// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// <p>Returns the objects or data listed below if successful. Otherwise, returns an error.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateTrailOutput {
    /// <p>Specifies the name of the trail.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>Specifies the name of the Amazon S3 bucket designated for publishing log files.</p>
    pub s3_bucket_name: std::option::Option<std::string::String>,
    /// <p>Specifies the Amazon S3 key prefix that comes after the name of the bucket you have designated for log file delivery. For more information, see <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/cloudtrail-find-log-files.html">Finding Your IAM Log Files</a>.</p>
    pub s3_key_prefix: std::option::Option<std::string::String>,
    /// <p>This field is no longer in use. Use <code>UpdateTrailResponse$SnsTopicARN</code>.</p>
    pub sns_topic_name: std::option::Option<std::string::String>,
    /// <p>Specifies the ARN of the Amazon SNS topic that CloudTrail uses to send notifications when log files are delivered. The following is the format of a topic ARN.</p>
    /// <p> <code>arn:aws:sns:us-east-2:123456789012:MyTopic</code> </p>
    pub sns_topic_arn: std::option::Option<std::string::String>,
    /// <p>Specifies whether the trail is publishing events from global services such as IAM to the log files.</p>
    pub include_global_service_events: std::option::Option<bool>,
    /// <p>Specifies whether the trail exists in one region or in all regions.</p>
    pub is_multi_region_trail: std::option::Option<bool>,
    /// <p>Specifies the ARN of the trail that was updated. The following is the format of a trail ARN.</p>
    /// <p> <code>arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail</code> </p>
    pub trail_arn: std::option::Option<std::string::String>,
    /// <p>Specifies whether log file integrity validation is enabled.</p>
    pub log_file_validation_enabled: std::option::Option<bool>,
    /// <p>Specifies the Amazon Resource Name (ARN) of the log group to which CloudTrail logs are delivered.</p>
    pub cloud_watch_logs_log_group_arn: std::option::Option<std::string::String>,
    /// <p>Specifies the role for the CloudWatch Logs endpoint to assume to write to a user's log group.</p>
    pub cloud_watch_logs_role_arn: std::option::Option<std::string::String>,
    /// <p>Specifies the KMS key ID that encrypts the logs delivered by CloudTrail. The value is a fully specified ARN to a KMS key in the following format.</p>
    /// <p> <code>arn:aws:kms:us-east-2:123456789012:key/12345678-1234-1234-1234-123456789012</code> </p>
    pub kms_key_id: std::option::Option<std::string::String>,
    /// <p>Specifies whether the trail is an organization trail.</p>
    pub is_organization_trail: std::option::Option<bool>,
}
impl UpdateTrailOutput {
    /// <p>Specifies the name of the trail.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>Specifies the name of the Amazon S3 bucket designated for publishing log files.</p>
    pub fn s3_bucket_name(&self) -> std::option::Option<&str> {
        self.s3_bucket_name.as_deref()
    }
    /// <p>Specifies the Amazon S3 key prefix that comes after the name of the bucket you have designated for log file delivery. For more information, see <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/cloudtrail-find-log-files.html">Finding Your IAM Log Files</a>.</p>
    pub fn s3_key_prefix(&self) -> std::option::Option<&str> {
        self.s3_key_prefix.as_deref()
    }
    /// <p>This field is no longer in use. Use <code>UpdateTrailResponse$SnsTopicARN</code>.</p>
    pub fn sns_topic_name(&self) -> std::option::Option<&str> {
        self.sns_topic_name.as_deref()
    }
    /// <p>Specifies the ARN of the Amazon SNS topic that CloudTrail uses to send notifications when log files are delivered. The following is the format of a topic ARN.</p>
    /// <p> <code>arn:aws:sns:us-east-2:123456789012:MyTopic</code> </p>
    pub fn sns_topic_arn(&self) -> std::option::Option<&str> {
        self.sns_topic_arn.as_deref()
    }
    /// <p>Specifies whether the trail is publishing events from global services such as IAM to the log files.</p>
    pub fn include_global_service_events(&self) -> std::option::Option<bool> {
        self.include_global_service_events
    }
    /// <p>Specifies whether the trail exists in one region or in all regions.</p>
    pub fn is_multi_region_trail(&self) -> std::option::Option<bool> {
        self.is_multi_region_trail
    }
    /// <p>Specifies the ARN of the trail that was updated. The following is the format of a trail ARN.</p>
    /// <p> <code>arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail</code> </p>
    pub fn trail_arn(&self) -> std::option::Option<&str> {
        self.trail_arn.as_deref()
    }
    /// <p>Specifies whether log file integrity validation is enabled.</p>
    pub fn log_file_validation_enabled(&self) -> std::option::Option<bool> {
        self.log_file_validation_enabled
    }
    /// <p>Specifies the Amazon Resource Name (ARN) of the log group to which CloudTrail logs are delivered.</p>
    pub fn cloud_watch_logs_log_group_arn(&self) -> std::option::Option<&str> {
        self.cloud_watch_logs_log_group_arn.as_deref()
    }
    /// <p>Specifies the role for the CloudWatch Logs endpoint to assume to write to a user's log group.</p>
    pub fn cloud_watch_logs_role_arn(&self) -> std::option::Option<&str> {
        self.cloud_watch_logs_role_arn.as_deref()
    }
    /// <p>Specifies the KMS key ID that encrypts the logs delivered by CloudTrail. The value is a fully specified ARN to a KMS key in the following format.</p>
    /// <p> <code>arn:aws:kms:us-east-2:123456789012:key/12345678-1234-1234-1234-123456789012</code> </p>
    pub fn kms_key_id(&self) -> std::option::Option<&str> {
        self.kms_key_id.as_deref()
    }
    /// <p>Specifies whether the trail is an organization trail.</p>
    pub fn is_organization_trail(&self) -> std::option::Option<bool> {
        self.is_organization_trail
    }
}
impl std::fmt::Debug for UpdateTrailOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateTrailOutput");
        formatter.field("name", &self.name);
        formatter.field("s3_bucket_name", &self.s3_bucket_name);
        formatter.field("s3_key_prefix", &self.s3_key_prefix);
        formatter.field("sns_topic_name", &self.sns_topic_name);
        formatter.field("sns_topic_arn", &self.sns_topic_arn);
        formatter.field(
            "include_global_service_events",
            &self.include_global_service_events,
        );
        formatter.field("is_multi_region_trail", &self.is_multi_region_trail);
        formatter.field("trail_arn", &self.trail_arn);
        formatter.field(
            "log_file_validation_enabled",
            &self.log_file_validation_enabled,
        );
        formatter.field(
            "cloud_watch_logs_log_group_arn",
            &self.cloud_watch_logs_log_group_arn,
        );
        formatter.field("cloud_watch_logs_role_arn", &self.cloud_watch_logs_role_arn);
        formatter.field("kms_key_id", &self.kms_key_id);
        formatter.field("is_organization_trail", &self.is_organization_trail);
        formatter.finish()
    }
}
/// See [`UpdateTrailOutput`](crate::output::UpdateTrailOutput)
pub mod update_trail_output {
    /// A builder for [`UpdateTrailOutput`](crate::output::UpdateTrailOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) s3_bucket_name: std::option::Option<std::string::String>,
        pub(crate) s3_key_prefix: std::option::Option<std::string::String>,
        pub(crate) sns_topic_name: std::option::Option<std::string::String>,
        pub(crate) sns_topic_arn: std::option::Option<std::string::String>,
        pub(crate) include_global_service_events: std::option::Option<bool>,
        pub(crate) is_multi_region_trail: std::option::Option<bool>,
        pub(crate) trail_arn: std::option::Option<std::string::String>,
        pub(crate) log_file_validation_enabled: std::option::Option<bool>,
        pub(crate) cloud_watch_logs_log_group_arn: std::option::Option<std::string::String>,
        pub(crate) cloud_watch_logs_role_arn: std::option::Option<std::string::String>,
        pub(crate) kms_key_id: std::option::Option<std::string::String>,
        pub(crate) is_organization_trail: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>Specifies the name of the trail.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>Specifies the name of the trail.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>Specifies the name of the Amazon S3 bucket designated for publishing log files.</p>
        pub fn s3_bucket_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.s3_bucket_name = Some(input.into());
            self
        }
        /// <p>Specifies the name of the Amazon S3 bucket designated for publishing log files.</p>
        pub fn set_s3_bucket_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.s3_bucket_name = input;
            self
        }
        /// <p>Specifies the Amazon S3 key prefix that comes after the name of the bucket you have designated for log file delivery. For more information, see <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/cloudtrail-find-log-files.html">Finding Your IAM Log Files</a>.</p>
        pub fn s3_key_prefix(mut self, input: impl Into<std::string::String>) -> Self {
            self.s3_key_prefix = Some(input.into());
            self
        }
        /// <p>Specifies the Amazon S3 key prefix that comes after the name of the bucket you have designated for log file delivery. For more information, see <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/cloudtrail-find-log-files.html">Finding Your IAM Log Files</a>.</p>
        pub fn set_s3_key_prefix(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.s3_key_prefix = input;
            self
        }
        /// <p>This field is no longer in use. Use <code>UpdateTrailResponse$SnsTopicARN</code>.</p>
        pub fn sns_topic_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.sns_topic_name = Some(input.into());
            self
        }
        /// <p>This field is no longer in use. Use <code>UpdateTrailResponse$SnsTopicARN</code>.</p>
        pub fn set_sns_topic_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.sns_topic_name = input;
            self
        }
        /// <p>Specifies the ARN of the Amazon SNS topic that CloudTrail uses to send notifications when log files are delivered. The following is the format of a topic ARN.</p>
        /// <p> <code>arn:aws:sns:us-east-2:123456789012:MyTopic</code> </p>
        pub fn sns_topic_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.sns_topic_arn = Some(input.into());
            self
        }
        /// <p>Specifies the ARN of the Amazon SNS topic that CloudTrail uses to send notifications when log files are delivered. The following is the format of a topic ARN.</p>
        /// <p> <code>arn:aws:sns:us-east-2:123456789012:MyTopic</code> </p>
        pub fn set_sns_topic_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.sns_topic_arn = input;
            self
        }
        /// <p>Specifies whether the trail is publishing events from global services such as IAM to the log files.</p>
        pub fn include_global_service_events(mut self, input: bool) -> Self {
            self.include_global_service_events = Some(input);
            self
        }
        /// <p>Specifies whether the trail is publishing events from global services such as IAM to the log files.</p>
        pub fn set_include_global_service_events(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.include_global_service_events = input;
            self
        }
        /// <p>Specifies whether the trail exists in one region or in all regions.</p>
        pub fn is_multi_region_trail(mut self, input: bool) -> Self {
            self.is_multi_region_trail = Some(input);
            self
        }
        /// <p>Specifies whether the trail exists in one region or in all regions.</p>
        pub fn set_is_multi_region_trail(mut self, input: std::option::Option<bool>) -> Self {
            self.is_multi_region_trail = input;
            self
        }
        /// <p>Specifies the ARN of the trail that was updated. The following is the format of a trail ARN.</p>
        /// <p> <code>arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail</code> </p>
        pub fn trail_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.trail_arn = Some(input.into());
            self
        }
        /// <p>Specifies the ARN of the trail that was updated. The following is the format of a trail ARN.</p>
        /// <p> <code>arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail</code> </p>
        pub fn set_trail_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.trail_arn = input;
            self
        }
        /// <p>Specifies whether log file integrity validation is enabled.</p>
        pub fn log_file_validation_enabled(mut self, input: bool) -> Self {
            self.log_file_validation_enabled = Some(input);
            self
        }
        /// <p>Specifies whether log file integrity validation is enabled.</p>
        pub fn set_log_file_validation_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.log_file_validation_enabled = input;
            self
        }
        /// <p>Specifies the Amazon Resource Name (ARN) of the log group to which CloudTrail logs are delivered.</p>
        pub fn cloud_watch_logs_log_group_arn(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.cloud_watch_logs_log_group_arn = Some(input.into());
            self
        }
        /// <p>Specifies the Amazon Resource Name (ARN) of the log group to which CloudTrail logs are delivered.</p>
        pub fn set_cloud_watch_logs_log_group_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.cloud_watch_logs_log_group_arn = input;
            self
        }
        /// <p>Specifies the role for the CloudWatch Logs endpoint to assume to write to a user's log group.</p>
        pub fn cloud_watch_logs_role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.cloud_watch_logs_role_arn = Some(input.into());
            self
        }
        /// <p>Specifies the role for the CloudWatch Logs endpoint to assume to write to a user's log group.</p>
        pub fn set_cloud_watch_logs_role_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.cloud_watch_logs_role_arn = input;
            self
        }
        /// <p>Specifies the KMS key ID that encrypts the logs delivered by CloudTrail. The value is a fully specified ARN to a KMS key in the following format.</p>
        /// <p> <code>arn:aws:kms:us-east-2:123456789012:key/12345678-1234-1234-1234-123456789012</code> </p>
        pub fn kms_key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.kms_key_id = Some(input.into());
            self
        }
        /// <p>Specifies the KMS key ID that encrypts the logs delivered by CloudTrail. The value is a fully specified ARN to a KMS key in the following format.</p>
        /// <p> <code>arn:aws:kms:us-east-2:123456789012:key/12345678-1234-1234-1234-123456789012</code> </p>
        pub fn set_kms_key_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.kms_key_id = input;
            self
        }
        /// <p>Specifies whether the trail is an organization trail.</p>
        pub fn is_organization_trail(mut self, input: bool) -> Self {
            self.is_organization_trail = Some(input);
            self
        }
        /// <p>Specifies whether the trail is an organization trail.</p>
        pub fn set_is_organization_trail(mut self, input: std::option::Option<bool>) -> Self {
            self.is_organization_trail = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateTrailOutput`](crate::output::UpdateTrailOutput)
        pub fn build(self) -> crate::output::UpdateTrailOutput {
            crate::output::UpdateTrailOutput {
                name: self.name,
                s3_bucket_name: self.s3_bucket_name,
                s3_key_prefix: self.s3_key_prefix,
                sns_topic_name: self.sns_topic_name,
                sns_topic_arn: self.sns_topic_arn,
                include_global_service_events: self.include_global_service_events,
                is_multi_region_trail: self.is_multi_region_trail,
                trail_arn: self.trail_arn,
                log_file_validation_enabled: self.log_file_validation_enabled,
                cloud_watch_logs_log_group_arn: self.cloud_watch_logs_log_group_arn,
                cloud_watch_logs_role_arn: self.cloud_watch_logs_role_arn,
                kms_key_id: self.kms_key_id,
                is_organization_trail: self.is_organization_trail,
            }
        }
    }
}
impl UpdateTrailOutput {
    /// Creates a new builder-style object to manufacture [`UpdateTrailOutput`](crate::output::UpdateTrailOutput)
    pub fn builder() -> crate::output::update_trail_output::Builder {
        crate::output::update_trail_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateEventDataStoreOutput {
    /// <p>The ARN of the event data store.</p>
    pub event_data_store_arn: std::option::Option<std::string::String>,
    /// <p>The name of the event data store.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The status of an event data store. Values can be <code>ENABLED</code> and <code>PENDING_DELETION</code>.</p>
    pub status: std::option::Option<crate::model::EventDataStoreStatus>,
    /// <p>The advanced event selectors that are applied to the event data store.</p>
    pub advanced_event_selectors:
        std::option::Option<std::vec::Vec<crate::model::AdvancedEventSelector>>,
    /// <p>Indicates whether the event data store includes events from all regions, or only from the region in which it was created.</p>
    pub multi_region_enabled: std::option::Option<bool>,
    /// <p>Indicates whether an event data store is collecting logged events for an organization in Organizations.</p>
    pub organization_enabled: std::option::Option<bool>,
    /// <p>The retention period, in days.</p>
    pub retention_period: std::option::Option<i32>,
    /// <p>Indicates whether termination protection is enabled for the event data store.</p>
    pub termination_protection_enabled: std::option::Option<bool>,
    /// <p>The timestamp that shows when an event data store was first created.</p>
    pub created_timestamp: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The timestamp that shows when the event data store was last updated. <code>UpdatedTimestamp</code> is always either the same or newer than the time shown in <code>CreatedTimestamp</code>.</p>
    pub updated_timestamp: std::option::Option<aws_smithy_types::DateTime>,
}
impl UpdateEventDataStoreOutput {
    /// <p>The ARN of the event data store.</p>
    pub fn event_data_store_arn(&self) -> std::option::Option<&str> {
        self.event_data_store_arn.as_deref()
    }
    /// <p>The name of the event data store.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The status of an event data store. Values can be <code>ENABLED</code> and <code>PENDING_DELETION</code>.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::EventDataStoreStatus> {
        self.status.as_ref()
    }
    /// <p>The advanced event selectors that are applied to the event data store.</p>
    pub fn advanced_event_selectors(
        &self,
    ) -> std::option::Option<&[crate::model::AdvancedEventSelector]> {
        self.advanced_event_selectors.as_deref()
    }
    /// <p>Indicates whether the event data store includes events from all regions, or only from the region in which it was created.</p>
    pub fn multi_region_enabled(&self) -> std::option::Option<bool> {
        self.multi_region_enabled
    }
    /// <p>Indicates whether an event data store is collecting logged events for an organization in Organizations.</p>
    pub fn organization_enabled(&self) -> std::option::Option<bool> {
        self.organization_enabled
    }
    /// <p>The retention period, in days.</p>
    pub fn retention_period(&self) -> std::option::Option<i32> {
        self.retention_period
    }
    /// <p>Indicates whether termination protection is enabled for the event data store.</p>
    pub fn termination_protection_enabled(&self) -> std::option::Option<bool> {
        self.termination_protection_enabled
    }
    /// <p>The timestamp that shows when an event data store was first created.</p>
    pub fn created_timestamp(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.created_timestamp.as_ref()
    }
    /// <p>The timestamp that shows when the event data store was last updated. <code>UpdatedTimestamp</code> is always either the same or newer than the time shown in <code>CreatedTimestamp</code>.</p>
    pub fn updated_timestamp(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.updated_timestamp.as_ref()
    }
}
impl std::fmt::Debug for UpdateEventDataStoreOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateEventDataStoreOutput");
        formatter.field("event_data_store_arn", &self.event_data_store_arn);
        formatter.field("name", &self.name);
        formatter.field("status", &self.status);
        formatter.field("advanced_event_selectors", &self.advanced_event_selectors);
        formatter.field("multi_region_enabled", &self.multi_region_enabled);
        formatter.field("organization_enabled", &self.organization_enabled);
        formatter.field("retention_period", &self.retention_period);
        formatter.field(
            "termination_protection_enabled",
            &self.termination_protection_enabled,
        );
        formatter.field("created_timestamp", &self.created_timestamp);
        formatter.field("updated_timestamp", &self.updated_timestamp);
        formatter.finish()
    }
}
/// See [`UpdateEventDataStoreOutput`](crate::output::UpdateEventDataStoreOutput)
pub mod update_event_data_store_output {
    /// A builder for [`UpdateEventDataStoreOutput`](crate::output::UpdateEventDataStoreOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) event_data_store_arn: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::EventDataStoreStatus>,
        pub(crate) advanced_event_selectors:
            std::option::Option<std::vec::Vec<crate::model::AdvancedEventSelector>>,
        pub(crate) multi_region_enabled: std::option::Option<bool>,
        pub(crate) organization_enabled: std::option::Option<bool>,
        pub(crate) retention_period: std::option::Option<i32>,
        pub(crate) termination_protection_enabled: std::option::Option<bool>,
        pub(crate) created_timestamp: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) updated_timestamp: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The ARN of the event data store.</p>
        pub fn event_data_store_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.event_data_store_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the event data store.</p>
        pub fn set_event_data_store_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.event_data_store_arn = input;
            self
        }
        /// <p>The name of the event data store.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the event data store.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The status of an event data store. Values can be <code>ENABLED</code> and <code>PENDING_DELETION</code>.</p>
        pub fn status(mut self, input: crate::model::EventDataStoreStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of an event data store. Values can be <code>ENABLED</code> and <code>PENDING_DELETION</code>.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::EventDataStoreStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// Appends an item to `advanced_event_selectors`.
        ///
        /// To override the contents of this collection use [`set_advanced_event_selectors`](Self::set_advanced_event_selectors).
        ///
        /// <p>The advanced event selectors that are applied to the event data store.</p>
        pub fn advanced_event_selectors(
            mut self,
            input: crate::model::AdvancedEventSelector,
        ) -> Self {
            let mut v = self.advanced_event_selectors.unwrap_or_default();
            v.push(input);
            self.advanced_event_selectors = Some(v);
            self
        }
        /// <p>The advanced event selectors that are applied to the event data store.</p>
        pub fn set_advanced_event_selectors(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AdvancedEventSelector>>,
        ) -> Self {
            self.advanced_event_selectors = input;
            self
        }
        /// <p>Indicates whether the event data store includes events from all regions, or only from the region in which it was created.</p>
        pub fn multi_region_enabled(mut self, input: bool) -> Self {
            self.multi_region_enabled = Some(input);
            self
        }
        /// <p>Indicates whether the event data store includes events from all regions, or only from the region in which it was created.</p>
        pub fn set_multi_region_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.multi_region_enabled = input;
            self
        }
        /// <p>Indicates whether an event data store is collecting logged events for an organization in Organizations.</p>
        pub fn organization_enabled(mut self, input: bool) -> Self {
            self.organization_enabled = Some(input);
            self
        }
        /// <p>Indicates whether an event data store is collecting logged events for an organization in Organizations.</p>
        pub fn set_organization_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.organization_enabled = input;
            self
        }
        /// <p>The retention period, in days.</p>
        pub fn retention_period(mut self, input: i32) -> Self {
            self.retention_period = Some(input);
            self
        }
        /// <p>The retention period, in days.</p>
        pub fn set_retention_period(mut self, input: std::option::Option<i32>) -> Self {
            self.retention_period = input;
            self
        }
        /// <p>Indicates whether termination protection is enabled for the event data store.</p>
        pub fn termination_protection_enabled(mut self, input: bool) -> Self {
            self.termination_protection_enabled = Some(input);
            self
        }
        /// <p>Indicates whether termination protection is enabled for the event data store.</p>
        pub fn set_termination_protection_enabled(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.termination_protection_enabled = input;
            self
        }
        /// <p>The timestamp that shows when an event data store was first created.</p>
        pub fn created_timestamp(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.created_timestamp = Some(input);
            self
        }
        /// <p>The timestamp that shows when an event data store was first created.</p>
        pub fn set_created_timestamp(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.created_timestamp = input;
            self
        }
        /// <p>The timestamp that shows when the event data store was last updated. <code>UpdatedTimestamp</code> is always either the same or newer than the time shown in <code>CreatedTimestamp</code>.</p>
        pub fn updated_timestamp(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.updated_timestamp = Some(input);
            self
        }
        /// <p>The timestamp that shows when the event data store was last updated. <code>UpdatedTimestamp</code> is always either the same or newer than the time shown in <code>CreatedTimestamp</code>.</p>
        pub fn set_updated_timestamp(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.updated_timestamp = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateEventDataStoreOutput`](crate::output::UpdateEventDataStoreOutput)
        pub fn build(self) -> crate::output::UpdateEventDataStoreOutput {
            crate::output::UpdateEventDataStoreOutput {
                event_data_store_arn: self.event_data_store_arn,
                name: self.name,
                status: self.status,
                advanced_event_selectors: self.advanced_event_selectors,
                multi_region_enabled: self.multi_region_enabled,
                organization_enabled: self.organization_enabled,
                retention_period: self.retention_period,
                termination_protection_enabled: self.termination_protection_enabled,
                created_timestamp: self.created_timestamp,
                updated_timestamp: self.updated_timestamp,
            }
        }
    }
}
impl UpdateEventDataStoreOutput {
    /// Creates a new builder-style object to manufacture [`UpdateEventDataStoreOutput`](crate::output::UpdateEventDataStoreOutput)
    pub fn builder() -> crate::output::update_event_data_store_output::Builder {
        crate::output::update_event_data_store_output::Builder::default()
    }
}

/// <p>Returns the objects or data listed below if successful. Otherwise, returns an error.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StopLoggingOutput {}
impl std::fmt::Debug for StopLoggingOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StopLoggingOutput");
        formatter.finish()
    }
}
/// See [`StopLoggingOutput`](crate::output::StopLoggingOutput)
pub mod stop_logging_output {
    /// A builder for [`StopLoggingOutput`](crate::output::StopLoggingOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`StopLoggingOutput`](crate::output::StopLoggingOutput)
        pub fn build(self) -> crate::output::StopLoggingOutput {
            crate::output::StopLoggingOutput {}
        }
    }
}
impl StopLoggingOutput {
    /// Creates a new builder-style object to manufacture [`StopLoggingOutput`](crate::output::StopLoggingOutput)
    pub fn builder() -> crate::output::stop_logging_output::Builder {
        crate::output::stop_logging_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StartQueryOutput {
    /// <p>The ID of the started query.</p>
    pub query_id: std::option::Option<std::string::String>,
}
impl StartQueryOutput {
    /// <p>The ID of the started query.</p>
    pub fn query_id(&self) -> std::option::Option<&str> {
        self.query_id.as_deref()
    }
}
impl std::fmt::Debug for StartQueryOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StartQueryOutput");
        formatter.field("query_id", &self.query_id);
        formatter.finish()
    }
}
/// See [`StartQueryOutput`](crate::output::StartQueryOutput)
pub mod start_query_output {
    /// A builder for [`StartQueryOutput`](crate::output::StartQueryOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) query_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the started query.</p>
        pub fn query_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.query_id = Some(input.into());
            self
        }
        /// <p>The ID of the started query.</p>
        pub fn set_query_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.query_id = input;
            self
        }
        /// Consumes the builder and constructs a [`StartQueryOutput`](crate::output::StartQueryOutput)
        pub fn build(self) -> crate::output::StartQueryOutput {
            crate::output::StartQueryOutput {
                query_id: self.query_id,
            }
        }
    }
}
impl StartQueryOutput {
    /// Creates a new builder-style object to manufacture [`StartQueryOutput`](crate::output::StartQueryOutput)
    pub fn builder() -> crate::output::start_query_output::Builder {
        crate::output::start_query_output::Builder::default()
    }
}

/// <p>Returns the objects or data listed below if successful. Otherwise, returns an error.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StartLoggingOutput {}
impl std::fmt::Debug for StartLoggingOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StartLoggingOutput");
        formatter.finish()
    }
}
/// See [`StartLoggingOutput`](crate::output::StartLoggingOutput)
pub mod start_logging_output {
    /// A builder for [`StartLoggingOutput`](crate::output::StartLoggingOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`StartLoggingOutput`](crate::output::StartLoggingOutput)
        pub fn build(self) -> crate::output::StartLoggingOutput {
            crate::output::StartLoggingOutput {}
        }
    }
}
impl StartLoggingOutput {
    /// Creates a new builder-style object to manufacture [`StartLoggingOutput`](crate::output::StartLoggingOutput)
    pub fn builder() -> crate::output::start_logging_output::Builder {
        crate::output::start_logging_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RestoreEventDataStoreOutput {
    /// <p>The event data store ARN.</p>
    pub event_data_store_arn: std::option::Option<std::string::String>,
    /// <p>The name of the event data store.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The status of the event data store.</p>
    pub status: std::option::Option<crate::model::EventDataStoreStatus>,
    /// <p>The advanced event selectors that were used to select events.</p>
    pub advanced_event_selectors:
        std::option::Option<std::vec::Vec<crate::model::AdvancedEventSelector>>,
    /// <p>Indicates whether the event data store is collecting events from all regions, or only from the region in which the event data store was created.</p>
    pub multi_region_enabled: std::option::Option<bool>,
    /// <p>Indicates whether an event data store is collecting logged events for an organization in Organizations.</p>
    pub organization_enabled: std::option::Option<bool>,
    /// <p>The retention period, in days.</p>
    pub retention_period: std::option::Option<i32>,
    /// <p>Indicates that termination protection is enabled and the event data store cannot be automatically deleted.</p>
    pub termination_protection_enabled: std::option::Option<bool>,
    /// <p>The timestamp of an event data store's creation.</p>
    pub created_timestamp: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The timestamp that shows when an event data store was updated, if applicable. <code>UpdatedTimestamp</code> is always either the same or newer than the time shown in <code>CreatedTimestamp</code>.</p>
    pub updated_timestamp: std::option::Option<aws_smithy_types::DateTime>,
}
impl RestoreEventDataStoreOutput {
    /// <p>The event data store ARN.</p>
    pub fn event_data_store_arn(&self) -> std::option::Option<&str> {
        self.event_data_store_arn.as_deref()
    }
    /// <p>The name of the event data store.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The status of the event data store.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::EventDataStoreStatus> {
        self.status.as_ref()
    }
    /// <p>The advanced event selectors that were used to select events.</p>
    pub fn advanced_event_selectors(
        &self,
    ) -> std::option::Option<&[crate::model::AdvancedEventSelector]> {
        self.advanced_event_selectors.as_deref()
    }
    /// <p>Indicates whether the event data store is collecting events from all regions, or only from the region in which the event data store was created.</p>
    pub fn multi_region_enabled(&self) -> std::option::Option<bool> {
        self.multi_region_enabled
    }
    /// <p>Indicates whether an event data store is collecting logged events for an organization in Organizations.</p>
    pub fn organization_enabled(&self) -> std::option::Option<bool> {
        self.organization_enabled
    }
    /// <p>The retention period, in days.</p>
    pub fn retention_period(&self) -> std::option::Option<i32> {
        self.retention_period
    }
    /// <p>Indicates that termination protection is enabled and the event data store cannot be automatically deleted.</p>
    pub fn termination_protection_enabled(&self) -> std::option::Option<bool> {
        self.termination_protection_enabled
    }
    /// <p>The timestamp of an event data store's creation.</p>
    pub fn created_timestamp(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.created_timestamp.as_ref()
    }
    /// <p>The timestamp that shows when an event data store was updated, if applicable. <code>UpdatedTimestamp</code> is always either the same or newer than the time shown in <code>CreatedTimestamp</code>.</p>
    pub fn updated_timestamp(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.updated_timestamp.as_ref()
    }
}
impl std::fmt::Debug for RestoreEventDataStoreOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RestoreEventDataStoreOutput");
        formatter.field("event_data_store_arn", &self.event_data_store_arn);
        formatter.field("name", &self.name);
        formatter.field("status", &self.status);
        formatter.field("advanced_event_selectors", &self.advanced_event_selectors);
        formatter.field("multi_region_enabled", &self.multi_region_enabled);
        formatter.field("organization_enabled", &self.organization_enabled);
        formatter.field("retention_period", &self.retention_period);
        formatter.field(
            "termination_protection_enabled",
            &self.termination_protection_enabled,
        );
        formatter.field("created_timestamp", &self.created_timestamp);
        formatter.field("updated_timestamp", &self.updated_timestamp);
        formatter.finish()
    }
}
/// See [`RestoreEventDataStoreOutput`](crate::output::RestoreEventDataStoreOutput)
pub mod restore_event_data_store_output {
    /// A builder for [`RestoreEventDataStoreOutput`](crate::output::RestoreEventDataStoreOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) event_data_store_arn: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::EventDataStoreStatus>,
        pub(crate) advanced_event_selectors:
            std::option::Option<std::vec::Vec<crate::model::AdvancedEventSelector>>,
        pub(crate) multi_region_enabled: std::option::Option<bool>,
        pub(crate) organization_enabled: std::option::Option<bool>,
        pub(crate) retention_period: std::option::Option<i32>,
        pub(crate) termination_protection_enabled: std::option::Option<bool>,
        pub(crate) created_timestamp: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) updated_timestamp: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The event data store ARN.</p>
        pub fn event_data_store_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.event_data_store_arn = Some(input.into());
            self
        }
        /// <p>The event data store ARN.</p>
        pub fn set_event_data_store_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.event_data_store_arn = input;
            self
        }
        /// <p>The name of the event data store.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the event data store.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The status of the event data store.</p>
        pub fn status(mut self, input: crate::model::EventDataStoreStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of the event data store.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::EventDataStoreStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// Appends an item to `advanced_event_selectors`.
        ///
        /// To override the contents of this collection use [`set_advanced_event_selectors`](Self::set_advanced_event_selectors).
        ///
        /// <p>The advanced event selectors that were used to select events.</p>
        pub fn advanced_event_selectors(
            mut self,
            input: crate::model::AdvancedEventSelector,
        ) -> Self {
            let mut v = self.advanced_event_selectors.unwrap_or_default();
            v.push(input);
            self.advanced_event_selectors = Some(v);
            self
        }
        /// <p>The advanced event selectors that were used to select events.</p>
        pub fn set_advanced_event_selectors(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AdvancedEventSelector>>,
        ) -> Self {
            self.advanced_event_selectors = input;
            self
        }
        /// <p>Indicates whether the event data store is collecting events from all regions, or only from the region in which the event data store was created.</p>
        pub fn multi_region_enabled(mut self, input: bool) -> Self {
            self.multi_region_enabled = Some(input);
            self
        }
        /// <p>Indicates whether the event data store is collecting events from all regions, or only from the region in which the event data store was created.</p>
        pub fn set_multi_region_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.multi_region_enabled = input;
            self
        }
        /// <p>Indicates whether an event data store is collecting logged events for an organization in Organizations.</p>
        pub fn organization_enabled(mut self, input: bool) -> Self {
            self.organization_enabled = Some(input);
            self
        }
        /// <p>Indicates whether an event data store is collecting logged events for an organization in Organizations.</p>
        pub fn set_organization_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.organization_enabled = input;
            self
        }
        /// <p>The retention period, in days.</p>
        pub fn retention_period(mut self, input: i32) -> Self {
            self.retention_period = Some(input);
            self
        }
        /// <p>The retention period, in days.</p>
        pub fn set_retention_period(mut self, input: std::option::Option<i32>) -> Self {
            self.retention_period = input;
            self
        }
        /// <p>Indicates that termination protection is enabled and the event data store cannot be automatically deleted.</p>
        pub fn termination_protection_enabled(mut self, input: bool) -> Self {
            self.termination_protection_enabled = Some(input);
            self
        }
        /// <p>Indicates that termination protection is enabled and the event data store cannot be automatically deleted.</p>
        pub fn set_termination_protection_enabled(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.termination_protection_enabled = input;
            self
        }
        /// <p>The timestamp of an event data store's creation.</p>
        pub fn created_timestamp(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.created_timestamp = Some(input);
            self
        }
        /// <p>The timestamp of an event data store's creation.</p>
        pub fn set_created_timestamp(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.created_timestamp = input;
            self
        }
        /// <p>The timestamp that shows when an event data store was updated, if applicable. <code>UpdatedTimestamp</code> is always either the same or newer than the time shown in <code>CreatedTimestamp</code>.</p>
        pub fn updated_timestamp(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.updated_timestamp = Some(input);
            self
        }
        /// <p>The timestamp that shows when an event data store was updated, if applicable. <code>UpdatedTimestamp</code> is always either the same or newer than the time shown in <code>CreatedTimestamp</code>.</p>
        pub fn set_updated_timestamp(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.updated_timestamp = input;
            self
        }
        /// Consumes the builder and constructs a [`RestoreEventDataStoreOutput`](crate::output::RestoreEventDataStoreOutput)
        pub fn build(self) -> crate::output::RestoreEventDataStoreOutput {
            crate::output::RestoreEventDataStoreOutput {
                event_data_store_arn: self.event_data_store_arn,
                name: self.name,
                status: self.status,
                advanced_event_selectors: self.advanced_event_selectors,
                multi_region_enabled: self.multi_region_enabled,
                organization_enabled: self.organization_enabled,
                retention_period: self.retention_period,
                termination_protection_enabled: self.termination_protection_enabled,
                created_timestamp: self.created_timestamp,
                updated_timestamp: self.updated_timestamp,
            }
        }
    }
}
impl RestoreEventDataStoreOutput {
    /// Creates a new builder-style object to manufacture [`RestoreEventDataStoreOutput`](crate::output::RestoreEventDataStoreOutput)
    pub fn builder() -> crate::output::restore_event_data_store_output::Builder {
        crate::output::restore_event_data_store_output::Builder::default()
    }
}

/// <p>Returns the objects or data listed below if successful. Otherwise, returns an error.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RemoveTagsOutput {}
impl std::fmt::Debug for RemoveTagsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RemoveTagsOutput");
        formatter.finish()
    }
}
/// See [`RemoveTagsOutput`](crate::output::RemoveTagsOutput)
pub mod remove_tags_output {
    /// A builder for [`RemoveTagsOutput`](crate::output::RemoveTagsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`RemoveTagsOutput`](crate::output::RemoveTagsOutput)
        pub fn build(self) -> crate::output::RemoveTagsOutput {
            crate::output::RemoveTagsOutput {}
        }
    }
}
impl RemoveTagsOutput {
    /// Creates a new builder-style object to manufacture [`RemoveTagsOutput`](crate::output::RemoveTagsOutput)
    pub fn builder() -> crate::output::remove_tags_output::Builder {
        crate::output::remove_tags_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutInsightSelectorsOutput {
    /// <p>The Amazon Resource Name (ARN) of a trail for which you want to change or add Insights selectors.</p>
    pub trail_arn: std::option::Option<std::string::String>,
    /// <p>A JSON string that contains the Insights event types that you want to log on a trail. The valid Insights types in this release are <code>ApiErrorRateInsight</code> and <code>ApiCallRateInsight</code>.</p>
    pub insight_selectors: std::option::Option<std::vec::Vec<crate::model::InsightSelector>>,
}
impl PutInsightSelectorsOutput {
    /// <p>The Amazon Resource Name (ARN) of a trail for which you want to change or add Insights selectors.</p>
    pub fn trail_arn(&self) -> std::option::Option<&str> {
        self.trail_arn.as_deref()
    }
    /// <p>A JSON string that contains the Insights event types that you want to log on a trail. The valid Insights types in this release are <code>ApiErrorRateInsight</code> and <code>ApiCallRateInsight</code>.</p>
    pub fn insight_selectors(&self) -> std::option::Option<&[crate::model::InsightSelector]> {
        self.insight_selectors.as_deref()
    }
}
impl std::fmt::Debug for PutInsightSelectorsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutInsightSelectorsOutput");
        formatter.field("trail_arn", &self.trail_arn);
        formatter.field("insight_selectors", &self.insight_selectors);
        formatter.finish()
    }
}
/// See [`PutInsightSelectorsOutput`](crate::output::PutInsightSelectorsOutput)
pub mod put_insight_selectors_output {
    /// A builder for [`PutInsightSelectorsOutput`](crate::output::PutInsightSelectorsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) trail_arn: std::option::Option<std::string::String>,
        pub(crate) insight_selectors:
            std::option::Option<std::vec::Vec<crate::model::InsightSelector>>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of a trail for which you want to change or add Insights selectors.</p>
        pub fn trail_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.trail_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of a trail for which you want to change or add Insights selectors.</p>
        pub fn set_trail_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.trail_arn = input;
            self
        }
        /// Appends an item to `insight_selectors`.
        ///
        /// To override the contents of this collection use [`set_insight_selectors`](Self::set_insight_selectors).
        ///
        /// <p>A JSON string that contains the Insights event types that you want to log on a trail. The valid Insights types in this release are <code>ApiErrorRateInsight</code> and <code>ApiCallRateInsight</code>.</p>
        pub fn insight_selectors(mut self, input: crate::model::InsightSelector) -> Self {
            let mut v = self.insight_selectors.unwrap_or_default();
            v.push(input);
            self.insight_selectors = Some(v);
            self
        }
        /// <p>A JSON string that contains the Insights event types that you want to log on a trail. The valid Insights types in this release are <code>ApiErrorRateInsight</code> and <code>ApiCallRateInsight</code>.</p>
        pub fn set_insight_selectors(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::InsightSelector>>,
        ) -> Self {
            self.insight_selectors = input;
            self
        }
        /// Consumes the builder and constructs a [`PutInsightSelectorsOutput`](crate::output::PutInsightSelectorsOutput)
        pub fn build(self) -> crate::output::PutInsightSelectorsOutput {
            crate::output::PutInsightSelectorsOutput {
                trail_arn: self.trail_arn,
                insight_selectors: self.insight_selectors,
            }
        }
    }
}
impl PutInsightSelectorsOutput {
    /// Creates a new builder-style object to manufacture [`PutInsightSelectorsOutput`](crate::output::PutInsightSelectorsOutput)
    pub fn builder() -> crate::output::put_insight_selectors_output::Builder {
        crate::output::put_insight_selectors_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutEventSelectorsOutput {
    /// <p>Specifies the ARN of the trail that was updated with event selectors. The following is the format of a trail ARN.</p>
    /// <p> <code>arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail</code> </p>
    pub trail_arn: std::option::Option<std::string::String>,
    /// <p>Specifies the event selectors configured for your trail.</p>
    pub event_selectors: std::option::Option<std::vec::Vec<crate::model::EventSelector>>,
    /// <p>Specifies the advanced event selectors configured for your trail.</p>
    pub advanced_event_selectors:
        std::option::Option<std::vec::Vec<crate::model::AdvancedEventSelector>>,
}
impl PutEventSelectorsOutput {
    /// <p>Specifies the ARN of the trail that was updated with event selectors. The following is the format of a trail ARN.</p>
    /// <p> <code>arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail</code> </p>
    pub fn trail_arn(&self) -> std::option::Option<&str> {
        self.trail_arn.as_deref()
    }
    /// <p>Specifies the event selectors configured for your trail.</p>
    pub fn event_selectors(&self) -> std::option::Option<&[crate::model::EventSelector]> {
        self.event_selectors.as_deref()
    }
    /// <p>Specifies the advanced event selectors configured for your trail.</p>
    pub fn advanced_event_selectors(
        &self,
    ) -> std::option::Option<&[crate::model::AdvancedEventSelector]> {
        self.advanced_event_selectors.as_deref()
    }
}
impl std::fmt::Debug for PutEventSelectorsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutEventSelectorsOutput");
        formatter.field("trail_arn", &self.trail_arn);
        formatter.field("event_selectors", &self.event_selectors);
        formatter.field("advanced_event_selectors", &self.advanced_event_selectors);
        formatter.finish()
    }
}
/// See [`PutEventSelectorsOutput`](crate::output::PutEventSelectorsOutput)
pub mod put_event_selectors_output {
    /// A builder for [`PutEventSelectorsOutput`](crate::output::PutEventSelectorsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) trail_arn: std::option::Option<std::string::String>,
        pub(crate) event_selectors: std::option::Option<std::vec::Vec<crate::model::EventSelector>>,
        pub(crate) advanced_event_selectors:
            std::option::Option<std::vec::Vec<crate::model::AdvancedEventSelector>>,
    }
    impl Builder {
        /// <p>Specifies the ARN of the trail that was updated with event selectors. The following is the format of a trail ARN.</p>
        /// <p> <code>arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail</code> </p>
        pub fn trail_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.trail_arn = Some(input.into());
            self
        }
        /// <p>Specifies the ARN of the trail that was updated with event selectors. The following is the format of a trail ARN.</p>
        /// <p> <code>arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail</code> </p>
        pub fn set_trail_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.trail_arn = input;
            self
        }
        /// Appends an item to `event_selectors`.
        ///
        /// To override the contents of this collection use [`set_event_selectors`](Self::set_event_selectors).
        ///
        /// <p>Specifies the event selectors configured for your trail.</p>
        pub fn event_selectors(mut self, input: crate::model::EventSelector) -> Self {
            let mut v = self.event_selectors.unwrap_or_default();
            v.push(input);
            self.event_selectors = Some(v);
            self
        }
        /// <p>Specifies the event selectors configured for your trail.</p>
        pub fn set_event_selectors(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::EventSelector>>,
        ) -> Self {
            self.event_selectors = input;
            self
        }
        /// Appends an item to `advanced_event_selectors`.
        ///
        /// To override the contents of this collection use [`set_advanced_event_selectors`](Self::set_advanced_event_selectors).
        ///
        /// <p>Specifies the advanced event selectors configured for your trail.</p>
        pub fn advanced_event_selectors(
            mut self,
            input: crate::model::AdvancedEventSelector,
        ) -> Self {
            let mut v = self.advanced_event_selectors.unwrap_or_default();
            v.push(input);
            self.advanced_event_selectors = Some(v);
            self
        }
        /// <p>Specifies the advanced event selectors configured for your trail.</p>
        pub fn set_advanced_event_selectors(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AdvancedEventSelector>>,
        ) -> Self {
            self.advanced_event_selectors = input;
            self
        }
        /// Consumes the builder and constructs a [`PutEventSelectorsOutput`](crate::output::PutEventSelectorsOutput)
        pub fn build(self) -> crate::output::PutEventSelectorsOutput {
            crate::output::PutEventSelectorsOutput {
                trail_arn: self.trail_arn,
                event_selectors: self.event_selectors,
                advanced_event_selectors: self.advanced_event_selectors,
            }
        }
    }
}
impl PutEventSelectorsOutput {
    /// Creates a new builder-style object to manufacture [`PutEventSelectorsOutput`](crate::output::PutEventSelectorsOutput)
    pub fn builder() -> crate::output::put_event_selectors_output::Builder {
        crate::output::put_event_selectors_output::Builder::default()
    }
}

/// <p>Contains a response to a LookupEvents action.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LookupEventsOutput {
    /// <p>A list of events returned based on the lookup attributes specified and the CloudTrail event. The events list is sorted by time. The most recent event is listed first.</p>
    pub events: std::option::Option<std::vec::Vec<crate::model::Event>>,
    /// <p>The token to use to get the next page of results after a previous API call. If the token does not appear, there are no more results to return. The token must be passed in with the same parameters as the previous call. For example, if the original call specified an AttributeKey of 'Username' with a value of 'root', the call with NextToken should include those same parameters.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl LookupEventsOutput {
    /// <p>A list of events returned based on the lookup attributes specified and the CloudTrail event. The events list is sorted by time. The most recent event is listed first.</p>
    pub fn events(&self) -> std::option::Option<&[crate::model::Event]> {
        self.events.as_deref()
    }
    /// <p>The token to use to get the next page of results after a previous API call. If the token does not appear, there are no more results to return. The token must be passed in with the same parameters as the previous call. For example, if the original call specified an AttributeKey of 'Username' with a value of 'root', the call with NextToken should include those same parameters.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for LookupEventsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LookupEventsOutput");
        formatter.field("events", &self.events);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`LookupEventsOutput`](crate::output::LookupEventsOutput)
pub mod lookup_events_output {
    /// A builder for [`LookupEventsOutput`](crate::output::LookupEventsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) events: std::option::Option<std::vec::Vec<crate::model::Event>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `events`.
        ///
        /// To override the contents of this collection use [`set_events`](Self::set_events).
        ///
        /// <p>A list of events returned based on the lookup attributes specified and the CloudTrail event. The events list is sorted by time. The most recent event is listed first.</p>
        pub fn events(mut self, input: crate::model::Event) -> Self {
            let mut v = self.events.unwrap_or_default();
            v.push(input);
            self.events = Some(v);
            self
        }
        /// <p>A list of events returned based on the lookup attributes specified and the CloudTrail event. The events list is sorted by time. The most recent event is listed first.</p>
        pub fn set_events(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Event>>,
        ) -> Self {
            self.events = input;
            self
        }
        /// <p>The token to use to get the next page of results after a previous API call. If the token does not appear, there are no more results to return. The token must be passed in with the same parameters as the previous call. For example, if the original call specified an AttributeKey of 'Username' with a value of 'root', the call with NextToken should include those same parameters.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token to use to get the next page of results after a previous API call. If the token does not appear, there are no more results to return. The token must be passed in with the same parameters as the previous call. For example, if the original call specified an AttributeKey of 'Username' with a value of 'root', the call with NextToken should include those same parameters.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`LookupEventsOutput`](crate::output::LookupEventsOutput)
        pub fn build(self) -> crate::output::LookupEventsOutput {
            crate::output::LookupEventsOutput {
                events: self.events,
                next_token: self.next_token,
            }
        }
    }
}
impl LookupEventsOutput {
    /// Creates a new builder-style object to manufacture [`LookupEventsOutput`](crate::output::LookupEventsOutput)
    pub fn builder() -> crate::output::lookup_events_output::Builder {
        crate::output::lookup_events_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTrailsOutput {
    /// <p>Returns the name, ARN, and home region of trails in the current account.</p>
    pub trails: std::option::Option<std::vec::Vec<crate::model::TrailInfo>>,
    /// <p>The token to use to get the next page of results after a previous API call. If the token does not appear, there are no more results to return. The token must be passed in with the same parameters as the previous call. For example, if the original call specified an AttributeKey of 'Username' with a value of 'root', the call with NextToken should include those same parameters.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListTrailsOutput {
    /// <p>Returns the name, ARN, and home region of trails in the current account.</p>
    pub fn trails(&self) -> std::option::Option<&[crate::model::TrailInfo]> {
        self.trails.as_deref()
    }
    /// <p>The token to use to get the next page of results after a previous API call. If the token does not appear, there are no more results to return. The token must be passed in with the same parameters as the previous call. For example, if the original call specified an AttributeKey of 'Username' with a value of 'root', the call with NextToken should include those same parameters.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListTrailsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTrailsOutput");
        formatter.field("trails", &self.trails);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListTrailsOutput`](crate::output::ListTrailsOutput)
pub mod list_trails_output {
    /// A builder for [`ListTrailsOutput`](crate::output::ListTrailsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) trails: std::option::Option<std::vec::Vec<crate::model::TrailInfo>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `trails`.
        ///
        /// To override the contents of this collection use [`set_trails`](Self::set_trails).
        ///
        /// <p>Returns the name, ARN, and home region of trails in the current account.</p>
        pub fn trails(mut self, input: crate::model::TrailInfo) -> Self {
            let mut v = self.trails.unwrap_or_default();
            v.push(input);
            self.trails = Some(v);
            self
        }
        /// <p>Returns the name, ARN, and home region of trails in the current account.</p>
        pub fn set_trails(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TrailInfo>>,
        ) -> Self {
            self.trails = input;
            self
        }
        /// <p>The token to use to get the next page of results after a previous API call. If the token does not appear, there are no more results to return. The token must be passed in with the same parameters as the previous call. For example, if the original call specified an AttributeKey of 'Username' with a value of 'root', the call with NextToken should include those same parameters.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token to use to get the next page of results after a previous API call. If the token does not appear, there are no more results to return. The token must be passed in with the same parameters as the previous call. For example, if the original call specified an AttributeKey of 'Username' with a value of 'root', the call with NextToken should include those same parameters.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTrailsOutput`](crate::output::ListTrailsOutput)
        pub fn build(self) -> crate::output::ListTrailsOutput {
            crate::output::ListTrailsOutput {
                trails: self.trails,
                next_token: self.next_token,
            }
        }
    }
}
impl ListTrailsOutput {
    /// Creates a new builder-style object to manufacture [`ListTrailsOutput`](crate::output::ListTrailsOutput)
    pub fn builder() -> crate::output::list_trails_output::Builder {
        crate::output::list_trails_output::Builder::default()
    }
}

/// <p>Returns the objects or data listed below if successful. Otherwise, returns an error.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTagsOutput {
    /// <p>A list of resource tags.</p>
    pub resource_tag_list: std::option::Option<std::vec::Vec<crate::model::ResourceTag>>,
    /// <p>Reserved for future use.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListTagsOutput {
    /// <p>A list of resource tags.</p>
    pub fn resource_tag_list(&self) -> std::option::Option<&[crate::model::ResourceTag]> {
        self.resource_tag_list.as_deref()
    }
    /// <p>Reserved for future use.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListTagsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTagsOutput");
        formatter.field("resource_tag_list", &self.resource_tag_list);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListTagsOutput`](crate::output::ListTagsOutput)
pub mod list_tags_output {
    /// A builder for [`ListTagsOutput`](crate::output::ListTagsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_tag_list: std::option::Option<std::vec::Vec<crate::model::ResourceTag>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `resource_tag_list`.
        ///
        /// To override the contents of this collection use [`set_resource_tag_list`](Self::set_resource_tag_list).
        ///
        /// <p>A list of resource tags.</p>
        pub fn resource_tag_list(mut self, input: crate::model::ResourceTag) -> Self {
            let mut v = self.resource_tag_list.unwrap_or_default();
            v.push(input);
            self.resource_tag_list = Some(v);
            self
        }
        /// <p>A list of resource tags.</p>
        pub fn set_resource_tag_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ResourceTag>>,
        ) -> Self {
            self.resource_tag_list = input;
            self
        }
        /// <p>Reserved for future use.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>Reserved for future use.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTagsOutput`](crate::output::ListTagsOutput)
        pub fn build(self) -> crate::output::ListTagsOutput {
            crate::output::ListTagsOutput {
                resource_tag_list: self.resource_tag_list,
                next_token: self.next_token,
            }
        }
    }
}
impl ListTagsOutput {
    /// Creates a new builder-style object to manufacture [`ListTagsOutput`](crate::output::ListTagsOutput)
    pub fn builder() -> crate::output::list_tags_output::Builder {
        crate::output::list_tags_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListQueriesOutput {
    /// <p>Lists matching query results, and shows query ID, status, and creation time of each query.</p>
    pub queries: std::option::Option<std::vec::Vec<crate::model::Query>>,
    /// <p>A token you can use to get the next page of results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListQueriesOutput {
    /// <p>Lists matching query results, and shows query ID, status, and creation time of each query.</p>
    pub fn queries(&self) -> std::option::Option<&[crate::model::Query]> {
        self.queries.as_deref()
    }
    /// <p>A token you can use to get the next page of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListQueriesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListQueriesOutput");
        formatter.field("queries", &self.queries);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListQueriesOutput`](crate::output::ListQueriesOutput)
pub mod list_queries_output {
    /// A builder for [`ListQueriesOutput`](crate::output::ListQueriesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) queries: std::option::Option<std::vec::Vec<crate::model::Query>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `queries`.
        ///
        /// To override the contents of this collection use [`set_queries`](Self::set_queries).
        ///
        /// <p>Lists matching query results, and shows query ID, status, and creation time of each query.</p>
        pub fn queries(mut self, input: crate::model::Query) -> Self {
            let mut v = self.queries.unwrap_or_default();
            v.push(input);
            self.queries = Some(v);
            self
        }
        /// <p>Lists matching query results, and shows query ID, status, and creation time of each query.</p>
        pub fn set_queries(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Query>>,
        ) -> Self {
            self.queries = input;
            self
        }
        /// <p>A token you can use to get the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A token you can use to get the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListQueriesOutput`](crate::output::ListQueriesOutput)
        pub fn build(self) -> crate::output::ListQueriesOutput {
            crate::output::ListQueriesOutput {
                queries: self.queries,
                next_token: self.next_token,
            }
        }
    }
}
impl ListQueriesOutput {
    /// Creates a new builder-style object to manufacture [`ListQueriesOutput`](crate::output::ListQueriesOutput)
    pub fn builder() -> crate::output::list_queries_output::Builder {
        crate::output::list_queries_output::Builder::default()
    }
}

/// <p>Returns the objects or data listed below if successful. Otherwise, returns an error.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListPublicKeysOutput {
    /// <p>Contains an array of PublicKey objects.</p> <note>
    /// <p>The returned public keys may have validity time ranges that overlap.</p>
    /// </note>
    pub public_key_list: std::option::Option<std::vec::Vec<crate::model::PublicKey>>,
    /// <p>Reserved for future use.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListPublicKeysOutput {
    /// <p>Contains an array of PublicKey objects.</p> <note>
    /// <p>The returned public keys may have validity time ranges that overlap.</p>
    /// </note>
    pub fn public_key_list(&self) -> std::option::Option<&[crate::model::PublicKey]> {
        self.public_key_list.as_deref()
    }
    /// <p>Reserved for future use.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListPublicKeysOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListPublicKeysOutput");
        formatter.field("public_key_list", &self.public_key_list);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListPublicKeysOutput`](crate::output::ListPublicKeysOutput)
pub mod list_public_keys_output {
    /// A builder for [`ListPublicKeysOutput`](crate::output::ListPublicKeysOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) public_key_list: std::option::Option<std::vec::Vec<crate::model::PublicKey>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `public_key_list`.
        ///
        /// To override the contents of this collection use [`set_public_key_list`](Self::set_public_key_list).
        ///
        /// <p>Contains an array of PublicKey objects.</p> <note>
        /// <p>The returned public keys may have validity time ranges that overlap.</p>
        /// </note>
        pub fn public_key_list(mut self, input: crate::model::PublicKey) -> Self {
            let mut v = self.public_key_list.unwrap_or_default();
            v.push(input);
            self.public_key_list = Some(v);
            self
        }
        /// <p>Contains an array of PublicKey objects.</p> <note>
        /// <p>The returned public keys may have validity time ranges that overlap.</p>
        /// </note>
        pub fn set_public_key_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PublicKey>>,
        ) -> Self {
            self.public_key_list = input;
            self
        }
        /// <p>Reserved for future use.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>Reserved for future use.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListPublicKeysOutput`](crate::output::ListPublicKeysOutput)
        pub fn build(self) -> crate::output::ListPublicKeysOutput {
            crate::output::ListPublicKeysOutput {
                public_key_list: self.public_key_list,
                next_token: self.next_token,
            }
        }
    }
}
impl ListPublicKeysOutput {
    /// Creates a new builder-style object to manufacture [`ListPublicKeysOutput`](crate::output::ListPublicKeysOutput)
    pub fn builder() -> crate::output::list_public_keys_output::Builder {
        crate::output::list_public_keys_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListEventDataStoresOutput {
    /// <p>Contains information about event data stores in the account, in the current region.</p>
    pub event_data_stores: std::option::Option<std::vec::Vec<crate::model::EventDataStore>>,
    /// <p>A token you can use to get the next page of results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListEventDataStoresOutput {
    /// <p>Contains information about event data stores in the account, in the current region.</p>
    pub fn event_data_stores(&self) -> std::option::Option<&[crate::model::EventDataStore]> {
        self.event_data_stores.as_deref()
    }
    /// <p>A token you can use to get the next page of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListEventDataStoresOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListEventDataStoresOutput");
        formatter.field("event_data_stores", &self.event_data_stores);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListEventDataStoresOutput`](crate::output::ListEventDataStoresOutput)
pub mod list_event_data_stores_output {
    /// A builder for [`ListEventDataStoresOutput`](crate::output::ListEventDataStoresOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) event_data_stores:
            std::option::Option<std::vec::Vec<crate::model::EventDataStore>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `event_data_stores`.
        ///
        /// To override the contents of this collection use [`set_event_data_stores`](Self::set_event_data_stores).
        ///
        /// <p>Contains information about event data stores in the account, in the current region.</p>
        pub fn event_data_stores(mut self, input: crate::model::EventDataStore) -> Self {
            let mut v = self.event_data_stores.unwrap_or_default();
            v.push(input);
            self.event_data_stores = Some(v);
            self
        }
        /// <p>Contains information about event data stores in the account, in the current region.</p>
        pub fn set_event_data_stores(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::EventDataStore>>,
        ) -> Self {
            self.event_data_stores = input;
            self
        }
        /// <p>A token you can use to get the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A token you can use to get the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListEventDataStoresOutput`](crate::output::ListEventDataStoresOutput)
        pub fn build(self) -> crate::output::ListEventDataStoresOutput {
            crate::output::ListEventDataStoresOutput {
                event_data_stores: self.event_data_stores,
                next_token: self.next_token,
            }
        }
    }
}
impl ListEventDataStoresOutput {
    /// Creates a new builder-style object to manufacture [`ListEventDataStoresOutput`](crate::output::ListEventDataStoresOutput)
    pub fn builder() -> crate::output::list_event_data_stores_output::Builder {
        crate::output::list_event_data_stores_output::Builder::default()
    }
}

/// <p>Returns the objects or data listed below if successful. Otherwise, returns an error.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetTrailStatusOutput {
    /// <p>Whether the CloudTrail trail is currently logging Amazon Web Services API calls.</p>
    pub is_logging: std::option::Option<bool>,
    /// <p>Displays any Amazon S3 error that CloudTrail encountered when attempting to deliver log files to the designated bucket. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/ErrorResponses.html">Error Responses</a> in the Amazon S3 API Reference. </p> <note>
    /// <p>This error occurs only when there is a problem with the destination S3 bucket, and does not occur for requests that time out. To resolve the issue, create a new bucket, and then call <code>UpdateTrail</code> to specify the new bucket; or fix the existing objects so that CloudTrail can again write to the bucket.</p>
    /// </note>
    pub latest_delivery_error: std::option::Option<std::string::String>,
    /// <p>Displays any Amazon SNS error that CloudTrail encountered when attempting to send a notification. For more information about Amazon SNS errors, see the <a href="https://docs.aws.amazon.com/sns/latest/dg/welcome.html">Amazon SNS Developer Guide</a>. </p>
    pub latest_notification_error: std::option::Option<std::string::String>,
    /// <p>Specifies the date and time that CloudTrail last delivered log files to an account's Amazon S3 bucket.</p>
    pub latest_delivery_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>Specifies the date and time of the most recent Amazon SNS notification that CloudTrail has written a new log file to an account's Amazon S3 bucket.</p>
    pub latest_notification_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>Specifies the most recent date and time when CloudTrail started recording API calls for an Amazon Web Services account.</p>
    pub start_logging_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>Specifies the most recent date and time when CloudTrail stopped recording API calls for an Amazon Web Services account.</p>
    pub stop_logging_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>Displays any CloudWatch Logs error that CloudTrail encountered when attempting to deliver logs to CloudWatch Logs.</p>
    pub latest_cloud_watch_logs_delivery_error: std::option::Option<std::string::String>,
    /// <p>Displays the most recent date and time when CloudTrail delivered logs to CloudWatch Logs.</p>
    pub latest_cloud_watch_logs_delivery_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>Specifies the date and time that CloudTrail last delivered a digest file to an account's Amazon S3 bucket.</p>
    pub latest_digest_delivery_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>Displays any Amazon S3 error that CloudTrail encountered when attempting to deliver a digest file to the designated bucket. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/ErrorResponses.html">Error Responses</a> in the Amazon S3 API Reference. </p> <note>
    /// <p>This error occurs only when there is a problem with the destination S3 bucket, and does not occur for requests that time out. To resolve the issue, create a new bucket, and then call <code>UpdateTrail</code> to specify the new bucket; or fix the existing objects so that CloudTrail can again write to the bucket.</p>
    /// </note>
    pub latest_digest_delivery_error: std::option::Option<std::string::String>,
    /// <p>This field is no longer in use.</p>
    pub latest_delivery_attempt_time: std::option::Option<std::string::String>,
    /// <p>This field is no longer in use.</p>
    pub latest_notification_attempt_time: std::option::Option<std::string::String>,
    /// <p>This field is no longer in use.</p>
    pub latest_notification_attempt_succeeded: std::option::Option<std::string::String>,
    /// <p>This field is no longer in use.</p>
    pub latest_delivery_attempt_succeeded: std::option::Option<std::string::String>,
    /// <p>This field is no longer in use.</p>
    pub time_logging_started: std::option::Option<std::string::String>,
    /// <p>This field is no longer in use.</p>
    pub time_logging_stopped: std::option::Option<std::string::String>,
}
impl GetTrailStatusOutput {
    /// <p>Whether the CloudTrail trail is currently logging Amazon Web Services API calls.</p>
    pub fn is_logging(&self) -> std::option::Option<bool> {
        self.is_logging
    }
    /// <p>Displays any Amazon S3 error that CloudTrail encountered when attempting to deliver log files to the designated bucket. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/ErrorResponses.html">Error Responses</a> in the Amazon S3 API Reference. </p> <note>
    /// <p>This error occurs only when there is a problem with the destination S3 bucket, and does not occur for requests that time out. To resolve the issue, create a new bucket, and then call <code>UpdateTrail</code> to specify the new bucket; or fix the existing objects so that CloudTrail can again write to the bucket.</p>
    /// </note>
    pub fn latest_delivery_error(&self) -> std::option::Option<&str> {
        self.latest_delivery_error.as_deref()
    }
    /// <p>Displays any Amazon SNS error that CloudTrail encountered when attempting to send a notification. For more information about Amazon SNS errors, see the <a href="https://docs.aws.amazon.com/sns/latest/dg/welcome.html">Amazon SNS Developer Guide</a>. </p>
    pub fn latest_notification_error(&self) -> std::option::Option<&str> {
        self.latest_notification_error.as_deref()
    }
    /// <p>Specifies the date and time that CloudTrail last delivered log files to an account's Amazon S3 bucket.</p>
    pub fn latest_delivery_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.latest_delivery_time.as_ref()
    }
    /// <p>Specifies the date and time of the most recent Amazon SNS notification that CloudTrail has written a new log file to an account's Amazon S3 bucket.</p>
    pub fn latest_notification_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.latest_notification_time.as_ref()
    }
    /// <p>Specifies the most recent date and time when CloudTrail started recording API calls for an Amazon Web Services account.</p>
    pub fn start_logging_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.start_logging_time.as_ref()
    }
    /// <p>Specifies the most recent date and time when CloudTrail stopped recording API calls for an Amazon Web Services account.</p>
    pub fn stop_logging_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.stop_logging_time.as_ref()
    }
    /// <p>Displays any CloudWatch Logs error that CloudTrail encountered when attempting to deliver logs to CloudWatch Logs.</p>
    pub fn latest_cloud_watch_logs_delivery_error(&self) -> std::option::Option<&str> {
        self.latest_cloud_watch_logs_delivery_error.as_deref()
    }
    /// <p>Displays the most recent date and time when CloudTrail delivered logs to CloudWatch Logs.</p>
    pub fn latest_cloud_watch_logs_delivery_time(
        &self,
    ) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.latest_cloud_watch_logs_delivery_time.as_ref()
    }
    /// <p>Specifies the date and time that CloudTrail last delivered a digest file to an account's Amazon S3 bucket.</p>
    pub fn latest_digest_delivery_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.latest_digest_delivery_time.as_ref()
    }
    /// <p>Displays any Amazon S3 error that CloudTrail encountered when attempting to deliver a digest file to the designated bucket. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/ErrorResponses.html">Error Responses</a> in the Amazon S3 API Reference. </p> <note>
    /// <p>This error occurs only when there is a problem with the destination S3 bucket, and does not occur for requests that time out. To resolve the issue, create a new bucket, and then call <code>UpdateTrail</code> to specify the new bucket; or fix the existing objects so that CloudTrail can again write to the bucket.</p>
    /// </note>
    pub fn latest_digest_delivery_error(&self) -> std::option::Option<&str> {
        self.latest_digest_delivery_error.as_deref()
    }
    /// <p>This field is no longer in use.</p>
    pub fn latest_delivery_attempt_time(&self) -> std::option::Option<&str> {
        self.latest_delivery_attempt_time.as_deref()
    }
    /// <p>This field is no longer in use.</p>
    pub fn latest_notification_attempt_time(&self) -> std::option::Option<&str> {
        self.latest_notification_attempt_time.as_deref()
    }
    /// <p>This field is no longer in use.</p>
    pub fn latest_notification_attempt_succeeded(&self) -> std::option::Option<&str> {
        self.latest_notification_attempt_succeeded.as_deref()
    }
    /// <p>This field is no longer in use.</p>
    pub fn latest_delivery_attempt_succeeded(&self) -> std::option::Option<&str> {
        self.latest_delivery_attempt_succeeded.as_deref()
    }
    /// <p>This field is no longer in use.</p>
    pub fn time_logging_started(&self) -> std::option::Option<&str> {
        self.time_logging_started.as_deref()
    }
    /// <p>This field is no longer in use.</p>
    pub fn time_logging_stopped(&self) -> std::option::Option<&str> {
        self.time_logging_stopped.as_deref()
    }
}
impl std::fmt::Debug for GetTrailStatusOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetTrailStatusOutput");
        formatter.field("is_logging", &self.is_logging);
        formatter.field("latest_delivery_error", &self.latest_delivery_error);
        formatter.field("latest_notification_error", &self.latest_notification_error);
        formatter.field("latest_delivery_time", &self.latest_delivery_time);
        formatter.field("latest_notification_time", &self.latest_notification_time);
        formatter.field("start_logging_time", &self.start_logging_time);
        formatter.field("stop_logging_time", &self.stop_logging_time);
        formatter.field(
            "latest_cloud_watch_logs_delivery_error",
            &self.latest_cloud_watch_logs_delivery_error,
        );
        formatter.field(
            "latest_cloud_watch_logs_delivery_time",
            &self.latest_cloud_watch_logs_delivery_time,
        );
        formatter.field(
            "latest_digest_delivery_time",
            &self.latest_digest_delivery_time,
        );
        formatter.field(
            "latest_digest_delivery_error",
            &self.latest_digest_delivery_error,
        );
        formatter.field(
            "latest_delivery_attempt_time",
            &self.latest_delivery_attempt_time,
        );
        formatter.field(
            "latest_notification_attempt_time",
            &self.latest_notification_attempt_time,
        );
        formatter.field(
            "latest_notification_attempt_succeeded",
            &self.latest_notification_attempt_succeeded,
        );
        formatter.field(
            "latest_delivery_attempt_succeeded",
            &self.latest_delivery_attempt_succeeded,
        );
        formatter.field("time_logging_started", &self.time_logging_started);
        formatter.field("time_logging_stopped", &self.time_logging_stopped);
        formatter.finish()
    }
}
/// See [`GetTrailStatusOutput`](crate::output::GetTrailStatusOutput)
pub mod get_trail_status_output {
    /// A builder for [`GetTrailStatusOutput`](crate::output::GetTrailStatusOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) is_logging: std::option::Option<bool>,
        pub(crate) latest_delivery_error: std::option::Option<std::string::String>,
        pub(crate) latest_notification_error: std::option::Option<std::string::String>,
        pub(crate) latest_delivery_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) latest_notification_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) start_logging_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) stop_logging_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) latest_cloud_watch_logs_delivery_error: std::option::Option<std::string::String>,
        pub(crate) latest_cloud_watch_logs_delivery_time:
            std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) latest_digest_delivery_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) latest_digest_delivery_error: std::option::Option<std::string::String>,
        pub(crate) latest_delivery_attempt_time: std::option::Option<std::string::String>,
        pub(crate) latest_notification_attempt_time: std::option::Option<std::string::String>,
        pub(crate) latest_notification_attempt_succeeded: std::option::Option<std::string::String>,
        pub(crate) latest_delivery_attempt_succeeded: std::option::Option<std::string::String>,
        pub(crate) time_logging_started: std::option::Option<std::string::String>,
        pub(crate) time_logging_stopped: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Whether the CloudTrail trail is currently logging Amazon Web Services API calls.</p>
        pub fn is_logging(mut self, input: bool) -> Self {
            self.is_logging = Some(input);
            self
        }
        /// <p>Whether the CloudTrail trail is currently logging Amazon Web Services API calls.</p>
        pub fn set_is_logging(mut self, input: std::option::Option<bool>) -> Self {
            self.is_logging = input;
            self
        }
        /// <p>Displays any Amazon S3 error that CloudTrail encountered when attempting to deliver log files to the designated bucket. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/ErrorResponses.html">Error Responses</a> in the Amazon S3 API Reference. </p> <note>
        /// <p>This error occurs only when there is a problem with the destination S3 bucket, and does not occur for requests that time out. To resolve the issue, create a new bucket, and then call <code>UpdateTrail</code> to specify the new bucket; or fix the existing objects so that CloudTrail can again write to the bucket.</p>
        /// </note>
        pub fn latest_delivery_error(mut self, input: impl Into<std::string::String>) -> Self {
            self.latest_delivery_error = Some(input.into());
            self
        }
        /// <p>Displays any Amazon S3 error that CloudTrail encountered when attempting to deliver log files to the designated bucket. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/ErrorResponses.html">Error Responses</a> in the Amazon S3 API Reference. </p> <note>
        /// <p>This error occurs only when there is a problem with the destination S3 bucket, and does not occur for requests that time out. To resolve the issue, create a new bucket, and then call <code>UpdateTrail</code> to specify the new bucket; or fix the existing objects so that CloudTrail can again write to the bucket.</p>
        /// </note>
        pub fn set_latest_delivery_error(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.latest_delivery_error = input;
            self
        }
        /// <p>Displays any Amazon SNS error that CloudTrail encountered when attempting to send a notification. For more information about Amazon SNS errors, see the <a href="https://docs.aws.amazon.com/sns/latest/dg/welcome.html">Amazon SNS Developer Guide</a>. </p>
        pub fn latest_notification_error(mut self, input: impl Into<std::string::String>) -> Self {
            self.latest_notification_error = Some(input.into());
            self
        }
        /// <p>Displays any Amazon SNS error that CloudTrail encountered when attempting to send a notification. For more information about Amazon SNS errors, see the <a href="https://docs.aws.amazon.com/sns/latest/dg/welcome.html">Amazon SNS Developer Guide</a>. </p>
        pub fn set_latest_notification_error(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.latest_notification_error = input;
            self
        }
        /// <p>Specifies the date and time that CloudTrail last delivered log files to an account's Amazon S3 bucket.</p>
        pub fn latest_delivery_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.latest_delivery_time = Some(input);
            self
        }
        /// <p>Specifies the date and time that CloudTrail last delivered log files to an account's Amazon S3 bucket.</p>
        pub fn set_latest_delivery_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.latest_delivery_time = input;
            self
        }
        /// <p>Specifies the date and time of the most recent Amazon SNS notification that CloudTrail has written a new log file to an account's Amazon S3 bucket.</p>
        pub fn latest_notification_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.latest_notification_time = Some(input);
            self
        }
        /// <p>Specifies the date and time of the most recent Amazon SNS notification that CloudTrail has written a new log file to an account's Amazon S3 bucket.</p>
        pub fn set_latest_notification_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.latest_notification_time = input;
            self
        }
        /// <p>Specifies the most recent date and time when CloudTrail started recording API calls for an Amazon Web Services account.</p>
        pub fn start_logging_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.start_logging_time = Some(input);
            self
        }
        /// <p>Specifies the most recent date and time when CloudTrail started recording API calls for an Amazon Web Services account.</p>
        pub fn set_start_logging_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.start_logging_time = input;
            self
        }
        /// <p>Specifies the most recent date and time when CloudTrail stopped recording API calls for an Amazon Web Services account.</p>
        pub fn stop_logging_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.stop_logging_time = Some(input);
            self
        }
        /// <p>Specifies the most recent date and time when CloudTrail stopped recording API calls for an Amazon Web Services account.</p>
        pub fn set_stop_logging_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.stop_logging_time = input;
            self
        }
        /// <p>Displays any CloudWatch Logs error that CloudTrail encountered when attempting to deliver logs to CloudWatch Logs.</p>
        pub fn latest_cloud_watch_logs_delivery_error(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.latest_cloud_watch_logs_delivery_error = Some(input.into());
            self
        }
        /// <p>Displays any CloudWatch Logs error that CloudTrail encountered when attempting to deliver logs to CloudWatch Logs.</p>
        pub fn set_latest_cloud_watch_logs_delivery_error(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.latest_cloud_watch_logs_delivery_error = input;
            self
        }
        /// <p>Displays the most recent date and time when CloudTrail delivered logs to CloudWatch Logs.</p>
        pub fn latest_cloud_watch_logs_delivery_time(
            mut self,
            input: aws_smithy_types::DateTime,
        ) -> Self {
            self.latest_cloud_watch_logs_delivery_time = Some(input);
            self
        }
        /// <p>Displays the most recent date and time when CloudTrail delivered logs to CloudWatch Logs.</p>
        pub fn set_latest_cloud_watch_logs_delivery_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.latest_cloud_watch_logs_delivery_time = input;
            self
        }
        /// <p>Specifies the date and time that CloudTrail last delivered a digest file to an account's Amazon S3 bucket.</p>
        pub fn latest_digest_delivery_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.latest_digest_delivery_time = Some(input);
            self
        }
        /// <p>Specifies the date and time that CloudTrail last delivered a digest file to an account's Amazon S3 bucket.</p>
        pub fn set_latest_digest_delivery_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.latest_digest_delivery_time = input;
            self
        }
        /// <p>Displays any Amazon S3 error that CloudTrail encountered when attempting to deliver a digest file to the designated bucket. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/ErrorResponses.html">Error Responses</a> in the Amazon S3 API Reference. </p> <note>
        /// <p>This error occurs only when there is a problem with the destination S3 bucket, and does not occur for requests that time out. To resolve the issue, create a new bucket, and then call <code>UpdateTrail</code> to specify the new bucket; or fix the existing objects so that CloudTrail can again write to the bucket.</p>
        /// </note>
        pub fn latest_digest_delivery_error(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.latest_digest_delivery_error = Some(input.into());
            self
        }
        /// <p>Displays any Amazon S3 error that CloudTrail encountered when attempting to deliver a digest file to the designated bucket. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/ErrorResponses.html">Error Responses</a> in the Amazon S3 API Reference. </p> <note>
        /// <p>This error occurs only when there is a problem with the destination S3 bucket, and does not occur for requests that time out. To resolve the issue, create a new bucket, and then call <code>UpdateTrail</code> to specify the new bucket; or fix the existing objects so that CloudTrail can again write to the bucket.</p>
        /// </note>
        pub fn set_latest_digest_delivery_error(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.latest_digest_delivery_error = input;
            self
        }
        /// <p>This field is no longer in use.</p>
        pub fn latest_delivery_attempt_time(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.latest_delivery_attempt_time = Some(input.into());
            self
        }
        /// <p>This field is no longer in use.</p>
        pub fn set_latest_delivery_attempt_time(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.latest_delivery_attempt_time = input;
            self
        }
        /// <p>This field is no longer in use.</p>
        pub fn latest_notification_attempt_time(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.latest_notification_attempt_time = Some(input.into());
            self
        }
        /// <p>This field is no longer in use.</p>
        pub fn set_latest_notification_attempt_time(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.latest_notification_attempt_time = input;
            self
        }
        /// <p>This field is no longer in use.</p>
        pub fn latest_notification_attempt_succeeded(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.latest_notification_attempt_succeeded = Some(input.into());
            self
        }
        /// <p>This field is no longer in use.</p>
        pub fn set_latest_notification_attempt_succeeded(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.latest_notification_attempt_succeeded = input;
            self
        }
        /// <p>This field is no longer in use.</p>
        pub fn latest_delivery_attempt_succeeded(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.latest_delivery_attempt_succeeded = Some(input.into());
            self
        }
        /// <p>This field is no longer in use.</p>
        pub fn set_latest_delivery_attempt_succeeded(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.latest_delivery_attempt_succeeded = input;
            self
        }
        /// <p>This field is no longer in use.</p>
        pub fn time_logging_started(mut self, input: impl Into<std::string::String>) -> Self {
            self.time_logging_started = Some(input.into());
            self
        }
        /// <p>This field is no longer in use.</p>
        pub fn set_time_logging_started(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.time_logging_started = input;
            self
        }
        /// <p>This field is no longer in use.</p>
        pub fn time_logging_stopped(mut self, input: impl Into<std::string::String>) -> Self {
            self.time_logging_stopped = Some(input.into());
            self
        }
        /// <p>This field is no longer in use.</p>
        pub fn set_time_logging_stopped(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.time_logging_stopped = input;
            self
        }
        /// Consumes the builder and constructs a [`GetTrailStatusOutput`](crate::output::GetTrailStatusOutput)
        pub fn build(self) -> crate::output::GetTrailStatusOutput {
            crate::output::GetTrailStatusOutput {
                is_logging: self.is_logging,
                latest_delivery_error: self.latest_delivery_error,
                latest_notification_error: self.latest_notification_error,
                latest_delivery_time: self.latest_delivery_time,
                latest_notification_time: self.latest_notification_time,
                start_logging_time: self.start_logging_time,
                stop_logging_time: self.stop_logging_time,
                latest_cloud_watch_logs_delivery_error: self.latest_cloud_watch_logs_delivery_error,
                latest_cloud_watch_logs_delivery_time: self.latest_cloud_watch_logs_delivery_time,
                latest_digest_delivery_time: self.latest_digest_delivery_time,
                latest_digest_delivery_error: self.latest_digest_delivery_error,
                latest_delivery_attempt_time: self.latest_delivery_attempt_time,
                latest_notification_attempt_time: self.latest_notification_attempt_time,
                latest_notification_attempt_succeeded: self.latest_notification_attempt_succeeded,
                latest_delivery_attempt_succeeded: self.latest_delivery_attempt_succeeded,
                time_logging_started: self.time_logging_started,
                time_logging_stopped: self.time_logging_stopped,
            }
        }
    }
}
impl GetTrailStatusOutput {
    /// Creates a new builder-style object to manufacture [`GetTrailStatusOutput`](crate::output::GetTrailStatusOutput)
    pub fn builder() -> crate::output::get_trail_status_output::Builder {
        crate::output::get_trail_status_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetTrailOutput {
    /// <p>The settings for a trail.</p>
    pub trail: std::option::Option<crate::model::Trail>,
}
impl GetTrailOutput {
    /// <p>The settings for a trail.</p>
    pub fn trail(&self) -> std::option::Option<&crate::model::Trail> {
        self.trail.as_ref()
    }
}
impl std::fmt::Debug for GetTrailOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetTrailOutput");
        formatter.field("trail", &self.trail);
        formatter.finish()
    }
}
/// See [`GetTrailOutput`](crate::output::GetTrailOutput)
pub mod get_trail_output {
    /// A builder for [`GetTrailOutput`](crate::output::GetTrailOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) trail: std::option::Option<crate::model::Trail>,
    }
    impl Builder {
        /// <p>The settings for a trail.</p>
        pub fn trail(mut self, input: crate::model::Trail) -> Self {
            self.trail = Some(input);
            self
        }
        /// <p>The settings for a trail.</p>
        pub fn set_trail(mut self, input: std::option::Option<crate::model::Trail>) -> Self {
            self.trail = input;
            self
        }
        /// Consumes the builder and constructs a [`GetTrailOutput`](crate::output::GetTrailOutput)
        pub fn build(self) -> crate::output::GetTrailOutput {
            crate::output::GetTrailOutput { trail: self.trail }
        }
    }
}
impl GetTrailOutput {
    /// Creates a new builder-style object to manufacture [`GetTrailOutput`](crate::output::GetTrailOutput)
    pub fn builder() -> crate::output::get_trail_output::Builder {
        crate::output::get_trail_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetQueryResultsOutput {
    /// <p>The status of the query. Values include <code>QUEUED</code>, <code>RUNNING</code>, <code>FINISHED</code>, <code>FAILED</code>, or <code>CANCELLED</code>.</p>
    pub query_status: std::option::Option<crate::model::QueryStatus>,
    /// <p>Shows the count of query results.</p>
    pub query_statistics: std::option::Option<crate::model::QueryStatistics>,
    /// <p>Contains the individual event results of the query.</p>
    pub query_result_rows: std::option::Option<
        std::vec::Vec<
            std::vec::Vec<std::collections::HashMap<std::string::String, std::string::String>>,
        >,
    >,
    /// <p>A token you can use to get the next page of query results.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The error message returned if a query failed.</p>
    pub error_message: std::option::Option<std::string::String>,
}
impl GetQueryResultsOutput {
    /// <p>The status of the query. Values include <code>QUEUED</code>, <code>RUNNING</code>, <code>FINISHED</code>, <code>FAILED</code>, or <code>CANCELLED</code>.</p>
    pub fn query_status(&self) -> std::option::Option<&crate::model::QueryStatus> {
        self.query_status.as_ref()
    }
    /// <p>Shows the count of query results.</p>
    pub fn query_statistics(&self) -> std::option::Option<&crate::model::QueryStatistics> {
        self.query_statistics.as_ref()
    }
    /// <p>Contains the individual event results of the query.</p>
    pub fn query_result_rows(
        &self,
    ) -> std::option::Option<
        &[std::vec::Vec<std::collections::HashMap<std::string::String, std::string::String>>],
    > {
        self.query_result_rows.as_deref()
    }
    /// <p>A token you can use to get the next page of query results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The error message returned if a query failed.</p>
    pub fn error_message(&self) -> std::option::Option<&str> {
        self.error_message.as_deref()
    }
}
impl std::fmt::Debug for GetQueryResultsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetQueryResultsOutput");
        formatter.field("query_status", &self.query_status);
        formatter.field("query_statistics", &self.query_statistics);
        formatter.field("query_result_rows", &self.query_result_rows);
        formatter.field("next_token", &self.next_token);
        formatter.field("error_message", &self.error_message);
        formatter.finish()
    }
}
/// See [`GetQueryResultsOutput`](crate::output::GetQueryResultsOutput)
pub mod get_query_results_output {
    /// A builder for [`GetQueryResultsOutput`](crate::output::GetQueryResultsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) query_status: std::option::Option<crate::model::QueryStatus>,
        pub(crate) query_statistics: std::option::Option<crate::model::QueryStatistics>,
        pub(crate) query_result_rows: std::option::Option<
            std::vec::Vec<
                std::vec::Vec<std::collections::HashMap<std::string::String, std::string::String>>,
            >,
        >,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) error_message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The status of the query. Values include <code>QUEUED</code>, <code>RUNNING</code>, <code>FINISHED</code>, <code>FAILED</code>, or <code>CANCELLED</code>.</p>
        pub fn query_status(mut self, input: crate::model::QueryStatus) -> Self {
            self.query_status = Some(input);
            self
        }
        /// <p>The status of the query. Values include <code>QUEUED</code>, <code>RUNNING</code>, <code>FINISHED</code>, <code>FAILED</code>, or <code>CANCELLED</code>.</p>
        pub fn set_query_status(
            mut self,
            input: std::option::Option<crate::model::QueryStatus>,
        ) -> Self {
            self.query_status = input;
            self
        }
        /// <p>Shows the count of query results.</p>
        pub fn query_statistics(mut self, input: crate::model::QueryStatistics) -> Self {
            self.query_statistics = Some(input);
            self
        }
        /// <p>Shows the count of query results.</p>
        pub fn set_query_statistics(
            mut self,
            input: std::option::Option<crate::model::QueryStatistics>,
        ) -> Self {
            self.query_statistics = input;
            self
        }
        /// Appends an item to `query_result_rows`.
        ///
        /// To override the contents of this collection use [`set_query_result_rows`](Self::set_query_result_rows).
        ///
        /// <p>Contains the individual event results of the query.</p>
        pub fn query_result_rows(
            mut self,
            input: std::vec::Vec<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            let mut v = self.query_result_rows.unwrap_or_default();
            v.push(input);
            self.query_result_rows = Some(v);
            self
        }
        /// <p>Contains the individual event results of the query.</p>
        pub fn set_query_result_rows(
            mut self,
            input: std::option::Option<
                std::vec::Vec<
                    std::vec::Vec<
                        std::collections::HashMap<std::string::String, std::string::String>,
                    >,
                >,
            >,
        ) -> Self {
            self.query_result_rows = input;
            self
        }
        /// <p>A token you can use to get the next page of query results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A token you can use to get the next page of query results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The error message returned if a query failed.</p>
        pub fn error_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.error_message = Some(input.into());
            self
        }
        /// <p>The error message returned if a query failed.</p>
        pub fn set_error_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.error_message = input;
            self
        }
        /// Consumes the builder and constructs a [`GetQueryResultsOutput`](crate::output::GetQueryResultsOutput)
        pub fn build(self) -> crate::output::GetQueryResultsOutput {
            crate::output::GetQueryResultsOutput {
                query_status: self.query_status,
                query_statistics: self.query_statistics,
                query_result_rows: self.query_result_rows,
                next_token: self.next_token,
                error_message: self.error_message,
            }
        }
    }
}
impl GetQueryResultsOutput {
    /// Creates a new builder-style object to manufacture [`GetQueryResultsOutput`](crate::output::GetQueryResultsOutput)
    pub fn builder() -> crate::output::get_query_results_output::Builder {
        crate::output::get_query_results_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetInsightSelectorsOutput {
    /// <p>The Amazon Resource Name (ARN) of a trail for which you want to get Insights selectors.</p>
    pub trail_arn: std::option::Option<std::string::String>,
    /// <p>A JSON string that contains the insight types you want to log on a trail. In this release, <code>ApiErrorRateInsight</code> and <code>ApiCallRateInsight</code> are supported as insight types.</p>
    pub insight_selectors: std::option::Option<std::vec::Vec<crate::model::InsightSelector>>,
}
impl GetInsightSelectorsOutput {
    /// <p>The Amazon Resource Name (ARN) of a trail for which you want to get Insights selectors.</p>
    pub fn trail_arn(&self) -> std::option::Option<&str> {
        self.trail_arn.as_deref()
    }
    /// <p>A JSON string that contains the insight types you want to log on a trail. In this release, <code>ApiErrorRateInsight</code> and <code>ApiCallRateInsight</code> are supported as insight types.</p>
    pub fn insight_selectors(&self) -> std::option::Option<&[crate::model::InsightSelector]> {
        self.insight_selectors.as_deref()
    }
}
impl std::fmt::Debug for GetInsightSelectorsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetInsightSelectorsOutput");
        formatter.field("trail_arn", &self.trail_arn);
        formatter.field("insight_selectors", &self.insight_selectors);
        formatter.finish()
    }
}
/// See [`GetInsightSelectorsOutput`](crate::output::GetInsightSelectorsOutput)
pub mod get_insight_selectors_output {
    /// A builder for [`GetInsightSelectorsOutput`](crate::output::GetInsightSelectorsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) trail_arn: std::option::Option<std::string::String>,
        pub(crate) insight_selectors:
            std::option::Option<std::vec::Vec<crate::model::InsightSelector>>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of a trail for which you want to get Insights selectors.</p>
        pub fn trail_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.trail_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of a trail for which you want to get Insights selectors.</p>
        pub fn set_trail_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.trail_arn = input;
            self
        }
        /// Appends an item to `insight_selectors`.
        ///
        /// To override the contents of this collection use [`set_insight_selectors`](Self::set_insight_selectors).
        ///
        /// <p>A JSON string that contains the insight types you want to log on a trail. In this release, <code>ApiErrorRateInsight</code> and <code>ApiCallRateInsight</code> are supported as insight types.</p>
        pub fn insight_selectors(mut self, input: crate::model::InsightSelector) -> Self {
            let mut v = self.insight_selectors.unwrap_or_default();
            v.push(input);
            self.insight_selectors = Some(v);
            self
        }
        /// <p>A JSON string that contains the insight types you want to log on a trail. In this release, <code>ApiErrorRateInsight</code> and <code>ApiCallRateInsight</code> are supported as insight types.</p>
        pub fn set_insight_selectors(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::InsightSelector>>,
        ) -> Self {
            self.insight_selectors = input;
            self
        }
        /// Consumes the builder and constructs a [`GetInsightSelectorsOutput`](crate::output::GetInsightSelectorsOutput)
        pub fn build(self) -> crate::output::GetInsightSelectorsOutput {
            crate::output::GetInsightSelectorsOutput {
                trail_arn: self.trail_arn,
                insight_selectors: self.insight_selectors,
            }
        }
    }
}
impl GetInsightSelectorsOutput {
    /// Creates a new builder-style object to manufacture [`GetInsightSelectorsOutput`](crate::output::GetInsightSelectorsOutput)
    pub fn builder() -> crate::output::get_insight_selectors_output::Builder {
        crate::output::get_insight_selectors_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetEventSelectorsOutput {
    /// <p>The specified trail ARN that has the event selectors.</p>
    pub trail_arn: std::option::Option<std::string::String>,
    /// <p>The event selectors that are configured for the trail.</p>
    pub event_selectors: std::option::Option<std::vec::Vec<crate::model::EventSelector>>,
    /// <p> The advanced event selectors that are configured for the trail. </p>
    pub advanced_event_selectors:
        std::option::Option<std::vec::Vec<crate::model::AdvancedEventSelector>>,
}
impl GetEventSelectorsOutput {
    /// <p>The specified trail ARN that has the event selectors.</p>
    pub fn trail_arn(&self) -> std::option::Option<&str> {
        self.trail_arn.as_deref()
    }
    /// <p>The event selectors that are configured for the trail.</p>
    pub fn event_selectors(&self) -> std::option::Option<&[crate::model::EventSelector]> {
        self.event_selectors.as_deref()
    }
    /// <p> The advanced event selectors that are configured for the trail. </p>
    pub fn advanced_event_selectors(
        &self,
    ) -> std::option::Option<&[crate::model::AdvancedEventSelector]> {
        self.advanced_event_selectors.as_deref()
    }
}
impl std::fmt::Debug for GetEventSelectorsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetEventSelectorsOutput");
        formatter.field("trail_arn", &self.trail_arn);
        formatter.field("event_selectors", &self.event_selectors);
        formatter.field("advanced_event_selectors", &self.advanced_event_selectors);
        formatter.finish()
    }
}
/// See [`GetEventSelectorsOutput`](crate::output::GetEventSelectorsOutput)
pub mod get_event_selectors_output {
    /// A builder for [`GetEventSelectorsOutput`](crate::output::GetEventSelectorsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) trail_arn: std::option::Option<std::string::String>,
        pub(crate) event_selectors: std::option::Option<std::vec::Vec<crate::model::EventSelector>>,
        pub(crate) advanced_event_selectors:
            std::option::Option<std::vec::Vec<crate::model::AdvancedEventSelector>>,
    }
    impl Builder {
        /// <p>The specified trail ARN that has the event selectors.</p>
        pub fn trail_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.trail_arn = Some(input.into());
            self
        }
        /// <p>The specified trail ARN that has the event selectors.</p>
        pub fn set_trail_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.trail_arn = input;
            self
        }
        /// Appends an item to `event_selectors`.
        ///
        /// To override the contents of this collection use [`set_event_selectors`](Self::set_event_selectors).
        ///
        /// <p>The event selectors that are configured for the trail.</p>
        pub fn event_selectors(mut self, input: crate::model::EventSelector) -> Self {
            let mut v = self.event_selectors.unwrap_or_default();
            v.push(input);
            self.event_selectors = Some(v);
            self
        }
        /// <p>The event selectors that are configured for the trail.</p>
        pub fn set_event_selectors(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::EventSelector>>,
        ) -> Self {
            self.event_selectors = input;
            self
        }
        /// Appends an item to `advanced_event_selectors`.
        ///
        /// To override the contents of this collection use [`set_advanced_event_selectors`](Self::set_advanced_event_selectors).
        ///
        /// <p> The advanced event selectors that are configured for the trail. </p>
        pub fn advanced_event_selectors(
            mut self,
            input: crate::model::AdvancedEventSelector,
        ) -> Self {
            let mut v = self.advanced_event_selectors.unwrap_or_default();
            v.push(input);
            self.advanced_event_selectors = Some(v);
            self
        }
        /// <p> The advanced event selectors that are configured for the trail. </p>
        pub fn set_advanced_event_selectors(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AdvancedEventSelector>>,
        ) -> Self {
            self.advanced_event_selectors = input;
            self
        }
        /// Consumes the builder and constructs a [`GetEventSelectorsOutput`](crate::output::GetEventSelectorsOutput)
        pub fn build(self) -> crate::output::GetEventSelectorsOutput {
            crate::output::GetEventSelectorsOutput {
                trail_arn: self.trail_arn,
                event_selectors: self.event_selectors,
                advanced_event_selectors: self.advanced_event_selectors,
            }
        }
    }
}
impl GetEventSelectorsOutput {
    /// Creates a new builder-style object to manufacture [`GetEventSelectorsOutput`](crate::output::GetEventSelectorsOutput)
    pub fn builder() -> crate::output::get_event_selectors_output::Builder {
        crate::output::get_event_selectors_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetEventDataStoreOutput {
    /// <p>The event data store Amazon Resource Number (ARN).</p>
    pub event_data_store_arn: std::option::Option<std::string::String>,
    /// <p>The name of the event data store.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The status of an event data store. Values can be <code>ENABLED</code> and <code>PENDING_DELETION</code>.</p>
    pub status: std::option::Option<crate::model::EventDataStoreStatus>,
    /// <p>The advanced event selectors used to select events for the data store.</p>
    pub advanced_event_selectors:
        std::option::Option<std::vec::Vec<crate::model::AdvancedEventSelector>>,
    /// <p>Indicates whether the event data store includes events from all regions, or only from the region in which it was created.</p>
    pub multi_region_enabled: std::option::Option<bool>,
    /// <p>Indicates whether an event data store is collecting logged events for an organization in Organizations.</p>
    pub organization_enabled: std::option::Option<bool>,
    /// <p>The retention period of the event data store, in days.</p>
    pub retention_period: std::option::Option<i32>,
    /// <p>Indicates that termination protection is enabled.</p>
    pub termination_protection_enabled: std::option::Option<bool>,
    /// <p>The timestamp of the event data store's creation.</p>
    pub created_timestamp: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>Shows the time that an event data store was updated, if applicable. <code>UpdatedTimestamp</code> is always either the same or newer than the time shown in <code>CreatedTimestamp</code>.</p>
    pub updated_timestamp: std::option::Option<aws_smithy_types::DateTime>,
}
impl GetEventDataStoreOutput {
    /// <p>The event data store Amazon Resource Number (ARN).</p>
    pub fn event_data_store_arn(&self) -> std::option::Option<&str> {
        self.event_data_store_arn.as_deref()
    }
    /// <p>The name of the event data store.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The status of an event data store. Values can be <code>ENABLED</code> and <code>PENDING_DELETION</code>.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::EventDataStoreStatus> {
        self.status.as_ref()
    }
    /// <p>The advanced event selectors used to select events for the data store.</p>
    pub fn advanced_event_selectors(
        &self,
    ) -> std::option::Option<&[crate::model::AdvancedEventSelector]> {
        self.advanced_event_selectors.as_deref()
    }
    /// <p>Indicates whether the event data store includes events from all regions, or only from the region in which it was created.</p>
    pub fn multi_region_enabled(&self) -> std::option::Option<bool> {
        self.multi_region_enabled
    }
    /// <p>Indicates whether an event data store is collecting logged events for an organization in Organizations.</p>
    pub fn organization_enabled(&self) -> std::option::Option<bool> {
        self.organization_enabled
    }
    /// <p>The retention period of the event data store, in days.</p>
    pub fn retention_period(&self) -> std::option::Option<i32> {
        self.retention_period
    }
    /// <p>Indicates that termination protection is enabled.</p>
    pub fn termination_protection_enabled(&self) -> std::option::Option<bool> {
        self.termination_protection_enabled
    }
    /// <p>The timestamp of the event data store's creation.</p>
    pub fn created_timestamp(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.created_timestamp.as_ref()
    }
    /// <p>Shows the time that an event data store was updated, if applicable. <code>UpdatedTimestamp</code> is always either the same or newer than the time shown in <code>CreatedTimestamp</code>.</p>
    pub fn updated_timestamp(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.updated_timestamp.as_ref()
    }
}
impl std::fmt::Debug for GetEventDataStoreOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetEventDataStoreOutput");
        formatter.field("event_data_store_arn", &self.event_data_store_arn);
        formatter.field("name", &self.name);
        formatter.field("status", &self.status);
        formatter.field("advanced_event_selectors", &self.advanced_event_selectors);
        formatter.field("multi_region_enabled", &self.multi_region_enabled);
        formatter.field("organization_enabled", &self.organization_enabled);
        formatter.field("retention_period", &self.retention_period);
        formatter.field(
            "termination_protection_enabled",
            &self.termination_protection_enabled,
        );
        formatter.field("created_timestamp", &self.created_timestamp);
        formatter.field("updated_timestamp", &self.updated_timestamp);
        formatter.finish()
    }
}
/// See [`GetEventDataStoreOutput`](crate::output::GetEventDataStoreOutput)
pub mod get_event_data_store_output {
    /// A builder for [`GetEventDataStoreOutput`](crate::output::GetEventDataStoreOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) event_data_store_arn: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::EventDataStoreStatus>,
        pub(crate) advanced_event_selectors:
            std::option::Option<std::vec::Vec<crate::model::AdvancedEventSelector>>,
        pub(crate) multi_region_enabled: std::option::Option<bool>,
        pub(crate) organization_enabled: std::option::Option<bool>,
        pub(crate) retention_period: std::option::Option<i32>,
        pub(crate) termination_protection_enabled: std::option::Option<bool>,
        pub(crate) created_timestamp: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) updated_timestamp: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The event data store Amazon Resource Number (ARN).</p>
        pub fn event_data_store_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.event_data_store_arn = Some(input.into());
            self
        }
        /// <p>The event data store Amazon Resource Number (ARN).</p>
        pub fn set_event_data_store_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.event_data_store_arn = input;
            self
        }
        /// <p>The name of the event data store.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the event data store.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The status of an event data store. Values can be <code>ENABLED</code> and <code>PENDING_DELETION</code>.</p>
        pub fn status(mut self, input: crate::model::EventDataStoreStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of an event data store. Values can be <code>ENABLED</code> and <code>PENDING_DELETION</code>.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::EventDataStoreStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// Appends an item to `advanced_event_selectors`.
        ///
        /// To override the contents of this collection use [`set_advanced_event_selectors`](Self::set_advanced_event_selectors).
        ///
        /// <p>The advanced event selectors used to select events for the data store.</p>
        pub fn advanced_event_selectors(
            mut self,
            input: crate::model::AdvancedEventSelector,
        ) -> Self {
            let mut v = self.advanced_event_selectors.unwrap_or_default();
            v.push(input);
            self.advanced_event_selectors = Some(v);
            self
        }
        /// <p>The advanced event selectors used to select events for the data store.</p>
        pub fn set_advanced_event_selectors(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AdvancedEventSelector>>,
        ) -> Self {
            self.advanced_event_selectors = input;
            self
        }
        /// <p>Indicates whether the event data store includes events from all regions, or only from the region in which it was created.</p>
        pub fn multi_region_enabled(mut self, input: bool) -> Self {
            self.multi_region_enabled = Some(input);
            self
        }
        /// <p>Indicates whether the event data store includes events from all regions, or only from the region in which it was created.</p>
        pub fn set_multi_region_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.multi_region_enabled = input;
            self
        }
        /// <p>Indicates whether an event data store is collecting logged events for an organization in Organizations.</p>
        pub fn organization_enabled(mut self, input: bool) -> Self {
            self.organization_enabled = Some(input);
            self
        }
        /// <p>Indicates whether an event data store is collecting logged events for an organization in Organizations.</p>
        pub fn set_organization_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.organization_enabled = input;
            self
        }
        /// <p>The retention period of the event data store, in days.</p>
        pub fn retention_period(mut self, input: i32) -> Self {
            self.retention_period = Some(input);
            self
        }
        /// <p>The retention period of the event data store, in days.</p>
        pub fn set_retention_period(mut self, input: std::option::Option<i32>) -> Self {
            self.retention_period = input;
            self
        }
        /// <p>Indicates that termination protection is enabled.</p>
        pub fn termination_protection_enabled(mut self, input: bool) -> Self {
            self.termination_protection_enabled = Some(input);
            self
        }
        /// <p>Indicates that termination protection is enabled.</p>
        pub fn set_termination_protection_enabled(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.termination_protection_enabled = input;
            self
        }
        /// <p>The timestamp of the event data store's creation.</p>
        pub fn created_timestamp(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.created_timestamp = Some(input);
            self
        }
        /// <p>The timestamp of the event data store's creation.</p>
        pub fn set_created_timestamp(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.created_timestamp = input;
            self
        }
        /// <p>Shows the time that an event data store was updated, if applicable. <code>UpdatedTimestamp</code> is always either the same or newer than the time shown in <code>CreatedTimestamp</code>.</p>
        pub fn updated_timestamp(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.updated_timestamp = Some(input);
            self
        }
        /// <p>Shows the time that an event data store was updated, if applicable. <code>UpdatedTimestamp</code> is always either the same or newer than the time shown in <code>CreatedTimestamp</code>.</p>
        pub fn set_updated_timestamp(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.updated_timestamp = input;
            self
        }
        /// Consumes the builder and constructs a [`GetEventDataStoreOutput`](crate::output::GetEventDataStoreOutput)
        pub fn build(self) -> crate::output::GetEventDataStoreOutput {
            crate::output::GetEventDataStoreOutput {
                event_data_store_arn: self.event_data_store_arn,
                name: self.name,
                status: self.status,
                advanced_event_selectors: self.advanced_event_selectors,
                multi_region_enabled: self.multi_region_enabled,
                organization_enabled: self.organization_enabled,
                retention_period: self.retention_period,
                termination_protection_enabled: self.termination_protection_enabled,
                created_timestamp: self.created_timestamp,
                updated_timestamp: self.updated_timestamp,
            }
        }
    }
}
impl GetEventDataStoreOutput {
    /// Creates a new builder-style object to manufacture [`GetEventDataStoreOutput`](crate::output::GetEventDataStoreOutput)
    pub fn builder() -> crate::output::get_event_data_store_output::Builder {
        crate::output::get_event_data_store_output::Builder::default()
    }
}

/// <p>Returns the objects or data listed below if successful. Otherwise, returns an error.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeTrailsOutput {
    /// <p>The list of trail objects. Trail objects with string values are only returned if values for the objects exist in a trail's configuration. For example, <code>SNSTopicName</code> and <code>SNSTopicARN</code> are only returned in results if a trail is configured to send SNS notifications. Similarly, <code>KMSKeyId</code> only appears in results if a trail's log files are encrypted with KMS customer managed keys.</p>
    pub trail_list: std::option::Option<std::vec::Vec<crate::model::Trail>>,
}
impl DescribeTrailsOutput {
    /// <p>The list of trail objects. Trail objects with string values are only returned if values for the objects exist in a trail's configuration. For example, <code>SNSTopicName</code> and <code>SNSTopicARN</code> are only returned in results if a trail is configured to send SNS notifications. Similarly, <code>KMSKeyId</code> only appears in results if a trail's log files are encrypted with KMS customer managed keys.</p>
    pub fn trail_list(&self) -> std::option::Option<&[crate::model::Trail]> {
        self.trail_list.as_deref()
    }
}
impl std::fmt::Debug for DescribeTrailsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeTrailsOutput");
        formatter.field("trail_list", &self.trail_list);
        formatter.finish()
    }
}
/// See [`DescribeTrailsOutput`](crate::output::DescribeTrailsOutput)
pub mod describe_trails_output {
    /// A builder for [`DescribeTrailsOutput`](crate::output::DescribeTrailsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) trail_list: std::option::Option<std::vec::Vec<crate::model::Trail>>,
    }
    impl Builder {
        /// Appends an item to `trail_list`.
        ///
        /// To override the contents of this collection use [`set_trail_list`](Self::set_trail_list).
        ///
        /// <p>The list of trail objects. Trail objects with string values are only returned if values for the objects exist in a trail's configuration. For example, <code>SNSTopicName</code> and <code>SNSTopicARN</code> are only returned in results if a trail is configured to send SNS notifications. Similarly, <code>KMSKeyId</code> only appears in results if a trail's log files are encrypted with KMS customer managed keys.</p>
        pub fn trail_list(mut self, input: crate::model::Trail) -> Self {
            let mut v = self.trail_list.unwrap_or_default();
            v.push(input);
            self.trail_list = Some(v);
            self
        }
        /// <p>The list of trail objects. Trail objects with string values are only returned if values for the objects exist in a trail's configuration. For example, <code>SNSTopicName</code> and <code>SNSTopicARN</code> are only returned in results if a trail is configured to send SNS notifications. Similarly, <code>KMSKeyId</code> only appears in results if a trail's log files are encrypted with KMS customer managed keys.</p>
        pub fn set_trail_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Trail>>,
        ) -> Self {
            self.trail_list = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeTrailsOutput`](crate::output::DescribeTrailsOutput)
        pub fn build(self) -> crate::output::DescribeTrailsOutput {
            crate::output::DescribeTrailsOutput {
                trail_list: self.trail_list,
            }
        }
    }
}
impl DescribeTrailsOutput {
    /// Creates a new builder-style object to manufacture [`DescribeTrailsOutput`](crate::output::DescribeTrailsOutput)
    pub fn builder() -> crate::output::describe_trails_output::Builder {
        crate::output::describe_trails_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeQueryOutput {
    /// <p>The ID of the query.</p>
    pub query_id: std::option::Option<std::string::String>,
    /// <p>The SQL code of a query.</p>
    pub query_string: std::option::Option<std::string::String>,
    /// <p>The status of a query. Values for <code>QueryStatus</code> include <code>QUEUED</code>, <code>RUNNING</code>, <code>FINISHED</code>, <code>FAILED</code>, or <code>CANCELLED</code> </p>
    pub query_status: std::option::Option<crate::model::QueryStatus>,
    /// <p>Metadata about a query, including the number of events that were matched, the total number of events scanned, the query run time in milliseconds, and the query's creation time.</p>
    pub query_statistics: std::option::Option<crate::model::QueryStatisticsForDescribeQuery>,
    /// <p>The error message returned if a query failed.</p>
    pub error_message: std::option::Option<std::string::String>,
}
impl DescribeQueryOutput {
    /// <p>The ID of the query.</p>
    pub fn query_id(&self) -> std::option::Option<&str> {
        self.query_id.as_deref()
    }
    /// <p>The SQL code of a query.</p>
    pub fn query_string(&self) -> std::option::Option<&str> {
        self.query_string.as_deref()
    }
    /// <p>The status of a query. Values for <code>QueryStatus</code> include <code>QUEUED</code>, <code>RUNNING</code>, <code>FINISHED</code>, <code>FAILED</code>, or <code>CANCELLED</code> </p>
    pub fn query_status(&self) -> std::option::Option<&crate::model::QueryStatus> {
        self.query_status.as_ref()
    }
    /// <p>Metadata about a query, including the number of events that were matched, the total number of events scanned, the query run time in milliseconds, and the query's creation time.</p>
    pub fn query_statistics(
        &self,
    ) -> std::option::Option<&crate::model::QueryStatisticsForDescribeQuery> {
        self.query_statistics.as_ref()
    }
    /// <p>The error message returned if a query failed.</p>
    pub fn error_message(&self) -> std::option::Option<&str> {
        self.error_message.as_deref()
    }
}
impl std::fmt::Debug for DescribeQueryOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeQueryOutput");
        formatter.field("query_id", &self.query_id);
        formatter.field("query_string", &self.query_string);
        formatter.field("query_status", &self.query_status);
        formatter.field("query_statistics", &self.query_statistics);
        formatter.field("error_message", &self.error_message);
        formatter.finish()
    }
}
/// See [`DescribeQueryOutput`](crate::output::DescribeQueryOutput)
pub mod describe_query_output {
    /// A builder for [`DescribeQueryOutput`](crate::output::DescribeQueryOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) query_id: std::option::Option<std::string::String>,
        pub(crate) query_string: std::option::Option<std::string::String>,
        pub(crate) query_status: std::option::Option<crate::model::QueryStatus>,
        pub(crate) query_statistics:
            std::option::Option<crate::model::QueryStatisticsForDescribeQuery>,
        pub(crate) error_message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the query.</p>
        pub fn query_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.query_id = Some(input.into());
            self
        }
        /// <p>The ID of the query.</p>
        pub fn set_query_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.query_id = input;
            self
        }
        /// <p>The SQL code of a query.</p>
        pub fn query_string(mut self, input: impl Into<std::string::String>) -> Self {
            self.query_string = Some(input.into());
            self
        }
        /// <p>The SQL code of a query.</p>
        pub fn set_query_string(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.query_string = input;
            self
        }
        /// <p>The status of a query. Values for <code>QueryStatus</code> include <code>QUEUED</code>, <code>RUNNING</code>, <code>FINISHED</code>, <code>FAILED</code>, or <code>CANCELLED</code> </p>
        pub fn query_status(mut self, input: crate::model::QueryStatus) -> Self {
            self.query_status = Some(input);
            self
        }
        /// <p>The status of a query. Values for <code>QueryStatus</code> include <code>QUEUED</code>, <code>RUNNING</code>, <code>FINISHED</code>, <code>FAILED</code>, or <code>CANCELLED</code> </p>
        pub fn set_query_status(
            mut self,
            input: std::option::Option<crate::model::QueryStatus>,
        ) -> Self {
            self.query_status = input;
            self
        }
        /// <p>Metadata about a query, including the number of events that were matched, the total number of events scanned, the query run time in milliseconds, and the query's creation time.</p>
        pub fn query_statistics(
            mut self,
            input: crate::model::QueryStatisticsForDescribeQuery,
        ) -> Self {
            self.query_statistics = Some(input);
            self
        }
        /// <p>Metadata about a query, including the number of events that were matched, the total number of events scanned, the query run time in milliseconds, and the query's creation time.</p>
        pub fn set_query_statistics(
            mut self,
            input: std::option::Option<crate::model::QueryStatisticsForDescribeQuery>,
        ) -> Self {
            self.query_statistics = input;
            self
        }
        /// <p>The error message returned if a query failed.</p>
        pub fn error_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.error_message = Some(input.into());
            self
        }
        /// <p>The error message returned if a query failed.</p>
        pub fn set_error_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.error_message = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeQueryOutput`](crate::output::DescribeQueryOutput)
        pub fn build(self) -> crate::output::DescribeQueryOutput {
            crate::output::DescribeQueryOutput {
                query_id: self.query_id,
                query_string: self.query_string,
                query_status: self.query_status,
                query_statistics: self.query_statistics,
                error_message: self.error_message,
            }
        }
    }
}
impl DescribeQueryOutput {
    /// Creates a new builder-style object to manufacture [`DescribeQueryOutput`](crate::output::DescribeQueryOutput)
    pub fn builder() -> crate::output::describe_query_output::Builder {
        crate::output::describe_query_output::Builder::default()
    }
}

/// <p>Returns the objects or data listed below if successful. Otherwise, returns an error.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteTrailOutput {}
impl std::fmt::Debug for DeleteTrailOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteTrailOutput");
        formatter.finish()
    }
}
/// See [`DeleteTrailOutput`](crate::output::DeleteTrailOutput)
pub mod delete_trail_output {
    /// A builder for [`DeleteTrailOutput`](crate::output::DeleteTrailOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteTrailOutput`](crate::output::DeleteTrailOutput)
        pub fn build(self) -> crate::output::DeleteTrailOutput {
            crate::output::DeleteTrailOutput {}
        }
    }
}
impl DeleteTrailOutput {
    /// Creates a new builder-style object to manufacture [`DeleteTrailOutput`](crate::output::DeleteTrailOutput)
    pub fn builder() -> crate::output::delete_trail_output::Builder {
        crate::output::delete_trail_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteEventDataStoreOutput {}
impl std::fmt::Debug for DeleteEventDataStoreOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteEventDataStoreOutput");
        formatter.finish()
    }
}
/// See [`DeleteEventDataStoreOutput`](crate::output::DeleteEventDataStoreOutput)
pub mod delete_event_data_store_output {
    /// A builder for [`DeleteEventDataStoreOutput`](crate::output::DeleteEventDataStoreOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteEventDataStoreOutput`](crate::output::DeleteEventDataStoreOutput)
        pub fn build(self) -> crate::output::DeleteEventDataStoreOutput {
            crate::output::DeleteEventDataStoreOutput {}
        }
    }
}
impl DeleteEventDataStoreOutput {
    /// Creates a new builder-style object to manufacture [`DeleteEventDataStoreOutput`](crate::output::DeleteEventDataStoreOutput)
    pub fn builder() -> crate::output::delete_event_data_store_output::Builder {
        crate::output::delete_event_data_store_output::Builder::default()
    }
}

/// <p>Returns the objects or data listed below if successful. Otherwise, returns an error.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateTrailOutput {
    /// <p>Specifies the name of the trail.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>Specifies the name of the Amazon S3 bucket designated for publishing log files.</p>
    pub s3_bucket_name: std::option::Option<std::string::String>,
    /// <p>Specifies the Amazon S3 key prefix that comes after the name of the bucket you have designated for log file delivery. For more information, see <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/cloudtrail-find-log-files.html">Finding Your CloudTrail Log Files</a>.</p>
    pub s3_key_prefix: std::option::Option<std::string::String>,
    /// <p>This field is no longer in use. Use SnsTopicARN.</p>
    pub sns_topic_name: std::option::Option<std::string::String>,
    /// <p>Specifies the ARN of the Amazon SNS topic that CloudTrail uses to send notifications when log files are delivered. The format of a topic ARN is:</p>
    /// <p> <code>arn:aws:sns:us-east-2:123456789012:MyTopic</code> </p>
    pub sns_topic_arn: std::option::Option<std::string::String>,
    /// <p>Specifies whether the trail is publishing events from global services such as IAM to the log files.</p>
    pub include_global_service_events: std::option::Option<bool>,
    /// <p>Specifies whether the trail exists in one region or in all regions.</p>
    pub is_multi_region_trail: std::option::Option<bool>,
    /// <p>Specifies the ARN of the trail that was created. The format of a trail ARN is:</p>
    /// <p> <code>arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail</code> </p>
    pub trail_arn: std::option::Option<std::string::String>,
    /// <p>Specifies whether log file integrity validation is enabled.</p>
    pub log_file_validation_enabled: std::option::Option<bool>,
    /// <p>Specifies the Amazon Resource Name (ARN) of the log group to which CloudTrail logs will be delivered.</p>
    pub cloud_watch_logs_log_group_arn: std::option::Option<std::string::String>,
    /// <p>Specifies the role for the CloudWatch Logs endpoint to assume to write to a user's log group.</p>
    pub cloud_watch_logs_role_arn: std::option::Option<std::string::String>,
    /// <p>Specifies the KMS key ID that encrypts the logs delivered by CloudTrail. The value is a fully specified ARN to a KMS key in the following format.</p>
    /// <p> <code>arn:aws:kms:us-east-2:123456789012:key/12345678-1234-1234-1234-123456789012</code> </p>
    pub kms_key_id: std::option::Option<std::string::String>,
    /// <p>Specifies whether the trail is an organization trail.</p>
    pub is_organization_trail: std::option::Option<bool>,
}
impl CreateTrailOutput {
    /// <p>Specifies the name of the trail.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>Specifies the name of the Amazon S3 bucket designated for publishing log files.</p>
    pub fn s3_bucket_name(&self) -> std::option::Option<&str> {
        self.s3_bucket_name.as_deref()
    }
    /// <p>Specifies the Amazon S3 key prefix that comes after the name of the bucket you have designated for log file delivery. For more information, see <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/cloudtrail-find-log-files.html">Finding Your CloudTrail Log Files</a>.</p>
    pub fn s3_key_prefix(&self) -> std::option::Option<&str> {
        self.s3_key_prefix.as_deref()
    }
    /// <p>This field is no longer in use. Use SnsTopicARN.</p>
    pub fn sns_topic_name(&self) -> std::option::Option<&str> {
        self.sns_topic_name.as_deref()
    }
    /// <p>Specifies the ARN of the Amazon SNS topic that CloudTrail uses to send notifications when log files are delivered. The format of a topic ARN is:</p>
    /// <p> <code>arn:aws:sns:us-east-2:123456789012:MyTopic</code> </p>
    pub fn sns_topic_arn(&self) -> std::option::Option<&str> {
        self.sns_topic_arn.as_deref()
    }
    /// <p>Specifies whether the trail is publishing events from global services such as IAM to the log files.</p>
    pub fn include_global_service_events(&self) -> std::option::Option<bool> {
        self.include_global_service_events
    }
    /// <p>Specifies whether the trail exists in one region or in all regions.</p>
    pub fn is_multi_region_trail(&self) -> std::option::Option<bool> {
        self.is_multi_region_trail
    }
    /// <p>Specifies the ARN of the trail that was created. The format of a trail ARN is:</p>
    /// <p> <code>arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail</code> </p>
    pub fn trail_arn(&self) -> std::option::Option<&str> {
        self.trail_arn.as_deref()
    }
    /// <p>Specifies whether log file integrity validation is enabled.</p>
    pub fn log_file_validation_enabled(&self) -> std::option::Option<bool> {
        self.log_file_validation_enabled
    }
    /// <p>Specifies the Amazon Resource Name (ARN) of the log group to which CloudTrail logs will be delivered.</p>
    pub fn cloud_watch_logs_log_group_arn(&self) -> std::option::Option<&str> {
        self.cloud_watch_logs_log_group_arn.as_deref()
    }
    /// <p>Specifies the role for the CloudWatch Logs endpoint to assume to write to a user's log group.</p>
    pub fn cloud_watch_logs_role_arn(&self) -> std::option::Option<&str> {
        self.cloud_watch_logs_role_arn.as_deref()
    }
    /// <p>Specifies the KMS key ID that encrypts the logs delivered by CloudTrail. The value is a fully specified ARN to a KMS key in the following format.</p>
    /// <p> <code>arn:aws:kms:us-east-2:123456789012:key/12345678-1234-1234-1234-123456789012</code> </p>
    pub fn kms_key_id(&self) -> std::option::Option<&str> {
        self.kms_key_id.as_deref()
    }
    /// <p>Specifies whether the trail is an organization trail.</p>
    pub fn is_organization_trail(&self) -> std::option::Option<bool> {
        self.is_organization_trail
    }
}
impl std::fmt::Debug for CreateTrailOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateTrailOutput");
        formatter.field("name", &self.name);
        formatter.field("s3_bucket_name", &self.s3_bucket_name);
        formatter.field("s3_key_prefix", &self.s3_key_prefix);
        formatter.field("sns_topic_name", &self.sns_topic_name);
        formatter.field("sns_topic_arn", &self.sns_topic_arn);
        formatter.field(
            "include_global_service_events",
            &self.include_global_service_events,
        );
        formatter.field("is_multi_region_trail", &self.is_multi_region_trail);
        formatter.field("trail_arn", &self.trail_arn);
        formatter.field(
            "log_file_validation_enabled",
            &self.log_file_validation_enabled,
        );
        formatter.field(
            "cloud_watch_logs_log_group_arn",
            &self.cloud_watch_logs_log_group_arn,
        );
        formatter.field("cloud_watch_logs_role_arn", &self.cloud_watch_logs_role_arn);
        formatter.field("kms_key_id", &self.kms_key_id);
        formatter.field("is_organization_trail", &self.is_organization_trail);
        formatter.finish()
    }
}
/// See [`CreateTrailOutput`](crate::output::CreateTrailOutput)
pub mod create_trail_output {
    /// A builder for [`CreateTrailOutput`](crate::output::CreateTrailOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) s3_bucket_name: std::option::Option<std::string::String>,
        pub(crate) s3_key_prefix: std::option::Option<std::string::String>,
        pub(crate) sns_topic_name: std::option::Option<std::string::String>,
        pub(crate) sns_topic_arn: std::option::Option<std::string::String>,
        pub(crate) include_global_service_events: std::option::Option<bool>,
        pub(crate) is_multi_region_trail: std::option::Option<bool>,
        pub(crate) trail_arn: std::option::Option<std::string::String>,
        pub(crate) log_file_validation_enabled: std::option::Option<bool>,
        pub(crate) cloud_watch_logs_log_group_arn: std::option::Option<std::string::String>,
        pub(crate) cloud_watch_logs_role_arn: std::option::Option<std::string::String>,
        pub(crate) kms_key_id: std::option::Option<std::string::String>,
        pub(crate) is_organization_trail: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>Specifies the name of the trail.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>Specifies the name of the trail.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>Specifies the name of the Amazon S3 bucket designated for publishing log files.</p>
        pub fn s3_bucket_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.s3_bucket_name = Some(input.into());
            self
        }
        /// <p>Specifies the name of the Amazon S3 bucket designated for publishing log files.</p>
        pub fn set_s3_bucket_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.s3_bucket_name = input;
            self
        }
        /// <p>Specifies the Amazon S3 key prefix that comes after the name of the bucket you have designated for log file delivery. For more information, see <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/cloudtrail-find-log-files.html">Finding Your CloudTrail Log Files</a>.</p>
        pub fn s3_key_prefix(mut self, input: impl Into<std::string::String>) -> Self {
            self.s3_key_prefix = Some(input.into());
            self
        }
        /// <p>Specifies the Amazon S3 key prefix that comes after the name of the bucket you have designated for log file delivery. For more information, see <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/cloudtrail-find-log-files.html">Finding Your CloudTrail Log Files</a>.</p>
        pub fn set_s3_key_prefix(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.s3_key_prefix = input;
            self
        }
        /// <p>This field is no longer in use. Use SnsTopicARN.</p>
        pub fn sns_topic_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.sns_topic_name = Some(input.into());
            self
        }
        /// <p>This field is no longer in use. Use SnsTopicARN.</p>
        pub fn set_sns_topic_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.sns_topic_name = input;
            self
        }
        /// <p>Specifies the ARN of the Amazon SNS topic that CloudTrail uses to send notifications when log files are delivered. The format of a topic ARN is:</p>
        /// <p> <code>arn:aws:sns:us-east-2:123456789012:MyTopic</code> </p>
        pub fn sns_topic_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.sns_topic_arn = Some(input.into());
            self
        }
        /// <p>Specifies the ARN of the Amazon SNS topic that CloudTrail uses to send notifications when log files are delivered. The format of a topic ARN is:</p>
        /// <p> <code>arn:aws:sns:us-east-2:123456789012:MyTopic</code> </p>
        pub fn set_sns_topic_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.sns_topic_arn = input;
            self
        }
        /// <p>Specifies whether the trail is publishing events from global services such as IAM to the log files.</p>
        pub fn include_global_service_events(mut self, input: bool) -> Self {
            self.include_global_service_events = Some(input);
            self
        }
        /// <p>Specifies whether the trail is publishing events from global services such as IAM to the log files.</p>
        pub fn set_include_global_service_events(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.include_global_service_events = input;
            self
        }
        /// <p>Specifies whether the trail exists in one region or in all regions.</p>
        pub fn is_multi_region_trail(mut self, input: bool) -> Self {
            self.is_multi_region_trail = Some(input);
            self
        }
        /// <p>Specifies whether the trail exists in one region or in all regions.</p>
        pub fn set_is_multi_region_trail(mut self, input: std::option::Option<bool>) -> Self {
            self.is_multi_region_trail = input;
            self
        }
        /// <p>Specifies the ARN of the trail that was created. The format of a trail ARN is:</p>
        /// <p> <code>arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail</code> </p>
        pub fn trail_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.trail_arn = Some(input.into());
            self
        }
        /// <p>Specifies the ARN of the trail that was created. The format of a trail ARN is:</p>
        /// <p> <code>arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail</code> </p>
        pub fn set_trail_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.trail_arn = input;
            self
        }
        /// <p>Specifies whether log file integrity validation is enabled.</p>
        pub fn log_file_validation_enabled(mut self, input: bool) -> Self {
            self.log_file_validation_enabled = Some(input);
            self
        }
        /// <p>Specifies whether log file integrity validation is enabled.</p>
        pub fn set_log_file_validation_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.log_file_validation_enabled = input;
            self
        }
        /// <p>Specifies the Amazon Resource Name (ARN) of the log group to which CloudTrail logs will be delivered.</p>
        pub fn cloud_watch_logs_log_group_arn(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.cloud_watch_logs_log_group_arn = Some(input.into());
            self
        }
        /// <p>Specifies the Amazon Resource Name (ARN) of the log group to which CloudTrail logs will be delivered.</p>
        pub fn set_cloud_watch_logs_log_group_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.cloud_watch_logs_log_group_arn = input;
            self
        }
        /// <p>Specifies the role for the CloudWatch Logs endpoint to assume to write to a user's log group.</p>
        pub fn cloud_watch_logs_role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.cloud_watch_logs_role_arn = Some(input.into());
            self
        }
        /// <p>Specifies the role for the CloudWatch Logs endpoint to assume to write to a user's log group.</p>
        pub fn set_cloud_watch_logs_role_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.cloud_watch_logs_role_arn = input;
            self
        }
        /// <p>Specifies the KMS key ID that encrypts the logs delivered by CloudTrail. The value is a fully specified ARN to a KMS key in the following format.</p>
        /// <p> <code>arn:aws:kms:us-east-2:123456789012:key/12345678-1234-1234-1234-123456789012</code> </p>
        pub fn kms_key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.kms_key_id = Some(input.into());
            self
        }
        /// <p>Specifies the KMS key ID that encrypts the logs delivered by CloudTrail. The value is a fully specified ARN to a KMS key in the following format.</p>
        /// <p> <code>arn:aws:kms:us-east-2:123456789012:key/12345678-1234-1234-1234-123456789012</code> </p>
        pub fn set_kms_key_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.kms_key_id = input;
            self
        }
        /// <p>Specifies whether the trail is an organization trail.</p>
        pub fn is_organization_trail(mut self, input: bool) -> Self {
            self.is_organization_trail = Some(input);
            self
        }
        /// <p>Specifies whether the trail is an organization trail.</p>
        pub fn set_is_organization_trail(mut self, input: std::option::Option<bool>) -> Self {
            self.is_organization_trail = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateTrailOutput`](crate::output::CreateTrailOutput)
        pub fn build(self) -> crate::output::CreateTrailOutput {
            crate::output::CreateTrailOutput {
                name: self.name,
                s3_bucket_name: self.s3_bucket_name,
                s3_key_prefix: self.s3_key_prefix,
                sns_topic_name: self.sns_topic_name,
                sns_topic_arn: self.sns_topic_arn,
                include_global_service_events: self.include_global_service_events,
                is_multi_region_trail: self.is_multi_region_trail,
                trail_arn: self.trail_arn,
                log_file_validation_enabled: self.log_file_validation_enabled,
                cloud_watch_logs_log_group_arn: self.cloud_watch_logs_log_group_arn,
                cloud_watch_logs_role_arn: self.cloud_watch_logs_role_arn,
                kms_key_id: self.kms_key_id,
                is_organization_trail: self.is_organization_trail,
            }
        }
    }
}
impl CreateTrailOutput {
    /// Creates a new builder-style object to manufacture [`CreateTrailOutput`](crate::output::CreateTrailOutput)
    pub fn builder() -> crate::output::create_trail_output::Builder {
        crate::output::create_trail_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateEventDataStoreOutput {
    /// <p>The ARN of the event data store.</p>
    pub event_data_store_arn: std::option::Option<std::string::String>,
    /// <p>The name of the event data store.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The status of event data store creation.</p>
    pub status: std::option::Option<crate::model::EventDataStoreStatus>,
    /// <p>The advanced event selectors that were used to select the events for the data store.</p>
    pub advanced_event_selectors:
        std::option::Option<std::vec::Vec<crate::model::AdvancedEventSelector>>,
    /// <p>Indicates whether the event data store collects events from all regions, or only from the region in which it was created.</p>
    pub multi_region_enabled: std::option::Option<bool>,
    /// <p>Indicates whether an event data store is collecting logged events for an organization in Organizations.</p>
    pub organization_enabled: std::option::Option<bool>,
    /// <p>The retention period of an event data store, in days.</p>
    pub retention_period: std::option::Option<i32>,
    /// <p>Indicates whether termination protection is enabled for the event data store.</p>
    pub termination_protection_enabled: std::option::Option<bool>,
    /// <p>A list of tags.</p>
    pub tags_list: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    /// <p>The timestamp that shows when the event data store was created.</p>
    pub created_timestamp: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The timestamp that shows when an event data store was updated, if applicable. <code>UpdatedTimestamp</code> is always either the same or newer than the time shown in <code>CreatedTimestamp</code>.</p>
    pub updated_timestamp: std::option::Option<aws_smithy_types::DateTime>,
}
impl CreateEventDataStoreOutput {
    /// <p>The ARN of the event data store.</p>
    pub fn event_data_store_arn(&self) -> std::option::Option<&str> {
        self.event_data_store_arn.as_deref()
    }
    /// <p>The name of the event data store.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The status of event data store creation.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::EventDataStoreStatus> {
        self.status.as_ref()
    }
    /// <p>The advanced event selectors that were used to select the events for the data store.</p>
    pub fn advanced_event_selectors(
        &self,
    ) -> std::option::Option<&[crate::model::AdvancedEventSelector]> {
        self.advanced_event_selectors.as_deref()
    }
    /// <p>Indicates whether the event data store collects events from all regions, or only from the region in which it was created.</p>
    pub fn multi_region_enabled(&self) -> std::option::Option<bool> {
        self.multi_region_enabled
    }
    /// <p>Indicates whether an event data store is collecting logged events for an organization in Organizations.</p>
    pub fn organization_enabled(&self) -> std::option::Option<bool> {
        self.organization_enabled
    }
    /// <p>The retention period of an event data store, in days.</p>
    pub fn retention_period(&self) -> std::option::Option<i32> {
        self.retention_period
    }
    /// <p>Indicates whether termination protection is enabled for the event data store.</p>
    pub fn termination_protection_enabled(&self) -> std::option::Option<bool> {
        self.termination_protection_enabled
    }
    /// <p>A list of tags.</p>
    pub fn tags_list(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags_list.as_deref()
    }
    /// <p>The timestamp that shows when the event data store was created.</p>
    pub fn created_timestamp(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.created_timestamp.as_ref()
    }
    /// <p>The timestamp that shows when an event data store was updated, if applicable. <code>UpdatedTimestamp</code> is always either the same or newer than the time shown in <code>CreatedTimestamp</code>.</p>
    pub fn updated_timestamp(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.updated_timestamp.as_ref()
    }
}
impl std::fmt::Debug for CreateEventDataStoreOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateEventDataStoreOutput");
        formatter.field("event_data_store_arn", &self.event_data_store_arn);
        formatter.field("name", &self.name);
        formatter.field("status", &self.status);
        formatter.field("advanced_event_selectors", &self.advanced_event_selectors);
        formatter.field("multi_region_enabled", &self.multi_region_enabled);
        formatter.field("organization_enabled", &self.organization_enabled);
        formatter.field("retention_period", &self.retention_period);
        formatter.field(
            "termination_protection_enabled",
            &self.termination_protection_enabled,
        );
        formatter.field("tags_list", &self.tags_list);
        formatter.field("created_timestamp", &self.created_timestamp);
        formatter.field("updated_timestamp", &self.updated_timestamp);
        formatter.finish()
    }
}
/// See [`CreateEventDataStoreOutput`](crate::output::CreateEventDataStoreOutput)
pub mod create_event_data_store_output {
    /// A builder for [`CreateEventDataStoreOutput`](crate::output::CreateEventDataStoreOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) event_data_store_arn: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::EventDataStoreStatus>,
        pub(crate) advanced_event_selectors:
            std::option::Option<std::vec::Vec<crate::model::AdvancedEventSelector>>,
        pub(crate) multi_region_enabled: std::option::Option<bool>,
        pub(crate) organization_enabled: std::option::Option<bool>,
        pub(crate) retention_period: std::option::Option<i32>,
        pub(crate) termination_protection_enabled: std::option::Option<bool>,
        pub(crate) tags_list: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        pub(crate) created_timestamp: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) updated_timestamp: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The ARN of the event data store.</p>
        pub fn event_data_store_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.event_data_store_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the event data store.</p>
        pub fn set_event_data_store_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.event_data_store_arn = input;
            self
        }
        /// <p>The name of the event data store.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the event data store.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The status of event data store creation.</p>
        pub fn status(mut self, input: crate::model::EventDataStoreStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of event data store creation.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::EventDataStoreStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// Appends an item to `advanced_event_selectors`.
        ///
        /// To override the contents of this collection use [`set_advanced_event_selectors`](Self::set_advanced_event_selectors).
        ///
        /// <p>The advanced event selectors that were used to select the events for the data store.</p>
        pub fn advanced_event_selectors(
            mut self,
            input: crate::model::AdvancedEventSelector,
        ) -> Self {
            let mut v = self.advanced_event_selectors.unwrap_or_default();
            v.push(input);
            self.advanced_event_selectors = Some(v);
            self
        }
        /// <p>The advanced event selectors that were used to select the events for the data store.</p>
        pub fn set_advanced_event_selectors(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AdvancedEventSelector>>,
        ) -> Self {
            self.advanced_event_selectors = input;
            self
        }
        /// <p>Indicates whether the event data store collects events from all regions, or only from the region in which it was created.</p>
        pub fn multi_region_enabled(mut self, input: bool) -> Self {
            self.multi_region_enabled = Some(input);
            self
        }
        /// <p>Indicates whether the event data store collects events from all regions, or only from the region in which it was created.</p>
        pub fn set_multi_region_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.multi_region_enabled = input;
            self
        }
        /// <p>Indicates whether an event data store is collecting logged events for an organization in Organizations.</p>
        pub fn organization_enabled(mut self, input: bool) -> Self {
            self.organization_enabled = Some(input);
            self
        }
        /// <p>Indicates whether an event data store is collecting logged events for an organization in Organizations.</p>
        pub fn set_organization_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.organization_enabled = input;
            self
        }
        /// <p>The retention period of an event data store, in days.</p>
        pub fn retention_period(mut self, input: i32) -> Self {
            self.retention_period = Some(input);
            self
        }
        /// <p>The retention period of an event data store, in days.</p>
        pub fn set_retention_period(mut self, input: std::option::Option<i32>) -> Self {
            self.retention_period = input;
            self
        }
        /// <p>Indicates whether termination protection is enabled for the event data store.</p>
        pub fn termination_protection_enabled(mut self, input: bool) -> Self {
            self.termination_protection_enabled = Some(input);
            self
        }
        /// <p>Indicates whether termination protection is enabled for the event data store.</p>
        pub fn set_termination_protection_enabled(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.termination_protection_enabled = input;
            self
        }
        /// Appends an item to `tags_list`.
        ///
        /// To override the contents of this collection use [`set_tags_list`](Self::set_tags_list).
        ///
        /// <p>A list of tags.</p>
        pub fn tags_list(mut self, input: crate::model::Tag) -> Self {
            let mut v = self.tags_list.unwrap_or_default();
            v.push(input);
            self.tags_list = Some(v);
            self
        }
        /// <p>A list of tags.</p>
        pub fn set_tags_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags_list = input;
            self
        }
        /// <p>The timestamp that shows when the event data store was created.</p>
        pub fn created_timestamp(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.created_timestamp = Some(input);
            self
        }
        /// <p>The timestamp that shows when the event data store was created.</p>
        pub fn set_created_timestamp(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.created_timestamp = input;
            self
        }
        /// <p>The timestamp that shows when an event data store was updated, if applicable. <code>UpdatedTimestamp</code> is always either the same or newer than the time shown in <code>CreatedTimestamp</code>.</p>
        pub fn updated_timestamp(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.updated_timestamp = Some(input);
            self
        }
        /// <p>The timestamp that shows when an event data store was updated, if applicable. <code>UpdatedTimestamp</code> is always either the same or newer than the time shown in <code>CreatedTimestamp</code>.</p>
        pub fn set_updated_timestamp(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.updated_timestamp = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateEventDataStoreOutput`](crate::output::CreateEventDataStoreOutput)
        pub fn build(self) -> crate::output::CreateEventDataStoreOutput {
            crate::output::CreateEventDataStoreOutput {
                event_data_store_arn: self.event_data_store_arn,
                name: self.name,
                status: self.status,
                advanced_event_selectors: self.advanced_event_selectors,
                multi_region_enabled: self.multi_region_enabled,
                organization_enabled: self.organization_enabled,
                retention_period: self.retention_period,
                termination_protection_enabled: self.termination_protection_enabled,
                tags_list: self.tags_list,
                created_timestamp: self.created_timestamp,
                updated_timestamp: self.updated_timestamp,
            }
        }
    }
}
impl CreateEventDataStoreOutput {
    /// Creates a new builder-style object to manufacture [`CreateEventDataStoreOutput`](crate::output::CreateEventDataStoreOutput)
    pub fn builder() -> crate::output::create_event_data_store_output::Builder {
        crate::output::create_event_data_store_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CancelQueryOutput {
    /// <p>The ID of the canceled query.</p>
    pub query_id: std::option::Option<std::string::String>,
    /// <p>Shows the status of a query after a <code>CancelQuery</code> request. Typically, the values shown are either <code>RUNNING</code> or <code>CANCELLED</code>.</p>
    pub query_status: std::option::Option<crate::model::QueryStatus>,
}
impl CancelQueryOutput {
    /// <p>The ID of the canceled query.</p>
    pub fn query_id(&self) -> std::option::Option<&str> {
        self.query_id.as_deref()
    }
    /// <p>Shows the status of a query after a <code>CancelQuery</code> request. Typically, the values shown are either <code>RUNNING</code> or <code>CANCELLED</code>.</p>
    pub fn query_status(&self) -> std::option::Option<&crate::model::QueryStatus> {
        self.query_status.as_ref()
    }
}
impl std::fmt::Debug for CancelQueryOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CancelQueryOutput");
        formatter.field("query_id", &self.query_id);
        formatter.field("query_status", &self.query_status);
        formatter.finish()
    }
}
/// See [`CancelQueryOutput`](crate::output::CancelQueryOutput)
pub mod cancel_query_output {
    /// A builder for [`CancelQueryOutput`](crate::output::CancelQueryOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) query_id: std::option::Option<std::string::String>,
        pub(crate) query_status: std::option::Option<crate::model::QueryStatus>,
    }
    impl Builder {
        /// <p>The ID of the canceled query.</p>
        pub fn query_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.query_id = Some(input.into());
            self
        }
        /// <p>The ID of the canceled query.</p>
        pub fn set_query_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.query_id = input;
            self
        }
        /// <p>Shows the status of a query after a <code>CancelQuery</code> request. Typically, the values shown are either <code>RUNNING</code> or <code>CANCELLED</code>.</p>
        pub fn query_status(mut self, input: crate::model::QueryStatus) -> Self {
            self.query_status = Some(input);
            self
        }
        /// <p>Shows the status of a query after a <code>CancelQuery</code> request. Typically, the values shown are either <code>RUNNING</code> or <code>CANCELLED</code>.</p>
        pub fn set_query_status(
            mut self,
            input: std::option::Option<crate::model::QueryStatus>,
        ) -> Self {
            self.query_status = input;
            self
        }
        /// Consumes the builder and constructs a [`CancelQueryOutput`](crate::output::CancelQueryOutput)
        pub fn build(self) -> crate::output::CancelQueryOutput {
            crate::output::CancelQueryOutput {
                query_id: self.query_id,
                query_status: self.query_status,
            }
        }
    }
}
impl CancelQueryOutput {
    /// Creates a new builder-style object to manufacture [`CancelQueryOutput`](crate::output::CancelQueryOutput)
    pub fn builder() -> crate::output::cancel_query_output::Builder {
        crate::output::cancel_query_output::Builder::default()
    }
}

/// <p>Returns the objects or data if successful. Otherwise, returns an error.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AddTagsOutput {}
impl std::fmt::Debug for AddTagsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AddTagsOutput");
        formatter.finish()
    }
}
/// See [`AddTagsOutput`](crate::output::AddTagsOutput)
pub mod add_tags_output {
    /// A builder for [`AddTagsOutput`](crate::output::AddTagsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`AddTagsOutput`](crate::output::AddTagsOutput)
        pub fn build(self) -> crate::output::AddTagsOutput {
            crate::output::AddTagsOutput {}
        }
    }
}
impl AddTagsOutput {
    /// Creates a new builder-style object to manufacture [`AddTagsOutput`](crate::output::AddTagsOutput)
    pub fn builder() -> crate::output::add_tags_output::Builder {
        crate::output::add_tags_output::Builder::default()
    }
}
