// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// <p>Advanced event selectors let you create fine-grained selectors for the following CloudTrail event record ﬁelds. They help you control costs by logging only those events that are important to you. For more information about advanced event selectors, see <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/logging-data-events-with-cloudtrail.html">Logging data events for trails</a> in the <i>CloudTrail User Guide</i>.</p>
/// <ul>
/// <li> <p> <code>readOnly</code> </p> </li>
/// <li> <p> <code>eventSource</code> </p> </li>
/// <li> <p> <code>eventName</code> </p> </li>
/// <li> <p> <code>eventCategory</code> </p> </li>
/// <li> <p> <code>resources.type</code> </p> </li>
/// <li> <p> <code>resources.ARN</code> </p> </li>
/// </ul>
/// <p>You cannot apply both event selectors and advanced event selectors to a trail.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AdvancedEventSelector {
    /// <p>An optional, descriptive name for an advanced event selector, such as "Log data events for only two S3 buckets".</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>Contains all selector statements in an advanced event selector.</p>
    pub field_selectors: std::option::Option<std::vec::Vec<crate::model::AdvancedFieldSelector>>,
}
impl AdvancedEventSelector {
    /// <p>An optional, descriptive name for an advanced event selector, such as "Log data events for only two S3 buckets".</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>Contains all selector statements in an advanced event selector.</p>
    pub fn field_selectors(&self) -> std::option::Option<&[crate::model::AdvancedFieldSelector]> {
        self.field_selectors.as_deref()
    }
}
impl std::fmt::Debug for AdvancedEventSelector {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AdvancedEventSelector");
        formatter.field("name", &self.name);
        formatter.field("field_selectors", &self.field_selectors);
        formatter.finish()
    }
}
/// See [`AdvancedEventSelector`](crate::model::AdvancedEventSelector)
pub mod advanced_event_selector {
    /// A builder for [`AdvancedEventSelector`](crate::model::AdvancedEventSelector)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) field_selectors:
            std::option::Option<std::vec::Vec<crate::model::AdvancedFieldSelector>>,
    }
    impl Builder {
        /// <p>An optional, descriptive name for an advanced event selector, such as "Log data events for only two S3 buckets".</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>An optional, descriptive name for an advanced event selector, such as "Log data events for only two S3 buckets".</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Appends an item to `field_selectors`.
        ///
        /// To override the contents of this collection use [`set_field_selectors`](Self::set_field_selectors).
        ///
        /// <p>Contains all selector statements in an advanced event selector.</p>
        pub fn field_selectors(mut self, input: crate::model::AdvancedFieldSelector) -> Self {
            let mut v = self.field_selectors.unwrap_or_default();
            v.push(input);
            self.field_selectors = Some(v);
            self
        }
        /// <p>Contains all selector statements in an advanced event selector.</p>
        pub fn set_field_selectors(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AdvancedFieldSelector>>,
        ) -> Self {
            self.field_selectors = input;
            self
        }
        /// Consumes the builder and constructs a [`AdvancedEventSelector`](crate::model::AdvancedEventSelector)
        pub fn build(self) -> crate::model::AdvancedEventSelector {
            crate::model::AdvancedEventSelector {
                name: self.name,
                field_selectors: self.field_selectors,
            }
        }
    }
}
impl AdvancedEventSelector {
    /// Creates a new builder-style object to manufacture [`AdvancedEventSelector`](crate::model::AdvancedEventSelector)
    pub fn builder() -> crate::model::advanced_event_selector::Builder {
        crate::model::advanced_event_selector::Builder::default()
    }
}

/// <p>A single selector statement in an advanced event selector.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AdvancedFieldSelector {
    /// <p> A field in an event record on which to filter events to be logged. Supported fields include <code>readOnly</code>, <code>eventCategory</code>, <code>eventSource</code> (for management events), <code>eventName</code>, <code>resources.type</code>, and <code>resources.ARN</code>. </p>
    /// <ul>
    /// <li> <p> <b> <code>readOnly</code> </b> - Optional. Can be set to <code>Equals</code> a value of <code>true</code> or <code>false</code>. If you do not add this field, CloudTrail logs both both <code>read</code> and <code>write</code> events. A value of <code>true</code> logs only <code>read</code> events. A value of <code>false</code> logs only <code>write</code> events.</p> </li>
    /// <li> <p> <b> <code>eventSource</code> </b> - For filtering management events only. This can be set only to <code>NotEquals</code> <code>kms.amazonaws.com</code>.</p> </li>
    /// <li> <p> <b> <code>eventName</code> </b> - Can use any operator. You can use it to ﬁlter in or ﬁlter out any data event logged to CloudTrail, such as <code>PutBucket</code> or <code>GetSnapshotBlock</code>. You can have multiple values for this ﬁeld, separated by commas.</p> </li>
    /// <li> <p> <b> <code>eventCategory</code> </b> - This is required. It must be set to <code>Equals</code>, and the value must be <code>Management</code> or <code>Data</code>.</p> </li>
    /// <li> <p> <b> <code>resources.type</code> </b> - This ﬁeld is required. <code>resources.type</code> can only use the <code>Equals</code> operator, and the value can be one of the following:</p>
    /// <ul>
    /// <li> <p> <code>AWS::S3::Object</code> </p> </li>
    /// <li> <p> <code>AWS::Lambda::Function</code> </p> </li>
    /// <li> <p> <code>AWS::DynamoDB::Table</code> </p> </li>
    /// <li> <p> <code>AWS::S3Outposts::Object</code> </p> </li>
    /// <li> <p> <code>AWS::ManagedBlockchain::Node</code> </p> </li>
    /// <li> <p> <code>AWS::S3ObjectLambda::AccessPoint</code> </p> </li>
    /// <li> <p> <code>AWS::EC2::Snapshot</code> </p> </li>
    /// <li> <p> <code>AWS::S3::AccessPoint</code> </p> </li>
    /// <li> <p> <code>AWS::DynamoDB::Stream</code> </p> </li>
    /// <li> <p> <code>AWS::Glue::Table</code> </p> </li>
    /// </ul> <p> You can have only one <code>resources.type</code> ﬁeld per selector. To log data events on more than one resource type, add another selector.</p> </li>
    /// <li> <p> <b> <code>resources.ARN</code> </b> - You can use any operator with <code>resources.ARN</code>, but if you use <code>Equals</code> or <code>NotEquals</code>, the value must exactly match the ARN of a valid resource of the type you've speciﬁed in the template as the value of resources.type. For example, if resources.type equals <code>AWS::S3::Object</code>, the ARN must be in one of the following formats. To log all data events for all objects in a specific S3 bucket, use the <code>StartsWith</code> operator, and include only the bucket ARN as the matching value.</p> <p>The trailing slash is intentional; do not exclude it. Replace the text between less than and greater than symbols (&lt;&gt;) with resource-specific information. </p>
    /// <ul>
    /// <li> <p> <code>arn:
    /// <partition>
    /// :s3:::
    /// <bucket_name>
    /// /
    /// </bucket_name>
    /// </partition></code> </p> </li>
    /// <li> <p> <code>arn:
    /// <partition>
    /// :s3:::
    /// <bucket_name>
    /// /
    /// <object_path>
    /// /
    /// </object_path>
    /// </bucket_name>
    /// </partition></code> </p> </li>
    /// </ul> <p>When <code>resources.type</code> equals <code>AWS::S3::AccessPoint</code>, and the operator is set to <code>Equals</code> or <code>NotEquals</code>, the ARN must be in one of the following formats. To log events on all objects in an S3 access point, we recommend that you use only the access point ARN, don’t include the object path, and use the <code>StartsWith</code> or <code>NotStartsWith</code> operators.</p>
    /// <ul>
    /// <li> <p> <code>arn:
    /// <partition>
    /// :s3:
    /// <region>
    /// :
    /// <account_id>
    /// :accesspoint/
    /// <access_point_name></access_point_name>
    /// </account_id>
    /// </region>
    /// </partition></code> </p> </li>
    /// <li> <p> <code>arn:
    /// <partition>
    /// :s3:
    /// <region>
    /// :
    /// <account_id>
    /// :accesspoint/
    /// <access_point_name>
    /// /object/
    /// <object_path></object_path>
    /// </access_point_name>
    /// </account_id>
    /// </region>
    /// </partition></code> </p> </li>
    /// </ul> <p>When resources.type equals <code>AWS::Lambda::Function</code>, and the operator is set to <code>Equals</code> or <code>NotEquals</code>, the ARN must be in the following format:</p>
    /// <ul>
    /// <li> <p> <code>arn:
    /// <partition>
    /// :lambda:
    /// <region>
    /// :
    /// <account_id>
    /// :function:
    /// <function_name></function_name>
    /// </account_id>
    /// </region>
    /// </partition></code> </p> </li>
    /// </ul> <p>When resources.type equals <code>AWS::DynamoDB::Table</code>, and the operator is set to <code>Equals</code> or <code>NotEquals</code>, the ARN must be in the following format:</p>
    /// <ul>
    /// <li> <p> <code>arn:
    /// <partition>
    /// :dynamodb:
    /// <region>
    /// :
    /// <account_id>
    /// :table/
    /// <table_name></table_name>
    /// </account_id>
    /// </region>
    /// </partition></code> </p> </li>
    /// </ul> <p>When <code>resources.type</code> equals <code>AWS::S3Outposts::Object</code>, and the operator is set to <code>Equals</code> or <code>NotEquals</code>, the ARN must be in the following format:</p>
    /// <ul>
    /// <li> <p> <code>arn:
    /// <partition>
    /// :s3-outposts:
    /// <region>
    /// :
    /// <account_id>
    /// :
    /// <object_path></object_path>
    /// </account_id>
    /// </region>
    /// </partition></code> </p> </li>
    /// </ul> <p>When <code>resources.type</code> equals <code>AWS::ManagedBlockchain::Node</code>, and the operator is set to <code>Equals</code> or <code>NotEquals</code>, the ARN must be in the following format:</p>
    /// <ul>
    /// <li> <p> <code>arn:
    /// <partition>
    /// :managedblockchain:
    /// <region>
    /// :
    /// <account_id>
    /// :nodes/
    /// <node_id></node_id>
    /// </account_id>
    /// </region>
    /// </partition></code> </p> </li>
    /// </ul> <p>When <code>resources.type</code> equals <code>AWS::S3ObjectLambda::AccessPoint</code>, and the operator is set to <code>Equals</code> or <code>NotEquals</code>, the ARN must be in the following format:</p>
    /// <ul>
    /// <li> <p> <code>arn:
    /// <partition>
    /// :s3-object-lambda:
    /// <region>
    /// :
    /// <account_id>
    /// :accesspoint/
    /// <access_point_name></access_point_name>
    /// </account_id>
    /// </region>
    /// </partition></code> </p> </li>
    /// </ul> <p>When <code>resources.type</code> equals <code>AWS::EC2::Snapshot</code>, and the operator is set to <code>Equals</code> or <code>NotEquals</code>, the ARN must be in the following format:</p>
    /// <ul>
    /// <li> <p> <code>arn:
    /// <partition>
    /// :ec2:
    /// <region>
    /// ::snapshot/
    /// <snapshot_id></snapshot_id>
    /// </region>
    /// </partition></code> </p> </li>
    /// </ul> <p>When <code>resources.type</code> equals <code>AWS::DynamoDB::Stream</code>, and the operator is set to <code>Equals</code> or <code>NotEquals</code>, the ARN must be in the following format:</p>
    /// <ul>
    /// <li> <p> <code>arn:
    /// <partition>
    /// :dynamodb:
    /// <region>
    /// :
    /// <account_id>
    /// :table/
    /// <table_name>
    /// /stream/
    /// <date_time></date_time>
    /// </table_name>
    /// </account_id>
    /// </region>
    /// </partition></code> </p> </li>
    /// </ul> <p>When <code>resources.type</code> equals <code>AWS::Glue::Table</code>, and the operator is set to <code>Equals</code> or <code>NotEquals</code>, the ARN must be in the following format:</p>
    /// <ul>
    /// <li> <p> <code>arn:
    /// <partition>
    /// :glue:
    /// <region>
    /// :
    /// <account_id>
    /// :table/
    /// <database_name>
    /// /
    /// <table_name></table_name>
    /// </database_name>
    /// </account_id>
    /// </region>
    /// </partition></code> </p> </li>
    /// </ul> </li>
    /// </ul>
    pub field: std::option::Option<std::string::String>,
    /// <p> An operator that includes events that match the exact value of the event record field specified as the value of <code>Field</code>. This is the only valid operator that you can use with the <code>readOnly</code>, <code>eventCategory</code>, and <code>resources.type</code> fields.</p>
    pub equals: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>An operator that includes events that match the first few characters of the event record field specified as the value of <code>Field</code>.</p>
    pub starts_with: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>An operator that includes events that match the last few characters of the event record field specified as the value of <code>Field</code>.</p>
    pub ends_with: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p> An operator that excludes events that match the exact value of the event record field specified as the value of <code>Field</code>. </p>
    pub not_equals: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p> An operator that excludes events that match the first few characters of the event record field specified as the value of <code>Field</code>. </p>
    pub not_starts_with: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p> An operator that excludes events that match the last few characters of the event record field specified as the value of <code>Field</code>. </p>
    pub not_ends_with: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl AdvancedFieldSelector {
    /// <p> A field in an event record on which to filter events to be logged. Supported fields include <code>readOnly</code>, <code>eventCategory</code>, <code>eventSource</code> (for management events), <code>eventName</code>, <code>resources.type</code>, and <code>resources.ARN</code>. </p>
    /// <ul>
    /// <li> <p> <b> <code>readOnly</code> </b> - Optional. Can be set to <code>Equals</code> a value of <code>true</code> or <code>false</code>. If you do not add this field, CloudTrail logs both both <code>read</code> and <code>write</code> events. A value of <code>true</code> logs only <code>read</code> events. A value of <code>false</code> logs only <code>write</code> events.</p> </li>
    /// <li> <p> <b> <code>eventSource</code> </b> - For filtering management events only. This can be set only to <code>NotEquals</code> <code>kms.amazonaws.com</code>.</p> </li>
    /// <li> <p> <b> <code>eventName</code> </b> - Can use any operator. You can use it to ﬁlter in or ﬁlter out any data event logged to CloudTrail, such as <code>PutBucket</code> or <code>GetSnapshotBlock</code>. You can have multiple values for this ﬁeld, separated by commas.</p> </li>
    /// <li> <p> <b> <code>eventCategory</code> </b> - This is required. It must be set to <code>Equals</code>, and the value must be <code>Management</code> or <code>Data</code>.</p> </li>
    /// <li> <p> <b> <code>resources.type</code> </b> - This ﬁeld is required. <code>resources.type</code> can only use the <code>Equals</code> operator, and the value can be one of the following:</p>
    /// <ul>
    /// <li> <p> <code>AWS::S3::Object</code> </p> </li>
    /// <li> <p> <code>AWS::Lambda::Function</code> </p> </li>
    /// <li> <p> <code>AWS::DynamoDB::Table</code> </p> </li>
    /// <li> <p> <code>AWS::S3Outposts::Object</code> </p> </li>
    /// <li> <p> <code>AWS::ManagedBlockchain::Node</code> </p> </li>
    /// <li> <p> <code>AWS::S3ObjectLambda::AccessPoint</code> </p> </li>
    /// <li> <p> <code>AWS::EC2::Snapshot</code> </p> </li>
    /// <li> <p> <code>AWS::S3::AccessPoint</code> </p> </li>
    /// <li> <p> <code>AWS::DynamoDB::Stream</code> </p> </li>
    /// <li> <p> <code>AWS::Glue::Table</code> </p> </li>
    /// </ul> <p> You can have only one <code>resources.type</code> ﬁeld per selector. To log data events on more than one resource type, add another selector.</p> </li>
    /// <li> <p> <b> <code>resources.ARN</code> </b> - You can use any operator with <code>resources.ARN</code>, but if you use <code>Equals</code> or <code>NotEquals</code>, the value must exactly match the ARN of a valid resource of the type you've speciﬁed in the template as the value of resources.type. For example, if resources.type equals <code>AWS::S3::Object</code>, the ARN must be in one of the following formats. To log all data events for all objects in a specific S3 bucket, use the <code>StartsWith</code> operator, and include only the bucket ARN as the matching value.</p> <p>The trailing slash is intentional; do not exclude it. Replace the text between less than and greater than symbols (&lt;&gt;) with resource-specific information. </p>
    /// <ul>
    /// <li> <p> <code>arn:
    /// <partition>
    /// :s3:::
    /// <bucket_name>
    /// /
    /// </bucket_name>
    /// </partition></code> </p> </li>
    /// <li> <p> <code>arn:
    /// <partition>
    /// :s3:::
    /// <bucket_name>
    /// /
    /// <object_path>
    /// /
    /// </object_path>
    /// </bucket_name>
    /// </partition></code> </p> </li>
    /// </ul> <p>When <code>resources.type</code> equals <code>AWS::S3::AccessPoint</code>, and the operator is set to <code>Equals</code> or <code>NotEquals</code>, the ARN must be in one of the following formats. To log events on all objects in an S3 access point, we recommend that you use only the access point ARN, don’t include the object path, and use the <code>StartsWith</code> or <code>NotStartsWith</code> operators.</p>
    /// <ul>
    /// <li> <p> <code>arn:
    /// <partition>
    /// :s3:
    /// <region>
    /// :
    /// <account_id>
    /// :accesspoint/
    /// <access_point_name></access_point_name>
    /// </account_id>
    /// </region>
    /// </partition></code> </p> </li>
    /// <li> <p> <code>arn:
    /// <partition>
    /// :s3:
    /// <region>
    /// :
    /// <account_id>
    /// :accesspoint/
    /// <access_point_name>
    /// /object/
    /// <object_path></object_path>
    /// </access_point_name>
    /// </account_id>
    /// </region>
    /// </partition></code> </p> </li>
    /// </ul> <p>When resources.type equals <code>AWS::Lambda::Function</code>, and the operator is set to <code>Equals</code> or <code>NotEquals</code>, the ARN must be in the following format:</p>
    /// <ul>
    /// <li> <p> <code>arn:
    /// <partition>
    /// :lambda:
    /// <region>
    /// :
    /// <account_id>
    /// :function:
    /// <function_name></function_name>
    /// </account_id>
    /// </region>
    /// </partition></code> </p> </li>
    /// </ul> <p>When resources.type equals <code>AWS::DynamoDB::Table</code>, and the operator is set to <code>Equals</code> or <code>NotEquals</code>, the ARN must be in the following format:</p>
    /// <ul>
    /// <li> <p> <code>arn:
    /// <partition>
    /// :dynamodb:
    /// <region>
    /// :
    /// <account_id>
    /// :table/
    /// <table_name></table_name>
    /// </account_id>
    /// </region>
    /// </partition></code> </p> </li>
    /// </ul> <p>When <code>resources.type</code> equals <code>AWS::S3Outposts::Object</code>, and the operator is set to <code>Equals</code> or <code>NotEquals</code>, the ARN must be in the following format:</p>
    /// <ul>
    /// <li> <p> <code>arn:
    /// <partition>
    /// :s3-outposts:
    /// <region>
    /// :
    /// <account_id>
    /// :
    /// <object_path></object_path>
    /// </account_id>
    /// </region>
    /// </partition></code> </p> </li>
    /// </ul> <p>When <code>resources.type</code> equals <code>AWS::ManagedBlockchain::Node</code>, and the operator is set to <code>Equals</code> or <code>NotEquals</code>, the ARN must be in the following format:</p>
    /// <ul>
    /// <li> <p> <code>arn:
    /// <partition>
    /// :managedblockchain:
    /// <region>
    /// :
    /// <account_id>
    /// :nodes/
    /// <node_id></node_id>
    /// </account_id>
    /// </region>
    /// </partition></code> </p> </li>
    /// </ul> <p>When <code>resources.type</code> equals <code>AWS::S3ObjectLambda::AccessPoint</code>, and the operator is set to <code>Equals</code> or <code>NotEquals</code>, the ARN must be in the following format:</p>
    /// <ul>
    /// <li> <p> <code>arn:
    /// <partition>
    /// :s3-object-lambda:
    /// <region>
    /// :
    /// <account_id>
    /// :accesspoint/
    /// <access_point_name></access_point_name>
    /// </account_id>
    /// </region>
    /// </partition></code> </p> </li>
    /// </ul> <p>When <code>resources.type</code> equals <code>AWS::EC2::Snapshot</code>, and the operator is set to <code>Equals</code> or <code>NotEquals</code>, the ARN must be in the following format:</p>
    /// <ul>
    /// <li> <p> <code>arn:
    /// <partition>
    /// :ec2:
    /// <region>
    /// ::snapshot/
    /// <snapshot_id></snapshot_id>
    /// </region>
    /// </partition></code> </p> </li>
    /// </ul> <p>When <code>resources.type</code> equals <code>AWS::DynamoDB::Stream</code>, and the operator is set to <code>Equals</code> or <code>NotEquals</code>, the ARN must be in the following format:</p>
    /// <ul>
    /// <li> <p> <code>arn:
    /// <partition>
    /// :dynamodb:
    /// <region>
    /// :
    /// <account_id>
    /// :table/
    /// <table_name>
    /// /stream/
    /// <date_time></date_time>
    /// </table_name>
    /// </account_id>
    /// </region>
    /// </partition></code> </p> </li>
    /// </ul> <p>When <code>resources.type</code> equals <code>AWS::Glue::Table</code>, and the operator is set to <code>Equals</code> or <code>NotEquals</code>, the ARN must be in the following format:</p>
    /// <ul>
    /// <li> <p> <code>arn:
    /// <partition>
    /// :glue:
    /// <region>
    /// :
    /// <account_id>
    /// :table/
    /// <database_name>
    /// /
    /// <table_name></table_name>
    /// </database_name>
    /// </account_id>
    /// </region>
    /// </partition></code> </p> </li>
    /// </ul> </li>
    /// </ul>
    pub fn field(&self) -> std::option::Option<&str> {
        self.field.as_deref()
    }
    /// <p> An operator that includes events that match the exact value of the event record field specified as the value of <code>Field</code>. This is the only valid operator that you can use with the <code>readOnly</code>, <code>eventCategory</code>, and <code>resources.type</code> fields.</p>
    pub fn equals(&self) -> std::option::Option<&[std::string::String]> {
        self.equals.as_deref()
    }
    /// <p>An operator that includes events that match the first few characters of the event record field specified as the value of <code>Field</code>.</p>
    pub fn starts_with(&self) -> std::option::Option<&[std::string::String]> {
        self.starts_with.as_deref()
    }
    /// <p>An operator that includes events that match the last few characters of the event record field specified as the value of <code>Field</code>.</p>
    pub fn ends_with(&self) -> std::option::Option<&[std::string::String]> {
        self.ends_with.as_deref()
    }
    /// <p> An operator that excludes events that match the exact value of the event record field specified as the value of <code>Field</code>. </p>
    pub fn not_equals(&self) -> std::option::Option<&[std::string::String]> {
        self.not_equals.as_deref()
    }
    /// <p> An operator that excludes events that match the first few characters of the event record field specified as the value of <code>Field</code>. </p>
    pub fn not_starts_with(&self) -> std::option::Option<&[std::string::String]> {
        self.not_starts_with.as_deref()
    }
    /// <p> An operator that excludes events that match the last few characters of the event record field specified as the value of <code>Field</code>. </p>
    pub fn not_ends_with(&self) -> std::option::Option<&[std::string::String]> {
        self.not_ends_with.as_deref()
    }
}
impl std::fmt::Debug for AdvancedFieldSelector {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AdvancedFieldSelector");
        formatter.field("field", &self.field);
        formatter.field("equals", &self.equals);
        formatter.field("starts_with", &self.starts_with);
        formatter.field("ends_with", &self.ends_with);
        formatter.field("not_equals", &self.not_equals);
        formatter.field("not_starts_with", &self.not_starts_with);
        formatter.field("not_ends_with", &self.not_ends_with);
        formatter.finish()
    }
}
/// See [`AdvancedFieldSelector`](crate::model::AdvancedFieldSelector)
pub mod advanced_field_selector {
    /// A builder for [`AdvancedFieldSelector`](crate::model::AdvancedFieldSelector)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) field: std::option::Option<std::string::String>,
        pub(crate) equals: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) starts_with: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) ends_with: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) not_equals: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) not_starts_with: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) not_ends_with: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p> A field in an event record on which to filter events to be logged. Supported fields include <code>readOnly</code>, <code>eventCategory</code>, <code>eventSource</code> (for management events), <code>eventName</code>, <code>resources.type</code>, and <code>resources.ARN</code>. </p>
        /// <ul>
        /// <li> <p> <b> <code>readOnly</code> </b> - Optional. Can be set to <code>Equals</code> a value of <code>true</code> or <code>false</code>. If you do not add this field, CloudTrail logs both both <code>read</code> and <code>write</code> events. A value of <code>true</code> logs only <code>read</code> events. A value of <code>false</code> logs only <code>write</code> events.</p> </li>
        /// <li> <p> <b> <code>eventSource</code> </b> - For filtering management events only. This can be set only to <code>NotEquals</code> <code>kms.amazonaws.com</code>.</p> </li>
        /// <li> <p> <b> <code>eventName</code> </b> - Can use any operator. You can use it to ﬁlter in or ﬁlter out any data event logged to CloudTrail, such as <code>PutBucket</code> or <code>GetSnapshotBlock</code>. You can have multiple values for this ﬁeld, separated by commas.</p> </li>
        /// <li> <p> <b> <code>eventCategory</code> </b> - This is required. It must be set to <code>Equals</code>, and the value must be <code>Management</code> or <code>Data</code>.</p> </li>
        /// <li> <p> <b> <code>resources.type</code> </b> - This ﬁeld is required. <code>resources.type</code> can only use the <code>Equals</code> operator, and the value can be one of the following:</p>
        /// <ul>
        /// <li> <p> <code>AWS::S3::Object</code> </p> </li>
        /// <li> <p> <code>AWS::Lambda::Function</code> </p> </li>
        /// <li> <p> <code>AWS::DynamoDB::Table</code> </p> </li>
        /// <li> <p> <code>AWS::S3Outposts::Object</code> </p> </li>
        /// <li> <p> <code>AWS::ManagedBlockchain::Node</code> </p> </li>
        /// <li> <p> <code>AWS::S3ObjectLambda::AccessPoint</code> </p> </li>
        /// <li> <p> <code>AWS::EC2::Snapshot</code> </p> </li>
        /// <li> <p> <code>AWS::S3::AccessPoint</code> </p> </li>
        /// <li> <p> <code>AWS::DynamoDB::Stream</code> </p> </li>
        /// <li> <p> <code>AWS::Glue::Table</code> </p> </li>
        /// </ul> <p> You can have only one <code>resources.type</code> ﬁeld per selector. To log data events on more than one resource type, add another selector.</p> </li>
        /// <li> <p> <b> <code>resources.ARN</code> </b> - You can use any operator with <code>resources.ARN</code>, but if you use <code>Equals</code> or <code>NotEquals</code>, the value must exactly match the ARN of a valid resource of the type you've speciﬁed in the template as the value of resources.type. For example, if resources.type equals <code>AWS::S3::Object</code>, the ARN must be in one of the following formats. To log all data events for all objects in a specific S3 bucket, use the <code>StartsWith</code> operator, and include only the bucket ARN as the matching value.</p> <p>The trailing slash is intentional; do not exclude it. Replace the text between less than and greater than symbols (&lt;&gt;) with resource-specific information. </p>
        /// <ul>
        /// <li> <p> <code>arn:
        /// <partition>
        /// :s3:::
        /// <bucket_name>
        /// /
        /// </bucket_name>
        /// </partition></code> </p> </li>
        /// <li> <p> <code>arn:
        /// <partition>
        /// :s3:::
        /// <bucket_name>
        /// /
        /// <object_path>
        /// /
        /// </object_path>
        /// </bucket_name>
        /// </partition></code> </p> </li>
        /// </ul> <p>When <code>resources.type</code> equals <code>AWS::S3::AccessPoint</code>, and the operator is set to <code>Equals</code> or <code>NotEquals</code>, the ARN must be in one of the following formats. To log events on all objects in an S3 access point, we recommend that you use only the access point ARN, don’t include the object path, and use the <code>StartsWith</code> or <code>NotStartsWith</code> operators.</p>
        /// <ul>
        /// <li> <p> <code>arn:
        /// <partition>
        /// :s3:
        /// <region>
        /// :
        /// <account_id>
        /// :accesspoint/
        /// <access_point_name></access_point_name>
        /// </account_id>
        /// </region>
        /// </partition></code> </p> </li>
        /// <li> <p> <code>arn:
        /// <partition>
        /// :s3:
        /// <region>
        /// :
        /// <account_id>
        /// :accesspoint/
        /// <access_point_name>
        /// /object/
        /// <object_path></object_path>
        /// </access_point_name>
        /// </account_id>
        /// </region>
        /// </partition></code> </p> </li>
        /// </ul> <p>When resources.type equals <code>AWS::Lambda::Function</code>, and the operator is set to <code>Equals</code> or <code>NotEquals</code>, the ARN must be in the following format:</p>
        /// <ul>
        /// <li> <p> <code>arn:
        /// <partition>
        /// :lambda:
        /// <region>
        /// :
        /// <account_id>
        /// :function:
        /// <function_name></function_name>
        /// </account_id>
        /// </region>
        /// </partition></code> </p> </li>
        /// </ul> <p>When resources.type equals <code>AWS::DynamoDB::Table</code>, and the operator is set to <code>Equals</code> or <code>NotEquals</code>, the ARN must be in the following format:</p>
        /// <ul>
        /// <li> <p> <code>arn:
        /// <partition>
        /// :dynamodb:
        /// <region>
        /// :
        /// <account_id>
        /// :table/
        /// <table_name></table_name>
        /// </account_id>
        /// </region>
        /// </partition></code> </p> </li>
        /// </ul> <p>When <code>resources.type</code> equals <code>AWS::S3Outposts::Object</code>, and the operator is set to <code>Equals</code> or <code>NotEquals</code>, the ARN must be in the following format:</p>
        /// <ul>
        /// <li> <p> <code>arn:
        /// <partition>
        /// :s3-outposts:
        /// <region>
        /// :
        /// <account_id>
        /// :
        /// <object_path></object_path>
        /// </account_id>
        /// </region>
        /// </partition></code> </p> </li>
        /// </ul> <p>When <code>resources.type</code> equals <code>AWS::ManagedBlockchain::Node</code>, and the operator is set to <code>Equals</code> or <code>NotEquals</code>, the ARN must be in the following format:</p>
        /// <ul>
        /// <li> <p> <code>arn:
        /// <partition>
        /// :managedblockchain:
        /// <region>
        /// :
        /// <account_id>
        /// :nodes/
        /// <node_id></node_id>
        /// </account_id>
        /// </region>
        /// </partition></code> </p> </li>
        /// </ul> <p>When <code>resources.type</code> equals <code>AWS::S3ObjectLambda::AccessPoint</code>, and the operator is set to <code>Equals</code> or <code>NotEquals</code>, the ARN must be in the following format:</p>
        /// <ul>
        /// <li> <p> <code>arn:
        /// <partition>
        /// :s3-object-lambda:
        /// <region>
        /// :
        /// <account_id>
        /// :accesspoint/
        /// <access_point_name></access_point_name>
        /// </account_id>
        /// </region>
        /// </partition></code> </p> </li>
        /// </ul> <p>When <code>resources.type</code> equals <code>AWS::EC2::Snapshot</code>, and the operator is set to <code>Equals</code> or <code>NotEquals</code>, the ARN must be in the following format:</p>
        /// <ul>
        /// <li> <p> <code>arn:
        /// <partition>
        /// :ec2:
        /// <region>
        /// ::snapshot/
        /// <snapshot_id></snapshot_id>
        /// </region>
        /// </partition></code> </p> </li>
        /// </ul> <p>When <code>resources.type</code> equals <code>AWS::DynamoDB::Stream</code>, and the operator is set to <code>Equals</code> or <code>NotEquals</code>, the ARN must be in the following format:</p>
        /// <ul>
        /// <li> <p> <code>arn:
        /// <partition>
        /// :dynamodb:
        /// <region>
        /// :
        /// <account_id>
        /// :table/
        /// <table_name>
        /// /stream/
        /// <date_time></date_time>
        /// </table_name>
        /// </account_id>
        /// </region>
        /// </partition></code> </p> </li>
        /// </ul> <p>When <code>resources.type</code> equals <code>AWS::Glue::Table</code>, and the operator is set to <code>Equals</code> or <code>NotEquals</code>, the ARN must be in the following format:</p>
        /// <ul>
        /// <li> <p> <code>arn:
        /// <partition>
        /// :glue:
        /// <region>
        /// :
        /// <account_id>
        /// :table/
        /// <database_name>
        /// /
        /// <table_name></table_name>
        /// </database_name>
        /// </account_id>
        /// </region>
        /// </partition></code> </p> </li>
        /// </ul> </li>
        /// </ul>
        pub fn field(mut self, input: impl Into<std::string::String>) -> Self {
            self.field = Some(input.into());
            self
        }
        /// <p> A field in an event record on which to filter events to be logged. Supported fields include <code>readOnly</code>, <code>eventCategory</code>, <code>eventSource</code> (for management events), <code>eventName</code>, <code>resources.type</code>, and <code>resources.ARN</code>. </p>
        /// <ul>
        /// <li> <p> <b> <code>readOnly</code> </b> - Optional. Can be set to <code>Equals</code> a value of <code>true</code> or <code>false</code>. If you do not add this field, CloudTrail logs both both <code>read</code> and <code>write</code> events. A value of <code>true</code> logs only <code>read</code> events. A value of <code>false</code> logs only <code>write</code> events.</p> </li>
        /// <li> <p> <b> <code>eventSource</code> </b> - For filtering management events only. This can be set only to <code>NotEquals</code> <code>kms.amazonaws.com</code>.</p> </li>
        /// <li> <p> <b> <code>eventName</code> </b> - Can use any operator. You can use it to ﬁlter in or ﬁlter out any data event logged to CloudTrail, such as <code>PutBucket</code> or <code>GetSnapshotBlock</code>. You can have multiple values for this ﬁeld, separated by commas.</p> </li>
        /// <li> <p> <b> <code>eventCategory</code> </b> - This is required. It must be set to <code>Equals</code>, and the value must be <code>Management</code> or <code>Data</code>.</p> </li>
        /// <li> <p> <b> <code>resources.type</code> </b> - This ﬁeld is required. <code>resources.type</code> can only use the <code>Equals</code> operator, and the value can be one of the following:</p>
        /// <ul>
        /// <li> <p> <code>AWS::S3::Object</code> </p> </li>
        /// <li> <p> <code>AWS::Lambda::Function</code> </p> </li>
        /// <li> <p> <code>AWS::DynamoDB::Table</code> </p> </li>
        /// <li> <p> <code>AWS::S3Outposts::Object</code> </p> </li>
        /// <li> <p> <code>AWS::ManagedBlockchain::Node</code> </p> </li>
        /// <li> <p> <code>AWS::S3ObjectLambda::AccessPoint</code> </p> </li>
        /// <li> <p> <code>AWS::EC2::Snapshot</code> </p> </li>
        /// <li> <p> <code>AWS::S3::AccessPoint</code> </p> </li>
        /// <li> <p> <code>AWS::DynamoDB::Stream</code> </p> </li>
        /// <li> <p> <code>AWS::Glue::Table</code> </p> </li>
        /// </ul> <p> You can have only one <code>resources.type</code> ﬁeld per selector. To log data events on more than one resource type, add another selector.</p> </li>
        /// <li> <p> <b> <code>resources.ARN</code> </b> - You can use any operator with <code>resources.ARN</code>, but if you use <code>Equals</code> or <code>NotEquals</code>, the value must exactly match the ARN of a valid resource of the type you've speciﬁed in the template as the value of resources.type. For example, if resources.type equals <code>AWS::S3::Object</code>, the ARN must be in one of the following formats. To log all data events for all objects in a specific S3 bucket, use the <code>StartsWith</code> operator, and include only the bucket ARN as the matching value.</p> <p>The trailing slash is intentional; do not exclude it. Replace the text between less than and greater than symbols (&lt;&gt;) with resource-specific information. </p>
        /// <ul>
        /// <li> <p> <code>arn:
        /// <partition>
        /// :s3:::
        /// <bucket_name>
        /// /
        /// </bucket_name>
        /// </partition></code> </p> </li>
        /// <li> <p> <code>arn:
        /// <partition>
        /// :s3:::
        /// <bucket_name>
        /// /
        /// <object_path>
        /// /
        /// </object_path>
        /// </bucket_name>
        /// </partition></code> </p> </li>
        /// </ul> <p>When <code>resources.type</code> equals <code>AWS::S3::AccessPoint</code>, and the operator is set to <code>Equals</code> or <code>NotEquals</code>, the ARN must be in one of the following formats. To log events on all objects in an S3 access point, we recommend that you use only the access point ARN, don’t include the object path, and use the <code>StartsWith</code> or <code>NotStartsWith</code> operators.</p>
        /// <ul>
        /// <li> <p> <code>arn:
        /// <partition>
        /// :s3:
        /// <region>
        /// :
        /// <account_id>
        /// :accesspoint/
        /// <access_point_name></access_point_name>
        /// </account_id>
        /// </region>
        /// </partition></code> </p> </li>
        /// <li> <p> <code>arn:
        /// <partition>
        /// :s3:
        /// <region>
        /// :
        /// <account_id>
        /// :accesspoint/
        /// <access_point_name>
        /// /object/
        /// <object_path></object_path>
        /// </access_point_name>
        /// </account_id>
        /// </region>
        /// </partition></code> </p> </li>
        /// </ul> <p>When resources.type equals <code>AWS::Lambda::Function</code>, and the operator is set to <code>Equals</code> or <code>NotEquals</code>, the ARN must be in the following format:</p>
        /// <ul>
        /// <li> <p> <code>arn:
        /// <partition>
        /// :lambda:
        /// <region>
        /// :
        /// <account_id>
        /// :function:
        /// <function_name></function_name>
        /// </account_id>
        /// </region>
        /// </partition></code> </p> </li>
        /// </ul> <p>When resources.type equals <code>AWS::DynamoDB::Table</code>, and the operator is set to <code>Equals</code> or <code>NotEquals</code>, the ARN must be in the following format:</p>
        /// <ul>
        /// <li> <p> <code>arn:
        /// <partition>
        /// :dynamodb:
        /// <region>
        /// :
        /// <account_id>
        /// :table/
        /// <table_name></table_name>
        /// </account_id>
        /// </region>
        /// </partition></code> </p> </li>
        /// </ul> <p>When <code>resources.type</code> equals <code>AWS::S3Outposts::Object</code>, and the operator is set to <code>Equals</code> or <code>NotEquals</code>, the ARN must be in the following format:</p>
        /// <ul>
        /// <li> <p> <code>arn:
        /// <partition>
        /// :s3-outposts:
        /// <region>
        /// :
        /// <account_id>
        /// :
        /// <object_path></object_path>
        /// </account_id>
        /// </region>
        /// </partition></code> </p> </li>
        /// </ul> <p>When <code>resources.type</code> equals <code>AWS::ManagedBlockchain::Node</code>, and the operator is set to <code>Equals</code> or <code>NotEquals</code>, the ARN must be in the following format:</p>
        /// <ul>
        /// <li> <p> <code>arn:
        /// <partition>
        /// :managedblockchain:
        /// <region>
        /// :
        /// <account_id>
        /// :nodes/
        /// <node_id></node_id>
        /// </account_id>
        /// </region>
        /// </partition></code> </p> </li>
        /// </ul> <p>When <code>resources.type</code> equals <code>AWS::S3ObjectLambda::AccessPoint</code>, and the operator is set to <code>Equals</code> or <code>NotEquals</code>, the ARN must be in the following format:</p>
        /// <ul>
        /// <li> <p> <code>arn:
        /// <partition>
        /// :s3-object-lambda:
        /// <region>
        /// :
        /// <account_id>
        /// :accesspoint/
        /// <access_point_name></access_point_name>
        /// </account_id>
        /// </region>
        /// </partition></code> </p> </li>
        /// </ul> <p>When <code>resources.type</code> equals <code>AWS::EC2::Snapshot</code>, and the operator is set to <code>Equals</code> or <code>NotEquals</code>, the ARN must be in the following format:</p>
        /// <ul>
        /// <li> <p> <code>arn:
        /// <partition>
        /// :ec2:
        /// <region>
        /// ::snapshot/
        /// <snapshot_id></snapshot_id>
        /// </region>
        /// </partition></code> </p> </li>
        /// </ul> <p>When <code>resources.type</code> equals <code>AWS::DynamoDB::Stream</code>, and the operator is set to <code>Equals</code> or <code>NotEquals</code>, the ARN must be in the following format:</p>
        /// <ul>
        /// <li> <p> <code>arn:
        /// <partition>
        /// :dynamodb:
        /// <region>
        /// :
        /// <account_id>
        /// :table/
        /// <table_name>
        /// /stream/
        /// <date_time></date_time>
        /// </table_name>
        /// </account_id>
        /// </region>
        /// </partition></code> </p> </li>
        /// </ul> <p>When <code>resources.type</code> equals <code>AWS::Glue::Table</code>, and the operator is set to <code>Equals</code> or <code>NotEquals</code>, the ARN must be in the following format:</p>
        /// <ul>
        /// <li> <p> <code>arn:
        /// <partition>
        /// :glue:
        /// <region>
        /// :
        /// <account_id>
        /// :table/
        /// <database_name>
        /// /
        /// <table_name></table_name>
        /// </database_name>
        /// </account_id>
        /// </region>
        /// </partition></code> </p> </li>
        /// </ul> </li>
        /// </ul>
        pub fn set_field(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.field = input;
            self
        }
        /// Appends an item to `equals`.
        ///
        /// To override the contents of this collection use [`set_equals`](Self::set_equals).
        ///
        /// <p> An operator that includes events that match the exact value of the event record field specified as the value of <code>Field</code>. This is the only valid operator that you can use with the <code>readOnly</code>, <code>eventCategory</code>, and <code>resources.type</code> fields.</p>
        pub fn equals(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.equals.unwrap_or_default();
            v.push(input.into());
            self.equals = Some(v);
            self
        }
        /// <p> An operator that includes events that match the exact value of the event record field specified as the value of <code>Field</code>. This is the only valid operator that you can use with the <code>readOnly</code>, <code>eventCategory</code>, and <code>resources.type</code> fields.</p>
        pub fn set_equals(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.equals = input;
            self
        }
        /// Appends an item to `starts_with`.
        ///
        /// To override the contents of this collection use [`set_starts_with`](Self::set_starts_with).
        ///
        /// <p>An operator that includes events that match the first few characters of the event record field specified as the value of <code>Field</code>.</p>
        pub fn starts_with(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.starts_with.unwrap_or_default();
            v.push(input.into());
            self.starts_with = Some(v);
            self
        }
        /// <p>An operator that includes events that match the first few characters of the event record field specified as the value of <code>Field</code>.</p>
        pub fn set_starts_with(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.starts_with = input;
            self
        }
        /// Appends an item to `ends_with`.
        ///
        /// To override the contents of this collection use [`set_ends_with`](Self::set_ends_with).
        ///
        /// <p>An operator that includes events that match the last few characters of the event record field specified as the value of <code>Field</code>.</p>
        pub fn ends_with(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.ends_with.unwrap_or_default();
            v.push(input.into());
            self.ends_with = Some(v);
            self
        }
        /// <p>An operator that includes events that match the last few characters of the event record field specified as the value of <code>Field</code>.</p>
        pub fn set_ends_with(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.ends_with = input;
            self
        }
        /// Appends an item to `not_equals`.
        ///
        /// To override the contents of this collection use [`set_not_equals`](Self::set_not_equals).
        ///
        /// <p> An operator that excludes events that match the exact value of the event record field specified as the value of <code>Field</code>. </p>
        pub fn not_equals(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.not_equals.unwrap_or_default();
            v.push(input.into());
            self.not_equals = Some(v);
            self
        }
        /// <p> An operator that excludes events that match the exact value of the event record field specified as the value of <code>Field</code>. </p>
        pub fn set_not_equals(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.not_equals = input;
            self
        }
        /// Appends an item to `not_starts_with`.
        ///
        /// To override the contents of this collection use [`set_not_starts_with`](Self::set_not_starts_with).
        ///
        /// <p> An operator that excludes events that match the first few characters of the event record field specified as the value of <code>Field</code>. </p>
        pub fn not_starts_with(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.not_starts_with.unwrap_or_default();
            v.push(input.into());
            self.not_starts_with = Some(v);
            self
        }
        /// <p> An operator that excludes events that match the first few characters of the event record field specified as the value of <code>Field</code>. </p>
        pub fn set_not_starts_with(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.not_starts_with = input;
            self
        }
        /// Appends an item to `not_ends_with`.
        ///
        /// To override the contents of this collection use [`set_not_ends_with`](Self::set_not_ends_with).
        ///
        /// <p> An operator that excludes events that match the last few characters of the event record field specified as the value of <code>Field</code>. </p>
        pub fn not_ends_with(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.not_ends_with.unwrap_or_default();
            v.push(input.into());
            self.not_ends_with = Some(v);
            self
        }
        /// <p> An operator that excludes events that match the last few characters of the event record field specified as the value of <code>Field</code>. </p>
        pub fn set_not_ends_with(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.not_ends_with = input;
            self
        }
        /// Consumes the builder and constructs a [`AdvancedFieldSelector`](crate::model::AdvancedFieldSelector)
        pub fn build(self) -> crate::model::AdvancedFieldSelector {
            crate::model::AdvancedFieldSelector {
                field: self.field,
                equals: self.equals,
                starts_with: self.starts_with,
                ends_with: self.ends_with,
                not_equals: self.not_equals,
                not_starts_with: self.not_starts_with,
                not_ends_with: self.not_ends_with,
            }
        }
    }
}
impl AdvancedFieldSelector {
    /// Creates a new builder-style object to manufacture [`AdvancedFieldSelector`](crate::model::AdvancedFieldSelector)
    pub fn builder() -> crate::model::advanced_field_selector::Builder {
        crate::model::advanced_field_selector::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum EventDataStoreStatus {
    #[allow(missing_docs)] // documentation missing in model
    Created,
    #[allow(missing_docs)] // documentation missing in model
    Enabled,
    #[allow(missing_docs)] // documentation missing in model
    PendingDeletion,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for EventDataStoreStatus {
    fn from(s: &str) -> Self {
        match s {
            "CREATED" => EventDataStoreStatus::Created,
            "ENABLED" => EventDataStoreStatus::Enabled,
            "PENDING_DELETION" => EventDataStoreStatus::PendingDeletion,
            other => EventDataStoreStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for EventDataStoreStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(EventDataStoreStatus::from(s))
    }
}
impl EventDataStoreStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            EventDataStoreStatus::Created => "CREATED",
            EventDataStoreStatus::Enabled => "ENABLED",
            EventDataStoreStatus::PendingDeletion => "PENDING_DELETION",
            EventDataStoreStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["CREATED", "ENABLED", "PENDING_DELETION"]
    }
}
impl AsRef<str> for EventDataStoreStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>A custom key-value pair associated with a resource such as a CloudTrail trail.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Tag {
    /// <p>The key in a key-value pair. The key must be must be no longer than 128 Unicode characters. The key must be unique for the resource to which it applies.</p>
    pub key: std::option::Option<std::string::String>,
    /// <p>The value in a key-value pair of a tag. The value must be no longer than 256 Unicode characters.</p>
    pub value: std::option::Option<std::string::String>,
}
impl Tag {
    /// <p>The key in a key-value pair. The key must be must be no longer than 128 Unicode characters. The key must be unique for the resource to which it applies.</p>
    pub fn key(&self) -> std::option::Option<&str> {
        self.key.as_deref()
    }
    /// <p>The value in a key-value pair of a tag. The value must be no longer than 256 Unicode characters.</p>
    pub fn value(&self) -> std::option::Option<&str> {
        self.value.as_deref()
    }
}
impl std::fmt::Debug for Tag {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Tag");
        formatter.field("key", &self.key);
        formatter.field("value", &self.value);
        formatter.finish()
    }
}
/// See [`Tag`](crate::model::Tag)
pub mod tag {
    /// A builder for [`Tag`](crate::model::Tag)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) key: std::option::Option<std::string::String>,
        pub(crate) value: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The key in a key-value pair. The key must be must be no longer than 128 Unicode characters. The key must be unique for the resource to which it applies.</p>
        pub fn key(mut self, input: impl Into<std::string::String>) -> Self {
            self.key = Some(input.into());
            self
        }
        /// <p>The key in a key-value pair. The key must be must be no longer than 128 Unicode characters. The key must be unique for the resource to which it applies.</p>
        pub fn set_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key = input;
            self
        }
        /// <p>The value in a key-value pair of a tag. The value must be no longer than 256 Unicode characters.</p>
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            self.value = Some(input.into());
            self
        }
        /// <p>The value in a key-value pair of a tag. The value must be no longer than 256 Unicode characters.</p>
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.value = input;
            self
        }
        /// Consumes the builder and constructs a [`Tag`](crate::model::Tag)
        pub fn build(self) -> crate::model::Tag {
            crate::model::Tag {
                key: self.key,
                value: self.value,
            }
        }
    }
}
impl Tag {
    /// Creates a new builder-style object to manufacture [`Tag`](crate::model::Tag)
    pub fn builder() -> crate::model::tag::Builder {
        crate::model::tag::Builder::default()
    }
}

/// <p>A JSON string that contains a list of insight types that are logged on a trail.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InsightSelector {
    /// <p>The type of insights to log on a trail. <code>ApiCallRateInsight</code> and <code>ApiErrorRateInsight</code> are valid insight types.</p>
    pub insight_type: std::option::Option<crate::model::InsightType>,
}
impl InsightSelector {
    /// <p>The type of insights to log on a trail. <code>ApiCallRateInsight</code> and <code>ApiErrorRateInsight</code> are valid insight types.</p>
    pub fn insight_type(&self) -> std::option::Option<&crate::model::InsightType> {
        self.insight_type.as_ref()
    }
}
impl std::fmt::Debug for InsightSelector {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InsightSelector");
        formatter.field("insight_type", &self.insight_type);
        formatter.finish()
    }
}
/// See [`InsightSelector`](crate::model::InsightSelector)
pub mod insight_selector {
    /// A builder for [`InsightSelector`](crate::model::InsightSelector)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) insight_type: std::option::Option<crate::model::InsightType>,
    }
    impl Builder {
        /// <p>The type of insights to log on a trail. <code>ApiCallRateInsight</code> and <code>ApiErrorRateInsight</code> are valid insight types.</p>
        pub fn insight_type(mut self, input: crate::model::InsightType) -> Self {
            self.insight_type = Some(input);
            self
        }
        /// <p>The type of insights to log on a trail. <code>ApiCallRateInsight</code> and <code>ApiErrorRateInsight</code> are valid insight types.</p>
        pub fn set_insight_type(
            mut self,
            input: std::option::Option<crate::model::InsightType>,
        ) -> Self {
            self.insight_type = input;
            self
        }
        /// Consumes the builder and constructs a [`InsightSelector`](crate::model::InsightSelector)
        pub fn build(self) -> crate::model::InsightSelector {
            crate::model::InsightSelector {
                insight_type: self.insight_type,
            }
        }
    }
}
impl InsightSelector {
    /// Creates a new builder-style object to manufacture [`InsightSelector`](crate::model::InsightSelector)
    pub fn builder() -> crate::model::insight_selector::Builder {
        crate::model::insight_selector::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum InsightType {
    #[allow(missing_docs)] // documentation missing in model
    ApiCallRateInsight,
    #[allow(missing_docs)] // documentation missing in model
    ApiErrorRateInsight,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for InsightType {
    fn from(s: &str) -> Self {
        match s {
            "ApiCallRateInsight" => InsightType::ApiCallRateInsight,
            "ApiErrorRateInsight" => InsightType::ApiErrorRateInsight,
            other => InsightType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for InsightType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(InsightType::from(s))
    }
}
impl InsightType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            InsightType::ApiCallRateInsight => "ApiCallRateInsight",
            InsightType::ApiErrorRateInsight => "ApiErrorRateInsight",
            InsightType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ApiCallRateInsight", "ApiErrorRateInsight"]
    }
}
impl AsRef<str> for InsightType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Use event selectors to further specify the management and data event settings for your trail. By default, trails created without specific event selectors will be configured to log all read and write management events, and no data events. When an event occurs in your account, CloudTrail evaluates the event selector for all trails. For each trail, if the event matches any event selector, the trail processes and logs the event. If the event doesn't match any event selector, the trail doesn't log the event.</p>
/// <p>You can configure up to five event selectors for a trail.</p>
/// <p>You cannot apply both event selectors and advanced event selectors to a trail.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EventSelector {
    /// <p>Specify if you want your trail to log read-only events, write-only events, or all. For example, the EC2 <code>GetConsoleOutput</code> is a read-only API operation and <code>RunInstances</code> is a write-only API operation.</p>
    /// <p> By default, the value is <code>All</code>.</p>
    pub read_write_type: std::option::Option<crate::model::ReadWriteType>,
    /// <p>Specify if you want your event selector to include management events for your trail.</p>
    /// <p> For more information, see <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/logging-management-and-data-events-with-cloudtrail.html#logging-management-events">Management Events</a> in the <i>CloudTrail User Guide</i>.</p>
    /// <p>By default, the value is <code>true</code>.</p>
    /// <p>The first copy of management events is free. You are charged for additional copies of management events that you are logging on any subsequent trail in the same region. For more information about CloudTrail pricing, see <a href="http://aws.amazon.com/cloudtrail/pricing/">CloudTrail Pricing</a>.</p>
    pub include_management_events: std::option::Option<bool>,
    /// <p>CloudTrail supports data event logging for Amazon S3 objects, Lambda functions, and Amazon DynamoDB tables with basic event selectors. You can specify up to 250 resources for an individual event selector, but the total number of data resources cannot exceed 250 across all event selectors in a trail. This limit does not apply if you configure resource logging for all data events.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/logging-management-and-data-events-with-cloudtrail.html#logging-data-events">Data Events</a> and <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/WhatIsCloudTrail-Limits.html">Limits in CloudTrail</a> in the <i>CloudTrail User Guide</i>.</p>
    pub data_resources: std::option::Option<std::vec::Vec<crate::model::DataResource>>,
    /// <p>An optional list of service event sources from which you do not want management events to be logged on your trail. In this release, the list can be empty (disables the filter), or it can filter out Key Management Service or Amazon RDS Data API events by containing <code>kms.amazonaws.com</code> or <code>rdsdata.amazonaws.com</code>. By default, <code>ExcludeManagementEventSources</code> is empty, and KMS and Amazon RDS Data API events are logged to your trail. You can exclude management event sources only in regions that support the event source.</p>
    pub exclude_management_event_sources: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl EventSelector {
    /// <p>Specify if you want your trail to log read-only events, write-only events, or all. For example, the EC2 <code>GetConsoleOutput</code> is a read-only API operation and <code>RunInstances</code> is a write-only API operation.</p>
    /// <p> By default, the value is <code>All</code>.</p>
    pub fn read_write_type(&self) -> std::option::Option<&crate::model::ReadWriteType> {
        self.read_write_type.as_ref()
    }
    /// <p>Specify if you want your event selector to include management events for your trail.</p>
    /// <p> For more information, see <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/logging-management-and-data-events-with-cloudtrail.html#logging-management-events">Management Events</a> in the <i>CloudTrail User Guide</i>.</p>
    /// <p>By default, the value is <code>true</code>.</p>
    /// <p>The first copy of management events is free. You are charged for additional copies of management events that you are logging on any subsequent trail in the same region. For more information about CloudTrail pricing, see <a href="http://aws.amazon.com/cloudtrail/pricing/">CloudTrail Pricing</a>.</p>
    pub fn include_management_events(&self) -> std::option::Option<bool> {
        self.include_management_events
    }
    /// <p>CloudTrail supports data event logging for Amazon S3 objects, Lambda functions, and Amazon DynamoDB tables with basic event selectors. You can specify up to 250 resources for an individual event selector, but the total number of data resources cannot exceed 250 across all event selectors in a trail. This limit does not apply if you configure resource logging for all data events.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/logging-management-and-data-events-with-cloudtrail.html#logging-data-events">Data Events</a> and <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/WhatIsCloudTrail-Limits.html">Limits in CloudTrail</a> in the <i>CloudTrail User Guide</i>.</p>
    pub fn data_resources(&self) -> std::option::Option<&[crate::model::DataResource]> {
        self.data_resources.as_deref()
    }
    /// <p>An optional list of service event sources from which you do not want management events to be logged on your trail. In this release, the list can be empty (disables the filter), or it can filter out Key Management Service or Amazon RDS Data API events by containing <code>kms.amazonaws.com</code> or <code>rdsdata.amazonaws.com</code>. By default, <code>ExcludeManagementEventSources</code> is empty, and KMS and Amazon RDS Data API events are logged to your trail. You can exclude management event sources only in regions that support the event source.</p>
    pub fn exclude_management_event_sources(&self) -> std::option::Option<&[std::string::String]> {
        self.exclude_management_event_sources.as_deref()
    }
}
impl std::fmt::Debug for EventSelector {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EventSelector");
        formatter.field("read_write_type", &self.read_write_type);
        formatter.field("include_management_events", &self.include_management_events);
        formatter.field("data_resources", &self.data_resources);
        formatter.field(
            "exclude_management_event_sources",
            &self.exclude_management_event_sources,
        );
        formatter.finish()
    }
}
/// See [`EventSelector`](crate::model::EventSelector)
pub mod event_selector {
    /// A builder for [`EventSelector`](crate::model::EventSelector)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) read_write_type: std::option::Option<crate::model::ReadWriteType>,
        pub(crate) include_management_events: std::option::Option<bool>,
        pub(crate) data_resources: std::option::Option<std::vec::Vec<crate::model::DataResource>>,
        pub(crate) exclude_management_event_sources:
            std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>Specify if you want your trail to log read-only events, write-only events, or all. For example, the EC2 <code>GetConsoleOutput</code> is a read-only API operation and <code>RunInstances</code> is a write-only API operation.</p>
        /// <p> By default, the value is <code>All</code>.</p>
        pub fn read_write_type(mut self, input: crate::model::ReadWriteType) -> Self {
            self.read_write_type = Some(input);
            self
        }
        /// <p>Specify if you want your trail to log read-only events, write-only events, or all. For example, the EC2 <code>GetConsoleOutput</code> is a read-only API operation and <code>RunInstances</code> is a write-only API operation.</p>
        /// <p> By default, the value is <code>All</code>.</p>
        pub fn set_read_write_type(
            mut self,
            input: std::option::Option<crate::model::ReadWriteType>,
        ) -> Self {
            self.read_write_type = input;
            self
        }
        /// <p>Specify if you want your event selector to include management events for your trail.</p>
        /// <p> For more information, see <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/logging-management-and-data-events-with-cloudtrail.html#logging-management-events">Management Events</a> in the <i>CloudTrail User Guide</i>.</p>
        /// <p>By default, the value is <code>true</code>.</p>
        /// <p>The first copy of management events is free. You are charged for additional copies of management events that you are logging on any subsequent trail in the same region. For more information about CloudTrail pricing, see <a href="http://aws.amazon.com/cloudtrail/pricing/">CloudTrail Pricing</a>.</p>
        pub fn include_management_events(mut self, input: bool) -> Self {
            self.include_management_events = Some(input);
            self
        }
        /// <p>Specify if you want your event selector to include management events for your trail.</p>
        /// <p> For more information, see <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/logging-management-and-data-events-with-cloudtrail.html#logging-management-events">Management Events</a> in the <i>CloudTrail User Guide</i>.</p>
        /// <p>By default, the value is <code>true</code>.</p>
        /// <p>The first copy of management events is free. You are charged for additional copies of management events that you are logging on any subsequent trail in the same region. For more information about CloudTrail pricing, see <a href="http://aws.amazon.com/cloudtrail/pricing/">CloudTrail Pricing</a>.</p>
        pub fn set_include_management_events(mut self, input: std::option::Option<bool>) -> Self {
            self.include_management_events = input;
            self
        }
        /// Appends an item to `data_resources`.
        ///
        /// To override the contents of this collection use [`set_data_resources`](Self::set_data_resources).
        ///
        /// <p>CloudTrail supports data event logging for Amazon S3 objects, Lambda functions, and Amazon DynamoDB tables with basic event selectors. You can specify up to 250 resources for an individual event selector, but the total number of data resources cannot exceed 250 across all event selectors in a trail. This limit does not apply if you configure resource logging for all data events.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/logging-management-and-data-events-with-cloudtrail.html#logging-data-events">Data Events</a> and <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/WhatIsCloudTrail-Limits.html">Limits in CloudTrail</a> in the <i>CloudTrail User Guide</i>.</p>
        pub fn data_resources(mut self, input: crate::model::DataResource) -> Self {
            let mut v = self.data_resources.unwrap_or_default();
            v.push(input);
            self.data_resources = Some(v);
            self
        }
        /// <p>CloudTrail supports data event logging for Amazon S3 objects, Lambda functions, and Amazon DynamoDB tables with basic event selectors. You can specify up to 250 resources for an individual event selector, but the total number of data resources cannot exceed 250 across all event selectors in a trail. This limit does not apply if you configure resource logging for all data events.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/logging-management-and-data-events-with-cloudtrail.html#logging-data-events">Data Events</a> and <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/WhatIsCloudTrail-Limits.html">Limits in CloudTrail</a> in the <i>CloudTrail User Guide</i>.</p>
        pub fn set_data_resources(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DataResource>>,
        ) -> Self {
            self.data_resources = input;
            self
        }
        /// Appends an item to `exclude_management_event_sources`.
        ///
        /// To override the contents of this collection use [`set_exclude_management_event_sources`](Self::set_exclude_management_event_sources).
        ///
        /// <p>An optional list of service event sources from which you do not want management events to be logged on your trail. In this release, the list can be empty (disables the filter), or it can filter out Key Management Service or Amazon RDS Data API events by containing <code>kms.amazonaws.com</code> or <code>rdsdata.amazonaws.com</code>. By default, <code>ExcludeManagementEventSources</code> is empty, and KMS and Amazon RDS Data API events are logged to your trail. You can exclude management event sources only in regions that support the event source.</p>
        pub fn exclude_management_event_sources(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            let mut v = self.exclude_management_event_sources.unwrap_or_default();
            v.push(input.into());
            self.exclude_management_event_sources = Some(v);
            self
        }
        /// <p>An optional list of service event sources from which you do not want management events to be logged on your trail. In this release, the list can be empty (disables the filter), or it can filter out Key Management Service or Amazon RDS Data API events by containing <code>kms.amazonaws.com</code> or <code>rdsdata.amazonaws.com</code>. By default, <code>ExcludeManagementEventSources</code> is empty, and KMS and Amazon RDS Data API events are logged to your trail. You can exclude management event sources only in regions that support the event source.</p>
        pub fn set_exclude_management_event_sources(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.exclude_management_event_sources = input;
            self
        }
        /// Consumes the builder and constructs a [`EventSelector`](crate::model::EventSelector)
        pub fn build(self) -> crate::model::EventSelector {
            crate::model::EventSelector {
                read_write_type: self.read_write_type,
                include_management_events: self.include_management_events,
                data_resources: self.data_resources,
                exclude_management_event_sources: self.exclude_management_event_sources,
            }
        }
    }
}
impl EventSelector {
    /// Creates a new builder-style object to manufacture [`EventSelector`](crate::model::EventSelector)
    pub fn builder() -> crate::model::event_selector::Builder {
        crate::model::event_selector::Builder::default()
    }
}

/// <p>The Amazon S3 buckets, Lambda functions, or Amazon DynamoDB tables that you specify in your event selectors for your trail to log data events. Data events provide information about the resource operations performed on or within a resource itself. These are also known as data plane operations. You can specify up to 250 data resources for a trail.</p> <note>
/// <p>The total number of allowed data resources is 250. This number can be distributed between 1 and 5 event selectors, but the total cannot exceed 250 across all selectors.</p>
/// <p>If you are using advanced event selectors, the maximum total number of values for all conditions, across all advanced event selectors for the trail, is 500.</p>
/// </note>
/// <p>The following example demonstrates how logging works when you configure logging of all data events for an S3 bucket named <code>bucket-1</code>. In this example, the CloudTrail user specified an empty prefix, and the option to log both <code>Read</code> and <code>Write</code> data events.</p>
/// <ol>
/// <li> <p>A user uploads an image file to <code>bucket-1</code>.</p> </li>
/// <li> <p>The <code>PutObject</code> API operation is an Amazon S3 object-level API. It is recorded as a data event in CloudTrail. Because the CloudTrail user specified an S3 bucket with an empty prefix, events that occur on any object in that bucket are logged. The trail processes and logs the event.</p> </li>
/// <li> <p>A user uploads an object to an Amazon S3 bucket named <code>arn:aws:s3:::bucket-2</code>.</p> </li>
/// <li> <p>The <code>PutObject</code> API operation occurred for an object in an S3 bucket that the CloudTrail user didn't specify for the trail. The trail doesn’t log the event.</p> </li>
/// </ol>
/// <p>The following example demonstrates how logging works when you configure logging of Lambda data events for a Lambda function named <i>MyLambdaFunction</i>, but not for all Lambda functions.</p>
/// <ol>
/// <li> <p>A user runs a script that includes a call to the <i>MyLambdaFunction</i> function and the <i>MyOtherLambdaFunction</i> function.</p> </li>
/// <li> <p>The <code>Invoke</code> API operation on <i>MyLambdaFunction</i> is an Lambda API. It is recorded as a data event in CloudTrail. Because the CloudTrail user specified logging data events for <i>MyLambdaFunction</i>, any invocations of that function are logged. The trail processes and logs the event.</p> </li>
/// <li> <p>The <code>Invoke</code> API operation on <i>MyOtherLambdaFunction</i> is an Lambda API. Because the CloudTrail user did not specify logging data events for all Lambda functions, the <code>Invoke</code> operation for <i>MyOtherLambdaFunction</i> does not match the function specified for the trail. The trail doesn’t log the event. </p> </li>
/// </ol>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DataResource {
    /// <p>The resource type in which you want to log data events. You can specify the following <i>basic</i> event selector resource types:</p>
    /// <ul>
    /// <li> <p> <code>AWS::S3::Object</code> </p> </li>
    /// <li> <p> <code>AWS::Lambda::Function</code> </p> </li>
    /// <li> <p> <code>AWS::DynamoDB::Table</code> </p> </li>
    /// </ul>
    /// <p>The following resource types are also availble through <i>advanced</i> event selectors. Basic event selector resource types are valid in advanced event selectors, but advanced event selector resource types are not valid in basic event selectors. For more information, see <code>AdvancedFieldSelector$Field</code>.</p>
    /// <ul>
    /// <li> <p> <code>AWS::S3Outposts::Object</code> </p> </li>
    /// <li> <p> <code>AWS::ManagedBlockchain::Node</code> </p> </li>
    /// <li> <p> <code>AWS::S3ObjectLambda::AccessPoint</code> </p> </li>
    /// <li> <p> <code>AWS::EC2::Snapshot</code> </p> </li>
    /// <li> <p> <code>AWS::S3::AccessPoint</code> </p> </li>
    /// <li> <p> <code>AWS::DynamoDB::Stream</code> </p> </li>
    /// <li> <p> <code>AWS::Glue::Table</code> </p> </li>
    /// </ul>
    pub r#type: std::option::Option<std::string::String>,
    /// <p>An array of Amazon Resource Name (ARN) strings or partial ARN strings for the specified objects.</p>
    /// <ul>
    /// <li> <p>To log data events for all objects in all S3 buckets in your Amazon Web Services account, specify the prefix as <code>arn:aws:s3:::</code>.</p> <note>
    /// <p>This also enables logging of data event activity performed by any user or role in your Amazon Web Services account, even if that activity is performed on a bucket that belongs to another Amazon Web Services account.</p>
    /// </note> </li>
    /// <li> <p>To log data events for all objects in an S3 bucket, specify the bucket and an empty object prefix such as <code>arn:aws:s3:::bucket-1/</code>. The trail logs data events for all objects in this S3 bucket.</p> </li>
    /// <li> <p>To log data events for specific objects, specify the S3 bucket and object prefix such as <code>arn:aws:s3:::bucket-1/example-images</code>. The trail logs data events for objects in this S3 bucket that match the prefix.</p> </li>
    /// <li> <p>To log data events for all Lambda functions in your Amazon Web Services account, specify the prefix as <code>arn:aws:lambda</code>.</p> <note>
    /// <p>This also enables logging of <code>Invoke</code> activity performed by any user or role in your Amazon Web Services account, even if that activity is performed on a function that belongs to another Amazon Web Services account. </p>
    /// </note> </li>
    /// <li> <p>To log data events for a specific Lambda function, specify the function ARN.</p> <note>
    /// <p>Lambda function ARNs are exact. For example, if you specify a function ARN <i>arn:aws:lambda:us-west-2:111111111111:function:helloworld</i>, data events will only be logged for <i>arn:aws:lambda:us-west-2:111111111111:function:helloworld</i>. They will not be logged for <i>arn:aws:lambda:us-west-2:111111111111:function:helloworld2</i>.</p>
    /// </note> </li>
    /// <li> <p>To log data events for all DynamoDB tables in your Amazon Web Services account, specify the prefix as <code>arn:aws:dynamodb</code>.</p> </li>
    /// </ul>
    pub values: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl DataResource {
    /// <p>The resource type in which you want to log data events. You can specify the following <i>basic</i> event selector resource types:</p>
    /// <ul>
    /// <li> <p> <code>AWS::S3::Object</code> </p> </li>
    /// <li> <p> <code>AWS::Lambda::Function</code> </p> </li>
    /// <li> <p> <code>AWS::DynamoDB::Table</code> </p> </li>
    /// </ul>
    /// <p>The following resource types are also availble through <i>advanced</i> event selectors. Basic event selector resource types are valid in advanced event selectors, but advanced event selector resource types are not valid in basic event selectors. For more information, see <code>AdvancedFieldSelector$Field</code>.</p>
    /// <ul>
    /// <li> <p> <code>AWS::S3Outposts::Object</code> </p> </li>
    /// <li> <p> <code>AWS::ManagedBlockchain::Node</code> </p> </li>
    /// <li> <p> <code>AWS::S3ObjectLambda::AccessPoint</code> </p> </li>
    /// <li> <p> <code>AWS::EC2::Snapshot</code> </p> </li>
    /// <li> <p> <code>AWS::S3::AccessPoint</code> </p> </li>
    /// <li> <p> <code>AWS::DynamoDB::Stream</code> </p> </li>
    /// <li> <p> <code>AWS::Glue::Table</code> </p> </li>
    /// </ul>
    pub fn r#type(&self) -> std::option::Option<&str> {
        self.r#type.as_deref()
    }
    /// <p>An array of Amazon Resource Name (ARN) strings or partial ARN strings for the specified objects.</p>
    /// <ul>
    /// <li> <p>To log data events for all objects in all S3 buckets in your Amazon Web Services account, specify the prefix as <code>arn:aws:s3:::</code>.</p> <note>
    /// <p>This also enables logging of data event activity performed by any user or role in your Amazon Web Services account, even if that activity is performed on a bucket that belongs to another Amazon Web Services account.</p>
    /// </note> </li>
    /// <li> <p>To log data events for all objects in an S3 bucket, specify the bucket and an empty object prefix such as <code>arn:aws:s3:::bucket-1/</code>. The trail logs data events for all objects in this S3 bucket.</p> </li>
    /// <li> <p>To log data events for specific objects, specify the S3 bucket and object prefix such as <code>arn:aws:s3:::bucket-1/example-images</code>. The trail logs data events for objects in this S3 bucket that match the prefix.</p> </li>
    /// <li> <p>To log data events for all Lambda functions in your Amazon Web Services account, specify the prefix as <code>arn:aws:lambda</code>.</p> <note>
    /// <p>This also enables logging of <code>Invoke</code> activity performed by any user or role in your Amazon Web Services account, even if that activity is performed on a function that belongs to another Amazon Web Services account. </p>
    /// </note> </li>
    /// <li> <p>To log data events for a specific Lambda function, specify the function ARN.</p> <note>
    /// <p>Lambda function ARNs are exact. For example, if you specify a function ARN <i>arn:aws:lambda:us-west-2:111111111111:function:helloworld</i>, data events will only be logged for <i>arn:aws:lambda:us-west-2:111111111111:function:helloworld</i>. They will not be logged for <i>arn:aws:lambda:us-west-2:111111111111:function:helloworld2</i>.</p>
    /// </note> </li>
    /// <li> <p>To log data events for all DynamoDB tables in your Amazon Web Services account, specify the prefix as <code>arn:aws:dynamodb</code>.</p> </li>
    /// </ul>
    pub fn values(&self) -> std::option::Option<&[std::string::String]> {
        self.values.as_deref()
    }
}
impl std::fmt::Debug for DataResource {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DataResource");
        formatter.field("r#type", &self.r#type);
        formatter.field("values", &self.values);
        formatter.finish()
    }
}
/// See [`DataResource`](crate::model::DataResource)
pub mod data_resource {
    /// A builder for [`DataResource`](crate::model::DataResource)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) r#type: std::option::Option<std::string::String>,
        pub(crate) values: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The resource type in which you want to log data events. You can specify the following <i>basic</i> event selector resource types:</p>
        /// <ul>
        /// <li> <p> <code>AWS::S3::Object</code> </p> </li>
        /// <li> <p> <code>AWS::Lambda::Function</code> </p> </li>
        /// <li> <p> <code>AWS::DynamoDB::Table</code> </p> </li>
        /// </ul>
        /// <p>The following resource types are also availble through <i>advanced</i> event selectors. Basic event selector resource types are valid in advanced event selectors, but advanced event selector resource types are not valid in basic event selectors. For more information, see <code>AdvancedFieldSelector$Field</code>.</p>
        /// <ul>
        /// <li> <p> <code>AWS::S3Outposts::Object</code> </p> </li>
        /// <li> <p> <code>AWS::ManagedBlockchain::Node</code> </p> </li>
        /// <li> <p> <code>AWS::S3ObjectLambda::AccessPoint</code> </p> </li>
        /// <li> <p> <code>AWS::EC2::Snapshot</code> </p> </li>
        /// <li> <p> <code>AWS::S3::AccessPoint</code> </p> </li>
        /// <li> <p> <code>AWS::DynamoDB::Stream</code> </p> </li>
        /// <li> <p> <code>AWS::Glue::Table</code> </p> </li>
        /// </ul>
        pub fn r#type(mut self, input: impl Into<std::string::String>) -> Self {
            self.r#type = Some(input.into());
            self
        }
        /// <p>The resource type in which you want to log data events. You can specify the following <i>basic</i> event selector resource types:</p>
        /// <ul>
        /// <li> <p> <code>AWS::S3::Object</code> </p> </li>
        /// <li> <p> <code>AWS::Lambda::Function</code> </p> </li>
        /// <li> <p> <code>AWS::DynamoDB::Table</code> </p> </li>
        /// </ul>
        /// <p>The following resource types are also availble through <i>advanced</i> event selectors. Basic event selector resource types are valid in advanced event selectors, but advanced event selector resource types are not valid in basic event selectors. For more information, see <code>AdvancedFieldSelector$Field</code>.</p>
        /// <ul>
        /// <li> <p> <code>AWS::S3Outposts::Object</code> </p> </li>
        /// <li> <p> <code>AWS::ManagedBlockchain::Node</code> </p> </li>
        /// <li> <p> <code>AWS::S3ObjectLambda::AccessPoint</code> </p> </li>
        /// <li> <p> <code>AWS::EC2::Snapshot</code> </p> </li>
        /// <li> <p> <code>AWS::S3::AccessPoint</code> </p> </li>
        /// <li> <p> <code>AWS::DynamoDB::Stream</code> </p> </li>
        /// <li> <p> <code>AWS::Glue::Table</code> </p> </li>
        /// </ul>
        pub fn set_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.r#type = input;
            self
        }
        /// Appends an item to `values`.
        ///
        /// To override the contents of this collection use [`set_values`](Self::set_values).
        ///
        /// <p>An array of Amazon Resource Name (ARN) strings or partial ARN strings for the specified objects.</p>
        /// <ul>
        /// <li> <p>To log data events for all objects in all S3 buckets in your Amazon Web Services account, specify the prefix as <code>arn:aws:s3:::</code>.</p> <note>
        /// <p>This also enables logging of data event activity performed by any user or role in your Amazon Web Services account, even if that activity is performed on a bucket that belongs to another Amazon Web Services account.</p>
        /// </note> </li>
        /// <li> <p>To log data events for all objects in an S3 bucket, specify the bucket and an empty object prefix such as <code>arn:aws:s3:::bucket-1/</code>. The trail logs data events for all objects in this S3 bucket.</p> </li>
        /// <li> <p>To log data events for specific objects, specify the S3 bucket and object prefix such as <code>arn:aws:s3:::bucket-1/example-images</code>. The trail logs data events for objects in this S3 bucket that match the prefix.</p> </li>
        /// <li> <p>To log data events for all Lambda functions in your Amazon Web Services account, specify the prefix as <code>arn:aws:lambda</code>.</p> <note>
        /// <p>This also enables logging of <code>Invoke</code> activity performed by any user or role in your Amazon Web Services account, even if that activity is performed on a function that belongs to another Amazon Web Services account. </p>
        /// </note> </li>
        /// <li> <p>To log data events for a specific Lambda function, specify the function ARN.</p> <note>
        /// <p>Lambda function ARNs are exact. For example, if you specify a function ARN <i>arn:aws:lambda:us-west-2:111111111111:function:helloworld</i>, data events will only be logged for <i>arn:aws:lambda:us-west-2:111111111111:function:helloworld</i>. They will not be logged for <i>arn:aws:lambda:us-west-2:111111111111:function:helloworld2</i>.</p>
        /// </note> </li>
        /// <li> <p>To log data events for all DynamoDB tables in your Amazon Web Services account, specify the prefix as <code>arn:aws:dynamodb</code>.</p> </li>
        /// </ul>
        pub fn values(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.values.unwrap_or_default();
            v.push(input.into());
            self.values = Some(v);
            self
        }
        /// <p>An array of Amazon Resource Name (ARN) strings or partial ARN strings for the specified objects.</p>
        /// <ul>
        /// <li> <p>To log data events for all objects in all S3 buckets in your Amazon Web Services account, specify the prefix as <code>arn:aws:s3:::</code>.</p> <note>
        /// <p>This also enables logging of data event activity performed by any user or role in your Amazon Web Services account, even if that activity is performed on a bucket that belongs to another Amazon Web Services account.</p>
        /// </note> </li>
        /// <li> <p>To log data events for all objects in an S3 bucket, specify the bucket and an empty object prefix such as <code>arn:aws:s3:::bucket-1/</code>. The trail logs data events for all objects in this S3 bucket.</p> </li>
        /// <li> <p>To log data events for specific objects, specify the S3 bucket and object prefix such as <code>arn:aws:s3:::bucket-1/example-images</code>. The trail logs data events for objects in this S3 bucket that match the prefix.</p> </li>
        /// <li> <p>To log data events for all Lambda functions in your Amazon Web Services account, specify the prefix as <code>arn:aws:lambda</code>.</p> <note>
        /// <p>This also enables logging of <code>Invoke</code> activity performed by any user or role in your Amazon Web Services account, even if that activity is performed on a function that belongs to another Amazon Web Services account. </p>
        /// </note> </li>
        /// <li> <p>To log data events for a specific Lambda function, specify the function ARN.</p> <note>
        /// <p>Lambda function ARNs are exact. For example, if you specify a function ARN <i>arn:aws:lambda:us-west-2:111111111111:function:helloworld</i>, data events will only be logged for <i>arn:aws:lambda:us-west-2:111111111111:function:helloworld</i>. They will not be logged for <i>arn:aws:lambda:us-west-2:111111111111:function:helloworld2</i>.</p>
        /// </note> </li>
        /// <li> <p>To log data events for all DynamoDB tables in your Amazon Web Services account, specify the prefix as <code>arn:aws:dynamodb</code>.</p> </li>
        /// </ul>
        pub fn set_values(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.values = input;
            self
        }
        /// Consumes the builder and constructs a [`DataResource`](crate::model::DataResource)
        pub fn build(self) -> crate::model::DataResource {
            crate::model::DataResource {
                r#type: self.r#type,
                values: self.values,
            }
        }
    }
}
impl DataResource {
    /// Creates a new builder-style object to manufacture [`DataResource`](crate::model::DataResource)
    pub fn builder() -> crate::model::data_resource::Builder {
        crate::model::data_resource::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ReadWriteType {
    #[allow(missing_docs)] // documentation missing in model
    All,
    #[allow(missing_docs)] // documentation missing in model
    ReadOnly,
    #[allow(missing_docs)] // documentation missing in model
    WriteOnly,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ReadWriteType {
    fn from(s: &str) -> Self {
        match s {
            "All" => ReadWriteType::All,
            "ReadOnly" => ReadWriteType::ReadOnly,
            "WriteOnly" => ReadWriteType::WriteOnly,
            other => ReadWriteType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ReadWriteType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ReadWriteType::from(s))
    }
}
impl ReadWriteType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ReadWriteType::All => "All",
            ReadWriteType::ReadOnly => "ReadOnly",
            ReadWriteType::WriteOnly => "WriteOnly",
            ReadWriteType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["All", "ReadOnly", "WriteOnly"]
    }
}
impl AsRef<str> for ReadWriteType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Contains information about an event that was returned by a lookup request. The result includes a representation of a CloudTrail event.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Event {
    /// <p>The CloudTrail ID of the event returned.</p>
    pub event_id: std::option::Option<std::string::String>,
    /// <p>The name of the event returned.</p>
    pub event_name: std::option::Option<std::string::String>,
    /// <p>Information about whether the event is a write event or a read event. </p>
    pub read_only: std::option::Option<std::string::String>,
    /// <p>The Amazon Web Services access key ID that was used to sign the request. If the request was made with temporary security credentials, this is the access key ID of the temporary credentials.</p>
    pub access_key_id: std::option::Option<std::string::String>,
    /// <p>The date and time of the event returned.</p>
    pub event_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The Amazon Web Services service to which the request was made.</p>
    pub event_source: std::option::Option<std::string::String>,
    /// <p>A user name or role name of the requester that called the API in the event returned.</p>
    pub username: std::option::Option<std::string::String>,
    /// <p>A list of resources referenced by the event returned.</p>
    pub resources: std::option::Option<std::vec::Vec<crate::model::Resource>>,
    /// <p>A JSON string that contains a representation of the event returned.</p>
    pub cloud_trail_event: std::option::Option<std::string::String>,
}
impl Event {
    /// <p>The CloudTrail ID of the event returned.</p>
    pub fn event_id(&self) -> std::option::Option<&str> {
        self.event_id.as_deref()
    }
    /// <p>The name of the event returned.</p>
    pub fn event_name(&self) -> std::option::Option<&str> {
        self.event_name.as_deref()
    }
    /// <p>Information about whether the event is a write event or a read event. </p>
    pub fn read_only(&self) -> std::option::Option<&str> {
        self.read_only.as_deref()
    }
    /// <p>The Amazon Web Services access key ID that was used to sign the request. If the request was made with temporary security credentials, this is the access key ID of the temporary credentials.</p>
    pub fn access_key_id(&self) -> std::option::Option<&str> {
        self.access_key_id.as_deref()
    }
    /// <p>The date and time of the event returned.</p>
    pub fn event_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.event_time.as_ref()
    }
    /// <p>The Amazon Web Services service to which the request was made.</p>
    pub fn event_source(&self) -> std::option::Option<&str> {
        self.event_source.as_deref()
    }
    /// <p>A user name or role name of the requester that called the API in the event returned.</p>
    pub fn username(&self) -> std::option::Option<&str> {
        self.username.as_deref()
    }
    /// <p>A list of resources referenced by the event returned.</p>
    pub fn resources(&self) -> std::option::Option<&[crate::model::Resource]> {
        self.resources.as_deref()
    }
    /// <p>A JSON string that contains a representation of the event returned.</p>
    pub fn cloud_trail_event(&self) -> std::option::Option<&str> {
        self.cloud_trail_event.as_deref()
    }
}
impl std::fmt::Debug for Event {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Event");
        formatter.field("event_id", &self.event_id);
        formatter.field("event_name", &self.event_name);
        formatter.field("read_only", &self.read_only);
        formatter.field("access_key_id", &self.access_key_id);
        formatter.field("event_time", &self.event_time);
        formatter.field("event_source", &self.event_source);
        formatter.field("username", &self.username);
        formatter.field("resources", &self.resources);
        formatter.field("cloud_trail_event", &self.cloud_trail_event);
        formatter.finish()
    }
}
/// See [`Event`](crate::model::Event)
pub mod event {
    /// A builder for [`Event`](crate::model::Event)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) event_id: std::option::Option<std::string::String>,
        pub(crate) event_name: std::option::Option<std::string::String>,
        pub(crate) read_only: std::option::Option<std::string::String>,
        pub(crate) access_key_id: std::option::Option<std::string::String>,
        pub(crate) event_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) event_source: std::option::Option<std::string::String>,
        pub(crate) username: std::option::Option<std::string::String>,
        pub(crate) resources: std::option::Option<std::vec::Vec<crate::model::Resource>>,
        pub(crate) cloud_trail_event: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The CloudTrail ID of the event returned.</p>
        pub fn event_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.event_id = Some(input.into());
            self
        }
        /// <p>The CloudTrail ID of the event returned.</p>
        pub fn set_event_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.event_id = input;
            self
        }
        /// <p>The name of the event returned.</p>
        pub fn event_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.event_name = Some(input.into());
            self
        }
        /// <p>The name of the event returned.</p>
        pub fn set_event_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.event_name = input;
            self
        }
        /// <p>Information about whether the event is a write event or a read event. </p>
        pub fn read_only(mut self, input: impl Into<std::string::String>) -> Self {
            self.read_only = Some(input.into());
            self
        }
        /// <p>Information about whether the event is a write event or a read event. </p>
        pub fn set_read_only(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.read_only = input;
            self
        }
        /// <p>The Amazon Web Services access key ID that was used to sign the request. If the request was made with temporary security credentials, this is the access key ID of the temporary credentials.</p>
        pub fn access_key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.access_key_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services access key ID that was used to sign the request. If the request was made with temporary security credentials, this is the access key ID of the temporary credentials.</p>
        pub fn set_access_key_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.access_key_id = input;
            self
        }
        /// <p>The date and time of the event returned.</p>
        pub fn event_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.event_time = Some(input);
            self
        }
        /// <p>The date and time of the event returned.</p>
        pub fn set_event_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.event_time = input;
            self
        }
        /// <p>The Amazon Web Services service to which the request was made.</p>
        pub fn event_source(mut self, input: impl Into<std::string::String>) -> Self {
            self.event_source = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services service to which the request was made.</p>
        pub fn set_event_source(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.event_source = input;
            self
        }
        /// <p>A user name or role name of the requester that called the API in the event returned.</p>
        pub fn username(mut self, input: impl Into<std::string::String>) -> Self {
            self.username = Some(input.into());
            self
        }
        /// <p>A user name or role name of the requester that called the API in the event returned.</p>
        pub fn set_username(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.username = input;
            self
        }
        /// Appends an item to `resources`.
        ///
        /// To override the contents of this collection use [`set_resources`](Self::set_resources).
        ///
        /// <p>A list of resources referenced by the event returned.</p>
        pub fn resources(mut self, input: crate::model::Resource) -> Self {
            let mut v = self.resources.unwrap_or_default();
            v.push(input);
            self.resources = Some(v);
            self
        }
        /// <p>A list of resources referenced by the event returned.</p>
        pub fn set_resources(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Resource>>,
        ) -> Self {
            self.resources = input;
            self
        }
        /// <p>A JSON string that contains a representation of the event returned.</p>
        pub fn cloud_trail_event(mut self, input: impl Into<std::string::String>) -> Self {
            self.cloud_trail_event = Some(input.into());
            self
        }
        /// <p>A JSON string that contains a representation of the event returned.</p>
        pub fn set_cloud_trail_event(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.cloud_trail_event = input;
            self
        }
        /// Consumes the builder and constructs a [`Event`](crate::model::Event)
        pub fn build(self) -> crate::model::Event {
            crate::model::Event {
                event_id: self.event_id,
                event_name: self.event_name,
                read_only: self.read_only,
                access_key_id: self.access_key_id,
                event_time: self.event_time,
                event_source: self.event_source,
                username: self.username,
                resources: self.resources,
                cloud_trail_event: self.cloud_trail_event,
            }
        }
    }
}
impl Event {
    /// Creates a new builder-style object to manufacture [`Event`](crate::model::Event)
    pub fn builder() -> crate::model::event::Builder {
        crate::model::event::Builder::default()
    }
}

/// <p>Specifies the type and name of a resource referenced by an event.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Resource {
    /// <p>The type of a resource referenced by the event returned. When the resource type cannot be determined, null is returned. Some examples of resource types are: <b>Instance</b> for EC2, <b>Trail</b> for CloudTrail, <b>DBInstance</b> for Amazon RDS, and <b>AccessKey</b> for IAM. To learn more about how to look up and filter events by the resource types supported for a service, see <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/view-cloudtrail-events-console.html#filtering-cloudtrail-events">Filtering CloudTrail Events</a>.</p>
    pub resource_type: std::option::Option<std::string::String>,
    /// <p>The name of the resource referenced by the event returned. These are user-created names whose values will depend on the environment. For example, the resource name might be "auto-scaling-test-group" for an Auto Scaling Group or "i-1234567" for an EC2 Instance.</p>
    pub resource_name: std::option::Option<std::string::String>,
}
impl Resource {
    /// <p>The type of a resource referenced by the event returned. When the resource type cannot be determined, null is returned. Some examples of resource types are: <b>Instance</b> for EC2, <b>Trail</b> for CloudTrail, <b>DBInstance</b> for Amazon RDS, and <b>AccessKey</b> for IAM. To learn more about how to look up and filter events by the resource types supported for a service, see <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/view-cloudtrail-events-console.html#filtering-cloudtrail-events">Filtering CloudTrail Events</a>.</p>
    pub fn resource_type(&self) -> std::option::Option<&str> {
        self.resource_type.as_deref()
    }
    /// <p>The name of the resource referenced by the event returned. These are user-created names whose values will depend on the environment. For example, the resource name might be "auto-scaling-test-group" for an Auto Scaling Group or "i-1234567" for an EC2 Instance.</p>
    pub fn resource_name(&self) -> std::option::Option<&str> {
        self.resource_name.as_deref()
    }
}
impl std::fmt::Debug for Resource {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Resource");
        formatter.field("resource_type", &self.resource_type);
        formatter.field("resource_name", &self.resource_name);
        formatter.finish()
    }
}
/// See [`Resource`](crate::model::Resource)
pub mod resource {
    /// A builder for [`Resource`](crate::model::Resource)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_type: std::option::Option<std::string::String>,
        pub(crate) resource_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The type of a resource referenced by the event returned. When the resource type cannot be determined, null is returned. Some examples of resource types are: <b>Instance</b> for EC2, <b>Trail</b> for CloudTrail, <b>DBInstance</b> for Amazon RDS, and <b>AccessKey</b> for IAM. To learn more about how to look up and filter events by the resource types supported for a service, see <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/view-cloudtrail-events-console.html#filtering-cloudtrail-events">Filtering CloudTrail Events</a>.</p>
        pub fn resource_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_type = Some(input.into());
            self
        }
        /// <p>The type of a resource referenced by the event returned. When the resource type cannot be determined, null is returned. Some examples of resource types are: <b>Instance</b> for EC2, <b>Trail</b> for CloudTrail, <b>DBInstance</b> for Amazon RDS, and <b>AccessKey</b> for IAM. To learn more about how to look up and filter events by the resource types supported for a service, see <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/view-cloudtrail-events-console.html#filtering-cloudtrail-events">Filtering CloudTrail Events</a>.</p>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_type = input;
            self
        }
        /// <p>The name of the resource referenced by the event returned. These are user-created names whose values will depend on the environment. For example, the resource name might be "auto-scaling-test-group" for an Auto Scaling Group or "i-1234567" for an EC2 Instance.</p>
        pub fn resource_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_name = Some(input.into());
            self
        }
        /// <p>The name of the resource referenced by the event returned. These are user-created names whose values will depend on the environment. For example, the resource name might be "auto-scaling-test-group" for an Auto Scaling Group or "i-1234567" for an EC2 Instance.</p>
        pub fn set_resource_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_name = input;
            self
        }
        /// Consumes the builder and constructs a [`Resource`](crate::model::Resource)
        pub fn build(self) -> crate::model::Resource {
            crate::model::Resource {
                resource_type: self.resource_type,
                resource_name: self.resource_name,
            }
        }
    }
}
impl Resource {
    /// Creates a new builder-style object to manufacture [`Resource`](crate::model::Resource)
    pub fn builder() -> crate::model::resource::Builder {
        crate::model::resource::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum EventCategory {
    #[allow(missing_docs)] // documentation missing in model
    Insight,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for EventCategory {
    fn from(s: &str) -> Self {
        match s {
            "insight" => EventCategory::Insight,
            other => EventCategory::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for EventCategory {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(EventCategory::from(s))
    }
}
impl EventCategory {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            EventCategory::Insight => "insight",
            EventCategory::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["insight"]
    }
}
impl AsRef<str> for EventCategory {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Specifies an attribute and value that filter the events returned.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LookupAttribute {
    /// <p>Specifies an attribute on which to filter the events returned.</p>
    pub attribute_key: std::option::Option<crate::model::LookupAttributeKey>,
    /// <p>Specifies a value for the specified AttributeKey.</p>
    pub attribute_value: std::option::Option<std::string::String>,
}
impl LookupAttribute {
    /// <p>Specifies an attribute on which to filter the events returned.</p>
    pub fn attribute_key(&self) -> std::option::Option<&crate::model::LookupAttributeKey> {
        self.attribute_key.as_ref()
    }
    /// <p>Specifies a value for the specified AttributeKey.</p>
    pub fn attribute_value(&self) -> std::option::Option<&str> {
        self.attribute_value.as_deref()
    }
}
impl std::fmt::Debug for LookupAttribute {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LookupAttribute");
        formatter.field("attribute_key", &self.attribute_key);
        formatter.field("attribute_value", &self.attribute_value);
        formatter.finish()
    }
}
/// See [`LookupAttribute`](crate::model::LookupAttribute)
pub mod lookup_attribute {
    /// A builder for [`LookupAttribute`](crate::model::LookupAttribute)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) attribute_key: std::option::Option<crate::model::LookupAttributeKey>,
        pub(crate) attribute_value: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Specifies an attribute on which to filter the events returned.</p>
        pub fn attribute_key(mut self, input: crate::model::LookupAttributeKey) -> Self {
            self.attribute_key = Some(input);
            self
        }
        /// <p>Specifies an attribute on which to filter the events returned.</p>
        pub fn set_attribute_key(
            mut self,
            input: std::option::Option<crate::model::LookupAttributeKey>,
        ) -> Self {
            self.attribute_key = input;
            self
        }
        /// <p>Specifies a value for the specified AttributeKey.</p>
        pub fn attribute_value(mut self, input: impl Into<std::string::String>) -> Self {
            self.attribute_value = Some(input.into());
            self
        }
        /// <p>Specifies a value for the specified AttributeKey.</p>
        pub fn set_attribute_value(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.attribute_value = input;
            self
        }
        /// Consumes the builder and constructs a [`LookupAttribute`](crate::model::LookupAttribute)
        pub fn build(self) -> crate::model::LookupAttribute {
            crate::model::LookupAttribute {
                attribute_key: self.attribute_key,
                attribute_value: self.attribute_value,
            }
        }
    }
}
impl LookupAttribute {
    /// Creates a new builder-style object to manufacture [`LookupAttribute`](crate::model::LookupAttribute)
    pub fn builder() -> crate::model::lookup_attribute::Builder {
        crate::model::lookup_attribute::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum LookupAttributeKey {
    #[allow(missing_docs)] // documentation missing in model
    AccessKeyId,
    #[allow(missing_docs)] // documentation missing in model
    EventId,
    #[allow(missing_docs)] // documentation missing in model
    EventName,
    #[allow(missing_docs)] // documentation missing in model
    EventSource,
    #[allow(missing_docs)] // documentation missing in model
    ReadOnly,
    #[allow(missing_docs)] // documentation missing in model
    ResourceName,
    #[allow(missing_docs)] // documentation missing in model
    ResourceType,
    #[allow(missing_docs)] // documentation missing in model
    Username,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for LookupAttributeKey {
    fn from(s: &str) -> Self {
        match s {
            "AccessKeyId" => LookupAttributeKey::AccessKeyId,
            "EventId" => LookupAttributeKey::EventId,
            "EventName" => LookupAttributeKey::EventName,
            "EventSource" => LookupAttributeKey::EventSource,
            "ReadOnly" => LookupAttributeKey::ReadOnly,
            "ResourceName" => LookupAttributeKey::ResourceName,
            "ResourceType" => LookupAttributeKey::ResourceType,
            "Username" => LookupAttributeKey::Username,
            other => LookupAttributeKey::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for LookupAttributeKey {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(LookupAttributeKey::from(s))
    }
}
impl LookupAttributeKey {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            LookupAttributeKey::AccessKeyId => "AccessKeyId",
            LookupAttributeKey::EventId => "EventId",
            LookupAttributeKey::EventName => "EventName",
            LookupAttributeKey::EventSource => "EventSource",
            LookupAttributeKey::ReadOnly => "ReadOnly",
            LookupAttributeKey::ResourceName => "ResourceName",
            LookupAttributeKey::ResourceType => "ResourceType",
            LookupAttributeKey::Username => "Username",
            LookupAttributeKey::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "AccessKeyId",
            "EventId",
            "EventName",
            "EventSource",
            "ReadOnly",
            "ResourceName",
            "ResourceType",
            "Username",
        ]
    }
}
impl AsRef<str> for LookupAttributeKey {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Information about a CloudTrail trail, including the trail's name, home region, and Amazon Resource Name (ARN).</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TrailInfo {
    /// <p>The ARN of a trail.</p>
    pub trail_arn: std::option::Option<std::string::String>,
    /// <p>The name of a trail.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The Amazon Web Services Region in which a trail was created.</p>
    pub home_region: std::option::Option<std::string::String>,
}
impl TrailInfo {
    /// <p>The ARN of a trail.</p>
    pub fn trail_arn(&self) -> std::option::Option<&str> {
        self.trail_arn.as_deref()
    }
    /// <p>The name of a trail.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The Amazon Web Services Region in which a trail was created.</p>
    pub fn home_region(&self) -> std::option::Option<&str> {
        self.home_region.as_deref()
    }
}
impl std::fmt::Debug for TrailInfo {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TrailInfo");
        formatter.field("trail_arn", &self.trail_arn);
        formatter.field("name", &self.name);
        formatter.field("home_region", &self.home_region);
        formatter.finish()
    }
}
/// See [`TrailInfo`](crate::model::TrailInfo)
pub mod trail_info {
    /// A builder for [`TrailInfo`](crate::model::TrailInfo)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) trail_arn: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) home_region: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of a trail.</p>
        pub fn trail_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.trail_arn = Some(input.into());
            self
        }
        /// <p>The ARN of a trail.</p>
        pub fn set_trail_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.trail_arn = input;
            self
        }
        /// <p>The name of a trail.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of a trail.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The Amazon Web Services Region in which a trail was created.</p>
        pub fn home_region(mut self, input: impl Into<std::string::String>) -> Self {
            self.home_region = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services Region in which a trail was created.</p>
        pub fn set_home_region(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.home_region = input;
            self
        }
        /// Consumes the builder and constructs a [`TrailInfo`](crate::model::TrailInfo)
        pub fn build(self) -> crate::model::TrailInfo {
            crate::model::TrailInfo {
                trail_arn: self.trail_arn,
                name: self.name,
                home_region: self.home_region,
            }
        }
    }
}
impl TrailInfo {
    /// Creates a new builder-style object to manufacture [`TrailInfo`](crate::model::TrailInfo)
    pub fn builder() -> crate::model::trail_info::Builder {
        crate::model::trail_info::Builder::default()
    }
}

/// <p>A resource tag.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResourceTag {
    /// <p>Specifies the ARN of the resource.</p>
    pub resource_id: std::option::Option<std::string::String>,
    /// <p>A list of tags.</p>
    pub tags_list: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl ResourceTag {
    /// <p>Specifies the ARN of the resource.</p>
    pub fn resource_id(&self) -> std::option::Option<&str> {
        self.resource_id.as_deref()
    }
    /// <p>A list of tags.</p>
    pub fn tags_list(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags_list.as_deref()
    }
}
impl std::fmt::Debug for ResourceTag {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResourceTag");
        formatter.field("resource_id", &self.resource_id);
        formatter.field("tags_list", &self.tags_list);
        formatter.finish()
    }
}
/// See [`ResourceTag`](crate::model::ResourceTag)
pub mod resource_tag {
    /// A builder for [`ResourceTag`](crate::model::ResourceTag)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_id: std::option::Option<std::string::String>,
        pub(crate) tags_list: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>Specifies the ARN of the resource.</p>
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_id = Some(input.into());
            self
        }
        /// <p>Specifies the ARN of the resource.</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_id = input;
            self
        }
        /// Appends an item to `tags_list`.
        ///
        /// To override the contents of this collection use [`set_tags_list`](Self::set_tags_list).
        ///
        /// <p>A list of tags.</p>
        pub fn tags_list(mut self, input: crate::model::Tag) -> Self {
            let mut v = self.tags_list.unwrap_or_default();
            v.push(input);
            self.tags_list = Some(v);
            self
        }
        /// <p>A list of tags.</p>
        pub fn set_tags_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags_list = input;
            self
        }
        /// Consumes the builder and constructs a [`ResourceTag`](crate::model::ResourceTag)
        pub fn build(self) -> crate::model::ResourceTag {
            crate::model::ResourceTag {
                resource_id: self.resource_id,
                tags_list: self.tags_list,
            }
        }
    }
}
impl ResourceTag {
    /// Creates a new builder-style object to manufacture [`ResourceTag`](crate::model::ResourceTag)
    pub fn builder() -> crate::model::resource_tag::Builder {
        crate::model::resource_tag::Builder::default()
    }
}

/// <p>A SQL string of criteria about events that you want to collect in an event data store.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Query {
    /// <p>The ID of a query.</p>
    pub query_id: std::option::Option<std::string::String>,
    /// <p>The status of the query. This can be <code>QUEUED</code>, <code>RUNNING</code>, <code>FINISHED</code>, <code>FAILED</code>, or <code>CANCELLED</code>.</p>
    pub query_status: std::option::Option<crate::model::QueryStatus>,
    /// <p>The creation time of a query.</p>
    pub creation_time: std::option::Option<aws_smithy_types::DateTime>,
}
impl Query {
    /// <p>The ID of a query.</p>
    pub fn query_id(&self) -> std::option::Option<&str> {
        self.query_id.as_deref()
    }
    /// <p>The status of the query. This can be <code>QUEUED</code>, <code>RUNNING</code>, <code>FINISHED</code>, <code>FAILED</code>, or <code>CANCELLED</code>.</p>
    pub fn query_status(&self) -> std::option::Option<&crate::model::QueryStatus> {
        self.query_status.as_ref()
    }
    /// <p>The creation time of a query.</p>
    pub fn creation_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.creation_time.as_ref()
    }
}
impl std::fmt::Debug for Query {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Query");
        formatter.field("query_id", &self.query_id);
        formatter.field("query_status", &self.query_status);
        formatter.field("creation_time", &self.creation_time);
        formatter.finish()
    }
}
/// See [`Query`](crate::model::Query)
pub mod query {
    /// A builder for [`Query`](crate::model::Query)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) query_id: std::option::Option<std::string::String>,
        pub(crate) query_status: std::option::Option<crate::model::QueryStatus>,
        pub(crate) creation_time: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The ID of a query.</p>
        pub fn query_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.query_id = Some(input.into());
            self
        }
        /// <p>The ID of a query.</p>
        pub fn set_query_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.query_id = input;
            self
        }
        /// <p>The status of the query. This can be <code>QUEUED</code>, <code>RUNNING</code>, <code>FINISHED</code>, <code>FAILED</code>, or <code>CANCELLED</code>.</p>
        pub fn query_status(mut self, input: crate::model::QueryStatus) -> Self {
            self.query_status = Some(input);
            self
        }
        /// <p>The status of the query. This can be <code>QUEUED</code>, <code>RUNNING</code>, <code>FINISHED</code>, <code>FAILED</code>, or <code>CANCELLED</code>.</p>
        pub fn set_query_status(
            mut self,
            input: std::option::Option<crate::model::QueryStatus>,
        ) -> Self {
            self.query_status = input;
            self
        }
        /// <p>The creation time of a query.</p>
        pub fn creation_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.creation_time = Some(input);
            self
        }
        /// <p>The creation time of a query.</p>
        pub fn set_creation_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.creation_time = input;
            self
        }
        /// Consumes the builder and constructs a [`Query`](crate::model::Query)
        pub fn build(self) -> crate::model::Query {
            crate::model::Query {
                query_id: self.query_id,
                query_status: self.query_status,
                creation_time: self.creation_time,
            }
        }
    }
}
impl Query {
    /// Creates a new builder-style object to manufacture [`Query`](crate::model::Query)
    pub fn builder() -> crate::model::query::Builder {
        crate::model::query::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum QueryStatus {
    #[allow(missing_docs)] // documentation missing in model
    Cancelled,
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    #[allow(missing_docs)] // documentation missing in model
    Finished,
    #[allow(missing_docs)] // documentation missing in model
    Queued,
    #[allow(missing_docs)] // documentation missing in model
    Running,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for QueryStatus {
    fn from(s: &str) -> Self {
        match s {
            "CANCELLED" => QueryStatus::Cancelled,
            "FAILED" => QueryStatus::Failed,
            "FINISHED" => QueryStatus::Finished,
            "QUEUED" => QueryStatus::Queued,
            "RUNNING" => QueryStatus::Running,
            other => QueryStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for QueryStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(QueryStatus::from(s))
    }
}
impl QueryStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            QueryStatus::Cancelled => "CANCELLED",
            QueryStatus::Failed => "FAILED",
            QueryStatus::Finished => "FINISHED",
            QueryStatus::Queued => "QUEUED",
            QueryStatus::Running => "RUNNING",
            QueryStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["CANCELLED", "FAILED", "FINISHED", "QUEUED", "RUNNING"]
    }
}
impl AsRef<str> for QueryStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Contains information about a returned public key.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PublicKey {
    /// <p>The DER encoded public key value in PKCS#1 format.</p>
    pub value: std::option::Option<aws_smithy_types::Blob>,
    /// <p>The starting time of validity of the public key.</p>
    pub validity_start_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The ending time of validity of the public key.</p>
    pub validity_end_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The fingerprint of the public key.</p>
    pub fingerprint: std::option::Option<std::string::String>,
}
impl PublicKey {
    /// <p>The DER encoded public key value in PKCS#1 format.</p>
    pub fn value(&self) -> std::option::Option<&aws_smithy_types::Blob> {
        self.value.as_ref()
    }
    /// <p>The starting time of validity of the public key.</p>
    pub fn validity_start_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.validity_start_time.as_ref()
    }
    /// <p>The ending time of validity of the public key.</p>
    pub fn validity_end_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.validity_end_time.as_ref()
    }
    /// <p>The fingerprint of the public key.</p>
    pub fn fingerprint(&self) -> std::option::Option<&str> {
        self.fingerprint.as_deref()
    }
}
impl std::fmt::Debug for PublicKey {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PublicKey");
        formatter.field("value", &self.value);
        formatter.field("validity_start_time", &self.validity_start_time);
        formatter.field("validity_end_time", &self.validity_end_time);
        formatter.field("fingerprint", &self.fingerprint);
        formatter.finish()
    }
}
/// See [`PublicKey`](crate::model::PublicKey)
pub mod public_key {
    /// A builder for [`PublicKey`](crate::model::PublicKey)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) value: std::option::Option<aws_smithy_types::Blob>,
        pub(crate) validity_start_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) validity_end_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) fingerprint: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The DER encoded public key value in PKCS#1 format.</p>
        pub fn value(mut self, input: aws_smithy_types::Blob) -> Self {
            self.value = Some(input);
            self
        }
        /// <p>The DER encoded public key value in PKCS#1 format.</p>
        pub fn set_value(mut self, input: std::option::Option<aws_smithy_types::Blob>) -> Self {
            self.value = input;
            self
        }
        /// <p>The starting time of validity of the public key.</p>
        pub fn validity_start_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.validity_start_time = Some(input);
            self
        }
        /// <p>The starting time of validity of the public key.</p>
        pub fn set_validity_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.validity_start_time = input;
            self
        }
        /// <p>The ending time of validity of the public key.</p>
        pub fn validity_end_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.validity_end_time = Some(input);
            self
        }
        /// <p>The ending time of validity of the public key.</p>
        pub fn set_validity_end_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.validity_end_time = input;
            self
        }
        /// <p>The fingerprint of the public key.</p>
        pub fn fingerprint(mut self, input: impl Into<std::string::String>) -> Self {
            self.fingerprint = Some(input.into());
            self
        }
        /// <p>The fingerprint of the public key.</p>
        pub fn set_fingerprint(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.fingerprint = input;
            self
        }
        /// Consumes the builder and constructs a [`PublicKey`](crate::model::PublicKey)
        pub fn build(self) -> crate::model::PublicKey {
            crate::model::PublicKey {
                value: self.value,
                validity_start_time: self.validity_start_time,
                validity_end_time: self.validity_end_time,
                fingerprint: self.fingerprint,
            }
        }
    }
}
impl PublicKey {
    /// Creates a new builder-style object to manufacture [`PublicKey`](crate::model::PublicKey)
    pub fn builder() -> crate::model::public_key::Builder {
        crate::model::public_key::Builder::default()
    }
}

/// <p>A storage lake of event data against which you can run complex SQL-based queries. An event data store can include events that you have logged on your account from the last 90 to 2555 days (about three months to up to seven years). To select events for an event data store, use <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/logging-data-events-with-cloudtrail.html#creating-data-event-selectors-advanced">advanced event selectors</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EventDataStore {
    /// <p>The ARN of the event data store.</p>
    pub event_data_store_arn: std::option::Option<std::string::String>,
    /// <p>The name of the event data store.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>Indicates whether the event data store is protected from termination.</p>
    pub termination_protection_enabled: std::option::Option<bool>,
    /// <p>The status of an event data store. Values are <code>ENABLED</code> and <code>PENDING_DELETION</code>.</p>
    pub status: std::option::Option<crate::model::EventDataStoreStatus>,
    /// <p>The advanced event selectors that were used to select events for the data store.</p>
    pub advanced_event_selectors:
        std::option::Option<std::vec::Vec<crate::model::AdvancedEventSelector>>,
    /// <p>Indicates whether the event data store includes events from all regions, or only from the region in which it was created.</p>
    pub multi_region_enabled: std::option::Option<bool>,
    /// <p>Indicates that an event data store is collecting logged events for an organization.</p>
    pub organization_enabled: std::option::Option<bool>,
    /// <p>The retention period, in days.</p>
    pub retention_period: std::option::Option<i32>,
    /// <p>The timestamp of the event data store's creation.</p>
    pub created_timestamp: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The timestamp showing when an event data store was updated, if applicable. <code>UpdatedTimestamp</code> is always either the same or newer than the time shown in <code>CreatedTimestamp</code>.</p>
    pub updated_timestamp: std::option::Option<aws_smithy_types::DateTime>,
}
impl EventDataStore {
    /// <p>The ARN of the event data store.</p>
    pub fn event_data_store_arn(&self) -> std::option::Option<&str> {
        self.event_data_store_arn.as_deref()
    }
    /// <p>The name of the event data store.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>Indicates whether the event data store is protected from termination.</p>
    pub fn termination_protection_enabled(&self) -> std::option::Option<bool> {
        self.termination_protection_enabled
    }
    /// <p>The status of an event data store. Values are <code>ENABLED</code> and <code>PENDING_DELETION</code>.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::EventDataStoreStatus> {
        self.status.as_ref()
    }
    /// <p>The advanced event selectors that were used to select events for the data store.</p>
    pub fn advanced_event_selectors(
        &self,
    ) -> std::option::Option<&[crate::model::AdvancedEventSelector]> {
        self.advanced_event_selectors.as_deref()
    }
    /// <p>Indicates whether the event data store includes events from all regions, or only from the region in which it was created.</p>
    pub fn multi_region_enabled(&self) -> std::option::Option<bool> {
        self.multi_region_enabled
    }
    /// <p>Indicates that an event data store is collecting logged events for an organization.</p>
    pub fn organization_enabled(&self) -> std::option::Option<bool> {
        self.organization_enabled
    }
    /// <p>The retention period, in days.</p>
    pub fn retention_period(&self) -> std::option::Option<i32> {
        self.retention_period
    }
    /// <p>The timestamp of the event data store's creation.</p>
    pub fn created_timestamp(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.created_timestamp.as_ref()
    }
    /// <p>The timestamp showing when an event data store was updated, if applicable. <code>UpdatedTimestamp</code> is always either the same or newer than the time shown in <code>CreatedTimestamp</code>.</p>
    pub fn updated_timestamp(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.updated_timestamp.as_ref()
    }
}
impl std::fmt::Debug for EventDataStore {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EventDataStore");
        formatter.field("event_data_store_arn", &self.event_data_store_arn);
        formatter.field("name", &self.name);
        formatter.field(
            "termination_protection_enabled",
            &self.termination_protection_enabled,
        );
        formatter.field("status", &self.status);
        formatter.field("advanced_event_selectors", &self.advanced_event_selectors);
        formatter.field("multi_region_enabled", &self.multi_region_enabled);
        formatter.field("organization_enabled", &self.organization_enabled);
        formatter.field("retention_period", &self.retention_period);
        formatter.field("created_timestamp", &self.created_timestamp);
        formatter.field("updated_timestamp", &self.updated_timestamp);
        formatter.finish()
    }
}
/// See [`EventDataStore`](crate::model::EventDataStore)
pub mod event_data_store {
    /// A builder for [`EventDataStore`](crate::model::EventDataStore)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) event_data_store_arn: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) termination_protection_enabled: std::option::Option<bool>,
        pub(crate) status: std::option::Option<crate::model::EventDataStoreStatus>,
        pub(crate) advanced_event_selectors:
            std::option::Option<std::vec::Vec<crate::model::AdvancedEventSelector>>,
        pub(crate) multi_region_enabled: std::option::Option<bool>,
        pub(crate) organization_enabled: std::option::Option<bool>,
        pub(crate) retention_period: std::option::Option<i32>,
        pub(crate) created_timestamp: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) updated_timestamp: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The ARN of the event data store.</p>
        pub fn event_data_store_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.event_data_store_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the event data store.</p>
        pub fn set_event_data_store_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.event_data_store_arn = input;
            self
        }
        /// <p>The name of the event data store.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the event data store.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>Indicates whether the event data store is protected from termination.</p>
        pub fn termination_protection_enabled(mut self, input: bool) -> Self {
            self.termination_protection_enabled = Some(input);
            self
        }
        /// <p>Indicates whether the event data store is protected from termination.</p>
        pub fn set_termination_protection_enabled(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.termination_protection_enabled = input;
            self
        }
        /// <p>The status of an event data store. Values are <code>ENABLED</code> and <code>PENDING_DELETION</code>.</p>
        pub fn status(mut self, input: crate::model::EventDataStoreStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of an event data store. Values are <code>ENABLED</code> and <code>PENDING_DELETION</code>.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::EventDataStoreStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// Appends an item to `advanced_event_selectors`.
        ///
        /// To override the contents of this collection use [`set_advanced_event_selectors`](Self::set_advanced_event_selectors).
        ///
        /// <p>The advanced event selectors that were used to select events for the data store.</p>
        pub fn advanced_event_selectors(
            mut self,
            input: crate::model::AdvancedEventSelector,
        ) -> Self {
            let mut v = self.advanced_event_selectors.unwrap_or_default();
            v.push(input);
            self.advanced_event_selectors = Some(v);
            self
        }
        /// <p>The advanced event selectors that were used to select events for the data store.</p>
        pub fn set_advanced_event_selectors(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AdvancedEventSelector>>,
        ) -> Self {
            self.advanced_event_selectors = input;
            self
        }
        /// <p>Indicates whether the event data store includes events from all regions, or only from the region in which it was created.</p>
        pub fn multi_region_enabled(mut self, input: bool) -> Self {
            self.multi_region_enabled = Some(input);
            self
        }
        /// <p>Indicates whether the event data store includes events from all regions, or only from the region in which it was created.</p>
        pub fn set_multi_region_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.multi_region_enabled = input;
            self
        }
        /// <p>Indicates that an event data store is collecting logged events for an organization.</p>
        pub fn organization_enabled(mut self, input: bool) -> Self {
            self.organization_enabled = Some(input);
            self
        }
        /// <p>Indicates that an event data store is collecting logged events for an organization.</p>
        pub fn set_organization_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.organization_enabled = input;
            self
        }
        /// <p>The retention period, in days.</p>
        pub fn retention_period(mut self, input: i32) -> Self {
            self.retention_period = Some(input);
            self
        }
        /// <p>The retention period, in days.</p>
        pub fn set_retention_period(mut self, input: std::option::Option<i32>) -> Self {
            self.retention_period = input;
            self
        }
        /// <p>The timestamp of the event data store's creation.</p>
        pub fn created_timestamp(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.created_timestamp = Some(input);
            self
        }
        /// <p>The timestamp of the event data store's creation.</p>
        pub fn set_created_timestamp(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.created_timestamp = input;
            self
        }
        /// <p>The timestamp showing when an event data store was updated, if applicable. <code>UpdatedTimestamp</code> is always either the same or newer than the time shown in <code>CreatedTimestamp</code>.</p>
        pub fn updated_timestamp(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.updated_timestamp = Some(input);
            self
        }
        /// <p>The timestamp showing when an event data store was updated, if applicable. <code>UpdatedTimestamp</code> is always either the same or newer than the time shown in <code>CreatedTimestamp</code>.</p>
        pub fn set_updated_timestamp(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.updated_timestamp = input;
            self
        }
        /// Consumes the builder and constructs a [`EventDataStore`](crate::model::EventDataStore)
        pub fn build(self) -> crate::model::EventDataStore {
            crate::model::EventDataStore {
                event_data_store_arn: self.event_data_store_arn,
                name: self.name,
                termination_protection_enabled: self.termination_protection_enabled,
                status: self.status,
                advanced_event_selectors: self.advanced_event_selectors,
                multi_region_enabled: self.multi_region_enabled,
                organization_enabled: self.organization_enabled,
                retention_period: self.retention_period,
                created_timestamp: self.created_timestamp,
                updated_timestamp: self.updated_timestamp,
            }
        }
    }
}
impl EventDataStore {
    /// Creates a new builder-style object to manufacture [`EventDataStore`](crate::model::EventDataStore)
    pub fn builder() -> crate::model::event_data_store::Builder {
        crate::model::event_data_store::Builder::default()
    }
}

/// <p>The settings for a trail.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Trail {
    /// <p>Name of the trail set by calling <code>CreateTrail</code>. The maximum length is 128 characters.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>Name of the Amazon S3 bucket into which CloudTrail delivers your trail files. See <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/create_trail_naming_policy.html">Amazon S3 Bucket Naming Requirements</a>.</p>
    pub s3_bucket_name: std::option::Option<std::string::String>,
    /// <p>Specifies the Amazon S3 key prefix that comes after the name of the bucket you have designated for log file delivery. For more information, see <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/cloudtrail-find-log-files.html">Finding Your CloudTrail Log Files</a>. The maximum length is 200 characters.</p>
    pub s3_key_prefix: std::option::Option<std::string::String>,
    /// <p>This field is no longer in use. Use SnsTopicARN.</p>
    pub sns_topic_name: std::option::Option<std::string::String>,
    /// <p>Specifies the ARN of the Amazon SNS topic that CloudTrail uses to send notifications when log files are delivered. The following is the format of a topic ARN.</p>
    /// <p> <code>arn:aws:sns:us-east-2:123456789012:MyTopic</code> </p>
    pub sns_topic_arn: std::option::Option<std::string::String>,
    /// <p>Set to <b>True</b> to include Amazon Web Services API calls from Amazon Web Services global services such as IAM. Otherwise, <b>False</b>.</p>
    pub include_global_service_events: std::option::Option<bool>,
    /// <p>Specifies whether the trail exists only in one region or exists in all regions.</p>
    pub is_multi_region_trail: std::option::Option<bool>,
    /// <p>The region in which the trail was created.</p>
    pub home_region: std::option::Option<std::string::String>,
    /// <p>Specifies the ARN of the trail. The following is the format of a trail ARN.</p>
    /// <p> <code>arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail</code> </p>
    pub trail_arn: std::option::Option<std::string::String>,
    /// <p>Specifies whether log file validation is enabled.</p>
    pub log_file_validation_enabled: std::option::Option<bool>,
    /// <p>Specifies an Amazon Resource Name (ARN), a unique identifier that represents the log group to which CloudTrail logs will be delivered.</p>
    pub cloud_watch_logs_log_group_arn: std::option::Option<std::string::String>,
    /// <p>Specifies the role for the CloudWatch Logs endpoint to assume to write to a user's log group.</p>
    pub cloud_watch_logs_role_arn: std::option::Option<std::string::String>,
    /// <p>Specifies the KMS key ID that encrypts the logs delivered by CloudTrail. The value is a fully specified ARN to a KMS key in the following format.</p>
    /// <p> <code>arn:aws:kms:us-east-2:123456789012:key/12345678-1234-1234-1234-123456789012</code> </p>
    pub kms_key_id: std::option::Option<std::string::String>,
    /// <p>Specifies if the trail has custom event selectors.</p>
    pub has_custom_event_selectors: std::option::Option<bool>,
    /// <p>Specifies whether a trail has insight types specified in an <code>InsightSelector</code> list.</p>
    pub has_insight_selectors: std::option::Option<bool>,
    /// <p>Specifies whether the trail is an organization trail.</p>
    pub is_organization_trail: std::option::Option<bool>,
}
impl Trail {
    /// <p>Name of the trail set by calling <code>CreateTrail</code>. The maximum length is 128 characters.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>Name of the Amazon S3 bucket into which CloudTrail delivers your trail files. See <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/create_trail_naming_policy.html">Amazon S3 Bucket Naming Requirements</a>.</p>
    pub fn s3_bucket_name(&self) -> std::option::Option<&str> {
        self.s3_bucket_name.as_deref()
    }
    /// <p>Specifies the Amazon S3 key prefix that comes after the name of the bucket you have designated for log file delivery. For more information, see <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/cloudtrail-find-log-files.html">Finding Your CloudTrail Log Files</a>. The maximum length is 200 characters.</p>
    pub fn s3_key_prefix(&self) -> std::option::Option<&str> {
        self.s3_key_prefix.as_deref()
    }
    /// <p>This field is no longer in use. Use SnsTopicARN.</p>
    pub fn sns_topic_name(&self) -> std::option::Option<&str> {
        self.sns_topic_name.as_deref()
    }
    /// <p>Specifies the ARN of the Amazon SNS topic that CloudTrail uses to send notifications when log files are delivered. The following is the format of a topic ARN.</p>
    /// <p> <code>arn:aws:sns:us-east-2:123456789012:MyTopic</code> </p>
    pub fn sns_topic_arn(&self) -> std::option::Option<&str> {
        self.sns_topic_arn.as_deref()
    }
    /// <p>Set to <b>True</b> to include Amazon Web Services API calls from Amazon Web Services global services such as IAM. Otherwise, <b>False</b>.</p>
    pub fn include_global_service_events(&self) -> std::option::Option<bool> {
        self.include_global_service_events
    }
    /// <p>Specifies whether the trail exists only in one region or exists in all regions.</p>
    pub fn is_multi_region_trail(&self) -> std::option::Option<bool> {
        self.is_multi_region_trail
    }
    /// <p>The region in which the trail was created.</p>
    pub fn home_region(&self) -> std::option::Option<&str> {
        self.home_region.as_deref()
    }
    /// <p>Specifies the ARN of the trail. The following is the format of a trail ARN.</p>
    /// <p> <code>arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail</code> </p>
    pub fn trail_arn(&self) -> std::option::Option<&str> {
        self.trail_arn.as_deref()
    }
    /// <p>Specifies whether log file validation is enabled.</p>
    pub fn log_file_validation_enabled(&self) -> std::option::Option<bool> {
        self.log_file_validation_enabled
    }
    /// <p>Specifies an Amazon Resource Name (ARN), a unique identifier that represents the log group to which CloudTrail logs will be delivered.</p>
    pub fn cloud_watch_logs_log_group_arn(&self) -> std::option::Option<&str> {
        self.cloud_watch_logs_log_group_arn.as_deref()
    }
    /// <p>Specifies the role for the CloudWatch Logs endpoint to assume to write to a user's log group.</p>
    pub fn cloud_watch_logs_role_arn(&self) -> std::option::Option<&str> {
        self.cloud_watch_logs_role_arn.as_deref()
    }
    /// <p>Specifies the KMS key ID that encrypts the logs delivered by CloudTrail. The value is a fully specified ARN to a KMS key in the following format.</p>
    /// <p> <code>arn:aws:kms:us-east-2:123456789012:key/12345678-1234-1234-1234-123456789012</code> </p>
    pub fn kms_key_id(&self) -> std::option::Option<&str> {
        self.kms_key_id.as_deref()
    }
    /// <p>Specifies if the trail has custom event selectors.</p>
    pub fn has_custom_event_selectors(&self) -> std::option::Option<bool> {
        self.has_custom_event_selectors
    }
    /// <p>Specifies whether a trail has insight types specified in an <code>InsightSelector</code> list.</p>
    pub fn has_insight_selectors(&self) -> std::option::Option<bool> {
        self.has_insight_selectors
    }
    /// <p>Specifies whether the trail is an organization trail.</p>
    pub fn is_organization_trail(&self) -> std::option::Option<bool> {
        self.is_organization_trail
    }
}
impl std::fmt::Debug for Trail {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Trail");
        formatter.field("name", &self.name);
        formatter.field("s3_bucket_name", &self.s3_bucket_name);
        formatter.field("s3_key_prefix", &self.s3_key_prefix);
        formatter.field("sns_topic_name", &self.sns_topic_name);
        formatter.field("sns_topic_arn", &self.sns_topic_arn);
        formatter.field(
            "include_global_service_events",
            &self.include_global_service_events,
        );
        formatter.field("is_multi_region_trail", &self.is_multi_region_trail);
        formatter.field("home_region", &self.home_region);
        formatter.field("trail_arn", &self.trail_arn);
        formatter.field(
            "log_file_validation_enabled",
            &self.log_file_validation_enabled,
        );
        formatter.field(
            "cloud_watch_logs_log_group_arn",
            &self.cloud_watch_logs_log_group_arn,
        );
        formatter.field("cloud_watch_logs_role_arn", &self.cloud_watch_logs_role_arn);
        formatter.field("kms_key_id", &self.kms_key_id);
        formatter.field(
            "has_custom_event_selectors",
            &self.has_custom_event_selectors,
        );
        formatter.field("has_insight_selectors", &self.has_insight_selectors);
        formatter.field("is_organization_trail", &self.is_organization_trail);
        formatter.finish()
    }
}
/// See [`Trail`](crate::model::Trail)
pub mod trail {
    /// A builder for [`Trail`](crate::model::Trail)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) s3_bucket_name: std::option::Option<std::string::String>,
        pub(crate) s3_key_prefix: std::option::Option<std::string::String>,
        pub(crate) sns_topic_name: std::option::Option<std::string::String>,
        pub(crate) sns_topic_arn: std::option::Option<std::string::String>,
        pub(crate) include_global_service_events: std::option::Option<bool>,
        pub(crate) is_multi_region_trail: std::option::Option<bool>,
        pub(crate) home_region: std::option::Option<std::string::String>,
        pub(crate) trail_arn: std::option::Option<std::string::String>,
        pub(crate) log_file_validation_enabled: std::option::Option<bool>,
        pub(crate) cloud_watch_logs_log_group_arn: std::option::Option<std::string::String>,
        pub(crate) cloud_watch_logs_role_arn: std::option::Option<std::string::String>,
        pub(crate) kms_key_id: std::option::Option<std::string::String>,
        pub(crate) has_custom_event_selectors: std::option::Option<bool>,
        pub(crate) has_insight_selectors: std::option::Option<bool>,
        pub(crate) is_organization_trail: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>Name of the trail set by calling <code>CreateTrail</code>. The maximum length is 128 characters.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>Name of the trail set by calling <code>CreateTrail</code>. The maximum length is 128 characters.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>Name of the Amazon S3 bucket into which CloudTrail delivers your trail files. See <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/create_trail_naming_policy.html">Amazon S3 Bucket Naming Requirements</a>.</p>
        pub fn s3_bucket_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.s3_bucket_name = Some(input.into());
            self
        }
        /// <p>Name of the Amazon S3 bucket into which CloudTrail delivers your trail files. See <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/create_trail_naming_policy.html">Amazon S3 Bucket Naming Requirements</a>.</p>
        pub fn set_s3_bucket_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.s3_bucket_name = input;
            self
        }
        /// <p>Specifies the Amazon S3 key prefix that comes after the name of the bucket you have designated for log file delivery. For more information, see <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/cloudtrail-find-log-files.html">Finding Your CloudTrail Log Files</a>. The maximum length is 200 characters.</p>
        pub fn s3_key_prefix(mut self, input: impl Into<std::string::String>) -> Self {
            self.s3_key_prefix = Some(input.into());
            self
        }
        /// <p>Specifies the Amazon S3 key prefix that comes after the name of the bucket you have designated for log file delivery. For more information, see <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/cloudtrail-find-log-files.html">Finding Your CloudTrail Log Files</a>. The maximum length is 200 characters.</p>
        pub fn set_s3_key_prefix(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.s3_key_prefix = input;
            self
        }
        /// <p>This field is no longer in use. Use SnsTopicARN.</p>
        pub fn sns_topic_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.sns_topic_name = Some(input.into());
            self
        }
        /// <p>This field is no longer in use. Use SnsTopicARN.</p>
        pub fn set_sns_topic_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.sns_topic_name = input;
            self
        }
        /// <p>Specifies the ARN of the Amazon SNS topic that CloudTrail uses to send notifications when log files are delivered. The following is the format of a topic ARN.</p>
        /// <p> <code>arn:aws:sns:us-east-2:123456789012:MyTopic</code> </p>
        pub fn sns_topic_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.sns_topic_arn = Some(input.into());
            self
        }
        /// <p>Specifies the ARN of the Amazon SNS topic that CloudTrail uses to send notifications when log files are delivered. The following is the format of a topic ARN.</p>
        /// <p> <code>arn:aws:sns:us-east-2:123456789012:MyTopic</code> </p>
        pub fn set_sns_topic_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.sns_topic_arn = input;
            self
        }
        /// <p>Set to <b>True</b> to include Amazon Web Services API calls from Amazon Web Services global services such as IAM. Otherwise, <b>False</b>.</p>
        pub fn include_global_service_events(mut self, input: bool) -> Self {
            self.include_global_service_events = Some(input);
            self
        }
        /// <p>Set to <b>True</b> to include Amazon Web Services API calls from Amazon Web Services global services such as IAM. Otherwise, <b>False</b>.</p>
        pub fn set_include_global_service_events(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.include_global_service_events = input;
            self
        }
        /// <p>Specifies whether the trail exists only in one region or exists in all regions.</p>
        pub fn is_multi_region_trail(mut self, input: bool) -> Self {
            self.is_multi_region_trail = Some(input);
            self
        }
        /// <p>Specifies whether the trail exists only in one region or exists in all regions.</p>
        pub fn set_is_multi_region_trail(mut self, input: std::option::Option<bool>) -> Self {
            self.is_multi_region_trail = input;
            self
        }
        /// <p>The region in which the trail was created.</p>
        pub fn home_region(mut self, input: impl Into<std::string::String>) -> Self {
            self.home_region = Some(input.into());
            self
        }
        /// <p>The region in which the trail was created.</p>
        pub fn set_home_region(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.home_region = input;
            self
        }
        /// <p>Specifies the ARN of the trail. The following is the format of a trail ARN.</p>
        /// <p> <code>arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail</code> </p>
        pub fn trail_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.trail_arn = Some(input.into());
            self
        }
        /// <p>Specifies the ARN of the trail. The following is the format of a trail ARN.</p>
        /// <p> <code>arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail</code> </p>
        pub fn set_trail_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.trail_arn = input;
            self
        }
        /// <p>Specifies whether log file validation is enabled.</p>
        pub fn log_file_validation_enabled(mut self, input: bool) -> Self {
            self.log_file_validation_enabled = Some(input);
            self
        }
        /// <p>Specifies whether log file validation is enabled.</p>
        pub fn set_log_file_validation_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.log_file_validation_enabled = input;
            self
        }
        /// <p>Specifies an Amazon Resource Name (ARN), a unique identifier that represents the log group to which CloudTrail logs will be delivered.</p>
        pub fn cloud_watch_logs_log_group_arn(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.cloud_watch_logs_log_group_arn = Some(input.into());
            self
        }
        /// <p>Specifies an Amazon Resource Name (ARN), a unique identifier that represents the log group to which CloudTrail logs will be delivered.</p>
        pub fn set_cloud_watch_logs_log_group_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.cloud_watch_logs_log_group_arn = input;
            self
        }
        /// <p>Specifies the role for the CloudWatch Logs endpoint to assume to write to a user's log group.</p>
        pub fn cloud_watch_logs_role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.cloud_watch_logs_role_arn = Some(input.into());
            self
        }
        /// <p>Specifies the role for the CloudWatch Logs endpoint to assume to write to a user's log group.</p>
        pub fn set_cloud_watch_logs_role_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.cloud_watch_logs_role_arn = input;
            self
        }
        /// <p>Specifies the KMS key ID that encrypts the logs delivered by CloudTrail. The value is a fully specified ARN to a KMS key in the following format.</p>
        /// <p> <code>arn:aws:kms:us-east-2:123456789012:key/12345678-1234-1234-1234-123456789012</code> </p>
        pub fn kms_key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.kms_key_id = Some(input.into());
            self
        }
        /// <p>Specifies the KMS key ID that encrypts the logs delivered by CloudTrail. The value is a fully specified ARN to a KMS key in the following format.</p>
        /// <p> <code>arn:aws:kms:us-east-2:123456789012:key/12345678-1234-1234-1234-123456789012</code> </p>
        pub fn set_kms_key_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.kms_key_id = input;
            self
        }
        /// <p>Specifies if the trail has custom event selectors.</p>
        pub fn has_custom_event_selectors(mut self, input: bool) -> Self {
            self.has_custom_event_selectors = Some(input);
            self
        }
        /// <p>Specifies if the trail has custom event selectors.</p>
        pub fn set_has_custom_event_selectors(mut self, input: std::option::Option<bool>) -> Self {
            self.has_custom_event_selectors = input;
            self
        }
        /// <p>Specifies whether a trail has insight types specified in an <code>InsightSelector</code> list.</p>
        pub fn has_insight_selectors(mut self, input: bool) -> Self {
            self.has_insight_selectors = Some(input);
            self
        }
        /// <p>Specifies whether a trail has insight types specified in an <code>InsightSelector</code> list.</p>
        pub fn set_has_insight_selectors(mut self, input: std::option::Option<bool>) -> Self {
            self.has_insight_selectors = input;
            self
        }
        /// <p>Specifies whether the trail is an organization trail.</p>
        pub fn is_organization_trail(mut self, input: bool) -> Self {
            self.is_organization_trail = Some(input);
            self
        }
        /// <p>Specifies whether the trail is an organization trail.</p>
        pub fn set_is_organization_trail(mut self, input: std::option::Option<bool>) -> Self {
            self.is_organization_trail = input;
            self
        }
        /// Consumes the builder and constructs a [`Trail`](crate::model::Trail)
        pub fn build(self) -> crate::model::Trail {
            crate::model::Trail {
                name: self.name,
                s3_bucket_name: self.s3_bucket_name,
                s3_key_prefix: self.s3_key_prefix,
                sns_topic_name: self.sns_topic_name,
                sns_topic_arn: self.sns_topic_arn,
                include_global_service_events: self.include_global_service_events,
                is_multi_region_trail: self.is_multi_region_trail,
                home_region: self.home_region,
                trail_arn: self.trail_arn,
                log_file_validation_enabled: self.log_file_validation_enabled,
                cloud_watch_logs_log_group_arn: self.cloud_watch_logs_log_group_arn,
                cloud_watch_logs_role_arn: self.cloud_watch_logs_role_arn,
                kms_key_id: self.kms_key_id,
                has_custom_event_selectors: self.has_custom_event_selectors,
                has_insight_selectors: self.has_insight_selectors,
                is_organization_trail: self.is_organization_trail,
            }
        }
    }
}
impl Trail {
    /// Creates a new builder-style object to manufacture [`Trail`](crate::model::Trail)
    pub fn builder() -> crate::model::trail::Builder {
        crate::model::trail::Builder::default()
    }
}

/// <p>Metadata about a query, such as the number of results.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct QueryStatistics {
    /// <p>The number of results returned.</p>
    pub results_count: std::option::Option<i32>,
    /// <p>The total number of results returned by a query.</p>
    pub total_results_count: std::option::Option<i32>,
}
impl QueryStatistics {
    /// <p>The number of results returned.</p>
    pub fn results_count(&self) -> std::option::Option<i32> {
        self.results_count
    }
    /// <p>The total number of results returned by a query.</p>
    pub fn total_results_count(&self) -> std::option::Option<i32> {
        self.total_results_count
    }
}
impl std::fmt::Debug for QueryStatistics {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("QueryStatistics");
        formatter.field("results_count", &self.results_count);
        formatter.field("total_results_count", &self.total_results_count);
        formatter.finish()
    }
}
/// See [`QueryStatistics`](crate::model::QueryStatistics)
pub mod query_statistics {
    /// A builder for [`QueryStatistics`](crate::model::QueryStatistics)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) results_count: std::option::Option<i32>,
        pub(crate) total_results_count: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The number of results returned.</p>
        pub fn results_count(mut self, input: i32) -> Self {
            self.results_count = Some(input);
            self
        }
        /// <p>The number of results returned.</p>
        pub fn set_results_count(mut self, input: std::option::Option<i32>) -> Self {
            self.results_count = input;
            self
        }
        /// <p>The total number of results returned by a query.</p>
        pub fn total_results_count(mut self, input: i32) -> Self {
            self.total_results_count = Some(input);
            self
        }
        /// <p>The total number of results returned by a query.</p>
        pub fn set_total_results_count(mut self, input: std::option::Option<i32>) -> Self {
            self.total_results_count = input;
            self
        }
        /// Consumes the builder and constructs a [`QueryStatistics`](crate::model::QueryStatistics)
        pub fn build(self) -> crate::model::QueryStatistics {
            crate::model::QueryStatistics {
                results_count: self.results_count,
                total_results_count: self.total_results_count,
            }
        }
    }
}
impl QueryStatistics {
    /// Creates a new builder-style object to manufacture [`QueryStatistics`](crate::model::QueryStatistics)
    pub fn builder() -> crate::model::query_statistics::Builder {
        crate::model::query_statistics::Builder::default()
    }
}

/// <p>Gets metadata about a query, including the number of events that were matched, the total number of events scanned, the query run time in milliseconds, and the query's creation time.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct QueryStatisticsForDescribeQuery {
    /// <p>The number of events that matched a query.</p>
    pub events_matched: std::option::Option<i64>,
    /// <p>The number of events that the query scanned in the event data store.</p>
    pub events_scanned: std::option::Option<i64>,
    /// <p>The query's run time, in milliseconds.</p>
    pub execution_time_in_millis: std::option::Option<i32>,
    /// <p>The creation time of the query.</p>
    pub creation_time: std::option::Option<aws_smithy_types::DateTime>,
}
impl QueryStatisticsForDescribeQuery {
    /// <p>The number of events that matched a query.</p>
    pub fn events_matched(&self) -> std::option::Option<i64> {
        self.events_matched
    }
    /// <p>The number of events that the query scanned in the event data store.</p>
    pub fn events_scanned(&self) -> std::option::Option<i64> {
        self.events_scanned
    }
    /// <p>The query's run time, in milliseconds.</p>
    pub fn execution_time_in_millis(&self) -> std::option::Option<i32> {
        self.execution_time_in_millis
    }
    /// <p>The creation time of the query.</p>
    pub fn creation_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.creation_time.as_ref()
    }
}
impl std::fmt::Debug for QueryStatisticsForDescribeQuery {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("QueryStatisticsForDescribeQuery");
        formatter.field("events_matched", &self.events_matched);
        formatter.field("events_scanned", &self.events_scanned);
        formatter.field("execution_time_in_millis", &self.execution_time_in_millis);
        formatter.field("creation_time", &self.creation_time);
        formatter.finish()
    }
}
/// See [`QueryStatisticsForDescribeQuery`](crate::model::QueryStatisticsForDescribeQuery)
pub mod query_statistics_for_describe_query {
    /// A builder for [`QueryStatisticsForDescribeQuery`](crate::model::QueryStatisticsForDescribeQuery)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) events_matched: std::option::Option<i64>,
        pub(crate) events_scanned: std::option::Option<i64>,
        pub(crate) execution_time_in_millis: std::option::Option<i32>,
        pub(crate) creation_time: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The number of events that matched a query.</p>
        pub fn events_matched(mut self, input: i64) -> Self {
            self.events_matched = Some(input);
            self
        }
        /// <p>The number of events that matched a query.</p>
        pub fn set_events_matched(mut self, input: std::option::Option<i64>) -> Self {
            self.events_matched = input;
            self
        }
        /// <p>The number of events that the query scanned in the event data store.</p>
        pub fn events_scanned(mut self, input: i64) -> Self {
            self.events_scanned = Some(input);
            self
        }
        /// <p>The number of events that the query scanned in the event data store.</p>
        pub fn set_events_scanned(mut self, input: std::option::Option<i64>) -> Self {
            self.events_scanned = input;
            self
        }
        /// <p>The query's run time, in milliseconds.</p>
        pub fn execution_time_in_millis(mut self, input: i32) -> Self {
            self.execution_time_in_millis = Some(input);
            self
        }
        /// <p>The query's run time, in milliseconds.</p>
        pub fn set_execution_time_in_millis(mut self, input: std::option::Option<i32>) -> Self {
            self.execution_time_in_millis = input;
            self
        }
        /// <p>The creation time of the query.</p>
        pub fn creation_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.creation_time = Some(input);
            self
        }
        /// <p>The creation time of the query.</p>
        pub fn set_creation_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.creation_time = input;
            self
        }
        /// Consumes the builder and constructs a [`QueryStatisticsForDescribeQuery`](crate::model::QueryStatisticsForDescribeQuery)
        pub fn build(self) -> crate::model::QueryStatisticsForDescribeQuery {
            crate::model::QueryStatisticsForDescribeQuery {
                events_matched: self.events_matched,
                events_scanned: self.events_scanned,
                execution_time_in_millis: self.execution_time_in_millis,
                creation_time: self.creation_time,
            }
        }
    }
}
impl QueryStatisticsForDescribeQuery {
    /// Creates a new builder-style object to manufacture [`QueryStatisticsForDescribeQuery`](crate::model::QueryStatisticsForDescribeQuery)
    pub fn builder() -> crate::model::query_statistics_for_describe_query::Builder {
        crate::model::query_statistics_for_describe_query::Builder::default()
    }
}
