// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(clippy::unnecessary_wraps)]
pub fn parse_add_tags_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::AddTagsOutput, crate::error::AddTagsError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::AddTagsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::AddTagsError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "CloudTrailARNInvalidException" => crate::error::AddTagsError {
            meta: generic,
            kind: crate::error::AddTagsErrorKind::CloudTrailArnInvalidException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::cloud_trail_arn_invalid_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_cloud_trail_arn_invalid_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AddTagsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ConflictException" => {
            crate::error::AddTagsError {
                meta: generic,
                kind: crate::error::AddTagsErrorKind::ConflictException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::conflict_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_conflict_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AddTagsError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "EventDataStoreNotFoundException" => crate::error::AddTagsError {
            meta: generic,
            kind: crate::error::AddTagsErrorKind::EventDataStoreNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::event_data_store_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_event_data_store_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AddTagsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InactiveEventDataStoreException" => crate::error::AddTagsError {
            meta: generic,
            kind: crate::error::AddTagsErrorKind::InactiveEventDataStoreException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::inactive_event_data_store_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_inactive_event_data_store_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AddTagsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidTagParameterException" => crate::error::AddTagsError {
            meta: generic,
            kind: crate::error::AddTagsErrorKind::InvalidTagParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_tag_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_tag_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AddTagsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidTrailNameException" => crate::error::AddTagsError {
            meta: generic,
            kind: crate::error::AddTagsErrorKind::InvalidTrailNameException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_trail_name_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_trail_name_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AddTagsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotOrganizationMasterAccountException" => {
            crate::error::AddTagsError {
                meta: generic,
                kind: crate::error::AddTagsErrorKind::NotOrganizationMasterAccountException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]let mut output = crate::error::not_organization_master_account_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_not_organization_master_account_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AddTagsError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "OperationNotPermittedException" => crate::error::AddTagsError {
            meta: generic,
            kind: crate::error::AddTagsErrorKind::OperationNotPermittedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::operation_not_permitted_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_operation_not_permitted_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AddTagsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::AddTagsError {
            meta: generic,
            kind: crate::error::AddTagsErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AddTagsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceTypeNotSupportedException" => crate::error::AddTagsError {
            meta: generic,
            kind: crate::error::AddTagsErrorKind::ResourceTypeNotSupportedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::resource_type_not_supported_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_type_not_supported_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AddTagsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TagsLimitExceededException" => crate::error::AddTagsError {
            meta: generic,
            kind: crate::error::AddTagsErrorKind::TagsLimitExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::tags_limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_tags_limit_exceeded_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AddTagsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "UnsupportedOperationException" => crate::error::AddTagsError {
            meta: generic,
            kind: crate::error::AddTagsErrorKind::UnsupportedOperationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::unsupported_operation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unsupported_operation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AddTagsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::AddTagsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_add_tags_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::AddTagsOutput, crate::error::AddTagsError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::add_tags_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_cancel_query_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CancelQueryOutput, crate::error::CancelQueryError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::CancelQueryError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::CancelQueryError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ConflictException" => {
            crate::error::CancelQueryError {
                meta: generic,
                kind: crate::error::CancelQueryErrorKind::ConflictException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::conflict_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_conflict_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CancelQueryError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "EventDataStoreARNInvalidException" => crate::error::CancelQueryError {
            meta: generic,
            kind: crate::error::CancelQueryErrorKind::EventDataStoreArnInvalidException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::event_data_store_arn_invalid_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_event_data_store_arn_invalid_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CancelQueryError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "EventDataStoreNotFoundException" => crate::error::CancelQueryError {
            meta: generic,
            kind: crate::error::CancelQueryErrorKind::EventDataStoreNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::event_data_store_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_event_data_store_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CancelQueryError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InactiveEventDataStoreException" => crate::error::CancelQueryError {
            meta: generic,
            kind: crate::error::CancelQueryErrorKind::InactiveEventDataStoreException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::inactive_event_data_store_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_inactive_event_data_store_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CancelQueryError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InactiveQueryException" => crate::error::CancelQueryError {
            meta: generic,
            kind: crate::error::CancelQueryErrorKind::InactiveQueryException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::inactive_query_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_inactive_query_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CancelQueryError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterException" => crate::error::CancelQueryError {
            meta: generic,
            kind: crate::error::CancelQueryErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CancelQueryError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "OperationNotPermittedException" => crate::error::CancelQueryError {
            meta: generic,
            kind: crate::error::CancelQueryErrorKind::OperationNotPermittedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::operation_not_permitted_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_operation_not_permitted_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CancelQueryError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "QueryIdNotFoundException" => crate::error::CancelQueryError {
            meta: generic,
            kind: crate::error::CancelQueryErrorKind::QueryIdNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::query_id_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_query_id_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CancelQueryError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "UnsupportedOperationException" => crate::error::CancelQueryError {
            meta: generic,
            kind: crate::error::CancelQueryErrorKind::UnsupportedOperationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::unsupported_operation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unsupported_operation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CancelQueryError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CancelQueryError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_cancel_query_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CancelQueryOutput, crate::error::CancelQueryError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::cancel_query_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_cancel_query(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CancelQueryError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_event_data_store_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateEventDataStoreOutput,
    crate::error::CreateEventDataStoreError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateEventDataStoreError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::CreateEventDataStoreError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "CloudTrailAccessNotEnabledException" => crate::error::CreateEventDataStoreError { meta: generic, kind: crate::error::CreateEventDataStoreErrorKind::CloudTrailAccessNotEnabledException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::cloud_trail_access_not_enabled_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_cloud_trail_access_not_enabled_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateEventDataStoreError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "ConflictException" => crate::error::CreateEventDataStoreError { meta: generic, kind: crate::error::CreateEventDataStoreErrorKind::ConflictException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::conflict_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_conflict_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateEventDataStoreError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "EventDataStoreAlreadyExistsException" => crate::error::CreateEventDataStoreError { meta: generic, kind: crate::error::CreateEventDataStoreErrorKind::EventDataStoreAlreadyExistsException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::event_data_store_already_exists_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_event_data_store_already_exists_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateEventDataStoreError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "EventDataStoreMaxLimitExceededException" => crate::error::CreateEventDataStoreError { meta: generic, kind: crate::error::CreateEventDataStoreErrorKind::EventDataStoreMaxLimitExceededException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::event_data_store_max_limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_event_data_store_max_limit_exceeded_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateEventDataStoreError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InsufficientDependencyServiceAccessPermissionException" => crate::error::CreateEventDataStoreError { meta: generic, kind: crate::error::CreateEventDataStoreErrorKind::InsufficientDependencyServiceAccessPermissionException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::insufficient_dependency_service_access_permission_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_insufficient_dependency_service_access_permission_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateEventDataStoreError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidParameterException" => crate::error::CreateEventDataStoreError { meta: generic, kind: crate::error::CreateEventDataStoreErrorKind::InvalidParameterException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateEventDataStoreError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidTagParameterException" => crate::error::CreateEventDataStoreError { meta: generic, kind: crate::error::CreateEventDataStoreErrorKind::InvalidTagParameterException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_tag_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_tag_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateEventDataStoreError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "NotOrganizationMasterAccountException" => crate::error::CreateEventDataStoreError { meta: generic, kind: crate::error::CreateEventDataStoreErrorKind::NotOrganizationMasterAccountException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::not_organization_master_account_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_organization_master_account_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateEventDataStoreError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "OperationNotPermittedException" => crate::error::CreateEventDataStoreError { meta: generic, kind: crate::error::CreateEventDataStoreErrorKind::OperationNotPermittedException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::operation_not_permitted_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_operation_not_permitted_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateEventDataStoreError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "OrganizationNotInAllFeaturesModeException" => crate::error::CreateEventDataStoreError { meta: generic, kind: crate::error::CreateEventDataStoreErrorKind::OrganizationNotInAllFeaturesModeException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::organization_not_in_all_features_mode_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_organization_not_in_all_features_mode_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateEventDataStoreError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "OrganizationsNotInUseException" => crate::error::CreateEventDataStoreError { meta: generic, kind: crate::error::CreateEventDataStoreErrorKind::OrganizationsNotInUseException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::organizations_not_in_use_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_organizations_not_in_use_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateEventDataStoreError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "UnsupportedOperationException" => crate::error::CreateEventDataStoreError { meta: generic, kind: crate::error::CreateEventDataStoreErrorKind::UnsupportedOperationException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::unsupported_operation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unsupported_operation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateEventDataStoreError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::CreateEventDataStoreError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_event_data_store_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateEventDataStoreOutput,
    crate::error::CreateEventDataStoreError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_event_data_store_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_create_event_data_store(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CreateEventDataStoreError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_trail_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateTrailOutput, crate::error::CreateTrailError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateTrailError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::CreateTrailError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "CloudTrailAccessNotEnabledException" => crate::error::CreateTrailError { meta: generic, kind: crate::error::CreateTrailErrorKind::CloudTrailAccessNotEnabledException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::cloud_trail_access_not_enabled_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_cloud_trail_access_not_enabled_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateTrailError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "CloudTrailInvalidClientTokenIdException" => crate::error::CreateTrailError { meta: generic, kind: crate::error::CreateTrailErrorKind::CloudTrailInvalidClientTokenIdException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::cloud_trail_invalid_client_token_id_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_cloud_trail_invalid_client_token_id_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateTrailError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "CloudWatchLogsDeliveryUnavailableException" => crate::error::CreateTrailError { meta: generic, kind: crate::error::CreateTrailErrorKind::CloudWatchLogsDeliveryUnavailableException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::cloud_watch_logs_delivery_unavailable_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_cloud_watch_logs_delivery_unavailable_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateTrailError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "ConflictException" => crate::error::CreateTrailError { meta: generic, kind: crate::error::CreateTrailErrorKind::ConflictException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::conflict_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_conflict_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateTrailError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InsufficientDependencyServiceAccessPermissionException" => crate::error::CreateTrailError { meta: generic, kind: crate::error::CreateTrailErrorKind::InsufficientDependencyServiceAccessPermissionException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::insufficient_dependency_service_access_permission_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_insufficient_dependency_service_access_permission_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateTrailError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InsufficientEncryptionPolicyException" => crate::error::CreateTrailError { meta: generic, kind: crate::error::CreateTrailErrorKind::InsufficientEncryptionPolicyException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::insufficient_encryption_policy_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_insufficient_encryption_policy_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateTrailError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InsufficientS3BucketPolicyException" => crate::error::CreateTrailError { meta: generic, kind: crate::error::CreateTrailErrorKind::InsufficientS3BucketPolicyException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::insufficient_s3_bucket_policy_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_insufficient_s3_bucket_policy_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateTrailError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InsufficientSnsTopicPolicyException" => crate::error::CreateTrailError { meta: generic, kind: crate::error::CreateTrailErrorKind::InsufficientSnsTopicPolicyException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::insufficient_sns_topic_policy_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_insufficient_sns_topic_policy_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateTrailError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidCloudWatchLogsLogGroupArnException" => crate::error::CreateTrailError { meta: generic, kind: crate::error::CreateTrailErrorKind::InvalidCloudWatchLogsLogGroupArnException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_cloud_watch_logs_log_group_arn_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_cloud_watch_logs_log_group_arn_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateTrailError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidCloudWatchLogsRoleArnException" => crate::error::CreateTrailError { meta: generic, kind: crate::error::CreateTrailErrorKind::InvalidCloudWatchLogsRoleArnException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_cloud_watch_logs_role_arn_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_cloud_watch_logs_role_arn_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateTrailError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidKmsKeyIdException" => crate::error::CreateTrailError { meta: generic, kind: crate::error::CreateTrailErrorKind::InvalidKmsKeyIdException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_kms_key_id_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_kms_key_id_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateTrailError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidParameterCombinationException" => crate::error::CreateTrailError { meta: generic, kind: crate::error::CreateTrailErrorKind::InvalidParameterCombinationException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_parameter_combination_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_combination_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateTrailError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidS3BucketNameException" => crate::error::CreateTrailError { meta: generic, kind: crate::error::CreateTrailErrorKind::InvalidS3BucketNameException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_s3_bucket_name_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_s3_bucket_name_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateTrailError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidS3PrefixException" => crate::error::CreateTrailError { meta: generic, kind: crate::error::CreateTrailErrorKind::InvalidS3PrefixException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_s3_prefix_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_s3_prefix_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateTrailError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidSnsTopicNameException" => crate::error::CreateTrailError { meta: generic, kind: crate::error::CreateTrailErrorKind::InvalidSnsTopicNameException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_sns_topic_name_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_sns_topic_name_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateTrailError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidTagParameterException" => crate::error::CreateTrailError { meta: generic, kind: crate::error::CreateTrailErrorKind::InvalidTagParameterException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_tag_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_tag_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateTrailError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidTrailNameException" => crate::error::CreateTrailError { meta: generic, kind: crate::error::CreateTrailErrorKind::InvalidTrailNameException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_trail_name_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_trail_name_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateTrailError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "KmsException" => crate::error::CreateTrailError { meta: generic, kind: crate::error::CreateTrailErrorKind::KmsException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::kms_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_kms_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateTrailError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "KmsKeyDisabledException" => crate::error::CreateTrailError { meta: generic, kind: crate::error::CreateTrailErrorKind::KmsKeyDisabledException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::kms_key_disabled_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_kms_key_disabled_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateTrailError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "KmsKeyNotFoundException" => crate::error::CreateTrailError { meta: generic, kind: crate::error::CreateTrailErrorKind::KmsKeyNotFoundException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::kms_key_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_kms_key_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateTrailError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "MaximumNumberOfTrailsExceededException" => crate::error::CreateTrailError { meta: generic, kind: crate::error::CreateTrailErrorKind::MaximumNumberOfTrailsExceededException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::maximum_number_of_trails_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_maximum_number_of_trails_exceeded_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateTrailError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "NotOrganizationMasterAccountException" => crate::error::CreateTrailError { meta: generic, kind: crate::error::CreateTrailErrorKind::NotOrganizationMasterAccountException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::not_organization_master_account_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_organization_master_account_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateTrailError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "OperationNotPermittedException" => crate::error::CreateTrailError { meta: generic, kind: crate::error::CreateTrailErrorKind::OperationNotPermittedException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::operation_not_permitted_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_operation_not_permitted_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateTrailError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "OrganizationNotInAllFeaturesModeException" => crate::error::CreateTrailError { meta: generic, kind: crate::error::CreateTrailErrorKind::OrganizationNotInAllFeaturesModeException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::organization_not_in_all_features_mode_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_organization_not_in_all_features_mode_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateTrailError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "OrganizationsNotInUseException" => crate::error::CreateTrailError { meta: generic, kind: crate::error::CreateTrailErrorKind::OrganizationsNotInUseException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::organizations_not_in_use_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_organizations_not_in_use_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateTrailError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "S3BucketDoesNotExistException" => crate::error::CreateTrailError { meta: generic, kind: crate::error::CreateTrailErrorKind::S3BucketDoesNotExistException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::s3_bucket_does_not_exist_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_s3_bucket_does_not_exist_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateTrailError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "TrailAlreadyExistsException" => crate::error::CreateTrailError { meta: generic, kind: crate::error::CreateTrailErrorKind::TrailAlreadyExistsException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::trail_already_exists_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_trail_already_exists_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateTrailError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "TrailNotProvidedException" => crate::error::CreateTrailError { meta: generic, kind: crate::error::CreateTrailErrorKind::TrailNotProvidedException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::trail_not_provided_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_trail_not_provided_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateTrailError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "UnsupportedOperationException" => crate::error::CreateTrailError { meta: generic, kind: crate::error::CreateTrailErrorKind::UnsupportedOperationException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::unsupported_operation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unsupported_operation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateTrailError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::CreateTrailError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_trail_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateTrailOutput, crate::error::CreateTrailError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_trail_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_create_trail(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CreateTrailError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_event_data_store_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteEventDataStoreOutput,
    crate::error::DeleteEventDataStoreError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteEventDataStoreError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DeleteEventDataStoreError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "EventDataStoreARNInvalidException" => crate::error::DeleteEventDataStoreError { meta: generic, kind: crate::error::DeleteEventDataStoreErrorKind::EventDataStoreArnInvalidException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::event_data_store_arn_invalid_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_event_data_store_arn_invalid_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteEventDataStoreError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "EventDataStoreNotFoundException" => crate::error::DeleteEventDataStoreError { meta: generic, kind: crate::error::DeleteEventDataStoreErrorKind::EventDataStoreNotFoundException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::event_data_store_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_event_data_store_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteEventDataStoreError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "EventDataStoreTerminationProtectedException" => crate::error::DeleteEventDataStoreError { meta: generic, kind: crate::error::DeleteEventDataStoreErrorKind::EventDataStoreTerminationProtectedException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::event_data_store_termination_protected_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_event_data_store_termination_protected_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteEventDataStoreError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InsufficientDependencyServiceAccessPermissionException" => crate::error::DeleteEventDataStoreError { meta: generic, kind: crate::error::DeleteEventDataStoreErrorKind::InsufficientDependencyServiceAccessPermissionException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::insufficient_dependency_service_access_permission_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_insufficient_dependency_service_access_permission_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteEventDataStoreError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidParameterException" => crate::error::DeleteEventDataStoreError { meta: generic, kind: crate::error::DeleteEventDataStoreErrorKind::InvalidParameterException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteEventDataStoreError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "NotOrganizationMasterAccountException" => crate::error::DeleteEventDataStoreError { meta: generic, kind: crate::error::DeleteEventDataStoreErrorKind::NotOrganizationMasterAccountException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::not_organization_master_account_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_organization_master_account_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteEventDataStoreError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "OperationNotPermittedException" => crate::error::DeleteEventDataStoreError { meta: generic, kind: crate::error::DeleteEventDataStoreErrorKind::OperationNotPermittedException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::operation_not_permitted_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_operation_not_permitted_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteEventDataStoreError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "UnsupportedOperationException" => crate::error::DeleteEventDataStoreError { meta: generic, kind: crate::error::DeleteEventDataStoreErrorKind::UnsupportedOperationException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::unsupported_operation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unsupported_operation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteEventDataStoreError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::DeleteEventDataStoreError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_event_data_store_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteEventDataStoreOutput,
    crate::error::DeleteEventDataStoreError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_event_data_store_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_trail_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteTrailOutput, crate::error::DeleteTrailError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteTrailError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DeleteTrailError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ConflictException" => crate::error::DeleteTrailError { meta: generic, kind: crate::error::DeleteTrailErrorKind::ConflictException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::conflict_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_conflict_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteTrailError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InsufficientDependencyServiceAccessPermissionException" => crate::error::DeleteTrailError { meta: generic, kind: crate::error::DeleteTrailErrorKind::InsufficientDependencyServiceAccessPermissionException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::insufficient_dependency_service_access_permission_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_insufficient_dependency_service_access_permission_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteTrailError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidHomeRegionException" => crate::error::DeleteTrailError { meta: generic, kind: crate::error::DeleteTrailErrorKind::InvalidHomeRegionException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_home_region_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_home_region_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteTrailError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidTrailNameException" => crate::error::DeleteTrailError { meta: generic, kind: crate::error::DeleteTrailErrorKind::InvalidTrailNameException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_trail_name_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_trail_name_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteTrailError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "NotOrganizationMasterAccountException" => crate::error::DeleteTrailError { meta: generic, kind: crate::error::DeleteTrailErrorKind::NotOrganizationMasterAccountException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::not_organization_master_account_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_organization_master_account_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteTrailError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "OperationNotPermittedException" => crate::error::DeleteTrailError { meta: generic, kind: crate::error::DeleteTrailErrorKind::OperationNotPermittedException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::operation_not_permitted_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_operation_not_permitted_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteTrailError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "TrailNotFoundException" => crate::error::DeleteTrailError { meta: generic, kind: crate::error::DeleteTrailErrorKind::TrailNotFoundException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::trail_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_trail_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteTrailError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "UnsupportedOperationException" => crate::error::DeleteTrailError { meta: generic, kind: crate::error::DeleteTrailErrorKind::UnsupportedOperationException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::unsupported_operation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unsupported_operation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteTrailError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::DeleteTrailError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_trail_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteTrailOutput, crate::error::DeleteTrailError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_trail_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_query_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DescribeQueryOutput, crate::error::DescribeQueryError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeQueryError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DescribeQueryError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "EventDataStoreARNInvalidException" => crate::error::DescribeQueryError {
            meta: generic,
            kind: crate::error::DescribeQueryErrorKind::EventDataStoreArnInvalidException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::event_data_store_arn_invalid_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_event_data_store_arn_invalid_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeQueryError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "EventDataStoreNotFoundException" => crate::error::DescribeQueryError {
            meta: generic,
            kind: crate::error::DescribeQueryErrorKind::EventDataStoreNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::event_data_store_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_event_data_store_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeQueryError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InactiveEventDataStoreException" => crate::error::DescribeQueryError {
            meta: generic,
            kind: crate::error::DescribeQueryErrorKind::InactiveEventDataStoreException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::inactive_event_data_store_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_inactive_event_data_store_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeQueryError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterException" => crate::error::DescribeQueryError {
            meta: generic,
            kind: crate::error::DescribeQueryErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeQueryError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "OperationNotPermittedException" => crate::error::DescribeQueryError {
            meta: generic,
            kind: crate::error::DescribeQueryErrorKind::OperationNotPermittedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::operation_not_permitted_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_operation_not_permitted_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeQueryError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "QueryIdNotFoundException" => crate::error::DescribeQueryError {
            meta: generic,
            kind: crate::error::DescribeQueryErrorKind::QueryIdNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::query_id_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_query_id_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeQueryError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "UnsupportedOperationException" => crate::error::DescribeQueryError {
            meta: generic,
            kind: crate::error::DescribeQueryErrorKind::UnsupportedOperationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::unsupported_operation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unsupported_operation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeQueryError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DescribeQueryError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_query_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DescribeQueryOutput, crate::error::DescribeQueryError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_query_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_describe_query(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeQueryError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_trails_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DescribeTrailsOutput, crate::error::DescribeTrailsError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeTrailsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DescribeTrailsError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidTrailNameException" => crate::error::DescribeTrailsError {
            meta: generic,
            kind: crate::error::DescribeTrailsErrorKind::InvalidTrailNameException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_trail_name_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_trail_name_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeTrailsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "OperationNotPermittedException" => crate::error::DescribeTrailsError {
            meta: generic,
            kind: crate::error::DescribeTrailsErrorKind::OperationNotPermittedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::operation_not_permitted_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_operation_not_permitted_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeTrailsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "UnsupportedOperationException" => crate::error::DescribeTrailsError {
            meta: generic,
            kind: crate::error::DescribeTrailsErrorKind::UnsupportedOperationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::unsupported_operation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unsupported_operation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeTrailsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DescribeTrailsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_trails_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DescribeTrailsOutput, crate::error::DescribeTrailsError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_trails_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_describe_trails(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeTrailsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_event_data_store_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetEventDataStoreOutput, crate::error::GetEventDataStoreError>
{
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetEventDataStoreError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::GetEventDataStoreError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "EventDataStoreARNInvalidException" => crate::error::GetEventDataStoreError {
            meta: generic,
            kind: crate::error::GetEventDataStoreErrorKind::EventDataStoreArnInvalidException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::event_data_store_arn_invalid_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_event_data_store_arn_invalid_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetEventDataStoreError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "EventDataStoreNotFoundException" => crate::error::GetEventDataStoreError {
            meta: generic,
            kind: crate::error::GetEventDataStoreErrorKind::EventDataStoreNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::event_data_store_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_event_data_store_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetEventDataStoreError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterException" => crate::error::GetEventDataStoreError {
            meta: generic,
            kind: crate::error::GetEventDataStoreErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetEventDataStoreError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "OperationNotPermittedException" => crate::error::GetEventDataStoreError {
            meta: generic,
            kind: crate::error::GetEventDataStoreErrorKind::OperationNotPermittedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::operation_not_permitted_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_operation_not_permitted_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetEventDataStoreError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "UnsupportedOperationException" => crate::error::GetEventDataStoreError {
            meta: generic,
            kind: crate::error::GetEventDataStoreErrorKind::UnsupportedOperationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::unsupported_operation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unsupported_operation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetEventDataStoreError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::GetEventDataStoreError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_event_data_store_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetEventDataStoreOutput, crate::error::GetEventDataStoreError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_event_data_store_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_get_event_data_store(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::GetEventDataStoreError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_event_selectors_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetEventSelectorsOutput, crate::error::GetEventSelectorsError>
{
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetEventSelectorsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::GetEventSelectorsError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidTrailNameException" => crate::error::GetEventSelectorsError {
            meta: generic,
            kind: crate::error::GetEventSelectorsErrorKind::InvalidTrailNameException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_trail_name_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_trail_name_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetEventSelectorsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "OperationNotPermittedException" => crate::error::GetEventSelectorsError {
            meta: generic,
            kind: crate::error::GetEventSelectorsErrorKind::OperationNotPermittedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::operation_not_permitted_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_operation_not_permitted_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetEventSelectorsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TrailNotFoundException" => crate::error::GetEventSelectorsError {
            meta: generic,
            kind: crate::error::GetEventSelectorsErrorKind::TrailNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::trail_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_trail_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetEventSelectorsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "UnsupportedOperationException" => crate::error::GetEventSelectorsError {
            meta: generic,
            kind: crate::error::GetEventSelectorsErrorKind::UnsupportedOperationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::unsupported_operation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unsupported_operation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetEventSelectorsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::GetEventSelectorsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_event_selectors_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetEventSelectorsOutput, crate::error::GetEventSelectorsError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_event_selectors_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_get_event_selectors(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::GetEventSelectorsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_insight_selectors_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetInsightSelectorsOutput,
    crate::error::GetInsightSelectorsError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetInsightSelectorsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::GetInsightSelectorsError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InsightNotEnabledException" => crate::error::GetInsightSelectorsError {
            meta: generic,
            kind: crate::error::GetInsightSelectorsErrorKind::InsightNotEnabledException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::insight_not_enabled_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_insight_not_enabled_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetInsightSelectorsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidTrailNameException" => crate::error::GetInsightSelectorsError {
            meta: generic,
            kind: crate::error::GetInsightSelectorsErrorKind::InvalidTrailNameException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_trail_name_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_trail_name_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetInsightSelectorsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "OperationNotPermittedException" => crate::error::GetInsightSelectorsError {
            meta: generic,
            kind: crate::error::GetInsightSelectorsErrorKind::OperationNotPermittedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::operation_not_permitted_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_operation_not_permitted_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetInsightSelectorsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TrailNotFoundException" => crate::error::GetInsightSelectorsError {
            meta: generic,
            kind: crate::error::GetInsightSelectorsErrorKind::TrailNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::trail_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_trail_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetInsightSelectorsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "UnsupportedOperationException" => crate::error::GetInsightSelectorsError {
            meta: generic,
            kind: crate::error::GetInsightSelectorsErrorKind::UnsupportedOperationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::unsupported_operation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unsupported_operation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetInsightSelectorsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::GetInsightSelectorsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_insight_selectors_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetInsightSelectorsOutput,
    crate::error::GetInsightSelectorsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_insight_selectors_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_get_insight_selectors(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::GetInsightSelectorsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_query_results_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetQueryResultsOutput, crate::error::GetQueryResultsError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetQueryResultsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::GetQueryResultsError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "EventDataStoreARNInvalidException" => crate::error::GetQueryResultsError {
            meta: generic,
            kind: crate::error::GetQueryResultsErrorKind::EventDataStoreArnInvalidException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::event_data_store_arn_invalid_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_event_data_store_arn_invalid_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetQueryResultsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "EventDataStoreNotFoundException" => crate::error::GetQueryResultsError {
            meta: generic,
            kind: crate::error::GetQueryResultsErrorKind::EventDataStoreNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::event_data_store_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_event_data_store_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetQueryResultsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InactiveEventDataStoreException" => crate::error::GetQueryResultsError {
            meta: generic,
            kind: crate::error::GetQueryResultsErrorKind::InactiveEventDataStoreException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::inactive_event_data_store_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_inactive_event_data_store_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetQueryResultsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidMaxResultsException" => crate::error::GetQueryResultsError {
            meta: generic,
            kind: crate::error::GetQueryResultsErrorKind::InvalidMaxResultsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_max_results_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_max_results_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetQueryResultsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidNextTokenException" => crate::error::GetQueryResultsError {
            meta: generic,
            kind: crate::error::GetQueryResultsErrorKind::InvalidNextTokenException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_next_token_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_next_token_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetQueryResultsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterException" => crate::error::GetQueryResultsError {
            meta: generic,
            kind: crate::error::GetQueryResultsErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetQueryResultsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "OperationNotPermittedException" => crate::error::GetQueryResultsError {
            meta: generic,
            kind: crate::error::GetQueryResultsErrorKind::OperationNotPermittedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::operation_not_permitted_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_operation_not_permitted_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetQueryResultsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "QueryIdNotFoundException" => crate::error::GetQueryResultsError {
            meta: generic,
            kind: crate::error::GetQueryResultsErrorKind::QueryIdNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::query_id_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_query_id_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetQueryResultsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "UnsupportedOperationException" => crate::error::GetQueryResultsError {
            meta: generic,
            kind: crate::error::GetQueryResultsErrorKind::UnsupportedOperationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::unsupported_operation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unsupported_operation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetQueryResultsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::GetQueryResultsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_query_results_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetQueryResultsOutput, crate::error::GetQueryResultsError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_query_results_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_get_query_results(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::GetQueryResultsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_trail_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetTrailOutput, crate::error::GetTrailError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetTrailError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::GetTrailError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidTrailNameException" => crate::error::GetTrailError {
            meta: generic,
            kind: crate::error::GetTrailErrorKind::InvalidTrailNameException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_trail_name_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_trail_name_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetTrailError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "OperationNotPermittedException" => crate::error::GetTrailError {
            meta: generic,
            kind: crate::error::GetTrailErrorKind::OperationNotPermittedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::operation_not_permitted_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_operation_not_permitted_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetTrailError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TrailNotFoundException" => crate::error::GetTrailError {
            meta: generic,
            kind: crate::error::GetTrailErrorKind::TrailNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::trail_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_trail_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetTrailError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "UnsupportedOperationException" => crate::error::GetTrailError {
            meta: generic,
            kind: crate::error::GetTrailErrorKind::UnsupportedOperationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::unsupported_operation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unsupported_operation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetTrailError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::GetTrailError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_trail_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetTrailOutput, crate::error::GetTrailError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_trail_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_get_trail(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::GetTrailError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_trail_status_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetTrailStatusOutput, crate::error::GetTrailStatusError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetTrailStatusError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::GetTrailStatusError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidTrailNameException" => crate::error::GetTrailStatusError {
            meta: generic,
            kind: crate::error::GetTrailStatusErrorKind::InvalidTrailNameException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_trail_name_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_trail_name_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetTrailStatusError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "OperationNotPermittedException" => crate::error::GetTrailStatusError {
            meta: generic,
            kind: crate::error::GetTrailStatusErrorKind::OperationNotPermittedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::operation_not_permitted_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_operation_not_permitted_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetTrailStatusError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TrailNotFoundException" => crate::error::GetTrailStatusError {
            meta: generic,
            kind: crate::error::GetTrailStatusErrorKind::TrailNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::trail_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_trail_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetTrailStatusError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "UnsupportedOperationException" => crate::error::GetTrailStatusError {
            meta: generic,
            kind: crate::error::GetTrailStatusErrorKind::UnsupportedOperationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::unsupported_operation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unsupported_operation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetTrailStatusError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::GetTrailStatusError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_trail_status_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetTrailStatusOutput, crate::error::GetTrailStatusError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_trail_status_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_get_trail_status(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::GetTrailStatusError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_event_data_stores_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListEventDataStoresOutput,
    crate::error::ListEventDataStoresError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListEventDataStoresError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ListEventDataStoresError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidMaxResultsException" => crate::error::ListEventDataStoresError {
            meta: generic,
            kind: crate::error::ListEventDataStoresErrorKind::InvalidMaxResultsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_max_results_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_max_results_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListEventDataStoresError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidNextTokenException" => crate::error::ListEventDataStoresError {
            meta: generic,
            kind: crate::error::ListEventDataStoresErrorKind::InvalidNextTokenException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_next_token_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_next_token_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListEventDataStoresError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "OperationNotPermittedException" => crate::error::ListEventDataStoresError {
            meta: generic,
            kind: crate::error::ListEventDataStoresErrorKind::OperationNotPermittedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::operation_not_permitted_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_operation_not_permitted_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListEventDataStoresError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "UnsupportedOperationException" => crate::error::ListEventDataStoresError {
            meta: generic,
            kind: crate::error::ListEventDataStoresErrorKind::UnsupportedOperationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::unsupported_operation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unsupported_operation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListEventDataStoresError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ListEventDataStoresError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_event_data_stores_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListEventDataStoresOutput,
    crate::error::ListEventDataStoresError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_event_data_stores_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_list_event_data_stores(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListEventDataStoresError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_public_keys_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListPublicKeysOutput, crate::error::ListPublicKeysError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListPublicKeysError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ListPublicKeysError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidTimeRangeException" => crate::error::ListPublicKeysError {
            meta: generic,
            kind: crate::error::ListPublicKeysErrorKind::InvalidTimeRangeException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_time_range_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_time_range_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListPublicKeysError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidTokenException" => crate::error::ListPublicKeysError {
            meta: generic,
            kind: crate::error::ListPublicKeysErrorKind::InvalidTokenException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_token_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_token_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListPublicKeysError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "OperationNotPermittedException" => crate::error::ListPublicKeysError {
            meta: generic,
            kind: crate::error::ListPublicKeysErrorKind::OperationNotPermittedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::operation_not_permitted_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_operation_not_permitted_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListPublicKeysError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "UnsupportedOperationException" => crate::error::ListPublicKeysError {
            meta: generic,
            kind: crate::error::ListPublicKeysErrorKind::UnsupportedOperationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::unsupported_operation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unsupported_operation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListPublicKeysError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ListPublicKeysError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_public_keys_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListPublicKeysOutput, crate::error::ListPublicKeysError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_public_keys_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_list_public_keys(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListPublicKeysError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_queries_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListQueriesOutput, crate::error::ListQueriesError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListQueriesError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ListQueriesError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "EventDataStoreARNInvalidException" => crate::error::ListQueriesError {
            meta: generic,
            kind: crate::error::ListQueriesErrorKind::EventDataStoreArnInvalidException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::event_data_store_arn_invalid_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_event_data_store_arn_invalid_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListQueriesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "EventDataStoreNotFoundException" => crate::error::ListQueriesError {
            meta: generic,
            kind: crate::error::ListQueriesErrorKind::EventDataStoreNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::event_data_store_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_event_data_store_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListQueriesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InactiveEventDataStoreException" => crate::error::ListQueriesError {
            meta: generic,
            kind: crate::error::ListQueriesErrorKind::InactiveEventDataStoreException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::inactive_event_data_store_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_inactive_event_data_store_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListQueriesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidDateRangeException" => crate::error::ListQueriesError {
            meta: generic,
            kind: crate::error::ListQueriesErrorKind::InvalidDateRangeException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_date_range_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_date_range_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListQueriesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidMaxResultsException" => crate::error::ListQueriesError {
            meta: generic,
            kind: crate::error::ListQueriesErrorKind::InvalidMaxResultsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_max_results_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_max_results_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListQueriesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidNextTokenException" => crate::error::ListQueriesError {
            meta: generic,
            kind: crate::error::ListQueriesErrorKind::InvalidNextTokenException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_next_token_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_next_token_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListQueriesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterException" => crate::error::ListQueriesError {
            meta: generic,
            kind: crate::error::ListQueriesErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListQueriesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidQueryStatusException" => crate::error::ListQueriesError {
            meta: generic,
            kind: crate::error::ListQueriesErrorKind::InvalidQueryStatusException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_query_status_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_query_status_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListQueriesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "OperationNotPermittedException" => crate::error::ListQueriesError {
            meta: generic,
            kind: crate::error::ListQueriesErrorKind::OperationNotPermittedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::operation_not_permitted_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_operation_not_permitted_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListQueriesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "UnsupportedOperationException" => crate::error::ListQueriesError {
            meta: generic,
            kind: crate::error::ListQueriesErrorKind::UnsupportedOperationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::unsupported_operation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unsupported_operation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListQueriesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ListQueriesError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_queries_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListQueriesOutput, crate::error::ListQueriesError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_queries_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_list_queries(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListQueriesError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_tags_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListTagsOutput, crate::error::ListTagsError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListTagsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ListTagsError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "CloudTrailARNInvalidException" => crate::error::ListTagsError {
            meta: generic,
            kind: crate::error::ListTagsErrorKind::CloudTrailArnInvalidException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::cloud_trail_arn_invalid_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_cloud_trail_arn_invalid_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListTagsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "EventDataStoreNotFoundException" => crate::error::ListTagsError {
            meta: generic,
            kind: crate::error::ListTagsErrorKind::EventDataStoreNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::event_data_store_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_event_data_store_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListTagsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InactiveEventDataStoreException" => crate::error::ListTagsError {
            meta: generic,
            kind: crate::error::ListTagsErrorKind::InactiveEventDataStoreException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::inactive_event_data_store_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_inactive_event_data_store_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListTagsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidTokenException" => crate::error::ListTagsError {
            meta: generic,
            kind: crate::error::ListTagsErrorKind::InvalidTokenException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_token_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_token_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListTagsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidTrailNameException" => crate::error::ListTagsError {
            meta: generic,
            kind: crate::error::ListTagsErrorKind::InvalidTrailNameException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_trail_name_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_trail_name_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListTagsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "OperationNotPermittedException" => crate::error::ListTagsError {
            meta: generic,
            kind: crate::error::ListTagsErrorKind::OperationNotPermittedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::operation_not_permitted_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_operation_not_permitted_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListTagsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::ListTagsError {
            meta: generic,
            kind: crate::error::ListTagsErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListTagsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceTypeNotSupportedException" => crate::error::ListTagsError {
            meta: generic,
            kind: crate::error::ListTagsErrorKind::ResourceTypeNotSupportedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::resource_type_not_supported_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_type_not_supported_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListTagsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "UnsupportedOperationException" => crate::error::ListTagsError {
            meta: generic,
            kind: crate::error::ListTagsErrorKind::UnsupportedOperationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::unsupported_operation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unsupported_operation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListTagsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ListTagsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_tags_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListTagsOutput, crate::error::ListTagsError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_tags_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_list_tags(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListTagsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_trails_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListTrailsOutput, crate::error::ListTrailsError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListTrailsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ListTrailsError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "OperationNotPermittedException" => crate::error::ListTrailsError {
            meta: generic,
            kind: crate::error::ListTrailsErrorKind::OperationNotPermittedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::operation_not_permitted_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_operation_not_permitted_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListTrailsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "UnsupportedOperationException" => crate::error::ListTrailsError {
            meta: generic,
            kind: crate::error::ListTrailsErrorKind::UnsupportedOperationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::unsupported_operation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unsupported_operation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListTrailsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ListTrailsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_trails_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListTrailsOutput, crate::error::ListTrailsError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_trails_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_list_trails(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListTrailsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_lookup_events_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::LookupEventsOutput, crate::error::LookupEventsError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::LookupEventsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::LookupEventsError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidEventCategoryException" => crate::error::LookupEventsError {
            meta: generic,
            kind: crate::error::LookupEventsErrorKind::InvalidEventCategoryException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_event_category_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_event_category_exception_json_err(response.body().as_ref(), output).map_err(crate::error::LookupEventsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidLookupAttributesException" => crate::error::LookupEventsError {
            meta: generic,
            kind: crate::error::LookupEventsErrorKind::InvalidLookupAttributesException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_lookup_attributes_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_lookup_attributes_exception_json_err(response.body().as_ref(), output).map_err(crate::error::LookupEventsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidMaxResultsException" => crate::error::LookupEventsError {
            meta: generic,
            kind: crate::error::LookupEventsErrorKind::InvalidMaxResultsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_max_results_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_max_results_exception_json_err(response.body().as_ref(), output).map_err(crate::error::LookupEventsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidNextTokenException" => crate::error::LookupEventsError {
            meta: generic,
            kind: crate::error::LookupEventsErrorKind::InvalidNextTokenException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_next_token_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_next_token_exception_json_err(response.body().as_ref(), output).map_err(crate::error::LookupEventsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidTimeRangeException" => crate::error::LookupEventsError {
            meta: generic,
            kind: crate::error::LookupEventsErrorKind::InvalidTimeRangeException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_time_range_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_time_range_exception_json_err(response.body().as_ref(), output).map_err(crate::error::LookupEventsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "OperationNotPermittedException" => crate::error::LookupEventsError {
            meta: generic,
            kind: crate::error::LookupEventsErrorKind::OperationNotPermittedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::operation_not_permitted_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_operation_not_permitted_exception_json_err(response.body().as_ref(), output).map_err(crate::error::LookupEventsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "UnsupportedOperationException" => crate::error::LookupEventsError {
            meta: generic,
            kind: crate::error::LookupEventsErrorKind::UnsupportedOperationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::unsupported_operation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unsupported_operation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::LookupEventsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::LookupEventsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_lookup_events_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::LookupEventsOutput, crate::error::LookupEventsError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::lookup_events_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_lookup_events(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::LookupEventsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_put_event_selectors_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::PutEventSelectorsOutput, crate::error::PutEventSelectorsError>
{
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::PutEventSelectorsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::PutEventSelectorsError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InsufficientDependencyServiceAccessPermissionException" => crate::error::PutEventSelectorsError { meta: generic, kind: crate::error::PutEventSelectorsErrorKind::InsufficientDependencyServiceAccessPermissionException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::insufficient_dependency_service_access_permission_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_insufficient_dependency_service_access_permission_exception_json_err(response.body().as_ref(), output).map_err(crate::error::PutEventSelectorsError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidEventSelectorsException" => crate::error::PutEventSelectorsError { meta: generic, kind: crate::error::PutEventSelectorsErrorKind::InvalidEventSelectorsException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_event_selectors_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_event_selectors_exception_json_err(response.body().as_ref(), output).map_err(crate::error::PutEventSelectorsError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidHomeRegionException" => crate::error::PutEventSelectorsError { meta: generic, kind: crate::error::PutEventSelectorsErrorKind::InvalidHomeRegionException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_home_region_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_home_region_exception_json_err(response.body().as_ref(), output).map_err(crate::error::PutEventSelectorsError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidTrailNameException" => crate::error::PutEventSelectorsError { meta: generic, kind: crate::error::PutEventSelectorsErrorKind::InvalidTrailNameException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_trail_name_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_trail_name_exception_json_err(response.body().as_ref(), output).map_err(crate::error::PutEventSelectorsError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "NotOrganizationMasterAccountException" => crate::error::PutEventSelectorsError { meta: generic, kind: crate::error::PutEventSelectorsErrorKind::NotOrganizationMasterAccountException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::not_organization_master_account_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_organization_master_account_exception_json_err(response.body().as_ref(), output).map_err(crate::error::PutEventSelectorsError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "OperationNotPermittedException" => crate::error::PutEventSelectorsError { meta: generic, kind: crate::error::PutEventSelectorsErrorKind::OperationNotPermittedException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::operation_not_permitted_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_operation_not_permitted_exception_json_err(response.body().as_ref(), output).map_err(crate::error::PutEventSelectorsError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "TrailNotFoundException" => crate::error::PutEventSelectorsError { meta: generic, kind: crate::error::PutEventSelectorsErrorKind::TrailNotFoundException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::trail_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_trail_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::PutEventSelectorsError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "UnsupportedOperationException" => crate::error::PutEventSelectorsError { meta: generic, kind: crate::error::PutEventSelectorsErrorKind::UnsupportedOperationException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::unsupported_operation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unsupported_operation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::PutEventSelectorsError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::PutEventSelectorsError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_put_event_selectors_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::PutEventSelectorsOutput, crate::error::PutEventSelectorsError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::put_event_selectors_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_put_event_selectors(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::PutEventSelectorsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_put_insight_selectors_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::PutInsightSelectorsOutput,
    crate::error::PutInsightSelectorsError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::PutInsightSelectorsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::PutInsightSelectorsError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InsufficientEncryptionPolicyException" => crate::error::PutInsightSelectorsError {
            meta: generic,
            kind: crate::error::PutInsightSelectorsErrorKind::InsufficientEncryptionPolicyException(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]let mut output = crate::error::insufficient_encryption_policy_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_insufficient_encryption_policy_exception_json_err(response.body().as_ref(), output).map_err(crate::error::PutInsightSelectorsError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        "InsufficientS3BucketPolicyException" => {
            crate::error::PutInsightSelectorsError {
                meta: generic,
                kind:
                    crate::error::PutInsightSelectorsErrorKind::InsufficientS3BucketPolicyException(
                        {
                            #[allow(unused_mut)]
                            let mut tmp = {
                                #[allow(unused_mut)]let mut output = crate::error::insufficient_s3_bucket_policy_exception::Builder::default();
                                let _ = response;
                                output = crate::json_deser::deser_structure_crate_error_insufficient_s3_bucket_policy_exception_json_err(response.body().as_ref(), output).map_err(crate::error::PutInsightSelectorsError::unhandled)?;
                                output.build()
                            };
                            if (&tmp.message).is_none() {
                                tmp.message = _error_message;
                            }
                            tmp
                        },
                    ),
            }
        }
        "InvalidHomeRegionException" => crate::error::PutInsightSelectorsError {
            meta: generic,
            kind: crate::error::PutInsightSelectorsErrorKind::InvalidHomeRegionException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_home_region_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_home_region_exception_json_err(response.body().as_ref(), output).map_err(crate::error::PutInsightSelectorsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidInsightSelectorsException" => crate::error::PutInsightSelectorsError {
            meta: generic,
            kind: crate::error::PutInsightSelectorsErrorKind::InvalidInsightSelectorsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_insight_selectors_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_insight_selectors_exception_json_err(response.body().as_ref(), output).map_err(crate::error::PutInsightSelectorsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidTrailNameException" => crate::error::PutInsightSelectorsError {
            meta: generic,
            kind: crate::error::PutInsightSelectorsErrorKind::InvalidTrailNameException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_trail_name_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_trail_name_exception_json_err(response.body().as_ref(), output).map_err(crate::error::PutInsightSelectorsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "KmsException" => crate::error::PutInsightSelectorsError {
            meta: generic,
            kind: crate::error::PutInsightSelectorsErrorKind::KmsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::kms_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_kms_exception_json_err(
                        response.body().as_ref(),
                        output,
                    )
                    .map_err(crate::error::PutInsightSelectorsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotOrganizationMasterAccountException" => crate::error::PutInsightSelectorsError {
            meta: generic,
            kind: crate::error::PutInsightSelectorsErrorKind::NotOrganizationMasterAccountException(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]let mut output = crate::error::not_organization_master_account_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_not_organization_master_account_exception_json_err(response.body().as_ref(), output).map_err(crate::error::PutInsightSelectorsError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        "OperationNotPermittedException" => crate::error::PutInsightSelectorsError {
            meta: generic,
            kind: crate::error::PutInsightSelectorsErrorKind::OperationNotPermittedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::operation_not_permitted_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_operation_not_permitted_exception_json_err(response.body().as_ref(), output).map_err(crate::error::PutInsightSelectorsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "S3BucketDoesNotExistException" => crate::error::PutInsightSelectorsError {
            meta: generic,
            kind: crate::error::PutInsightSelectorsErrorKind::S3BucketDoesNotExistException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::s3_bucket_does_not_exist_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_s3_bucket_does_not_exist_exception_json_err(response.body().as_ref(), output).map_err(crate::error::PutInsightSelectorsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TrailNotFoundException" => crate::error::PutInsightSelectorsError {
            meta: generic,
            kind: crate::error::PutInsightSelectorsErrorKind::TrailNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::trail_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_trail_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::PutInsightSelectorsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "UnsupportedOperationException" => crate::error::PutInsightSelectorsError {
            meta: generic,
            kind: crate::error::PutInsightSelectorsErrorKind::UnsupportedOperationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::unsupported_operation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unsupported_operation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::PutInsightSelectorsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::PutInsightSelectorsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_put_insight_selectors_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::PutInsightSelectorsOutput,
    crate::error::PutInsightSelectorsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::put_insight_selectors_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_put_insight_selectors(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::PutInsightSelectorsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_remove_tags_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::RemoveTagsOutput, crate::error::RemoveTagsError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::RemoveTagsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::RemoveTagsError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "CloudTrailARNInvalidException" => crate::error::RemoveTagsError {
            meta: generic,
            kind: crate::error::RemoveTagsErrorKind::CloudTrailArnInvalidException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::cloud_trail_arn_invalid_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_cloud_trail_arn_invalid_exception_json_err(response.body().as_ref(), output).map_err(crate::error::RemoveTagsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "EventDataStoreNotFoundException" => crate::error::RemoveTagsError {
            meta: generic,
            kind: crate::error::RemoveTagsErrorKind::EventDataStoreNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::event_data_store_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_event_data_store_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::RemoveTagsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InactiveEventDataStoreException" => crate::error::RemoveTagsError {
            meta: generic,
            kind: crate::error::RemoveTagsErrorKind::InactiveEventDataStoreException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::inactive_event_data_store_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_inactive_event_data_store_exception_json_err(response.body().as_ref(), output).map_err(crate::error::RemoveTagsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidTagParameterException" => crate::error::RemoveTagsError {
            meta: generic,
            kind: crate::error::RemoveTagsErrorKind::InvalidTagParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_tag_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_tag_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::RemoveTagsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidTrailNameException" => crate::error::RemoveTagsError {
            meta: generic,
            kind: crate::error::RemoveTagsErrorKind::InvalidTrailNameException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_trail_name_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_trail_name_exception_json_err(response.body().as_ref(), output).map_err(crate::error::RemoveTagsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotOrganizationMasterAccountException" => {
            crate::error::RemoveTagsError {
                meta: generic,
                kind: crate::error::RemoveTagsErrorKind::NotOrganizationMasterAccountException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]let mut output = crate::error::not_organization_master_account_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_not_organization_master_account_exception_json_err(response.body().as_ref(), output).map_err(crate::error::RemoveTagsError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "OperationNotPermittedException" => crate::error::RemoveTagsError {
            meta: generic,
            kind: crate::error::RemoveTagsErrorKind::OperationNotPermittedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::operation_not_permitted_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_operation_not_permitted_exception_json_err(response.body().as_ref(), output).map_err(crate::error::RemoveTagsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::RemoveTagsError {
            meta: generic,
            kind: crate::error::RemoveTagsErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::RemoveTagsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceTypeNotSupportedException" => crate::error::RemoveTagsError {
            meta: generic,
            kind: crate::error::RemoveTagsErrorKind::ResourceTypeNotSupportedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::resource_type_not_supported_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_type_not_supported_exception_json_err(response.body().as_ref(), output).map_err(crate::error::RemoveTagsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "UnsupportedOperationException" => crate::error::RemoveTagsError {
            meta: generic,
            kind: crate::error::RemoveTagsErrorKind::UnsupportedOperationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::unsupported_operation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unsupported_operation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::RemoveTagsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::RemoveTagsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_remove_tags_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::RemoveTagsOutput, crate::error::RemoveTagsError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::remove_tags_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_restore_event_data_store_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::RestoreEventDataStoreOutput,
    crate::error::RestoreEventDataStoreError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::RestoreEventDataStoreError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::RestoreEventDataStoreError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "CloudTrailAccessNotEnabledException" => crate::error::RestoreEventDataStoreError { meta: generic, kind: crate::error::RestoreEventDataStoreErrorKind::CloudTrailAccessNotEnabledException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::cloud_trail_access_not_enabled_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_cloud_trail_access_not_enabled_exception_json_err(response.body().as_ref(), output).map_err(crate::error::RestoreEventDataStoreError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "EventDataStoreARNInvalidException" => crate::error::RestoreEventDataStoreError { meta: generic, kind: crate::error::RestoreEventDataStoreErrorKind::EventDataStoreArnInvalidException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::event_data_store_arn_invalid_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_event_data_store_arn_invalid_exception_json_err(response.body().as_ref(), output).map_err(crate::error::RestoreEventDataStoreError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "EventDataStoreMaxLimitExceededException" => crate::error::RestoreEventDataStoreError { meta: generic, kind: crate::error::RestoreEventDataStoreErrorKind::EventDataStoreMaxLimitExceededException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::event_data_store_max_limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_event_data_store_max_limit_exceeded_exception_json_err(response.body().as_ref(), output).map_err(crate::error::RestoreEventDataStoreError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "EventDataStoreNotFoundException" => crate::error::RestoreEventDataStoreError { meta: generic, kind: crate::error::RestoreEventDataStoreErrorKind::EventDataStoreNotFoundException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::event_data_store_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_event_data_store_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::RestoreEventDataStoreError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InsufficientDependencyServiceAccessPermissionException" => crate::error::RestoreEventDataStoreError { meta: generic, kind: crate::error::RestoreEventDataStoreErrorKind::InsufficientDependencyServiceAccessPermissionException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::insufficient_dependency_service_access_permission_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_insufficient_dependency_service_access_permission_exception_json_err(response.body().as_ref(), output).map_err(crate::error::RestoreEventDataStoreError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidEventDataStoreStatusException" => crate::error::RestoreEventDataStoreError { meta: generic, kind: crate::error::RestoreEventDataStoreErrorKind::InvalidEventDataStoreStatusException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_event_data_store_status_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_event_data_store_status_exception_json_err(response.body().as_ref(), output).map_err(crate::error::RestoreEventDataStoreError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidParameterException" => crate::error::RestoreEventDataStoreError { meta: generic, kind: crate::error::RestoreEventDataStoreErrorKind::InvalidParameterException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::RestoreEventDataStoreError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "NotOrganizationMasterAccountException" => crate::error::RestoreEventDataStoreError { meta: generic, kind: crate::error::RestoreEventDataStoreErrorKind::NotOrganizationMasterAccountException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::not_organization_master_account_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_organization_master_account_exception_json_err(response.body().as_ref(), output).map_err(crate::error::RestoreEventDataStoreError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "OperationNotPermittedException" => crate::error::RestoreEventDataStoreError { meta: generic, kind: crate::error::RestoreEventDataStoreErrorKind::OperationNotPermittedException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::operation_not_permitted_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_operation_not_permitted_exception_json_err(response.body().as_ref(), output).map_err(crate::error::RestoreEventDataStoreError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "OrganizationNotInAllFeaturesModeException" => crate::error::RestoreEventDataStoreError { meta: generic, kind: crate::error::RestoreEventDataStoreErrorKind::OrganizationNotInAllFeaturesModeException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::organization_not_in_all_features_mode_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_organization_not_in_all_features_mode_exception_json_err(response.body().as_ref(), output).map_err(crate::error::RestoreEventDataStoreError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "OrganizationsNotInUseException" => crate::error::RestoreEventDataStoreError { meta: generic, kind: crate::error::RestoreEventDataStoreErrorKind::OrganizationsNotInUseException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::organizations_not_in_use_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_organizations_not_in_use_exception_json_err(response.body().as_ref(), output).map_err(crate::error::RestoreEventDataStoreError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "UnsupportedOperationException" => crate::error::RestoreEventDataStoreError { meta: generic, kind: crate::error::RestoreEventDataStoreErrorKind::UnsupportedOperationException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::unsupported_operation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unsupported_operation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::RestoreEventDataStoreError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::RestoreEventDataStoreError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_restore_event_data_store_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::RestoreEventDataStoreOutput,
    crate::error::RestoreEventDataStoreError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::restore_event_data_store_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_restore_event_data_store(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::RestoreEventDataStoreError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_start_logging_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::StartLoggingOutput, crate::error::StartLoggingError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::StartLoggingError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::StartLoggingError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InsufficientDependencyServiceAccessPermissionException" => crate::error::StartLoggingError { meta: generic, kind: crate::error::StartLoggingErrorKind::InsufficientDependencyServiceAccessPermissionException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::insufficient_dependency_service_access_permission_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_insufficient_dependency_service_access_permission_exception_json_err(response.body().as_ref(), output).map_err(crate::error::StartLoggingError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidHomeRegionException" => crate::error::StartLoggingError { meta: generic, kind: crate::error::StartLoggingErrorKind::InvalidHomeRegionException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_home_region_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_home_region_exception_json_err(response.body().as_ref(), output).map_err(crate::error::StartLoggingError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidTrailNameException" => crate::error::StartLoggingError { meta: generic, kind: crate::error::StartLoggingErrorKind::InvalidTrailNameException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_trail_name_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_trail_name_exception_json_err(response.body().as_ref(), output).map_err(crate::error::StartLoggingError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "NotOrganizationMasterAccountException" => crate::error::StartLoggingError { meta: generic, kind: crate::error::StartLoggingErrorKind::NotOrganizationMasterAccountException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::not_organization_master_account_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_organization_master_account_exception_json_err(response.body().as_ref(), output).map_err(crate::error::StartLoggingError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "OperationNotPermittedException" => crate::error::StartLoggingError { meta: generic, kind: crate::error::StartLoggingErrorKind::OperationNotPermittedException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::operation_not_permitted_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_operation_not_permitted_exception_json_err(response.body().as_ref(), output).map_err(crate::error::StartLoggingError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "TrailNotFoundException" => crate::error::StartLoggingError { meta: generic, kind: crate::error::StartLoggingErrorKind::TrailNotFoundException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::trail_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_trail_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::StartLoggingError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "UnsupportedOperationException" => crate::error::StartLoggingError { meta: generic, kind: crate::error::StartLoggingErrorKind::UnsupportedOperationException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::unsupported_operation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unsupported_operation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::StartLoggingError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::StartLoggingError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_start_logging_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::StartLoggingOutput, crate::error::StartLoggingError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::start_logging_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_start_query_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::StartQueryOutput, crate::error::StartQueryError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::StartQueryError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::StartQueryError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "EventDataStoreARNInvalidException" => crate::error::StartQueryError {
            meta: generic,
            kind: crate::error::StartQueryErrorKind::EventDataStoreArnInvalidException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::event_data_store_arn_invalid_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_event_data_store_arn_invalid_exception_json_err(response.body().as_ref(), output).map_err(crate::error::StartQueryError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "EventDataStoreNotFoundException" => crate::error::StartQueryError {
            meta: generic,
            kind: crate::error::StartQueryErrorKind::EventDataStoreNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::event_data_store_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_event_data_store_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::StartQueryError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InactiveEventDataStoreException" => crate::error::StartQueryError {
            meta: generic,
            kind: crate::error::StartQueryErrorKind::InactiveEventDataStoreException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::inactive_event_data_store_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_inactive_event_data_store_exception_json_err(response.body().as_ref(), output).map_err(crate::error::StartQueryError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterException" => crate::error::StartQueryError {
            meta: generic,
            kind: crate::error::StartQueryErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::StartQueryError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidQueryStatementException" => crate::error::StartQueryError {
            meta: generic,
            kind: crate::error::StartQueryErrorKind::InvalidQueryStatementException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_query_statement_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_query_statement_exception_json_err(response.body().as_ref(), output).map_err(crate::error::StartQueryError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "MaxConcurrentQueriesException" => crate::error::StartQueryError {
            meta: generic,
            kind: crate::error::StartQueryErrorKind::MaxConcurrentQueriesException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::max_concurrent_queries_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_max_concurrent_queries_exception_json_err(response.body().as_ref(), output).map_err(crate::error::StartQueryError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "OperationNotPermittedException" => crate::error::StartQueryError {
            meta: generic,
            kind: crate::error::StartQueryErrorKind::OperationNotPermittedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::operation_not_permitted_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_operation_not_permitted_exception_json_err(response.body().as_ref(), output).map_err(crate::error::StartQueryError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "UnsupportedOperationException" => crate::error::StartQueryError {
            meta: generic,
            kind: crate::error::StartQueryErrorKind::UnsupportedOperationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::unsupported_operation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unsupported_operation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::StartQueryError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::StartQueryError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_start_query_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::StartQueryOutput, crate::error::StartQueryError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::start_query_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_start_query(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::StartQueryError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_stop_logging_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::StopLoggingOutput, crate::error::StopLoggingError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::StopLoggingError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::StopLoggingError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InsufficientDependencyServiceAccessPermissionException" => crate::error::StopLoggingError { meta: generic, kind: crate::error::StopLoggingErrorKind::InsufficientDependencyServiceAccessPermissionException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::insufficient_dependency_service_access_permission_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_insufficient_dependency_service_access_permission_exception_json_err(response.body().as_ref(), output).map_err(crate::error::StopLoggingError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidHomeRegionException" => crate::error::StopLoggingError { meta: generic, kind: crate::error::StopLoggingErrorKind::InvalidHomeRegionException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_home_region_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_home_region_exception_json_err(response.body().as_ref(), output).map_err(crate::error::StopLoggingError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidTrailNameException" => crate::error::StopLoggingError { meta: generic, kind: crate::error::StopLoggingErrorKind::InvalidTrailNameException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_trail_name_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_trail_name_exception_json_err(response.body().as_ref(), output).map_err(crate::error::StopLoggingError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "NotOrganizationMasterAccountException" => crate::error::StopLoggingError { meta: generic, kind: crate::error::StopLoggingErrorKind::NotOrganizationMasterAccountException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::not_organization_master_account_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_organization_master_account_exception_json_err(response.body().as_ref(), output).map_err(crate::error::StopLoggingError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "OperationNotPermittedException" => crate::error::StopLoggingError { meta: generic, kind: crate::error::StopLoggingErrorKind::OperationNotPermittedException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::operation_not_permitted_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_operation_not_permitted_exception_json_err(response.body().as_ref(), output).map_err(crate::error::StopLoggingError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "TrailNotFoundException" => crate::error::StopLoggingError { meta: generic, kind: crate::error::StopLoggingErrorKind::TrailNotFoundException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::trail_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_trail_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::StopLoggingError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "UnsupportedOperationException" => crate::error::StopLoggingError { meta: generic, kind: crate::error::StopLoggingErrorKind::UnsupportedOperationException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::unsupported_operation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unsupported_operation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::StopLoggingError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::StopLoggingError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_stop_logging_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::StopLoggingOutput, crate::error::StopLoggingError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::stop_logging_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_event_data_store_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UpdateEventDataStoreOutput,
    crate::error::UpdateEventDataStoreError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::UpdateEventDataStoreError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::UpdateEventDataStoreError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "CloudTrailAccessNotEnabledException" => crate::error::UpdateEventDataStoreError { meta: generic, kind: crate::error::UpdateEventDataStoreErrorKind::CloudTrailAccessNotEnabledException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::cloud_trail_access_not_enabled_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_cloud_trail_access_not_enabled_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateEventDataStoreError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "EventDataStoreARNInvalidException" => crate::error::UpdateEventDataStoreError { meta: generic, kind: crate::error::UpdateEventDataStoreErrorKind::EventDataStoreArnInvalidException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::event_data_store_arn_invalid_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_event_data_store_arn_invalid_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateEventDataStoreError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "EventDataStoreNotFoundException" => crate::error::UpdateEventDataStoreError { meta: generic, kind: crate::error::UpdateEventDataStoreErrorKind::EventDataStoreNotFoundException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::event_data_store_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_event_data_store_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateEventDataStoreError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InactiveEventDataStoreException" => crate::error::UpdateEventDataStoreError { meta: generic, kind: crate::error::UpdateEventDataStoreErrorKind::InactiveEventDataStoreException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::inactive_event_data_store_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_inactive_event_data_store_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateEventDataStoreError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InsufficientDependencyServiceAccessPermissionException" => crate::error::UpdateEventDataStoreError { meta: generic, kind: crate::error::UpdateEventDataStoreErrorKind::InsufficientDependencyServiceAccessPermissionException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::insufficient_dependency_service_access_permission_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_insufficient_dependency_service_access_permission_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateEventDataStoreError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidParameterException" => crate::error::UpdateEventDataStoreError { meta: generic, kind: crate::error::UpdateEventDataStoreErrorKind::InvalidParameterException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateEventDataStoreError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "NotOrganizationMasterAccountException" => crate::error::UpdateEventDataStoreError { meta: generic, kind: crate::error::UpdateEventDataStoreErrorKind::NotOrganizationMasterAccountException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::not_organization_master_account_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_organization_master_account_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateEventDataStoreError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "OperationNotPermittedException" => crate::error::UpdateEventDataStoreError { meta: generic, kind: crate::error::UpdateEventDataStoreErrorKind::OperationNotPermittedException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::operation_not_permitted_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_operation_not_permitted_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateEventDataStoreError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "OrganizationNotInAllFeaturesModeException" => crate::error::UpdateEventDataStoreError { meta: generic, kind: crate::error::UpdateEventDataStoreErrorKind::OrganizationNotInAllFeaturesModeException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::organization_not_in_all_features_mode_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_organization_not_in_all_features_mode_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateEventDataStoreError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "OrganizationsNotInUseException" => crate::error::UpdateEventDataStoreError { meta: generic, kind: crate::error::UpdateEventDataStoreErrorKind::OrganizationsNotInUseException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::organizations_not_in_use_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_organizations_not_in_use_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateEventDataStoreError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "UnsupportedOperationException" => crate::error::UpdateEventDataStoreError { meta: generic, kind: crate::error::UpdateEventDataStoreErrorKind::UnsupportedOperationException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::unsupported_operation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unsupported_operation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateEventDataStoreError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::UpdateEventDataStoreError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_event_data_store_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UpdateEventDataStoreOutput,
    crate::error::UpdateEventDataStoreError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::update_event_data_store_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_update_event_data_store(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::UpdateEventDataStoreError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_trail_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::UpdateTrailOutput, crate::error::UpdateTrailError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::UpdateTrailError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::UpdateTrailError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "CloudTrailAccessNotEnabledException" => crate::error::UpdateTrailError { meta: generic, kind: crate::error::UpdateTrailErrorKind::CloudTrailAccessNotEnabledException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::cloud_trail_access_not_enabled_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_cloud_trail_access_not_enabled_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateTrailError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "CloudTrailInvalidClientTokenIdException" => crate::error::UpdateTrailError { meta: generic, kind: crate::error::UpdateTrailErrorKind::CloudTrailInvalidClientTokenIdException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::cloud_trail_invalid_client_token_id_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_cloud_trail_invalid_client_token_id_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateTrailError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "CloudWatchLogsDeliveryUnavailableException" => crate::error::UpdateTrailError { meta: generic, kind: crate::error::UpdateTrailErrorKind::CloudWatchLogsDeliveryUnavailableException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::cloud_watch_logs_delivery_unavailable_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_cloud_watch_logs_delivery_unavailable_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateTrailError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InsufficientDependencyServiceAccessPermissionException" => crate::error::UpdateTrailError { meta: generic, kind: crate::error::UpdateTrailErrorKind::InsufficientDependencyServiceAccessPermissionException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::insufficient_dependency_service_access_permission_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_insufficient_dependency_service_access_permission_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateTrailError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InsufficientEncryptionPolicyException" => crate::error::UpdateTrailError { meta: generic, kind: crate::error::UpdateTrailErrorKind::InsufficientEncryptionPolicyException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::insufficient_encryption_policy_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_insufficient_encryption_policy_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateTrailError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InsufficientS3BucketPolicyException" => crate::error::UpdateTrailError { meta: generic, kind: crate::error::UpdateTrailErrorKind::InsufficientS3BucketPolicyException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::insufficient_s3_bucket_policy_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_insufficient_s3_bucket_policy_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateTrailError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InsufficientSnsTopicPolicyException" => crate::error::UpdateTrailError { meta: generic, kind: crate::error::UpdateTrailErrorKind::InsufficientSnsTopicPolicyException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::insufficient_sns_topic_policy_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_insufficient_sns_topic_policy_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateTrailError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidCloudWatchLogsLogGroupArnException" => crate::error::UpdateTrailError { meta: generic, kind: crate::error::UpdateTrailErrorKind::InvalidCloudWatchLogsLogGroupArnException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_cloud_watch_logs_log_group_arn_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_cloud_watch_logs_log_group_arn_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateTrailError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidCloudWatchLogsRoleArnException" => crate::error::UpdateTrailError { meta: generic, kind: crate::error::UpdateTrailErrorKind::InvalidCloudWatchLogsRoleArnException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_cloud_watch_logs_role_arn_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_cloud_watch_logs_role_arn_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateTrailError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidEventSelectorsException" => crate::error::UpdateTrailError { meta: generic, kind: crate::error::UpdateTrailErrorKind::InvalidEventSelectorsException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_event_selectors_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_event_selectors_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateTrailError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidHomeRegionException" => crate::error::UpdateTrailError { meta: generic, kind: crate::error::UpdateTrailErrorKind::InvalidHomeRegionException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_home_region_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_home_region_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateTrailError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidKmsKeyIdException" => crate::error::UpdateTrailError { meta: generic, kind: crate::error::UpdateTrailErrorKind::InvalidKmsKeyIdException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_kms_key_id_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_kms_key_id_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateTrailError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidParameterCombinationException" => crate::error::UpdateTrailError { meta: generic, kind: crate::error::UpdateTrailErrorKind::InvalidParameterCombinationException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_parameter_combination_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_combination_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateTrailError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidS3BucketNameException" => crate::error::UpdateTrailError { meta: generic, kind: crate::error::UpdateTrailErrorKind::InvalidS3BucketNameException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_s3_bucket_name_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_s3_bucket_name_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateTrailError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidS3PrefixException" => crate::error::UpdateTrailError { meta: generic, kind: crate::error::UpdateTrailErrorKind::InvalidS3PrefixException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_s3_prefix_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_s3_prefix_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateTrailError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidSnsTopicNameException" => crate::error::UpdateTrailError { meta: generic, kind: crate::error::UpdateTrailErrorKind::InvalidSnsTopicNameException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_sns_topic_name_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_sns_topic_name_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateTrailError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidTrailNameException" => crate::error::UpdateTrailError { meta: generic, kind: crate::error::UpdateTrailErrorKind::InvalidTrailNameException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_trail_name_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_trail_name_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateTrailError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "KmsException" => crate::error::UpdateTrailError { meta: generic, kind: crate::error::UpdateTrailErrorKind::KmsException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::kms_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_kms_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateTrailError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "KmsKeyDisabledException" => crate::error::UpdateTrailError { meta: generic, kind: crate::error::UpdateTrailErrorKind::KmsKeyDisabledException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::kms_key_disabled_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_kms_key_disabled_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateTrailError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "KmsKeyNotFoundException" => crate::error::UpdateTrailError { meta: generic, kind: crate::error::UpdateTrailErrorKind::KmsKeyNotFoundException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::kms_key_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_kms_key_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateTrailError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "NotOrganizationMasterAccountException" => crate::error::UpdateTrailError { meta: generic, kind: crate::error::UpdateTrailErrorKind::NotOrganizationMasterAccountException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::not_organization_master_account_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_organization_master_account_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateTrailError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "OperationNotPermittedException" => crate::error::UpdateTrailError { meta: generic, kind: crate::error::UpdateTrailErrorKind::OperationNotPermittedException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::operation_not_permitted_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_operation_not_permitted_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateTrailError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "OrganizationNotInAllFeaturesModeException" => crate::error::UpdateTrailError { meta: generic, kind: crate::error::UpdateTrailErrorKind::OrganizationNotInAllFeaturesModeException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::organization_not_in_all_features_mode_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_organization_not_in_all_features_mode_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateTrailError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "OrganizationsNotInUseException" => crate::error::UpdateTrailError { meta: generic, kind: crate::error::UpdateTrailErrorKind::OrganizationsNotInUseException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::organizations_not_in_use_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_organizations_not_in_use_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateTrailError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "S3BucketDoesNotExistException" => crate::error::UpdateTrailError { meta: generic, kind: crate::error::UpdateTrailErrorKind::S3BucketDoesNotExistException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::s3_bucket_does_not_exist_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_s3_bucket_does_not_exist_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateTrailError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "TrailNotFoundException" => crate::error::UpdateTrailError { meta: generic, kind: crate::error::UpdateTrailErrorKind::TrailNotFoundException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::trail_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_trail_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateTrailError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "TrailNotProvidedException" => crate::error::UpdateTrailError { meta: generic, kind: crate::error::UpdateTrailErrorKind::TrailNotProvidedException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::trail_not_provided_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_trail_not_provided_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateTrailError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "UnsupportedOperationException" => crate::error::UpdateTrailError { meta: generic, kind: crate::error::UpdateTrailErrorKind::UnsupportedOperationException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::unsupported_operation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unsupported_operation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateTrailError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::UpdateTrailError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_trail_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::UpdateTrailOutput, crate::error::UpdateTrailError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::update_trail_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_update_trail(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::UpdateTrailError::unhandled)?;
        output.build()
    })
}
