// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
use std::fmt::Write;
/// See [`AddTagsInput`](crate::input::AddTagsInput)
pub mod add_tags_input {
    /// A builder for [`AddTagsInput`](crate::input::AddTagsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_id: std::option::Option<std::string::String>,
        pub(crate) tags_list: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>Specifies the ARN of the trail or event data store to which one or more tags will be added. The format of a trail ARN is:</p>
        /// <p> <code>arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail</code> </p>
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_id = Some(input.into());
            self
        }
        /// <p>Specifies the ARN of the trail or event data store to which one or more tags will be added. The format of a trail ARN is:</p>
        /// <p> <code>arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail</code> </p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_id = input;
            self
        }
        /// Appends an item to `tags_list`.
        ///
        /// To override the contents of this collection use [`set_tags_list`](Self::set_tags_list).
        ///
        /// <p>Contains a list of tags, up to a limit of 50</p>
        pub fn tags_list(mut self, input: crate::model::Tag) -> Self {
            let mut v = self.tags_list.unwrap_or_default();
            v.push(input);
            self.tags_list = Some(v);
            self
        }
        /// <p>Contains a list of tags, up to a limit of 50</p>
        pub fn set_tags_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags_list = input;
            self
        }
        /// Consumes the builder and constructs a [`AddTagsInput`](crate::input::AddTagsInput)
        pub fn build(
            self,
        ) -> std::result::Result<crate::input::AddTagsInput, aws_smithy_http::operation::BuildError>
        {
            Ok(crate::input::AddTagsInput {
                resource_id: self.resource_id,
                tags_list: self.tags_list,
            })
        }
    }
}
#[doc(hidden)]
pub type AddTagsInputOperationOutputAlias = crate::operation::AddTags;
#[doc(hidden)]
pub type AddTagsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl AddTagsInput {
    /// Consumes the builder and constructs an Operation<[`AddTags`](crate::operation::AddTags)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::AddTags,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::AddTagsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::AddTagsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "CloudTrail_20131101.AddTags",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_add_tags(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op =
            aws_smithy_http::operation::Operation::new(request, crate::operation::AddTags::new())
                .with_metadata(aws_smithy_http::operation::Metadata::new(
                    "AddTags",
                    "cloudtrail",
                ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`AddTagsInput`](crate::input::AddTagsInput)
    pub fn builder() -> crate::input::add_tags_input::Builder {
        crate::input::add_tags_input::Builder::default()
    }
}

/// See [`CancelQueryInput`](crate::input::CancelQueryInput)
pub mod cancel_query_input {
    /// A builder for [`CancelQueryInput`](crate::input::CancelQueryInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) event_data_store: std::option::Option<std::string::String>,
        pub(crate) query_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN (or the ID suffix of the ARN) of an event data store on which the specified query is running.</p>
        pub fn event_data_store(mut self, input: impl Into<std::string::String>) -> Self {
            self.event_data_store = Some(input.into());
            self
        }
        /// <p>The ARN (or the ID suffix of the ARN) of an event data store on which the specified query is running.</p>
        pub fn set_event_data_store(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.event_data_store = input;
            self
        }
        /// <p>The ID of the query that you want to cancel. The <code>QueryId</code> comes from the response of a <code>StartQuery</code> operation.</p>
        pub fn query_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.query_id = Some(input.into());
            self
        }
        /// <p>The ID of the query that you want to cancel. The <code>QueryId</code> comes from the response of a <code>StartQuery</code> operation.</p>
        pub fn set_query_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.query_id = input;
            self
        }
        /// Consumes the builder and constructs a [`CancelQueryInput`](crate::input::CancelQueryInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CancelQueryInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CancelQueryInput {
                event_data_store: self.event_data_store,
                query_id: self.query_id,
            })
        }
    }
}
#[doc(hidden)]
pub type CancelQueryInputOperationOutputAlias = crate::operation::CancelQuery;
#[doc(hidden)]
pub type CancelQueryInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CancelQueryInput {
    /// Consumes the builder and constructs an Operation<[`CancelQuery`](crate::operation::CancelQuery)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CancelQuery,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::CancelQueryInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CancelQueryInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "CloudTrail_20131101.CancelQuery",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_cancel_query(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CancelQuery::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CancelQuery",
            "cloudtrail",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CancelQueryInput`](crate::input::CancelQueryInput)
    pub fn builder() -> crate::input::cancel_query_input::Builder {
        crate::input::cancel_query_input::Builder::default()
    }
}

/// See [`CreateEventDataStoreInput`](crate::input::CreateEventDataStoreInput)
pub mod create_event_data_store_input {
    /// A builder for [`CreateEventDataStoreInput`](crate::input::CreateEventDataStoreInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) advanced_event_selectors:
            std::option::Option<std::vec::Vec<crate::model::AdvancedEventSelector>>,
        pub(crate) multi_region_enabled: std::option::Option<bool>,
        pub(crate) organization_enabled: std::option::Option<bool>,
        pub(crate) retention_period: std::option::Option<i32>,
        pub(crate) termination_protection_enabled: std::option::Option<bool>,
        pub(crate) tags_list: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The name of the event data store.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the event data store.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Appends an item to `advanced_event_selectors`.
        ///
        /// To override the contents of this collection use [`set_advanced_event_selectors`](Self::set_advanced_event_selectors).
        ///
        /// <p>The advanced event selectors to use to select the events for the data store. For more information about how to use advanced event selectors, see <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/logging-data-events-with-cloudtrail.html#creating-data-event-selectors-advanced">Log events by using advanced event selectors</a> in the CloudTrail User Guide.</p>
        pub fn advanced_event_selectors(
            mut self,
            input: crate::model::AdvancedEventSelector,
        ) -> Self {
            let mut v = self.advanced_event_selectors.unwrap_or_default();
            v.push(input);
            self.advanced_event_selectors = Some(v);
            self
        }
        /// <p>The advanced event selectors to use to select the events for the data store. For more information about how to use advanced event selectors, see <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/logging-data-events-with-cloudtrail.html#creating-data-event-selectors-advanced">Log events by using advanced event selectors</a> in the CloudTrail User Guide.</p>
        pub fn set_advanced_event_selectors(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AdvancedEventSelector>>,
        ) -> Self {
            self.advanced_event_selectors = input;
            self
        }
        /// <p>Specifies whether the event data store includes events from all regions, or only from the region in which the event data store is created.</p>
        pub fn multi_region_enabled(mut self, input: bool) -> Self {
            self.multi_region_enabled = Some(input);
            self
        }
        /// <p>Specifies whether the event data store includes events from all regions, or only from the region in which the event data store is created.</p>
        pub fn set_multi_region_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.multi_region_enabled = input;
            self
        }
        /// <p>Specifies whether an event data store collects events logged for an organization in Organizations.</p>
        pub fn organization_enabled(mut self, input: bool) -> Self {
            self.organization_enabled = Some(input);
            self
        }
        /// <p>Specifies whether an event data store collects events logged for an organization in Organizations.</p>
        pub fn set_organization_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.organization_enabled = input;
            self
        }
        /// <p>The retention period of the event data store, in days. You can set a retention period of up to 2555 days, the equivalent of seven years.</p>
        pub fn retention_period(mut self, input: i32) -> Self {
            self.retention_period = Some(input);
            self
        }
        /// <p>The retention period of the event data store, in days. You can set a retention period of up to 2555 days, the equivalent of seven years.</p>
        pub fn set_retention_period(mut self, input: std::option::Option<i32>) -> Self {
            self.retention_period = input;
            self
        }
        /// <p>Specifies whether termination protection is enabled for the event data store. If termination protection is enabled, you cannot delete the event data store until termination protection is disabled.</p>
        pub fn termination_protection_enabled(mut self, input: bool) -> Self {
            self.termination_protection_enabled = Some(input);
            self
        }
        /// <p>Specifies whether termination protection is enabled for the event data store. If termination protection is enabled, you cannot delete the event data store until termination protection is disabled.</p>
        pub fn set_termination_protection_enabled(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.termination_protection_enabled = input;
            self
        }
        /// Appends an item to `tags_list`.
        ///
        /// To override the contents of this collection use [`set_tags_list`](Self::set_tags_list).
        ///
        /// <p>A list of tags.</p>
        pub fn tags_list(mut self, input: crate::model::Tag) -> Self {
            let mut v = self.tags_list.unwrap_or_default();
            v.push(input);
            self.tags_list = Some(v);
            self
        }
        /// <p>A list of tags.</p>
        pub fn set_tags_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags_list = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateEventDataStoreInput`](crate::input::CreateEventDataStoreInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateEventDataStoreInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateEventDataStoreInput {
                name: self.name,
                advanced_event_selectors: self.advanced_event_selectors,
                multi_region_enabled: self.multi_region_enabled,
                organization_enabled: self.organization_enabled,
                retention_period: self.retention_period,
                termination_protection_enabled: self.termination_protection_enabled,
                tags_list: self.tags_list,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateEventDataStoreInputOperationOutputAlias = crate::operation::CreateEventDataStore;
#[doc(hidden)]
pub type CreateEventDataStoreInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateEventDataStoreInput {
    /// Consumes the builder and constructs an Operation<[`CreateEventDataStore`](crate::operation::CreateEventDataStore)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateEventDataStore,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateEventDataStoreInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateEventDataStoreInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "CloudTrail_20131101.CreateEventDataStore",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_event_data_store(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateEventDataStore::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateEventDataStore",
            "cloudtrail",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateEventDataStoreInput`](crate::input::CreateEventDataStoreInput)
    pub fn builder() -> crate::input::create_event_data_store_input::Builder {
        crate::input::create_event_data_store_input::Builder::default()
    }
}

/// See [`CreateTrailInput`](crate::input::CreateTrailInput)
pub mod create_trail_input {
    /// A builder for [`CreateTrailInput`](crate::input::CreateTrailInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) s3_bucket_name: std::option::Option<std::string::String>,
        pub(crate) s3_key_prefix: std::option::Option<std::string::String>,
        pub(crate) sns_topic_name: std::option::Option<std::string::String>,
        pub(crate) include_global_service_events: std::option::Option<bool>,
        pub(crate) is_multi_region_trail: std::option::Option<bool>,
        pub(crate) enable_log_file_validation: std::option::Option<bool>,
        pub(crate) cloud_watch_logs_log_group_arn: std::option::Option<std::string::String>,
        pub(crate) cloud_watch_logs_role_arn: std::option::Option<std::string::String>,
        pub(crate) kms_key_id: std::option::Option<std::string::String>,
        pub(crate) is_organization_trail: std::option::Option<bool>,
        pub(crate) tags_list: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>Specifies the name of the trail. The name must meet the following requirements:</p>
        /// <ul>
        /// <li> <p>Contain only ASCII letters (a-z, A-Z), numbers (0-9), periods (.), underscores (_), or dashes (-)</p> </li>
        /// <li> <p>Start with a letter or number, and end with a letter or number</p> </li>
        /// <li> <p>Be between 3 and 128 characters</p> </li>
        /// <li> <p>Have no adjacent periods, underscores or dashes. Names like <code>my-_namespace</code> and <code>my--namespace</code> are not valid.</p> </li>
        /// <li> <p>Not be in IP address format (for example, 192.168.5.4)</p> </li>
        /// </ul>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>Specifies the name of the trail. The name must meet the following requirements:</p>
        /// <ul>
        /// <li> <p>Contain only ASCII letters (a-z, A-Z), numbers (0-9), periods (.), underscores (_), or dashes (-)</p> </li>
        /// <li> <p>Start with a letter or number, and end with a letter or number</p> </li>
        /// <li> <p>Be between 3 and 128 characters</p> </li>
        /// <li> <p>Have no adjacent periods, underscores or dashes. Names like <code>my-_namespace</code> and <code>my--namespace</code> are not valid.</p> </li>
        /// <li> <p>Not be in IP address format (for example, 192.168.5.4)</p> </li>
        /// </ul>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>Specifies the name of the Amazon S3 bucket designated for publishing log files. See <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/create_trail_naming_policy.html">Amazon S3 Bucket Naming Requirements</a>.</p>
        pub fn s3_bucket_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.s3_bucket_name = Some(input.into());
            self
        }
        /// <p>Specifies the name of the Amazon S3 bucket designated for publishing log files. See <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/create_trail_naming_policy.html">Amazon S3 Bucket Naming Requirements</a>.</p>
        pub fn set_s3_bucket_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.s3_bucket_name = input;
            self
        }
        /// <p>Specifies the Amazon S3 key prefix that comes after the name of the bucket you have designated for log file delivery. For more information, see <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/cloudtrail-find-log-files.html">Finding Your CloudTrail Log Files</a>. The maximum length is 200 characters.</p>
        pub fn s3_key_prefix(mut self, input: impl Into<std::string::String>) -> Self {
            self.s3_key_prefix = Some(input.into());
            self
        }
        /// <p>Specifies the Amazon S3 key prefix that comes after the name of the bucket you have designated for log file delivery. For more information, see <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/cloudtrail-find-log-files.html">Finding Your CloudTrail Log Files</a>. The maximum length is 200 characters.</p>
        pub fn set_s3_key_prefix(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.s3_key_prefix = input;
            self
        }
        /// <p>Specifies the name of the Amazon SNS topic defined for notification of log file delivery. The maximum length is 256 characters.</p>
        pub fn sns_topic_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.sns_topic_name = Some(input.into());
            self
        }
        /// <p>Specifies the name of the Amazon SNS topic defined for notification of log file delivery. The maximum length is 256 characters.</p>
        pub fn set_sns_topic_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.sns_topic_name = input;
            self
        }
        /// <p>Specifies whether the trail is publishing events from global services such as IAM to the log files.</p>
        pub fn include_global_service_events(mut self, input: bool) -> Self {
            self.include_global_service_events = Some(input);
            self
        }
        /// <p>Specifies whether the trail is publishing events from global services such as IAM to the log files.</p>
        pub fn set_include_global_service_events(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.include_global_service_events = input;
            self
        }
        /// <p>Specifies whether the trail is created in the current region or in all regions. The default is false, which creates a trail only in the region where you are signed in. As a best practice, consider creating trails that log events in all regions.</p>
        pub fn is_multi_region_trail(mut self, input: bool) -> Self {
            self.is_multi_region_trail = Some(input);
            self
        }
        /// <p>Specifies whether the trail is created in the current region or in all regions. The default is false, which creates a trail only in the region where you are signed in. As a best practice, consider creating trails that log events in all regions.</p>
        pub fn set_is_multi_region_trail(mut self, input: std::option::Option<bool>) -> Self {
            self.is_multi_region_trail = input;
            self
        }
        /// <p>Specifies whether log file integrity validation is enabled. The default is false.</p> <note>
        /// <p>When you disable log file integrity validation, the chain of digest files is broken after one hour. CloudTrail does not create digest files for log files that were delivered during a period in which log file integrity validation was disabled. For example, if you enable log file integrity validation at noon on January 1, disable it at noon on January 2, and re-enable it at noon on January 10, digest files will not be created for the log files delivered from noon on January 2 to noon on January 10. The same applies whenever you stop CloudTrail logging or delete a trail.</p>
        /// </note>
        pub fn enable_log_file_validation(mut self, input: bool) -> Self {
            self.enable_log_file_validation = Some(input);
            self
        }
        /// <p>Specifies whether log file integrity validation is enabled. The default is false.</p> <note>
        /// <p>When you disable log file integrity validation, the chain of digest files is broken after one hour. CloudTrail does not create digest files for log files that were delivered during a period in which log file integrity validation was disabled. For example, if you enable log file integrity validation at noon on January 1, disable it at noon on January 2, and re-enable it at noon on January 10, digest files will not be created for the log files delivered from noon on January 2 to noon on January 10. The same applies whenever you stop CloudTrail logging or delete a trail.</p>
        /// </note>
        pub fn set_enable_log_file_validation(mut self, input: std::option::Option<bool>) -> Self {
            self.enable_log_file_validation = input;
            self
        }
        /// <p>Specifies a log group name using an Amazon Resource Name (ARN), a unique identifier that represents the log group to which CloudTrail logs will be delivered. Not required unless you specify <code>CloudWatchLogsRoleArn</code>.</p>
        pub fn cloud_watch_logs_log_group_arn(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.cloud_watch_logs_log_group_arn = Some(input.into());
            self
        }
        /// <p>Specifies a log group name using an Amazon Resource Name (ARN), a unique identifier that represents the log group to which CloudTrail logs will be delivered. Not required unless you specify <code>CloudWatchLogsRoleArn</code>.</p>
        pub fn set_cloud_watch_logs_log_group_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.cloud_watch_logs_log_group_arn = input;
            self
        }
        /// <p>Specifies the role for the CloudWatch Logs endpoint to assume to write to a user's log group.</p>
        pub fn cloud_watch_logs_role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.cloud_watch_logs_role_arn = Some(input.into());
            self
        }
        /// <p>Specifies the role for the CloudWatch Logs endpoint to assume to write to a user's log group.</p>
        pub fn set_cloud_watch_logs_role_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.cloud_watch_logs_role_arn = input;
            self
        }
        /// <p>Specifies the KMS key ID to use to encrypt the logs delivered by CloudTrail. The value can be an alias name prefixed by "alias/", a fully specified ARN to an alias, a fully specified ARN to a key, or a globally unique identifier.</p>
        /// <p>CloudTrail also supports KMS multi-Region keys. For more information about multi-Region keys, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/multi-region-keys-overview.html">Using multi-Region keys</a> in the <i>Key Management Service Developer Guide</i>.</p>
        /// <p>Examples:</p>
        /// <ul>
        /// <li> <p>alias/MyAliasName</p> </li>
        /// <li> <p>arn:aws:kms:us-east-2:123456789012:alias/MyAliasName</p> </li>
        /// <li> <p>arn:aws:kms:us-east-2:123456789012:key/12345678-1234-1234-1234-123456789012</p> </li>
        /// <li> <p>12345678-1234-1234-1234-123456789012</p> </li>
        /// </ul>
        pub fn kms_key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.kms_key_id = Some(input.into());
            self
        }
        /// <p>Specifies the KMS key ID to use to encrypt the logs delivered by CloudTrail. The value can be an alias name prefixed by "alias/", a fully specified ARN to an alias, a fully specified ARN to a key, or a globally unique identifier.</p>
        /// <p>CloudTrail also supports KMS multi-Region keys. For more information about multi-Region keys, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/multi-region-keys-overview.html">Using multi-Region keys</a> in the <i>Key Management Service Developer Guide</i>.</p>
        /// <p>Examples:</p>
        /// <ul>
        /// <li> <p>alias/MyAliasName</p> </li>
        /// <li> <p>arn:aws:kms:us-east-2:123456789012:alias/MyAliasName</p> </li>
        /// <li> <p>arn:aws:kms:us-east-2:123456789012:key/12345678-1234-1234-1234-123456789012</p> </li>
        /// <li> <p>12345678-1234-1234-1234-123456789012</p> </li>
        /// </ul>
        pub fn set_kms_key_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.kms_key_id = input;
            self
        }
        /// <p>Specifies whether the trail is created for all accounts in an organization in Organizations, or only for the current Amazon Web Services account. The default is false, and cannot be true unless the call is made on behalf of an Amazon Web Services account that is the management account for an organization in Organizations.</p>
        pub fn is_organization_trail(mut self, input: bool) -> Self {
            self.is_organization_trail = Some(input);
            self
        }
        /// <p>Specifies whether the trail is created for all accounts in an organization in Organizations, or only for the current Amazon Web Services account. The default is false, and cannot be true unless the call is made on behalf of an Amazon Web Services account that is the management account for an organization in Organizations.</p>
        pub fn set_is_organization_trail(mut self, input: std::option::Option<bool>) -> Self {
            self.is_organization_trail = input;
            self
        }
        /// Appends an item to `tags_list`.
        ///
        /// To override the contents of this collection use [`set_tags_list`](Self::set_tags_list).
        ///
        /// <p>A list of tags.</p>
        pub fn tags_list(mut self, input: crate::model::Tag) -> Self {
            let mut v = self.tags_list.unwrap_or_default();
            v.push(input);
            self.tags_list = Some(v);
            self
        }
        /// <p>A list of tags.</p>
        pub fn set_tags_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags_list = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateTrailInput`](crate::input::CreateTrailInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateTrailInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateTrailInput {
                name: self.name,
                s3_bucket_name: self.s3_bucket_name,
                s3_key_prefix: self.s3_key_prefix,
                sns_topic_name: self.sns_topic_name,
                include_global_service_events: self.include_global_service_events,
                is_multi_region_trail: self.is_multi_region_trail,
                enable_log_file_validation: self.enable_log_file_validation,
                cloud_watch_logs_log_group_arn: self.cloud_watch_logs_log_group_arn,
                cloud_watch_logs_role_arn: self.cloud_watch_logs_role_arn,
                kms_key_id: self.kms_key_id,
                is_organization_trail: self.is_organization_trail,
                tags_list: self.tags_list,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateTrailInputOperationOutputAlias = crate::operation::CreateTrail;
#[doc(hidden)]
pub type CreateTrailInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateTrailInput {
    /// Consumes the builder and constructs an Operation<[`CreateTrail`](crate::operation::CreateTrail)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateTrail,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateTrailInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateTrailInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "CloudTrail_20131101.CreateTrail",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_trail(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateTrail::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateTrail",
            "cloudtrail",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateTrailInput`](crate::input::CreateTrailInput)
    pub fn builder() -> crate::input::create_trail_input::Builder {
        crate::input::create_trail_input::Builder::default()
    }
}

/// See [`DeleteEventDataStoreInput`](crate::input::DeleteEventDataStoreInput)
pub mod delete_event_data_store_input {
    /// A builder for [`DeleteEventDataStoreInput`](crate::input::DeleteEventDataStoreInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) event_data_store: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN (or the ID suffix of the ARN) of the event data store to delete.</p>
        pub fn event_data_store(mut self, input: impl Into<std::string::String>) -> Self {
            self.event_data_store = Some(input.into());
            self
        }
        /// <p>The ARN (or the ID suffix of the ARN) of the event data store to delete.</p>
        pub fn set_event_data_store(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.event_data_store = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteEventDataStoreInput`](crate::input::DeleteEventDataStoreInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteEventDataStoreInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteEventDataStoreInput {
                event_data_store: self.event_data_store,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteEventDataStoreInputOperationOutputAlias = crate::operation::DeleteEventDataStore;
#[doc(hidden)]
pub type DeleteEventDataStoreInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteEventDataStoreInput {
    /// Consumes the builder and constructs an Operation<[`DeleteEventDataStore`](crate::operation::DeleteEventDataStore)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteEventDataStore,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteEventDataStoreInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteEventDataStoreInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "CloudTrail_20131101.DeleteEventDataStore",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_delete_event_data_store(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteEventDataStore::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteEventDataStore",
            "cloudtrail",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteEventDataStoreInput`](crate::input::DeleteEventDataStoreInput)
    pub fn builder() -> crate::input::delete_event_data_store_input::Builder {
        crate::input::delete_event_data_store_input::Builder::default()
    }
}

/// See [`DeleteTrailInput`](crate::input::DeleteTrailInput)
pub mod delete_trail_input {
    /// A builder for [`DeleteTrailInput`](crate::input::DeleteTrailInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Specifies the name or the CloudTrail ARN of the trail to be deleted. The following is the format of a trail ARN. <code>arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail</code> </p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>Specifies the name or the CloudTrail ARN of the trail to be deleted. The following is the format of a trail ARN. <code>arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail</code> </p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteTrailInput`](crate::input::DeleteTrailInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteTrailInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteTrailInput { name: self.name })
        }
    }
}
#[doc(hidden)]
pub type DeleteTrailInputOperationOutputAlias = crate::operation::DeleteTrail;
#[doc(hidden)]
pub type DeleteTrailInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteTrailInput {
    /// Consumes the builder and constructs an Operation<[`DeleteTrail`](crate::operation::DeleteTrail)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteTrail,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteTrailInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteTrailInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "CloudTrail_20131101.DeleteTrail",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_delete_trail(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteTrail::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteTrail",
            "cloudtrail",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteTrailInput`](crate::input::DeleteTrailInput)
    pub fn builder() -> crate::input::delete_trail_input::Builder {
        crate::input::delete_trail_input::Builder::default()
    }
}

/// See [`DescribeQueryInput`](crate::input::DescribeQueryInput)
pub mod describe_query_input {
    /// A builder for [`DescribeQueryInput`](crate::input::DescribeQueryInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) event_data_store: std::option::Option<std::string::String>,
        pub(crate) query_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN (or the ID suffix of the ARN) of an event data store on which the specified query was run.</p>
        pub fn event_data_store(mut self, input: impl Into<std::string::String>) -> Self {
            self.event_data_store = Some(input.into());
            self
        }
        /// <p>The ARN (or the ID suffix of the ARN) of an event data store on which the specified query was run.</p>
        pub fn set_event_data_store(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.event_data_store = input;
            self
        }
        /// <p>The query ID.</p>
        pub fn query_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.query_id = Some(input.into());
            self
        }
        /// <p>The query ID.</p>
        pub fn set_query_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.query_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeQueryInput`](crate::input::DescribeQueryInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeQueryInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeQueryInput {
                event_data_store: self.event_data_store,
                query_id: self.query_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeQueryInputOperationOutputAlias = crate::operation::DescribeQuery;
#[doc(hidden)]
pub type DescribeQueryInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeQueryInput {
    /// Consumes the builder and constructs an Operation<[`DescribeQuery`](crate::operation::DescribeQuery)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeQuery,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DescribeQueryInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DescribeQueryInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "CloudTrail_20131101.DescribeQuery",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_describe_query(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeQuery::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeQuery",
            "cloudtrail",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DescribeQueryInput`](crate::input::DescribeQueryInput)
    pub fn builder() -> crate::input::describe_query_input::Builder {
        crate::input::describe_query_input::Builder::default()
    }
}

/// See [`DescribeTrailsInput`](crate::input::DescribeTrailsInput)
pub mod describe_trails_input {
    /// A builder for [`DescribeTrailsInput`](crate::input::DescribeTrailsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) trail_name_list: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) include_shadow_trails: std::option::Option<bool>,
    }
    impl Builder {
        /// Appends an item to `trail_name_list`.
        ///
        /// To override the contents of this collection use [`set_trail_name_list`](Self::set_trail_name_list).
        ///
        /// <p>Specifies a list of trail names, trail ARNs, or both, of the trails to describe. The format of a trail ARN is:</p>
        /// <p> <code>arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail</code> </p>
        /// <p>If an empty list is specified, information for the trail in the current region is returned.</p>
        /// <ul>
        /// <li> <p>If an empty list is specified and <code>IncludeShadowTrails</code> is false, then information for all trails in the current region is returned.</p> </li>
        /// <li> <p>If an empty list is specified and IncludeShadowTrails is null or true, then information for all trails in the current region and any associated shadow trails in other regions is returned.</p> </li>
        /// </ul> <note>
        /// <p>If one or more trail names are specified, information is returned only if the names match the names of trails belonging only to the current region. To return information about a trail in another region, you must specify its trail ARN.</p>
        /// </note>
        pub fn trail_name_list(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.trail_name_list.unwrap_or_default();
            v.push(input.into());
            self.trail_name_list = Some(v);
            self
        }
        /// <p>Specifies a list of trail names, trail ARNs, or both, of the trails to describe. The format of a trail ARN is:</p>
        /// <p> <code>arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail</code> </p>
        /// <p>If an empty list is specified, information for the trail in the current region is returned.</p>
        /// <ul>
        /// <li> <p>If an empty list is specified and <code>IncludeShadowTrails</code> is false, then information for all trails in the current region is returned.</p> </li>
        /// <li> <p>If an empty list is specified and IncludeShadowTrails is null or true, then information for all trails in the current region and any associated shadow trails in other regions is returned.</p> </li>
        /// </ul> <note>
        /// <p>If one or more trail names are specified, information is returned only if the names match the names of trails belonging only to the current region. To return information about a trail in another region, you must specify its trail ARN.</p>
        /// </note>
        pub fn set_trail_name_list(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.trail_name_list = input;
            self
        }
        /// <p>Specifies whether to include shadow trails in the response. A shadow trail is the replication in a region of a trail that was created in a different region, or in the case of an organization trail, the replication of an organization trail in member accounts. If you do not include shadow trails, organization trails in a member account and region replication trails will not be returned. The default is true.</p>
        pub fn include_shadow_trails(mut self, input: bool) -> Self {
            self.include_shadow_trails = Some(input);
            self
        }
        /// <p>Specifies whether to include shadow trails in the response. A shadow trail is the replication in a region of a trail that was created in a different region, or in the case of an organization trail, the replication of an organization trail in member accounts. If you do not include shadow trails, organization trails in a member account and region replication trails will not be returned. The default is true.</p>
        pub fn set_include_shadow_trails(mut self, input: std::option::Option<bool>) -> Self {
            self.include_shadow_trails = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeTrailsInput`](crate::input::DescribeTrailsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeTrailsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeTrailsInput {
                trail_name_list: self.trail_name_list,
                include_shadow_trails: self.include_shadow_trails,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeTrailsInputOperationOutputAlias = crate::operation::DescribeTrails;
#[doc(hidden)]
pub type DescribeTrailsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeTrailsInput {
    /// Consumes the builder and constructs an Operation<[`DescribeTrails`](crate::operation::DescribeTrails)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeTrails,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DescribeTrailsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DescribeTrailsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "CloudTrail_20131101.DescribeTrails",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_describe_trails(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeTrails::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeTrails",
            "cloudtrail",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DescribeTrailsInput`](crate::input::DescribeTrailsInput)
    pub fn builder() -> crate::input::describe_trails_input::Builder {
        crate::input::describe_trails_input::Builder::default()
    }
}

/// See [`GetEventDataStoreInput`](crate::input::GetEventDataStoreInput)
pub mod get_event_data_store_input {
    /// A builder for [`GetEventDataStoreInput`](crate::input::GetEventDataStoreInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) event_data_store: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN (or ID suffix of the ARN) of the event data store about which you want information.</p>
        pub fn event_data_store(mut self, input: impl Into<std::string::String>) -> Self {
            self.event_data_store = Some(input.into());
            self
        }
        /// <p>The ARN (or ID suffix of the ARN) of the event data store about which you want information.</p>
        pub fn set_event_data_store(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.event_data_store = input;
            self
        }
        /// Consumes the builder and constructs a [`GetEventDataStoreInput`](crate::input::GetEventDataStoreInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetEventDataStoreInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetEventDataStoreInput {
                event_data_store: self.event_data_store,
            })
        }
    }
}
#[doc(hidden)]
pub type GetEventDataStoreInputOperationOutputAlias = crate::operation::GetEventDataStore;
#[doc(hidden)]
pub type GetEventDataStoreInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetEventDataStoreInput {
    /// Consumes the builder and constructs an Operation<[`GetEventDataStore`](crate::operation::GetEventDataStore)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetEventDataStore,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetEventDataStoreInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetEventDataStoreInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "CloudTrail_20131101.GetEventDataStore",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_get_event_data_store(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetEventDataStore::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetEventDataStore",
            "cloudtrail",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetEventDataStoreInput`](crate::input::GetEventDataStoreInput)
    pub fn builder() -> crate::input::get_event_data_store_input::Builder {
        crate::input::get_event_data_store_input::Builder::default()
    }
}

/// See [`GetEventSelectorsInput`](crate::input::GetEventSelectorsInput)
pub mod get_event_selectors_input {
    /// A builder for [`GetEventSelectorsInput`](crate::input::GetEventSelectorsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) trail_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Specifies the name of the trail or trail ARN. If you specify a trail name, the string must meet the following requirements:</p>
        /// <ul>
        /// <li> <p>Contain only ASCII letters (a-z, A-Z), numbers (0-9), periods (.), underscores (_), or dashes (-)</p> </li>
        /// <li> <p>Start with a letter or number, and end with a letter or number</p> </li>
        /// <li> <p>Be between 3 and 128 characters</p> </li>
        /// <li> <p>Have no adjacent periods, underscores or dashes. Names like <code>my-_namespace</code> and <code>my--namespace</code> are not valid.</p> </li>
        /// <li> <p>Not be in IP address format (for example, 192.168.5.4)</p> </li>
        /// </ul>
        /// <p>If you specify a trail ARN, it must be in the format:</p>
        /// <p> <code>arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail</code> </p>
        pub fn trail_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.trail_name = Some(input.into());
            self
        }
        /// <p>Specifies the name of the trail or trail ARN. If you specify a trail name, the string must meet the following requirements:</p>
        /// <ul>
        /// <li> <p>Contain only ASCII letters (a-z, A-Z), numbers (0-9), periods (.), underscores (_), or dashes (-)</p> </li>
        /// <li> <p>Start with a letter or number, and end with a letter or number</p> </li>
        /// <li> <p>Be between 3 and 128 characters</p> </li>
        /// <li> <p>Have no adjacent periods, underscores or dashes. Names like <code>my-_namespace</code> and <code>my--namespace</code> are not valid.</p> </li>
        /// <li> <p>Not be in IP address format (for example, 192.168.5.4)</p> </li>
        /// </ul>
        /// <p>If you specify a trail ARN, it must be in the format:</p>
        /// <p> <code>arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail</code> </p>
        pub fn set_trail_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.trail_name = input;
            self
        }
        /// Consumes the builder and constructs a [`GetEventSelectorsInput`](crate::input::GetEventSelectorsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetEventSelectorsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetEventSelectorsInput {
                trail_name: self.trail_name,
            })
        }
    }
}
#[doc(hidden)]
pub type GetEventSelectorsInputOperationOutputAlias = crate::operation::GetEventSelectors;
#[doc(hidden)]
pub type GetEventSelectorsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetEventSelectorsInput {
    /// Consumes the builder and constructs an Operation<[`GetEventSelectors`](crate::operation::GetEventSelectors)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetEventSelectors,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetEventSelectorsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetEventSelectorsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "CloudTrail_20131101.GetEventSelectors",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_get_event_selectors(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetEventSelectors::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetEventSelectors",
            "cloudtrail",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetEventSelectorsInput`](crate::input::GetEventSelectorsInput)
    pub fn builder() -> crate::input::get_event_selectors_input::Builder {
        crate::input::get_event_selectors_input::Builder::default()
    }
}

/// See [`GetInsightSelectorsInput`](crate::input::GetInsightSelectorsInput)
pub mod get_insight_selectors_input {
    /// A builder for [`GetInsightSelectorsInput`](crate::input::GetInsightSelectorsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) trail_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Specifies the name of the trail or trail ARN. If you specify a trail name, the string must meet the following requirements:</p>
        /// <ul>
        /// <li> <p>Contain only ASCII letters (a-z, A-Z), numbers (0-9), periods (.), underscores (_), or dashes (-)</p> </li>
        /// <li> <p>Start with a letter or number, and end with a letter or number</p> </li>
        /// <li> <p>Be between 3 and 128 characters</p> </li>
        /// <li> <p>Have no adjacent periods, underscores or dashes. Names like <code>my-_namespace</code> and <code>my--namespace</code> are not valid.</p> </li>
        /// <li> <p>Not be in IP address format (for example, 192.168.5.4)</p> </li>
        /// </ul>
        /// <p>If you specify a trail ARN, it must be in the format:</p>
        /// <p> <code>arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail</code> </p>
        pub fn trail_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.trail_name = Some(input.into());
            self
        }
        /// <p>Specifies the name of the trail or trail ARN. If you specify a trail name, the string must meet the following requirements:</p>
        /// <ul>
        /// <li> <p>Contain only ASCII letters (a-z, A-Z), numbers (0-9), periods (.), underscores (_), or dashes (-)</p> </li>
        /// <li> <p>Start with a letter or number, and end with a letter or number</p> </li>
        /// <li> <p>Be between 3 and 128 characters</p> </li>
        /// <li> <p>Have no adjacent periods, underscores or dashes. Names like <code>my-_namespace</code> and <code>my--namespace</code> are not valid.</p> </li>
        /// <li> <p>Not be in IP address format (for example, 192.168.5.4)</p> </li>
        /// </ul>
        /// <p>If you specify a trail ARN, it must be in the format:</p>
        /// <p> <code>arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail</code> </p>
        pub fn set_trail_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.trail_name = input;
            self
        }
        /// Consumes the builder and constructs a [`GetInsightSelectorsInput`](crate::input::GetInsightSelectorsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetInsightSelectorsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetInsightSelectorsInput {
                trail_name: self.trail_name,
            })
        }
    }
}
#[doc(hidden)]
pub type GetInsightSelectorsInputOperationOutputAlias = crate::operation::GetInsightSelectors;
#[doc(hidden)]
pub type GetInsightSelectorsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetInsightSelectorsInput {
    /// Consumes the builder and constructs an Operation<[`GetInsightSelectors`](crate::operation::GetInsightSelectors)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetInsightSelectors,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetInsightSelectorsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetInsightSelectorsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "CloudTrail_20131101.GetInsightSelectors",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_get_insight_selectors(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetInsightSelectors::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetInsightSelectors",
            "cloudtrail",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetInsightSelectorsInput`](crate::input::GetInsightSelectorsInput)
    pub fn builder() -> crate::input::get_insight_selectors_input::Builder {
        crate::input::get_insight_selectors_input::Builder::default()
    }
}

/// See [`GetQueryResultsInput`](crate::input::GetQueryResultsInput)
pub mod get_query_results_input {
    /// A builder for [`GetQueryResultsInput`](crate::input::GetQueryResultsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) event_data_store: std::option::Option<std::string::String>,
        pub(crate) query_id: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_query_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The ARN (or ID suffix of the ARN) of the event data store against which the query was run.</p>
        pub fn event_data_store(mut self, input: impl Into<std::string::String>) -> Self {
            self.event_data_store = Some(input.into());
            self
        }
        /// <p>The ARN (or ID suffix of the ARN) of the event data store against which the query was run.</p>
        pub fn set_event_data_store(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.event_data_store = input;
            self
        }
        /// <p>The ID of the query for which you want to get results.</p>
        pub fn query_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.query_id = Some(input.into());
            self
        }
        /// <p>The ID of the query for which you want to get results.</p>
        pub fn set_query_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.query_id = input;
            self
        }
        /// <p>A token you can use to get the next page of query results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A token you can use to get the next page of query results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of query results to display on a single page.</p>
        pub fn max_query_results(mut self, input: i32) -> Self {
            self.max_query_results = Some(input);
            self
        }
        /// <p>The maximum number of query results to display on a single page.</p>
        pub fn set_max_query_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_query_results = input;
            self
        }
        /// Consumes the builder and constructs a [`GetQueryResultsInput`](crate::input::GetQueryResultsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetQueryResultsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetQueryResultsInput {
                event_data_store: self.event_data_store,
                query_id: self.query_id,
                next_token: self.next_token,
                max_query_results: self.max_query_results,
            })
        }
    }
}
#[doc(hidden)]
pub type GetQueryResultsInputOperationOutputAlias = crate::operation::GetQueryResults;
#[doc(hidden)]
pub type GetQueryResultsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetQueryResultsInput {
    /// Consumes the builder and constructs an Operation<[`GetQueryResults`](crate::operation::GetQueryResults)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetQueryResults,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetQueryResultsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetQueryResultsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "CloudTrail_20131101.GetQueryResults",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_get_query_results(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetQueryResults::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetQueryResults",
            "cloudtrail",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetQueryResultsInput`](crate::input::GetQueryResultsInput)
    pub fn builder() -> crate::input::get_query_results_input::Builder {
        crate::input::get_query_results_input::Builder::default()
    }
}

/// See [`GetTrailInput`](crate::input::GetTrailInput)
pub mod get_trail_input {
    /// A builder for [`GetTrailInput`](crate::input::GetTrailInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name or the Amazon Resource Name (ARN) of the trail for which you want to retrieve settings information.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name or the Amazon Resource Name (ARN) of the trail for which you want to retrieve settings information.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Consumes the builder and constructs a [`GetTrailInput`](crate::input::GetTrailInput)
        pub fn build(
            self,
        ) -> std::result::Result<crate::input::GetTrailInput, aws_smithy_http::operation::BuildError>
        {
            Ok(crate::input::GetTrailInput { name: self.name })
        }
    }
}
#[doc(hidden)]
pub type GetTrailInputOperationOutputAlias = crate::operation::GetTrail;
#[doc(hidden)]
pub type GetTrailInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetTrailInput {
    /// Consumes the builder and constructs an Operation<[`GetTrail`](crate::operation::GetTrail)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetTrail,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetTrailInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetTrailInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "CloudTrail_20131101.GetTrail",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_get_trail(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op =
            aws_smithy_http::operation::Operation::new(request, crate::operation::GetTrail::new())
                .with_metadata(aws_smithy_http::operation::Metadata::new(
                    "GetTrail",
                    "cloudtrail",
                ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetTrailInput`](crate::input::GetTrailInput)
    pub fn builder() -> crate::input::get_trail_input::Builder {
        crate::input::get_trail_input::Builder::default()
    }
}

/// See [`GetTrailStatusInput`](crate::input::GetTrailStatusInput)
pub mod get_trail_status_input {
    /// A builder for [`GetTrailStatusInput`](crate::input::GetTrailStatusInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Specifies the name or the CloudTrail ARN of the trail for which you are requesting status. To get the status of a shadow trail (a replication of the trail in another region), you must specify its ARN. The following is the format of a trail ARN.</p>
        /// <p> <code>arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail</code> </p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>Specifies the name or the CloudTrail ARN of the trail for which you are requesting status. To get the status of a shadow trail (a replication of the trail in another region), you must specify its ARN. The following is the format of a trail ARN.</p>
        /// <p> <code>arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail</code> </p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Consumes the builder and constructs a [`GetTrailStatusInput`](crate::input::GetTrailStatusInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetTrailStatusInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetTrailStatusInput { name: self.name })
        }
    }
}
#[doc(hidden)]
pub type GetTrailStatusInputOperationOutputAlias = crate::operation::GetTrailStatus;
#[doc(hidden)]
pub type GetTrailStatusInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetTrailStatusInput {
    /// Consumes the builder and constructs an Operation<[`GetTrailStatus`](crate::operation::GetTrailStatus)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetTrailStatus,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetTrailStatusInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetTrailStatusInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "CloudTrail_20131101.GetTrailStatus",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_get_trail_status(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetTrailStatus::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetTrailStatus",
            "cloudtrail",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetTrailStatusInput`](crate::input::GetTrailStatusInput)
    pub fn builder() -> crate::input::get_trail_status_input::Builder {
        crate::input::get_trail_status_input::Builder::default()
    }
}

/// See [`ListEventDataStoresInput`](crate::input::ListEventDataStoresInput)
pub mod list_event_data_stores_input {
    /// A builder for [`ListEventDataStoresInput`](crate::input::ListEventDataStoresInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>A token you can use to get the next page of event data store results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A token you can use to get the next page of event data store results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of event data stores to display on a single page.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of event data stores to display on a single page.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListEventDataStoresInput`](crate::input::ListEventDataStoresInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListEventDataStoresInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListEventDataStoresInput {
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type ListEventDataStoresInputOperationOutputAlias = crate::operation::ListEventDataStores;
#[doc(hidden)]
pub type ListEventDataStoresInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListEventDataStoresInput {
    /// Consumes the builder and constructs an Operation<[`ListEventDataStores`](crate::operation::ListEventDataStores)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListEventDataStores,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ListEventDataStoresInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ListEventDataStoresInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "CloudTrail_20131101.ListEventDataStores",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_list_event_data_stores(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListEventDataStores::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListEventDataStores",
            "cloudtrail",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ListEventDataStoresInput`](crate::input::ListEventDataStoresInput)
    pub fn builder() -> crate::input::list_event_data_stores_input::Builder {
        crate::input::list_event_data_stores_input::Builder::default()
    }
}

/// See [`ListPublicKeysInput`](crate::input::ListPublicKeysInput)
pub mod list_public_keys_input {
    /// A builder for [`ListPublicKeysInput`](crate::input::ListPublicKeysInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) start_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) end_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Optionally specifies, in UTC, the start of the time range to look up public keys for CloudTrail digest files. If not specified, the current time is used, and the current public key is returned.</p>
        pub fn start_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.start_time = Some(input);
            self
        }
        /// <p>Optionally specifies, in UTC, the start of the time range to look up public keys for CloudTrail digest files. If not specified, the current time is used, and the current public key is returned.</p>
        pub fn set_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.start_time = input;
            self
        }
        /// <p>Optionally specifies, in UTC, the end of the time range to look up public keys for CloudTrail digest files. If not specified, the current time is used.</p>
        pub fn end_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.end_time = Some(input);
            self
        }
        /// <p>Optionally specifies, in UTC, the end of the time range to look up public keys for CloudTrail digest files. If not specified, the current time is used.</p>
        pub fn set_end_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.end_time = input;
            self
        }
        /// <p>Reserved for future use.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>Reserved for future use.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListPublicKeysInput`](crate::input::ListPublicKeysInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListPublicKeysInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListPublicKeysInput {
                start_time: self.start_time,
                end_time: self.end_time,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListPublicKeysInputOperationOutputAlias = crate::operation::ListPublicKeys;
#[doc(hidden)]
pub type ListPublicKeysInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListPublicKeysInput {
    /// Consumes the builder and constructs an Operation<[`ListPublicKeys`](crate::operation::ListPublicKeys)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListPublicKeys,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ListPublicKeysInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ListPublicKeysInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "CloudTrail_20131101.ListPublicKeys",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_list_public_keys(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListPublicKeys::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListPublicKeys",
            "cloudtrail",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ListPublicKeysInput`](crate::input::ListPublicKeysInput)
    pub fn builder() -> crate::input::list_public_keys_input::Builder {
        crate::input::list_public_keys_input::Builder::default()
    }
}

/// See [`ListQueriesInput`](crate::input::ListQueriesInput)
pub mod list_queries_input {
    /// A builder for [`ListQueriesInput`](crate::input::ListQueriesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) event_data_store: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) start_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) end_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) query_status: std::option::Option<crate::model::QueryStatus>,
    }
    impl Builder {
        /// <p>The ARN (or the ID suffix of the ARN) of an event data store on which queries were run.</p>
        pub fn event_data_store(mut self, input: impl Into<std::string::String>) -> Self {
            self.event_data_store = Some(input.into());
            self
        }
        /// <p>The ARN (or the ID suffix of the ARN) of an event data store on which queries were run.</p>
        pub fn set_event_data_store(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.event_data_store = input;
            self
        }
        /// <p>A token you can use to get the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A token you can use to get the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of queries to show on a page.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of queries to show on a page.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>Use with <code>EndTime</code> to bound a <code>ListQueries</code> request, and limit its results to only those queries run within a specified time period.</p>
        pub fn start_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.start_time = Some(input);
            self
        }
        /// <p>Use with <code>EndTime</code> to bound a <code>ListQueries</code> request, and limit its results to only those queries run within a specified time period.</p>
        pub fn set_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.start_time = input;
            self
        }
        /// <p>Use with <code>StartTime</code> to bound a <code>ListQueries</code> request, and limit its results to only those queries run within a specified time period.</p>
        pub fn end_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.end_time = Some(input);
            self
        }
        /// <p>Use with <code>StartTime</code> to bound a <code>ListQueries</code> request, and limit its results to only those queries run within a specified time period.</p>
        pub fn set_end_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.end_time = input;
            self
        }
        /// <p>The status of queries that you want to return in results. Valid values for <code>QueryStatus</code> include <code>QUEUED</code>, <code>RUNNING</code>, <code>FINISHED</code>, <code>FAILED</code>, <code>TIMED_OUT</code>, or <code>CANCELLED</code>.</p>
        pub fn query_status(mut self, input: crate::model::QueryStatus) -> Self {
            self.query_status = Some(input);
            self
        }
        /// <p>The status of queries that you want to return in results. Valid values for <code>QueryStatus</code> include <code>QUEUED</code>, <code>RUNNING</code>, <code>FINISHED</code>, <code>FAILED</code>, <code>TIMED_OUT</code>, or <code>CANCELLED</code>.</p>
        pub fn set_query_status(
            mut self,
            input: std::option::Option<crate::model::QueryStatus>,
        ) -> Self {
            self.query_status = input;
            self
        }
        /// Consumes the builder and constructs a [`ListQueriesInput`](crate::input::ListQueriesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListQueriesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListQueriesInput {
                event_data_store: self.event_data_store,
                next_token: self.next_token,
                max_results: self.max_results,
                start_time: self.start_time,
                end_time: self.end_time,
                query_status: self.query_status,
            })
        }
    }
}
#[doc(hidden)]
pub type ListQueriesInputOperationOutputAlias = crate::operation::ListQueries;
#[doc(hidden)]
pub type ListQueriesInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListQueriesInput {
    /// Consumes the builder and constructs an Operation<[`ListQueries`](crate::operation::ListQueries)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListQueries,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ListQueriesInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ListQueriesInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "CloudTrail_20131101.ListQueries",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_list_queries(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListQueries::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListQueries",
            "cloudtrail",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ListQueriesInput`](crate::input::ListQueriesInput)
    pub fn builder() -> crate::input::list_queries_input::Builder {
        crate::input::list_queries_input::Builder::default()
    }
}

/// See [`ListTagsInput`](crate::input::ListTagsInput)
pub mod list_tags_input {
    /// A builder for [`ListTagsInput`](crate::input::ListTagsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_id_list: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `resource_id_list`.
        ///
        /// To override the contents of this collection use [`set_resource_id_list`](Self::set_resource_id_list).
        ///
        /// <p>Specifies a list of trail and event data store ARNs whose tags will be listed. The list has a limit of 20 ARNs.</p>
        pub fn resource_id_list(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.resource_id_list.unwrap_or_default();
            v.push(input.into());
            self.resource_id_list = Some(v);
            self
        }
        /// <p>Specifies a list of trail and event data store ARNs whose tags will be listed. The list has a limit of 20 ARNs.</p>
        pub fn set_resource_id_list(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.resource_id_list = input;
            self
        }
        /// <p>Reserved for future use.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>Reserved for future use.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTagsInput`](crate::input::ListTagsInput)
        pub fn build(
            self,
        ) -> std::result::Result<crate::input::ListTagsInput, aws_smithy_http::operation::BuildError>
        {
            Ok(crate::input::ListTagsInput {
                resource_id_list: self.resource_id_list,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListTagsInputOperationOutputAlias = crate::operation::ListTags;
#[doc(hidden)]
pub type ListTagsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListTagsInput {
    /// Consumes the builder and constructs an Operation<[`ListTags`](crate::operation::ListTags)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListTags,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ListTagsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ListTagsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "CloudTrail_20131101.ListTags",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_list_tags(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op =
            aws_smithy_http::operation::Operation::new(request, crate::operation::ListTags::new())
                .with_metadata(aws_smithy_http::operation::Metadata::new(
                    "ListTags",
                    "cloudtrail",
                ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ListTagsInput`](crate::input::ListTagsInput)
    pub fn builder() -> crate::input::list_tags_input::Builder {
        crate::input::list_tags_input::Builder::default()
    }
}

/// See [`ListTrailsInput`](crate::input::ListTrailsInput)
pub mod list_trails_input {
    /// A builder for [`ListTrailsInput`](crate::input::ListTrailsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The token to use to get the next page of results after a previous API call. This token must be passed in with the same parameters that were specified in the the original call. For example, if the original call specified an AttributeKey of 'Username' with a value of 'root', the call with NextToken should include those same parameters.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token to use to get the next page of results after a previous API call. This token must be passed in with the same parameters that were specified in the the original call. For example, if the original call specified an AttributeKey of 'Username' with a value of 'root', the call with NextToken should include those same parameters.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTrailsInput`](crate::input::ListTrailsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListTrailsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListTrailsInput {
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListTrailsInputOperationOutputAlias = crate::operation::ListTrails;
#[doc(hidden)]
pub type ListTrailsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListTrailsInput {
    /// Consumes the builder and constructs an Operation<[`ListTrails`](crate::operation::ListTrails)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListTrails,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ListTrailsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ListTrailsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "CloudTrail_20131101.ListTrails",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_list_trails(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListTrails::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListTrails",
            "cloudtrail",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ListTrailsInput`](crate::input::ListTrailsInput)
    pub fn builder() -> crate::input::list_trails_input::Builder {
        crate::input::list_trails_input::Builder::default()
    }
}

/// See [`LookupEventsInput`](crate::input::LookupEventsInput)
pub mod lookup_events_input {
    /// A builder for [`LookupEventsInput`](crate::input::LookupEventsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) lookup_attributes:
            std::option::Option<std::vec::Vec<crate::model::LookupAttribute>>,
        pub(crate) start_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) end_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) event_category: std::option::Option<crate::model::EventCategory>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `lookup_attributes`.
        ///
        /// To override the contents of this collection use [`set_lookup_attributes`](Self::set_lookup_attributes).
        ///
        /// <p>Contains a list of lookup attributes. Currently the list can contain only one item.</p>
        pub fn lookup_attributes(mut self, input: crate::model::LookupAttribute) -> Self {
            let mut v = self.lookup_attributes.unwrap_or_default();
            v.push(input);
            self.lookup_attributes = Some(v);
            self
        }
        /// <p>Contains a list of lookup attributes. Currently the list can contain only one item.</p>
        pub fn set_lookup_attributes(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::LookupAttribute>>,
        ) -> Self {
            self.lookup_attributes = input;
            self
        }
        /// <p>Specifies that only events that occur after or at the specified time are returned. If the specified start time is after the specified end time, an error is returned.</p>
        pub fn start_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.start_time = Some(input);
            self
        }
        /// <p>Specifies that only events that occur after or at the specified time are returned. If the specified start time is after the specified end time, an error is returned.</p>
        pub fn set_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.start_time = input;
            self
        }
        /// <p>Specifies that only events that occur before or at the specified time are returned. If the specified end time is before the specified start time, an error is returned.</p>
        pub fn end_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.end_time = Some(input);
            self
        }
        /// <p>Specifies that only events that occur before or at the specified time are returned. If the specified end time is before the specified start time, an error is returned.</p>
        pub fn set_end_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.end_time = input;
            self
        }
        /// <p>Specifies the event category. If you do not specify an event category, events of the category are not returned in the response. For example, if you do not specify <code>insight</code> as the value of <code>EventCategory</code>, no Insights events are returned.</p>
        pub fn event_category(mut self, input: crate::model::EventCategory) -> Self {
            self.event_category = Some(input);
            self
        }
        /// <p>Specifies the event category. If you do not specify an event category, events of the category are not returned in the response. For example, if you do not specify <code>insight</code> as the value of <code>EventCategory</code>, no Insights events are returned.</p>
        pub fn set_event_category(
            mut self,
            input: std::option::Option<crate::model::EventCategory>,
        ) -> Self {
            self.event_category = input;
            self
        }
        /// <p>The number of events to return. Possible values are 1 through 50. The default is 50.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The number of events to return. Possible values are 1 through 50. The default is 50.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>The token to use to get the next page of results after a previous API call. This token must be passed in with the same parameters that were specified in the the original call. For example, if the original call specified an AttributeKey of 'Username' with a value of 'root', the call with NextToken should include those same parameters.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token to use to get the next page of results after a previous API call. This token must be passed in with the same parameters that were specified in the the original call. For example, if the original call specified an AttributeKey of 'Username' with a value of 'root', the call with NextToken should include those same parameters.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`LookupEventsInput`](crate::input::LookupEventsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::LookupEventsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::LookupEventsInput {
                lookup_attributes: self.lookup_attributes,
                start_time: self.start_time,
                end_time: self.end_time,
                event_category: self.event_category,
                max_results: self.max_results,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type LookupEventsInputOperationOutputAlias = crate::operation::LookupEvents;
#[doc(hidden)]
pub type LookupEventsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl LookupEventsInput {
    /// Consumes the builder and constructs an Operation<[`LookupEvents`](crate::operation::LookupEvents)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::LookupEvents,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::LookupEventsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::LookupEventsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "CloudTrail_20131101.LookupEvents",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_lookup_events(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::LookupEvents::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "LookupEvents",
            "cloudtrail",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`LookupEventsInput`](crate::input::LookupEventsInput)
    pub fn builder() -> crate::input::lookup_events_input::Builder {
        crate::input::lookup_events_input::Builder::default()
    }
}

/// See [`PutEventSelectorsInput`](crate::input::PutEventSelectorsInput)
pub mod put_event_selectors_input {
    /// A builder for [`PutEventSelectorsInput`](crate::input::PutEventSelectorsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) trail_name: std::option::Option<std::string::String>,
        pub(crate) event_selectors: std::option::Option<std::vec::Vec<crate::model::EventSelector>>,
        pub(crate) advanced_event_selectors:
            std::option::Option<std::vec::Vec<crate::model::AdvancedEventSelector>>,
    }
    impl Builder {
        /// <p>Specifies the name of the trail or trail ARN. If you specify a trail name, the string must meet the following requirements:</p>
        /// <ul>
        /// <li> <p>Contain only ASCII letters (a-z, A-Z), numbers (0-9), periods (.), underscores (_), or dashes (-)</p> </li>
        /// <li> <p>Start with a letter or number, and end with a letter or number</p> </li>
        /// <li> <p>Be between 3 and 128 characters</p> </li>
        /// <li> <p>Have no adjacent periods, underscores or dashes. Names like <code>my-_namespace</code> and <code>my--namespace</code> are not valid.</p> </li>
        /// <li> <p>Not be in IP address format (for example, 192.168.5.4)</p> </li>
        /// </ul>
        /// <p>If you specify a trail ARN, it must be in the following format.</p>
        /// <p> <code>arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail</code> </p>
        pub fn trail_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.trail_name = Some(input.into());
            self
        }
        /// <p>Specifies the name of the trail or trail ARN. If you specify a trail name, the string must meet the following requirements:</p>
        /// <ul>
        /// <li> <p>Contain only ASCII letters (a-z, A-Z), numbers (0-9), periods (.), underscores (_), or dashes (-)</p> </li>
        /// <li> <p>Start with a letter or number, and end with a letter or number</p> </li>
        /// <li> <p>Be between 3 and 128 characters</p> </li>
        /// <li> <p>Have no adjacent periods, underscores or dashes. Names like <code>my-_namespace</code> and <code>my--namespace</code> are not valid.</p> </li>
        /// <li> <p>Not be in IP address format (for example, 192.168.5.4)</p> </li>
        /// </ul>
        /// <p>If you specify a trail ARN, it must be in the following format.</p>
        /// <p> <code>arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail</code> </p>
        pub fn set_trail_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.trail_name = input;
            self
        }
        /// Appends an item to `event_selectors`.
        ///
        /// To override the contents of this collection use [`set_event_selectors`](Self::set_event_selectors).
        ///
        /// <p>Specifies the settings for your event selectors. You can configure up to five event selectors for a trail. You can use either <code>EventSelectors</code> or <code>AdvancedEventSelectors</code> in a <code>PutEventSelectors</code> request, but not both. If you apply <code>EventSelectors</code> to a trail, any existing <code>AdvancedEventSelectors</code> are overwritten.</p>
        pub fn event_selectors(mut self, input: crate::model::EventSelector) -> Self {
            let mut v = self.event_selectors.unwrap_or_default();
            v.push(input);
            self.event_selectors = Some(v);
            self
        }
        /// <p>Specifies the settings for your event selectors. You can configure up to five event selectors for a trail. You can use either <code>EventSelectors</code> or <code>AdvancedEventSelectors</code> in a <code>PutEventSelectors</code> request, but not both. If you apply <code>EventSelectors</code> to a trail, any existing <code>AdvancedEventSelectors</code> are overwritten.</p>
        pub fn set_event_selectors(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::EventSelector>>,
        ) -> Self {
            self.event_selectors = input;
            self
        }
        /// Appends an item to `advanced_event_selectors`.
        ///
        /// To override the contents of this collection use [`set_advanced_event_selectors`](Self::set_advanced_event_selectors).
        ///
        /// <p> Specifies the settings for advanced event selectors. You can add advanced event selectors, and conditions for your advanced event selectors, up to a maximum of 500 values for all conditions and selectors on a trail. You can use either <code>AdvancedEventSelectors</code> or <code>EventSelectors</code>, but not both. If you apply <code>AdvancedEventSelectors</code> to a trail, any existing <code>EventSelectors</code> are overwritten. For more information about advanced event selectors, see <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/logging-data-events-with-cloudtrail.html">Logging data events for trails</a> in the <i>CloudTrail User Guide</i>. </p>
        pub fn advanced_event_selectors(
            mut self,
            input: crate::model::AdvancedEventSelector,
        ) -> Self {
            let mut v = self.advanced_event_selectors.unwrap_or_default();
            v.push(input);
            self.advanced_event_selectors = Some(v);
            self
        }
        /// <p> Specifies the settings for advanced event selectors. You can add advanced event selectors, and conditions for your advanced event selectors, up to a maximum of 500 values for all conditions and selectors on a trail. You can use either <code>AdvancedEventSelectors</code> or <code>EventSelectors</code>, but not both. If you apply <code>AdvancedEventSelectors</code> to a trail, any existing <code>EventSelectors</code> are overwritten. For more information about advanced event selectors, see <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/logging-data-events-with-cloudtrail.html">Logging data events for trails</a> in the <i>CloudTrail User Guide</i>. </p>
        pub fn set_advanced_event_selectors(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AdvancedEventSelector>>,
        ) -> Self {
            self.advanced_event_selectors = input;
            self
        }
        /// Consumes the builder and constructs a [`PutEventSelectorsInput`](crate::input::PutEventSelectorsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::PutEventSelectorsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::PutEventSelectorsInput {
                trail_name: self.trail_name,
                event_selectors: self.event_selectors,
                advanced_event_selectors: self.advanced_event_selectors,
            })
        }
    }
}
#[doc(hidden)]
pub type PutEventSelectorsInputOperationOutputAlias = crate::operation::PutEventSelectors;
#[doc(hidden)]
pub type PutEventSelectorsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl PutEventSelectorsInput {
    /// Consumes the builder and constructs an Operation<[`PutEventSelectors`](crate::operation::PutEventSelectors)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::PutEventSelectors,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::PutEventSelectorsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::PutEventSelectorsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "CloudTrail_20131101.PutEventSelectors",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_put_event_selectors(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::PutEventSelectors::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "PutEventSelectors",
            "cloudtrail",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`PutEventSelectorsInput`](crate::input::PutEventSelectorsInput)
    pub fn builder() -> crate::input::put_event_selectors_input::Builder {
        crate::input::put_event_selectors_input::Builder::default()
    }
}

/// See [`PutInsightSelectorsInput`](crate::input::PutInsightSelectorsInput)
pub mod put_insight_selectors_input {
    /// A builder for [`PutInsightSelectorsInput`](crate::input::PutInsightSelectorsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) trail_name: std::option::Option<std::string::String>,
        pub(crate) insight_selectors:
            std::option::Option<std::vec::Vec<crate::model::InsightSelector>>,
    }
    impl Builder {
        /// <p>The name of the CloudTrail trail for which you want to change or add Insights selectors.</p>
        pub fn trail_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.trail_name = Some(input.into());
            self
        }
        /// <p>The name of the CloudTrail trail for which you want to change or add Insights selectors.</p>
        pub fn set_trail_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.trail_name = input;
            self
        }
        /// Appends an item to `insight_selectors`.
        ///
        /// To override the contents of this collection use [`set_insight_selectors`](Self::set_insight_selectors).
        ///
        /// <p>A JSON string that contains the insight types you want to log on a trail. <code>ApiCallRateInsight</code> and <code>ApiErrorRateInsight</code> are valid insight types.</p>
        pub fn insight_selectors(mut self, input: crate::model::InsightSelector) -> Self {
            let mut v = self.insight_selectors.unwrap_or_default();
            v.push(input);
            self.insight_selectors = Some(v);
            self
        }
        /// <p>A JSON string that contains the insight types you want to log on a trail. <code>ApiCallRateInsight</code> and <code>ApiErrorRateInsight</code> are valid insight types.</p>
        pub fn set_insight_selectors(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::InsightSelector>>,
        ) -> Self {
            self.insight_selectors = input;
            self
        }
        /// Consumes the builder and constructs a [`PutInsightSelectorsInput`](crate::input::PutInsightSelectorsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::PutInsightSelectorsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::PutInsightSelectorsInput {
                trail_name: self.trail_name,
                insight_selectors: self.insight_selectors,
            })
        }
    }
}
#[doc(hidden)]
pub type PutInsightSelectorsInputOperationOutputAlias = crate::operation::PutInsightSelectors;
#[doc(hidden)]
pub type PutInsightSelectorsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl PutInsightSelectorsInput {
    /// Consumes the builder and constructs an Operation<[`PutInsightSelectors`](crate::operation::PutInsightSelectors)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::PutInsightSelectors,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::PutInsightSelectorsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::PutInsightSelectorsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "CloudTrail_20131101.PutInsightSelectors",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_put_insight_selectors(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::PutInsightSelectors::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "PutInsightSelectors",
            "cloudtrail",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`PutInsightSelectorsInput`](crate::input::PutInsightSelectorsInput)
    pub fn builder() -> crate::input::put_insight_selectors_input::Builder {
        crate::input::put_insight_selectors_input::Builder::default()
    }
}

/// See [`RemoveTagsInput`](crate::input::RemoveTagsInput)
pub mod remove_tags_input {
    /// A builder for [`RemoveTagsInput`](crate::input::RemoveTagsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_id: std::option::Option<std::string::String>,
        pub(crate) tags_list: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>Specifies the ARN of the trail or event data store from which tags should be removed.</p>
        /// <p> Example trail ARN format: <code>arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail</code> </p>
        /// <p>Example event data store ARN format: <code>arn:aws:cloudtrail:us-east-2:12345678910:eventdatastore/EXAMPLE-f852-4e8f-8bd1-bcf6cEXAMPLE</code> </p>
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_id = Some(input.into());
            self
        }
        /// <p>Specifies the ARN of the trail or event data store from which tags should be removed.</p>
        /// <p> Example trail ARN format: <code>arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail</code> </p>
        /// <p>Example event data store ARN format: <code>arn:aws:cloudtrail:us-east-2:12345678910:eventdatastore/EXAMPLE-f852-4e8f-8bd1-bcf6cEXAMPLE</code> </p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_id = input;
            self
        }
        /// Appends an item to `tags_list`.
        ///
        /// To override the contents of this collection use [`set_tags_list`](Self::set_tags_list).
        ///
        /// <p>Specifies a list of tags to be removed.</p>
        pub fn tags_list(mut self, input: crate::model::Tag) -> Self {
            let mut v = self.tags_list.unwrap_or_default();
            v.push(input);
            self.tags_list = Some(v);
            self
        }
        /// <p>Specifies a list of tags to be removed.</p>
        pub fn set_tags_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags_list = input;
            self
        }
        /// Consumes the builder and constructs a [`RemoveTagsInput`](crate::input::RemoveTagsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::RemoveTagsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::RemoveTagsInput {
                resource_id: self.resource_id,
                tags_list: self.tags_list,
            })
        }
    }
}
#[doc(hidden)]
pub type RemoveTagsInputOperationOutputAlias = crate::operation::RemoveTags;
#[doc(hidden)]
pub type RemoveTagsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl RemoveTagsInput {
    /// Consumes the builder and constructs an Operation<[`RemoveTags`](crate::operation::RemoveTags)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::RemoveTags,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::RemoveTagsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::RemoveTagsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "CloudTrail_20131101.RemoveTags",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_remove_tags(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::RemoveTags::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "RemoveTags",
            "cloudtrail",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`RemoveTagsInput`](crate::input::RemoveTagsInput)
    pub fn builder() -> crate::input::remove_tags_input::Builder {
        crate::input::remove_tags_input::Builder::default()
    }
}

/// See [`RestoreEventDataStoreInput`](crate::input::RestoreEventDataStoreInput)
pub mod restore_event_data_store_input {
    /// A builder for [`RestoreEventDataStoreInput`](crate::input::RestoreEventDataStoreInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) event_data_store: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN (or the ID suffix of the ARN) of the event data store that you want to restore.</p>
        pub fn event_data_store(mut self, input: impl Into<std::string::String>) -> Self {
            self.event_data_store = Some(input.into());
            self
        }
        /// <p>The ARN (or the ID suffix of the ARN) of the event data store that you want to restore.</p>
        pub fn set_event_data_store(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.event_data_store = input;
            self
        }
        /// Consumes the builder and constructs a [`RestoreEventDataStoreInput`](crate::input::RestoreEventDataStoreInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::RestoreEventDataStoreInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::RestoreEventDataStoreInput {
                event_data_store: self.event_data_store,
            })
        }
    }
}
#[doc(hidden)]
pub type RestoreEventDataStoreInputOperationOutputAlias = crate::operation::RestoreEventDataStore;
#[doc(hidden)]
pub type RestoreEventDataStoreInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl RestoreEventDataStoreInput {
    /// Consumes the builder and constructs an Operation<[`RestoreEventDataStore`](crate::operation::RestoreEventDataStore)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::RestoreEventDataStore,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::RestoreEventDataStoreInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::RestoreEventDataStoreInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "CloudTrail_20131101.RestoreEventDataStore",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_restore_event_data_store(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::RestoreEventDataStore::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "RestoreEventDataStore",
            "cloudtrail",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`RestoreEventDataStoreInput`](crate::input::RestoreEventDataStoreInput)
    pub fn builder() -> crate::input::restore_event_data_store_input::Builder {
        crate::input::restore_event_data_store_input::Builder::default()
    }
}

/// See [`StartLoggingInput`](crate::input::StartLoggingInput)
pub mod start_logging_input {
    /// A builder for [`StartLoggingInput`](crate::input::StartLoggingInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Specifies the name or the CloudTrail ARN of the trail for which CloudTrail logs Amazon Web Services API calls. The following is the format of a trail ARN.</p>
        /// <p> <code>arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail</code> </p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>Specifies the name or the CloudTrail ARN of the trail for which CloudTrail logs Amazon Web Services API calls. The following is the format of a trail ARN.</p>
        /// <p> <code>arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail</code> </p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Consumes the builder and constructs a [`StartLoggingInput`](crate::input::StartLoggingInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::StartLoggingInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::StartLoggingInput { name: self.name })
        }
    }
}
#[doc(hidden)]
pub type StartLoggingInputOperationOutputAlias = crate::operation::StartLogging;
#[doc(hidden)]
pub type StartLoggingInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl StartLoggingInput {
    /// Consumes the builder and constructs an Operation<[`StartLogging`](crate::operation::StartLogging)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::StartLogging,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::StartLoggingInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::StartLoggingInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "CloudTrail_20131101.StartLogging",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_start_logging(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::StartLogging::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "StartLogging",
            "cloudtrail",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`StartLoggingInput`](crate::input::StartLoggingInput)
    pub fn builder() -> crate::input::start_logging_input::Builder {
        crate::input::start_logging_input::Builder::default()
    }
}

/// See [`StartQueryInput`](crate::input::StartQueryInput)
pub mod start_query_input {
    /// A builder for [`StartQueryInput`](crate::input::StartQueryInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) query_statement: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The SQL code of your query.</p>
        pub fn query_statement(mut self, input: impl Into<std::string::String>) -> Self {
            self.query_statement = Some(input.into());
            self
        }
        /// <p>The SQL code of your query.</p>
        pub fn set_query_statement(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.query_statement = input;
            self
        }
        /// Consumes the builder and constructs a [`StartQueryInput`](crate::input::StartQueryInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::StartQueryInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::StartQueryInput {
                query_statement: self.query_statement,
            })
        }
    }
}
#[doc(hidden)]
pub type StartQueryInputOperationOutputAlias = crate::operation::StartQuery;
#[doc(hidden)]
pub type StartQueryInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl StartQueryInput {
    /// Consumes the builder and constructs an Operation<[`StartQuery`](crate::operation::StartQuery)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::StartQuery,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::StartQueryInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::StartQueryInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "CloudTrail_20131101.StartQuery",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_start_query(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::StartQuery::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "StartQuery",
            "cloudtrail",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`StartQueryInput`](crate::input::StartQueryInput)
    pub fn builder() -> crate::input::start_query_input::Builder {
        crate::input::start_query_input::Builder::default()
    }
}

/// See [`StopLoggingInput`](crate::input::StopLoggingInput)
pub mod stop_logging_input {
    /// A builder for [`StopLoggingInput`](crate::input::StopLoggingInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Specifies the name or the CloudTrail ARN of the trail for which CloudTrail will stop logging Amazon Web Services API calls. The following is the format of a trail ARN.</p>
        /// <p> <code>arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail</code> </p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>Specifies the name or the CloudTrail ARN of the trail for which CloudTrail will stop logging Amazon Web Services API calls. The following is the format of a trail ARN.</p>
        /// <p> <code>arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail</code> </p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Consumes the builder and constructs a [`StopLoggingInput`](crate::input::StopLoggingInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::StopLoggingInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::StopLoggingInput { name: self.name })
        }
    }
}
#[doc(hidden)]
pub type StopLoggingInputOperationOutputAlias = crate::operation::StopLogging;
#[doc(hidden)]
pub type StopLoggingInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl StopLoggingInput {
    /// Consumes the builder and constructs an Operation<[`StopLogging`](crate::operation::StopLogging)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::StopLogging,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::StopLoggingInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::StopLoggingInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "CloudTrail_20131101.StopLogging",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_stop_logging(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::StopLogging::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "StopLogging",
            "cloudtrail",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`StopLoggingInput`](crate::input::StopLoggingInput)
    pub fn builder() -> crate::input::stop_logging_input::Builder {
        crate::input::stop_logging_input::Builder::default()
    }
}

/// See [`UpdateEventDataStoreInput`](crate::input::UpdateEventDataStoreInput)
pub mod update_event_data_store_input {
    /// A builder for [`UpdateEventDataStoreInput`](crate::input::UpdateEventDataStoreInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) event_data_store: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) advanced_event_selectors:
            std::option::Option<std::vec::Vec<crate::model::AdvancedEventSelector>>,
        pub(crate) multi_region_enabled: std::option::Option<bool>,
        pub(crate) organization_enabled: std::option::Option<bool>,
        pub(crate) retention_period: std::option::Option<i32>,
        pub(crate) termination_protection_enabled: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The ARN (or the ID suffix of the ARN) of the event data store that you want to update.</p>
        pub fn event_data_store(mut self, input: impl Into<std::string::String>) -> Self {
            self.event_data_store = Some(input.into());
            self
        }
        /// <p>The ARN (or the ID suffix of the ARN) of the event data store that you want to update.</p>
        pub fn set_event_data_store(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.event_data_store = input;
            self
        }
        /// <p>The event data store name.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The event data store name.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Appends an item to `advanced_event_selectors`.
        ///
        /// To override the contents of this collection use [`set_advanced_event_selectors`](Self::set_advanced_event_selectors).
        ///
        /// <p>The advanced event selectors used to select events for the event data store.</p>
        pub fn advanced_event_selectors(
            mut self,
            input: crate::model::AdvancedEventSelector,
        ) -> Self {
            let mut v = self.advanced_event_selectors.unwrap_or_default();
            v.push(input);
            self.advanced_event_selectors = Some(v);
            self
        }
        /// <p>The advanced event selectors used to select events for the event data store.</p>
        pub fn set_advanced_event_selectors(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AdvancedEventSelector>>,
        ) -> Self {
            self.advanced_event_selectors = input;
            self
        }
        /// <p>Specifies whether an event data store collects events from all regions, or only from the region in which it was created.</p>
        pub fn multi_region_enabled(mut self, input: bool) -> Self {
            self.multi_region_enabled = Some(input);
            self
        }
        /// <p>Specifies whether an event data store collects events from all regions, or only from the region in which it was created.</p>
        pub fn set_multi_region_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.multi_region_enabled = input;
            self
        }
        /// <p>Specifies whether an event data store collects events logged for an organization in Organizations.</p>
        pub fn organization_enabled(mut self, input: bool) -> Self {
            self.organization_enabled = Some(input);
            self
        }
        /// <p>Specifies whether an event data store collects events logged for an organization in Organizations.</p>
        pub fn set_organization_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.organization_enabled = input;
            self
        }
        /// <p>The retention period, in days.</p>
        pub fn retention_period(mut self, input: i32) -> Self {
            self.retention_period = Some(input);
            self
        }
        /// <p>The retention period, in days.</p>
        pub fn set_retention_period(mut self, input: std::option::Option<i32>) -> Self {
            self.retention_period = input;
            self
        }
        /// <p>Indicates that termination protection is enabled and the event data store cannot be automatically deleted.</p>
        pub fn termination_protection_enabled(mut self, input: bool) -> Self {
            self.termination_protection_enabled = Some(input);
            self
        }
        /// <p>Indicates that termination protection is enabled and the event data store cannot be automatically deleted.</p>
        pub fn set_termination_protection_enabled(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.termination_protection_enabled = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateEventDataStoreInput`](crate::input::UpdateEventDataStoreInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateEventDataStoreInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateEventDataStoreInput {
                event_data_store: self.event_data_store,
                name: self.name,
                advanced_event_selectors: self.advanced_event_selectors,
                multi_region_enabled: self.multi_region_enabled,
                organization_enabled: self.organization_enabled,
                retention_period: self.retention_period,
                termination_protection_enabled: self.termination_protection_enabled,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateEventDataStoreInputOperationOutputAlias = crate::operation::UpdateEventDataStore;
#[doc(hidden)]
pub type UpdateEventDataStoreInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdateEventDataStoreInput {
    /// Consumes the builder and constructs an Operation<[`UpdateEventDataStore`](crate::operation::UpdateEventDataStore)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateEventDataStore,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::UpdateEventDataStoreInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::UpdateEventDataStoreInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "CloudTrail_20131101.UpdateEventDataStore",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_update_event_data_store(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateEventDataStore::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateEventDataStore",
            "cloudtrail",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`UpdateEventDataStoreInput`](crate::input::UpdateEventDataStoreInput)
    pub fn builder() -> crate::input::update_event_data_store_input::Builder {
        crate::input::update_event_data_store_input::Builder::default()
    }
}

/// See [`UpdateTrailInput`](crate::input::UpdateTrailInput)
pub mod update_trail_input {
    /// A builder for [`UpdateTrailInput`](crate::input::UpdateTrailInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) s3_bucket_name: std::option::Option<std::string::String>,
        pub(crate) s3_key_prefix: std::option::Option<std::string::String>,
        pub(crate) sns_topic_name: std::option::Option<std::string::String>,
        pub(crate) include_global_service_events: std::option::Option<bool>,
        pub(crate) is_multi_region_trail: std::option::Option<bool>,
        pub(crate) enable_log_file_validation: std::option::Option<bool>,
        pub(crate) cloud_watch_logs_log_group_arn: std::option::Option<std::string::String>,
        pub(crate) cloud_watch_logs_role_arn: std::option::Option<std::string::String>,
        pub(crate) kms_key_id: std::option::Option<std::string::String>,
        pub(crate) is_organization_trail: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>Specifies the name of the trail or trail ARN. If <code>Name</code> is a trail name, the string must meet the following requirements:</p>
        /// <ul>
        /// <li> <p>Contain only ASCII letters (a-z, A-Z), numbers (0-9), periods (.), underscores (_), or dashes (-)</p> </li>
        /// <li> <p>Start with a letter or number, and end with a letter or number</p> </li>
        /// <li> <p>Be between 3 and 128 characters</p> </li>
        /// <li> <p>Have no adjacent periods, underscores or dashes. Names like <code>my-_namespace</code> and <code>my--namespace</code> are not valid.</p> </li>
        /// <li> <p>Not be in IP address format (for example, 192.168.5.4)</p> </li>
        /// </ul>
        /// <p>If <code>Name</code> is a trail ARN, it must be in the following format.</p>
        /// <p> <code>arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail</code> </p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>Specifies the name of the trail or trail ARN. If <code>Name</code> is a trail name, the string must meet the following requirements:</p>
        /// <ul>
        /// <li> <p>Contain only ASCII letters (a-z, A-Z), numbers (0-9), periods (.), underscores (_), or dashes (-)</p> </li>
        /// <li> <p>Start with a letter or number, and end with a letter or number</p> </li>
        /// <li> <p>Be between 3 and 128 characters</p> </li>
        /// <li> <p>Have no adjacent periods, underscores or dashes. Names like <code>my-_namespace</code> and <code>my--namespace</code> are not valid.</p> </li>
        /// <li> <p>Not be in IP address format (for example, 192.168.5.4)</p> </li>
        /// </ul>
        /// <p>If <code>Name</code> is a trail ARN, it must be in the following format.</p>
        /// <p> <code>arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail</code> </p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>Specifies the name of the Amazon S3 bucket designated for publishing log files. See <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/create_trail_naming_policy.html">Amazon S3 Bucket Naming Requirements</a>.</p>
        pub fn s3_bucket_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.s3_bucket_name = Some(input.into());
            self
        }
        /// <p>Specifies the name of the Amazon S3 bucket designated for publishing log files. See <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/create_trail_naming_policy.html">Amazon S3 Bucket Naming Requirements</a>.</p>
        pub fn set_s3_bucket_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.s3_bucket_name = input;
            self
        }
        /// <p>Specifies the Amazon S3 key prefix that comes after the name of the bucket you have designated for log file delivery. For more information, see <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/cloudtrail-find-log-files.html">Finding Your CloudTrail Log Files</a>. The maximum length is 200 characters.</p>
        pub fn s3_key_prefix(mut self, input: impl Into<std::string::String>) -> Self {
            self.s3_key_prefix = Some(input.into());
            self
        }
        /// <p>Specifies the Amazon S3 key prefix that comes after the name of the bucket you have designated for log file delivery. For more information, see <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/cloudtrail-find-log-files.html">Finding Your CloudTrail Log Files</a>. The maximum length is 200 characters.</p>
        pub fn set_s3_key_prefix(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.s3_key_prefix = input;
            self
        }
        /// <p>Specifies the name of the Amazon SNS topic defined for notification of log file delivery. The maximum length is 256 characters.</p>
        pub fn sns_topic_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.sns_topic_name = Some(input.into());
            self
        }
        /// <p>Specifies the name of the Amazon SNS topic defined for notification of log file delivery. The maximum length is 256 characters.</p>
        pub fn set_sns_topic_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.sns_topic_name = input;
            self
        }
        /// <p>Specifies whether the trail is publishing events from global services such as IAM to the log files.</p>
        pub fn include_global_service_events(mut self, input: bool) -> Self {
            self.include_global_service_events = Some(input);
            self
        }
        /// <p>Specifies whether the trail is publishing events from global services such as IAM to the log files.</p>
        pub fn set_include_global_service_events(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.include_global_service_events = input;
            self
        }
        /// <p>Specifies whether the trail applies only to the current region or to all regions. The default is false. If the trail exists only in the current region and this value is set to true, shadow trails (replications of the trail) will be created in the other regions. If the trail exists in all regions and this value is set to false, the trail will remain in the region where it was created, and its shadow trails in other regions will be deleted. As a best practice, consider using trails that log events in all regions.</p>
        pub fn is_multi_region_trail(mut self, input: bool) -> Self {
            self.is_multi_region_trail = Some(input);
            self
        }
        /// <p>Specifies whether the trail applies only to the current region or to all regions. The default is false. If the trail exists only in the current region and this value is set to true, shadow trails (replications of the trail) will be created in the other regions. If the trail exists in all regions and this value is set to false, the trail will remain in the region where it was created, and its shadow trails in other regions will be deleted. As a best practice, consider using trails that log events in all regions.</p>
        pub fn set_is_multi_region_trail(mut self, input: std::option::Option<bool>) -> Self {
            self.is_multi_region_trail = input;
            self
        }
        /// <p>Specifies whether log file validation is enabled. The default is false.</p> <note>
        /// <p>When you disable log file integrity validation, the chain of digest files is broken after one hour. CloudTrail does not create digest files for log files that were delivered during a period in which log file integrity validation was disabled. For example, if you enable log file integrity validation at noon on January 1, disable it at noon on January 2, and re-enable it at noon on January 10, digest files will not be created for the log files delivered from noon on January 2 to noon on January 10. The same applies whenever you stop CloudTrail logging or delete a trail.</p>
        /// </note>
        pub fn enable_log_file_validation(mut self, input: bool) -> Self {
            self.enable_log_file_validation = Some(input);
            self
        }
        /// <p>Specifies whether log file validation is enabled. The default is false.</p> <note>
        /// <p>When you disable log file integrity validation, the chain of digest files is broken after one hour. CloudTrail does not create digest files for log files that were delivered during a period in which log file integrity validation was disabled. For example, if you enable log file integrity validation at noon on January 1, disable it at noon on January 2, and re-enable it at noon on January 10, digest files will not be created for the log files delivered from noon on January 2 to noon on January 10. The same applies whenever you stop CloudTrail logging or delete a trail.</p>
        /// </note>
        pub fn set_enable_log_file_validation(mut self, input: std::option::Option<bool>) -> Self {
            self.enable_log_file_validation = input;
            self
        }
        /// <p>Specifies a log group name using an Amazon Resource Name (ARN), a unique identifier that represents the log group to which CloudTrail logs are delivered. Not required unless you specify <code>CloudWatchLogsRoleArn</code>.</p>
        pub fn cloud_watch_logs_log_group_arn(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.cloud_watch_logs_log_group_arn = Some(input.into());
            self
        }
        /// <p>Specifies a log group name using an Amazon Resource Name (ARN), a unique identifier that represents the log group to which CloudTrail logs are delivered. Not required unless you specify <code>CloudWatchLogsRoleArn</code>.</p>
        pub fn set_cloud_watch_logs_log_group_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.cloud_watch_logs_log_group_arn = input;
            self
        }
        /// <p>Specifies the role for the CloudWatch Logs endpoint to assume to write to a user's log group.</p>
        pub fn cloud_watch_logs_role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.cloud_watch_logs_role_arn = Some(input.into());
            self
        }
        /// <p>Specifies the role for the CloudWatch Logs endpoint to assume to write to a user's log group.</p>
        pub fn set_cloud_watch_logs_role_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.cloud_watch_logs_role_arn = input;
            self
        }
        /// <p>Specifies the KMS key ID to use to encrypt the logs delivered by CloudTrail. The value can be an alias name prefixed by "alias/", a fully specified ARN to an alias, a fully specified ARN to a key, or a globally unique identifier.</p>
        /// <p>CloudTrail also supports KMS multi-Region keys. For more information about multi-Region keys, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/multi-region-keys-overview.html">Using multi-Region keys</a> in the <i>Key Management Service Developer Guide</i>.</p>
        /// <p>Examples:</p>
        /// <ul>
        /// <li> <p>alias/MyAliasName</p> </li>
        /// <li> <p>arn:aws:kms:us-east-2:123456789012:alias/MyAliasName</p> </li>
        /// <li> <p>arn:aws:kms:us-east-2:123456789012:key/12345678-1234-1234-1234-123456789012</p> </li>
        /// <li> <p>12345678-1234-1234-1234-123456789012</p> </li>
        /// </ul>
        pub fn kms_key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.kms_key_id = Some(input.into());
            self
        }
        /// <p>Specifies the KMS key ID to use to encrypt the logs delivered by CloudTrail. The value can be an alias name prefixed by "alias/", a fully specified ARN to an alias, a fully specified ARN to a key, or a globally unique identifier.</p>
        /// <p>CloudTrail also supports KMS multi-Region keys. For more information about multi-Region keys, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/multi-region-keys-overview.html">Using multi-Region keys</a> in the <i>Key Management Service Developer Guide</i>.</p>
        /// <p>Examples:</p>
        /// <ul>
        /// <li> <p>alias/MyAliasName</p> </li>
        /// <li> <p>arn:aws:kms:us-east-2:123456789012:alias/MyAliasName</p> </li>
        /// <li> <p>arn:aws:kms:us-east-2:123456789012:key/12345678-1234-1234-1234-123456789012</p> </li>
        /// <li> <p>12345678-1234-1234-1234-123456789012</p> </li>
        /// </ul>
        pub fn set_kms_key_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.kms_key_id = input;
            self
        }
        /// <p>Specifies whether the trail is applied to all accounts in an organization in Organizations, or only for the current Amazon Web Services account. The default is false, and cannot be true unless the call is made on behalf of an Amazon Web Services account that is the management account for an organization in Organizations. If the trail is not an organization trail and this is set to <code>true</code>, the trail will be created in all Amazon Web Services accounts that belong to the organization. If the trail is an organization trail and this is set to <code>false</code>, the trail will remain in the current Amazon Web Services account but be deleted from all member accounts in the organization.</p>
        pub fn is_organization_trail(mut self, input: bool) -> Self {
            self.is_organization_trail = Some(input);
            self
        }
        /// <p>Specifies whether the trail is applied to all accounts in an organization in Organizations, or only for the current Amazon Web Services account. The default is false, and cannot be true unless the call is made on behalf of an Amazon Web Services account that is the management account for an organization in Organizations. If the trail is not an organization trail and this is set to <code>true</code>, the trail will be created in all Amazon Web Services accounts that belong to the organization. If the trail is an organization trail and this is set to <code>false</code>, the trail will remain in the current Amazon Web Services account but be deleted from all member accounts in the organization.</p>
        pub fn set_is_organization_trail(mut self, input: std::option::Option<bool>) -> Self {
            self.is_organization_trail = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateTrailInput`](crate::input::UpdateTrailInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateTrailInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateTrailInput {
                name: self.name,
                s3_bucket_name: self.s3_bucket_name,
                s3_key_prefix: self.s3_key_prefix,
                sns_topic_name: self.sns_topic_name,
                include_global_service_events: self.include_global_service_events,
                is_multi_region_trail: self.is_multi_region_trail,
                enable_log_file_validation: self.enable_log_file_validation,
                cloud_watch_logs_log_group_arn: self.cloud_watch_logs_log_group_arn,
                cloud_watch_logs_role_arn: self.cloud_watch_logs_role_arn,
                kms_key_id: self.kms_key_id,
                is_organization_trail: self.is_organization_trail,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateTrailInputOperationOutputAlias = crate::operation::UpdateTrail;
#[doc(hidden)]
pub type UpdateTrailInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdateTrailInput {
    /// Consumes the builder and constructs an Operation<[`UpdateTrail`](crate::operation::UpdateTrail)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateTrail,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::UpdateTrailInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::UpdateTrailInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "CloudTrail_20131101.UpdateTrail",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_update_trail(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateTrail::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateTrail",
            "cloudtrail",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`UpdateTrailInput`](crate::input::UpdateTrailInput)
    pub fn builder() -> crate::input::update_trail_input::Builder {
        crate::input::update_trail_input::Builder::default()
    }
}

/// <p>Specifies settings to update for the trail.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateTrailInput {
    /// <p>Specifies the name of the trail or trail ARN. If <code>Name</code> is a trail name, the string must meet the following requirements:</p>
    /// <ul>
    /// <li> <p>Contain only ASCII letters (a-z, A-Z), numbers (0-9), periods (.), underscores (_), or dashes (-)</p> </li>
    /// <li> <p>Start with a letter or number, and end with a letter or number</p> </li>
    /// <li> <p>Be between 3 and 128 characters</p> </li>
    /// <li> <p>Have no adjacent periods, underscores or dashes. Names like <code>my-_namespace</code> and <code>my--namespace</code> are not valid.</p> </li>
    /// <li> <p>Not be in IP address format (for example, 192.168.5.4)</p> </li>
    /// </ul>
    /// <p>If <code>Name</code> is a trail ARN, it must be in the following format.</p>
    /// <p> <code>arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail</code> </p>
    pub name: std::option::Option<std::string::String>,
    /// <p>Specifies the name of the Amazon S3 bucket designated for publishing log files. See <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/create_trail_naming_policy.html">Amazon S3 Bucket Naming Requirements</a>.</p>
    pub s3_bucket_name: std::option::Option<std::string::String>,
    /// <p>Specifies the Amazon S3 key prefix that comes after the name of the bucket you have designated for log file delivery. For more information, see <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/cloudtrail-find-log-files.html">Finding Your CloudTrail Log Files</a>. The maximum length is 200 characters.</p>
    pub s3_key_prefix: std::option::Option<std::string::String>,
    /// <p>Specifies the name of the Amazon SNS topic defined for notification of log file delivery. The maximum length is 256 characters.</p>
    pub sns_topic_name: std::option::Option<std::string::String>,
    /// <p>Specifies whether the trail is publishing events from global services such as IAM to the log files.</p>
    pub include_global_service_events: std::option::Option<bool>,
    /// <p>Specifies whether the trail applies only to the current region or to all regions. The default is false. If the trail exists only in the current region and this value is set to true, shadow trails (replications of the trail) will be created in the other regions. If the trail exists in all regions and this value is set to false, the trail will remain in the region where it was created, and its shadow trails in other regions will be deleted. As a best practice, consider using trails that log events in all regions.</p>
    pub is_multi_region_trail: std::option::Option<bool>,
    /// <p>Specifies whether log file validation is enabled. The default is false.</p> <note>
    /// <p>When you disable log file integrity validation, the chain of digest files is broken after one hour. CloudTrail does not create digest files for log files that were delivered during a period in which log file integrity validation was disabled. For example, if you enable log file integrity validation at noon on January 1, disable it at noon on January 2, and re-enable it at noon on January 10, digest files will not be created for the log files delivered from noon on January 2 to noon on January 10. The same applies whenever you stop CloudTrail logging or delete a trail.</p>
    /// </note>
    pub enable_log_file_validation: std::option::Option<bool>,
    /// <p>Specifies a log group name using an Amazon Resource Name (ARN), a unique identifier that represents the log group to which CloudTrail logs are delivered. Not required unless you specify <code>CloudWatchLogsRoleArn</code>.</p>
    pub cloud_watch_logs_log_group_arn: std::option::Option<std::string::String>,
    /// <p>Specifies the role for the CloudWatch Logs endpoint to assume to write to a user's log group.</p>
    pub cloud_watch_logs_role_arn: std::option::Option<std::string::String>,
    /// <p>Specifies the KMS key ID to use to encrypt the logs delivered by CloudTrail. The value can be an alias name prefixed by "alias/", a fully specified ARN to an alias, a fully specified ARN to a key, or a globally unique identifier.</p>
    /// <p>CloudTrail also supports KMS multi-Region keys. For more information about multi-Region keys, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/multi-region-keys-overview.html">Using multi-Region keys</a> in the <i>Key Management Service Developer Guide</i>.</p>
    /// <p>Examples:</p>
    /// <ul>
    /// <li> <p>alias/MyAliasName</p> </li>
    /// <li> <p>arn:aws:kms:us-east-2:123456789012:alias/MyAliasName</p> </li>
    /// <li> <p>arn:aws:kms:us-east-2:123456789012:key/12345678-1234-1234-1234-123456789012</p> </li>
    /// <li> <p>12345678-1234-1234-1234-123456789012</p> </li>
    /// </ul>
    pub kms_key_id: std::option::Option<std::string::String>,
    /// <p>Specifies whether the trail is applied to all accounts in an organization in Organizations, or only for the current Amazon Web Services account. The default is false, and cannot be true unless the call is made on behalf of an Amazon Web Services account that is the management account for an organization in Organizations. If the trail is not an organization trail and this is set to <code>true</code>, the trail will be created in all Amazon Web Services accounts that belong to the organization. If the trail is an organization trail and this is set to <code>false</code>, the trail will remain in the current Amazon Web Services account but be deleted from all member accounts in the organization.</p>
    pub is_organization_trail: std::option::Option<bool>,
}
impl UpdateTrailInput {
    /// <p>Specifies the name of the trail or trail ARN. If <code>Name</code> is a trail name, the string must meet the following requirements:</p>
    /// <ul>
    /// <li> <p>Contain only ASCII letters (a-z, A-Z), numbers (0-9), periods (.), underscores (_), or dashes (-)</p> </li>
    /// <li> <p>Start with a letter or number, and end with a letter or number</p> </li>
    /// <li> <p>Be between 3 and 128 characters</p> </li>
    /// <li> <p>Have no adjacent periods, underscores or dashes. Names like <code>my-_namespace</code> and <code>my--namespace</code> are not valid.</p> </li>
    /// <li> <p>Not be in IP address format (for example, 192.168.5.4)</p> </li>
    /// </ul>
    /// <p>If <code>Name</code> is a trail ARN, it must be in the following format.</p>
    /// <p> <code>arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail</code> </p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>Specifies the name of the Amazon S3 bucket designated for publishing log files. See <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/create_trail_naming_policy.html">Amazon S3 Bucket Naming Requirements</a>.</p>
    pub fn s3_bucket_name(&self) -> std::option::Option<&str> {
        self.s3_bucket_name.as_deref()
    }
    /// <p>Specifies the Amazon S3 key prefix that comes after the name of the bucket you have designated for log file delivery. For more information, see <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/cloudtrail-find-log-files.html">Finding Your CloudTrail Log Files</a>. The maximum length is 200 characters.</p>
    pub fn s3_key_prefix(&self) -> std::option::Option<&str> {
        self.s3_key_prefix.as_deref()
    }
    /// <p>Specifies the name of the Amazon SNS topic defined for notification of log file delivery. The maximum length is 256 characters.</p>
    pub fn sns_topic_name(&self) -> std::option::Option<&str> {
        self.sns_topic_name.as_deref()
    }
    /// <p>Specifies whether the trail is publishing events from global services such as IAM to the log files.</p>
    pub fn include_global_service_events(&self) -> std::option::Option<bool> {
        self.include_global_service_events
    }
    /// <p>Specifies whether the trail applies only to the current region or to all regions. The default is false. If the trail exists only in the current region and this value is set to true, shadow trails (replications of the trail) will be created in the other regions. If the trail exists in all regions and this value is set to false, the trail will remain in the region where it was created, and its shadow trails in other regions will be deleted. As a best practice, consider using trails that log events in all regions.</p>
    pub fn is_multi_region_trail(&self) -> std::option::Option<bool> {
        self.is_multi_region_trail
    }
    /// <p>Specifies whether log file validation is enabled. The default is false.</p> <note>
    /// <p>When you disable log file integrity validation, the chain of digest files is broken after one hour. CloudTrail does not create digest files for log files that were delivered during a period in which log file integrity validation was disabled. For example, if you enable log file integrity validation at noon on January 1, disable it at noon on January 2, and re-enable it at noon on January 10, digest files will not be created for the log files delivered from noon on January 2 to noon on January 10. The same applies whenever you stop CloudTrail logging or delete a trail.</p>
    /// </note>
    pub fn enable_log_file_validation(&self) -> std::option::Option<bool> {
        self.enable_log_file_validation
    }
    /// <p>Specifies a log group name using an Amazon Resource Name (ARN), a unique identifier that represents the log group to which CloudTrail logs are delivered. Not required unless you specify <code>CloudWatchLogsRoleArn</code>.</p>
    pub fn cloud_watch_logs_log_group_arn(&self) -> std::option::Option<&str> {
        self.cloud_watch_logs_log_group_arn.as_deref()
    }
    /// <p>Specifies the role for the CloudWatch Logs endpoint to assume to write to a user's log group.</p>
    pub fn cloud_watch_logs_role_arn(&self) -> std::option::Option<&str> {
        self.cloud_watch_logs_role_arn.as_deref()
    }
    /// <p>Specifies the KMS key ID to use to encrypt the logs delivered by CloudTrail. The value can be an alias name prefixed by "alias/", a fully specified ARN to an alias, a fully specified ARN to a key, or a globally unique identifier.</p>
    /// <p>CloudTrail also supports KMS multi-Region keys. For more information about multi-Region keys, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/multi-region-keys-overview.html">Using multi-Region keys</a> in the <i>Key Management Service Developer Guide</i>.</p>
    /// <p>Examples:</p>
    /// <ul>
    /// <li> <p>alias/MyAliasName</p> </li>
    /// <li> <p>arn:aws:kms:us-east-2:123456789012:alias/MyAliasName</p> </li>
    /// <li> <p>arn:aws:kms:us-east-2:123456789012:key/12345678-1234-1234-1234-123456789012</p> </li>
    /// <li> <p>12345678-1234-1234-1234-123456789012</p> </li>
    /// </ul>
    pub fn kms_key_id(&self) -> std::option::Option<&str> {
        self.kms_key_id.as_deref()
    }
    /// <p>Specifies whether the trail is applied to all accounts in an organization in Organizations, or only for the current Amazon Web Services account. The default is false, and cannot be true unless the call is made on behalf of an Amazon Web Services account that is the management account for an organization in Organizations. If the trail is not an organization trail and this is set to <code>true</code>, the trail will be created in all Amazon Web Services accounts that belong to the organization. If the trail is an organization trail and this is set to <code>false</code>, the trail will remain in the current Amazon Web Services account but be deleted from all member accounts in the organization.</p>
    pub fn is_organization_trail(&self) -> std::option::Option<bool> {
        self.is_organization_trail
    }
}
impl std::fmt::Debug for UpdateTrailInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateTrailInput");
        formatter.field("name", &self.name);
        formatter.field("s3_bucket_name", &self.s3_bucket_name);
        formatter.field("s3_key_prefix", &self.s3_key_prefix);
        formatter.field("sns_topic_name", &self.sns_topic_name);
        formatter.field(
            "include_global_service_events",
            &self.include_global_service_events,
        );
        formatter.field("is_multi_region_trail", &self.is_multi_region_trail);
        formatter.field(
            "enable_log_file_validation",
            &self.enable_log_file_validation,
        );
        formatter.field(
            "cloud_watch_logs_log_group_arn",
            &self.cloud_watch_logs_log_group_arn,
        );
        formatter.field("cloud_watch_logs_role_arn", &self.cloud_watch_logs_role_arn);
        formatter.field("kms_key_id", &self.kms_key_id);
        formatter.field("is_organization_trail", &self.is_organization_trail);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateEventDataStoreInput {
    /// <p>The ARN (or the ID suffix of the ARN) of the event data store that you want to update.</p>
    pub event_data_store: std::option::Option<std::string::String>,
    /// <p>The event data store name.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The advanced event selectors used to select events for the event data store.</p>
    pub advanced_event_selectors:
        std::option::Option<std::vec::Vec<crate::model::AdvancedEventSelector>>,
    /// <p>Specifies whether an event data store collects events from all regions, or only from the region in which it was created.</p>
    pub multi_region_enabled: std::option::Option<bool>,
    /// <p>Specifies whether an event data store collects events logged for an organization in Organizations.</p>
    pub organization_enabled: std::option::Option<bool>,
    /// <p>The retention period, in days.</p>
    pub retention_period: std::option::Option<i32>,
    /// <p>Indicates that termination protection is enabled and the event data store cannot be automatically deleted.</p>
    pub termination_protection_enabled: std::option::Option<bool>,
}
impl UpdateEventDataStoreInput {
    /// <p>The ARN (or the ID suffix of the ARN) of the event data store that you want to update.</p>
    pub fn event_data_store(&self) -> std::option::Option<&str> {
        self.event_data_store.as_deref()
    }
    /// <p>The event data store name.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The advanced event selectors used to select events for the event data store.</p>
    pub fn advanced_event_selectors(
        &self,
    ) -> std::option::Option<&[crate::model::AdvancedEventSelector]> {
        self.advanced_event_selectors.as_deref()
    }
    /// <p>Specifies whether an event data store collects events from all regions, or only from the region in which it was created.</p>
    pub fn multi_region_enabled(&self) -> std::option::Option<bool> {
        self.multi_region_enabled
    }
    /// <p>Specifies whether an event data store collects events logged for an organization in Organizations.</p>
    pub fn organization_enabled(&self) -> std::option::Option<bool> {
        self.organization_enabled
    }
    /// <p>The retention period, in days.</p>
    pub fn retention_period(&self) -> std::option::Option<i32> {
        self.retention_period
    }
    /// <p>Indicates that termination protection is enabled and the event data store cannot be automatically deleted.</p>
    pub fn termination_protection_enabled(&self) -> std::option::Option<bool> {
        self.termination_protection_enabled
    }
}
impl std::fmt::Debug for UpdateEventDataStoreInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateEventDataStoreInput");
        formatter.field("event_data_store", &self.event_data_store);
        formatter.field("name", &self.name);
        formatter.field("advanced_event_selectors", &self.advanced_event_selectors);
        formatter.field("multi_region_enabled", &self.multi_region_enabled);
        formatter.field("organization_enabled", &self.organization_enabled);
        formatter.field("retention_period", &self.retention_period);
        formatter.field(
            "termination_protection_enabled",
            &self.termination_protection_enabled,
        );
        formatter.finish()
    }
}

/// <p>Passes the request to CloudTrail to stop logging Amazon Web Services API calls for the specified account.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StopLoggingInput {
    /// <p>Specifies the name or the CloudTrail ARN of the trail for which CloudTrail will stop logging Amazon Web Services API calls. The following is the format of a trail ARN.</p>
    /// <p> <code>arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail</code> </p>
    pub name: std::option::Option<std::string::String>,
}
impl StopLoggingInput {
    /// <p>Specifies the name or the CloudTrail ARN of the trail for which CloudTrail will stop logging Amazon Web Services API calls. The following is the format of a trail ARN.</p>
    /// <p> <code>arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail</code> </p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
}
impl std::fmt::Debug for StopLoggingInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StopLoggingInput");
        formatter.field("name", &self.name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StartQueryInput {
    /// <p>The SQL code of your query.</p>
    pub query_statement: std::option::Option<std::string::String>,
}
impl StartQueryInput {
    /// <p>The SQL code of your query.</p>
    pub fn query_statement(&self) -> std::option::Option<&str> {
        self.query_statement.as_deref()
    }
}
impl std::fmt::Debug for StartQueryInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StartQueryInput");
        formatter.field("query_statement", &self.query_statement);
        formatter.finish()
    }
}

/// <p>The request to CloudTrail to start logging Amazon Web Services API calls for an account.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StartLoggingInput {
    /// <p>Specifies the name or the CloudTrail ARN of the trail for which CloudTrail logs Amazon Web Services API calls. The following is the format of a trail ARN.</p>
    /// <p> <code>arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail</code> </p>
    pub name: std::option::Option<std::string::String>,
}
impl StartLoggingInput {
    /// <p>Specifies the name or the CloudTrail ARN of the trail for which CloudTrail logs Amazon Web Services API calls. The following is the format of a trail ARN.</p>
    /// <p> <code>arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail</code> </p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
}
impl std::fmt::Debug for StartLoggingInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StartLoggingInput");
        formatter.field("name", &self.name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RestoreEventDataStoreInput {
    /// <p>The ARN (or the ID suffix of the ARN) of the event data store that you want to restore.</p>
    pub event_data_store: std::option::Option<std::string::String>,
}
impl RestoreEventDataStoreInput {
    /// <p>The ARN (or the ID suffix of the ARN) of the event data store that you want to restore.</p>
    pub fn event_data_store(&self) -> std::option::Option<&str> {
        self.event_data_store.as_deref()
    }
}
impl std::fmt::Debug for RestoreEventDataStoreInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RestoreEventDataStoreInput");
        formatter.field("event_data_store", &self.event_data_store);
        formatter.finish()
    }
}

/// <p>Specifies the tags to remove from a trail or event data store.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RemoveTagsInput {
    /// <p>Specifies the ARN of the trail or event data store from which tags should be removed.</p>
    /// <p> Example trail ARN format: <code>arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail</code> </p>
    /// <p>Example event data store ARN format: <code>arn:aws:cloudtrail:us-east-2:12345678910:eventdatastore/EXAMPLE-f852-4e8f-8bd1-bcf6cEXAMPLE</code> </p>
    pub resource_id: std::option::Option<std::string::String>,
    /// <p>Specifies a list of tags to be removed.</p>
    pub tags_list: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl RemoveTagsInput {
    /// <p>Specifies the ARN of the trail or event data store from which tags should be removed.</p>
    /// <p> Example trail ARN format: <code>arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail</code> </p>
    /// <p>Example event data store ARN format: <code>arn:aws:cloudtrail:us-east-2:12345678910:eventdatastore/EXAMPLE-f852-4e8f-8bd1-bcf6cEXAMPLE</code> </p>
    pub fn resource_id(&self) -> std::option::Option<&str> {
        self.resource_id.as_deref()
    }
    /// <p>Specifies a list of tags to be removed.</p>
    pub fn tags_list(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags_list.as_deref()
    }
}
impl std::fmt::Debug for RemoveTagsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RemoveTagsInput");
        formatter.field("resource_id", &self.resource_id);
        formatter.field("tags_list", &self.tags_list);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutInsightSelectorsInput {
    /// <p>The name of the CloudTrail trail for which you want to change or add Insights selectors.</p>
    pub trail_name: std::option::Option<std::string::String>,
    /// <p>A JSON string that contains the insight types you want to log on a trail. <code>ApiCallRateInsight</code> and <code>ApiErrorRateInsight</code> are valid insight types.</p>
    pub insight_selectors: std::option::Option<std::vec::Vec<crate::model::InsightSelector>>,
}
impl PutInsightSelectorsInput {
    /// <p>The name of the CloudTrail trail for which you want to change or add Insights selectors.</p>
    pub fn trail_name(&self) -> std::option::Option<&str> {
        self.trail_name.as_deref()
    }
    /// <p>A JSON string that contains the insight types you want to log on a trail. <code>ApiCallRateInsight</code> and <code>ApiErrorRateInsight</code> are valid insight types.</p>
    pub fn insight_selectors(&self) -> std::option::Option<&[crate::model::InsightSelector]> {
        self.insight_selectors.as_deref()
    }
}
impl std::fmt::Debug for PutInsightSelectorsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutInsightSelectorsInput");
        formatter.field("trail_name", &self.trail_name);
        formatter.field("insight_selectors", &self.insight_selectors);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutEventSelectorsInput {
    /// <p>Specifies the name of the trail or trail ARN. If you specify a trail name, the string must meet the following requirements:</p>
    /// <ul>
    /// <li> <p>Contain only ASCII letters (a-z, A-Z), numbers (0-9), periods (.), underscores (_), or dashes (-)</p> </li>
    /// <li> <p>Start with a letter or number, and end with a letter or number</p> </li>
    /// <li> <p>Be between 3 and 128 characters</p> </li>
    /// <li> <p>Have no adjacent periods, underscores or dashes. Names like <code>my-_namespace</code> and <code>my--namespace</code> are not valid.</p> </li>
    /// <li> <p>Not be in IP address format (for example, 192.168.5.4)</p> </li>
    /// </ul>
    /// <p>If you specify a trail ARN, it must be in the following format.</p>
    /// <p> <code>arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail</code> </p>
    pub trail_name: std::option::Option<std::string::String>,
    /// <p>Specifies the settings for your event selectors. You can configure up to five event selectors for a trail. You can use either <code>EventSelectors</code> or <code>AdvancedEventSelectors</code> in a <code>PutEventSelectors</code> request, but not both. If you apply <code>EventSelectors</code> to a trail, any existing <code>AdvancedEventSelectors</code> are overwritten.</p>
    pub event_selectors: std::option::Option<std::vec::Vec<crate::model::EventSelector>>,
    /// <p> Specifies the settings for advanced event selectors. You can add advanced event selectors, and conditions for your advanced event selectors, up to a maximum of 500 values for all conditions and selectors on a trail. You can use either <code>AdvancedEventSelectors</code> or <code>EventSelectors</code>, but not both. If you apply <code>AdvancedEventSelectors</code> to a trail, any existing <code>EventSelectors</code> are overwritten. For more information about advanced event selectors, see <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/logging-data-events-with-cloudtrail.html">Logging data events for trails</a> in the <i>CloudTrail User Guide</i>. </p>
    pub advanced_event_selectors:
        std::option::Option<std::vec::Vec<crate::model::AdvancedEventSelector>>,
}
impl PutEventSelectorsInput {
    /// <p>Specifies the name of the trail or trail ARN. If you specify a trail name, the string must meet the following requirements:</p>
    /// <ul>
    /// <li> <p>Contain only ASCII letters (a-z, A-Z), numbers (0-9), periods (.), underscores (_), or dashes (-)</p> </li>
    /// <li> <p>Start with a letter or number, and end with a letter or number</p> </li>
    /// <li> <p>Be between 3 and 128 characters</p> </li>
    /// <li> <p>Have no adjacent periods, underscores or dashes. Names like <code>my-_namespace</code> and <code>my--namespace</code> are not valid.</p> </li>
    /// <li> <p>Not be in IP address format (for example, 192.168.5.4)</p> </li>
    /// </ul>
    /// <p>If you specify a trail ARN, it must be in the following format.</p>
    /// <p> <code>arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail</code> </p>
    pub fn trail_name(&self) -> std::option::Option<&str> {
        self.trail_name.as_deref()
    }
    /// <p>Specifies the settings for your event selectors. You can configure up to five event selectors for a trail. You can use either <code>EventSelectors</code> or <code>AdvancedEventSelectors</code> in a <code>PutEventSelectors</code> request, but not both. If you apply <code>EventSelectors</code> to a trail, any existing <code>AdvancedEventSelectors</code> are overwritten.</p>
    pub fn event_selectors(&self) -> std::option::Option<&[crate::model::EventSelector]> {
        self.event_selectors.as_deref()
    }
    /// <p> Specifies the settings for advanced event selectors. You can add advanced event selectors, and conditions for your advanced event selectors, up to a maximum of 500 values for all conditions and selectors on a trail. You can use either <code>AdvancedEventSelectors</code> or <code>EventSelectors</code>, but not both. If you apply <code>AdvancedEventSelectors</code> to a trail, any existing <code>EventSelectors</code> are overwritten. For more information about advanced event selectors, see <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/logging-data-events-with-cloudtrail.html">Logging data events for trails</a> in the <i>CloudTrail User Guide</i>. </p>
    pub fn advanced_event_selectors(
        &self,
    ) -> std::option::Option<&[crate::model::AdvancedEventSelector]> {
        self.advanced_event_selectors.as_deref()
    }
}
impl std::fmt::Debug for PutEventSelectorsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutEventSelectorsInput");
        formatter.field("trail_name", &self.trail_name);
        formatter.field("event_selectors", &self.event_selectors);
        formatter.field("advanced_event_selectors", &self.advanced_event_selectors);
        formatter.finish()
    }
}

/// <p>Contains a request for LookupEvents.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LookupEventsInput {
    /// <p>Contains a list of lookup attributes. Currently the list can contain only one item.</p>
    pub lookup_attributes: std::option::Option<std::vec::Vec<crate::model::LookupAttribute>>,
    /// <p>Specifies that only events that occur after or at the specified time are returned. If the specified start time is after the specified end time, an error is returned.</p>
    pub start_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>Specifies that only events that occur before or at the specified time are returned. If the specified end time is before the specified start time, an error is returned.</p>
    pub end_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>Specifies the event category. If you do not specify an event category, events of the category are not returned in the response. For example, if you do not specify <code>insight</code> as the value of <code>EventCategory</code>, no Insights events are returned.</p>
    pub event_category: std::option::Option<crate::model::EventCategory>,
    /// <p>The number of events to return. Possible values are 1 through 50. The default is 50.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>The token to use to get the next page of results after a previous API call. This token must be passed in with the same parameters that were specified in the the original call. For example, if the original call specified an AttributeKey of 'Username' with a value of 'root', the call with NextToken should include those same parameters.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl LookupEventsInput {
    /// <p>Contains a list of lookup attributes. Currently the list can contain only one item.</p>
    pub fn lookup_attributes(&self) -> std::option::Option<&[crate::model::LookupAttribute]> {
        self.lookup_attributes.as_deref()
    }
    /// <p>Specifies that only events that occur after or at the specified time are returned. If the specified start time is after the specified end time, an error is returned.</p>
    pub fn start_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.start_time.as_ref()
    }
    /// <p>Specifies that only events that occur before or at the specified time are returned. If the specified end time is before the specified start time, an error is returned.</p>
    pub fn end_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.end_time.as_ref()
    }
    /// <p>Specifies the event category. If you do not specify an event category, events of the category are not returned in the response. For example, if you do not specify <code>insight</code> as the value of <code>EventCategory</code>, no Insights events are returned.</p>
    pub fn event_category(&self) -> std::option::Option<&crate::model::EventCategory> {
        self.event_category.as_ref()
    }
    /// <p>The number of events to return. Possible values are 1 through 50. The default is 50.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p>The token to use to get the next page of results after a previous API call. This token must be passed in with the same parameters that were specified in the the original call. For example, if the original call specified an AttributeKey of 'Username' with a value of 'root', the call with NextToken should include those same parameters.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for LookupEventsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LookupEventsInput");
        formatter.field("lookup_attributes", &self.lookup_attributes);
        formatter.field("start_time", &self.start_time);
        formatter.field("end_time", &self.end_time);
        formatter.field("event_category", &self.event_category);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTrailsInput {
    /// <p>The token to use to get the next page of results after a previous API call. This token must be passed in with the same parameters that were specified in the the original call. For example, if the original call specified an AttributeKey of 'Username' with a value of 'root', the call with NextToken should include those same parameters.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListTrailsInput {
    /// <p>The token to use to get the next page of results after a previous API call. This token must be passed in with the same parameters that were specified in the the original call. For example, if the original call specified an AttributeKey of 'Username' with a value of 'root', the call with NextToken should include those same parameters.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListTrailsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTrailsInput");
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

/// <p>Specifies a list of tags to return.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTagsInput {
    /// <p>Specifies a list of trail and event data store ARNs whose tags will be listed. The list has a limit of 20 ARNs.</p>
    pub resource_id_list: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>Reserved for future use.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListTagsInput {
    /// <p>Specifies a list of trail and event data store ARNs whose tags will be listed. The list has a limit of 20 ARNs.</p>
    pub fn resource_id_list(&self) -> std::option::Option<&[std::string::String]> {
        self.resource_id_list.as_deref()
    }
    /// <p>Reserved for future use.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListTagsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTagsInput");
        formatter.field("resource_id_list", &self.resource_id_list);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListQueriesInput {
    /// <p>The ARN (or the ID suffix of the ARN) of an event data store on which queries were run.</p>
    pub event_data_store: std::option::Option<std::string::String>,
    /// <p>A token you can use to get the next page of results.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of queries to show on a page.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>Use with <code>EndTime</code> to bound a <code>ListQueries</code> request, and limit its results to only those queries run within a specified time period.</p>
    pub start_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>Use with <code>StartTime</code> to bound a <code>ListQueries</code> request, and limit its results to only those queries run within a specified time period.</p>
    pub end_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The status of queries that you want to return in results. Valid values for <code>QueryStatus</code> include <code>QUEUED</code>, <code>RUNNING</code>, <code>FINISHED</code>, <code>FAILED</code>, <code>TIMED_OUT</code>, or <code>CANCELLED</code>.</p>
    pub query_status: std::option::Option<crate::model::QueryStatus>,
}
impl ListQueriesInput {
    /// <p>The ARN (or the ID suffix of the ARN) of an event data store on which queries were run.</p>
    pub fn event_data_store(&self) -> std::option::Option<&str> {
        self.event_data_store.as_deref()
    }
    /// <p>A token you can use to get the next page of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of queries to show on a page.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p>Use with <code>EndTime</code> to bound a <code>ListQueries</code> request, and limit its results to only those queries run within a specified time period.</p>
    pub fn start_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.start_time.as_ref()
    }
    /// <p>Use with <code>StartTime</code> to bound a <code>ListQueries</code> request, and limit its results to only those queries run within a specified time period.</p>
    pub fn end_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.end_time.as_ref()
    }
    /// <p>The status of queries that you want to return in results. Valid values for <code>QueryStatus</code> include <code>QUEUED</code>, <code>RUNNING</code>, <code>FINISHED</code>, <code>FAILED</code>, <code>TIMED_OUT</code>, or <code>CANCELLED</code>.</p>
    pub fn query_status(&self) -> std::option::Option<&crate::model::QueryStatus> {
        self.query_status.as_ref()
    }
}
impl std::fmt::Debug for ListQueriesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListQueriesInput");
        formatter.field("event_data_store", &self.event_data_store);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.field("start_time", &self.start_time);
        formatter.field("end_time", &self.end_time);
        formatter.field("query_status", &self.query_status);
        formatter.finish()
    }
}

/// <p>Requests the public keys for a specified time range.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListPublicKeysInput {
    /// <p>Optionally specifies, in UTC, the start of the time range to look up public keys for CloudTrail digest files. If not specified, the current time is used, and the current public key is returned.</p>
    pub start_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>Optionally specifies, in UTC, the end of the time range to look up public keys for CloudTrail digest files. If not specified, the current time is used.</p>
    pub end_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>Reserved for future use.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListPublicKeysInput {
    /// <p>Optionally specifies, in UTC, the start of the time range to look up public keys for CloudTrail digest files. If not specified, the current time is used, and the current public key is returned.</p>
    pub fn start_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.start_time.as_ref()
    }
    /// <p>Optionally specifies, in UTC, the end of the time range to look up public keys for CloudTrail digest files. If not specified, the current time is used.</p>
    pub fn end_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.end_time.as_ref()
    }
    /// <p>Reserved for future use.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListPublicKeysInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListPublicKeysInput");
        formatter.field("start_time", &self.start_time);
        formatter.field("end_time", &self.end_time);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListEventDataStoresInput {
    /// <p>A token you can use to get the next page of event data store results.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of event data stores to display on a single page.</p>
    pub max_results: std::option::Option<i32>,
}
impl ListEventDataStoresInput {
    /// <p>A token you can use to get the next page of event data store results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of event data stores to display on a single page.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
}
impl std::fmt::Debug for ListEventDataStoresInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListEventDataStoresInput");
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

/// <p>The name of a trail about which you want the current status.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetTrailStatusInput {
    /// <p>Specifies the name or the CloudTrail ARN of the trail for which you are requesting status. To get the status of a shadow trail (a replication of the trail in another region), you must specify its ARN. The following is the format of a trail ARN.</p>
    /// <p> <code>arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail</code> </p>
    pub name: std::option::Option<std::string::String>,
}
impl GetTrailStatusInput {
    /// <p>Specifies the name or the CloudTrail ARN of the trail for which you are requesting status. To get the status of a shadow trail (a replication of the trail in another region), you must specify its ARN. The following is the format of a trail ARN.</p>
    /// <p> <code>arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail</code> </p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
}
impl std::fmt::Debug for GetTrailStatusInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetTrailStatusInput");
        formatter.field("name", &self.name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetTrailInput {
    /// <p>The name or the Amazon Resource Name (ARN) of the trail for which you want to retrieve settings information.</p>
    pub name: std::option::Option<std::string::String>,
}
impl GetTrailInput {
    /// <p>The name or the Amazon Resource Name (ARN) of the trail for which you want to retrieve settings information.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
}
impl std::fmt::Debug for GetTrailInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetTrailInput");
        formatter.field("name", &self.name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetQueryResultsInput {
    /// <p>The ARN (or ID suffix of the ARN) of the event data store against which the query was run.</p>
    pub event_data_store: std::option::Option<std::string::String>,
    /// <p>The ID of the query for which you want to get results.</p>
    pub query_id: std::option::Option<std::string::String>,
    /// <p>A token you can use to get the next page of query results.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of query results to display on a single page.</p>
    pub max_query_results: std::option::Option<i32>,
}
impl GetQueryResultsInput {
    /// <p>The ARN (or ID suffix of the ARN) of the event data store against which the query was run.</p>
    pub fn event_data_store(&self) -> std::option::Option<&str> {
        self.event_data_store.as_deref()
    }
    /// <p>The ID of the query for which you want to get results.</p>
    pub fn query_id(&self) -> std::option::Option<&str> {
        self.query_id.as_deref()
    }
    /// <p>A token you can use to get the next page of query results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of query results to display on a single page.</p>
    pub fn max_query_results(&self) -> std::option::Option<i32> {
        self.max_query_results
    }
}
impl std::fmt::Debug for GetQueryResultsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetQueryResultsInput");
        formatter.field("event_data_store", &self.event_data_store);
        formatter.field("query_id", &self.query_id);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_query_results", &self.max_query_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetInsightSelectorsInput {
    /// <p>Specifies the name of the trail or trail ARN. If you specify a trail name, the string must meet the following requirements:</p>
    /// <ul>
    /// <li> <p>Contain only ASCII letters (a-z, A-Z), numbers (0-9), periods (.), underscores (_), or dashes (-)</p> </li>
    /// <li> <p>Start with a letter or number, and end with a letter or number</p> </li>
    /// <li> <p>Be between 3 and 128 characters</p> </li>
    /// <li> <p>Have no adjacent periods, underscores or dashes. Names like <code>my-_namespace</code> and <code>my--namespace</code> are not valid.</p> </li>
    /// <li> <p>Not be in IP address format (for example, 192.168.5.4)</p> </li>
    /// </ul>
    /// <p>If you specify a trail ARN, it must be in the format:</p>
    /// <p> <code>arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail</code> </p>
    pub trail_name: std::option::Option<std::string::String>,
}
impl GetInsightSelectorsInput {
    /// <p>Specifies the name of the trail or trail ARN. If you specify a trail name, the string must meet the following requirements:</p>
    /// <ul>
    /// <li> <p>Contain only ASCII letters (a-z, A-Z), numbers (0-9), periods (.), underscores (_), or dashes (-)</p> </li>
    /// <li> <p>Start with a letter or number, and end with a letter or number</p> </li>
    /// <li> <p>Be between 3 and 128 characters</p> </li>
    /// <li> <p>Have no adjacent periods, underscores or dashes. Names like <code>my-_namespace</code> and <code>my--namespace</code> are not valid.</p> </li>
    /// <li> <p>Not be in IP address format (for example, 192.168.5.4)</p> </li>
    /// </ul>
    /// <p>If you specify a trail ARN, it must be in the format:</p>
    /// <p> <code>arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail</code> </p>
    pub fn trail_name(&self) -> std::option::Option<&str> {
        self.trail_name.as_deref()
    }
}
impl std::fmt::Debug for GetInsightSelectorsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetInsightSelectorsInput");
        formatter.field("trail_name", &self.trail_name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetEventSelectorsInput {
    /// <p>Specifies the name of the trail or trail ARN. If you specify a trail name, the string must meet the following requirements:</p>
    /// <ul>
    /// <li> <p>Contain only ASCII letters (a-z, A-Z), numbers (0-9), periods (.), underscores (_), or dashes (-)</p> </li>
    /// <li> <p>Start with a letter or number, and end with a letter or number</p> </li>
    /// <li> <p>Be between 3 and 128 characters</p> </li>
    /// <li> <p>Have no adjacent periods, underscores or dashes. Names like <code>my-_namespace</code> and <code>my--namespace</code> are not valid.</p> </li>
    /// <li> <p>Not be in IP address format (for example, 192.168.5.4)</p> </li>
    /// </ul>
    /// <p>If you specify a trail ARN, it must be in the format:</p>
    /// <p> <code>arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail</code> </p>
    pub trail_name: std::option::Option<std::string::String>,
}
impl GetEventSelectorsInput {
    /// <p>Specifies the name of the trail or trail ARN. If you specify a trail name, the string must meet the following requirements:</p>
    /// <ul>
    /// <li> <p>Contain only ASCII letters (a-z, A-Z), numbers (0-9), periods (.), underscores (_), or dashes (-)</p> </li>
    /// <li> <p>Start with a letter or number, and end with a letter or number</p> </li>
    /// <li> <p>Be between 3 and 128 characters</p> </li>
    /// <li> <p>Have no adjacent periods, underscores or dashes. Names like <code>my-_namespace</code> and <code>my--namespace</code> are not valid.</p> </li>
    /// <li> <p>Not be in IP address format (for example, 192.168.5.4)</p> </li>
    /// </ul>
    /// <p>If you specify a trail ARN, it must be in the format:</p>
    /// <p> <code>arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail</code> </p>
    pub fn trail_name(&self) -> std::option::Option<&str> {
        self.trail_name.as_deref()
    }
}
impl std::fmt::Debug for GetEventSelectorsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetEventSelectorsInput");
        formatter.field("trail_name", &self.trail_name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetEventDataStoreInput {
    /// <p>The ARN (or ID suffix of the ARN) of the event data store about which you want information.</p>
    pub event_data_store: std::option::Option<std::string::String>,
}
impl GetEventDataStoreInput {
    /// <p>The ARN (or ID suffix of the ARN) of the event data store about which you want information.</p>
    pub fn event_data_store(&self) -> std::option::Option<&str> {
        self.event_data_store.as_deref()
    }
}
impl std::fmt::Debug for GetEventDataStoreInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetEventDataStoreInput");
        formatter.field("event_data_store", &self.event_data_store);
        formatter.finish()
    }
}

/// <p>Returns information about the trail.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeTrailsInput {
    /// <p>Specifies a list of trail names, trail ARNs, or both, of the trails to describe. The format of a trail ARN is:</p>
    /// <p> <code>arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail</code> </p>
    /// <p>If an empty list is specified, information for the trail in the current region is returned.</p>
    /// <ul>
    /// <li> <p>If an empty list is specified and <code>IncludeShadowTrails</code> is false, then information for all trails in the current region is returned.</p> </li>
    /// <li> <p>If an empty list is specified and IncludeShadowTrails is null or true, then information for all trails in the current region and any associated shadow trails in other regions is returned.</p> </li>
    /// </ul> <note>
    /// <p>If one or more trail names are specified, information is returned only if the names match the names of trails belonging only to the current region. To return information about a trail in another region, you must specify its trail ARN.</p>
    /// </note>
    pub trail_name_list: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>Specifies whether to include shadow trails in the response. A shadow trail is the replication in a region of a trail that was created in a different region, or in the case of an organization trail, the replication of an organization trail in member accounts. If you do not include shadow trails, organization trails in a member account and region replication trails will not be returned. The default is true.</p>
    pub include_shadow_trails: std::option::Option<bool>,
}
impl DescribeTrailsInput {
    /// <p>Specifies a list of trail names, trail ARNs, or both, of the trails to describe. The format of a trail ARN is:</p>
    /// <p> <code>arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail</code> </p>
    /// <p>If an empty list is specified, information for the trail in the current region is returned.</p>
    /// <ul>
    /// <li> <p>If an empty list is specified and <code>IncludeShadowTrails</code> is false, then information for all trails in the current region is returned.</p> </li>
    /// <li> <p>If an empty list is specified and IncludeShadowTrails is null or true, then information for all trails in the current region and any associated shadow trails in other regions is returned.</p> </li>
    /// </ul> <note>
    /// <p>If one or more trail names are specified, information is returned only if the names match the names of trails belonging only to the current region. To return information about a trail in another region, you must specify its trail ARN.</p>
    /// </note>
    pub fn trail_name_list(&self) -> std::option::Option<&[std::string::String]> {
        self.trail_name_list.as_deref()
    }
    /// <p>Specifies whether to include shadow trails in the response. A shadow trail is the replication in a region of a trail that was created in a different region, or in the case of an organization trail, the replication of an organization trail in member accounts. If you do not include shadow trails, organization trails in a member account and region replication trails will not be returned. The default is true.</p>
    pub fn include_shadow_trails(&self) -> std::option::Option<bool> {
        self.include_shadow_trails
    }
}
impl std::fmt::Debug for DescribeTrailsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeTrailsInput");
        formatter.field("trail_name_list", &self.trail_name_list);
        formatter.field("include_shadow_trails", &self.include_shadow_trails);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeQueryInput {
    /// <p>The ARN (or the ID suffix of the ARN) of an event data store on which the specified query was run.</p>
    pub event_data_store: std::option::Option<std::string::String>,
    /// <p>The query ID.</p>
    pub query_id: std::option::Option<std::string::String>,
}
impl DescribeQueryInput {
    /// <p>The ARN (or the ID suffix of the ARN) of an event data store on which the specified query was run.</p>
    pub fn event_data_store(&self) -> std::option::Option<&str> {
        self.event_data_store.as_deref()
    }
    /// <p>The query ID.</p>
    pub fn query_id(&self) -> std::option::Option<&str> {
        self.query_id.as_deref()
    }
}
impl std::fmt::Debug for DescribeQueryInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeQueryInput");
        formatter.field("event_data_store", &self.event_data_store);
        formatter.field("query_id", &self.query_id);
        formatter.finish()
    }
}

/// <p>The request that specifies the name of a trail to delete.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteTrailInput {
    /// <p>Specifies the name or the CloudTrail ARN of the trail to be deleted. The following is the format of a trail ARN. <code>arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail</code> </p>
    pub name: std::option::Option<std::string::String>,
}
impl DeleteTrailInput {
    /// <p>Specifies the name or the CloudTrail ARN of the trail to be deleted. The following is the format of a trail ARN. <code>arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail</code> </p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
}
impl std::fmt::Debug for DeleteTrailInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteTrailInput");
        formatter.field("name", &self.name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteEventDataStoreInput {
    /// <p>The ARN (or the ID suffix of the ARN) of the event data store to delete.</p>
    pub event_data_store: std::option::Option<std::string::String>,
}
impl DeleteEventDataStoreInput {
    /// <p>The ARN (or the ID suffix of the ARN) of the event data store to delete.</p>
    pub fn event_data_store(&self) -> std::option::Option<&str> {
        self.event_data_store.as_deref()
    }
}
impl std::fmt::Debug for DeleteEventDataStoreInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteEventDataStoreInput");
        formatter.field("event_data_store", &self.event_data_store);
        formatter.finish()
    }
}

/// <p>Specifies the settings for each trail.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateTrailInput {
    /// <p>Specifies the name of the trail. The name must meet the following requirements:</p>
    /// <ul>
    /// <li> <p>Contain only ASCII letters (a-z, A-Z), numbers (0-9), periods (.), underscores (_), or dashes (-)</p> </li>
    /// <li> <p>Start with a letter or number, and end with a letter or number</p> </li>
    /// <li> <p>Be between 3 and 128 characters</p> </li>
    /// <li> <p>Have no adjacent periods, underscores or dashes. Names like <code>my-_namespace</code> and <code>my--namespace</code> are not valid.</p> </li>
    /// <li> <p>Not be in IP address format (for example, 192.168.5.4)</p> </li>
    /// </ul>
    pub name: std::option::Option<std::string::String>,
    /// <p>Specifies the name of the Amazon S3 bucket designated for publishing log files. See <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/create_trail_naming_policy.html">Amazon S3 Bucket Naming Requirements</a>.</p>
    pub s3_bucket_name: std::option::Option<std::string::String>,
    /// <p>Specifies the Amazon S3 key prefix that comes after the name of the bucket you have designated for log file delivery. For more information, see <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/cloudtrail-find-log-files.html">Finding Your CloudTrail Log Files</a>. The maximum length is 200 characters.</p>
    pub s3_key_prefix: std::option::Option<std::string::String>,
    /// <p>Specifies the name of the Amazon SNS topic defined for notification of log file delivery. The maximum length is 256 characters.</p>
    pub sns_topic_name: std::option::Option<std::string::String>,
    /// <p>Specifies whether the trail is publishing events from global services such as IAM to the log files.</p>
    pub include_global_service_events: std::option::Option<bool>,
    /// <p>Specifies whether the trail is created in the current region or in all regions. The default is false, which creates a trail only in the region where you are signed in. As a best practice, consider creating trails that log events in all regions.</p>
    pub is_multi_region_trail: std::option::Option<bool>,
    /// <p>Specifies whether log file integrity validation is enabled. The default is false.</p> <note>
    /// <p>When you disable log file integrity validation, the chain of digest files is broken after one hour. CloudTrail does not create digest files for log files that were delivered during a period in which log file integrity validation was disabled. For example, if you enable log file integrity validation at noon on January 1, disable it at noon on January 2, and re-enable it at noon on January 10, digest files will not be created for the log files delivered from noon on January 2 to noon on January 10. The same applies whenever you stop CloudTrail logging or delete a trail.</p>
    /// </note>
    pub enable_log_file_validation: std::option::Option<bool>,
    /// <p>Specifies a log group name using an Amazon Resource Name (ARN), a unique identifier that represents the log group to which CloudTrail logs will be delivered. Not required unless you specify <code>CloudWatchLogsRoleArn</code>.</p>
    pub cloud_watch_logs_log_group_arn: std::option::Option<std::string::String>,
    /// <p>Specifies the role for the CloudWatch Logs endpoint to assume to write to a user's log group.</p>
    pub cloud_watch_logs_role_arn: std::option::Option<std::string::String>,
    /// <p>Specifies the KMS key ID to use to encrypt the logs delivered by CloudTrail. The value can be an alias name prefixed by "alias/", a fully specified ARN to an alias, a fully specified ARN to a key, or a globally unique identifier.</p>
    /// <p>CloudTrail also supports KMS multi-Region keys. For more information about multi-Region keys, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/multi-region-keys-overview.html">Using multi-Region keys</a> in the <i>Key Management Service Developer Guide</i>.</p>
    /// <p>Examples:</p>
    /// <ul>
    /// <li> <p>alias/MyAliasName</p> </li>
    /// <li> <p>arn:aws:kms:us-east-2:123456789012:alias/MyAliasName</p> </li>
    /// <li> <p>arn:aws:kms:us-east-2:123456789012:key/12345678-1234-1234-1234-123456789012</p> </li>
    /// <li> <p>12345678-1234-1234-1234-123456789012</p> </li>
    /// </ul>
    pub kms_key_id: std::option::Option<std::string::String>,
    /// <p>Specifies whether the trail is created for all accounts in an organization in Organizations, or only for the current Amazon Web Services account. The default is false, and cannot be true unless the call is made on behalf of an Amazon Web Services account that is the management account for an organization in Organizations.</p>
    pub is_organization_trail: std::option::Option<bool>,
    /// <p>A list of tags.</p>
    pub tags_list: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl CreateTrailInput {
    /// <p>Specifies the name of the trail. The name must meet the following requirements:</p>
    /// <ul>
    /// <li> <p>Contain only ASCII letters (a-z, A-Z), numbers (0-9), periods (.), underscores (_), or dashes (-)</p> </li>
    /// <li> <p>Start with a letter or number, and end with a letter or number</p> </li>
    /// <li> <p>Be between 3 and 128 characters</p> </li>
    /// <li> <p>Have no adjacent periods, underscores or dashes. Names like <code>my-_namespace</code> and <code>my--namespace</code> are not valid.</p> </li>
    /// <li> <p>Not be in IP address format (for example, 192.168.5.4)</p> </li>
    /// </ul>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>Specifies the name of the Amazon S3 bucket designated for publishing log files. See <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/create_trail_naming_policy.html">Amazon S3 Bucket Naming Requirements</a>.</p>
    pub fn s3_bucket_name(&self) -> std::option::Option<&str> {
        self.s3_bucket_name.as_deref()
    }
    /// <p>Specifies the Amazon S3 key prefix that comes after the name of the bucket you have designated for log file delivery. For more information, see <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/cloudtrail-find-log-files.html">Finding Your CloudTrail Log Files</a>. The maximum length is 200 characters.</p>
    pub fn s3_key_prefix(&self) -> std::option::Option<&str> {
        self.s3_key_prefix.as_deref()
    }
    /// <p>Specifies the name of the Amazon SNS topic defined for notification of log file delivery. The maximum length is 256 characters.</p>
    pub fn sns_topic_name(&self) -> std::option::Option<&str> {
        self.sns_topic_name.as_deref()
    }
    /// <p>Specifies whether the trail is publishing events from global services such as IAM to the log files.</p>
    pub fn include_global_service_events(&self) -> std::option::Option<bool> {
        self.include_global_service_events
    }
    /// <p>Specifies whether the trail is created in the current region or in all regions. The default is false, which creates a trail only in the region where you are signed in. As a best practice, consider creating trails that log events in all regions.</p>
    pub fn is_multi_region_trail(&self) -> std::option::Option<bool> {
        self.is_multi_region_trail
    }
    /// <p>Specifies whether log file integrity validation is enabled. The default is false.</p> <note>
    /// <p>When you disable log file integrity validation, the chain of digest files is broken after one hour. CloudTrail does not create digest files for log files that were delivered during a period in which log file integrity validation was disabled. For example, if you enable log file integrity validation at noon on January 1, disable it at noon on January 2, and re-enable it at noon on January 10, digest files will not be created for the log files delivered from noon on January 2 to noon on January 10. The same applies whenever you stop CloudTrail logging or delete a trail.</p>
    /// </note>
    pub fn enable_log_file_validation(&self) -> std::option::Option<bool> {
        self.enable_log_file_validation
    }
    /// <p>Specifies a log group name using an Amazon Resource Name (ARN), a unique identifier that represents the log group to which CloudTrail logs will be delivered. Not required unless you specify <code>CloudWatchLogsRoleArn</code>.</p>
    pub fn cloud_watch_logs_log_group_arn(&self) -> std::option::Option<&str> {
        self.cloud_watch_logs_log_group_arn.as_deref()
    }
    /// <p>Specifies the role for the CloudWatch Logs endpoint to assume to write to a user's log group.</p>
    pub fn cloud_watch_logs_role_arn(&self) -> std::option::Option<&str> {
        self.cloud_watch_logs_role_arn.as_deref()
    }
    /// <p>Specifies the KMS key ID to use to encrypt the logs delivered by CloudTrail. The value can be an alias name prefixed by "alias/", a fully specified ARN to an alias, a fully specified ARN to a key, or a globally unique identifier.</p>
    /// <p>CloudTrail also supports KMS multi-Region keys. For more information about multi-Region keys, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/multi-region-keys-overview.html">Using multi-Region keys</a> in the <i>Key Management Service Developer Guide</i>.</p>
    /// <p>Examples:</p>
    /// <ul>
    /// <li> <p>alias/MyAliasName</p> </li>
    /// <li> <p>arn:aws:kms:us-east-2:123456789012:alias/MyAliasName</p> </li>
    /// <li> <p>arn:aws:kms:us-east-2:123456789012:key/12345678-1234-1234-1234-123456789012</p> </li>
    /// <li> <p>12345678-1234-1234-1234-123456789012</p> </li>
    /// </ul>
    pub fn kms_key_id(&self) -> std::option::Option<&str> {
        self.kms_key_id.as_deref()
    }
    /// <p>Specifies whether the trail is created for all accounts in an organization in Organizations, or only for the current Amazon Web Services account. The default is false, and cannot be true unless the call is made on behalf of an Amazon Web Services account that is the management account for an organization in Organizations.</p>
    pub fn is_organization_trail(&self) -> std::option::Option<bool> {
        self.is_organization_trail
    }
    /// <p>A list of tags.</p>
    pub fn tags_list(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags_list.as_deref()
    }
}
impl std::fmt::Debug for CreateTrailInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateTrailInput");
        formatter.field("name", &self.name);
        formatter.field("s3_bucket_name", &self.s3_bucket_name);
        formatter.field("s3_key_prefix", &self.s3_key_prefix);
        formatter.field("sns_topic_name", &self.sns_topic_name);
        formatter.field(
            "include_global_service_events",
            &self.include_global_service_events,
        );
        formatter.field("is_multi_region_trail", &self.is_multi_region_trail);
        formatter.field(
            "enable_log_file_validation",
            &self.enable_log_file_validation,
        );
        formatter.field(
            "cloud_watch_logs_log_group_arn",
            &self.cloud_watch_logs_log_group_arn,
        );
        formatter.field("cloud_watch_logs_role_arn", &self.cloud_watch_logs_role_arn);
        formatter.field("kms_key_id", &self.kms_key_id);
        formatter.field("is_organization_trail", &self.is_organization_trail);
        formatter.field("tags_list", &self.tags_list);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateEventDataStoreInput {
    /// <p>The name of the event data store.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The advanced event selectors to use to select the events for the data store. For more information about how to use advanced event selectors, see <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/logging-data-events-with-cloudtrail.html#creating-data-event-selectors-advanced">Log events by using advanced event selectors</a> in the CloudTrail User Guide.</p>
    pub advanced_event_selectors:
        std::option::Option<std::vec::Vec<crate::model::AdvancedEventSelector>>,
    /// <p>Specifies whether the event data store includes events from all regions, or only from the region in which the event data store is created.</p>
    pub multi_region_enabled: std::option::Option<bool>,
    /// <p>Specifies whether an event data store collects events logged for an organization in Organizations.</p>
    pub organization_enabled: std::option::Option<bool>,
    /// <p>The retention period of the event data store, in days. You can set a retention period of up to 2555 days, the equivalent of seven years.</p>
    pub retention_period: std::option::Option<i32>,
    /// <p>Specifies whether termination protection is enabled for the event data store. If termination protection is enabled, you cannot delete the event data store until termination protection is disabled.</p>
    pub termination_protection_enabled: std::option::Option<bool>,
    /// <p>A list of tags.</p>
    pub tags_list: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl CreateEventDataStoreInput {
    /// <p>The name of the event data store.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The advanced event selectors to use to select the events for the data store. For more information about how to use advanced event selectors, see <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/logging-data-events-with-cloudtrail.html#creating-data-event-selectors-advanced">Log events by using advanced event selectors</a> in the CloudTrail User Guide.</p>
    pub fn advanced_event_selectors(
        &self,
    ) -> std::option::Option<&[crate::model::AdvancedEventSelector]> {
        self.advanced_event_selectors.as_deref()
    }
    /// <p>Specifies whether the event data store includes events from all regions, or only from the region in which the event data store is created.</p>
    pub fn multi_region_enabled(&self) -> std::option::Option<bool> {
        self.multi_region_enabled
    }
    /// <p>Specifies whether an event data store collects events logged for an organization in Organizations.</p>
    pub fn organization_enabled(&self) -> std::option::Option<bool> {
        self.organization_enabled
    }
    /// <p>The retention period of the event data store, in days. You can set a retention period of up to 2555 days, the equivalent of seven years.</p>
    pub fn retention_period(&self) -> std::option::Option<i32> {
        self.retention_period
    }
    /// <p>Specifies whether termination protection is enabled for the event data store. If termination protection is enabled, you cannot delete the event data store until termination protection is disabled.</p>
    pub fn termination_protection_enabled(&self) -> std::option::Option<bool> {
        self.termination_protection_enabled
    }
    /// <p>A list of tags.</p>
    pub fn tags_list(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags_list.as_deref()
    }
}
impl std::fmt::Debug for CreateEventDataStoreInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateEventDataStoreInput");
        formatter.field("name", &self.name);
        formatter.field("advanced_event_selectors", &self.advanced_event_selectors);
        formatter.field("multi_region_enabled", &self.multi_region_enabled);
        formatter.field("organization_enabled", &self.organization_enabled);
        formatter.field("retention_period", &self.retention_period);
        formatter.field(
            "termination_protection_enabled",
            &self.termination_protection_enabled,
        );
        formatter.field("tags_list", &self.tags_list);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CancelQueryInput {
    /// <p>The ARN (or the ID suffix of the ARN) of an event data store on which the specified query is running.</p>
    pub event_data_store: std::option::Option<std::string::String>,
    /// <p>The ID of the query that you want to cancel. The <code>QueryId</code> comes from the response of a <code>StartQuery</code> operation.</p>
    pub query_id: std::option::Option<std::string::String>,
}
impl CancelQueryInput {
    /// <p>The ARN (or the ID suffix of the ARN) of an event data store on which the specified query is running.</p>
    pub fn event_data_store(&self) -> std::option::Option<&str> {
        self.event_data_store.as_deref()
    }
    /// <p>The ID of the query that you want to cancel. The <code>QueryId</code> comes from the response of a <code>StartQuery</code> operation.</p>
    pub fn query_id(&self) -> std::option::Option<&str> {
        self.query_id.as_deref()
    }
}
impl std::fmt::Debug for CancelQueryInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CancelQueryInput");
        formatter.field("event_data_store", &self.event_data_store);
        formatter.field("query_id", &self.query_id);
        formatter.finish()
    }
}

/// <p>Specifies the tags to add to a trail or event data store.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AddTagsInput {
    /// <p>Specifies the ARN of the trail or event data store to which one or more tags will be added. The format of a trail ARN is:</p>
    /// <p> <code>arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail</code> </p>
    pub resource_id: std::option::Option<std::string::String>,
    /// <p>Contains a list of tags, up to a limit of 50</p>
    pub tags_list: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl AddTagsInput {
    /// <p>Specifies the ARN of the trail or event data store to which one or more tags will be added. The format of a trail ARN is:</p>
    /// <p> <code>arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail</code> </p>
    pub fn resource_id(&self) -> std::option::Option<&str> {
        self.resource_id.as_deref()
    }
    /// <p>Contains a list of tags, up to a limit of 50</p>
    pub fn tags_list(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags_list.as_deref()
    }
}
impl std::fmt::Debug for AddTagsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AddTagsInput");
        formatter.field("resource_id", &self.resource_id);
        formatter.field("tags_list", &self.tags_list);
        formatter.finish()
    }
}
