// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Error type for the `AddTags` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct AddTagsError {
    /// Kind of error that occurred.
    pub kind: AddTagsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `AddTags` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum AddTagsErrorKind {
    /// <p>This exception is thrown when an operation is called with a trail ARN that is not valid. The following is the format of a trail ARN.</p>
    /// <p> <code>arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail</code> </p>
    CloudTrailArnInvalidException(crate::error::CloudTrailArnInvalidException),
    /// <p>This exception is thrown when the specified resource is not ready for an operation. This can occur when you try to run an operation on a trail before CloudTrail has time to fully load the trail. If this exception occurs, wait a few minutes, and then try the operation again.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The specified event data store was not found.</p>
    EventDataStoreNotFoundException(crate::error::EventDataStoreNotFoundException),
    /// <p>The event data store against which you ran your query is inactive.</p>
    InactiveEventDataStoreException(crate::error::InactiveEventDataStoreException),
    /// <p>This exception is thrown when the specified tag key or values are not valid. It can also occur if there are duplicate tags or too many tags on the resource.</p>
    InvalidTagParameterException(crate::error::InvalidTagParameterException),
    /// <p>This exception is thrown when the provided trail name is not valid. Trail names must meet the following requirements:</p>
    /// <ul>
    /// <li> <p>Contain only ASCII letters (a-z, A-Z), numbers (0-9), periods (.), underscores (_), or dashes (-)</p> </li>
    /// <li> <p>Start with a letter or number, and end with a letter or number</p> </li>
    /// <li> <p>Be between 3 and 128 characters</p> </li>
    /// <li> <p>Have no adjacent periods, underscores or dashes. Names like <code>my-_namespace</code> and <code>my--namespace</code> are not valid.</p> </li>
    /// <li> <p>Not be in IP address format (for example, 192.168.5.4)</p> </li>
    /// </ul>
    InvalidTrailNameException(crate::error::InvalidTrailNameException),
    /// <p>This exception is thrown when the Amazon Web Services account making the request to create or update an organization trail is not the management account for an organization in Organizations. For more information, see <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/creating-an-organizational-trail-prepare.html">Prepare For Creating a Trail For Your Organization</a>.</p>
    NotOrganizationMasterAccountException(crate::error::NotOrganizationMasterAccountException),
    /// <p>This exception is thrown when the requested operation is not permitted.</p>
    OperationNotPermittedException(crate::error::OperationNotPermittedException),
    /// <p>This exception is thrown when the specified resource is not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>This exception is thrown when the specified resource type is not supported by CloudTrail.</p>
    ResourceTypeNotSupportedException(crate::error::ResourceTypeNotSupportedException),
    /// <p>The number of tags per trail has exceeded the permitted amount. Currently, the limit is 50.</p>
    TagsLimitExceededException(crate::error::TagsLimitExceededException),
    /// <p>This exception is thrown when the requested operation is not supported.</p>
    UnsupportedOperationException(crate::error::UnsupportedOperationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for AddTagsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            AddTagsErrorKind::CloudTrailArnInvalidException(_inner) => _inner.fmt(f),
            AddTagsErrorKind::ConflictException(_inner) => _inner.fmt(f),
            AddTagsErrorKind::EventDataStoreNotFoundException(_inner) => _inner.fmt(f),
            AddTagsErrorKind::InactiveEventDataStoreException(_inner) => _inner.fmt(f),
            AddTagsErrorKind::InvalidTagParameterException(_inner) => _inner.fmt(f),
            AddTagsErrorKind::InvalidTrailNameException(_inner) => _inner.fmt(f),
            AddTagsErrorKind::NotOrganizationMasterAccountException(_inner) => _inner.fmt(f),
            AddTagsErrorKind::OperationNotPermittedException(_inner) => _inner.fmt(f),
            AddTagsErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            AddTagsErrorKind::ResourceTypeNotSupportedException(_inner) => _inner.fmt(f),
            AddTagsErrorKind::TagsLimitExceededException(_inner) => _inner.fmt(f),
            AddTagsErrorKind::UnsupportedOperationException(_inner) => _inner.fmt(f),
            AddTagsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for AddTagsError {
    fn code(&self) -> Option<&str> {
        AddTagsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl AddTagsError {
    /// Creates a new `AddTagsError`.
    pub fn new(kind: AddTagsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `AddTagsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: AddTagsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `AddTagsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: AddTagsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `AddTagsErrorKind::CloudTrailArnInvalidException`.
    pub fn is_cloud_trail_arn_invalid_exception(&self) -> bool {
        matches!(
            &self.kind,
            AddTagsErrorKind::CloudTrailArnInvalidException(_)
        )
    }
    /// Returns `true` if the error kind is `AddTagsErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, AddTagsErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `AddTagsErrorKind::EventDataStoreNotFoundException`.
    pub fn is_event_data_store_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            AddTagsErrorKind::EventDataStoreNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `AddTagsErrorKind::InactiveEventDataStoreException`.
    pub fn is_inactive_event_data_store_exception(&self) -> bool {
        matches!(
            &self.kind,
            AddTagsErrorKind::InactiveEventDataStoreException(_)
        )
    }
    /// Returns `true` if the error kind is `AddTagsErrorKind::InvalidTagParameterException`.
    pub fn is_invalid_tag_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            AddTagsErrorKind::InvalidTagParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `AddTagsErrorKind::InvalidTrailNameException`.
    pub fn is_invalid_trail_name_exception(&self) -> bool {
        matches!(&self.kind, AddTagsErrorKind::InvalidTrailNameException(_))
    }
    /// Returns `true` if the error kind is `AddTagsErrorKind::NotOrganizationMasterAccountException`.
    pub fn is_not_organization_master_account_exception(&self) -> bool {
        matches!(
            &self.kind,
            AddTagsErrorKind::NotOrganizationMasterAccountException(_)
        )
    }
    /// Returns `true` if the error kind is `AddTagsErrorKind::OperationNotPermittedException`.
    pub fn is_operation_not_permitted_exception(&self) -> bool {
        matches!(
            &self.kind,
            AddTagsErrorKind::OperationNotPermittedException(_)
        )
    }
    /// Returns `true` if the error kind is `AddTagsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(&self.kind, AddTagsErrorKind::ResourceNotFoundException(_))
    }
    /// Returns `true` if the error kind is `AddTagsErrorKind::ResourceTypeNotSupportedException`.
    pub fn is_resource_type_not_supported_exception(&self) -> bool {
        matches!(
            &self.kind,
            AddTagsErrorKind::ResourceTypeNotSupportedException(_)
        )
    }
    /// Returns `true` if the error kind is `AddTagsErrorKind::TagsLimitExceededException`.
    pub fn is_tags_limit_exceeded_exception(&self) -> bool {
        matches!(&self.kind, AddTagsErrorKind::TagsLimitExceededException(_))
    }
    /// Returns `true` if the error kind is `AddTagsErrorKind::UnsupportedOperationException`.
    pub fn is_unsupported_operation_exception(&self) -> bool {
        matches!(
            &self.kind,
            AddTagsErrorKind::UnsupportedOperationException(_)
        )
    }
}
impl std::error::Error for AddTagsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            AddTagsErrorKind::CloudTrailArnInvalidException(_inner) => Some(_inner),
            AddTagsErrorKind::ConflictException(_inner) => Some(_inner),
            AddTagsErrorKind::EventDataStoreNotFoundException(_inner) => Some(_inner),
            AddTagsErrorKind::InactiveEventDataStoreException(_inner) => Some(_inner),
            AddTagsErrorKind::InvalidTagParameterException(_inner) => Some(_inner),
            AddTagsErrorKind::InvalidTrailNameException(_inner) => Some(_inner),
            AddTagsErrorKind::NotOrganizationMasterAccountException(_inner) => Some(_inner),
            AddTagsErrorKind::OperationNotPermittedException(_inner) => Some(_inner),
            AddTagsErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            AddTagsErrorKind::ResourceTypeNotSupportedException(_inner) => Some(_inner),
            AddTagsErrorKind::TagsLimitExceededException(_inner) => Some(_inner),
            AddTagsErrorKind::UnsupportedOperationException(_inner) => Some(_inner),
            AddTagsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CancelQuery` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CancelQueryError {
    /// Kind of error that occurred.
    pub kind: CancelQueryErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CancelQuery` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CancelQueryErrorKind {
    /// <p>This exception is thrown when the specified resource is not ready for an operation. This can occur when you try to run an operation on a trail before CloudTrail has time to fully load the trail. If this exception occurs, wait a few minutes, and then try the operation again.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The specified event data store ARN is not valid or does not map to an event data store in your account.</p>
    EventDataStoreArnInvalidException(crate::error::EventDataStoreArnInvalidException),
    /// <p>The specified event data store was not found.</p>
    EventDataStoreNotFoundException(crate::error::EventDataStoreNotFoundException),
    /// <p>The event data store against which you ran your query is inactive.</p>
    InactiveEventDataStoreException(crate::error::InactiveEventDataStoreException),
    /// <p>The specified query cannot be canceled because it is in the <code>FINISHED</code>, <code>FAILED</code>, <code>TIMED_OUT</code>, or <code>CANCELLED</code> state.</p>
    InactiveQueryException(crate::error::InactiveQueryException),
    /// <p>The request includes a parameter that is not valid.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>This exception is thrown when the requested operation is not permitted.</p>
    OperationNotPermittedException(crate::error::OperationNotPermittedException),
    /// <p>The query ID does not exist or does not map to a query.</p>
    QueryIdNotFoundException(crate::error::QueryIdNotFoundException),
    /// <p>This exception is thrown when the requested operation is not supported.</p>
    UnsupportedOperationException(crate::error::UnsupportedOperationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CancelQueryError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CancelQueryErrorKind::ConflictException(_inner) => _inner.fmt(f),
            CancelQueryErrorKind::EventDataStoreArnInvalidException(_inner) => _inner.fmt(f),
            CancelQueryErrorKind::EventDataStoreNotFoundException(_inner) => _inner.fmt(f),
            CancelQueryErrorKind::InactiveEventDataStoreException(_inner) => _inner.fmt(f),
            CancelQueryErrorKind::InactiveQueryException(_inner) => _inner.fmt(f),
            CancelQueryErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            CancelQueryErrorKind::OperationNotPermittedException(_inner) => _inner.fmt(f),
            CancelQueryErrorKind::QueryIdNotFoundException(_inner) => _inner.fmt(f),
            CancelQueryErrorKind::UnsupportedOperationException(_inner) => _inner.fmt(f),
            CancelQueryErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CancelQueryError {
    fn code(&self) -> Option<&str> {
        CancelQueryError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CancelQueryError {
    /// Creates a new `CancelQueryError`.
    pub fn new(kind: CancelQueryErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CancelQueryError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CancelQueryErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CancelQueryError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CancelQueryErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CancelQueryErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, CancelQueryErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `CancelQueryErrorKind::EventDataStoreArnInvalidException`.
    pub fn is_event_data_store_arn_invalid_exception(&self) -> bool {
        matches!(
            &self.kind,
            CancelQueryErrorKind::EventDataStoreArnInvalidException(_)
        )
    }
    /// Returns `true` if the error kind is `CancelQueryErrorKind::EventDataStoreNotFoundException`.
    pub fn is_event_data_store_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CancelQueryErrorKind::EventDataStoreNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `CancelQueryErrorKind::InactiveEventDataStoreException`.
    pub fn is_inactive_event_data_store_exception(&self) -> bool {
        matches!(
            &self.kind,
            CancelQueryErrorKind::InactiveEventDataStoreException(_)
        )
    }
    /// Returns `true` if the error kind is `CancelQueryErrorKind::InactiveQueryException`.
    pub fn is_inactive_query_exception(&self) -> bool {
        matches!(&self.kind, CancelQueryErrorKind::InactiveQueryException(_))
    }
    /// Returns `true` if the error kind is `CancelQueryErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            CancelQueryErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `CancelQueryErrorKind::OperationNotPermittedException`.
    pub fn is_operation_not_permitted_exception(&self) -> bool {
        matches!(
            &self.kind,
            CancelQueryErrorKind::OperationNotPermittedException(_)
        )
    }
    /// Returns `true` if the error kind is `CancelQueryErrorKind::QueryIdNotFoundException`.
    pub fn is_query_id_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CancelQueryErrorKind::QueryIdNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `CancelQueryErrorKind::UnsupportedOperationException`.
    pub fn is_unsupported_operation_exception(&self) -> bool {
        matches!(
            &self.kind,
            CancelQueryErrorKind::UnsupportedOperationException(_)
        )
    }
}
impl std::error::Error for CancelQueryError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CancelQueryErrorKind::ConflictException(_inner) => Some(_inner),
            CancelQueryErrorKind::EventDataStoreArnInvalidException(_inner) => Some(_inner),
            CancelQueryErrorKind::EventDataStoreNotFoundException(_inner) => Some(_inner),
            CancelQueryErrorKind::InactiveEventDataStoreException(_inner) => Some(_inner),
            CancelQueryErrorKind::InactiveQueryException(_inner) => Some(_inner),
            CancelQueryErrorKind::InvalidParameterException(_inner) => Some(_inner),
            CancelQueryErrorKind::OperationNotPermittedException(_inner) => Some(_inner),
            CancelQueryErrorKind::QueryIdNotFoundException(_inner) => Some(_inner),
            CancelQueryErrorKind::UnsupportedOperationException(_inner) => Some(_inner),
            CancelQueryErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateEventDataStore` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateEventDataStoreError {
    /// Kind of error that occurred.
    pub kind: CreateEventDataStoreErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateEventDataStore` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateEventDataStoreErrorKind {
    /// <p>This exception is thrown when trusted access has not been enabled between CloudTrail and Organizations. For more information, see <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_integrate_services.html">Enabling Trusted Access with Other Amazon Web Services Services</a> and <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/creating-an-organizational-trail-prepare.html">Prepare For Creating a Trail For Your Organization</a>. </p>
    CloudTrailAccessNotEnabledException(crate::error::CloudTrailAccessNotEnabledException),
    /// <p>This exception is thrown when the specified resource is not ready for an operation. This can occur when you try to run an operation on a trail before CloudTrail has time to fully load the trail. If this exception occurs, wait a few minutes, and then try the operation again.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>An event data store with that name already exists.</p>
    EventDataStoreAlreadyExistsException(crate::error::EventDataStoreAlreadyExistsException),
    /// <p>Your account has used the maximum number of event data stores.</p>
    EventDataStoreMaxLimitExceededException(crate::error::EventDataStoreMaxLimitExceededException),
    /// <p>This exception is thrown when the IAM user or role that is used to create the organization trail is lacking one or more required permissions for creating an organization trail in a required service. For more information, see <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/creating-an-organizational-trail-prepare.html">Prepare For Creating a Trail For Your Organization</a>.</p>
    InsufficientDependencyServiceAccessPermissionException(
        crate::error::InsufficientDependencyServiceAccessPermissionException,
    ),
    /// <p>The request includes a parameter that is not valid.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>This exception is thrown when the specified tag key or values are not valid. It can also occur if there are duplicate tags or too many tags on the resource.</p>
    InvalidTagParameterException(crate::error::InvalidTagParameterException),
    /// <p>This exception is thrown when the Amazon Web Services account making the request to create or update an organization trail is not the management account for an organization in Organizations. For more information, see <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/creating-an-organizational-trail-prepare.html">Prepare For Creating a Trail For Your Organization</a>.</p>
    NotOrganizationMasterAccountException(crate::error::NotOrganizationMasterAccountException),
    /// <p>This exception is thrown when the requested operation is not permitted.</p>
    OperationNotPermittedException(crate::error::OperationNotPermittedException),
    /// <p>This exception is thrown when Organizations is not configured to support all features. All features must be enabled in Organizations to support creating an organization trail. For more information, see <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/creating-an-organizational-trail-prepare.html">Prepare For Creating a Trail For Your Organization</a>.</p>
    OrganizationNotInAllFeaturesModeException(
        crate::error::OrganizationNotInAllFeaturesModeException,
    ),
    /// <p>This exception is thrown when the request is made from an Amazon Web Services account that is not a member of an organization. To make this request, sign in using the credentials of an account that belongs to an organization.</p>
    OrganizationsNotInUseException(crate::error::OrganizationsNotInUseException),
    /// <p>This exception is thrown when the requested operation is not supported.</p>
    UnsupportedOperationException(crate::error::UnsupportedOperationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateEventDataStoreError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateEventDataStoreErrorKind::CloudTrailAccessNotEnabledException(_inner) =>
            _inner.fmt(f)
            ,
            CreateEventDataStoreErrorKind::ConflictException(_inner) =>
            _inner.fmt(f)
            ,
            CreateEventDataStoreErrorKind::EventDataStoreAlreadyExistsException(_inner) =>
            _inner.fmt(f)
            ,
            CreateEventDataStoreErrorKind::EventDataStoreMaxLimitExceededException(_inner) =>
            _inner.fmt(f)
            ,
            CreateEventDataStoreErrorKind::InsufficientDependencyServiceAccessPermissionException(_inner) =>
            _inner.fmt(f)
            ,
            CreateEventDataStoreErrorKind::InvalidParameterException(_inner) =>
            _inner.fmt(f)
            ,
            CreateEventDataStoreErrorKind::InvalidTagParameterException(_inner) =>
            _inner.fmt(f)
            ,
            CreateEventDataStoreErrorKind::NotOrganizationMasterAccountException(_inner) =>
            _inner.fmt(f)
            ,
            CreateEventDataStoreErrorKind::OperationNotPermittedException(_inner) =>
            _inner.fmt(f)
            ,
            CreateEventDataStoreErrorKind::OrganizationNotInAllFeaturesModeException(_inner) =>
            _inner.fmt(f)
            ,
            CreateEventDataStoreErrorKind::OrganizationsNotInUseException(_inner) =>
            _inner.fmt(f)
            ,
            CreateEventDataStoreErrorKind::UnsupportedOperationException(_inner) =>
            _inner.fmt(f)
            ,
            CreateEventDataStoreErrorKind::Unhandled(_inner) => {
                _inner.fmt(f)
            }
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateEventDataStoreError {
    fn code(&self) -> Option<&str> {
        CreateEventDataStoreError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateEventDataStoreError {
    /// Creates a new `CreateEventDataStoreError`.
    pub fn new(kind: CreateEventDataStoreErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateEventDataStoreError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateEventDataStoreErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateEventDataStoreError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateEventDataStoreErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateEventDataStoreErrorKind::CloudTrailAccessNotEnabledException`.
    pub fn is_cloud_trail_access_not_enabled_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateEventDataStoreErrorKind::CloudTrailAccessNotEnabledException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateEventDataStoreErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateEventDataStoreErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateEventDataStoreErrorKind::EventDataStoreAlreadyExistsException`.
    pub fn is_event_data_store_already_exists_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateEventDataStoreErrorKind::EventDataStoreAlreadyExistsException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateEventDataStoreErrorKind::EventDataStoreMaxLimitExceededException`.
    pub fn is_event_data_store_max_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateEventDataStoreErrorKind::EventDataStoreMaxLimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateEventDataStoreErrorKind::InsufficientDependencyServiceAccessPermissionException`.
    pub fn is_insufficient_dependency_service_access_permission_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateEventDataStoreErrorKind::InsufficientDependencyServiceAccessPermissionException(
                _
            )
        )
    }
    /// Returns `true` if the error kind is `CreateEventDataStoreErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateEventDataStoreErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateEventDataStoreErrorKind::InvalidTagParameterException`.
    pub fn is_invalid_tag_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateEventDataStoreErrorKind::InvalidTagParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateEventDataStoreErrorKind::NotOrganizationMasterAccountException`.
    pub fn is_not_organization_master_account_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateEventDataStoreErrorKind::NotOrganizationMasterAccountException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateEventDataStoreErrorKind::OperationNotPermittedException`.
    pub fn is_operation_not_permitted_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateEventDataStoreErrorKind::OperationNotPermittedException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateEventDataStoreErrorKind::OrganizationNotInAllFeaturesModeException`.
    pub fn is_organization_not_in_all_features_mode_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateEventDataStoreErrorKind::OrganizationNotInAllFeaturesModeException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateEventDataStoreErrorKind::OrganizationsNotInUseException`.
    pub fn is_organizations_not_in_use_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateEventDataStoreErrorKind::OrganizationsNotInUseException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateEventDataStoreErrorKind::UnsupportedOperationException`.
    pub fn is_unsupported_operation_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateEventDataStoreErrorKind::UnsupportedOperationException(_)
        )
    }
}
impl std::error::Error for CreateEventDataStoreError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateEventDataStoreErrorKind::CloudTrailAccessNotEnabledException(_inner) =>
            Some(_inner)
            ,
            CreateEventDataStoreErrorKind::ConflictException(_inner) =>
            Some(_inner)
            ,
            CreateEventDataStoreErrorKind::EventDataStoreAlreadyExistsException(_inner) =>
            Some(_inner)
            ,
            CreateEventDataStoreErrorKind::EventDataStoreMaxLimitExceededException(_inner) =>
            Some(_inner)
            ,
            CreateEventDataStoreErrorKind::InsufficientDependencyServiceAccessPermissionException(_inner) =>
            Some(_inner)
            ,
            CreateEventDataStoreErrorKind::InvalidParameterException(_inner) =>
            Some(_inner)
            ,
            CreateEventDataStoreErrorKind::InvalidTagParameterException(_inner) =>
            Some(_inner)
            ,
            CreateEventDataStoreErrorKind::NotOrganizationMasterAccountException(_inner) =>
            Some(_inner)
            ,
            CreateEventDataStoreErrorKind::OperationNotPermittedException(_inner) =>
            Some(_inner)
            ,
            CreateEventDataStoreErrorKind::OrganizationNotInAllFeaturesModeException(_inner) =>
            Some(_inner)
            ,
            CreateEventDataStoreErrorKind::OrganizationsNotInUseException(_inner) =>
            Some(_inner)
            ,
            CreateEventDataStoreErrorKind::UnsupportedOperationException(_inner) =>
            Some(_inner)
            ,
            CreateEventDataStoreErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `CreateTrail` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateTrailError {
    /// Kind of error that occurred.
    pub kind: CreateTrailErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateTrail` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateTrailErrorKind {
    /// <p>This exception is thrown when trusted access has not been enabled between CloudTrail and Organizations. For more information, see <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_integrate_services.html">Enabling Trusted Access with Other Amazon Web Services Services</a> and <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/creating-an-organizational-trail-prepare.html">Prepare For Creating a Trail For Your Organization</a>. </p>
    CloudTrailAccessNotEnabledException(crate::error::CloudTrailAccessNotEnabledException),
    /// <p>This exception is thrown when a call results in the <code>InvalidClientTokenId</code> error code. This can occur when you are creating or updating a trail to send notifications to an Amazon SNS topic that is in a suspended Amazon Web Services account.</p>
    CloudTrailInvalidClientTokenIdException(crate::error::CloudTrailInvalidClientTokenIdException),
    /// <p>Cannot set a CloudWatch Logs delivery for this region.</p>
    CloudWatchLogsDeliveryUnavailableException(
        crate::error::CloudWatchLogsDeliveryUnavailableException,
    ),
    /// <p>This exception is thrown when the specified resource is not ready for an operation. This can occur when you try to run an operation on a trail before CloudTrail has time to fully load the trail. If this exception occurs, wait a few minutes, and then try the operation again.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>This exception is thrown when the IAM user or role that is used to create the organization trail is lacking one or more required permissions for creating an organization trail in a required service. For more information, see <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/creating-an-organizational-trail-prepare.html">Prepare For Creating a Trail For Your Organization</a>.</p>
    InsufficientDependencyServiceAccessPermissionException(
        crate::error::InsufficientDependencyServiceAccessPermissionException,
    ),
    /// <p>This exception is thrown when the policy on the S3 bucket or KMS key is not sufficient.</p>
    InsufficientEncryptionPolicyException(crate::error::InsufficientEncryptionPolicyException),
    /// <p>This exception is thrown when the policy on the S3 bucket is not sufficient.</p>
    InsufficientS3BucketPolicyException(crate::error::InsufficientS3BucketPolicyException),
    /// <p>This exception is thrown when the policy on the Amazon SNS topic is not sufficient.</p>
    InsufficientSnsTopicPolicyException(crate::error::InsufficientSnsTopicPolicyException),
    /// <p>This exception is thrown when the provided CloudWatch Logs log group is not valid.</p>
    InvalidCloudWatchLogsLogGroupArnException(
        crate::error::InvalidCloudWatchLogsLogGroupArnException,
    ),
    /// <p>This exception is thrown when the provided role is not valid.</p>
    InvalidCloudWatchLogsRoleArnException(crate::error::InvalidCloudWatchLogsRoleArnException),
    /// <p>This exception is thrown when the KMS key ARN is not valid.</p>
    InvalidKmsKeyIdException(crate::error::InvalidKmsKeyIdException),
    /// <p>This exception is thrown when the combination of parameters provided is not valid.</p>
    InvalidParameterCombinationException(crate::error::InvalidParameterCombinationException),
    /// <p>This exception is thrown when the provided S3 bucket name is not valid.</p>
    InvalidS3BucketNameException(crate::error::InvalidS3BucketNameException),
    /// <p>This exception is thrown when the provided S3 prefix is not valid.</p>
    InvalidS3PrefixException(crate::error::InvalidS3PrefixException),
    /// <p>This exception is thrown when the provided SNS topic name is not valid.</p>
    InvalidSnsTopicNameException(crate::error::InvalidSnsTopicNameException),
    /// <p>This exception is thrown when the specified tag key or values are not valid. It can also occur if there are duplicate tags or too many tags on the resource.</p>
    InvalidTagParameterException(crate::error::InvalidTagParameterException),
    /// <p>This exception is thrown when the provided trail name is not valid. Trail names must meet the following requirements:</p>
    /// <ul>
    /// <li> <p>Contain only ASCII letters (a-z, A-Z), numbers (0-9), periods (.), underscores (_), or dashes (-)</p> </li>
    /// <li> <p>Start with a letter or number, and end with a letter or number</p> </li>
    /// <li> <p>Be between 3 and 128 characters</p> </li>
    /// <li> <p>Have no adjacent periods, underscores or dashes. Names like <code>my-_namespace</code> and <code>my--namespace</code> are not valid.</p> </li>
    /// <li> <p>Not be in IP address format (for example, 192.168.5.4)</p> </li>
    /// </ul>
    InvalidTrailNameException(crate::error::InvalidTrailNameException),
    /// <p>This exception is thrown when there is an issue with the specified KMS key and the trail can’t be updated.</p>
    KmsException(crate::error::KmsException),
    /// <p>This exception is no longer in use.</p>
    KmsKeyDisabledException(crate::error::KmsKeyDisabledException),
    /// <p>This exception is thrown when the KMS key does not exist, when the S3 bucket and the KMS key are not in the same region, or when the KMS key associated with the Amazon SNS topic either does not exist or is not in the same region.</p>
    KmsKeyNotFoundException(crate::error::KmsKeyNotFoundException),
    /// <p>This exception is thrown when the maximum number of trails is reached.</p>
    MaximumNumberOfTrailsExceededException(crate::error::MaximumNumberOfTrailsExceededException),
    /// <p>This exception is thrown when the Amazon Web Services account making the request to create or update an organization trail is not the management account for an organization in Organizations. For more information, see <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/creating-an-organizational-trail-prepare.html">Prepare For Creating a Trail For Your Organization</a>.</p>
    NotOrganizationMasterAccountException(crate::error::NotOrganizationMasterAccountException),
    /// <p>This exception is thrown when the requested operation is not permitted.</p>
    OperationNotPermittedException(crate::error::OperationNotPermittedException),
    /// <p>This exception is thrown when Organizations is not configured to support all features. All features must be enabled in Organizations to support creating an organization trail. For more information, see <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/creating-an-organizational-trail-prepare.html">Prepare For Creating a Trail For Your Organization</a>.</p>
    OrganizationNotInAllFeaturesModeException(
        crate::error::OrganizationNotInAllFeaturesModeException,
    ),
    /// <p>This exception is thrown when the request is made from an Amazon Web Services account that is not a member of an organization. To make this request, sign in using the credentials of an account that belongs to an organization.</p>
    OrganizationsNotInUseException(crate::error::OrganizationsNotInUseException),
    /// <p>This exception is thrown when the specified S3 bucket does not exist.</p>
    S3BucketDoesNotExistException(crate::error::S3BucketDoesNotExistException),
    /// <p>This exception is thrown when the specified trail already exists.</p>
    TrailAlreadyExistsException(crate::error::TrailAlreadyExistsException),
    /// <p>This exception is no longer in use.</p>
    TrailNotProvidedException(crate::error::TrailNotProvidedException),
    /// <p>This exception is thrown when the requested operation is not supported.</p>
    UnsupportedOperationException(crate::error::UnsupportedOperationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateTrailError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateTrailErrorKind::CloudTrailAccessNotEnabledException(_inner) => _inner.fmt(f),
            CreateTrailErrorKind::CloudTrailInvalidClientTokenIdException(_inner) => _inner.fmt(f),
            CreateTrailErrorKind::CloudWatchLogsDeliveryUnavailableException(_inner) => {
                _inner.fmt(f)
            }
            CreateTrailErrorKind::ConflictException(_inner) => _inner.fmt(f),
            CreateTrailErrorKind::InsufficientDependencyServiceAccessPermissionException(
                _inner,
            ) => _inner.fmt(f),
            CreateTrailErrorKind::InsufficientEncryptionPolicyException(_inner) => _inner.fmt(f),
            CreateTrailErrorKind::InsufficientS3BucketPolicyException(_inner) => _inner.fmt(f),
            CreateTrailErrorKind::InsufficientSnsTopicPolicyException(_inner) => _inner.fmt(f),
            CreateTrailErrorKind::InvalidCloudWatchLogsLogGroupArnException(_inner) => {
                _inner.fmt(f)
            }
            CreateTrailErrorKind::InvalidCloudWatchLogsRoleArnException(_inner) => _inner.fmt(f),
            CreateTrailErrorKind::InvalidKmsKeyIdException(_inner) => _inner.fmt(f),
            CreateTrailErrorKind::InvalidParameterCombinationException(_inner) => _inner.fmt(f),
            CreateTrailErrorKind::InvalidS3BucketNameException(_inner) => _inner.fmt(f),
            CreateTrailErrorKind::InvalidS3PrefixException(_inner) => _inner.fmt(f),
            CreateTrailErrorKind::InvalidSnsTopicNameException(_inner) => _inner.fmt(f),
            CreateTrailErrorKind::InvalidTagParameterException(_inner) => _inner.fmt(f),
            CreateTrailErrorKind::InvalidTrailNameException(_inner) => _inner.fmt(f),
            CreateTrailErrorKind::KmsException(_inner) => _inner.fmt(f),
            CreateTrailErrorKind::KmsKeyDisabledException(_inner) => _inner.fmt(f),
            CreateTrailErrorKind::KmsKeyNotFoundException(_inner) => _inner.fmt(f),
            CreateTrailErrorKind::MaximumNumberOfTrailsExceededException(_inner) => _inner.fmt(f),
            CreateTrailErrorKind::NotOrganizationMasterAccountException(_inner) => _inner.fmt(f),
            CreateTrailErrorKind::OperationNotPermittedException(_inner) => _inner.fmt(f),
            CreateTrailErrorKind::OrganizationNotInAllFeaturesModeException(_inner) => {
                _inner.fmt(f)
            }
            CreateTrailErrorKind::OrganizationsNotInUseException(_inner) => _inner.fmt(f),
            CreateTrailErrorKind::S3BucketDoesNotExistException(_inner) => _inner.fmt(f),
            CreateTrailErrorKind::TrailAlreadyExistsException(_inner) => _inner.fmt(f),
            CreateTrailErrorKind::TrailNotProvidedException(_inner) => _inner.fmt(f),
            CreateTrailErrorKind::UnsupportedOperationException(_inner) => _inner.fmt(f),
            CreateTrailErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateTrailError {
    fn code(&self) -> Option<&str> {
        CreateTrailError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateTrailError {
    /// Creates a new `CreateTrailError`.
    pub fn new(kind: CreateTrailErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateTrailError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateTrailErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateTrailError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateTrailErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateTrailErrorKind::CloudTrailAccessNotEnabledException`.
    pub fn is_cloud_trail_access_not_enabled_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateTrailErrorKind::CloudTrailAccessNotEnabledException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateTrailErrorKind::CloudTrailInvalidClientTokenIdException`.
    pub fn is_cloud_trail_invalid_client_token_id_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateTrailErrorKind::CloudTrailInvalidClientTokenIdException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateTrailErrorKind::CloudWatchLogsDeliveryUnavailableException`.
    pub fn is_cloud_watch_logs_delivery_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateTrailErrorKind::CloudWatchLogsDeliveryUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateTrailErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, CreateTrailErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `CreateTrailErrorKind::InsufficientDependencyServiceAccessPermissionException`.
    pub fn is_insufficient_dependency_service_access_permission_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateTrailErrorKind::InsufficientDependencyServiceAccessPermissionException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateTrailErrorKind::InsufficientEncryptionPolicyException`.
    pub fn is_insufficient_encryption_policy_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateTrailErrorKind::InsufficientEncryptionPolicyException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateTrailErrorKind::InsufficientS3BucketPolicyException`.
    pub fn is_insufficient_s3_bucket_policy_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateTrailErrorKind::InsufficientS3BucketPolicyException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateTrailErrorKind::InsufficientSnsTopicPolicyException`.
    pub fn is_insufficient_sns_topic_policy_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateTrailErrorKind::InsufficientSnsTopicPolicyException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateTrailErrorKind::InvalidCloudWatchLogsLogGroupArnException`.
    pub fn is_invalid_cloud_watch_logs_log_group_arn_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateTrailErrorKind::InvalidCloudWatchLogsLogGroupArnException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateTrailErrorKind::InvalidCloudWatchLogsRoleArnException`.
    pub fn is_invalid_cloud_watch_logs_role_arn_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateTrailErrorKind::InvalidCloudWatchLogsRoleArnException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateTrailErrorKind::InvalidKmsKeyIdException`.
    pub fn is_invalid_kms_key_id_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateTrailErrorKind::InvalidKmsKeyIdException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateTrailErrorKind::InvalidParameterCombinationException`.
    pub fn is_invalid_parameter_combination_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateTrailErrorKind::InvalidParameterCombinationException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateTrailErrorKind::InvalidS3BucketNameException`.
    pub fn is_invalid_s3_bucket_name_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateTrailErrorKind::InvalidS3BucketNameException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateTrailErrorKind::InvalidS3PrefixException`.
    pub fn is_invalid_s3_prefix_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateTrailErrorKind::InvalidS3PrefixException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateTrailErrorKind::InvalidSnsTopicNameException`.
    pub fn is_invalid_sns_topic_name_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateTrailErrorKind::InvalidSnsTopicNameException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateTrailErrorKind::InvalidTagParameterException`.
    pub fn is_invalid_tag_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateTrailErrorKind::InvalidTagParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateTrailErrorKind::InvalidTrailNameException`.
    pub fn is_invalid_trail_name_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateTrailErrorKind::InvalidTrailNameException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateTrailErrorKind::KmsException`.
    pub fn is_kms_exception(&self) -> bool {
        matches!(&self.kind, CreateTrailErrorKind::KmsException(_))
    }
    /// Returns `true` if the error kind is `CreateTrailErrorKind::KmsKeyDisabledException`.
    pub fn is_kms_key_disabled_exception(&self) -> bool {
        matches!(&self.kind, CreateTrailErrorKind::KmsKeyDisabledException(_))
    }
    /// Returns `true` if the error kind is `CreateTrailErrorKind::KmsKeyNotFoundException`.
    pub fn is_kms_key_not_found_exception(&self) -> bool {
        matches!(&self.kind, CreateTrailErrorKind::KmsKeyNotFoundException(_))
    }
    /// Returns `true` if the error kind is `CreateTrailErrorKind::MaximumNumberOfTrailsExceededException`.
    pub fn is_maximum_number_of_trails_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateTrailErrorKind::MaximumNumberOfTrailsExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateTrailErrorKind::NotOrganizationMasterAccountException`.
    pub fn is_not_organization_master_account_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateTrailErrorKind::NotOrganizationMasterAccountException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateTrailErrorKind::OperationNotPermittedException`.
    pub fn is_operation_not_permitted_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateTrailErrorKind::OperationNotPermittedException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateTrailErrorKind::OrganizationNotInAllFeaturesModeException`.
    pub fn is_organization_not_in_all_features_mode_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateTrailErrorKind::OrganizationNotInAllFeaturesModeException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateTrailErrorKind::OrganizationsNotInUseException`.
    pub fn is_organizations_not_in_use_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateTrailErrorKind::OrganizationsNotInUseException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateTrailErrorKind::S3BucketDoesNotExistException`.
    pub fn is_s3_bucket_does_not_exist_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateTrailErrorKind::S3BucketDoesNotExistException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateTrailErrorKind::TrailAlreadyExistsException`.
    pub fn is_trail_already_exists_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateTrailErrorKind::TrailAlreadyExistsException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateTrailErrorKind::TrailNotProvidedException`.
    pub fn is_trail_not_provided_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateTrailErrorKind::TrailNotProvidedException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateTrailErrorKind::UnsupportedOperationException`.
    pub fn is_unsupported_operation_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateTrailErrorKind::UnsupportedOperationException(_)
        )
    }
}
impl std::error::Error for CreateTrailError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateTrailErrorKind::CloudTrailAccessNotEnabledException(_inner) => Some(_inner),
            CreateTrailErrorKind::CloudTrailInvalidClientTokenIdException(_inner) => Some(_inner),
            CreateTrailErrorKind::CloudWatchLogsDeliveryUnavailableException(_inner) => {
                Some(_inner)
            }
            CreateTrailErrorKind::ConflictException(_inner) => Some(_inner),
            CreateTrailErrorKind::InsufficientDependencyServiceAccessPermissionException(
                _inner,
            ) => Some(_inner),
            CreateTrailErrorKind::InsufficientEncryptionPolicyException(_inner) => Some(_inner),
            CreateTrailErrorKind::InsufficientS3BucketPolicyException(_inner) => Some(_inner),
            CreateTrailErrorKind::InsufficientSnsTopicPolicyException(_inner) => Some(_inner),
            CreateTrailErrorKind::InvalidCloudWatchLogsLogGroupArnException(_inner) => Some(_inner),
            CreateTrailErrorKind::InvalidCloudWatchLogsRoleArnException(_inner) => Some(_inner),
            CreateTrailErrorKind::InvalidKmsKeyIdException(_inner) => Some(_inner),
            CreateTrailErrorKind::InvalidParameterCombinationException(_inner) => Some(_inner),
            CreateTrailErrorKind::InvalidS3BucketNameException(_inner) => Some(_inner),
            CreateTrailErrorKind::InvalidS3PrefixException(_inner) => Some(_inner),
            CreateTrailErrorKind::InvalidSnsTopicNameException(_inner) => Some(_inner),
            CreateTrailErrorKind::InvalidTagParameterException(_inner) => Some(_inner),
            CreateTrailErrorKind::InvalidTrailNameException(_inner) => Some(_inner),
            CreateTrailErrorKind::KmsException(_inner) => Some(_inner),
            CreateTrailErrorKind::KmsKeyDisabledException(_inner) => Some(_inner),
            CreateTrailErrorKind::KmsKeyNotFoundException(_inner) => Some(_inner),
            CreateTrailErrorKind::MaximumNumberOfTrailsExceededException(_inner) => Some(_inner),
            CreateTrailErrorKind::NotOrganizationMasterAccountException(_inner) => Some(_inner),
            CreateTrailErrorKind::OperationNotPermittedException(_inner) => Some(_inner),
            CreateTrailErrorKind::OrganizationNotInAllFeaturesModeException(_inner) => Some(_inner),
            CreateTrailErrorKind::OrganizationsNotInUseException(_inner) => Some(_inner),
            CreateTrailErrorKind::S3BucketDoesNotExistException(_inner) => Some(_inner),
            CreateTrailErrorKind::TrailAlreadyExistsException(_inner) => Some(_inner),
            CreateTrailErrorKind::TrailNotProvidedException(_inner) => Some(_inner),
            CreateTrailErrorKind::UnsupportedOperationException(_inner) => Some(_inner),
            CreateTrailErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteEventDataStore` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteEventDataStoreError {
    /// Kind of error that occurred.
    pub kind: DeleteEventDataStoreErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteEventDataStore` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteEventDataStoreErrorKind {
    /// <p>The specified event data store ARN is not valid or does not map to an event data store in your account.</p>
    EventDataStoreArnInvalidException(crate::error::EventDataStoreArnInvalidException),
    /// <p>The specified event data store was not found.</p>
    EventDataStoreNotFoundException(crate::error::EventDataStoreNotFoundException),
    /// <p>The event data store cannot be deleted because termination protection is enabled for it.</p>
    EventDataStoreTerminationProtectedException(
        crate::error::EventDataStoreTerminationProtectedException,
    ),
    /// <p>This exception is thrown when the IAM user or role that is used to create the organization trail is lacking one or more required permissions for creating an organization trail in a required service. For more information, see <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/creating-an-organizational-trail-prepare.html">Prepare For Creating a Trail For Your Organization</a>.</p>
    InsufficientDependencyServiceAccessPermissionException(
        crate::error::InsufficientDependencyServiceAccessPermissionException,
    ),
    /// <p>The request includes a parameter that is not valid.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>This exception is thrown when the Amazon Web Services account making the request to create or update an organization trail is not the management account for an organization in Organizations. For more information, see <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/creating-an-organizational-trail-prepare.html">Prepare For Creating a Trail For Your Organization</a>.</p>
    NotOrganizationMasterAccountException(crate::error::NotOrganizationMasterAccountException),
    /// <p>This exception is thrown when the requested operation is not permitted.</p>
    OperationNotPermittedException(crate::error::OperationNotPermittedException),
    /// <p>This exception is thrown when the requested operation is not supported.</p>
    UnsupportedOperationException(crate::error::UnsupportedOperationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteEventDataStoreError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteEventDataStoreErrorKind::EventDataStoreArnInvalidException(_inner) =>
            _inner.fmt(f)
            ,
            DeleteEventDataStoreErrorKind::EventDataStoreNotFoundException(_inner) =>
            _inner.fmt(f)
            ,
            DeleteEventDataStoreErrorKind::EventDataStoreTerminationProtectedException(_inner) =>
            _inner.fmt(f)
            ,
            DeleteEventDataStoreErrorKind::InsufficientDependencyServiceAccessPermissionException(_inner) =>
            _inner.fmt(f)
            ,
            DeleteEventDataStoreErrorKind::InvalidParameterException(_inner) =>
            _inner.fmt(f)
            ,
            DeleteEventDataStoreErrorKind::NotOrganizationMasterAccountException(_inner) =>
            _inner.fmt(f)
            ,
            DeleteEventDataStoreErrorKind::OperationNotPermittedException(_inner) =>
            _inner.fmt(f)
            ,
            DeleteEventDataStoreErrorKind::UnsupportedOperationException(_inner) =>
            _inner.fmt(f)
            ,
            DeleteEventDataStoreErrorKind::Unhandled(_inner) => {
                _inner.fmt(f)
            }
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteEventDataStoreError {
    fn code(&self) -> Option<&str> {
        DeleteEventDataStoreError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteEventDataStoreError {
    /// Creates a new `DeleteEventDataStoreError`.
    pub fn new(kind: DeleteEventDataStoreErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteEventDataStoreError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteEventDataStoreErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteEventDataStoreError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteEventDataStoreErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteEventDataStoreErrorKind::EventDataStoreArnInvalidException`.
    pub fn is_event_data_store_arn_invalid_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteEventDataStoreErrorKind::EventDataStoreArnInvalidException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteEventDataStoreErrorKind::EventDataStoreNotFoundException`.
    pub fn is_event_data_store_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteEventDataStoreErrorKind::EventDataStoreNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteEventDataStoreErrorKind::EventDataStoreTerminationProtectedException`.
    pub fn is_event_data_store_termination_protected_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteEventDataStoreErrorKind::EventDataStoreTerminationProtectedException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteEventDataStoreErrorKind::InsufficientDependencyServiceAccessPermissionException`.
    pub fn is_insufficient_dependency_service_access_permission_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteEventDataStoreErrorKind::InsufficientDependencyServiceAccessPermissionException(
                _
            )
        )
    }
    /// Returns `true` if the error kind is `DeleteEventDataStoreErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteEventDataStoreErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteEventDataStoreErrorKind::NotOrganizationMasterAccountException`.
    pub fn is_not_organization_master_account_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteEventDataStoreErrorKind::NotOrganizationMasterAccountException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteEventDataStoreErrorKind::OperationNotPermittedException`.
    pub fn is_operation_not_permitted_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteEventDataStoreErrorKind::OperationNotPermittedException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteEventDataStoreErrorKind::UnsupportedOperationException`.
    pub fn is_unsupported_operation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteEventDataStoreErrorKind::UnsupportedOperationException(_)
        )
    }
}
impl std::error::Error for DeleteEventDataStoreError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteEventDataStoreErrorKind::EventDataStoreArnInvalidException(_inner) =>
            Some(_inner)
            ,
            DeleteEventDataStoreErrorKind::EventDataStoreNotFoundException(_inner) =>
            Some(_inner)
            ,
            DeleteEventDataStoreErrorKind::EventDataStoreTerminationProtectedException(_inner) =>
            Some(_inner)
            ,
            DeleteEventDataStoreErrorKind::InsufficientDependencyServiceAccessPermissionException(_inner) =>
            Some(_inner)
            ,
            DeleteEventDataStoreErrorKind::InvalidParameterException(_inner) =>
            Some(_inner)
            ,
            DeleteEventDataStoreErrorKind::NotOrganizationMasterAccountException(_inner) =>
            Some(_inner)
            ,
            DeleteEventDataStoreErrorKind::OperationNotPermittedException(_inner) =>
            Some(_inner)
            ,
            DeleteEventDataStoreErrorKind::UnsupportedOperationException(_inner) =>
            Some(_inner)
            ,
            DeleteEventDataStoreErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `DeleteTrail` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteTrailError {
    /// Kind of error that occurred.
    pub kind: DeleteTrailErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteTrail` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteTrailErrorKind {
    /// <p>This exception is thrown when the specified resource is not ready for an operation. This can occur when you try to run an operation on a trail before CloudTrail has time to fully load the trail. If this exception occurs, wait a few minutes, and then try the operation again.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>This exception is thrown when the IAM user or role that is used to create the organization trail is lacking one or more required permissions for creating an organization trail in a required service. For more information, see <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/creating-an-organizational-trail-prepare.html">Prepare For Creating a Trail For Your Organization</a>.</p>
    InsufficientDependencyServiceAccessPermissionException(
        crate::error::InsufficientDependencyServiceAccessPermissionException,
    ),
    /// <p>This exception is thrown when an operation is called on a trail from a region other than the region in which the trail was created.</p>
    InvalidHomeRegionException(crate::error::InvalidHomeRegionException),
    /// <p>This exception is thrown when the provided trail name is not valid. Trail names must meet the following requirements:</p>
    /// <ul>
    /// <li> <p>Contain only ASCII letters (a-z, A-Z), numbers (0-9), periods (.), underscores (_), or dashes (-)</p> </li>
    /// <li> <p>Start with a letter or number, and end with a letter or number</p> </li>
    /// <li> <p>Be between 3 and 128 characters</p> </li>
    /// <li> <p>Have no adjacent periods, underscores or dashes. Names like <code>my-_namespace</code> and <code>my--namespace</code> are not valid.</p> </li>
    /// <li> <p>Not be in IP address format (for example, 192.168.5.4)</p> </li>
    /// </ul>
    InvalidTrailNameException(crate::error::InvalidTrailNameException),
    /// <p>This exception is thrown when the Amazon Web Services account making the request to create or update an organization trail is not the management account for an organization in Organizations. For more information, see <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/creating-an-organizational-trail-prepare.html">Prepare For Creating a Trail For Your Organization</a>.</p>
    NotOrganizationMasterAccountException(crate::error::NotOrganizationMasterAccountException),
    /// <p>This exception is thrown when the requested operation is not permitted.</p>
    OperationNotPermittedException(crate::error::OperationNotPermittedException),
    /// <p>This exception is thrown when the trail with the given name is not found.</p>
    TrailNotFoundException(crate::error::TrailNotFoundException),
    /// <p>This exception is thrown when the requested operation is not supported.</p>
    UnsupportedOperationException(crate::error::UnsupportedOperationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteTrailError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteTrailErrorKind::ConflictException(_inner) => _inner.fmt(f),
            DeleteTrailErrorKind::InsufficientDependencyServiceAccessPermissionException(
                _inner,
            ) => _inner.fmt(f),
            DeleteTrailErrorKind::InvalidHomeRegionException(_inner) => _inner.fmt(f),
            DeleteTrailErrorKind::InvalidTrailNameException(_inner) => _inner.fmt(f),
            DeleteTrailErrorKind::NotOrganizationMasterAccountException(_inner) => _inner.fmt(f),
            DeleteTrailErrorKind::OperationNotPermittedException(_inner) => _inner.fmt(f),
            DeleteTrailErrorKind::TrailNotFoundException(_inner) => _inner.fmt(f),
            DeleteTrailErrorKind::UnsupportedOperationException(_inner) => _inner.fmt(f),
            DeleteTrailErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteTrailError {
    fn code(&self) -> Option<&str> {
        DeleteTrailError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteTrailError {
    /// Creates a new `DeleteTrailError`.
    pub fn new(kind: DeleteTrailErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteTrailError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteTrailErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteTrailError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteTrailErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteTrailErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, DeleteTrailErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `DeleteTrailErrorKind::InsufficientDependencyServiceAccessPermissionException`.
    pub fn is_insufficient_dependency_service_access_permission_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteTrailErrorKind::InsufficientDependencyServiceAccessPermissionException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteTrailErrorKind::InvalidHomeRegionException`.
    pub fn is_invalid_home_region_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteTrailErrorKind::InvalidHomeRegionException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteTrailErrorKind::InvalidTrailNameException`.
    pub fn is_invalid_trail_name_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteTrailErrorKind::InvalidTrailNameException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteTrailErrorKind::NotOrganizationMasterAccountException`.
    pub fn is_not_organization_master_account_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteTrailErrorKind::NotOrganizationMasterAccountException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteTrailErrorKind::OperationNotPermittedException`.
    pub fn is_operation_not_permitted_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteTrailErrorKind::OperationNotPermittedException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteTrailErrorKind::TrailNotFoundException`.
    pub fn is_trail_not_found_exception(&self) -> bool {
        matches!(&self.kind, DeleteTrailErrorKind::TrailNotFoundException(_))
    }
    /// Returns `true` if the error kind is `DeleteTrailErrorKind::UnsupportedOperationException`.
    pub fn is_unsupported_operation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteTrailErrorKind::UnsupportedOperationException(_)
        )
    }
}
impl std::error::Error for DeleteTrailError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteTrailErrorKind::ConflictException(_inner) => Some(_inner),
            DeleteTrailErrorKind::InsufficientDependencyServiceAccessPermissionException(
                _inner,
            ) => Some(_inner),
            DeleteTrailErrorKind::InvalidHomeRegionException(_inner) => Some(_inner),
            DeleteTrailErrorKind::InvalidTrailNameException(_inner) => Some(_inner),
            DeleteTrailErrorKind::NotOrganizationMasterAccountException(_inner) => Some(_inner),
            DeleteTrailErrorKind::OperationNotPermittedException(_inner) => Some(_inner),
            DeleteTrailErrorKind::TrailNotFoundException(_inner) => Some(_inner),
            DeleteTrailErrorKind::UnsupportedOperationException(_inner) => Some(_inner),
            DeleteTrailErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeQuery` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeQueryError {
    /// Kind of error that occurred.
    pub kind: DescribeQueryErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeQuery` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeQueryErrorKind {
    /// <p>The specified event data store ARN is not valid or does not map to an event data store in your account.</p>
    EventDataStoreArnInvalidException(crate::error::EventDataStoreArnInvalidException),
    /// <p>The specified event data store was not found.</p>
    EventDataStoreNotFoundException(crate::error::EventDataStoreNotFoundException),
    /// <p>The event data store against which you ran your query is inactive.</p>
    InactiveEventDataStoreException(crate::error::InactiveEventDataStoreException),
    /// <p>The request includes a parameter that is not valid.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>This exception is thrown when the requested operation is not permitted.</p>
    OperationNotPermittedException(crate::error::OperationNotPermittedException),
    /// <p>The query ID does not exist or does not map to a query.</p>
    QueryIdNotFoundException(crate::error::QueryIdNotFoundException),
    /// <p>This exception is thrown when the requested operation is not supported.</p>
    UnsupportedOperationException(crate::error::UnsupportedOperationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeQueryError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeQueryErrorKind::EventDataStoreArnInvalidException(_inner) => _inner.fmt(f),
            DescribeQueryErrorKind::EventDataStoreNotFoundException(_inner) => _inner.fmt(f),
            DescribeQueryErrorKind::InactiveEventDataStoreException(_inner) => _inner.fmt(f),
            DescribeQueryErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            DescribeQueryErrorKind::OperationNotPermittedException(_inner) => _inner.fmt(f),
            DescribeQueryErrorKind::QueryIdNotFoundException(_inner) => _inner.fmt(f),
            DescribeQueryErrorKind::UnsupportedOperationException(_inner) => _inner.fmt(f),
            DescribeQueryErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeQueryError {
    fn code(&self) -> Option<&str> {
        DescribeQueryError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeQueryError {
    /// Creates a new `DescribeQueryError`.
    pub fn new(kind: DescribeQueryErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeQueryError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeQueryErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeQueryError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeQueryErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeQueryErrorKind::EventDataStoreArnInvalidException`.
    pub fn is_event_data_store_arn_invalid_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeQueryErrorKind::EventDataStoreArnInvalidException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeQueryErrorKind::EventDataStoreNotFoundException`.
    pub fn is_event_data_store_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeQueryErrorKind::EventDataStoreNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeQueryErrorKind::InactiveEventDataStoreException`.
    pub fn is_inactive_event_data_store_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeQueryErrorKind::InactiveEventDataStoreException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeQueryErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeQueryErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeQueryErrorKind::OperationNotPermittedException`.
    pub fn is_operation_not_permitted_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeQueryErrorKind::OperationNotPermittedException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeQueryErrorKind::QueryIdNotFoundException`.
    pub fn is_query_id_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeQueryErrorKind::QueryIdNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeQueryErrorKind::UnsupportedOperationException`.
    pub fn is_unsupported_operation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeQueryErrorKind::UnsupportedOperationException(_)
        )
    }
}
impl std::error::Error for DescribeQueryError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeQueryErrorKind::EventDataStoreArnInvalidException(_inner) => Some(_inner),
            DescribeQueryErrorKind::EventDataStoreNotFoundException(_inner) => Some(_inner),
            DescribeQueryErrorKind::InactiveEventDataStoreException(_inner) => Some(_inner),
            DescribeQueryErrorKind::InvalidParameterException(_inner) => Some(_inner),
            DescribeQueryErrorKind::OperationNotPermittedException(_inner) => Some(_inner),
            DescribeQueryErrorKind::QueryIdNotFoundException(_inner) => Some(_inner),
            DescribeQueryErrorKind::UnsupportedOperationException(_inner) => Some(_inner),
            DescribeQueryErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeTrails` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeTrailsError {
    /// Kind of error that occurred.
    pub kind: DescribeTrailsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeTrails` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeTrailsErrorKind {
    /// <p>This exception is thrown when the provided trail name is not valid. Trail names must meet the following requirements:</p>
    /// <ul>
    /// <li> <p>Contain only ASCII letters (a-z, A-Z), numbers (0-9), periods (.), underscores (_), or dashes (-)</p> </li>
    /// <li> <p>Start with a letter or number, and end with a letter or number</p> </li>
    /// <li> <p>Be between 3 and 128 characters</p> </li>
    /// <li> <p>Have no adjacent periods, underscores or dashes. Names like <code>my-_namespace</code> and <code>my--namespace</code> are not valid.</p> </li>
    /// <li> <p>Not be in IP address format (for example, 192.168.5.4)</p> </li>
    /// </ul>
    InvalidTrailNameException(crate::error::InvalidTrailNameException),
    /// <p>This exception is thrown when the requested operation is not permitted.</p>
    OperationNotPermittedException(crate::error::OperationNotPermittedException),
    /// <p>This exception is thrown when the requested operation is not supported.</p>
    UnsupportedOperationException(crate::error::UnsupportedOperationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeTrailsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeTrailsErrorKind::InvalidTrailNameException(_inner) => _inner.fmt(f),
            DescribeTrailsErrorKind::OperationNotPermittedException(_inner) => _inner.fmt(f),
            DescribeTrailsErrorKind::UnsupportedOperationException(_inner) => _inner.fmt(f),
            DescribeTrailsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeTrailsError {
    fn code(&self) -> Option<&str> {
        DescribeTrailsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeTrailsError {
    /// Creates a new `DescribeTrailsError`.
    pub fn new(kind: DescribeTrailsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeTrailsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeTrailsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeTrailsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeTrailsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeTrailsErrorKind::InvalidTrailNameException`.
    pub fn is_invalid_trail_name_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeTrailsErrorKind::InvalidTrailNameException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeTrailsErrorKind::OperationNotPermittedException`.
    pub fn is_operation_not_permitted_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeTrailsErrorKind::OperationNotPermittedException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeTrailsErrorKind::UnsupportedOperationException`.
    pub fn is_unsupported_operation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeTrailsErrorKind::UnsupportedOperationException(_)
        )
    }
}
impl std::error::Error for DescribeTrailsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeTrailsErrorKind::InvalidTrailNameException(_inner) => Some(_inner),
            DescribeTrailsErrorKind::OperationNotPermittedException(_inner) => Some(_inner),
            DescribeTrailsErrorKind::UnsupportedOperationException(_inner) => Some(_inner),
            DescribeTrailsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetEventDataStore` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetEventDataStoreError {
    /// Kind of error that occurred.
    pub kind: GetEventDataStoreErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetEventDataStore` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetEventDataStoreErrorKind {
    /// <p>The specified event data store ARN is not valid or does not map to an event data store in your account.</p>
    EventDataStoreArnInvalidException(crate::error::EventDataStoreArnInvalidException),
    /// <p>The specified event data store was not found.</p>
    EventDataStoreNotFoundException(crate::error::EventDataStoreNotFoundException),
    /// <p>The request includes a parameter that is not valid.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>This exception is thrown when the requested operation is not permitted.</p>
    OperationNotPermittedException(crate::error::OperationNotPermittedException),
    /// <p>This exception is thrown when the requested operation is not supported.</p>
    UnsupportedOperationException(crate::error::UnsupportedOperationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetEventDataStoreError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetEventDataStoreErrorKind::EventDataStoreArnInvalidException(_inner) => _inner.fmt(f),
            GetEventDataStoreErrorKind::EventDataStoreNotFoundException(_inner) => _inner.fmt(f),
            GetEventDataStoreErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            GetEventDataStoreErrorKind::OperationNotPermittedException(_inner) => _inner.fmt(f),
            GetEventDataStoreErrorKind::UnsupportedOperationException(_inner) => _inner.fmt(f),
            GetEventDataStoreErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetEventDataStoreError {
    fn code(&self) -> Option<&str> {
        GetEventDataStoreError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetEventDataStoreError {
    /// Creates a new `GetEventDataStoreError`.
    pub fn new(kind: GetEventDataStoreErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetEventDataStoreError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetEventDataStoreErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetEventDataStoreError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetEventDataStoreErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetEventDataStoreErrorKind::EventDataStoreArnInvalidException`.
    pub fn is_event_data_store_arn_invalid_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetEventDataStoreErrorKind::EventDataStoreArnInvalidException(_)
        )
    }
    /// Returns `true` if the error kind is `GetEventDataStoreErrorKind::EventDataStoreNotFoundException`.
    pub fn is_event_data_store_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetEventDataStoreErrorKind::EventDataStoreNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetEventDataStoreErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetEventDataStoreErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `GetEventDataStoreErrorKind::OperationNotPermittedException`.
    pub fn is_operation_not_permitted_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetEventDataStoreErrorKind::OperationNotPermittedException(_)
        )
    }
    /// Returns `true` if the error kind is `GetEventDataStoreErrorKind::UnsupportedOperationException`.
    pub fn is_unsupported_operation_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetEventDataStoreErrorKind::UnsupportedOperationException(_)
        )
    }
}
impl std::error::Error for GetEventDataStoreError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetEventDataStoreErrorKind::EventDataStoreArnInvalidException(_inner) => Some(_inner),
            GetEventDataStoreErrorKind::EventDataStoreNotFoundException(_inner) => Some(_inner),
            GetEventDataStoreErrorKind::InvalidParameterException(_inner) => Some(_inner),
            GetEventDataStoreErrorKind::OperationNotPermittedException(_inner) => Some(_inner),
            GetEventDataStoreErrorKind::UnsupportedOperationException(_inner) => Some(_inner),
            GetEventDataStoreErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetEventSelectors` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetEventSelectorsError {
    /// Kind of error that occurred.
    pub kind: GetEventSelectorsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetEventSelectors` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetEventSelectorsErrorKind {
    /// <p>This exception is thrown when the provided trail name is not valid. Trail names must meet the following requirements:</p>
    /// <ul>
    /// <li> <p>Contain only ASCII letters (a-z, A-Z), numbers (0-9), periods (.), underscores (_), or dashes (-)</p> </li>
    /// <li> <p>Start with a letter or number, and end with a letter or number</p> </li>
    /// <li> <p>Be between 3 and 128 characters</p> </li>
    /// <li> <p>Have no adjacent periods, underscores or dashes. Names like <code>my-_namespace</code> and <code>my--namespace</code> are not valid.</p> </li>
    /// <li> <p>Not be in IP address format (for example, 192.168.5.4)</p> </li>
    /// </ul>
    InvalidTrailNameException(crate::error::InvalidTrailNameException),
    /// <p>This exception is thrown when the requested operation is not permitted.</p>
    OperationNotPermittedException(crate::error::OperationNotPermittedException),
    /// <p>This exception is thrown when the trail with the given name is not found.</p>
    TrailNotFoundException(crate::error::TrailNotFoundException),
    /// <p>This exception is thrown when the requested operation is not supported.</p>
    UnsupportedOperationException(crate::error::UnsupportedOperationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetEventSelectorsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetEventSelectorsErrorKind::InvalidTrailNameException(_inner) => _inner.fmt(f),
            GetEventSelectorsErrorKind::OperationNotPermittedException(_inner) => _inner.fmt(f),
            GetEventSelectorsErrorKind::TrailNotFoundException(_inner) => _inner.fmt(f),
            GetEventSelectorsErrorKind::UnsupportedOperationException(_inner) => _inner.fmt(f),
            GetEventSelectorsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetEventSelectorsError {
    fn code(&self) -> Option<&str> {
        GetEventSelectorsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetEventSelectorsError {
    /// Creates a new `GetEventSelectorsError`.
    pub fn new(kind: GetEventSelectorsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetEventSelectorsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetEventSelectorsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetEventSelectorsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetEventSelectorsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetEventSelectorsErrorKind::InvalidTrailNameException`.
    pub fn is_invalid_trail_name_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetEventSelectorsErrorKind::InvalidTrailNameException(_)
        )
    }
    /// Returns `true` if the error kind is `GetEventSelectorsErrorKind::OperationNotPermittedException`.
    pub fn is_operation_not_permitted_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetEventSelectorsErrorKind::OperationNotPermittedException(_)
        )
    }
    /// Returns `true` if the error kind is `GetEventSelectorsErrorKind::TrailNotFoundException`.
    pub fn is_trail_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetEventSelectorsErrorKind::TrailNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetEventSelectorsErrorKind::UnsupportedOperationException`.
    pub fn is_unsupported_operation_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetEventSelectorsErrorKind::UnsupportedOperationException(_)
        )
    }
}
impl std::error::Error for GetEventSelectorsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetEventSelectorsErrorKind::InvalidTrailNameException(_inner) => Some(_inner),
            GetEventSelectorsErrorKind::OperationNotPermittedException(_inner) => Some(_inner),
            GetEventSelectorsErrorKind::TrailNotFoundException(_inner) => Some(_inner),
            GetEventSelectorsErrorKind::UnsupportedOperationException(_inner) => Some(_inner),
            GetEventSelectorsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetInsightSelectors` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetInsightSelectorsError {
    /// Kind of error that occurred.
    pub kind: GetInsightSelectorsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetInsightSelectors` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetInsightSelectorsErrorKind {
    /// <p>If you run <code>GetInsightSelectors</code> on a trail that does not have Insights events enabled, the operation throws the exception <code>InsightNotEnabledException</code>.</p>
    InsightNotEnabledException(crate::error::InsightNotEnabledException),
    /// <p>This exception is thrown when the provided trail name is not valid. Trail names must meet the following requirements:</p>
    /// <ul>
    /// <li> <p>Contain only ASCII letters (a-z, A-Z), numbers (0-9), periods (.), underscores (_), or dashes (-)</p> </li>
    /// <li> <p>Start with a letter or number, and end with a letter or number</p> </li>
    /// <li> <p>Be between 3 and 128 characters</p> </li>
    /// <li> <p>Have no adjacent periods, underscores or dashes. Names like <code>my-_namespace</code> and <code>my--namespace</code> are not valid.</p> </li>
    /// <li> <p>Not be in IP address format (for example, 192.168.5.4)</p> </li>
    /// </ul>
    InvalidTrailNameException(crate::error::InvalidTrailNameException),
    /// <p>This exception is thrown when the requested operation is not permitted.</p>
    OperationNotPermittedException(crate::error::OperationNotPermittedException),
    /// <p>This exception is thrown when the trail with the given name is not found.</p>
    TrailNotFoundException(crate::error::TrailNotFoundException),
    /// <p>This exception is thrown when the requested operation is not supported.</p>
    UnsupportedOperationException(crate::error::UnsupportedOperationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetInsightSelectorsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetInsightSelectorsErrorKind::InsightNotEnabledException(_inner) => _inner.fmt(f),
            GetInsightSelectorsErrorKind::InvalidTrailNameException(_inner) => _inner.fmt(f),
            GetInsightSelectorsErrorKind::OperationNotPermittedException(_inner) => _inner.fmt(f),
            GetInsightSelectorsErrorKind::TrailNotFoundException(_inner) => _inner.fmt(f),
            GetInsightSelectorsErrorKind::UnsupportedOperationException(_inner) => _inner.fmt(f),
            GetInsightSelectorsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetInsightSelectorsError {
    fn code(&self) -> Option<&str> {
        GetInsightSelectorsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetInsightSelectorsError {
    /// Creates a new `GetInsightSelectorsError`.
    pub fn new(kind: GetInsightSelectorsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetInsightSelectorsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetInsightSelectorsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetInsightSelectorsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetInsightSelectorsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetInsightSelectorsErrorKind::InsightNotEnabledException`.
    pub fn is_insight_not_enabled_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetInsightSelectorsErrorKind::InsightNotEnabledException(_)
        )
    }
    /// Returns `true` if the error kind is `GetInsightSelectorsErrorKind::InvalidTrailNameException`.
    pub fn is_invalid_trail_name_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetInsightSelectorsErrorKind::InvalidTrailNameException(_)
        )
    }
    /// Returns `true` if the error kind is `GetInsightSelectorsErrorKind::OperationNotPermittedException`.
    pub fn is_operation_not_permitted_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetInsightSelectorsErrorKind::OperationNotPermittedException(_)
        )
    }
    /// Returns `true` if the error kind is `GetInsightSelectorsErrorKind::TrailNotFoundException`.
    pub fn is_trail_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetInsightSelectorsErrorKind::TrailNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetInsightSelectorsErrorKind::UnsupportedOperationException`.
    pub fn is_unsupported_operation_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetInsightSelectorsErrorKind::UnsupportedOperationException(_)
        )
    }
}
impl std::error::Error for GetInsightSelectorsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetInsightSelectorsErrorKind::InsightNotEnabledException(_inner) => Some(_inner),
            GetInsightSelectorsErrorKind::InvalidTrailNameException(_inner) => Some(_inner),
            GetInsightSelectorsErrorKind::OperationNotPermittedException(_inner) => Some(_inner),
            GetInsightSelectorsErrorKind::TrailNotFoundException(_inner) => Some(_inner),
            GetInsightSelectorsErrorKind::UnsupportedOperationException(_inner) => Some(_inner),
            GetInsightSelectorsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetQueryResults` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetQueryResultsError {
    /// Kind of error that occurred.
    pub kind: GetQueryResultsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetQueryResults` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetQueryResultsErrorKind {
    /// <p>The specified event data store ARN is not valid or does not map to an event data store in your account.</p>
    EventDataStoreArnInvalidException(crate::error::EventDataStoreArnInvalidException),
    /// <p>The specified event data store was not found.</p>
    EventDataStoreNotFoundException(crate::error::EventDataStoreNotFoundException),
    /// <p>The event data store against which you ran your query is inactive.</p>
    InactiveEventDataStoreException(crate::error::InactiveEventDataStoreException),
    /// <p>This exception is thrown if the limit specified is not valid.</p>
    InvalidMaxResultsException(crate::error::InvalidMaxResultsException),
    /// <p>A token that is not valid, or a token that was previously used in a request with different parameters. This exception is thrown if the token is not valid.</p>
    InvalidNextTokenException(crate::error::InvalidNextTokenException),
    /// <p>The request includes a parameter that is not valid.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>This exception is thrown when the requested operation is not permitted.</p>
    OperationNotPermittedException(crate::error::OperationNotPermittedException),
    /// <p>The query ID does not exist or does not map to a query.</p>
    QueryIdNotFoundException(crate::error::QueryIdNotFoundException),
    /// <p>This exception is thrown when the requested operation is not supported.</p>
    UnsupportedOperationException(crate::error::UnsupportedOperationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetQueryResultsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetQueryResultsErrorKind::EventDataStoreArnInvalidException(_inner) => _inner.fmt(f),
            GetQueryResultsErrorKind::EventDataStoreNotFoundException(_inner) => _inner.fmt(f),
            GetQueryResultsErrorKind::InactiveEventDataStoreException(_inner) => _inner.fmt(f),
            GetQueryResultsErrorKind::InvalidMaxResultsException(_inner) => _inner.fmt(f),
            GetQueryResultsErrorKind::InvalidNextTokenException(_inner) => _inner.fmt(f),
            GetQueryResultsErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            GetQueryResultsErrorKind::OperationNotPermittedException(_inner) => _inner.fmt(f),
            GetQueryResultsErrorKind::QueryIdNotFoundException(_inner) => _inner.fmt(f),
            GetQueryResultsErrorKind::UnsupportedOperationException(_inner) => _inner.fmt(f),
            GetQueryResultsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetQueryResultsError {
    fn code(&self) -> Option<&str> {
        GetQueryResultsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetQueryResultsError {
    /// Creates a new `GetQueryResultsError`.
    pub fn new(kind: GetQueryResultsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetQueryResultsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetQueryResultsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetQueryResultsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetQueryResultsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetQueryResultsErrorKind::EventDataStoreArnInvalidException`.
    pub fn is_event_data_store_arn_invalid_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetQueryResultsErrorKind::EventDataStoreArnInvalidException(_)
        )
    }
    /// Returns `true` if the error kind is `GetQueryResultsErrorKind::EventDataStoreNotFoundException`.
    pub fn is_event_data_store_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetQueryResultsErrorKind::EventDataStoreNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetQueryResultsErrorKind::InactiveEventDataStoreException`.
    pub fn is_inactive_event_data_store_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetQueryResultsErrorKind::InactiveEventDataStoreException(_)
        )
    }
    /// Returns `true` if the error kind is `GetQueryResultsErrorKind::InvalidMaxResultsException`.
    pub fn is_invalid_max_results_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetQueryResultsErrorKind::InvalidMaxResultsException(_)
        )
    }
    /// Returns `true` if the error kind is `GetQueryResultsErrorKind::InvalidNextTokenException`.
    pub fn is_invalid_next_token_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetQueryResultsErrorKind::InvalidNextTokenException(_)
        )
    }
    /// Returns `true` if the error kind is `GetQueryResultsErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetQueryResultsErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `GetQueryResultsErrorKind::OperationNotPermittedException`.
    pub fn is_operation_not_permitted_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetQueryResultsErrorKind::OperationNotPermittedException(_)
        )
    }
    /// Returns `true` if the error kind is `GetQueryResultsErrorKind::QueryIdNotFoundException`.
    pub fn is_query_id_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetQueryResultsErrorKind::QueryIdNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetQueryResultsErrorKind::UnsupportedOperationException`.
    pub fn is_unsupported_operation_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetQueryResultsErrorKind::UnsupportedOperationException(_)
        )
    }
}
impl std::error::Error for GetQueryResultsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetQueryResultsErrorKind::EventDataStoreArnInvalidException(_inner) => Some(_inner),
            GetQueryResultsErrorKind::EventDataStoreNotFoundException(_inner) => Some(_inner),
            GetQueryResultsErrorKind::InactiveEventDataStoreException(_inner) => Some(_inner),
            GetQueryResultsErrorKind::InvalidMaxResultsException(_inner) => Some(_inner),
            GetQueryResultsErrorKind::InvalidNextTokenException(_inner) => Some(_inner),
            GetQueryResultsErrorKind::InvalidParameterException(_inner) => Some(_inner),
            GetQueryResultsErrorKind::OperationNotPermittedException(_inner) => Some(_inner),
            GetQueryResultsErrorKind::QueryIdNotFoundException(_inner) => Some(_inner),
            GetQueryResultsErrorKind::UnsupportedOperationException(_inner) => Some(_inner),
            GetQueryResultsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetTrail` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetTrailError {
    /// Kind of error that occurred.
    pub kind: GetTrailErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetTrail` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetTrailErrorKind {
    /// <p>This exception is thrown when the provided trail name is not valid. Trail names must meet the following requirements:</p>
    /// <ul>
    /// <li> <p>Contain only ASCII letters (a-z, A-Z), numbers (0-9), periods (.), underscores (_), or dashes (-)</p> </li>
    /// <li> <p>Start with a letter or number, and end with a letter or number</p> </li>
    /// <li> <p>Be between 3 and 128 characters</p> </li>
    /// <li> <p>Have no adjacent periods, underscores or dashes. Names like <code>my-_namespace</code> and <code>my--namespace</code> are not valid.</p> </li>
    /// <li> <p>Not be in IP address format (for example, 192.168.5.4)</p> </li>
    /// </ul>
    InvalidTrailNameException(crate::error::InvalidTrailNameException),
    /// <p>This exception is thrown when the requested operation is not permitted.</p>
    OperationNotPermittedException(crate::error::OperationNotPermittedException),
    /// <p>This exception is thrown when the trail with the given name is not found.</p>
    TrailNotFoundException(crate::error::TrailNotFoundException),
    /// <p>This exception is thrown when the requested operation is not supported.</p>
    UnsupportedOperationException(crate::error::UnsupportedOperationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetTrailError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetTrailErrorKind::InvalidTrailNameException(_inner) => _inner.fmt(f),
            GetTrailErrorKind::OperationNotPermittedException(_inner) => _inner.fmt(f),
            GetTrailErrorKind::TrailNotFoundException(_inner) => _inner.fmt(f),
            GetTrailErrorKind::UnsupportedOperationException(_inner) => _inner.fmt(f),
            GetTrailErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetTrailError {
    fn code(&self) -> Option<&str> {
        GetTrailError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetTrailError {
    /// Creates a new `GetTrailError`.
    pub fn new(kind: GetTrailErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetTrailError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetTrailErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetTrailError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetTrailErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetTrailErrorKind::InvalidTrailNameException`.
    pub fn is_invalid_trail_name_exception(&self) -> bool {
        matches!(&self.kind, GetTrailErrorKind::InvalidTrailNameException(_))
    }
    /// Returns `true` if the error kind is `GetTrailErrorKind::OperationNotPermittedException`.
    pub fn is_operation_not_permitted_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetTrailErrorKind::OperationNotPermittedException(_)
        )
    }
    /// Returns `true` if the error kind is `GetTrailErrorKind::TrailNotFoundException`.
    pub fn is_trail_not_found_exception(&self) -> bool {
        matches!(&self.kind, GetTrailErrorKind::TrailNotFoundException(_))
    }
    /// Returns `true` if the error kind is `GetTrailErrorKind::UnsupportedOperationException`.
    pub fn is_unsupported_operation_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetTrailErrorKind::UnsupportedOperationException(_)
        )
    }
}
impl std::error::Error for GetTrailError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetTrailErrorKind::InvalidTrailNameException(_inner) => Some(_inner),
            GetTrailErrorKind::OperationNotPermittedException(_inner) => Some(_inner),
            GetTrailErrorKind::TrailNotFoundException(_inner) => Some(_inner),
            GetTrailErrorKind::UnsupportedOperationException(_inner) => Some(_inner),
            GetTrailErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetTrailStatus` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetTrailStatusError {
    /// Kind of error that occurred.
    pub kind: GetTrailStatusErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetTrailStatus` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetTrailStatusErrorKind {
    /// <p>This exception is thrown when the provided trail name is not valid. Trail names must meet the following requirements:</p>
    /// <ul>
    /// <li> <p>Contain only ASCII letters (a-z, A-Z), numbers (0-9), periods (.), underscores (_), or dashes (-)</p> </li>
    /// <li> <p>Start with a letter or number, and end with a letter or number</p> </li>
    /// <li> <p>Be between 3 and 128 characters</p> </li>
    /// <li> <p>Have no adjacent periods, underscores or dashes. Names like <code>my-_namespace</code> and <code>my--namespace</code> are not valid.</p> </li>
    /// <li> <p>Not be in IP address format (for example, 192.168.5.4)</p> </li>
    /// </ul>
    InvalidTrailNameException(crate::error::InvalidTrailNameException),
    /// <p>This exception is thrown when the requested operation is not permitted.</p>
    OperationNotPermittedException(crate::error::OperationNotPermittedException),
    /// <p>This exception is thrown when the trail with the given name is not found.</p>
    TrailNotFoundException(crate::error::TrailNotFoundException),
    /// <p>This exception is thrown when the requested operation is not supported.</p>
    UnsupportedOperationException(crate::error::UnsupportedOperationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetTrailStatusError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetTrailStatusErrorKind::InvalidTrailNameException(_inner) => _inner.fmt(f),
            GetTrailStatusErrorKind::OperationNotPermittedException(_inner) => _inner.fmt(f),
            GetTrailStatusErrorKind::TrailNotFoundException(_inner) => _inner.fmt(f),
            GetTrailStatusErrorKind::UnsupportedOperationException(_inner) => _inner.fmt(f),
            GetTrailStatusErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetTrailStatusError {
    fn code(&self) -> Option<&str> {
        GetTrailStatusError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetTrailStatusError {
    /// Creates a new `GetTrailStatusError`.
    pub fn new(kind: GetTrailStatusErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetTrailStatusError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetTrailStatusErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetTrailStatusError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetTrailStatusErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetTrailStatusErrorKind::InvalidTrailNameException`.
    pub fn is_invalid_trail_name_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetTrailStatusErrorKind::InvalidTrailNameException(_)
        )
    }
    /// Returns `true` if the error kind is `GetTrailStatusErrorKind::OperationNotPermittedException`.
    pub fn is_operation_not_permitted_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetTrailStatusErrorKind::OperationNotPermittedException(_)
        )
    }
    /// Returns `true` if the error kind is `GetTrailStatusErrorKind::TrailNotFoundException`.
    pub fn is_trail_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetTrailStatusErrorKind::TrailNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetTrailStatusErrorKind::UnsupportedOperationException`.
    pub fn is_unsupported_operation_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetTrailStatusErrorKind::UnsupportedOperationException(_)
        )
    }
}
impl std::error::Error for GetTrailStatusError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetTrailStatusErrorKind::InvalidTrailNameException(_inner) => Some(_inner),
            GetTrailStatusErrorKind::OperationNotPermittedException(_inner) => Some(_inner),
            GetTrailStatusErrorKind::TrailNotFoundException(_inner) => Some(_inner),
            GetTrailStatusErrorKind::UnsupportedOperationException(_inner) => Some(_inner),
            GetTrailStatusErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListEventDataStores` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListEventDataStoresError {
    /// Kind of error that occurred.
    pub kind: ListEventDataStoresErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListEventDataStores` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListEventDataStoresErrorKind {
    /// <p>This exception is thrown if the limit specified is not valid.</p>
    InvalidMaxResultsException(crate::error::InvalidMaxResultsException),
    /// <p>A token that is not valid, or a token that was previously used in a request with different parameters. This exception is thrown if the token is not valid.</p>
    InvalidNextTokenException(crate::error::InvalidNextTokenException),
    /// <p>This exception is thrown when the requested operation is not permitted.</p>
    OperationNotPermittedException(crate::error::OperationNotPermittedException),
    /// <p>This exception is thrown when the requested operation is not supported.</p>
    UnsupportedOperationException(crate::error::UnsupportedOperationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListEventDataStoresError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListEventDataStoresErrorKind::InvalidMaxResultsException(_inner) => _inner.fmt(f),
            ListEventDataStoresErrorKind::InvalidNextTokenException(_inner) => _inner.fmt(f),
            ListEventDataStoresErrorKind::OperationNotPermittedException(_inner) => _inner.fmt(f),
            ListEventDataStoresErrorKind::UnsupportedOperationException(_inner) => _inner.fmt(f),
            ListEventDataStoresErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListEventDataStoresError {
    fn code(&self) -> Option<&str> {
        ListEventDataStoresError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListEventDataStoresError {
    /// Creates a new `ListEventDataStoresError`.
    pub fn new(kind: ListEventDataStoresErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListEventDataStoresError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListEventDataStoresErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListEventDataStoresError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListEventDataStoresErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListEventDataStoresErrorKind::InvalidMaxResultsException`.
    pub fn is_invalid_max_results_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListEventDataStoresErrorKind::InvalidMaxResultsException(_)
        )
    }
    /// Returns `true` if the error kind is `ListEventDataStoresErrorKind::InvalidNextTokenException`.
    pub fn is_invalid_next_token_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListEventDataStoresErrorKind::InvalidNextTokenException(_)
        )
    }
    /// Returns `true` if the error kind is `ListEventDataStoresErrorKind::OperationNotPermittedException`.
    pub fn is_operation_not_permitted_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListEventDataStoresErrorKind::OperationNotPermittedException(_)
        )
    }
    /// Returns `true` if the error kind is `ListEventDataStoresErrorKind::UnsupportedOperationException`.
    pub fn is_unsupported_operation_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListEventDataStoresErrorKind::UnsupportedOperationException(_)
        )
    }
}
impl std::error::Error for ListEventDataStoresError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListEventDataStoresErrorKind::InvalidMaxResultsException(_inner) => Some(_inner),
            ListEventDataStoresErrorKind::InvalidNextTokenException(_inner) => Some(_inner),
            ListEventDataStoresErrorKind::OperationNotPermittedException(_inner) => Some(_inner),
            ListEventDataStoresErrorKind::UnsupportedOperationException(_inner) => Some(_inner),
            ListEventDataStoresErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListPublicKeys` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListPublicKeysError {
    /// Kind of error that occurred.
    pub kind: ListPublicKeysErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListPublicKeys` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListPublicKeysErrorKind {
    /// <p>Occurs if the timestamp values are not valid. Either the start time occurs after the end time, or the time range is outside the range of possible values.</p>
    InvalidTimeRangeException(crate::error::InvalidTimeRangeException),
    /// <p>Reserved for future use.</p>
    InvalidTokenException(crate::error::InvalidTokenException),
    /// <p>This exception is thrown when the requested operation is not permitted.</p>
    OperationNotPermittedException(crate::error::OperationNotPermittedException),
    /// <p>This exception is thrown when the requested operation is not supported.</p>
    UnsupportedOperationException(crate::error::UnsupportedOperationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListPublicKeysError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListPublicKeysErrorKind::InvalidTimeRangeException(_inner) => _inner.fmt(f),
            ListPublicKeysErrorKind::InvalidTokenException(_inner) => _inner.fmt(f),
            ListPublicKeysErrorKind::OperationNotPermittedException(_inner) => _inner.fmt(f),
            ListPublicKeysErrorKind::UnsupportedOperationException(_inner) => _inner.fmt(f),
            ListPublicKeysErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListPublicKeysError {
    fn code(&self) -> Option<&str> {
        ListPublicKeysError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListPublicKeysError {
    /// Creates a new `ListPublicKeysError`.
    pub fn new(kind: ListPublicKeysErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListPublicKeysError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListPublicKeysErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListPublicKeysError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListPublicKeysErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListPublicKeysErrorKind::InvalidTimeRangeException`.
    pub fn is_invalid_time_range_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListPublicKeysErrorKind::InvalidTimeRangeException(_)
        )
    }
    /// Returns `true` if the error kind is `ListPublicKeysErrorKind::InvalidTokenException`.
    pub fn is_invalid_token_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListPublicKeysErrorKind::InvalidTokenException(_)
        )
    }
    /// Returns `true` if the error kind is `ListPublicKeysErrorKind::OperationNotPermittedException`.
    pub fn is_operation_not_permitted_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListPublicKeysErrorKind::OperationNotPermittedException(_)
        )
    }
    /// Returns `true` if the error kind is `ListPublicKeysErrorKind::UnsupportedOperationException`.
    pub fn is_unsupported_operation_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListPublicKeysErrorKind::UnsupportedOperationException(_)
        )
    }
}
impl std::error::Error for ListPublicKeysError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListPublicKeysErrorKind::InvalidTimeRangeException(_inner) => Some(_inner),
            ListPublicKeysErrorKind::InvalidTokenException(_inner) => Some(_inner),
            ListPublicKeysErrorKind::OperationNotPermittedException(_inner) => Some(_inner),
            ListPublicKeysErrorKind::UnsupportedOperationException(_inner) => Some(_inner),
            ListPublicKeysErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListQueries` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListQueriesError {
    /// Kind of error that occurred.
    pub kind: ListQueriesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListQueries` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListQueriesErrorKind {
    /// <p>The specified event data store ARN is not valid or does not map to an event data store in your account.</p>
    EventDataStoreArnInvalidException(crate::error::EventDataStoreArnInvalidException),
    /// <p>The specified event data store was not found.</p>
    EventDataStoreNotFoundException(crate::error::EventDataStoreNotFoundException),
    /// <p>The event data store against which you ran your query is inactive.</p>
    InactiveEventDataStoreException(crate::error::InactiveEventDataStoreException),
    /// <p>A date range for the query was specified that is not valid. For more information about writing a query, see <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/query-create-edit-query.html">Create or edit a query</a> in the <i>CloudTrail User Guide</i>.</p>
    InvalidDateRangeException(crate::error::InvalidDateRangeException),
    /// <p>This exception is thrown if the limit specified is not valid.</p>
    InvalidMaxResultsException(crate::error::InvalidMaxResultsException),
    /// <p>A token that is not valid, or a token that was previously used in a request with different parameters. This exception is thrown if the token is not valid.</p>
    InvalidNextTokenException(crate::error::InvalidNextTokenException),
    /// <p>The request includes a parameter that is not valid.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>The query status is not valid for the operation.</p>
    InvalidQueryStatusException(crate::error::InvalidQueryStatusException),
    /// <p>This exception is thrown when the requested operation is not permitted.</p>
    OperationNotPermittedException(crate::error::OperationNotPermittedException),
    /// <p>This exception is thrown when the requested operation is not supported.</p>
    UnsupportedOperationException(crate::error::UnsupportedOperationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListQueriesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListQueriesErrorKind::EventDataStoreArnInvalidException(_inner) => _inner.fmt(f),
            ListQueriesErrorKind::EventDataStoreNotFoundException(_inner) => _inner.fmt(f),
            ListQueriesErrorKind::InactiveEventDataStoreException(_inner) => _inner.fmt(f),
            ListQueriesErrorKind::InvalidDateRangeException(_inner) => _inner.fmt(f),
            ListQueriesErrorKind::InvalidMaxResultsException(_inner) => _inner.fmt(f),
            ListQueriesErrorKind::InvalidNextTokenException(_inner) => _inner.fmt(f),
            ListQueriesErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            ListQueriesErrorKind::InvalidQueryStatusException(_inner) => _inner.fmt(f),
            ListQueriesErrorKind::OperationNotPermittedException(_inner) => _inner.fmt(f),
            ListQueriesErrorKind::UnsupportedOperationException(_inner) => _inner.fmt(f),
            ListQueriesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListQueriesError {
    fn code(&self) -> Option<&str> {
        ListQueriesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListQueriesError {
    /// Creates a new `ListQueriesError`.
    pub fn new(kind: ListQueriesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListQueriesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListQueriesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListQueriesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListQueriesErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListQueriesErrorKind::EventDataStoreArnInvalidException`.
    pub fn is_event_data_store_arn_invalid_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListQueriesErrorKind::EventDataStoreArnInvalidException(_)
        )
    }
    /// Returns `true` if the error kind is `ListQueriesErrorKind::EventDataStoreNotFoundException`.
    pub fn is_event_data_store_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListQueriesErrorKind::EventDataStoreNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListQueriesErrorKind::InactiveEventDataStoreException`.
    pub fn is_inactive_event_data_store_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListQueriesErrorKind::InactiveEventDataStoreException(_)
        )
    }
    /// Returns `true` if the error kind is `ListQueriesErrorKind::InvalidDateRangeException`.
    pub fn is_invalid_date_range_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListQueriesErrorKind::InvalidDateRangeException(_)
        )
    }
    /// Returns `true` if the error kind is `ListQueriesErrorKind::InvalidMaxResultsException`.
    pub fn is_invalid_max_results_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListQueriesErrorKind::InvalidMaxResultsException(_)
        )
    }
    /// Returns `true` if the error kind is `ListQueriesErrorKind::InvalidNextTokenException`.
    pub fn is_invalid_next_token_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListQueriesErrorKind::InvalidNextTokenException(_)
        )
    }
    /// Returns `true` if the error kind is `ListQueriesErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListQueriesErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `ListQueriesErrorKind::InvalidQueryStatusException`.
    pub fn is_invalid_query_status_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListQueriesErrorKind::InvalidQueryStatusException(_)
        )
    }
    /// Returns `true` if the error kind is `ListQueriesErrorKind::OperationNotPermittedException`.
    pub fn is_operation_not_permitted_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListQueriesErrorKind::OperationNotPermittedException(_)
        )
    }
    /// Returns `true` if the error kind is `ListQueriesErrorKind::UnsupportedOperationException`.
    pub fn is_unsupported_operation_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListQueriesErrorKind::UnsupportedOperationException(_)
        )
    }
}
impl std::error::Error for ListQueriesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListQueriesErrorKind::EventDataStoreArnInvalidException(_inner) => Some(_inner),
            ListQueriesErrorKind::EventDataStoreNotFoundException(_inner) => Some(_inner),
            ListQueriesErrorKind::InactiveEventDataStoreException(_inner) => Some(_inner),
            ListQueriesErrorKind::InvalidDateRangeException(_inner) => Some(_inner),
            ListQueriesErrorKind::InvalidMaxResultsException(_inner) => Some(_inner),
            ListQueriesErrorKind::InvalidNextTokenException(_inner) => Some(_inner),
            ListQueriesErrorKind::InvalidParameterException(_inner) => Some(_inner),
            ListQueriesErrorKind::InvalidQueryStatusException(_inner) => Some(_inner),
            ListQueriesErrorKind::OperationNotPermittedException(_inner) => Some(_inner),
            ListQueriesErrorKind::UnsupportedOperationException(_inner) => Some(_inner),
            ListQueriesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListTags` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListTagsError {
    /// Kind of error that occurred.
    pub kind: ListTagsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListTags` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListTagsErrorKind {
    /// <p>This exception is thrown when an operation is called with a trail ARN that is not valid. The following is the format of a trail ARN.</p>
    /// <p> <code>arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail</code> </p>
    CloudTrailArnInvalidException(crate::error::CloudTrailArnInvalidException),
    /// <p>The specified event data store was not found.</p>
    EventDataStoreNotFoundException(crate::error::EventDataStoreNotFoundException),
    /// <p>The event data store against which you ran your query is inactive.</p>
    InactiveEventDataStoreException(crate::error::InactiveEventDataStoreException),
    /// <p>Reserved for future use.</p>
    InvalidTokenException(crate::error::InvalidTokenException),
    /// <p>This exception is thrown when the provided trail name is not valid. Trail names must meet the following requirements:</p>
    /// <ul>
    /// <li> <p>Contain only ASCII letters (a-z, A-Z), numbers (0-9), periods (.), underscores (_), or dashes (-)</p> </li>
    /// <li> <p>Start with a letter or number, and end with a letter or number</p> </li>
    /// <li> <p>Be between 3 and 128 characters</p> </li>
    /// <li> <p>Have no adjacent periods, underscores or dashes. Names like <code>my-_namespace</code> and <code>my--namespace</code> are not valid.</p> </li>
    /// <li> <p>Not be in IP address format (for example, 192.168.5.4)</p> </li>
    /// </ul>
    InvalidTrailNameException(crate::error::InvalidTrailNameException),
    /// <p>This exception is thrown when the requested operation is not permitted.</p>
    OperationNotPermittedException(crate::error::OperationNotPermittedException),
    /// <p>This exception is thrown when the specified resource is not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>This exception is thrown when the specified resource type is not supported by CloudTrail.</p>
    ResourceTypeNotSupportedException(crate::error::ResourceTypeNotSupportedException),
    /// <p>This exception is thrown when the requested operation is not supported.</p>
    UnsupportedOperationException(crate::error::UnsupportedOperationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListTagsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListTagsErrorKind::CloudTrailArnInvalidException(_inner) => _inner.fmt(f),
            ListTagsErrorKind::EventDataStoreNotFoundException(_inner) => _inner.fmt(f),
            ListTagsErrorKind::InactiveEventDataStoreException(_inner) => _inner.fmt(f),
            ListTagsErrorKind::InvalidTokenException(_inner) => _inner.fmt(f),
            ListTagsErrorKind::InvalidTrailNameException(_inner) => _inner.fmt(f),
            ListTagsErrorKind::OperationNotPermittedException(_inner) => _inner.fmt(f),
            ListTagsErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListTagsErrorKind::ResourceTypeNotSupportedException(_inner) => _inner.fmt(f),
            ListTagsErrorKind::UnsupportedOperationException(_inner) => _inner.fmt(f),
            ListTagsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListTagsError {
    fn code(&self) -> Option<&str> {
        ListTagsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListTagsError {
    /// Creates a new `ListTagsError`.
    pub fn new(kind: ListTagsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListTagsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListTagsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListTagsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListTagsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListTagsErrorKind::CloudTrailArnInvalidException`.
    pub fn is_cloud_trail_arn_invalid_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsErrorKind::CloudTrailArnInvalidException(_)
        )
    }
    /// Returns `true` if the error kind is `ListTagsErrorKind::EventDataStoreNotFoundException`.
    pub fn is_event_data_store_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsErrorKind::EventDataStoreNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListTagsErrorKind::InactiveEventDataStoreException`.
    pub fn is_inactive_event_data_store_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsErrorKind::InactiveEventDataStoreException(_)
        )
    }
    /// Returns `true` if the error kind is `ListTagsErrorKind::InvalidTokenException`.
    pub fn is_invalid_token_exception(&self) -> bool {
        matches!(&self.kind, ListTagsErrorKind::InvalidTokenException(_))
    }
    /// Returns `true` if the error kind is `ListTagsErrorKind::InvalidTrailNameException`.
    pub fn is_invalid_trail_name_exception(&self) -> bool {
        matches!(&self.kind, ListTagsErrorKind::InvalidTrailNameException(_))
    }
    /// Returns `true` if the error kind is `ListTagsErrorKind::OperationNotPermittedException`.
    pub fn is_operation_not_permitted_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsErrorKind::OperationNotPermittedException(_)
        )
    }
    /// Returns `true` if the error kind is `ListTagsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(&self.kind, ListTagsErrorKind::ResourceNotFoundException(_))
    }
    /// Returns `true` if the error kind is `ListTagsErrorKind::ResourceTypeNotSupportedException`.
    pub fn is_resource_type_not_supported_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsErrorKind::ResourceTypeNotSupportedException(_)
        )
    }
    /// Returns `true` if the error kind is `ListTagsErrorKind::UnsupportedOperationException`.
    pub fn is_unsupported_operation_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsErrorKind::UnsupportedOperationException(_)
        )
    }
}
impl std::error::Error for ListTagsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListTagsErrorKind::CloudTrailArnInvalidException(_inner) => Some(_inner),
            ListTagsErrorKind::EventDataStoreNotFoundException(_inner) => Some(_inner),
            ListTagsErrorKind::InactiveEventDataStoreException(_inner) => Some(_inner),
            ListTagsErrorKind::InvalidTokenException(_inner) => Some(_inner),
            ListTagsErrorKind::InvalidTrailNameException(_inner) => Some(_inner),
            ListTagsErrorKind::OperationNotPermittedException(_inner) => Some(_inner),
            ListTagsErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListTagsErrorKind::ResourceTypeNotSupportedException(_inner) => Some(_inner),
            ListTagsErrorKind::UnsupportedOperationException(_inner) => Some(_inner),
            ListTagsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListTrails` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListTrailsError {
    /// Kind of error that occurred.
    pub kind: ListTrailsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListTrails` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListTrailsErrorKind {
    /// <p>This exception is thrown when the requested operation is not permitted.</p>
    OperationNotPermittedException(crate::error::OperationNotPermittedException),
    /// <p>This exception is thrown when the requested operation is not supported.</p>
    UnsupportedOperationException(crate::error::UnsupportedOperationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListTrailsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListTrailsErrorKind::OperationNotPermittedException(_inner) => _inner.fmt(f),
            ListTrailsErrorKind::UnsupportedOperationException(_inner) => _inner.fmt(f),
            ListTrailsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListTrailsError {
    fn code(&self) -> Option<&str> {
        ListTrailsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListTrailsError {
    /// Creates a new `ListTrailsError`.
    pub fn new(kind: ListTrailsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListTrailsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListTrailsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListTrailsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListTrailsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListTrailsErrorKind::OperationNotPermittedException`.
    pub fn is_operation_not_permitted_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTrailsErrorKind::OperationNotPermittedException(_)
        )
    }
    /// Returns `true` if the error kind is `ListTrailsErrorKind::UnsupportedOperationException`.
    pub fn is_unsupported_operation_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTrailsErrorKind::UnsupportedOperationException(_)
        )
    }
}
impl std::error::Error for ListTrailsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListTrailsErrorKind::OperationNotPermittedException(_inner) => Some(_inner),
            ListTrailsErrorKind::UnsupportedOperationException(_inner) => Some(_inner),
            ListTrailsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `LookupEvents` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct LookupEventsError {
    /// Kind of error that occurred.
    pub kind: LookupEventsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `LookupEvents` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum LookupEventsErrorKind {
    /// <p>Occurs if an event category that is not valid is specified as a value of <code>EventCategory</code>.</p>
    InvalidEventCategoryException(crate::error::InvalidEventCategoryException),
    /// <p>Occurs when a lookup attribute is specified that is not valid.</p>
    InvalidLookupAttributesException(crate::error::InvalidLookupAttributesException),
    /// <p>This exception is thrown if the limit specified is not valid.</p>
    InvalidMaxResultsException(crate::error::InvalidMaxResultsException),
    /// <p>A token that is not valid, or a token that was previously used in a request with different parameters. This exception is thrown if the token is not valid.</p>
    InvalidNextTokenException(crate::error::InvalidNextTokenException),
    /// <p>Occurs if the timestamp values are not valid. Either the start time occurs after the end time, or the time range is outside the range of possible values.</p>
    InvalidTimeRangeException(crate::error::InvalidTimeRangeException),
    /// <p>This exception is thrown when the requested operation is not permitted.</p>
    OperationNotPermittedException(crate::error::OperationNotPermittedException),
    /// <p>This exception is thrown when the requested operation is not supported.</p>
    UnsupportedOperationException(crate::error::UnsupportedOperationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for LookupEventsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            LookupEventsErrorKind::InvalidEventCategoryException(_inner) => _inner.fmt(f),
            LookupEventsErrorKind::InvalidLookupAttributesException(_inner) => _inner.fmt(f),
            LookupEventsErrorKind::InvalidMaxResultsException(_inner) => _inner.fmt(f),
            LookupEventsErrorKind::InvalidNextTokenException(_inner) => _inner.fmt(f),
            LookupEventsErrorKind::InvalidTimeRangeException(_inner) => _inner.fmt(f),
            LookupEventsErrorKind::OperationNotPermittedException(_inner) => _inner.fmt(f),
            LookupEventsErrorKind::UnsupportedOperationException(_inner) => _inner.fmt(f),
            LookupEventsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for LookupEventsError {
    fn code(&self) -> Option<&str> {
        LookupEventsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl LookupEventsError {
    /// Creates a new `LookupEventsError`.
    pub fn new(kind: LookupEventsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `LookupEventsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: LookupEventsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `LookupEventsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: LookupEventsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `LookupEventsErrorKind::InvalidEventCategoryException`.
    pub fn is_invalid_event_category_exception(&self) -> bool {
        matches!(
            &self.kind,
            LookupEventsErrorKind::InvalidEventCategoryException(_)
        )
    }
    /// Returns `true` if the error kind is `LookupEventsErrorKind::InvalidLookupAttributesException`.
    pub fn is_invalid_lookup_attributes_exception(&self) -> bool {
        matches!(
            &self.kind,
            LookupEventsErrorKind::InvalidLookupAttributesException(_)
        )
    }
    /// Returns `true` if the error kind is `LookupEventsErrorKind::InvalidMaxResultsException`.
    pub fn is_invalid_max_results_exception(&self) -> bool {
        matches!(
            &self.kind,
            LookupEventsErrorKind::InvalidMaxResultsException(_)
        )
    }
    /// Returns `true` if the error kind is `LookupEventsErrorKind::InvalidNextTokenException`.
    pub fn is_invalid_next_token_exception(&self) -> bool {
        matches!(
            &self.kind,
            LookupEventsErrorKind::InvalidNextTokenException(_)
        )
    }
    /// Returns `true` if the error kind is `LookupEventsErrorKind::InvalidTimeRangeException`.
    pub fn is_invalid_time_range_exception(&self) -> bool {
        matches!(
            &self.kind,
            LookupEventsErrorKind::InvalidTimeRangeException(_)
        )
    }
    /// Returns `true` if the error kind is `LookupEventsErrorKind::OperationNotPermittedException`.
    pub fn is_operation_not_permitted_exception(&self) -> bool {
        matches!(
            &self.kind,
            LookupEventsErrorKind::OperationNotPermittedException(_)
        )
    }
    /// Returns `true` if the error kind is `LookupEventsErrorKind::UnsupportedOperationException`.
    pub fn is_unsupported_operation_exception(&self) -> bool {
        matches!(
            &self.kind,
            LookupEventsErrorKind::UnsupportedOperationException(_)
        )
    }
}
impl std::error::Error for LookupEventsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            LookupEventsErrorKind::InvalidEventCategoryException(_inner) => Some(_inner),
            LookupEventsErrorKind::InvalidLookupAttributesException(_inner) => Some(_inner),
            LookupEventsErrorKind::InvalidMaxResultsException(_inner) => Some(_inner),
            LookupEventsErrorKind::InvalidNextTokenException(_inner) => Some(_inner),
            LookupEventsErrorKind::InvalidTimeRangeException(_inner) => Some(_inner),
            LookupEventsErrorKind::OperationNotPermittedException(_inner) => Some(_inner),
            LookupEventsErrorKind::UnsupportedOperationException(_inner) => Some(_inner),
            LookupEventsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `PutEventSelectors` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct PutEventSelectorsError {
    /// Kind of error that occurred.
    pub kind: PutEventSelectorsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `PutEventSelectors` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum PutEventSelectorsErrorKind {
    /// <p>This exception is thrown when the IAM user or role that is used to create the organization trail is lacking one or more required permissions for creating an organization trail in a required service. For more information, see <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/creating-an-organizational-trail-prepare.html">Prepare For Creating a Trail For Your Organization</a>.</p>
    InsufficientDependencyServiceAccessPermissionException(
        crate::error::InsufficientDependencyServiceAccessPermissionException,
    ),
    /// <p>This exception is thrown when the <code>PutEventSelectors</code> operation is called with a number of event selectors, advanced event selectors, or data resources that is not valid. The combination of event selectors or advanced event selectors and data resources is not valid. A trail can have up to 5 event selectors. If a trail uses advanced event selectors, a maximum of 500 total values for all conditions in all advanced event selectors is allowed. A trail is limited to 250 data resources. These data resources can be distributed across event selectors, but the overall total cannot exceed 250.</p>
    /// <p>You can:</p>
    /// <ul>
    /// <li> <p>Specify a valid number of event selectors (1 to 5) for a trail.</p> </li>
    /// <li> <p>Specify a valid number of data resources (1 to 250) for an event selector. The limit of number of resources on an individual event selector is configurable up to 250. However, this upper limit is allowed only if the total number of data resources does not exceed 250 across all event selectors for a trail.</p> </li>
    /// <li> <p>Specify up to 500 values for all conditions in all advanced event selectors for a trail.</p> </li>
    /// <li> <p>Specify a valid value for a parameter. For example, specifying the <code>ReadWriteType</code> parameter with a value of <code>read-only</code> is not valid.</p> </li>
    /// </ul>
    InvalidEventSelectorsException(crate::error::InvalidEventSelectorsException),
    /// <p>This exception is thrown when an operation is called on a trail from a region other than the region in which the trail was created.</p>
    InvalidHomeRegionException(crate::error::InvalidHomeRegionException),
    /// <p>This exception is thrown when the provided trail name is not valid. Trail names must meet the following requirements:</p>
    /// <ul>
    /// <li> <p>Contain only ASCII letters (a-z, A-Z), numbers (0-9), periods (.), underscores (_), or dashes (-)</p> </li>
    /// <li> <p>Start with a letter or number, and end with a letter or number</p> </li>
    /// <li> <p>Be between 3 and 128 characters</p> </li>
    /// <li> <p>Have no adjacent periods, underscores or dashes. Names like <code>my-_namespace</code> and <code>my--namespace</code> are not valid.</p> </li>
    /// <li> <p>Not be in IP address format (for example, 192.168.5.4)</p> </li>
    /// </ul>
    InvalidTrailNameException(crate::error::InvalidTrailNameException),
    /// <p>This exception is thrown when the Amazon Web Services account making the request to create or update an organization trail is not the management account for an organization in Organizations. For more information, see <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/creating-an-organizational-trail-prepare.html">Prepare For Creating a Trail For Your Organization</a>.</p>
    NotOrganizationMasterAccountException(crate::error::NotOrganizationMasterAccountException),
    /// <p>This exception is thrown when the requested operation is not permitted.</p>
    OperationNotPermittedException(crate::error::OperationNotPermittedException),
    /// <p>This exception is thrown when the trail with the given name is not found.</p>
    TrailNotFoundException(crate::error::TrailNotFoundException),
    /// <p>This exception is thrown when the requested operation is not supported.</p>
    UnsupportedOperationException(crate::error::UnsupportedOperationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for PutEventSelectorsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            PutEventSelectorsErrorKind::InsufficientDependencyServiceAccessPermissionException(
                _inner,
            ) => _inner.fmt(f),
            PutEventSelectorsErrorKind::InvalidEventSelectorsException(_inner) => _inner.fmt(f),
            PutEventSelectorsErrorKind::InvalidHomeRegionException(_inner) => _inner.fmt(f),
            PutEventSelectorsErrorKind::InvalidTrailNameException(_inner) => _inner.fmt(f),
            PutEventSelectorsErrorKind::NotOrganizationMasterAccountException(_inner) => {
                _inner.fmt(f)
            }
            PutEventSelectorsErrorKind::OperationNotPermittedException(_inner) => _inner.fmt(f),
            PutEventSelectorsErrorKind::TrailNotFoundException(_inner) => _inner.fmt(f),
            PutEventSelectorsErrorKind::UnsupportedOperationException(_inner) => _inner.fmt(f),
            PutEventSelectorsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for PutEventSelectorsError {
    fn code(&self) -> Option<&str> {
        PutEventSelectorsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl PutEventSelectorsError {
    /// Creates a new `PutEventSelectorsError`.
    pub fn new(kind: PutEventSelectorsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `PutEventSelectorsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: PutEventSelectorsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `PutEventSelectorsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: PutEventSelectorsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `PutEventSelectorsErrorKind::InsufficientDependencyServiceAccessPermissionException`.
    pub fn is_insufficient_dependency_service_access_permission_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutEventSelectorsErrorKind::InsufficientDependencyServiceAccessPermissionException(_)
        )
    }
    /// Returns `true` if the error kind is `PutEventSelectorsErrorKind::InvalidEventSelectorsException`.
    pub fn is_invalid_event_selectors_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutEventSelectorsErrorKind::InvalidEventSelectorsException(_)
        )
    }
    /// Returns `true` if the error kind is `PutEventSelectorsErrorKind::InvalidHomeRegionException`.
    pub fn is_invalid_home_region_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutEventSelectorsErrorKind::InvalidHomeRegionException(_)
        )
    }
    /// Returns `true` if the error kind is `PutEventSelectorsErrorKind::InvalidTrailNameException`.
    pub fn is_invalid_trail_name_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutEventSelectorsErrorKind::InvalidTrailNameException(_)
        )
    }
    /// Returns `true` if the error kind is `PutEventSelectorsErrorKind::NotOrganizationMasterAccountException`.
    pub fn is_not_organization_master_account_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutEventSelectorsErrorKind::NotOrganizationMasterAccountException(_)
        )
    }
    /// Returns `true` if the error kind is `PutEventSelectorsErrorKind::OperationNotPermittedException`.
    pub fn is_operation_not_permitted_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutEventSelectorsErrorKind::OperationNotPermittedException(_)
        )
    }
    /// Returns `true` if the error kind is `PutEventSelectorsErrorKind::TrailNotFoundException`.
    pub fn is_trail_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutEventSelectorsErrorKind::TrailNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `PutEventSelectorsErrorKind::UnsupportedOperationException`.
    pub fn is_unsupported_operation_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutEventSelectorsErrorKind::UnsupportedOperationException(_)
        )
    }
}
impl std::error::Error for PutEventSelectorsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            PutEventSelectorsErrorKind::InsufficientDependencyServiceAccessPermissionException(
                _inner,
            ) => Some(_inner),
            PutEventSelectorsErrorKind::InvalidEventSelectorsException(_inner) => Some(_inner),
            PutEventSelectorsErrorKind::InvalidHomeRegionException(_inner) => Some(_inner),
            PutEventSelectorsErrorKind::InvalidTrailNameException(_inner) => Some(_inner),
            PutEventSelectorsErrorKind::NotOrganizationMasterAccountException(_inner) => {
                Some(_inner)
            }
            PutEventSelectorsErrorKind::OperationNotPermittedException(_inner) => Some(_inner),
            PutEventSelectorsErrorKind::TrailNotFoundException(_inner) => Some(_inner),
            PutEventSelectorsErrorKind::UnsupportedOperationException(_inner) => Some(_inner),
            PutEventSelectorsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `PutInsightSelectors` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct PutInsightSelectorsError {
    /// Kind of error that occurred.
    pub kind: PutInsightSelectorsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `PutInsightSelectors` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum PutInsightSelectorsErrorKind {
    /// <p>This exception is thrown when the policy on the S3 bucket or KMS key is not sufficient.</p>
    InsufficientEncryptionPolicyException(crate::error::InsufficientEncryptionPolicyException),
    /// <p>This exception is thrown when the policy on the S3 bucket is not sufficient.</p>
    InsufficientS3BucketPolicyException(crate::error::InsufficientS3BucketPolicyException),
    /// <p>This exception is thrown when an operation is called on a trail from a region other than the region in which the trail was created.</p>
    InvalidHomeRegionException(crate::error::InvalidHomeRegionException),
    /// <p>The formatting or syntax of the <code>InsightSelectors</code> JSON statement in your <code>PutInsightSelectors</code> or <code>GetInsightSelectors</code> request is not valid, or the specified insight type in the <code>InsightSelectors</code> statement is not a valid insight type.</p>
    InvalidInsightSelectorsException(crate::error::InvalidInsightSelectorsException),
    /// <p>This exception is thrown when the provided trail name is not valid. Trail names must meet the following requirements:</p>
    /// <ul>
    /// <li> <p>Contain only ASCII letters (a-z, A-Z), numbers (0-9), periods (.), underscores (_), or dashes (-)</p> </li>
    /// <li> <p>Start with a letter or number, and end with a letter or number</p> </li>
    /// <li> <p>Be between 3 and 128 characters</p> </li>
    /// <li> <p>Have no adjacent periods, underscores or dashes. Names like <code>my-_namespace</code> and <code>my--namespace</code> are not valid.</p> </li>
    /// <li> <p>Not be in IP address format (for example, 192.168.5.4)</p> </li>
    /// </ul>
    InvalidTrailNameException(crate::error::InvalidTrailNameException),
    /// <p>This exception is thrown when there is an issue with the specified KMS key and the trail can’t be updated.</p>
    KmsException(crate::error::KmsException),
    /// <p>This exception is thrown when the Amazon Web Services account making the request to create or update an organization trail is not the management account for an organization in Organizations. For more information, see <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/creating-an-organizational-trail-prepare.html">Prepare For Creating a Trail For Your Organization</a>.</p>
    NotOrganizationMasterAccountException(crate::error::NotOrganizationMasterAccountException),
    /// <p>This exception is thrown when the requested operation is not permitted.</p>
    OperationNotPermittedException(crate::error::OperationNotPermittedException),
    /// <p>This exception is thrown when the specified S3 bucket does not exist.</p>
    S3BucketDoesNotExistException(crate::error::S3BucketDoesNotExistException),
    /// <p>This exception is thrown when the trail with the given name is not found.</p>
    TrailNotFoundException(crate::error::TrailNotFoundException),
    /// <p>This exception is thrown when the requested operation is not supported.</p>
    UnsupportedOperationException(crate::error::UnsupportedOperationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for PutInsightSelectorsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            PutInsightSelectorsErrorKind::InsufficientEncryptionPolicyException(_inner) => {
                _inner.fmt(f)
            }
            PutInsightSelectorsErrorKind::InsufficientS3BucketPolicyException(_inner) => {
                _inner.fmt(f)
            }
            PutInsightSelectorsErrorKind::InvalidHomeRegionException(_inner) => _inner.fmt(f),
            PutInsightSelectorsErrorKind::InvalidInsightSelectorsException(_inner) => _inner.fmt(f),
            PutInsightSelectorsErrorKind::InvalidTrailNameException(_inner) => _inner.fmt(f),
            PutInsightSelectorsErrorKind::KmsException(_inner) => _inner.fmt(f),
            PutInsightSelectorsErrorKind::NotOrganizationMasterAccountException(_inner) => {
                _inner.fmt(f)
            }
            PutInsightSelectorsErrorKind::OperationNotPermittedException(_inner) => _inner.fmt(f),
            PutInsightSelectorsErrorKind::S3BucketDoesNotExistException(_inner) => _inner.fmt(f),
            PutInsightSelectorsErrorKind::TrailNotFoundException(_inner) => _inner.fmt(f),
            PutInsightSelectorsErrorKind::UnsupportedOperationException(_inner) => _inner.fmt(f),
            PutInsightSelectorsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for PutInsightSelectorsError {
    fn code(&self) -> Option<&str> {
        PutInsightSelectorsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl PutInsightSelectorsError {
    /// Creates a new `PutInsightSelectorsError`.
    pub fn new(kind: PutInsightSelectorsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `PutInsightSelectorsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: PutInsightSelectorsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `PutInsightSelectorsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: PutInsightSelectorsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `PutInsightSelectorsErrorKind::InsufficientEncryptionPolicyException`.
    pub fn is_insufficient_encryption_policy_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutInsightSelectorsErrorKind::InsufficientEncryptionPolicyException(_)
        )
    }
    /// Returns `true` if the error kind is `PutInsightSelectorsErrorKind::InsufficientS3BucketPolicyException`.
    pub fn is_insufficient_s3_bucket_policy_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutInsightSelectorsErrorKind::InsufficientS3BucketPolicyException(_)
        )
    }
    /// Returns `true` if the error kind is `PutInsightSelectorsErrorKind::InvalidHomeRegionException`.
    pub fn is_invalid_home_region_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutInsightSelectorsErrorKind::InvalidHomeRegionException(_)
        )
    }
    /// Returns `true` if the error kind is `PutInsightSelectorsErrorKind::InvalidInsightSelectorsException`.
    pub fn is_invalid_insight_selectors_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutInsightSelectorsErrorKind::InvalidInsightSelectorsException(_)
        )
    }
    /// Returns `true` if the error kind is `PutInsightSelectorsErrorKind::InvalidTrailNameException`.
    pub fn is_invalid_trail_name_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutInsightSelectorsErrorKind::InvalidTrailNameException(_)
        )
    }
    /// Returns `true` if the error kind is `PutInsightSelectorsErrorKind::KmsException`.
    pub fn is_kms_exception(&self) -> bool {
        matches!(&self.kind, PutInsightSelectorsErrorKind::KmsException(_))
    }
    /// Returns `true` if the error kind is `PutInsightSelectorsErrorKind::NotOrganizationMasterAccountException`.
    pub fn is_not_organization_master_account_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutInsightSelectorsErrorKind::NotOrganizationMasterAccountException(_)
        )
    }
    /// Returns `true` if the error kind is `PutInsightSelectorsErrorKind::OperationNotPermittedException`.
    pub fn is_operation_not_permitted_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutInsightSelectorsErrorKind::OperationNotPermittedException(_)
        )
    }
    /// Returns `true` if the error kind is `PutInsightSelectorsErrorKind::S3BucketDoesNotExistException`.
    pub fn is_s3_bucket_does_not_exist_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutInsightSelectorsErrorKind::S3BucketDoesNotExistException(_)
        )
    }
    /// Returns `true` if the error kind is `PutInsightSelectorsErrorKind::TrailNotFoundException`.
    pub fn is_trail_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutInsightSelectorsErrorKind::TrailNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `PutInsightSelectorsErrorKind::UnsupportedOperationException`.
    pub fn is_unsupported_operation_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutInsightSelectorsErrorKind::UnsupportedOperationException(_)
        )
    }
}
impl std::error::Error for PutInsightSelectorsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            PutInsightSelectorsErrorKind::InsufficientEncryptionPolicyException(_inner) => {
                Some(_inner)
            }
            PutInsightSelectorsErrorKind::InsufficientS3BucketPolicyException(_inner) => {
                Some(_inner)
            }
            PutInsightSelectorsErrorKind::InvalidHomeRegionException(_inner) => Some(_inner),
            PutInsightSelectorsErrorKind::InvalidInsightSelectorsException(_inner) => Some(_inner),
            PutInsightSelectorsErrorKind::InvalidTrailNameException(_inner) => Some(_inner),
            PutInsightSelectorsErrorKind::KmsException(_inner) => Some(_inner),
            PutInsightSelectorsErrorKind::NotOrganizationMasterAccountException(_inner) => {
                Some(_inner)
            }
            PutInsightSelectorsErrorKind::OperationNotPermittedException(_inner) => Some(_inner),
            PutInsightSelectorsErrorKind::S3BucketDoesNotExistException(_inner) => Some(_inner),
            PutInsightSelectorsErrorKind::TrailNotFoundException(_inner) => Some(_inner),
            PutInsightSelectorsErrorKind::UnsupportedOperationException(_inner) => Some(_inner),
            PutInsightSelectorsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `RemoveTags` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct RemoveTagsError {
    /// Kind of error that occurred.
    pub kind: RemoveTagsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `RemoveTags` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum RemoveTagsErrorKind {
    /// <p>This exception is thrown when an operation is called with a trail ARN that is not valid. The following is the format of a trail ARN.</p>
    /// <p> <code>arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail</code> </p>
    CloudTrailArnInvalidException(crate::error::CloudTrailArnInvalidException),
    /// <p>The specified event data store was not found.</p>
    EventDataStoreNotFoundException(crate::error::EventDataStoreNotFoundException),
    /// <p>The event data store against which you ran your query is inactive.</p>
    InactiveEventDataStoreException(crate::error::InactiveEventDataStoreException),
    /// <p>This exception is thrown when the specified tag key or values are not valid. It can also occur if there are duplicate tags or too many tags on the resource.</p>
    InvalidTagParameterException(crate::error::InvalidTagParameterException),
    /// <p>This exception is thrown when the provided trail name is not valid. Trail names must meet the following requirements:</p>
    /// <ul>
    /// <li> <p>Contain only ASCII letters (a-z, A-Z), numbers (0-9), periods (.), underscores (_), or dashes (-)</p> </li>
    /// <li> <p>Start with a letter or number, and end with a letter or number</p> </li>
    /// <li> <p>Be between 3 and 128 characters</p> </li>
    /// <li> <p>Have no adjacent periods, underscores or dashes. Names like <code>my-_namespace</code> and <code>my--namespace</code> are not valid.</p> </li>
    /// <li> <p>Not be in IP address format (for example, 192.168.5.4)</p> </li>
    /// </ul>
    InvalidTrailNameException(crate::error::InvalidTrailNameException),
    /// <p>This exception is thrown when the Amazon Web Services account making the request to create or update an organization trail is not the management account for an organization in Organizations. For more information, see <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/creating-an-organizational-trail-prepare.html">Prepare For Creating a Trail For Your Organization</a>.</p>
    NotOrganizationMasterAccountException(crate::error::NotOrganizationMasterAccountException),
    /// <p>This exception is thrown when the requested operation is not permitted.</p>
    OperationNotPermittedException(crate::error::OperationNotPermittedException),
    /// <p>This exception is thrown when the specified resource is not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>This exception is thrown when the specified resource type is not supported by CloudTrail.</p>
    ResourceTypeNotSupportedException(crate::error::ResourceTypeNotSupportedException),
    /// <p>This exception is thrown when the requested operation is not supported.</p>
    UnsupportedOperationException(crate::error::UnsupportedOperationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for RemoveTagsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            RemoveTagsErrorKind::CloudTrailArnInvalidException(_inner) => _inner.fmt(f),
            RemoveTagsErrorKind::EventDataStoreNotFoundException(_inner) => _inner.fmt(f),
            RemoveTagsErrorKind::InactiveEventDataStoreException(_inner) => _inner.fmt(f),
            RemoveTagsErrorKind::InvalidTagParameterException(_inner) => _inner.fmt(f),
            RemoveTagsErrorKind::InvalidTrailNameException(_inner) => _inner.fmt(f),
            RemoveTagsErrorKind::NotOrganizationMasterAccountException(_inner) => _inner.fmt(f),
            RemoveTagsErrorKind::OperationNotPermittedException(_inner) => _inner.fmt(f),
            RemoveTagsErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            RemoveTagsErrorKind::ResourceTypeNotSupportedException(_inner) => _inner.fmt(f),
            RemoveTagsErrorKind::UnsupportedOperationException(_inner) => _inner.fmt(f),
            RemoveTagsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for RemoveTagsError {
    fn code(&self) -> Option<&str> {
        RemoveTagsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl RemoveTagsError {
    /// Creates a new `RemoveTagsError`.
    pub fn new(kind: RemoveTagsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `RemoveTagsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: RemoveTagsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `RemoveTagsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: RemoveTagsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `RemoveTagsErrorKind::CloudTrailArnInvalidException`.
    pub fn is_cloud_trail_arn_invalid_exception(&self) -> bool {
        matches!(
            &self.kind,
            RemoveTagsErrorKind::CloudTrailArnInvalidException(_)
        )
    }
    /// Returns `true` if the error kind is `RemoveTagsErrorKind::EventDataStoreNotFoundException`.
    pub fn is_event_data_store_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            RemoveTagsErrorKind::EventDataStoreNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `RemoveTagsErrorKind::InactiveEventDataStoreException`.
    pub fn is_inactive_event_data_store_exception(&self) -> bool {
        matches!(
            &self.kind,
            RemoveTagsErrorKind::InactiveEventDataStoreException(_)
        )
    }
    /// Returns `true` if the error kind is `RemoveTagsErrorKind::InvalidTagParameterException`.
    pub fn is_invalid_tag_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            RemoveTagsErrorKind::InvalidTagParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `RemoveTagsErrorKind::InvalidTrailNameException`.
    pub fn is_invalid_trail_name_exception(&self) -> bool {
        matches!(
            &self.kind,
            RemoveTagsErrorKind::InvalidTrailNameException(_)
        )
    }
    /// Returns `true` if the error kind is `RemoveTagsErrorKind::NotOrganizationMasterAccountException`.
    pub fn is_not_organization_master_account_exception(&self) -> bool {
        matches!(
            &self.kind,
            RemoveTagsErrorKind::NotOrganizationMasterAccountException(_)
        )
    }
    /// Returns `true` if the error kind is `RemoveTagsErrorKind::OperationNotPermittedException`.
    pub fn is_operation_not_permitted_exception(&self) -> bool {
        matches!(
            &self.kind,
            RemoveTagsErrorKind::OperationNotPermittedException(_)
        )
    }
    /// Returns `true` if the error kind is `RemoveTagsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            RemoveTagsErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `RemoveTagsErrorKind::ResourceTypeNotSupportedException`.
    pub fn is_resource_type_not_supported_exception(&self) -> bool {
        matches!(
            &self.kind,
            RemoveTagsErrorKind::ResourceTypeNotSupportedException(_)
        )
    }
    /// Returns `true` if the error kind is `RemoveTagsErrorKind::UnsupportedOperationException`.
    pub fn is_unsupported_operation_exception(&self) -> bool {
        matches!(
            &self.kind,
            RemoveTagsErrorKind::UnsupportedOperationException(_)
        )
    }
}
impl std::error::Error for RemoveTagsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            RemoveTagsErrorKind::CloudTrailArnInvalidException(_inner) => Some(_inner),
            RemoveTagsErrorKind::EventDataStoreNotFoundException(_inner) => Some(_inner),
            RemoveTagsErrorKind::InactiveEventDataStoreException(_inner) => Some(_inner),
            RemoveTagsErrorKind::InvalidTagParameterException(_inner) => Some(_inner),
            RemoveTagsErrorKind::InvalidTrailNameException(_inner) => Some(_inner),
            RemoveTagsErrorKind::NotOrganizationMasterAccountException(_inner) => Some(_inner),
            RemoveTagsErrorKind::OperationNotPermittedException(_inner) => Some(_inner),
            RemoveTagsErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            RemoveTagsErrorKind::ResourceTypeNotSupportedException(_inner) => Some(_inner),
            RemoveTagsErrorKind::UnsupportedOperationException(_inner) => Some(_inner),
            RemoveTagsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `RestoreEventDataStore` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct RestoreEventDataStoreError {
    /// Kind of error that occurred.
    pub kind: RestoreEventDataStoreErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `RestoreEventDataStore` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum RestoreEventDataStoreErrorKind {
    /// <p>This exception is thrown when trusted access has not been enabled between CloudTrail and Organizations. For more information, see <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_integrate_services.html">Enabling Trusted Access with Other Amazon Web Services Services</a> and <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/creating-an-organizational-trail-prepare.html">Prepare For Creating a Trail For Your Organization</a>. </p>
    CloudTrailAccessNotEnabledException(crate::error::CloudTrailAccessNotEnabledException),
    /// <p>The specified event data store ARN is not valid or does not map to an event data store in your account.</p>
    EventDataStoreArnInvalidException(crate::error::EventDataStoreArnInvalidException),
    /// <p>Your account has used the maximum number of event data stores.</p>
    EventDataStoreMaxLimitExceededException(crate::error::EventDataStoreMaxLimitExceededException),
    /// <p>The specified event data store was not found.</p>
    EventDataStoreNotFoundException(crate::error::EventDataStoreNotFoundException),
    /// <p>This exception is thrown when the IAM user or role that is used to create the organization trail is lacking one or more required permissions for creating an organization trail in a required service. For more information, see <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/creating-an-organizational-trail-prepare.html">Prepare For Creating a Trail For Your Organization</a>.</p>
    InsufficientDependencyServiceAccessPermissionException(
        crate::error::InsufficientDependencyServiceAccessPermissionException,
    ),
    /// <p>The event data store is not in a status that supports the operation.</p>
    InvalidEventDataStoreStatusException(crate::error::InvalidEventDataStoreStatusException),
    /// <p>The request includes a parameter that is not valid.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>This exception is thrown when the Amazon Web Services account making the request to create or update an organization trail is not the management account for an organization in Organizations. For more information, see <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/creating-an-organizational-trail-prepare.html">Prepare For Creating a Trail For Your Organization</a>.</p>
    NotOrganizationMasterAccountException(crate::error::NotOrganizationMasterAccountException),
    /// <p>This exception is thrown when the requested operation is not permitted.</p>
    OperationNotPermittedException(crate::error::OperationNotPermittedException),
    /// <p>This exception is thrown when Organizations is not configured to support all features. All features must be enabled in Organizations to support creating an organization trail. For more information, see <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/creating-an-organizational-trail-prepare.html">Prepare For Creating a Trail For Your Organization</a>.</p>
    OrganizationNotInAllFeaturesModeException(
        crate::error::OrganizationNotInAllFeaturesModeException,
    ),
    /// <p>This exception is thrown when the request is made from an Amazon Web Services account that is not a member of an organization. To make this request, sign in using the credentials of an account that belongs to an organization.</p>
    OrganizationsNotInUseException(crate::error::OrganizationsNotInUseException),
    /// <p>This exception is thrown when the requested operation is not supported.</p>
    UnsupportedOperationException(crate::error::UnsupportedOperationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for RestoreEventDataStoreError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            RestoreEventDataStoreErrorKind::CloudTrailAccessNotEnabledException(_inner) =>
            _inner.fmt(f)
            ,
            RestoreEventDataStoreErrorKind::EventDataStoreArnInvalidException(_inner) =>
            _inner.fmt(f)
            ,
            RestoreEventDataStoreErrorKind::EventDataStoreMaxLimitExceededException(_inner) =>
            _inner.fmt(f)
            ,
            RestoreEventDataStoreErrorKind::EventDataStoreNotFoundException(_inner) =>
            _inner.fmt(f)
            ,
            RestoreEventDataStoreErrorKind::InsufficientDependencyServiceAccessPermissionException(_inner) =>
            _inner.fmt(f)
            ,
            RestoreEventDataStoreErrorKind::InvalidEventDataStoreStatusException(_inner) =>
            _inner.fmt(f)
            ,
            RestoreEventDataStoreErrorKind::InvalidParameterException(_inner) =>
            _inner.fmt(f)
            ,
            RestoreEventDataStoreErrorKind::NotOrganizationMasterAccountException(_inner) =>
            _inner.fmt(f)
            ,
            RestoreEventDataStoreErrorKind::OperationNotPermittedException(_inner) =>
            _inner.fmt(f)
            ,
            RestoreEventDataStoreErrorKind::OrganizationNotInAllFeaturesModeException(_inner) =>
            _inner.fmt(f)
            ,
            RestoreEventDataStoreErrorKind::OrganizationsNotInUseException(_inner) =>
            _inner.fmt(f)
            ,
            RestoreEventDataStoreErrorKind::UnsupportedOperationException(_inner) =>
            _inner.fmt(f)
            ,
            RestoreEventDataStoreErrorKind::Unhandled(_inner) => {
                _inner.fmt(f)
            }
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for RestoreEventDataStoreError {
    fn code(&self) -> Option<&str> {
        RestoreEventDataStoreError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl RestoreEventDataStoreError {
    /// Creates a new `RestoreEventDataStoreError`.
    pub fn new(kind: RestoreEventDataStoreErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `RestoreEventDataStoreError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: RestoreEventDataStoreErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `RestoreEventDataStoreError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: RestoreEventDataStoreErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `RestoreEventDataStoreErrorKind::CloudTrailAccessNotEnabledException`.
    pub fn is_cloud_trail_access_not_enabled_exception(&self) -> bool {
        matches!(
            &self.kind,
            RestoreEventDataStoreErrorKind::CloudTrailAccessNotEnabledException(_)
        )
    }
    /// Returns `true` if the error kind is `RestoreEventDataStoreErrorKind::EventDataStoreArnInvalidException`.
    pub fn is_event_data_store_arn_invalid_exception(&self) -> bool {
        matches!(
            &self.kind,
            RestoreEventDataStoreErrorKind::EventDataStoreArnInvalidException(_)
        )
    }
    /// Returns `true` if the error kind is `RestoreEventDataStoreErrorKind::EventDataStoreMaxLimitExceededException`.
    pub fn is_event_data_store_max_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            RestoreEventDataStoreErrorKind::EventDataStoreMaxLimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `RestoreEventDataStoreErrorKind::EventDataStoreNotFoundException`.
    pub fn is_event_data_store_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            RestoreEventDataStoreErrorKind::EventDataStoreNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `RestoreEventDataStoreErrorKind::InsufficientDependencyServiceAccessPermissionException`.
    pub fn is_insufficient_dependency_service_access_permission_exception(&self) -> bool {
        matches!(
            &self.kind,
            RestoreEventDataStoreErrorKind::InsufficientDependencyServiceAccessPermissionException(
                _
            )
        )
    }
    /// Returns `true` if the error kind is `RestoreEventDataStoreErrorKind::InvalidEventDataStoreStatusException`.
    pub fn is_invalid_event_data_store_status_exception(&self) -> bool {
        matches!(
            &self.kind,
            RestoreEventDataStoreErrorKind::InvalidEventDataStoreStatusException(_)
        )
    }
    /// Returns `true` if the error kind is `RestoreEventDataStoreErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            RestoreEventDataStoreErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `RestoreEventDataStoreErrorKind::NotOrganizationMasterAccountException`.
    pub fn is_not_organization_master_account_exception(&self) -> bool {
        matches!(
            &self.kind,
            RestoreEventDataStoreErrorKind::NotOrganizationMasterAccountException(_)
        )
    }
    /// Returns `true` if the error kind is `RestoreEventDataStoreErrorKind::OperationNotPermittedException`.
    pub fn is_operation_not_permitted_exception(&self) -> bool {
        matches!(
            &self.kind,
            RestoreEventDataStoreErrorKind::OperationNotPermittedException(_)
        )
    }
    /// Returns `true` if the error kind is `RestoreEventDataStoreErrorKind::OrganizationNotInAllFeaturesModeException`.
    pub fn is_organization_not_in_all_features_mode_exception(&self) -> bool {
        matches!(
            &self.kind,
            RestoreEventDataStoreErrorKind::OrganizationNotInAllFeaturesModeException(_)
        )
    }
    /// Returns `true` if the error kind is `RestoreEventDataStoreErrorKind::OrganizationsNotInUseException`.
    pub fn is_organizations_not_in_use_exception(&self) -> bool {
        matches!(
            &self.kind,
            RestoreEventDataStoreErrorKind::OrganizationsNotInUseException(_)
        )
    }
    /// Returns `true` if the error kind is `RestoreEventDataStoreErrorKind::UnsupportedOperationException`.
    pub fn is_unsupported_operation_exception(&self) -> bool {
        matches!(
            &self.kind,
            RestoreEventDataStoreErrorKind::UnsupportedOperationException(_)
        )
    }
}
impl std::error::Error for RestoreEventDataStoreError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            RestoreEventDataStoreErrorKind::CloudTrailAccessNotEnabledException(_inner) =>
            Some(_inner)
            ,
            RestoreEventDataStoreErrorKind::EventDataStoreArnInvalidException(_inner) =>
            Some(_inner)
            ,
            RestoreEventDataStoreErrorKind::EventDataStoreMaxLimitExceededException(_inner) =>
            Some(_inner)
            ,
            RestoreEventDataStoreErrorKind::EventDataStoreNotFoundException(_inner) =>
            Some(_inner)
            ,
            RestoreEventDataStoreErrorKind::InsufficientDependencyServiceAccessPermissionException(_inner) =>
            Some(_inner)
            ,
            RestoreEventDataStoreErrorKind::InvalidEventDataStoreStatusException(_inner) =>
            Some(_inner)
            ,
            RestoreEventDataStoreErrorKind::InvalidParameterException(_inner) =>
            Some(_inner)
            ,
            RestoreEventDataStoreErrorKind::NotOrganizationMasterAccountException(_inner) =>
            Some(_inner)
            ,
            RestoreEventDataStoreErrorKind::OperationNotPermittedException(_inner) =>
            Some(_inner)
            ,
            RestoreEventDataStoreErrorKind::OrganizationNotInAllFeaturesModeException(_inner) =>
            Some(_inner)
            ,
            RestoreEventDataStoreErrorKind::OrganizationsNotInUseException(_inner) =>
            Some(_inner)
            ,
            RestoreEventDataStoreErrorKind::UnsupportedOperationException(_inner) =>
            Some(_inner)
            ,
            RestoreEventDataStoreErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `StartLogging` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct StartLoggingError {
    /// Kind of error that occurred.
    pub kind: StartLoggingErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `StartLogging` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum StartLoggingErrorKind {
    /// <p>This exception is thrown when the IAM user or role that is used to create the organization trail is lacking one or more required permissions for creating an organization trail in a required service. For more information, see <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/creating-an-organizational-trail-prepare.html">Prepare For Creating a Trail For Your Organization</a>.</p>
    InsufficientDependencyServiceAccessPermissionException(
        crate::error::InsufficientDependencyServiceAccessPermissionException,
    ),
    /// <p>This exception is thrown when an operation is called on a trail from a region other than the region in which the trail was created.</p>
    InvalidHomeRegionException(crate::error::InvalidHomeRegionException),
    /// <p>This exception is thrown when the provided trail name is not valid. Trail names must meet the following requirements:</p>
    /// <ul>
    /// <li> <p>Contain only ASCII letters (a-z, A-Z), numbers (0-9), periods (.), underscores (_), or dashes (-)</p> </li>
    /// <li> <p>Start with a letter or number, and end with a letter or number</p> </li>
    /// <li> <p>Be between 3 and 128 characters</p> </li>
    /// <li> <p>Have no adjacent periods, underscores or dashes. Names like <code>my-_namespace</code> and <code>my--namespace</code> are not valid.</p> </li>
    /// <li> <p>Not be in IP address format (for example, 192.168.5.4)</p> </li>
    /// </ul>
    InvalidTrailNameException(crate::error::InvalidTrailNameException),
    /// <p>This exception is thrown when the Amazon Web Services account making the request to create or update an organization trail is not the management account for an organization in Organizations. For more information, see <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/creating-an-organizational-trail-prepare.html">Prepare For Creating a Trail For Your Organization</a>.</p>
    NotOrganizationMasterAccountException(crate::error::NotOrganizationMasterAccountException),
    /// <p>This exception is thrown when the requested operation is not permitted.</p>
    OperationNotPermittedException(crate::error::OperationNotPermittedException),
    /// <p>This exception is thrown when the trail with the given name is not found.</p>
    TrailNotFoundException(crate::error::TrailNotFoundException),
    /// <p>This exception is thrown when the requested operation is not supported.</p>
    UnsupportedOperationException(crate::error::UnsupportedOperationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for StartLoggingError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            StartLoggingErrorKind::InsufficientDependencyServiceAccessPermissionException(
                _inner,
            ) => _inner.fmt(f),
            StartLoggingErrorKind::InvalidHomeRegionException(_inner) => _inner.fmt(f),
            StartLoggingErrorKind::InvalidTrailNameException(_inner) => _inner.fmt(f),
            StartLoggingErrorKind::NotOrganizationMasterAccountException(_inner) => _inner.fmt(f),
            StartLoggingErrorKind::OperationNotPermittedException(_inner) => _inner.fmt(f),
            StartLoggingErrorKind::TrailNotFoundException(_inner) => _inner.fmt(f),
            StartLoggingErrorKind::UnsupportedOperationException(_inner) => _inner.fmt(f),
            StartLoggingErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for StartLoggingError {
    fn code(&self) -> Option<&str> {
        StartLoggingError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl StartLoggingError {
    /// Creates a new `StartLoggingError`.
    pub fn new(kind: StartLoggingErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `StartLoggingError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: StartLoggingErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `StartLoggingError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: StartLoggingErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `StartLoggingErrorKind::InsufficientDependencyServiceAccessPermissionException`.
    pub fn is_insufficient_dependency_service_access_permission_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartLoggingErrorKind::InsufficientDependencyServiceAccessPermissionException(_)
        )
    }
    /// Returns `true` if the error kind is `StartLoggingErrorKind::InvalidHomeRegionException`.
    pub fn is_invalid_home_region_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartLoggingErrorKind::InvalidHomeRegionException(_)
        )
    }
    /// Returns `true` if the error kind is `StartLoggingErrorKind::InvalidTrailNameException`.
    pub fn is_invalid_trail_name_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartLoggingErrorKind::InvalidTrailNameException(_)
        )
    }
    /// Returns `true` if the error kind is `StartLoggingErrorKind::NotOrganizationMasterAccountException`.
    pub fn is_not_organization_master_account_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartLoggingErrorKind::NotOrganizationMasterAccountException(_)
        )
    }
    /// Returns `true` if the error kind is `StartLoggingErrorKind::OperationNotPermittedException`.
    pub fn is_operation_not_permitted_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartLoggingErrorKind::OperationNotPermittedException(_)
        )
    }
    /// Returns `true` if the error kind is `StartLoggingErrorKind::TrailNotFoundException`.
    pub fn is_trail_not_found_exception(&self) -> bool {
        matches!(&self.kind, StartLoggingErrorKind::TrailNotFoundException(_))
    }
    /// Returns `true` if the error kind is `StartLoggingErrorKind::UnsupportedOperationException`.
    pub fn is_unsupported_operation_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartLoggingErrorKind::UnsupportedOperationException(_)
        )
    }
}
impl std::error::Error for StartLoggingError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            StartLoggingErrorKind::InsufficientDependencyServiceAccessPermissionException(
                _inner,
            ) => Some(_inner),
            StartLoggingErrorKind::InvalidHomeRegionException(_inner) => Some(_inner),
            StartLoggingErrorKind::InvalidTrailNameException(_inner) => Some(_inner),
            StartLoggingErrorKind::NotOrganizationMasterAccountException(_inner) => Some(_inner),
            StartLoggingErrorKind::OperationNotPermittedException(_inner) => Some(_inner),
            StartLoggingErrorKind::TrailNotFoundException(_inner) => Some(_inner),
            StartLoggingErrorKind::UnsupportedOperationException(_inner) => Some(_inner),
            StartLoggingErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `StartQuery` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct StartQueryError {
    /// Kind of error that occurred.
    pub kind: StartQueryErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `StartQuery` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum StartQueryErrorKind {
    /// <p>The specified event data store ARN is not valid or does not map to an event data store in your account.</p>
    EventDataStoreArnInvalidException(crate::error::EventDataStoreArnInvalidException),
    /// <p>The specified event data store was not found.</p>
    EventDataStoreNotFoundException(crate::error::EventDataStoreNotFoundException),
    /// <p>The event data store against which you ran your query is inactive.</p>
    InactiveEventDataStoreException(crate::error::InactiveEventDataStoreException),
    /// <p>The request includes a parameter that is not valid.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>The query that was submitted has validation errors, or uses incorrect syntax or unsupported keywords. For more information about writing a query, see <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/query-create-edit-query.html">Create or edit a query</a> in the <i>CloudTrail User Guide</i>.</p>
    InvalidQueryStatementException(crate::error::InvalidQueryStatementException),
    /// <p>You are already running the maximum number of concurrent queries. Wait a minute for some queries to finish, and then run the query again.</p>
    MaxConcurrentQueriesException(crate::error::MaxConcurrentQueriesException),
    /// <p>This exception is thrown when the requested operation is not permitted.</p>
    OperationNotPermittedException(crate::error::OperationNotPermittedException),
    /// <p>This exception is thrown when the requested operation is not supported.</p>
    UnsupportedOperationException(crate::error::UnsupportedOperationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for StartQueryError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            StartQueryErrorKind::EventDataStoreArnInvalidException(_inner) => _inner.fmt(f),
            StartQueryErrorKind::EventDataStoreNotFoundException(_inner) => _inner.fmt(f),
            StartQueryErrorKind::InactiveEventDataStoreException(_inner) => _inner.fmt(f),
            StartQueryErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            StartQueryErrorKind::InvalidQueryStatementException(_inner) => _inner.fmt(f),
            StartQueryErrorKind::MaxConcurrentQueriesException(_inner) => _inner.fmt(f),
            StartQueryErrorKind::OperationNotPermittedException(_inner) => _inner.fmt(f),
            StartQueryErrorKind::UnsupportedOperationException(_inner) => _inner.fmt(f),
            StartQueryErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for StartQueryError {
    fn code(&self) -> Option<&str> {
        StartQueryError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl StartQueryError {
    /// Creates a new `StartQueryError`.
    pub fn new(kind: StartQueryErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `StartQueryError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: StartQueryErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `StartQueryError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: StartQueryErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `StartQueryErrorKind::EventDataStoreArnInvalidException`.
    pub fn is_event_data_store_arn_invalid_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartQueryErrorKind::EventDataStoreArnInvalidException(_)
        )
    }
    /// Returns `true` if the error kind is `StartQueryErrorKind::EventDataStoreNotFoundException`.
    pub fn is_event_data_store_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartQueryErrorKind::EventDataStoreNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `StartQueryErrorKind::InactiveEventDataStoreException`.
    pub fn is_inactive_event_data_store_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartQueryErrorKind::InactiveEventDataStoreException(_)
        )
    }
    /// Returns `true` if the error kind is `StartQueryErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartQueryErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `StartQueryErrorKind::InvalidQueryStatementException`.
    pub fn is_invalid_query_statement_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartQueryErrorKind::InvalidQueryStatementException(_)
        )
    }
    /// Returns `true` if the error kind is `StartQueryErrorKind::MaxConcurrentQueriesException`.
    pub fn is_max_concurrent_queries_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartQueryErrorKind::MaxConcurrentQueriesException(_)
        )
    }
    /// Returns `true` if the error kind is `StartQueryErrorKind::OperationNotPermittedException`.
    pub fn is_operation_not_permitted_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartQueryErrorKind::OperationNotPermittedException(_)
        )
    }
    /// Returns `true` if the error kind is `StartQueryErrorKind::UnsupportedOperationException`.
    pub fn is_unsupported_operation_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartQueryErrorKind::UnsupportedOperationException(_)
        )
    }
}
impl std::error::Error for StartQueryError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            StartQueryErrorKind::EventDataStoreArnInvalidException(_inner) => Some(_inner),
            StartQueryErrorKind::EventDataStoreNotFoundException(_inner) => Some(_inner),
            StartQueryErrorKind::InactiveEventDataStoreException(_inner) => Some(_inner),
            StartQueryErrorKind::InvalidParameterException(_inner) => Some(_inner),
            StartQueryErrorKind::InvalidQueryStatementException(_inner) => Some(_inner),
            StartQueryErrorKind::MaxConcurrentQueriesException(_inner) => Some(_inner),
            StartQueryErrorKind::OperationNotPermittedException(_inner) => Some(_inner),
            StartQueryErrorKind::UnsupportedOperationException(_inner) => Some(_inner),
            StartQueryErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `StopLogging` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct StopLoggingError {
    /// Kind of error that occurred.
    pub kind: StopLoggingErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `StopLogging` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum StopLoggingErrorKind {
    /// <p>This exception is thrown when the IAM user or role that is used to create the organization trail is lacking one or more required permissions for creating an organization trail in a required service. For more information, see <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/creating-an-organizational-trail-prepare.html">Prepare For Creating a Trail For Your Organization</a>.</p>
    InsufficientDependencyServiceAccessPermissionException(
        crate::error::InsufficientDependencyServiceAccessPermissionException,
    ),
    /// <p>This exception is thrown when an operation is called on a trail from a region other than the region in which the trail was created.</p>
    InvalidHomeRegionException(crate::error::InvalidHomeRegionException),
    /// <p>This exception is thrown when the provided trail name is not valid. Trail names must meet the following requirements:</p>
    /// <ul>
    /// <li> <p>Contain only ASCII letters (a-z, A-Z), numbers (0-9), periods (.), underscores (_), or dashes (-)</p> </li>
    /// <li> <p>Start with a letter or number, and end with a letter or number</p> </li>
    /// <li> <p>Be between 3 and 128 characters</p> </li>
    /// <li> <p>Have no adjacent periods, underscores or dashes. Names like <code>my-_namespace</code> and <code>my--namespace</code> are not valid.</p> </li>
    /// <li> <p>Not be in IP address format (for example, 192.168.5.4)</p> </li>
    /// </ul>
    InvalidTrailNameException(crate::error::InvalidTrailNameException),
    /// <p>This exception is thrown when the Amazon Web Services account making the request to create or update an organization trail is not the management account for an organization in Organizations. For more information, see <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/creating-an-organizational-trail-prepare.html">Prepare For Creating a Trail For Your Organization</a>.</p>
    NotOrganizationMasterAccountException(crate::error::NotOrganizationMasterAccountException),
    /// <p>This exception is thrown when the requested operation is not permitted.</p>
    OperationNotPermittedException(crate::error::OperationNotPermittedException),
    /// <p>This exception is thrown when the trail with the given name is not found.</p>
    TrailNotFoundException(crate::error::TrailNotFoundException),
    /// <p>This exception is thrown when the requested operation is not supported.</p>
    UnsupportedOperationException(crate::error::UnsupportedOperationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for StopLoggingError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            StopLoggingErrorKind::InsufficientDependencyServiceAccessPermissionException(
                _inner,
            ) => _inner.fmt(f),
            StopLoggingErrorKind::InvalidHomeRegionException(_inner) => _inner.fmt(f),
            StopLoggingErrorKind::InvalidTrailNameException(_inner) => _inner.fmt(f),
            StopLoggingErrorKind::NotOrganizationMasterAccountException(_inner) => _inner.fmt(f),
            StopLoggingErrorKind::OperationNotPermittedException(_inner) => _inner.fmt(f),
            StopLoggingErrorKind::TrailNotFoundException(_inner) => _inner.fmt(f),
            StopLoggingErrorKind::UnsupportedOperationException(_inner) => _inner.fmt(f),
            StopLoggingErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for StopLoggingError {
    fn code(&self) -> Option<&str> {
        StopLoggingError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl StopLoggingError {
    /// Creates a new `StopLoggingError`.
    pub fn new(kind: StopLoggingErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `StopLoggingError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: StopLoggingErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `StopLoggingError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: StopLoggingErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `StopLoggingErrorKind::InsufficientDependencyServiceAccessPermissionException`.
    pub fn is_insufficient_dependency_service_access_permission_exception(&self) -> bool {
        matches!(
            &self.kind,
            StopLoggingErrorKind::InsufficientDependencyServiceAccessPermissionException(_)
        )
    }
    /// Returns `true` if the error kind is `StopLoggingErrorKind::InvalidHomeRegionException`.
    pub fn is_invalid_home_region_exception(&self) -> bool {
        matches!(
            &self.kind,
            StopLoggingErrorKind::InvalidHomeRegionException(_)
        )
    }
    /// Returns `true` if the error kind is `StopLoggingErrorKind::InvalidTrailNameException`.
    pub fn is_invalid_trail_name_exception(&self) -> bool {
        matches!(
            &self.kind,
            StopLoggingErrorKind::InvalidTrailNameException(_)
        )
    }
    /// Returns `true` if the error kind is `StopLoggingErrorKind::NotOrganizationMasterAccountException`.
    pub fn is_not_organization_master_account_exception(&self) -> bool {
        matches!(
            &self.kind,
            StopLoggingErrorKind::NotOrganizationMasterAccountException(_)
        )
    }
    /// Returns `true` if the error kind is `StopLoggingErrorKind::OperationNotPermittedException`.
    pub fn is_operation_not_permitted_exception(&self) -> bool {
        matches!(
            &self.kind,
            StopLoggingErrorKind::OperationNotPermittedException(_)
        )
    }
    /// Returns `true` if the error kind is `StopLoggingErrorKind::TrailNotFoundException`.
    pub fn is_trail_not_found_exception(&self) -> bool {
        matches!(&self.kind, StopLoggingErrorKind::TrailNotFoundException(_))
    }
    /// Returns `true` if the error kind is `StopLoggingErrorKind::UnsupportedOperationException`.
    pub fn is_unsupported_operation_exception(&self) -> bool {
        matches!(
            &self.kind,
            StopLoggingErrorKind::UnsupportedOperationException(_)
        )
    }
}
impl std::error::Error for StopLoggingError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            StopLoggingErrorKind::InsufficientDependencyServiceAccessPermissionException(
                _inner,
            ) => Some(_inner),
            StopLoggingErrorKind::InvalidHomeRegionException(_inner) => Some(_inner),
            StopLoggingErrorKind::InvalidTrailNameException(_inner) => Some(_inner),
            StopLoggingErrorKind::NotOrganizationMasterAccountException(_inner) => Some(_inner),
            StopLoggingErrorKind::OperationNotPermittedException(_inner) => Some(_inner),
            StopLoggingErrorKind::TrailNotFoundException(_inner) => Some(_inner),
            StopLoggingErrorKind::UnsupportedOperationException(_inner) => Some(_inner),
            StopLoggingErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateEventDataStore` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateEventDataStoreError {
    /// Kind of error that occurred.
    pub kind: UpdateEventDataStoreErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateEventDataStore` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateEventDataStoreErrorKind {
    /// <p>This exception is thrown when trusted access has not been enabled between CloudTrail and Organizations. For more information, see <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_integrate_services.html">Enabling Trusted Access with Other Amazon Web Services Services</a> and <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/creating-an-organizational-trail-prepare.html">Prepare For Creating a Trail For Your Organization</a>. </p>
    CloudTrailAccessNotEnabledException(crate::error::CloudTrailAccessNotEnabledException),
    /// <p>The specified event data store ARN is not valid or does not map to an event data store in your account.</p>
    EventDataStoreArnInvalidException(crate::error::EventDataStoreArnInvalidException),
    /// <p>The specified event data store was not found.</p>
    EventDataStoreNotFoundException(crate::error::EventDataStoreNotFoundException),
    /// <p>The event data store against which you ran your query is inactive.</p>
    InactiveEventDataStoreException(crate::error::InactiveEventDataStoreException),
    /// <p>This exception is thrown when the IAM user or role that is used to create the organization trail is lacking one or more required permissions for creating an organization trail in a required service. For more information, see <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/creating-an-organizational-trail-prepare.html">Prepare For Creating a Trail For Your Organization</a>.</p>
    InsufficientDependencyServiceAccessPermissionException(
        crate::error::InsufficientDependencyServiceAccessPermissionException,
    ),
    /// <p>The request includes a parameter that is not valid.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>This exception is thrown when the Amazon Web Services account making the request to create or update an organization trail is not the management account for an organization in Organizations. For more information, see <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/creating-an-organizational-trail-prepare.html">Prepare For Creating a Trail For Your Organization</a>.</p>
    NotOrganizationMasterAccountException(crate::error::NotOrganizationMasterAccountException),
    /// <p>This exception is thrown when the requested operation is not permitted.</p>
    OperationNotPermittedException(crate::error::OperationNotPermittedException),
    /// <p>This exception is thrown when Organizations is not configured to support all features. All features must be enabled in Organizations to support creating an organization trail. For more information, see <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/creating-an-organizational-trail-prepare.html">Prepare For Creating a Trail For Your Organization</a>.</p>
    OrganizationNotInAllFeaturesModeException(
        crate::error::OrganizationNotInAllFeaturesModeException,
    ),
    /// <p>This exception is thrown when the request is made from an Amazon Web Services account that is not a member of an organization. To make this request, sign in using the credentials of an account that belongs to an organization.</p>
    OrganizationsNotInUseException(crate::error::OrganizationsNotInUseException),
    /// <p>This exception is thrown when the requested operation is not supported.</p>
    UnsupportedOperationException(crate::error::UnsupportedOperationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateEventDataStoreError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateEventDataStoreErrorKind::CloudTrailAccessNotEnabledException(_inner) =>
            _inner.fmt(f)
            ,
            UpdateEventDataStoreErrorKind::EventDataStoreArnInvalidException(_inner) =>
            _inner.fmt(f)
            ,
            UpdateEventDataStoreErrorKind::EventDataStoreNotFoundException(_inner) =>
            _inner.fmt(f)
            ,
            UpdateEventDataStoreErrorKind::InactiveEventDataStoreException(_inner) =>
            _inner.fmt(f)
            ,
            UpdateEventDataStoreErrorKind::InsufficientDependencyServiceAccessPermissionException(_inner) =>
            _inner.fmt(f)
            ,
            UpdateEventDataStoreErrorKind::InvalidParameterException(_inner) =>
            _inner.fmt(f)
            ,
            UpdateEventDataStoreErrorKind::NotOrganizationMasterAccountException(_inner) =>
            _inner.fmt(f)
            ,
            UpdateEventDataStoreErrorKind::OperationNotPermittedException(_inner) =>
            _inner.fmt(f)
            ,
            UpdateEventDataStoreErrorKind::OrganizationNotInAllFeaturesModeException(_inner) =>
            _inner.fmt(f)
            ,
            UpdateEventDataStoreErrorKind::OrganizationsNotInUseException(_inner) =>
            _inner.fmt(f)
            ,
            UpdateEventDataStoreErrorKind::UnsupportedOperationException(_inner) =>
            _inner.fmt(f)
            ,
            UpdateEventDataStoreErrorKind::Unhandled(_inner) => {
                _inner.fmt(f)
            }
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateEventDataStoreError {
    fn code(&self) -> Option<&str> {
        UpdateEventDataStoreError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateEventDataStoreError {
    /// Creates a new `UpdateEventDataStoreError`.
    pub fn new(kind: UpdateEventDataStoreErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateEventDataStoreError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateEventDataStoreErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateEventDataStoreError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateEventDataStoreErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateEventDataStoreErrorKind::CloudTrailAccessNotEnabledException`.
    pub fn is_cloud_trail_access_not_enabled_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateEventDataStoreErrorKind::CloudTrailAccessNotEnabledException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateEventDataStoreErrorKind::EventDataStoreArnInvalidException`.
    pub fn is_event_data_store_arn_invalid_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateEventDataStoreErrorKind::EventDataStoreArnInvalidException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateEventDataStoreErrorKind::EventDataStoreNotFoundException`.
    pub fn is_event_data_store_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateEventDataStoreErrorKind::EventDataStoreNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateEventDataStoreErrorKind::InactiveEventDataStoreException`.
    pub fn is_inactive_event_data_store_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateEventDataStoreErrorKind::InactiveEventDataStoreException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateEventDataStoreErrorKind::InsufficientDependencyServiceAccessPermissionException`.
    pub fn is_insufficient_dependency_service_access_permission_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateEventDataStoreErrorKind::InsufficientDependencyServiceAccessPermissionException(
                _
            )
        )
    }
    /// Returns `true` if the error kind is `UpdateEventDataStoreErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateEventDataStoreErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateEventDataStoreErrorKind::NotOrganizationMasterAccountException`.
    pub fn is_not_organization_master_account_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateEventDataStoreErrorKind::NotOrganizationMasterAccountException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateEventDataStoreErrorKind::OperationNotPermittedException`.
    pub fn is_operation_not_permitted_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateEventDataStoreErrorKind::OperationNotPermittedException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateEventDataStoreErrorKind::OrganizationNotInAllFeaturesModeException`.
    pub fn is_organization_not_in_all_features_mode_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateEventDataStoreErrorKind::OrganizationNotInAllFeaturesModeException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateEventDataStoreErrorKind::OrganizationsNotInUseException`.
    pub fn is_organizations_not_in_use_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateEventDataStoreErrorKind::OrganizationsNotInUseException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateEventDataStoreErrorKind::UnsupportedOperationException`.
    pub fn is_unsupported_operation_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateEventDataStoreErrorKind::UnsupportedOperationException(_)
        )
    }
}
impl std::error::Error for UpdateEventDataStoreError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateEventDataStoreErrorKind::CloudTrailAccessNotEnabledException(_inner) =>
            Some(_inner)
            ,
            UpdateEventDataStoreErrorKind::EventDataStoreArnInvalidException(_inner) =>
            Some(_inner)
            ,
            UpdateEventDataStoreErrorKind::EventDataStoreNotFoundException(_inner) =>
            Some(_inner)
            ,
            UpdateEventDataStoreErrorKind::InactiveEventDataStoreException(_inner) =>
            Some(_inner)
            ,
            UpdateEventDataStoreErrorKind::InsufficientDependencyServiceAccessPermissionException(_inner) =>
            Some(_inner)
            ,
            UpdateEventDataStoreErrorKind::InvalidParameterException(_inner) =>
            Some(_inner)
            ,
            UpdateEventDataStoreErrorKind::NotOrganizationMasterAccountException(_inner) =>
            Some(_inner)
            ,
            UpdateEventDataStoreErrorKind::OperationNotPermittedException(_inner) =>
            Some(_inner)
            ,
            UpdateEventDataStoreErrorKind::OrganizationNotInAllFeaturesModeException(_inner) =>
            Some(_inner)
            ,
            UpdateEventDataStoreErrorKind::OrganizationsNotInUseException(_inner) =>
            Some(_inner)
            ,
            UpdateEventDataStoreErrorKind::UnsupportedOperationException(_inner) =>
            Some(_inner)
            ,
            UpdateEventDataStoreErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `UpdateTrail` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateTrailError {
    /// Kind of error that occurred.
    pub kind: UpdateTrailErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateTrail` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateTrailErrorKind {
    /// <p>This exception is thrown when trusted access has not been enabled between CloudTrail and Organizations. For more information, see <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_integrate_services.html">Enabling Trusted Access with Other Amazon Web Services Services</a> and <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/creating-an-organizational-trail-prepare.html">Prepare For Creating a Trail For Your Organization</a>. </p>
    CloudTrailAccessNotEnabledException(crate::error::CloudTrailAccessNotEnabledException),
    /// <p>This exception is thrown when a call results in the <code>InvalidClientTokenId</code> error code. This can occur when you are creating or updating a trail to send notifications to an Amazon SNS topic that is in a suspended Amazon Web Services account.</p>
    CloudTrailInvalidClientTokenIdException(crate::error::CloudTrailInvalidClientTokenIdException),
    /// <p>Cannot set a CloudWatch Logs delivery for this region.</p>
    CloudWatchLogsDeliveryUnavailableException(
        crate::error::CloudWatchLogsDeliveryUnavailableException,
    ),
    /// <p>This exception is thrown when the IAM user or role that is used to create the organization trail is lacking one or more required permissions for creating an organization trail in a required service. For more information, see <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/creating-an-organizational-trail-prepare.html">Prepare For Creating a Trail For Your Organization</a>.</p>
    InsufficientDependencyServiceAccessPermissionException(
        crate::error::InsufficientDependencyServiceAccessPermissionException,
    ),
    /// <p>This exception is thrown when the policy on the S3 bucket or KMS key is not sufficient.</p>
    InsufficientEncryptionPolicyException(crate::error::InsufficientEncryptionPolicyException),
    /// <p>This exception is thrown when the policy on the S3 bucket is not sufficient.</p>
    InsufficientS3BucketPolicyException(crate::error::InsufficientS3BucketPolicyException),
    /// <p>This exception is thrown when the policy on the Amazon SNS topic is not sufficient.</p>
    InsufficientSnsTopicPolicyException(crate::error::InsufficientSnsTopicPolicyException),
    /// <p>This exception is thrown when the provided CloudWatch Logs log group is not valid.</p>
    InvalidCloudWatchLogsLogGroupArnException(
        crate::error::InvalidCloudWatchLogsLogGroupArnException,
    ),
    /// <p>This exception is thrown when the provided role is not valid.</p>
    InvalidCloudWatchLogsRoleArnException(crate::error::InvalidCloudWatchLogsRoleArnException),
    /// <p>This exception is thrown when the <code>PutEventSelectors</code> operation is called with a number of event selectors, advanced event selectors, or data resources that is not valid. The combination of event selectors or advanced event selectors and data resources is not valid. A trail can have up to 5 event selectors. If a trail uses advanced event selectors, a maximum of 500 total values for all conditions in all advanced event selectors is allowed. A trail is limited to 250 data resources. These data resources can be distributed across event selectors, but the overall total cannot exceed 250.</p>
    /// <p>You can:</p>
    /// <ul>
    /// <li> <p>Specify a valid number of event selectors (1 to 5) for a trail.</p> </li>
    /// <li> <p>Specify a valid number of data resources (1 to 250) for an event selector. The limit of number of resources on an individual event selector is configurable up to 250. However, this upper limit is allowed only if the total number of data resources does not exceed 250 across all event selectors for a trail.</p> </li>
    /// <li> <p>Specify up to 500 values for all conditions in all advanced event selectors for a trail.</p> </li>
    /// <li> <p>Specify a valid value for a parameter. For example, specifying the <code>ReadWriteType</code> parameter with a value of <code>read-only</code> is not valid.</p> </li>
    /// </ul>
    InvalidEventSelectorsException(crate::error::InvalidEventSelectorsException),
    /// <p>This exception is thrown when an operation is called on a trail from a region other than the region in which the trail was created.</p>
    InvalidHomeRegionException(crate::error::InvalidHomeRegionException),
    /// <p>This exception is thrown when the KMS key ARN is not valid.</p>
    InvalidKmsKeyIdException(crate::error::InvalidKmsKeyIdException),
    /// <p>This exception is thrown when the combination of parameters provided is not valid.</p>
    InvalidParameterCombinationException(crate::error::InvalidParameterCombinationException),
    /// <p>This exception is thrown when the provided S3 bucket name is not valid.</p>
    InvalidS3BucketNameException(crate::error::InvalidS3BucketNameException),
    /// <p>This exception is thrown when the provided S3 prefix is not valid.</p>
    InvalidS3PrefixException(crate::error::InvalidS3PrefixException),
    /// <p>This exception is thrown when the provided SNS topic name is not valid.</p>
    InvalidSnsTopicNameException(crate::error::InvalidSnsTopicNameException),
    /// <p>This exception is thrown when the provided trail name is not valid. Trail names must meet the following requirements:</p>
    /// <ul>
    /// <li> <p>Contain only ASCII letters (a-z, A-Z), numbers (0-9), periods (.), underscores (_), or dashes (-)</p> </li>
    /// <li> <p>Start with a letter or number, and end with a letter or number</p> </li>
    /// <li> <p>Be between 3 and 128 characters</p> </li>
    /// <li> <p>Have no adjacent periods, underscores or dashes. Names like <code>my-_namespace</code> and <code>my--namespace</code> are not valid.</p> </li>
    /// <li> <p>Not be in IP address format (for example, 192.168.5.4)</p> </li>
    /// </ul>
    InvalidTrailNameException(crate::error::InvalidTrailNameException),
    /// <p>This exception is thrown when there is an issue with the specified KMS key and the trail can’t be updated.</p>
    KmsException(crate::error::KmsException),
    /// <p>This exception is no longer in use.</p>
    KmsKeyDisabledException(crate::error::KmsKeyDisabledException),
    /// <p>This exception is thrown when the KMS key does not exist, when the S3 bucket and the KMS key are not in the same region, or when the KMS key associated with the Amazon SNS topic either does not exist or is not in the same region.</p>
    KmsKeyNotFoundException(crate::error::KmsKeyNotFoundException),
    /// <p>This exception is thrown when the Amazon Web Services account making the request to create or update an organization trail is not the management account for an organization in Organizations. For more information, see <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/creating-an-organizational-trail-prepare.html">Prepare For Creating a Trail For Your Organization</a>.</p>
    NotOrganizationMasterAccountException(crate::error::NotOrganizationMasterAccountException),
    /// <p>This exception is thrown when the requested operation is not permitted.</p>
    OperationNotPermittedException(crate::error::OperationNotPermittedException),
    /// <p>This exception is thrown when Organizations is not configured to support all features. All features must be enabled in Organizations to support creating an organization trail. For more information, see <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/creating-an-organizational-trail-prepare.html">Prepare For Creating a Trail For Your Organization</a>.</p>
    OrganizationNotInAllFeaturesModeException(
        crate::error::OrganizationNotInAllFeaturesModeException,
    ),
    /// <p>This exception is thrown when the request is made from an Amazon Web Services account that is not a member of an organization. To make this request, sign in using the credentials of an account that belongs to an organization.</p>
    OrganizationsNotInUseException(crate::error::OrganizationsNotInUseException),
    /// <p>This exception is thrown when the specified S3 bucket does not exist.</p>
    S3BucketDoesNotExistException(crate::error::S3BucketDoesNotExistException),
    /// <p>This exception is thrown when the trail with the given name is not found.</p>
    TrailNotFoundException(crate::error::TrailNotFoundException),
    /// <p>This exception is no longer in use.</p>
    TrailNotProvidedException(crate::error::TrailNotProvidedException),
    /// <p>This exception is thrown when the requested operation is not supported.</p>
    UnsupportedOperationException(crate::error::UnsupportedOperationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateTrailError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateTrailErrorKind::CloudTrailAccessNotEnabledException(_inner) => _inner.fmt(f),
            UpdateTrailErrorKind::CloudTrailInvalidClientTokenIdException(_inner) => _inner.fmt(f),
            UpdateTrailErrorKind::CloudWatchLogsDeliveryUnavailableException(_inner) => {
                _inner.fmt(f)
            }
            UpdateTrailErrorKind::InsufficientDependencyServiceAccessPermissionException(
                _inner,
            ) => _inner.fmt(f),
            UpdateTrailErrorKind::InsufficientEncryptionPolicyException(_inner) => _inner.fmt(f),
            UpdateTrailErrorKind::InsufficientS3BucketPolicyException(_inner) => _inner.fmt(f),
            UpdateTrailErrorKind::InsufficientSnsTopicPolicyException(_inner) => _inner.fmt(f),
            UpdateTrailErrorKind::InvalidCloudWatchLogsLogGroupArnException(_inner) => {
                _inner.fmt(f)
            }
            UpdateTrailErrorKind::InvalidCloudWatchLogsRoleArnException(_inner) => _inner.fmt(f),
            UpdateTrailErrorKind::InvalidEventSelectorsException(_inner) => _inner.fmt(f),
            UpdateTrailErrorKind::InvalidHomeRegionException(_inner) => _inner.fmt(f),
            UpdateTrailErrorKind::InvalidKmsKeyIdException(_inner) => _inner.fmt(f),
            UpdateTrailErrorKind::InvalidParameterCombinationException(_inner) => _inner.fmt(f),
            UpdateTrailErrorKind::InvalidS3BucketNameException(_inner) => _inner.fmt(f),
            UpdateTrailErrorKind::InvalidS3PrefixException(_inner) => _inner.fmt(f),
            UpdateTrailErrorKind::InvalidSnsTopicNameException(_inner) => _inner.fmt(f),
            UpdateTrailErrorKind::InvalidTrailNameException(_inner) => _inner.fmt(f),
            UpdateTrailErrorKind::KmsException(_inner) => _inner.fmt(f),
            UpdateTrailErrorKind::KmsKeyDisabledException(_inner) => _inner.fmt(f),
            UpdateTrailErrorKind::KmsKeyNotFoundException(_inner) => _inner.fmt(f),
            UpdateTrailErrorKind::NotOrganizationMasterAccountException(_inner) => _inner.fmt(f),
            UpdateTrailErrorKind::OperationNotPermittedException(_inner) => _inner.fmt(f),
            UpdateTrailErrorKind::OrganizationNotInAllFeaturesModeException(_inner) => {
                _inner.fmt(f)
            }
            UpdateTrailErrorKind::OrganizationsNotInUseException(_inner) => _inner.fmt(f),
            UpdateTrailErrorKind::S3BucketDoesNotExistException(_inner) => _inner.fmt(f),
            UpdateTrailErrorKind::TrailNotFoundException(_inner) => _inner.fmt(f),
            UpdateTrailErrorKind::TrailNotProvidedException(_inner) => _inner.fmt(f),
            UpdateTrailErrorKind::UnsupportedOperationException(_inner) => _inner.fmt(f),
            UpdateTrailErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateTrailError {
    fn code(&self) -> Option<&str> {
        UpdateTrailError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateTrailError {
    /// Creates a new `UpdateTrailError`.
    pub fn new(kind: UpdateTrailErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateTrailError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateTrailErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateTrailError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateTrailErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateTrailErrorKind::CloudTrailAccessNotEnabledException`.
    pub fn is_cloud_trail_access_not_enabled_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateTrailErrorKind::CloudTrailAccessNotEnabledException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateTrailErrorKind::CloudTrailInvalidClientTokenIdException`.
    pub fn is_cloud_trail_invalid_client_token_id_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateTrailErrorKind::CloudTrailInvalidClientTokenIdException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateTrailErrorKind::CloudWatchLogsDeliveryUnavailableException`.
    pub fn is_cloud_watch_logs_delivery_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateTrailErrorKind::CloudWatchLogsDeliveryUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateTrailErrorKind::InsufficientDependencyServiceAccessPermissionException`.
    pub fn is_insufficient_dependency_service_access_permission_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateTrailErrorKind::InsufficientDependencyServiceAccessPermissionException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateTrailErrorKind::InsufficientEncryptionPolicyException`.
    pub fn is_insufficient_encryption_policy_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateTrailErrorKind::InsufficientEncryptionPolicyException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateTrailErrorKind::InsufficientS3BucketPolicyException`.
    pub fn is_insufficient_s3_bucket_policy_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateTrailErrorKind::InsufficientS3BucketPolicyException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateTrailErrorKind::InsufficientSnsTopicPolicyException`.
    pub fn is_insufficient_sns_topic_policy_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateTrailErrorKind::InsufficientSnsTopicPolicyException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateTrailErrorKind::InvalidCloudWatchLogsLogGroupArnException`.
    pub fn is_invalid_cloud_watch_logs_log_group_arn_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateTrailErrorKind::InvalidCloudWatchLogsLogGroupArnException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateTrailErrorKind::InvalidCloudWatchLogsRoleArnException`.
    pub fn is_invalid_cloud_watch_logs_role_arn_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateTrailErrorKind::InvalidCloudWatchLogsRoleArnException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateTrailErrorKind::InvalidEventSelectorsException`.
    pub fn is_invalid_event_selectors_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateTrailErrorKind::InvalidEventSelectorsException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateTrailErrorKind::InvalidHomeRegionException`.
    pub fn is_invalid_home_region_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateTrailErrorKind::InvalidHomeRegionException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateTrailErrorKind::InvalidKmsKeyIdException`.
    pub fn is_invalid_kms_key_id_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateTrailErrorKind::InvalidKmsKeyIdException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateTrailErrorKind::InvalidParameterCombinationException`.
    pub fn is_invalid_parameter_combination_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateTrailErrorKind::InvalidParameterCombinationException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateTrailErrorKind::InvalidS3BucketNameException`.
    pub fn is_invalid_s3_bucket_name_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateTrailErrorKind::InvalidS3BucketNameException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateTrailErrorKind::InvalidS3PrefixException`.
    pub fn is_invalid_s3_prefix_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateTrailErrorKind::InvalidS3PrefixException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateTrailErrorKind::InvalidSnsTopicNameException`.
    pub fn is_invalid_sns_topic_name_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateTrailErrorKind::InvalidSnsTopicNameException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateTrailErrorKind::InvalidTrailNameException`.
    pub fn is_invalid_trail_name_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateTrailErrorKind::InvalidTrailNameException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateTrailErrorKind::KmsException`.
    pub fn is_kms_exception(&self) -> bool {
        matches!(&self.kind, UpdateTrailErrorKind::KmsException(_))
    }
    /// Returns `true` if the error kind is `UpdateTrailErrorKind::KmsKeyDisabledException`.
    pub fn is_kms_key_disabled_exception(&self) -> bool {
        matches!(&self.kind, UpdateTrailErrorKind::KmsKeyDisabledException(_))
    }
    /// Returns `true` if the error kind is `UpdateTrailErrorKind::KmsKeyNotFoundException`.
    pub fn is_kms_key_not_found_exception(&self) -> bool {
        matches!(&self.kind, UpdateTrailErrorKind::KmsKeyNotFoundException(_))
    }
    /// Returns `true` if the error kind is `UpdateTrailErrorKind::NotOrganizationMasterAccountException`.
    pub fn is_not_organization_master_account_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateTrailErrorKind::NotOrganizationMasterAccountException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateTrailErrorKind::OperationNotPermittedException`.
    pub fn is_operation_not_permitted_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateTrailErrorKind::OperationNotPermittedException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateTrailErrorKind::OrganizationNotInAllFeaturesModeException`.
    pub fn is_organization_not_in_all_features_mode_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateTrailErrorKind::OrganizationNotInAllFeaturesModeException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateTrailErrorKind::OrganizationsNotInUseException`.
    pub fn is_organizations_not_in_use_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateTrailErrorKind::OrganizationsNotInUseException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateTrailErrorKind::S3BucketDoesNotExistException`.
    pub fn is_s3_bucket_does_not_exist_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateTrailErrorKind::S3BucketDoesNotExistException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateTrailErrorKind::TrailNotFoundException`.
    pub fn is_trail_not_found_exception(&self) -> bool {
        matches!(&self.kind, UpdateTrailErrorKind::TrailNotFoundException(_))
    }
    /// Returns `true` if the error kind is `UpdateTrailErrorKind::TrailNotProvidedException`.
    pub fn is_trail_not_provided_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateTrailErrorKind::TrailNotProvidedException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateTrailErrorKind::UnsupportedOperationException`.
    pub fn is_unsupported_operation_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateTrailErrorKind::UnsupportedOperationException(_)
        )
    }
}
impl std::error::Error for UpdateTrailError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateTrailErrorKind::CloudTrailAccessNotEnabledException(_inner) => Some(_inner),
            UpdateTrailErrorKind::CloudTrailInvalidClientTokenIdException(_inner) => Some(_inner),
            UpdateTrailErrorKind::CloudWatchLogsDeliveryUnavailableException(_inner) => {
                Some(_inner)
            }
            UpdateTrailErrorKind::InsufficientDependencyServiceAccessPermissionException(
                _inner,
            ) => Some(_inner),
            UpdateTrailErrorKind::InsufficientEncryptionPolicyException(_inner) => Some(_inner),
            UpdateTrailErrorKind::InsufficientS3BucketPolicyException(_inner) => Some(_inner),
            UpdateTrailErrorKind::InsufficientSnsTopicPolicyException(_inner) => Some(_inner),
            UpdateTrailErrorKind::InvalidCloudWatchLogsLogGroupArnException(_inner) => Some(_inner),
            UpdateTrailErrorKind::InvalidCloudWatchLogsRoleArnException(_inner) => Some(_inner),
            UpdateTrailErrorKind::InvalidEventSelectorsException(_inner) => Some(_inner),
            UpdateTrailErrorKind::InvalidHomeRegionException(_inner) => Some(_inner),
            UpdateTrailErrorKind::InvalidKmsKeyIdException(_inner) => Some(_inner),
            UpdateTrailErrorKind::InvalidParameterCombinationException(_inner) => Some(_inner),
            UpdateTrailErrorKind::InvalidS3BucketNameException(_inner) => Some(_inner),
            UpdateTrailErrorKind::InvalidS3PrefixException(_inner) => Some(_inner),
            UpdateTrailErrorKind::InvalidSnsTopicNameException(_inner) => Some(_inner),
            UpdateTrailErrorKind::InvalidTrailNameException(_inner) => Some(_inner),
            UpdateTrailErrorKind::KmsException(_inner) => Some(_inner),
            UpdateTrailErrorKind::KmsKeyDisabledException(_inner) => Some(_inner),
            UpdateTrailErrorKind::KmsKeyNotFoundException(_inner) => Some(_inner),
            UpdateTrailErrorKind::NotOrganizationMasterAccountException(_inner) => Some(_inner),
            UpdateTrailErrorKind::OperationNotPermittedException(_inner) => Some(_inner),
            UpdateTrailErrorKind::OrganizationNotInAllFeaturesModeException(_inner) => Some(_inner),
            UpdateTrailErrorKind::OrganizationsNotInUseException(_inner) => Some(_inner),
            UpdateTrailErrorKind::S3BucketDoesNotExistException(_inner) => Some(_inner),
            UpdateTrailErrorKind::TrailNotFoundException(_inner) => Some(_inner),
            UpdateTrailErrorKind::TrailNotProvidedException(_inner) => Some(_inner),
            UpdateTrailErrorKind::UnsupportedOperationException(_inner) => Some(_inner),
            UpdateTrailErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// <p>This exception is thrown when the requested operation is not supported.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UnsupportedOperationException {
    /// <p>Brief description of the exception returned by the request.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for UnsupportedOperationException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UnsupportedOperationException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl UnsupportedOperationException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for UnsupportedOperationException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "UnsupportedOperationException")?;
        if let Some(inner_1) = &self.message {
            write!(f, ": {}", inner_1)?;
        }
        Ok(())
    }
}
impl std::error::Error for UnsupportedOperationException {}
/// See [`UnsupportedOperationException`](crate::error::UnsupportedOperationException)
pub mod unsupported_operation_exception {
    /// A builder for [`UnsupportedOperationException`](crate::error::UnsupportedOperationException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Brief description of the exception returned by the request.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>Brief description of the exception returned by the request.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`UnsupportedOperationException`](crate::error::UnsupportedOperationException)
        pub fn build(self) -> crate::error::UnsupportedOperationException {
            crate::error::UnsupportedOperationException {
                message: self.message,
            }
        }
    }
}
impl UnsupportedOperationException {
    /// Creates a new builder-style object to manufacture [`UnsupportedOperationException`](crate::error::UnsupportedOperationException)
    pub fn builder() -> crate::error::unsupported_operation_exception::Builder {
        crate::error::unsupported_operation_exception::Builder::default()
    }
}

/// <p>This exception is no longer in use.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TrailNotProvidedException {
    /// <p>Brief description of the exception returned by the request.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for TrailNotProvidedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TrailNotProvidedException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl TrailNotProvidedException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for TrailNotProvidedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "TrailNotProvidedException")?;
        if let Some(inner_2) = &self.message {
            write!(f, ": {}", inner_2)?;
        }
        Ok(())
    }
}
impl std::error::Error for TrailNotProvidedException {}
/// See [`TrailNotProvidedException`](crate::error::TrailNotProvidedException)
pub mod trail_not_provided_exception {
    /// A builder for [`TrailNotProvidedException`](crate::error::TrailNotProvidedException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Brief description of the exception returned by the request.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>Brief description of the exception returned by the request.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`TrailNotProvidedException`](crate::error::TrailNotProvidedException)
        pub fn build(self) -> crate::error::TrailNotProvidedException {
            crate::error::TrailNotProvidedException {
                message: self.message,
            }
        }
    }
}
impl TrailNotProvidedException {
    /// Creates a new builder-style object to manufacture [`TrailNotProvidedException`](crate::error::TrailNotProvidedException)
    pub fn builder() -> crate::error::trail_not_provided_exception::Builder {
        crate::error::trail_not_provided_exception::Builder::default()
    }
}

/// <p>This exception is thrown when the trail with the given name is not found.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TrailNotFoundException {
    /// <p>Brief description of the exception returned by the request.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for TrailNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TrailNotFoundException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl TrailNotFoundException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for TrailNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "TrailNotFoundException")?;
        if let Some(inner_3) = &self.message {
            write!(f, ": {}", inner_3)?;
        }
        Ok(())
    }
}
impl std::error::Error for TrailNotFoundException {}
/// See [`TrailNotFoundException`](crate::error::TrailNotFoundException)
pub mod trail_not_found_exception {
    /// A builder for [`TrailNotFoundException`](crate::error::TrailNotFoundException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Brief description of the exception returned by the request.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>Brief description of the exception returned by the request.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`TrailNotFoundException`](crate::error::TrailNotFoundException)
        pub fn build(self) -> crate::error::TrailNotFoundException {
            crate::error::TrailNotFoundException {
                message: self.message,
            }
        }
    }
}
impl TrailNotFoundException {
    /// Creates a new builder-style object to manufacture [`TrailNotFoundException`](crate::error::TrailNotFoundException)
    pub fn builder() -> crate::error::trail_not_found_exception::Builder {
        crate::error::trail_not_found_exception::Builder::default()
    }
}

/// <p>This exception is thrown when the specified S3 bucket does not exist.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct S3BucketDoesNotExistException {
    /// <p>Brief description of the exception returned by the request.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for S3BucketDoesNotExistException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("S3BucketDoesNotExistException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl S3BucketDoesNotExistException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for S3BucketDoesNotExistException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "S3BucketDoesNotExistException")?;
        if let Some(inner_4) = &self.message {
            write!(f, ": {}", inner_4)?;
        }
        Ok(())
    }
}
impl std::error::Error for S3BucketDoesNotExistException {}
/// See [`S3BucketDoesNotExistException`](crate::error::S3BucketDoesNotExistException)
pub mod s3_bucket_does_not_exist_exception {
    /// A builder for [`S3BucketDoesNotExistException`](crate::error::S3BucketDoesNotExistException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Brief description of the exception returned by the request.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>Brief description of the exception returned by the request.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`S3BucketDoesNotExistException`](crate::error::S3BucketDoesNotExistException)
        pub fn build(self) -> crate::error::S3BucketDoesNotExistException {
            crate::error::S3BucketDoesNotExistException {
                message: self.message,
            }
        }
    }
}
impl S3BucketDoesNotExistException {
    /// Creates a new builder-style object to manufacture [`S3BucketDoesNotExistException`](crate::error::S3BucketDoesNotExistException)
    pub fn builder() -> crate::error::s3_bucket_does_not_exist_exception::Builder {
        crate::error::s3_bucket_does_not_exist_exception::Builder::default()
    }
}

/// <p>This exception is thrown when the request is made from an Amazon Web Services account that is not a member of an organization. To make this request, sign in using the credentials of an account that belongs to an organization.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct OrganizationsNotInUseException {
    /// <p>Brief description of the exception returned by the request.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for OrganizationsNotInUseException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("OrganizationsNotInUseException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl OrganizationsNotInUseException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for OrganizationsNotInUseException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "OrganizationsNotInUseException")?;
        if let Some(inner_5) = &self.message {
            write!(f, ": {}", inner_5)?;
        }
        Ok(())
    }
}
impl std::error::Error for OrganizationsNotInUseException {}
/// See [`OrganizationsNotInUseException`](crate::error::OrganizationsNotInUseException)
pub mod organizations_not_in_use_exception {
    /// A builder for [`OrganizationsNotInUseException`](crate::error::OrganizationsNotInUseException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Brief description of the exception returned by the request.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>Brief description of the exception returned by the request.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`OrganizationsNotInUseException`](crate::error::OrganizationsNotInUseException)
        pub fn build(self) -> crate::error::OrganizationsNotInUseException {
            crate::error::OrganizationsNotInUseException {
                message: self.message,
            }
        }
    }
}
impl OrganizationsNotInUseException {
    /// Creates a new builder-style object to manufacture [`OrganizationsNotInUseException`](crate::error::OrganizationsNotInUseException)
    pub fn builder() -> crate::error::organizations_not_in_use_exception::Builder {
        crate::error::organizations_not_in_use_exception::Builder::default()
    }
}

/// <p>This exception is thrown when Organizations is not configured to support all features. All features must be enabled in Organizations to support creating an organization trail. For more information, see <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/creating-an-organizational-trail-prepare.html">Prepare For Creating a Trail For Your Organization</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct OrganizationNotInAllFeaturesModeException {
    /// <p>Brief description of the exception returned by the request.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for OrganizationNotInAllFeaturesModeException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("OrganizationNotInAllFeaturesModeException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl OrganizationNotInAllFeaturesModeException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for OrganizationNotInAllFeaturesModeException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "OrganizationNotInAllFeaturesModeException")?;
        if let Some(inner_6) = &self.message {
            write!(f, ": {}", inner_6)?;
        }
        Ok(())
    }
}
impl std::error::Error for OrganizationNotInAllFeaturesModeException {}
/// See [`OrganizationNotInAllFeaturesModeException`](crate::error::OrganizationNotInAllFeaturesModeException)
pub mod organization_not_in_all_features_mode_exception {
    /// A builder for [`OrganizationNotInAllFeaturesModeException`](crate::error::OrganizationNotInAllFeaturesModeException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Brief description of the exception returned by the request.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>Brief description of the exception returned by the request.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`OrganizationNotInAllFeaturesModeException`](crate::error::OrganizationNotInAllFeaturesModeException)
        pub fn build(self) -> crate::error::OrganizationNotInAllFeaturesModeException {
            crate::error::OrganizationNotInAllFeaturesModeException {
                message: self.message,
            }
        }
    }
}
impl OrganizationNotInAllFeaturesModeException {
    /// Creates a new builder-style object to manufacture [`OrganizationNotInAllFeaturesModeException`](crate::error::OrganizationNotInAllFeaturesModeException)
    pub fn builder() -> crate::error::organization_not_in_all_features_mode_exception::Builder {
        crate::error::organization_not_in_all_features_mode_exception::Builder::default()
    }
}

/// <p>This exception is thrown when the requested operation is not permitted.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct OperationNotPermittedException {
    /// <p>Brief description of the exception returned by the request.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for OperationNotPermittedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("OperationNotPermittedException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl OperationNotPermittedException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for OperationNotPermittedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "OperationNotPermittedException")?;
        if let Some(inner_7) = &self.message {
            write!(f, ": {}", inner_7)?;
        }
        Ok(())
    }
}
impl std::error::Error for OperationNotPermittedException {}
/// See [`OperationNotPermittedException`](crate::error::OperationNotPermittedException)
pub mod operation_not_permitted_exception {
    /// A builder for [`OperationNotPermittedException`](crate::error::OperationNotPermittedException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Brief description of the exception returned by the request.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>Brief description of the exception returned by the request.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`OperationNotPermittedException`](crate::error::OperationNotPermittedException)
        pub fn build(self) -> crate::error::OperationNotPermittedException {
            crate::error::OperationNotPermittedException {
                message: self.message,
            }
        }
    }
}
impl OperationNotPermittedException {
    /// Creates a new builder-style object to manufacture [`OperationNotPermittedException`](crate::error::OperationNotPermittedException)
    pub fn builder() -> crate::error::operation_not_permitted_exception::Builder {
        crate::error::operation_not_permitted_exception::Builder::default()
    }
}

/// <p>This exception is thrown when the Amazon Web Services account making the request to create or update an organization trail is not the management account for an organization in Organizations. For more information, see <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/creating-an-organizational-trail-prepare.html">Prepare For Creating a Trail For Your Organization</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct NotOrganizationMasterAccountException {
    /// <p>Brief description of the exception returned by the request.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for NotOrganizationMasterAccountException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("NotOrganizationMasterAccountException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl NotOrganizationMasterAccountException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for NotOrganizationMasterAccountException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "NotOrganizationMasterAccountException")?;
        if let Some(inner_8) = &self.message {
            write!(f, ": {}", inner_8)?;
        }
        Ok(())
    }
}
impl std::error::Error for NotOrganizationMasterAccountException {}
/// See [`NotOrganizationMasterAccountException`](crate::error::NotOrganizationMasterAccountException)
pub mod not_organization_master_account_exception {
    /// A builder for [`NotOrganizationMasterAccountException`](crate::error::NotOrganizationMasterAccountException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Brief description of the exception returned by the request.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>Brief description of the exception returned by the request.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`NotOrganizationMasterAccountException`](crate::error::NotOrganizationMasterAccountException)
        pub fn build(self) -> crate::error::NotOrganizationMasterAccountException {
            crate::error::NotOrganizationMasterAccountException {
                message: self.message,
            }
        }
    }
}
impl NotOrganizationMasterAccountException {
    /// Creates a new builder-style object to manufacture [`NotOrganizationMasterAccountException`](crate::error::NotOrganizationMasterAccountException)
    pub fn builder() -> crate::error::not_organization_master_account_exception::Builder {
        crate::error::not_organization_master_account_exception::Builder::default()
    }
}

/// <p>This exception is thrown when the KMS key does not exist, when the S3 bucket and the KMS key are not in the same region, or when the KMS key associated with the Amazon SNS topic either does not exist or is not in the same region.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct KmsKeyNotFoundException {
    /// <p>Brief description of the exception returned by the request.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for KmsKeyNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("KmsKeyNotFoundException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl KmsKeyNotFoundException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for KmsKeyNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "KmsKeyNotFoundException")?;
        if let Some(inner_9) = &self.message {
            write!(f, ": {}", inner_9)?;
        }
        Ok(())
    }
}
impl std::error::Error for KmsKeyNotFoundException {}
/// See [`KmsKeyNotFoundException`](crate::error::KmsKeyNotFoundException)
pub mod kms_key_not_found_exception {
    /// A builder for [`KmsKeyNotFoundException`](crate::error::KmsKeyNotFoundException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Brief description of the exception returned by the request.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>Brief description of the exception returned by the request.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`KmsKeyNotFoundException`](crate::error::KmsKeyNotFoundException)
        pub fn build(self) -> crate::error::KmsKeyNotFoundException {
            crate::error::KmsKeyNotFoundException {
                message: self.message,
            }
        }
    }
}
impl KmsKeyNotFoundException {
    /// Creates a new builder-style object to manufacture [`KmsKeyNotFoundException`](crate::error::KmsKeyNotFoundException)
    pub fn builder() -> crate::error::kms_key_not_found_exception::Builder {
        crate::error::kms_key_not_found_exception::Builder::default()
    }
}

/// <p>This exception is no longer in use.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct KmsKeyDisabledException {
    /// <p>Brief description of the exception returned by the request.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for KmsKeyDisabledException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("KmsKeyDisabledException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl KmsKeyDisabledException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for KmsKeyDisabledException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "KmsKeyDisabledException")?;
        if let Some(inner_10) = &self.message {
            write!(f, ": {}", inner_10)?;
        }
        Ok(())
    }
}
impl std::error::Error for KmsKeyDisabledException {}
/// See [`KmsKeyDisabledException`](crate::error::KmsKeyDisabledException)
pub mod kms_key_disabled_exception {
    /// A builder for [`KmsKeyDisabledException`](crate::error::KmsKeyDisabledException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Brief description of the exception returned by the request.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>Brief description of the exception returned by the request.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`KmsKeyDisabledException`](crate::error::KmsKeyDisabledException)
        pub fn build(self) -> crate::error::KmsKeyDisabledException {
            crate::error::KmsKeyDisabledException {
                message: self.message,
            }
        }
    }
}
impl KmsKeyDisabledException {
    /// Creates a new builder-style object to manufacture [`KmsKeyDisabledException`](crate::error::KmsKeyDisabledException)
    pub fn builder() -> crate::error::kms_key_disabled_exception::Builder {
        crate::error::kms_key_disabled_exception::Builder::default()
    }
}

/// <p>This exception is thrown when there is an issue with the specified KMS key and the trail can’t be updated.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct KmsException {
    /// <p>Brief description of the exception returned by the request.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for KmsException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("KmsException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl KmsException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for KmsException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "KmsException")?;
        if let Some(inner_11) = &self.message {
            write!(f, ": {}", inner_11)?;
        }
        Ok(())
    }
}
impl std::error::Error for KmsException {}
/// See [`KmsException`](crate::error::KmsException)
pub mod kms_exception {
    /// A builder for [`KmsException`](crate::error::KmsException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Brief description of the exception returned by the request.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>Brief description of the exception returned by the request.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`KmsException`](crate::error::KmsException)
        pub fn build(self) -> crate::error::KmsException {
            crate::error::KmsException {
                message: self.message,
            }
        }
    }
}
impl KmsException {
    /// Creates a new builder-style object to manufacture [`KmsException`](crate::error::KmsException)
    pub fn builder() -> crate::error::kms_exception::Builder {
        crate::error::kms_exception::Builder::default()
    }
}

/// <p>This exception is thrown when the provided trail name is not valid. Trail names must meet the following requirements:</p>
/// <ul>
/// <li> <p>Contain only ASCII letters (a-z, A-Z), numbers (0-9), periods (.), underscores (_), or dashes (-)</p> </li>
/// <li> <p>Start with a letter or number, and end with a letter or number</p> </li>
/// <li> <p>Be between 3 and 128 characters</p> </li>
/// <li> <p>Have no adjacent periods, underscores or dashes. Names like <code>my-_namespace</code> and <code>my--namespace</code> are not valid.</p> </li>
/// <li> <p>Not be in IP address format (for example, 192.168.5.4)</p> </li>
/// </ul>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidTrailNameException {
    /// <p>Brief description of the exception returned by the request.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidTrailNameException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidTrailNameException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidTrailNameException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidTrailNameException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidTrailNameException")?;
        if let Some(inner_12) = &self.message {
            write!(f, ": {}", inner_12)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidTrailNameException {}
/// See [`InvalidTrailNameException`](crate::error::InvalidTrailNameException)
pub mod invalid_trail_name_exception {
    /// A builder for [`InvalidTrailNameException`](crate::error::InvalidTrailNameException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Brief description of the exception returned by the request.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>Brief description of the exception returned by the request.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidTrailNameException`](crate::error::InvalidTrailNameException)
        pub fn build(self) -> crate::error::InvalidTrailNameException {
            crate::error::InvalidTrailNameException {
                message: self.message,
            }
        }
    }
}
impl InvalidTrailNameException {
    /// Creates a new builder-style object to manufacture [`InvalidTrailNameException`](crate::error::InvalidTrailNameException)
    pub fn builder() -> crate::error::invalid_trail_name_exception::Builder {
        crate::error::invalid_trail_name_exception::Builder::default()
    }
}

/// <p>This exception is thrown when the provided SNS topic name is not valid.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidSnsTopicNameException {
    /// <p>Brief description of the exception returned by the request.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidSnsTopicNameException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidSnsTopicNameException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidSnsTopicNameException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidSnsTopicNameException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidSnsTopicNameException")?;
        if let Some(inner_13) = &self.message {
            write!(f, ": {}", inner_13)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidSnsTopicNameException {}
/// See [`InvalidSnsTopicNameException`](crate::error::InvalidSnsTopicNameException)
pub mod invalid_sns_topic_name_exception {
    /// A builder for [`InvalidSnsTopicNameException`](crate::error::InvalidSnsTopicNameException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Brief description of the exception returned by the request.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>Brief description of the exception returned by the request.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidSnsTopicNameException`](crate::error::InvalidSnsTopicNameException)
        pub fn build(self) -> crate::error::InvalidSnsTopicNameException {
            crate::error::InvalidSnsTopicNameException {
                message: self.message,
            }
        }
    }
}
impl InvalidSnsTopicNameException {
    /// Creates a new builder-style object to manufacture [`InvalidSnsTopicNameException`](crate::error::InvalidSnsTopicNameException)
    pub fn builder() -> crate::error::invalid_sns_topic_name_exception::Builder {
        crate::error::invalid_sns_topic_name_exception::Builder::default()
    }
}

/// <p>This exception is thrown when the provided S3 prefix is not valid.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidS3PrefixException {
    /// <p>Brief description of the exception returned by the request.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidS3PrefixException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidS3PrefixException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidS3PrefixException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidS3PrefixException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidS3PrefixException")?;
        if let Some(inner_14) = &self.message {
            write!(f, ": {}", inner_14)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidS3PrefixException {}
/// See [`InvalidS3PrefixException`](crate::error::InvalidS3PrefixException)
pub mod invalid_s3_prefix_exception {
    /// A builder for [`InvalidS3PrefixException`](crate::error::InvalidS3PrefixException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Brief description of the exception returned by the request.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>Brief description of the exception returned by the request.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidS3PrefixException`](crate::error::InvalidS3PrefixException)
        pub fn build(self) -> crate::error::InvalidS3PrefixException {
            crate::error::InvalidS3PrefixException {
                message: self.message,
            }
        }
    }
}
impl InvalidS3PrefixException {
    /// Creates a new builder-style object to manufacture [`InvalidS3PrefixException`](crate::error::InvalidS3PrefixException)
    pub fn builder() -> crate::error::invalid_s3_prefix_exception::Builder {
        crate::error::invalid_s3_prefix_exception::Builder::default()
    }
}

/// <p>This exception is thrown when the provided S3 bucket name is not valid.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidS3BucketNameException {
    /// <p>Brief description of the exception returned by the request.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidS3BucketNameException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidS3BucketNameException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidS3BucketNameException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidS3BucketNameException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidS3BucketNameException")?;
        if let Some(inner_15) = &self.message {
            write!(f, ": {}", inner_15)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidS3BucketNameException {}
/// See [`InvalidS3BucketNameException`](crate::error::InvalidS3BucketNameException)
pub mod invalid_s3_bucket_name_exception {
    /// A builder for [`InvalidS3BucketNameException`](crate::error::InvalidS3BucketNameException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Brief description of the exception returned by the request.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>Brief description of the exception returned by the request.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidS3BucketNameException`](crate::error::InvalidS3BucketNameException)
        pub fn build(self) -> crate::error::InvalidS3BucketNameException {
            crate::error::InvalidS3BucketNameException {
                message: self.message,
            }
        }
    }
}
impl InvalidS3BucketNameException {
    /// Creates a new builder-style object to manufacture [`InvalidS3BucketNameException`](crate::error::InvalidS3BucketNameException)
    pub fn builder() -> crate::error::invalid_s3_bucket_name_exception::Builder {
        crate::error::invalid_s3_bucket_name_exception::Builder::default()
    }
}

/// <p>This exception is thrown when the combination of parameters provided is not valid.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidParameterCombinationException {
    /// <p>Brief description of the exception returned by the request.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidParameterCombinationException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidParameterCombinationException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidParameterCombinationException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidParameterCombinationException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidParameterCombinationException")?;
        if let Some(inner_16) = &self.message {
            write!(f, ": {}", inner_16)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidParameterCombinationException {}
/// See [`InvalidParameterCombinationException`](crate::error::InvalidParameterCombinationException)
pub mod invalid_parameter_combination_exception {
    /// A builder for [`InvalidParameterCombinationException`](crate::error::InvalidParameterCombinationException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Brief description of the exception returned by the request.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>Brief description of the exception returned by the request.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidParameterCombinationException`](crate::error::InvalidParameterCombinationException)
        pub fn build(self) -> crate::error::InvalidParameterCombinationException {
            crate::error::InvalidParameterCombinationException {
                message: self.message,
            }
        }
    }
}
impl InvalidParameterCombinationException {
    /// Creates a new builder-style object to manufacture [`InvalidParameterCombinationException`](crate::error::InvalidParameterCombinationException)
    pub fn builder() -> crate::error::invalid_parameter_combination_exception::Builder {
        crate::error::invalid_parameter_combination_exception::Builder::default()
    }
}

/// <p>This exception is thrown when the KMS key ARN is not valid.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidKmsKeyIdException {
    /// <p>Brief description of the exception returned by the request.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidKmsKeyIdException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidKmsKeyIdException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidKmsKeyIdException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidKmsKeyIdException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidKmsKeyIdException")?;
        if let Some(inner_17) = &self.message {
            write!(f, ": {}", inner_17)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidKmsKeyIdException {}
/// See [`InvalidKmsKeyIdException`](crate::error::InvalidKmsKeyIdException)
pub mod invalid_kms_key_id_exception {
    /// A builder for [`InvalidKmsKeyIdException`](crate::error::InvalidKmsKeyIdException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Brief description of the exception returned by the request.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>Brief description of the exception returned by the request.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidKmsKeyIdException`](crate::error::InvalidKmsKeyIdException)
        pub fn build(self) -> crate::error::InvalidKmsKeyIdException {
            crate::error::InvalidKmsKeyIdException {
                message: self.message,
            }
        }
    }
}
impl InvalidKmsKeyIdException {
    /// Creates a new builder-style object to manufacture [`InvalidKmsKeyIdException`](crate::error::InvalidKmsKeyIdException)
    pub fn builder() -> crate::error::invalid_kms_key_id_exception::Builder {
        crate::error::invalid_kms_key_id_exception::Builder::default()
    }
}

/// <p>This exception is thrown when an operation is called on a trail from a region other than the region in which the trail was created.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidHomeRegionException {
    /// <p>Brief description of the exception returned by the request.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidHomeRegionException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidHomeRegionException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidHomeRegionException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidHomeRegionException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidHomeRegionException")?;
        if let Some(inner_18) = &self.message {
            write!(f, ": {}", inner_18)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidHomeRegionException {}
/// See [`InvalidHomeRegionException`](crate::error::InvalidHomeRegionException)
pub mod invalid_home_region_exception {
    /// A builder for [`InvalidHomeRegionException`](crate::error::InvalidHomeRegionException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Brief description of the exception returned by the request.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>Brief description of the exception returned by the request.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidHomeRegionException`](crate::error::InvalidHomeRegionException)
        pub fn build(self) -> crate::error::InvalidHomeRegionException {
            crate::error::InvalidHomeRegionException {
                message: self.message,
            }
        }
    }
}
impl InvalidHomeRegionException {
    /// Creates a new builder-style object to manufacture [`InvalidHomeRegionException`](crate::error::InvalidHomeRegionException)
    pub fn builder() -> crate::error::invalid_home_region_exception::Builder {
        crate::error::invalid_home_region_exception::Builder::default()
    }
}

/// <p>This exception is thrown when the <code>PutEventSelectors</code> operation is called with a number of event selectors, advanced event selectors, or data resources that is not valid. The combination of event selectors or advanced event selectors and data resources is not valid. A trail can have up to 5 event selectors. If a trail uses advanced event selectors, a maximum of 500 total values for all conditions in all advanced event selectors is allowed. A trail is limited to 250 data resources. These data resources can be distributed across event selectors, but the overall total cannot exceed 250.</p>
/// <p>You can:</p>
/// <ul>
/// <li> <p>Specify a valid number of event selectors (1 to 5) for a trail.</p> </li>
/// <li> <p>Specify a valid number of data resources (1 to 250) for an event selector. The limit of number of resources on an individual event selector is configurable up to 250. However, this upper limit is allowed only if the total number of data resources does not exceed 250 across all event selectors for a trail.</p> </li>
/// <li> <p>Specify up to 500 values for all conditions in all advanced event selectors for a trail.</p> </li>
/// <li> <p>Specify a valid value for a parameter. For example, specifying the <code>ReadWriteType</code> parameter with a value of <code>read-only</code> is not valid.</p> </li>
/// </ul>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidEventSelectorsException {
    /// <p>Brief description of the exception returned by the request.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidEventSelectorsException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidEventSelectorsException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidEventSelectorsException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidEventSelectorsException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidEventSelectorsException")?;
        if let Some(inner_19) = &self.message {
            write!(f, ": {}", inner_19)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidEventSelectorsException {}
/// See [`InvalidEventSelectorsException`](crate::error::InvalidEventSelectorsException)
pub mod invalid_event_selectors_exception {
    /// A builder for [`InvalidEventSelectorsException`](crate::error::InvalidEventSelectorsException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Brief description of the exception returned by the request.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>Brief description of the exception returned by the request.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidEventSelectorsException`](crate::error::InvalidEventSelectorsException)
        pub fn build(self) -> crate::error::InvalidEventSelectorsException {
            crate::error::InvalidEventSelectorsException {
                message: self.message,
            }
        }
    }
}
impl InvalidEventSelectorsException {
    /// Creates a new builder-style object to manufacture [`InvalidEventSelectorsException`](crate::error::InvalidEventSelectorsException)
    pub fn builder() -> crate::error::invalid_event_selectors_exception::Builder {
        crate::error::invalid_event_selectors_exception::Builder::default()
    }
}

/// <p>This exception is thrown when the provided role is not valid.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidCloudWatchLogsRoleArnException {
    /// <p>Brief description of the exception returned by the request.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidCloudWatchLogsRoleArnException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidCloudWatchLogsRoleArnException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidCloudWatchLogsRoleArnException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidCloudWatchLogsRoleArnException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidCloudWatchLogsRoleArnException")?;
        if let Some(inner_20) = &self.message {
            write!(f, ": {}", inner_20)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidCloudWatchLogsRoleArnException {}
/// See [`InvalidCloudWatchLogsRoleArnException`](crate::error::InvalidCloudWatchLogsRoleArnException)
pub mod invalid_cloud_watch_logs_role_arn_exception {
    /// A builder for [`InvalidCloudWatchLogsRoleArnException`](crate::error::InvalidCloudWatchLogsRoleArnException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Brief description of the exception returned by the request.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>Brief description of the exception returned by the request.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidCloudWatchLogsRoleArnException`](crate::error::InvalidCloudWatchLogsRoleArnException)
        pub fn build(self) -> crate::error::InvalidCloudWatchLogsRoleArnException {
            crate::error::InvalidCloudWatchLogsRoleArnException {
                message: self.message,
            }
        }
    }
}
impl InvalidCloudWatchLogsRoleArnException {
    /// Creates a new builder-style object to manufacture [`InvalidCloudWatchLogsRoleArnException`](crate::error::InvalidCloudWatchLogsRoleArnException)
    pub fn builder() -> crate::error::invalid_cloud_watch_logs_role_arn_exception::Builder {
        crate::error::invalid_cloud_watch_logs_role_arn_exception::Builder::default()
    }
}

/// <p>This exception is thrown when the provided CloudWatch Logs log group is not valid.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidCloudWatchLogsLogGroupArnException {
    /// <p>Brief description of the exception returned by the request.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidCloudWatchLogsLogGroupArnException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidCloudWatchLogsLogGroupArnException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidCloudWatchLogsLogGroupArnException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidCloudWatchLogsLogGroupArnException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidCloudWatchLogsLogGroupArnException")?;
        if let Some(inner_21) = &self.message {
            write!(f, ": {}", inner_21)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidCloudWatchLogsLogGroupArnException {}
/// See [`InvalidCloudWatchLogsLogGroupArnException`](crate::error::InvalidCloudWatchLogsLogGroupArnException)
pub mod invalid_cloud_watch_logs_log_group_arn_exception {
    /// A builder for [`InvalidCloudWatchLogsLogGroupArnException`](crate::error::InvalidCloudWatchLogsLogGroupArnException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Brief description of the exception returned by the request.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>Brief description of the exception returned by the request.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidCloudWatchLogsLogGroupArnException`](crate::error::InvalidCloudWatchLogsLogGroupArnException)
        pub fn build(self) -> crate::error::InvalidCloudWatchLogsLogGroupArnException {
            crate::error::InvalidCloudWatchLogsLogGroupArnException {
                message: self.message,
            }
        }
    }
}
impl InvalidCloudWatchLogsLogGroupArnException {
    /// Creates a new builder-style object to manufacture [`InvalidCloudWatchLogsLogGroupArnException`](crate::error::InvalidCloudWatchLogsLogGroupArnException)
    pub fn builder() -> crate::error::invalid_cloud_watch_logs_log_group_arn_exception::Builder {
        crate::error::invalid_cloud_watch_logs_log_group_arn_exception::Builder::default()
    }
}

/// <p>This exception is thrown when the policy on the Amazon SNS topic is not sufficient.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InsufficientSnsTopicPolicyException {
    /// <p>Brief description of the exception returned by the request.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InsufficientSnsTopicPolicyException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InsufficientSnsTopicPolicyException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InsufficientSnsTopicPolicyException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InsufficientSnsTopicPolicyException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InsufficientSnsTopicPolicyException")?;
        if let Some(inner_22) = &self.message {
            write!(f, ": {}", inner_22)?;
        }
        Ok(())
    }
}
impl std::error::Error for InsufficientSnsTopicPolicyException {}
/// See [`InsufficientSnsTopicPolicyException`](crate::error::InsufficientSnsTopicPolicyException)
pub mod insufficient_sns_topic_policy_exception {
    /// A builder for [`InsufficientSnsTopicPolicyException`](crate::error::InsufficientSnsTopicPolicyException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Brief description of the exception returned by the request.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>Brief description of the exception returned by the request.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InsufficientSnsTopicPolicyException`](crate::error::InsufficientSnsTopicPolicyException)
        pub fn build(self) -> crate::error::InsufficientSnsTopicPolicyException {
            crate::error::InsufficientSnsTopicPolicyException {
                message: self.message,
            }
        }
    }
}
impl InsufficientSnsTopicPolicyException {
    /// Creates a new builder-style object to manufacture [`InsufficientSnsTopicPolicyException`](crate::error::InsufficientSnsTopicPolicyException)
    pub fn builder() -> crate::error::insufficient_sns_topic_policy_exception::Builder {
        crate::error::insufficient_sns_topic_policy_exception::Builder::default()
    }
}

/// <p>This exception is thrown when the policy on the S3 bucket is not sufficient.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InsufficientS3BucketPolicyException {
    /// <p>Brief description of the exception returned by the request.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InsufficientS3BucketPolicyException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InsufficientS3BucketPolicyException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InsufficientS3BucketPolicyException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InsufficientS3BucketPolicyException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InsufficientS3BucketPolicyException")?;
        if let Some(inner_23) = &self.message {
            write!(f, ": {}", inner_23)?;
        }
        Ok(())
    }
}
impl std::error::Error for InsufficientS3BucketPolicyException {}
/// See [`InsufficientS3BucketPolicyException`](crate::error::InsufficientS3BucketPolicyException)
pub mod insufficient_s3_bucket_policy_exception {
    /// A builder for [`InsufficientS3BucketPolicyException`](crate::error::InsufficientS3BucketPolicyException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Brief description of the exception returned by the request.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>Brief description of the exception returned by the request.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InsufficientS3BucketPolicyException`](crate::error::InsufficientS3BucketPolicyException)
        pub fn build(self) -> crate::error::InsufficientS3BucketPolicyException {
            crate::error::InsufficientS3BucketPolicyException {
                message: self.message,
            }
        }
    }
}
impl InsufficientS3BucketPolicyException {
    /// Creates a new builder-style object to manufacture [`InsufficientS3BucketPolicyException`](crate::error::InsufficientS3BucketPolicyException)
    pub fn builder() -> crate::error::insufficient_s3_bucket_policy_exception::Builder {
        crate::error::insufficient_s3_bucket_policy_exception::Builder::default()
    }
}

/// <p>This exception is thrown when the policy on the S3 bucket or KMS key is not sufficient.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InsufficientEncryptionPolicyException {
    /// <p>Brief description of the exception returned by the request.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InsufficientEncryptionPolicyException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InsufficientEncryptionPolicyException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InsufficientEncryptionPolicyException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InsufficientEncryptionPolicyException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InsufficientEncryptionPolicyException")?;
        if let Some(inner_24) = &self.message {
            write!(f, ": {}", inner_24)?;
        }
        Ok(())
    }
}
impl std::error::Error for InsufficientEncryptionPolicyException {}
/// See [`InsufficientEncryptionPolicyException`](crate::error::InsufficientEncryptionPolicyException)
pub mod insufficient_encryption_policy_exception {
    /// A builder for [`InsufficientEncryptionPolicyException`](crate::error::InsufficientEncryptionPolicyException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Brief description of the exception returned by the request.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>Brief description of the exception returned by the request.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InsufficientEncryptionPolicyException`](crate::error::InsufficientEncryptionPolicyException)
        pub fn build(self) -> crate::error::InsufficientEncryptionPolicyException {
            crate::error::InsufficientEncryptionPolicyException {
                message: self.message,
            }
        }
    }
}
impl InsufficientEncryptionPolicyException {
    /// Creates a new builder-style object to manufacture [`InsufficientEncryptionPolicyException`](crate::error::InsufficientEncryptionPolicyException)
    pub fn builder() -> crate::error::insufficient_encryption_policy_exception::Builder {
        crate::error::insufficient_encryption_policy_exception::Builder::default()
    }
}

/// <p>This exception is thrown when the IAM user or role that is used to create the organization trail is lacking one or more required permissions for creating an organization trail in a required service. For more information, see <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/creating-an-organizational-trail-prepare.html">Prepare For Creating a Trail For Your Organization</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InsufficientDependencyServiceAccessPermissionException {
    /// <p>Brief description of the exception returned by the request.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InsufficientDependencyServiceAccessPermissionException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter =
            f.debug_struct("InsufficientDependencyServiceAccessPermissionException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InsufficientDependencyServiceAccessPermissionException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InsufficientDependencyServiceAccessPermissionException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InsufficientDependencyServiceAccessPermissionException")?;
        if let Some(inner_25) = &self.message {
            write!(f, ": {}", inner_25)?;
        }
        Ok(())
    }
}
impl std::error::Error for InsufficientDependencyServiceAccessPermissionException {}
/// See [`InsufficientDependencyServiceAccessPermissionException`](crate::error::InsufficientDependencyServiceAccessPermissionException)
pub mod insufficient_dependency_service_access_permission_exception {
    /// A builder for [`InsufficientDependencyServiceAccessPermissionException`](crate::error::InsufficientDependencyServiceAccessPermissionException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Brief description of the exception returned by the request.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>Brief description of the exception returned by the request.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InsufficientDependencyServiceAccessPermissionException`](crate::error::InsufficientDependencyServiceAccessPermissionException)
        pub fn build(self) -> crate::error::InsufficientDependencyServiceAccessPermissionException {
            crate::error::InsufficientDependencyServiceAccessPermissionException {
                message: self.message,
            }
        }
    }
}
impl InsufficientDependencyServiceAccessPermissionException {
    /// Creates a new builder-style object to manufacture [`InsufficientDependencyServiceAccessPermissionException`](crate::error::InsufficientDependencyServiceAccessPermissionException)
    pub fn builder(
    ) -> crate::error::insufficient_dependency_service_access_permission_exception::Builder {
        crate::error::insufficient_dependency_service_access_permission_exception::Builder::default(
        )
    }
}

/// <p>Cannot set a CloudWatch Logs delivery for this region.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CloudWatchLogsDeliveryUnavailableException {
    /// <p>Brief description of the exception returned by the request.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for CloudWatchLogsDeliveryUnavailableException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CloudWatchLogsDeliveryUnavailableException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl CloudWatchLogsDeliveryUnavailableException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for CloudWatchLogsDeliveryUnavailableException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "CloudWatchLogsDeliveryUnavailableException")?;
        if let Some(inner_26) = &self.message {
            write!(f, ": {}", inner_26)?;
        }
        Ok(())
    }
}
impl std::error::Error for CloudWatchLogsDeliveryUnavailableException {}
/// See [`CloudWatchLogsDeliveryUnavailableException`](crate::error::CloudWatchLogsDeliveryUnavailableException)
pub mod cloud_watch_logs_delivery_unavailable_exception {
    /// A builder for [`CloudWatchLogsDeliveryUnavailableException`](crate::error::CloudWatchLogsDeliveryUnavailableException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Brief description of the exception returned by the request.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>Brief description of the exception returned by the request.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`CloudWatchLogsDeliveryUnavailableException`](crate::error::CloudWatchLogsDeliveryUnavailableException)
        pub fn build(self) -> crate::error::CloudWatchLogsDeliveryUnavailableException {
            crate::error::CloudWatchLogsDeliveryUnavailableException {
                message: self.message,
            }
        }
    }
}
impl CloudWatchLogsDeliveryUnavailableException {
    /// Creates a new builder-style object to manufacture [`CloudWatchLogsDeliveryUnavailableException`](crate::error::CloudWatchLogsDeliveryUnavailableException)
    pub fn builder() -> crate::error::cloud_watch_logs_delivery_unavailable_exception::Builder {
        crate::error::cloud_watch_logs_delivery_unavailable_exception::Builder::default()
    }
}

/// <p>This exception is thrown when a call results in the <code>InvalidClientTokenId</code> error code. This can occur when you are creating or updating a trail to send notifications to an Amazon SNS topic that is in a suspended Amazon Web Services account.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CloudTrailInvalidClientTokenIdException {
    /// <p>Brief description of the exception returned by the request.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for CloudTrailInvalidClientTokenIdException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CloudTrailInvalidClientTokenIdException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl CloudTrailInvalidClientTokenIdException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for CloudTrailInvalidClientTokenIdException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "CloudTrailInvalidClientTokenIdException")?;
        if let Some(inner_27) = &self.message {
            write!(f, ": {}", inner_27)?;
        }
        Ok(())
    }
}
impl std::error::Error for CloudTrailInvalidClientTokenIdException {}
/// See [`CloudTrailInvalidClientTokenIdException`](crate::error::CloudTrailInvalidClientTokenIdException)
pub mod cloud_trail_invalid_client_token_id_exception {
    /// A builder for [`CloudTrailInvalidClientTokenIdException`](crate::error::CloudTrailInvalidClientTokenIdException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Brief description of the exception returned by the request.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>Brief description of the exception returned by the request.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`CloudTrailInvalidClientTokenIdException`](crate::error::CloudTrailInvalidClientTokenIdException)
        pub fn build(self) -> crate::error::CloudTrailInvalidClientTokenIdException {
            crate::error::CloudTrailInvalidClientTokenIdException {
                message: self.message,
            }
        }
    }
}
impl CloudTrailInvalidClientTokenIdException {
    /// Creates a new builder-style object to manufacture [`CloudTrailInvalidClientTokenIdException`](crate::error::CloudTrailInvalidClientTokenIdException)
    pub fn builder() -> crate::error::cloud_trail_invalid_client_token_id_exception::Builder {
        crate::error::cloud_trail_invalid_client_token_id_exception::Builder::default()
    }
}

/// <p>This exception is thrown when trusted access has not been enabled between CloudTrail and Organizations. For more information, see <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_integrate_services.html">Enabling Trusted Access with Other Amazon Web Services Services</a> and <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/creating-an-organizational-trail-prepare.html">Prepare For Creating a Trail For Your Organization</a>. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CloudTrailAccessNotEnabledException {
    /// <p>Brief description of the exception returned by the request.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for CloudTrailAccessNotEnabledException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CloudTrailAccessNotEnabledException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl CloudTrailAccessNotEnabledException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for CloudTrailAccessNotEnabledException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "CloudTrailAccessNotEnabledException")?;
        if let Some(inner_28) = &self.message {
            write!(f, ": {}", inner_28)?;
        }
        Ok(())
    }
}
impl std::error::Error for CloudTrailAccessNotEnabledException {}
/// See [`CloudTrailAccessNotEnabledException`](crate::error::CloudTrailAccessNotEnabledException)
pub mod cloud_trail_access_not_enabled_exception {
    /// A builder for [`CloudTrailAccessNotEnabledException`](crate::error::CloudTrailAccessNotEnabledException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Brief description of the exception returned by the request.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>Brief description of the exception returned by the request.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`CloudTrailAccessNotEnabledException`](crate::error::CloudTrailAccessNotEnabledException)
        pub fn build(self) -> crate::error::CloudTrailAccessNotEnabledException {
            crate::error::CloudTrailAccessNotEnabledException {
                message: self.message,
            }
        }
    }
}
impl CloudTrailAccessNotEnabledException {
    /// Creates a new builder-style object to manufacture [`CloudTrailAccessNotEnabledException`](crate::error::CloudTrailAccessNotEnabledException)
    pub fn builder() -> crate::error::cloud_trail_access_not_enabled_exception::Builder {
        crate::error::cloud_trail_access_not_enabled_exception::Builder::default()
    }
}

/// <p>The request includes a parameter that is not valid.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidParameterException {
    /// <p>Brief description of the exception returned by the request.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidParameterException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidParameterException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidParameterException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidParameterException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidParameterException")?;
        if let Some(inner_29) = &self.message {
            write!(f, ": {}", inner_29)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidParameterException {}
/// See [`InvalidParameterException`](crate::error::InvalidParameterException)
pub mod invalid_parameter_exception {
    /// A builder for [`InvalidParameterException`](crate::error::InvalidParameterException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Brief description of the exception returned by the request.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>Brief description of the exception returned by the request.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidParameterException`](crate::error::InvalidParameterException)
        pub fn build(self) -> crate::error::InvalidParameterException {
            crate::error::InvalidParameterException {
                message: self.message,
            }
        }
    }
}
impl InvalidParameterException {
    /// Creates a new builder-style object to manufacture [`InvalidParameterException`](crate::error::InvalidParameterException)
    pub fn builder() -> crate::error::invalid_parameter_exception::Builder {
        crate::error::invalid_parameter_exception::Builder::default()
    }
}

/// <p>The event data store against which you ran your query is inactive.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InactiveEventDataStoreException {
    /// <p>Brief description of the exception returned by the request.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InactiveEventDataStoreException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InactiveEventDataStoreException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InactiveEventDataStoreException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InactiveEventDataStoreException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InactiveEventDataStoreException")?;
        if let Some(inner_30) = &self.message {
            write!(f, ": {}", inner_30)?;
        }
        Ok(())
    }
}
impl std::error::Error for InactiveEventDataStoreException {}
/// See [`InactiveEventDataStoreException`](crate::error::InactiveEventDataStoreException)
pub mod inactive_event_data_store_exception {
    /// A builder for [`InactiveEventDataStoreException`](crate::error::InactiveEventDataStoreException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Brief description of the exception returned by the request.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>Brief description of the exception returned by the request.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InactiveEventDataStoreException`](crate::error::InactiveEventDataStoreException)
        pub fn build(self) -> crate::error::InactiveEventDataStoreException {
            crate::error::InactiveEventDataStoreException {
                message: self.message,
            }
        }
    }
}
impl InactiveEventDataStoreException {
    /// Creates a new builder-style object to manufacture [`InactiveEventDataStoreException`](crate::error::InactiveEventDataStoreException)
    pub fn builder() -> crate::error::inactive_event_data_store_exception::Builder {
        crate::error::inactive_event_data_store_exception::Builder::default()
    }
}

/// <p>The specified event data store was not found.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EventDataStoreNotFoundException {
    /// <p>Brief description of the exception returned by the request.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for EventDataStoreNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EventDataStoreNotFoundException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl EventDataStoreNotFoundException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for EventDataStoreNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "EventDataStoreNotFoundException")?;
        if let Some(inner_31) = &self.message {
            write!(f, ": {}", inner_31)?;
        }
        Ok(())
    }
}
impl std::error::Error for EventDataStoreNotFoundException {}
/// See [`EventDataStoreNotFoundException`](crate::error::EventDataStoreNotFoundException)
pub mod event_data_store_not_found_exception {
    /// A builder for [`EventDataStoreNotFoundException`](crate::error::EventDataStoreNotFoundException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Brief description of the exception returned by the request.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>Brief description of the exception returned by the request.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`EventDataStoreNotFoundException`](crate::error::EventDataStoreNotFoundException)
        pub fn build(self) -> crate::error::EventDataStoreNotFoundException {
            crate::error::EventDataStoreNotFoundException {
                message: self.message,
            }
        }
    }
}
impl EventDataStoreNotFoundException {
    /// Creates a new builder-style object to manufacture [`EventDataStoreNotFoundException`](crate::error::EventDataStoreNotFoundException)
    pub fn builder() -> crate::error::event_data_store_not_found_exception::Builder {
        crate::error::event_data_store_not_found_exception::Builder::default()
    }
}

/// <p>The specified event data store ARN is not valid or does not map to an event data store in your account.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EventDataStoreArnInvalidException {
    /// <p>Brief description of the exception returned by the request.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for EventDataStoreArnInvalidException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EventDataStoreArnInvalidException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl EventDataStoreArnInvalidException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for EventDataStoreArnInvalidException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(
            f,
            "EventDataStoreArnInvalidException [EventDataStoreARNInvalidException]"
        )?;
        if let Some(inner_32) = &self.message {
            write!(f, ": {}", inner_32)?;
        }
        Ok(())
    }
}
impl std::error::Error for EventDataStoreArnInvalidException {}
/// See [`EventDataStoreArnInvalidException`](crate::error::EventDataStoreArnInvalidException)
pub mod event_data_store_arn_invalid_exception {
    /// A builder for [`EventDataStoreArnInvalidException`](crate::error::EventDataStoreArnInvalidException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Brief description of the exception returned by the request.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>Brief description of the exception returned by the request.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`EventDataStoreArnInvalidException`](crate::error::EventDataStoreArnInvalidException)
        pub fn build(self) -> crate::error::EventDataStoreArnInvalidException {
            crate::error::EventDataStoreArnInvalidException {
                message: self.message,
            }
        }
    }
}
impl EventDataStoreArnInvalidException {
    /// Creates a new builder-style object to manufacture [`EventDataStoreArnInvalidException`](crate::error::EventDataStoreArnInvalidException)
    pub fn builder() -> crate::error::event_data_store_arn_invalid_exception::Builder {
        crate::error::event_data_store_arn_invalid_exception::Builder::default()
    }
}

/// <p>You are already running the maximum number of concurrent queries. Wait a minute for some queries to finish, and then run the query again.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MaxConcurrentQueriesException {
    /// <p>Brief description of the exception returned by the request.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for MaxConcurrentQueriesException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MaxConcurrentQueriesException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl MaxConcurrentQueriesException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for MaxConcurrentQueriesException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "MaxConcurrentQueriesException")?;
        if let Some(inner_33) = &self.message {
            write!(f, ": {}", inner_33)?;
        }
        Ok(())
    }
}
impl std::error::Error for MaxConcurrentQueriesException {}
/// See [`MaxConcurrentQueriesException`](crate::error::MaxConcurrentQueriesException)
pub mod max_concurrent_queries_exception {
    /// A builder for [`MaxConcurrentQueriesException`](crate::error::MaxConcurrentQueriesException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Brief description of the exception returned by the request.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>Brief description of the exception returned by the request.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`MaxConcurrentQueriesException`](crate::error::MaxConcurrentQueriesException)
        pub fn build(self) -> crate::error::MaxConcurrentQueriesException {
            crate::error::MaxConcurrentQueriesException {
                message: self.message,
            }
        }
    }
}
impl MaxConcurrentQueriesException {
    /// Creates a new builder-style object to manufacture [`MaxConcurrentQueriesException`](crate::error::MaxConcurrentQueriesException)
    pub fn builder() -> crate::error::max_concurrent_queries_exception::Builder {
        crate::error::max_concurrent_queries_exception::Builder::default()
    }
}

/// <p>The query that was submitted has validation errors, or uses incorrect syntax or unsupported keywords. For more information about writing a query, see <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/query-create-edit-query.html">Create or edit a query</a> in the <i>CloudTrail User Guide</i>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidQueryStatementException {
    /// <p>Brief description of the exception returned by the request.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidQueryStatementException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidQueryStatementException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidQueryStatementException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidQueryStatementException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidQueryStatementException")?;
        if let Some(inner_34) = &self.message {
            write!(f, ": {}", inner_34)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidQueryStatementException {}
/// See [`InvalidQueryStatementException`](crate::error::InvalidQueryStatementException)
pub mod invalid_query_statement_exception {
    /// A builder for [`InvalidQueryStatementException`](crate::error::InvalidQueryStatementException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Brief description of the exception returned by the request.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>Brief description of the exception returned by the request.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidQueryStatementException`](crate::error::InvalidQueryStatementException)
        pub fn build(self) -> crate::error::InvalidQueryStatementException {
            crate::error::InvalidQueryStatementException {
                message: self.message,
            }
        }
    }
}
impl InvalidQueryStatementException {
    /// Creates a new builder-style object to manufacture [`InvalidQueryStatementException`](crate::error::InvalidQueryStatementException)
    pub fn builder() -> crate::error::invalid_query_statement_exception::Builder {
        crate::error::invalid_query_statement_exception::Builder::default()
    }
}

/// <p>The event data store is not in a status that supports the operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidEventDataStoreStatusException {
    /// <p>Brief description of the exception returned by the request.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidEventDataStoreStatusException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidEventDataStoreStatusException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidEventDataStoreStatusException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidEventDataStoreStatusException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidEventDataStoreStatusException")?;
        if let Some(inner_35) = &self.message {
            write!(f, ": {}", inner_35)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidEventDataStoreStatusException {}
/// See [`InvalidEventDataStoreStatusException`](crate::error::InvalidEventDataStoreStatusException)
pub mod invalid_event_data_store_status_exception {
    /// A builder for [`InvalidEventDataStoreStatusException`](crate::error::InvalidEventDataStoreStatusException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Brief description of the exception returned by the request.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>Brief description of the exception returned by the request.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidEventDataStoreStatusException`](crate::error::InvalidEventDataStoreStatusException)
        pub fn build(self) -> crate::error::InvalidEventDataStoreStatusException {
            crate::error::InvalidEventDataStoreStatusException {
                message: self.message,
            }
        }
    }
}
impl InvalidEventDataStoreStatusException {
    /// Creates a new builder-style object to manufacture [`InvalidEventDataStoreStatusException`](crate::error::InvalidEventDataStoreStatusException)
    pub fn builder() -> crate::error::invalid_event_data_store_status_exception::Builder {
        crate::error::invalid_event_data_store_status_exception::Builder::default()
    }
}

/// <p>Your account has used the maximum number of event data stores.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EventDataStoreMaxLimitExceededException {
    /// <p>Brief description of the exception returned by the request.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for EventDataStoreMaxLimitExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EventDataStoreMaxLimitExceededException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl EventDataStoreMaxLimitExceededException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for EventDataStoreMaxLimitExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "EventDataStoreMaxLimitExceededException")?;
        if let Some(inner_36) = &self.message {
            write!(f, ": {}", inner_36)?;
        }
        Ok(())
    }
}
impl std::error::Error for EventDataStoreMaxLimitExceededException {}
/// See [`EventDataStoreMaxLimitExceededException`](crate::error::EventDataStoreMaxLimitExceededException)
pub mod event_data_store_max_limit_exceeded_exception {
    /// A builder for [`EventDataStoreMaxLimitExceededException`](crate::error::EventDataStoreMaxLimitExceededException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Brief description of the exception returned by the request.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>Brief description of the exception returned by the request.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`EventDataStoreMaxLimitExceededException`](crate::error::EventDataStoreMaxLimitExceededException)
        pub fn build(self) -> crate::error::EventDataStoreMaxLimitExceededException {
            crate::error::EventDataStoreMaxLimitExceededException {
                message: self.message,
            }
        }
    }
}
impl EventDataStoreMaxLimitExceededException {
    /// Creates a new builder-style object to manufacture [`EventDataStoreMaxLimitExceededException`](crate::error::EventDataStoreMaxLimitExceededException)
    pub fn builder() -> crate::error::event_data_store_max_limit_exceeded_exception::Builder {
        crate::error::event_data_store_max_limit_exceeded_exception::Builder::default()
    }
}

/// <p>This exception is thrown when the specified resource type is not supported by CloudTrail.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResourceTypeNotSupportedException {
    /// <p>Brief description of the exception returned by the request.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ResourceTypeNotSupportedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResourceTypeNotSupportedException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ResourceTypeNotSupportedException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ResourceTypeNotSupportedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ResourceTypeNotSupportedException")?;
        if let Some(inner_37) = &self.message {
            write!(f, ": {}", inner_37)?;
        }
        Ok(())
    }
}
impl std::error::Error for ResourceTypeNotSupportedException {}
/// See [`ResourceTypeNotSupportedException`](crate::error::ResourceTypeNotSupportedException)
pub mod resource_type_not_supported_exception {
    /// A builder for [`ResourceTypeNotSupportedException`](crate::error::ResourceTypeNotSupportedException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Brief description of the exception returned by the request.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>Brief description of the exception returned by the request.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ResourceTypeNotSupportedException`](crate::error::ResourceTypeNotSupportedException)
        pub fn build(self) -> crate::error::ResourceTypeNotSupportedException {
            crate::error::ResourceTypeNotSupportedException {
                message: self.message,
            }
        }
    }
}
impl ResourceTypeNotSupportedException {
    /// Creates a new builder-style object to manufacture [`ResourceTypeNotSupportedException`](crate::error::ResourceTypeNotSupportedException)
    pub fn builder() -> crate::error::resource_type_not_supported_exception::Builder {
        crate::error::resource_type_not_supported_exception::Builder::default()
    }
}

/// <p>This exception is thrown when the specified resource is not found.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResourceNotFoundException {
    /// <p>Brief description of the exception returned by the request.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ResourceNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResourceNotFoundException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ResourceNotFoundException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ResourceNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ResourceNotFoundException")?;
        if let Some(inner_38) = &self.message {
            write!(f, ": {}", inner_38)?;
        }
        Ok(())
    }
}
impl std::error::Error for ResourceNotFoundException {}
/// See [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
pub mod resource_not_found_exception {
    /// A builder for [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Brief description of the exception returned by the request.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>Brief description of the exception returned by the request.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
        pub fn build(self) -> crate::error::ResourceNotFoundException {
            crate::error::ResourceNotFoundException {
                message: self.message,
            }
        }
    }
}
impl ResourceNotFoundException {
    /// Creates a new builder-style object to manufacture [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
    pub fn builder() -> crate::error::resource_not_found_exception::Builder {
        crate::error::resource_not_found_exception::Builder::default()
    }
}

/// <p>This exception is thrown when the specified tag key or values are not valid. It can also occur if there are duplicate tags or too many tags on the resource.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidTagParameterException {
    /// <p>Brief description of the exception returned by the request.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidTagParameterException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidTagParameterException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidTagParameterException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidTagParameterException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidTagParameterException")?;
        if let Some(inner_39) = &self.message {
            write!(f, ": {}", inner_39)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidTagParameterException {}
/// See [`InvalidTagParameterException`](crate::error::InvalidTagParameterException)
pub mod invalid_tag_parameter_exception {
    /// A builder for [`InvalidTagParameterException`](crate::error::InvalidTagParameterException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Brief description of the exception returned by the request.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>Brief description of the exception returned by the request.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidTagParameterException`](crate::error::InvalidTagParameterException)
        pub fn build(self) -> crate::error::InvalidTagParameterException {
            crate::error::InvalidTagParameterException {
                message: self.message,
            }
        }
    }
}
impl InvalidTagParameterException {
    /// Creates a new builder-style object to manufacture [`InvalidTagParameterException`](crate::error::InvalidTagParameterException)
    pub fn builder() -> crate::error::invalid_tag_parameter_exception::Builder {
        crate::error::invalid_tag_parameter_exception::Builder::default()
    }
}

/// <p>This exception is thrown when an operation is called with a trail ARN that is not valid. The following is the format of a trail ARN.</p>
/// <p> <code>arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail</code> </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CloudTrailArnInvalidException {
    /// <p>Brief description of the exception returned by the request.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for CloudTrailArnInvalidException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CloudTrailArnInvalidException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl CloudTrailArnInvalidException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for CloudTrailArnInvalidException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(
            f,
            "CloudTrailArnInvalidException [CloudTrailARNInvalidException]"
        )?;
        if let Some(inner_40) = &self.message {
            write!(f, ": {}", inner_40)?;
        }
        Ok(())
    }
}
impl std::error::Error for CloudTrailArnInvalidException {}
/// See [`CloudTrailArnInvalidException`](crate::error::CloudTrailArnInvalidException)
pub mod cloud_trail_arn_invalid_exception {
    /// A builder for [`CloudTrailArnInvalidException`](crate::error::CloudTrailArnInvalidException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Brief description of the exception returned by the request.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>Brief description of the exception returned by the request.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`CloudTrailArnInvalidException`](crate::error::CloudTrailArnInvalidException)
        pub fn build(self) -> crate::error::CloudTrailArnInvalidException {
            crate::error::CloudTrailArnInvalidException {
                message: self.message,
            }
        }
    }
}
impl CloudTrailArnInvalidException {
    /// Creates a new builder-style object to manufacture [`CloudTrailArnInvalidException`](crate::error::CloudTrailArnInvalidException)
    pub fn builder() -> crate::error::cloud_trail_arn_invalid_exception::Builder {
        crate::error::cloud_trail_arn_invalid_exception::Builder::default()
    }
}

/// <p>The formatting or syntax of the <code>InsightSelectors</code> JSON statement in your <code>PutInsightSelectors</code> or <code>GetInsightSelectors</code> request is not valid, or the specified insight type in the <code>InsightSelectors</code> statement is not a valid insight type.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidInsightSelectorsException {
    /// <p>Brief description of the exception returned by the request.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidInsightSelectorsException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidInsightSelectorsException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidInsightSelectorsException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidInsightSelectorsException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidInsightSelectorsException")?;
        if let Some(inner_41) = &self.message {
            write!(f, ": {}", inner_41)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidInsightSelectorsException {}
/// See [`InvalidInsightSelectorsException`](crate::error::InvalidInsightSelectorsException)
pub mod invalid_insight_selectors_exception {
    /// A builder for [`InvalidInsightSelectorsException`](crate::error::InvalidInsightSelectorsException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Brief description of the exception returned by the request.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>Brief description of the exception returned by the request.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidInsightSelectorsException`](crate::error::InvalidInsightSelectorsException)
        pub fn build(self) -> crate::error::InvalidInsightSelectorsException {
            crate::error::InvalidInsightSelectorsException {
                message: self.message,
            }
        }
    }
}
impl InvalidInsightSelectorsException {
    /// Creates a new builder-style object to manufacture [`InvalidInsightSelectorsException`](crate::error::InvalidInsightSelectorsException)
    pub fn builder() -> crate::error::invalid_insight_selectors_exception::Builder {
        crate::error::invalid_insight_selectors_exception::Builder::default()
    }
}

/// <p>Occurs if the timestamp values are not valid. Either the start time occurs after the end time, or the time range is outside the range of possible values.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidTimeRangeException {
    /// <p>Brief description of the exception returned by the request.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidTimeRangeException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidTimeRangeException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidTimeRangeException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidTimeRangeException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidTimeRangeException")?;
        if let Some(inner_42) = &self.message {
            write!(f, ": {}", inner_42)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidTimeRangeException {}
/// See [`InvalidTimeRangeException`](crate::error::InvalidTimeRangeException)
pub mod invalid_time_range_exception {
    /// A builder for [`InvalidTimeRangeException`](crate::error::InvalidTimeRangeException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Brief description of the exception returned by the request.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>Brief description of the exception returned by the request.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidTimeRangeException`](crate::error::InvalidTimeRangeException)
        pub fn build(self) -> crate::error::InvalidTimeRangeException {
            crate::error::InvalidTimeRangeException {
                message: self.message,
            }
        }
    }
}
impl InvalidTimeRangeException {
    /// Creates a new builder-style object to manufacture [`InvalidTimeRangeException`](crate::error::InvalidTimeRangeException)
    pub fn builder() -> crate::error::invalid_time_range_exception::Builder {
        crate::error::invalid_time_range_exception::Builder::default()
    }
}

/// <p>A token that is not valid, or a token that was previously used in a request with different parameters. This exception is thrown if the token is not valid.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidNextTokenException {
    /// <p>Brief description of the exception returned by the request.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidNextTokenException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidNextTokenException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidNextTokenException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidNextTokenException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidNextTokenException")?;
        if let Some(inner_43) = &self.message {
            write!(f, ": {}", inner_43)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidNextTokenException {}
/// See [`InvalidNextTokenException`](crate::error::InvalidNextTokenException)
pub mod invalid_next_token_exception {
    /// A builder for [`InvalidNextTokenException`](crate::error::InvalidNextTokenException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Brief description of the exception returned by the request.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>Brief description of the exception returned by the request.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidNextTokenException`](crate::error::InvalidNextTokenException)
        pub fn build(self) -> crate::error::InvalidNextTokenException {
            crate::error::InvalidNextTokenException {
                message: self.message,
            }
        }
    }
}
impl InvalidNextTokenException {
    /// Creates a new builder-style object to manufacture [`InvalidNextTokenException`](crate::error::InvalidNextTokenException)
    pub fn builder() -> crate::error::invalid_next_token_exception::Builder {
        crate::error::invalid_next_token_exception::Builder::default()
    }
}

/// <p>This exception is thrown if the limit specified is not valid.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidMaxResultsException {
    /// <p>Brief description of the exception returned by the request.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidMaxResultsException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidMaxResultsException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidMaxResultsException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidMaxResultsException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidMaxResultsException")?;
        if let Some(inner_44) = &self.message {
            write!(f, ": {}", inner_44)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidMaxResultsException {}
/// See [`InvalidMaxResultsException`](crate::error::InvalidMaxResultsException)
pub mod invalid_max_results_exception {
    /// A builder for [`InvalidMaxResultsException`](crate::error::InvalidMaxResultsException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Brief description of the exception returned by the request.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>Brief description of the exception returned by the request.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidMaxResultsException`](crate::error::InvalidMaxResultsException)
        pub fn build(self) -> crate::error::InvalidMaxResultsException {
            crate::error::InvalidMaxResultsException {
                message: self.message,
            }
        }
    }
}
impl InvalidMaxResultsException {
    /// Creates a new builder-style object to manufacture [`InvalidMaxResultsException`](crate::error::InvalidMaxResultsException)
    pub fn builder() -> crate::error::invalid_max_results_exception::Builder {
        crate::error::invalid_max_results_exception::Builder::default()
    }
}

/// <p>Occurs when a lookup attribute is specified that is not valid.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidLookupAttributesException {
    /// <p>Brief description of the exception returned by the request.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidLookupAttributesException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidLookupAttributesException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidLookupAttributesException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidLookupAttributesException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidLookupAttributesException")?;
        if let Some(inner_45) = &self.message {
            write!(f, ": {}", inner_45)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidLookupAttributesException {}
/// See [`InvalidLookupAttributesException`](crate::error::InvalidLookupAttributesException)
pub mod invalid_lookup_attributes_exception {
    /// A builder for [`InvalidLookupAttributesException`](crate::error::InvalidLookupAttributesException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Brief description of the exception returned by the request.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>Brief description of the exception returned by the request.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidLookupAttributesException`](crate::error::InvalidLookupAttributesException)
        pub fn build(self) -> crate::error::InvalidLookupAttributesException {
            crate::error::InvalidLookupAttributesException {
                message: self.message,
            }
        }
    }
}
impl InvalidLookupAttributesException {
    /// Creates a new builder-style object to manufacture [`InvalidLookupAttributesException`](crate::error::InvalidLookupAttributesException)
    pub fn builder() -> crate::error::invalid_lookup_attributes_exception::Builder {
        crate::error::invalid_lookup_attributes_exception::Builder::default()
    }
}

/// <p>Occurs if an event category that is not valid is specified as a value of <code>EventCategory</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidEventCategoryException {
    /// <p>Brief description of the exception returned by the request.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidEventCategoryException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidEventCategoryException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidEventCategoryException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidEventCategoryException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidEventCategoryException")?;
        if let Some(inner_46) = &self.message {
            write!(f, ": {}", inner_46)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidEventCategoryException {}
/// See [`InvalidEventCategoryException`](crate::error::InvalidEventCategoryException)
pub mod invalid_event_category_exception {
    /// A builder for [`InvalidEventCategoryException`](crate::error::InvalidEventCategoryException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Brief description of the exception returned by the request.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>Brief description of the exception returned by the request.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidEventCategoryException`](crate::error::InvalidEventCategoryException)
        pub fn build(self) -> crate::error::InvalidEventCategoryException {
            crate::error::InvalidEventCategoryException {
                message: self.message,
            }
        }
    }
}
impl InvalidEventCategoryException {
    /// Creates a new builder-style object to manufacture [`InvalidEventCategoryException`](crate::error::InvalidEventCategoryException)
    pub fn builder() -> crate::error::invalid_event_category_exception::Builder {
        crate::error::invalid_event_category_exception::Builder::default()
    }
}

/// <p>Reserved for future use.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidTokenException {
    /// <p>Brief description of the exception returned by the request.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidTokenException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidTokenException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidTokenException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidTokenException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidTokenException")?;
        if let Some(inner_47) = &self.message {
            write!(f, ": {}", inner_47)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidTokenException {}
/// See [`InvalidTokenException`](crate::error::InvalidTokenException)
pub mod invalid_token_exception {
    /// A builder for [`InvalidTokenException`](crate::error::InvalidTokenException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Brief description of the exception returned by the request.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>Brief description of the exception returned by the request.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidTokenException`](crate::error::InvalidTokenException)
        pub fn build(self) -> crate::error::InvalidTokenException {
            crate::error::InvalidTokenException {
                message: self.message,
            }
        }
    }
}
impl InvalidTokenException {
    /// Creates a new builder-style object to manufacture [`InvalidTokenException`](crate::error::InvalidTokenException)
    pub fn builder() -> crate::error::invalid_token_exception::Builder {
        crate::error::invalid_token_exception::Builder::default()
    }
}

/// <p>The query status is not valid for the operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidQueryStatusException {
    /// <p>Brief description of the exception returned by the request.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidQueryStatusException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidQueryStatusException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidQueryStatusException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidQueryStatusException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidQueryStatusException")?;
        if let Some(inner_48) = &self.message {
            write!(f, ": {}", inner_48)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidQueryStatusException {}
/// See [`InvalidQueryStatusException`](crate::error::InvalidQueryStatusException)
pub mod invalid_query_status_exception {
    /// A builder for [`InvalidQueryStatusException`](crate::error::InvalidQueryStatusException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Brief description of the exception returned by the request.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>Brief description of the exception returned by the request.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidQueryStatusException`](crate::error::InvalidQueryStatusException)
        pub fn build(self) -> crate::error::InvalidQueryStatusException {
            crate::error::InvalidQueryStatusException {
                message: self.message,
            }
        }
    }
}
impl InvalidQueryStatusException {
    /// Creates a new builder-style object to manufacture [`InvalidQueryStatusException`](crate::error::InvalidQueryStatusException)
    pub fn builder() -> crate::error::invalid_query_status_exception::Builder {
        crate::error::invalid_query_status_exception::Builder::default()
    }
}

/// <p>A date range for the query was specified that is not valid. For more information about writing a query, see <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/query-create-edit-query.html">Create or edit a query</a> in the <i>CloudTrail User Guide</i>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidDateRangeException {
    /// <p>Brief description of the exception returned by the request.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidDateRangeException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidDateRangeException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidDateRangeException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidDateRangeException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidDateRangeException")?;
        if let Some(inner_49) = &self.message {
            write!(f, ": {}", inner_49)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidDateRangeException {}
/// See [`InvalidDateRangeException`](crate::error::InvalidDateRangeException)
pub mod invalid_date_range_exception {
    /// A builder for [`InvalidDateRangeException`](crate::error::InvalidDateRangeException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Brief description of the exception returned by the request.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>Brief description of the exception returned by the request.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidDateRangeException`](crate::error::InvalidDateRangeException)
        pub fn build(self) -> crate::error::InvalidDateRangeException {
            crate::error::InvalidDateRangeException {
                message: self.message,
            }
        }
    }
}
impl InvalidDateRangeException {
    /// Creates a new builder-style object to manufacture [`InvalidDateRangeException`](crate::error::InvalidDateRangeException)
    pub fn builder() -> crate::error::invalid_date_range_exception::Builder {
        crate::error::invalid_date_range_exception::Builder::default()
    }
}

/// <p>The query ID does not exist or does not map to a query.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct QueryIdNotFoundException {
    /// <p>Brief description of the exception returned by the request.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for QueryIdNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("QueryIdNotFoundException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl QueryIdNotFoundException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for QueryIdNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "QueryIdNotFoundException")?;
        if let Some(inner_50) = &self.message {
            write!(f, ": {}", inner_50)?;
        }
        Ok(())
    }
}
impl std::error::Error for QueryIdNotFoundException {}
/// See [`QueryIdNotFoundException`](crate::error::QueryIdNotFoundException)
pub mod query_id_not_found_exception {
    /// A builder for [`QueryIdNotFoundException`](crate::error::QueryIdNotFoundException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Brief description of the exception returned by the request.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>Brief description of the exception returned by the request.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`QueryIdNotFoundException`](crate::error::QueryIdNotFoundException)
        pub fn build(self) -> crate::error::QueryIdNotFoundException {
            crate::error::QueryIdNotFoundException {
                message: self.message,
            }
        }
    }
}
impl QueryIdNotFoundException {
    /// Creates a new builder-style object to manufacture [`QueryIdNotFoundException`](crate::error::QueryIdNotFoundException)
    pub fn builder() -> crate::error::query_id_not_found_exception::Builder {
        crate::error::query_id_not_found_exception::Builder::default()
    }
}

/// <p>If you run <code>GetInsightSelectors</code> on a trail that does not have Insights events enabled, the operation throws the exception <code>InsightNotEnabledException</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InsightNotEnabledException {
    /// <p>Brief description of the exception returned by the request.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InsightNotEnabledException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InsightNotEnabledException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InsightNotEnabledException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InsightNotEnabledException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InsightNotEnabledException")?;
        if let Some(inner_51) = &self.message {
            write!(f, ": {}", inner_51)?;
        }
        Ok(())
    }
}
impl std::error::Error for InsightNotEnabledException {}
/// See [`InsightNotEnabledException`](crate::error::InsightNotEnabledException)
pub mod insight_not_enabled_exception {
    /// A builder for [`InsightNotEnabledException`](crate::error::InsightNotEnabledException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Brief description of the exception returned by the request.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>Brief description of the exception returned by the request.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InsightNotEnabledException`](crate::error::InsightNotEnabledException)
        pub fn build(self) -> crate::error::InsightNotEnabledException {
            crate::error::InsightNotEnabledException {
                message: self.message,
            }
        }
    }
}
impl InsightNotEnabledException {
    /// Creates a new builder-style object to manufacture [`InsightNotEnabledException`](crate::error::InsightNotEnabledException)
    pub fn builder() -> crate::error::insight_not_enabled_exception::Builder {
        crate::error::insight_not_enabled_exception::Builder::default()
    }
}

/// <p>This exception is thrown when the specified resource is not ready for an operation. This can occur when you try to run an operation on a trail before CloudTrail has time to fully load the trail. If this exception occurs, wait a few minutes, and then try the operation again.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ConflictException {
    /// <p>Brief description of the exception returned by the request.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ConflictException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ConflictException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ConflictException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ConflictException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ConflictException")?;
        if let Some(inner_52) = &self.message {
            write!(f, ": {}", inner_52)?;
        }
        Ok(())
    }
}
impl std::error::Error for ConflictException {}
/// See [`ConflictException`](crate::error::ConflictException)
pub mod conflict_exception {
    /// A builder for [`ConflictException`](crate::error::ConflictException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Brief description of the exception returned by the request.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>Brief description of the exception returned by the request.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ConflictException`](crate::error::ConflictException)
        pub fn build(self) -> crate::error::ConflictException {
            crate::error::ConflictException {
                message: self.message,
            }
        }
    }
}
impl ConflictException {
    /// Creates a new builder-style object to manufacture [`ConflictException`](crate::error::ConflictException)
    pub fn builder() -> crate::error::conflict_exception::Builder {
        crate::error::conflict_exception::Builder::default()
    }
}

/// <p>The event data store cannot be deleted because termination protection is enabled for it.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EventDataStoreTerminationProtectedException {
    /// <p>Brief description of the exception returned by the request.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for EventDataStoreTerminationProtectedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EventDataStoreTerminationProtectedException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl EventDataStoreTerminationProtectedException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for EventDataStoreTerminationProtectedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "EventDataStoreTerminationProtectedException")?;
        if let Some(inner_53) = &self.message {
            write!(f, ": {}", inner_53)?;
        }
        Ok(())
    }
}
impl std::error::Error for EventDataStoreTerminationProtectedException {}
/// See [`EventDataStoreTerminationProtectedException`](crate::error::EventDataStoreTerminationProtectedException)
pub mod event_data_store_termination_protected_exception {
    /// A builder for [`EventDataStoreTerminationProtectedException`](crate::error::EventDataStoreTerminationProtectedException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Brief description of the exception returned by the request.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>Brief description of the exception returned by the request.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`EventDataStoreTerminationProtectedException`](crate::error::EventDataStoreTerminationProtectedException)
        pub fn build(self) -> crate::error::EventDataStoreTerminationProtectedException {
            crate::error::EventDataStoreTerminationProtectedException {
                message: self.message,
            }
        }
    }
}
impl EventDataStoreTerminationProtectedException {
    /// Creates a new builder-style object to manufacture [`EventDataStoreTerminationProtectedException`](crate::error::EventDataStoreTerminationProtectedException)
    pub fn builder() -> crate::error::event_data_store_termination_protected_exception::Builder {
        crate::error::event_data_store_termination_protected_exception::Builder::default()
    }
}

/// <p>This exception is thrown when the specified trail already exists.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TrailAlreadyExistsException {
    /// <p>Brief description of the exception returned by the request.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for TrailAlreadyExistsException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TrailAlreadyExistsException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl TrailAlreadyExistsException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for TrailAlreadyExistsException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "TrailAlreadyExistsException")?;
        if let Some(inner_54) = &self.message {
            write!(f, ": {}", inner_54)?;
        }
        Ok(())
    }
}
impl std::error::Error for TrailAlreadyExistsException {}
/// See [`TrailAlreadyExistsException`](crate::error::TrailAlreadyExistsException)
pub mod trail_already_exists_exception {
    /// A builder for [`TrailAlreadyExistsException`](crate::error::TrailAlreadyExistsException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Brief description of the exception returned by the request.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>Brief description of the exception returned by the request.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`TrailAlreadyExistsException`](crate::error::TrailAlreadyExistsException)
        pub fn build(self) -> crate::error::TrailAlreadyExistsException {
            crate::error::TrailAlreadyExistsException {
                message: self.message,
            }
        }
    }
}
impl TrailAlreadyExistsException {
    /// Creates a new builder-style object to manufacture [`TrailAlreadyExistsException`](crate::error::TrailAlreadyExistsException)
    pub fn builder() -> crate::error::trail_already_exists_exception::Builder {
        crate::error::trail_already_exists_exception::Builder::default()
    }
}

/// <p>This exception is thrown when the maximum number of trails is reached.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MaximumNumberOfTrailsExceededException {
    /// <p>Brief description of the exception returned by the request.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for MaximumNumberOfTrailsExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MaximumNumberOfTrailsExceededException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl MaximumNumberOfTrailsExceededException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for MaximumNumberOfTrailsExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "MaximumNumberOfTrailsExceededException")?;
        if let Some(inner_55) = &self.message {
            write!(f, ": {}", inner_55)?;
        }
        Ok(())
    }
}
impl std::error::Error for MaximumNumberOfTrailsExceededException {}
/// See [`MaximumNumberOfTrailsExceededException`](crate::error::MaximumNumberOfTrailsExceededException)
pub mod maximum_number_of_trails_exceeded_exception {
    /// A builder for [`MaximumNumberOfTrailsExceededException`](crate::error::MaximumNumberOfTrailsExceededException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Brief description of the exception returned by the request.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>Brief description of the exception returned by the request.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`MaximumNumberOfTrailsExceededException`](crate::error::MaximumNumberOfTrailsExceededException)
        pub fn build(self) -> crate::error::MaximumNumberOfTrailsExceededException {
            crate::error::MaximumNumberOfTrailsExceededException {
                message: self.message,
            }
        }
    }
}
impl MaximumNumberOfTrailsExceededException {
    /// Creates a new builder-style object to manufacture [`MaximumNumberOfTrailsExceededException`](crate::error::MaximumNumberOfTrailsExceededException)
    pub fn builder() -> crate::error::maximum_number_of_trails_exceeded_exception::Builder {
        crate::error::maximum_number_of_trails_exceeded_exception::Builder::default()
    }
}

/// <p>An event data store with that name already exists.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EventDataStoreAlreadyExistsException {
    /// <p>Brief description of the exception returned by the request.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for EventDataStoreAlreadyExistsException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EventDataStoreAlreadyExistsException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl EventDataStoreAlreadyExistsException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for EventDataStoreAlreadyExistsException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "EventDataStoreAlreadyExistsException")?;
        if let Some(inner_56) = &self.message {
            write!(f, ": {}", inner_56)?;
        }
        Ok(())
    }
}
impl std::error::Error for EventDataStoreAlreadyExistsException {}
/// See [`EventDataStoreAlreadyExistsException`](crate::error::EventDataStoreAlreadyExistsException)
pub mod event_data_store_already_exists_exception {
    /// A builder for [`EventDataStoreAlreadyExistsException`](crate::error::EventDataStoreAlreadyExistsException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Brief description of the exception returned by the request.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>Brief description of the exception returned by the request.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`EventDataStoreAlreadyExistsException`](crate::error::EventDataStoreAlreadyExistsException)
        pub fn build(self) -> crate::error::EventDataStoreAlreadyExistsException {
            crate::error::EventDataStoreAlreadyExistsException {
                message: self.message,
            }
        }
    }
}
impl EventDataStoreAlreadyExistsException {
    /// Creates a new builder-style object to manufacture [`EventDataStoreAlreadyExistsException`](crate::error::EventDataStoreAlreadyExistsException)
    pub fn builder() -> crate::error::event_data_store_already_exists_exception::Builder {
        crate::error::event_data_store_already_exists_exception::Builder::default()
    }
}

/// <p>The specified query cannot be canceled because it is in the <code>FINISHED</code>, <code>FAILED</code>, <code>TIMED_OUT</code>, or <code>CANCELLED</code> state.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InactiveQueryException {
    /// <p>Brief description of the exception returned by the request.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InactiveQueryException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InactiveQueryException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InactiveQueryException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InactiveQueryException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InactiveQueryException")?;
        if let Some(inner_57) = &self.message {
            write!(f, ": {}", inner_57)?;
        }
        Ok(())
    }
}
impl std::error::Error for InactiveQueryException {}
/// See [`InactiveQueryException`](crate::error::InactiveQueryException)
pub mod inactive_query_exception {
    /// A builder for [`InactiveQueryException`](crate::error::InactiveQueryException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Brief description of the exception returned by the request.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>Brief description of the exception returned by the request.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InactiveQueryException`](crate::error::InactiveQueryException)
        pub fn build(self) -> crate::error::InactiveQueryException {
            crate::error::InactiveQueryException {
                message: self.message,
            }
        }
    }
}
impl InactiveQueryException {
    /// Creates a new builder-style object to manufacture [`InactiveQueryException`](crate::error::InactiveQueryException)
    pub fn builder() -> crate::error::inactive_query_exception::Builder {
        crate::error::inactive_query_exception::Builder::default()
    }
}

/// <p>The number of tags per trail has exceeded the permitted amount. Currently, the limit is 50.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TagsLimitExceededException {
    /// <p>Brief description of the exception returned by the request.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for TagsLimitExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TagsLimitExceededException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl TagsLimitExceededException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for TagsLimitExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "TagsLimitExceededException")?;
        if let Some(inner_58) = &self.message {
            write!(f, ": {}", inner_58)?;
        }
        Ok(())
    }
}
impl std::error::Error for TagsLimitExceededException {}
/// See [`TagsLimitExceededException`](crate::error::TagsLimitExceededException)
pub mod tags_limit_exceeded_exception {
    /// A builder for [`TagsLimitExceededException`](crate::error::TagsLimitExceededException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Brief description of the exception returned by the request.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>Brief description of the exception returned by the request.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`TagsLimitExceededException`](crate::error::TagsLimitExceededException)
        pub fn build(self) -> crate::error::TagsLimitExceededException {
            crate::error::TagsLimitExceededException {
                message: self.message,
            }
        }
    }
}
impl TagsLimitExceededException {
    /// Creates a new builder-style object to manufacture [`TagsLimitExceededException`](crate::error::TagsLimitExceededException)
    pub fn builder() -> crate::error::tags_limit_exceeded_exception::Builder {
        crate::error::tags_limit_exceeded_exception::Builder::default()
    }
}
