// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
use std::fmt::Write;
/// See [`AddTagsInput`](crate::input::AddTagsInput)
pub mod add_tags_input {
    /// A builder for [`AddTagsInput`](crate::input::AddTagsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_id: std::option::Option<std::string::String>,
        pub(crate) tags_list: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>Specifies the ARN of the trail to which one or more tags will be added. The format of a trail ARN is:</p>
        /// <p>
        /// <code>arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail</code>
        /// </p>
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_id = Some(input.into());
            self
        }
        /// <p>Specifies the ARN of the trail to which one or more tags will be added. The format of a trail ARN is:</p>
        /// <p>
        /// <code>arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail</code>
        /// </p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_id = input;
            self
        }
        /// Appends an item to `tags_list`.
        ///
        /// To override the contents of this collection use [`set_tags_list`](Self::set_tags_list).
        ///
        /// <p>Contains a list of tags, up to a limit of 50</p>
        pub fn tags_list(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags_list.unwrap_or_default();
            v.push(input.into());
            self.tags_list = Some(v);
            self
        }
        /// <p>Contains a list of tags, up to a limit of 50</p>
        pub fn set_tags_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags_list = input;
            self
        }
        /// Consumes the builder and constructs a [`AddTagsInput`](crate::input::AddTagsInput)
        pub fn build(
            self,
        ) -> std::result::Result<crate::input::AddTagsInput, aws_smithy_http::operation::BuildError>
        {
            Ok(crate::input::AddTagsInput {
                resource_id: self.resource_id,
                tags_list: self.tags_list,
            })
        }
    }
}
#[doc(hidden)]
pub type AddTagsInputOperationOutputAlias = crate::operation::AddTags;
#[doc(hidden)]
pub type AddTagsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl AddTagsInput {
    /// Consumes the builder and constructs an Operation<[`AddTags`](crate::operation::AddTags)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::AddTags,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::AddTagsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::AddTagsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::AddTagsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "CloudTrail_20131101.AddTags",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_add_tags(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op =
            aws_smithy_http::operation::Operation::new(request, crate::operation::AddTags::new())
                .with_metadata(aws_smithy_http::operation::Metadata::new(
                    "AddTags",
                    "cloudtrail",
                ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`AddTagsInput`](crate::input::AddTagsInput)
    pub fn builder() -> crate::input::add_tags_input::Builder {
        crate::input::add_tags_input::Builder::default()
    }
}

/// See [`CreateTrailInput`](crate::input::CreateTrailInput)
pub mod create_trail_input {
    /// A builder for [`CreateTrailInput`](crate::input::CreateTrailInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) s3_bucket_name: std::option::Option<std::string::String>,
        pub(crate) s3_key_prefix: std::option::Option<std::string::String>,
        pub(crate) sns_topic_name: std::option::Option<std::string::String>,
        pub(crate) include_global_service_events: std::option::Option<bool>,
        pub(crate) is_multi_region_trail: std::option::Option<bool>,
        pub(crate) enable_log_file_validation: std::option::Option<bool>,
        pub(crate) cloud_watch_logs_log_group_arn: std::option::Option<std::string::String>,
        pub(crate) cloud_watch_logs_role_arn: std::option::Option<std::string::String>,
        pub(crate) kms_key_id: std::option::Option<std::string::String>,
        pub(crate) is_organization_trail: std::option::Option<bool>,
        pub(crate) tags_list: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>Specifies the name of the trail. The name must meet the following requirements:</p>
        /// <ul>
        /// <li>
        /// <p>Contain only ASCII letters (a-z, A-Z), numbers (0-9), periods (.), underscores (_), or dashes (-)</p>
        /// </li>
        /// <li>
        /// <p>Start with a letter or number, and end with a letter or number</p>
        /// </li>
        /// <li>
        /// <p>Be between 3 and 128 characters</p>
        /// </li>
        /// <li>
        /// <p>Have no adjacent periods, underscores or dashes. Names like <code>my-_namespace</code>
        /// and <code>my--namespace</code> are not valid.</p>
        /// </li>
        /// <li>
        /// <p>Not be in IP address format (for example, 192.168.5.4)</p>
        /// </li>
        /// </ul>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>Specifies the name of the trail. The name must meet the following requirements:</p>
        /// <ul>
        /// <li>
        /// <p>Contain only ASCII letters (a-z, A-Z), numbers (0-9), periods (.), underscores (_), or dashes (-)</p>
        /// </li>
        /// <li>
        /// <p>Start with a letter or number, and end with a letter or number</p>
        /// </li>
        /// <li>
        /// <p>Be between 3 and 128 characters</p>
        /// </li>
        /// <li>
        /// <p>Have no adjacent periods, underscores or dashes. Names like <code>my-_namespace</code>
        /// and <code>my--namespace</code> are not valid.</p>
        /// </li>
        /// <li>
        /// <p>Not be in IP address format (for example, 192.168.5.4)</p>
        /// </li>
        /// </ul>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>Specifies the name of the Amazon S3 bucket designated for publishing log files. See <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/create_trail_naming_policy.html">Amazon S3 Bucket Naming Requirements</a>.</p>
        pub fn s3_bucket_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.s3_bucket_name = Some(input.into());
            self
        }
        /// <p>Specifies the name of the Amazon S3 bucket designated for publishing log files. See <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/create_trail_naming_policy.html">Amazon S3 Bucket Naming Requirements</a>.</p>
        pub fn set_s3_bucket_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.s3_bucket_name = input;
            self
        }
        /// <p>Specifies the Amazon S3 key prefix that comes after the name of the bucket you have designated
        /// for log file delivery. For more information, see <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/cloudtrail-find-log-files.html">Finding Your CloudTrail Log Files</a>. The maximum length is 200 characters.</p>
        pub fn s3_key_prefix(mut self, input: impl Into<std::string::String>) -> Self {
            self.s3_key_prefix = Some(input.into());
            self
        }
        /// <p>Specifies the Amazon S3 key prefix that comes after the name of the bucket you have designated
        /// for log file delivery. For more information, see <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/cloudtrail-find-log-files.html">Finding Your CloudTrail Log Files</a>. The maximum length is 200 characters.</p>
        pub fn set_s3_key_prefix(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.s3_key_prefix = input;
            self
        }
        /// <p>Specifies the name of the Amazon SNS topic defined for notification of log file delivery. The maximum length is 256 characters.</p>
        pub fn sns_topic_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.sns_topic_name = Some(input.into());
            self
        }
        /// <p>Specifies the name of the Amazon SNS topic defined for notification of log file delivery. The maximum length is 256 characters.</p>
        pub fn set_sns_topic_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.sns_topic_name = input;
            self
        }
        /// <p>Specifies whether the trail is publishing events from global services such as IAM to the log files.</p>
        pub fn include_global_service_events(mut self, input: bool) -> Self {
            self.include_global_service_events = Some(input);
            self
        }
        /// <p>Specifies whether the trail is publishing events from global services such as IAM to the log files.</p>
        pub fn set_include_global_service_events(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.include_global_service_events = input;
            self
        }
        /// <p>Specifies whether the trail is created in the current region or in all regions. The default is false, which creates a trail only in the region where you are signed in. As a best practice, consider
        /// creating trails that log events in all regions.</p>
        pub fn is_multi_region_trail(mut self, input: bool) -> Self {
            self.is_multi_region_trail = Some(input);
            self
        }
        /// <p>Specifies whether the trail is created in the current region or in all regions. The default is false, which creates a trail only in the region where you are signed in. As a best practice, consider
        /// creating trails that log events in all regions.</p>
        pub fn set_is_multi_region_trail(mut self, input: std::option::Option<bool>) -> Self {
            self.is_multi_region_trail = input;
            self
        }
        /// <p>Specifies whether log file integrity validation is enabled. The default is false.</p>
        /// <note>
        /// <p>When you disable log file integrity validation, the chain of digest files is broken after one hour. CloudTrail does
        /// not create digest files for log files that were delivered during a period in which log file integrity validation was disabled.
        /// For example, if you enable log file integrity validation at noon on January 1, disable it at noon on January 2, and re-enable
        /// it at noon on January 10, digest files will not be created for the log files delivered from noon on January 2 to noon on
        /// January 10. The same applies whenever you stop CloudTrail logging or delete a trail.</p>
        /// </note>
        pub fn enable_log_file_validation(mut self, input: bool) -> Self {
            self.enable_log_file_validation = Some(input);
            self
        }
        /// <p>Specifies whether log file integrity validation is enabled. The default is false.</p>
        /// <note>
        /// <p>When you disable log file integrity validation, the chain of digest files is broken after one hour. CloudTrail does
        /// not create digest files for log files that were delivered during a period in which log file integrity validation was disabled.
        /// For example, if you enable log file integrity validation at noon on January 1, disable it at noon on January 2, and re-enable
        /// it at noon on January 10, digest files will not be created for the log files delivered from noon on January 2 to noon on
        /// January 10. The same applies whenever you stop CloudTrail logging or delete a trail.</p>
        /// </note>
        pub fn set_enable_log_file_validation(mut self, input: std::option::Option<bool>) -> Self {
            self.enable_log_file_validation = input;
            self
        }
        /// <p>Specifies a log group name using an Amazon Resource Name (ARN), a unique identifier that represents the log group
        /// to which CloudTrail logs will be delivered. Not required unless you specify <code>CloudWatchLogsRoleArn</code>.</p>
        pub fn cloud_watch_logs_log_group_arn(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.cloud_watch_logs_log_group_arn = Some(input.into());
            self
        }
        /// <p>Specifies a log group name using an Amazon Resource Name (ARN), a unique identifier that represents the log group
        /// to which CloudTrail logs will be delivered. Not required unless you specify <code>CloudWatchLogsRoleArn</code>.</p>
        pub fn set_cloud_watch_logs_log_group_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.cloud_watch_logs_log_group_arn = input;
            self
        }
        /// <p>Specifies the role for the CloudWatch Logs endpoint to assume to write to a user's log group.</p>
        pub fn cloud_watch_logs_role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.cloud_watch_logs_role_arn = Some(input.into());
            self
        }
        /// <p>Specifies the role for the CloudWatch Logs endpoint to assume to write to a user's log group.</p>
        pub fn set_cloud_watch_logs_role_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.cloud_watch_logs_role_arn = input;
            self
        }
        /// <p>Specifies the KMS key ID to use to encrypt the logs delivered by CloudTrail. The
        /// value can be an alias name prefixed by "alias/", a fully specified ARN to an alias, a fully
        /// specified ARN to a key, or a globally unique identifier.</p>
        /// <p>CloudTrail also supports KMS multi-Region keys. For more information about multi-Region keys,
        /// see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/multi-region-keys-overview.html">Using multi-Region keys</a> in the <i>Key Management Service Developer Guide</i>.</p>
        /// <p>Examples:</p>
        /// <ul>
        /// <li>
        /// <p>alias/MyAliasName</p>
        /// </li>
        /// <li>
        /// <p>arn:aws:kms:us-east-2:123456789012:alias/MyAliasName</p>
        /// </li>
        /// <li>
        /// <p>arn:aws:kms:us-east-2:123456789012:key/12345678-1234-1234-1234-123456789012</p>
        /// </li>
        /// <li>
        /// <p>12345678-1234-1234-1234-123456789012</p>
        /// </li>
        /// </ul>
        pub fn kms_key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.kms_key_id = Some(input.into());
            self
        }
        /// <p>Specifies the KMS key ID to use to encrypt the logs delivered by CloudTrail. The
        /// value can be an alias name prefixed by "alias/", a fully specified ARN to an alias, a fully
        /// specified ARN to a key, or a globally unique identifier.</p>
        /// <p>CloudTrail also supports KMS multi-Region keys. For more information about multi-Region keys,
        /// see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/multi-region-keys-overview.html">Using multi-Region keys</a> in the <i>Key Management Service Developer Guide</i>.</p>
        /// <p>Examples:</p>
        /// <ul>
        /// <li>
        /// <p>alias/MyAliasName</p>
        /// </li>
        /// <li>
        /// <p>arn:aws:kms:us-east-2:123456789012:alias/MyAliasName</p>
        /// </li>
        /// <li>
        /// <p>arn:aws:kms:us-east-2:123456789012:key/12345678-1234-1234-1234-123456789012</p>
        /// </li>
        /// <li>
        /// <p>12345678-1234-1234-1234-123456789012</p>
        /// </li>
        /// </ul>
        pub fn set_kms_key_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.kms_key_id = input;
            self
        }
        /// <p>Specifies whether the trail is created for all accounts in an organization in Organizations, or only for the current Amazon Web Services account.
        /// The default is false, and cannot be true unless the call is made on behalf of an Amazon Web Services account that is the management account for an organization in
        /// Organizations.</p>
        pub fn is_organization_trail(mut self, input: bool) -> Self {
            self.is_organization_trail = Some(input);
            self
        }
        /// <p>Specifies whether the trail is created for all accounts in an organization in Organizations, or only for the current Amazon Web Services account.
        /// The default is false, and cannot be true unless the call is made on behalf of an Amazon Web Services account that is the management account for an organization in
        /// Organizations.</p>
        pub fn set_is_organization_trail(mut self, input: std::option::Option<bool>) -> Self {
            self.is_organization_trail = input;
            self
        }
        /// Appends an item to `tags_list`.
        ///
        /// To override the contents of this collection use [`set_tags_list`](Self::set_tags_list).
        ///
        /// <p>A list of tags.</p>
        pub fn tags_list(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags_list.unwrap_or_default();
            v.push(input.into());
            self.tags_list = Some(v);
            self
        }
        /// <p>A list of tags.</p>
        pub fn set_tags_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags_list = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateTrailInput`](crate::input::CreateTrailInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateTrailInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateTrailInput {
                name: self.name,
                s3_bucket_name: self.s3_bucket_name,
                s3_key_prefix: self.s3_key_prefix,
                sns_topic_name: self.sns_topic_name,
                include_global_service_events: self.include_global_service_events,
                is_multi_region_trail: self.is_multi_region_trail,
                enable_log_file_validation: self.enable_log_file_validation,
                cloud_watch_logs_log_group_arn: self.cloud_watch_logs_log_group_arn,
                cloud_watch_logs_role_arn: self.cloud_watch_logs_role_arn,
                kms_key_id: self.kms_key_id,
                is_organization_trail: self.is_organization_trail,
                tags_list: self.tags_list,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateTrailInputOperationOutputAlias = crate::operation::CreateTrail;
#[doc(hidden)]
pub type CreateTrailInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateTrailInput {
    /// Consumes the builder and constructs an Operation<[`CreateTrail`](crate::operation::CreateTrail)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateTrail,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateTrailInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateTrailInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateTrailInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "CloudTrail_20131101.CreateTrail",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_create_trail(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateTrail::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateTrail",
            "cloudtrail",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateTrailInput`](crate::input::CreateTrailInput)
    pub fn builder() -> crate::input::create_trail_input::Builder {
        crate::input::create_trail_input::Builder::default()
    }
}

/// See [`DeleteTrailInput`](crate::input::DeleteTrailInput)
pub mod delete_trail_input {
    /// A builder for [`DeleteTrailInput`](crate::input::DeleteTrailInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Specifies the name or the CloudTrail ARN of the trail to be deleted. The following is the format of a
        /// trail ARN.
        /// <code>arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail</code>
        /// </p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>Specifies the name or the CloudTrail ARN of the trail to be deleted. The following is the format of a
        /// trail ARN.
        /// <code>arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail</code>
        /// </p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteTrailInput`](crate::input::DeleteTrailInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteTrailInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteTrailInput { name: self.name })
        }
    }
}
#[doc(hidden)]
pub type DeleteTrailInputOperationOutputAlias = crate::operation::DeleteTrail;
#[doc(hidden)]
pub type DeleteTrailInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteTrailInput {
    /// Consumes the builder and constructs an Operation<[`DeleteTrail`](crate::operation::DeleteTrail)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteTrail,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteTrailInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteTrailInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteTrailInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "CloudTrail_20131101.DeleteTrail",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_delete_trail(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteTrail::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteTrail",
            "cloudtrail",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteTrailInput`](crate::input::DeleteTrailInput)
    pub fn builder() -> crate::input::delete_trail_input::Builder {
        crate::input::delete_trail_input::Builder::default()
    }
}

/// See [`DescribeTrailsInput`](crate::input::DescribeTrailsInput)
pub mod describe_trails_input {
    /// A builder for [`DescribeTrailsInput`](crate::input::DescribeTrailsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) trail_name_list: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) include_shadow_trails: std::option::Option<bool>,
    }
    impl Builder {
        /// Appends an item to `trail_name_list`.
        ///
        /// To override the contents of this collection use [`set_trail_name_list`](Self::set_trail_name_list).
        ///
        /// <p>Specifies a list of trail names, trail ARNs, or both, of the trails to describe. The format of a trail ARN is:</p>
        /// <p>
        /// <code>arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail</code>
        /// </p>
        ///
        /// <p>If an empty list is specified, information for the trail in the current region is returned.</p>
        /// <ul>
        /// <li>
        /// <p>If an empty list is specified and <code>IncludeShadowTrails</code> is false, then
        /// information for all trails in the current region is returned.</p>
        /// </li>
        /// <li>
        /// <p>If an empty list is specified and IncludeShadowTrails is null or true, then information for all trails in the current region and any associated shadow trails in other regions is returned.</p>
        /// </li>
        /// </ul>
        /// <note>
        /// <p>If one or more trail names are specified, information is returned only if the names match the names of trails belonging only to the current region. To return information about a trail in another region, you must specify its trail ARN.</p>
        /// </note>
        pub fn trail_name_list(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.trail_name_list.unwrap_or_default();
            v.push(input.into());
            self.trail_name_list = Some(v);
            self
        }
        /// <p>Specifies a list of trail names, trail ARNs, or both, of the trails to describe. The format of a trail ARN is:</p>
        /// <p>
        /// <code>arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail</code>
        /// </p>
        ///
        /// <p>If an empty list is specified, information for the trail in the current region is returned.</p>
        /// <ul>
        /// <li>
        /// <p>If an empty list is specified and <code>IncludeShadowTrails</code> is false, then
        /// information for all trails in the current region is returned.</p>
        /// </li>
        /// <li>
        /// <p>If an empty list is specified and IncludeShadowTrails is null or true, then information for all trails in the current region and any associated shadow trails in other regions is returned.</p>
        /// </li>
        /// </ul>
        /// <note>
        /// <p>If one or more trail names are specified, information is returned only if the names match the names of trails belonging only to the current region. To return information about a trail in another region, you must specify its trail ARN.</p>
        /// </note>
        pub fn set_trail_name_list(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.trail_name_list = input;
            self
        }
        /// <p>Specifies whether to include shadow trails in the response. A shadow trail is the replication in a region of a trail that was created in a different region,
        /// or in the case of an organization trail, the replication of an organization trail in member accounts. If you do not include shadow trails, organization trails in a member account
        /// and region replication trails will not be returned. The default is true.</p>
        pub fn include_shadow_trails(mut self, input: bool) -> Self {
            self.include_shadow_trails = Some(input);
            self
        }
        /// <p>Specifies whether to include shadow trails in the response. A shadow trail is the replication in a region of a trail that was created in a different region,
        /// or in the case of an organization trail, the replication of an organization trail in member accounts. If you do not include shadow trails, organization trails in a member account
        /// and region replication trails will not be returned. The default is true.</p>
        pub fn set_include_shadow_trails(mut self, input: std::option::Option<bool>) -> Self {
            self.include_shadow_trails = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeTrailsInput`](crate::input::DescribeTrailsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeTrailsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeTrailsInput {
                trail_name_list: self.trail_name_list,
                include_shadow_trails: self.include_shadow_trails,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeTrailsInputOperationOutputAlias = crate::operation::DescribeTrails;
#[doc(hidden)]
pub type DescribeTrailsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeTrailsInput {
    /// Consumes the builder and constructs an Operation<[`DescribeTrails`](crate::operation::DescribeTrails)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeTrails,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeTrailsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeTrailsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeTrailsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "CloudTrail_20131101.DescribeTrails",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_trails(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeTrails::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeTrails",
            "cloudtrail",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeTrailsInput`](crate::input::DescribeTrailsInput)
    pub fn builder() -> crate::input::describe_trails_input::Builder {
        crate::input::describe_trails_input::Builder::default()
    }
}

/// See [`GetEventSelectorsInput`](crate::input::GetEventSelectorsInput)
pub mod get_event_selectors_input {
    /// A builder for [`GetEventSelectorsInput`](crate::input::GetEventSelectorsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) trail_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Specifies the name of the trail or trail ARN. If you specify a trail name, the
        /// string must meet the following requirements:</p>
        /// <ul>
        /// <li>
        /// <p>Contain only ASCII letters (a-z, A-Z), numbers (0-9), periods (.), underscores (_), or dashes (-)</p>
        /// </li>
        /// <li>
        /// <p>Start with a letter or number, and end with a letter or number</p>
        /// </li>
        /// <li>
        /// <p>Be between 3 and 128 characters</p>
        /// </li>
        /// <li>
        /// <p>Have no adjacent periods, underscores or dashes. Names like <code>my-_namespace</code>
        /// and <code>my--namespace</code> are not valid.</p>
        /// </li>
        /// <li>
        /// <p>Not be in IP address format (for example, 192.168.5.4)</p>
        /// </li>
        /// </ul>
        /// <p>If you specify a trail ARN, it must be in the format:</p>
        /// <p>
        /// <code>arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail</code>
        /// </p>
        pub fn trail_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.trail_name = Some(input.into());
            self
        }
        /// <p>Specifies the name of the trail or trail ARN. If you specify a trail name, the
        /// string must meet the following requirements:</p>
        /// <ul>
        /// <li>
        /// <p>Contain only ASCII letters (a-z, A-Z), numbers (0-9), periods (.), underscores (_), or dashes (-)</p>
        /// </li>
        /// <li>
        /// <p>Start with a letter or number, and end with a letter or number</p>
        /// </li>
        /// <li>
        /// <p>Be between 3 and 128 characters</p>
        /// </li>
        /// <li>
        /// <p>Have no adjacent periods, underscores or dashes. Names like <code>my-_namespace</code>
        /// and <code>my--namespace</code> are not valid.</p>
        /// </li>
        /// <li>
        /// <p>Not be in IP address format (for example, 192.168.5.4)</p>
        /// </li>
        /// </ul>
        /// <p>If you specify a trail ARN, it must be in the format:</p>
        /// <p>
        /// <code>arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail</code>
        /// </p>
        pub fn set_trail_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.trail_name = input;
            self
        }
        /// Consumes the builder and constructs a [`GetEventSelectorsInput`](crate::input::GetEventSelectorsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetEventSelectorsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetEventSelectorsInput {
                trail_name: self.trail_name,
            })
        }
    }
}
#[doc(hidden)]
pub type GetEventSelectorsInputOperationOutputAlias = crate::operation::GetEventSelectors;
#[doc(hidden)]
pub type GetEventSelectorsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetEventSelectorsInput {
    /// Consumes the builder and constructs an Operation<[`GetEventSelectors`](crate::operation::GetEventSelectors)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetEventSelectors,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetEventSelectorsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetEventSelectorsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetEventSelectorsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "CloudTrail_20131101.GetEventSelectors",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_get_event_selectors(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetEventSelectors::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetEventSelectors",
            "cloudtrail",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetEventSelectorsInput`](crate::input::GetEventSelectorsInput)
    pub fn builder() -> crate::input::get_event_selectors_input::Builder {
        crate::input::get_event_selectors_input::Builder::default()
    }
}

/// See [`GetInsightSelectorsInput`](crate::input::GetInsightSelectorsInput)
pub mod get_insight_selectors_input {
    /// A builder for [`GetInsightSelectorsInput`](crate::input::GetInsightSelectorsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) trail_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Specifies the name of the trail or trail ARN. If you specify a trail name, the
        /// string must meet the following requirements:</p>
        /// <ul>
        /// <li>
        /// <p>Contain only ASCII letters (a-z, A-Z), numbers (0-9), periods (.), underscores (_), or dashes (-)</p>
        /// </li>
        /// <li>
        /// <p>Start with a letter or number, and end with a letter or number</p>
        /// </li>
        /// <li>
        /// <p>Be between 3 and 128 characters</p>
        /// </li>
        /// <li>
        /// <p>Have no adjacent periods, underscores or dashes. Names like <code>my-_namespace</code>
        /// and <code>my--namespace</code> are not valid.</p>
        /// </li>
        /// <li>
        /// <p>Not be in IP address format (for example, 192.168.5.4)</p>
        /// </li>
        /// </ul>
        /// <p>If you specify a trail ARN, it must be in the format:</p>
        /// <p>
        /// <code>arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail</code>
        /// </p>
        pub fn trail_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.trail_name = Some(input.into());
            self
        }
        /// <p>Specifies the name of the trail or trail ARN. If you specify a trail name, the
        /// string must meet the following requirements:</p>
        /// <ul>
        /// <li>
        /// <p>Contain only ASCII letters (a-z, A-Z), numbers (0-9), periods (.), underscores (_), or dashes (-)</p>
        /// </li>
        /// <li>
        /// <p>Start with a letter or number, and end with a letter or number</p>
        /// </li>
        /// <li>
        /// <p>Be between 3 and 128 characters</p>
        /// </li>
        /// <li>
        /// <p>Have no adjacent periods, underscores or dashes. Names like <code>my-_namespace</code>
        /// and <code>my--namespace</code> are not valid.</p>
        /// </li>
        /// <li>
        /// <p>Not be in IP address format (for example, 192.168.5.4)</p>
        /// </li>
        /// </ul>
        /// <p>If you specify a trail ARN, it must be in the format:</p>
        /// <p>
        /// <code>arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail</code>
        /// </p>
        pub fn set_trail_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.trail_name = input;
            self
        }
        /// Consumes the builder and constructs a [`GetInsightSelectorsInput`](crate::input::GetInsightSelectorsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetInsightSelectorsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetInsightSelectorsInput {
                trail_name: self.trail_name,
            })
        }
    }
}
#[doc(hidden)]
pub type GetInsightSelectorsInputOperationOutputAlias = crate::operation::GetInsightSelectors;
#[doc(hidden)]
pub type GetInsightSelectorsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetInsightSelectorsInput {
    /// Consumes the builder and constructs an Operation<[`GetInsightSelectors`](crate::operation::GetInsightSelectors)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetInsightSelectors,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetInsightSelectorsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetInsightSelectorsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetInsightSelectorsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "CloudTrail_20131101.GetInsightSelectors",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_get_insight_selectors(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetInsightSelectors::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetInsightSelectors",
            "cloudtrail",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetInsightSelectorsInput`](crate::input::GetInsightSelectorsInput)
    pub fn builder() -> crate::input::get_insight_selectors_input::Builder {
        crate::input::get_insight_selectors_input::Builder::default()
    }
}

/// See [`GetTrailInput`](crate::input::GetTrailInput)
pub mod get_trail_input {
    /// A builder for [`GetTrailInput`](crate::input::GetTrailInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name or the Amazon Resource Name (ARN) of the trail for which you want to retrieve settings information.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name or the Amazon Resource Name (ARN) of the trail for which you want to retrieve settings information.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Consumes the builder and constructs a [`GetTrailInput`](crate::input::GetTrailInput)
        pub fn build(
            self,
        ) -> std::result::Result<crate::input::GetTrailInput, aws_smithy_http::operation::BuildError>
        {
            Ok(crate::input::GetTrailInput { name: self.name })
        }
    }
}
#[doc(hidden)]
pub type GetTrailInputOperationOutputAlias = crate::operation::GetTrail;
#[doc(hidden)]
pub type GetTrailInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetTrailInput {
    /// Consumes the builder and constructs an Operation<[`GetTrail`](crate::operation::GetTrail)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetTrail,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetTrailInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetTrailInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetTrailInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "CloudTrail_20131101.GetTrail",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_get_trail(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op =
            aws_smithy_http::operation::Operation::new(request, crate::operation::GetTrail::new())
                .with_metadata(aws_smithy_http::operation::Metadata::new(
                    "GetTrail",
                    "cloudtrail",
                ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetTrailInput`](crate::input::GetTrailInput)
    pub fn builder() -> crate::input::get_trail_input::Builder {
        crate::input::get_trail_input::Builder::default()
    }
}

/// See [`GetTrailStatusInput`](crate::input::GetTrailStatusInput)
pub mod get_trail_status_input {
    /// A builder for [`GetTrailStatusInput`](crate::input::GetTrailStatusInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Specifies the name or the CloudTrail ARN of the trail for which you are requesting status. To get the status of a
        /// shadow trail (a replication of the trail in another region), you must specify its ARN. The following is the format of a trail ARN.</p>
        /// <p>
        /// <code>arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail</code>
        /// </p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>Specifies the name or the CloudTrail ARN of the trail for which you are requesting status. To get the status of a
        /// shadow trail (a replication of the trail in another region), you must specify its ARN. The following is the format of a trail ARN.</p>
        /// <p>
        /// <code>arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail</code>
        /// </p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Consumes the builder and constructs a [`GetTrailStatusInput`](crate::input::GetTrailStatusInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetTrailStatusInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetTrailStatusInput { name: self.name })
        }
    }
}
#[doc(hidden)]
pub type GetTrailStatusInputOperationOutputAlias = crate::operation::GetTrailStatus;
#[doc(hidden)]
pub type GetTrailStatusInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetTrailStatusInput {
    /// Consumes the builder and constructs an Operation<[`GetTrailStatus`](crate::operation::GetTrailStatus)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetTrailStatus,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetTrailStatusInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetTrailStatusInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetTrailStatusInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "CloudTrail_20131101.GetTrailStatus",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_get_trail_status(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetTrailStatus::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetTrailStatus",
            "cloudtrail",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetTrailStatusInput`](crate::input::GetTrailStatusInput)
    pub fn builder() -> crate::input::get_trail_status_input::Builder {
        crate::input::get_trail_status_input::Builder::default()
    }
}

/// See [`ListPublicKeysInput`](crate::input::ListPublicKeysInput)
pub mod list_public_keys_input {
    /// A builder for [`ListPublicKeysInput`](crate::input::ListPublicKeysInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) start_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) end_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Optionally specifies, in UTC, the start of the time range to look up public keys for CloudTrail digest files.
        /// If not specified, the current time is used, and the current public key is returned.</p>
        pub fn start_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.start_time = Some(input);
            self
        }
        /// <p>Optionally specifies, in UTC, the start of the time range to look up public keys for CloudTrail digest files.
        /// If not specified, the current time is used, and the current public key is returned.</p>
        pub fn set_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.start_time = input;
            self
        }
        /// <p>Optionally specifies, in UTC, the end of the time range to look up public keys for CloudTrail digest files. If not
        /// specified, the current time is used.</p>
        pub fn end_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.end_time = Some(input);
            self
        }
        /// <p>Optionally specifies, in UTC, the end of the time range to look up public keys for CloudTrail digest files. If not
        /// specified, the current time is used.</p>
        pub fn set_end_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.end_time = input;
            self
        }
        /// <p>Reserved for future use.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>Reserved for future use.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListPublicKeysInput`](crate::input::ListPublicKeysInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListPublicKeysInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListPublicKeysInput {
                start_time: self.start_time,
                end_time: self.end_time,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListPublicKeysInputOperationOutputAlias = crate::operation::ListPublicKeys;
#[doc(hidden)]
pub type ListPublicKeysInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListPublicKeysInput {
    /// Consumes the builder and constructs an Operation<[`ListPublicKeys`](crate::operation::ListPublicKeys)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListPublicKeys,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListPublicKeysInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListPublicKeysInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListPublicKeysInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "CloudTrail_20131101.ListPublicKeys",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_public_keys(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListPublicKeys::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListPublicKeys",
            "cloudtrail",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListPublicKeysInput`](crate::input::ListPublicKeysInput)
    pub fn builder() -> crate::input::list_public_keys_input::Builder {
        crate::input::list_public_keys_input::Builder::default()
    }
}

/// See [`ListTagsInput`](crate::input::ListTagsInput)
pub mod list_tags_input {
    /// A builder for [`ListTagsInput`](crate::input::ListTagsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_id_list: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `resource_id_list`.
        ///
        /// To override the contents of this collection use [`set_resource_id_list`](Self::set_resource_id_list).
        ///
        /// <p>Specifies a list of trail ARNs whose tags will be listed. The list has a limit of 20 ARNs. The following is the format of
        /// a trail ARN.</p>
        /// <p>
        /// <code>arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail</code>
        /// </p>
        pub fn resource_id_list(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.resource_id_list.unwrap_or_default();
            v.push(input.into());
            self.resource_id_list = Some(v);
            self
        }
        /// <p>Specifies a list of trail ARNs whose tags will be listed. The list has a limit of 20 ARNs. The following is the format of
        /// a trail ARN.</p>
        /// <p>
        /// <code>arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail</code>
        /// </p>
        pub fn set_resource_id_list(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.resource_id_list = input;
            self
        }
        /// <p>Reserved for future use.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>Reserved for future use.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTagsInput`](crate::input::ListTagsInput)
        pub fn build(
            self,
        ) -> std::result::Result<crate::input::ListTagsInput, aws_smithy_http::operation::BuildError>
        {
            Ok(crate::input::ListTagsInput {
                resource_id_list: self.resource_id_list,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListTagsInputOperationOutputAlias = crate::operation::ListTags;
#[doc(hidden)]
pub type ListTagsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListTagsInput {
    /// Consumes the builder and constructs an Operation<[`ListTags`](crate::operation::ListTags)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListTags,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListTagsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListTagsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListTagsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "CloudTrail_20131101.ListTags",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_list_tags(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op =
            aws_smithy_http::operation::Operation::new(request, crate::operation::ListTags::new())
                .with_metadata(aws_smithy_http::operation::Metadata::new(
                    "ListTags",
                    "cloudtrail",
                ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListTagsInput`](crate::input::ListTagsInput)
    pub fn builder() -> crate::input::list_tags_input::Builder {
        crate::input::list_tags_input::Builder::default()
    }
}

/// See [`ListTrailsInput`](crate::input::ListTrailsInput)
pub mod list_trails_input {
    /// A builder for [`ListTrailsInput`](crate::input::ListTrailsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The token to use to get the next page of results after a previous API call. This token must be passed
        /// in with the same parameters that were specified in the the original call. For example, if the original
        /// call specified an AttributeKey of 'Username' with a value of 'root', the call with NextToken should
        /// include those same parameters.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token to use to get the next page of results after a previous API call. This token must be passed
        /// in with the same parameters that were specified in the the original call. For example, if the original
        /// call specified an AttributeKey of 'Username' with a value of 'root', the call with NextToken should
        /// include those same parameters.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTrailsInput`](crate::input::ListTrailsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListTrailsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListTrailsInput {
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListTrailsInputOperationOutputAlias = crate::operation::ListTrails;
#[doc(hidden)]
pub type ListTrailsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListTrailsInput {
    /// Consumes the builder and constructs an Operation<[`ListTrails`](crate::operation::ListTrails)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListTrails,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListTrailsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListTrailsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListTrailsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "CloudTrail_20131101.ListTrails",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_list_trails(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListTrails::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListTrails",
            "cloudtrail",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListTrailsInput`](crate::input::ListTrailsInput)
    pub fn builder() -> crate::input::list_trails_input::Builder {
        crate::input::list_trails_input::Builder::default()
    }
}

/// See [`LookupEventsInput`](crate::input::LookupEventsInput)
pub mod lookup_events_input {
    /// A builder for [`LookupEventsInput`](crate::input::LookupEventsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) lookup_attributes:
            std::option::Option<std::vec::Vec<crate::model::LookupAttribute>>,
        pub(crate) start_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) end_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) event_category: std::option::Option<crate::model::EventCategory>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `lookup_attributes`.
        ///
        /// To override the contents of this collection use [`set_lookup_attributes`](Self::set_lookup_attributes).
        ///
        /// <p>Contains a list of lookup attributes. Currently the list can contain only one item.</p>
        pub fn lookup_attributes(
            mut self,
            input: impl Into<crate::model::LookupAttribute>,
        ) -> Self {
            let mut v = self.lookup_attributes.unwrap_or_default();
            v.push(input.into());
            self.lookup_attributes = Some(v);
            self
        }
        /// <p>Contains a list of lookup attributes. Currently the list can contain only one item.</p>
        pub fn set_lookup_attributes(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::LookupAttribute>>,
        ) -> Self {
            self.lookup_attributes = input;
            self
        }
        /// <p>Specifies that only events that occur after or at the specified time are returned. If the specified start time is after the specified end time, an error is returned.</p>
        pub fn start_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.start_time = Some(input);
            self
        }
        /// <p>Specifies that only events that occur after or at the specified time are returned. If the specified start time is after the specified end time, an error is returned.</p>
        pub fn set_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.start_time = input;
            self
        }
        /// <p>Specifies that only events that occur before or at the specified time are returned. If the specified end time is before the specified start time, an error is returned.</p>
        pub fn end_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.end_time = Some(input);
            self
        }
        /// <p>Specifies that only events that occur before or at the specified time are returned. If the specified end time is before the specified start time, an error is returned.</p>
        pub fn set_end_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.end_time = input;
            self
        }
        /// <p>Specifies the event category. If you do not specify an event category, events of the category are not returned in the response. For example,
        /// if you do not specify <code>insight</code> as the value of <code>EventCategory</code>, no Insights events are returned.</p>
        pub fn event_category(mut self, input: crate::model::EventCategory) -> Self {
            self.event_category = Some(input);
            self
        }
        /// <p>Specifies the event category. If you do not specify an event category, events of the category are not returned in the response. For example,
        /// if you do not specify <code>insight</code> as the value of <code>EventCategory</code>, no Insights events are returned.</p>
        pub fn set_event_category(
            mut self,
            input: std::option::Option<crate::model::EventCategory>,
        ) -> Self {
            self.event_category = input;
            self
        }
        /// <p>The number of events to return. Possible values are 1 through 50. The default is 50.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The number of events to return. Possible values are 1 through 50. The default is 50.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>The token to use to get the next page of results after a previous API call. This token must be passed in with the same parameters that were specified in the the original call.
        /// For example, if the original call specified an AttributeKey of 'Username' with a value of 'root', the call with NextToken should include those same parameters.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token to use to get the next page of results after a previous API call. This token must be passed in with the same parameters that were specified in the the original call.
        /// For example, if the original call specified an AttributeKey of 'Username' with a value of 'root', the call with NextToken should include those same parameters.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`LookupEventsInput`](crate::input::LookupEventsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::LookupEventsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::LookupEventsInput {
                lookup_attributes: self.lookup_attributes,
                start_time: self.start_time,
                end_time: self.end_time,
                event_category: self.event_category,
                max_results: self.max_results,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type LookupEventsInputOperationOutputAlias = crate::operation::LookupEvents;
#[doc(hidden)]
pub type LookupEventsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl LookupEventsInput {
    /// Consumes the builder and constructs an Operation<[`LookupEvents`](crate::operation::LookupEvents)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::LookupEvents,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::LookupEventsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::LookupEventsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::LookupEventsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "CloudTrail_20131101.LookupEvents",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_lookup_events(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::LookupEvents::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "LookupEvents",
            "cloudtrail",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`LookupEventsInput`](crate::input::LookupEventsInput)
    pub fn builder() -> crate::input::lookup_events_input::Builder {
        crate::input::lookup_events_input::Builder::default()
    }
}

/// See [`PutEventSelectorsInput`](crate::input::PutEventSelectorsInput)
pub mod put_event_selectors_input {
    /// A builder for [`PutEventSelectorsInput`](crate::input::PutEventSelectorsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) trail_name: std::option::Option<std::string::String>,
        pub(crate) event_selectors: std::option::Option<std::vec::Vec<crate::model::EventSelector>>,
        pub(crate) advanced_event_selectors:
            std::option::Option<std::vec::Vec<crate::model::AdvancedEventSelector>>,
    }
    impl Builder {
        /// <p>Specifies the name of the trail or trail ARN. If you specify a trail name, the
        /// string must meet the following requirements:</p>
        /// <ul>
        /// <li>
        /// <p>Contain only ASCII letters (a-z, A-Z), numbers (0-9), periods (.), underscores (_), or dashes (-)</p>
        /// </li>
        /// <li>
        /// <p>Start with a letter or number, and end with a letter or number</p>
        /// </li>
        /// <li>
        /// <p>Be between 3 and 128 characters</p>
        /// </li>
        /// <li>
        /// <p>Have no adjacent periods, underscores or dashes. Names like <code>my-_namespace</code>
        /// and <code>my--namespace</code> are not valid.</p>
        /// </li>
        /// <li>
        /// <p>Not be in IP address format (for example, 192.168.5.4)</p>
        /// </li>
        /// </ul>
        /// <p>If you specify a trail ARN, it must be in the following format.</p>
        /// <p>
        /// <code>arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail</code>
        /// </p>
        pub fn trail_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.trail_name = Some(input.into());
            self
        }
        /// <p>Specifies the name of the trail or trail ARN. If you specify a trail name, the
        /// string must meet the following requirements:</p>
        /// <ul>
        /// <li>
        /// <p>Contain only ASCII letters (a-z, A-Z), numbers (0-9), periods (.), underscores (_), or dashes (-)</p>
        /// </li>
        /// <li>
        /// <p>Start with a letter or number, and end with a letter or number</p>
        /// </li>
        /// <li>
        /// <p>Be between 3 and 128 characters</p>
        /// </li>
        /// <li>
        /// <p>Have no adjacent periods, underscores or dashes. Names like <code>my-_namespace</code>
        /// and <code>my--namespace</code> are not valid.</p>
        /// </li>
        /// <li>
        /// <p>Not be in IP address format (for example, 192.168.5.4)</p>
        /// </li>
        /// </ul>
        /// <p>If you specify a trail ARN, it must be in the following format.</p>
        /// <p>
        /// <code>arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail</code>
        /// </p>
        pub fn set_trail_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.trail_name = input;
            self
        }
        /// Appends an item to `event_selectors`.
        ///
        /// To override the contents of this collection use [`set_event_selectors`](Self::set_event_selectors).
        ///
        /// <p>Specifies the settings for your event selectors. You can configure up to five event selectors for a trail.
        /// You can use either <code>EventSelectors</code> or <code>AdvancedEventSelectors</code> in a <code>PutEventSelectors</code> request, but not both.
        /// If you apply <code>EventSelectors</code> to a trail, any existing <code>AdvancedEventSelectors</code> are overwritten.</p>
        pub fn event_selectors(mut self, input: impl Into<crate::model::EventSelector>) -> Self {
            let mut v = self.event_selectors.unwrap_or_default();
            v.push(input.into());
            self.event_selectors = Some(v);
            self
        }
        /// <p>Specifies the settings for your event selectors. You can configure up to five event selectors for a trail.
        /// You can use either <code>EventSelectors</code> or <code>AdvancedEventSelectors</code> in a <code>PutEventSelectors</code> request, but not both.
        /// If you apply <code>EventSelectors</code> to a trail, any existing <code>AdvancedEventSelectors</code> are overwritten.</p>
        pub fn set_event_selectors(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::EventSelector>>,
        ) -> Self {
            self.event_selectors = input;
            self
        }
        /// Appends an item to `advanced_event_selectors`.
        ///
        /// To override the contents of this collection use [`set_advanced_event_selectors`](Self::set_advanced_event_selectors).
        ///
        /// <p>
        /// Specifies the settings for advanced event selectors. You can add advanced event selectors, and conditions for your advanced
        /// event selectors, up to a maximum of 500 values for all conditions and selectors on a trail.
        /// You can use either <code>AdvancedEventSelectors</code> or <code>EventSelectors</code>, but not both. If you apply <code>AdvancedEventSelectors</code>
        /// to a trail, any existing <code>EventSelectors</code> are overwritten. For more information about
        /// advanced event selectors, see
        /// <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/logging-data-events-with-cloudtrail.html">Logging
        /// data events for trails</a> in the <i>CloudTrail User Guide</i>.
        /// </p>
        pub fn advanced_event_selectors(
            mut self,
            input: impl Into<crate::model::AdvancedEventSelector>,
        ) -> Self {
            let mut v = self.advanced_event_selectors.unwrap_or_default();
            v.push(input.into());
            self.advanced_event_selectors = Some(v);
            self
        }
        /// <p>
        /// Specifies the settings for advanced event selectors. You can add advanced event selectors, and conditions for your advanced
        /// event selectors, up to a maximum of 500 values for all conditions and selectors on a trail.
        /// You can use either <code>AdvancedEventSelectors</code> or <code>EventSelectors</code>, but not both. If you apply <code>AdvancedEventSelectors</code>
        /// to a trail, any existing <code>EventSelectors</code> are overwritten. For more information about
        /// advanced event selectors, see
        /// <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/logging-data-events-with-cloudtrail.html">Logging
        /// data events for trails</a> in the <i>CloudTrail User Guide</i>.
        /// </p>
        pub fn set_advanced_event_selectors(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AdvancedEventSelector>>,
        ) -> Self {
            self.advanced_event_selectors = input;
            self
        }
        /// Consumes the builder and constructs a [`PutEventSelectorsInput`](crate::input::PutEventSelectorsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::PutEventSelectorsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::PutEventSelectorsInput {
                trail_name: self.trail_name,
                event_selectors: self.event_selectors,
                advanced_event_selectors: self.advanced_event_selectors,
            })
        }
    }
}
#[doc(hidden)]
pub type PutEventSelectorsInputOperationOutputAlias = crate::operation::PutEventSelectors;
#[doc(hidden)]
pub type PutEventSelectorsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl PutEventSelectorsInput {
    /// Consumes the builder and constructs an Operation<[`PutEventSelectors`](crate::operation::PutEventSelectors)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::PutEventSelectors,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::PutEventSelectorsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::PutEventSelectorsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::PutEventSelectorsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "CloudTrail_20131101.PutEventSelectors",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_put_event_selectors(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::PutEventSelectors::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "PutEventSelectors",
            "cloudtrail",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`PutEventSelectorsInput`](crate::input::PutEventSelectorsInput)
    pub fn builder() -> crate::input::put_event_selectors_input::Builder {
        crate::input::put_event_selectors_input::Builder::default()
    }
}

/// See [`PutInsightSelectorsInput`](crate::input::PutInsightSelectorsInput)
pub mod put_insight_selectors_input {
    /// A builder for [`PutInsightSelectorsInput`](crate::input::PutInsightSelectorsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) trail_name: std::option::Option<std::string::String>,
        pub(crate) insight_selectors:
            std::option::Option<std::vec::Vec<crate::model::InsightSelector>>,
    }
    impl Builder {
        /// <p>The name of the CloudTrail trail for which you want to change or add Insights selectors.</p>
        pub fn trail_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.trail_name = Some(input.into());
            self
        }
        /// <p>The name of the CloudTrail trail for which you want to change or add Insights selectors.</p>
        pub fn set_trail_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.trail_name = input;
            self
        }
        /// Appends an item to `insight_selectors`.
        ///
        /// To override the contents of this collection use [`set_insight_selectors`](Self::set_insight_selectors).
        ///
        /// <p>A JSON string that contains the Insights types that you want to log on a trail. The valid Insights type in this release is <code>ApiCallRateInsight</code>.</p>
        pub fn insight_selectors(
            mut self,
            input: impl Into<crate::model::InsightSelector>,
        ) -> Self {
            let mut v = self.insight_selectors.unwrap_or_default();
            v.push(input.into());
            self.insight_selectors = Some(v);
            self
        }
        /// <p>A JSON string that contains the Insights types that you want to log on a trail. The valid Insights type in this release is <code>ApiCallRateInsight</code>.</p>
        pub fn set_insight_selectors(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::InsightSelector>>,
        ) -> Self {
            self.insight_selectors = input;
            self
        }
        /// Consumes the builder and constructs a [`PutInsightSelectorsInput`](crate::input::PutInsightSelectorsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::PutInsightSelectorsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::PutInsightSelectorsInput {
                trail_name: self.trail_name,
                insight_selectors: self.insight_selectors,
            })
        }
    }
}
#[doc(hidden)]
pub type PutInsightSelectorsInputOperationOutputAlias = crate::operation::PutInsightSelectors;
#[doc(hidden)]
pub type PutInsightSelectorsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl PutInsightSelectorsInput {
    /// Consumes the builder and constructs an Operation<[`PutInsightSelectors`](crate::operation::PutInsightSelectors)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::PutInsightSelectors,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::PutInsightSelectorsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::PutInsightSelectorsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::PutInsightSelectorsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "CloudTrail_20131101.PutInsightSelectors",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_put_insight_selectors(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::PutInsightSelectors::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "PutInsightSelectors",
            "cloudtrail",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`PutInsightSelectorsInput`](crate::input::PutInsightSelectorsInput)
    pub fn builder() -> crate::input::put_insight_selectors_input::Builder {
        crate::input::put_insight_selectors_input::Builder::default()
    }
}

/// See [`RemoveTagsInput`](crate::input::RemoveTagsInput)
pub mod remove_tags_input {
    /// A builder for [`RemoveTagsInput`](crate::input::RemoveTagsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_id: std::option::Option<std::string::String>,
        pub(crate) tags_list: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>Specifies the ARN of the trail from which tags should be removed. The format of a trail ARN is:</p>
        /// <p>
        /// <code>arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail</code>
        /// </p>
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_id = Some(input.into());
            self
        }
        /// <p>Specifies the ARN of the trail from which tags should be removed. The format of a trail ARN is:</p>
        /// <p>
        /// <code>arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail</code>
        /// </p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_id = input;
            self
        }
        /// Appends an item to `tags_list`.
        ///
        /// To override the contents of this collection use [`set_tags_list`](Self::set_tags_list).
        ///
        /// <p>Specifies a list of tags to be removed.</p>
        pub fn tags_list(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags_list.unwrap_or_default();
            v.push(input.into());
            self.tags_list = Some(v);
            self
        }
        /// <p>Specifies a list of tags to be removed.</p>
        pub fn set_tags_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags_list = input;
            self
        }
        /// Consumes the builder and constructs a [`RemoveTagsInput`](crate::input::RemoveTagsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::RemoveTagsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::RemoveTagsInput {
                resource_id: self.resource_id,
                tags_list: self.tags_list,
            })
        }
    }
}
#[doc(hidden)]
pub type RemoveTagsInputOperationOutputAlias = crate::operation::RemoveTags;
#[doc(hidden)]
pub type RemoveTagsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl RemoveTagsInput {
    /// Consumes the builder and constructs an Operation<[`RemoveTags`](crate::operation::RemoveTags)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::RemoveTags,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::RemoveTagsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::RemoveTagsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::RemoveTagsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "CloudTrail_20131101.RemoveTags",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_remove_tags(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::RemoveTags::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "RemoveTags",
            "cloudtrail",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`RemoveTagsInput`](crate::input::RemoveTagsInput)
    pub fn builder() -> crate::input::remove_tags_input::Builder {
        crate::input::remove_tags_input::Builder::default()
    }
}

/// See [`StartLoggingInput`](crate::input::StartLoggingInput)
pub mod start_logging_input {
    /// A builder for [`StartLoggingInput`](crate::input::StartLoggingInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Specifies the name or the CloudTrail ARN of the trail for which CloudTrail logs Amazon Web Services API calls.
        /// The following is the format of a trail ARN.</p>
        /// <p>
        /// <code>arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail</code>
        /// </p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>Specifies the name or the CloudTrail ARN of the trail for which CloudTrail logs Amazon Web Services API calls.
        /// The following is the format of a trail ARN.</p>
        /// <p>
        /// <code>arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail</code>
        /// </p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Consumes the builder and constructs a [`StartLoggingInput`](crate::input::StartLoggingInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::StartLoggingInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::StartLoggingInput { name: self.name })
        }
    }
}
#[doc(hidden)]
pub type StartLoggingInputOperationOutputAlias = crate::operation::StartLogging;
#[doc(hidden)]
pub type StartLoggingInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl StartLoggingInput {
    /// Consumes the builder and constructs an Operation<[`StartLogging`](crate::operation::StartLogging)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::StartLogging,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::StartLoggingInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::StartLoggingInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::StartLoggingInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "CloudTrail_20131101.StartLogging",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_start_logging(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::StartLogging::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "StartLogging",
            "cloudtrail",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`StartLoggingInput`](crate::input::StartLoggingInput)
    pub fn builder() -> crate::input::start_logging_input::Builder {
        crate::input::start_logging_input::Builder::default()
    }
}

/// See [`StopLoggingInput`](crate::input::StopLoggingInput)
pub mod stop_logging_input {
    /// A builder for [`StopLoggingInput`](crate::input::StopLoggingInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Specifies the name or the CloudTrail ARN of the trail for which CloudTrail will stop logging Amazon Web Services
        /// API calls. The following is the format of a trail ARN.</p>
        /// <p>
        /// <code>arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail</code>
        /// </p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>Specifies the name or the CloudTrail ARN of the trail for which CloudTrail will stop logging Amazon Web Services
        /// API calls. The following is the format of a trail ARN.</p>
        /// <p>
        /// <code>arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail</code>
        /// </p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Consumes the builder and constructs a [`StopLoggingInput`](crate::input::StopLoggingInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::StopLoggingInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::StopLoggingInput { name: self.name })
        }
    }
}
#[doc(hidden)]
pub type StopLoggingInputOperationOutputAlias = crate::operation::StopLogging;
#[doc(hidden)]
pub type StopLoggingInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl StopLoggingInput {
    /// Consumes the builder and constructs an Operation<[`StopLogging`](crate::operation::StopLogging)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::StopLogging,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::StopLoggingInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::StopLoggingInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::StopLoggingInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "CloudTrail_20131101.StopLogging",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_stop_logging(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::StopLogging::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "StopLogging",
            "cloudtrail",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`StopLoggingInput`](crate::input::StopLoggingInput)
    pub fn builder() -> crate::input::stop_logging_input::Builder {
        crate::input::stop_logging_input::Builder::default()
    }
}

/// See [`UpdateTrailInput`](crate::input::UpdateTrailInput)
pub mod update_trail_input {
    /// A builder for [`UpdateTrailInput`](crate::input::UpdateTrailInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) s3_bucket_name: std::option::Option<std::string::String>,
        pub(crate) s3_key_prefix: std::option::Option<std::string::String>,
        pub(crate) sns_topic_name: std::option::Option<std::string::String>,
        pub(crate) include_global_service_events: std::option::Option<bool>,
        pub(crate) is_multi_region_trail: std::option::Option<bool>,
        pub(crate) enable_log_file_validation: std::option::Option<bool>,
        pub(crate) cloud_watch_logs_log_group_arn: std::option::Option<std::string::String>,
        pub(crate) cloud_watch_logs_role_arn: std::option::Option<std::string::String>,
        pub(crate) kms_key_id: std::option::Option<std::string::String>,
        pub(crate) is_organization_trail: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>Specifies the name of the trail or trail ARN. If <code>Name</code> is a trail name, the
        /// string must meet the following requirements:</p>
        /// <ul>
        /// <li>
        /// <p>Contain only ASCII letters (a-z, A-Z), numbers (0-9), periods (.), underscores (_), or dashes (-)</p>
        /// </li>
        /// <li>
        /// <p>Start with a letter or number, and end with a letter or number</p>
        /// </li>
        /// <li>
        /// <p>Be between 3 and 128 characters</p>
        /// </li>
        /// <li>
        /// <p>Have no adjacent periods, underscores or dashes. Names like <code>my-_namespace</code>
        /// and <code>my--namespace</code> are not valid.</p>
        /// </li>
        /// <li>
        /// <p>Not be in IP address format (for example, 192.168.5.4)</p>
        /// </li>
        /// </ul>
        /// <p>If <code>Name</code> is a trail ARN, it must be in the following format.</p>
        /// <p>
        /// <code>arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail</code>
        /// </p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>Specifies the name of the trail or trail ARN. If <code>Name</code> is a trail name, the
        /// string must meet the following requirements:</p>
        /// <ul>
        /// <li>
        /// <p>Contain only ASCII letters (a-z, A-Z), numbers (0-9), periods (.), underscores (_), or dashes (-)</p>
        /// </li>
        /// <li>
        /// <p>Start with a letter or number, and end with a letter or number</p>
        /// </li>
        /// <li>
        /// <p>Be between 3 and 128 characters</p>
        /// </li>
        /// <li>
        /// <p>Have no adjacent periods, underscores or dashes. Names like <code>my-_namespace</code>
        /// and <code>my--namespace</code> are not valid.</p>
        /// </li>
        /// <li>
        /// <p>Not be in IP address format (for example, 192.168.5.4)</p>
        /// </li>
        /// </ul>
        /// <p>If <code>Name</code> is a trail ARN, it must be in the following format.</p>
        /// <p>
        /// <code>arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail</code>
        /// </p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>Specifies the name of the Amazon S3 bucket designated for publishing log files. See <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/create_trail_naming_policy.html">Amazon S3 Bucket Naming Requirements</a>.</p>
        pub fn s3_bucket_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.s3_bucket_name = Some(input.into());
            self
        }
        /// <p>Specifies the name of the Amazon S3 bucket designated for publishing log files. See <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/create_trail_naming_policy.html">Amazon S3 Bucket Naming Requirements</a>.</p>
        pub fn set_s3_bucket_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.s3_bucket_name = input;
            self
        }
        /// <p>Specifies the Amazon S3 key prefix that comes after the name of the bucket you have designated
        /// for log file delivery. For more information, see <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/cloudtrail-find-log-files.html">Finding Your CloudTrail Log Files</a>. The maximum length is 200 characters.</p>
        pub fn s3_key_prefix(mut self, input: impl Into<std::string::String>) -> Self {
            self.s3_key_prefix = Some(input.into());
            self
        }
        /// <p>Specifies the Amazon S3 key prefix that comes after the name of the bucket you have designated
        /// for log file delivery. For more information, see <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/cloudtrail-find-log-files.html">Finding Your CloudTrail Log Files</a>. The maximum length is 200 characters.</p>
        pub fn set_s3_key_prefix(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.s3_key_prefix = input;
            self
        }
        /// <p>Specifies the name of the Amazon SNS topic defined for notification of log file delivery. The maximum length is 256 characters.</p>
        pub fn sns_topic_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.sns_topic_name = Some(input.into());
            self
        }
        /// <p>Specifies the name of the Amazon SNS topic defined for notification of log file delivery. The maximum length is 256 characters.</p>
        pub fn set_sns_topic_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.sns_topic_name = input;
            self
        }
        /// <p>Specifies whether the trail is publishing events from global services such as IAM to the log files.</p>
        pub fn include_global_service_events(mut self, input: bool) -> Self {
            self.include_global_service_events = Some(input);
            self
        }
        /// <p>Specifies whether the trail is publishing events from global services such as IAM to the log files.</p>
        pub fn set_include_global_service_events(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.include_global_service_events = input;
            self
        }
        /// <p>Specifies whether the trail applies only to the current region or to all regions. The default is false. If the trail exists only in the current region and this value is set to true,
        /// shadow trails (replications of the trail) will be created in the other regions. If the trail exists in all regions and this value is set to false, the trail will remain in the region
        /// where it was created, and its shadow trails in other regions will be deleted. As a best practice, consider
        /// using trails that log events in all regions.</p>
        pub fn is_multi_region_trail(mut self, input: bool) -> Self {
            self.is_multi_region_trail = Some(input);
            self
        }
        /// <p>Specifies whether the trail applies only to the current region or to all regions. The default is false. If the trail exists only in the current region and this value is set to true,
        /// shadow trails (replications of the trail) will be created in the other regions. If the trail exists in all regions and this value is set to false, the trail will remain in the region
        /// where it was created, and its shadow trails in other regions will be deleted. As a best practice, consider
        /// using trails that log events in all regions.</p>
        pub fn set_is_multi_region_trail(mut self, input: std::option::Option<bool>) -> Self {
            self.is_multi_region_trail = input;
            self
        }
        /// <p>Specifies whether log file validation is enabled. The default is false.</p>
        /// <note>
        /// <p>When you disable log file integrity validation, the chain of digest files is broken after one hour. CloudTrail
        /// does not create digest files for log files that were delivered during a period in which log file integrity validation
        /// was disabled. For example, if you enable log file integrity validation at noon on January 1, disable it at noon on
        /// January 2, and re-enable it at noon on January 10, digest files will not be created for the log files delivered from noon
        /// on January 2 to noon on January 10. The same applies whenever you stop CloudTrail logging or delete a trail.</p>
        /// </note>
        pub fn enable_log_file_validation(mut self, input: bool) -> Self {
            self.enable_log_file_validation = Some(input);
            self
        }
        /// <p>Specifies whether log file validation is enabled. The default is false.</p>
        /// <note>
        /// <p>When you disable log file integrity validation, the chain of digest files is broken after one hour. CloudTrail
        /// does not create digest files for log files that were delivered during a period in which log file integrity validation
        /// was disabled. For example, if you enable log file integrity validation at noon on January 1, disable it at noon on
        /// January 2, and re-enable it at noon on January 10, digest files will not be created for the log files delivered from noon
        /// on January 2 to noon on January 10. The same applies whenever you stop CloudTrail logging or delete a trail.</p>
        /// </note>
        pub fn set_enable_log_file_validation(mut self, input: std::option::Option<bool>) -> Self {
            self.enable_log_file_validation = input;
            self
        }
        /// <p>Specifies a log group name using an Amazon Resource Name (ARN), a unique identifier that represents the log group to which CloudTrail logs are delivered. Not required unless you specify <code>CloudWatchLogsRoleArn</code>.</p>
        pub fn cloud_watch_logs_log_group_arn(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.cloud_watch_logs_log_group_arn = Some(input.into());
            self
        }
        /// <p>Specifies a log group name using an Amazon Resource Name (ARN), a unique identifier that represents the log group to which CloudTrail logs are delivered. Not required unless you specify <code>CloudWatchLogsRoleArn</code>.</p>
        pub fn set_cloud_watch_logs_log_group_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.cloud_watch_logs_log_group_arn = input;
            self
        }
        /// <p>Specifies the role for the CloudWatch Logs endpoint to assume to write to a user's log group.</p>
        pub fn cloud_watch_logs_role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.cloud_watch_logs_role_arn = Some(input.into());
            self
        }
        /// <p>Specifies the role for the CloudWatch Logs endpoint to assume to write to a user's log group.</p>
        pub fn set_cloud_watch_logs_role_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.cloud_watch_logs_role_arn = input;
            self
        }
        /// <p>Specifies the KMS key ID to use to encrypt the logs delivered by CloudTrail. The
        /// value can be an alias name prefixed by "alias/", a fully specified ARN to an alias, a fully
        /// specified ARN to a key, or a globally unique identifier.</p>
        /// <p>CloudTrail also supports KMS multi-Region keys. For more information about multi-Region keys,
        /// see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/multi-region-keys-overview.html">Using multi-Region keys</a> in the <i>Key Management Service Developer Guide</i>.</p>
        /// <p>Examples:</p>
        /// <ul>
        /// <li>
        /// <p>alias/MyAliasName</p>
        /// </li>
        /// <li>
        /// <p>arn:aws:kms:us-east-2:123456789012:alias/MyAliasName</p>
        /// </li>
        /// <li>
        /// <p>arn:aws:kms:us-east-2:123456789012:key/12345678-1234-1234-1234-123456789012</p>
        /// </li>
        /// <li>
        /// <p>12345678-1234-1234-1234-123456789012</p>
        /// </li>
        /// </ul>
        pub fn kms_key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.kms_key_id = Some(input.into());
            self
        }
        /// <p>Specifies the KMS key ID to use to encrypt the logs delivered by CloudTrail. The
        /// value can be an alias name prefixed by "alias/", a fully specified ARN to an alias, a fully
        /// specified ARN to a key, or a globally unique identifier.</p>
        /// <p>CloudTrail also supports KMS multi-Region keys. For more information about multi-Region keys,
        /// see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/multi-region-keys-overview.html">Using multi-Region keys</a> in the <i>Key Management Service Developer Guide</i>.</p>
        /// <p>Examples:</p>
        /// <ul>
        /// <li>
        /// <p>alias/MyAliasName</p>
        /// </li>
        /// <li>
        /// <p>arn:aws:kms:us-east-2:123456789012:alias/MyAliasName</p>
        /// </li>
        /// <li>
        /// <p>arn:aws:kms:us-east-2:123456789012:key/12345678-1234-1234-1234-123456789012</p>
        /// </li>
        /// <li>
        /// <p>12345678-1234-1234-1234-123456789012</p>
        /// </li>
        /// </ul>
        pub fn set_kms_key_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.kms_key_id = input;
            self
        }
        /// <p>Specifies whether the trail is applied to all accounts in an organization in Organizations, or only for the current Amazon Web Services account.
        /// The default is false, and cannot be true unless the call is made on behalf of an Amazon Web Services account that is the management account for an organization in
        /// Organizations. If the trail is not an organization trail and this is set to <code>true</code>, the trail will be created in all Amazon Web Services accounts that belong
        /// to the organization. If the trail is an organization trail and this is set to <code>false</code>, the trail will remain in the current Amazon Web Services account but be
        /// deleted from all member accounts in the organization.</p>
        pub fn is_organization_trail(mut self, input: bool) -> Self {
            self.is_organization_trail = Some(input);
            self
        }
        /// <p>Specifies whether the trail is applied to all accounts in an organization in Organizations, or only for the current Amazon Web Services account.
        /// The default is false, and cannot be true unless the call is made on behalf of an Amazon Web Services account that is the management account for an organization in
        /// Organizations. If the trail is not an organization trail and this is set to <code>true</code>, the trail will be created in all Amazon Web Services accounts that belong
        /// to the organization. If the trail is an organization trail and this is set to <code>false</code>, the trail will remain in the current Amazon Web Services account but be
        /// deleted from all member accounts in the organization.</p>
        pub fn set_is_organization_trail(mut self, input: std::option::Option<bool>) -> Self {
            self.is_organization_trail = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateTrailInput`](crate::input::UpdateTrailInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateTrailInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateTrailInput {
                name: self.name,
                s3_bucket_name: self.s3_bucket_name,
                s3_key_prefix: self.s3_key_prefix,
                sns_topic_name: self.sns_topic_name,
                include_global_service_events: self.include_global_service_events,
                is_multi_region_trail: self.is_multi_region_trail,
                enable_log_file_validation: self.enable_log_file_validation,
                cloud_watch_logs_log_group_arn: self.cloud_watch_logs_log_group_arn,
                cloud_watch_logs_role_arn: self.cloud_watch_logs_role_arn,
                kms_key_id: self.kms_key_id,
                is_organization_trail: self.is_organization_trail,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateTrailInputOperationOutputAlias = crate::operation::UpdateTrail;
#[doc(hidden)]
pub type UpdateTrailInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UpdateTrailInput {
    /// Consumes the builder and constructs an Operation<[`UpdateTrail`](crate::operation::UpdateTrail)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateTrail,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateTrailInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateTrailInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateTrailInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "CloudTrail_20131101.UpdateTrail",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_update_trail(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateTrail::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateTrail",
            "cloudtrail",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateTrailInput`](crate::input::UpdateTrailInput)
    pub fn builder() -> crate::input::update_trail_input::Builder {
        crate::input::update_trail_input::Builder::default()
    }
}

/// <p>Specifies settings to update for the trail.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateTrailInput {
    /// <p>Specifies the name of the trail or trail ARN. If <code>Name</code> is a trail name, the
    /// string must meet the following requirements:</p>
    /// <ul>
    /// <li>
    /// <p>Contain only ASCII letters (a-z, A-Z), numbers (0-9), periods (.), underscores (_), or dashes (-)</p>
    /// </li>
    /// <li>
    /// <p>Start with a letter or number, and end with a letter or number</p>
    /// </li>
    /// <li>
    /// <p>Be between 3 and 128 characters</p>
    /// </li>
    /// <li>
    /// <p>Have no adjacent periods, underscores or dashes. Names like <code>my-_namespace</code>
    /// and <code>my--namespace</code> are not valid.</p>
    /// </li>
    /// <li>
    /// <p>Not be in IP address format (for example, 192.168.5.4)</p>
    /// </li>
    /// </ul>
    /// <p>If <code>Name</code> is a trail ARN, it must be in the following format.</p>
    /// <p>
    /// <code>arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail</code>
    /// </p>
    pub name: std::option::Option<std::string::String>,
    /// <p>Specifies the name of the Amazon S3 bucket designated for publishing log files. See <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/create_trail_naming_policy.html">Amazon S3 Bucket Naming Requirements</a>.</p>
    pub s3_bucket_name: std::option::Option<std::string::String>,
    /// <p>Specifies the Amazon S3 key prefix that comes after the name of the bucket you have designated
    /// for log file delivery. For more information, see <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/cloudtrail-find-log-files.html">Finding Your CloudTrail Log Files</a>. The maximum length is 200 characters.</p>
    pub s3_key_prefix: std::option::Option<std::string::String>,
    /// <p>Specifies the name of the Amazon SNS topic defined for notification of log file delivery. The maximum length is 256 characters.</p>
    pub sns_topic_name: std::option::Option<std::string::String>,
    /// <p>Specifies whether the trail is publishing events from global services such as IAM to the log files.</p>
    pub include_global_service_events: std::option::Option<bool>,
    /// <p>Specifies whether the trail applies only to the current region or to all regions. The default is false. If the trail exists only in the current region and this value is set to true,
    /// shadow trails (replications of the trail) will be created in the other regions. If the trail exists in all regions and this value is set to false, the trail will remain in the region
    /// where it was created, and its shadow trails in other regions will be deleted. As a best practice, consider
    /// using trails that log events in all regions.</p>
    pub is_multi_region_trail: std::option::Option<bool>,
    /// <p>Specifies whether log file validation is enabled. The default is false.</p>
    /// <note>
    /// <p>When you disable log file integrity validation, the chain of digest files is broken after one hour. CloudTrail
    /// does not create digest files for log files that were delivered during a period in which log file integrity validation
    /// was disabled. For example, if you enable log file integrity validation at noon on January 1, disable it at noon on
    /// January 2, and re-enable it at noon on January 10, digest files will not be created for the log files delivered from noon
    /// on January 2 to noon on January 10. The same applies whenever you stop CloudTrail logging or delete a trail.</p>
    /// </note>
    pub enable_log_file_validation: std::option::Option<bool>,
    /// <p>Specifies a log group name using an Amazon Resource Name (ARN), a unique identifier that represents the log group to which CloudTrail logs are delivered. Not required unless you specify <code>CloudWatchLogsRoleArn</code>.</p>
    pub cloud_watch_logs_log_group_arn: std::option::Option<std::string::String>,
    /// <p>Specifies the role for the CloudWatch Logs endpoint to assume to write to a user's log group.</p>
    pub cloud_watch_logs_role_arn: std::option::Option<std::string::String>,
    /// <p>Specifies the KMS key ID to use to encrypt the logs delivered by CloudTrail. The
    /// value can be an alias name prefixed by "alias/", a fully specified ARN to an alias, a fully
    /// specified ARN to a key, or a globally unique identifier.</p>
    /// <p>CloudTrail also supports KMS multi-Region keys. For more information about multi-Region keys,
    /// see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/multi-region-keys-overview.html">Using multi-Region keys</a> in the <i>Key Management Service Developer Guide</i>.</p>
    /// <p>Examples:</p>
    /// <ul>
    /// <li>
    /// <p>alias/MyAliasName</p>
    /// </li>
    /// <li>
    /// <p>arn:aws:kms:us-east-2:123456789012:alias/MyAliasName</p>
    /// </li>
    /// <li>
    /// <p>arn:aws:kms:us-east-2:123456789012:key/12345678-1234-1234-1234-123456789012</p>
    /// </li>
    /// <li>
    /// <p>12345678-1234-1234-1234-123456789012</p>
    /// </li>
    /// </ul>
    pub kms_key_id: std::option::Option<std::string::String>,
    /// <p>Specifies whether the trail is applied to all accounts in an organization in Organizations, or only for the current Amazon Web Services account.
    /// The default is false, and cannot be true unless the call is made on behalf of an Amazon Web Services account that is the management account for an organization in
    /// Organizations. If the trail is not an organization trail and this is set to <code>true</code>, the trail will be created in all Amazon Web Services accounts that belong
    /// to the organization. If the trail is an organization trail and this is set to <code>false</code>, the trail will remain in the current Amazon Web Services account but be
    /// deleted from all member accounts in the organization.</p>
    pub is_organization_trail: std::option::Option<bool>,
}
impl UpdateTrailInput {
    /// <p>Specifies the name of the trail or trail ARN. If <code>Name</code> is a trail name, the
    /// string must meet the following requirements:</p>
    /// <ul>
    /// <li>
    /// <p>Contain only ASCII letters (a-z, A-Z), numbers (0-9), periods (.), underscores (_), or dashes (-)</p>
    /// </li>
    /// <li>
    /// <p>Start with a letter or number, and end with a letter or number</p>
    /// </li>
    /// <li>
    /// <p>Be between 3 and 128 characters</p>
    /// </li>
    /// <li>
    /// <p>Have no adjacent periods, underscores or dashes. Names like <code>my-_namespace</code>
    /// and <code>my--namespace</code> are not valid.</p>
    /// </li>
    /// <li>
    /// <p>Not be in IP address format (for example, 192.168.5.4)</p>
    /// </li>
    /// </ul>
    /// <p>If <code>Name</code> is a trail ARN, it must be in the following format.</p>
    /// <p>
    /// <code>arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail</code>
    /// </p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>Specifies the name of the Amazon S3 bucket designated for publishing log files. See <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/create_trail_naming_policy.html">Amazon S3 Bucket Naming Requirements</a>.</p>
    pub fn s3_bucket_name(&self) -> std::option::Option<&str> {
        self.s3_bucket_name.as_deref()
    }
    /// <p>Specifies the Amazon S3 key prefix that comes after the name of the bucket you have designated
    /// for log file delivery. For more information, see <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/cloudtrail-find-log-files.html">Finding Your CloudTrail Log Files</a>. The maximum length is 200 characters.</p>
    pub fn s3_key_prefix(&self) -> std::option::Option<&str> {
        self.s3_key_prefix.as_deref()
    }
    /// <p>Specifies the name of the Amazon SNS topic defined for notification of log file delivery. The maximum length is 256 characters.</p>
    pub fn sns_topic_name(&self) -> std::option::Option<&str> {
        self.sns_topic_name.as_deref()
    }
    /// <p>Specifies whether the trail is publishing events from global services such as IAM to the log files.</p>
    pub fn include_global_service_events(&self) -> std::option::Option<bool> {
        self.include_global_service_events
    }
    /// <p>Specifies whether the trail applies only to the current region or to all regions. The default is false. If the trail exists only in the current region and this value is set to true,
    /// shadow trails (replications of the trail) will be created in the other regions. If the trail exists in all regions and this value is set to false, the trail will remain in the region
    /// where it was created, and its shadow trails in other regions will be deleted. As a best practice, consider
    /// using trails that log events in all regions.</p>
    pub fn is_multi_region_trail(&self) -> std::option::Option<bool> {
        self.is_multi_region_trail
    }
    /// <p>Specifies whether log file validation is enabled. The default is false.</p>
    /// <note>
    /// <p>When you disable log file integrity validation, the chain of digest files is broken after one hour. CloudTrail
    /// does not create digest files for log files that were delivered during a period in which log file integrity validation
    /// was disabled. For example, if you enable log file integrity validation at noon on January 1, disable it at noon on
    /// January 2, and re-enable it at noon on January 10, digest files will not be created for the log files delivered from noon
    /// on January 2 to noon on January 10. The same applies whenever you stop CloudTrail logging or delete a trail.</p>
    /// </note>
    pub fn enable_log_file_validation(&self) -> std::option::Option<bool> {
        self.enable_log_file_validation
    }
    /// <p>Specifies a log group name using an Amazon Resource Name (ARN), a unique identifier that represents the log group to which CloudTrail logs are delivered. Not required unless you specify <code>CloudWatchLogsRoleArn</code>.</p>
    pub fn cloud_watch_logs_log_group_arn(&self) -> std::option::Option<&str> {
        self.cloud_watch_logs_log_group_arn.as_deref()
    }
    /// <p>Specifies the role for the CloudWatch Logs endpoint to assume to write to a user's log group.</p>
    pub fn cloud_watch_logs_role_arn(&self) -> std::option::Option<&str> {
        self.cloud_watch_logs_role_arn.as_deref()
    }
    /// <p>Specifies the KMS key ID to use to encrypt the logs delivered by CloudTrail. The
    /// value can be an alias name prefixed by "alias/", a fully specified ARN to an alias, a fully
    /// specified ARN to a key, or a globally unique identifier.</p>
    /// <p>CloudTrail also supports KMS multi-Region keys. For more information about multi-Region keys,
    /// see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/multi-region-keys-overview.html">Using multi-Region keys</a> in the <i>Key Management Service Developer Guide</i>.</p>
    /// <p>Examples:</p>
    /// <ul>
    /// <li>
    /// <p>alias/MyAliasName</p>
    /// </li>
    /// <li>
    /// <p>arn:aws:kms:us-east-2:123456789012:alias/MyAliasName</p>
    /// </li>
    /// <li>
    /// <p>arn:aws:kms:us-east-2:123456789012:key/12345678-1234-1234-1234-123456789012</p>
    /// </li>
    /// <li>
    /// <p>12345678-1234-1234-1234-123456789012</p>
    /// </li>
    /// </ul>
    pub fn kms_key_id(&self) -> std::option::Option<&str> {
        self.kms_key_id.as_deref()
    }
    /// <p>Specifies whether the trail is applied to all accounts in an organization in Organizations, or only for the current Amazon Web Services account.
    /// The default is false, and cannot be true unless the call is made on behalf of an Amazon Web Services account that is the management account for an organization in
    /// Organizations. If the trail is not an organization trail and this is set to <code>true</code>, the trail will be created in all Amazon Web Services accounts that belong
    /// to the organization. If the trail is an organization trail and this is set to <code>false</code>, the trail will remain in the current Amazon Web Services account but be
    /// deleted from all member accounts in the organization.</p>
    pub fn is_organization_trail(&self) -> std::option::Option<bool> {
        self.is_organization_trail
    }
}
impl std::fmt::Debug for UpdateTrailInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateTrailInput");
        formatter.field("name", &self.name);
        formatter.field("s3_bucket_name", &self.s3_bucket_name);
        formatter.field("s3_key_prefix", &self.s3_key_prefix);
        formatter.field("sns_topic_name", &self.sns_topic_name);
        formatter.field(
            "include_global_service_events",
            &self.include_global_service_events,
        );
        formatter.field("is_multi_region_trail", &self.is_multi_region_trail);
        formatter.field(
            "enable_log_file_validation",
            &self.enable_log_file_validation,
        );
        formatter.field(
            "cloud_watch_logs_log_group_arn",
            &self.cloud_watch_logs_log_group_arn,
        );
        formatter.field("cloud_watch_logs_role_arn", &self.cloud_watch_logs_role_arn);
        formatter.field("kms_key_id", &self.kms_key_id);
        formatter.field("is_organization_trail", &self.is_organization_trail);
        formatter.finish()
    }
}

/// <p>Passes the request to CloudTrail to stop logging Amazon Web Services API calls for the specified account.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StopLoggingInput {
    /// <p>Specifies the name or the CloudTrail ARN of the trail for which CloudTrail will stop logging Amazon Web Services
    /// API calls. The following is the format of a trail ARN.</p>
    /// <p>
    /// <code>arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail</code>
    /// </p>
    pub name: std::option::Option<std::string::String>,
}
impl StopLoggingInput {
    /// <p>Specifies the name or the CloudTrail ARN of the trail for which CloudTrail will stop logging Amazon Web Services
    /// API calls. The following is the format of a trail ARN.</p>
    /// <p>
    /// <code>arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail</code>
    /// </p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
}
impl std::fmt::Debug for StopLoggingInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StopLoggingInput");
        formatter.field("name", &self.name);
        formatter.finish()
    }
}

/// <p>The request to CloudTrail to start logging Amazon Web Services API calls for an account.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StartLoggingInput {
    /// <p>Specifies the name or the CloudTrail ARN of the trail for which CloudTrail logs Amazon Web Services API calls.
    /// The following is the format of a trail ARN.</p>
    /// <p>
    /// <code>arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail</code>
    /// </p>
    pub name: std::option::Option<std::string::String>,
}
impl StartLoggingInput {
    /// <p>Specifies the name or the CloudTrail ARN of the trail for which CloudTrail logs Amazon Web Services API calls.
    /// The following is the format of a trail ARN.</p>
    /// <p>
    /// <code>arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail</code>
    /// </p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
}
impl std::fmt::Debug for StartLoggingInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StartLoggingInput");
        formatter.field("name", &self.name);
        formatter.finish()
    }
}

/// <p>Specifies the tags to remove from a trail.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RemoveTagsInput {
    /// <p>Specifies the ARN of the trail from which tags should be removed. The format of a trail ARN is:</p>
    /// <p>
    /// <code>arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail</code>
    /// </p>
    pub resource_id: std::option::Option<std::string::String>,
    /// <p>Specifies a list of tags to be removed.</p>
    pub tags_list: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl RemoveTagsInput {
    /// <p>Specifies the ARN of the trail from which tags should be removed. The format of a trail ARN is:</p>
    /// <p>
    /// <code>arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail</code>
    /// </p>
    pub fn resource_id(&self) -> std::option::Option<&str> {
        self.resource_id.as_deref()
    }
    /// <p>Specifies a list of tags to be removed.</p>
    pub fn tags_list(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags_list.as_deref()
    }
}
impl std::fmt::Debug for RemoveTagsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RemoveTagsInput");
        formatter.field("resource_id", &self.resource_id);
        formatter.field("tags_list", &self.tags_list);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutInsightSelectorsInput {
    /// <p>The name of the CloudTrail trail for which you want to change or add Insights selectors.</p>
    pub trail_name: std::option::Option<std::string::String>,
    /// <p>A JSON string that contains the Insights types that you want to log on a trail. The valid Insights type in this release is <code>ApiCallRateInsight</code>.</p>
    pub insight_selectors: std::option::Option<std::vec::Vec<crate::model::InsightSelector>>,
}
impl PutInsightSelectorsInput {
    /// <p>The name of the CloudTrail trail for which you want to change or add Insights selectors.</p>
    pub fn trail_name(&self) -> std::option::Option<&str> {
        self.trail_name.as_deref()
    }
    /// <p>A JSON string that contains the Insights types that you want to log on a trail. The valid Insights type in this release is <code>ApiCallRateInsight</code>.</p>
    pub fn insight_selectors(&self) -> std::option::Option<&[crate::model::InsightSelector]> {
        self.insight_selectors.as_deref()
    }
}
impl std::fmt::Debug for PutInsightSelectorsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutInsightSelectorsInput");
        formatter.field("trail_name", &self.trail_name);
        formatter.field("insight_selectors", &self.insight_selectors);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutEventSelectorsInput {
    /// <p>Specifies the name of the trail or trail ARN. If you specify a trail name, the
    /// string must meet the following requirements:</p>
    /// <ul>
    /// <li>
    /// <p>Contain only ASCII letters (a-z, A-Z), numbers (0-9), periods (.), underscores (_), or dashes (-)</p>
    /// </li>
    /// <li>
    /// <p>Start with a letter or number, and end with a letter or number</p>
    /// </li>
    /// <li>
    /// <p>Be between 3 and 128 characters</p>
    /// </li>
    /// <li>
    /// <p>Have no adjacent periods, underscores or dashes. Names like <code>my-_namespace</code>
    /// and <code>my--namespace</code> are not valid.</p>
    /// </li>
    /// <li>
    /// <p>Not be in IP address format (for example, 192.168.5.4)</p>
    /// </li>
    /// </ul>
    /// <p>If you specify a trail ARN, it must be in the following format.</p>
    /// <p>
    /// <code>arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail</code>
    /// </p>
    pub trail_name: std::option::Option<std::string::String>,
    /// <p>Specifies the settings for your event selectors. You can configure up to five event selectors for a trail.
    /// You can use either <code>EventSelectors</code> or <code>AdvancedEventSelectors</code> in a <code>PutEventSelectors</code> request, but not both.
    /// If you apply <code>EventSelectors</code> to a trail, any existing <code>AdvancedEventSelectors</code> are overwritten.</p>
    pub event_selectors: std::option::Option<std::vec::Vec<crate::model::EventSelector>>,
    /// <p>
    /// Specifies the settings for advanced event selectors. You can add advanced event selectors, and conditions for your advanced
    /// event selectors, up to a maximum of 500 values for all conditions and selectors on a trail.
    /// You can use either <code>AdvancedEventSelectors</code> or <code>EventSelectors</code>, but not both. If you apply <code>AdvancedEventSelectors</code>
    /// to a trail, any existing <code>EventSelectors</code> are overwritten. For more information about
    /// advanced event selectors, see
    /// <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/logging-data-events-with-cloudtrail.html">Logging
    /// data events for trails</a> in the <i>CloudTrail User Guide</i>.
    /// </p>
    pub advanced_event_selectors:
        std::option::Option<std::vec::Vec<crate::model::AdvancedEventSelector>>,
}
impl PutEventSelectorsInput {
    /// <p>Specifies the name of the trail or trail ARN. If you specify a trail name, the
    /// string must meet the following requirements:</p>
    /// <ul>
    /// <li>
    /// <p>Contain only ASCII letters (a-z, A-Z), numbers (0-9), periods (.), underscores (_), or dashes (-)</p>
    /// </li>
    /// <li>
    /// <p>Start with a letter or number, and end with a letter or number</p>
    /// </li>
    /// <li>
    /// <p>Be between 3 and 128 characters</p>
    /// </li>
    /// <li>
    /// <p>Have no adjacent periods, underscores or dashes. Names like <code>my-_namespace</code>
    /// and <code>my--namespace</code> are not valid.</p>
    /// </li>
    /// <li>
    /// <p>Not be in IP address format (for example, 192.168.5.4)</p>
    /// </li>
    /// </ul>
    /// <p>If you specify a trail ARN, it must be in the following format.</p>
    /// <p>
    /// <code>arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail</code>
    /// </p>
    pub fn trail_name(&self) -> std::option::Option<&str> {
        self.trail_name.as_deref()
    }
    /// <p>Specifies the settings for your event selectors. You can configure up to five event selectors for a trail.
    /// You can use either <code>EventSelectors</code> or <code>AdvancedEventSelectors</code> in a <code>PutEventSelectors</code> request, but not both.
    /// If you apply <code>EventSelectors</code> to a trail, any existing <code>AdvancedEventSelectors</code> are overwritten.</p>
    pub fn event_selectors(&self) -> std::option::Option<&[crate::model::EventSelector]> {
        self.event_selectors.as_deref()
    }
    /// <p>
    /// Specifies the settings for advanced event selectors. You can add advanced event selectors, and conditions for your advanced
    /// event selectors, up to a maximum of 500 values for all conditions and selectors on a trail.
    /// You can use either <code>AdvancedEventSelectors</code> or <code>EventSelectors</code>, but not both. If you apply <code>AdvancedEventSelectors</code>
    /// to a trail, any existing <code>EventSelectors</code> are overwritten. For more information about
    /// advanced event selectors, see
    /// <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/logging-data-events-with-cloudtrail.html">Logging
    /// data events for trails</a> in the <i>CloudTrail User Guide</i>.
    /// </p>
    pub fn advanced_event_selectors(
        &self,
    ) -> std::option::Option<&[crate::model::AdvancedEventSelector]> {
        self.advanced_event_selectors.as_deref()
    }
}
impl std::fmt::Debug for PutEventSelectorsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutEventSelectorsInput");
        formatter.field("trail_name", &self.trail_name);
        formatter.field("event_selectors", &self.event_selectors);
        formatter.field("advanced_event_selectors", &self.advanced_event_selectors);
        formatter.finish()
    }
}

/// <p>Contains a request for LookupEvents.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LookupEventsInput {
    /// <p>Contains a list of lookup attributes. Currently the list can contain only one item.</p>
    pub lookup_attributes: std::option::Option<std::vec::Vec<crate::model::LookupAttribute>>,
    /// <p>Specifies that only events that occur after or at the specified time are returned. If the specified start time is after the specified end time, an error is returned.</p>
    pub start_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>Specifies that only events that occur before or at the specified time are returned. If the specified end time is before the specified start time, an error is returned.</p>
    pub end_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>Specifies the event category. If you do not specify an event category, events of the category are not returned in the response. For example,
    /// if you do not specify <code>insight</code> as the value of <code>EventCategory</code>, no Insights events are returned.</p>
    pub event_category: std::option::Option<crate::model::EventCategory>,
    /// <p>The number of events to return. Possible values are 1 through 50. The default is 50.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>The token to use to get the next page of results after a previous API call. This token must be passed in with the same parameters that were specified in the the original call.
    /// For example, if the original call specified an AttributeKey of 'Username' with a value of 'root', the call with NextToken should include those same parameters.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl LookupEventsInput {
    /// <p>Contains a list of lookup attributes. Currently the list can contain only one item.</p>
    pub fn lookup_attributes(&self) -> std::option::Option<&[crate::model::LookupAttribute]> {
        self.lookup_attributes.as_deref()
    }
    /// <p>Specifies that only events that occur after or at the specified time are returned. If the specified start time is after the specified end time, an error is returned.</p>
    pub fn start_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.start_time.as_ref()
    }
    /// <p>Specifies that only events that occur before or at the specified time are returned. If the specified end time is before the specified start time, an error is returned.</p>
    pub fn end_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.end_time.as_ref()
    }
    /// <p>Specifies the event category. If you do not specify an event category, events of the category are not returned in the response. For example,
    /// if you do not specify <code>insight</code> as the value of <code>EventCategory</code>, no Insights events are returned.</p>
    pub fn event_category(&self) -> std::option::Option<&crate::model::EventCategory> {
        self.event_category.as_ref()
    }
    /// <p>The number of events to return. Possible values are 1 through 50. The default is 50.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p>The token to use to get the next page of results after a previous API call. This token must be passed in with the same parameters that were specified in the the original call.
    /// For example, if the original call specified an AttributeKey of 'Username' with a value of 'root', the call with NextToken should include those same parameters.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for LookupEventsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LookupEventsInput");
        formatter.field("lookup_attributes", &self.lookup_attributes);
        formatter.field("start_time", &self.start_time);
        formatter.field("end_time", &self.end_time);
        formatter.field("event_category", &self.event_category);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTrailsInput {
    /// <p>The token to use to get the next page of results after a previous API call. This token must be passed
    /// in with the same parameters that were specified in the the original call. For example, if the original
    /// call specified an AttributeKey of 'Username' with a value of 'root', the call with NextToken should
    /// include those same parameters.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListTrailsInput {
    /// <p>The token to use to get the next page of results after a previous API call. This token must be passed
    /// in with the same parameters that were specified in the the original call. For example, if the original
    /// call specified an AttributeKey of 'Username' with a value of 'root', the call with NextToken should
    /// include those same parameters.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListTrailsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTrailsInput");
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

/// <p>Specifies a list of trail tags to return.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTagsInput {
    /// <p>Specifies a list of trail ARNs whose tags will be listed. The list has a limit of 20 ARNs. The following is the format of
    /// a trail ARN.</p>
    /// <p>
    /// <code>arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail</code>
    /// </p>
    pub resource_id_list: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>Reserved for future use.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListTagsInput {
    /// <p>Specifies a list of trail ARNs whose tags will be listed. The list has a limit of 20 ARNs. The following is the format of
    /// a trail ARN.</p>
    /// <p>
    /// <code>arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail</code>
    /// </p>
    pub fn resource_id_list(&self) -> std::option::Option<&[std::string::String]> {
        self.resource_id_list.as_deref()
    }
    /// <p>Reserved for future use.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListTagsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTagsInput");
        formatter.field("resource_id_list", &self.resource_id_list);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

/// <p>Requests the public keys for a specified time range.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListPublicKeysInput {
    /// <p>Optionally specifies, in UTC, the start of the time range to look up public keys for CloudTrail digest files.
    /// If not specified, the current time is used, and the current public key is returned.</p>
    pub start_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>Optionally specifies, in UTC, the end of the time range to look up public keys for CloudTrail digest files. If not
    /// specified, the current time is used.</p>
    pub end_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>Reserved for future use.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListPublicKeysInput {
    /// <p>Optionally specifies, in UTC, the start of the time range to look up public keys for CloudTrail digest files.
    /// If not specified, the current time is used, and the current public key is returned.</p>
    pub fn start_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.start_time.as_ref()
    }
    /// <p>Optionally specifies, in UTC, the end of the time range to look up public keys for CloudTrail digest files. If not
    /// specified, the current time is used.</p>
    pub fn end_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.end_time.as_ref()
    }
    /// <p>Reserved for future use.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListPublicKeysInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListPublicKeysInput");
        formatter.field("start_time", &self.start_time);
        formatter.field("end_time", &self.end_time);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

/// <p>The name of a trail about which you want the current status.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetTrailStatusInput {
    /// <p>Specifies the name or the CloudTrail ARN of the trail for which you are requesting status. To get the status of a
    /// shadow trail (a replication of the trail in another region), you must specify its ARN. The following is the format of a trail ARN.</p>
    /// <p>
    /// <code>arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail</code>
    /// </p>
    pub name: std::option::Option<std::string::String>,
}
impl GetTrailStatusInput {
    /// <p>Specifies the name or the CloudTrail ARN of the trail for which you are requesting status. To get the status of a
    /// shadow trail (a replication of the trail in another region), you must specify its ARN. The following is the format of a trail ARN.</p>
    /// <p>
    /// <code>arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail</code>
    /// </p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
}
impl std::fmt::Debug for GetTrailStatusInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetTrailStatusInput");
        formatter.field("name", &self.name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetTrailInput {
    /// <p>The name or the Amazon Resource Name (ARN) of the trail for which you want to retrieve settings information.</p>
    pub name: std::option::Option<std::string::String>,
}
impl GetTrailInput {
    /// <p>The name or the Amazon Resource Name (ARN) of the trail for which you want to retrieve settings information.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
}
impl std::fmt::Debug for GetTrailInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetTrailInput");
        formatter.field("name", &self.name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetInsightSelectorsInput {
    /// <p>Specifies the name of the trail or trail ARN. If you specify a trail name, the
    /// string must meet the following requirements:</p>
    /// <ul>
    /// <li>
    /// <p>Contain only ASCII letters (a-z, A-Z), numbers (0-9), periods (.), underscores (_), or dashes (-)</p>
    /// </li>
    /// <li>
    /// <p>Start with a letter or number, and end with a letter or number</p>
    /// </li>
    /// <li>
    /// <p>Be between 3 and 128 characters</p>
    /// </li>
    /// <li>
    /// <p>Have no adjacent periods, underscores or dashes. Names like <code>my-_namespace</code>
    /// and <code>my--namespace</code> are not valid.</p>
    /// </li>
    /// <li>
    /// <p>Not be in IP address format (for example, 192.168.5.4)</p>
    /// </li>
    /// </ul>
    /// <p>If you specify a trail ARN, it must be in the format:</p>
    /// <p>
    /// <code>arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail</code>
    /// </p>
    pub trail_name: std::option::Option<std::string::String>,
}
impl GetInsightSelectorsInput {
    /// <p>Specifies the name of the trail or trail ARN. If you specify a trail name, the
    /// string must meet the following requirements:</p>
    /// <ul>
    /// <li>
    /// <p>Contain only ASCII letters (a-z, A-Z), numbers (0-9), periods (.), underscores (_), or dashes (-)</p>
    /// </li>
    /// <li>
    /// <p>Start with a letter or number, and end with a letter or number</p>
    /// </li>
    /// <li>
    /// <p>Be between 3 and 128 characters</p>
    /// </li>
    /// <li>
    /// <p>Have no adjacent periods, underscores or dashes. Names like <code>my-_namespace</code>
    /// and <code>my--namespace</code> are not valid.</p>
    /// </li>
    /// <li>
    /// <p>Not be in IP address format (for example, 192.168.5.4)</p>
    /// </li>
    /// </ul>
    /// <p>If you specify a trail ARN, it must be in the format:</p>
    /// <p>
    /// <code>arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail</code>
    /// </p>
    pub fn trail_name(&self) -> std::option::Option<&str> {
        self.trail_name.as_deref()
    }
}
impl std::fmt::Debug for GetInsightSelectorsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetInsightSelectorsInput");
        formatter.field("trail_name", &self.trail_name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetEventSelectorsInput {
    /// <p>Specifies the name of the trail or trail ARN. If you specify a trail name, the
    /// string must meet the following requirements:</p>
    /// <ul>
    /// <li>
    /// <p>Contain only ASCII letters (a-z, A-Z), numbers (0-9), periods (.), underscores (_), or dashes (-)</p>
    /// </li>
    /// <li>
    /// <p>Start with a letter or number, and end with a letter or number</p>
    /// </li>
    /// <li>
    /// <p>Be between 3 and 128 characters</p>
    /// </li>
    /// <li>
    /// <p>Have no adjacent periods, underscores or dashes. Names like <code>my-_namespace</code>
    /// and <code>my--namespace</code> are not valid.</p>
    /// </li>
    /// <li>
    /// <p>Not be in IP address format (for example, 192.168.5.4)</p>
    /// </li>
    /// </ul>
    /// <p>If you specify a trail ARN, it must be in the format:</p>
    /// <p>
    /// <code>arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail</code>
    /// </p>
    pub trail_name: std::option::Option<std::string::String>,
}
impl GetEventSelectorsInput {
    /// <p>Specifies the name of the trail or trail ARN. If you specify a trail name, the
    /// string must meet the following requirements:</p>
    /// <ul>
    /// <li>
    /// <p>Contain only ASCII letters (a-z, A-Z), numbers (0-9), periods (.), underscores (_), or dashes (-)</p>
    /// </li>
    /// <li>
    /// <p>Start with a letter or number, and end with a letter or number</p>
    /// </li>
    /// <li>
    /// <p>Be between 3 and 128 characters</p>
    /// </li>
    /// <li>
    /// <p>Have no adjacent periods, underscores or dashes. Names like <code>my-_namespace</code>
    /// and <code>my--namespace</code> are not valid.</p>
    /// </li>
    /// <li>
    /// <p>Not be in IP address format (for example, 192.168.5.4)</p>
    /// </li>
    /// </ul>
    /// <p>If you specify a trail ARN, it must be in the format:</p>
    /// <p>
    /// <code>arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail</code>
    /// </p>
    pub fn trail_name(&self) -> std::option::Option<&str> {
        self.trail_name.as_deref()
    }
}
impl std::fmt::Debug for GetEventSelectorsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetEventSelectorsInput");
        formatter.field("trail_name", &self.trail_name);
        formatter.finish()
    }
}

/// <p>Returns information about the trail.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeTrailsInput {
    /// <p>Specifies a list of trail names, trail ARNs, or both, of the trails to describe. The format of a trail ARN is:</p>
    /// <p>
    /// <code>arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail</code>
    /// </p>
    ///
    /// <p>If an empty list is specified, information for the trail in the current region is returned.</p>
    /// <ul>
    /// <li>
    /// <p>If an empty list is specified and <code>IncludeShadowTrails</code> is false, then
    /// information for all trails in the current region is returned.</p>
    /// </li>
    /// <li>
    /// <p>If an empty list is specified and IncludeShadowTrails is null or true, then information for all trails in the current region and any associated shadow trails in other regions is returned.</p>
    /// </li>
    /// </ul>
    /// <note>
    /// <p>If one or more trail names are specified, information is returned only if the names match the names of trails belonging only to the current region. To return information about a trail in another region, you must specify its trail ARN.</p>
    /// </note>
    pub trail_name_list: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>Specifies whether to include shadow trails in the response. A shadow trail is the replication in a region of a trail that was created in a different region,
    /// or in the case of an organization trail, the replication of an organization trail in member accounts. If you do not include shadow trails, organization trails in a member account
    /// and region replication trails will not be returned. The default is true.</p>
    pub include_shadow_trails: std::option::Option<bool>,
}
impl DescribeTrailsInput {
    /// <p>Specifies a list of trail names, trail ARNs, or both, of the trails to describe. The format of a trail ARN is:</p>
    /// <p>
    /// <code>arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail</code>
    /// </p>
    ///
    /// <p>If an empty list is specified, information for the trail in the current region is returned.</p>
    /// <ul>
    /// <li>
    /// <p>If an empty list is specified and <code>IncludeShadowTrails</code> is false, then
    /// information for all trails in the current region is returned.</p>
    /// </li>
    /// <li>
    /// <p>If an empty list is specified and IncludeShadowTrails is null or true, then information for all trails in the current region and any associated shadow trails in other regions is returned.</p>
    /// </li>
    /// </ul>
    /// <note>
    /// <p>If one or more trail names are specified, information is returned only if the names match the names of trails belonging only to the current region. To return information about a trail in another region, you must specify its trail ARN.</p>
    /// </note>
    pub fn trail_name_list(&self) -> std::option::Option<&[std::string::String]> {
        self.trail_name_list.as_deref()
    }
    /// <p>Specifies whether to include shadow trails in the response. A shadow trail is the replication in a region of a trail that was created in a different region,
    /// or in the case of an organization trail, the replication of an organization trail in member accounts. If you do not include shadow trails, organization trails in a member account
    /// and region replication trails will not be returned. The default is true.</p>
    pub fn include_shadow_trails(&self) -> std::option::Option<bool> {
        self.include_shadow_trails
    }
}
impl std::fmt::Debug for DescribeTrailsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeTrailsInput");
        formatter.field("trail_name_list", &self.trail_name_list);
        formatter.field("include_shadow_trails", &self.include_shadow_trails);
        formatter.finish()
    }
}

/// <p>The request that specifies the name of a trail to delete.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteTrailInput {
    /// <p>Specifies the name or the CloudTrail ARN of the trail to be deleted. The following is the format of a
    /// trail ARN.
    /// <code>arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail</code>
    /// </p>
    pub name: std::option::Option<std::string::String>,
}
impl DeleteTrailInput {
    /// <p>Specifies the name or the CloudTrail ARN of the trail to be deleted. The following is the format of a
    /// trail ARN.
    /// <code>arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail</code>
    /// </p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
}
impl std::fmt::Debug for DeleteTrailInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteTrailInput");
        formatter.field("name", &self.name);
        formatter.finish()
    }
}

/// <p>Specifies the settings for each trail.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateTrailInput {
    /// <p>Specifies the name of the trail. The name must meet the following requirements:</p>
    /// <ul>
    /// <li>
    /// <p>Contain only ASCII letters (a-z, A-Z), numbers (0-9), periods (.), underscores (_), or dashes (-)</p>
    /// </li>
    /// <li>
    /// <p>Start with a letter or number, and end with a letter or number</p>
    /// </li>
    /// <li>
    /// <p>Be between 3 and 128 characters</p>
    /// </li>
    /// <li>
    /// <p>Have no adjacent periods, underscores or dashes. Names like <code>my-_namespace</code>
    /// and <code>my--namespace</code> are not valid.</p>
    /// </li>
    /// <li>
    /// <p>Not be in IP address format (for example, 192.168.5.4)</p>
    /// </li>
    /// </ul>
    pub name: std::option::Option<std::string::String>,
    /// <p>Specifies the name of the Amazon S3 bucket designated for publishing log files. See <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/create_trail_naming_policy.html">Amazon S3 Bucket Naming Requirements</a>.</p>
    pub s3_bucket_name: std::option::Option<std::string::String>,
    /// <p>Specifies the Amazon S3 key prefix that comes after the name of the bucket you have designated
    /// for log file delivery. For more information, see <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/cloudtrail-find-log-files.html">Finding Your CloudTrail Log Files</a>. The maximum length is 200 characters.</p>
    pub s3_key_prefix: std::option::Option<std::string::String>,
    /// <p>Specifies the name of the Amazon SNS topic defined for notification of log file delivery. The maximum length is 256 characters.</p>
    pub sns_topic_name: std::option::Option<std::string::String>,
    /// <p>Specifies whether the trail is publishing events from global services such as IAM to the log files.</p>
    pub include_global_service_events: std::option::Option<bool>,
    /// <p>Specifies whether the trail is created in the current region or in all regions. The default is false, which creates a trail only in the region where you are signed in. As a best practice, consider
    /// creating trails that log events in all regions.</p>
    pub is_multi_region_trail: std::option::Option<bool>,
    /// <p>Specifies whether log file integrity validation is enabled. The default is false.</p>
    /// <note>
    /// <p>When you disable log file integrity validation, the chain of digest files is broken after one hour. CloudTrail does
    /// not create digest files for log files that were delivered during a period in which log file integrity validation was disabled.
    /// For example, if you enable log file integrity validation at noon on January 1, disable it at noon on January 2, and re-enable
    /// it at noon on January 10, digest files will not be created for the log files delivered from noon on January 2 to noon on
    /// January 10. The same applies whenever you stop CloudTrail logging or delete a trail.</p>
    /// </note>
    pub enable_log_file_validation: std::option::Option<bool>,
    /// <p>Specifies a log group name using an Amazon Resource Name (ARN), a unique identifier that represents the log group
    /// to which CloudTrail logs will be delivered. Not required unless you specify <code>CloudWatchLogsRoleArn</code>.</p>
    pub cloud_watch_logs_log_group_arn: std::option::Option<std::string::String>,
    /// <p>Specifies the role for the CloudWatch Logs endpoint to assume to write to a user's log group.</p>
    pub cloud_watch_logs_role_arn: std::option::Option<std::string::String>,
    /// <p>Specifies the KMS key ID to use to encrypt the logs delivered by CloudTrail. The
    /// value can be an alias name prefixed by "alias/", a fully specified ARN to an alias, a fully
    /// specified ARN to a key, or a globally unique identifier.</p>
    /// <p>CloudTrail also supports KMS multi-Region keys. For more information about multi-Region keys,
    /// see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/multi-region-keys-overview.html">Using multi-Region keys</a> in the <i>Key Management Service Developer Guide</i>.</p>
    /// <p>Examples:</p>
    /// <ul>
    /// <li>
    /// <p>alias/MyAliasName</p>
    /// </li>
    /// <li>
    /// <p>arn:aws:kms:us-east-2:123456789012:alias/MyAliasName</p>
    /// </li>
    /// <li>
    /// <p>arn:aws:kms:us-east-2:123456789012:key/12345678-1234-1234-1234-123456789012</p>
    /// </li>
    /// <li>
    /// <p>12345678-1234-1234-1234-123456789012</p>
    /// </li>
    /// </ul>
    pub kms_key_id: std::option::Option<std::string::String>,
    /// <p>Specifies whether the trail is created for all accounts in an organization in Organizations, or only for the current Amazon Web Services account.
    /// The default is false, and cannot be true unless the call is made on behalf of an Amazon Web Services account that is the management account for an organization in
    /// Organizations.</p>
    pub is_organization_trail: std::option::Option<bool>,
    /// <p>A list of tags.</p>
    pub tags_list: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl CreateTrailInput {
    /// <p>Specifies the name of the trail. The name must meet the following requirements:</p>
    /// <ul>
    /// <li>
    /// <p>Contain only ASCII letters (a-z, A-Z), numbers (0-9), periods (.), underscores (_), or dashes (-)</p>
    /// </li>
    /// <li>
    /// <p>Start with a letter or number, and end with a letter or number</p>
    /// </li>
    /// <li>
    /// <p>Be between 3 and 128 characters</p>
    /// </li>
    /// <li>
    /// <p>Have no adjacent periods, underscores or dashes. Names like <code>my-_namespace</code>
    /// and <code>my--namespace</code> are not valid.</p>
    /// </li>
    /// <li>
    /// <p>Not be in IP address format (for example, 192.168.5.4)</p>
    /// </li>
    /// </ul>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>Specifies the name of the Amazon S3 bucket designated for publishing log files. See <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/create_trail_naming_policy.html">Amazon S3 Bucket Naming Requirements</a>.</p>
    pub fn s3_bucket_name(&self) -> std::option::Option<&str> {
        self.s3_bucket_name.as_deref()
    }
    /// <p>Specifies the Amazon S3 key prefix that comes after the name of the bucket you have designated
    /// for log file delivery. For more information, see <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/cloudtrail-find-log-files.html">Finding Your CloudTrail Log Files</a>. The maximum length is 200 characters.</p>
    pub fn s3_key_prefix(&self) -> std::option::Option<&str> {
        self.s3_key_prefix.as_deref()
    }
    /// <p>Specifies the name of the Amazon SNS topic defined for notification of log file delivery. The maximum length is 256 characters.</p>
    pub fn sns_topic_name(&self) -> std::option::Option<&str> {
        self.sns_topic_name.as_deref()
    }
    /// <p>Specifies whether the trail is publishing events from global services such as IAM to the log files.</p>
    pub fn include_global_service_events(&self) -> std::option::Option<bool> {
        self.include_global_service_events
    }
    /// <p>Specifies whether the trail is created in the current region or in all regions. The default is false, which creates a trail only in the region where you are signed in. As a best practice, consider
    /// creating trails that log events in all regions.</p>
    pub fn is_multi_region_trail(&self) -> std::option::Option<bool> {
        self.is_multi_region_trail
    }
    /// <p>Specifies whether log file integrity validation is enabled. The default is false.</p>
    /// <note>
    /// <p>When you disable log file integrity validation, the chain of digest files is broken after one hour. CloudTrail does
    /// not create digest files for log files that were delivered during a period in which log file integrity validation was disabled.
    /// For example, if you enable log file integrity validation at noon on January 1, disable it at noon on January 2, and re-enable
    /// it at noon on January 10, digest files will not be created for the log files delivered from noon on January 2 to noon on
    /// January 10. The same applies whenever you stop CloudTrail logging or delete a trail.</p>
    /// </note>
    pub fn enable_log_file_validation(&self) -> std::option::Option<bool> {
        self.enable_log_file_validation
    }
    /// <p>Specifies a log group name using an Amazon Resource Name (ARN), a unique identifier that represents the log group
    /// to which CloudTrail logs will be delivered. Not required unless you specify <code>CloudWatchLogsRoleArn</code>.</p>
    pub fn cloud_watch_logs_log_group_arn(&self) -> std::option::Option<&str> {
        self.cloud_watch_logs_log_group_arn.as_deref()
    }
    /// <p>Specifies the role for the CloudWatch Logs endpoint to assume to write to a user's log group.</p>
    pub fn cloud_watch_logs_role_arn(&self) -> std::option::Option<&str> {
        self.cloud_watch_logs_role_arn.as_deref()
    }
    /// <p>Specifies the KMS key ID to use to encrypt the logs delivered by CloudTrail. The
    /// value can be an alias name prefixed by "alias/", a fully specified ARN to an alias, a fully
    /// specified ARN to a key, or a globally unique identifier.</p>
    /// <p>CloudTrail also supports KMS multi-Region keys. For more information about multi-Region keys,
    /// see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/multi-region-keys-overview.html">Using multi-Region keys</a> in the <i>Key Management Service Developer Guide</i>.</p>
    /// <p>Examples:</p>
    /// <ul>
    /// <li>
    /// <p>alias/MyAliasName</p>
    /// </li>
    /// <li>
    /// <p>arn:aws:kms:us-east-2:123456789012:alias/MyAliasName</p>
    /// </li>
    /// <li>
    /// <p>arn:aws:kms:us-east-2:123456789012:key/12345678-1234-1234-1234-123456789012</p>
    /// </li>
    /// <li>
    /// <p>12345678-1234-1234-1234-123456789012</p>
    /// </li>
    /// </ul>
    pub fn kms_key_id(&self) -> std::option::Option<&str> {
        self.kms_key_id.as_deref()
    }
    /// <p>Specifies whether the trail is created for all accounts in an organization in Organizations, or only for the current Amazon Web Services account.
    /// The default is false, and cannot be true unless the call is made on behalf of an Amazon Web Services account that is the management account for an organization in
    /// Organizations.</p>
    pub fn is_organization_trail(&self) -> std::option::Option<bool> {
        self.is_organization_trail
    }
    /// <p>A list of tags.</p>
    pub fn tags_list(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags_list.as_deref()
    }
}
impl std::fmt::Debug for CreateTrailInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateTrailInput");
        formatter.field("name", &self.name);
        formatter.field("s3_bucket_name", &self.s3_bucket_name);
        formatter.field("s3_key_prefix", &self.s3_key_prefix);
        formatter.field("sns_topic_name", &self.sns_topic_name);
        formatter.field(
            "include_global_service_events",
            &self.include_global_service_events,
        );
        formatter.field("is_multi_region_trail", &self.is_multi_region_trail);
        formatter.field(
            "enable_log_file_validation",
            &self.enable_log_file_validation,
        );
        formatter.field(
            "cloud_watch_logs_log_group_arn",
            &self.cloud_watch_logs_log_group_arn,
        );
        formatter.field("cloud_watch_logs_role_arn", &self.cloud_watch_logs_role_arn);
        formatter.field("kms_key_id", &self.kms_key_id);
        formatter.field("is_organization_trail", &self.is_organization_trail);
        formatter.field("tags_list", &self.tags_list);
        formatter.finish()
    }
}

/// <p>Specifies the tags to add to a trail.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AddTagsInput {
    /// <p>Specifies the ARN of the trail to which one or more tags will be added. The format of a trail ARN is:</p>
    /// <p>
    /// <code>arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail</code>
    /// </p>
    pub resource_id: std::option::Option<std::string::String>,
    /// <p>Contains a list of tags, up to a limit of 50</p>
    pub tags_list: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl AddTagsInput {
    /// <p>Specifies the ARN of the trail to which one or more tags will be added. The format of a trail ARN is:</p>
    /// <p>
    /// <code>arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail</code>
    /// </p>
    pub fn resource_id(&self) -> std::option::Option<&str> {
        self.resource_id.as_deref()
    }
    /// <p>Contains a list of tags, up to a limit of 50</p>
    pub fn tags_list(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags_list.as_deref()
    }
}
impl std::fmt::Debug for AddTagsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AddTagsInput");
        formatter.field("resource_id", &self.resource_id);
        formatter.field("tags_list", &self.tags_list);
        formatter.finish()
    }
}
