// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// <p>Returns the objects or data listed below if successful. Otherwise, returns an error.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateTrailOutput {
    /// <p>Specifies the name of the trail.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>Specifies the name of the Amazon S3 bucket designated for publishing log files.</p>
    pub s3_bucket_name: std::option::Option<std::string::String>,
    /// <p>Specifies the Amazon S3 key prefix that comes after the name of the bucket you have designated
    /// for log file delivery.
    /// For more information, see <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/cloudtrail-find-log-files.html">Finding Your IAM Log Files</a>.</p>
    pub s3_key_prefix: std::option::Option<std::string::String>,
    /// <p>This field is no longer in use. Use <a>UpdateTrailResponse$SnsTopicARN</a>.</p>
    pub sns_topic_name: std::option::Option<std::string::String>,
    /// <p>Specifies the ARN of the Amazon SNS topic that CloudTrail uses to send notifications
    /// when log files are delivered. The following is the format of a topic ARN.</p>
    /// <p>
    /// <code>arn:aws:sns:us-east-2:123456789012:MyTopic</code>
    /// </p>
    pub sns_topic_arn: std::option::Option<std::string::String>,
    /// <p>Specifies whether the trail is publishing events from global services such as IAM to the log files.</p>
    pub include_global_service_events: std::option::Option<bool>,
    /// <p>Specifies whether the trail exists in one region or in all regions.</p>
    pub is_multi_region_trail: std::option::Option<bool>,
    /// <p>Specifies the ARN of the trail that was updated. The following is the format of a trail ARN.</p>
    /// <p>
    /// <code>arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail</code>
    /// </p>
    pub trail_arn: std::option::Option<std::string::String>,
    /// <p>Specifies whether log file integrity validation is enabled.</p>
    pub log_file_validation_enabled: std::option::Option<bool>,
    /// <p>Specifies the Amazon Resource Name (ARN) of the log group to which CloudTrail logs are delivered.</p>
    pub cloud_watch_logs_log_group_arn: std::option::Option<std::string::String>,
    /// <p>Specifies the role for the CloudWatch Logs endpoint to assume to write to a user's log group.</p>
    pub cloud_watch_logs_role_arn: std::option::Option<std::string::String>,
    /// <p>Specifies the KMS key ID that encrypts the logs delivered by CloudTrail. The value is a fully specified ARN to a KMS key in the following format.</p>
    ///
    /// <p>
    /// <code>arn:aws:kms:us-east-2:123456789012:key/12345678-1234-1234-1234-123456789012</code>
    /// </p>
    pub kms_key_id: std::option::Option<std::string::String>,
    /// <p>Specifies whether the trail is an organization trail.</p>
    pub is_organization_trail: std::option::Option<bool>,
}
impl std::fmt::Debug for UpdateTrailOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateTrailOutput");
        formatter.field("name", &self.name);
        formatter.field("s3_bucket_name", &self.s3_bucket_name);
        formatter.field("s3_key_prefix", &self.s3_key_prefix);
        formatter.field("sns_topic_name", &self.sns_topic_name);
        formatter.field("sns_topic_arn", &self.sns_topic_arn);
        formatter.field(
            "include_global_service_events",
            &self.include_global_service_events,
        );
        formatter.field("is_multi_region_trail", &self.is_multi_region_trail);
        formatter.field("trail_arn", &self.trail_arn);
        formatter.field(
            "log_file_validation_enabled",
            &self.log_file_validation_enabled,
        );
        formatter.field(
            "cloud_watch_logs_log_group_arn",
            &self.cloud_watch_logs_log_group_arn,
        );
        formatter.field("cloud_watch_logs_role_arn", &self.cloud_watch_logs_role_arn);
        formatter.field("kms_key_id", &self.kms_key_id);
        formatter.field("is_organization_trail", &self.is_organization_trail);
        formatter.finish()
    }
}
/// See [`UpdateTrailOutput`](crate::output::UpdateTrailOutput)
pub mod update_trail_output {
    /// A builder for [`UpdateTrailOutput`](crate::output::UpdateTrailOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) s3_bucket_name: std::option::Option<std::string::String>,
        pub(crate) s3_key_prefix: std::option::Option<std::string::String>,
        pub(crate) sns_topic_name: std::option::Option<std::string::String>,
        pub(crate) sns_topic_arn: std::option::Option<std::string::String>,
        pub(crate) include_global_service_events: std::option::Option<bool>,
        pub(crate) is_multi_region_trail: std::option::Option<bool>,
        pub(crate) trail_arn: std::option::Option<std::string::String>,
        pub(crate) log_file_validation_enabled: std::option::Option<bool>,
        pub(crate) cloud_watch_logs_log_group_arn: std::option::Option<std::string::String>,
        pub(crate) cloud_watch_logs_role_arn: std::option::Option<std::string::String>,
        pub(crate) kms_key_id: std::option::Option<std::string::String>,
        pub(crate) is_organization_trail: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>Specifies the name of the trail.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>Specifies the name of the trail.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>Specifies the name of the Amazon S3 bucket designated for publishing log files.</p>
        pub fn s3_bucket_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.s3_bucket_name = Some(input.into());
            self
        }
        /// <p>Specifies the name of the Amazon S3 bucket designated for publishing log files.</p>
        pub fn set_s3_bucket_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.s3_bucket_name = input;
            self
        }
        /// <p>Specifies the Amazon S3 key prefix that comes after the name of the bucket you have designated
        /// for log file delivery.
        /// For more information, see <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/cloudtrail-find-log-files.html">Finding Your IAM Log Files</a>.</p>
        pub fn s3_key_prefix(mut self, input: impl Into<std::string::String>) -> Self {
            self.s3_key_prefix = Some(input.into());
            self
        }
        /// <p>Specifies the Amazon S3 key prefix that comes after the name of the bucket you have designated
        /// for log file delivery.
        /// For more information, see <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/cloudtrail-find-log-files.html">Finding Your IAM Log Files</a>.</p>
        pub fn set_s3_key_prefix(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.s3_key_prefix = input;
            self
        }
        /// <p>This field is no longer in use. Use <a>UpdateTrailResponse$SnsTopicARN</a>.</p>
        pub fn sns_topic_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.sns_topic_name = Some(input.into());
            self
        }
        /// <p>This field is no longer in use. Use <a>UpdateTrailResponse$SnsTopicARN</a>.</p>
        pub fn set_sns_topic_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.sns_topic_name = input;
            self
        }
        /// <p>Specifies the ARN of the Amazon SNS topic that CloudTrail uses to send notifications
        /// when log files are delivered. The following is the format of a topic ARN.</p>
        /// <p>
        /// <code>arn:aws:sns:us-east-2:123456789012:MyTopic</code>
        /// </p>
        pub fn sns_topic_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.sns_topic_arn = Some(input.into());
            self
        }
        /// <p>Specifies the ARN of the Amazon SNS topic that CloudTrail uses to send notifications
        /// when log files are delivered. The following is the format of a topic ARN.</p>
        /// <p>
        /// <code>arn:aws:sns:us-east-2:123456789012:MyTopic</code>
        /// </p>
        pub fn set_sns_topic_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.sns_topic_arn = input;
            self
        }
        /// <p>Specifies whether the trail is publishing events from global services such as IAM to the log files.</p>
        pub fn include_global_service_events(mut self, input: bool) -> Self {
            self.include_global_service_events = Some(input);
            self
        }
        /// <p>Specifies whether the trail is publishing events from global services such as IAM to the log files.</p>
        pub fn set_include_global_service_events(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.include_global_service_events = input;
            self
        }
        /// <p>Specifies whether the trail exists in one region or in all regions.</p>
        pub fn is_multi_region_trail(mut self, input: bool) -> Self {
            self.is_multi_region_trail = Some(input);
            self
        }
        /// <p>Specifies whether the trail exists in one region or in all regions.</p>
        pub fn set_is_multi_region_trail(mut self, input: std::option::Option<bool>) -> Self {
            self.is_multi_region_trail = input;
            self
        }
        /// <p>Specifies the ARN of the trail that was updated. The following is the format of a trail ARN.</p>
        /// <p>
        /// <code>arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail</code>
        /// </p>
        pub fn trail_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.trail_arn = Some(input.into());
            self
        }
        /// <p>Specifies the ARN of the trail that was updated. The following is the format of a trail ARN.</p>
        /// <p>
        /// <code>arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail</code>
        /// </p>
        pub fn set_trail_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.trail_arn = input;
            self
        }
        /// <p>Specifies whether log file integrity validation is enabled.</p>
        pub fn log_file_validation_enabled(mut self, input: bool) -> Self {
            self.log_file_validation_enabled = Some(input);
            self
        }
        /// <p>Specifies whether log file integrity validation is enabled.</p>
        pub fn set_log_file_validation_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.log_file_validation_enabled = input;
            self
        }
        /// <p>Specifies the Amazon Resource Name (ARN) of the log group to which CloudTrail logs are delivered.</p>
        pub fn cloud_watch_logs_log_group_arn(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.cloud_watch_logs_log_group_arn = Some(input.into());
            self
        }
        /// <p>Specifies the Amazon Resource Name (ARN) of the log group to which CloudTrail logs are delivered.</p>
        pub fn set_cloud_watch_logs_log_group_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.cloud_watch_logs_log_group_arn = input;
            self
        }
        /// <p>Specifies the role for the CloudWatch Logs endpoint to assume to write to a user's log group.</p>
        pub fn cloud_watch_logs_role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.cloud_watch_logs_role_arn = Some(input.into());
            self
        }
        /// <p>Specifies the role for the CloudWatch Logs endpoint to assume to write to a user's log group.</p>
        pub fn set_cloud_watch_logs_role_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.cloud_watch_logs_role_arn = input;
            self
        }
        /// <p>Specifies the KMS key ID that encrypts the logs delivered by CloudTrail. The value is a fully specified ARN to a KMS key in the following format.</p>
        ///
        /// <p>
        /// <code>arn:aws:kms:us-east-2:123456789012:key/12345678-1234-1234-1234-123456789012</code>
        /// </p>
        pub fn kms_key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.kms_key_id = Some(input.into());
            self
        }
        /// <p>Specifies the KMS key ID that encrypts the logs delivered by CloudTrail. The value is a fully specified ARN to a KMS key in the following format.</p>
        ///
        /// <p>
        /// <code>arn:aws:kms:us-east-2:123456789012:key/12345678-1234-1234-1234-123456789012</code>
        /// </p>
        pub fn set_kms_key_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.kms_key_id = input;
            self
        }
        /// <p>Specifies whether the trail is an organization trail.</p>
        pub fn is_organization_trail(mut self, input: bool) -> Self {
            self.is_organization_trail = Some(input);
            self
        }
        /// <p>Specifies whether the trail is an organization trail.</p>
        pub fn set_is_organization_trail(mut self, input: std::option::Option<bool>) -> Self {
            self.is_organization_trail = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateTrailOutput`](crate::output::UpdateTrailOutput)
        pub fn build(self) -> crate::output::UpdateTrailOutput {
            crate::output::UpdateTrailOutput {
                name: self.name,
                s3_bucket_name: self.s3_bucket_name,
                s3_key_prefix: self.s3_key_prefix,
                sns_topic_name: self.sns_topic_name,
                sns_topic_arn: self.sns_topic_arn,
                include_global_service_events: self.include_global_service_events,
                is_multi_region_trail: self.is_multi_region_trail,
                trail_arn: self.trail_arn,
                log_file_validation_enabled: self.log_file_validation_enabled,
                cloud_watch_logs_log_group_arn: self.cloud_watch_logs_log_group_arn,
                cloud_watch_logs_role_arn: self.cloud_watch_logs_role_arn,
                kms_key_id: self.kms_key_id,
                is_organization_trail: self.is_organization_trail,
            }
        }
    }
}
impl UpdateTrailOutput {
    /// Creates a new builder-style object to manufacture [`UpdateTrailOutput`](crate::output::UpdateTrailOutput)
    pub fn builder() -> crate::output::update_trail_output::Builder {
        crate::output::update_trail_output::Builder::default()
    }
}

/// <p>Returns the objects or data listed below if successful. Otherwise, returns an error.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StopLoggingOutput {}
impl std::fmt::Debug for StopLoggingOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StopLoggingOutput");
        formatter.finish()
    }
}
/// See [`StopLoggingOutput`](crate::output::StopLoggingOutput)
pub mod stop_logging_output {
    /// A builder for [`StopLoggingOutput`](crate::output::StopLoggingOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`StopLoggingOutput`](crate::output::StopLoggingOutput)
        pub fn build(self) -> crate::output::StopLoggingOutput {
            crate::output::StopLoggingOutput {}
        }
    }
}
impl StopLoggingOutput {
    /// Creates a new builder-style object to manufacture [`StopLoggingOutput`](crate::output::StopLoggingOutput)
    pub fn builder() -> crate::output::stop_logging_output::Builder {
        crate::output::stop_logging_output::Builder::default()
    }
}

/// <p>Returns the objects or data listed below if successful. Otherwise, returns an error.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StartLoggingOutput {}
impl std::fmt::Debug for StartLoggingOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StartLoggingOutput");
        formatter.finish()
    }
}
/// See [`StartLoggingOutput`](crate::output::StartLoggingOutput)
pub mod start_logging_output {
    /// A builder for [`StartLoggingOutput`](crate::output::StartLoggingOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`StartLoggingOutput`](crate::output::StartLoggingOutput)
        pub fn build(self) -> crate::output::StartLoggingOutput {
            crate::output::StartLoggingOutput {}
        }
    }
}
impl StartLoggingOutput {
    /// Creates a new builder-style object to manufacture [`StartLoggingOutput`](crate::output::StartLoggingOutput)
    pub fn builder() -> crate::output::start_logging_output::Builder {
        crate::output::start_logging_output::Builder::default()
    }
}

/// <p>Returns the objects or data listed below if successful. Otherwise, returns an error.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RemoveTagsOutput {}
impl std::fmt::Debug for RemoveTagsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RemoveTagsOutput");
        formatter.finish()
    }
}
/// See [`RemoveTagsOutput`](crate::output::RemoveTagsOutput)
pub mod remove_tags_output {
    /// A builder for [`RemoveTagsOutput`](crate::output::RemoveTagsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`RemoveTagsOutput`](crate::output::RemoveTagsOutput)
        pub fn build(self) -> crate::output::RemoveTagsOutput {
            crate::output::RemoveTagsOutput {}
        }
    }
}
impl RemoveTagsOutput {
    /// Creates a new builder-style object to manufacture [`RemoveTagsOutput`](crate::output::RemoveTagsOutput)
    pub fn builder() -> crate::output::remove_tags_output::Builder {
        crate::output::remove_tags_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutInsightSelectorsOutput {
    /// <p>The Amazon Resource Name (ARN) of a trail for which you want to change or add Insights selectors.</p>
    pub trail_arn: std::option::Option<std::string::String>,
    /// <p>A JSON string that contains the Insights event types that you want to log on a trail. The valid Insights type in this release is <code>ApiCallRateInsight</code>.</p>
    pub insight_selectors: std::option::Option<std::vec::Vec<crate::model::InsightSelector>>,
}
impl std::fmt::Debug for PutInsightSelectorsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutInsightSelectorsOutput");
        formatter.field("trail_arn", &self.trail_arn);
        formatter.field("insight_selectors", &self.insight_selectors);
        formatter.finish()
    }
}
/// See [`PutInsightSelectorsOutput`](crate::output::PutInsightSelectorsOutput)
pub mod put_insight_selectors_output {
    /// A builder for [`PutInsightSelectorsOutput`](crate::output::PutInsightSelectorsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) trail_arn: std::option::Option<std::string::String>,
        pub(crate) insight_selectors:
            std::option::Option<std::vec::Vec<crate::model::InsightSelector>>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of a trail for which you want to change or add Insights selectors.</p>
        pub fn trail_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.trail_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of a trail for which you want to change or add Insights selectors.</p>
        pub fn set_trail_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.trail_arn = input;
            self
        }
        /// Appends an item to `insight_selectors`.
        ///
        /// To override the contents of this collection use [`set_insight_selectors`](Self::set_insight_selectors).
        ///
        /// <p>A JSON string that contains the Insights event types that you want to log on a trail. The valid Insights type in this release is <code>ApiCallRateInsight</code>.</p>
        pub fn insight_selectors(
            mut self,
            input: impl Into<crate::model::InsightSelector>,
        ) -> Self {
            let mut v = self.insight_selectors.unwrap_or_default();
            v.push(input.into());
            self.insight_selectors = Some(v);
            self
        }
        /// <p>A JSON string that contains the Insights event types that you want to log on a trail. The valid Insights type in this release is <code>ApiCallRateInsight</code>.</p>
        pub fn set_insight_selectors(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::InsightSelector>>,
        ) -> Self {
            self.insight_selectors = input;
            self
        }
        /// Consumes the builder and constructs a [`PutInsightSelectorsOutput`](crate::output::PutInsightSelectorsOutput)
        pub fn build(self) -> crate::output::PutInsightSelectorsOutput {
            crate::output::PutInsightSelectorsOutput {
                trail_arn: self.trail_arn,
                insight_selectors: self.insight_selectors,
            }
        }
    }
}
impl PutInsightSelectorsOutput {
    /// Creates a new builder-style object to manufacture [`PutInsightSelectorsOutput`](crate::output::PutInsightSelectorsOutput)
    pub fn builder() -> crate::output::put_insight_selectors_output::Builder {
        crate::output::put_insight_selectors_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutEventSelectorsOutput {
    /// <p>Specifies the ARN of the trail that was updated with event selectors. The following is the format of a trail ARN.</p>
    /// <p>
    /// <code>arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail</code>
    /// </p>
    pub trail_arn: std::option::Option<std::string::String>,
    /// <p>Specifies the event selectors configured for your trail.</p>
    pub event_selectors: std::option::Option<std::vec::Vec<crate::model::EventSelector>>,
    /// <p>Specifies the advanced event selectors configured for your trail.</p>
    pub advanced_event_selectors:
        std::option::Option<std::vec::Vec<crate::model::AdvancedEventSelector>>,
}
impl std::fmt::Debug for PutEventSelectorsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutEventSelectorsOutput");
        formatter.field("trail_arn", &self.trail_arn);
        formatter.field("event_selectors", &self.event_selectors);
        formatter.field("advanced_event_selectors", &self.advanced_event_selectors);
        formatter.finish()
    }
}
/// See [`PutEventSelectorsOutput`](crate::output::PutEventSelectorsOutput)
pub mod put_event_selectors_output {
    /// A builder for [`PutEventSelectorsOutput`](crate::output::PutEventSelectorsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) trail_arn: std::option::Option<std::string::String>,
        pub(crate) event_selectors: std::option::Option<std::vec::Vec<crate::model::EventSelector>>,
        pub(crate) advanced_event_selectors:
            std::option::Option<std::vec::Vec<crate::model::AdvancedEventSelector>>,
    }
    impl Builder {
        /// <p>Specifies the ARN of the trail that was updated with event selectors. The following is the format of a trail ARN.</p>
        /// <p>
        /// <code>arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail</code>
        /// </p>
        pub fn trail_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.trail_arn = Some(input.into());
            self
        }
        /// <p>Specifies the ARN of the trail that was updated with event selectors. The following is the format of a trail ARN.</p>
        /// <p>
        /// <code>arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail</code>
        /// </p>
        pub fn set_trail_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.trail_arn = input;
            self
        }
        /// Appends an item to `event_selectors`.
        ///
        /// To override the contents of this collection use [`set_event_selectors`](Self::set_event_selectors).
        ///
        /// <p>Specifies the event selectors configured for your trail.</p>
        pub fn event_selectors(mut self, input: impl Into<crate::model::EventSelector>) -> Self {
            let mut v = self.event_selectors.unwrap_or_default();
            v.push(input.into());
            self.event_selectors = Some(v);
            self
        }
        /// <p>Specifies the event selectors configured for your trail.</p>
        pub fn set_event_selectors(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::EventSelector>>,
        ) -> Self {
            self.event_selectors = input;
            self
        }
        /// Appends an item to `advanced_event_selectors`.
        ///
        /// To override the contents of this collection use [`set_advanced_event_selectors`](Self::set_advanced_event_selectors).
        ///
        /// <p>Specifies the advanced event selectors configured for your trail.</p>
        pub fn advanced_event_selectors(
            mut self,
            input: impl Into<crate::model::AdvancedEventSelector>,
        ) -> Self {
            let mut v = self.advanced_event_selectors.unwrap_or_default();
            v.push(input.into());
            self.advanced_event_selectors = Some(v);
            self
        }
        /// <p>Specifies the advanced event selectors configured for your trail.</p>
        pub fn set_advanced_event_selectors(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AdvancedEventSelector>>,
        ) -> Self {
            self.advanced_event_selectors = input;
            self
        }
        /// Consumes the builder and constructs a [`PutEventSelectorsOutput`](crate::output::PutEventSelectorsOutput)
        pub fn build(self) -> crate::output::PutEventSelectorsOutput {
            crate::output::PutEventSelectorsOutput {
                trail_arn: self.trail_arn,
                event_selectors: self.event_selectors,
                advanced_event_selectors: self.advanced_event_selectors,
            }
        }
    }
}
impl PutEventSelectorsOutput {
    /// Creates a new builder-style object to manufacture [`PutEventSelectorsOutput`](crate::output::PutEventSelectorsOutput)
    pub fn builder() -> crate::output::put_event_selectors_output::Builder {
        crate::output::put_event_selectors_output::Builder::default()
    }
}

/// <p>Contains a response to a LookupEvents action.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LookupEventsOutput {
    /// <p>A list of events returned based on the lookup attributes specified and the CloudTrail event. The events list is sorted by time. The most recent event is listed first.</p>
    pub events: std::option::Option<std::vec::Vec<crate::model::Event>>,
    /// <p>The token to use to get the next page of results after a previous API call. If the token does not appear,
    /// there are no more results to return. The token must be passed in with the same parameters as the previous call.
    /// For example, if the original call specified an AttributeKey of 'Username' with a value of 'root', the call with
    /// NextToken should include those same parameters.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for LookupEventsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LookupEventsOutput");
        formatter.field("events", &self.events);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`LookupEventsOutput`](crate::output::LookupEventsOutput)
pub mod lookup_events_output {
    /// A builder for [`LookupEventsOutput`](crate::output::LookupEventsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) events: std::option::Option<std::vec::Vec<crate::model::Event>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `events`.
        ///
        /// To override the contents of this collection use [`set_events`](Self::set_events).
        ///
        /// <p>A list of events returned based on the lookup attributes specified and the CloudTrail event. The events list is sorted by time. The most recent event is listed first.</p>
        pub fn events(mut self, input: impl Into<crate::model::Event>) -> Self {
            let mut v = self.events.unwrap_or_default();
            v.push(input.into());
            self.events = Some(v);
            self
        }
        /// <p>A list of events returned based on the lookup attributes specified and the CloudTrail event. The events list is sorted by time. The most recent event is listed first.</p>
        pub fn set_events(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Event>>,
        ) -> Self {
            self.events = input;
            self
        }
        /// <p>The token to use to get the next page of results after a previous API call. If the token does not appear,
        /// there are no more results to return. The token must be passed in with the same parameters as the previous call.
        /// For example, if the original call specified an AttributeKey of 'Username' with a value of 'root', the call with
        /// NextToken should include those same parameters.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token to use to get the next page of results after a previous API call. If the token does not appear,
        /// there are no more results to return. The token must be passed in with the same parameters as the previous call.
        /// For example, if the original call specified an AttributeKey of 'Username' with a value of 'root', the call with
        /// NextToken should include those same parameters.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`LookupEventsOutput`](crate::output::LookupEventsOutput)
        pub fn build(self) -> crate::output::LookupEventsOutput {
            crate::output::LookupEventsOutput {
                events: self.events,
                next_token: self.next_token,
            }
        }
    }
}
impl LookupEventsOutput {
    /// Creates a new builder-style object to manufacture [`LookupEventsOutput`](crate::output::LookupEventsOutput)
    pub fn builder() -> crate::output::lookup_events_output::Builder {
        crate::output::lookup_events_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTrailsOutput {
    /// <p>Returns the name, ARN, and home region of trails in the current account.</p>
    pub trails: std::option::Option<std::vec::Vec<crate::model::TrailInfo>>,
    /// <p>The token to use to get the next page of results after a previous API call. If the token does not appear,
    /// there are no more results to return. The token must be passed in with the same parameters as the previous call.
    /// For example, if the original call specified an AttributeKey of 'Username' with a value of 'root', the call with
    /// NextToken should include those same parameters.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ListTrailsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTrailsOutput");
        formatter.field("trails", &self.trails);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListTrailsOutput`](crate::output::ListTrailsOutput)
pub mod list_trails_output {
    /// A builder for [`ListTrailsOutput`](crate::output::ListTrailsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) trails: std::option::Option<std::vec::Vec<crate::model::TrailInfo>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `trails`.
        ///
        /// To override the contents of this collection use [`set_trails`](Self::set_trails).
        ///
        /// <p>Returns the name, ARN, and home region of trails in the current account.</p>
        pub fn trails(mut self, input: impl Into<crate::model::TrailInfo>) -> Self {
            let mut v = self.trails.unwrap_or_default();
            v.push(input.into());
            self.trails = Some(v);
            self
        }
        /// <p>Returns the name, ARN, and home region of trails in the current account.</p>
        pub fn set_trails(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TrailInfo>>,
        ) -> Self {
            self.trails = input;
            self
        }
        /// <p>The token to use to get the next page of results after a previous API call. If the token does not appear,
        /// there are no more results to return. The token must be passed in with the same parameters as the previous call.
        /// For example, if the original call specified an AttributeKey of 'Username' with a value of 'root', the call with
        /// NextToken should include those same parameters.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token to use to get the next page of results after a previous API call. If the token does not appear,
        /// there are no more results to return. The token must be passed in with the same parameters as the previous call.
        /// For example, if the original call specified an AttributeKey of 'Username' with a value of 'root', the call with
        /// NextToken should include those same parameters.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTrailsOutput`](crate::output::ListTrailsOutput)
        pub fn build(self) -> crate::output::ListTrailsOutput {
            crate::output::ListTrailsOutput {
                trails: self.trails,
                next_token: self.next_token,
            }
        }
    }
}
impl ListTrailsOutput {
    /// Creates a new builder-style object to manufacture [`ListTrailsOutput`](crate::output::ListTrailsOutput)
    pub fn builder() -> crate::output::list_trails_output::Builder {
        crate::output::list_trails_output::Builder::default()
    }
}

/// <p>Returns the objects or data listed below if successful. Otherwise, returns an error.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTagsOutput {
    /// <p>A list of resource tags.</p>
    pub resource_tag_list: std::option::Option<std::vec::Vec<crate::model::ResourceTag>>,
    /// <p>Reserved for future use.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ListTagsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTagsOutput");
        formatter.field("resource_tag_list", &self.resource_tag_list);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListTagsOutput`](crate::output::ListTagsOutput)
pub mod list_tags_output {
    /// A builder for [`ListTagsOutput`](crate::output::ListTagsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_tag_list: std::option::Option<std::vec::Vec<crate::model::ResourceTag>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `resource_tag_list`.
        ///
        /// To override the contents of this collection use [`set_resource_tag_list`](Self::set_resource_tag_list).
        ///
        /// <p>A list of resource tags.</p>
        pub fn resource_tag_list(mut self, input: impl Into<crate::model::ResourceTag>) -> Self {
            let mut v = self.resource_tag_list.unwrap_or_default();
            v.push(input.into());
            self.resource_tag_list = Some(v);
            self
        }
        /// <p>A list of resource tags.</p>
        pub fn set_resource_tag_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ResourceTag>>,
        ) -> Self {
            self.resource_tag_list = input;
            self
        }
        /// <p>Reserved for future use.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>Reserved for future use.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTagsOutput`](crate::output::ListTagsOutput)
        pub fn build(self) -> crate::output::ListTagsOutput {
            crate::output::ListTagsOutput {
                resource_tag_list: self.resource_tag_list,
                next_token: self.next_token,
            }
        }
    }
}
impl ListTagsOutput {
    /// Creates a new builder-style object to manufacture [`ListTagsOutput`](crate::output::ListTagsOutput)
    pub fn builder() -> crate::output::list_tags_output::Builder {
        crate::output::list_tags_output::Builder::default()
    }
}

/// <p>Returns the objects or data listed below if successful. Otherwise, returns an error.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListPublicKeysOutput {
    /// <p>Contains an array of PublicKey objects.</p>
    /// <note>
    /// <p>The returned public keys may have validity time ranges that overlap.</p>
    /// </note>
    pub public_key_list: std::option::Option<std::vec::Vec<crate::model::PublicKey>>,
    /// <p>Reserved for future use.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ListPublicKeysOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListPublicKeysOutput");
        formatter.field("public_key_list", &self.public_key_list);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListPublicKeysOutput`](crate::output::ListPublicKeysOutput)
pub mod list_public_keys_output {
    /// A builder for [`ListPublicKeysOutput`](crate::output::ListPublicKeysOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) public_key_list: std::option::Option<std::vec::Vec<crate::model::PublicKey>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `public_key_list`.
        ///
        /// To override the contents of this collection use [`set_public_key_list`](Self::set_public_key_list).
        ///
        /// <p>Contains an array of PublicKey objects.</p>
        /// <note>
        /// <p>The returned public keys may have validity time ranges that overlap.</p>
        /// </note>
        pub fn public_key_list(mut self, input: impl Into<crate::model::PublicKey>) -> Self {
            let mut v = self.public_key_list.unwrap_or_default();
            v.push(input.into());
            self.public_key_list = Some(v);
            self
        }
        /// <p>Contains an array of PublicKey objects.</p>
        /// <note>
        /// <p>The returned public keys may have validity time ranges that overlap.</p>
        /// </note>
        pub fn set_public_key_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PublicKey>>,
        ) -> Self {
            self.public_key_list = input;
            self
        }
        /// <p>Reserved for future use.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>Reserved for future use.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListPublicKeysOutput`](crate::output::ListPublicKeysOutput)
        pub fn build(self) -> crate::output::ListPublicKeysOutput {
            crate::output::ListPublicKeysOutput {
                public_key_list: self.public_key_list,
                next_token: self.next_token,
            }
        }
    }
}
impl ListPublicKeysOutput {
    /// Creates a new builder-style object to manufacture [`ListPublicKeysOutput`](crate::output::ListPublicKeysOutput)
    pub fn builder() -> crate::output::list_public_keys_output::Builder {
        crate::output::list_public_keys_output::Builder::default()
    }
}

/// <p>Returns the objects or data listed below if successful. Otherwise, returns an error.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetTrailStatusOutput {
    /// <p>Whether the CloudTrail trail is currently logging Amazon Web Services API calls.</p>
    pub is_logging: std::option::Option<bool>,
    /// <p>Displays any Amazon S3 error that CloudTrail encountered when attempting to deliver log files
    /// to the designated bucket. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/ErrorResponses.html">Error
    /// Responses</a> in the Amazon S3 API Reference. </p>
    /// <note>
    /// <p>This error occurs only when there is a problem with the destination S3 bucket, and does
    /// not occur for requests that time out. To resolve the issue, create a new bucket, and then call
    /// <code>UpdateTrail</code> to specify the new bucket; or fix the existing objects so that
    /// CloudTrail can again write to the bucket.</p>
    /// </note>
    pub latest_delivery_error: std::option::Option<std::string::String>,
    /// <p>Displays any Amazon SNS error that CloudTrail encountered when attempting to send a
    /// notification. For more information about Amazon SNS errors, see the <a href="https://docs.aws.amazon.com/sns/latest/dg/welcome.html">Amazon SNS Developer Guide</a>.
    /// </p>
    pub latest_notification_error: std::option::Option<std::string::String>,
    /// <p>Specifies the date and time that CloudTrail last delivered log files to an account's Amazon S3 bucket.</p>
    pub latest_delivery_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>Specifies the date and time of the most recent Amazon SNS notification that CloudTrail has written a new log file to an account's Amazon S3 bucket.</p>
    pub latest_notification_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>Specifies the most recent date and time when CloudTrail started recording API calls for an Amazon Web Services account.</p>
    pub start_logging_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>Specifies the most recent date and time when CloudTrail stopped recording API calls for an Amazon Web Services account.</p>
    pub stop_logging_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>Displays any CloudWatch Logs error that CloudTrail encountered when attempting to deliver logs to CloudWatch Logs.</p>
    pub latest_cloud_watch_logs_delivery_error: std::option::Option<std::string::String>,
    /// <p>Displays the most recent date and time when CloudTrail delivered logs to CloudWatch Logs.</p>
    pub latest_cloud_watch_logs_delivery_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>Specifies the date and time that CloudTrail last delivered a digest file to an account's Amazon S3 bucket.</p>
    pub latest_digest_delivery_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>Displays any Amazon S3 error that CloudTrail encountered when attempting to deliver a digest
    /// file to the designated bucket. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/ErrorResponses.html">Error
    /// Responses</a> in the Amazon S3 API Reference. </p>
    /// <note>
    /// <p>This error occurs only when there is a problem with the destination S3 bucket, and does
    /// not occur for requests that time out. To resolve the issue, create a new bucket, and then call
    /// <code>UpdateTrail</code> to specify the new bucket; or fix the existing objects so that
    /// CloudTrail can again write to the bucket.</p>
    /// </note>
    pub latest_digest_delivery_error: std::option::Option<std::string::String>,
    /// <p>This field is no longer in use.</p>
    pub latest_delivery_attempt_time: std::option::Option<std::string::String>,
    /// <p>This field is no longer in use.</p>
    pub latest_notification_attempt_time: std::option::Option<std::string::String>,
    /// <p>This field is no longer in use.</p>
    pub latest_notification_attempt_succeeded: std::option::Option<std::string::String>,
    /// <p>This field is no longer in use.</p>
    pub latest_delivery_attempt_succeeded: std::option::Option<std::string::String>,
    /// <p>This field is no longer in use.</p>
    pub time_logging_started: std::option::Option<std::string::String>,
    /// <p>This field is no longer in use.</p>
    pub time_logging_stopped: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for GetTrailStatusOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetTrailStatusOutput");
        formatter.field("is_logging", &self.is_logging);
        formatter.field("latest_delivery_error", &self.latest_delivery_error);
        formatter.field("latest_notification_error", &self.latest_notification_error);
        formatter.field("latest_delivery_time", &self.latest_delivery_time);
        formatter.field("latest_notification_time", &self.latest_notification_time);
        formatter.field("start_logging_time", &self.start_logging_time);
        formatter.field("stop_logging_time", &self.stop_logging_time);
        formatter.field(
            "latest_cloud_watch_logs_delivery_error",
            &self.latest_cloud_watch_logs_delivery_error,
        );
        formatter.field(
            "latest_cloud_watch_logs_delivery_time",
            &self.latest_cloud_watch_logs_delivery_time,
        );
        formatter.field(
            "latest_digest_delivery_time",
            &self.latest_digest_delivery_time,
        );
        formatter.field(
            "latest_digest_delivery_error",
            &self.latest_digest_delivery_error,
        );
        formatter.field(
            "latest_delivery_attempt_time",
            &self.latest_delivery_attempt_time,
        );
        formatter.field(
            "latest_notification_attempt_time",
            &self.latest_notification_attempt_time,
        );
        formatter.field(
            "latest_notification_attempt_succeeded",
            &self.latest_notification_attempt_succeeded,
        );
        formatter.field(
            "latest_delivery_attempt_succeeded",
            &self.latest_delivery_attempt_succeeded,
        );
        formatter.field("time_logging_started", &self.time_logging_started);
        formatter.field("time_logging_stopped", &self.time_logging_stopped);
        formatter.finish()
    }
}
/// See [`GetTrailStatusOutput`](crate::output::GetTrailStatusOutput)
pub mod get_trail_status_output {
    /// A builder for [`GetTrailStatusOutput`](crate::output::GetTrailStatusOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) is_logging: std::option::Option<bool>,
        pub(crate) latest_delivery_error: std::option::Option<std::string::String>,
        pub(crate) latest_notification_error: std::option::Option<std::string::String>,
        pub(crate) latest_delivery_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) latest_notification_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) start_logging_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) stop_logging_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) latest_cloud_watch_logs_delivery_error: std::option::Option<std::string::String>,
        pub(crate) latest_cloud_watch_logs_delivery_time:
            std::option::Option<aws_smithy_types::Instant>,
        pub(crate) latest_digest_delivery_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) latest_digest_delivery_error: std::option::Option<std::string::String>,
        pub(crate) latest_delivery_attempt_time: std::option::Option<std::string::String>,
        pub(crate) latest_notification_attempt_time: std::option::Option<std::string::String>,
        pub(crate) latest_notification_attempt_succeeded: std::option::Option<std::string::String>,
        pub(crate) latest_delivery_attempt_succeeded: std::option::Option<std::string::String>,
        pub(crate) time_logging_started: std::option::Option<std::string::String>,
        pub(crate) time_logging_stopped: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Whether the CloudTrail trail is currently logging Amazon Web Services API calls.</p>
        pub fn is_logging(mut self, input: bool) -> Self {
            self.is_logging = Some(input);
            self
        }
        /// <p>Whether the CloudTrail trail is currently logging Amazon Web Services API calls.</p>
        pub fn set_is_logging(mut self, input: std::option::Option<bool>) -> Self {
            self.is_logging = input;
            self
        }
        /// <p>Displays any Amazon S3 error that CloudTrail encountered when attempting to deliver log files
        /// to the designated bucket. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/ErrorResponses.html">Error
        /// Responses</a> in the Amazon S3 API Reference. </p>
        /// <note>
        /// <p>This error occurs only when there is a problem with the destination S3 bucket, and does
        /// not occur for requests that time out. To resolve the issue, create a new bucket, and then call
        /// <code>UpdateTrail</code> to specify the new bucket; or fix the existing objects so that
        /// CloudTrail can again write to the bucket.</p>
        /// </note>
        pub fn latest_delivery_error(mut self, input: impl Into<std::string::String>) -> Self {
            self.latest_delivery_error = Some(input.into());
            self
        }
        /// <p>Displays any Amazon S3 error that CloudTrail encountered when attempting to deliver log files
        /// to the designated bucket. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/ErrorResponses.html">Error
        /// Responses</a> in the Amazon S3 API Reference. </p>
        /// <note>
        /// <p>This error occurs only when there is a problem with the destination S3 bucket, and does
        /// not occur for requests that time out. To resolve the issue, create a new bucket, and then call
        /// <code>UpdateTrail</code> to specify the new bucket; or fix the existing objects so that
        /// CloudTrail can again write to the bucket.</p>
        /// </note>
        pub fn set_latest_delivery_error(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.latest_delivery_error = input;
            self
        }
        /// <p>Displays any Amazon SNS error that CloudTrail encountered when attempting to send a
        /// notification. For more information about Amazon SNS errors, see the <a href="https://docs.aws.amazon.com/sns/latest/dg/welcome.html">Amazon SNS Developer Guide</a>.
        /// </p>
        pub fn latest_notification_error(mut self, input: impl Into<std::string::String>) -> Self {
            self.latest_notification_error = Some(input.into());
            self
        }
        /// <p>Displays any Amazon SNS error that CloudTrail encountered when attempting to send a
        /// notification. For more information about Amazon SNS errors, see the <a href="https://docs.aws.amazon.com/sns/latest/dg/welcome.html">Amazon SNS Developer Guide</a>.
        /// </p>
        pub fn set_latest_notification_error(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.latest_notification_error = input;
            self
        }
        /// <p>Specifies the date and time that CloudTrail last delivered log files to an account's Amazon S3 bucket.</p>
        pub fn latest_delivery_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.latest_delivery_time = Some(input);
            self
        }
        /// <p>Specifies the date and time that CloudTrail last delivered log files to an account's Amazon S3 bucket.</p>
        pub fn set_latest_delivery_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.latest_delivery_time = input;
            self
        }
        /// <p>Specifies the date and time of the most recent Amazon SNS notification that CloudTrail has written a new log file to an account's Amazon S3 bucket.</p>
        pub fn latest_notification_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.latest_notification_time = Some(input);
            self
        }
        /// <p>Specifies the date and time of the most recent Amazon SNS notification that CloudTrail has written a new log file to an account's Amazon S3 bucket.</p>
        pub fn set_latest_notification_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.latest_notification_time = input;
            self
        }
        /// <p>Specifies the most recent date and time when CloudTrail started recording API calls for an Amazon Web Services account.</p>
        pub fn start_logging_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.start_logging_time = Some(input);
            self
        }
        /// <p>Specifies the most recent date and time when CloudTrail started recording API calls for an Amazon Web Services account.</p>
        pub fn set_start_logging_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.start_logging_time = input;
            self
        }
        /// <p>Specifies the most recent date and time when CloudTrail stopped recording API calls for an Amazon Web Services account.</p>
        pub fn stop_logging_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.stop_logging_time = Some(input);
            self
        }
        /// <p>Specifies the most recent date and time when CloudTrail stopped recording API calls for an Amazon Web Services account.</p>
        pub fn set_stop_logging_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.stop_logging_time = input;
            self
        }
        /// <p>Displays any CloudWatch Logs error that CloudTrail encountered when attempting to deliver logs to CloudWatch Logs.</p>
        pub fn latest_cloud_watch_logs_delivery_error(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.latest_cloud_watch_logs_delivery_error = Some(input.into());
            self
        }
        /// <p>Displays any CloudWatch Logs error that CloudTrail encountered when attempting to deliver logs to CloudWatch Logs.</p>
        pub fn set_latest_cloud_watch_logs_delivery_error(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.latest_cloud_watch_logs_delivery_error = input;
            self
        }
        /// <p>Displays the most recent date and time when CloudTrail delivered logs to CloudWatch Logs.</p>
        pub fn latest_cloud_watch_logs_delivery_time(
            mut self,
            input: aws_smithy_types::Instant,
        ) -> Self {
            self.latest_cloud_watch_logs_delivery_time = Some(input);
            self
        }
        /// <p>Displays the most recent date and time when CloudTrail delivered logs to CloudWatch Logs.</p>
        pub fn set_latest_cloud_watch_logs_delivery_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.latest_cloud_watch_logs_delivery_time = input;
            self
        }
        /// <p>Specifies the date and time that CloudTrail last delivered a digest file to an account's Amazon S3 bucket.</p>
        pub fn latest_digest_delivery_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.latest_digest_delivery_time = Some(input);
            self
        }
        /// <p>Specifies the date and time that CloudTrail last delivered a digest file to an account's Amazon S3 bucket.</p>
        pub fn set_latest_digest_delivery_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.latest_digest_delivery_time = input;
            self
        }
        /// <p>Displays any Amazon S3 error that CloudTrail encountered when attempting to deliver a digest
        /// file to the designated bucket. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/ErrorResponses.html">Error
        /// Responses</a> in the Amazon S3 API Reference. </p>
        /// <note>
        /// <p>This error occurs only when there is a problem with the destination S3 bucket, and does
        /// not occur for requests that time out. To resolve the issue, create a new bucket, and then call
        /// <code>UpdateTrail</code> to specify the new bucket; or fix the existing objects so that
        /// CloudTrail can again write to the bucket.</p>
        /// </note>
        pub fn latest_digest_delivery_error(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.latest_digest_delivery_error = Some(input.into());
            self
        }
        /// <p>Displays any Amazon S3 error that CloudTrail encountered when attempting to deliver a digest
        /// file to the designated bucket. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/ErrorResponses.html">Error
        /// Responses</a> in the Amazon S3 API Reference. </p>
        /// <note>
        /// <p>This error occurs only when there is a problem with the destination S3 bucket, and does
        /// not occur for requests that time out. To resolve the issue, create a new bucket, and then call
        /// <code>UpdateTrail</code> to specify the new bucket; or fix the existing objects so that
        /// CloudTrail can again write to the bucket.</p>
        /// </note>
        pub fn set_latest_digest_delivery_error(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.latest_digest_delivery_error = input;
            self
        }
        /// <p>This field is no longer in use.</p>
        pub fn latest_delivery_attempt_time(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.latest_delivery_attempt_time = Some(input.into());
            self
        }
        /// <p>This field is no longer in use.</p>
        pub fn set_latest_delivery_attempt_time(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.latest_delivery_attempt_time = input;
            self
        }
        /// <p>This field is no longer in use.</p>
        pub fn latest_notification_attempt_time(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.latest_notification_attempt_time = Some(input.into());
            self
        }
        /// <p>This field is no longer in use.</p>
        pub fn set_latest_notification_attempt_time(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.latest_notification_attempt_time = input;
            self
        }
        /// <p>This field is no longer in use.</p>
        pub fn latest_notification_attempt_succeeded(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.latest_notification_attempt_succeeded = Some(input.into());
            self
        }
        /// <p>This field is no longer in use.</p>
        pub fn set_latest_notification_attempt_succeeded(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.latest_notification_attempt_succeeded = input;
            self
        }
        /// <p>This field is no longer in use.</p>
        pub fn latest_delivery_attempt_succeeded(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.latest_delivery_attempt_succeeded = Some(input.into());
            self
        }
        /// <p>This field is no longer in use.</p>
        pub fn set_latest_delivery_attempt_succeeded(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.latest_delivery_attempt_succeeded = input;
            self
        }
        /// <p>This field is no longer in use.</p>
        pub fn time_logging_started(mut self, input: impl Into<std::string::String>) -> Self {
            self.time_logging_started = Some(input.into());
            self
        }
        /// <p>This field is no longer in use.</p>
        pub fn set_time_logging_started(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.time_logging_started = input;
            self
        }
        /// <p>This field is no longer in use.</p>
        pub fn time_logging_stopped(mut self, input: impl Into<std::string::String>) -> Self {
            self.time_logging_stopped = Some(input.into());
            self
        }
        /// <p>This field is no longer in use.</p>
        pub fn set_time_logging_stopped(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.time_logging_stopped = input;
            self
        }
        /// Consumes the builder and constructs a [`GetTrailStatusOutput`](crate::output::GetTrailStatusOutput)
        pub fn build(self) -> crate::output::GetTrailStatusOutput {
            crate::output::GetTrailStatusOutput {
                is_logging: self.is_logging,
                latest_delivery_error: self.latest_delivery_error,
                latest_notification_error: self.latest_notification_error,
                latest_delivery_time: self.latest_delivery_time,
                latest_notification_time: self.latest_notification_time,
                start_logging_time: self.start_logging_time,
                stop_logging_time: self.stop_logging_time,
                latest_cloud_watch_logs_delivery_error: self.latest_cloud_watch_logs_delivery_error,
                latest_cloud_watch_logs_delivery_time: self.latest_cloud_watch_logs_delivery_time,
                latest_digest_delivery_time: self.latest_digest_delivery_time,
                latest_digest_delivery_error: self.latest_digest_delivery_error,
                latest_delivery_attempt_time: self.latest_delivery_attempt_time,
                latest_notification_attempt_time: self.latest_notification_attempt_time,
                latest_notification_attempt_succeeded: self.latest_notification_attempt_succeeded,
                latest_delivery_attempt_succeeded: self.latest_delivery_attempt_succeeded,
                time_logging_started: self.time_logging_started,
                time_logging_stopped: self.time_logging_stopped,
            }
        }
    }
}
impl GetTrailStatusOutput {
    /// Creates a new builder-style object to manufacture [`GetTrailStatusOutput`](crate::output::GetTrailStatusOutput)
    pub fn builder() -> crate::output::get_trail_status_output::Builder {
        crate::output::get_trail_status_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetTrailOutput {
    /// <p>The settings for a trail.</p>
    pub trail: std::option::Option<crate::model::Trail>,
}
impl std::fmt::Debug for GetTrailOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetTrailOutput");
        formatter.field("trail", &self.trail);
        formatter.finish()
    }
}
/// See [`GetTrailOutput`](crate::output::GetTrailOutput)
pub mod get_trail_output {
    /// A builder for [`GetTrailOutput`](crate::output::GetTrailOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) trail: std::option::Option<crate::model::Trail>,
    }
    impl Builder {
        /// <p>The settings for a trail.</p>
        pub fn trail(mut self, input: crate::model::Trail) -> Self {
            self.trail = Some(input);
            self
        }
        /// <p>The settings for a trail.</p>
        pub fn set_trail(mut self, input: std::option::Option<crate::model::Trail>) -> Self {
            self.trail = input;
            self
        }
        /// Consumes the builder and constructs a [`GetTrailOutput`](crate::output::GetTrailOutput)
        pub fn build(self) -> crate::output::GetTrailOutput {
            crate::output::GetTrailOutput { trail: self.trail }
        }
    }
}
impl GetTrailOutput {
    /// Creates a new builder-style object to manufacture [`GetTrailOutput`](crate::output::GetTrailOutput)
    pub fn builder() -> crate::output::get_trail_output::Builder {
        crate::output::get_trail_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetInsightSelectorsOutput {
    /// <p>The Amazon Resource Name (ARN) of a trail for which you want to get Insights selectors.</p>
    pub trail_arn: std::option::Option<std::string::String>,
    /// <p>A JSON string that contains the insight types you want to log on a trail. In this release, only <code>ApiCallRateInsight</code> is supported as an insight type.</p>
    pub insight_selectors: std::option::Option<std::vec::Vec<crate::model::InsightSelector>>,
}
impl std::fmt::Debug for GetInsightSelectorsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetInsightSelectorsOutput");
        formatter.field("trail_arn", &self.trail_arn);
        formatter.field("insight_selectors", &self.insight_selectors);
        formatter.finish()
    }
}
/// See [`GetInsightSelectorsOutput`](crate::output::GetInsightSelectorsOutput)
pub mod get_insight_selectors_output {
    /// A builder for [`GetInsightSelectorsOutput`](crate::output::GetInsightSelectorsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) trail_arn: std::option::Option<std::string::String>,
        pub(crate) insight_selectors:
            std::option::Option<std::vec::Vec<crate::model::InsightSelector>>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of a trail for which you want to get Insights selectors.</p>
        pub fn trail_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.trail_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of a trail for which you want to get Insights selectors.</p>
        pub fn set_trail_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.trail_arn = input;
            self
        }
        /// Appends an item to `insight_selectors`.
        ///
        /// To override the contents of this collection use [`set_insight_selectors`](Self::set_insight_selectors).
        ///
        /// <p>A JSON string that contains the insight types you want to log on a trail. In this release, only <code>ApiCallRateInsight</code> is supported as an insight type.</p>
        pub fn insight_selectors(
            mut self,
            input: impl Into<crate::model::InsightSelector>,
        ) -> Self {
            let mut v = self.insight_selectors.unwrap_or_default();
            v.push(input.into());
            self.insight_selectors = Some(v);
            self
        }
        /// <p>A JSON string that contains the insight types you want to log on a trail. In this release, only <code>ApiCallRateInsight</code> is supported as an insight type.</p>
        pub fn set_insight_selectors(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::InsightSelector>>,
        ) -> Self {
            self.insight_selectors = input;
            self
        }
        /// Consumes the builder and constructs a [`GetInsightSelectorsOutput`](crate::output::GetInsightSelectorsOutput)
        pub fn build(self) -> crate::output::GetInsightSelectorsOutput {
            crate::output::GetInsightSelectorsOutput {
                trail_arn: self.trail_arn,
                insight_selectors: self.insight_selectors,
            }
        }
    }
}
impl GetInsightSelectorsOutput {
    /// Creates a new builder-style object to manufacture [`GetInsightSelectorsOutput`](crate::output::GetInsightSelectorsOutput)
    pub fn builder() -> crate::output::get_insight_selectors_output::Builder {
        crate::output::get_insight_selectors_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetEventSelectorsOutput {
    /// <p>The specified trail ARN that has the event selectors.</p>
    pub trail_arn: std::option::Option<std::string::String>,
    /// <p>The event selectors that are configured for the trail.</p>
    pub event_selectors: std::option::Option<std::vec::Vec<crate::model::EventSelector>>,
    /// <p>
    /// The advanced event selectors that are configured for the trail.
    /// </p>
    pub advanced_event_selectors:
        std::option::Option<std::vec::Vec<crate::model::AdvancedEventSelector>>,
}
impl std::fmt::Debug for GetEventSelectorsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetEventSelectorsOutput");
        formatter.field("trail_arn", &self.trail_arn);
        formatter.field("event_selectors", &self.event_selectors);
        formatter.field("advanced_event_selectors", &self.advanced_event_selectors);
        formatter.finish()
    }
}
/// See [`GetEventSelectorsOutput`](crate::output::GetEventSelectorsOutput)
pub mod get_event_selectors_output {
    /// A builder for [`GetEventSelectorsOutput`](crate::output::GetEventSelectorsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) trail_arn: std::option::Option<std::string::String>,
        pub(crate) event_selectors: std::option::Option<std::vec::Vec<crate::model::EventSelector>>,
        pub(crate) advanced_event_selectors:
            std::option::Option<std::vec::Vec<crate::model::AdvancedEventSelector>>,
    }
    impl Builder {
        /// <p>The specified trail ARN that has the event selectors.</p>
        pub fn trail_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.trail_arn = Some(input.into());
            self
        }
        /// <p>The specified trail ARN that has the event selectors.</p>
        pub fn set_trail_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.trail_arn = input;
            self
        }
        /// Appends an item to `event_selectors`.
        ///
        /// To override the contents of this collection use [`set_event_selectors`](Self::set_event_selectors).
        ///
        /// <p>The event selectors that are configured for the trail.</p>
        pub fn event_selectors(mut self, input: impl Into<crate::model::EventSelector>) -> Self {
            let mut v = self.event_selectors.unwrap_or_default();
            v.push(input.into());
            self.event_selectors = Some(v);
            self
        }
        /// <p>The event selectors that are configured for the trail.</p>
        pub fn set_event_selectors(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::EventSelector>>,
        ) -> Self {
            self.event_selectors = input;
            self
        }
        /// Appends an item to `advanced_event_selectors`.
        ///
        /// To override the contents of this collection use [`set_advanced_event_selectors`](Self::set_advanced_event_selectors).
        ///
        /// <p>
        /// The advanced event selectors that are configured for the trail.
        /// </p>
        pub fn advanced_event_selectors(
            mut self,
            input: impl Into<crate::model::AdvancedEventSelector>,
        ) -> Self {
            let mut v = self.advanced_event_selectors.unwrap_or_default();
            v.push(input.into());
            self.advanced_event_selectors = Some(v);
            self
        }
        /// <p>
        /// The advanced event selectors that are configured for the trail.
        /// </p>
        pub fn set_advanced_event_selectors(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AdvancedEventSelector>>,
        ) -> Self {
            self.advanced_event_selectors = input;
            self
        }
        /// Consumes the builder and constructs a [`GetEventSelectorsOutput`](crate::output::GetEventSelectorsOutput)
        pub fn build(self) -> crate::output::GetEventSelectorsOutput {
            crate::output::GetEventSelectorsOutput {
                trail_arn: self.trail_arn,
                event_selectors: self.event_selectors,
                advanced_event_selectors: self.advanced_event_selectors,
            }
        }
    }
}
impl GetEventSelectorsOutput {
    /// Creates a new builder-style object to manufacture [`GetEventSelectorsOutput`](crate::output::GetEventSelectorsOutput)
    pub fn builder() -> crate::output::get_event_selectors_output::Builder {
        crate::output::get_event_selectors_output::Builder::default()
    }
}

/// <p>Returns the objects or data listed below if successful. Otherwise, returns an error.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeTrailsOutput {
    /// <p>The list of trail objects. Trail objects with string values are only returned if values for the objects exist in a trail's configuration.
    /// For example, <code>SNSTopicName</code> and <code>SNSTopicARN</code> are only returned in results if a trail is configured to send SNS notifications. Similarly,
    /// <code>KMSKeyId</code> only appears in results if a trail's log files are encrypted with KMS customer managed keys.</p>
    pub trail_list: std::option::Option<std::vec::Vec<crate::model::Trail>>,
}
impl std::fmt::Debug for DescribeTrailsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeTrailsOutput");
        formatter.field("trail_list", &self.trail_list);
        formatter.finish()
    }
}
/// See [`DescribeTrailsOutput`](crate::output::DescribeTrailsOutput)
pub mod describe_trails_output {
    /// A builder for [`DescribeTrailsOutput`](crate::output::DescribeTrailsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) trail_list: std::option::Option<std::vec::Vec<crate::model::Trail>>,
    }
    impl Builder {
        /// Appends an item to `trail_list`.
        ///
        /// To override the contents of this collection use [`set_trail_list`](Self::set_trail_list).
        ///
        /// <p>The list of trail objects. Trail objects with string values are only returned if values for the objects exist in a trail's configuration.
        /// For example, <code>SNSTopicName</code> and <code>SNSTopicARN</code> are only returned in results if a trail is configured to send SNS notifications. Similarly,
        /// <code>KMSKeyId</code> only appears in results if a trail's log files are encrypted with KMS customer managed keys.</p>
        pub fn trail_list(mut self, input: impl Into<crate::model::Trail>) -> Self {
            let mut v = self.trail_list.unwrap_or_default();
            v.push(input.into());
            self.trail_list = Some(v);
            self
        }
        /// <p>The list of trail objects. Trail objects with string values are only returned if values for the objects exist in a trail's configuration.
        /// For example, <code>SNSTopicName</code> and <code>SNSTopicARN</code> are only returned in results if a trail is configured to send SNS notifications. Similarly,
        /// <code>KMSKeyId</code> only appears in results if a trail's log files are encrypted with KMS customer managed keys.</p>
        pub fn set_trail_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Trail>>,
        ) -> Self {
            self.trail_list = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeTrailsOutput`](crate::output::DescribeTrailsOutput)
        pub fn build(self) -> crate::output::DescribeTrailsOutput {
            crate::output::DescribeTrailsOutput {
                trail_list: self.trail_list,
            }
        }
    }
}
impl DescribeTrailsOutput {
    /// Creates a new builder-style object to manufacture [`DescribeTrailsOutput`](crate::output::DescribeTrailsOutput)
    pub fn builder() -> crate::output::describe_trails_output::Builder {
        crate::output::describe_trails_output::Builder::default()
    }
}

/// <p>Returns the objects or data listed below if successful. Otherwise, returns an error.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteTrailOutput {}
impl std::fmt::Debug for DeleteTrailOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteTrailOutput");
        formatter.finish()
    }
}
/// See [`DeleteTrailOutput`](crate::output::DeleteTrailOutput)
pub mod delete_trail_output {
    /// A builder for [`DeleteTrailOutput`](crate::output::DeleteTrailOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteTrailOutput`](crate::output::DeleteTrailOutput)
        pub fn build(self) -> crate::output::DeleteTrailOutput {
            crate::output::DeleteTrailOutput {}
        }
    }
}
impl DeleteTrailOutput {
    /// Creates a new builder-style object to manufacture [`DeleteTrailOutput`](crate::output::DeleteTrailOutput)
    pub fn builder() -> crate::output::delete_trail_output::Builder {
        crate::output::delete_trail_output::Builder::default()
    }
}

/// <p>Returns the objects or data listed below if successful. Otherwise, returns an error.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateTrailOutput {
    /// <p>Specifies the name of the trail.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>Specifies the name of the Amazon S3 bucket designated for publishing log files.</p>
    pub s3_bucket_name: std::option::Option<std::string::String>,
    /// <p>Specifies the Amazon S3 key prefix that comes after the name of the bucket you have designated
    /// for log file delivery. For more information, see <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/cloudtrail-find-log-files.html">Finding Your CloudTrail Log Files</a>.</p>
    pub s3_key_prefix: std::option::Option<std::string::String>,
    /// <p>This field is no longer in use. Use SnsTopicARN.</p>
    pub sns_topic_name: std::option::Option<std::string::String>,
    /// <p>Specifies the ARN of the Amazon SNS topic that CloudTrail uses to send notifications when log files are delivered. The format of a topic ARN is:</p>
    /// <p>
    /// <code>arn:aws:sns:us-east-2:123456789012:MyTopic</code>
    /// </p>
    pub sns_topic_arn: std::option::Option<std::string::String>,
    /// <p>Specifies whether the trail is publishing events from global services such as IAM to the log files.</p>
    pub include_global_service_events: std::option::Option<bool>,
    /// <p>Specifies whether the trail exists in one region or in all regions.</p>
    pub is_multi_region_trail: std::option::Option<bool>,
    /// <p>Specifies the ARN of the trail that was created. The format of a trail ARN
    /// is:</p>
    /// <p>
    /// <code>arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail</code>
    /// </p>
    pub trail_arn: std::option::Option<std::string::String>,
    /// <p>Specifies whether log file integrity validation is enabled.</p>
    pub log_file_validation_enabled: std::option::Option<bool>,
    /// <p>Specifies the Amazon Resource Name (ARN) of the log group to which CloudTrail logs will be delivered.</p>
    pub cloud_watch_logs_log_group_arn: std::option::Option<std::string::String>,
    /// <p>Specifies the role for the CloudWatch Logs endpoint to assume to write to a user's log group.</p>
    pub cloud_watch_logs_role_arn: std::option::Option<std::string::String>,
    /// <p>Specifies the KMS key ID that encrypts the logs delivered by CloudTrail.
    /// The value is a fully specified ARN to a KMS key in the following format.</p>
    /// <p>
    /// <code>arn:aws:kms:us-east-2:123456789012:key/12345678-1234-1234-1234-123456789012</code>
    /// </p>
    pub kms_key_id: std::option::Option<std::string::String>,
    /// <p>Specifies whether the trail is an organization trail.</p>
    pub is_organization_trail: std::option::Option<bool>,
}
impl std::fmt::Debug for CreateTrailOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateTrailOutput");
        formatter.field("name", &self.name);
        formatter.field("s3_bucket_name", &self.s3_bucket_name);
        formatter.field("s3_key_prefix", &self.s3_key_prefix);
        formatter.field("sns_topic_name", &self.sns_topic_name);
        formatter.field("sns_topic_arn", &self.sns_topic_arn);
        formatter.field(
            "include_global_service_events",
            &self.include_global_service_events,
        );
        formatter.field("is_multi_region_trail", &self.is_multi_region_trail);
        formatter.field("trail_arn", &self.trail_arn);
        formatter.field(
            "log_file_validation_enabled",
            &self.log_file_validation_enabled,
        );
        formatter.field(
            "cloud_watch_logs_log_group_arn",
            &self.cloud_watch_logs_log_group_arn,
        );
        formatter.field("cloud_watch_logs_role_arn", &self.cloud_watch_logs_role_arn);
        formatter.field("kms_key_id", &self.kms_key_id);
        formatter.field("is_organization_trail", &self.is_organization_trail);
        formatter.finish()
    }
}
/// See [`CreateTrailOutput`](crate::output::CreateTrailOutput)
pub mod create_trail_output {
    /// A builder for [`CreateTrailOutput`](crate::output::CreateTrailOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) s3_bucket_name: std::option::Option<std::string::String>,
        pub(crate) s3_key_prefix: std::option::Option<std::string::String>,
        pub(crate) sns_topic_name: std::option::Option<std::string::String>,
        pub(crate) sns_topic_arn: std::option::Option<std::string::String>,
        pub(crate) include_global_service_events: std::option::Option<bool>,
        pub(crate) is_multi_region_trail: std::option::Option<bool>,
        pub(crate) trail_arn: std::option::Option<std::string::String>,
        pub(crate) log_file_validation_enabled: std::option::Option<bool>,
        pub(crate) cloud_watch_logs_log_group_arn: std::option::Option<std::string::String>,
        pub(crate) cloud_watch_logs_role_arn: std::option::Option<std::string::String>,
        pub(crate) kms_key_id: std::option::Option<std::string::String>,
        pub(crate) is_organization_trail: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>Specifies the name of the trail.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>Specifies the name of the trail.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>Specifies the name of the Amazon S3 bucket designated for publishing log files.</p>
        pub fn s3_bucket_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.s3_bucket_name = Some(input.into());
            self
        }
        /// <p>Specifies the name of the Amazon S3 bucket designated for publishing log files.</p>
        pub fn set_s3_bucket_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.s3_bucket_name = input;
            self
        }
        /// <p>Specifies the Amazon S3 key prefix that comes after the name of the bucket you have designated
        /// for log file delivery. For more information, see <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/cloudtrail-find-log-files.html">Finding Your CloudTrail Log Files</a>.</p>
        pub fn s3_key_prefix(mut self, input: impl Into<std::string::String>) -> Self {
            self.s3_key_prefix = Some(input.into());
            self
        }
        /// <p>Specifies the Amazon S3 key prefix that comes after the name of the bucket you have designated
        /// for log file delivery. For more information, see <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/cloudtrail-find-log-files.html">Finding Your CloudTrail Log Files</a>.</p>
        pub fn set_s3_key_prefix(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.s3_key_prefix = input;
            self
        }
        /// <p>This field is no longer in use. Use SnsTopicARN.</p>
        pub fn sns_topic_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.sns_topic_name = Some(input.into());
            self
        }
        /// <p>This field is no longer in use. Use SnsTopicARN.</p>
        pub fn set_sns_topic_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.sns_topic_name = input;
            self
        }
        /// <p>Specifies the ARN of the Amazon SNS topic that CloudTrail uses to send notifications when log files are delivered. The format of a topic ARN is:</p>
        /// <p>
        /// <code>arn:aws:sns:us-east-2:123456789012:MyTopic</code>
        /// </p>
        pub fn sns_topic_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.sns_topic_arn = Some(input.into());
            self
        }
        /// <p>Specifies the ARN of the Amazon SNS topic that CloudTrail uses to send notifications when log files are delivered. The format of a topic ARN is:</p>
        /// <p>
        /// <code>arn:aws:sns:us-east-2:123456789012:MyTopic</code>
        /// </p>
        pub fn set_sns_topic_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.sns_topic_arn = input;
            self
        }
        /// <p>Specifies whether the trail is publishing events from global services such as IAM to the log files.</p>
        pub fn include_global_service_events(mut self, input: bool) -> Self {
            self.include_global_service_events = Some(input);
            self
        }
        /// <p>Specifies whether the trail is publishing events from global services such as IAM to the log files.</p>
        pub fn set_include_global_service_events(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.include_global_service_events = input;
            self
        }
        /// <p>Specifies whether the trail exists in one region or in all regions.</p>
        pub fn is_multi_region_trail(mut self, input: bool) -> Self {
            self.is_multi_region_trail = Some(input);
            self
        }
        /// <p>Specifies whether the trail exists in one region or in all regions.</p>
        pub fn set_is_multi_region_trail(mut self, input: std::option::Option<bool>) -> Self {
            self.is_multi_region_trail = input;
            self
        }
        /// <p>Specifies the ARN of the trail that was created. The format of a trail ARN
        /// is:</p>
        /// <p>
        /// <code>arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail</code>
        /// </p>
        pub fn trail_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.trail_arn = Some(input.into());
            self
        }
        /// <p>Specifies the ARN of the trail that was created. The format of a trail ARN
        /// is:</p>
        /// <p>
        /// <code>arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail</code>
        /// </p>
        pub fn set_trail_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.trail_arn = input;
            self
        }
        /// <p>Specifies whether log file integrity validation is enabled.</p>
        pub fn log_file_validation_enabled(mut self, input: bool) -> Self {
            self.log_file_validation_enabled = Some(input);
            self
        }
        /// <p>Specifies whether log file integrity validation is enabled.</p>
        pub fn set_log_file_validation_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.log_file_validation_enabled = input;
            self
        }
        /// <p>Specifies the Amazon Resource Name (ARN) of the log group to which CloudTrail logs will be delivered.</p>
        pub fn cloud_watch_logs_log_group_arn(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.cloud_watch_logs_log_group_arn = Some(input.into());
            self
        }
        /// <p>Specifies the Amazon Resource Name (ARN) of the log group to which CloudTrail logs will be delivered.</p>
        pub fn set_cloud_watch_logs_log_group_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.cloud_watch_logs_log_group_arn = input;
            self
        }
        /// <p>Specifies the role for the CloudWatch Logs endpoint to assume to write to a user's log group.</p>
        pub fn cloud_watch_logs_role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.cloud_watch_logs_role_arn = Some(input.into());
            self
        }
        /// <p>Specifies the role for the CloudWatch Logs endpoint to assume to write to a user's log group.</p>
        pub fn set_cloud_watch_logs_role_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.cloud_watch_logs_role_arn = input;
            self
        }
        /// <p>Specifies the KMS key ID that encrypts the logs delivered by CloudTrail.
        /// The value is a fully specified ARN to a KMS key in the following format.</p>
        /// <p>
        /// <code>arn:aws:kms:us-east-2:123456789012:key/12345678-1234-1234-1234-123456789012</code>
        /// </p>
        pub fn kms_key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.kms_key_id = Some(input.into());
            self
        }
        /// <p>Specifies the KMS key ID that encrypts the logs delivered by CloudTrail.
        /// The value is a fully specified ARN to a KMS key in the following format.</p>
        /// <p>
        /// <code>arn:aws:kms:us-east-2:123456789012:key/12345678-1234-1234-1234-123456789012</code>
        /// </p>
        pub fn set_kms_key_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.kms_key_id = input;
            self
        }
        /// <p>Specifies whether the trail is an organization trail.</p>
        pub fn is_organization_trail(mut self, input: bool) -> Self {
            self.is_organization_trail = Some(input);
            self
        }
        /// <p>Specifies whether the trail is an organization trail.</p>
        pub fn set_is_organization_trail(mut self, input: std::option::Option<bool>) -> Self {
            self.is_organization_trail = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateTrailOutput`](crate::output::CreateTrailOutput)
        pub fn build(self) -> crate::output::CreateTrailOutput {
            crate::output::CreateTrailOutput {
                name: self.name,
                s3_bucket_name: self.s3_bucket_name,
                s3_key_prefix: self.s3_key_prefix,
                sns_topic_name: self.sns_topic_name,
                sns_topic_arn: self.sns_topic_arn,
                include_global_service_events: self.include_global_service_events,
                is_multi_region_trail: self.is_multi_region_trail,
                trail_arn: self.trail_arn,
                log_file_validation_enabled: self.log_file_validation_enabled,
                cloud_watch_logs_log_group_arn: self.cloud_watch_logs_log_group_arn,
                cloud_watch_logs_role_arn: self.cloud_watch_logs_role_arn,
                kms_key_id: self.kms_key_id,
                is_organization_trail: self.is_organization_trail,
            }
        }
    }
}
impl CreateTrailOutput {
    /// Creates a new builder-style object to manufacture [`CreateTrailOutput`](crate::output::CreateTrailOutput)
    pub fn builder() -> crate::output::create_trail_output::Builder {
        crate::output::create_trail_output::Builder::default()
    }
}

/// <p>Returns the objects or data if successful. Otherwise, returns an error.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AddTagsOutput {}
impl std::fmt::Debug for AddTagsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AddTagsOutput");
        formatter.finish()
    }
}
/// See [`AddTagsOutput`](crate::output::AddTagsOutput)
pub mod add_tags_output {
    /// A builder for [`AddTagsOutput`](crate::output::AddTagsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`AddTagsOutput`](crate::output::AddTagsOutput)
        pub fn build(self) -> crate::output::AddTagsOutput {
            crate::output::AddTagsOutput {}
        }
    }
}
impl AddTagsOutput {
    /// Creates a new builder-style object to manufacture [`AddTagsOutput`](crate::output::AddTagsOutput)
    pub fn builder() -> crate::output::add_tags_output::Builder {
        crate::output::add_tags_output::Builder::default()
    }
}
