// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle<
    C = aws_smithy_client::erase::DynConnector,
    M = aws_hyper::AwsMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    client: aws_smithy_client::Client<C, M, R>,
    conf: crate::Config,
}

/// An ergonomic service client for `CloudTrail_20131101`.
///
/// This client allows ergonomic access to a `CloudTrail_20131101`-shaped service.
/// Each method corresponds to an endpoint defined in the service's Smithy model,
/// and the request and response shapes are auto-generated from that same model.
///
/// # Using a Client
///
/// Once you have a client set up, you can access the service's endpoints
/// by calling the appropriate method on [`Client`]. Each such method
/// returns a request builder for that endpoint, with methods for setting
/// the various fields of the request. Once your request is complete, use
/// the `send` method to send the request. `send` returns a future, which
/// you then have to `.await` to get the service's response.
///
/// [builder pattern]: https://rust-lang.github.io/api-guidelines/type-safety.html#c-builder
/// [SigV4-signed requests]: https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html
#[derive(std::fmt::Debug)]
pub struct Client<
    C = aws_smithy_client::erase::DynConnector,
    M = aws_hyper::AwsMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    handle: std::sync::Arc<Handle<C, M, R>>,
}

impl<C, M, R> std::clone::Clone for Client<C, M, R> {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl<C, M, R> From<aws_smithy_client::Client<C, M, R>> for Client<C, M, R> {
    fn from(client: aws_smithy_client::Client<C, M, R>) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl<C, M, R> Client<C, M, R> {
    /// Creates a client with the given service configuration.
    pub fn with_config(client: aws_smithy_client::Client<C, M, R>, conf: crate::Config) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl<C, M, R> Client<C, M, R>
where
    C: aws_smithy_client::bounds::SmithyConnector,
    M: aws_smithy_client::bounds::SmithyMiddleware<C>,
    R: aws_smithy_client::retry::NewRequestPolicy,
{
    /// Constructs a fluent builder for the `AddTags` operation.
    ///
    /// See [`AddTags`](crate::client::fluent_builders::AddTags) for more information about the
    /// operation and its arguments.
    pub fn add_tags(&self) -> fluent_builders::AddTags<C, M, R> {
        fluent_builders::AddTags::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateTrail` operation.
    ///
    /// See [`CreateTrail`](crate::client::fluent_builders::CreateTrail) for more information about the
    /// operation and its arguments.
    pub fn create_trail(&self) -> fluent_builders::CreateTrail<C, M, R> {
        fluent_builders::CreateTrail::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteTrail` operation.
    ///
    /// See [`DeleteTrail`](crate::client::fluent_builders::DeleteTrail) for more information about the
    /// operation and its arguments.
    pub fn delete_trail(&self) -> fluent_builders::DeleteTrail<C, M, R> {
        fluent_builders::DeleteTrail::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeTrails` operation.
    ///
    /// See [`DescribeTrails`](crate::client::fluent_builders::DescribeTrails) for more information about the
    /// operation and its arguments.
    pub fn describe_trails(&self) -> fluent_builders::DescribeTrails<C, M, R> {
        fluent_builders::DescribeTrails::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetEventSelectors` operation.
    ///
    /// See [`GetEventSelectors`](crate::client::fluent_builders::GetEventSelectors) for more information about the
    /// operation and its arguments.
    pub fn get_event_selectors(&self) -> fluent_builders::GetEventSelectors<C, M, R> {
        fluent_builders::GetEventSelectors::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetInsightSelectors` operation.
    ///
    /// See [`GetInsightSelectors`](crate::client::fluent_builders::GetInsightSelectors) for more information about the
    /// operation and its arguments.
    pub fn get_insight_selectors(&self) -> fluent_builders::GetInsightSelectors<C, M, R> {
        fluent_builders::GetInsightSelectors::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetTrail` operation.
    ///
    /// See [`GetTrail`](crate::client::fluent_builders::GetTrail) for more information about the
    /// operation and its arguments.
    pub fn get_trail(&self) -> fluent_builders::GetTrail<C, M, R> {
        fluent_builders::GetTrail::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetTrailStatus` operation.
    ///
    /// See [`GetTrailStatus`](crate::client::fluent_builders::GetTrailStatus) for more information about the
    /// operation and its arguments.
    pub fn get_trail_status(&self) -> fluent_builders::GetTrailStatus<C, M, R> {
        fluent_builders::GetTrailStatus::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListPublicKeys` operation.
    ///
    /// See [`ListPublicKeys`](crate::client::fluent_builders::ListPublicKeys) for more information about the
    /// operation and its arguments.
    pub fn list_public_keys(&self) -> fluent_builders::ListPublicKeys<C, M, R> {
        fluent_builders::ListPublicKeys::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListTags` operation.
    ///
    /// See [`ListTags`](crate::client::fluent_builders::ListTags) for more information about the
    /// operation and its arguments.
    pub fn list_tags(&self) -> fluent_builders::ListTags<C, M, R> {
        fluent_builders::ListTags::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListTrails` operation.
    ///
    /// See [`ListTrails`](crate::client::fluent_builders::ListTrails) for more information about the
    /// operation and its arguments.
    pub fn list_trails(&self) -> fluent_builders::ListTrails<C, M, R> {
        fluent_builders::ListTrails::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `LookupEvents` operation.
    ///
    /// See [`LookupEvents`](crate::client::fluent_builders::LookupEvents) for more information about the
    /// operation and its arguments.
    pub fn lookup_events(&self) -> fluent_builders::LookupEvents<C, M, R> {
        fluent_builders::LookupEvents::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `PutEventSelectors` operation.
    ///
    /// See [`PutEventSelectors`](crate::client::fluent_builders::PutEventSelectors) for more information about the
    /// operation and its arguments.
    pub fn put_event_selectors(&self) -> fluent_builders::PutEventSelectors<C, M, R> {
        fluent_builders::PutEventSelectors::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `PutInsightSelectors` operation.
    ///
    /// See [`PutInsightSelectors`](crate::client::fluent_builders::PutInsightSelectors) for more information about the
    /// operation and its arguments.
    pub fn put_insight_selectors(&self) -> fluent_builders::PutInsightSelectors<C, M, R> {
        fluent_builders::PutInsightSelectors::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `RemoveTags` operation.
    ///
    /// See [`RemoveTags`](crate::client::fluent_builders::RemoveTags) for more information about the
    /// operation and its arguments.
    pub fn remove_tags(&self) -> fluent_builders::RemoveTags<C, M, R> {
        fluent_builders::RemoveTags::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `StartLogging` operation.
    ///
    /// See [`StartLogging`](crate::client::fluent_builders::StartLogging) for more information about the
    /// operation and its arguments.
    pub fn start_logging(&self) -> fluent_builders::StartLogging<C, M, R> {
        fluent_builders::StartLogging::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `StopLogging` operation.
    ///
    /// See [`StopLogging`](crate::client::fluent_builders::StopLogging) for more information about the
    /// operation and its arguments.
    pub fn stop_logging(&self) -> fluent_builders::StopLogging<C, M, R> {
        fluent_builders::StopLogging::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateTrail` operation.
    ///
    /// See [`UpdateTrail`](crate::client::fluent_builders::UpdateTrail) for more information about the
    /// operation and its arguments.
    pub fn update_trail(&self) -> fluent_builders::UpdateTrail<C, M, R> {
        fluent_builders::UpdateTrail::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `AddTags`.
    ///
    /// <p>Adds one or more tags to a trail, up to a limit of 50. Overwrites an existing tag's value when a new value is specified for an existing tag key.
    /// Tag key names must be unique for a trail; you cannot have two keys with the same name but different values.
    /// If you specify a key without a value, the tag will be created with the specified key and a value of null.
    /// You can tag a trail that applies to all Amazon Web Services Regions only from the Region in which the trail was created (also known as its home region).</p>
    #[derive(std::fmt::Debug)]
    pub struct AddTags<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::add_tags_input::Builder,
    }
    impl<C, M, R> AddTags<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AddTags`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AddTagsOutput,
            aws_smithy_http::result::SdkError<crate::error::AddTagsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AddTagsInputOperationOutputAlias,
                crate::output::AddTagsOutput,
                crate::error::AddTagsError,
                crate::input::AddTagsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>Specifies the ARN of the trail to which one or more tags will be added. The format of a trail ARN is:</p>
        /// <p>
        /// <code>arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail</code>
        /// </p>
        pub fn resource_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_id(inp);
            self
        }
        /// <p>Specifies the ARN of the trail to which one or more tags will be added. The format of a trail ARN is:</p>
        /// <p>
        /// <code>arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail</code>
        /// </p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_id(input);
            self
        }
        /// Appends an item to `TagsList`.
        ///
        /// To override the contents of this collection use [`set_tags_list`](Self::set_tags_list).
        ///
        /// <p>Contains a list of tags, up to a limit of 50</p>
        pub fn tags_list(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags_list(inp);
            self
        }
        /// <p>Contains a list of tags, up to a limit of 50</p>
        pub fn set_tags_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags_list(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateTrail`.
    ///
    /// <p>Creates a trail that specifies the settings for delivery of log data to an Amazon S3 bucket.
    /// </p>
    #[derive(std::fmt::Debug)]
    pub struct CreateTrail<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_trail_input::Builder,
    }
    impl<C, M, R> CreateTrail<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateTrail`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateTrailOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateTrailError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateTrailInputOperationOutputAlias,
                crate::output::CreateTrailOutput,
                crate::error::CreateTrailError,
                crate::input::CreateTrailInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>Specifies the name of the trail. The name must meet the following requirements:</p>
        /// <ul>
        /// <li>
        /// <p>Contain only ASCII letters (a-z, A-Z), numbers (0-9), periods (.), underscores (_), or dashes (-)</p>
        /// </li>
        /// <li>
        /// <p>Start with a letter or number, and end with a letter or number</p>
        /// </li>
        /// <li>
        /// <p>Be between 3 and 128 characters</p>
        /// </li>
        /// <li>
        /// <p>Have no adjacent periods, underscores or dashes. Names like <code>my-_namespace</code>
        /// and <code>my--namespace</code> are not valid.</p>
        /// </li>
        /// <li>
        /// <p>Not be in IP address format (for example, 192.168.5.4)</p>
        /// </li>
        /// </ul>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>Specifies the name of the trail. The name must meet the following requirements:</p>
        /// <ul>
        /// <li>
        /// <p>Contain only ASCII letters (a-z, A-Z), numbers (0-9), periods (.), underscores (_), or dashes (-)</p>
        /// </li>
        /// <li>
        /// <p>Start with a letter or number, and end with a letter or number</p>
        /// </li>
        /// <li>
        /// <p>Be between 3 and 128 characters</p>
        /// </li>
        /// <li>
        /// <p>Have no adjacent periods, underscores or dashes. Names like <code>my-_namespace</code>
        /// and <code>my--namespace</code> are not valid.</p>
        /// </li>
        /// <li>
        /// <p>Not be in IP address format (for example, 192.168.5.4)</p>
        /// </li>
        /// </ul>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>Specifies the name of the Amazon S3 bucket designated for publishing log files. See <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/create_trail_naming_policy.html">Amazon S3 Bucket Naming Requirements</a>.</p>
        pub fn s3_bucket_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.s3_bucket_name(inp);
            self
        }
        /// <p>Specifies the name of the Amazon S3 bucket designated for publishing log files. See <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/create_trail_naming_policy.html">Amazon S3 Bucket Naming Requirements</a>.</p>
        pub fn set_s3_bucket_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_s3_bucket_name(input);
            self
        }
        /// <p>Specifies the Amazon S3 key prefix that comes after the name of the bucket you have designated
        /// for log file delivery. For more information, see <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/cloudtrail-find-log-files.html">Finding Your CloudTrail Log Files</a>. The maximum length is 200 characters.</p>
        pub fn s3_key_prefix(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.s3_key_prefix(inp);
            self
        }
        /// <p>Specifies the Amazon S3 key prefix that comes after the name of the bucket you have designated
        /// for log file delivery. For more information, see <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/cloudtrail-find-log-files.html">Finding Your CloudTrail Log Files</a>. The maximum length is 200 characters.</p>
        pub fn set_s3_key_prefix(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_s3_key_prefix(input);
            self
        }
        /// <p>Specifies the name of the Amazon SNS topic defined for notification of log file delivery. The maximum length is 256 characters.</p>
        pub fn sns_topic_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.sns_topic_name(inp);
            self
        }
        /// <p>Specifies the name of the Amazon SNS topic defined for notification of log file delivery. The maximum length is 256 characters.</p>
        pub fn set_sns_topic_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_sns_topic_name(input);
            self
        }
        /// <p>Specifies whether the trail is publishing events from global services such as IAM to the log files.</p>
        pub fn include_global_service_events(mut self, inp: bool) -> Self {
            self.inner = self.inner.include_global_service_events(inp);
            self
        }
        /// <p>Specifies whether the trail is publishing events from global services such as IAM to the log files.</p>
        pub fn set_include_global_service_events(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.inner = self.inner.set_include_global_service_events(input);
            self
        }
        /// <p>Specifies whether the trail is created in the current region or in all regions. The default is false, which creates a trail only in the region where you are signed in. As a best practice, consider
        /// creating trails that log events in all regions.</p>
        pub fn is_multi_region_trail(mut self, inp: bool) -> Self {
            self.inner = self.inner.is_multi_region_trail(inp);
            self
        }
        /// <p>Specifies whether the trail is created in the current region or in all regions. The default is false, which creates a trail only in the region where you are signed in. As a best practice, consider
        /// creating trails that log events in all regions.</p>
        pub fn set_is_multi_region_trail(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_is_multi_region_trail(input);
            self
        }
        /// <p>Specifies whether log file integrity validation is enabled. The default is false.</p>
        /// <note>
        /// <p>When you disable log file integrity validation, the chain of digest files is broken after one hour. CloudTrail does
        /// not create digest files for log files that were delivered during a period in which log file integrity validation was disabled.
        /// For example, if you enable log file integrity validation at noon on January 1, disable it at noon on January 2, and re-enable
        /// it at noon on January 10, digest files will not be created for the log files delivered from noon on January 2 to noon on
        /// January 10. The same applies whenever you stop CloudTrail logging or delete a trail.</p>
        /// </note>
        pub fn enable_log_file_validation(mut self, inp: bool) -> Self {
            self.inner = self.inner.enable_log_file_validation(inp);
            self
        }
        /// <p>Specifies whether log file integrity validation is enabled. The default is false.</p>
        /// <note>
        /// <p>When you disable log file integrity validation, the chain of digest files is broken after one hour. CloudTrail does
        /// not create digest files for log files that were delivered during a period in which log file integrity validation was disabled.
        /// For example, if you enable log file integrity validation at noon on January 1, disable it at noon on January 2, and re-enable
        /// it at noon on January 10, digest files will not be created for the log files delivered from noon on January 2 to noon on
        /// January 10. The same applies whenever you stop CloudTrail logging or delete a trail.</p>
        /// </note>
        pub fn set_enable_log_file_validation(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_enable_log_file_validation(input);
            self
        }
        /// <p>Specifies a log group name using an Amazon Resource Name (ARN), a unique identifier that represents the log group
        /// to which CloudTrail logs will be delivered. Not required unless you specify <code>CloudWatchLogsRoleArn</code>.</p>
        pub fn cloud_watch_logs_log_group_arn(
            mut self,
            inp: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.cloud_watch_logs_log_group_arn(inp);
            self
        }
        /// <p>Specifies a log group name using an Amazon Resource Name (ARN), a unique identifier that represents the log group
        /// to which CloudTrail logs will be delivered. Not required unless you specify <code>CloudWatchLogsRoleArn</code>.</p>
        pub fn set_cloud_watch_logs_log_group_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_cloud_watch_logs_log_group_arn(input);
            self
        }
        /// <p>Specifies the role for the CloudWatch Logs endpoint to assume to write to a user's log group.</p>
        pub fn cloud_watch_logs_role_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cloud_watch_logs_role_arn(inp);
            self
        }
        /// <p>Specifies the role for the CloudWatch Logs endpoint to assume to write to a user's log group.</p>
        pub fn set_cloud_watch_logs_role_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_cloud_watch_logs_role_arn(input);
            self
        }
        /// <p>Specifies the KMS key ID to use to encrypt the logs delivered by CloudTrail. The
        /// value can be an alias name prefixed by "alias/", a fully specified ARN to an alias, a fully
        /// specified ARN to a key, or a globally unique identifier.</p>
        /// <p>CloudTrail also supports KMS multi-Region keys. For more information about multi-Region keys,
        /// see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/multi-region-keys-overview.html">Using multi-Region keys</a> in the <i>Key Management Service Developer Guide</i>.</p>
        /// <p>Examples:</p>
        /// <ul>
        /// <li>
        /// <p>alias/MyAliasName</p>
        /// </li>
        /// <li>
        /// <p>arn:aws:kms:us-east-2:123456789012:alias/MyAliasName</p>
        /// </li>
        /// <li>
        /// <p>arn:aws:kms:us-east-2:123456789012:key/12345678-1234-1234-1234-123456789012</p>
        /// </li>
        /// <li>
        /// <p>12345678-1234-1234-1234-123456789012</p>
        /// </li>
        /// </ul>
        pub fn kms_key_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.kms_key_id(inp);
            self
        }
        /// <p>Specifies the KMS key ID to use to encrypt the logs delivered by CloudTrail. The
        /// value can be an alias name prefixed by "alias/", a fully specified ARN to an alias, a fully
        /// specified ARN to a key, or a globally unique identifier.</p>
        /// <p>CloudTrail also supports KMS multi-Region keys. For more information about multi-Region keys,
        /// see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/multi-region-keys-overview.html">Using multi-Region keys</a> in the <i>Key Management Service Developer Guide</i>.</p>
        /// <p>Examples:</p>
        /// <ul>
        /// <li>
        /// <p>alias/MyAliasName</p>
        /// </li>
        /// <li>
        /// <p>arn:aws:kms:us-east-2:123456789012:alias/MyAliasName</p>
        /// </li>
        /// <li>
        /// <p>arn:aws:kms:us-east-2:123456789012:key/12345678-1234-1234-1234-123456789012</p>
        /// </li>
        /// <li>
        /// <p>12345678-1234-1234-1234-123456789012</p>
        /// </li>
        /// </ul>
        pub fn set_kms_key_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_kms_key_id(input);
            self
        }
        /// <p>Specifies whether the trail is created for all accounts in an organization in Organizations, or only for the current Amazon Web Services account.
        /// The default is false, and cannot be true unless the call is made on behalf of an Amazon Web Services account that is the management account for an organization in
        /// Organizations.</p>
        pub fn is_organization_trail(mut self, inp: bool) -> Self {
            self.inner = self.inner.is_organization_trail(inp);
            self
        }
        /// <p>Specifies whether the trail is created for all accounts in an organization in Organizations, or only for the current Amazon Web Services account.
        /// The default is false, and cannot be true unless the call is made on behalf of an Amazon Web Services account that is the management account for an organization in
        /// Organizations.</p>
        pub fn set_is_organization_trail(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_is_organization_trail(input);
            self
        }
        /// Appends an item to `TagsList`.
        ///
        /// To override the contents of this collection use [`set_tags_list`](Self::set_tags_list).
        ///
        /// <p>A list of tags.</p>
        pub fn tags_list(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags_list(inp);
            self
        }
        /// <p>A list of tags.</p>
        pub fn set_tags_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags_list(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteTrail`.
    ///
    /// <p>Deletes a trail. This operation must be called from the region in which the trail was
    /// created. <code>DeleteTrail</code> cannot be called on the shadow trails (replicated trails
    /// in other regions) of a trail that is enabled in all regions.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteTrail<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_trail_input::Builder,
    }
    impl<C, M, R> DeleteTrail<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteTrail`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteTrailOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteTrailError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteTrailInputOperationOutputAlias,
                crate::output::DeleteTrailOutput,
                crate::error::DeleteTrailError,
                crate::input::DeleteTrailInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>Specifies the name or the CloudTrail ARN of the trail to be deleted. The following is the format of a
        /// trail ARN.
        /// <code>arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail</code>
        /// </p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>Specifies the name or the CloudTrail ARN of the trail to be deleted. The following is the format of a
        /// trail ARN.
        /// <code>arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail</code>
        /// </p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeTrails`.
    ///
    /// <p>Retrieves settings for one or more trails associated with the current region for your account.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeTrails<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_trails_input::Builder,
    }
    impl<C, M, R> DescribeTrails<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeTrails`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeTrailsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeTrailsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeTrailsInputOperationOutputAlias,
                crate::output::DescribeTrailsOutput,
                crate::error::DescribeTrailsError,
                crate::input::DescribeTrailsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `trailNameList`.
        ///
        /// To override the contents of this collection use [`set_trail_name_list`](Self::set_trail_name_list).
        ///
        /// <p>Specifies a list of trail names, trail ARNs, or both, of the trails to describe. The format of a trail ARN is:</p>
        /// <p>
        /// <code>arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail</code>
        /// </p>
        ///
        /// <p>If an empty list is specified, information for the trail in the current region is returned.</p>
        /// <ul>
        /// <li>
        /// <p>If an empty list is specified and <code>IncludeShadowTrails</code> is false, then
        /// information for all trails in the current region is returned.</p>
        /// </li>
        /// <li>
        /// <p>If an empty list is specified and IncludeShadowTrails is null or true, then information for all trails in the current region and any associated shadow trails in other regions is returned.</p>
        /// </li>
        /// </ul>
        /// <note>
        /// <p>If one or more trail names are specified, information is returned only if the names match the names of trails belonging only to the current region. To return information about a trail in another region, you must specify its trail ARN.</p>
        /// </note>
        pub fn trail_name_list(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.trail_name_list(inp);
            self
        }
        /// <p>Specifies a list of trail names, trail ARNs, or both, of the trails to describe. The format of a trail ARN is:</p>
        /// <p>
        /// <code>arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail</code>
        /// </p>
        ///
        /// <p>If an empty list is specified, information for the trail in the current region is returned.</p>
        /// <ul>
        /// <li>
        /// <p>If an empty list is specified and <code>IncludeShadowTrails</code> is false, then
        /// information for all trails in the current region is returned.</p>
        /// </li>
        /// <li>
        /// <p>If an empty list is specified and IncludeShadowTrails is null or true, then information for all trails in the current region and any associated shadow trails in other regions is returned.</p>
        /// </li>
        /// </ul>
        /// <note>
        /// <p>If one or more trail names are specified, information is returned only if the names match the names of trails belonging only to the current region. To return information about a trail in another region, you must specify its trail ARN.</p>
        /// </note>
        pub fn set_trail_name_list(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_trail_name_list(input);
            self
        }
        /// <p>Specifies whether to include shadow trails in the response. A shadow trail is the replication in a region of a trail that was created in a different region,
        /// or in the case of an organization trail, the replication of an organization trail in member accounts. If you do not include shadow trails, organization trails in a member account
        /// and region replication trails will not be returned. The default is true.</p>
        pub fn include_shadow_trails(mut self, inp: bool) -> Self {
            self.inner = self.inner.include_shadow_trails(inp);
            self
        }
        /// <p>Specifies whether to include shadow trails in the response. A shadow trail is the replication in a region of a trail that was created in a different region,
        /// or in the case of an organization trail, the replication of an organization trail in member accounts. If you do not include shadow trails, organization trails in a member account
        /// and region replication trails will not be returned. The default is true.</p>
        pub fn set_include_shadow_trails(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_include_shadow_trails(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetEventSelectors`.
    ///
    /// <p>Describes the settings for the event selectors that you configured for your trail.
    /// The information returned for your event selectors includes the following:</p>
    /// <ul>
    /// <li>
    /// <p>If your event selector includes read-only events, write-only events, or
    /// all events. This applies to both management events and data events.</p>
    /// </li>
    /// <li>
    /// <p>If your event selector includes management events.</p>
    /// </li>
    /// <li>
    /// <p>If your event selector includes data events, the resources on which you are logging data
    /// events.</p>
    /// </li>
    /// </ul>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/logging-management-and-data-events-with-cloudtrail.html">Logging Data and Management Events for Trails
    /// </a> in the <i>CloudTrail User Guide</i>.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetEventSelectors<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_event_selectors_input::Builder,
    }
    impl<C, M, R> GetEventSelectors<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetEventSelectors`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetEventSelectorsOutput,
            aws_smithy_http::result::SdkError<crate::error::GetEventSelectorsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetEventSelectorsInputOperationOutputAlias,
                crate::output::GetEventSelectorsOutput,
                crate::error::GetEventSelectorsError,
                crate::input::GetEventSelectorsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>Specifies the name of the trail or trail ARN. If you specify a trail name, the
        /// string must meet the following requirements:</p>
        /// <ul>
        /// <li>
        /// <p>Contain only ASCII letters (a-z, A-Z), numbers (0-9), periods (.), underscores (_), or dashes (-)</p>
        /// </li>
        /// <li>
        /// <p>Start with a letter or number, and end with a letter or number</p>
        /// </li>
        /// <li>
        /// <p>Be between 3 and 128 characters</p>
        /// </li>
        /// <li>
        /// <p>Have no adjacent periods, underscores or dashes. Names like <code>my-_namespace</code>
        /// and <code>my--namespace</code> are not valid.</p>
        /// </li>
        /// <li>
        /// <p>Not be in IP address format (for example, 192.168.5.4)</p>
        /// </li>
        /// </ul>
        /// <p>If you specify a trail ARN, it must be in the format:</p>
        /// <p>
        /// <code>arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail</code>
        /// </p>
        pub fn trail_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.trail_name(inp);
            self
        }
        /// <p>Specifies the name of the trail or trail ARN. If you specify a trail name, the
        /// string must meet the following requirements:</p>
        /// <ul>
        /// <li>
        /// <p>Contain only ASCII letters (a-z, A-Z), numbers (0-9), periods (.), underscores (_), or dashes (-)</p>
        /// </li>
        /// <li>
        /// <p>Start with a letter or number, and end with a letter or number</p>
        /// </li>
        /// <li>
        /// <p>Be between 3 and 128 characters</p>
        /// </li>
        /// <li>
        /// <p>Have no adjacent periods, underscores or dashes. Names like <code>my-_namespace</code>
        /// and <code>my--namespace</code> are not valid.</p>
        /// </li>
        /// <li>
        /// <p>Not be in IP address format (for example, 192.168.5.4)</p>
        /// </li>
        /// </ul>
        /// <p>If you specify a trail ARN, it must be in the format:</p>
        /// <p>
        /// <code>arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail</code>
        /// </p>
        pub fn set_trail_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_trail_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetInsightSelectors`.
    ///
    /// <p>Describes the settings for the Insights event selectors that you configured for your trail. <code>GetInsightSelectors</code> shows
    /// if CloudTrail Insights event logging is enabled on the trail, and if it is, which insight types are enabled.
    /// If you run <code>GetInsightSelectors</code> on a trail that does not have Insights events enabled, the operation throws the exception
    /// <code>InsightNotEnabledException</code>
    /// </p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/logging-insights-events-with-cloudtrail.html">Logging CloudTrail Insights Events for Trails
    /// </a> in the <i>CloudTrail User Guide</i>.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetInsightSelectors<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_insight_selectors_input::Builder,
    }
    impl<C, M, R> GetInsightSelectors<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetInsightSelectors`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetInsightSelectorsOutput,
            aws_smithy_http::result::SdkError<crate::error::GetInsightSelectorsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetInsightSelectorsInputOperationOutputAlias,
                crate::output::GetInsightSelectorsOutput,
                crate::error::GetInsightSelectorsError,
                crate::input::GetInsightSelectorsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>Specifies the name of the trail or trail ARN. If you specify a trail name, the
        /// string must meet the following requirements:</p>
        /// <ul>
        /// <li>
        /// <p>Contain only ASCII letters (a-z, A-Z), numbers (0-9), periods (.), underscores (_), or dashes (-)</p>
        /// </li>
        /// <li>
        /// <p>Start with a letter or number, and end with a letter or number</p>
        /// </li>
        /// <li>
        /// <p>Be between 3 and 128 characters</p>
        /// </li>
        /// <li>
        /// <p>Have no adjacent periods, underscores or dashes. Names like <code>my-_namespace</code>
        /// and <code>my--namespace</code> are not valid.</p>
        /// </li>
        /// <li>
        /// <p>Not be in IP address format (for example, 192.168.5.4)</p>
        /// </li>
        /// </ul>
        /// <p>If you specify a trail ARN, it must be in the format:</p>
        /// <p>
        /// <code>arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail</code>
        /// </p>
        pub fn trail_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.trail_name(inp);
            self
        }
        /// <p>Specifies the name of the trail or trail ARN. If you specify a trail name, the
        /// string must meet the following requirements:</p>
        /// <ul>
        /// <li>
        /// <p>Contain only ASCII letters (a-z, A-Z), numbers (0-9), periods (.), underscores (_), or dashes (-)</p>
        /// </li>
        /// <li>
        /// <p>Start with a letter or number, and end with a letter or number</p>
        /// </li>
        /// <li>
        /// <p>Be between 3 and 128 characters</p>
        /// </li>
        /// <li>
        /// <p>Have no adjacent periods, underscores or dashes. Names like <code>my-_namespace</code>
        /// and <code>my--namespace</code> are not valid.</p>
        /// </li>
        /// <li>
        /// <p>Not be in IP address format (for example, 192.168.5.4)</p>
        /// </li>
        /// </ul>
        /// <p>If you specify a trail ARN, it must be in the format:</p>
        /// <p>
        /// <code>arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail</code>
        /// </p>
        pub fn set_trail_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_trail_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetTrail`.
    ///
    /// <p>Returns settings information for a specified trail.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetTrail<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_trail_input::Builder,
    }
    impl<C, M, R> GetTrail<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetTrail`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetTrailOutput,
            aws_smithy_http::result::SdkError<crate::error::GetTrailError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetTrailInputOperationOutputAlias,
                crate::output::GetTrailOutput,
                crate::error::GetTrailError,
                crate::input::GetTrailInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The name or the Amazon Resource Name (ARN) of the trail for which you want to retrieve settings information.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name or the Amazon Resource Name (ARN) of the trail for which you want to retrieve settings information.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetTrailStatus`.
    ///
    /// <p>Returns a JSON-formatted list of information about the specified trail. Fields include information on delivery errors, Amazon SNS and Amazon S3 errors, and start and stop logging times for each trail. This operation returns trail status from a single region. To return trail status from all regions, you must call the operation on each region.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetTrailStatus<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_trail_status_input::Builder,
    }
    impl<C, M, R> GetTrailStatus<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetTrailStatus`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetTrailStatusOutput,
            aws_smithy_http::result::SdkError<crate::error::GetTrailStatusError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetTrailStatusInputOperationOutputAlias,
                crate::output::GetTrailStatusOutput,
                crate::error::GetTrailStatusError,
                crate::input::GetTrailStatusInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>Specifies the name or the CloudTrail ARN of the trail for which you are requesting status. To get the status of a
        /// shadow trail (a replication of the trail in another region), you must specify its ARN. The following is the format of a trail ARN.</p>
        /// <p>
        /// <code>arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail</code>
        /// </p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>Specifies the name or the CloudTrail ARN of the trail for which you are requesting status. To get the status of a
        /// shadow trail (a replication of the trail in another region), you must specify its ARN. The following is the format of a trail ARN.</p>
        /// <p>
        /// <code>arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail</code>
        /// </p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListPublicKeys`.
    ///
    /// <p>Returns all public keys whose private keys were used to sign the digest files within the specified time range. The public key is needed to validate digest files that were signed with its corresponding private key.</p>
    /// <note>
    /// <p>CloudTrail uses different private and public key pairs per region. Each digest file is signed with a private key
    /// unique to its region. When you validate a digest file from a specific region, you must look in the same region for its
    /// corresponding public key.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct ListPublicKeys<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_public_keys_input::Builder,
    }
    impl<C, M, R> ListPublicKeys<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListPublicKeys`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListPublicKeysOutput,
            aws_smithy_http::result::SdkError<crate::error::ListPublicKeysError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListPublicKeysInputOperationOutputAlias,
                crate::output::ListPublicKeysOutput,
                crate::error::ListPublicKeysError,
                crate::input::ListPublicKeysInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>Optionally specifies, in UTC, the start of the time range to look up public keys for CloudTrail digest files.
        /// If not specified, the current time is used, and the current public key is returned.</p>
        pub fn start_time(mut self, inp: aws_smithy_types::Instant) -> Self {
            self.inner = self.inner.start_time(inp);
            self
        }
        /// <p>Optionally specifies, in UTC, the start of the time range to look up public keys for CloudTrail digest files.
        /// If not specified, the current time is used, and the current public key is returned.</p>
        pub fn set_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.inner = self.inner.set_start_time(input);
            self
        }
        /// <p>Optionally specifies, in UTC, the end of the time range to look up public keys for CloudTrail digest files. If not
        /// specified, the current time is used.</p>
        pub fn end_time(mut self, inp: aws_smithy_types::Instant) -> Self {
            self.inner = self.inner.end_time(inp);
            self
        }
        /// <p>Optionally specifies, in UTC, the end of the time range to look up public keys for CloudTrail digest files. If not
        /// specified, the current time is used.</p>
        pub fn set_end_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.inner = self.inner.set_end_time(input);
            self
        }
        /// <p>Reserved for future use.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>Reserved for future use.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTags`.
    ///
    /// <p>Lists the tags for the trail in the current region.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListTags<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_tags_input::Builder,
    }
    impl<C, M, R> ListTags<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListTags`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTagsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTagsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListTagsInputOperationOutputAlias,
                crate::output::ListTagsOutput,
                crate::error::ListTagsError,
                crate::input::ListTagsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `ResourceIdList`.
        ///
        /// To override the contents of this collection use [`set_resource_id_list`](Self::set_resource_id_list).
        ///
        /// <p>Specifies a list of trail ARNs whose tags will be listed. The list has a limit of 20 ARNs. The following is the format of
        /// a trail ARN.</p>
        /// <p>
        /// <code>arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail</code>
        /// </p>
        pub fn resource_id_list(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_id_list(inp);
            self
        }
        /// <p>Specifies a list of trail ARNs whose tags will be listed. The list has a limit of 20 ARNs. The following is the format of
        /// a trail ARN.</p>
        /// <p>
        /// <code>arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail</code>
        /// </p>
        pub fn set_resource_id_list(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_resource_id_list(input);
            self
        }
        /// <p>Reserved for future use.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>Reserved for future use.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTrails`.
    ///
    /// <p>Lists trails that are in the current account.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListTrails<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_trails_input::Builder,
    }
    impl<C, M, R> ListTrails<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListTrails`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTrailsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTrailsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListTrailsInputOperationOutputAlias,
                crate::output::ListTrailsOutput,
                crate::error::ListTrailsError,
                crate::input::ListTrailsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The token to use to get the next page of results after a previous API call. This token must be passed
        /// in with the same parameters that were specified in the the original call. For example, if the original
        /// call specified an AttributeKey of 'Username' with a value of 'root', the call with NextToken should
        /// include those same parameters.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The token to use to get the next page of results after a previous API call. This token must be passed
        /// in with the same parameters that were specified in the the original call. For example, if the original
        /// call specified an AttributeKey of 'Username' with a value of 'root', the call with NextToken should
        /// include those same parameters.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `LookupEvents`.
    ///
    /// <p>Looks up <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/cloudtrail-concepts.html#cloudtrail-concepts-management-events">management events</a> or
    /// <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/cloudtrail-concepts.html#cloudtrail-concepts-insights-events">CloudTrail Insights events</a> that are captured by CloudTrail.
    /// You can look up events that occurred in a region within the last 90 days. Lookup supports the following attributes for management events:</p>
    /// <ul>
    /// <li>
    /// <p>Amazon Web Services access key</p>
    /// </li>
    /// <li>
    /// <p>Event ID</p>
    /// </li>
    /// <li>
    /// <p>Event name</p>
    /// </li>
    /// <li>
    /// <p>Event source</p>
    /// </li>
    /// <li>
    /// <p>Read only</p>
    /// </li>
    /// <li>
    /// <p>Resource name</p>
    /// </li>
    /// <li>
    /// <p>Resource type</p>
    /// </li>
    /// <li>
    /// <p>User name</p>
    /// </li>
    /// </ul>
    /// <p>Lookup supports the following attributes for Insights events:</p>
    /// <ul>
    /// <li>
    /// <p>Event ID</p>
    /// </li>
    /// <li>
    /// <p>Event name</p>
    /// </li>
    /// <li>
    /// <p>Event source</p>
    /// </li>
    /// </ul>
    /// <p>All attributes are optional. The default number of results returned is 50, with a
    /// maximum of 50 possible. The response includes a token that you can use to get the next page
    /// of results.</p>
    /// <important>
    /// <p>The rate of lookup requests is limited to two per second, per account, per region. If this
    /// limit is exceeded, a throttling error occurs.</p>
    /// </important>
    #[derive(std::fmt::Debug)]
    pub struct LookupEvents<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::lookup_events_input::Builder,
    }
    impl<C, M, R> LookupEvents<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `LookupEvents`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::LookupEventsOutput,
            aws_smithy_http::result::SdkError<crate::error::LookupEventsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::LookupEventsInputOperationOutputAlias,
                crate::output::LookupEventsOutput,
                crate::error::LookupEventsError,
                crate::input::LookupEventsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `LookupAttributes`.
        ///
        /// To override the contents of this collection use [`set_lookup_attributes`](Self::set_lookup_attributes).
        ///
        /// <p>Contains a list of lookup attributes. Currently the list can contain only one item.</p>
        pub fn lookup_attributes(mut self, inp: impl Into<crate::model::LookupAttribute>) -> Self {
            self.inner = self.inner.lookup_attributes(inp);
            self
        }
        /// <p>Contains a list of lookup attributes. Currently the list can contain only one item.</p>
        pub fn set_lookup_attributes(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::LookupAttribute>>,
        ) -> Self {
            self.inner = self.inner.set_lookup_attributes(input);
            self
        }
        /// <p>Specifies that only events that occur after or at the specified time are returned. If the specified start time is after the specified end time, an error is returned.</p>
        pub fn start_time(mut self, inp: aws_smithy_types::Instant) -> Self {
            self.inner = self.inner.start_time(inp);
            self
        }
        /// <p>Specifies that only events that occur after or at the specified time are returned. If the specified start time is after the specified end time, an error is returned.</p>
        pub fn set_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.inner = self.inner.set_start_time(input);
            self
        }
        /// <p>Specifies that only events that occur before or at the specified time are returned. If the specified end time is before the specified start time, an error is returned.</p>
        pub fn end_time(mut self, inp: aws_smithy_types::Instant) -> Self {
            self.inner = self.inner.end_time(inp);
            self
        }
        /// <p>Specifies that only events that occur before or at the specified time are returned. If the specified end time is before the specified start time, an error is returned.</p>
        pub fn set_end_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.inner = self.inner.set_end_time(input);
            self
        }
        /// <p>Specifies the event category. If you do not specify an event category, events of the category are not returned in the response. For example,
        /// if you do not specify <code>insight</code> as the value of <code>EventCategory</code>, no Insights events are returned.</p>
        pub fn event_category(mut self, inp: crate::model::EventCategory) -> Self {
            self.inner = self.inner.event_category(inp);
            self
        }
        /// <p>Specifies the event category. If you do not specify an event category, events of the category are not returned in the response. For example,
        /// if you do not specify <code>insight</code> as the value of <code>EventCategory</code>, no Insights events are returned.</p>
        pub fn set_event_category(
            mut self,
            input: std::option::Option<crate::model::EventCategory>,
        ) -> Self {
            self.inner = self.inner.set_event_category(input);
            self
        }
        /// <p>The number of events to return. Possible values are 1 through 50. The default is 50.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The number of events to return. Possible values are 1 through 50. The default is 50.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token to use to get the next page of results after a previous API call. This token must be passed in with the same parameters that were specified in the the original call.
        /// For example, if the original call specified an AttributeKey of 'Username' with a value of 'root', the call with NextToken should include those same parameters.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The token to use to get the next page of results after a previous API call. This token must be passed in with the same parameters that were specified in the the original call.
        /// For example, if the original call specified an AttributeKey of 'Username' with a value of 'root', the call with NextToken should include those same parameters.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutEventSelectors`.
    ///
    /// <p>Configures an event selector or advanced event selectors for your trail.
    /// Use event selectors or advanced event selectors to specify management and data event settings for your trail. By
    /// default, trails created without specific event selectors are configured to log all read and
    /// write management events, and no data events.</p>
    /// <p>When an event occurs in your account, CloudTrail
    /// evaluates the event selectors or advanced event selectors in all trails. For each trail, if the event matches
    /// any event selector, the trail processes and logs the event. If the event doesn't match any event
    /// selector, the trail doesn't log the event.</p>
    /// <p>Example</p>
    /// <ol>
    /// <li>
    /// <p>You create an event selector for a trail and specify that you want
    /// write-only events.</p>
    /// </li>
    /// <li>
    /// <p>The EC2 <code>GetConsoleOutput</code> and <code>RunInstances</code> API
    /// operations occur in your account.</p>
    /// </li>
    /// <li>
    /// <p>CloudTrail evaluates whether the events match your event
    /// selectors.</p>
    /// </li>
    /// <li>
    /// <p>The <code>RunInstances</code> is a write-only event and it matches your
    /// event selector. The trail logs the event.</p>
    /// </li>
    /// <li>
    /// <p>The <code>GetConsoleOutput</code> is a read-only event that doesn't
    /// match your event selector. The trail doesn't log the event.
    /// </p>
    /// </li>
    /// </ol>
    /// <p>The <code>PutEventSelectors</code> operation must be called from the region in which
    /// the trail was created; otherwise, an <code>InvalidHomeRegionException</code> exception is
    /// thrown.</p>
    /// <p>You can configure up to five event selectors for each trail. For more information, see <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/logging-management-and-data-events-with-cloudtrail.html">Logging data and management events for trails
    /// </a> and <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/WhatIsCloudTrail-Limits.html">Quotas in CloudTrail</a>
    /// in the <i>CloudTrail User Guide</i>.</p>
    /// <p>You can add advanced event selectors, and conditions for your advanced
    /// event selectors, up to a maximum of 500 values for all conditions and selectors on a trail.
    /// You can use either <code>AdvancedEventSelectors</code> or <code>EventSelectors</code>, but not both. If you apply <code>AdvancedEventSelectors</code>
    /// to a trail, any existing <code>EventSelectors</code> are overwritten. For more information about
    /// advanced event selectors, see
    /// <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/logging-data-events-with-cloudtrail.html">Logging
    /// data events for trails</a> in the <i>CloudTrail User Guide</i>.</p>
    #[derive(std::fmt::Debug)]
    pub struct PutEventSelectors<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::put_event_selectors_input::Builder,
    }
    impl<C, M, R> PutEventSelectors<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `PutEventSelectors`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutEventSelectorsOutput,
            aws_smithy_http::result::SdkError<crate::error::PutEventSelectorsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::PutEventSelectorsInputOperationOutputAlias,
                crate::output::PutEventSelectorsOutput,
                crate::error::PutEventSelectorsError,
                crate::input::PutEventSelectorsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>Specifies the name of the trail or trail ARN. If you specify a trail name, the
        /// string must meet the following requirements:</p>
        /// <ul>
        /// <li>
        /// <p>Contain only ASCII letters (a-z, A-Z), numbers (0-9), periods (.), underscores (_), or dashes (-)</p>
        /// </li>
        /// <li>
        /// <p>Start with a letter or number, and end with a letter or number</p>
        /// </li>
        /// <li>
        /// <p>Be between 3 and 128 characters</p>
        /// </li>
        /// <li>
        /// <p>Have no adjacent periods, underscores or dashes. Names like <code>my-_namespace</code>
        /// and <code>my--namespace</code> are not valid.</p>
        /// </li>
        /// <li>
        /// <p>Not be in IP address format (for example, 192.168.5.4)</p>
        /// </li>
        /// </ul>
        /// <p>If you specify a trail ARN, it must be in the following format.</p>
        /// <p>
        /// <code>arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail</code>
        /// </p>
        pub fn trail_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.trail_name(inp);
            self
        }
        /// <p>Specifies the name of the trail or trail ARN. If you specify a trail name, the
        /// string must meet the following requirements:</p>
        /// <ul>
        /// <li>
        /// <p>Contain only ASCII letters (a-z, A-Z), numbers (0-9), periods (.), underscores (_), or dashes (-)</p>
        /// </li>
        /// <li>
        /// <p>Start with a letter or number, and end with a letter or number</p>
        /// </li>
        /// <li>
        /// <p>Be between 3 and 128 characters</p>
        /// </li>
        /// <li>
        /// <p>Have no adjacent periods, underscores or dashes. Names like <code>my-_namespace</code>
        /// and <code>my--namespace</code> are not valid.</p>
        /// </li>
        /// <li>
        /// <p>Not be in IP address format (for example, 192.168.5.4)</p>
        /// </li>
        /// </ul>
        /// <p>If you specify a trail ARN, it must be in the following format.</p>
        /// <p>
        /// <code>arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail</code>
        /// </p>
        pub fn set_trail_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_trail_name(input);
            self
        }
        /// Appends an item to `EventSelectors`.
        ///
        /// To override the contents of this collection use [`set_event_selectors`](Self::set_event_selectors).
        ///
        /// <p>Specifies the settings for your event selectors. You can configure up to five event selectors for a trail.
        /// You can use either <code>EventSelectors</code> or <code>AdvancedEventSelectors</code> in a <code>PutEventSelectors</code> request, but not both.
        /// If you apply <code>EventSelectors</code> to a trail, any existing <code>AdvancedEventSelectors</code> are overwritten.</p>
        pub fn event_selectors(mut self, inp: impl Into<crate::model::EventSelector>) -> Self {
            self.inner = self.inner.event_selectors(inp);
            self
        }
        /// <p>Specifies the settings for your event selectors. You can configure up to five event selectors for a trail.
        /// You can use either <code>EventSelectors</code> or <code>AdvancedEventSelectors</code> in a <code>PutEventSelectors</code> request, but not both.
        /// If you apply <code>EventSelectors</code> to a trail, any existing <code>AdvancedEventSelectors</code> are overwritten.</p>
        pub fn set_event_selectors(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::EventSelector>>,
        ) -> Self {
            self.inner = self.inner.set_event_selectors(input);
            self
        }
        /// Appends an item to `AdvancedEventSelectors`.
        ///
        /// To override the contents of this collection use [`set_advanced_event_selectors`](Self::set_advanced_event_selectors).
        ///
        /// <p>
        /// Specifies the settings for advanced event selectors. You can add advanced event selectors, and conditions for your advanced
        /// event selectors, up to a maximum of 500 values for all conditions and selectors on a trail.
        /// You can use either <code>AdvancedEventSelectors</code> or <code>EventSelectors</code>, but not both. If you apply <code>AdvancedEventSelectors</code>
        /// to a trail, any existing <code>EventSelectors</code> are overwritten. For more information about
        /// advanced event selectors, see
        /// <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/logging-data-events-with-cloudtrail.html">Logging
        /// data events for trails</a> in the <i>CloudTrail User Guide</i>.
        /// </p>
        pub fn advanced_event_selectors(
            mut self,
            inp: impl Into<crate::model::AdvancedEventSelector>,
        ) -> Self {
            self.inner = self.inner.advanced_event_selectors(inp);
            self
        }
        /// <p>
        /// Specifies the settings for advanced event selectors. You can add advanced event selectors, and conditions for your advanced
        /// event selectors, up to a maximum of 500 values for all conditions and selectors on a trail.
        /// You can use either <code>AdvancedEventSelectors</code> or <code>EventSelectors</code>, but not both. If you apply <code>AdvancedEventSelectors</code>
        /// to a trail, any existing <code>EventSelectors</code> are overwritten. For more information about
        /// advanced event selectors, see
        /// <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/logging-data-events-with-cloudtrail.html">Logging
        /// data events for trails</a> in the <i>CloudTrail User Guide</i>.
        /// </p>
        pub fn set_advanced_event_selectors(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AdvancedEventSelector>>,
        ) -> Self {
            self.inner = self.inner.set_advanced_event_selectors(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutInsightSelectors`.
    ///
    /// <p>Lets you enable Insights event logging by specifying the Insights
    /// selectors that you want to enable on an existing trail. You also use
    /// <code>PutInsightSelectors</code> to turn off Insights event logging, by passing an empty list of insight types.
    /// The valid Insights event type in this release is <code>ApiCallRateInsight</code>.</p>
    #[derive(std::fmt::Debug)]
    pub struct PutInsightSelectors<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::put_insight_selectors_input::Builder,
    }
    impl<C, M, R> PutInsightSelectors<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `PutInsightSelectors`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutInsightSelectorsOutput,
            aws_smithy_http::result::SdkError<crate::error::PutInsightSelectorsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::PutInsightSelectorsInputOperationOutputAlias,
                crate::output::PutInsightSelectorsOutput,
                crate::error::PutInsightSelectorsError,
                crate::input::PutInsightSelectorsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the CloudTrail trail for which you want to change or add Insights selectors.</p>
        pub fn trail_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.trail_name(inp);
            self
        }
        /// <p>The name of the CloudTrail trail for which you want to change or add Insights selectors.</p>
        pub fn set_trail_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_trail_name(input);
            self
        }
        /// Appends an item to `InsightSelectors`.
        ///
        /// To override the contents of this collection use [`set_insight_selectors`](Self::set_insight_selectors).
        ///
        /// <p>A JSON string that contains the Insights types that you want to log on a trail. The valid Insights type in this release is <code>ApiCallRateInsight</code>.</p>
        pub fn insight_selectors(mut self, inp: impl Into<crate::model::InsightSelector>) -> Self {
            self.inner = self.inner.insight_selectors(inp);
            self
        }
        /// <p>A JSON string that contains the Insights types that you want to log on a trail. The valid Insights type in this release is <code>ApiCallRateInsight</code>.</p>
        pub fn set_insight_selectors(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::InsightSelector>>,
        ) -> Self {
            self.inner = self.inner.set_insight_selectors(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RemoveTags`.
    ///
    /// <p>Removes the specified tags from a trail.</p>
    #[derive(std::fmt::Debug)]
    pub struct RemoveTags<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::remove_tags_input::Builder,
    }
    impl<C, M, R> RemoveTags<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `RemoveTags`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RemoveTagsOutput,
            aws_smithy_http::result::SdkError<crate::error::RemoveTagsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::RemoveTagsInputOperationOutputAlias,
                crate::output::RemoveTagsOutput,
                crate::error::RemoveTagsError,
                crate::input::RemoveTagsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>Specifies the ARN of the trail from which tags should be removed. The format of a trail ARN is:</p>
        /// <p>
        /// <code>arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail</code>
        /// </p>
        pub fn resource_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_id(inp);
            self
        }
        /// <p>Specifies the ARN of the trail from which tags should be removed. The format of a trail ARN is:</p>
        /// <p>
        /// <code>arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail</code>
        /// </p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_id(input);
            self
        }
        /// Appends an item to `TagsList`.
        ///
        /// To override the contents of this collection use [`set_tags_list`](Self::set_tags_list).
        ///
        /// <p>Specifies a list of tags to be removed.</p>
        pub fn tags_list(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags_list(inp);
            self
        }
        /// <p>Specifies a list of tags to be removed.</p>
        pub fn set_tags_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags_list(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StartLogging`.
    ///
    /// <p>Starts the recording of Amazon Web Services API calls and log file delivery for a trail. For a trail that is enabled in all regions, this operation must be called from the region in which the trail was created. This operation cannot be called on the shadow trails (replicated trails in other regions) of a trail that is enabled in all regions.</p>
    #[derive(std::fmt::Debug)]
    pub struct StartLogging<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::start_logging_input::Builder,
    }
    impl<C, M, R> StartLogging<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `StartLogging`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StartLoggingOutput,
            aws_smithy_http::result::SdkError<crate::error::StartLoggingError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::StartLoggingInputOperationOutputAlias,
                crate::output::StartLoggingOutput,
                crate::error::StartLoggingError,
                crate::input::StartLoggingInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>Specifies the name or the CloudTrail ARN of the trail for which CloudTrail logs Amazon Web Services API calls.
        /// The following is the format of a trail ARN.</p>
        /// <p>
        /// <code>arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail</code>
        /// </p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>Specifies the name or the CloudTrail ARN of the trail for which CloudTrail logs Amazon Web Services API calls.
        /// The following is the format of a trail ARN.</p>
        /// <p>
        /// <code>arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail</code>
        /// </p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StopLogging`.
    ///
    /// <p>Suspends the recording of Amazon Web Services API calls and log file delivery for the specified trail.
    /// Under most circumstances, there is no need to use this action. You can update a trail
    /// without stopping it first. This action is the only way to stop recording. For a trail
    /// enabled in all regions, this operation must be called from the region in which the trail
    /// was created, or an <code>InvalidHomeRegionException</code> will occur. This operation
    /// cannot be called on the shadow trails (replicated trails in other regions) of a trail
    /// enabled in all regions.</p>
    #[derive(std::fmt::Debug)]
    pub struct StopLogging<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::stop_logging_input::Builder,
    }
    impl<C, M, R> StopLogging<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `StopLogging`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StopLoggingOutput,
            aws_smithy_http::result::SdkError<crate::error::StopLoggingError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::StopLoggingInputOperationOutputAlias,
                crate::output::StopLoggingOutput,
                crate::error::StopLoggingError,
                crate::input::StopLoggingInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>Specifies the name or the CloudTrail ARN of the trail for which CloudTrail will stop logging Amazon Web Services
        /// API calls. The following is the format of a trail ARN.</p>
        /// <p>
        /// <code>arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail</code>
        /// </p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>Specifies the name or the CloudTrail ARN of the trail for which CloudTrail will stop logging Amazon Web Services
        /// API calls. The following is the format of a trail ARN.</p>
        /// <p>
        /// <code>arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail</code>
        /// </p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateTrail`.
    ///
    /// <p>Updates trail settings that control what events you are logging, and how to handle log files. Changes to a trail do not require
    /// stopping the CloudTrail service. Use this action to designate an existing bucket for log
    /// delivery. If the existing bucket has previously been a target for CloudTrail log files,
    /// an IAM policy exists for the bucket. <code>UpdateTrail</code> must be called from the
    /// region in which the trail was created; otherwise, an
    /// <code>InvalidHomeRegionException</code> is thrown.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateTrail<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_trail_input::Builder,
    }
    impl<C, M, R> UpdateTrail<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateTrail`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateTrailOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateTrailError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateTrailInputOperationOutputAlias,
                crate::output::UpdateTrailOutput,
                crate::error::UpdateTrailError,
                crate::input::UpdateTrailInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>Specifies the name of the trail or trail ARN. If <code>Name</code> is a trail name, the
        /// string must meet the following requirements:</p>
        /// <ul>
        /// <li>
        /// <p>Contain only ASCII letters (a-z, A-Z), numbers (0-9), periods (.), underscores (_), or dashes (-)</p>
        /// </li>
        /// <li>
        /// <p>Start with a letter or number, and end with a letter or number</p>
        /// </li>
        /// <li>
        /// <p>Be between 3 and 128 characters</p>
        /// </li>
        /// <li>
        /// <p>Have no adjacent periods, underscores or dashes. Names like <code>my-_namespace</code>
        /// and <code>my--namespace</code> are not valid.</p>
        /// </li>
        /// <li>
        /// <p>Not be in IP address format (for example, 192.168.5.4)</p>
        /// </li>
        /// </ul>
        /// <p>If <code>Name</code> is a trail ARN, it must be in the following format.</p>
        /// <p>
        /// <code>arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail</code>
        /// </p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>Specifies the name of the trail or trail ARN. If <code>Name</code> is a trail name, the
        /// string must meet the following requirements:</p>
        /// <ul>
        /// <li>
        /// <p>Contain only ASCII letters (a-z, A-Z), numbers (0-9), periods (.), underscores (_), or dashes (-)</p>
        /// </li>
        /// <li>
        /// <p>Start with a letter or number, and end with a letter or number</p>
        /// </li>
        /// <li>
        /// <p>Be between 3 and 128 characters</p>
        /// </li>
        /// <li>
        /// <p>Have no adjacent periods, underscores or dashes. Names like <code>my-_namespace</code>
        /// and <code>my--namespace</code> are not valid.</p>
        /// </li>
        /// <li>
        /// <p>Not be in IP address format (for example, 192.168.5.4)</p>
        /// </li>
        /// </ul>
        /// <p>If <code>Name</code> is a trail ARN, it must be in the following format.</p>
        /// <p>
        /// <code>arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail</code>
        /// </p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>Specifies the name of the Amazon S3 bucket designated for publishing log files. See <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/create_trail_naming_policy.html">Amazon S3 Bucket Naming Requirements</a>.</p>
        pub fn s3_bucket_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.s3_bucket_name(inp);
            self
        }
        /// <p>Specifies the name of the Amazon S3 bucket designated for publishing log files. See <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/create_trail_naming_policy.html">Amazon S3 Bucket Naming Requirements</a>.</p>
        pub fn set_s3_bucket_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_s3_bucket_name(input);
            self
        }
        /// <p>Specifies the Amazon S3 key prefix that comes after the name of the bucket you have designated
        /// for log file delivery. For more information, see <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/cloudtrail-find-log-files.html">Finding Your CloudTrail Log Files</a>. The maximum length is 200 characters.</p>
        pub fn s3_key_prefix(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.s3_key_prefix(inp);
            self
        }
        /// <p>Specifies the Amazon S3 key prefix that comes after the name of the bucket you have designated
        /// for log file delivery. For more information, see <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/cloudtrail-find-log-files.html">Finding Your CloudTrail Log Files</a>. The maximum length is 200 characters.</p>
        pub fn set_s3_key_prefix(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_s3_key_prefix(input);
            self
        }
        /// <p>Specifies the name of the Amazon SNS topic defined for notification of log file delivery. The maximum length is 256 characters.</p>
        pub fn sns_topic_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.sns_topic_name(inp);
            self
        }
        /// <p>Specifies the name of the Amazon SNS topic defined for notification of log file delivery. The maximum length is 256 characters.</p>
        pub fn set_sns_topic_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_sns_topic_name(input);
            self
        }
        /// <p>Specifies whether the trail is publishing events from global services such as IAM to the log files.</p>
        pub fn include_global_service_events(mut self, inp: bool) -> Self {
            self.inner = self.inner.include_global_service_events(inp);
            self
        }
        /// <p>Specifies whether the trail is publishing events from global services such as IAM to the log files.</p>
        pub fn set_include_global_service_events(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.inner = self.inner.set_include_global_service_events(input);
            self
        }
        /// <p>Specifies whether the trail applies only to the current region or to all regions. The default is false. If the trail exists only in the current region and this value is set to true,
        /// shadow trails (replications of the trail) will be created in the other regions. If the trail exists in all regions and this value is set to false, the trail will remain in the region
        /// where it was created, and its shadow trails in other regions will be deleted. As a best practice, consider
        /// using trails that log events in all regions.</p>
        pub fn is_multi_region_trail(mut self, inp: bool) -> Self {
            self.inner = self.inner.is_multi_region_trail(inp);
            self
        }
        /// <p>Specifies whether the trail applies only to the current region or to all regions. The default is false. If the trail exists only in the current region and this value is set to true,
        /// shadow trails (replications of the trail) will be created in the other regions. If the trail exists in all regions and this value is set to false, the trail will remain in the region
        /// where it was created, and its shadow trails in other regions will be deleted. As a best practice, consider
        /// using trails that log events in all regions.</p>
        pub fn set_is_multi_region_trail(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_is_multi_region_trail(input);
            self
        }
        /// <p>Specifies whether log file validation is enabled. The default is false.</p>
        /// <note>
        /// <p>When you disable log file integrity validation, the chain of digest files is broken after one hour. CloudTrail
        /// does not create digest files for log files that were delivered during a period in which log file integrity validation
        /// was disabled. For example, if you enable log file integrity validation at noon on January 1, disable it at noon on
        /// January 2, and re-enable it at noon on January 10, digest files will not be created for the log files delivered from noon
        /// on January 2 to noon on January 10. The same applies whenever you stop CloudTrail logging or delete a trail.</p>
        /// </note>
        pub fn enable_log_file_validation(mut self, inp: bool) -> Self {
            self.inner = self.inner.enable_log_file_validation(inp);
            self
        }
        /// <p>Specifies whether log file validation is enabled. The default is false.</p>
        /// <note>
        /// <p>When you disable log file integrity validation, the chain of digest files is broken after one hour. CloudTrail
        /// does not create digest files for log files that were delivered during a period in which log file integrity validation
        /// was disabled. For example, if you enable log file integrity validation at noon on January 1, disable it at noon on
        /// January 2, and re-enable it at noon on January 10, digest files will not be created for the log files delivered from noon
        /// on January 2 to noon on January 10. The same applies whenever you stop CloudTrail logging or delete a trail.</p>
        /// </note>
        pub fn set_enable_log_file_validation(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_enable_log_file_validation(input);
            self
        }
        /// <p>Specifies a log group name using an Amazon Resource Name (ARN), a unique identifier that represents the log group to which CloudTrail logs are delivered. Not required unless you specify <code>CloudWatchLogsRoleArn</code>.</p>
        pub fn cloud_watch_logs_log_group_arn(
            mut self,
            inp: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.cloud_watch_logs_log_group_arn(inp);
            self
        }
        /// <p>Specifies a log group name using an Amazon Resource Name (ARN), a unique identifier that represents the log group to which CloudTrail logs are delivered. Not required unless you specify <code>CloudWatchLogsRoleArn</code>.</p>
        pub fn set_cloud_watch_logs_log_group_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_cloud_watch_logs_log_group_arn(input);
            self
        }
        /// <p>Specifies the role for the CloudWatch Logs endpoint to assume to write to a user's log group.</p>
        pub fn cloud_watch_logs_role_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cloud_watch_logs_role_arn(inp);
            self
        }
        /// <p>Specifies the role for the CloudWatch Logs endpoint to assume to write to a user's log group.</p>
        pub fn set_cloud_watch_logs_role_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_cloud_watch_logs_role_arn(input);
            self
        }
        /// <p>Specifies the KMS key ID to use to encrypt the logs delivered by CloudTrail. The
        /// value can be an alias name prefixed by "alias/", a fully specified ARN to an alias, a fully
        /// specified ARN to a key, or a globally unique identifier.</p>
        /// <p>CloudTrail also supports KMS multi-Region keys. For more information about multi-Region keys,
        /// see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/multi-region-keys-overview.html">Using multi-Region keys</a> in the <i>Key Management Service Developer Guide</i>.</p>
        /// <p>Examples:</p>
        /// <ul>
        /// <li>
        /// <p>alias/MyAliasName</p>
        /// </li>
        /// <li>
        /// <p>arn:aws:kms:us-east-2:123456789012:alias/MyAliasName</p>
        /// </li>
        /// <li>
        /// <p>arn:aws:kms:us-east-2:123456789012:key/12345678-1234-1234-1234-123456789012</p>
        /// </li>
        /// <li>
        /// <p>12345678-1234-1234-1234-123456789012</p>
        /// </li>
        /// </ul>
        pub fn kms_key_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.kms_key_id(inp);
            self
        }
        /// <p>Specifies the KMS key ID to use to encrypt the logs delivered by CloudTrail. The
        /// value can be an alias name prefixed by "alias/", a fully specified ARN to an alias, a fully
        /// specified ARN to a key, or a globally unique identifier.</p>
        /// <p>CloudTrail also supports KMS multi-Region keys. For more information about multi-Region keys,
        /// see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/multi-region-keys-overview.html">Using multi-Region keys</a> in the <i>Key Management Service Developer Guide</i>.</p>
        /// <p>Examples:</p>
        /// <ul>
        /// <li>
        /// <p>alias/MyAliasName</p>
        /// </li>
        /// <li>
        /// <p>arn:aws:kms:us-east-2:123456789012:alias/MyAliasName</p>
        /// </li>
        /// <li>
        /// <p>arn:aws:kms:us-east-2:123456789012:key/12345678-1234-1234-1234-123456789012</p>
        /// </li>
        /// <li>
        /// <p>12345678-1234-1234-1234-123456789012</p>
        /// </li>
        /// </ul>
        pub fn set_kms_key_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_kms_key_id(input);
            self
        }
        /// <p>Specifies whether the trail is applied to all accounts in an organization in Organizations, or only for the current Amazon Web Services account.
        /// The default is false, and cannot be true unless the call is made on behalf of an Amazon Web Services account that is the management account for an organization in
        /// Organizations. If the trail is not an organization trail and this is set to <code>true</code>, the trail will be created in all Amazon Web Services accounts that belong
        /// to the organization. If the trail is an organization trail and this is set to <code>false</code>, the trail will remain in the current Amazon Web Services account but be
        /// deleted from all member accounts in the organization.</p>
        pub fn is_organization_trail(mut self, inp: bool) -> Self {
            self.inner = self.inner.is_organization_trail(inp);
            self
        }
        /// <p>Specifies whether the trail is applied to all accounts in an organization in Organizations, or only for the current Amazon Web Services account.
        /// The default is false, and cannot be true unless the call is made on behalf of an Amazon Web Services account that is the management account for an organization in
        /// Organizations. If the trail is not an organization trail and this is set to <code>true</code>, the trail will be created in all Amazon Web Services accounts that belong
        /// to the organization. If the trail is an organization trail and this is set to <code>false</code>, the trail will remain in the current Amazon Web Services account but be
        /// deleted from all member accounts in the organization.</p>
        pub fn set_is_organization_trail(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_is_organization_trail(input);
            self
        }
    }
}
impl<C> Client<C, aws_hyper::AwsMiddleware, aws_smithy_client::retry::Standard> {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn(conf: crate::Config, conn: C) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let client = aws_hyper::Client::new(conn).with_retry_config(retry_config.into());
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
impl
    Client<
        aws_smithy_client::erase::DynConnector,
        aws_hyper::AwsMiddleware,
        aws_smithy_client::retry::Standard,
    >
{
    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(config: &aws_types::config::Config) -> Self {
        Self::from_conf(config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let client = aws_hyper::Client::https().with_retry_config(retry_config.into());
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
