// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// <p>A warning returned by the document service when an issue is discovered while processing an upload request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DocumentServiceWarning {
    /// <p>The description for a warning returned by the document service.</p>
    pub message: std::option::Option<std::string::String>,
}
impl DocumentServiceWarning {
    /// <p>The description for a warning returned by the document service.</p>
    pub fn message(&self) -> std::option::Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Debug for DocumentServiceWarning {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DocumentServiceWarning");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
/// See [`DocumentServiceWarning`](crate::model::DocumentServiceWarning)
pub mod document_service_warning {
    /// A builder for [`DocumentServiceWarning`](crate::model::DocumentServiceWarning)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The description for a warning returned by the document service.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The description for a warning returned by the document service.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`DocumentServiceWarning`](crate::model::DocumentServiceWarning)
        pub fn build(self) -> crate::model::DocumentServiceWarning {
            crate::model::DocumentServiceWarning {
                message: self.message,
            }
        }
    }
}
impl DocumentServiceWarning {
    /// Creates a new builder-style object to manufacture [`DocumentServiceWarning`](crate::model::DocumentServiceWarning)
    pub fn builder() -> crate::model::document_service_warning::Builder {
        crate::model::document_service_warning::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ContentType {
    #[allow(missing_docs)] // documentation missing in model
    ApplicationJson,
    #[allow(missing_docs)] // documentation missing in model
    ApplicationXml,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ContentType {
    fn from(s: &str) -> Self {
        match s {
            "application/json" => ContentType::ApplicationJson,
            "application/xml" => ContentType::ApplicationXml,
            other => ContentType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ContentType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ContentType::from(s))
    }
}
impl ContentType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ContentType::ApplicationJson => "application/json",
            ContentType::ApplicationXml => "application/xml",
            ContentType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["application/json", "application/xml"]
    }
}
impl AsRef<str> for ContentType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Container for the suggestion information returned in a <code>SuggestResponse</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SuggestModel {
    /// <p>The query string specified in the suggest request.</p>
    pub query: std::option::Option<std::string::String>,
    /// <p>The number of documents that were found to match the query string.</p>
    pub found: i64,
    /// <p>The documents that match the query string.</p>
    pub suggestions: std::option::Option<std::vec::Vec<crate::model::SuggestionMatch>>,
}
impl SuggestModel {
    /// <p>The query string specified in the suggest request.</p>
    pub fn query(&self) -> std::option::Option<&str> {
        self.query.as_deref()
    }
    /// <p>The number of documents that were found to match the query string.</p>
    pub fn found(&self) -> i64 {
        self.found
    }
    /// <p>The documents that match the query string.</p>
    pub fn suggestions(&self) -> std::option::Option<&[crate::model::SuggestionMatch]> {
        self.suggestions.as_deref()
    }
}
impl std::fmt::Debug for SuggestModel {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SuggestModel");
        formatter.field("query", &self.query);
        formatter.field("found", &self.found);
        formatter.field("suggestions", &self.suggestions);
        formatter.finish()
    }
}
/// See [`SuggestModel`](crate::model::SuggestModel)
pub mod suggest_model {
    /// A builder for [`SuggestModel`](crate::model::SuggestModel)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) query: std::option::Option<std::string::String>,
        pub(crate) found: std::option::Option<i64>,
        pub(crate) suggestions: std::option::Option<std::vec::Vec<crate::model::SuggestionMatch>>,
    }
    impl Builder {
        /// <p>The query string specified in the suggest request.</p>
        pub fn query(mut self, input: impl Into<std::string::String>) -> Self {
            self.query = Some(input.into());
            self
        }
        /// <p>The query string specified in the suggest request.</p>
        pub fn set_query(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.query = input;
            self
        }
        /// <p>The number of documents that were found to match the query string.</p>
        pub fn found(mut self, input: i64) -> Self {
            self.found = Some(input);
            self
        }
        /// <p>The number of documents that were found to match the query string.</p>
        pub fn set_found(mut self, input: std::option::Option<i64>) -> Self {
            self.found = input;
            self
        }
        /// Appends an item to `suggestions`.
        ///
        /// To override the contents of this collection use [`set_suggestions`](Self::set_suggestions).
        ///
        /// <p>The documents that match the query string.</p>
        pub fn suggestions(mut self, input: crate::model::SuggestionMatch) -> Self {
            let mut v = self.suggestions.unwrap_or_default();
            v.push(input);
            self.suggestions = Some(v);
            self
        }
        /// <p>The documents that match the query string.</p>
        pub fn set_suggestions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SuggestionMatch>>,
        ) -> Self {
            self.suggestions = input;
            self
        }
        /// Consumes the builder and constructs a [`SuggestModel`](crate::model::SuggestModel)
        pub fn build(self) -> crate::model::SuggestModel {
            crate::model::SuggestModel {
                query: self.query,
                found: self.found.unwrap_or_default(),
                suggestions: self.suggestions,
            }
        }
    }
}
impl SuggestModel {
    /// Creates a new builder-style object to manufacture [`SuggestModel`](crate::model::SuggestModel)
    pub fn builder() -> crate::model::suggest_model::Builder {
        crate::model::suggest_model::Builder::default()
    }
}

/// <p>An autocomplete suggestion that matches the query string specified in a <code>SuggestRequest</code>. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SuggestionMatch {
    /// <p>The string that matches the query string specified in the <code>SuggestRequest</code>. </p>
    pub suggestion: std::option::Option<std::string::String>,
    /// <p>The relevance score of a suggested match.</p>
    pub score: i64,
    /// <p>The document ID of the suggested document.</p>
    pub id: std::option::Option<std::string::String>,
}
impl SuggestionMatch {
    /// <p>The string that matches the query string specified in the <code>SuggestRequest</code>. </p>
    pub fn suggestion(&self) -> std::option::Option<&str> {
        self.suggestion.as_deref()
    }
    /// <p>The relevance score of a suggested match.</p>
    pub fn score(&self) -> i64 {
        self.score
    }
    /// <p>The document ID of the suggested document.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
}
impl std::fmt::Debug for SuggestionMatch {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SuggestionMatch");
        formatter.field("suggestion", &self.suggestion);
        formatter.field("score", &self.score);
        formatter.field("id", &self.id);
        formatter.finish()
    }
}
/// See [`SuggestionMatch`](crate::model::SuggestionMatch)
pub mod suggestion_match {
    /// A builder for [`SuggestionMatch`](crate::model::SuggestionMatch)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) suggestion: std::option::Option<std::string::String>,
        pub(crate) score: std::option::Option<i64>,
        pub(crate) id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The string that matches the query string specified in the <code>SuggestRequest</code>. </p>
        pub fn suggestion(mut self, input: impl Into<std::string::String>) -> Self {
            self.suggestion = Some(input.into());
            self
        }
        /// <p>The string that matches the query string specified in the <code>SuggestRequest</code>. </p>
        pub fn set_suggestion(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.suggestion = input;
            self
        }
        /// <p>The relevance score of a suggested match.</p>
        pub fn score(mut self, input: i64) -> Self {
            self.score = Some(input);
            self
        }
        /// <p>The relevance score of a suggested match.</p>
        pub fn set_score(mut self, input: std::option::Option<i64>) -> Self {
            self.score = input;
            self
        }
        /// <p>The document ID of the suggested document.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The document ID of the suggested document.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// Consumes the builder and constructs a [`SuggestionMatch`](crate::model::SuggestionMatch)
        pub fn build(self) -> crate::model::SuggestionMatch {
            crate::model::SuggestionMatch {
                suggestion: self.suggestion,
                score: self.score.unwrap_or_default(),
                id: self.id,
            }
        }
    }
}
impl SuggestionMatch {
    /// Creates a new builder-style object to manufacture [`SuggestionMatch`](crate::model::SuggestionMatch)
    pub fn builder() -> crate::model::suggestion_match::Builder {
        crate::model::suggestion_match::Builder::default()
    }
}

/// <p>Contains the resource id (<code>rid</code>) and the time it took to process the request (<code>timems</code>).</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SuggestStatus {
    /// <p>How long it took to process the request, in milliseconds.</p>
    pub timems: i64,
    /// <p>The encrypted resource ID for the request.</p>
    pub rid: std::option::Option<std::string::String>,
}
impl SuggestStatus {
    /// <p>How long it took to process the request, in milliseconds.</p>
    pub fn timems(&self) -> i64 {
        self.timems
    }
    /// <p>The encrypted resource ID for the request.</p>
    pub fn rid(&self) -> std::option::Option<&str> {
        self.rid.as_deref()
    }
}
impl std::fmt::Debug for SuggestStatus {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SuggestStatus");
        formatter.field("timems", &self.timems);
        formatter.field("rid", &self.rid);
        formatter.finish()
    }
}
/// See [`SuggestStatus`](crate::model::SuggestStatus)
pub mod suggest_status {
    /// A builder for [`SuggestStatus`](crate::model::SuggestStatus)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) timems: std::option::Option<i64>,
        pub(crate) rid: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>How long it took to process the request, in milliseconds.</p>
        pub fn timems(mut self, input: i64) -> Self {
            self.timems = Some(input);
            self
        }
        /// <p>How long it took to process the request, in milliseconds.</p>
        pub fn set_timems(mut self, input: std::option::Option<i64>) -> Self {
            self.timems = input;
            self
        }
        /// <p>The encrypted resource ID for the request.</p>
        pub fn rid(mut self, input: impl Into<std::string::String>) -> Self {
            self.rid = Some(input.into());
            self
        }
        /// <p>The encrypted resource ID for the request.</p>
        pub fn set_rid(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.rid = input;
            self
        }
        /// Consumes the builder and constructs a [`SuggestStatus`](crate::model::SuggestStatus)
        pub fn build(self) -> crate::model::SuggestStatus {
            crate::model::SuggestStatus {
                timems: self.timems.unwrap_or_default(),
                rid: self.rid,
            }
        }
    }
}
impl SuggestStatus {
    /// Creates a new builder-style object to manufacture [`SuggestStatus`](crate::model::SuggestStatus)
    pub fn builder() -> crate::model::suggest_status::Builder {
        crate::model::suggest_status::Builder::default()
    }
}

/// <p>The statistics for a field calculated in the request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct FieldStats {
    /// <p>The minimum value found in the specified field in the result set.</p>
    /// <p>If the field is numeric (<code>int</code>, <code>int-array</code>, <code>double</code>, or <code>double-array</code>), <code>min</code> is the string representation of a double-precision 64-bit floating point value. If the field is <code>date</code> or <code>date-array</code>, <code>min</code> is the string representation of a date with the format specified in <a href="http://tools.ietf.org/html/rfc3339">IETF RFC3339</a>: yyyy-mm-ddTHH:mm:ss.SSSZ.</p>
    pub min: std::option::Option<std::string::String>,
    /// <p>The maximum value found in the specified field in the result set.</p>
    /// <p>If the field is numeric (<code>int</code>, <code>int-array</code>, <code>double</code>, or <code>double-array</code>), <code>max</code> is the string representation of a double-precision 64-bit floating point value. If the field is <code>date</code> or <code>date-array</code>, <code>max</code> is the string representation of a date with the format specified in <a href="http://tools.ietf.org/html/rfc3339">IETF RFC3339</a>: yyyy-mm-ddTHH:mm:ss.SSSZ.</p>
    pub max: std::option::Option<std::string::String>,
    /// <p>The number of documents that contain a value in the specified field in the result set.</p>
    pub count: i64,
    /// <p>The number of documents that do not contain a value in the specified field in the result set.</p>
    pub missing: i64,
    /// <p>The sum of the field values across the documents in the result set. <code>null</code> for date fields.</p>
    pub sum: f64,
    /// <p>The sum of all field values in the result set squared.</p>
    pub sum_of_squares: f64,
    /// <p>The average of the values found in the specified field in the result set.</p>
    /// <p>If the field is numeric (<code>int</code>, <code>int-array</code>, <code>double</code>, or <code>double-array</code>), <code>mean</code> is the string representation of a double-precision 64-bit floating point value. If the field is <code>date</code> or <code>date-array</code>, <code>mean</code> is the string representation of a date with the format specified in <a href="http://tools.ietf.org/html/rfc3339">IETF RFC3339</a>: yyyy-mm-ddTHH:mm:ss.SSSZ.</p>
    pub mean: std::option::Option<std::string::String>,
    /// <p>The standard deviation of the values in the specified field in the result set.</p>
    pub stddev: f64,
}
impl FieldStats {
    /// <p>The minimum value found in the specified field in the result set.</p>
    /// <p>If the field is numeric (<code>int</code>, <code>int-array</code>, <code>double</code>, or <code>double-array</code>), <code>min</code> is the string representation of a double-precision 64-bit floating point value. If the field is <code>date</code> or <code>date-array</code>, <code>min</code> is the string representation of a date with the format specified in <a href="http://tools.ietf.org/html/rfc3339">IETF RFC3339</a>: yyyy-mm-ddTHH:mm:ss.SSSZ.</p>
    pub fn min(&self) -> std::option::Option<&str> {
        self.min.as_deref()
    }
    /// <p>The maximum value found in the specified field in the result set.</p>
    /// <p>If the field is numeric (<code>int</code>, <code>int-array</code>, <code>double</code>, or <code>double-array</code>), <code>max</code> is the string representation of a double-precision 64-bit floating point value. If the field is <code>date</code> or <code>date-array</code>, <code>max</code> is the string representation of a date with the format specified in <a href="http://tools.ietf.org/html/rfc3339">IETF RFC3339</a>: yyyy-mm-ddTHH:mm:ss.SSSZ.</p>
    pub fn max(&self) -> std::option::Option<&str> {
        self.max.as_deref()
    }
    /// <p>The number of documents that contain a value in the specified field in the result set.</p>
    pub fn count(&self) -> i64 {
        self.count
    }
    /// <p>The number of documents that do not contain a value in the specified field in the result set.</p>
    pub fn missing(&self) -> i64 {
        self.missing
    }
    /// <p>The sum of the field values across the documents in the result set. <code>null</code> for date fields.</p>
    pub fn sum(&self) -> f64 {
        self.sum
    }
    /// <p>The sum of all field values in the result set squared.</p>
    pub fn sum_of_squares(&self) -> f64 {
        self.sum_of_squares
    }
    /// <p>The average of the values found in the specified field in the result set.</p>
    /// <p>If the field is numeric (<code>int</code>, <code>int-array</code>, <code>double</code>, or <code>double-array</code>), <code>mean</code> is the string representation of a double-precision 64-bit floating point value. If the field is <code>date</code> or <code>date-array</code>, <code>mean</code> is the string representation of a date with the format specified in <a href="http://tools.ietf.org/html/rfc3339">IETF RFC3339</a>: yyyy-mm-ddTHH:mm:ss.SSSZ.</p>
    pub fn mean(&self) -> std::option::Option<&str> {
        self.mean.as_deref()
    }
    /// <p>The standard deviation of the values in the specified field in the result set.</p>
    pub fn stddev(&self) -> f64 {
        self.stddev
    }
}
impl std::fmt::Debug for FieldStats {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("FieldStats");
        formatter.field("min", &self.min);
        formatter.field("max", &self.max);
        formatter.field("count", &self.count);
        formatter.field("missing", &self.missing);
        formatter.field("sum", &self.sum);
        formatter.field("sum_of_squares", &self.sum_of_squares);
        formatter.field("mean", &self.mean);
        formatter.field("stddev", &self.stddev);
        formatter.finish()
    }
}
/// See [`FieldStats`](crate::model::FieldStats)
pub mod field_stats {
    /// A builder for [`FieldStats`](crate::model::FieldStats)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) min: std::option::Option<std::string::String>,
        pub(crate) max: std::option::Option<std::string::String>,
        pub(crate) count: std::option::Option<i64>,
        pub(crate) missing: std::option::Option<i64>,
        pub(crate) sum: std::option::Option<f64>,
        pub(crate) sum_of_squares: std::option::Option<f64>,
        pub(crate) mean: std::option::Option<std::string::String>,
        pub(crate) stddev: std::option::Option<f64>,
    }
    impl Builder {
        /// <p>The minimum value found in the specified field in the result set.</p>
        /// <p>If the field is numeric (<code>int</code>, <code>int-array</code>, <code>double</code>, or <code>double-array</code>), <code>min</code> is the string representation of a double-precision 64-bit floating point value. If the field is <code>date</code> or <code>date-array</code>, <code>min</code> is the string representation of a date with the format specified in <a href="http://tools.ietf.org/html/rfc3339">IETF RFC3339</a>: yyyy-mm-ddTHH:mm:ss.SSSZ.</p>
        pub fn min(mut self, input: impl Into<std::string::String>) -> Self {
            self.min = Some(input.into());
            self
        }
        /// <p>The minimum value found in the specified field in the result set.</p>
        /// <p>If the field is numeric (<code>int</code>, <code>int-array</code>, <code>double</code>, or <code>double-array</code>), <code>min</code> is the string representation of a double-precision 64-bit floating point value. If the field is <code>date</code> or <code>date-array</code>, <code>min</code> is the string representation of a date with the format specified in <a href="http://tools.ietf.org/html/rfc3339">IETF RFC3339</a>: yyyy-mm-ddTHH:mm:ss.SSSZ.</p>
        pub fn set_min(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.min = input;
            self
        }
        /// <p>The maximum value found in the specified field in the result set.</p>
        /// <p>If the field is numeric (<code>int</code>, <code>int-array</code>, <code>double</code>, or <code>double-array</code>), <code>max</code> is the string representation of a double-precision 64-bit floating point value. If the field is <code>date</code> or <code>date-array</code>, <code>max</code> is the string representation of a date with the format specified in <a href="http://tools.ietf.org/html/rfc3339">IETF RFC3339</a>: yyyy-mm-ddTHH:mm:ss.SSSZ.</p>
        pub fn max(mut self, input: impl Into<std::string::String>) -> Self {
            self.max = Some(input.into());
            self
        }
        /// <p>The maximum value found in the specified field in the result set.</p>
        /// <p>If the field is numeric (<code>int</code>, <code>int-array</code>, <code>double</code>, or <code>double-array</code>), <code>max</code> is the string representation of a double-precision 64-bit floating point value. If the field is <code>date</code> or <code>date-array</code>, <code>max</code> is the string representation of a date with the format specified in <a href="http://tools.ietf.org/html/rfc3339">IETF RFC3339</a>: yyyy-mm-ddTHH:mm:ss.SSSZ.</p>
        pub fn set_max(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.max = input;
            self
        }
        /// <p>The number of documents that contain a value in the specified field in the result set.</p>
        pub fn count(mut self, input: i64) -> Self {
            self.count = Some(input);
            self
        }
        /// <p>The number of documents that contain a value in the specified field in the result set.</p>
        pub fn set_count(mut self, input: std::option::Option<i64>) -> Self {
            self.count = input;
            self
        }
        /// <p>The number of documents that do not contain a value in the specified field in the result set.</p>
        pub fn missing(mut self, input: i64) -> Self {
            self.missing = Some(input);
            self
        }
        /// <p>The number of documents that do not contain a value in the specified field in the result set.</p>
        pub fn set_missing(mut self, input: std::option::Option<i64>) -> Self {
            self.missing = input;
            self
        }
        /// <p>The sum of the field values across the documents in the result set. <code>null</code> for date fields.</p>
        pub fn sum(mut self, input: f64) -> Self {
            self.sum = Some(input);
            self
        }
        /// <p>The sum of the field values across the documents in the result set. <code>null</code> for date fields.</p>
        pub fn set_sum(mut self, input: std::option::Option<f64>) -> Self {
            self.sum = input;
            self
        }
        /// <p>The sum of all field values in the result set squared.</p>
        pub fn sum_of_squares(mut self, input: f64) -> Self {
            self.sum_of_squares = Some(input);
            self
        }
        /// <p>The sum of all field values in the result set squared.</p>
        pub fn set_sum_of_squares(mut self, input: std::option::Option<f64>) -> Self {
            self.sum_of_squares = input;
            self
        }
        /// <p>The average of the values found in the specified field in the result set.</p>
        /// <p>If the field is numeric (<code>int</code>, <code>int-array</code>, <code>double</code>, or <code>double-array</code>), <code>mean</code> is the string representation of a double-precision 64-bit floating point value. If the field is <code>date</code> or <code>date-array</code>, <code>mean</code> is the string representation of a date with the format specified in <a href="http://tools.ietf.org/html/rfc3339">IETF RFC3339</a>: yyyy-mm-ddTHH:mm:ss.SSSZ.</p>
        pub fn mean(mut self, input: impl Into<std::string::String>) -> Self {
            self.mean = Some(input.into());
            self
        }
        /// <p>The average of the values found in the specified field in the result set.</p>
        /// <p>If the field is numeric (<code>int</code>, <code>int-array</code>, <code>double</code>, or <code>double-array</code>), <code>mean</code> is the string representation of a double-precision 64-bit floating point value. If the field is <code>date</code> or <code>date-array</code>, <code>mean</code> is the string representation of a date with the format specified in <a href="http://tools.ietf.org/html/rfc3339">IETF RFC3339</a>: yyyy-mm-ddTHH:mm:ss.SSSZ.</p>
        pub fn set_mean(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.mean = input;
            self
        }
        /// <p>The standard deviation of the values in the specified field in the result set.</p>
        pub fn stddev(mut self, input: f64) -> Self {
            self.stddev = Some(input);
            self
        }
        /// <p>The standard deviation of the values in the specified field in the result set.</p>
        pub fn set_stddev(mut self, input: std::option::Option<f64>) -> Self {
            self.stddev = input;
            self
        }
        /// Consumes the builder and constructs a [`FieldStats`](crate::model::FieldStats)
        pub fn build(self) -> crate::model::FieldStats {
            crate::model::FieldStats {
                min: self.min,
                max: self.max,
                count: self.count.unwrap_or_default(),
                missing: self.missing.unwrap_or_default(),
                sum: self.sum.unwrap_or_default(),
                sum_of_squares: self.sum_of_squares.unwrap_or_default(),
                mean: self.mean,
                stddev: self.stddev.unwrap_or_default(),
            }
        }
    }
}
impl FieldStats {
    /// Creates a new builder-style object to manufacture [`FieldStats`](crate::model::FieldStats)
    pub fn builder() -> crate::model::field_stats::Builder {
        crate::model::field_stats::Builder::default()
    }
}

/// <p>A container for the calculated facet values and counts.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BucketInfo {
    /// <p>A list of the calculated facet values and counts.</p>
    pub buckets: std::option::Option<std::vec::Vec<crate::model::Bucket>>,
}
impl BucketInfo {
    /// <p>A list of the calculated facet values and counts.</p>
    pub fn buckets(&self) -> std::option::Option<&[crate::model::Bucket]> {
        self.buckets.as_deref()
    }
}
impl std::fmt::Debug for BucketInfo {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BucketInfo");
        formatter.field("buckets", &self.buckets);
        formatter.finish()
    }
}
/// See [`BucketInfo`](crate::model::BucketInfo)
pub mod bucket_info {
    /// A builder for [`BucketInfo`](crate::model::BucketInfo)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) buckets: std::option::Option<std::vec::Vec<crate::model::Bucket>>,
    }
    impl Builder {
        /// Appends an item to `buckets`.
        ///
        /// To override the contents of this collection use [`set_buckets`](Self::set_buckets).
        ///
        /// <p>A list of the calculated facet values and counts.</p>
        pub fn buckets(mut self, input: crate::model::Bucket) -> Self {
            let mut v = self.buckets.unwrap_or_default();
            v.push(input);
            self.buckets = Some(v);
            self
        }
        /// <p>A list of the calculated facet values and counts.</p>
        pub fn set_buckets(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Bucket>>,
        ) -> Self {
            self.buckets = input;
            self
        }
        /// Consumes the builder and constructs a [`BucketInfo`](crate::model::BucketInfo)
        pub fn build(self) -> crate::model::BucketInfo {
            crate::model::BucketInfo {
                buckets: self.buckets,
            }
        }
    }
}
impl BucketInfo {
    /// Creates a new builder-style object to manufacture [`BucketInfo`](crate::model::BucketInfo)
    pub fn builder() -> crate::model::bucket_info::Builder {
        crate::model::bucket_info::Builder::default()
    }
}

/// <p>A container for facet information. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Bucket {
    /// <p>The facet value being counted.</p>
    pub value: std::option::Option<std::string::String>,
    /// <p>The number of hits that contain the facet value in the specified facet field.</p>
    pub count: i64,
}
impl Bucket {
    /// <p>The facet value being counted.</p>
    pub fn value(&self) -> std::option::Option<&str> {
        self.value.as_deref()
    }
    /// <p>The number of hits that contain the facet value in the specified facet field.</p>
    pub fn count(&self) -> i64 {
        self.count
    }
}
impl std::fmt::Debug for Bucket {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Bucket");
        formatter.field("value", &self.value);
        formatter.field("count", &self.count);
        formatter.finish()
    }
}
/// See [`Bucket`](crate::model::Bucket)
pub mod bucket {
    /// A builder for [`Bucket`](crate::model::Bucket)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) value: std::option::Option<std::string::String>,
        pub(crate) count: std::option::Option<i64>,
    }
    impl Builder {
        /// <p>The facet value being counted.</p>
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            self.value = Some(input.into());
            self
        }
        /// <p>The facet value being counted.</p>
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.value = input;
            self
        }
        /// <p>The number of hits that contain the facet value in the specified facet field.</p>
        pub fn count(mut self, input: i64) -> Self {
            self.count = Some(input);
            self
        }
        /// <p>The number of hits that contain the facet value in the specified facet field.</p>
        pub fn set_count(mut self, input: std::option::Option<i64>) -> Self {
            self.count = input;
            self
        }
        /// Consumes the builder and constructs a [`Bucket`](crate::model::Bucket)
        pub fn build(self) -> crate::model::Bucket {
            crate::model::Bucket {
                value: self.value,
                count: self.count.unwrap_or_default(),
            }
        }
    }
}
impl Bucket {
    /// Creates a new builder-style object to manufacture [`Bucket`](crate::model::Bucket)
    pub fn builder() -> crate::model::bucket::Builder {
        crate::model::bucket::Builder::default()
    }
}

/// <p>The collection of documents that match the search request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Hits {
    /// <p>The total number of documents that match the search request.</p>
    pub found: i64,
    /// <p>The index of the first matching document.</p>
    pub start: i64,
    /// <p>A cursor that can be used to retrieve the next set of matching documents when you want to page through a large result set.</p>
    pub cursor: std::option::Option<std::string::String>,
    /// <p>A document that matches the search request.</p>
    pub hit: std::option::Option<std::vec::Vec<crate::model::Hit>>,
}
impl Hits {
    /// <p>The total number of documents that match the search request.</p>
    pub fn found(&self) -> i64 {
        self.found
    }
    /// <p>The index of the first matching document.</p>
    pub fn start(&self) -> i64 {
        self.start
    }
    /// <p>A cursor that can be used to retrieve the next set of matching documents when you want to page through a large result set.</p>
    pub fn cursor(&self) -> std::option::Option<&str> {
        self.cursor.as_deref()
    }
    /// <p>A document that matches the search request.</p>
    pub fn hit(&self) -> std::option::Option<&[crate::model::Hit]> {
        self.hit.as_deref()
    }
}
impl std::fmt::Debug for Hits {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Hits");
        formatter.field("found", &self.found);
        formatter.field("start", &self.start);
        formatter.field("cursor", &self.cursor);
        formatter.field("hit", &self.hit);
        formatter.finish()
    }
}
/// See [`Hits`](crate::model::Hits)
pub mod hits {
    /// A builder for [`Hits`](crate::model::Hits)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) found: std::option::Option<i64>,
        pub(crate) start: std::option::Option<i64>,
        pub(crate) cursor: std::option::Option<std::string::String>,
        pub(crate) hit: std::option::Option<std::vec::Vec<crate::model::Hit>>,
    }
    impl Builder {
        /// <p>The total number of documents that match the search request.</p>
        pub fn found(mut self, input: i64) -> Self {
            self.found = Some(input);
            self
        }
        /// <p>The total number of documents that match the search request.</p>
        pub fn set_found(mut self, input: std::option::Option<i64>) -> Self {
            self.found = input;
            self
        }
        /// <p>The index of the first matching document.</p>
        pub fn start(mut self, input: i64) -> Self {
            self.start = Some(input);
            self
        }
        /// <p>The index of the first matching document.</p>
        pub fn set_start(mut self, input: std::option::Option<i64>) -> Self {
            self.start = input;
            self
        }
        /// <p>A cursor that can be used to retrieve the next set of matching documents when you want to page through a large result set.</p>
        pub fn cursor(mut self, input: impl Into<std::string::String>) -> Self {
            self.cursor = Some(input.into());
            self
        }
        /// <p>A cursor that can be used to retrieve the next set of matching documents when you want to page through a large result set.</p>
        pub fn set_cursor(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.cursor = input;
            self
        }
        /// Appends an item to `hit`.
        ///
        /// To override the contents of this collection use [`set_hit`](Self::set_hit).
        ///
        /// <p>A document that matches the search request.</p>
        pub fn hit(mut self, input: crate::model::Hit) -> Self {
            let mut v = self.hit.unwrap_or_default();
            v.push(input);
            self.hit = Some(v);
            self
        }
        /// <p>A document that matches the search request.</p>
        pub fn set_hit(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Hit>>,
        ) -> Self {
            self.hit = input;
            self
        }
        /// Consumes the builder and constructs a [`Hits`](crate::model::Hits)
        pub fn build(self) -> crate::model::Hits {
            crate::model::Hits {
                found: self.found.unwrap_or_default(),
                start: self.start.unwrap_or_default(),
                cursor: self.cursor,
                hit: self.hit,
            }
        }
    }
}
impl Hits {
    /// Creates a new builder-style object to manufacture [`Hits`](crate::model::Hits)
    pub fn builder() -> crate::model::hits::Builder {
        crate::model::hits::Builder::default()
    }
}

/// <p>Information about a document that matches the search request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Hit {
    /// <p>The document ID of a document that matches the search request.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The fields returned from a document that matches the search request.</p>
    pub fields: std::option::Option<
        std::collections::HashMap<std::string::String, std::vec::Vec<std::string::String>>,
    >,
    /// <p>The expressions returned from a document that matches the search request.</p>
    pub exprs:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>The highlights returned from a document that matches the search request.</p>
    pub highlights:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl Hit {
    /// <p>The document ID of a document that matches the search request.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The fields returned from a document that matches the search request.</p>
    pub fn fields(
        &self,
    ) -> std::option::Option<
        &std::collections::HashMap<std::string::String, std::vec::Vec<std::string::String>>,
    > {
        self.fields.as_ref()
    }
    /// <p>The expressions returned from a document that matches the search request.</p>
    pub fn exprs(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.exprs.as_ref()
    }
    /// <p>The highlights returned from a document that matches the search request.</p>
    pub fn highlights(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.highlights.as_ref()
    }
}
impl std::fmt::Debug for Hit {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Hit");
        formatter.field("id", &self.id);
        formatter.field("fields", &self.fields);
        formatter.field("exprs", &self.exprs);
        formatter.field("highlights", &self.highlights);
        formatter.finish()
    }
}
/// See [`Hit`](crate::model::Hit)
pub mod hit {
    /// A builder for [`Hit`](crate::model::Hit)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) fields: std::option::Option<
            std::collections::HashMap<std::string::String, std::vec::Vec<std::string::String>>,
        >,
        pub(crate) exprs: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) highlights: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The document ID of a document that matches the search request.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The document ID of a document that matches the search request.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// Adds a key-value pair to `fields`.
        ///
        /// To override the contents of this collection use [`set_fields`](Self::set_fields).
        ///
        /// <p>The fields returned from a document that matches the search request.</p>
        pub fn fields(
            mut self,
            k: impl Into<std::string::String>,
            v: std::vec::Vec<std::string::String>,
        ) -> Self {
            let mut hash_map = self.fields.unwrap_or_default();
            hash_map.insert(k.into(), v);
            self.fields = Some(hash_map);
            self
        }
        /// <p>The fields returned from a document that matches the search request.</p>
        pub fn set_fields(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::vec::Vec<std::string::String>>,
            >,
        ) -> Self {
            self.fields = input;
            self
        }
        /// Adds a key-value pair to `exprs`.
        ///
        /// To override the contents of this collection use [`set_exprs`](Self::set_exprs).
        ///
        /// <p>The expressions returned from a document that matches the search request.</p>
        pub fn exprs(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.exprs.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.exprs = Some(hash_map);
            self
        }
        /// <p>The expressions returned from a document that matches the search request.</p>
        pub fn set_exprs(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.exprs = input;
            self
        }
        /// Adds a key-value pair to `highlights`.
        ///
        /// To override the contents of this collection use [`set_highlights`](Self::set_highlights).
        ///
        /// <p>The highlights returned from a document that matches the search request.</p>
        pub fn highlights(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.highlights.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.highlights = Some(hash_map);
            self
        }
        /// <p>The highlights returned from a document that matches the search request.</p>
        pub fn set_highlights(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.highlights = input;
            self
        }
        /// Consumes the builder and constructs a [`Hit`](crate::model::Hit)
        pub fn build(self) -> crate::model::Hit {
            crate::model::Hit {
                id: self.id,
                fields: self.fields,
                exprs: self.exprs,
                highlights: self.highlights,
            }
        }
    }
}
impl Hit {
    /// Creates a new builder-style object to manufacture [`Hit`](crate::model::Hit)
    pub fn builder() -> crate::model::hit::Builder {
        crate::model::hit::Builder::default()
    }
}

/// <p>Contains the resource id (<code>rid</code>) and the time it took to process the request (<code>timems</code>).</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SearchStatus {
    /// <p>How long it took to process the request, in milliseconds.</p>
    pub timems: i64,
    /// <p>The encrypted resource ID for the request.</p>
    pub rid: std::option::Option<std::string::String>,
}
impl SearchStatus {
    /// <p>How long it took to process the request, in milliseconds.</p>
    pub fn timems(&self) -> i64 {
        self.timems
    }
    /// <p>The encrypted resource ID for the request.</p>
    pub fn rid(&self) -> std::option::Option<&str> {
        self.rid.as_deref()
    }
}
impl std::fmt::Debug for SearchStatus {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SearchStatus");
        formatter.field("timems", &self.timems);
        formatter.field("rid", &self.rid);
        formatter.finish()
    }
}
/// See [`SearchStatus`](crate::model::SearchStatus)
pub mod search_status {
    /// A builder for [`SearchStatus`](crate::model::SearchStatus)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) timems: std::option::Option<i64>,
        pub(crate) rid: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>How long it took to process the request, in milliseconds.</p>
        pub fn timems(mut self, input: i64) -> Self {
            self.timems = Some(input);
            self
        }
        /// <p>How long it took to process the request, in milliseconds.</p>
        pub fn set_timems(mut self, input: std::option::Option<i64>) -> Self {
            self.timems = input;
            self
        }
        /// <p>The encrypted resource ID for the request.</p>
        pub fn rid(mut self, input: impl Into<std::string::String>) -> Self {
            self.rid = Some(input.into());
            self
        }
        /// <p>The encrypted resource ID for the request.</p>
        pub fn set_rid(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.rid = input;
            self
        }
        /// Consumes the builder and constructs a [`SearchStatus`](crate::model::SearchStatus)
        pub fn build(self) -> crate::model::SearchStatus {
            crate::model::SearchStatus {
                timems: self.timems.unwrap_or_default(),
                rid: self.rid,
            }
        }
    }
}
impl SearchStatus {
    /// Creates a new builder-style object to manufacture [`SearchStatus`](crate::model::SearchStatus)
    pub fn builder() -> crate::model::search_status::Builder {
        crate::model::search_status::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum QueryParser {
    #[allow(missing_docs)] // documentation missing in model
    Dismax,
    #[allow(missing_docs)] // documentation missing in model
    Lucene,
    #[allow(missing_docs)] // documentation missing in model
    Simple,
    #[allow(missing_docs)] // documentation missing in model
    Structured,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for QueryParser {
    fn from(s: &str) -> Self {
        match s {
            "dismax" => QueryParser::Dismax,
            "lucene" => QueryParser::Lucene,
            "simple" => QueryParser::Simple,
            "structured" => QueryParser::Structured,
            other => QueryParser::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for QueryParser {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(QueryParser::from(s))
    }
}
impl QueryParser {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            QueryParser::Dismax => "dismax",
            QueryParser::Lucene => "lucene",
            QueryParser::Simple => "simple",
            QueryParser::Structured => "structured",
            QueryParser::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["dismax", "lucene", "simple", "structured"]
    }
}
impl AsRef<str> for QueryParser {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}
