// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(clippy::unnecessary_wraps)]
pub fn parse_search_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::SearchOutput, crate::error::SearchError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::SearchError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::SearchError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "SearchException" => {
            crate::error::SearchError {
                meta: generic,
                kind: crate::error::SearchErrorKind::SearchException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::search_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_search_exception_json_err(response.body().as_ref(), output).map_err(crate::error::SearchError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::SearchError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_search_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::SearchOutput, crate::error::SearchError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::search_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_search(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::SearchError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_suggest_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::SuggestOutput, crate::error::SuggestError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::SuggestError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::SuggestError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "SearchException" => {
            crate::error::SuggestError {
                meta: generic,
                kind: crate::error::SuggestErrorKind::SearchException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::search_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_search_exception_json_err(response.body().as_ref(), output).map_err(crate::error::SuggestError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::SuggestError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_suggest_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::SuggestOutput, crate::error::SuggestError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::suggest_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_suggest(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::SuggestError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_upload_documents_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::UploadDocumentsOutput, crate::error::UploadDocumentsError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::UploadDocumentsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::UploadDocumentsError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "DocumentServiceException" => crate::error::UploadDocumentsError {
            meta: generic,
            kind: crate::error::UploadDocumentsErrorKind::DocumentServiceException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::document_service_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_document_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UploadDocumentsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::UploadDocumentsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_upload_documents_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::UploadDocumentsOutput, crate::error::UploadDocumentsError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::upload_documents_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_upload_documents(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::UploadDocumentsError::unhandled)?;
        output.build()
    })
}
