// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Operation shape for `Search`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`search`](crate::client::Client::search).
///
/// See [`crate::client::fluent_builders::Search`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct Search {
    _private: (),
}
impl Search {
    /// Creates a new builder-style object to manufacture [`SearchInput`](crate::input::SearchInput)
    pub fn builder() -> crate::input::search_input::Builder {
        crate::input::search_input::Builder::default()
    }
    /// Creates a new `Search` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for Search {
    type Output = std::result::Result<crate::output::SearchOutput, crate::error::SearchError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_search_error(response)
        } else {
            crate::operation_deser::parse_search_response(response)
        }
    }
}

/// Operation shape for `Suggest`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`suggest`](crate::client::Client::suggest).
///
/// See [`crate::client::fluent_builders::Suggest`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct Suggest {
    _private: (),
}
impl Suggest {
    /// Creates a new builder-style object to manufacture [`SuggestInput`](crate::input::SuggestInput)
    pub fn builder() -> crate::input::suggest_input::Builder {
        crate::input::suggest_input::Builder::default()
    }
    /// Creates a new `Suggest` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for Suggest {
    type Output = std::result::Result<crate::output::SuggestOutput, crate::error::SuggestError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_suggest_error(response)
        } else {
            crate::operation_deser::parse_suggest_response(response)
        }
    }
}

/// Operation shape for `UploadDocuments`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`upload_documents`](crate::client::Client::upload_documents).
///
/// See [`crate::client::fluent_builders::UploadDocuments`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UploadDocuments {
    _private: (),
}
impl UploadDocuments {
    /// Creates a new builder-style object to manufacture [`UploadDocumentsInput`](crate::input::UploadDocumentsInput)
    pub fn builder() -> crate::input::upload_documents_input::Builder {
        crate::input::upload_documents_input::Builder::default()
    }
    /// Creates a new `UploadDocuments` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UploadDocuments {
    type Output = std::result::Result<
        crate::output::UploadDocumentsOutput,
        crate::error::UploadDocumentsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_upload_documents_error(response)
        } else {
            crate::operation_deser::parse_upload_documents_response(response)
        }
    }
}
