// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(clippy::unnecessary_wraps)]
pub fn parse_build_suggesters_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::BuildSuggestersOutput, crate::error::BuildSuggestersError> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::BuildSuggestersError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::BuildSuggestersError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "BaseException" => crate::error::BuildSuggestersError {
            meta: generic,
            kind: crate::error::BuildSuggestersErrorKind::BaseException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::base_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_base_exception_xml_err(
                        response.body().as_ref(),
                        output,
                    )
                    .map_err(crate::error::BuildSuggestersError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InternalException" => {
            crate::error::BuildSuggestersError {
                meta: generic,
                kind: crate::error::BuildSuggestersErrorKind::InternalException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::internal_exception::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_internal_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::BuildSuggestersError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "ResourceNotFound" => crate::error::BuildSuggestersError {
            meta: generic,
            kind: crate::error::BuildSuggestersErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_resource_not_found_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::BuildSuggestersError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ValidationException" => {
            crate::error::BuildSuggestersError {
                meta: generic,
                kind: crate::error::BuildSuggestersErrorKind::ValidationException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::validation_exception::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_validation_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::BuildSuggestersError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::BuildSuggestersError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_build_suggesters_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::BuildSuggestersOutput, crate::error::BuildSuggestersError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::build_suggesters_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_build_suggesters(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::BuildSuggestersError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_domain_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateDomainOutput, crate::error::CreateDomainError> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateDomainError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::CreateDomainError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "BaseException" => crate::error::CreateDomainError {
            meta: generic,
            kind: crate::error::CreateDomainErrorKind::BaseException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::base_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_base_exception_xml_err(
                        response.body().as_ref(),
                        output,
                    )
                    .map_err(crate::error::CreateDomainError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InternalException" => {
            crate::error::CreateDomainError {
                meta: generic,
                kind: crate::error::CreateDomainErrorKind::InternalException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::internal_exception::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_internal_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateDomainError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "LimitExceeded" => crate::error::CreateDomainError {
            meta: generic,
            kind: crate::error::CreateDomainErrorKind::LimitExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_limit_exceeded_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateDomainError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceAlreadyExists" => crate::error::CreateDomainError {
            meta: generic,
            kind: crate::error::CreateDomainErrorKind::ResourceAlreadyExistsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::resource_already_exists_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_resource_already_exists_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateDomainError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ValidationException" => {
            crate::error::CreateDomainError {
                meta: generic,
                kind: crate::error::CreateDomainErrorKind::ValidationException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::validation_exception::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_validation_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateDomainError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::CreateDomainError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_domain_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateDomainOutput, crate::error::CreateDomainError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_domain_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_create_domain(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CreateDomainError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_define_analysis_scheme_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DefineAnalysisSchemeOutput,
    crate::error::DefineAnalysisSchemeError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DefineAnalysisSchemeError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DefineAnalysisSchemeError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "BaseException" => crate::error::DefineAnalysisSchemeError {
            meta: generic,
            kind: crate::error::DefineAnalysisSchemeErrorKind::BaseException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::base_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_base_exception_xml_err(
                        response.body().as_ref(),
                        output,
                    )
                    .map_err(crate::error::DefineAnalysisSchemeError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InternalException" => {
            crate::error::DefineAnalysisSchemeError {
                meta: generic,
                kind: crate::error::DefineAnalysisSchemeErrorKind::InternalException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::internal_exception::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_internal_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DefineAnalysisSchemeError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "InvalidType" => crate::error::DefineAnalysisSchemeError {
            meta: generic,
            kind: crate::error::DefineAnalysisSchemeErrorKind::InvalidTypeException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_type_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_type_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DefineAnalysisSchemeError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "LimitExceeded" => crate::error::DefineAnalysisSchemeError {
            meta: generic,
            kind: crate::error::DefineAnalysisSchemeErrorKind::LimitExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_limit_exceeded_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DefineAnalysisSchemeError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFound" => crate::error::DefineAnalysisSchemeError {
            meta: generic,
            kind: crate::error::DefineAnalysisSchemeErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_resource_not_found_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DefineAnalysisSchemeError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ValidationException" => {
            crate::error::DefineAnalysisSchemeError {
                meta: generic,
                kind: crate::error::DefineAnalysisSchemeErrorKind::ValidationException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::validation_exception::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_validation_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DefineAnalysisSchemeError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::DefineAnalysisSchemeError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_define_analysis_scheme_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DefineAnalysisSchemeOutput,
    crate::error::DefineAnalysisSchemeError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::define_analysis_scheme_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_define_analysis_scheme(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DefineAnalysisSchemeError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_define_expression_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DefineExpressionOutput, crate::error::DefineExpressionError>
{
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DefineExpressionError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DefineExpressionError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "BaseException" => crate::error::DefineExpressionError {
            meta: generic,
            kind: crate::error::DefineExpressionErrorKind::BaseException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::base_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_base_exception_xml_err(
                        response.body().as_ref(),
                        output,
                    )
                    .map_err(crate::error::DefineExpressionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InternalException" => {
            crate::error::DefineExpressionError {
                meta: generic,
                kind: crate::error::DefineExpressionErrorKind::InternalException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::internal_exception::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_internal_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DefineExpressionError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "InvalidType" => crate::error::DefineExpressionError {
            meta: generic,
            kind: crate::error::DefineExpressionErrorKind::InvalidTypeException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_type_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_type_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DefineExpressionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "LimitExceeded" => crate::error::DefineExpressionError {
            meta: generic,
            kind: crate::error::DefineExpressionErrorKind::LimitExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_limit_exceeded_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DefineExpressionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFound" => crate::error::DefineExpressionError {
            meta: generic,
            kind: crate::error::DefineExpressionErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_resource_not_found_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DefineExpressionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ValidationException" => {
            crate::error::DefineExpressionError {
                meta: generic,
                kind: crate::error::DefineExpressionErrorKind::ValidationException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::validation_exception::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_validation_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DefineExpressionError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::DefineExpressionError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_define_expression_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DefineExpressionOutput, crate::error::DefineExpressionError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::define_expression_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_define_expression(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DefineExpressionError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_define_index_field_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DefineIndexFieldOutput, crate::error::DefineIndexFieldError>
{
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DefineIndexFieldError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DefineIndexFieldError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "BaseException" => crate::error::DefineIndexFieldError {
            meta: generic,
            kind: crate::error::DefineIndexFieldErrorKind::BaseException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::base_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_base_exception_xml_err(
                        response.body().as_ref(),
                        output,
                    )
                    .map_err(crate::error::DefineIndexFieldError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InternalException" => {
            crate::error::DefineIndexFieldError {
                meta: generic,
                kind: crate::error::DefineIndexFieldErrorKind::InternalException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::internal_exception::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_internal_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DefineIndexFieldError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "InvalidType" => crate::error::DefineIndexFieldError {
            meta: generic,
            kind: crate::error::DefineIndexFieldErrorKind::InvalidTypeException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_type_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_type_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DefineIndexFieldError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "LimitExceeded" => crate::error::DefineIndexFieldError {
            meta: generic,
            kind: crate::error::DefineIndexFieldErrorKind::LimitExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_limit_exceeded_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DefineIndexFieldError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFound" => crate::error::DefineIndexFieldError {
            meta: generic,
            kind: crate::error::DefineIndexFieldErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_resource_not_found_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DefineIndexFieldError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ValidationException" => {
            crate::error::DefineIndexFieldError {
                meta: generic,
                kind: crate::error::DefineIndexFieldErrorKind::ValidationException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::validation_exception::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_validation_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DefineIndexFieldError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::DefineIndexFieldError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_define_index_field_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DefineIndexFieldOutput, crate::error::DefineIndexFieldError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::define_index_field_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_define_index_field(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DefineIndexFieldError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_define_suggester_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DefineSuggesterOutput, crate::error::DefineSuggesterError> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DefineSuggesterError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DefineSuggesterError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "BaseException" => crate::error::DefineSuggesterError {
            meta: generic,
            kind: crate::error::DefineSuggesterErrorKind::BaseException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::base_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_base_exception_xml_err(
                        response.body().as_ref(),
                        output,
                    )
                    .map_err(crate::error::DefineSuggesterError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InternalException" => {
            crate::error::DefineSuggesterError {
                meta: generic,
                kind: crate::error::DefineSuggesterErrorKind::InternalException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::internal_exception::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_internal_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DefineSuggesterError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "InvalidType" => crate::error::DefineSuggesterError {
            meta: generic,
            kind: crate::error::DefineSuggesterErrorKind::InvalidTypeException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_type_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_type_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DefineSuggesterError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "LimitExceeded" => crate::error::DefineSuggesterError {
            meta: generic,
            kind: crate::error::DefineSuggesterErrorKind::LimitExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_limit_exceeded_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DefineSuggesterError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFound" => crate::error::DefineSuggesterError {
            meta: generic,
            kind: crate::error::DefineSuggesterErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_resource_not_found_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DefineSuggesterError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ValidationException" => {
            crate::error::DefineSuggesterError {
                meta: generic,
                kind: crate::error::DefineSuggesterErrorKind::ValidationException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::validation_exception::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_validation_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DefineSuggesterError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::DefineSuggesterError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_define_suggester_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DefineSuggesterOutput, crate::error::DefineSuggesterError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::define_suggester_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_define_suggester(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DefineSuggesterError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_analysis_scheme_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteAnalysisSchemeOutput,
    crate::error::DeleteAnalysisSchemeError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteAnalysisSchemeError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DeleteAnalysisSchemeError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "BaseException" => crate::error::DeleteAnalysisSchemeError {
            meta: generic,
            kind: crate::error::DeleteAnalysisSchemeErrorKind::BaseException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::base_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_base_exception_xml_err(
                        response.body().as_ref(),
                        output,
                    )
                    .map_err(crate::error::DeleteAnalysisSchemeError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InternalException" => {
            crate::error::DeleteAnalysisSchemeError {
                meta: generic,
                kind: crate::error::DeleteAnalysisSchemeErrorKind::InternalException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::internal_exception::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_internal_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteAnalysisSchemeError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "InvalidType" => crate::error::DeleteAnalysisSchemeError {
            meta: generic,
            kind: crate::error::DeleteAnalysisSchemeErrorKind::InvalidTypeException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_type_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_type_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteAnalysisSchemeError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFound" => crate::error::DeleteAnalysisSchemeError {
            meta: generic,
            kind: crate::error::DeleteAnalysisSchemeErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_resource_not_found_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteAnalysisSchemeError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ValidationException" => {
            crate::error::DeleteAnalysisSchemeError {
                meta: generic,
                kind: crate::error::DeleteAnalysisSchemeErrorKind::ValidationException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::validation_exception::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_validation_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteAnalysisSchemeError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::DeleteAnalysisSchemeError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_analysis_scheme_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteAnalysisSchemeOutput,
    crate::error::DeleteAnalysisSchemeError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_analysis_scheme_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_delete_analysis_scheme(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DeleteAnalysisSchemeError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_domain_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteDomainOutput, crate::error::DeleteDomainError> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteDomainError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DeleteDomainError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "BaseException" => crate::error::DeleteDomainError {
            meta: generic,
            kind: crate::error::DeleteDomainErrorKind::BaseException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::base_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_base_exception_xml_err(
                        response.body().as_ref(),
                        output,
                    )
                    .map_err(crate::error::DeleteDomainError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InternalException" => {
            crate::error::DeleteDomainError {
                meta: generic,
                kind: crate::error::DeleteDomainErrorKind::InternalException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::internal_exception::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_internal_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteDomainError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::DeleteDomainError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_domain_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteDomainOutput, crate::error::DeleteDomainError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_domain_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_delete_domain(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DeleteDomainError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_expression_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteExpressionOutput, crate::error::DeleteExpressionError>
{
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteExpressionError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DeleteExpressionError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "BaseException" => crate::error::DeleteExpressionError {
            meta: generic,
            kind: crate::error::DeleteExpressionErrorKind::BaseException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::base_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_base_exception_xml_err(
                        response.body().as_ref(),
                        output,
                    )
                    .map_err(crate::error::DeleteExpressionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InternalException" => {
            crate::error::DeleteExpressionError {
                meta: generic,
                kind: crate::error::DeleteExpressionErrorKind::InternalException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::internal_exception::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_internal_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteExpressionError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "InvalidType" => crate::error::DeleteExpressionError {
            meta: generic,
            kind: crate::error::DeleteExpressionErrorKind::InvalidTypeException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_type_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_type_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteExpressionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFound" => crate::error::DeleteExpressionError {
            meta: generic,
            kind: crate::error::DeleteExpressionErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_resource_not_found_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteExpressionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ValidationException" => {
            crate::error::DeleteExpressionError {
                meta: generic,
                kind: crate::error::DeleteExpressionErrorKind::ValidationException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::validation_exception::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_validation_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteExpressionError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::DeleteExpressionError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_expression_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteExpressionOutput, crate::error::DeleteExpressionError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_expression_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_delete_expression(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DeleteExpressionError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_index_field_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteIndexFieldOutput, crate::error::DeleteIndexFieldError>
{
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteIndexFieldError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DeleteIndexFieldError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "BaseException" => crate::error::DeleteIndexFieldError {
            meta: generic,
            kind: crate::error::DeleteIndexFieldErrorKind::BaseException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::base_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_base_exception_xml_err(
                        response.body().as_ref(),
                        output,
                    )
                    .map_err(crate::error::DeleteIndexFieldError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InternalException" => {
            crate::error::DeleteIndexFieldError {
                meta: generic,
                kind: crate::error::DeleteIndexFieldErrorKind::InternalException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::internal_exception::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_internal_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteIndexFieldError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "InvalidType" => crate::error::DeleteIndexFieldError {
            meta: generic,
            kind: crate::error::DeleteIndexFieldErrorKind::InvalidTypeException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_type_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_type_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteIndexFieldError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFound" => crate::error::DeleteIndexFieldError {
            meta: generic,
            kind: crate::error::DeleteIndexFieldErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_resource_not_found_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteIndexFieldError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ValidationException" => {
            crate::error::DeleteIndexFieldError {
                meta: generic,
                kind: crate::error::DeleteIndexFieldErrorKind::ValidationException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::validation_exception::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_validation_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteIndexFieldError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::DeleteIndexFieldError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_index_field_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteIndexFieldOutput, crate::error::DeleteIndexFieldError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_index_field_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_delete_index_field(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DeleteIndexFieldError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_suggester_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteSuggesterOutput, crate::error::DeleteSuggesterError> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteSuggesterError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DeleteSuggesterError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "BaseException" => crate::error::DeleteSuggesterError {
            meta: generic,
            kind: crate::error::DeleteSuggesterErrorKind::BaseException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::base_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_base_exception_xml_err(
                        response.body().as_ref(),
                        output,
                    )
                    .map_err(crate::error::DeleteSuggesterError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InternalException" => {
            crate::error::DeleteSuggesterError {
                meta: generic,
                kind: crate::error::DeleteSuggesterErrorKind::InternalException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::internal_exception::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_internal_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteSuggesterError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "InvalidType" => crate::error::DeleteSuggesterError {
            meta: generic,
            kind: crate::error::DeleteSuggesterErrorKind::InvalidTypeException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_type_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_type_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteSuggesterError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFound" => crate::error::DeleteSuggesterError {
            meta: generic,
            kind: crate::error::DeleteSuggesterErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_resource_not_found_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteSuggesterError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ValidationException" => {
            crate::error::DeleteSuggesterError {
                meta: generic,
                kind: crate::error::DeleteSuggesterErrorKind::ValidationException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::validation_exception::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_validation_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteSuggesterError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::DeleteSuggesterError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_suggester_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteSuggesterOutput, crate::error::DeleteSuggesterError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_suggester_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_delete_suggester(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DeleteSuggesterError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_analysis_schemes_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeAnalysisSchemesOutput,
    crate::error::DescribeAnalysisSchemesError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeAnalysisSchemesError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DescribeAnalysisSchemesError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "BaseException" => crate::error::DescribeAnalysisSchemesError {
            meta: generic,
            kind: crate::error::DescribeAnalysisSchemesErrorKind::BaseException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::base_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_base_exception_xml_err(
                        response.body().as_ref(),
                        output,
                    )
                    .map_err(crate::error::DescribeAnalysisSchemesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InternalException" => {
            crate::error::DescribeAnalysisSchemesError {
                meta: generic,
                kind: crate::error::DescribeAnalysisSchemesErrorKind::InternalException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::internal_exception::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_internal_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DescribeAnalysisSchemesError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "ResourceNotFound" => crate::error::DescribeAnalysisSchemesError {
            meta: generic,
            kind: crate::error::DescribeAnalysisSchemesErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_resource_not_found_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DescribeAnalysisSchemesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DescribeAnalysisSchemesError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_analysis_schemes_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeAnalysisSchemesOutput,
    crate::error::DescribeAnalysisSchemesError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_analysis_schemes_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_describe_analysis_schemes(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeAnalysisSchemesError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_availability_options_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeAvailabilityOptionsOutput,
    crate::error::DescribeAvailabilityOptionsError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeAvailabilityOptionsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DescribeAvailabilityOptionsError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "BaseException" => crate::error::DescribeAvailabilityOptionsError {
            meta: generic,
            kind: crate::error::DescribeAvailabilityOptionsErrorKind::BaseException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::base_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_base_exception_xml_err(
                        response.body().as_ref(),
                        output,
                    )
                    .map_err(crate::error::DescribeAvailabilityOptionsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "DisabledAction" => crate::error::DescribeAvailabilityOptionsError {
            meta: generic,
            kind: crate::error::DescribeAvailabilityOptionsErrorKind::DisabledOperationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::disabled_operation_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_disabled_operation_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DescribeAvailabilityOptionsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InternalException" => {
            crate::error::DescribeAvailabilityOptionsError {
                meta: generic,
                kind: crate::error::DescribeAvailabilityOptionsErrorKind::InternalException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::internal_exception::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_internal_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DescribeAvailabilityOptionsError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "InvalidType" => crate::error::DescribeAvailabilityOptionsError {
            meta: generic,
            kind: crate::error::DescribeAvailabilityOptionsErrorKind::InvalidTypeException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_type_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_type_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DescribeAvailabilityOptionsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "LimitExceeded" => crate::error::DescribeAvailabilityOptionsError {
            meta: generic,
            kind: crate::error::DescribeAvailabilityOptionsErrorKind::LimitExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_limit_exceeded_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DescribeAvailabilityOptionsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFound" => crate::error::DescribeAvailabilityOptionsError {
            meta: generic,
            kind: crate::error::DescribeAvailabilityOptionsErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_resource_not_found_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DescribeAvailabilityOptionsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DescribeAvailabilityOptionsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_availability_options_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeAvailabilityOptionsOutput,
    crate::error::DescribeAvailabilityOptionsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_availability_options_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_describe_availability_options(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeAvailabilityOptionsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_domain_endpoint_options_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeDomainEndpointOptionsOutput,
    crate::error::DescribeDomainEndpointOptionsError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeDomainEndpointOptionsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DescribeDomainEndpointOptionsError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "BaseException" => crate::error::DescribeDomainEndpointOptionsError {
            meta: generic,
            kind: crate::error::DescribeDomainEndpointOptionsErrorKind::BaseException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::base_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_base_exception_xml_err(
                        response.body().as_ref(),
                        output,
                    )
                    .map_err(crate::error::DescribeDomainEndpointOptionsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "DisabledAction" => crate::error::DescribeDomainEndpointOptionsError {
            meta: generic,
            kind: crate::error::DescribeDomainEndpointOptionsErrorKind::DisabledOperationException(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::disabled_operation_exception::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_disabled_operation_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DescribeDomainEndpointOptionsError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        "InternalException" => {
            crate::error::DescribeDomainEndpointOptionsError {
                meta: generic,
                kind: crate::error::DescribeDomainEndpointOptionsErrorKind::InternalException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::internal_exception::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_internal_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DescribeDomainEndpointOptionsError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "LimitExceeded" => crate::error::DescribeDomainEndpointOptionsError {
            meta: generic,
            kind: crate::error::DescribeDomainEndpointOptionsErrorKind::LimitExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_limit_exceeded_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DescribeDomainEndpointOptionsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFound" => crate::error::DescribeDomainEndpointOptionsError {
            meta: generic,
            kind: crate::error::DescribeDomainEndpointOptionsErrorKind::ResourceNotFoundException(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::resource_not_found_exception::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_resource_not_found_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DescribeDomainEndpointOptionsError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        _ => crate::error::DescribeDomainEndpointOptionsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_domain_endpoint_options_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeDomainEndpointOptionsOutput,
    crate::error::DescribeDomainEndpointOptionsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_domain_endpoint_options_output::Builder::default();
        let _ = response;
        output =
            crate::xml_deser::deser_operation_crate_operation_describe_domain_endpoint_options(
                response.body().as_ref(),
                output,
            )
            .map_err(crate::error::DescribeDomainEndpointOptionsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_domains_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DescribeDomainsOutput, crate::error::DescribeDomainsError> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeDomainsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DescribeDomainsError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "BaseException" => crate::error::DescribeDomainsError {
            meta: generic,
            kind: crate::error::DescribeDomainsErrorKind::BaseException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::base_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_base_exception_xml_err(
                        response.body().as_ref(),
                        output,
                    )
                    .map_err(crate::error::DescribeDomainsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InternalException" => {
            crate::error::DescribeDomainsError {
                meta: generic,
                kind: crate::error::DescribeDomainsErrorKind::InternalException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::internal_exception::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_internal_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DescribeDomainsError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::DescribeDomainsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_domains_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DescribeDomainsOutput, crate::error::DescribeDomainsError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_domains_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_describe_domains(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeDomainsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_expressions_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeExpressionsOutput,
    crate::error::DescribeExpressionsError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeExpressionsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DescribeExpressionsError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "BaseException" => crate::error::DescribeExpressionsError {
            meta: generic,
            kind: crate::error::DescribeExpressionsErrorKind::BaseException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::base_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_base_exception_xml_err(
                        response.body().as_ref(),
                        output,
                    )
                    .map_err(crate::error::DescribeExpressionsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InternalException" => {
            crate::error::DescribeExpressionsError {
                meta: generic,
                kind: crate::error::DescribeExpressionsErrorKind::InternalException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::internal_exception::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_internal_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DescribeExpressionsError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "ResourceNotFound" => crate::error::DescribeExpressionsError {
            meta: generic,
            kind: crate::error::DescribeExpressionsErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_resource_not_found_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DescribeExpressionsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DescribeExpressionsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_expressions_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeExpressionsOutput,
    crate::error::DescribeExpressionsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_expressions_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_describe_expressions(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeExpressionsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_index_fields_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeIndexFieldsOutput,
    crate::error::DescribeIndexFieldsError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeIndexFieldsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DescribeIndexFieldsError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "BaseException" => crate::error::DescribeIndexFieldsError {
            meta: generic,
            kind: crate::error::DescribeIndexFieldsErrorKind::BaseException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::base_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_base_exception_xml_err(
                        response.body().as_ref(),
                        output,
                    )
                    .map_err(crate::error::DescribeIndexFieldsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InternalException" => {
            crate::error::DescribeIndexFieldsError {
                meta: generic,
                kind: crate::error::DescribeIndexFieldsErrorKind::InternalException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::internal_exception::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_internal_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DescribeIndexFieldsError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "ResourceNotFound" => crate::error::DescribeIndexFieldsError {
            meta: generic,
            kind: crate::error::DescribeIndexFieldsErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_resource_not_found_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DescribeIndexFieldsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DescribeIndexFieldsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_index_fields_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeIndexFieldsOutput,
    crate::error::DescribeIndexFieldsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_index_fields_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_describe_index_fields(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeIndexFieldsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_scaling_parameters_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeScalingParametersOutput,
    crate::error::DescribeScalingParametersError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeScalingParametersError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DescribeScalingParametersError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "BaseException" => crate::error::DescribeScalingParametersError {
            meta: generic,
            kind: crate::error::DescribeScalingParametersErrorKind::BaseException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::base_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_base_exception_xml_err(
                        response.body().as_ref(),
                        output,
                    )
                    .map_err(crate::error::DescribeScalingParametersError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InternalException" => {
            crate::error::DescribeScalingParametersError {
                meta: generic,
                kind: crate::error::DescribeScalingParametersErrorKind::InternalException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::internal_exception::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_internal_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DescribeScalingParametersError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "ResourceNotFound" => crate::error::DescribeScalingParametersError {
            meta: generic,
            kind: crate::error::DescribeScalingParametersErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_resource_not_found_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DescribeScalingParametersError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DescribeScalingParametersError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_scaling_parameters_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeScalingParametersOutput,
    crate::error::DescribeScalingParametersError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_scaling_parameters_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_describe_scaling_parameters(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeScalingParametersError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_service_access_policies_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeServiceAccessPoliciesOutput,
    crate::error::DescribeServiceAccessPoliciesError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeServiceAccessPoliciesError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DescribeServiceAccessPoliciesError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "BaseException" => crate::error::DescribeServiceAccessPoliciesError {
            meta: generic,
            kind: crate::error::DescribeServiceAccessPoliciesErrorKind::BaseException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::base_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_base_exception_xml_err(
                        response.body().as_ref(),
                        output,
                    )
                    .map_err(crate::error::DescribeServiceAccessPoliciesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InternalException" => {
            crate::error::DescribeServiceAccessPoliciesError {
                meta: generic,
                kind: crate::error::DescribeServiceAccessPoliciesErrorKind::InternalException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::internal_exception::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_internal_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DescribeServiceAccessPoliciesError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "ResourceNotFound" => crate::error::DescribeServiceAccessPoliciesError {
            meta: generic,
            kind: crate::error::DescribeServiceAccessPoliciesErrorKind::ResourceNotFoundException(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::resource_not_found_exception::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_resource_not_found_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DescribeServiceAccessPoliciesError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        _ => crate::error::DescribeServiceAccessPoliciesError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_service_access_policies_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeServiceAccessPoliciesOutput,
    crate::error::DescribeServiceAccessPoliciesError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_service_access_policies_output::Builder::default();
        let _ = response;
        output =
            crate::xml_deser::deser_operation_crate_operation_describe_service_access_policies(
                response.body().as_ref(),
                output,
            )
            .map_err(crate::error::DescribeServiceAccessPoliciesError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_suggesters_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeSuggestersOutput,
    crate::error::DescribeSuggestersError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeSuggestersError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DescribeSuggestersError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "BaseException" => crate::error::DescribeSuggestersError {
            meta: generic,
            kind: crate::error::DescribeSuggestersErrorKind::BaseException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::base_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_base_exception_xml_err(
                        response.body().as_ref(),
                        output,
                    )
                    .map_err(crate::error::DescribeSuggestersError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InternalException" => {
            crate::error::DescribeSuggestersError {
                meta: generic,
                kind: crate::error::DescribeSuggestersErrorKind::InternalException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::internal_exception::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_internal_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DescribeSuggestersError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "ResourceNotFound" => crate::error::DescribeSuggestersError {
            meta: generic,
            kind: crate::error::DescribeSuggestersErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_resource_not_found_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DescribeSuggestersError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DescribeSuggestersError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_suggesters_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeSuggestersOutput,
    crate::error::DescribeSuggestersError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_suggesters_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_describe_suggesters(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeSuggestersError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_index_documents_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::IndexDocumentsOutput, crate::error::IndexDocumentsError> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::IndexDocumentsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::IndexDocumentsError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "BaseException" => crate::error::IndexDocumentsError {
            meta: generic,
            kind: crate::error::IndexDocumentsErrorKind::BaseException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::base_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_base_exception_xml_err(
                        response.body().as_ref(),
                        output,
                    )
                    .map_err(crate::error::IndexDocumentsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InternalException" => {
            crate::error::IndexDocumentsError {
                meta: generic,
                kind: crate::error::IndexDocumentsErrorKind::InternalException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::internal_exception::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_internal_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::IndexDocumentsError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "ResourceNotFound" => crate::error::IndexDocumentsError {
            meta: generic,
            kind: crate::error::IndexDocumentsErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_resource_not_found_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::IndexDocumentsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ValidationException" => {
            crate::error::IndexDocumentsError {
                meta: generic,
                kind: crate::error::IndexDocumentsErrorKind::ValidationException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::validation_exception::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_validation_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::IndexDocumentsError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::IndexDocumentsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_index_documents_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::IndexDocumentsOutput, crate::error::IndexDocumentsError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::index_documents_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_index_documents(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::IndexDocumentsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_domain_names_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListDomainNamesOutput, crate::error::ListDomainNamesError> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListDomainNamesError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ListDomainNamesError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "BaseException" => crate::error::ListDomainNamesError {
            meta: generic,
            kind: crate::error::ListDomainNamesErrorKind::BaseException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::base_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_base_exception_xml_err(
                        response.body().as_ref(),
                        output,
                    )
                    .map_err(crate::error::ListDomainNamesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ListDomainNamesError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_domain_names_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListDomainNamesOutput, crate::error::ListDomainNamesError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_domain_names_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_list_domain_names(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListDomainNamesError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_availability_options_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UpdateAvailabilityOptionsOutput,
    crate::error::UpdateAvailabilityOptionsError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::UpdateAvailabilityOptionsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::UpdateAvailabilityOptionsError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "BaseException" => crate::error::UpdateAvailabilityOptionsError {
            meta: generic,
            kind: crate::error::UpdateAvailabilityOptionsErrorKind::BaseException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::base_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_base_exception_xml_err(
                        response.body().as_ref(),
                        output,
                    )
                    .map_err(crate::error::UpdateAvailabilityOptionsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "DisabledAction" => crate::error::UpdateAvailabilityOptionsError {
            meta: generic,
            kind: crate::error::UpdateAvailabilityOptionsErrorKind::DisabledOperationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::disabled_operation_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_disabled_operation_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::UpdateAvailabilityOptionsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InternalException" => {
            crate::error::UpdateAvailabilityOptionsError {
                meta: generic,
                kind: crate::error::UpdateAvailabilityOptionsErrorKind::InternalException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::internal_exception::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_internal_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::UpdateAvailabilityOptionsError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "InvalidType" => crate::error::UpdateAvailabilityOptionsError {
            meta: generic,
            kind: crate::error::UpdateAvailabilityOptionsErrorKind::InvalidTypeException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_type_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_type_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::UpdateAvailabilityOptionsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "LimitExceeded" => crate::error::UpdateAvailabilityOptionsError {
            meta: generic,
            kind: crate::error::UpdateAvailabilityOptionsErrorKind::LimitExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_limit_exceeded_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::UpdateAvailabilityOptionsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFound" => crate::error::UpdateAvailabilityOptionsError {
            meta: generic,
            kind: crate::error::UpdateAvailabilityOptionsErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_resource_not_found_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::UpdateAvailabilityOptionsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ValidationException" => {
            crate::error::UpdateAvailabilityOptionsError {
                meta: generic,
                kind: crate::error::UpdateAvailabilityOptionsErrorKind::ValidationException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::validation_exception::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_validation_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::UpdateAvailabilityOptionsError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::UpdateAvailabilityOptionsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_availability_options_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UpdateAvailabilityOptionsOutput,
    crate::error::UpdateAvailabilityOptionsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::update_availability_options_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_update_availability_options(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::UpdateAvailabilityOptionsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_domain_endpoint_options_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UpdateDomainEndpointOptionsOutput,
    crate::error::UpdateDomainEndpointOptionsError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::UpdateDomainEndpointOptionsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::UpdateDomainEndpointOptionsError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "BaseException" => crate::error::UpdateDomainEndpointOptionsError {
            meta: generic,
            kind: crate::error::UpdateDomainEndpointOptionsErrorKind::BaseException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::base_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_base_exception_xml_err(
                        response.body().as_ref(),
                        output,
                    )
                    .map_err(crate::error::UpdateDomainEndpointOptionsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "DisabledAction" => crate::error::UpdateDomainEndpointOptionsError {
            meta: generic,
            kind: crate::error::UpdateDomainEndpointOptionsErrorKind::DisabledOperationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::disabled_operation_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_disabled_operation_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::UpdateDomainEndpointOptionsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InternalException" => {
            crate::error::UpdateDomainEndpointOptionsError {
                meta: generic,
                kind: crate::error::UpdateDomainEndpointOptionsErrorKind::InternalException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::internal_exception::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_internal_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::UpdateDomainEndpointOptionsError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "InvalidType" => crate::error::UpdateDomainEndpointOptionsError {
            meta: generic,
            kind: crate::error::UpdateDomainEndpointOptionsErrorKind::InvalidTypeException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_type_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_type_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::UpdateDomainEndpointOptionsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "LimitExceeded" => crate::error::UpdateDomainEndpointOptionsError {
            meta: generic,
            kind: crate::error::UpdateDomainEndpointOptionsErrorKind::LimitExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_limit_exceeded_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::UpdateDomainEndpointOptionsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFound" => crate::error::UpdateDomainEndpointOptionsError {
            meta: generic,
            kind: crate::error::UpdateDomainEndpointOptionsErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_resource_not_found_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::UpdateDomainEndpointOptionsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ValidationException" => {
            crate::error::UpdateDomainEndpointOptionsError {
                meta: generic,
                kind: crate::error::UpdateDomainEndpointOptionsErrorKind::ValidationException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::validation_exception::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_validation_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::UpdateDomainEndpointOptionsError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::UpdateDomainEndpointOptionsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_domain_endpoint_options_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UpdateDomainEndpointOptionsOutput,
    crate::error::UpdateDomainEndpointOptionsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::update_domain_endpoint_options_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_update_domain_endpoint_options(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::UpdateDomainEndpointOptionsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_scaling_parameters_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UpdateScalingParametersOutput,
    crate::error::UpdateScalingParametersError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::UpdateScalingParametersError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::UpdateScalingParametersError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "BaseException" => crate::error::UpdateScalingParametersError {
            meta: generic,
            kind: crate::error::UpdateScalingParametersErrorKind::BaseException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::base_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_base_exception_xml_err(
                        response.body().as_ref(),
                        output,
                    )
                    .map_err(crate::error::UpdateScalingParametersError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InternalException" => {
            crate::error::UpdateScalingParametersError {
                meta: generic,
                kind: crate::error::UpdateScalingParametersErrorKind::InternalException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::internal_exception::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_internal_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::UpdateScalingParametersError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "InvalidType" => crate::error::UpdateScalingParametersError {
            meta: generic,
            kind: crate::error::UpdateScalingParametersErrorKind::InvalidTypeException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_type_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_type_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::UpdateScalingParametersError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "LimitExceeded" => crate::error::UpdateScalingParametersError {
            meta: generic,
            kind: crate::error::UpdateScalingParametersErrorKind::LimitExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_limit_exceeded_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::UpdateScalingParametersError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFound" => crate::error::UpdateScalingParametersError {
            meta: generic,
            kind: crate::error::UpdateScalingParametersErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_resource_not_found_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::UpdateScalingParametersError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ValidationException" => {
            crate::error::UpdateScalingParametersError {
                meta: generic,
                kind: crate::error::UpdateScalingParametersErrorKind::ValidationException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::validation_exception::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_validation_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::UpdateScalingParametersError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::UpdateScalingParametersError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_scaling_parameters_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UpdateScalingParametersOutput,
    crate::error::UpdateScalingParametersError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::update_scaling_parameters_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_update_scaling_parameters(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::UpdateScalingParametersError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_service_access_policies_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UpdateServiceAccessPoliciesOutput,
    crate::error::UpdateServiceAccessPoliciesError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::UpdateServiceAccessPoliciesError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::UpdateServiceAccessPoliciesError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "BaseException" => crate::error::UpdateServiceAccessPoliciesError {
            meta: generic,
            kind: crate::error::UpdateServiceAccessPoliciesErrorKind::BaseException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::base_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_base_exception_xml_err(
                        response.body().as_ref(),
                        output,
                    )
                    .map_err(crate::error::UpdateServiceAccessPoliciesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InternalException" => {
            crate::error::UpdateServiceAccessPoliciesError {
                meta: generic,
                kind: crate::error::UpdateServiceAccessPoliciesErrorKind::InternalException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::internal_exception::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_internal_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::UpdateServiceAccessPoliciesError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "InvalidType" => crate::error::UpdateServiceAccessPoliciesError {
            meta: generic,
            kind: crate::error::UpdateServiceAccessPoliciesErrorKind::InvalidTypeException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_type_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_type_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::UpdateServiceAccessPoliciesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "LimitExceeded" => crate::error::UpdateServiceAccessPoliciesError {
            meta: generic,
            kind: crate::error::UpdateServiceAccessPoliciesErrorKind::LimitExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_limit_exceeded_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::UpdateServiceAccessPoliciesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFound" => crate::error::UpdateServiceAccessPoliciesError {
            meta: generic,
            kind: crate::error::UpdateServiceAccessPoliciesErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_resource_not_found_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::UpdateServiceAccessPoliciesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ValidationException" => {
            crate::error::UpdateServiceAccessPoliciesError {
                meta: generic,
                kind: crate::error::UpdateServiceAccessPoliciesErrorKind::ValidationException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::validation_exception::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_validation_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::UpdateServiceAccessPoliciesError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::UpdateServiceAccessPoliciesError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_service_access_policies_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UpdateServiceAccessPoliciesOutput,
    crate::error::UpdateServiceAccessPoliciesError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::update_service_access_policies_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_update_service_access_policies(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::UpdateServiceAccessPoliciesError::unhandled)?;
        output.build()
    })
}
