// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// <p>The result of an <code>UpdateServiceAccessPolicies</code> request. Contains the new access policies.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateServiceAccessPoliciesOutput {
    /// <p>The access rules configured for the domain.</p>
    pub access_policies: std::option::Option<crate::model::AccessPoliciesStatus>,
}
impl UpdateServiceAccessPoliciesOutput {
    /// <p>The access rules configured for the domain.</p>
    pub fn access_policies(&self) -> std::option::Option<&crate::model::AccessPoliciesStatus> {
        self.access_policies.as_ref()
    }
}
impl std::fmt::Debug for UpdateServiceAccessPoliciesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateServiceAccessPoliciesOutput");
        formatter.field("access_policies", &self.access_policies);
        formatter.finish()
    }
}
/// See [`UpdateServiceAccessPoliciesOutput`](crate::output::UpdateServiceAccessPoliciesOutput)
pub mod update_service_access_policies_output {
    /// A builder for [`UpdateServiceAccessPoliciesOutput`](crate::output::UpdateServiceAccessPoliciesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) access_policies: std::option::Option<crate::model::AccessPoliciesStatus>,
    }
    impl Builder {
        /// <p>The access rules configured for the domain.</p>
        pub fn access_policies(mut self, input: crate::model::AccessPoliciesStatus) -> Self {
            self.access_policies = Some(input);
            self
        }
        /// <p>The access rules configured for the domain.</p>
        pub fn set_access_policies(
            mut self,
            input: std::option::Option<crate::model::AccessPoliciesStatus>,
        ) -> Self {
            self.access_policies = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateServiceAccessPoliciesOutput`](crate::output::UpdateServiceAccessPoliciesOutput)
        pub fn build(self) -> crate::output::UpdateServiceAccessPoliciesOutput {
            crate::output::UpdateServiceAccessPoliciesOutput {
                access_policies: self.access_policies,
            }
        }
    }
}
impl UpdateServiceAccessPoliciesOutput {
    /// Creates a new builder-style object to manufacture [`UpdateServiceAccessPoliciesOutput`](crate::output::UpdateServiceAccessPoliciesOutput)
    pub fn builder() -> crate::output::update_service_access_policies_output::Builder {
        crate::output::update_service_access_policies_output::Builder::default()
    }
}

/// <p>The result of a <code>UpdateScalingParameters</code> request. Contains the status of the newly-configured scaling parameters.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateScalingParametersOutput {
    /// <p>The status and configuration of a search domain's scaling parameters. </p>
    pub scaling_parameters: std::option::Option<crate::model::ScalingParametersStatus>,
}
impl UpdateScalingParametersOutput {
    /// <p>The status and configuration of a search domain's scaling parameters. </p>
    pub fn scaling_parameters(
        &self,
    ) -> std::option::Option<&crate::model::ScalingParametersStatus> {
        self.scaling_parameters.as_ref()
    }
}
impl std::fmt::Debug for UpdateScalingParametersOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateScalingParametersOutput");
        formatter.field("scaling_parameters", &self.scaling_parameters);
        formatter.finish()
    }
}
/// See [`UpdateScalingParametersOutput`](crate::output::UpdateScalingParametersOutput)
pub mod update_scaling_parameters_output {
    /// A builder for [`UpdateScalingParametersOutput`](crate::output::UpdateScalingParametersOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) scaling_parameters: std::option::Option<crate::model::ScalingParametersStatus>,
    }
    impl Builder {
        /// <p>The status and configuration of a search domain's scaling parameters. </p>
        pub fn scaling_parameters(mut self, input: crate::model::ScalingParametersStatus) -> Self {
            self.scaling_parameters = Some(input);
            self
        }
        /// <p>The status and configuration of a search domain's scaling parameters. </p>
        pub fn set_scaling_parameters(
            mut self,
            input: std::option::Option<crate::model::ScalingParametersStatus>,
        ) -> Self {
            self.scaling_parameters = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateScalingParametersOutput`](crate::output::UpdateScalingParametersOutput)
        pub fn build(self) -> crate::output::UpdateScalingParametersOutput {
            crate::output::UpdateScalingParametersOutput {
                scaling_parameters: self.scaling_parameters,
            }
        }
    }
}
impl UpdateScalingParametersOutput {
    /// Creates a new builder-style object to manufacture [`UpdateScalingParametersOutput`](crate::output::UpdateScalingParametersOutput)
    pub fn builder() -> crate::output::update_scaling_parameters_output::Builder {
        crate::output::update_scaling_parameters_output::Builder::default()
    }
}

/// <p>The result of a <code>UpdateDomainEndpointOptions</code> request. Contains the configuration and status of the domain's endpoint options. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateDomainEndpointOptionsOutput {
    /// <p>The newly-configured domain endpoint options.</p>
    pub domain_endpoint_options: std::option::Option<crate::model::DomainEndpointOptionsStatus>,
}
impl UpdateDomainEndpointOptionsOutput {
    /// <p>The newly-configured domain endpoint options.</p>
    pub fn domain_endpoint_options(
        &self,
    ) -> std::option::Option<&crate::model::DomainEndpointOptionsStatus> {
        self.domain_endpoint_options.as_ref()
    }
}
impl std::fmt::Debug for UpdateDomainEndpointOptionsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateDomainEndpointOptionsOutput");
        formatter.field("domain_endpoint_options", &self.domain_endpoint_options);
        formatter.finish()
    }
}
/// See [`UpdateDomainEndpointOptionsOutput`](crate::output::UpdateDomainEndpointOptionsOutput)
pub mod update_domain_endpoint_options_output {
    /// A builder for [`UpdateDomainEndpointOptionsOutput`](crate::output::UpdateDomainEndpointOptionsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) domain_endpoint_options:
            std::option::Option<crate::model::DomainEndpointOptionsStatus>,
    }
    impl Builder {
        /// <p>The newly-configured domain endpoint options.</p>
        pub fn domain_endpoint_options(
            mut self,
            input: crate::model::DomainEndpointOptionsStatus,
        ) -> Self {
            self.domain_endpoint_options = Some(input);
            self
        }
        /// <p>The newly-configured domain endpoint options.</p>
        pub fn set_domain_endpoint_options(
            mut self,
            input: std::option::Option<crate::model::DomainEndpointOptionsStatus>,
        ) -> Self {
            self.domain_endpoint_options = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateDomainEndpointOptionsOutput`](crate::output::UpdateDomainEndpointOptionsOutput)
        pub fn build(self) -> crate::output::UpdateDomainEndpointOptionsOutput {
            crate::output::UpdateDomainEndpointOptionsOutput {
                domain_endpoint_options: self.domain_endpoint_options,
            }
        }
    }
}
impl UpdateDomainEndpointOptionsOutput {
    /// Creates a new builder-style object to manufacture [`UpdateDomainEndpointOptionsOutput`](crate::output::UpdateDomainEndpointOptionsOutput)
    pub fn builder() -> crate::output::update_domain_endpoint_options_output::Builder {
        crate::output::update_domain_endpoint_options_output::Builder::default()
    }
}

/// <p>The result of a <code>UpdateAvailabilityOptions</code> request. Contains the status of the domain's availability options. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateAvailabilityOptionsOutput {
    /// <p>The newly-configured availability options. Indicates whether Multi-AZ is enabled for the domain. </p>
    pub availability_options: std::option::Option<crate::model::AvailabilityOptionsStatus>,
}
impl UpdateAvailabilityOptionsOutput {
    /// <p>The newly-configured availability options. Indicates whether Multi-AZ is enabled for the domain. </p>
    pub fn availability_options(
        &self,
    ) -> std::option::Option<&crate::model::AvailabilityOptionsStatus> {
        self.availability_options.as_ref()
    }
}
impl std::fmt::Debug for UpdateAvailabilityOptionsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateAvailabilityOptionsOutput");
        formatter.field("availability_options", &self.availability_options);
        formatter.finish()
    }
}
/// See [`UpdateAvailabilityOptionsOutput`](crate::output::UpdateAvailabilityOptionsOutput)
pub mod update_availability_options_output {
    /// A builder for [`UpdateAvailabilityOptionsOutput`](crate::output::UpdateAvailabilityOptionsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) availability_options:
            std::option::Option<crate::model::AvailabilityOptionsStatus>,
    }
    impl Builder {
        /// <p>The newly-configured availability options. Indicates whether Multi-AZ is enabled for the domain. </p>
        pub fn availability_options(
            mut self,
            input: crate::model::AvailabilityOptionsStatus,
        ) -> Self {
            self.availability_options = Some(input);
            self
        }
        /// <p>The newly-configured availability options. Indicates whether Multi-AZ is enabled for the domain. </p>
        pub fn set_availability_options(
            mut self,
            input: std::option::Option<crate::model::AvailabilityOptionsStatus>,
        ) -> Self {
            self.availability_options = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateAvailabilityOptionsOutput`](crate::output::UpdateAvailabilityOptionsOutput)
        pub fn build(self) -> crate::output::UpdateAvailabilityOptionsOutput {
            crate::output::UpdateAvailabilityOptionsOutput {
                availability_options: self.availability_options,
            }
        }
    }
}
impl UpdateAvailabilityOptionsOutput {
    /// Creates a new builder-style object to manufacture [`UpdateAvailabilityOptionsOutput`](crate::output::UpdateAvailabilityOptionsOutput)
    pub fn builder() -> crate::output::update_availability_options_output::Builder {
        crate::output::update_availability_options_output::Builder::default()
    }
}

/// <p>The result of a <code>ListDomainNames</code> request. Contains a list of the domains owned by an account.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListDomainNamesOutput {
    /// <p>The names of the search domains owned by an account.</p>
    pub domain_names:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl ListDomainNamesOutput {
    /// <p>The names of the search domains owned by an account.</p>
    pub fn domain_names(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.domain_names.as_ref()
    }
}
impl std::fmt::Debug for ListDomainNamesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListDomainNamesOutput");
        formatter.field("domain_names", &self.domain_names);
        formatter.finish()
    }
}
/// See [`ListDomainNamesOutput`](crate::output::ListDomainNamesOutput)
pub mod list_domain_names_output {
    /// A builder for [`ListDomainNamesOutput`](crate::output::ListDomainNamesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) domain_names: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// Adds a key-value pair to `domain_names`.
        ///
        /// To override the contents of this collection use [`set_domain_names`](Self::set_domain_names).
        ///
        /// <p>The names of the search domains owned by an account.</p>
        pub fn domain_names(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.domain_names.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.domain_names = Some(hash_map);
            self
        }
        /// <p>The names of the search domains owned by an account.</p>
        pub fn set_domain_names(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.domain_names = input;
            self
        }
        /// Consumes the builder and constructs a [`ListDomainNamesOutput`](crate::output::ListDomainNamesOutput)
        pub fn build(self) -> crate::output::ListDomainNamesOutput {
            crate::output::ListDomainNamesOutput {
                domain_names: self.domain_names,
            }
        }
    }
}
impl ListDomainNamesOutput {
    /// Creates a new builder-style object to manufacture [`ListDomainNamesOutput`](crate::output::ListDomainNamesOutput)
    pub fn builder() -> crate::output::list_domain_names_output::Builder {
        crate::output::list_domain_names_output::Builder::default()
    }
}

/// <p>The result of an <code>IndexDocuments</code> request. Contains the status of the indexing operation, including the fields being indexed.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct IndexDocumentsOutput {
    /// <p>The names of the fields that are currently being indexed.</p>
    pub field_names: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl IndexDocumentsOutput {
    /// <p>The names of the fields that are currently being indexed.</p>
    pub fn field_names(&self) -> std::option::Option<&[std::string::String]> {
        self.field_names.as_deref()
    }
}
impl std::fmt::Debug for IndexDocumentsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("IndexDocumentsOutput");
        formatter.field("field_names", &self.field_names);
        formatter.finish()
    }
}
/// See [`IndexDocumentsOutput`](crate::output::IndexDocumentsOutput)
pub mod index_documents_output {
    /// A builder for [`IndexDocumentsOutput`](crate::output::IndexDocumentsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) field_names: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// Appends an item to `field_names`.
        ///
        /// To override the contents of this collection use [`set_field_names`](Self::set_field_names).
        ///
        /// <p>The names of the fields that are currently being indexed.</p>
        pub fn field_names(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.field_names.unwrap_or_default();
            v.push(input.into());
            self.field_names = Some(v);
            self
        }
        /// <p>The names of the fields that are currently being indexed.</p>
        pub fn set_field_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.field_names = input;
            self
        }
        /// Consumes the builder and constructs a [`IndexDocumentsOutput`](crate::output::IndexDocumentsOutput)
        pub fn build(self) -> crate::output::IndexDocumentsOutput {
            crate::output::IndexDocumentsOutput {
                field_names: self.field_names,
            }
        }
    }
}
impl IndexDocumentsOutput {
    /// Creates a new builder-style object to manufacture [`IndexDocumentsOutput`](crate::output::IndexDocumentsOutput)
    pub fn builder() -> crate::output::index_documents_output::Builder {
        crate::output::index_documents_output::Builder::default()
    }
}

/// <p>The result of a <code>DescribeSuggesters</code> request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeSuggestersOutput {
    /// <p>The suggesters configured for the domain specified in the request.</p>
    pub suggesters: std::option::Option<std::vec::Vec<crate::model::SuggesterStatus>>,
}
impl DescribeSuggestersOutput {
    /// <p>The suggesters configured for the domain specified in the request.</p>
    pub fn suggesters(&self) -> std::option::Option<&[crate::model::SuggesterStatus]> {
        self.suggesters.as_deref()
    }
}
impl std::fmt::Debug for DescribeSuggestersOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeSuggestersOutput");
        formatter.field("suggesters", &self.suggesters);
        formatter.finish()
    }
}
/// See [`DescribeSuggestersOutput`](crate::output::DescribeSuggestersOutput)
pub mod describe_suggesters_output {
    /// A builder for [`DescribeSuggestersOutput`](crate::output::DescribeSuggestersOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) suggesters: std::option::Option<std::vec::Vec<crate::model::SuggesterStatus>>,
    }
    impl Builder {
        /// Appends an item to `suggesters`.
        ///
        /// To override the contents of this collection use [`set_suggesters`](Self::set_suggesters).
        ///
        /// <p>The suggesters configured for the domain specified in the request.</p>
        pub fn suggesters(mut self, input: crate::model::SuggesterStatus) -> Self {
            let mut v = self.suggesters.unwrap_or_default();
            v.push(input);
            self.suggesters = Some(v);
            self
        }
        /// <p>The suggesters configured for the domain specified in the request.</p>
        pub fn set_suggesters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SuggesterStatus>>,
        ) -> Self {
            self.suggesters = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeSuggestersOutput`](crate::output::DescribeSuggestersOutput)
        pub fn build(self) -> crate::output::DescribeSuggestersOutput {
            crate::output::DescribeSuggestersOutput {
                suggesters: self.suggesters,
            }
        }
    }
}
impl DescribeSuggestersOutput {
    /// Creates a new builder-style object to manufacture [`DescribeSuggestersOutput`](crate::output::DescribeSuggestersOutput)
    pub fn builder() -> crate::output::describe_suggesters_output::Builder {
        crate::output::describe_suggesters_output::Builder::default()
    }
}

/// <p>The result of a <code>DescribeServiceAccessPolicies</code> request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeServiceAccessPoliciesOutput {
    /// <p>The access rules configured for the domain specified in the request.</p>
    pub access_policies: std::option::Option<crate::model::AccessPoliciesStatus>,
}
impl DescribeServiceAccessPoliciesOutput {
    /// <p>The access rules configured for the domain specified in the request.</p>
    pub fn access_policies(&self) -> std::option::Option<&crate::model::AccessPoliciesStatus> {
        self.access_policies.as_ref()
    }
}
impl std::fmt::Debug for DescribeServiceAccessPoliciesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeServiceAccessPoliciesOutput");
        formatter.field("access_policies", &self.access_policies);
        formatter.finish()
    }
}
/// See [`DescribeServiceAccessPoliciesOutput`](crate::output::DescribeServiceAccessPoliciesOutput)
pub mod describe_service_access_policies_output {
    /// A builder for [`DescribeServiceAccessPoliciesOutput`](crate::output::DescribeServiceAccessPoliciesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) access_policies: std::option::Option<crate::model::AccessPoliciesStatus>,
    }
    impl Builder {
        /// <p>The access rules configured for the domain specified in the request.</p>
        pub fn access_policies(mut self, input: crate::model::AccessPoliciesStatus) -> Self {
            self.access_policies = Some(input);
            self
        }
        /// <p>The access rules configured for the domain specified in the request.</p>
        pub fn set_access_policies(
            mut self,
            input: std::option::Option<crate::model::AccessPoliciesStatus>,
        ) -> Self {
            self.access_policies = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeServiceAccessPoliciesOutput`](crate::output::DescribeServiceAccessPoliciesOutput)
        pub fn build(self) -> crate::output::DescribeServiceAccessPoliciesOutput {
            crate::output::DescribeServiceAccessPoliciesOutput {
                access_policies: self.access_policies,
            }
        }
    }
}
impl DescribeServiceAccessPoliciesOutput {
    /// Creates a new builder-style object to manufacture [`DescribeServiceAccessPoliciesOutput`](crate::output::DescribeServiceAccessPoliciesOutput)
    pub fn builder() -> crate::output::describe_service_access_policies_output::Builder {
        crate::output::describe_service_access_policies_output::Builder::default()
    }
}

/// <p>The result of a <code>DescribeScalingParameters</code> request. Contains the scaling parameters configured for the domain specified in the request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeScalingParametersOutput {
    /// <p>The status and configuration of a search domain's scaling parameters. </p>
    pub scaling_parameters: std::option::Option<crate::model::ScalingParametersStatus>,
}
impl DescribeScalingParametersOutput {
    /// <p>The status and configuration of a search domain's scaling parameters. </p>
    pub fn scaling_parameters(
        &self,
    ) -> std::option::Option<&crate::model::ScalingParametersStatus> {
        self.scaling_parameters.as_ref()
    }
}
impl std::fmt::Debug for DescribeScalingParametersOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeScalingParametersOutput");
        formatter.field("scaling_parameters", &self.scaling_parameters);
        formatter.finish()
    }
}
/// See [`DescribeScalingParametersOutput`](crate::output::DescribeScalingParametersOutput)
pub mod describe_scaling_parameters_output {
    /// A builder for [`DescribeScalingParametersOutput`](crate::output::DescribeScalingParametersOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) scaling_parameters: std::option::Option<crate::model::ScalingParametersStatus>,
    }
    impl Builder {
        /// <p>The status and configuration of a search domain's scaling parameters. </p>
        pub fn scaling_parameters(mut self, input: crate::model::ScalingParametersStatus) -> Self {
            self.scaling_parameters = Some(input);
            self
        }
        /// <p>The status and configuration of a search domain's scaling parameters. </p>
        pub fn set_scaling_parameters(
            mut self,
            input: std::option::Option<crate::model::ScalingParametersStatus>,
        ) -> Self {
            self.scaling_parameters = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeScalingParametersOutput`](crate::output::DescribeScalingParametersOutput)
        pub fn build(self) -> crate::output::DescribeScalingParametersOutput {
            crate::output::DescribeScalingParametersOutput {
                scaling_parameters: self.scaling_parameters,
            }
        }
    }
}
impl DescribeScalingParametersOutput {
    /// Creates a new builder-style object to manufacture [`DescribeScalingParametersOutput`](crate::output::DescribeScalingParametersOutput)
    pub fn builder() -> crate::output::describe_scaling_parameters_output::Builder {
        crate::output::describe_scaling_parameters_output::Builder::default()
    }
}

/// <p>The result of a <code>DescribeIndexFields</code> request. Contains the index fields configured for the domain specified in the request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeIndexFieldsOutput {
    /// <p>The index fields configured for the domain.</p>
    pub index_fields: std::option::Option<std::vec::Vec<crate::model::IndexFieldStatus>>,
}
impl DescribeIndexFieldsOutput {
    /// <p>The index fields configured for the domain.</p>
    pub fn index_fields(&self) -> std::option::Option<&[crate::model::IndexFieldStatus]> {
        self.index_fields.as_deref()
    }
}
impl std::fmt::Debug for DescribeIndexFieldsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeIndexFieldsOutput");
        formatter.field("index_fields", &self.index_fields);
        formatter.finish()
    }
}
/// See [`DescribeIndexFieldsOutput`](crate::output::DescribeIndexFieldsOutput)
pub mod describe_index_fields_output {
    /// A builder for [`DescribeIndexFieldsOutput`](crate::output::DescribeIndexFieldsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) index_fields: std::option::Option<std::vec::Vec<crate::model::IndexFieldStatus>>,
    }
    impl Builder {
        /// Appends an item to `index_fields`.
        ///
        /// To override the contents of this collection use [`set_index_fields`](Self::set_index_fields).
        ///
        /// <p>The index fields configured for the domain.</p>
        pub fn index_fields(mut self, input: crate::model::IndexFieldStatus) -> Self {
            let mut v = self.index_fields.unwrap_or_default();
            v.push(input);
            self.index_fields = Some(v);
            self
        }
        /// <p>The index fields configured for the domain.</p>
        pub fn set_index_fields(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::IndexFieldStatus>>,
        ) -> Self {
            self.index_fields = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeIndexFieldsOutput`](crate::output::DescribeIndexFieldsOutput)
        pub fn build(self) -> crate::output::DescribeIndexFieldsOutput {
            crate::output::DescribeIndexFieldsOutput {
                index_fields: self.index_fields,
            }
        }
    }
}
impl DescribeIndexFieldsOutput {
    /// Creates a new builder-style object to manufacture [`DescribeIndexFieldsOutput`](crate::output::DescribeIndexFieldsOutput)
    pub fn builder() -> crate::output::describe_index_fields_output::Builder {
        crate::output::describe_index_fields_output::Builder::default()
    }
}

/// <p>The result of a <code>DescribeExpressions</code> request. Contains the expressions configured for the domain specified in the request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeExpressionsOutput {
    /// <p>The expressions configured for the domain.</p>
    pub expressions: std::option::Option<std::vec::Vec<crate::model::ExpressionStatus>>,
}
impl DescribeExpressionsOutput {
    /// <p>The expressions configured for the domain.</p>
    pub fn expressions(&self) -> std::option::Option<&[crate::model::ExpressionStatus]> {
        self.expressions.as_deref()
    }
}
impl std::fmt::Debug for DescribeExpressionsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeExpressionsOutput");
        formatter.field("expressions", &self.expressions);
        formatter.finish()
    }
}
/// See [`DescribeExpressionsOutput`](crate::output::DescribeExpressionsOutput)
pub mod describe_expressions_output {
    /// A builder for [`DescribeExpressionsOutput`](crate::output::DescribeExpressionsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) expressions: std::option::Option<std::vec::Vec<crate::model::ExpressionStatus>>,
    }
    impl Builder {
        /// Appends an item to `expressions`.
        ///
        /// To override the contents of this collection use [`set_expressions`](Self::set_expressions).
        ///
        /// <p>The expressions configured for the domain.</p>
        pub fn expressions(mut self, input: crate::model::ExpressionStatus) -> Self {
            let mut v = self.expressions.unwrap_or_default();
            v.push(input);
            self.expressions = Some(v);
            self
        }
        /// <p>The expressions configured for the domain.</p>
        pub fn set_expressions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ExpressionStatus>>,
        ) -> Self {
            self.expressions = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeExpressionsOutput`](crate::output::DescribeExpressionsOutput)
        pub fn build(self) -> crate::output::DescribeExpressionsOutput {
            crate::output::DescribeExpressionsOutput {
                expressions: self.expressions,
            }
        }
    }
}
impl DescribeExpressionsOutput {
    /// Creates a new builder-style object to manufacture [`DescribeExpressionsOutput`](crate::output::DescribeExpressionsOutput)
    pub fn builder() -> crate::output::describe_expressions_output::Builder {
        crate::output::describe_expressions_output::Builder::default()
    }
}

/// <p>The result of a <code>DescribeDomains</code> request. Contains the status of the domains specified in the request or all domains owned by the account.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeDomainsOutput {
    /// <p>A list that contains the status of each requested domain.</p>
    pub domain_status_list: std::option::Option<std::vec::Vec<crate::model::DomainStatus>>,
}
impl DescribeDomainsOutput {
    /// <p>A list that contains the status of each requested domain.</p>
    pub fn domain_status_list(&self) -> std::option::Option<&[crate::model::DomainStatus]> {
        self.domain_status_list.as_deref()
    }
}
impl std::fmt::Debug for DescribeDomainsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeDomainsOutput");
        formatter.field("domain_status_list", &self.domain_status_list);
        formatter.finish()
    }
}
/// See [`DescribeDomainsOutput`](crate::output::DescribeDomainsOutput)
pub mod describe_domains_output {
    /// A builder for [`DescribeDomainsOutput`](crate::output::DescribeDomainsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) domain_status_list:
            std::option::Option<std::vec::Vec<crate::model::DomainStatus>>,
    }
    impl Builder {
        /// Appends an item to `domain_status_list`.
        ///
        /// To override the contents of this collection use [`set_domain_status_list`](Self::set_domain_status_list).
        ///
        /// <p>A list that contains the status of each requested domain.</p>
        pub fn domain_status_list(mut self, input: crate::model::DomainStatus) -> Self {
            let mut v = self.domain_status_list.unwrap_or_default();
            v.push(input);
            self.domain_status_list = Some(v);
            self
        }
        /// <p>A list that contains the status of each requested domain.</p>
        pub fn set_domain_status_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DomainStatus>>,
        ) -> Self {
            self.domain_status_list = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeDomainsOutput`](crate::output::DescribeDomainsOutput)
        pub fn build(self) -> crate::output::DescribeDomainsOutput {
            crate::output::DescribeDomainsOutput {
                domain_status_list: self.domain_status_list,
            }
        }
    }
}
impl DescribeDomainsOutput {
    /// Creates a new builder-style object to manufacture [`DescribeDomainsOutput`](crate::output::DescribeDomainsOutput)
    pub fn builder() -> crate::output::describe_domains_output::Builder {
        crate::output::describe_domains_output::Builder::default()
    }
}

/// <p>The result of a <code>DescribeDomainEndpointOptions</code> request. Contains the status and configuration of a search domain's endpoint options. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeDomainEndpointOptionsOutput {
    /// <p>The status and configuration of a search domain's endpoint options.</p>
    pub domain_endpoint_options: std::option::Option<crate::model::DomainEndpointOptionsStatus>,
}
impl DescribeDomainEndpointOptionsOutput {
    /// <p>The status and configuration of a search domain's endpoint options.</p>
    pub fn domain_endpoint_options(
        &self,
    ) -> std::option::Option<&crate::model::DomainEndpointOptionsStatus> {
        self.domain_endpoint_options.as_ref()
    }
}
impl std::fmt::Debug for DescribeDomainEndpointOptionsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeDomainEndpointOptionsOutput");
        formatter.field("domain_endpoint_options", &self.domain_endpoint_options);
        formatter.finish()
    }
}
/// See [`DescribeDomainEndpointOptionsOutput`](crate::output::DescribeDomainEndpointOptionsOutput)
pub mod describe_domain_endpoint_options_output {
    /// A builder for [`DescribeDomainEndpointOptionsOutput`](crate::output::DescribeDomainEndpointOptionsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) domain_endpoint_options:
            std::option::Option<crate::model::DomainEndpointOptionsStatus>,
    }
    impl Builder {
        /// <p>The status and configuration of a search domain's endpoint options.</p>
        pub fn domain_endpoint_options(
            mut self,
            input: crate::model::DomainEndpointOptionsStatus,
        ) -> Self {
            self.domain_endpoint_options = Some(input);
            self
        }
        /// <p>The status and configuration of a search domain's endpoint options.</p>
        pub fn set_domain_endpoint_options(
            mut self,
            input: std::option::Option<crate::model::DomainEndpointOptionsStatus>,
        ) -> Self {
            self.domain_endpoint_options = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeDomainEndpointOptionsOutput`](crate::output::DescribeDomainEndpointOptionsOutput)
        pub fn build(self) -> crate::output::DescribeDomainEndpointOptionsOutput {
            crate::output::DescribeDomainEndpointOptionsOutput {
                domain_endpoint_options: self.domain_endpoint_options,
            }
        }
    }
}
impl DescribeDomainEndpointOptionsOutput {
    /// Creates a new builder-style object to manufacture [`DescribeDomainEndpointOptionsOutput`](crate::output::DescribeDomainEndpointOptionsOutput)
    pub fn builder() -> crate::output::describe_domain_endpoint_options_output::Builder {
        crate::output::describe_domain_endpoint_options_output::Builder::default()
    }
}

/// <p>The result of a <code>DescribeAvailabilityOptions</code> request. Indicates whether or not the Multi-AZ option is enabled for the domain specified in the request. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeAvailabilityOptionsOutput {
    /// <p>The availability options configured for the domain. Indicates whether Multi-AZ is enabled for the domain. </p>
    pub availability_options: std::option::Option<crate::model::AvailabilityOptionsStatus>,
}
impl DescribeAvailabilityOptionsOutput {
    /// <p>The availability options configured for the domain. Indicates whether Multi-AZ is enabled for the domain. </p>
    pub fn availability_options(
        &self,
    ) -> std::option::Option<&crate::model::AvailabilityOptionsStatus> {
        self.availability_options.as_ref()
    }
}
impl std::fmt::Debug for DescribeAvailabilityOptionsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeAvailabilityOptionsOutput");
        formatter.field("availability_options", &self.availability_options);
        formatter.finish()
    }
}
/// See [`DescribeAvailabilityOptionsOutput`](crate::output::DescribeAvailabilityOptionsOutput)
pub mod describe_availability_options_output {
    /// A builder for [`DescribeAvailabilityOptionsOutput`](crate::output::DescribeAvailabilityOptionsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) availability_options:
            std::option::Option<crate::model::AvailabilityOptionsStatus>,
    }
    impl Builder {
        /// <p>The availability options configured for the domain. Indicates whether Multi-AZ is enabled for the domain. </p>
        pub fn availability_options(
            mut self,
            input: crate::model::AvailabilityOptionsStatus,
        ) -> Self {
            self.availability_options = Some(input);
            self
        }
        /// <p>The availability options configured for the domain. Indicates whether Multi-AZ is enabled for the domain. </p>
        pub fn set_availability_options(
            mut self,
            input: std::option::Option<crate::model::AvailabilityOptionsStatus>,
        ) -> Self {
            self.availability_options = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeAvailabilityOptionsOutput`](crate::output::DescribeAvailabilityOptionsOutput)
        pub fn build(self) -> crate::output::DescribeAvailabilityOptionsOutput {
            crate::output::DescribeAvailabilityOptionsOutput {
                availability_options: self.availability_options,
            }
        }
    }
}
impl DescribeAvailabilityOptionsOutput {
    /// Creates a new builder-style object to manufacture [`DescribeAvailabilityOptionsOutput`](crate::output::DescribeAvailabilityOptionsOutput)
    pub fn builder() -> crate::output::describe_availability_options_output::Builder {
        crate::output::describe_availability_options_output::Builder::default()
    }
}

/// <p>The result of a <code>DescribeAnalysisSchemes</code> request. Contains the analysis schemes configured for the domain specified in the request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeAnalysisSchemesOutput {
    /// <p>The analysis scheme descriptions.</p>
    pub analysis_schemes: std::option::Option<std::vec::Vec<crate::model::AnalysisSchemeStatus>>,
}
impl DescribeAnalysisSchemesOutput {
    /// <p>The analysis scheme descriptions.</p>
    pub fn analysis_schemes(&self) -> std::option::Option<&[crate::model::AnalysisSchemeStatus]> {
        self.analysis_schemes.as_deref()
    }
}
impl std::fmt::Debug for DescribeAnalysisSchemesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeAnalysisSchemesOutput");
        formatter.field("analysis_schemes", &self.analysis_schemes);
        formatter.finish()
    }
}
/// See [`DescribeAnalysisSchemesOutput`](crate::output::DescribeAnalysisSchemesOutput)
pub mod describe_analysis_schemes_output {
    /// A builder for [`DescribeAnalysisSchemesOutput`](crate::output::DescribeAnalysisSchemesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) analysis_schemes:
            std::option::Option<std::vec::Vec<crate::model::AnalysisSchemeStatus>>,
    }
    impl Builder {
        /// Appends an item to `analysis_schemes`.
        ///
        /// To override the contents of this collection use [`set_analysis_schemes`](Self::set_analysis_schemes).
        ///
        /// <p>The analysis scheme descriptions.</p>
        pub fn analysis_schemes(mut self, input: crate::model::AnalysisSchemeStatus) -> Self {
            let mut v = self.analysis_schemes.unwrap_or_default();
            v.push(input);
            self.analysis_schemes = Some(v);
            self
        }
        /// <p>The analysis scheme descriptions.</p>
        pub fn set_analysis_schemes(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AnalysisSchemeStatus>>,
        ) -> Self {
            self.analysis_schemes = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeAnalysisSchemesOutput`](crate::output::DescribeAnalysisSchemesOutput)
        pub fn build(self) -> crate::output::DescribeAnalysisSchemesOutput {
            crate::output::DescribeAnalysisSchemesOutput {
                analysis_schemes: self.analysis_schemes,
            }
        }
    }
}
impl DescribeAnalysisSchemesOutput {
    /// Creates a new builder-style object to manufacture [`DescribeAnalysisSchemesOutput`](crate::output::DescribeAnalysisSchemesOutput)
    pub fn builder() -> crate::output::describe_analysis_schemes_output::Builder {
        crate::output::describe_analysis_schemes_output::Builder::default()
    }
}

/// <p>The result of a <code>DeleteSuggester</code> request. Contains the status of the deleted suggester.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteSuggesterOutput {
    /// <p>The status of the suggester being deleted.</p>
    pub suggester: std::option::Option<crate::model::SuggesterStatus>,
}
impl DeleteSuggesterOutput {
    /// <p>The status of the suggester being deleted.</p>
    pub fn suggester(&self) -> std::option::Option<&crate::model::SuggesterStatus> {
        self.suggester.as_ref()
    }
}
impl std::fmt::Debug for DeleteSuggesterOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteSuggesterOutput");
        formatter.field("suggester", &self.suggester);
        formatter.finish()
    }
}
/// See [`DeleteSuggesterOutput`](crate::output::DeleteSuggesterOutput)
pub mod delete_suggester_output {
    /// A builder for [`DeleteSuggesterOutput`](crate::output::DeleteSuggesterOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) suggester: std::option::Option<crate::model::SuggesterStatus>,
    }
    impl Builder {
        /// <p>The status of the suggester being deleted.</p>
        pub fn suggester(mut self, input: crate::model::SuggesterStatus) -> Self {
            self.suggester = Some(input);
            self
        }
        /// <p>The status of the suggester being deleted.</p>
        pub fn set_suggester(
            mut self,
            input: std::option::Option<crate::model::SuggesterStatus>,
        ) -> Self {
            self.suggester = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteSuggesterOutput`](crate::output::DeleteSuggesterOutput)
        pub fn build(self) -> crate::output::DeleteSuggesterOutput {
            crate::output::DeleteSuggesterOutput {
                suggester: self.suggester,
            }
        }
    }
}
impl DeleteSuggesterOutput {
    /// Creates a new builder-style object to manufacture [`DeleteSuggesterOutput`](crate::output::DeleteSuggesterOutput)
    pub fn builder() -> crate::output::delete_suggester_output::Builder {
        crate::output::delete_suggester_output::Builder::default()
    }
}

/// <p>The result of a <code><code>DeleteIndexField</code></code> request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteIndexFieldOutput {
    /// <p>The status of the index field being deleted.</p>
    pub index_field: std::option::Option<crate::model::IndexFieldStatus>,
}
impl DeleteIndexFieldOutput {
    /// <p>The status of the index field being deleted.</p>
    pub fn index_field(&self) -> std::option::Option<&crate::model::IndexFieldStatus> {
        self.index_field.as_ref()
    }
}
impl std::fmt::Debug for DeleteIndexFieldOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteIndexFieldOutput");
        formatter.field("index_field", &self.index_field);
        formatter.finish()
    }
}
/// See [`DeleteIndexFieldOutput`](crate::output::DeleteIndexFieldOutput)
pub mod delete_index_field_output {
    /// A builder for [`DeleteIndexFieldOutput`](crate::output::DeleteIndexFieldOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) index_field: std::option::Option<crate::model::IndexFieldStatus>,
    }
    impl Builder {
        /// <p>The status of the index field being deleted.</p>
        pub fn index_field(mut self, input: crate::model::IndexFieldStatus) -> Self {
            self.index_field = Some(input);
            self
        }
        /// <p>The status of the index field being deleted.</p>
        pub fn set_index_field(
            mut self,
            input: std::option::Option<crate::model::IndexFieldStatus>,
        ) -> Self {
            self.index_field = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteIndexFieldOutput`](crate::output::DeleteIndexFieldOutput)
        pub fn build(self) -> crate::output::DeleteIndexFieldOutput {
            crate::output::DeleteIndexFieldOutput {
                index_field: self.index_field,
            }
        }
    }
}
impl DeleteIndexFieldOutput {
    /// Creates a new builder-style object to manufacture [`DeleteIndexFieldOutput`](crate::output::DeleteIndexFieldOutput)
    pub fn builder() -> crate::output::delete_index_field_output::Builder {
        crate::output::delete_index_field_output::Builder::default()
    }
}

/// <p>The result of a <code><code>DeleteExpression</code></code> request. Specifies the expression being deleted.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteExpressionOutput {
    /// <p>The status of the expression being deleted.</p>
    pub expression: std::option::Option<crate::model::ExpressionStatus>,
}
impl DeleteExpressionOutput {
    /// <p>The status of the expression being deleted.</p>
    pub fn expression(&self) -> std::option::Option<&crate::model::ExpressionStatus> {
        self.expression.as_ref()
    }
}
impl std::fmt::Debug for DeleteExpressionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteExpressionOutput");
        formatter.field("expression", &self.expression);
        formatter.finish()
    }
}
/// See [`DeleteExpressionOutput`](crate::output::DeleteExpressionOutput)
pub mod delete_expression_output {
    /// A builder for [`DeleteExpressionOutput`](crate::output::DeleteExpressionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) expression: std::option::Option<crate::model::ExpressionStatus>,
    }
    impl Builder {
        /// <p>The status of the expression being deleted.</p>
        pub fn expression(mut self, input: crate::model::ExpressionStatus) -> Self {
            self.expression = Some(input);
            self
        }
        /// <p>The status of the expression being deleted.</p>
        pub fn set_expression(
            mut self,
            input: std::option::Option<crate::model::ExpressionStatus>,
        ) -> Self {
            self.expression = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteExpressionOutput`](crate::output::DeleteExpressionOutput)
        pub fn build(self) -> crate::output::DeleteExpressionOutput {
            crate::output::DeleteExpressionOutput {
                expression: self.expression,
            }
        }
    }
}
impl DeleteExpressionOutput {
    /// Creates a new builder-style object to manufacture [`DeleteExpressionOutput`](crate::output::DeleteExpressionOutput)
    pub fn builder() -> crate::output::delete_expression_output::Builder {
        crate::output::delete_expression_output::Builder::default()
    }
}

/// <p>The result of a <code>DeleteDomain</code> request. Contains the status of a newly deleted domain, or no status if the domain has already been completely deleted.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteDomainOutput {
    /// <p>The current status of the search domain.</p>
    pub domain_status: std::option::Option<crate::model::DomainStatus>,
}
impl DeleteDomainOutput {
    /// <p>The current status of the search domain.</p>
    pub fn domain_status(&self) -> std::option::Option<&crate::model::DomainStatus> {
        self.domain_status.as_ref()
    }
}
impl std::fmt::Debug for DeleteDomainOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteDomainOutput");
        formatter.field("domain_status", &self.domain_status);
        formatter.finish()
    }
}
/// See [`DeleteDomainOutput`](crate::output::DeleteDomainOutput)
pub mod delete_domain_output {
    /// A builder for [`DeleteDomainOutput`](crate::output::DeleteDomainOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) domain_status: std::option::Option<crate::model::DomainStatus>,
    }
    impl Builder {
        /// <p>The current status of the search domain.</p>
        pub fn domain_status(mut self, input: crate::model::DomainStatus) -> Self {
            self.domain_status = Some(input);
            self
        }
        /// <p>The current status of the search domain.</p>
        pub fn set_domain_status(
            mut self,
            input: std::option::Option<crate::model::DomainStatus>,
        ) -> Self {
            self.domain_status = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteDomainOutput`](crate::output::DeleteDomainOutput)
        pub fn build(self) -> crate::output::DeleteDomainOutput {
            crate::output::DeleteDomainOutput {
                domain_status: self.domain_status,
            }
        }
    }
}
impl DeleteDomainOutput {
    /// Creates a new builder-style object to manufacture [`DeleteDomainOutput`](crate::output::DeleteDomainOutput)
    pub fn builder() -> crate::output::delete_domain_output::Builder {
        crate::output::delete_domain_output::Builder::default()
    }
}

/// <p>The result of a <code>DeleteAnalysisScheme</code> request. Contains the status of the deleted analysis scheme.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteAnalysisSchemeOutput {
    /// <p>The status of the analysis scheme being deleted.</p>
    pub analysis_scheme: std::option::Option<crate::model::AnalysisSchemeStatus>,
}
impl DeleteAnalysisSchemeOutput {
    /// <p>The status of the analysis scheme being deleted.</p>
    pub fn analysis_scheme(&self) -> std::option::Option<&crate::model::AnalysisSchemeStatus> {
        self.analysis_scheme.as_ref()
    }
}
impl std::fmt::Debug for DeleteAnalysisSchemeOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteAnalysisSchemeOutput");
        formatter.field("analysis_scheme", &self.analysis_scheme);
        formatter.finish()
    }
}
/// See [`DeleteAnalysisSchemeOutput`](crate::output::DeleteAnalysisSchemeOutput)
pub mod delete_analysis_scheme_output {
    /// A builder for [`DeleteAnalysisSchemeOutput`](crate::output::DeleteAnalysisSchemeOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) analysis_scheme: std::option::Option<crate::model::AnalysisSchemeStatus>,
    }
    impl Builder {
        /// <p>The status of the analysis scheme being deleted.</p>
        pub fn analysis_scheme(mut self, input: crate::model::AnalysisSchemeStatus) -> Self {
            self.analysis_scheme = Some(input);
            self
        }
        /// <p>The status of the analysis scheme being deleted.</p>
        pub fn set_analysis_scheme(
            mut self,
            input: std::option::Option<crate::model::AnalysisSchemeStatus>,
        ) -> Self {
            self.analysis_scheme = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteAnalysisSchemeOutput`](crate::output::DeleteAnalysisSchemeOutput)
        pub fn build(self) -> crate::output::DeleteAnalysisSchemeOutput {
            crate::output::DeleteAnalysisSchemeOutput {
                analysis_scheme: self.analysis_scheme,
            }
        }
    }
}
impl DeleteAnalysisSchemeOutput {
    /// Creates a new builder-style object to manufacture [`DeleteAnalysisSchemeOutput`](crate::output::DeleteAnalysisSchemeOutput)
    pub fn builder() -> crate::output::delete_analysis_scheme_output::Builder {
        crate::output::delete_analysis_scheme_output::Builder::default()
    }
}

/// <p>The result of a <code>DefineSuggester</code> request. Contains the status of the newly-configured suggester.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DefineSuggesterOutput {
    /// <p>The value of a <code>Suggester</code> and its current status.</p>
    pub suggester: std::option::Option<crate::model::SuggesterStatus>,
}
impl DefineSuggesterOutput {
    /// <p>The value of a <code>Suggester</code> and its current status.</p>
    pub fn suggester(&self) -> std::option::Option<&crate::model::SuggesterStatus> {
        self.suggester.as_ref()
    }
}
impl std::fmt::Debug for DefineSuggesterOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DefineSuggesterOutput");
        formatter.field("suggester", &self.suggester);
        formatter.finish()
    }
}
/// See [`DefineSuggesterOutput`](crate::output::DefineSuggesterOutput)
pub mod define_suggester_output {
    /// A builder for [`DefineSuggesterOutput`](crate::output::DefineSuggesterOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) suggester: std::option::Option<crate::model::SuggesterStatus>,
    }
    impl Builder {
        /// <p>The value of a <code>Suggester</code> and its current status.</p>
        pub fn suggester(mut self, input: crate::model::SuggesterStatus) -> Self {
            self.suggester = Some(input);
            self
        }
        /// <p>The value of a <code>Suggester</code> and its current status.</p>
        pub fn set_suggester(
            mut self,
            input: std::option::Option<crate::model::SuggesterStatus>,
        ) -> Self {
            self.suggester = input;
            self
        }
        /// Consumes the builder and constructs a [`DefineSuggesterOutput`](crate::output::DefineSuggesterOutput)
        pub fn build(self) -> crate::output::DefineSuggesterOutput {
            crate::output::DefineSuggesterOutput {
                suggester: self.suggester,
            }
        }
    }
}
impl DefineSuggesterOutput {
    /// Creates a new builder-style object to manufacture [`DefineSuggesterOutput`](crate::output::DefineSuggesterOutput)
    pub fn builder() -> crate::output::define_suggester_output::Builder {
        crate::output::define_suggester_output::Builder::default()
    }
}

/// <p>The result of a <code><code>DefineIndexField</code></code> request. Contains the status of the newly-configured index field.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DefineIndexFieldOutput {
    /// <p>The value of an <code>IndexField</code> and its current status.</p>
    pub index_field: std::option::Option<crate::model::IndexFieldStatus>,
}
impl DefineIndexFieldOutput {
    /// <p>The value of an <code>IndexField</code> and its current status.</p>
    pub fn index_field(&self) -> std::option::Option<&crate::model::IndexFieldStatus> {
        self.index_field.as_ref()
    }
}
impl std::fmt::Debug for DefineIndexFieldOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DefineIndexFieldOutput");
        formatter.field("index_field", &self.index_field);
        formatter.finish()
    }
}
/// See [`DefineIndexFieldOutput`](crate::output::DefineIndexFieldOutput)
pub mod define_index_field_output {
    /// A builder for [`DefineIndexFieldOutput`](crate::output::DefineIndexFieldOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) index_field: std::option::Option<crate::model::IndexFieldStatus>,
    }
    impl Builder {
        /// <p>The value of an <code>IndexField</code> and its current status.</p>
        pub fn index_field(mut self, input: crate::model::IndexFieldStatus) -> Self {
            self.index_field = Some(input);
            self
        }
        /// <p>The value of an <code>IndexField</code> and its current status.</p>
        pub fn set_index_field(
            mut self,
            input: std::option::Option<crate::model::IndexFieldStatus>,
        ) -> Self {
            self.index_field = input;
            self
        }
        /// Consumes the builder and constructs a [`DefineIndexFieldOutput`](crate::output::DefineIndexFieldOutput)
        pub fn build(self) -> crate::output::DefineIndexFieldOutput {
            crate::output::DefineIndexFieldOutput {
                index_field: self.index_field,
            }
        }
    }
}
impl DefineIndexFieldOutput {
    /// Creates a new builder-style object to manufacture [`DefineIndexFieldOutput`](crate::output::DefineIndexFieldOutput)
    pub fn builder() -> crate::output::define_index_field_output::Builder {
        crate::output::define_index_field_output::Builder::default()
    }
}

/// <p>The result of a <code>DefineExpression</code> request. Contains the status of the newly-configured expression.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DefineExpressionOutput {
    /// <p>The value of an <code>Expression</code> and its current status.</p>
    pub expression: std::option::Option<crate::model::ExpressionStatus>,
}
impl DefineExpressionOutput {
    /// <p>The value of an <code>Expression</code> and its current status.</p>
    pub fn expression(&self) -> std::option::Option<&crate::model::ExpressionStatus> {
        self.expression.as_ref()
    }
}
impl std::fmt::Debug for DefineExpressionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DefineExpressionOutput");
        formatter.field("expression", &self.expression);
        formatter.finish()
    }
}
/// See [`DefineExpressionOutput`](crate::output::DefineExpressionOutput)
pub mod define_expression_output {
    /// A builder for [`DefineExpressionOutput`](crate::output::DefineExpressionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) expression: std::option::Option<crate::model::ExpressionStatus>,
    }
    impl Builder {
        /// <p>The value of an <code>Expression</code> and its current status.</p>
        pub fn expression(mut self, input: crate::model::ExpressionStatus) -> Self {
            self.expression = Some(input);
            self
        }
        /// <p>The value of an <code>Expression</code> and its current status.</p>
        pub fn set_expression(
            mut self,
            input: std::option::Option<crate::model::ExpressionStatus>,
        ) -> Self {
            self.expression = input;
            self
        }
        /// Consumes the builder and constructs a [`DefineExpressionOutput`](crate::output::DefineExpressionOutput)
        pub fn build(self) -> crate::output::DefineExpressionOutput {
            crate::output::DefineExpressionOutput {
                expression: self.expression,
            }
        }
    }
}
impl DefineExpressionOutput {
    /// Creates a new builder-style object to manufacture [`DefineExpressionOutput`](crate::output::DefineExpressionOutput)
    pub fn builder() -> crate::output::define_expression_output::Builder {
        crate::output::define_expression_output::Builder::default()
    }
}

/// <p>The result of a <code><code>DefineAnalysisScheme</code></code> request. Contains the status of the newly-configured analysis scheme.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DefineAnalysisSchemeOutput {
    /// <p>The status and configuration of an <code>AnalysisScheme</code>.</p>
    pub analysis_scheme: std::option::Option<crate::model::AnalysisSchemeStatus>,
}
impl DefineAnalysisSchemeOutput {
    /// <p>The status and configuration of an <code>AnalysisScheme</code>.</p>
    pub fn analysis_scheme(&self) -> std::option::Option<&crate::model::AnalysisSchemeStatus> {
        self.analysis_scheme.as_ref()
    }
}
impl std::fmt::Debug for DefineAnalysisSchemeOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DefineAnalysisSchemeOutput");
        formatter.field("analysis_scheme", &self.analysis_scheme);
        formatter.finish()
    }
}
/// See [`DefineAnalysisSchemeOutput`](crate::output::DefineAnalysisSchemeOutput)
pub mod define_analysis_scheme_output {
    /// A builder for [`DefineAnalysisSchemeOutput`](crate::output::DefineAnalysisSchemeOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) analysis_scheme: std::option::Option<crate::model::AnalysisSchemeStatus>,
    }
    impl Builder {
        /// <p>The status and configuration of an <code>AnalysisScheme</code>.</p>
        pub fn analysis_scheme(mut self, input: crate::model::AnalysisSchemeStatus) -> Self {
            self.analysis_scheme = Some(input);
            self
        }
        /// <p>The status and configuration of an <code>AnalysisScheme</code>.</p>
        pub fn set_analysis_scheme(
            mut self,
            input: std::option::Option<crate::model::AnalysisSchemeStatus>,
        ) -> Self {
            self.analysis_scheme = input;
            self
        }
        /// Consumes the builder and constructs a [`DefineAnalysisSchemeOutput`](crate::output::DefineAnalysisSchemeOutput)
        pub fn build(self) -> crate::output::DefineAnalysisSchemeOutput {
            crate::output::DefineAnalysisSchemeOutput {
                analysis_scheme: self.analysis_scheme,
            }
        }
    }
}
impl DefineAnalysisSchemeOutput {
    /// Creates a new builder-style object to manufacture [`DefineAnalysisSchemeOutput`](crate::output::DefineAnalysisSchemeOutput)
    pub fn builder() -> crate::output::define_analysis_scheme_output::Builder {
        crate::output::define_analysis_scheme_output::Builder::default()
    }
}

/// <p>The result of a <code>CreateDomainRequest</code>. Contains the status of a newly created domain.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateDomainOutput {
    /// <p>The current status of the search domain.</p>
    pub domain_status: std::option::Option<crate::model::DomainStatus>,
}
impl CreateDomainOutput {
    /// <p>The current status of the search domain.</p>
    pub fn domain_status(&self) -> std::option::Option<&crate::model::DomainStatus> {
        self.domain_status.as_ref()
    }
}
impl std::fmt::Debug for CreateDomainOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateDomainOutput");
        formatter.field("domain_status", &self.domain_status);
        formatter.finish()
    }
}
/// See [`CreateDomainOutput`](crate::output::CreateDomainOutput)
pub mod create_domain_output {
    /// A builder for [`CreateDomainOutput`](crate::output::CreateDomainOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) domain_status: std::option::Option<crate::model::DomainStatus>,
    }
    impl Builder {
        /// <p>The current status of the search domain.</p>
        pub fn domain_status(mut self, input: crate::model::DomainStatus) -> Self {
            self.domain_status = Some(input);
            self
        }
        /// <p>The current status of the search domain.</p>
        pub fn set_domain_status(
            mut self,
            input: std::option::Option<crate::model::DomainStatus>,
        ) -> Self {
            self.domain_status = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateDomainOutput`](crate::output::CreateDomainOutput)
        pub fn build(self) -> crate::output::CreateDomainOutput {
            crate::output::CreateDomainOutput {
                domain_status: self.domain_status,
            }
        }
    }
}
impl CreateDomainOutput {
    /// Creates a new builder-style object to manufacture [`CreateDomainOutput`](crate::output::CreateDomainOutput)
    pub fn builder() -> crate::output::create_domain_output::Builder {
        crate::output::create_domain_output::Builder::default()
    }
}

/// <p>The result of a <code>BuildSuggester</code> request. Contains a list of the fields used for suggestions.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BuildSuggestersOutput {
    /// <p>A list of field names.</p>
    pub field_names: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl BuildSuggestersOutput {
    /// <p>A list of field names.</p>
    pub fn field_names(&self) -> std::option::Option<&[std::string::String]> {
        self.field_names.as_deref()
    }
}
impl std::fmt::Debug for BuildSuggestersOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BuildSuggestersOutput");
        formatter.field("field_names", &self.field_names);
        formatter.finish()
    }
}
/// See [`BuildSuggestersOutput`](crate::output::BuildSuggestersOutput)
pub mod build_suggesters_output {
    /// A builder for [`BuildSuggestersOutput`](crate::output::BuildSuggestersOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) field_names: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// Appends an item to `field_names`.
        ///
        /// To override the contents of this collection use [`set_field_names`](Self::set_field_names).
        ///
        /// <p>A list of field names.</p>
        pub fn field_names(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.field_names.unwrap_or_default();
            v.push(input.into());
            self.field_names = Some(v);
            self
        }
        /// <p>A list of field names.</p>
        pub fn set_field_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.field_names = input;
            self
        }
        /// Consumes the builder and constructs a [`BuildSuggestersOutput`](crate::output::BuildSuggestersOutput)
        pub fn build(self) -> crate::output::BuildSuggestersOutput {
            crate::output::BuildSuggestersOutput {
                field_names: self.field_names,
            }
        }
    }
}
impl BuildSuggestersOutput {
    /// Creates a new builder-style object to manufacture [`BuildSuggestersOutput`](crate::output::BuildSuggestersOutput)
    pub fn builder() -> crate::output::build_suggesters_output::Builder {
        crate::output::build_suggesters_output::Builder::default()
    }
}
