// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// <p>The configured access rules for the domain's document and search endpoints, and the current status of those rules.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AccessPoliciesStatus {
    /// <p>Access rules for a domain's document or search service endpoints. For more information, see <a href="http://docs.aws.amazon.com/cloudsearch/latest/developerguide/configuring-access.html" target="_blank">Configuring Access for a Search Domain</a> in the <i>Amazon CloudSearch Developer Guide</i>. The maximum size of a policy document is 100 KB.</p>
    pub options: std::option::Option<std::string::String>,
    /// <p>The status of domain configuration option.</p>
    pub status: std::option::Option<crate::model::OptionStatus>,
}
impl AccessPoliciesStatus {
    /// <p>Access rules for a domain's document or search service endpoints. For more information, see <a href="http://docs.aws.amazon.com/cloudsearch/latest/developerguide/configuring-access.html" target="_blank">Configuring Access for a Search Domain</a> in the <i>Amazon CloudSearch Developer Guide</i>. The maximum size of a policy document is 100 KB.</p>
    pub fn options(&self) -> std::option::Option<&str> {
        self.options.as_deref()
    }
    /// <p>The status of domain configuration option.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::OptionStatus> {
        self.status.as_ref()
    }
}
impl std::fmt::Debug for AccessPoliciesStatus {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AccessPoliciesStatus");
        formatter.field("options", &self.options);
        formatter.field("status", &self.status);
        formatter.finish()
    }
}
/// See [`AccessPoliciesStatus`](crate::model::AccessPoliciesStatus)
pub mod access_policies_status {
    /// A builder for [`AccessPoliciesStatus`](crate::model::AccessPoliciesStatus)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) options: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::OptionStatus>,
    }
    impl Builder {
        /// <p>Access rules for a domain's document or search service endpoints. For more information, see <a href="http://docs.aws.amazon.com/cloudsearch/latest/developerguide/configuring-access.html" target="_blank">Configuring Access for a Search Domain</a> in the <i>Amazon CloudSearch Developer Guide</i>. The maximum size of a policy document is 100 KB.</p>
        pub fn options(mut self, input: impl Into<std::string::String>) -> Self {
            self.options = Some(input.into());
            self
        }
        /// <p>Access rules for a domain's document or search service endpoints. For more information, see <a href="http://docs.aws.amazon.com/cloudsearch/latest/developerguide/configuring-access.html" target="_blank">Configuring Access for a Search Domain</a> in the <i>Amazon CloudSearch Developer Guide</i>. The maximum size of a policy document is 100 KB.</p>
        pub fn set_options(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.options = input;
            self
        }
        /// <p>The status of domain configuration option.</p>
        pub fn status(mut self, input: crate::model::OptionStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of domain configuration option.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::OptionStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`AccessPoliciesStatus`](crate::model::AccessPoliciesStatus)
        pub fn build(self) -> crate::model::AccessPoliciesStatus {
            crate::model::AccessPoliciesStatus {
                options: self.options,
                status: self.status,
            }
        }
    }
}
impl AccessPoliciesStatus {
    /// Creates a new builder-style object to manufacture [`AccessPoliciesStatus`](crate::model::AccessPoliciesStatus)
    pub fn builder() -> crate::model::access_policies_status::Builder {
        crate::model::access_policies_status::Builder::default()
    }
}

/// <p>The status of domain configuration option.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct OptionStatus {
    /// <p>A timestamp for when this option was created.</p>
    pub creation_date: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>A timestamp for when this option was last updated.</p>
    pub update_date: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>A unique integer that indicates when this option was last updated.</p>
    pub update_version: i32,
    /// <p>The state of processing a change to an option.  Possible values:</p><ul>
    /// <li><code>RequiresIndexDocuments</code>: the option's latest value will not be deployed until  <a>IndexDocuments</a> has been called and indexing is complete.</li>
    /// <li><code>Processing</code>: the option's latest value is in the process of being activated.  </li>
    /// <li><code>Active</code>: the option's latest value is completely deployed.</li>
    /// <li><code>FailedToValidate</code>: the option value is not compatible with the domain's data and cannot be used to index the data. You must either modify the option value or update or remove the incompatible documents.</li>
    /// </ul>
    pub state: std::option::Option<crate::model::OptionState>,
    /// <p>Indicates that the option will be deleted once processing is complete.</p>
    pub pending_deletion: std::option::Option<bool>,
}
impl OptionStatus {
    /// <p>A timestamp for when this option was created.</p>
    pub fn creation_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.creation_date.as_ref()
    }
    /// <p>A timestamp for when this option was last updated.</p>
    pub fn update_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.update_date.as_ref()
    }
    /// <p>A unique integer that indicates when this option was last updated.</p>
    pub fn update_version(&self) -> i32 {
        self.update_version
    }
    /// <p>The state of processing a change to an option.  Possible values:</p><ul>
    /// <li><code>RequiresIndexDocuments</code>: the option's latest value will not be deployed until  <a>IndexDocuments</a> has been called and indexing is complete.</li>
    /// <li><code>Processing</code>: the option's latest value is in the process of being activated.  </li>
    /// <li><code>Active</code>: the option's latest value is completely deployed.</li>
    /// <li><code>FailedToValidate</code>: the option value is not compatible with the domain's data and cannot be used to index the data. You must either modify the option value or update or remove the incompatible documents.</li>
    /// </ul>
    pub fn state(&self) -> std::option::Option<&crate::model::OptionState> {
        self.state.as_ref()
    }
    /// <p>Indicates that the option will be deleted once processing is complete.</p>
    pub fn pending_deletion(&self) -> std::option::Option<bool> {
        self.pending_deletion
    }
}
impl std::fmt::Debug for OptionStatus {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("OptionStatus");
        formatter.field("creation_date", &self.creation_date);
        formatter.field("update_date", &self.update_date);
        formatter.field("update_version", &self.update_version);
        formatter.field("state", &self.state);
        formatter.field("pending_deletion", &self.pending_deletion);
        formatter.finish()
    }
}
/// See [`OptionStatus`](crate::model::OptionStatus)
pub mod option_status {
    /// A builder for [`OptionStatus`](crate::model::OptionStatus)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) creation_date: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) update_date: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) update_version: std::option::Option<i32>,
        pub(crate) state: std::option::Option<crate::model::OptionState>,
        pub(crate) pending_deletion: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>A timestamp for when this option was created.</p>
        pub fn creation_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.creation_date = Some(input);
            self
        }
        /// <p>A timestamp for when this option was created.</p>
        pub fn set_creation_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.creation_date = input;
            self
        }
        /// <p>A timestamp for when this option was last updated.</p>
        pub fn update_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.update_date = Some(input);
            self
        }
        /// <p>A timestamp for when this option was last updated.</p>
        pub fn set_update_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.update_date = input;
            self
        }
        /// <p>A unique integer that indicates when this option was last updated.</p>
        pub fn update_version(mut self, input: i32) -> Self {
            self.update_version = Some(input);
            self
        }
        /// <p>A unique integer that indicates when this option was last updated.</p>
        pub fn set_update_version(mut self, input: std::option::Option<i32>) -> Self {
            self.update_version = input;
            self
        }
        /// <p>The state of processing a change to an option.  Possible values:</p><ul>
        /// <li><code>RequiresIndexDocuments</code>: the option's latest value will not be deployed until  <a>IndexDocuments</a> has been called and indexing is complete.</li>
        /// <li><code>Processing</code>: the option's latest value is in the process of being activated.  </li>
        /// <li><code>Active</code>: the option's latest value is completely deployed.</li>
        /// <li><code>FailedToValidate</code>: the option value is not compatible with the domain's data and cannot be used to index the data. You must either modify the option value or update or remove the incompatible documents.</li>
        /// </ul>
        pub fn state(mut self, input: crate::model::OptionState) -> Self {
            self.state = Some(input);
            self
        }
        /// <p>The state of processing a change to an option.  Possible values:</p><ul>
        /// <li><code>RequiresIndexDocuments</code>: the option's latest value will not be deployed until  <a>IndexDocuments</a> has been called and indexing is complete.</li>
        /// <li><code>Processing</code>: the option's latest value is in the process of being activated.  </li>
        /// <li><code>Active</code>: the option's latest value is completely deployed.</li>
        /// <li><code>FailedToValidate</code>: the option value is not compatible with the domain's data and cannot be used to index the data. You must either modify the option value or update or remove the incompatible documents.</li>
        /// </ul>
        pub fn set_state(mut self, input: std::option::Option<crate::model::OptionState>) -> Self {
            self.state = input;
            self
        }
        /// <p>Indicates that the option will be deleted once processing is complete.</p>
        pub fn pending_deletion(mut self, input: bool) -> Self {
            self.pending_deletion = Some(input);
            self
        }
        /// <p>Indicates that the option will be deleted once processing is complete.</p>
        pub fn set_pending_deletion(mut self, input: std::option::Option<bool>) -> Self {
            self.pending_deletion = input;
            self
        }
        /// Consumes the builder and constructs a [`OptionStatus`](crate::model::OptionStatus)
        pub fn build(self) -> crate::model::OptionStatus {
            crate::model::OptionStatus {
                creation_date: self.creation_date,
                update_date: self.update_date,
                update_version: self.update_version.unwrap_or_default(),
                state: self.state,
                pending_deletion: self.pending_deletion,
            }
        }
    }
}
impl OptionStatus {
    /// Creates a new builder-style object to manufacture [`OptionStatus`](crate::model::OptionStatus)
    pub fn builder() -> crate::model::option_status::Builder {
        crate::model::option_status::Builder::default()
    }
}

/// <p>The state of processing a change to an option. One of:</p>
/// <ul>
/// <li>RequiresIndexDocuments: The option's latest value will not be deployed until  <a>IndexDocuments</a> has been called and indexing is complete.</li>
/// <li>Processing: The option's latest value is in the process of being activated.</li>
/// <li>Active: The option's latest value is fully deployed. </li>
/// <li>FailedToValidate: The option value is not compatible with the domain's data and cannot be used to index the data. You must either modify the option value or update or remove the incompatible documents.</li>
/// </ul>
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum OptionState {
    #[allow(missing_docs)] // documentation missing in model
    Active,
    #[allow(missing_docs)] // documentation missing in model
    FailedToValidate,
    #[allow(missing_docs)] // documentation missing in model
    Processing,
    #[allow(missing_docs)] // documentation missing in model
    RequiresIndexDocuments,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for OptionState {
    fn from(s: &str) -> Self {
        match s {
            "Active" => OptionState::Active,
            "FailedToValidate" => OptionState::FailedToValidate,
            "Processing" => OptionState::Processing,
            "RequiresIndexDocuments" => OptionState::RequiresIndexDocuments,
            other => OptionState::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for OptionState {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(OptionState::from(s))
    }
}
impl OptionState {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            OptionState::Active => "Active",
            OptionState::FailedToValidate => "FailedToValidate",
            OptionState::Processing => "Processing",
            OptionState::RequiresIndexDocuments => "RequiresIndexDocuments",
            OptionState::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "Active",
            "FailedToValidate",
            "Processing",
            "RequiresIndexDocuments",
        ]
    }
}
impl AsRef<str> for OptionState {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The status and configuration of a search domain's scaling parameters. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ScalingParametersStatus {
    /// <p>The desired instance type and desired number of replicas of each index partition.</p>
    pub options: std::option::Option<crate::model::ScalingParameters>,
    /// <p>The status of domain configuration option.</p>
    pub status: std::option::Option<crate::model::OptionStatus>,
}
impl ScalingParametersStatus {
    /// <p>The desired instance type and desired number of replicas of each index partition.</p>
    pub fn options(&self) -> std::option::Option<&crate::model::ScalingParameters> {
        self.options.as_ref()
    }
    /// <p>The status of domain configuration option.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::OptionStatus> {
        self.status.as_ref()
    }
}
impl std::fmt::Debug for ScalingParametersStatus {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ScalingParametersStatus");
        formatter.field("options", &self.options);
        formatter.field("status", &self.status);
        formatter.finish()
    }
}
/// See [`ScalingParametersStatus`](crate::model::ScalingParametersStatus)
pub mod scaling_parameters_status {
    /// A builder for [`ScalingParametersStatus`](crate::model::ScalingParametersStatus)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) options: std::option::Option<crate::model::ScalingParameters>,
        pub(crate) status: std::option::Option<crate::model::OptionStatus>,
    }
    impl Builder {
        /// <p>The desired instance type and desired number of replicas of each index partition.</p>
        pub fn options(mut self, input: crate::model::ScalingParameters) -> Self {
            self.options = Some(input);
            self
        }
        /// <p>The desired instance type and desired number of replicas of each index partition.</p>
        pub fn set_options(
            mut self,
            input: std::option::Option<crate::model::ScalingParameters>,
        ) -> Self {
            self.options = input;
            self
        }
        /// <p>The status of domain configuration option.</p>
        pub fn status(mut self, input: crate::model::OptionStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of domain configuration option.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::OptionStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`ScalingParametersStatus`](crate::model::ScalingParametersStatus)
        pub fn build(self) -> crate::model::ScalingParametersStatus {
            crate::model::ScalingParametersStatus {
                options: self.options,
                status: self.status,
            }
        }
    }
}
impl ScalingParametersStatus {
    /// Creates a new builder-style object to manufacture [`ScalingParametersStatus`](crate::model::ScalingParametersStatus)
    pub fn builder() -> crate::model::scaling_parameters_status::Builder {
        crate::model::scaling_parameters_status::Builder::default()
    }
}

/// <p>The desired instance type and desired number of replicas of each index partition.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ScalingParameters {
    /// <p>The instance type that you want to preconfigure for your domain. For example, <code>search.m1.small</code>.</p>
    pub desired_instance_type: std::option::Option<crate::model::PartitionInstanceType>,
    /// <p>The number of replicas you want to preconfigure for each index partition.</p>
    pub desired_replication_count: i32,
    /// <p>The number of partitions you want to preconfigure for your domain. Only valid when
    /// you select <code>m2.2xlarge</code> as the desired instance type.</p>
    pub desired_partition_count: i32,
}
impl ScalingParameters {
    /// <p>The instance type that you want to preconfigure for your domain. For example, <code>search.m1.small</code>.</p>
    pub fn desired_instance_type(
        &self,
    ) -> std::option::Option<&crate::model::PartitionInstanceType> {
        self.desired_instance_type.as_ref()
    }
    /// <p>The number of replicas you want to preconfigure for each index partition.</p>
    pub fn desired_replication_count(&self) -> i32 {
        self.desired_replication_count
    }
    /// <p>The number of partitions you want to preconfigure for your domain. Only valid when
    /// you select <code>m2.2xlarge</code> as the desired instance type.</p>
    pub fn desired_partition_count(&self) -> i32 {
        self.desired_partition_count
    }
}
impl std::fmt::Debug for ScalingParameters {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ScalingParameters");
        formatter.field("desired_instance_type", &self.desired_instance_type);
        formatter.field("desired_replication_count", &self.desired_replication_count);
        formatter.field("desired_partition_count", &self.desired_partition_count);
        formatter.finish()
    }
}
/// See [`ScalingParameters`](crate::model::ScalingParameters)
pub mod scaling_parameters {
    /// A builder for [`ScalingParameters`](crate::model::ScalingParameters)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) desired_instance_type: std::option::Option<crate::model::PartitionInstanceType>,
        pub(crate) desired_replication_count: std::option::Option<i32>,
        pub(crate) desired_partition_count: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The instance type that you want to preconfigure for your domain. For example, <code>search.m1.small</code>.</p>
        pub fn desired_instance_type(mut self, input: crate::model::PartitionInstanceType) -> Self {
            self.desired_instance_type = Some(input);
            self
        }
        /// <p>The instance type that you want to preconfigure for your domain. For example, <code>search.m1.small</code>.</p>
        pub fn set_desired_instance_type(
            mut self,
            input: std::option::Option<crate::model::PartitionInstanceType>,
        ) -> Self {
            self.desired_instance_type = input;
            self
        }
        /// <p>The number of replicas you want to preconfigure for each index partition.</p>
        pub fn desired_replication_count(mut self, input: i32) -> Self {
            self.desired_replication_count = Some(input);
            self
        }
        /// <p>The number of replicas you want to preconfigure for each index partition.</p>
        pub fn set_desired_replication_count(mut self, input: std::option::Option<i32>) -> Self {
            self.desired_replication_count = input;
            self
        }
        /// <p>The number of partitions you want to preconfigure for your domain. Only valid when
        /// you select <code>m2.2xlarge</code> as the desired instance type.</p>
        pub fn desired_partition_count(mut self, input: i32) -> Self {
            self.desired_partition_count = Some(input);
            self
        }
        /// <p>The number of partitions you want to preconfigure for your domain. Only valid when
        /// you select <code>m2.2xlarge</code> as the desired instance type.</p>
        pub fn set_desired_partition_count(mut self, input: std::option::Option<i32>) -> Self {
            self.desired_partition_count = input;
            self
        }
        /// Consumes the builder and constructs a [`ScalingParameters`](crate::model::ScalingParameters)
        pub fn build(self) -> crate::model::ScalingParameters {
            crate::model::ScalingParameters {
                desired_instance_type: self.desired_instance_type,
                desired_replication_count: self.desired_replication_count.unwrap_or_default(),
                desired_partition_count: self.desired_partition_count.unwrap_or_default(),
            }
        }
    }
}
impl ScalingParameters {
    /// Creates a new builder-style object to manufacture [`ScalingParameters`](crate::model::ScalingParameters)
    pub fn builder() -> crate::model::scaling_parameters::Builder {
        crate::model::scaling_parameters::Builder::default()
    }
}

/// <p>The instance type (such as <code>search.m1.small</code>) on which an index partition is hosted.</p>
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum PartitionInstanceType {
    #[allow(missing_docs)] // documentation missing in model
    Search2xlarge,
    #[allow(missing_docs)] // documentation missing in model
    SearchLarge,
    #[allow(missing_docs)] // documentation missing in model
    SearchM1Large,
    #[allow(missing_docs)] // documentation missing in model
    SearchM1Small,
    #[allow(missing_docs)] // documentation missing in model
    SearchM22xlarge,
    #[allow(missing_docs)] // documentation missing in model
    SearchM2Xlarge,
    #[allow(missing_docs)] // documentation missing in model
    SearchM32xlarge,
    #[allow(missing_docs)] // documentation missing in model
    SearchM3Large,
    #[allow(missing_docs)] // documentation missing in model
    SearchM3Medium,
    #[allow(missing_docs)] // documentation missing in model
    SearchM3Xlarge,
    #[allow(missing_docs)] // documentation missing in model
    SearchMedium,
    #[allow(missing_docs)] // documentation missing in model
    SearchPreviousgeneration2xlarge,
    #[allow(missing_docs)] // documentation missing in model
    SearchPreviousgenerationLarge,
    #[allow(missing_docs)] // documentation missing in model
    SearchPreviousgenerationSmall,
    #[allow(missing_docs)] // documentation missing in model
    SearchPreviousgenerationXlarge,
    #[allow(missing_docs)] // documentation missing in model
    SearchSmall,
    #[allow(missing_docs)] // documentation missing in model
    SearchXlarge,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for PartitionInstanceType {
    fn from(s: &str) -> Self {
        match s {
            "search.2xlarge" => PartitionInstanceType::Search2xlarge,
            "search.large" => PartitionInstanceType::SearchLarge,
            "search.m1.large" => PartitionInstanceType::SearchM1Large,
            "search.m1.small" => PartitionInstanceType::SearchM1Small,
            "search.m2.2xlarge" => PartitionInstanceType::SearchM22xlarge,
            "search.m2.xlarge" => PartitionInstanceType::SearchM2Xlarge,
            "search.m3.2xlarge" => PartitionInstanceType::SearchM32xlarge,
            "search.m3.large" => PartitionInstanceType::SearchM3Large,
            "search.m3.medium" => PartitionInstanceType::SearchM3Medium,
            "search.m3.xlarge" => PartitionInstanceType::SearchM3Xlarge,
            "search.medium" => PartitionInstanceType::SearchMedium,
            "search.previousgeneration.2xlarge" => {
                PartitionInstanceType::SearchPreviousgeneration2xlarge
            }
            "search.previousgeneration.large" => {
                PartitionInstanceType::SearchPreviousgenerationLarge
            }
            "search.previousgeneration.small" => {
                PartitionInstanceType::SearchPreviousgenerationSmall
            }
            "search.previousgeneration.xlarge" => {
                PartitionInstanceType::SearchPreviousgenerationXlarge
            }
            "search.small" => PartitionInstanceType::SearchSmall,
            "search.xlarge" => PartitionInstanceType::SearchXlarge,
            other => PartitionInstanceType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for PartitionInstanceType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(PartitionInstanceType::from(s))
    }
}
impl PartitionInstanceType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            PartitionInstanceType::Search2xlarge => "search.2xlarge",
            PartitionInstanceType::SearchLarge => "search.large",
            PartitionInstanceType::SearchM1Large => "search.m1.large",
            PartitionInstanceType::SearchM1Small => "search.m1.small",
            PartitionInstanceType::SearchM22xlarge => "search.m2.2xlarge",
            PartitionInstanceType::SearchM2Xlarge => "search.m2.xlarge",
            PartitionInstanceType::SearchM32xlarge => "search.m3.2xlarge",
            PartitionInstanceType::SearchM3Large => "search.m3.large",
            PartitionInstanceType::SearchM3Medium => "search.m3.medium",
            PartitionInstanceType::SearchM3Xlarge => "search.m3.xlarge",
            PartitionInstanceType::SearchMedium => "search.medium",
            PartitionInstanceType::SearchPreviousgeneration2xlarge => {
                "search.previousgeneration.2xlarge"
            }
            PartitionInstanceType::SearchPreviousgenerationLarge => {
                "search.previousgeneration.large"
            }
            PartitionInstanceType::SearchPreviousgenerationSmall => {
                "search.previousgeneration.small"
            }
            PartitionInstanceType::SearchPreviousgenerationXlarge => {
                "search.previousgeneration.xlarge"
            }
            PartitionInstanceType::SearchSmall => "search.small",
            PartitionInstanceType::SearchXlarge => "search.xlarge",
            PartitionInstanceType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "search.2xlarge",
            "search.large",
            "search.m1.large",
            "search.m1.small",
            "search.m2.2xlarge",
            "search.m2.xlarge",
            "search.m3.2xlarge",
            "search.m3.large",
            "search.m3.medium",
            "search.m3.xlarge",
            "search.medium",
            "search.previousgeneration.2xlarge",
            "search.previousgeneration.large",
            "search.previousgeneration.small",
            "search.previousgeneration.xlarge",
            "search.small",
            "search.xlarge",
        ]
    }
}
impl AsRef<str> for PartitionInstanceType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The configuration and status of the domain's endpoint options.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DomainEndpointOptionsStatus {
    /// <p>The domain endpoint options configured for the domain.</p>
    pub options: std::option::Option<crate::model::DomainEndpointOptions>,
    /// <p>The status of the configured domain endpoint options.</p>
    pub status: std::option::Option<crate::model::OptionStatus>,
}
impl DomainEndpointOptionsStatus {
    /// <p>The domain endpoint options configured for the domain.</p>
    pub fn options(&self) -> std::option::Option<&crate::model::DomainEndpointOptions> {
        self.options.as_ref()
    }
    /// <p>The status of the configured domain endpoint options.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::OptionStatus> {
        self.status.as_ref()
    }
}
impl std::fmt::Debug for DomainEndpointOptionsStatus {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DomainEndpointOptionsStatus");
        formatter.field("options", &self.options);
        formatter.field("status", &self.status);
        formatter.finish()
    }
}
/// See [`DomainEndpointOptionsStatus`](crate::model::DomainEndpointOptionsStatus)
pub mod domain_endpoint_options_status {
    /// A builder for [`DomainEndpointOptionsStatus`](crate::model::DomainEndpointOptionsStatus)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) options: std::option::Option<crate::model::DomainEndpointOptions>,
        pub(crate) status: std::option::Option<crate::model::OptionStatus>,
    }
    impl Builder {
        /// <p>The domain endpoint options configured for the domain.</p>
        pub fn options(mut self, input: crate::model::DomainEndpointOptions) -> Self {
            self.options = Some(input);
            self
        }
        /// <p>The domain endpoint options configured for the domain.</p>
        pub fn set_options(
            mut self,
            input: std::option::Option<crate::model::DomainEndpointOptions>,
        ) -> Self {
            self.options = input;
            self
        }
        /// <p>The status of the configured domain endpoint options.</p>
        pub fn status(mut self, input: crate::model::OptionStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of the configured domain endpoint options.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::OptionStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`DomainEndpointOptionsStatus`](crate::model::DomainEndpointOptionsStatus)
        pub fn build(self) -> crate::model::DomainEndpointOptionsStatus {
            crate::model::DomainEndpointOptionsStatus {
                options: self.options,
                status: self.status,
            }
        }
    }
}
impl DomainEndpointOptionsStatus {
    /// Creates a new builder-style object to manufacture [`DomainEndpointOptionsStatus`](crate::model::DomainEndpointOptionsStatus)
    pub fn builder() -> crate::model::domain_endpoint_options_status::Builder {
        crate::model::domain_endpoint_options_status::Builder::default()
    }
}

/// <p>The domain's endpoint options.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DomainEndpointOptions {
    /// <p>Whether the domain is HTTPS only enabled.</p>
    pub enforce_https: std::option::Option<bool>,
    /// <p>The minimum required TLS version</p>
    pub tls_security_policy: std::option::Option<crate::model::TlsSecurityPolicy>,
}
impl DomainEndpointOptions {
    /// <p>Whether the domain is HTTPS only enabled.</p>
    pub fn enforce_https(&self) -> std::option::Option<bool> {
        self.enforce_https
    }
    /// <p>The minimum required TLS version</p>
    pub fn tls_security_policy(&self) -> std::option::Option<&crate::model::TlsSecurityPolicy> {
        self.tls_security_policy.as_ref()
    }
}
impl std::fmt::Debug for DomainEndpointOptions {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DomainEndpointOptions");
        formatter.field("enforce_https", &self.enforce_https);
        formatter.field("tls_security_policy", &self.tls_security_policy);
        formatter.finish()
    }
}
/// See [`DomainEndpointOptions`](crate::model::DomainEndpointOptions)
pub mod domain_endpoint_options {
    /// A builder for [`DomainEndpointOptions`](crate::model::DomainEndpointOptions)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) enforce_https: std::option::Option<bool>,
        pub(crate) tls_security_policy: std::option::Option<crate::model::TlsSecurityPolicy>,
    }
    impl Builder {
        /// <p>Whether the domain is HTTPS only enabled.</p>
        pub fn enforce_https(mut self, input: bool) -> Self {
            self.enforce_https = Some(input);
            self
        }
        /// <p>Whether the domain is HTTPS only enabled.</p>
        pub fn set_enforce_https(mut self, input: std::option::Option<bool>) -> Self {
            self.enforce_https = input;
            self
        }
        /// <p>The minimum required TLS version</p>
        pub fn tls_security_policy(mut self, input: crate::model::TlsSecurityPolicy) -> Self {
            self.tls_security_policy = Some(input);
            self
        }
        /// <p>The minimum required TLS version</p>
        pub fn set_tls_security_policy(
            mut self,
            input: std::option::Option<crate::model::TlsSecurityPolicy>,
        ) -> Self {
            self.tls_security_policy = input;
            self
        }
        /// Consumes the builder and constructs a [`DomainEndpointOptions`](crate::model::DomainEndpointOptions)
        pub fn build(self) -> crate::model::DomainEndpointOptions {
            crate::model::DomainEndpointOptions {
                enforce_https: self.enforce_https,
                tls_security_policy: self.tls_security_policy,
            }
        }
    }
}
impl DomainEndpointOptions {
    /// Creates a new builder-style object to manufacture [`DomainEndpointOptions`](crate::model::DomainEndpointOptions)
    pub fn builder() -> crate::model::domain_endpoint_options::Builder {
        crate::model::domain_endpoint_options::Builder::default()
    }
}

/// <p>The minimum required TLS version.</p>
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum TlsSecurityPolicy {
    #[allow(missing_docs)] // documentation missing in model
    PolicyMinTls10201907,
    #[allow(missing_docs)] // documentation missing in model
    PolicyMinTls12201907,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for TlsSecurityPolicy {
    fn from(s: &str) -> Self {
        match s {
            "Policy-Min-TLS-1-0-2019-07" => TlsSecurityPolicy::PolicyMinTls10201907,
            "Policy-Min-TLS-1-2-2019-07" => TlsSecurityPolicy::PolicyMinTls12201907,
            other => TlsSecurityPolicy::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for TlsSecurityPolicy {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(TlsSecurityPolicy::from(s))
    }
}
impl TlsSecurityPolicy {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            TlsSecurityPolicy::PolicyMinTls10201907 => "Policy-Min-TLS-1-0-2019-07",
            TlsSecurityPolicy::PolicyMinTls12201907 => "Policy-Min-TLS-1-2-2019-07",
            TlsSecurityPolicy::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["Policy-Min-TLS-1-0-2019-07", "Policy-Min-TLS-1-2-2019-07"]
    }
}
impl AsRef<str> for TlsSecurityPolicy {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The status and configuration of the domain's availability options.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AvailabilityOptionsStatus {
    /// <p>The availability options configured for the domain.</p>
    pub options: bool,
    /// <p>The status of domain configuration option.</p>
    pub status: std::option::Option<crate::model::OptionStatus>,
}
impl AvailabilityOptionsStatus {
    /// <p>The availability options configured for the domain.</p>
    pub fn options(&self) -> bool {
        self.options
    }
    /// <p>The status of domain configuration option.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::OptionStatus> {
        self.status.as_ref()
    }
}
impl std::fmt::Debug for AvailabilityOptionsStatus {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AvailabilityOptionsStatus");
        formatter.field("options", &self.options);
        formatter.field("status", &self.status);
        formatter.finish()
    }
}
/// See [`AvailabilityOptionsStatus`](crate::model::AvailabilityOptionsStatus)
pub mod availability_options_status {
    /// A builder for [`AvailabilityOptionsStatus`](crate::model::AvailabilityOptionsStatus)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) options: std::option::Option<bool>,
        pub(crate) status: std::option::Option<crate::model::OptionStatus>,
    }
    impl Builder {
        /// <p>The availability options configured for the domain.</p>
        pub fn options(mut self, input: bool) -> Self {
            self.options = Some(input);
            self
        }
        /// <p>The availability options configured for the domain.</p>
        pub fn set_options(mut self, input: std::option::Option<bool>) -> Self {
            self.options = input;
            self
        }
        /// <p>The status of domain configuration option.</p>
        pub fn status(mut self, input: crate::model::OptionStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of domain configuration option.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::OptionStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`AvailabilityOptionsStatus`](crate::model::AvailabilityOptionsStatus)
        pub fn build(self) -> crate::model::AvailabilityOptionsStatus {
            crate::model::AvailabilityOptionsStatus {
                options: self.options.unwrap_or_default(),
                status: self.status,
            }
        }
    }
}
impl AvailabilityOptionsStatus {
    /// Creates a new builder-style object to manufacture [`AvailabilityOptionsStatus`](crate::model::AvailabilityOptionsStatus)
    pub fn builder() -> crate::model::availability_options_status::Builder {
        crate::model::availability_options_status::Builder::default()
    }
}

/// <p>The value of a <code>Suggester</code> and its current status.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SuggesterStatus {
    /// <p>Configuration information for a search suggester. Each suggester has a unique name and specifies the text field you want to use for suggestions. The following options can be configured for a suggester: <code>FuzzyMatching</code>, <code>SortExpression</code>. </p>
    pub options: std::option::Option<crate::model::Suggester>,
    /// <p>The status of domain configuration option.</p>
    pub status: std::option::Option<crate::model::OptionStatus>,
}
impl SuggesterStatus {
    /// <p>Configuration information for a search suggester. Each suggester has a unique name and specifies the text field you want to use for suggestions. The following options can be configured for a suggester: <code>FuzzyMatching</code>, <code>SortExpression</code>. </p>
    pub fn options(&self) -> std::option::Option<&crate::model::Suggester> {
        self.options.as_ref()
    }
    /// <p>The status of domain configuration option.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::OptionStatus> {
        self.status.as_ref()
    }
}
impl std::fmt::Debug for SuggesterStatus {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SuggesterStatus");
        formatter.field("options", &self.options);
        formatter.field("status", &self.status);
        formatter.finish()
    }
}
/// See [`SuggesterStatus`](crate::model::SuggesterStatus)
pub mod suggester_status {
    /// A builder for [`SuggesterStatus`](crate::model::SuggesterStatus)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) options: std::option::Option<crate::model::Suggester>,
        pub(crate) status: std::option::Option<crate::model::OptionStatus>,
    }
    impl Builder {
        /// <p>Configuration information for a search suggester. Each suggester has a unique name and specifies the text field you want to use for suggestions. The following options can be configured for a suggester: <code>FuzzyMatching</code>, <code>SortExpression</code>. </p>
        pub fn options(mut self, input: crate::model::Suggester) -> Self {
            self.options = Some(input);
            self
        }
        /// <p>Configuration information for a search suggester. Each suggester has a unique name and specifies the text field you want to use for suggestions. The following options can be configured for a suggester: <code>FuzzyMatching</code>, <code>SortExpression</code>. </p>
        pub fn set_options(mut self, input: std::option::Option<crate::model::Suggester>) -> Self {
            self.options = input;
            self
        }
        /// <p>The status of domain configuration option.</p>
        pub fn status(mut self, input: crate::model::OptionStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of domain configuration option.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::OptionStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`SuggesterStatus`](crate::model::SuggesterStatus)
        pub fn build(self) -> crate::model::SuggesterStatus {
            crate::model::SuggesterStatus {
                options: self.options,
                status: self.status,
            }
        }
    }
}
impl SuggesterStatus {
    /// Creates a new builder-style object to manufacture [`SuggesterStatus`](crate::model::SuggesterStatus)
    pub fn builder() -> crate::model::suggester_status::Builder {
        crate::model::suggester_status::Builder::default()
    }
}

/// <p>Configuration information for a search suggester. Each suggester has a unique name and specifies the text field you want to use for suggestions. The following options can be configured for a suggester: <code>FuzzyMatching</code>, <code>SortExpression</code>. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Suggester {
    /// <p>Names must begin with a letter and can contain the following characters:
    /// a-z (lowercase), 0-9, and _ (underscore).</p>
    pub suggester_name: std::option::Option<std::string::String>,
    /// <p>Options for a search suggester.</p>
    pub document_suggester_options: std::option::Option<crate::model::DocumentSuggesterOptions>,
}
impl Suggester {
    /// <p>Names must begin with a letter and can contain the following characters:
    /// a-z (lowercase), 0-9, and _ (underscore).</p>
    pub fn suggester_name(&self) -> std::option::Option<&str> {
        self.suggester_name.as_deref()
    }
    /// <p>Options for a search suggester.</p>
    pub fn document_suggester_options(
        &self,
    ) -> std::option::Option<&crate::model::DocumentSuggesterOptions> {
        self.document_suggester_options.as_ref()
    }
}
impl std::fmt::Debug for Suggester {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Suggester");
        formatter.field("suggester_name", &self.suggester_name);
        formatter.field(
            "document_suggester_options",
            &self.document_suggester_options,
        );
        formatter.finish()
    }
}
/// See [`Suggester`](crate::model::Suggester)
pub mod suggester {
    /// A builder for [`Suggester`](crate::model::Suggester)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) suggester_name: std::option::Option<std::string::String>,
        pub(crate) document_suggester_options:
            std::option::Option<crate::model::DocumentSuggesterOptions>,
    }
    impl Builder {
        /// <p>Names must begin with a letter and can contain the following characters:
        /// a-z (lowercase), 0-9, and _ (underscore).</p>
        pub fn suggester_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.suggester_name = Some(input.into());
            self
        }
        /// <p>Names must begin with a letter and can contain the following characters:
        /// a-z (lowercase), 0-9, and _ (underscore).</p>
        pub fn set_suggester_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.suggester_name = input;
            self
        }
        /// <p>Options for a search suggester.</p>
        pub fn document_suggester_options(
            mut self,
            input: crate::model::DocumentSuggesterOptions,
        ) -> Self {
            self.document_suggester_options = Some(input);
            self
        }
        /// <p>Options for a search suggester.</p>
        pub fn set_document_suggester_options(
            mut self,
            input: std::option::Option<crate::model::DocumentSuggesterOptions>,
        ) -> Self {
            self.document_suggester_options = input;
            self
        }
        /// Consumes the builder and constructs a [`Suggester`](crate::model::Suggester)
        pub fn build(self) -> crate::model::Suggester {
            crate::model::Suggester {
                suggester_name: self.suggester_name,
                document_suggester_options: self.document_suggester_options,
            }
        }
    }
}
impl Suggester {
    /// Creates a new builder-style object to manufacture [`Suggester`](crate::model::Suggester)
    pub fn builder() -> crate::model::suggester::Builder {
        crate::model::suggester::Builder::default()
    }
}

/// <p>Options for a search suggester.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DocumentSuggesterOptions {
    /// <p>The name of the index field you want to use for suggestions.
    /// </p>
    pub source_field: std::option::Option<std::string::String>,
    /// <p>The level of fuzziness allowed when suggesting matches for a string: <code>none</code>, <code>low</code>, or <code>high</code>. With none, the specified string is treated as an exact prefix. With low, suggestions must differ from the specified string by no more than one character. With high, suggestions can differ by up to two characters. The default is none. </p>
    pub fuzzy_matching: std::option::Option<crate::model::SuggesterFuzzyMatching>,
    /// <p>An expression that computes a score for each suggestion to control how they are sorted. The scores are rounded to the nearest
    /// integer, with a floor of 0 and a ceiling of 2^31-1. A document's relevance score is not computed
    /// for suggestions, so sort expressions cannot reference the <code>_score</code> value.
    /// To sort suggestions using a numeric field or existing expression, simply specify
    /// the name of the field or expression. If no expression is configured for the suggester, the
    /// suggestions are sorted with the closest matches listed first.</p>
    pub sort_expression: std::option::Option<std::string::String>,
}
impl DocumentSuggesterOptions {
    /// <p>The name of the index field you want to use for suggestions.
    /// </p>
    pub fn source_field(&self) -> std::option::Option<&str> {
        self.source_field.as_deref()
    }
    /// <p>The level of fuzziness allowed when suggesting matches for a string: <code>none</code>, <code>low</code>, or <code>high</code>. With none, the specified string is treated as an exact prefix. With low, suggestions must differ from the specified string by no more than one character. With high, suggestions can differ by up to two characters. The default is none. </p>
    pub fn fuzzy_matching(&self) -> std::option::Option<&crate::model::SuggesterFuzzyMatching> {
        self.fuzzy_matching.as_ref()
    }
    /// <p>An expression that computes a score for each suggestion to control how they are sorted. The scores are rounded to the nearest
    /// integer, with a floor of 0 and a ceiling of 2^31-1. A document's relevance score is not computed
    /// for suggestions, so sort expressions cannot reference the <code>_score</code> value.
    /// To sort suggestions using a numeric field or existing expression, simply specify
    /// the name of the field or expression. If no expression is configured for the suggester, the
    /// suggestions are sorted with the closest matches listed first.</p>
    pub fn sort_expression(&self) -> std::option::Option<&str> {
        self.sort_expression.as_deref()
    }
}
impl std::fmt::Debug for DocumentSuggesterOptions {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DocumentSuggesterOptions");
        formatter.field("source_field", &self.source_field);
        formatter.field("fuzzy_matching", &self.fuzzy_matching);
        formatter.field("sort_expression", &self.sort_expression);
        formatter.finish()
    }
}
/// See [`DocumentSuggesterOptions`](crate::model::DocumentSuggesterOptions)
pub mod document_suggester_options {
    /// A builder for [`DocumentSuggesterOptions`](crate::model::DocumentSuggesterOptions)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) source_field: std::option::Option<std::string::String>,
        pub(crate) fuzzy_matching: std::option::Option<crate::model::SuggesterFuzzyMatching>,
        pub(crate) sort_expression: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the index field you want to use for suggestions.
        /// </p>
        pub fn source_field(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_field = Some(input.into());
            self
        }
        /// <p>The name of the index field you want to use for suggestions.
        /// </p>
        pub fn set_source_field(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.source_field = input;
            self
        }
        /// <p>The level of fuzziness allowed when suggesting matches for a string: <code>none</code>, <code>low</code>, or <code>high</code>. With none, the specified string is treated as an exact prefix. With low, suggestions must differ from the specified string by no more than one character. With high, suggestions can differ by up to two characters. The default is none. </p>
        pub fn fuzzy_matching(mut self, input: crate::model::SuggesterFuzzyMatching) -> Self {
            self.fuzzy_matching = Some(input);
            self
        }
        /// <p>The level of fuzziness allowed when suggesting matches for a string: <code>none</code>, <code>low</code>, or <code>high</code>. With none, the specified string is treated as an exact prefix. With low, suggestions must differ from the specified string by no more than one character. With high, suggestions can differ by up to two characters. The default is none. </p>
        pub fn set_fuzzy_matching(
            mut self,
            input: std::option::Option<crate::model::SuggesterFuzzyMatching>,
        ) -> Self {
            self.fuzzy_matching = input;
            self
        }
        /// <p>An expression that computes a score for each suggestion to control how they are sorted. The scores are rounded to the nearest
        /// integer, with a floor of 0 and a ceiling of 2^31-1. A document's relevance score is not computed
        /// for suggestions, so sort expressions cannot reference the <code>_score</code> value.
        /// To sort suggestions using a numeric field or existing expression, simply specify
        /// the name of the field or expression. If no expression is configured for the suggester, the
        /// suggestions are sorted with the closest matches listed first.</p>
        pub fn sort_expression(mut self, input: impl Into<std::string::String>) -> Self {
            self.sort_expression = Some(input.into());
            self
        }
        /// <p>An expression that computes a score for each suggestion to control how they are sorted. The scores are rounded to the nearest
        /// integer, with a floor of 0 and a ceiling of 2^31-1. A document's relevance score is not computed
        /// for suggestions, so sort expressions cannot reference the <code>_score</code> value.
        /// To sort suggestions using a numeric field or existing expression, simply specify
        /// the name of the field or expression. If no expression is configured for the suggester, the
        /// suggestions are sorted with the closest matches listed first.</p>
        pub fn set_sort_expression(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.sort_expression = input;
            self
        }
        /// Consumes the builder and constructs a [`DocumentSuggesterOptions`](crate::model::DocumentSuggesterOptions)
        pub fn build(self) -> crate::model::DocumentSuggesterOptions {
            crate::model::DocumentSuggesterOptions {
                source_field: self.source_field,
                fuzzy_matching: self.fuzzy_matching,
                sort_expression: self.sort_expression,
            }
        }
    }
}
impl DocumentSuggesterOptions {
    /// Creates a new builder-style object to manufacture [`DocumentSuggesterOptions`](crate::model::DocumentSuggesterOptions)
    pub fn builder() -> crate::model::document_suggester_options::Builder {
        crate::model::document_suggester_options::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum SuggesterFuzzyMatching {
    #[allow(missing_docs)] // documentation missing in model
    High,
    #[allow(missing_docs)] // documentation missing in model
    Low,
    #[allow(missing_docs)] // documentation missing in model
    None,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for SuggesterFuzzyMatching {
    fn from(s: &str) -> Self {
        match s {
            "high" => SuggesterFuzzyMatching::High,
            "low" => SuggesterFuzzyMatching::Low,
            "none" => SuggesterFuzzyMatching::None,
            other => SuggesterFuzzyMatching::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for SuggesterFuzzyMatching {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(SuggesterFuzzyMatching::from(s))
    }
}
impl SuggesterFuzzyMatching {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            SuggesterFuzzyMatching::High => "high",
            SuggesterFuzzyMatching::Low => "low",
            SuggesterFuzzyMatching::None => "none",
            SuggesterFuzzyMatching::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["high", "low", "none"]
    }
}
impl AsRef<str> for SuggesterFuzzyMatching {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The value of an <code>IndexField</code> and its current status.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct IndexFieldStatus {
    /// <p>Configuration information for a field in the index, including its name, type, and options. The supported options depend on the <code><a>IndexFieldType</a></code>.</p>
    pub options: std::option::Option<crate::model::IndexField>,
    /// <p>The status of domain configuration option.</p>
    pub status: std::option::Option<crate::model::OptionStatus>,
}
impl IndexFieldStatus {
    /// <p>Configuration information for a field in the index, including its name, type, and options. The supported options depend on the <code><a>IndexFieldType</a></code>.</p>
    pub fn options(&self) -> std::option::Option<&crate::model::IndexField> {
        self.options.as_ref()
    }
    /// <p>The status of domain configuration option.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::OptionStatus> {
        self.status.as_ref()
    }
}
impl std::fmt::Debug for IndexFieldStatus {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("IndexFieldStatus");
        formatter.field("options", &self.options);
        formatter.field("status", &self.status);
        formatter.finish()
    }
}
/// See [`IndexFieldStatus`](crate::model::IndexFieldStatus)
pub mod index_field_status {
    /// A builder for [`IndexFieldStatus`](crate::model::IndexFieldStatus)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) options: std::option::Option<crate::model::IndexField>,
        pub(crate) status: std::option::Option<crate::model::OptionStatus>,
    }
    impl Builder {
        /// <p>Configuration information for a field in the index, including its name, type, and options. The supported options depend on the <code><a>IndexFieldType</a></code>.</p>
        pub fn options(mut self, input: crate::model::IndexField) -> Self {
            self.options = Some(input);
            self
        }
        /// <p>Configuration information for a field in the index, including its name, type, and options. The supported options depend on the <code><a>IndexFieldType</a></code>.</p>
        pub fn set_options(mut self, input: std::option::Option<crate::model::IndexField>) -> Self {
            self.options = input;
            self
        }
        /// <p>The status of domain configuration option.</p>
        pub fn status(mut self, input: crate::model::OptionStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of domain configuration option.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::OptionStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`IndexFieldStatus`](crate::model::IndexFieldStatus)
        pub fn build(self) -> crate::model::IndexFieldStatus {
            crate::model::IndexFieldStatus {
                options: self.options,
                status: self.status,
            }
        }
    }
}
impl IndexFieldStatus {
    /// Creates a new builder-style object to manufacture [`IndexFieldStatus`](crate::model::IndexFieldStatus)
    pub fn builder() -> crate::model::index_field_status::Builder {
        crate::model::index_field_status::Builder::default()
    }
}

/// <p>Configuration information for a field in the index, including its name, type, and options. The supported options depend on the <code><a>IndexFieldType</a></code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct IndexField {
    /// <p>A string that represents the name of an index field. CloudSearch supports regular index fields as well as dynamic fields.
    /// A dynamic field's name defines a pattern that begins or ends with a wildcard.
    /// Any document fields that don't map to a regular index field but do match a  
    /// dynamic field's pattern are configured with the dynamic field's indexing options.
    /// </p>
    /// <p>Regular field names begin with a letter and can contain the following characters:
    /// a-z (lowercase), 0-9, and _ (underscore).
    /// Dynamic field names must begin or end with a wildcard (*).
    /// The wildcard can also be the only character in a dynamic field name.
    /// Multiple wildcards, and wildcards embedded within a string are not supported.
    /// </p>
    /// <p>The name <code>score</code> is reserved and cannot be used as a field name.
    /// To reference a document's ID, you can use the name <code>_id</code>.
    /// </p>
    pub index_field_name: std::option::Option<std::string::String>,
    /// <p>The type of field. The valid options for a field depend on the field type. For more information about the supported field types, see <a href="http://docs.aws.amazon.com/cloudsearch/latest/developerguide/configuring-index-fields.html" target="_blank">Configuring Index Fields</a> in the <i>Amazon CloudSearch Developer Guide</i>.</p>
    pub index_field_type: std::option::Option<crate::model::IndexFieldType>,
    /// <p>Options for a 64-bit signed integer field.  Present if <code>IndexFieldType</code> specifies the field is of type <code>int</code>. All options are enabled by default.</p>
    pub int_options: std::option::Option<crate::model::IntOptions>,
    /// <p>Options for a double-precision 64-bit floating point field.  Present if <code>IndexFieldType</code> specifies the field is of type <code>double</code>. All options are enabled by default.</p>
    pub double_options: std::option::Option<crate::model::DoubleOptions>,
    /// <p>Options for literal field.  Present if <code>IndexFieldType</code> specifies the field is of type <code>literal</code>. All options are enabled by default.</p>
    pub literal_options: std::option::Option<crate::model::LiteralOptions>,
    /// <p>Options for text field.  Present if <code>IndexFieldType</code> specifies the field is of type <code>text</code>. A <code>text</code> field is always searchable. All options are enabled by default.</p>
    pub text_options: std::option::Option<crate::model::TextOptions>,
    /// <p>Options for a date field. Dates and times are specified in UTC (Coordinated Universal Time) according to IETF RFC3339: yyyy-mm-ddT00:00:00Z.  Present if <code>IndexFieldType</code> specifies the field is of type <code>date</code>. All options are enabled by default.</p>
    pub date_options: std::option::Option<crate::model::DateOptions>,
    /// <p>Options for a latlon field. A latlon field contains a location stored as a latitude and longitude value pair. Present if <code>IndexFieldType</code> specifies the field is of type <code>latlon</code>. All options are enabled by default.</p>
    pub lat_lon_options: std::option::Option<crate::model::LatLonOptions>,
    /// <p>Options for a field that contains an array of 64-bit signed integers.  Present if <code>IndexFieldType</code> specifies the field is of type <code>int-array</code>. All options are enabled by default.</p>
    pub int_array_options: std::option::Option<crate::model::IntArrayOptions>,
    /// <p>Options for a field that contains an array of double-precision 64-bit floating point values.  Present if <code>IndexFieldType</code> specifies the field is of type <code>double-array</code>.  All options are enabled by default.</p>
    pub double_array_options: std::option::Option<crate::model::DoubleArrayOptions>,
    /// <p>Options for a field that contains an array of literal strings.  Present if <code>IndexFieldType</code> specifies the field is of type <code>literal-array</code>. All options are enabled by default.</p>
    pub literal_array_options: std::option::Option<crate::model::LiteralArrayOptions>,
    /// <p>Options for a field that contains an array of text strings.  Present if <code>IndexFieldType</code> specifies the field is of type <code>text-array</code>. A <code>text-array</code> field is always searchable. All options are enabled by default.</p>
    pub text_array_options: std::option::Option<crate::model::TextArrayOptions>,
    /// <p>Options for a field that contains an array of dates.  Present if <code>IndexFieldType</code> specifies the field is of type <code>date-array</code>. All options are enabled by default.</p>
    pub date_array_options: std::option::Option<crate::model::DateArrayOptions>,
}
impl IndexField {
    /// <p>A string that represents the name of an index field. CloudSearch supports regular index fields as well as dynamic fields.
    /// A dynamic field's name defines a pattern that begins or ends with a wildcard.
    /// Any document fields that don't map to a regular index field but do match a  
    /// dynamic field's pattern are configured with the dynamic field's indexing options.
    /// </p>
    /// <p>Regular field names begin with a letter and can contain the following characters:
    /// a-z (lowercase), 0-9, and _ (underscore).
    /// Dynamic field names must begin or end with a wildcard (*).
    /// The wildcard can also be the only character in a dynamic field name.
    /// Multiple wildcards, and wildcards embedded within a string are not supported.
    /// </p>
    /// <p>The name <code>score</code> is reserved and cannot be used as a field name.
    /// To reference a document's ID, you can use the name <code>_id</code>.
    /// </p>
    pub fn index_field_name(&self) -> std::option::Option<&str> {
        self.index_field_name.as_deref()
    }
    /// <p>The type of field. The valid options for a field depend on the field type. For more information about the supported field types, see <a href="http://docs.aws.amazon.com/cloudsearch/latest/developerguide/configuring-index-fields.html" target="_blank">Configuring Index Fields</a> in the <i>Amazon CloudSearch Developer Guide</i>.</p>
    pub fn index_field_type(&self) -> std::option::Option<&crate::model::IndexFieldType> {
        self.index_field_type.as_ref()
    }
    /// <p>Options for a 64-bit signed integer field.  Present if <code>IndexFieldType</code> specifies the field is of type <code>int</code>. All options are enabled by default.</p>
    pub fn int_options(&self) -> std::option::Option<&crate::model::IntOptions> {
        self.int_options.as_ref()
    }
    /// <p>Options for a double-precision 64-bit floating point field.  Present if <code>IndexFieldType</code> specifies the field is of type <code>double</code>. All options are enabled by default.</p>
    pub fn double_options(&self) -> std::option::Option<&crate::model::DoubleOptions> {
        self.double_options.as_ref()
    }
    /// <p>Options for literal field.  Present if <code>IndexFieldType</code> specifies the field is of type <code>literal</code>. All options are enabled by default.</p>
    pub fn literal_options(&self) -> std::option::Option<&crate::model::LiteralOptions> {
        self.literal_options.as_ref()
    }
    /// <p>Options for text field.  Present if <code>IndexFieldType</code> specifies the field is of type <code>text</code>. A <code>text</code> field is always searchable. All options are enabled by default.</p>
    pub fn text_options(&self) -> std::option::Option<&crate::model::TextOptions> {
        self.text_options.as_ref()
    }
    /// <p>Options for a date field. Dates and times are specified in UTC (Coordinated Universal Time) according to IETF RFC3339: yyyy-mm-ddT00:00:00Z.  Present if <code>IndexFieldType</code> specifies the field is of type <code>date</code>. All options are enabled by default.</p>
    pub fn date_options(&self) -> std::option::Option<&crate::model::DateOptions> {
        self.date_options.as_ref()
    }
    /// <p>Options for a latlon field. A latlon field contains a location stored as a latitude and longitude value pair. Present if <code>IndexFieldType</code> specifies the field is of type <code>latlon</code>. All options are enabled by default.</p>
    pub fn lat_lon_options(&self) -> std::option::Option<&crate::model::LatLonOptions> {
        self.lat_lon_options.as_ref()
    }
    /// <p>Options for a field that contains an array of 64-bit signed integers.  Present if <code>IndexFieldType</code> specifies the field is of type <code>int-array</code>. All options are enabled by default.</p>
    pub fn int_array_options(&self) -> std::option::Option<&crate::model::IntArrayOptions> {
        self.int_array_options.as_ref()
    }
    /// <p>Options for a field that contains an array of double-precision 64-bit floating point values.  Present if <code>IndexFieldType</code> specifies the field is of type <code>double-array</code>.  All options are enabled by default.</p>
    pub fn double_array_options(&self) -> std::option::Option<&crate::model::DoubleArrayOptions> {
        self.double_array_options.as_ref()
    }
    /// <p>Options for a field that contains an array of literal strings.  Present if <code>IndexFieldType</code> specifies the field is of type <code>literal-array</code>. All options are enabled by default.</p>
    pub fn literal_array_options(&self) -> std::option::Option<&crate::model::LiteralArrayOptions> {
        self.literal_array_options.as_ref()
    }
    /// <p>Options for a field that contains an array of text strings.  Present if <code>IndexFieldType</code> specifies the field is of type <code>text-array</code>. A <code>text-array</code> field is always searchable. All options are enabled by default.</p>
    pub fn text_array_options(&self) -> std::option::Option<&crate::model::TextArrayOptions> {
        self.text_array_options.as_ref()
    }
    /// <p>Options for a field that contains an array of dates.  Present if <code>IndexFieldType</code> specifies the field is of type <code>date-array</code>. All options are enabled by default.</p>
    pub fn date_array_options(&self) -> std::option::Option<&crate::model::DateArrayOptions> {
        self.date_array_options.as_ref()
    }
}
impl std::fmt::Debug for IndexField {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("IndexField");
        formatter.field("index_field_name", &self.index_field_name);
        formatter.field("index_field_type", &self.index_field_type);
        formatter.field("int_options", &self.int_options);
        formatter.field("double_options", &self.double_options);
        formatter.field("literal_options", &self.literal_options);
        formatter.field("text_options", &self.text_options);
        formatter.field("date_options", &self.date_options);
        formatter.field("lat_lon_options", &self.lat_lon_options);
        formatter.field("int_array_options", &self.int_array_options);
        formatter.field("double_array_options", &self.double_array_options);
        formatter.field("literal_array_options", &self.literal_array_options);
        formatter.field("text_array_options", &self.text_array_options);
        formatter.field("date_array_options", &self.date_array_options);
        formatter.finish()
    }
}
/// See [`IndexField`](crate::model::IndexField)
pub mod index_field {
    /// A builder for [`IndexField`](crate::model::IndexField)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) index_field_name: std::option::Option<std::string::String>,
        pub(crate) index_field_type: std::option::Option<crate::model::IndexFieldType>,
        pub(crate) int_options: std::option::Option<crate::model::IntOptions>,
        pub(crate) double_options: std::option::Option<crate::model::DoubleOptions>,
        pub(crate) literal_options: std::option::Option<crate::model::LiteralOptions>,
        pub(crate) text_options: std::option::Option<crate::model::TextOptions>,
        pub(crate) date_options: std::option::Option<crate::model::DateOptions>,
        pub(crate) lat_lon_options: std::option::Option<crate::model::LatLonOptions>,
        pub(crate) int_array_options: std::option::Option<crate::model::IntArrayOptions>,
        pub(crate) double_array_options: std::option::Option<crate::model::DoubleArrayOptions>,
        pub(crate) literal_array_options: std::option::Option<crate::model::LiteralArrayOptions>,
        pub(crate) text_array_options: std::option::Option<crate::model::TextArrayOptions>,
        pub(crate) date_array_options: std::option::Option<crate::model::DateArrayOptions>,
    }
    impl Builder {
        /// <p>A string that represents the name of an index field. CloudSearch supports regular index fields as well as dynamic fields.
        /// A dynamic field's name defines a pattern that begins or ends with a wildcard.
        /// Any document fields that don't map to a regular index field but do match a  
        /// dynamic field's pattern are configured with the dynamic field's indexing options.
        /// </p>
        /// <p>Regular field names begin with a letter and can contain the following characters:
        /// a-z (lowercase), 0-9, and _ (underscore).
        /// Dynamic field names must begin or end with a wildcard (*).
        /// The wildcard can also be the only character in a dynamic field name.
        /// Multiple wildcards, and wildcards embedded within a string are not supported.
        /// </p>
        /// <p>The name <code>score</code> is reserved and cannot be used as a field name.
        /// To reference a document's ID, you can use the name <code>_id</code>.
        /// </p>
        pub fn index_field_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.index_field_name = Some(input.into());
            self
        }
        /// <p>A string that represents the name of an index field. CloudSearch supports regular index fields as well as dynamic fields.
        /// A dynamic field's name defines a pattern that begins or ends with a wildcard.
        /// Any document fields that don't map to a regular index field but do match a  
        /// dynamic field's pattern are configured with the dynamic field's indexing options.
        /// </p>
        /// <p>Regular field names begin with a letter and can contain the following characters:
        /// a-z (lowercase), 0-9, and _ (underscore).
        /// Dynamic field names must begin or end with a wildcard (*).
        /// The wildcard can also be the only character in a dynamic field name.
        /// Multiple wildcards, and wildcards embedded within a string are not supported.
        /// </p>
        /// <p>The name <code>score</code> is reserved and cannot be used as a field name.
        /// To reference a document's ID, you can use the name <code>_id</code>.
        /// </p>
        pub fn set_index_field_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.index_field_name = input;
            self
        }
        /// <p>The type of field. The valid options for a field depend on the field type. For more information about the supported field types, see <a href="http://docs.aws.amazon.com/cloudsearch/latest/developerguide/configuring-index-fields.html" target="_blank">Configuring Index Fields</a> in the <i>Amazon CloudSearch Developer Guide</i>.</p>
        pub fn index_field_type(mut self, input: crate::model::IndexFieldType) -> Self {
            self.index_field_type = Some(input);
            self
        }
        /// <p>The type of field. The valid options for a field depend on the field type. For more information about the supported field types, see <a href="http://docs.aws.amazon.com/cloudsearch/latest/developerguide/configuring-index-fields.html" target="_blank">Configuring Index Fields</a> in the <i>Amazon CloudSearch Developer Guide</i>.</p>
        pub fn set_index_field_type(
            mut self,
            input: std::option::Option<crate::model::IndexFieldType>,
        ) -> Self {
            self.index_field_type = input;
            self
        }
        /// <p>Options for a 64-bit signed integer field.  Present if <code>IndexFieldType</code> specifies the field is of type <code>int</code>. All options are enabled by default.</p>
        pub fn int_options(mut self, input: crate::model::IntOptions) -> Self {
            self.int_options = Some(input);
            self
        }
        /// <p>Options for a 64-bit signed integer field.  Present if <code>IndexFieldType</code> specifies the field is of type <code>int</code>. All options are enabled by default.</p>
        pub fn set_int_options(
            mut self,
            input: std::option::Option<crate::model::IntOptions>,
        ) -> Self {
            self.int_options = input;
            self
        }
        /// <p>Options for a double-precision 64-bit floating point field.  Present if <code>IndexFieldType</code> specifies the field is of type <code>double</code>. All options are enabled by default.</p>
        pub fn double_options(mut self, input: crate::model::DoubleOptions) -> Self {
            self.double_options = Some(input);
            self
        }
        /// <p>Options for a double-precision 64-bit floating point field.  Present if <code>IndexFieldType</code> specifies the field is of type <code>double</code>. All options are enabled by default.</p>
        pub fn set_double_options(
            mut self,
            input: std::option::Option<crate::model::DoubleOptions>,
        ) -> Self {
            self.double_options = input;
            self
        }
        /// <p>Options for literal field.  Present if <code>IndexFieldType</code> specifies the field is of type <code>literal</code>. All options are enabled by default.</p>
        pub fn literal_options(mut self, input: crate::model::LiteralOptions) -> Self {
            self.literal_options = Some(input);
            self
        }
        /// <p>Options for literal field.  Present if <code>IndexFieldType</code> specifies the field is of type <code>literal</code>. All options are enabled by default.</p>
        pub fn set_literal_options(
            mut self,
            input: std::option::Option<crate::model::LiteralOptions>,
        ) -> Self {
            self.literal_options = input;
            self
        }
        /// <p>Options for text field.  Present if <code>IndexFieldType</code> specifies the field is of type <code>text</code>. A <code>text</code> field is always searchable. All options are enabled by default.</p>
        pub fn text_options(mut self, input: crate::model::TextOptions) -> Self {
            self.text_options = Some(input);
            self
        }
        /// <p>Options for text field.  Present if <code>IndexFieldType</code> specifies the field is of type <code>text</code>. A <code>text</code> field is always searchable. All options are enabled by default.</p>
        pub fn set_text_options(
            mut self,
            input: std::option::Option<crate::model::TextOptions>,
        ) -> Self {
            self.text_options = input;
            self
        }
        /// <p>Options for a date field. Dates and times are specified in UTC (Coordinated Universal Time) according to IETF RFC3339: yyyy-mm-ddT00:00:00Z.  Present if <code>IndexFieldType</code> specifies the field is of type <code>date</code>. All options are enabled by default.</p>
        pub fn date_options(mut self, input: crate::model::DateOptions) -> Self {
            self.date_options = Some(input);
            self
        }
        /// <p>Options for a date field. Dates and times are specified in UTC (Coordinated Universal Time) according to IETF RFC3339: yyyy-mm-ddT00:00:00Z.  Present if <code>IndexFieldType</code> specifies the field is of type <code>date</code>. All options are enabled by default.</p>
        pub fn set_date_options(
            mut self,
            input: std::option::Option<crate::model::DateOptions>,
        ) -> Self {
            self.date_options = input;
            self
        }
        /// <p>Options for a latlon field. A latlon field contains a location stored as a latitude and longitude value pair. Present if <code>IndexFieldType</code> specifies the field is of type <code>latlon</code>. All options are enabled by default.</p>
        pub fn lat_lon_options(mut self, input: crate::model::LatLonOptions) -> Self {
            self.lat_lon_options = Some(input);
            self
        }
        /// <p>Options for a latlon field. A latlon field contains a location stored as a latitude and longitude value pair. Present if <code>IndexFieldType</code> specifies the field is of type <code>latlon</code>. All options are enabled by default.</p>
        pub fn set_lat_lon_options(
            mut self,
            input: std::option::Option<crate::model::LatLonOptions>,
        ) -> Self {
            self.lat_lon_options = input;
            self
        }
        /// <p>Options for a field that contains an array of 64-bit signed integers.  Present if <code>IndexFieldType</code> specifies the field is of type <code>int-array</code>. All options are enabled by default.</p>
        pub fn int_array_options(mut self, input: crate::model::IntArrayOptions) -> Self {
            self.int_array_options = Some(input);
            self
        }
        /// <p>Options for a field that contains an array of 64-bit signed integers.  Present if <code>IndexFieldType</code> specifies the field is of type <code>int-array</code>. All options are enabled by default.</p>
        pub fn set_int_array_options(
            mut self,
            input: std::option::Option<crate::model::IntArrayOptions>,
        ) -> Self {
            self.int_array_options = input;
            self
        }
        /// <p>Options for a field that contains an array of double-precision 64-bit floating point values.  Present if <code>IndexFieldType</code> specifies the field is of type <code>double-array</code>.  All options are enabled by default.</p>
        pub fn double_array_options(mut self, input: crate::model::DoubleArrayOptions) -> Self {
            self.double_array_options = Some(input);
            self
        }
        /// <p>Options for a field that contains an array of double-precision 64-bit floating point values.  Present if <code>IndexFieldType</code> specifies the field is of type <code>double-array</code>.  All options are enabled by default.</p>
        pub fn set_double_array_options(
            mut self,
            input: std::option::Option<crate::model::DoubleArrayOptions>,
        ) -> Self {
            self.double_array_options = input;
            self
        }
        /// <p>Options for a field that contains an array of literal strings.  Present if <code>IndexFieldType</code> specifies the field is of type <code>literal-array</code>. All options are enabled by default.</p>
        pub fn literal_array_options(mut self, input: crate::model::LiteralArrayOptions) -> Self {
            self.literal_array_options = Some(input);
            self
        }
        /// <p>Options for a field that contains an array of literal strings.  Present if <code>IndexFieldType</code> specifies the field is of type <code>literal-array</code>. All options are enabled by default.</p>
        pub fn set_literal_array_options(
            mut self,
            input: std::option::Option<crate::model::LiteralArrayOptions>,
        ) -> Self {
            self.literal_array_options = input;
            self
        }
        /// <p>Options for a field that contains an array of text strings.  Present if <code>IndexFieldType</code> specifies the field is of type <code>text-array</code>. A <code>text-array</code> field is always searchable. All options are enabled by default.</p>
        pub fn text_array_options(mut self, input: crate::model::TextArrayOptions) -> Self {
            self.text_array_options = Some(input);
            self
        }
        /// <p>Options for a field that contains an array of text strings.  Present if <code>IndexFieldType</code> specifies the field is of type <code>text-array</code>. A <code>text-array</code> field is always searchable. All options are enabled by default.</p>
        pub fn set_text_array_options(
            mut self,
            input: std::option::Option<crate::model::TextArrayOptions>,
        ) -> Self {
            self.text_array_options = input;
            self
        }
        /// <p>Options for a field that contains an array of dates.  Present if <code>IndexFieldType</code> specifies the field is of type <code>date-array</code>. All options are enabled by default.</p>
        pub fn date_array_options(mut self, input: crate::model::DateArrayOptions) -> Self {
            self.date_array_options = Some(input);
            self
        }
        /// <p>Options for a field that contains an array of dates.  Present if <code>IndexFieldType</code> specifies the field is of type <code>date-array</code>. All options are enabled by default.</p>
        pub fn set_date_array_options(
            mut self,
            input: std::option::Option<crate::model::DateArrayOptions>,
        ) -> Self {
            self.date_array_options = input;
            self
        }
        /// Consumes the builder and constructs a [`IndexField`](crate::model::IndexField)
        pub fn build(self) -> crate::model::IndexField {
            crate::model::IndexField {
                index_field_name: self.index_field_name,
                index_field_type: self.index_field_type,
                int_options: self.int_options,
                double_options: self.double_options,
                literal_options: self.literal_options,
                text_options: self.text_options,
                date_options: self.date_options,
                lat_lon_options: self.lat_lon_options,
                int_array_options: self.int_array_options,
                double_array_options: self.double_array_options,
                literal_array_options: self.literal_array_options,
                text_array_options: self.text_array_options,
                date_array_options: self.date_array_options,
            }
        }
    }
}
impl IndexField {
    /// Creates a new builder-style object to manufacture [`IndexField`](crate::model::IndexField)
    pub fn builder() -> crate::model::index_field::Builder {
        crate::model::index_field::Builder::default()
    }
}

/// <p>Options for a field that contains an array of dates.  Present if <code>IndexFieldType</code> specifies the field is of type <code>date-array</code>. All options are enabled by default.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DateArrayOptions {
    /// A value to use for the field if the field isn't specified for a document.
    pub default_value: std::option::Option<std::string::String>,
    /// <p>A list of source fields to map to the field. </p>
    pub source_fields: std::option::Option<std::string::String>,
    /// <p>Whether facet information can be returned for the field.</p>
    pub facet_enabled: std::option::Option<bool>,
    /// <p>Whether the contents of the field are searchable.</p>
    pub search_enabled: std::option::Option<bool>,
    /// <p>Whether the contents of the field can be returned in the search results.</p>
    pub return_enabled: std::option::Option<bool>,
}
impl DateArrayOptions {
    /// A value to use for the field if the field isn't specified for a document.
    pub fn default_value(&self) -> std::option::Option<&str> {
        self.default_value.as_deref()
    }
    /// <p>A list of source fields to map to the field. </p>
    pub fn source_fields(&self) -> std::option::Option<&str> {
        self.source_fields.as_deref()
    }
    /// <p>Whether facet information can be returned for the field.</p>
    pub fn facet_enabled(&self) -> std::option::Option<bool> {
        self.facet_enabled
    }
    /// <p>Whether the contents of the field are searchable.</p>
    pub fn search_enabled(&self) -> std::option::Option<bool> {
        self.search_enabled
    }
    /// <p>Whether the contents of the field can be returned in the search results.</p>
    pub fn return_enabled(&self) -> std::option::Option<bool> {
        self.return_enabled
    }
}
impl std::fmt::Debug for DateArrayOptions {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DateArrayOptions");
        formatter.field("default_value", &self.default_value);
        formatter.field("source_fields", &self.source_fields);
        formatter.field("facet_enabled", &self.facet_enabled);
        formatter.field("search_enabled", &self.search_enabled);
        formatter.field("return_enabled", &self.return_enabled);
        formatter.finish()
    }
}
/// See [`DateArrayOptions`](crate::model::DateArrayOptions)
pub mod date_array_options {
    /// A builder for [`DateArrayOptions`](crate::model::DateArrayOptions)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) default_value: std::option::Option<std::string::String>,
        pub(crate) source_fields: std::option::Option<std::string::String>,
        pub(crate) facet_enabled: std::option::Option<bool>,
        pub(crate) search_enabled: std::option::Option<bool>,
        pub(crate) return_enabled: std::option::Option<bool>,
    }
    impl Builder {
        /// A value to use for the field if the field isn't specified for a document.
        pub fn default_value(mut self, input: impl Into<std::string::String>) -> Self {
            self.default_value = Some(input.into());
            self
        }
        /// A value to use for the field if the field isn't specified for a document.
        pub fn set_default_value(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.default_value = input;
            self
        }
        /// <p>A list of source fields to map to the field. </p>
        pub fn source_fields(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_fields = Some(input.into());
            self
        }
        /// <p>A list of source fields to map to the field. </p>
        pub fn set_source_fields(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.source_fields = input;
            self
        }
        /// <p>Whether facet information can be returned for the field.</p>
        pub fn facet_enabled(mut self, input: bool) -> Self {
            self.facet_enabled = Some(input);
            self
        }
        /// <p>Whether facet information can be returned for the field.</p>
        pub fn set_facet_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.facet_enabled = input;
            self
        }
        /// <p>Whether the contents of the field are searchable.</p>
        pub fn search_enabled(mut self, input: bool) -> Self {
            self.search_enabled = Some(input);
            self
        }
        /// <p>Whether the contents of the field are searchable.</p>
        pub fn set_search_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.search_enabled = input;
            self
        }
        /// <p>Whether the contents of the field can be returned in the search results.</p>
        pub fn return_enabled(mut self, input: bool) -> Self {
            self.return_enabled = Some(input);
            self
        }
        /// <p>Whether the contents of the field can be returned in the search results.</p>
        pub fn set_return_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.return_enabled = input;
            self
        }
        /// Consumes the builder and constructs a [`DateArrayOptions`](crate::model::DateArrayOptions)
        pub fn build(self) -> crate::model::DateArrayOptions {
            crate::model::DateArrayOptions {
                default_value: self.default_value,
                source_fields: self.source_fields,
                facet_enabled: self.facet_enabled,
                search_enabled: self.search_enabled,
                return_enabled: self.return_enabled,
            }
        }
    }
}
impl DateArrayOptions {
    /// Creates a new builder-style object to manufacture [`DateArrayOptions`](crate::model::DateArrayOptions)
    pub fn builder() -> crate::model::date_array_options::Builder {
        crate::model::date_array_options::Builder::default()
    }
}

/// <p>Options for a field that contains an array of text strings.  Present if <code>IndexFieldType</code> specifies the field is of type <code>text-array</code>. A <code>text-array</code> field is always searchable. All options are enabled by default.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TextArrayOptions {
    /// A value to use for the field if the field isn't specified for a document.
    pub default_value: std::option::Option<std::string::String>,
    /// <p>A list of source fields to map to the field. </p>
    pub source_fields: std::option::Option<std::string::String>,
    /// <p>Whether the contents of the field can be returned in the search results.</p>
    pub return_enabled: std::option::Option<bool>,
    /// <p>Whether highlights can be returned for the field.</p>
    pub highlight_enabled: std::option::Option<bool>,
    /// <p>The name of an analysis scheme for a  <code>text-array</code> field.</p>
    pub analysis_scheme: std::option::Option<std::string::String>,
}
impl TextArrayOptions {
    /// A value to use for the field if the field isn't specified for a document.
    pub fn default_value(&self) -> std::option::Option<&str> {
        self.default_value.as_deref()
    }
    /// <p>A list of source fields to map to the field. </p>
    pub fn source_fields(&self) -> std::option::Option<&str> {
        self.source_fields.as_deref()
    }
    /// <p>Whether the contents of the field can be returned in the search results.</p>
    pub fn return_enabled(&self) -> std::option::Option<bool> {
        self.return_enabled
    }
    /// <p>Whether highlights can be returned for the field.</p>
    pub fn highlight_enabled(&self) -> std::option::Option<bool> {
        self.highlight_enabled
    }
    /// <p>The name of an analysis scheme for a  <code>text-array</code> field.</p>
    pub fn analysis_scheme(&self) -> std::option::Option<&str> {
        self.analysis_scheme.as_deref()
    }
}
impl std::fmt::Debug for TextArrayOptions {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TextArrayOptions");
        formatter.field("default_value", &self.default_value);
        formatter.field("source_fields", &self.source_fields);
        formatter.field("return_enabled", &self.return_enabled);
        formatter.field("highlight_enabled", &self.highlight_enabled);
        formatter.field("analysis_scheme", &self.analysis_scheme);
        formatter.finish()
    }
}
/// See [`TextArrayOptions`](crate::model::TextArrayOptions)
pub mod text_array_options {
    /// A builder for [`TextArrayOptions`](crate::model::TextArrayOptions)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) default_value: std::option::Option<std::string::String>,
        pub(crate) source_fields: std::option::Option<std::string::String>,
        pub(crate) return_enabled: std::option::Option<bool>,
        pub(crate) highlight_enabled: std::option::Option<bool>,
        pub(crate) analysis_scheme: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// A value to use for the field if the field isn't specified for a document.
        pub fn default_value(mut self, input: impl Into<std::string::String>) -> Self {
            self.default_value = Some(input.into());
            self
        }
        /// A value to use for the field if the field isn't specified for a document.
        pub fn set_default_value(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.default_value = input;
            self
        }
        /// <p>A list of source fields to map to the field. </p>
        pub fn source_fields(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_fields = Some(input.into());
            self
        }
        /// <p>A list of source fields to map to the field. </p>
        pub fn set_source_fields(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.source_fields = input;
            self
        }
        /// <p>Whether the contents of the field can be returned in the search results.</p>
        pub fn return_enabled(mut self, input: bool) -> Self {
            self.return_enabled = Some(input);
            self
        }
        /// <p>Whether the contents of the field can be returned in the search results.</p>
        pub fn set_return_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.return_enabled = input;
            self
        }
        /// <p>Whether highlights can be returned for the field.</p>
        pub fn highlight_enabled(mut self, input: bool) -> Self {
            self.highlight_enabled = Some(input);
            self
        }
        /// <p>Whether highlights can be returned for the field.</p>
        pub fn set_highlight_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.highlight_enabled = input;
            self
        }
        /// <p>The name of an analysis scheme for a  <code>text-array</code> field.</p>
        pub fn analysis_scheme(mut self, input: impl Into<std::string::String>) -> Self {
            self.analysis_scheme = Some(input.into());
            self
        }
        /// <p>The name of an analysis scheme for a  <code>text-array</code> field.</p>
        pub fn set_analysis_scheme(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.analysis_scheme = input;
            self
        }
        /// Consumes the builder and constructs a [`TextArrayOptions`](crate::model::TextArrayOptions)
        pub fn build(self) -> crate::model::TextArrayOptions {
            crate::model::TextArrayOptions {
                default_value: self.default_value,
                source_fields: self.source_fields,
                return_enabled: self.return_enabled,
                highlight_enabled: self.highlight_enabled,
                analysis_scheme: self.analysis_scheme,
            }
        }
    }
}
impl TextArrayOptions {
    /// Creates a new builder-style object to manufacture [`TextArrayOptions`](crate::model::TextArrayOptions)
    pub fn builder() -> crate::model::text_array_options::Builder {
        crate::model::text_array_options::Builder::default()
    }
}

/// <p>Options for a field that contains an array of literal strings.  Present if <code>IndexFieldType</code> specifies the field is of type <code>literal-array</code>. All options are enabled by default.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LiteralArrayOptions {
    /// A value to use for the field if the field isn't specified for a document.
    pub default_value: std::option::Option<std::string::String>,
    /// <p>A list of source fields to map to the field. </p>
    pub source_fields: std::option::Option<std::string::String>,
    /// <p>Whether facet information can be returned for the field.</p>
    pub facet_enabled: std::option::Option<bool>,
    /// <p>Whether the contents of the field are searchable.</p>
    pub search_enabled: std::option::Option<bool>,
    /// <p>Whether the contents of the field can be returned in the search results.</p>
    pub return_enabled: std::option::Option<bool>,
}
impl LiteralArrayOptions {
    /// A value to use for the field if the field isn't specified for a document.
    pub fn default_value(&self) -> std::option::Option<&str> {
        self.default_value.as_deref()
    }
    /// <p>A list of source fields to map to the field. </p>
    pub fn source_fields(&self) -> std::option::Option<&str> {
        self.source_fields.as_deref()
    }
    /// <p>Whether facet information can be returned for the field.</p>
    pub fn facet_enabled(&self) -> std::option::Option<bool> {
        self.facet_enabled
    }
    /// <p>Whether the contents of the field are searchable.</p>
    pub fn search_enabled(&self) -> std::option::Option<bool> {
        self.search_enabled
    }
    /// <p>Whether the contents of the field can be returned in the search results.</p>
    pub fn return_enabled(&self) -> std::option::Option<bool> {
        self.return_enabled
    }
}
impl std::fmt::Debug for LiteralArrayOptions {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LiteralArrayOptions");
        formatter.field("default_value", &self.default_value);
        formatter.field("source_fields", &self.source_fields);
        formatter.field("facet_enabled", &self.facet_enabled);
        formatter.field("search_enabled", &self.search_enabled);
        formatter.field("return_enabled", &self.return_enabled);
        formatter.finish()
    }
}
/// See [`LiteralArrayOptions`](crate::model::LiteralArrayOptions)
pub mod literal_array_options {
    /// A builder for [`LiteralArrayOptions`](crate::model::LiteralArrayOptions)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) default_value: std::option::Option<std::string::String>,
        pub(crate) source_fields: std::option::Option<std::string::String>,
        pub(crate) facet_enabled: std::option::Option<bool>,
        pub(crate) search_enabled: std::option::Option<bool>,
        pub(crate) return_enabled: std::option::Option<bool>,
    }
    impl Builder {
        /// A value to use for the field if the field isn't specified for a document.
        pub fn default_value(mut self, input: impl Into<std::string::String>) -> Self {
            self.default_value = Some(input.into());
            self
        }
        /// A value to use for the field if the field isn't specified for a document.
        pub fn set_default_value(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.default_value = input;
            self
        }
        /// <p>A list of source fields to map to the field. </p>
        pub fn source_fields(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_fields = Some(input.into());
            self
        }
        /// <p>A list of source fields to map to the field. </p>
        pub fn set_source_fields(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.source_fields = input;
            self
        }
        /// <p>Whether facet information can be returned for the field.</p>
        pub fn facet_enabled(mut self, input: bool) -> Self {
            self.facet_enabled = Some(input);
            self
        }
        /// <p>Whether facet information can be returned for the field.</p>
        pub fn set_facet_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.facet_enabled = input;
            self
        }
        /// <p>Whether the contents of the field are searchable.</p>
        pub fn search_enabled(mut self, input: bool) -> Self {
            self.search_enabled = Some(input);
            self
        }
        /// <p>Whether the contents of the field are searchable.</p>
        pub fn set_search_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.search_enabled = input;
            self
        }
        /// <p>Whether the contents of the field can be returned in the search results.</p>
        pub fn return_enabled(mut self, input: bool) -> Self {
            self.return_enabled = Some(input);
            self
        }
        /// <p>Whether the contents of the field can be returned in the search results.</p>
        pub fn set_return_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.return_enabled = input;
            self
        }
        /// Consumes the builder and constructs a [`LiteralArrayOptions`](crate::model::LiteralArrayOptions)
        pub fn build(self) -> crate::model::LiteralArrayOptions {
            crate::model::LiteralArrayOptions {
                default_value: self.default_value,
                source_fields: self.source_fields,
                facet_enabled: self.facet_enabled,
                search_enabled: self.search_enabled,
                return_enabled: self.return_enabled,
            }
        }
    }
}
impl LiteralArrayOptions {
    /// Creates a new builder-style object to manufacture [`LiteralArrayOptions`](crate::model::LiteralArrayOptions)
    pub fn builder() -> crate::model::literal_array_options::Builder {
        crate::model::literal_array_options::Builder::default()
    }
}

/// <p>Options for a field that contains an array of double-precision 64-bit floating point values.  Present if <code>IndexFieldType</code> specifies the field is of type <code>double-array</code>.  All options are enabled by default.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DoubleArrayOptions {
    /// A value to use for the field if the field isn't specified for a document.
    pub default_value: std::option::Option<f64>,
    /// <p>A list of source fields to map to the field. </p>
    pub source_fields: std::option::Option<std::string::String>,
    /// <p>Whether facet information can be returned for the field.</p>
    pub facet_enabled: std::option::Option<bool>,
    /// <p>Whether the contents of the field are searchable.</p>
    pub search_enabled: std::option::Option<bool>,
    /// <p>Whether the contents of the field can be returned in the search results.</p>
    pub return_enabled: std::option::Option<bool>,
}
impl DoubleArrayOptions {
    /// A value to use for the field if the field isn't specified for a document.
    pub fn default_value(&self) -> std::option::Option<f64> {
        self.default_value
    }
    /// <p>A list of source fields to map to the field. </p>
    pub fn source_fields(&self) -> std::option::Option<&str> {
        self.source_fields.as_deref()
    }
    /// <p>Whether facet information can be returned for the field.</p>
    pub fn facet_enabled(&self) -> std::option::Option<bool> {
        self.facet_enabled
    }
    /// <p>Whether the contents of the field are searchable.</p>
    pub fn search_enabled(&self) -> std::option::Option<bool> {
        self.search_enabled
    }
    /// <p>Whether the contents of the field can be returned in the search results.</p>
    pub fn return_enabled(&self) -> std::option::Option<bool> {
        self.return_enabled
    }
}
impl std::fmt::Debug for DoubleArrayOptions {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DoubleArrayOptions");
        formatter.field("default_value", &self.default_value);
        formatter.field("source_fields", &self.source_fields);
        formatter.field("facet_enabled", &self.facet_enabled);
        formatter.field("search_enabled", &self.search_enabled);
        formatter.field("return_enabled", &self.return_enabled);
        formatter.finish()
    }
}
/// See [`DoubleArrayOptions`](crate::model::DoubleArrayOptions)
pub mod double_array_options {
    /// A builder for [`DoubleArrayOptions`](crate::model::DoubleArrayOptions)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) default_value: std::option::Option<f64>,
        pub(crate) source_fields: std::option::Option<std::string::String>,
        pub(crate) facet_enabled: std::option::Option<bool>,
        pub(crate) search_enabled: std::option::Option<bool>,
        pub(crate) return_enabled: std::option::Option<bool>,
    }
    impl Builder {
        /// A value to use for the field if the field isn't specified for a document.
        pub fn default_value(mut self, input: f64) -> Self {
            self.default_value = Some(input);
            self
        }
        /// A value to use for the field if the field isn't specified for a document.
        pub fn set_default_value(mut self, input: std::option::Option<f64>) -> Self {
            self.default_value = input;
            self
        }
        /// <p>A list of source fields to map to the field. </p>
        pub fn source_fields(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_fields = Some(input.into());
            self
        }
        /// <p>A list of source fields to map to the field. </p>
        pub fn set_source_fields(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.source_fields = input;
            self
        }
        /// <p>Whether facet information can be returned for the field.</p>
        pub fn facet_enabled(mut self, input: bool) -> Self {
            self.facet_enabled = Some(input);
            self
        }
        /// <p>Whether facet information can be returned for the field.</p>
        pub fn set_facet_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.facet_enabled = input;
            self
        }
        /// <p>Whether the contents of the field are searchable.</p>
        pub fn search_enabled(mut self, input: bool) -> Self {
            self.search_enabled = Some(input);
            self
        }
        /// <p>Whether the contents of the field are searchable.</p>
        pub fn set_search_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.search_enabled = input;
            self
        }
        /// <p>Whether the contents of the field can be returned in the search results.</p>
        pub fn return_enabled(mut self, input: bool) -> Self {
            self.return_enabled = Some(input);
            self
        }
        /// <p>Whether the contents of the field can be returned in the search results.</p>
        pub fn set_return_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.return_enabled = input;
            self
        }
        /// Consumes the builder and constructs a [`DoubleArrayOptions`](crate::model::DoubleArrayOptions)
        pub fn build(self) -> crate::model::DoubleArrayOptions {
            crate::model::DoubleArrayOptions {
                default_value: self.default_value,
                source_fields: self.source_fields,
                facet_enabled: self.facet_enabled,
                search_enabled: self.search_enabled,
                return_enabled: self.return_enabled,
            }
        }
    }
}
impl DoubleArrayOptions {
    /// Creates a new builder-style object to manufacture [`DoubleArrayOptions`](crate::model::DoubleArrayOptions)
    pub fn builder() -> crate::model::double_array_options::Builder {
        crate::model::double_array_options::Builder::default()
    }
}

/// <p>Options for a field that contains an array of 64-bit signed integers.  Present if <code>IndexFieldType</code> specifies the field is of type <code>int-array</code>. All options are enabled by default.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct IntArrayOptions {
    /// A value to use for the field if the field isn't specified for a document.
    pub default_value: std::option::Option<i64>,
    /// <p>A list of source fields to map to the field. </p>
    pub source_fields: std::option::Option<std::string::String>,
    /// <p>Whether facet information can be returned for the field.</p>
    pub facet_enabled: std::option::Option<bool>,
    /// <p>Whether the contents of the field are searchable.</p>
    pub search_enabled: std::option::Option<bool>,
    /// <p>Whether the contents of the field can be returned in the search results.</p>
    pub return_enabled: std::option::Option<bool>,
}
impl IntArrayOptions {
    /// A value to use for the field if the field isn't specified for a document.
    pub fn default_value(&self) -> std::option::Option<i64> {
        self.default_value
    }
    /// <p>A list of source fields to map to the field. </p>
    pub fn source_fields(&self) -> std::option::Option<&str> {
        self.source_fields.as_deref()
    }
    /// <p>Whether facet information can be returned for the field.</p>
    pub fn facet_enabled(&self) -> std::option::Option<bool> {
        self.facet_enabled
    }
    /// <p>Whether the contents of the field are searchable.</p>
    pub fn search_enabled(&self) -> std::option::Option<bool> {
        self.search_enabled
    }
    /// <p>Whether the contents of the field can be returned in the search results.</p>
    pub fn return_enabled(&self) -> std::option::Option<bool> {
        self.return_enabled
    }
}
impl std::fmt::Debug for IntArrayOptions {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("IntArrayOptions");
        formatter.field("default_value", &self.default_value);
        formatter.field("source_fields", &self.source_fields);
        formatter.field("facet_enabled", &self.facet_enabled);
        formatter.field("search_enabled", &self.search_enabled);
        formatter.field("return_enabled", &self.return_enabled);
        formatter.finish()
    }
}
/// See [`IntArrayOptions`](crate::model::IntArrayOptions)
pub mod int_array_options {
    /// A builder for [`IntArrayOptions`](crate::model::IntArrayOptions)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) default_value: std::option::Option<i64>,
        pub(crate) source_fields: std::option::Option<std::string::String>,
        pub(crate) facet_enabled: std::option::Option<bool>,
        pub(crate) search_enabled: std::option::Option<bool>,
        pub(crate) return_enabled: std::option::Option<bool>,
    }
    impl Builder {
        /// A value to use for the field if the field isn't specified for a document.
        pub fn default_value(mut self, input: i64) -> Self {
            self.default_value = Some(input);
            self
        }
        /// A value to use for the field if the field isn't specified for a document.
        pub fn set_default_value(mut self, input: std::option::Option<i64>) -> Self {
            self.default_value = input;
            self
        }
        /// <p>A list of source fields to map to the field. </p>
        pub fn source_fields(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_fields = Some(input.into());
            self
        }
        /// <p>A list of source fields to map to the field. </p>
        pub fn set_source_fields(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.source_fields = input;
            self
        }
        /// <p>Whether facet information can be returned for the field.</p>
        pub fn facet_enabled(mut self, input: bool) -> Self {
            self.facet_enabled = Some(input);
            self
        }
        /// <p>Whether facet information can be returned for the field.</p>
        pub fn set_facet_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.facet_enabled = input;
            self
        }
        /// <p>Whether the contents of the field are searchable.</p>
        pub fn search_enabled(mut self, input: bool) -> Self {
            self.search_enabled = Some(input);
            self
        }
        /// <p>Whether the contents of the field are searchable.</p>
        pub fn set_search_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.search_enabled = input;
            self
        }
        /// <p>Whether the contents of the field can be returned in the search results.</p>
        pub fn return_enabled(mut self, input: bool) -> Self {
            self.return_enabled = Some(input);
            self
        }
        /// <p>Whether the contents of the field can be returned in the search results.</p>
        pub fn set_return_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.return_enabled = input;
            self
        }
        /// Consumes the builder and constructs a [`IntArrayOptions`](crate::model::IntArrayOptions)
        pub fn build(self) -> crate::model::IntArrayOptions {
            crate::model::IntArrayOptions {
                default_value: self.default_value,
                source_fields: self.source_fields,
                facet_enabled: self.facet_enabled,
                search_enabled: self.search_enabled,
                return_enabled: self.return_enabled,
            }
        }
    }
}
impl IntArrayOptions {
    /// Creates a new builder-style object to manufacture [`IntArrayOptions`](crate::model::IntArrayOptions)
    pub fn builder() -> crate::model::int_array_options::Builder {
        crate::model::int_array_options::Builder::default()
    }
}

/// <p>Options for a latlon field. A latlon field contains a location stored as a latitude and longitude value pair. Present if <code>IndexFieldType</code> specifies the field is of type <code>latlon</code>. All options are enabled by default.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LatLonOptions {
    /// A value to use for the field if the field isn't specified for a document.
    pub default_value: std::option::Option<std::string::String>,
    /// <p>A string that represents the name of an index field. CloudSearch supports regular index fields as well as dynamic fields.
    /// A dynamic field's name defines a pattern that begins or ends with a wildcard.
    /// Any document fields that don't map to a regular index field but do match a  
    /// dynamic field's pattern are configured with the dynamic field's indexing options.
    /// </p>
    /// <p>Regular field names begin with a letter and can contain the following characters:
    /// a-z (lowercase), 0-9, and _ (underscore).
    /// Dynamic field names must begin or end with a wildcard (*).
    /// The wildcard can also be the only character in a dynamic field name.
    /// Multiple wildcards, and wildcards embedded within a string are not supported.
    /// </p>
    /// <p>The name <code>score</code> is reserved and cannot be used as a field name.
    /// To reference a document's ID, you can use the name <code>_id</code>.
    /// </p>
    pub source_field: std::option::Option<std::string::String>,
    /// <p>Whether facet information can be returned for the field.</p>
    pub facet_enabled: std::option::Option<bool>,
    /// <p>Whether the contents of the field are searchable.</p>
    pub search_enabled: std::option::Option<bool>,
    /// <p>Whether the contents of the field can be returned in the search results.</p>
    pub return_enabled: std::option::Option<bool>,
    /// <p>Whether the field can be used to sort the search results.</p>
    pub sort_enabled: std::option::Option<bool>,
}
impl LatLonOptions {
    /// A value to use for the field if the field isn't specified for a document.
    pub fn default_value(&self) -> std::option::Option<&str> {
        self.default_value.as_deref()
    }
    /// <p>A string that represents the name of an index field. CloudSearch supports regular index fields as well as dynamic fields.
    /// A dynamic field's name defines a pattern that begins or ends with a wildcard.
    /// Any document fields that don't map to a regular index field but do match a  
    /// dynamic field's pattern are configured with the dynamic field's indexing options.
    /// </p>
    /// <p>Regular field names begin with a letter and can contain the following characters:
    /// a-z (lowercase), 0-9, and _ (underscore).
    /// Dynamic field names must begin or end with a wildcard (*).
    /// The wildcard can also be the only character in a dynamic field name.
    /// Multiple wildcards, and wildcards embedded within a string are not supported.
    /// </p>
    /// <p>The name <code>score</code> is reserved and cannot be used as a field name.
    /// To reference a document's ID, you can use the name <code>_id</code>.
    /// </p>
    pub fn source_field(&self) -> std::option::Option<&str> {
        self.source_field.as_deref()
    }
    /// <p>Whether facet information can be returned for the field.</p>
    pub fn facet_enabled(&self) -> std::option::Option<bool> {
        self.facet_enabled
    }
    /// <p>Whether the contents of the field are searchable.</p>
    pub fn search_enabled(&self) -> std::option::Option<bool> {
        self.search_enabled
    }
    /// <p>Whether the contents of the field can be returned in the search results.</p>
    pub fn return_enabled(&self) -> std::option::Option<bool> {
        self.return_enabled
    }
    /// <p>Whether the field can be used to sort the search results.</p>
    pub fn sort_enabled(&self) -> std::option::Option<bool> {
        self.sort_enabled
    }
}
impl std::fmt::Debug for LatLonOptions {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LatLonOptions");
        formatter.field("default_value", &self.default_value);
        formatter.field("source_field", &self.source_field);
        formatter.field("facet_enabled", &self.facet_enabled);
        formatter.field("search_enabled", &self.search_enabled);
        formatter.field("return_enabled", &self.return_enabled);
        formatter.field("sort_enabled", &self.sort_enabled);
        formatter.finish()
    }
}
/// See [`LatLonOptions`](crate::model::LatLonOptions)
pub mod lat_lon_options {
    /// A builder for [`LatLonOptions`](crate::model::LatLonOptions)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) default_value: std::option::Option<std::string::String>,
        pub(crate) source_field: std::option::Option<std::string::String>,
        pub(crate) facet_enabled: std::option::Option<bool>,
        pub(crate) search_enabled: std::option::Option<bool>,
        pub(crate) return_enabled: std::option::Option<bool>,
        pub(crate) sort_enabled: std::option::Option<bool>,
    }
    impl Builder {
        /// A value to use for the field if the field isn't specified for a document.
        pub fn default_value(mut self, input: impl Into<std::string::String>) -> Self {
            self.default_value = Some(input.into());
            self
        }
        /// A value to use for the field if the field isn't specified for a document.
        pub fn set_default_value(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.default_value = input;
            self
        }
        /// <p>A string that represents the name of an index field. CloudSearch supports regular index fields as well as dynamic fields.
        /// A dynamic field's name defines a pattern that begins or ends with a wildcard.
        /// Any document fields that don't map to a regular index field but do match a  
        /// dynamic field's pattern are configured with the dynamic field's indexing options.
        /// </p>
        /// <p>Regular field names begin with a letter and can contain the following characters:
        /// a-z (lowercase), 0-9, and _ (underscore).
        /// Dynamic field names must begin or end with a wildcard (*).
        /// The wildcard can also be the only character in a dynamic field name.
        /// Multiple wildcards, and wildcards embedded within a string are not supported.
        /// </p>
        /// <p>The name <code>score</code> is reserved and cannot be used as a field name.
        /// To reference a document's ID, you can use the name <code>_id</code>.
        /// </p>
        pub fn source_field(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_field = Some(input.into());
            self
        }
        /// <p>A string that represents the name of an index field. CloudSearch supports regular index fields as well as dynamic fields.
        /// A dynamic field's name defines a pattern that begins or ends with a wildcard.
        /// Any document fields that don't map to a regular index field but do match a  
        /// dynamic field's pattern are configured with the dynamic field's indexing options.
        /// </p>
        /// <p>Regular field names begin with a letter and can contain the following characters:
        /// a-z (lowercase), 0-9, and _ (underscore).
        /// Dynamic field names must begin or end with a wildcard (*).
        /// The wildcard can also be the only character in a dynamic field name.
        /// Multiple wildcards, and wildcards embedded within a string are not supported.
        /// </p>
        /// <p>The name <code>score</code> is reserved and cannot be used as a field name.
        /// To reference a document's ID, you can use the name <code>_id</code>.
        /// </p>
        pub fn set_source_field(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.source_field = input;
            self
        }
        /// <p>Whether facet information can be returned for the field.</p>
        pub fn facet_enabled(mut self, input: bool) -> Self {
            self.facet_enabled = Some(input);
            self
        }
        /// <p>Whether facet information can be returned for the field.</p>
        pub fn set_facet_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.facet_enabled = input;
            self
        }
        /// <p>Whether the contents of the field are searchable.</p>
        pub fn search_enabled(mut self, input: bool) -> Self {
            self.search_enabled = Some(input);
            self
        }
        /// <p>Whether the contents of the field are searchable.</p>
        pub fn set_search_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.search_enabled = input;
            self
        }
        /// <p>Whether the contents of the field can be returned in the search results.</p>
        pub fn return_enabled(mut self, input: bool) -> Self {
            self.return_enabled = Some(input);
            self
        }
        /// <p>Whether the contents of the field can be returned in the search results.</p>
        pub fn set_return_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.return_enabled = input;
            self
        }
        /// <p>Whether the field can be used to sort the search results.</p>
        pub fn sort_enabled(mut self, input: bool) -> Self {
            self.sort_enabled = Some(input);
            self
        }
        /// <p>Whether the field can be used to sort the search results.</p>
        pub fn set_sort_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.sort_enabled = input;
            self
        }
        /// Consumes the builder and constructs a [`LatLonOptions`](crate::model::LatLonOptions)
        pub fn build(self) -> crate::model::LatLonOptions {
            crate::model::LatLonOptions {
                default_value: self.default_value,
                source_field: self.source_field,
                facet_enabled: self.facet_enabled,
                search_enabled: self.search_enabled,
                return_enabled: self.return_enabled,
                sort_enabled: self.sort_enabled,
            }
        }
    }
}
impl LatLonOptions {
    /// Creates a new builder-style object to manufacture [`LatLonOptions`](crate::model::LatLonOptions)
    pub fn builder() -> crate::model::lat_lon_options::Builder {
        crate::model::lat_lon_options::Builder::default()
    }
}

/// <p>Options for a date field. Dates and times are specified in UTC (Coordinated Universal Time) according to IETF RFC3339: yyyy-mm-ddT00:00:00Z.  Present if <code>IndexFieldType</code> specifies the field is of type <code>date</code>. All options are enabled by default.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DateOptions {
    /// A value to use for the field if the field isn't specified for a document.
    pub default_value: std::option::Option<std::string::String>,
    /// <p>A string that represents the name of an index field. CloudSearch supports regular index fields as well as dynamic fields.
    /// A dynamic field's name defines a pattern that begins or ends with a wildcard.
    /// Any document fields that don't map to a regular index field but do match a  
    /// dynamic field's pattern are configured with the dynamic field's indexing options.
    /// </p>
    /// <p>Regular field names begin with a letter and can contain the following characters:
    /// a-z (lowercase), 0-9, and _ (underscore).
    /// Dynamic field names must begin or end with a wildcard (*).
    /// The wildcard can also be the only character in a dynamic field name.
    /// Multiple wildcards, and wildcards embedded within a string are not supported.
    /// </p>
    /// <p>The name <code>score</code> is reserved and cannot be used as a field name.
    /// To reference a document's ID, you can use the name <code>_id</code>.
    /// </p>
    pub source_field: std::option::Option<std::string::String>,
    /// <p>Whether facet information can be returned for the field.</p>
    pub facet_enabled: std::option::Option<bool>,
    /// <p>Whether the contents of the field are searchable.</p>
    pub search_enabled: std::option::Option<bool>,
    /// <p>Whether the contents of the field can be returned in the search results.</p>
    pub return_enabled: std::option::Option<bool>,
    /// <p>Whether the field can be used to sort the search results.</p>
    pub sort_enabled: std::option::Option<bool>,
}
impl DateOptions {
    /// A value to use for the field if the field isn't specified for a document.
    pub fn default_value(&self) -> std::option::Option<&str> {
        self.default_value.as_deref()
    }
    /// <p>A string that represents the name of an index field. CloudSearch supports regular index fields as well as dynamic fields.
    /// A dynamic field's name defines a pattern that begins or ends with a wildcard.
    /// Any document fields that don't map to a regular index field but do match a  
    /// dynamic field's pattern are configured with the dynamic field's indexing options.
    /// </p>
    /// <p>Regular field names begin with a letter and can contain the following characters:
    /// a-z (lowercase), 0-9, and _ (underscore).
    /// Dynamic field names must begin or end with a wildcard (*).
    /// The wildcard can also be the only character in a dynamic field name.
    /// Multiple wildcards, and wildcards embedded within a string are not supported.
    /// </p>
    /// <p>The name <code>score</code> is reserved and cannot be used as a field name.
    /// To reference a document's ID, you can use the name <code>_id</code>.
    /// </p>
    pub fn source_field(&self) -> std::option::Option<&str> {
        self.source_field.as_deref()
    }
    /// <p>Whether facet information can be returned for the field.</p>
    pub fn facet_enabled(&self) -> std::option::Option<bool> {
        self.facet_enabled
    }
    /// <p>Whether the contents of the field are searchable.</p>
    pub fn search_enabled(&self) -> std::option::Option<bool> {
        self.search_enabled
    }
    /// <p>Whether the contents of the field can be returned in the search results.</p>
    pub fn return_enabled(&self) -> std::option::Option<bool> {
        self.return_enabled
    }
    /// <p>Whether the field can be used to sort the search results.</p>
    pub fn sort_enabled(&self) -> std::option::Option<bool> {
        self.sort_enabled
    }
}
impl std::fmt::Debug for DateOptions {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DateOptions");
        formatter.field("default_value", &self.default_value);
        formatter.field("source_field", &self.source_field);
        formatter.field("facet_enabled", &self.facet_enabled);
        formatter.field("search_enabled", &self.search_enabled);
        formatter.field("return_enabled", &self.return_enabled);
        formatter.field("sort_enabled", &self.sort_enabled);
        formatter.finish()
    }
}
/// See [`DateOptions`](crate::model::DateOptions)
pub mod date_options {
    /// A builder for [`DateOptions`](crate::model::DateOptions)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) default_value: std::option::Option<std::string::String>,
        pub(crate) source_field: std::option::Option<std::string::String>,
        pub(crate) facet_enabled: std::option::Option<bool>,
        pub(crate) search_enabled: std::option::Option<bool>,
        pub(crate) return_enabled: std::option::Option<bool>,
        pub(crate) sort_enabled: std::option::Option<bool>,
    }
    impl Builder {
        /// A value to use for the field if the field isn't specified for a document.
        pub fn default_value(mut self, input: impl Into<std::string::String>) -> Self {
            self.default_value = Some(input.into());
            self
        }
        /// A value to use for the field if the field isn't specified for a document.
        pub fn set_default_value(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.default_value = input;
            self
        }
        /// <p>A string that represents the name of an index field. CloudSearch supports regular index fields as well as dynamic fields.
        /// A dynamic field's name defines a pattern that begins or ends with a wildcard.
        /// Any document fields that don't map to a regular index field but do match a  
        /// dynamic field's pattern are configured with the dynamic field's indexing options.
        /// </p>
        /// <p>Regular field names begin with a letter and can contain the following characters:
        /// a-z (lowercase), 0-9, and _ (underscore).
        /// Dynamic field names must begin or end with a wildcard (*).
        /// The wildcard can also be the only character in a dynamic field name.
        /// Multiple wildcards, and wildcards embedded within a string are not supported.
        /// </p>
        /// <p>The name <code>score</code> is reserved and cannot be used as a field name.
        /// To reference a document's ID, you can use the name <code>_id</code>.
        /// </p>
        pub fn source_field(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_field = Some(input.into());
            self
        }
        /// <p>A string that represents the name of an index field. CloudSearch supports regular index fields as well as dynamic fields.
        /// A dynamic field's name defines a pattern that begins or ends with a wildcard.
        /// Any document fields that don't map to a regular index field but do match a  
        /// dynamic field's pattern are configured with the dynamic field's indexing options.
        /// </p>
        /// <p>Regular field names begin with a letter and can contain the following characters:
        /// a-z (lowercase), 0-9, and _ (underscore).
        /// Dynamic field names must begin or end with a wildcard (*).
        /// The wildcard can also be the only character in a dynamic field name.
        /// Multiple wildcards, and wildcards embedded within a string are not supported.
        /// </p>
        /// <p>The name <code>score</code> is reserved and cannot be used as a field name.
        /// To reference a document's ID, you can use the name <code>_id</code>.
        /// </p>
        pub fn set_source_field(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.source_field = input;
            self
        }
        /// <p>Whether facet information can be returned for the field.</p>
        pub fn facet_enabled(mut self, input: bool) -> Self {
            self.facet_enabled = Some(input);
            self
        }
        /// <p>Whether facet information can be returned for the field.</p>
        pub fn set_facet_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.facet_enabled = input;
            self
        }
        /// <p>Whether the contents of the field are searchable.</p>
        pub fn search_enabled(mut self, input: bool) -> Self {
            self.search_enabled = Some(input);
            self
        }
        /// <p>Whether the contents of the field are searchable.</p>
        pub fn set_search_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.search_enabled = input;
            self
        }
        /// <p>Whether the contents of the field can be returned in the search results.</p>
        pub fn return_enabled(mut self, input: bool) -> Self {
            self.return_enabled = Some(input);
            self
        }
        /// <p>Whether the contents of the field can be returned in the search results.</p>
        pub fn set_return_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.return_enabled = input;
            self
        }
        /// <p>Whether the field can be used to sort the search results.</p>
        pub fn sort_enabled(mut self, input: bool) -> Self {
            self.sort_enabled = Some(input);
            self
        }
        /// <p>Whether the field can be used to sort the search results.</p>
        pub fn set_sort_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.sort_enabled = input;
            self
        }
        /// Consumes the builder and constructs a [`DateOptions`](crate::model::DateOptions)
        pub fn build(self) -> crate::model::DateOptions {
            crate::model::DateOptions {
                default_value: self.default_value,
                source_field: self.source_field,
                facet_enabled: self.facet_enabled,
                search_enabled: self.search_enabled,
                return_enabled: self.return_enabled,
                sort_enabled: self.sort_enabled,
            }
        }
    }
}
impl DateOptions {
    /// Creates a new builder-style object to manufacture [`DateOptions`](crate::model::DateOptions)
    pub fn builder() -> crate::model::date_options::Builder {
        crate::model::date_options::Builder::default()
    }
}

/// <p>Options for text field.  Present if <code>IndexFieldType</code> specifies the field is of type <code>text</code>. A <code>text</code> field is always searchable. All options are enabled by default.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TextOptions {
    /// A value to use for the field if the field isn't specified for a document.
    pub default_value: std::option::Option<std::string::String>,
    /// <p>A string that represents the name of an index field. CloudSearch supports regular index fields as well as dynamic fields.
    /// A dynamic field's name defines a pattern that begins or ends with a wildcard.
    /// Any document fields that don't map to a regular index field but do match a  
    /// dynamic field's pattern are configured with the dynamic field's indexing options.
    /// </p>
    /// <p>Regular field names begin with a letter and can contain the following characters:
    /// a-z (lowercase), 0-9, and _ (underscore).
    /// Dynamic field names must begin or end with a wildcard (*).
    /// The wildcard can also be the only character in a dynamic field name.
    /// Multiple wildcards, and wildcards embedded within a string are not supported.
    /// </p>
    /// <p>The name <code>score</code> is reserved and cannot be used as a field name.
    /// To reference a document's ID, you can use the name <code>_id</code>.
    /// </p>
    pub source_field: std::option::Option<std::string::String>,
    /// <p>Whether the contents of the field can be returned in the search results.</p>
    pub return_enabled: std::option::Option<bool>,
    /// <p>Whether the field can be used to sort the search results.</p>
    pub sort_enabled: std::option::Option<bool>,
    /// <p>Whether highlights can be returned for the field.</p>
    pub highlight_enabled: std::option::Option<bool>,
    /// <p>The name of an analysis scheme for a  <code>text</code> field.</p>
    pub analysis_scheme: std::option::Option<std::string::String>,
}
impl TextOptions {
    /// A value to use for the field if the field isn't specified for a document.
    pub fn default_value(&self) -> std::option::Option<&str> {
        self.default_value.as_deref()
    }
    /// <p>A string that represents the name of an index field. CloudSearch supports regular index fields as well as dynamic fields.
    /// A dynamic field's name defines a pattern that begins or ends with a wildcard.
    /// Any document fields that don't map to a regular index field but do match a  
    /// dynamic field's pattern are configured with the dynamic field's indexing options.
    /// </p>
    /// <p>Regular field names begin with a letter and can contain the following characters:
    /// a-z (lowercase), 0-9, and _ (underscore).
    /// Dynamic field names must begin or end with a wildcard (*).
    /// The wildcard can also be the only character in a dynamic field name.
    /// Multiple wildcards, and wildcards embedded within a string are not supported.
    /// </p>
    /// <p>The name <code>score</code> is reserved and cannot be used as a field name.
    /// To reference a document's ID, you can use the name <code>_id</code>.
    /// </p>
    pub fn source_field(&self) -> std::option::Option<&str> {
        self.source_field.as_deref()
    }
    /// <p>Whether the contents of the field can be returned in the search results.</p>
    pub fn return_enabled(&self) -> std::option::Option<bool> {
        self.return_enabled
    }
    /// <p>Whether the field can be used to sort the search results.</p>
    pub fn sort_enabled(&self) -> std::option::Option<bool> {
        self.sort_enabled
    }
    /// <p>Whether highlights can be returned for the field.</p>
    pub fn highlight_enabled(&self) -> std::option::Option<bool> {
        self.highlight_enabled
    }
    /// <p>The name of an analysis scheme for a  <code>text</code> field.</p>
    pub fn analysis_scheme(&self) -> std::option::Option<&str> {
        self.analysis_scheme.as_deref()
    }
}
impl std::fmt::Debug for TextOptions {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TextOptions");
        formatter.field("default_value", &self.default_value);
        formatter.field("source_field", &self.source_field);
        formatter.field("return_enabled", &self.return_enabled);
        formatter.field("sort_enabled", &self.sort_enabled);
        formatter.field("highlight_enabled", &self.highlight_enabled);
        formatter.field("analysis_scheme", &self.analysis_scheme);
        formatter.finish()
    }
}
/// See [`TextOptions`](crate::model::TextOptions)
pub mod text_options {
    /// A builder for [`TextOptions`](crate::model::TextOptions)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) default_value: std::option::Option<std::string::String>,
        pub(crate) source_field: std::option::Option<std::string::String>,
        pub(crate) return_enabled: std::option::Option<bool>,
        pub(crate) sort_enabled: std::option::Option<bool>,
        pub(crate) highlight_enabled: std::option::Option<bool>,
        pub(crate) analysis_scheme: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// A value to use for the field if the field isn't specified for a document.
        pub fn default_value(mut self, input: impl Into<std::string::String>) -> Self {
            self.default_value = Some(input.into());
            self
        }
        /// A value to use for the field if the field isn't specified for a document.
        pub fn set_default_value(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.default_value = input;
            self
        }
        /// <p>A string that represents the name of an index field. CloudSearch supports regular index fields as well as dynamic fields.
        /// A dynamic field's name defines a pattern that begins or ends with a wildcard.
        /// Any document fields that don't map to a regular index field but do match a  
        /// dynamic field's pattern are configured with the dynamic field's indexing options.
        /// </p>
        /// <p>Regular field names begin with a letter and can contain the following characters:
        /// a-z (lowercase), 0-9, and _ (underscore).
        /// Dynamic field names must begin or end with a wildcard (*).
        /// The wildcard can also be the only character in a dynamic field name.
        /// Multiple wildcards, and wildcards embedded within a string are not supported.
        /// </p>
        /// <p>The name <code>score</code> is reserved and cannot be used as a field name.
        /// To reference a document's ID, you can use the name <code>_id</code>.
        /// </p>
        pub fn source_field(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_field = Some(input.into());
            self
        }
        /// <p>A string that represents the name of an index field. CloudSearch supports regular index fields as well as dynamic fields.
        /// A dynamic field's name defines a pattern that begins or ends with a wildcard.
        /// Any document fields that don't map to a regular index field but do match a  
        /// dynamic field's pattern are configured with the dynamic field's indexing options.
        /// </p>
        /// <p>Regular field names begin with a letter and can contain the following characters:
        /// a-z (lowercase), 0-9, and _ (underscore).
        /// Dynamic field names must begin or end with a wildcard (*).
        /// The wildcard can also be the only character in a dynamic field name.
        /// Multiple wildcards, and wildcards embedded within a string are not supported.
        /// </p>
        /// <p>The name <code>score</code> is reserved and cannot be used as a field name.
        /// To reference a document's ID, you can use the name <code>_id</code>.
        /// </p>
        pub fn set_source_field(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.source_field = input;
            self
        }
        /// <p>Whether the contents of the field can be returned in the search results.</p>
        pub fn return_enabled(mut self, input: bool) -> Self {
            self.return_enabled = Some(input);
            self
        }
        /// <p>Whether the contents of the field can be returned in the search results.</p>
        pub fn set_return_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.return_enabled = input;
            self
        }
        /// <p>Whether the field can be used to sort the search results.</p>
        pub fn sort_enabled(mut self, input: bool) -> Self {
            self.sort_enabled = Some(input);
            self
        }
        /// <p>Whether the field can be used to sort the search results.</p>
        pub fn set_sort_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.sort_enabled = input;
            self
        }
        /// <p>Whether highlights can be returned for the field.</p>
        pub fn highlight_enabled(mut self, input: bool) -> Self {
            self.highlight_enabled = Some(input);
            self
        }
        /// <p>Whether highlights can be returned for the field.</p>
        pub fn set_highlight_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.highlight_enabled = input;
            self
        }
        /// <p>The name of an analysis scheme for a  <code>text</code> field.</p>
        pub fn analysis_scheme(mut self, input: impl Into<std::string::String>) -> Self {
            self.analysis_scheme = Some(input.into());
            self
        }
        /// <p>The name of an analysis scheme for a  <code>text</code> field.</p>
        pub fn set_analysis_scheme(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.analysis_scheme = input;
            self
        }
        /// Consumes the builder and constructs a [`TextOptions`](crate::model::TextOptions)
        pub fn build(self) -> crate::model::TextOptions {
            crate::model::TextOptions {
                default_value: self.default_value,
                source_field: self.source_field,
                return_enabled: self.return_enabled,
                sort_enabled: self.sort_enabled,
                highlight_enabled: self.highlight_enabled,
                analysis_scheme: self.analysis_scheme,
            }
        }
    }
}
impl TextOptions {
    /// Creates a new builder-style object to manufacture [`TextOptions`](crate::model::TextOptions)
    pub fn builder() -> crate::model::text_options::Builder {
        crate::model::text_options::Builder::default()
    }
}

/// <p>Options for literal field.  Present if <code>IndexFieldType</code> specifies the field is of type <code>literal</code>. All options are enabled by default.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LiteralOptions {
    /// A value to use for the field if the field isn't specified for a document.
    pub default_value: std::option::Option<std::string::String>,
    /// <p>A string that represents the name of an index field. CloudSearch supports regular index fields as well as dynamic fields.
    /// A dynamic field's name defines a pattern that begins or ends with a wildcard.
    /// Any document fields that don't map to a regular index field but do match a  
    /// dynamic field's pattern are configured with the dynamic field's indexing options.
    /// </p>
    /// <p>Regular field names begin with a letter and can contain the following characters:
    /// a-z (lowercase), 0-9, and _ (underscore).
    /// Dynamic field names must begin or end with a wildcard (*).
    /// The wildcard can also be the only character in a dynamic field name.
    /// Multiple wildcards, and wildcards embedded within a string are not supported.
    /// </p>
    /// <p>The name <code>score</code> is reserved and cannot be used as a field name.
    /// To reference a document's ID, you can use the name <code>_id</code>.
    /// </p>
    pub source_field: std::option::Option<std::string::String>,
    /// <p>Whether facet information can be returned for the field.</p>
    pub facet_enabled: std::option::Option<bool>,
    /// <p>Whether the contents of the field are searchable.</p>
    pub search_enabled: std::option::Option<bool>,
    /// <p>Whether the contents of the field can be returned in the search results.</p>
    pub return_enabled: std::option::Option<bool>,
    /// <p>Whether the field can be used to sort the search results.</p>
    pub sort_enabled: std::option::Option<bool>,
}
impl LiteralOptions {
    /// A value to use for the field if the field isn't specified for a document.
    pub fn default_value(&self) -> std::option::Option<&str> {
        self.default_value.as_deref()
    }
    /// <p>A string that represents the name of an index field. CloudSearch supports regular index fields as well as dynamic fields.
    /// A dynamic field's name defines a pattern that begins or ends with a wildcard.
    /// Any document fields that don't map to a regular index field but do match a  
    /// dynamic field's pattern are configured with the dynamic field's indexing options.
    /// </p>
    /// <p>Regular field names begin with a letter and can contain the following characters:
    /// a-z (lowercase), 0-9, and _ (underscore).
    /// Dynamic field names must begin or end with a wildcard (*).
    /// The wildcard can also be the only character in a dynamic field name.
    /// Multiple wildcards, and wildcards embedded within a string are not supported.
    /// </p>
    /// <p>The name <code>score</code> is reserved and cannot be used as a field name.
    /// To reference a document's ID, you can use the name <code>_id</code>.
    /// </p>
    pub fn source_field(&self) -> std::option::Option<&str> {
        self.source_field.as_deref()
    }
    /// <p>Whether facet information can be returned for the field.</p>
    pub fn facet_enabled(&self) -> std::option::Option<bool> {
        self.facet_enabled
    }
    /// <p>Whether the contents of the field are searchable.</p>
    pub fn search_enabled(&self) -> std::option::Option<bool> {
        self.search_enabled
    }
    /// <p>Whether the contents of the field can be returned in the search results.</p>
    pub fn return_enabled(&self) -> std::option::Option<bool> {
        self.return_enabled
    }
    /// <p>Whether the field can be used to sort the search results.</p>
    pub fn sort_enabled(&self) -> std::option::Option<bool> {
        self.sort_enabled
    }
}
impl std::fmt::Debug for LiteralOptions {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LiteralOptions");
        formatter.field("default_value", &self.default_value);
        formatter.field("source_field", &self.source_field);
        formatter.field("facet_enabled", &self.facet_enabled);
        formatter.field("search_enabled", &self.search_enabled);
        formatter.field("return_enabled", &self.return_enabled);
        formatter.field("sort_enabled", &self.sort_enabled);
        formatter.finish()
    }
}
/// See [`LiteralOptions`](crate::model::LiteralOptions)
pub mod literal_options {
    /// A builder for [`LiteralOptions`](crate::model::LiteralOptions)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) default_value: std::option::Option<std::string::String>,
        pub(crate) source_field: std::option::Option<std::string::String>,
        pub(crate) facet_enabled: std::option::Option<bool>,
        pub(crate) search_enabled: std::option::Option<bool>,
        pub(crate) return_enabled: std::option::Option<bool>,
        pub(crate) sort_enabled: std::option::Option<bool>,
    }
    impl Builder {
        /// A value to use for the field if the field isn't specified for a document.
        pub fn default_value(mut self, input: impl Into<std::string::String>) -> Self {
            self.default_value = Some(input.into());
            self
        }
        /// A value to use for the field if the field isn't specified for a document.
        pub fn set_default_value(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.default_value = input;
            self
        }
        /// <p>A string that represents the name of an index field. CloudSearch supports regular index fields as well as dynamic fields.
        /// A dynamic field's name defines a pattern that begins or ends with a wildcard.
        /// Any document fields that don't map to a regular index field but do match a  
        /// dynamic field's pattern are configured with the dynamic field's indexing options.
        /// </p>
        /// <p>Regular field names begin with a letter and can contain the following characters:
        /// a-z (lowercase), 0-9, and _ (underscore).
        /// Dynamic field names must begin or end with a wildcard (*).
        /// The wildcard can also be the only character in a dynamic field name.
        /// Multiple wildcards, and wildcards embedded within a string are not supported.
        /// </p>
        /// <p>The name <code>score</code> is reserved and cannot be used as a field name.
        /// To reference a document's ID, you can use the name <code>_id</code>.
        /// </p>
        pub fn source_field(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_field = Some(input.into());
            self
        }
        /// <p>A string that represents the name of an index field. CloudSearch supports regular index fields as well as dynamic fields.
        /// A dynamic field's name defines a pattern that begins or ends with a wildcard.
        /// Any document fields that don't map to a regular index field but do match a  
        /// dynamic field's pattern are configured with the dynamic field's indexing options.
        /// </p>
        /// <p>Regular field names begin with a letter and can contain the following characters:
        /// a-z (lowercase), 0-9, and _ (underscore).
        /// Dynamic field names must begin or end with a wildcard (*).
        /// The wildcard can also be the only character in a dynamic field name.
        /// Multiple wildcards, and wildcards embedded within a string are not supported.
        /// </p>
        /// <p>The name <code>score</code> is reserved and cannot be used as a field name.
        /// To reference a document's ID, you can use the name <code>_id</code>.
        /// </p>
        pub fn set_source_field(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.source_field = input;
            self
        }
        /// <p>Whether facet information can be returned for the field.</p>
        pub fn facet_enabled(mut self, input: bool) -> Self {
            self.facet_enabled = Some(input);
            self
        }
        /// <p>Whether facet information can be returned for the field.</p>
        pub fn set_facet_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.facet_enabled = input;
            self
        }
        /// <p>Whether the contents of the field are searchable.</p>
        pub fn search_enabled(mut self, input: bool) -> Self {
            self.search_enabled = Some(input);
            self
        }
        /// <p>Whether the contents of the field are searchable.</p>
        pub fn set_search_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.search_enabled = input;
            self
        }
        /// <p>Whether the contents of the field can be returned in the search results.</p>
        pub fn return_enabled(mut self, input: bool) -> Self {
            self.return_enabled = Some(input);
            self
        }
        /// <p>Whether the contents of the field can be returned in the search results.</p>
        pub fn set_return_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.return_enabled = input;
            self
        }
        /// <p>Whether the field can be used to sort the search results.</p>
        pub fn sort_enabled(mut self, input: bool) -> Self {
            self.sort_enabled = Some(input);
            self
        }
        /// <p>Whether the field can be used to sort the search results.</p>
        pub fn set_sort_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.sort_enabled = input;
            self
        }
        /// Consumes the builder and constructs a [`LiteralOptions`](crate::model::LiteralOptions)
        pub fn build(self) -> crate::model::LiteralOptions {
            crate::model::LiteralOptions {
                default_value: self.default_value,
                source_field: self.source_field,
                facet_enabled: self.facet_enabled,
                search_enabled: self.search_enabled,
                return_enabled: self.return_enabled,
                sort_enabled: self.sort_enabled,
            }
        }
    }
}
impl LiteralOptions {
    /// Creates a new builder-style object to manufacture [`LiteralOptions`](crate::model::LiteralOptions)
    pub fn builder() -> crate::model::literal_options::Builder {
        crate::model::literal_options::Builder::default()
    }
}

/// <p>Options for a double-precision 64-bit floating point field.  Present if <code>IndexFieldType</code> specifies the field is of type <code>double</code>. All options are enabled by default.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DoubleOptions {
    /// <p>A value to use for the field if the field isn't specified for a document. This can be important if you are using the field in an expression and that field is not present in every document.</p>
    pub default_value: std::option::Option<f64>,
    /// <p>The name of the source field to map to the field. </p>
    pub source_field: std::option::Option<std::string::String>,
    /// <p>Whether facet information can be returned for the field.</p>
    pub facet_enabled: std::option::Option<bool>,
    /// <p>Whether the contents of the field are searchable.</p>
    pub search_enabled: std::option::Option<bool>,
    /// <p>Whether the contents of the field can be returned in the search results.</p>
    pub return_enabled: std::option::Option<bool>,
    /// <p>Whether the field can be used to sort the search results.</p>
    pub sort_enabled: std::option::Option<bool>,
}
impl DoubleOptions {
    /// <p>A value to use for the field if the field isn't specified for a document. This can be important if you are using the field in an expression and that field is not present in every document.</p>
    pub fn default_value(&self) -> std::option::Option<f64> {
        self.default_value
    }
    /// <p>The name of the source field to map to the field. </p>
    pub fn source_field(&self) -> std::option::Option<&str> {
        self.source_field.as_deref()
    }
    /// <p>Whether facet information can be returned for the field.</p>
    pub fn facet_enabled(&self) -> std::option::Option<bool> {
        self.facet_enabled
    }
    /// <p>Whether the contents of the field are searchable.</p>
    pub fn search_enabled(&self) -> std::option::Option<bool> {
        self.search_enabled
    }
    /// <p>Whether the contents of the field can be returned in the search results.</p>
    pub fn return_enabled(&self) -> std::option::Option<bool> {
        self.return_enabled
    }
    /// <p>Whether the field can be used to sort the search results.</p>
    pub fn sort_enabled(&self) -> std::option::Option<bool> {
        self.sort_enabled
    }
}
impl std::fmt::Debug for DoubleOptions {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DoubleOptions");
        formatter.field("default_value", &self.default_value);
        formatter.field("source_field", &self.source_field);
        formatter.field("facet_enabled", &self.facet_enabled);
        formatter.field("search_enabled", &self.search_enabled);
        formatter.field("return_enabled", &self.return_enabled);
        formatter.field("sort_enabled", &self.sort_enabled);
        formatter.finish()
    }
}
/// See [`DoubleOptions`](crate::model::DoubleOptions)
pub mod double_options {
    /// A builder for [`DoubleOptions`](crate::model::DoubleOptions)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) default_value: std::option::Option<f64>,
        pub(crate) source_field: std::option::Option<std::string::String>,
        pub(crate) facet_enabled: std::option::Option<bool>,
        pub(crate) search_enabled: std::option::Option<bool>,
        pub(crate) return_enabled: std::option::Option<bool>,
        pub(crate) sort_enabled: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>A value to use for the field if the field isn't specified for a document. This can be important if you are using the field in an expression and that field is not present in every document.</p>
        pub fn default_value(mut self, input: f64) -> Self {
            self.default_value = Some(input);
            self
        }
        /// <p>A value to use for the field if the field isn't specified for a document. This can be important if you are using the field in an expression and that field is not present in every document.</p>
        pub fn set_default_value(mut self, input: std::option::Option<f64>) -> Self {
            self.default_value = input;
            self
        }
        /// <p>The name of the source field to map to the field. </p>
        pub fn source_field(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_field = Some(input.into());
            self
        }
        /// <p>The name of the source field to map to the field. </p>
        pub fn set_source_field(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.source_field = input;
            self
        }
        /// <p>Whether facet information can be returned for the field.</p>
        pub fn facet_enabled(mut self, input: bool) -> Self {
            self.facet_enabled = Some(input);
            self
        }
        /// <p>Whether facet information can be returned for the field.</p>
        pub fn set_facet_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.facet_enabled = input;
            self
        }
        /// <p>Whether the contents of the field are searchable.</p>
        pub fn search_enabled(mut self, input: bool) -> Self {
            self.search_enabled = Some(input);
            self
        }
        /// <p>Whether the contents of the field are searchable.</p>
        pub fn set_search_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.search_enabled = input;
            self
        }
        /// <p>Whether the contents of the field can be returned in the search results.</p>
        pub fn return_enabled(mut self, input: bool) -> Self {
            self.return_enabled = Some(input);
            self
        }
        /// <p>Whether the contents of the field can be returned in the search results.</p>
        pub fn set_return_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.return_enabled = input;
            self
        }
        /// <p>Whether the field can be used to sort the search results.</p>
        pub fn sort_enabled(mut self, input: bool) -> Self {
            self.sort_enabled = Some(input);
            self
        }
        /// <p>Whether the field can be used to sort the search results.</p>
        pub fn set_sort_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.sort_enabled = input;
            self
        }
        /// Consumes the builder and constructs a [`DoubleOptions`](crate::model::DoubleOptions)
        pub fn build(self) -> crate::model::DoubleOptions {
            crate::model::DoubleOptions {
                default_value: self.default_value,
                source_field: self.source_field,
                facet_enabled: self.facet_enabled,
                search_enabled: self.search_enabled,
                return_enabled: self.return_enabled,
                sort_enabled: self.sort_enabled,
            }
        }
    }
}
impl DoubleOptions {
    /// Creates a new builder-style object to manufacture [`DoubleOptions`](crate::model::DoubleOptions)
    pub fn builder() -> crate::model::double_options::Builder {
        crate::model::double_options::Builder::default()
    }
}

/// <p>Options for a 64-bit signed integer field.  Present if <code>IndexFieldType</code> specifies the field is of type <code>int</code>. All options are enabled by default.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct IntOptions {
    /// A value to use for the field if the field isn't specified for a document. This can be important if you are using the field in an expression and that field is not present in every document.
    pub default_value: std::option::Option<i64>,
    /// <p>The name of the source field to map to the field. </p>
    pub source_field: std::option::Option<std::string::String>,
    /// <p>Whether facet information can be returned for the field.</p>
    pub facet_enabled: std::option::Option<bool>,
    /// <p>Whether the contents of the field are searchable.</p>
    pub search_enabled: std::option::Option<bool>,
    /// <p>Whether the contents of the field can be returned in the search results.</p>
    pub return_enabled: std::option::Option<bool>,
    /// <p>Whether the field can be used to sort the search results.</p>
    pub sort_enabled: std::option::Option<bool>,
}
impl IntOptions {
    /// A value to use for the field if the field isn't specified for a document. This can be important if you are using the field in an expression and that field is not present in every document.
    pub fn default_value(&self) -> std::option::Option<i64> {
        self.default_value
    }
    /// <p>The name of the source field to map to the field. </p>
    pub fn source_field(&self) -> std::option::Option<&str> {
        self.source_field.as_deref()
    }
    /// <p>Whether facet information can be returned for the field.</p>
    pub fn facet_enabled(&self) -> std::option::Option<bool> {
        self.facet_enabled
    }
    /// <p>Whether the contents of the field are searchable.</p>
    pub fn search_enabled(&self) -> std::option::Option<bool> {
        self.search_enabled
    }
    /// <p>Whether the contents of the field can be returned in the search results.</p>
    pub fn return_enabled(&self) -> std::option::Option<bool> {
        self.return_enabled
    }
    /// <p>Whether the field can be used to sort the search results.</p>
    pub fn sort_enabled(&self) -> std::option::Option<bool> {
        self.sort_enabled
    }
}
impl std::fmt::Debug for IntOptions {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("IntOptions");
        formatter.field("default_value", &self.default_value);
        formatter.field("source_field", &self.source_field);
        formatter.field("facet_enabled", &self.facet_enabled);
        formatter.field("search_enabled", &self.search_enabled);
        formatter.field("return_enabled", &self.return_enabled);
        formatter.field("sort_enabled", &self.sort_enabled);
        formatter.finish()
    }
}
/// See [`IntOptions`](crate::model::IntOptions)
pub mod int_options {
    /// A builder for [`IntOptions`](crate::model::IntOptions)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) default_value: std::option::Option<i64>,
        pub(crate) source_field: std::option::Option<std::string::String>,
        pub(crate) facet_enabled: std::option::Option<bool>,
        pub(crate) search_enabled: std::option::Option<bool>,
        pub(crate) return_enabled: std::option::Option<bool>,
        pub(crate) sort_enabled: std::option::Option<bool>,
    }
    impl Builder {
        /// A value to use for the field if the field isn't specified for a document. This can be important if you are using the field in an expression and that field is not present in every document.
        pub fn default_value(mut self, input: i64) -> Self {
            self.default_value = Some(input);
            self
        }
        /// A value to use for the field if the field isn't specified for a document. This can be important if you are using the field in an expression and that field is not present in every document.
        pub fn set_default_value(mut self, input: std::option::Option<i64>) -> Self {
            self.default_value = input;
            self
        }
        /// <p>The name of the source field to map to the field. </p>
        pub fn source_field(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_field = Some(input.into());
            self
        }
        /// <p>The name of the source field to map to the field. </p>
        pub fn set_source_field(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.source_field = input;
            self
        }
        /// <p>Whether facet information can be returned for the field.</p>
        pub fn facet_enabled(mut self, input: bool) -> Self {
            self.facet_enabled = Some(input);
            self
        }
        /// <p>Whether facet information can be returned for the field.</p>
        pub fn set_facet_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.facet_enabled = input;
            self
        }
        /// <p>Whether the contents of the field are searchable.</p>
        pub fn search_enabled(mut self, input: bool) -> Self {
            self.search_enabled = Some(input);
            self
        }
        /// <p>Whether the contents of the field are searchable.</p>
        pub fn set_search_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.search_enabled = input;
            self
        }
        /// <p>Whether the contents of the field can be returned in the search results.</p>
        pub fn return_enabled(mut self, input: bool) -> Self {
            self.return_enabled = Some(input);
            self
        }
        /// <p>Whether the contents of the field can be returned in the search results.</p>
        pub fn set_return_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.return_enabled = input;
            self
        }
        /// <p>Whether the field can be used to sort the search results.</p>
        pub fn sort_enabled(mut self, input: bool) -> Self {
            self.sort_enabled = Some(input);
            self
        }
        /// <p>Whether the field can be used to sort the search results.</p>
        pub fn set_sort_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.sort_enabled = input;
            self
        }
        /// Consumes the builder and constructs a [`IntOptions`](crate::model::IntOptions)
        pub fn build(self) -> crate::model::IntOptions {
            crate::model::IntOptions {
                default_value: self.default_value,
                source_field: self.source_field,
                facet_enabled: self.facet_enabled,
                search_enabled: self.search_enabled,
                return_enabled: self.return_enabled,
                sort_enabled: self.sort_enabled,
            }
        }
    }
}
impl IntOptions {
    /// Creates a new builder-style object to manufacture [`IntOptions`](crate::model::IntOptions)
    pub fn builder() -> crate::model::int_options::Builder {
        crate::model::int_options::Builder::default()
    }
}

/// <p>The type of field. The valid options for a field depend on the field type. For more information about the supported field types, see <a href="http://docs.aws.amazon.com/cloudsearch/latest/developerguide/configuring-index-fields.html" target="_blank">Configuring Index Fields</a> in the <i>Amazon CloudSearch Developer Guide</i>.</p>
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum IndexFieldType {
    #[allow(missing_docs)] // documentation missing in model
    Date,
    #[allow(missing_docs)] // documentation missing in model
    DateArray,
    #[allow(missing_docs)] // documentation missing in model
    Double,
    #[allow(missing_docs)] // documentation missing in model
    DoubleArray,
    #[allow(missing_docs)] // documentation missing in model
    Int,
    #[allow(missing_docs)] // documentation missing in model
    IntArray,
    #[allow(missing_docs)] // documentation missing in model
    Latlon,
    #[allow(missing_docs)] // documentation missing in model
    Literal,
    #[allow(missing_docs)] // documentation missing in model
    LiteralArray,
    #[allow(missing_docs)] // documentation missing in model
    Text,
    #[allow(missing_docs)] // documentation missing in model
    TextArray,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for IndexFieldType {
    fn from(s: &str) -> Self {
        match s {
            "date" => IndexFieldType::Date,
            "date-array" => IndexFieldType::DateArray,
            "double" => IndexFieldType::Double,
            "double-array" => IndexFieldType::DoubleArray,
            "int" => IndexFieldType::Int,
            "int-array" => IndexFieldType::IntArray,
            "latlon" => IndexFieldType::Latlon,
            "literal" => IndexFieldType::Literal,
            "literal-array" => IndexFieldType::LiteralArray,
            "text" => IndexFieldType::Text,
            "text-array" => IndexFieldType::TextArray,
            other => IndexFieldType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for IndexFieldType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(IndexFieldType::from(s))
    }
}
impl IndexFieldType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            IndexFieldType::Date => "date",
            IndexFieldType::DateArray => "date-array",
            IndexFieldType::Double => "double",
            IndexFieldType::DoubleArray => "double-array",
            IndexFieldType::Int => "int",
            IndexFieldType::IntArray => "int-array",
            IndexFieldType::Latlon => "latlon",
            IndexFieldType::Literal => "literal",
            IndexFieldType::LiteralArray => "literal-array",
            IndexFieldType::Text => "text",
            IndexFieldType::TextArray => "text-array",
            IndexFieldType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "date",
            "date-array",
            "double",
            "double-array",
            "int",
            "int-array",
            "latlon",
            "literal",
            "literal-array",
            "text",
            "text-array",
        ]
    }
}
impl AsRef<str> for IndexFieldType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The value of an <code>Expression</code> and its current status.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ExpressionStatus {
    /// <p>The expression that is evaluated for sorting while processing a search request.</p>
    pub options: std::option::Option<crate::model::Expression>,
    /// <p>The status of domain configuration option.</p>
    pub status: std::option::Option<crate::model::OptionStatus>,
}
impl ExpressionStatus {
    /// <p>The expression that is evaluated for sorting while processing a search request.</p>
    pub fn options(&self) -> std::option::Option<&crate::model::Expression> {
        self.options.as_ref()
    }
    /// <p>The status of domain configuration option.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::OptionStatus> {
        self.status.as_ref()
    }
}
impl std::fmt::Debug for ExpressionStatus {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ExpressionStatus");
        formatter.field("options", &self.options);
        formatter.field("status", &self.status);
        formatter.finish()
    }
}
/// See [`ExpressionStatus`](crate::model::ExpressionStatus)
pub mod expression_status {
    /// A builder for [`ExpressionStatus`](crate::model::ExpressionStatus)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) options: std::option::Option<crate::model::Expression>,
        pub(crate) status: std::option::Option<crate::model::OptionStatus>,
    }
    impl Builder {
        /// <p>The expression that is evaluated for sorting while processing a search request.</p>
        pub fn options(mut self, input: crate::model::Expression) -> Self {
            self.options = Some(input);
            self
        }
        /// <p>The expression that is evaluated for sorting while processing a search request.</p>
        pub fn set_options(mut self, input: std::option::Option<crate::model::Expression>) -> Self {
            self.options = input;
            self
        }
        /// <p>The status of domain configuration option.</p>
        pub fn status(mut self, input: crate::model::OptionStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of domain configuration option.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::OptionStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`ExpressionStatus`](crate::model::ExpressionStatus)
        pub fn build(self) -> crate::model::ExpressionStatus {
            crate::model::ExpressionStatus {
                options: self.options,
                status: self.status,
            }
        }
    }
}
impl ExpressionStatus {
    /// Creates a new builder-style object to manufacture [`ExpressionStatus`](crate::model::ExpressionStatus)
    pub fn builder() -> crate::model::expression_status::Builder {
        crate::model::expression_status::Builder::default()
    }
}

/// <p>A named expression that can be evaluated at search time. Can be used to sort the search results, define other expressions, or return computed information in the search results.  </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Expression {
    /// <p>Names must begin with a letter and can contain the following characters:
    /// a-z (lowercase), 0-9, and _ (underscore).</p>
    pub expression_name: std::option::Option<std::string::String>,
    /// <p>The expression to evaluate for sorting while processing a search request.  The <code>Expression</code> syntax is based on JavaScript expressions. For more information, see <a href="http://docs.aws.amazon.com/cloudsearch/latest/developerguide/configuring-expressions.html" target="_blank">Configuring Expressions</a> in the <i>Amazon CloudSearch Developer Guide</i>.</p>
    pub expression_value: std::option::Option<std::string::String>,
}
impl Expression {
    /// <p>Names must begin with a letter and can contain the following characters:
    /// a-z (lowercase), 0-9, and _ (underscore).</p>
    pub fn expression_name(&self) -> std::option::Option<&str> {
        self.expression_name.as_deref()
    }
    /// <p>The expression to evaluate for sorting while processing a search request.  The <code>Expression</code> syntax is based on JavaScript expressions. For more information, see <a href="http://docs.aws.amazon.com/cloudsearch/latest/developerguide/configuring-expressions.html" target="_blank">Configuring Expressions</a> in the <i>Amazon CloudSearch Developer Guide</i>.</p>
    pub fn expression_value(&self) -> std::option::Option<&str> {
        self.expression_value.as_deref()
    }
}
impl std::fmt::Debug for Expression {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Expression");
        formatter.field("expression_name", &self.expression_name);
        formatter.field("expression_value", &self.expression_value);
        formatter.finish()
    }
}
/// See [`Expression`](crate::model::Expression)
pub mod expression {
    /// A builder for [`Expression`](crate::model::Expression)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) expression_name: std::option::Option<std::string::String>,
        pub(crate) expression_value: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Names must begin with a letter and can contain the following characters:
        /// a-z (lowercase), 0-9, and _ (underscore).</p>
        pub fn expression_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.expression_name = Some(input.into());
            self
        }
        /// <p>Names must begin with a letter and can contain the following characters:
        /// a-z (lowercase), 0-9, and _ (underscore).</p>
        pub fn set_expression_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.expression_name = input;
            self
        }
        /// <p>The expression to evaluate for sorting while processing a search request.  The <code>Expression</code> syntax is based on JavaScript expressions. For more information, see <a href="http://docs.aws.amazon.com/cloudsearch/latest/developerguide/configuring-expressions.html" target="_blank">Configuring Expressions</a> in the <i>Amazon CloudSearch Developer Guide</i>.</p>
        pub fn expression_value(mut self, input: impl Into<std::string::String>) -> Self {
            self.expression_value = Some(input.into());
            self
        }
        /// <p>The expression to evaluate for sorting while processing a search request.  The <code>Expression</code> syntax is based on JavaScript expressions. For more information, see <a href="http://docs.aws.amazon.com/cloudsearch/latest/developerguide/configuring-expressions.html" target="_blank">Configuring Expressions</a> in the <i>Amazon CloudSearch Developer Guide</i>.</p>
        pub fn set_expression_value(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.expression_value = input;
            self
        }
        /// Consumes the builder and constructs a [`Expression`](crate::model::Expression)
        pub fn build(self) -> crate::model::Expression {
            crate::model::Expression {
                expression_name: self.expression_name,
                expression_value: self.expression_value,
            }
        }
    }
}
impl Expression {
    /// Creates a new builder-style object to manufacture [`Expression`](crate::model::Expression)
    pub fn builder() -> crate::model::expression::Builder {
        crate::model::expression::Builder::default()
    }
}

/// <p>The current status of the search domain.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DomainStatus {
    /// <p>An internally generated unique identifier for a domain.</p>
    pub domain_id: std::option::Option<std::string::String>,
    /// <p>A string that represents the name of a domain. Domain names are unique across the domains owned by an account within an AWS region. Domain names start with a letter or number and can contain the following characters: a-z (lowercase), 0-9, and - (hyphen).</p>
    pub domain_name: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the search domain.  See <a href="http://docs.aws.amazon.com/IAM/latest/UserGuide/index.html?Using_Identifiers.html" target="_blank">Identifiers for IAM Entities</a> in <i>Using AWS Identity and Access Management</i> for more information.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>True if the search domain is created. It can take several minutes to initialize a domain when <a>CreateDomain</a> is called. Newly created search domains are returned from <a>DescribeDomains</a> with a false value for Created until domain creation is complete.</p>
    pub created: std::option::Option<bool>,
    /// <p>True if the search domain has been deleted.  The system must clean up resources dedicated to the search domain when <a>DeleteDomain</a> is called.  Newly deleted search domains are returned from <a>DescribeDomains</a> with a true value for IsDeleted for several minutes until resource cleanup is complete.</p>
    pub deleted: std::option::Option<bool>,
    /// <p>The service endpoint for updating documents in a search domain.</p>
    pub doc_service: std::option::Option<crate::model::ServiceEndpoint>,
    /// <p>The service endpoint for requesting search results from a search domain.</p>
    pub search_service: std::option::Option<crate::model::ServiceEndpoint>,
    /// <p>True if <a>IndexDocuments</a> needs to be called to activate the current domain configuration.</p>
    pub requires_index_documents: std::option::Option<bool>,
    /// <p>True if processing is being done to activate the current domain configuration.</p>
    pub processing: std::option::Option<bool>,
    /// <p>The instance type that is being used to process search requests.</p>
    pub search_instance_type: std::option::Option<std::string::String>,
    /// <p>The number of partitions across which the search index is spread.</p>
    pub search_partition_count: i32,
    /// <p>The number of search instances that are available to process search requests.</p>
    pub search_instance_count: i32,
    #[allow(missing_docs)] // documentation missing in model
    pub limits: std::option::Option<crate::model::Limits>,
}
impl DomainStatus {
    /// <p>An internally generated unique identifier for a domain.</p>
    pub fn domain_id(&self) -> std::option::Option<&str> {
        self.domain_id.as_deref()
    }
    /// <p>A string that represents the name of a domain. Domain names are unique across the domains owned by an account within an AWS region. Domain names start with a letter or number and can contain the following characters: a-z (lowercase), 0-9, and - (hyphen).</p>
    pub fn domain_name(&self) -> std::option::Option<&str> {
        self.domain_name.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the search domain.  See <a href="http://docs.aws.amazon.com/IAM/latest/UserGuide/index.html?Using_Identifiers.html" target="_blank">Identifiers for IAM Entities</a> in <i>Using AWS Identity and Access Management</i> for more information.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>True if the search domain is created. It can take several minutes to initialize a domain when <a>CreateDomain</a> is called. Newly created search domains are returned from <a>DescribeDomains</a> with a false value for Created until domain creation is complete.</p>
    pub fn created(&self) -> std::option::Option<bool> {
        self.created
    }
    /// <p>True if the search domain has been deleted.  The system must clean up resources dedicated to the search domain when <a>DeleteDomain</a> is called.  Newly deleted search domains are returned from <a>DescribeDomains</a> with a true value for IsDeleted for several minutes until resource cleanup is complete.</p>
    pub fn deleted(&self) -> std::option::Option<bool> {
        self.deleted
    }
    /// <p>The service endpoint for updating documents in a search domain.</p>
    pub fn doc_service(&self) -> std::option::Option<&crate::model::ServiceEndpoint> {
        self.doc_service.as_ref()
    }
    /// <p>The service endpoint for requesting search results from a search domain.</p>
    pub fn search_service(&self) -> std::option::Option<&crate::model::ServiceEndpoint> {
        self.search_service.as_ref()
    }
    /// <p>True if <a>IndexDocuments</a> needs to be called to activate the current domain configuration.</p>
    pub fn requires_index_documents(&self) -> std::option::Option<bool> {
        self.requires_index_documents
    }
    /// <p>True if processing is being done to activate the current domain configuration.</p>
    pub fn processing(&self) -> std::option::Option<bool> {
        self.processing
    }
    /// <p>The instance type that is being used to process search requests.</p>
    pub fn search_instance_type(&self) -> std::option::Option<&str> {
        self.search_instance_type.as_deref()
    }
    /// <p>The number of partitions across which the search index is spread.</p>
    pub fn search_partition_count(&self) -> i32 {
        self.search_partition_count
    }
    /// <p>The number of search instances that are available to process search requests.</p>
    pub fn search_instance_count(&self) -> i32 {
        self.search_instance_count
    }
    #[allow(missing_docs)] // documentation missing in model
    pub fn limits(&self) -> std::option::Option<&crate::model::Limits> {
        self.limits.as_ref()
    }
}
impl std::fmt::Debug for DomainStatus {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DomainStatus");
        formatter.field("domain_id", &self.domain_id);
        formatter.field("domain_name", &self.domain_name);
        formatter.field("arn", &self.arn);
        formatter.field("created", &self.created);
        formatter.field("deleted", &self.deleted);
        formatter.field("doc_service", &self.doc_service);
        formatter.field("search_service", &self.search_service);
        formatter.field("requires_index_documents", &self.requires_index_documents);
        formatter.field("processing", &self.processing);
        formatter.field("search_instance_type", &self.search_instance_type);
        formatter.field("search_partition_count", &self.search_partition_count);
        formatter.field("search_instance_count", &self.search_instance_count);
        formatter.field("limits", &self.limits);
        formatter.finish()
    }
}
/// See [`DomainStatus`](crate::model::DomainStatus)
pub mod domain_status {
    /// A builder for [`DomainStatus`](crate::model::DomainStatus)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) domain_id: std::option::Option<std::string::String>,
        pub(crate) domain_name: std::option::Option<std::string::String>,
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) created: std::option::Option<bool>,
        pub(crate) deleted: std::option::Option<bool>,
        pub(crate) doc_service: std::option::Option<crate::model::ServiceEndpoint>,
        pub(crate) search_service: std::option::Option<crate::model::ServiceEndpoint>,
        pub(crate) requires_index_documents: std::option::Option<bool>,
        pub(crate) processing: std::option::Option<bool>,
        pub(crate) search_instance_type: std::option::Option<std::string::String>,
        pub(crate) search_partition_count: std::option::Option<i32>,
        pub(crate) search_instance_count: std::option::Option<i32>,
        pub(crate) limits: std::option::Option<crate::model::Limits>,
    }
    impl Builder {
        /// <p>An internally generated unique identifier for a domain.</p>
        pub fn domain_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain_id = Some(input.into());
            self
        }
        /// <p>An internally generated unique identifier for a domain.</p>
        pub fn set_domain_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain_id = input;
            self
        }
        /// <p>A string that represents the name of a domain. Domain names are unique across the domains owned by an account within an AWS region. Domain names start with a letter or number and can contain the following characters: a-z (lowercase), 0-9, and - (hyphen).</p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain_name = Some(input.into());
            self
        }
        /// <p>A string that represents the name of a domain. Domain names are unique across the domains owned by an account within an AWS region. Domain names start with a letter or number and can contain the following characters: a-z (lowercase), 0-9, and - (hyphen).</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain_name = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the search domain.  See <a href="http://docs.aws.amazon.com/IAM/latest/UserGuide/index.html?Using_Identifiers.html" target="_blank">Identifiers for IAM Entities</a> in <i>Using AWS Identity and Access Management</i> for more information.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the search domain.  See <a href="http://docs.aws.amazon.com/IAM/latest/UserGuide/index.html?Using_Identifiers.html" target="_blank">Identifiers for IAM Entities</a> in <i>Using AWS Identity and Access Management</i> for more information.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>True if the search domain is created. It can take several minutes to initialize a domain when <a>CreateDomain</a> is called. Newly created search domains are returned from <a>DescribeDomains</a> with a false value for Created until domain creation is complete.</p>
        pub fn created(mut self, input: bool) -> Self {
            self.created = Some(input);
            self
        }
        /// <p>True if the search domain is created. It can take several minutes to initialize a domain when <a>CreateDomain</a> is called. Newly created search domains are returned from <a>DescribeDomains</a> with a false value for Created until domain creation is complete.</p>
        pub fn set_created(mut self, input: std::option::Option<bool>) -> Self {
            self.created = input;
            self
        }
        /// <p>True if the search domain has been deleted.  The system must clean up resources dedicated to the search domain when <a>DeleteDomain</a> is called.  Newly deleted search domains are returned from <a>DescribeDomains</a> with a true value for IsDeleted for several minutes until resource cleanup is complete.</p>
        pub fn deleted(mut self, input: bool) -> Self {
            self.deleted = Some(input);
            self
        }
        /// <p>True if the search domain has been deleted.  The system must clean up resources dedicated to the search domain when <a>DeleteDomain</a> is called.  Newly deleted search domains are returned from <a>DescribeDomains</a> with a true value for IsDeleted for several minutes until resource cleanup is complete.</p>
        pub fn set_deleted(mut self, input: std::option::Option<bool>) -> Self {
            self.deleted = input;
            self
        }
        /// <p>The service endpoint for updating documents in a search domain.</p>
        pub fn doc_service(mut self, input: crate::model::ServiceEndpoint) -> Self {
            self.doc_service = Some(input);
            self
        }
        /// <p>The service endpoint for updating documents in a search domain.</p>
        pub fn set_doc_service(
            mut self,
            input: std::option::Option<crate::model::ServiceEndpoint>,
        ) -> Self {
            self.doc_service = input;
            self
        }
        /// <p>The service endpoint for requesting search results from a search domain.</p>
        pub fn search_service(mut self, input: crate::model::ServiceEndpoint) -> Self {
            self.search_service = Some(input);
            self
        }
        /// <p>The service endpoint for requesting search results from a search domain.</p>
        pub fn set_search_service(
            mut self,
            input: std::option::Option<crate::model::ServiceEndpoint>,
        ) -> Self {
            self.search_service = input;
            self
        }
        /// <p>True if <a>IndexDocuments</a> needs to be called to activate the current domain configuration.</p>
        pub fn requires_index_documents(mut self, input: bool) -> Self {
            self.requires_index_documents = Some(input);
            self
        }
        /// <p>True if <a>IndexDocuments</a> needs to be called to activate the current domain configuration.</p>
        pub fn set_requires_index_documents(mut self, input: std::option::Option<bool>) -> Self {
            self.requires_index_documents = input;
            self
        }
        /// <p>True if processing is being done to activate the current domain configuration.</p>
        pub fn processing(mut self, input: bool) -> Self {
            self.processing = Some(input);
            self
        }
        /// <p>True if processing is being done to activate the current domain configuration.</p>
        pub fn set_processing(mut self, input: std::option::Option<bool>) -> Self {
            self.processing = input;
            self
        }
        /// <p>The instance type that is being used to process search requests.</p>
        pub fn search_instance_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.search_instance_type = Some(input.into());
            self
        }
        /// <p>The instance type that is being used to process search requests.</p>
        pub fn set_search_instance_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.search_instance_type = input;
            self
        }
        /// <p>The number of partitions across which the search index is spread.</p>
        pub fn search_partition_count(mut self, input: i32) -> Self {
            self.search_partition_count = Some(input);
            self
        }
        /// <p>The number of partitions across which the search index is spread.</p>
        pub fn set_search_partition_count(mut self, input: std::option::Option<i32>) -> Self {
            self.search_partition_count = input;
            self
        }
        /// <p>The number of search instances that are available to process search requests.</p>
        pub fn search_instance_count(mut self, input: i32) -> Self {
            self.search_instance_count = Some(input);
            self
        }
        /// <p>The number of search instances that are available to process search requests.</p>
        pub fn set_search_instance_count(mut self, input: std::option::Option<i32>) -> Self {
            self.search_instance_count = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn limits(mut self, input: crate::model::Limits) -> Self {
            self.limits = Some(input);
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_limits(mut self, input: std::option::Option<crate::model::Limits>) -> Self {
            self.limits = input;
            self
        }
        /// Consumes the builder and constructs a [`DomainStatus`](crate::model::DomainStatus)
        pub fn build(self) -> crate::model::DomainStatus {
            crate::model::DomainStatus {
                domain_id: self.domain_id,
                domain_name: self.domain_name,
                arn: self.arn,
                created: self.created,
                deleted: self.deleted,
                doc_service: self.doc_service,
                search_service: self.search_service,
                requires_index_documents: self.requires_index_documents,
                processing: self.processing,
                search_instance_type: self.search_instance_type,
                search_partition_count: self.search_partition_count.unwrap_or_default(),
                search_instance_count: self.search_instance_count.unwrap_or_default(),
                limits: self.limits,
            }
        }
    }
}
impl DomainStatus {
    /// Creates a new builder-style object to manufacture [`DomainStatus`](crate::model::DomainStatus)
    pub fn builder() -> crate::model::domain_status::Builder {
        crate::model::domain_status::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Limits {
    #[allow(missing_docs)] // documentation missing in model
    pub maximum_replication_count: i32,
    #[allow(missing_docs)] // documentation missing in model
    pub maximum_partition_count: i32,
}
impl Limits {
    #[allow(missing_docs)] // documentation missing in model
    pub fn maximum_replication_count(&self) -> i32 {
        self.maximum_replication_count
    }
    #[allow(missing_docs)] // documentation missing in model
    pub fn maximum_partition_count(&self) -> i32 {
        self.maximum_partition_count
    }
}
impl std::fmt::Debug for Limits {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Limits");
        formatter.field("maximum_replication_count", &self.maximum_replication_count);
        formatter.field("maximum_partition_count", &self.maximum_partition_count);
        formatter.finish()
    }
}
/// See [`Limits`](crate::model::Limits)
pub mod limits {
    /// A builder for [`Limits`](crate::model::Limits)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) maximum_replication_count: std::option::Option<i32>,
        pub(crate) maximum_partition_count: std::option::Option<i32>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn maximum_replication_count(mut self, input: i32) -> Self {
            self.maximum_replication_count = Some(input);
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_maximum_replication_count(mut self, input: std::option::Option<i32>) -> Self {
            self.maximum_replication_count = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn maximum_partition_count(mut self, input: i32) -> Self {
            self.maximum_partition_count = Some(input);
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_maximum_partition_count(mut self, input: std::option::Option<i32>) -> Self {
            self.maximum_partition_count = input;
            self
        }
        /// Consumes the builder and constructs a [`Limits`](crate::model::Limits)
        pub fn build(self) -> crate::model::Limits {
            crate::model::Limits {
                maximum_replication_count: self.maximum_replication_count.unwrap_or_default(),
                maximum_partition_count: self.maximum_partition_count.unwrap_or_default(),
            }
        }
    }
}
impl Limits {
    /// Creates a new builder-style object to manufacture [`Limits`](crate::model::Limits)
    pub fn builder() -> crate::model::limits::Builder {
        crate::model::limits::Builder::default()
    }
}

/// <p>The endpoint to which service requests can be submitted.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ServiceEndpoint {
    /// <p>The endpoint to which service requests can be submitted. For example, <code>search-imdb-movies-oopcnjfn6ugofer3zx5iadxxca.eu-west-1.cloudsearch.amazonaws.com</code> or <code>doc-imdb-movies-oopcnjfn6ugofer3zx5iadxxca.eu-west-1.cloudsearch.amazonaws.com</code>.</p>
    pub endpoint: std::option::Option<std::string::String>,
}
impl ServiceEndpoint {
    /// <p>The endpoint to which service requests can be submitted. For example, <code>search-imdb-movies-oopcnjfn6ugofer3zx5iadxxca.eu-west-1.cloudsearch.amazonaws.com</code> or <code>doc-imdb-movies-oopcnjfn6ugofer3zx5iadxxca.eu-west-1.cloudsearch.amazonaws.com</code>.</p>
    pub fn endpoint(&self) -> std::option::Option<&str> {
        self.endpoint.as_deref()
    }
}
impl std::fmt::Debug for ServiceEndpoint {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ServiceEndpoint");
        formatter.field("endpoint", &self.endpoint);
        formatter.finish()
    }
}
/// See [`ServiceEndpoint`](crate::model::ServiceEndpoint)
pub mod service_endpoint {
    /// A builder for [`ServiceEndpoint`](crate::model::ServiceEndpoint)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) endpoint: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The endpoint to which service requests can be submitted. For example, <code>search-imdb-movies-oopcnjfn6ugofer3zx5iadxxca.eu-west-1.cloudsearch.amazonaws.com</code> or <code>doc-imdb-movies-oopcnjfn6ugofer3zx5iadxxca.eu-west-1.cloudsearch.amazonaws.com</code>.</p>
        pub fn endpoint(mut self, input: impl Into<std::string::String>) -> Self {
            self.endpoint = Some(input.into());
            self
        }
        /// <p>The endpoint to which service requests can be submitted. For example, <code>search-imdb-movies-oopcnjfn6ugofer3zx5iadxxca.eu-west-1.cloudsearch.amazonaws.com</code> or <code>doc-imdb-movies-oopcnjfn6ugofer3zx5iadxxca.eu-west-1.cloudsearch.amazonaws.com</code>.</p>
        pub fn set_endpoint(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.endpoint = input;
            self
        }
        /// Consumes the builder and constructs a [`ServiceEndpoint`](crate::model::ServiceEndpoint)
        pub fn build(self) -> crate::model::ServiceEndpoint {
            crate::model::ServiceEndpoint {
                endpoint: self.endpoint,
            }
        }
    }
}
impl ServiceEndpoint {
    /// Creates a new builder-style object to manufacture [`ServiceEndpoint`](crate::model::ServiceEndpoint)
    pub fn builder() -> crate::model::service_endpoint::Builder {
        crate::model::service_endpoint::Builder::default()
    }
}

/// <p>The status and configuration of an  <code>AnalysisScheme</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AnalysisSchemeStatus {
    /// <p>Configuration information for an analysis scheme. Each analysis scheme has a unique name and specifies the language of the text to be processed. The following options can be configured for an analysis scheme: <code>Synonyms</code>, <code>Stopwords</code>, <code>StemmingDictionary</code>, <code>JapaneseTokenizationDictionary</code> and <code>AlgorithmicStemming</code>.</p>
    pub options: std::option::Option<crate::model::AnalysisScheme>,
    /// <p>The status of domain configuration option.</p>
    pub status: std::option::Option<crate::model::OptionStatus>,
}
impl AnalysisSchemeStatus {
    /// <p>Configuration information for an analysis scheme. Each analysis scheme has a unique name and specifies the language of the text to be processed. The following options can be configured for an analysis scheme: <code>Synonyms</code>, <code>Stopwords</code>, <code>StemmingDictionary</code>, <code>JapaneseTokenizationDictionary</code> and <code>AlgorithmicStemming</code>.</p>
    pub fn options(&self) -> std::option::Option<&crate::model::AnalysisScheme> {
        self.options.as_ref()
    }
    /// <p>The status of domain configuration option.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::OptionStatus> {
        self.status.as_ref()
    }
}
impl std::fmt::Debug for AnalysisSchemeStatus {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AnalysisSchemeStatus");
        formatter.field("options", &self.options);
        formatter.field("status", &self.status);
        formatter.finish()
    }
}
/// See [`AnalysisSchemeStatus`](crate::model::AnalysisSchemeStatus)
pub mod analysis_scheme_status {
    /// A builder for [`AnalysisSchemeStatus`](crate::model::AnalysisSchemeStatus)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) options: std::option::Option<crate::model::AnalysisScheme>,
        pub(crate) status: std::option::Option<crate::model::OptionStatus>,
    }
    impl Builder {
        /// <p>Configuration information for an analysis scheme. Each analysis scheme has a unique name and specifies the language of the text to be processed. The following options can be configured for an analysis scheme: <code>Synonyms</code>, <code>Stopwords</code>, <code>StemmingDictionary</code>, <code>JapaneseTokenizationDictionary</code> and <code>AlgorithmicStemming</code>.</p>
        pub fn options(mut self, input: crate::model::AnalysisScheme) -> Self {
            self.options = Some(input);
            self
        }
        /// <p>Configuration information for an analysis scheme. Each analysis scheme has a unique name and specifies the language of the text to be processed. The following options can be configured for an analysis scheme: <code>Synonyms</code>, <code>Stopwords</code>, <code>StemmingDictionary</code>, <code>JapaneseTokenizationDictionary</code> and <code>AlgorithmicStemming</code>.</p>
        pub fn set_options(
            mut self,
            input: std::option::Option<crate::model::AnalysisScheme>,
        ) -> Self {
            self.options = input;
            self
        }
        /// <p>The status of domain configuration option.</p>
        pub fn status(mut self, input: crate::model::OptionStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of domain configuration option.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::OptionStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`AnalysisSchemeStatus`](crate::model::AnalysisSchemeStatus)
        pub fn build(self) -> crate::model::AnalysisSchemeStatus {
            crate::model::AnalysisSchemeStatus {
                options: self.options,
                status: self.status,
            }
        }
    }
}
impl AnalysisSchemeStatus {
    /// Creates a new builder-style object to manufacture [`AnalysisSchemeStatus`](crate::model::AnalysisSchemeStatus)
    pub fn builder() -> crate::model::analysis_scheme_status::Builder {
        crate::model::analysis_scheme_status::Builder::default()
    }
}

/// <p>Configuration information for an analysis scheme. Each analysis scheme has a unique name and specifies the language of the text to be processed. The following options can be configured for an analysis scheme: <code>Synonyms</code>, <code>Stopwords</code>, <code>StemmingDictionary</code>, <code>JapaneseTokenizationDictionary</code> and <code>AlgorithmicStemming</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AnalysisScheme {
    /// <p>Names must begin with a letter and can contain the following characters:
    /// a-z (lowercase), 0-9, and _ (underscore).</p>
    pub analysis_scheme_name: std::option::Option<std::string::String>,
    /// <p>An <a href="http://tools.ietf.org/html/rfc4646" target="_blank">IETF RFC 4646</a> language code or <code>mul</code>  for multiple languages.</p>
    pub analysis_scheme_language: std::option::Option<crate::model::AnalysisSchemeLanguage>,
    /// <p>Synonyms, stopwords, and stemming options for an analysis scheme. Includes tokenization dictionary for Japanese.</p>
    pub analysis_options: std::option::Option<crate::model::AnalysisOptions>,
}
impl AnalysisScheme {
    /// <p>Names must begin with a letter and can contain the following characters:
    /// a-z (lowercase), 0-9, and _ (underscore).</p>
    pub fn analysis_scheme_name(&self) -> std::option::Option<&str> {
        self.analysis_scheme_name.as_deref()
    }
    /// <p>An <a href="http://tools.ietf.org/html/rfc4646" target="_blank">IETF RFC 4646</a> language code or <code>mul</code>  for multiple languages.</p>
    pub fn analysis_scheme_language(
        &self,
    ) -> std::option::Option<&crate::model::AnalysisSchemeLanguage> {
        self.analysis_scheme_language.as_ref()
    }
    /// <p>Synonyms, stopwords, and stemming options for an analysis scheme. Includes tokenization dictionary for Japanese.</p>
    pub fn analysis_options(&self) -> std::option::Option<&crate::model::AnalysisOptions> {
        self.analysis_options.as_ref()
    }
}
impl std::fmt::Debug for AnalysisScheme {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AnalysisScheme");
        formatter.field("analysis_scheme_name", &self.analysis_scheme_name);
        formatter.field("analysis_scheme_language", &self.analysis_scheme_language);
        formatter.field("analysis_options", &self.analysis_options);
        formatter.finish()
    }
}
/// See [`AnalysisScheme`](crate::model::AnalysisScheme)
pub mod analysis_scheme {
    /// A builder for [`AnalysisScheme`](crate::model::AnalysisScheme)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) analysis_scheme_name: std::option::Option<std::string::String>,
        pub(crate) analysis_scheme_language:
            std::option::Option<crate::model::AnalysisSchemeLanguage>,
        pub(crate) analysis_options: std::option::Option<crate::model::AnalysisOptions>,
    }
    impl Builder {
        /// <p>Names must begin with a letter and can contain the following characters:
        /// a-z (lowercase), 0-9, and _ (underscore).</p>
        pub fn analysis_scheme_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.analysis_scheme_name = Some(input.into());
            self
        }
        /// <p>Names must begin with a letter and can contain the following characters:
        /// a-z (lowercase), 0-9, and _ (underscore).</p>
        pub fn set_analysis_scheme_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.analysis_scheme_name = input;
            self
        }
        /// <p>An <a href="http://tools.ietf.org/html/rfc4646" target="_blank">IETF RFC 4646</a> language code or <code>mul</code>  for multiple languages.</p>
        pub fn analysis_scheme_language(
            mut self,
            input: crate::model::AnalysisSchemeLanguage,
        ) -> Self {
            self.analysis_scheme_language = Some(input);
            self
        }
        /// <p>An <a href="http://tools.ietf.org/html/rfc4646" target="_blank">IETF RFC 4646</a> language code or <code>mul</code>  for multiple languages.</p>
        pub fn set_analysis_scheme_language(
            mut self,
            input: std::option::Option<crate::model::AnalysisSchemeLanguage>,
        ) -> Self {
            self.analysis_scheme_language = input;
            self
        }
        /// <p>Synonyms, stopwords, and stemming options for an analysis scheme. Includes tokenization dictionary for Japanese.</p>
        pub fn analysis_options(mut self, input: crate::model::AnalysisOptions) -> Self {
            self.analysis_options = Some(input);
            self
        }
        /// <p>Synonyms, stopwords, and stemming options for an analysis scheme. Includes tokenization dictionary for Japanese.</p>
        pub fn set_analysis_options(
            mut self,
            input: std::option::Option<crate::model::AnalysisOptions>,
        ) -> Self {
            self.analysis_options = input;
            self
        }
        /// Consumes the builder and constructs a [`AnalysisScheme`](crate::model::AnalysisScheme)
        pub fn build(self) -> crate::model::AnalysisScheme {
            crate::model::AnalysisScheme {
                analysis_scheme_name: self.analysis_scheme_name,
                analysis_scheme_language: self.analysis_scheme_language,
                analysis_options: self.analysis_options,
            }
        }
    }
}
impl AnalysisScheme {
    /// Creates a new builder-style object to manufacture [`AnalysisScheme`](crate::model::AnalysisScheme)
    pub fn builder() -> crate::model::analysis_scheme::Builder {
        crate::model::analysis_scheme::Builder::default()
    }
}

/// <p>Synonyms, stopwords, and stemming options for an analysis scheme. Includes tokenization dictionary for Japanese.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AnalysisOptions {
    /// <p>A JSON object that defines synonym groups and aliases. A synonym group is an array of arrays, where each sub-array is a group of terms where each term in the group is considered a synonym of every other term in the group. The aliases value is an object that contains a collection of string:value pairs where the string specifies a term and the array of values specifies each of the aliases for that term. An alias is considered a synonym of the specified term, but the term is not considered a synonym of the alias. For more information about specifying synonyms, see <a href="http://docs.aws.amazon.com/cloudsearch/latest/developerguide/configuring-analysis-schemes.html#synonyms">Synonyms</a> in the <i>Amazon CloudSearch Developer Guide</i>.</p>
    pub synonyms: std::option::Option<std::string::String>,
    /// <p>A  JSON array of terms to ignore during indexing and searching. For example, <code>["a", "an", "the", "of"]</code>. The stopwords dictionary must explicitly list each word you want to ignore. Wildcards and regular expressions are not supported. </p>
    pub stopwords: std::option::Option<std::string::String>,
    /// <p>A JSON object that contains a collection of string:value pairs that each map a term to its stem. For example, <code>{"term1": "stem1", "term2": "stem2", "term3": "stem3"}</code>. The stemming dictionary is applied in addition to any algorithmic stemming. This enables you to override the results of the algorithmic stemming to correct specific cases of overstemming or understemming. The maximum size of a stemming dictionary is 500 KB.</p>
    pub stemming_dictionary: std::option::Option<std::string::String>,
    /// <p>A JSON array that contains a collection of terms, tokens, readings and part of speech for Japanese Tokenizaiton. The Japanese tokenization dictionary enables you to override the default tokenization for selected terms. This is only valid for Japanese language fields.</p>
    pub japanese_tokenization_dictionary: std::option::Option<std::string::String>,
    /// <p>The level of algorithmic stemming to perform: <code>none</code>, <code>minimal</code>, <code>light</code>, or <code>full</code>. The available levels vary depending on the language. For more information, see <a href="http://docs.aws.amazon.com/cloudsearch/latest/developerguide/text-processing.html#text-processing-settings" target="_blank">Language Specific Text Processing Settings</a> in the <i>Amazon CloudSearch Developer Guide</i> </p>
    pub algorithmic_stemming: std::option::Option<crate::model::AlgorithmicStemming>,
}
impl AnalysisOptions {
    /// <p>A JSON object that defines synonym groups and aliases. A synonym group is an array of arrays, where each sub-array is a group of terms where each term in the group is considered a synonym of every other term in the group. The aliases value is an object that contains a collection of string:value pairs where the string specifies a term and the array of values specifies each of the aliases for that term. An alias is considered a synonym of the specified term, but the term is not considered a synonym of the alias. For more information about specifying synonyms, see <a href="http://docs.aws.amazon.com/cloudsearch/latest/developerguide/configuring-analysis-schemes.html#synonyms">Synonyms</a> in the <i>Amazon CloudSearch Developer Guide</i>.</p>
    pub fn synonyms(&self) -> std::option::Option<&str> {
        self.synonyms.as_deref()
    }
    /// <p>A  JSON array of terms to ignore during indexing and searching. For example, <code>["a", "an", "the", "of"]</code>. The stopwords dictionary must explicitly list each word you want to ignore. Wildcards and regular expressions are not supported. </p>
    pub fn stopwords(&self) -> std::option::Option<&str> {
        self.stopwords.as_deref()
    }
    /// <p>A JSON object that contains a collection of string:value pairs that each map a term to its stem. For example, <code>{"term1": "stem1", "term2": "stem2", "term3": "stem3"}</code>. The stemming dictionary is applied in addition to any algorithmic stemming. This enables you to override the results of the algorithmic stemming to correct specific cases of overstemming or understemming. The maximum size of a stemming dictionary is 500 KB.</p>
    pub fn stemming_dictionary(&self) -> std::option::Option<&str> {
        self.stemming_dictionary.as_deref()
    }
    /// <p>A JSON array that contains a collection of terms, tokens, readings and part of speech for Japanese Tokenizaiton. The Japanese tokenization dictionary enables you to override the default tokenization for selected terms. This is only valid for Japanese language fields.</p>
    pub fn japanese_tokenization_dictionary(&self) -> std::option::Option<&str> {
        self.japanese_tokenization_dictionary.as_deref()
    }
    /// <p>The level of algorithmic stemming to perform: <code>none</code>, <code>minimal</code>, <code>light</code>, or <code>full</code>. The available levels vary depending on the language. For more information, see <a href="http://docs.aws.amazon.com/cloudsearch/latest/developerguide/text-processing.html#text-processing-settings" target="_blank">Language Specific Text Processing Settings</a> in the <i>Amazon CloudSearch Developer Guide</i> </p>
    pub fn algorithmic_stemming(&self) -> std::option::Option<&crate::model::AlgorithmicStemming> {
        self.algorithmic_stemming.as_ref()
    }
}
impl std::fmt::Debug for AnalysisOptions {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AnalysisOptions");
        formatter.field("synonyms", &self.synonyms);
        formatter.field("stopwords", &self.stopwords);
        formatter.field("stemming_dictionary", &self.stemming_dictionary);
        formatter.field(
            "japanese_tokenization_dictionary",
            &self.japanese_tokenization_dictionary,
        );
        formatter.field("algorithmic_stemming", &self.algorithmic_stemming);
        formatter.finish()
    }
}
/// See [`AnalysisOptions`](crate::model::AnalysisOptions)
pub mod analysis_options {
    /// A builder for [`AnalysisOptions`](crate::model::AnalysisOptions)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) synonyms: std::option::Option<std::string::String>,
        pub(crate) stopwords: std::option::Option<std::string::String>,
        pub(crate) stemming_dictionary: std::option::Option<std::string::String>,
        pub(crate) japanese_tokenization_dictionary: std::option::Option<std::string::String>,
        pub(crate) algorithmic_stemming: std::option::Option<crate::model::AlgorithmicStemming>,
    }
    impl Builder {
        /// <p>A JSON object that defines synonym groups and aliases. A synonym group is an array of arrays, where each sub-array is a group of terms where each term in the group is considered a synonym of every other term in the group. The aliases value is an object that contains a collection of string:value pairs where the string specifies a term and the array of values specifies each of the aliases for that term. An alias is considered a synonym of the specified term, but the term is not considered a synonym of the alias. For more information about specifying synonyms, see <a href="http://docs.aws.amazon.com/cloudsearch/latest/developerguide/configuring-analysis-schemes.html#synonyms">Synonyms</a> in the <i>Amazon CloudSearch Developer Guide</i>.</p>
        pub fn synonyms(mut self, input: impl Into<std::string::String>) -> Self {
            self.synonyms = Some(input.into());
            self
        }
        /// <p>A JSON object that defines synonym groups and aliases. A synonym group is an array of arrays, where each sub-array is a group of terms where each term in the group is considered a synonym of every other term in the group. The aliases value is an object that contains a collection of string:value pairs where the string specifies a term and the array of values specifies each of the aliases for that term. An alias is considered a synonym of the specified term, but the term is not considered a synonym of the alias. For more information about specifying synonyms, see <a href="http://docs.aws.amazon.com/cloudsearch/latest/developerguide/configuring-analysis-schemes.html#synonyms">Synonyms</a> in the <i>Amazon CloudSearch Developer Guide</i>.</p>
        pub fn set_synonyms(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.synonyms = input;
            self
        }
        /// <p>A  JSON array of terms to ignore during indexing and searching. For example, <code>["a", "an", "the", "of"]</code>. The stopwords dictionary must explicitly list each word you want to ignore. Wildcards and regular expressions are not supported. </p>
        pub fn stopwords(mut self, input: impl Into<std::string::String>) -> Self {
            self.stopwords = Some(input.into());
            self
        }
        /// <p>A  JSON array of terms to ignore during indexing and searching. For example, <code>["a", "an", "the", "of"]</code>. The stopwords dictionary must explicitly list each word you want to ignore. Wildcards and regular expressions are not supported. </p>
        pub fn set_stopwords(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.stopwords = input;
            self
        }
        /// <p>A JSON object that contains a collection of string:value pairs that each map a term to its stem. For example, <code>{"term1": "stem1", "term2": "stem2", "term3": "stem3"}</code>. The stemming dictionary is applied in addition to any algorithmic stemming. This enables you to override the results of the algorithmic stemming to correct specific cases of overstemming or understemming. The maximum size of a stemming dictionary is 500 KB.</p>
        pub fn stemming_dictionary(mut self, input: impl Into<std::string::String>) -> Self {
            self.stemming_dictionary = Some(input.into());
            self
        }
        /// <p>A JSON object that contains a collection of string:value pairs that each map a term to its stem. For example, <code>{"term1": "stem1", "term2": "stem2", "term3": "stem3"}</code>. The stemming dictionary is applied in addition to any algorithmic stemming. This enables you to override the results of the algorithmic stemming to correct specific cases of overstemming or understemming. The maximum size of a stemming dictionary is 500 KB.</p>
        pub fn set_stemming_dictionary(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.stemming_dictionary = input;
            self
        }
        /// <p>A JSON array that contains a collection of terms, tokens, readings and part of speech for Japanese Tokenizaiton. The Japanese tokenization dictionary enables you to override the default tokenization for selected terms. This is only valid for Japanese language fields.</p>
        pub fn japanese_tokenization_dictionary(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.japanese_tokenization_dictionary = Some(input.into());
            self
        }
        /// <p>A JSON array that contains a collection of terms, tokens, readings and part of speech for Japanese Tokenizaiton. The Japanese tokenization dictionary enables you to override the default tokenization for selected terms. This is only valid for Japanese language fields.</p>
        pub fn set_japanese_tokenization_dictionary(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.japanese_tokenization_dictionary = input;
            self
        }
        /// <p>The level of algorithmic stemming to perform: <code>none</code>, <code>minimal</code>, <code>light</code>, or <code>full</code>. The available levels vary depending on the language. For more information, see <a href="http://docs.aws.amazon.com/cloudsearch/latest/developerguide/text-processing.html#text-processing-settings" target="_blank">Language Specific Text Processing Settings</a> in the <i>Amazon CloudSearch Developer Guide</i> </p>
        pub fn algorithmic_stemming(mut self, input: crate::model::AlgorithmicStemming) -> Self {
            self.algorithmic_stemming = Some(input);
            self
        }
        /// <p>The level of algorithmic stemming to perform: <code>none</code>, <code>minimal</code>, <code>light</code>, or <code>full</code>. The available levels vary depending on the language. For more information, see <a href="http://docs.aws.amazon.com/cloudsearch/latest/developerguide/text-processing.html#text-processing-settings" target="_blank">Language Specific Text Processing Settings</a> in the <i>Amazon CloudSearch Developer Guide</i> </p>
        pub fn set_algorithmic_stemming(
            mut self,
            input: std::option::Option<crate::model::AlgorithmicStemming>,
        ) -> Self {
            self.algorithmic_stemming = input;
            self
        }
        /// Consumes the builder and constructs a [`AnalysisOptions`](crate::model::AnalysisOptions)
        pub fn build(self) -> crate::model::AnalysisOptions {
            crate::model::AnalysisOptions {
                synonyms: self.synonyms,
                stopwords: self.stopwords,
                stemming_dictionary: self.stemming_dictionary,
                japanese_tokenization_dictionary: self.japanese_tokenization_dictionary,
                algorithmic_stemming: self.algorithmic_stemming,
            }
        }
    }
}
impl AnalysisOptions {
    /// Creates a new builder-style object to manufacture [`AnalysisOptions`](crate::model::AnalysisOptions)
    pub fn builder() -> crate::model::analysis_options::Builder {
        crate::model::analysis_options::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum AlgorithmicStemming {
    #[allow(missing_docs)] // documentation missing in model
    Full,
    #[allow(missing_docs)] // documentation missing in model
    Light,
    #[allow(missing_docs)] // documentation missing in model
    Minimal,
    #[allow(missing_docs)] // documentation missing in model
    None,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for AlgorithmicStemming {
    fn from(s: &str) -> Self {
        match s {
            "full" => AlgorithmicStemming::Full,
            "light" => AlgorithmicStemming::Light,
            "minimal" => AlgorithmicStemming::Minimal,
            "none" => AlgorithmicStemming::None,
            other => AlgorithmicStemming::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for AlgorithmicStemming {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(AlgorithmicStemming::from(s))
    }
}
impl AlgorithmicStemming {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            AlgorithmicStemming::Full => "full",
            AlgorithmicStemming::Light => "light",
            AlgorithmicStemming::Minimal => "minimal",
            AlgorithmicStemming::None => "none",
            AlgorithmicStemming::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["full", "light", "minimal", "none"]
    }
}
impl AsRef<str> for AlgorithmicStemming {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>An <a href="http://tools.ietf.org/html/rfc4646" target="_blank">IETF RFC 4646</a> language code or <code>mul</code>  for multiple languages.</p>
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum AnalysisSchemeLanguage {
    #[allow(missing_docs)] // documentation missing in model
    Ar,
    #[allow(missing_docs)] // documentation missing in model
    Bg,
    #[allow(missing_docs)] // documentation missing in model
    Ca,
    #[allow(missing_docs)] // documentation missing in model
    Cs,
    #[allow(missing_docs)] // documentation missing in model
    Da,
    #[allow(missing_docs)] // documentation missing in model
    De,
    #[allow(missing_docs)] // documentation missing in model
    El,
    #[allow(missing_docs)] // documentation missing in model
    En,
    #[allow(missing_docs)] // documentation missing in model
    Es,
    #[allow(missing_docs)] // documentation missing in model
    Eu,
    #[allow(missing_docs)] // documentation missing in model
    Fa,
    #[allow(missing_docs)] // documentation missing in model
    Fi,
    #[allow(missing_docs)] // documentation missing in model
    Fr,
    #[allow(missing_docs)] // documentation missing in model
    Ga,
    #[allow(missing_docs)] // documentation missing in model
    Gl,
    #[allow(missing_docs)] // documentation missing in model
    He,
    #[allow(missing_docs)] // documentation missing in model
    Hi,
    #[allow(missing_docs)] // documentation missing in model
    Hu,
    #[allow(missing_docs)] // documentation missing in model
    Hy,
    #[allow(missing_docs)] // documentation missing in model
    Id,
    #[allow(missing_docs)] // documentation missing in model
    It,
    #[allow(missing_docs)] // documentation missing in model
    Ja,
    #[allow(missing_docs)] // documentation missing in model
    Ko,
    #[allow(missing_docs)] // documentation missing in model
    Lv,
    #[allow(missing_docs)] // documentation missing in model
    Mul,
    #[allow(missing_docs)] // documentation missing in model
    Nl,
    #[allow(missing_docs)] // documentation missing in model
    No,
    #[allow(missing_docs)] // documentation missing in model
    Pt,
    #[allow(missing_docs)] // documentation missing in model
    Ro,
    #[allow(missing_docs)] // documentation missing in model
    Ru,
    #[allow(missing_docs)] // documentation missing in model
    Sv,
    #[allow(missing_docs)] // documentation missing in model
    Th,
    #[allow(missing_docs)] // documentation missing in model
    Tr,
    #[allow(missing_docs)] // documentation missing in model
    ZhHans,
    #[allow(missing_docs)] // documentation missing in model
    ZhHant,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for AnalysisSchemeLanguage {
    fn from(s: &str) -> Self {
        match s {
            "ar" => AnalysisSchemeLanguage::Ar,
            "bg" => AnalysisSchemeLanguage::Bg,
            "ca" => AnalysisSchemeLanguage::Ca,
            "cs" => AnalysisSchemeLanguage::Cs,
            "da" => AnalysisSchemeLanguage::Da,
            "de" => AnalysisSchemeLanguage::De,
            "el" => AnalysisSchemeLanguage::El,
            "en" => AnalysisSchemeLanguage::En,
            "es" => AnalysisSchemeLanguage::Es,
            "eu" => AnalysisSchemeLanguage::Eu,
            "fa" => AnalysisSchemeLanguage::Fa,
            "fi" => AnalysisSchemeLanguage::Fi,
            "fr" => AnalysisSchemeLanguage::Fr,
            "ga" => AnalysisSchemeLanguage::Ga,
            "gl" => AnalysisSchemeLanguage::Gl,
            "he" => AnalysisSchemeLanguage::He,
            "hi" => AnalysisSchemeLanguage::Hi,
            "hu" => AnalysisSchemeLanguage::Hu,
            "hy" => AnalysisSchemeLanguage::Hy,
            "id" => AnalysisSchemeLanguage::Id,
            "it" => AnalysisSchemeLanguage::It,
            "ja" => AnalysisSchemeLanguage::Ja,
            "ko" => AnalysisSchemeLanguage::Ko,
            "lv" => AnalysisSchemeLanguage::Lv,
            "mul" => AnalysisSchemeLanguage::Mul,
            "nl" => AnalysisSchemeLanguage::Nl,
            "no" => AnalysisSchemeLanguage::No,
            "pt" => AnalysisSchemeLanguage::Pt,
            "ro" => AnalysisSchemeLanguage::Ro,
            "ru" => AnalysisSchemeLanguage::Ru,
            "sv" => AnalysisSchemeLanguage::Sv,
            "th" => AnalysisSchemeLanguage::Th,
            "tr" => AnalysisSchemeLanguage::Tr,
            "zh-Hans" => AnalysisSchemeLanguage::ZhHans,
            "zh-Hant" => AnalysisSchemeLanguage::ZhHant,
            other => AnalysisSchemeLanguage::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for AnalysisSchemeLanguage {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(AnalysisSchemeLanguage::from(s))
    }
}
impl AnalysisSchemeLanguage {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            AnalysisSchemeLanguage::Ar => "ar",
            AnalysisSchemeLanguage::Bg => "bg",
            AnalysisSchemeLanguage::Ca => "ca",
            AnalysisSchemeLanguage::Cs => "cs",
            AnalysisSchemeLanguage::Da => "da",
            AnalysisSchemeLanguage::De => "de",
            AnalysisSchemeLanguage::El => "el",
            AnalysisSchemeLanguage::En => "en",
            AnalysisSchemeLanguage::Es => "es",
            AnalysisSchemeLanguage::Eu => "eu",
            AnalysisSchemeLanguage::Fa => "fa",
            AnalysisSchemeLanguage::Fi => "fi",
            AnalysisSchemeLanguage::Fr => "fr",
            AnalysisSchemeLanguage::Ga => "ga",
            AnalysisSchemeLanguage::Gl => "gl",
            AnalysisSchemeLanguage::He => "he",
            AnalysisSchemeLanguage::Hi => "hi",
            AnalysisSchemeLanguage::Hu => "hu",
            AnalysisSchemeLanguage::Hy => "hy",
            AnalysisSchemeLanguage::Id => "id",
            AnalysisSchemeLanguage::It => "it",
            AnalysisSchemeLanguage::Ja => "ja",
            AnalysisSchemeLanguage::Ko => "ko",
            AnalysisSchemeLanguage::Lv => "lv",
            AnalysisSchemeLanguage::Mul => "mul",
            AnalysisSchemeLanguage::Nl => "nl",
            AnalysisSchemeLanguage::No => "no",
            AnalysisSchemeLanguage::Pt => "pt",
            AnalysisSchemeLanguage::Ro => "ro",
            AnalysisSchemeLanguage::Ru => "ru",
            AnalysisSchemeLanguage::Sv => "sv",
            AnalysisSchemeLanguage::Th => "th",
            AnalysisSchemeLanguage::Tr => "tr",
            AnalysisSchemeLanguage::ZhHans => "zh-Hans",
            AnalysisSchemeLanguage::ZhHant => "zh-Hant",
            AnalysisSchemeLanguage::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "ar", "bg", "ca", "cs", "da", "de", "el", "en", "es", "eu", "fa", "fi", "fr", "ga",
            "gl", "he", "hi", "hu", "hy", "id", "it", "ja", "ko", "lv", "mul", "nl", "no", "pt",
            "ro", "ru", "sv", "th", "tr", "zh-Hans", "zh-Hant",
        ]
    }
}
impl AsRef<str> for AnalysisSchemeLanguage {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}
