// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
pub fn parse_http_generic_error(
    response: &http::Response<bytes::Bytes>,
) -> Result<aws_smithy_types::Error, aws_smithy_xml::decode::XmlError> {
    crate::rest_xml_wrapped_errors::parse_generic_error(response.body().as_ref())
}

#[allow(unused_mut)]
pub fn deser_structure_crate_error_base_exception_xml_err(
    inp: &[u8],
    mut builder: crate::error::base_exception::Builder,
) -> Result<crate::error::base_exception::Builder, aws_smithy_xml::decode::XmlError> {
    if inp.is_empty() {
        return Ok(builder);
    }
    use std::convert::TryFrom;
    let mut document = aws_smithy_xml::decode::Document::try_from(inp)?;
    #[allow(unused_mut)]
    let mut error_decoder = crate::rest_xml_wrapped_errors::error_scope(&mut document)?;
    while let Some(mut tag) = error_decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("Message") /* Message com.amazonaws.cloudsearch#BaseException$Message */ =>  {
                let var_1 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_message(var_1);
            }
            ,
            s if s.matches("Code") /* Code com.amazonaws.cloudsearch#BaseException$Code */ =>  {
                let var_2 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_code(var_2);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_structure_crate_error_internal_exception_xml_err(
    inp: &[u8],
    mut builder: crate::error::internal_exception::Builder,
) -> Result<crate::error::internal_exception::Builder, aws_smithy_xml::decode::XmlError> {
    if inp.is_empty() {
        return Ok(builder);
    }
    use std::convert::TryFrom;
    let mut document = aws_smithy_xml::decode::Document::try_from(inp)?;
    #[allow(unused_mut)]
    let mut error_decoder = crate::rest_xml_wrapped_errors::error_scope(&mut document)?;
    while let Some(mut tag) = error_decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("Message") /* Message com.amazonaws.cloudsearch#InternalException$Message */ =>  {
                let var_3 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_message(var_3);
            }
            ,
            s if s.matches("Code") /* Code com.amazonaws.cloudsearch#InternalException$Code */ =>  {
                let var_4 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_code(var_4);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_structure_crate_error_resource_not_found_exception_xml_err(
    inp: &[u8],
    mut builder: crate::error::resource_not_found_exception::Builder,
) -> Result<crate::error::resource_not_found_exception::Builder, aws_smithy_xml::decode::XmlError> {
    if inp.is_empty() {
        return Ok(builder);
    }
    use std::convert::TryFrom;
    let mut document = aws_smithy_xml::decode::Document::try_from(inp)?;
    #[allow(unused_mut)]
    let mut error_decoder = crate::rest_xml_wrapped_errors::error_scope(&mut document)?;
    while let Some(mut tag) = error_decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("Message") /* Message com.amazonaws.cloudsearch#ResourceNotFoundException$Message */ =>  {
                let var_5 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_message(var_5);
            }
            ,
            s if s.matches("Code") /* Code com.amazonaws.cloudsearch#ResourceNotFoundException$Code */ =>  {
                let var_6 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_code(var_6);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_structure_crate_error_validation_exception_xml_err(
    inp: &[u8],
    mut builder: crate::error::validation_exception::Builder,
) -> Result<crate::error::validation_exception::Builder, aws_smithy_xml::decode::XmlError> {
    if inp.is_empty() {
        return Ok(builder);
    }
    use std::convert::TryFrom;
    let mut document = aws_smithy_xml::decode::Document::try_from(inp)?;
    #[allow(unused_mut)]
    let mut error_decoder = crate::rest_xml_wrapped_errors::error_scope(&mut document)?;
    while let Some(mut tag) = error_decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("Message") /* Message com.amazonaws.cloudsearch#ValidationException$Message */ =>  {
                let var_7 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_message(var_7);
            }
            ,
            s if s.matches("Code") /* Code com.amazonaws.cloudsearch#ValidationException$Code */ =>  {
                let var_8 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_code(var_8);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_build_suggesters(
    inp: &[u8],
    mut builder: crate::output::build_suggesters_output::Builder,
) -> Result<crate::output::build_suggesters_output::Builder, aws_smithy_xml::decode::XmlError> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("BuildSuggestersResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected BuildSuggestersResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("BuildSuggestersResult")) {
            return Err(aws_smithy_xml::decode::XmlError::custom(format!(
                "invalid result, expected BuildSuggestersResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("FieldNames") /* FieldNames com.amazonaws.cloudsearch.synthetic#BuildSuggestersOutput$FieldNames */ =>  {
                let var_9 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_cloudsearch_field_name_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_field_names(var_9);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(aws_smithy_xml::decode::XmlError::custom(
            "expected BuildSuggestersResult tag",
        ));
    };
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_structure_crate_error_limit_exceeded_exception_xml_err(
    inp: &[u8],
    mut builder: crate::error::limit_exceeded_exception::Builder,
) -> Result<crate::error::limit_exceeded_exception::Builder, aws_smithy_xml::decode::XmlError> {
    if inp.is_empty() {
        return Ok(builder);
    }
    use std::convert::TryFrom;
    let mut document = aws_smithy_xml::decode::Document::try_from(inp)?;
    #[allow(unused_mut)]
    let mut error_decoder = crate::rest_xml_wrapped_errors::error_scope(&mut document)?;
    while let Some(mut tag) = error_decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("Message") /* Message com.amazonaws.cloudsearch#LimitExceededException$Message */ =>  {
                let var_10 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_message(var_10);
            }
            ,
            s if s.matches("Code") /* Code com.amazonaws.cloudsearch#LimitExceededException$Code */ =>  {
                let var_11 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_code(var_11);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_structure_crate_error_resource_already_exists_exception_xml_err(
    inp: &[u8],
    mut builder: crate::error::resource_already_exists_exception::Builder,
) -> Result<
    crate::error::resource_already_exists_exception::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    if inp.is_empty() {
        return Ok(builder);
    }
    use std::convert::TryFrom;
    let mut document = aws_smithy_xml::decode::Document::try_from(inp)?;
    #[allow(unused_mut)]
    let mut error_decoder = crate::rest_xml_wrapped_errors::error_scope(&mut document)?;
    while let Some(mut tag) = error_decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("Message") /* Message com.amazonaws.cloudsearch#ResourceAlreadyExistsException$Message */ =>  {
                let var_12 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_message(var_12);
            }
            ,
            s if s.matches("Code") /* Code com.amazonaws.cloudsearch#ResourceAlreadyExistsException$Code */ =>  {
                let var_13 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_code(var_13);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_create_domain(
    inp: &[u8],
    mut builder: crate::output::create_domain_output::Builder,
) -> Result<crate::output::create_domain_output::Builder, aws_smithy_xml::decode::XmlError> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("CreateDomainResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected CreateDomainResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("CreateDomainResult")) {
            return Err(aws_smithy_xml::decode::XmlError::custom(format!(
                "invalid result, expected CreateDomainResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("DomainStatus") /* DomainStatus com.amazonaws.cloudsearch.synthetic#CreateDomainOutput$DomainStatus */ =>  {
                let var_14 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_domain_status(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_domain_status(var_14);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(aws_smithy_xml::decode::XmlError::custom(
            "expected CreateDomainResult tag",
        ));
    };
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_structure_crate_error_invalid_type_exception_xml_err(
    inp: &[u8],
    mut builder: crate::error::invalid_type_exception::Builder,
) -> Result<crate::error::invalid_type_exception::Builder, aws_smithy_xml::decode::XmlError> {
    if inp.is_empty() {
        return Ok(builder);
    }
    use std::convert::TryFrom;
    let mut document = aws_smithy_xml::decode::Document::try_from(inp)?;
    #[allow(unused_mut)]
    let mut error_decoder = crate::rest_xml_wrapped_errors::error_scope(&mut document)?;
    while let Some(mut tag) = error_decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("Message") /* Message com.amazonaws.cloudsearch#InvalidTypeException$Message */ =>  {
                let var_15 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_message(var_15);
            }
            ,
            s if s.matches("Code") /* Code com.amazonaws.cloudsearch#InvalidTypeException$Code */ =>  {
                let var_16 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_code(var_16);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_define_analysis_scheme(
    inp: &[u8],
    mut builder: crate::output::define_analysis_scheme_output::Builder,
) -> Result<crate::output::define_analysis_scheme_output::Builder, aws_smithy_xml::decode::XmlError>
{
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("DefineAnalysisSchemeResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected DefineAnalysisSchemeResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("DefineAnalysisSchemeResult")) {
            return Err(aws_smithy_xml::decode::XmlError::custom(format!(
                "invalid result, expected DefineAnalysisSchemeResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("AnalysisScheme") /* AnalysisScheme com.amazonaws.cloudsearch.synthetic#DefineAnalysisSchemeOutput$AnalysisScheme */ =>  {
                let var_17 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_analysis_scheme_status(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_analysis_scheme(var_17);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(aws_smithy_xml::decode::XmlError::custom(
            "expected DefineAnalysisSchemeResult tag",
        ));
    };
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_define_expression(
    inp: &[u8],
    mut builder: crate::output::define_expression_output::Builder,
) -> Result<crate::output::define_expression_output::Builder, aws_smithy_xml::decode::XmlError> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("DefineExpressionResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected DefineExpressionResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("DefineExpressionResult")) {
            return Err(aws_smithy_xml::decode::XmlError::custom(format!(
                "invalid result, expected DefineExpressionResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("Expression") /* Expression com.amazonaws.cloudsearch.synthetic#DefineExpressionOutput$Expression */ =>  {
                let var_18 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_expression_status(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_expression(var_18);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(aws_smithy_xml::decode::XmlError::custom(
            "expected DefineExpressionResult tag",
        ));
    };
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_define_index_field(
    inp: &[u8],
    mut builder: crate::output::define_index_field_output::Builder,
) -> Result<crate::output::define_index_field_output::Builder, aws_smithy_xml::decode::XmlError> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("DefineIndexFieldResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected DefineIndexFieldResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("DefineIndexFieldResult")) {
            return Err(aws_smithy_xml::decode::XmlError::custom(format!(
                "invalid result, expected DefineIndexFieldResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("IndexField") /* IndexField com.amazonaws.cloudsearch.synthetic#DefineIndexFieldOutput$IndexField */ =>  {
                let var_19 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_index_field_status(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_index_field(var_19);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(aws_smithy_xml::decode::XmlError::custom(
            "expected DefineIndexFieldResult tag",
        ));
    };
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_define_suggester(
    inp: &[u8],
    mut builder: crate::output::define_suggester_output::Builder,
) -> Result<crate::output::define_suggester_output::Builder, aws_smithy_xml::decode::XmlError> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("DefineSuggesterResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected DefineSuggesterResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("DefineSuggesterResult")) {
            return Err(aws_smithy_xml::decode::XmlError::custom(format!(
                "invalid result, expected DefineSuggesterResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("Suggester") /* Suggester com.amazonaws.cloudsearch.synthetic#DefineSuggesterOutput$Suggester */ =>  {
                let var_20 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_suggester_status(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_suggester(var_20);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(aws_smithy_xml::decode::XmlError::custom(
            "expected DefineSuggesterResult tag",
        ));
    };
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_delete_analysis_scheme(
    inp: &[u8],
    mut builder: crate::output::delete_analysis_scheme_output::Builder,
) -> Result<crate::output::delete_analysis_scheme_output::Builder, aws_smithy_xml::decode::XmlError>
{
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("DeleteAnalysisSchemeResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected DeleteAnalysisSchemeResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("DeleteAnalysisSchemeResult")) {
            return Err(aws_smithy_xml::decode::XmlError::custom(format!(
                "invalid result, expected DeleteAnalysisSchemeResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("AnalysisScheme") /* AnalysisScheme com.amazonaws.cloudsearch.synthetic#DeleteAnalysisSchemeOutput$AnalysisScheme */ =>  {
                let var_21 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_analysis_scheme_status(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_analysis_scheme(var_21);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(aws_smithy_xml::decode::XmlError::custom(
            "expected DeleteAnalysisSchemeResult tag",
        ));
    };
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_delete_domain(
    inp: &[u8],
    mut builder: crate::output::delete_domain_output::Builder,
) -> Result<crate::output::delete_domain_output::Builder, aws_smithy_xml::decode::XmlError> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("DeleteDomainResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected DeleteDomainResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("DeleteDomainResult")) {
            return Err(aws_smithy_xml::decode::XmlError::custom(format!(
                "invalid result, expected DeleteDomainResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("DomainStatus") /* DomainStatus com.amazonaws.cloudsearch.synthetic#DeleteDomainOutput$DomainStatus */ =>  {
                let var_22 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_domain_status(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_domain_status(var_22);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(aws_smithy_xml::decode::XmlError::custom(
            "expected DeleteDomainResult tag",
        ));
    };
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_delete_expression(
    inp: &[u8],
    mut builder: crate::output::delete_expression_output::Builder,
) -> Result<crate::output::delete_expression_output::Builder, aws_smithy_xml::decode::XmlError> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("DeleteExpressionResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected DeleteExpressionResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("DeleteExpressionResult")) {
            return Err(aws_smithy_xml::decode::XmlError::custom(format!(
                "invalid result, expected DeleteExpressionResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("Expression") /* Expression com.amazonaws.cloudsearch.synthetic#DeleteExpressionOutput$Expression */ =>  {
                let var_23 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_expression_status(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_expression(var_23);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(aws_smithy_xml::decode::XmlError::custom(
            "expected DeleteExpressionResult tag",
        ));
    };
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_delete_index_field(
    inp: &[u8],
    mut builder: crate::output::delete_index_field_output::Builder,
) -> Result<crate::output::delete_index_field_output::Builder, aws_smithy_xml::decode::XmlError> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("DeleteIndexFieldResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected DeleteIndexFieldResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("DeleteIndexFieldResult")) {
            return Err(aws_smithy_xml::decode::XmlError::custom(format!(
                "invalid result, expected DeleteIndexFieldResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("IndexField") /* IndexField com.amazonaws.cloudsearch.synthetic#DeleteIndexFieldOutput$IndexField */ =>  {
                let var_24 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_index_field_status(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_index_field(var_24);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(aws_smithy_xml::decode::XmlError::custom(
            "expected DeleteIndexFieldResult tag",
        ));
    };
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_delete_suggester(
    inp: &[u8],
    mut builder: crate::output::delete_suggester_output::Builder,
) -> Result<crate::output::delete_suggester_output::Builder, aws_smithy_xml::decode::XmlError> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("DeleteSuggesterResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected DeleteSuggesterResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("DeleteSuggesterResult")) {
            return Err(aws_smithy_xml::decode::XmlError::custom(format!(
                "invalid result, expected DeleteSuggesterResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("Suggester") /* Suggester com.amazonaws.cloudsearch.synthetic#DeleteSuggesterOutput$Suggester */ =>  {
                let var_25 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_suggester_status(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_suggester(var_25);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(aws_smithy_xml::decode::XmlError::custom(
            "expected DeleteSuggesterResult tag",
        ));
    };
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_describe_analysis_schemes(
    inp: &[u8],
    mut builder: crate::output::describe_analysis_schemes_output::Builder,
) -> Result<
    crate::output::describe_analysis_schemes_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("DescribeAnalysisSchemesResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected DescribeAnalysisSchemesResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("DescribeAnalysisSchemesResult")) {
            return Err(aws_smithy_xml::decode::XmlError::custom(format!(
                "invalid result, expected DescribeAnalysisSchemesResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("AnalysisSchemes") /* AnalysisSchemes com.amazonaws.cloudsearch.synthetic#DescribeAnalysisSchemesOutput$AnalysisSchemes */ =>  {
                let var_26 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_cloudsearch_analysis_scheme_status_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_analysis_schemes(var_26);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(aws_smithy_xml::decode::XmlError::custom(
            "expected DescribeAnalysisSchemesResult tag",
        ));
    };
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_structure_crate_error_disabled_operation_exception_xml_err(
    inp: &[u8],
    mut builder: crate::error::disabled_operation_exception::Builder,
) -> Result<crate::error::disabled_operation_exception::Builder, aws_smithy_xml::decode::XmlError> {
    if inp.is_empty() {
        return Ok(builder);
    }
    use std::convert::TryFrom;
    let mut document = aws_smithy_xml::decode::Document::try_from(inp)?;
    #[allow(unused_mut)]
    let mut error_decoder = crate::rest_xml_wrapped_errors::error_scope(&mut document)?;
    while let Some(mut tag) = error_decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("Message") /* Message com.amazonaws.cloudsearch#DisabledOperationException$Message */ =>  {
                let var_27 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_message(var_27);
            }
            ,
            s if s.matches("Code") /* Code com.amazonaws.cloudsearch#DisabledOperationException$Code */ =>  {
                let var_28 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_code(var_28);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_describe_availability_options(
    inp: &[u8],
    mut builder: crate::output::describe_availability_options_output::Builder,
) -> Result<
    crate::output::describe_availability_options_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("DescribeAvailabilityOptionsResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected DescribeAvailabilityOptionsResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("DescribeAvailabilityOptionsResult")) {
            return Err(aws_smithy_xml::decode::XmlError::custom(format!(
                "invalid result, expected DescribeAvailabilityOptionsResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("AvailabilityOptions") /* AvailabilityOptions com.amazonaws.cloudsearch.synthetic#DescribeAvailabilityOptionsOutput$AvailabilityOptions */ =>  {
                let var_29 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_availability_options_status(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_availability_options(var_29);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(aws_smithy_xml::decode::XmlError::custom(
            "expected DescribeAvailabilityOptionsResult tag",
        ));
    };
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_describe_domain_endpoint_options(
    inp: &[u8],
    mut builder: crate::output::describe_domain_endpoint_options_output::Builder,
) -> Result<
    crate::output::describe_domain_endpoint_options_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("DescribeDomainEndpointOptionsResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected DescribeDomainEndpointOptionsResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("DescribeDomainEndpointOptionsResult")) {
            return Err(aws_smithy_xml::decode::XmlError::custom(format!(
                "invalid result, expected DescribeDomainEndpointOptionsResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("DomainEndpointOptions") /* DomainEndpointOptions com.amazonaws.cloudsearch.synthetic#DescribeDomainEndpointOptionsOutput$DomainEndpointOptions */ =>  {
                let var_30 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_domain_endpoint_options_status(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_domain_endpoint_options(var_30);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(aws_smithy_xml::decode::XmlError::custom(
            "expected DescribeDomainEndpointOptionsResult tag",
        ));
    };
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_describe_domains(
    inp: &[u8],
    mut builder: crate::output::describe_domains_output::Builder,
) -> Result<crate::output::describe_domains_output::Builder, aws_smithy_xml::decode::XmlError> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("DescribeDomainsResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected DescribeDomainsResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("DescribeDomainsResult")) {
            return Err(aws_smithy_xml::decode::XmlError::custom(format!(
                "invalid result, expected DescribeDomainsResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("DomainStatusList") /* DomainStatusList com.amazonaws.cloudsearch.synthetic#DescribeDomainsOutput$DomainStatusList */ =>  {
                let var_31 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_cloudsearch_domain_status_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_domain_status_list(var_31);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(aws_smithy_xml::decode::XmlError::custom(
            "expected DescribeDomainsResult tag",
        ));
    };
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_describe_expressions(
    inp: &[u8],
    mut builder: crate::output::describe_expressions_output::Builder,
) -> Result<crate::output::describe_expressions_output::Builder, aws_smithy_xml::decode::XmlError> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("DescribeExpressionsResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected DescribeExpressionsResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("DescribeExpressionsResult")) {
            return Err(aws_smithy_xml::decode::XmlError::custom(format!(
                "invalid result, expected DescribeExpressionsResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("Expressions") /* Expressions com.amazonaws.cloudsearch.synthetic#DescribeExpressionsOutput$Expressions */ =>  {
                let var_32 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_cloudsearch_expression_status_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_expressions(var_32);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(aws_smithy_xml::decode::XmlError::custom(
            "expected DescribeExpressionsResult tag",
        ));
    };
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_describe_index_fields(
    inp: &[u8],
    mut builder: crate::output::describe_index_fields_output::Builder,
) -> Result<crate::output::describe_index_fields_output::Builder, aws_smithy_xml::decode::XmlError>
{
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("DescribeIndexFieldsResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected DescribeIndexFieldsResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("DescribeIndexFieldsResult")) {
            return Err(aws_smithy_xml::decode::XmlError::custom(format!(
                "invalid result, expected DescribeIndexFieldsResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("IndexFields") /* IndexFields com.amazonaws.cloudsearch.synthetic#DescribeIndexFieldsOutput$IndexFields */ =>  {
                let var_33 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_cloudsearch_index_field_status_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_index_fields(var_33);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(aws_smithy_xml::decode::XmlError::custom(
            "expected DescribeIndexFieldsResult tag",
        ));
    };
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_describe_scaling_parameters(
    inp: &[u8],
    mut builder: crate::output::describe_scaling_parameters_output::Builder,
) -> Result<
    crate::output::describe_scaling_parameters_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("DescribeScalingParametersResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected DescribeScalingParametersResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("DescribeScalingParametersResult")) {
            return Err(aws_smithy_xml::decode::XmlError::custom(format!(
                "invalid result, expected DescribeScalingParametersResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("ScalingParameters") /* ScalingParameters com.amazonaws.cloudsearch.synthetic#DescribeScalingParametersOutput$ScalingParameters */ =>  {
                let var_34 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_scaling_parameters_status(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_scaling_parameters(var_34);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(aws_smithy_xml::decode::XmlError::custom(
            "expected DescribeScalingParametersResult tag",
        ));
    };
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_describe_service_access_policies(
    inp: &[u8],
    mut builder: crate::output::describe_service_access_policies_output::Builder,
) -> Result<
    crate::output::describe_service_access_policies_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("DescribeServiceAccessPoliciesResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected DescribeServiceAccessPoliciesResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("DescribeServiceAccessPoliciesResult")) {
            return Err(aws_smithy_xml::decode::XmlError::custom(format!(
                "invalid result, expected DescribeServiceAccessPoliciesResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("AccessPolicies") /* AccessPolicies com.amazonaws.cloudsearch.synthetic#DescribeServiceAccessPoliciesOutput$AccessPolicies */ =>  {
                let var_35 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_access_policies_status(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_access_policies(var_35);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(aws_smithy_xml::decode::XmlError::custom(
            "expected DescribeServiceAccessPoliciesResult tag",
        ));
    };
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_describe_suggesters(
    inp: &[u8],
    mut builder: crate::output::describe_suggesters_output::Builder,
) -> Result<crate::output::describe_suggesters_output::Builder, aws_smithy_xml::decode::XmlError> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("DescribeSuggestersResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected DescribeSuggestersResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("DescribeSuggestersResult")) {
            return Err(aws_smithy_xml::decode::XmlError::custom(format!(
                "invalid result, expected DescribeSuggestersResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("Suggesters") /* Suggesters com.amazonaws.cloudsearch.synthetic#DescribeSuggestersOutput$Suggesters */ =>  {
                let var_36 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_cloudsearch_suggester_status_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_suggesters(var_36);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(aws_smithy_xml::decode::XmlError::custom(
            "expected DescribeSuggestersResult tag",
        ));
    };
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_index_documents(
    inp: &[u8],
    mut builder: crate::output::index_documents_output::Builder,
) -> Result<crate::output::index_documents_output::Builder, aws_smithy_xml::decode::XmlError> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("IndexDocumentsResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected IndexDocumentsResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("IndexDocumentsResult")) {
            return Err(aws_smithy_xml::decode::XmlError::custom(format!(
                "invalid result, expected IndexDocumentsResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("FieldNames") /* FieldNames com.amazonaws.cloudsearch.synthetic#IndexDocumentsOutput$FieldNames */ =>  {
                let var_37 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_cloudsearch_field_name_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_field_names(var_37);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(aws_smithy_xml::decode::XmlError::custom(
            "expected IndexDocumentsResult tag",
        ));
    };
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_list_domain_names(
    inp: &[u8],
    mut builder: crate::output::list_domain_names_output::Builder,
) -> Result<crate::output::list_domain_names_output::Builder, aws_smithy_xml::decode::XmlError> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("ListDomainNamesResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected ListDomainNamesResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("ListDomainNamesResult")) {
            return Err(aws_smithy_xml::decode::XmlError::custom(format!(
                "invalid result, expected ListDomainNamesResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("DomainNames") /* DomainNames com.amazonaws.cloudsearch.synthetic#ListDomainNamesOutput$DomainNames */ =>  {
                let var_38 =
                    Some(
                        crate::xml_deser::deser_map_com_amazonaws_cloudsearch_domain_name_map(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_domain_names(var_38);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(aws_smithy_xml::decode::XmlError::custom(
            "expected ListDomainNamesResult tag",
        ));
    };
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_update_availability_options(
    inp: &[u8],
    mut builder: crate::output::update_availability_options_output::Builder,
) -> Result<
    crate::output::update_availability_options_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("UpdateAvailabilityOptionsResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected UpdateAvailabilityOptionsResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("UpdateAvailabilityOptionsResult")) {
            return Err(aws_smithy_xml::decode::XmlError::custom(format!(
                "invalid result, expected UpdateAvailabilityOptionsResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("AvailabilityOptions") /* AvailabilityOptions com.amazonaws.cloudsearch.synthetic#UpdateAvailabilityOptionsOutput$AvailabilityOptions */ =>  {
                let var_39 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_availability_options_status(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_availability_options(var_39);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(aws_smithy_xml::decode::XmlError::custom(
            "expected UpdateAvailabilityOptionsResult tag",
        ));
    };
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_update_domain_endpoint_options(
    inp: &[u8],
    mut builder: crate::output::update_domain_endpoint_options_output::Builder,
) -> Result<
    crate::output::update_domain_endpoint_options_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("UpdateDomainEndpointOptionsResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected UpdateDomainEndpointOptionsResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("UpdateDomainEndpointOptionsResult")) {
            return Err(aws_smithy_xml::decode::XmlError::custom(format!(
                "invalid result, expected UpdateDomainEndpointOptionsResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("DomainEndpointOptions") /* DomainEndpointOptions com.amazonaws.cloudsearch.synthetic#UpdateDomainEndpointOptionsOutput$DomainEndpointOptions */ =>  {
                let var_40 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_domain_endpoint_options_status(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_domain_endpoint_options(var_40);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(aws_smithy_xml::decode::XmlError::custom(
            "expected UpdateDomainEndpointOptionsResult tag",
        ));
    };
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_update_scaling_parameters(
    inp: &[u8],
    mut builder: crate::output::update_scaling_parameters_output::Builder,
) -> Result<
    crate::output::update_scaling_parameters_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("UpdateScalingParametersResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected UpdateScalingParametersResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("UpdateScalingParametersResult")) {
            return Err(aws_smithy_xml::decode::XmlError::custom(format!(
                "invalid result, expected UpdateScalingParametersResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("ScalingParameters") /* ScalingParameters com.amazonaws.cloudsearch.synthetic#UpdateScalingParametersOutput$ScalingParameters */ =>  {
                let var_41 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_scaling_parameters_status(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_scaling_parameters(var_41);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(aws_smithy_xml::decode::XmlError::custom(
            "expected UpdateScalingParametersResult tag",
        ));
    };
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_update_service_access_policies(
    inp: &[u8],
    mut builder: crate::output::update_service_access_policies_output::Builder,
) -> Result<
    crate::output::update_service_access_policies_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("UpdateServiceAccessPoliciesResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected UpdateServiceAccessPoliciesResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("UpdateServiceAccessPoliciesResult")) {
            return Err(aws_smithy_xml::decode::XmlError::custom(format!(
                "invalid result, expected UpdateServiceAccessPoliciesResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("AccessPolicies") /* AccessPolicies com.amazonaws.cloudsearch.synthetic#UpdateServiceAccessPoliciesOutput$AccessPolicies */ =>  {
                let var_42 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_access_policies_status(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_access_policies(var_42);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(aws_smithy_xml::decode::XmlError::custom(
            "expected UpdateServiceAccessPoliciesResult tag",
        ));
    };
    Ok(builder)
}

pub fn deser_list_com_amazonaws_cloudsearch_field_name_list(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<std::vec::Vec<std::string::String>, aws_smithy_xml::decode::XmlError> {
    let mut out = std::vec::Vec::new();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("member") /* member com.amazonaws.cloudsearch#FieldNameList$member */ =>  {
                out.push(
                    Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                        aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                        .into()
                    )
                    ?
                );
            }
            ,
            _ => {}
        }
    }
    Ok(out)
}

pub fn deser_structure_crate_model_domain_status(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::DomainStatus, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::DomainStatus::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("DomainId") /* DomainId com.amazonaws.cloudsearch#DomainStatus$DomainId */ =>  {
                let var_43 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_domain_id(var_43);
            }
            ,
            s if s.matches("DomainName") /* DomainName com.amazonaws.cloudsearch#DomainStatus$DomainName */ =>  {
                let var_44 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_domain_name(var_44);
            }
            ,
            s if s.matches("ARN") /* ARN com.amazonaws.cloudsearch#DomainStatus$ARN */ =>  {
                let var_45 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_arn(var_45);
            }
            ,
            s if s.matches("Created") /* Created com.amazonaws.cloudsearch#DomainStatus$Created */ =>  {
                let var_46 =
                    Some(
                         {
                            <bool as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (boolean: `com.amazonaws.cloudsearch#Boolean`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_created(var_46);
            }
            ,
            s if s.matches("Deleted") /* Deleted com.amazonaws.cloudsearch#DomainStatus$Deleted */ =>  {
                let var_47 =
                    Some(
                         {
                            <bool as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (boolean: `com.amazonaws.cloudsearch#Boolean`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_deleted(var_47);
            }
            ,
            s if s.matches("DocService") /* DocService com.amazonaws.cloudsearch#DomainStatus$DocService */ =>  {
                let var_48 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_service_endpoint(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_doc_service(var_48);
            }
            ,
            s if s.matches("SearchService") /* SearchService com.amazonaws.cloudsearch#DomainStatus$SearchService */ =>  {
                let var_49 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_service_endpoint(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_search_service(var_49);
            }
            ,
            s if s.matches("RequiresIndexDocuments") /* RequiresIndexDocuments com.amazonaws.cloudsearch#DomainStatus$RequiresIndexDocuments */ =>  {
                let var_50 =
                    Some(
                         {
                            <bool as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (boolean: `com.amazonaws.cloudsearch#Boolean`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_requires_index_documents(var_50);
            }
            ,
            s if s.matches("Processing") /* Processing com.amazonaws.cloudsearch#DomainStatus$Processing */ =>  {
                let var_51 =
                    Some(
                         {
                            <bool as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (boolean: `com.amazonaws.cloudsearch#Boolean`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_processing(var_51);
            }
            ,
            s if s.matches("SearchInstanceType") /* SearchInstanceType com.amazonaws.cloudsearch#DomainStatus$SearchInstanceType */ =>  {
                let var_52 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_search_instance_type(var_52);
            }
            ,
            s if s.matches("SearchPartitionCount") /* SearchPartitionCount com.amazonaws.cloudsearch#DomainStatus$SearchPartitionCount */ =>  {
                let var_53 =
                    Some(
                         {
                            <i32 as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (integer: `com.amazonaws.cloudsearch#PartitionCount`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_search_partition_count(var_53);
            }
            ,
            s if s.matches("SearchInstanceCount") /* SearchInstanceCount com.amazonaws.cloudsearch#DomainStatus$SearchInstanceCount */ =>  {
                let var_54 =
                    Some(
                         {
                            <i32 as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (integer: `com.amazonaws.cloudsearch#InstanceCount`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_search_instance_count(var_54);
            }
            ,
            s if s.matches("Limits") /* Limits com.amazonaws.cloudsearch#DomainStatus$Limits */ =>  {
                let var_55 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_limits(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_limits(var_55);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_analysis_scheme_status(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::AnalysisSchemeStatus, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::AnalysisSchemeStatus::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("Options") /* Options com.amazonaws.cloudsearch#AnalysisSchemeStatus$Options */ =>  {
                let var_56 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_analysis_scheme(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_options(var_56);
            }
            ,
            s if s.matches("Status") /* Status com.amazonaws.cloudsearch#AnalysisSchemeStatus$Status */ =>  {
                let var_57 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_option_status(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_status(var_57);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_expression_status(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::ExpressionStatus, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::ExpressionStatus::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("Options") /* Options com.amazonaws.cloudsearch#ExpressionStatus$Options */ =>  {
                let var_58 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_expression(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_options(var_58);
            }
            ,
            s if s.matches("Status") /* Status com.amazonaws.cloudsearch#ExpressionStatus$Status */ =>  {
                let var_59 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_option_status(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_status(var_59);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_index_field_status(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::IndexFieldStatus, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::IndexFieldStatus::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("Options") /* Options com.amazonaws.cloudsearch#IndexFieldStatus$Options */ =>  {
                let var_60 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_index_field(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_options(var_60);
            }
            ,
            s if s.matches("Status") /* Status com.amazonaws.cloudsearch#IndexFieldStatus$Status */ =>  {
                let var_61 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_option_status(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_status(var_61);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_suggester_status(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::SuggesterStatus, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::SuggesterStatus::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("Options") /* Options com.amazonaws.cloudsearch#SuggesterStatus$Options */ =>  {
                let var_62 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_suggester(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_options(var_62);
            }
            ,
            s if s.matches("Status") /* Status com.amazonaws.cloudsearch#SuggesterStatus$Status */ =>  {
                let var_63 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_option_status(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_status(var_63);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_list_com_amazonaws_cloudsearch_analysis_scheme_status_list(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<std::vec::Vec<crate::model::AnalysisSchemeStatus>, aws_smithy_xml::decode::XmlError> {
    let mut out = std::vec::Vec::new();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("member") /* member com.amazonaws.cloudsearch#AnalysisSchemeStatusList$member */ =>  {
                out.push(
                    crate::xml_deser::deser_structure_crate_model_analysis_scheme_status(&mut tag)
                    ?
                );
            }
            ,
            _ => {}
        }
    }
    Ok(out)
}

pub fn deser_structure_crate_model_availability_options_status(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::AvailabilityOptionsStatus, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::AvailabilityOptionsStatus::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("Options") /* Options com.amazonaws.cloudsearch#AvailabilityOptionsStatus$Options */ =>  {
                let var_64 =
                    Some(
                         {
                            <bool as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (boolean: `com.amazonaws.cloudsearch#MultiAZ`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_options(var_64);
            }
            ,
            s if s.matches("Status") /* Status com.amazonaws.cloudsearch#AvailabilityOptionsStatus$Status */ =>  {
                let var_65 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_option_status(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_status(var_65);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_domain_endpoint_options_status(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::DomainEndpointOptionsStatus, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::DomainEndpointOptionsStatus::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("Options") /* Options com.amazonaws.cloudsearch#DomainEndpointOptionsStatus$Options */ =>  {
                let var_66 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_domain_endpoint_options(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_options(var_66);
            }
            ,
            s if s.matches("Status") /* Status com.amazonaws.cloudsearch#DomainEndpointOptionsStatus$Status */ =>  {
                let var_67 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_option_status(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_status(var_67);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_list_com_amazonaws_cloudsearch_domain_status_list(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<std::vec::Vec<crate::model::DomainStatus>, aws_smithy_xml::decode::XmlError> {
    let mut out = std::vec::Vec::new();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("member") /* member com.amazonaws.cloudsearch#DomainStatusList$member */ =>  {
                out.push(
                    crate::xml_deser::deser_structure_crate_model_domain_status(&mut tag)
                    ?
                );
            }
            ,
            _ => {}
        }
    }
    Ok(out)
}

pub fn deser_list_com_amazonaws_cloudsearch_expression_status_list(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<std::vec::Vec<crate::model::ExpressionStatus>, aws_smithy_xml::decode::XmlError> {
    let mut out = std::vec::Vec::new();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("member") /* member com.amazonaws.cloudsearch#ExpressionStatusList$member */ =>  {
                out.push(
                    crate::xml_deser::deser_structure_crate_model_expression_status(&mut tag)
                    ?
                );
            }
            ,
            _ => {}
        }
    }
    Ok(out)
}

pub fn deser_list_com_amazonaws_cloudsearch_index_field_status_list(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<std::vec::Vec<crate::model::IndexFieldStatus>, aws_smithy_xml::decode::XmlError> {
    let mut out = std::vec::Vec::new();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("member") /* member com.amazonaws.cloudsearch#IndexFieldStatusList$member */ =>  {
                out.push(
                    crate::xml_deser::deser_structure_crate_model_index_field_status(&mut tag)
                    ?
                );
            }
            ,
            _ => {}
        }
    }
    Ok(out)
}

pub fn deser_structure_crate_model_scaling_parameters_status(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::ScalingParametersStatus, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::ScalingParametersStatus::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("Options") /* Options com.amazonaws.cloudsearch#ScalingParametersStatus$Options */ =>  {
                let var_68 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_scaling_parameters(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_options(var_68);
            }
            ,
            s if s.matches("Status") /* Status com.amazonaws.cloudsearch#ScalingParametersStatus$Status */ =>  {
                let var_69 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_option_status(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_status(var_69);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_access_policies_status(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::AccessPoliciesStatus, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::AccessPoliciesStatus::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("Options") /* Options com.amazonaws.cloudsearch#AccessPoliciesStatus$Options */ =>  {
                let var_70 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_options(var_70);
            }
            ,
            s if s.matches("Status") /* Status com.amazonaws.cloudsearch#AccessPoliciesStatus$Status */ =>  {
                let var_71 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_option_status(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_status(var_71);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_list_com_amazonaws_cloudsearch_suggester_status_list(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<std::vec::Vec<crate::model::SuggesterStatus>, aws_smithy_xml::decode::XmlError> {
    let mut out = std::vec::Vec::new();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("member") /* member com.amazonaws.cloudsearch#SuggesterStatusList$member */ =>  {
                out.push(
                    crate::xml_deser::deser_structure_crate_model_suggester_status(&mut tag)
                    ?
                );
            }
            ,
            _ => {}
        }
    }
    Ok(out)
}

pub fn deser_map_com_amazonaws_cloudsearch_domain_name_map(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<
    std::collections::HashMap<std::string::String, std::string::String>,
    aws_smithy_xml::decode::XmlError,
> {
    let mut out = std::collections::HashMap::new();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("entry") => {
                crate::xml_deser::deser_map_com_amazonaws_cloudsearch_domain_name_map_entry(
                    &mut tag, &mut out,
                )?;
            }
            _ => {}
        }
    }
    Ok(out)
}

pub fn deser_structure_crate_model_service_endpoint(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::ServiceEndpoint, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::ServiceEndpoint::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("Endpoint") /* Endpoint com.amazonaws.cloudsearch#ServiceEndpoint$Endpoint */ =>  {
                let var_72 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_endpoint(var_72);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_limits(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::Limits, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::Limits::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("MaximumReplicationCount") /* MaximumReplicationCount com.amazonaws.cloudsearch#Limits$MaximumReplicationCount */ =>  {
                let var_73 =
                    Some(
                         {
                            <i32 as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (integer: `com.amazonaws.cloudsearch#MaximumReplicationCount`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_maximum_replication_count(var_73);
            }
            ,
            s if s.matches("MaximumPartitionCount") /* MaximumPartitionCount com.amazonaws.cloudsearch#Limits$MaximumPartitionCount */ =>  {
                let var_74 =
                    Some(
                         {
                            <i32 as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (integer: `com.amazonaws.cloudsearch#MaximumPartitionCount`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_maximum_partition_count(var_74);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_analysis_scheme(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::AnalysisScheme, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::AnalysisScheme::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("AnalysisSchemeName") /* AnalysisSchemeName com.amazonaws.cloudsearch#AnalysisScheme$AnalysisSchemeName */ =>  {
                let var_75 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_analysis_scheme_name(var_75);
            }
            ,
            s if s.matches("AnalysisSchemeLanguage") /* AnalysisSchemeLanguage com.amazonaws.cloudsearch#AnalysisScheme$AnalysisSchemeLanguage */ =>  {
                let var_76 =
                    Some(
                        Result::<crate::model::AnalysisSchemeLanguage, aws_smithy_xml::decode::XmlError>::Ok(
                            crate::model::AnalysisSchemeLanguage::from(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                        )
                        ?
                    )
                ;
                builder = builder.set_analysis_scheme_language(var_76);
            }
            ,
            s if s.matches("AnalysisOptions") /* AnalysisOptions com.amazonaws.cloudsearch#AnalysisScheme$AnalysisOptions */ =>  {
                let var_77 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_analysis_options(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_analysis_options(var_77);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_option_status(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::OptionStatus, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::OptionStatus::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("CreationDate") /* CreationDate com.amazonaws.cloudsearch#OptionStatus$CreationDate */ =>  {
                let var_78 =
                    Some(
                        aws_smithy_types::Instant::from_str(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            , aws_smithy_types::instant::Format::DateTime
                        )
                        .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (timestamp: `com.amazonaws.cloudsearch#UpdateTimestamp`)"))
                        ?
                    )
                ;
                builder = builder.set_creation_date(var_78);
            }
            ,
            s if s.matches("UpdateDate") /* UpdateDate com.amazonaws.cloudsearch#OptionStatus$UpdateDate */ =>  {
                let var_79 =
                    Some(
                        aws_smithy_types::Instant::from_str(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            , aws_smithy_types::instant::Format::DateTime
                        )
                        .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (timestamp: `com.amazonaws.cloudsearch#UpdateTimestamp`)"))
                        ?
                    )
                ;
                builder = builder.set_update_date(var_79);
            }
            ,
            s if s.matches("UpdateVersion") /* UpdateVersion com.amazonaws.cloudsearch#OptionStatus$UpdateVersion */ =>  {
                let var_80 =
                    Some(
                         {
                            <i32 as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (integer: `com.amazonaws.cloudsearch#UIntValue`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_update_version(var_80);
            }
            ,
            s if s.matches("State") /* State com.amazonaws.cloudsearch#OptionStatus$State */ =>  {
                let var_81 =
                    Some(
                        Result::<crate::model::OptionState, aws_smithy_xml::decode::XmlError>::Ok(
                            crate::model::OptionState::from(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                        )
                        ?
                    )
                ;
                builder = builder.set_state(var_81);
            }
            ,
            s if s.matches("PendingDeletion") /* PendingDeletion com.amazonaws.cloudsearch#OptionStatus$PendingDeletion */ =>  {
                let var_82 =
                    Some(
                         {
                            <bool as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (boolean: `com.amazonaws.cloudsearch#Boolean`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_pending_deletion(var_82);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_expression(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::Expression, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::Expression::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("ExpressionName") /* ExpressionName com.amazonaws.cloudsearch#Expression$ExpressionName */ =>  {
                let var_83 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_expression_name(var_83);
            }
            ,
            s if s.matches("ExpressionValue") /* ExpressionValue com.amazonaws.cloudsearch#Expression$ExpressionValue */ =>  {
                let var_84 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_expression_value(var_84);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_index_field(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::IndexField, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::IndexField::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("IndexFieldName") /* IndexFieldName com.amazonaws.cloudsearch#IndexField$IndexFieldName */ =>  {
                let var_85 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_index_field_name(var_85);
            }
            ,
            s if s.matches("IndexFieldType") /* IndexFieldType com.amazonaws.cloudsearch#IndexField$IndexFieldType */ =>  {
                let var_86 =
                    Some(
                        Result::<crate::model::IndexFieldType, aws_smithy_xml::decode::XmlError>::Ok(
                            crate::model::IndexFieldType::from(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                        )
                        ?
                    )
                ;
                builder = builder.set_index_field_type(var_86);
            }
            ,
            s if s.matches("IntOptions") /* IntOptions com.amazonaws.cloudsearch#IndexField$IntOptions */ =>  {
                let var_87 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_int_options(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_int_options(var_87);
            }
            ,
            s if s.matches("DoubleOptions") /* DoubleOptions com.amazonaws.cloudsearch#IndexField$DoubleOptions */ =>  {
                let var_88 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_double_options(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_double_options(var_88);
            }
            ,
            s if s.matches("LiteralOptions") /* LiteralOptions com.amazonaws.cloudsearch#IndexField$LiteralOptions */ =>  {
                let var_89 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_literal_options(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_literal_options(var_89);
            }
            ,
            s if s.matches("TextOptions") /* TextOptions com.amazonaws.cloudsearch#IndexField$TextOptions */ =>  {
                let var_90 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_text_options(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_text_options(var_90);
            }
            ,
            s if s.matches("DateOptions") /* DateOptions com.amazonaws.cloudsearch#IndexField$DateOptions */ =>  {
                let var_91 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_date_options(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_date_options(var_91);
            }
            ,
            s if s.matches("LatLonOptions") /* LatLonOptions com.amazonaws.cloudsearch#IndexField$LatLonOptions */ =>  {
                let var_92 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_lat_lon_options(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_lat_lon_options(var_92);
            }
            ,
            s if s.matches("IntArrayOptions") /* IntArrayOptions com.amazonaws.cloudsearch#IndexField$IntArrayOptions */ =>  {
                let var_93 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_int_array_options(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_int_array_options(var_93);
            }
            ,
            s if s.matches("DoubleArrayOptions") /* DoubleArrayOptions com.amazonaws.cloudsearch#IndexField$DoubleArrayOptions */ =>  {
                let var_94 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_double_array_options(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_double_array_options(var_94);
            }
            ,
            s if s.matches("LiteralArrayOptions") /* LiteralArrayOptions com.amazonaws.cloudsearch#IndexField$LiteralArrayOptions */ =>  {
                let var_95 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_literal_array_options(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_literal_array_options(var_95);
            }
            ,
            s if s.matches("TextArrayOptions") /* TextArrayOptions com.amazonaws.cloudsearch#IndexField$TextArrayOptions */ =>  {
                let var_96 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_text_array_options(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_text_array_options(var_96);
            }
            ,
            s if s.matches("DateArrayOptions") /* DateArrayOptions com.amazonaws.cloudsearch#IndexField$DateArrayOptions */ =>  {
                let var_97 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_date_array_options(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_date_array_options(var_97);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_suggester(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::Suggester, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::Suggester::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("SuggesterName") /* SuggesterName com.amazonaws.cloudsearch#Suggester$SuggesterName */ =>  {
                let var_98 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_suggester_name(var_98);
            }
            ,
            s if s.matches("DocumentSuggesterOptions") /* DocumentSuggesterOptions com.amazonaws.cloudsearch#Suggester$DocumentSuggesterOptions */ =>  {
                let var_99 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_document_suggester_options(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_document_suggester_options(var_99);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_domain_endpoint_options(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::DomainEndpointOptions, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::DomainEndpointOptions::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("EnforceHTTPS") /* EnforceHTTPS com.amazonaws.cloudsearch#DomainEndpointOptions$EnforceHTTPS */ =>  {
                let var_100 =
                    Some(
                         {
                            <bool as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (boolean: `com.amazonaws.cloudsearch#Boolean`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_enforce_https(var_100);
            }
            ,
            s if s.matches("TLSSecurityPolicy") /* TLSSecurityPolicy com.amazonaws.cloudsearch#DomainEndpointOptions$TLSSecurityPolicy */ =>  {
                let var_101 =
                    Some(
                        Result::<crate::model::TlsSecurityPolicy, aws_smithy_xml::decode::XmlError>::Ok(
                            crate::model::TlsSecurityPolicy::from(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                        )
                        ?
                    )
                ;
                builder = builder.set_tls_security_policy(var_101);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_scaling_parameters(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::ScalingParameters, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::ScalingParameters::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("DesiredInstanceType") /* DesiredInstanceType com.amazonaws.cloudsearch#ScalingParameters$DesiredInstanceType */ =>  {
                let var_102 =
                    Some(
                        Result::<crate::model::PartitionInstanceType, aws_smithy_xml::decode::XmlError>::Ok(
                            crate::model::PartitionInstanceType::from(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                        )
                        ?
                    )
                ;
                builder = builder.set_desired_instance_type(var_102);
            }
            ,
            s if s.matches("DesiredReplicationCount") /* DesiredReplicationCount com.amazonaws.cloudsearch#ScalingParameters$DesiredReplicationCount */ =>  {
                let var_103 =
                    Some(
                         {
                            <i32 as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (integer: `com.amazonaws.cloudsearch#UIntValue`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_desired_replication_count(var_103);
            }
            ,
            s if s.matches("DesiredPartitionCount") /* DesiredPartitionCount com.amazonaws.cloudsearch#ScalingParameters$DesiredPartitionCount */ =>  {
                let var_104 =
                    Some(
                         {
                            <i32 as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (integer: `com.amazonaws.cloudsearch#UIntValue`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_desired_partition_count(var_104);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_map_com_amazonaws_cloudsearch_domain_name_map_entry(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
    out: &mut std::collections::HashMap<std::string::String, std::string::String>,
) -> Result<(), aws_smithy_xml::decode::XmlError> {
    let mut k: Option<std::string::String> = None;
    let mut v: Option<std::string::String> = None;
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("key") /* key com.amazonaws.cloudsearch#DomainNameMap$key */ =>  {
                k = Some(
                    Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                        aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                        .into()
                    )
                    ?
                )
            }
            ,
            s if s.matches("value") /* value com.amazonaws.cloudsearch#DomainNameMap$value */ =>  {
                v = Some(
                    Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                        aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                        .into()
                    )
                    ?
                )
            }
            ,
            _ => {}
        }
    }
    let k = k.ok_or_else(|| aws_smithy_xml::decode::XmlError::custom("missing key map entry"))?;
    let v = v.ok_or_else(|| aws_smithy_xml::decode::XmlError::custom("missing value map entry"))?;
    out.insert(k, v);
    Ok(())
}

pub fn deser_structure_crate_model_analysis_options(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::AnalysisOptions, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::AnalysisOptions::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("Synonyms") /* Synonyms com.amazonaws.cloudsearch#AnalysisOptions$Synonyms */ =>  {
                let var_105 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_synonyms(var_105);
            }
            ,
            s if s.matches("Stopwords") /* Stopwords com.amazonaws.cloudsearch#AnalysisOptions$Stopwords */ =>  {
                let var_106 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_stopwords(var_106);
            }
            ,
            s if s.matches("StemmingDictionary") /* StemmingDictionary com.amazonaws.cloudsearch#AnalysisOptions$StemmingDictionary */ =>  {
                let var_107 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_stemming_dictionary(var_107);
            }
            ,
            s if s.matches("JapaneseTokenizationDictionary") /* JapaneseTokenizationDictionary com.amazonaws.cloudsearch#AnalysisOptions$JapaneseTokenizationDictionary */ =>  {
                let var_108 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_japanese_tokenization_dictionary(var_108);
            }
            ,
            s if s.matches("AlgorithmicStemming") /* AlgorithmicStemming com.amazonaws.cloudsearch#AnalysisOptions$AlgorithmicStemming */ =>  {
                let var_109 =
                    Some(
                        Result::<crate::model::AlgorithmicStemming, aws_smithy_xml::decode::XmlError>::Ok(
                            crate::model::AlgorithmicStemming::from(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                        )
                        ?
                    )
                ;
                builder = builder.set_algorithmic_stemming(var_109);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_int_options(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::IntOptions, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::IntOptions::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("DefaultValue") /* DefaultValue com.amazonaws.cloudsearch#IntOptions$DefaultValue */ =>  {
                let var_110 =
                    Some(
                         {
                            <i64 as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (long: `com.amazonaws.cloudsearch#Long`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_default_value(var_110);
            }
            ,
            s if s.matches("SourceField") /* SourceField com.amazonaws.cloudsearch#IntOptions$SourceField */ =>  {
                let var_111 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_source_field(var_111);
            }
            ,
            s if s.matches("FacetEnabled") /* FacetEnabled com.amazonaws.cloudsearch#IntOptions$FacetEnabled */ =>  {
                let var_112 =
                    Some(
                         {
                            <bool as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (boolean: `com.amazonaws.cloudsearch#Boolean`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_facet_enabled(var_112);
            }
            ,
            s if s.matches("SearchEnabled") /* SearchEnabled com.amazonaws.cloudsearch#IntOptions$SearchEnabled */ =>  {
                let var_113 =
                    Some(
                         {
                            <bool as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (boolean: `com.amazonaws.cloudsearch#Boolean`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_search_enabled(var_113);
            }
            ,
            s if s.matches("ReturnEnabled") /* ReturnEnabled com.amazonaws.cloudsearch#IntOptions$ReturnEnabled */ =>  {
                let var_114 =
                    Some(
                         {
                            <bool as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (boolean: `com.amazonaws.cloudsearch#Boolean`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_return_enabled(var_114);
            }
            ,
            s if s.matches("SortEnabled") /* SortEnabled com.amazonaws.cloudsearch#IntOptions$SortEnabled */ =>  {
                let var_115 =
                    Some(
                         {
                            <bool as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (boolean: `com.amazonaws.cloudsearch#Boolean`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_sort_enabled(var_115);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_double_options(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::DoubleOptions, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::DoubleOptions::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("DefaultValue") /* DefaultValue com.amazonaws.cloudsearch#DoubleOptions$DefaultValue */ =>  {
                let var_116 =
                    Some(
                         {
                            <f64 as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (double: `com.amazonaws.cloudsearch#Double`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_default_value(var_116);
            }
            ,
            s if s.matches("SourceField") /* SourceField com.amazonaws.cloudsearch#DoubleOptions$SourceField */ =>  {
                let var_117 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_source_field(var_117);
            }
            ,
            s if s.matches("FacetEnabled") /* FacetEnabled com.amazonaws.cloudsearch#DoubleOptions$FacetEnabled */ =>  {
                let var_118 =
                    Some(
                         {
                            <bool as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (boolean: `com.amazonaws.cloudsearch#Boolean`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_facet_enabled(var_118);
            }
            ,
            s if s.matches("SearchEnabled") /* SearchEnabled com.amazonaws.cloudsearch#DoubleOptions$SearchEnabled */ =>  {
                let var_119 =
                    Some(
                         {
                            <bool as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (boolean: `com.amazonaws.cloudsearch#Boolean`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_search_enabled(var_119);
            }
            ,
            s if s.matches("ReturnEnabled") /* ReturnEnabled com.amazonaws.cloudsearch#DoubleOptions$ReturnEnabled */ =>  {
                let var_120 =
                    Some(
                         {
                            <bool as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (boolean: `com.amazonaws.cloudsearch#Boolean`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_return_enabled(var_120);
            }
            ,
            s if s.matches("SortEnabled") /* SortEnabled com.amazonaws.cloudsearch#DoubleOptions$SortEnabled */ =>  {
                let var_121 =
                    Some(
                         {
                            <bool as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (boolean: `com.amazonaws.cloudsearch#Boolean`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_sort_enabled(var_121);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_literal_options(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::LiteralOptions, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::LiteralOptions::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("DefaultValue") /* DefaultValue com.amazonaws.cloudsearch#LiteralOptions$DefaultValue */ =>  {
                let var_122 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_default_value(var_122);
            }
            ,
            s if s.matches("SourceField") /* SourceField com.amazonaws.cloudsearch#LiteralOptions$SourceField */ =>  {
                let var_123 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_source_field(var_123);
            }
            ,
            s if s.matches("FacetEnabled") /* FacetEnabled com.amazonaws.cloudsearch#LiteralOptions$FacetEnabled */ =>  {
                let var_124 =
                    Some(
                         {
                            <bool as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (boolean: `com.amazonaws.cloudsearch#Boolean`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_facet_enabled(var_124);
            }
            ,
            s if s.matches("SearchEnabled") /* SearchEnabled com.amazonaws.cloudsearch#LiteralOptions$SearchEnabled */ =>  {
                let var_125 =
                    Some(
                         {
                            <bool as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (boolean: `com.amazonaws.cloudsearch#Boolean`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_search_enabled(var_125);
            }
            ,
            s if s.matches("ReturnEnabled") /* ReturnEnabled com.amazonaws.cloudsearch#LiteralOptions$ReturnEnabled */ =>  {
                let var_126 =
                    Some(
                         {
                            <bool as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (boolean: `com.amazonaws.cloudsearch#Boolean`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_return_enabled(var_126);
            }
            ,
            s if s.matches("SortEnabled") /* SortEnabled com.amazonaws.cloudsearch#LiteralOptions$SortEnabled */ =>  {
                let var_127 =
                    Some(
                         {
                            <bool as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (boolean: `com.amazonaws.cloudsearch#Boolean`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_sort_enabled(var_127);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_text_options(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::TextOptions, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::TextOptions::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("DefaultValue") /* DefaultValue com.amazonaws.cloudsearch#TextOptions$DefaultValue */ =>  {
                let var_128 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_default_value(var_128);
            }
            ,
            s if s.matches("SourceField") /* SourceField com.amazonaws.cloudsearch#TextOptions$SourceField */ =>  {
                let var_129 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_source_field(var_129);
            }
            ,
            s if s.matches("ReturnEnabled") /* ReturnEnabled com.amazonaws.cloudsearch#TextOptions$ReturnEnabled */ =>  {
                let var_130 =
                    Some(
                         {
                            <bool as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (boolean: `com.amazonaws.cloudsearch#Boolean`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_return_enabled(var_130);
            }
            ,
            s if s.matches("SortEnabled") /* SortEnabled com.amazonaws.cloudsearch#TextOptions$SortEnabled */ =>  {
                let var_131 =
                    Some(
                         {
                            <bool as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (boolean: `com.amazonaws.cloudsearch#Boolean`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_sort_enabled(var_131);
            }
            ,
            s if s.matches("HighlightEnabled") /* HighlightEnabled com.amazonaws.cloudsearch#TextOptions$HighlightEnabled */ =>  {
                let var_132 =
                    Some(
                         {
                            <bool as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (boolean: `com.amazonaws.cloudsearch#Boolean`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_highlight_enabled(var_132);
            }
            ,
            s if s.matches("AnalysisScheme") /* AnalysisScheme com.amazonaws.cloudsearch#TextOptions$AnalysisScheme */ =>  {
                let var_133 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_analysis_scheme(var_133);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_date_options(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::DateOptions, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::DateOptions::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("DefaultValue") /* DefaultValue com.amazonaws.cloudsearch#DateOptions$DefaultValue */ =>  {
                let var_134 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_default_value(var_134);
            }
            ,
            s if s.matches("SourceField") /* SourceField com.amazonaws.cloudsearch#DateOptions$SourceField */ =>  {
                let var_135 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_source_field(var_135);
            }
            ,
            s if s.matches("FacetEnabled") /* FacetEnabled com.amazonaws.cloudsearch#DateOptions$FacetEnabled */ =>  {
                let var_136 =
                    Some(
                         {
                            <bool as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (boolean: `com.amazonaws.cloudsearch#Boolean`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_facet_enabled(var_136);
            }
            ,
            s if s.matches("SearchEnabled") /* SearchEnabled com.amazonaws.cloudsearch#DateOptions$SearchEnabled */ =>  {
                let var_137 =
                    Some(
                         {
                            <bool as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (boolean: `com.amazonaws.cloudsearch#Boolean`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_search_enabled(var_137);
            }
            ,
            s if s.matches("ReturnEnabled") /* ReturnEnabled com.amazonaws.cloudsearch#DateOptions$ReturnEnabled */ =>  {
                let var_138 =
                    Some(
                         {
                            <bool as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (boolean: `com.amazonaws.cloudsearch#Boolean`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_return_enabled(var_138);
            }
            ,
            s if s.matches("SortEnabled") /* SortEnabled com.amazonaws.cloudsearch#DateOptions$SortEnabled */ =>  {
                let var_139 =
                    Some(
                         {
                            <bool as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (boolean: `com.amazonaws.cloudsearch#Boolean`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_sort_enabled(var_139);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_lat_lon_options(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::LatLonOptions, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::LatLonOptions::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("DefaultValue") /* DefaultValue com.amazonaws.cloudsearch#LatLonOptions$DefaultValue */ =>  {
                let var_140 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_default_value(var_140);
            }
            ,
            s if s.matches("SourceField") /* SourceField com.amazonaws.cloudsearch#LatLonOptions$SourceField */ =>  {
                let var_141 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_source_field(var_141);
            }
            ,
            s if s.matches("FacetEnabled") /* FacetEnabled com.amazonaws.cloudsearch#LatLonOptions$FacetEnabled */ =>  {
                let var_142 =
                    Some(
                         {
                            <bool as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (boolean: `com.amazonaws.cloudsearch#Boolean`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_facet_enabled(var_142);
            }
            ,
            s if s.matches("SearchEnabled") /* SearchEnabled com.amazonaws.cloudsearch#LatLonOptions$SearchEnabled */ =>  {
                let var_143 =
                    Some(
                         {
                            <bool as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (boolean: `com.amazonaws.cloudsearch#Boolean`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_search_enabled(var_143);
            }
            ,
            s if s.matches("ReturnEnabled") /* ReturnEnabled com.amazonaws.cloudsearch#LatLonOptions$ReturnEnabled */ =>  {
                let var_144 =
                    Some(
                         {
                            <bool as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (boolean: `com.amazonaws.cloudsearch#Boolean`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_return_enabled(var_144);
            }
            ,
            s if s.matches("SortEnabled") /* SortEnabled com.amazonaws.cloudsearch#LatLonOptions$SortEnabled */ =>  {
                let var_145 =
                    Some(
                         {
                            <bool as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (boolean: `com.amazonaws.cloudsearch#Boolean`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_sort_enabled(var_145);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_int_array_options(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::IntArrayOptions, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::IntArrayOptions::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("DefaultValue") /* DefaultValue com.amazonaws.cloudsearch#IntArrayOptions$DefaultValue */ =>  {
                let var_146 =
                    Some(
                         {
                            <i64 as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (long: `com.amazonaws.cloudsearch#Long`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_default_value(var_146);
            }
            ,
            s if s.matches("SourceFields") /* SourceFields com.amazonaws.cloudsearch#IntArrayOptions$SourceFields */ =>  {
                let var_147 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_source_fields(var_147);
            }
            ,
            s if s.matches("FacetEnabled") /* FacetEnabled com.amazonaws.cloudsearch#IntArrayOptions$FacetEnabled */ =>  {
                let var_148 =
                    Some(
                         {
                            <bool as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (boolean: `com.amazonaws.cloudsearch#Boolean`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_facet_enabled(var_148);
            }
            ,
            s if s.matches("SearchEnabled") /* SearchEnabled com.amazonaws.cloudsearch#IntArrayOptions$SearchEnabled */ =>  {
                let var_149 =
                    Some(
                         {
                            <bool as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (boolean: `com.amazonaws.cloudsearch#Boolean`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_search_enabled(var_149);
            }
            ,
            s if s.matches("ReturnEnabled") /* ReturnEnabled com.amazonaws.cloudsearch#IntArrayOptions$ReturnEnabled */ =>  {
                let var_150 =
                    Some(
                         {
                            <bool as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (boolean: `com.amazonaws.cloudsearch#Boolean`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_return_enabled(var_150);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_double_array_options(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::DoubleArrayOptions, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::DoubleArrayOptions::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("DefaultValue") /* DefaultValue com.amazonaws.cloudsearch#DoubleArrayOptions$DefaultValue */ =>  {
                let var_151 =
                    Some(
                         {
                            <f64 as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (double: `com.amazonaws.cloudsearch#Double`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_default_value(var_151);
            }
            ,
            s if s.matches("SourceFields") /* SourceFields com.amazonaws.cloudsearch#DoubleArrayOptions$SourceFields */ =>  {
                let var_152 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_source_fields(var_152);
            }
            ,
            s if s.matches("FacetEnabled") /* FacetEnabled com.amazonaws.cloudsearch#DoubleArrayOptions$FacetEnabled */ =>  {
                let var_153 =
                    Some(
                         {
                            <bool as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (boolean: `com.amazonaws.cloudsearch#Boolean`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_facet_enabled(var_153);
            }
            ,
            s if s.matches("SearchEnabled") /* SearchEnabled com.amazonaws.cloudsearch#DoubleArrayOptions$SearchEnabled */ =>  {
                let var_154 =
                    Some(
                         {
                            <bool as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (boolean: `com.amazonaws.cloudsearch#Boolean`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_search_enabled(var_154);
            }
            ,
            s if s.matches("ReturnEnabled") /* ReturnEnabled com.amazonaws.cloudsearch#DoubleArrayOptions$ReturnEnabled */ =>  {
                let var_155 =
                    Some(
                         {
                            <bool as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (boolean: `com.amazonaws.cloudsearch#Boolean`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_return_enabled(var_155);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_literal_array_options(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::LiteralArrayOptions, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::LiteralArrayOptions::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("DefaultValue") /* DefaultValue com.amazonaws.cloudsearch#LiteralArrayOptions$DefaultValue */ =>  {
                let var_156 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_default_value(var_156);
            }
            ,
            s if s.matches("SourceFields") /* SourceFields com.amazonaws.cloudsearch#LiteralArrayOptions$SourceFields */ =>  {
                let var_157 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_source_fields(var_157);
            }
            ,
            s if s.matches("FacetEnabled") /* FacetEnabled com.amazonaws.cloudsearch#LiteralArrayOptions$FacetEnabled */ =>  {
                let var_158 =
                    Some(
                         {
                            <bool as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (boolean: `com.amazonaws.cloudsearch#Boolean`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_facet_enabled(var_158);
            }
            ,
            s if s.matches("SearchEnabled") /* SearchEnabled com.amazonaws.cloudsearch#LiteralArrayOptions$SearchEnabled */ =>  {
                let var_159 =
                    Some(
                         {
                            <bool as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (boolean: `com.amazonaws.cloudsearch#Boolean`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_search_enabled(var_159);
            }
            ,
            s if s.matches("ReturnEnabled") /* ReturnEnabled com.amazonaws.cloudsearch#LiteralArrayOptions$ReturnEnabled */ =>  {
                let var_160 =
                    Some(
                         {
                            <bool as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (boolean: `com.amazonaws.cloudsearch#Boolean`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_return_enabled(var_160);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_text_array_options(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::TextArrayOptions, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::TextArrayOptions::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("DefaultValue") /* DefaultValue com.amazonaws.cloudsearch#TextArrayOptions$DefaultValue */ =>  {
                let var_161 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_default_value(var_161);
            }
            ,
            s if s.matches("SourceFields") /* SourceFields com.amazonaws.cloudsearch#TextArrayOptions$SourceFields */ =>  {
                let var_162 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_source_fields(var_162);
            }
            ,
            s if s.matches("ReturnEnabled") /* ReturnEnabled com.amazonaws.cloudsearch#TextArrayOptions$ReturnEnabled */ =>  {
                let var_163 =
                    Some(
                         {
                            <bool as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (boolean: `com.amazonaws.cloudsearch#Boolean`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_return_enabled(var_163);
            }
            ,
            s if s.matches("HighlightEnabled") /* HighlightEnabled com.amazonaws.cloudsearch#TextArrayOptions$HighlightEnabled */ =>  {
                let var_164 =
                    Some(
                         {
                            <bool as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (boolean: `com.amazonaws.cloudsearch#Boolean`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_highlight_enabled(var_164);
            }
            ,
            s if s.matches("AnalysisScheme") /* AnalysisScheme com.amazonaws.cloudsearch#TextArrayOptions$AnalysisScheme */ =>  {
                let var_165 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_analysis_scheme(var_165);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_date_array_options(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::DateArrayOptions, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::DateArrayOptions::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("DefaultValue") /* DefaultValue com.amazonaws.cloudsearch#DateArrayOptions$DefaultValue */ =>  {
                let var_166 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_default_value(var_166);
            }
            ,
            s if s.matches("SourceFields") /* SourceFields com.amazonaws.cloudsearch#DateArrayOptions$SourceFields */ =>  {
                let var_167 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_source_fields(var_167);
            }
            ,
            s if s.matches("FacetEnabled") /* FacetEnabled com.amazonaws.cloudsearch#DateArrayOptions$FacetEnabled */ =>  {
                let var_168 =
                    Some(
                         {
                            <bool as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (boolean: `com.amazonaws.cloudsearch#Boolean`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_facet_enabled(var_168);
            }
            ,
            s if s.matches("SearchEnabled") /* SearchEnabled com.amazonaws.cloudsearch#DateArrayOptions$SearchEnabled */ =>  {
                let var_169 =
                    Some(
                         {
                            <bool as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (boolean: `com.amazonaws.cloudsearch#Boolean`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_search_enabled(var_169);
            }
            ,
            s if s.matches("ReturnEnabled") /* ReturnEnabled com.amazonaws.cloudsearch#DateArrayOptions$ReturnEnabled */ =>  {
                let var_170 =
                    Some(
                         {
                            <bool as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (boolean: `com.amazonaws.cloudsearch#Boolean`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_return_enabled(var_170);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_document_suggester_options(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::DocumentSuggesterOptions, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::DocumentSuggesterOptions::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("SourceField") /* SourceField com.amazonaws.cloudsearch#DocumentSuggesterOptions$SourceField */ =>  {
                let var_171 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_source_field(var_171);
            }
            ,
            s if s.matches("FuzzyMatching") /* FuzzyMatching com.amazonaws.cloudsearch#DocumentSuggesterOptions$FuzzyMatching */ =>  {
                let var_172 =
                    Some(
                        Result::<crate::model::SuggesterFuzzyMatching, aws_smithy_xml::decode::XmlError>::Ok(
                            crate::model::SuggesterFuzzyMatching::from(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                        )
                        ?
                    )
                ;
                builder = builder.set_fuzzy_matching(var_172);
            }
            ,
            s if s.matches("SortExpression") /* SortExpression com.amazonaws.cloudsearch#DocumentSuggesterOptions$SortExpression */ =>  {
                let var_173 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_sort_expression(var_173);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}
