// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Error type for the `BuildSuggesters` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct BuildSuggestersError {
    /// Kind of error that occurred.
    pub kind: BuildSuggestersErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `BuildSuggesters` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum BuildSuggestersErrorKind {
    /// <p>An error occurred while processing the request.</p>
    BaseException(crate::error::BaseException),
    /// <p>An internal error occurred while processing the request. If this problem persists,
    /// report an issue from the <a href="http://status.aws.amazon.com/" target="_blank">Service Health Dashboard</a>.</p>
    InternalException(crate::error::InternalException),
    /// <p>The request was rejected because it attempted to reference a resource that does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was rejected because it has invalid parameters.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for BuildSuggestersError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            BuildSuggestersErrorKind::BaseException(_inner) => _inner.fmt(f),
            BuildSuggestersErrorKind::InternalException(_inner) => _inner.fmt(f),
            BuildSuggestersErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            BuildSuggestersErrorKind::ValidationException(_inner) => _inner.fmt(f),
            BuildSuggestersErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for BuildSuggestersError {
    fn code(&self) -> Option<&str> {
        BuildSuggestersError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl BuildSuggestersError {
    /// Creates a new `BuildSuggestersError`.
    pub fn new(kind: BuildSuggestersErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `BuildSuggestersError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: BuildSuggestersErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `BuildSuggestersError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: BuildSuggestersErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `BuildSuggestersErrorKind::BaseException`.
    pub fn is_base_exception(&self) -> bool {
        matches!(&self.kind, BuildSuggestersErrorKind::BaseException(_))
    }
    /// Returns true if the error kind is `BuildSuggestersErrorKind::InternalException`.
    pub fn is_internal_exception(&self) -> bool {
        matches!(&self.kind, BuildSuggestersErrorKind::InternalException(_))
    }
    /// Returns true if the error kind is `BuildSuggestersErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            BuildSuggestersErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `BuildSuggestersErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, BuildSuggestersErrorKind::ValidationException(_))
    }
}
impl std::error::Error for BuildSuggestersError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            BuildSuggestersErrorKind::BaseException(_inner) => Some(_inner),
            BuildSuggestersErrorKind::InternalException(_inner) => Some(_inner),
            BuildSuggestersErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            BuildSuggestersErrorKind::ValidationException(_inner) => Some(_inner),
            BuildSuggestersErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateDomain` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateDomainError {
    /// Kind of error that occurred.
    pub kind: CreateDomainErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateDomain` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateDomainErrorKind {
    /// <p>An error occurred while processing the request.</p>
    BaseException(crate::error::BaseException),
    /// <p>An internal error occurred while processing the request. If this problem persists,
    /// report an issue from the <a href="http://status.aws.amazon.com/" target="_blank">Service Health Dashboard</a>.</p>
    InternalException(crate::error::InternalException),
    /// <p>The request was rejected because a resource limit has already been met.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The request was rejected because it attempted to create a resource that already exists.</p>
    ResourceAlreadyExistsException(crate::error::ResourceAlreadyExistsException),
    /// <p>The request was rejected because it has invalid parameters.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateDomainError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateDomainErrorKind::BaseException(_inner) => _inner.fmt(f),
            CreateDomainErrorKind::InternalException(_inner) => _inner.fmt(f),
            CreateDomainErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            CreateDomainErrorKind::ResourceAlreadyExistsException(_inner) => _inner.fmt(f),
            CreateDomainErrorKind::ValidationException(_inner) => _inner.fmt(f),
            CreateDomainErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateDomainError {
    fn code(&self) -> Option<&str> {
        CreateDomainError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateDomainError {
    /// Creates a new `CreateDomainError`.
    pub fn new(kind: CreateDomainErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateDomainError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateDomainErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateDomainError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateDomainErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `CreateDomainErrorKind::BaseException`.
    pub fn is_base_exception(&self) -> bool {
        matches!(&self.kind, CreateDomainErrorKind::BaseException(_))
    }
    /// Returns true if the error kind is `CreateDomainErrorKind::InternalException`.
    pub fn is_internal_exception(&self) -> bool {
        matches!(&self.kind, CreateDomainErrorKind::InternalException(_))
    }
    /// Returns true if the error kind is `CreateDomainErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(&self.kind, CreateDomainErrorKind::LimitExceededException(_))
    }
    /// Returns true if the error kind is `CreateDomainErrorKind::ResourceAlreadyExistsException`.
    pub fn is_resource_already_exists_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateDomainErrorKind::ResourceAlreadyExistsException(_)
        )
    }
    /// Returns true if the error kind is `CreateDomainErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, CreateDomainErrorKind::ValidationException(_))
    }
}
impl std::error::Error for CreateDomainError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateDomainErrorKind::BaseException(_inner) => Some(_inner),
            CreateDomainErrorKind::InternalException(_inner) => Some(_inner),
            CreateDomainErrorKind::LimitExceededException(_inner) => Some(_inner),
            CreateDomainErrorKind::ResourceAlreadyExistsException(_inner) => Some(_inner),
            CreateDomainErrorKind::ValidationException(_inner) => Some(_inner),
            CreateDomainErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DefineAnalysisScheme` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DefineAnalysisSchemeError {
    /// Kind of error that occurred.
    pub kind: DefineAnalysisSchemeErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DefineAnalysisScheme` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DefineAnalysisSchemeErrorKind {
    /// <p>An error occurred while processing the request.</p>
    BaseException(crate::error::BaseException),
    /// <p>An internal error occurred while processing the request. If this problem persists,
    /// report an issue from the <a href="http://status.aws.amazon.com/" target="_blank">Service Health Dashboard</a>.</p>
    InternalException(crate::error::InternalException),
    /// <p>The request was rejected because it specified an invalid type definition.</p>
    InvalidTypeException(crate::error::InvalidTypeException),
    /// <p>The request was rejected because a resource limit has already been met.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The request was rejected because it attempted to reference a resource that does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was rejected because it has invalid parameters.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DefineAnalysisSchemeError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DefineAnalysisSchemeErrorKind::BaseException(_inner) => _inner.fmt(f),
            DefineAnalysisSchemeErrorKind::InternalException(_inner) => _inner.fmt(f),
            DefineAnalysisSchemeErrorKind::InvalidTypeException(_inner) => _inner.fmt(f),
            DefineAnalysisSchemeErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            DefineAnalysisSchemeErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DefineAnalysisSchemeErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DefineAnalysisSchemeErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DefineAnalysisSchemeError {
    fn code(&self) -> Option<&str> {
        DefineAnalysisSchemeError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DefineAnalysisSchemeError {
    /// Creates a new `DefineAnalysisSchemeError`.
    pub fn new(kind: DefineAnalysisSchemeErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DefineAnalysisSchemeError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DefineAnalysisSchemeErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DefineAnalysisSchemeError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DefineAnalysisSchemeErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DefineAnalysisSchemeErrorKind::BaseException`.
    pub fn is_base_exception(&self) -> bool {
        matches!(&self.kind, DefineAnalysisSchemeErrorKind::BaseException(_))
    }
    /// Returns true if the error kind is `DefineAnalysisSchemeErrorKind::InternalException`.
    pub fn is_internal_exception(&self) -> bool {
        matches!(
            &self.kind,
            DefineAnalysisSchemeErrorKind::InternalException(_)
        )
    }
    /// Returns true if the error kind is `DefineAnalysisSchemeErrorKind::InvalidTypeException`.
    pub fn is_invalid_type_exception(&self) -> bool {
        matches!(
            &self.kind,
            DefineAnalysisSchemeErrorKind::InvalidTypeException(_)
        )
    }
    /// Returns true if the error kind is `DefineAnalysisSchemeErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            DefineAnalysisSchemeErrorKind::LimitExceededException(_)
        )
    }
    /// Returns true if the error kind is `DefineAnalysisSchemeErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DefineAnalysisSchemeErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `DefineAnalysisSchemeErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DefineAnalysisSchemeErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for DefineAnalysisSchemeError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DefineAnalysisSchemeErrorKind::BaseException(_inner) => Some(_inner),
            DefineAnalysisSchemeErrorKind::InternalException(_inner) => Some(_inner),
            DefineAnalysisSchemeErrorKind::InvalidTypeException(_inner) => Some(_inner),
            DefineAnalysisSchemeErrorKind::LimitExceededException(_inner) => Some(_inner),
            DefineAnalysisSchemeErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DefineAnalysisSchemeErrorKind::ValidationException(_inner) => Some(_inner),
            DefineAnalysisSchemeErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DefineExpression` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DefineExpressionError {
    /// Kind of error that occurred.
    pub kind: DefineExpressionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DefineExpression` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DefineExpressionErrorKind {
    /// <p>An error occurred while processing the request.</p>
    BaseException(crate::error::BaseException),
    /// <p>An internal error occurred while processing the request. If this problem persists,
    /// report an issue from the <a href="http://status.aws.amazon.com/" target="_blank">Service Health Dashboard</a>.</p>
    InternalException(crate::error::InternalException),
    /// <p>The request was rejected because it specified an invalid type definition.</p>
    InvalidTypeException(crate::error::InvalidTypeException),
    /// <p>The request was rejected because a resource limit has already been met.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The request was rejected because it attempted to reference a resource that does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was rejected because it has invalid parameters.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DefineExpressionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DefineExpressionErrorKind::BaseException(_inner) => _inner.fmt(f),
            DefineExpressionErrorKind::InternalException(_inner) => _inner.fmt(f),
            DefineExpressionErrorKind::InvalidTypeException(_inner) => _inner.fmt(f),
            DefineExpressionErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            DefineExpressionErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DefineExpressionErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DefineExpressionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DefineExpressionError {
    fn code(&self) -> Option<&str> {
        DefineExpressionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DefineExpressionError {
    /// Creates a new `DefineExpressionError`.
    pub fn new(kind: DefineExpressionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DefineExpressionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DefineExpressionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DefineExpressionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DefineExpressionErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DefineExpressionErrorKind::BaseException`.
    pub fn is_base_exception(&self) -> bool {
        matches!(&self.kind, DefineExpressionErrorKind::BaseException(_))
    }
    /// Returns true if the error kind is `DefineExpressionErrorKind::InternalException`.
    pub fn is_internal_exception(&self) -> bool {
        matches!(&self.kind, DefineExpressionErrorKind::InternalException(_))
    }
    /// Returns true if the error kind is `DefineExpressionErrorKind::InvalidTypeException`.
    pub fn is_invalid_type_exception(&self) -> bool {
        matches!(
            &self.kind,
            DefineExpressionErrorKind::InvalidTypeException(_)
        )
    }
    /// Returns true if the error kind is `DefineExpressionErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            DefineExpressionErrorKind::LimitExceededException(_)
        )
    }
    /// Returns true if the error kind is `DefineExpressionErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DefineExpressionErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `DefineExpressionErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DefineExpressionErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for DefineExpressionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DefineExpressionErrorKind::BaseException(_inner) => Some(_inner),
            DefineExpressionErrorKind::InternalException(_inner) => Some(_inner),
            DefineExpressionErrorKind::InvalidTypeException(_inner) => Some(_inner),
            DefineExpressionErrorKind::LimitExceededException(_inner) => Some(_inner),
            DefineExpressionErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DefineExpressionErrorKind::ValidationException(_inner) => Some(_inner),
            DefineExpressionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DefineIndexField` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DefineIndexFieldError {
    /// Kind of error that occurred.
    pub kind: DefineIndexFieldErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DefineIndexField` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DefineIndexFieldErrorKind {
    /// <p>An error occurred while processing the request.</p>
    BaseException(crate::error::BaseException),
    /// <p>An internal error occurred while processing the request. If this problem persists,
    /// report an issue from the <a href="http://status.aws.amazon.com/" target="_blank">Service Health Dashboard</a>.</p>
    InternalException(crate::error::InternalException),
    /// <p>The request was rejected because it specified an invalid type definition.</p>
    InvalidTypeException(crate::error::InvalidTypeException),
    /// <p>The request was rejected because a resource limit has already been met.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The request was rejected because it attempted to reference a resource that does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was rejected because it has invalid parameters.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DefineIndexFieldError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DefineIndexFieldErrorKind::BaseException(_inner) => _inner.fmt(f),
            DefineIndexFieldErrorKind::InternalException(_inner) => _inner.fmt(f),
            DefineIndexFieldErrorKind::InvalidTypeException(_inner) => _inner.fmt(f),
            DefineIndexFieldErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            DefineIndexFieldErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DefineIndexFieldErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DefineIndexFieldErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DefineIndexFieldError {
    fn code(&self) -> Option<&str> {
        DefineIndexFieldError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DefineIndexFieldError {
    /// Creates a new `DefineIndexFieldError`.
    pub fn new(kind: DefineIndexFieldErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DefineIndexFieldError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DefineIndexFieldErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DefineIndexFieldError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DefineIndexFieldErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DefineIndexFieldErrorKind::BaseException`.
    pub fn is_base_exception(&self) -> bool {
        matches!(&self.kind, DefineIndexFieldErrorKind::BaseException(_))
    }
    /// Returns true if the error kind is `DefineIndexFieldErrorKind::InternalException`.
    pub fn is_internal_exception(&self) -> bool {
        matches!(&self.kind, DefineIndexFieldErrorKind::InternalException(_))
    }
    /// Returns true if the error kind is `DefineIndexFieldErrorKind::InvalidTypeException`.
    pub fn is_invalid_type_exception(&self) -> bool {
        matches!(
            &self.kind,
            DefineIndexFieldErrorKind::InvalidTypeException(_)
        )
    }
    /// Returns true if the error kind is `DefineIndexFieldErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            DefineIndexFieldErrorKind::LimitExceededException(_)
        )
    }
    /// Returns true if the error kind is `DefineIndexFieldErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DefineIndexFieldErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `DefineIndexFieldErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DefineIndexFieldErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for DefineIndexFieldError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DefineIndexFieldErrorKind::BaseException(_inner) => Some(_inner),
            DefineIndexFieldErrorKind::InternalException(_inner) => Some(_inner),
            DefineIndexFieldErrorKind::InvalidTypeException(_inner) => Some(_inner),
            DefineIndexFieldErrorKind::LimitExceededException(_inner) => Some(_inner),
            DefineIndexFieldErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DefineIndexFieldErrorKind::ValidationException(_inner) => Some(_inner),
            DefineIndexFieldErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DefineSuggester` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DefineSuggesterError {
    /// Kind of error that occurred.
    pub kind: DefineSuggesterErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DefineSuggester` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DefineSuggesterErrorKind {
    /// <p>An error occurred while processing the request.</p>
    BaseException(crate::error::BaseException),
    /// <p>An internal error occurred while processing the request. If this problem persists,
    /// report an issue from the <a href="http://status.aws.amazon.com/" target="_blank">Service Health Dashboard</a>.</p>
    InternalException(crate::error::InternalException),
    /// <p>The request was rejected because it specified an invalid type definition.</p>
    InvalidTypeException(crate::error::InvalidTypeException),
    /// <p>The request was rejected because a resource limit has already been met.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The request was rejected because it attempted to reference a resource that does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was rejected because it has invalid parameters.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DefineSuggesterError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DefineSuggesterErrorKind::BaseException(_inner) => _inner.fmt(f),
            DefineSuggesterErrorKind::InternalException(_inner) => _inner.fmt(f),
            DefineSuggesterErrorKind::InvalidTypeException(_inner) => _inner.fmt(f),
            DefineSuggesterErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            DefineSuggesterErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DefineSuggesterErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DefineSuggesterErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DefineSuggesterError {
    fn code(&self) -> Option<&str> {
        DefineSuggesterError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DefineSuggesterError {
    /// Creates a new `DefineSuggesterError`.
    pub fn new(kind: DefineSuggesterErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DefineSuggesterError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DefineSuggesterErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DefineSuggesterError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DefineSuggesterErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DefineSuggesterErrorKind::BaseException`.
    pub fn is_base_exception(&self) -> bool {
        matches!(&self.kind, DefineSuggesterErrorKind::BaseException(_))
    }
    /// Returns true if the error kind is `DefineSuggesterErrorKind::InternalException`.
    pub fn is_internal_exception(&self) -> bool {
        matches!(&self.kind, DefineSuggesterErrorKind::InternalException(_))
    }
    /// Returns true if the error kind is `DefineSuggesterErrorKind::InvalidTypeException`.
    pub fn is_invalid_type_exception(&self) -> bool {
        matches!(
            &self.kind,
            DefineSuggesterErrorKind::InvalidTypeException(_)
        )
    }
    /// Returns true if the error kind is `DefineSuggesterErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            DefineSuggesterErrorKind::LimitExceededException(_)
        )
    }
    /// Returns true if the error kind is `DefineSuggesterErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DefineSuggesterErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `DefineSuggesterErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, DefineSuggesterErrorKind::ValidationException(_))
    }
}
impl std::error::Error for DefineSuggesterError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DefineSuggesterErrorKind::BaseException(_inner) => Some(_inner),
            DefineSuggesterErrorKind::InternalException(_inner) => Some(_inner),
            DefineSuggesterErrorKind::InvalidTypeException(_inner) => Some(_inner),
            DefineSuggesterErrorKind::LimitExceededException(_inner) => Some(_inner),
            DefineSuggesterErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DefineSuggesterErrorKind::ValidationException(_inner) => Some(_inner),
            DefineSuggesterErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteAnalysisScheme` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteAnalysisSchemeError {
    /// Kind of error that occurred.
    pub kind: DeleteAnalysisSchemeErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteAnalysisScheme` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteAnalysisSchemeErrorKind {
    /// <p>An error occurred while processing the request.</p>
    BaseException(crate::error::BaseException),
    /// <p>An internal error occurred while processing the request. If this problem persists,
    /// report an issue from the <a href="http://status.aws.amazon.com/" target="_blank">Service Health Dashboard</a>.</p>
    InternalException(crate::error::InternalException),
    /// <p>The request was rejected because it specified an invalid type definition.</p>
    InvalidTypeException(crate::error::InvalidTypeException),
    /// <p>The request was rejected because it attempted to reference a resource that does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was rejected because it has invalid parameters.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteAnalysisSchemeError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteAnalysisSchemeErrorKind::BaseException(_inner) => _inner.fmt(f),
            DeleteAnalysisSchemeErrorKind::InternalException(_inner) => _inner.fmt(f),
            DeleteAnalysisSchemeErrorKind::InvalidTypeException(_inner) => _inner.fmt(f),
            DeleteAnalysisSchemeErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteAnalysisSchemeErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DeleteAnalysisSchemeErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteAnalysisSchemeError {
    fn code(&self) -> Option<&str> {
        DeleteAnalysisSchemeError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteAnalysisSchemeError {
    /// Creates a new `DeleteAnalysisSchemeError`.
    pub fn new(kind: DeleteAnalysisSchemeErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteAnalysisSchemeError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteAnalysisSchemeErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteAnalysisSchemeError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteAnalysisSchemeErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DeleteAnalysisSchemeErrorKind::BaseException`.
    pub fn is_base_exception(&self) -> bool {
        matches!(&self.kind, DeleteAnalysisSchemeErrorKind::BaseException(_))
    }
    /// Returns true if the error kind is `DeleteAnalysisSchemeErrorKind::InternalException`.
    pub fn is_internal_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteAnalysisSchemeErrorKind::InternalException(_)
        )
    }
    /// Returns true if the error kind is `DeleteAnalysisSchemeErrorKind::InvalidTypeException`.
    pub fn is_invalid_type_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteAnalysisSchemeErrorKind::InvalidTypeException(_)
        )
    }
    /// Returns true if the error kind is `DeleteAnalysisSchemeErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteAnalysisSchemeErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `DeleteAnalysisSchemeErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteAnalysisSchemeErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for DeleteAnalysisSchemeError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteAnalysisSchemeErrorKind::BaseException(_inner) => Some(_inner),
            DeleteAnalysisSchemeErrorKind::InternalException(_inner) => Some(_inner),
            DeleteAnalysisSchemeErrorKind::InvalidTypeException(_inner) => Some(_inner),
            DeleteAnalysisSchemeErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteAnalysisSchemeErrorKind::ValidationException(_inner) => Some(_inner),
            DeleteAnalysisSchemeErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteDomain` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteDomainError {
    /// Kind of error that occurred.
    pub kind: DeleteDomainErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteDomain` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteDomainErrorKind {
    /// <p>An error occurred while processing the request.</p>
    BaseException(crate::error::BaseException),
    /// <p>An internal error occurred while processing the request. If this problem persists,
    /// report an issue from the <a href="http://status.aws.amazon.com/" target="_blank">Service Health Dashboard</a>.</p>
    InternalException(crate::error::InternalException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteDomainError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteDomainErrorKind::BaseException(_inner) => _inner.fmt(f),
            DeleteDomainErrorKind::InternalException(_inner) => _inner.fmt(f),
            DeleteDomainErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteDomainError {
    fn code(&self) -> Option<&str> {
        DeleteDomainError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteDomainError {
    /// Creates a new `DeleteDomainError`.
    pub fn new(kind: DeleteDomainErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteDomainError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteDomainErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteDomainError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteDomainErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DeleteDomainErrorKind::BaseException`.
    pub fn is_base_exception(&self) -> bool {
        matches!(&self.kind, DeleteDomainErrorKind::BaseException(_))
    }
    /// Returns true if the error kind is `DeleteDomainErrorKind::InternalException`.
    pub fn is_internal_exception(&self) -> bool {
        matches!(&self.kind, DeleteDomainErrorKind::InternalException(_))
    }
}
impl std::error::Error for DeleteDomainError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteDomainErrorKind::BaseException(_inner) => Some(_inner),
            DeleteDomainErrorKind::InternalException(_inner) => Some(_inner),
            DeleteDomainErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteExpression` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteExpressionError {
    /// Kind of error that occurred.
    pub kind: DeleteExpressionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteExpression` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteExpressionErrorKind {
    /// <p>An error occurred while processing the request.</p>
    BaseException(crate::error::BaseException),
    /// <p>An internal error occurred while processing the request. If this problem persists,
    /// report an issue from the <a href="http://status.aws.amazon.com/" target="_blank">Service Health Dashboard</a>.</p>
    InternalException(crate::error::InternalException),
    /// <p>The request was rejected because it specified an invalid type definition.</p>
    InvalidTypeException(crate::error::InvalidTypeException),
    /// <p>The request was rejected because it attempted to reference a resource that does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was rejected because it has invalid parameters.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteExpressionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteExpressionErrorKind::BaseException(_inner) => _inner.fmt(f),
            DeleteExpressionErrorKind::InternalException(_inner) => _inner.fmt(f),
            DeleteExpressionErrorKind::InvalidTypeException(_inner) => _inner.fmt(f),
            DeleteExpressionErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteExpressionErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DeleteExpressionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteExpressionError {
    fn code(&self) -> Option<&str> {
        DeleteExpressionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteExpressionError {
    /// Creates a new `DeleteExpressionError`.
    pub fn new(kind: DeleteExpressionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteExpressionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteExpressionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteExpressionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteExpressionErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DeleteExpressionErrorKind::BaseException`.
    pub fn is_base_exception(&self) -> bool {
        matches!(&self.kind, DeleteExpressionErrorKind::BaseException(_))
    }
    /// Returns true if the error kind is `DeleteExpressionErrorKind::InternalException`.
    pub fn is_internal_exception(&self) -> bool {
        matches!(&self.kind, DeleteExpressionErrorKind::InternalException(_))
    }
    /// Returns true if the error kind is `DeleteExpressionErrorKind::InvalidTypeException`.
    pub fn is_invalid_type_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteExpressionErrorKind::InvalidTypeException(_)
        )
    }
    /// Returns true if the error kind is `DeleteExpressionErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteExpressionErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `DeleteExpressionErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteExpressionErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for DeleteExpressionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteExpressionErrorKind::BaseException(_inner) => Some(_inner),
            DeleteExpressionErrorKind::InternalException(_inner) => Some(_inner),
            DeleteExpressionErrorKind::InvalidTypeException(_inner) => Some(_inner),
            DeleteExpressionErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteExpressionErrorKind::ValidationException(_inner) => Some(_inner),
            DeleteExpressionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteIndexField` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteIndexFieldError {
    /// Kind of error that occurred.
    pub kind: DeleteIndexFieldErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteIndexField` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteIndexFieldErrorKind {
    /// <p>An error occurred while processing the request.</p>
    BaseException(crate::error::BaseException),
    /// <p>An internal error occurred while processing the request. If this problem persists,
    /// report an issue from the <a href="http://status.aws.amazon.com/" target="_blank">Service Health Dashboard</a>.</p>
    InternalException(crate::error::InternalException),
    /// <p>The request was rejected because it specified an invalid type definition.</p>
    InvalidTypeException(crate::error::InvalidTypeException),
    /// <p>The request was rejected because it attempted to reference a resource that does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was rejected because it has invalid parameters.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteIndexFieldError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteIndexFieldErrorKind::BaseException(_inner) => _inner.fmt(f),
            DeleteIndexFieldErrorKind::InternalException(_inner) => _inner.fmt(f),
            DeleteIndexFieldErrorKind::InvalidTypeException(_inner) => _inner.fmt(f),
            DeleteIndexFieldErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteIndexFieldErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DeleteIndexFieldErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteIndexFieldError {
    fn code(&self) -> Option<&str> {
        DeleteIndexFieldError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteIndexFieldError {
    /// Creates a new `DeleteIndexFieldError`.
    pub fn new(kind: DeleteIndexFieldErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteIndexFieldError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteIndexFieldErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteIndexFieldError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteIndexFieldErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DeleteIndexFieldErrorKind::BaseException`.
    pub fn is_base_exception(&self) -> bool {
        matches!(&self.kind, DeleteIndexFieldErrorKind::BaseException(_))
    }
    /// Returns true if the error kind is `DeleteIndexFieldErrorKind::InternalException`.
    pub fn is_internal_exception(&self) -> bool {
        matches!(&self.kind, DeleteIndexFieldErrorKind::InternalException(_))
    }
    /// Returns true if the error kind is `DeleteIndexFieldErrorKind::InvalidTypeException`.
    pub fn is_invalid_type_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteIndexFieldErrorKind::InvalidTypeException(_)
        )
    }
    /// Returns true if the error kind is `DeleteIndexFieldErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteIndexFieldErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `DeleteIndexFieldErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteIndexFieldErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for DeleteIndexFieldError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteIndexFieldErrorKind::BaseException(_inner) => Some(_inner),
            DeleteIndexFieldErrorKind::InternalException(_inner) => Some(_inner),
            DeleteIndexFieldErrorKind::InvalidTypeException(_inner) => Some(_inner),
            DeleteIndexFieldErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteIndexFieldErrorKind::ValidationException(_inner) => Some(_inner),
            DeleteIndexFieldErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteSuggester` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteSuggesterError {
    /// Kind of error that occurred.
    pub kind: DeleteSuggesterErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteSuggester` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteSuggesterErrorKind {
    /// <p>An error occurred while processing the request.</p>
    BaseException(crate::error::BaseException),
    /// <p>An internal error occurred while processing the request. If this problem persists,
    /// report an issue from the <a href="http://status.aws.amazon.com/" target="_blank">Service Health Dashboard</a>.</p>
    InternalException(crate::error::InternalException),
    /// <p>The request was rejected because it specified an invalid type definition.</p>
    InvalidTypeException(crate::error::InvalidTypeException),
    /// <p>The request was rejected because it attempted to reference a resource that does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was rejected because it has invalid parameters.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteSuggesterError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteSuggesterErrorKind::BaseException(_inner) => _inner.fmt(f),
            DeleteSuggesterErrorKind::InternalException(_inner) => _inner.fmt(f),
            DeleteSuggesterErrorKind::InvalidTypeException(_inner) => _inner.fmt(f),
            DeleteSuggesterErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteSuggesterErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DeleteSuggesterErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteSuggesterError {
    fn code(&self) -> Option<&str> {
        DeleteSuggesterError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteSuggesterError {
    /// Creates a new `DeleteSuggesterError`.
    pub fn new(kind: DeleteSuggesterErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteSuggesterError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteSuggesterErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteSuggesterError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteSuggesterErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DeleteSuggesterErrorKind::BaseException`.
    pub fn is_base_exception(&self) -> bool {
        matches!(&self.kind, DeleteSuggesterErrorKind::BaseException(_))
    }
    /// Returns true if the error kind is `DeleteSuggesterErrorKind::InternalException`.
    pub fn is_internal_exception(&self) -> bool {
        matches!(&self.kind, DeleteSuggesterErrorKind::InternalException(_))
    }
    /// Returns true if the error kind is `DeleteSuggesterErrorKind::InvalidTypeException`.
    pub fn is_invalid_type_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteSuggesterErrorKind::InvalidTypeException(_)
        )
    }
    /// Returns true if the error kind is `DeleteSuggesterErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteSuggesterErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `DeleteSuggesterErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, DeleteSuggesterErrorKind::ValidationException(_))
    }
}
impl std::error::Error for DeleteSuggesterError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteSuggesterErrorKind::BaseException(_inner) => Some(_inner),
            DeleteSuggesterErrorKind::InternalException(_inner) => Some(_inner),
            DeleteSuggesterErrorKind::InvalidTypeException(_inner) => Some(_inner),
            DeleteSuggesterErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteSuggesterErrorKind::ValidationException(_inner) => Some(_inner),
            DeleteSuggesterErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeAnalysisSchemes` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeAnalysisSchemesError {
    /// Kind of error that occurred.
    pub kind: DescribeAnalysisSchemesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeAnalysisSchemes` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeAnalysisSchemesErrorKind {
    /// <p>An error occurred while processing the request.</p>
    BaseException(crate::error::BaseException),
    /// <p>An internal error occurred while processing the request. If this problem persists,
    /// report an issue from the <a href="http://status.aws.amazon.com/" target="_blank">Service Health Dashboard</a>.</p>
    InternalException(crate::error::InternalException),
    /// <p>The request was rejected because it attempted to reference a resource that does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeAnalysisSchemesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeAnalysisSchemesErrorKind::BaseException(_inner) => _inner.fmt(f),
            DescribeAnalysisSchemesErrorKind::InternalException(_inner) => _inner.fmt(f),
            DescribeAnalysisSchemesErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DescribeAnalysisSchemesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeAnalysisSchemesError {
    fn code(&self) -> Option<&str> {
        DescribeAnalysisSchemesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeAnalysisSchemesError {
    /// Creates a new `DescribeAnalysisSchemesError`.
    pub fn new(kind: DescribeAnalysisSchemesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeAnalysisSchemesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeAnalysisSchemesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeAnalysisSchemesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeAnalysisSchemesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DescribeAnalysisSchemesErrorKind::BaseException`.
    pub fn is_base_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeAnalysisSchemesErrorKind::BaseException(_)
        )
    }
    /// Returns true if the error kind is `DescribeAnalysisSchemesErrorKind::InternalException`.
    pub fn is_internal_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeAnalysisSchemesErrorKind::InternalException(_)
        )
    }
    /// Returns true if the error kind is `DescribeAnalysisSchemesErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeAnalysisSchemesErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for DescribeAnalysisSchemesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeAnalysisSchemesErrorKind::BaseException(_inner) => Some(_inner),
            DescribeAnalysisSchemesErrorKind::InternalException(_inner) => Some(_inner),
            DescribeAnalysisSchemesErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DescribeAnalysisSchemesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeAvailabilityOptions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeAvailabilityOptionsError {
    /// Kind of error that occurred.
    pub kind: DescribeAvailabilityOptionsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeAvailabilityOptions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeAvailabilityOptionsErrorKind {
    /// <p>An error occurred while processing the request.</p>
    BaseException(crate::error::BaseException),
    /// <p>The request was rejected because it attempted an operation which is not enabled.</p>
    DisabledOperationException(crate::error::DisabledOperationException),
    /// <p>An internal error occurred while processing the request. If this problem persists,
    /// report an issue from the <a href="http://status.aws.amazon.com/" target="_blank">Service Health Dashboard</a>.</p>
    InternalException(crate::error::InternalException),
    /// <p>The request was rejected because it specified an invalid type definition.</p>
    InvalidTypeException(crate::error::InvalidTypeException),
    /// <p>The request was rejected because a resource limit has already been met.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The request was rejected because it attempted to reference a resource that does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeAvailabilityOptionsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeAvailabilityOptionsErrorKind::BaseException(_inner) => _inner.fmt(f),
            DescribeAvailabilityOptionsErrorKind::DisabledOperationException(_inner) => {
                _inner.fmt(f)
            }
            DescribeAvailabilityOptionsErrorKind::InternalException(_inner) => _inner.fmt(f),
            DescribeAvailabilityOptionsErrorKind::InvalidTypeException(_inner) => _inner.fmt(f),
            DescribeAvailabilityOptionsErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            DescribeAvailabilityOptionsErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            DescribeAvailabilityOptionsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeAvailabilityOptionsError {
    fn code(&self) -> Option<&str> {
        DescribeAvailabilityOptionsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeAvailabilityOptionsError {
    /// Creates a new `DescribeAvailabilityOptionsError`.
    pub fn new(kind: DescribeAvailabilityOptionsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeAvailabilityOptionsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeAvailabilityOptionsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeAvailabilityOptionsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeAvailabilityOptionsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DescribeAvailabilityOptionsErrorKind::BaseException`.
    pub fn is_base_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeAvailabilityOptionsErrorKind::BaseException(_)
        )
    }
    /// Returns true if the error kind is `DescribeAvailabilityOptionsErrorKind::DisabledOperationException`.
    pub fn is_disabled_operation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeAvailabilityOptionsErrorKind::DisabledOperationException(_)
        )
    }
    /// Returns true if the error kind is `DescribeAvailabilityOptionsErrorKind::InternalException`.
    pub fn is_internal_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeAvailabilityOptionsErrorKind::InternalException(_)
        )
    }
    /// Returns true if the error kind is `DescribeAvailabilityOptionsErrorKind::InvalidTypeException`.
    pub fn is_invalid_type_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeAvailabilityOptionsErrorKind::InvalidTypeException(_)
        )
    }
    /// Returns true if the error kind is `DescribeAvailabilityOptionsErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeAvailabilityOptionsErrorKind::LimitExceededException(_)
        )
    }
    /// Returns true if the error kind is `DescribeAvailabilityOptionsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeAvailabilityOptionsErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for DescribeAvailabilityOptionsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeAvailabilityOptionsErrorKind::BaseException(_inner) => Some(_inner),
            DescribeAvailabilityOptionsErrorKind::DisabledOperationException(_inner) => {
                Some(_inner)
            }
            DescribeAvailabilityOptionsErrorKind::InternalException(_inner) => Some(_inner),
            DescribeAvailabilityOptionsErrorKind::InvalidTypeException(_inner) => Some(_inner),
            DescribeAvailabilityOptionsErrorKind::LimitExceededException(_inner) => Some(_inner),
            DescribeAvailabilityOptionsErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DescribeAvailabilityOptionsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeDomainEndpointOptions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeDomainEndpointOptionsError {
    /// Kind of error that occurred.
    pub kind: DescribeDomainEndpointOptionsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeDomainEndpointOptions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeDomainEndpointOptionsErrorKind {
    /// <p>An error occurred while processing the request.</p>
    BaseException(crate::error::BaseException),
    /// <p>The request was rejected because it attempted an operation which is not enabled.</p>
    DisabledOperationException(crate::error::DisabledOperationException),
    /// <p>An internal error occurred while processing the request. If this problem persists,
    /// report an issue from the <a href="http://status.aws.amazon.com/" target="_blank">Service Health Dashboard</a>.</p>
    InternalException(crate::error::InternalException),
    /// <p>The request was rejected because a resource limit has already been met.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The request was rejected because it attempted to reference a resource that does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeDomainEndpointOptionsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeDomainEndpointOptionsErrorKind::BaseException(_inner) => _inner.fmt(f),
            DescribeDomainEndpointOptionsErrorKind::DisabledOperationException(_inner) => {
                _inner.fmt(f)
            }
            DescribeDomainEndpointOptionsErrorKind::InternalException(_inner) => _inner.fmt(f),
            DescribeDomainEndpointOptionsErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            DescribeDomainEndpointOptionsErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            DescribeDomainEndpointOptionsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeDomainEndpointOptionsError {
    fn code(&self) -> Option<&str> {
        DescribeDomainEndpointOptionsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeDomainEndpointOptionsError {
    /// Creates a new `DescribeDomainEndpointOptionsError`.
    pub fn new(
        kind: DescribeDomainEndpointOptionsErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeDomainEndpointOptionsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeDomainEndpointOptionsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeDomainEndpointOptionsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeDomainEndpointOptionsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DescribeDomainEndpointOptionsErrorKind::BaseException`.
    pub fn is_base_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeDomainEndpointOptionsErrorKind::BaseException(_)
        )
    }
    /// Returns true if the error kind is `DescribeDomainEndpointOptionsErrorKind::DisabledOperationException`.
    pub fn is_disabled_operation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeDomainEndpointOptionsErrorKind::DisabledOperationException(_)
        )
    }
    /// Returns true if the error kind is `DescribeDomainEndpointOptionsErrorKind::InternalException`.
    pub fn is_internal_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeDomainEndpointOptionsErrorKind::InternalException(_)
        )
    }
    /// Returns true if the error kind is `DescribeDomainEndpointOptionsErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeDomainEndpointOptionsErrorKind::LimitExceededException(_)
        )
    }
    /// Returns true if the error kind is `DescribeDomainEndpointOptionsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeDomainEndpointOptionsErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for DescribeDomainEndpointOptionsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeDomainEndpointOptionsErrorKind::BaseException(_inner) => Some(_inner),
            DescribeDomainEndpointOptionsErrorKind::DisabledOperationException(_inner) => {
                Some(_inner)
            }
            DescribeDomainEndpointOptionsErrorKind::InternalException(_inner) => Some(_inner),
            DescribeDomainEndpointOptionsErrorKind::LimitExceededException(_inner) => Some(_inner),
            DescribeDomainEndpointOptionsErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            DescribeDomainEndpointOptionsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeDomains` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeDomainsError {
    /// Kind of error that occurred.
    pub kind: DescribeDomainsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeDomains` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeDomainsErrorKind {
    /// <p>An error occurred while processing the request.</p>
    BaseException(crate::error::BaseException),
    /// <p>An internal error occurred while processing the request. If this problem persists,
    /// report an issue from the <a href="http://status.aws.amazon.com/" target="_blank">Service Health Dashboard</a>.</p>
    InternalException(crate::error::InternalException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeDomainsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeDomainsErrorKind::BaseException(_inner) => _inner.fmt(f),
            DescribeDomainsErrorKind::InternalException(_inner) => _inner.fmt(f),
            DescribeDomainsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeDomainsError {
    fn code(&self) -> Option<&str> {
        DescribeDomainsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeDomainsError {
    /// Creates a new `DescribeDomainsError`.
    pub fn new(kind: DescribeDomainsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeDomainsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeDomainsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeDomainsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeDomainsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DescribeDomainsErrorKind::BaseException`.
    pub fn is_base_exception(&self) -> bool {
        matches!(&self.kind, DescribeDomainsErrorKind::BaseException(_))
    }
    /// Returns true if the error kind is `DescribeDomainsErrorKind::InternalException`.
    pub fn is_internal_exception(&self) -> bool {
        matches!(&self.kind, DescribeDomainsErrorKind::InternalException(_))
    }
}
impl std::error::Error for DescribeDomainsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeDomainsErrorKind::BaseException(_inner) => Some(_inner),
            DescribeDomainsErrorKind::InternalException(_inner) => Some(_inner),
            DescribeDomainsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeExpressions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeExpressionsError {
    /// Kind of error that occurred.
    pub kind: DescribeExpressionsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeExpressions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeExpressionsErrorKind {
    /// <p>An error occurred while processing the request.</p>
    BaseException(crate::error::BaseException),
    /// <p>An internal error occurred while processing the request. If this problem persists,
    /// report an issue from the <a href="http://status.aws.amazon.com/" target="_blank">Service Health Dashboard</a>.</p>
    InternalException(crate::error::InternalException),
    /// <p>The request was rejected because it attempted to reference a resource that does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeExpressionsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeExpressionsErrorKind::BaseException(_inner) => _inner.fmt(f),
            DescribeExpressionsErrorKind::InternalException(_inner) => _inner.fmt(f),
            DescribeExpressionsErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DescribeExpressionsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeExpressionsError {
    fn code(&self) -> Option<&str> {
        DescribeExpressionsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeExpressionsError {
    /// Creates a new `DescribeExpressionsError`.
    pub fn new(kind: DescribeExpressionsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeExpressionsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeExpressionsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeExpressionsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeExpressionsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DescribeExpressionsErrorKind::BaseException`.
    pub fn is_base_exception(&self) -> bool {
        matches!(&self.kind, DescribeExpressionsErrorKind::BaseException(_))
    }
    /// Returns true if the error kind is `DescribeExpressionsErrorKind::InternalException`.
    pub fn is_internal_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeExpressionsErrorKind::InternalException(_)
        )
    }
    /// Returns true if the error kind is `DescribeExpressionsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeExpressionsErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for DescribeExpressionsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeExpressionsErrorKind::BaseException(_inner) => Some(_inner),
            DescribeExpressionsErrorKind::InternalException(_inner) => Some(_inner),
            DescribeExpressionsErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DescribeExpressionsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeIndexFields` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeIndexFieldsError {
    /// Kind of error that occurred.
    pub kind: DescribeIndexFieldsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeIndexFields` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeIndexFieldsErrorKind {
    /// <p>An error occurred while processing the request.</p>
    BaseException(crate::error::BaseException),
    /// <p>An internal error occurred while processing the request. If this problem persists,
    /// report an issue from the <a href="http://status.aws.amazon.com/" target="_blank">Service Health Dashboard</a>.</p>
    InternalException(crate::error::InternalException),
    /// <p>The request was rejected because it attempted to reference a resource that does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeIndexFieldsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeIndexFieldsErrorKind::BaseException(_inner) => _inner.fmt(f),
            DescribeIndexFieldsErrorKind::InternalException(_inner) => _inner.fmt(f),
            DescribeIndexFieldsErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DescribeIndexFieldsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeIndexFieldsError {
    fn code(&self) -> Option<&str> {
        DescribeIndexFieldsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeIndexFieldsError {
    /// Creates a new `DescribeIndexFieldsError`.
    pub fn new(kind: DescribeIndexFieldsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeIndexFieldsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeIndexFieldsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeIndexFieldsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeIndexFieldsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DescribeIndexFieldsErrorKind::BaseException`.
    pub fn is_base_exception(&self) -> bool {
        matches!(&self.kind, DescribeIndexFieldsErrorKind::BaseException(_))
    }
    /// Returns true if the error kind is `DescribeIndexFieldsErrorKind::InternalException`.
    pub fn is_internal_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeIndexFieldsErrorKind::InternalException(_)
        )
    }
    /// Returns true if the error kind is `DescribeIndexFieldsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeIndexFieldsErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for DescribeIndexFieldsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeIndexFieldsErrorKind::BaseException(_inner) => Some(_inner),
            DescribeIndexFieldsErrorKind::InternalException(_inner) => Some(_inner),
            DescribeIndexFieldsErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DescribeIndexFieldsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeScalingParameters` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeScalingParametersError {
    /// Kind of error that occurred.
    pub kind: DescribeScalingParametersErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeScalingParameters` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeScalingParametersErrorKind {
    /// <p>An error occurred while processing the request.</p>
    BaseException(crate::error::BaseException),
    /// <p>An internal error occurred while processing the request. If this problem persists,
    /// report an issue from the <a href="http://status.aws.amazon.com/" target="_blank">Service Health Dashboard</a>.</p>
    InternalException(crate::error::InternalException),
    /// <p>The request was rejected because it attempted to reference a resource that does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeScalingParametersError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeScalingParametersErrorKind::BaseException(_inner) => _inner.fmt(f),
            DescribeScalingParametersErrorKind::InternalException(_inner) => _inner.fmt(f),
            DescribeScalingParametersErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DescribeScalingParametersErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeScalingParametersError {
    fn code(&self) -> Option<&str> {
        DescribeScalingParametersError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeScalingParametersError {
    /// Creates a new `DescribeScalingParametersError`.
    pub fn new(kind: DescribeScalingParametersErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeScalingParametersError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeScalingParametersErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeScalingParametersError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeScalingParametersErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DescribeScalingParametersErrorKind::BaseException`.
    pub fn is_base_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeScalingParametersErrorKind::BaseException(_)
        )
    }
    /// Returns true if the error kind is `DescribeScalingParametersErrorKind::InternalException`.
    pub fn is_internal_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeScalingParametersErrorKind::InternalException(_)
        )
    }
    /// Returns true if the error kind is `DescribeScalingParametersErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeScalingParametersErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for DescribeScalingParametersError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeScalingParametersErrorKind::BaseException(_inner) => Some(_inner),
            DescribeScalingParametersErrorKind::InternalException(_inner) => Some(_inner),
            DescribeScalingParametersErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DescribeScalingParametersErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeServiceAccessPolicies` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeServiceAccessPoliciesError {
    /// Kind of error that occurred.
    pub kind: DescribeServiceAccessPoliciesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeServiceAccessPolicies` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeServiceAccessPoliciesErrorKind {
    /// <p>An error occurred while processing the request.</p>
    BaseException(crate::error::BaseException),
    /// <p>An internal error occurred while processing the request. If this problem persists,
    /// report an issue from the <a href="http://status.aws.amazon.com/" target="_blank">Service Health Dashboard</a>.</p>
    InternalException(crate::error::InternalException),
    /// <p>The request was rejected because it attempted to reference a resource that does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeServiceAccessPoliciesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeServiceAccessPoliciesErrorKind::BaseException(_inner) => _inner.fmt(f),
            DescribeServiceAccessPoliciesErrorKind::InternalException(_inner) => _inner.fmt(f),
            DescribeServiceAccessPoliciesErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            DescribeServiceAccessPoliciesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeServiceAccessPoliciesError {
    fn code(&self) -> Option<&str> {
        DescribeServiceAccessPoliciesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeServiceAccessPoliciesError {
    /// Creates a new `DescribeServiceAccessPoliciesError`.
    pub fn new(
        kind: DescribeServiceAccessPoliciesErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeServiceAccessPoliciesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeServiceAccessPoliciesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeServiceAccessPoliciesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeServiceAccessPoliciesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DescribeServiceAccessPoliciesErrorKind::BaseException`.
    pub fn is_base_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeServiceAccessPoliciesErrorKind::BaseException(_)
        )
    }
    /// Returns true if the error kind is `DescribeServiceAccessPoliciesErrorKind::InternalException`.
    pub fn is_internal_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeServiceAccessPoliciesErrorKind::InternalException(_)
        )
    }
    /// Returns true if the error kind is `DescribeServiceAccessPoliciesErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeServiceAccessPoliciesErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for DescribeServiceAccessPoliciesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeServiceAccessPoliciesErrorKind::BaseException(_inner) => Some(_inner),
            DescribeServiceAccessPoliciesErrorKind::InternalException(_inner) => Some(_inner),
            DescribeServiceAccessPoliciesErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            DescribeServiceAccessPoliciesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeSuggesters` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeSuggestersError {
    /// Kind of error that occurred.
    pub kind: DescribeSuggestersErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeSuggesters` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeSuggestersErrorKind {
    /// <p>An error occurred while processing the request.</p>
    BaseException(crate::error::BaseException),
    /// <p>An internal error occurred while processing the request. If this problem persists,
    /// report an issue from the <a href="http://status.aws.amazon.com/" target="_blank">Service Health Dashboard</a>.</p>
    InternalException(crate::error::InternalException),
    /// <p>The request was rejected because it attempted to reference a resource that does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeSuggestersError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeSuggestersErrorKind::BaseException(_inner) => _inner.fmt(f),
            DescribeSuggestersErrorKind::InternalException(_inner) => _inner.fmt(f),
            DescribeSuggestersErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DescribeSuggestersErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeSuggestersError {
    fn code(&self) -> Option<&str> {
        DescribeSuggestersError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeSuggestersError {
    /// Creates a new `DescribeSuggestersError`.
    pub fn new(kind: DescribeSuggestersErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeSuggestersError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeSuggestersErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeSuggestersError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeSuggestersErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DescribeSuggestersErrorKind::BaseException`.
    pub fn is_base_exception(&self) -> bool {
        matches!(&self.kind, DescribeSuggestersErrorKind::BaseException(_))
    }
    /// Returns true if the error kind is `DescribeSuggestersErrorKind::InternalException`.
    pub fn is_internal_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeSuggestersErrorKind::InternalException(_)
        )
    }
    /// Returns true if the error kind is `DescribeSuggestersErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeSuggestersErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for DescribeSuggestersError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeSuggestersErrorKind::BaseException(_inner) => Some(_inner),
            DescribeSuggestersErrorKind::InternalException(_inner) => Some(_inner),
            DescribeSuggestersErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DescribeSuggestersErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `IndexDocuments` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct IndexDocumentsError {
    /// Kind of error that occurred.
    pub kind: IndexDocumentsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `IndexDocuments` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum IndexDocumentsErrorKind {
    /// <p>An error occurred while processing the request.</p>
    BaseException(crate::error::BaseException),
    /// <p>An internal error occurred while processing the request. If this problem persists,
    /// report an issue from the <a href="http://status.aws.amazon.com/" target="_blank">Service Health Dashboard</a>.</p>
    InternalException(crate::error::InternalException),
    /// <p>The request was rejected because it attempted to reference a resource that does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was rejected because it has invalid parameters.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for IndexDocumentsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            IndexDocumentsErrorKind::BaseException(_inner) => _inner.fmt(f),
            IndexDocumentsErrorKind::InternalException(_inner) => _inner.fmt(f),
            IndexDocumentsErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            IndexDocumentsErrorKind::ValidationException(_inner) => _inner.fmt(f),
            IndexDocumentsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for IndexDocumentsError {
    fn code(&self) -> Option<&str> {
        IndexDocumentsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl IndexDocumentsError {
    /// Creates a new `IndexDocumentsError`.
    pub fn new(kind: IndexDocumentsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `IndexDocumentsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: IndexDocumentsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `IndexDocumentsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: IndexDocumentsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `IndexDocumentsErrorKind::BaseException`.
    pub fn is_base_exception(&self) -> bool {
        matches!(&self.kind, IndexDocumentsErrorKind::BaseException(_))
    }
    /// Returns true if the error kind is `IndexDocumentsErrorKind::InternalException`.
    pub fn is_internal_exception(&self) -> bool {
        matches!(&self.kind, IndexDocumentsErrorKind::InternalException(_))
    }
    /// Returns true if the error kind is `IndexDocumentsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            IndexDocumentsErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `IndexDocumentsErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, IndexDocumentsErrorKind::ValidationException(_))
    }
}
impl std::error::Error for IndexDocumentsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            IndexDocumentsErrorKind::BaseException(_inner) => Some(_inner),
            IndexDocumentsErrorKind::InternalException(_inner) => Some(_inner),
            IndexDocumentsErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            IndexDocumentsErrorKind::ValidationException(_inner) => Some(_inner),
            IndexDocumentsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListDomainNames` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListDomainNamesError {
    /// Kind of error that occurred.
    pub kind: ListDomainNamesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListDomainNames` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListDomainNamesErrorKind {
    /// <p>An error occurred while processing the request.</p>
    BaseException(crate::error::BaseException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListDomainNamesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListDomainNamesErrorKind::BaseException(_inner) => _inner.fmt(f),
            ListDomainNamesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListDomainNamesError {
    fn code(&self) -> Option<&str> {
        ListDomainNamesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListDomainNamesError {
    /// Creates a new `ListDomainNamesError`.
    pub fn new(kind: ListDomainNamesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListDomainNamesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListDomainNamesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListDomainNamesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListDomainNamesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `ListDomainNamesErrorKind::BaseException`.
    pub fn is_base_exception(&self) -> bool {
        matches!(&self.kind, ListDomainNamesErrorKind::BaseException(_))
    }
}
impl std::error::Error for ListDomainNamesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListDomainNamesErrorKind::BaseException(_inner) => Some(_inner),
            ListDomainNamesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateAvailabilityOptions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateAvailabilityOptionsError {
    /// Kind of error that occurred.
    pub kind: UpdateAvailabilityOptionsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateAvailabilityOptions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateAvailabilityOptionsErrorKind {
    /// <p>An error occurred while processing the request.</p>
    BaseException(crate::error::BaseException),
    /// <p>The request was rejected because it attempted an operation which is not enabled.</p>
    DisabledOperationException(crate::error::DisabledOperationException),
    /// <p>An internal error occurred while processing the request. If this problem persists,
    /// report an issue from the <a href="http://status.aws.amazon.com/" target="_blank">Service Health Dashboard</a>.</p>
    InternalException(crate::error::InternalException),
    /// <p>The request was rejected because it specified an invalid type definition.</p>
    InvalidTypeException(crate::error::InvalidTypeException),
    /// <p>The request was rejected because a resource limit has already been met.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The request was rejected because it attempted to reference a resource that does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was rejected because it has invalid parameters.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateAvailabilityOptionsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateAvailabilityOptionsErrorKind::BaseException(_inner) => _inner.fmt(f),
            UpdateAvailabilityOptionsErrorKind::DisabledOperationException(_inner) => _inner.fmt(f),
            UpdateAvailabilityOptionsErrorKind::InternalException(_inner) => _inner.fmt(f),
            UpdateAvailabilityOptionsErrorKind::InvalidTypeException(_inner) => _inner.fmt(f),
            UpdateAvailabilityOptionsErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            UpdateAvailabilityOptionsErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UpdateAvailabilityOptionsErrorKind::ValidationException(_inner) => _inner.fmt(f),
            UpdateAvailabilityOptionsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateAvailabilityOptionsError {
    fn code(&self) -> Option<&str> {
        UpdateAvailabilityOptionsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateAvailabilityOptionsError {
    /// Creates a new `UpdateAvailabilityOptionsError`.
    pub fn new(kind: UpdateAvailabilityOptionsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateAvailabilityOptionsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateAvailabilityOptionsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateAvailabilityOptionsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateAvailabilityOptionsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `UpdateAvailabilityOptionsErrorKind::BaseException`.
    pub fn is_base_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateAvailabilityOptionsErrorKind::BaseException(_)
        )
    }
    /// Returns true if the error kind is `UpdateAvailabilityOptionsErrorKind::DisabledOperationException`.
    pub fn is_disabled_operation_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateAvailabilityOptionsErrorKind::DisabledOperationException(_)
        )
    }
    /// Returns true if the error kind is `UpdateAvailabilityOptionsErrorKind::InternalException`.
    pub fn is_internal_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateAvailabilityOptionsErrorKind::InternalException(_)
        )
    }
    /// Returns true if the error kind is `UpdateAvailabilityOptionsErrorKind::InvalidTypeException`.
    pub fn is_invalid_type_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateAvailabilityOptionsErrorKind::InvalidTypeException(_)
        )
    }
    /// Returns true if the error kind is `UpdateAvailabilityOptionsErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateAvailabilityOptionsErrorKind::LimitExceededException(_)
        )
    }
    /// Returns true if the error kind is `UpdateAvailabilityOptionsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateAvailabilityOptionsErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `UpdateAvailabilityOptionsErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateAvailabilityOptionsErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for UpdateAvailabilityOptionsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateAvailabilityOptionsErrorKind::BaseException(_inner) => Some(_inner),
            UpdateAvailabilityOptionsErrorKind::DisabledOperationException(_inner) => Some(_inner),
            UpdateAvailabilityOptionsErrorKind::InternalException(_inner) => Some(_inner),
            UpdateAvailabilityOptionsErrorKind::InvalidTypeException(_inner) => Some(_inner),
            UpdateAvailabilityOptionsErrorKind::LimitExceededException(_inner) => Some(_inner),
            UpdateAvailabilityOptionsErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UpdateAvailabilityOptionsErrorKind::ValidationException(_inner) => Some(_inner),
            UpdateAvailabilityOptionsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateDomainEndpointOptions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateDomainEndpointOptionsError {
    /// Kind of error that occurred.
    pub kind: UpdateDomainEndpointOptionsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateDomainEndpointOptions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateDomainEndpointOptionsErrorKind {
    /// <p>An error occurred while processing the request.</p>
    BaseException(crate::error::BaseException),
    /// <p>The request was rejected because it attempted an operation which is not enabled.</p>
    DisabledOperationException(crate::error::DisabledOperationException),
    /// <p>An internal error occurred while processing the request. If this problem persists,
    /// report an issue from the <a href="http://status.aws.amazon.com/" target="_blank">Service Health Dashboard</a>.</p>
    InternalException(crate::error::InternalException),
    /// <p>The request was rejected because it specified an invalid type definition.</p>
    InvalidTypeException(crate::error::InvalidTypeException),
    /// <p>The request was rejected because a resource limit has already been met.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The request was rejected because it attempted to reference a resource that does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was rejected because it has invalid parameters.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateDomainEndpointOptionsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateDomainEndpointOptionsErrorKind::BaseException(_inner) => _inner.fmt(f),
            UpdateDomainEndpointOptionsErrorKind::DisabledOperationException(_inner) => {
                _inner.fmt(f)
            }
            UpdateDomainEndpointOptionsErrorKind::InternalException(_inner) => _inner.fmt(f),
            UpdateDomainEndpointOptionsErrorKind::InvalidTypeException(_inner) => _inner.fmt(f),
            UpdateDomainEndpointOptionsErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            UpdateDomainEndpointOptionsErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            UpdateDomainEndpointOptionsErrorKind::ValidationException(_inner) => _inner.fmt(f),
            UpdateDomainEndpointOptionsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateDomainEndpointOptionsError {
    fn code(&self) -> Option<&str> {
        UpdateDomainEndpointOptionsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateDomainEndpointOptionsError {
    /// Creates a new `UpdateDomainEndpointOptionsError`.
    pub fn new(kind: UpdateDomainEndpointOptionsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateDomainEndpointOptionsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateDomainEndpointOptionsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateDomainEndpointOptionsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateDomainEndpointOptionsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `UpdateDomainEndpointOptionsErrorKind::BaseException`.
    pub fn is_base_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDomainEndpointOptionsErrorKind::BaseException(_)
        )
    }
    /// Returns true if the error kind is `UpdateDomainEndpointOptionsErrorKind::DisabledOperationException`.
    pub fn is_disabled_operation_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDomainEndpointOptionsErrorKind::DisabledOperationException(_)
        )
    }
    /// Returns true if the error kind is `UpdateDomainEndpointOptionsErrorKind::InternalException`.
    pub fn is_internal_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDomainEndpointOptionsErrorKind::InternalException(_)
        )
    }
    /// Returns true if the error kind is `UpdateDomainEndpointOptionsErrorKind::InvalidTypeException`.
    pub fn is_invalid_type_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDomainEndpointOptionsErrorKind::InvalidTypeException(_)
        )
    }
    /// Returns true if the error kind is `UpdateDomainEndpointOptionsErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDomainEndpointOptionsErrorKind::LimitExceededException(_)
        )
    }
    /// Returns true if the error kind is `UpdateDomainEndpointOptionsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDomainEndpointOptionsErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `UpdateDomainEndpointOptionsErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDomainEndpointOptionsErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for UpdateDomainEndpointOptionsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateDomainEndpointOptionsErrorKind::BaseException(_inner) => Some(_inner),
            UpdateDomainEndpointOptionsErrorKind::DisabledOperationException(_inner) => {
                Some(_inner)
            }
            UpdateDomainEndpointOptionsErrorKind::InternalException(_inner) => Some(_inner),
            UpdateDomainEndpointOptionsErrorKind::InvalidTypeException(_inner) => Some(_inner),
            UpdateDomainEndpointOptionsErrorKind::LimitExceededException(_inner) => Some(_inner),
            UpdateDomainEndpointOptionsErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UpdateDomainEndpointOptionsErrorKind::ValidationException(_inner) => Some(_inner),
            UpdateDomainEndpointOptionsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateScalingParameters` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateScalingParametersError {
    /// Kind of error that occurred.
    pub kind: UpdateScalingParametersErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateScalingParameters` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateScalingParametersErrorKind {
    /// <p>An error occurred while processing the request.</p>
    BaseException(crate::error::BaseException),
    /// <p>An internal error occurred while processing the request. If this problem persists,
    /// report an issue from the <a href="http://status.aws.amazon.com/" target="_blank">Service Health Dashboard</a>.</p>
    InternalException(crate::error::InternalException),
    /// <p>The request was rejected because it specified an invalid type definition.</p>
    InvalidTypeException(crate::error::InvalidTypeException),
    /// <p>The request was rejected because a resource limit has already been met.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The request was rejected because it attempted to reference a resource that does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was rejected because it has invalid parameters.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateScalingParametersError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateScalingParametersErrorKind::BaseException(_inner) => _inner.fmt(f),
            UpdateScalingParametersErrorKind::InternalException(_inner) => _inner.fmt(f),
            UpdateScalingParametersErrorKind::InvalidTypeException(_inner) => _inner.fmt(f),
            UpdateScalingParametersErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            UpdateScalingParametersErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UpdateScalingParametersErrorKind::ValidationException(_inner) => _inner.fmt(f),
            UpdateScalingParametersErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateScalingParametersError {
    fn code(&self) -> Option<&str> {
        UpdateScalingParametersError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateScalingParametersError {
    /// Creates a new `UpdateScalingParametersError`.
    pub fn new(kind: UpdateScalingParametersErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateScalingParametersError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateScalingParametersErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateScalingParametersError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateScalingParametersErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `UpdateScalingParametersErrorKind::BaseException`.
    pub fn is_base_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateScalingParametersErrorKind::BaseException(_)
        )
    }
    /// Returns true if the error kind is `UpdateScalingParametersErrorKind::InternalException`.
    pub fn is_internal_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateScalingParametersErrorKind::InternalException(_)
        )
    }
    /// Returns true if the error kind is `UpdateScalingParametersErrorKind::InvalidTypeException`.
    pub fn is_invalid_type_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateScalingParametersErrorKind::InvalidTypeException(_)
        )
    }
    /// Returns true if the error kind is `UpdateScalingParametersErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateScalingParametersErrorKind::LimitExceededException(_)
        )
    }
    /// Returns true if the error kind is `UpdateScalingParametersErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateScalingParametersErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `UpdateScalingParametersErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateScalingParametersErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for UpdateScalingParametersError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateScalingParametersErrorKind::BaseException(_inner) => Some(_inner),
            UpdateScalingParametersErrorKind::InternalException(_inner) => Some(_inner),
            UpdateScalingParametersErrorKind::InvalidTypeException(_inner) => Some(_inner),
            UpdateScalingParametersErrorKind::LimitExceededException(_inner) => Some(_inner),
            UpdateScalingParametersErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UpdateScalingParametersErrorKind::ValidationException(_inner) => Some(_inner),
            UpdateScalingParametersErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateServiceAccessPolicies` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateServiceAccessPoliciesError {
    /// Kind of error that occurred.
    pub kind: UpdateServiceAccessPoliciesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateServiceAccessPolicies` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateServiceAccessPoliciesErrorKind {
    /// <p>An error occurred while processing the request.</p>
    BaseException(crate::error::BaseException),
    /// <p>An internal error occurred while processing the request. If this problem persists,
    /// report an issue from the <a href="http://status.aws.amazon.com/" target="_blank">Service Health Dashboard</a>.</p>
    InternalException(crate::error::InternalException),
    /// <p>The request was rejected because it specified an invalid type definition.</p>
    InvalidTypeException(crate::error::InvalidTypeException),
    /// <p>The request was rejected because a resource limit has already been met.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The request was rejected because it attempted to reference a resource that does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was rejected because it has invalid parameters.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateServiceAccessPoliciesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateServiceAccessPoliciesErrorKind::BaseException(_inner) => _inner.fmt(f),
            UpdateServiceAccessPoliciesErrorKind::InternalException(_inner) => _inner.fmt(f),
            UpdateServiceAccessPoliciesErrorKind::InvalidTypeException(_inner) => _inner.fmt(f),
            UpdateServiceAccessPoliciesErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            UpdateServiceAccessPoliciesErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            UpdateServiceAccessPoliciesErrorKind::ValidationException(_inner) => _inner.fmt(f),
            UpdateServiceAccessPoliciesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateServiceAccessPoliciesError {
    fn code(&self) -> Option<&str> {
        UpdateServiceAccessPoliciesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateServiceAccessPoliciesError {
    /// Creates a new `UpdateServiceAccessPoliciesError`.
    pub fn new(kind: UpdateServiceAccessPoliciesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateServiceAccessPoliciesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateServiceAccessPoliciesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateServiceAccessPoliciesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateServiceAccessPoliciesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `UpdateServiceAccessPoliciesErrorKind::BaseException`.
    pub fn is_base_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateServiceAccessPoliciesErrorKind::BaseException(_)
        )
    }
    /// Returns true if the error kind is `UpdateServiceAccessPoliciesErrorKind::InternalException`.
    pub fn is_internal_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateServiceAccessPoliciesErrorKind::InternalException(_)
        )
    }
    /// Returns true if the error kind is `UpdateServiceAccessPoliciesErrorKind::InvalidTypeException`.
    pub fn is_invalid_type_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateServiceAccessPoliciesErrorKind::InvalidTypeException(_)
        )
    }
    /// Returns true if the error kind is `UpdateServiceAccessPoliciesErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateServiceAccessPoliciesErrorKind::LimitExceededException(_)
        )
    }
    /// Returns true if the error kind is `UpdateServiceAccessPoliciesErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateServiceAccessPoliciesErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `UpdateServiceAccessPoliciesErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateServiceAccessPoliciesErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for UpdateServiceAccessPoliciesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateServiceAccessPoliciesErrorKind::BaseException(_inner) => Some(_inner),
            UpdateServiceAccessPoliciesErrorKind::InternalException(_inner) => Some(_inner),
            UpdateServiceAccessPoliciesErrorKind::InvalidTypeException(_inner) => Some(_inner),
            UpdateServiceAccessPoliciesErrorKind::LimitExceededException(_inner) => Some(_inner),
            UpdateServiceAccessPoliciesErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UpdateServiceAccessPoliciesErrorKind::ValidationException(_inner) => Some(_inner),
            UpdateServiceAccessPoliciesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// <p>The request was rejected because it has invalid parameters.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ValidationException {
    /// <p>A machine-parsable string error or warning code.</p>
    pub code: std::option::Option<std::string::String>,
    /// <p>A human-readable string error or warning message.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ValidationException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ValidationException");
        formatter.field("code", &self.code);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ValidationException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ValidationException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ValidationException")?;
        if let Some(inner_1) = &self.message {
            write!(f, ": {}", inner_1)?;
        }
        Ok(())
    }
}
impl std::error::Error for ValidationException {}
/// See [`ValidationException`](crate::error::ValidationException)
pub mod validation_exception {
    /// A builder for [`ValidationException`](crate::error::ValidationException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) code: std::option::Option<std::string::String>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A machine-parsable string error or warning code.</p>
        pub fn code(mut self, input: impl Into<std::string::String>) -> Self {
            self.code = Some(input.into());
            self
        }
        /// <p>A machine-parsable string error or warning code.</p>
        pub fn set_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.code = input;
            self
        }
        /// <p>A human-readable string error or warning message.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>A human-readable string error or warning message.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ValidationException`](crate::error::ValidationException)
        pub fn build(self) -> crate::error::ValidationException {
            crate::error::ValidationException {
                code: self.code,
                message: self.message,
            }
        }
    }
}
impl ValidationException {
    /// Creates a new builder-style object to manufacture [`ValidationException`](crate::error::ValidationException)
    pub fn builder() -> crate::error::validation_exception::Builder {
        crate::error::validation_exception::Builder::default()
    }
}

/// <p>The request was rejected because it attempted to reference a resource that does not exist.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResourceNotFoundException {
    /// <p>A machine-parsable string error or warning code.</p>
    pub code: std::option::Option<std::string::String>,
    /// <p>A human-readable string error or warning message.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ResourceNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResourceNotFoundException");
        formatter.field("code", &self.code);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ResourceNotFoundException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ResourceNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ResourceNotFoundException")?;
        if let Some(inner_2) = &self.message {
            write!(f, ": {}", inner_2)?;
        }
        Ok(())
    }
}
impl std::error::Error for ResourceNotFoundException {}
/// See [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
pub mod resource_not_found_exception {
    /// A builder for [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) code: std::option::Option<std::string::String>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A machine-parsable string error or warning code.</p>
        pub fn code(mut self, input: impl Into<std::string::String>) -> Self {
            self.code = Some(input.into());
            self
        }
        /// <p>A machine-parsable string error or warning code.</p>
        pub fn set_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.code = input;
            self
        }
        /// <p>A human-readable string error or warning message.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>A human-readable string error or warning message.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
        pub fn build(self) -> crate::error::ResourceNotFoundException {
            crate::error::ResourceNotFoundException {
                code: self.code,
                message: self.message,
            }
        }
    }
}
impl ResourceNotFoundException {
    /// Creates a new builder-style object to manufacture [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
    pub fn builder() -> crate::error::resource_not_found_exception::Builder {
        crate::error::resource_not_found_exception::Builder::default()
    }
}

/// <p>The request was rejected because a resource limit has already been met.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LimitExceededException {
    /// <p>A machine-parsable string error or warning code.</p>
    pub code: std::option::Option<std::string::String>,
    /// <p>A human-readable string error or warning message.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for LimitExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LimitExceededException");
        formatter.field("code", &self.code);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl LimitExceededException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for LimitExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "LimitExceededException")?;
        if let Some(inner_3) = &self.message {
            write!(f, ": {}", inner_3)?;
        }
        Ok(())
    }
}
impl std::error::Error for LimitExceededException {}
/// See [`LimitExceededException`](crate::error::LimitExceededException)
pub mod limit_exceeded_exception {
    /// A builder for [`LimitExceededException`](crate::error::LimitExceededException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) code: std::option::Option<std::string::String>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A machine-parsable string error or warning code.</p>
        pub fn code(mut self, input: impl Into<std::string::String>) -> Self {
            self.code = Some(input.into());
            self
        }
        /// <p>A machine-parsable string error or warning code.</p>
        pub fn set_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.code = input;
            self
        }
        /// <p>A human-readable string error or warning message.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>A human-readable string error or warning message.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`LimitExceededException`](crate::error::LimitExceededException)
        pub fn build(self) -> crate::error::LimitExceededException {
            crate::error::LimitExceededException {
                code: self.code,
                message: self.message,
            }
        }
    }
}
impl LimitExceededException {
    /// Creates a new builder-style object to manufacture [`LimitExceededException`](crate::error::LimitExceededException)
    pub fn builder() -> crate::error::limit_exceeded_exception::Builder {
        crate::error::limit_exceeded_exception::Builder::default()
    }
}

/// <p>The request was rejected because it specified an invalid type definition.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidTypeException {
    /// <p>A machine-parsable string error or warning code.</p>
    pub code: std::option::Option<std::string::String>,
    /// <p>A human-readable string error or warning message.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidTypeException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidTypeException");
        formatter.field("code", &self.code);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidTypeException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidTypeException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidTypeException")?;
        if let Some(inner_4) = &self.message {
            write!(f, ": {}", inner_4)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidTypeException {}
/// See [`InvalidTypeException`](crate::error::InvalidTypeException)
pub mod invalid_type_exception {
    /// A builder for [`InvalidTypeException`](crate::error::InvalidTypeException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) code: std::option::Option<std::string::String>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A machine-parsable string error or warning code.</p>
        pub fn code(mut self, input: impl Into<std::string::String>) -> Self {
            self.code = Some(input.into());
            self
        }
        /// <p>A machine-parsable string error or warning code.</p>
        pub fn set_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.code = input;
            self
        }
        /// <p>A human-readable string error or warning message.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>A human-readable string error or warning message.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidTypeException`](crate::error::InvalidTypeException)
        pub fn build(self) -> crate::error::InvalidTypeException {
            crate::error::InvalidTypeException {
                code: self.code,
                message: self.message,
            }
        }
    }
}
impl InvalidTypeException {
    /// Creates a new builder-style object to manufacture [`InvalidTypeException`](crate::error::InvalidTypeException)
    pub fn builder() -> crate::error::invalid_type_exception::Builder {
        crate::error::invalid_type_exception::Builder::default()
    }
}

/// <p>An internal error occurred while processing the request. If this problem persists,
/// report an issue from the <a href="http://status.aws.amazon.com/" target="_blank">Service Health Dashboard</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InternalException {
    /// <p>A machine-parsable string error or warning code.</p>
    pub code: std::option::Option<std::string::String>,
    /// <p>A human-readable string error or warning message.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InternalException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InternalException");
        formatter.field("code", &self.code);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InternalException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InternalException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InternalException")?;
        if let Some(inner_5) = &self.message {
            write!(f, ": {}", inner_5)?;
        }
        Ok(())
    }
}
impl std::error::Error for InternalException {}
/// See [`InternalException`](crate::error::InternalException)
pub mod internal_exception {
    /// A builder for [`InternalException`](crate::error::InternalException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) code: std::option::Option<std::string::String>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A machine-parsable string error or warning code.</p>
        pub fn code(mut self, input: impl Into<std::string::String>) -> Self {
            self.code = Some(input.into());
            self
        }
        /// <p>A machine-parsable string error or warning code.</p>
        pub fn set_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.code = input;
            self
        }
        /// <p>A human-readable string error or warning message.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>A human-readable string error or warning message.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InternalException`](crate::error::InternalException)
        pub fn build(self) -> crate::error::InternalException {
            crate::error::InternalException {
                code: self.code,
                message: self.message,
            }
        }
    }
}
impl InternalException {
    /// Creates a new builder-style object to manufacture [`InternalException`](crate::error::InternalException)
    pub fn builder() -> crate::error::internal_exception::Builder {
        crate::error::internal_exception::Builder::default()
    }
}

/// <p>An error occurred while processing the request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BaseException {
    /// <p>A machine-parsable string error or warning code.</p>
    pub code: std::option::Option<std::string::String>,
    /// <p>A human-readable string error or warning message.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for BaseException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BaseException");
        formatter.field("code", &self.code);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl BaseException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for BaseException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "BaseException")?;
        if let Some(inner_6) = &self.message {
            write!(f, ": {}", inner_6)?;
        }
        Ok(())
    }
}
impl std::error::Error for BaseException {}
/// See [`BaseException`](crate::error::BaseException)
pub mod base_exception {
    /// A builder for [`BaseException`](crate::error::BaseException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) code: std::option::Option<std::string::String>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A machine-parsable string error or warning code.</p>
        pub fn code(mut self, input: impl Into<std::string::String>) -> Self {
            self.code = Some(input.into());
            self
        }
        /// <p>A machine-parsable string error or warning code.</p>
        pub fn set_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.code = input;
            self
        }
        /// <p>A human-readable string error or warning message.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>A human-readable string error or warning message.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`BaseException`](crate::error::BaseException)
        pub fn build(self) -> crate::error::BaseException {
            crate::error::BaseException {
                code: self.code,
                message: self.message,
            }
        }
    }
}
impl BaseException {
    /// Creates a new builder-style object to manufacture [`BaseException`](crate::error::BaseException)
    pub fn builder() -> crate::error::base_exception::Builder {
        crate::error::base_exception::Builder::default()
    }
}

/// <p>The request was rejected because it attempted an operation which is not enabled.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DisabledOperationException {
    /// <p>A machine-parsable string error or warning code.</p>
    pub code: std::option::Option<std::string::String>,
    /// <p>A human-readable string error or warning message.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DisabledOperationException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DisabledOperationException");
        formatter.field("code", &self.code);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl DisabledOperationException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for DisabledOperationException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "DisabledOperationException")?;
        if let Some(inner_7) = &self.message {
            write!(f, ": {}", inner_7)?;
        }
        Ok(())
    }
}
impl std::error::Error for DisabledOperationException {}
/// See [`DisabledOperationException`](crate::error::DisabledOperationException)
pub mod disabled_operation_exception {
    /// A builder for [`DisabledOperationException`](crate::error::DisabledOperationException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) code: std::option::Option<std::string::String>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A machine-parsable string error or warning code.</p>
        pub fn code(mut self, input: impl Into<std::string::String>) -> Self {
            self.code = Some(input.into());
            self
        }
        /// <p>A machine-parsable string error or warning code.</p>
        pub fn set_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.code = input;
            self
        }
        /// <p>A human-readable string error or warning message.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>A human-readable string error or warning message.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`DisabledOperationException`](crate::error::DisabledOperationException)
        pub fn build(self) -> crate::error::DisabledOperationException {
            crate::error::DisabledOperationException {
                code: self.code,
                message: self.message,
            }
        }
    }
}
impl DisabledOperationException {
    /// Creates a new builder-style object to manufacture [`DisabledOperationException`](crate::error::DisabledOperationException)
    pub fn builder() -> crate::error::disabled_operation_exception::Builder {
        crate::error::disabled_operation_exception::Builder::default()
    }
}

/// <p>The request was rejected because it attempted to create a resource that already exists.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResourceAlreadyExistsException {
    /// <p>A machine-parsable string error or warning code.</p>
    pub code: std::option::Option<std::string::String>,
    /// <p>A human-readable string error or warning message.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ResourceAlreadyExistsException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResourceAlreadyExistsException");
        formatter.field("code", &self.code);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ResourceAlreadyExistsException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ResourceAlreadyExistsException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ResourceAlreadyExistsException")?;
        if let Some(inner_8) = &self.message {
            write!(f, ": {}", inner_8)?;
        }
        Ok(())
    }
}
impl std::error::Error for ResourceAlreadyExistsException {}
/// See [`ResourceAlreadyExistsException`](crate::error::ResourceAlreadyExistsException)
pub mod resource_already_exists_exception {
    /// A builder for [`ResourceAlreadyExistsException`](crate::error::ResourceAlreadyExistsException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) code: std::option::Option<std::string::String>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A machine-parsable string error or warning code.</p>
        pub fn code(mut self, input: impl Into<std::string::String>) -> Self {
            self.code = Some(input.into());
            self
        }
        /// <p>A machine-parsable string error or warning code.</p>
        pub fn set_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.code = input;
            self
        }
        /// <p>A human-readable string error or warning message.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>A human-readable string error or warning message.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ResourceAlreadyExistsException`](crate::error::ResourceAlreadyExistsException)
        pub fn build(self) -> crate::error::ResourceAlreadyExistsException {
            crate::error::ResourceAlreadyExistsException {
                code: self.code,
                message: self.message,
            }
        }
    }
}
impl ResourceAlreadyExistsException {
    /// Creates a new builder-style object to manufacture [`ResourceAlreadyExistsException`](crate::error::ResourceAlreadyExistsException)
    pub fn builder() -> crate::error::resource_already_exists_exception::Builder {
        crate::error::resource_already_exists_exception::Builder::default()
    }
}
