// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle {
    pub(crate) client: aws_smithy_client::Client<
        aws_smithy_client::erase::DynConnector,
        aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
    >,
    pub(crate) conf: crate::Config,
}

/// Client for AWS CloudHSM V2
///
/// Client for invoking operations on AWS CloudHSM V2. Each operation on AWS CloudHSM V2 is a method on this
/// this struct. `.send()` MUST be invoked on the generated operations to dispatch the request to the service.
///
/// # Examples
/// **Constructing a client and invoking an operation**
/// ```rust,no_run
/// # async fn docs() {
///     // create a shared configuration. This can be used & shared between multiple service clients.
///     let shared_config = aws_config::load_from_env().await;
///     let client = aws_sdk_cloudhsmv2::Client::new(&shared_config);
///     // invoke an operation
///     /* let rsp = client
///         .<operation_name>().
///         .<param>("some value")
///         .send().await; */
/// # }
/// ```
/// **Constructing a client with custom configuration**
/// ```rust,no_run
/// use aws_config::RetryConfig;
/// # async fn docs() {
///     let shared_config = aws_config::load_from_env().await;
///     let config = aws_sdk_cloudhsmv2::config::Builder::from(&shared_config)
///         .retry_config(RetryConfig::disabled())
///         .build();
///     let client = aws_sdk_cloudhsmv2::Client::from_conf(config);
/// # }
#[derive(std::fmt::Debug)]
pub struct Client {
    handle: std::sync::Arc<Handle>,
}

impl std::clone::Clone for Client {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl
    From<
        aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
    > for Client
{
    fn from(
        client: aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
    ) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl Client {
    /// Creates a client with the given service configuration.
    pub fn with_config(
        client: aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
        conf: crate::Config,
    ) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl Client {
    /// Constructs a fluent builder for the [`CopyBackupToRegion`](crate::client::fluent_builders::CopyBackupToRegion) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`destination_region(impl Into<String>)`](crate::client::fluent_builders::CopyBackupToRegion::destination_region) / [`set_destination_region(Option<String>)`](crate::client::fluent_builders::CopyBackupToRegion::set_destination_region): <p>The AWS region that will contain your copied CloudHSM cluster backup.</p>
    ///   - [`backup_id(impl Into<String>)`](crate::client::fluent_builders::CopyBackupToRegion::backup_id) / [`set_backup_id(Option<String>)`](crate::client::fluent_builders::CopyBackupToRegion::set_backup_id): <p>The ID of the backup that will be copied to the destination region. </p>
    ///   - [`tag_list(Vec<Tag>)`](crate::client::fluent_builders::CopyBackupToRegion::tag_list) / [`set_tag_list(Option<Vec<Tag>>)`](crate::client::fluent_builders::CopyBackupToRegion::set_tag_list): <p>Tags to apply to the destination backup during creation. If you specify tags, only these tags will be applied to the destination backup. If you do not specify tags, the service copies tags from the source backup to the destination backup.</p>
    /// - On success, responds with [`CopyBackupToRegionOutput`](crate::output::CopyBackupToRegionOutput) with field(s):
    ///   - [`destination_backup(Option<DestinationBackup>)`](crate::output::CopyBackupToRegionOutput::destination_backup): <p>Information on the backup that will be copied to the destination region, including CreateTimestamp, SourceBackup, SourceCluster, and Source Region. CreateTimestamp of the destination backup will be the same as that of the source backup.</p>  <p>You will need to use the <code>sourceBackupID</code> returned in this operation to use the <code>DescribeBackups</code> operation on the backup that will be copied to the destination region.</p>
    /// - On failure, responds with [`SdkError<CopyBackupToRegionError>`](crate::error::CopyBackupToRegionError)
    pub fn copy_backup_to_region(&self) -> fluent_builders::CopyBackupToRegion {
        fluent_builders::CopyBackupToRegion::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateCluster`](crate::client::fluent_builders::CreateCluster) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`backup_retention_policy(BackupRetentionPolicy)`](crate::client::fluent_builders::CreateCluster::backup_retention_policy) / [`set_backup_retention_policy(Option<BackupRetentionPolicy>)`](crate::client::fluent_builders::CreateCluster::set_backup_retention_policy): <p>A policy that defines how the service retains backups.</p>
    ///   - [`hsm_type(impl Into<String>)`](crate::client::fluent_builders::CreateCluster::hsm_type) / [`set_hsm_type(Option<String>)`](crate::client::fluent_builders::CreateCluster::set_hsm_type): <p>The type of HSM to use in the cluster. Currently the only allowed value is <code>hsm1.medium</code>.</p>
    ///   - [`source_backup_id(impl Into<String>)`](crate::client::fluent_builders::CreateCluster::source_backup_id) / [`set_source_backup_id(Option<String>)`](crate::client::fluent_builders::CreateCluster::set_source_backup_id): <p>The identifier (ID) of the cluster backup to restore. Use this value to restore the cluster from a backup instead of creating a new cluster. To find the backup ID, use <code>DescribeBackups</code>.</p>
    ///   - [`subnet_ids(Vec<String>)`](crate::client::fluent_builders::CreateCluster::subnet_ids) / [`set_subnet_ids(Option<Vec<String>>)`](crate::client::fluent_builders::CreateCluster::set_subnet_ids): <p>The identifiers (IDs) of the subnets where you are creating the cluster. You must specify at least one subnet. If you specify multiple subnets, they must meet the following criteria:</p>  <ul>   <li> <p>All subnets must be in the same virtual private cloud (VPC).</p> </li>   <li> <p>You can specify only one subnet per Availability Zone.</p> </li>  </ul>
    ///   - [`tag_list(Vec<Tag>)`](crate::client::fluent_builders::CreateCluster::tag_list) / [`set_tag_list(Option<Vec<Tag>>)`](crate::client::fluent_builders::CreateCluster::set_tag_list): <p>Tags to apply to the CloudHSM cluster during creation.</p>
    /// - On success, responds with [`CreateClusterOutput`](crate::output::CreateClusterOutput) with field(s):
    ///   - [`cluster(Option<Cluster>)`](crate::output::CreateClusterOutput::cluster): <p>Information about the cluster that was created.</p>
    /// - On failure, responds with [`SdkError<CreateClusterError>`](crate::error::CreateClusterError)
    pub fn create_cluster(&self) -> fluent_builders::CreateCluster {
        fluent_builders::CreateCluster::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateHsm`](crate::client::fluent_builders::CreateHsm) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`cluster_id(impl Into<String>)`](crate::client::fluent_builders::CreateHsm::cluster_id) / [`set_cluster_id(Option<String>)`](crate::client::fluent_builders::CreateHsm::set_cluster_id): <p>The identifier (ID) of the HSM's cluster. To find the cluster ID, use <code>DescribeClusters</code>.</p>
    ///   - [`availability_zone(impl Into<String>)`](crate::client::fluent_builders::CreateHsm::availability_zone) / [`set_availability_zone(Option<String>)`](crate::client::fluent_builders::CreateHsm::set_availability_zone): <p>The Availability Zone where you are creating the HSM. To find the cluster's Availability Zones, use <code>DescribeClusters</code>.</p>
    ///   - [`ip_address(impl Into<String>)`](crate::client::fluent_builders::CreateHsm::ip_address) / [`set_ip_address(Option<String>)`](crate::client::fluent_builders::CreateHsm::set_ip_address): <p>The HSM's IP address. If you specify an IP address, use an available address from the subnet that maps to the Availability Zone where you are creating the HSM. If you don't specify an IP address, one is chosen for you from that subnet.</p>
    /// - On success, responds with [`CreateHsmOutput`](crate::output::CreateHsmOutput) with field(s):
    ///   - [`hsm(Option<Hsm>)`](crate::output::CreateHsmOutput::hsm): <p>Information about the HSM that was created.</p>
    /// - On failure, responds with [`SdkError<CreateHsmError>`](crate::error::CreateHsmError)
    pub fn create_hsm(&self) -> fluent_builders::CreateHsm {
        fluent_builders::CreateHsm::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteBackup`](crate::client::fluent_builders::DeleteBackup) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`backup_id(impl Into<String>)`](crate::client::fluent_builders::DeleteBackup::backup_id) / [`set_backup_id(Option<String>)`](crate::client::fluent_builders::DeleteBackup::set_backup_id): <p>The ID of the backup to be deleted. To find the ID of a backup, use the <code>DescribeBackups</code> operation.</p>
    /// - On success, responds with [`DeleteBackupOutput`](crate::output::DeleteBackupOutput) with field(s):
    ///   - [`backup(Option<Backup>)`](crate::output::DeleteBackupOutput::backup): <p>Information on the <code>Backup</code> object deleted.</p>
    /// - On failure, responds with [`SdkError<DeleteBackupError>`](crate::error::DeleteBackupError)
    pub fn delete_backup(&self) -> fluent_builders::DeleteBackup {
        fluent_builders::DeleteBackup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteCluster`](crate::client::fluent_builders::DeleteCluster) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`cluster_id(impl Into<String>)`](crate::client::fluent_builders::DeleteCluster::cluster_id) / [`set_cluster_id(Option<String>)`](crate::client::fluent_builders::DeleteCluster::set_cluster_id): <p>The identifier (ID) of the cluster that you are deleting. To find the cluster ID, use <code>DescribeClusters</code>.</p>
    /// - On success, responds with [`DeleteClusterOutput`](crate::output::DeleteClusterOutput) with field(s):
    ///   - [`cluster(Option<Cluster>)`](crate::output::DeleteClusterOutput::cluster): <p>Information about the cluster that was deleted.</p>
    /// - On failure, responds with [`SdkError<DeleteClusterError>`](crate::error::DeleteClusterError)
    pub fn delete_cluster(&self) -> fluent_builders::DeleteCluster {
        fluent_builders::DeleteCluster::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteHsm`](crate::client::fluent_builders::DeleteHsm) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`cluster_id(impl Into<String>)`](crate::client::fluent_builders::DeleteHsm::cluster_id) / [`set_cluster_id(Option<String>)`](crate::client::fluent_builders::DeleteHsm::set_cluster_id): <p>The identifier (ID) of the cluster that contains the HSM that you are deleting.</p>
    ///   - [`hsm_id(impl Into<String>)`](crate::client::fluent_builders::DeleteHsm::hsm_id) / [`set_hsm_id(Option<String>)`](crate::client::fluent_builders::DeleteHsm::set_hsm_id): <p>The identifier (ID) of the HSM that you are deleting.</p>
    ///   - [`eni_id(impl Into<String>)`](crate::client::fluent_builders::DeleteHsm::eni_id) / [`set_eni_id(Option<String>)`](crate::client::fluent_builders::DeleteHsm::set_eni_id): <p>The identifier (ID) of the elastic network interface (ENI) of the HSM that you are deleting.</p>
    ///   - [`eni_ip(impl Into<String>)`](crate::client::fluent_builders::DeleteHsm::eni_ip) / [`set_eni_ip(Option<String>)`](crate::client::fluent_builders::DeleteHsm::set_eni_ip): <p>The IP address of the elastic network interface (ENI) of the HSM that you are deleting.</p>
    /// - On success, responds with [`DeleteHsmOutput`](crate::output::DeleteHsmOutput) with field(s):
    ///   - [`hsm_id(Option<String>)`](crate::output::DeleteHsmOutput::hsm_id): <p>The identifier (ID) of the HSM that was deleted.</p>
    /// - On failure, responds with [`SdkError<DeleteHsmError>`](crate::error::DeleteHsmError)
    pub fn delete_hsm(&self) -> fluent_builders::DeleteHsm {
        fluent_builders::DeleteHsm::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeBackups`](crate::client::fluent_builders::DescribeBackups) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeBackups::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::DescribeBackups::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::DescribeBackups::set_next_token): <p>The <code>NextToken</code> value that you received in the previous response. Use this value to get more backups.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::DescribeBackups::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::DescribeBackups::set_max_results): <p>The maximum number of backups to return in the response. When there are more backups than the number you specify, the response contains a <code>NextToken</code> value.</p>
    ///   - [`filters(HashMap<String, Vec<String>>)`](crate::client::fluent_builders::DescribeBackups::filters) / [`set_filters(Option<HashMap<String, Vec<String>>>)`](crate::client::fluent_builders::DescribeBackups::set_filters): <p>One or more filters to limit the items returned in the response.</p>  <p>Use the <code>backupIds</code> filter to return only the specified backups. Specify backups by their backup identifier (ID).</p>  <p>Use the <code>sourceBackupIds</code> filter to return only the backups created from a source backup. The <code>sourceBackupID</code> of a source backup is returned by the <code>CopyBackupToRegion</code> operation.</p>  <p>Use the <code>clusterIds</code> filter to return only the backups for the specified clusters. Specify clusters by their cluster identifier (ID).</p>  <p>Use the <code>states</code> filter to return only backups that match the specified state.</p>  <p>Use the <code>neverExpires</code> filter to return backups filtered by the value in the <code>neverExpires</code> parameter. <code>True</code> returns all backups exempt from the backup retention policy. <code>False</code> returns all backups with a backup retention policy defined at the cluster.</p>
    ///   - [`sort_ascending(bool)`](crate::client::fluent_builders::DescribeBackups::sort_ascending) / [`set_sort_ascending(Option<bool>)`](crate::client::fluent_builders::DescribeBackups::set_sort_ascending): <p>Designates whether or not to sort the return backups by ascending chronological order of generation.</p>
    /// - On success, responds with [`DescribeBackupsOutput`](crate::output::DescribeBackupsOutput) with field(s):
    ///   - [`backups(Option<Vec<Backup>>)`](crate::output::DescribeBackupsOutput::backups): <p>A list of backups.</p>
    ///   - [`next_token(Option<String>)`](crate::output::DescribeBackupsOutput::next_token): <p>An opaque string that indicates that the response contains only a subset of backups. Use this value in a subsequent <code>DescribeBackups</code> request to get more backups.</p>
    /// - On failure, responds with [`SdkError<DescribeBackupsError>`](crate::error::DescribeBackupsError)
    pub fn describe_backups(&self) -> fluent_builders::DescribeBackups {
        fluent_builders::DescribeBackups::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeClusters`](crate::client::fluent_builders::DescribeClusters) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeClusters::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`filters(HashMap<String, Vec<String>>)`](crate::client::fluent_builders::DescribeClusters::filters) / [`set_filters(Option<HashMap<String, Vec<String>>>)`](crate::client::fluent_builders::DescribeClusters::set_filters): <p>One or more filters to limit the items returned in the response.</p>  <p>Use the <code>clusterIds</code> filter to return only the specified clusters. Specify clusters by their cluster identifier (ID).</p>  <p>Use the <code>vpcIds</code> filter to return only the clusters in the specified virtual private clouds (VPCs). Specify VPCs by their VPC identifier (ID).</p>  <p>Use the <code>states</code> filter to return only clusters that match the specified state.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::DescribeClusters::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::DescribeClusters::set_next_token): <p>The <code>NextToken</code> value that you received in the previous response. Use this value to get more clusters.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::DescribeClusters::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::DescribeClusters::set_max_results): <p>The maximum number of clusters to return in the response. When there are more clusters than the number you specify, the response contains a <code>NextToken</code> value.</p>
    /// - On success, responds with [`DescribeClustersOutput`](crate::output::DescribeClustersOutput) with field(s):
    ///   - [`clusters(Option<Vec<Cluster>>)`](crate::output::DescribeClustersOutput::clusters): <p>A list of clusters.</p>
    ///   - [`next_token(Option<String>)`](crate::output::DescribeClustersOutput::next_token): <p>An opaque string that indicates that the response contains only a subset of clusters. Use this value in a subsequent <code>DescribeClusters</code> request to get more clusters.</p>
    /// - On failure, responds with [`SdkError<DescribeClustersError>`](crate::error::DescribeClustersError)
    pub fn describe_clusters(&self) -> fluent_builders::DescribeClusters {
        fluent_builders::DescribeClusters::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`InitializeCluster`](crate::client::fluent_builders::InitializeCluster) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`cluster_id(impl Into<String>)`](crate::client::fluent_builders::InitializeCluster::cluster_id) / [`set_cluster_id(Option<String>)`](crate::client::fluent_builders::InitializeCluster::set_cluster_id): <p>The identifier (ID) of the cluster that you are claiming. To find the cluster ID, use <code>DescribeClusters</code>.</p>
    ///   - [`signed_cert(impl Into<String>)`](crate::client::fluent_builders::InitializeCluster::signed_cert) / [`set_signed_cert(Option<String>)`](crate::client::fluent_builders::InitializeCluster::set_signed_cert): <p>The cluster certificate issued (signed) by your issuing certificate authority (CA). The certificate must be in PEM format and can contain a maximum of 5000 characters.</p>
    ///   - [`trust_anchor(impl Into<String>)`](crate::client::fluent_builders::InitializeCluster::trust_anchor) / [`set_trust_anchor(Option<String>)`](crate::client::fluent_builders::InitializeCluster::set_trust_anchor): <p>The issuing certificate of the issuing certificate authority (CA) that issued (signed) the cluster certificate. You must use a self-signed certificate. The certificate used to sign the HSM CSR must be directly available, and thus must be the root certificate. The certificate must be in PEM format and can contain a maximum of 5000 characters.</p>
    /// - On success, responds with [`InitializeClusterOutput`](crate::output::InitializeClusterOutput) with field(s):
    ///   - [`state(Option<ClusterState>)`](crate::output::InitializeClusterOutput::state): <p>The cluster's state.</p>
    ///   - [`state_message(Option<String>)`](crate::output::InitializeClusterOutput::state_message): <p>A description of the cluster's state.</p>
    /// - On failure, responds with [`SdkError<InitializeClusterError>`](crate::error::InitializeClusterError)
    pub fn initialize_cluster(&self) -> fluent_builders::InitializeCluster {
        fluent_builders::InitializeCluster::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListTags`](crate::client::fluent_builders::ListTags) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListTags::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_id(impl Into<String>)`](crate::client::fluent_builders::ListTags::resource_id) / [`set_resource_id(Option<String>)`](crate::client::fluent_builders::ListTags::set_resource_id): <p>The cluster identifier (ID) for the cluster whose tags you are getting. To find the cluster ID, use <code>DescribeClusters</code>.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListTags::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListTags::set_next_token): <p>The <code>NextToken</code> value that you received in the previous response. Use this value to get more tags.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListTags::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListTags::set_max_results): <p>The maximum number of tags to return in the response. When there are more tags than the number you specify, the response contains a <code>NextToken</code> value.</p>
    /// - On success, responds with [`ListTagsOutput`](crate::output::ListTagsOutput) with field(s):
    ///   - [`tag_list(Option<Vec<Tag>>)`](crate::output::ListTagsOutput::tag_list): <p>A list of tags.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListTagsOutput::next_token): <p>An opaque string that indicates that the response contains only a subset of tags. Use this value in a subsequent <code>ListTags</code> request to get more tags.</p>
    /// - On failure, responds with [`SdkError<ListTagsError>`](crate::error::ListTagsError)
    pub fn list_tags(&self) -> fluent_builders::ListTags {
        fluent_builders::ListTags::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ModifyBackupAttributes`](crate::client::fluent_builders::ModifyBackupAttributes) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`backup_id(impl Into<String>)`](crate::client::fluent_builders::ModifyBackupAttributes::backup_id) / [`set_backup_id(Option<String>)`](crate::client::fluent_builders::ModifyBackupAttributes::set_backup_id): <p>The identifier (ID) of the backup to modify. To find the ID of a backup, use the <code>DescribeBackups</code> operation.</p>
    ///   - [`never_expires(bool)`](crate::client::fluent_builders::ModifyBackupAttributes::never_expires) / [`set_never_expires(Option<bool>)`](crate::client::fluent_builders::ModifyBackupAttributes::set_never_expires): <p>Specifies whether the service should exempt a backup from the retention policy for the cluster. <code>True</code> exempts a backup from the retention policy. <code>False</code> means the service applies the backup retention policy defined at the cluster.</p>
    /// - On success, responds with [`ModifyBackupAttributesOutput`](crate::output::ModifyBackupAttributesOutput) with field(s):
    ///   - [`backup(Option<Backup>)`](crate::output::ModifyBackupAttributesOutput::backup): <p>Contains information about a backup of an AWS CloudHSM cluster. All backup objects contain the <code>BackupId</code>, <code>BackupState</code>, <code>ClusterId</code>, and <code>CreateTimestamp</code> parameters. Backups that were copied into a destination region additionally contain the <code>CopyTimestamp</code>, <code>SourceBackup</code>, <code>SourceCluster</code>, and <code>SourceRegion</code> parameters. A backup that is pending deletion will include the <code>DeleteTimestamp</code> parameter.</p>
    /// - On failure, responds with [`SdkError<ModifyBackupAttributesError>`](crate::error::ModifyBackupAttributesError)
    pub fn modify_backup_attributes(&self) -> fluent_builders::ModifyBackupAttributes {
        fluent_builders::ModifyBackupAttributes::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ModifyCluster`](crate::client::fluent_builders::ModifyCluster) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`backup_retention_policy(BackupRetentionPolicy)`](crate::client::fluent_builders::ModifyCluster::backup_retention_policy) / [`set_backup_retention_policy(Option<BackupRetentionPolicy>)`](crate::client::fluent_builders::ModifyCluster::set_backup_retention_policy): <p>A policy that defines how the service retains backups.</p>
    ///   - [`cluster_id(impl Into<String>)`](crate::client::fluent_builders::ModifyCluster::cluster_id) / [`set_cluster_id(Option<String>)`](crate::client::fluent_builders::ModifyCluster::set_cluster_id): <p>The identifier (ID) of the cluster that you want to modify. To find the cluster ID, use <code>DescribeClusters</code>.</p>
    /// - On success, responds with [`ModifyClusterOutput`](crate::output::ModifyClusterOutput) with field(s):
    ///   - [`cluster(Option<Cluster>)`](crate::output::ModifyClusterOutput::cluster): <p>Contains information about an AWS CloudHSM cluster.</p>
    /// - On failure, responds with [`SdkError<ModifyClusterError>`](crate::error::ModifyClusterError)
    pub fn modify_cluster(&self) -> fluent_builders::ModifyCluster {
        fluent_builders::ModifyCluster::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`RestoreBackup`](crate::client::fluent_builders::RestoreBackup) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`backup_id(impl Into<String>)`](crate::client::fluent_builders::RestoreBackup::backup_id) / [`set_backup_id(Option<String>)`](crate::client::fluent_builders::RestoreBackup::set_backup_id): <p>The ID of the backup to be restored. To find the ID of a backup, use the <code>DescribeBackups</code> operation.</p>
    /// - On success, responds with [`RestoreBackupOutput`](crate::output::RestoreBackupOutput) with field(s):
    ///   - [`backup(Option<Backup>)`](crate::output::RestoreBackupOutput::backup): <p>Information on the <code>Backup</code> object created.</p>
    /// - On failure, responds with [`SdkError<RestoreBackupError>`](crate::error::RestoreBackupError)
    pub fn restore_backup(&self) -> fluent_builders::RestoreBackup {
        fluent_builders::RestoreBackup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`TagResource`](crate::client::fluent_builders::TagResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_id(impl Into<String>)`](crate::client::fluent_builders::TagResource::resource_id) / [`set_resource_id(Option<String>)`](crate::client::fluent_builders::TagResource::set_resource_id): <p>The cluster identifier (ID) for the cluster that you are tagging. To find the cluster ID, use <code>DescribeClusters</code>.</p>
    ///   - [`tag_list(Vec<Tag>)`](crate::client::fluent_builders::TagResource::tag_list) / [`set_tag_list(Option<Vec<Tag>>)`](crate::client::fluent_builders::TagResource::set_tag_list): <p>A list of one or more tags.</p>
    /// - On success, responds with [`TagResourceOutput`](crate::output::TagResourceOutput)

    /// - On failure, responds with [`SdkError<TagResourceError>`](crate::error::TagResourceError)
    pub fn tag_resource(&self) -> fluent_builders::TagResource {
        fluent_builders::TagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UntagResource`](crate::client::fluent_builders::UntagResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_id(impl Into<String>)`](crate::client::fluent_builders::UntagResource::resource_id) / [`set_resource_id(Option<String>)`](crate::client::fluent_builders::UntagResource::set_resource_id): <p>The cluster identifier (ID) for the cluster whose tags you are removing. To find the cluster ID, use <code>DescribeClusters</code>.</p>
    ///   - [`tag_key_list(Vec<String>)`](crate::client::fluent_builders::UntagResource::tag_key_list) / [`set_tag_key_list(Option<Vec<String>>)`](crate::client::fluent_builders::UntagResource::set_tag_key_list): <p>A list of one or more tag keys for the tags that you are removing. Specify only the tag keys, not the tag values.</p>
    /// - On success, responds with [`UntagResourceOutput`](crate::output::UntagResourceOutput)

    /// - On failure, responds with [`SdkError<UntagResourceError>`](crate::error::UntagResourceError)
    pub fn untag_resource(&self) -> fluent_builders::UntagResource {
        fluent_builders::UntagResource::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `CopyBackupToRegion`.
    ///
    /// <p>Copy an AWS CloudHSM cluster backup to a different region.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CopyBackupToRegion {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::copy_backup_to_region_input::Builder,
    }
    impl CopyBackupToRegion {
        /// Creates a new `CopyBackupToRegion`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CopyBackupToRegionOutput,
            aws_smithy_http::result::SdkError<crate::error::CopyBackupToRegionError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The AWS region that will contain your copied CloudHSM cluster backup.</p>
        pub fn destination_region(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.destination_region(input.into());
            self
        }
        /// <p>The AWS region that will contain your copied CloudHSM cluster backup.</p>
        pub fn set_destination_region(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_destination_region(input);
            self
        }
        /// <p>The ID of the backup that will be copied to the destination region. </p>
        pub fn backup_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.backup_id(input.into());
            self
        }
        /// <p>The ID of the backup that will be copied to the destination region. </p>
        pub fn set_backup_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_backup_id(input);
            self
        }
        /// Appends an item to `TagList`.
        ///
        /// To override the contents of this collection use [`set_tag_list`](Self::set_tag_list).
        ///
        /// <p>Tags to apply to the destination backup during creation. If you specify tags, only these tags will be applied to the destination backup. If you do not specify tags, the service copies tags from the source backup to the destination backup.</p>
        pub fn tag_list(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tag_list(input);
            self
        }
        /// <p>Tags to apply to the destination backup during creation. If you specify tags, only these tags will be applied to the destination backup. If you do not specify tags, the service copies tags from the source backup to the destination backup.</p>
        pub fn set_tag_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tag_list(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateCluster`.
    ///
    /// <p>Creates a new AWS CloudHSM cluster.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateCluster {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_cluster_input::Builder,
    }
    impl CreateCluster {
        /// Creates a new `CreateCluster`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateClusterOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateClusterError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A policy that defines how the service retains backups.</p>
        pub fn backup_retention_policy(
            mut self,
            input: crate::model::BackupRetentionPolicy,
        ) -> Self {
            self.inner = self.inner.backup_retention_policy(input);
            self
        }
        /// <p>A policy that defines how the service retains backups.</p>
        pub fn set_backup_retention_policy(
            mut self,
            input: std::option::Option<crate::model::BackupRetentionPolicy>,
        ) -> Self {
            self.inner = self.inner.set_backup_retention_policy(input);
            self
        }
        /// <p>The type of HSM to use in the cluster. Currently the only allowed value is <code>hsm1.medium</code>.</p>
        pub fn hsm_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.hsm_type(input.into());
            self
        }
        /// <p>The type of HSM to use in the cluster. Currently the only allowed value is <code>hsm1.medium</code>.</p>
        pub fn set_hsm_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_hsm_type(input);
            self
        }
        /// <p>The identifier (ID) of the cluster backup to restore. Use this value to restore the cluster from a backup instead of creating a new cluster. To find the backup ID, use <code>DescribeBackups</code>.</p>
        pub fn source_backup_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.source_backup_id(input.into());
            self
        }
        /// <p>The identifier (ID) of the cluster backup to restore. Use this value to restore the cluster from a backup instead of creating a new cluster. To find the backup ID, use <code>DescribeBackups</code>.</p>
        pub fn set_source_backup_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_source_backup_id(input);
            self
        }
        /// Appends an item to `SubnetIds`.
        ///
        /// To override the contents of this collection use [`set_subnet_ids`](Self::set_subnet_ids).
        ///
        /// <p>The identifiers (IDs) of the subnets where you are creating the cluster. You must specify at least one subnet. If you specify multiple subnets, they must meet the following criteria:</p>
        /// <ul>
        /// <li> <p>All subnets must be in the same virtual private cloud (VPC).</p> </li>
        /// <li> <p>You can specify only one subnet per Availability Zone.</p> </li>
        /// </ul>
        pub fn subnet_ids(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.subnet_ids(input.into());
            self
        }
        /// <p>The identifiers (IDs) of the subnets where you are creating the cluster. You must specify at least one subnet. If you specify multiple subnets, they must meet the following criteria:</p>
        /// <ul>
        /// <li> <p>All subnets must be in the same virtual private cloud (VPC).</p> </li>
        /// <li> <p>You can specify only one subnet per Availability Zone.</p> </li>
        /// </ul>
        pub fn set_subnet_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_subnet_ids(input);
            self
        }
        /// Appends an item to `TagList`.
        ///
        /// To override the contents of this collection use [`set_tag_list`](Self::set_tag_list).
        ///
        /// <p>Tags to apply to the CloudHSM cluster during creation.</p>
        pub fn tag_list(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tag_list(input);
            self
        }
        /// <p>Tags to apply to the CloudHSM cluster during creation.</p>
        pub fn set_tag_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tag_list(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateHsm`.
    ///
    /// <p>Creates a new hardware security module (HSM) in the specified AWS CloudHSM cluster.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateHsm {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_hsm_input::Builder,
    }
    impl CreateHsm {
        /// Creates a new `CreateHsm`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateHsmOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateHsmError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier (ID) of the HSM's cluster. To find the cluster ID, use <code>DescribeClusters</code>.</p>
        pub fn cluster_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cluster_id(input.into());
            self
        }
        /// <p>The identifier (ID) of the HSM's cluster. To find the cluster ID, use <code>DescribeClusters</code>.</p>
        pub fn set_cluster_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_cluster_id(input);
            self
        }
        /// <p>The Availability Zone where you are creating the HSM. To find the cluster's Availability Zones, use <code>DescribeClusters</code>.</p>
        pub fn availability_zone(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.availability_zone(input.into());
            self
        }
        /// <p>The Availability Zone where you are creating the HSM. To find the cluster's Availability Zones, use <code>DescribeClusters</code>.</p>
        pub fn set_availability_zone(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_availability_zone(input);
            self
        }
        /// <p>The HSM's IP address. If you specify an IP address, use an available address from the subnet that maps to the Availability Zone where you are creating the HSM. If you don't specify an IP address, one is chosen for you from that subnet.</p>
        pub fn ip_address(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.ip_address(input.into());
            self
        }
        /// <p>The HSM's IP address. If you specify an IP address, use an available address from the subnet that maps to the Availability Zone where you are creating the HSM. If you don't specify an IP address, one is chosen for you from that subnet.</p>
        pub fn set_ip_address(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_ip_address(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteBackup`.
    ///
    /// <p>Deletes a specified AWS CloudHSM backup. A backup can be restored up to 7 days after the DeleteBackup request is made. For more information on restoring a backup, see <code>RestoreBackup</code>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteBackup {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_backup_input::Builder,
    }
    impl DeleteBackup {
        /// Creates a new `DeleteBackup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteBackupOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteBackupError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the backup to be deleted. To find the ID of a backup, use the <code>DescribeBackups</code> operation.</p>
        pub fn backup_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.backup_id(input.into());
            self
        }
        /// <p>The ID of the backup to be deleted. To find the ID of a backup, use the <code>DescribeBackups</code> operation.</p>
        pub fn set_backup_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_backup_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteCluster`.
    ///
    /// <p>Deletes the specified AWS CloudHSM cluster. Before you can delete a cluster, you must delete all HSMs in the cluster. To see if the cluster contains any HSMs, use <code>DescribeClusters</code>. To delete an HSM, use <code>DeleteHsm</code>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteCluster {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_cluster_input::Builder,
    }
    impl DeleteCluster {
        /// Creates a new `DeleteCluster`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteClusterOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteClusterError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier (ID) of the cluster that you are deleting. To find the cluster ID, use <code>DescribeClusters</code>.</p>
        pub fn cluster_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cluster_id(input.into());
            self
        }
        /// <p>The identifier (ID) of the cluster that you are deleting. To find the cluster ID, use <code>DescribeClusters</code>.</p>
        pub fn set_cluster_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_cluster_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteHsm`.
    ///
    /// <p>Deletes the specified HSM. To specify an HSM, you can use its identifier (ID), the IP address of the HSM's elastic network interface (ENI), or the ID of the HSM's ENI. You need to specify only one of these values. To find these values, use <code>DescribeClusters</code>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteHsm {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_hsm_input::Builder,
    }
    impl DeleteHsm {
        /// Creates a new `DeleteHsm`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteHsmOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteHsmError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier (ID) of the cluster that contains the HSM that you are deleting.</p>
        pub fn cluster_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cluster_id(input.into());
            self
        }
        /// <p>The identifier (ID) of the cluster that contains the HSM that you are deleting.</p>
        pub fn set_cluster_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_cluster_id(input);
            self
        }
        /// <p>The identifier (ID) of the HSM that you are deleting.</p>
        pub fn hsm_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.hsm_id(input.into());
            self
        }
        /// <p>The identifier (ID) of the HSM that you are deleting.</p>
        pub fn set_hsm_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_hsm_id(input);
            self
        }
        /// <p>The identifier (ID) of the elastic network interface (ENI) of the HSM that you are deleting.</p>
        pub fn eni_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.eni_id(input.into());
            self
        }
        /// <p>The identifier (ID) of the elastic network interface (ENI) of the HSM that you are deleting.</p>
        pub fn set_eni_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_eni_id(input);
            self
        }
        /// <p>The IP address of the elastic network interface (ENI) of the HSM that you are deleting.</p>
        pub fn eni_ip(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.eni_ip(input.into());
            self
        }
        /// <p>The IP address of the elastic network interface (ENI) of the HSM that you are deleting.</p>
        pub fn set_eni_ip(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_eni_ip(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeBackups`.
    ///
    /// <p>Gets information about backups of AWS CloudHSM clusters.</p>
    /// <p>This is a paginated operation, which means that each response might contain only a subset of all the backups. When the response contains only a subset of backups, it includes a <code>NextToken</code> value. Use this value in a subsequent <code>DescribeBackups</code> request to get more backups. When you receive a response with no <code>NextToken</code> (or an empty or null value), that means there are no more backups to get.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeBackups {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_backups_input::Builder,
    }
    impl DescribeBackups {
        /// Creates a new `DescribeBackups`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeBackupsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeBackupsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::DescribeBackupsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::DescribeBackupsPaginator {
            crate::paginator::DescribeBackupsPaginator::new(self.handle, self.inner)
        }
        /// <p>The <code>NextToken</code> value that you received in the previous response. Use this value to get more backups.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The <code>NextToken</code> value that you received in the previous response. Use this value to get more backups.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of backups to return in the response. When there are more backups than the number you specify, the response contains a <code>NextToken</code> value.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of backups to return in the response. When there are more backups than the number you specify, the response contains a <code>NextToken</code> value.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// Adds a key-value pair to `Filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>One or more filters to limit the items returned in the response.</p>
        /// <p>Use the <code>backupIds</code> filter to return only the specified backups. Specify backups by their backup identifier (ID).</p>
        /// <p>Use the <code>sourceBackupIds</code> filter to return only the backups created from a source backup. The <code>sourceBackupID</code> of a source backup is returned by the <code>CopyBackupToRegion</code> operation.</p>
        /// <p>Use the <code>clusterIds</code> filter to return only the backups for the specified clusters. Specify clusters by their cluster identifier (ID).</p>
        /// <p>Use the <code>states</code> filter to return only backups that match the specified state.</p>
        /// <p>Use the <code>neverExpires</code> filter to return backups filtered by the value in the <code>neverExpires</code> parameter. <code>True</code> returns all backups exempt from the backup retention policy. <code>False</code> returns all backups with a backup retention policy defined at the cluster.</p>
        pub fn filters(
            mut self,
            k: impl Into<std::string::String>,
            v: std::vec::Vec<std::string::String>,
        ) -> Self {
            self.inner = self.inner.filters(k.into(), v);
            self
        }
        /// <p>One or more filters to limit the items returned in the response.</p>
        /// <p>Use the <code>backupIds</code> filter to return only the specified backups. Specify backups by their backup identifier (ID).</p>
        /// <p>Use the <code>sourceBackupIds</code> filter to return only the backups created from a source backup. The <code>sourceBackupID</code> of a source backup is returned by the <code>CopyBackupToRegion</code> operation.</p>
        /// <p>Use the <code>clusterIds</code> filter to return only the backups for the specified clusters. Specify clusters by their cluster identifier (ID).</p>
        /// <p>Use the <code>states</code> filter to return only backups that match the specified state.</p>
        /// <p>Use the <code>neverExpires</code> filter to return backups filtered by the value in the <code>neverExpires</code> parameter. <code>True</code> returns all backups exempt from the backup retention policy. <code>False</code> returns all backups with a backup retention policy defined at the cluster.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::vec::Vec<std::string::String>>,
            >,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p>Designates whether or not to sort the return backups by ascending chronological order of generation.</p>
        pub fn sort_ascending(mut self, input: bool) -> Self {
            self.inner = self.inner.sort_ascending(input);
            self
        }
        /// <p>Designates whether or not to sort the return backups by ascending chronological order of generation.</p>
        pub fn set_sort_ascending(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_sort_ascending(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeClusters`.
    ///
    /// <p>Gets information about AWS CloudHSM clusters.</p>
    /// <p>This is a paginated operation, which means that each response might contain only a subset of all the clusters. When the response contains only a subset of clusters, it includes a <code>NextToken</code> value. Use this value in a subsequent <code>DescribeClusters</code> request to get more clusters. When you receive a response with no <code>NextToken</code> (or an empty or null value), that means there are no more clusters to get.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeClusters {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_clusters_input::Builder,
    }
    impl DescribeClusters {
        /// Creates a new `DescribeClusters`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeClustersOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeClustersError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::DescribeClustersPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::DescribeClustersPaginator {
            crate::paginator::DescribeClustersPaginator::new(self.handle, self.inner)
        }
        /// Adds a key-value pair to `Filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>One or more filters to limit the items returned in the response.</p>
        /// <p>Use the <code>clusterIds</code> filter to return only the specified clusters. Specify clusters by their cluster identifier (ID).</p>
        /// <p>Use the <code>vpcIds</code> filter to return only the clusters in the specified virtual private clouds (VPCs). Specify VPCs by their VPC identifier (ID).</p>
        /// <p>Use the <code>states</code> filter to return only clusters that match the specified state.</p>
        pub fn filters(
            mut self,
            k: impl Into<std::string::String>,
            v: std::vec::Vec<std::string::String>,
        ) -> Self {
            self.inner = self.inner.filters(k.into(), v);
            self
        }
        /// <p>One or more filters to limit the items returned in the response.</p>
        /// <p>Use the <code>clusterIds</code> filter to return only the specified clusters. Specify clusters by their cluster identifier (ID).</p>
        /// <p>Use the <code>vpcIds</code> filter to return only the clusters in the specified virtual private clouds (VPCs). Specify VPCs by their VPC identifier (ID).</p>
        /// <p>Use the <code>states</code> filter to return only clusters that match the specified state.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::vec::Vec<std::string::String>>,
            >,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p>The <code>NextToken</code> value that you received in the previous response. Use this value to get more clusters.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The <code>NextToken</code> value that you received in the previous response. Use this value to get more clusters.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of clusters to return in the response. When there are more clusters than the number you specify, the response contains a <code>NextToken</code> value.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of clusters to return in the response. When there are more clusters than the number you specify, the response contains a <code>NextToken</code> value.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `InitializeCluster`.
    ///
    /// <p>Claims an AWS CloudHSM cluster by submitting the cluster certificate issued by your issuing certificate authority (CA) and the CA's root certificate. Before you can claim a cluster, you must sign the cluster's certificate signing request (CSR) with your issuing CA. To get the cluster's CSR, use <code>DescribeClusters</code>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct InitializeCluster {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::initialize_cluster_input::Builder,
    }
    impl InitializeCluster {
        /// Creates a new `InitializeCluster`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::InitializeClusterOutput,
            aws_smithy_http::result::SdkError<crate::error::InitializeClusterError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier (ID) of the cluster that you are claiming. To find the cluster ID, use <code>DescribeClusters</code>.</p>
        pub fn cluster_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cluster_id(input.into());
            self
        }
        /// <p>The identifier (ID) of the cluster that you are claiming. To find the cluster ID, use <code>DescribeClusters</code>.</p>
        pub fn set_cluster_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_cluster_id(input);
            self
        }
        /// <p>The cluster certificate issued (signed) by your issuing certificate authority (CA). The certificate must be in PEM format and can contain a maximum of 5000 characters.</p>
        pub fn signed_cert(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.signed_cert(input.into());
            self
        }
        /// <p>The cluster certificate issued (signed) by your issuing certificate authority (CA). The certificate must be in PEM format and can contain a maximum of 5000 characters.</p>
        pub fn set_signed_cert(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_signed_cert(input);
            self
        }
        /// <p>The issuing certificate of the issuing certificate authority (CA) that issued (signed) the cluster certificate. You must use a self-signed certificate. The certificate used to sign the HSM CSR must be directly available, and thus must be the root certificate. The certificate must be in PEM format and can contain a maximum of 5000 characters.</p>
        pub fn trust_anchor(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.trust_anchor(input.into());
            self
        }
        /// <p>The issuing certificate of the issuing certificate authority (CA) that issued (signed) the cluster certificate. You must use a self-signed certificate. The certificate used to sign the HSM CSR must be directly available, and thus must be the root certificate. The certificate must be in PEM format and can contain a maximum of 5000 characters.</p>
        pub fn set_trust_anchor(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_trust_anchor(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTags`.
    ///
    /// <p>Gets a list of tags for the specified AWS CloudHSM cluster.</p>
    /// <p>This is a paginated operation, which means that each response might contain only a subset of all the tags. When the response contains only a subset of tags, it includes a <code>NextToken</code> value. Use this value in a subsequent <code>ListTags</code> request to get more tags. When you receive a response with no <code>NextToken</code> (or an empty or null value), that means there are no more tags to get.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListTags {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_tags_input::Builder,
    }
    impl ListTags {
        /// Creates a new `ListTags`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTagsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTagsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListTagsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListTagsPaginator {
            crate::paginator::ListTagsPaginator::new(self.handle, self.inner)
        }
        /// <p>The cluster identifier (ID) for the cluster whose tags you are getting. To find the cluster ID, use <code>DescribeClusters</code>.</p>
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_id(input.into());
            self
        }
        /// <p>The cluster identifier (ID) for the cluster whose tags you are getting. To find the cluster ID, use <code>DescribeClusters</code>.</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_id(input);
            self
        }
        /// <p>The <code>NextToken</code> value that you received in the previous response. Use this value to get more tags.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The <code>NextToken</code> value that you received in the previous response. Use this value to get more tags.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of tags to return in the response. When there are more tags than the number you specify, the response contains a <code>NextToken</code> value.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of tags to return in the response. When there are more tags than the number you specify, the response contains a <code>NextToken</code> value.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ModifyBackupAttributes`.
    ///
    /// <p>Modifies attributes for AWS CloudHSM backup.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ModifyBackupAttributes {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::modify_backup_attributes_input::Builder,
    }
    impl ModifyBackupAttributes {
        /// Creates a new `ModifyBackupAttributes`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ModifyBackupAttributesOutput,
            aws_smithy_http::result::SdkError<crate::error::ModifyBackupAttributesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier (ID) of the backup to modify. To find the ID of a backup, use the <code>DescribeBackups</code> operation.</p>
        pub fn backup_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.backup_id(input.into());
            self
        }
        /// <p>The identifier (ID) of the backup to modify. To find the ID of a backup, use the <code>DescribeBackups</code> operation.</p>
        pub fn set_backup_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_backup_id(input);
            self
        }
        /// <p>Specifies whether the service should exempt a backup from the retention policy for the cluster. <code>True</code> exempts a backup from the retention policy. <code>False</code> means the service applies the backup retention policy defined at the cluster.</p>
        pub fn never_expires(mut self, input: bool) -> Self {
            self.inner = self.inner.never_expires(input);
            self
        }
        /// <p>Specifies whether the service should exempt a backup from the retention policy for the cluster. <code>True</code> exempts a backup from the retention policy. <code>False</code> means the service applies the backup retention policy defined at the cluster.</p>
        pub fn set_never_expires(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_never_expires(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ModifyCluster`.
    ///
    /// <p>Modifies AWS CloudHSM cluster.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ModifyCluster {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::modify_cluster_input::Builder,
    }
    impl ModifyCluster {
        /// Creates a new `ModifyCluster`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ModifyClusterOutput,
            aws_smithy_http::result::SdkError<crate::error::ModifyClusterError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A policy that defines how the service retains backups.</p>
        pub fn backup_retention_policy(
            mut self,
            input: crate::model::BackupRetentionPolicy,
        ) -> Self {
            self.inner = self.inner.backup_retention_policy(input);
            self
        }
        /// <p>A policy that defines how the service retains backups.</p>
        pub fn set_backup_retention_policy(
            mut self,
            input: std::option::Option<crate::model::BackupRetentionPolicy>,
        ) -> Self {
            self.inner = self.inner.set_backup_retention_policy(input);
            self
        }
        /// <p>The identifier (ID) of the cluster that you want to modify. To find the cluster ID, use <code>DescribeClusters</code>.</p>
        pub fn cluster_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cluster_id(input.into());
            self
        }
        /// <p>The identifier (ID) of the cluster that you want to modify. To find the cluster ID, use <code>DescribeClusters</code>.</p>
        pub fn set_cluster_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_cluster_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RestoreBackup`.
    ///
    /// <p>Restores a specified AWS CloudHSM backup that is in the <code>PENDING_DELETION</code> state. For mor information on deleting a backup, see <code>DeleteBackup</code>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct RestoreBackup {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::restore_backup_input::Builder,
    }
    impl RestoreBackup {
        /// Creates a new `RestoreBackup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RestoreBackupOutput,
            aws_smithy_http::result::SdkError<crate::error::RestoreBackupError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the backup to be restored. To find the ID of a backup, use the <code>DescribeBackups</code> operation.</p>
        pub fn backup_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.backup_id(input.into());
            self
        }
        /// <p>The ID of the backup to be restored. To find the ID of a backup, use the <code>DescribeBackups</code> operation.</p>
        pub fn set_backup_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_backup_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TagResource`.
    ///
    /// <p>Adds or overwrites one or more tags for the specified AWS CloudHSM cluster.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct TagResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::tag_resource_input::Builder,
    }
    impl TagResource {
        /// Creates a new `TagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::TagResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The cluster identifier (ID) for the cluster that you are tagging. To find the cluster ID, use <code>DescribeClusters</code>.</p>
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_id(input.into());
            self
        }
        /// <p>The cluster identifier (ID) for the cluster that you are tagging. To find the cluster ID, use <code>DescribeClusters</code>.</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_id(input);
            self
        }
        /// Appends an item to `TagList`.
        ///
        /// To override the contents of this collection use [`set_tag_list`](Self::set_tag_list).
        ///
        /// <p>A list of one or more tags.</p>
        pub fn tag_list(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tag_list(input);
            self
        }
        /// <p>A list of one or more tags.</p>
        pub fn set_tag_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tag_list(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UntagResource`.
    ///
    /// <p>Removes the specified tag or tags from the specified AWS CloudHSM cluster.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UntagResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::untag_resource_input::Builder,
    }
    impl UntagResource {
        /// Creates a new `UntagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UntagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::UntagResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The cluster identifier (ID) for the cluster whose tags you are removing. To find the cluster ID, use <code>DescribeClusters</code>.</p>
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_id(input.into());
            self
        }
        /// <p>The cluster identifier (ID) for the cluster whose tags you are removing. To find the cluster ID, use <code>DescribeClusters</code>.</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_id(input);
            self
        }
        /// Appends an item to `TagKeyList`.
        ///
        /// To override the contents of this collection use [`set_tag_key_list`](Self::set_tag_key_list).
        ///
        /// <p>A list of one or more tag keys for the tags that you are removing. Specify only the tag keys, not the tag values.</p>
        pub fn tag_key_list(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_key_list(input.into());
            self
        }
        /// <p>A list of one or more tag keys for the tags that you are removing. Specify only the tag keys, not the tag values.</p>
        pub fn set_tag_key_list(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_key_list(input);
            self
        }
    }
}

impl Client {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn<C, E>(conf: crate::Config, conn: C) -> Self
    where
        C: aws_smithy_client::bounds::SmithyConnector<Error = E> + Send + 'static,
        E: Into<aws_smithy_http::result::ConnectorError>,
    {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::new()
            .connector(aws_smithy_client::erase::DynConnector::new(conn))
            .middleware(aws_smithy_client::erase::DynMiddleware::new(
                crate::middleware::DefaultMiddleware::new(),
            ));
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(config: &aws_types::config::Config) -> Self {
        Self::from_conf(config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::dyn_https().middleware(
            aws_smithy_client::erase::DynMiddleware::new(
                crate::middleware::DefaultMiddleware::new(),
            ),
        );
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        // the builder maintains a try-state. To avoid suppressing the warning when sleep is unset,
        // only set it if we actually have a sleep impl.
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();

        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
