// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// <p>Contains a tag. A tag is a key-value pair.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Tag {
    /// <p>The key of the tag.</p>
    pub key: std::option::Option<std::string::String>,
    /// <p>The value of the tag.</p>
    pub value: std::option::Option<std::string::String>,
}
impl Tag {
    /// <p>The key of the tag.</p>
    pub fn key(&self) -> std::option::Option<&str> {
        self.key.as_deref()
    }
    /// <p>The value of the tag.</p>
    pub fn value(&self) -> std::option::Option<&str> {
        self.value.as_deref()
    }
}
impl std::fmt::Debug for Tag {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Tag");
        formatter.field("key", &self.key);
        formatter.field("value", &self.value);
        formatter.finish()
    }
}
/// See [`Tag`](crate::model::Tag)
pub mod tag {
    /// A builder for [`Tag`](crate::model::Tag)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) key: std::option::Option<std::string::String>,
        pub(crate) value: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The key of the tag.</p>
        pub fn key(mut self, input: impl Into<std::string::String>) -> Self {
            self.key = Some(input.into());
            self
        }
        /// <p>The key of the tag.</p>
        pub fn set_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key = input;
            self
        }
        /// <p>The value of the tag.</p>
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            self.value = Some(input.into());
            self
        }
        /// <p>The value of the tag.</p>
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.value = input;
            self
        }
        /// Consumes the builder and constructs a [`Tag`](crate::model::Tag)
        pub fn build(self) -> crate::model::Tag {
            crate::model::Tag {
                key: self.key,
                value: self.value,
            }
        }
    }
}
impl Tag {
    /// Creates a new builder-style object to manufacture [`Tag`](crate::model::Tag)
    pub fn builder() -> crate::model::tag::Builder {
        crate::model::tag::Builder::default()
    }
}

/// <p>Contains information about a backup of an AWS CloudHSM cluster. All backup objects
/// contain the <code>BackupId</code>, <code>BackupState</code>, <code>ClusterId</code>, and
/// <code>CreateTimestamp</code> parameters. Backups that were copied into a destination region
/// additionally contain the <code>CopyTimestamp</code>, <code>SourceBackup</code>,
/// <code>SourceCluster</code>, and <code>SourceRegion</code> parameters. A backup that is
/// pending deletion will include the <code>DeleteTimestamp</code> parameter.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Backup {
    /// <p>The identifier (ID) of the backup.</p>
    pub backup_id: std::option::Option<std::string::String>,
    /// <p>The state of the backup.</p>
    pub backup_state: std::option::Option<crate::model::BackupState>,
    /// <p>The identifier (ID) of the cluster that was backed up.</p>
    pub cluster_id: std::option::Option<std::string::String>,
    /// <p>The date and time when the backup was created.</p>
    pub create_timestamp: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The date and time when the backup was copied from a source backup.</p>
    pub copy_timestamp: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>Specifies whether the service should exempt a backup from the retention policy for the cluster. <code>True</code> exempts
    /// a backup from the retention policy. <code>False</code> means the service applies the backup retention policy defined at the cluster.</p>
    pub never_expires: std::option::Option<bool>,
    /// <p>The AWS Region that contains the source backup from which the new backup was
    /// copied.</p>
    pub source_region: std::option::Option<std::string::String>,
    /// <p>The identifier (ID) of the source backup from which the new backup was
    /// copied.</p>
    pub source_backup: std::option::Option<std::string::String>,
    /// <p>The identifier (ID) of the cluster containing the source backup from which the new
    /// backup was copied.</p>
    pub source_cluster: std::option::Option<std::string::String>,
    /// <p>The date and time when the backup will be permanently deleted.</p>
    pub delete_timestamp: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The list of tags for the backup.</p>
    pub tag_list: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl Backup {
    /// <p>The identifier (ID) of the backup.</p>
    pub fn backup_id(&self) -> std::option::Option<&str> {
        self.backup_id.as_deref()
    }
    /// <p>The state of the backup.</p>
    pub fn backup_state(&self) -> std::option::Option<&crate::model::BackupState> {
        self.backup_state.as_ref()
    }
    /// <p>The identifier (ID) of the cluster that was backed up.</p>
    pub fn cluster_id(&self) -> std::option::Option<&str> {
        self.cluster_id.as_deref()
    }
    /// <p>The date and time when the backup was created.</p>
    pub fn create_timestamp(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.create_timestamp.as_ref()
    }
    /// <p>The date and time when the backup was copied from a source backup.</p>
    pub fn copy_timestamp(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.copy_timestamp.as_ref()
    }
    /// <p>Specifies whether the service should exempt a backup from the retention policy for the cluster. <code>True</code> exempts
    /// a backup from the retention policy. <code>False</code> means the service applies the backup retention policy defined at the cluster.</p>
    pub fn never_expires(&self) -> std::option::Option<bool> {
        self.never_expires
    }
    /// <p>The AWS Region that contains the source backup from which the new backup was
    /// copied.</p>
    pub fn source_region(&self) -> std::option::Option<&str> {
        self.source_region.as_deref()
    }
    /// <p>The identifier (ID) of the source backup from which the new backup was
    /// copied.</p>
    pub fn source_backup(&self) -> std::option::Option<&str> {
        self.source_backup.as_deref()
    }
    /// <p>The identifier (ID) of the cluster containing the source backup from which the new
    /// backup was copied.</p>
    pub fn source_cluster(&self) -> std::option::Option<&str> {
        self.source_cluster.as_deref()
    }
    /// <p>The date and time when the backup will be permanently deleted.</p>
    pub fn delete_timestamp(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.delete_timestamp.as_ref()
    }
    /// <p>The list of tags for the backup.</p>
    pub fn tag_list(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tag_list.as_deref()
    }
}
impl std::fmt::Debug for Backup {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Backup");
        formatter.field("backup_id", &self.backup_id);
        formatter.field("backup_state", &self.backup_state);
        formatter.field("cluster_id", &self.cluster_id);
        formatter.field("create_timestamp", &self.create_timestamp);
        formatter.field("copy_timestamp", &self.copy_timestamp);
        formatter.field("never_expires", &self.never_expires);
        formatter.field("source_region", &self.source_region);
        formatter.field("source_backup", &self.source_backup);
        formatter.field("source_cluster", &self.source_cluster);
        formatter.field("delete_timestamp", &self.delete_timestamp);
        formatter.field("tag_list", &self.tag_list);
        formatter.finish()
    }
}
/// See [`Backup`](crate::model::Backup)
pub mod backup {
    /// A builder for [`Backup`](crate::model::Backup)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) backup_id: std::option::Option<std::string::String>,
        pub(crate) backup_state: std::option::Option<crate::model::BackupState>,
        pub(crate) cluster_id: std::option::Option<std::string::String>,
        pub(crate) create_timestamp: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) copy_timestamp: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) never_expires: std::option::Option<bool>,
        pub(crate) source_region: std::option::Option<std::string::String>,
        pub(crate) source_backup: std::option::Option<std::string::String>,
        pub(crate) source_cluster: std::option::Option<std::string::String>,
        pub(crate) delete_timestamp: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) tag_list: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The identifier (ID) of the backup.</p>
        pub fn backup_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.backup_id = Some(input.into());
            self
        }
        /// <p>The identifier (ID) of the backup.</p>
        pub fn set_backup_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.backup_id = input;
            self
        }
        /// <p>The state of the backup.</p>
        pub fn backup_state(mut self, input: crate::model::BackupState) -> Self {
            self.backup_state = Some(input);
            self
        }
        /// <p>The state of the backup.</p>
        pub fn set_backup_state(
            mut self,
            input: std::option::Option<crate::model::BackupState>,
        ) -> Self {
            self.backup_state = input;
            self
        }
        /// <p>The identifier (ID) of the cluster that was backed up.</p>
        pub fn cluster_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.cluster_id = Some(input.into());
            self
        }
        /// <p>The identifier (ID) of the cluster that was backed up.</p>
        pub fn set_cluster_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.cluster_id = input;
            self
        }
        /// <p>The date and time when the backup was created.</p>
        pub fn create_timestamp(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.create_timestamp = Some(input);
            self
        }
        /// <p>The date and time when the backup was created.</p>
        pub fn set_create_timestamp(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.create_timestamp = input;
            self
        }
        /// <p>The date and time when the backup was copied from a source backup.</p>
        pub fn copy_timestamp(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.copy_timestamp = Some(input);
            self
        }
        /// <p>The date and time when the backup was copied from a source backup.</p>
        pub fn set_copy_timestamp(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.copy_timestamp = input;
            self
        }
        /// <p>Specifies whether the service should exempt a backup from the retention policy for the cluster. <code>True</code> exempts
        /// a backup from the retention policy. <code>False</code> means the service applies the backup retention policy defined at the cluster.</p>
        pub fn never_expires(mut self, input: bool) -> Self {
            self.never_expires = Some(input);
            self
        }
        /// <p>Specifies whether the service should exempt a backup from the retention policy for the cluster. <code>True</code> exempts
        /// a backup from the retention policy. <code>False</code> means the service applies the backup retention policy defined at the cluster.</p>
        pub fn set_never_expires(mut self, input: std::option::Option<bool>) -> Self {
            self.never_expires = input;
            self
        }
        /// <p>The AWS Region that contains the source backup from which the new backup was
        /// copied.</p>
        pub fn source_region(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_region = Some(input.into());
            self
        }
        /// <p>The AWS Region that contains the source backup from which the new backup was
        /// copied.</p>
        pub fn set_source_region(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.source_region = input;
            self
        }
        /// <p>The identifier (ID) of the source backup from which the new backup was
        /// copied.</p>
        pub fn source_backup(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_backup = Some(input.into());
            self
        }
        /// <p>The identifier (ID) of the source backup from which the new backup was
        /// copied.</p>
        pub fn set_source_backup(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.source_backup = input;
            self
        }
        /// <p>The identifier (ID) of the cluster containing the source backup from which the new
        /// backup was copied.</p>
        pub fn source_cluster(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_cluster = Some(input.into());
            self
        }
        /// <p>The identifier (ID) of the cluster containing the source backup from which the new
        /// backup was copied.</p>
        pub fn set_source_cluster(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.source_cluster = input;
            self
        }
        /// <p>The date and time when the backup will be permanently deleted.</p>
        pub fn delete_timestamp(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.delete_timestamp = Some(input);
            self
        }
        /// <p>The date and time when the backup will be permanently deleted.</p>
        pub fn set_delete_timestamp(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.delete_timestamp = input;
            self
        }
        /// Appends an item to `tag_list`.
        ///
        /// To override the contents of this collection use [`set_tag_list`](Self::set_tag_list).
        ///
        /// <p>The list of tags for the backup.</p>
        pub fn tag_list(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tag_list.unwrap_or_default();
            v.push(input.into());
            self.tag_list = Some(v);
            self
        }
        /// <p>The list of tags for the backup.</p>
        pub fn set_tag_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tag_list = input;
            self
        }
        /// Consumes the builder and constructs a [`Backup`](crate::model::Backup)
        pub fn build(self) -> crate::model::Backup {
            crate::model::Backup {
                backup_id: self.backup_id,
                backup_state: self.backup_state,
                cluster_id: self.cluster_id,
                create_timestamp: self.create_timestamp,
                copy_timestamp: self.copy_timestamp,
                never_expires: self.never_expires,
                source_region: self.source_region,
                source_backup: self.source_backup,
                source_cluster: self.source_cluster,
                delete_timestamp: self.delete_timestamp,
                tag_list: self.tag_list,
            }
        }
    }
}
impl Backup {
    /// Creates a new builder-style object to manufacture [`Backup`](crate::model::Backup)
    pub fn builder() -> crate::model::backup::Builder {
        crate::model::backup::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum BackupState {
    #[allow(missing_docs)] // documentation missing in model
    CreateInProgress,
    #[allow(missing_docs)] // documentation missing in model
    Deleted,
    #[allow(missing_docs)] // documentation missing in model
    PendingDeletion,
    #[allow(missing_docs)] // documentation missing in model
    Ready,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for BackupState {
    fn from(s: &str) -> Self {
        match s {
            "CREATE_IN_PROGRESS" => BackupState::CreateInProgress,
            "DELETED" => BackupState::Deleted,
            "PENDING_DELETION" => BackupState::PendingDeletion,
            "READY" => BackupState::Ready,
            other => BackupState::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for BackupState {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(BackupState::from(s))
    }
}
impl BackupState {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            BackupState::CreateInProgress => "CREATE_IN_PROGRESS",
            BackupState::Deleted => "DELETED",
            BackupState::PendingDeletion => "PENDING_DELETION",
            BackupState::Ready => "READY",
            BackupState::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["CREATE_IN_PROGRESS", "DELETED", "PENDING_DELETION", "READY"]
    }
}
impl AsRef<str> for BackupState {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Contains information about an AWS CloudHSM cluster.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Cluster {
    /// <p>The cluster's backup policy.</p>
    pub backup_policy: std::option::Option<crate::model::BackupPolicy>,
    /// <p>A policy that defines how the service retains backups.</p>
    pub backup_retention_policy: std::option::Option<crate::model::BackupRetentionPolicy>,
    /// <p>The cluster's identifier (ID).</p>
    pub cluster_id: std::option::Option<std::string::String>,
    /// <p>The date and time when the cluster was created.</p>
    pub create_timestamp: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>Contains information about the HSMs in the cluster.</p>
    pub hsms: std::option::Option<std::vec::Vec<crate::model::Hsm>>,
    /// <p>The type of HSM that the cluster contains.</p>
    pub hsm_type: std::option::Option<std::string::String>,
    /// <p>The default password for the cluster's Pre-Crypto Officer (PRECO) user.</p>
    pub pre_co_password: std::option::Option<std::string::String>,
    /// <p>The identifier (ID) of the cluster's security group.</p>
    pub security_group: std::option::Option<std::string::String>,
    /// <p>The identifier (ID) of the backup used to create the cluster. This value exists only
    /// when the cluster was created from a backup.</p>
    pub source_backup_id: std::option::Option<std::string::String>,
    /// <p>The cluster's state.</p>
    pub state: std::option::Option<crate::model::ClusterState>,
    /// <p>A description of the cluster's state.</p>
    pub state_message: std::option::Option<std::string::String>,
    /// <p>A map from availability zone to the cluster’s subnet in that availability zone.</p>
    pub subnet_mapping:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>The identifier (ID) of the virtual private cloud (VPC) that contains the
    /// cluster.</p>
    pub vpc_id: std::option::Option<std::string::String>,
    /// <p>Contains one or more certificates or a certificate signing request (CSR).</p>
    pub certificates: std::option::Option<crate::model::Certificates>,
    /// <p>The list of tags for the cluster.</p>
    pub tag_list: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl Cluster {
    /// <p>The cluster's backup policy.</p>
    pub fn backup_policy(&self) -> std::option::Option<&crate::model::BackupPolicy> {
        self.backup_policy.as_ref()
    }
    /// <p>A policy that defines how the service retains backups.</p>
    pub fn backup_retention_policy(
        &self,
    ) -> std::option::Option<&crate::model::BackupRetentionPolicy> {
        self.backup_retention_policy.as_ref()
    }
    /// <p>The cluster's identifier (ID).</p>
    pub fn cluster_id(&self) -> std::option::Option<&str> {
        self.cluster_id.as_deref()
    }
    /// <p>The date and time when the cluster was created.</p>
    pub fn create_timestamp(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.create_timestamp.as_ref()
    }
    /// <p>Contains information about the HSMs in the cluster.</p>
    pub fn hsms(&self) -> std::option::Option<&[crate::model::Hsm]> {
        self.hsms.as_deref()
    }
    /// <p>The type of HSM that the cluster contains.</p>
    pub fn hsm_type(&self) -> std::option::Option<&str> {
        self.hsm_type.as_deref()
    }
    /// <p>The default password for the cluster's Pre-Crypto Officer (PRECO) user.</p>
    pub fn pre_co_password(&self) -> std::option::Option<&str> {
        self.pre_co_password.as_deref()
    }
    /// <p>The identifier (ID) of the cluster's security group.</p>
    pub fn security_group(&self) -> std::option::Option<&str> {
        self.security_group.as_deref()
    }
    /// <p>The identifier (ID) of the backup used to create the cluster. This value exists only
    /// when the cluster was created from a backup.</p>
    pub fn source_backup_id(&self) -> std::option::Option<&str> {
        self.source_backup_id.as_deref()
    }
    /// <p>The cluster's state.</p>
    pub fn state(&self) -> std::option::Option<&crate::model::ClusterState> {
        self.state.as_ref()
    }
    /// <p>A description of the cluster's state.</p>
    pub fn state_message(&self) -> std::option::Option<&str> {
        self.state_message.as_deref()
    }
    /// <p>A map from availability zone to the cluster’s subnet in that availability zone.</p>
    pub fn subnet_mapping(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.subnet_mapping.as_ref()
    }
    /// <p>The identifier (ID) of the virtual private cloud (VPC) that contains the
    /// cluster.</p>
    pub fn vpc_id(&self) -> std::option::Option<&str> {
        self.vpc_id.as_deref()
    }
    /// <p>Contains one or more certificates or a certificate signing request (CSR).</p>
    pub fn certificates(&self) -> std::option::Option<&crate::model::Certificates> {
        self.certificates.as_ref()
    }
    /// <p>The list of tags for the cluster.</p>
    pub fn tag_list(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tag_list.as_deref()
    }
}
impl std::fmt::Debug for Cluster {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Cluster");
        formatter.field("backup_policy", &self.backup_policy);
        formatter.field("backup_retention_policy", &self.backup_retention_policy);
        formatter.field("cluster_id", &self.cluster_id);
        formatter.field("create_timestamp", &self.create_timestamp);
        formatter.field("hsms", &self.hsms);
        formatter.field("hsm_type", &self.hsm_type);
        formatter.field("pre_co_password", &self.pre_co_password);
        formatter.field("security_group", &self.security_group);
        formatter.field("source_backup_id", &self.source_backup_id);
        formatter.field("state", &self.state);
        formatter.field("state_message", &self.state_message);
        formatter.field("subnet_mapping", &self.subnet_mapping);
        formatter.field("vpc_id", &self.vpc_id);
        formatter.field("certificates", &self.certificates);
        formatter.field("tag_list", &self.tag_list);
        formatter.finish()
    }
}
/// See [`Cluster`](crate::model::Cluster)
pub mod cluster {
    /// A builder for [`Cluster`](crate::model::Cluster)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) backup_policy: std::option::Option<crate::model::BackupPolicy>,
        pub(crate) backup_retention_policy:
            std::option::Option<crate::model::BackupRetentionPolicy>,
        pub(crate) cluster_id: std::option::Option<std::string::String>,
        pub(crate) create_timestamp: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) hsms: std::option::Option<std::vec::Vec<crate::model::Hsm>>,
        pub(crate) hsm_type: std::option::Option<std::string::String>,
        pub(crate) pre_co_password: std::option::Option<std::string::String>,
        pub(crate) security_group: std::option::Option<std::string::String>,
        pub(crate) source_backup_id: std::option::Option<std::string::String>,
        pub(crate) state: std::option::Option<crate::model::ClusterState>,
        pub(crate) state_message: std::option::Option<std::string::String>,
        pub(crate) subnet_mapping: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) vpc_id: std::option::Option<std::string::String>,
        pub(crate) certificates: std::option::Option<crate::model::Certificates>,
        pub(crate) tag_list: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The cluster's backup policy.</p>
        pub fn backup_policy(mut self, input: crate::model::BackupPolicy) -> Self {
            self.backup_policy = Some(input);
            self
        }
        /// <p>The cluster's backup policy.</p>
        pub fn set_backup_policy(
            mut self,
            input: std::option::Option<crate::model::BackupPolicy>,
        ) -> Self {
            self.backup_policy = input;
            self
        }
        /// <p>A policy that defines how the service retains backups.</p>
        pub fn backup_retention_policy(
            mut self,
            input: crate::model::BackupRetentionPolicy,
        ) -> Self {
            self.backup_retention_policy = Some(input);
            self
        }
        /// <p>A policy that defines how the service retains backups.</p>
        pub fn set_backup_retention_policy(
            mut self,
            input: std::option::Option<crate::model::BackupRetentionPolicy>,
        ) -> Self {
            self.backup_retention_policy = input;
            self
        }
        /// <p>The cluster's identifier (ID).</p>
        pub fn cluster_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.cluster_id = Some(input.into());
            self
        }
        /// <p>The cluster's identifier (ID).</p>
        pub fn set_cluster_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.cluster_id = input;
            self
        }
        /// <p>The date and time when the cluster was created.</p>
        pub fn create_timestamp(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.create_timestamp = Some(input);
            self
        }
        /// <p>The date and time when the cluster was created.</p>
        pub fn set_create_timestamp(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.create_timestamp = input;
            self
        }
        /// Appends an item to `hsms`.
        ///
        /// To override the contents of this collection use [`set_hsms`](Self::set_hsms).
        ///
        /// <p>Contains information about the HSMs in the cluster.</p>
        pub fn hsms(mut self, input: impl Into<crate::model::Hsm>) -> Self {
            let mut v = self.hsms.unwrap_or_default();
            v.push(input.into());
            self.hsms = Some(v);
            self
        }
        /// <p>Contains information about the HSMs in the cluster.</p>
        pub fn set_hsms(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Hsm>>,
        ) -> Self {
            self.hsms = input;
            self
        }
        /// <p>The type of HSM that the cluster contains.</p>
        pub fn hsm_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.hsm_type = Some(input.into());
            self
        }
        /// <p>The type of HSM that the cluster contains.</p>
        pub fn set_hsm_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.hsm_type = input;
            self
        }
        /// <p>The default password for the cluster's Pre-Crypto Officer (PRECO) user.</p>
        pub fn pre_co_password(mut self, input: impl Into<std::string::String>) -> Self {
            self.pre_co_password = Some(input.into());
            self
        }
        /// <p>The default password for the cluster's Pre-Crypto Officer (PRECO) user.</p>
        pub fn set_pre_co_password(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.pre_co_password = input;
            self
        }
        /// <p>The identifier (ID) of the cluster's security group.</p>
        pub fn security_group(mut self, input: impl Into<std::string::String>) -> Self {
            self.security_group = Some(input.into());
            self
        }
        /// <p>The identifier (ID) of the cluster's security group.</p>
        pub fn set_security_group(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.security_group = input;
            self
        }
        /// <p>The identifier (ID) of the backup used to create the cluster. This value exists only
        /// when the cluster was created from a backup.</p>
        pub fn source_backup_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_backup_id = Some(input.into());
            self
        }
        /// <p>The identifier (ID) of the backup used to create the cluster. This value exists only
        /// when the cluster was created from a backup.</p>
        pub fn set_source_backup_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.source_backup_id = input;
            self
        }
        /// <p>The cluster's state.</p>
        pub fn state(mut self, input: crate::model::ClusterState) -> Self {
            self.state = Some(input);
            self
        }
        /// <p>The cluster's state.</p>
        pub fn set_state(mut self, input: std::option::Option<crate::model::ClusterState>) -> Self {
            self.state = input;
            self
        }
        /// <p>A description of the cluster's state.</p>
        pub fn state_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.state_message = Some(input.into());
            self
        }
        /// <p>A description of the cluster's state.</p>
        pub fn set_state_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.state_message = input;
            self
        }
        /// Adds a key-value pair to `subnet_mapping`.
        ///
        /// To override the contents of this collection use [`set_subnet_mapping`](Self::set_subnet_mapping).
        ///
        /// <p>A map from availability zone to the cluster’s subnet in that availability zone.</p>
        pub fn subnet_mapping(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.subnet_mapping.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.subnet_mapping = Some(hash_map);
            self
        }
        /// <p>A map from availability zone to the cluster’s subnet in that availability zone.</p>
        pub fn set_subnet_mapping(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.subnet_mapping = input;
            self
        }
        /// <p>The identifier (ID) of the virtual private cloud (VPC) that contains the
        /// cluster.</p>
        pub fn vpc_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.vpc_id = Some(input.into());
            self
        }
        /// <p>The identifier (ID) of the virtual private cloud (VPC) that contains the
        /// cluster.</p>
        pub fn set_vpc_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.vpc_id = input;
            self
        }
        /// <p>Contains one or more certificates or a certificate signing request (CSR).</p>
        pub fn certificates(mut self, input: crate::model::Certificates) -> Self {
            self.certificates = Some(input);
            self
        }
        /// <p>Contains one or more certificates or a certificate signing request (CSR).</p>
        pub fn set_certificates(
            mut self,
            input: std::option::Option<crate::model::Certificates>,
        ) -> Self {
            self.certificates = input;
            self
        }
        /// Appends an item to `tag_list`.
        ///
        /// To override the contents of this collection use [`set_tag_list`](Self::set_tag_list).
        ///
        /// <p>The list of tags for the cluster.</p>
        pub fn tag_list(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tag_list.unwrap_or_default();
            v.push(input.into());
            self.tag_list = Some(v);
            self
        }
        /// <p>The list of tags for the cluster.</p>
        pub fn set_tag_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tag_list = input;
            self
        }
        /// Consumes the builder and constructs a [`Cluster`](crate::model::Cluster)
        pub fn build(self) -> crate::model::Cluster {
            crate::model::Cluster {
                backup_policy: self.backup_policy,
                backup_retention_policy: self.backup_retention_policy,
                cluster_id: self.cluster_id,
                create_timestamp: self.create_timestamp,
                hsms: self.hsms,
                hsm_type: self.hsm_type,
                pre_co_password: self.pre_co_password,
                security_group: self.security_group,
                source_backup_id: self.source_backup_id,
                state: self.state,
                state_message: self.state_message,
                subnet_mapping: self.subnet_mapping,
                vpc_id: self.vpc_id,
                certificates: self.certificates,
                tag_list: self.tag_list,
            }
        }
    }
}
impl Cluster {
    /// Creates a new builder-style object to manufacture [`Cluster`](crate::model::Cluster)
    pub fn builder() -> crate::model::cluster::Builder {
        crate::model::cluster::Builder::default()
    }
}

/// <p>Contains one or more certificates or a certificate signing request (CSR).</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Certificates {
    /// <p>The cluster's certificate signing request (CSR). The CSR exists only when the cluster's
    /// state is <code>UNINITIALIZED</code>.</p>
    pub cluster_csr: std::option::Option<std::string::String>,
    /// <p>The HSM certificate issued (signed) by the HSM hardware.</p>
    pub hsm_certificate: std::option::Option<std::string::String>,
    /// <p>The HSM hardware certificate issued (signed) by AWS CloudHSM.</p>
    pub aws_hardware_certificate: std::option::Option<std::string::String>,
    /// <p>The HSM hardware certificate issued (signed) by the hardware manufacturer.</p>
    pub manufacturer_hardware_certificate: std::option::Option<std::string::String>,
    /// <p>The cluster certificate issued (signed) by the issuing certificate authority (CA) of
    /// the cluster's owner.</p>
    pub cluster_certificate: std::option::Option<std::string::String>,
}
impl Certificates {
    /// <p>The cluster's certificate signing request (CSR). The CSR exists only when the cluster's
    /// state is <code>UNINITIALIZED</code>.</p>
    pub fn cluster_csr(&self) -> std::option::Option<&str> {
        self.cluster_csr.as_deref()
    }
    /// <p>The HSM certificate issued (signed) by the HSM hardware.</p>
    pub fn hsm_certificate(&self) -> std::option::Option<&str> {
        self.hsm_certificate.as_deref()
    }
    /// <p>The HSM hardware certificate issued (signed) by AWS CloudHSM.</p>
    pub fn aws_hardware_certificate(&self) -> std::option::Option<&str> {
        self.aws_hardware_certificate.as_deref()
    }
    /// <p>The HSM hardware certificate issued (signed) by the hardware manufacturer.</p>
    pub fn manufacturer_hardware_certificate(&self) -> std::option::Option<&str> {
        self.manufacturer_hardware_certificate.as_deref()
    }
    /// <p>The cluster certificate issued (signed) by the issuing certificate authority (CA) of
    /// the cluster's owner.</p>
    pub fn cluster_certificate(&self) -> std::option::Option<&str> {
        self.cluster_certificate.as_deref()
    }
}
impl std::fmt::Debug for Certificates {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Certificates");
        formatter.field("cluster_csr", &self.cluster_csr);
        formatter.field("hsm_certificate", &self.hsm_certificate);
        formatter.field("aws_hardware_certificate", &self.aws_hardware_certificate);
        formatter.field(
            "manufacturer_hardware_certificate",
            &self.manufacturer_hardware_certificate,
        );
        formatter.field("cluster_certificate", &self.cluster_certificate);
        formatter.finish()
    }
}
/// See [`Certificates`](crate::model::Certificates)
pub mod certificates {
    /// A builder for [`Certificates`](crate::model::Certificates)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cluster_csr: std::option::Option<std::string::String>,
        pub(crate) hsm_certificate: std::option::Option<std::string::String>,
        pub(crate) aws_hardware_certificate: std::option::Option<std::string::String>,
        pub(crate) manufacturer_hardware_certificate: std::option::Option<std::string::String>,
        pub(crate) cluster_certificate: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The cluster's certificate signing request (CSR). The CSR exists only when the cluster's
        /// state is <code>UNINITIALIZED</code>.</p>
        pub fn cluster_csr(mut self, input: impl Into<std::string::String>) -> Self {
            self.cluster_csr = Some(input.into());
            self
        }
        /// <p>The cluster's certificate signing request (CSR). The CSR exists only when the cluster's
        /// state is <code>UNINITIALIZED</code>.</p>
        pub fn set_cluster_csr(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.cluster_csr = input;
            self
        }
        /// <p>The HSM certificate issued (signed) by the HSM hardware.</p>
        pub fn hsm_certificate(mut self, input: impl Into<std::string::String>) -> Self {
            self.hsm_certificate = Some(input.into());
            self
        }
        /// <p>The HSM certificate issued (signed) by the HSM hardware.</p>
        pub fn set_hsm_certificate(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.hsm_certificate = input;
            self
        }
        /// <p>The HSM hardware certificate issued (signed) by AWS CloudHSM.</p>
        pub fn aws_hardware_certificate(mut self, input: impl Into<std::string::String>) -> Self {
            self.aws_hardware_certificate = Some(input.into());
            self
        }
        /// <p>The HSM hardware certificate issued (signed) by AWS CloudHSM.</p>
        pub fn set_aws_hardware_certificate(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.aws_hardware_certificate = input;
            self
        }
        /// <p>The HSM hardware certificate issued (signed) by the hardware manufacturer.</p>
        pub fn manufacturer_hardware_certificate(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.manufacturer_hardware_certificate = Some(input.into());
            self
        }
        /// <p>The HSM hardware certificate issued (signed) by the hardware manufacturer.</p>
        pub fn set_manufacturer_hardware_certificate(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.manufacturer_hardware_certificate = input;
            self
        }
        /// <p>The cluster certificate issued (signed) by the issuing certificate authority (CA) of
        /// the cluster's owner.</p>
        pub fn cluster_certificate(mut self, input: impl Into<std::string::String>) -> Self {
            self.cluster_certificate = Some(input.into());
            self
        }
        /// <p>The cluster certificate issued (signed) by the issuing certificate authority (CA) of
        /// the cluster's owner.</p>
        pub fn set_cluster_certificate(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.cluster_certificate = input;
            self
        }
        /// Consumes the builder and constructs a [`Certificates`](crate::model::Certificates)
        pub fn build(self) -> crate::model::Certificates {
            crate::model::Certificates {
                cluster_csr: self.cluster_csr,
                hsm_certificate: self.hsm_certificate,
                aws_hardware_certificate: self.aws_hardware_certificate,
                manufacturer_hardware_certificate: self.manufacturer_hardware_certificate,
                cluster_certificate: self.cluster_certificate,
            }
        }
    }
}
impl Certificates {
    /// Creates a new builder-style object to manufacture [`Certificates`](crate::model::Certificates)
    pub fn builder() -> crate::model::certificates::Builder {
        crate::model::certificates::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ClusterState {
    #[allow(missing_docs)] // documentation missing in model
    Active,
    #[allow(missing_docs)] // documentation missing in model
    CreateInProgress,
    #[allow(missing_docs)] // documentation missing in model
    Degraded,
    #[allow(missing_docs)] // documentation missing in model
    Deleted,
    #[allow(missing_docs)] // documentation missing in model
    DeleteInProgress,
    #[allow(missing_docs)] // documentation missing in model
    Initialized,
    #[allow(missing_docs)] // documentation missing in model
    InitializeInProgress,
    #[allow(missing_docs)] // documentation missing in model
    Uninitialized,
    #[allow(missing_docs)] // documentation missing in model
    UpdateInProgress,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ClusterState {
    fn from(s: &str) -> Self {
        match s {
            "ACTIVE" => ClusterState::Active,
            "CREATE_IN_PROGRESS" => ClusterState::CreateInProgress,
            "DEGRADED" => ClusterState::Degraded,
            "DELETED" => ClusterState::Deleted,
            "DELETE_IN_PROGRESS" => ClusterState::DeleteInProgress,
            "INITIALIZED" => ClusterState::Initialized,
            "INITIALIZE_IN_PROGRESS" => ClusterState::InitializeInProgress,
            "UNINITIALIZED" => ClusterState::Uninitialized,
            "UPDATE_IN_PROGRESS" => ClusterState::UpdateInProgress,
            other => ClusterState::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ClusterState {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ClusterState::from(s))
    }
}
impl ClusterState {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ClusterState::Active => "ACTIVE",
            ClusterState::CreateInProgress => "CREATE_IN_PROGRESS",
            ClusterState::Degraded => "DEGRADED",
            ClusterState::Deleted => "DELETED",
            ClusterState::DeleteInProgress => "DELETE_IN_PROGRESS",
            ClusterState::Initialized => "INITIALIZED",
            ClusterState::InitializeInProgress => "INITIALIZE_IN_PROGRESS",
            ClusterState::Uninitialized => "UNINITIALIZED",
            ClusterState::UpdateInProgress => "UPDATE_IN_PROGRESS",
            ClusterState::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "ACTIVE",
            "CREATE_IN_PROGRESS",
            "DEGRADED",
            "DELETED",
            "DELETE_IN_PROGRESS",
            "INITIALIZED",
            "INITIALIZE_IN_PROGRESS",
            "UNINITIALIZED",
            "UPDATE_IN_PROGRESS",
        ]
    }
}
impl AsRef<str> for ClusterState {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Contains information about a hardware security module (HSM) in an AWS CloudHSM
/// cluster.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Hsm {
    /// <p>The Availability Zone that contains the HSM.</p>
    pub availability_zone: std::option::Option<std::string::String>,
    /// <p>The identifier (ID) of the cluster that contains the HSM.</p>
    pub cluster_id: std::option::Option<std::string::String>,
    /// <p>The subnet that contains the HSM's elastic network interface (ENI).</p>
    pub subnet_id: std::option::Option<std::string::String>,
    /// <p>The identifier (ID) of the HSM's elastic network interface (ENI).</p>
    pub eni_id: std::option::Option<std::string::String>,
    /// <p>The IP address of the HSM's elastic network interface (ENI).</p>
    pub eni_ip: std::option::Option<std::string::String>,
    /// <p>The HSM's identifier (ID).</p>
    pub hsm_id: std::option::Option<std::string::String>,
    /// <p>The HSM's state.</p>
    pub state: std::option::Option<crate::model::HsmState>,
    /// <p>A description of the HSM's state.</p>
    pub state_message: std::option::Option<std::string::String>,
}
impl Hsm {
    /// <p>The Availability Zone that contains the HSM.</p>
    pub fn availability_zone(&self) -> std::option::Option<&str> {
        self.availability_zone.as_deref()
    }
    /// <p>The identifier (ID) of the cluster that contains the HSM.</p>
    pub fn cluster_id(&self) -> std::option::Option<&str> {
        self.cluster_id.as_deref()
    }
    /// <p>The subnet that contains the HSM's elastic network interface (ENI).</p>
    pub fn subnet_id(&self) -> std::option::Option<&str> {
        self.subnet_id.as_deref()
    }
    /// <p>The identifier (ID) of the HSM's elastic network interface (ENI).</p>
    pub fn eni_id(&self) -> std::option::Option<&str> {
        self.eni_id.as_deref()
    }
    /// <p>The IP address of the HSM's elastic network interface (ENI).</p>
    pub fn eni_ip(&self) -> std::option::Option<&str> {
        self.eni_ip.as_deref()
    }
    /// <p>The HSM's identifier (ID).</p>
    pub fn hsm_id(&self) -> std::option::Option<&str> {
        self.hsm_id.as_deref()
    }
    /// <p>The HSM's state.</p>
    pub fn state(&self) -> std::option::Option<&crate::model::HsmState> {
        self.state.as_ref()
    }
    /// <p>A description of the HSM's state.</p>
    pub fn state_message(&self) -> std::option::Option<&str> {
        self.state_message.as_deref()
    }
}
impl std::fmt::Debug for Hsm {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Hsm");
        formatter.field("availability_zone", &self.availability_zone);
        formatter.field("cluster_id", &self.cluster_id);
        formatter.field("subnet_id", &self.subnet_id);
        formatter.field("eni_id", &self.eni_id);
        formatter.field("eni_ip", &self.eni_ip);
        formatter.field("hsm_id", &self.hsm_id);
        formatter.field("state", &self.state);
        formatter.field("state_message", &self.state_message);
        formatter.finish()
    }
}
/// See [`Hsm`](crate::model::Hsm)
pub mod hsm {
    /// A builder for [`Hsm`](crate::model::Hsm)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) availability_zone: std::option::Option<std::string::String>,
        pub(crate) cluster_id: std::option::Option<std::string::String>,
        pub(crate) subnet_id: std::option::Option<std::string::String>,
        pub(crate) eni_id: std::option::Option<std::string::String>,
        pub(crate) eni_ip: std::option::Option<std::string::String>,
        pub(crate) hsm_id: std::option::Option<std::string::String>,
        pub(crate) state: std::option::Option<crate::model::HsmState>,
        pub(crate) state_message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Availability Zone that contains the HSM.</p>
        pub fn availability_zone(mut self, input: impl Into<std::string::String>) -> Self {
            self.availability_zone = Some(input.into());
            self
        }
        /// <p>The Availability Zone that contains the HSM.</p>
        pub fn set_availability_zone(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.availability_zone = input;
            self
        }
        /// <p>The identifier (ID) of the cluster that contains the HSM.</p>
        pub fn cluster_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.cluster_id = Some(input.into());
            self
        }
        /// <p>The identifier (ID) of the cluster that contains the HSM.</p>
        pub fn set_cluster_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.cluster_id = input;
            self
        }
        /// <p>The subnet that contains the HSM's elastic network interface (ENI).</p>
        pub fn subnet_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.subnet_id = Some(input.into());
            self
        }
        /// <p>The subnet that contains the HSM's elastic network interface (ENI).</p>
        pub fn set_subnet_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.subnet_id = input;
            self
        }
        /// <p>The identifier (ID) of the HSM's elastic network interface (ENI).</p>
        pub fn eni_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.eni_id = Some(input.into());
            self
        }
        /// <p>The identifier (ID) of the HSM's elastic network interface (ENI).</p>
        pub fn set_eni_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.eni_id = input;
            self
        }
        /// <p>The IP address of the HSM's elastic network interface (ENI).</p>
        pub fn eni_ip(mut self, input: impl Into<std::string::String>) -> Self {
            self.eni_ip = Some(input.into());
            self
        }
        /// <p>The IP address of the HSM's elastic network interface (ENI).</p>
        pub fn set_eni_ip(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.eni_ip = input;
            self
        }
        /// <p>The HSM's identifier (ID).</p>
        pub fn hsm_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.hsm_id = Some(input.into());
            self
        }
        /// <p>The HSM's identifier (ID).</p>
        pub fn set_hsm_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.hsm_id = input;
            self
        }
        /// <p>The HSM's state.</p>
        pub fn state(mut self, input: crate::model::HsmState) -> Self {
            self.state = Some(input);
            self
        }
        /// <p>The HSM's state.</p>
        pub fn set_state(mut self, input: std::option::Option<crate::model::HsmState>) -> Self {
            self.state = input;
            self
        }
        /// <p>A description of the HSM's state.</p>
        pub fn state_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.state_message = Some(input.into());
            self
        }
        /// <p>A description of the HSM's state.</p>
        pub fn set_state_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.state_message = input;
            self
        }
        /// Consumes the builder and constructs a [`Hsm`](crate::model::Hsm)
        pub fn build(self) -> crate::model::Hsm {
            crate::model::Hsm {
                availability_zone: self.availability_zone,
                cluster_id: self.cluster_id,
                subnet_id: self.subnet_id,
                eni_id: self.eni_id,
                eni_ip: self.eni_ip,
                hsm_id: self.hsm_id,
                state: self.state,
                state_message: self.state_message,
            }
        }
    }
}
impl Hsm {
    /// Creates a new builder-style object to manufacture [`Hsm`](crate::model::Hsm)
    pub fn builder() -> crate::model::hsm::Builder {
        crate::model::hsm::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum HsmState {
    #[allow(missing_docs)] // documentation missing in model
    Active,
    #[allow(missing_docs)] // documentation missing in model
    CreateInProgress,
    #[allow(missing_docs)] // documentation missing in model
    Degraded,
    #[allow(missing_docs)] // documentation missing in model
    Deleted,
    #[allow(missing_docs)] // documentation missing in model
    DeleteInProgress,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for HsmState {
    fn from(s: &str) -> Self {
        match s {
            "ACTIVE" => HsmState::Active,
            "CREATE_IN_PROGRESS" => HsmState::CreateInProgress,
            "DEGRADED" => HsmState::Degraded,
            "DELETED" => HsmState::Deleted,
            "DELETE_IN_PROGRESS" => HsmState::DeleteInProgress,
            other => HsmState::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for HsmState {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(HsmState::from(s))
    }
}
impl HsmState {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            HsmState::Active => "ACTIVE",
            HsmState::CreateInProgress => "CREATE_IN_PROGRESS",
            HsmState::Degraded => "DEGRADED",
            HsmState::Deleted => "DELETED",
            HsmState::DeleteInProgress => "DELETE_IN_PROGRESS",
            HsmState::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "ACTIVE",
            "CREATE_IN_PROGRESS",
            "DEGRADED",
            "DELETED",
            "DELETE_IN_PROGRESS",
        ]
    }
}
impl AsRef<str> for HsmState {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>A policy that defines the number of days to retain backups.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BackupRetentionPolicy {
    /// <p>The type of backup retention policy. For the <code>DAYS</code> type, the value is
    /// the number of days to retain backups.</p>
    pub r#type: std::option::Option<crate::model::BackupRetentionType>,
    /// <p>Use a value between 7 - 379.</p>
    pub value: std::option::Option<std::string::String>,
}
impl BackupRetentionPolicy {
    /// <p>The type of backup retention policy. For the <code>DAYS</code> type, the value is
    /// the number of days to retain backups.</p>
    pub fn r#type(&self) -> std::option::Option<&crate::model::BackupRetentionType> {
        self.r#type.as_ref()
    }
    /// <p>Use a value between 7 - 379.</p>
    pub fn value(&self) -> std::option::Option<&str> {
        self.value.as_deref()
    }
}
impl std::fmt::Debug for BackupRetentionPolicy {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BackupRetentionPolicy");
        formatter.field("r#type", &self.r#type);
        formatter.field("value", &self.value);
        formatter.finish()
    }
}
/// See [`BackupRetentionPolicy`](crate::model::BackupRetentionPolicy)
pub mod backup_retention_policy {
    /// A builder for [`BackupRetentionPolicy`](crate::model::BackupRetentionPolicy)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) r#type: std::option::Option<crate::model::BackupRetentionType>,
        pub(crate) value: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The type of backup retention policy. For the <code>DAYS</code> type, the value is
        /// the number of days to retain backups.</p>
        pub fn r#type(mut self, input: crate::model::BackupRetentionType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The type of backup retention policy. For the <code>DAYS</code> type, the value is
        /// the number of days to retain backups.</p>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::BackupRetentionType>,
        ) -> Self {
            self.r#type = input;
            self
        }
        /// <p>Use a value between 7 - 379.</p>
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            self.value = Some(input.into());
            self
        }
        /// <p>Use a value between 7 - 379.</p>
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.value = input;
            self
        }
        /// Consumes the builder and constructs a [`BackupRetentionPolicy`](crate::model::BackupRetentionPolicy)
        pub fn build(self) -> crate::model::BackupRetentionPolicy {
            crate::model::BackupRetentionPolicy {
                r#type: self.r#type,
                value: self.value,
            }
        }
    }
}
impl BackupRetentionPolicy {
    /// Creates a new builder-style object to manufacture [`BackupRetentionPolicy`](crate::model::BackupRetentionPolicy)
    pub fn builder() -> crate::model::backup_retention_policy::Builder {
        crate::model::backup_retention_policy::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum BackupRetentionType {
    #[allow(missing_docs)] // documentation missing in model
    Days,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for BackupRetentionType {
    fn from(s: &str) -> Self {
        match s {
            "DAYS" => BackupRetentionType::Days,
            other => BackupRetentionType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for BackupRetentionType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(BackupRetentionType::from(s))
    }
}
impl BackupRetentionType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            BackupRetentionType::Days => "DAYS",
            BackupRetentionType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["DAYS"]
    }
}
impl AsRef<str> for BackupRetentionType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum BackupPolicy {
    #[allow(missing_docs)] // documentation missing in model
    Default,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for BackupPolicy {
    fn from(s: &str) -> Self {
        match s {
            "DEFAULT" => BackupPolicy::Default,
            other => BackupPolicy::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for BackupPolicy {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(BackupPolicy::from(s))
    }
}
impl BackupPolicy {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            BackupPolicy::Default => "DEFAULT",
            BackupPolicy::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["DEFAULT"]
    }
}
impl AsRef<str> for BackupPolicy {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Contains information about the backup that will be copied and created by the <a>CopyBackupToRegion</a> operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DestinationBackup {
    /// <p>The date and time when both the source backup was created.</p>
    pub create_timestamp: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The AWS region that contains the source backup from which the new backup was copied.</p>
    pub source_region: std::option::Option<std::string::String>,
    /// <p>The identifier (ID) of the source backup from which the new backup was copied.</p>
    pub source_backup: std::option::Option<std::string::String>,
    /// <p>The identifier (ID) of the cluster containing the source backup from which the new backup was copied.</p>
    pub source_cluster: std::option::Option<std::string::String>,
}
impl DestinationBackup {
    /// <p>The date and time when both the source backup was created.</p>
    pub fn create_timestamp(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.create_timestamp.as_ref()
    }
    /// <p>The AWS region that contains the source backup from which the new backup was copied.</p>
    pub fn source_region(&self) -> std::option::Option<&str> {
        self.source_region.as_deref()
    }
    /// <p>The identifier (ID) of the source backup from which the new backup was copied.</p>
    pub fn source_backup(&self) -> std::option::Option<&str> {
        self.source_backup.as_deref()
    }
    /// <p>The identifier (ID) of the cluster containing the source backup from which the new backup was copied.</p>
    pub fn source_cluster(&self) -> std::option::Option<&str> {
        self.source_cluster.as_deref()
    }
}
impl std::fmt::Debug for DestinationBackup {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DestinationBackup");
        formatter.field("create_timestamp", &self.create_timestamp);
        formatter.field("source_region", &self.source_region);
        formatter.field("source_backup", &self.source_backup);
        formatter.field("source_cluster", &self.source_cluster);
        formatter.finish()
    }
}
/// See [`DestinationBackup`](crate::model::DestinationBackup)
pub mod destination_backup {
    /// A builder for [`DestinationBackup`](crate::model::DestinationBackup)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) create_timestamp: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) source_region: std::option::Option<std::string::String>,
        pub(crate) source_backup: std::option::Option<std::string::String>,
        pub(crate) source_cluster: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The date and time when both the source backup was created.</p>
        pub fn create_timestamp(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.create_timestamp = Some(input);
            self
        }
        /// <p>The date and time when both the source backup was created.</p>
        pub fn set_create_timestamp(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.create_timestamp = input;
            self
        }
        /// <p>The AWS region that contains the source backup from which the new backup was copied.</p>
        pub fn source_region(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_region = Some(input.into());
            self
        }
        /// <p>The AWS region that contains the source backup from which the new backup was copied.</p>
        pub fn set_source_region(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.source_region = input;
            self
        }
        /// <p>The identifier (ID) of the source backup from which the new backup was copied.</p>
        pub fn source_backup(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_backup = Some(input.into());
            self
        }
        /// <p>The identifier (ID) of the source backup from which the new backup was copied.</p>
        pub fn set_source_backup(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.source_backup = input;
            self
        }
        /// <p>The identifier (ID) of the cluster containing the source backup from which the new backup was copied.</p>
        pub fn source_cluster(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_cluster = Some(input.into());
            self
        }
        /// <p>The identifier (ID) of the cluster containing the source backup from which the new backup was copied.</p>
        pub fn set_source_cluster(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.source_cluster = input;
            self
        }
        /// Consumes the builder and constructs a [`DestinationBackup`](crate::model::DestinationBackup)
        pub fn build(self) -> crate::model::DestinationBackup {
            crate::model::DestinationBackup {
                create_timestamp: self.create_timestamp,
                source_region: self.source_region,
                source_backup: self.source_backup,
                source_cluster: self.source_cluster,
            }
        }
    }
}
impl DestinationBackup {
    /// Creates a new builder-style object to manufacture [`DestinationBackup`](crate::model::DestinationBackup)
    pub fn builder() -> crate::model::destination_backup::Builder {
        crate::model::destination_backup::Builder::default()
    }
}
