// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle<
    C = aws_smithy_client::erase::DynConnector,
    M = aws_hyper::AwsMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    client: aws_smithy_client::Client<C, M, R>,
    conf: crate::Config,
}

/// An ergonomic service client for `BaldrApiService`.
///
/// This client allows ergonomic access to a `BaldrApiService`-shaped service.
/// Each method corresponds to an endpoint defined in the service's Smithy model,
/// and the request and response shapes are auto-generated from that same model.
///
/// # Using a Client
///
/// Once you have a client set up, you can access the service's endpoints
/// by calling the appropriate method on [`Client`]. Each such method
/// returns a request builder for that endpoint, with methods for setting
/// the various fields of the request. Once your request is complete, use
/// the `send` method to send the request. `send` returns a future, which
/// you then have to `.await` to get the service's response.
///
/// [builder pattern]: https://rust-lang.github.io/api-guidelines/type-safety.html#c-builder
/// [SigV4-signed requests]: https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html
#[derive(std::fmt::Debug)]
pub struct Client<
    C = aws_smithy_client::erase::DynConnector,
    M = aws_hyper::AwsMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    handle: std::sync::Arc<Handle<C, M, R>>,
}

impl<C, M, R> std::clone::Clone for Client<C, M, R> {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl<C, M, R> From<aws_smithy_client::Client<C, M, R>> for Client<C, M, R> {
    fn from(client: aws_smithy_client::Client<C, M, R>) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl<C, M, R> Client<C, M, R> {
    /// Creates a client with the given service configuration.
    pub fn with_config(client: aws_smithy_client::Client<C, M, R>, conf: crate::Config) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl<C, M, R> Client<C, M, R>
where
    C: aws_smithy_client::bounds::SmithyConnector,
    M: aws_smithy_client::bounds::SmithyMiddleware<C>,
    R: aws_smithy_client::retry::NewRequestPolicy,
{
    /// Constructs a fluent builder for the `CopyBackupToRegion` operation.
    ///
    /// See [`CopyBackupToRegion`](crate::client::fluent_builders::CopyBackupToRegion) for more information about the
    /// operation and its arguments.
    pub fn copy_backup_to_region(&self) -> fluent_builders::CopyBackupToRegion<C, M, R> {
        fluent_builders::CopyBackupToRegion::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateCluster` operation.
    ///
    /// See [`CreateCluster`](crate::client::fluent_builders::CreateCluster) for more information about the
    /// operation and its arguments.
    pub fn create_cluster(&self) -> fluent_builders::CreateCluster<C, M, R> {
        fluent_builders::CreateCluster::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateHsm` operation.
    ///
    /// See [`CreateHsm`](crate::client::fluent_builders::CreateHsm) for more information about the
    /// operation and its arguments.
    pub fn create_hsm(&self) -> fluent_builders::CreateHsm<C, M, R> {
        fluent_builders::CreateHsm::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteBackup` operation.
    ///
    /// See [`DeleteBackup`](crate::client::fluent_builders::DeleteBackup) for more information about the
    /// operation and its arguments.
    pub fn delete_backup(&self) -> fluent_builders::DeleteBackup<C, M, R> {
        fluent_builders::DeleteBackup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteCluster` operation.
    ///
    /// See [`DeleteCluster`](crate::client::fluent_builders::DeleteCluster) for more information about the
    /// operation and its arguments.
    pub fn delete_cluster(&self) -> fluent_builders::DeleteCluster<C, M, R> {
        fluent_builders::DeleteCluster::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteHsm` operation.
    ///
    /// See [`DeleteHsm`](crate::client::fluent_builders::DeleteHsm) for more information about the
    /// operation and its arguments.
    pub fn delete_hsm(&self) -> fluent_builders::DeleteHsm<C, M, R> {
        fluent_builders::DeleteHsm::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeBackups` operation.
    ///
    /// See [`DescribeBackups`](crate::client::fluent_builders::DescribeBackups) for more information about the
    /// operation and its arguments.
    pub fn describe_backups(&self) -> fluent_builders::DescribeBackups<C, M, R> {
        fluent_builders::DescribeBackups::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeClusters` operation.
    ///
    /// See [`DescribeClusters`](crate::client::fluent_builders::DescribeClusters) for more information about the
    /// operation and its arguments.
    pub fn describe_clusters(&self) -> fluent_builders::DescribeClusters<C, M, R> {
        fluent_builders::DescribeClusters::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `InitializeCluster` operation.
    ///
    /// See [`InitializeCluster`](crate::client::fluent_builders::InitializeCluster) for more information about the
    /// operation and its arguments.
    pub fn initialize_cluster(&self) -> fluent_builders::InitializeCluster<C, M, R> {
        fluent_builders::InitializeCluster::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListTags` operation.
    ///
    /// See [`ListTags`](crate::client::fluent_builders::ListTags) for more information about the
    /// operation and its arguments.
    pub fn list_tags(&self) -> fluent_builders::ListTags<C, M, R> {
        fluent_builders::ListTags::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ModifyBackupAttributes` operation.
    ///
    /// See [`ModifyBackupAttributes`](crate::client::fluent_builders::ModifyBackupAttributes) for more information about the
    /// operation and its arguments.
    pub fn modify_backup_attributes(&self) -> fluent_builders::ModifyBackupAttributes<C, M, R> {
        fluent_builders::ModifyBackupAttributes::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ModifyCluster` operation.
    ///
    /// See [`ModifyCluster`](crate::client::fluent_builders::ModifyCluster) for more information about the
    /// operation and its arguments.
    pub fn modify_cluster(&self) -> fluent_builders::ModifyCluster<C, M, R> {
        fluent_builders::ModifyCluster::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `RestoreBackup` operation.
    ///
    /// See [`RestoreBackup`](crate::client::fluent_builders::RestoreBackup) for more information about the
    /// operation and its arguments.
    pub fn restore_backup(&self) -> fluent_builders::RestoreBackup<C, M, R> {
        fluent_builders::RestoreBackup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `TagResource` operation.
    ///
    /// See [`TagResource`](crate::client::fluent_builders::TagResource) for more information about the
    /// operation and its arguments.
    pub fn tag_resource(&self) -> fluent_builders::TagResource<C, M, R> {
        fluent_builders::TagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UntagResource` operation.
    ///
    /// See [`UntagResource`](crate::client::fluent_builders::UntagResource) for more information about the
    /// operation and its arguments.
    pub fn untag_resource(&self) -> fluent_builders::UntagResource<C, M, R> {
        fluent_builders::UntagResource::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `CopyBackupToRegion`.
    ///
    /// <p>Copy an AWS CloudHSM cluster backup to a different region.</p>
    #[derive(std::fmt::Debug)]
    pub struct CopyBackupToRegion<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::copy_backup_to_region_input::Builder,
    }
    impl<C, M, R> CopyBackupToRegion<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CopyBackupToRegion`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CopyBackupToRegionOutput,
            aws_smithy_http::result::SdkError<crate::error::CopyBackupToRegionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CopyBackupToRegionInputOperationOutputAlias,
                crate::output::CopyBackupToRegionOutput,
                crate::error::CopyBackupToRegionError,
                crate::input::CopyBackupToRegionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The AWS region that will contain your copied CloudHSM cluster backup.</p>
        pub fn destination_region(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.destination_region(inp);
            self
        }
        /// <p>The AWS region that will contain your copied CloudHSM cluster backup.</p>
        pub fn set_destination_region(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_destination_region(input);
            self
        }
        /// <p>The ID of the backup that will be copied to the destination region. </p>
        pub fn backup_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.backup_id(inp);
            self
        }
        /// <p>The ID of the backup that will be copied to the destination region. </p>
        pub fn set_backup_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_backup_id(input);
            self
        }
        /// Appends an item to `TagList`.
        ///
        /// To override the contents of this collection use [`set_tag_list`](Self::set_tag_list).
        ///
        /// <p>Tags to apply to the destination backup during creation. If you specify tags, only these tags will be applied to the destination backup. If you do not specify tags, the service copies tags from the source backup to the destination backup.</p>
        pub fn tag_list(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tag_list(inp);
            self
        }
        /// <p>Tags to apply to the destination backup during creation. If you specify tags, only these tags will be applied to the destination backup. If you do not specify tags, the service copies tags from the source backup to the destination backup.</p>
        pub fn set_tag_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tag_list(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateCluster`.
    ///
    /// <p>Creates a new AWS CloudHSM cluster.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateCluster<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_cluster_input::Builder,
    }
    impl<C, M, R> CreateCluster<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateCluster`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateClusterOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateClusterError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateClusterInputOperationOutputAlias,
                crate::output::CreateClusterOutput,
                crate::error::CreateClusterError,
                crate::input::CreateClusterInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>A policy that defines how the service retains backups.</p>
        pub fn backup_retention_policy(mut self, inp: crate::model::BackupRetentionPolicy) -> Self {
            self.inner = self.inner.backup_retention_policy(inp);
            self
        }
        /// <p>A policy that defines how the service retains backups.</p>
        pub fn set_backup_retention_policy(
            mut self,
            input: std::option::Option<crate::model::BackupRetentionPolicy>,
        ) -> Self {
            self.inner = self.inner.set_backup_retention_policy(input);
            self
        }
        /// <p>The type of HSM to use in the cluster. Currently the only allowed value is
        /// <code>hsm1.medium</code>.</p>
        pub fn hsm_type(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.hsm_type(inp);
            self
        }
        /// <p>The type of HSM to use in the cluster. Currently the only allowed value is
        /// <code>hsm1.medium</code>.</p>
        pub fn set_hsm_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_hsm_type(input);
            self
        }
        /// <p>The identifier (ID) of the cluster backup to restore. Use this value to restore the
        /// cluster from a backup instead of creating a new cluster. To find the backup ID, use <a>DescribeBackups</a>.</p>
        pub fn source_backup_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.source_backup_id(inp);
            self
        }
        /// <p>The identifier (ID) of the cluster backup to restore. Use this value to restore the
        /// cluster from a backup instead of creating a new cluster. To find the backup ID, use <a>DescribeBackups</a>.</p>
        pub fn set_source_backup_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_source_backup_id(input);
            self
        }
        /// Appends an item to `SubnetIds`.
        ///
        /// To override the contents of this collection use [`set_subnet_ids`](Self::set_subnet_ids).
        ///
        /// <p>The identifiers (IDs) of the subnets where you are creating the cluster. You must
        /// specify at least one subnet. If you specify multiple subnets, they must meet the following
        /// criteria:</p>
        /// <ul>
        /// <li>
        /// <p>All subnets must be in the same virtual private cloud (VPC).</p>
        /// </li>
        /// <li>
        /// <p>You can specify only one subnet per Availability Zone.</p>
        /// </li>
        /// </ul>
        pub fn subnet_ids(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.subnet_ids(inp);
            self
        }
        /// <p>The identifiers (IDs) of the subnets where you are creating the cluster. You must
        /// specify at least one subnet. If you specify multiple subnets, they must meet the following
        /// criteria:</p>
        /// <ul>
        /// <li>
        /// <p>All subnets must be in the same virtual private cloud (VPC).</p>
        /// </li>
        /// <li>
        /// <p>You can specify only one subnet per Availability Zone.</p>
        /// </li>
        /// </ul>
        pub fn set_subnet_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_subnet_ids(input);
            self
        }
        /// Appends an item to `TagList`.
        ///
        /// To override the contents of this collection use [`set_tag_list`](Self::set_tag_list).
        ///
        /// <p>Tags to apply to the CloudHSM cluster during creation.</p>
        pub fn tag_list(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tag_list(inp);
            self
        }
        /// <p>Tags to apply to the CloudHSM cluster during creation.</p>
        pub fn set_tag_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tag_list(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateHsm`.
    ///
    /// <p>Creates a new hardware security module (HSM) in the specified AWS CloudHSM
    /// cluster.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateHsm<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_hsm_input::Builder,
    }
    impl<C, M, R> CreateHsm<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateHsm`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateHsmOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateHsmError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateHsmInputOperationOutputAlias,
                crate::output::CreateHsmOutput,
                crate::error::CreateHsmError,
                crate::input::CreateHsmInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier (ID) of the HSM's cluster. To find the cluster ID, use <a>DescribeClusters</a>.</p>
        pub fn cluster_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cluster_id(inp);
            self
        }
        /// <p>The identifier (ID) of the HSM's cluster. To find the cluster ID, use <a>DescribeClusters</a>.</p>
        pub fn set_cluster_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_cluster_id(input);
            self
        }
        /// <p>The Availability Zone where you are creating the HSM. To find the cluster's
        /// Availability Zones, use <a>DescribeClusters</a>.</p>
        pub fn availability_zone(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.availability_zone(inp);
            self
        }
        /// <p>The Availability Zone where you are creating the HSM. To find the cluster's
        /// Availability Zones, use <a>DescribeClusters</a>.</p>
        pub fn set_availability_zone(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_availability_zone(input);
            self
        }
        /// <p>The HSM's IP address. If you specify an IP address, use an available address from the
        /// subnet that maps to the Availability Zone where you are creating the HSM. If you don't specify
        /// an IP address, one is chosen for you from that subnet.</p>
        pub fn ip_address(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.ip_address(inp);
            self
        }
        /// <p>The HSM's IP address. If you specify an IP address, use an available address from the
        /// subnet that maps to the Availability Zone where you are creating the HSM. If you don't specify
        /// an IP address, one is chosen for you from that subnet.</p>
        pub fn set_ip_address(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_ip_address(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteBackup`.
    ///
    /// <p>Deletes a specified AWS CloudHSM backup. A backup can be restored up to 7 days
    /// after the DeleteBackup request is made. For more information on restoring a backup, see
    /// <a>RestoreBackup</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteBackup<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_backup_input::Builder,
    }
    impl<C, M, R> DeleteBackup<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteBackup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteBackupOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteBackupError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteBackupInputOperationOutputAlias,
                crate::output::DeleteBackupOutput,
                crate::error::DeleteBackupError,
                crate::input::DeleteBackupInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the backup to be deleted. To find the ID of a backup, use the <a>DescribeBackups</a> operation.</p>
        pub fn backup_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.backup_id(inp);
            self
        }
        /// <p>The ID of the backup to be deleted. To find the ID of a backup, use the <a>DescribeBackups</a> operation.</p>
        pub fn set_backup_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_backup_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteCluster`.
    ///
    /// <p>Deletes the specified AWS CloudHSM cluster. Before you can delete a cluster, you must
    /// delete all HSMs in the cluster. To see if the cluster contains any HSMs, use <a>DescribeClusters</a>. To delete an HSM, use <a>DeleteHsm</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteCluster<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_cluster_input::Builder,
    }
    impl<C, M, R> DeleteCluster<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteCluster`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteClusterOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteClusterError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteClusterInputOperationOutputAlias,
                crate::output::DeleteClusterOutput,
                crate::error::DeleteClusterError,
                crate::input::DeleteClusterInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier (ID) of the cluster that you are deleting. To find the cluster ID, use
        /// <a>DescribeClusters</a>.</p>
        pub fn cluster_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cluster_id(inp);
            self
        }
        /// <p>The identifier (ID) of the cluster that you are deleting. To find the cluster ID, use
        /// <a>DescribeClusters</a>.</p>
        pub fn set_cluster_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_cluster_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteHsm`.
    ///
    /// <p>Deletes the specified HSM. To specify an HSM, you can use its identifier (ID), the IP
    /// address of the HSM's elastic network interface (ENI), or the ID of the HSM's ENI. You need to
    /// specify only one of these values. To find these values, use <a>DescribeClusters</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteHsm<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_hsm_input::Builder,
    }
    impl<C, M, R> DeleteHsm<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteHsm`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteHsmOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteHsmError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteHsmInputOperationOutputAlias,
                crate::output::DeleteHsmOutput,
                crate::error::DeleteHsmError,
                crate::input::DeleteHsmInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier (ID) of the cluster that contains the HSM that you are
        /// deleting.</p>
        pub fn cluster_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cluster_id(inp);
            self
        }
        /// <p>The identifier (ID) of the cluster that contains the HSM that you are
        /// deleting.</p>
        pub fn set_cluster_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_cluster_id(input);
            self
        }
        /// <p>The identifier (ID) of the HSM that you are deleting.</p>
        pub fn hsm_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.hsm_id(inp);
            self
        }
        /// <p>The identifier (ID) of the HSM that you are deleting.</p>
        pub fn set_hsm_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_hsm_id(input);
            self
        }
        /// <p>The identifier (ID) of the elastic network interface (ENI) of the HSM that you are
        /// deleting.</p>
        pub fn eni_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.eni_id(inp);
            self
        }
        /// <p>The identifier (ID) of the elastic network interface (ENI) of the HSM that you are
        /// deleting.</p>
        pub fn set_eni_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_eni_id(input);
            self
        }
        /// <p>The IP address of the elastic network interface (ENI) of the HSM that you are
        /// deleting.</p>
        pub fn eni_ip(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.eni_ip(inp);
            self
        }
        /// <p>The IP address of the elastic network interface (ENI) of the HSM that you are
        /// deleting.</p>
        pub fn set_eni_ip(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_eni_ip(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeBackups`.
    ///
    /// <p>Gets information about backups of AWS CloudHSM clusters.</p>
    /// <p>This is a paginated operation, which means that each response might contain only a
    /// subset of all the backups. When the response contains only a subset of backups, it includes a
    /// <code>NextToken</code> value. Use this value in a subsequent <code>DescribeBackups</code>
    /// request to get more backups. When you receive a response with no <code>NextToken</code> (or an
    /// empty or null value), that means there are no more backups to get.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeBackups<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_backups_input::Builder,
    }
    impl<C, M, R> DescribeBackups<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeBackups`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeBackupsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeBackupsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeBackupsInputOperationOutputAlias,
                crate::output::DescribeBackupsOutput,
                crate::error::DescribeBackupsError,
                crate::input::DescribeBackupsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The <code>NextToken</code> value that you received in the previous response. Use this
        /// value to get more backups.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The <code>NextToken</code> value that you received in the previous response. Use this
        /// value to get more backups.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of backups to return in the response. When there are more backups
        /// than the number you specify, the response contains a <code>NextToken</code> value.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of backups to return in the response. When there are more backups
        /// than the number you specify, the response contains a <code>NextToken</code> value.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// Adds a key-value pair to `Filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>One or more filters to limit the items returned in the response.</p>
        /// <p>Use the <code>backupIds</code> filter to return only the specified backups. Specify
        /// backups by their backup identifier (ID).</p>
        /// <p>Use the <code>sourceBackupIds</code> filter to return only the backups created from a
        /// source backup. The <code>sourceBackupID</code> of a source backup is returned by the <a>CopyBackupToRegion</a> operation.</p>
        /// <p>Use the <code>clusterIds</code> filter to return only the backups for the specified
        /// clusters. Specify clusters by their cluster identifier (ID).</p>
        /// <p>Use the <code>states</code> filter to return only backups that match the specified
        /// state.</p>
        /// <p>Use the <code>neverExpires</code> filter to return backups filtered by the value in the
        /// <code>neverExpires</code> parameter. <code>True</code> returns all backups exempt from the
        /// backup retention policy. <code>False</code> returns all backups with a backup retention policy
        /// defined at the cluster.</p>
        pub fn filters(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.filters(k, v);
            self
        }
        /// <p>One or more filters to limit the items returned in the response.</p>
        /// <p>Use the <code>backupIds</code> filter to return only the specified backups. Specify
        /// backups by their backup identifier (ID).</p>
        /// <p>Use the <code>sourceBackupIds</code> filter to return only the backups created from a
        /// source backup. The <code>sourceBackupID</code> of a source backup is returned by the <a>CopyBackupToRegion</a> operation.</p>
        /// <p>Use the <code>clusterIds</code> filter to return only the backups for the specified
        /// clusters. Specify clusters by their cluster identifier (ID).</p>
        /// <p>Use the <code>states</code> filter to return only backups that match the specified
        /// state.</p>
        /// <p>Use the <code>neverExpires</code> filter to return backups filtered by the value in the
        /// <code>neverExpires</code> parameter. <code>True</code> returns all backups exempt from the
        /// backup retention policy. <code>False</code> returns all backups with a backup retention policy
        /// defined at the cluster.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::vec::Vec<std::string::String>>,
            >,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p>Designates whether or not to sort the return backups by ascending chronological order
        /// of generation.</p>
        pub fn sort_ascending(mut self, inp: bool) -> Self {
            self.inner = self.inner.sort_ascending(inp);
            self
        }
        /// <p>Designates whether or not to sort the return backups by ascending chronological order
        /// of generation.</p>
        pub fn set_sort_ascending(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_sort_ascending(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeClusters`.
    ///
    /// <p>Gets information about AWS CloudHSM clusters.</p>
    /// <p>This is a paginated operation, which means that each response might contain only a
    /// subset of all the clusters. When the response contains only a subset of clusters, it includes
    /// a <code>NextToken</code> value. Use this value in a subsequent <code>DescribeClusters</code>
    /// request to get more clusters. When you receive a response with no <code>NextToken</code> (or
    /// an empty or null value), that means there are no more clusters to get.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeClusters<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_clusters_input::Builder,
    }
    impl<C, M, R> DescribeClusters<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeClusters`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeClustersOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeClustersError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeClustersInputOperationOutputAlias,
                crate::output::DescribeClustersOutput,
                crate::error::DescribeClustersError,
                crate::input::DescribeClustersInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// Adds a key-value pair to `Filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>One or more filters to limit the items returned in the response.</p>
        /// <p>Use the <code>clusterIds</code> filter to return only the specified clusters. Specify
        /// clusters by their cluster identifier (ID).</p>
        /// <p>Use the <code>vpcIds</code> filter to return only the clusters in the specified virtual
        /// private clouds (VPCs). Specify VPCs by their VPC identifier (ID).</p>
        /// <p>Use the <code>states</code> filter to return only clusters that match the specified
        /// state.</p>
        pub fn filters(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.filters(k, v);
            self
        }
        /// <p>One or more filters to limit the items returned in the response.</p>
        /// <p>Use the <code>clusterIds</code> filter to return only the specified clusters. Specify
        /// clusters by their cluster identifier (ID).</p>
        /// <p>Use the <code>vpcIds</code> filter to return only the clusters in the specified virtual
        /// private clouds (VPCs). Specify VPCs by their VPC identifier (ID).</p>
        /// <p>Use the <code>states</code> filter to return only clusters that match the specified
        /// state.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::vec::Vec<std::string::String>>,
            >,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p>The <code>NextToken</code> value that you received in the previous response. Use this
        /// value to get more clusters.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The <code>NextToken</code> value that you received in the previous response. Use this
        /// value to get more clusters.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of clusters to return in the response. When there are more clusters
        /// than the number you specify, the response contains a <code>NextToken</code> value.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of clusters to return in the response. When there are more clusters
        /// than the number you specify, the response contains a <code>NextToken</code> value.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `InitializeCluster`.
    ///
    /// <p>Claims an AWS CloudHSM cluster by submitting the cluster certificate issued by your
    /// issuing certificate authority (CA) and the CA's root certificate. Before you can claim a
    /// cluster, you must sign the cluster's certificate signing request (CSR) with your issuing CA.
    /// To get the cluster's CSR, use <a>DescribeClusters</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct InitializeCluster<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::initialize_cluster_input::Builder,
    }
    impl<C, M, R> InitializeCluster<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `InitializeCluster`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::InitializeClusterOutput,
            aws_smithy_http::result::SdkError<crate::error::InitializeClusterError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::InitializeClusterInputOperationOutputAlias,
                crate::output::InitializeClusterOutput,
                crate::error::InitializeClusterError,
                crate::input::InitializeClusterInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier (ID) of the cluster that you are claiming. To find the cluster ID, use
        /// <a>DescribeClusters</a>.</p>
        pub fn cluster_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cluster_id(inp);
            self
        }
        /// <p>The identifier (ID) of the cluster that you are claiming. To find the cluster ID, use
        /// <a>DescribeClusters</a>.</p>
        pub fn set_cluster_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_cluster_id(input);
            self
        }
        /// <p>The cluster certificate issued (signed) by your issuing certificate authority (CA). The
        /// certificate must be in PEM format and can contain a maximum of 5000 characters.</p>
        pub fn signed_cert(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.signed_cert(inp);
            self
        }
        /// <p>The cluster certificate issued (signed) by your issuing certificate authority (CA). The
        /// certificate must be in PEM format and can contain a maximum of 5000 characters.</p>
        pub fn set_signed_cert(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_signed_cert(input);
            self
        }
        /// <p>The issuing certificate of the issuing certificate authority (CA) that issued (signed)
        /// the cluster certificate. You must use a self-signed certificate. The certificate used to sign the HSM CSR must be directly available, and thus must be the
        /// root certificate. The certificate must be in PEM format and can contain a
        /// maximum of 5000 characters.</p>
        pub fn trust_anchor(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.trust_anchor(inp);
            self
        }
        /// <p>The issuing certificate of the issuing certificate authority (CA) that issued (signed)
        /// the cluster certificate. You must use a self-signed certificate. The certificate used to sign the HSM CSR must be directly available, and thus must be the
        /// root certificate. The certificate must be in PEM format and can contain a
        /// maximum of 5000 characters.</p>
        pub fn set_trust_anchor(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_trust_anchor(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTags`.
    ///
    /// <p>Gets a list of tags for the specified AWS CloudHSM cluster.</p>
    /// <p>This is a paginated operation, which means that each response might contain only a
    /// subset of all the tags. When the response contains only a subset of tags, it includes a
    /// <code>NextToken</code> value. Use this value in a subsequent <code>ListTags</code> request to
    /// get more tags. When you receive a response with no <code>NextToken</code> (or an empty or null
    /// value), that means there are no more tags to get.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListTags<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_tags_input::Builder,
    }
    impl<C, M, R> ListTags<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListTags`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTagsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTagsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListTagsInputOperationOutputAlias,
                crate::output::ListTagsOutput,
                crate::error::ListTagsError,
                crate::input::ListTagsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The cluster identifier (ID) for the cluster whose tags you are getting. To find the
        /// cluster ID, use <a>DescribeClusters</a>.</p>
        pub fn resource_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_id(inp);
            self
        }
        /// <p>The cluster identifier (ID) for the cluster whose tags you are getting. To find the
        /// cluster ID, use <a>DescribeClusters</a>.</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_id(input);
            self
        }
        /// <p>The <code>NextToken</code> value that you received in the previous response. Use this
        /// value to get more tags.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The <code>NextToken</code> value that you received in the previous response. Use this
        /// value to get more tags.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of tags to return in the response. When there are more tags than the
        /// number you specify, the response contains a <code>NextToken</code> value.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of tags to return in the response. When there are more tags than the
        /// number you specify, the response contains a <code>NextToken</code> value.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ModifyBackupAttributes`.
    ///
    /// <p>Modifies attributes for AWS CloudHSM backup.</p>
    #[derive(std::fmt::Debug)]
    pub struct ModifyBackupAttributes<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::modify_backup_attributes_input::Builder,
    }
    impl<C, M, R> ModifyBackupAttributes<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ModifyBackupAttributes`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ModifyBackupAttributesOutput,
            aws_smithy_http::result::SdkError<crate::error::ModifyBackupAttributesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ModifyBackupAttributesInputOperationOutputAlias,
                crate::output::ModifyBackupAttributesOutput,
                crate::error::ModifyBackupAttributesError,
                crate::input::ModifyBackupAttributesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier (ID) of the backup to modify. To find the ID of a backup, use the <a>DescribeBackups</a> operation.</p>
        pub fn backup_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.backup_id(inp);
            self
        }
        /// <p>The identifier (ID) of the backup to modify. To find the ID of a backup, use the <a>DescribeBackups</a> operation.</p>
        pub fn set_backup_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_backup_id(input);
            self
        }
        /// <p>Specifies whether the service should exempt a backup from the retention policy for the cluster. <code>True</code> exempts
        /// a backup from the retention policy. <code>False</code> means the service applies the backup retention policy defined at the cluster.</p>
        pub fn never_expires(mut self, inp: bool) -> Self {
            self.inner = self.inner.never_expires(inp);
            self
        }
        /// <p>Specifies whether the service should exempt a backup from the retention policy for the cluster. <code>True</code> exempts
        /// a backup from the retention policy. <code>False</code> means the service applies the backup retention policy defined at the cluster.</p>
        pub fn set_never_expires(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_never_expires(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ModifyCluster`.
    ///
    /// <p>Modifies AWS CloudHSM cluster.</p>
    #[derive(std::fmt::Debug)]
    pub struct ModifyCluster<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::modify_cluster_input::Builder,
    }
    impl<C, M, R> ModifyCluster<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ModifyCluster`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ModifyClusterOutput,
            aws_smithy_http::result::SdkError<crate::error::ModifyClusterError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ModifyClusterInputOperationOutputAlias,
                crate::output::ModifyClusterOutput,
                crate::error::ModifyClusterError,
                crate::input::ModifyClusterInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>A policy that defines how the service retains backups.</p>
        pub fn backup_retention_policy(mut self, inp: crate::model::BackupRetentionPolicy) -> Self {
            self.inner = self.inner.backup_retention_policy(inp);
            self
        }
        /// <p>A policy that defines how the service retains backups.</p>
        pub fn set_backup_retention_policy(
            mut self,
            input: std::option::Option<crate::model::BackupRetentionPolicy>,
        ) -> Self {
            self.inner = self.inner.set_backup_retention_policy(input);
            self
        }
        /// <p>The identifier (ID) of the cluster that you want to modify. To find the cluster ID, use
        /// <a>DescribeClusters</a>.</p>
        pub fn cluster_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cluster_id(inp);
            self
        }
        /// <p>The identifier (ID) of the cluster that you want to modify. To find the cluster ID, use
        /// <a>DescribeClusters</a>.</p>
        pub fn set_cluster_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_cluster_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RestoreBackup`.
    ///
    /// <p>Restores a specified AWS CloudHSM backup that is in the
    /// <code>PENDING_DELETION</code> state. For mor information on deleting a backup, see
    /// <a>DeleteBackup</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct RestoreBackup<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::restore_backup_input::Builder,
    }
    impl<C, M, R> RestoreBackup<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `RestoreBackup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RestoreBackupOutput,
            aws_smithy_http::result::SdkError<crate::error::RestoreBackupError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::RestoreBackupInputOperationOutputAlias,
                crate::output::RestoreBackupOutput,
                crate::error::RestoreBackupError,
                crate::input::RestoreBackupInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the backup to be restored. To find the ID of a backup, use the <a>DescribeBackups</a> operation.</p>
        pub fn backup_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.backup_id(inp);
            self
        }
        /// <p>The ID of the backup to be restored. To find the ID of a backup, use the <a>DescribeBackups</a> operation.</p>
        pub fn set_backup_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_backup_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TagResource`.
    ///
    /// <p>Adds or overwrites one or more tags for the specified AWS CloudHSM cluster.</p>
    #[derive(std::fmt::Debug)]
    pub struct TagResource<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::tag_resource_input::Builder,
    }
    impl<C, M, R> TagResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `TagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::TagResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::TagResourceInputOperationOutputAlias,
                crate::output::TagResourceOutput,
                crate::error::TagResourceError,
                crate::input::TagResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The cluster identifier (ID) for the cluster that you are tagging. To find the cluster
        /// ID, use <a>DescribeClusters</a>.</p>
        pub fn resource_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_id(inp);
            self
        }
        /// <p>The cluster identifier (ID) for the cluster that you are tagging. To find the cluster
        /// ID, use <a>DescribeClusters</a>.</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_id(input);
            self
        }
        /// Appends an item to `TagList`.
        ///
        /// To override the contents of this collection use [`set_tag_list`](Self::set_tag_list).
        ///
        /// <p>A list of one or more tags.</p>
        pub fn tag_list(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tag_list(inp);
            self
        }
        /// <p>A list of one or more tags.</p>
        pub fn set_tag_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tag_list(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UntagResource`.
    ///
    /// <p>Removes the specified tag or tags from the specified AWS CloudHSM cluster.</p>
    #[derive(std::fmt::Debug)]
    pub struct UntagResource<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::untag_resource_input::Builder,
    }
    impl<C, M, R> UntagResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UntagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UntagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::UntagResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UntagResourceInputOperationOutputAlias,
                crate::output::UntagResourceOutput,
                crate::error::UntagResourceError,
                crate::input::UntagResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The cluster identifier (ID) for the cluster whose tags you are removing. To find the
        /// cluster ID, use <a>DescribeClusters</a>.</p>
        pub fn resource_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_id(inp);
            self
        }
        /// <p>The cluster identifier (ID) for the cluster whose tags you are removing. To find the
        /// cluster ID, use <a>DescribeClusters</a>.</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_id(input);
            self
        }
        /// Appends an item to `TagKeyList`.
        ///
        /// To override the contents of this collection use [`set_tag_key_list`](Self::set_tag_key_list).
        ///
        /// <p>A list of one or more tag keys for the tags that you are removing. Specify only the tag
        /// keys, not the tag values.</p>
        pub fn tag_key_list(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_key_list(inp);
            self
        }
        /// <p>A list of one or more tag keys for the tags that you are removing. Specify only the tag
        /// keys, not the tag values.</p>
        pub fn set_tag_key_list(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_key_list(input);
            self
        }
    }
}
impl<C> Client<C, aws_hyper::AwsMiddleware, aws_smithy_client::retry::Standard> {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn(conf: crate::Config, conn: C) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let client = aws_hyper::Client::new(conn).with_retry_config(retry_config.into());
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
impl
    Client<
        aws_smithy_client::erase::DynConnector,
        aws_hyper::AwsMiddleware,
        aws_smithy_client::retry::Standard,
    >
{
    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(config: &aws_types::config::Config) -> Self {
        Self::from_conf(config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let client = aws_hyper::Client::https().with_retry_config(retry_config.into());
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
