// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle {
    pub(crate) client: aws_smithy_client::Client<
        aws_smithy_client::erase::DynConnector,
        aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
    >,
    pub(crate) conf: crate::Config,
}

/// Client for Amazon CloudHSM
///
/// Client for invoking operations on Amazon CloudHSM. Each operation on Amazon CloudHSM is a method on this
/// this struct. `.send()` MUST be invoked on the generated operations to dispatch the request to the service.
///
/// # Examples
/// **Constructing a client and invoking an operation**
/// ```rust,no_run
/// # async fn docs() {
///     // create a shared configuration. This can be used & shared between multiple service clients.
///     let shared_config = aws_config::load_from_env().await;
///     let client = aws_sdk_cloudhsm::Client::new(&shared_config);
///     // invoke an operation
///     /* let rsp = client
///         .<operation_name>().
///         .<param>("some value")
///         .send().await; */
/// # }
/// ```
/// **Constructing a client with custom configuration**
/// ```rust,no_run
/// use aws_config::RetryConfig;
/// # async fn docs() {
///     let shared_config = aws_config::load_from_env().await;
///     let config = aws_sdk_cloudhsm::config::Builder::from(&shared_config)
///         .retry_config(RetryConfig::disabled())
///         .build();
///     let client = aws_sdk_cloudhsm::Client::from_conf(config);
/// # }
#[derive(std::fmt::Debug)]
pub struct Client {
    handle: std::sync::Arc<Handle>,
}

impl std::clone::Clone for Client {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl
    From<
        aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
    > for Client
{
    fn from(
        client: aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
    ) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl Client {
    /// Creates a client with the given service configuration.
    pub fn with_config(
        client: aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
        conf: crate::Config,
    ) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl Client {
    /// Constructs a fluent builder for the [`AddTagsToResource`](crate::client::fluent_builders::AddTagsToResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::AddTagsToResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::AddTagsToResource::set_resource_arn): <p>The Amazon Resource Name (ARN) of the AWS CloudHSM resource to tag.</p>
    ///   - [`tag_list(Vec<Tag>)`](crate::client::fluent_builders::AddTagsToResource::tag_list) / [`set_tag_list(Option<Vec<Tag>>)`](crate::client::fluent_builders::AddTagsToResource::set_tag_list): <p>One or more tags.</p>
    /// - On success, responds with [`AddTagsToResourceOutput`](crate::output::AddTagsToResourceOutput) with field(s):
    ///   - [`status(Option<String>)`](crate::output::AddTagsToResourceOutput::status): <p>The status of the operation.</p>
    /// - On failure, responds with [`SdkError<AddTagsToResourceError>`](crate::error::AddTagsToResourceError)
    pub fn add_tags_to_resource(&self) -> fluent_builders::AddTagsToResource {
        fluent_builders::AddTagsToResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateHapg`](crate::client::fluent_builders::CreateHapg) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`label(impl Into<String>)`](crate::client::fluent_builders::CreateHapg::label) / [`set_label(Option<String>)`](crate::client::fluent_builders::CreateHapg::set_label): <p>The label of the new high-availability partition group.</p>
    /// - On success, responds with [`CreateHapgOutput`](crate::output::CreateHapgOutput) with field(s):
    ///   - [`hapg_arn(Option<String>)`](crate::output::CreateHapgOutput::hapg_arn): <p>The ARN of the high-availability partition group.</p>
    /// - On failure, responds with [`SdkError<CreateHapgError>`](crate::error::CreateHapgError)
    pub fn create_hapg(&self) -> fluent_builders::CreateHapg {
        fluent_builders::CreateHapg::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateHsm`](crate::client::fluent_builders::CreateHsm) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`subnet_id(impl Into<String>)`](crate::client::fluent_builders::CreateHsm::subnet_id) / [`set_subnet_id(Option<String>)`](crate::client::fluent_builders::CreateHsm::set_subnet_id): <p>The identifier of the subnet in your VPC in which to place the HSM.</p>
    ///   - [`ssh_key(impl Into<String>)`](crate::client::fluent_builders::CreateHsm::ssh_key) / [`set_ssh_key(Option<String>)`](crate::client::fluent_builders::CreateHsm::set_ssh_key): <p>The SSH public key to install on the HSM.</p>
    ///   - [`eni_ip(impl Into<String>)`](crate::client::fluent_builders::CreateHsm::eni_ip) / [`set_eni_ip(Option<String>)`](crate::client::fluent_builders::CreateHsm::set_eni_ip): <p>The IP address to assign to the HSM's ENI.</p>  <p>If an IP address is not specified, an IP address will be randomly chosen from the CIDR range of the subnet.</p>
    ///   - [`iam_role_arn(impl Into<String>)`](crate::client::fluent_builders::CreateHsm::iam_role_arn) / [`set_iam_role_arn(Option<String>)`](crate::client::fluent_builders::CreateHsm::set_iam_role_arn): <p>The ARN of an IAM role to enable the AWS CloudHSM service to allocate an ENI on your behalf.</p>
    ///   - [`external_id(impl Into<String>)`](crate::client::fluent_builders::CreateHsm::external_id) / [`set_external_id(Option<String>)`](crate::client::fluent_builders::CreateHsm::set_external_id): <p>The external ID from <code>IamRoleArn</code>, if present.</p>
    ///   - [`subscription_type(SubscriptionType)`](crate::client::fluent_builders::CreateHsm::subscription_type) / [`set_subscription_type(Option<SubscriptionType>)`](crate::client::fluent_builders::CreateHsm::set_subscription_type): <p>Specifies the type of subscription for the HSM.</p>  <ul>   <li> <p> <b>PRODUCTION</b> - The HSM is being used in a production environment.</p> </li>   <li> <p> <b>TRIAL</b> - The HSM is being used in a product trial.</p> </li>  </ul>
    ///   - [`client_token(impl Into<String>)`](crate::client::fluent_builders::CreateHsm::client_token) / [`set_client_token(Option<String>)`](crate::client::fluent_builders::CreateHsm::set_client_token): <p>A user-defined token to ensure idempotence. Subsequent calls to this operation with the same token will be ignored.</p>
    ///   - [`syslog_ip(impl Into<String>)`](crate::client::fluent_builders::CreateHsm::syslog_ip) / [`set_syslog_ip(Option<String>)`](crate::client::fluent_builders::CreateHsm::set_syslog_ip): <p>The IP address for the syslog monitoring server. The AWS CloudHSM service only supports one syslog monitoring server.</p>
    /// - On success, responds with [`CreateHsmOutput`](crate::output::CreateHsmOutput) with field(s):
    ///   - [`hsm_arn(Option<String>)`](crate::output::CreateHsmOutput::hsm_arn): <p>The ARN of the HSM.</p>
    /// - On failure, responds with [`SdkError<CreateHsmError>`](crate::error::CreateHsmError)
    pub fn create_hsm(&self) -> fluent_builders::CreateHsm {
        fluent_builders::CreateHsm::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateLunaClient`](crate::client::fluent_builders::CreateLunaClient) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`label(impl Into<String>)`](crate::client::fluent_builders::CreateLunaClient::label) / [`set_label(Option<String>)`](crate::client::fluent_builders::CreateLunaClient::set_label): <p>The label for the client.</p>
    ///   - [`certificate(impl Into<String>)`](crate::client::fluent_builders::CreateLunaClient::certificate) / [`set_certificate(Option<String>)`](crate::client::fluent_builders::CreateLunaClient::set_certificate): <p>The contents of a Base64-Encoded X.509 v3 certificate to be installed on the HSMs used by this client.</p>
    /// - On success, responds with [`CreateLunaClientOutput`](crate::output::CreateLunaClientOutput) with field(s):
    ///   - [`client_arn(Option<String>)`](crate::output::CreateLunaClientOutput::client_arn): <p>The ARN of the client.</p>
    /// - On failure, responds with [`SdkError<CreateLunaClientError>`](crate::error::CreateLunaClientError)
    pub fn create_luna_client(&self) -> fluent_builders::CreateLunaClient {
        fluent_builders::CreateLunaClient::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteHapg`](crate::client::fluent_builders::DeleteHapg) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`hapg_arn(impl Into<String>)`](crate::client::fluent_builders::DeleteHapg::hapg_arn) / [`set_hapg_arn(Option<String>)`](crate::client::fluent_builders::DeleteHapg::set_hapg_arn): <p>The ARN of the high-availability partition group to delete.</p>
    /// - On success, responds with [`DeleteHapgOutput`](crate::output::DeleteHapgOutput) with field(s):
    ///   - [`status(Option<String>)`](crate::output::DeleteHapgOutput::status): <p>The status of the action.</p>
    /// - On failure, responds with [`SdkError<DeleteHapgError>`](crate::error::DeleteHapgError)
    pub fn delete_hapg(&self) -> fluent_builders::DeleteHapg {
        fluent_builders::DeleteHapg::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteHsm`](crate::client::fluent_builders::DeleteHsm) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`hsm_arn(impl Into<String>)`](crate::client::fluent_builders::DeleteHsm::hsm_arn) / [`set_hsm_arn(Option<String>)`](crate::client::fluent_builders::DeleteHsm::set_hsm_arn): <p>The ARN of the HSM to delete.</p>
    /// - On success, responds with [`DeleteHsmOutput`](crate::output::DeleteHsmOutput) with field(s):
    ///   - [`status(Option<String>)`](crate::output::DeleteHsmOutput::status): <p>The status of the operation.</p>
    /// - On failure, responds with [`SdkError<DeleteHsmError>`](crate::error::DeleteHsmError)
    pub fn delete_hsm(&self) -> fluent_builders::DeleteHsm {
        fluent_builders::DeleteHsm::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteLunaClient`](crate::client::fluent_builders::DeleteLunaClient) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`client_arn(impl Into<String>)`](crate::client::fluent_builders::DeleteLunaClient::client_arn) / [`set_client_arn(Option<String>)`](crate::client::fluent_builders::DeleteLunaClient::set_client_arn): <p>The ARN of the client to delete.</p>
    /// - On success, responds with [`DeleteLunaClientOutput`](crate::output::DeleteLunaClientOutput) with field(s):
    ///   - [`status(Option<String>)`](crate::output::DeleteLunaClientOutput::status): <p>The status of the action.</p>
    /// - On failure, responds with [`SdkError<DeleteLunaClientError>`](crate::error::DeleteLunaClientError)
    pub fn delete_luna_client(&self) -> fluent_builders::DeleteLunaClient {
        fluent_builders::DeleteLunaClient::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeHapg`](crate::client::fluent_builders::DescribeHapg) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`hapg_arn(impl Into<String>)`](crate::client::fluent_builders::DescribeHapg::hapg_arn) / [`set_hapg_arn(Option<String>)`](crate::client::fluent_builders::DescribeHapg::set_hapg_arn): <p>The ARN of the high-availability partition group to describe.</p>
    /// - On success, responds with [`DescribeHapgOutput`](crate::output::DescribeHapgOutput) with field(s):
    ///   - [`hapg_arn(Option<String>)`](crate::output::DescribeHapgOutput::hapg_arn): <p>The ARN of the high-availability partition group.</p>
    ///   - [`hapg_serial(Option<String>)`](crate::output::DescribeHapgOutput::hapg_serial): <p>The serial number of the high-availability partition group.</p>
    ///   - [`hsms_last_action_failed(Option<Vec<String>>)`](crate::output::DescribeHapgOutput::hsms_last_action_failed): <p></p>
    ///   - [`hsms_pending_deletion(Option<Vec<String>>)`](crate::output::DescribeHapgOutput::hsms_pending_deletion): <p></p>
    ///   - [`hsms_pending_registration(Option<Vec<String>>)`](crate::output::DescribeHapgOutput::hsms_pending_registration): <p></p>
    ///   - [`label(Option<String>)`](crate::output::DescribeHapgOutput::label): <p>The label for the high-availability partition group.</p>
    ///   - [`last_modified_timestamp(Option<String>)`](crate::output::DescribeHapgOutput::last_modified_timestamp): <p>The date and time the high-availability partition group was last modified.</p>
    ///   - [`partition_serial_list(Option<Vec<String>>)`](crate::output::DescribeHapgOutput::partition_serial_list): <p>The list of partition serial numbers that belong to the high-availability partition group.</p>
    ///   - [`state(Option<CloudHsmObjectState>)`](crate::output::DescribeHapgOutput::state): <p>The state of the high-availability partition group.</p>
    /// - On failure, responds with [`SdkError<DescribeHapgError>`](crate::error::DescribeHapgError)
    pub fn describe_hapg(&self) -> fluent_builders::DescribeHapg {
        fluent_builders::DescribeHapg::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeHsm`](crate::client::fluent_builders::DescribeHsm) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`hsm_arn(impl Into<String>)`](crate::client::fluent_builders::DescribeHsm::hsm_arn) / [`set_hsm_arn(Option<String>)`](crate::client::fluent_builders::DescribeHsm::set_hsm_arn): <p>The ARN of the HSM. Either the <code>HsmArn</code> or the <code>SerialNumber</code> parameter must be specified.</p>
    ///   - [`hsm_serial_number(impl Into<String>)`](crate::client::fluent_builders::DescribeHsm::hsm_serial_number) / [`set_hsm_serial_number(Option<String>)`](crate::client::fluent_builders::DescribeHsm::set_hsm_serial_number): <p>The serial number of the HSM. Either the <code>HsmArn</code> or the <code>HsmSerialNumber</code> parameter must be specified.</p>
    /// - On success, responds with [`DescribeHsmOutput`](crate::output::DescribeHsmOutput) with field(s):
    ///   - [`hsm_arn(Option<String>)`](crate::output::DescribeHsmOutput::hsm_arn): <p>The ARN of the HSM.</p>
    ///   - [`status(Option<HsmStatus>)`](crate::output::DescribeHsmOutput::status): <p>The status of the HSM.</p>
    ///   - [`status_details(Option<String>)`](crate::output::DescribeHsmOutput::status_details): <p>Contains additional information about the status of the HSM.</p>
    ///   - [`availability_zone(Option<String>)`](crate::output::DescribeHsmOutput::availability_zone): <p>The Availability Zone that the HSM is in.</p>
    ///   - [`eni_id(Option<String>)`](crate::output::DescribeHsmOutput::eni_id): <p>The identifier of the elastic network interface (ENI) attached to the HSM.</p>
    ///   - [`eni_ip(Option<String>)`](crate::output::DescribeHsmOutput::eni_ip): <p>The IP address assigned to the HSM's ENI.</p>
    ///   - [`subscription_type(Option<SubscriptionType>)`](crate::output::DescribeHsmOutput::subscription_type): <p>Specifies the type of subscription for the HSM.</p>  <ul>   <li> <p> <b>PRODUCTION</b> - The HSM is being used in a production environment.</p> </li>   <li> <p> <b>TRIAL</b> - The HSM is being used in a product trial.</p> </li>  </ul>
    ///   - [`subscription_start_date(Option<String>)`](crate::output::DescribeHsmOutput::subscription_start_date): <p>The subscription start date.</p>
    ///   - [`subscription_end_date(Option<String>)`](crate::output::DescribeHsmOutput::subscription_end_date): <p>The subscription end date.</p>
    ///   - [`vpc_id(Option<String>)`](crate::output::DescribeHsmOutput::vpc_id): <p>The identifier of the VPC that the HSM is in.</p>
    ///   - [`subnet_id(Option<String>)`](crate::output::DescribeHsmOutput::subnet_id): <p>The identifier of the subnet that the HSM is in.</p>
    ///   - [`iam_role_arn(Option<String>)`](crate::output::DescribeHsmOutput::iam_role_arn): <p>The ARN of the IAM role assigned to the HSM.</p>
    ///   - [`serial_number(Option<String>)`](crate::output::DescribeHsmOutput::serial_number): <p>The serial number of the HSM.</p>
    ///   - [`vendor_name(Option<String>)`](crate::output::DescribeHsmOutput::vendor_name): <p>The name of the HSM vendor.</p>
    ///   - [`hsm_type(Option<String>)`](crate::output::DescribeHsmOutput::hsm_type): <p>The HSM model type.</p>
    ///   - [`software_version(Option<String>)`](crate::output::DescribeHsmOutput::software_version): <p>The HSM software version.</p>
    ///   - [`ssh_public_key(Option<String>)`](crate::output::DescribeHsmOutput::ssh_public_key): <p>The public SSH key.</p>
    ///   - [`ssh_key_last_updated(Option<String>)`](crate::output::DescribeHsmOutput::ssh_key_last_updated): <p>The date and time that the SSH key was last updated.</p>
    ///   - [`server_cert_uri(Option<String>)`](crate::output::DescribeHsmOutput::server_cert_uri): <p>The URI of the certificate server.</p>
    ///   - [`server_cert_last_updated(Option<String>)`](crate::output::DescribeHsmOutput::server_cert_last_updated): <p>The date and time that the server certificate was last updated.</p>
    ///   - [`partitions(Option<Vec<String>>)`](crate::output::DescribeHsmOutput::partitions): <p>The list of partitions on the HSM.</p>
    /// - On failure, responds with [`SdkError<DescribeHsmError>`](crate::error::DescribeHsmError)
    pub fn describe_hsm(&self) -> fluent_builders::DescribeHsm {
        fluent_builders::DescribeHsm::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeLunaClient`](crate::client::fluent_builders::DescribeLunaClient) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`client_arn(impl Into<String>)`](crate::client::fluent_builders::DescribeLunaClient::client_arn) / [`set_client_arn(Option<String>)`](crate::client::fluent_builders::DescribeLunaClient::set_client_arn): <p>The ARN of the client.</p>
    ///   - [`certificate_fingerprint(impl Into<String>)`](crate::client::fluent_builders::DescribeLunaClient::certificate_fingerprint) / [`set_certificate_fingerprint(Option<String>)`](crate::client::fluent_builders::DescribeLunaClient::set_certificate_fingerprint): <p>The certificate fingerprint.</p>
    /// - On success, responds with [`DescribeLunaClientOutput`](crate::output::DescribeLunaClientOutput) with field(s):
    ///   - [`client_arn(Option<String>)`](crate::output::DescribeLunaClientOutput::client_arn): <p>The ARN of the client.</p>
    ///   - [`certificate(Option<String>)`](crate::output::DescribeLunaClientOutput::certificate): <p>The certificate installed on the HSMs used by this client.</p>
    ///   - [`certificate_fingerprint(Option<String>)`](crate::output::DescribeLunaClientOutput::certificate_fingerprint): <p>The certificate fingerprint.</p>
    ///   - [`last_modified_timestamp(Option<String>)`](crate::output::DescribeLunaClientOutput::last_modified_timestamp): <p>The date and time the client was last modified.</p>
    ///   - [`label(Option<String>)`](crate::output::DescribeLunaClientOutput::label): <p>The label of the client.</p>
    /// - On failure, responds with [`SdkError<DescribeLunaClientError>`](crate::error::DescribeLunaClientError)
    pub fn describe_luna_client(&self) -> fluent_builders::DescribeLunaClient {
        fluent_builders::DescribeLunaClient::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetConfig`](crate::client::fluent_builders::GetConfig) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`client_arn(impl Into<String>)`](crate::client::fluent_builders::GetConfig::client_arn) / [`set_client_arn(Option<String>)`](crate::client::fluent_builders::GetConfig::set_client_arn): <p>The ARN of the client.</p>
    ///   - [`client_version(ClientVersion)`](crate::client::fluent_builders::GetConfig::client_version) / [`set_client_version(Option<ClientVersion>)`](crate::client::fluent_builders::GetConfig::set_client_version): <p>The client version.</p>
    ///   - [`hapg_list(Vec<String>)`](crate::client::fluent_builders::GetConfig::hapg_list) / [`set_hapg_list(Option<Vec<String>>)`](crate::client::fluent_builders::GetConfig::set_hapg_list): <p>A list of ARNs that identify the high-availability partition groups that are associated with the client.</p>
    /// - On success, responds with [`GetConfigOutput`](crate::output::GetConfigOutput) with field(s):
    ///   - [`config_type(Option<String>)`](crate::output::GetConfigOutput::config_type): <p>The type of credentials.</p>
    ///   - [`config_file(Option<String>)`](crate::output::GetConfigOutput::config_file): <p>The chrystoki.conf configuration file.</p>
    ///   - [`config_cred(Option<String>)`](crate::output::GetConfigOutput::config_cred): <p>The certificate file containing the server.pem files of the HSMs.</p>
    /// - On failure, responds with [`SdkError<GetConfigError>`](crate::error::GetConfigError)
    pub fn get_config(&self) -> fluent_builders::GetConfig {
        fluent_builders::GetConfig::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListAvailableZones`](crate::client::fluent_builders::ListAvailableZones) operation.
    ///
    /// - The fluent builder takes no input, just [`send`](crate::client::fluent_builders::ListAvailableZones::send) it.

    /// - On success, responds with [`ListAvailableZonesOutput`](crate::output::ListAvailableZonesOutput) with field(s):
    ///   - [`az_list(Option<Vec<String>>)`](crate::output::ListAvailableZonesOutput::az_list): <p>The list of Availability Zones that have available AWS CloudHSM capacity.</p>
    /// - On failure, responds with [`SdkError<ListAvailableZonesError>`](crate::error::ListAvailableZonesError)
    pub fn list_available_zones(&self) -> fluent_builders::ListAvailableZones {
        fluent_builders::ListAvailableZones::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListHapgs`](crate::client::fluent_builders::ListHapgs) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListHapgs::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListHapgs::set_next_token): <p>The <code>NextToken</code> value from a previous call to <code>ListHapgs</code>. Pass null if this is the first call.</p>
    /// - On success, responds with [`ListHapgsOutput`](crate::output::ListHapgsOutput) with field(s):
    ///   - [`hapg_list(Option<Vec<String>>)`](crate::output::ListHapgsOutput::hapg_list): <p>The list of high-availability partition groups.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListHapgsOutput::next_token): <p>If not null, more results are available. Pass this value to <code>ListHapgs</code> to retrieve the next set of items.</p>
    /// - On failure, responds with [`SdkError<ListHapgsError>`](crate::error::ListHapgsError)
    pub fn list_hapgs(&self) -> fluent_builders::ListHapgs {
        fluent_builders::ListHapgs::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListHsms`](crate::client::fluent_builders::ListHsms) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListHsms::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListHsms::set_next_token): <p>The <code>NextToken</code> value from a previous call to <code>ListHsms</code>. Pass null if this is the first call.</p>
    /// - On success, responds with [`ListHsmsOutput`](crate::output::ListHsmsOutput) with field(s):
    ///   - [`hsm_list(Option<Vec<String>>)`](crate::output::ListHsmsOutput::hsm_list): <p>The list of ARNs that identify the HSMs.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListHsmsOutput::next_token): <p>If not null, more results are available. Pass this value to <code>ListHsms</code> to retrieve the next set of items.</p>
    /// - On failure, responds with [`SdkError<ListHsmsError>`](crate::error::ListHsmsError)
    pub fn list_hsms(&self) -> fluent_builders::ListHsms {
        fluent_builders::ListHsms::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListLunaClients`](crate::client::fluent_builders::ListLunaClients) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListLunaClients::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListLunaClients::set_next_token): <p>The <code>NextToken</code> value from a previous call to <code>ListLunaClients</code>. Pass null if this is the first call.</p>
    /// - On success, responds with [`ListLunaClientsOutput`](crate::output::ListLunaClientsOutput) with field(s):
    ///   - [`client_list(Option<Vec<String>>)`](crate::output::ListLunaClientsOutput::client_list): <p>The list of clients.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListLunaClientsOutput::next_token): <p>If not null, more results are available. Pass this to <code>ListLunaClients</code> to retrieve the next set of items.</p>
    /// - On failure, responds with [`SdkError<ListLunaClientsError>`](crate::error::ListLunaClientsError)
    pub fn list_luna_clients(&self) -> fluent_builders::ListLunaClients {
        fluent_builders::ListLunaClients::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListTagsForResource`](crate::client::fluent_builders::ListTagsForResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::ListTagsForResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::ListTagsForResource::set_resource_arn): <p>The Amazon Resource Name (ARN) of the AWS CloudHSM resource.</p>
    /// - On success, responds with [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput) with field(s):
    ///   - [`tag_list(Option<Vec<Tag>>)`](crate::output::ListTagsForResourceOutput::tag_list): <p>One or more tags.</p>
    /// - On failure, responds with [`SdkError<ListTagsForResourceError>`](crate::error::ListTagsForResourceError)
    pub fn list_tags_for_resource(&self) -> fluent_builders::ListTagsForResource {
        fluent_builders::ListTagsForResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ModifyHapg`](crate::client::fluent_builders::ModifyHapg) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`hapg_arn(impl Into<String>)`](crate::client::fluent_builders::ModifyHapg::hapg_arn) / [`set_hapg_arn(Option<String>)`](crate::client::fluent_builders::ModifyHapg::set_hapg_arn): <p>The ARN of the high-availability partition group to modify.</p>
    ///   - [`label(impl Into<String>)`](crate::client::fluent_builders::ModifyHapg::label) / [`set_label(Option<String>)`](crate::client::fluent_builders::ModifyHapg::set_label): <p>The new label for the high-availability partition group.</p>
    ///   - [`partition_serial_list(Vec<String>)`](crate::client::fluent_builders::ModifyHapg::partition_serial_list) / [`set_partition_serial_list(Option<Vec<String>>)`](crate::client::fluent_builders::ModifyHapg::set_partition_serial_list): <p>The list of partition serial numbers to make members of the high-availability partition group.</p>
    /// - On success, responds with [`ModifyHapgOutput`](crate::output::ModifyHapgOutput) with field(s):
    ///   - [`hapg_arn(Option<String>)`](crate::output::ModifyHapgOutput::hapg_arn): <p>The ARN of the high-availability partition group.</p>
    /// - On failure, responds with [`SdkError<ModifyHapgError>`](crate::error::ModifyHapgError)
    pub fn modify_hapg(&self) -> fluent_builders::ModifyHapg {
        fluent_builders::ModifyHapg::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ModifyHsm`](crate::client::fluent_builders::ModifyHsm) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`hsm_arn(impl Into<String>)`](crate::client::fluent_builders::ModifyHsm::hsm_arn) / [`set_hsm_arn(Option<String>)`](crate::client::fluent_builders::ModifyHsm::set_hsm_arn): <p>The ARN of the HSM to modify.</p>
    ///   - [`subnet_id(impl Into<String>)`](crate::client::fluent_builders::ModifyHsm::subnet_id) / [`set_subnet_id(Option<String>)`](crate::client::fluent_builders::ModifyHsm::set_subnet_id): <p>The new identifier of the subnet that the HSM is in. The new subnet must be in the same Availability Zone as the current subnet.</p>
    ///   - [`eni_ip(impl Into<String>)`](crate::client::fluent_builders::ModifyHsm::eni_ip) / [`set_eni_ip(Option<String>)`](crate::client::fluent_builders::ModifyHsm::set_eni_ip): <p>The new IP address for the elastic network interface (ENI) attached to the HSM.</p>  <p>If the HSM is moved to a different subnet, and an IP address is not specified, an IP address will be randomly chosen from the CIDR range of the new subnet.</p>
    ///   - [`iam_role_arn(impl Into<String>)`](crate::client::fluent_builders::ModifyHsm::iam_role_arn) / [`set_iam_role_arn(Option<String>)`](crate::client::fluent_builders::ModifyHsm::set_iam_role_arn): <p>The new IAM role ARN.</p>
    ///   - [`external_id(impl Into<String>)`](crate::client::fluent_builders::ModifyHsm::external_id) / [`set_external_id(Option<String>)`](crate::client::fluent_builders::ModifyHsm::set_external_id): <p>The new external ID.</p>
    ///   - [`syslog_ip(impl Into<String>)`](crate::client::fluent_builders::ModifyHsm::syslog_ip) / [`set_syslog_ip(Option<String>)`](crate::client::fluent_builders::ModifyHsm::set_syslog_ip): <p>The new IP address for the syslog monitoring server. The AWS CloudHSM service only supports one syslog monitoring server.</p>
    /// - On success, responds with [`ModifyHsmOutput`](crate::output::ModifyHsmOutput) with field(s):
    ///   - [`hsm_arn(Option<String>)`](crate::output::ModifyHsmOutput::hsm_arn): <p>The ARN of the HSM.</p>
    /// - On failure, responds with [`SdkError<ModifyHsmError>`](crate::error::ModifyHsmError)
    pub fn modify_hsm(&self) -> fluent_builders::ModifyHsm {
        fluent_builders::ModifyHsm::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ModifyLunaClient`](crate::client::fluent_builders::ModifyLunaClient) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`client_arn(impl Into<String>)`](crate::client::fluent_builders::ModifyLunaClient::client_arn) / [`set_client_arn(Option<String>)`](crate::client::fluent_builders::ModifyLunaClient::set_client_arn): <p>The ARN of the client.</p>
    ///   - [`certificate(impl Into<String>)`](crate::client::fluent_builders::ModifyLunaClient::certificate) / [`set_certificate(Option<String>)`](crate::client::fluent_builders::ModifyLunaClient::set_certificate): <p>The new certificate for the client.</p>
    /// - On success, responds with [`ModifyLunaClientOutput`](crate::output::ModifyLunaClientOutput) with field(s):
    ///   - [`client_arn(Option<String>)`](crate::output::ModifyLunaClientOutput::client_arn): <p>The ARN of the client.</p>
    /// - On failure, responds with [`SdkError<ModifyLunaClientError>`](crate::error::ModifyLunaClientError)
    pub fn modify_luna_client(&self) -> fluent_builders::ModifyLunaClient {
        fluent_builders::ModifyLunaClient::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`RemoveTagsFromResource`](crate::client::fluent_builders::RemoveTagsFromResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::RemoveTagsFromResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::RemoveTagsFromResource::set_resource_arn): <p>The Amazon Resource Name (ARN) of the AWS CloudHSM resource.</p>
    ///   - [`tag_key_list(Vec<String>)`](crate::client::fluent_builders::RemoveTagsFromResource::tag_key_list) / [`set_tag_key_list(Option<Vec<String>>)`](crate::client::fluent_builders::RemoveTagsFromResource::set_tag_key_list): <p>The tag key or keys to remove.</p>  <p>Specify only the tag key to remove (not the value). To overwrite the value for an existing tag, use <code>AddTagsToResource</code>.</p>
    /// - On success, responds with [`RemoveTagsFromResourceOutput`](crate::output::RemoveTagsFromResourceOutput) with field(s):
    ///   - [`status(Option<String>)`](crate::output::RemoveTagsFromResourceOutput::status): <p>The status of the operation.</p>
    /// - On failure, responds with [`SdkError<RemoveTagsFromResourceError>`](crate::error::RemoveTagsFromResourceError)
    pub fn remove_tags_from_resource(&self) -> fluent_builders::RemoveTagsFromResource {
        fluent_builders::RemoveTagsFromResource::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `AddTagsToResource`.
    ///
    /// <p>This is documentation for <b>AWS CloudHSM Classic</b>. For more information, see <a href="http://aws.amazon.com/cloudhsm/faqs-classic/">AWS CloudHSM Classic FAQs</a>, the <a href="https://docs.aws.amazon.com/cloudhsm/classic/userguide/">AWS CloudHSM Classic User Guide</a>, and the <a href="https://docs.aws.amazon.com/cloudhsm/classic/APIReference/">AWS CloudHSM Classic API Reference</a>.</p>
    /// <p> <b>For information about the current version of AWS CloudHSM</b>, see <a href="http://aws.amazon.com/cloudhsm/">AWS CloudHSM</a>, the <a href="https://docs.aws.amazon.com/cloudhsm/latest/userguide/">AWS CloudHSM User Guide</a>, and the <a href="https://docs.aws.amazon.com/cloudhsm/latest/APIReference/">AWS CloudHSM API Reference</a>.</p>
    /// <p>Adds or overwrites one or more tags for the specified AWS CloudHSM resource.</p>
    /// <p>Each tag consists of a key and a value. Tag keys must be unique to each resource.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct AddTagsToResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::add_tags_to_resource_input::Builder,
    }
    impl AddTagsToResource {
        /// Creates a new `AddTagsToResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AddTagsToResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::AddTagsToResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the AWS CloudHSM resource to tag.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the AWS CloudHSM resource to tag.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `TagList`.
        ///
        /// To override the contents of this collection use [`set_tag_list`](Self::set_tag_list).
        ///
        /// <p>One or more tags.</p>
        pub fn tag_list(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tag_list(input);
            self
        }
        /// <p>One or more tags.</p>
        pub fn set_tag_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tag_list(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateHapg`.
    ///
    /// <p>This is documentation for <b>AWS CloudHSM Classic</b>. For more information, see <a href="http://aws.amazon.com/cloudhsm/faqs-classic/">AWS CloudHSM Classic FAQs</a>, the <a href="https://docs.aws.amazon.com/cloudhsm/classic/userguide/">AWS CloudHSM Classic User Guide</a>, and the <a href="https://docs.aws.amazon.com/cloudhsm/classic/APIReference/">AWS CloudHSM Classic API Reference</a>.</p>
    /// <p> <b>For information about the current version of AWS CloudHSM</b>, see <a href="http://aws.amazon.com/cloudhsm/">AWS CloudHSM</a>, the <a href="https://docs.aws.amazon.com/cloudhsm/latest/userguide/">AWS CloudHSM User Guide</a>, and the <a href="https://docs.aws.amazon.com/cloudhsm/latest/APIReference/">AWS CloudHSM API Reference</a>.</p>
    /// <p>Creates a high-availability partition group. A high-availability partition group is a group of partitions that spans multiple physical HSMs.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateHapg {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_hapg_input::Builder,
    }
    impl CreateHapg {
        /// Creates a new `CreateHapg`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateHapgOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateHapgError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The label of the new high-availability partition group.</p>
        pub fn label(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.label(input.into());
            self
        }
        /// <p>The label of the new high-availability partition group.</p>
        pub fn set_label(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_label(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateHsm`.
    ///
    /// <p>This is documentation for <b>AWS CloudHSM Classic</b>. For more information, see <a href="http://aws.amazon.com/cloudhsm/faqs-classic/">AWS CloudHSM Classic FAQs</a>, the <a href="https://docs.aws.amazon.com/cloudhsm/classic/userguide/">AWS CloudHSM Classic User Guide</a>, and the <a href="https://docs.aws.amazon.com/cloudhsm/classic/APIReference/">AWS CloudHSM Classic API Reference</a>.</p>
    /// <p> <b>For information about the current version of AWS CloudHSM</b>, see <a href="http://aws.amazon.com/cloudhsm/">AWS CloudHSM</a>, the <a href="https://docs.aws.amazon.com/cloudhsm/latest/userguide/">AWS CloudHSM User Guide</a>, and the <a href="https://docs.aws.amazon.com/cloudhsm/latest/APIReference/">AWS CloudHSM API Reference</a>.</p>
    /// <p>Creates an uninitialized HSM instance.</p>
    /// <p>There is an upfront fee charged for each HSM instance that you create with the <code>CreateHsm</code> operation. If you accidentally provision an HSM and want to request a refund, delete the instance using the <code>DeleteHsm</code> operation, go to the <a href="https://console.aws.amazon.com/support/home">AWS Support Center</a>, create a new case, and select <b>Account and Billing Support</b>.</p> <important>
    /// <p>It can take up to 20 minutes to create and provision an HSM. You can monitor the status of the HSM with the <code>DescribeHsm</code> operation. The HSM is ready to be initialized when the status changes to <code>RUNNING</code>.</p>
    /// </important>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateHsm {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_hsm_input::Builder,
    }
    impl CreateHsm {
        /// Creates a new `CreateHsm`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateHsmOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateHsmError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the subnet in your VPC in which to place the HSM.</p>
        pub fn subnet_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.subnet_id(input.into());
            self
        }
        /// <p>The identifier of the subnet in your VPC in which to place the HSM.</p>
        pub fn set_subnet_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_subnet_id(input);
            self
        }
        /// <p>The SSH public key to install on the HSM.</p>
        pub fn ssh_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.ssh_key(input.into());
            self
        }
        /// <p>The SSH public key to install on the HSM.</p>
        pub fn set_ssh_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_ssh_key(input);
            self
        }
        /// <p>The IP address to assign to the HSM's ENI.</p>
        /// <p>If an IP address is not specified, an IP address will be randomly chosen from the CIDR range of the subnet.</p>
        pub fn eni_ip(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.eni_ip(input.into());
            self
        }
        /// <p>The IP address to assign to the HSM's ENI.</p>
        /// <p>If an IP address is not specified, an IP address will be randomly chosen from the CIDR range of the subnet.</p>
        pub fn set_eni_ip(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_eni_ip(input);
            self
        }
        /// <p>The ARN of an IAM role to enable the AWS CloudHSM service to allocate an ENI on your behalf.</p>
        pub fn iam_role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.iam_role_arn(input.into());
            self
        }
        /// <p>The ARN of an IAM role to enable the AWS CloudHSM service to allocate an ENI on your behalf.</p>
        pub fn set_iam_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_iam_role_arn(input);
            self
        }
        /// <p>The external ID from <code>IamRoleArn</code>, if present.</p>
        pub fn external_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.external_id(input.into());
            self
        }
        /// <p>The external ID from <code>IamRoleArn</code>, if present.</p>
        pub fn set_external_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_external_id(input);
            self
        }
        /// <p>Specifies the type of subscription for the HSM.</p>
        /// <ul>
        /// <li> <p> <b>PRODUCTION</b> - The HSM is being used in a production environment.</p> </li>
        /// <li> <p> <b>TRIAL</b> - The HSM is being used in a product trial.</p> </li>
        /// </ul>
        pub fn subscription_type(mut self, input: crate::model::SubscriptionType) -> Self {
            self.inner = self.inner.subscription_type(input);
            self
        }
        /// <p>Specifies the type of subscription for the HSM.</p>
        /// <ul>
        /// <li> <p> <b>PRODUCTION</b> - The HSM is being used in a production environment.</p> </li>
        /// <li> <p> <b>TRIAL</b> - The HSM is being used in a product trial.</p> </li>
        /// </ul>
        pub fn set_subscription_type(
            mut self,
            input: std::option::Option<crate::model::SubscriptionType>,
        ) -> Self {
            self.inner = self.inner.set_subscription_type(input);
            self
        }
        /// <p>A user-defined token to ensure idempotence. Subsequent calls to this operation with the same token will be ignored.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(input.into());
            self
        }
        /// <p>A user-defined token to ensure idempotence. Subsequent calls to this operation with the same token will be ignored.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
        /// <p>The IP address for the syslog monitoring server. The AWS CloudHSM service only supports one syslog monitoring server.</p>
        pub fn syslog_ip(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.syslog_ip(input.into());
            self
        }
        /// <p>The IP address for the syslog monitoring server. The AWS CloudHSM service only supports one syslog monitoring server.</p>
        pub fn set_syslog_ip(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_syslog_ip(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateLunaClient`.
    ///
    /// <p>This is documentation for <b>AWS CloudHSM Classic</b>. For more information, see <a href="http://aws.amazon.com/cloudhsm/faqs-classic/">AWS CloudHSM Classic FAQs</a>, the <a href="https://docs.aws.amazon.com/cloudhsm/classic/userguide/">AWS CloudHSM Classic User Guide</a>, and the <a href="https://docs.aws.amazon.com/cloudhsm/classic/APIReference/">AWS CloudHSM Classic API Reference</a>.</p>
    /// <p> <b>For information about the current version of AWS CloudHSM</b>, see <a href="http://aws.amazon.com/cloudhsm/">AWS CloudHSM</a>, the <a href="https://docs.aws.amazon.com/cloudhsm/latest/userguide/">AWS CloudHSM User Guide</a>, and the <a href="https://docs.aws.amazon.com/cloudhsm/latest/APIReference/">AWS CloudHSM API Reference</a>.</p>
    /// <p>Creates an HSM client.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateLunaClient {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_luna_client_input::Builder,
    }
    impl CreateLunaClient {
        /// Creates a new `CreateLunaClient`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateLunaClientOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateLunaClientError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The label for the client.</p>
        pub fn label(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.label(input.into());
            self
        }
        /// <p>The label for the client.</p>
        pub fn set_label(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_label(input);
            self
        }
        /// <p>The contents of a Base64-Encoded X.509 v3 certificate to be installed on the HSMs used by this client.</p>
        pub fn certificate(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.certificate(input.into());
            self
        }
        /// <p>The contents of a Base64-Encoded X.509 v3 certificate to be installed on the HSMs used by this client.</p>
        pub fn set_certificate(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_certificate(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteHapg`.
    ///
    /// <p>This is documentation for <b>AWS CloudHSM Classic</b>. For more information, see <a href="http://aws.amazon.com/cloudhsm/faqs-classic/">AWS CloudHSM Classic FAQs</a>, the <a href="https://docs.aws.amazon.com/cloudhsm/classic/userguide/">AWS CloudHSM Classic User Guide</a>, and the <a href="https://docs.aws.amazon.com/cloudhsm/classic/APIReference/">AWS CloudHSM Classic API Reference</a>.</p>
    /// <p> <b>For information about the current version of AWS CloudHSM</b>, see <a href="http://aws.amazon.com/cloudhsm/">AWS CloudHSM</a>, the <a href="https://docs.aws.amazon.com/cloudhsm/latest/userguide/">AWS CloudHSM User Guide</a>, and the <a href="https://docs.aws.amazon.com/cloudhsm/latest/APIReference/">AWS CloudHSM API Reference</a>.</p>
    /// <p>Deletes a high-availability partition group.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteHapg {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_hapg_input::Builder,
    }
    impl DeleteHapg {
        /// Creates a new `DeleteHapg`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteHapgOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteHapgError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the high-availability partition group to delete.</p>
        pub fn hapg_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.hapg_arn(input.into());
            self
        }
        /// <p>The ARN of the high-availability partition group to delete.</p>
        pub fn set_hapg_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_hapg_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteHsm`.
    ///
    /// <p>This is documentation for <b>AWS CloudHSM Classic</b>. For more information, see <a href="http://aws.amazon.com/cloudhsm/faqs-classic/">AWS CloudHSM Classic FAQs</a>, the <a href="https://docs.aws.amazon.com/cloudhsm/classic/userguide/">AWS CloudHSM Classic User Guide</a>, and the <a href="https://docs.aws.amazon.com/cloudhsm/classic/APIReference/">AWS CloudHSM Classic API Reference</a>.</p>
    /// <p> <b>For information about the current version of AWS CloudHSM</b>, see <a href="http://aws.amazon.com/cloudhsm/">AWS CloudHSM</a>, the <a href="https://docs.aws.amazon.com/cloudhsm/latest/userguide/">AWS CloudHSM User Guide</a>, and the <a href="https://docs.aws.amazon.com/cloudhsm/latest/APIReference/">AWS CloudHSM API Reference</a>.</p>
    /// <p>Deletes an HSM. After completion, this operation cannot be undone and your key material cannot be recovered.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteHsm {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_hsm_input::Builder,
    }
    impl DeleteHsm {
        /// Creates a new `DeleteHsm`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteHsmOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteHsmError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the HSM to delete.</p>
        pub fn hsm_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.hsm_arn(input.into());
            self
        }
        /// <p>The ARN of the HSM to delete.</p>
        pub fn set_hsm_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_hsm_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteLunaClient`.
    ///
    /// <p>This is documentation for <b>AWS CloudHSM Classic</b>. For more information, see <a href="http://aws.amazon.com/cloudhsm/faqs-classic/">AWS CloudHSM Classic FAQs</a>, the <a href="https://docs.aws.amazon.com/cloudhsm/classic/userguide/">AWS CloudHSM Classic User Guide</a>, and the <a href="https://docs.aws.amazon.com/cloudhsm/classic/APIReference/">AWS CloudHSM Classic API Reference</a>.</p>
    /// <p> <b>For information about the current version of AWS CloudHSM</b>, see <a href="http://aws.amazon.com/cloudhsm/">AWS CloudHSM</a>, the <a href="https://docs.aws.amazon.com/cloudhsm/latest/userguide/">AWS CloudHSM User Guide</a>, and the <a href="https://docs.aws.amazon.com/cloudhsm/latest/APIReference/">AWS CloudHSM API Reference</a>.</p>
    /// <p>Deletes a client.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteLunaClient {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_luna_client_input::Builder,
    }
    impl DeleteLunaClient {
        /// Creates a new `DeleteLunaClient`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteLunaClientOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteLunaClientError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the client to delete.</p>
        pub fn client_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_arn(input.into());
            self
        }
        /// <p>The ARN of the client to delete.</p>
        pub fn set_client_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeHapg`.
    ///
    /// <p>This is documentation for <b>AWS CloudHSM Classic</b>. For more information, see <a href="http://aws.amazon.com/cloudhsm/faqs-classic/">AWS CloudHSM Classic FAQs</a>, the <a href="https://docs.aws.amazon.com/cloudhsm/classic/userguide/">AWS CloudHSM Classic User Guide</a>, and the <a href="https://docs.aws.amazon.com/cloudhsm/classic/APIReference/">AWS CloudHSM Classic API Reference</a>.</p>
    /// <p> <b>For information about the current version of AWS CloudHSM</b>, see <a href="http://aws.amazon.com/cloudhsm/">AWS CloudHSM</a>, the <a href="https://docs.aws.amazon.com/cloudhsm/latest/userguide/">AWS CloudHSM User Guide</a>, and the <a href="https://docs.aws.amazon.com/cloudhsm/latest/APIReference/">AWS CloudHSM API Reference</a>.</p>
    /// <p>Retrieves information about a high-availability partition group.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeHapg {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_hapg_input::Builder,
    }
    impl DescribeHapg {
        /// Creates a new `DescribeHapg`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeHapgOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeHapgError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the high-availability partition group to describe.</p>
        pub fn hapg_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.hapg_arn(input.into());
            self
        }
        /// <p>The ARN of the high-availability partition group to describe.</p>
        pub fn set_hapg_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_hapg_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeHsm`.
    ///
    /// <p>This is documentation for <b>AWS CloudHSM Classic</b>. For more information, see <a href="http://aws.amazon.com/cloudhsm/faqs-classic/">AWS CloudHSM Classic FAQs</a>, the <a href="https://docs.aws.amazon.com/cloudhsm/classic/userguide/">AWS CloudHSM Classic User Guide</a>, and the <a href="https://docs.aws.amazon.com/cloudhsm/classic/APIReference/">AWS CloudHSM Classic API Reference</a>.</p>
    /// <p> <b>For information about the current version of AWS CloudHSM</b>, see <a href="http://aws.amazon.com/cloudhsm/">AWS CloudHSM</a>, the <a href="https://docs.aws.amazon.com/cloudhsm/latest/userguide/">AWS CloudHSM User Guide</a>, and the <a href="https://docs.aws.amazon.com/cloudhsm/latest/APIReference/">AWS CloudHSM API Reference</a>.</p>
    /// <p>Retrieves information about an HSM. You can identify the HSM by its ARN or its serial number.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeHsm {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_hsm_input::Builder,
    }
    impl DescribeHsm {
        /// Creates a new `DescribeHsm`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeHsmOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeHsmError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the HSM. Either the <code>HsmArn</code> or the <code>SerialNumber</code> parameter must be specified.</p>
        pub fn hsm_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.hsm_arn(input.into());
            self
        }
        /// <p>The ARN of the HSM. Either the <code>HsmArn</code> or the <code>SerialNumber</code> parameter must be specified.</p>
        pub fn set_hsm_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_hsm_arn(input);
            self
        }
        /// <p>The serial number of the HSM. Either the <code>HsmArn</code> or the <code>HsmSerialNumber</code> parameter must be specified.</p>
        pub fn hsm_serial_number(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.hsm_serial_number(input.into());
            self
        }
        /// <p>The serial number of the HSM. Either the <code>HsmArn</code> or the <code>HsmSerialNumber</code> parameter must be specified.</p>
        pub fn set_hsm_serial_number(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_hsm_serial_number(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeLunaClient`.
    ///
    /// <p>This is documentation for <b>AWS CloudHSM Classic</b>. For more information, see <a href="http://aws.amazon.com/cloudhsm/faqs-classic/">AWS CloudHSM Classic FAQs</a>, the <a href="https://docs.aws.amazon.com/cloudhsm/classic/userguide/">AWS CloudHSM Classic User Guide</a>, and the <a href="https://docs.aws.amazon.com/cloudhsm/classic/APIReference/">AWS CloudHSM Classic API Reference</a>.</p>
    /// <p> <b>For information about the current version of AWS CloudHSM</b>, see <a href="http://aws.amazon.com/cloudhsm/">AWS CloudHSM</a>, the <a href="https://docs.aws.amazon.com/cloudhsm/latest/userguide/">AWS CloudHSM User Guide</a>, and the <a href="https://docs.aws.amazon.com/cloudhsm/latest/APIReference/">AWS CloudHSM API Reference</a>.</p>
    /// <p>Retrieves information about an HSM client.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeLunaClient {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_luna_client_input::Builder,
    }
    impl DescribeLunaClient {
        /// Creates a new `DescribeLunaClient`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeLunaClientOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeLunaClientError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the client.</p>
        pub fn client_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_arn(input.into());
            self
        }
        /// <p>The ARN of the client.</p>
        pub fn set_client_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_arn(input);
            self
        }
        /// <p>The certificate fingerprint.</p>
        pub fn certificate_fingerprint(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.certificate_fingerprint(input.into());
            self
        }
        /// <p>The certificate fingerprint.</p>
        pub fn set_certificate_fingerprint(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_certificate_fingerprint(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetConfig`.
    ///
    /// <p>This is documentation for <b>AWS CloudHSM Classic</b>. For more information, see <a href="http://aws.amazon.com/cloudhsm/faqs-classic/">AWS CloudHSM Classic FAQs</a>, the <a href="https://docs.aws.amazon.com/cloudhsm/classic/userguide/">AWS CloudHSM Classic User Guide</a>, and the <a href="https://docs.aws.amazon.com/cloudhsm/classic/APIReference/">AWS CloudHSM Classic API Reference</a>.</p>
    /// <p> <b>For information about the current version of AWS CloudHSM</b>, see <a href="http://aws.amazon.com/cloudhsm/">AWS CloudHSM</a>, the <a href="https://docs.aws.amazon.com/cloudhsm/latest/userguide/">AWS CloudHSM User Guide</a>, and the <a href="https://docs.aws.amazon.com/cloudhsm/latest/APIReference/">AWS CloudHSM API Reference</a>.</p>
    /// <p>Gets the configuration files necessary to connect to all high availability partition groups the client is associated with.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetConfig {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_config_input::Builder,
    }
    impl GetConfig {
        /// Creates a new `GetConfig`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetConfigOutput,
            aws_smithy_http::result::SdkError<crate::error::GetConfigError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the client.</p>
        pub fn client_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_arn(input.into());
            self
        }
        /// <p>The ARN of the client.</p>
        pub fn set_client_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_arn(input);
            self
        }
        /// <p>The client version.</p>
        pub fn client_version(mut self, input: crate::model::ClientVersion) -> Self {
            self.inner = self.inner.client_version(input);
            self
        }
        /// <p>The client version.</p>
        pub fn set_client_version(
            mut self,
            input: std::option::Option<crate::model::ClientVersion>,
        ) -> Self {
            self.inner = self.inner.set_client_version(input);
            self
        }
        /// Appends an item to `HapgList`.
        ///
        /// To override the contents of this collection use [`set_hapg_list`](Self::set_hapg_list).
        ///
        /// <p>A list of ARNs that identify the high-availability partition groups that are associated with the client.</p>
        pub fn hapg_list(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.hapg_list(input.into());
            self
        }
        /// <p>A list of ARNs that identify the high-availability partition groups that are associated with the client.</p>
        pub fn set_hapg_list(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_hapg_list(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListAvailableZones`.
    ///
    /// <p>This is documentation for <b>AWS CloudHSM Classic</b>. For more information, see <a href="http://aws.amazon.com/cloudhsm/faqs-classic/">AWS CloudHSM Classic FAQs</a>, the <a href="https://docs.aws.amazon.com/cloudhsm/classic/userguide/">AWS CloudHSM Classic User Guide</a>, and the <a href="https://docs.aws.amazon.com/cloudhsm/classic/APIReference/">AWS CloudHSM Classic API Reference</a>.</p>
    /// <p> <b>For information about the current version of AWS CloudHSM</b>, see <a href="http://aws.amazon.com/cloudhsm/">AWS CloudHSM</a>, the <a href="https://docs.aws.amazon.com/cloudhsm/latest/userguide/">AWS CloudHSM User Guide</a>, and the <a href="https://docs.aws.amazon.com/cloudhsm/latest/APIReference/">AWS CloudHSM API Reference</a>.</p>
    /// <p>Lists the Availability Zones that have available AWS CloudHSM capacity.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListAvailableZones {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_available_zones_input::Builder,
    }
    impl ListAvailableZones {
        /// Creates a new `ListAvailableZones`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListAvailableZonesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListAvailableZonesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
    }
    /// Fluent builder constructing a request to `ListHapgs`.
    ///
    /// <p>This is documentation for <b>AWS CloudHSM Classic</b>. For more information, see <a href="http://aws.amazon.com/cloudhsm/faqs-classic/">AWS CloudHSM Classic FAQs</a>, the <a href="https://docs.aws.amazon.com/cloudhsm/classic/userguide/">AWS CloudHSM Classic User Guide</a>, and the <a href="https://docs.aws.amazon.com/cloudhsm/classic/APIReference/">AWS CloudHSM Classic API Reference</a>.</p>
    /// <p> <b>For information about the current version of AWS CloudHSM</b>, see <a href="http://aws.amazon.com/cloudhsm/">AWS CloudHSM</a>, the <a href="https://docs.aws.amazon.com/cloudhsm/latest/userguide/">AWS CloudHSM User Guide</a>, and the <a href="https://docs.aws.amazon.com/cloudhsm/latest/APIReference/">AWS CloudHSM API Reference</a>.</p>
    /// <p>Lists the high-availability partition groups for the account.</p>
    /// <p>This operation supports pagination with the use of the <code>NextToken</code> member. If more results are available, the <code>NextToken</code> member of the response contains a token that you pass in the next call to <code>ListHapgs</code> to retrieve the next set of items.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListHapgs {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_hapgs_input::Builder,
    }
    impl ListHapgs {
        /// Creates a new `ListHapgs`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListHapgsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListHapgsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The <code>NextToken</code> value from a previous call to <code>ListHapgs</code>. Pass null if this is the first call.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The <code>NextToken</code> value from a previous call to <code>ListHapgs</code>. Pass null if this is the first call.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListHsms`.
    ///
    /// <p>This is documentation for <b>AWS CloudHSM Classic</b>. For more information, see <a href="http://aws.amazon.com/cloudhsm/faqs-classic/">AWS CloudHSM Classic FAQs</a>, the <a href="https://docs.aws.amazon.com/cloudhsm/classic/userguide/">AWS CloudHSM Classic User Guide</a>, and the <a href="https://docs.aws.amazon.com/cloudhsm/classic/APIReference/">AWS CloudHSM Classic API Reference</a>.</p>
    /// <p> <b>For information about the current version of AWS CloudHSM</b>, see <a href="http://aws.amazon.com/cloudhsm/">AWS CloudHSM</a>, the <a href="https://docs.aws.amazon.com/cloudhsm/latest/userguide/">AWS CloudHSM User Guide</a>, and the <a href="https://docs.aws.amazon.com/cloudhsm/latest/APIReference/">AWS CloudHSM API Reference</a>.</p>
    /// <p>Retrieves the identifiers of all of the HSMs provisioned for the current customer.</p>
    /// <p>This operation supports pagination with the use of the <code>NextToken</code> member. If more results are available, the <code>NextToken</code> member of the response contains a token that you pass in the next call to <code>ListHsms</code> to retrieve the next set of items.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListHsms {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_hsms_input::Builder,
    }
    impl ListHsms {
        /// Creates a new `ListHsms`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListHsmsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListHsmsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The <code>NextToken</code> value from a previous call to <code>ListHsms</code>. Pass null if this is the first call.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The <code>NextToken</code> value from a previous call to <code>ListHsms</code>. Pass null if this is the first call.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListLunaClients`.
    ///
    /// <p>This is documentation for <b>AWS CloudHSM Classic</b>. For more information, see <a href="http://aws.amazon.com/cloudhsm/faqs-classic/">AWS CloudHSM Classic FAQs</a>, the <a href="https://docs.aws.amazon.com/cloudhsm/classic/userguide/">AWS CloudHSM Classic User Guide</a>, and the <a href="https://docs.aws.amazon.com/cloudhsm/classic/APIReference/">AWS CloudHSM Classic API Reference</a>.</p>
    /// <p> <b>For information about the current version of AWS CloudHSM</b>, see <a href="http://aws.amazon.com/cloudhsm/">AWS CloudHSM</a>, the <a href="https://docs.aws.amazon.com/cloudhsm/latest/userguide/">AWS CloudHSM User Guide</a>, and the <a href="https://docs.aws.amazon.com/cloudhsm/latest/APIReference/">AWS CloudHSM API Reference</a>.</p>
    /// <p>Lists all of the clients.</p>
    /// <p>This operation supports pagination with the use of the <code>NextToken</code> member. If more results are available, the <code>NextToken</code> member of the response contains a token that you pass in the next call to <code>ListLunaClients</code> to retrieve the next set of items.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListLunaClients {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_luna_clients_input::Builder,
    }
    impl ListLunaClients {
        /// Creates a new `ListLunaClients`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListLunaClientsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListLunaClientsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The <code>NextToken</code> value from a previous call to <code>ListLunaClients</code>. Pass null if this is the first call.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The <code>NextToken</code> value from a previous call to <code>ListLunaClients</code>. Pass null if this is the first call.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTagsForResource`.
    ///
    /// <p>This is documentation for <b>AWS CloudHSM Classic</b>. For more information, see <a href="http://aws.amazon.com/cloudhsm/faqs-classic/">AWS CloudHSM Classic FAQs</a>, the <a href="https://docs.aws.amazon.com/cloudhsm/classic/userguide/">AWS CloudHSM Classic User Guide</a>, and the <a href="https://docs.aws.amazon.com/cloudhsm/classic/APIReference/">AWS CloudHSM Classic API Reference</a>.</p>
    /// <p> <b>For information about the current version of AWS CloudHSM</b>, see <a href="http://aws.amazon.com/cloudhsm/">AWS CloudHSM</a>, the <a href="https://docs.aws.amazon.com/cloudhsm/latest/userguide/">AWS CloudHSM User Guide</a>, and the <a href="https://docs.aws.amazon.com/cloudhsm/latest/APIReference/">AWS CloudHSM API Reference</a>.</p>
    /// <p>Returns a list of all tags for the specified AWS CloudHSM resource.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListTagsForResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_tags_for_resource_input::Builder,
    }
    impl ListTagsForResource {
        /// Creates a new `ListTagsForResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTagsForResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTagsForResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the AWS CloudHSM resource.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the AWS CloudHSM resource.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ModifyHapg`.
    ///
    /// <p>This is documentation for <b>AWS CloudHSM Classic</b>. For more information, see <a href="http://aws.amazon.com/cloudhsm/faqs-classic/">AWS CloudHSM Classic FAQs</a>, the <a href="https://docs.aws.amazon.com/cloudhsm/classic/userguide/">AWS CloudHSM Classic User Guide</a>, and the <a href="https://docs.aws.amazon.com/cloudhsm/classic/APIReference/">AWS CloudHSM Classic API Reference</a>.</p>
    /// <p> <b>For information about the current version of AWS CloudHSM</b>, see <a href="http://aws.amazon.com/cloudhsm/">AWS CloudHSM</a>, the <a href="https://docs.aws.amazon.com/cloudhsm/latest/userguide/">AWS CloudHSM User Guide</a>, and the <a href="https://docs.aws.amazon.com/cloudhsm/latest/APIReference/">AWS CloudHSM API Reference</a>.</p>
    /// <p>Modifies an existing high-availability partition group.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ModifyHapg {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::modify_hapg_input::Builder,
    }
    impl ModifyHapg {
        /// Creates a new `ModifyHapg`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ModifyHapgOutput,
            aws_smithy_http::result::SdkError<crate::error::ModifyHapgError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the high-availability partition group to modify.</p>
        pub fn hapg_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.hapg_arn(input.into());
            self
        }
        /// <p>The ARN of the high-availability partition group to modify.</p>
        pub fn set_hapg_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_hapg_arn(input);
            self
        }
        /// <p>The new label for the high-availability partition group.</p>
        pub fn label(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.label(input.into());
            self
        }
        /// <p>The new label for the high-availability partition group.</p>
        pub fn set_label(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_label(input);
            self
        }
        /// Appends an item to `PartitionSerialList`.
        ///
        /// To override the contents of this collection use [`set_partition_serial_list`](Self::set_partition_serial_list).
        ///
        /// <p>The list of partition serial numbers to make members of the high-availability partition group.</p>
        pub fn partition_serial_list(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.partition_serial_list(input.into());
            self
        }
        /// <p>The list of partition serial numbers to make members of the high-availability partition group.</p>
        pub fn set_partition_serial_list(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_partition_serial_list(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ModifyHsm`.
    ///
    /// <p>This is documentation for <b>AWS CloudHSM Classic</b>. For more information, see <a href="http://aws.amazon.com/cloudhsm/faqs-classic/">AWS CloudHSM Classic FAQs</a>, the <a href="https://docs.aws.amazon.com/cloudhsm/classic/userguide/">AWS CloudHSM Classic User Guide</a>, and the <a href="https://docs.aws.amazon.com/cloudhsm/classic/APIReference/">AWS CloudHSM Classic API Reference</a>.</p>
    /// <p> <b>For information about the current version of AWS CloudHSM</b>, see <a href="http://aws.amazon.com/cloudhsm/">AWS CloudHSM</a>, the <a href="https://docs.aws.amazon.com/cloudhsm/latest/userguide/">AWS CloudHSM User Guide</a>, and the <a href="https://docs.aws.amazon.com/cloudhsm/latest/APIReference/">AWS CloudHSM API Reference</a>.</p>
    /// <p>Modifies an HSM.</p> <important>
    /// <p>This operation can result in the HSM being offline for up to 15 minutes while the AWS CloudHSM service is reconfigured. If you are modifying a production HSM, you should ensure that your AWS CloudHSM service is configured for high availability, and consider executing this operation during a maintenance window.</p>
    /// </important>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ModifyHsm {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::modify_hsm_input::Builder,
    }
    impl ModifyHsm {
        /// Creates a new `ModifyHsm`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ModifyHsmOutput,
            aws_smithy_http::result::SdkError<crate::error::ModifyHsmError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the HSM to modify.</p>
        pub fn hsm_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.hsm_arn(input.into());
            self
        }
        /// <p>The ARN of the HSM to modify.</p>
        pub fn set_hsm_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_hsm_arn(input);
            self
        }
        /// <p>The new identifier of the subnet that the HSM is in. The new subnet must be in the same Availability Zone as the current subnet.</p>
        pub fn subnet_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.subnet_id(input.into());
            self
        }
        /// <p>The new identifier of the subnet that the HSM is in. The new subnet must be in the same Availability Zone as the current subnet.</p>
        pub fn set_subnet_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_subnet_id(input);
            self
        }
        /// <p>The new IP address for the elastic network interface (ENI) attached to the HSM.</p>
        /// <p>If the HSM is moved to a different subnet, and an IP address is not specified, an IP address will be randomly chosen from the CIDR range of the new subnet.</p>
        pub fn eni_ip(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.eni_ip(input.into());
            self
        }
        /// <p>The new IP address for the elastic network interface (ENI) attached to the HSM.</p>
        /// <p>If the HSM is moved to a different subnet, and an IP address is not specified, an IP address will be randomly chosen from the CIDR range of the new subnet.</p>
        pub fn set_eni_ip(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_eni_ip(input);
            self
        }
        /// <p>The new IAM role ARN.</p>
        pub fn iam_role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.iam_role_arn(input.into());
            self
        }
        /// <p>The new IAM role ARN.</p>
        pub fn set_iam_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_iam_role_arn(input);
            self
        }
        /// <p>The new external ID.</p>
        pub fn external_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.external_id(input.into());
            self
        }
        /// <p>The new external ID.</p>
        pub fn set_external_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_external_id(input);
            self
        }
        /// <p>The new IP address for the syslog monitoring server. The AWS CloudHSM service only supports one syslog monitoring server.</p>
        pub fn syslog_ip(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.syslog_ip(input.into());
            self
        }
        /// <p>The new IP address for the syslog monitoring server. The AWS CloudHSM service only supports one syslog monitoring server.</p>
        pub fn set_syslog_ip(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_syslog_ip(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ModifyLunaClient`.
    ///
    /// <p>This is documentation for <b>AWS CloudHSM Classic</b>. For more information, see <a href="http://aws.amazon.com/cloudhsm/faqs-classic/">AWS CloudHSM Classic FAQs</a>, the <a href="https://docs.aws.amazon.com/cloudhsm/classic/userguide/">AWS CloudHSM Classic User Guide</a>, and the <a href="https://docs.aws.amazon.com/cloudhsm/classic/APIReference/">AWS CloudHSM Classic API Reference</a>.</p>
    /// <p> <b>For information about the current version of AWS CloudHSM</b>, see <a href="http://aws.amazon.com/cloudhsm/">AWS CloudHSM</a>, the <a href="https://docs.aws.amazon.com/cloudhsm/latest/userguide/">AWS CloudHSM User Guide</a>, and the <a href="https://docs.aws.amazon.com/cloudhsm/latest/APIReference/">AWS CloudHSM API Reference</a>.</p>
    /// <p>Modifies the certificate used by the client.</p>
    /// <p>This action can potentially start a workflow to install the new certificate on the client's HSMs.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ModifyLunaClient {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::modify_luna_client_input::Builder,
    }
    impl ModifyLunaClient {
        /// Creates a new `ModifyLunaClient`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ModifyLunaClientOutput,
            aws_smithy_http::result::SdkError<crate::error::ModifyLunaClientError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the client.</p>
        pub fn client_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_arn(input.into());
            self
        }
        /// <p>The ARN of the client.</p>
        pub fn set_client_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_arn(input);
            self
        }
        /// <p>The new certificate for the client.</p>
        pub fn certificate(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.certificate(input.into());
            self
        }
        /// <p>The new certificate for the client.</p>
        pub fn set_certificate(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_certificate(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RemoveTagsFromResource`.
    ///
    /// <p>This is documentation for <b>AWS CloudHSM Classic</b>. For more information, see <a href="http://aws.amazon.com/cloudhsm/faqs-classic/">AWS CloudHSM Classic FAQs</a>, the <a href="https://docs.aws.amazon.com/cloudhsm/classic/userguide/">AWS CloudHSM Classic User Guide</a>, and the <a href="https://docs.aws.amazon.com/cloudhsm/classic/APIReference/">AWS CloudHSM Classic API Reference</a>.</p>
    /// <p> <b>For information about the current version of AWS CloudHSM</b>, see <a href="http://aws.amazon.com/cloudhsm/">AWS CloudHSM</a>, the <a href="https://docs.aws.amazon.com/cloudhsm/latest/userguide/">AWS CloudHSM User Guide</a>, and the <a href="https://docs.aws.amazon.com/cloudhsm/latest/APIReference/">AWS CloudHSM API Reference</a>.</p>
    /// <p>Removes one or more tags from the specified AWS CloudHSM resource.</p>
    /// <p>To remove a tag, specify only the tag key to remove (not the value). To overwrite the value for an existing tag, use <code>AddTagsToResource</code>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct RemoveTagsFromResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::remove_tags_from_resource_input::Builder,
    }
    impl RemoveTagsFromResource {
        /// Creates a new `RemoveTagsFromResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RemoveTagsFromResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::RemoveTagsFromResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the AWS CloudHSM resource.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the AWS CloudHSM resource.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `TagKeyList`.
        ///
        /// To override the contents of this collection use [`set_tag_key_list`](Self::set_tag_key_list).
        ///
        /// <p>The tag key or keys to remove.</p>
        /// <p>Specify only the tag key to remove (not the value). To overwrite the value for an existing tag, use <code>AddTagsToResource</code>.</p>
        pub fn tag_key_list(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_key_list(input.into());
            self
        }
        /// <p>The tag key or keys to remove.</p>
        /// <p>Specify only the tag key to remove (not the value). To overwrite the value for an existing tag, use <code>AddTagsToResource</code>.</p>
        pub fn set_tag_key_list(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_key_list(input);
            self
        }
    }
}

impl Client {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn<C, E>(conf: crate::Config, conn: C) -> Self
    where
        C: aws_smithy_client::bounds::SmithyConnector<Error = E> + Send + 'static,
        E: Into<aws_smithy_http::result::ConnectorError>,
    {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::new()
            .connector(aws_smithy_client::erase::DynConnector::new(conn))
            .middleware(aws_smithy_client::erase::DynMiddleware::new(
                crate::middleware::DefaultMiddleware::new(),
            ));
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(sdk_config: &aws_types::sdk_config::SdkConfig) -> Self {
        Self::from_conf(sdk_config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::dyn_https().middleware(
            aws_smithy_client::erase::DynMiddleware::new(
                crate::middleware::DefaultMiddleware::new(),
            ),
        );
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        // the builder maintains a try-state. To avoid suppressing the warning when sleep is unset,
        // only set it if we actually have a sleep impl.
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();

        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
