// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle<
    C = aws_smithy_client::erase::DynConnector,
    M = crate::middleware::DefaultMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    pub(crate) client: aws_smithy_client::Client<C, M, R>,
    pub(crate) conf: crate::Config,
}

/// Client for Amazon CloudHSM
///
/// Client for invoking operations on Amazon CloudHSM. Each operation on Amazon CloudHSM is a method on this
/// this struct. `.send()` MUST be invoked on the generated operations to dispatch the request to the service.
///
/// # Examples
/// **Constructing a client and invoking an operation**
/// ```rust,no_run
/// # async fn docs() {
///     // create a shared configuration. This can be used & shared between multiple service clients.
///     let shared_config = aws_config::load_from_env().await;
///     let client = aws_sdk_cloudhsm::Client::new(&shared_config);
///     // invoke an operation
///     /* let rsp = client
///         .<operation_name>().
///         .<param>("some value")
///         .send().await; */
/// # }
/// ```
/// **Constructing a client with custom configuration**
/// ```rust,no_run
/// use aws_config::RetryConfig;
/// # async fn docs() {
///     let shared_config = aws_config::load_from_env().await;
///     let config = aws_sdk_cloudhsm::config::Builder::from(&shared_config)
///         .retry_config(RetryConfig::disabled())
///         .build();
///     let client = aws_sdk_cloudhsm::Client::from_conf(config);
/// # }
#[derive(std::fmt::Debug)]
pub struct Client<
    C = aws_smithy_client::erase::DynConnector,
    M = crate::middleware::DefaultMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    handle: std::sync::Arc<Handle<C, M, R>>,
}

impl<C, M, R> std::clone::Clone for Client<C, M, R> {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl<C, M, R> From<aws_smithy_client::Client<C, M, R>> for Client<C, M, R> {
    fn from(client: aws_smithy_client::Client<C, M, R>) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl<C, M, R> Client<C, M, R> {
    /// Creates a client with the given service configuration.
    pub fn with_config(client: aws_smithy_client::Client<C, M, R>, conf: crate::Config) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl<C, M, R> Client<C, M, R>
where
    C: aws_smithy_client::bounds::SmithyConnector,
    M: aws_smithy_client::bounds::SmithyMiddleware<C>,
    R: aws_smithy_client::retry::NewRequestPolicy,
{
    /// Constructs a fluent builder for the `AddTagsToResource` operation.
    ///
    /// See [`AddTagsToResource`](crate::client::fluent_builders::AddTagsToResource) for more information about the
    /// operation and its arguments.
    pub fn add_tags_to_resource(&self) -> fluent_builders::AddTagsToResource<C, M, R> {
        fluent_builders::AddTagsToResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateHapg` operation.
    ///
    /// See [`CreateHapg`](crate::client::fluent_builders::CreateHapg) for more information about the
    /// operation and its arguments.
    pub fn create_hapg(&self) -> fluent_builders::CreateHapg<C, M, R> {
        fluent_builders::CreateHapg::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateHsm` operation.
    ///
    /// See [`CreateHsm`](crate::client::fluent_builders::CreateHsm) for more information about the
    /// operation and its arguments.
    pub fn create_hsm(&self) -> fluent_builders::CreateHsm<C, M, R> {
        fluent_builders::CreateHsm::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateLunaClient` operation.
    ///
    /// See [`CreateLunaClient`](crate::client::fluent_builders::CreateLunaClient) for more information about the
    /// operation and its arguments.
    pub fn create_luna_client(&self) -> fluent_builders::CreateLunaClient<C, M, R> {
        fluent_builders::CreateLunaClient::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteHapg` operation.
    ///
    /// See [`DeleteHapg`](crate::client::fluent_builders::DeleteHapg) for more information about the
    /// operation and its arguments.
    pub fn delete_hapg(&self) -> fluent_builders::DeleteHapg<C, M, R> {
        fluent_builders::DeleteHapg::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteHsm` operation.
    ///
    /// See [`DeleteHsm`](crate::client::fluent_builders::DeleteHsm) for more information about the
    /// operation and its arguments.
    pub fn delete_hsm(&self) -> fluent_builders::DeleteHsm<C, M, R> {
        fluent_builders::DeleteHsm::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteLunaClient` operation.
    ///
    /// See [`DeleteLunaClient`](crate::client::fluent_builders::DeleteLunaClient) for more information about the
    /// operation and its arguments.
    pub fn delete_luna_client(&self) -> fluent_builders::DeleteLunaClient<C, M, R> {
        fluent_builders::DeleteLunaClient::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeHapg` operation.
    ///
    /// See [`DescribeHapg`](crate::client::fluent_builders::DescribeHapg) for more information about the
    /// operation and its arguments.
    pub fn describe_hapg(&self) -> fluent_builders::DescribeHapg<C, M, R> {
        fluent_builders::DescribeHapg::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeHsm` operation.
    ///
    /// See [`DescribeHsm`](crate::client::fluent_builders::DescribeHsm) for more information about the
    /// operation and its arguments.
    pub fn describe_hsm(&self) -> fluent_builders::DescribeHsm<C, M, R> {
        fluent_builders::DescribeHsm::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeLunaClient` operation.
    ///
    /// See [`DescribeLunaClient`](crate::client::fluent_builders::DescribeLunaClient) for more information about the
    /// operation and its arguments.
    pub fn describe_luna_client(&self) -> fluent_builders::DescribeLunaClient<C, M, R> {
        fluent_builders::DescribeLunaClient::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetConfig` operation.
    ///
    /// See [`GetConfig`](crate::client::fluent_builders::GetConfig) for more information about the
    /// operation and its arguments.
    pub fn get_config(&self) -> fluent_builders::GetConfig<C, M, R> {
        fluent_builders::GetConfig::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListAvailableZones` operation.
    ///
    /// See [`ListAvailableZones`](crate::client::fluent_builders::ListAvailableZones) for more information about the
    /// operation and its arguments.
    pub fn list_available_zones(&self) -> fluent_builders::ListAvailableZones<C, M, R> {
        fluent_builders::ListAvailableZones::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListHapgs` operation.
    ///
    /// See [`ListHapgs`](crate::client::fluent_builders::ListHapgs) for more information about the
    /// operation and its arguments.
    pub fn list_hapgs(&self) -> fluent_builders::ListHapgs<C, M, R> {
        fluent_builders::ListHapgs::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListHsms` operation.
    ///
    /// See [`ListHsms`](crate::client::fluent_builders::ListHsms) for more information about the
    /// operation and its arguments.
    pub fn list_hsms(&self) -> fluent_builders::ListHsms<C, M, R> {
        fluent_builders::ListHsms::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListLunaClients` operation.
    ///
    /// See [`ListLunaClients`](crate::client::fluent_builders::ListLunaClients) for more information about the
    /// operation and its arguments.
    pub fn list_luna_clients(&self) -> fluent_builders::ListLunaClients<C, M, R> {
        fluent_builders::ListLunaClients::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListTagsForResource` operation.
    ///
    /// See [`ListTagsForResource`](crate::client::fluent_builders::ListTagsForResource) for more information about the
    /// operation and its arguments.
    pub fn list_tags_for_resource(&self) -> fluent_builders::ListTagsForResource<C, M, R> {
        fluent_builders::ListTagsForResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ModifyHapg` operation.
    ///
    /// See [`ModifyHapg`](crate::client::fluent_builders::ModifyHapg) for more information about the
    /// operation and its arguments.
    pub fn modify_hapg(&self) -> fluent_builders::ModifyHapg<C, M, R> {
        fluent_builders::ModifyHapg::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ModifyHsm` operation.
    ///
    /// See [`ModifyHsm`](crate::client::fluent_builders::ModifyHsm) for more information about the
    /// operation and its arguments.
    pub fn modify_hsm(&self) -> fluent_builders::ModifyHsm<C, M, R> {
        fluent_builders::ModifyHsm::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ModifyLunaClient` operation.
    ///
    /// See [`ModifyLunaClient`](crate::client::fluent_builders::ModifyLunaClient) for more information about the
    /// operation and its arguments.
    pub fn modify_luna_client(&self) -> fluent_builders::ModifyLunaClient<C, M, R> {
        fluent_builders::ModifyLunaClient::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `RemoveTagsFromResource` operation.
    ///
    /// See [`RemoveTagsFromResource`](crate::client::fluent_builders::RemoveTagsFromResource) for more information about the
    /// operation and its arguments.
    pub fn remove_tags_from_resource(&self) -> fluent_builders::RemoveTagsFromResource<C, M, R> {
        fluent_builders::RemoveTagsFromResource::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `AddTagsToResource`.
    ///
    /// <p>This is documentation for <b>AWS CloudHSM Classic</b>. For more information, see <a href="http://aws.amazon.com/cloudhsm/faqs-classic/">AWS CloudHSM Classic FAQs</a>, the <a href="https://docs.aws.amazon.com/cloudhsm/classic/userguide/">AWS CloudHSM Classic User Guide</a>, and the <a href="https://docs.aws.amazon.com/cloudhsm/classic/APIReference/">AWS CloudHSM Classic API Reference</a>.</p>
    /// <p> <b>For information about the current version of AWS CloudHSM</b>, see <a href="http://aws.amazon.com/cloudhsm/">AWS CloudHSM</a>, the <a href="https://docs.aws.amazon.com/cloudhsm/latest/userguide/">AWS CloudHSM User Guide</a>, and the <a href="https://docs.aws.amazon.com/cloudhsm/latest/APIReference/">AWS CloudHSM API Reference</a>.</p>
    /// <p>Adds or overwrites one or more tags for the specified AWS CloudHSM resource.</p>
    /// <p>Each tag consists of a key and a value. Tag keys must be unique to each resource.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct AddTagsToResource<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::add_tags_to_resource_input::Builder,
    }
    impl<C, M, R> AddTagsToResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AddTagsToResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AddTagsToResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::AddTagsToResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AddTagsToResourceInputOperationOutputAlias,
                crate::output::AddTagsToResourceOutput,
                crate::error::AddTagsToResourceError,
                crate::input::AddTagsToResourceInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the AWS CloudHSM resource to tag.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the AWS CloudHSM resource to tag.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `TagList`.
        ///
        /// To override the contents of this collection use [`set_tag_list`](Self::set_tag_list).
        ///
        /// <p>One or more tags.</p>
        pub fn tag_list(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tag_list(input);
            self
        }
        /// <p>One or more tags.</p>
        pub fn set_tag_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tag_list(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateHapg`.
    ///
    /// <p>This is documentation for <b>AWS CloudHSM Classic</b>. For more information, see <a href="http://aws.amazon.com/cloudhsm/faqs-classic/">AWS CloudHSM Classic FAQs</a>, the <a href="https://docs.aws.amazon.com/cloudhsm/classic/userguide/">AWS CloudHSM Classic User Guide</a>, and the <a href="https://docs.aws.amazon.com/cloudhsm/classic/APIReference/">AWS CloudHSM Classic API Reference</a>.</p>
    /// <p> <b>For information about the current version of AWS CloudHSM</b>, see <a href="http://aws.amazon.com/cloudhsm/">AWS CloudHSM</a>, the <a href="https://docs.aws.amazon.com/cloudhsm/latest/userguide/">AWS CloudHSM User Guide</a>, and the <a href="https://docs.aws.amazon.com/cloudhsm/latest/APIReference/">AWS CloudHSM API Reference</a>.</p>
    /// <p>Creates a high-availability partition group. A high-availability partition group is a group of partitions that spans multiple physical HSMs.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateHapg<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_hapg_input::Builder,
    }
    impl<C, M, R> CreateHapg<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateHapg`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateHapgOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateHapgError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateHapgInputOperationOutputAlias,
                crate::output::CreateHapgOutput,
                crate::error::CreateHapgError,
                crate::input::CreateHapgInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The label of the new high-availability partition group.</p>
        pub fn label(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.label(input.into());
            self
        }
        /// <p>The label of the new high-availability partition group.</p>
        pub fn set_label(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_label(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateHsm`.
    ///
    /// <p>This is documentation for <b>AWS CloudHSM Classic</b>. For more information, see <a href="http://aws.amazon.com/cloudhsm/faqs-classic/">AWS CloudHSM Classic FAQs</a>, the <a href="https://docs.aws.amazon.com/cloudhsm/classic/userguide/">AWS CloudHSM Classic User Guide</a>, and the <a href="https://docs.aws.amazon.com/cloudhsm/classic/APIReference/">AWS CloudHSM Classic API Reference</a>.</p>
    /// <p> <b>For information about the current version of AWS CloudHSM</b>, see <a href="http://aws.amazon.com/cloudhsm/">AWS CloudHSM</a>, the <a href="https://docs.aws.amazon.com/cloudhsm/latest/userguide/">AWS CloudHSM User Guide</a>, and the <a href="https://docs.aws.amazon.com/cloudhsm/latest/APIReference/">AWS CloudHSM API Reference</a>.</p>
    /// <p>Creates an uninitialized HSM instance.</p>
    /// <p>There is an upfront fee charged for each HSM instance that you create with the <code>CreateHsm</code> operation. If you accidentally provision an HSM and want to request a refund, delete the instance using the <code>DeleteHsm</code> operation, go to the <a href="https://console.aws.amazon.com/support/home">AWS Support Center</a>, create a new case, and select <b>Account and Billing Support</b>.</p> <important>
    /// <p>It can take up to 20 minutes to create and provision an HSM. You can monitor the status of the HSM with the <code>DescribeHsm</code> operation. The HSM is ready to be initialized when the status changes to <code>RUNNING</code>.</p>
    /// </important>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateHsm<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_hsm_input::Builder,
    }
    impl<C, M, R> CreateHsm<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateHsm`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateHsmOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateHsmError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateHsmInputOperationOutputAlias,
                crate::output::CreateHsmOutput,
                crate::error::CreateHsmError,
                crate::input::CreateHsmInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the subnet in your VPC in which to place the HSM.</p>
        pub fn subnet_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.subnet_id(input.into());
            self
        }
        /// <p>The identifier of the subnet in your VPC in which to place the HSM.</p>
        pub fn set_subnet_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_subnet_id(input);
            self
        }
        /// <p>The SSH public key to install on the HSM.</p>
        pub fn ssh_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.ssh_key(input.into());
            self
        }
        /// <p>The SSH public key to install on the HSM.</p>
        pub fn set_ssh_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_ssh_key(input);
            self
        }
        /// <p>The IP address to assign to the HSM's ENI.</p>
        /// <p>If an IP address is not specified, an IP address will be randomly chosen from the CIDR range of the subnet.</p>
        pub fn eni_ip(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.eni_ip(input.into());
            self
        }
        /// <p>The IP address to assign to the HSM's ENI.</p>
        /// <p>If an IP address is not specified, an IP address will be randomly chosen from the CIDR range of the subnet.</p>
        pub fn set_eni_ip(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_eni_ip(input);
            self
        }
        /// <p>The ARN of an IAM role to enable the AWS CloudHSM service to allocate an ENI on your behalf.</p>
        pub fn iam_role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.iam_role_arn(input.into());
            self
        }
        /// <p>The ARN of an IAM role to enable the AWS CloudHSM service to allocate an ENI on your behalf.</p>
        pub fn set_iam_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_iam_role_arn(input);
            self
        }
        /// <p>The external ID from <code>IamRoleArn</code>, if present.</p>
        pub fn external_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.external_id(input.into());
            self
        }
        /// <p>The external ID from <code>IamRoleArn</code>, if present.</p>
        pub fn set_external_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_external_id(input);
            self
        }
        /// <p>Specifies the type of subscription for the HSM.</p>
        /// <ul>
        /// <li> <p> <b>PRODUCTION</b> - The HSM is being used in a production environment.</p> </li>
        /// <li> <p> <b>TRIAL</b> - The HSM is being used in a product trial.</p> </li>
        /// </ul>
        pub fn subscription_type(mut self, input: crate::model::SubscriptionType) -> Self {
            self.inner = self.inner.subscription_type(input);
            self
        }
        /// <p>Specifies the type of subscription for the HSM.</p>
        /// <ul>
        /// <li> <p> <b>PRODUCTION</b> - The HSM is being used in a production environment.</p> </li>
        /// <li> <p> <b>TRIAL</b> - The HSM is being used in a product trial.</p> </li>
        /// </ul>
        pub fn set_subscription_type(
            mut self,
            input: std::option::Option<crate::model::SubscriptionType>,
        ) -> Self {
            self.inner = self.inner.set_subscription_type(input);
            self
        }
        /// <p>A user-defined token to ensure idempotence. Subsequent calls to this operation with the same token will be ignored.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(input.into());
            self
        }
        /// <p>A user-defined token to ensure idempotence. Subsequent calls to this operation with the same token will be ignored.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
        /// <p>The IP address for the syslog monitoring server. The AWS CloudHSM service only supports one syslog monitoring server.</p>
        pub fn syslog_ip(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.syslog_ip(input.into());
            self
        }
        /// <p>The IP address for the syslog monitoring server. The AWS CloudHSM service only supports one syslog monitoring server.</p>
        pub fn set_syslog_ip(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_syslog_ip(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateLunaClient`.
    ///
    /// <p>This is documentation for <b>AWS CloudHSM Classic</b>. For more information, see <a href="http://aws.amazon.com/cloudhsm/faqs-classic/">AWS CloudHSM Classic FAQs</a>, the <a href="https://docs.aws.amazon.com/cloudhsm/classic/userguide/">AWS CloudHSM Classic User Guide</a>, and the <a href="https://docs.aws.amazon.com/cloudhsm/classic/APIReference/">AWS CloudHSM Classic API Reference</a>.</p>
    /// <p> <b>For information about the current version of AWS CloudHSM</b>, see <a href="http://aws.amazon.com/cloudhsm/">AWS CloudHSM</a>, the <a href="https://docs.aws.amazon.com/cloudhsm/latest/userguide/">AWS CloudHSM User Guide</a>, and the <a href="https://docs.aws.amazon.com/cloudhsm/latest/APIReference/">AWS CloudHSM API Reference</a>.</p>
    /// <p>Creates an HSM client.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateLunaClient<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_luna_client_input::Builder,
    }
    impl<C, M, R> CreateLunaClient<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateLunaClient`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateLunaClientOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateLunaClientError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateLunaClientInputOperationOutputAlias,
                crate::output::CreateLunaClientOutput,
                crate::error::CreateLunaClientError,
                crate::input::CreateLunaClientInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The label for the client.</p>
        pub fn label(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.label(input.into());
            self
        }
        /// <p>The label for the client.</p>
        pub fn set_label(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_label(input);
            self
        }
        /// <p>The contents of a Base64-Encoded X.509 v3 certificate to be installed on the HSMs used by this client.</p>
        pub fn certificate(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.certificate(input.into());
            self
        }
        /// <p>The contents of a Base64-Encoded X.509 v3 certificate to be installed on the HSMs used by this client.</p>
        pub fn set_certificate(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_certificate(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteHapg`.
    ///
    /// <p>This is documentation for <b>AWS CloudHSM Classic</b>. For more information, see <a href="http://aws.amazon.com/cloudhsm/faqs-classic/">AWS CloudHSM Classic FAQs</a>, the <a href="https://docs.aws.amazon.com/cloudhsm/classic/userguide/">AWS CloudHSM Classic User Guide</a>, and the <a href="https://docs.aws.amazon.com/cloudhsm/classic/APIReference/">AWS CloudHSM Classic API Reference</a>.</p>
    /// <p> <b>For information about the current version of AWS CloudHSM</b>, see <a href="http://aws.amazon.com/cloudhsm/">AWS CloudHSM</a>, the <a href="https://docs.aws.amazon.com/cloudhsm/latest/userguide/">AWS CloudHSM User Guide</a>, and the <a href="https://docs.aws.amazon.com/cloudhsm/latest/APIReference/">AWS CloudHSM API Reference</a>.</p>
    /// <p>Deletes a high-availability partition group.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteHapg<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_hapg_input::Builder,
    }
    impl<C, M, R> DeleteHapg<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteHapg`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteHapgOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteHapgError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteHapgInputOperationOutputAlias,
                crate::output::DeleteHapgOutput,
                crate::error::DeleteHapgError,
                crate::input::DeleteHapgInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the high-availability partition group to delete.</p>
        pub fn hapg_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.hapg_arn(input.into());
            self
        }
        /// <p>The ARN of the high-availability partition group to delete.</p>
        pub fn set_hapg_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_hapg_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteHsm`.
    ///
    /// <p>This is documentation for <b>AWS CloudHSM Classic</b>. For more information, see <a href="http://aws.amazon.com/cloudhsm/faqs-classic/">AWS CloudHSM Classic FAQs</a>, the <a href="https://docs.aws.amazon.com/cloudhsm/classic/userguide/">AWS CloudHSM Classic User Guide</a>, and the <a href="https://docs.aws.amazon.com/cloudhsm/classic/APIReference/">AWS CloudHSM Classic API Reference</a>.</p>
    /// <p> <b>For information about the current version of AWS CloudHSM</b>, see <a href="http://aws.amazon.com/cloudhsm/">AWS CloudHSM</a>, the <a href="https://docs.aws.amazon.com/cloudhsm/latest/userguide/">AWS CloudHSM User Guide</a>, and the <a href="https://docs.aws.amazon.com/cloudhsm/latest/APIReference/">AWS CloudHSM API Reference</a>.</p>
    /// <p>Deletes an HSM. After completion, this operation cannot be undone and your key material cannot be recovered.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteHsm<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_hsm_input::Builder,
    }
    impl<C, M, R> DeleteHsm<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteHsm`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteHsmOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteHsmError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteHsmInputOperationOutputAlias,
                crate::output::DeleteHsmOutput,
                crate::error::DeleteHsmError,
                crate::input::DeleteHsmInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the HSM to delete.</p>
        pub fn hsm_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.hsm_arn(input.into());
            self
        }
        /// <p>The ARN of the HSM to delete.</p>
        pub fn set_hsm_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_hsm_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteLunaClient`.
    ///
    /// <p>This is documentation for <b>AWS CloudHSM Classic</b>. For more information, see <a href="http://aws.amazon.com/cloudhsm/faqs-classic/">AWS CloudHSM Classic FAQs</a>, the <a href="https://docs.aws.amazon.com/cloudhsm/classic/userguide/">AWS CloudHSM Classic User Guide</a>, and the <a href="https://docs.aws.amazon.com/cloudhsm/classic/APIReference/">AWS CloudHSM Classic API Reference</a>.</p>
    /// <p> <b>For information about the current version of AWS CloudHSM</b>, see <a href="http://aws.amazon.com/cloudhsm/">AWS CloudHSM</a>, the <a href="https://docs.aws.amazon.com/cloudhsm/latest/userguide/">AWS CloudHSM User Guide</a>, and the <a href="https://docs.aws.amazon.com/cloudhsm/latest/APIReference/">AWS CloudHSM API Reference</a>.</p>
    /// <p>Deletes a client.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteLunaClient<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_luna_client_input::Builder,
    }
    impl<C, M, R> DeleteLunaClient<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteLunaClient`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteLunaClientOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteLunaClientError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteLunaClientInputOperationOutputAlias,
                crate::output::DeleteLunaClientOutput,
                crate::error::DeleteLunaClientError,
                crate::input::DeleteLunaClientInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the client to delete.</p>
        pub fn client_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_arn(input.into());
            self
        }
        /// <p>The ARN of the client to delete.</p>
        pub fn set_client_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeHapg`.
    ///
    /// <p>This is documentation for <b>AWS CloudHSM Classic</b>. For more information, see <a href="http://aws.amazon.com/cloudhsm/faqs-classic/">AWS CloudHSM Classic FAQs</a>, the <a href="https://docs.aws.amazon.com/cloudhsm/classic/userguide/">AWS CloudHSM Classic User Guide</a>, and the <a href="https://docs.aws.amazon.com/cloudhsm/classic/APIReference/">AWS CloudHSM Classic API Reference</a>.</p>
    /// <p> <b>For information about the current version of AWS CloudHSM</b>, see <a href="http://aws.amazon.com/cloudhsm/">AWS CloudHSM</a>, the <a href="https://docs.aws.amazon.com/cloudhsm/latest/userguide/">AWS CloudHSM User Guide</a>, and the <a href="https://docs.aws.amazon.com/cloudhsm/latest/APIReference/">AWS CloudHSM API Reference</a>.</p>
    /// <p>Retrieves information about a high-availability partition group.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeHapg<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_hapg_input::Builder,
    }
    impl<C, M, R> DescribeHapg<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeHapg`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeHapgOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeHapgError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeHapgInputOperationOutputAlias,
                crate::output::DescribeHapgOutput,
                crate::error::DescribeHapgError,
                crate::input::DescribeHapgInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the high-availability partition group to describe.</p>
        pub fn hapg_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.hapg_arn(input.into());
            self
        }
        /// <p>The ARN of the high-availability partition group to describe.</p>
        pub fn set_hapg_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_hapg_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeHsm`.
    ///
    /// <p>This is documentation for <b>AWS CloudHSM Classic</b>. For more information, see <a href="http://aws.amazon.com/cloudhsm/faqs-classic/">AWS CloudHSM Classic FAQs</a>, the <a href="https://docs.aws.amazon.com/cloudhsm/classic/userguide/">AWS CloudHSM Classic User Guide</a>, and the <a href="https://docs.aws.amazon.com/cloudhsm/classic/APIReference/">AWS CloudHSM Classic API Reference</a>.</p>
    /// <p> <b>For information about the current version of AWS CloudHSM</b>, see <a href="http://aws.amazon.com/cloudhsm/">AWS CloudHSM</a>, the <a href="https://docs.aws.amazon.com/cloudhsm/latest/userguide/">AWS CloudHSM User Guide</a>, and the <a href="https://docs.aws.amazon.com/cloudhsm/latest/APIReference/">AWS CloudHSM API Reference</a>.</p>
    /// <p>Retrieves information about an HSM. You can identify the HSM by its ARN or its serial number.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeHsm<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_hsm_input::Builder,
    }
    impl<C, M, R> DescribeHsm<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeHsm`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeHsmOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeHsmError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeHsmInputOperationOutputAlias,
                crate::output::DescribeHsmOutput,
                crate::error::DescribeHsmError,
                crate::input::DescribeHsmInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the HSM. Either the <code>HsmArn</code> or the <code>SerialNumber</code> parameter must be specified.</p>
        pub fn hsm_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.hsm_arn(input.into());
            self
        }
        /// <p>The ARN of the HSM. Either the <code>HsmArn</code> or the <code>SerialNumber</code> parameter must be specified.</p>
        pub fn set_hsm_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_hsm_arn(input);
            self
        }
        /// <p>The serial number of the HSM. Either the <code>HsmArn</code> or the <code>HsmSerialNumber</code> parameter must be specified.</p>
        pub fn hsm_serial_number(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.hsm_serial_number(input.into());
            self
        }
        /// <p>The serial number of the HSM. Either the <code>HsmArn</code> or the <code>HsmSerialNumber</code> parameter must be specified.</p>
        pub fn set_hsm_serial_number(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_hsm_serial_number(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeLunaClient`.
    ///
    /// <p>This is documentation for <b>AWS CloudHSM Classic</b>. For more information, see <a href="http://aws.amazon.com/cloudhsm/faqs-classic/">AWS CloudHSM Classic FAQs</a>, the <a href="https://docs.aws.amazon.com/cloudhsm/classic/userguide/">AWS CloudHSM Classic User Guide</a>, and the <a href="https://docs.aws.amazon.com/cloudhsm/classic/APIReference/">AWS CloudHSM Classic API Reference</a>.</p>
    /// <p> <b>For information about the current version of AWS CloudHSM</b>, see <a href="http://aws.amazon.com/cloudhsm/">AWS CloudHSM</a>, the <a href="https://docs.aws.amazon.com/cloudhsm/latest/userguide/">AWS CloudHSM User Guide</a>, and the <a href="https://docs.aws.amazon.com/cloudhsm/latest/APIReference/">AWS CloudHSM API Reference</a>.</p>
    /// <p>Retrieves information about an HSM client.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeLunaClient<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_luna_client_input::Builder,
    }
    impl<C, M, R> DescribeLunaClient<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeLunaClient`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeLunaClientOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeLunaClientError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeLunaClientInputOperationOutputAlias,
                crate::output::DescribeLunaClientOutput,
                crate::error::DescribeLunaClientError,
                crate::input::DescribeLunaClientInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the client.</p>
        pub fn client_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_arn(input.into());
            self
        }
        /// <p>The ARN of the client.</p>
        pub fn set_client_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_arn(input);
            self
        }
        /// <p>The certificate fingerprint.</p>
        pub fn certificate_fingerprint(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.certificate_fingerprint(input.into());
            self
        }
        /// <p>The certificate fingerprint.</p>
        pub fn set_certificate_fingerprint(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_certificate_fingerprint(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetConfig`.
    ///
    /// <p>This is documentation for <b>AWS CloudHSM Classic</b>. For more information, see <a href="http://aws.amazon.com/cloudhsm/faqs-classic/">AWS CloudHSM Classic FAQs</a>, the <a href="https://docs.aws.amazon.com/cloudhsm/classic/userguide/">AWS CloudHSM Classic User Guide</a>, and the <a href="https://docs.aws.amazon.com/cloudhsm/classic/APIReference/">AWS CloudHSM Classic API Reference</a>.</p>
    /// <p> <b>For information about the current version of AWS CloudHSM</b>, see <a href="http://aws.amazon.com/cloudhsm/">AWS CloudHSM</a>, the <a href="https://docs.aws.amazon.com/cloudhsm/latest/userguide/">AWS CloudHSM User Guide</a>, and the <a href="https://docs.aws.amazon.com/cloudhsm/latest/APIReference/">AWS CloudHSM API Reference</a>.</p>
    /// <p>Gets the configuration files necessary to connect to all high availability partition groups the client is associated with.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetConfig<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_config_input::Builder,
    }
    impl<C, M, R> GetConfig<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetConfig`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetConfigOutput,
            aws_smithy_http::result::SdkError<crate::error::GetConfigError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetConfigInputOperationOutputAlias,
                crate::output::GetConfigOutput,
                crate::error::GetConfigError,
                crate::input::GetConfigInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the client.</p>
        pub fn client_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_arn(input.into());
            self
        }
        /// <p>The ARN of the client.</p>
        pub fn set_client_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_arn(input);
            self
        }
        /// <p>The client version.</p>
        pub fn client_version(mut self, input: crate::model::ClientVersion) -> Self {
            self.inner = self.inner.client_version(input);
            self
        }
        /// <p>The client version.</p>
        pub fn set_client_version(
            mut self,
            input: std::option::Option<crate::model::ClientVersion>,
        ) -> Self {
            self.inner = self.inner.set_client_version(input);
            self
        }
        /// Appends an item to `HapgList`.
        ///
        /// To override the contents of this collection use [`set_hapg_list`](Self::set_hapg_list).
        ///
        /// <p>A list of ARNs that identify the high-availability partition groups that are associated with the client.</p>
        pub fn hapg_list(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.hapg_list(input.into());
            self
        }
        /// <p>A list of ARNs that identify the high-availability partition groups that are associated with the client.</p>
        pub fn set_hapg_list(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_hapg_list(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListAvailableZones`.
    ///
    /// <p>This is documentation for <b>AWS CloudHSM Classic</b>. For more information, see <a href="http://aws.amazon.com/cloudhsm/faqs-classic/">AWS CloudHSM Classic FAQs</a>, the <a href="https://docs.aws.amazon.com/cloudhsm/classic/userguide/">AWS CloudHSM Classic User Guide</a>, and the <a href="https://docs.aws.amazon.com/cloudhsm/classic/APIReference/">AWS CloudHSM Classic API Reference</a>.</p>
    /// <p> <b>For information about the current version of AWS CloudHSM</b>, see <a href="http://aws.amazon.com/cloudhsm/">AWS CloudHSM</a>, the <a href="https://docs.aws.amazon.com/cloudhsm/latest/userguide/">AWS CloudHSM User Guide</a>, and the <a href="https://docs.aws.amazon.com/cloudhsm/latest/APIReference/">AWS CloudHSM API Reference</a>.</p>
    /// <p>Lists the Availability Zones that have available AWS CloudHSM capacity.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListAvailableZones<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_available_zones_input::Builder,
    }
    impl<C, M, R> ListAvailableZones<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListAvailableZones`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListAvailableZonesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListAvailableZonesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListAvailableZonesInputOperationOutputAlias,
                crate::output::ListAvailableZonesOutput,
                crate::error::ListAvailableZonesError,
                crate::input::ListAvailableZonesInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
    }
    /// Fluent builder constructing a request to `ListHapgs`.
    ///
    /// <p>This is documentation for <b>AWS CloudHSM Classic</b>. For more information, see <a href="http://aws.amazon.com/cloudhsm/faqs-classic/">AWS CloudHSM Classic FAQs</a>, the <a href="https://docs.aws.amazon.com/cloudhsm/classic/userguide/">AWS CloudHSM Classic User Guide</a>, and the <a href="https://docs.aws.amazon.com/cloudhsm/classic/APIReference/">AWS CloudHSM Classic API Reference</a>.</p>
    /// <p> <b>For information about the current version of AWS CloudHSM</b>, see <a href="http://aws.amazon.com/cloudhsm/">AWS CloudHSM</a>, the <a href="https://docs.aws.amazon.com/cloudhsm/latest/userguide/">AWS CloudHSM User Guide</a>, and the <a href="https://docs.aws.amazon.com/cloudhsm/latest/APIReference/">AWS CloudHSM API Reference</a>.</p>
    /// <p>Lists the high-availability partition groups for the account.</p>
    /// <p>This operation supports pagination with the use of the <code>NextToken</code> member. If more results are available, the <code>NextToken</code> member of the response contains a token that you pass in the next call to <code>ListHapgs</code> to retrieve the next set of items.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListHapgs<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_hapgs_input::Builder,
    }
    impl<C, M, R> ListHapgs<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListHapgs`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListHapgsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListHapgsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListHapgsInputOperationOutputAlias,
                crate::output::ListHapgsOutput,
                crate::error::ListHapgsError,
                crate::input::ListHapgsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The <code>NextToken</code> value from a previous call to <code>ListHapgs</code>. Pass null if this is the first call.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The <code>NextToken</code> value from a previous call to <code>ListHapgs</code>. Pass null if this is the first call.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListHsms`.
    ///
    /// <p>This is documentation for <b>AWS CloudHSM Classic</b>. For more information, see <a href="http://aws.amazon.com/cloudhsm/faqs-classic/">AWS CloudHSM Classic FAQs</a>, the <a href="https://docs.aws.amazon.com/cloudhsm/classic/userguide/">AWS CloudHSM Classic User Guide</a>, and the <a href="https://docs.aws.amazon.com/cloudhsm/classic/APIReference/">AWS CloudHSM Classic API Reference</a>.</p>
    /// <p> <b>For information about the current version of AWS CloudHSM</b>, see <a href="http://aws.amazon.com/cloudhsm/">AWS CloudHSM</a>, the <a href="https://docs.aws.amazon.com/cloudhsm/latest/userguide/">AWS CloudHSM User Guide</a>, and the <a href="https://docs.aws.amazon.com/cloudhsm/latest/APIReference/">AWS CloudHSM API Reference</a>.</p>
    /// <p>Retrieves the identifiers of all of the HSMs provisioned for the current customer.</p>
    /// <p>This operation supports pagination with the use of the <code>NextToken</code> member. If more results are available, the <code>NextToken</code> member of the response contains a token that you pass in the next call to <code>ListHsms</code> to retrieve the next set of items.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListHsms<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_hsms_input::Builder,
    }
    impl<C, M, R> ListHsms<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListHsms`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListHsmsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListHsmsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListHsmsInputOperationOutputAlias,
                crate::output::ListHsmsOutput,
                crate::error::ListHsmsError,
                crate::input::ListHsmsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The <code>NextToken</code> value from a previous call to <code>ListHsms</code>. Pass null if this is the first call.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The <code>NextToken</code> value from a previous call to <code>ListHsms</code>. Pass null if this is the first call.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListLunaClients`.
    ///
    /// <p>This is documentation for <b>AWS CloudHSM Classic</b>. For more information, see <a href="http://aws.amazon.com/cloudhsm/faqs-classic/">AWS CloudHSM Classic FAQs</a>, the <a href="https://docs.aws.amazon.com/cloudhsm/classic/userguide/">AWS CloudHSM Classic User Guide</a>, and the <a href="https://docs.aws.amazon.com/cloudhsm/classic/APIReference/">AWS CloudHSM Classic API Reference</a>.</p>
    /// <p> <b>For information about the current version of AWS CloudHSM</b>, see <a href="http://aws.amazon.com/cloudhsm/">AWS CloudHSM</a>, the <a href="https://docs.aws.amazon.com/cloudhsm/latest/userguide/">AWS CloudHSM User Guide</a>, and the <a href="https://docs.aws.amazon.com/cloudhsm/latest/APIReference/">AWS CloudHSM API Reference</a>.</p>
    /// <p>Lists all of the clients.</p>
    /// <p>This operation supports pagination with the use of the <code>NextToken</code> member. If more results are available, the <code>NextToken</code> member of the response contains a token that you pass in the next call to <code>ListLunaClients</code> to retrieve the next set of items.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListLunaClients<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_luna_clients_input::Builder,
    }
    impl<C, M, R> ListLunaClients<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListLunaClients`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListLunaClientsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListLunaClientsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListLunaClientsInputOperationOutputAlias,
                crate::output::ListLunaClientsOutput,
                crate::error::ListLunaClientsError,
                crate::input::ListLunaClientsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The <code>NextToken</code> value from a previous call to <code>ListLunaClients</code>. Pass null if this is the first call.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The <code>NextToken</code> value from a previous call to <code>ListLunaClients</code>. Pass null if this is the first call.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTagsForResource`.
    ///
    /// <p>This is documentation for <b>AWS CloudHSM Classic</b>. For more information, see <a href="http://aws.amazon.com/cloudhsm/faqs-classic/">AWS CloudHSM Classic FAQs</a>, the <a href="https://docs.aws.amazon.com/cloudhsm/classic/userguide/">AWS CloudHSM Classic User Guide</a>, and the <a href="https://docs.aws.amazon.com/cloudhsm/classic/APIReference/">AWS CloudHSM Classic API Reference</a>.</p>
    /// <p> <b>For information about the current version of AWS CloudHSM</b>, see <a href="http://aws.amazon.com/cloudhsm/">AWS CloudHSM</a>, the <a href="https://docs.aws.amazon.com/cloudhsm/latest/userguide/">AWS CloudHSM User Guide</a>, and the <a href="https://docs.aws.amazon.com/cloudhsm/latest/APIReference/">AWS CloudHSM API Reference</a>.</p>
    /// <p>Returns a list of all tags for the specified AWS CloudHSM resource.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListTagsForResource<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_tags_for_resource_input::Builder,
    }
    impl<C, M, R> ListTagsForResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListTagsForResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTagsForResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTagsForResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListTagsForResourceInputOperationOutputAlias,
                crate::output::ListTagsForResourceOutput,
                crate::error::ListTagsForResourceError,
                crate::input::ListTagsForResourceInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the AWS CloudHSM resource.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the AWS CloudHSM resource.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ModifyHapg`.
    ///
    /// <p>This is documentation for <b>AWS CloudHSM Classic</b>. For more information, see <a href="http://aws.amazon.com/cloudhsm/faqs-classic/">AWS CloudHSM Classic FAQs</a>, the <a href="https://docs.aws.amazon.com/cloudhsm/classic/userguide/">AWS CloudHSM Classic User Guide</a>, and the <a href="https://docs.aws.amazon.com/cloudhsm/classic/APIReference/">AWS CloudHSM Classic API Reference</a>.</p>
    /// <p> <b>For information about the current version of AWS CloudHSM</b>, see <a href="http://aws.amazon.com/cloudhsm/">AWS CloudHSM</a>, the <a href="https://docs.aws.amazon.com/cloudhsm/latest/userguide/">AWS CloudHSM User Guide</a>, and the <a href="https://docs.aws.amazon.com/cloudhsm/latest/APIReference/">AWS CloudHSM API Reference</a>.</p>
    /// <p>Modifies an existing high-availability partition group.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ModifyHapg<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::modify_hapg_input::Builder,
    }
    impl<C, M, R> ModifyHapg<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ModifyHapg`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ModifyHapgOutput,
            aws_smithy_http::result::SdkError<crate::error::ModifyHapgError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ModifyHapgInputOperationOutputAlias,
                crate::output::ModifyHapgOutput,
                crate::error::ModifyHapgError,
                crate::input::ModifyHapgInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the high-availability partition group to modify.</p>
        pub fn hapg_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.hapg_arn(input.into());
            self
        }
        /// <p>The ARN of the high-availability partition group to modify.</p>
        pub fn set_hapg_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_hapg_arn(input);
            self
        }
        /// <p>The new label for the high-availability partition group.</p>
        pub fn label(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.label(input.into());
            self
        }
        /// <p>The new label for the high-availability partition group.</p>
        pub fn set_label(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_label(input);
            self
        }
        /// Appends an item to `PartitionSerialList`.
        ///
        /// To override the contents of this collection use [`set_partition_serial_list`](Self::set_partition_serial_list).
        ///
        /// <p>The list of partition serial numbers to make members of the high-availability partition group.</p>
        pub fn partition_serial_list(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.partition_serial_list(input.into());
            self
        }
        /// <p>The list of partition serial numbers to make members of the high-availability partition group.</p>
        pub fn set_partition_serial_list(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_partition_serial_list(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ModifyHsm`.
    ///
    /// <p>This is documentation for <b>AWS CloudHSM Classic</b>. For more information, see <a href="http://aws.amazon.com/cloudhsm/faqs-classic/">AWS CloudHSM Classic FAQs</a>, the <a href="https://docs.aws.amazon.com/cloudhsm/classic/userguide/">AWS CloudHSM Classic User Guide</a>, and the <a href="https://docs.aws.amazon.com/cloudhsm/classic/APIReference/">AWS CloudHSM Classic API Reference</a>.</p>
    /// <p> <b>For information about the current version of AWS CloudHSM</b>, see <a href="http://aws.amazon.com/cloudhsm/">AWS CloudHSM</a>, the <a href="https://docs.aws.amazon.com/cloudhsm/latest/userguide/">AWS CloudHSM User Guide</a>, and the <a href="https://docs.aws.amazon.com/cloudhsm/latest/APIReference/">AWS CloudHSM API Reference</a>.</p>
    /// <p>Modifies an HSM.</p> <important>
    /// <p>This operation can result in the HSM being offline for up to 15 minutes while the AWS CloudHSM service is reconfigured. If you are modifying a production HSM, you should ensure that your AWS CloudHSM service is configured for high availability, and consider executing this operation during a maintenance window.</p>
    /// </important>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ModifyHsm<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::modify_hsm_input::Builder,
    }
    impl<C, M, R> ModifyHsm<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ModifyHsm`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ModifyHsmOutput,
            aws_smithy_http::result::SdkError<crate::error::ModifyHsmError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ModifyHsmInputOperationOutputAlias,
                crate::output::ModifyHsmOutput,
                crate::error::ModifyHsmError,
                crate::input::ModifyHsmInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the HSM to modify.</p>
        pub fn hsm_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.hsm_arn(input.into());
            self
        }
        /// <p>The ARN of the HSM to modify.</p>
        pub fn set_hsm_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_hsm_arn(input);
            self
        }
        /// <p>The new identifier of the subnet that the HSM is in. The new subnet must be in the same Availability Zone as the current subnet.</p>
        pub fn subnet_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.subnet_id(input.into());
            self
        }
        /// <p>The new identifier of the subnet that the HSM is in. The new subnet must be in the same Availability Zone as the current subnet.</p>
        pub fn set_subnet_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_subnet_id(input);
            self
        }
        /// <p>The new IP address for the elastic network interface (ENI) attached to the HSM.</p>
        /// <p>If the HSM is moved to a different subnet, and an IP address is not specified, an IP address will be randomly chosen from the CIDR range of the new subnet.</p>
        pub fn eni_ip(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.eni_ip(input.into());
            self
        }
        /// <p>The new IP address for the elastic network interface (ENI) attached to the HSM.</p>
        /// <p>If the HSM is moved to a different subnet, and an IP address is not specified, an IP address will be randomly chosen from the CIDR range of the new subnet.</p>
        pub fn set_eni_ip(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_eni_ip(input);
            self
        }
        /// <p>The new IAM role ARN.</p>
        pub fn iam_role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.iam_role_arn(input.into());
            self
        }
        /// <p>The new IAM role ARN.</p>
        pub fn set_iam_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_iam_role_arn(input);
            self
        }
        /// <p>The new external ID.</p>
        pub fn external_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.external_id(input.into());
            self
        }
        /// <p>The new external ID.</p>
        pub fn set_external_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_external_id(input);
            self
        }
        /// <p>The new IP address for the syslog monitoring server. The AWS CloudHSM service only supports one syslog monitoring server.</p>
        pub fn syslog_ip(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.syslog_ip(input.into());
            self
        }
        /// <p>The new IP address for the syslog monitoring server. The AWS CloudHSM service only supports one syslog monitoring server.</p>
        pub fn set_syslog_ip(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_syslog_ip(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ModifyLunaClient`.
    ///
    /// <p>This is documentation for <b>AWS CloudHSM Classic</b>. For more information, see <a href="http://aws.amazon.com/cloudhsm/faqs-classic/">AWS CloudHSM Classic FAQs</a>, the <a href="https://docs.aws.amazon.com/cloudhsm/classic/userguide/">AWS CloudHSM Classic User Guide</a>, and the <a href="https://docs.aws.amazon.com/cloudhsm/classic/APIReference/">AWS CloudHSM Classic API Reference</a>.</p>
    /// <p> <b>For information about the current version of AWS CloudHSM</b>, see <a href="http://aws.amazon.com/cloudhsm/">AWS CloudHSM</a>, the <a href="https://docs.aws.amazon.com/cloudhsm/latest/userguide/">AWS CloudHSM User Guide</a>, and the <a href="https://docs.aws.amazon.com/cloudhsm/latest/APIReference/">AWS CloudHSM API Reference</a>.</p>
    /// <p>Modifies the certificate used by the client.</p>
    /// <p>This action can potentially start a workflow to install the new certificate on the client's HSMs.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ModifyLunaClient<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::modify_luna_client_input::Builder,
    }
    impl<C, M, R> ModifyLunaClient<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ModifyLunaClient`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ModifyLunaClientOutput,
            aws_smithy_http::result::SdkError<crate::error::ModifyLunaClientError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ModifyLunaClientInputOperationOutputAlias,
                crate::output::ModifyLunaClientOutput,
                crate::error::ModifyLunaClientError,
                crate::input::ModifyLunaClientInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the client.</p>
        pub fn client_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_arn(input.into());
            self
        }
        /// <p>The ARN of the client.</p>
        pub fn set_client_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_arn(input);
            self
        }
        /// <p>The new certificate for the client.</p>
        pub fn certificate(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.certificate(input.into());
            self
        }
        /// <p>The new certificate for the client.</p>
        pub fn set_certificate(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_certificate(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RemoveTagsFromResource`.
    ///
    /// <p>This is documentation for <b>AWS CloudHSM Classic</b>. For more information, see <a href="http://aws.amazon.com/cloudhsm/faqs-classic/">AWS CloudHSM Classic FAQs</a>, the <a href="https://docs.aws.amazon.com/cloudhsm/classic/userguide/">AWS CloudHSM Classic User Guide</a>, and the <a href="https://docs.aws.amazon.com/cloudhsm/classic/APIReference/">AWS CloudHSM Classic API Reference</a>.</p>
    /// <p> <b>For information about the current version of AWS CloudHSM</b>, see <a href="http://aws.amazon.com/cloudhsm/">AWS CloudHSM</a>, the <a href="https://docs.aws.amazon.com/cloudhsm/latest/userguide/">AWS CloudHSM User Guide</a>, and the <a href="https://docs.aws.amazon.com/cloudhsm/latest/APIReference/">AWS CloudHSM API Reference</a>.</p>
    /// <p>Removes one or more tags from the specified AWS CloudHSM resource.</p>
    /// <p>To remove a tag, specify only the tag key to remove (not the value). To overwrite the value for an existing tag, use <code>AddTagsToResource</code>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct RemoveTagsFromResource<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::remove_tags_from_resource_input::Builder,
    }
    impl<C, M, R> RemoveTagsFromResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `RemoveTagsFromResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RemoveTagsFromResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::RemoveTagsFromResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::RemoveTagsFromResourceInputOperationOutputAlias,
                crate::output::RemoveTagsFromResourceOutput,
                crate::error::RemoveTagsFromResourceError,
                crate::input::RemoveTagsFromResourceInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the AWS CloudHSM resource.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the AWS CloudHSM resource.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `TagKeyList`.
        ///
        /// To override the contents of this collection use [`set_tag_key_list`](Self::set_tag_key_list).
        ///
        /// <p>The tag key or keys to remove.</p>
        /// <p>Specify only the tag key to remove (not the value). To overwrite the value for an existing tag, use <code>AddTagsToResource</code>.</p>
        pub fn tag_key_list(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_key_list(input.into());
            self
        }
        /// <p>The tag key or keys to remove.</p>
        /// <p>Specify only the tag key to remove (not the value). To overwrite the value for an existing tag, use <code>AddTagsToResource</code>.</p>
        pub fn set_tag_key_list(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_key_list(input);
            self
        }
    }
}

impl<C> Client<C, crate::middleware::DefaultMiddleware, aws_smithy_client::retry::Standard> {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn(conf: crate::Config, conn: C) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::new()
            .connector(conn)
            .middleware(crate::middleware::DefaultMiddleware::new());
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
impl
    Client<
        aws_smithy_client::erase::DynConnector,
        crate::middleware::DefaultMiddleware,
        aws_smithy_client::retry::Standard,
    >
{
    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(config: &aws_types::config::Config) -> Self {
        Self::from_conf(config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::dyn_https()
            .middleware(crate::middleware::DefaultMiddleware::new());
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        // the builder maintains a try-state. To avoid suppressing the warning when sleep is unset,
        // only set it if we actually have a sleep impl.
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();

        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
