// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Error type for the `AddTagsToResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct AddTagsToResourceError {
    /// Kind of error that occurred.
    pub kind: AddTagsToResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `AddTagsToResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum AddTagsToResourceErrorKind {
    /// <p>Indicates that an internal error occurred.</p>
    CloudHsmInternalException(crate::error::CloudHsmInternalException),
    /// <p>Indicates that an exception occurred in the AWS CloudHSM service.</p>
    CloudHsmServiceException(crate::error::CloudHsmServiceException),
    /// <p>Indicates that one or more of the request parameters are not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for AddTagsToResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            AddTagsToResourceErrorKind::CloudHsmInternalException(_inner) => _inner.fmt(f),
            AddTagsToResourceErrorKind::CloudHsmServiceException(_inner) => _inner.fmt(f),
            AddTagsToResourceErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            AddTagsToResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for AddTagsToResourceError {
    fn code(&self) -> Option<&str> {
        AddTagsToResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl AddTagsToResourceError {
    /// Creates a new `AddTagsToResourceError`.
    pub fn new(kind: AddTagsToResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `AddTagsToResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: AddTagsToResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `AddTagsToResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: AddTagsToResourceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `AddTagsToResourceErrorKind::CloudHsmInternalException`.
    pub fn is_cloud_hsm_internal_exception(&self) -> bool {
        matches!(
            &self.kind,
            AddTagsToResourceErrorKind::CloudHsmInternalException(_)
        )
    }
    /// Returns `true` if the error kind is `AddTagsToResourceErrorKind::CloudHsmServiceException`.
    pub fn is_cloud_hsm_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            AddTagsToResourceErrorKind::CloudHsmServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `AddTagsToResourceErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            AddTagsToResourceErrorKind::InvalidRequestException(_)
        )
    }
}
impl std::error::Error for AddTagsToResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            AddTagsToResourceErrorKind::CloudHsmInternalException(_inner) => Some(_inner),
            AddTagsToResourceErrorKind::CloudHsmServiceException(_inner) => Some(_inner),
            AddTagsToResourceErrorKind::InvalidRequestException(_inner) => Some(_inner),
            AddTagsToResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateHapg` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateHapgError {
    /// Kind of error that occurred.
    pub kind: CreateHapgErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateHapg` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateHapgErrorKind {
    /// <p>Indicates that an internal error occurred.</p>
    CloudHsmInternalException(crate::error::CloudHsmInternalException),
    /// <p>Indicates that an exception occurred in the AWS CloudHSM service.</p>
    CloudHsmServiceException(crate::error::CloudHsmServiceException),
    /// <p>Indicates that one or more of the request parameters are not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateHapgError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateHapgErrorKind::CloudHsmInternalException(_inner) => _inner.fmt(f),
            CreateHapgErrorKind::CloudHsmServiceException(_inner) => _inner.fmt(f),
            CreateHapgErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            CreateHapgErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateHapgError {
    fn code(&self) -> Option<&str> {
        CreateHapgError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateHapgError {
    /// Creates a new `CreateHapgError`.
    pub fn new(kind: CreateHapgErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateHapgError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateHapgErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateHapgError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateHapgErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateHapgErrorKind::CloudHsmInternalException`.
    pub fn is_cloud_hsm_internal_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateHapgErrorKind::CloudHsmInternalException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateHapgErrorKind::CloudHsmServiceException`.
    pub fn is_cloud_hsm_service_exception(&self) -> bool {
        matches!(&self.kind, CreateHapgErrorKind::CloudHsmServiceException(_))
    }
    /// Returns `true` if the error kind is `CreateHapgErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(&self.kind, CreateHapgErrorKind::InvalidRequestException(_))
    }
}
impl std::error::Error for CreateHapgError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateHapgErrorKind::CloudHsmInternalException(_inner) => Some(_inner),
            CreateHapgErrorKind::CloudHsmServiceException(_inner) => Some(_inner),
            CreateHapgErrorKind::InvalidRequestException(_inner) => Some(_inner),
            CreateHapgErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateHsm` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateHsmError {
    /// Kind of error that occurred.
    pub kind: CreateHsmErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateHsm` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateHsmErrorKind {
    /// <p>Indicates that an internal error occurred.</p>
    CloudHsmInternalException(crate::error::CloudHsmInternalException),
    /// <p>Indicates that an exception occurred in the AWS CloudHSM service.</p>
    CloudHsmServiceException(crate::error::CloudHsmServiceException),
    /// <p>Indicates that one or more of the request parameters are not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateHsmError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateHsmErrorKind::CloudHsmInternalException(_inner) => _inner.fmt(f),
            CreateHsmErrorKind::CloudHsmServiceException(_inner) => _inner.fmt(f),
            CreateHsmErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            CreateHsmErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateHsmError {
    fn code(&self) -> Option<&str> {
        CreateHsmError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateHsmError {
    /// Creates a new `CreateHsmError`.
    pub fn new(kind: CreateHsmErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateHsmError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateHsmErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateHsmError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateHsmErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateHsmErrorKind::CloudHsmInternalException`.
    pub fn is_cloud_hsm_internal_exception(&self) -> bool {
        matches!(&self.kind, CreateHsmErrorKind::CloudHsmInternalException(_))
    }
    /// Returns `true` if the error kind is `CreateHsmErrorKind::CloudHsmServiceException`.
    pub fn is_cloud_hsm_service_exception(&self) -> bool {
        matches!(&self.kind, CreateHsmErrorKind::CloudHsmServiceException(_))
    }
    /// Returns `true` if the error kind is `CreateHsmErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(&self.kind, CreateHsmErrorKind::InvalidRequestException(_))
    }
}
impl std::error::Error for CreateHsmError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateHsmErrorKind::CloudHsmInternalException(_inner) => Some(_inner),
            CreateHsmErrorKind::CloudHsmServiceException(_inner) => Some(_inner),
            CreateHsmErrorKind::InvalidRequestException(_inner) => Some(_inner),
            CreateHsmErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateLunaClient` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateLunaClientError {
    /// Kind of error that occurred.
    pub kind: CreateLunaClientErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateLunaClient` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateLunaClientErrorKind {
    /// <p>Indicates that an internal error occurred.</p>
    CloudHsmInternalException(crate::error::CloudHsmInternalException),
    /// <p>Indicates that an exception occurred in the AWS CloudHSM service.</p>
    CloudHsmServiceException(crate::error::CloudHsmServiceException),
    /// <p>Indicates that one or more of the request parameters are not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateLunaClientError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateLunaClientErrorKind::CloudHsmInternalException(_inner) => _inner.fmt(f),
            CreateLunaClientErrorKind::CloudHsmServiceException(_inner) => _inner.fmt(f),
            CreateLunaClientErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            CreateLunaClientErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateLunaClientError {
    fn code(&self) -> Option<&str> {
        CreateLunaClientError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateLunaClientError {
    /// Creates a new `CreateLunaClientError`.
    pub fn new(kind: CreateLunaClientErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateLunaClientError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateLunaClientErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateLunaClientError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateLunaClientErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateLunaClientErrorKind::CloudHsmInternalException`.
    pub fn is_cloud_hsm_internal_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateLunaClientErrorKind::CloudHsmInternalException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateLunaClientErrorKind::CloudHsmServiceException`.
    pub fn is_cloud_hsm_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateLunaClientErrorKind::CloudHsmServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateLunaClientErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateLunaClientErrorKind::InvalidRequestException(_)
        )
    }
}
impl std::error::Error for CreateLunaClientError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateLunaClientErrorKind::CloudHsmInternalException(_inner) => Some(_inner),
            CreateLunaClientErrorKind::CloudHsmServiceException(_inner) => Some(_inner),
            CreateLunaClientErrorKind::InvalidRequestException(_inner) => Some(_inner),
            CreateLunaClientErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteHapg` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteHapgError {
    /// Kind of error that occurred.
    pub kind: DeleteHapgErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteHapg` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteHapgErrorKind {
    /// <p>Indicates that an internal error occurred.</p>
    CloudHsmInternalException(crate::error::CloudHsmInternalException),
    /// <p>Indicates that an exception occurred in the AWS CloudHSM service.</p>
    CloudHsmServiceException(crate::error::CloudHsmServiceException),
    /// <p>Indicates that one or more of the request parameters are not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteHapgError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteHapgErrorKind::CloudHsmInternalException(_inner) => _inner.fmt(f),
            DeleteHapgErrorKind::CloudHsmServiceException(_inner) => _inner.fmt(f),
            DeleteHapgErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            DeleteHapgErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteHapgError {
    fn code(&self) -> Option<&str> {
        DeleteHapgError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteHapgError {
    /// Creates a new `DeleteHapgError`.
    pub fn new(kind: DeleteHapgErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteHapgError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteHapgErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteHapgError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteHapgErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteHapgErrorKind::CloudHsmInternalException`.
    pub fn is_cloud_hsm_internal_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteHapgErrorKind::CloudHsmInternalException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteHapgErrorKind::CloudHsmServiceException`.
    pub fn is_cloud_hsm_service_exception(&self) -> bool {
        matches!(&self.kind, DeleteHapgErrorKind::CloudHsmServiceException(_))
    }
    /// Returns `true` if the error kind is `DeleteHapgErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(&self.kind, DeleteHapgErrorKind::InvalidRequestException(_))
    }
}
impl std::error::Error for DeleteHapgError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteHapgErrorKind::CloudHsmInternalException(_inner) => Some(_inner),
            DeleteHapgErrorKind::CloudHsmServiceException(_inner) => Some(_inner),
            DeleteHapgErrorKind::InvalidRequestException(_inner) => Some(_inner),
            DeleteHapgErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteHsm` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteHsmError {
    /// Kind of error that occurred.
    pub kind: DeleteHsmErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteHsm` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteHsmErrorKind {
    /// <p>Indicates that an internal error occurred.</p>
    CloudHsmInternalException(crate::error::CloudHsmInternalException),
    /// <p>Indicates that an exception occurred in the AWS CloudHSM service.</p>
    CloudHsmServiceException(crate::error::CloudHsmServiceException),
    /// <p>Indicates that one or more of the request parameters are not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteHsmError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteHsmErrorKind::CloudHsmInternalException(_inner) => _inner.fmt(f),
            DeleteHsmErrorKind::CloudHsmServiceException(_inner) => _inner.fmt(f),
            DeleteHsmErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            DeleteHsmErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteHsmError {
    fn code(&self) -> Option<&str> {
        DeleteHsmError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteHsmError {
    /// Creates a new `DeleteHsmError`.
    pub fn new(kind: DeleteHsmErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteHsmError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteHsmErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteHsmError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteHsmErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteHsmErrorKind::CloudHsmInternalException`.
    pub fn is_cloud_hsm_internal_exception(&self) -> bool {
        matches!(&self.kind, DeleteHsmErrorKind::CloudHsmInternalException(_))
    }
    /// Returns `true` if the error kind is `DeleteHsmErrorKind::CloudHsmServiceException`.
    pub fn is_cloud_hsm_service_exception(&self) -> bool {
        matches!(&self.kind, DeleteHsmErrorKind::CloudHsmServiceException(_))
    }
    /// Returns `true` if the error kind is `DeleteHsmErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(&self.kind, DeleteHsmErrorKind::InvalidRequestException(_))
    }
}
impl std::error::Error for DeleteHsmError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteHsmErrorKind::CloudHsmInternalException(_inner) => Some(_inner),
            DeleteHsmErrorKind::CloudHsmServiceException(_inner) => Some(_inner),
            DeleteHsmErrorKind::InvalidRequestException(_inner) => Some(_inner),
            DeleteHsmErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteLunaClient` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteLunaClientError {
    /// Kind of error that occurred.
    pub kind: DeleteLunaClientErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteLunaClient` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteLunaClientErrorKind {
    /// <p>Indicates that an internal error occurred.</p>
    CloudHsmInternalException(crate::error::CloudHsmInternalException),
    /// <p>Indicates that an exception occurred in the AWS CloudHSM service.</p>
    CloudHsmServiceException(crate::error::CloudHsmServiceException),
    /// <p>Indicates that one or more of the request parameters are not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteLunaClientError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteLunaClientErrorKind::CloudHsmInternalException(_inner) => _inner.fmt(f),
            DeleteLunaClientErrorKind::CloudHsmServiceException(_inner) => _inner.fmt(f),
            DeleteLunaClientErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            DeleteLunaClientErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteLunaClientError {
    fn code(&self) -> Option<&str> {
        DeleteLunaClientError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteLunaClientError {
    /// Creates a new `DeleteLunaClientError`.
    pub fn new(kind: DeleteLunaClientErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteLunaClientError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteLunaClientErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteLunaClientError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteLunaClientErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteLunaClientErrorKind::CloudHsmInternalException`.
    pub fn is_cloud_hsm_internal_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteLunaClientErrorKind::CloudHsmInternalException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteLunaClientErrorKind::CloudHsmServiceException`.
    pub fn is_cloud_hsm_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteLunaClientErrorKind::CloudHsmServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteLunaClientErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteLunaClientErrorKind::InvalidRequestException(_)
        )
    }
}
impl std::error::Error for DeleteLunaClientError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteLunaClientErrorKind::CloudHsmInternalException(_inner) => Some(_inner),
            DeleteLunaClientErrorKind::CloudHsmServiceException(_inner) => Some(_inner),
            DeleteLunaClientErrorKind::InvalidRequestException(_inner) => Some(_inner),
            DeleteLunaClientErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeHapg` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeHapgError {
    /// Kind of error that occurred.
    pub kind: DescribeHapgErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeHapg` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeHapgErrorKind {
    /// <p>Indicates that an internal error occurred.</p>
    CloudHsmInternalException(crate::error::CloudHsmInternalException),
    /// <p>Indicates that an exception occurred in the AWS CloudHSM service.</p>
    CloudHsmServiceException(crate::error::CloudHsmServiceException),
    /// <p>Indicates that one or more of the request parameters are not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeHapgError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeHapgErrorKind::CloudHsmInternalException(_inner) => _inner.fmt(f),
            DescribeHapgErrorKind::CloudHsmServiceException(_inner) => _inner.fmt(f),
            DescribeHapgErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            DescribeHapgErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeHapgError {
    fn code(&self) -> Option<&str> {
        DescribeHapgError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeHapgError {
    /// Creates a new `DescribeHapgError`.
    pub fn new(kind: DescribeHapgErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeHapgError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeHapgErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeHapgError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeHapgErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeHapgErrorKind::CloudHsmInternalException`.
    pub fn is_cloud_hsm_internal_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeHapgErrorKind::CloudHsmInternalException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeHapgErrorKind::CloudHsmServiceException`.
    pub fn is_cloud_hsm_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeHapgErrorKind::CloudHsmServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeHapgErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeHapgErrorKind::InvalidRequestException(_)
        )
    }
}
impl std::error::Error for DescribeHapgError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeHapgErrorKind::CloudHsmInternalException(_inner) => Some(_inner),
            DescribeHapgErrorKind::CloudHsmServiceException(_inner) => Some(_inner),
            DescribeHapgErrorKind::InvalidRequestException(_inner) => Some(_inner),
            DescribeHapgErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeHsm` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeHsmError {
    /// Kind of error that occurred.
    pub kind: DescribeHsmErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeHsm` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeHsmErrorKind {
    /// <p>Indicates that an internal error occurred.</p>
    CloudHsmInternalException(crate::error::CloudHsmInternalException),
    /// <p>Indicates that an exception occurred in the AWS CloudHSM service.</p>
    CloudHsmServiceException(crate::error::CloudHsmServiceException),
    /// <p>Indicates that one or more of the request parameters are not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeHsmError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeHsmErrorKind::CloudHsmInternalException(_inner) => _inner.fmt(f),
            DescribeHsmErrorKind::CloudHsmServiceException(_inner) => _inner.fmt(f),
            DescribeHsmErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            DescribeHsmErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeHsmError {
    fn code(&self) -> Option<&str> {
        DescribeHsmError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeHsmError {
    /// Creates a new `DescribeHsmError`.
    pub fn new(kind: DescribeHsmErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeHsmError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeHsmErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeHsmError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeHsmErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeHsmErrorKind::CloudHsmInternalException`.
    pub fn is_cloud_hsm_internal_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeHsmErrorKind::CloudHsmInternalException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeHsmErrorKind::CloudHsmServiceException`.
    pub fn is_cloud_hsm_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeHsmErrorKind::CloudHsmServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeHsmErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(&self.kind, DescribeHsmErrorKind::InvalidRequestException(_))
    }
}
impl std::error::Error for DescribeHsmError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeHsmErrorKind::CloudHsmInternalException(_inner) => Some(_inner),
            DescribeHsmErrorKind::CloudHsmServiceException(_inner) => Some(_inner),
            DescribeHsmErrorKind::InvalidRequestException(_inner) => Some(_inner),
            DescribeHsmErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeLunaClient` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeLunaClientError {
    /// Kind of error that occurred.
    pub kind: DescribeLunaClientErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeLunaClient` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeLunaClientErrorKind {
    /// <p>Indicates that an internal error occurred.</p>
    CloudHsmInternalException(crate::error::CloudHsmInternalException),
    /// <p>Indicates that an exception occurred in the AWS CloudHSM service.</p>
    CloudHsmServiceException(crate::error::CloudHsmServiceException),
    /// <p>Indicates that one or more of the request parameters are not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeLunaClientError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeLunaClientErrorKind::CloudHsmInternalException(_inner) => _inner.fmt(f),
            DescribeLunaClientErrorKind::CloudHsmServiceException(_inner) => _inner.fmt(f),
            DescribeLunaClientErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            DescribeLunaClientErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeLunaClientError {
    fn code(&self) -> Option<&str> {
        DescribeLunaClientError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeLunaClientError {
    /// Creates a new `DescribeLunaClientError`.
    pub fn new(kind: DescribeLunaClientErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeLunaClientError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeLunaClientErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeLunaClientError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeLunaClientErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeLunaClientErrorKind::CloudHsmInternalException`.
    pub fn is_cloud_hsm_internal_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeLunaClientErrorKind::CloudHsmInternalException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeLunaClientErrorKind::CloudHsmServiceException`.
    pub fn is_cloud_hsm_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeLunaClientErrorKind::CloudHsmServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeLunaClientErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeLunaClientErrorKind::InvalidRequestException(_)
        )
    }
}
impl std::error::Error for DescribeLunaClientError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeLunaClientErrorKind::CloudHsmInternalException(_inner) => Some(_inner),
            DescribeLunaClientErrorKind::CloudHsmServiceException(_inner) => Some(_inner),
            DescribeLunaClientErrorKind::InvalidRequestException(_inner) => Some(_inner),
            DescribeLunaClientErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetConfig` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetConfigError {
    /// Kind of error that occurred.
    pub kind: GetConfigErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetConfig` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetConfigErrorKind {
    /// <p>Indicates that an internal error occurred.</p>
    CloudHsmInternalException(crate::error::CloudHsmInternalException),
    /// <p>Indicates that an exception occurred in the AWS CloudHSM service.</p>
    CloudHsmServiceException(crate::error::CloudHsmServiceException),
    /// <p>Indicates that one or more of the request parameters are not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetConfigError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetConfigErrorKind::CloudHsmInternalException(_inner) => _inner.fmt(f),
            GetConfigErrorKind::CloudHsmServiceException(_inner) => _inner.fmt(f),
            GetConfigErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            GetConfigErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetConfigError {
    fn code(&self) -> Option<&str> {
        GetConfigError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetConfigError {
    /// Creates a new `GetConfigError`.
    pub fn new(kind: GetConfigErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetConfigError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetConfigErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetConfigError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetConfigErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetConfigErrorKind::CloudHsmInternalException`.
    pub fn is_cloud_hsm_internal_exception(&self) -> bool {
        matches!(&self.kind, GetConfigErrorKind::CloudHsmInternalException(_))
    }
    /// Returns `true` if the error kind is `GetConfigErrorKind::CloudHsmServiceException`.
    pub fn is_cloud_hsm_service_exception(&self) -> bool {
        matches!(&self.kind, GetConfigErrorKind::CloudHsmServiceException(_))
    }
    /// Returns `true` if the error kind is `GetConfigErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(&self.kind, GetConfigErrorKind::InvalidRequestException(_))
    }
}
impl std::error::Error for GetConfigError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetConfigErrorKind::CloudHsmInternalException(_inner) => Some(_inner),
            GetConfigErrorKind::CloudHsmServiceException(_inner) => Some(_inner),
            GetConfigErrorKind::InvalidRequestException(_inner) => Some(_inner),
            GetConfigErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListAvailableZones` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListAvailableZonesError {
    /// Kind of error that occurred.
    pub kind: ListAvailableZonesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListAvailableZones` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListAvailableZonesErrorKind {
    /// <p>Indicates that an internal error occurred.</p>
    CloudHsmInternalException(crate::error::CloudHsmInternalException),
    /// <p>Indicates that an exception occurred in the AWS CloudHSM service.</p>
    CloudHsmServiceException(crate::error::CloudHsmServiceException),
    /// <p>Indicates that one or more of the request parameters are not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListAvailableZonesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListAvailableZonesErrorKind::CloudHsmInternalException(_inner) => _inner.fmt(f),
            ListAvailableZonesErrorKind::CloudHsmServiceException(_inner) => _inner.fmt(f),
            ListAvailableZonesErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            ListAvailableZonesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListAvailableZonesError {
    fn code(&self) -> Option<&str> {
        ListAvailableZonesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListAvailableZonesError {
    /// Creates a new `ListAvailableZonesError`.
    pub fn new(kind: ListAvailableZonesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListAvailableZonesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListAvailableZonesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListAvailableZonesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListAvailableZonesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListAvailableZonesErrorKind::CloudHsmInternalException`.
    pub fn is_cloud_hsm_internal_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListAvailableZonesErrorKind::CloudHsmInternalException(_)
        )
    }
    /// Returns `true` if the error kind is `ListAvailableZonesErrorKind::CloudHsmServiceException`.
    pub fn is_cloud_hsm_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListAvailableZonesErrorKind::CloudHsmServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `ListAvailableZonesErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListAvailableZonesErrorKind::InvalidRequestException(_)
        )
    }
}
impl std::error::Error for ListAvailableZonesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListAvailableZonesErrorKind::CloudHsmInternalException(_inner) => Some(_inner),
            ListAvailableZonesErrorKind::CloudHsmServiceException(_inner) => Some(_inner),
            ListAvailableZonesErrorKind::InvalidRequestException(_inner) => Some(_inner),
            ListAvailableZonesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListHapgs` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListHapgsError {
    /// Kind of error that occurred.
    pub kind: ListHapgsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListHapgs` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListHapgsErrorKind {
    /// <p>Indicates that an internal error occurred.</p>
    CloudHsmInternalException(crate::error::CloudHsmInternalException),
    /// <p>Indicates that an exception occurred in the AWS CloudHSM service.</p>
    CloudHsmServiceException(crate::error::CloudHsmServiceException),
    /// <p>Indicates that one or more of the request parameters are not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListHapgsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListHapgsErrorKind::CloudHsmInternalException(_inner) => _inner.fmt(f),
            ListHapgsErrorKind::CloudHsmServiceException(_inner) => _inner.fmt(f),
            ListHapgsErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            ListHapgsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListHapgsError {
    fn code(&self) -> Option<&str> {
        ListHapgsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListHapgsError {
    /// Creates a new `ListHapgsError`.
    pub fn new(kind: ListHapgsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListHapgsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListHapgsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListHapgsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListHapgsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListHapgsErrorKind::CloudHsmInternalException`.
    pub fn is_cloud_hsm_internal_exception(&self) -> bool {
        matches!(&self.kind, ListHapgsErrorKind::CloudHsmInternalException(_))
    }
    /// Returns `true` if the error kind is `ListHapgsErrorKind::CloudHsmServiceException`.
    pub fn is_cloud_hsm_service_exception(&self) -> bool {
        matches!(&self.kind, ListHapgsErrorKind::CloudHsmServiceException(_))
    }
    /// Returns `true` if the error kind is `ListHapgsErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(&self.kind, ListHapgsErrorKind::InvalidRequestException(_))
    }
}
impl std::error::Error for ListHapgsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListHapgsErrorKind::CloudHsmInternalException(_inner) => Some(_inner),
            ListHapgsErrorKind::CloudHsmServiceException(_inner) => Some(_inner),
            ListHapgsErrorKind::InvalidRequestException(_inner) => Some(_inner),
            ListHapgsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListHsms` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListHsmsError {
    /// Kind of error that occurred.
    pub kind: ListHsmsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListHsms` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListHsmsErrorKind {
    /// <p>Indicates that an internal error occurred.</p>
    CloudHsmInternalException(crate::error::CloudHsmInternalException),
    /// <p>Indicates that an exception occurred in the AWS CloudHSM service.</p>
    CloudHsmServiceException(crate::error::CloudHsmServiceException),
    /// <p>Indicates that one or more of the request parameters are not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListHsmsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListHsmsErrorKind::CloudHsmInternalException(_inner) => _inner.fmt(f),
            ListHsmsErrorKind::CloudHsmServiceException(_inner) => _inner.fmt(f),
            ListHsmsErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            ListHsmsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListHsmsError {
    fn code(&self) -> Option<&str> {
        ListHsmsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListHsmsError {
    /// Creates a new `ListHsmsError`.
    pub fn new(kind: ListHsmsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListHsmsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListHsmsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListHsmsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListHsmsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListHsmsErrorKind::CloudHsmInternalException`.
    pub fn is_cloud_hsm_internal_exception(&self) -> bool {
        matches!(&self.kind, ListHsmsErrorKind::CloudHsmInternalException(_))
    }
    /// Returns `true` if the error kind is `ListHsmsErrorKind::CloudHsmServiceException`.
    pub fn is_cloud_hsm_service_exception(&self) -> bool {
        matches!(&self.kind, ListHsmsErrorKind::CloudHsmServiceException(_))
    }
    /// Returns `true` if the error kind is `ListHsmsErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(&self.kind, ListHsmsErrorKind::InvalidRequestException(_))
    }
}
impl std::error::Error for ListHsmsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListHsmsErrorKind::CloudHsmInternalException(_inner) => Some(_inner),
            ListHsmsErrorKind::CloudHsmServiceException(_inner) => Some(_inner),
            ListHsmsErrorKind::InvalidRequestException(_inner) => Some(_inner),
            ListHsmsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListLunaClients` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListLunaClientsError {
    /// Kind of error that occurred.
    pub kind: ListLunaClientsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListLunaClients` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListLunaClientsErrorKind {
    /// <p>Indicates that an internal error occurred.</p>
    CloudHsmInternalException(crate::error::CloudHsmInternalException),
    /// <p>Indicates that an exception occurred in the AWS CloudHSM service.</p>
    CloudHsmServiceException(crate::error::CloudHsmServiceException),
    /// <p>Indicates that one or more of the request parameters are not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListLunaClientsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListLunaClientsErrorKind::CloudHsmInternalException(_inner) => _inner.fmt(f),
            ListLunaClientsErrorKind::CloudHsmServiceException(_inner) => _inner.fmt(f),
            ListLunaClientsErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            ListLunaClientsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListLunaClientsError {
    fn code(&self) -> Option<&str> {
        ListLunaClientsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListLunaClientsError {
    /// Creates a new `ListLunaClientsError`.
    pub fn new(kind: ListLunaClientsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListLunaClientsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListLunaClientsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListLunaClientsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListLunaClientsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListLunaClientsErrorKind::CloudHsmInternalException`.
    pub fn is_cloud_hsm_internal_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListLunaClientsErrorKind::CloudHsmInternalException(_)
        )
    }
    /// Returns `true` if the error kind is `ListLunaClientsErrorKind::CloudHsmServiceException`.
    pub fn is_cloud_hsm_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListLunaClientsErrorKind::CloudHsmServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `ListLunaClientsErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListLunaClientsErrorKind::InvalidRequestException(_)
        )
    }
}
impl std::error::Error for ListLunaClientsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListLunaClientsErrorKind::CloudHsmInternalException(_inner) => Some(_inner),
            ListLunaClientsErrorKind::CloudHsmServiceException(_inner) => Some(_inner),
            ListLunaClientsErrorKind::InvalidRequestException(_inner) => Some(_inner),
            ListLunaClientsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListTagsForResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListTagsForResourceError {
    /// Kind of error that occurred.
    pub kind: ListTagsForResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListTagsForResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListTagsForResourceErrorKind {
    /// <p>Indicates that an internal error occurred.</p>
    CloudHsmInternalException(crate::error::CloudHsmInternalException),
    /// <p>Indicates that an exception occurred in the AWS CloudHSM service.</p>
    CloudHsmServiceException(crate::error::CloudHsmServiceException),
    /// <p>Indicates that one or more of the request parameters are not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListTagsForResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListTagsForResourceErrorKind::CloudHsmInternalException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::CloudHsmServiceException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListTagsForResourceError {
    fn code(&self) -> Option<&str> {
        ListTagsForResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListTagsForResourceError {
    /// Creates a new `ListTagsForResourceError`.
    pub fn new(kind: ListTagsForResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListTagsForResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListTagsForResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListTagsForResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListTagsForResourceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::CloudHsmInternalException`.
    pub fn is_cloud_hsm_internal_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::CloudHsmInternalException(_)
        )
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::CloudHsmServiceException`.
    pub fn is_cloud_hsm_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::CloudHsmServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::InvalidRequestException(_)
        )
    }
}
impl std::error::Error for ListTagsForResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListTagsForResourceErrorKind::CloudHsmInternalException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::CloudHsmServiceException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::InvalidRequestException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ModifyHapg` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ModifyHapgError {
    /// Kind of error that occurred.
    pub kind: ModifyHapgErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ModifyHapg` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ModifyHapgErrorKind {
    /// <p>Indicates that an internal error occurred.</p>
    CloudHsmInternalException(crate::error::CloudHsmInternalException),
    /// <p>Indicates that an exception occurred in the AWS CloudHSM service.</p>
    CloudHsmServiceException(crate::error::CloudHsmServiceException),
    /// <p>Indicates that one or more of the request parameters are not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ModifyHapgError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ModifyHapgErrorKind::CloudHsmInternalException(_inner) => _inner.fmt(f),
            ModifyHapgErrorKind::CloudHsmServiceException(_inner) => _inner.fmt(f),
            ModifyHapgErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            ModifyHapgErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ModifyHapgError {
    fn code(&self) -> Option<&str> {
        ModifyHapgError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ModifyHapgError {
    /// Creates a new `ModifyHapgError`.
    pub fn new(kind: ModifyHapgErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ModifyHapgError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ModifyHapgErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ModifyHapgError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ModifyHapgErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ModifyHapgErrorKind::CloudHsmInternalException`.
    pub fn is_cloud_hsm_internal_exception(&self) -> bool {
        matches!(
            &self.kind,
            ModifyHapgErrorKind::CloudHsmInternalException(_)
        )
    }
    /// Returns `true` if the error kind is `ModifyHapgErrorKind::CloudHsmServiceException`.
    pub fn is_cloud_hsm_service_exception(&self) -> bool {
        matches!(&self.kind, ModifyHapgErrorKind::CloudHsmServiceException(_))
    }
    /// Returns `true` if the error kind is `ModifyHapgErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(&self.kind, ModifyHapgErrorKind::InvalidRequestException(_))
    }
}
impl std::error::Error for ModifyHapgError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ModifyHapgErrorKind::CloudHsmInternalException(_inner) => Some(_inner),
            ModifyHapgErrorKind::CloudHsmServiceException(_inner) => Some(_inner),
            ModifyHapgErrorKind::InvalidRequestException(_inner) => Some(_inner),
            ModifyHapgErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ModifyHsm` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ModifyHsmError {
    /// Kind of error that occurred.
    pub kind: ModifyHsmErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ModifyHsm` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ModifyHsmErrorKind {
    /// <p>Indicates that an internal error occurred.</p>
    CloudHsmInternalException(crate::error::CloudHsmInternalException),
    /// <p>Indicates that an exception occurred in the AWS CloudHSM service.</p>
    CloudHsmServiceException(crate::error::CloudHsmServiceException),
    /// <p>Indicates that one or more of the request parameters are not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ModifyHsmError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ModifyHsmErrorKind::CloudHsmInternalException(_inner) => _inner.fmt(f),
            ModifyHsmErrorKind::CloudHsmServiceException(_inner) => _inner.fmt(f),
            ModifyHsmErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            ModifyHsmErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ModifyHsmError {
    fn code(&self) -> Option<&str> {
        ModifyHsmError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ModifyHsmError {
    /// Creates a new `ModifyHsmError`.
    pub fn new(kind: ModifyHsmErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ModifyHsmError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ModifyHsmErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ModifyHsmError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ModifyHsmErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ModifyHsmErrorKind::CloudHsmInternalException`.
    pub fn is_cloud_hsm_internal_exception(&self) -> bool {
        matches!(&self.kind, ModifyHsmErrorKind::CloudHsmInternalException(_))
    }
    /// Returns `true` if the error kind is `ModifyHsmErrorKind::CloudHsmServiceException`.
    pub fn is_cloud_hsm_service_exception(&self) -> bool {
        matches!(&self.kind, ModifyHsmErrorKind::CloudHsmServiceException(_))
    }
    /// Returns `true` if the error kind is `ModifyHsmErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(&self.kind, ModifyHsmErrorKind::InvalidRequestException(_))
    }
}
impl std::error::Error for ModifyHsmError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ModifyHsmErrorKind::CloudHsmInternalException(_inner) => Some(_inner),
            ModifyHsmErrorKind::CloudHsmServiceException(_inner) => Some(_inner),
            ModifyHsmErrorKind::InvalidRequestException(_inner) => Some(_inner),
            ModifyHsmErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ModifyLunaClient` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ModifyLunaClientError {
    /// Kind of error that occurred.
    pub kind: ModifyLunaClientErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ModifyLunaClient` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ModifyLunaClientErrorKind {
    /// <p>Indicates that an exception occurred in the AWS CloudHSM service.</p>
    CloudHsmServiceException(crate::error::CloudHsmServiceException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ModifyLunaClientError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ModifyLunaClientErrorKind::CloudHsmServiceException(_inner) => _inner.fmt(f),
            ModifyLunaClientErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ModifyLunaClientError {
    fn code(&self) -> Option<&str> {
        ModifyLunaClientError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ModifyLunaClientError {
    /// Creates a new `ModifyLunaClientError`.
    pub fn new(kind: ModifyLunaClientErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ModifyLunaClientError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ModifyLunaClientErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ModifyLunaClientError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ModifyLunaClientErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ModifyLunaClientErrorKind::CloudHsmServiceException`.
    pub fn is_cloud_hsm_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            ModifyLunaClientErrorKind::CloudHsmServiceException(_)
        )
    }
}
impl std::error::Error for ModifyLunaClientError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ModifyLunaClientErrorKind::CloudHsmServiceException(_inner) => Some(_inner),
            ModifyLunaClientErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `RemoveTagsFromResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct RemoveTagsFromResourceError {
    /// Kind of error that occurred.
    pub kind: RemoveTagsFromResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `RemoveTagsFromResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum RemoveTagsFromResourceErrorKind {
    /// <p>Indicates that an internal error occurred.</p>
    CloudHsmInternalException(crate::error::CloudHsmInternalException),
    /// <p>Indicates that an exception occurred in the AWS CloudHSM service.</p>
    CloudHsmServiceException(crate::error::CloudHsmServiceException),
    /// <p>Indicates that one or more of the request parameters are not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for RemoveTagsFromResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            RemoveTagsFromResourceErrorKind::CloudHsmInternalException(_inner) => _inner.fmt(f),
            RemoveTagsFromResourceErrorKind::CloudHsmServiceException(_inner) => _inner.fmt(f),
            RemoveTagsFromResourceErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            RemoveTagsFromResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for RemoveTagsFromResourceError {
    fn code(&self) -> Option<&str> {
        RemoveTagsFromResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl RemoveTagsFromResourceError {
    /// Creates a new `RemoveTagsFromResourceError`.
    pub fn new(kind: RemoveTagsFromResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `RemoveTagsFromResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: RemoveTagsFromResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `RemoveTagsFromResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: RemoveTagsFromResourceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `RemoveTagsFromResourceErrorKind::CloudHsmInternalException`.
    pub fn is_cloud_hsm_internal_exception(&self) -> bool {
        matches!(
            &self.kind,
            RemoveTagsFromResourceErrorKind::CloudHsmInternalException(_)
        )
    }
    /// Returns `true` if the error kind is `RemoveTagsFromResourceErrorKind::CloudHsmServiceException`.
    pub fn is_cloud_hsm_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            RemoveTagsFromResourceErrorKind::CloudHsmServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `RemoveTagsFromResourceErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            RemoveTagsFromResourceErrorKind::InvalidRequestException(_)
        )
    }
}
impl std::error::Error for RemoveTagsFromResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            RemoveTagsFromResourceErrorKind::CloudHsmInternalException(_inner) => Some(_inner),
            RemoveTagsFromResourceErrorKind::CloudHsmServiceException(_inner) => Some(_inner),
            RemoveTagsFromResourceErrorKind::InvalidRequestException(_inner) => Some(_inner),
            RemoveTagsFromResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// <p>Indicates that one or more of the request parameters are not valid.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidRequestException {
    /// <p>Additional information about the error.</p>
    pub message: std::option::Option<std::string::String>,
    /// <p>Indicates if the action can be retried.</p>
    pub retryable: bool,
}
impl InvalidRequestException {
    /// <p>Indicates if the action can be retried.</p>
    pub fn retryable(&self) -> bool {
        self.retryable
    }
}
impl std::fmt::Debug for InvalidRequestException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidRequestException");
        formatter.field("message", &self.message);
        formatter.field("retryable", &self.retryable);
        formatter.finish()
    }
}
impl InvalidRequestException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidRequestException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidRequestException")?;
        if let Some(inner_1) = &self.message {
            write!(f, ": {}", inner_1)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidRequestException {}
/// See [`InvalidRequestException`](crate::error::InvalidRequestException)
pub mod invalid_request_exception {
    /// A builder for [`InvalidRequestException`](crate::error::InvalidRequestException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) retryable: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>Additional information about the error.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>Additional information about the error.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p>Indicates if the action can be retried.</p>
        pub fn retryable(mut self, input: bool) -> Self {
            self.retryable = Some(input);
            self
        }
        /// <p>Indicates if the action can be retried.</p>
        pub fn set_retryable(mut self, input: std::option::Option<bool>) -> Self {
            self.retryable = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidRequestException`](crate::error::InvalidRequestException)
        pub fn build(self) -> crate::error::InvalidRequestException {
            crate::error::InvalidRequestException {
                message: self.message,
                retryable: self.retryable.unwrap_or_default(),
            }
        }
    }
}
impl InvalidRequestException {
    /// Creates a new builder-style object to manufacture [`InvalidRequestException`](crate::error::InvalidRequestException)
    pub fn builder() -> crate::error::invalid_request_exception::Builder {
        crate::error::invalid_request_exception::Builder::default()
    }
}

/// <p>Indicates that an exception occurred in the AWS CloudHSM service.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CloudHsmServiceException {
    /// <p>Additional information about the error.</p>
    pub message: std::option::Option<std::string::String>,
    /// <p>Indicates if the action can be retried.</p>
    pub retryable: bool,
}
impl CloudHsmServiceException {
    /// <p>Indicates if the action can be retried.</p>
    pub fn retryable(&self) -> bool {
        self.retryable
    }
}
impl std::fmt::Debug for CloudHsmServiceException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CloudHsmServiceException");
        formatter.field("message", &self.message);
        formatter.field("retryable", &self.retryable);
        formatter.finish()
    }
}
impl CloudHsmServiceException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for CloudHsmServiceException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "CloudHsmServiceException")?;
        if let Some(inner_2) = &self.message {
            write!(f, ": {}", inner_2)?;
        }
        Ok(())
    }
}
impl std::error::Error for CloudHsmServiceException {}
/// See [`CloudHsmServiceException`](crate::error::CloudHsmServiceException)
pub mod cloud_hsm_service_exception {
    /// A builder for [`CloudHsmServiceException`](crate::error::CloudHsmServiceException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) retryable: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>Additional information about the error.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>Additional information about the error.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p>Indicates if the action can be retried.</p>
        pub fn retryable(mut self, input: bool) -> Self {
            self.retryable = Some(input);
            self
        }
        /// <p>Indicates if the action can be retried.</p>
        pub fn set_retryable(mut self, input: std::option::Option<bool>) -> Self {
            self.retryable = input;
            self
        }
        /// Consumes the builder and constructs a [`CloudHsmServiceException`](crate::error::CloudHsmServiceException)
        pub fn build(self) -> crate::error::CloudHsmServiceException {
            crate::error::CloudHsmServiceException {
                message: self.message,
                retryable: self.retryable.unwrap_or_default(),
            }
        }
    }
}
impl CloudHsmServiceException {
    /// Creates a new builder-style object to manufacture [`CloudHsmServiceException`](crate::error::CloudHsmServiceException)
    pub fn builder() -> crate::error::cloud_hsm_service_exception::Builder {
        crate::error::cloud_hsm_service_exception::Builder::default()
    }
}

/// <p>Indicates that an internal error occurred.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CloudHsmInternalException {
    /// <p>Additional information about the error.</p>
    pub message: std::option::Option<std::string::String>,
    /// <p>Indicates if the action can be retried.</p>
    pub retryable: bool,
}
impl CloudHsmInternalException {
    /// <p>Indicates if the action can be retried.</p>
    pub fn retryable(&self) -> bool {
        self.retryable
    }
}
impl std::fmt::Debug for CloudHsmInternalException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CloudHsmInternalException");
        formatter.field("message", &self.message);
        formatter.field("retryable", &self.retryable);
        formatter.finish()
    }
}
impl CloudHsmInternalException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for CloudHsmInternalException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "CloudHsmInternalException")?;
        if let Some(inner_3) = &self.message {
            write!(f, ": {}", inner_3)?;
        }
        Ok(())
    }
}
impl std::error::Error for CloudHsmInternalException {}
/// See [`CloudHsmInternalException`](crate::error::CloudHsmInternalException)
pub mod cloud_hsm_internal_exception {
    /// A builder for [`CloudHsmInternalException`](crate::error::CloudHsmInternalException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) retryable: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>Additional information about the error.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>Additional information about the error.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p>Indicates if the action can be retried.</p>
        pub fn retryable(mut self, input: bool) -> Self {
            self.retryable = Some(input);
            self
        }
        /// <p>Indicates if the action can be retried.</p>
        pub fn set_retryable(mut self, input: std::option::Option<bool>) -> Self {
            self.retryable = input;
            self
        }
        /// Consumes the builder and constructs a [`CloudHsmInternalException`](crate::error::CloudHsmInternalException)
        pub fn build(self) -> crate::error::CloudHsmInternalException {
            crate::error::CloudHsmInternalException {
                message: self.message,
                retryable: self.retryable.unwrap_or_default(),
            }
        }
    }
}
impl CloudHsmInternalException {
    /// Creates a new builder-style object to manufacture [`CloudHsmInternalException`](crate::error::CloudHsmInternalException)
    pub fn builder() -> crate::error::cloud_hsm_internal_exception::Builder {
        crate::error::cloud_hsm_internal_exception::Builder::default()
    }
}
