// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RemoveTagsFromResourceOutput {
    /// <p>The status of the operation.</p>
    pub status: std::option::Option<std::string::String>,
}
impl RemoveTagsFromResourceOutput {
    /// <p>The status of the operation.</p>
    pub fn status(&self) -> std::option::Option<&str> {
        self.status.as_deref()
    }
}
impl std::fmt::Debug for RemoveTagsFromResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RemoveTagsFromResourceOutput");
        formatter.field("status", &self.status);
        formatter.finish()
    }
}
/// See [`RemoveTagsFromResourceOutput`](crate::output::RemoveTagsFromResourceOutput)
pub mod remove_tags_from_resource_output {
    /// A builder for [`RemoveTagsFromResourceOutput`](crate::output::RemoveTagsFromResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) status: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The status of the operation.</p>
        pub fn status(mut self, input: impl Into<std::string::String>) -> Self {
            self.status = Some(input.into());
            self
        }
        /// <p>The status of the operation.</p>
        pub fn set_status(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`RemoveTagsFromResourceOutput`](crate::output::RemoveTagsFromResourceOutput)
        pub fn build(self) -> crate::output::RemoveTagsFromResourceOutput {
            crate::output::RemoveTagsFromResourceOutput {
                status: self.status,
            }
        }
    }
}
impl RemoveTagsFromResourceOutput {
    /// Creates a new builder-style object to manufacture [`RemoveTagsFromResourceOutput`](crate::output::RemoveTagsFromResourceOutput)
    pub fn builder() -> crate::output::remove_tags_from_resource_output::Builder {
        crate::output::remove_tags_from_resource_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ModifyLunaClientOutput {
    /// <p>The ARN of the client.</p>
    pub client_arn: std::option::Option<std::string::String>,
}
impl ModifyLunaClientOutput {
    /// <p>The ARN of the client.</p>
    pub fn client_arn(&self) -> std::option::Option<&str> {
        self.client_arn.as_deref()
    }
}
impl std::fmt::Debug for ModifyLunaClientOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ModifyLunaClientOutput");
        formatter.field("client_arn", &self.client_arn);
        formatter.finish()
    }
}
/// See [`ModifyLunaClientOutput`](crate::output::ModifyLunaClientOutput)
pub mod modify_luna_client_output {
    /// A builder for [`ModifyLunaClientOutput`](crate::output::ModifyLunaClientOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) client_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the client.</p>
        pub fn client_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the client.</p>
        pub fn set_client_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`ModifyLunaClientOutput`](crate::output::ModifyLunaClientOutput)
        pub fn build(self) -> crate::output::ModifyLunaClientOutput {
            crate::output::ModifyLunaClientOutput {
                client_arn: self.client_arn,
            }
        }
    }
}
impl ModifyLunaClientOutput {
    /// Creates a new builder-style object to manufacture [`ModifyLunaClientOutput`](crate::output::ModifyLunaClientOutput)
    pub fn builder() -> crate::output::modify_luna_client_output::Builder {
        crate::output::modify_luna_client_output::Builder::default()
    }
}

/// <p>Contains the output of the <a>ModifyHsm</a> operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ModifyHsmOutput {
    /// <p>The ARN of the HSM.</p>
    pub hsm_arn: std::option::Option<std::string::String>,
}
impl ModifyHsmOutput {
    /// <p>The ARN of the HSM.</p>
    pub fn hsm_arn(&self) -> std::option::Option<&str> {
        self.hsm_arn.as_deref()
    }
}
impl std::fmt::Debug for ModifyHsmOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ModifyHsmOutput");
        formatter.field("hsm_arn", &self.hsm_arn);
        formatter.finish()
    }
}
/// See [`ModifyHsmOutput`](crate::output::ModifyHsmOutput)
pub mod modify_hsm_output {
    /// A builder for [`ModifyHsmOutput`](crate::output::ModifyHsmOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) hsm_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the HSM.</p>
        pub fn hsm_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.hsm_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the HSM.</p>
        pub fn set_hsm_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.hsm_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`ModifyHsmOutput`](crate::output::ModifyHsmOutput)
        pub fn build(self) -> crate::output::ModifyHsmOutput {
            crate::output::ModifyHsmOutput {
                hsm_arn: self.hsm_arn,
            }
        }
    }
}
impl ModifyHsmOutput {
    /// Creates a new builder-style object to manufacture [`ModifyHsmOutput`](crate::output::ModifyHsmOutput)
    pub fn builder() -> crate::output::modify_hsm_output::Builder {
        crate::output::modify_hsm_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ModifyHapgOutput {
    /// <p>The ARN of the high-availability partition group.</p>
    pub hapg_arn: std::option::Option<std::string::String>,
}
impl ModifyHapgOutput {
    /// <p>The ARN of the high-availability partition group.</p>
    pub fn hapg_arn(&self) -> std::option::Option<&str> {
        self.hapg_arn.as_deref()
    }
}
impl std::fmt::Debug for ModifyHapgOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ModifyHapgOutput");
        formatter.field("hapg_arn", &self.hapg_arn);
        formatter.finish()
    }
}
/// See [`ModifyHapgOutput`](crate::output::ModifyHapgOutput)
pub mod modify_hapg_output {
    /// A builder for [`ModifyHapgOutput`](crate::output::ModifyHapgOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) hapg_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the high-availability partition group.</p>
        pub fn hapg_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.hapg_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the high-availability partition group.</p>
        pub fn set_hapg_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.hapg_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`ModifyHapgOutput`](crate::output::ModifyHapgOutput)
        pub fn build(self) -> crate::output::ModifyHapgOutput {
            crate::output::ModifyHapgOutput {
                hapg_arn: self.hapg_arn,
            }
        }
    }
}
impl ModifyHapgOutput {
    /// Creates a new builder-style object to manufacture [`ModifyHapgOutput`](crate::output::ModifyHapgOutput)
    pub fn builder() -> crate::output::modify_hapg_output::Builder {
        crate::output::modify_hapg_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTagsForResourceOutput {
    /// <p>One or more tags.</p>
    pub tag_list: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl ListTagsForResourceOutput {
    /// <p>One or more tags.</p>
    pub fn tag_list(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tag_list.as_deref()
    }
}
impl std::fmt::Debug for ListTagsForResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTagsForResourceOutput");
        formatter.field("tag_list", &self.tag_list);
        formatter.finish()
    }
}
/// See [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
pub mod list_tags_for_resource_output {
    /// A builder for [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) tag_list: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// Appends an item to `tag_list`.
        ///
        /// To override the contents of this collection use [`set_tag_list`](Self::set_tag_list).
        ///
        /// <p>One or more tags.</p>
        pub fn tag_list(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tag_list.unwrap_or_default();
            v.push(input.into());
            self.tag_list = Some(v);
            self
        }
        /// <p>One or more tags.</p>
        pub fn set_tag_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tag_list = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
        pub fn build(self) -> crate::output::ListTagsForResourceOutput {
            crate::output::ListTagsForResourceOutput {
                tag_list: self.tag_list,
            }
        }
    }
}
impl ListTagsForResourceOutput {
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
    pub fn builder() -> crate::output::list_tags_for_resource_output::Builder {
        crate::output::list_tags_for_resource_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListLunaClientsOutput {
    /// <p>The list of clients.</p>
    pub client_list: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>If not null, more results are available. Pass this to <code>ListLunaClients</code> to
    /// retrieve the next set of items.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListLunaClientsOutput {
    /// <p>The list of clients.</p>
    pub fn client_list(&self) -> std::option::Option<&[std::string::String]> {
        self.client_list.as_deref()
    }
    /// <p>If not null, more results are available. Pass this to <code>ListLunaClients</code> to
    /// retrieve the next set of items.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListLunaClientsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListLunaClientsOutput");
        formatter.field("client_list", &self.client_list);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListLunaClientsOutput`](crate::output::ListLunaClientsOutput)
pub mod list_luna_clients_output {
    /// A builder for [`ListLunaClientsOutput`](crate::output::ListLunaClientsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) client_list: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `client_list`.
        ///
        /// To override the contents of this collection use [`set_client_list`](Self::set_client_list).
        ///
        /// <p>The list of clients.</p>
        pub fn client_list(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.client_list.unwrap_or_default();
            v.push(input.into());
            self.client_list = Some(v);
            self
        }
        /// <p>The list of clients.</p>
        pub fn set_client_list(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.client_list = input;
            self
        }
        /// <p>If not null, more results are available. Pass this to <code>ListLunaClients</code> to
        /// retrieve the next set of items.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>If not null, more results are available. Pass this to <code>ListLunaClients</code> to
        /// retrieve the next set of items.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListLunaClientsOutput`](crate::output::ListLunaClientsOutput)
        pub fn build(self) -> crate::output::ListLunaClientsOutput {
            crate::output::ListLunaClientsOutput {
                client_list: self.client_list,
                next_token: self.next_token,
            }
        }
    }
}
impl ListLunaClientsOutput {
    /// Creates a new builder-style object to manufacture [`ListLunaClientsOutput`](crate::output::ListLunaClientsOutput)
    pub fn builder() -> crate::output::list_luna_clients_output::Builder {
        crate::output::list_luna_clients_output::Builder::default()
    }
}

/// <p>Contains the output of the <code>ListHsms</code> operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListHsmsOutput {
    /// <p>The list of ARNs that identify the HSMs.</p>
    pub hsm_list: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>If not null, more results are available. Pass this value to <code>ListHsms</code> to
    /// retrieve the next set of items.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListHsmsOutput {
    /// <p>The list of ARNs that identify the HSMs.</p>
    pub fn hsm_list(&self) -> std::option::Option<&[std::string::String]> {
        self.hsm_list.as_deref()
    }
    /// <p>If not null, more results are available. Pass this value to <code>ListHsms</code> to
    /// retrieve the next set of items.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListHsmsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListHsmsOutput");
        formatter.field("hsm_list", &self.hsm_list);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListHsmsOutput`](crate::output::ListHsmsOutput)
pub mod list_hsms_output {
    /// A builder for [`ListHsmsOutput`](crate::output::ListHsmsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) hsm_list: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `hsm_list`.
        ///
        /// To override the contents of this collection use [`set_hsm_list`](Self::set_hsm_list).
        ///
        /// <p>The list of ARNs that identify the HSMs.</p>
        pub fn hsm_list(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.hsm_list.unwrap_or_default();
            v.push(input.into());
            self.hsm_list = Some(v);
            self
        }
        /// <p>The list of ARNs that identify the HSMs.</p>
        pub fn set_hsm_list(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.hsm_list = input;
            self
        }
        /// <p>If not null, more results are available. Pass this value to <code>ListHsms</code> to
        /// retrieve the next set of items.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>If not null, more results are available. Pass this value to <code>ListHsms</code> to
        /// retrieve the next set of items.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListHsmsOutput`](crate::output::ListHsmsOutput)
        pub fn build(self) -> crate::output::ListHsmsOutput {
            crate::output::ListHsmsOutput {
                hsm_list: self.hsm_list,
                next_token: self.next_token,
            }
        }
    }
}
impl ListHsmsOutput {
    /// Creates a new builder-style object to manufacture [`ListHsmsOutput`](crate::output::ListHsmsOutput)
    pub fn builder() -> crate::output::list_hsms_output::Builder {
        crate::output::list_hsms_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListHapgsOutput {
    /// <p>The list of high-availability partition groups.</p>
    pub hapg_list: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>If not null, more results are available. Pass this value to <code>ListHapgs</code> to
    /// retrieve the next set of items.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListHapgsOutput {
    /// <p>The list of high-availability partition groups.</p>
    pub fn hapg_list(&self) -> std::option::Option<&[std::string::String]> {
        self.hapg_list.as_deref()
    }
    /// <p>If not null, more results are available. Pass this value to <code>ListHapgs</code> to
    /// retrieve the next set of items.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListHapgsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListHapgsOutput");
        formatter.field("hapg_list", &self.hapg_list);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListHapgsOutput`](crate::output::ListHapgsOutput)
pub mod list_hapgs_output {
    /// A builder for [`ListHapgsOutput`](crate::output::ListHapgsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) hapg_list: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `hapg_list`.
        ///
        /// To override the contents of this collection use [`set_hapg_list`](Self::set_hapg_list).
        ///
        /// <p>The list of high-availability partition groups.</p>
        pub fn hapg_list(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.hapg_list.unwrap_or_default();
            v.push(input.into());
            self.hapg_list = Some(v);
            self
        }
        /// <p>The list of high-availability partition groups.</p>
        pub fn set_hapg_list(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.hapg_list = input;
            self
        }
        /// <p>If not null, more results are available. Pass this value to <code>ListHapgs</code> to
        /// retrieve the next set of items.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>If not null, more results are available. Pass this value to <code>ListHapgs</code> to
        /// retrieve the next set of items.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListHapgsOutput`](crate::output::ListHapgsOutput)
        pub fn build(self) -> crate::output::ListHapgsOutput {
            crate::output::ListHapgsOutput {
                hapg_list: self.hapg_list,
                next_token: self.next_token,
            }
        }
    }
}
impl ListHapgsOutput {
    /// Creates a new builder-style object to manufacture [`ListHapgsOutput`](crate::output::ListHapgsOutput)
    pub fn builder() -> crate::output::list_hapgs_output::Builder {
        crate::output::list_hapgs_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListAvailableZonesOutput {
    /// <p>The list of Availability Zones that have available AWS CloudHSM capacity.</p>
    pub az_list: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl ListAvailableZonesOutput {
    /// <p>The list of Availability Zones that have available AWS CloudHSM capacity.</p>
    pub fn az_list(&self) -> std::option::Option<&[std::string::String]> {
        self.az_list.as_deref()
    }
}
impl std::fmt::Debug for ListAvailableZonesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListAvailableZonesOutput");
        formatter.field("az_list", &self.az_list);
        formatter.finish()
    }
}
/// See [`ListAvailableZonesOutput`](crate::output::ListAvailableZonesOutput)
pub mod list_available_zones_output {
    /// A builder for [`ListAvailableZonesOutput`](crate::output::ListAvailableZonesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) az_list: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// Appends an item to `az_list`.
        ///
        /// To override the contents of this collection use [`set_az_list`](Self::set_az_list).
        ///
        /// <p>The list of Availability Zones that have available AWS CloudHSM capacity.</p>
        pub fn az_list(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.az_list.unwrap_or_default();
            v.push(input.into());
            self.az_list = Some(v);
            self
        }
        /// <p>The list of Availability Zones that have available AWS CloudHSM capacity.</p>
        pub fn set_az_list(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.az_list = input;
            self
        }
        /// Consumes the builder and constructs a [`ListAvailableZonesOutput`](crate::output::ListAvailableZonesOutput)
        pub fn build(self) -> crate::output::ListAvailableZonesOutput {
            crate::output::ListAvailableZonesOutput {
                az_list: self.az_list,
            }
        }
    }
}
impl ListAvailableZonesOutput {
    /// Creates a new builder-style object to manufacture [`ListAvailableZonesOutput`](crate::output::ListAvailableZonesOutput)
    pub fn builder() -> crate::output::list_available_zones_output::Builder {
        crate::output::list_available_zones_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetConfigOutput {
    /// <p>The type of credentials.</p>
    pub config_type: std::option::Option<std::string::String>,
    /// <p>The chrystoki.conf configuration file.</p>
    pub config_file: std::option::Option<std::string::String>,
    /// <p>The certificate file containing the server.pem files of the HSMs.</p>
    pub config_cred: std::option::Option<std::string::String>,
}
impl GetConfigOutput {
    /// <p>The type of credentials.</p>
    pub fn config_type(&self) -> std::option::Option<&str> {
        self.config_type.as_deref()
    }
    /// <p>The chrystoki.conf configuration file.</p>
    pub fn config_file(&self) -> std::option::Option<&str> {
        self.config_file.as_deref()
    }
    /// <p>The certificate file containing the server.pem files of the HSMs.</p>
    pub fn config_cred(&self) -> std::option::Option<&str> {
        self.config_cred.as_deref()
    }
}
impl std::fmt::Debug for GetConfigOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetConfigOutput");
        formatter.field("config_type", &self.config_type);
        formatter.field("config_file", &self.config_file);
        formatter.field("config_cred", &self.config_cred);
        formatter.finish()
    }
}
/// See [`GetConfigOutput`](crate::output::GetConfigOutput)
pub mod get_config_output {
    /// A builder for [`GetConfigOutput`](crate::output::GetConfigOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) config_type: std::option::Option<std::string::String>,
        pub(crate) config_file: std::option::Option<std::string::String>,
        pub(crate) config_cred: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The type of credentials.</p>
        pub fn config_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.config_type = Some(input.into());
            self
        }
        /// <p>The type of credentials.</p>
        pub fn set_config_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.config_type = input;
            self
        }
        /// <p>The chrystoki.conf configuration file.</p>
        pub fn config_file(mut self, input: impl Into<std::string::String>) -> Self {
            self.config_file = Some(input.into());
            self
        }
        /// <p>The chrystoki.conf configuration file.</p>
        pub fn set_config_file(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.config_file = input;
            self
        }
        /// <p>The certificate file containing the server.pem files of the HSMs.</p>
        pub fn config_cred(mut self, input: impl Into<std::string::String>) -> Self {
            self.config_cred = Some(input.into());
            self
        }
        /// <p>The certificate file containing the server.pem files of the HSMs.</p>
        pub fn set_config_cred(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.config_cred = input;
            self
        }
        /// Consumes the builder and constructs a [`GetConfigOutput`](crate::output::GetConfigOutput)
        pub fn build(self) -> crate::output::GetConfigOutput {
            crate::output::GetConfigOutput {
                config_type: self.config_type,
                config_file: self.config_file,
                config_cred: self.config_cred,
            }
        }
    }
}
impl GetConfigOutput {
    /// Creates a new builder-style object to manufacture [`GetConfigOutput`](crate::output::GetConfigOutput)
    pub fn builder() -> crate::output::get_config_output::Builder {
        crate::output::get_config_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeLunaClientOutput {
    /// <p>The ARN of the client.</p>
    pub client_arn: std::option::Option<std::string::String>,
    /// <p>The certificate installed on the HSMs used by this client.</p>
    pub certificate: std::option::Option<std::string::String>,
    /// <p>The certificate fingerprint.</p>
    pub certificate_fingerprint: std::option::Option<std::string::String>,
    /// <p>The date and time the client was last modified.</p>
    pub last_modified_timestamp: std::option::Option<std::string::String>,
    /// <p>The label of the client.</p>
    pub label: std::option::Option<std::string::String>,
}
impl DescribeLunaClientOutput {
    /// <p>The ARN of the client.</p>
    pub fn client_arn(&self) -> std::option::Option<&str> {
        self.client_arn.as_deref()
    }
    /// <p>The certificate installed on the HSMs used by this client.</p>
    pub fn certificate(&self) -> std::option::Option<&str> {
        self.certificate.as_deref()
    }
    /// <p>The certificate fingerprint.</p>
    pub fn certificate_fingerprint(&self) -> std::option::Option<&str> {
        self.certificate_fingerprint.as_deref()
    }
    /// <p>The date and time the client was last modified.</p>
    pub fn last_modified_timestamp(&self) -> std::option::Option<&str> {
        self.last_modified_timestamp.as_deref()
    }
    /// <p>The label of the client.</p>
    pub fn label(&self) -> std::option::Option<&str> {
        self.label.as_deref()
    }
}
impl std::fmt::Debug for DescribeLunaClientOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeLunaClientOutput");
        formatter.field("client_arn", &self.client_arn);
        formatter.field("certificate", &self.certificate);
        formatter.field("certificate_fingerprint", &self.certificate_fingerprint);
        formatter.field("last_modified_timestamp", &self.last_modified_timestamp);
        formatter.field("label", &self.label);
        formatter.finish()
    }
}
/// See [`DescribeLunaClientOutput`](crate::output::DescribeLunaClientOutput)
pub mod describe_luna_client_output {
    /// A builder for [`DescribeLunaClientOutput`](crate::output::DescribeLunaClientOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) client_arn: std::option::Option<std::string::String>,
        pub(crate) certificate: std::option::Option<std::string::String>,
        pub(crate) certificate_fingerprint: std::option::Option<std::string::String>,
        pub(crate) last_modified_timestamp: std::option::Option<std::string::String>,
        pub(crate) label: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the client.</p>
        pub fn client_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the client.</p>
        pub fn set_client_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_arn = input;
            self
        }
        /// <p>The certificate installed on the HSMs used by this client.</p>
        pub fn certificate(mut self, input: impl Into<std::string::String>) -> Self {
            self.certificate = Some(input.into());
            self
        }
        /// <p>The certificate installed on the HSMs used by this client.</p>
        pub fn set_certificate(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.certificate = input;
            self
        }
        /// <p>The certificate fingerprint.</p>
        pub fn certificate_fingerprint(mut self, input: impl Into<std::string::String>) -> Self {
            self.certificate_fingerprint = Some(input.into());
            self
        }
        /// <p>The certificate fingerprint.</p>
        pub fn set_certificate_fingerprint(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.certificate_fingerprint = input;
            self
        }
        /// <p>The date and time the client was last modified.</p>
        pub fn last_modified_timestamp(mut self, input: impl Into<std::string::String>) -> Self {
            self.last_modified_timestamp = Some(input.into());
            self
        }
        /// <p>The date and time the client was last modified.</p>
        pub fn set_last_modified_timestamp(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.last_modified_timestamp = input;
            self
        }
        /// <p>The label of the client.</p>
        pub fn label(mut self, input: impl Into<std::string::String>) -> Self {
            self.label = Some(input.into());
            self
        }
        /// <p>The label of the client.</p>
        pub fn set_label(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.label = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeLunaClientOutput`](crate::output::DescribeLunaClientOutput)
        pub fn build(self) -> crate::output::DescribeLunaClientOutput {
            crate::output::DescribeLunaClientOutput {
                client_arn: self.client_arn,
                certificate: self.certificate,
                certificate_fingerprint: self.certificate_fingerprint,
                last_modified_timestamp: self.last_modified_timestamp,
                label: self.label,
            }
        }
    }
}
impl DescribeLunaClientOutput {
    /// Creates a new builder-style object to manufacture [`DescribeLunaClientOutput`](crate::output::DescribeLunaClientOutput)
    pub fn builder() -> crate::output::describe_luna_client_output::Builder {
        crate::output::describe_luna_client_output::Builder::default()
    }
}

/// <p>Contains the output of the <a>DescribeHsm</a> operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeHsmOutput {
    /// <p>The ARN of the HSM.</p>
    pub hsm_arn: std::option::Option<std::string::String>,
    /// <p>The status of the HSM.</p>
    pub status: std::option::Option<crate::model::HsmStatus>,
    /// <p>Contains additional information about the status of the HSM.</p>
    pub status_details: std::option::Option<std::string::String>,
    /// <p>The Availability Zone that the HSM is in.</p>
    pub availability_zone: std::option::Option<std::string::String>,
    /// <p>The identifier of the elastic network interface (ENI) attached to the HSM.</p>
    pub eni_id: std::option::Option<std::string::String>,
    /// <p>The IP address assigned to the HSM's ENI.</p>
    pub eni_ip: std::option::Option<std::string::String>,
    /// <p>Specifies the type of subscription for the HSM.</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <b>PRODUCTION</b> - The HSM is being used in a production
    /// environment.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>TRIAL</b> - The HSM is being used in a product
    /// trial.</p>
    /// </li>
    /// </ul>
    pub subscription_type: std::option::Option<crate::model::SubscriptionType>,
    /// <p>The subscription start date.</p>
    pub subscription_start_date: std::option::Option<std::string::String>,
    /// <p>The subscription end date.</p>
    pub subscription_end_date: std::option::Option<std::string::String>,
    /// <p>The identifier of the VPC that the HSM is in.</p>
    pub vpc_id: std::option::Option<std::string::String>,
    /// <p>The identifier of the subnet that the HSM is in.</p>
    pub subnet_id: std::option::Option<std::string::String>,
    /// <p>The ARN of the IAM role assigned to the HSM.</p>
    pub iam_role_arn: std::option::Option<std::string::String>,
    /// <p>The serial number of the HSM.</p>
    pub serial_number: std::option::Option<std::string::String>,
    /// <p>The name of the HSM vendor.</p>
    pub vendor_name: std::option::Option<std::string::String>,
    /// <p>The HSM model type.</p>
    pub hsm_type: std::option::Option<std::string::String>,
    /// <p>The HSM software version.</p>
    pub software_version: std::option::Option<std::string::String>,
    /// <p>The public SSH key.</p>
    pub ssh_public_key: std::option::Option<std::string::String>,
    /// <p>The date and time that the SSH key was last updated.</p>
    pub ssh_key_last_updated: std::option::Option<std::string::String>,
    /// <p>The URI of the certificate server.</p>
    pub server_cert_uri: std::option::Option<std::string::String>,
    /// <p>The date and time that the server certificate was last updated.</p>
    pub server_cert_last_updated: std::option::Option<std::string::String>,
    /// <p>The list of partitions on the HSM.</p>
    pub partitions: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl DescribeHsmOutput {
    /// <p>The ARN of the HSM.</p>
    pub fn hsm_arn(&self) -> std::option::Option<&str> {
        self.hsm_arn.as_deref()
    }
    /// <p>The status of the HSM.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::HsmStatus> {
        self.status.as_ref()
    }
    /// <p>Contains additional information about the status of the HSM.</p>
    pub fn status_details(&self) -> std::option::Option<&str> {
        self.status_details.as_deref()
    }
    /// <p>The Availability Zone that the HSM is in.</p>
    pub fn availability_zone(&self) -> std::option::Option<&str> {
        self.availability_zone.as_deref()
    }
    /// <p>The identifier of the elastic network interface (ENI) attached to the HSM.</p>
    pub fn eni_id(&self) -> std::option::Option<&str> {
        self.eni_id.as_deref()
    }
    /// <p>The IP address assigned to the HSM's ENI.</p>
    pub fn eni_ip(&self) -> std::option::Option<&str> {
        self.eni_ip.as_deref()
    }
    /// <p>Specifies the type of subscription for the HSM.</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <b>PRODUCTION</b> - The HSM is being used in a production
    /// environment.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>TRIAL</b> - The HSM is being used in a product
    /// trial.</p>
    /// </li>
    /// </ul>
    pub fn subscription_type(&self) -> std::option::Option<&crate::model::SubscriptionType> {
        self.subscription_type.as_ref()
    }
    /// <p>The subscription start date.</p>
    pub fn subscription_start_date(&self) -> std::option::Option<&str> {
        self.subscription_start_date.as_deref()
    }
    /// <p>The subscription end date.</p>
    pub fn subscription_end_date(&self) -> std::option::Option<&str> {
        self.subscription_end_date.as_deref()
    }
    /// <p>The identifier of the VPC that the HSM is in.</p>
    pub fn vpc_id(&self) -> std::option::Option<&str> {
        self.vpc_id.as_deref()
    }
    /// <p>The identifier of the subnet that the HSM is in.</p>
    pub fn subnet_id(&self) -> std::option::Option<&str> {
        self.subnet_id.as_deref()
    }
    /// <p>The ARN of the IAM role assigned to the HSM.</p>
    pub fn iam_role_arn(&self) -> std::option::Option<&str> {
        self.iam_role_arn.as_deref()
    }
    /// <p>The serial number of the HSM.</p>
    pub fn serial_number(&self) -> std::option::Option<&str> {
        self.serial_number.as_deref()
    }
    /// <p>The name of the HSM vendor.</p>
    pub fn vendor_name(&self) -> std::option::Option<&str> {
        self.vendor_name.as_deref()
    }
    /// <p>The HSM model type.</p>
    pub fn hsm_type(&self) -> std::option::Option<&str> {
        self.hsm_type.as_deref()
    }
    /// <p>The HSM software version.</p>
    pub fn software_version(&self) -> std::option::Option<&str> {
        self.software_version.as_deref()
    }
    /// <p>The public SSH key.</p>
    pub fn ssh_public_key(&self) -> std::option::Option<&str> {
        self.ssh_public_key.as_deref()
    }
    /// <p>The date and time that the SSH key was last updated.</p>
    pub fn ssh_key_last_updated(&self) -> std::option::Option<&str> {
        self.ssh_key_last_updated.as_deref()
    }
    /// <p>The URI of the certificate server.</p>
    pub fn server_cert_uri(&self) -> std::option::Option<&str> {
        self.server_cert_uri.as_deref()
    }
    /// <p>The date and time that the server certificate was last updated.</p>
    pub fn server_cert_last_updated(&self) -> std::option::Option<&str> {
        self.server_cert_last_updated.as_deref()
    }
    /// <p>The list of partitions on the HSM.</p>
    pub fn partitions(&self) -> std::option::Option<&[std::string::String]> {
        self.partitions.as_deref()
    }
}
impl std::fmt::Debug for DescribeHsmOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeHsmOutput");
        formatter.field("hsm_arn", &self.hsm_arn);
        formatter.field("status", &self.status);
        formatter.field("status_details", &self.status_details);
        formatter.field("availability_zone", &self.availability_zone);
        formatter.field("eni_id", &self.eni_id);
        formatter.field("eni_ip", &self.eni_ip);
        formatter.field("subscription_type", &self.subscription_type);
        formatter.field("subscription_start_date", &self.subscription_start_date);
        formatter.field("subscription_end_date", &self.subscription_end_date);
        formatter.field("vpc_id", &self.vpc_id);
        formatter.field("subnet_id", &self.subnet_id);
        formatter.field("iam_role_arn", &self.iam_role_arn);
        formatter.field("serial_number", &self.serial_number);
        formatter.field("vendor_name", &self.vendor_name);
        formatter.field("hsm_type", &self.hsm_type);
        formatter.field("software_version", &self.software_version);
        formatter.field("ssh_public_key", &self.ssh_public_key);
        formatter.field("ssh_key_last_updated", &self.ssh_key_last_updated);
        formatter.field("server_cert_uri", &self.server_cert_uri);
        formatter.field("server_cert_last_updated", &self.server_cert_last_updated);
        formatter.field("partitions", &self.partitions);
        formatter.finish()
    }
}
/// See [`DescribeHsmOutput`](crate::output::DescribeHsmOutput)
pub mod describe_hsm_output {
    /// A builder for [`DescribeHsmOutput`](crate::output::DescribeHsmOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) hsm_arn: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::HsmStatus>,
        pub(crate) status_details: std::option::Option<std::string::String>,
        pub(crate) availability_zone: std::option::Option<std::string::String>,
        pub(crate) eni_id: std::option::Option<std::string::String>,
        pub(crate) eni_ip: std::option::Option<std::string::String>,
        pub(crate) subscription_type: std::option::Option<crate::model::SubscriptionType>,
        pub(crate) subscription_start_date: std::option::Option<std::string::String>,
        pub(crate) subscription_end_date: std::option::Option<std::string::String>,
        pub(crate) vpc_id: std::option::Option<std::string::String>,
        pub(crate) subnet_id: std::option::Option<std::string::String>,
        pub(crate) iam_role_arn: std::option::Option<std::string::String>,
        pub(crate) serial_number: std::option::Option<std::string::String>,
        pub(crate) vendor_name: std::option::Option<std::string::String>,
        pub(crate) hsm_type: std::option::Option<std::string::String>,
        pub(crate) software_version: std::option::Option<std::string::String>,
        pub(crate) ssh_public_key: std::option::Option<std::string::String>,
        pub(crate) ssh_key_last_updated: std::option::Option<std::string::String>,
        pub(crate) server_cert_uri: std::option::Option<std::string::String>,
        pub(crate) server_cert_last_updated: std::option::Option<std::string::String>,
        pub(crate) partitions: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The ARN of the HSM.</p>
        pub fn hsm_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.hsm_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the HSM.</p>
        pub fn set_hsm_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.hsm_arn = input;
            self
        }
        /// <p>The status of the HSM.</p>
        pub fn status(mut self, input: crate::model::HsmStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of the HSM.</p>
        pub fn set_status(mut self, input: std::option::Option<crate::model::HsmStatus>) -> Self {
            self.status = input;
            self
        }
        /// <p>Contains additional information about the status of the HSM.</p>
        pub fn status_details(mut self, input: impl Into<std::string::String>) -> Self {
            self.status_details = Some(input.into());
            self
        }
        /// <p>Contains additional information about the status of the HSM.</p>
        pub fn set_status_details(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.status_details = input;
            self
        }
        /// <p>The Availability Zone that the HSM is in.</p>
        pub fn availability_zone(mut self, input: impl Into<std::string::String>) -> Self {
            self.availability_zone = Some(input.into());
            self
        }
        /// <p>The Availability Zone that the HSM is in.</p>
        pub fn set_availability_zone(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.availability_zone = input;
            self
        }
        /// <p>The identifier of the elastic network interface (ENI) attached to the HSM.</p>
        pub fn eni_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.eni_id = Some(input.into());
            self
        }
        /// <p>The identifier of the elastic network interface (ENI) attached to the HSM.</p>
        pub fn set_eni_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.eni_id = input;
            self
        }
        /// <p>The IP address assigned to the HSM's ENI.</p>
        pub fn eni_ip(mut self, input: impl Into<std::string::String>) -> Self {
            self.eni_ip = Some(input.into());
            self
        }
        /// <p>The IP address assigned to the HSM's ENI.</p>
        pub fn set_eni_ip(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.eni_ip = input;
            self
        }
        /// <p>Specifies the type of subscription for the HSM.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>PRODUCTION</b> - The HSM is being used in a production
        /// environment.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>TRIAL</b> - The HSM is being used in a product
        /// trial.</p>
        /// </li>
        /// </ul>
        pub fn subscription_type(mut self, input: crate::model::SubscriptionType) -> Self {
            self.subscription_type = Some(input);
            self
        }
        /// <p>Specifies the type of subscription for the HSM.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>PRODUCTION</b> - The HSM is being used in a production
        /// environment.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>TRIAL</b> - The HSM is being used in a product
        /// trial.</p>
        /// </li>
        /// </ul>
        pub fn set_subscription_type(
            mut self,
            input: std::option::Option<crate::model::SubscriptionType>,
        ) -> Self {
            self.subscription_type = input;
            self
        }
        /// <p>The subscription start date.</p>
        pub fn subscription_start_date(mut self, input: impl Into<std::string::String>) -> Self {
            self.subscription_start_date = Some(input.into());
            self
        }
        /// <p>The subscription start date.</p>
        pub fn set_subscription_start_date(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.subscription_start_date = input;
            self
        }
        /// <p>The subscription end date.</p>
        pub fn subscription_end_date(mut self, input: impl Into<std::string::String>) -> Self {
            self.subscription_end_date = Some(input.into());
            self
        }
        /// <p>The subscription end date.</p>
        pub fn set_subscription_end_date(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.subscription_end_date = input;
            self
        }
        /// <p>The identifier of the VPC that the HSM is in.</p>
        pub fn vpc_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.vpc_id = Some(input.into());
            self
        }
        /// <p>The identifier of the VPC that the HSM is in.</p>
        pub fn set_vpc_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.vpc_id = input;
            self
        }
        /// <p>The identifier of the subnet that the HSM is in.</p>
        pub fn subnet_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.subnet_id = Some(input.into());
            self
        }
        /// <p>The identifier of the subnet that the HSM is in.</p>
        pub fn set_subnet_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.subnet_id = input;
            self
        }
        /// <p>The ARN of the IAM role assigned to the HSM.</p>
        pub fn iam_role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.iam_role_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the IAM role assigned to the HSM.</p>
        pub fn set_iam_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.iam_role_arn = input;
            self
        }
        /// <p>The serial number of the HSM.</p>
        pub fn serial_number(mut self, input: impl Into<std::string::String>) -> Self {
            self.serial_number = Some(input.into());
            self
        }
        /// <p>The serial number of the HSM.</p>
        pub fn set_serial_number(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.serial_number = input;
            self
        }
        /// <p>The name of the HSM vendor.</p>
        pub fn vendor_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.vendor_name = Some(input.into());
            self
        }
        /// <p>The name of the HSM vendor.</p>
        pub fn set_vendor_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.vendor_name = input;
            self
        }
        /// <p>The HSM model type.</p>
        pub fn hsm_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.hsm_type = Some(input.into());
            self
        }
        /// <p>The HSM model type.</p>
        pub fn set_hsm_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.hsm_type = input;
            self
        }
        /// <p>The HSM software version.</p>
        pub fn software_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.software_version = Some(input.into());
            self
        }
        /// <p>The HSM software version.</p>
        pub fn set_software_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.software_version = input;
            self
        }
        /// <p>The public SSH key.</p>
        pub fn ssh_public_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.ssh_public_key = Some(input.into());
            self
        }
        /// <p>The public SSH key.</p>
        pub fn set_ssh_public_key(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.ssh_public_key = input;
            self
        }
        /// <p>The date and time that the SSH key was last updated.</p>
        pub fn ssh_key_last_updated(mut self, input: impl Into<std::string::String>) -> Self {
            self.ssh_key_last_updated = Some(input.into());
            self
        }
        /// <p>The date and time that the SSH key was last updated.</p>
        pub fn set_ssh_key_last_updated(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.ssh_key_last_updated = input;
            self
        }
        /// <p>The URI of the certificate server.</p>
        pub fn server_cert_uri(mut self, input: impl Into<std::string::String>) -> Self {
            self.server_cert_uri = Some(input.into());
            self
        }
        /// <p>The URI of the certificate server.</p>
        pub fn set_server_cert_uri(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.server_cert_uri = input;
            self
        }
        /// <p>The date and time that the server certificate was last updated.</p>
        pub fn server_cert_last_updated(mut self, input: impl Into<std::string::String>) -> Self {
            self.server_cert_last_updated = Some(input.into());
            self
        }
        /// <p>The date and time that the server certificate was last updated.</p>
        pub fn set_server_cert_last_updated(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.server_cert_last_updated = input;
            self
        }
        /// Appends an item to `partitions`.
        ///
        /// To override the contents of this collection use [`set_partitions`](Self::set_partitions).
        ///
        /// <p>The list of partitions on the HSM.</p>
        pub fn partitions(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.partitions.unwrap_or_default();
            v.push(input.into());
            self.partitions = Some(v);
            self
        }
        /// <p>The list of partitions on the HSM.</p>
        pub fn set_partitions(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.partitions = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeHsmOutput`](crate::output::DescribeHsmOutput)
        pub fn build(self) -> crate::output::DescribeHsmOutput {
            crate::output::DescribeHsmOutput {
                hsm_arn: self.hsm_arn,
                status: self.status,
                status_details: self.status_details,
                availability_zone: self.availability_zone,
                eni_id: self.eni_id,
                eni_ip: self.eni_ip,
                subscription_type: self.subscription_type,
                subscription_start_date: self.subscription_start_date,
                subscription_end_date: self.subscription_end_date,
                vpc_id: self.vpc_id,
                subnet_id: self.subnet_id,
                iam_role_arn: self.iam_role_arn,
                serial_number: self.serial_number,
                vendor_name: self.vendor_name,
                hsm_type: self.hsm_type,
                software_version: self.software_version,
                ssh_public_key: self.ssh_public_key,
                ssh_key_last_updated: self.ssh_key_last_updated,
                server_cert_uri: self.server_cert_uri,
                server_cert_last_updated: self.server_cert_last_updated,
                partitions: self.partitions,
            }
        }
    }
}
impl DescribeHsmOutput {
    /// Creates a new builder-style object to manufacture [`DescribeHsmOutput`](crate::output::DescribeHsmOutput)
    pub fn builder() -> crate::output::describe_hsm_output::Builder {
        crate::output::describe_hsm_output::Builder::default()
    }
}

/// <p>Contains the output of the <a>DescribeHapg</a> action.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeHapgOutput {
    /// <p>The ARN of the high-availability partition group.</p>
    pub hapg_arn: std::option::Option<std::string::String>,
    /// <p>The serial number of the high-availability partition group.</p>
    pub hapg_serial: std::option::Option<std::string::String>,
    /// <p></p>
    pub hsms_last_action_failed: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p></p>
    pub hsms_pending_deletion: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p></p>
    pub hsms_pending_registration: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The label for the high-availability partition group.</p>
    pub label: std::option::Option<std::string::String>,
    /// <p>The date and time the high-availability partition group was last modified.</p>
    pub last_modified_timestamp: std::option::Option<std::string::String>,
    /// <p>The list of partition serial numbers that belong to the high-availability partition
    /// group.</p>
    pub partition_serial_list: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The state of the high-availability partition group.</p>
    pub state: std::option::Option<crate::model::CloudHsmObjectState>,
}
impl DescribeHapgOutput {
    /// <p>The ARN of the high-availability partition group.</p>
    pub fn hapg_arn(&self) -> std::option::Option<&str> {
        self.hapg_arn.as_deref()
    }
    /// <p>The serial number of the high-availability partition group.</p>
    pub fn hapg_serial(&self) -> std::option::Option<&str> {
        self.hapg_serial.as_deref()
    }
    /// <p></p>
    pub fn hsms_last_action_failed(&self) -> std::option::Option<&[std::string::String]> {
        self.hsms_last_action_failed.as_deref()
    }
    /// <p></p>
    pub fn hsms_pending_deletion(&self) -> std::option::Option<&[std::string::String]> {
        self.hsms_pending_deletion.as_deref()
    }
    /// <p></p>
    pub fn hsms_pending_registration(&self) -> std::option::Option<&[std::string::String]> {
        self.hsms_pending_registration.as_deref()
    }
    /// <p>The label for the high-availability partition group.</p>
    pub fn label(&self) -> std::option::Option<&str> {
        self.label.as_deref()
    }
    /// <p>The date and time the high-availability partition group was last modified.</p>
    pub fn last_modified_timestamp(&self) -> std::option::Option<&str> {
        self.last_modified_timestamp.as_deref()
    }
    /// <p>The list of partition serial numbers that belong to the high-availability partition
    /// group.</p>
    pub fn partition_serial_list(&self) -> std::option::Option<&[std::string::String]> {
        self.partition_serial_list.as_deref()
    }
    /// <p>The state of the high-availability partition group.</p>
    pub fn state(&self) -> std::option::Option<&crate::model::CloudHsmObjectState> {
        self.state.as_ref()
    }
}
impl std::fmt::Debug for DescribeHapgOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeHapgOutput");
        formatter.field("hapg_arn", &self.hapg_arn);
        formatter.field("hapg_serial", &self.hapg_serial);
        formatter.field("hsms_last_action_failed", &self.hsms_last_action_failed);
        formatter.field("hsms_pending_deletion", &self.hsms_pending_deletion);
        formatter.field("hsms_pending_registration", &self.hsms_pending_registration);
        formatter.field("label", &self.label);
        formatter.field("last_modified_timestamp", &self.last_modified_timestamp);
        formatter.field("partition_serial_list", &self.partition_serial_list);
        formatter.field("state", &self.state);
        formatter.finish()
    }
}
/// See [`DescribeHapgOutput`](crate::output::DescribeHapgOutput)
pub mod describe_hapg_output {
    /// A builder for [`DescribeHapgOutput`](crate::output::DescribeHapgOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) hapg_arn: std::option::Option<std::string::String>,
        pub(crate) hapg_serial: std::option::Option<std::string::String>,
        pub(crate) hsms_last_action_failed: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) hsms_pending_deletion: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) hsms_pending_registration:
            std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) label: std::option::Option<std::string::String>,
        pub(crate) last_modified_timestamp: std::option::Option<std::string::String>,
        pub(crate) partition_serial_list: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) state: std::option::Option<crate::model::CloudHsmObjectState>,
    }
    impl Builder {
        /// <p>The ARN of the high-availability partition group.</p>
        pub fn hapg_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.hapg_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the high-availability partition group.</p>
        pub fn set_hapg_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.hapg_arn = input;
            self
        }
        /// <p>The serial number of the high-availability partition group.</p>
        pub fn hapg_serial(mut self, input: impl Into<std::string::String>) -> Self {
            self.hapg_serial = Some(input.into());
            self
        }
        /// <p>The serial number of the high-availability partition group.</p>
        pub fn set_hapg_serial(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.hapg_serial = input;
            self
        }
        /// Appends an item to `hsms_last_action_failed`.
        ///
        /// To override the contents of this collection use [`set_hsms_last_action_failed`](Self::set_hsms_last_action_failed).
        ///
        /// <p></p>
        pub fn hsms_last_action_failed(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.hsms_last_action_failed.unwrap_or_default();
            v.push(input.into());
            self.hsms_last_action_failed = Some(v);
            self
        }
        /// <p></p>
        pub fn set_hsms_last_action_failed(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.hsms_last_action_failed = input;
            self
        }
        /// Appends an item to `hsms_pending_deletion`.
        ///
        /// To override the contents of this collection use [`set_hsms_pending_deletion`](Self::set_hsms_pending_deletion).
        ///
        /// <p></p>
        pub fn hsms_pending_deletion(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.hsms_pending_deletion.unwrap_or_default();
            v.push(input.into());
            self.hsms_pending_deletion = Some(v);
            self
        }
        /// <p></p>
        pub fn set_hsms_pending_deletion(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.hsms_pending_deletion = input;
            self
        }
        /// Appends an item to `hsms_pending_registration`.
        ///
        /// To override the contents of this collection use [`set_hsms_pending_registration`](Self::set_hsms_pending_registration).
        ///
        /// <p></p>
        pub fn hsms_pending_registration(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.hsms_pending_registration.unwrap_or_default();
            v.push(input.into());
            self.hsms_pending_registration = Some(v);
            self
        }
        /// <p></p>
        pub fn set_hsms_pending_registration(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.hsms_pending_registration = input;
            self
        }
        /// <p>The label for the high-availability partition group.</p>
        pub fn label(mut self, input: impl Into<std::string::String>) -> Self {
            self.label = Some(input.into());
            self
        }
        /// <p>The label for the high-availability partition group.</p>
        pub fn set_label(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.label = input;
            self
        }
        /// <p>The date and time the high-availability partition group was last modified.</p>
        pub fn last_modified_timestamp(mut self, input: impl Into<std::string::String>) -> Self {
            self.last_modified_timestamp = Some(input.into());
            self
        }
        /// <p>The date and time the high-availability partition group was last modified.</p>
        pub fn set_last_modified_timestamp(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.last_modified_timestamp = input;
            self
        }
        /// Appends an item to `partition_serial_list`.
        ///
        /// To override the contents of this collection use [`set_partition_serial_list`](Self::set_partition_serial_list).
        ///
        /// <p>The list of partition serial numbers that belong to the high-availability partition
        /// group.</p>
        pub fn partition_serial_list(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.partition_serial_list.unwrap_or_default();
            v.push(input.into());
            self.partition_serial_list = Some(v);
            self
        }
        /// <p>The list of partition serial numbers that belong to the high-availability partition
        /// group.</p>
        pub fn set_partition_serial_list(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.partition_serial_list = input;
            self
        }
        /// <p>The state of the high-availability partition group.</p>
        pub fn state(mut self, input: crate::model::CloudHsmObjectState) -> Self {
            self.state = Some(input);
            self
        }
        /// <p>The state of the high-availability partition group.</p>
        pub fn set_state(
            mut self,
            input: std::option::Option<crate::model::CloudHsmObjectState>,
        ) -> Self {
            self.state = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeHapgOutput`](crate::output::DescribeHapgOutput)
        pub fn build(self) -> crate::output::DescribeHapgOutput {
            crate::output::DescribeHapgOutput {
                hapg_arn: self.hapg_arn,
                hapg_serial: self.hapg_serial,
                hsms_last_action_failed: self.hsms_last_action_failed,
                hsms_pending_deletion: self.hsms_pending_deletion,
                hsms_pending_registration: self.hsms_pending_registration,
                label: self.label,
                last_modified_timestamp: self.last_modified_timestamp,
                partition_serial_list: self.partition_serial_list,
                state: self.state,
            }
        }
    }
}
impl DescribeHapgOutput {
    /// Creates a new builder-style object to manufacture [`DescribeHapgOutput`](crate::output::DescribeHapgOutput)
    pub fn builder() -> crate::output::describe_hapg_output::Builder {
        crate::output::describe_hapg_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteLunaClientOutput {
    /// <p>The status of the action.</p>
    pub status: std::option::Option<std::string::String>,
}
impl DeleteLunaClientOutput {
    /// <p>The status of the action.</p>
    pub fn status(&self) -> std::option::Option<&str> {
        self.status.as_deref()
    }
}
impl std::fmt::Debug for DeleteLunaClientOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteLunaClientOutput");
        formatter.field("status", &self.status);
        formatter.finish()
    }
}
/// See [`DeleteLunaClientOutput`](crate::output::DeleteLunaClientOutput)
pub mod delete_luna_client_output {
    /// A builder for [`DeleteLunaClientOutput`](crate::output::DeleteLunaClientOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) status: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The status of the action.</p>
        pub fn status(mut self, input: impl Into<std::string::String>) -> Self {
            self.status = Some(input.into());
            self
        }
        /// <p>The status of the action.</p>
        pub fn set_status(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteLunaClientOutput`](crate::output::DeleteLunaClientOutput)
        pub fn build(self) -> crate::output::DeleteLunaClientOutput {
            crate::output::DeleteLunaClientOutput {
                status: self.status,
            }
        }
    }
}
impl DeleteLunaClientOutput {
    /// Creates a new builder-style object to manufacture [`DeleteLunaClientOutput`](crate::output::DeleteLunaClientOutput)
    pub fn builder() -> crate::output::delete_luna_client_output::Builder {
        crate::output::delete_luna_client_output::Builder::default()
    }
}

/// <p>Contains the output of the <a>DeleteHsm</a> operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteHsmOutput {
    /// <p>The status of the operation.</p>
    pub status: std::option::Option<std::string::String>,
}
impl DeleteHsmOutput {
    /// <p>The status of the operation.</p>
    pub fn status(&self) -> std::option::Option<&str> {
        self.status.as_deref()
    }
}
impl std::fmt::Debug for DeleteHsmOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteHsmOutput");
        formatter.field("status", &self.status);
        formatter.finish()
    }
}
/// See [`DeleteHsmOutput`](crate::output::DeleteHsmOutput)
pub mod delete_hsm_output {
    /// A builder for [`DeleteHsmOutput`](crate::output::DeleteHsmOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) status: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The status of the operation.</p>
        pub fn status(mut self, input: impl Into<std::string::String>) -> Self {
            self.status = Some(input.into());
            self
        }
        /// <p>The status of the operation.</p>
        pub fn set_status(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteHsmOutput`](crate::output::DeleteHsmOutput)
        pub fn build(self) -> crate::output::DeleteHsmOutput {
            crate::output::DeleteHsmOutput {
                status: self.status,
            }
        }
    }
}
impl DeleteHsmOutput {
    /// Creates a new builder-style object to manufacture [`DeleteHsmOutput`](crate::output::DeleteHsmOutput)
    pub fn builder() -> crate::output::delete_hsm_output::Builder {
        crate::output::delete_hsm_output::Builder::default()
    }
}

/// <p>Contains the output of the <a>DeleteHapg</a> action.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteHapgOutput {
    /// <p>The status of the action.</p>
    pub status: std::option::Option<std::string::String>,
}
impl DeleteHapgOutput {
    /// <p>The status of the action.</p>
    pub fn status(&self) -> std::option::Option<&str> {
        self.status.as_deref()
    }
}
impl std::fmt::Debug for DeleteHapgOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteHapgOutput");
        formatter.field("status", &self.status);
        formatter.finish()
    }
}
/// See [`DeleteHapgOutput`](crate::output::DeleteHapgOutput)
pub mod delete_hapg_output {
    /// A builder for [`DeleteHapgOutput`](crate::output::DeleteHapgOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) status: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The status of the action.</p>
        pub fn status(mut self, input: impl Into<std::string::String>) -> Self {
            self.status = Some(input.into());
            self
        }
        /// <p>The status of the action.</p>
        pub fn set_status(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteHapgOutput`](crate::output::DeleteHapgOutput)
        pub fn build(self) -> crate::output::DeleteHapgOutput {
            crate::output::DeleteHapgOutput {
                status: self.status,
            }
        }
    }
}
impl DeleteHapgOutput {
    /// Creates a new builder-style object to manufacture [`DeleteHapgOutput`](crate::output::DeleteHapgOutput)
    pub fn builder() -> crate::output::delete_hapg_output::Builder {
        crate::output::delete_hapg_output::Builder::default()
    }
}

/// <p>Contains the output of the <a>CreateLunaClient</a> action.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateLunaClientOutput {
    /// <p>The ARN of the client.</p>
    pub client_arn: std::option::Option<std::string::String>,
}
impl CreateLunaClientOutput {
    /// <p>The ARN of the client.</p>
    pub fn client_arn(&self) -> std::option::Option<&str> {
        self.client_arn.as_deref()
    }
}
impl std::fmt::Debug for CreateLunaClientOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateLunaClientOutput");
        formatter.field("client_arn", &self.client_arn);
        formatter.finish()
    }
}
/// See [`CreateLunaClientOutput`](crate::output::CreateLunaClientOutput)
pub mod create_luna_client_output {
    /// A builder for [`CreateLunaClientOutput`](crate::output::CreateLunaClientOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) client_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the client.</p>
        pub fn client_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the client.</p>
        pub fn set_client_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateLunaClientOutput`](crate::output::CreateLunaClientOutput)
        pub fn build(self) -> crate::output::CreateLunaClientOutput {
            crate::output::CreateLunaClientOutput {
                client_arn: self.client_arn,
            }
        }
    }
}
impl CreateLunaClientOutput {
    /// Creates a new builder-style object to manufacture [`CreateLunaClientOutput`](crate::output::CreateLunaClientOutput)
    pub fn builder() -> crate::output::create_luna_client_output::Builder {
        crate::output::create_luna_client_output::Builder::default()
    }
}

/// <p>Contains the output of the <code>CreateHsm</code> operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateHsmOutput {
    /// <p>The ARN of the HSM.</p>
    pub hsm_arn: std::option::Option<std::string::String>,
}
impl CreateHsmOutput {
    /// <p>The ARN of the HSM.</p>
    pub fn hsm_arn(&self) -> std::option::Option<&str> {
        self.hsm_arn.as_deref()
    }
}
impl std::fmt::Debug for CreateHsmOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateHsmOutput");
        formatter.field("hsm_arn", &self.hsm_arn);
        formatter.finish()
    }
}
/// See [`CreateHsmOutput`](crate::output::CreateHsmOutput)
pub mod create_hsm_output {
    /// A builder for [`CreateHsmOutput`](crate::output::CreateHsmOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) hsm_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the HSM.</p>
        pub fn hsm_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.hsm_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the HSM.</p>
        pub fn set_hsm_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.hsm_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateHsmOutput`](crate::output::CreateHsmOutput)
        pub fn build(self) -> crate::output::CreateHsmOutput {
            crate::output::CreateHsmOutput {
                hsm_arn: self.hsm_arn,
            }
        }
    }
}
impl CreateHsmOutput {
    /// Creates a new builder-style object to manufacture [`CreateHsmOutput`](crate::output::CreateHsmOutput)
    pub fn builder() -> crate::output::create_hsm_output::Builder {
        crate::output::create_hsm_output::Builder::default()
    }
}

/// <p>Contains the output of the <a>CreateHAPartitionGroup</a> action.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateHapgOutput {
    /// <p>The ARN of the high-availability partition group.</p>
    pub hapg_arn: std::option::Option<std::string::String>,
}
impl CreateHapgOutput {
    /// <p>The ARN of the high-availability partition group.</p>
    pub fn hapg_arn(&self) -> std::option::Option<&str> {
        self.hapg_arn.as_deref()
    }
}
impl std::fmt::Debug for CreateHapgOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateHapgOutput");
        formatter.field("hapg_arn", &self.hapg_arn);
        formatter.finish()
    }
}
/// See [`CreateHapgOutput`](crate::output::CreateHapgOutput)
pub mod create_hapg_output {
    /// A builder for [`CreateHapgOutput`](crate::output::CreateHapgOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) hapg_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the high-availability partition group.</p>
        pub fn hapg_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.hapg_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the high-availability partition group.</p>
        pub fn set_hapg_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.hapg_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateHapgOutput`](crate::output::CreateHapgOutput)
        pub fn build(self) -> crate::output::CreateHapgOutput {
            crate::output::CreateHapgOutput {
                hapg_arn: self.hapg_arn,
            }
        }
    }
}
impl CreateHapgOutput {
    /// Creates a new builder-style object to manufacture [`CreateHapgOutput`](crate::output::CreateHapgOutput)
    pub fn builder() -> crate::output::create_hapg_output::Builder {
        crate::output::create_hapg_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AddTagsToResourceOutput {
    /// <p>The status of the operation.</p>
    pub status: std::option::Option<std::string::String>,
}
impl AddTagsToResourceOutput {
    /// <p>The status of the operation.</p>
    pub fn status(&self) -> std::option::Option<&str> {
        self.status.as_deref()
    }
}
impl std::fmt::Debug for AddTagsToResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AddTagsToResourceOutput");
        formatter.field("status", &self.status);
        formatter.finish()
    }
}
/// See [`AddTagsToResourceOutput`](crate::output::AddTagsToResourceOutput)
pub mod add_tags_to_resource_output {
    /// A builder for [`AddTagsToResourceOutput`](crate::output::AddTagsToResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) status: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The status of the operation.</p>
        pub fn status(mut self, input: impl Into<std::string::String>) -> Self {
            self.status = Some(input.into());
            self
        }
        /// <p>The status of the operation.</p>
        pub fn set_status(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`AddTagsToResourceOutput`](crate::output::AddTagsToResourceOutput)
        pub fn build(self) -> crate::output::AddTagsToResourceOutput {
            crate::output::AddTagsToResourceOutput {
                status: self.status,
            }
        }
    }
}
impl AddTagsToResourceOutput {
    /// Creates a new builder-style object to manufacture [`AddTagsToResourceOutput`](crate::output::AddTagsToResourceOutput)
    pub fn builder() -> crate::output::add_tags_to_resource_output::Builder {
        crate::output::add_tags_to_resource_output::Builder::default()
    }
}
