// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
use std::fmt::Write;
/// See [`AddTagsToResourceInput`](crate::input::AddTagsToResourceInput)
pub mod add_tags_to_resource_input {
    /// A builder for [`AddTagsToResourceInput`](crate::input::AddTagsToResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) tag_list: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the AWS CloudHSM resource to tag.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the AWS CloudHSM resource to tag.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Appends an item to `tag_list`.
        ///
        /// To override the contents of this collection use [`set_tag_list`](Self::set_tag_list).
        ///
        /// <p>One or more tags.</p>
        pub fn tag_list(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tag_list.unwrap_or_default();
            v.push(input.into());
            self.tag_list = Some(v);
            self
        }
        /// <p>One or more tags.</p>
        pub fn set_tag_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tag_list = input;
            self
        }
        /// Consumes the builder and constructs a [`AddTagsToResourceInput`](crate::input::AddTagsToResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::AddTagsToResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::AddTagsToResourceInput {
                resource_arn: self.resource_arn,
                tag_list: self.tag_list,
            })
        }
    }
}
#[doc(hidden)]
pub type AddTagsToResourceInputOperationOutputAlias = crate::operation::AddTagsToResource;
#[doc(hidden)]
pub type AddTagsToResourceInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl AddTagsToResourceInput {
    /// Consumes the builder and constructs an Operation<[`AddTagsToResource`](crate::operation::AddTagsToResource)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::AddTagsToResource,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::AddTagsToResourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::AddTagsToResourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::AddTagsToResourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "CloudHsmFrontendService.AddTagsToResource",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_add_tags_to_resource(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::AddTagsToResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "AddTagsToResource",
            "cloudhsm",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`AddTagsToResourceInput`](crate::input::AddTagsToResourceInput)
    pub fn builder() -> crate::input::add_tags_to_resource_input::Builder {
        crate::input::add_tags_to_resource_input::Builder::default()
    }
}

/// See [`CreateHapgInput`](crate::input::CreateHapgInput)
pub mod create_hapg_input {
    /// A builder for [`CreateHapgInput`](crate::input::CreateHapgInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) label: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The label of the new high-availability partition group.</p>
        pub fn label(mut self, input: impl Into<std::string::String>) -> Self {
            self.label = Some(input.into());
            self
        }
        /// <p>The label of the new high-availability partition group.</p>
        pub fn set_label(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.label = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateHapgInput`](crate::input::CreateHapgInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateHapgInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateHapgInput { label: self.label })
        }
    }
}
#[doc(hidden)]
pub type CreateHapgInputOperationOutputAlias = crate::operation::CreateHapg;
#[doc(hidden)]
pub type CreateHapgInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateHapgInput {
    /// Consumes the builder and constructs an Operation<[`CreateHapg`](crate::operation::CreateHapg)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateHapg,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateHapgInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateHapgInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateHapgInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "CloudHsmFrontendService.CreateHapg",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_create_hapg(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateHapg::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateHapg",
            "cloudhsm",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateHapgInput`](crate::input::CreateHapgInput)
    pub fn builder() -> crate::input::create_hapg_input::Builder {
        crate::input::create_hapg_input::Builder::default()
    }
}

/// See [`CreateHsmInput`](crate::input::CreateHsmInput)
pub mod create_hsm_input {
    /// A builder for [`CreateHsmInput`](crate::input::CreateHsmInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) subnet_id: std::option::Option<std::string::String>,
        pub(crate) ssh_key: std::option::Option<std::string::String>,
        pub(crate) eni_ip: std::option::Option<std::string::String>,
        pub(crate) iam_role_arn: std::option::Option<std::string::String>,
        pub(crate) external_id: std::option::Option<std::string::String>,
        pub(crate) subscription_type: std::option::Option<crate::model::SubscriptionType>,
        pub(crate) client_token: std::option::Option<std::string::String>,
        pub(crate) syslog_ip: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier of the subnet in your VPC in which to place the HSM.</p>
        pub fn subnet_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.subnet_id = Some(input.into());
            self
        }
        /// <p>The identifier of the subnet in your VPC in which to place the HSM.</p>
        pub fn set_subnet_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.subnet_id = input;
            self
        }
        /// <p>The SSH public key to install on the HSM.</p>
        pub fn ssh_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.ssh_key = Some(input.into());
            self
        }
        /// <p>The SSH public key to install on the HSM.</p>
        pub fn set_ssh_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.ssh_key = input;
            self
        }
        /// <p>The IP address to assign to the HSM's ENI.</p>
        /// <p>If an IP address is not specified, an IP address will be randomly chosen from the CIDR
        /// range of the subnet.</p>
        pub fn eni_ip(mut self, input: impl Into<std::string::String>) -> Self {
            self.eni_ip = Some(input.into());
            self
        }
        /// <p>The IP address to assign to the HSM's ENI.</p>
        /// <p>If an IP address is not specified, an IP address will be randomly chosen from the CIDR
        /// range of the subnet.</p>
        pub fn set_eni_ip(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.eni_ip = input;
            self
        }
        /// <p>The ARN of an IAM role to enable the AWS CloudHSM service to allocate an ENI on your
        /// behalf.</p>
        pub fn iam_role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.iam_role_arn = Some(input.into());
            self
        }
        /// <p>The ARN of an IAM role to enable the AWS CloudHSM service to allocate an ENI on your
        /// behalf.</p>
        pub fn set_iam_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.iam_role_arn = input;
            self
        }
        /// <p>The external ID from <code>IamRoleArn</code>, if present.</p>
        pub fn external_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.external_id = Some(input.into());
            self
        }
        /// <p>The external ID from <code>IamRoleArn</code>, if present.</p>
        pub fn set_external_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.external_id = input;
            self
        }
        /// <p>Specifies the type of subscription for the HSM.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>PRODUCTION</b> - The HSM is being used in a production
        /// environment.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>TRIAL</b> - The HSM is being used in a product
        /// trial.</p>
        /// </li>
        /// </ul>
        pub fn subscription_type(mut self, input: crate::model::SubscriptionType) -> Self {
            self.subscription_type = Some(input);
            self
        }
        /// <p>Specifies the type of subscription for the HSM.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>PRODUCTION</b> - The HSM is being used in a production
        /// environment.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>TRIAL</b> - The HSM is being used in a product
        /// trial.</p>
        /// </li>
        /// </ul>
        pub fn set_subscription_type(
            mut self,
            input: std::option::Option<crate::model::SubscriptionType>,
        ) -> Self {
            self.subscription_type = input;
            self
        }
        /// <p>A user-defined token to ensure idempotence. Subsequent calls to this operation with the
        /// same token will be ignored.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p>A user-defined token to ensure idempotence. Subsequent calls to this operation with the
        /// same token will be ignored.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// <p>The IP address for the syslog monitoring server. The AWS CloudHSM service only supports one
        /// syslog monitoring server.</p>
        pub fn syslog_ip(mut self, input: impl Into<std::string::String>) -> Self {
            self.syslog_ip = Some(input.into());
            self
        }
        /// <p>The IP address for the syslog monitoring server. The AWS CloudHSM service only supports one
        /// syslog monitoring server.</p>
        pub fn set_syslog_ip(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.syslog_ip = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateHsmInput`](crate::input::CreateHsmInput)
        pub fn build(
            self,
        ) -> std::result::Result<crate::input::CreateHsmInput, aws_smithy_http::operation::BuildError>
        {
            Ok(crate::input::CreateHsmInput {
                subnet_id: self.subnet_id,
                ssh_key: self.ssh_key,
                eni_ip: self.eni_ip,
                iam_role_arn: self.iam_role_arn,
                external_id: self.external_id,
                subscription_type: self.subscription_type,
                client_token: self.client_token,
                syslog_ip: self.syslog_ip,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateHsmInputOperationOutputAlias = crate::operation::CreateHsm;
#[doc(hidden)]
pub type CreateHsmInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateHsmInput {
    /// Consumes the builder and constructs an Operation<[`CreateHsm`](crate::operation::CreateHsm)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateHsm,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateHsmInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateHsmInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateHsmInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "CloudHsmFrontendService.CreateHsm",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_create_hsm(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op =
            aws_smithy_http::operation::Operation::new(request, crate::operation::CreateHsm::new())
                .with_metadata(aws_smithy_http::operation::Metadata::new(
                    "CreateHsm",
                    "cloudhsm",
                ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateHsmInput`](crate::input::CreateHsmInput)
    pub fn builder() -> crate::input::create_hsm_input::Builder {
        crate::input::create_hsm_input::Builder::default()
    }
}

/// See [`CreateLunaClientInput`](crate::input::CreateLunaClientInput)
pub mod create_luna_client_input {
    /// A builder for [`CreateLunaClientInput`](crate::input::CreateLunaClientInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) label: std::option::Option<std::string::String>,
        pub(crate) certificate: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The label for the client.</p>
        pub fn label(mut self, input: impl Into<std::string::String>) -> Self {
            self.label = Some(input.into());
            self
        }
        /// <p>The label for the client.</p>
        pub fn set_label(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.label = input;
            self
        }
        /// <p>The contents of a Base64-Encoded X.509 v3 certificate to be installed on the HSMs used
        /// by this client.</p>
        pub fn certificate(mut self, input: impl Into<std::string::String>) -> Self {
            self.certificate = Some(input.into());
            self
        }
        /// <p>The contents of a Base64-Encoded X.509 v3 certificate to be installed on the HSMs used
        /// by this client.</p>
        pub fn set_certificate(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.certificate = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateLunaClientInput`](crate::input::CreateLunaClientInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateLunaClientInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateLunaClientInput {
                label: self.label,
                certificate: self.certificate,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateLunaClientInputOperationOutputAlias = crate::operation::CreateLunaClient;
#[doc(hidden)]
pub type CreateLunaClientInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateLunaClientInput {
    /// Consumes the builder and constructs an Operation<[`CreateLunaClient`](crate::operation::CreateLunaClient)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateLunaClient,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateLunaClientInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateLunaClientInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateLunaClientInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "CloudHsmFrontendService.CreateLunaClient",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_luna_client(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateLunaClient::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateLunaClient",
            "cloudhsm",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateLunaClientInput`](crate::input::CreateLunaClientInput)
    pub fn builder() -> crate::input::create_luna_client_input::Builder {
        crate::input::create_luna_client_input::Builder::default()
    }
}

/// See [`DeleteHapgInput`](crate::input::DeleteHapgInput)
pub mod delete_hapg_input {
    /// A builder for [`DeleteHapgInput`](crate::input::DeleteHapgInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) hapg_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the high-availability partition group to delete.</p>
        pub fn hapg_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.hapg_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the high-availability partition group to delete.</p>
        pub fn set_hapg_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.hapg_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteHapgInput`](crate::input::DeleteHapgInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteHapgInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteHapgInput {
                hapg_arn: self.hapg_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteHapgInputOperationOutputAlias = crate::operation::DeleteHapg;
#[doc(hidden)]
pub type DeleteHapgInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteHapgInput {
    /// Consumes the builder and constructs an Operation<[`DeleteHapg`](crate::operation::DeleteHapg)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteHapg,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteHapgInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteHapgInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteHapgInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "CloudHsmFrontendService.DeleteHapg",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_delete_hapg(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteHapg::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteHapg",
            "cloudhsm",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteHapgInput`](crate::input::DeleteHapgInput)
    pub fn builder() -> crate::input::delete_hapg_input::Builder {
        crate::input::delete_hapg_input::Builder::default()
    }
}

/// See [`DeleteHsmInput`](crate::input::DeleteHsmInput)
pub mod delete_hsm_input {
    /// A builder for [`DeleteHsmInput`](crate::input::DeleteHsmInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) hsm_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the HSM to delete.</p>
        pub fn hsm_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.hsm_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the HSM to delete.</p>
        pub fn set_hsm_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.hsm_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteHsmInput`](crate::input::DeleteHsmInput)
        pub fn build(
            self,
        ) -> std::result::Result<crate::input::DeleteHsmInput, aws_smithy_http::operation::BuildError>
        {
            Ok(crate::input::DeleteHsmInput {
                hsm_arn: self.hsm_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteHsmInputOperationOutputAlias = crate::operation::DeleteHsm;
#[doc(hidden)]
pub type DeleteHsmInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteHsmInput {
    /// Consumes the builder and constructs an Operation<[`DeleteHsm`](crate::operation::DeleteHsm)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteHsm,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteHsmInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteHsmInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteHsmInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "CloudHsmFrontendService.DeleteHsm",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_delete_hsm(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op =
            aws_smithy_http::operation::Operation::new(request, crate::operation::DeleteHsm::new())
                .with_metadata(aws_smithy_http::operation::Metadata::new(
                    "DeleteHsm",
                    "cloudhsm",
                ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteHsmInput`](crate::input::DeleteHsmInput)
    pub fn builder() -> crate::input::delete_hsm_input::Builder {
        crate::input::delete_hsm_input::Builder::default()
    }
}

/// See [`DeleteLunaClientInput`](crate::input::DeleteLunaClientInput)
pub mod delete_luna_client_input {
    /// A builder for [`DeleteLunaClientInput`](crate::input::DeleteLunaClientInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) client_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the client to delete.</p>
        pub fn client_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the client to delete.</p>
        pub fn set_client_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteLunaClientInput`](crate::input::DeleteLunaClientInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteLunaClientInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteLunaClientInput {
                client_arn: self.client_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteLunaClientInputOperationOutputAlias = crate::operation::DeleteLunaClient;
#[doc(hidden)]
pub type DeleteLunaClientInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteLunaClientInput {
    /// Consumes the builder and constructs an Operation<[`DeleteLunaClient`](crate::operation::DeleteLunaClient)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteLunaClient,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteLunaClientInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteLunaClientInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteLunaClientInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "CloudHsmFrontendService.DeleteLunaClient",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_delete_luna_client(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteLunaClient::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteLunaClient",
            "cloudhsm",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteLunaClientInput`](crate::input::DeleteLunaClientInput)
    pub fn builder() -> crate::input::delete_luna_client_input::Builder {
        crate::input::delete_luna_client_input::Builder::default()
    }
}

/// See [`DescribeHapgInput`](crate::input::DescribeHapgInput)
pub mod describe_hapg_input {
    /// A builder for [`DescribeHapgInput`](crate::input::DescribeHapgInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) hapg_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the high-availability partition group to describe.</p>
        pub fn hapg_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.hapg_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the high-availability partition group to describe.</p>
        pub fn set_hapg_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.hapg_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeHapgInput`](crate::input::DescribeHapgInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeHapgInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeHapgInput {
                hapg_arn: self.hapg_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeHapgInputOperationOutputAlias = crate::operation::DescribeHapg;
#[doc(hidden)]
pub type DescribeHapgInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeHapgInput {
    /// Consumes the builder and constructs an Operation<[`DescribeHapg`](crate::operation::DescribeHapg)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeHapg,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeHapgInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeHapgInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeHapgInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "CloudHsmFrontendService.DescribeHapg",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_describe_hapg(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeHapg::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeHapg",
            "cloudhsm",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeHapgInput`](crate::input::DescribeHapgInput)
    pub fn builder() -> crate::input::describe_hapg_input::Builder {
        crate::input::describe_hapg_input::Builder::default()
    }
}

/// See [`DescribeHsmInput`](crate::input::DescribeHsmInput)
pub mod describe_hsm_input {
    /// A builder for [`DescribeHsmInput`](crate::input::DescribeHsmInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) hsm_arn: std::option::Option<std::string::String>,
        pub(crate) hsm_serial_number: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the HSM. Either the <code>HsmArn</code> or the <code>SerialNumber</code>
        /// parameter must be specified.</p>
        pub fn hsm_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.hsm_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the HSM. Either the <code>HsmArn</code> or the <code>SerialNumber</code>
        /// parameter must be specified.</p>
        pub fn set_hsm_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.hsm_arn = input;
            self
        }
        /// <p>The serial number of the HSM. Either the <code>HsmArn</code> or the
        /// <code>HsmSerialNumber</code> parameter must be specified.</p>
        pub fn hsm_serial_number(mut self, input: impl Into<std::string::String>) -> Self {
            self.hsm_serial_number = Some(input.into());
            self
        }
        /// <p>The serial number of the HSM. Either the <code>HsmArn</code> or the
        /// <code>HsmSerialNumber</code> parameter must be specified.</p>
        pub fn set_hsm_serial_number(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.hsm_serial_number = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeHsmInput`](crate::input::DescribeHsmInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeHsmInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeHsmInput {
                hsm_arn: self.hsm_arn,
                hsm_serial_number: self.hsm_serial_number,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeHsmInputOperationOutputAlias = crate::operation::DescribeHsm;
#[doc(hidden)]
pub type DescribeHsmInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeHsmInput {
    /// Consumes the builder and constructs an Operation<[`DescribeHsm`](crate::operation::DescribeHsm)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeHsm,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeHsmInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeHsmInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeHsmInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "CloudHsmFrontendService.DescribeHsm",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_describe_hsm(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeHsm::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeHsm",
            "cloudhsm",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeHsmInput`](crate::input::DescribeHsmInput)
    pub fn builder() -> crate::input::describe_hsm_input::Builder {
        crate::input::describe_hsm_input::Builder::default()
    }
}

/// See [`DescribeLunaClientInput`](crate::input::DescribeLunaClientInput)
pub mod describe_luna_client_input {
    /// A builder for [`DescribeLunaClientInput`](crate::input::DescribeLunaClientInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) client_arn: std::option::Option<std::string::String>,
        pub(crate) certificate_fingerprint: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the client.</p>
        pub fn client_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the client.</p>
        pub fn set_client_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_arn = input;
            self
        }
        /// <p>The certificate fingerprint.</p>
        pub fn certificate_fingerprint(mut self, input: impl Into<std::string::String>) -> Self {
            self.certificate_fingerprint = Some(input.into());
            self
        }
        /// <p>The certificate fingerprint.</p>
        pub fn set_certificate_fingerprint(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.certificate_fingerprint = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeLunaClientInput`](crate::input::DescribeLunaClientInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeLunaClientInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeLunaClientInput {
                client_arn: self.client_arn,
                certificate_fingerprint: self.certificate_fingerprint,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeLunaClientInputOperationOutputAlias = crate::operation::DescribeLunaClient;
#[doc(hidden)]
pub type DescribeLunaClientInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeLunaClientInput {
    /// Consumes the builder and constructs an Operation<[`DescribeLunaClient`](crate::operation::DescribeLunaClient)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeLunaClient,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeLunaClientInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeLunaClientInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeLunaClientInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "CloudHsmFrontendService.DescribeLunaClient",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_luna_client(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeLunaClient::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeLunaClient",
            "cloudhsm",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeLunaClientInput`](crate::input::DescribeLunaClientInput)
    pub fn builder() -> crate::input::describe_luna_client_input::Builder {
        crate::input::describe_luna_client_input::Builder::default()
    }
}

/// See [`GetConfigInput`](crate::input::GetConfigInput)
pub mod get_config_input {
    /// A builder for [`GetConfigInput`](crate::input::GetConfigInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) client_arn: std::option::Option<std::string::String>,
        pub(crate) client_version: std::option::Option<crate::model::ClientVersion>,
        pub(crate) hapg_list: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The ARN of the client.</p>
        pub fn client_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the client.</p>
        pub fn set_client_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_arn = input;
            self
        }
        /// <p>The client version.</p>
        pub fn client_version(mut self, input: crate::model::ClientVersion) -> Self {
            self.client_version = Some(input);
            self
        }
        /// <p>The client version.</p>
        pub fn set_client_version(
            mut self,
            input: std::option::Option<crate::model::ClientVersion>,
        ) -> Self {
            self.client_version = input;
            self
        }
        /// Appends an item to `hapg_list`.
        ///
        /// To override the contents of this collection use [`set_hapg_list`](Self::set_hapg_list).
        ///
        /// <p>A list of ARNs that identify the high-availability partition groups that are associated
        /// with the client.</p>
        pub fn hapg_list(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.hapg_list.unwrap_or_default();
            v.push(input.into());
            self.hapg_list = Some(v);
            self
        }
        /// <p>A list of ARNs that identify the high-availability partition groups that are associated
        /// with the client.</p>
        pub fn set_hapg_list(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.hapg_list = input;
            self
        }
        /// Consumes the builder and constructs a [`GetConfigInput`](crate::input::GetConfigInput)
        pub fn build(
            self,
        ) -> std::result::Result<crate::input::GetConfigInput, aws_smithy_http::operation::BuildError>
        {
            Ok(crate::input::GetConfigInput {
                client_arn: self.client_arn,
                client_version: self.client_version,
                hapg_list: self.hapg_list,
            })
        }
    }
}
#[doc(hidden)]
pub type GetConfigInputOperationOutputAlias = crate::operation::GetConfig;
#[doc(hidden)]
pub type GetConfigInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetConfigInput {
    /// Consumes the builder and constructs an Operation<[`GetConfig`](crate::operation::GetConfig)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetConfig,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetConfigInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetConfigInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetConfigInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "CloudHsmFrontendService.GetConfig",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_get_config(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op =
            aws_smithy_http::operation::Operation::new(request, crate::operation::GetConfig::new())
                .with_metadata(aws_smithy_http::operation::Metadata::new(
                    "GetConfig",
                    "cloudhsm",
                ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetConfigInput`](crate::input::GetConfigInput)
    pub fn builder() -> crate::input::get_config_input::Builder {
        crate::input::get_config_input::Builder::default()
    }
}

/// See [`ListAvailableZonesInput`](crate::input::ListAvailableZonesInput)
pub mod list_available_zones_input {
    /// A builder for [`ListAvailableZonesInput`](crate::input::ListAvailableZonesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`ListAvailableZonesInput`](crate::input::ListAvailableZonesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListAvailableZonesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListAvailableZonesInput {})
        }
    }
}
#[doc(hidden)]
pub type ListAvailableZonesInputOperationOutputAlias = crate::operation::ListAvailableZones;
#[doc(hidden)]
pub type ListAvailableZonesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListAvailableZonesInput {
    /// Consumes the builder and constructs an Operation<[`ListAvailableZones`](crate::operation::ListAvailableZones)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListAvailableZones,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListAvailableZonesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListAvailableZonesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListAvailableZonesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "CloudHsmFrontendService.ListAvailableZones",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_available_zones(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListAvailableZones::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListAvailableZones",
            "cloudhsm",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListAvailableZonesInput`](crate::input::ListAvailableZonesInput)
    pub fn builder() -> crate::input::list_available_zones_input::Builder {
        crate::input::list_available_zones_input::Builder::default()
    }
}

/// See [`ListHapgsInput`](crate::input::ListHapgsInput)
pub mod list_hapgs_input {
    /// A builder for [`ListHapgsInput`](crate::input::ListHapgsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The <code>NextToken</code> value from a previous call to <code>ListHapgs</code>. Pass
        /// null if this is the first call.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The <code>NextToken</code> value from a previous call to <code>ListHapgs</code>. Pass
        /// null if this is the first call.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListHapgsInput`](crate::input::ListHapgsInput)
        pub fn build(
            self,
        ) -> std::result::Result<crate::input::ListHapgsInput, aws_smithy_http::operation::BuildError>
        {
            Ok(crate::input::ListHapgsInput {
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListHapgsInputOperationOutputAlias = crate::operation::ListHapgs;
#[doc(hidden)]
pub type ListHapgsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListHapgsInput {
    /// Consumes the builder and constructs an Operation<[`ListHapgs`](crate::operation::ListHapgs)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListHapgs,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListHapgsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListHapgsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListHapgsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "CloudHsmFrontendService.ListHapgs",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_list_hapgs(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op =
            aws_smithy_http::operation::Operation::new(request, crate::operation::ListHapgs::new())
                .with_metadata(aws_smithy_http::operation::Metadata::new(
                    "ListHapgs",
                    "cloudhsm",
                ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListHapgsInput`](crate::input::ListHapgsInput)
    pub fn builder() -> crate::input::list_hapgs_input::Builder {
        crate::input::list_hapgs_input::Builder::default()
    }
}

/// See [`ListHsmsInput`](crate::input::ListHsmsInput)
pub mod list_hsms_input {
    /// A builder for [`ListHsmsInput`](crate::input::ListHsmsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The <code>NextToken</code> value from a previous call to <code>ListHsms</code>. Pass
        /// null if this is the first call.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The <code>NextToken</code> value from a previous call to <code>ListHsms</code>. Pass
        /// null if this is the first call.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListHsmsInput`](crate::input::ListHsmsInput)
        pub fn build(
            self,
        ) -> std::result::Result<crate::input::ListHsmsInput, aws_smithy_http::operation::BuildError>
        {
            Ok(crate::input::ListHsmsInput {
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListHsmsInputOperationOutputAlias = crate::operation::ListHsms;
#[doc(hidden)]
pub type ListHsmsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListHsmsInput {
    /// Consumes the builder and constructs an Operation<[`ListHsms`](crate::operation::ListHsms)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListHsms,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListHsmsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListHsmsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListHsmsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "CloudHsmFrontendService.ListHsms",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_list_hsms(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op =
            aws_smithy_http::operation::Operation::new(request, crate::operation::ListHsms::new())
                .with_metadata(aws_smithy_http::operation::Metadata::new(
                    "ListHsms", "cloudhsm",
                ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListHsmsInput`](crate::input::ListHsmsInput)
    pub fn builder() -> crate::input::list_hsms_input::Builder {
        crate::input::list_hsms_input::Builder::default()
    }
}

/// See [`ListLunaClientsInput`](crate::input::ListLunaClientsInput)
pub mod list_luna_clients_input {
    /// A builder for [`ListLunaClientsInput`](crate::input::ListLunaClientsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The <code>NextToken</code> value from a previous call to <code>ListLunaClients</code>.
        /// Pass null if this is the first call.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The <code>NextToken</code> value from a previous call to <code>ListLunaClients</code>.
        /// Pass null if this is the first call.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListLunaClientsInput`](crate::input::ListLunaClientsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListLunaClientsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListLunaClientsInput {
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListLunaClientsInputOperationOutputAlias = crate::operation::ListLunaClients;
#[doc(hidden)]
pub type ListLunaClientsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListLunaClientsInput {
    /// Consumes the builder and constructs an Operation<[`ListLunaClients`](crate::operation::ListLunaClients)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListLunaClients,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListLunaClientsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListLunaClientsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListLunaClientsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "CloudHsmFrontendService.ListLunaClients",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_luna_clients(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListLunaClients::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListLunaClients",
            "cloudhsm",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListLunaClientsInput`](crate::input::ListLunaClientsInput)
    pub fn builder() -> crate::input::list_luna_clients_input::Builder {
        crate::input::list_luna_clients_input::Builder::default()
    }
}

/// See [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
pub mod list_tags_for_resource_input {
    /// A builder for [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the AWS CloudHSM resource.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the AWS CloudHSM resource.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListTagsForResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListTagsForResourceInput {
                resource_arn: self.resource_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type ListTagsForResourceInputOperationOutputAlias = crate::operation::ListTagsForResource;
#[doc(hidden)]
pub type ListTagsForResourceInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListTagsForResourceInput {
    /// Consumes the builder and constructs an Operation<[`ListTagsForResource`](crate::operation::ListTagsForResource)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListTagsForResource,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListTagsForResourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListTagsForResourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListTagsForResourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "CloudHsmFrontendService.ListTagsForResource",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_tags_for_resource(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListTagsForResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListTagsForResource",
            "cloudhsm",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    pub fn builder() -> crate::input::list_tags_for_resource_input::Builder {
        crate::input::list_tags_for_resource_input::Builder::default()
    }
}

/// See [`ModifyHapgInput`](crate::input::ModifyHapgInput)
pub mod modify_hapg_input {
    /// A builder for [`ModifyHapgInput`](crate::input::ModifyHapgInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) hapg_arn: std::option::Option<std::string::String>,
        pub(crate) label: std::option::Option<std::string::String>,
        pub(crate) partition_serial_list: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The ARN of the high-availability partition group to modify.</p>
        pub fn hapg_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.hapg_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the high-availability partition group to modify.</p>
        pub fn set_hapg_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.hapg_arn = input;
            self
        }
        /// <p>The new label for the high-availability partition group.</p>
        pub fn label(mut self, input: impl Into<std::string::String>) -> Self {
            self.label = Some(input.into());
            self
        }
        /// <p>The new label for the high-availability partition group.</p>
        pub fn set_label(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.label = input;
            self
        }
        /// Appends an item to `partition_serial_list`.
        ///
        /// To override the contents of this collection use [`set_partition_serial_list`](Self::set_partition_serial_list).
        ///
        /// <p>The list of partition serial numbers to make members of the high-availability partition
        /// group.</p>
        pub fn partition_serial_list(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.partition_serial_list.unwrap_or_default();
            v.push(input.into());
            self.partition_serial_list = Some(v);
            self
        }
        /// <p>The list of partition serial numbers to make members of the high-availability partition
        /// group.</p>
        pub fn set_partition_serial_list(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.partition_serial_list = input;
            self
        }
        /// Consumes the builder and constructs a [`ModifyHapgInput`](crate::input::ModifyHapgInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ModifyHapgInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ModifyHapgInput {
                hapg_arn: self.hapg_arn,
                label: self.label,
                partition_serial_list: self.partition_serial_list,
            })
        }
    }
}
#[doc(hidden)]
pub type ModifyHapgInputOperationOutputAlias = crate::operation::ModifyHapg;
#[doc(hidden)]
pub type ModifyHapgInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ModifyHapgInput {
    /// Consumes the builder and constructs an Operation<[`ModifyHapg`](crate::operation::ModifyHapg)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ModifyHapg,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ModifyHapgInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ModifyHapgInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ModifyHapgInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "CloudHsmFrontendService.ModifyHapg",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_modify_hapg(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ModifyHapg::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ModifyHapg",
            "cloudhsm",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ModifyHapgInput`](crate::input::ModifyHapgInput)
    pub fn builder() -> crate::input::modify_hapg_input::Builder {
        crate::input::modify_hapg_input::Builder::default()
    }
}

/// See [`ModifyHsmInput`](crate::input::ModifyHsmInput)
pub mod modify_hsm_input {
    /// A builder for [`ModifyHsmInput`](crate::input::ModifyHsmInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) hsm_arn: std::option::Option<std::string::String>,
        pub(crate) subnet_id: std::option::Option<std::string::String>,
        pub(crate) eni_ip: std::option::Option<std::string::String>,
        pub(crate) iam_role_arn: std::option::Option<std::string::String>,
        pub(crate) external_id: std::option::Option<std::string::String>,
        pub(crate) syslog_ip: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the HSM to modify.</p>
        pub fn hsm_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.hsm_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the HSM to modify.</p>
        pub fn set_hsm_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.hsm_arn = input;
            self
        }
        /// <p>The new identifier of the subnet that the HSM is in. The new subnet must be in the same
        /// Availability Zone as the current subnet.</p>
        pub fn subnet_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.subnet_id = Some(input.into());
            self
        }
        /// <p>The new identifier of the subnet that the HSM is in. The new subnet must be in the same
        /// Availability Zone as the current subnet.</p>
        pub fn set_subnet_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.subnet_id = input;
            self
        }
        /// <p>The new IP address for the elastic network interface (ENI) attached to the
        /// HSM.</p>
        /// <p>If the HSM is moved to a different subnet, and an IP address is not specified, an IP
        /// address will be randomly chosen from the CIDR range of the new subnet.</p>
        pub fn eni_ip(mut self, input: impl Into<std::string::String>) -> Self {
            self.eni_ip = Some(input.into());
            self
        }
        /// <p>The new IP address for the elastic network interface (ENI) attached to the
        /// HSM.</p>
        /// <p>If the HSM is moved to a different subnet, and an IP address is not specified, an IP
        /// address will be randomly chosen from the CIDR range of the new subnet.</p>
        pub fn set_eni_ip(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.eni_ip = input;
            self
        }
        /// <p>The new IAM role ARN.</p>
        pub fn iam_role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.iam_role_arn = Some(input.into());
            self
        }
        /// <p>The new IAM role ARN.</p>
        pub fn set_iam_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.iam_role_arn = input;
            self
        }
        /// <p>The new external ID.</p>
        pub fn external_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.external_id = Some(input.into());
            self
        }
        /// <p>The new external ID.</p>
        pub fn set_external_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.external_id = input;
            self
        }
        /// <p>The new IP address for the syslog monitoring server. The AWS CloudHSM service only supports
        /// one syslog monitoring server.</p>
        pub fn syslog_ip(mut self, input: impl Into<std::string::String>) -> Self {
            self.syslog_ip = Some(input.into());
            self
        }
        /// <p>The new IP address for the syslog monitoring server. The AWS CloudHSM service only supports
        /// one syslog monitoring server.</p>
        pub fn set_syslog_ip(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.syslog_ip = input;
            self
        }
        /// Consumes the builder and constructs a [`ModifyHsmInput`](crate::input::ModifyHsmInput)
        pub fn build(
            self,
        ) -> std::result::Result<crate::input::ModifyHsmInput, aws_smithy_http::operation::BuildError>
        {
            Ok(crate::input::ModifyHsmInput {
                hsm_arn: self.hsm_arn,
                subnet_id: self.subnet_id,
                eni_ip: self.eni_ip,
                iam_role_arn: self.iam_role_arn,
                external_id: self.external_id,
                syslog_ip: self.syslog_ip,
            })
        }
    }
}
#[doc(hidden)]
pub type ModifyHsmInputOperationOutputAlias = crate::operation::ModifyHsm;
#[doc(hidden)]
pub type ModifyHsmInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ModifyHsmInput {
    /// Consumes the builder and constructs an Operation<[`ModifyHsm`](crate::operation::ModifyHsm)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ModifyHsm,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ModifyHsmInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ModifyHsmInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ModifyHsmInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "CloudHsmFrontendService.ModifyHsm",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_modify_hsm(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op =
            aws_smithy_http::operation::Operation::new(request, crate::operation::ModifyHsm::new())
                .with_metadata(aws_smithy_http::operation::Metadata::new(
                    "ModifyHsm",
                    "cloudhsm",
                ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ModifyHsmInput`](crate::input::ModifyHsmInput)
    pub fn builder() -> crate::input::modify_hsm_input::Builder {
        crate::input::modify_hsm_input::Builder::default()
    }
}

/// See [`ModifyLunaClientInput`](crate::input::ModifyLunaClientInput)
pub mod modify_luna_client_input {
    /// A builder for [`ModifyLunaClientInput`](crate::input::ModifyLunaClientInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) client_arn: std::option::Option<std::string::String>,
        pub(crate) certificate: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the client.</p>
        pub fn client_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the client.</p>
        pub fn set_client_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_arn = input;
            self
        }
        /// <p>The new certificate for the client.</p>
        pub fn certificate(mut self, input: impl Into<std::string::String>) -> Self {
            self.certificate = Some(input.into());
            self
        }
        /// <p>The new certificate for the client.</p>
        pub fn set_certificate(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.certificate = input;
            self
        }
        /// Consumes the builder and constructs a [`ModifyLunaClientInput`](crate::input::ModifyLunaClientInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ModifyLunaClientInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ModifyLunaClientInput {
                client_arn: self.client_arn,
                certificate: self.certificate,
            })
        }
    }
}
#[doc(hidden)]
pub type ModifyLunaClientInputOperationOutputAlias = crate::operation::ModifyLunaClient;
#[doc(hidden)]
pub type ModifyLunaClientInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ModifyLunaClientInput {
    /// Consumes the builder and constructs an Operation<[`ModifyLunaClient`](crate::operation::ModifyLunaClient)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ModifyLunaClient,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ModifyLunaClientInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ModifyLunaClientInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ModifyLunaClientInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "CloudHsmFrontendService.ModifyLunaClient",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_modify_luna_client(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ModifyLunaClient::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ModifyLunaClient",
            "cloudhsm",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ModifyLunaClientInput`](crate::input::ModifyLunaClientInput)
    pub fn builder() -> crate::input::modify_luna_client_input::Builder {
        crate::input::modify_luna_client_input::Builder::default()
    }
}

/// See [`RemoveTagsFromResourceInput`](crate::input::RemoveTagsFromResourceInput)
pub mod remove_tags_from_resource_input {
    /// A builder for [`RemoveTagsFromResourceInput`](crate::input::RemoveTagsFromResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) tag_key_list: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the AWS CloudHSM resource.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the AWS CloudHSM resource.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Appends an item to `tag_key_list`.
        ///
        /// To override the contents of this collection use [`set_tag_key_list`](Self::set_tag_key_list).
        ///
        /// <p>The tag key or keys to remove.</p>
        /// <p>Specify only the tag key to remove (not the value). To overwrite the value for an
        /// existing tag, use <a>AddTagsToResource</a>.</p>
        pub fn tag_key_list(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.tag_key_list.unwrap_or_default();
            v.push(input.into());
            self.tag_key_list = Some(v);
            self
        }
        /// <p>The tag key or keys to remove.</p>
        /// <p>Specify only the tag key to remove (not the value). To overwrite the value for an
        /// existing tag, use <a>AddTagsToResource</a>.</p>
        pub fn set_tag_key_list(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.tag_key_list = input;
            self
        }
        /// Consumes the builder and constructs a [`RemoveTagsFromResourceInput`](crate::input::RemoveTagsFromResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::RemoveTagsFromResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::RemoveTagsFromResourceInput {
                resource_arn: self.resource_arn,
                tag_key_list: self.tag_key_list,
            })
        }
    }
}
#[doc(hidden)]
pub type RemoveTagsFromResourceInputOperationOutputAlias = crate::operation::RemoveTagsFromResource;
#[doc(hidden)]
pub type RemoveTagsFromResourceInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl RemoveTagsFromResourceInput {
    /// Consumes the builder and constructs an Operation<[`RemoveTagsFromResource`](crate::operation::RemoveTagsFromResource)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::RemoveTagsFromResource,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::RemoveTagsFromResourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::RemoveTagsFromResourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::RemoveTagsFromResourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "CloudHsmFrontendService.RemoveTagsFromResource",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_remove_tags_from_resource(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::RemoveTagsFromResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "RemoveTagsFromResource",
            "cloudhsm",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`RemoveTagsFromResourceInput`](crate::input::RemoveTagsFromResourceInput)
    pub fn builder() -> crate::input::remove_tags_from_resource_input::Builder {
        crate::input::remove_tags_from_resource_input::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RemoveTagsFromResourceInput {
    /// <p>The Amazon Resource Name (ARN) of the AWS CloudHSM resource.</p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>The tag key or keys to remove.</p>
    /// <p>Specify only the tag key to remove (not the value). To overwrite the value for an
    /// existing tag, use <a>AddTagsToResource</a>.</p>
    pub tag_key_list: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl RemoveTagsFromResourceInput {
    /// <p>The Amazon Resource Name (ARN) of the AWS CloudHSM resource.</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
    /// <p>The tag key or keys to remove.</p>
    /// <p>Specify only the tag key to remove (not the value). To overwrite the value for an
    /// existing tag, use <a>AddTagsToResource</a>.</p>
    pub fn tag_key_list(&self) -> std::option::Option<&[std::string::String]> {
        self.tag_key_list.as_deref()
    }
}
impl std::fmt::Debug for RemoveTagsFromResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RemoveTagsFromResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("tag_key_list", &self.tag_key_list);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ModifyLunaClientInput {
    /// <p>The ARN of the client.</p>
    pub client_arn: std::option::Option<std::string::String>,
    /// <p>The new certificate for the client.</p>
    pub certificate: std::option::Option<std::string::String>,
}
impl ModifyLunaClientInput {
    /// <p>The ARN of the client.</p>
    pub fn client_arn(&self) -> std::option::Option<&str> {
        self.client_arn.as_deref()
    }
    /// <p>The new certificate for the client.</p>
    pub fn certificate(&self) -> std::option::Option<&str> {
        self.certificate.as_deref()
    }
}
impl std::fmt::Debug for ModifyLunaClientInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ModifyLunaClientInput");
        formatter.field("client_arn", &self.client_arn);
        formatter.field("certificate", &self.certificate);
        formatter.finish()
    }
}

/// <p>Contains the inputs for the <a>ModifyHsm</a> operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ModifyHsmInput {
    /// <p>The ARN of the HSM to modify.</p>
    pub hsm_arn: std::option::Option<std::string::String>,
    /// <p>The new identifier of the subnet that the HSM is in. The new subnet must be in the same
    /// Availability Zone as the current subnet.</p>
    pub subnet_id: std::option::Option<std::string::String>,
    /// <p>The new IP address for the elastic network interface (ENI) attached to the
    /// HSM.</p>
    /// <p>If the HSM is moved to a different subnet, and an IP address is not specified, an IP
    /// address will be randomly chosen from the CIDR range of the new subnet.</p>
    pub eni_ip: std::option::Option<std::string::String>,
    /// <p>The new IAM role ARN.</p>
    pub iam_role_arn: std::option::Option<std::string::String>,
    /// <p>The new external ID.</p>
    pub external_id: std::option::Option<std::string::String>,
    /// <p>The new IP address for the syslog monitoring server. The AWS CloudHSM service only supports
    /// one syslog monitoring server.</p>
    pub syslog_ip: std::option::Option<std::string::String>,
}
impl ModifyHsmInput {
    /// <p>The ARN of the HSM to modify.</p>
    pub fn hsm_arn(&self) -> std::option::Option<&str> {
        self.hsm_arn.as_deref()
    }
    /// <p>The new identifier of the subnet that the HSM is in. The new subnet must be in the same
    /// Availability Zone as the current subnet.</p>
    pub fn subnet_id(&self) -> std::option::Option<&str> {
        self.subnet_id.as_deref()
    }
    /// <p>The new IP address for the elastic network interface (ENI) attached to the
    /// HSM.</p>
    /// <p>If the HSM is moved to a different subnet, and an IP address is not specified, an IP
    /// address will be randomly chosen from the CIDR range of the new subnet.</p>
    pub fn eni_ip(&self) -> std::option::Option<&str> {
        self.eni_ip.as_deref()
    }
    /// <p>The new IAM role ARN.</p>
    pub fn iam_role_arn(&self) -> std::option::Option<&str> {
        self.iam_role_arn.as_deref()
    }
    /// <p>The new external ID.</p>
    pub fn external_id(&self) -> std::option::Option<&str> {
        self.external_id.as_deref()
    }
    /// <p>The new IP address for the syslog monitoring server. The AWS CloudHSM service only supports
    /// one syslog monitoring server.</p>
    pub fn syslog_ip(&self) -> std::option::Option<&str> {
        self.syslog_ip.as_deref()
    }
}
impl std::fmt::Debug for ModifyHsmInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ModifyHsmInput");
        formatter.field("hsm_arn", &self.hsm_arn);
        formatter.field("subnet_id", &self.subnet_id);
        formatter.field("eni_ip", &self.eni_ip);
        formatter.field("iam_role_arn", &self.iam_role_arn);
        formatter.field("external_id", &self.external_id);
        formatter.field("syslog_ip", &self.syslog_ip);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ModifyHapgInput {
    /// <p>The ARN of the high-availability partition group to modify.</p>
    pub hapg_arn: std::option::Option<std::string::String>,
    /// <p>The new label for the high-availability partition group.</p>
    pub label: std::option::Option<std::string::String>,
    /// <p>The list of partition serial numbers to make members of the high-availability partition
    /// group.</p>
    pub partition_serial_list: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl ModifyHapgInput {
    /// <p>The ARN of the high-availability partition group to modify.</p>
    pub fn hapg_arn(&self) -> std::option::Option<&str> {
        self.hapg_arn.as_deref()
    }
    /// <p>The new label for the high-availability partition group.</p>
    pub fn label(&self) -> std::option::Option<&str> {
        self.label.as_deref()
    }
    /// <p>The list of partition serial numbers to make members of the high-availability partition
    /// group.</p>
    pub fn partition_serial_list(&self) -> std::option::Option<&[std::string::String]> {
        self.partition_serial_list.as_deref()
    }
}
impl std::fmt::Debug for ModifyHapgInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ModifyHapgInput");
        formatter.field("hapg_arn", &self.hapg_arn);
        formatter.field("label", &self.label);
        formatter.field("partition_serial_list", &self.partition_serial_list);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTagsForResourceInput {
    /// <p>The Amazon Resource Name (ARN) of the AWS CloudHSM resource.</p>
    pub resource_arn: std::option::Option<std::string::String>,
}
impl ListTagsForResourceInput {
    /// <p>The Amazon Resource Name (ARN) of the AWS CloudHSM resource.</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
}
impl std::fmt::Debug for ListTagsForResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTagsForResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListLunaClientsInput {
    /// <p>The <code>NextToken</code> value from a previous call to <code>ListLunaClients</code>.
    /// Pass null if this is the first call.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListLunaClientsInput {
    /// <p>The <code>NextToken</code> value from a previous call to <code>ListLunaClients</code>.
    /// Pass null if this is the first call.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListLunaClientsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListLunaClientsInput");
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListHsmsInput {
    /// <p>The <code>NextToken</code> value from a previous call to <code>ListHsms</code>. Pass
    /// null if this is the first call.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListHsmsInput {
    /// <p>The <code>NextToken</code> value from a previous call to <code>ListHsms</code>. Pass
    /// null if this is the first call.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListHsmsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListHsmsInput");
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListHapgsInput {
    /// <p>The <code>NextToken</code> value from a previous call to <code>ListHapgs</code>. Pass
    /// null if this is the first call.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListHapgsInput {
    /// <p>The <code>NextToken</code> value from a previous call to <code>ListHapgs</code>. Pass
    /// null if this is the first call.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListHapgsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListHapgsInput");
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

/// <p>Contains the inputs for the <a>ListAvailableZones</a> action.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListAvailableZonesInput {}
impl std::fmt::Debug for ListAvailableZonesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListAvailableZonesInput");
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetConfigInput {
    /// <p>The ARN of the client.</p>
    pub client_arn: std::option::Option<std::string::String>,
    /// <p>The client version.</p>
    pub client_version: std::option::Option<crate::model::ClientVersion>,
    /// <p>A list of ARNs that identify the high-availability partition groups that are associated
    /// with the client.</p>
    pub hapg_list: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl GetConfigInput {
    /// <p>The ARN of the client.</p>
    pub fn client_arn(&self) -> std::option::Option<&str> {
        self.client_arn.as_deref()
    }
    /// <p>The client version.</p>
    pub fn client_version(&self) -> std::option::Option<&crate::model::ClientVersion> {
        self.client_version.as_ref()
    }
    /// <p>A list of ARNs that identify the high-availability partition groups that are associated
    /// with the client.</p>
    pub fn hapg_list(&self) -> std::option::Option<&[std::string::String]> {
        self.hapg_list.as_deref()
    }
}
impl std::fmt::Debug for GetConfigInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetConfigInput");
        formatter.field("client_arn", &self.client_arn);
        formatter.field("client_version", &self.client_version);
        formatter.field("hapg_list", &self.hapg_list);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeLunaClientInput {
    /// <p>The ARN of the client.</p>
    pub client_arn: std::option::Option<std::string::String>,
    /// <p>The certificate fingerprint.</p>
    pub certificate_fingerprint: std::option::Option<std::string::String>,
}
impl DescribeLunaClientInput {
    /// <p>The ARN of the client.</p>
    pub fn client_arn(&self) -> std::option::Option<&str> {
        self.client_arn.as_deref()
    }
    /// <p>The certificate fingerprint.</p>
    pub fn certificate_fingerprint(&self) -> std::option::Option<&str> {
        self.certificate_fingerprint.as_deref()
    }
}
impl std::fmt::Debug for DescribeLunaClientInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeLunaClientInput");
        formatter.field("client_arn", &self.client_arn);
        formatter.field("certificate_fingerprint", &self.certificate_fingerprint);
        formatter.finish()
    }
}

/// <p>Contains the inputs for the <a>DescribeHsm</a> operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeHsmInput {
    /// <p>The ARN of the HSM. Either the <code>HsmArn</code> or the <code>SerialNumber</code>
    /// parameter must be specified.</p>
    pub hsm_arn: std::option::Option<std::string::String>,
    /// <p>The serial number of the HSM. Either the <code>HsmArn</code> or the
    /// <code>HsmSerialNumber</code> parameter must be specified.</p>
    pub hsm_serial_number: std::option::Option<std::string::String>,
}
impl DescribeHsmInput {
    /// <p>The ARN of the HSM. Either the <code>HsmArn</code> or the <code>SerialNumber</code>
    /// parameter must be specified.</p>
    pub fn hsm_arn(&self) -> std::option::Option<&str> {
        self.hsm_arn.as_deref()
    }
    /// <p>The serial number of the HSM. Either the <code>HsmArn</code> or the
    /// <code>HsmSerialNumber</code> parameter must be specified.</p>
    pub fn hsm_serial_number(&self) -> std::option::Option<&str> {
        self.hsm_serial_number.as_deref()
    }
}
impl std::fmt::Debug for DescribeHsmInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeHsmInput");
        formatter.field("hsm_arn", &self.hsm_arn);
        formatter.field("hsm_serial_number", &self.hsm_serial_number);
        formatter.finish()
    }
}

/// <p>Contains the inputs for the <a>DescribeHapg</a> action.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeHapgInput {
    /// <p>The ARN of the high-availability partition group to describe.</p>
    pub hapg_arn: std::option::Option<std::string::String>,
}
impl DescribeHapgInput {
    /// <p>The ARN of the high-availability partition group to describe.</p>
    pub fn hapg_arn(&self) -> std::option::Option<&str> {
        self.hapg_arn.as_deref()
    }
}
impl std::fmt::Debug for DescribeHapgInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeHapgInput");
        formatter.field("hapg_arn", &self.hapg_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteLunaClientInput {
    /// <p>The ARN of the client to delete.</p>
    pub client_arn: std::option::Option<std::string::String>,
}
impl DeleteLunaClientInput {
    /// <p>The ARN of the client to delete.</p>
    pub fn client_arn(&self) -> std::option::Option<&str> {
        self.client_arn.as_deref()
    }
}
impl std::fmt::Debug for DeleteLunaClientInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteLunaClientInput");
        formatter.field("client_arn", &self.client_arn);
        formatter.finish()
    }
}

/// <p>Contains the inputs for the <a>DeleteHsm</a> operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteHsmInput {
    /// <p>The ARN of the HSM to delete.</p>
    pub hsm_arn: std::option::Option<std::string::String>,
}
impl DeleteHsmInput {
    /// <p>The ARN of the HSM to delete.</p>
    pub fn hsm_arn(&self) -> std::option::Option<&str> {
        self.hsm_arn.as_deref()
    }
}
impl std::fmt::Debug for DeleteHsmInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteHsmInput");
        formatter.field("hsm_arn", &self.hsm_arn);
        formatter.finish()
    }
}

/// <p>Contains the inputs for the <a>DeleteHapg</a> action.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteHapgInput {
    /// <p>The ARN of the high-availability partition group to delete.</p>
    pub hapg_arn: std::option::Option<std::string::String>,
}
impl DeleteHapgInput {
    /// <p>The ARN of the high-availability partition group to delete.</p>
    pub fn hapg_arn(&self) -> std::option::Option<&str> {
        self.hapg_arn.as_deref()
    }
}
impl std::fmt::Debug for DeleteHapgInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteHapgInput");
        formatter.field("hapg_arn", &self.hapg_arn);
        formatter.finish()
    }
}

/// <p>Contains the inputs for the <a>CreateLunaClient</a> action.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateLunaClientInput {
    /// <p>The label for the client.</p>
    pub label: std::option::Option<std::string::String>,
    /// <p>The contents of a Base64-Encoded X.509 v3 certificate to be installed on the HSMs used
    /// by this client.</p>
    pub certificate: std::option::Option<std::string::String>,
}
impl CreateLunaClientInput {
    /// <p>The label for the client.</p>
    pub fn label(&self) -> std::option::Option<&str> {
        self.label.as_deref()
    }
    /// <p>The contents of a Base64-Encoded X.509 v3 certificate to be installed on the HSMs used
    /// by this client.</p>
    pub fn certificate(&self) -> std::option::Option<&str> {
        self.certificate.as_deref()
    }
}
impl std::fmt::Debug for CreateLunaClientInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateLunaClientInput");
        formatter.field("label", &self.label);
        formatter.field("certificate", &self.certificate);
        formatter.finish()
    }
}

/// <p>Contains the inputs for the <code>CreateHsm</code> operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateHsmInput {
    /// <p>The identifier of the subnet in your VPC in which to place the HSM.</p>
    pub subnet_id: std::option::Option<std::string::String>,
    /// <p>The SSH public key to install on the HSM.</p>
    pub ssh_key: std::option::Option<std::string::String>,
    /// <p>The IP address to assign to the HSM's ENI.</p>
    /// <p>If an IP address is not specified, an IP address will be randomly chosen from the CIDR
    /// range of the subnet.</p>
    pub eni_ip: std::option::Option<std::string::String>,
    /// <p>The ARN of an IAM role to enable the AWS CloudHSM service to allocate an ENI on your
    /// behalf.</p>
    pub iam_role_arn: std::option::Option<std::string::String>,
    /// <p>The external ID from <code>IamRoleArn</code>, if present.</p>
    pub external_id: std::option::Option<std::string::String>,
    /// <p>Specifies the type of subscription for the HSM.</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <b>PRODUCTION</b> - The HSM is being used in a production
    /// environment.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>TRIAL</b> - The HSM is being used in a product
    /// trial.</p>
    /// </li>
    /// </ul>
    pub subscription_type: std::option::Option<crate::model::SubscriptionType>,
    /// <p>A user-defined token to ensure idempotence. Subsequent calls to this operation with the
    /// same token will be ignored.</p>
    pub client_token: std::option::Option<std::string::String>,
    /// <p>The IP address for the syslog monitoring server. The AWS CloudHSM service only supports one
    /// syslog monitoring server.</p>
    pub syslog_ip: std::option::Option<std::string::String>,
}
impl CreateHsmInput {
    /// <p>The identifier of the subnet in your VPC in which to place the HSM.</p>
    pub fn subnet_id(&self) -> std::option::Option<&str> {
        self.subnet_id.as_deref()
    }
    /// <p>The SSH public key to install on the HSM.</p>
    pub fn ssh_key(&self) -> std::option::Option<&str> {
        self.ssh_key.as_deref()
    }
    /// <p>The IP address to assign to the HSM's ENI.</p>
    /// <p>If an IP address is not specified, an IP address will be randomly chosen from the CIDR
    /// range of the subnet.</p>
    pub fn eni_ip(&self) -> std::option::Option<&str> {
        self.eni_ip.as_deref()
    }
    /// <p>The ARN of an IAM role to enable the AWS CloudHSM service to allocate an ENI on your
    /// behalf.</p>
    pub fn iam_role_arn(&self) -> std::option::Option<&str> {
        self.iam_role_arn.as_deref()
    }
    /// <p>The external ID from <code>IamRoleArn</code>, if present.</p>
    pub fn external_id(&self) -> std::option::Option<&str> {
        self.external_id.as_deref()
    }
    /// <p>Specifies the type of subscription for the HSM.</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <b>PRODUCTION</b> - The HSM is being used in a production
    /// environment.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>TRIAL</b> - The HSM is being used in a product
    /// trial.</p>
    /// </li>
    /// </ul>
    pub fn subscription_type(&self) -> std::option::Option<&crate::model::SubscriptionType> {
        self.subscription_type.as_ref()
    }
    /// <p>A user-defined token to ensure idempotence. Subsequent calls to this operation with the
    /// same token will be ignored.</p>
    pub fn client_token(&self) -> std::option::Option<&str> {
        self.client_token.as_deref()
    }
    /// <p>The IP address for the syslog monitoring server. The AWS CloudHSM service only supports one
    /// syslog monitoring server.</p>
    pub fn syslog_ip(&self) -> std::option::Option<&str> {
        self.syslog_ip.as_deref()
    }
}
impl std::fmt::Debug for CreateHsmInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateHsmInput");
        formatter.field("subnet_id", &self.subnet_id);
        formatter.field("ssh_key", &self.ssh_key);
        formatter.field("eni_ip", &self.eni_ip);
        formatter.field("iam_role_arn", &self.iam_role_arn);
        formatter.field("external_id", &self.external_id);
        formatter.field("subscription_type", &self.subscription_type);
        formatter.field("client_token", &self.client_token);
        formatter.field("syslog_ip", &self.syslog_ip);
        formatter.finish()
    }
}

/// <p>Contains the inputs for the <a>CreateHapgRequest</a> action.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateHapgInput {
    /// <p>The label of the new high-availability partition group.</p>
    pub label: std::option::Option<std::string::String>,
}
impl CreateHapgInput {
    /// <p>The label of the new high-availability partition group.</p>
    pub fn label(&self) -> std::option::Option<&str> {
        self.label.as_deref()
    }
}
impl std::fmt::Debug for CreateHapgInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateHapgInput");
        formatter.field("label", &self.label);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AddTagsToResourceInput {
    /// <p>The Amazon Resource Name (ARN) of the AWS CloudHSM resource to tag.</p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>One or more tags.</p>
    pub tag_list: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl AddTagsToResourceInput {
    /// <p>The Amazon Resource Name (ARN) of the AWS CloudHSM resource to tag.</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
    /// <p>One or more tags.</p>
    pub fn tag_list(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tag_list.as_deref()
    }
}
impl std::fmt::Debug for AddTagsToResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AddTagsToResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("tag_list", &self.tag_list);
        formatter.finish()
    }
}
