// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle {
    pub(crate) client: aws_smithy_client::Client<
        aws_smithy_client::erase::DynConnector,
        aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
    >,
    pub(crate) conf: crate::Config,
}

/// Client for Amazon CloudFront
///
/// Client for invoking operations on Amazon CloudFront. Each operation on Amazon CloudFront is a method on this
/// this struct. `.send()` MUST be invoked on the generated operations to dispatch the request to the service.
///
/// # Examples
/// **Constructing a client and invoking an operation**
/// ```rust,no_run
/// # async fn docs() {
///     // create a shared configuration. This can be used & shared between multiple service clients.
///     let shared_config = aws_config::load_from_env().await;
///     let client = aws_sdk_cloudfront::Client::new(&shared_config);
///     // invoke an operation
///     /* let rsp = client
///         .<operation_name>().
///         .<param>("some value")
///         .send().await; */
/// # }
/// ```
/// **Constructing a client with custom configuration**
/// ```rust,no_run
/// use aws_config::RetryConfig;
/// # async fn docs() {
///     let shared_config = aws_config::load_from_env().await;
///     let config = aws_sdk_cloudfront::config::Builder::from(&shared_config)
///         .retry_config(RetryConfig::disabled())
///         .build();
///     let client = aws_sdk_cloudfront::Client::from_conf(config);
/// # }
#[derive(std::fmt::Debug)]
pub struct Client {
    handle: std::sync::Arc<Handle>,
}

impl std::clone::Clone for Client {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl
    From<
        aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
    > for Client
{
    fn from(
        client: aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
    ) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl Client {
    /// Creates a client with the given service configuration.
    pub fn with_config(
        client: aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
        conf: crate::Config,
    ) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl Client {
    /// Constructs a fluent builder for the [`AssociateAlias`](crate::client::fluent_builders::AssociateAlias) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`target_distribution_id(impl Into<String>)`](crate::client::fluent_builders::AssociateAlias::target_distribution_id) / [`set_target_distribution_id(Option<String>)`](crate::client::fluent_builders::AssociateAlias::set_target_distribution_id): <p>The ID of the distribution that you’re associating the alias with.</p>
    ///   - [`alias(impl Into<String>)`](crate::client::fluent_builders::AssociateAlias::alias) / [`set_alias(Option<String>)`](crate::client::fluent_builders::AssociateAlias::set_alias): <p>The alias (also known as a CNAME) to add to the target distribution.</p>
    /// - On success, responds with [`AssociateAliasOutput`](crate::output::AssociateAliasOutput)

    /// - On failure, responds with [`SdkError<AssociateAliasError>`](crate::error::AssociateAliasError)
    pub fn associate_alias(&self) -> fluent_builders::AssociateAlias {
        fluent_builders::AssociateAlias::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateCachePolicy`](crate::client::fluent_builders::CreateCachePolicy) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`cache_policy_config(CachePolicyConfig)`](crate::client::fluent_builders::CreateCachePolicy::cache_policy_config) / [`set_cache_policy_config(Option<CachePolicyConfig>)`](crate::client::fluent_builders::CreateCachePolicy::set_cache_policy_config): <p>A cache policy configuration.</p>
    /// - On success, responds with [`CreateCachePolicyOutput`](crate::output::CreateCachePolicyOutput) with field(s):
    ///   - [`cache_policy(Option<CachePolicy>)`](crate::output::CreateCachePolicyOutput::cache_policy): <p>A cache policy.</p>
    ///   - [`location(Option<String>)`](crate::output::CreateCachePolicyOutput::location): <p>The fully qualified URI of the cache policy just created.</p>
    ///   - [`e_tag(Option<String>)`](crate::output::CreateCachePolicyOutput::e_tag): <p>The current version of the cache policy.</p>
    /// - On failure, responds with [`SdkError<CreateCachePolicyError>`](crate::error::CreateCachePolicyError)
    pub fn create_cache_policy(&self) -> fluent_builders::CreateCachePolicy {
        fluent_builders::CreateCachePolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateCloudFrontOriginAccessIdentity`](crate::client::fluent_builders::CreateCloudFrontOriginAccessIdentity) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`cloud_front_origin_access_identity_config(CloudFrontOriginAccessIdentityConfig)`](crate::client::fluent_builders::CreateCloudFrontOriginAccessIdentity::cloud_front_origin_access_identity_config) / [`set_cloud_front_origin_access_identity_config(Option<CloudFrontOriginAccessIdentityConfig>)`](crate::client::fluent_builders::CreateCloudFrontOriginAccessIdentity::set_cloud_front_origin_access_identity_config): <p>The current configuration information for the identity.</p>
    /// - On success, responds with [`CreateCloudFrontOriginAccessIdentityOutput`](crate::output::CreateCloudFrontOriginAccessIdentityOutput) with field(s):
    ///   - [`cloud_front_origin_access_identity(Option<CloudFrontOriginAccessIdentity>)`](crate::output::CreateCloudFrontOriginAccessIdentityOutput::cloud_front_origin_access_identity): <p>The origin access identity's information.</p>
    ///   - [`location(Option<String>)`](crate::output::CreateCloudFrontOriginAccessIdentityOutput::location): <p>The fully qualified URI of the new origin access identity just created.</p>
    ///   - [`e_tag(Option<String>)`](crate::output::CreateCloudFrontOriginAccessIdentityOutput::e_tag): <p>The current version of the origin access identity created.</p>
    /// - On failure, responds with [`SdkError<CreateCloudFrontOriginAccessIdentityError>`](crate::error::CreateCloudFrontOriginAccessIdentityError)
    pub fn create_cloud_front_origin_access_identity(
        &self,
    ) -> fluent_builders::CreateCloudFrontOriginAccessIdentity {
        fluent_builders::CreateCloudFrontOriginAccessIdentity::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateDistribution`](crate::client::fluent_builders::CreateDistribution) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`distribution_config(DistributionConfig)`](crate::client::fluent_builders::CreateDistribution::distribution_config) / [`set_distribution_config(Option<DistributionConfig>)`](crate::client::fluent_builders::CreateDistribution::set_distribution_config): <p>The distribution's configuration information.</p>
    /// - On success, responds with [`CreateDistributionOutput`](crate::output::CreateDistributionOutput) with field(s):
    ///   - [`distribution(Option<Distribution>)`](crate::output::CreateDistributionOutput::distribution): <p>The distribution's information.</p>
    ///   - [`location(Option<String>)`](crate::output::CreateDistributionOutput::location): <p>The fully qualified URI of the new distribution resource just created.</p>
    ///   - [`e_tag(Option<String>)`](crate::output::CreateDistributionOutput::e_tag): <p>The current version of the distribution created.</p>
    /// - On failure, responds with [`SdkError<CreateDistributionError>`](crate::error::CreateDistributionError)
    pub fn create_distribution(&self) -> fluent_builders::CreateDistribution {
        fluent_builders::CreateDistribution::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateDistributionWithTags`](crate::client::fluent_builders::CreateDistributionWithTags) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`distribution_config_with_tags(DistributionConfigWithTags)`](crate::client::fluent_builders::CreateDistributionWithTags::distribution_config_with_tags) / [`set_distribution_config_with_tags(Option<DistributionConfigWithTags>)`](crate::client::fluent_builders::CreateDistributionWithTags::set_distribution_config_with_tags): <p>The distribution's configuration information. </p>
    /// - On success, responds with [`CreateDistributionWithTagsOutput`](crate::output::CreateDistributionWithTagsOutput) with field(s):
    ///   - [`distribution(Option<Distribution>)`](crate::output::CreateDistributionWithTagsOutput::distribution): <p>The distribution's information. </p>
    ///   - [`location(Option<String>)`](crate::output::CreateDistributionWithTagsOutput::location): <p>The fully qualified URI of the new distribution resource just created.</p>
    ///   - [`e_tag(Option<String>)`](crate::output::CreateDistributionWithTagsOutput::e_tag): <p>The current version of the distribution created.</p>
    /// - On failure, responds with [`SdkError<CreateDistributionWithTagsError>`](crate::error::CreateDistributionWithTagsError)
    pub fn create_distribution_with_tags(&self) -> fluent_builders::CreateDistributionWithTags {
        fluent_builders::CreateDistributionWithTags::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateFieldLevelEncryptionConfig`](crate::client::fluent_builders::CreateFieldLevelEncryptionConfig) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`field_level_encryption_config(FieldLevelEncryptionConfig)`](crate::client::fluent_builders::CreateFieldLevelEncryptionConfig::field_level_encryption_config) / [`set_field_level_encryption_config(Option<FieldLevelEncryptionConfig>)`](crate::client::fluent_builders::CreateFieldLevelEncryptionConfig::set_field_level_encryption_config): <p>The request to create a new field-level encryption configuration.</p>
    /// - On success, responds with [`CreateFieldLevelEncryptionConfigOutput`](crate::output::CreateFieldLevelEncryptionConfigOutput) with field(s):
    ///   - [`field_level_encryption(Option<FieldLevelEncryption>)`](crate::output::CreateFieldLevelEncryptionConfigOutput::field_level_encryption): <p>Returned when you create a new field-level encryption configuration.</p>
    ///   - [`location(Option<String>)`](crate::output::CreateFieldLevelEncryptionConfigOutput::location): <p>The fully qualified URI of the new configuration resource just created.</p>
    ///   - [`e_tag(Option<String>)`](crate::output::CreateFieldLevelEncryptionConfigOutput::e_tag): <p>The current version of the field level encryption configuration. For example: <code>E2QWRUHAPOMQZL</code>.</p>
    /// - On failure, responds with [`SdkError<CreateFieldLevelEncryptionConfigError>`](crate::error::CreateFieldLevelEncryptionConfigError)
    pub fn create_field_level_encryption_config(
        &self,
    ) -> fluent_builders::CreateFieldLevelEncryptionConfig {
        fluent_builders::CreateFieldLevelEncryptionConfig::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateFieldLevelEncryptionProfile`](crate::client::fluent_builders::CreateFieldLevelEncryptionProfile) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`field_level_encryption_profile_config(FieldLevelEncryptionProfileConfig)`](crate::client::fluent_builders::CreateFieldLevelEncryptionProfile::field_level_encryption_profile_config) / [`set_field_level_encryption_profile_config(Option<FieldLevelEncryptionProfileConfig>)`](crate::client::fluent_builders::CreateFieldLevelEncryptionProfile::set_field_level_encryption_profile_config): <p>The request to create a field-level encryption profile.</p>
    /// - On success, responds with [`CreateFieldLevelEncryptionProfileOutput`](crate::output::CreateFieldLevelEncryptionProfileOutput) with field(s):
    ///   - [`field_level_encryption_profile(Option<FieldLevelEncryptionProfile>)`](crate::output::CreateFieldLevelEncryptionProfileOutput::field_level_encryption_profile): <p>Returned when you create a new field-level encryption profile.</p>
    ///   - [`location(Option<String>)`](crate::output::CreateFieldLevelEncryptionProfileOutput::location): <p>The fully qualified URI of the new profile resource just created.</p>
    ///   - [`e_tag(Option<String>)`](crate::output::CreateFieldLevelEncryptionProfileOutput::e_tag): <p>The current version of the field level encryption profile. For example: <code>E2QWRUHAPOMQZL</code>.</p>
    /// - On failure, responds with [`SdkError<CreateFieldLevelEncryptionProfileError>`](crate::error::CreateFieldLevelEncryptionProfileError)
    pub fn create_field_level_encryption_profile(
        &self,
    ) -> fluent_builders::CreateFieldLevelEncryptionProfile {
        fluent_builders::CreateFieldLevelEncryptionProfile::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateFunction`](crate::client::fluent_builders::CreateFunction) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::CreateFunction::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::CreateFunction::set_name): <p>A name to identify the function.</p>
    ///   - [`function_config(FunctionConfig)`](crate::client::fluent_builders::CreateFunction::function_config) / [`set_function_config(Option<FunctionConfig>)`](crate::client::fluent_builders::CreateFunction::set_function_config): <p>Configuration information about the function, including an optional comment and the function’s runtime.</p>
    ///   - [`function_code(Blob)`](crate::client::fluent_builders::CreateFunction::function_code) / [`set_function_code(Option<Blob>)`](crate::client::fluent_builders::CreateFunction::set_function_code): <p>The function code. For more information about writing a CloudFront function, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/writing-function-code.html">Writing function code for CloudFront Functions</a> in the <i>Amazon CloudFront Developer Guide</i>.</p>
    /// - On success, responds with [`CreateFunctionOutput`](crate::output::CreateFunctionOutput) with field(s):
    ///   - [`function_summary(Option<FunctionSummary>)`](crate::output::CreateFunctionOutput::function_summary): <p>Contains configuration information and metadata about a CloudFront function.</p>
    ///   - [`location(Option<String>)`](crate::output::CreateFunctionOutput::location): <p>The URL of the CloudFront function. Use the URL to manage the function with the CloudFront API.</p>
    ///   - [`e_tag(Option<String>)`](crate::output::CreateFunctionOutput::e_tag): <p>The version identifier for the current version of the CloudFront function.</p>
    /// - On failure, responds with [`SdkError<CreateFunctionError>`](crate::error::CreateFunctionError)
    pub fn create_function(&self) -> fluent_builders::CreateFunction {
        fluent_builders::CreateFunction::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateInvalidation`](crate::client::fluent_builders::CreateInvalidation) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`distribution_id(impl Into<String>)`](crate::client::fluent_builders::CreateInvalidation::distribution_id) / [`set_distribution_id(Option<String>)`](crate::client::fluent_builders::CreateInvalidation::set_distribution_id): <p>The distribution's id.</p>
    ///   - [`invalidation_batch(InvalidationBatch)`](crate::client::fluent_builders::CreateInvalidation::invalidation_batch) / [`set_invalidation_batch(Option<InvalidationBatch>)`](crate::client::fluent_builders::CreateInvalidation::set_invalidation_batch): <p>The batch information for the invalidation.</p>
    /// - On success, responds with [`CreateInvalidationOutput`](crate::output::CreateInvalidationOutput) with field(s):
    ///   - [`location(Option<String>)`](crate::output::CreateInvalidationOutput::location): <p>The fully qualified URI of the distribution and invalidation batch request, including the <code>Invalidation ID</code>.</p>
    ///   - [`invalidation(Option<Invalidation>)`](crate::output::CreateInvalidationOutput::invalidation): <p>The invalidation's information.</p>
    /// - On failure, responds with [`SdkError<CreateInvalidationError>`](crate::error::CreateInvalidationError)
    pub fn create_invalidation(&self) -> fluent_builders::CreateInvalidation {
        fluent_builders::CreateInvalidation::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateKeyGroup`](crate::client::fluent_builders::CreateKeyGroup) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`key_group_config(KeyGroupConfig)`](crate::client::fluent_builders::CreateKeyGroup::key_group_config) / [`set_key_group_config(Option<KeyGroupConfig>)`](crate::client::fluent_builders::CreateKeyGroup::set_key_group_config): <p>A key group configuration.</p>
    /// - On success, responds with [`CreateKeyGroupOutput`](crate::output::CreateKeyGroupOutput) with field(s):
    ///   - [`key_group(Option<KeyGroup>)`](crate::output::CreateKeyGroupOutput::key_group): <p>The key group that was just created.</p>
    ///   - [`location(Option<String>)`](crate::output::CreateKeyGroupOutput::location): <p>The URL of the key group.</p>
    ///   - [`e_tag(Option<String>)`](crate::output::CreateKeyGroupOutput::e_tag): <p>The identifier for this version of the key group.</p>
    /// - On failure, responds with [`SdkError<CreateKeyGroupError>`](crate::error::CreateKeyGroupError)
    pub fn create_key_group(&self) -> fluent_builders::CreateKeyGroup {
        fluent_builders::CreateKeyGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateMonitoringSubscription`](crate::client::fluent_builders::CreateMonitoringSubscription) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`distribution_id(impl Into<String>)`](crate::client::fluent_builders::CreateMonitoringSubscription::distribution_id) / [`set_distribution_id(Option<String>)`](crate::client::fluent_builders::CreateMonitoringSubscription::set_distribution_id): <p>The ID of the distribution that you are enabling metrics for.</p>
    ///   - [`monitoring_subscription(MonitoringSubscription)`](crate::client::fluent_builders::CreateMonitoringSubscription::monitoring_subscription) / [`set_monitoring_subscription(Option<MonitoringSubscription>)`](crate::client::fluent_builders::CreateMonitoringSubscription::set_monitoring_subscription): <p>A monitoring subscription. This structure contains information about whether additional CloudWatch metrics are enabled for a given CloudFront distribution.</p>
    /// - On success, responds with [`CreateMonitoringSubscriptionOutput`](crate::output::CreateMonitoringSubscriptionOutput) with field(s):
    ///   - [`monitoring_subscription(Option<MonitoringSubscription>)`](crate::output::CreateMonitoringSubscriptionOutput::monitoring_subscription): <p>A monitoring subscription. This structure contains information about whether additional CloudWatch metrics are enabled for a given CloudFront distribution.</p>
    /// - On failure, responds with [`SdkError<CreateMonitoringSubscriptionError>`](crate::error::CreateMonitoringSubscriptionError)
    pub fn create_monitoring_subscription(&self) -> fluent_builders::CreateMonitoringSubscription {
        fluent_builders::CreateMonitoringSubscription::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateOriginRequestPolicy`](crate::client::fluent_builders::CreateOriginRequestPolicy) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`origin_request_policy_config(OriginRequestPolicyConfig)`](crate::client::fluent_builders::CreateOriginRequestPolicy::origin_request_policy_config) / [`set_origin_request_policy_config(Option<OriginRequestPolicyConfig>)`](crate::client::fluent_builders::CreateOriginRequestPolicy::set_origin_request_policy_config): <p>An origin request policy configuration.</p>
    /// - On success, responds with [`CreateOriginRequestPolicyOutput`](crate::output::CreateOriginRequestPolicyOutput) with field(s):
    ///   - [`origin_request_policy(Option<OriginRequestPolicy>)`](crate::output::CreateOriginRequestPolicyOutput::origin_request_policy): <p>An origin request policy.</p>
    ///   - [`location(Option<String>)`](crate::output::CreateOriginRequestPolicyOutput::location): <p>The fully qualified URI of the origin request policy just created.</p>
    ///   - [`e_tag(Option<String>)`](crate::output::CreateOriginRequestPolicyOutput::e_tag): <p>The current version of the origin request policy.</p>
    /// - On failure, responds with [`SdkError<CreateOriginRequestPolicyError>`](crate::error::CreateOriginRequestPolicyError)
    pub fn create_origin_request_policy(&self) -> fluent_builders::CreateOriginRequestPolicy {
        fluent_builders::CreateOriginRequestPolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreatePublicKey`](crate::client::fluent_builders::CreatePublicKey) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`public_key_config(PublicKeyConfig)`](crate::client::fluent_builders::CreatePublicKey::public_key_config) / [`set_public_key_config(Option<PublicKeyConfig>)`](crate::client::fluent_builders::CreatePublicKey::set_public_key_config): <p>A CloudFront public key configuration.</p>
    /// - On success, responds with [`CreatePublicKeyOutput`](crate::output::CreatePublicKeyOutput) with field(s):
    ///   - [`public_key(Option<PublicKey>)`](crate::output::CreatePublicKeyOutput::public_key): <p>The public key.</p>
    ///   - [`location(Option<String>)`](crate::output::CreatePublicKeyOutput::location): <p>The URL of the public key.</p>
    ///   - [`e_tag(Option<String>)`](crate::output::CreatePublicKeyOutput::e_tag): <p>The identifier for this version of the public key.</p>
    /// - On failure, responds with [`SdkError<CreatePublicKeyError>`](crate::error::CreatePublicKeyError)
    pub fn create_public_key(&self) -> fluent_builders::CreatePublicKey {
        fluent_builders::CreatePublicKey::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateRealtimeLogConfig`](crate::client::fluent_builders::CreateRealtimeLogConfig) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`end_points(Vec<EndPoint>)`](crate::client::fluent_builders::CreateRealtimeLogConfig::end_points) / [`set_end_points(Option<Vec<EndPoint>>)`](crate::client::fluent_builders::CreateRealtimeLogConfig::set_end_points): <p>Contains information about the Amazon Kinesis data stream where you are sending real-time log data.</p>
    ///   - [`fields(Vec<String>)`](crate::client::fluent_builders::CreateRealtimeLogConfig::fields) / [`set_fields(Option<Vec<String>>)`](crate::client::fluent_builders::CreateRealtimeLogConfig::set_fields): <p>A list of fields to include in each real-time log record.</p>  <p>For more information about fields, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/real-time-logs.html#understand-real-time-log-config-fields">Real-time log configuration fields</a> in the <i>Amazon CloudFront Developer Guide</i>.</p>
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::CreateRealtimeLogConfig::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::CreateRealtimeLogConfig::set_name): <p>A unique name to identify this real-time log configuration.</p>
    ///   - [`sampling_rate(i64)`](crate::client::fluent_builders::CreateRealtimeLogConfig::sampling_rate) / [`set_sampling_rate(Option<i64>)`](crate::client::fluent_builders::CreateRealtimeLogConfig::set_sampling_rate): <p>The sampling rate for this real-time log configuration. The sampling rate determines the percentage of viewer requests that are represented in the real-time log data. You must provide an integer between 1 and 100, inclusive.</p>
    /// - On success, responds with [`CreateRealtimeLogConfigOutput`](crate::output::CreateRealtimeLogConfigOutput) with field(s):
    ///   - [`realtime_log_config(Option<RealtimeLogConfig>)`](crate::output::CreateRealtimeLogConfigOutput::realtime_log_config): <p>A real-time log configuration.</p>
    /// - On failure, responds with [`SdkError<CreateRealtimeLogConfigError>`](crate::error::CreateRealtimeLogConfigError)
    pub fn create_realtime_log_config(&self) -> fluent_builders::CreateRealtimeLogConfig {
        fluent_builders::CreateRealtimeLogConfig::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateResponseHeadersPolicy`](crate::client::fluent_builders::CreateResponseHeadersPolicy) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`response_headers_policy_config(ResponseHeadersPolicyConfig)`](crate::client::fluent_builders::CreateResponseHeadersPolicy::response_headers_policy_config) / [`set_response_headers_policy_config(Option<ResponseHeadersPolicyConfig>)`](crate::client::fluent_builders::CreateResponseHeadersPolicy::set_response_headers_policy_config): <p>Contains metadata about the response headers policy, and a set of configurations that specify the response headers.</p>
    /// - On success, responds with [`CreateResponseHeadersPolicyOutput`](crate::output::CreateResponseHeadersPolicyOutput) with field(s):
    ///   - [`response_headers_policy(Option<ResponseHeadersPolicy>)`](crate::output::CreateResponseHeadersPolicyOutput::response_headers_policy): <p>Contains a response headers policy.</p>
    ///   - [`location(Option<String>)`](crate::output::CreateResponseHeadersPolicyOutput::location): <p>The URL of the response headers policy.</p>
    ///   - [`e_tag(Option<String>)`](crate::output::CreateResponseHeadersPolicyOutput::e_tag): <p>The version identifier for the current version of the response headers policy.</p>
    /// - On failure, responds with [`SdkError<CreateResponseHeadersPolicyError>`](crate::error::CreateResponseHeadersPolicyError)
    pub fn create_response_headers_policy(&self) -> fluent_builders::CreateResponseHeadersPolicy {
        fluent_builders::CreateResponseHeadersPolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateStreamingDistribution`](crate::client::fluent_builders::CreateStreamingDistribution) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`streaming_distribution_config(StreamingDistributionConfig)`](crate::client::fluent_builders::CreateStreamingDistribution::streaming_distribution_config) / [`set_streaming_distribution_config(Option<StreamingDistributionConfig>)`](crate::client::fluent_builders::CreateStreamingDistribution::set_streaming_distribution_config): <p>The streaming distribution's configuration information.</p>
    /// - On success, responds with [`CreateStreamingDistributionOutput`](crate::output::CreateStreamingDistributionOutput) with field(s):
    ///   - [`streaming_distribution(Option<StreamingDistribution>)`](crate::output::CreateStreamingDistributionOutput::streaming_distribution): <p>The streaming distribution's information.</p>
    ///   - [`location(Option<String>)`](crate::output::CreateStreamingDistributionOutput::location): <p>The fully qualified URI of the new streaming distribution resource just created.</p>
    ///   - [`e_tag(Option<String>)`](crate::output::CreateStreamingDistributionOutput::e_tag): <p>The current version of the streaming distribution created.</p>
    /// - On failure, responds with [`SdkError<CreateStreamingDistributionError>`](crate::error::CreateStreamingDistributionError)
    pub fn create_streaming_distribution(&self) -> fluent_builders::CreateStreamingDistribution {
        fluent_builders::CreateStreamingDistribution::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateStreamingDistributionWithTags`](crate::client::fluent_builders::CreateStreamingDistributionWithTags) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`streaming_distribution_config_with_tags(StreamingDistributionConfigWithTags)`](crate::client::fluent_builders::CreateStreamingDistributionWithTags::streaming_distribution_config_with_tags) / [`set_streaming_distribution_config_with_tags(Option<StreamingDistributionConfigWithTags>)`](crate::client::fluent_builders::CreateStreamingDistributionWithTags::set_streaming_distribution_config_with_tags): <p> The streaming distribution's configuration information. </p>
    /// - On success, responds with [`CreateStreamingDistributionWithTagsOutput`](crate::output::CreateStreamingDistributionWithTagsOutput) with field(s):
    ///   - [`streaming_distribution(Option<StreamingDistribution>)`](crate::output::CreateStreamingDistributionWithTagsOutput::streaming_distribution): <p>The streaming distribution's information. </p>
    ///   - [`location(Option<String>)`](crate::output::CreateStreamingDistributionWithTagsOutput::location): <p>The fully qualified URI of the new streaming distribution resource just created.</p>
    ///   - [`e_tag(Option<String>)`](crate::output::CreateStreamingDistributionWithTagsOutput::e_tag): <p>The current version of the distribution created.</p>
    /// - On failure, responds with [`SdkError<CreateStreamingDistributionWithTagsError>`](crate::error::CreateStreamingDistributionWithTagsError)
    pub fn create_streaming_distribution_with_tags(
        &self,
    ) -> fluent_builders::CreateStreamingDistributionWithTags {
        fluent_builders::CreateStreamingDistributionWithTags::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteCachePolicy`](crate::client::fluent_builders::DeleteCachePolicy) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`id(impl Into<String>)`](crate::client::fluent_builders::DeleteCachePolicy::id) / [`set_id(Option<String>)`](crate::client::fluent_builders::DeleteCachePolicy::set_id): <p>The unique identifier for the cache policy that you are deleting. To get the identifier, you can use <code>ListCachePolicies</code>.</p>
    ///   - [`if_match(impl Into<String>)`](crate::client::fluent_builders::DeleteCachePolicy::if_match) / [`set_if_match(Option<String>)`](crate::client::fluent_builders::DeleteCachePolicy::set_if_match): <p>The version of the cache policy that you are deleting. The version is the cache policy’s <code>ETag</code> value, which you can get using <code>ListCachePolicies</code>, <code>GetCachePolicy</code>, or <code>GetCachePolicyConfig</code>.</p>
    /// - On success, responds with [`DeleteCachePolicyOutput`](crate::output::DeleteCachePolicyOutput)

    /// - On failure, responds with [`SdkError<DeleteCachePolicyError>`](crate::error::DeleteCachePolicyError)
    pub fn delete_cache_policy(&self) -> fluent_builders::DeleteCachePolicy {
        fluent_builders::DeleteCachePolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteCloudFrontOriginAccessIdentity`](crate::client::fluent_builders::DeleteCloudFrontOriginAccessIdentity) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`id(impl Into<String>)`](crate::client::fluent_builders::DeleteCloudFrontOriginAccessIdentity::id) / [`set_id(Option<String>)`](crate::client::fluent_builders::DeleteCloudFrontOriginAccessIdentity::set_id): <p>The origin access identity's ID.</p>
    ///   - [`if_match(impl Into<String>)`](crate::client::fluent_builders::DeleteCloudFrontOriginAccessIdentity::if_match) / [`set_if_match(Option<String>)`](crate::client::fluent_builders::DeleteCloudFrontOriginAccessIdentity::set_if_match): <p>The value of the <code>ETag</code> header you received from a previous <code>GET</code> or <code>PUT</code> request. For example: <code>E2QWRUHAPOMQZL</code>.</p>
    /// - On success, responds with [`DeleteCloudFrontOriginAccessIdentityOutput`](crate::output::DeleteCloudFrontOriginAccessIdentityOutput)

    /// - On failure, responds with [`SdkError<DeleteCloudFrontOriginAccessIdentityError>`](crate::error::DeleteCloudFrontOriginAccessIdentityError)
    pub fn delete_cloud_front_origin_access_identity(
        &self,
    ) -> fluent_builders::DeleteCloudFrontOriginAccessIdentity {
        fluent_builders::DeleteCloudFrontOriginAccessIdentity::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteDistribution`](crate::client::fluent_builders::DeleteDistribution) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`id(impl Into<String>)`](crate::client::fluent_builders::DeleteDistribution::id) / [`set_id(Option<String>)`](crate::client::fluent_builders::DeleteDistribution::set_id): <p>The distribution ID. </p>
    ///   - [`if_match(impl Into<String>)`](crate::client::fluent_builders::DeleteDistribution::if_match) / [`set_if_match(Option<String>)`](crate::client::fluent_builders::DeleteDistribution::set_if_match): <p>The value of the <code>ETag</code> header that you received when you disabled the distribution. For example: <code>E2QWRUHAPOMQZL</code>. </p>
    /// - On success, responds with [`DeleteDistributionOutput`](crate::output::DeleteDistributionOutput)

    /// - On failure, responds with [`SdkError<DeleteDistributionError>`](crate::error::DeleteDistributionError)
    pub fn delete_distribution(&self) -> fluent_builders::DeleteDistribution {
        fluent_builders::DeleteDistribution::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteFieldLevelEncryptionConfig`](crate::client::fluent_builders::DeleteFieldLevelEncryptionConfig) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`id(impl Into<String>)`](crate::client::fluent_builders::DeleteFieldLevelEncryptionConfig::id) / [`set_id(Option<String>)`](crate::client::fluent_builders::DeleteFieldLevelEncryptionConfig::set_id): <p>The ID of the configuration you want to delete from CloudFront.</p>
    ///   - [`if_match(impl Into<String>)`](crate::client::fluent_builders::DeleteFieldLevelEncryptionConfig::if_match) / [`set_if_match(Option<String>)`](crate::client::fluent_builders::DeleteFieldLevelEncryptionConfig::set_if_match): <p>The value of the <code>ETag</code> header that you received when retrieving the configuration identity to delete. For example: <code>E2QWRUHAPOMQZL</code>.</p>
    /// - On success, responds with [`DeleteFieldLevelEncryptionConfigOutput`](crate::output::DeleteFieldLevelEncryptionConfigOutput)

    /// - On failure, responds with [`SdkError<DeleteFieldLevelEncryptionConfigError>`](crate::error::DeleteFieldLevelEncryptionConfigError)
    pub fn delete_field_level_encryption_config(
        &self,
    ) -> fluent_builders::DeleteFieldLevelEncryptionConfig {
        fluent_builders::DeleteFieldLevelEncryptionConfig::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteFieldLevelEncryptionProfile`](crate::client::fluent_builders::DeleteFieldLevelEncryptionProfile) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`id(impl Into<String>)`](crate::client::fluent_builders::DeleteFieldLevelEncryptionProfile::id) / [`set_id(Option<String>)`](crate::client::fluent_builders::DeleteFieldLevelEncryptionProfile::set_id): <p>Request the ID of the profile you want to delete from CloudFront.</p>
    ///   - [`if_match(impl Into<String>)`](crate::client::fluent_builders::DeleteFieldLevelEncryptionProfile::if_match) / [`set_if_match(Option<String>)`](crate::client::fluent_builders::DeleteFieldLevelEncryptionProfile::set_if_match): <p>The value of the <code>ETag</code> header that you received when retrieving the profile to delete. For example: <code>E2QWRUHAPOMQZL</code>.</p>
    /// - On success, responds with [`DeleteFieldLevelEncryptionProfileOutput`](crate::output::DeleteFieldLevelEncryptionProfileOutput)

    /// - On failure, responds with [`SdkError<DeleteFieldLevelEncryptionProfileError>`](crate::error::DeleteFieldLevelEncryptionProfileError)
    pub fn delete_field_level_encryption_profile(
        &self,
    ) -> fluent_builders::DeleteFieldLevelEncryptionProfile {
        fluent_builders::DeleteFieldLevelEncryptionProfile::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteFunction`](crate::client::fluent_builders::DeleteFunction) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::DeleteFunction::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::DeleteFunction::set_name): <p>The name of the function that you are deleting.</p>
    ///   - [`if_match(impl Into<String>)`](crate::client::fluent_builders::DeleteFunction::if_match) / [`set_if_match(Option<String>)`](crate::client::fluent_builders::DeleteFunction::set_if_match): <p>The current version (<code>ETag</code> value) of the function that you are deleting, which you can get using <code>DescribeFunction</code>.</p>
    /// - On success, responds with [`DeleteFunctionOutput`](crate::output::DeleteFunctionOutput)

    /// - On failure, responds with [`SdkError<DeleteFunctionError>`](crate::error::DeleteFunctionError)
    pub fn delete_function(&self) -> fluent_builders::DeleteFunction {
        fluent_builders::DeleteFunction::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteKeyGroup`](crate::client::fluent_builders::DeleteKeyGroup) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`id(impl Into<String>)`](crate::client::fluent_builders::DeleteKeyGroup::id) / [`set_id(Option<String>)`](crate::client::fluent_builders::DeleteKeyGroup::set_id): <p>The identifier of the key group that you are deleting. To get the identifier, use <code>ListKeyGroups</code>.</p>
    ///   - [`if_match(impl Into<String>)`](crate::client::fluent_builders::DeleteKeyGroup::if_match) / [`set_if_match(Option<String>)`](crate::client::fluent_builders::DeleteKeyGroup::set_if_match): <p>The version of the key group that you are deleting. The version is the key group’s <code>ETag</code> value. To get the <code>ETag</code>, use <code>GetKeyGroup</code> or <code>GetKeyGroupConfig</code>.</p>
    /// - On success, responds with [`DeleteKeyGroupOutput`](crate::output::DeleteKeyGroupOutput)

    /// - On failure, responds with [`SdkError<DeleteKeyGroupError>`](crate::error::DeleteKeyGroupError)
    pub fn delete_key_group(&self) -> fluent_builders::DeleteKeyGroup {
        fluent_builders::DeleteKeyGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteMonitoringSubscription`](crate::client::fluent_builders::DeleteMonitoringSubscription) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`distribution_id(impl Into<String>)`](crate::client::fluent_builders::DeleteMonitoringSubscription::distribution_id) / [`set_distribution_id(Option<String>)`](crate::client::fluent_builders::DeleteMonitoringSubscription::set_distribution_id): <p>The ID of the distribution that you are disabling metrics for.</p>
    /// - On success, responds with [`DeleteMonitoringSubscriptionOutput`](crate::output::DeleteMonitoringSubscriptionOutput)

    /// - On failure, responds with [`SdkError<DeleteMonitoringSubscriptionError>`](crate::error::DeleteMonitoringSubscriptionError)
    pub fn delete_monitoring_subscription(&self) -> fluent_builders::DeleteMonitoringSubscription {
        fluent_builders::DeleteMonitoringSubscription::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteOriginRequestPolicy`](crate::client::fluent_builders::DeleteOriginRequestPolicy) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`id(impl Into<String>)`](crate::client::fluent_builders::DeleteOriginRequestPolicy::id) / [`set_id(Option<String>)`](crate::client::fluent_builders::DeleteOriginRequestPolicy::set_id): <p>The unique identifier for the origin request policy that you are deleting. To get the identifier, you can use <code>ListOriginRequestPolicies</code>.</p>
    ///   - [`if_match(impl Into<String>)`](crate::client::fluent_builders::DeleteOriginRequestPolicy::if_match) / [`set_if_match(Option<String>)`](crate::client::fluent_builders::DeleteOriginRequestPolicy::set_if_match): <p>The version of the origin request policy that you are deleting. The version is the origin request policy’s <code>ETag</code> value, which you can get using <code>ListOriginRequestPolicies</code>, <code>GetOriginRequestPolicy</code>, or <code>GetOriginRequestPolicyConfig</code>.</p>
    /// - On success, responds with [`DeleteOriginRequestPolicyOutput`](crate::output::DeleteOriginRequestPolicyOutput)

    /// - On failure, responds with [`SdkError<DeleteOriginRequestPolicyError>`](crate::error::DeleteOriginRequestPolicyError)
    pub fn delete_origin_request_policy(&self) -> fluent_builders::DeleteOriginRequestPolicy {
        fluent_builders::DeleteOriginRequestPolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeletePublicKey`](crate::client::fluent_builders::DeletePublicKey) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`id(impl Into<String>)`](crate::client::fluent_builders::DeletePublicKey::id) / [`set_id(Option<String>)`](crate::client::fluent_builders::DeletePublicKey::set_id): <p>The ID of the public key you want to remove from CloudFront.</p>
    ///   - [`if_match(impl Into<String>)`](crate::client::fluent_builders::DeletePublicKey::if_match) / [`set_if_match(Option<String>)`](crate::client::fluent_builders::DeletePublicKey::set_if_match): <p>The value of the <code>ETag</code> header that you received when retrieving the public key identity to delete. For example: <code>E2QWRUHAPOMQZL</code>.</p>
    /// - On success, responds with [`DeletePublicKeyOutput`](crate::output::DeletePublicKeyOutput)

    /// - On failure, responds with [`SdkError<DeletePublicKeyError>`](crate::error::DeletePublicKeyError)
    pub fn delete_public_key(&self) -> fluent_builders::DeletePublicKey {
        fluent_builders::DeletePublicKey::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteRealtimeLogConfig`](crate::client::fluent_builders::DeleteRealtimeLogConfig) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::DeleteRealtimeLogConfig::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::DeleteRealtimeLogConfig::set_name): <p>The name of the real-time log configuration to delete.</p>
    ///   - [`arn(impl Into<String>)`](crate::client::fluent_builders::DeleteRealtimeLogConfig::arn) / [`set_arn(Option<String>)`](crate::client::fluent_builders::DeleteRealtimeLogConfig::set_arn): <p>The Amazon Resource Name (ARN) of the real-time log configuration to delete.</p>
    /// - On success, responds with [`DeleteRealtimeLogConfigOutput`](crate::output::DeleteRealtimeLogConfigOutput)

    /// - On failure, responds with [`SdkError<DeleteRealtimeLogConfigError>`](crate::error::DeleteRealtimeLogConfigError)
    pub fn delete_realtime_log_config(&self) -> fluent_builders::DeleteRealtimeLogConfig {
        fluent_builders::DeleteRealtimeLogConfig::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteResponseHeadersPolicy`](crate::client::fluent_builders::DeleteResponseHeadersPolicy) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`id(impl Into<String>)`](crate::client::fluent_builders::DeleteResponseHeadersPolicy::id) / [`set_id(Option<String>)`](crate::client::fluent_builders::DeleteResponseHeadersPolicy::set_id): <p>The identifier for the response headers policy that you are deleting.</p>  <p>To get the identifier, you can use <code>ListResponseHeadersPolicies</code>.</p>
    ///   - [`if_match(impl Into<String>)`](crate::client::fluent_builders::DeleteResponseHeadersPolicy::if_match) / [`set_if_match(Option<String>)`](crate::client::fluent_builders::DeleteResponseHeadersPolicy::set_if_match): <p>The version of the response headers policy that you are deleting.</p>  <p>The version is the response headers policy’s <code>ETag</code> value, which you can get using <code>ListResponseHeadersPolicies</code>, <code>GetResponseHeadersPolicy</code>, or <code>GetResponseHeadersPolicyConfig</code>.</p>
    /// - On success, responds with [`DeleteResponseHeadersPolicyOutput`](crate::output::DeleteResponseHeadersPolicyOutput)

    /// - On failure, responds with [`SdkError<DeleteResponseHeadersPolicyError>`](crate::error::DeleteResponseHeadersPolicyError)
    pub fn delete_response_headers_policy(&self) -> fluent_builders::DeleteResponseHeadersPolicy {
        fluent_builders::DeleteResponseHeadersPolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteStreamingDistribution`](crate::client::fluent_builders::DeleteStreamingDistribution) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`id(impl Into<String>)`](crate::client::fluent_builders::DeleteStreamingDistribution::id) / [`set_id(Option<String>)`](crate::client::fluent_builders::DeleteStreamingDistribution::set_id): <p>The distribution ID. </p>
    ///   - [`if_match(impl Into<String>)`](crate::client::fluent_builders::DeleteStreamingDistribution::if_match) / [`set_if_match(Option<String>)`](crate::client::fluent_builders::DeleteStreamingDistribution::set_if_match): <p>The value of the <code>ETag</code> header that you received when you disabled the streaming distribution. For example: <code>E2QWRUHAPOMQZL</code>.</p>
    /// - On success, responds with [`DeleteStreamingDistributionOutput`](crate::output::DeleteStreamingDistributionOutput)

    /// - On failure, responds with [`SdkError<DeleteStreamingDistributionError>`](crate::error::DeleteStreamingDistributionError)
    pub fn delete_streaming_distribution(&self) -> fluent_builders::DeleteStreamingDistribution {
        fluent_builders::DeleteStreamingDistribution::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeFunction`](crate::client::fluent_builders::DescribeFunction) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::DescribeFunction::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::DescribeFunction::set_name): <p>The name of the function that you are getting information about.</p>
    ///   - [`stage(FunctionStage)`](crate::client::fluent_builders::DescribeFunction::stage) / [`set_stage(Option<FunctionStage>)`](crate::client::fluent_builders::DescribeFunction::set_stage): <p>The function’s stage, either <code>DEVELOPMENT</code> or <code>LIVE</code>.</p>
    /// - On success, responds with [`DescribeFunctionOutput`](crate::output::DescribeFunctionOutput) with field(s):
    ///   - [`function_summary(Option<FunctionSummary>)`](crate::output::DescribeFunctionOutput::function_summary): <p>Contains configuration information and metadata about a CloudFront function.</p>
    ///   - [`e_tag(Option<String>)`](crate::output::DescribeFunctionOutput::e_tag): <p>The version identifier for the current version of the CloudFront function.</p>
    /// - On failure, responds with [`SdkError<DescribeFunctionError>`](crate::error::DescribeFunctionError)
    pub fn describe_function(&self) -> fluent_builders::DescribeFunction {
        fluent_builders::DescribeFunction::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetCachePolicy`](crate::client::fluent_builders::GetCachePolicy) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`id(impl Into<String>)`](crate::client::fluent_builders::GetCachePolicy::id) / [`set_id(Option<String>)`](crate::client::fluent_builders::GetCachePolicy::set_id): <p>The unique identifier for the cache policy. If the cache policy is attached to a distribution’s cache behavior, you can get the policy’s identifier using <code>ListDistributions</code> or <code>GetDistribution</code>. If the cache policy is not attached to a cache behavior, you can get the identifier using <code>ListCachePolicies</code>.</p>
    /// - On success, responds with [`GetCachePolicyOutput`](crate::output::GetCachePolicyOutput) with field(s):
    ///   - [`cache_policy(Option<CachePolicy>)`](crate::output::GetCachePolicyOutput::cache_policy): <p>The cache policy.</p>
    ///   - [`e_tag(Option<String>)`](crate::output::GetCachePolicyOutput::e_tag): <p>The current version of the cache policy.</p>
    /// - On failure, responds with [`SdkError<GetCachePolicyError>`](crate::error::GetCachePolicyError)
    pub fn get_cache_policy(&self) -> fluent_builders::GetCachePolicy {
        fluent_builders::GetCachePolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetCachePolicyConfig`](crate::client::fluent_builders::GetCachePolicyConfig) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`id(impl Into<String>)`](crate::client::fluent_builders::GetCachePolicyConfig::id) / [`set_id(Option<String>)`](crate::client::fluent_builders::GetCachePolicyConfig::set_id): <p>The unique identifier for the cache policy. If the cache policy is attached to a distribution’s cache behavior, you can get the policy’s identifier using <code>ListDistributions</code> or <code>GetDistribution</code>. If the cache policy is not attached to a cache behavior, you can get the identifier using <code>ListCachePolicies</code>.</p>
    /// - On success, responds with [`GetCachePolicyConfigOutput`](crate::output::GetCachePolicyConfigOutput) with field(s):
    ///   - [`cache_policy_config(Option<CachePolicyConfig>)`](crate::output::GetCachePolicyConfigOutput::cache_policy_config): <p>The cache policy configuration.</p>
    ///   - [`e_tag(Option<String>)`](crate::output::GetCachePolicyConfigOutput::e_tag): <p>The current version of the cache policy.</p>
    /// - On failure, responds with [`SdkError<GetCachePolicyConfigError>`](crate::error::GetCachePolicyConfigError)
    pub fn get_cache_policy_config(&self) -> fluent_builders::GetCachePolicyConfig {
        fluent_builders::GetCachePolicyConfig::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetCloudFrontOriginAccessIdentity`](crate::client::fluent_builders::GetCloudFrontOriginAccessIdentity) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`id(impl Into<String>)`](crate::client::fluent_builders::GetCloudFrontOriginAccessIdentity::id) / [`set_id(Option<String>)`](crate::client::fluent_builders::GetCloudFrontOriginAccessIdentity::set_id): <p>The identity's ID.</p>
    /// - On success, responds with [`GetCloudFrontOriginAccessIdentityOutput`](crate::output::GetCloudFrontOriginAccessIdentityOutput) with field(s):
    ///   - [`cloud_front_origin_access_identity(Option<CloudFrontOriginAccessIdentity>)`](crate::output::GetCloudFrontOriginAccessIdentityOutput::cloud_front_origin_access_identity): <p>The origin access identity's information.</p>
    ///   - [`e_tag(Option<String>)`](crate::output::GetCloudFrontOriginAccessIdentityOutput::e_tag): <p>The current version of the origin access identity's information. For example: <code>E2QWRUHAPOMQZL</code>.</p>
    /// - On failure, responds with [`SdkError<GetCloudFrontOriginAccessIdentityError>`](crate::error::GetCloudFrontOriginAccessIdentityError)
    pub fn get_cloud_front_origin_access_identity(
        &self,
    ) -> fluent_builders::GetCloudFrontOriginAccessIdentity {
        fluent_builders::GetCloudFrontOriginAccessIdentity::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetCloudFrontOriginAccessIdentityConfig`](crate::client::fluent_builders::GetCloudFrontOriginAccessIdentityConfig) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`id(impl Into<String>)`](crate::client::fluent_builders::GetCloudFrontOriginAccessIdentityConfig::id) / [`set_id(Option<String>)`](crate::client::fluent_builders::GetCloudFrontOriginAccessIdentityConfig::set_id): <p>The identity's ID. </p>
    /// - On success, responds with [`GetCloudFrontOriginAccessIdentityConfigOutput`](crate::output::GetCloudFrontOriginAccessIdentityConfigOutput) with field(s):
    ///   - [`cloud_front_origin_access_identity_config(Option<CloudFrontOriginAccessIdentityConfig>)`](crate::output::GetCloudFrontOriginAccessIdentityConfigOutput::cloud_front_origin_access_identity_config): <p>The origin access identity's configuration information. </p>
    ///   - [`e_tag(Option<String>)`](crate::output::GetCloudFrontOriginAccessIdentityConfigOutput::e_tag): <p>The current version of the configuration. For example: <code>E2QWRUHAPOMQZL</code>.</p>
    /// - On failure, responds with [`SdkError<GetCloudFrontOriginAccessIdentityConfigError>`](crate::error::GetCloudFrontOriginAccessIdentityConfigError)
    pub fn get_cloud_front_origin_access_identity_config(
        &self,
    ) -> fluent_builders::GetCloudFrontOriginAccessIdentityConfig {
        fluent_builders::GetCloudFrontOriginAccessIdentityConfig::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetDistribution`](crate::client::fluent_builders::GetDistribution) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`id(impl Into<String>)`](crate::client::fluent_builders::GetDistribution::id) / [`set_id(Option<String>)`](crate::client::fluent_builders::GetDistribution::set_id): <p>The distribution's ID. If the ID is empty, an empty distribution configuration is returned.</p>
    /// - On success, responds with [`GetDistributionOutput`](crate::output::GetDistributionOutput) with field(s):
    ///   - [`distribution(Option<Distribution>)`](crate::output::GetDistributionOutput::distribution): <p>The distribution's information.</p>
    ///   - [`e_tag(Option<String>)`](crate::output::GetDistributionOutput::e_tag): <p>The current version of the distribution's information. For example: <code>E2QWRUHAPOMQZL</code>.</p>
    /// - On failure, responds with [`SdkError<GetDistributionError>`](crate::error::GetDistributionError)
    pub fn get_distribution(&self) -> fluent_builders::GetDistribution {
        fluent_builders::GetDistribution::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetDistributionConfig`](crate::client::fluent_builders::GetDistributionConfig) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`id(impl Into<String>)`](crate::client::fluent_builders::GetDistributionConfig::id) / [`set_id(Option<String>)`](crate::client::fluent_builders::GetDistributionConfig::set_id): <p>The distribution's ID. If the ID is empty, an empty distribution configuration is returned.</p>
    /// - On success, responds with [`GetDistributionConfigOutput`](crate::output::GetDistributionConfigOutput) with field(s):
    ///   - [`distribution_config(Option<DistributionConfig>)`](crate::output::GetDistributionConfigOutput::distribution_config): <p>The distribution's configuration information.</p>
    ///   - [`e_tag(Option<String>)`](crate::output::GetDistributionConfigOutput::e_tag): <p>The current version of the configuration. For example: <code>E2QWRUHAPOMQZL</code>.</p>
    /// - On failure, responds with [`SdkError<GetDistributionConfigError>`](crate::error::GetDistributionConfigError)
    pub fn get_distribution_config(&self) -> fluent_builders::GetDistributionConfig {
        fluent_builders::GetDistributionConfig::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetFieldLevelEncryption`](crate::client::fluent_builders::GetFieldLevelEncryption) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`id(impl Into<String>)`](crate::client::fluent_builders::GetFieldLevelEncryption::id) / [`set_id(Option<String>)`](crate::client::fluent_builders::GetFieldLevelEncryption::set_id): <p>Request the ID for the field-level encryption configuration information.</p>
    /// - On success, responds with [`GetFieldLevelEncryptionOutput`](crate::output::GetFieldLevelEncryptionOutput) with field(s):
    ///   - [`field_level_encryption(Option<FieldLevelEncryption>)`](crate::output::GetFieldLevelEncryptionOutput::field_level_encryption): <p>Return the field-level encryption configuration information.</p>
    ///   - [`e_tag(Option<String>)`](crate::output::GetFieldLevelEncryptionOutput::e_tag): <p>The current version of the field level encryption configuration. For example: <code>E2QWRUHAPOMQZL</code>.</p>
    /// - On failure, responds with [`SdkError<GetFieldLevelEncryptionError>`](crate::error::GetFieldLevelEncryptionError)
    pub fn get_field_level_encryption(&self) -> fluent_builders::GetFieldLevelEncryption {
        fluent_builders::GetFieldLevelEncryption::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetFieldLevelEncryptionConfig`](crate::client::fluent_builders::GetFieldLevelEncryptionConfig) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`id(impl Into<String>)`](crate::client::fluent_builders::GetFieldLevelEncryptionConfig::id) / [`set_id(Option<String>)`](crate::client::fluent_builders::GetFieldLevelEncryptionConfig::set_id): <p>Request the ID for the field-level encryption configuration information.</p>
    /// - On success, responds with [`GetFieldLevelEncryptionConfigOutput`](crate::output::GetFieldLevelEncryptionConfigOutput) with field(s):
    ///   - [`field_level_encryption_config(Option<FieldLevelEncryptionConfig>)`](crate::output::GetFieldLevelEncryptionConfigOutput::field_level_encryption_config): <p>Return the field-level encryption configuration information.</p>
    ///   - [`e_tag(Option<String>)`](crate::output::GetFieldLevelEncryptionConfigOutput::e_tag): <p>The current version of the field level encryption configuration. For example: <code>E2QWRUHAPOMQZL</code>.</p>
    /// - On failure, responds with [`SdkError<GetFieldLevelEncryptionConfigError>`](crate::error::GetFieldLevelEncryptionConfigError)
    pub fn get_field_level_encryption_config(
        &self,
    ) -> fluent_builders::GetFieldLevelEncryptionConfig {
        fluent_builders::GetFieldLevelEncryptionConfig::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetFieldLevelEncryptionProfile`](crate::client::fluent_builders::GetFieldLevelEncryptionProfile) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`id(impl Into<String>)`](crate::client::fluent_builders::GetFieldLevelEncryptionProfile::id) / [`set_id(Option<String>)`](crate::client::fluent_builders::GetFieldLevelEncryptionProfile::set_id): <p>Get the ID for the field-level encryption profile information.</p>
    /// - On success, responds with [`GetFieldLevelEncryptionProfileOutput`](crate::output::GetFieldLevelEncryptionProfileOutput) with field(s):
    ///   - [`field_level_encryption_profile(Option<FieldLevelEncryptionProfile>)`](crate::output::GetFieldLevelEncryptionProfileOutput::field_level_encryption_profile): <p>Return the field-level encryption profile information.</p>
    ///   - [`e_tag(Option<String>)`](crate::output::GetFieldLevelEncryptionProfileOutput::e_tag): <p>The current version of the field level encryption profile. For example: <code>E2QWRUHAPOMQZL</code>.</p>
    /// - On failure, responds with [`SdkError<GetFieldLevelEncryptionProfileError>`](crate::error::GetFieldLevelEncryptionProfileError)
    pub fn get_field_level_encryption_profile(
        &self,
    ) -> fluent_builders::GetFieldLevelEncryptionProfile {
        fluent_builders::GetFieldLevelEncryptionProfile::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetFieldLevelEncryptionProfileConfig`](crate::client::fluent_builders::GetFieldLevelEncryptionProfileConfig) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`id(impl Into<String>)`](crate::client::fluent_builders::GetFieldLevelEncryptionProfileConfig::id) / [`set_id(Option<String>)`](crate::client::fluent_builders::GetFieldLevelEncryptionProfileConfig::set_id): <p>Get the ID for the field-level encryption profile configuration information.</p>
    /// - On success, responds with [`GetFieldLevelEncryptionProfileConfigOutput`](crate::output::GetFieldLevelEncryptionProfileConfigOutput) with field(s):
    ///   - [`field_level_encryption_profile_config(Option<FieldLevelEncryptionProfileConfig>)`](crate::output::GetFieldLevelEncryptionProfileConfigOutput::field_level_encryption_profile_config): <p>Return the field-level encryption profile configuration information.</p>
    ///   - [`e_tag(Option<String>)`](crate::output::GetFieldLevelEncryptionProfileConfigOutput::e_tag): <p>The current version of the field-level encryption profile configuration result. For example: <code>E2QWRUHAPOMQZL</code>.</p>
    /// - On failure, responds with [`SdkError<GetFieldLevelEncryptionProfileConfigError>`](crate::error::GetFieldLevelEncryptionProfileConfigError)
    pub fn get_field_level_encryption_profile_config(
        &self,
    ) -> fluent_builders::GetFieldLevelEncryptionProfileConfig {
        fluent_builders::GetFieldLevelEncryptionProfileConfig::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetFunction`](crate::client::fluent_builders::GetFunction) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::GetFunction::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::GetFunction::set_name): <p>The name of the function whose code you are getting.</p>
    ///   - [`stage(FunctionStage)`](crate::client::fluent_builders::GetFunction::stage) / [`set_stage(Option<FunctionStage>)`](crate::client::fluent_builders::GetFunction::set_stage): <p>The function’s stage, either <code>DEVELOPMENT</code> or <code>LIVE</code>.</p>
    /// - On success, responds with [`GetFunctionOutput`](crate::output::GetFunctionOutput) with field(s):
    ///   - [`function_code(Option<Blob>)`](crate::output::GetFunctionOutput::function_code): <p>The function code of a CloudFront function.</p>
    ///   - [`e_tag(Option<String>)`](crate::output::GetFunctionOutput::e_tag): <p>The version identifier for the current version of the CloudFront function.</p>
    ///   - [`content_type(Option<String>)`](crate::output::GetFunctionOutput::content_type): <p>The content type (media type) of the response.</p>
    /// - On failure, responds with [`SdkError<GetFunctionError>`](crate::error::GetFunctionError)
    pub fn get_function(&self) -> fluent_builders::GetFunction {
        fluent_builders::GetFunction::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetInvalidation`](crate::client::fluent_builders::GetInvalidation) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`distribution_id(impl Into<String>)`](crate::client::fluent_builders::GetInvalidation::distribution_id) / [`set_distribution_id(Option<String>)`](crate::client::fluent_builders::GetInvalidation::set_distribution_id): <p>The distribution's ID.</p>
    ///   - [`id(impl Into<String>)`](crate::client::fluent_builders::GetInvalidation::id) / [`set_id(Option<String>)`](crate::client::fluent_builders::GetInvalidation::set_id): <p>The identifier for the invalidation request, for example, <code>IDFDVBD632BHDS5</code>.</p>
    /// - On success, responds with [`GetInvalidationOutput`](crate::output::GetInvalidationOutput) with field(s):
    ///   - [`invalidation(Option<Invalidation>)`](crate::output::GetInvalidationOutput::invalidation): <p>The invalidation's information. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/InvalidationDatatype.html">Invalidation Complex Type</a>. </p>
    /// - On failure, responds with [`SdkError<GetInvalidationError>`](crate::error::GetInvalidationError)
    pub fn get_invalidation(&self) -> fluent_builders::GetInvalidation {
        fluent_builders::GetInvalidation::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetKeyGroup`](crate::client::fluent_builders::GetKeyGroup) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`id(impl Into<String>)`](crate::client::fluent_builders::GetKeyGroup::id) / [`set_id(Option<String>)`](crate::client::fluent_builders::GetKeyGroup::set_id): <p>The identifier of the key group that you are getting. To get the identifier, use <code>ListKeyGroups</code>.</p>
    /// - On success, responds with [`GetKeyGroupOutput`](crate::output::GetKeyGroupOutput) with field(s):
    ///   - [`key_group(Option<KeyGroup>)`](crate::output::GetKeyGroupOutput::key_group): <p>The key group.</p>
    ///   - [`e_tag(Option<String>)`](crate::output::GetKeyGroupOutput::e_tag): <p>The identifier for this version of the key group.</p>
    /// - On failure, responds with [`SdkError<GetKeyGroupError>`](crate::error::GetKeyGroupError)
    pub fn get_key_group(&self) -> fluent_builders::GetKeyGroup {
        fluent_builders::GetKeyGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetKeyGroupConfig`](crate::client::fluent_builders::GetKeyGroupConfig) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`id(impl Into<String>)`](crate::client::fluent_builders::GetKeyGroupConfig::id) / [`set_id(Option<String>)`](crate::client::fluent_builders::GetKeyGroupConfig::set_id): <p>The identifier of the key group whose configuration you are getting. To get the identifier, use <code>ListKeyGroups</code>.</p>
    /// - On success, responds with [`GetKeyGroupConfigOutput`](crate::output::GetKeyGroupConfigOutput) with field(s):
    ///   - [`key_group_config(Option<KeyGroupConfig>)`](crate::output::GetKeyGroupConfigOutput::key_group_config): <p>The key group configuration.</p>
    ///   - [`e_tag(Option<String>)`](crate::output::GetKeyGroupConfigOutput::e_tag): <p>The identifier for this version of the key group.</p>
    /// - On failure, responds with [`SdkError<GetKeyGroupConfigError>`](crate::error::GetKeyGroupConfigError)
    pub fn get_key_group_config(&self) -> fluent_builders::GetKeyGroupConfig {
        fluent_builders::GetKeyGroupConfig::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetMonitoringSubscription`](crate::client::fluent_builders::GetMonitoringSubscription) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`distribution_id(impl Into<String>)`](crate::client::fluent_builders::GetMonitoringSubscription::distribution_id) / [`set_distribution_id(Option<String>)`](crate::client::fluent_builders::GetMonitoringSubscription::set_distribution_id): <p>The ID of the distribution that you are getting metrics information for.</p>
    /// - On success, responds with [`GetMonitoringSubscriptionOutput`](crate::output::GetMonitoringSubscriptionOutput) with field(s):
    ///   - [`monitoring_subscription(Option<MonitoringSubscription>)`](crate::output::GetMonitoringSubscriptionOutput::monitoring_subscription): <p>A monitoring subscription. This structure contains information about whether additional CloudWatch metrics are enabled for a given CloudFront distribution.</p>
    /// - On failure, responds with [`SdkError<GetMonitoringSubscriptionError>`](crate::error::GetMonitoringSubscriptionError)
    pub fn get_monitoring_subscription(&self) -> fluent_builders::GetMonitoringSubscription {
        fluent_builders::GetMonitoringSubscription::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetOriginRequestPolicy`](crate::client::fluent_builders::GetOriginRequestPolicy) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`id(impl Into<String>)`](crate::client::fluent_builders::GetOriginRequestPolicy::id) / [`set_id(Option<String>)`](crate::client::fluent_builders::GetOriginRequestPolicy::set_id): <p>The unique identifier for the origin request policy. If the origin request policy is attached to a distribution’s cache behavior, you can get the policy’s identifier using <code>ListDistributions</code> or <code>GetDistribution</code>. If the origin request policy is not attached to a cache behavior, you can get the identifier using <code>ListOriginRequestPolicies</code>.</p>
    /// - On success, responds with [`GetOriginRequestPolicyOutput`](crate::output::GetOriginRequestPolicyOutput) with field(s):
    ///   - [`origin_request_policy(Option<OriginRequestPolicy>)`](crate::output::GetOriginRequestPolicyOutput::origin_request_policy): <p>The origin request policy.</p>
    ///   - [`e_tag(Option<String>)`](crate::output::GetOriginRequestPolicyOutput::e_tag): <p>The current version of the origin request policy.</p>
    /// - On failure, responds with [`SdkError<GetOriginRequestPolicyError>`](crate::error::GetOriginRequestPolicyError)
    pub fn get_origin_request_policy(&self) -> fluent_builders::GetOriginRequestPolicy {
        fluent_builders::GetOriginRequestPolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetOriginRequestPolicyConfig`](crate::client::fluent_builders::GetOriginRequestPolicyConfig) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`id(impl Into<String>)`](crate::client::fluent_builders::GetOriginRequestPolicyConfig::id) / [`set_id(Option<String>)`](crate::client::fluent_builders::GetOriginRequestPolicyConfig::set_id): <p>The unique identifier for the origin request policy. If the origin request policy is attached to a distribution’s cache behavior, you can get the policy’s identifier using <code>ListDistributions</code> or <code>GetDistribution</code>. If the origin request policy is not attached to a cache behavior, you can get the identifier using <code>ListOriginRequestPolicies</code>.</p>
    /// - On success, responds with [`GetOriginRequestPolicyConfigOutput`](crate::output::GetOriginRequestPolicyConfigOutput) with field(s):
    ///   - [`origin_request_policy_config(Option<OriginRequestPolicyConfig>)`](crate::output::GetOriginRequestPolicyConfigOutput::origin_request_policy_config): <p>The origin request policy configuration.</p>
    ///   - [`e_tag(Option<String>)`](crate::output::GetOriginRequestPolicyConfigOutput::e_tag): <p>The current version of the origin request policy.</p>
    /// - On failure, responds with [`SdkError<GetOriginRequestPolicyConfigError>`](crate::error::GetOriginRequestPolicyConfigError)
    pub fn get_origin_request_policy_config(
        &self,
    ) -> fluent_builders::GetOriginRequestPolicyConfig {
        fluent_builders::GetOriginRequestPolicyConfig::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetPublicKey`](crate::client::fluent_builders::GetPublicKey) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`id(impl Into<String>)`](crate::client::fluent_builders::GetPublicKey::id) / [`set_id(Option<String>)`](crate::client::fluent_builders::GetPublicKey::set_id): <p>The identifier of the public key you are getting.</p>
    /// - On success, responds with [`GetPublicKeyOutput`](crate::output::GetPublicKeyOutput) with field(s):
    ///   - [`public_key(Option<PublicKey>)`](crate::output::GetPublicKeyOutput::public_key): <p>The public key.</p>
    ///   - [`e_tag(Option<String>)`](crate::output::GetPublicKeyOutput::e_tag): <p>The identifier for this version of the public key.</p>
    /// - On failure, responds with [`SdkError<GetPublicKeyError>`](crate::error::GetPublicKeyError)
    pub fn get_public_key(&self) -> fluent_builders::GetPublicKey {
        fluent_builders::GetPublicKey::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetPublicKeyConfig`](crate::client::fluent_builders::GetPublicKeyConfig) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`id(impl Into<String>)`](crate::client::fluent_builders::GetPublicKeyConfig::id) / [`set_id(Option<String>)`](crate::client::fluent_builders::GetPublicKeyConfig::set_id): <p>The identifier of the public key whose configuration you are getting.</p>
    /// - On success, responds with [`GetPublicKeyConfigOutput`](crate::output::GetPublicKeyConfigOutput) with field(s):
    ///   - [`public_key_config(Option<PublicKeyConfig>)`](crate::output::GetPublicKeyConfigOutput::public_key_config): <p>A public key configuration.</p>
    ///   - [`e_tag(Option<String>)`](crate::output::GetPublicKeyConfigOutput::e_tag): <p>The identifier for this version of the public key configuration.</p>
    /// - On failure, responds with [`SdkError<GetPublicKeyConfigError>`](crate::error::GetPublicKeyConfigError)
    pub fn get_public_key_config(&self) -> fluent_builders::GetPublicKeyConfig {
        fluent_builders::GetPublicKeyConfig::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetRealtimeLogConfig`](crate::client::fluent_builders::GetRealtimeLogConfig) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::GetRealtimeLogConfig::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::GetRealtimeLogConfig::set_name): <p>The name of the real-time log configuration to get.</p>
    ///   - [`arn(impl Into<String>)`](crate::client::fluent_builders::GetRealtimeLogConfig::arn) / [`set_arn(Option<String>)`](crate::client::fluent_builders::GetRealtimeLogConfig::set_arn): <p>The Amazon Resource Name (ARN) of the real-time log configuration to get.</p>
    /// - On success, responds with [`GetRealtimeLogConfigOutput`](crate::output::GetRealtimeLogConfigOutput) with field(s):
    ///   - [`realtime_log_config(Option<RealtimeLogConfig>)`](crate::output::GetRealtimeLogConfigOutput::realtime_log_config): <p>A real-time log configuration.</p>
    /// - On failure, responds with [`SdkError<GetRealtimeLogConfigError>`](crate::error::GetRealtimeLogConfigError)
    pub fn get_realtime_log_config(&self) -> fluent_builders::GetRealtimeLogConfig {
        fluent_builders::GetRealtimeLogConfig::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetResponseHeadersPolicy`](crate::client::fluent_builders::GetResponseHeadersPolicy) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`id(impl Into<String>)`](crate::client::fluent_builders::GetResponseHeadersPolicy::id) / [`set_id(Option<String>)`](crate::client::fluent_builders::GetResponseHeadersPolicy::set_id): <p>The identifier for the response headers policy.</p>  <p>If the response headers policy is attached to a distribution’s cache behavior, you can get the policy’s identifier using <code>ListDistributions</code> or <code>GetDistribution</code>. If the response headers policy is not attached to a cache behavior, you can get the identifier using <code>ListResponseHeadersPolicies</code>.</p>
    /// - On success, responds with [`GetResponseHeadersPolicyOutput`](crate::output::GetResponseHeadersPolicyOutput) with field(s):
    ///   - [`response_headers_policy(Option<ResponseHeadersPolicy>)`](crate::output::GetResponseHeadersPolicyOutput::response_headers_policy): <p>Contains a response headers policy.</p>
    ///   - [`e_tag(Option<String>)`](crate::output::GetResponseHeadersPolicyOutput::e_tag): <p>The version identifier for the current version of the response headers policy.</p>
    /// - On failure, responds with [`SdkError<GetResponseHeadersPolicyError>`](crate::error::GetResponseHeadersPolicyError)
    pub fn get_response_headers_policy(&self) -> fluent_builders::GetResponseHeadersPolicy {
        fluent_builders::GetResponseHeadersPolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetResponseHeadersPolicyConfig`](crate::client::fluent_builders::GetResponseHeadersPolicyConfig) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`id(impl Into<String>)`](crate::client::fluent_builders::GetResponseHeadersPolicyConfig::id) / [`set_id(Option<String>)`](crate::client::fluent_builders::GetResponseHeadersPolicyConfig::set_id): <p>The identifier for the response headers policy.</p>  <p>If the response headers policy is attached to a distribution’s cache behavior, you can get the policy’s identifier using <code>ListDistributions</code> or <code>GetDistribution</code>. If the response headers policy is not attached to a cache behavior, you can get the identifier using <code>ListResponseHeadersPolicies</code>.</p>
    /// - On success, responds with [`GetResponseHeadersPolicyConfigOutput`](crate::output::GetResponseHeadersPolicyConfigOutput) with field(s):
    ///   - [`response_headers_policy_config(Option<ResponseHeadersPolicyConfig>)`](crate::output::GetResponseHeadersPolicyConfigOutput::response_headers_policy_config): <p>Contains a response headers policy.</p>
    ///   - [`e_tag(Option<String>)`](crate::output::GetResponseHeadersPolicyConfigOutput::e_tag): <p>The version identifier for the current version of the response headers policy.</p>
    /// - On failure, responds with [`SdkError<GetResponseHeadersPolicyConfigError>`](crate::error::GetResponseHeadersPolicyConfigError)
    pub fn get_response_headers_policy_config(
        &self,
    ) -> fluent_builders::GetResponseHeadersPolicyConfig {
        fluent_builders::GetResponseHeadersPolicyConfig::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetStreamingDistribution`](crate::client::fluent_builders::GetStreamingDistribution) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`id(impl Into<String>)`](crate::client::fluent_builders::GetStreamingDistribution::id) / [`set_id(Option<String>)`](crate::client::fluent_builders::GetStreamingDistribution::set_id): <p>The streaming distribution's ID.</p>
    /// - On success, responds with [`GetStreamingDistributionOutput`](crate::output::GetStreamingDistributionOutput) with field(s):
    ///   - [`streaming_distribution(Option<StreamingDistribution>)`](crate::output::GetStreamingDistributionOutput::streaming_distribution): <p>The streaming distribution's information.</p>
    ///   - [`e_tag(Option<String>)`](crate::output::GetStreamingDistributionOutput::e_tag): <p>The current version of the streaming distribution's information. For example: <code>E2QWRUHAPOMQZL</code>.</p>
    /// - On failure, responds with [`SdkError<GetStreamingDistributionError>`](crate::error::GetStreamingDistributionError)
    pub fn get_streaming_distribution(&self) -> fluent_builders::GetStreamingDistribution {
        fluent_builders::GetStreamingDistribution::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetStreamingDistributionConfig`](crate::client::fluent_builders::GetStreamingDistributionConfig) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`id(impl Into<String>)`](crate::client::fluent_builders::GetStreamingDistributionConfig::id) / [`set_id(Option<String>)`](crate::client::fluent_builders::GetStreamingDistributionConfig::set_id): <p>The streaming distribution's ID.</p>
    /// - On success, responds with [`GetStreamingDistributionConfigOutput`](crate::output::GetStreamingDistributionConfigOutput) with field(s):
    ///   - [`streaming_distribution_config(Option<StreamingDistributionConfig>)`](crate::output::GetStreamingDistributionConfigOutput::streaming_distribution_config): <p>The streaming distribution's configuration information.</p>
    ///   - [`e_tag(Option<String>)`](crate::output::GetStreamingDistributionConfigOutput::e_tag): <p>The current version of the configuration. For example: <code>E2QWRUHAPOMQZL</code>. </p>
    /// - On failure, responds with [`SdkError<GetStreamingDistributionConfigError>`](crate::error::GetStreamingDistributionConfigError)
    pub fn get_streaming_distribution_config(
        &self,
    ) -> fluent_builders::GetStreamingDistributionConfig {
        fluent_builders::GetStreamingDistributionConfig::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListCachePolicies`](crate::client::fluent_builders::ListCachePolicies) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`r#type(CachePolicyType)`](crate::client::fluent_builders::ListCachePolicies::type) / [`set_type(Option<CachePolicyType>)`](crate::client::fluent_builders::ListCachePolicies::set_type): <p>A filter to return only the specified kinds of cache policies. Valid values are:</p>  <ul>   <li> <p> <code>managed</code> – Returns only the managed policies created by Amazon Web Services.</p> </li>   <li> <p> <code>custom</code> – Returns only the custom policies created in your Amazon Web Services account.</p> </li>  </ul>
    ///   - [`marker(impl Into<String>)`](crate::client::fluent_builders::ListCachePolicies::marker) / [`set_marker(Option<String>)`](crate::client::fluent_builders::ListCachePolicies::set_marker): <p>Use this field when paginating results to indicate where to begin in your list of cache policies. The response includes cache policies in the list that occur after the marker. To get the next page of the list, set this field’s value to the value of <code>NextMarker</code> from the current page’s response.</p>
    ///   - [`max_items(i32)`](crate::client::fluent_builders::ListCachePolicies::max_items) / [`set_max_items(Option<i32>)`](crate::client::fluent_builders::ListCachePolicies::set_max_items): <p>The maximum number of cache policies that you want in the response.</p>
    /// - On success, responds with [`ListCachePoliciesOutput`](crate::output::ListCachePoliciesOutput) with field(s):
    ///   - [`cache_policy_list(Option<CachePolicyList>)`](crate::output::ListCachePoliciesOutput::cache_policy_list): <p>A list of cache policies.</p>
    /// - On failure, responds with [`SdkError<ListCachePoliciesError>`](crate::error::ListCachePoliciesError)
    pub fn list_cache_policies(&self) -> fluent_builders::ListCachePolicies {
        fluent_builders::ListCachePolicies::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListCloudFrontOriginAccessIdentities`](crate::client::fluent_builders::ListCloudFrontOriginAccessIdentities) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListCloudFrontOriginAccessIdentities::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`marker(impl Into<String>)`](crate::client::fluent_builders::ListCloudFrontOriginAccessIdentities::marker) / [`set_marker(Option<String>)`](crate::client::fluent_builders::ListCloudFrontOriginAccessIdentities::set_marker): <p>Use this when paginating results to indicate where to begin in your list of origin access identities. The results include identities in the list that occur after the marker. To get the next page of results, set the <code>Marker</code> to the value of the <code>NextMarker</code> from the current page's response (which is also the ID of the last identity on that page).</p>
    ///   - [`max_items(i32)`](crate::client::fluent_builders::ListCloudFrontOriginAccessIdentities::max_items) / [`set_max_items(Option<i32>)`](crate::client::fluent_builders::ListCloudFrontOriginAccessIdentities::set_max_items): <p>The maximum number of origin access identities you want in the response body. </p>
    /// - On success, responds with [`ListCloudFrontOriginAccessIdentitiesOutput`](crate::output::ListCloudFrontOriginAccessIdentitiesOutput) with field(s):
    ///   - [`cloud_front_origin_access_identity_list(Option<CloudFrontOriginAccessIdentityList>)`](crate::output::ListCloudFrontOriginAccessIdentitiesOutput::cloud_front_origin_access_identity_list): <p>The <code>CloudFrontOriginAccessIdentityList</code> type. </p>
    /// - On failure, responds with [`SdkError<ListCloudFrontOriginAccessIdentitiesError>`](crate::error::ListCloudFrontOriginAccessIdentitiesError)
    pub fn list_cloud_front_origin_access_identities(
        &self,
    ) -> fluent_builders::ListCloudFrontOriginAccessIdentities {
        fluent_builders::ListCloudFrontOriginAccessIdentities::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListConflictingAliases`](crate::client::fluent_builders::ListConflictingAliases) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`distribution_id(impl Into<String>)`](crate::client::fluent_builders::ListConflictingAliases::distribution_id) / [`set_distribution_id(Option<String>)`](crate::client::fluent_builders::ListConflictingAliases::set_distribution_id): <p>The ID of a distribution in your account that has an attached SSL/TLS certificate that includes the provided alias.</p>
    ///   - [`alias(impl Into<String>)`](crate::client::fluent_builders::ListConflictingAliases::alias) / [`set_alias(Option<String>)`](crate::client::fluent_builders::ListConflictingAliases::set_alias): <p>The alias (also called a CNAME) to search for conflicting aliases.</p>
    ///   - [`marker(impl Into<String>)`](crate::client::fluent_builders::ListConflictingAliases::marker) / [`set_marker(Option<String>)`](crate::client::fluent_builders::ListConflictingAliases::set_marker): <p>Use this field when paginating results to indicate where to begin in the list of conflicting aliases. The response includes conflicting aliases in the list that occur after the marker. To get the next page of the list, set this field’s value to the value of <code>NextMarker</code> from the current page’s response.</p>
    ///   - [`max_items(i32)`](crate::client::fluent_builders::ListConflictingAliases::max_items) / [`set_max_items(Option<i32>)`](crate::client::fluent_builders::ListConflictingAliases::set_max_items): <p>The maximum number of conflicting aliases that you want in the response.</p>
    /// - On success, responds with [`ListConflictingAliasesOutput`](crate::output::ListConflictingAliasesOutput) with field(s):
    ///   - [`conflicting_aliases_list(Option<ConflictingAliasesList>)`](crate::output::ListConflictingAliasesOutput::conflicting_aliases_list): <p>A list of conflicting aliases.</p>
    /// - On failure, responds with [`SdkError<ListConflictingAliasesError>`](crate::error::ListConflictingAliasesError)
    pub fn list_conflicting_aliases(&self) -> fluent_builders::ListConflictingAliases {
        fluent_builders::ListConflictingAliases::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListDistributions`](crate::client::fluent_builders::ListDistributions) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListDistributions::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`marker(impl Into<String>)`](crate::client::fluent_builders::ListDistributions::marker) / [`set_marker(Option<String>)`](crate::client::fluent_builders::ListDistributions::set_marker): <p>Use this when paginating results to indicate where to begin in your list of distributions. The results include distributions in the list that occur after the marker. To get the next page of results, set the <code>Marker</code> to the value of the <code>NextMarker</code> from the current page's response (which is also the ID of the last distribution on that page).</p>
    ///   - [`max_items(i32)`](crate::client::fluent_builders::ListDistributions::max_items) / [`set_max_items(Option<i32>)`](crate::client::fluent_builders::ListDistributions::set_max_items): <p>The maximum number of distributions you want in the response body.</p>
    /// - On success, responds with [`ListDistributionsOutput`](crate::output::ListDistributionsOutput) with field(s):
    ///   - [`distribution_list(Option<DistributionList>)`](crate::output::ListDistributionsOutput::distribution_list): <p>The <code>DistributionList</code> type. </p>
    /// - On failure, responds with [`SdkError<ListDistributionsError>`](crate::error::ListDistributionsError)
    pub fn list_distributions(&self) -> fluent_builders::ListDistributions {
        fluent_builders::ListDistributions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListDistributionsByCachePolicyId`](crate::client::fluent_builders::ListDistributionsByCachePolicyId) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`marker(impl Into<String>)`](crate::client::fluent_builders::ListDistributionsByCachePolicyId::marker) / [`set_marker(Option<String>)`](crate::client::fluent_builders::ListDistributionsByCachePolicyId::set_marker): <p>Use this field when paginating results to indicate where to begin in your list of distribution IDs. The response includes distribution IDs in the list that occur after the marker. To get the next page of the list, set this field’s value to the value of <code>NextMarker</code> from the current page’s response.</p>
    ///   - [`max_items(i32)`](crate::client::fluent_builders::ListDistributionsByCachePolicyId::max_items) / [`set_max_items(Option<i32>)`](crate::client::fluent_builders::ListDistributionsByCachePolicyId::set_max_items): <p>The maximum number of distribution IDs that you want in the response.</p>
    ///   - [`cache_policy_id(impl Into<String>)`](crate::client::fluent_builders::ListDistributionsByCachePolicyId::cache_policy_id) / [`set_cache_policy_id(Option<String>)`](crate::client::fluent_builders::ListDistributionsByCachePolicyId::set_cache_policy_id): <p>The ID of the cache policy whose associated distribution IDs you want to list.</p>
    /// - On success, responds with [`ListDistributionsByCachePolicyIdOutput`](crate::output::ListDistributionsByCachePolicyIdOutput) with field(s):
    ///   - [`distribution_id_list(Option<DistributionIdList>)`](crate::output::ListDistributionsByCachePolicyIdOutput::distribution_id_list): <p>A list of distribution IDs.</p>
    /// - On failure, responds with [`SdkError<ListDistributionsByCachePolicyIdError>`](crate::error::ListDistributionsByCachePolicyIdError)
    pub fn list_distributions_by_cache_policy_id(
        &self,
    ) -> fluent_builders::ListDistributionsByCachePolicyId {
        fluent_builders::ListDistributionsByCachePolicyId::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListDistributionsByKeyGroup`](crate::client::fluent_builders::ListDistributionsByKeyGroup) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`marker(impl Into<String>)`](crate::client::fluent_builders::ListDistributionsByKeyGroup::marker) / [`set_marker(Option<String>)`](crate::client::fluent_builders::ListDistributionsByKeyGroup::set_marker): <p>Use this field when paginating results to indicate where to begin in your list of distribution IDs. The response includes distribution IDs in the list that occur after the marker. To get the next page of the list, set this field’s value to the value of <code>NextMarker</code> from the current page’s response.</p>
    ///   - [`max_items(i32)`](crate::client::fluent_builders::ListDistributionsByKeyGroup::max_items) / [`set_max_items(Option<i32>)`](crate::client::fluent_builders::ListDistributionsByKeyGroup::set_max_items): <p>The maximum number of distribution IDs that you want in the response.</p>
    ///   - [`key_group_id(impl Into<String>)`](crate::client::fluent_builders::ListDistributionsByKeyGroup::key_group_id) / [`set_key_group_id(Option<String>)`](crate::client::fluent_builders::ListDistributionsByKeyGroup::set_key_group_id): <p>The ID of the key group whose associated distribution IDs you are listing.</p>
    /// - On success, responds with [`ListDistributionsByKeyGroupOutput`](crate::output::ListDistributionsByKeyGroupOutput) with field(s):
    ///   - [`distribution_id_list(Option<DistributionIdList>)`](crate::output::ListDistributionsByKeyGroupOutput::distribution_id_list): <p>A list of distribution IDs.</p>
    /// - On failure, responds with [`SdkError<ListDistributionsByKeyGroupError>`](crate::error::ListDistributionsByKeyGroupError)
    pub fn list_distributions_by_key_group(&self) -> fluent_builders::ListDistributionsByKeyGroup {
        fluent_builders::ListDistributionsByKeyGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListDistributionsByOriginRequestPolicyId`](crate::client::fluent_builders::ListDistributionsByOriginRequestPolicyId) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`marker(impl Into<String>)`](crate::client::fluent_builders::ListDistributionsByOriginRequestPolicyId::marker) / [`set_marker(Option<String>)`](crate::client::fluent_builders::ListDistributionsByOriginRequestPolicyId::set_marker): <p>Use this field when paginating results to indicate where to begin in your list of distribution IDs. The response includes distribution IDs in the list that occur after the marker. To get the next page of the list, set this field’s value to the value of <code>NextMarker</code> from the current page’s response.</p>
    ///   - [`max_items(i32)`](crate::client::fluent_builders::ListDistributionsByOriginRequestPolicyId::max_items) / [`set_max_items(Option<i32>)`](crate::client::fluent_builders::ListDistributionsByOriginRequestPolicyId::set_max_items): <p>The maximum number of distribution IDs that you want in the response.</p>
    ///   - [`origin_request_policy_id(impl Into<String>)`](crate::client::fluent_builders::ListDistributionsByOriginRequestPolicyId::origin_request_policy_id) / [`set_origin_request_policy_id(Option<String>)`](crate::client::fluent_builders::ListDistributionsByOriginRequestPolicyId::set_origin_request_policy_id): <p>The ID of the origin request policy whose associated distribution IDs you want to list.</p>
    /// - On success, responds with [`ListDistributionsByOriginRequestPolicyIdOutput`](crate::output::ListDistributionsByOriginRequestPolicyIdOutput) with field(s):
    ///   - [`distribution_id_list(Option<DistributionIdList>)`](crate::output::ListDistributionsByOriginRequestPolicyIdOutput::distribution_id_list): <p>A list of distribution IDs.</p>
    /// - On failure, responds with [`SdkError<ListDistributionsByOriginRequestPolicyIdError>`](crate::error::ListDistributionsByOriginRequestPolicyIdError)
    pub fn list_distributions_by_origin_request_policy_id(
        &self,
    ) -> fluent_builders::ListDistributionsByOriginRequestPolicyId {
        fluent_builders::ListDistributionsByOriginRequestPolicyId::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListDistributionsByRealtimeLogConfig`](crate::client::fluent_builders::ListDistributionsByRealtimeLogConfig) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`marker(impl Into<String>)`](crate::client::fluent_builders::ListDistributionsByRealtimeLogConfig::marker) / [`set_marker(Option<String>)`](crate::client::fluent_builders::ListDistributionsByRealtimeLogConfig::set_marker): <p>Use this field when paginating results to indicate where to begin in your list of distributions. The response includes distributions in the list that occur after the marker. To get the next page of the list, set this field’s value to the value of <code>NextMarker</code> from the current page’s response.</p>
    ///   - [`max_items(i32)`](crate::client::fluent_builders::ListDistributionsByRealtimeLogConfig::max_items) / [`set_max_items(Option<i32>)`](crate::client::fluent_builders::ListDistributionsByRealtimeLogConfig::set_max_items): <p>The maximum number of distributions that you want in the response.</p>
    ///   - [`realtime_log_config_name(impl Into<String>)`](crate::client::fluent_builders::ListDistributionsByRealtimeLogConfig::realtime_log_config_name) / [`set_realtime_log_config_name(Option<String>)`](crate::client::fluent_builders::ListDistributionsByRealtimeLogConfig::set_realtime_log_config_name): <p>The name of the real-time log configuration whose associated distributions you want to list.</p>
    ///   - [`realtime_log_config_arn(impl Into<String>)`](crate::client::fluent_builders::ListDistributionsByRealtimeLogConfig::realtime_log_config_arn) / [`set_realtime_log_config_arn(Option<String>)`](crate::client::fluent_builders::ListDistributionsByRealtimeLogConfig::set_realtime_log_config_arn): <p>The Amazon Resource Name (ARN) of the real-time log configuration whose associated distributions you want to list.</p>
    /// - On success, responds with [`ListDistributionsByRealtimeLogConfigOutput`](crate::output::ListDistributionsByRealtimeLogConfigOutput) with field(s):
    ///   - [`distribution_list(Option<DistributionList>)`](crate::output::ListDistributionsByRealtimeLogConfigOutput::distribution_list): <p>A distribution list.</p>
    /// - On failure, responds with [`SdkError<ListDistributionsByRealtimeLogConfigError>`](crate::error::ListDistributionsByRealtimeLogConfigError)
    pub fn list_distributions_by_realtime_log_config(
        &self,
    ) -> fluent_builders::ListDistributionsByRealtimeLogConfig {
        fluent_builders::ListDistributionsByRealtimeLogConfig::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListDistributionsByResponseHeadersPolicyId`](crate::client::fluent_builders::ListDistributionsByResponseHeadersPolicyId) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`marker(impl Into<String>)`](crate::client::fluent_builders::ListDistributionsByResponseHeadersPolicyId::marker) / [`set_marker(Option<String>)`](crate::client::fluent_builders::ListDistributionsByResponseHeadersPolicyId::set_marker): <p>Use this field when paginating results to indicate where to begin in your list of distribution IDs. The response includes distribution IDs in the list that occur after the marker. To get the next page of the list, set this field’s value to the value of <code>NextMarker</code> from the current page’s response.</p>
    ///   - [`max_items(i32)`](crate::client::fluent_builders::ListDistributionsByResponseHeadersPolicyId::max_items) / [`set_max_items(Option<i32>)`](crate::client::fluent_builders::ListDistributionsByResponseHeadersPolicyId::set_max_items): <p>The maximum number of distribution IDs that you want to get in the response.</p>
    ///   - [`response_headers_policy_id(impl Into<String>)`](crate::client::fluent_builders::ListDistributionsByResponseHeadersPolicyId::response_headers_policy_id) / [`set_response_headers_policy_id(Option<String>)`](crate::client::fluent_builders::ListDistributionsByResponseHeadersPolicyId::set_response_headers_policy_id): <p>The ID of the response headers policy whose associated distribution IDs you want to list.</p>
    /// - On success, responds with [`ListDistributionsByResponseHeadersPolicyIdOutput`](crate::output::ListDistributionsByResponseHeadersPolicyIdOutput) with field(s):
    ///   - [`distribution_id_list(Option<DistributionIdList>)`](crate::output::ListDistributionsByResponseHeadersPolicyIdOutput::distribution_id_list): <p>A list of distribution IDs.</p>
    /// - On failure, responds with [`SdkError<ListDistributionsByResponseHeadersPolicyIdError>`](crate::error::ListDistributionsByResponseHeadersPolicyIdError)
    pub fn list_distributions_by_response_headers_policy_id(
        &self,
    ) -> fluent_builders::ListDistributionsByResponseHeadersPolicyId {
        fluent_builders::ListDistributionsByResponseHeadersPolicyId::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListDistributionsByWebACLId`](crate::client::fluent_builders::ListDistributionsByWebACLId) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`marker(impl Into<String>)`](crate::client::fluent_builders::ListDistributionsByWebACLId::marker) / [`set_marker(Option<String>)`](crate::client::fluent_builders::ListDistributionsByWebACLId::set_marker): <p>Use <code>Marker</code> and <code>MaxItems</code> to control pagination of results. If you have more than <code>MaxItems</code> distributions that satisfy the request, the response includes a <code>NextMarker</code> element. To get the next page of results, submit another request. For the value of <code>Marker</code>, specify the value of <code>NextMarker</code> from the last response. (For the first request, omit <code>Marker</code>.) </p>
    ///   - [`max_items(i32)`](crate::client::fluent_builders::ListDistributionsByWebACLId::max_items) / [`set_max_items(Option<i32>)`](crate::client::fluent_builders::ListDistributionsByWebACLId::set_max_items): <p>The maximum number of distributions that you want CloudFront to return in the response body. The maximum and default values are both 100.</p>
    ///   - [`web_acl_id(impl Into<String>)`](crate::client::fluent_builders::ListDistributionsByWebACLId::web_acl_id) / [`set_web_acl_id(Option<String>)`](crate::client::fluent_builders::ListDistributionsByWebACLId::set_web_acl_id): <p>The ID of the WAF web ACL that you want to list the associated distributions. If you specify "null" for the ID, the request returns a list of the distributions that aren't associated with a web ACL.</p>
    /// - On success, responds with [`ListDistributionsByWebAclIdOutput`](crate::output::ListDistributionsByWebAclIdOutput) with field(s):
    ///   - [`distribution_list(Option<DistributionList>)`](crate::output::ListDistributionsByWebAclIdOutput::distribution_list): <p>The <code>DistributionList</code> type. </p>
    /// - On failure, responds with [`SdkError<ListDistributionsByWebACLIdError>`](crate::error::ListDistributionsByWebACLIdError)
    pub fn list_distributions_by_web_acl_id(&self) -> fluent_builders::ListDistributionsByWebACLId {
        fluent_builders::ListDistributionsByWebACLId::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListFieldLevelEncryptionConfigs`](crate::client::fluent_builders::ListFieldLevelEncryptionConfigs) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`marker(impl Into<String>)`](crate::client::fluent_builders::ListFieldLevelEncryptionConfigs::marker) / [`set_marker(Option<String>)`](crate::client::fluent_builders::ListFieldLevelEncryptionConfigs::set_marker): <p>Use this when paginating results to indicate where to begin in your list of configurations. The results include configurations in the list that occur after the marker. To get the next page of results, set the <code>Marker</code> to the value of the <code>NextMarker</code> from the current page's response (which is also the ID of the last configuration on that page). </p>
    ///   - [`max_items(i32)`](crate::client::fluent_builders::ListFieldLevelEncryptionConfigs::max_items) / [`set_max_items(Option<i32>)`](crate::client::fluent_builders::ListFieldLevelEncryptionConfigs::set_max_items): <p>The maximum number of field-level encryption configurations you want in the response body. </p>
    /// - On success, responds with [`ListFieldLevelEncryptionConfigsOutput`](crate::output::ListFieldLevelEncryptionConfigsOutput) with field(s):
    ///   - [`field_level_encryption_list(Option<FieldLevelEncryptionList>)`](crate::output::ListFieldLevelEncryptionConfigsOutput::field_level_encryption_list): <p>Returns a list of all field-level encryption configurations that have been created in CloudFront for this account.</p>
    /// - On failure, responds with [`SdkError<ListFieldLevelEncryptionConfigsError>`](crate::error::ListFieldLevelEncryptionConfigsError)
    pub fn list_field_level_encryption_configs(
        &self,
    ) -> fluent_builders::ListFieldLevelEncryptionConfigs {
        fluent_builders::ListFieldLevelEncryptionConfigs::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListFieldLevelEncryptionProfiles`](crate::client::fluent_builders::ListFieldLevelEncryptionProfiles) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`marker(impl Into<String>)`](crate::client::fluent_builders::ListFieldLevelEncryptionProfiles::marker) / [`set_marker(Option<String>)`](crate::client::fluent_builders::ListFieldLevelEncryptionProfiles::set_marker): <p>Use this when paginating results to indicate where to begin in your list of profiles. The results include profiles in the list that occur after the marker. To get the next page of results, set the <code>Marker</code> to the value of the <code>NextMarker</code> from the current page's response (which is also the ID of the last profile on that page). </p>
    ///   - [`max_items(i32)`](crate::client::fluent_builders::ListFieldLevelEncryptionProfiles::max_items) / [`set_max_items(Option<i32>)`](crate::client::fluent_builders::ListFieldLevelEncryptionProfiles::set_max_items): <p>The maximum number of field-level encryption profiles you want in the response body. </p>
    /// - On success, responds with [`ListFieldLevelEncryptionProfilesOutput`](crate::output::ListFieldLevelEncryptionProfilesOutput) with field(s):
    ///   - [`field_level_encryption_profile_list(Option<FieldLevelEncryptionProfileList>)`](crate::output::ListFieldLevelEncryptionProfilesOutput::field_level_encryption_profile_list): <p>Returns a list of the field-level encryption profiles that have been created in CloudFront for this account.</p>
    /// - On failure, responds with [`SdkError<ListFieldLevelEncryptionProfilesError>`](crate::error::ListFieldLevelEncryptionProfilesError)
    pub fn list_field_level_encryption_profiles(
        &self,
    ) -> fluent_builders::ListFieldLevelEncryptionProfiles {
        fluent_builders::ListFieldLevelEncryptionProfiles::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListFunctions`](crate::client::fluent_builders::ListFunctions) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`marker(impl Into<String>)`](crate::client::fluent_builders::ListFunctions::marker) / [`set_marker(Option<String>)`](crate::client::fluent_builders::ListFunctions::set_marker): <p>Use this field when paginating results to indicate where to begin in your list of functions. The response includes functions in the list that occur after the marker. To get the next page of the list, set this field’s value to the value of <code>NextMarker</code> from the current page’s response.</p>
    ///   - [`max_items(i32)`](crate::client::fluent_builders::ListFunctions::max_items) / [`set_max_items(Option<i32>)`](crate::client::fluent_builders::ListFunctions::set_max_items): <p>The maximum number of functions that you want in the response.</p>
    ///   - [`stage(FunctionStage)`](crate::client::fluent_builders::ListFunctions::stage) / [`set_stage(Option<FunctionStage>)`](crate::client::fluent_builders::ListFunctions::set_stage): <p>An optional filter to return only the functions that are in the specified stage, either <code>DEVELOPMENT</code> or <code>LIVE</code>.</p>
    /// - On success, responds with [`ListFunctionsOutput`](crate::output::ListFunctionsOutput) with field(s):
    ///   - [`function_list(Option<FunctionList>)`](crate::output::ListFunctionsOutput::function_list): <p>A list of CloudFront functions.</p>
    /// - On failure, responds with [`SdkError<ListFunctionsError>`](crate::error::ListFunctionsError)
    pub fn list_functions(&self) -> fluent_builders::ListFunctions {
        fluent_builders::ListFunctions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListInvalidations`](crate::client::fluent_builders::ListInvalidations) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListInvalidations::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`distribution_id(impl Into<String>)`](crate::client::fluent_builders::ListInvalidations::distribution_id) / [`set_distribution_id(Option<String>)`](crate::client::fluent_builders::ListInvalidations::set_distribution_id): <p>The distribution's ID.</p>
    ///   - [`marker(impl Into<String>)`](crate::client::fluent_builders::ListInvalidations::marker) / [`set_marker(Option<String>)`](crate::client::fluent_builders::ListInvalidations::set_marker): <p>Use this parameter when paginating results to indicate where to begin in your list of invalidation batches. Because the results are returned in decreasing order from most recent to oldest, the most recent results are on the first page, the second page will contain earlier results, and so on. To get the next page of results, set <code>Marker</code> to the value of the <code>NextMarker</code> from the current page's response. This value is the same as the ID of the last invalidation batch on that page. </p>
    ///   - [`max_items(i32)`](crate::client::fluent_builders::ListInvalidations::max_items) / [`set_max_items(Option<i32>)`](crate::client::fluent_builders::ListInvalidations::set_max_items): <p>The maximum number of invalidation batches that you want in the response body.</p>
    /// - On success, responds with [`ListInvalidationsOutput`](crate::output::ListInvalidationsOutput) with field(s):
    ///   - [`invalidation_list(Option<InvalidationList>)`](crate::output::ListInvalidationsOutput::invalidation_list): <p>Information about invalidation batches. </p>
    /// - On failure, responds with [`SdkError<ListInvalidationsError>`](crate::error::ListInvalidationsError)
    pub fn list_invalidations(&self) -> fluent_builders::ListInvalidations {
        fluent_builders::ListInvalidations::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListKeyGroups`](crate::client::fluent_builders::ListKeyGroups) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`marker(impl Into<String>)`](crate::client::fluent_builders::ListKeyGroups::marker) / [`set_marker(Option<String>)`](crate::client::fluent_builders::ListKeyGroups::set_marker): <p>Use this field when paginating results to indicate where to begin in your list of key groups. The response includes key groups in the list that occur after the marker. To get the next page of the list, set this field’s value to the value of <code>NextMarker</code> from the current page’s response.</p>
    ///   - [`max_items(i32)`](crate::client::fluent_builders::ListKeyGroups::max_items) / [`set_max_items(Option<i32>)`](crate::client::fluent_builders::ListKeyGroups::set_max_items): <p>The maximum number of key groups that you want in the response.</p>
    /// - On success, responds with [`ListKeyGroupsOutput`](crate::output::ListKeyGroupsOutput) with field(s):
    ///   - [`key_group_list(Option<KeyGroupList>)`](crate::output::ListKeyGroupsOutput::key_group_list): <p>A list of key groups.</p>
    /// - On failure, responds with [`SdkError<ListKeyGroupsError>`](crate::error::ListKeyGroupsError)
    pub fn list_key_groups(&self) -> fluent_builders::ListKeyGroups {
        fluent_builders::ListKeyGroups::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListOriginRequestPolicies`](crate::client::fluent_builders::ListOriginRequestPolicies) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`r#type(OriginRequestPolicyType)`](crate::client::fluent_builders::ListOriginRequestPolicies::type) / [`set_type(Option<OriginRequestPolicyType>)`](crate::client::fluent_builders::ListOriginRequestPolicies::set_type): <p>A filter to return only the specified kinds of origin request policies. Valid values are:</p>  <ul>   <li> <p> <code>managed</code> – Returns only the managed policies created by Amazon Web Services.</p> </li>   <li> <p> <code>custom</code> – Returns only the custom policies created in your Amazon Web Services account.</p> </li>  </ul>
    ///   - [`marker(impl Into<String>)`](crate::client::fluent_builders::ListOriginRequestPolicies::marker) / [`set_marker(Option<String>)`](crate::client::fluent_builders::ListOriginRequestPolicies::set_marker): <p>Use this field when paginating results to indicate where to begin in your list of origin request policies. The response includes origin request policies in the list that occur after the marker. To get the next page of the list, set this field’s value to the value of <code>NextMarker</code> from the current page’s response.</p>
    ///   - [`max_items(i32)`](crate::client::fluent_builders::ListOriginRequestPolicies::max_items) / [`set_max_items(Option<i32>)`](crate::client::fluent_builders::ListOriginRequestPolicies::set_max_items): <p>The maximum number of origin request policies that you want in the response.</p>
    /// - On success, responds with [`ListOriginRequestPoliciesOutput`](crate::output::ListOriginRequestPoliciesOutput) with field(s):
    ///   - [`origin_request_policy_list(Option<OriginRequestPolicyList>)`](crate::output::ListOriginRequestPoliciesOutput::origin_request_policy_list): <p>A list of origin request policies.</p>
    /// - On failure, responds with [`SdkError<ListOriginRequestPoliciesError>`](crate::error::ListOriginRequestPoliciesError)
    pub fn list_origin_request_policies(&self) -> fluent_builders::ListOriginRequestPolicies {
        fluent_builders::ListOriginRequestPolicies::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListPublicKeys`](crate::client::fluent_builders::ListPublicKeys) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`marker(impl Into<String>)`](crate::client::fluent_builders::ListPublicKeys::marker) / [`set_marker(Option<String>)`](crate::client::fluent_builders::ListPublicKeys::set_marker): <p>Use this when paginating results to indicate where to begin in your list of public keys. The results include public keys in the list that occur after the marker. To get the next page of results, set the <code>Marker</code> to the value of the <code>NextMarker</code> from the current page's response (which is also the ID of the last public key on that page). </p>
    ///   - [`max_items(i32)`](crate::client::fluent_builders::ListPublicKeys::max_items) / [`set_max_items(Option<i32>)`](crate::client::fluent_builders::ListPublicKeys::set_max_items): <p>The maximum number of public keys you want in the response body. </p>
    /// - On success, responds with [`ListPublicKeysOutput`](crate::output::ListPublicKeysOutput) with field(s):
    ///   - [`public_key_list(Option<PublicKeyList>)`](crate::output::ListPublicKeysOutput::public_key_list): <p>Returns a list of all public keys that have been added to CloudFront for this account.</p>
    /// - On failure, responds with [`SdkError<ListPublicKeysError>`](crate::error::ListPublicKeysError)
    pub fn list_public_keys(&self) -> fluent_builders::ListPublicKeys {
        fluent_builders::ListPublicKeys::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListRealtimeLogConfigs`](crate::client::fluent_builders::ListRealtimeLogConfigs) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`max_items(i32)`](crate::client::fluent_builders::ListRealtimeLogConfigs::max_items) / [`set_max_items(Option<i32>)`](crate::client::fluent_builders::ListRealtimeLogConfigs::set_max_items): <p>The maximum number of real-time log configurations that you want in the response.</p>
    ///   - [`marker(impl Into<String>)`](crate::client::fluent_builders::ListRealtimeLogConfigs::marker) / [`set_marker(Option<String>)`](crate::client::fluent_builders::ListRealtimeLogConfigs::set_marker): <p>Use this field when paginating results to indicate where to begin in your list of real-time log configurations. The response includes real-time log configurations in the list that occur after the marker. To get the next page of the list, set this field’s value to the value of <code>NextMarker</code> from the current page’s response.</p>
    /// - On success, responds with [`ListRealtimeLogConfigsOutput`](crate::output::ListRealtimeLogConfigsOutput) with field(s):
    ///   - [`realtime_log_configs(Option<RealtimeLogConfigs>)`](crate::output::ListRealtimeLogConfigsOutput::realtime_log_configs): <p>A list of real-time log configurations.</p>
    /// - On failure, responds with [`SdkError<ListRealtimeLogConfigsError>`](crate::error::ListRealtimeLogConfigsError)
    pub fn list_realtime_log_configs(&self) -> fluent_builders::ListRealtimeLogConfigs {
        fluent_builders::ListRealtimeLogConfigs::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListResponseHeadersPolicies`](crate::client::fluent_builders::ListResponseHeadersPolicies) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`r#type(ResponseHeadersPolicyType)`](crate::client::fluent_builders::ListResponseHeadersPolicies::type) / [`set_type(Option<ResponseHeadersPolicyType>)`](crate::client::fluent_builders::ListResponseHeadersPolicies::set_type): <p>A filter to get only the specified kind of response headers policies. Valid values are:</p>  <ul>   <li> <p> <code>managed</code> – Gets only the managed policies created by Amazon Web Services.</p> </li>   <li> <p> <code>custom</code> – Gets only the custom policies created in your Amazon Web Services account.</p> </li>  </ul>
    ///   - [`marker(impl Into<String>)`](crate::client::fluent_builders::ListResponseHeadersPolicies::marker) / [`set_marker(Option<String>)`](crate::client::fluent_builders::ListResponseHeadersPolicies::set_marker): <p>Use this field when paginating results to indicate where to begin in your list of response headers policies. The response includes response headers policies in the list that occur after the marker. To get the next page of the list, set this field’s value to the value of <code>NextMarker</code> from the current page’s response. </p>
    ///   - [`max_items(i32)`](crate::client::fluent_builders::ListResponseHeadersPolicies::max_items) / [`set_max_items(Option<i32>)`](crate::client::fluent_builders::ListResponseHeadersPolicies::set_max_items): <p>The maximum number of response headers policies that you want to get in the response.</p>
    /// - On success, responds with [`ListResponseHeadersPoliciesOutput`](crate::output::ListResponseHeadersPoliciesOutput) with field(s):
    ///   - [`response_headers_policy_list(Option<ResponseHeadersPolicyList>)`](crate::output::ListResponseHeadersPoliciesOutput::response_headers_policy_list): <p>A list of response headers policies.</p>
    /// - On failure, responds with [`SdkError<ListResponseHeadersPoliciesError>`](crate::error::ListResponseHeadersPoliciesError)
    pub fn list_response_headers_policies(&self) -> fluent_builders::ListResponseHeadersPolicies {
        fluent_builders::ListResponseHeadersPolicies::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListStreamingDistributions`](crate::client::fluent_builders::ListStreamingDistributions) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListStreamingDistributions::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`marker(impl Into<String>)`](crate::client::fluent_builders::ListStreamingDistributions::marker) / [`set_marker(Option<String>)`](crate::client::fluent_builders::ListStreamingDistributions::set_marker): <p>The value that you provided for the <code>Marker</code> request parameter.</p>
    ///   - [`max_items(i32)`](crate::client::fluent_builders::ListStreamingDistributions::max_items) / [`set_max_items(Option<i32>)`](crate::client::fluent_builders::ListStreamingDistributions::set_max_items): <p>The value that you provided for the <code>MaxItems</code> request parameter.</p>
    /// - On success, responds with [`ListStreamingDistributionsOutput`](crate::output::ListStreamingDistributionsOutput) with field(s):
    ///   - [`streaming_distribution_list(Option<StreamingDistributionList>)`](crate::output::ListStreamingDistributionsOutput::streaming_distribution_list): <p>The <code>StreamingDistributionList</code> type. </p>
    /// - On failure, responds with [`SdkError<ListStreamingDistributionsError>`](crate::error::ListStreamingDistributionsError)
    pub fn list_streaming_distributions(&self) -> fluent_builders::ListStreamingDistributions {
        fluent_builders::ListStreamingDistributions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListTagsForResource`](crate::client::fluent_builders::ListTagsForResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource(impl Into<String>)`](crate::client::fluent_builders::ListTagsForResource::resource) / [`set_resource(Option<String>)`](crate::client::fluent_builders::ListTagsForResource::set_resource): <p> An ARN of a CloudFront resource.</p>
    /// - On success, responds with [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput) with field(s):
    ///   - [`tags(Option<Tags>)`](crate::output::ListTagsForResourceOutput::tags): <p> A complex type that contains zero or more <code>Tag</code> elements.</p>
    /// - On failure, responds with [`SdkError<ListTagsForResourceError>`](crate::error::ListTagsForResourceError)
    pub fn list_tags_for_resource(&self) -> fluent_builders::ListTagsForResource {
        fluent_builders::ListTagsForResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`PublishFunction`](crate::client::fluent_builders::PublishFunction) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::PublishFunction::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::PublishFunction::set_name): <p>The name of the function that you are publishing.</p>
    ///   - [`if_match(impl Into<String>)`](crate::client::fluent_builders::PublishFunction::if_match) / [`set_if_match(Option<String>)`](crate::client::fluent_builders::PublishFunction::set_if_match): <p>The current version (<code>ETag</code> value) of the function that you are publishing, which you can get using <code>DescribeFunction</code>.</p>
    /// - On success, responds with [`PublishFunctionOutput`](crate::output::PublishFunctionOutput) with field(s):
    ///   - [`function_summary(Option<FunctionSummary>)`](crate::output::PublishFunctionOutput::function_summary): <p>Contains configuration information and metadata about a CloudFront function.</p>
    /// - On failure, responds with [`SdkError<PublishFunctionError>`](crate::error::PublishFunctionError)
    pub fn publish_function(&self) -> fluent_builders::PublishFunction {
        fluent_builders::PublishFunction::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`TagResource`](crate::client::fluent_builders::TagResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource(impl Into<String>)`](crate::client::fluent_builders::TagResource::resource) / [`set_resource(Option<String>)`](crate::client::fluent_builders::TagResource::set_resource): <p> An ARN of a CloudFront resource.</p>
    ///   - [`tags(Tags)`](crate::client::fluent_builders::TagResource::tags) / [`set_tags(Option<Tags>)`](crate::client::fluent_builders::TagResource::set_tags): <p> A complex type that contains zero or more <code>Tag</code> elements.</p>
    /// - On success, responds with [`TagResourceOutput`](crate::output::TagResourceOutput)

    /// - On failure, responds with [`SdkError<TagResourceError>`](crate::error::TagResourceError)
    pub fn tag_resource(&self) -> fluent_builders::TagResource {
        fluent_builders::TagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`TestFunction`](crate::client::fluent_builders::TestFunction) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::TestFunction::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::TestFunction::set_name): <p>The name of the function that you are testing.</p>
    ///   - [`if_match(impl Into<String>)`](crate::client::fluent_builders::TestFunction::if_match) / [`set_if_match(Option<String>)`](crate::client::fluent_builders::TestFunction::set_if_match): <p>The current version (<code>ETag</code> value) of the function that you are testing, which you can get using <code>DescribeFunction</code>.</p>
    ///   - [`stage(FunctionStage)`](crate::client::fluent_builders::TestFunction::stage) / [`set_stage(Option<FunctionStage>)`](crate::client::fluent_builders::TestFunction::set_stage): <p>The stage of the function that you are testing, either <code>DEVELOPMENT</code> or <code>LIVE</code>.</p>
    ///   - [`event_object(Blob)`](crate::client::fluent_builders::TestFunction::event_object) / [`set_event_object(Option<Blob>)`](crate::client::fluent_builders::TestFunction::set_event_object): <p>The event object to test the function with. For more information about the structure of the event object, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/managing-functions.html#test-function">Testing functions</a> in the <i>Amazon CloudFront Developer Guide</i>.</p>
    /// - On success, responds with [`TestFunctionOutput`](crate::output::TestFunctionOutput) with field(s):
    ///   - [`test_result(Option<TestResult>)`](crate::output::TestFunctionOutput::test_result): <p>An object that represents the result of running the function with the provided event object.</p>
    /// - On failure, responds with [`SdkError<TestFunctionError>`](crate::error::TestFunctionError)
    pub fn test_function(&self) -> fluent_builders::TestFunction {
        fluent_builders::TestFunction::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UntagResource`](crate::client::fluent_builders::UntagResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource(impl Into<String>)`](crate::client::fluent_builders::UntagResource::resource) / [`set_resource(Option<String>)`](crate::client::fluent_builders::UntagResource::set_resource): <p> An ARN of a CloudFront resource.</p>
    ///   - [`tag_keys(TagKeys)`](crate::client::fluent_builders::UntagResource::tag_keys) / [`set_tag_keys(Option<TagKeys>)`](crate::client::fluent_builders::UntagResource::set_tag_keys): <p> A complex type that contains zero or more <code>Tag</code> key elements.</p>
    /// - On success, responds with [`UntagResourceOutput`](crate::output::UntagResourceOutput)

    /// - On failure, responds with [`SdkError<UntagResourceError>`](crate::error::UntagResourceError)
    pub fn untag_resource(&self) -> fluent_builders::UntagResource {
        fluent_builders::UntagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateCachePolicy`](crate::client::fluent_builders::UpdateCachePolicy) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`cache_policy_config(CachePolicyConfig)`](crate::client::fluent_builders::UpdateCachePolicy::cache_policy_config) / [`set_cache_policy_config(Option<CachePolicyConfig>)`](crate::client::fluent_builders::UpdateCachePolicy::set_cache_policy_config): <p>A cache policy configuration.</p>
    ///   - [`id(impl Into<String>)`](crate::client::fluent_builders::UpdateCachePolicy::id) / [`set_id(Option<String>)`](crate::client::fluent_builders::UpdateCachePolicy::set_id): <p>The unique identifier for the cache policy that you are updating. The identifier is returned in a cache behavior’s <code>CachePolicyId</code> field in the response to <code>GetDistributionConfig</code>.</p>
    ///   - [`if_match(impl Into<String>)`](crate::client::fluent_builders::UpdateCachePolicy::if_match) / [`set_if_match(Option<String>)`](crate::client::fluent_builders::UpdateCachePolicy::set_if_match): <p>The version of the cache policy that you are updating. The version is returned in the cache policy’s <code>ETag</code> field in the response to <code>GetCachePolicyConfig</code>.</p>
    /// - On success, responds with [`UpdateCachePolicyOutput`](crate::output::UpdateCachePolicyOutput) with field(s):
    ///   - [`cache_policy(Option<CachePolicy>)`](crate::output::UpdateCachePolicyOutput::cache_policy): <p>A cache policy.</p>
    ///   - [`e_tag(Option<String>)`](crate::output::UpdateCachePolicyOutput::e_tag): <p>The current version of the cache policy.</p>
    /// - On failure, responds with [`SdkError<UpdateCachePolicyError>`](crate::error::UpdateCachePolicyError)
    pub fn update_cache_policy(&self) -> fluent_builders::UpdateCachePolicy {
        fluent_builders::UpdateCachePolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateCloudFrontOriginAccessIdentity`](crate::client::fluent_builders::UpdateCloudFrontOriginAccessIdentity) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`cloud_front_origin_access_identity_config(CloudFrontOriginAccessIdentityConfig)`](crate::client::fluent_builders::UpdateCloudFrontOriginAccessIdentity::cloud_front_origin_access_identity_config) / [`set_cloud_front_origin_access_identity_config(Option<CloudFrontOriginAccessIdentityConfig>)`](crate::client::fluent_builders::UpdateCloudFrontOriginAccessIdentity::set_cloud_front_origin_access_identity_config): <p>The identity's configuration information.</p>
    ///   - [`id(impl Into<String>)`](crate::client::fluent_builders::UpdateCloudFrontOriginAccessIdentity::id) / [`set_id(Option<String>)`](crate::client::fluent_builders::UpdateCloudFrontOriginAccessIdentity::set_id): <p>The identity's id.</p>
    ///   - [`if_match(impl Into<String>)`](crate::client::fluent_builders::UpdateCloudFrontOriginAccessIdentity::if_match) / [`set_if_match(Option<String>)`](crate::client::fluent_builders::UpdateCloudFrontOriginAccessIdentity::set_if_match): <p>The value of the <code>ETag</code> header that you received when retrieving the identity's configuration. For example: <code>E2QWRUHAPOMQZL</code>.</p>
    /// - On success, responds with [`UpdateCloudFrontOriginAccessIdentityOutput`](crate::output::UpdateCloudFrontOriginAccessIdentityOutput) with field(s):
    ///   - [`cloud_front_origin_access_identity(Option<CloudFrontOriginAccessIdentity>)`](crate::output::UpdateCloudFrontOriginAccessIdentityOutput::cloud_front_origin_access_identity): <p>The origin access identity's information.</p>
    ///   - [`e_tag(Option<String>)`](crate::output::UpdateCloudFrontOriginAccessIdentityOutput::e_tag): <p>The current version of the configuration. For example: <code>E2QWRUHAPOMQZL</code>.</p>
    /// - On failure, responds with [`SdkError<UpdateCloudFrontOriginAccessIdentityError>`](crate::error::UpdateCloudFrontOriginAccessIdentityError)
    pub fn update_cloud_front_origin_access_identity(
        &self,
    ) -> fluent_builders::UpdateCloudFrontOriginAccessIdentity {
        fluent_builders::UpdateCloudFrontOriginAccessIdentity::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateDistribution`](crate::client::fluent_builders::UpdateDistribution) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`distribution_config(DistributionConfig)`](crate::client::fluent_builders::UpdateDistribution::distribution_config) / [`set_distribution_config(Option<DistributionConfig>)`](crate::client::fluent_builders::UpdateDistribution::set_distribution_config): <p>The distribution's configuration information.</p>
    ///   - [`id(impl Into<String>)`](crate::client::fluent_builders::UpdateDistribution::id) / [`set_id(Option<String>)`](crate::client::fluent_builders::UpdateDistribution::set_id): <p>The distribution's id.</p>
    ///   - [`if_match(impl Into<String>)`](crate::client::fluent_builders::UpdateDistribution::if_match) / [`set_if_match(Option<String>)`](crate::client::fluent_builders::UpdateDistribution::set_if_match): <p>The value of the <code>ETag</code> header that you received when retrieving the distribution's configuration. For example: <code>E2QWRUHAPOMQZL</code>.</p>
    /// - On success, responds with [`UpdateDistributionOutput`](crate::output::UpdateDistributionOutput) with field(s):
    ///   - [`distribution(Option<Distribution>)`](crate::output::UpdateDistributionOutput::distribution): <p>The distribution's information.</p>
    ///   - [`e_tag(Option<String>)`](crate::output::UpdateDistributionOutput::e_tag): <p>The current version of the configuration. For example: <code>E2QWRUHAPOMQZL</code>.</p>
    /// - On failure, responds with [`SdkError<UpdateDistributionError>`](crate::error::UpdateDistributionError)
    pub fn update_distribution(&self) -> fluent_builders::UpdateDistribution {
        fluent_builders::UpdateDistribution::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateFieldLevelEncryptionConfig`](crate::client::fluent_builders::UpdateFieldLevelEncryptionConfig) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`field_level_encryption_config(FieldLevelEncryptionConfig)`](crate::client::fluent_builders::UpdateFieldLevelEncryptionConfig::field_level_encryption_config) / [`set_field_level_encryption_config(Option<FieldLevelEncryptionConfig>)`](crate::client::fluent_builders::UpdateFieldLevelEncryptionConfig::set_field_level_encryption_config): <p>Request to update a field-level encryption configuration. </p>
    ///   - [`id(impl Into<String>)`](crate::client::fluent_builders::UpdateFieldLevelEncryptionConfig::id) / [`set_id(Option<String>)`](crate::client::fluent_builders::UpdateFieldLevelEncryptionConfig::set_id): <p>The ID of the configuration you want to update.</p>
    ///   - [`if_match(impl Into<String>)`](crate::client::fluent_builders::UpdateFieldLevelEncryptionConfig::if_match) / [`set_if_match(Option<String>)`](crate::client::fluent_builders::UpdateFieldLevelEncryptionConfig::set_if_match): <p>The value of the <code>ETag</code> header that you received when retrieving the configuration identity to update. For example: <code>E2QWRUHAPOMQZL</code>.</p>
    /// - On success, responds with [`UpdateFieldLevelEncryptionConfigOutput`](crate::output::UpdateFieldLevelEncryptionConfigOutput) with field(s):
    ///   - [`field_level_encryption(Option<FieldLevelEncryption>)`](crate::output::UpdateFieldLevelEncryptionConfigOutput::field_level_encryption): <p>Return the results of updating the configuration.</p>
    ///   - [`e_tag(Option<String>)`](crate::output::UpdateFieldLevelEncryptionConfigOutput::e_tag): <p>The value of the <code>ETag</code> header that you received when updating the configuration. For example: <code>E2QWRUHAPOMQZL</code>.</p>
    /// - On failure, responds with [`SdkError<UpdateFieldLevelEncryptionConfigError>`](crate::error::UpdateFieldLevelEncryptionConfigError)
    pub fn update_field_level_encryption_config(
        &self,
    ) -> fluent_builders::UpdateFieldLevelEncryptionConfig {
        fluent_builders::UpdateFieldLevelEncryptionConfig::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateFieldLevelEncryptionProfile`](crate::client::fluent_builders::UpdateFieldLevelEncryptionProfile) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`field_level_encryption_profile_config(FieldLevelEncryptionProfileConfig)`](crate::client::fluent_builders::UpdateFieldLevelEncryptionProfile::field_level_encryption_profile_config) / [`set_field_level_encryption_profile_config(Option<FieldLevelEncryptionProfileConfig>)`](crate::client::fluent_builders::UpdateFieldLevelEncryptionProfile::set_field_level_encryption_profile_config): <p>Request to update a field-level encryption profile. </p>
    ///   - [`id(impl Into<String>)`](crate::client::fluent_builders::UpdateFieldLevelEncryptionProfile::id) / [`set_id(Option<String>)`](crate::client::fluent_builders::UpdateFieldLevelEncryptionProfile::set_id): <p>The ID of the field-level encryption profile request. </p>
    ///   - [`if_match(impl Into<String>)`](crate::client::fluent_builders::UpdateFieldLevelEncryptionProfile::if_match) / [`set_if_match(Option<String>)`](crate::client::fluent_builders::UpdateFieldLevelEncryptionProfile::set_if_match): <p>The value of the <code>ETag</code> header that you received when retrieving the profile identity to update. For example: <code>E2QWRUHAPOMQZL</code>.</p>
    /// - On success, responds with [`UpdateFieldLevelEncryptionProfileOutput`](crate::output::UpdateFieldLevelEncryptionProfileOutput) with field(s):
    ///   - [`field_level_encryption_profile(Option<FieldLevelEncryptionProfile>)`](crate::output::UpdateFieldLevelEncryptionProfileOutput::field_level_encryption_profile): <p>Return the results of updating the profile.</p>
    ///   - [`e_tag(Option<String>)`](crate::output::UpdateFieldLevelEncryptionProfileOutput::e_tag): <p>The result of the field-level encryption profile request. </p>
    /// - On failure, responds with [`SdkError<UpdateFieldLevelEncryptionProfileError>`](crate::error::UpdateFieldLevelEncryptionProfileError)
    pub fn update_field_level_encryption_profile(
        &self,
    ) -> fluent_builders::UpdateFieldLevelEncryptionProfile {
        fluent_builders::UpdateFieldLevelEncryptionProfile::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateFunction`](crate::client::fluent_builders::UpdateFunction) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::UpdateFunction::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::UpdateFunction::set_name): <p>The name of the function that you are updating.</p>
    ///   - [`if_match(impl Into<String>)`](crate::client::fluent_builders::UpdateFunction::if_match) / [`set_if_match(Option<String>)`](crate::client::fluent_builders::UpdateFunction::set_if_match): <p>The current version (<code>ETag</code> value) of the function that you are updating, which you can get using <code>DescribeFunction</code>.</p>
    ///   - [`function_config(FunctionConfig)`](crate::client::fluent_builders::UpdateFunction::function_config) / [`set_function_config(Option<FunctionConfig>)`](crate::client::fluent_builders::UpdateFunction::set_function_config): <p>Configuration information about the function.</p>
    ///   - [`function_code(Blob)`](crate::client::fluent_builders::UpdateFunction::function_code) / [`set_function_code(Option<Blob>)`](crate::client::fluent_builders::UpdateFunction::set_function_code): <p>The function code. For more information about writing a CloudFront function, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/writing-function-code.html">Writing function code for CloudFront Functions</a> in the <i>Amazon CloudFront Developer Guide</i>.</p>
    /// - On success, responds with [`UpdateFunctionOutput`](crate::output::UpdateFunctionOutput) with field(s):
    ///   - [`function_summary(Option<FunctionSummary>)`](crate::output::UpdateFunctionOutput::function_summary): <p>Contains configuration information and metadata about a CloudFront function.</p>
    ///   - [`e_tag(Option<String>)`](crate::output::UpdateFunctionOutput::e_tag): <p>The version identifier for the current version of the CloudFront function.</p>
    /// - On failure, responds with [`SdkError<UpdateFunctionError>`](crate::error::UpdateFunctionError)
    pub fn update_function(&self) -> fluent_builders::UpdateFunction {
        fluent_builders::UpdateFunction::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateKeyGroup`](crate::client::fluent_builders::UpdateKeyGroup) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`key_group_config(KeyGroupConfig)`](crate::client::fluent_builders::UpdateKeyGroup::key_group_config) / [`set_key_group_config(Option<KeyGroupConfig>)`](crate::client::fluent_builders::UpdateKeyGroup::set_key_group_config): <p>The key group configuration.</p>
    ///   - [`id(impl Into<String>)`](crate::client::fluent_builders::UpdateKeyGroup::id) / [`set_id(Option<String>)`](crate::client::fluent_builders::UpdateKeyGroup::set_id): <p>The identifier of the key group that you are updating.</p>
    ///   - [`if_match(impl Into<String>)`](crate::client::fluent_builders::UpdateKeyGroup::if_match) / [`set_if_match(Option<String>)`](crate::client::fluent_builders::UpdateKeyGroup::set_if_match): <p>The version of the key group that you are updating. The version is the key group’s <code>ETag</code> value.</p>
    /// - On success, responds with [`UpdateKeyGroupOutput`](crate::output::UpdateKeyGroupOutput) with field(s):
    ///   - [`key_group(Option<KeyGroup>)`](crate::output::UpdateKeyGroupOutput::key_group): <p>The key group that was just updated.</p>
    ///   - [`e_tag(Option<String>)`](crate::output::UpdateKeyGroupOutput::e_tag): <p>The identifier for this version of the key group.</p>
    /// - On failure, responds with [`SdkError<UpdateKeyGroupError>`](crate::error::UpdateKeyGroupError)
    pub fn update_key_group(&self) -> fluent_builders::UpdateKeyGroup {
        fluent_builders::UpdateKeyGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateOriginRequestPolicy`](crate::client::fluent_builders::UpdateOriginRequestPolicy) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`origin_request_policy_config(OriginRequestPolicyConfig)`](crate::client::fluent_builders::UpdateOriginRequestPolicy::origin_request_policy_config) / [`set_origin_request_policy_config(Option<OriginRequestPolicyConfig>)`](crate::client::fluent_builders::UpdateOriginRequestPolicy::set_origin_request_policy_config): <p>An origin request policy configuration.</p>
    ///   - [`id(impl Into<String>)`](crate::client::fluent_builders::UpdateOriginRequestPolicy::id) / [`set_id(Option<String>)`](crate::client::fluent_builders::UpdateOriginRequestPolicy::set_id): <p>The unique identifier for the origin request policy that you are updating. The identifier is returned in a cache behavior’s <code>OriginRequestPolicyId</code> field in the response to <code>GetDistributionConfig</code>.</p>
    ///   - [`if_match(impl Into<String>)`](crate::client::fluent_builders::UpdateOriginRequestPolicy::if_match) / [`set_if_match(Option<String>)`](crate::client::fluent_builders::UpdateOriginRequestPolicy::set_if_match): <p>The version of the origin request policy that you are updating. The version is returned in the origin request policy’s <code>ETag</code> field in the response to <code>GetOriginRequestPolicyConfig</code>.</p>
    /// - On success, responds with [`UpdateOriginRequestPolicyOutput`](crate::output::UpdateOriginRequestPolicyOutput) with field(s):
    ///   - [`origin_request_policy(Option<OriginRequestPolicy>)`](crate::output::UpdateOriginRequestPolicyOutput::origin_request_policy): <p>An origin request policy.</p>
    ///   - [`e_tag(Option<String>)`](crate::output::UpdateOriginRequestPolicyOutput::e_tag): <p>The current version of the origin request policy.</p>
    /// - On failure, responds with [`SdkError<UpdateOriginRequestPolicyError>`](crate::error::UpdateOriginRequestPolicyError)
    pub fn update_origin_request_policy(&self) -> fluent_builders::UpdateOriginRequestPolicy {
        fluent_builders::UpdateOriginRequestPolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdatePublicKey`](crate::client::fluent_builders::UpdatePublicKey) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`public_key_config(PublicKeyConfig)`](crate::client::fluent_builders::UpdatePublicKey::public_key_config) / [`set_public_key_config(Option<PublicKeyConfig>)`](crate::client::fluent_builders::UpdatePublicKey::set_public_key_config): <p>A public key configuration.</p>
    ///   - [`id(impl Into<String>)`](crate::client::fluent_builders::UpdatePublicKey::id) / [`set_id(Option<String>)`](crate::client::fluent_builders::UpdatePublicKey::set_id): <p>The identifier of the public key that you are updating.</p>
    ///   - [`if_match(impl Into<String>)`](crate::client::fluent_builders::UpdatePublicKey::if_match) / [`set_if_match(Option<String>)`](crate::client::fluent_builders::UpdatePublicKey::set_if_match): <p>The value of the <code>ETag</code> header that you received when retrieving the public key to update. For example: <code>E2QWRUHAPOMQZL</code>.</p>
    /// - On success, responds with [`UpdatePublicKeyOutput`](crate::output::UpdatePublicKeyOutput) with field(s):
    ///   - [`public_key(Option<PublicKey>)`](crate::output::UpdatePublicKeyOutput::public_key): <p>The public key.</p>
    ///   - [`e_tag(Option<String>)`](crate::output::UpdatePublicKeyOutput::e_tag): <p>The identifier of the current version of the public key.</p>
    /// - On failure, responds with [`SdkError<UpdatePublicKeyError>`](crate::error::UpdatePublicKeyError)
    pub fn update_public_key(&self) -> fluent_builders::UpdatePublicKey {
        fluent_builders::UpdatePublicKey::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateRealtimeLogConfig`](crate::client::fluent_builders::UpdateRealtimeLogConfig) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`end_points(Vec<EndPoint>)`](crate::client::fluent_builders::UpdateRealtimeLogConfig::end_points) / [`set_end_points(Option<Vec<EndPoint>>)`](crate::client::fluent_builders::UpdateRealtimeLogConfig::set_end_points): <p>Contains information about the Amazon Kinesis data stream where you are sending real-time log data.</p>
    ///   - [`fields(Vec<String>)`](crate::client::fluent_builders::UpdateRealtimeLogConfig::fields) / [`set_fields(Option<Vec<String>>)`](crate::client::fluent_builders::UpdateRealtimeLogConfig::set_fields): <p>A list of fields to include in each real-time log record.</p>  <p>For more information about fields, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/real-time-logs.html#understand-real-time-log-config-fields">Real-time log configuration fields</a> in the <i>Amazon CloudFront Developer Guide</i>.</p>
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::UpdateRealtimeLogConfig::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::UpdateRealtimeLogConfig::set_name): <p>The name for this real-time log configuration.</p>
    ///   - [`arn(impl Into<String>)`](crate::client::fluent_builders::UpdateRealtimeLogConfig::arn) / [`set_arn(Option<String>)`](crate::client::fluent_builders::UpdateRealtimeLogConfig::set_arn): <p>The Amazon Resource Name (ARN) for this real-time log configuration.</p>
    ///   - [`sampling_rate(i64)`](crate::client::fluent_builders::UpdateRealtimeLogConfig::sampling_rate) / [`set_sampling_rate(Option<i64>)`](crate::client::fluent_builders::UpdateRealtimeLogConfig::set_sampling_rate): <p>The sampling rate for this real-time log configuration. The sampling rate determines the percentage of viewer requests that are represented in the real-time log data. You must provide an integer between 1 and 100, inclusive.</p>
    /// - On success, responds with [`UpdateRealtimeLogConfigOutput`](crate::output::UpdateRealtimeLogConfigOutput) with field(s):
    ///   - [`realtime_log_config(Option<RealtimeLogConfig>)`](crate::output::UpdateRealtimeLogConfigOutput::realtime_log_config): <p>A real-time log configuration.</p>
    /// - On failure, responds with [`SdkError<UpdateRealtimeLogConfigError>`](crate::error::UpdateRealtimeLogConfigError)
    pub fn update_realtime_log_config(&self) -> fluent_builders::UpdateRealtimeLogConfig {
        fluent_builders::UpdateRealtimeLogConfig::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateResponseHeadersPolicy`](crate::client::fluent_builders::UpdateResponseHeadersPolicy) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`response_headers_policy_config(ResponseHeadersPolicyConfig)`](crate::client::fluent_builders::UpdateResponseHeadersPolicy::response_headers_policy_config) / [`set_response_headers_policy_config(Option<ResponseHeadersPolicyConfig>)`](crate::client::fluent_builders::UpdateResponseHeadersPolicy::set_response_headers_policy_config): <p>A response headers policy configuration.</p>
    ///   - [`id(impl Into<String>)`](crate::client::fluent_builders::UpdateResponseHeadersPolicy::id) / [`set_id(Option<String>)`](crate::client::fluent_builders::UpdateResponseHeadersPolicy::set_id): <p>The identifier for the response headers policy that you are updating.</p>
    ///   - [`if_match(impl Into<String>)`](crate::client::fluent_builders::UpdateResponseHeadersPolicy::if_match) / [`set_if_match(Option<String>)`](crate::client::fluent_builders::UpdateResponseHeadersPolicy::set_if_match): <p>The version of the response headers policy that you are updating.</p>  <p>The version is returned in the cache policy’s <code>ETag</code> field in the response to <code>GetResponseHeadersPolicyConfig</code>.</p>
    /// - On success, responds with [`UpdateResponseHeadersPolicyOutput`](crate::output::UpdateResponseHeadersPolicyOutput) with field(s):
    ///   - [`response_headers_policy(Option<ResponseHeadersPolicy>)`](crate::output::UpdateResponseHeadersPolicyOutput::response_headers_policy): <p>A response headers policy.</p>
    ///   - [`e_tag(Option<String>)`](crate::output::UpdateResponseHeadersPolicyOutput::e_tag): <p>The current version of the response headers policy.</p>
    /// - On failure, responds with [`SdkError<UpdateResponseHeadersPolicyError>`](crate::error::UpdateResponseHeadersPolicyError)
    pub fn update_response_headers_policy(&self) -> fluent_builders::UpdateResponseHeadersPolicy {
        fluent_builders::UpdateResponseHeadersPolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateStreamingDistribution`](crate::client::fluent_builders::UpdateStreamingDistribution) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`streaming_distribution_config(StreamingDistributionConfig)`](crate::client::fluent_builders::UpdateStreamingDistribution::streaming_distribution_config) / [`set_streaming_distribution_config(Option<StreamingDistributionConfig>)`](crate::client::fluent_builders::UpdateStreamingDistribution::set_streaming_distribution_config): <p>The streaming distribution's configuration information.</p>
    ///   - [`id(impl Into<String>)`](crate::client::fluent_builders::UpdateStreamingDistribution::id) / [`set_id(Option<String>)`](crate::client::fluent_builders::UpdateStreamingDistribution::set_id): <p>The streaming distribution's id.</p>
    ///   - [`if_match(impl Into<String>)`](crate::client::fluent_builders::UpdateStreamingDistribution::if_match) / [`set_if_match(Option<String>)`](crate::client::fluent_builders::UpdateStreamingDistribution::set_if_match): <p>The value of the <code>ETag</code> header that you received when retrieving the streaming distribution's configuration. For example: <code>E2QWRUHAPOMQZL</code>.</p>
    /// - On success, responds with [`UpdateStreamingDistributionOutput`](crate::output::UpdateStreamingDistributionOutput) with field(s):
    ///   - [`streaming_distribution(Option<StreamingDistribution>)`](crate::output::UpdateStreamingDistributionOutput::streaming_distribution): <p>The streaming distribution's information.</p>
    ///   - [`e_tag(Option<String>)`](crate::output::UpdateStreamingDistributionOutput::e_tag): <p>The current version of the configuration. For example: <code>E2QWRUHAPOMQZL</code>.</p>
    /// - On failure, responds with [`SdkError<UpdateStreamingDistributionError>`](crate::error::UpdateStreamingDistributionError)
    pub fn update_streaming_distribution(&self) -> fluent_builders::UpdateStreamingDistribution {
        fluent_builders::UpdateStreamingDistribution::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `AssociateAlias`.
    ///
    /// <p>Associates an alias (also known as a CNAME or an alternate domain name) with a CloudFront distribution.</p>
    /// <p>With this operation you can move an alias that’s already in use on a CloudFront distribution to a different distribution in one step. This prevents the downtime that could occur if you first remove the alias from one distribution and then separately add the alias to another distribution.</p>
    /// <p>To use this operation to associate an alias with a distribution, you provide the alias and the ID of the target distribution for the alias. For more information, including how to set up the target distribution, prerequisites that you must complete, and other restrictions, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/CNAMEs.html#alternate-domain-names-move">Moving an alternate domain name to a different distribution</a> in the <i>Amazon CloudFront Developer Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct AssociateAlias {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::associate_alias_input::Builder,
    }
    impl AssociateAlias {
        /// Creates a new `AssociateAlias`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AssociateAliasOutput,
            aws_smithy_http::result::SdkError<crate::error::AssociateAliasError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the distribution that you’re associating the alias with.</p>
        pub fn target_distribution_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.target_distribution_id(input.into());
            self
        }
        /// <p>The ID of the distribution that you’re associating the alias with.</p>
        pub fn set_target_distribution_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_target_distribution_id(input);
            self
        }
        /// <p>The alias (also known as a CNAME) to add to the target distribution.</p>
        pub fn alias(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.alias(input.into());
            self
        }
        /// <p>The alias (also known as a CNAME) to add to the target distribution.</p>
        pub fn set_alias(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_alias(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateCachePolicy`.
    ///
    /// <p>Creates a cache policy.</p>
    /// <p>After you create a cache policy, you can attach it to one or more cache behaviors. When it’s attached to a cache behavior, the cache policy determines the following:</p>
    /// <ul>
    /// <li> <p>The values that CloudFront includes in the <i>cache key</i>. These values can include HTTP headers, cookies, and URL query strings. CloudFront uses the cache key to find an object in its cache that it can return to the viewer.</p> </li>
    /// <li> <p>The default, minimum, and maximum time to live (TTL) values that you want objects to stay in the CloudFront cache.</p> </li>
    /// </ul>
    /// <p>The headers, cookies, and query strings that are included in the cache key are automatically included in requests that CloudFront sends to the origin. CloudFront sends a request when it can’t find an object in its cache that matches the request’s cache key. If you want to send values to the origin but <i>not</i> include them in the cache key, use <code>OriginRequestPolicy</code>.</p>
    /// <p>For more information about cache policies, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html">Controlling the cache key</a> in the <i>Amazon CloudFront Developer Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateCachePolicy {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_cache_policy_input::Builder,
    }
    impl CreateCachePolicy {
        /// Creates a new `CreateCachePolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateCachePolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateCachePolicyError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A cache policy configuration.</p>
        pub fn cache_policy_config(mut self, input: crate::model::CachePolicyConfig) -> Self {
            self.inner = self.inner.cache_policy_config(input);
            self
        }
        /// <p>A cache policy configuration.</p>
        pub fn set_cache_policy_config(
            mut self,
            input: std::option::Option<crate::model::CachePolicyConfig>,
        ) -> Self {
            self.inner = self.inner.set_cache_policy_config(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateCloudFrontOriginAccessIdentity`.
    ///
    /// <p>Creates a new origin access identity. If you're using Amazon S3 for your origin, you can use an origin access identity to require users to access your content using a CloudFront URL instead of the Amazon S3 URL. For more information about how to use origin access identities, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html">Serving Private Content through CloudFront</a> in the <i>Amazon CloudFront Developer Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateCloudFrontOriginAccessIdentity {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_cloud_front_origin_access_identity_input::Builder,
    }
    impl CreateCloudFrontOriginAccessIdentity {
        /// Creates a new `CreateCloudFrontOriginAccessIdentity`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateCloudFrontOriginAccessIdentityOutput,
            aws_smithy_http::result::SdkError<
                crate::error::CreateCloudFrontOriginAccessIdentityError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The current configuration information for the identity.</p>
        pub fn cloud_front_origin_access_identity_config(
            mut self,
            input: crate::model::CloudFrontOriginAccessIdentityConfig,
        ) -> Self {
            self.inner = self.inner.cloud_front_origin_access_identity_config(input);
            self
        }
        /// <p>The current configuration information for the identity.</p>
        pub fn set_cloud_front_origin_access_identity_config(
            mut self,
            input: std::option::Option<crate::model::CloudFrontOriginAccessIdentityConfig>,
        ) -> Self {
            self.inner = self
                .inner
                .set_cloud_front_origin_access_identity_config(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateDistribution`.
    ///
    /// <p>Creates a new web distribution. You create a CloudFront distribution to tell CloudFront where you want content to be delivered from, and the details about how to track and manage content delivery. Send a <code>POST</code> request to the <code>/<i>CloudFront API version</i>/distribution</code>/<code>distribution ID</code> resource.</p> <important>
    /// <p>When you update a distribution, there are more required fields than when you create a distribution. When you update your distribution by using <a href="https://docs.aws.amazon.com/cloudfront/latest/APIReference/API_UpdateDistribution.html">UpdateDistribution</a>, follow the steps included in the documentation to get the current configuration and then make your updates. This helps to make sure that you include all of the required fields. To view a summary, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-overview-required-fields.html">Required Fields for Create Distribution and Update Distribution</a> in the <i>Amazon CloudFront Developer Guide</i>.</p>
    /// </important>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateDistribution {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_distribution_input::Builder,
    }
    impl CreateDistribution {
        /// Creates a new `CreateDistribution`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateDistributionOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateDistributionError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The distribution's configuration information.</p>
        pub fn distribution_config(mut self, input: crate::model::DistributionConfig) -> Self {
            self.inner = self.inner.distribution_config(input);
            self
        }
        /// <p>The distribution's configuration information.</p>
        pub fn set_distribution_config(
            mut self,
            input: std::option::Option<crate::model::DistributionConfig>,
        ) -> Self {
            self.inner = self.inner.set_distribution_config(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateDistributionWithTags`.
    ///
    /// <p>Create a new distribution with tags.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateDistributionWithTags {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_distribution_with_tags_input::Builder,
    }
    impl CreateDistributionWithTags {
        /// Creates a new `CreateDistributionWithTags`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateDistributionWithTagsOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateDistributionWithTagsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The distribution's configuration information. </p>
        pub fn distribution_config_with_tags(
            mut self,
            input: crate::model::DistributionConfigWithTags,
        ) -> Self {
            self.inner = self.inner.distribution_config_with_tags(input);
            self
        }
        /// <p>The distribution's configuration information. </p>
        pub fn set_distribution_config_with_tags(
            mut self,
            input: std::option::Option<crate::model::DistributionConfigWithTags>,
        ) -> Self {
            self.inner = self.inner.set_distribution_config_with_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateFieldLevelEncryptionConfig`.
    ///
    /// <p>Create a new field-level encryption configuration.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateFieldLevelEncryptionConfig {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_field_level_encryption_config_input::Builder,
    }
    impl CreateFieldLevelEncryptionConfig {
        /// Creates a new `CreateFieldLevelEncryptionConfig`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateFieldLevelEncryptionConfigOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateFieldLevelEncryptionConfigError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The request to create a new field-level encryption configuration.</p>
        pub fn field_level_encryption_config(
            mut self,
            input: crate::model::FieldLevelEncryptionConfig,
        ) -> Self {
            self.inner = self.inner.field_level_encryption_config(input);
            self
        }
        /// <p>The request to create a new field-level encryption configuration.</p>
        pub fn set_field_level_encryption_config(
            mut self,
            input: std::option::Option<crate::model::FieldLevelEncryptionConfig>,
        ) -> Self {
            self.inner = self.inner.set_field_level_encryption_config(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateFieldLevelEncryptionProfile`.
    ///
    /// <p>Create a field-level encryption profile.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateFieldLevelEncryptionProfile {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_field_level_encryption_profile_input::Builder,
    }
    impl CreateFieldLevelEncryptionProfile {
        /// Creates a new `CreateFieldLevelEncryptionProfile`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateFieldLevelEncryptionProfileOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateFieldLevelEncryptionProfileError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The request to create a field-level encryption profile.</p>
        pub fn field_level_encryption_profile_config(
            mut self,
            input: crate::model::FieldLevelEncryptionProfileConfig,
        ) -> Self {
            self.inner = self.inner.field_level_encryption_profile_config(input);
            self
        }
        /// <p>The request to create a field-level encryption profile.</p>
        pub fn set_field_level_encryption_profile_config(
            mut self,
            input: std::option::Option<crate::model::FieldLevelEncryptionProfileConfig>,
        ) -> Self {
            self.inner = self.inner.set_field_level_encryption_profile_config(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateFunction`.
    ///
    /// <p>Creates a CloudFront function.</p>
    /// <p>To create a function, you provide the function code and some configuration information about the function. The response contains an Amazon Resource Name (ARN) that uniquely identifies the function.</p>
    /// <p>When you create a function, it’s in the <code>DEVELOPMENT</code> stage. In this stage, you can test the function with <code>TestFunction</code>, and update it with <code>UpdateFunction</code>.</p>
    /// <p>When you’re ready to use your function with a CloudFront distribution, use <code>PublishFunction</code> to copy the function from the <code>DEVELOPMENT</code> stage to <code>LIVE</code>. When it’s live, you can attach the function to a distribution’s cache behavior, using the function’s ARN.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateFunction {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_function_input::Builder,
    }
    impl CreateFunction {
        /// Creates a new `CreateFunction`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateFunctionOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateFunctionError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A name to identify the function.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>A name to identify the function.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>Configuration information about the function, including an optional comment and the function’s runtime.</p>
        pub fn function_config(mut self, input: crate::model::FunctionConfig) -> Self {
            self.inner = self.inner.function_config(input);
            self
        }
        /// <p>Configuration information about the function, including an optional comment and the function’s runtime.</p>
        pub fn set_function_config(
            mut self,
            input: std::option::Option<crate::model::FunctionConfig>,
        ) -> Self {
            self.inner = self.inner.set_function_config(input);
            self
        }
        /// <p>The function code. For more information about writing a CloudFront function, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/writing-function-code.html">Writing function code for CloudFront Functions</a> in the <i>Amazon CloudFront Developer Guide</i>.</p>
        pub fn function_code(mut self, input: aws_smithy_types::Blob) -> Self {
            self.inner = self.inner.function_code(input);
            self
        }
        /// <p>The function code. For more information about writing a CloudFront function, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/writing-function-code.html">Writing function code for CloudFront Functions</a> in the <i>Amazon CloudFront Developer Guide</i>.</p>
        pub fn set_function_code(
            mut self,
            input: std::option::Option<aws_smithy_types::Blob>,
        ) -> Self {
            self.inner = self.inner.set_function_code(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateInvalidation`.
    ///
    /// <p>Create a new invalidation. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateInvalidation {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_invalidation_input::Builder,
    }
    impl CreateInvalidation {
        /// Creates a new `CreateInvalidation`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateInvalidationOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateInvalidationError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The distribution's id.</p>
        pub fn distribution_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.distribution_id(input.into());
            self
        }
        /// <p>The distribution's id.</p>
        pub fn set_distribution_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_distribution_id(input);
            self
        }
        /// <p>The batch information for the invalidation.</p>
        pub fn invalidation_batch(mut self, input: crate::model::InvalidationBatch) -> Self {
            self.inner = self.inner.invalidation_batch(input);
            self
        }
        /// <p>The batch information for the invalidation.</p>
        pub fn set_invalidation_batch(
            mut self,
            input: std::option::Option<crate::model::InvalidationBatch>,
        ) -> Self {
            self.inner = self.inner.set_invalidation_batch(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateKeyGroup`.
    ///
    /// <p>Creates a key group that you can use with <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html">CloudFront signed URLs and signed cookies</a>.</p>
    /// <p>To create a key group, you must specify at least one public key for the key group. After you create a key group, you can reference it from one or more cache behaviors. When you reference a key group in a cache behavior, CloudFront requires signed URLs or signed cookies for all requests that match the cache behavior. The URLs or cookies must be signed with a private key whose corresponding public key is in the key group. The signed URL or cookie contains information about which public key CloudFront should use to verify the signature. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html">Serving private content</a> in the <i>Amazon CloudFront Developer Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateKeyGroup {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_key_group_input::Builder,
    }
    impl CreateKeyGroup {
        /// Creates a new `CreateKeyGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateKeyGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateKeyGroupError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A key group configuration.</p>
        pub fn key_group_config(mut self, input: crate::model::KeyGroupConfig) -> Self {
            self.inner = self.inner.key_group_config(input);
            self
        }
        /// <p>A key group configuration.</p>
        pub fn set_key_group_config(
            mut self,
            input: std::option::Option<crate::model::KeyGroupConfig>,
        ) -> Self {
            self.inner = self.inner.set_key_group_config(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateMonitoringSubscription`.
    ///
    /// <p>Enables additional CloudWatch metrics for the specified CloudFront distribution. The additional metrics incur an additional cost.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/viewing-cloudfront-metrics.html#monitoring-console.distributions-additional">Viewing additional CloudFront distribution metrics</a> in the <i>Amazon CloudFront Developer Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateMonitoringSubscription {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_monitoring_subscription_input::Builder,
    }
    impl CreateMonitoringSubscription {
        /// Creates a new `CreateMonitoringSubscription`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateMonitoringSubscriptionOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateMonitoringSubscriptionError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the distribution that you are enabling metrics for.</p>
        pub fn distribution_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.distribution_id(input.into());
            self
        }
        /// <p>The ID of the distribution that you are enabling metrics for.</p>
        pub fn set_distribution_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_distribution_id(input);
            self
        }
        /// <p>A monitoring subscription. This structure contains information about whether additional CloudWatch metrics are enabled for a given CloudFront distribution.</p>
        pub fn monitoring_subscription(
            mut self,
            input: crate::model::MonitoringSubscription,
        ) -> Self {
            self.inner = self.inner.monitoring_subscription(input);
            self
        }
        /// <p>A monitoring subscription. This structure contains information about whether additional CloudWatch metrics are enabled for a given CloudFront distribution.</p>
        pub fn set_monitoring_subscription(
            mut self,
            input: std::option::Option<crate::model::MonitoringSubscription>,
        ) -> Self {
            self.inner = self.inner.set_monitoring_subscription(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateOriginRequestPolicy`.
    ///
    /// <p>Creates an origin request policy.</p>
    /// <p>After you create an origin request policy, you can attach it to one or more cache behaviors. When it’s attached to a cache behavior, the origin request policy determines the values that CloudFront includes in requests that it sends to the origin. Each request that CloudFront sends to the origin includes the following:</p>
    /// <ul>
    /// <li> <p>The request body and the URL path (without the domain name) from the viewer request.</p> </li>
    /// <li> <p>The headers that CloudFront automatically includes in every origin request, including <code>Host</code>, <code>User-Agent</code>, and <code>X-Amz-Cf-Id</code>.</p> </li>
    /// <li> <p>All HTTP headers, cookies, and URL query strings that are specified in the cache policy or the origin request policy. These can include items from the viewer request and, in the case of headers, additional ones that are added by CloudFront.</p> </li>
    /// </ul>
    /// <p>CloudFront sends a request when it can’t find a valid object in its cache that matches the request. If you want to send values to the origin and also include them in the cache key, use <code>CachePolicy</code>.</p>
    /// <p>For more information about origin request policies, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-origin-requests.html">Controlling origin requests</a> in the <i>Amazon CloudFront Developer Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateOriginRequestPolicy {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_origin_request_policy_input::Builder,
    }
    impl CreateOriginRequestPolicy {
        /// Creates a new `CreateOriginRequestPolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateOriginRequestPolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateOriginRequestPolicyError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>An origin request policy configuration.</p>
        pub fn origin_request_policy_config(
            mut self,
            input: crate::model::OriginRequestPolicyConfig,
        ) -> Self {
            self.inner = self.inner.origin_request_policy_config(input);
            self
        }
        /// <p>An origin request policy configuration.</p>
        pub fn set_origin_request_policy_config(
            mut self,
            input: std::option::Option<crate::model::OriginRequestPolicyConfig>,
        ) -> Self {
            self.inner = self.inner.set_origin_request_policy_config(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreatePublicKey`.
    ///
    /// <p>Uploads a public key to CloudFront that you can use with <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html">signed URLs and signed cookies</a>, or with <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/field-level-encryption.html">field-level encryption</a>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreatePublicKey {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_public_key_input::Builder,
    }
    impl CreatePublicKey {
        /// Creates a new `CreatePublicKey`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreatePublicKeyOutput,
            aws_smithy_http::result::SdkError<crate::error::CreatePublicKeyError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A CloudFront public key configuration.</p>
        pub fn public_key_config(mut self, input: crate::model::PublicKeyConfig) -> Self {
            self.inner = self.inner.public_key_config(input);
            self
        }
        /// <p>A CloudFront public key configuration.</p>
        pub fn set_public_key_config(
            mut self,
            input: std::option::Option<crate::model::PublicKeyConfig>,
        ) -> Self {
            self.inner = self.inner.set_public_key_config(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateRealtimeLogConfig`.
    ///
    /// <p>Creates a real-time log configuration.</p>
    /// <p>After you create a real-time log configuration, you can attach it to one or more cache behaviors to send real-time log data to the specified Amazon Kinesis data stream.</p>
    /// <p>For more information about real-time log configurations, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/real-time-logs.html">Real-time logs</a> in the <i>Amazon CloudFront Developer Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateRealtimeLogConfig {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_realtime_log_config_input::Builder,
    }
    impl CreateRealtimeLogConfig {
        /// Creates a new `CreateRealtimeLogConfig`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateRealtimeLogConfigOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateRealtimeLogConfigError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `EndPoints`.
        ///
        /// To override the contents of this collection use [`set_end_points`](Self::set_end_points).
        ///
        /// <p>Contains information about the Amazon Kinesis data stream where you are sending real-time log data.</p>
        pub fn end_points(mut self, input: crate::model::EndPoint) -> Self {
            self.inner = self.inner.end_points(input);
            self
        }
        /// <p>Contains information about the Amazon Kinesis data stream where you are sending real-time log data.</p>
        pub fn set_end_points(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::EndPoint>>,
        ) -> Self {
            self.inner = self.inner.set_end_points(input);
            self
        }
        /// Appends an item to `Fields`.
        ///
        /// To override the contents of this collection use [`set_fields`](Self::set_fields).
        ///
        /// <p>A list of fields to include in each real-time log record.</p>
        /// <p>For more information about fields, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/real-time-logs.html#understand-real-time-log-config-fields">Real-time log configuration fields</a> in the <i>Amazon CloudFront Developer Guide</i>.</p>
        pub fn fields(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.fields(input.into());
            self
        }
        /// <p>A list of fields to include in each real-time log record.</p>
        /// <p>For more information about fields, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/real-time-logs.html#understand-real-time-log-config-fields">Real-time log configuration fields</a> in the <i>Amazon CloudFront Developer Guide</i>.</p>
        pub fn set_fields(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_fields(input);
            self
        }
        /// <p>A unique name to identify this real-time log configuration.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>A unique name to identify this real-time log configuration.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The sampling rate for this real-time log configuration. The sampling rate determines the percentage of viewer requests that are represented in the real-time log data. You must provide an integer between 1 and 100, inclusive.</p>
        pub fn sampling_rate(mut self, input: i64) -> Self {
            self.inner = self.inner.sampling_rate(input);
            self
        }
        /// <p>The sampling rate for this real-time log configuration. The sampling rate determines the percentage of viewer requests that are represented in the real-time log data. You must provide an integer between 1 and 100, inclusive.</p>
        pub fn set_sampling_rate(mut self, input: std::option::Option<i64>) -> Self {
            self.inner = self.inner.set_sampling_rate(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateResponseHeadersPolicy`.
    ///
    /// <p>Creates a response headers policy.</p>
    /// <p>A response headers policy contains information about a set of HTTP response headers and their values. To create a response headers policy, you provide some metadata about the policy, and a set of configurations that specify the response headers.</p>
    /// <p>After you create a response headers policy, you can use its ID to attach it to one or more cache behaviors in a CloudFront distribution. When it’s attached to a cache behavior, CloudFront adds the headers in the policy to HTTP responses that it sends for requests that match the cache behavior.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateResponseHeadersPolicy {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_response_headers_policy_input::Builder,
    }
    impl CreateResponseHeadersPolicy {
        /// Creates a new `CreateResponseHeadersPolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateResponseHeadersPolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateResponseHeadersPolicyError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Contains metadata about the response headers policy, and a set of configurations that specify the response headers.</p>
        pub fn response_headers_policy_config(
            mut self,
            input: crate::model::ResponseHeadersPolicyConfig,
        ) -> Self {
            self.inner = self.inner.response_headers_policy_config(input);
            self
        }
        /// <p>Contains metadata about the response headers policy, and a set of configurations that specify the response headers.</p>
        pub fn set_response_headers_policy_config(
            mut self,
            input: std::option::Option<crate::model::ResponseHeadersPolicyConfig>,
        ) -> Self {
            self.inner = self.inner.set_response_headers_policy_config(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateStreamingDistribution`.
    ///
    /// <p>This API is deprecated. Amazon CloudFront is deprecating real-time messaging protocol (RTMP) distributions on December 31, 2020. For more information, <a href="http://forums.aws.amazon.com/ann.jspa?annID=7356">read the announcement</a> on the Amazon CloudFront discussion forum.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateStreamingDistribution {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_streaming_distribution_input::Builder,
    }
    impl CreateStreamingDistribution {
        /// Creates a new `CreateStreamingDistribution`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateStreamingDistributionOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateStreamingDistributionError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The streaming distribution's configuration information.</p>
        pub fn streaming_distribution_config(
            mut self,
            input: crate::model::StreamingDistributionConfig,
        ) -> Self {
            self.inner = self.inner.streaming_distribution_config(input);
            self
        }
        /// <p>The streaming distribution's configuration information.</p>
        pub fn set_streaming_distribution_config(
            mut self,
            input: std::option::Option<crate::model::StreamingDistributionConfig>,
        ) -> Self {
            self.inner = self.inner.set_streaming_distribution_config(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateStreamingDistributionWithTags`.
    ///
    /// <p>This API is deprecated. Amazon CloudFront is deprecating real-time messaging protocol (RTMP) distributions on December 31, 2020. For more information, <a href="http://forums.aws.amazon.com/ann.jspa?annID=7356">read the announcement</a> on the Amazon CloudFront discussion forum.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateStreamingDistributionWithTags {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_streaming_distribution_with_tags_input::Builder,
    }
    impl CreateStreamingDistributionWithTags {
        /// Creates a new `CreateStreamingDistributionWithTags`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateStreamingDistributionWithTagsOutput,
            aws_smithy_http::result::SdkError<
                crate::error::CreateStreamingDistributionWithTagsError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The streaming distribution's configuration information. </p>
        pub fn streaming_distribution_config_with_tags(
            mut self,
            input: crate::model::StreamingDistributionConfigWithTags,
        ) -> Self {
            self.inner = self.inner.streaming_distribution_config_with_tags(input);
            self
        }
        /// <p> The streaming distribution's configuration information. </p>
        pub fn set_streaming_distribution_config_with_tags(
            mut self,
            input: std::option::Option<crate::model::StreamingDistributionConfigWithTags>,
        ) -> Self {
            self.inner = self
                .inner
                .set_streaming_distribution_config_with_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteCachePolicy`.
    ///
    /// <p>Deletes a cache policy.</p>
    /// <p>You cannot delete a cache policy if it’s attached to a cache behavior. First update your distributions to remove the cache policy from all cache behaviors, then delete the cache policy.</p>
    /// <p>To delete a cache policy, you must provide the policy’s identifier and version. To get these values, you can use <code>ListCachePolicies</code> or <code>GetCachePolicy</code>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteCachePolicy {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_cache_policy_input::Builder,
    }
    impl DeleteCachePolicy {
        /// Creates a new `DeleteCachePolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteCachePolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteCachePolicyError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier for the cache policy that you are deleting. To get the identifier, you can use <code>ListCachePolicies</code>.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// <p>The unique identifier for the cache policy that you are deleting. To get the identifier, you can use <code>ListCachePolicies</code>.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
        /// <p>The version of the cache policy that you are deleting. The version is the cache policy’s <code>ETag</code> value, which you can get using <code>ListCachePolicies</code>, <code>GetCachePolicy</code>, or <code>GetCachePolicyConfig</code>.</p>
        pub fn if_match(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.if_match(input.into());
            self
        }
        /// <p>The version of the cache policy that you are deleting. The version is the cache policy’s <code>ETag</code> value, which you can get using <code>ListCachePolicies</code>, <code>GetCachePolicy</code>, or <code>GetCachePolicyConfig</code>.</p>
        pub fn set_if_match(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_if_match(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteCloudFrontOriginAccessIdentity`.
    ///
    /// <p>Delete an origin access identity. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteCloudFrontOriginAccessIdentity {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_cloud_front_origin_access_identity_input::Builder,
    }
    impl DeleteCloudFrontOriginAccessIdentity {
        /// Creates a new `DeleteCloudFrontOriginAccessIdentity`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteCloudFrontOriginAccessIdentityOutput,
            aws_smithy_http::result::SdkError<
                crate::error::DeleteCloudFrontOriginAccessIdentityError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The origin access identity's ID.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// <p>The origin access identity's ID.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
        /// <p>The value of the <code>ETag</code> header you received from a previous <code>GET</code> or <code>PUT</code> request. For example: <code>E2QWRUHAPOMQZL</code>.</p>
        pub fn if_match(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.if_match(input.into());
            self
        }
        /// <p>The value of the <code>ETag</code> header you received from a previous <code>GET</code> or <code>PUT</code> request. For example: <code>E2QWRUHAPOMQZL</code>.</p>
        pub fn set_if_match(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_if_match(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteDistribution`.
    ///
    /// <p>Delete a distribution. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteDistribution {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_distribution_input::Builder,
    }
    impl DeleteDistribution {
        /// Creates a new `DeleteDistribution`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteDistributionOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteDistributionError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The distribution ID. </p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// <p>The distribution ID. </p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
        /// <p>The value of the <code>ETag</code> header that you received when you disabled the distribution. For example: <code>E2QWRUHAPOMQZL</code>. </p>
        pub fn if_match(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.if_match(input.into());
            self
        }
        /// <p>The value of the <code>ETag</code> header that you received when you disabled the distribution. For example: <code>E2QWRUHAPOMQZL</code>. </p>
        pub fn set_if_match(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_if_match(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteFieldLevelEncryptionConfig`.
    ///
    /// <p>Remove a field-level encryption configuration.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteFieldLevelEncryptionConfig {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_field_level_encryption_config_input::Builder,
    }
    impl DeleteFieldLevelEncryptionConfig {
        /// Creates a new `DeleteFieldLevelEncryptionConfig`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteFieldLevelEncryptionConfigOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteFieldLevelEncryptionConfigError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the configuration you want to delete from CloudFront.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// <p>The ID of the configuration you want to delete from CloudFront.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
        /// <p>The value of the <code>ETag</code> header that you received when retrieving the configuration identity to delete. For example: <code>E2QWRUHAPOMQZL</code>.</p>
        pub fn if_match(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.if_match(input.into());
            self
        }
        /// <p>The value of the <code>ETag</code> header that you received when retrieving the configuration identity to delete. For example: <code>E2QWRUHAPOMQZL</code>.</p>
        pub fn set_if_match(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_if_match(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteFieldLevelEncryptionProfile`.
    ///
    /// <p>Remove a field-level encryption profile.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteFieldLevelEncryptionProfile {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_field_level_encryption_profile_input::Builder,
    }
    impl DeleteFieldLevelEncryptionProfile {
        /// Creates a new `DeleteFieldLevelEncryptionProfile`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteFieldLevelEncryptionProfileOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteFieldLevelEncryptionProfileError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Request the ID of the profile you want to delete from CloudFront.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// <p>Request the ID of the profile you want to delete from CloudFront.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
        /// <p>The value of the <code>ETag</code> header that you received when retrieving the profile to delete. For example: <code>E2QWRUHAPOMQZL</code>.</p>
        pub fn if_match(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.if_match(input.into());
            self
        }
        /// <p>The value of the <code>ETag</code> header that you received when retrieving the profile to delete. For example: <code>E2QWRUHAPOMQZL</code>.</p>
        pub fn set_if_match(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_if_match(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteFunction`.
    ///
    /// <p>Deletes a CloudFront function.</p>
    /// <p>You cannot delete a function if it’s associated with a cache behavior. First, update your distributions to remove the function association from all cache behaviors, then delete the function.</p>
    /// <p>To delete a function, you must provide the function’s name and version (<code>ETag</code> value). To get these values, you can use <code>ListFunctions</code> and <code>DescribeFunction</code>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteFunction {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_function_input::Builder,
    }
    impl DeleteFunction {
        /// Creates a new `DeleteFunction`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteFunctionOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteFunctionError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the function that you are deleting.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the function that you are deleting.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The current version (<code>ETag</code> value) of the function that you are deleting, which you can get using <code>DescribeFunction</code>.</p>
        pub fn if_match(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.if_match(input.into());
            self
        }
        /// <p>The current version (<code>ETag</code> value) of the function that you are deleting, which you can get using <code>DescribeFunction</code>.</p>
        pub fn set_if_match(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_if_match(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteKeyGroup`.
    ///
    /// <p>Deletes a key group.</p>
    /// <p>You cannot delete a key group that is referenced in a cache behavior. First update your distributions to remove the key group from all cache behaviors, then delete the key group.</p>
    /// <p>To delete a key group, you must provide the key group’s identifier and version. To get these values, use <code>ListKeyGroups</code> followed by <code>GetKeyGroup</code> or <code>GetKeyGroupConfig</code>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteKeyGroup {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_key_group_input::Builder,
    }
    impl DeleteKeyGroup {
        /// Creates a new `DeleteKeyGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteKeyGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteKeyGroupError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the key group that you are deleting. To get the identifier, use <code>ListKeyGroups</code>.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// <p>The identifier of the key group that you are deleting. To get the identifier, use <code>ListKeyGroups</code>.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
        /// <p>The version of the key group that you are deleting. The version is the key group’s <code>ETag</code> value. To get the <code>ETag</code>, use <code>GetKeyGroup</code> or <code>GetKeyGroupConfig</code>.</p>
        pub fn if_match(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.if_match(input.into());
            self
        }
        /// <p>The version of the key group that you are deleting. The version is the key group’s <code>ETag</code> value. To get the <code>ETag</code>, use <code>GetKeyGroup</code> or <code>GetKeyGroupConfig</code>.</p>
        pub fn set_if_match(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_if_match(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteMonitoringSubscription`.
    ///
    /// <p>Disables additional CloudWatch metrics for the specified CloudFront distribution.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteMonitoringSubscription {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_monitoring_subscription_input::Builder,
    }
    impl DeleteMonitoringSubscription {
        /// Creates a new `DeleteMonitoringSubscription`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteMonitoringSubscriptionOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteMonitoringSubscriptionError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the distribution that you are disabling metrics for.</p>
        pub fn distribution_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.distribution_id(input.into());
            self
        }
        /// <p>The ID of the distribution that you are disabling metrics for.</p>
        pub fn set_distribution_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_distribution_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteOriginRequestPolicy`.
    ///
    /// <p>Deletes an origin request policy.</p>
    /// <p>You cannot delete an origin request policy if it’s attached to any cache behaviors. First update your distributions to remove the origin request policy from all cache behaviors, then delete the origin request policy.</p>
    /// <p>To delete an origin request policy, you must provide the policy’s identifier and version. To get the identifier, you can use <code>ListOriginRequestPolicies</code> or <code>GetOriginRequestPolicy</code>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteOriginRequestPolicy {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_origin_request_policy_input::Builder,
    }
    impl DeleteOriginRequestPolicy {
        /// Creates a new `DeleteOriginRequestPolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteOriginRequestPolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteOriginRequestPolicyError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier for the origin request policy that you are deleting. To get the identifier, you can use <code>ListOriginRequestPolicies</code>.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// <p>The unique identifier for the origin request policy that you are deleting. To get the identifier, you can use <code>ListOriginRequestPolicies</code>.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
        /// <p>The version of the origin request policy that you are deleting. The version is the origin request policy’s <code>ETag</code> value, which you can get using <code>ListOriginRequestPolicies</code>, <code>GetOriginRequestPolicy</code>, or <code>GetOriginRequestPolicyConfig</code>.</p>
        pub fn if_match(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.if_match(input.into());
            self
        }
        /// <p>The version of the origin request policy that you are deleting. The version is the origin request policy’s <code>ETag</code> value, which you can get using <code>ListOriginRequestPolicies</code>, <code>GetOriginRequestPolicy</code>, or <code>GetOriginRequestPolicyConfig</code>.</p>
        pub fn set_if_match(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_if_match(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeletePublicKey`.
    ///
    /// <p>Remove a public key you previously added to CloudFront.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeletePublicKey {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_public_key_input::Builder,
    }
    impl DeletePublicKey {
        /// Creates a new `DeletePublicKey`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeletePublicKeyOutput,
            aws_smithy_http::result::SdkError<crate::error::DeletePublicKeyError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the public key you want to remove from CloudFront.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// <p>The ID of the public key you want to remove from CloudFront.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
        /// <p>The value of the <code>ETag</code> header that you received when retrieving the public key identity to delete. For example: <code>E2QWRUHAPOMQZL</code>.</p>
        pub fn if_match(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.if_match(input.into());
            self
        }
        /// <p>The value of the <code>ETag</code> header that you received when retrieving the public key identity to delete. For example: <code>E2QWRUHAPOMQZL</code>.</p>
        pub fn set_if_match(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_if_match(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteRealtimeLogConfig`.
    ///
    /// <p>Deletes a real-time log configuration.</p>
    /// <p>You cannot delete a real-time log configuration if it’s attached to a cache behavior. First update your distributions to remove the real-time log configuration from all cache behaviors, then delete the real-time log configuration.</p>
    /// <p>To delete a real-time log configuration, you can provide the configuration’s name or its Amazon Resource Name (ARN). You must provide at least one. If you provide both, CloudFront uses the name to identify the real-time log configuration to delete.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteRealtimeLogConfig {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_realtime_log_config_input::Builder,
    }
    impl DeleteRealtimeLogConfig {
        /// Creates a new `DeleteRealtimeLogConfig`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteRealtimeLogConfigOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteRealtimeLogConfigError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the real-time log configuration to delete.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the real-time log configuration to delete.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the real-time log configuration to delete.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the real-time log configuration to delete.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteResponseHeadersPolicy`.
    ///
    /// <p>Deletes a response headers policy.</p>
    /// <p>You cannot delete a response headers policy if it’s attached to a cache behavior. First update your distributions to remove the response headers policy from all cache behaviors, then delete the response headers policy.</p>
    /// <p>To delete a response headers policy, you must provide the policy’s identifier and version. To get these values, you can use <code>ListResponseHeadersPolicies</code> or <code>GetResponseHeadersPolicy</code>. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteResponseHeadersPolicy {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_response_headers_policy_input::Builder,
    }
    impl DeleteResponseHeadersPolicy {
        /// Creates a new `DeleteResponseHeadersPolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteResponseHeadersPolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteResponseHeadersPolicyError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier for the response headers policy that you are deleting.</p>
        /// <p>To get the identifier, you can use <code>ListResponseHeadersPolicies</code>.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// <p>The identifier for the response headers policy that you are deleting.</p>
        /// <p>To get the identifier, you can use <code>ListResponseHeadersPolicies</code>.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
        /// <p>The version of the response headers policy that you are deleting.</p>
        /// <p>The version is the response headers policy’s <code>ETag</code> value, which you can get using <code>ListResponseHeadersPolicies</code>, <code>GetResponseHeadersPolicy</code>, or <code>GetResponseHeadersPolicyConfig</code>.</p>
        pub fn if_match(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.if_match(input.into());
            self
        }
        /// <p>The version of the response headers policy that you are deleting.</p>
        /// <p>The version is the response headers policy’s <code>ETag</code> value, which you can get using <code>ListResponseHeadersPolicies</code>, <code>GetResponseHeadersPolicy</code>, or <code>GetResponseHeadersPolicyConfig</code>.</p>
        pub fn set_if_match(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_if_match(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteStreamingDistribution`.
    ///
    /// <p>Delete a streaming distribution. To delete an RTMP distribution using the CloudFront API, perform the following steps.</p>
    /// <p> <b>To delete an RTMP distribution using the CloudFront API</b>:</p>
    /// <ol>
    /// <li> <p>Disable the RTMP distribution.</p> </li>
    /// <li> <p>Submit a <code>GET Streaming Distribution Config</code> request to get the current configuration and the <code>Etag</code> header for the distribution. </p> </li>
    /// <li> <p>Update the XML document that was returned in the response to your <code>GET Streaming Distribution Config</code> request to change the value of <code>Enabled</code> to <code>false</code>.</p> </li>
    /// <li> <p>Submit a <code>PUT Streaming Distribution Config</code> request to update the configuration for your distribution. In the request body, include the XML document that you updated in Step 3. Then set the value of the HTTP <code>If-Match</code> header to the value of the <code>ETag</code> header that CloudFront returned when you submitted the <code>GET Streaming Distribution Config</code> request in Step 2.</p> </li>
    /// <li> <p>Review the response to the <code>PUT Streaming Distribution Config</code> request to confirm that the distribution was successfully disabled.</p> </li>
    /// <li> <p>Submit a <code>GET Streaming Distribution Config</code> request to confirm that your changes have propagated. When propagation is complete, the value of <code>Status</code> is <code>Deployed</code>.</p> </li>
    /// <li> <p>Submit a <code>DELETE Streaming Distribution</code> request. Set the value of the HTTP <code>If-Match</code> header to the value of the <code>ETag</code> header that CloudFront returned when you submitted the <code>GET Streaming Distribution Config</code> request in Step 2.</p> </li>
    /// <li> <p>Review the response to your <code>DELETE Streaming Distribution</code> request to confirm that the distribution was successfully deleted.</p> </li>
    /// </ol>
    /// <p>For information about deleting a distribution using the CloudFront console, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/HowToDeleteDistribution.html">Deleting a Distribution</a> in the <i>Amazon CloudFront Developer Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteStreamingDistribution {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_streaming_distribution_input::Builder,
    }
    impl DeleteStreamingDistribution {
        /// Creates a new `DeleteStreamingDistribution`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteStreamingDistributionOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteStreamingDistributionError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The distribution ID. </p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// <p>The distribution ID. </p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
        /// <p>The value of the <code>ETag</code> header that you received when you disabled the streaming distribution. For example: <code>E2QWRUHAPOMQZL</code>.</p>
        pub fn if_match(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.if_match(input.into());
            self
        }
        /// <p>The value of the <code>ETag</code> header that you received when you disabled the streaming distribution. For example: <code>E2QWRUHAPOMQZL</code>.</p>
        pub fn set_if_match(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_if_match(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeFunction`.
    ///
    /// <p>Gets configuration information and metadata about a CloudFront function, but not the function’s code. To get a function’s code, use <code>GetFunction</code>.</p>
    /// <p>To get configuration information and metadata about a function, you must provide the function’s name and stage. To get these values, you can use <code>ListFunctions</code>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeFunction {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_function_input::Builder,
    }
    impl DescribeFunction {
        /// Creates a new `DescribeFunction`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeFunctionOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeFunctionError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the function that you are getting information about.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the function that you are getting information about.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The function’s stage, either <code>DEVELOPMENT</code> or <code>LIVE</code>.</p>
        pub fn stage(mut self, input: crate::model::FunctionStage) -> Self {
            self.inner = self.inner.stage(input);
            self
        }
        /// <p>The function’s stage, either <code>DEVELOPMENT</code> or <code>LIVE</code>.</p>
        pub fn set_stage(
            mut self,
            input: std::option::Option<crate::model::FunctionStage>,
        ) -> Self {
            self.inner = self.inner.set_stage(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetCachePolicy`.
    ///
    /// <p>Gets a cache policy, including the following metadata:</p>
    /// <ul>
    /// <li> <p>The policy’s identifier.</p> </li>
    /// <li> <p>The date and time when the policy was last modified.</p> </li>
    /// </ul>
    /// <p>To get a cache policy, you must provide the policy’s identifier. If the cache policy is attached to a distribution’s cache behavior, you can get the policy’s identifier using <code>ListDistributions</code> or <code>GetDistribution</code>. If the cache policy is not attached to a cache behavior, you can get the identifier using <code>ListCachePolicies</code>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetCachePolicy {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_cache_policy_input::Builder,
    }
    impl GetCachePolicy {
        /// Creates a new `GetCachePolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetCachePolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::GetCachePolicyError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier for the cache policy. If the cache policy is attached to a distribution’s cache behavior, you can get the policy’s identifier using <code>ListDistributions</code> or <code>GetDistribution</code>. If the cache policy is not attached to a cache behavior, you can get the identifier using <code>ListCachePolicies</code>.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// <p>The unique identifier for the cache policy. If the cache policy is attached to a distribution’s cache behavior, you can get the policy’s identifier using <code>ListDistributions</code> or <code>GetDistribution</code>. If the cache policy is not attached to a cache behavior, you can get the identifier using <code>ListCachePolicies</code>.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetCachePolicyConfig`.
    ///
    /// <p>Gets a cache policy configuration.</p>
    /// <p>To get a cache policy configuration, you must provide the policy’s identifier. If the cache policy is attached to a distribution’s cache behavior, you can get the policy’s identifier using <code>ListDistributions</code> or <code>GetDistribution</code>. If the cache policy is not attached to a cache behavior, you can get the identifier using <code>ListCachePolicies</code>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetCachePolicyConfig {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_cache_policy_config_input::Builder,
    }
    impl GetCachePolicyConfig {
        /// Creates a new `GetCachePolicyConfig`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetCachePolicyConfigOutput,
            aws_smithy_http::result::SdkError<crate::error::GetCachePolicyConfigError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier for the cache policy. If the cache policy is attached to a distribution’s cache behavior, you can get the policy’s identifier using <code>ListDistributions</code> or <code>GetDistribution</code>. If the cache policy is not attached to a cache behavior, you can get the identifier using <code>ListCachePolicies</code>.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// <p>The unique identifier for the cache policy. If the cache policy is attached to a distribution’s cache behavior, you can get the policy’s identifier using <code>ListDistributions</code> or <code>GetDistribution</code>. If the cache policy is not attached to a cache behavior, you can get the identifier using <code>ListCachePolicies</code>.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetCloudFrontOriginAccessIdentity`.
    ///
    /// <p>Get the information about an origin access identity. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetCloudFrontOriginAccessIdentity {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_cloud_front_origin_access_identity_input::Builder,
    }
    impl GetCloudFrontOriginAccessIdentity {
        /// Creates a new `GetCloudFrontOriginAccessIdentity`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetCloudFrontOriginAccessIdentityOutput,
            aws_smithy_http::result::SdkError<crate::error::GetCloudFrontOriginAccessIdentityError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identity's ID.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// <p>The identity's ID.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetCloudFrontOriginAccessIdentityConfig`.
    ///
    /// <p>Get the configuration information about an origin access identity. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetCloudFrontOriginAccessIdentityConfig {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_cloud_front_origin_access_identity_config_input::Builder,
    }
    impl GetCloudFrontOriginAccessIdentityConfig {
        /// Creates a new `GetCloudFrontOriginAccessIdentityConfig`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetCloudFrontOriginAccessIdentityConfigOutput,
            aws_smithy_http::result::SdkError<
                crate::error::GetCloudFrontOriginAccessIdentityConfigError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identity's ID. </p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// <p>The identity's ID. </p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetDistribution`.
    ///
    /// <p>Get the information about a distribution.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetDistribution {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_distribution_input::Builder,
    }
    impl GetDistribution {
        /// Creates a new `GetDistribution`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetDistributionOutput,
            aws_smithy_http::result::SdkError<crate::error::GetDistributionError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The distribution's ID. If the ID is empty, an empty distribution configuration is returned.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// <p>The distribution's ID. If the ID is empty, an empty distribution configuration is returned.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetDistributionConfig`.
    ///
    /// <p>Get the configuration information about a distribution. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetDistributionConfig {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_distribution_config_input::Builder,
    }
    impl GetDistributionConfig {
        /// Creates a new `GetDistributionConfig`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetDistributionConfigOutput,
            aws_smithy_http::result::SdkError<crate::error::GetDistributionConfigError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The distribution's ID. If the ID is empty, an empty distribution configuration is returned.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// <p>The distribution's ID. If the ID is empty, an empty distribution configuration is returned.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetFieldLevelEncryption`.
    ///
    /// <p>Get the field-level encryption configuration information.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetFieldLevelEncryption {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_field_level_encryption_input::Builder,
    }
    impl GetFieldLevelEncryption {
        /// Creates a new `GetFieldLevelEncryption`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetFieldLevelEncryptionOutput,
            aws_smithy_http::result::SdkError<crate::error::GetFieldLevelEncryptionError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Request the ID for the field-level encryption configuration information.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// <p>Request the ID for the field-level encryption configuration information.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetFieldLevelEncryptionConfig`.
    ///
    /// <p>Get the field-level encryption configuration information.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetFieldLevelEncryptionConfig {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_field_level_encryption_config_input::Builder,
    }
    impl GetFieldLevelEncryptionConfig {
        /// Creates a new `GetFieldLevelEncryptionConfig`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetFieldLevelEncryptionConfigOutput,
            aws_smithy_http::result::SdkError<crate::error::GetFieldLevelEncryptionConfigError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Request the ID for the field-level encryption configuration information.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// <p>Request the ID for the field-level encryption configuration information.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetFieldLevelEncryptionProfile`.
    ///
    /// <p>Get the field-level encryption profile information.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetFieldLevelEncryptionProfile {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_field_level_encryption_profile_input::Builder,
    }
    impl GetFieldLevelEncryptionProfile {
        /// Creates a new `GetFieldLevelEncryptionProfile`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetFieldLevelEncryptionProfileOutput,
            aws_smithy_http::result::SdkError<crate::error::GetFieldLevelEncryptionProfileError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Get the ID for the field-level encryption profile information.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// <p>Get the ID for the field-level encryption profile information.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetFieldLevelEncryptionProfileConfig`.
    ///
    /// <p>Get the field-level encryption profile configuration information.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetFieldLevelEncryptionProfileConfig {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_field_level_encryption_profile_config_input::Builder,
    }
    impl GetFieldLevelEncryptionProfileConfig {
        /// Creates a new `GetFieldLevelEncryptionProfileConfig`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetFieldLevelEncryptionProfileConfigOutput,
            aws_smithy_http::result::SdkError<
                crate::error::GetFieldLevelEncryptionProfileConfigError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Get the ID for the field-level encryption profile configuration information.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// <p>Get the ID for the field-level encryption profile configuration information.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetFunction`.
    ///
    /// <p>Gets the code of a CloudFront function. To get configuration information and metadata about a function, use <code>DescribeFunction</code>.</p>
    /// <p>To get a function’s code, you must provide the function’s name and stage. To get these values, you can use <code>ListFunctions</code>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetFunction {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_function_input::Builder,
    }
    impl GetFunction {
        /// Creates a new `GetFunction`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetFunctionOutput,
            aws_smithy_http::result::SdkError<crate::error::GetFunctionError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the function whose code you are getting.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the function whose code you are getting.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The function’s stage, either <code>DEVELOPMENT</code> or <code>LIVE</code>.</p>
        pub fn stage(mut self, input: crate::model::FunctionStage) -> Self {
            self.inner = self.inner.stage(input);
            self
        }
        /// <p>The function’s stage, either <code>DEVELOPMENT</code> or <code>LIVE</code>.</p>
        pub fn set_stage(
            mut self,
            input: std::option::Option<crate::model::FunctionStage>,
        ) -> Self {
            self.inner = self.inner.set_stage(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetInvalidation`.
    ///
    /// <p>Get the information about an invalidation. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetInvalidation {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_invalidation_input::Builder,
    }
    impl GetInvalidation {
        /// Creates a new `GetInvalidation`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetInvalidationOutput,
            aws_smithy_http::result::SdkError<crate::error::GetInvalidationError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The distribution's ID.</p>
        pub fn distribution_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.distribution_id(input.into());
            self
        }
        /// <p>The distribution's ID.</p>
        pub fn set_distribution_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_distribution_id(input);
            self
        }
        /// <p>The identifier for the invalidation request, for example, <code>IDFDVBD632BHDS5</code>.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// <p>The identifier for the invalidation request, for example, <code>IDFDVBD632BHDS5</code>.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetKeyGroup`.
    ///
    /// <p>Gets a key group, including the date and time when the key group was last modified.</p>
    /// <p>To get a key group, you must provide the key group’s identifier. If the key group is referenced in a distribution’s cache behavior, you can get the key group’s identifier using <code>ListDistributions</code> or <code>GetDistribution</code>. If the key group is not referenced in a cache behavior, you can get the identifier using <code>ListKeyGroups</code>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetKeyGroup {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_key_group_input::Builder,
    }
    impl GetKeyGroup {
        /// Creates a new `GetKeyGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetKeyGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::GetKeyGroupError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the key group that you are getting. To get the identifier, use <code>ListKeyGroups</code>.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// <p>The identifier of the key group that you are getting. To get the identifier, use <code>ListKeyGroups</code>.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetKeyGroupConfig`.
    ///
    /// <p>Gets a key group configuration.</p>
    /// <p>To get a key group configuration, you must provide the key group’s identifier. If the key group is referenced in a distribution’s cache behavior, you can get the key group’s identifier using <code>ListDistributions</code> or <code>GetDistribution</code>. If the key group is not referenced in a cache behavior, you can get the identifier using <code>ListKeyGroups</code>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetKeyGroupConfig {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_key_group_config_input::Builder,
    }
    impl GetKeyGroupConfig {
        /// Creates a new `GetKeyGroupConfig`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetKeyGroupConfigOutput,
            aws_smithy_http::result::SdkError<crate::error::GetKeyGroupConfigError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the key group whose configuration you are getting. To get the identifier, use <code>ListKeyGroups</code>.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// <p>The identifier of the key group whose configuration you are getting. To get the identifier, use <code>ListKeyGroups</code>.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetMonitoringSubscription`.
    ///
    /// <p>Gets information about whether additional CloudWatch metrics are enabled for the specified CloudFront distribution.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetMonitoringSubscription {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_monitoring_subscription_input::Builder,
    }
    impl GetMonitoringSubscription {
        /// Creates a new `GetMonitoringSubscription`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetMonitoringSubscriptionOutput,
            aws_smithy_http::result::SdkError<crate::error::GetMonitoringSubscriptionError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the distribution that you are getting metrics information for.</p>
        pub fn distribution_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.distribution_id(input.into());
            self
        }
        /// <p>The ID of the distribution that you are getting metrics information for.</p>
        pub fn set_distribution_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_distribution_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetOriginRequestPolicy`.
    ///
    /// <p>Gets an origin request policy, including the following metadata:</p>
    /// <ul>
    /// <li> <p>The policy’s identifier.</p> </li>
    /// <li> <p>The date and time when the policy was last modified.</p> </li>
    /// </ul>
    /// <p>To get an origin request policy, you must provide the policy’s identifier. If the origin request policy is attached to a distribution’s cache behavior, you can get the policy’s identifier using <code>ListDistributions</code> or <code>GetDistribution</code>. If the origin request policy is not attached to a cache behavior, you can get the identifier using <code>ListOriginRequestPolicies</code>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetOriginRequestPolicy {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_origin_request_policy_input::Builder,
    }
    impl GetOriginRequestPolicy {
        /// Creates a new `GetOriginRequestPolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetOriginRequestPolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::GetOriginRequestPolicyError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier for the origin request policy. If the origin request policy is attached to a distribution’s cache behavior, you can get the policy’s identifier using <code>ListDistributions</code> or <code>GetDistribution</code>. If the origin request policy is not attached to a cache behavior, you can get the identifier using <code>ListOriginRequestPolicies</code>.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// <p>The unique identifier for the origin request policy. If the origin request policy is attached to a distribution’s cache behavior, you can get the policy’s identifier using <code>ListDistributions</code> or <code>GetDistribution</code>. If the origin request policy is not attached to a cache behavior, you can get the identifier using <code>ListOriginRequestPolicies</code>.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetOriginRequestPolicyConfig`.
    ///
    /// <p>Gets an origin request policy configuration.</p>
    /// <p>To get an origin request policy configuration, you must provide the policy’s identifier. If the origin request policy is attached to a distribution’s cache behavior, you can get the policy’s identifier using <code>ListDistributions</code> or <code>GetDistribution</code>. If the origin request policy is not attached to a cache behavior, you can get the identifier using <code>ListOriginRequestPolicies</code>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetOriginRequestPolicyConfig {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_origin_request_policy_config_input::Builder,
    }
    impl GetOriginRequestPolicyConfig {
        /// Creates a new `GetOriginRequestPolicyConfig`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetOriginRequestPolicyConfigOutput,
            aws_smithy_http::result::SdkError<crate::error::GetOriginRequestPolicyConfigError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier for the origin request policy. If the origin request policy is attached to a distribution’s cache behavior, you can get the policy’s identifier using <code>ListDistributions</code> or <code>GetDistribution</code>. If the origin request policy is not attached to a cache behavior, you can get the identifier using <code>ListOriginRequestPolicies</code>.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// <p>The unique identifier for the origin request policy. If the origin request policy is attached to a distribution’s cache behavior, you can get the policy’s identifier using <code>ListDistributions</code> or <code>GetDistribution</code>. If the origin request policy is not attached to a cache behavior, you can get the identifier using <code>ListOriginRequestPolicies</code>.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetPublicKey`.
    ///
    /// <p>Gets a public key.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetPublicKey {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_public_key_input::Builder,
    }
    impl GetPublicKey {
        /// Creates a new `GetPublicKey`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetPublicKeyOutput,
            aws_smithy_http::result::SdkError<crate::error::GetPublicKeyError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the public key you are getting.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// <p>The identifier of the public key you are getting.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetPublicKeyConfig`.
    ///
    /// <p>Gets a public key configuration.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetPublicKeyConfig {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_public_key_config_input::Builder,
    }
    impl GetPublicKeyConfig {
        /// Creates a new `GetPublicKeyConfig`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetPublicKeyConfigOutput,
            aws_smithy_http::result::SdkError<crate::error::GetPublicKeyConfigError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the public key whose configuration you are getting.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// <p>The identifier of the public key whose configuration you are getting.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetRealtimeLogConfig`.
    ///
    /// <p>Gets a real-time log configuration.</p>
    /// <p>To get a real-time log configuration, you can provide the configuration’s name or its Amazon Resource Name (ARN). You must provide at least one. If you provide both, CloudFront uses the name to identify the real-time log configuration to get.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetRealtimeLogConfig {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_realtime_log_config_input::Builder,
    }
    impl GetRealtimeLogConfig {
        /// Creates a new `GetRealtimeLogConfig`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetRealtimeLogConfigOutput,
            aws_smithy_http::result::SdkError<crate::error::GetRealtimeLogConfigError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the real-time log configuration to get.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the real-time log configuration to get.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the real-time log configuration to get.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the real-time log configuration to get.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetResponseHeadersPolicy`.
    ///
    /// <p>Gets a response headers policy, including metadata (the policy’s identifier and the date and time when the policy was last modified).</p>
    /// <p>To get a response headers policy, you must provide the policy’s identifier. If the response headers policy is attached to a distribution’s cache behavior, you can get the policy’s identifier using <code>ListDistributions</code> or <code>GetDistribution</code>. If the response headers policy is not attached to a cache behavior, you can get the identifier using <code>ListResponseHeadersPolicies</code>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetResponseHeadersPolicy {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_response_headers_policy_input::Builder,
    }
    impl GetResponseHeadersPolicy {
        /// Creates a new `GetResponseHeadersPolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetResponseHeadersPolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::GetResponseHeadersPolicyError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier for the response headers policy.</p>
        /// <p>If the response headers policy is attached to a distribution’s cache behavior, you can get the policy’s identifier using <code>ListDistributions</code> or <code>GetDistribution</code>. If the response headers policy is not attached to a cache behavior, you can get the identifier using <code>ListResponseHeadersPolicies</code>.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// <p>The identifier for the response headers policy.</p>
        /// <p>If the response headers policy is attached to a distribution’s cache behavior, you can get the policy’s identifier using <code>ListDistributions</code> or <code>GetDistribution</code>. If the response headers policy is not attached to a cache behavior, you can get the identifier using <code>ListResponseHeadersPolicies</code>.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetResponseHeadersPolicyConfig`.
    ///
    /// <p>Gets a response headers policy configuration.</p>
    /// <p>To get a response headers policy configuration, you must provide the policy’s identifier. If the response headers policy is attached to a distribution’s cache behavior, you can get the policy’s identifier using <code>ListDistributions</code> or <code>GetDistribution</code>. If the response headers policy is not attached to a cache behavior, you can get the identifier using <code>ListResponseHeadersPolicies</code>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetResponseHeadersPolicyConfig {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_response_headers_policy_config_input::Builder,
    }
    impl GetResponseHeadersPolicyConfig {
        /// Creates a new `GetResponseHeadersPolicyConfig`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetResponseHeadersPolicyConfigOutput,
            aws_smithy_http::result::SdkError<crate::error::GetResponseHeadersPolicyConfigError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier for the response headers policy.</p>
        /// <p>If the response headers policy is attached to a distribution’s cache behavior, you can get the policy’s identifier using <code>ListDistributions</code> or <code>GetDistribution</code>. If the response headers policy is not attached to a cache behavior, you can get the identifier using <code>ListResponseHeadersPolicies</code>.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// <p>The identifier for the response headers policy.</p>
        /// <p>If the response headers policy is attached to a distribution’s cache behavior, you can get the policy’s identifier using <code>ListDistributions</code> or <code>GetDistribution</code>. If the response headers policy is not attached to a cache behavior, you can get the identifier using <code>ListResponseHeadersPolicies</code>.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetStreamingDistribution`.
    ///
    /// <p>Gets information about a specified RTMP distribution, including the distribution configuration.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetStreamingDistribution {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_streaming_distribution_input::Builder,
    }
    impl GetStreamingDistribution {
        /// Creates a new `GetStreamingDistribution`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetStreamingDistributionOutput,
            aws_smithy_http::result::SdkError<crate::error::GetStreamingDistributionError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The streaming distribution's ID.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// <p>The streaming distribution's ID.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetStreamingDistributionConfig`.
    ///
    /// <p>Get the configuration information about a streaming distribution. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetStreamingDistributionConfig {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_streaming_distribution_config_input::Builder,
    }
    impl GetStreamingDistributionConfig {
        /// Creates a new `GetStreamingDistributionConfig`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetStreamingDistributionConfigOutput,
            aws_smithy_http::result::SdkError<crate::error::GetStreamingDistributionConfigError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The streaming distribution's ID.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// <p>The streaming distribution's ID.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListCachePolicies`.
    ///
    /// <p>Gets a list of cache policies.</p>
    /// <p>You can optionally apply a filter to return only the managed policies created by Amazon Web Services, or only the custom policies created in your Amazon Web Services account.</p>
    /// <p>You can optionally specify the maximum number of items to receive in the response. If the total number of items in the list exceeds the maximum that you specify, or the default maximum, the response is paginated. To get the next page of items, send a subsequent request that specifies the <code>NextMarker</code> value from the current response as the <code>Marker</code> value in the subsequent request.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListCachePolicies {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_cache_policies_input::Builder,
    }
    impl ListCachePolicies {
        /// Creates a new `ListCachePolicies`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListCachePoliciesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListCachePoliciesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A filter to return only the specified kinds of cache policies. Valid values are:</p>
        /// <ul>
        /// <li> <p> <code>managed</code> – Returns only the managed policies created by Amazon Web Services.</p> </li>
        /// <li> <p> <code>custom</code> – Returns only the custom policies created in your Amazon Web Services account.</p> </li>
        /// </ul>
        pub fn r#type(mut self, input: crate::model::CachePolicyType) -> Self {
            self.inner = self.inner.r#type(input);
            self
        }
        /// <p>A filter to return only the specified kinds of cache policies. Valid values are:</p>
        /// <ul>
        /// <li> <p> <code>managed</code> – Returns only the managed policies created by Amazon Web Services.</p> </li>
        /// <li> <p> <code>custom</code> – Returns only the custom policies created in your Amazon Web Services account.</p> </li>
        /// </ul>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::CachePolicyType>,
        ) -> Self {
            self.inner = self.inner.set_type(input);
            self
        }
        /// <p>Use this field when paginating results to indicate where to begin in your list of cache policies. The response includes cache policies in the list that occur after the marker. To get the next page of the list, set this field’s value to the value of <code>NextMarker</code> from the current page’s response.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(input.into());
            self
        }
        /// <p>Use this field when paginating results to indicate where to begin in your list of cache policies. The response includes cache policies in the list that occur after the marker. To get the next page of the list, set this field’s value to the value of <code>NextMarker</code> from the current page’s response.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
        /// <p>The maximum number of cache policies that you want in the response.</p>
        pub fn max_items(mut self, input: i32) -> Self {
            self.inner = self.inner.max_items(input);
            self
        }
        /// <p>The maximum number of cache policies that you want in the response.</p>
        pub fn set_max_items(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_items(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListCloudFrontOriginAccessIdentities`.
    ///
    /// <p>Lists origin access identities.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListCloudFrontOriginAccessIdentities {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_cloud_front_origin_access_identities_input::Builder,
    }
    impl ListCloudFrontOriginAccessIdentities {
        /// Creates a new `ListCloudFrontOriginAccessIdentities`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListCloudFrontOriginAccessIdentitiesOutput,
            aws_smithy_http::result::SdkError<
                crate::error::ListCloudFrontOriginAccessIdentitiesError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListCloudFrontOriginAccessIdentitiesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(
            self,
        ) -> crate::paginator::ListCloudFrontOriginAccessIdentitiesPaginator {
            crate::paginator::ListCloudFrontOriginAccessIdentitiesPaginator::new(
                self.handle,
                self.inner,
            )
        }
        /// <p>Use this when paginating results to indicate where to begin in your list of origin access identities. The results include identities in the list that occur after the marker. To get the next page of results, set the <code>Marker</code> to the value of the <code>NextMarker</code> from the current page's response (which is also the ID of the last identity on that page).</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(input.into());
            self
        }
        /// <p>Use this when paginating results to indicate where to begin in your list of origin access identities. The results include identities in the list that occur after the marker. To get the next page of results, set the <code>Marker</code> to the value of the <code>NextMarker</code> from the current page's response (which is also the ID of the last identity on that page).</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
        /// <p>The maximum number of origin access identities you want in the response body. </p>
        pub fn max_items(mut self, input: i32) -> Self {
            self.inner = self.inner.max_items(input);
            self
        }
        /// <p>The maximum number of origin access identities you want in the response body. </p>
        pub fn set_max_items(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_items(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListConflictingAliases`.
    ///
    /// <p>Gets a list of aliases (also called CNAMEs or alternate domain names) that conflict or overlap with the provided alias, and the associated CloudFront distributions and Amazon Web Services accounts for each conflicting alias. In the returned list, the distribution and account IDs are partially hidden, which allows you to identify the distributions and accounts that you own, but helps to protect the information of ones that you don’t own.</p>
    /// <p>Use this operation to find aliases that are in use in CloudFront that conflict or overlap with the provided alias. For example, if you provide <code>www.example.com</code> as input, the returned list can include <code>www.example.com</code> and the overlapping wildcard alternate domain name (<code>*.example.com</code>), if they exist. If you provide <code>*.example.com</code> as input, the returned list can include <code>*.example.com</code> and any alternate domain names covered by that wildcard (for example, <code>www.example.com</code>, <code>test.example.com</code>, <code>dev.example.com</code>, and so on), if they exist.</p>
    /// <p>To list conflicting aliases, you provide the alias to search and the ID of a distribution in your account that has an attached SSL/TLS certificate that includes the provided alias. For more information, including how to set up the distribution and certificate, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/CNAMEs.html#alternate-domain-names-move">Moving an alternate domain name to a different distribution</a> in the <i>Amazon CloudFront Developer Guide</i>.</p>
    /// <p>You can optionally specify the maximum number of items to receive in the response. If the total number of items in the list exceeds the maximum that you specify, or the default maximum, the response is paginated. To get the next page of items, send a subsequent request that specifies the <code>NextMarker</code> value from the current response as the <code>Marker</code> value in the subsequent request.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListConflictingAliases {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_conflicting_aliases_input::Builder,
    }
    impl ListConflictingAliases {
        /// Creates a new `ListConflictingAliases`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListConflictingAliasesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListConflictingAliasesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of a distribution in your account that has an attached SSL/TLS certificate that includes the provided alias.</p>
        pub fn distribution_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.distribution_id(input.into());
            self
        }
        /// <p>The ID of a distribution in your account that has an attached SSL/TLS certificate that includes the provided alias.</p>
        pub fn set_distribution_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_distribution_id(input);
            self
        }
        /// <p>The alias (also called a CNAME) to search for conflicting aliases.</p>
        pub fn alias(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.alias(input.into());
            self
        }
        /// <p>The alias (also called a CNAME) to search for conflicting aliases.</p>
        pub fn set_alias(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_alias(input);
            self
        }
        /// <p>Use this field when paginating results to indicate where to begin in the list of conflicting aliases. The response includes conflicting aliases in the list that occur after the marker. To get the next page of the list, set this field’s value to the value of <code>NextMarker</code> from the current page’s response.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(input.into());
            self
        }
        /// <p>Use this field when paginating results to indicate where to begin in the list of conflicting aliases. The response includes conflicting aliases in the list that occur after the marker. To get the next page of the list, set this field’s value to the value of <code>NextMarker</code> from the current page’s response.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
        /// <p>The maximum number of conflicting aliases that you want in the response.</p>
        pub fn max_items(mut self, input: i32) -> Self {
            self.inner = self.inner.max_items(input);
            self
        }
        /// <p>The maximum number of conflicting aliases that you want in the response.</p>
        pub fn set_max_items(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_items(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListDistributions`.
    ///
    /// <p>List CloudFront distributions.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListDistributions {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_distributions_input::Builder,
    }
    impl ListDistributions {
        /// Creates a new `ListDistributions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListDistributionsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListDistributionsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListDistributionsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListDistributionsPaginator {
            crate::paginator::ListDistributionsPaginator::new(self.handle, self.inner)
        }
        /// <p>Use this when paginating results to indicate where to begin in your list of distributions. The results include distributions in the list that occur after the marker. To get the next page of results, set the <code>Marker</code> to the value of the <code>NextMarker</code> from the current page's response (which is also the ID of the last distribution on that page).</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(input.into());
            self
        }
        /// <p>Use this when paginating results to indicate where to begin in your list of distributions. The results include distributions in the list that occur after the marker. To get the next page of results, set the <code>Marker</code> to the value of the <code>NextMarker</code> from the current page's response (which is also the ID of the last distribution on that page).</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
        /// <p>The maximum number of distributions you want in the response body.</p>
        pub fn max_items(mut self, input: i32) -> Self {
            self.inner = self.inner.max_items(input);
            self
        }
        /// <p>The maximum number of distributions you want in the response body.</p>
        pub fn set_max_items(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_items(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListDistributionsByCachePolicyId`.
    ///
    /// <p>Gets a list of distribution IDs for distributions that have a cache behavior that’s associated with the specified cache policy.</p>
    /// <p>You can optionally specify the maximum number of items to receive in the response. If the total number of items in the list exceeds the maximum that you specify, or the default maximum, the response is paginated. To get the next page of items, send a subsequent request that specifies the <code>NextMarker</code> value from the current response as the <code>Marker</code> value in the subsequent request.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListDistributionsByCachePolicyId {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_distributions_by_cache_policy_id_input::Builder,
    }
    impl ListDistributionsByCachePolicyId {
        /// Creates a new `ListDistributionsByCachePolicyId`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListDistributionsByCachePolicyIdOutput,
            aws_smithy_http::result::SdkError<crate::error::ListDistributionsByCachePolicyIdError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Use this field when paginating results to indicate where to begin in your list of distribution IDs. The response includes distribution IDs in the list that occur after the marker. To get the next page of the list, set this field’s value to the value of <code>NextMarker</code> from the current page’s response.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(input.into());
            self
        }
        /// <p>Use this field when paginating results to indicate where to begin in your list of distribution IDs. The response includes distribution IDs in the list that occur after the marker. To get the next page of the list, set this field’s value to the value of <code>NextMarker</code> from the current page’s response.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
        /// <p>The maximum number of distribution IDs that you want in the response.</p>
        pub fn max_items(mut self, input: i32) -> Self {
            self.inner = self.inner.max_items(input);
            self
        }
        /// <p>The maximum number of distribution IDs that you want in the response.</p>
        pub fn set_max_items(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_items(input);
            self
        }
        /// <p>The ID of the cache policy whose associated distribution IDs you want to list.</p>
        pub fn cache_policy_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cache_policy_id(input.into());
            self
        }
        /// <p>The ID of the cache policy whose associated distribution IDs you want to list.</p>
        pub fn set_cache_policy_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_cache_policy_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListDistributionsByKeyGroup`.
    ///
    /// <p>Gets a list of distribution IDs for distributions that have a cache behavior that references the specified key group.</p>
    /// <p>You can optionally specify the maximum number of items to receive in the response. If the total number of items in the list exceeds the maximum that you specify, or the default maximum, the response is paginated. To get the next page of items, send a subsequent request that specifies the <code>NextMarker</code> value from the current response as the <code>Marker</code> value in the subsequent request.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListDistributionsByKeyGroup {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_distributions_by_key_group_input::Builder,
    }
    impl ListDistributionsByKeyGroup {
        /// Creates a new `ListDistributionsByKeyGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListDistributionsByKeyGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::ListDistributionsByKeyGroupError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Use this field when paginating results to indicate where to begin in your list of distribution IDs. The response includes distribution IDs in the list that occur after the marker. To get the next page of the list, set this field’s value to the value of <code>NextMarker</code> from the current page’s response.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(input.into());
            self
        }
        /// <p>Use this field when paginating results to indicate where to begin in your list of distribution IDs. The response includes distribution IDs in the list that occur after the marker. To get the next page of the list, set this field’s value to the value of <code>NextMarker</code> from the current page’s response.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
        /// <p>The maximum number of distribution IDs that you want in the response.</p>
        pub fn max_items(mut self, input: i32) -> Self {
            self.inner = self.inner.max_items(input);
            self
        }
        /// <p>The maximum number of distribution IDs that you want in the response.</p>
        pub fn set_max_items(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_items(input);
            self
        }
        /// <p>The ID of the key group whose associated distribution IDs you are listing.</p>
        pub fn key_group_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.key_group_id(input.into());
            self
        }
        /// <p>The ID of the key group whose associated distribution IDs you are listing.</p>
        pub fn set_key_group_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_key_group_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListDistributionsByOriginRequestPolicyId`.
    ///
    /// <p>Gets a list of distribution IDs for distributions that have a cache behavior that’s associated with the specified origin request policy.</p>
    /// <p>You can optionally specify the maximum number of items to receive in the response. If the total number of items in the list exceeds the maximum that you specify, or the default maximum, the response is paginated. To get the next page of items, send a subsequent request that specifies the <code>NextMarker</code> value from the current response as the <code>Marker</code> value in the subsequent request.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListDistributionsByOriginRequestPolicyId {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_distributions_by_origin_request_policy_id_input::Builder,
    }
    impl ListDistributionsByOriginRequestPolicyId {
        /// Creates a new `ListDistributionsByOriginRequestPolicyId`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListDistributionsByOriginRequestPolicyIdOutput,
            aws_smithy_http::result::SdkError<
                crate::error::ListDistributionsByOriginRequestPolicyIdError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Use this field when paginating results to indicate where to begin in your list of distribution IDs. The response includes distribution IDs in the list that occur after the marker. To get the next page of the list, set this field’s value to the value of <code>NextMarker</code> from the current page’s response.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(input.into());
            self
        }
        /// <p>Use this field when paginating results to indicate where to begin in your list of distribution IDs. The response includes distribution IDs in the list that occur after the marker. To get the next page of the list, set this field’s value to the value of <code>NextMarker</code> from the current page’s response.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
        /// <p>The maximum number of distribution IDs that you want in the response.</p>
        pub fn max_items(mut self, input: i32) -> Self {
            self.inner = self.inner.max_items(input);
            self
        }
        /// <p>The maximum number of distribution IDs that you want in the response.</p>
        pub fn set_max_items(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_items(input);
            self
        }
        /// <p>The ID of the origin request policy whose associated distribution IDs you want to list.</p>
        pub fn origin_request_policy_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.origin_request_policy_id(input.into());
            self
        }
        /// <p>The ID of the origin request policy whose associated distribution IDs you want to list.</p>
        pub fn set_origin_request_policy_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_origin_request_policy_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListDistributionsByRealtimeLogConfig`.
    ///
    /// <p>Gets a list of distributions that have a cache behavior that’s associated with the specified real-time log configuration.</p>
    /// <p>You can specify the real-time log configuration by its name or its Amazon Resource Name (ARN). You must provide at least one. If you provide both, CloudFront uses the name to identify the real-time log configuration to list distributions for.</p>
    /// <p>You can optionally specify the maximum number of items to receive in the response. If the total number of items in the list exceeds the maximum that you specify, or the default maximum, the response is paginated. To get the next page of items, send a subsequent request that specifies the <code>NextMarker</code> value from the current response as the <code>Marker</code> value in the subsequent request. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListDistributionsByRealtimeLogConfig {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_distributions_by_realtime_log_config_input::Builder,
    }
    impl ListDistributionsByRealtimeLogConfig {
        /// Creates a new `ListDistributionsByRealtimeLogConfig`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListDistributionsByRealtimeLogConfigOutput,
            aws_smithy_http::result::SdkError<
                crate::error::ListDistributionsByRealtimeLogConfigError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Use this field when paginating results to indicate where to begin in your list of distributions. The response includes distributions in the list that occur after the marker. To get the next page of the list, set this field’s value to the value of <code>NextMarker</code> from the current page’s response.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(input.into());
            self
        }
        /// <p>Use this field when paginating results to indicate where to begin in your list of distributions. The response includes distributions in the list that occur after the marker. To get the next page of the list, set this field’s value to the value of <code>NextMarker</code> from the current page’s response.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
        /// <p>The maximum number of distributions that you want in the response.</p>
        pub fn max_items(mut self, input: i32) -> Self {
            self.inner = self.inner.max_items(input);
            self
        }
        /// <p>The maximum number of distributions that you want in the response.</p>
        pub fn set_max_items(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_items(input);
            self
        }
        /// <p>The name of the real-time log configuration whose associated distributions you want to list.</p>
        pub fn realtime_log_config_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.realtime_log_config_name(input.into());
            self
        }
        /// <p>The name of the real-time log configuration whose associated distributions you want to list.</p>
        pub fn set_realtime_log_config_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_realtime_log_config_name(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the real-time log configuration whose associated distributions you want to list.</p>
        pub fn realtime_log_config_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.realtime_log_config_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the real-time log configuration whose associated distributions you want to list.</p>
        pub fn set_realtime_log_config_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_realtime_log_config_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListDistributionsByResponseHeadersPolicyId`.
    ///
    /// <p>Gets a list of distribution IDs for distributions that have a cache behavior that’s associated with the specified response headers policy.</p>
    /// <p>You can optionally specify the maximum number of items to receive in the response. If the total number of items in the list exceeds the maximum that you specify, or the default maximum, the response is paginated. To get the next page of items, send a subsequent request that specifies the <code>NextMarker</code> value from the current response as the <code>Marker</code> value in the subsequent request.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListDistributionsByResponseHeadersPolicyId {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_distributions_by_response_headers_policy_id_input::Builder,
    }
    impl ListDistributionsByResponseHeadersPolicyId {
        /// Creates a new `ListDistributionsByResponseHeadersPolicyId`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListDistributionsByResponseHeadersPolicyIdOutput,
            aws_smithy_http::result::SdkError<
                crate::error::ListDistributionsByResponseHeadersPolicyIdError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Use this field when paginating results to indicate where to begin in your list of distribution IDs. The response includes distribution IDs in the list that occur after the marker. To get the next page of the list, set this field’s value to the value of <code>NextMarker</code> from the current page’s response.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(input.into());
            self
        }
        /// <p>Use this field when paginating results to indicate where to begin in your list of distribution IDs. The response includes distribution IDs in the list that occur after the marker. To get the next page of the list, set this field’s value to the value of <code>NextMarker</code> from the current page’s response.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
        /// <p>The maximum number of distribution IDs that you want to get in the response.</p>
        pub fn max_items(mut self, input: i32) -> Self {
            self.inner = self.inner.max_items(input);
            self
        }
        /// <p>The maximum number of distribution IDs that you want to get in the response.</p>
        pub fn set_max_items(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_items(input);
            self
        }
        /// <p>The ID of the response headers policy whose associated distribution IDs you want to list.</p>
        pub fn response_headers_policy_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.response_headers_policy_id(input.into());
            self
        }
        /// <p>The ID of the response headers policy whose associated distribution IDs you want to list.</p>
        pub fn set_response_headers_policy_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_response_headers_policy_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListDistributionsByWebACLId`.
    ///
    /// <p>List the distributions that are associated with a specified WAF web ACL.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListDistributionsByWebACLId {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_distributions_by_web_acl_id_input::Builder,
    }
    impl ListDistributionsByWebACLId {
        /// Creates a new `ListDistributionsByWebACLId`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListDistributionsByWebAclIdOutput,
            aws_smithy_http::result::SdkError<crate::error::ListDistributionsByWebACLIdError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Use <code>Marker</code> and <code>MaxItems</code> to control pagination of results. If you have more than <code>MaxItems</code> distributions that satisfy the request, the response includes a <code>NextMarker</code> element. To get the next page of results, submit another request. For the value of <code>Marker</code>, specify the value of <code>NextMarker</code> from the last response. (For the first request, omit <code>Marker</code>.) </p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(input.into());
            self
        }
        /// <p>Use <code>Marker</code> and <code>MaxItems</code> to control pagination of results. If you have more than <code>MaxItems</code> distributions that satisfy the request, the response includes a <code>NextMarker</code> element. To get the next page of results, submit another request. For the value of <code>Marker</code>, specify the value of <code>NextMarker</code> from the last response. (For the first request, omit <code>Marker</code>.) </p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
        /// <p>The maximum number of distributions that you want CloudFront to return in the response body. The maximum and default values are both 100.</p>
        pub fn max_items(mut self, input: i32) -> Self {
            self.inner = self.inner.max_items(input);
            self
        }
        /// <p>The maximum number of distributions that you want CloudFront to return in the response body. The maximum and default values are both 100.</p>
        pub fn set_max_items(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_items(input);
            self
        }
        /// <p>The ID of the WAF web ACL that you want to list the associated distributions. If you specify "null" for the ID, the request returns a list of the distributions that aren't associated with a web ACL.</p>
        pub fn web_acl_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.web_acl_id(input.into());
            self
        }
        /// <p>The ID of the WAF web ACL that you want to list the associated distributions. If you specify "null" for the ID, the request returns a list of the distributions that aren't associated with a web ACL.</p>
        pub fn set_web_acl_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_web_acl_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListFieldLevelEncryptionConfigs`.
    ///
    /// <p>List all field-level encryption configurations that have been created in CloudFront for this account.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListFieldLevelEncryptionConfigs {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_field_level_encryption_configs_input::Builder,
    }
    impl ListFieldLevelEncryptionConfigs {
        /// Creates a new `ListFieldLevelEncryptionConfigs`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListFieldLevelEncryptionConfigsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListFieldLevelEncryptionConfigsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Use this when paginating results to indicate where to begin in your list of configurations. The results include configurations in the list that occur after the marker. To get the next page of results, set the <code>Marker</code> to the value of the <code>NextMarker</code> from the current page's response (which is also the ID of the last configuration on that page). </p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(input.into());
            self
        }
        /// <p>Use this when paginating results to indicate where to begin in your list of configurations. The results include configurations in the list that occur after the marker. To get the next page of results, set the <code>Marker</code> to the value of the <code>NextMarker</code> from the current page's response (which is also the ID of the last configuration on that page). </p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
        /// <p>The maximum number of field-level encryption configurations you want in the response body. </p>
        pub fn max_items(mut self, input: i32) -> Self {
            self.inner = self.inner.max_items(input);
            self
        }
        /// <p>The maximum number of field-level encryption configurations you want in the response body. </p>
        pub fn set_max_items(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_items(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListFieldLevelEncryptionProfiles`.
    ///
    /// <p>Request a list of field-level encryption profiles that have been created in CloudFront for this account.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListFieldLevelEncryptionProfiles {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_field_level_encryption_profiles_input::Builder,
    }
    impl ListFieldLevelEncryptionProfiles {
        /// Creates a new `ListFieldLevelEncryptionProfiles`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListFieldLevelEncryptionProfilesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListFieldLevelEncryptionProfilesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Use this when paginating results to indicate where to begin in your list of profiles. The results include profiles in the list that occur after the marker. To get the next page of results, set the <code>Marker</code> to the value of the <code>NextMarker</code> from the current page's response (which is also the ID of the last profile on that page). </p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(input.into());
            self
        }
        /// <p>Use this when paginating results to indicate where to begin in your list of profiles. The results include profiles in the list that occur after the marker. To get the next page of results, set the <code>Marker</code> to the value of the <code>NextMarker</code> from the current page's response (which is also the ID of the last profile on that page). </p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
        /// <p>The maximum number of field-level encryption profiles you want in the response body. </p>
        pub fn max_items(mut self, input: i32) -> Self {
            self.inner = self.inner.max_items(input);
            self
        }
        /// <p>The maximum number of field-level encryption profiles you want in the response body. </p>
        pub fn set_max_items(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_items(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListFunctions`.
    ///
    /// <p>Gets a list of all CloudFront functions in your Amazon Web Services account.</p>
    /// <p>You can optionally apply a filter to return only the functions that are in the specified stage, either <code>DEVELOPMENT</code> or <code>LIVE</code>.</p>
    /// <p>You can optionally specify the maximum number of items to receive in the response. If the total number of items in the list exceeds the maximum that you specify, or the default maximum, the response is paginated. To get the next page of items, send a subsequent request that specifies the <code>NextMarker</code> value from the current response as the <code>Marker</code> value in the subsequent request.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListFunctions {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_functions_input::Builder,
    }
    impl ListFunctions {
        /// Creates a new `ListFunctions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListFunctionsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListFunctionsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Use this field when paginating results to indicate where to begin in your list of functions. The response includes functions in the list that occur after the marker. To get the next page of the list, set this field’s value to the value of <code>NextMarker</code> from the current page’s response.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(input.into());
            self
        }
        /// <p>Use this field when paginating results to indicate where to begin in your list of functions. The response includes functions in the list that occur after the marker. To get the next page of the list, set this field’s value to the value of <code>NextMarker</code> from the current page’s response.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
        /// <p>The maximum number of functions that you want in the response.</p>
        pub fn max_items(mut self, input: i32) -> Self {
            self.inner = self.inner.max_items(input);
            self
        }
        /// <p>The maximum number of functions that you want in the response.</p>
        pub fn set_max_items(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_items(input);
            self
        }
        /// <p>An optional filter to return only the functions that are in the specified stage, either <code>DEVELOPMENT</code> or <code>LIVE</code>.</p>
        pub fn stage(mut self, input: crate::model::FunctionStage) -> Self {
            self.inner = self.inner.stage(input);
            self
        }
        /// <p>An optional filter to return only the functions that are in the specified stage, either <code>DEVELOPMENT</code> or <code>LIVE</code>.</p>
        pub fn set_stage(
            mut self,
            input: std::option::Option<crate::model::FunctionStage>,
        ) -> Self {
            self.inner = self.inner.set_stage(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListInvalidations`.
    ///
    /// <p>Lists invalidation batches. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListInvalidations {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_invalidations_input::Builder,
    }
    impl ListInvalidations {
        /// Creates a new `ListInvalidations`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListInvalidationsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListInvalidationsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListInvalidationsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListInvalidationsPaginator {
            crate::paginator::ListInvalidationsPaginator::new(self.handle, self.inner)
        }
        /// <p>The distribution's ID.</p>
        pub fn distribution_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.distribution_id(input.into());
            self
        }
        /// <p>The distribution's ID.</p>
        pub fn set_distribution_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_distribution_id(input);
            self
        }
        /// <p>Use this parameter when paginating results to indicate where to begin in your list of invalidation batches. Because the results are returned in decreasing order from most recent to oldest, the most recent results are on the first page, the second page will contain earlier results, and so on. To get the next page of results, set <code>Marker</code> to the value of the <code>NextMarker</code> from the current page's response. This value is the same as the ID of the last invalidation batch on that page. </p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(input.into());
            self
        }
        /// <p>Use this parameter when paginating results to indicate where to begin in your list of invalidation batches. Because the results are returned in decreasing order from most recent to oldest, the most recent results are on the first page, the second page will contain earlier results, and so on. To get the next page of results, set <code>Marker</code> to the value of the <code>NextMarker</code> from the current page's response. This value is the same as the ID of the last invalidation batch on that page. </p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
        /// <p>The maximum number of invalidation batches that you want in the response body.</p>
        pub fn max_items(mut self, input: i32) -> Self {
            self.inner = self.inner.max_items(input);
            self
        }
        /// <p>The maximum number of invalidation batches that you want in the response body.</p>
        pub fn set_max_items(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_items(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListKeyGroups`.
    ///
    /// <p>Gets a list of key groups.</p>
    /// <p>You can optionally specify the maximum number of items to receive in the response. If the total number of items in the list exceeds the maximum that you specify, or the default maximum, the response is paginated. To get the next page of items, send a subsequent request that specifies the <code>NextMarker</code> value from the current response as the <code>Marker</code> value in the subsequent request.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListKeyGroups {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_key_groups_input::Builder,
    }
    impl ListKeyGroups {
        /// Creates a new `ListKeyGroups`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListKeyGroupsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListKeyGroupsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Use this field when paginating results to indicate where to begin in your list of key groups. The response includes key groups in the list that occur after the marker. To get the next page of the list, set this field’s value to the value of <code>NextMarker</code> from the current page’s response.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(input.into());
            self
        }
        /// <p>Use this field when paginating results to indicate where to begin in your list of key groups. The response includes key groups in the list that occur after the marker. To get the next page of the list, set this field’s value to the value of <code>NextMarker</code> from the current page’s response.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
        /// <p>The maximum number of key groups that you want in the response.</p>
        pub fn max_items(mut self, input: i32) -> Self {
            self.inner = self.inner.max_items(input);
            self
        }
        /// <p>The maximum number of key groups that you want in the response.</p>
        pub fn set_max_items(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_items(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListOriginRequestPolicies`.
    ///
    /// <p>Gets a list of origin request policies.</p>
    /// <p>You can optionally apply a filter to return only the managed policies created by Amazon Web Services, or only the custom policies created in your Amazon Web Services account.</p>
    /// <p>You can optionally specify the maximum number of items to receive in the response. If the total number of items in the list exceeds the maximum that you specify, or the default maximum, the response is paginated. To get the next page of items, send a subsequent request that specifies the <code>NextMarker</code> value from the current response as the <code>Marker</code> value in the subsequent request.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListOriginRequestPolicies {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_origin_request_policies_input::Builder,
    }
    impl ListOriginRequestPolicies {
        /// Creates a new `ListOriginRequestPolicies`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListOriginRequestPoliciesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListOriginRequestPoliciesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A filter to return only the specified kinds of origin request policies. Valid values are:</p>
        /// <ul>
        /// <li> <p> <code>managed</code> – Returns only the managed policies created by Amazon Web Services.</p> </li>
        /// <li> <p> <code>custom</code> – Returns only the custom policies created in your Amazon Web Services account.</p> </li>
        /// </ul>
        pub fn r#type(mut self, input: crate::model::OriginRequestPolicyType) -> Self {
            self.inner = self.inner.r#type(input);
            self
        }
        /// <p>A filter to return only the specified kinds of origin request policies. Valid values are:</p>
        /// <ul>
        /// <li> <p> <code>managed</code> – Returns only the managed policies created by Amazon Web Services.</p> </li>
        /// <li> <p> <code>custom</code> – Returns only the custom policies created in your Amazon Web Services account.</p> </li>
        /// </ul>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::OriginRequestPolicyType>,
        ) -> Self {
            self.inner = self.inner.set_type(input);
            self
        }
        /// <p>Use this field when paginating results to indicate where to begin in your list of origin request policies. The response includes origin request policies in the list that occur after the marker. To get the next page of the list, set this field’s value to the value of <code>NextMarker</code> from the current page’s response.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(input.into());
            self
        }
        /// <p>Use this field when paginating results to indicate where to begin in your list of origin request policies. The response includes origin request policies in the list that occur after the marker. To get the next page of the list, set this field’s value to the value of <code>NextMarker</code> from the current page’s response.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
        /// <p>The maximum number of origin request policies that you want in the response.</p>
        pub fn max_items(mut self, input: i32) -> Self {
            self.inner = self.inner.max_items(input);
            self
        }
        /// <p>The maximum number of origin request policies that you want in the response.</p>
        pub fn set_max_items(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_items(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListPublicKeys`.
    ///
    /// <p>List all public keys that have been added to CloudFront for this account.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListPublicKeys {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_public_keys_input::Builder,
    }
    impl ListPublicKeys {
        /// Creates a new `ListPublicKeys`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListPublicKeysOutput,
            aws_smithy_http::result::SdkError<crate::error::ListPublicKeysError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Use this when paginating results to indicate where to begin in your list of public keys. The results include public keys in the list that occur after the marker. To get the next page of results, set the <code>Marker</code> to the value of the <code>NextMarker</code> from the current page's response (which is also the ID of the last public key on that page). </p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(input.into());
            self
        }
        /// <p>Use this when paginating results to indicate where to begin in your list of public keys. The results include public keys in the list that occur after the marker. To get the next page of results, set the <code>Marker</code> to the value of the <code>NextMarker</code> from the current page's response (which is also the ID of the last public key on that page). </p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
        /// <p>The maximum number of public keys you want in the response body. </p>
        pub fn max_items(mut self, input: i32) -> Self {
            self.inner = self.inner.max_items(input);
            self
        }
        /// <p>The maximum number of public keys you want in the response body. </p>
        pub fn set_max_items(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_items(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListRealtimeLogConfigs`.
    ///
    /// <p>Gets a list of real-time log configurations.</p>
    /// <p>You can optionally specify the maximum number of items to receive in the response. If the total number of items in the list exceeds the maximum that you specify, or the default maximum, the response is paginated. To get the next page of items, send a subsequent request that specifies the <code>NextMarker</code> value from the current response as the <code>Marker</code> value in the subsequent request. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListRealtimeLogConfigs {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_realtime_log_configs_input::Builder,
    }
    impl ListRealtimeLogConfigs {
        /// Creates a new `ListRealtimeLogConfigs`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListRealtimeLogConfigsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListRealtimeLogConfigsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The maximum number of real-time log configurations that you want in the response.</p>
        pub fn max_items(mut self, input: i32) -> Self {
            self.inner = self.inner.max_items(input);
            self
        }
        /// <p>The maximum number of real-time log configurations that you want in the response.</p>
        pub fn set_max_items(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_items(input);
            self
        }
        /// <p>Use this field when paginating results to indicate where to begin in your list of real-time log configurations. The response includes real-time log configurations in the list that occur after the marker. To get the next page of the list, set this field’s value to the value of <code>NextMarker</code> from the current page’s response.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(input.into());
            self
        }
        /// <p>Use this field when paginating results to indicate where to begin in your list of real-time log configurations. The response includes real-time log configurations in the list that occur after the marker. To get the next page of the list, set this field’s value to the value of <code>NextMarker</code> from the current page’s response.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListResponseHeadersPolicies`.
    ///
    /// <p>Gets a list of response headers policies.</p>
    /// <p>You can optionally apply a filter to get only the managed policies created by Amazon Web Services, or only the custom policies created in your Amazon Web Services account.</p>
    /// <p>You can optionally specify the maximum number of items to receive in the response. If the total number of items in the list exceeds the maximum that you specify, or the default maximum, the response is paginated. To get the next page of items, send a subsequent request that specifies the <code>NextMarker</code> value from the current response as the <code>Marker</code> value in the subsequent request.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListResponseHeadersPolicies {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_response_headers_policies_input::Builder,
    }
    impl ListResponseHeadersPolicies {
        /// Creates a new `ListResponseHeadersPolicies`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListResponseHeadersPoliciesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListResponseHeadersPoliciesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A filter to get only the specified kind of response headers policies. Valid values are:</p>
        /// <ul>
        /// <li> <p> <code>managed</code> – Gets only the managed policies created by Amazon Web Services.</p> </li>
        /// <li> <p> <code>custom</code> – Gets only the custom policies created in your Amazon Web Services account.</p> </li>
        /// </ul>
        pub fn r#type(mut self, input: crate::model::ResponseHeadersPolicyType) -> Self {
            self.inner = self.inner.r#type(input);
            self
        }
        /// <p>A filter to get only the specified kind of response headers policies. Valid values are:</p>
        /// <ul>
        /// <li> <p> <code>managed</code> – Gets only the managed policies created by Amazon Web Services.</p> </li>
        /// <li> <p> <code>custom</code> – Gets only the custom policies created in your Amazon Web Services account.</p> </li>
        /// </ul>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::ResponseHeadersPolicyType>,
        ) -> Self {
            self.inner = self.inner.set_type(input);
            self
        }
        /// <p>Use this field when paginating results to indicate where to begin in your list of response headers policies. The response includes response headers policies in the list that occur after the marker. To get the next page of the list, set this field’s value to the value of <code>NextMarker</code> from the current page’s response. </p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(input.into());
            self
        }
        /// <p>Use this field when paginating results to indicate where to begin in your list of response headers policies. The response includes response headers policies in the list that occur after the marker. To get the next page of the list, set this field’s value to the value of <code>NextMarker</code> from the current page’s response. </p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
        /// <p>The maximum number of response headers policies that you want to get in the response.</p>
        pub fn max_items(mut self, input: i32) -> Self {
            self.inner = self.inner.max_items(input);
            self
        }
        /// <p>The maximum number of response headers policies that you want to get in the response.</p>
        pub fn set_max_items(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_items(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListStreamingDistributions`.
    ///
    /// <p>List streaming distributions. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListStreamingDistributions {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_streaming_distributions_input::Builder,
    }
    impl ListStreamingDistributions {
        /// Creates a new `ListStreamingDistributions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListStreamingDistributionsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListStreamingDistributionsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListStreamingDistributionsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListStreamingDistributionsPaginator {
            crate::paginator::ListStreamingDistributionsPaginator::new(self.handle, self.inner)
        }
        /// <p>The value that you provided for the <code>Marker</code> request parameter.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(input.into());
            self
        }
        /// <p>The value that you provided for the <code>Marker</code> request parameter.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
        /// <p>The value that you provided for the <code>MaxItems</code> request parameter.</p>
        pub fn max_items(mut self, input: i32) -> Self {
            self.inner = self.inner.max_items(input);
            self
        }
        /// <p>The value that you provided for the <code>MaxItems</code> request parameter.</p>
        pub fn set_max_items(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_items(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTagsForResource`.
    ///
    /// <p>List tags for a CloudFront resource.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListTagsForResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_tags_for_resource_input::Builder,
    }
    impl ListTagsForResource {
        /// Creates a new `ListTagsForResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTagsForResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTagsForResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> An ARN of a CloudFront resource.</p>
        pub fn resource(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource(input.into());
            self
        }
        /// <p> An ARN of a CloudFront resource.</p>
        pub fn set_resource(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PublishFunction`.
    ///
    /// <p>Publishes a CloudFront function by copying the function code from the <code>DEVELOPMENT</code> stage to <code>LIVE</code>. This automatically updates all cache behaviors that are using this function to use the newly published copy in the <code>LIVE</code> stage.</p>
    /// <p>When a function is published to the <code>LIVE</code> stage, you can attach the function to a distribution’s cache behavior, using the function’s Amazon Resource Name (ARN).</p>
    /// <p>To publish a function, you must provide the function’s name and version (<code>ETag</code> value). To get these values, you can use <code>ListFunctions</code> and <code>DescribeFunction</code>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct PublishFunction {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::publish_function_input::Builder,
    }
    impl PublishFunction {
        /// Creates a new `PublishFunction`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PublishFunctionOutput,
            aws_smithy_http::result::SdkError<crate::error::PublishFunctionError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the function that you are publishing.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the function that you are publishing.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The current version (<code>ETag</code> value) of the function that you are publishing, which you can get using <code>DescribeFunction</code>.</p>
        pub fn if_match(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.if_match(input.into());
            self
        }
        /// <p>The current version (<code>ETag</code> value) of the function that you are publishing, which you can get using <code>DescribeFunction</code>.</p>
        pub fn set_if_match(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_if_match(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TagResource`.
    ///
    /// <p>Add tags to a CloudFront resource.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct TagResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::tag_resource_input::Builder,
    }
    impl TagResource {
        /// Creates a new `TagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::TagResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> An ARN of a CloudFront resource.</p>
        pub fn resource(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource(input.into());
            self
        }
        /// <p> An ARN of a CloudFront resource.</p>
        pub fn set_resource(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource(input);
            self
        }
        /// <p> A complex type that contains zero or more <code>Tag</code> elements.</p>
        pub fn tags(mut self, input: crate::model::Tags) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p> A complex type that contains zero or more <code>Tag</code> elements.</p>
        pub fn set_tags(mut self, input: std::option::Option<crate::model::Tags>) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TestFunction`.
    ///
    /// <p>Tests a CloudFront function.</p>
    /// <p>To test a function, you provide an <i>event object</i> that represents an HTTP request or response that your CloudFront distribution could receive in production. CloudFront runs the function, passing it the event object that you provided, and returns the function’s result (the modified event object) in the response. The response also contains function logs and error messages, if any exist. For more information about testing functions, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/managing-functions.html#test-function">Testing functions</a> in the <i>Amazon CloudFront Developer Guide</i>.</p>
    /// <p>To test a function, you provide the function’s name and version (<code>ETag</code> value) along with the event object. To get the function’s name and version, you can use <code>ListFunctions</code> and <code>DescribeFunction</code>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct TestFunction {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::test_function_input::Builder,
    }
    impl TestFunction {
        /// Creates a new `TestFunction`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TestFunctionOutput,
            aws_smithy_http::result::SdkError<crate::error::TestFunctionError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the function that you are testing.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the function that you are testing.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The current version (<code>ETag</code> value) of the function that you are testing, which you can get using <code>DescribeFunction</code>.</p>
        pub fn if_match(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.if_match(input.into());
            self
        }
        /// <p>The current version (<code>ETag</code> value) of the function that you are testing, which you can get using <code>DescribeFunction</code>.</p>
        pub fn set_if_match(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_if_match(input);
            self
        }
        /// <p>The stage of the function that you are testing, either <code>DEVELOPMENT</code> or <code>LIVE</code>.</p>
        pub fn stage(mut self, input: crate::model::FunctionStage) -> Self {
            self.inner = self.inner.stage(input);
            self
        }
        /// <p>The stage of the function that you are testing, either <code>DEVELOPMENT</code> or <code>LIVE</code>.</p>
        pub fn set_stage(
            mut self,
            input: std::option::Option<crate::model::FunctionStage>,
        ) -> Self {
            self.inner = self.inner.set_stage(input);
            self
        }
        /// <p>The event object to test the function with. For more information about the structure of the event object, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/managing-functions.html#test-function">Testing functions</a> in the <i>Amazon CloudFront Developer Guide</i>.</p>
        pub fn event_object(mut self, input: aws_smithy_types::Blob) -> Self {
            self.inner = self.inner.event_object(input);
            self
        }
        /// <p>The event object to test the function with. For more information about the structure of the event object, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/managing-functions.html#test-function">Testing functions</a> in the <i>Amazon CloudFront Developer Guide</i>.</p>
        pub fn set_event_object(
            mut self,
            input: std::option::Option<aws_smithy_types::Blob>,
        ) -> Self {
            self.inner = self.inner.set_event_object(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UntagResource`.
    ///
    /// <p>Remove tags from a CloudFront resource.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UntagResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::untag_resource_input::Builder,
    }
    impl UntagResource {
        /// Creates a new `UntagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UntagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::UntagResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> An ARN of a CloudFront resource.</p>
        pub fn resource(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource(input.into());
            self
        }
        /// <p> An ARN of a CloudFront resource.</p>
        pub fn set_resource(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource(input);
            self
        }
        /// <p> A complex type that contains zero or more <code>Tag</code> key elements.</p>
        pub fn tag_keys(mut self, input: crate::model::TagKeys) -> Self {
            self.inner = self.inner.tag_keys(input);
            self
        }
        /// <p> A complex type that contains zero or more <code>Tag</code> key elements.</p>
        pub fn set_tag_keys(mut self, input: std::option::Option<crate::model::TagKeys>) -> Self {
            self.inner = self.inner.set_tag_keys(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateCachePolicy`.
    ///
    /// <p>Updates a cache policy configuration.</p>
    /// <p>When you update a cache policy configuration, all the fields are updated with the values provided in the request. You cannot update some fields independent of others. To update a cache policy configuration:</p>
    /// <ol>
    /// <li> <p>Use <code>GetCachePolicyConfig</code> to get the current configuration.</p> </li>
    /// <li> <p>Locally modify the fields in the cache policy configuration that you want to update.</p> </li>
    /// <li> <p>Call <code>UpdateCachePolicy</code> by providing the entire cache policy configuration, including the fields that you modified and those that you didn’t.</p> </li>
    /// </ol>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateCachePolicy {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_cache_policy_input::Builder,
    }
    impl UpdateCachePolicy {
        /// Creates a new `UpdateCachePolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateCachePolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateCachePolicyError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A cache policy configuration.</p>
        pub fn cache_policy_config(mut self, input: crate::model::CachePolicyConfig) -> Self {
            self.inner = self.inner.cache_policy_config(input);
            self
        }
        /// <p>A cache policy configuration.</p>
        pub fn set_cache_policy_config(
            mut self,
            input: std::option::Option<crate::model::CachePolicyConfig>,
        ) -> Self {
            self.inner = self.inner.set_cache_policy_config(input);
            self
        }
        /// <p>The unique identifier for the cache policy that you are updating. The identifier is returned in a cache behavior’s <code>CachePolicyId</code> field in the response to <code>GetDistributionConfig</code>.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// <p>The unique identifier for the cache policy that you are updating. The identifier is returned in a cache behavior’s <code>CachePolicyId</code> field in the response to <code>GetDistributionConfig</code>.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
        /// <p>The version of the cache policy that you are updating. The version is returned in the cache policy’s <code>ETag</code> field in the response to <code>GetCachePolicyConfig</code>.</p>
        pub fn if_match(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.if_match(input.into());
            self
        }
        /// <p>The version of the cache policy that you are updating. The version is returned in the cache policy’s <code>ETag</code> field in the response to <code>GetCachePolicyConfig</code>.</p>
        pub fn set_if_match(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_if_match(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateCloudFrontOriginAccessIdentity`.
    ///
    /// <p>Update an origin access identity. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateCloudFrontOriginAccessIdentity {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_cloud_front_origin_access_identity_input::Builder,
    }
    impl UpdateCloudFrontOriginAccessIdentity {
        /// Creates a new `UpdateCloudFrontOriginAccessIdentity`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateCloudFrontOriginAccessIdentityOutput,
            aws_smithy_http::result::SdkError<
                crate::error::UpdateCloudFrontOriginAccessIdentityError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identity's configuration information.</p>
        pub fn cloud_front_origin_access_identity_config(
            mut self,
            input: crate::model::CloudFrontOriginAccessIdentityConfig,
        ) -> Self {
            self.inner = self.inner.cloud_front_origin_access_identity_config(input);
            self
        }
        /// <p>The identity's configuration information.</p>
        pub fn set_cloud_front_origin_access_identity_config(
            mut self,
            input: std::option::Option<crate::model::CloudFrontOriginAccessIdentityConfig>,
        ) -> Self {
            self.inner = self
                .inner
                .set_cloud_front_origin_access_identity_config(input);
            self
        }
        /// <p>The identity's id.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// <p>The identity's id.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
        /// <p>The value of the <code>ETag</code> header that you received when retrieving the identity's configuration. For example: <code>E2QWRUHAPOMQZL</code>.</p>
        pub fn if_match(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.if_match(input.into());
            self
        }
        /// <p>The value of the <code>ETag</code> header that you received when retrieving the identity's configuration. For example: <code>E2QWRUHAPOMQZL</code>.</p>
        pub fn set_if_match(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_if_match(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateDistribution`.
    ///
    /// <p>Updates the configuration for a web distribution. </p> <important>
    /// <p>When you update a distribution, there are more required fields than when you create a distribution. When you update your distribution by using this API action, follow the steps here to get the current configuration and then make your updates, to make sure that you include all of the required fields. To view a summary, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-overview-required-fields.html">Required Fields for Create Distribution and Update Distribution</a> in the <i>Amazon CloudFront Developer Guide</i>.</p>
    /// </important>
    /// <p>The update process includes getting the current distribution configuration, updating the XML document that is returned to make your changes, and then submitting an <code>UpdateDistribution</code> request to make the updates.</p>
    /// <p>For information about updating a distribution using the CloudFront console instead, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-web-creating-console.html">Creating a Distribution</a> in the <i>Amazon CloudFront Developer Guide</i>.</p>
    /// <p> <b>To update a web distribution using the CloudFront API</b> </p>
    /// <ol>
    /// <li> <p>Submit a <a href="https://docs.aws.amazon.com/cloudfront/latest/APIReference/API_GetDistributionConfig.html">GetDistributionConfig</a> request to get the current configuration and an <code>Etag</code> header for the distribution.</p> <note>
    /// <p>If you update the distribution again, you must get a new <code>Etag</code> header.</p>
    /// </note> </li>
    /// <li> <p>Update the XML document that was returned in the response to your <code>GetDistributionConfig</code> request to include your changes. </p> <important>
    /// <p>When you edit the XML file, be aware of the following:</p>
    /// <ul>
    /// <li> <p>You must strip out the ETag parameter that is returned.</p> </li>
    /// <li> <p>Additional fields are required when you update a distribution. There may be fields included in the XML file for features that you haven't configured for your distribution. This is expected and required to successfully update the distribution.</p> </li>
    /// <li> <p>You can't change the value of <code>CallerReference</code>. If you try to change this value, CloudFront returns an <code>IllegalUpdate</code> error. </p> </li>
    /// <li> <p>The new configuration replaces the existing configuration; the values that you specify in an <code>UpdateDistribution</code> request are not merged into your existing configuration. When you add, delete, or replace values in an element that allows multiple values (for example, <code>CNAME</code>), you must specify all of the values that you want to appear in the updated distribution. In addition, you must update the corresponding <code>Quantity</code> element.</p> </li>
    /// </ul>
    /// </important> </li>
    /// <li> <p>Submit an <code>UpdateDistribution</code> request to update the configuration for your distribution:</p>
    /// <ul>
    /// <li> <p>In the request body, include the XML document that you updated in Step 2. The request body must include an XML document with a <code>DistributionConfig</code> element.</p> </li>
    /// <li> <p>Set the value of the HTTP <code>If-Match</code> header to the value of the <code>ETag</code> header that CloudFront returned when you submitted the <code>GetDistributionConfig</code> request in Step 1.</p> </li>
    /// </ul> </li>
    /// <li> <p>Review the response to the <code>UpdateDistribution</code> request to confirm that the configuration was successfully updated.</p> </li>
    /// <li> <p>Optional: Submit a <a href="https://docs.aws.amazon.com/cloudfront/latest/APIReference/API_GetDistribution.html">GetDistribution</a> request to confirm that your changes have propagated. When propagation is complete, the value of <code>Status</code> is <code>Deployed</code>.</p> </li>
    /// </ol>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateDistribution {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_distribution_input::Builder,
    }
    impl UpdateDistribution {
        /// Creates a new `UpdateDistribution`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateDistributionOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateDistributionError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The distribution's configuration information.</p>
        pub fn distribution_config(mut self, input: crate::model::DistributionConfig) -> Self {
            self.inner = self.inner.distribution_config(input);
            self
        }
        /// <p>The distribution's configuration information.</p>
        pub fn set_distribution_config(
            mut self,
            input: std::option::Option<crate::model::DistributionConfig>,
        ) -> Self {
            self.inner = self.inner.set_distribution_config(input);
            self
        }
        /// <p>The distribution's id.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// <p>The distribution's id.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
        /// <p>The value of the <code>ETag</code> header that you received when retrieving the distribution's configuration. For example: <code>E2QWRUHAPOMQZL</code>.</p>
        pub fn if_match(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.if_match(input.into());
            self
        }
        /// <p>The value of the <code>ETag</code> header that you received when retrieving the distribution's configuration. For example: <code>E2QWRUHAPOMQZL</code>.</p>
        pub fn set_if_match(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_if_match(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateFieldLevelEncryptionConfig`.
    ///
    /// <p>Update a field-level encryption configuration. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateFieldLevelEncryptionConfig {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_field_level_encryption_config_input::Builder,
    }
    impl UpdateFieldLevelEncryptionConfig {
        /// Creates a new `UpdateFieldLevelEncryptionConfig`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateFieldLevelEncryptionConfigOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateFieldLevelEncryptionConfigError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Request to update a field-level encryption configuration. </p>
        pub fn field_level_encryption_config(
            mut self,
            input: crate::model::FieldLevelEncryptionConfig,
        ) -> Self {
            self.inner = self.inner.field_level_encryption_config(input);
            self
        }
        /// <p>Request to update a field-level encryption configuration. </p>
        pub fn set_field_level_encryption_config(
            mut self,
            input: std::option::Option<crate::model::FieldLevelEncryptionConfig>,
        ) -> Self {
            self.inner = self.inner.set_field_level_encryption_config(input);
            self
        }
        /// <p>The ID of the configuration you want to update.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// <p>The ID of the configuration you want to update.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
        /// <p>The value of the <code>ETag</code> header that you received when retrieving the configuration identity to update. For example: <code>E2QWRUHAPOMQZL</code>.</p>
        pub fn if_match(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.if_match(input.into());
            self
        }
        /// <p>The value of the <code>ETag</code> header that you received when retrieving the configuration identity to update. For example: <code>E2QWRUHAPOMQZL</code>.</p>
        pub fn set_if_match(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_if_match(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateFieldLevelEncryptionProfile`.
    ///
    /// <p>Update a field-level encryption profile. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateFieldLevelEncryptionProfile {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_field_level_encryption_profile_input::Builder,
    }
    impl UpdateFieldLevelEncryptionProfile {
        /// Creates a new `UpdateFieldLevelEncryptionProfile`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateFieldLevelEncryptionProfileOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateFieldLevelEncryptionProfileError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Request to update a field-level encryption profile. </p>
        pub fn field_level_encryption_profile_config(
            mut self,
            input: crate::model::FieldLevelEncryptionProfileConfig,
        ) -> Self {
            self.inner = self.inner.field_level_encryption_profile_config(input);
            self
        }
        /// <p>Request to update a field-level encryption profile. </p>
        pub fn set_field_level_encryption_profile_config(
            mut self,
            input: std::option::Option<crate::model::FieldLevelEncryptionProfileConfig>,
        ) -> Self {
            self.inner = self.inner.set_field_level_encryption_profile_config(input);
            self
        }
        /// <p>The ID of the field-level encryption profile request. </p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// <p>The ID of the field-level encryption profile request. </p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
        /// <p>The value of the <code>ETag</code> header that you received when retrieving the profile identity to update. For example: <code>E2QWRUHAPOMQZL</code>.</p>
        pub fn if_match(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.if_match(input.into());
            self
        }
        /// <p>The value of the <code>ETag</code> header that you received when retrieving the profile identity to update. For example: <code>E2QWRUHAPOMQZL</code>.</p>
        pub fn set_if_match(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_if_match(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateFunction`.
    ///
    /// <p>Updates a CloudFront function.</p>
    /// <p>You can update a function’s code or the comment that describes the function. You cannot update a function’s name.</p>
    /// <p>To update a function, you provide the function’s name and version (<code>ETag</code> value) along with the updated function code. To get the name and version, you can use <code>ListFunctions</code> and <code>DescribeFunction</code>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateFunction {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_function_input::Builder,
    }
    impl UpdateFunction {
        /// Creates a new `UpdateFunction`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateFunctionOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateFunctionError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the function that you are updating.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the function that you are updating.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The current version (<code>ETag</code> value) of the function that you are updating, which you can get using <code>DescribeFunction</code>.</p>
        pub fn if_match(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.if_match(input.into());
            self
        }
        /// <p>The current version (<code>ETag</code> value) of the function that you are updating, which you can get using <code>DescribeFunction</code>.</p>
        pub fn set_if_match(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_if_match(input);
            self
        }
        /// <p>Configuration information about the function.</p>
        pub fn function_config(mut self, input: crate::model::FunctionConfig) -> Self {
            self.inner = self.inner.function_config(input);
            self
        }
        /// <p>Configuration information about the function.</p>
        pub fn set_function_config(
            mut self,
            input: std::option::Option<crate::model::FunctionConfig>,
        ) -> Self {
            self.inner = self.inner.set_function_config(input);
            self
        }
        /// <p>The function code. For more information about writing a CloudFront function, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/writing-function-code.html">Writing function code for CloudFront Functions</a> in the <i>Amazon CloudFront Developer Guide</i>.</p>
        pub fn function_code(mut self, input: aws_smithy_types::Blob) -> Self {
            self.inner = self.inner.function_code(input);
            self
        }
        /// <p>The function code. For more information about writing a CloudFront function, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/writing-function-code.html">Writing function code for CloudFront Functions</a> in the <i>Amazon CloudFront Developer Guide</i>.</p>
        pub fn set_function_code(
            mut self,
            input: std::option::Option<aws_smithy_types::Blob>,
        ) -> Self {
            self.inner = self.inner.set_function_code(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateKeyGroup`.
    ///
    /// <p>Updates a key group.</p>
    /// <p>When you update a key group, all the fields are updated with the values provided in the request. You cannot update some fields independent of others. To update a key group:</p>
    /// <ol>
    /// <li> <p>Get the current key group with <code>GetKeyGroup</code> or <code>GetKeyGroupConfig</code>.</p> </li>
    /// <li> <p>Locally modify the fields in the key group that you want to update. For example, add or remove public key IDs.</p> </li>
    /// <li> <p>Call <code>UpdateKeyGroup</code> with the entire key group object, including the fields that you modified and those that you didn’t.</p> </li>
    /// </ol>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateKeyGroup {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_key_group_input::Builder,
    }
    impl UpdateKeyGroup {
        /// Creates a new `UpdateKeyGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateKeyGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateKeyGroupError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The key group configuration.</p>
        pub fn key_group_config(mut self, input: crate::model::KeyGroupConfig) -> Self {
            self.inner = self.inner.key_group_config(input);
            self
        }
        /// <p>The key group configuration.</p>
        pub fn set_key_group_config(
            mut self,
            input: std::option::Option<crate::model::KeyGroupConfig>,
        ) -> Self {
            self.inner = self.inner.set_key_group_config(input);
            self
        }
        /// <p>The identifier of the key group that you are updating.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// <p>The identifier of the key group that you are updating.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
        /// <p>The version of the key group that you are updating. The version is the key group’s <code>ETag</code> value.</p>
        pub fn if_match(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.if_match(input.into());
            self
        }
        /// <p>The version of the key group that you are updating. The version is the key group’s <code>ETag</code> value.</p>
        pub fn set_if_match(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_if_match(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateOriginRequestPolicy`.
    ///
    /// <p>Updates an origin request policy configuration.</p>
    /// <p>When you update an origin request policy configuration, all the fields are updated with the values provided in the request. You cannot update some fields independent of others. To update an origin request policy configuration:</p>
    /// <ol>
    /// <li> <p>Use <code>GetOriginRequestPolicyConfig</code> to get the current configuration.</p> </li>
    /// <li> <p>Locally modify the fields in the origin request policy configuration that you want to update.</p> </li>
    /// <li> <p>Call <code>UpdateOriginRequestPolicy</code> by providing the entire origin request policy configuration, including the fields that you modified and those that you didn’t.</p> </li>
    /// </ol>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateOriginRequestPolicy {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_origin_request_policy_input::Builder,
    }
    impl UpdateOriginRequestPolicy {
        /// Creates a new `UpdateOriginRequestPolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateOriginRequestPolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateOriginRequestPolicyError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>An origin request policy configuration.</p>
        pub fn origin_request_policy_config(
            mut self,
            input: crate::model::OriginRequestPolicyConfig,
        ) -> Self {
            self.inner = self.inner.origin_request_policy_config(input);
            self
        }
        /// <p>An origin request policy configuration.</p>
        pub fn set_origin_request_policy_config(
            mut self,
            input: std::option::Option<crate::model::OriginRequestPolicyConfig>,
        ) -> Self {
            self.inner = self.inner.set_origin_request_policy_config(input);
            self
        }
        /// <p>The unique identifier for the origin request policy that you are updating. The identifier is returned in a cache behavior’s <code>OriginRequestPolicyId</code> field in the response to <code>GetDistributionConfig</code>.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// <p>The unique identifier for the origin request policy that you are updating. The identifier is returned in a cache behavior’s <code>OriginRequestPolicyId</code> field in the response to <code>GetDistributionConfig</code>.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
        /// <p>The version of the origin request policy that you are updating. The version is returned in the origin request policy’s <code>ETag</code> field in the response to <code>GetOriginRequestPolicyConfig</code>.</p>
        pub fn if_match(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.if_match(input.into());
            self
        }
        /// <p>The version of the origin request policy that you are updating. The version is returned in the origin request policy’s <code>ETag</code> field in the response to <code>GetOriginRequestPolicyConfig</code>.</p>
        pub fn set_if_match(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_if_match(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdatePublicKey`.
    ///
    /// <p>Update public key information. Note that the only value you can change is the comment.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdatePublicKey {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_public_key_input::Builder,
    }
    impl UpdatePublicKey {
        /// Creates a new `UpdatePublicKey`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdatePublicKeyOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdatePublicKeyError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A public key configuration.</p>
        pub fn public_key_config(mut self, input: crate::model::PublicKeyConfig) -> Self {
            self.inner = self.inner.public_key_config(input);
            self
        }
        /// <p>A public key configuration.</p>
        pub fn set_public_key_config(
            mut self,
            input: std::option::Option<crate::model::PublicKeyConfig>,
        ) -> Self {
            self.inner = self.inner.set_public_key_config(input);
            self
        }
        /// <p>The identifier of the public key that you are updating.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// <p>The identifier of the public key that you are updating.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
        /// <p>The value of the <code>ETag</code> header that you received when retrieving the public key to update. For example: <code>E2QWRUHAPOMQZL</code>.</p>
        pub fn if_match(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.if_match(input.into());
            self
        }
        /// <p>The value of the <code>ETag</code> header that you received when retrieving the public key to update. For example: <code>E2QWRUHAPOMQZL</code>.</p>
        pub fn set_if_match(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_if_match(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateRealtimeLogConfig`.
    ///
    /// <p>Updates a real-time log configuration.</p>
    /// <p>When you update a real-time log configuration, all the parameters are updated with the values provided in the request. You cannot update some parameters independent of others. To update a real-time log configuration:</p>
    /// <ol>
    /// <li> <p>Call <code>GetRealtimeLogConfig</code> to get the current real-time log configuration.</p> </li>
    /// <li> <p>Locally modify the parameters in the real-time log configuration that you want to update.</p> </li>
    /// <li> <p>Call this API (<code>UpdateRealtimeLogConfig</code>) by providing the entire real-time log configuration, including the parameters that you modified and those that you didn’t.</p> </li>
    /// </ol>
    /// <p>You cannot update a real-time log configuration’s <code>Name</code> or <code>ARN</code>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateRealtimeLogConfig {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_realtime_log_config_input::Builder,
    }
    impl UpdateRealtimeLogConfig {
        /// Creates a new `UpdateRealtimeLogConfig`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateRealtimeLogConfigOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateRealtimeLogConfigError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `EndPoints`.
        ///
        /// To override the contents of this collection use [`set_end_points`](Self::set_end_points).
        ///
        /// <p>Contains information about the Amazon Kinesis data stream where you are sending real-time log data.</p>
        pub fn end_points(mut self, input: crate::model::EndPoint) -> Self {
            self.inner = self.inner.end_points(input);
            self
        }
        /// <p>Contains information about the Amazon Kinesis data stream where you are sending real-time log data.</p>
        pub fn set_end_points(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::EndPoint>>,
        ) -> Self {
            self.inner = self.inner.set_end_points(input);
            self
        }
        /// Appends an item to `Fields`.
        ///
        /// To override the contents of this collection use [`set_fields`](Self::set_fields).
        ///
        /// <p>A list of fields to include in each real-time log record.</p>
        /// <p>For more information about fields, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/real-time-logs.html#understand-real-time-log-config-fields">Real-time log configuration fields</a> in the <i>Amazon CloudFront Developer Guide</i>.</p>
        pub fn fields(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.fields(input.into());
            self
        }
        /// <p>A list of fields to include in each real-time log record.</p>
        /// <p>For more information about fields, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/real-time-logs.html#understand-real-time-log-config-fields">Real-time log configuration fields</a> in the <i>Amazon CloudFront Developer Guide</i>.</p>
        pub fn set_fields(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_fields(input);
            self
        }
        /// <p>The name for this real-time log configuration.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name for this real-time log configuration.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) for this real-time log configuration.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) for this real-time log configuration.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_arn(input);
            self
        }
        /// <p>The sampling rate for this real-time log configuration. The sampling rate determines the percentage of viewer requests that are represented in the real-time log data. You must provide an integer between 1 and 100, inclusive.</p>
        pub fn sampling_rate(mut self, input: i64) -> Self {
            self.inner = self.inner.sampling_rate(input);
            self
        }
        /// <p>The sampling rate for this real-time log configuration. The sampling rate determines the percentage of viewer requests that are represented in the real-time log data. You must provide an integer between 1 and 100, inclusive.</p>
        pub fn set_sampling_rate(mut self, input: std::option::Option<i64>) -> Self {
            self.inner = self.inner.set_sampling_rate(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateResponseHeadersPolicy`.
    ///
    /// <p>Updates a response headers policy.</p>
    /// <p>When you update a response headers policy, the entire policy is replaced. You cannot update some policy fields independent of others. To update a response headers policy configuration:</p>
    /// <ol>
    /// <li> <p>Use <code>GetResponseHeadersPolicyConfig</code> to get the current policy’s configuration.</p> </li>
    /// <li> <p>Modify the fields in the response headers policy configuration that you want to update.</p> </li>
    /// <li> <p>Call <code>UpdateResponseHeadersPolicy</code>, providing the entire response headers policy configuration, including the fields that you modified and those that you didn’t.</p> </li>
    /// </ol>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateResponseHeadersPolicy {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_response_headers_policy_input::Builder,
    }
    impl UpdateResponseHeadersPolicy {
        /// Creates a new `UpdateResponseHeadersPolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateResponseHeadersPolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateResponseHeadersPolicyError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A response headers policy configuration.</p>
        pub fn response_headers_policy_config(
            mut self,
            input: crate::model::ResponseHeadersPolicyConfig,
        ) -> Self {
            self.inner = self.inner.response_headers_policy_config(input);
            self
        }
        /// <p>A response headers policy configuration.</p>
        pub fn set_response_headers_policy_config(
            mut self,
            input: std::option::Option<crate::model::ResponseHeadersPolicyConfig>,
        ) -> Self {
            self.inner = self.inner.set_response_headers_policy_config(input);
            self
        }
        /// <p>The identifier for the response headers policy that you are updating.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// <p>The identifier for the response headers policy that you are updating.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
        /// <p>The version of the response headers policy that you are updating.</p>
        /// <p>The version is returned in the cache policy’s <code>ETag</code> field in the response to <code>GetResponseHeadersPolicyConfig</code>.</p>
        pub fn if_match(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.if_match(input.into());
            self
        }
        /// <p>The version of the response headers policy that you are updating.</p>
        /// <p>The version is returned in the cache policy’s <code>ETag</code> field in the response to <code>GetResponseHeadersPolicyConfig</code>.</p>
        pub fn set_if_match(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_if_match(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateStreamingDistribution`.
    ///
    /// <p>Update a streaming distribution. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateStreamingDistribution {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_streaming_distribution_input::Builder,
    }
    impl UpdateStreamingDistribution {
        /// Creates a new `UpdateStreamingDistribution`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateStreamingDistributionOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateStreamingDistributionError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The streaming distribution's configuration information.</p>
        pub fn streaming_distribution_config(
            mut self,
            input: crate::model::StreamingDistributionConfig,
        ) -> Self {
            self.inner = self.inner.streaming_distribution_config(input);
            self
        }
        /// <p>The streaming distribution's configuration information.</p>
        pub fn set_streaming_distribution_config(
            mut self,
            input: std::option::Option<crate::model::StreamingDistributionConfig>,
        ) -> Self {
            self.inner = self.inner.set_streaming_distribution_config(input);
            self
        }
        /// <p>The streaming distribution's id.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// <p>The streaming distribution's id.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
        /// <p>The value of the <code>ETag</code> header that you received when retrieving the streaming distribution's configuration. For example: <code>E2QWRUHAPOMQZL</code>.</p>
        pub fn if_match(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.if_match(input.into());
            self
        }
        /// <p>The value of the <code>ETag</code> header that you received when retrieving the streaming distribution's configuration. For example: <code>E2QWRUHAPOMQZL</code>.</p>
        pub fn set_if_match(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_if_match(input);
            self
        }
    }
}

impl Client {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn<C, E>(conf: crate::Config, conn: C) -> Self
    where
        C: aws_smithy_client::bounds::SmithyConnector<Error = E> + Send + 'static,
        E: Into<aws_smithy_http::result::ConnectorError>,
    {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::new()
            .connector(aws_smithy_client::erase::DynConnector::new(conn))
            .middleware(aws_smithy_client::erase::DynMiddleware::new(
                crate::middleware::DefaultMiddleware::new(),
            ));
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(sdk_config: &aws_types::sdk_config::SdkConfig) -> Self {
        Self::from_conf(sdk_config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::dyn_https().middleware(
            aws_smithy_client::erase::DynMiddleware::new(
                crate::middleware::DefaultMiddleware::new(),
            ),
        );
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        // the builder maintains a try-state. To avoid suppressing the warning when sleep is unset,
        // only set it if we actually have a sleep impl.
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();

        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
