// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
use std::fmt::Write;
/// See [`AssociateAliasInput`](crate::input::AssociateAliasInput)
pub mod associate_alias_input {
    /// A builder for [`AssociateAliasInput`](crate::input::AssociateAliasInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) target_distribution_id: std::option::Option<std::string::String>,
        pub(crate) alias: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the distribution that you’re associating the alias with.</p>
        pub fn target_distribution_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.target_distribution_id = Some(input.into());
            self
        }
        /// <p>The ID of the distribution that you’re associating the alias with.</p>
        pub fn set_target_distribution_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.target_distribution_id = input;
            self
        }
        /// <p>The alias (also known as a CNAME) to add to the target distribution.</p>
        pub fn alias(mut self, input: impl Into<std::string::String>) -> Self {
            self.alias = Some(input.into());
            self
        }
        /// <p>The alias (also known as a CNAME) to add to the target distribution.</p>
        pub fn set_alias(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.alias = input;
            self
        }
        /// Consumes the builder and constructs a [`AssociateAliasInput`](crate::input::AssociateAliasInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::AssociateAliasInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::AssociateAliasInput {
                target_distribution_id: self.target_distribution_id,
                alias: self.alias,
            })
        }
    }
}
#[doc(hidden)]
pub type AssociateAliasInputOperationOutputAlias = crate::operation::AssociateAlias;
#[doc(hidden)]
pub type AssociateAliasInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl AssociateAliasInput {
    /// Consumes the builder and constructs an Operation<[`AssociateAlias`](crate::operation::AssociateAlias)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::AssociateAlias,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::AssociateAliasInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_1 = &_input.target_distribution_id;
                let input_1 = input_1.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "target_distribution_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let target_distribution_id = aws_smithy_http::label::fmt_string(input_1, false);
                if target_distribution_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "target_distribution_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/2020-05-31/distribution/{TargetDistributionId}/associate-alias",
                    TargetDistributionId = target_distribution_id
                )
                .expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::AssociateAliasInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_2) = &_input.alias {
                    query.push_kv("Alias", &aws_smithy_http::query::fmt_string(&inner_2));
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::AssociateAliasInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("PUT").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::AssociateAlias::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "AssociateAlias",
            "cloudfront",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`AssociateAliasInput`](crate::input::AssociateAliasInput)
    pub fn builder() -> crate::input::associate_alias_input::Builder {
        crate::input::associate_alias_input::Builder::default()
    }
}

/// See [`CreateCachePolicyInput`](crate::input::CreateCachePolicyInput)
pub mod create_cache_policy_input {
    /// A builder for [`CreateCachePolicyInput`](crate::input::CreateCachePolicyInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cache_policy_config: std::option::Option<crate::model::CachePolicyConfig>,
    }
    impl Builder {
        /// <p>A cache policy configuration.</p>
        pub fn cache_policy_config(mut self, input: crate::model::CachePolicyConfig) -> Self {
            self.cache_policy_config = Some(input);
            self
        }
        /// <p>A cache policy configuration.</p>
        pub fn set_cache_policy_config(
            mut self,
            input: std::option::Option<crate::model::CachePolicyConfig>,
        ) -> Self {
            self.cache_policy_config = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateCachePolicyInput`](crate::input::CreateCachePolicyInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateCachePolicyInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateCachePolicyInput {
                cache_policy_config: self.cache_policy_config,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateCachePolicyInputOperationOutputAlias = crate::operation::CreateCachePolicy;
#[doc(hidden)]
pub type CreateCachePolicyInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateCachePolicyInput {
    /// Consumes the builder and constructs an Operation<[`CreateCachePolicy`](crate::operation::CreateCachePolicy)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateCachePolicy,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateCachePolicyInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/2020-05-31/cache-policy").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateCachePolicyInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/xml",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_payload_create_cache_policy_input(
                &self.cache_policy_config,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateCachePolicy::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateCachePolicy",
            "cloudfront",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateCachePolicyInput`](crate::input::CreateCachePolicyInput)
    pub fn builder() -> crate::input::create_cache_policy_input::Builder {
        crate::input::create_cache_policy_input::Builder::default()
    }
}

/// See [`CreateCloudFrontOriginAccessIdentityInput`](crate::input::CreateCloudFrontOriginAccessIdentityInput)
pub mod create_cloud_front_origin_access_identity_input {
    /// A builder for [`CreateCloudFrontOriginAccessIdentityInput`](crate::input::CreateCloudFrontOriginAccessIdentityInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cloud_front_origin_access_identity_config:
            std::option::Option<crate::model::CloudFrontOriginAccessIdentityConfig>,
    }
    impl Builder {
        /// <p>The current configuration information for the identity.</p>
        pub fn cloud_front_origin_access_identity_config(
            mut self,
            input: crate::model::CloudFrontOriginAccessIdentityConfig,
        ) -> Self {
            self.cloud_front_origin_access_identity_config = Some(input);
            self
        }
        /// <p>The current configuration information for the identity.</p>
        pub fn set_cloud_front_origin_access_identity_config(
            mut self,
            input: std::option::Option<crate::model::CloudFrontOriginAccessIdentityConfig>,
        ) -> Self {
            self.cloud_front_origin_access_identity_config = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateCloudFrontOriginAccessIdentityInput`](crate::input::CreateCloudFrontOriginAccessIdentityInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateCloudFrontOriginAccessIdentityInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateCloudFrontOriginAccessIdentityInput {
                cloud_front_origin_access_identity_config: self
                    .cloud_front_origin_access_identity_config,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateCloudFrontOriginAccessIdentityInputOperationOutputAlias =
    crate::operation::CreateCloudFrontOriginAccessIdentity;
#[doc(hidden)]
pub type CreateCloudFrontOriginAccessIdentityInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl CreateCloudFrontOriginAccessIdentityInput {
    /// Consumes the builder and constructs an Operation<[`CreateCloudFrontOriginAccessIdentity`](crate::operation::CreateCloudFrontOriginAccessIdentity)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateCloudFrontOriginAccessIdentity,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateCloudFrontOriginAccessIdentityInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/2020-05-31/origin-access-identity/cloudfront")
                    .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateCloudFrontOriginAccessIdentityInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/xml",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_payload_create_cloud_front_origin_access_identity_input(& self.cloud_front_origin_access_identity_config)?
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateCloudFrontOriginAccessIdentity::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateCloudFrontOriginAccessIdentity",
            "cloudfront",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateCloudFrontOriginAccessIdentityInput`](crate::input::CreateCloudFrontOriginAccessIdentityInput)
    pub fn builder() -> crate::input::create_cloud_front_origin_access_identity_input::Builder {
        crate::input::create_cloud_front_origin_access_identity_input::Builder::default()
    }
}

/// See [`CreateDistributionInput`](crate::input::CreateDistributionInput)
pub mod create_distribution_input {
    /// A builder for [`CreateDistributionInput`](crate::input::CreateDistributionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) distribution_config: std::option::Option<crate::model::DistributionConfig>,
    }
    impl Builder {
        /// <p>The distribution's configuration information.</p>
        pub fn distribution_config(mut self, input: crate::model::DistributionConfig) -> Self {
            self.distribution_config = Some(input);
            self
        }
        /// <p>The distribution's configuration information.</p>
        pub fn set_distribution_config(
            mut self,
            input: std::option::Option<crate::model::DistributionConfig>,
        ) -> Self {
            self.distribution_config = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateDistributionInput`](crate::input::CreateDistributionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateDistributionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateDistributionInput {
                distribution_config: self.distribution_config,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateDistributionInputOperationOutputAlias = crate::operation::CreateDistribution;
#[doc(hidden)]
pub type CreateDistributionInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateDistributionInput {
    /// Consumes the builder and constructs an Operation<[`CreateDistribution`](crate::operation::CreateDistribution)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateDistribution,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateDistributionInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/2020-05-31/distribution").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateDistributionInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/xml",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_payload_create_distribution_input(
                &self.distribution_config,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateDistribution::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateDistribution",
            "cloudfront",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateDistributionInput`](crate::input::CreateDistributionInput)
    pub fn builder() -> crate::input::create_distribution_input::Builder {
        crate::input::create_distribution_input::Builder::default()
    }
}

/// See [`CreateDistributionWithTagsInput`](crate::input::CreateDistributionWithTagsInput)
pub mod create_distribution_with_tags_input {
    /// A builder for [`CreateDistributionWithTagsInput`](crate::input::CreateDistributionWithTagsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) distribution_config_with_tags:
            std::option::Option<crate::model::DistributionConfigWithTags>,
    }
    impl Builder {
        /// <p>The distribution's configuration information. </p>
        pub fn distribution_config_with_tags(
            mut self,
            input: crate::model::DistributionConfigWithTags,
        ) -> Self {
            self.distribution_config_with_tags = Some(input);
            self
        }
        /// <p>The distribution's configuration information. </p>
        pub fn set_distribution_config_with_tags(
            mut self,
            input: std::option::Option<crate::model::DistributionConfigWithTags>,
        ) -> Self {
            self.distribution_config_with_tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateDistributionWithTagsInput`](crate::input::CreateDistributionWithTagsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateDistributionWithTagsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateDistributionWithTagsInput {
                distribution_config_with_tags: self.distribution_config_with_tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateDistributionWithTagsInputOperationOutputAlias =
    crate::operation::CreateDistributionWithTags;
#[doc(hidden)]
pub type CreateDistributionWithTagsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateDistributionWithTagsInput {
    /// Consumes the builder and constructs an Operation<[`CreateDistributionWithTags`](crate::operation::CreateDistributionWithTags)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateDistributionWithTags,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateDistributionWithTagsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/2020-05-31/distribution").expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::CreateDistributionWithTagsInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                query.push_v("WithTags");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateDistributionWithTagsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/xml",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_payload_create_distribution_with_tags_input(
                &self.distribution_config_with_tags,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateDistributionWithTags::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateDistributionWithTags",
            "cloudfront",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateDistributionWithTagsInput`](crate::input::CreateDistributionWithTagsInput)
    pub fn builder() -> crate::input::create_distribution_with_tags_input::Builder {
        crate::input::create_distribution_with_tags_input::Builder::default()
    }
}

/// See [`CreateFieldLevelEncryptionConfigInput`](crate::input::CreateFieldLevelEncryptionConfigInput)
pub mod create_field_level_encryption_config_input {
    /// A builder for [`CreateFieldLevelEncryptionConfigInput`](crate::input::CreateFieldLevelEncryptionConfigInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) field_level_encryption_config:
            std::option::Option<crate::model::FieldLevelEncryptionConfig>,
    }
    impl Builder {
        /// <p>The request to create a new field-level encryption configuration.</p>
        pub fn field_level_encryption_config(
            mut self,
            input: crate::model::FieldLevelEncryptionConfig,
        ) -> Self {
            self.field_level_encryption_config = Some(input);
            self
        }
        /// <p>The request to create a new field-level encryption configuration.</p>
        pub fn set_field_level_encryption_config(
            mut self,
            input: std::option::Option<crate::model::FieldLevelEncryptionConfig>,
        ) -> Self {
            self.field_level_encryption_config = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateFieldLevelEncryptionConfigInput`](crate::input::CreateFieldLevelEncryptionConfigInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateFieldLevelEncryptionConfigInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateFieldLevelEncryptionConfigInput {
                field_level_encryption_config: self.field_level_encryption_config,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateFieldLevelEncryptionConfigInputOperationOutputAlias =
    crate::operation::CreateFieldLevelEncryptionConfig;
#[doc(hidden)]
pub type CreateFieldLevelEncryptionConfigInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl CreateFieldLevelEncryptionConfigInput {
    /// Consumes the builder and constructs an Operation<[`CreateFieldLevelEncryptionConfig`](crate::operation::CreateFieldLevelEncryptionConfig)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateFieldLevelEncryptionConfig,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateFieldLevelEncryptionConfigInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/2020-05-31/field-level-encryption")
                    .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateFieldLevelEncryptionConfigInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/xml",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_payload_create_field_level_encryption_config_input(
                &self.field_level_encryption_config,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateFieldLevelEncryptionConfig::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateFieldLevelEncryptionConfig",
            "cloudfront",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateFieldLevelEncryptionConfigInput`](crate::input::CreateFieldLevelEncryptionConfigInput)
    pub fn builder() -> crate::input::create_field_level_encryption_config_input::Builder {
        crate::input::create_field_level_encryption_config_input::Builder::default()
    }
}

/// See [`CreateFieldLevelEncryptionProfileInput`](crate::input::CreateFieldLevelEncryptionProfileInput)
pub mod create_field_level_encryption_profile_input {
    /// A builder for [`CreateFieldLevelEncryptionProfileInput`](crate::input::CreateFieldLevelEncryptionProfileInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) field_level_encryption_profile_config:
            std::option::Option<crate::model::FieldLevelEncryptionProfileConfig>,
    }
    impl Builder {
        /// <p>The request to create a field-level encryption profile.</p>
        pub fn field_level_encryption_profile_config(
            mut self,
            input: crate::model::FieldLevelEncryptionProfileConfig,
        ) -> Self {
            self.field_level_encryption_profile_config = Some(input);
            self
        }
        /// <p>The request to create a field-level encryption profile.</p>
        pub fn set_field_level_encryption_profile_config(
            mut self,
            input: std::option::Option<crate::model::FieldLevelEncryptionProfileConfig>,
        ) -> Self {
            self.field_level_encryption_profile_config = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateFieldLevelEncryptionProfileInput`](crate::input::CreateFieldLevelEncryptionProfileInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateFieldLevelEncryptionProfileInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateFieldLevelEncryptionProfileInput {
                field_level_encryption_profile_config: self.field_level_encryption_profile_config,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateFieldLevelEncryptionProfileInputOperationOutputAlias =
    crate::operation::CreateFieldLevelEncryptionProfile;
#[doc(hidden)]
pub type CreateFieldLevelEncryptionProfileInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl CreateFieldLevelEncryptionProfileInput {
    /// Consumes the builder and constructs an Operation<[`CreateFieldLevelEncryptionProfile`](crate::operation::CreateFieldLevelEncryptionProfile)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateFieldLevelEncryptionProfile,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateFieldLevelEncryptionProfileInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/2020-05-31/field-level-encryption-profile")
                    .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateFieldLevelEncryptionProfileInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/xml",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_payload_create_field_level_encryption_profile_input(
                &self.field_level_encryption_profile_config,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateFieldLevelEncryptionProfile::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateFieldLevelEncryptionProfile",
            "cloudfront",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateFieldLevelEncryptionProfileInput`](crate::input::CreateFieldLevelEncryptionProfileInput)
    pub fn builder() -> crate::input::create_field_level_encryption_profile_input::Builder {
        crate::input::create_field_level_encryption_profile_input::Builder::default()
    }
}

/// See [`CreateFunctionInput`](crate::input::CreateFunctionInput)
pub mod create_function_input {
    /// A builder for [`CreateFunctionInput`](crate::input::CreateFunctionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) function_config: std::option::Option<crate::model::FunctionConfig>,
        pub(crate) function_code: std::option::Option<aws_smithy_types::Blob>,
    }
    impl Builder {
        /// <p>A name to identify the function.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>A name to identify the function.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>Configuration information about the function, including an optional comment and the function’s runtime.</p>
        pub fn function_config(mut self, input: crate::model::FunctionConfig) -> Self {
            self.function_config = Some(input);
            self
        }
        /// <p>Configuration information about the function, including an optional comment and the function’s runtime.</p>
        pub fn set_function_config(
            mut self,
            input: std::option::Option<crate::model::FunctionConfig>,
        ) -> Self {
            self.function_config = input;
            self
        }
        /// <p>The function code. For more information about writing a CloudFront function, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/writing-function-code.html">Writing function code for CloudFront Functions</a> in the <i>Amazon CloudFront Developer Guide</i>.</p>
        pub fn function_code(mut self, input: aws_smithy_types::Blob) -> Self {
            self.function_code = Some(input);
            self
        }
        /// <p>The function code. For more information about writing a CloudFront function, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/writing-function-code.html">Writing function code for CloudFront Functions</a> in the <i>Amazon CloudFront Developer Guide</i>.</p>
        pub fn set_function_code(
            mut self,
            input: std::option::Option<aws_smithy_types::Blob>,
        ) -> Self {
            self.function_code = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateFunctionInput`](crate::input::CreateFunctionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateFunctionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateFunctionInput {
                name: self.name,
                function_config: self.function_config,
                function_code: self.function_code,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateFunctionInputOperationOutputAlias = crate::operation::CreateFunction;
#[doc(hidden)]
pub type CreateFunctionInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateFunctionInput {
    /// Consumes the builder and constructs an Operation<[`CreateFunction`](crate::operation::CreateFunction)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateFunction,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateFunctionInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/2020-05-31/function").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateFunctionInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/xml",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_function(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateFunction::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateFunction",
            "cloudfront",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateFunctionInput`](crate::input::CreateFunctionInput)
    pub fn builder() -> crate::input::create_function_input::Builder {
        crate::input::create_function_input::Builder::default()
    }
}

/// See [`CreateInvalidationInput`](crate::input::CreateInvalidationInput)
pub mod create_invalidation_input {
    /// A builder for [`CreateInvalidationInput`](crate::input::CreateInvalidationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) distribution_id: std::option::Option<std::string::String>,
        pub(crate) invalidation_batch: std::option::Option<crate::model::InvalidationBatch>,
    }
    impl Builder {
        /// <p>The distribution's id.</p>
        pub fn distribution_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.distribution_id = Some(input.into());
            self
        }
        /// <p>The distribution's id.</p>
        pub fn set_distribution_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.distribution_id = input;
            self
        }
        /// <p>The batch information for the invalidation.</p>
        pub fn invalidation_batch(mut self, input: crate::model::InvalidationBatch) -> Self {
            self.invalidation_batch = Some(input);
            self
        }
        /// <p>The batch information for the invalidation.</p>
        pub fn set_invalidation_batch(
            mut self,
            input: std::option::Option<crate::model::InvalidationBatch>,
        ) -> Self {
            self.invalidation_batch = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateInvalidationInput`](crate::input::CreateInvalidationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateInvalidationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateInvalidationInput {
                distribution_id: self.distribution_id,
                invalidation_batch: self.invalidation_batch,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateInvalidationInputOperationOutputAlias = crate::operation::CreateInvalidation;
#[doc(hidden)]
pub type CreateInvalidationInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateInvalidationInput {
    /// Consumes the builder and constructs an Operation<[`CreateInvalidation`](crate::operation::CreateInvalidation)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateInvalidation,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateInvalidationInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_3 = &_input.distribution_id;
                let input_3 = input_3.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "distribution_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let distribution_id = aws_smithy_http::label::fmt_string(input_3, false);
                if distribution_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "distribution_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/2020-05-31/distribution/{DistributionId}/invalidation",
                    DistributionId = distribution_id
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateInvalidationInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/xml",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_payload_create_invalidation_input(
                &self.invalidation_batch,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateInvalidation::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateInvalidation",
            "cloudfront",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateInvalidationInput`](crate::input::CreateInvalidationInput)
    pub fn builder() -> crate::input::create_invalidation_input::Builder {
        crate::input::create_invalidation_input::Builder::default()
    }
}

/// See [`CreateKeyGroupInput`](crate::input::CreateKeyGroupInput)
pub mod create_key_group_input {
    /// A builder for [`CreateKeyGroupInput`](crate::input::CreateKeyGroupInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) key_group_config: std::option::Option<crate::model::KeyGroupConfig>,
    }
    impl Builder {
        /// <p>A key group configuration.</p>
        pub fn key_group_config(mut self, input: crate::model::KeyGroupConfig) -> Self {
            self.key_group_config = Some(input);
            self
        }
        /// <p>A key group configuration.</p>
        pub fn set_key_group_config(
            mut self,
            input: std::option::Option<crate::model::KeyGroupConfig>,
        ) -> Self {
            self.key_group_config = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateKeyGroupInput`](crate::input::CreateKeyGroupInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateKeyGroupInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateKeyGroupInput {
                key_group_config: self.key_group_config,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateKeyGroupInputOperationOutputAlias = crate::operation::CreateKeyGroup;
#[doc(hidden)]
pub type CreateKeyGroupInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateKeyGroupInput {
    /// Consumes the builder and constructs an Operation<[`CreateKeyGroup`](crate::operation::CreateKeyGroup)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateKeyGroup,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateKeyGroupInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/2020-05-31/key-group").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateKeyGroupInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/xml",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_payload_create_key_group_input(&self.key_group_config)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateKeyGroup::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateKeyGroup",
            "cloudfront",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateKeyGroupInput`](crate::input::CreateKeyGroupInput)
    pub fn builder() -> crate::input::create_key_group_input::Builder {
        crate::input::create_key_group_input::Builder::default()
    }
}

/// See [`CreateMonitoringSubscriptionInput`](crate::input::CreateMonitoringSubscriptionInput)
pub mod create_monitoring_subscription_input {
    /// A builder for [`CreateMonitoringSubscriptionInput`](crate::input::CreateMonitoringSubscriptionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) distribution_id: std::option::Option<std::string::String>,
        pub(crate) monitoring_subscription:
            std::option::Option<crate::model::MonitoringSubscription>,
    }
    impl Builder {
        /// <p>The ID of the distribution that you are enabling metrics for.</p>
        pub fn distribution_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.distribution_id = Some(input.into());
            self
        }
        /// <p>The ID of the distribution that you are enabling metrics for.</p>
        pub fn set_distribution_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.distribution_id = input;
            self
        }
        /// <p>A monitoring subscription. This structure contains information about whether additional CloudWatch metrics are enabled for a given CloudFront distribution.</p>
        pub fn monitoring_subscription(
            mut self,
            input: crate::model::MonitoringSubscription,
        ) -> Self {
            self.monitoring_subscription = Some(input);
            self
        }
        /// <p>A monitoring subscription. This structure contains information about whether additional CloudWatch metrics are enabled for a given CloudFront distribution.</p>
        pub fn set_monitoring_subscription(
            mut self,
            input: std::option::Option<crate::model::MonitoringSubscription>,
        ) -> Self {
            self.monitoring_subscription = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateMonitoringSubscriptionInput`](crate::input::CreateMonitoringSubscriptionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateMonitoringSubscriptionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateMonitoringSubscriptionInput {
                distribution_id: self.distribution_id,
                monitoring_subscription: self.monitoring_subscription,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateMonitoringSubscriptionInputOperationOutputAlias =
    crate::operation::CreateMonitoringSubscription;
#[doc(hidden)]
pub type CreateMonitoringSubscriptionInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl CreateMonitoringSubscriptionInput {
    /// Consumes the builder and constructs an Operation<[`CreateMonitoringSubscription`](crate::operation::CreateMonitoringSubscription)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateMonitoringSubscription,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateMonitoringSubscriptionInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_4 = &_input.distribution_id;
                let input_4 = input_4.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "distribution_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let distribution_id = aws_smithy_http::label::fmt_string(input_4, false);
                if distribution_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "distribution_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/2020-05-31/distributions/{DistributionId}/monitoring-subscription",
                    DistributionId = distribution_id
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateMonitoringSubscriptionInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/xml",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_payload_create_monitoring_subscription_input(
                &self.monitoring_subscription,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateMonitoringSubscription::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateMonitoringSubscription",
            "cloudfront",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateMonitoringSubscriptionInput`](crate::input::CreateMonitoringSubscriptionInput)
    pub fn builder() -> crate::input::create_monitoring_subscription_input::Builder {
        crate::input::create_monitoring_subscription_input::Builder::default()
    }
}

/// See [`CreateOriginRequestPolicyInput`](crate::input::CreateOriginRequestPolicyInput)
pub mod create_origin_request_policy_input {
    /// A builder for [`CreateOriginRequestPolicyInput`](crate::input::CreateOriginRequestPolicyInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) origin_request_policy_config:
            std::option::Option<crate::model::OriginRequestPolicyConfig>,
    }
    impl Builder {
        /// <p>An origin request policy configuration.</p>
        pub fn origin_request_policy_config(
            mut self,
            input: crate::model::OriginRequestPolicyConfig,
        ) -> Self {
            self.origin_request_policy_config = Some(input);
            self
        }
        /// <p>An origin request policy configuration.</p>
        pub fn set_origin_request_policy_config(
            mut self,
            input: std::option::Option<crate::model::OriginRequestPolicyConfig>,
        ) -> Self {
            self.origin_request_policy_config = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateOriginRequestPolicyInput`](crate::input::CreateOriginRequestPolicyInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateOriginRequestPolicyInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateOriginRequestPolicyInput {
                origin_request_policy_config: self.origin_request_policy_config,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateOriginRequestPolicyInputOperationOutputAlias =
    crate::operation::CreateOriginRequestPolicy;
#[doc(hidden)]
pub type CreateOriginRequestPolicyInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateOriginRequestPolicyInput {
    /// Consumes the builder and constructs an Operation<[`CreateOriginRequestPolicy`](crate::operation::CreateOriginRequestPolicy)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateOriginRequestPolicy,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateOriginRequestPolicyInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/2020-05-31/origin-request-policy")
                    .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateOriginRequestPolicyInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/xml",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_payload_create_origin_request_policy_input(
                &self.origin_request_policy_config,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateOriginRequestPolicy::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateOriginRequestPolicy",
            "cloudfront",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateOriginRequestPolicyInput`](crate::input::CreateOriginRequestPolicyInput)
    pub fn builder() -> crate::input::create_origin_request_policy_input::Builder {
        crate::input::create_origin_request_policy_input::Builder::default()
    }
}

/// See [`CreatePublicKeyInput`](crate::input::CreatePublicKeyInput)
pub mod create_public_key_input {
    /// A builder for [`CreatePublicKeyInput`](crate::input::CreatePublicKeyInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) public_key_config: std::option::Option<crate::model::PublicKeyConfig>,
    }
    impl Builder {
        /// <p>A CloudFront public key configuration.</p>
        pub fn public_key_config(mut self, input: crate::model::PublicKeyConfig) -> Self {
            self.public_key_config = Some(input);
            self
        }
        /// <p>A CloudFront public key configuration.</p>
        pub fn set_public_key_config(
            mut self,
            input: std::option::Option<crate::model::PublicKeyConfig>,
        ) -> Self {
            self.public_key_config = input;
            self
        }
        /// Consumes the builder and constructs a [`CreatePublicKeyInput`](crate::input::CreatePublicKeyInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreatePublicKeyInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreatePublicKeyInput {
                public_key_config: self.public_key_config,
            })
        }
    }
}
#[doc(hidden)]
pub type CreatePublicKeyInputOperationOutputAlias = crate::operation::CreatePublicKey;
#[doc(hidden)]
pub type CreatePublicKeyInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreatePublicKeyInput {
    /// Consumes the builder and constructs an Operation<[`CreatePublicKey`](crate::operation::CreatePublicKey)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreatePublicKey,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreatePublicKeyInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/2020-05-31/public-key").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreatePublicKeyInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/xml",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_payload_create_public_key_input(
                &self.public_key_config,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreatePublicKey::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreatePublicKey",
            "cloudfront",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreatePublicKeyInput`](crate::input::CreatePublicKeyInput)
    pub fn builder() -> crate::input::create_public_key_input::Builder {
        crate::input::create_public_key_input::Builder::default()
    }
}

/// See [`CreateRealtimeLogConfigInput`](crate::input::CreateRealtimeLogConfigInput)
pub mod create_realtime_log_config_input {
    /// A builder for [`CreateRealtimeLogConfigInput`](crate::input::CreateRealtimeLogConfigInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) end_points: std::option::Option<std::vec::Vec<crate::model::EndPoint>>,
        pub(crate) fields: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) sampling_rate: std::option::Option<i64>,
    }
    impl Builder {
        /// Appends an item to `end_points`.
        ///
        /// To override the contents of this collection use [`set_end_points`](Self::set_end_points).
        ///
        /// <p>Contains information about the Amazon Kinesis data stream where you are sending real-time log data.</p>
        pub fn end_points(mut self, input: crate::model::EndPoint) -> Self {
            let mut v = self.end_points.unwrap_or_default();
            v.push(input);
            self.end_points = Some(v);
            self
        }
        /// <p>Contains information about the Amazon Kinesis data stream where you are sending real-time log data.</p>
        pub fn set_end_points(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::EndPoint>>,
        ) -> Self {
            self.end_points = input;
            self
        }
        /// Appends an item to `fields`.
        ///
        /// To override the contents of this collection use [`set_fields`](Self::set_fields).
        ///
        /// <p>A list of fields to include in each real-time log record.</p>
        /// <p>For more information about fields, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/real-time-logs.html#understand-real-time-log-config-fields">Real-time log configuration fields</a> in the <i>Amazon CloudFront Developer Guide</i>.</p>
        pub fn fields(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.fields.unwrap_or_default();
            v.push(input.into());
            self.fields = Some(v);
            self
        }
        /// <p>A list of fields to include in each real-time log record.</p>
        /// <p>For more information about fields, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/real-time-logs.html#understand-real-time-log-config-fields">Real-time log configuration fields</a> in the <i>Amazon CloudFront Developer Guide</i>.</p>
        pub fn set_fields(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.fields = input;
            self
        }
        /// <p>A unique name to identify this real-time log configuration.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>A unique name to identify this real-time log configuration.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The sampling rate for this real-time log configuration. The sampling rate determines the percentage of viewer requests that are represented in the real-time log data. You must provide an integer between 1 and 100, inclusive.</p>
        pub fn sampling_rate(mut self, input: i64) -> Self {
            self.sampling_rate = Some(input);
            self
        }
        /// <p>The sampling rate for this real-time log configuration. The sampling rate determines the percentage of viewer requests that are represented in the real-time log data. You must provide an integer between 1 and 100, inclusive.</p>
        pub fn set_sampling_rate(mut self, input: std::option::Option<i64>) -> Self {
            self.sampling_rate = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateRealtimeLogConfigInput`](crate::input::CreateRealtimeLogConfigInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateRealtimeLogConfigInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateRealtimeLogConfigInput {
                end_points: self.end_points,
                fields: self.fields,
                name: self.name,
                sampling_rate: self.sampling_rate,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateRealtimeLogConfigInputOperationOutputAlias =
    crate::operation::CreateRealtimeLogConfig;
#[doc(hidden)]
pub type CreateRealtimeLogConfigInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateRealtimeLogConfigInput {
    /// Consumes the builder and constructs an Operation<[`CreateRealtimeLogConfig`](crate::operation::CreateRealtimeLogConfig)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateRealtimeLogConfig,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateRealtimeLogConfigInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/2020-05-31/realtime-log-config")
                    .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateRealtimeLogConfigInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/xml",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_realtime_log_config(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateRealtimeLogConfig::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateRealtimeLogConfig",
            "cloudfront",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateRealtimeLogConfigInput`](crate::input::CreateRealtimeLogConfigInput)
    pub fn builder() -> crate::input::create_realtime_log_config_input::Builder {
        crate::input::create_realtime_log_config_input::Builder::default()
    }
}

/// See [`CreateResponseHeadersPolicyInput`](crate::input::CreateResponseHeadersPolicyInput)
pub mod create_response_headers_policy_input {
    /// A builder for [`CreateResponseHeadersPolicyInput`](crate::input::CreateResponseHeadersPolicyInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) response_headers_policy_config:
            std::option::Option<crate::model::ResponseHeadersPolicyConfig>,
    }
    impl Builder {
        /// <p>Contains metadata about the response headers policy, and a set of configurations that specify the response headers.</p>
        pub fn response_headers_policy_config(
            mut self,
            input: crate::model::ResponseHeadersPolicyConfig,
        ) -> Self {
            self.response_headers_policy_config = Some(input);
            self
        }
        /// <p>Contains metadata about the response headers policy, and a set of configurations that specify the response headers.</p>
        pub fn set_response_headers_policy_config(
            mut self,
            input: std::option::Option<crate::model::ResponseHeadersPolicyConfig>,
        ) -> Self {
            self.response_headers_policy_config = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateResponseHeadersPolicyInput`](crate::input::CreateResponseHeadersPolicyInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateResponseHeadersPolicyInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateResponseHeadersPolicyInput {
                response_headers_policy_config: self.response_headers_policy_config,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateResponseHeadersPolicyInputOperationOutputAlias =
    crate::operation::CreateResponseHeadersPolicy;
#[doc(hidden)]
pub type CreateResponseHeadersPolicyInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateResponseHeadersPolicyInput {
    /// Consumes the builder and constructs an Operation<[`CreateResponseHeadersPolicy`](crate::operation::CreateResponseHeadersPolicy)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateResponseHeadersPolicy,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateResponseHeadersPolicyInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/2020-05-31/response-headers-policy")
                    .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateResponseHeadersPolicyInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/xml",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_payload_create_response_headers_policy_input(
                &self.response_headers_policy_config,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateResponseHeadersPolicy::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateResponseHeadersPolicy",
            "cloudfront",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateResponseHeadersPolicyInput`](crate::input::CreateResponseHeadersPolicyInput)
    pub fn builder() -> crate::input::create_response_headers_policy_input::Builder {
        crate::input::create_response_headers_policy_input::Builder::default()
    }
}

/// See [`CreateStreamingDistributionInput`](crate::input::CreateStreamingDistributionInput)
pub mod create_streaming_distribution_input {
    /// A builder for [`CreateStreamingDistributionInput`](crate::input::CreateStreamingDistributionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) streaming_distribution_config:
            std::option::Option<crate::model::StreamingDistributionConfig>,
    }
    impl Builder {
        /// <p>The streaming distribution's configuration information.</p>
        pub fn streaming_distribution_config(
            mut self,
            input: crate::model::StreamingDistributionConfig,
        ) -> Self {
            self.streaming_distribution_config = Some(input);
            self
        }
        /// <p>The streaming distribution's configuration information.</p>
        pub fn set_streaming_distribution_config(
            mut self,
            input: std::option::Option<crate::model::StreamingDistributionConfig>,
        ) -> Self {
            self.streaming_distribution_config = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateStreamingDistributionInput`](crate::input::CreateStreamingDistributionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateStreamingDistributionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateStreamingDistributionInput {
                streaming_distribution_config: self.streaming_distribution_config,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateStreamingDistributionInputOperationOutputAlias =
    crate::operation::CreateStreamingDistribution;
#[doc(hidden)]
pub type CreateStreamingDistributionInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateStreamingDistributionInput {
    /// Consumes the builder and constructs an Operation<[`CreateStreamingDistribution`](crate::operation::CreateStreamingDistribution)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateStreamingDistribution,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateStreamingDistributionInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/2020-05-31/streaming-distribution")
                    .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateStreamingDistributionInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/xml",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_payload_create_streaming_distribution_input(
                &self.streaming_distribution_config,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateStreamingDistribution::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateStreamingDistribution",
            "cloudfront",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateStreamingDistributionInput`](crate::input::CreateStreamingDistributionInput)
    pub fn builder() -> crate::input::create_streaming_distribution_input::Builder {
        crate::input::create_streaming_distribution_input::Builder::default()
    }
}

/// See [`CreateStreamingDistributionWithTagsInput`](crate::input::CreateStreamingDistributionWithTagsInput)
pub mod create_streaming_distribution_with_tags_input {
    /// A builder for [`CreateStreamingDistributionWithTagsInput`](crate::input::CreateStreamingDistributionWithTagsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) streaming_distribution_config_with_tags:
            std::option::Option<crate::model::StreamingDistributionConfigWithTags>,
    }
    impl Builder {
        /// <p> The streaming distribution's configuration information. </p>
        pub fn streaming_distribution_config_with_tags(
            mut self,
            input: crate::model::StreamingDistributionConfigWithTags,
        ) -> Self {
            self.streaming_distribution_config_with_tags = Some(input);
            self
        }
        /// <p> The streaming distribution's configuration information. </p>
        pub fn set_streaming_distribution_config_with_tags(
            mut self,
            input: std::option::Option<crate::model::StreamingDistributionConfigWithTags>,
        ) -> Self {
            self.streaming_distribution_config_with_tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateStreamingDistributionWithTagsInput`](crate::input::CreateStreamingDistributionWithTagsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateStreamingDistributionWithTagsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateStreamingDistributionWithTagsInput {
                streaming_distribution_config_with_tags: self
                    .streaming_distribution_config_with_tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateStreamingDistributionWithTagsInputOperationOutputAlias =
    crate::operation::CreateStreamingDistributionWithTags;
#[doc(hidden)]
pub type CreateStreamingDistributionWithTagsInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl CreateStreamingDistributionWithTagsInput {
    /// Consumes the builder and constructs an Operation<[`CreateStreamingDistributionWithTags`](crate::operation::CreateStreamingDistributionWithTags)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateStreamingDistributionWithTags,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateStreamingDistributionWithTagsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/2020-05-31/streaming-distribution")
                    .expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::CreateStreamingDistributionWithTagsInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                query.push_v("WithTags");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateStreamingDistributionWithTagsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/xml",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_payload_create_streaming_distribution_with_tags_input(
                &self.streaming_distribution_config_with_tags,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateStreamingDistributionWithTags::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateStreamingDistributionWithTags",
            "cloudfront",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateStreamingDistributionWithTagsInput`](crate::input::CreateStreamingDistributionWithTagsInput)
    pub fn builder() -> crate::input::create_streaming_distribution_with_tags_input::Builder {
        crate::input::create_streaming_distribution_with_tags_input::Builder::default()
    }
}

/// See [`DeleteCachePolicyInput`](crate::input::DeleteCachePolicyInput)
pub mod delete_cache_policy_input {
    /// A builder for [`DeleteCachePolicyInput`](crate::input::DeleteCachePolicyInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) if_match: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique identifier for the cache policy that you are deleting. To get the identifier, you can use <code>ListCachePolicies</code>.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the cache policy that you are deleting. To get the identifier, you can use <code>ListCachePolicies</code>.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The version of the cache policy that you are deleting. The version is the cache policy’s <code>ETag</code> value, which you can get using <code>ListCachePolicies</code>, <code>GetCachePolicy</code>, or <code>GetCachePolicyConfig</code>.</p>
        pub fn if_match(mut self, input: impl Into<std::string::String>) -> Self {
            self.if_match = Some(input.into());
            self
        }
        /// <p>The version of the cache policy that you are deleting. The version is the cache policy’s <code>ETag</code> value, which you can get using <code>ListCachePolicies</code>, <code>GetCachePolicy</code>, or <code>GetCachePolicyConfig</code>.</p>
        pub fn set_if_match(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.if_match = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteCachePolicyInput`](crate::input::DeleteCachePolicyInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteCachePolicyInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteCachePolicyInput {
                id: self.id,
                if_match: self.if_match,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteCachePolicyInputOperationOutputAlias = crate::operation::DeleteCachePolicy;
#[doc(hidden)]
pub type DeleteCachePolicyInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteCachePolicyInput {
    /// Consumes the builder and constructs an Operation<[`DeleteCachePolicy`](crate::operation::DeleteCachePolicy)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteCachePolicy,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteCachePolicyInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_5 = &_input.id;
                let input_5 = input_5.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let id = aws_smithy_http::label::fmt_string(input_5, false);
                if id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/2020-05-31/cache-policy/{Id}", Id = id)
                    .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteCachePolicyInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                let builder = crate::http_serde::add_headers_delete_cache_policy(input, builder)?;
                Ok(builder.method("DELETE").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteCachePolicy::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteCachePolicy",
            "cloudfront",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteCachePolicyInput`](crate::input::DeleteCachePolicyInput)
    pub fn builder() -> crate::input::delete_cache_policy_input::Builder {
        crate::input::delete_cache_policy_input::Builder::default()
    }
}

/// See [`DeleteCloudFrontOriginAccessIdentityInput`](crate::input::DeleteCloudFrontOriginAccessIdentityInput)
pub mod delete_cloud_front_origin_access_identity_input {
    /// A builder for [`DeleteCloudFrontOriginAccessIdentityInput`](crate::input::DeleteCloudFrontOriginAccessIdentityInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) if_match: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The origin access identity's ID.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The origin access identity's ID.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The value of the <code>ETag</code> header you received from a previous <code>GET</code> or <code>PUT</code> request. For example: <code>E2QWRUHAPOMQZL</code>.</p>
        pub fn if_match(mut self, input: impl Into<std::string::String>) -> Self {
            self.if_match = Some(input.into());
            self
        }
        /// <p>The value of the <code>ETag</code> header you received from a previous <code>GET</code> or <code>PUT</code> request. For example: <code>E2QWRUHAPOMQZL</code>.</p>
        pub fn set_if_match(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.if_match = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteCloudFrontOriginAccessIdentityInput`](crate::input::DeleteCloudFrontOriginAccessIdentityInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteCloudFrontOriginAccessIdentityInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteCloudFrontOriginAccessIdentityInput {
                id: self.id,
                if_match: self.if_match,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteCloudFrontOriginAccessIdentityInputOperationOutputAlias =
    crate::operation::DeleteCloudFrontOriginAccessIdentity;
#[doc(hidden)]
pub type DeleteCloudFrontOriginAccessIdentityInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl DeleteCloudFrontOriginAccessIdentityInput {
    /// Consumes the builder and constructs an Operation<[`DeleteCloudFrontOriginAccessIdentity`](crate::operation::DeleteCloudFrontOriginAccessIdentity)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteCloudFrontOriginAccessIdentity,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteCloudFrontOriginAccessIdentityInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_6 = &_input.id;
                let input_6 = input_6.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let id = aws_smithy_http::label::fmt_string(input_6, false);
                if id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/2020-05-31/origin-access-identity/cloudfront/{Id}",
                    Id = id
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteCloudFrontOriginAccessIdentityInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                let builder =
                    crate::http_serde::add_headers_delete_cloud_front_origin_access_identity(
                        input, builder,
                    )?;
                Ok(builder.method("DELETE").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteCloudFrontOriginAccessIdentity::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteCloudFrontOriginAccessIdentity",
            "cloudfront",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteCloudFrontOriginAccessIdentityInput`](crate::input::DeleteCloudFrontOriginAccessIdentityInput)
    pub fn builder() -> crate::input::delete_cloud_front_origin_access_identity_input::Builder {
        crate::input::delete_cloud_front_origin_access_identity_input::Builder::default()
    }
}

/// See [`DeleteDistributionInput`](crate::input::DeleteDistributionInput)
pub mod delete_distribution_input {
    /// A builder for [`DeleteDistributionInput`](crate::input::DeleteDistributionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) if_match: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The distribution ID. </p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The distribution ID. </p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The value of the <code>ETag</code> header that you received when you disabled the distribution. For example: <code>E2QWRUHAPOMQZL</code>. </p>
        pub fn if_match(mut self, input: impl Into<std::string::String>) -> Self {
            self.if_match = Some(input.into());
            self
        }
        /// <p>The value of the <code>ETag</code> header that you received when you disabled the distribution. For example: <code>E2QWRUHAPOMQZL</code>. </p>
        pub fn set_if_match(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.if_match = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteDistributionInput`](crate::input::DeleteDistributionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteDistributionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteDistributionInput {
                id: self.id,
                if_match: self.if_match,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteDistributionInputOperationOutputAlias = crate::operation::DeleteDistribution;
#[doc(hidden)]
pub type DeleteDistributionInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteDistributionInput {
    /// Consumes the builder and constructs an Operation<[`DeleteDistribution`](crate::operation::DeleteDistribution)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteDistribution,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteDistributionInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_7 = &_input.id;
                let input_7 = input_7.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let id = aws_smithy_http::label::fmt_string(input_7, false);
                if id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/2020-05-31/distribution/{Id}", Id = id)
                    .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteDistributionInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                let builder = crate::http_serde::add_headers_delete_distribution(input, builder)?;
                Ok(builder.method("DELETE").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteDistribution::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteDistribution",
            "cloudfront",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteDistributionInput`](crate::input::DeleteDistributionInput)
    pub fn builder() -> crate::input::delete_distribution_input::Builder {
        crate::input::delete_distribution_input::Builder::default()
    }
}

/// See [`DeleteFieldLevelEncryptionConfigInput`](crate::input::DeleteFieldLevelEncryptionConfigInput)
pub mod delete_field_level_encryption_config_input {
    /// A builder for [`DeleteFieldLevelEncryptionConfigInput`](crate::input::DeleteFieldLevelEncryptionConfigInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) if_match: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the configuration you want to delete from CloudFront.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The ID of the configuration you want to delete from CloudFront.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The value of the <code>ETag</code> header that you received when retrieving the configuration identity to delete. For example: <code>E2QWRUHAPOMQZL</code>.</p>
        pub fn if_match(mut self, input: impl Into<std::string::String>) -> Self {
            self.if_match = Some(input.into());
            self
        }
        /// <p>The value of the <code>ETag</code> header that you received when retrieving the configuration identity to delete. For example: <code>E2QWRUHAPOMQZL</code>.</p>
        pub fn set_if_match(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.if_match = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteFieldLevelEncryptionConfigInput`](crate::input::DeleteFieldLevelEncryptionConfigInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteFieldLevelEncryptionConfigInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteFieldLevelEncryptionConfigInput {
                id: self.id,
                if_match: self.if_match,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteFieldLevelEncryptionConfigInputOperationOutputAlias =
    crate::operation::DeleteFieldLevelEncryptionConfig;
#[doc(hidden)]
pub type DeleteFieldLevelEncryptionConfigInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl DeleteFieldLevelEncryptionConfigInput {
    /// Consumes the builder and constructs an Operation<[`DeleteFieldLevelEncryptionConfig`](crate::operation::DeleteFieldLevelEncryptionConfig)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteFieldLevelEncryptionConfig,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteFieldLevelEncryptionConfigInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_8 = &_input.id;
                let input_8 = input_8.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let id = aws_smithy_http::label::fmt_string(input_8, false);
                if id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/2020-05-31/field-level-encryption/{Id}", Id = id)
                    .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteFieldLevelEncryptionConfigInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                let builder = crate::http_serde::add_headers_delete_field_level_encryption_config(
                    input, builder,
                )?;
                Ok(builder.method("DELETE").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteFieldLevelEncryptionConfig::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteFieldLevelEncryptionConfig",
            "cloudfront",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteFieldLevelEncryptionConfigInput`](crate::input::DeleteFieldLevelEncryptionConfigInput)
    pub fn builder() -> crate::input::delete_field_level_encryption_config_input::Builder {
        crate::input::delete_field_level_encryption_config_input::Builder::default()
    }
}

/// See [`DeleteFieldLevelEncryptionProfileInput`](crate::input::DeleteFieldLevelEncryptionProfileInput)
pub mod delete_field_level_encryption_profile_input {
    /// A builder for [`DeleteFieldLevelEncryptionProfileInput`](crate::input::DeleteFieldLevelEncryptionProfileInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) if_match: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Request the ID of the profile you want to delete from CloudFront.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>Request the ID of the profile you want to delete from CloudFront.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The value of the <code>ETag</code> header that you received when retrieving the profile to delete. For example: <code>E2QWRUHAPOMQZL</code>.</p>
        pub fn if_match(mut self, input: impl Into<std::string::String>) -> Self {
            self.if_match = Some(input.into());
            self
        }
        /// <p>The value of the <code>ETag</code> header that you received when retrieving the profile to delete. For example: <code>E2QWRUHAPOMQZL</code>.</p>
        pub fn set_if_match(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.if_match = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteFieldLevelEncryptionProfileInput`](crate::input::DeleteFieldLevelEncryptionProfileInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteFieldLevelEncryptionProfileInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteFieldLevelEncryptionProfileInput {
                id: self.id,
                if_match: self.if_match,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteFieldLevelEncryptionProfileInputOperationOutputAlias =
    crate::operation::DeleteFieldLevelEncryptionProfile;
#[doc(hidden)]
pub type DeleteFieldLevelEncryptionProfileInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl DeleteFieldLevelEncryptionProfileInput {
    /// Consumes the builder and constructs an Operation<[`DeleteFieldLevelEncryptionProfile`](crate::operation::DeleteFieldLevelEncryptionProfile)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteFieldLevelEncryptionProfile,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteFieldLevelEncryptionProfileInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_9 = &_input.id;
                let input_9 = input_9.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let id = aws_smithy_http::label::fmt_string(input_9, false);
                if id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/2020-05-31/field-level-encryption-profile/{Id}",
                    Id = id
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteFieldLevelEncryptionProfileInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                let builder = crate::http_serde::add_headers_delete_field_level_encryption_profile(
                    input, builder,
                )?;
                Ok(builder.method("DELETE").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteFieldLevelEncryptionProfile::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteFieldLevelEncryptionProfile",
            "cloudfront",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteFieldLevelEncryptionProfileInput`](crate::input::DeleteFieldLevelEncryptionProfileInput)
    pub fn builder() -> crate::input::delete_field_level_encryption_profile_input::Builder {
        crate::input::delete_field_level_encryption_profile_input::Builder::default()
    }
}

/// See [`DeleteFunctionInput`](crate::input::DeleteFunctionInput)
pub mod delete_function_input {
    /// A builder for [`DeleteFunctionInput`](crate::input::DeleteFunctionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) if_match: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the function that you are deleting.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the function that you are deleting.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The current version (<code>ETag</code> value) of the function that you are deleting, which you can get using <code>DescribeFunction</code>.</p>
        pub fn if_match(mut self, input: impl Into<std::string::String>) -> Self {
            self.if_match = Some(input.into());
            self
        }
        /// <p>The current version (<code>ETag</code> value) of the function that you are deleting, which you can get using <code>DescribeFunction</code>.</p>
        pub fn set_if_match(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.if_match = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteFunctionInput`](crate::input::DeleteFunctionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteFunctionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteFunctionInput {
                name: self.name,
                if_match: self.if_match,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteFunctionInputOperationOutputAlias = crate::operation::DeleteFunction;
#[doc(hidden)]
pub type DeleteFunctionInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteFunctionInput {
    /// Consumes the builder and constructs an Operation<[`DeleteFunction`](crate::operation::DeleteFunction)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteFunction,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteFunctionInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_10 = &_input.name;
                let input_10 = input_10.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let name = aws_smithy_http::label::fmt_string(input_10, false);
                if name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/2020-05-31/function/{Name}", Name = name)
                    .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteFunctionInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                let builder = crate::http_serde::add_headers_delete_function(input, builder)?;
                Ok(builder.method("DELETE").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteFunction::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteFunction",
            "cloudfront",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteFunctionInput`](crate::input::DeleteFunctionInput)
    pub fn builder() -> crate::input::delete_function_input::Builder {
        crate::input::delete_function_input::Builder::default()
    }
}

/// See [`DeleteKeyGroupInput`](crate::input::DeleteKeyGroupInput)
pub mod delete_key_group_input {
    /// A builder for [`DeleteKeyGroupInput`](crate::input::DeleteKeyGroupInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) if_match: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier of the key group that you are deleting. To get the identifier, use <code>ListKeyGroups</code>.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The identifier of the key group that you are deleting. To get the identifier, use <code>ListKeyGroups</code>.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The version of the key group that you are deleting. The version is the key group’s <code>ETag</code> value. To get the <code>ETag</code>, use <code>GetKeyGroup</code> or <code>GetKeyGroupConfig</code>.</p>
        pub fn if_match(mut self, input: impl Into<std::string::String>) -> Self {
            self.if_match = Some(input.into());
            self
        }
        /// <p>The version of the key group that you are deleting. The version is the key group’s <code>ETag</code> value. To get the <code>ETag</code>, use <code>GetKeyGroup</code> or <code>GetKeyGroupConfig</code>.</p>
        pub fn set_if_match(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.if_match = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteKeyGroupInput`](crate::input::DeleteKeyGroupInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteKeyGroupInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteKeyGroupInput {
                id: self.id,
                if_match: self.if_match,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteKeyGroupInputOperationOutputAlias = crate::operation::DeleteKeyGroup;
#[doc(hidden)]
pub type DeleteKeyGroupInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteKeyGroupInput {
    /// Consumes the builder and constructs an Operation<[`DeleteKeyGroup`](crate::operation::DeleteKeyGroup)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteKeyGroup,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteKeyGroupInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_11 = &_input.id;
                let input_11 = input_11.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let id = aws_smithy_http::label::fmt_string(input_11, false);
                if id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/2020-05-31/key-group/{Id}", Id = id)
                    .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteKeyGroupInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                let builder = crate::http_serde::add_headers_delete_key_group(input, builder)?;
                Ok(builder.method("DELETE").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteKeyGroup::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteKeyGroup",
            "cloudfront",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteKeyGroupInput`](crate::input::DeleteKeyGroupInput)
    pub fn builder() -> crate::input::delete_key_group_input::Builder {
        crate::input::delete_key_group_input::Builder::default()
    }
}

/// See [`DeleteMonitoringSubscriptionInput`](crate::input::DeleteMonitoringSubscriptionInput)
pub mod delete_monitoring_subscription_input {
    /// A builder for [`DeleteMonitoringSubscriptionInput`](crate::input::DeleteMonitoringSubscriptionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) distribution_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the distribution that you are disabling metrics for.</p>
        pub fn distribution_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.distribution_id = Some(input.into());
            self
        }
        /// <p>The ID of the distribution that you are disabling metrics for.</p>
        pub fn set_distribution_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.distribution_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteMonitoringSubscriptionInput`](crate::input::DeleteMonitoringSubscriptionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteMonitoringSubscriptionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteMonitoringSubscriptionInput {
                distribution_id: self.distribution_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteMonitoringSubscriptionInputOperationOutputAlias =
    crate::operation::DeleteMonitoringSubscription;
#[doc(hidden)]
pub type DeleteMonitoringSubscriptionInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl DeleteMonitoringSubscriptionInput {
    /// Consumes the builder and constructs an Operation<[`DeleteMonitoringSubscription`](crate::operation::DeleteMonitoringSubscription)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteMonitoringSubscription,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteMonitoringSubscriptionInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_12 = &_input.distribution_id;
                let input_12 = input_12.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "distribution_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let distribution_id = aws_smithy_http::label::fmt_string(input_12, false);
                if distribution_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "distribution_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/2020-05-31/distributions/{DistributionId}/monitoring-subscription",
                    DistributionId = distribution_id
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteMonitoringSubscriptionInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("DELETE").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteMonitoringSubscription::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteMonitoringSubscription",
            "cloudfront",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteMonitoringSubscriptionInput`](crate::input::DeleteMonitoringSubscriptionInput)
    pub fn builder() -> crate::input::delete_monitoring_subscription_input::Builder {
        crate::input::delete_monitoring_subscription_input::Builder::default()
    }
}

/// See [`DeleteOriginRequestPolicyInput`](crate::input::DeleteOriginRequestPolicyInput)
pub mod delete_origin_request_policy_input {
    /// A builder for [`DeleteOriginRequestPolicyInput`](crate::input::DeleteOriginRequestPolicyInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) if_match: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique identifier for the origin request policy that you are deleting. To get the identifier, you can use <code>ListOriginRequestPolicies</code>.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the origin request policy that you are deleting. To get the identifier, you can use <code>ListOriginRequestPolicies</code>.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The version of the origin request policy that you are deleting. The version is the origin request policy’s <code>ETag</code> value, which you can get using <code>ListOriginRequestPolicies</code>, <code>GetOriginRequestPolicy</code>, or <code>GetOriginRequestPolicyConfig</code>.</p>
        pub fn if_match(mut self, input: impl Into<std::string::String>) -> Self {
            self.if_match = Some(input.into());
            self
        }
        /// <p>The version of the origin request policy that you are deleting. The version is the origin request policy’s <code>ETag</code> value, which you can get using <code>ListOriginRequestPolicies</code>, <code>GetOriginRequestPolicy</code>, or <code>GetOriginRequestPolicyConfig</code>.</p>
        pub fn set_if_match(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.if_match = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteOriginRequestPolicyInput`](crate::input::DeleteOriginRequestPolicyInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteOriginRequestPolicyInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteOriginRequestPolicyInput {
                id: self.id,
                if_match: self.if_match,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteOriginRequestPolicyInputOperationOutputAlias =
    crate::operation::DeleteOriginRequestPolicy;
#[doc(hidden)]
pub type DeleteOriginRequestPolicyInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteOriginRequestPolicyInput {
    /// Consumes the builder and constructs an Operation<[`DeleteOriginRequestPolicy`](crate::operation::DeleteOriginRequestPolicy)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteOriginRequestPolicy,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteOriginRequestPolicyInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_13 = &_input.id;
                let input_13 = input_13.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let id = aws_smithy_http::label::fmt_string(input_13, false);
                if id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/2020-05-31/origin-request-policy/{Id}", Id = id)
                    .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteOriginRequestPolicyInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                let builder =
                    crate::http_serde::add_headers_delete_origin_request_policy(input, builder)?;
                Ok(builder.method("DELETE").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteOriginRequestPolicy::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteOriginRequestPolicy",
            "cloudfront",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteOriginRequestPolicyInput`](crate::input::DeleteOriginRequestPolicyInput)
    pub fn builder() -> crate::input::delete_origin_request_policy_input::Builder {
        crate::input::delete_origin_request_policy_input::Builder::default()
    }
}

/// See [`DeletePublicKeyInput`](crate::input::DeletePublicKeyInput)
pub mod delete_public_key_input {
    /// A builder for [`DeletePublicKeyInput`](crate::input::DeletePublicKeyInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) if_match: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the public key you want to remove from CloudFront.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The ID of the public key you want to remove from CloudFront.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The value of the <code>ETag</code> header that you received when retrieving the public key identity to delete. For example: <code>E2QWRUHAPOMQZL</code>.</p>
        pub fn if_match(mut self, input: impl Into<std::string::String>) -> Self {
            self.if_match = Some(input.into());
            self
        }
        /// <p>The value of the <code>ETag</code> header that you received when retrieving the public key identity to delete. For example: <code>E2QWRUHAPOMQZL</code>.</p>
        pub fn set_if_match(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.if_match = input;
            self
        }
        /// Consumes the builder and constructs a [`DeletePublicKeyInput`](crate::input::DeletePublicKeyInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeletePublicKeyInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeletePublicKeyInput {
                id: self.id,
                if_match: self.if_match,
            })
        }
    }
}
#[doc(hidden)]
pub type DeletePublicKeyInputOperationOutputAlias = crate::operation::DeletePublicKey;
#[doc(hidden)]
pub type DeletePublicKeyInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeletePublicKeyInput {
    /// Consumes the builder and constructs an Operation<[`DeletePublicKey`](crate::operation::DeletePublicKey)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeletePublicKey,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeletePublicKeyInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_14 = &_input.id;
                let input_14 = input_14.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let id = aws_smithy_http::label::fmt_string(input_14, false);
                if id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/2020-05-31/public-key/{Id}", Id = id)
                    .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeletePublicKeyInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                let builder = crate::http_serde::add_headers_delete_public_key(input, builder)?;
                Ok(builder.method("DELETE").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeletePublicKey::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeletePublicKey",
            "cloudfront",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeletePublicKeyInput`](crate::input::DeletePublicKeyInput)
    pub fn builder() -> crate::input::delete_public_key_input::Builder {
        crate::input::delete_public_key_input::Builder::default()
    }
}

/// See [`DeleteRealtimeLogConfigInput`](crate::input::DeleteRealtimeLogConfigInput)
pub mod delete_realtime_log_config_input {
    /// A builder for [`DeleteRealtimeLogConfigInput`](crate::input::DeleteRealtimeLogConfigInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the real-time log configuration to delete.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the real-time log configuration to delete.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the real-time log configuration to delete.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the real-time log configuration to delete.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteRealtimeLogConfigInput`](crate::input::DeleteRealtimeLogConfigInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteRealtimeLogConfigInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteRealtimeLogConfigInput {
                name: self.name,
                arn: self.arn,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteRealtimeLogConfigInputOperationOutputAlias =
    crate::operation::DeleteRealtimeLogConfig;
#[doc(hidden)]
pub type DeleteRealtimeLogConfigInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteRealtimeLogConfigInput {
    /// Consumes the builder and constructs an Operation<[`DeleteRealtimeLogConfig`](crate::operation::DeleteRealtimeLogConfig)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteRealtimeLogConfig,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteRealtimeLogConfigInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/2020-05-31/delete-realtime-log-config")
                    .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteRealtimeLogConfigInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/xml",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_delete_realtime_log_config(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteRealtimeLogConfig::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteRealtimeLogConfig",
            "cloudfront",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteRealtimeLogConfigInput`](crate::input::DeleteRealtimeLogConfigInput)
    pub fn builder() -> crate::input::delete_realtime_log_config_input::Builder {
        crate::input::delete_realtime_log_config_input::Builder::default()
    }
}

/// See [`DeleteResponseHeadersPolicyInput`](crate::input::DeleteResponseHeadersPolicyInput)
pub mod delete_response_headers_policy_input {
    /// A builder for [`DeleteResponseHeadersPolicyInput`](crate::input::DeleteResponseHeadersPolicyInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) if_match: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier for the response headers policy that you are deleting.</p>
        /// <p>To get the identifier, you can use <code>ListResponseHeadersPolicies</code>.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The identifier for the response headers policy that you are deleting.</p>
        /// <p>To get the identifier, you can use <code>ListResponseHeadersPolicies</code>.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The version of the response headers policy that you are deleting.</p>
        /// <p>The version is the response headers policy’s <code>ETag</code> value, which you can get using <code>ListResponseHeadersPolicies</code>, <code>GetResponseHeadersPolicy</code>, or <code>GetResponseHeadersPolicyConfig</code>.</p>
        pub fn if_match(mut self, input: impl Into<std::string::String>) -> Self {
            self.if_match = Some(input.into());
            self
        }
        /// <p>The version of the response headers policy that you are deleting.</p>
        /// <p>The version is the response headers policy’s <code>ETag</code> value, which you can get using <code>ListResponseHeadersPolicies</code>, <code>GetResponseHeadersPolicy</code>, or <code>GetResponseHeadersPolicyConfig</code>.</p>
        pub fn set_if_match(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.if_match = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteResponseHeadersPolicyInput`](crate::input::DeleteResponseHeadersPolicyInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteResponseHeadersPolicyInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteResponseHeadersPolicyInput {
                id: self.id,
                if_match: self.if_match,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteResponseHeadersPolicyInputOperationOutputAlias =
    crate::operation::DeleteResponseHeadersPolicy;
#[doc(hidden)]
pub type DeleteResponseHeadersPolicyInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteResponseHeadersPolicyInput {
    /// Consumes the builder and constructs an Operation<[`DeleteResponseHeadersPolicy`](crate::operation::DeleteResponseHeadersPolicy)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteResponseHeadersPolicy,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteResponseHeadersPolicyInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_15 = &_input.id;
                let input_15 = input_15.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let id = aws_smithy_http::label::fmt_string(input_15, false);
                if id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/2020-05-31/response-headers-policy/{Id}", Id = id)
                    .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteResponseHeadersPolicyInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                let builder =
                    crate::http_serde::add_headers_delete_response_headers_policy(input, builder)?;
                Ok(builder.method("DELETE").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteResponseHeadersPolicy::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteResponseHeadersPolicy",
            "cloudfront",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteResponseHeadersPolicyInput`](crate::input::DeleteResponseHeadersPolicyInput)
    pub fn builder() -> crate::input::delete_response_headers_policy_input::Builder {
        crate::input::delete_response_headers_policy_input::Builder::default()
    }
}

/// See [`DeleteStreamingDistributionInput`](crate::input::DeleteStreamingDistributionInput)
pub mod delete_streaming_distribution_input {
    /// A builder for [`DeleteStreamingDistributionInput`](crate::input::DeleteStreamingDistributionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) if_match: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The distribution ID. </p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The distribution ID. </p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The value of the <code>ETag</code> header that you received when you disabled the streaming distribution. For example: <code>E2QWRUHAPOMQZL</code>.</p>
        pub fn if_match(mut self, input: impl Into<std::string::String>) -> Self {
            self.if_match = Some(input.into());
            self
        }
        /// <p>The value of the <code>ETag</code> header that you received when you disabled the streaming distribution. For example: <code>E2QWRUHAPOMQZL</code>.</p>
        pub fn set_if_match(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.if_match = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteStreamingDistributionInput`](crate::input::DeleteStreamingDistributionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteStreamingDistributionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteStreamingDistributionInput {
                id: self.id,
                if_match: self.if_match,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteStreamingDistributionInputOperationOutputAlias =
    crate::operation::DeleteStreamingDistribution;
#[doc(hidden)]
pub type DeleteStreamingDistributionInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteStreamingDistributionInput {
    /// Consumes the builder and constructs an Operation<[`DeleteStreamingDistribution`](crate::operation::DeleteStreamingDistribution)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteStreamingDistribution,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteStreamingDistributionInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_16 = &_input.id;
                let input_16 = input_16.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let id = aws_smithy_http::label::fmt_string(input_16, false);
                if id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/2020-05-31/streaming-distribution/{Id}", Id = id)
                    .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteStreamingDistributionInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                let builder =
                    crate::http_serde::add_headers_delete_streaming_distribution(input, builder)?;
                Ok(builder.method("DELETE").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteStreamingDistribution::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteStreamingDistribution",
            "cloudfront",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteStreamingDistributionInput`](crate::input::DeleteStreamingDistributionInput)
    pub fn builder() -> crate::input::delete_streaming_distribution_input::Builder {
        crate::input::delete_streaming_distribution_input::Builder::default()
    }
}

/// See [`DescribeFunctionInput`](crate::input::DescribeFunctionInput)
pub mod describe_function_input {
    /// A builder for [`DescribeFunctionInput`](crate::input::DescribeFunctionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) stage: std::option::Option<crate::model::FunctionStage>,
    }
    impl Builder {
        /// <p>The name of the function that you are getting information about.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the function that you are getting information about.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The function’s stage, either <code>DEVELOPMENT</code> or <code>LIVE</code>.</p>
        pub fn stage(mut self, input: crate::model::FunctionStage) -> Self {
            self.stage = Some(input);
            self
        }
        /// <p>The function’s stage, either <code>DEVELOPMENT</code> or <code>LIVE</code>.</p>
        pub fn set_stage(
            mut self,
            input: std::option::Option<crate::model::FunctionStage>,
        ) -> Self {
            self.stage = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeFunctionInput`](crate::input::DescribeFunctionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeFunctionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeFunctionInput {
                name: self.name,
                stage: self.stage,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeFunctionInputOperationOutputAlias = crate::operation::DescribeFunction;
#[doc(hidden)]
pub type DescribeFunctionInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeFunctionInput {
    /// Consumes the builder and constructs an Operation<[`DescribeFunction`](crate::operation::DescribeFunction)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeFunction,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DescribeFunctionInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_17 = &_input.name;
                let input_17 = input_17.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let name = aws_smithy_http::label::fmt_string(input_17, false);
                if name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/2020-05-31/function/{Name}/describe", Name = name)
                    .expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::DescribeFunctionInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_18) = &_input.stage {
                    query.push_kv("Stage", &aws_smithy_http::query::fmt_string(&inner_18));
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DescribeFunctionInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeFunction::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeFunction",
            "cloudfront",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DescribeFunctionInput`](crate::input::DescribeFunctionInput)
    pub fn builder() -> crate::input::describe_function_input::Builder {
        crate::input::describe_function_input::Builder::default()
    }
}

/// See [`GetCachePolicyInput`](crate::input::GetCachePolicyInput)
pub mod get_cache_policy_input {
    /// A builder for [`GetCachePolicyInput`](crate::input::GetCachePolicyInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique identifier for the cache policy. If the cache policy is attached to a distribution’s cache behavior, you can get the policy’s identifier using <code>ListDistributions</code> or <code>GetDistribution</code>. If the cache policy is not attached to a cache behavior, you can get the identifier using <code>ListCachePolicies</code>.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the cache policy. If the cache policy is attached to a distribution’s cache behavior, you can get the policy’s identifier using <code>ListDistributions</code> or <code>GetDistribution</code>. If the cache policy is not attached to a cache behavior, you can get the identifier using <code>ListCachePolicies</code>.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetCachePolicyInput`](crate::input::GetCachePolicyInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetCachePolicyInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetCachePolicyInput { id: self.id })
        }
    }
}
#[doc(hidden)]
pub type GetCachePolicyInputOperationOutputAlias = crate::operation::GetCachePolicy;
#[doc(hidden)]
pub type GetCachePolicyInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetCachePolicyInput {
    /// Consumes the builder and constructs an Operation<[`GetCachePolicy`](crate::operation::GetCachePolicy)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetCachePolicy,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetCachePolicyInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_19 = &_input.id;
                let input_19 = input_19.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let id = aws_smithy_http::label::fmt_string(input_19, false);
                if id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/2020-05-31/cache-policy/{Id}", Id = id)
                    .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetCachePolicyInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetCachePolicy::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetCachePolicy",
            "cloudfront",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetCachePolicyInput`](crate::input::GetCachePolicyInput)
    pub fn builder() -> crate::input::get_cache_policy_input::Builder {
        crate::input::get_cache_policy_input::Builder::default()
    }
}

/// See [`GetCachePolicyConfigInput`](crate::input::GetCachePolicyConfigInput)
pub mod get_cache_policy_config_input {
    /// A builder for [`GetCachePolicyConfigInput`](crate::input::GetCachePolicyConfigInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique identifier for the cache policy. If the cache policy is attached to a distribution’s cache behavior, you can get the policy’s identifier using <code>ListDistributions</code> or <code>GetDistribution</code>. If the cache policy is not attached to a cache behavior, you can get the identifier using <code>ListCachePolicies</code>.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the cache policy. If the cache policy is attached to a distribution’s cache behavior, you can get the policy’s identifier using <code>ListDistributions</code> or <code>GetDistribution</code>. If the cache policy is not attached to a cache behavior, you can get the identifier using <code>ListCachePolicies</code>.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetCachePolicyConfigInput`](crate::input::GetCachePolicyConfigInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetCachePolicyConfigInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetCachePolicyConfigInput { id: self.id })
        }
    }
}
#[doc(hidden)]
pub type GetCachePolicyConfigInputOperationOutputAlias = crate::operation::GetCachePolicyConfig;
#[doc(hidden)]
pub type GetCachePolicyConfigInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetCachePolicyConfigInput {
    /// Consumes the builder and constructs an Operation<[`GetCachePolicyConfig`](crate::operation::GetCachePolicyConfig)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetCachePolicyConfig,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetCachePolicyConfigInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_20 = &_input.id;
                let input_20 = input_20.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let id = aws_smithy_http::label::fmt_string(input_20, false);
                if id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/2020-05-31/cache-policy/{Id}/config", Id = id)
                    .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetCachePolicyConfigInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetCachePolicyConfig::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetCachePolicyConfig",
            "cloudfront",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetCachePolicyConfigInput`](crate::input::GetCachePolicyConfigInput)
    pub fn builder() -> crate::input::get_cache_policy_config_input::Builder {
        crate::input::get_cache_policy_config_input::Builder::default()
    }
}

/// See [`GetCloudFrontOriginAccessIdentityInput`](crate::input::GetCloudFrontOriginAccessIdentityInput)
pub mod get_cloud_front_origin_access_identity_input {
    /// A builder for [`GetCloudFrontOriginAccessIdentityInput`](crate::input::GetCloudFrontOriginAccessIdentityInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identity's ID.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The identity's ID.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetCloudFrontOriginAccessIdentityInput`](crate::input::GetCloudFrontOriginAccessIdentityInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetCloudFrontOriginAccessIdentityInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetCloudFrontOriginAccessIdentityInput { id: self.id })
        }
    }
}
#[doc(hidden)]
pub type GetCloudFrontOriginAccessIdentityInputOperationOutputAlias =
    crate::operation::GetCloudFrontOriginAccessIdentity;
#[doc(hidden)]
pub type GetCloudFrontOriginAccessIdentityInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl GetCloudFrontOriginAccessIdentityInput {
    /// Consumes the builder and constructs an Operation<[`GetCloudFrontOriginAccessIdentity`](crate::operation::GetCloudFrontOriginAccessIdentity)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetCloudFrontOriginAccessIdentity,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetCloudFrontOriginAccessIdentityInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_21 = &_input.id;
                let input_21 = input_21.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let id = aws_smithy_http::label::fmt_string(input_21, false);
                if id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/2020-05-31/origin-access-identity/cloudfront/{Id}",
                    Id = id
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetCloudFrontOriginAccessIdentityInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetCloudFrontOriginAccessIdentity::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetCloudFrontOriginAccessIdentity",
            "cloudfront",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetCloudFrontOriginAccessIdentityInput`](crate::input::GetCloudFrontOriginAccessIdentityInput)
    pub fn builder() -> crate::input::get_cloud_front_origin_access_identity_input::Builder {
        crate::input::get_cloud_front_origin_access_identity_input::Builder::default()
    }
}

/// See [`GetCloudFrontOriginAccessIdentityConfigInput`](crate::input::GetCloudFrontOriginAccessIdentityConfigInput)
pub mod get_cloud_front_origin_access_identity_config_input {
    /// A builder for [`GetCloudFrontOriginAccessIdentityConfigInput`](crate::input::GetCloudFrontOriginAccessIdentityConfigInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identity's ID. </p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The identity's ID. </p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetCloudFrontOriginAccessIdentityConfigInput`](crate::input::GetCloudFrontOriginAccessIdentityConfigInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetCloudFrontOriginAccessIdentityConfigInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetCloudFrontOriginAccessIdentityConfigInput { id: self.id })
        }
    }
}
#[doc(hidden)]
pub type GetCloudFrontOriginAccessIdentityConfigInputOperationOutputAlias =
    crate::operation::GetCloudFrontOriginAccessIdentityConfig;
#[doc(hidden)]
pub type GetCloudFrontOriginAccessIdentityConfigInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl GetCloudFrontOriginAccessIdentityConfigInput {
    /// Consumes the builder and constructs an Operation<[`GetCloudFrontOriginAccessIdentityConfig`](crate::operation::GetCloudFrontOriginAccessIdentityConfig)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetCloudFrontOriginAccessIdentityConfig,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetCloudFrontOriginAccessIdentityConfigInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_22 = &_input.id;
                let input_22 = input_22.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let id = aws_smithy_http::label::fmt_string(input_22, false);
                if id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/2020-05-31/origin-access-identity/cloudfront/{Id}/config",
                    Id = id
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetCloudFrontOriginAccessIdentityConfigInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetCloudFrontOriginAccessIdentityConfig::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetCloudFrontOriginAccessIdentityConfig",
            "cloudfront",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetCloudFrontOriginAccessIdentityConfigInput`](crate::input::GetCloudFrontOriginAccessIdentityConfigInput)
    pub fn builder() -> crate::input::get_cloud_front_origin_access_identity_config_input::Builder {
        crate::input::get_cloud_front_origin_access_identity_config_input::Builder::default()
    }
}

/// See [`GetDistributionInput`](crate::input::GetDistributionInput)
pub mod get_distribution_input {
    /// A builder for [`GetDistributionInput`](crate::input::GetDistributionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The distribution's ID. If the ID is empty, an empty distribution configuration is returned.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The distribution's ID. If the ID is empty, an empty distribution configuration is returned.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetDistributionInput`](crate::input::GetDistributionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetDistributionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetDistributionInput { id: self.id })
        }
    }
}
#[doc(hidden)]
pub type GetDistributionInputOperationOutputAlias = crate::operation::GetDistribution;
#[doc(hidden)]
pub type GetDistributionInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetDistributionInput {
    /// Consumes the builder and constructs an Operation<[`GetDistribution`](crate::operation::GetDistribution)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetDistribution,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetDistributionInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_23 = &_input.id;
                let input_23 = input_23.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let id = aws_smithy_http::label::fmt_string(input_23, false);
                if id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/2020-05-31/distribution/{Id}", Id = id)
                    .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetDistributionInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetDistribution::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetDistribution",
            "cloudfront",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetDistributionInput`](crate::input::GetDistributionInput)
    pub fn builder() -> crate::input::get_distribution_input::Builder {
        crate::input::get_distribution_input::Builder::default()
    }
}

/// See [`GetDistributionConfigInput`](crate::input::GetDistributionConfigInput)
pub mod get_distribution_config_input {
    /// A builder for [`GetDistributionConfigInput`](crate::input::GetDistributionConfigInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The distribution's ID. If the ID is empty, an empty distribution configuration is returned.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The distribution's ID. If the ID is empty, an empty distribution configuration is returned.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetDistributionConfigInput`](crate::input::GetDistributionConfigInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetDistributionConfigInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetDistributionConfigInput { id: self.id })
        }
    }
}
#[doc(hidden)]
pub type GetDistributionConfigInputOperationOutputAlias = crate::operation::GetDistributionConfig;
#[doc(hidden)]
pub type GetDistributionConfigInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetDistributionConfigInput {
    /// Consumes the builder and constructs an Operation<[`GetDistributionConfig`](crate::operation::GetDistributionConfig)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetDistributionConfig,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetDistributionConfigInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_24 = &_input.id;
                let input_24 = input_24.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let id = aws_smithy_http::label::fmt_string(input_24, false);
                if id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/2020-05-31/distribution/{Id}/config", Id = id)
                    .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetDistributionConfigInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetDistributionConfig::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetDistributionConfig",
            "cloudfront",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetDistributionConfigInput`](crate::input::GetDistributionConfigInput)
    pub fn builder() -> crate::input::get_distribution_config_input::Builder {
        crate::input::get_distribution_config_input::Builder::default()
    }
}

/// See [`GetFieldLevelEncryptionInput`](crate::input::GetFieldLevelEncryptionInput)
pub mod get_field_level_encryption_input {
    /// A builder for [`GetFieldLevelEncryptionInput`](crate::input::GetFieldLevelEncryptionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Request the ID for the field-level encryption configuration information.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>Request the ID for the field-level encryption configuration information.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetFieldLevelEncryptionInput`](crate::input::GetFieldLevelEncryptionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetFieldLevelEncryptionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetFieldLevelEncryptionInput { id: self.id })
        }
    }
}
#[doc(hidden)]
pub type GetFieldLevelEncryptionInputOperationOutputAlias =
    crate::operation::GetFieldLevelEncryption;
#[doc(hidden)]
pub type GetFieldLevelEncryptionInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetFieldLevelEncryptionInput {
    /// Consumes the builder and constructs an Operation<[`GetFieldLevelEncryption`](crate::operation::GetFieldLevelEncryption)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetFieldLevelEncryption,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetFieldLevelEncryptionInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_25 = &_input.id;
                let input_25 = input_25.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let id = aws_smithy_http::label::fmt_string(input_25, false);
                if id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/2020-05-31/field-level-encryption/{Id}", Id = id)
                    .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetFieldLevelEncryptionInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetFieldLevelEncryption::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetFieldLevelEncryption",
            "cloudfront",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetFieldLevelEncryptionInput`](crate::input::GetFieldLevelEncryptionInput)
    pub fn builder() -> crate::input::get_field_level_encryption_input::Builder {
        crate::input::get_field_level_encryption_input::Builder::default()
    }
}

/// See [`GetFieldLevelEncryptionConfigInput`](crate::input::GetFieldLevelEncryptionConfigInput)
pub mod get_field_level_encryption_config_input {
    /// A builder for [`GetFieldLevelEncryptionConfigInput`](crate::input::GetFieldLevelEncryptionConfigInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Request the ID for the field-level encryption configuration information.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>Request the ID for the field-level encryption configuration information.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetFieldLevelEncryptionConfigInput`](crate::input::GetFieldLevelEncryptionConfigInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetFieldLevelEncryptionConfigInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetFieldLevelEncryptionConfigInput { id: self.id })
        }
    }
}
#[doc(hidden)]
pub type GetFieldLevelEncryptionConfigInputOperationOutputAlias =
    crate::operation::GetFieldLevelEncryptionConfig;
#[doc(hidden)]
pub type GetFieldLevelEncryptionConfigInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl GetFieldLevelEncryptionConfigInput {
    /// Consumes the builder and constructs an Operation<[`GetFieldLevelEncryptionConfig`](crate::operation::GetFieldLevelEncryptionConfig)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetFieldLevelEncryptionConfig,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetFieldLevelEncryptionConfigInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_26 = &_input.id;
                let input_26 = input_26.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let id = aws_smithy_http::label::fmt_string(input_26, false);
                if id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/2020-05-31/field-level-encryption/{Id}/config",
                    Id = id
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetFieldLevelEncryptionConfigInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetFieldLevelEncryptionConfig::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetFieldLevelEncryptionConfig",
            "cloudfront",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetFieldLevelEncryptionConfigInput`](crate::input::GetFieldLevelEncryptionConfigInput)
    pub fn builder() -> crate::input::get_field_level_encryption_config_input::Builder {
        crate::input::get_field_level_encryption_config_input::Builder::default()
    }
}

/// See [`GetFieldLevelEncryptionProfileInput`](crate::input::GetFieldLevelEncryptionProfileInput)
pub mod get_field_level_encryption_profile_input {
    /// A builder for [`GetFieldLevelEncryptionProfileInput`](crate::input::GetFieldLevelEncryptionProfileInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Get the ID for the field-level encryption profile information.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>Get the ID for the field-level encryption profile information.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetFieldLevelEncryptionProfileInput`](crate::input::GetFieldLevelEncryptionProfileInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetFieldLevelEncryptionProfileInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetFieldLevelEncryptionProfileInput { id: self.id })
        }
    }
}
#[doc(hidden)]
pub type GetFieldLevelEncryptionProfileInputOperationOutputAlias =
    crate::operation::GetFieldLevelEncryptionProfile;
#[doc(hidden)]
pub type GetFieldLevelEncryptionProfileInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl GetFieldLevelEncryptionProfileInput {
    /// Consumes the builder and constructs an Operation<[`GetFieldLevelEncryptionProfile`](crate::operation::GetFieldLevelEncryptionProfile)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetFieldLevelEncryptionProfile,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetFieldLevelEncryptionProfileInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_27 = &_input.id;
                let input_27 = input_27.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let id = aws_smithy_http::label::fmt_string(input_27, false);
                if id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/2020-05-31/field-level-encryption-profile/{Id}",
                    Id = id
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetFieldLevelEncryptionProfileInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetFieldLevelEncryptionProfile::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetFieldLevelEncryptionProfile",
            "cloudfront",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetFieldLevelEncryptionProfileInput`](crate::input::GetFieldLevelEncryptionProfileInput)
    pub fn builder() -> crate::input::get_field_level_encryption_profile_input::Builder {
        crate::input::get_field_level_encryption_profile_input::Builder::default()
    }
}

/// See [`GetFieldLevelEncryptionProfileConfigInput`](crate::input::GetFieldLevelEncryptionProfileConfigInput)
pub mod get_field_level_encryption_profile_config_input {
    /// A builder for [`GetFieldLevelEncryptionProfileConfigInput`](crate::input::GetFieldLevelEncryptionProfileConfigInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Get the ID for the field-level encryption profile configuration information.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>Get the ID for the field-level encryption profile configuration information.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetFieldLevelEncryptionProfileConfigInput`](crate::input::GetFieldLevelEncryptionProfileConfigInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetFieldLevelEncryptionProfileConfigInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetFieldLevelEncryptionProfileConfigInput { id: self.id })
        }
    }
}
#[doc(hidden)]
pub type GetFieldLevelEncryptionProfileConfigInputOperationOutputAlias =
    crate::operation::GetFieldLevelEncryptionProfileConfig;
#[doc(hidden)]
pub type GetFieldLevelEncryptionProfileConfigInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl GetFieldLevelEncryptionProfileConfigInput {
    /// Consumes the builder and constructs an Operation<[`GetFieldLevelEncryptionProfileConfig`](crate::operation::GetFieldLevelEncryptionProfileConfig)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetFieldLevelEncryptionProfileConfig,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetFieldLevelEncryptionProfileConfigInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_28 = &_input.id;
                let input_28 = input_28.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let id = aws_smithy_http::label::fmt_string(input_28, false);
                if id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/2020-05-31/field-level-encryption-profile/{Id}/config",
                    Id = id
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetFieldLevelEncryptionProfileConfigInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetFieldLevelEncryptionProfileConfig::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetFieldLevelEncryptionProfileConfig",
            "cloudfront",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetFieldLevelEncryptionProfileConfigInput`](crate::input::GetFieldLevelEncryptionProfileConfigInput)
    pub fn builder() -> crate::input::get_field_level_encryption_profile_config_input::Builder {
        crate::input::get_field_level_encryption_profile_config_input::Builder::default()
    }
}

/// See [`GetFunctionInput`](crate::input::GetFunctionInput)
pub mod get_function_input {
    /// A builder for [`GetFunctionInput`](crate::input::GetFunctionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) stage: std::option::Option<crate::model::FunctionStage>,
    }
    impl Builder {
        /// <p>The name of the function whose code you are getting.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the function whose code you are getting.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The function’s stage, either <code>DEVELOPMENT</code> or <code>LIVE</code>.</p>
        pub fn stage(mut self, input: crate::model::FunctionStage) -> Self {
            self.stage = Some(input);
            self
        }
        /// <p>The function’s stage, either <code>DEVELOPMENT</code> or <code>LIVE</code>.</p>
        pub fn set_stage(
            mut self,
            input: std::option::Option<crate::model::FunctionStage>,
        ) -> Self {
            self.stage = input;
            self
        }
        /// Consumes the builder and constructs a [`GetFunctionInput`](crate::input::GetFunctionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetFunctionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetFunctionInput {
                name: self.name,
                stage: self.stage,
            })
        }
    }
}
#[doc(hidden)]
pub type GetFunctionInputOperationOutputAlias = crate::operation::GetFunction;
#[doc(hidden)]
pub type GetFunctionInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetFunctionInput {
    /// Consumes the builder and constructs an Operation<[`GetFunction`](crate::operation::GetFunction)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetFunction,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetFunctionInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_29 = &_input.name;
                let input_29 = input_29.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let name = aws_smithy_http::label::fmt_string(input_29, false);
                if name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/2020-05-31/function/{Name}", Name = name)
                    .expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::GetFunctionInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_30) = &_input.stage {
                    query.push_kv("Stage", &aws_smithy_http::query::fmt_string(&inner_30));
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetFunctionInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetFunction::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetFunction",
            "cloudfront",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetFunctionInput`](crate::input::GetFunctionInput)
    pub fn builder() -> crate::input::get_function_input::Builder {
        crate::input::get_function_input::Builder::default()
    }
}

/// See [`GetInvalidationInput`](crate::input::GetInvalidationInput)
pub mod get_invalidation_input {
    /// A builder for [`GetInvalidationInput`](crate::input::GetInvalidationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) distribution_id: std::option::Option<std::string::String>,
        pub(crate) id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The distribution's ID.</p>
        pub fn distribution_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.distribution_id = Some(input.into());
            self
        }
        /// <p>The distribution's ID.</p>
        pub fn set_distribution_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.distribution_id = input;
            self
        }
        /// <p>The identifier for the invalidation request, for example, <code>IDFDVBD632BHDS5</code>.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The identifier for the invalidation request, for example, <code>IDFDVBD632BHDS5</code>.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetInvalidationInput`](crate::input::GetInvalidationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetInvalidationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetInvalidationInput {
                distribution_id: self.distribution_id,
                id: self.id,
            })
        }
    }
}
#[doc(hidden)]
pub type GetInvalidationInputOperationOutputAlias = crate::operation::GetInvalidation;
#[doc(hidden)]
pub type GetInvalidationInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetInvalidationInput {
    /// Consumes the builder and constructs an Operation<[`GetInvalidation`](crate::operation::GetInvalidation)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetInvalidation,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetInvalidationInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_31 = &_input.distribution_id;
                let input_31 = input_31.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "distribution_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let distribution_id = aws_smithy_http::label::fmt_string(input_31, false);
                if distribution_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "distribution_id",
                        details: "cannot be empty or unset",
                    });
                }
                let input_32 = &_input.id;
                let input_32 = input_32.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let id = aws_smithy_http::label::fmt_string(input_32, false);
                if id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/2020-05-31/distribution/{DistributionId}/invalidation/{Id}",
                    DistributionId = distribution_id,
                    Id = id
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetInvalidationInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetInvalidation::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetInvalidation",
            "cloudfront",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetInvalidationInput`](crate::input::GetInvalidationInput)
    pub fn builder() -> crate::input::get_invalidation_input::Builder {
        crate::input::get_invalidation_input::Builder::default()
    }
}

/// See [`GetKeyGroupInput`](crate::input::GetKeyGroupInput)
pub mod get_key_group_input {
    /// A builder for [`GetKeyGroupInput`](crate::input::GetKeyGroupInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier of the key group that you are getting. To get the identifier, use <code>ListKeyGroups</code>.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The identifier of the key group that you are getting. To get the identifier, use <code>ListKeyGroups</code>.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetKeyGroupInput`](crate::input::GetKeyGroupInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetKeyGroupInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetKeyGroupInput { id: self.id })
        }
    }
}
#[doc(hidden)]
pub type GetKeyGroupInputOperationOutputAlias = crate::operation::GetKeyGroup;
#[doc(hidden)]
pub type GetKeyGroupInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetKeyGroupInput {
    /// Consumes the builder and constructs an Operation<[`GetKeyGroup`](crate::operation::GetKeyGroup)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetKeyGroup,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetKeyGroupInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_33 = &_input.id;
                let input_33 = input_33.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let id = aws_smithy_http::label::fmt_string(input_33, false);
                if id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/2020-05-31/key-group/{Id}", Id = id)
                    .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetKeyGroupInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetKeyGroup::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetKeyGroup",
            "cloudfront",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetKeyGroupInput`](crate::input::GetKeyGroupInput)
    pub fn builder() -> crate::input::get_key_group_input::Builder {
        crate::input::get_key_group_input::Builder::default()
    }
}

/// See [`GetKeyGroupConfigInput`](crate::input::GetKeyGroupConfigInput)
pub mod get_key_group_config_input {
    /// A builder for [`GetKeyGroupConfigInput`](crate::input::GetKeyGroupConfigInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier of the key group whose configuration you are getting. To get the identifier, use <code>ListKeyGroups</code>.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The identifier of the key group whose configuration you are getting. To get the identifier, use <code>ListKeyGroups</code>.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetKeyGroupConfigInput`](crate::input::GetKeyGroupConfigInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetKeyGroupConfigInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetKeyGroupConfigInput { id: self.id })
        }
    }
}
#[doc(hidden)]
pub type GetKeyGroupConfigInputOperationOutputAlias = crate::operation::GetKeyGroupConfig;
#[doc(hidden)]
pub type GetKeyGroupConfigInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetKeyGroupConfigInput {
    /// Consumes the builder and constructs an Operation<[`GetKeyGroupConfig`](crate::operation::GetKeyGroupConfig)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetKeyGroupConfig,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetKeyGroupConfigInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_34 = &_input.id;
                let input_34 = input_34.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let id = aws_smithy_http::label::fmt_string(input_34, false);
                if id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/2020-05-31/key-group/{Id}/config", Id = id)
                    .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetKeyGroupConfigInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetKeyGroupConfig::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetKeyGroupConfig",
            "cloudfront",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetKeyGroupConfigInput`](crate::input::GetKeyGroupConfigInput)
    pub fn builder() -> crate::input::get_key_group_config_input::Builder {
        crate::input::get_key_group_config_input::Builder::default()
    }
}

/// See [`GetMonitoringSubscriptionInput`](crate::input::GetMonitoringSubscriptionInput)
pub mod get_monitoring_subscription_input {
    /// A builder for [`GetMonitoringSubscriptionInput`](crate::input::GetMonitoringSubscriptionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) distribution_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the distribution that you are getting metrics information for.</p>
        pub fn distribution_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.distribution_id = Some(input.into());
            self
        }
        /// <p>The ID of the distribution that you are getting metrics information for.</p>
        pub fn set_distribution_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.distribution_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetMonitoringSubscriptionInput`](crate::input::GetMonitoringSubscriptionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetMonitoringSubscriptionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetMonitoringSubscriptionInput {
                distribution_id: self.distribution_id,
            })
        }
    }
}
#[doc(hidden)]
pub type GetMonitoringSubscriptionInputOperationOutputAlias =
    crate::operation::GetMonitoringSubscription;
#[doc(hidden)]
pub type GetMonitoringSubscriptionInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetMonitoringSubscriptionInput {
    /// Consumes the builder and constructs an Operation<[`GetMonitoringSubscription`](crate::operation::GetMonitoringSubscription)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetMonitoringSubscription,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetMonitoringSubscriptionInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_35 = &_input.distribution_id;
                let input_35 = input_35.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "distribution_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let distribution_id = aws_smithy_http::label::fmt_string(input_35, false);
                if distribution_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "distribution_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/2020-05-31/distributions/{DistributionId}/monitoring-subscription",
                    DistributionId = distribution_id
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetMonitoringSubscriptionInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetMonitoringSubscription::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetMonitoringSubscription",
            "cloudfront",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetMonitoringSubscriptionInput`](crate::input::GetMonitoringSubscriptionInput)
    pub fn builder() -> crate::input::get_monitoring_subscription_input::Builder {
        crate::input::get_monitoring_subscription_input::Builder::default()
    }
}

/// See [`GetOriginRequestPolicyInput`](crate::input::GetOriginRequestPolicyInput)
pub mod get_origin_request_policy_input {
    /// A builder for [`GetOriginRequestPolicyInput`](crate::input::GetOriginRequestPolicyInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique identifier for the origin request policy. If the origin request policy is attached to a distribution’s cache behavior, you can get the policy’s identifier using <code>ListDistributions</code> or <code>GetDistribution</code>. If the origin request policy is not attached to a cache behavior, you can get the identifier using <code>ListOriginRequestPolicies</code>.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the origin request policy. If the origin request policy is attached to a distribution’s cache behavior, you can get the policy’s identifier using <code>ListDistributions</code> or <code>GetDistribution</code>. If the origin request policy is not attached to a cache behavior, you can get the identifier using <code>ListOriginRequestPolicies</code>.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetOriginRequestPolicyInput`](crate::input::GetOriginRequestPolicyInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetOriginRequestPolicyInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetOriginRequestPolicyInput { id: self.id })
        }
    }
}
#[doc(hidden)]
pub type GetOriginRequestPolicyInputOperationOutputAlias = crate::operation::GetOriginRequestPolicy;
#[doc(hidden)]
pub type GetOriginRequestPolicyInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetOriginRequestPolicyInput {
    /// Consumes the builder and constructs an Operation<[`GetOriginRequestPolicy`](crate::operation::GetOriginRequestPolicy)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetOriginRequestPolicy,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetOriginRequestPolicyInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_36 = &_input.id;
                let input_36 = input_36.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let id = aws_smithy_http::label::fmt_string(input_36, false);
                if id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/2020-05-31/origin-request-policy/{Id}", Id = id)
                    .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetOriginRequestPolicyInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetOriginRequestPolicy::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetOriginRequestPolicy",
            "cloudfront",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetOriginRequestPolicyInput`](crate::input::GetOriginRequestPolicyInput)
    pub fn builder() -> crate::input::get_origin_request_policy_input::Builder {
        crate::input::get_origin_request_policy_input::Builder::default()
    }
}

/// See [`GetOriginRequestPolicyConfigInput`](crate::input::GetOriginRequestPolicyConfigInput)
pub mod get_origin_request_policy_config_input {
    /// A builder for [`GetOriginRequestPolicyConfigInput`](crate::input::GetOriginRequestPolicyConfigInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique identifier for the origin request policy. If the origin request policy is attached to a distribution’s cache behavior, you can get the policy’s identifier using <code>ListDistributions</code> or <code>GetDistribution</code>. If the origin request policy is not attached to a cache behavior, you can get the identifier using <code>ListOriginRequestPolicies</code>.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the origin request policy. If the origin request policy is attached to a distribution’s cache behavior, you can get the policy’s identifier using <code>ListDistributions</code> or <code>GetDistribution</code>. If the origin request policy is not attached to a cache behavior, you can get the identifier using <code>ListOriginRequestPolicies</code>.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetOriginRequestPolicyConfigInput`](crate::input::GetOriginRequestPolicyConfigInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetOriginRequestPolicyConfigInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetOriginRequestPolicyConfigInput { id: self.id })
        }
    }
}
#[doc(hidden)]
pub type GetOriginRequestPolicyConfigInputOperationOutputAlias =
    crate::operation::GetOriginRequestPolicyConfig;
#[doc(hidden)]
pub type GetOriginRequestPolicyConfigInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl GetOriginRequestPolicyConfigInput {
    /// Consumes the builder and constructs an Operation<[`GetOriginRequestPolicyConfig`](crate::operation::GetOriginRequestPolicyConfig)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetOriginRequestPolicyConfig,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetOriginRequestPolicyConfigInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_37 = &_input.id;
                let input_37 = input_37.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let id = aws_smithy_http::label::fmt_string(input_37, false);
                if id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/2020-05-31/origin-request-policy/{Id}/config",
                    Id = id
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetOriginRequestPolicyConfigInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetOriginRequestPolicyConfig::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetOriginRequestPolicyConfig",
            "cloudfront",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetOriginRequestPolicyConfigInput`](crate::input::GetOriginRequestPolicyConfigInput)
    pub fn builder() -> crate::input::get_origin_request_policy_config_input::Builder {
        crate::input::get_origin_request_policy_config_input::Builder::default()
    }
}

/// See [`GetPublicKeyInput`](crate::input::GetPublicKeyInput)
pub mod get_public_key_input {
    /// A builder for [`GetPublicKeyInput`](crate::input::GetPublicKeyInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier of the public key you are getting.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The identifier of the public key you are getting.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetPublicKeyInput`](crate::input::GetPublicKeyInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetPublicKeyInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetPublicKeyInput { id: self.id })
        }
    }
}
#[doc(hidden)]
pub type GetPublicKeyInputOperationOutputAlias = crate::operation::GetPublicKey;
#[doc(hidden)]
pub type GetPublicKeyInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetPublicKeyInput {
    /// Consumes the builder and constructs an Operation<[`GetPublicKey`](crate::operation::GetPublicKey)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetPublicKey,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetPublicKeyInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_38 = &_input.id;
                let input_38 = input_38.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let id = aws_smithy_http::label::fmt_string(input_38, false);
                if id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/2020-05-31/public-key/{Id}", Id = id)
                    .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetPublicKeyInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetPublicKey::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetPublicKey",
            "cloudfront",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetPublicKeyInput`](crate::input::GetPublicKeyInput)
    pub fn builder() -> crate::input::get_public_key_input::Builder {
        crate::input::get_public_key_input::Builder::default()
    }
}

/// See [`GetPublicKeyConfigInput`](crate::input::GetPublicKeyConfigInput)
pub mod get_public_key_config_input {
    /// A builder for [`GetPublicKeyConfigInput`](crate::input::GetPublicKeyConfigInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier of the public key whose configuration you are getting.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The identifier of the public key whose configuration you are getting.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetPublicKeyConfigInput`](crate::input::GetPublicKeyConfigInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetPublicKeyConfigInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetPublicKeyConfigInput { id: self.id })
        }
    }
}
#[doc(hidden)]
pub type GetPublicKeyConfigInputOperationOutputAlias = crate::operation::GetPublicKeyConfig;
#[doc(hidden)]
pub type GetPublicKeyConfigInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetPublicKeyConfigInput {
    /// Consumes the builder and constructs an Operation<[`GetPublicKeyConfig`](crate::operation::GetPublicKeyConfig)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetPublicKeyConfig,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetPublicKeyConfigInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_39 = &_input.id;
                let input_39 = input_39.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let id = aws_smithy_http::label::fmt_string(input_39, false);
                if id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/2020-05-31/public-key/{Id}/config", Id = id)
                    .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetPublicKeyConfigInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetPublicKeyConfig::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetPublicKeyConfig",
            "cloudfront",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetPublicKeyConfigInput`](crate::input::GetPublicKeyConfigInput)
    pub fn builder() -> crate::input::get_public_key_config_input::Builder {
        crate::input::get_public_key_config_input::Builder::default()
    }
}

/// See [`GetRealtimeLogConfigInput`](crate::input::GetRealtimeLogConfigInput)
pub mod get_realtime_log_config_input {
    /// A builder for [`GetRealtimeLogConfigInput`](crate::input::GetRealtimeLogConfigInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the real-time log configuration to get.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the real-time log configuration to get.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the real-time log configuration to get.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the real-time log configuration to get.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// Consumes the builder and constructs a [`GetRealtimeLogConfigInput`](crate::input::GetRealtimeLogConfigInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetRealtimeLogConfigInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetRealtimeLogConfigInput {
                name: self.name,
                arn: self.arn,
            })
        }
    }
}
#[doc(hidden)]
pub type GetRealtimeLogConfigInputOperationOutputAlias = crate::operation::GetRealtimeLogConfig;
#[doc(hidden)]
pub type GetRealtimeLogConfigInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetRealtimeLogConfigInput {
    /// Consumes the builder and constructs an Operation<[`GetRealtimeLogConfig`](crate::operation::GetRealtimeLogConfig)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetRealtimeLogConfig,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetRealtimeLogConfigInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/2020-05-31/get-realtime-log-config")
                    .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetRealtimeLogConfigInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/xml",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_get_realtime_log_config(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetRealtimeLogConfig::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetRealtimeLogConfig",
            "cloudfront",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetRealtimeLogConfigInput`](crate::input::GetRealtimeLogConfigInput)
    pub fn builder() -> crate::input::get_realtime_log_config_input::Builder {
        crate::input::get_realtime_log_config_input::Builder::default()
    }
}

/// See [`GetResponseHeadersPolicyInput`](crate::input::GetResponseHeadersPolicyInput)
pub mod get_response_headers_policy_input {
    /// A builder for [`GetResponseHeadersPolicyInput`](crate::input::GetResponseHeadersPolicyInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier for the response headers policy.</p>
        /// <p>If the response headers policy is attached to a distribution’s cache behavior, you can get the policy’s identifier using <code>ListDistributions</code> or <code>GetDistribution</code>. If the response headers policy is not attached to a cache behavior, you can get the identifier using <code>ListResponseHeadersPolicies</code>.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The identifier for the response headers policy.</p>
        /// <p>If the response headers policy is attached to a distribution’s cache behavior, you can get the policy’s identifier using <code>ListDistributions</code> or <code>GetDistribution</code>. If the response headers policy is not attached to a cache behavior, you can get the identifier using <code>ListResponseHeadersPolicies</code>.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetResponseHeadersPolicyInput`](crate::input::GetResponseHeadersPolicyInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetResponseHeadersPolicyInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetResponseHeadersPolicyInput { id: self.id })
        }
    }
}
#[doc(hidden)]
pub type GetResponseHeadersPolicyInputOperationOutputAlias =
    crate::operation::GetResponseHeadersPolicy;
#[doc(hidden)]
pub type GetResponseHeadersPolicyInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetResponseHeadersPolicyInput {
    /// Consumes the builder and constructs an Operation<[`GetResponseHeadersPolicy`](crate::operation::GetResponseHeadersPolicy)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetResponseHeadersPolicy,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetResponseHeadersPolicyInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_40 = &_input.id;
                let input_40 = input_40.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let id = aws_smithy_http::label::fmt_string(input_40, false);
                if id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/2020-05-31/response-headers-policy/{Id}", Id = id)
                    .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetResponseHeadersPolicyInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetResponseHeadersPolicy::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetResponseHeadersPolicy",
            "cloudfront",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetResponseHeadersPolicyInput`](crate::input::GetResponseHeadersPolicyInput)
    pub fn builder() -> crate::input::get_response_headers_policy_input::Builder {
        crate::input::get_response_headers_policy_input::Builder::default()
    }
}

/// See [`GetResponseHeadersPolicyConfigInput`](crate::input::GetResponseHeadersPolicyConfigInput)
pub mod get_response_headers_policy_config_input {
    /// A builder for [`GetResponseHeadersPolicyConfigInput`](crate::input::GetResponseHeadersPolicyConfigInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier for the response headers policy.</p>
        /// <p>If the response headers policy is attached to a distribution’s cache behavior, you can get the policy’s identifier using <code>ListDistributions</code> or <code>GetDistribution</code>. If the response headers policy is not attached to a cache behavior, you can get the identifier using <code>ListResponseHeadersPolicies</code>.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The identifier for the response headers policy.</p>
        /// <p>If the response headers policy is attached to a distribution’s cache behavior, you can get the policy’s identifier using <code>ListDistributions</code> or <code>GetDistribution</code>. If the response headers policy is not attached to a cache behavior, you can get the identifier using <code>ListResponseHeadersPolicies</code>.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetResponseHeadersPolicyConfigInput`](crate::input::GetResponseHeadersPolicyConfigInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetResponseHeadersPolicyConfigInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetResponseHeadersPolicyConfigInput { id: self.id })
        }
    }
}
#[doc(hidden)]
pub type GetResponseHeadersPolicyConfigInputOperationOutputAlias =
    crate::operation::GetResponseHeadersPolicyConfig;
#[doc(hidden)]
pub type GetResponseHeadersPolicyConfigInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl GetResponseHeadersPolicyConfigInput {
    /// Consumes the builder and constructs an Operation<[`GetResponseHeadersPolicyConfig`](crate::operation::GetResponseHeadersPolicyConfig)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetResponseHeadersPolicyConfig,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetResponseHeadersPolicyConfigInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_41 = &_input.id;
                let input_41 = input_41.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let id = aws_smithy_http::label::fmt_string(input_41, false);
                if id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/2020-05-31/response-headers-policy/{Id}/config",
                    Id = id
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetResponseHeadersPolicyConfigInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetResponseHeadersPolicyConfig::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetResponseHeadersPolicyConfig",
            "cloudfront",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetResponseHeadersPolicyConfigInput`](crate::input::GetResponseHeadersPolicyConfigInput)
    pub fn builder() -> crate::input::get_response_headers_policy_config_input::Builder {
        crate::input::get_response_headers_policy_config_input::Builder::default()
    }
}

/// See [`GetStreamingDistributionInput`](crate::input::GetStreamingDistributionInput)
pub mod get_streaming_distribution_input {
    /// A builder for [`GetStreamingDistributionInput`](crate::input::GetStreamingDistributionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The streaming distribution's ID.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The streaming distribution's ID.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetStreamingDistributionInput`](crate::input::GetStreamingDistributionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetStreamingDistributionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetStreamingDistributionInput { id: self.id })
        }
    }
}
#[doc(hidden)]
pub type GetStreamingDistributionInputOperationOutputAlias =
    crate::operation::GetStreamingDistribution;
#[doc(hidden)]
pub type GetStreamingDistributionInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetStreamingDistributionInput {
    /// Consumes the builder and constructs an Operation<[`GetStreamingDistribution`](crate::operation::GetStreamingDistribution)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetStreamingDistribution,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetStreamingDistributionInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_42 = &_input.id;
                let input_42 = input_42.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let id = aws_smithy_http::label::fmt_string(input_42, false);
                if id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/2020-05-31/streaming-distribution/{Id}", Id = id)
                    .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetStreamingDistributionInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetStreamingDistribution::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetStreamingDistribution",
            "cloudfront",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetStreamingDistributionInput`](crate::input::GetStreamingDistributionInput)
    pub fn builder() -> crate::input::get_streaming_distribution_input::Builder {
        crate::input::get_streaming_distribution_input::Builder::default()
    }
}

/// See [`GetStreamingDistributionConfigInput`](crate::input::GetStreamingDistributionConfigInput)
pub mod get_streaming_distribution_config_input {
    /// A builder for [`GetStreamingDistributionConfigInput`](crate::input::GetStreamingDistributionConfigInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The streaming distribution's ID.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The streaming distribution's ID.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetStreamingDistributionConfigInput`](crate::input::GetStreamingDistributionConfigInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetStreamingDistributionConfigInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetStreamingDistributionConfigInput { id: self.id })
        }
    }
}
#[doc(hidden)]
pub type GetStreamingDistributionConfigInputOperationOutputAlias =
    crate::operation::GetStreamingDistributionConfig;
#[doc(hidden)]
pub type GetStreamingDistributionConfigInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl GetStreamingDistributionConfigInput {
    /// Consumes the builder and constructs an Operation<[`GetStreamingDistributionConfig`](crate::operation::GetStreamingDistributionConfig)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetStreamingDistributionConfig,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetStreamingDistributionConfigInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_43 = &_input.id;
                let input_43 = input_43.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let id = aws_smithy_http::label::fmt_string(input_43, false);
                if id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/2020-05-31/streaming-distribution/{Id}/config",
                    Id = id
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetStreamingDistributionConfigInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetStreamingDistributionConfig::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetStreamingDistributionConfig",
            "cloudfront",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetStreamingDistributionConfigInput`](crate::input::GetStreamingDistributionConfigInput)
    pub fn builder() -> crate::input::get_streaming_distribution_config_input::Builder {
        crate::input::get_streaming_distribution_config_input::Builder::default()
    }
}

/// See [`ListCachePoliciesInput`](crate::input::ListCachePoliciesInput)
pub mod list_cache_policies_input {
    /// A builder for [`ListCachePoliciesInput`](crate::input::ListCachePoliciesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) r#type: std::option::Option<crate::model::CachePolicyType>,
        pub(crate) marker: std::option::Option<std::string::String>,
        pub(crate) max_items: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>A filter to return only the specified kinds of cache policies. Valid values are:</p>
        /// <ul>
        /// <li> <p> <code>managed</code> – Returns only the managed policies created by Amazon Web Services.</p> </li>
        /// <li> <p> <code>custom</code> – Returns only the custom policies created in your Amazon Web Services account.</p> </li>
        /// </ul>
        pub fn r#type(mut self, input: crate::model::CachePolicyType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>A filter to return only the specified kinds of cache policies. Valid values are:</p>
        /// <ul>
        /// <li> <p> <code>managed</code> – Returns only the managed policies created by Amazon Web Services.</p> </li>
        /// <li> <p> <code>custom</code> – Returns only the custom policies created in your Amazon Web Services account.</p> </li>
        /// </ul>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::CachePolicyType>,
        ) -> Self {
            self.r#type = input;
            self
        }
        /// <p>Use this field when paginating results to indicate where to begin in your list of cache policies. The response includes cache policies in the list that occur after the marker. To get the next page of the list, set this field’s value to the value of <code>NextMarker</code> from the current page’s response.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>Use this field when paginating results to indicate where to begin in your list of cache policies. The response includes cache policies in the list that occur after the marker. To get the next page of the list, set this field’s value to the value of <code>NextMarker</code> from the current page’s response.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// <p>The maximum number of cache policies that you want in the response.</p>
        pub fn max_items(mut self, input: i32) -> Self {
            self.max_items = Some(input);
            self
        }
        /// <p>The maximum number of cache policies that you want in the response.</p>
        pub fn set_max_items(mut self, input: std::option::Option<i32>) -> Self {
            self.max_items = input;
            self
        }
        /// Consumes the builder and constructs a [`ListCachePoliciesInput`](crate::input::ListCachePoliciesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListCachePoliciesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListCachePoliciesInput {
                r#type: self.r#type,
                marker: self.marker,
                max_items: self.max_items,
            })
        }
    }
}
#[doc(hidden)]
pub type ListCachePoliciesInputOperationOutputAlias = crate::operation::ListCachePolicies;
#[doc(hidden)]
pub type ListCachePoliciesInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListCachePoliciesInput {
    /// Consumes the builder and constructs an Operation<[`ListCachePolicies`](crate::operation::ListCachePolicies)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListCachePolicies,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ListCachePoliciesInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/2020-05-31/cache-policy").expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::ListCachePoliciesInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_44) = &_input.r#type {
                    query.push_kv("Type", &aws_smithy_http::query::fmt_string(&inner_44));
                }
                if let Some(inner_45) = &_input.marker {
                    query.push_kv("Marker", &aws_smithy_http::query::fmt_string(&inner_45));
                }
                if let Some(inner_46) = &_input.max_items {
                    query.push_kv(
                        "MaxItems",
                        aws_smithy_types::primitive::Encoder::from(*inner_46).encode(),
                    );
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ListCachePoliciesInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListCachePolicies::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListCachePolicies",
            "cloudfront",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ListCachePoliciesInput`](crate::input::ListCachePoliciesInput)
    pub fn builder() -> crate::input::list_cache_policies_input::Builder {
        crate::input::list_cache_policies_input::Builder::default()
    }
}

/// See [`ListCloudFrontOriginAccessIdentitiesInput`](crate::input::ListCloudFrontOriginAccessIdentitiesInput)
pub mod list_cloud_front_origin_access_identities_input {
    /// A builder for [`ListCloudFrontOriginAccessIdentitiesInput`](crate::input::ListCloudFrontOriginAccessIdentitiesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) marker: std::option::Option<std::string::String>,
        pub(crate) max_items: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>Use this when paginating results to indicate where to begin in your list of origin access identities. The results include identities in the list that occur after the marker. To get the next page of results, set the <code>Marker</code> to the value of the <code>NextMarker</code> from the current page's response (which is also the ID of the last identity on that page).</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>Use this when paginating results to indicate where to begin in your list of origin access identities. The results include identities in the list that occur after the marker. To get the next page of results, set the <code>Marker</code> to the value of the <code>NextMarker</code> from the current page's response (which is also the ID of the last identity on that page).</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// <p>The maximum number of origin access identities you want in the response body. </p>
        pub fn max_items(mut self, input: i32) -> Self {
            self.max_items = Some(input);
            self
        }
        /// <p>The maximum number of origin access identities you want in the response body. </p>
        pub fn set_max_items(mut self, input: std::option::Option<i32>) -> Self {
            self.max_items = input;
            self
        }
        /// Consumes the builder and constructs a [`ListCloudFrontOriginAccessIdentitiesInput`](crate::input::ListCloudFrontOriginAccessIdentitiesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListCloudFrontOriginAccessIdentitiesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListCloudFrontOriginAccessIdentitiesInput {
                marker: self.marker,
                max_items: self.max_items,
            })
        }
    }
}
#[doc(hidden)]
pub type ListCloudFrontOriginAccessIdentitiesInputOperationOutputAlias =
    crate::operation::ListCloudFrontOriginAccessIdentities;
#[doc(hidden)]
pub type ListCloudFrontOriginAccessIdentitiesInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl ListCloudFrontOriginAccessIdentitiesInput {
    /// Consumes the builder and constructs an Operation<[`ListCloudFrontOriginAccessIdentities`](crate::operation::ListCloudFrontOriginAccessIdentities)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListCloudFrontOriginAccessIdentities,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ListCloudFrontOriginAccessIdentitiesInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/2020-05-31/origin-access-identity/cloudfront")
                    .expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::ListCloudFrontOriginAccessIdentitiesInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_47) = &_input.marker {
                    query.push_kv("Marker", &aws_smithy_http::query::fmt_string(&inner_47));
                }
                if let Some(inner_48) = &_input.max_items {
                    query.push_kv(
                        "MaxItems",
                        aws_smithy_types::primitive::Encoder::from(*inner_48).encode(),
                    );
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ListCloudFrontOriginAccessIdentitiesInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListCloudFrontOriginAccessIdentities::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListCloudFrontOriginAccessIdentities",
            "cloudfront",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ListCloudFrontOriginAccessIdentitiesInput`](crate::input::ListCloudFrontOriginAccessIdentitiesInput)
    pub fn builder() -> crate::input::list_cloud_front_origin_access_identities_input::Builder {
        crate::input::list_cloud_front_origin_access_identities_input::Builder::default()
    }
}

/// See [`ListConflictingAliasesInput`](crate::input::ListConflictingAliasesInput)
pub mod list_conflicting_aliases_input {
    /// A builder for [`ListConflictingAliasesInput`](crate::input::ListConflictingAliasesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) distribution_id: std::option::Option<std::string::String>,
        pub(crate) alias: std::option::Option<std::string::String>,
        pub(crate) marker: std::option::Option<std::string::String>,
        pub(crate) max_items: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The ID of a distribution in your account that has an attached SSL/TLS certificate that includes the provided alias.</p>
        pub fn distribution_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.distribution_id = Some(input.into());
            self
        }
        /// <p>The ID of a distribution in your account that has an attached SSL/TLS certificate that includes the provided alias.</p>
        pub fn set_distribution_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.distribution_id = input;
            self
        }
        /// <p>The alias (also called a CNAME) to search for conflicting aliases.</p>
        pub fn alias(mut self, input: impl Into<std::string::String>) -> Self {
            self.alias = Some(input.into());
            self
        }
        /// <p>The alias (also called a CNAME) to search for conflicting aliases.</p>
        pub fn set_alias(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.alias = input;
            self
        }
        /// <p>Use this field when paginating results to indicate where to begin in the list of conflicting aliases. The response includes conflicting aliases in the list that occur after the marker. To get the next page of the list, set this field’s value to the value of <code>NextMarker</code> from the current page’s response.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>Use this field when paginating results to indicate where to begin in the list of conflicting aliases. The response includes conflicting aliases in the list that occur after the marker. To get the next page of the list, set this field’s value to the value of <code>NextMarker</code> from the current page’s response.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// <p>The maximum number of conflicting aliases that you want in the response.</p>
        pub fn max_items(mut self, input: i32) -> Self {
            self.max_items = Some(input);
            self
        }
        /// <p>The maximum number of conflicting aliases that you want in the response.</p>
        pub fn set_max_items(mut self, input: std::option::Option<i32>) -> Self {
            self.max_items = input;
            self
        }
        /// Consumes the builder and constructs a [`ListConflictingAliasesInput`](crate::input::ListConflictingAliasesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListConflictingAliasesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListConflictingAliasesInput {
                distribution_id: self.distribution_id,
                alias: self.alias,
                marker: self.marker,
                max_items: self.max_items,
            })
        }
    }
}
#[doc(hidden)]
pub type ListConflictingAliasesInputOperationOutputAlias = crate::operation::ListConflictingAliases;
#[doc(hidden)]
pub type ListConflictingAliasesInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListConflictingAliasesInput {
    /// Consumes the builder and constructs an Operation<[`ListConflictingAliases`](crate::operation::ListConflictingAliases)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListConflictingAliases,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ListConflictingAliasesInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/2020-05-31/conflicting-alias").expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::ListConflictingAliasesInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_49) = &_input.distribution_id {
                    query.push_kv(
                        "DistributionId",
                        &aws_smithy_http::query::fmt_string(&inner_49),
                    );
                }
                if let Some(inner_50) = &_input.alias {
                    query.push_kv("Alias", &aws_smithy_http::query::fmt_string(&inner_50));
                }
                if let Some(inner_51) = &_input.marker {
                    query.push_kv("Marker", &aws_smithy_http::query::fmt_string(&inner_51));
                }
                if let Some(inner_52) = &_input.max_items {
                    query.push_kv(
                        "MaxItems",
                        aws_smithy_types::primitive::Encoder::from(*inner_52).encode(),
                    );
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ListConflictingAliasesInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListConflictingAliases::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListConflictingAliases",
            "cloudfront",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ListConflictingAliasesInput`](crate::input::ListConflictingAliasesInput)
    pub fn builder() -> crate::input::list_conflicting_aliases_input::Builder {
        crate::input::list_conflicting_aliases_input::Builder::default()
    }
}

/// See [`ListDistributionsInput`](crate::input::ListDistributionsInput)
pub mod list_distributions_input {
    /// A builder for [`ListDistributionsInput`](crate::input::ListDistributionsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) marker: std::option::Option<std::string::String>,
        pub(crate) max_items: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>Use this when paginating results to indicate where to begin in your list of distributions. The results include distributions in the list that occur after the marker. To get the next page of results, set the <code>Marker</code> to the value of the <code>NextMarker</code> from the current page's response (which is also the ID of the last distribution on that page).</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>Use this when paginating results to indicate where to begin in your list of distributions. The results include distributions in the list that occur after the marker. To get the next page of results, set the <code>Marker</code> to the value of the <code>NextMarker</code> from the current page's response (which is also the ID of the last distribution on that page).</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// <p>The maximum number of distributions you want in the response body.</p>
        pub fn max_items(mut self, input: i32) -> Self {
            self.max_items = Some(input);
            self
        }
        /// <p>The maximum number of distributions you want in the response body.</p>
        pub fn set_max_items(mut self, input: std::option::Option<i32>) -> Self {
            self.max_items = input;
            self
        }
        /// Consumes the builder and constructs a [`ListDistributionsInput`](crate::input::ListDistributionsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListDistributionsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListDistributionsInput {
                marker: self.marker,
                max_items: self.max_items,
            })
        }
    }
}
#[doc(hidden)]
pub type ListDistributionsInputOperationOutputAlias = crate::operation::ListDistributions;
#[doc(hidden)]
pub type ListDistributionsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListDistributionsInput {
    /// Consumes the builder and constructs an Operation<[`ListDistributions`](crate::operation::ListDistributions)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListDistributions,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ListDistributionsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/2020-05-31/distribution").expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::ListDistributionsInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_53) = &_input.marker {
                    query.push_kv("Marker", &aws_smithy_http::query::fmt_string(&inner_53));
                }
                if let Some(inner_54) = &_input.max_items {
                    query.push_kv(
                        "MaxItems",
                        aws_smithy_types::primitive::Encoder::from(*inner_54).encode(),
                    );
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ListDistributionsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListDistributions::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListDistributions",
            "cloudfront",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ListDistributionsInput`](crate::input::ListDistributionsInput)
    pub fn builder() -> crate::input::list_distributions_input::Builder {
        crate::input::list_distributions_input::Builder::default()
    }
}

/// See [`ListDistributionsByCachePolicyIdInput`](crate::input::ListDistributionsByCachePolicyIdInput)
pub mod list_distributions_by_cache_policy_id_input {
    /// A builder for [`ListDistributionsByCachePolicyIdInput`](crate::input::ListDistributionsByCachePolicyIdInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) marker: std::option::Option<std::string::String>,
        pub(crate) max_items: std::option::Option<i32>,
        pub(crate) cache_policy_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Use this field when paginating results to indicate where to begin in your list of distribution IDs. The response includes distribution IDs in the list that occur after the marker. To get the next page of the list, set this field’s value to the value of <code>NextMarker</code> from the current page’s response.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>Use this field when paginating results to indicate where to begin in your list of distribution IDs. The response includes distribution IDs in the list that occur after the marker. To get the next page of the list, set this field’s value to the value of <code>NextMarker</code> from the current page’s response.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// <p>The maximum number of distribution IDs that you want in the response.</p>
        pub fn max_items(mut self, input: i32) -> Self {
            self.max_items = Some(input);
            self
        }
        /// <p>The maximum number of distribution IDs that you want in the response.</p>
        pub fn set_max_items(mut self, input: std::option::Option<i32>) -> Self {
            self.max_items = input;
            self
        }
        /// <p>The ID of the cache policy whose associated distribution IDs you want to list.</p>
        pub fn cache_policy_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.cache_policy_id = Some(input.into());
            self
        }
        /// <p>The ID of the cache policy whose associated distribution IDs you want to list.</p>
        pub fn set_cache_policy_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.cache_policy_id = input;
            self
        }
        /// Consumes the builder and constructs a [`ListDistributionsByCachePolicyIdInput`](crate::input::ListDistributionsByCachePolicyIdInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListDistributionsByCachePolicyIdInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListDistributionsByCachePolicyIdInput {
                marker: self.marker,
                max_items: self.max_items,
                cache_policy_id: self.cache_policy_id,
            })
        }
    }
}
#[doc(hidden)]
pub type ListDistributionsByCachePolicyIdInputOperationOutputAlias =
    crate::operation::ListDistributionsByCachePolicyId;
#[doc(hidden)]
pub type ListDistributionsByCachePolicyIdInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl ListDistributionsByCachePolicyIdInput {
    /// Consumes the builder and constructs an Operation<[`ListDistributionsByCachePolicyId`](crate::operation::ListDistributionsByCachePolicyId)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListDistributionsByCachePolicyId,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ListDistributionsByCachePolicyIdInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_55 = &_input.cache_policy_id;
                let input_55 = input_55.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "cache_policy_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let cache_policy_id = aws_smithy_http::label::fmt_string(input_55, false);
                if cache_policy_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "cache_policy_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/2020-05-31/distributionsByCachePolicyId/{CachePolicyId}",
                    CachePolicyId = cache_policy_id
                )
                .expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::ListDistributionsByCachePolicyIdInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_56) = &_input.marker {
                    query.push_kv("Marker", &aws_smithy_http::query::fmt_string(&inner_56));
                }
                if let Some(inner_57) = &_input.max_items {
                    query.push_kv(
                        "MaxItems",
                        aws_smithy_types::primitive::Encoder::from(*inner_57).encode(),
                    );
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ListDistributionsByCachePolicyIdInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListDistributionsByCachePolicyId::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListDistributionsByCachePolicyId",
            "cloudfront",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ListDistributionsByCachePolicyIdInput`](crate::input::ListDistributionsByCachePolicyIdInput)
    pub fn builder() -> crate::input::list_distributions_by_cache_policy_id_input::Builder {
        crate::input::list_distributions_by_cache_policy_id_input::Builder::default()
    }
}

/// See [`ListDistributionsByKeyGroupInput`](crate::input::ListDistributionsByKeyGroupInput)
pub mod list_distributions_by_key_group_input {
    /// A builder for [`ListDistributionsByKeyGroupInput`](crate::input::ListDistributionsByKeyGroupInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) marker: std::option::Option<std::string::String>,
        pub(crate) max_items: std::option::Option<i32>,
        pub(crate) key_group_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Use this field when paginating results to indicate where to begin in your list of distribution IDs. The response includes distribution IDs in the list that occur after the marker. To get the next page of the list, set this field’s value to the value of <code>NextMarker</code> from the current page’s response.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>Use this field when paginating results to indicate where to begin in your list of distribution IDs. The response includes distribution IDs in the list that occur after the marker. To get the next page of the list, set this field’s value to the value of <code>NextMarker</code> from the current page’s response.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// <p>The maximum number of distribution IDs that you want in the response.</p>
        pub fn max_items(mut self, input: i32) -> Self {
            self.max_items = Some(input);
            self
        }
        /// <p>The maximum number of distribution IDs that you want in the response.</p>
        pub fn set_max_items(mut self, input: std::option::Option<i32>) -> Self {
            self.max_items = input;
            self
        }
        /// <p>The ID of the key group whose associated distribution IDs you are listing.</p>
        pub fn key_group_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.key_group_id = Some(input.into());
            self
        }
        /// <p>The ID of the key group whose associated distribution IDs you are listing.</p>
        pub fn set_key_group_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key_group_id = input;
            self
        }
        /// Consumes the builder and constructs a [`ListDistributionsByKeyGroupInput`](crate::input::ListDistributionsByKeyGroupInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListDistributionsByKeyGroupInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListDistributionsByKeyGroupInput {
                marker: self.marker,
                max_items: self.max_items,
                key_group_id: self.key_group_id,
            })
        }
    }
}
#[doc(hidden)]
pub type ListDistributionsByKeyGroupInputOperationOutputAlias =
    crate::operation::ListDistributionsByKeyGroup;
#[doc(hidden)]
pub type ListDistributionsByKeyGroupInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListDistributionsByKeyGroupInput {
    /// Consumes the builder and constructs an Operation<[`ListDistributionsByKeyGroup`](crate::operation::ListDistributionsByKeyGroup)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListDistributionsByKeyGroup,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ListDistributionsByKeyGroupInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_58 = &_input.key_group_id;
                let input_58 = input_58.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "key_group_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let key_group_id = aws_smithy_http::label::fmt_string(input_58, false);
                if key_group_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "key_group_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/2020-05-31/distributionsByKeyGroupId/{KeyGroupId}",
                    KeyGroupId = key_group_id
                )
                .expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::ListDistributionsByKeyGroupInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_59) = &_input.marker {
                    query.push_kv("Marker", &aws_smithy_http::query::fmt_string(&inner_59));
                }
                if let Some(inner_60) = &_input.max_items {
                    query.push_kv(
                        "MaxItems",
                        aws_smithy_types::primitive::Encoder::from(*inner_60).encode(),
                    );
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ListDistributionsByKeyGroupInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListDistributionsByKeyGroup::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListDistributionsByKeyGroup",
            "cloudfront",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ListDistributionsByKeyGroupInput`](crate::input::ListDistributionsByKeyGroupInput)
    pub fn builder() -> crate::input::list_distributions_by_key_group_input::Builder {
        crate::input::list_distributions_by_key_group_input::Builder::default()
    }
}

/// See [`ListDistributionsByOriginRequestPolicyIdInput`](crate::input::ListDistributionsByOriginRequestPolicyIdInput)
pub mod list_distributions_by_origin_request_policy_id_input {
    /// A builder for [`ListDistributionsByOriginRequestPolicyIdInput`](crate::input::ListDistributionsByOriginRequestPolicyIdInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) marker: std::option::Option<std::string::String>,
        pub(crate) max_items: std::option::Option<i32>,
        pub(crate) origin_request_policy_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Use this field when paginating results to indicate where to begin in your list of distribution IDs. The response includes distribution IDs in the list that occur after the marker. To get the next page of the list, set this field’s value to the value of <code>NextMarker</code> from the current page’s response.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>Use this field when paginating results to indicate where to begin in your list of distribution IDs. The response includes distribution IDs in the list that occur after the marker. To get the next page of the list, set this field’s value to the value of <code>NextMarker</code> from the current page’s response.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// <p>The maximum number of distribution IDs that you want in the response.</p>
        pub fn max_items(mut self, input: i32) -> Self {
            self.max_items = Some(input);
            self
        }
        /// <p>The maximum number of distribution IDs that you want in the response.</p>
        pub fn set_max_items(mut self, input: std::option::Option<i32>) -> Self {
            self.max_items = input;
            self
        }
        /// <p>The ID of the origin request policy whose associated distribution IDs you want to list.</p>
        pub fn origin_request_policy_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.origin_request_policy_id = Some(input.into());
            self
        }
        /// <p>The ID of the origin request policy whose associated distribution IDs you want to list.</p>
        pub fn set_origin_request_policy_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.origin_request_policy_id = input;
            self
        }
        /// Consumes the builder and constructs a [`ListDistributionsByOriginRequestPolicyIdInput`](crate::input::ListDistributionsByOriginRequestPolicyIdInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListDistributionsByOriginRequestPolicyIdInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(
                crate::input::ListDistributionsByOriginRequestPolicyIdInput {
                    marker: self.marker,
                    max_items: self.max_items,
                    origin_request_policy_id: self.origin_request_policy_id,
                },
            )
        }
    }
}
#[doc(hidden)]
pub type ListDistributionsByOriginRequestPolicyIdInputOperationOutputAlias =
    crate::operation::ListDistributionsByOriginRequestPolicyId;
#[doc(hidden)]
pub type ListDistributionsByOriginRequestPolicyIdInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl ListDistributionsByOriginRequestPolicyIdInput {
    /// Consumes the builder and constructs an Operation<[`ListDistributionsByOriginRequestPolicyId`](crate::operation::ListDistributionsByOriginRequestPolicyId)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListDistributionsByOriginRequestPolicyId,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ListDistributionsByOriginRequestPolicyIdInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_61 = &_input.origin_request_policy_id;
                let input_61 = input_61.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "origin_request_policy_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let origin_request_policy_id = aws_smithy_http::label::fmt_string(input_61, false);
                if origin_request_policy_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "origin_request_policy_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/2020-05-31/distributionsByOriginRequestPolicyId/{OriginRequestPolicyId}",
                    OriginRequestPolicyId = origin_request_policy_id
                )
                .expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::ListDistributionsByOriginRequestPolicyIdInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_62) = &_input.marker {
                    query.push_kv("Marker", &aws_smithy_http::query::fmt_string(&inner_62));
                }
                if let Some(inner_63) = &_input.max_items {
                    query.push_kv(
                        "MaxItems",
                        aws_smithy_types::primitive::Encoder::from(*inner_63).encode(),
                    );
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ListDistributionsByOriginRequestPolicyIdInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListDistributionsByOriginRequestPolicyId::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListDistributionsByOriginRequestPolicyId",
            "cloudfront",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ListDistributionsByOriginRequestPolicyIdInput`](crate::input::ListDistributionsByOriginRequestPolicyIdInput)
    pub fn builder() -> crate::input::list_distributions_by_origin_request_policy_id_input::Builder
    {
        crate::input::list_distributions_by_origin_request_policy_id_input::Builder::default()
    }
}

/// See [`ListDistributionsByRealtimeLogConfigInput`](crate::input::ListDistributionsByRealtimeLogConfigInput)
pub mod list_distributions_by_realtime_log_config_input {
    /// A builder for [`ListDistributionsByRealtimeLogConfigInput`](crate::input::ListDistributionsByRealtimeLogConfigInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) marker: std::option::Option<std::string::String>,
        pub(crate) max_items: std::option::Option<i32>,
        pub(crate) realtime_log_config_name: std::option::Option<std::string::String>,
        pub(crate) realtime_log_config_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Use this field when paginating results to indicate where to begin in your list of distributions. The response includes distributions in the list that occur after the marker. To get the next page of the list, set this field’s value to the value of <code>NextMarker</code> from the current page’s response.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>Use this field when paginating results to indicate where to begin in your list of distributions. The response includes distributions in the list that occur after the marker. To get the next page of the list, set this field’s value to the value of <code>NextMarker</code> from the current page’s response.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// <p>The maximum number of distributions that you want in the response.</p>
        pub fn max_items(mut self, input: i32) -> Self {
            self.max_items = Some(input);
            self
        }
        /// <p>The maximum number of distributions that you want in the response.</p>
        pub fn set_max_items(mut self, input: std::option::Option<i32>) -> Self {
            self.max_items = input;
            self
        }
        /// <p>The name of the real-time log configuration whose associated distributions you want to list.</p>
        pub fn realtime_log_config_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.realtime_log_config_name = Some(input.into());
            self
        }
        /// <p>The name of the real-time log configuration whose associated distributions you want to list.</p>
        pub fn set_realtime_log_config_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.realtime_log_config_name = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the real-time log configuration whose associated distributions you want to list.</p>
        pub fn realtime_log_config_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.realtime_log_config_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the real-time log configuration whose associated distributions you want to list.</p>
        pub fn set_realtime_log_config_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.realtime_log_config_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`ListDistributionsByRealtimeLogConfigInput`](crate::input::ListDistributionsByRealtimeLogConfigInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListDistributionsByRealtimeLogConfigInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListDistributionsByRealtimeLogConfigInput {
                marker: self.marker,
                max_items: self.max_items,
                realtime_log_config_name: self.realtime_log_config_name,
                realtime_log_config_arn: self.realtime_log_config_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type ListDistributionsByRealtimeLogConfigInputOperationOutputAlias =
    crate::operation::ListDistributionsByRealtimeLogConfig;
#[doc(hidden)]
pub type ListDistributionsByRealtimeLogConfigInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl ListDistributionsByRealtimeLogConfigInput {
    /// Consumes the builder and constructs an Operation<[`ListDistributionsByRealtimeLogConfig`](crate::operation::ListDistributionsByRealtimeLogConfig)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListDistributionsByRealtimeLogConfig,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ListDistributionsByRealtimeLogConfigInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/2020-05-31/distributionsByRealtimeLogConfig")
                    .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ListDistributionsByRealtimeLogConfigInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/xml",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_list_distributions_by_realtime_log_config(&self)?
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListDistributionsByRealtimeLogConfig::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListDistributionsByRealtimeLogConfig",
            "cloudfront",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ListDistributionsByRealtimeLogConfigInput`](crate::input::ListDistributionsByRealtimeLogConfigInput)
    pub fn builder() -> crate::input::list_distributions_by_realtime_log_config_input::Builder {
        crate::input::list_distributions_by_realtime_log_config_input::Builder::default()
    }
}

/// See [`ListDistributionsByResponseHeadersPolicyIdInput`](crate::input::ListDistributionsByResponseHeadersPolicyIdInput)
pub mod list_distributions_by_response_headers_policy_id_input {
    /// A builder for [`ListDistributionsByResponseHeadersPolicyIdInput`](crate::input::ListDistributionsByResponseHeadersPolicyIdInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) marker: std::option::Option<std::string::String>,
        pub(crate) max_items: std::option::Option<i32>,
        pub(crate) response_headers_policy_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Use this field when paginating results to indicate where to begin in your list of distribution IDs. The response includes distribution IDs in the list that occur after the marker. To get the next page of the list, set this field’s value to the value of <code>NextMarker</code> from the current page’s response.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>Use this field when paginating results to indicate where to begin in your list of distribution IDs. The response includes distribution IDs in the list that occur after the marker. To get the next page of the list, set this field’s value to the value of <code>NextMarker</code> from the current page’s response.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// <p>The maximum number of distribution IDs that you want to get in the response.</p>
        pub fn max_items(mut self, input: i32) -> Self {
            self.max_items = Some(input);
            self
        }
        /// <p>The maximum number of distribution IDs that you want to get in the response.</p>
        pub fn set_max_items(mut self, input: std::option::Option<i32>) -> Self {
            self.max_items = input;
            self
        }
        /// <p>The ID of the response headers policy whose associated distribution IDs you want to list.</p>
        pub fn response_headers_policy_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.response_headers_policy_id = Some(input.into());
            self
        }
        /// <p>The ID of the response headers policy whose associated distribution IDs you want to list.</p>
        pub fn set_response_headers_policy_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.response_headers_policy_id = input;
            self
        }
        /// Consumes the builder and constructs a [`ListDistributionsByResponseHeadersPolicyIdInput`](crate::input::ListDistributionsByResponseHeadersPolicyIdInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListDistributionsByResponseHeadersPolicyIdInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(
                crate::input::ListDistributionsByResponseHeadersPolicyIdInput {
                    marker: self.marker,
                    max_items: self.max_items,
                    response_headers_policy_id: self.response_headers_policy_id,
                },
            )
        }
    }
}
#[doc(hidden)]
pub type ListDistributionsByResponseHeadersPolicyIdInputOperationOutputAlias =
    crate::operation::ListDistributionsByResponseHeadersPolicyId;
#[doc(hidden)]
pub type ListDistributionsByResponseHeadersPolicyIdInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl ListDistributionsByResponseHeadersPolicyIdInput {
    /// Consumes the builder and constructs an Operation<[`ListDistributionsByResponseHeadersPolicyId`](crate::operation::ListDistributionsByResponseHeadersPolicyId)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListDistributionsByResponseHeadersPolicyId,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ListDistributionsByResponseHeadersPolicyIdInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_64 = &_input.response_headers_policy_id;
                let input_64 = input_64.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "response_headers_policy_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let response_headers_policy_id =
                    aws_smithy_http::label::fmt_string(input_64, false);
                if response_headers_policy_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "response_headers_policy_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/2020-05-31/distributionsByResponseHeadersPolicyId/{ResponseHeadersPolicyId}",
                    ResponseHeadersPolicyId = response_headers_policy_id
                )
                .expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::ListDistributionsByResponseHeadersPolicyIdInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_65) = &_input.marker {
                    query.push_kv("Marker", &aws_smithy_http::query::fmt_string(&inner_65));
                }
                if let Some(inner_66) = &_input.max_items {
                    query.push_kv(
                        "MaxItems",
                        aws_smithy_types::primitive::Encoder::from(*inner_66).encode(),
                    );
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ListDistributionsByResponseHeadersPolicyIdInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListDistributionsByResponseHeadersPolicyId::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListDistributionsByResponseHeadersPolicyId",
            "cloudfront",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ListDistributionsByResponseHeadersPolicyIdInput`](crate::input::ListDistributionsByResponseHeadersPolicyIdInput)
    pub fn builder() -> crate::input::list_distributions_by_response_headers_policy_id_input::Builder
    {
        crate::input::list_distributions_by_response_headers_policy_id_input::Builder::default()
    }
}

/// See [`ListDistributionsByWebAclIdInput`](crate::input::ListDistributionsByWebAclIdInput)
pub mod list_distributions_by_web_acl_id_input {
    /// A builder for [`ListDistributionsByWebAclIdInput`](crate::input::ListDistributionsByWebAclIdInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) marker: std::option::Option<std::string::String>,
        pub(crate) max_items: std::option::Option<i32>,
        pub(crate) web_acl_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Use <code>Marker</code> and <code>MaxItems</code> to control pagination of results. If you have more than <code>MaxItems</code> distributions that satisfy the request, the response includes a <code>NextMarker</code> element. To get the next page of results, submit another request. For the value of <code>Marker</code>, specify the value of <code>NextMarker</code> from the last response. (For the first request, omit <code>Marker</code>.) </p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>Use <code>Marker</code> and <code>MaxItems</code> to control pagination of results. If you have more than <code>MaxItems</code> distributions that satisfy the request, the response includes a <code>NextMarker</code> element. To get the next page of results, submit another request. For the value of <code>Marker</code>, specify the value of <code>NextMarker</code> from the last response. (For the first request, omit <code>Marker</code>.) </p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// <p>The maximum number of distributions that you want CloudFront to return in the response body. The maximum and default values are both 100.</p>
        pub fn max_items(mut self, input: i32) -> Self {
            self.max_items = Some(input);
            self
        }
        /// <p>The maximum number of distributions that you want CloudFront to return in the response body. The maximum and default values are both 100.</p>
        pub fn set_max_items(mut self, input: std::option::Option<i32>) -> Self {
            self.max_items = input;
            self
        }
        /// <p>The ID of the WAF web ACL that you want to list the associated distributions. If you specify "null" for the ID, the request returns a list of the distributions that aren't associated with a web ACL.</p>
        pub fn web_acl_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.web_acl_id = Some(input.into());
            self
        }
        /// <p>The ID of the WAF web ACL that you want to list the associated distributions. If you specify "null" for the ID, the request returns a list of the distributions that aren't associated with a web ACL.</p>
        pub fn set_web_acl_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.web_acl_id = input;
            self
        }
        /// Consumes the builder and constructs a [`ListDistributionsByWebAclIdInput`](crate::input::ListDistributionsByWebAclIdInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListDistributionsByWebAclIdInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListDistributionsByWebAclIdInput {
                marker: self.marker,
                max_items: self.max_items,
                web_acl_id: self.web_acl_id,
            })
        }
    }
}
#[doc(hidden)]
pub type ListDistributionsByWebAclIdInputOperationOutputAlias =
    crate::operation::ListDistributionsByWebACLId;
#[doc(hidden)]
pub type ListDistributionsByWebAclIdInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListDistributionsByWebAclIdInput {
    /// Consumes the builder and constructs an Operation<[`ListDistributionsByWebACLId`](crate::operation::ListDistributionsByWebACLId)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListDistributionsByWebACLId,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ListDistributionsByWebAclIdInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_67 = &_input.web_acl_id;
                let input_67 = input_67.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "web_acl_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let web_acl_id = aws_smithy_http::label::fmt_string(input_67, false);
                if web_acl_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "web_acl_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/2020-05-31/distributionsByWebACLId/{WebACLId}",
                    WebACLId = web_acl_id
                )
                .expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::ListDistributionsByWebAclIdInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_68) = &_input.marker {
                    query.push_kv("Marker", &aws_smithy_http::query::fmt_string(&inner_68));
                }
                if let Some(inner_69) = &_input.max_items {
                    query.push_kv(
                        "MaxItems",
                        aws_smithy_types::primitive::Encoder::from(*inner_69).encode(),
                    );
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ListDistributionsByWebAclIdInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListDistributionsByWebACLId::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListDistributionsByWebACLId",
            "cloudfront",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ListDistributionsByWebAclIdInput`](crate::input::ListDistributionsByWebAclIdInput)
    pub fn builder() -> crate::input::list_distributions_by_web_acl_id_input::Builder {
        crate::input::list_distributions_by_web_acl_id_input::Builder::default()
    }
}

/// See [`ListFieldLevelEncryptionConfigsInput`](crate::input::ListFieldLevelEncryptionConfigsInput)
pub mod list_field_level_encryption_configs_input {
    /// A builder for [`ListFieldLevelEncryptionConfigsInput`](crate::input::ListFieldLevelEncryptionConfigsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) marker: std::option::Option<std::string::String>,
        pub(crate) max_items: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>Use this when paginating results to indicate where to begin in your list of configurations. The results include configurations in the list that occur after the marker. To get the next page of results, set the <code>Marker</code> to the value of the <code>NextMarker</code> from the current page's response (which is also the ID of the last configuration on that page). </p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>Use this when paginating results to indicate where to begin in your list of configurations. The results include configurations in the list that occur after the marker. To get the next page of results, set the <code>Marker</code> to the value of the <code>NextMarker</code> from the current page's response (which is also the ID of the last configuration on that page). </p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// <p>The maximum number of field-level encryption configurations you want in the response body. </p>
        pub fn max_items(mut self, input: i32) -> Self {
            self.max_items = Some(input);
            self
        }
        /// <p>The maximum number of field-level encryption configurations you want in the response body. </p>
        pub fn set_max_items(mut self, input: std::option::Option<i32>) -> Self {
            self.max_items = input;
            self
        }
        /// Consumes the builder and constructs a [`ListFieldLevelEncryptionConfigsInput`](crate::input::ListFieldLevelEncryptionConfigsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListFieldLevelEncryptionConfigsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListFieldLevelEncryptionConfigsInput {
                marker: self.marker,
                max_items: self.max_items,
            })
        }
    }
}
#[doc(hidden)]
pub type ListFieldLevelEncryptionConfigsInputOperationOutputAlias =
    crate::operation::ListFieldLevelEncryptionConfigs;
#[doc(hidden)]
pub type ListFieldLevelEncryptionConfigsInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl ListFieldLevelEncryptionConfigsInput {
    /// Consumes the builder and constructs an Operation<[`ListFieldLevelEncryptionConfigs`](crate::operation::ListFieldLevelEncryptionConfigs)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListFieldLevelEncryptionConfigs,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ListFieldLevelEncryptionConfigsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/2020-05-31/field-level-encryption")
                    .expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::ListFieldLevelEncryptionConfigsInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_70) = &_input.marker {
                    query.push_kv("Marker", &aws_smithy_http::query::fmt_string(&inner_70));
                }
                if let Some(inner_71) = &_input.max_items {
                    query.push_kv(
                        "MaxItems",
                        aws_smithy_types::primitive::Encoder::from(*inner_71).encode(),
                    );
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ListFieldLevelEncryptionConfigsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListFieldLevelEncryptionConfigs::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListFieldLevelEncryptionConfigs",
            "cloudfront",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ListFieldLevelEncryptionConfigsInput`](crate::input::ListFieldLevelEncryptionConfigsInput)
    pub fn builder() -> crate::input::list_field_level_encryption_configs_input::Builder {
        crate::input::list_field_level_encryption_configs_input::Builder::default()
    }
}

/// See [`ListFieldLevelEncryptionProfilesInput`](crate::input::ListFieldLevelEncryptionProfilesInput)
pub mod list_field_level_encryption_profiles_input {
    /// A builder for [`ListFieldLevelEncryptionProfilesInput`](crate::input::ListFieldLevelEncryptionProfilesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) marker: std::option::Option<std::string::String>,
        pub(crate) max_items: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>Use this when paginating results to indicate where to begin in your list of profiles. The results include profiles in the list that occur after the marker. To get the next page of results, set the <code>Marker</code> to the value of the <code>NextMarker</code> from the current page's response (which is also the ID of the last profile on that page). </p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>Use this when paginating results to indicate where to begin in your list of profiles. The results include profiles in the list that occur after the marker. To get the next page of results, set the <code>Marker</code> to the value of the <code>NextMarker</code> from the current page's response (which is also the ID of the last profile on that page). </p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// <p>The maximum number of field-level encryption profiles you want in the response body. </p>
        pub fn max_items(mut self, input: i32) -> Self {
            self.max_items = Some(input);
            self
        }
        /// <p>The maximum number of field-level encryption profiles you want in the response body. </p>
        pub fn set_max_items(mut self, input: std::option::Option<i32>) -> Self {
            self.max_items = input;
            self
        }
        /// Consumes the builder and constructs a [`ListFieldLevelEncryptionProfilesInput`](crate::input::ListFieldLevelEncryptionProfilesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListFieldLevelEncryptionProfilesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListFieldLevelEncryptionProfilesInput {
                marker: self.marker,
                max_items: self.max_items,
            })
        }
    }
}
#[doc(hidden)]
pub type ListFieldLevelEncryptionProfilesInputOperationOutputAlias =
    crate::operation::ListFieldLevelEncryptionProfiles;
#[doc(hidden)]
pub type ListFieldLevelEncryptionProfilesInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl ListFieldLevelEncryptionProfilesInput {
    /// Consumes the builder and constructs an Operation<[`ListFieldLevelEncryptionProfiles`](crate::operation::ListFieldLevelEncryptionProfiles)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListFieldLevelEncryptionProfiles,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ListFieldLevelEncryptionProfilesInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/2020-05-31/field-level-encryption-profile")
                    .expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::ListFieldLevelEncryptionProfilesInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_72) = &_input.marker {
                    query.push_kv("Marker", &aws_smithy_http::query::fmt_string(&inner_72));
                }
                if let Some(inner_73) = &_input.max_items {
                    query.push_kv(
                        "MaxItems",
                        aws_smithy_types::primitive::Encoder::from(*inner_73).encode(),
                    );
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ListFieldLevelEncryptionProfilesInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListFieldLevelEncryptionProfiles::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListFieldLevelEncryptionProfiles",
            "cloudfront",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ListFieldLevelEncryptionProfilesInput`](crate::input::ListFieldLevelEncryptionProfilesInput)
    pub fn builder() -> crate::input::list_field_level_encryption_profiles_input::Builder {
        crate::input::list_field_level_encryption_profiles_input::Builder::default()
    }
}

/// See [`ListFunctionsInput`](crate::input::ListFunctionsInput)
pub mod list_functions_input {
    /// A builder for [`ListFunctionsInput`](crate::input::ListFunctionsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) marker: std::option::Option<std::string::String>,
        pub(crate) max_items: std::option::Option<i32>,
        pub(crate) stage: std::option::Option<crate::model::FunctionStage>,
    }
    impl Builder {
        /// <p>Use this field when paginating results to indicate where to begin in your list of functions. The response includes functions in the list that occur after the marker. To get the next page of the list, set this field’s value to the value of <code>NextMarker</code> from the current page’s response.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>Use this field when paginating results to indicate where to begin in your list of functions. The response includes functions in the list that occur after the marker. To get the next page of the list, set this field’s value to the value of <code>NextMarker</code> from the current page’s response.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// <p>The maximum number of functions that you want in the response.</p>
        pub fn max_items(mut self, input: i32) -> Self {
            self.max_items = Some(input);
            self
        }
        /// <p>The maximum number of functions that you want in the response.</p>
        pub fn set_max_items(mut self, input: std::option::Option<i32>) -> Self {
            self.max_items = input;
            self
        }
        /// <p>An optional filter to return only the functions that are in the specified stage, either <code>DEVELOPMENT</code> or <code>LIVE</code>.</p>
        pub fn stage(mut self, input: crate::model::FunctionStage) -> Self {
            self.stage = Some(input);
            self
        }
        /// <p>An optional filter to return only the functions that are in the specified stage, either <code>DEVELOPMENT</code> or <code>LIVE</code>.</p>
        pub fn set_stage(
            mut self,
            input: std::option::Option<crate::model::FunctionStage>,
        ) -> Self {
            self.stage = input;
            self
        }
        /// Consumes the builder and constructs a [`ListFunctionsInput`](crate::input::ListFunctionsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListFunctionsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListFunctionsInput {
                marker: self.marker,
                max_items: self.max_items,
                stage: self.stage,
            })
        }
    }
}
#[doc(hidden)]
pub type ListFunctionsInputOperationOutputAlias = crate::operation::ListFunctions;
#[doc(hidden)]
pub type ListFunctionsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListFunctionsInput {
    /// Consumes the builder and constructs an Operation<[`ListFunctions`](crate::operation::ListFunctions)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListFunctions,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ListFunctionsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/2020-05-31/function").expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::ListFunctionsInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_74) = &_input.marker {
                    query.push_kv("Marker", &aws_smithy_http::query::fmt_string(&inner_74));
                }
                if let Some(inner_75) = &_input.max_items {
                    query.push_kv(
                        "MaxItems",
                        aws_smithy_types::primitive::Encoder::from(*inner_75).encode(),
                    );
                }
                if let Some(inner_76) = &_input.stage {
                    query.push_kv("Stage", &aws_smithy_http::query::fmt_string(&inner_76));
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ListFunctionsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListFunctions::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListFunctions",
            "cloudfront",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ListFunctionsInput`](crate::input::ListFunctionsInput)
    pub fn builder() -> crate::input::list_functions_input::Builder {
        crate::input::list_functions_input::Builder::default()
    }
}

/// See [`ListInvalidationsInput`](crate::input::ListInvalidationsInput)
pub mod list_invalidations_input {
    /// A builder for [`ListInvalidationsInput`](crate::input::ListInvalidationsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) distribution_id: std::option::Option<std::string::String>,
        pub(crate) marker: std::option::Option<std::string::String>,
        pub(crate) max_items: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The distribution's ID.</p>
        pub fn distribution_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.distribution_id = Some(input.into());
            self
        }
        /// <p>The distribution's ID.</p>
        pub fn set_distribution_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.distribution_id = input;
            self
        }
        /// <p>Use this parameter when paginating results to indicate where to begin in your list of invalidation batches. Because the results are returned in decreasing order from most recent to oldest, the most recent results are on the first page, the second page will contain earlier results, and so on. To get the next page of results, set <code>Marker</code> to the value of the <code>NextMarker</code> from the current page's response. This value is the same as the ID of the last invalidation batch on that page. </p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>Use this parameter when paginating results to indicate where to begin in your list of invalidation batches. Because the results are returned in decreasing order from most recent to oldest, the most recent results are on the first page, the second page will contain earlier results, and so on. To get the next page of results, set <code>Marker</code> to the value of the <code>NextMarker</code> from the current page's response. This value is the same as the ID of the last invalidation batch on that page. </p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// <p>The maximum number of invalidation batches that you want in the response body.</p>
        pub fn max_items(mut self, input: i32) -> Self {
            self.max_items = Some(input);
            self
        }
        /// <p>The maximum number of invalidation batches that you want in the response body.</p>
        pub fn set_max_items(mut self, input: std::option::Option<i32>) -> Self {
            self.max_items = input;
            self
        }
        /// Consumes the builder and constructs a [`ListInvalidationsInput`](crate::input::ListInvalidationsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListInvalidationsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListInvalidationsInput {
                distribution_id: self.distribution_id,
                marker: self.marker,
                max_items: self.max_items,
            })
        }
    }
}
#[doc(hidden)]
pub type ListInvalidationsInputOperationOutputAlias = crate::operation::ListInvalidations;
#[doc(hidden)]
pub type ListInvalidationsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListInvalidationsInput {
    /// Consumes the builder and constructs an Operation<[`ListInvalidations`](crate::operation::ListInvalidations)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListInvalidations,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ListInvalidationsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_77 = &_input.distribution_id;
                let input_77 = input_77.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "distribution_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let distribution_id = aws_smithy_http::label::fmt_string(input_77, false);
                if distribution_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "distribution_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/2020-05-31/distribution/{DistributionId}/invalidation",
                    DistributionId = distribution_id
                )
                .expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::ListInvalidationsInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_78) = &_input.marker {
                    query.push_kv("Marker", &aws_smithy_http::query::fmt_string(&inner_78));
                }
                if let Some(inner_79) = &_input.max_items {
                    query.push_kv(
                        "MaxItems",
                        aws_smithy_types::primitive::Encoder::from(*inner_79).encode(),
                    );
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ListInvalidationsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListInvalidations::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListInvalidations",
            "cloudfront",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ListInvalidationsInput`](crate::input::ListInvalidationsInput)
    pub fn builder() -> crate::input::list_invalidations_input::Builder {
        crate::input::list_invalidations_input::Builder::default()
    }
}

/// See [`ListKeyGroupsInput`](crate::input::ListKeyGroupsInput)
pub mod list_key_groups_input {
    /// A builder for [`ListKeyGroupsInput`](crate::input::ListKeyGroupsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) marker: std::option::Option<std::string::String>,
        pub(crate) max_items: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>Use this field when paginating results to indicate where to begin in your list of key groups. The response includes key groups in the list that occur after the marker. To get the next page of the list, set this field’s value to the value of <code>NextMarker</code> from the current page’s response.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>Use this field when paginating results to indicate where to begin in your list of key groups. The response includes key groups in the list that occur after the marker. To get the next page of the list, set this field’s value to the value of <code>NextMarker</code> from the current page’s response.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// <p>The maximum number of key groups that you want in the response.</p>
        pub fn max_items(mut self, input: i32) -> Self {
            self.max_items = Some(input);
            self
        }
        /// <p>The maximum number of key groups that you want in the response.</p>
        pub fn set_max_items(mut self, input: std::option::Option<i32>) -> Self {
            self.max_items = input;
            self
        }
        /// Consumes the builder and constructs a [`ListKeyGroupsInput`](crate::input::ListKeyGroupsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListKeyGroupsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListKeyGroupsInput {
                marker: self.marker,
                max_items: self.max_items,
            })
        }
    }
}
#[doc(hidden)]
pub type ListKeyGroupsInputOperationOutputAlias = crate::operation::ListKeyGroups;
#[doc(hidden)]
pub type ListKeyGroupsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListKeyGroupsInput {
    /// Consumes the builder and constructs an Operation<[`ListKeyGroups`](crate::operation::ListKeyGroups)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListKeyGroups,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ListKeyGroupsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/2020-05-31/key-group").expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::ListKeyGroupsInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_80) = &_input.marker {
                    query.push_kv("Marker", &aws_smithy_http::query::fmt_string(&inner_80));
                }
                if let Some(inner_81) = &_input.max_items {
                    query.push_kv(
                        "MaxItems",
                        aws_smithy_types::primitive::Encoder::from(*inner_81).encode(),
                    );
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ListKeyGroupsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListKeyGroups::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListKeyGroups",
            "cloudfront",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ListKeyGroupsInput`](crate::input::ListKeyGroupsInput)
    pub fn builder() -> crate::input::list_key_groups_input::Builder {
        crate::input::list_key_groups_input::Builder::default()
    }
}

/// See [`ListOriginRequestPoliciesInput`](crate::input::ListOriginRequestPoliciesInput)
pub mod list_origin_request_policies_input {
    /// A builder for [`ListOriginRequestPoliciesInput`](crate::input::ListOriginRequestPoliciesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) r#type: std::option::Option<crate::model::OriginRequestPolicyType>,
        pub(crate) marker: std::option::Option<std::string::String>,
        pub(crate) max_items: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>A filter to return only the specified kinds of origin request policies. Valid values are:</p>
        /// <ul>
        /// <li> <p> <code>managed</code> – Returns only the managed policies created by Amazon Web Services.</p> </li>
        /// <li> <p> <code>custom</code> – Returns only the custom policies created in your Amazon Web Services account.</p> </li>
        /// </ul>
        pub fn r#type(mut self, input: crate::model::OriginRequestPolicyType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>A filter to return only the specified kinds of origin request policies. Valid values are:</p>
        /// <ul>
        /// <li> <p> <code>managed</code> – Returns only the managed policies created by Amazon Web Services.</p> </li>
        /// <li> <p> <code>custom</code> – Returns only the custom policies created in your Amazon Web Services account.</p> </li>
        /// </ul>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::OriginRequestPolicyType>,
        ) -> Self {
            self.r#type = input;
            self
        }
        /// <p>Use this field when paginating results to indicate where to begin in your list of origin request policies. The response includes origin request policies in the list that occur after the marker. To get the next page of the list, set this field’s value to the value of <code>NextMarker</code> from the current page’s response.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>Use this field when paginating results to indicate where to begin in your list of origin request policies. The response includes origin request policies in the list that occur after the marker. To get the next page of the list, set this field’s value to the value of <code>NextMarker</code> from the current page’s response.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// <p>The maximum number of origin request policies that you want in the response.</p>
        pub fn max_items(mut self, input: i32) -> Self {
            self.max_items = Some(input);
            self
        }
        /// <p>The maximum number of origin request policies that you want in the response.</p>
        pub fn set_max_items(mut self, input: std::option::Option<i32>) -> Self {
            self.max_items = input;
            self
        }
        /// Consumes the builder and constructs a [`ListOriginRequestPoliciesInput`](crate::input::ListOriginRequestPoliciesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListOriginRequestPoliciesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListOriginRequestPoliciesInput {
                r#type: self.r#type,
                marker: self.marker,
                max_items: self.max_items,
            })
        }
    }
}
#[doc(hidden)]
pub type ListOriginRequestPoliciesInputOperationOutputAlias =
    crate::operation::ListOriginRequestPolicies;
#[doc(hidden)]
pub type ListOriginRequestPoliciesInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListOriginRequestPoliciesInput {
    /// Consumes the builder and constructs an Operation<[`ListOriginRequestPolicies`](crate::operation::ListOriginRequestPolicies)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListOriginRequestPolicies,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ListOriginRequestPoliciesInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/2020-05-31/origin-request-policy")
                    .expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::ListOriginRequestPoliciesInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_82) = &_input.r#type {
                    query.push_kv("Type", &aws_smithy_http::query::fmt_string(&inner_82));
                }
                if let Some(inner_83) = &_input.marker {
                    query.push_kv("Marker", &aws_smithy_http::query::fmt_string(&inner_83));
                }
                if let Some(inner_84) = &_input.max_items {
                    query.push_kv(
                        "MaxItems",
                        aws_smithy_types::primitive::Encoder::from(*inner_84).encode(),
                    );
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ListOriginRequestPoliciesInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListOriginRequestPolicies::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListOriginRequestPolicies",
            "cloudfront",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ListOriginRequestPoliciesInput`](crate::input::ListOriginRequestPoliciesInput)
    pub fn builder() -> crate::input::list_origin_request_policies_input::Builder {
        crate::input::list_origin_request_policies_input::Builder::default()
    }
}

/// See [`ListPublicKeysInput`](crate::input::ListPublicKeysInput)
pub mod list_public_keys_input {
    /// A builder for [`ListPublicKeysInput`](crate::input::ListPublicKeysInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) marker: std::option::Option<std::string::String>,
        pub(crate) max_items: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>Use this when paginating results to indicate where to begin in your list of public keys. The results include public keys in the list that occur after the marker. To get the next page of results, set the <code>Marker</code> to the value of the <code>NextMarker</code> from the current page's response (which is also the ID of the last public key on that page). </p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>Use this when paginating results to indicate where to begin in your list of public keys. The results include public keys in the list that occur after the marker. To get the next page of results, set the <code>Marker</code> to the value of the <code>NextMarker</code> from the current page's response (which is also the ID of the last public key on that page). </p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// <p>The maximum number of public keys you want in the response body. </p>
        pub fn max_items(mut self, input: i32) -> Self {
            self.max_items = Some(input);
            self
        }
        /// <p>The maximum number of public keys you want in the response body. </p>
        pub fn set_max_items(mut self, input: std::option::Option<i32>) -> Self {
            self.max_items = input;
            self
        }
        /// Consumes the builder and constructs a [`ListPublicKeysInput`](crate::input::ListPublicKeysInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListPublicKeysInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListPublicKeysInput {
                marker: self.marker,
                max_items: self.max_items,
            })
        }
    }
}
#[doc(hidden)]
pub type ListPublicKeysInputOperationOutputAlias = crate::operation::ListPublicKeys;
#[doc(hidden)]
pub type ListPublicKeysInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListPublicKeysInput {
    /// Consumes the builder and constructs an Operation<[`ListPublicKeys`](crate::operation::ListPublicKeys)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListPublicKeys,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ListPublicKeysInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/2020-05-31/public-key").expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::ListPublicKeysInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_85) = &_input.marker {
                    query.push_kv("Marker", &aws_smithy_http::query::fmt_string(&inner_85));
                }
                if let Some(inner_86) = &_input.max_items {
                    query.push_kv(
                        "MaxItems",
                        aws_smithy_types::primitive::Encoder::from(*inner_86).encode(),
                    );
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ListPublicKeysInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListPublicKeys::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListPublicKeys",
            "cloudfront",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ListPublicKeysInput`](crate::input::ListPublicKeysInput)
    pub fn builder() -> crate::input::list_public_keys_input::Builder {
        crate::input::list_public_keys_input::Builder::default()
    }
}

/// See [`ListRealtimeLogConfigsInput`](crate::input::ListRealtimeLogConfigsInput)
pub mod list_realtime_log_configs_input {
    /// A builder for [`ListRealtimeLogConfigsInput`](crate::input::ListRealtimeLogConfigsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) max_items: std::option::Option<i32>,
        pub(crate) marker: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The maximum number of real-time log configurations that you want in the response.</p>
        pub fn max_items(mut self, input: i32) -> Self {
            self.max_items = Some(input);
            self
        }
        /// <p>The maximum number of real-time log configurations that you want in the response.</p>
        pub fn set_max_items(mut self, input: std::option::Option<i32>) -> Self {
            self.max_items = input;
            self
        }
        /// <p>Use this field when paginating results to indicate where to begin in your list of real-time log configurations. The response includes real-time log configurations in the list that occur after the marker. To get the next page of the list, set this field’s value to the value of <code>NextMarker</code> from the current page’s response.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>Use this field when paginating results to indicate where to begin in your list of real-time log configurations. The response includes real-time log configurations in the list that occur after the marker. To get the next page of the list, set this field’s value to the value of <code>NextMarker</code> from the current page’s response.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// Consumes the builder and constructs a [`ListRealtimeLogConfigsInput`](crate::input::ListRealtimeLogConfigsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListRealtimeLogConfigsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListRealtimeLogConfigsInput {
                max_items: self.max_items,
                marker: self.marker,
            })
        }
    }
}
#[doc(hidden)]
pub type ListRealtimeLogConfigsInputOperationOutputAlias = crate::operation::ListRealtimeLogConfigs;
#[doc(hidden)]
pub type ListRealtimeLogConfigsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListRealtimeLogConfigsInput {
    /// Consumes the builder and constructs an Operation<[`ListRealtimeLogConfigs`](crate::operation::ListRealtimeLogConfigs)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListRealtimeLogConfigs,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ListRealtimeLogConfigsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/2020-05-31/realtime-log-config")
                    .expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::ListRealtimeLogConfigsInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_87) = &_input.max_items {
                    query.push_kv(
                        "MaxItems",
                        aws_smithy_types::primitive::Encoder::from(*inner_87).encode(),
                    );
                }
                if let Some(inner_88) = &_input.marker {
                    query.push_kv("Marker", &aws_smithy_http::query::fmt_string(&inner_88));
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ListRealtimeLogConfigsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListRealtimeLogConfigs::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListRealtimeLogConfigs",
            "cloudfront",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ListRealtimeLogConfigsInput`](crate::input::ListRealtimeLogConfigsInput)
    pub fn builder() -> crate::input::list_realtime_log_configs_input::Builder {
        crate::input::list_realtime_log_configs_input::Builder::default()
    }
}

/// See [`ListResponseHeadersPoliciesInput`](crate::input::ListResponseHeadersPoliciesInput)
pub mod list_response_headers_policies_input {
    /// A builder for [`ListResponseHeadersPoliciesInput`](crate::input::ListResponseHeadersPoliciesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) r#type: std::option::Option<crate::model::ResponseHeadersPolicyType>,
        pub(crate) marker: std::option::Option<std::string::String>,
        pub(crate) max_items: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>A filter to get only the specified kind of response headers policies. Valid values are:</p>
        /// <ul>
        /// <li> <p> <code>managed</code> – Gets only the managed policies created by Amazon Web Services.</p> </li>
        /// <li> <p> <code>custom</code> – Gets only the custom policies created in your Amazon Web Services account.</p> </li>
        /// </ul>
        pub fn r#type(mut self, input: crate::model::ResponseHeadersPolicyType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>A filter to get only the specified kind of response headers policies. Valid values are:</p>
        /// <ul>
        /// <li> <p> <code>managed</code> – Gets only the managed policies created by Amazon Web Services.</p> </li>
        /// <li> <p> <code>custom</code> – Gets only the custom policies created in your Amazon Web Services account.</p> </li>
        /// </ul>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::ResponseHeadersPolicyType>,
        ) -> Self {
            self.r#type = input;
            self
        }
        /// <p>Use this field when paginating results to indicate where to begin in your list of response headers policies. The response includes response headers policies in the list that occur after the marker. To get the next page of the list, set this field’s value to the value of <code>NextMarker</code> from the current page’s response. </p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>Use this field when paginating results to indicate where to begin in your list of response headers policies. The response includes response headers policies in the list that occur after the marker. To get the next page of the list, set this field’s value to the value of <code>NextMarker</code> from the current page’s response. </p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// <p>The maximum number of response headers policies that you want to get in the response.</p>
        pub fn max_items(mut self, input: i32) -> Self {
            self.max_items = Some(input);
            self
        }
        /// <p>The maximum number of response headers policies that you want to get in the response.</p>
        pub fn set_max_items(mut self, input: std::option::Option<i32>) -> Self {
            self.max_items = input;
            self
        }
        /// Consumes the builder and constructs a [`ListResponseHeadersPoliciesInput`](crate::input::ListResponseHeadersPoliciesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListResponseHeadersPoliciesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListResponseHeadersPoliciesInput {
                r#type: self.r#type,
                marker: self.marker,
                max_items: self.max_items,
            })
        }
    }
}
#[doc(hidden)]
pub type ListResponseHeadersPoliciesInputOperationOutputAlias =
    crate::operation::ListResponseHeadersPolicies;
#[doc(hidden)]
pub type ListResponseHeadersPoliciesInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListResponseHeadersPoliciesInput {
    /// Consumes the builder and constructs an Operation<[`ListResponseHeadersPolicies`](crate::operation::ListResponseHeadersPolicies)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListResponseHeadersPolicies,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ListResponseHeadersPoliciesInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/2020-05-31/response-headers-policy")
                    .expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::ListResponseHeadersPoliciesInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_89) = &_input.r#type {
                    query.push_kv("Type", &aws_smithy_http::query::fmt_string(&inner_89));
                }
                if let Some(inner_90) = &_input.marker {
                    query.push_kv("Marker", &aws_smithy_http::query::fmt_string(&inner_90));
                }
                if let Some(inner_91) = &_input.max_items {
                    query.push_kv(
                        "MaxItems",
                        aws_smithy_types::primitive::Encoder::from(*inner_91).encode(),
                    );
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ListResponseHeadersPoliciesInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListResponseHeadersPolicies::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListResponseHeadersPolicies",
            "cloudfront",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ListResponseHeadersPoliciesInput`](crate::input::ListResponseHeadersPoliciesInput)
    pub fn builder() -> crate::input::list_response_headers_policies_input::Builder {
        crate::input::list_response_headers_policies_input::Builder::default()
    }
}

/// See [`ListStreamingDistributionsInput`](crate::input::ListStreamingDistributionsInput)
pub mod list_streaming_distributions_input {
    /// A builder for [`ListStreamingDistributionsInput`](crate::input::ListStreamingDistributionsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) marker: std::option::Option<std::string::String>,
        pub(crate) max_items: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The value that you provided for the <code>Marker</code> request parameter.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>The value that you provided for the <code>Marker</code> request parameter.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// <p>The value that you provided for the <code>MaxItems</code> request parameter.</p>
        pub fn max_items(mut self, input: i32) -> Self {
            self.max_items = Some(input);
            self
        }
        /// <p>The value that you provided for the <code>MaxItems</code> request parameter.</p>
        pub fn set_max_items(mut self, input: std::option::Option<i32>) -> Self {
            self.max_items = input;
            self
        }
        /// Consumes the builder and constructs a [`ListStreamingDistributionsInput`](crate::input::ListStreamingDistributionsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListStreamingDistributionsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListStreamingDistributionsInput {
                marker: self.marker,
                max_items: self.max_items,
            })
        }
    }
}
#[doc(hidden)]
pub type ListStreamingDistributionsInputOperationOutputAlias =
    crate::operation::ListStreamingDistributions;
#[doc(hidden)]
pub type ListStreamingDistributionsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListStreamingDistributionsInput {
    /// Consumes the builder and constructs an Operation<[`ListStreamingDistributions`](crate::operation::ListStreamingDistributions)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListStreamingDistributions,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ListStreamingDistributionsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/2020-05-31/streaming-distribution")
                    .expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::ListStreamingDistributionsInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_92) = &_input.marker {
                    query.push_kv("Marker", &aws_smithy_http::query::fmt_string(&inner_92));
                }
                if let Some(inner_93) = &_input.max_items {
                    query.push_kv(
                        "MaxItems",
                        aws_smithy_types::primitive::Encoder::from(*inner_93).encode(),
                    );
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ListStreamingDistributionsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListStreamingDistributions::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListStreamingDistributions",
            "cloudfront",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ListStreamingDistributionsInput`](crate::input::ListStreamingDistributionsInput)
    pub fn builder() -> crate::input::list_streaming_distributions_input::Builder {
        crate::input::list_streaming_distributions_input::Builder::default()
    }
}

/// See [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
pub mod list_tags_for_resource_input {
    /// A builder for [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p> An ARN of a CloudFront resource.</p>
        pub fn resource(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource = Some(input.into());
            self
        }
        /// <p> An ARN of a CloudFront resource.</p>
        pub fn set_resource(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListTagsForResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListTagsForResourceInput {
                resource: self.resource,
            })
        }
    }
}
#[doc(hidden)]
pub type ListTagsForResourceInputOperationOutputAlias = crate::operation::ListTagsForResource;
#[doc(hidden)]
pub type ListTagsForResourceInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListTagsForResourceInput {
    /// Consumes the builder and constructs an Operation<[`ListTagsForResource`](crate::operation::ListTagsForResource)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListTagsForResource,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ListTagsForResourceInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/2020-05-31/tagging").expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::ListTagsForResourceInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_94) = &_input.resource {
                    query.push_kv("Resource", &aws_smithy_http::query::fmt_string(&inner_94));
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ListTagsForResourceInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListTagsForResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListTagsForResource",
            "cloudfront",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    pub fn builder() -> crate::input::list_tags_for_resource_input::Builder {
        crate::input::list_tags_for_resource_input::Builder::default()
    }
}

/// See [`PublishFunctionInput`](crate::input::PublishFunctionInput)
pub mod publish_function_input {
    /// A builder for [`PublishFunctionInput`](crate::input::PublishFunctionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) if_match: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the function that you are publishing.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the function that you are publishing.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The current version (<code>ETag</code> value) of the function that you are publishing, which you can get using <code>DescribeFunction</code>.</p>
        pub fn if_match(mut self, input: impl Into<std::string::String>) -> Self {
            self.if_match = Some(input.into());
            self
        }
        /// <p>The current version (<code>ETag</code> value) of the function that you are publishing, which you can get using <code>DescribeFunction</code>.</p>
        pub fn set_if_match(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.if_match = input;
            self
        }
        /// Consumes the builder and constructs a [`PublishFunctionInput`](crate::input::PublishFunctionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::PublishFunctionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::PublishFunctionInput {
                name: self.name,
                if_match: self.if_match,
            })
        }
    }
}
#[doc(hidden)]
pub type PublishFunctionInputOperationOutputAlias = crate::operation::PublishFunction;
#[doc(hidden)]
pub type PublishFunctionInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl PublishFunctionInput {
    /// Consumes the builder and constructs an Operation<[`PublishFunction`](crate::operation::PublishFunction)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::PublishFunction,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::PublishFunctionInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_95 = &_input.name;
                let input_95 = input_95.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let name = aws_smithy_http::label::fmt_string(input_95, false);
                if name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/2020-05-31/function/{Name}/publish", Name = name)
                    .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::PublishFunctionInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                let builder = crate::http_serde::add_headers_publish_function(input, builder)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::PublishFunction::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "PublishFunction",
            "cloudfront",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`PublishFunctionInput`](crate::input::PublishFunctionInput)
    pub fn builder() -> crate::input::publish_function_input::Builder {
        crate::input::publish_function_input::Builder::default()
    }
}

/// See [`TagResourceInput`](crate::input::TagResourceInput)
pub mod tag_resource_input {
    /// A builder for [`TagResourceInput`](crate::input::TagResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<crate::model::Tags>,
    }
    impl Builder {
        /// <p> An ARN of a CloudFront resource.</p>
        pub fn resource(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource = Some(input.into());
            self
        }
        /// <p> An ARN of a CloudFront resource.</p>
        pub fn set_resource(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource = input;
            self
        }
        /// <p> A complex type that contains zero or more <code>Tag</code> elements.</p>
        pub fn tags(mut self, input: crate::model::Tags) -> Self {
            self.tags = Some(input);
            self
        }
        /// <p> A complex type that contains zero or more <code>Tag</code> elements.</p>
        pub fn set_tags(mut self, input: std::option::Option<crate::model::Tags>) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`TagResourceInput`](crate::input::TagResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::TagResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::TagResourceInput {
                resource: self.resource,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type TagResourceInputOperationOutputAlias = crate::operation::TagResource;
#[doc(hidden)]
pub type TagResourceInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl TagResourceInput {
    /// Consumes the builder and constructs an Operation<[`TagResource`](crate::operation::TagResource)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::TagResource,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::TagResourceInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/2020-05-31/tagging").expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::TagResourceInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                query.push_kv("Operation", "Tag");
                if let Some(inner_96) = &_input.resource {
                    query.push_kv("Resource", &aws_smithy_http::query::fmt_string(&inner_96));
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::TagResourceInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/xml",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_payload_tag_resource_input(&self.tags)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::TagResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "TagResource",
            "cloudfront",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`TagResourceInput`](crate::input::TagResourceInput)
    pub fn builder() -> crate::input::tag_resource_input::Builder {
        crate::input::tag_resource_input::Builder::default()
    }
}

/// See [`TestFunctionInput`](crate::input::TestFunctionInput)
pub mod test_function_input {
    /// A builder for [`TestFunctionInput`](crate::input::TestFunctionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) if_match: std::option::Option<std::string::String>,
        pub(crate) stage: std::option::Option<crate::model::FunctionStage>,
        pub(crate) event_object: std::option::Option<aws_smithy_types::Blob>,
    }
    impl Builder {
        /// <p>The name of the function that you are testing.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the function that you are testing.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The current version (<code>ETag</code> value) of the function that you are testing, which you can get using <code>DescribeFunction</code>.</p>
        pub fn if_match(mut self, input: impl Into<std::string::String>) -> Self {
            self.if_match = Some(input.into());
            self
        }
        /// <p>The current version (<code>ETag</code> value) of the function that you are testing, which you can get using <code>DescribeFunction</code>.</p>
        pub fn set_if_match(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.if_match = input;
            self
        }
        /// <p>The stage of the function that you are testing, either <code>DEVELOPMENT</code> or <code>LIVE</code>.</p>
        pub fn stage(mut self, input: crate::model::FunctionStage) -> Self {
            self.stage = Some(input);
            self
        }
        /// <p>The stage of the function that you are testing, either <code>DEVELOPMENT</code> or <code>LIVE</code>.</p>
        pub fn set_stage(
            mut self,
            input: std::option::Option<crate::model::FunctionStage>,
        ) -> Self {
            self.stage = input;
            self
        }
        /// <p>The event object to test the function with. For more information about the structure of the event object, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/managing-functions.html#test-function">Testing functions</a> in the <i>Amazon CloudFront Developer Guide</i>.</p>
        pub fn event_object(mut self, input: aws_smithy_types::Blob) -> Self {
            self.event_object = Some(input);
            self
        }
        /// <p>The event object to test the function with. For more information about the structure of the event object, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/managing-functions.html#test-function">Testing functions</a> in the <i>Amazon CloudFront Developer Guide</i>.</p>
        pub fn set_event_object(
            mut self,
            input: std::option::Option<aws_smithy_types::Blob>,
        ) -> Self {
            self.event_object = input;
            self
        }
        /// Consumes the builder and constructs a [`TestFunctionInput`](crate::input::TestFunctionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::TestFunctionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::TestFunctionInput {
                name: self.name,
                if_match: self.if_match,
                stage: self.stage,
                event_object: self.event_object,
            })
        }
    }
}
#[doc(hidden)]
pub type TestFunctionInputOperationOutputAlias = crate::operation::TestFunction;
#[doc(hidden)]
pub type TestFunctionInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl TestFunctionInput {
    /// Consumes the builder and constructs an Operation<[`TestFunction`](crate::operation::TestFunction)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::TestFunction,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::TestFunctionInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_97 = &_input.name;
                let input_97 = input_97.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let name = aws_smithy_http::label::fmt_string(input_97, false);
                if name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/2020-05-31/function/{Name}/test", Name = name)
                    .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::TestFunctionInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                let builder = crate::http_serde::add_headers_test_function(input, builder)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/xml",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_test_function(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::TestFunction::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "TestFunction",
            "cloudfront",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`TestFunctionInput`](crate::input::TestFunctionInput)
    pub fn builder() -> crate::input::test_function_input::Builder {
        crate::input::test_function_input::Builder::default()
    }
}

/// See [`UntagResourceInput`](crate::input::UntagResourceInput)
pub mod untag_resource_input {
    /// A builder for [`UntagResourceInput`](crate::input::UntagResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource: std::option::Option<std::string::String>,
        pub(crate) tag_keys: std::option::Option<crate::model::TagKeys>,
    }
    impl Builder {
        /// <p> An ARN of a CloudFront resource.</p>
        pub fn resource(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource = Some(input.into());
            self
        }
        /// <p> An ARN of a CloudFront resource.</p>
        pub fn set_resource(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource = input;
            self
        }
        /// <p> A complex type that contains zero or more <code>Tag</code> key elements.</p>
        pub fn tag_keys(mut self, input: crate::model::TagKeys) -> Self {
            self.tag_keys = Some(input);
            self
        }
        /// <p> A complex type that contains zero or more <code>Tag</code> key elements.</p>
        pub fn set_tag_keys(mut self, input: std::option::Option<crate::model::TagKeys>) -> Self {
            self.tag_keys = input;
            self
        }
        /// Consumes the builder and constructs a [`UntagResourceInput`](crate::input::UntagResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UntagResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UntagResourceInput {
                resource: self.resource,
                tag_keys: self.tag_keys,
            })
        }
    }
}
#[doc(hidden)]
pub type UntagResourceInputOperationOutputAlias = crate::operation::UntagResource;
#[doc(hidden)]
pub type UntagResourceInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UntagResourceInput {
    /// Consumes the builder and constructs an Operation<[`UntagResource`](crate::operation::UntagResource)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UntagResource,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::UntagResourceInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/2020-05-31/tagging").expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::UntagResourceInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                query.push_kv("Operation", "Untag");
                if let Some(inner_98) = &_input.resource {
                    query.push_kv("Resource", &aws_smithy_http::query::fmt_string(&inner_98));
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::UntagResourceInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/xml",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_payload_untag_resource_input(&self.tag_keys)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UntagResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UntagResource",
            "cloudfront",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`UntagResourceInput`](crate::input::UntagResourceInput)
    pub fn builder() -> crate::input::untag_resource_input::Builder {
        crate::input::untag_resource_input::Builder::default()
    }
}

/// See [`UpdateCachePolicyInput`](crate::input::UpdateCachePolicyInput)
pub mod update_cache_policy_input {
    /// A builder for [`UpdateCachePolicyInput`](crate::input::UpdateCachePolicyInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cache_policy_config: std::option::Option<crate::model::CachePolicyConfig>,
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) if_match: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A cache policy configuration.</p>
        pub fn cache_policy_config(mut self, input: crate::model::CachePolicyConfig) -> Self {
            self.cache_policy_config = Some(input);
            self
        }
        /// <p>A cache policy configuration.</p>
        pub fn set_cache_policy_config(
            mut self,
            input: std::option::Option<crate::model::CachePolicyConfig>,
        ) -> Self {
            self.cache_policy_config = input;
            self
        }
        /// <p>The unique identifier for the cache policy that you are updating. The identifier is returned in a cache behavior’s <code>CachePolicyId</code> field in the response to <code>GetDistributionConfig</code>.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the cache policy that you are updating. The identifier is returned in a cache behavior’s <code>CachePolicyId</code> field in the response to <code>GetDistributionConfig</code>.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The version of the cache policy that you are updating. The version is returned in the cache policy’s <code>ETag</code> field in the response to <code>GetCachePolicyConfig</code>.</p>
        pub fn if_match(mut self, input: impl Into<std::string::String>) -> Self {
            self.if_match = Some(input.into());
            self
        }
        /// <p>The version of the cache policy that you are updating. The version is returned in the cache policy’s <code>ETag</code> field in the response to <code>GetCachePolicyConfig</code>.</p>
        pub fn set_if_match(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.if_match = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateCachePolicyInput`](crate::input::UpdateCachePolicyInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateCachePolicyInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateCachePolicyInput {
                cache_policy_config: self.cache_policy_config,
                id: self.id,
                if_match: self.if_match,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateCachePolicyInputOperationOutputAlias = crate::operation::UpdateCachePolicy;
#[doc(hidden)]
pub type UpdateCachePolicyInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdateCachePolicyInput {
    /// Consumes the builder and constructs an Operation<[`UpdateCachePolicy`](crate::operation::UpdateCachePolicy)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateCachePolicy,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::UpdateCachePolicyInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_99 = &_input.id;
                let input_99 = input_99.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let id = aws_smithy_http::label::fmt_string(input_99, false);
                if id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/2020-05-31/cache-policy/{Id}", Id = id)
                    .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::UpdateCachePolicyInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                let builder = crate::http_serde::add_headers_update_cache_policy(input, builder)?;
                Ok(builder.method("PUT").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/xml",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_payload_update_cache_policy_input(
                &self.cache_policy_config,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateCachePolicy::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateCachePolicy",
            "cloudfront",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`UpdateCachePolicyInput`](crate::input::UpdateCachePolicyInput)
    pub fn builder() -> crate::input::update_cache_policy_input::Builder {
        crate::input::update_cache_policy_input::Builder::default()
    }
}

/// See [`UpdateCloudFrontOriginAccessIdentityInput`](crate::input::UpdateCloudFrontOriginAccessIdentityInput)
pub mod update_cloud_front_origin_access_identity_input {
    /// A builder for [`UpdateCloudFrontOriginAccessIdentityInput`](crate::input::UpdateCloudFrontOriginAccessIdentityInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cloud_front_origin_access_identity_config:
            std::option::Option<crate::model::CloudFrontOriginAccessIdentityConfig>,
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) if_match: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identity's configuration information.</p>
        pub fn cloud_front_origin_access_identity_config(
            mut self,
            input: crate::model::CloudFrontOriginAccessIdentityConfig,
        ) -> Self {
            self.cloud_front_origin_access_identity_config = Some(input);
            self
        }
        /// <p>The identity's configuration information.</p>
        pub fn set_cloud_front_origin_access_identity_config(
            mut self,
            input: std::option::Option<crate::model::CloudFrontOriginAccessIdentityConfig>,
        ) -> Self {
            self.cloud_front_origin_access_identity_config = input;
            self
        }
        /// <p>The identity's id.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The identity's id.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The value of the <code>ETag</code> header that you received when retrieving the identity's configuration. For example: <code>E2QWRUHAPOMQZL</code>.</p>
        pub fn if_match(mut self, input: impl Into<std::string::String>) -> Self {
            self.if_match = Some(input.into());
            self
        }
        /// <p>The value of the <code>ETag</code> header that you received when retrieving the identity's configuration. For example: <code>E2QWRUHAPOMQZL</code>.</p>
        pub fn set_if_match(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.if_match = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateCloudFrontOriginAccessIdentityInput`](crate::input::UpdateCloudFrontOriginAccessIdentityInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateCloudFrontOriginAccessIdentityInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateCloudFrontOriginAccessIdentityInput {
                cloud_front_origin_access_identity_config: self
                    .cloud_front_origin_access_identity_config,
                id: self.id,
                if_match: self.if_match,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateCloudFrontOriginAccessIdentityInputOperationOutputAlias =
    crate::operation::UpdateCloudFrontOriginAccessIdentity;
#[doc(hidden)]
pub type UpdateCloudFrontOriginAccessIdentityInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl UpdateCloudFrontOriginAccessIdentityInput {
    /// Consumes the builder and constructs an Operation<[`UpdateCloudFrontOriginAccessIdentity`](crate::operation::UpdateCloudFrontOriginAccessIdentity)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateCloudFrontOriginAccessIdentity,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::UpdateCloudFrontOriginAccessIdentityInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_100 = &_input.id;
                let input_100 = input_100.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let id = aws_smithy_http::label::fmt_string(input_100, false);
                if id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/2020-05-31/origin-access-identity/cloudfront/{Id}/config",
                    Id = id
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::UpdateCloudFrontOriginAccessIdentityInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                let builder =
                    crate::http_serde::add_headers_update_cloud_front_origin_access_identity(
                        input, builder,
                    )?;
                Ok(builder.method("PUT").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/xml",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_payload_update_cloud_front_origin_access_identity_input(& self.cloud_front_origin_access_identity_config)?
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateCloudFrontOriginAccessIdentity::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateCloudFrontOriginAccessIdentity",
            "cloudfront",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`UpdateCloudFrontOriginAccessIdentityInput`](crate::input::UpdateCloudFrontOriginAccessIdentityInput)
    pub fn builder() -> crate::input::update_cloud_front_origin_access_identity_input::Builder {
        crate::input::update_cloud_front_origin_access_identity_input::Builder::default()
    }
}

/// See [`UpdateDistributionInput`](crate::input::UpdateDistributionInput)
pub mod update_distribution_input {
    /// A builder for [`UpdateDistributionInput`](crate::input::UpdateDistributionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) distribution_config: std::option::Option<crate::model::DistributionConfig>,
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) if_match: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The distribution's configuration information.</p>
        pub fn distribution_config(mut self, input: crate::model::DistributionConfig) -> Self {
            self.distribution_config = Some(input);
            self
        }
        /// <p>The distribution's configuration information.</p>
        pub fn set_distribution_config(
            mut self,
            input: std::option::Option<crate::model::DistributionConfig>,
        ) -> Self {
            self.distribution_config = input;
            self
        }
        /// <p>The distribution's id.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The distribution's id.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The value of the <code>ETag</code> header that you received when retrieving the distribution's configuration. For example: <code>E2QWRUHAPOMQZL</code>.</p>
        pub fn if_match(mut self, input: impl Into<std::string::String>) -> Self {
            self.if_match = Some(input.into());
            self
        }
        /// <p>The value of the <code>ETag</code> header that you received when retrieving the distribution's configuration. For example: <code>E2QWRUHAPOMQZL</code>.</p>
        pub fn set_if_match(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.if_match = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateDistributionInput`](crate::input::UpdateDistributionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateDistributionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateDistributionInput {
                distribution_config: self.distribution_config,
                id: self.id,
                if_match: self.if_match,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateDistributionInputOperationOutputAlias = crate::operation::UpdateDistribution;
#[doc(hidden)]
pub type UpdateDistributionInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdateDistributionInput {
    /// Consumes the builder and constructs an Operation<[`UpdateDistribution`](crate::operation::UpdateDistribution)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateDistribution,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::UpdateDistributionInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_101 = &_input.id;
                let input_101 = input_101.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let id = aws_smithy_http::label::fmt_string(input_101, false);
                if id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/2020-05-31/distribution/{Id}/config", Id = id)
                    .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::UpdateDistributionInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                let builder = crate::http_serde::add_headers_update_distribution(input, builder)?;
                Ok(builder.method("PUT").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/xml",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_payload_update_distribution_input(
                &self.distribution_config,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateDistribution::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateDistribution",
            "cloudfront",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`UpdateDistributionInput`](crate::input::UpdateDistributionInput)
    pub fn builder() -> crate::input::update_distribution_input::Builder {
        crate::input::update_distribution_input::Builder::default()
    }
}

/// See [`UpdateFieldLevelEncryptionConfigInput`](crate::input::UpdateFieldLevelEncryptionConfigInput)
pub mod update_field_level_encryption_config_input {
    /// A builder for [`UpdateFieldLevelEncryptionConfigInput`](crate::input::UpdateFieldLevelEncryptionConfigInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) field_level_encryption_config:
            std::option::Option<crate::model::FieldLevelEncryptionConfig>,
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) if_match: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Request to update a field-level encryption configuration. </p>
        pub fn field_level_encryption_config(
            mut self,
            input: crate::model::FieldLevelEncryptionConfig,
        ) -> Self {
            self.field_level_encryption_config = Some(input);
            self
        }
        /// <p>Request to update a field-level encryption configuration. </p>
        pub fn set_field_level_encryption_config(
            mut self,
            input: std::option::Option<crate::model::FieldLevelEncryptionConfig>,
        ) -> Self {
            self.field_level_encryption_config = input;
            self
        }
        /// <p>The ID of the configuration you want to update.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The ID of the configuration you want to update.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The value of the <code>ETag</code> header that you received when retrieving the configuration identity to update. For example: <code>E2QWRUHAPOMQZL</code>.</p>
        pub fn if_match(mut self, input: impl Into<std::string::String>) -> Self {
            self.if_match = Some(input.into());
            self
        }
        /// <p>The value of the <code>ETag</code> header that you received when retrieving the configuration identity to update. For example: <code>E2QWRUHAPOMQZL</code>.</p>
        pub fn set_if_match(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.if_match = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateFieldLevelEncryptionConfigInput`](crate::input::UpdateFieldLevelEncryptionConfigInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateFieldLevelEncryptionConfigInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateFieldLevelEncryptionConfigInput {
                field_level_encryption_config: self.field_level_encryption_config,
                id: self.id,
                if_match: self.if_match,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateFieldLevelEncryptionConfigInputOperationOutputAlias =
    crate::operation::UpdateFieldLevelEncryptionConfig;
#[doc(hidden)]
pub type UpdateFieldLevelEncryptionConfigInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl UpdateFieldLevelEncryptionConfigInput {
    /// Consumes the builder and constructs an Operation<[`UpdateFieldLevelEncryptionConfig`](crate::operation::UpdateFieldLevelEncryptionConfig)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateFieldLevelEncryptionConfig,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::UpdateFieldLevelEncryptionConfigInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_102 = &_input.id;
                let input_102 = input_102.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let id = aws_smithy_http::label::fmt_string(input_102, false);
                if id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/2020-05-31/field-level-encryption/{Id}/config",
                    Id = id
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::UpdateFieldLevelEncryptionConfigInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                let builder = crate::http_serde::add_headers_update_field_level_encryption_config(
                    input, builder,
                )?;
                Ok(builder.method("PUT").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/xml",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_payload_update_field_level_encryption_config_input(
                &self.field_level_encryption_config,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateFieldLevelEncryptionConfig::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateFieldLevelEncryptionConfig",
            "cloudfront",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`UpdateFieldLevelEncryptionConfigInput`](crate::input::UpdateFieldLevelEncryptionConfigInput)
    pub fn builder() -> crate::input::update_field_level_encryption_config_input::Builder {
        crate::input::update_field_level_encryption_config_input::Builder::default()
    }
}

/// See [`UpdateFieldLevelEncryptionProfileInput`](crate::input::UpdateFieldLevelEncryptionProfileInput)
pub mod update_field_level_encryption_profile_input {
    /// A builder for [`UpdateFieldLevelEncryptionProfileInput`](crate::input::UpdateFieldLevelEncryptionProfileInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) field_level_encryption_profile_config:
            std::option::Option<crate::model::FieldLevelEncryptionProfileConfig>,
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) if_match: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Request to update a field-level encryption profile. </p>
        pub fn field_level_encryption_profile_config(
            mut self,
            input: crate::model::FieldLevelEncryptionProfileConfig,
        ) -> Self {
            self.field_level_encryption_profile_config = Some(input);
            self
        }
        /// <p>Request to update a field-level encryption profile. </p>
        pub fn set_field_level_encryption_profile_config(
            mut self,
            input: std::option::Option<crate::model::FieldLevelEncryptionProfileConfig>,
        ) -> Self {
            self.field_level_encryption_profile_config = input;
            self
        }
        /// <p>The ID of the field-level encryption profile request. </p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The ID of the field-level encryption profile request. </p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The value of the <code>ETag</code> header that you received when retrieving the profile identity to update. For example: <code>E2QWRUHAPOMQZL</code>.</p>
        pub fn if_match(mut self, input: impl Into<std::string::String>) -> Self {
            self.if_match = Some(input.into());
            self
        }
        /// <p>The value of the <code>ETag</code> header that you received when retrieving the profile identity to update. For example: <code>E2QWRUHAPOMQZL</code>.</p>
        pub fn set_if_match(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.if_match = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateFieldLevelEncryptionProfileInput`](crate::input::UpdateFieldLevelEncryptionProfileInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateFieldLevelEncryptionProfileInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateFieldLevelEncryptionProfileInput {
                field_level_encryption_profile_config: self.field_level_encryption_profile_config,
                id: self.id,
                if_match: self.if_match,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateFieldLevelEncryptionProfileInputOperationOutputAlias =
    crate::operation::UpdateFieldLevelEncryptionProfile;
#[doc(hidden)]
pub type UpdateFieldLevelEncryptionProfileInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl UpdateFieldLevelEncryptionProfileInput {
    /// Consumes the builder and constructs an Operation<[`UpdateFieldLevelEncryptionProfile`](crate::operation::UpdateFieldLevelEncryptionProfile)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateFieldLevelEncryptionProfile,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::UpdateFieldLevelEncryptionProfileInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_103 = &_input.id;
                let input_103 = input_103.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let id = aws_smithy_http::label::fmt_string(input_103, false);
                if id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/2020-05-31/field-level-encryption-profile/{Id}/config",
                    Id = id
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::UpdateFieldLevelEncryptionProfileInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                let builder = crate::http_serde::add_headers_update_field_level_encryption_profile(
                    input, builder,
                )?;
                Ok(builder.method("PUT").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/xml",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_payload_update_field_level_encryption_profile_input(
                &self.field_level_encryption_profile_config,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateFieldLevelEncryptionProfile::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateFieldLevelEncryptionProfile",
            "cloudfront",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`UpdateFieldLevelEncryptionProfileInput`](crate::input::UpdateFieldLevelEncryptionProfileInput)
    pub fn builder() -> crate::input::update_field_level_encryption_profile_input::Builder {
        crate::input::update_field_level_encryption_profile_input::Builder::default()
    }
}

/// See [`UpdateFunctionInput`](crate::input::UpdateFunctionInput)
pub mod update_function_input {
    /// A builder for [`UpdateFunctionInput`](crate::input::UpdateFunctionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) if_match: std::option::Option<std::string::String>,
        pub(crate) function_config: std::option::Option<crate::model::FunctionConfig>,
        pub(crate) function_code: std::option::Option<aws_smithy_types::Blob>,
    }
    impl Builder {
        /// <p>The name of the function that you are updating.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the function that you are updating.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The current version (<code>ETag</code> value) of the function that you are updating, which you can get using <code>DescribeFunction</code>.</p>
        pub fn if_match(mut self, input: impl Into<std::string::String>) -> Self {
            self.if_match = Some(input.into());
            self
        }
        /// <p>The current version (<code>ETag</code> value) of the function that you are updating, which you can get using <code>DescribeFunction</code>.</p>
        pub fn set_if_match(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.if_match = input;
            self
        }
        /// <p>Configuration information about the function.</p>
        pub fn function_config(mut self, input: crate::model::FunctionConfig) -> Self {
            self.function_config = Some(input);
            self
        }
        /// <p>Configuration information about the function.</p>
        pub fn set_function_config(
            mut self,
            input: std::option::Option<crate::model::FunctionConfig>,
        ) -> Self {
            self.function_config = input;
            self
        }
        /// <p>The function code. For more information about writing a CloudFront function, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/writing-function-code.html">Writing function code for CloudFront Functions</a> in the <i>Amazon CloudFront Developer Guide</i>.</p>
        pub fn function_code(mut self, input: aws_smithy_types::Blob) -> Self {
            self.function_code = Some(input);
            self
        }
        /// <p>The function code. For more information about writing a CloudFront function, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/writing-function-code.html">Writing function code for CloudFront Functions</a> in the <i>Amazon CloudFront Developer Guide</i>.</p>
        pub fn set_function_code(
            mut self,
            input: std::option::Option<aws_smithy_types::Blob>,
        ) -> Self {
            self.function_code = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateFunctionInput`](crate::input::UpdateFunctionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateFunctionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateFunctionInput {
                name: self.name,
                if_match: self.if_match,
                function_config: self.function_config,
                function_code: self.function_code,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateFunctionInputOperationOutputAlias = crate::operation::UpdateFunction;
#[doc(hidden)]
pub type UpdateFunctionInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdateFunctionInput {
    /// Consumes the builder and constructs an Operation<[`UpdateFunction`](crate::operation::UpdateFunction)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateFunction,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::UpdateFunctionInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_104 = &_input.name;
                let input_104 = input_104.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let name = aws_smithy_http::label::fmt_string(input_104, false);
                if name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/2020-05-31/function/{Name}", Name = name)
                    .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::UpdateFunctionInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                let builder = crate::http_serde::add_headers_update_function(input, builder)?;
                Ok(builder.method("PUT").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/xml",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_update_function(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateFunction::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateFunction",
            "cloudfront",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`UpdateFunctionInput`](crate::input::UpdateFunctionInput)
    pub fn builder() -> crate::input::update_function_input::Builder {
        crate::input::update_function_input::Builder::default()
    }
}

/// See [`UpdateKeyGroupInput`](crate::input::UpdateKeyGroupInput)
pub mod update_key_group_input {
    /// A builder for [`UpdateKeyGroupInput`](crate::input::UpdateKeyGroupInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) key_group_config: std::option::Option<crate::model::KeyGroupConfig>,
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) if_match: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The key group configuration.</p>
        pub fn key_group_config(mut self, input: crate::model::KeyGroupConfig) -> Self {
            self.key_group_config = Some(input);
            self
        }
        /// <p>The key group configuration.</p>
        pub fn set_key_group_config(
            mut self,
            input: std::option::Option<crate::model::KeyGroupConfig>,
        ) -> Self {
            self.key_group_config = input;
            self
        }
        /// <p>The identifier of the key group that you are updating.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The identifier of the key group that you are updating.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The version of the key group that you are updating. The version is the key group’s <code>ETag</code> value.</p>
        pub fn if_match(mut self, input: impl Into<std::string::String>) -> Self {
            self.if_match = Some(input.into());
            self
        }
        /// <p>The version of the key group that you are updating. The version is the key group’s <code>ETag</code> value.</p>
        pub fn set_if_match(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.if_match = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateKeyGroupInput`](crate::input::UpdateKeyGroupInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateKeyGroupInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateKeyGroupInput {
                key_group_config: self.key_group_config,
                id: self.id,
                if_match: self.if_match,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateKeyGroupInputOperationOutputAlias = crate::operation::UpdateKeyGroup;
#[doc(hidden)]
pub type UpdateKeyGroupInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdateKeyGroupInput {
    /// Consumes the builder and constructs an Operation<[`UpdateKeyGroup`](crate::operation::UpdateKeyGroup)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateKeyGroup,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::UpdateKeyGroupInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_105 = &_input.id;
                let input_105 = input_105.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let id = aws_smithy_http::label::fmt_string(input_105, false);
                if id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/2020-05-31/key-group/{Id}", Id = id)
                    .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::UpdateKeyGroupInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                let builder = crate::http_serde::add_headers_update_key_group(input, builder)?;
                Ok(builder.method("PUT").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/xml",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_payload_update_key_group_input(&self.key_group_config)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateKeyGroup::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateKeyGroup",
            "cloudfront",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`UpdateKeyGroupInput`](crate::input::UpdateKeyGroupInput)
    pub fn builder() -> crate::input::update_key_group_input::Builder {
        crate::input::update_key_group_input::Builder::default()
    }
}

/// See [`UpdateOriginRequestPolicyInput`](crate::input::UpdateOriginRequestPolicyInput)
pub mod update_origin_request_policy_input {
    /// A builder for [`UpdateOriginRequestPolicyInput`](crate::input::UpdateOriginRequestPolicyInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) origin_request_policy_config:
            std::option::Option<crate::model::OriginRequestPolicyConfig>,
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) if_match: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>An origin request policy configuration.</p>
        pub fn origin_request_policy_config(
            mut self,
            input: crate::model::OriginRequestPolicyConfig,
        ) -> Self {
            self.origin_request_policy_config = Some(input);
            self
        }
        /// <p>An origin request policy configuration.</p>
        pub fn set_origin_request_policy_config(
            mut self,
            input: std::option::Option<crate::model::OriginRequestPolicyConfig>,
        ) -> Self {
            self.origin_request_policy_config = input;
            self
        }
        /// <p>The unique identifier for the origin request policy that you are updating. The identifier is returned in a cache behavior’s <code>OriginRequestPolicyId</code> field in the response to <code>GetDistributionConfig</code>.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the origin request policy that you are updating. The identifier is returned in a cache behavior’s <code>OriginRequestPolicyId</code> field in the response to <code>GetDistributionConfig</code>.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The version of the origin request policy that you are updating. The version is returned in the origin request policy’s <code>ETag</code> field in the response to <code>GetOriginRequestPolicyConfig</code>.</p>
        pub fn if_match(mut self, input: impl Into<std::string::String>) -> Self {
            self.if_match = Some(input.into());
            self
        }
        /// <p>The version of the origin request policy that you are updating. The version is returned in the origin request policy’s <code>ETag</code> field in the response to <code>GetOriginRequestPolicyConfig</code>.</p>
        pub fn set_if_match(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.if_match = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateOriginRequestPolicyInput`](crate::input::UpdateOriginRequestPolicyInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateOriginRequestPolicyInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateOriginRequestPolicyInput {
                origin_request_policy_config: self.origin_request_policy_config,
                id: self.id,
                if_match: self.if_match,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateOriginRequestPolicyInputOperationOutputAlias =
    crate::operation::UpdateOriginRequestPolicy;
#[doc(hidden)]
pub type UpdateOriginRequestPolicyInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdateOriginRequestPolicyInput {
    /// Consumes the builder and constructs an Operation<[`UpdateOriginRequestPolicy`](crate::operation::UpdateOriginRequestPolicy)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateOriginRequestPolicy,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::UpdateOriginRequestPolicyInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_106 = &_input.id;
                let input_106 = input_106.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let id = aws_smithy_http::label::fmt_string(input_106, false);
                if id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/2020-05-31/origin-request-policy/{Id}", Id = id)
                    .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::UpdateOriginRequestPolicyInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                let builder =
                    crate::http_serde::add_headers_update_origin_request_policy(input, builder)?;
                Ok(builder.method("PUT").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/xml",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_payload_update_origin_request_policy_input(
                &self.origin_request_policy_config,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateOriginRequestPolicy::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateOriginRequestPolicy",
            "cloudfront",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`UpdateOriginRequestPolicyInput`](crate::input::UpdateOriginRequestPolicyInput)
    pub fn builder() -> crate::input::update_origin_request_policy_input::Builder {
        crate::input::update_origin_request_policy_input::Builder::default()
    }
}

/// See [`UpdatePublicKeyInput`](crate::input::UpdatePublicKeyInput)
pub mod update_public_key_input {
    /// A builder for [`UpdatePublicKeyInput`](crate::input::UpdatePublicKeyInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) public_key_config: std::option::Option<crate::model::PublicKeyConfig>,
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) if_match: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A public key configuration.</p>
        pub fn public_key_config(mut self, input: crate::model::PublicKeyConfig) -> Self {
            self.public_key_config = Some(input);
            self
        }
        /// <p>A public key configuration.</p>
        pub fn set_public_key_config(
            mut self,
            input: std::option::Option<crate::model::PublicKeyConfig>,
        ) -> Self {
            self.public_key_config = input;
            self
        }
        /// <p>The identifier of the public key that you are updating.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The identifier of the public key that you are updating.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The value of the <code>ETag</code> header that you received when retrieving the public key to update. For example: <code>E2QWRUHAPOMQZL</code>.</p>
        pub fn if_match(mut self, input: impl Into<std::string::String>) -> Self {
            self.if_match = Some(input.into());
            self
        }
        /// <p>The value of the <code>ETag</code> header that you received when retrieving the public key to update. For example: <code>E2QWRUHAPOMQZL</code>.</p>
        pub fn set_if_match(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.if_match = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdatePublicKeyInput`](crate::input::UpdatePublicKeyInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdatePublicKeyInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdatePublicKeyInput {
                public_key_config: self.public_key_config,
                id: self.id,
                if_match: self.if_match,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdatePublicKeyInputOperationOutputAlias = crate::operation::UpdatePublicKey;
#[doc(hidden)]
pub type UpdatePublicKeyInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdatePublicKeyInput {
    /// Consumes the builder and constructs an Operation<[`UpdatePublicKey`](crate::operation::UpdatePublicKey)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdatePublicKey,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::UpdatePublicKeyInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_107 = &_input.id;
                let input_107 = input_107.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let id = aws_smithy_http::label::fmt_string(input_107, false);
                if id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/2020-05-31/public-key/{Id}/config", Id = id)
                    .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::UpdatePublicKeyInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                let builder = crate::http_serde::add_headers_update_public_key(input, builder)?;
                Ok(builder.method("PUT").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/xml",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_payload_update_public_key_input(
                &self.public_key_config,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdatePublicKey::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdatePublicKey",
            "cloudfront",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`UpdatePublicKeyInput`](crate::input::UpdatePublicKeyInput)
    pub fn builder() -> crate::input::update_public_key_input::Builder {
        crate::input::update_public_key_input::Builder::default()
    }
}

/// See [`UpdateRealtimeLogConfigInput`](crate::input::UpdateRealtimeLogConfigInput)
pub mod update_realtime_log_config_input {
    /// A builder for [`UpdateRealtimeLogConfigInput`](crate::input::UpdateRealtimeLogConfigInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) end_points: std::option::Option<std::vec::Vec<crate::model::EndPoint>>,
        pub(crate) fields: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) sampling_rate: std::option::Option<i64>,
    }
    impl Builder {
        /// Appends an item to `end_points`.
        ///
        /// To override the contents of this collection use [`set_end_points`](Self::set_end_points).
        ///
        /// <p>Contains information about the Amazon Kinesis data stream where you are sending real-time log data.</p>
        pub fn end_points(mut self, input: crate::model::EndPoint) -> Self {
            let mut v = self.end_points.unwrap_or_default();
            v.push(input);
            self.end_points = Some(v);
            self
        }
        /// <p>Contains information about the Amazon Kinesis data stream where you are sending real-time log data.</p>
        pub fn set_end_points(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::EndPoint>>,
        ) -> Self {
            self.end_points = input;
            self
        }
        /// Appends an item to `fields`.
        ///
        /// To override the contents of this collection use [`set_fields`](Self::set_fields).
        ///
        /// <p>A list of fields to include in each real-time log record.</p>
        /// <p>For more information about fields, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/real-time-logs.html#understand-real-time-log-config-fields">Real-time log configuration fields</a> in the <i>Amazon CloudFront Developer Guide</i>.</p>
        pub fn fields(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.fields.unwrap_or_default();
            v.push(input.into());
            self.fields = Some(v);
            self
        }
        /// <p>A list of fields to include in each real-time log record.</p>
        /// <p>For more information about fields, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/real-time-logs.html#understand-real-time-log-config-fields">Real-time log configuration fields</a> in the <i>Amazon CloudFront Developer Guide</i>.</p>
        pub fn set_fields(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.fields = input;
            self
        }
        /// <p>The name for this real-time log configuration.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name for this real-time log configuration.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) for this real-time log configuration.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) for this real-time log configuration.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The sampling rate for this real-time log configuration. The sampling rate determines the percentage of viewer requests that are represented in the real-time log data. You must provide an integer between 1 and 100, inclusive.</p>
        pub fn sampling_rate(mut self, input: i64) -> Self {
            self.sampling_rate = Some(input);
            self
        }
        /// <p>The sampling rate for this real-time log configuration. The sampling rate determines the percentage of viewer requests that are represented in the real-time log data. You must provide an integer between 1 and 100, inclusive.</p>
        pub fn set_sampling_rate(mut self, input: std::option::Option<i64>) -> Self {
            self.sampling_rate = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateRealtimeLogConfigInput`](crate::input::UpdateRealtimeLogConfigInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateRealtimeLogConfigInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateRealtimeLogConfigInput {
                end_points: self.end_points,
                fields: self.fields,
                name: self.name,
                arn: self.arn,
                sampling_rate: self.sampling_rate,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateRealtimeLogConfigInputOperationOutputAlias =
    crate::operation::UpdateRealtimeLogConfig;
#[doc(hidden)]
pub type UpdateRealtimeLogConfigInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdateRealtimeLogConfigInput {
    /// Consumes the builder and constructs an Operation<[`UpdateRealtimeLogConfig`](crate::operation::UpdateRealtimeLogConfig)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateRealtimeLogConfig,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::UpdateRealtimeLogConfigInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/2020-05-31/realtime-log-config")
                    .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::UpdateRealtimeLogConfigInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("PUT").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/xml",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_update_realtime_log_config(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateRealtimeLogConfig::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateRealtimeLogConfig",
            "cloudfront",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`UpdateRealtimeLogConfigInput`](crate::input::UpdateRealtimeLogConfigInput)
    pub fn builder() -> crate::input::update_realtime_log_config_input::Builder {
        crate::input::update_realtime_log_config_input::Builder::default()
    }
}

/// See [`UpdateResponseHeadersPolicyInput`](crate::input::UpdateResponseHeadersPolicyInput)
pub mod update_response_headers_policy_input {
    /// A builder for [`UpdateResponseHeadersPolicyInput`](crate::input::UpdateResponseHeadersPolicyInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) response_headers_policy_config:
            std::option::Option<crate::model::ResponseHeadersPolicyConfig>,
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) if_match: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A response headers policy configuration.</p>
        pub fn response_headers_policy_config(
            mut self,
            input: crate::model::ResponseHeadersPolicyConfig,
        ) -> Self {
            self.response_headers_policy_config = Some(input);
            self
        }
        /// <p>A response headers policy configuration.</p>
        pub fn set_response_headers_policy_config(
            mut self,
            input: std::option::Option<crate::model::ResponseHeadersPolicyConfig>,
        ) -> Self {
            self.response_headers_policy_config = input;
            self
        }
        /// <p>The identifier for the response headers policy that you are updating.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The identifier for the response headers policy that you are updating.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The version of the response headers policy that you are updating.</p>
        /// <p>The version is returned in the cache policy’s <code>ETag</code> field in the response to <code>GetResponseHeadersPolicyConfig</code>.</p>
        pub fn if_match(mut self, input: impl Into<std::string::String>) -> Self {
            self.if_match = Some(input.into());
            self
        }
        /// <p>The version of the response headers policy that you are updating.</p>
        /// <p>The version is returned in the cache policy’s <code>ETag</code> field in the response to <code>GetResponseHeadersPolicyConfig</code>.</p>
        pub fn set_if_match(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.if_match = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateResponseHeadersPolicyInput`](crate::input::UpdateResponseHeadersPolicyInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateResponseHeadersPolicyInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateResponseHeadersPolicyInput {
                response_headers_policy_config: self.response_headers_policy_config,
                id: self.id,
                if_match: self.if_match,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateResponseHeadersPolicyInputOperationOutputAlias =
    crate::operation::UpdateResponseHeadersPolicy;
#[doc(hidden)]
pub type UpdateResponseHeadersPolicyInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdateResponseHeadersPolicyInput {
    /// Consumes the builder and constructs an Operation<[`UpdateResponseHeadersPolicy`](crate::operation::UpdateResponseHeadersPolicy)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateResponseHeadersPolicy,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::UpdateResponseHeadersPolicyInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_108 = &_input.id;
                let input_108 = input_108.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let id = aws_smithy_http::label::fmt_string(input_108, false);
                if id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/2020-05-31/response-headers-policy/{Id}", Id = id)
                    .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::UpdateResponseHeadersPolicyInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                let builder =
                    crate::http_serde::add_headers_update_response_headers_policy(input, builder)?;
                Ok(builder.method("PUT").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/xml",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_payload_update_response_headers_policy_input(
                &self.response_headers_policy_config,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateResponseHeadersPolicy::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateResponseHeadersPolicy",
            "cloudfront",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`UpdateResponseHeadersPolicyInput`](crate::input::UpdateResponseHeadersPolicyInput)
    pub fn builder() -> crate::input::update_response_headers_policy_input::Builder {
        crate::input::update_response_headers_policy_input::Builder::default()
    }
}

/// See [`UpdateStreamingDistributionInput`](crate::input::UpdateStreamingDistributionInput)
pub mod update_streaming_distribution_input {
    /// A builder for [`UpdateStreamingDistributionInput`](crate::input::UpdateStreamingDistributionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) streaming_distribution_config:
            std::option::Option<crate::model::StreamingDistributionConfig>,
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) if_match: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The streaming distribution's configuration information.</p>
        pub fn streaming_distribution_config(
            mut self,
            input: crate::model::StreamingDistributionConfig,
        ) -> Self {
            self.streaming_distribution_config = Some(input);
            self
        }
        /// <p>The streaming distribution's configuration information.</p>
        pub fn set_streaming_distribution_config(
            mut self,
            input: std::option::Option<crate::model::StreamingDistributionConfig>,
        ) -> Self {
            self.streaming_distribution_config = input;
            self
        }
        /// <p>The streaming distribution's id.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The streaming distribution's id.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The value of the <code>ETag</code> header that you received when retrieving the streaming distribution's configuration. For example: <code>E2QWRUHAPOMQZL</code>.</p>
        pub fn if_match(mut self, input: impl Into<std::string::String>) -> Self {
            self.if_match = Some(input.into());
            self
        }
        /// <p>The value of the <code>ETag</code> header that you received when retrieving the streaming distribution's configuration. For example: <code>E2QWRUHAPOMQZL</code>.</p>
        pub fn set_if_match(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.if_match = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateStreamingDistributionInput`](crate::input::UpdateStreamingDistributionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateStreamingDistributionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateStreamingDistributionInput {
                streaming_distribution_config: self.streaming_distribution_config,
                id: self.id,
                if_match: self.if_match,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateStreamingDistributionInputOperationOutputAlias =
    crate::operation::UpdateStreamingDistribution;
#[doc(hidden)]
pub type UpdateStreamingDistributionInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdateStreamingDistributionInput {
    /// Consumes the builder and constructs an Operation<[`UpdateStreamingDistribution`](crate::operation::UpdateStreamingDistribution)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateStreamingDistribution,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::UpdateStreamingDistributionInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_109 = &_input.id;
                let input_109 = input_109.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let id = aws_smithy_http::label::fmt_string(input_109, false);
                if id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/2020-05-31/streaming-distribution/{Id}/config",
                    Id = id
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::UpdateStreamingDistributionInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                let builder =
                    crate::http_serde::add_headers_update_streaming_distribution(input, builder)?;
                Ok(builder.method("PUT").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/xml",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_payload_update_streaming_distribution_input(
                &self.streaming_distribution_config,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateStreamingDistribution::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateStreamingDistribution",
            "cloudfront",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`UpdateStreamingDistributionInput`](crate::input::UpdateStreamingDistributionInput)
    pub fn builder() -> crate::input::update_streaming_distribution_input::Builder {
        crate::input::update_streaming_distribution_input::Builder::default()
    }
}

/// <p>The request to update a streaming distribution.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateStreamingDistributionInput {
    /// <p>The streaming distribution's configuration information.</p>
    pub streaming_distribution_config:
        std::option::Option<crate::model::StreamingDistributionConfig>,
    /// <p>The streaming distribution's id.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The value of the <code>ETag</code> header that you received when retrieving the streaming distribution's configuration. For example: <code>E2QWRUHAPOMQZL</code>.</p>
    pub if_match: std::option::Option<std::string::String>,
}
impl UpdateStreamingDistributionInput {
    /// <p>The streaming distribution's configuration information.</p>
    pub fn streaming_distribution_config(
        &self,
    ) -> std::option::Option<&crate::model::StreamingDistributionConfig> {
        self.streaming_distribution_config.as_ref()
    }
    /// <p>The streaming distribution's id.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The value of the <code>ETag</code> header that you received when retrieving the streaming distribution's configuration. For example: <code>E2QWRUHAPOMQZL</code>.</p>
    pub fn if_match(&self) -> std::option::Option<&str> {
        self.if_match.as_deref()
    }
}
impl std::fmt::Debug for UpdateStreamingDistributionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateStreamingDistributionInput");
        formatter.field(
            "streaming_distribution_config",
            &self.streaming_distribution_config,
        );
        formatter.field("id", &self.id);
        formatter.field("if_match", &self.if_match);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateResponseHeadersPolicyInput {
    /// <p>A response headers policy configuration.</p>
    pub response_headers_policy_config:
        std::option::Option<crate::model::ResponseHeadersPolicyConfig>,
    /// <p>The identifier for the response headers policy that you are updating.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The version of the response headers policy that you are updating.</p>
    /// <p>The version is returned in the cache policy’s <code>ETag</code> field in the response to <code>GetResponseHeadersPolicyConfig</code>.</p>
    pub if_match: std::option::Option<std::string::String>,
}
impl UpdateResponseHeadersPolicyInput {
    /// <p>A response headers policy configuration.</p>
    pub fn response_headers_policy_config(
        &self,
    ) -> std::option::Option<&crate::model::ResponseHeadersPolicyConfig> {
        self.response_headers_policy_config.as_ref()
    }
    /// <p>The identifier for the response headers policy that you are updating.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The version of the response headers policy that you are updating.</p>
    /// <p>The version is returned in the cache policy’s <code>ETag</code> field in the response to <code>GetResponseHeadersPolicyConfig</code>.</p>
    pub fn if_match(&self) -> std::option::Option<&str> {
        self.if_match.as_deref()
    }
}
impl std::fmt::Debug for UpdateResponseHeadersPolicyInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateResponseHeadersPolicyInput");
        formatter.field(
            "response_headers_policy_config",
            &self.response_headers_policy_config,
        );
        formatter.field("id", &self.id);
        formatter.field("if_match", &self.if_match);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateRealtimeLogConfigInput {
    /// <p>Contains information about the Amazon Kinesis data stream where you are sending real-time log data.</p>
    pub end_points: std::option::Option<std::vec::Vec<crate::model::EndPoint>>,
    /// <p>A list of fields to include in each real-time log record.</p>
    /// <p>For more information about fields, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/real-time-logs.html#understand-real-time-log-config-fields">Real-time log configuration fields</a> in the <i>Amazon CloudFront Developer Guide</i>.</p>
    pub fields: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The name for this real-time log configuration.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) for this real-time log configuration.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The sampling rate for this real-time log configuration. The sampling rate determines the percentage of viewer requests that are represented in the real-time log data. You must provide an integer between 1 and 100, inclusive.</p>
    pub sampling_rate: std::option::Option<i64>,
}
impl UpdateRealtimeLogConfigInput {
    /// <p>Contains information about the Amazon Kinesis data stream where you are sending real-time log data.</p>
    pub fn end_points(&self) -> std::option::Option<&[crate::model::EndPoint]> {
        self.end_points.as_deref()
    }
    /// <p>A list of fields to include in each real-time log record.</p>
    /// <p>For more information about fields, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/real-time-logs.html#understand-real-time-log-config-fields">Real-time log configuration fields</a> in the <i>Amazon CloudFront Developer Guide</i>.</p>
    pub fn fields(&self) -> std::option::Option<&[std::string::String]> {
        self.fields.as_deref()
    }
    /// <p>The name for this real-time log configuration.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) for this real-time log configuration.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The sampling rate for this real-time log configuration. The sampling rate determines the percentage of viewer requests that are represented in the real-time log data. You must provide an integer between 1 and 100, inclusive.</p>
    pub fn sampling_rate(&self) -> std::option::Option<i64> {
        self.sampling_rate
    }
}
impl std::fmt::Debug for UpdateRealtimeLogConfigInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateRealtimeLogConfigInput");
        formatter.field("end_points", &self.end_points);
        formatter.field("fields", &self.fields);
        formatter.field("name", &self.name);
        formatter.field("arn", &self.arn);
        formatter.field("sampling_rate", &self.sampling_rate);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdatePublicKeyInput {
    /// <p>A public key configuration.</p>
    pub public_key_config: std::option::Option<crate::model::PublicKeyConfig>,
    /// <p>The identifier of the public key that you are updating.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The value of the <code>ETag</code> header that you received when retrieving the public key to update. For example: <code>E2QWRUHAPOMQZL</code>.</p>
    pub if_match: std::option::Option<std::string::String>,
}
impl UpdatePublicKeyInput {
    /// <p>A public key configuration.</p>
    pub fn public_key_config(&self) -> std::option::Option<&crate::model::PublicKeyConfig> {
        self.public_key_config.as_ref()
    }
    /// <p>The identifier of the public key that you are updating.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The value of the <code>ETag</code> header that you received when retrieving the public key to update. For example: <code>E2QWRUHAPOMQZL</code>.</p>
    pub fn if_match(&self) -> std::option::Option<&str> {
        self.if_match.as_deref()
    }
}
impl std::fmt::Debug for UpdatePublicKeyInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdatePublicKeyInput");
        formatter.field("public_key_config", &self.public_key_config);
        formatter.field("id", &self.id);
        formatter.field("if_match", &self.if_match);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateOriginRequestPolicyInput {
    /// <p>An origin request policy configuration.</p>
    pub origin_request_policy_config: std::option::Option<crate::model::OriginRequestPolicyConfig>,
    /// <p>The unique identifier for the origin request policy that you are updating. The identifier is returned in a cache behavior’s <code>OriginRequestPolicyId</code> field in the response to <code>GetDistributionConfig</code>.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The version of the origin request policy that you are updating. The version is returned in the origin request policy’s <code>ETag</code> field in the response to <code>GetOriginRequestPolicyConfig</code>.</p>
    pub if_match: std::option::Option<std::string::String>,
}
impl UpdateOriginRequestPolicyInput {
    /// <p>An origin request policy configuration.</p>
    pub fn origin_request_policy_config(
        &self,
    ) -> std::option::Option<&crate::model::OriginRequestPolicyConfig> {
        self.origin_request_policy_config.as_ref()
    }
    /// <p>The unique identifier for the origin request policy that you are updating. The identifier is returned in a cache behavior’s <code>OriginRequestPolicyId</code> field in the response to <code>GetDistributionConfig</code>.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The version of the origin request policy that you are updating. The version is returned in the origin request policy’s <code>ETag</code> field in the response to <code>GetOriginRequestPolicyConfig</code>.</p>
    pub fn if_match(&self) -> std::option::Option<&str> {
        self.if_match.as_deref()
    }
}
impl std::fmt::Debug for UpdateOriginRequestPolicyInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateOriginRequestPolicyInput");
        formatter.field(
            "origin_request_policy_config",
            &self.origin_request_policy_config,
        );
        formatter.field("id", &self.id);
        formatter.field("if_match", &self.if_match);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateKeyGroupInput {
    /// <p>The key group configuration.</p>
    pub key_group_config: std::option::Option<crate::model::KeyGroupConfig>,
    /// <p>The identifier of the key group that you are updating.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The version of the key group that you are updating. The version is the key group’s <code>ETag</code> value.</p>
    pub if_match: std::option::Option<std::string::String>,
}
impl UpdateKeyGroupInput {
    /// <p>The key group configuration.</p>
    pub fn key_group_config(&self) -> std::option::Option<&crate::model::KeyGroupConfig> {
        self.key_group_config.as_ref()
    }
    /// <p>The identifier of the key group that you are updating.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The version of the key group that you are updating. The version is the key group’s <code>ETag</code> value.</p>
    pub fn if_match(&self) -> std::option::Option<&str> {
        self.if_match.as_deref()
    }
}
impl std::fmt::Debug for UpdateKeyGroupInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateKeyGroupInput");
        formatter.field("key_group_config", &self.key_group_config);
        formatter.field("id", &self.id);
        formatter.field("if_match", &self.if_match);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateFunctionInput {
    /// <p>The name of the function that you are updating.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The current version (<code>ETag</code> value) of the function that you are updating, which you can get using <code>DescribeFunction</code>.</p>
    pub if_match: std::option::Option<std::string::String>,
    /// <p>Configuration information about the function.</p>
    pub function_config: std::option::Option<crate::model::FunctionConfig>,
    /// <p>The function code. For more information about writing a CloudFront function, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/writing-function-code.html">Writing function code for CloudFront Functions</a> in the <i>Amazon CloudFront Developer Guide</i>.</p>
    pub function_code: std::option::Option<aws_smithy_types::Blob>,
}
impl UpdateFunctionInput {
    /// <p>The name of the function that you are updating.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The current version (<code>ETag</code> value) of the function that you are updating, which you can get using <code>DescribeFunction</code>.</p>
    pub fn if_match(&self) -> std::option::Option<&str> {
        self.if_match.as_deref()
    }
    /// <p>Configuration information about the function.</p>
    pub fn function_config(&self) -> std::option::Option<&crate::model::FunctionConfig> {
        self.function_config.as_ref()
    }
    /// <p>The function code. For more information about writing a CloudFront function, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/writing-function-code.html">Writing function code for CloudFront Functions</a> in the <i>Amazon CloudFront Developer Guide</i>.</p>
    pub fn function_code(&self) -> std::option::Option<&aws_smithy_types::Blob> {
        self.function_code.as_ref()
    }
}
impl std::fmt::Debug for UpdateFunctionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateFunctionInput");
        formatter.field("name", &self.name);
        formatter.field("if_match", &self.if_match);
        formatter.field("function_config", &self.function_config);
        formatter.field("function_code", &"*** Sensitive Data Redacted ***");
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateFieldLevelEncryptionProfileInput {
    /// <p>Request to update a field-level encryption profile. </p>
    pub field_level_encryption_profile_config:
        std::option::Option<crate::model::FieldLevelEncryptionProfileConfig>,
    /// <p>The ID of the field-level encryption profile request. </p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The value of the <code>ETag</code> header that you received when retrieving the profile identity to update. For example: <code>E2QWRUHAPOMQZL</code>.</p>
    pub if_match: std::option::Option<std::string::String>,
}
impl UpdateFieldLevelEncryptionProfileInput {
    /// <p>Request to update a field-level encryption profile. </p>
    pub fn field_level_encryption_profile_config(
        &self,
    ) -> std::option::Option<&crate::model::FieldLevelEncryptionProfileConfig> {
        self.field_level_encryption_profile_config.as_ref()
    }
    /// <p>The ID of the field-level encryption profile request. </p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The value of the <code>ETag</code> header that you received when retrieving the profile identity to update. For example: <code>E2QWRUHAPOMQZL</code>.</p>
    pub fn if_match(&self) -> std::option::Option<&str> {
        self.if_match.as_deref()
    }
}
impl std::fmt::Debug for UpdateFieldLevelEncryptionProfileInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateFieldLevelEncryptionProfileInput");
        formatter.field(
            "field_level_encryption_profile_config",
            &self.field_level_encryption_profile_config,
        );
        formatter.field("id", &self.id);
        formatter.field("if_match", &self.if_match);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateFieldLevelEncryptionConfigInput {
    /// <p>Request to update a field-level encryption configuration. </p>
    pub field_level_encryption_config:
        std::option::Option<crate::model::FieldLevelEncryptionConfig>,
    /// <p>The ID of the configuration you want to update.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The value of the <code>ETag</code> header that you received when retrieving the configuration identity to update. For example: <code>E2QWRUHAPOMQZL</code>.</p>
    pub if_match: std::option::Option<std::string::String>,
}
impl UpdateFieldLevelEncryptionConfigInput {
    /// <p>Request to update a field-level encryption configuration. </p>
    pub fn field_level_encryption_config(
        &self,
    ) -> std::option::Option<&crate::model::FieldLevelEncryptionConfig> {
        self.field_level_encryption_config.as_ref()
    }
    /// <p>The ID of the configuration you want to update.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The value of the <code>ETag</code> header that you received when retrieving the configuration identity to update. For example: <code>E2QWRUHAPOMQZL</code>.</p>
    pub fn if_match(&self) -> std::option::Option<&str> {
        self.if_match.as_deref()
    }
}
impl std::fmt::Debug for UpdateFieldLevelEncryptionConfigInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateFieldLevelEncryptionConfigInput");
        formatter.field(
            "field_level_encryption_config",
            &self.field_level_encryption_config,
        );
        formatter.field("id", &self.id);
        formatter.field("if_match", &self.if_match);
        formatter.finish()
    }
}

/// <p>The request to update a distribution.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateDistributionInput {
    /// <p>The distribution's configuration information.</p>
    pub distribution_config: std::option::Option<crate::model::DistributionConfig>,
    /// <p>The distribution's id.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The value of the <code>ETag</code> header that you received when retrieving the distribution's configuration. For example: <code>E2QWRUHAPOMQZL</code>.</p>
    pub if_match: std::option::Option<std::string::String>,
}
impl UpdateDistributionInput {
    /// <p>The distribution's configuration information.</p>
    pub fn distribution_config(&self) -> std::option::Option<&crate::model::DistributionConfig> {
        self.distribution_config.as_ref()
    }
    /// <p>The distribution's id.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The value of the <code>ETag</code> header that you received when retrieving the distribution's configuration. For example: <code>E2QWRUHAPOMQZL</code>.</p>
    pub fn if_match(&self) -> std::option::Option<&str> {
        self.if_match.as_deref()
    }
}
impl std::fmt::Debug for UpdateDistributionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateDistributionInput");
        formatter.field("distribution_config", &self.distribution_config);
        formatter.field("id", &self.id);
        formatter.field("if_match", &self.if_match);
        formatter.finish()
    }
}

/// <p>The request to update an origin access identity.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateCloudFrontOriginAccessIdentityInput {
    /// <p>The identity's configuration information.</p>
    pub cloud_front_origin_access_identity_config:
        std::option::Option<crate::model::CloudFrontOriginAccessIdentityConfig>,
    /// <p>The identity's id.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The value of the <code>ETag</code> header that you received when retrieving the identity's configuration. For example: <code>E2QWRUHAPOMQZL</code>.</p>
    pub if_match: std::option::Option<std::string::String>,
}
impl UpdateCloudFrontOriginAccessIdentityInput {
    /// <p>The identity's configuration information.</p>
    pub fn cloud_front_origin_access_identity_config(
        &self,
    ) -> std::option::Option<&crate::model::CloudFrontOriginAccessIdentityConfig> {
        self.cloud_front_origin_access_identity_config.as_ref()
    }
    /// <p>The identity's id.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The value of the <code>ETag</code> header that you received when retrieving the identity's configuration. For example: <code>E2QWRUHAPOMQZL</code>.</p>
    pub fn if_match(&self) -> std::option::Option<&str> {
        self.if_match.as_deref()
    }
}
impl std::fmt::Debug for UpdateCloudFrontOriginAccessIdentityInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateCloudFrontOriginAccessIdentityInput");
        formatter.field(
            "cloud_front_origin_access_identity_config",
            &self.cloud_front_origin_access_identity_config,
        );
        formatter.field("id", &self.id);
        formatter.field("if_match", &self.if_match);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateCachePolicyInput {
    /// <p>A cache policy configuration.</p>
    pub cache_policy_config: std::option::Option<crate::model::CachePolicyConfig>,
    /// <p>The unique identifier for the cache policy that you are updating. The identifier is returned in a cache behavior’s <code>CachePolicyId</code> field in the response to <code>GetDistributionConfig</code>.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The version of the cache policy that you are updating. The version is returned in the cache policy’s <code>ETag</code> field in the response to <code>GetCachePolicyConfig</code>.</p>
    pub if_match: std::option::Option<std::string::String>,
}
impl UpdateCachePolicyInput {
    /// <p>A cache policy configuration.</p>
    pub fn cache_policy_config(&self) -> std::option::Option<&crate::model::CachePolicyConfig> {
        self.cache_policy_config.as_ref()
    }
    /// <p>The unique identifier for the cache policy that you are updating. The identifier is returned in a cache behavior’s <code>CachePolicyId</code> field in the response to <code>GetDistributionConfig</code>.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The version of the cache policy that you are updating. The version is returned in the cache policy’s <code>ETag</code> field in the response to <code>GetCachePolicyConfig</code>.</p>
    pub fn if_match(&self) -> std::option::Option<&str> {
        self.if_match.as_deref()
    }
}
impl std::fmt::Debug for UpdateCachePolicyInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateCachePolicyInput");
        formatter.field("cache_policy_config", &self.cache_policy_config);
        formatter.field("id", &self.id);
        formatter.field("if_match", &self.if_match);
        formatter.finish()
    }
}

/// <p> The request to remove tags from a CloudFront resource.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UntagResourceInput {
    /// <p> An ARN of a CloudFront resource.</p>
    pub resource: std::option::Option<std::string::String>,
    /// <p> A complex type that contains zero or more <code>Tag</code> key elements.</p>
    pub tag_keys: std::option::Option<crate::model::TagKeys>,
}
impl UntagResourceInput {
    /// <p> An ARN of a CloudFront resource.</p>
    pub fn resource(&self) -> std::option::Option<&str> {
        self.resource.as_deref()
    }
    /// <p> A complex type that contains zero or more <code>Tag</code> key elements.</p>
    pub fn tag_keys(&self) -> std::option::Option<&crate::model::TagKeys> {
        self.tag_keys.as_ref()
    }
}
impl std::fmt::Debug for UntagResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UntagResourceInput");
        formatter.field("resource", &self.resource);
        formatter.field("tag_keys", &self.tag_keys);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TestFunctionInput {
    /// <p>The name of the function that you are testing.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The current version (<code>ETag</code> value) of the function that you are testing, which you can get using <code>DescribeFunction</code>.</p>
    pub if_match: std::option::Option<std::string::String>,
    /// <p>The stage of the function that you are testing, either <code>DEVELOPMENT</code> or <code>LIVE</code>.</p>
    pub stage: std::option::Option<crate::model::FunctionStage>,
    /// <p>The event object to test the function with. For more information about the structure of the event object, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/managing-functions.html#test-function">Testing functions</a> in the <i>Amazon CloudFront Developer Guide</i>.</p>
    pub event_object: std::option::Option<aws_smithy_types::Blob>,
}
impl TestFunctionInput {
    /// <p>The name of the function that you are testing.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The current version (<code>ETag</code> value) of the function that you are testing, which you can get using <code>DescribeFunction</code>.</p>
    pub fn if_match(&self) -> std::option::Option<&str> {
        self.if_match.as_deref()
    }
    /// <p>The stage of the function that you are testing, either <code>DEVELOPMENT</code> or <code>LIVE</code>.</p>
    pub fn stage(&self) -> std::option::Option<&crate::model::FunctionStage> {
        self.stage.as_ref()
    }
    /// <p>The event object to test the function with. For more information about the structure of the event object, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/managing-functions.html#test-function">Testing functions</a> in the <i>Amazon CloudFront Developer Guide</i>.</p>
    pub fn event_object(&self) -> std::option::Option<&aws_smithy_types::Blob> {
        self.event_object.as_ref()
    }
}
impl std::fmt::Debug for TestFunctionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TestFunctionInput");
        formatter.field("name", &self.name);
        formatter.field("if_match", &self.if_match);
        formatter.field("stage", &self.stage);
        formatter.field("event_object", &"*** Sensitive Data Redacted ***");
        formatter.finish()
    }
}

/// <p> The request to add tags to a CloudFront resource.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TagResourceInput {
    /// <p> An ARN of a CloudFront resource.</p>
    pub resource: std::option::Option<std::string::String>,
    /// <p> A complex type that contains zero or more <code>Tag</code> elements.</p>
    pub tags: std::option::Option<crate::model::Tags>,
}
impl TagResourceInput {
    /// <p> An ARN of a CloudFront resource.</p>
    pub fn resource(&self) -> std::option::Option<&str> {
        self.resource.as_deref()
    }
    /// <p> A complex type that contains zero or more <code>Tag</code> elements.</p>
    pub fn tags(&self) -> std::option::Option<&crate::model::Tags> {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for TagResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TagResourceInput");
        formatter.field("resource", &self.resource);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PublishFunctionInput {
    /// <p>The name of the function that you are publishing.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The current version (<code>ETag</code> value) of the function that you are publishing, which you can get using <code>DescribeFunction</code>.</p>
    pub if_match: std::option::Option<std::string::String>,
}
impl PublishFunctionInput {
    /// <p>The name of the function that you are publishing.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The current version (<code>ETag</code> value) of the function that you are publishing, which you can get using <code>DescribeFunction</code>.</p>
    pub fn if_match(&self) -> std::option::Option<&str> {
        self.if_match.as_deref()
    }
}
impl std::fmt::Debug for PublishFunctionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PublishFunctionInput");
        formatter.field("name", &self.name);
        formatter.field("if_match", &self.if_match);
        formatter.finish()
    }
}

/// <p> The request to list tags for a CloudFront resource.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTagsForResourceInput {
    /// <p> An ARN of a CloudFront resource.</p>
    pub resource: std::option::Option<std::string::String>,
}
impl ListTagsForResourceInput {
    /// <p> An ARN of a CloudFront resource.</p>
    pub fn resource(&self) -> std::option::Option<&str> {
        self.resource.as_deref()
    }
}
impl std::fmt::Debug for ListTagsForResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTagsForResourceInput");
        formatter.field("resource", &self.resource);
        formatter.finish()
    }
}

/// <p>The request to list your streaming distributions. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListStreamingDistributionsInput {
    /// <p>The value that you provided for the <code>Marker</code> request parameter.</p>
    pub marker: std::option::Option<std::string::String>,
    /// <p>The value that you provided for the <code>MaxItems</code> request parameter.</p>
    pub max_items: std::option::Option<i32>,
}
impl ListStreamingDistributionsInput {
    /// <p>The value that you provided for the <code>Marker</code> request parameter.</p>
    pub fn marker(&self) -> std::option::Option<&str> {
        self.marker.as_deref()
    }
    /// <p>The value that you provided for the <code>MaxItems</code> request parameter.</p>
    pub fn max_items(&self) -> std::option::Option<i32> {
        self.max_items
    }
}
impl std::fmt::Debug for ListStreamingDistributionsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListStreamingDistributionsInput");
        formatter.field("marker", &self.marker);
        formatter.field("max_items", &self.max_items);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListResponseHeadersPoliciesInput {
    /// <p>A filter to get only the specified kind of response headers policies. Valid values are:</p>
    /// <ul>
    /// <li> <p> <code>managed</code> – Gets only the managed policies created by Amazon Web Services.</p> </li>
    /// <li> <p> <code>custom</code> – Gets only the custom policies created in your Amazon Web Services account.</p> </li>
    /// </ul>
    pub r#type: std::option::Option<crate::model::ResponseHeadersPolicyType>,
    /// <p>Use this field when paginating results to indicate where to begin in your list of response headers policies. The response includes response headers policies in the list that occur after the marker. To get the next page of the list, set this field’s value to the value of <code>NextMarker</code> from the current page’s response. </p>
    pub marker: std::option::Option<std::string::String>,
    /// <p>The maximum number of response headers policies that you want to get in the response.</p>
    pub max_items: std::option::Option<i32>,
}
impl ListResponseHeadersPoliciesInput {
    /// <p>A filter to get only the specified kind of response headers policies. Valid values are:</p>
    /// <ul>
    /// <li> <p> <code>managed</code> – Gets only the managed policies created by Amazon Web Services.</p> </li>
    /// <li> <p> <code>custom</code> – Gets only the custom policies created in your Amazon Web Services account.</p> </li>
    /// </ul>
    pub fn r#type(&self) -> std::option::Option<&crate::model::ResponseHeadersPolicyType> {
        self.r#type.as_ref()
    }
    /// <p>Use this field when paginating results to indicate where to begin in your list of response headers policies. The response includes response headers policies in the list that occur after the marker. To get the next page of the list, set this field’s value to the value of <code>NextMarker</code> from the current page’s response. </p>
    pub fn marker(&self) -> std::option::Option<&str> {
        self.marker.as_deref()
    }
    /// <p>The maximum number of response headers policies that you want to get in the response.</p>
    pub fn max_items(&self) -> std::option::Option<i32> {
        self.max_items
    }
}
impl std::fmt::Debug for ListResponseHeadersPoliciesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListResponseHeadersPoliciesInput");
        formatter.field("r#type", &self.r#type);
        formatter.field("marker", &self.marker);
        formatter.field("max_items", &self.max_items);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListRealtimeLogConfigsInput {
    /// <p>The maximum number of real-time log configurations that you want in the response.</p>
    pub max_items: std::option::Option<i32>,
    /// <p>Use this field when paginating results to indicate where to begin in your list of real-time log configurations. The response includes real-time log configurations in the list that occur after the marker. To get the next page of the list, set this field’s value to the value of <code>NextMarker</code> from the current page’s response.</p>
    pub marker: std::option::Option<std::string::String>,
}
impl ListRealtimeLogConfigsInput {
    /// <p>The maximum number of real-time log configurations that you want in the response.</p>
    pub fn max_items(&self) -> std::option::Option<i32> {
        self.max_items
    }
    /// <p>Use this field when paginating results to indicate where to begin in your list of real-time log configurations. The response includes real-time log configurations in the list that occur after the marker. To get the next page of the list, set this field’s value to the value of <code>NextMarker</code> from the current page’s response.</p>
    pub fn marker(&self) -> std::option::Option<&str> {
        self.marker.as_deref()
    }
}
impl std::fmt::Debug for ListRealtimeLogConfigsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListRealtimeLogConfigsInput");
        formatter.field("max_items", &self.max_items);
        formatter.field("marker", &self.marker);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListPublicKeysInput {
    /// <p>Use this when paginating results to indicate where to begin in your list of public keys. The results include public keys in the list that occur after the marker. To get the next page of results, set the <code>Marker</code> to the value of the <code>NextMarker</code> from the current page's response (which is also the ID of the last public key on that page). </p>
    pub marker: std::option::Option<std::string::String>,
    /// <p>The maximum number of public keys you want in the response body. </p>
    pub max_items: std::option::Option<i32>,
}
impl ListPublicKeysInput {
    /// <p>Use this when paginating results to indicate where to begin in your list of public keys. The results include public keys in the list that occur after the marker. To get the next page of results, set the <code>Marker</code> to the value of the <code>NextMarker</code> from the current page's response (which is also the ID of the last public key on that page). </p>
    pub fn marker(&self) -> std::option::Option<&str> {
        self.marker.as_deref()
    }
    /// <p>The maximum number of public keys you want in the response body. </p>
    pub fn max_items(&self) -> std::option::Option<i32> {
        self.max_items
    }
}
impl std::fmt::Debug for ListPublicKeysInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListPublicKeysInput");
        formatter.field("marker", &self.marker);
        formatter.field("max_items", &self.max_items);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListOriginRequestPoliciesInput {
    /// <p>A filter to return only the specified kinds of origin request policies. Valid values are:</p>
    /// <ul>
    /// <li> <p> <code>managed</code> – Returns only the managed policies created by Amazon Web Services.</p> </li>
    /// <li> <p> <code>custom</code> – Returns only the custom policies created in your Amazon Web Services account.</p> </li>
    /// </ul>
    pub r#type: std::option::Option<crate::model::OriginRequestPolicyType>,
    /// <p>Use this field when paginating results to indicate where to begin in your list of origin request policies. The response includes origin request policies in the list that occur after the marker. To get the next page of the list, set this field’s value to the value of <code>NextMarker</code> from the current page’s response.</p>
    pub marker: std::option::Option<std::string::String>,
    /// <p>The maximum number of origin request policies that you want in the response.</p>
    pub max_items: std::option::Option<i32>,
}
impl ListOriginRequestPoliciesInput {
    /// <p>A filter to return only the specified kinds of origin request policies. Valid values are:</p>
    /// <ul>
    /// <li> <p> <code>managed</code> – Returns only the managed policies created by Amazon Web Services.</p> </li>
    /// <li> <p> <code>custom</code> – Returns only the custom policies created in your Amazon Web Services account.</p> </li>
    /// </ul>
    pub fn r#type(&self) -> std::option::Option<&crate::model::OriginRequestPolicyType> {
        self.r#type.as_ref()
    }
    /// <p>Use this field when paginating results to indicate where to begin in your list of origin request policies. The response includes origin request policies in the list that occur after the marker. To get the next page of the list, set this field’s value to the value of <code>NextMarker</code> from the current page’s response.</p>
    pub fn marker(&self) -> std::option::Option<&str> {
        self.marker.as_deref()
    }
    /// <p>The maximum number of origin request policies that you want in the response.</p>
    pub fn max_items(&self) -> std::option::Option<i32> {
        self.max_items
    }
}
impl std::fmt::Debug for ListOriginRequestPoliciesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListOriginRequestPoliciesInput");
        formatter.field("r#type", &self.r#type);
        formatter.field("marker", &self.marker);
        formatter.field("max_items", &self.max_items);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListKeyGroupsInput {
    /// <p>Use this field when paginating results to indicate where to begin in your list of key groups. The response includes key groups in the list that occur after the marker. To get the next page of the list, set this field’s value to the value of <code>NextMarker</code> from the current page’s response.</p>
    pub marker: std::option::Option<std::string::String>,
    /// <p>The maximum number of key groups that you want in the response.</p>
    pub max_items: std::option::Option<i32>,
}
impl ListKeyGroupsInput {
    /// <p>Use this field when paginating results to indicate where to begin in your list of key groups. The response includes key groups in the list that occur after the marker. To get the next page of the list, set this field’s value to the value of <code>NextMarker</code> from the current page’s response.</p>
    pub fn marker(&self) -> std::option::Option<&str> {
        self.marker.as_deref()
    }
    /// <p>The maximum number of key groups that you want in the response.</p>
    pub fn max_items(&self) -> std::option::Option<i32> {
        self.max_items
    }
}
impl std::fmt::Debug for ListKeyGroupsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListKeyGroupsInput");
        formatter.field("marker", &self.marker);
        formatter.field("max_items", &self.max_items);
        formatter.finish()
    }
}

/// <p>The request to list invalidations. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListInvalidationsInput {
    /// <p>The distribution's ID.</p>
    pub distribution_id: std::option::Option<std::string::String>,
    /// <p>Use this parameter when paginating results to indicate where to begin in your list of invalidation batches. Because the results are returned in decreasing order from most recent to oldest, the most recent results are on the first page, the second page will contain earlier results, and so on. To get the next page of results, set <code>Marker</code> to the value of the <code>NextMarker</code> from the current page's response. This value is the same as the ID of the last invalidation batch on that page. </p>
    pub marker: std::option::Option<std::string::String>,
    /// <p>The maximum number of invalidation batches that you want in the response body.</p>
    pub max_items: std::option::Option<i32>,
}
impl ListInvalidationsInput {
    /// <p>The distribution's ID.</p>
    pub fn distribution_id(&self) -> std::option::Option<&str> {
        self.distribution_id.as_deref()
    }
    /// <p>Use this parameter when paginating results to indicate where to begin in your list of invalidation batches. Because the results are returned in decreasing order from most recent to oldest, the most recent results are on the first page, the second page will contain earlier results, and so on. To get the next page of results, set <code>Marker</code> to the value of the <code>NextMarker</code> from the current page's response. This value is the same as the ID of the last invalidation batch on that page. </p>
    pub fn marker(&self) -> std::option::Option<&str> {
        self.marker.as_deref()
    }
    /// <p>The maximum number of invalidation batches that you want in the response body.</p>
    pub fn max_items(&self) -> std::option::Option<i32> {
        self.max_items
    }
}
impl std::fmt::Debug for ListInvalidationsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListInvalidationsInput");
        formatter.field("distribution_id", &self.distribution_id);
        formatter.field("marker", &self.marker);
        formatter.field("max_items", &self.max_items);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListFunctionsInput {
    /// <p>Use this field when paginating results to indicate where to begin in your list of functions. The response includes functions in the list that occur after the marker. To get the next page of the list, set this field’s value to the value of <code>NextMarker</code> from the current page’s response.</p>
    pub marker: std::option::Option<std::string::String>,
    /// <p>The maximum number of functions that you want in the response.</p>
    pub max_items: std::option::Option<i32>,
    /// <p>An optional filter to return only the functions that are in the specified stage, either <code>DEVELOPMENT</code> or <code>LIVE</code>.</p>
    pub stage: std::option::Option<crate::model::FunctionStage>,
}
impl ListFunctionsInput {
    /// <p>Use this field when paginating results to indicate where to begin in your list of functions. The response includes functions in the list that occur after the marker. To get the next page of the list, set this field’s value to the value of <code>NextMarker</code> from the current page’s response.</p>
    pub fn marker(&self) -> std::option::Option<&str> {
        self.marker.as_deref()
    }
    /// <p>The maximum number of functions that you want in the response.</p>
    pub fn max_items(&self) -> std::option::Option<i32> {
        self.max_items
    }
    /// <p>An optional filter to return only the functions that are in the specified stage, either <code>DEVELOPMENT</code> or <code>LIVE</code>.</p>
    pub fn stage(&self) -> std::option::Option<&crate::model::FunctionStage> {
        self.stage.as_ref()
    }
}
impl std::fmt::Debug for ListFunctionsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListFunctionsInput");
        formatter.field("marker", &self.marker);
        formatter.field("max_items", &self.max_items);
        formatter.field("stage", &self.stage);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListFieldLevelEncryptionProfilesInput {
    /// <p>Use this when paginating results to indicate where to begin in your list of profiles. The results include profiles in the list that occur after the marker. To get the next page of results, set the <code>Marker</code> to the value of the <code>NextMarker</code> from the current page's response (which is also the ID of the last profile on that page). </p>
    pub marker: std::option::Option<std::string::String>,
    /// <p>The maximum number of field-level encryption profiles you want in the response body. </p>
    pub max_items: std::option::Option<i32>,
}
impl ListFieldLevelEncryptionProfilesInput {
    /// <p>Use this when paginating results to indicate where to begin in your list of profiles. The results include profiles in the list that occur after the marker. To get the next page of results, set the <code>Marker</code> to the value of the <code>NextMarker</code> from the current page's response (which is also the ID of the last profile on that page). </p>
    pub fn marker(&self) -> std::option::Option<&str> {
        self.marker.as_deref()
    }
    /// <p>The maximum number of field-level encryption profiles you want in the response body. </p>
    pub fn max_items(&self) -> std::option::Option<i32> {
        self.max_items
    }
}
impl std::fmt::Debug for ListFieldLevelEncryptionProfilesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListFieldLevelEncryptionProfilesInput");
        formatter.field("marker", &self.marker);
        formatter.field("max_items", &self.max_items);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListFieldLevelEncryptionConfigsInput {
    /// <p>Use this when paginating results to indicate where to begin in your list of configurations. The results include configurations in the list that occur after the marker. To get the next page of results, set the <code>Marker</code> to the value of the <code>NextMarker</code> from the current page's response (which is also the ID of the last configuration on that page). </p>
    pub marker: std::option::Option<std::string::String>,
    /// <p>The maximum number of field-level encryption configurations you want in the response body. </p>
    pub max_items: std::option::Option<i32>,
}
impl ListFieldLevelEncryptionConfigsInput {
    /// <p>Use this when paginating results to indicate where to begin in your list of configurations. The results include configurations in the list that occur after the marker. To get the next page of results, set the <code>Marker</code> to the value of the <code>NextMarker</code> from the current page's response (which is also the ID of the last configuration on that page). </p>
    pub fn marker(&self) -> std::option::Option<&str> {
        self.marker.as_deref()
    }
    /// <p>The maximum number of field-level encryption configurations you want in the response body. </p>
    pub fn max_items(&self) -> std::option::Option<i32> {
        self.max_items
    }
}
impl std::fmt::Debug for ListFieldLevelEncryptionConfigsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListFieldLevelEncryptionConfigsInput");
        formatter.field("marker", &self.marker);
        formatter.field("max_items", &self.max_items);
        formatter.finish()
    }
}

/// <p>The request to list distributions that are associated with a specified WAF web ACL.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListDistributionsByWebAclIdInput {
    /// <p>Use <code>Marker</code> and <code>MaxItems</code> to control pagination of results. If you have more than <code>MaxItems</code> distributions that satisfy the request, the response includes a <code>NextMarker</code> element. To get the next page of results, submit another request. For the value of <code>Marker</code>, specify the value of <code>NextMarker</code> from the last response. (For the first request, omit <code>Marker</code>.) </p>
    pub marker: std::option::Option<std::string::String>,
    /// <p>The maximum number of distributions that you want CloudFront to return in the response body. The maximum and default values are both 100.</p>
    pub max_items: std::option::Option<i32>,
    /// <p>The ID of the WAF web ACL that you want to list the associated distributions. If you specify "null" for the ID, the request returns a list of the distributions that aren't associated with a web ACL.</p>
    pub web_acl_id: std::option::Option<std::string::String>,
}
impl ListDistributionsByWebAclIdInput {
    /// <p>Use <code>Marker</code> and <code>MaxItems</code> to control pagination of results. If you have more than <code>MaxItems</code> distributions that satisfy the request, the response includes a <code>NextMarker</code> element. To get the next page of results, submit another request. For the value of <code>Marker</code>, specify the value of <code>NextMarker</code> from the last response. (For the first request, omit <code>Marker</code>.) </p>
    pub fn marker(&self) -> std::option::Option<&str> {
        self.marker.as_deref()
    }
    /// <p>The maximum number of distributions that you want CloudFront to return in the response body. The maximum and default values are both 100.</p>
    pub fn max_items(&self) -> std::option::Option<i32> {
        self.max_items
    }
    /// <p>The ID of the WAF web ACL that you want to list the associated distributions. If you specify "null" for the ID, the request returns a list of the distributions that aren't associated with a web ACL.</p>
    pub fn web_acl_id(&self) -> std::option::Option<&str> {
        self.web_acl_id.as_deref()
    }
}
impl std::fmt::Debug for ListDistributionsByWebAclIdInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListDistributionsByWebAclIdInput");
        formatter.field("marker", &self.marker);
        formatter.field("max_items", &self.max_items);
        formatter.field("web_acl_id", &self.web_acl_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListDistributionsByResponseHeadersPolicyIdInput {
    /// <p>Use this field when paginating results to indicate where to begin in your list of distribution IDs. The response includes distribution IDs in the list that occur after the marker. To get the next page of the list, set this field’s value to the value of <code>NextMarker</code> from the current page’s response.</p>
    pub marker: std::option::Option<std::string::String>,
    /// <p>The maximum number of distribution IDs that you want to get in the response.</p>
    pub max_items: std::option::Option<i32>,
    /// <p>The ID of the response headers policy whose associated distribution IDs you want to list.</p>
    pub response_headers_policy_id: std::option::Option<std::string::String>,
}
impl ListDistributionsByResponseHeadersPolicyIdInput {
    /// <p>Use this field when paginating results to indicate where to begin in your list of distribution IDs. The response includes distribution IDs in the list that occur after the marker. To get the next page of the list, set this field’s value to the value of <code>NextMarker</code> from the current page’s response.</p>
    pub fn marker(&self) -> std::option::Option<&str> {
        self.marker.as_deref()
    }
    /// <p>The maximum number of distribution IDs that you want to get in the response.</p>
    pub fn max_items(&self) -> std::option::Option<i32> {
        self.max_items
    }
    /// <p>The ID of the response headers policy whose associated distribution IDs you want to list.</p>
    pub fn response_headers_policy_id(&self) -> std::option::Option<&str> {
        self.response_headers_policy_id.as_deref()
    }
}
impl std::fmt::Debug for ListDistributionsByResponseHeadersPolicyIdInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListDistributionsByResponseHeadersPolicyIdInput");
        formatter.field("marker", &self.marker);
        formatter.field("max_items", &self.max_items);
        formatter.field(
            "response_headers_policy_id",
            &self.response_headers_policy_id,
        );
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListDistributionsByRealtimeLogConfigInput {
    /// <p>Use this field when paginating results to indicate where to begin in your list of distributions. The response includes distributions in the list that occur after the marker. To get the next page of the list, set this field’s value to the value of <code>NextMarker</code> from the current page’s response.</p>
    pub marker: std::option::Option<std::string::String>,
    /// <p>The maximum number of distributions that you want in the response.</p>
    pub max_items: std::option::Option<i32>,
    /// <p>The name of the real-time log configuration whose associated distributions you want to list.</p>
    pub realtime_log_config_name: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the real-time log configuration whose associated distributions you want to list.</p>
    pub realtime_log_config_arn: std::option::Option<std::string::String>,
}
impl ListDistributionsByRealtimeLogConfigInput {
    /// <p>Use this field when paginating results to indicate where to begin in your list of distributions. The response includes distributions in the list that occur after the marker. To get the next page of the list, set this field’s value to the value of <code>NextMarker</code> from the current page’s response.</p>
    pub fn marker(&self) -> std::option::Option<&str> {
        self.marker.as_deref()
    }
    /// <p>The maximum number of distributions that you want in the response.</p>
    pub fn max_items(&self) -> std::option::Option<i32> {
        self.max_items
    }
    /// <p>The name of the real-time log configuration whose associated distributions you want to list.</p>
    pub fn realtime_log_config_name(&self) -> std::option::Option<&str> {
        self.realtime_log_config_name.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the real-time log configuration whose associated distributions you want to list.</p>
    pub fn realtime_log_config_arn(&self) -> std::option::Option<&str> {
        self.realtime_log_config_arn.as_deref()
    }
}
impl std::fmt::Debug for ListDistributionsByRealtimeLogConfigInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListDistributionsByRealtimeLogConfigInput");
        formatter.field("marker", &self.marker);
        formatter.field("max_items", &self.max_items);
        formatter.field("realtime_log_config_name", &self.realtime_log_config_name);
        formatter.field("realtime_log_config_arn", &self.realtime_log_config_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListDistributionsByOriginRequestPolicyIdInput {
    /// <p>Use this field when paginating results to indicate where to begin in your list of distribution IDs. The response includes distribution IDs in the list that occur after the marker. To get the next page of the list, set this field’s value to the value of <code>NextMarker</code> from the current page’s response.</p>
    pub marker: std::option::Option<std::string::String>,
    /// <p>The maximum number of distribution IDs that you want in the response.</p>
    pub max_items: std::option::Option<i32>,
    /// <p>The ID of the origin request policy whose associated distribution IDs you want to list.</p>
    pub origin_request_policy_id: std::option::Option<std::string::String>,
}
impl ListDistributionsByOriginRequestPolicyIdInput {
    /// <p>Use this field when paginating results to indicate where to begin in your list of distribution IDs. The response includes distribution IDs in the list that occur after the marker. To get the next page of the list, set this field’s value to the value of <code>NextMarker</code> from the current page’s response.</p>
    pub fn marker(&self) -> std::option::Option<&str> {
        self.marker.as_deref()
    }
    /// <p>The maximum number of distribution IDs that you want in the response.</p>
    pub fn max_items(&self) -> std::option::Option<i32> {
        self.max_items
    }
    /// <p>The ID of the origin request policy whose associated distribution IDs you want to list.</p>
    pub fn origin_request_policy_id(&self) -> std::option::Option<&str> {
        self.origin_request_policy_id.as_deref()
    }
}
impl std::fmt::Debug for ListDistributionsByOriginRequestPolicyIdInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListDistributionsByOriginRequestPolicyIdInput");
        formatter.field("marker", &self.marker);
        formatter.field("max_items", &self.max_items);
        formatter.field("origin_request_policy_id", &self.origin_request_policy_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListDistributionsByKeyGroupInput {
    /// <p>Use this field when paginating results to indicate where to begin in your list of distribution IDs. The response includes distribution IDs in the list that occur after the marker. To get the next page of the list, set this field’s value to the value of <code>NextMarker</code> from the current page’s response.</p>
    pub marker: std::option::Option<std::string::String>,
    /// <p>The maximum number of distribution IDs that you want in the response.</p>
    pub max_items: std::option::Option<i32>,
    /// <p>The ID of the key group whose associated distribution IDs you are listing.</p>
    pub key_group_id: std::option::Option<std::string::String>,
}
impl ListDistributionsByKeyGroupInput {
    /// <p>Use this field when paginating results to indicate where to begin in your list of distribution IDs. The response includes distribution IDs in the list that occur after the marker. To get the next page of the list, set this field’s value to the value of <code>NextMarker</code> from the current page’s response.</p>
    pub fn marker(&self) -> std::option::Option<&str> {
        self.marker.as_deref()
    }
    /// <p>The maximum number of distribution IDs that you want in the response.</p>
    pub fn max_items(&self) -> std::option::Option<i32> {
        self.max_items
    }
    /// <p>The ID of the key group whose associated distribution IDs you are listing.</p>
    pub fn key_group_id(&self) -> std::option::Option<&str> {
        self.key_group_id.as_deref()
    }
}
impl std::fmt::Debug for ListDistributionsByKeyGroupInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListDistributionsByKeyGroupInput");
        formatter.field("marker", &self.marker);
        formatter.field("max_items", &self.max_items);
        formatter.field("key_group_id", &self.key_group_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListDistributionsByCachePolicyIdInput {
    /// <p>Use this field when paginating results to indicate where to begin in your list of distribution IDs. The response includes distribution IDs in the list that occur after the marker. To get the next page of the list, set this field’s value to the value of <code>NextMarker</code> from the current page’s response.</p>
    pub marker: std::option::Option<std::string::String>,
    /// <p>The maximum number of distribution IDs that you want in the response.</p>
    pub max_items: std::option::Option<i32>,
    /// <p>The ID of the cache policy whose associated distribution IDs you want to list.</p>
    pub cache_policy_id: std::option::Option<std::string::String>,
}
impl ListDistributionsByCachePolicyIdInput {
    /// <p>Use this field when paginating results to indicate where to begin in your list of distribution IDs. The response includes distribution IDs in the list that occur after the marker. To get the next page of the list, set this field’s value to the value of <code>NextMarker</code> from the current page’s response.</p>
    pub fn marker(&self) -> std::option::Option<&str> {
        self.marker.as_deref()
    }
    /// <p>The maximum number of distribution IDs that you want in the response.</p>
    pub fn max_items(&self) -> std::option::Option<i32> {
        self.max_items
    }
    /// <p>The ID of the cache policy whose associated distribution IDs you want to list.</p>
    pub fn cache_policy_id(&self) -> std::option::Option<&str> {
        self.cache_policy_id.as_deref()
    }
}
impl std::fmt::Debug for ListDistributionsByCachePolicyIdInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListDistributionsByCachePolicyIdInput");
        formatter.field("marker", &self.marker);
        formatter.field("max_items", &self.max_items);
        formatter.field("cache_policy_id", &self.cache_policy_id);
        formatter.finish()
    }
}

/// <p>The request to list your distributions. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListDistributionsInput {
    /// <p>Use this when paginating results to indicate where to begin in your list of distributions. The results include distributions in the list that occur after the marker. To get the next page of results, set the <code>Marker</code> to the value of the <code>NextMarker</code> from the current page's response (which is also the ID of the last distribution on that page).</p>
    pub marker: std::option::Option<std::string::String>,
    /// <p>The maximum number of distributions you want in the response body.</p>
    pub max_items: std::option::Option<i32>,
}
impl ListDistributionsInput {
    /// <p>Use this when paginating results to indicate where to begin in your list of distributions. The results include distributions in the list that occur after the marker. To get the next page of results, set the <code>Marker</code> to the value of the <code>NextMarker</code> from the current page's response (which is also the ID of the last distribution on that page).</p>
    pub fn marker(&self) -> std::option::Option<&str> {
        self.marker.as_deref()
    }
    /// <p>The maximum number of distributions you want in the response body.</p>
    pub fn max_items(&self) -> std::option::Option<i32> {
        self.max_items
    }
}
impl std::fmt::Debug for ListDistributionsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListDistributionsInput");
        formatter.field("marker", &self.marker);
        formatter.field("max_items", &self.max_items);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListConflictingAliasesInput {
    /// <p>The ID of a distribution in your account that has an attached SSL/TLS certificate that includes the provided alias.</p>
    pub distribution_id: std::option::Option<std::string::String>,
    /// <p>The alias (also called a CNAME) to search for conflicting aliases.</p>
    pub alias: std::option::Option<std::string::String>,
    /// <p>Use this field when paginating results to indicate where to begin in the list of conflicting aliases. The response includes conflicting aliases in the list that occur after the marker. To get the next page of the list, set this field’s value to the value of <code>NextMarker</code> from the current page’s response.</p>
    pub marker: std::option::Option<std::string::String>,
    /// <p>The maximum number of conflicting aliases that you want in the response.</p>
    pub max_items: std::option::Option<i32>,
}
impl ListConflictingAliasesInput {
    /// <p>The ID of a distribution in your account that has an attached SSL/TLS certificate that includes the provided alias.</p>
    pub fn distribution_id(&self) -> std::option::Option<&str> {
        self.distribution_id.as_deref()
    }
    /// <p>The alias (also called a CNAME) to search for conflicting aliases.</p>
    pub fn alias(&self) -> std::option::Option<&str> {
        self.alias.as_deref()
    }
    /// <p>Use this field when paginating results to indicate where to begin in the list of conflicting aliases. The response includes conflicting aliases in the list that occur after the marker. To get the next page of the list, set this field’s value to the value of <code>NextMarker</code> from the current page’s response.</p>
    pub fn marker(&self) -> std::option::Option<&str> {
        self.marker.as_deref()
    }
    /// <p>The maximum number of conflicting aliases that you want in the response.</p>
    pub fn max_items(&self) -> std::option::Option<i32> {
        self.max_items
    }
}
impl std::fmt::Debug for ListConflictingAliasesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListConflictingAliasesInput");
        formatter.field("distribution_id", &self.distribution_id);
        formatter.field("alias", &self.alias);
        formatter.field("marker", &self.marker);
        formatter.field("max_items", &self.max_items);
        formatter.finish()
    }
}

/// <p>The request to list origin access identities. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListCloudFrontOriginAccessIdentitiesInput {
    /// <p>Use this when paginating results to indicate where to begin in your list of origin access identities. The results include identities in the list that occur after the marker. To get the next page of results, set the <code>Marker</code> to the value of the <code>NextMarker</code> from the current page's response (which is also the ID of the last identity on that page).</p>
    pub marker: std::option::Option<std::string::String>,
    /// <p>The maximum number of origin access identities you want in the response body. </p>
    pub max_items: std::option::Option<i32>,
}
impl ListCloudFrontOriginAccessIdentitiesInput {
    /// <p>Use this when paginating results to indicate where to begin in your list of origin access identities. The results include identities in the list that occur after the marker. To get the next page of results, set the <code>Marker</code> to the value of the <code>NextMarker</code> from the current page's response (which is also the ID of the last identity on that page).</p>
    pub fn marker(&self) -> std::option::Option<&str> {
        self.marker.as_deref()
    }
    /// <p>The maximum number of origin access identities you want in the response body. </p>
    pub fn max_items(&self) -> std::option::Option<i32> {
        self.max_items
    }
}
impl std::fmt::Debug for ListCloudFrontOriginAccessIdentitiesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListCloudFrontOriginAccessIdentitiesInput");
        formatter.field("marker", &self.marker);
        formatter.field("max_items", &self.max_items);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListCachePoliciesInput {
    /// <p>A filter to return only the specified kinds of cache policies. Valid values are:</p>
    /// <ul>
    /// <li> <p> <code>managed</code> – Returns only the managed policies created by Amazon Web Services.</p> </li>
    /// <li> <p> <code>custom</code> – Returns only the custom policies created in your Amazon Web Services account.</p> </li>
    /// </ul>
    pub r#type: std::option::Option<crate::model::CachePolicyType>,
    /// <p>Use this field when paginating results to indicate where to begin in your list of cache policies. The response includes cache policies in the list that occur after the marker. To get the next page of the list, set this field’s value to the value of <code>NextMarker</code> from the current page’s response.</p>
    pub marker: std::option::Option<std::string::String>,
    /// <p>The maximum number of cache policies that you want in the response.</p>
    pub max_items: std::option::Option<i32>,
}
impl ListCachePoliciesInput {
    /// <p>A filter to return only the specified kinds of cache policies. Valid values are:</p>
    /// <ul>
    /// <li> <p> <code>managed</code> – Returns only the managed policies created by Amazon Web Services.</p> </li>
    /// <li> <p> <code>custom</code> – Returns only the custom policies created in your Amazon Web Services account.</p> </li>
    /// </ul>
    pub fn r#type(&self) -> std::option::Option<&crate::model::CachePolicyType> {
        self.r#type.as_ref()
    }
    /// <p>Use this field when paginating results to indicate where to begin in your list of cache policies. The response includes cache policies in the list that occur after the marker. To get the next page of the list, set this field’s value to the value of <code>NextMarker</code> from the current page’s response.</p>
    pub fn marker(&self) -> std::option::Option<&str> {
        self.marker.as_deref()
    }
    /// <p>The maximum number of cache policies that you want in the response.</p>
    pub fn max_items(&self) -> std::option::Option<i32> {
        self.max_items
    }
}
impl std::fmt::Debug for ListCachePoliciesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListCachePoliciesInput");
        formatter.field("r#type", &self.r#type);
        formatter.field("marker", &self.marker);
        formatter.field("max_items", &self.max_items);
        formatter.finish()
    }
}

/// <p>To request to get a streaming distribution configuration.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetStreamingDistributionConfigInput {
    /// <p>The streaming distribution's ID.</p>
    pub id: std::option::Option<std::string::String>,
}
impl GetStreamingDistributionConfigInput {
    /// <p>The streaming distribution's ID.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
}
impl std::fmt::Debug for GetStreamingDistributionConfigInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetStreamingDistributionConfigInput");
        formatter.field("id", &self.id);
        formatter.finish()
    }
}

/// <p>The request to get a streaming distribution's information.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetStreamingDistributionInput {
    /// <p>The streaming distribution's ID.</p>
    pub id: std::option::Option<std::string::String>,
}
impl GetStreamingDistributionInput {
    /// <p>The streaming distribution's ID.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
}
impl std::fmt::Debug for GetStreamingDistributionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetStreamingDistributionInput");
        formatter.field("id", &self.id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetResponseHeadersPolicyConfigInput {
    /// <p>The identifier for the response headers policy.</p>
    /// <p>If the response headers policy is attached to a distribution’s cache behavior, you can get the policy’s identifier using <code>ListDistributions</code> or <code>GetDistribution</code>. If the response headers policy is not attached to a cache behavior, you can get the identifier using <code>ListResponseHeadersPolicies</code>.</p>
    pub id: std::option::Option<std::string::String>,
}
impl GetResponseHeadersPolicyConfigInput {
    /// <p>The identifier for the response headers policy.</p>
    /// <p>If the response headers policy is attached to a distribution’s cache behavior, you can get the policy’s identifier using <code>ListDistributions</code> or <code>GetDistribution</code>. If the response headers policy is not attached to a cache behavior, you can get the identifier using <code>ListResponseHeadersPolicies</code>.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
}
impl std::fmt::Debug for GetResponseHeadersPolicyConfigInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetResponseHeadersPolicyConfigInput");
        formatter.field("id", &self.id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetResponseHeadersPolicyInput {
    /// <p>The identifier for the response headers policy.</p>
    /// <p>If the response headers policy is attached to a distribution’s cache behavior, you can get the policy’s identifier using <code>ListDistributions</code> or <code>GetDistribution</code>. If the response headers policy is not attached to a cache behavior, you can get the identifier using <code>ListResponseHeadersPolicies</code>.</p>
    pub id: std::option::Option<std::string::String>,
}
impl GetResponseHeadersPolicyInput {
    /// <p>The identifier for the response headers policy.</p>
    /// <p>If the response headers policy is attached to a distribution’s cache behavior, you can get the policy’s identifier using <code>ListDistributions</code> or <code>GetDistribution</code>. If the response headers policy is not attached to a cache behavior, you can get the identifier using <code>ListResponseHeadersPolicies</code>.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
}
impl std::fmt::Debug for GetResponseHeadersPolicyInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetResponseHeadersPolicyInput");
        formatter.field("id", &self.id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetRealtimeLogConfigInput {
    /// <p>The name of the real-time log configuration to get.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the real-time log configuration to get.</p>
    pub arn: std::option::Option<std::string::String>,
}
impl GetRealtimeLogConfigInput {
    /// <p>The name of the real-time log configuration to get.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the real-time log configuration to get.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
}
impl std::fmt::Debug for GetRealtimeLogConfigInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetRealtimeLogConfigInput");
        formatter.field("name", &self.name);
        formatter.field("arn", &self.arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetPublicKeyConfigInput {
    /// <p>The identifier of the public key whose configuration you are getting.</p>
    pub id: std::option::Option<std::string::String>,
}
impl GetPublicKeyConfigInput {
    /// <p>The identifier of the public key whose configuration you are getting.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
}
impl std::fmt::Debug for GetPublicKeyConfigInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetPublicKeyConfigInput");
        formatter.field("id", &self.id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetPublicKeyInput {
    /// <p>The identifier of the public key you are getting.</p>
    pub id: std::option::Option<std::string::String>,
}
impl GetPublicKeyInput {
    /// <p>The identifier of the public key you are getting.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
}
impl std::fmt::Debug for GetPublicKeyInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetPublicKeyInput");
        formatter.field("id", &self.id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetOriginRequestPolicyConfigInput {
    /// <p>The unique identifier for the origin request policy. If the origin request policy is attached to a distribution’s cache behavior, you can get the policy’s identifier using <code>ListDistributions</code> or <code>GetDistribution</code>. If the origin request policy is not attached to a cache behavior, you can get the identifier using <code>ListOriginRequestPolicies</code>.</p>
    pub id: std::option::Option<std::string::String>,
}
impl GetOriginRequestPolicyConfigInput {
    /// <p>The unique identifier for the origin request policy. If the origin request policy is attached to a distribution’s cache behavior, you can get the policy’s identifier using <code>ListDistributions</code> or <code>GetDistribution</code>. If the origin request policy is not attached to a cache behavior, you can get the identifier using <code>ListOriginRequestPolicies</code>.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
}
impl std::fmt::Debug for GetOriginRequestPolicyConfigInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetOriginRequestPolicyConfigInput");
        formatter.field("id", &self.id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetOriginRequestPolicyInput {
    /// <p>The unique identifier for the origin request policy. If the origin request policy is attached to a distribution’s cache behavior, you can get the policy’s identifier using <code>ListDistributions</code> or <code>GetDistribution</code>. If the origin request policy is not attached to a cache behavior, you can get the identifier using <code>ListOriginRequestPolicies</code>.</p>
    pub id: std::option::Option<std::string::String>,
}
impl GetOriginRequestPolicyInput {
    /// <p>The unique identifier for the origin request policy. If the origin request policy is attached to a distribution’s cache behavior, you can get the policy’s identifier using <code>ListDistributions</code> or <code>GetDistribution</code>. If the origin request policy is not attached to a cache behavior, you can get the identifier using <code>ListOriginRequestPolicies</code>.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
}
impl std::fmt::Debug for GetOriginRequestPolicyInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetOriginRequestPolicyInput");
        formatter.field("id", &self.id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetMonitoringSubscriptionInput {
    /// <p>The ID of the distribution that you are getting metrics information for.</p>
    pub distribution_id: std::option::Option<std::string::String>,
}
impl GetMonitoringSubscriptionInput {
    /// <p>The ID of the distribution that you are getting metrics information for.</p>
    pub fn distribution_id(&self) -> std::option::Option<&str> {
        self.distribution_id.as_deref()
    }
}
impl std::fmt::Debug for GetMonitoringSubscriptionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetMonitoringSubscriptionInput");
        formatter.field("distribution_id", &self.distribution_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetKeyGroupConfigInput {
    /// <p>The identifier of the key group whose configuration you are getting. To get the identifier, use <code>ListKeyGroups</code>.</p>
    pub id: std::option::Option<std::string::String>,
}
impl GetKeyGroupConfigInput {
    /// <p>The identifier of the key group whose configuration you are getting. To get the identifier, use <code>ListKeyGroups</code>.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
}
impl std::fmt::Debug for GetKeyGroupConfigInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetKeyGroupConfigInput");
        formatter.field("id", &self.id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetKeyGroupInput {
    /// <p>The identifier of the key group that you are getting. To get the identifier, use <code>ListKeyGroups</code>.</p>
    pub id: std::option::Option<std::string::String>,
}
impl GetKeyGroupInput {
    /// <p>The identifier of the key group that you are getting. To get the identifier, use <code>ListKeyGroups</code>.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
}
impl std::fmt::Debug for GetKeyGroupInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetKeyGroupInput");
        formatter.field("id", &self.id);
        formatter.finish()
    }
}

/// <p>The request to get an invalidation's information. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetInvalidationInput {
    /// <p>The distribution's ID.</p>
    pub distribution_id: std::option::Option<std::string::String>,
    /// <p>The identifier for the invalidation request, for example, <code>IDFDVBD632BHDS5</code>.</p>
    pub id: std::option::Option<std::string::String>,
}
impl GetInvalidationInput {
    /// <p>The distribution's ID.</p>
    pub fn distribution_id(&self) -> std::option::Option<&str> {
        self.distribution_id.as_deref()
    }
    /// <p>The identifier for the invalidation request, for example, <code>IDFDVBD632BHDS5</code>.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
}
impl std::fmt::Debug for GetInvalidationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetInvalidationInput");
        formatter.field("distribution_id", &self.distribution_id);
        formatter.field("id", &self.id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetFunctionInput {
    /// <p>The name of the function whose code you are getting.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The function’s stage, either <code>DEVELOPMENT</code> or <code>LIVE</code>.</p>
    pub stage: std::option::Option<crate::model::FunctionStage>,
}
impl GetFunctionInput {
    /// <p>The name of the function whose code you are getting.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The function’s stage, either <code>DEVELOPMENT</code> or <code>LIVE</code>.</p>
    pub fn stage(&self) -> std::option::Option<&crate::model::FunctionStage> {
        self.stage.as_ref()
    }
}
impl std::fmt::Debug for GetFunctionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetFunctionInput");
        formatter.field("name", &self.name);
        formatter.field("stage", &self.stage);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetFieldLevelEncryptionProfileConfigInput {
    /// <p>Get the ID for the field-level encryption profile configuration information.</p>
    pub id: std::option::Option<std::string::String>,
}
impl GetFieldLevelEncryptionProfileConfigInput {
    /// <p>Get the ID for the field-level encryption profile configuration information.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
}
impl std::fmt::Debug for GetFieldLevelEncryptionProfileConfigInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetFieldLevelEncryptionProfileConfigInput");
        formatter.field("id", &self.id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetFieldLevelEncryptionProfileInput {
    /// <p>Get the ID for the field-level encryption profile information.</p>
    pub id: std::option::Option<std::string::String>,
}
impl GetFieldLevelEncryptionProfileInput {
    /// <p>Get the ID for the field-level encryption profile information.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
}
impl std::fmt::Debug for GetFieldLevelEncryptionProfileInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetFieldLevelEncryptionProfileInput");
        formatter.field("id", &self.id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetFieldLevelEncryptionConfigInput {
    /// <p>Request the ID for the field-level encryption configuration information.</p>
    pub id: std::option::Option<std::string::String>,
}
impl GetFieldLevelEncryptionConfigInput {
    /// <p>Request the ID for the field-level encryption configuration information.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
}
impl std::fmt::Debug for GetFieldLevelEncryptionConfigInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetFieldLevelEncryptionConfigInput");
        formatter.field("id", &self.id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetFieldLevelEncryptionInput {
    /// <p>Request the ID for the field-level encryption configuration information.</p>
    pub id: std::option::Option<std::string::String>,
}
impl GetFieldLevelEncryptionInput {
    /// <p>Request the ID for the field-level encryption configuration information.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
}
impl std::fmt::Debug for GetFieldLevelEncryptionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetFieldLevelEncryptionInput");
        formatter.field("id", &self.id);
        formatter.finish()
    }
}

/// <p>The request to get a distribution configuration.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetDistributionConfigInput {
    /// <p>The distribution's ID. If the ID is empty, an empty distribution configuration is returned.</p>
    pub id: std::option::Option<std::string::String>,
}
impl GetDistributionConfigInput {
    /// <p>The distribution's ID. If the ID is empty, an empty distribution configuration is returned.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
}
impl std::fmt::Debug for GetDistributionConfigInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetDistributionConfigInput");
        formatter.field("id", &self.id);
        formatter.finish()
    }
}

/// <p>The request to get a distribution's information.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetDistributionInput {
    /// <p>The distribution's ID. If the ID is empty, an empty distribution configuration is returned.</p>
    pub id: std::option::Option<std::string::String>,
}
impl GetDistributionInput {
    /// <p>The distribution's ID. If the ID is empty, an empty distribution configuration is returned.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
}
impl std::fmt::Debug for GetDistributionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetDistributionInput");
        formatter.field("id", &self.id);
        formatter.finish()
    }
}

/// <p>The origin access identity's configuration information. For more information, see <a href="https://docs.aws.amazon.com/cloudfront/latest/APIReference/API_CloudFrontOriginAccessIdentityConfig.html">CloudFrontOriginAccessIdentityConfig</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetCloudFrontOriginAccessIdentityConfigInput {
    /// <p>The identity's ID. </p>
    pub id: std::option::Option<std::string::String>,
}
impl GetCloudFrontOriginAccessIdentityConfigInput {
    /// <p>The identity's ID. </p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
}
impl std::fmt::Debug for GetCloudFrontOriginAccessIdentityConfigInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetCloudFrontOriginAccessIdentityConfigInput");
        formatter.field("id", &self.id);
        formatter.finish()
    }
}

/// <p>The request to get an origin access identity's information.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetCloudFrontOriginAccessIdentityInput {
    /// <p>The identity's ID.</p>
    pub id: std::option::Option<std::string::String>,
}
impl GetCloudFrontOriginAccessIdentityInput {
    /// <p>The identity's ID.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
}
impl std::fmt::Debug for GetCloudFrontOriginAccessIdentityInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetCloudFrontOriginAccessIdentityInput");
        formatter.field("id", &self.id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetCachePolicyConfigInput {
    /// <p>The unique identifier for the cache policy. If the cache policy is attached to a distribution’s cache behavior, you can get the policy’s identifier using <code>ListDistributions</code> or <code>GetDistribution</code>. If the cache policy is not attached to a cache behavior, you can get the identifier using <code>ListCachePolicies</code>.</p>
    pub id: std::option::Option<std::string::String>,
}
impl GetCachePolicyConfigInput {
    /// <p>The unique identifier for the cache policy. If the cache policy is attached to a distribution’s cache behavior, you can get the policy’s identifier using <code>ListDistributions</code> or <code>GetDistribution</code>. If the cache policy is not attached to a cache behavior, you can get the identifier using <code>ListCachePolicies</code>.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
}
impl std::fmt::Debug for GetCachePolicyConfigInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetCachePolicyConfigInput");
        formatter.field("id", &self.id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetCachePolicyInput {
    /// <p>The unique identifier for the cache policy. If the cache policy is attached to a distribution’s cache behavior, you can get the policy’s identifier using <code>ListDistributions</code> or <code>GetDistribution</code>. If the cache policy is not attached to a cache behavior, you can get the identifier using <code>ListCachePolicies</code>.</p>
    pub id: std::option::Option<std::string::String>,
}
impl GetCachePolicyInput {
    /// <p>The unique identifier for the cache policy. If the cache policy is attached to a distribution’s cache behavior, you can get the policy’s identifier using <code>ListDistributions</code> or <code>GetDistribution</code>. If the cache policy is not attached to a cache behavior, you can get the identifier using <code>ListCachePolicies</code>.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
}
impl std::fmt::Debug for GetCachePolicyInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetCachePolicyInput");
        formatter.field("id", &self.id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeFunctionInput {
    /// <p>The name of the function that you are getting information about.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The function’s stage, either <code>DEVELOPMENT</code> or <code>LIVE</code>.</p>
    pub stage: std::option::Option<crate::model::FunctionStage>,
}
impl DescribeFunctionInput {
    /// <p>The name of the function that you are getting information about.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The function’s stage, either <code>DEVELOPMENT</code> or <code>LIVE</code>.</p>
    pub fn stage(&self) -> std::option::Option<&crate::model::FunctionStage> {
        self.stage.as_ref()
    }
}
impl std::fmt::Debug for DescribeFunctionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeFunctionInput");
        formatter.field("name", &self.name);
        formatter.field("stage", &self.stage);
        formatter.finish()
    }
}

/// <p>The request to delete a streaming distribution.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteStreamingDistributionInput {
    /// <p>The distribution ID. </p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The value of the <code>ETag</code> header that you received when you disabled the streaming distribution. For example: <code>E2QWRUHAPOMQZL</code>.</p>
    pub if_match: std::option::Option<std::string::String>,
}
impl DeleteStreamingDistributionInput {
    /// <p>The distribution ID. </p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The value of the <code>ETag</code> header that you received when you disabled the streaming distribution. For example: <code>E2QWRUHAPOMQZL</code>.</p>
    pub fn if_match(&self) -> std::option::Option<&str> {
        self.if_match.as_deref()
    }
}
impl std::fmt::Debug for DeleteStreamingDistributionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteStreamingDistributionInput");
        formatter.field("id", &self.id);
        formatter.field("if_match", &self.if_match);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteResponseHeadersPolicyInput {
    /// <p>The identifier for the response headers policy that you are deleting.</p>
    /// <p>To get the identifier, you can use <code>ListResponseHeadersPolicies</code>.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The version of the response headers policy that you are deleting.</p>
    /// <p>The version is the response headers policy’s <code>ETag</code> value, which you can get using <code>ListResponseHeadersPolicies</code>, <code>GetResponseHeadersPolicy</code>, or <code>GetResponseHeadersPolicyConfig</code>.</p>
    pub if_match: std::option::Option<std::string::String>,
}
impl DeleteResponseHeadersPolicyInput {
    /// <p>The identifier for the response headers policy that you are deleting.</p>
    /// <p>To get the identifier, you can use <code>ListResponseHeadersPolicies</code>.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The version of the response headers policy that you are deleting.</p>
    /// <p>The version is the response headers policy’s <code>ETag</code> value, which you can get using <code>ListResponseHeadersPolicies</code>, <code>GetResponseHeadersPolicy</code>, or <code>GetResponseHeadersPolicyConfig</code>.</p>
    pub fn if_match(&self) -> std::option::Option<&str> {
        self.if_match.as_deref()
    }
}
impl std::fmt::Debug for DeleteResponseHeadersPolicyInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteResponseHeadersPolicyInput");
        formatter.field("id", &self.id);
        formatter.field("if_match", &self.if_match);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteRealtimeLogConfigInput {
    /// <p>The name of the real-time log configuration to delete.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the real-time log configuration to delete.</p>
    pub arn: std::option::Option<std::string::String>,
}
impl DeleteRealtimeLogConfigInput {
    /// <p>The name of the real-time log configuration to delete.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the real-time log configuration to delete.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
}
impl std::fmt::Debug for DeleteRealtimeLogConfigInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteRealtimeLogConfigInput");
        formatter.field("name", &self.name);
        formatter.field("arn", &self.arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeletePublicKeyInput {
    /// <p>The ID of the public key you want to remove from CloudFront.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The value of the <code>ETag</code> header that you received when retrieving the public key identity to delete. For example: <code>E2QWRUHAPOMQZL</code>.</p>
    pub if_match: std::option::Option<std::string::String>,
}
impl DeletePublicKeyInput {
    /// <p>The ID of the public key you want to remove from CloudFront.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The value of the <code>ETag</code> header that you received when retrieving the public key identity to delete. For example: <code>E2QWRUHAPOMQZL</code>.</p>
    pub fn if_match(&self) -> std::option::Option<&str> {
        self.if_match.as_deref()
    }
}
impl std::fmt::Debug for DeletePublicKeyInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeletePublicKeyInput");
        formatter.field("id", &self.id);
        formatter.field("if_match", &self.if_match);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteOriginRequestPolicyInput {
    /// <p>The unique identifier for the origin request policy that you are deleting. To get the identifier, you can use <code>ListOriginRequestPolicies</code>.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The version of the origin request policy that you are deleting. The version is the origin request policy’s <code>ETag</code> value, which you can get using <code>ListOriginRequestPolicies</code>, <code>GetOriginRequestPolicy</code>, or <code>GetOriginRequestPolicyConfig</code>.</p>
    pub if_match: std::option::Option<std::string::String>,
}
impl DeleteOriginRequestPolicyInput {
    /// <p>The unique identifier for the origin request policy that you are deleting. To get the identifier, you can use <code>ListOriginRequestPolicies</code>.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The version of the origin request policy that you are deleting. The version is the origin request policy’s <code>ETag</code> value, which you can get using <code>ListOriginRequestPolicies</code>, <code>GetOriginRequestPolicy</code>, or <code>GetOriginRequestPolicyConfig</code>.</p>
    pub fn if_match(&self) -> std::option::Option<&str> {
        self.if_match.as_deref()
    }
}
impl std::fmt::Debug for DeleteOriginRequestPolicyInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteOriginRequestPolicyInput");
        formatter.field("id", &self.id);
        formatter.field("if_match", &self.if_match);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteMonitoringSubscriptionInput {
    /// <p>The ID of the distribution that you are disabling metrics for.</p>
    pub distribution_id: std::option::Option<std::string::String>,
}
impl DeleteMonitoringSubscriptionInput {
    /// <p>The ID of the distribution that you are disabling metrics for.</p>
    pub fn distribution_id(&self) -> std::option::Option<&str> {
        self.distribution_id.as_deref()
    }
}
impl std::fmt::Debug for DeleteMonitoringSubscriptionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteMonitoringSubscriptionInput");
        formatter.field("distribution_id", &self.distribution_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteKeyGroupInput {
    /// <p>The identifier of the key group that you are deleting. To get the identifier, use <code>ListKeyGroups</code>.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The version of the key group that you are deleting. The version is the key group’s <code>ETag</code> value. To get the <code>ETag</code>, use <code>GetKeyGroup</code> or <code>GetKeyGroupConfig</code>.</p>
    pub if_match: std::option::Option<std::string::String>,
}
impl DeleteKeyGroupInput {
    /// <p>The identifier of the key group that you are deleting. To get the identifier, use <code>ListKeyGroups</code>.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The version of the key group that you are deleting. The version is the key group’s <code>ETag</code> value. To get the <code>ETag</code>, use <code>GetKeyGroup</code> or <code>GetKeyGroupConfig</code>.</p>
    pub fn if_match(&self) -> std::option::Option<&str> {
        self.if_match.as_deref()
    }
}
impl std::fmt::Debug for DeleteKeyGroupInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteKeyGroupInput");
        formatter.field("id", &self.id);
        formatter.field("if_match", &self.if_match);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteFunctionInput {
    /// <p>The name of the function that you are deleting.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The current version (<code>ETag</code> value) of the function that you are deleting, which you can get using <code>DescribeFunction</code>.</p>
    pub if_match: std::option::Option<std::string::String>,
}
impl DeleteFunctionInput {
    /// <p>The name of the function that you are deleting.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The current version (<code>ETag</code> value) of the function that you are deleting, which you can get using <code>DescribeFunction</code>.</p>
    pub fn if_match(&self) -> std::option::Option<&str> {
        self.if_match.as_deref()
    }
}
impl std::fmt::Debug for DeleteFunctionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteFunctionInput");
        formatter.field("name", &self.name);
        formatter.field("if_match", &self.if_match);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteFieldLevelEncryptionProfileInput {
    /// <p>Request the ID of the profile you want to delete from CloudFront.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The value of the <code>ETag</code> header that you received when retrieving the profile to delete. For example: <code>E2QWRUHAPOMQZL</code>.</p>
    pub if_match: std::option::Option<std::string::String>,
}
impl DeleteFieldLevelEncryptionProfileInput {
    /// <p>Request the ID of the profile you want to delete from CloudFront.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The value of the <code>ETag</code> header that you received when retrieving the profile to delete. For example: <code>E2QWRUHAPOMQZL</code>.</p>
    pub fn if_match(&self) -> std::option::Option<&str> {
        self.if_match.as_deref()
    }
}
impl std::fmt::Debug for DeleteFieldLevelEncryptionProfileInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteFieldLevelEncryptionProfileInput");
        formatter.field("id", &self.id);
        formatter.field("if_match", &self.if_match);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteFieldLevelEncryptionConfigInput {
    /// <p>The ID of the configuration you want to delete from CloudFront.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The value of the <code>ETag</code> header that you received when retrieving the configuration identity to delete. For example: <code>E2QWRUHAPOMQZL</code>.</p>
    pub if_match: std::option::Option<std::string::String>,
}
impl DeleteFieldLevelEncryptionConfigInput {
    /// <p>The ID of the configuration you want to delete from CloudFront.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The value of the <code>ETag</code> header that you received when retrieving the configuration identity to delete. For example: <code>E2QWRUHAPOMQZL</code>.</p>
    pub fn if_match(&self) -> std::option::Option<&str> {
        self.if_match.as_deref()
    }
}
impl std::fmt::Debug for DeleteFieldLevelEncryptionConfigInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteFieldLevelEncryptionConfigInput");
        formatter.field("id", &self.id);
        formatter.field("if_match", &self.if_match);
        formatter.finish()
    }
}

/// <p>This action deletes a web distribution. To delete a web distribution using the CloudFront API, perform the following steps.</p>
/// <p> <b>To delete a web distribution using the CloudFront API:</b> </p>
/// <ol>
/// <li> <p>Disable the web distribution </p> </li>
/// <li> <p>Submit a <code>GET Distribution Config</code> request to get the current configuration and the <code>Etag</code> header for the distribution.</p> </li>
/// <li> <p>Update the XML document that was returned in the response to your <code>GET Distribution Config</code> request to change the value of <code>Enabled</code> to <code>false</code>.</p> </li>
/// <li> <p>Submit a <code>PUT Distribution Config</code> request to update the configuration for your distribution. In the request body, include the XML document that you updated in Step 3. Set the value of the HTTP <code>If-Match</code> header to the value of the <code>ETag</code> header that CloudFront returned when you submitted the <code>GET Distribution Config</code> request in Step 2.</p> </li>
/// <li> <p>Review the response to the <code>PUT Distribution Config</code> request to confirm that the distribution was successfully disabled.</p> </li>
/// <li> <p>Submit a <code>GET Distribution</code> request to confirm that your changes have propagated. When propagation is complete, the value of <code>Status</code> is <code>Deployed</code>.</p> </li>
/// <li> <p>Submit a <code>DELETE Distribution</code> request. Set the value of the HTTP <code>If-Match</code> header to the value of the <code>ETag</code> header that CloudFront returned when you submitted the <code>GET Distribution Config</code> request in Step 6.</p> </li>
/// <li> <p>Review the response to your <code>DELETE Distribution</code> request to confirm that the distribution was successfully deleted.</p> </li>
/// </ol>
/// <p>For information about deleting a distribution using the CloudFront console, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/HowToDeleteDistribution.html">Deleting a Distribution</a> in the <i>Amazon CloudFront Developer Guide</i>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteDistributionInput {
    /// <p>The distribution ID. </p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The value of the <code>ETag</code> header that you received when you disabled the distribution. For example: <code>E2QWRUHAPOMQZL</code>. </p>
    pub if_match: std::option::Option<std::string::String>,
}
impl DeleteDistributionInput {
    /// <p>The distribution ID. </p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The value of the <code>ETag</code> header that you received when you disabled the distribution. For example: <code>E2QWRUHAPOMQZL</code>. </p>
    pub fn if_match(&self) -> std::option::Option<&str> {
        self.if_match.as_deref()
    }
}
impl std::fmt::Debug for DeleteDistributionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteDistributionInput");
        formatter.field("id", &self.id);
        formatter.field("if_match", &self.if_match);
        formatter.finish()
    }
}

/// <p>Deletes a origin access identity.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteCloudFrontOriginAccessIdentityInput {
    /// <p>The origin access identity's ID.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The value of the <code>ETag</code> header you received from a previous <code>GET</code> or <code>PUT</code> request. For example: <code>E2QWRUHAPOMQZL</code>.</p>
    pub if_match: std::option::Option<std::string::String>,
}
impl DeleteCloudFrontOriginAccessIdentityInput {
    /// <p>The origin access identity's ID.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The value of the <code>ETag</code> header you received from a previous <code>GET</code> or <code>PUT</code> request. For example: <code>E2QWRUHAPOMQZL</code>.</p>
    pub fn if_match(&self) -> std::option::Option<&str> {
        self.if_match.as_deref()
    }
}
impl std::fmt::Debug for DeleteCloudFrontOriginAccessIdentityInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteCloudFrontOriginAccessIdentityInput");
        formatter.field("id", &self.id);
        formatter.field("if_match", &self.if_match);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteCachePolicyInput {
    /// <p>The unique identifier for the cache policy that you are deleting. To get the identifier, you can use <code>ListCachePolicies</code>.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The version of the cache policy that you are deleting. The version is the cache policy’s <code>ETag</code> value, which you can get using <code>ListCachePolicies</code>, <code>GetCachePolicy</code>, or <code>GetCachePolicyConfig</code>.</p>
    pub if_match: std::option::Option<std::string::String>,
}
impl DeleteCachePolicyInput {
    /// <p>The unique identifier for the cache policy that you are deleting. To get the identifier, you can use <code>ListCachePolicies</code>.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The version of the cache policy that you are deleting. The version is the cache policy’s <code>ETag</code> value, which you can get using <code>ListCachePolicies</code>, <code>GetCachePolicy</code>, or <code>GetCachePolicyConfig</code>.</p>
    pub fn if_match(&self) -> std::option::Option<&str> {
        self.if_match.as_deref()
    }
}
impl std::fmt::Debug for DeleteCachePolicyInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteCachePolicyInput");
        formatter.field("id", &self.id);
        formatter.field("if_match", &self.if_match);
        formatter.finish()
    }
}

/// <p>The request to create a new streaming distribution with tags.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateStreamingDistributionWithTagsInput {
    /// <p> The streaming distribution's configuration information. </p>
    pub streaming_distribution_config_with_tags:
        std::option::Option<crate::model::StreamingDistributionConfigWithTags>,
}
impl CreateStreamingDistributionWithTagsInput {
    /// <p> The streaming distribution's configuration information. </p>
    pub fn streaming_distribution_config_with_tags(
        &self,
    ) -> std::option::Option<&crate::model::StreamingDistributionConfigWithTags> {
        self.streaming_distribution_config_with_tags.as_ref()
    }
}
impl std::fmt::Debug for CreateStreamingDistributionWithTagsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateStreamingDistributionWithTagsInput");
        formatter.field(
            "streaming_distribution_config_with_tags",
            &self.streaming_distribution_config_with_tags,
        );
        formatter.finish()
    }
}

/// <p>The request to create a new streaming distribution.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateStreamingDistributionInput {
    /// <p>The streaming distribution's configuration information.</p>
    pub streaming_distribution_config:
        std::option::Option<crate::model::StreamingDistributionConfig>,
}
impl CreateStreamingDistributionInput {
    /// <p>The streaming distribution's configuration information.</p>
    pub fn streaming_distribution_config(
        &self,
    ) -> std::option::Option<&crate::model::StreamingDistributionConfig> {
        self.streaming_distribution_config.as_ref()
    }
}
impl std::fmt::Debug for CreateStreamingDistributionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateStreamingDistributionInput");
        formatter.field(
            "streaming_distribution_config",
            &self.streaming_distribution_config,
        );
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateResponseHeadersPolicyInput {
    /// <p>Contains metadata about the response headers policy, and a set of configurations that specify the response headers.</p>
    pub response_headers_policy_config:
        std::option::Option<crate::model::ResponseHeadersPolicyConfig>,
}
impl CreateResponseHeadersPolicyInput {
    /// <p>Contains metadata about the response headers policy, and a set of configurations that specify the response headers.</p>
    pub fn response_headers_policy_config(
        &self,
    ) -> std::option::Option<&crate::model::ResponseHeadersPolicyConfig> {
        self.response_headers_policy_config.as_ref()
    }
}
impl std::fmt::Debug for CreateResponseHeadersPolicyInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateResponseHeadersPolicyInput");
        formatter.field(
            "response_headers_policy_config",
            &self.response_headers_policy_config,
        );
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateRealtimeLogConfigInput {
    /// <p>Contains information about the Amazon Kinesis data stream where you are sending real-time log data.</p>
    pub end_points: std::option::Option<std::vec::Vec<crate::model::EndPoint>>,
    /// <p>A list of fields to include in each real-time log record.</p>
    /// <p>For more information about fields, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/real-time-logs.html#understand-real-time-log-config-fields">Real-time log configuration fields</a> in the <i>Amazon CloudFront Developer Guide</i>.</p>
    pub fields: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>A unique name to identify this real-time log configuration.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The sampling rate for this real-time log configuration. The sampling rate determines the percentage of viewer requests that are represented in the real-time log data. You must provide an integer between 1 and 100, inclusive.</p>
    pub sampling_rate: std::option::Option<i64>,
}
impl CreateRealtimeLogConfigInput {
    /// <p>Contains information about the Amazon Kinesis data stream where you are sending real-time log data.</p>
    pub fn end_points(&self) -> std::option::Option<&[crate::model::EndPoint]> {
        self.end_points.as_deref()
    }
    /// <p>A list of fields to include in each real-time log record.</p>
    /// <p>For more information about fields, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/real-time-logs.html#understand-real-time-log-config-fields">Real-time log configuration fields</a> in the <i>Amazon CloudFront Developer Guide</i>.</p>
    pub fn fields(&self) -> std::option::Option<&[std::string::String]> {
        self.fields.as_deref()
    }
    /// <p>A unique name to identify this real-time log configuration.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The sampling rate for this real-time log configuration. The sampling rate determines the percentage of viewer requests that are represented in the real-time log data. You must provide an integer between 1 and 100, inclusive.</p>
    pub fn sampling_rate(&self) -> std::option::Option<i64> {
        self.sampling_rate
    }
}
impl std::fmt::Debug for CreateRealtimeLogConfigInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateRealtimeLogConfigInput");
        formatter.field("end_points", &self.end_points);
        formatter.field("fields", &self.fields);
        formatter.field("name", &self.name);
        formatter.field("sampling_rate", &self.sampling_rate);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreatePublicKeyInput {
    /// <p>A CloudFront public key configuration.</p>
    pub public_key_config: std::option::Option<crate::model::PublicKeyConfig>,
}
impl CreatePublicKeyInput {
    /// <p>A CloudFront public key configuration.</p>
    pub fn public_key_config(&self) -> std::option::Option<&crate::model::PublicKeyConfig> {
        self.public_key_config.as_ref()
    }
}
impl std::fmt::Debug for CreatePublicKeyInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreatePublicKeyInput");
        formatter.field("public_key_config", &self.public_key_config);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateOriginRequestPolicyInput {
    /// <p>An origin request policy configuration.</p>
    pub origin_request_policy_config: std::option::Option<crate::model::OriginRequestPolicyConfig>,
}
impl CreateOriginRequestPolicyInput {
    /// <p>An origin request policy configuration.</p>
    pub fn origin_request_policy_config(
        &self,
    ) -> std::option::Option<&crate::model::OriginRequestPolicyConfig> {
        self.origin_request_policy_config.as_ref()
    }
}
impl std::fmt::Debug for CreateOriginRequestPolicyInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateOriginRequestPolicyInput");
        formatter.field(
            "origin_request_policy_config",
            &self.origin_request_policy_config,
        );
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateMonitoringSubscriptionInput {
    /// <p>The ID of the distribution that you are enabling metrics for.</p>
    pub distribution_id: std::option::Option<std::string::String>,
    /// <p>A monitoring subscription. This structure contains information about whether additional CloudWatch metrics are enabled for a given CloudFront distribution.</p>
    pub monitoring_subscription: std::option::Option<crate::model::MonitoringSubscription>,
}
impl CreateMonitoringSubscriptionInput {
    /// <p>The ID of the distribution that you are enabling metrics for.</p>
    pub fn distribution_id(&self) -> std::option::Option<&str> {
        self.distribution_id.as_deref()
    }
    /// <p>A monitoring subscription. This structure contains information about whether additional CloudWatch metrics are enabled for a given CloudFront distribution.</p>
    pub fn monitoring_subscription(
        &self,
    ) -> std::option::Option<&crate::model::MonitoringSubscription> {
        self.monitoring_subscription.as_ref()
    }
}
impl std::fmt::Debug for CreateMonitoringSubscriptionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateMonitoringSubscriptionInput");
        formatter.field("distribution_id", &self.distribution_id);
        formatter.field("monitoring_subscription", &self.monitoring_subscription);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateKeyGroupInput {
    /// <p>A key group configuration.</p>
    pub key_group_config: std::option::Option<crate::model::KeyGroupConfig>,
}
impl CreateKeyGroupInput {
    /// <p>A key group configuration.</p>
    pub fn key_group_config(&self) -> std::option::Option<&crate::model::KeyGroupConfig> {
        self.key_group_config.as_ref()
    }
}
impl std::fmt::Debug for CreateKeyGroupInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateKeyGroupInput");
        formatter.field("key_group_config", &self.key_group_config);
        formatter.finish()
    }
}

/// <p>The request to create an invalidation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateInvalidationInput {
    /// <p>The distribution's id.</p>
    pub distribution_id: std::option::Option<std::string::String>,
    /// <p>The batch information for the invalidation.</p>
    pub invalidation_batch: std::option::Option<crate::model::InvalidationBatch>,
}
impl CreateInvalidationInput {
    /// <p>The distribution's id.</p>
    pub fn distribution_id(&self) -> std::option::Option<&str> {
        self.distribution_id.as_deref()
    }
    /// <p>The batch information for the invalidation.</p>
    pub fn invalidation_batch(&self) -> std::option::Option<&crate::model::InvalidationBatch> {
        self.invalidation_batch.as_ref()
    }
}
impl std::fmt::Debug for CreateInvalidationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateInvalidationInput");
        formatter.field("distribution_id", &self.distribution_id);
        formatter.field("invalidation_batch", &self.invalidation_batch);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateFunctionInput {
    /// <p>A name to identify the function.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>Configuration information about the function, including an optional comment and the function’s runtime.</p>
    pub function_config: std::option::Option<crate::model::FunctionConfig>,
    /// <p>The function code. For more information about writing a CloudFront function, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/writing-function-code.html">Writing function code for CloudFront Functions</a> in the <i>Amazon CloudFront Developer Guide</i>.</p>
    pub function_code: std::option::Option<aws_smithy_types::Blob>,
}
impl CreateFunctionInput {
    /// <p>A name to identify the function.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>Configuration information about the function, including an optional comment and the function’s runtime.</p>
    pub fn function_config(&self) -> std::option::Option<&crate::model::FunctionConfig> {
        self.function_config.as_ref()
    }
    /// <p>The function code. For more information about writing a CloudFront function, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/writing-function-code.html">Writing function code for CloudFront Functions</a> in the <i>Amazon CloudFront Developer Guide</i>.</p>
    pub fn function_code(&self) -> std::option::Option<&aws_smithy_types::Blob> {
        self.function_code.as_ref()
    }
}
impl std::fmt::Debug for CreateFunctionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateFunctionInput");
        formatter.field("name", &self.name);
        formatter.field("function_config", &self.function_config);
        formatter.field("function_code", &"*** Sensitive Data Redacted ***");
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateFieldLevelEncryptionProfileInput {
    /// <p>The request to create a field-level encryption profile.</p>
    pub field_level_encryption_profile_config:
        std::option::Option<crate::model::FieldLevelEncryptionProfileConfig>,
}
impl CreateFieldLevelEncryptionProfileInput {
    /// <p>The request to create a field-level encryption profile.</p>
    pub fn field_level_encryption_profile_config(
        &self,
    ) -> std::option::Option<&crate::model::FieldLevelEncryptionProfileConfig> {
        self.field_level_encryption_profile_config.as_ref()
    }
}
impl std::fmt::Debug for CreateFieldLevelEncryptionProfileInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateFieldLevelEncryptionProfileInput");
        formatter.field(
            "field_level_encryption_profile_config",
            &self.field_level_encryption_profile_config,
        );
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateFieldLevelEncryptionConfigInput {
    /// <p>The request to create a new field-level encryption configuration.</p>
    pub field_level_encryption_config:
        std::option::Option<crate::model::FieldLevelEncryptionConfig>,
}
impl CreateFieldLevelEncryptionConfigInput {
    /// <p>The request to create a new field-level encryption configuration.</p>
    pub fn field_level_encryption_config(
        &self,
    ) -> std::option::Option<&crate::model::FieldLevelEncryptionConfig> {
        self.field_level_encryption_config.as_ref()
    }
}
impl std::fmt::Debug for CreateFieldLevelEncryptionConfigInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateFieldLevelEncryptionConfigInput");
        formatter.field(
            "field_level_encryption_config",
            &self.field_level_encryption_config,
        );
        formatter.finish()
    }
}

/// <p>The request to create a new distribution with tags. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateDistributionWithTagsInput {
    /// <p>The distribution's configuration information. </p>
    pub distribution_config_with_tags:
        std::option::Option<crate::model::DistributionConfigWithTags>,
}
impl CreateDistributionWithTagsInput {
    /// <p>The distribution's configuration information. </p>
    pub fn distribution_config_with_tags(
        &self,
    ) -> std::option::Option<&crate::model::DistributionConfigWithTags> {
        self.distribution_config_with_tags.as_ref()
    }
}
impl std::fmt::Debug for CreateDistributionWithTagsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateDistributionWithTagsInput");
        formatter.field(
            "distribution_config_with_tags",
            &self.distribution_config_with_tags,
        );
        formatter.finish()
    }
}

/// <p>The request to create a new distribution.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateDistributionInput {
    /// <p>The distribution's configuration information.</p>
    pub distribution_config: std::option::Option<crate::model::DistributionConfig>,
}
impl CreateDistributionInput {
    /// <p>The distribution's configuration information.</p>
    pub fn distribution_config(&self) -> std::option::Option<&crate::model::DistributionConfig> {
        self.distribution_config.as_ref()
    }
}
impl std::fmt::Debug for CreateDistributionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateDistributionInput");
        formatter.field("distribution_config", &self.distribution_config);
        formatter.finish()
    }
}

/// <p>The request to create a new origin access identity (OAI). An origin access identity is a special CloudFront user that you can associate with Amazon S3 origins, so that you can secure all or just some of your Amazon S3 content. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/private-content-restricting-access-to-s3.html"> Restricting Access to Amazon S3 Content by Using an Origin Access Identity</a> in the <i>Amazon CloudFront Developer Guide</i>. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateCloudFrontOriginAccessIdentityInput {
    /// <p>The current configuration information for the identity.</p>
    pub cloud_front_origin_access_identity_config:
        std::option::Option<crate::model::CloudFrontOriginAccessIdentityConfig>,
}
impl CreateCloudFrontOriginAccessIdentityInput {
    /// <p>The current configuration information for the identity.</p>
    pub fn cloud_front_origin_access_identity_config(
        &self,
    ) -> std::option::Option<&crate::model::CloudFrontOriginAccessIdentityConfig> {
        self.cloud_front_origin_access_identity_config.as_ref()
    }
}
impl std::fmt::Debug for CreateCloudFrontOriginAccessIdentityInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateCloudFrontOriginAccessIdentityInput");
        formatter.field(
            "cloud_front_origin_access_identity_config",
            &self.cloud_front_origin_access_identity_config,
        );
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateCachePolicyInput {
    /// <p>A cache policy configuration.</p>
    pub cache_policy_config: std::option::Option<crate::model::CachePolicyConfig>,
}
impl CreateCachePolicyInput {
    /// <p>A cache policy configuration.</p>
    pub fn cache_policy_config(&self) -> std::option::Option<&crate::model::CachePolicyConfig> {
        self.cache_policy_config.as_ref()
    }
}
impl std::fmt::Debug for CreateCachePolicyInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateCachePolicyInput");
        formatter.field("cache_policy_config", &self.cache_policy_config);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AssociateAliasInput {
    /// <p>The ID of the distribution that you’re associating the alias with.</p>
    pub target_distribution_id: std::option::Option<std::string::String>,
    /// <p>The alias (also known as a CNAME) to add to the target distribution.</p>
    pub alias: std::option::Option<std::string::String>,
}
impl AssociateAliasInput {
    /// <p>The ID of the distribution that you’re associating the alias with.</p>
    pub fn target_distribution_id(&self) -> std::option::Option<&str> {
        self.target_distribution_id.as_deref()
    }
    /// <p>The alias (also known as a CNAME) to add to the target distribution.</p>
    pub fn alias(&self) -> std::option::Option<&str> {
        self.alias.as_deref()
    }
}
impl std::fmt::Debug for AssociateAliasInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AssociateAliasInput");
        formatter.field("target_distribution_id", &self.target_distribution_id);
        formatter.field("alias", &self.alias);
        formatter.finish()
    }
}
