// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(clippy::unnecessary_wraps)]
pub fn parse_associate_alias_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::AssociateAliasOutput, crate::error::AssociateAliasError> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::AssociateAliasError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::AssociateAliasError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDenied" => crate::error::AssociateAliasError {
            meta: generic,
            kind: crate::error::AssociateAliasErrorKind::AccessDenied({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_access_denied_xml_err(
                        response.body().as_ref(),
                        output,
                    )
                    .map_err(crate::error::AssociateAliasError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "IllegalUpdate" => crate::error::AssociateAliasError {
            meta: generic,
            kind: crate::error::AssociateAliasErrorKind::IllegalUpdate({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::illegal_update::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_illegal_update_xml_err(
                        response.body().as_ref(),
                        output,
                    )
                    .map_err(crate::error::AssociateAliasError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidArgument" => crate::error::AssociateAliasError {
            meta: generic,
            kind: crate::error::AssociateAliasErrorKind::InvalidArgument({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_argument::Builder::default();
                    let _ = response;
                    output =
                        crate::xml_deser::deser_structure_crate_error_invalid_argument_xml_err(
                            response.body().as_ref(),
                            output,
                        )
                        .map_err(crate::error::AssociateAliasError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NoSuchDistribution" => {
            crate::error::AssociateAliasError {
                meta: generic,
                kind: crate::error::AssociateAliasErrorKind::NoSuchDistribution({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::no_such_distribution::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_no_such_distribution_xml_err(response.body().as_ref(), output).map_err(crate::error::AssociateAliasError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "TooManyDistributionCNAMEs" => crate::error::AssociateAliasError {
            meta: generic,
            kind: crate::error::AssociateAliasErrorKind::TooManyDistributionCnamEs({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::too_many_distribution_cnam_es::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_too_many_distribution_cnam_es_xml_err(response.body().as_ref(), output).map_err(crate::error::AssociateAliasError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::AssociateAliasError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_associate_alias_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::AssociateAliasOutput, crate::error::AssociateAliasError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::associate_alias_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_cache_policy_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateCachePolicyOutput, crate::error::CreateCachePolicyError>
{
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateCachePolicyError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::CreateCachePolicyError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDenied" => crate::error::CreateCachePolicyError {
            meta: generic,
            kind: crate::error::CreateCachePolicyErrorKind::AccessDenied({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_access_denied_xml_err(
                        response.body().as_ref(),
                        output,
                    )
                    .map_err(crate::error::CreateCachePolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "CachePolicyAlreadyExists" => crate::error::CreateCachePolicyError {
            meta: generic,
            kind: crate::error::CreateCachePolicyErrorKind::CachePolicyAlreadyExists({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::cache_policy_already_exists::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_cache_policy_already_exists_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateCachePolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InconsistentQuantities" => crate::error::CreateCachePolicyError {
            meta: generic,
            kind: crate::error::CreateCachePolicyErrorKind::InconsistentQuantities({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::inconsistent_quantities::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_inconsistent_quantities_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateCachePolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidArgument" => crate::error::CreateCachePolicyError {
            meta: generic,
            kind: crate::error::CreateCachePolicyErrorKind::InvalidArgument({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_argument::Builder::default();
                    let _ = response;
                    output =
                        crate::xml_deser::deser_structure_crate_error_invalid_argument_xml_err(
                            response.body().as_ref(),
                            output,
                        )
                        .map_err(crate::error::CreateCachePolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TooManyCachePolicies" => crate::error::CreateCachePolicyError {
            meta: generic,
            kind: crate::error::CreateCachePolicyErrorKind::TooManyCachePolicies({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_cache_policies::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_too_many_cache_policies_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateCachePolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TooManyCookiesInCachePolicy" => crate::error::CreateCachePolicyError {
            meta: generic,
            kind: crate::error::CreateCachePolicyErrorKind::TooManyCookiesInCachePolicy({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::too_many_cookies_in_cache_policy::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_too_many_cookies_in_cache_policy_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateCachePolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TooManyHeadersInCachePolicy" => crate::error::CreateCachePolicyError {
            meta: generic,
            kind: crate::error::CreateCachePolicyErrorKind::TooManyHeadersInCachePolicy({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::too_many_headers_in_cache_policy::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_too_many_headers_in_cache_policy_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateCachePolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TooManyQueryStringsInCachePolicy" => crate::error::CreateCachePolicyError {
            meta: generic,
            kind: crate::error::CreateCachePolicyErrorKind::TooManyQueryStringsInCachePolicy({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::too_many_query_strings_in_cache_policy::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_too_many_query_strings_in_cache_policy_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateCachePolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CreateCachePolicyError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_cache_policy_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateCachePolicyOutput, crate::error::CreateCachePolicyError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_cache_policy_output::Builder::default();
        let _ = response;
        output = output.set_cache_policy(
            crate::http_serde::deser_payload_create_cache_policy_create_cache_policy_output_cache_policy(response.body().as_ref())?
        );
        output = output.set_e_tag(
            crate::http_serde::deser_header_create_cache_policy_create_cache_policy_output_e_tag(
                response.headers(),
            )
            .map_err(|_| {
                crate::error::CreateCachePolicyError::unhandled(
                    "Failed to parse ETag from header `ETag",
                )
            })?,
        );
        output = output.set_location(
            crate::http_serde::deser_header_create_cache_policy_create_cache_policy_output_location(response.headers())
                                    .map_err(|_|crate::error::CreateCachePolicyError::unhandled("Failed to parse Location from header `Location"))?
        );
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_cloud_front_origin_access_identity_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateCloudFrontOriginAccessIdentityOutput,
    crate::error::CreateCloudFrontOriginAccessIdentityError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateCloudFrontOriginAccessIdentityError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::CreateCloudFrontOriginAccessIdentityError::unhandled(generic))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "CloudFrontOriginAccessIdentityAlreadyExists" => crate::error::CreateCloudFrontOriginAccessIdentityError { meta: generic, kind: crate::error::CreateCloudFrontOriginAccessIdentityErrorKind::CloudFrontOriginAccessIdentityAlreadyExists({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::cloud_front_origin_access_identity_already_exists::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_cloud_front_origin_access_identity_already_exists_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateCloudFrontOriginAccessIdentityError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InconsistentQuantities" => crate::error::CreateCloudFrontOriginAccessIdentityError { meta: generic, kind: crate::error::CreateCloudFrontOriginAccessIdentityErrorKind::InconsistentQuantities({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::inconsistent_quantities::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_inconsistent_quantities_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateCloudFrontOriginAccessIdentityError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidArgument" => crate::error::CreateCloudFrontOriginAccessIdentityError { meta: generic, kind: crate::error::CreateCloudFrontOriginAccessIdentityErrorKind::InvalidArgument({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_argument::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_argument_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateCloudFrontOriginAccessIdentityError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "MissingBody" => crate::error::CreateCloudFrontOriginAccessIdentityError { meta: generic, kind: crate::error::CreateCloudFrontOriginAccessIdentityErrorKind::MissingBody({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::missing_body::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_missing_body_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateCloudFrontOriginAccessIdentityError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "TooManyCloudFrontOriginAccessIdentities" => crate::error::CreateCloudFrontOriginAccessIdentityError { meta: generic, kind: crate::error::CreateCloudFrontOriginAccessIdentityErrorKind::TooManyCloudFrontOriginAccessIdentities({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::too_many_cloud_front_origin_access_identities::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_too_many_cloud_front_origin_access_identities_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateCloudFrontOriginAccessIdentityError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::CreateCloudFrontOriginAccessIdentityError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_cloud_front_origin_access_identity_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateCloudFrontOriginAccessIdentityOutput,
    crate::error::CreateCloudFrontOriginAccessIdentityError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::create_cloud_front_origin_access_identity_output::Builder::default();
        let _ = response;
        output = output.set_cloud_front_origin_access_identity(
            crate::http_serde::deser_payload_create_cloud_front_origin_access_identity_create_cloud_front_origin_access_identity_output_cloud_front_origin_access_identity(response.body().as_ref())?
        );
        output = output.set_e_tag(
            crate::http_serde::deser_header_create_cloud_front_origin_access_identity_create_cloud_front_origin_access_identity_output_e_tag(response.headers())
                                    .map_err(|_|crate::error::CreateCloudFrontOriginAccessIdentityError::unhandled("Failed to parse ETag from header `ETag"))?
        );
        output = output.set_location(
            crate::http_serde::deser_header_create_cloud_front_origin_access_identity_create_cloud_front_origin_access_identity_output_location(response.headers())
                                    .map_err(|_|crate::error::CreateCloudFrontOriginAccessIdentityError::unhandled("Failed to parse Location from header `Location"))?
        );
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_distribution_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateDistributionOutput,
    crate::error::CreateDistributionError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateDistributionError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::CreateDistributionError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDenied" => crate::error::CreateDistributionError { meta: generic, kind: crate::error::CreateDistributionErrorKind::AccessDenied({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::access_denied::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_access_denied_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateDistributionError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "CNAMEAlreadyExists" => crate::error::CreateDistributionError { meta: generic, kind: crate::error::CreateDistributionErrorKind::CnameAlreadyExists({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::cname_already_exists::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_cname_already_exists_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateDistributionError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "DistributionAlreadyExists" => crate::error::CreateDistributionError { meta: generic, kind: crate::error::CreateDistributionErrorKind::DistributionAlreadyExists({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::distribution_already_exists::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_distribution_already_exists_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateDistributionError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "IllegalFieldLevelEncryptionConfigAssociationWithCacheBehavior" => crate::error::CreateDistributionError { meta: generic, kind: crate::error::CreateDistributionErrorKind::IllegalFieldLevelEncryptionConfigAssociationWithCacheBehavior({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::illegal_field_level_encryption_config_association_with_cache_behavior::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_illegal_field_level_encryption_config_association_with_cache_behavior_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateDistributionError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InconsistentQuantities" => crate::error::CreateDistributionError { meta: generic, kind: crate::error::CreateDistributionErrorKind::InconsistentQuantities({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::inconsistent_quantities::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_inconsistent_quantities_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateDistributionError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidArgument" => crate::error::CreateDistributionError { meta: generic, kind: crate::error::CreateDistributionErrorKind::InvalidArgument({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_argument::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_argument_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateDistributionError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidDefaultRootObject" => crate::error::CreateDistributionError { meta: generic, kind: crate::error::CreateDistributionErrorKind::InvalidDefaultRootObject({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_default_root_object::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_default_root_object_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateDistributionError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidErrorCode" => crate::error::CreateDistributionError { meta: generic, kind: crate::error::CreateDistributionErrorKind::InvalidErrorCode({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_error_code::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_error_code_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateDistributionError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidForwardCookies" => crate::error::CreateDistributionError { meta: generic, kind: crate::error::CreateDistributionErrorKind::InvalidForwardCookies({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_forward_cookies::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_forward_cookies_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateDistributionError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidFunctionAssociation" => crate::error::CreateDistributionError { meta: generic, kind: crate::error::CreateDistributionErrorKind::InvalidFunctionAssociation({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_function_association::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_function_association_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateDistributionError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidGeoRestrictionParameter" => crate::error::CreateDistributionError { meta: generic, kind: crate::error::CreateDistributionErrorKind::InvalidGeoRestrictionParameter({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_geo_restriction_parameter::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_geo_restriction_parameter_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateDistributionError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidHeadersForS3Origin" => crate::error::CreateDistributionError { meta: generic, kind: crate::error::CreateDistributionErrorKind::InvalidHeadersForS3Origin({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_headers_for_s3_origin::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_headers_for_s3_origin_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateDistributionError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidLambdaFunctionAssociation" => crate::error::CreateDistributionError { meta: generic, kind: crate::error::CreateDistributionErrorKind::InvalidLambdaFunctionAssociation({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_lambda_function_association::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_lambda_function_association_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateDistributionError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidLocationCode" => crate::error::CreateDistributionError { meta: generic, kind: crate::error::CreateDistributionErrorKind::InvalidLocationCode({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_location_code::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_location_code_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateDistributionError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidMinimumProtocolVersion" => crate::error::CreateDistributionError { meta: generic, kind: crate::error::CreateDistributionErrorKind::InvalidMinimumProtocolVersion({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_minimum_protocol_version::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_minimum_protocol_version_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateDistributionError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidOrigin" => crate::error::CreateDistributionError { meta: generic, kind: crate::error::CreateDistributionErrorKind::InvalidOrigin({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_origin::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_origin_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateDistributionError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidOriginAccessIdentity" => crate::error::CreateDistributionError { meta: generic, kind: crate::error::CreateDistributionErrorKind::InvalidOriginAccessIdentity({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_origin_access_identity::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_origin_access_identity_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateDistributionError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidOriginKeepaliveTimeout" => crate::error::CreateDistributionError { meta: generic, kind: crate::error::CreateDistributionErrorKind::InvalidOriginKeepaliveTimeout({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_origin_keepalive_timeout::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_origin_keepalive_timeout_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateDistributionError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidOriginReadTimeout" => crate::error::CreateDistributionError { meta: generic, kind: crate::error::CreateDistributionErrorKind::InvalidOriginReadTimeout({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_origin_read_timeout::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_origin_read_timeout_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateDistributionError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidProtocolSettings" => crate::error::CreateDistributionError { meta: generic, kind: crate::error::CreateDistributionErrorKind::InvalidProtocolSettings({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_protocol_settings::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_protocol_settings_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateDistributionError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidQueryStringParameters" => crate::error::CreateDistributionError { meta: generic, kind: crate::error::CreateDistributionErrorKind::InvalidQueryStringParameters({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_query_string_parameters::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_query_string_parameters_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateDistributionError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidRelativePath" => crate::error::CreateDistributionError { meta: generic, kind: crate::error::CreateDistributionErrorKind::InvalidRelativePath({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_relative_path::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_relative_path_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateDistributionError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidRequiredProtocol" => crate::error::CreateDistributionError { meta: generic, kind: crate::error::CreateDistributionErrorKind::InvalidRequiredProtocol({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_required_protocol::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_required_protocol_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateDistributionError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidResponseCode" => crate::error::CreateDistributionError { meta: generic, kind: crate::error::CreateDistributionErrorKind::InvalidResponseCode({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_response_code::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_response_code_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateDistributionError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidTTLOrder" => crate::error::CreateDistributionError { meta: generic, kind: crate::error::CreateDistributionErrorKind::InvalidTtlOrder({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_ttl_order::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_ttl_order_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateDistributionError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidViewerCertificate" => crate::error::CreateDistributionError { meta: generic, kind: crate::error::CreateDistributionErrorKind::InvalidViewerCertificate({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_viewer_certificate::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_viewer_certificate_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateDistributionError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidWebACLId" => crate::error::CreateDistributionError { meta: generic, kind: crate::error::CreateDistributionErrorKind::InvalidWebAclId({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_web_acl_id::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_web_acl_id_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateDistributionError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "MissingBody" => crate::error::CreateDistributionError { meta: generic, kind: crate::error::CreateDistributionErrorKind::MissingBody({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::missing_body::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_missing_body_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateDistributionError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "NoSuchCachePolicy" => crate::error::CreateDistributionError { meta: generic, kind: crate::error::CreateDistributionErrorKind::NoSuchCachePolicy({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::no_such_cache_policy::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_no_such_cache_policy_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateDistributionError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "NoSuchFieldLevelEncryptionConfig" => crate::error::CreateDistributionError { meta: generic, kind: crate::error::CreateDistributionErrorKind::NoSuchFieldLevelEncryptionConfig({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::no_such_field_level_encryption_config::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_no_such_field_level_encryption_config_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateDistributionError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "NoSuchOrigin" => crate::error::CreateDistributionError { meta: generic, kind: crate::error::CreateDistributionErrorKind::NoSuchOrigin({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::no_such_origin::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_no_such_origin_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateDistributionError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "NoSuchOriginRequestPolicy" => crate::error::CreateDistributionError { meta: generic, kind: crate::error::CreateDistributionErrorKind::NoSuchOriginRequestPolicy({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::no_such_origin_request_policy::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_no_such_origin_request_policy_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateDistributionError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "NoSuchRealtimeLogConfig" => crate::error::CreateDistributionError { meta: generic, kind: crate::error::CreateDistributionErrorKind::NoSuchRealtimeLogConfig({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::no_such_realtime_log_config::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_no_such_realtime_log_config_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateDistributionError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "NoSuchResponseHeadersPolicy" => crate::error::CreateDistributionError { meta: generic, kind: crate::error::CreateDistributionErrorKind::NoSuchResponseHeadersPolicy({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::no_such_response_headers_policy::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_no_such_response_headers_policy_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateDistributionError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "RealtimeLogConfigOwnerMismatch" => crate::error::CreateDistributionError { meta: generic, kind: crate::error::CreateDistributionErrorKind::RealtimeLogConfigOwnerMismatch({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::realtime_log_config_owner_mismatch::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_realtime_log_config_owner_mismatch_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateDistributionError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "TooManyCacheBehaviors" => crate::error::CreateDistributionError { meta: generic, kind: crate::error::CreateDistributionErrorKind::TooManyCacheBehaviors({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::too_many_cache_behaviors::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_too_many_cache_behaviors_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateDistributionError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "TooManyCertificates" => crate::error::CreateDistributionError { meta: generic, kind: crate::error::CreateDistributionErrorKind::TooManyCertificates({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::too_many_certificates::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_too_many_certificates_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateDistributionError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "TooManyCookieNamesInWhiteList" => crate::error::CreateDistributionError { meta: generic, kind: crate::error::CreateDistributionErrorKind::TooManyCookieNamesInWhiteList({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::too_many_cookie_names_in_white_list::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_too_many_cookie_names_in_white_list_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateDistributionError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "TooManyDistributionCNAMEs" => crate::error::CreateDistributionError { meta: generic, kind: crate::error::CreateDistributionErrorKind::TooManyDistributionCnamEs({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::too_many_distribution_cnam_es::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_too_many_distribution_cnam_es_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateDistributionError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "TooManyDistributions" => crate::error::CreateDistributionError { meta: generic, kind: crate::error::CreateDistributionErrorKind::TooManyDistributions({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::too_many_distributions::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_too_many_distributions_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateDistributionError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "TooManyDistributionsAssociatedToCachePolicy" => crate::error::CreateDistributionError { meta: generic, kind: crate::error::CreateDistributionErrorKind::TooManyDistributionsAssociatedToCachePolicy({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::too_many_distributions_associated_to_cache_policy::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_too_many_distributions_associated_to_cache_policy_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateDistributionError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "TooManyDistributionsAssociatedToFieldLevelEncryptionConfig" => crate::error::CreateDistributionError { meta: generic, kind: crate::error::CreateDistributionErrorKind::TooManyDistributionsAssociatedToFieldLevelEncryptionConfig({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::too_many_distributions_associated_to_field_level_encryption_config::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_too_many_distributions_associated_to_field_level_encryption_config_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateDistributionError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "TooManyDistributionsAssociatedToKeyGroup" => crate::error::CreateDistributionError { meta: generic, kind: crate::error::CreateDistributionErrorKind::TooManyDistributionsAssociatedToKeyGroup({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::too_many_distributions_associated_to_key_group::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_too_many_distributions_associated_to_key_group_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateDistributionError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "TooManyDistributionsAssociatedToOriginRequestPolicy" => crate::error::CreateDistributionError { meta: generic, kind: crate::error::CreateDistributionErrorKind::TooManyDistributionsAssociatedToOriginRequestPolicy({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::too_many_distributions_associated_to_origin_request_policy::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_too_many_distributions_associated_to_origin_request_policy_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateDistributionError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "TooManyDistributionsAssociatedToResponseHeadersPolicy" => crate::error::CreateDistributionError { meta: generic, kind: crate::error::CreateDistributionErrorKind::TooManyDistributionsAssociatedToResponseHeadersPolicy({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::too_many_distributions_associated_to_response_headers_policy::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_too_many_distributions_associated_to_response_headers_policy_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateDistributionError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "TooManyDistributionsWithFunctionAssociations" => crate::error::CreateDistributionError { meta: generic, kind: crate::error::CreateDistributionErrorKind::TooManyDistributionsWithFunctionAssociations({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::too_many_distributions_with_function_associations::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_too_many_distributions_with_function_associations_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateDistributionError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "TooManyDistributionsWithLambdaAssociations" => crate::error::CreateDistributionError { meta: generic, kind: crate::error::CreateDistributionErrorKind::TooManyDistributionsWithLambdaAssociations({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::too_many_distributions_with_lambda_associations::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_too_many_distributions_with_lambda_associations_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateDistributionError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "TooManyDistributionsWithSingleFunctionARN" => crate::error::CreateDistributionError { meta: generic, kind: crate::error::CreateDistributionErrorKind::TooManyDistributionsWithSingleFunctionArn({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::too_many_distributions_with_single_function_arn::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_too_many_distributions_with_single_function_arn_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateDistributionError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "TooManyFunctionAssociations" => crate::error::CreateDistributionError { meta: generic, kind: crate::error::CreateDistributionErrorKind::TooManyFunctionAssociations({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::too_many_function_associations::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_too_many_function_associations_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateDistributionError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "TooManyHeadersInForwardedValues" => crate::error::CreateDistributionError { meta: generic, kind: crate::error::CreateDistributionErrorKind::TooManyHeadersInForwardedValues({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::too_many_headers_in_forwarded_values::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_too_many_headers_in_forwarded_values_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateDistributionError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "TooManyKeyGroupsAssociatedToDistribution" => crate::error::CreateDistributionError { meta: generic, kind: crate::error::CreateDistributionErrorKind::TooManyKeyGroupsAssociatedToDistribution({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::too_many_key_groups_associated_to_distribution::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_too_many_key_groups_associated_to_distribution_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateDistributionError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "TooManyLambdaFunctionAssociations" => crate::error::CreateDistributionError { meta: generic, kind: crate::error::CreateDistributionErrorKind::TooManyLambdaFunctionAssociations({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::too_many_lambda_function_associations::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_too_many_lambda_function_associations_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateDistributionError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "TooManyOriginCustomHeaders" => crate::error::CreateDistributionError { meta: generic, kind: crate::error::CreateDistributionErrorKind::TooManyOriginCustomHeaders({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::too_many_origin_custom_headers::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_too_many_origin_custom_headers_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateDistributionError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "TooManyOriginGroupsPerDistribution" => crate::error::CreateDistributionError { meta: generic, kind: crate::error::CreateDistributionErrorKind::TooManyOriginGroupsPerDistribution({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::too_many_origin_groups_per_distribution::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_too_many_origin_groups_per_distribution_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateDistributionError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "TooManyOrigins" => crate::error::CreateDistributionError { meta: generic, kind: crate::error::CreateDistributionErrorKind::TooManyOrigins({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::too_many_origins::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_too_many_origins_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateDistributionError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "TooManyQueryStringParameters" => crate::error::CreateDistributionError { meta: generic, kind: crate::error::CreateDistributionErrorKind::TooManyQueryStringParameters({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::too_many_query_string_parameters::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_too_many_query_string_parameters_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateDistributionError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "TooManyTrustedSigners" => crate::error::CreateDistributionError { meta: generic, kind: crate::error::CreateDistributionErrorKind::TooManyTrustedSigners({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::too_many_trusted_signers::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_too_many_trusted_signers_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateDistributionError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "TrustedKeyGroupDoesNotExist" => crate::error::CreateDistributionError { meta: generic, kind: crate::error::CreateDistributionErrorKind::TrustedKeyGroupDoesNotExist({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::trusted_key_group_does_not_exist::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_trusted_key_group_does_not_exist_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateDistributionError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "TrustedSignerDoesNotExist" => crate::error::CreateDistributionError { meta: generic, kind: crate::error::CreateDistributionErrorKind::TrustedSignerDoesNotExist({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::trusted_signer_does_not_exist::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_trusted_signer_does_not_exist_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateDistributionError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::CreateDistributionError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_distribution_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateDistributionOutput,
    crate::error::CreateDistributionError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_distribution_output::Builder::default();
        let _ = response;
        output = output.set_distribution(
            crate::http_serde::deser_payload_create_distribution_create_distribution_output_distribution(response.body().as_ref())?
        );
        output = output.set_e_tag(
            crate::http_serde::deser_header_create_distribution_create_distribution_output_e_tag(
                response.headers(),
            )
            .map_err(|_| {
                crate::error::CreateDistributionError::unhandled(
                    "Failed to parse ETag from header `ETag",
                )
            })?,
        );
        output = output.set_location(
            crate::http_serde::deser_header_create_distribution_create_distribution_output_location(response.headers())
                                    .map_err(|_|crate::error::CreateDistributionError::unhandled("Failed to parse Location from header `Location"))?
        );
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_distribution_with_tags_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateDistributionWithTagsOutput,
    crate::error::CreateDistributionWithTagsError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateDistributionWithTagsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::CreateDistributionWithTagsError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDenied" => crate::error::CreateDistributionWithTagsError { meta: generic, kind: crate::error::CreateDistributionWithTagsErrorKind::AccessDenied({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::access_denied::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_access_denied_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateDistributionWithTagsError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "CNAMEAlreadyExists" => crate::error::CreateDistributionWithTagsError { meta: generic, kind: crate::error::CreateDistributionWithTagsErrorKind::CnameAlreadyExists({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::cname_already_exists::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_cname_already_exists_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateDistributionWithTagsError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "DistributionAlreadyExists" => crate::error::CreateDistributionWithTagsError { meta: generic, kind: crate::error::CreateDistributionWithTagsErrorKind::DistributionAlreadyExists({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::distribution_already_exists::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_distribution_already_exists_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateDistributionWithTagsError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "IllegalFieldLevelEncryptionConfigAssociationWithCacheBehavior" => crate::error::CreateDistributionWithTagsError { meta: generic, kind: crate::error::CreateDistributionWithTagsErrorKind::IllegalFieldLevelEncryptionConfigAssociationWithCacheBehavior({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::illegal_field_level_encryption_config_association_with_cache_behavior::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_illegal_field_level_encryption_config_association_with_cache_behavior_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateDistributionWithTagsError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InconsistentQuantities" => crate::error::CreateDistributionWithTagsError { meta: generic, kind: crate::error::CreateDistributionWithTagsErrorKind::InconsistentQuantities({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::inconsistent_quantities::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_inconsistent_quantities_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateDistributionWithTagsError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidArgument" => crate::error::CreateDistributionWithTagsError { meta: generic, kind: crate::error::CreateDistributionWithTagsErrorKind::InvalidArgument({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_argument::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_argument_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateDistributionWithTagsError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidDefaultRootObject" => crate::error::CreateDistributionWithTagsError { meta: generic, kind: crate::error::CreateDistributionWithTagsErrorKind::InvalidDefaultRootObject({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_default_root_object::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_default_root_object_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateDistributionWithTagsError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidErrorCode" => crate::error::CreateDistributionWithTagsError { meta: generic, kind: crate::error::CreateDistributionWithTagsErrorKind::InvalidErrorCode({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_error_code::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_error_code_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateDistributionWithTagsError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidForwardCookies" => crate::error::CreateDistributionWithTagsError { meta: generic, kind: crate::error::CreateDistributionWithTagsErrorKind::InvalidForwardCookies({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_forward_cookies::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_forward_cookies_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateDistributionWithTagsError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidFunctionAssociation" => crate::error::CreateDistributionWithTagsError { meta: generic, kind: crate::error::CreateDistributionWithTagsErrorKind::InvalidFunctionAssociation({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_function_association::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_function_association_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateDistributionWithTagsError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidGeoRestrictionParameter" => crate::error::CreateDistributionWithTagsError { meta: generic, kind: crate::error::CreateDistributionWithTagsErrorKind::InvalidGeoRestrictionParameter({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_geo_restriction_parameter::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_geo_restriction_parameter_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateDistributionWithTagsError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidHeadersForS3Origin" => crate::error::CreateDistributionWithTagsError { meta: generic, kind: crate::error::CreateDistributionWithTagsErrorKind::InvalidHeadersForS3Origin({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_headers_for_s3_origin::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_headers_for_s3_origin_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateDistributionWithTagsError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidLambdaFunctionAssociation" => crate::error::CreateDistributionWithTagsError { meta: generic, kind: crate::error::CreateDistributionWithTagsErrorKind::InvalidLambdaFunctionAssociation({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_lambda_function_association::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_lambda_function_association_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateDistributionWithTagsError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidLocationCode" => crate::error::CreateDistributionWithTagsError { meta: generic, kind: crate::error::CreateDistributionWithTagsErrorKind::InvalidLocationCode({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_location_code::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_location_code_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateDistributionWithTagsError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidMinimumProtocolVersion" => crate::error::CreateDistributionWithTagsError { meta: generic, kind: crate::error::CreateDistributionWithTagsErrorKind::InvalidMinimumProtocolVersion({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_minimum_protocol_version::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_minimum_protocol_version_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateDistributionWithTagsError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidOrigin" => crate::error::CreateDistributionWithTagsError { meta: generic, kind: crate::error::CreateDistributionWithTagsErrorKind::InvalidOrigin({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_origin::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_origin_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateDistributionWithTagsError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidOriginAccessIdentity" => crate::error::CreateDistributionWithTagsError { meta: generic, kind: crate::error::CreateDistributionWithTagsErrorKind::InvalidOriginAccessIdentity({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_origin_access_identity::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_origin_access_identity_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateDistributionWithTagsError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidOriginKeepaliveTimeout" => crate::error::CreateDistributionWithTagsError { meta: generic, kind: crate::error::CreateDistributionWithTagsErrorKind::InvalidOriginKeepaliveTimeout({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_origin_keepalive_timeout::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_origin_keepalive_timeout_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateDistributionWithTagsError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidOriginReadTimeout" => crate::error::CreateDistributionWithTagsError { meta: generic, kind: crate::error::CreateDistributionWithTagsErrorKind::InvalidOriginReadTimeout({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_origin_read_timeout::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_origin_read_timeout_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateDistributionWithTagsError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidProtocolSettings" => crate::error::CreateDistributionWithTagsError { meta: generic, kind: crate::error::CreateDistributionWithTagsErrorKind::InvalidProtocolSettings({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_protocol_settings::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_protocol_settings_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateDistributionWithTagsError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidQueryStringParameters" => crate::error::CreateDistributionWithTagsError { meta: generic, kind: crate::error::CreateDistributionWithTagsErrorKind::InvalidQueryStringParameters({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_query_string_parameters::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_query_string_parameters_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateDistributionWithTagsError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidRelativePath" => crate::error::CreateDistributionWithTagsError { meta: generic, kind: crate::error::CreateDistributionWithTagsErrorKind::InvalidRelativePath({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_relative_path::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_relative_path_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateDistributionWithTagsError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidRequiredProtocol" => crate::error::CreateDistributionWithTagsError { meta: generic, kind: crate::error::CreateDistributionWithTagsErrorKind::InvalidRequiredProtocol({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_required_protocol::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_required_protocol_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateDistributionWithTagsError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidResponseCode" => crate::error::CreateDistributionWithTagsError { meta: generic, kind: crate::error::CreateDistributionWithTagsErrorKind::InvalidResponseCode({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_response_code::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_response_code_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateDistributionWithTagsError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidTagging" => crate::error::CreateDistributionWithTagsError { meta: generic, kind: crate::error::CreateDistributionWithTagsErrorKind::InvalidTagging({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_tagging::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_tagging_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateDistributionWithTagsError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidTTLOrder" => crate::error::CreateDistributionWithTagsError { meta: generic, kind: crate::error::CreateDistributionWithTagsErrorKind::InvalidTtlOrder({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_ttl_order::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_ttl_order_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateDistributionWithTagsError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidViewerCertificate" => crate::error::CreateDistributionWithTagsError { meta: generic, kind: crate::error::CreateDistributionWithTagsErrorKind::InvalidViewerCertificate({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_viewer_certificate::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_viewer_certificate_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateDistributionWithTagsError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidWebACLId" => crate::error::CreateDistributionWithTagsError { meta: generic, kind: crate::error::CreateDistributionWithTagsErrorKind::InvalidWebAclId({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_web_acl_id::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_web_acl_id_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateDistributionWithTagsError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "MissingBody" => crate::error::CreateDistributionWithTagsError { meta: generic, kind: crate::error::CreateDistributionWithTagsErrorKind::MissingBody({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::missing_body::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_missing_body_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateDistributionWithTagsError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "NoSuchCachePolicy" => crate::error::CreateDistributionWithTagsError { meta: generic, kind: crate::error::CreateDistributionWithTagsErrorKind::NoSuchCachePolicy({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::no_such_cache_policy::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_no_such_cache_policy_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateDistributionWithTagsError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "NoSuchFieldLevelEncryptionConfig" => crate::error::CreateDistributionWithTagsError { meta: generic, kind: crate::error::CreateDistributionWithTagsErrorKind::NoSuchFieldLevelEncryptionConfig({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::no_such_field_level_encryption_config::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_no_such_field_level_encryption_config_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateDistributionWithTagsError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "NoSuchOrigin" => crate::error::CreateDistributionWithTagsError { meta: generic, kind: crate::error::CreateDistributionWithTagsErrorKind::NoSuchOrigin({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::no_such_origin::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_no_such_origin_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateDistributionWithTagsError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "NoSuchOriginRequestPolicy" => crate::error::CreateDistributionWithTagsError { meta: generic, kind: crate::error::CreateDistributionWithTagsErrorKind::NoSuchOriginRequestPolicy({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::no_such_origin_request_policy::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_no_such_origin_request_policy_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateDistributionWithTagsError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "NoSuchRealtimeLogConfig" => crate::error::CreateDistributionWithTagsError { meta: generic, kind: crate::error::CreateDistributionWithTagsErrorKind::NoSuchRealtimeLogConfig({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::no_such_realtime_log_config::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_no_such_realtime_log_config_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateDistributionWithTagsError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "NoSuchResponseHeadersPolicy" => crate::error::CreateDistributionWithTagsError { meta: generic, kind: crate::error::CreateDistributionWithTagsErrorKind::NoSuchResponseHeadersPolicy({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::no_such_response_headers_policy::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_no_such_response_headers_policy_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateDistributionWithTagsError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "RealtimeLogConfigOwnerMismatch" => crate::error::CreateDistributionWithTagsError { meta: generic, kind: crate::error::CreateDistributionWithTagsErrorKind::RealtimeLogConfigOwnerMismatch({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::realtime_log_config_owner_mismatch::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_realtime_log_config_owner_mismatch_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateDistributionWithTagsError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "TooManyCacheBehaviors" => crate::error::CreateDistributionWithTagsError { meta: generic, kind: crate::error::CreateDistributionWithTagsErrorKind::TooManyCacheBehaviors({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::too_many_cache_behaviors::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_too_many_cache_behaviors_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateDistributionWithTagsError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "TooManyCertificates" => crate::error::CreateDistributionWithTagsError { meta: generic, kind: crate::error::CreateDistributionWithTagsErrorKind::TooManyCertificates({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::too_many_certificates::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_too_many_certificates_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateDistributionWithTagsError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "TooManyCookieNamesInWhiteList" => crate::error::CreateDistributionWithTagsError { meta: generic, kind: crate::error::CreateDistributionWithTagsErrorKind::TooManyCookieNamesInWhiteList({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::too_many_cookie_names_in_white_list::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_too_many_cookie_names_in_white_list_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateDistributionWithTagsError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "TooManyDistributionCNAMEs" => crate::error::CreateDistributionWithTagsError { meta: generic, kind: crate::error::CreateDistributionWithTagsErrorKind::TooManyDistributionCnamEs({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::too_many_distribution_cnam_es::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_too_many_distribution_cnam_es_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateDistributionWithTagsError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "TooManyDistributions" => crate::error::CreateDistributionWithTagsError { meta: generic, kind: crate::error::CreateDistributionWithTagsErrorKind::TooManyDistributions({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::too_many_distributions::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_too_many_distributions_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateDistributionWithTagsError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "TooManyDistributionsAssociatedToCachePolicy" => crate::error::CreateDistributionWithTagsError { meta: generic, kind: crate::error::CreateDistributionWithTagsErrorKind::TooManyDistributionsAssociatedToCachePolicy({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::too_many_distributions_associated_to_cache_policy::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_too_many_distributions_associated_to_cache_policy_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateDistributionWithTagsError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "TooManyDistributionsAssociatedToFieldLevelEncryptionConfig" => crate::error::CreateDistributionWithTagsError { meta: generic, kind: crate::error::CreateDistributionWithTagsErrorKind::TooManyDistributionsAssociatedToFieldLevelEncryptionConfig({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::too_many_distributions_associated_to_field_level_encryption_config::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_too_many_distributions_associated_to_field_level_encryption_config_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateDistributionWithTagsError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "TooManyDistributionsAssociatedToKeyGroup" => crate::error::CreateDistributionWithTagsError { meta: generic, kind: crate::error::CreateDistributionWithTagsErrorKind::TooManyDistributionsAssociatedToKeyGroup({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::too_many_distributions_associated_to_key_group::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_too_many_distributions_associated_to_key_group_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateDistributionWithTagsError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "TooManyDistributionsAssociatedToOriginRequestPolicy" => crate::error::CreateDistributionWithTagsError { meta: generic, kind: crate::error::CreateDistributionWithTagsErrorKind::TooManyDistributionsAssociatedToOriginRequestPolicy({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::too_many_distributions_associated_to_origin_request_policy::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_too_many_distributions_associated_to_origin_request_policy_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateDistributionWithTagsError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "TooManyDistributionsAssociatedToResponseHeadersPolicy" => crate::error::CreateDistributionWithTagsError { meta: generic, kind: crate::error::CreateDistributionWithTagsErrorKind::TooManyDistributionsAssociatedToResponseHeadersPolicy({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::too_many_distributions_associated_to_response_headers_policy::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_too_many_distributions_associated_to_response_headers_policy_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateDistributionWithTagsError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "TooManyDistributionsWithFunctionAssociations" => crate::error::CreateDistributionWithTagsError { meta: generic, kind: crate::error::CreateDistributionWithTagsErrorKind::TooManyDistributionsWithFunctionAssociations({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::too_many_distributions_with_function_associations::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_too_many_distributions_with_function_associations_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateDistributionWithTagsError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "TooManyDistributionsWithLambdaAssociations" => crate::error::CreateDistributionWithTagsError { meta: generic, kind: crate::error::CreateDistributionWithTagsErrorKind::TooManyDistributionsWithLambdaAssociations({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::too_many_distributions_with_lambda_associations::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_too_many_distributions_with_lambda_associations_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateDistributionWithTagsError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "TooManyDistributionsWithSingleFunctionARN" => crate::error::CreateDistributionWithTagsError { meta: generic, kind: crate::error::CreateDistributionWithTagsErrorKind::TooManyDistributionsWithSingleFunctionArn({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::too_many_distributions_with_single_function_arn::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_too_many_distributions_with_single_function_arn_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateDistributionWithTagsError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "TooManyFunctionAssociations" => crate::error::CreateDistributionWithTagsError { meta: generic, kind: crate::error::CreateDistributionWithTagsErrorKind::TooManyFunctionAssociations({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::too_many_function_associations::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_too_many_function_associations_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateDistributionWithTagsError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "TooManyHeadersInForwardedValues" => crate::error::CreateDistributionWithTagsError { meta: generic, kind: crate::error::CreateDistributionWithTagsErrorKind::TooManyHeadersInForwardedValues({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::too_many_headers_in_forwarded_values::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_too_many_headers_in_forwarded_values_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateDistributionWithTagsError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "TooManyKeyGroupsAssociatedToDistribution" => crate::error::CreateDistributionWithTagsError { meta: generic, kind: crate::error::CreateDistributionWithTagsErrorKind::TooManyKeyGroupsAssociatedToDistribution({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::too_many_key_groups_associated_to_distribution::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_too_many_key_groups_associated_to_distribution_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateDistributionWithTagsError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "TooManyLambdaFunctionAssociations" => crate::error::CreateDistributionWithTagsError { meta: generic, kind: crate::error::CreateDistributionWithTagsErrorKind::TooManyLambdaFunctionAssociations({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::too_many_lambda_function_associations::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_too_many_lambda_function_associations_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateDistributionWithTagsError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "TooManyOriginCustomHeaders" => crate::error::CreateDistributionWithTagsError { meta: generic, kind: crate::error::CreateDistributionWithTagsErrorKind::TooManyOriginCustomHeaders({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::too_many_origin_custom_headers::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_too_many_origin_custom_headers_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateDistributionWithTagsError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "TooManyOriginGroupsPerDistribution" => crate::error::CreateDistributionWithTagsError { meta: generic, kind: crate::error::CreateDistributionWithTagsErrorKind::TooManyOriginGroupsPerDistribution({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::too_many_origin_groups_per_distribution::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_too_many_origin_groups_per_distribution_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateDistributionWithTagsError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "TooManyOrigins" => crate::error::CreateDistributionWithTagsError { meta: generic, kind: crate::error::CreateDistributionWithTagsErrorKind::TooManyOrigins({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::too_many_origins::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_too_many_origins_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateDistributionWithTagsError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "TooManyQueryStringParameters" => crate::error::CreateDistributionWithTagsError { meta: generic, kind: crate::error::CreateDistributionWithTagsErrorKind::TooManyQueryStringParameters({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::too_many_query_string_parameters::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_too_many_query_string_parameters_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateDistributionWithTagsError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "TooManyTrustedSigners" => crate::error::CreateDistributionWithTagsError { meta: generic, kind: crate::error::CreateDistributionWithTagsErrorKind::TooManyTrustedSigners({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::too_many_trusted_signers::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_too_many_trusted_signers_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateDistributionWithTagsError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "TrustedKeyGroupDoesNotExist" => crate::error::CreateDistributionWithTagsError { meta: generic, kind: crate::error::CreateDistributionWithTagsErrorKind::TrustedKeyGroupDoesNotExist({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::trusted_key_group_does_not_exist::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_trusted_key_group_does_not_exist_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateDistributionWithTagsError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "TrustedSignerDoesNotExist" => crate::error::CreateDistributionWithTagsError { meta: generic, kind: crate::error::CreateDistributionWithTagsErrorKind::TrustedSignerDoesNotExist({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::trusted_signer_does_not_exist::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_trusted_signer_does_not_exist_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateDistributionWithTagsError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::CreateDistributionWithTagsError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_distribution_with_tags_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateDistributionWithTagsOutput,
    crate::error::CreateDistributionWithTagsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_distribution_with_tags_output::Builder::default();
        let _ = response;
        output = output.set_distribution(
            crate::http_serde::deser_payload_create_distribution_with_tags_create_distribution_with_tags_output_distribution(response.body().as_ref())?
        );
        output = output.set_e_tag(
            crate::http_serde::deser_header_create_distribution_with_tags_create_distribution_with_tags_output_e_tag(response.headers())
                                    .map_err(|_|crate::error::CreateDistributionWithTagsError::unhandled("Failed to parse ETag from header `ETag"))?
        );
        output = output.set_location(
            crate::http_serde::deser_header_create_distribution_with_tags_create_distribution_with_tags_output_location(response.headers())
                                    .map_err(|_|crate::error::CreateDistributionWithTagsError::unhandled("Failed to parse Location from header `Location"))?
        );
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_field_level_encryption_config_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateFieldLevelEncryptionConfigOutput,
    crate::error::CreateFieldLevelEncryptionConfigError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateFieldLevelEncryptionConfigError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::CreateFieldLevelEncryptionConfigError::unhandled(generic))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "FieldLevelEncryptionConfigAlreadyExists" => crate::error::CreateFieldLevelEncryptionConfigError { meta: generic, kind: crate::error::CreateFieldLevelEncryptionConfigErrorKind::FieldLevelEncryptionConfigAlreadyExists({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::field_level_encryption_config_already_exists::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_field_level_encryption_config_already_exists_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateFieldLevelEncryptionConfigError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InconsistentQuantities" => crate::error::CreateFieldLevelEncryptionConfigError { meta: generic, kind: crate::error::CreateFieldLevelEncryptionConfigErrorKind::InconsistentQuantities({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::inconsistent_quantities::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_inconsistent_quantities_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateFieldLevelEncryptionConfigError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidArgument" => crate::error::CreateFieldLevelEncryptionConfigError { meta: generic, kind: crate::error::CreateFieldLevelEncryptionConfigErrorKind::InvalidArgument({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_argument::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_argument_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateFieldLevelEncryptionConfigError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "NoSuchFieldLevelEncryptionProfile" => crate::error::CreateFieldLevelEncryptionConfigError { meta: generic, kind: crate::error::CreateFieldLevelEncryptionConfigErrorKind::NoSuchFieldLevelEncryptionProfile({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::no_such_field_level_encryption_profile::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_no_such_field_level_encryption_profile_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateFieldLevelEncryptionConfigError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "QueryArgProfileEmpty" => crate::error::CreateFieldLevelEncryptionConfigError { meta: generic, kind: crate::error::CreateFieldLevelEncryptionConfigErrorKind::QueryArgProfileEmpty({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::query_arg_profile_empty::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_query_arg_profile_empty_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateFieldLevelEncryptionConfigError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "TooManyFieldLevelEncryptionConfigs" => crate::error::CreateFieldLevelEncryptionConfigError { meta: generic, kind: crate::error::CreateFieldLevelEncryptionConfigErrorKind::TooManyFieldLevelEncryptionConfigs({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::too_many_field_level_encryption_configs::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_too_many_field_level_encryption_configs_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateFieldLevelEncryptionConfigError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "TooManyFieldLevelEncryptionContentTypeProfiles" => crate::error::CreateFieldLevelEncryptionConfigError { meta: generic, kind: crate::error::CreateFieldLevelEncryptionConfigErrorKind::TooManyFieldLevelEncryptionContentTypeProfiles({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::too_many_field_level_encryption_content_type_profiles::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_too_many_field_level_encryption_content_type_profiles_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateFieldLevelEncryptionConfigError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "TooManyFieldLevelEncryptionQueryArgProfiles" => crate::error::CreateFieldLevelEncryptionConfigError { meta: generic, kind: crate::error::CreateFieldLevelEncryptionConfigErrorKind::TooManyFieldLevelEncryptionQueryArgProfiles({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::too_many_field_level_encryption_query_arg_profiles::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_too_many_field_level_encryption_query_arg_profiles_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateFieldLevelEncryptionConfigError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::CreateFieldLevelEncryptionConfigError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_field_level_encryption_config_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateFieldLevelEncryptionConfigOutput,
    crate::error::CreateFieldLevelEncryptionConfigError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::create_field_level_encryption_config_output::Builder::default();
        let _ = response;
        output = output.set_e_tag(
            crate::http_serde::deser_header_create_field_level_encryption_config_create_field_level_encryption_config_output_e_tag(response.headers())
                                    .map_err(|_|crate::error::CreateFieldLevelEncryptionConfigError::unhandled("Failed to parse ETag from header `ETag"))?
        );
        output = output.set_field_level_encryption(
            crate::http_serde::deser_payload_create_field_level_encryption_config_create_field_level_encryption_config_output_field_level_encryption(response.body().as_ref())?
        );
        output = output.set_location(
            crate::http_serde::deser_header_create_field_level_encryption_config_create_field_level_encryption_config_output_location(response.headers())
                                    .map_err(|_|crate::error::CreateFieldLevelEncryptionConfigError::unhandled("Failed to parse Location from header `Location"))?
        );
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_field_level_encryption_profile_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateFieldLevelEncryptionProfileOutput,
    crate::error::CreateFieldLevelEncryptionProfileError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateFieldLevelEncryptionProfileError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::CreateFieldLevelEncryptionProfileError::unhandled(generic))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "FieldLevelEncryptionProfileAlreadyExists" => crate::error::CreateFieldLevelEncryptionProfileError { meta: generic, kind: crate::error::CreateFieldLevelEncryptionProfileErrorKind::FieldLevelEncryptionProfileAlreadyExists({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::field_level_encryption_profile_already_exists::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_field_level_encryption_profile_already_exists_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateFieldLevelEncryptionProfileError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "FieldLevelEncryptionProfileSizeExceeded" => crate::error::CreateFieldLevelEncryptionProfileError { meta: generic, kind: crate::error::CreateFieldLevelEncryptionProfileErrorKind::FieldLevelEncryptionProfileSizeExceeded({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::field_level_encryption_profile_size_exceeded::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_field_level_encryption_profile_size_exceeded_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateFieldLevelEncryptionProfileError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InconsistentQuantities" => crate::error::CreateFieldLevelEncryptionProfileError { meta: generic, kind: crate::error::CreateFieldLevelEncryptionProfileErrorKind::InconsistentQuantities({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::inconsistent_quantities::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_inconsistent_quantities_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateFieldLevelEncryptionProfileError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidArgument" => crate::error::CreateFieldLevelEncryptionProfileError { meta: generic, kind: crate::error::CreateFieldLevelEncryptionProfileErrorKind::InvalidArgument({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_argument::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_argument_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateFieldLevelEncryptionProfileError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "NoSuchPublicKey" => crate::error::CreateFieldLevelEncryptionProfileError { meta: generic, kind: crate::error::CreateFieldLevelEncryptionProfileErrorKind::NoSuchPublicKey({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::no_such_public_key::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_no_such_public_key_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateFieldLevelEncryptionProfileError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "TooManyFieldLevelEncryptionEncryptionEntities" => crate::error::CreateFieldLevelEncryptionProfileError { meta: generic, kind: crate::error::CreateFieldLevelEncryptionProfileErrorKind::TooManyFieldLevelEncryptionEncryptionEntities({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::too_many_field_level_encryption_encryption_entities::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_too_many_field_level_encryption_encryption_entities_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateFieldLevelEncryptionProfileError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "TooManyFieldLevelEncryptionFieldPatterns" => crate::error::CreateFieldLevelEncryptionProfileError { meta: generic, kind: crate::error::CreateFieldLevelEncryptionProfileErrorKind::TooManyFieldLevelEncryptionFieldPatterns({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::too_many_field_level_encryption_field_patterns::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_too_many_field_level_encryption_field_patterns_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateFieldLevelEncryptionProfileError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "TooManyFieldLevelEncryptionProfiles" => crate::error::CreateFieldLevelEncryptionProfileError { meta: generic, kind: crate::error::CreateFieldLevelEncryptionProfileErrorKind::TooManyFieldLevelEncryptionProfiles({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::too_many_field_level_encryption_profiles::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_too_many_field_level_encryption_profiles_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateFieldLevelEncryptionProfileError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::CreateFieldLevelEncryptionProfileError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_field_level_encryption_profile_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateFieldLevelEncryptionProfileOutput,
    crate::error::CreateFieldLevelEncryptionProfileError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::create_field_level_encryption_profile_output::Builder::default();
        let _ = response;
        output = output.set_e_tag(
            crate::http_serde::deser_header_create_field_level_encryption_profile_create_field_level_encryption_profile_output_e_tag(response.headers())
                                    .map_err(|_|crate::error::CreateFieldLevelEncryptionProfileError::unhandled("Failed to parse ETag from header `ETag"))?
        );
        output = output.set_field_level_encryption_profile(
            crate::http_serde::deser_payload_create_field_level_encryption_profile_create_field_level_encryption_profile_output_field_level_encryption_profile(response.body().as_ref())?
        );
        output = output.set_location(
            crate::http_serde::deser_header_create_field_level_encryption_profile_create_field_level_encryption_profile_output_location(response.headers())
                                    .map_err(|_|crate::error::CreateFieldLevelEncryptionProfileError::unhandled("Failed to parse Location from header `Location"))?
        );
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_function_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateFunctionOutput, crate::error::CreateFunctionError> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateFunctionError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::CreateFunctionError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "FunctionAlreadyExists" => crate::error::CreateFunctionError {
            meta: generic,
            kind: crate::error::CreateFunctionErrorKind::FunctionAlreadyExists({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::function_already_exists::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_function_already_exists_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateFunctionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "FunctionSizeLimitExceeded" => crate::error::CreateFunctionError {
            meta: generic,
            kind: crate::error::CreateFunctionErrorKind::FunctionSizeLimitExceeded({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::function_size_limit_exceeded::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_function_size_limit_exceeded_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateFunctionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidArgument" => crate::error::CreateFunctionError {
            meta: generic,
            kind: crate::error::CreateFunctionErrorKind::InvalidArgument({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_argument::Builder::default();
                    let _ = response;
                    output =
                        crate::xml_deser::deser_structure_crate_error_invalid_argument_xml_err(
                            response.body().as_ref(),
                            output,
                        )
                        .map_err(crate::error::CreateFunctionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TooManyFunctions" => {
            crate::error::CreateFunctionError {
                meta: generic,
                kind: crate::error::CreateFunctionErrorKind::TooManyFunctions({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::too_many_functions::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_too_many_functions_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateFunctionError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "UnsupportedOperation" => crate::error::CreateFunctionError {
            meta: generic,
            kind: crate::error::CreateFunctionErrorKind::UnsupportedOperation({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::unsupported_operation::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_unsupported_operation_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateFunctionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CreateFunctionError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_function_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateFunctionOutput, crate::error::CreateFunctionError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_function_output::Builder::default();
        let _ = response;
        output = output.set_e_tag(
            crate::http_serde::deser_header_create_function_create_function_output_e_tag(
                response.headers(),
            )
            .map_err(|_| {
                crate::error::CreateFunctionError::unhandled(
                    "Failed to parse ETag from header `ETag",
                )
            })?,
        );
        output = output.set_function_summary(
            crate::http_serde::deser_payload_create_function_create_function_output_function_summary(response.body().as_ref())?
        );
        output = output.set_location(
            crate::http_serde::deser_header_create_function_create_function_output_location(
                response.headers(),
            )
            .map_err(|_| {
                crate::error::CreateFunctionError::unhandled(
                    "Failed to parse Location from header `Location",
                )
            })?,
        );
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_invalidation_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateInvalidationOutput,
    crate::error::CreateInvalidationError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateInvalidationError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::CreateInvalidationError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDenied" => crate::error::CreateInvalidationError {
            meta: generic,
            kind: crate::error::CreateInvalidationErrorKind::AccessDenied({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_access_denied_xml_err(
                        response.body().as_ref(),
                        output,
                    )
                    .map_err(crate::error::CreateInvalidationError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "BatchTooLarge" => crate::error::CreateInvalidationError {
            meta: generic,
            kind: crate::error::CreateInvalidationErrorKind::BatchTooLarge({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::batch_too_large::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_batch_too_large_xml_err(
                        response.body().as_ref(),
                        output,
                    )
                    .map_err(crate::error::CreateInvalidationError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InconsistentQuantities" => crate::error::CreateInvalidationError {
            meta: generic,
            kind: crate::error::CreateInvalidationErrorKind::InconsistentQuantities({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::inconsistent_quantities::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_inconsistent_quantities_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateInvalidationError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidArgument" => crate::error::CreateInvalidationError {
            meta: generic,
            kind: crate::error::CreateInvalidationErrorKind::InvalidArgument({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_argument::Builder::default();
                    let _ = response;
                    output =
                        crate::xml_deser::deser_structure_crate_error_invalid_argument_xml_err(
                            response.body().as_ref(),
                            output,
                        )
                        .map_err(crate::error::CreateInvalidationError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "MissingBody" => crate::error::CreateInvalidationError {
            meta: generic,
            kind: crate::error::CreateInvalidationErrorKind::MissingBody({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::missing_body::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_missing_body_xml_err(
                        response.body().as_ref(),
                        output,
                    )
                    .map_err(crate::error::CreateInvalidationError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NoSuchDistribution" => {
            crate::error::CreateInvalidationError {
                meta: generic,
                kind: crate::error::CreateInvalidationErrorKind::NoSuchDistribution({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::no_such_distribution::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_no_such_distribution_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateInvalidationError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "TooManyInvalidationsInProgress" => crate::error::CreateInvalidationError {
            meta: generic,
            kind: crate::error::CreateInvalidationErrorKind::TooManyInvalidationsInProgress({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::too_many_invalidations_in_progress::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_too_many_invalidations_in_progress_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateInvalidationError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CreateInvalidationError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_invalidation_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateInvalidationOutput,
    crate::error::CreateInvalidationError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_invalidation_output::Builder::default();
        let _ = response;
        output = output.set_invalidation(
            crate::http_serde::deser_payload_create_invalidation_create_invalidation_output_invalidation(response.body().as_ref())?
        );
        output = output.set_location(
            crate::http_serde::deser_header_create_invalidation_create_invalidation_output_location(response.headers())
                                    .map_err(|_|crate::error::CreateInvalidationError::unhandled("Failed to parse Location from header `Location"))?
        );
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_key_group_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateKeyGroupOutput, crate::error::CreateKeyGroupError> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateKeyGroupError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::CreateKeyGroupError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidArgument" => crate::error::CreateKeyGroupError {
            meta: generic,
            kind: crate::error::CreateKeyGroupErrorKind::InvalidArgument({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_argument::Builder::default();
                    let _ = response;
                    output =
                        crate::xml_deser::deser_structure_crate_error_invalid_argument_xml_err(
                            response.body().as_ref(),
                            output,
                        )
                        .map_err(crate::error::CreateKeyGroupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "KeyGroupAlreadyExists" => crate::error::CreateKeyGroupError {
            meta: generic,
            kind: crate::error::CreateKeyGroupErrorKind::KeyGroupAlreadyExists({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::key_group_already_exists::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_key_group_already_exists_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateKeyGroupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TooManyKeyGroups" => {
            crate::error::CreateKeyGroupError {
                meta: generic,
                kind: crate::error::CreateKeyGroupErrorKind::TooManyKeyGroups({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::too_many_key_groups::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_too_many_key_groups_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateKeyGroupError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "TooManyPublicKeysInKeyGroup" => crate::error::CreateKeyGroupError {
            meta: generic,
            kind: crate::error::CreateKeyGroupErrorKind::TooManyPublicKeysInKeyGroup({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::too_many_public_keys_in_key_group::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_too_many_public_keys_in_key_group_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateKeyGroupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CreateKeyGroupError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_key_group_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateKeyGroupOutput, crate::error::CreateKeyGroupError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_key_group_output::Builder::default();
        let _ = response;
        output = output.set_e_tag(
            crate::http_serde::deser_header_create_key_group_create_key_group_output_e_tag(
                response.headers(),
            )
            .map_err(|_| {
                crate::error::CreateKeyGroupError::unhandled(
                    "Failed to parse ETag from header `ETag",
                )
            })?,
        );
        output = output.set_key_group(
            crate::http_serde::deser_payload_create_key_group_create_key_group_output_key_group(
                response.body().as_ref(),
            )?,
        );
        output = output.set_location(
            crate::http_serde::deser_header_create_key_group_create_key_group_output_location(
                response.headers(),
            )
            .map_err(|_| {
                crate::error::CreateKeyGroupError::unhandled(
                    "Failed to parse Location from header `Location",
                )
            })?,
        );
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_monitoring_subscription_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateMonitoringSubscriptionOutput,
    crate::error::CreateMonitoringSubscriptionError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateMonitoringSubscriptionError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::CreateMonitoringSubscriptionError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDenied" => crate::error::CreateMonitoringSubscriptionError {
            meta: generic,
            kind: crate::error::CreateMonitoringSubscriptionErrorKind::AccessDenied({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_access_denied_xml_err(
                        response.body().as_ref(),
                        output,
                    )
                    .map_err(crate::error::CreateMonitoringSubscriptionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NoSuchDistribution" => {
            crate::error::CreateMonitoringSubscriptionError {
                meta: generic,
                kind: crate::error::CreateMonitoringSubscriptionErrorKind::NoSuchDistribution({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::no_such_distribution::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_no_such_distribution_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateMonitoringSubscriptionError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "UnsupportedOperation" => crate::error::CreateMonitoringSubscriptionError {
            meta: generic,
            kind: crate::error::CreateMonitoringSubscriptionErrorKind::UnsupportedOperation({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::unsupported_operation::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_unsupported_operation_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateMonitoringSubscriptionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CreateMonitoringSubscriptionError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_monitoring_subscription_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateMonitoringSubscriptionOutput,
    crate::error::CreateMonitoringSubscriptionError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_monitoring_subscription_output::Builder::default();
        let _ = response;
        output = output.set_monitoring_subscription(
            crate::http_serde::deser_payload_create_monitoring_subscription_create_monitoring_subscription_output_monitoring_subscription(response.body().as_ref())?
        );
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_origin_request_policy_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateOriginRequestPolicyOutput,
    crate::error::CreateOriginRequestPolicyError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateOriginRequestPolicyError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::CreateOriginRequestPolicyError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDenied" => crate::error::CreateOriginRequestPolicyError { meta: generic, kind: crate::error::CreateOriginRequestPolicyErrorKind::AccessDenied({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::access_denied::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_access_denied_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateOriginRequestPolicyError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InconsistentQuantities" => crate::error::CreateOriginRequestPolicyError { meta: generic, kind: crate::error::CreateOriginRequestPolicyErrorKind::InconsistentQuantities({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::inconsistent_quantities::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_inconsistent_quantities_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateOriginRequestPolicyError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidArgument" => crate::error::CreateOriginRequestPolicyError { meta: generic, kind: crate::error::CreateOriginRequestPolicyErrorKind::InvalidArgument({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_argument::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_argument_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateOriginRequestPolicyError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "OriginRequestPolicyAlreadyExists" => crate::error::CreateOriginRequestPolicyError { meta: generic, kind: crate::error::CreateOriginRequestPolicyErrorKind::OriginRequestPolicyAlreadyExists({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::origin_request_policy_already_exists::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_origin_request_policy_already_exists_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateOriginRequestPolicyError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "TooManyCookiesInOriginRequestPolicy" => crate::error::CreateOriginRequestPolicyError { meta: generic, kind: crate::error::CreateOriginRequestPolicyErrorKind::TooManyCookiesInOriginRequestPolicy({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::too_many_cookies_in_origin_request_policy::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_too_many_cookies_in_origin_request_policy_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateOriginRequestPolicyError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "TooManyHeadersInOriginRequestPolicy" => crate::error::CreateOriginRequestPolicyError { meta: generic, kind: crate::error::CreateOriginRequestPolicyErrorKind::TooManyHeadersInOriginRequestPolicy({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::too_many_headers_in_origin_request_policy::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_too_many_headers_in_origin_request_policy_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateOriginRequestPolicyError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "TooManyOriginRequestPolicies" => crate::error::CreateOriginRequestPolicyError { meta: generic, kind: crate::error::CreateOriginRequestPolicyErrorKind::TooManyOriginRequestPolicies({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::too_many_origin_request_policies::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_too_many_origin_request_policies_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateOriginRequestPolicyError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "TooManyQueryStringsInOriginRequestPolicy" => crate::error::CreateOriginRequestPolicyError { meta: generic, kind: crate::error::CreateOriginRequestPolicyErrorKind::TooManyQueryStringsInOriginRequestPolicy({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::too_many_query_strings_in_origin_request_policy::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_too_many_query_strings_in_origin_request_policy_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateOriginRequestPolicyError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::CreateOriginRequestPolicyError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_origin_request_policy_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateOriginRequestPolicyOutput,
    crate::error::CreateOriginRequestPolicyError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_origin_request_policy_output::Builder::default();
        let _ = response;
        output = output.set_e_tag(
            crate::http_serde::deser_header_create_origin_request_policy_create_origin_request_policy_output_e_tag(response.headers())
                                    .map_err(|_|crate::error::CreateOriginRequestPolicyError::unhandled("Failed to parse ETag from header `ETag"))?
        );
        output = output.set_location(
            crate::http_serde::deser_header_create_origin_request_policy_create_origin_request_policy_output_location(response.headers())
                                    .map_err(|_|crate::error::CreateOriginRequestPolicyError::unhandled("Failed to parse Location from header `Location"))?
        );
        output = output.set_origin_request_policy(
            crate::http_serde::deser_payload_create_origin_request_policy_create_origin_request_policy_output_origin_request_policy(response.body().as_ref())?
        );
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_public_key_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreatePublicKeyOutput, crate::error::CreatePublicKeyError> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreatePublicKeyError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::CreatePublicKeyError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidArgument" => crate::error::CreatePublicKeyError {
            meta: generic,
            kind: crate::error::CreatePublicKeyErrorKind::InvalidArgument({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_argument::Builder::default();
                    let _ = response;
                    output =
                        crate::xml_deser::deser_structure_crate_error_invalid_argument_xml_err(
                            response.body().as_ref(),
                            output,
                        )
                        .map_err(crate::error::CreatePublicKeyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "PublicKeyAlreadyExists" => crate::error::CreatePublicKeyError {
            meta: generic,
            kind: crate::error::CreatePublicKeyErrorKind::PublicKeyAlreadyExists({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::public_key_already_exists::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_public_key_already_exists_xml_err(response.body().as_ref(), output).map_err(crate::error::CreatePublicKeyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TooManyPublicKeys" => {
            crate::error::CreatePublicKeyError {
                meta: generic,
                kind: crate::error::CreatePublicKeyErrorKind::TooManyPublicKeys({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::too_many_public_keys::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_too_many_public_keys_xml_err(response.body().as_ref(), output).map_err(crate::error::CreatePublicKeyError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::CreatePublicKeyError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_public_key_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreatePublicKeyOutput, crate::error::CreatePublicKeyError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_public_key_output::Builder::default();
        let _ = response;
        output = output.set_e_tag(
            crate::http_serde::deser_header_create_public_key_create_public_key_output_e_tag(
                response.headers(),
            )
            .map_err(|_| {
                crate::error::CreatePublicKeyError::unhandled(
                    "Failed to parse ETag from header `ETag",
                )
            })?,
        );
        output = output.set_location(
            crate::http_serde::deser_header_create_public_key_create_public_key_output_location(
                response.headers(),
            )
            .map_err(|_| {
                crate::error::CreatePublicKeyError::unhandled(
                    "Failed to parse Location from header `Location",
                )
            })?,
        );
        output = output.set_public_key(
            crate::http_serde::deser_payload_create_public_key_create_public_key_output_public_key(
                response.body().as_ref(),
            )?,
        );
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_realtime_log_config_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateRealtimeLogConfigOutput,
    crate::error::CreateRealtimeLogConfigError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateRealtimeLogConfigError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::CreateRealtimeLogConfigError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDenied" => crate::error::CreateRealtimeLogConfigError {
            meta: generic,
            kind: crate::error::CreateRealtimeLogConfigErrorKind::AccessDenied({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_access_denied_xml_err(
                        response.body().as_ref(),
                        output,
                    )
                    .map_err(crate::error::CreateRealtimeLogConfigError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidArgument" => crate::error::CreateRealtimeLogConfigError {
            meta: generic,
            kind: crate::error::CreateRealtimeLogConfigErrorKind::InvalidArgument({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_argument::Builder::default();
                    let _ = response;
                    output =
                        crate::xml_deser::deser_structure_crate_error_invalid_argument_xml_err(
                            response.body().as_ref(),
                            output,
                        )
                        .map_err(crate::error::CreateRealtimeLogConfigError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "RealtimeLogConfigAlreadyExists" => crate::error::CreateRealtimeLogConfigError {
            meta: generic,
            kind: crate::error::CreateRealtimeLogConfigErrorKind::RealtimeLogConfigAlreadyExists({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::realtime_log_config_already_exists::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_realtime_log_config_already_exists_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateRealtimeLogConfigError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TooManyRealtimeLogConfigs" => crate::error::CreateRealtimeLogConfigError {
            meta: generic,
            kind: crate::error::CreateRealtimeLogConfigErrorKind::TooManyRealtimeLogConfigs({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::too_many_realtime_log_configs::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_too_many_realtime_log_configs_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateRealtimeLogConfigError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CreateRealtimeLogConfigError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_realtime_log_config_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateRealtimeLogConfigOutput,
    crate::error::CreateRealtimeLogConfigError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_realtime_log_config_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_create_realtime_log_config(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CreateRealtimeLogConfigError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_response_headers_policy_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateResponseHeadersPolicyOutput,
    crate::error::CreateResponseHeadersPolicyError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateResponseHeadersPolicyError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::CreateResponseHeadersPolicyError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDenied" => crate::error::CreateResponseHeadersPolicyError { meta: generic, kind: crate::error::CreateResponseHeadersPolicyErrorKind::AccessDenied({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::access_denied::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_access_denied_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateResponseHeadersPolicyError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InconsistentQuantities" => crate::error::CreateResponseHeadersPolicyError { meta: generic, kind: crate::error::CreateResponseHeadersPolicyErrorKind::InconsistentQuantities({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::inconsistent_quantities::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_inconsistent_quantities_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateResponseHeadersPolicyError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidArgument" => crate::error::CreateResponseHeadersPolicyError { meta: generic, kind: crate::error::CreateResponseHeadersPolicyErrorKind::InvalidArgument({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_argument::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_argument_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateResponseHeadersPolicyError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "ResponseHeadersPolicyAlreadyExists" => crate::error::CreateResponseHeadersPolicyError { meta: generic, kind: crate::error::CreateResponseHeadersPolicyErrorKind::ResponseHeadersPolicyAlreadyExists({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::response_headers_policy_already_exists::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_response_headers_policy_already_exists_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateResponseHeadersPolicyError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "TooManyCustomHeadersInResponseHeadersPolicy" => crate::error::CreateResponseHeadersPolicyError { meta: generic, kind: crate::error::CreateResponseHeadersPolicyErrorKind::TooManyCustomHeadersInResponseHeadersPolicy({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::too_many_custom_headers_in_response_headers_policy::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_too_many_custom_headers_in_response_headers_policy_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateResponseHeadersPolicyError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "TooManyResponseHeadersPolicies" => crate::error::CreateResponseHeadersPolicyError { meta: generic, kind: crate::error::CreateResponseHeadersPolicyErrorKind::TooManyResponseHeadersPolicies({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::too_many_response_headers_policies::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_too_many_response_headers_policies_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateResponseHeadersPolicyError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::CreateResponseHeadersPolicyError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_response_headers_policy_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateResponseHeadersPolicyOutput,
    crate::error::CreateResponseHeadersPolicyError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_response_headers_policy_output::Builder::default();
        let _ = response;
        output = output.set_e_tag(
            crate::http_serde::deser_header_create_response_headers_policy_create_response_headers_policy_output_e_tag(response.headers())
                                    .map_err(|_|crate::error::CreateResponseHeadersPolicyError::unhandled("Failed to parse ETag from header `ETag"))?
        );
        output = output.set_location(
            crate::http_serde::deser_header_create_response_headers_policy_create_response_headers_policy_output_location(response.headers())
                                    .map_err(|_|crate::error::CreateResponseHeadersPolicyError::unhandled("Failed to parse Location from header `Location"))?
        );
        output = output.set_response_headers_policy(
            crate::http_serde::deser_payload_create_response_headers_policy_create_response_headers_policy_output_response_headers_policy(response.body().as_ref())?
        );
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_streaming_distribution_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateStreamingDistributionOutput,
    crate::error::CreateStreamingDistributionError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateStreamingDistributionError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::CreateStreamingDistributionError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDenied" => crate::error::CreateStreamingDistributionError { meta: generic, kind: crate::error::CreateStreamingDistributionErrorKind::AccessDenied({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::access_denied::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_access_denied_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateStreamingDistributionError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "CNAMEAlreadyExists" => crate::error::CreateStreamingDistributionError { meta: generic, kind: crate::error::CreateStreamingDistributionErrorKind::CnameAlreadyExists({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::cname_already_exists::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_cname_already_exists_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateStreamingDistributionError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InconsistentQuantities" => crate::error::CreateStreamingDistributionError { meta: generic, kind: crate::error::CreateStreamingDistributionErrorKind::InconsistentQuantities({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::inconsistent_quantities::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_inconsistent_quantities_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateStreamingDistributionError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidArgument" => crate::error::CreateStreamingDistributionError { meta: generic, kind: crate::error::CreateStreamingDistributionErrorKind::InvalidArgument({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_argument::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_argument_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateStreamingDistributionError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidOrigin" => crate::error::CreateStreamingDistributionError { meta: generic, kind: crate::error::CreateStreamingDistributionErrorKind::InvalidOrigin({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_origin::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_origin_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateStreamingDistributionError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidOriginAccessIdentity" => crate::error::CreateStreamingDistributionError { meta: generic, kind: crate::error::CreateStreamingDistributionErrorKind::InvalidOriginAccessIdentity({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_origin_access_identity::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_origin_access_identity_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateStreamingDistributionError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "MissingBody" => crate::error::CreateStreamingDistributionError { meta: generic, kind: crate::error::CreateStreamingDistributionErrorKind::MissingBody({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::missing_body::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_missing_body_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateStreamingDistributionError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "StreamingDistributionAlreadyExists" => crate::error::CreateStreamingDistributionError { meta: generic, kind: crate::error::CreateStreamingDistributionErrorKind::StreamingDistributionAlreadyExists({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::streaming_distribution_already_exists::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_streaming_distribution_already_exists_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateStreamingDistributionError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "TooManyStreamingDistributionCNAMEs" => crate::error::CreateStreamingDistributionError { meta: generic, kind: crate::error::CreateStreamingDistributionErrorKind::TooManyStreamingDistributionCnamEs({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::too_many_streaming_distribution_cnam_es::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_too_many_streaming_distribution_cnam_es_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateStreamingDistributionError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "TooManyStreamingDistributions" => crate::error::CreateStreamingDistributionError { meta: generic, kind: crate::error::CreateStreamingDistributionErrorKind::TooManyStreamingDistributions({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::too_many_streaming_distributions::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_too_many_streaming_distributions_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateStreamingDistributionError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "TooManyTrustedSigners" => crate::error::CreateStreamingDistributionError { meta: generic, kind: crate::error::CreateStreamingDistributionErrorKind::TooManyTrustedSigners({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::too_many_trusted_signers::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_too_many_trusted_signers_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateStreamingDistributionError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "TrustedSignerDoesNotExist" => crate::error::CreateStreamingDistributionError { meta: generic, kind: crate::error::CreateStreamingDistributionErrorKind::TrustedSignerDoesNotExist({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::trusted_signer_does_not_exist::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_trusted_signer_does_not_exist_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateStreamingDistributionError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::CreateStreamingDistributionError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_streaming_distribution_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateStreamingDistributionOutput,
    crate::error::CreateStreamingDistributionError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_streaming_distribution_output::Builder::default();
        let _ = response;
        output = output.set_e_tag(
            crate::http_serde::deser_header_create_streaming_distribution_create_streaming_distribution_output_e_tag(response.headers())
                                    .map_err(|_|crate::error::CreateStreamingDistributionError::unhandled("Failed to parse ETag from header `ETag"))?
        );
        output = output.set_location(
            crate::http_serde::deser_header_create_streaming_distribution_create_streaming_distribution_output_location(response.headers())
                                    .map_err(|_|crate::error::CreateStreamingDistributionError::unhandled("Failed to parse Location from header `Location"))?
        );
        output = output.set_streaming_distribution(
            crate::http_serde::deser_payload_create_streaming_distribution_create_streaming_distribution_output_streaming_distribution(response.body().as_ref())?
        );
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_streaming_distribution_with_tags_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateStreamingDistributionWithTagsOutput,
    crate::error::CreateStreamingDistributionWithTagsError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateStreamingDistributionWithTagsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::CreateStreamingDistributionWithTagsError::unhandled(generic))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDenied" => crate::error::CreateStreamingDistributionWithTagsError { meta: generic, kind: crate::error::CreateStreamingDistributionWithTagsErrorKind::AccessDenied({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::access_denied::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_access_denied_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateStreamingDistributionWithTagsError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "CNAMEAlreadyExists" => crate::error::CreateStreamingDistributionWithTagsError { meta: generic, kind: crate::error::CreateStreamingDistributionWithTagsErrorKind::CnameAlreadyExists({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::cname_already_exists::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_cname_already_exists_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateStreamingDistributionWithTagsError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InconsistentQuantities" => crate::error::CreateStreamingDistributionWithTagsError { meta: generic, kind: crate::error::CreateStreamingDistributionWithTagsErrorKind::InconsistentQuantities({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::inconsistent_quantities::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_inconsistent_quantities_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateStreamingDistributionWithTagsError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidArgument" => crate::error::CreateStreamingDistributionWithTagsError { meta: generic, kind: crate::error::CreateStreamingDistributionWithTagsErrorKind::InvalidArgument({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_argument::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_argument_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateStreamingDistributionWithTagsError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidOrigin" => crate::error::CreateStreamingDistributionWithTagsError { meta: generic, kind: crate::error::CreateStreamingDistributionWithTagsErrorKind::InvalidOrigin({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_origin::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_origin_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateStreamingDistributionWithTagsError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidOriginAccessIdentity" => crate::error::CreateStreamingDistributionWithTagsError { meta: generic, kind: crate::error::CreateStreamingDistributionWithTagsErrorKind::InvalidOriginAccessIdentity({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_origin_access_identity::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_origin_access_identity_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateStreamingDistributionWithTagsError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidTagging" => crate::error::CreateStreamingDistributionWithTagsError { meta: generic, kind: crate::error::CreateStreamingDistributionWithTagsErrorKind::InvalidTagging({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_tagging::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_tagging_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateStreamingDistributionWithTagsError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "MissingBody" => crate::error::CreateStreamingDistributionWithTagsError { meta: generic, kind: crate::error::CreateStreamingDistributionWithTagsErrorKind::MissingBody({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::missing_body::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_missing_body_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateStreamingDistributionWithTagsError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "StreamingDistributionAlreadyExists" => crate::error::CreateStreamingDistributionWithTagsError { meta: generic, kind: crate::error::CreateStreamingDistributionWithTagsErrorKind::StreamingDistributionAlreadyExists({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::streaming_distribution_already_exists::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_streaming_distribution_already_exists_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateStreamingDistributionWithTagsError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "TooManyStreamingDistributionCNAMEs" => crate::error::CreateStreamingDistributionWithTagsError { meta: generic, kind: crate::error::CreateStreamingDistributionWithTagsErrorKind::TooManyStreamingDistributionCnamEs({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::too_many_streaming_distribution_cnam_es::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_too_many_streaming_distribution_cnam_es_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateStreamingDistributionWithTagsError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "TooManyStreamingDistributions" => crate::error::CreateStreamingDistributionWithTagsError { meta: generic, kind: crate::error::CreateStreamingDistributionWithTagsErrorKind::TooManyStreamingDistributions({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::too_many_streaming_distributions::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_too_many_streaming_distributions_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateStreamingDistributionWithTagsError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "TooManyTrustedSigners" => crate::error::CreateStreamingDistributionWithTagsError { meta: generic, kind: crate::error::CreateStreamingDistributionWithTagsErrorKind::TooManyTrustedSigners({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::too_many_trusted_signers::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_too_many_trusted_signers_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateStreamingDistributionWithTagsError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "TrustedSignerDoesNotExist" => crate::error::CreateStreamingDistributionWithTagsError { meta: generic, kind: crate::error::CreateStreamingDistributionWithTagsErrorKind::TrustedSignerDoesNotExist({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::trusted_signer_does_not_exist::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_trusted_signer_does_not_exist_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateStreamingDistributionWithTagsError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::CreateStreamingDistributionWithTagsError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_streaming_distribution_with_tags_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateStreamingDistributionWithTagsOutput,
    crate::error::CreateStreamingDistributionWithTagsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::create_streaming_distribution_with_tags_output::Builder::default();
        let _ = response;
        output = output.set_e_tag(
            crate::http_serde::deser_header_create_streaming_distribution_with_tags_create_streaming_distribution_with_tags_output_e_tag(response.headers())
                                    .map_err(|_|crate::error::CreateStreamingDistributionWithTagsError::unhandled("Failed to parse ETag from header `ETag"))?
        );
        output = output.set_location(
            crate::http_serde::deser_header_create_streaming_distribution_with_tags_create_streaming_distribution_with_tags_output_location(response.headers())
                                    .map_err(|_|crate::error::CreateStreamingDistributionWithTagsError::unhandled("Failed to parse Location from header `Location"))?
        );
        output = output.set_streaming_distribution(
            crate::http_serde::deser_payload_create_streaming_distribution_with_tags_create_streaming_distribution_with_tags_output_streaming_distribution(response.body().as_ref())?
        );
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_cache_policy_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteCachePolicyOutput, crate::error::DeleteCachePolicyError>
{
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteCachePolicyError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DeleteCachePolicyError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDenied" => crate::error::DeleteCachePolicyError {
            meta: generic,
            kind: crate::error::DeleteCachePolicyErrorKind::AccessDenied({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_access_denied_xml_err(
                        response.body().as_ref(),
                        output,
                    )
                    .map_err(crate::error::DeleteCachePolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "CachePolicyInUse" => {
            crate::error::DeleteCachePolicyError {
                meta: generic,
                kind: crate::error::DeleteCachePolicyErrorKind::CachePolicyInUse({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::cache_policy_in_use::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_cache_policy_in_use_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteCachePolicyError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "IllegalDelete" => crate::error::DeleteCachePolicyError {
            meta: generic,
            kind: crate::error::DeleteCachePolicyErrorKind::IllegalDelete({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::illegal_delete::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_illegal_delete_xml_err(
                        response.body().as_ref(),
                        output,
                    )
                    .map_err(crate::error::DeleteCachePolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidIfMatchVersion" => crate::error::DeleteCachePolicyError {
            meta: generic,
            kind: crate::error::DeleteCachePolicyErrorKind::InvalidIfMatchVersion({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_if_match_version::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_if_match_version_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteCachePolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NoSuchCachePolicy" => {
            crate::error::DeleteCachePolicyError {
                meta: generic,
                kind: crate::error::DeleteCachePolicyErrorKind::NoSuchCachePolicy({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::no_such_cache_policy::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_no_such_cache_policy_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteCachePolicyError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "PreconditionFailed" => {
            crate::error::DeleteCachePolicyError {
                meta: generic,
                kind: crate::error::DeleteCachePolicyErrorKind::PreconditionFailed({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::precondition_failed::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_precondition_failed_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteCachePolicyError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::DeleteCachePolicyError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_cache_policy_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteCachePolicyOutput, crate::error::DeleteCachePolicyError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_cache_policy_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_cloud_front_origin_access_identity_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteCloudFrontOriginAccessIdentityOutput,
    crate::error::DeleteCloudFrontOriginAccessIdentityError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteCloudFrontOriginAccessIdentityError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DeleteCloudFrontOriginAccessIdentityError::unhandled(generic))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDenied" => crate::error::DeleteCloudFrontOriginAccessIdentityError { meta: generic, kind: crate::error::DeleteCloudFrontOriginAccessIdentityErrorKind::AccessDenied({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::access_denied::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_access_denied_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteCloudFrontOriginAccessIdentityError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "CloudFrontOriginAccessIdentityInUse" => crate::error::DeleteCloudFrontOriginAccessIdentityError { meta: generic, kind: crate::error::DeleteCloudFrontOriginAccessIdentityErrorKind::CloudFrontOriginAccessIdentityInUse({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::cloud_front_origin_access_identity_in_use::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_cloud_front_origin_access_identity_in_use_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteCloudFrontOriginAccessIdentityError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidIfMatchVersion" => crate::error::DeleteCloudFrontOriginAccessIdentityError { meta: generic, kind: crate::error::DeleteCloudFrontOriginAccessIdentityErrorKind::InvalidIfMatchVersion({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_if_match_version::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_if_match_version_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteCloudFrontOriginAccessIdentityError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "NoSuchCloudFrontOriginAccessIdentity" => crate::error::DeleteCloudFrontOriginAccessIdentityError { meta: generic, kind: crate::error::DeleteCloudFrontOriginAccessIdentityErrorKind::NoSuchCloudFrontOriginAccessIdentity({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::no_such_cloud_front_origin_access_identity::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_no_such_cloud_front_origin_access_identity_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteCloudFrontOriginAccessIdentityError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "PreconditionFailed" => crate::error::DeleteCloudFrontOriginAccessIdentityError { meta: generic, kind: crate::error::DeleteCloudFrontOriginAccessIdentityErrorKind::PreconditionFailed({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::precondition_failed::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_precondition_failed_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteCloudFrontOriginAccessIdentityError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::DeleteCloudFrontOriginAccessIdentityError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_cloud_front_origin_access_identity_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteCloudFrontOriginAccessIdentityOutput,
    crate::error::DeleteCloudFrontOriginAccessIdentityError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::delete_cloud_front_origin_access_identity_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_distribution_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteDistributionOutput,
    crate::error::DeleteDistributionError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteDistributionError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DeleteDistributionError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDenied" => crate::error::DeleteDistributionError {
            meta: generic,
            kind: crate::error::DeleteDistributionErrorKind::AccessDenied({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_access_denied_xml_err(
                        response.body().as_ref(),
                        output,
                    )
                    .map_err(crate::error::DeleteDistributionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "DistributionNotDisabled" => crate::error::DeleteDistributionError {
            meta: generic,
            kind: crate::error::DeleteDistributionErrorKind::DistributionNotDisabled({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::distribution_not_disabled::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_distribution_not_disabled_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteDistributionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidIfMatchVersion" => crate::error::DeleteDistributionError {
            meta: generic,
            kind: crate::error::DeleteDistributionErrorKind::InvalidIfMatchVersion({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_if_match_version::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_if_match_version_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteDistributionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NoSuchDistribution" => {
            crate::error::DeleteDistributionError {
                meta: generic,
                kind: crate::error::DeleteDistributionErrorKind::NoSuchDistribution({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::no_such_distribution::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_no_such_distribution_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteDistributionError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "PreconditionFailed" => {
            crate::error::DeleteDistributionError {
                meta: generic,
                kind: crate::error::DeleteDistributionErrorKind::PreconditionFailed({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::precondition_failed::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_precondition_failed_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteDistributionError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::DeleteDistributionError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_distribution_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteDistributionOutput,
    crate::error::DeleteDistributionError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_distribution_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_field_level_encryption_config_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteFieldLevelEncryptionConfigOutput,
    crate::error::DeleteFieldLevelEncryptionConfigError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteFieldLevelEncryptionConfigError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DeleteFieldLevelEncryptionConfigError::unhandled(generic))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDenied" => crate::error::DeleteFieldLevelEncryptionConfigError { meta: generic, kind: crate::error::DeleteFieldLevelEncryptionConfigErrorKind::AccessDenied({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::access_denied::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_access_denied_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteFieldLevelEncryptionConfigError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "FieldLevelEncryptionConfigInUse" => crate::error::DeleteFieldLevelEncryptionConfigError { meta: generic, kind: crate::error::DeleteFieldLevelEncryptionConfigErrorKind::FieldLevelEncryptionConfigInUse({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::field_level_encryption_config_in_use::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_field_level_encryption_config_in_use_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteFieldLevelEncryptionConfigError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidIfMatchVersion" => crate::error::DeleteFieldLevelEncryptionConfigError { meta: generic, kind: crate::error::DeleteFieldLevelEncryptionConfigErrorKind::InvalidIfMatchVersion({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_if_match_version::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_if_match_version_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteFieldLevelEncryptionConfigError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "NoSuchFieldLevelEncryptionConfig" => crate::error::DeleteFieldLevelEncryptionConfigError { meta: generic, kind: crate::error::DeleteFieldLevelEncryptionConfigErrorKind::NoSuchFieldLevelEncryptionConfig({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::no_such_field_level_encryption_config::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_no_such_field_level_encryption_config_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteFieldLevelEncryptionConfigError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "PreconditionFailed" => crate::error::DeleteFieldLevelEncryptionConfigError { meta: generic, kind: crate::error::DeleteFieldLevelEncryptionConfigErrorKind::PreconditionFailed({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::precondition_failed::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_precondition_failed_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteFieldLevelEncryptionConfigError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::DeleteFieldLevelEncryptionConfigError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_field_level_encryption_config_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteFieldLevelEncryptionConfigOutput,
    crate::error::DeleteFieldLevelEncryptionConfigError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::delete_field_level_encryption_config_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_field_level_encryption_profile_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteFieldLevelEncryptionProfileOutput,
    crate::error::DeleteFieldLevelEncryptionProfileError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteFieldLevelEncryptionProfileError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DeleteFieldLevelEncryptionProfileError::unhandled(generic))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDenied" => crate::error::DeleteFieldLevelEncryptionProfileError { meta: generic, kind: crate::error::DeleteFieldLevelEncryptionProfileErrorKind::AccessDenied({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::access_denied::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_access_denied_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteFieldLevelEncryptionProfileError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "FieldLevelEncryptionProfileInUse" => crate::error::DeleteFieldLevelEncryptionProfileError { meta: generic, kind: crate::error::DeleteFieldLevelEncryptionProfileErrorKind::FieldLevelEncryptionProfileInUse({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::field_level_encryption_profile_in_use::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_field_level_encryption_profile_in_use_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteFieldLevelEncryptionProfileError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidIfMatchVersion" => crate::error::DeleteFieldLevelEncryptionProfileError { meta: generic, kind: crate::error::DeleteFieldLevelEncryptionProfileErrorKind::InvalidIfMatchVersion({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_if_match_version::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_if_match_version_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteFieldLevelEncryptionProfileError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "NoSuchFieldLevelEncryptionProfile" => crate::error::DeleteFieldLevelEncryptionProfileError { meta: generic, kind: crate::error::DeleteFieldLevelEncryptionProfileErrorKind::NoSuchFieldLevelEncryptionProfile({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::no_such_field_level_encryption_profile::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_no_such_field_level_encryption_profile_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteFieldLevelEncryptionProfileError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "PreconditionFailed" => crate::error::DeleteFieldLevelEncryptionProfileError { meta: generic, kind: crate::error::DeleteFieldLevelEncryptionProfileErrorKind::PreconditionFailed({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::precondition_failed::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_precondition_failed_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteFieldLevelEncryptionProfileError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::DeleteFieldLevelEncryptionProfileError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_field_level_encryption_profile_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteFieldLevelEncryptionProfileOutput,
    crate::error::DeleteFieldLevelEncryptionProfileError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::delete_field_level_encryption_profile_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_function_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteFunctionOutput, crate::error::DeleteFunctionError> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteFunctionError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DeleteFunctionError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "FunctionInUse" => crate::error::DeleteFunctionError {
            meta: generic,
            kind: crate::error::DeleteFunctionErrorKind::FunctionInUse({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::function_in_use::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_function_in_use_xml_err(
                        response.body().as_ref(),
                        output,
                    )
                    .map_err(crate::error::DeleteFunctionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidIfMatchVersion" => crate::error::DeleteFunctionError {
            meta: generic,
            kind: crate::error::DeleteFunctionErrorKind::InvalidIfMatchVersion({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_if_match_version::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_if_match_version_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteFunctionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NoSuchFunctionExists" => crate::error::DeleteFunctionError {
            meta: generic,
            kind: crate::error::DeleteFunctionErrorKind::NoSuchFunctionExists({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::no_such_function_exists::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_no_such_function_exists_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteFunctionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "PreconditionFailed" => {
            crate::error::DeleteFunctionError {
                meta: generic,
                kind: crate::error::DeleteFunctionErrorKind::PreconditionFailed({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::precondition_failed::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_precondition_failed_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteFunctionError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "UnsupportedOperation" => crate::error::DeleteFunctionError {
            meta: generic,
            kind: crate::error::DeleteFunctionErrorKind::UnsupportedOperation({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::unsupported_operation::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_unsupported_operation_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteFunctionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DeleteFunctionError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_function_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteFunctionOutput, crate::error::DeleteFunctionError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_function_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_key_group_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteKeyGroupOutput, crate::error::DeleteKeyGroupError> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteKeyGroupError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DeleteKeyGroupError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidIfMatchVersion" => crate::error::DeleteKeyGroupError {
            meta: generic,
            kind: crate::error::DeleteKeyGroupErrorKind::InvalidIfMatchVersion({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_if_match_version::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_if_match_version_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteKeyGroupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NoSuchResource" => crate::error::DeleteKeyGroupError {
            meta: generic,
            kind: crate::error::DeleteKeyGroupErrorKind::NoSuchResource({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::no_such_resource::Builder::default();
                    let _ = response;
                    output =
                        crate::xml_deser::deser_structure_crate_error_no_such_resource_xml_err(
                            response.body().as_ref(),
                            output,
                        )
                        .map_err(crate::error::DeleteKeyGroupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "PreconditionFailed" => {
            crate::error::DeleteKeyGroupError {
                meta: generic,
                kind: crate::error::DeleteKeyGroupErrorKind::PreconditionFailed({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::precondition_failed::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_precondition_failed_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteKeyGroupError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "ResourceInUse" => crate::error::DeleteKeyGroupError {
            meta: generic,
            kind: crate::error::DeleteKeyGroupErrorKind::ResourceInUse({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_in_use::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_resource_in_use_xml_err(
                        response.body().as_ref(),
                        output,
                    )
                    .map_err(crate::error::DeleteKeyGroupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DeleteKeyGroupError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_key_group_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteKeyGroupOutput, crate::error::DeleteKeyGroupError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_key_group_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_monitoring_subscription_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteMonitoringSubscriptionOutput,
    crate::error::DeleteMonitoringSubscriptionError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteMonitoringSubscriptionError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DeleteMonitoringSubscriptionError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDenied" => crate::error::DeleteMonitoringSubscriptionError {
            meta: generic,
            kind: crate::error::DeleteMonitoringSubscriptionErrorKind::AccessDenied({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_access_denied_xml_err(
                        response.body().as_ref(),
                        output,
                    )
                    .map_err(crate::error::DeleteMonitoringSubscriptionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NoSuchDistribution" => {
            crate::error::DeleteMonitoringSubscriptionError {
                meta: generic,
                kind: crate::error::DeleteMonitoringSubscriptionErrorKind::NoSuchDistribution({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::no_such_distribution::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_no_such_distribution_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteMonitoringSubscriptionError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "UnsupportedOperation" => crate::error::DeleteMonitoringSubscriptionError {
            meta: generic,
            kind: crate::error::DeleteMonitoringSubscriptionErrorKind::UnsupportedOperation({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::unsupported_operation::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_unsupported_operation_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteMonitoringSubscriptionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DeleteMonitoringSubscriptionError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_monitoring_subscription_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteMonitoringSubscriptionOutput,
    crate::error::DeleteMonitoringSubscriptionError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_monitoring_subscription_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_origin_request_policy_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteOriginRequestPolicyOutput,
    crate::error::DeleteOriginRequestPolicyError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteOriginRequestPolicyError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DeleteOriginRequestPolicyError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDenied" => crate::error::DeleteOriginRequestPolicyError {
            meta: generic,
            kind: crate::error::DeleteOriginRequestPolicyErrorKind::AccessDenied({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_access_denied_xml_err(
                        response.body().as_ref(),
                        output,
                    )
                    .map_err(crate::error::DeleteOriginRequestPolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "IllegalDelete" => crate::error::DeleteOriginRequestPolicyError {
            meta: generic,
            kind: crate::error::DeleteOriginRequestPolicyErrorKind::IllegalDelete({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::illegal_delete::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_illegal_delete_xml_err(
                        response.body().as_ref(),
                        output,
                    )
                    .map_err(crate::error::DeleteOriginRequestPolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidIfMatchVersion" => crate::error::DeleteOriginRequestPolicyError {
            meta: generic,
            kind: crate::error::DeleteOriginRequestPolicyErrorKind::InvalidIfMatchVersion({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_if_match_version::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_if_match_version_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteOriginRequestPolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NoSuchOriginRequestPolicy" => crate::error::DeleteOriginRequestPolicyError {
            meta: generic,
            kind: crate::error::DeleteOriginRequestPolicyErrorKind::NoSuchOriginRequestPolicy({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::no_such_origin_request_policy::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_no_such_origin_request_policy_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteOriginRequestPolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "OriginRequestPolicyInUse" => crate::error::DeleteOriginRequestPolicyError {
            meta: generic,
            kind: crate::error::DeleteOriginRequestPolicyErrorKind::OriginRequestPolicyInUse({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::origin_request_policy_in_use::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_origin_request_policy_in_use_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteOriginRequestPolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "PreconditionFailed" => {
            crate::error::DeleteOriginRequestPolicyError {
                meta: generic,
                kind: crate::error::DeleteOriginRequestPolicyErrorKind::PreconditionFailed({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::precondition_failed::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_precondition_failed_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteOriginRequestPolicyError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::DeleteOriginRequestPolicyError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_origin_request_policy_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteOriginRequestPolicyOutput,
    crate::error::DeleteOriginRequestPolicyError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_origin_request_policy_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_public_key_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeletePublicKeyOutput, crate::error::DeletePublicKeyError> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeletePublicKeyError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DeletePublicKeyError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDenied" => crate::error::DeletePublicKeyError {
            meta: generic,
            kind: crate::error::DeletePublicKeyErrorKind::AccessDenied({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_access_denied_xml_err(
                        response.body().as_ref(),
                        output,
                    )
                    .map_err(crate::error::DeletePublicKeyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidIfMatchVersion" => crate::error::DeletePublicKeyError {
            meta: generic,
            kind: crate::error::DeletePublicKeyErrorKind::InvalidIfMatchVersion({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_if_match_version::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_if_match_version_xml_err(response.body().as_ref(), output).map_err(crate::error::DeletePublicKeyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NoSuchPublicKey" => {
            crate::error::DeletePublicKeyError {
                meta: generic,
                kind: crate::error::DeletePublicKeyErrorKind::NoSuchPublicKey({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::no_such_public_key::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_no_such_public_key_xml_err(response.body().as_ref(), output).map_err(crate::error::DeletePublicKeyError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "PreconditionFailed" => {
            crate::error::DeletePublicKeyError {
                meta: generic,
                kind: crate::error::DeletePublicKeyErrorKind::PreconditionFailed({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::precondition_failed::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_precondition_failed_xml_err(response.body().as_ref(), output).map_err(crate::error::DeletePublicKeyError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "PublicKeyInUse" => {
            crate::error::DeletePublicKeyError {
                meta: generic,
                kind: crate::error::DeletePublicKeyErrorKind::PublicKeyInUse({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::public_key_in_use::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_public_key_in_use_xml_err(response.body().as_ref(), output).map_err(crate::error::DeletePublicKeyError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::DeletePublicKeyError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_public_key_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeletePublicKeyOutput, crate::error::DeletePublicKeyError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_public_key_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_realtime_log_config_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteRealtimeLogConfigOutput,
    crate::error::DeleteRealtimeLogConfigError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteRealtimeLogConfigError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DeleteRealtimeLogConfigError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDenied" => crate::error::DeleteRealtimeLogConfigError {
            meta: generic,
            kind: crate::error::DeleteRealtimeLogConfigErrorKind::AccessDenied({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_access_denied_xml_err(
                        response.body().as_ref(),
                        output,
                    )
                    .map_err(crate::error::DeleteRealtimeLogConfigError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidArgument" => crate::error::DeleteRealtimeLogConfigError {
            meta: generic,
            kind: crate::error::DeleteRealtimeLogConfigErrorKind::InvalidArgument({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_argument::Builder::default();
                    let _ = response;
                    output =
                        crate::xml_deser::deser_structure_crate_error_invalid_argument_xml_err(
                            response.body().as_ref(),
                            output,
                        )
                        .map_err(crate::error::DeleteRealtimeLogConfigError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NoSuchRealtimeLogConfig" => crate::error::DeleteRealtimeLogConfigError {
            meta: generic,
            kind: crate::error::DeleteRealtimeLogConfigErrorKind::NoSuchRealtimeLogConfig({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::no_such_realtime_log_config::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_no_such_realtime_log_config_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteRealtimeLogConfigError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "RealtimeLogConfigInUse" => crate::error::DeleteRealtimeLogConfigError {
            meta: generic,
            kind: crate::error::DeleteRealtimeLogConfigErrorKind::RealtimeLogConfigInUse({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::realtime_log_config_in_use::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_realtime_log_config_in_use_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteRealtimeLogConfigError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DeleteRealtimeLogConfigError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_realtime_log_config_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteRealtimeLogConfigOutput,
    crate::error::DeleteRealtimeLogConfigError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_realtime_log_config_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_response_headers_policy_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteResponseHeadersPolicyOutput,
    crate::error::DeleteResponseHeadersPolicyError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteResponseHeadersPolicyError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DeleteResponseHeadersPolicyError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDenied" => crate::error::DeleteResponseHeadersPolicyError {
            meta: generic,
            kind: crate::error::DeleteResponseHeadersPolicyErrorKind::AccessDenied({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_access_denied_xml_err(
                        response.body().as_ref(),
                        output,
                    )
                    .map_err(crate::error::DeleteResponseHeadersPolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "IllegalDelete" => crate::error::DeleteResponseHeadersPolicyError {
            meta: generic,
            kind: crate::error::DeleteResponseHeadersPolicyErrorKind::IllegalDelete({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::illegal_delete::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_illegal_delete_xml_err(
                        response.body().as_ref(),
                        output,
                    )
                    .map_err(crate::error::DeleteResponseHeadersPolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidIfMatchVersion" => crate::error::DeleteResponseHeadersPolicyError {
            meta: generic,
            kind: crate::error::DeleteResponseHeadersPolicyErrorKind::InvalidIfMatchVersion({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_if_match_version::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_if_match_version_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteResponseHeadersPolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NoSuchResponseHeadersPolicy" => crate::error::DeleteResponseHeadersPolicyError {
            meta: generic,
            kind: crate::error::DeleteResponseHeadersPolicyErrorKind::NoSuchResponseHeadersPolicy(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::no_such_response_headers_policy::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_no_such_response_headers_policy_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteResponseHeadersPolicyError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        "PreconditionFailed" => {
            crate::error::DeleteResponseHeadersPolicyError {
                meta: generic,
                kind: crate::error::DeleteResponseHeadersPolicyErrorKind::PreconditionFailed({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::precondition_failed::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_precondition_failed_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteResponseHeadersPolicyError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "ResponseHeadersPolicyInUse" => crate::error::DeleteResponseHeadersPolicyError {
            meta: generic,
            kind: crate::error::DeleteResponseHeadersPolicyErrorKind::ResponseHeadersPolicyInUse({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::response_headers_policy_in_use::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_response_headers_policy_in_use_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteResponseHeadersPolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DeleteResponseHeadersPolicyError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_response_headers_policy_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteResponseHeadersPolicyOutput,
    crate::error::DeleteResponseHeadersPolicyError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_response_headers_policy_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_streaming_distribution_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteStreamingDistributionOutput,
    crate::error::DeleteStreamingDistributionError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteStreamingDistributionError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DeleteStreamingDistributionError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDenied" => crate::error::DeleteStreamingDistributionError {
            meta: generic,
            kind: crate::error::DeleteStreamingDistributionErrorKind::AccessDenied({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_access_denied_xml_err(
                        response.body().as_ref(),
                        output,
                    )
                    .map_err(crate::error::DeleteStreamingDistributionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidIfMatchVersion" => crate::error::DeleteStreamingDistributionError {
            meta: generic,
            kind: crate::error::DeleteStreamingDistributionErrorKind::InvalidIfMatchVersion({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_if_match_version::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_if_match_version_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteStreamingDistributionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NoSuchStreamingDistribution" => crate::error::DeleteStreamingDistributionError {
            meta: generic,
            kind: crate::error::DeleteStreamingDistributionErrorKind::NoSuchStreamingDistribution(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::no_such_streaming_distribution::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_no_such_streaming_distribution_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteStreamingDistributionError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        "PreconditionFailed" => {
            crate::error::DeleteStreamingDistributionError {
                meta: generic,
                kind: crate::error::DeleteStreamingDistributionErrorKind::PreconditionFailed({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::precondition_failed::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_precondition_failed_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteStreamingDistributionError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "StreamingDistributionNotDisabled" => crate::error::DeleteStreamingDistributionError {
            meta: generic,
            kind:
                crate::error::DeleteStreamingDistributionErrorKind::StreamingDistributionNotDisabled(
                    {
                        #[allow(unused_mut)]
                        let mut tmp = {
                            #[allow(unused_mut)]
                            let mut output =
                                crate::error::streaming_distribution_not_disabled::Builder::default(
                                );
                            let _ = response;
                            output = crate::xml_deser::deser_structure_crate_error_streaming_distribution_not_disabled_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteStreamingDistributionError::unhandled)?;
                            output.build()
                        };
                        if (&tmp.message).is_none() {
                            tmp.message = _error_message;
                        }
                        tmp
                    },
                ),
        },
        _ => crate::error::DeleteStreamingDistributionError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_streaming_distribution_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteStreamingDistributionOutput,
    crate::error::DeleteStreamingDistributionError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_streaming_distribution_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_function_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DescribeFunctionOutput, crate::error::DescribeFunctionError>
{
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeFunctionError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DescribeFunctionError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "NoSuchFunctionExists" => crate::error::DescribeFunctionError {
            meta: generic,
            kind: crate::error::DescribeFunctionErrorKind::NoSuchFunctionExists({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::no_such_function_exists::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_no_such_function_exists_xml_err(response.body().as_ref(), output).map_err(crate::error::DescribeFunctionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "UnsupportedOperation" => crate::error::DescribeFunctionError {
            meta: generic,
            kind: crate::error::DescribeFunctionErrorKind::UnsupportedOperation({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::unsupported_operation::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_unsupported_operation_xml_err(response.body().as_ref(), output).map_err(crate::error::DescribeFunctionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DescribeFunctionError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_function_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DescribeFunctionOutput, crate::error::DescribeFunctionError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_function_output::Builder::default();
        let _ = response;
        output = output.set_e_tag(
            crate::http_serde::deser_header_describe_function_describe_function_output_e_tag(
                response.headers(),
            )
            .map_err(|_| {
                crate::error::DescribeFunctionError::unhandled(
                    "Failed to parse ETag from header `ETag",
                )
            })?,
        );
        output = output.set_function_summary(
            crate::http_serde::deser_payload_describe_function_describe_function_output_function_summary(response.body().as_ref())?
        );
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_cache_policy_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetCachePolicyOutput, crate::error::GetCachePolicyError> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetCachePolicyError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::GetCachePolicyError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDenied" => crate::error::GetCachePolicyError {
            meta: generic,
            kind: crate::error::GetCachePolicyErrorKind::AccessDenied({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_access_denied_xml_err(
                        response.body().as_ref(),
                        output,
                    )
                    .map_err(crate::error::GetCachePolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NoSuchCachePolicy" => {
            crate::error::GetCachePolicyError {
                meta: generic,
                kind: crate::error::GetCachePolicyErrorKind::NoSuchCachePolicy({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::no_such_cache_policy::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_no_such_cache_policy_xml_err(response.body().as_ref(), output).map_err(crate::error::GetCachePolicyError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::GetCachePolicyError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_cache_policy_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetCachePolicyOutput, crate::error::GetCachePolicyError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_cache_policy_output::Builder::default();
        let _ = response;
        output = output.set_cache_policy(
            crate::http_serde::deser_payload_get_cache_policy_get_cache_policy_output_cache_policy(
                response.body().as_ref(),
            )?,
        );
        output = output.set_e_tag(
            crate::http_serde::deser_header_get_cache_policy_get_cache_policy_output_e_tag(
                response.headers(),
            )
            .map_err(|_| {
                crate::error::GetCachePolicyError::unhandled(
                    "Failed to parse ETag from header `ETag",
                )
            })?,
        );
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_cache_policy_config_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetCachePolicyConfigOutput,
    crate::error::GetCachePolicyConfigError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetCachePolicyConfigError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::GetCachePolicyConfigError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDenied" => crate::error::GetCachePolicyConfigError {
            meta: generic,
            kind: crate::error::GetCachePolicyConfigErrorKind::AccessDenied({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_access_denied_xml_err(
                        response.body().as_ref(),
                        output,
                    )
                    .map_err(crate::error::GetCachePolicyConfigError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NoSuchCachePolicy" => {
            crate::error::GetCachePolicyConfigError {
                meta: generic,
                kind: crate::error::GetCachePolicyConfigErrorKind::NoSuchCachePolicy({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::no_such_cache_policy::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_no_such_cache_policy_xml_err(response.body().as_ref(), output).map_err(crate::error::GetCachePolicyConfigError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::GetCachePolicyConfigError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_cache_policy_config_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetCachePolicyConfigOutput,
    crate::error::GetCachePolicyConfigError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_cache_policy_config_output::Builder::default();
        let _ = response;
        output = output.set_cache_policy_config(
            crate::http_serde::deser_payload_get_cache_policy_config_get_cache_policy_config_output_cache_policy_config(response.body().as_ref())?
        );
        output = output.set_e_tag(
            crate::http_serde::deser_header_get_cache_policy_config_get_cache_policy_config_output_e_tag(response.headers())
                                    .map_err(|_|crate::error::GetCachePolicyConfigError::unhandled("Failed to parse ETag from header `ETag"))?
        );
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_cloud_front_origin_access_identity_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetCloudFrontOriginAccessIdentityOutput,
    crate::error::GetCloudFrontOriginAccessIdentityError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetCloudFrontOriginAccessIdentityError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::GetCloudFrontOriginAccessIdentityError::unhandled(generic))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDenied" => crate::error::GetCloudFrontOriginAccessIdentityError { meta: generic, kind: crate::error::GetCloudFrontOriginAccessIdentityErrorKind::AccessDenied({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::access_denied::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_access_denied_xml_err(response.body().as_ref(), output).map_err(crate::error::GetCloudFrontOriginAccessIdentityError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "NoSuchCloudFrontOriginAccessIdentity" => crate::error::GetCloudFrontOriginAccessIdentityError { meta: generic, kind: crate::error::GetCloudFrontOriginAccessIdentityErrorKind::NoSuchCloudFrontOriginAccessIdentity({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::no_such_cloud_front_origin_access_identity::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_no_such_cloud_front_origin_access_identity_xml_err(response.body().as_ref(), output).map_err(crate::error::GetCloudFrontOriginAccessIdentityError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::GetCloudFrontOriginAccessIdentityError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_cloud_front_origin_access_identity_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetCloudFrontOriginAccessIdentityOutput,
    crate::error::GetCloudFrontOriginAccessIdentityError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::get_cloud_front_origin_access_identity_output::Builder::default();
        let _ = response;
        output = output.set_cloud_front_origin_access_identity(
            crate::http_serde::deser_payload_get_cloud_front_origin_access_identity_get_cloud_front_origin_access_identity_output_cloud_front_origin_access_identity(response.body().as_ref())?
        );
        output = output.set_e_tag(
            crate::http_serde::deser_header_get_cloud_front_origin_access_identity_get_cloud_front_origin_access_identity_output_e_tag(response.headers())
                                    .map_err(|_|crate::error::GetCloudFrontOriginAccessIdentityError::unhandled("Failed to parse ETag from header `ETag"))?
        );
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_cloud_front_origin_access_identity_config_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetCloudFrontOriginAccessIdentityConfigOutput,
    crate::error::GetCloudFrontOriginAccessIdentityConfigError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetCloudFrontOriginAccessIdentityConfigError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(
                crate::error::GetCloudFrontOriginAccessIdentityConfigError::unhandled(generic),
            )
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDenied" => crate::error::GetCloudFrontOriginAccessIdentityConfigError { meta: generic, kind: crate::error::GetCloudFrontOriginAccessIdentityConfigErrorKind::AccessDenied({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::access_denied::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_access_denied_xml_err(response.body().as_ref(), output).map_err(crate::error::GetCloudFrontOriginAccessIdentityConfigError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "NoSuchCloudFrontOriginAccessIdentity" => crate::error::GetCloudFrontOriginAccessIdentityConfigError { meta: generic, kind: crate::error::GetCloudFrontOriginAccessIdentityConfigErrorKind::NoSuchCloudFrontOriginAccessIdentity({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::no_such_cloud_front_origin_access_identity::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_no_such_cloud_front_origin_access_identity_xml_err(response.body().as_ref(), output).map_err(crate::error::GetCloudFrontOriginAccessIdentityConfigError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::GetCloudFrontOriginAccessIdentityConfigError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_cloud_front_origin_access_identity_config_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetCloudFrontOriginAccessIdentityConfigOutput,
    crate::error::GetCloudFrontOriginAccessIdentityConfigError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::get_cloud_front_origin_access_identity_config_output::Builder::default();
        let _ = response;
        output = output.set_cloud_front_origin_access_identity_config(
            crate::http_serde::deser_payload_get_cloud_front_origin_access_identity_config_get_cloud_front_origin_access_identity_config_output_cloud_front_origin_access_identity_config(response.body().as_ref())?
        );
        output = output.set_e_tag(
            crate::http_serde::deser_header_get_cloud_front_origin_access_identity_config_get_cloud_front_origin_access_identity_config_output_e_tag(response.headers())
                                    .map_err(|_|crate::error::GetCloudFrontOriginAccessIdentityConfigError::unhandled("Failed to parse ETag from header `ETag"))?
        );
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_distribution_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetDistributionOutput, crate::error::GetDistributionError> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetDistributionError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::GetDistributionError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDenied" => crate::error::GetDistributionError {
            meta: generic,
            kind: crate::error::GetDistributionErrorKind::AccessDenied({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_access_denied_xml_err(
                        response.body().as_ref(),
                        output,
                    )
                    .map_err(crate::error::GetDistributionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NoSuchDistribution" => {
            crate::error::GetDistributionError {
                meta: generic,
                kind: crate::error::GetDistributionErrorKind::NoSuchDistribution({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::no_such_distribution::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_no_such_distribution_xml_err(response.body().as_ref(), output).map_err(crate::error::GetDistributionError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::GetDistributionError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_distribution_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetDistributionOutput, crate::error::GetDistributionError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_distribution_output::Builder::default();
        let _ = response;
        output = output.set_distribution(
            crate::http_serde::deser_payload_get_distribution_get_distribution_output_distribution(
                response.body().as_ref(),
            )?,
        );
        output = output.set_e_tag(
            crate::http_serde::deser_header_get_distribution_get_distribution_output_e_tag(
                response.headers(),
            )
            .map_err(|_| {
                crate::error::GetDistributionError::unhandled(
                    "Failed to parse ETag from header `ETag",
                )
            })?,
        );
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_distribution_config_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetDistributionConfigOutput,
    crate::error::GetDistributionConfigError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetDistributionConfigError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::GetDistributionConfigError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDenied" => crate::error::GetDistributionConfigError {
            meta: generic,
            kind: crate::error::GetDistributionConfigErrorKind::AccessDenied({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_access_denied_xml_err(
                        response.body().as_ref(),
                        output,
                    )
                    .map_err(crate::error::GetDistributionConfigError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NoSuchDistribution" => {
            crate::error::GetDistributionConfigError {
                meta: generic,
                kind: crate::error::GetDistributionConfigErrorKind::NoSuchDistribution({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::no_such_distribution::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_no_such_distribution_xml_err(response.body().as_ref(), output).map_err(crate::error::GetDistributionConfigError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::GetDistributionConfigError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_distribution_config_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetDistributionConfigOutput,
    crate::error::GetDistributionConfigError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_distribution_config_output::Builder::default();
        let _ = response;
        output = output.set_distribution_config(
            crate::http_serde::deser_payload_get_distribution_config_get_distribution_config_output_distribution_config(response.body().as_ref())?
        );
        output = output.set_e_tag(
            crate::http_serde::deser_header_get_distribution_config_get_distribution_config_output_e_tag(response.headers())
                                    .map_err(|_|crate::error::GetDistributionConfigError::unhandled("Failed to parse ETag from header `ETag"))?
        );
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_field_level_encryption_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetFieldLevelEncryptionOutput,
    crate::error::GetFieldLevelEncryptionError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetFieldLevelEncryptionError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::GetFieldLevelEncryptionError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDenied" => crate::error::GetFieldLevelEncryptionError {
            meta: generic,
            kind: crate::error::GetFieldLevelEncryptionErrorKind::AccessDenied({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_access_denied_xml_err(
                        response.body().as_ref(),
                        output,
                    )
                    .map_err(crate::error::GetFieldLevelEncryptionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NoSuchFieldLevelEncryptionConfig" => crate::error::GetFieldLevelEncryptionError {
            meta: generic,
            kind: crate::error::GetFieldLevelEncryptionErrorKind::NoSuchFieldLevelEncryptionConfig(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::no_such_field_level_encryption_config::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_no_such_field_level_encryption_config_xml_err(response.body().as_ref(), output).map_err(crate::error::GetFieldLevelEncryptionError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        _ => crate::error::GetFieldLevelEncryptionError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_field_level_encryption_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetFieldLevelEncryptionOutput,
    crate::error::GetFieldLevelEncryptionError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_field_level_encryption_output::Builder::default();
        let _ = response;
        output = output.set_e_tag(
            crate::http_serde::deser_header_get_field_level_encryption_get_field_level_encryption_output_e_tag(response.headers())
                                    .map_err(|_|crate::error::GetFieldLevelEncryptionError::unhandled("Failed to parse ETag from header `ETag"))?
        );
        output = output.set_field_level_encryption(
            crate::http_serde::deser_payload_get_field_level_encryption_get_field_level_encryption_output_field_level_encryption(response.body().as_ref())?
        );
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_field_level_encryption_config_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetFieldLevelEncryptionConfigOutput,
    crate::error::GetFieldLevelEncryptionConfigError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetFieldLevelEncryptionConfigError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::GetFieldLevelEncryptionConfigError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDenied" => crate::error::GetFieldLevelEncryptionConfigError { meta: generic, kind: crate::error::GetFieldLevelEncryptionConfigErrorKind::AccessDenied({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::access_denied::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_access_denied_xml_err(response.body().as_ref(), output).map_err(crate::error::GetFieldLevelEncryptionConfigError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "NoSuchFieldLevelEncryptionConfig" => crate::error::GetFieldLevelEncryptionConfigError { meta: generic, kind: crate::error::GetFieldLevelEncryptionConfigErrorKind::NoSuchFieldLevelEncryptionConfig({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::no_such_field_level_encryption_config::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_no_such_field_level_encryption_config_xml_err(response.body().as_ref(), output).map_err(crate::error::GetFieldLevelEncryptionConfigError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::GetFieldLevelEncryptionConfigError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_field_level_encryption_config_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetFieldLevelEncryptionConfigOutput,
    crate::error::GetFieldLevelEncryptionConfigError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::get_field_level_encryption_config_output::Builder::default();
        let _ = response;
        output = output.set_e_tag(
            crate::http_serde::deser_header_get_field_level_encryption_config_get_field_level_encryption_config_output_e_tag(response.headers())
                                    .map_err(|_|crate::error::GetFieldLevelEncryptionConfigError::unhandled("Failed to parse ETag from header `ETag"))?
        );
        output = output.set_field_level_encryption_config(
            crate::http_serde::deser_payload_get_field_level_encryption_config_get_field_level_encryption_config_output_field_level_encryption_config(response.body().as_ref())?
        );
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_field_level_encryption_profile_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetFieldLevelEncryptionProfileOutput,
    crate::error::GetFieldLevelEncryptionProfileError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetFieldLevelEncryptionProfileError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::GetFieldLevelEncryptionProfileError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDenied" => crate::error::GetFieldLevelEncryptionProfileError { meta: generic, kind: crate::error::GetFieldLevelEncryptionProfileErrorKind::AccessDenied({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::access_denied::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_access_denied_xml_err(response.body().as_ref(), output).map_err(crate::error::GetFieldLevelEncryptionProfileError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "NoSuchFieldLevelEncryptionProfile" => crate::error::GetFieldLevelEncryptionProfileError { meta: generic, kind: crate::error::GetFieldLevelEncryptionProfileErrorKind::NoSuchFieldLevelEncryptionProfile({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::no_such_field_level_encryption_profile::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_no_such_field_level_encryption_profile_xml_err(response.body().as_ref(), output).map_err(crate::error::GetFieldLevelEncryptionProfileError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::GetFieldLevelEncryptionProfileError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_field_level_encryption_profile_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetFieldLevelEncryptionProfileOutput,
    crate::error::GetFieldLevelEncryptionProfileError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::get_field_level_encryption_profile_output::Builder::default();
        let _ = response;
        output = output.set_e_tag(
            crate::http_serde::deser_header_get_field_level_encryption_profile_get_field_level_encryption_profile_output_e_tag(response.headers())
                                    .map_err(|_|crate::error::GetFieldLevelEncryptionProfileError::unhandled("Failed to parse ETag from header `ETag"))?
        );
        output = output.set_field_level_encryption_profile(
            crate::http_serde::deser_payload_get_field_level_encryption_profile_get_field_level_encryption_profile_output_field_level_encryption_profile(response.body().as_ref())?
        );
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_field_level_encryption_profile_config_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetFieldLevelEncryptionProfileConfigOutput,
    crate::error::GetFieldLevelEncryptionProfileConfigError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetFieldLevelEncryptionProfileConfigError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::GetFieldLevelEncryptionProfileConfigError::unhandled(generic))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDenied" => crate::error::GetFieldLevelEncryptionProfileConfigError { meta: generic, kind: crate::error::GetFieldLevelEncryptionProfileConfigErrorKind::AccessDenied({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::access_denied::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_access_denied_xml_err(response.body().as_ref(), output).map_err(crate::error::GetFieldLevelEncryptionProfileConfigError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "NoSuchFieldLevelEncryptionProfile" => crate::error::GetFieldLevelEncryptionProfileConfigError { meta: generic, kind: crate::error::GetFieldLevelEncryptionProfileConfigErrorKind::NoSuchFieldLevelEncryptionProfile({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::no_such_field_level_encryption_profile::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_no_such_field_level_encryption_profile_xml_err(response.body().as_ref(), output).map_err(crate::error::GetFieldLevelEncryptionProfileConfigError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::GetFieldLevelEncryptionProfileConfigError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_field_level_encryption_profile_config_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetFieldLevelEncryptionProfileConfigOutput,
    crate::error::GetFieldLevelEncryptionProfileConfigError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::get_field_level_encryption_profile_config_output::Builder::default();
        let _ = response;
        output = output.set_e_tag(
            crate::http_serde::deser_header_get_field_level_encryption_profile_config_get_field_level_encryption_profile_config_output_e_tag(response.headers())
                                    .map_err(|_|crate::error::GetFieldLevelEncryptionProfileConfigError::unhandled("Failed to parse ETag from header `ETag"))?
        );
        output = output.set_field_level_encryption_profile_config(
            crate::http_serde::deser_payload_get_field_level_encryption_profile_config_get_field_level_encryption_profile_config_output_field_level_encryption_profile_config(response.body().as_ref())?
        );
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_function_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetFunctionOutput, crate::error::GetFunctionError> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetFunctionError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::GetFunctionError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "NoSuchFunctionExists" => crate::error::GetFunctionError {
            meta: generic,
            kind: crate::error::GetFunctionErrorKind::NoSuchFunctionExists({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::no_such_function_exists::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_no_such_function_exists_xml_err(response.body().as_ref(), output).map_err(crate::error::GetFunctionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "UnsupportedOperation" => crate::error::GetFunctionError {
            meta: generic,
            kind: crate::error::GetFunctionErrorKind::UnsupportedOperation({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::unsupported_operation::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_unsupported_operation_xml_err(response.body().as_ref(), output).map_err(crate::error::GetFunctionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::GetFunctionError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_function_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetFunctionOutput, crate::error::GetFunctionError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_function_output::Builder::default();
        let _ = response;
        output = output.set_content_type(
            crate::http_serde::deser_header_get_function_get_function_output_content_type(
                response.headers(),
            )
            .map_err(|_| {
                crate::error::GetFunctionError::unhandled(
                    "Failed to parse ContentType from header `Content-Type",
                )
            })?,
        );
        output = output.set_e_tag(
            crate::http_serde::deser_header_get_function_get_function_output_e_tag(
                response.headers(),
            )
            .map_err(|_| {
                crate::error::GetFunctionError::unhandled("Failed to parse ETag from header `ETag")
            })?,
        );
        output = output.set_function_code(
            crate::http_serde::deser_payload_get_function_get_function_output_function_code(
                response.body().as_ref(),
            )?,
        );
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_invalidation_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetInvalidationOutput, crate::error::GetInvalidationError> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetInvalidationError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::GetInvalidationError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDenied" => crate::error::GetInvalidationError {
            meta: generic,
            kind: crate::error::GetInvalidationErrorKind::AccessDenied({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_access_denied_xml_err(
                        response.body().as_ref(),
                        output,
                    )
                    .map_err(crate::error::GetInvalidationError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NoSuchDistribution" => {
            crate::error::GetInvalidationError {
                meta: generic,
                kind: crate::error::GetInvalidationErrorKind::NoSuchDistribution({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::no_such_distribution::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_no_such_distribution_xml_err(response.body().as_ref(), output).map_err(crate::error::GetInvalidationError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "NoSuchInvalidation" => {
            crate::error::GetInvalidationError {
                meta: generic,
                kind: crate::error::GetInvalidationErrorKind::NoSuchInvalidation({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::no_such_invalidation::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_no_such_invalidation_xml_err(response.body().as_ref(), output).map_err(crate::error::GetInvalidationError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::GetInvalidationError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_invalidation_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetInvalidationOutput, crate::error::GetInvalidationError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_invalidation_output::Builder::default();
        let _ = response;
        output = output.set_invalidation(
            crate::http_serde::deser_payload_get_invalidation_get_invalidation_output_invalidation(
                response.body().as_ref(),
            )?,
        );
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_key_group_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetKeyGroupOutput, crate::error::GetKeyGroupError> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetKeyGroupError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::GetKeyGroupError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "NoSuchResource" => crate::error::GetKeyGroupError {
            meta: generic,
            kind: crate::error::GetKeyGroupErrorKind::NoSuchResource({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::no_such_resource::Builder::default();
                    let _ = response;
                    output =
                        crate::xml_deser::deser_structure_crate_error_no_such_resource_xml_err(
                            response.body().as_ref(),
                            output,
                        )
                        .map_err(crate::error::GetKeyGroupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::GetKeyGroupError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_key_group_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetKeyGroupOutput, crate::error::GetKeyGroupError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_key_group_output::Builder::default();
        let _ = response;
        output = output.set_e_tag(
            crate::http_serde::deser_header_get_key_group_get_key_group_output_e_tag(
                response.headers(),
            )
            .map_err(|_| {
                crate::error::GetKeyGroupError::unhandled("Failed to parse ETag from header `ETag")
            })?,
        );
        output = output.set_key_group(
            crate::http_serde::deser_payload_get_key_group_get_key_group_output_key_group(
                response.body().as_ref(),
            )?,
        );
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_key_group_config_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetKeyGroupConfigOutput, crate::error::GetKeyGroupConfigError>
{
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetKeyGroupConfigError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::GetKeyGroupConfigError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "NoSuchResource" => crate::error::GetKeyGroupConfigError {
            meta: generic,
            kind: crate::error::GetKeyGroupConfigErrorKind::NoSuchResource({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::no_such_resource::Builder::default();
                    let _ = response;
                    output =
                        crate::xml_deser::deser_structure_crate_error_no_such_resource_xml_err(
                            response.body().as_ref(),
                            output,
                        )
                        .map_err(crate::error::GetKeyGroupConfigError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::GetKeyGroupConfigError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_key_group_config_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetKeyGroupConfigOutput, crate::error::GetKeyGroupConfigError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_key_group_config_output::Builder::default();
        let _ = response;
        output = output.set_e_tag(
            crate::http_serde::deser_header_get_key_group_config_get_key_group_config_output_e_tag(
                response.headers(),
            )
            .map_err(|_| {
                crate::error::GetKeyGroupConfigError::unhandled(
                    "Failed to parse ETag from header `ETag",
                )
            })?,
        );
        output = output.set_key_group_config(
            crate::http_serde::deser_payload_get_key_group_config_get_key_group_config_output_key_group_config(response.body().as_ref())?
        );
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_monitoring_subscription_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetMonitoringSubscriptionOutput,
    crate::error::GetMonitoringSubscriptionError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetMonitoringSubscriptionError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::GetMonitoringSubscriptionError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDenied" => crate::error::GetMonitoringSubscriptionError {
            meta: generic,
            kind: crate::error::GetMonitoringSubscriptionErrorKind::AccessDenied({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_access_denied_xml_err(
                        response.body().as_ref(),
                        output,
                    )
                    .map_err(crate::error::GetMonitoringSubscriptionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NoSuchDistribution" => {
            crate::error::GetMonitoringSubscriptionError {
                meta: generic,
                kind: crate::error::GetMonitoringSubscriptionErrorKind::NoSuchDistribution({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::no_such_distribution::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_no_such_distribution_xml_err(response.body().as_ref(), output).map_err(crate::error::GetMonitoringSubscriptionError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "UnsupportedOperation" => crate::error::GetMonitoringSubscriptionError {
            meta: generic,
            kind: crate::error::GetMonitoringSubscriptionErrorKind::UnsupportedOperation({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::unsupported_operation::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_unsupported_operation_xml_err(response.body().as_ref(), output).map_err(crate::error::GetMonitoringSubscriptionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::GetMonitoringSubscriptionError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_monitoring_subscription_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetMonitoringSubscriptionOutput,
    crate::error::GetMonitoringSubscriptionError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_monitoring_subscription_output::Builder::default();
        let _ = response;
        output = output.set_monitoring_subscription(
            crate::http_serde::deser_payload_get_monitoring_subscription_get_monitoring_subscription_output_monitoring_subscription(response.body().as_ref())?
        );
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_origin_request_policy_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetOriginRequestPolicyOutput,
    crate::error::GetOriginRequestPolicyError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetOriginRequestPolicyError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::GetOriginRequestPolicyError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDenied" => crate::error::GetOriginRequestPolicyError {
            meta: generic,
            kind: crate::error::GetOriginRequestPolicyErrorKind::AccessDenied({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_access_denied_xml_err(
                        response.body().as_ref(),
                        output,
                    )
                    .map_err(crate::error::GetOriginRequestPolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NoSuchOriginRequestPolicy" => crate::error::GetOriginRequestPolicyError {
            meta: generic,
            kind: crate::error::GetOriginRequestPolicyErrorKind::NoSuchOriginRequestPolicy({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::no_such_origin_request_policy::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_no_such_origin_request_policy_xml_err(response.body().as_ref(), output).map_err(crate::error::GetOriginRequestPolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::GetOriginRequestPolicyError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_origin_request_policy_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetOriginRequestPolicyOutput,
    crate::error::GetOriginRequestPolicyError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_origin_request_policy_output::Builder::default();
        let _ = response;
        output = output.set_e_tag(
            crate::http_serde::deser_header_get_origin_request_policy_get_origin_request_policy_output_e_tag(response.headers())
                                    .map_err(|_|crate::error::GetOriginRequestPolicyError::unhandled("Failed to parse ETag from header `ETag"))?
        );
        output = output.set_origin_request_policy(
            crate::http_serde::deser_payload_get_origin_request_policy_get_origin_request_policy_output_origin_request_policy(response.body().as_ref())?
        );
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_origin_request_policy_config_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetOriginRequestPolicyConfigOutput,
    crate::error::GetOriginRequestPolicyConfigError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetOriginRequestPolicyConfigError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::GetOriginRequestPolicyConfigError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDenied" => crate::error::GetOriginRequestPolicyConfigError {
            meta: generic,
            kind: crate::error::GetOriginRequestPolicyConfigErrorKind::AccessDenied({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_access_denied_xml_err(
                        response.body().as_ref(),
                        output,
                    )
                    .map_err(crate::error::GetOriginRequestPolicyConfigError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NoSuchOriginRequestPolicy" => crate::error::GetOriginRequestPolicyConfigError {
            meta: generic,
            kind: crate::error::GetOriginRequestPolicyConfigErrorKind::NoSuchOriginRequestPolicy({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::no_such_origin_request_policy::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_no_such_origin_request_policy_xml_err(response.body().as_ref(), output).map_err(crate::error::GetOriginRequestPolicyConfigError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::GetOriginRequestPolicyConfigError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_origin_request_policy_config_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetOriginRequestPolicyConfigOutput,
    crate::error::GetOriginRequestPolicyConfigError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_origin_request_policy_config_output::Builder::default();
        let _ = response;
        output = output.set_e_tag(
            crate::http_serde::deser_header_get_origin_request_policy_config_get_origin_request_policy_config_output_e_tag(response.headers())
                                    .map_err(|_|crate::error::GetOriginRequestPolicyConfigError::unhandled("Failed to parse ETag from header `ETag"))?
        );
        output = output.set_origin_request_policy_config(
            crate::http_serde::deser_payload_get_origin_request_policy_config_get_origin_request_policy_config_output_origin_request_policy_config(response.body().as_ref())?
        );
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_public_key_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetPublicKeyOutput, crate::error::GetPublicKeyError> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetPublicKeyError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::GetPublicKeyError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDenied" => crate::error::GetPublicKeyError {
            meta: generic,
            kind: crate::error::GetPublicKeyErrorKind::AccessDenied({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_access_denied_xml_err(
                        response.body().as_ref(),
                        output,
                    )
                    .map_err(crate::error::GetPublicKeyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NoSuchPublicKey" => {
            crate::error::GetPublicKeyError {
                meta: generic,
                kind: crate::error::GetPublicKeyErrorKind::NoSuchPublicKey({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::no_such_public_key::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_no_such_public_key_xml_err(response.body().as_ref(), output).map_err(crate::error::GetPublicKeyError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::GetPublicKeyError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_public_key_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetPublicKeyOutput, crate::error::GetPublicKeyError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_public_key_output::Builder::default();
        let _ = response;
        output = output.set_e_tag(
            crate::http_serde::deser_header_get_public_key_get_public_key_output_e_tag(
                response.headers(),
            )
            .map_err(|_| {
                crate::error::GetPublicKeyError::unhandled("Failed to parse ETag from header `ETag")
            })?,
        );
        output = output.set_public_key(
            crate::http_serde::deser_payload_get_public_key_get_public_key_output_public_key(
                response.body().as_ref(),
            )?,
        );
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_public_key_config_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetPublicKeyConfigOutput,
    crate::error::GetPublicKeyConfigError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetPublicKeyConfigError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::GetPublicKeyConfigError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDenied" => crate::error::GetPublicKeyConfigError {
            meta: generic,
            kind: crate::error::GetPublicKeyConfigErrorKind::AccessDenied({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_access_denied_xml_err(
                        response.body().as_ref(),
                        output,
                    )
                    .map_err(crate::error::GetPublicKeyConfigError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NoSuchPublicKey" => {
            crate::error::GetPublicKeyConfigError {
                meta: generic,
                kind: crate::error::GetPublicKeyConfigErrorKind::NoSuchPublicKey({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::no_such_public_key::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_no_such_public_key_xml_err(response.body().as_ref(), output).map_err(crate::error::GetPublicKeyConfigError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::GetPublicKeyConfigError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_public_key_config_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetPublicKeyConfigOutput,
    crate::error::GetPublicKeyConfigError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_public_key_config_output::Builder::default();
        let _ = response;
        output = output.set_e_tag(
            crate::http_serde::deser_header_get_public_key_config_get_public_key_config_output_e_tag(response.headers())
                                    .map_err(|_|crate::error::GetPublicKeyConfigError::unhandled("Failed to parse ETag from header `ETag"))?
        );
        output = output.set_public_key_config(
            crate::http_serde::deser_payload_get_public_key_config_get_public_key_config_output_public_key_config(response.body().as_ref())?
        );
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_realtime_log_config_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetRealtimeLogConfigOutput,
    crate::error::GetRealtimeLogConfigError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetRealtimeLogConfigError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::GetRealtimeLogConfigError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDenied" => crate::error::GetRealtimeLogConfigError {
            meta: generic,
            kind: crate::error::GetRealtimeLogConfigErrorKind::AccessDenied({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_access_denied_xml_err(
                        response.body().as_ref(),
                        output,
                    )
                    .map_err(crate::error::GetRealtimeLogConfigError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidArgument" => crate::error::GetRealtimeLogConfigError {
            meta: generic,
            kind: crate::error::GetRealtimeLogConfigErrorKind::InvalidArgument({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_argument::Builder::default();
                    let _ = response;
                    output =
                        crate::xml_deser::deser_structure_crate_error_invalid_argument_xml_err(
                            response.body().as_ref(),
                            output,
                        )
                        .map_err(crate::error::GetRealtimeLogConfigError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NoSuchRealtimeLogConfig" => crate::error::GetRealtimeLogConfigError {
            meta: generic,
            kind: crate::error::GetRealtimeLogConfigErrorKind::NoSuchRealtimeLogConfig({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::no_such_realtime_log_config::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_no_such_realtime_log_config_xml_err(response.body().as_ref(), output).map_err(crate::error::GetRealtimeLogConfigError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::GetRealtimeLogConfigError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_realtime_log_config_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetRealtimeLogConfigOutput,
    crate::error::GetRealtimeLogConfigError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_realtime_log_config_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_get_realtime_log_config(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::GetRealtimeLogConfigError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_response_headers_policy_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetResponseHeadersPolicyOutput,
    crate::error::GetResponseHeadersPolicyError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetResponseHeadersPolicyError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::GetResponseHeadersPolicyError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDenied" => crate::error::GetResponseHeadersPolicyError {
            meta: generic,
            kind: crate::error::GetResponseHeadersPolicyErrorKind::AccessDenied({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_access_denied_xml_err(
                        response.body().as_ref(),
                        output,
                    )
                    .map_err(crate::error::GetResponseHeadersPolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NoSuchResponseHeadersPolicy" => crate::error::GetResponseHeadersPolicyError {
            meta: generic,
            kind: crate::error::GetResponseHeadersPolicyErrorKind::NoSuchResponseHeadersPolicy({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::no_such_response_headers_policy::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_no_such_response_headers_policy_xml_err(response.body().as_ref(), output).map_err(crate::error::GetResponseHeadersPolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::GetResponseHeadersPolicyError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_response_headers_policy_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetResponseHeadersPolicyOutput,
    crate::error::GetResponseHeadersPolicyError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_response_headers_policy_output::Builder::default();
        let _ = response;
        output = output.set_e_tag(
            crate::http_serde::deser_header_get_response_headers_policy_get_response_headers_policy_output_e_tag(response.headers())
                                    .map_err(|_|crate::error::GetResponseHeadersPolicyError::unhandled("Failed to parse ETag from header `ETag"))?
        );
        output = output.set_response_headers_policy(
            crate::http_serde::deser_payload_get_response_headers_policy_get_response_headers_policy_output_response_headers_policy(response.body().as_ref())?
        );
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_response_headers_policy_config_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetResponseHeadersPolicyConfigOutput,
    crate::error::GetResponseHeadersPolicyConfigError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetResponseHeadersPolicyConfigError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::GetResponseHeadersPolicyConfigError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDenied" => crate::error::GetResponseHeadersPolicyConfigError {
            meta: generic,
            kind: crate::error::GetResponseHeadersPolicyConfigErrorKind::AccessDenied({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_access_denied_xml_err(
                        response.body().as_ref(),
                        output,
                    )
                    .map_err(crate::error::GetResponseHeadersPolicyConfigError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NoSuchResponseHeadersPolicy" => crate::error::GetResponseHeadersPolicyConfigError {
            meta: generic,
            kind:
                crate::error::GetResponseHeadersPolicyConfigErrorKind::NoSuchResponseHeadersPolicy(
                    {
                        #[allow(unused_mut)]
                        let mut tmp = {
                            #[allow(unused_mut)]
                            let mut output =
                                crate::error::no_such_response_headers_policy::Builder::default();
                            let _ = response;
                            output = crate::xml_deser::deser_structure_crate_error_no_such_response_headers_policy_xml_err(response.body().as_ref(), output).map_err(crate::error::GetResponseHeadersPolicyConfigError::unhandled)?;
                            output.build()
                        };
                        if (&tmp.message).is_none() {
                            tmp.message = _error_message;
                        }
                        tmp
                    },
                ),
        },
        _ => crate::error::GetResponseHeadersPolicyConfigError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_response_headers_policy_config_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetResponseHeadersPolicyConfigOutput,
    crate::error::GetResponseHeadersPolicyConfigError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::get_response_headers_policy_config_output::Builder::default();
        let _ = response;
        output = output.set_e_tag(
            crate::http_serde::deser_header_get_response_headers_policy_config_get_response_headers_policy_config_output_e_tag(response.headers())
                                    .map_err(|_|crate::error::GetResponseHeadersPolicyConfigError::unhandled("Failed to parse ETag from header `ETag"))?
        );
        output = output.set_response_headers_policy_config(
            crate::http_serde::deser_payload_get_response_headers_policy_config_get_response_headers_policy_config_output_response_headers_policy_config(response.body().as_ref())?
        );
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_streaming_distribution_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetStreamingDistributionOutput,
    crate::error::GetStreamingDistributionError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetStreamingDistributionError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::GetStreamingDistributionError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDenied" => crate::error::GetStreamingDistributionError {
            meta: generic,
            kind: crate::error::GetStreamingDistributionErrorKind::AccessDenied({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_access_denied_xml_err(
                        response.body().as_ref(),
                        output,
                    )
                    .map_err(crate::error::GetStreamingDistributionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NoSuchStreamingDistribution" => crate::error::GetStreamingDistributionError {
            meta: generic,
            kind: crate::error::GetStreamingDistributionErrorKind::NoSuchStreamingDistribution({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::no_such_streaming_distribution::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_no_such_streaming_distribution_xml_err(response.body().as_ref(), output).map_err(crate::error::GetStreamingDistributionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::GetStreamingDistributionError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_streaming_distribution_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetStreamingDistributionOutput,
    crate::error::GetStreamingDistributionError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_streaming_distribution_output::Builder::default();
        let _ = response;
        output = output.set_e_tag(
            crate::http_serde::deser_header_get_streaming_distribution_get_streaming_distribution_output_e_tag(response.headers())
                                    .map_err(|_|crate::error::GetStreamingDistributionError::unhandled("Failed to parse ETag from header `ETag"))?
        );
        output = output.set_streaming_distribution(
            crate::http_serde::deser_payload_get_streaming_distribution_get_streaming_distribution_output_streaming_distribution(response.body().as_ref())?
        );
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_streaming_distribution_config_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetStreamingDistributionConfigOutput,
    crate::error::GetStreamingDistributionConfigError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetStreamingDistributionConfigError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::GetStreamingDistributionConfigError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDenied" => crate::error::GetStreamingDistributionConfigError {
            meta: generic,
            kind: crate::error::GetStreamingDistributionConfigErrorKind::AccessDenied({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_access_denied_xml_err(
                        response.body().as_ref(),
                        output,
                    )
                    .map_err(crate::error::GetStreamingDistributionConfigError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NoSuchStreamingDistribution" => crate::error::GetStreamingDistributionConfigError {
            meta: generic,
            kind:
                crate::error::GetStreamingDistributionConfigErrorKind::NoSuchStreamingDistribution(
                    {
                        #[allow(unused_mut)]
                        let mut tmp = {
                            #[allow(unused_mut)]
                            let mut output =
                                crate::error::no_such_streaming_distribution::Builder::default();
                            let _ = response;
                            output = crate::xml_deser::deser_structure_crate_error_no_such_streaming_distribution_xml_err(response.body().as_ref(), output).map_err(crate::error::GetStreamingDistributionConfigError::unhandled)?;
                            output.build()
                        };
                        if (&tmp.message).is_none() {
                            tmp.message = _error_message;
                        }
                        tmp
                    },
                ),
        },
        _ => crate::error::GetStreamingDistributionConfigError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_streaming_distribution_config_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetStreamingDistributionConfigOutput,
    crate::error::GetStreamingDistributionConfigError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::get_streaming_distribution_config_output::Builder::default();
        let _ = response;
        output = output.set_e_tag(
            crate::http_serde::deser_header_get_streaming_distribution_config_get_streaming_distribution_config_output_e_tag(response.headers())
                                    .map_err(|_|crate::error::GetStreamingDistributionConfigError::unhandled("Failed to parse ETag from header `ETag"))?
        );
        output = output.set_streaming_distribution_config(
            crate::http_serde::deser_payload_get_streaming_distribution_config_get_streaming_distribution_config_output_streaming_distribution_config(response.body().as_ref())?
        );
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_cache_policies_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListCachePoliciesOutput, crate::error::ListCachePoliciesError>
{
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListCachePoliciesError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ListCachePoliciesError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDenied" => crate::error::ListCachePoliciesError {
            meta: generic,
            kind: crate::error::ListCachePoliciesErrorKind::AccessDenied({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_access_denied_xml_err(
                        response.body().as_ref(),
                        output,
                    )
                    .map_err(crate::error::ListCachePoliciesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidArgument" => crate::error::ListCachePoliciesError {
            meta: generic,
            kind: crate::error::ListCachePoliciesErrorKind::InvalidArgument({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_argument::Builder::default();
                    let _ = response;
                    output =
                        crate::xml_deser::deser_structure_crate_error_invalid_argument_xml_err(
                            response.body().as_ref(),
                            output,
                        )
                        .map_err(crate::error::ListCachePoliciesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NoSuchCachePolicy" => {
            crate::error::ListCachePoliciesError {
                meta: generic,
                kind: crate::error::ListCachePoliciesErrorKind::NoSuchCachePolicy({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::no_such_cache_policy::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_no_such_cache_policy_xml_err(response.body().as_ref(), output).map_err(crate::error::ListCachePoliciesError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::ListCachePoliciesError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_cache_policies_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListCachePoliciesOutput, crate::error::ListCachePoliciesError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_cache_policies_output::Builder::default();
        let _ = response;
        output = output.set_cache_policy_list(
            crate::http_serde::deser_payload_list_cache_policies_list_cache_policies_output_cache_policy_list(response.body().as_ref())?
        );
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_cloud_front_origin_access_identities_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListCloudFrontOriginAccessIdentitiesOutput,
    crate::error::ListCloudFrontOriginAccessIdentitiesError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListCloudFrontOriginAccessIdentitiesError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::ListCloudFrontOriginAccessIdentitiesError::unhandled(generic))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidArgument" => {
            crate::error::ListCloudFrontOriginAccessIdentitiesError {
                meta: generic,
                kind: crate::error::ListCloudFrontOriginAccessIdentitiesErrorKind::InvalidArgument(
                    {
                        #[allow(unused_mut)]
                        let mut tmp = {
                            #[allow(unused_mut)]
                            let mut output = crate::error::invalid_argument::Builder::default();
                            let _ = response;
                            output = crate::xml_deser::deser_structure_crate_error_invalid_argument_xml_err(response.body().as_ref(), output).map_err(crate::error::ListCloudFrontOriginAccessIdentitiesError::unhandled)?;
                            output.build()
                        };
                        if (&tmp.message).is_none() {
                            tmp.message = _error_message;
                        }
                        tmp
                    },
                ),
            }
        }
        _ => crate::error::ListCloudFrontOriginAccessIdentitiesError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_cloud_front_origin_access_identities_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListCloudFrontOriginAccessIdentitiesOutput,
    crate::error::ListCloudFrontOriginAccessIdentitiesError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::list_cloud_front_origin_access_identities_output::Builder::default();
        let _ = response;
        output = output.set_cloud_front_origin_access_identity_list(
            crate::http_serde::deser_payload_list_cloud_front_origin_access_identities_list_cloud_front_origin_access_identities_output_cloud_front_origin_access_identity_list(response.body().as_ref())?
        );
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_conflicting_aliases_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListConflictingAliasesOutput,
    crate::error::ListConflictingAliasesError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListConflictingAliasesError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::ListConflictingAliasesError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidArgument" => crate::error::ListConflictingAliasesError {
            meta: generic,
            kind: crate::error::ListConflictingAliasesErrorKind::InvalidArgument({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_argument::Builder::default();
                    let _ = response;
                    output =
                        crate::xml_deser::deser_structure_crate_error_invalid_argument_xml_err(
                            response.body().as_ref(),
                            output,
                        )
                        .map_err(crate::error::ListConflictingAliasesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NoSuchDistribution" => {
            crate::error::ListConflictingAliasesError {
                meta: generic,
                kind: crate::error::ListConflictingAliasesErrorKind::NoSuchDistribution({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::no_such_distribution::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_no_such_distribution_xml_err(response.body().as_ref(), output).map_err(crate::error::ListConflictingAliasesError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::ListConflictingAliasesError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_conflicting_aliases_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListConflictingAliasesOutput,
    crate::error::ListConflictingAliasesError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_conflicting_aliases_output::Builder::default();
        let _ = response;
        output = output.set_conflicting_aliases_list(
            crate::http_serde::deser_payload_list_conflicting_aliases_list_conflicting_aliases_output_conflicting_aliases_list(response.body().as_ref())?
        );
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_distributions_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListDistributionsOutput, crate::error::ListDistributionsError>
{
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListDistributionsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ListDistributionsError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidArgument" => crate::error::ListDistributionsError {
            meta: generic,
            kind: crate::error::ListDistributionsErrorKind::InvalidArgument({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_argument::Builder::default();
                    let _ = response;
                    output =
                        crate::xml_deser::deser_structure_crate_error_invalid_argument_xml_err(
                            response.body().as_ref(),
                            output,
                        )
                        .map_err(crate::error::ListDistributionsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ListDistributionsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_distributions_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListDistributionsOutput, crate::error::ListDistributionsError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_distributions_output::Builder::default();
        let _ = response;
        output = output.set_distribution_list(
            crate::http_serde::deser_payload_list_distributions_list_distributions_output_distribution_list(response.body().as_ref())?
        );
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_distributions_by_cache_policy_id_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListDistributionsByCachePolicyIdOutput,
    crate::error::ListDistributionsByCachePolicyIdError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListDistributionsByCachePolicyIdError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::ListDistributionsByCachePolicyIdError::unhandled(generic))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDenied" => crate::error::ListDistributionsByCachePolicyIdError {
            meta: generic,
            kind: crate::error::ListDistributionsByCachePolicyIdErrorKind::AccessDenied({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_access_denied_xml_err(
                        response.body().as_ref(),
                        output,
                    )
                    .map_err(crate::error::ListDistributionsByCachePolicyIdError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidArgument" => crate::error::ListDistributionsByCachePolicyIdError {
            meta: generic,
            kind: crate::error::ListDistributionsByCachePolicyIdErrorKind::InvalidArgument({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_argument::Builder::default();
                    let _ = response;
                    output =
                        crate::xml_deser::deser_structure_crate_error_invalid_argument_xml_err(
                            response.body().as_ref(),
                            output,
                        )
                        .map_err(crate::error::ListDistributionsByCachePolicyIdError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NoSuchCachePolicy" => {
            crate::error::ListDistributionsByCachePolicyIdError {
                meta: generic,
                kind: crate::error::ListDistributionsByCachePolicyIdErrorKind::NoSuchCachePolicy({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::no_such_cache_policy::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_no_such_cache_policy_xml_err(response.body().as_ref(), output).map_err(crate::error::ListDistributionsByCachePolicyIdError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::ListDistributionsByCachePolicyIdError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_distributions_by_cache_policy_id_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListDistributionsByCachePolicyIdOutput,
    crate::error::ListDistributionsByCachePolicyIdError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::list_distributions_by_cache_policy_id_output::Builder::default();
        let _ = response;
        output = output.set_distribution_id_list(
            crate::http_serde::deser_payload_list_distributions_by_cache_policy_id_list_distributions_by_cache_policy_id_output_distribution_id_list(response.body().as_ref())?
        );
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_distributions_by_key_group_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListDistributionsByKeyGroupOutput,
    crate::error::ListDistributionsByKeyGroupError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListDistributionsByKeyGroupError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::ListDistributionsByKeyGroupError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidArgument" => crate::error::ListDistributionsByKeyGroupError {
            meta: generic,
            kind: crate::error::ListDistributionsByKeyGroupErrorKind::InvalidArgument({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_argument::Builder::default();
                    let _ = response;
                    output =
                        crate::xml_deser::deser_structure_crate_error_invalid_argument_xml_err(
                            response.body().as_ref(),
                            output,
                        )
                        .map_err(crate::error::ListDistributionsByKeyGroupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NoSuchResource" => crate::error::ListDistributionsByKeyGroupError {
            meta: generic,
            kind: crate::error::ListDistributionsByKeyGroupErrorKind::NoSuchResource({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::no_such_resource::Builder::default();
                    let _ = response;
                    output =
                        crate::xml_deser::deser_structure_crate_error_no_such_resource_xml_err(
                            response.body().as_ref(),
                            output,
                        )
                        .map_err(crate::error::ListDistributionsByKeyGroupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ListDistributionsByKeyGroupError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_distributions_by_key_group_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListDistributionsByKeyGroupOutput,
    crate::error::ListDistributionsByKeyGroupError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_distributions_by_key_group_output::Builder::default();
        let _ = response;
        output = output.set_distribution_id_list(
            crate::http_serde::deser_payload_list_distributions_by_key_group_list_distributions_by_key_group_output_distribution_id_list(response.body().as_ref())?
        );
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_distributions_by_origin_request_policy_id_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListDistributionsByOriginRequestPolicyIdOutput,
    crate::error::ListDistributionsByOriginRequestPolicyIdError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListDistributionsByOriginRequestPolicyIdError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(
                crate::error::ListDistributionsByOriginRequestPolicyIdError::unhandled(generic),
            )
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDenied" => crate::error::ListDistributionsByOriginRequestPolicyIdError { meta: generic, kind: crate::error::ListDistributionsByOriginRequestPolicyIdErrorKind::AccessDenied({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::access_denied::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_access_denied_xml_err(response.body().as_ref(), output).map_err(crate::error::ListDistributionsByOriginRequestPolicyIdError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidArgument" => crate::error::ListDistributionsByOriginRequestPolicyIdError { meta: generic, kind: crate::error::ListDistributionsByOriginRequestPolicyIdErrorKind::InvalidArgument({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_argument::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_argument_xml_err(response.body().as_ref(), output).map_err(crate::error::ListDistributionsByOriginRequestPolicyIdError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "NoSuchOriginRequestPolicy" => crate::error::ListDistributionsByOriginRequestPolicyIdError { meta: generic, kind: crate::error::ListDistributionsByOriginRequestPolicyIdErrorKind::NoSuchOriginRequestPolicy({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::no_such_origin_request_policy::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_no_such_origin_request_policy_xml_err(response.body().as_ref(), output).map_err(crate::error::ListDistributionsByOriginRequestPolicyIdError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::ListDistributionsByOriginRequestPolicyIdError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_distributions_by_origin_request_policy_id_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListDistributionsByOriginRequestPolicyIdOutput,
    crate::error::ListDistributionsByOriginRequestPolicyIdError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::list_distributions_by_origin_request_policy_id_output::Builder::default(
            );
        let _ = response;
        output = output.set_distribution_id_list(
            crate::http_serde::deser_payload_list_distributions_by_origin_request_policy_id_list_distributions_by_origin_request_policy_id_output_distribution_id_list(response.body().as_ref())?
        );
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_distributions_by_realtime_log_config_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListDistributionsByRealtimeLogConfigOutput,
    crate::error::ListDistributionsByRealtimeLogConfigError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListDistributionsByRealtimeLogConfigError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::ListDistributionsByRealtimeLogConfigError::unhandled(generic))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidArgument" => {
            crate::error::ListDistributionsByRealtimeLogConfigError {
                meta: generic,
                kind: crate::error::ListDistributionsByRealtimeLogConfigErrorKind::InvalidArgument(
                    {
                        #[allow(unused_mut)]
                        let mut tmp = {
                            #[allow(unused_mut)]
                            let mut output = crate::error::invalid_argument::Builder::default();
                            let _ = response;
                            output = crate::xml_deser::deser_structure_crate_error_invalid_argument_xml_err(response.body().as_ref(), output).map_err(crate::error::ListDistributionsByRealtimeLogConfigError::unhandled)?;
                            output.build()
                        };
                        if (&tmp.message).is_none() {
                            tmp.message = _error_message;
                        }
                        tmp
                    },
                ),
            }
        }
        _ => crate::error::ListDistributionsByRealtimeLogConfigError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_distributions_by_realtime_log_config_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListDistributionsByRealtimeLogConfigOutput,
    crate::error::ListDistributionsByRealtimeLogConfigError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::list_distributions_by_realtime_log_config_output::Builder::default();
        let _ = response;
        output = output.set_distribution_list(
            crate::http_serde::deser_payload_list_distributions_by_realtime_log_config_list_distributions_by_realtime_log_config_output_distribution_list(response.body().as_ref())?
        );
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_distributions_by_response_headers_policy_id_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListDistributionsByResponseHeadersPolicyIdOutput,
    crate::error::ListDistributionsByResponseHeadersPolicyIdError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListDistributionsByResponseHeadersPolicyIdError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(
                crate::error::ListDistributionsByResponseHeadersPolicyIdError::unhandled(generic),
            )
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDenied" => crate::error::ListDistributionsByResponseHeadersPolicyIdError { meta: generic, kind: crate::error::ListDistributionsByResponseHeadersPolicyIdErrorKind::AccessDenied({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::access_denied::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_access_denied_xml_err(response.body().as_ref(), output).map_err(crate::error::ListDistributionsByResponseHeadersPolicyIdError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidArgument" => crate::error::ListDistributionsByResponseHeadersPolicyIdError { meta: generic, kind: crate::error::ListDistributionsByResponseHeadersPolicyIdErrorKind::InvalidArgument({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_argument::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_argument_xml_err(response.body().as_ref(), output).map_err(crate::error::ListDistributionsByResponseHeadersPolicyIdError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "NoSuchResponseHeadersPolicy" => crate::error::ListDistributionsByResponseHeadersPolicyIdError { meta: generic, kind: crate::error::ListDistributionsByResponseHeadersPolicyIdErrorKind::NoSuchResponseHeadersPolicy({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::no_such_response_headers_policy::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_no_such_response_headers_policy_xml_err(response.body().as_ref(), output).map_err(crate::error::ListDistributionsByResponseHeadersPolicyIdError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::ListDistributionsByResponseHeadersPolicyIdError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_distributions_by_response_headers_policy_id_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListDistributionsByResponseHeadersPolicyIdOutput,
    crate::error::ListDistributionsByResponseHeadersPolicyIdError,
> {
    Ok({
        #[allow(unused_mut)]let mut output = crate::output::list_distributions_by_response_headers_policy_id_output::Builder::default();
        let _ = response;
        output = output.set_distribution_id_list(
            crate::http_serde::deser_payload_list_distributions_by_response_headers_policy_id_list_distributions_by_response_headers_policy_id_output_distribution_id_list(response.body().as_ref())?
        );
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_distributions_by_web_acl_id_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListDistributionsByWebAclIdOutput,
    crate::error::ListDistributionsByWebACLIdError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListDistributionsByWebACLIdError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::ListDistributionsByWebACLIdError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidArgument" => crate::error::ListDistributionsByWebACLIdError {
            meta: generic,
            kind: crate::error::ListDistributionsByWebACLIdErrorKind::InvalidArgument({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_argument::Builder::default();
                    let _ = response;
                    output =
                        crate::xml_deser::deser_structure_crate_error_invalid_argument_xml_err(
                            response.body().as_ref(),
                            output,
                        )
                        .map_err(crate::error::ListDistributionsByWebACLIdError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidWebACLId" => {
            crate::error::ListDistributionsByWebACLIdError {
                meta: generic,
                kind: crate::error::ListDistributionsByWebACLIdErrorKind::InvalidWebAclId({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::invalid_web_acl_id::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_invalid_web_acl_id_xml_err(response.body().as_ref(), output).map_err(crate::error::ListDistributionsByWebACLIdError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::ListDistributionsByWebACLIdError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_distributions_by_web_acl_id_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListDistributionsByWebAclIdOutput,
    crate::error::ListDistributionsByWebACLIdError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_distributions_by_web_acl_id_output::Builder::default();
        let _ = response;
        output = output.set_distribution_list(
            crate::http_serde::deser_payload_list_distributions_by_web_acl_id_list_distributions_by_web_acl_id_output_distribution_list(response.body().as_ref())?
        );
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_field_level_encryption_configs_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListFieldLevelEncryptionConfigsOutput,
    crate::error::ListFieldLevelEncryptionConfigsError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListFieldLevelEncryptionConfigsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ListFieldLevelEncryptionConfigsError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidArgument" => crate::error::ListFieldLevelEncryptionConfigsError {
            meta: generic,
            kind: crate::error::ListFieldLevelEncryptionConfigsErrorKind::InvalidArgument({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_argument::Builder::default();
                    let _ = response;
                    output =
                        crate::xml_deser::deser_structure_crate_error_invalid_argument_xml_err(
                            response.body().as_ref(),
                            output,
                        )
                        .map_err(crate::error::ListFieldLevelEncryptionConfigsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ListFieldLevelEncryptionConfigsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_field_level_encryption_configs_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListFieldLevelEncryptionConfigsOutput,
    crate::error::ListFieldLevelEncryptionConfigsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::list_field_level_encryption_configs_output::Builder::default();
        let _ = response;
        output = output.set_field_level_encryption_list(
            crate::http_serde::deser_payload_list_field_level_encryption_configs_list_field_level_encryption_configs_output_field_level_encryption_list(response.body().as_ref())?
        );
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_field_level_encryption_profiles_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListFieldLevelEncryptionProfilesOutput,
    crate::error::ListFieldLevelEncryptionProfilesError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListFieldLevelEncryptionProfilesError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::ListFieldLevelEncryptionProfilesError::unhandled(generic))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidArgument" => crate::error::ListFieldLevelEncryptionProfilesError {
            meta: generic,
            kind: crate::error::ListFieldLevelEncryptionProfilesErrorKind::InvalidArgument({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_argument::Builder::default();
                    let _ = response;
                    output =
                        crate::xml_deser::deser_structure_crate_error_invalid_argument_xml_err(
                            response.body().as_ref(),
                            output,
                        )
                        .map_err(crate::error::ListFieldLevelEncryptionProfilesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ListFieldLevelEncryptionProfilesError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_field_level_encryption_profiles_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListFieldLevelEncryptionProfilesOutput,
    crate::error::ListFieldLevelEncryptionProfilesError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::list_field_level_encryption_profiles_output::Builder::default();
        let _ = response;
        output = output.set_field_level_encryption_profile_list(
            crate::http_serde::deser_payload_list_field_level_encryption_profiles_list_field_level_encryption_profiles_output_field_level_encryption_profile_list(response.body().as_ref())?
        );
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_functions_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListFunctionsOutput, crate::error::ListFunctionsError> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListFunctionsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ListFunctionsError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidArgument" => crate::error::ListFunctionsError {
            meta: generic,
            kind: crate::error::ListFunctionsErrorKind::InvalidArgument({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_argument::Builder::default();
                    let _ = response;
                    output =
                        crate::xml_deser::deser_structure_crate_error_invalid_argument_xml_err(
                            response.body().as_ref(),
                            output,
                        )
                        .map_err(crate::error::ListFunctionsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "UnsupportedOperation" => crate::error::ListFunctionsError {
            meta: generic,
            kind: crate::error::ListFunctionsErrorKind::UnsupportedOperation({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::unsupported_operation::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_unsupported_operation_xml_err(response.body().as_ref(), output).map_err(crate::error::ListFunctionsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ListFunctionsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_functions_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListFunctionsOutput, crate::error::ListFunctionsError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_functions_output::Builder::default();
        let _ = response;
        output = output.set_function_list(
            crate::http_serde::deser_payload_list_functions_list_functions_output_function_list(
                response.body().as_ref(),
            )?,
        );
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_invalidations_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListInvalidationsOutput, crate::error::ListInvalidationsError>
{
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListInvalidationsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ListInvalidationsError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDenied" => crate::error::ListInvalidationsError {
            meta: generic,
            kind: crate::error::ListInvalidationsErrorKind::AccessDenied({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_access_denied_xml_err(
                        response.body().as_ref(),
                        output,
                    )
                    .map_err(crate::error::ListInvalidationsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidArgument" => crate::error::ListInvalidationsError {
            meta: generic,
            kind: crate::error::ListInvalidationsErrorKind::InvalidArgument({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_argument::Builder::default();
                    let _ = response;
                    output =
                        crate::xml_deser::deser_structure_crate_error_invalid_argument_xml_err(
                            response.body().as_ref(),
                            output,
                        )
                        .map_err(crate::error::ListInvalidationsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NoSuchDistribution" => {
            crate::error::ListInvalidationsError {
                meta: generic,
                kind: crate::error::ListInvalidationsErrorKind::NoSuchDistribution({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::no_such_distribution::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_no_such_distribution_xml_err(response.body().as_ref(), output).map_err(crate::error::ListInvalidationsError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::ListInvalidationsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_invalidations_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListInvalidationsOutput, crate::error::ListInvalidationsError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_invalidations_output::Builder::default();
        let _ = response;
        output = output.set_invalidation_list(
            crate::http_serde::deser_payload_list_invalidations_list_invalidations_output_invalidation_list(response.body().as_ref())?
        );
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_key_groups_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListKeyGroupsOutput, crate::error::ListKeyGroupsError> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListKeyGroupsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ListKeyGroupsError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidArgument" => crate::error::ListKeyGroupsError {
            meta: generic,
            kind: crate::error::ListKeyGroupsErrorKind::InvalidArgument({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_argument::Builder::default();
                    let _ = response;
                    output =
                        crate::xml_deser::deser_structure_crate_error_invalid_argument_xml_err(
                            response.body().as_ref(),
                            output,
                        )
                        .map_err(crate::error::ListKeyGroupsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ListKeyGroupsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_key_groups_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListKeyGroupsOutput, crate::error::ListKeyGroupsError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_key_groups_output::Builder::default();
        let _ = response;
        output = output.set_key_group_list(
            crate::http_serde::deser_payload_list_key_groups_list_key_groups_output_key_group_list(
                response.body().as_ref(),
            )?,
        );
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_origin_request_policies_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListOriginRequestPoliciesOutput,
    crate::error::ListOriginRequestPoliciesError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListOriginRequestPoliciesError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::ListOriginRequestPoliciesError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDenied" => crate::error::ListOriginRequestPoliciesError {
            meta: generic,
            kind: crate::error::ListOriginRequestPoliciesErrorKind::AccessDenied({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_access_denied_xml_err(
                        response.body().as_ref(),
                        output,
                    )
                    .map_err(crate::error::ListOriginRequestPoliciesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidArgument" => crate::error::ListOriginRequestPoliciesError {
            meta: generic,
            kind: crate::error::ListOriginRequestPoliciesErrorKind::InvalidArgument({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_argument::Builder::default();
                    let _ = response;
                    output =
                        crate::xml_deser::deser_structure_crate_error_invalid_argument_xml_err(
                            response.body().as_ref(),
                            output,
                        )
                        .map_err(crate::error::ListOriginRequestPoliciesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NoSuchOriginRequestPolicy" => crate::error::ListOriginRequestPoliciesError {
            meta: generic,
            kind: crate::error::ListOriginRequestPoliciesErrorKind::NoSuchOriginRequestPolicy({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::no_such_origin_request_policy::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_no_such_origin_request_policy_xml_err(response.body().as_ref(), output).map_err(crate::error::ListOriginRequestPoliciesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ListOriginRequestPoliciesError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_origin_request_policies_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListOriginRequestPoliciesOutput,
    crate::error::ListOriginRequestPoliciesError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_origin_request_policies_output::Builder::default();
        let _ = response;
        output = output.set_origin_request_policy_list(
            crate::http_serde::deser_payload_list_origin_request_policies_list_origin_request_policies_output_origin_request_policy_list(response.body().as_ref())?
        );
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_public_keys_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListPublicKeysOutput, crate::error::ListPublicKeysError> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListPublicKeysError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ListPublicKeysError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidArgument" => crate::error::ListPublicKeysError {
            meta: generic,
            kind: crate::error::ListPublicKeysErrorKind::InvalidArgument({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_argument::Builder::default();
                    let _ = response;
                    output =
                        crate::xml_deser::deser_structure_crate_error_invalid_argument_xml_err(
                            response.body().as_ref(),
                            output,
                        )
                        .map_err(crate::error::ListPublicKeysError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ListPublicKeysError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_public_keys_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListPublicKeysOutput, crate::error::ListPublicKeysError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_public_keys_output::Builder::default();
        let _ = response;
        output = output.set_public_key_list(
            crate::http_serde::deser_payload_list_public_keys_list_public_keys_output_public_key_list(response.body().as_ref())?
        );
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_realtime_log_configs_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListRealtimeLogConfigsOutput,
    crate::error::ListRealtimeLogConfigsError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListRealtimeLogConfigsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::ListRealtimeLogConfigsError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDenied" => crate::error::ListRealtimeLogConfigsError {
            meta: generic,
            kind: crate::error::ListRealtimeLogConfigsErrorKind::AccessDenied({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_access_denied_xml_err(
                        response.body().as_ref(),
                        output,
                    )
                    .map_err(crate::error::ListRealtimeLogConfigsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidArgument" => crate::error::ListRealtimeLogConfigsError {
            meta: generic,
            kind: crate::error::ListRealtimeLogConfigsErrorKind::InvalidArgument({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_argument::Builder::default();
                    let _ = response;
                    output =
                        crate::xml_deser::deser_structure_crate_error_invalid_argument_xml_err(
                            response.body().as_ref(),
                            output,
                        )
                        .map_err(crate::error::ListRealtimeLogConfigsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NoSuchRealtimeLogConfig" => crate::error::ListRealtimeLogConfigsError {
            meta: generic,
            kind: crate::error::ListRealtimeLogConfigsErrorKind::NoSuchRealtimeLogConfig({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::no_such_realtime_log_config::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_no_such_realtime_log_config_xml_err(response.body().as_ref(), output).map_err(crate::error::ListRealtimeLogConfigsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ListRealtimeLogConfigsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_realtime_log_configs_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListRealtimeLogConfigsOutput,
    crate::error::ListRealtimeLogConfigsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_realtime_log_configs_output::Builder::default();
        let _ = response;
        output = output.set_realtime_log_configs(
            crate::http_serde::deser_payload_list_realtime_log_configs_list_realtime_log_configs_output_realtime_log_configs(response.body().as_ref())?
        );
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_response_headers_policies_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListResponseHeadersPoliciesOutput,
    crate::error::ListResponseHeadersPoliciesError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListResponseHeadersPoliciesError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::ListResponseHeadersPoliciesError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDenied" => crate::error::ListResponseHeadersPoliciesError {
            meta: generic,
            kind: crate::error::ListResponseHeadersPoliciesErrorKind::AccessDenied({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_access_denied_xml_err(
                        response.body().as_ref(),
                        output,
                    )
                    .map_err(crate::error::ListResponseHeadersPoliciesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidArgument" => crate::error::ListResponseHeadersPoliciesError {
            meta: generic,
            kind: crate::error::ListResponseHeadersPoliciesErrorKind::InvalidArgument({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_argument::Builder::default();
                    let _ = response;
                    output =
                        crate::xml_deser::deser_structure_crate_error_invalid_argument_xml_err(
                            response.body().as_ref(),
                            output,
                        )
                        .map_err(crate::error::ListResponseHeadersPoliciesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NoSuchResponseHeadersPolicy" => crate::error::ListResponseHeadersPoliciesError {
            meta: generic,
            kind: crate::error::ListResponseHeadersPoliciesErrorKind::NoSuchResponseHeadersPolicy(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::no_such_response_headers_policy::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_no_such_response_headers_policy_xml_err(response.body().as_ref(), output).map_err(crate::error::ListResponseHeadersPoliciesError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        _ => crate::error::ListResponseHeadersPoliciesError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_response_headers_policies_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListResponseHeadersPoliciesOutput,
    crate::error::ListResponseHeadersPoliciesError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_response_headers_policies_output::Builder::default();
        let _ = response;
        output = output.set_response_headers_policy_list(
            crate::http_serde::deser_payload_list_response_headers_policies_list_response_headers_policies_output_response_headers_policy_list(response.body().as_ref())?
        );
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_streaming_distributions_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListStreamingDistributionsOutput,
    crate::error::ListStreamingDistributionsError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListStreamingDistributionsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::ListStreamingDistributionsError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidArgument" => crate::error::ListStreamingDistributionsError {
            meta: generic,
            kind: crate::error::ListStreamingDistributionsErrorKind::InvalidArgument({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_argument::Builder::default();
                    let _ = response;
                    output =
                        crate::xml_deser::deser_structure_crate_error_invalid_argument_xml_err(
                            response.body().as_ref(),
                            output,
                        )
                        .map_err(crate::error::ListStreamingDistributionsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ListStreamingDistributionsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_streaming_distributions_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListStreamingDistributionsOutput,
    crate::error::ListStreamingDistributionsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_streaming_distributions_output::Builder::default();
        let _ = response;
        output = output.set_streaming_distribution_list(
            crate::http_serde::deser_payload_list_streaming_distributions_list_streaming_distributions_output_streaming_distribution_list(response.body().as_ref())?
        );
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_tags_for_resource_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListTagsForResourceOutput,
    crate::error::ListTagsForResourceError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListTagsForResourceError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ListTagsForResourceError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDenied" => crate::error::ListTagsForResourceError {
            meta: generic,
            kind: crate::error::ListTagsForResourceErrorKind::AccessDenied({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_access_denied_xml_err(
                        response.body().as_ref(),
                        output,
                    )
                    .map_err(crate::error::ListTagsForResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidArgument" => crate::error::ListTagsForResourceError {
            meta: generic,
            kind: crate::error::ListTagsForResourceErrorKind::InvalidArgument({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_argument::Builder::default();
                    let _ = response;
                    output =
                        crate::xml_deser::deser_structure_crate_error_invalid_argument_xml_err(
                            response.body().as_ref(),
                            output,
                        )
                        .map_err(crate::error::ListTagsForResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidTagging" => crate::error::ListTagsForResourceError {
            meta: generic,
            kind: crate::error::ListTagsForResourceErrorKind::InvalidTagging({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_tagging::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_tagging_xml_err(
                        response.body().as_ref(),
                        output,
                    )
                    .map_err(crate::error::ListTagsForResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NoSuchResource" => crate::error::ListTagsForResourceError {
            meta: generic,
            kind: crate::error::ListTagsForResourceErrorKind::NoSuchResource({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::no_such_resource::Builder::default();
                    let _ = response;
                    output =
                        crate::xml_deser::deser_structure_crate_error_no_such_resource_xml_err(
                            response.body().as_ref(),
                            output,
                        )
                        .map_err(crate::error::ListTagsForResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ListTagsForResourceError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_tags_for_resource_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListTagsForResourceOutput,
    crate::error::ListTagsForResourceError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_tags_for_resource_output::Builder::default();
        let _ = response;
        output = output.set_tags(
            crate::http_serde::deser_payload_list_tags_for_resource_list_tags_for_resource_output_tags(response.body().as_ref())?
        );
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_publish_function_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::PublishFunctionOutput, crate::error::PublishFunctionError> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::PublishFunctionError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::PublishFunctionError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidArgument" => crate::error::PublishFunctionError {
            meta: generic,
            kind: crate::error::PublishFunctionErrorKind::InvalidArgument({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_argument::Builder::default();
                    let _ = response;
                    output =
                        crate::xml_deser::deser_structure_crate_error_invalid_argument_xml_err(
                            response.body().as_ref(),
                            output,
                        )
                        .map_err(crate::error::PublishFunctionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidIfMatchVersion" => crate::error::PublishFunctionError {
            meta: generic,
            kind: crate::error::PublishFunctionErrorKind::InvalidIfMatchVersion({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_if_match_version::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_if_match_version_xml_err(response.body().as_ref(), output).map_err(crate::error::PublishFunctionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NoSuchFunctionExists" => crate::error::PublishFunctionError {
            meta: generic,
            kind: crate::error::PublishFunctionErrorKind::NoSuchFunctionExists({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::no_such_function_exists::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_no_such_function_exists_xml_err(response.body().as_ref(), output).map_err(crate::error::PublishFunctionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "PreconditionFailed" => {
            crate::error::PublishFunctionError {
                meta: generic,
                kind: crate::error::PublishFunctionErrorKind::PreconditionFailed({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::precondition_failed::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_precondition_failed_xml_err(response.body().as_ref(), output).map_err(crate::error::PublishFunctionError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "UnsupportedOperation" => crate::error::PublishFunctionError {
            meta: generic,
            kind: crate::error::PublishFunctionErrorKind::UnsupportedOperation({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::unsupported_operation::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_unsupported_operation_xml_err(response.body().as_ref(), output).map_err(crate::error::PublishFunctionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::PublishFunctionError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_publish_function_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::PublishFunctionOutput, crate::error::PublishFunctionError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::publish_function_output::Builder::default();
        let _ = response;
        output = output.set_function_summary(
            crate::http_serde::deser_payload_publish_function_publish_function_output_function_summary(response.body().as_ref())?
        );
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_tag_resource_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::TagResourceOutput, crate::error::TagResourceError> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::TagResourceError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::TagResourceError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDenied" => crate::error::TagResourceError {
            meta: generic,
            kind: crate::error::TagResourceErrorKind::AccessDenied({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_access_denied_xml_err(
                        response.body().as_ref(),
                        output,
                    )
                    .map_err(crate::error::TagResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidArgument" => crate::error::TagResourceError {
            meta: generic,
            kind: crate::error::TagResourceErrorKind::InvalidArgument({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_argument::Builder::default();
                    let _ = response;
                    output =
                        crate::xml_deser::deser_structure_crate_error_invalid_argument_xml_err(
                            response.body().as_ref(),
                            output,
                        )
                        .map_err(crate::error::TagResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidTagging" => crate::error::TagResourceError {
            meta: generic,
            kind: crate::error::TagResourceErrorKind::InvalidTagging({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_tagging::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_tagging_xml_err(
                        response.body().as_ref(),
                        output,
                    )
                    .map_err(crate::error::TagResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NoSuchResource" => crate::error::TagResourceError {
            meta: generic,
            kind: crate::error::TagResourceErrorKind::NoSuchResource({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::no_such_resource::Builder::default();
                    let _ = response;
                    output =
                        crate::xml_deser::deser_structure_crate_error_no_such_resource_xml_err(
                            response.body().as_ref(),
                            output,
                        )
                        .map_err(crate::error::TagResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::TagResourceError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_tag_resource_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::TagResourceOutput, crate::error::TagResourceError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::tag_resource_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_test_function_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::TestFunctionOutput, crate::error::TestFunctionError> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::TestFunctionError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::TestFunctionError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidArgument" => crate::error::TestFunctionError {
            meta: generic,
            kind: crate::error::TestFunctionErrorKind::InvalidArgument({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_argument::Builder::default();
                    let _ = response;
                    output =
                        crate::xml_deser::deser_structure_crate_error_invalid_argument_xml_err(
                            response.body().as_ref(),
                            output,
                        )
                        .map_err(crate::error::TestFunctionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidIfMatchVersion" => crate::error::TestFunctionError {
            meta: generic,
            kind: crate::error::TestFunctionErrorKind::InvalidIfMatchVersion({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_if_match_version::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_if_match_version_xml_err(response.body().as_ref(), output).map_err(crate::error::TestFunctionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NoSuchFunctionExists" => crate::error::TestFunctionError {
            meta: generic,
            kind: crate::error::TestFunctionErrorKind::NoSuchFunctionExists({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::no_such_function_exists::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_no_such_function_exists_xml_err(response.body().as_ref(), output).map_err(crate::error::TestFunctionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TestFunctionFailed" => {
            crate::error::TestFunctionError {
                meta: generic,
                kind: crate::error::TestFunctionErrorKind::TestFunctionFailed({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::test_function_failed::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_test_function_failed_xml_err(response.body().as_ref(), output).map_err(crate::error::TestFunctionError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "UnsupportedOperation" => crate::error::TestFunctionError {
            meta: generic,
            kind: crate::error::TestFunctionErrorKind::UnsupportedOperation({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::unsupported_operation::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_unsupported_operation_xml_err(response.body().as_ref(), output).map_err(crate::error::TestFunctionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::TestFunctionError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_test_function_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::TestFunctionOutput, crate::error::TestFunctionError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::test_function_output::Builder::default();
        let _ = response;
        output = output.set_test_result(
            crate::http_serde::deser_payload_test_function_test_function_output_test_result(
                response.body().as_ref(),
            )?,
        );
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_untag_resource_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::UntagResourceOutput, crate::error::UntagResourceError> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::UntagResourceError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::UntagResourceError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDenied" => crate::error::UntagResourceError {
            meta: generic,
            kind: crate::error::UntagResourceErrorKind::AccessDenied({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_access_denied_xml_err(
                        response.body().as_ref(),
                        output,
                    )
                    .map_err(crate::error::UntagResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidArgument" => crate::error::UntagResourceError {
            meta: generic,
            kind: crate::error::UntagResourceErrorKind::InvalidArgument({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_argument::Builder::default();
                    let _ = response;
                    output =
                        crate::xml_deser::deser_structure_crate_error_invalid_argument_xml_err(
                            response.body().as_ref(),
                            output,
                        )
                        .map_err(crate::error::UntagResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidTagging" => crate::error::UntagResourceError {
            meta: generic,
            kind: crate::error::UntagResourceErrorKind::InvalidTagging({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_tagging::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_tagging_xml_err(
                        response.body().as_ref(),
                        output,
                    )
                    .map_err(crate::error::UntagResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NoSuchResource" => crate::error::UntagResourceError {
            meta: generic,
            kind: crate::error::UntagResourceErrorKind::NoSuchResource({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::no_such_resource::Builder::default();
                    let _ = response;
                    output =
                        crate::xml_deser::deser_structure_crate_error_no_such_resource_xml_err(
                            response.body().as_ref(),
                            output,
                        )
                        .map_err(crate::error::UntagResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::UntagResourceError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_untag_resource_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::UntagResourceOutput, crate::error::UntagResourceError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::untag_resource_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_cache_policy_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::UpdateCachePolicyOutput, crate::error::UpdateCachePolicyError>
{
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::UpdateCachePolicyError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::UpdateCachePolicyError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDenied" => crate::error::UpdateCachePolicyError {
            meta: generic,
            kind: crate::error::UpdateCachePolicyErrorKind::AccessDenied({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_access_denied_xml_err(
                        response.body().as_ref(),
                        output,
                    )
                    .map_err(crate::error::UpdateCachePolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "CachePolicyAlreadyExists" => crate::error::UpdateCachePolicyError {
            meta: generic,
            kind: crate::error::UpdateCachePolicyErrorKind::CachePolicyAlreadyExists({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::cache_policy_already_exists::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_cache_policy_already_exists_xml_err(response.body().as_ref(), output).map_err(crate::error::UpdateCachePolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "IllegalUpdate" => crate::error::UpdateCachePolicyError {
            meta: generic,
            kind: crate::error::UpdateCachePolicyErrorKind::IllegalUpdate({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::illegal_update::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_illegal_update_xml_err(
                        response.body().as_ref(),
                        output,
                    )
                    .map_err(crate::error::UpdateCachePolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InconsistentQuantities" => crate::error::UpdateCachePolicyError {
            meta: generic,
            kind: crate::error::UpdateCachePolicyErrorKind::InconsistentQuantities({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::inconsistent_quantities::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_inconsistent_quantities_xml_err(response.body().as_ref(), output).map_err(crate::error::UpdateCachePolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidArgument" => crate::error::UpdateCachePolicyError {
            meta: generic,
            kind: crate::error::UpdateCachePolicyErrorKind::InvalidArgument({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_argument::Builder::default();
                    let _ = response;
                    output =
                        crate::xml_deser::deser_structure_crate_error_invalid_argument_xml_err(
                            response.body().as_ref(),
                            output,
                        )
                        .map_err(crate::error::UpdateCachePolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidIfMatchVersion" => crate::error::UpdateCachePolicyError {
            meta: generic,
            kind: crate::error::UpdateCachePolicyErrorKind::InvalidIfMatchVersion({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_if_match_version::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_if_match_version_xml_err(response.body().as_ref(), output).map_err(crate::error::UpdateCachePolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NoSuchCachePolicy" => {
            crate::error::UpdateCachePolicyError {
                meta: generic,
                kind: crate::error::UpdateCachePolicyErrorKind::NoSuchCachePolicy({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::no_such_cache_policy::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_no_such_cache_policy_xml_err(response.body().as_ref(), output).map_err(crate::error::UpdateCachePolicyError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "PreconditionFailed" => {
            crate::error::UpdateCachePolicyError {
                meta: generic,
                kind: crate::error::UpdateCachePolicyErrorKind::PreconditionFailed({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::precondition_failed::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_precondition_failed_xml_err(response.body().as_ref(), output).map_err(crate::error::UpdateCachePolicyError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "TooManyCookiesInCachePolicy" => crate::error::UpdateCachePolicyError {
            meta: generic,
            kind: crate::error::UpdateCachePolicyErrorKind::TooManyCookiesInCachePolicy({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::too_many_cookies_in_cache_policy::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_too_many_cookies_in_cache_policy_xml_err(response.body().as_ref(), output).map_err(crate::error::UpdateCachePolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TooManyHeadersInCachePolicy" => crate::error::UpdateCachePolicyError {
            meta: generic,
            kind: crate::error::UpdateCachePolicyErrorKind::TooManyHeadersInCachePolicy({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::too_many_headers_in_cache_policy::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_too_many_headers_in_cache_policy_xml_err(response.body().as_ref(), output).map_err(crate::error::UpdateCachePolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TooManyQueryStringsInCachePolicy" => crate::error::UpdateCachePolicyError {
            meta: generic,
            kind: crate::error::UpdateCachePolicyErrorKind::TooManyQueryStringsInCachePolicy({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::too_many_query_strings_in_cache_policy::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_too_many_query_strings_in_cache_policy_xml_err(response.body().as_ref(), output).map_err(crate::error::UpdateCachePolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::UpdateCachePolicyError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_cache_policy_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::UpdateCachePolicyOutput, crate::error::UpdateCachePolicyError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::update_cache_policy_output::Builder::default();
        let _ = response;
        output = output.set_cache_policy(
            crate::http_serde::deser_payload_update_cache_policy_update_cache_policy_output_cache_policy(response.body().as_ref())?
        );
        output = output.set_e_tag(
            crate::http_serde::deser_header_update_cache_policy_update_cache_policy_output_e_tag(
                response.headers(),
            )
            .map_err(|_| {
                crate::error::UpdateCachePolicyError::unhandled(
                    "Failed to parse ETag from header `ETag",
                )
            })?,
        );
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_cloud_front_origin_access_identity_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UpdateCloudFrontOriginAccessIdentityOutput,
    crate::error::UpdateCloudFrontOriginAccessIdentityError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::UpdateCloudFrontOriginAccessIdentityError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::UpdateCloudFrontOriginAccessIdentityError::unhandled(generic))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDenied" => crate::error::UpdateCloudFrontOriginAccessIdentityError { meta: generic, kind: crate::error::UpdateCloudFrontOriginAccessIdentityErrorKind::AccessDenied({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::access_denied::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_access_denied_xml_err(response.body().as_ref(), output).map_err(crate::error::UpdateCloudFrontOriginAccessIdentityError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "IllegalUpdate" => crate::error::UpdateCloudFrontOriginAccessIdentityError { meta: generic, kind: crate::error::UpdateCloudFrontOriginAccessIdentityErrorKind::IllegalUpdate({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::illegal_update::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_illegal_update_xml_err(response.body().as_ref(), output).map_err(crate::error::UpdateCloudFrontOriginAccessIdentityError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InconsistentQuantities" => crate::error::UpdateCloudFrontOriginAccessIdentityError { meta: generic, kind: crate::error::UpdateCloudFrontOriginAccessIdentityErrorKind::InconsistentQuantities({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::inconsistent_quantities::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_inconsistent_quantities_xml_err(response.body().as_ref(), output).map_err(crate::error::UpdateCloudFrontOriginAccessIdentityError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidArgument" => crate::error::UpdateCloudFrontOriginAccessIdentityError { meta: generic, kind: crate::error::UpdateCloudFrontOriginAccessIdentityErrorKind::InvalidArgument({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_argument::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_argument_xml_err(response.body().as_ref(), output).map_err(crate::error::UpdateCloudFrontOriginAccessIdentityError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidIfMatchVersion" => crate::error::UpdateCloudFrontOriginAccessIdentityError { meta: generic, kind: crate::error::UpdateCloudFrontOriginAccessIdentityErrorKind::InvalidIfMatchVersion({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_if_match_version::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_if_match_version_xml_err(response.body().as_ref(), output).map_err(crate::error::UpdateCloudFrontOriginAccessIdentityError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "MissingBody" => crate::error::UpdateCloudFrontOriginAccessIdentityError { meta: generic, kind: crate::error::UpdateCloudFrontOriginAccessIdentityErrorKind::MissingBody({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::missing_body::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_missing_body_xml_err(response.body().as_ref(), output).map_err(crate::error::UpdateCloudFrontOriginAccessIdentityError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "NoSuchCloudFrontOriginAccessIdentity" => crate::error::UpdateCloudFrontOriginAccessIdentityError { meta: generic, kind: crate::error::UpdateCloudFrontOriginAccessIdentityErrorKind::NoSuchCloudFrontOriginAccessIdentity({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::no_such_cloud_front_origin_access_identity::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_no_such_cloud_front_origin_access_identity_xml_err(response.body().as_ref(), output).map_err(crate::error::UpdateCloudFrontOriginAccessIdentityError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "PreconditionFailed" => crate::error::UpdateCloudFrontOriginAccessIdentityError { meta: generic, kind: crate::error::UpdateCloudFrontOriginAccessIdentityErrorKind::PreconditionFailed({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::precondition_failed::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_precondition_failed_xml_err(response.body().as_ref(), output).map_err(crate::error::UpdateCloudFrontOriginAccessIdentityError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::UpdateCloudFrontOriginAccessIdentityError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_cloud_front_origin_access_identity_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UpdateCloudFrontOriginAccessIdentityOutput,
    crate::error::UpdateCloudFrontOriginAccessIdentityError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::update_cloud_front_origin_access_identity_output::Builder::default();
        let _ = response;
        output = output.set_cloud_front_origin_access_identity(
            crate::http_serde::deser_payload_update_cloud_front_origin_access_identity_update_cloud_front_origin_access_identity_output_cloud_front_origin_access_identity(response.body().as_ref())?
        );
        output = output.set_e_tag(
            crate::http_serde::deser_header_update_cloud_front_origin_access_identity_update_cloud_front_origin_access_identity_output_e_tag(response.headers())
                                    .map_err(|_|crate::error::UpdateCloudFrontOriginAccessIdentityError::unhandled("Failed to parse ETag from header `ETag"))?
        );
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_distribution_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UpdateDistributionOutput,
    crate::error::UpdateDistributionError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::UpdateDistributionError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::UpdateDistributionError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDenied" => crate::error::UpdateDistributionError { meta: generic, kind: crate::error::UpdateDistributionErrorKind::AccessDenied({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::access_denied::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_access_denied_xml_err(response.body().as_ref(), output).map_err(crate::error::UpdateDistributionError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "CNAMEAlreadyExists" => crate::error::UpdateDistributionError { meta: generic, kind: crate::error::UpdateDistributionErrorKind::CnameAlreadyExists({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::cname_already_exists::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_cname_already_exists_xml_err(response.body().as_ref(), output).map_err(crate::error::UpdateDistributionError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "IllegalFieldLevelEncryptionConfigAssociationWithCacheBehavior" => crate::error::UpdateDistributionError { meta: generic, kind: crate::error::UpdateDistributionErrorKind::IllegalFieldLevelEncryptionConfigAssociationWithCacheBehavior({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::illegal_field_level_encryption_config_association_with_cache_behavior::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_illegal_field_level_encryption_config_association_with_cache_behavior_xml_err(response.body().as_ref(), output).map_err(crate::error::UpdateDistributionError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "IllegalUpdate" => crate::error::UpdateDistributionError { meta: generic, kind: crate::error::UpdateDistributionErrorKind::IllegalUpdate({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::illegal_update::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_illegal_update_xml_err(response.body().as_ref(), output).map_err(crate::error::UpdateDistributionError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InconsistentQuantities" => crate::error::UpdateDistributionError { meta: generic, kind: crate::error::UpdateDistributionErrorKind::InconsistentQuantities({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::inconsistent_quantities::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_inconsistent_quantities_xml_err(response.body().as_ref(), output).map_err(crate::error::UpdateDistributionError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidArgument" => crate::error::UpdateDistributionError { meta: generic, kind: crate::error::UpdateDistributionErrorKind::InvalidArgument({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_argument::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_argument_xml_err(response.body().as_ref(), output).map_err(crate::error::UpdateDistributionError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidDefaultRootObject" => crate::error::UpdateDistributionError { meta: generic, kind: crate::error::UpdateDistributionErrorKind::InvalidDefaultRootObject({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_default_root_object::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_default_root_object_xml_err(response.body().as_ref(), output).map_err(crate::error::UpdateDistributionError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidErrorCode" => crate::error::UpdateDistributionError { meta: generic, kind: crate::error::UpdateDistributionErrorKind::InvalidErrorCode({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_error_code::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_error_code_xml_err(response.body().as_ref(), output).map_err(crate::error::UpdateDistributionError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidForwardCookies" => crate::error::UpdateDistributionError { meta: generic, kind: crate::error::UpdateDistributionErrorKind::InvalidForwardCookies({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_forward_cookies::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_forward_cookies_xml_err(response.body().as_ref(), output).map_err(crate::error::UpdateDistributionError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidFunctionAssociation" => crate::error::UpdateDistributionError { meta: generic, kind: crate::error::UpdateDistributionErrorKind::InvalidFunctionAssociation({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_function_association::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_function_association_xml_err(response.body().as_ref(), output).map_err(crate::error::UpdateDistributionError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidGeoRestrictionParameter" => crate::error::UpdateDistributionError { meta: generic, kind: crate::error::UpdateDistributionErrorKind::InvalidGeoRestrictionParameter({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_geo_restriction_parameter::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_geo_restriction_parameter_xml_err(response.body().as_ref(), output).map_err(crate::error::UpdateDistributionError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidHeadersForS3Origin" => crate::error::UpdateDistributionError { meta: generic, kind: crate::error::UpdateDistributionErrorKind::InvalidHeadersForS3Origin({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_headers_for_s3_origin::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_headers_for_s3_origin_xml_err(response.body().as_ref(), output).map_err(crate::error::UpdateDistributionError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidIfMatchVersion" => crate::error::UpdateDistributionError { meta: generic, kind: crate::error::UpdateDistributionErrorKind::InvalidIfMatchVersion({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_if_match_version::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_if_match_version_xml_err(response.body().as_ref(), output).map_err(crate::error::UpdateDistributionError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidLambdaFunctionAssociation" => crate::error::UpdateDistributionError { meta: generic, kind: crate::error::UpdateDistributionErrorKind::InvalidLambdaFunctionAssociation({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_lambda_function_association::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_lambda_function_association_xml_err(response.body().as_ref(), output).map_err(crate::error::UpdateDistributionError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidLocationCode" => crate::error::UpdateDistributionError { meta: generic, kind: crate::error::UpdateDistributionErrorKind::InvalidLocationCode({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_location_code::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_location_code_xml_err(response.body().as_ref(), output).map_err(crate::error::UpdateDistributionError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidMinimumProtocolVersion" => crate::error::UpdateDistributionError { meta: generic, kind: crate::error::UpdateDistributionErrorKind::InvalidMinimumProtocolVersion({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_minimum_protocol_version::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_minimum_protocol_version_xml_err(response.body().as_ref(), output).map_err(crate::error::UpdateDistributionError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidOriginAccessIdentity" => crate::error::UpdateDistributionError { meta: generic, kind: crate::error::UpdateDistributionErrorKind::InvalidOriginAccessIdentity({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_origin_access_identity::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_origin_access_identity_xml_err(response.body().as_ref(), output).map_err(crate::error::UpdateDistributionError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidOriginKeepaliveTimeout" => crate::error::UpdateDistributionError { meta: generic, kind: crate::error::UpdateDistributionErrorKind::InvalidOriginKeepaliveTimeout({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_origin_keepalive_timeout::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_origin_keepalive_timeout_xml_err(response.body().as_ref(), output).map_err(crate::error::UpdateDistributionError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidOriginReadTimeout" => crate::error::UpdateDistributionError { meta: generic, kind: crate::error::UpdateDistributionErrorKind::InvalidOriginReadTimeout({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_origin_read_timeout::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_origin_read_timeout_xml_err(response.body().as_ref(), output).map_err(crate::error::UpdateDistributionError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidQueryStringParameters" => crate::error::UpdateDistributionError { meta: generic, kind: crate::error::UpdateDistributionErrorKind::InvalidQueryStringParameters({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_query_string_parameters::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_query_string_parameters_xml_err(response.body().as_ref(), output).map_err(crate::error::UpdateDistributionError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidRelativePath" => crate::error::UpdateDistributionError { meta: generic, kind: crate::error::UpdateDistributionErrorKind::InvalidRelativePath({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_relative_path::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_relative_path_xml_err(response.body().as_ref(), output).map_err(crate::error::UpdateDistributionError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidRequiredProtocol" => crate::error::UpdateDistributionError { meta: generic, kind: crate::error::UpdateDistributionErrorKind::InvalidRequiredProtocol({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_required_protocol::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_required_protocol_xml_err(response.body().as_ref(), output).map_err(crate::error::UpdateDistributionError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidResponseCode" => crate::error::UpdateDistributionError { meta: generic, kind: crate::error::UpdateDistributionErrorKind::InvalidResponseCode({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_response_code::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_response_code_xml_err(response.body().as_ref(), output).map_err(crate::error::UpdateDistributionError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidTTLOrder" => crate::error::UpdateDistributionError { meta: generic, kind: crate::error::UpdateDistributionErrorKind::InvalidTtlOrder({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_ttl_order::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_ttl_order_xml_err(response.body().as_ref(), output).map_err(crate::error::UpdateDistributionError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidViewerCertificate" => crate::error::UpdateDistributionError { meta: generic, kind: crate::error::UpdateDistributionErrorKind::InvalidViewerCertificate({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_viewer_certificate::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_viewer_certificate_xml_err(response.body().as_ref(), output).map_err(crate::error::UpdateDistributionError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidWebACLId" => crate::error::UpdateDistributionError { meta: generic, kind: crate::error::UpdateDistributionErrorKind::InvalidWebAclId({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_web_acl_id::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_web_acl_id_xml_err(response.body().as_ref(), output).map_err(crate::error::UpdateDistributionError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "MissingBody" => crate::error::UpdateDistributionError { meta: generic, kind: crate::error::UpdateDistributionErrorKind::MissingBody({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::missing_body::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_missing_body_xml_err(response.body().as_ref(), output).map_err(crate::error::UpdateDistributionError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "NoSuchCachePolicy" => crate::error::UpdateDistributionError { meta: generic, kind: crate::error::UpdateDistributionErrorKind::NoSuchCachePolicy({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::no_such_cache_policy::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_no_such_cache_policy_xml_err(response.body().as_ref(), output).map_err(crate::error::UpdateDistributionError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "NoSuchDistribution" => crate::error::UpdateDistributionError { meta: generic, kind: crate::error::UpdateDistributionErrorKind::NoSuchDistribution({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::no_such_distribution::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_no_such_distribution_xml_err(response.body().as_ref(), output).map_err(crate::error::UpdateDistributionError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "NoSuchFieldLevelEncryptionConfig" => crate::error::UpdateDistributionError { meta: generic, kind: crate::error::UpdateDistributionErrorKind::NoSuchFieldLevelEncryptionConfig({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::no_such_field_level_encryption_config::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_no_such_field_level_encryption_config_xml_err(response.body().as_ref(), output).map_err(crate::error::UpdateDistributionError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "NoSuchOrigin" => crate::error::UpdateDistributionError { meta: generic, kind: crate::error::UpdateDistributionErrorKind::NoSuchOrigin({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::no_such_origin::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_no_such_origin_xml_err(response.body().as_ref(), output).map_err(crate::error::UpdateDistributionError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "NoSuchOriginRequestPolicy" => crate::error::UpdateDistributionError { meta: generic, kind: crate::error::UpdateDistributionErrorKind::NoSuchOriginRequestPolicy({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::no_such_origin_request_policy::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_no_such_origin_request_policy_xml_err(response.body().as_ref(), output).map_err(crate::error::UpdateDistributionError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "NoSuchRealtimeLogConfig" => crate::error::UpdateDistributionError { meta: generic, kind: crate::error::UpdateDistributionErrorKind::NoSuchRealtimeLogConfig({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::no_such_realtime_log_config::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_no_such_realtime_log_config_xml_err(response.body().as_ref(), output).map_err(crate::error::UpdateDistributionError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "NoSuchResponseHeadersPolicy" => crate::error::UpdateDistributionError { meta: generic, kind: crate::error::UpdateDistributionErrorKind::NoSuchResponseHeadersPolicy({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::no_such_response_headers_policy::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_no_such_response_headers_policy_xml_err(response.body().as_ref(), output).map_err(crate::error::UpdateDistributionError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "PreconditionFailed" => crate::error::UpdateDistributionError { meta: generic, kind: crate::error::UpdateDistributionErrorKind::PreconditionFailed({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::precondition_failed::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_precondition_failed_xml_err(response.body().as_ref(), output).map_err(crate::error::UpdateDistributionError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "RealtimeLogConfigOwnerMismatch" => crate::error::UpdateDistributionError { meta: generic, kind: crate::error::UpdateDistributionErrorKind::RealtimeLogConfigOwnerMismatch({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::realtime_log_config_owner_mismatch::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_realtime_log_config_owner_mismatch_xml_err(response.body().as_ref(), output).map_err(crate::error::UpdateDistributionError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "TooManyCacheBehaviors" => crate::error::UpdateDistributionError { meta: generic, kind: crate::error::UpdateDistributionErrorKind::TooManyCacheBehaviors({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::too_many_cache_behaviors::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_too_many_cache_behaviors_xml_err(response.body().as_ref(), output).map_err(crate::error::UpdateDistributionError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "TooManyCertificates" => crate::error::UpdateDistributionError { meta: generic, kind: crate::error::UpdateDistributionErrorKind::TooManyCertificates({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::too_many_certificates::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_too_many_certificates_xml_err(response.body().as_ref(), output).map_err(crate::error::UpdateDistributionError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "TooManyCookieNamesInWhiteList" => crate::error::UpdateDistributionError { meta: generic, kind: crate::error::UpdateDistributionErrorKind::TooManyCookieNamesInWhiteList({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::too_many_cookie_names_in_white_list::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_too_many_cookie_names_in_white_list_xml_err(response.body().as_ref(), output).map_err(crate::error::UpdateDistributionError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "TooManyDistributionCNAMEs" => crate::error::UpdateDistributionError { meta: generic, kind: crate::error::UpdateDistributionErrorKind::TooManyDistributionCnamEs({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::too_many_distribution_cnam_es::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_too_many_distribution_cnam_es_xml_err(response.body().as_ref(), output).map_err(crate::error::UpdateDistributionError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "TooManyDistributionsAssociatedToCachePolicy" => crate::error::UpdateDistributionError { meta: generic, kind: crate::error::UpdateDistributionErrorKind::TooManyDistributionsAssociatedToCachePolicy({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::too_many_distributions_associated_to_cache_policy::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_too_many_distributions_associated_to_cache_policy_xml_err(response.body().as_ref(), output).map_err(crate::error::UpdateDistributionError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "TooManyDistributionsAssociatedToFieldLevelEncryptionConfig" => crate::error::UpdateDistributionError { meta: generic, kind: crate::error::UpdateDistributionErrorKind::TooManyDistributionsAssociatedToFieldLevelEncryptionConfig({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::too_many_distributions_associated_to_field_level_encryption_config::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_too_many_distributions_associated_to_field_level_encryption_config_xml_err(response.body().as_ref(), output).map_err(crate::error::UpdateDistributionError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "TooManyDistributionsAssociatedToKeyGroup" => crate::error::UpdateDistributionError { meta: generic, kind: crate::error::UpdateDistributionErrorKind::TooManyDistributionsAssociatedToKeyGroup({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::too_many_distributions_associated_to_key_group::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_too_many_distributions_associated_to_key_group_xml_err(response.body().as_ref(), output).map_err(crate::error::UpdateDistributionError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "TooManyDistributionsAssociatedToOriginRequestPolicy" => crate::error::UpdateDistributionError { meta: generic, kind: crate::error::UpdateDistributionErrorKind::TooManyDistributionsAssociatedToOriginRequestPolicy({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::too_many_distributions_associated_to_origin_request_policy::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_too_many_distributions_associated_to_origin_request_policy_xml_err(response.body().as_ref(), output).map_err(crate::error::UpdateDistributionError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "TooManyDistributionsAssociatedToResponseHeadersPolicy" => crate::error::UpdateDistributionError { meta: generic, kind: crate::error::UpdateDistributionErrorKind::TooManyDistributionsAssociatedToResponseHeadersPolicy({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::too_many_distributions_associated_to_response_headers_policy::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_too_many_distributions_associated_to_response_headers_policy_xml_err(response.body().as_ref(), output).map_err(crate::error::UpdateDistributionError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "TooManyDistributionsWithFunctionAssociations" => crate::error::UpdateDistributionError { meta: generic, kind: crate::error::UpdateDistributionErrorKind::TooManyDistributionsWithFunctionAssociations({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::too_many_distributions_with_function_associations::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_too_many_distributions_with_function_associations_xml_err(response.body().as_ref(), output).map_err(crate::error::UpdateDistributionError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "TooManyDistributionsWithLambdaAssociations" => crate::error::UpdateDistributionError { meta: generic, kind: crate::error::UpdateDistributionErrorKind::TooManyDistributionsWithLambdaAssociations({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::too_many_distributions_with_lambda_associations::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_too_many_distributions_with_lambda_associations_xml_err(response.body().as_ref(), output).map_err(crate::error::UpdateDistributionError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "TooManyDistributionsWithSingleFunctionARN" => crate::error::UpdateDistributionError { meta: generic, kind: crate::error::UpdateDistributionErrorKind::TooManyDistributionsWithSingleFunctionArn({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::too_many_distributions_with_single_function_arn::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_too_many_distributions_with_single_function_arn_xml_err(response.body().as_ref(), output).map_err(crate::error::UpdateDistributionError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "TooManyFunctionAssociations" => crate::error::UpdateDistributionError { meta: generic, kind: crate::error::UpdateDistributionErrorKind::TooManyFunctionAssociations({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::too_many_function_associations::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_too_many_function_associations_xml_err(response.body().as_ref(), output).map_err(crate::error::UpdateDistributionError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "TooManyHeadersInForwardedValues" => crate::error::UpdateDistributionError { meta: generic, kind: crate::error::UpdateDistributionErrorKind::TooManyHeadersInForwardedValues({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::too_many_headers_in_forwarded_values::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_too_many_headers_in_forwarded_values_xml_err(response.body().as_ref(), output).map_err(crate::error::UpdateDistributionError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "TooManyKeyGroupsAssociatedToDistribution" => crate::error::UpdateDistributionError { meta: generic, kind: crate::error::UpdateDistributionErrorKind::TooManyKeyGroupsAssociatedToDistribution({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::too_many_key_groups_associated_to_distribution::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_too_many_key_groups_associated_to_distribution_xml_err(response.body().as_ref(), output).map_err(crate::error::UpdateDistributionError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "TooManyLambdaFunctionAssociations" => crate::error::UpdateDistributionError { meta: generic, kind: crate::error::UpdateDistributionErrorKind::TooManyLambdaFunctionAssociations({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::too_many_lambda_function_associations::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_too_many_lambda_function_associations_xml_err(response.body().as_ref(), output).map_err(crate::error::UpdateDistributionError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "TooManyOriginCustomHeaders" => crate::error::UpdateDistributionError { meta: generic, kind: crate::error::UpdateDistributionErrorKind::TooManyOriginCustomHeaders({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::too_many_origin_custom_headers::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_too_many_origin_custom_headers_xml_err(response.body().as_ref(), output).map_err(crate::error::UpdateDistributionError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "TooManyOriginGroupsPerDistribution" => crate::error::UpdateDistributionError { meta: generic, kind: crate::error::UpdateDistributionErrorKind::TooManyOriginGroupsPerDistribution({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::too_many_origin_groups_per_distribution::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_too_many_origin_groups_per_distribution_xml_err(response.body().as_ref(), output).map_err(crate::error::UpdateDistributionError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "TooManyOrigins" => crate::error::UpdateDistributionError { meta: generic, kind: crate::error::UpdateDistributionErrorKind::TooManyOrigins({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::too_many_origins::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_too_many_origins_xml_err(response.body().as_ref(), output).map_err(crate::error::UpdateDistributionError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "TooManyQueryStringParameters" => crate::error::UpdateDistributionError { meta: generic, kind: crate::error::UpdateDistributionErrorKind::TooManyQueryStringParameters({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::too_many_query_string_parameters::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_too_many_query_string_parameters_xml_err(response.body().as_ref(), output).map_err(crate::error::UpdateDistributionError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "TooManyTrustedSigners" => crate::error::UpdateDistributionError { meta: generic, kind: crate::error::UpdateDistributionErrorKind::TooManyTrustedSigners({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::too_many_trusted_signers::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_too_many_trusted_signers_xml_err(response.body().as_ref(), output).map_err(crate::error::UpdateDistributionError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "TrustedKeyGroupDoesNotExist" => crate::error::UpdateDistributionError { meta: generic, kind: crate::error::UpdateDistributionErrorKind::TrustedKeyGroupDoesNotExist({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::trusted_key_group_does_not_exist::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_trusted_key_group_does_not_exist_xml_err(response.body().as_ref(), output).map_err(crate::error::UpdateDistributionError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "TrustedSignerDoesNotExist" => crate::error::UpdateDistributionError { meta: generic, kind: crate::error::UpdateDistributionErrorKind::TrustedSignerDoesNotExist({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::trusted_signer_does_not_exist::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_trusted_signer_does_not_exist_xml_err(response.body().as_ref(), output).map_err(crate::error::UpdateDistributionError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::UpdateDistributionError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_distribution_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UpdateDistributionOutput,
    crate::error::UpdateDistributionError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::update_distribution_output::Builder::default();
        let _ = response;
        output = output.set_distribution(
            crate::http_serde::deser_payload_update_distribution_update_distribution_output_distribution(response.body().as_ref())?
        );
        output = output.set_e_tag(
            crate::http_serde::deser_header_update_distribution_update_distribution_output_e_tag(
                response.headers(),
            )
            .map_err(|_| {
                crate::error::UpdateDistributionError::unhandled(
                    "Failed to parse ETag from header `ETag",
                )
            })?,
        );
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_field_level_encryption_config_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UpdateFieldLevelEncryptionConfigOutput,
    crate::error::UpdateFieldLevelEncryptionConfigError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::UpdateFieldLevelEncryptionConfigError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::UpdateFieldLevelEncryptionConfigError::unhandled(generic))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDenied" => crate::error::UpdateFieldLevelEncryptionConfigError { meta: generic, kind: crate::error::UpdateFieldLevelEncryptionConfigErrorKind::AccessDenied({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::access_denied::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_access_denied_xml_err(response.body().as_ref(), output).map_err(crate::error::UpdateFieldLevelEncryptionConfigError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "IllegalUpdate" => crate::error::UpdateFieldLevelEncryptionConfigError { meta: generic, kind: crate::error::UpdateFieldLevelEncryptionConfigErrorKind::IllegalUpdate({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::illegal_update::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_illegal_update_xml_err(response.body().as_ref(), output).map_err(crate::error::UpdateFieldLevelEncryptionConfigError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InconsistentQuantities" => crate::error::UpdateFieldLevelEncryptionConfigError { meta: generic, kind: crate::error::UpdateFieldLevelEncryptionConfigErrorKind::InconsistentQuantities({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::inconsistent_quantities::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_inconsistent_quantities_xml_err(response.body().as_ref(), output).map_err(crate::error::UpdateFieldLevelEncryptionConfigError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidArgument" => crate::error::UpdateFieldLevelEncryptionConfigError { meta: generic, kind: crate::error::UpdateFieldLevelEncryptionConfigErrorKind::InvalidArgument({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_argument::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_argument_xml_err(response.body().as_ref(), output).map_err(crate::error::UpdateFieldLevelEncryptionConfigError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidIfMatchVersion" => crate::error::UpdateFieldLevelEncryptionConfigError { meta: generic, kind: crate::error::UpdateFieldLevelEncryptionConfigErrorKind::InvalidIfMatchVersion({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_if_match_version::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_if_match_version_xml_err(response.body().as_ref(), output).map_err(crate::error::UpdateFieldLevelEncryptionConfigError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "NoSuchFieldLevelEncryptionConfig" => crate::error::UpdateFieldLevelEncryptionConfigError { meta: generic, kind: crate::error::UpdateFieldLevelEncryptionConfigErrorKind::NoSuchFieldLevelEncryptionConfig({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::no_such_field_level_encryption_config::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_no_such_field_level_encryption_config_xml_err(response.body().as_ref(), output).map_err(crate::error::UpdateFieldLevelEncryptionConfigError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "NoSuchFieldLevelEncryptionProfile" => crate::error::UpdateFieldLevelEncryptionConfigError { meta: generic, kind: crate::error::UpdateFieldLevelEncryptionConfigErrorKind::NoSuchFieldLevelEncryptionProfile({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::no_such_field_level_encryption_profile::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_no_such_field_level_encryption_profile_xml_err(response.body().as_ref(), output).map_err(crate::error::UpdateFieldLevelEncryptionConfigError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "PreconditionFailed" => crate::error::UpdateFieldLevelEncryptionConfigError { meta: generic, kind: crate::error::UpdateFieldLevelEncryptionConfigErrorKind::PreconditionFailed({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::precondition_failed::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_precondition_failed_xml_err(response.body().as_ref(), output).map_err(crate::error::UpdateFieldLevelEncryptionConfigError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "QueryArgProfileEmpty" => crate::error::UpdateFieldLevelEncryptionConfigError { meta: generic, kind: crate::error::UpdateFieldLevelEncryptionConfigErrorKind::QueryArgProfileEmpty({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::query_arg_profile_empty::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_query_arg_profile_empty_xml_err(response.body().as_ref(), output).map_err(crate::error::UpdateFieldLevelEncryptionConfigError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "TooManyFieldLevelEncryptionContentTypeProfiles" => crate::error::UpdateFieldLevelEncryptionConfigError { meta: generic, kind: crate::error::UpdateFieldLevelEncryptionConfigErrorKind::TooManyFieldLevelEncryptionContentTypeProfiles({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::too_many_field_level_encryption_content_type_profiles::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_too_many_field_level_encryption_content_type_profiles_xml_err(response.body().as_ref(), output).map_err(crate::error::UpdateFieldLevelEncryptionConfigError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "TooManyFieldLevelEncryptionQueryArgProfiles" => crate::error::UpdateFieldLevelEncryptionConfigError { meta: generic, kind: crate::error::UpdateFieldLevelEncryptionConfigErrorKind::TooManyFieldLevelEncryptionQueryArgProfiles({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::too_many_field_level_encryption_query_arg_profiles::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_too_many_field_level_encryption_query_arg_profiles_xml_err(response.body().as_ref(), output).map_err(crate::error::UpdateFieldLevelEncryptionConfigError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::UpdateFieldLevelEncryptionConfigError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_field_level_encryption_config_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UpdateFieldLevelEncryptionConfigOutput,
    crate::error::UpdateFieldLevelEncryptionConfigError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::update_field_level_encryption_config_output::Builder::default();
        let _ = response;
        output = output.set_e_tag(
            crate::http_serde::deser_header_update_field_level_encryption_config_update_field_level_encryption_config_output_e_tag(response.headers())
                                    .map_err(|_|crate::error::UpdateFieldLevelEncryptionConfigError::unhandled("Failed to parse ETag from header `ETag"))?
        );
        output = output.set_field_level_encryption(
            crate::http_serde::deser_payload_update_field_level_encryption_config_update_field_level_encryption_config_output_field_level_encryption(response.body().as_ref())?
        );
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_field_level_encryption_profile_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UpdateFieldLevelEncryptionProfileOutput,
    crate::error::UpdateFieldLevelEncryptionProfileError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::UpdateFieldLevelEncryptionProfileError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::UpdateFieldLevelEncryptionProfileError::unhandled(generic))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDenied" => crate::error::UpdateFieldLevelEncryptionProfileError { meta: generic, kind: crate::error::UpdateFieldLevelEncryptionProfileErrorKind::AccessDenied({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::access_denied::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_access_denied_xml_err(response.body().as_ref(), output).map_err(crate::error::UpdateFieldLevelEncryptionProfileError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "FieldLevelEncryptionProfileAlreadyExists" => crate::error::UpdateFieldLevelEncryptionProfileError { meta: generic, kind: crate::error::UpdateFieldLevelEncryptionProfileErrorKind::FieldLevelEncryptionProfileAlreadyExists({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::field_level_encryption_profile_already_exists::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_field_level_encryption_profile_already_exists_xml_err(response.body().as_ref(), output).map_err(crate::error::UpdateFieldLevelEncryptionProfileError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "FieldLevelEncryptionProfileSizeExceeded" => crate::error::UpdateFieldLevelEncryptionProfileError { meta: generic, kind: crate::error::UpdateFieldLevelEncryptionProfileErrorKind::FieldLevelEncryptionProfileSizeExceeded({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::field_level_encryption_profile_size_exceeded::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_field_level_encryption_profile_size_exceeded_xml_err(response.body().as_ref(), output).map_err(crate::error::UpdateFieldLevelEncryptionProfileError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "IllegalUpdate" => crate::error::UpdateFieldLevelEncryptionProfileError { meta: generic, kind: crate::error::UpdateFieldLevelEncryptionProfileErrorKind::IllegalUpdate({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::illegal_update::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_illegal_update_xml_err(response.body().as_ref(), output).map_err(crate::error::UpdateFieldLevelEncryptionProfileError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InconsistentQuantities" => crate::error::UpdateFieldLevelEncryptionProfileError { meta: generic, kind: crate::error::UpdateFieldLevelEncryptionProfileErrorKind::InconsistentQuantities({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::inconsistent_quantities::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_inconsistent_quantities_xml_err(response.body().as_ref(), output).map_err(crate::error::UpdateFieldLevelEncryptionProfileError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidArgument" => crate::error::UpdateFieldLevelEncryptionProfileError { meta: generic, kind: crate::error::UpdateFieldLevelEncryptionProfileErrorKind::InvalidArgument({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_argument::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_argument_xml_err(response.body().as_ref(), output).map_err(crate::error::UpdateFieldLevelEncryptionProfileError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidIfMatchVersion" => crate::error::UpdateFieldLevelEncryptionProfileError { meta: generic, kind: crate::error::UpdateFieldLevelEncryptionProfileErrorKind::InvalidIfMatchVersion({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_if_match_version::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_if_match_version_xml_err(response.body().as_ref(), output).map_err(crate::error::UpdateFieldLevelEncryptionProfileError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "NoSuchFieldLevelEncryptionProfile" => crate::error::UpdateFieldLevelEncryptionProfileError { meta: generic, kind: crate::error::UpdateFieldLevelEncryptionProfileErrorKind::NoSuchFieldLevelEncryptionProfile({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::no_such_field_level_encryption_profile::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_no_such_field_level_encryption_profile_xml_err(response.body().as_ref(), output).map_err(crate::error::UpdateFieldLevelEncryptionProfileError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "NoSuchPublicKey" => crate::error::UpdateFieldLevelEncryptionProfileError { meta: generic, kind: crate::error::UpdateFieldLevelEncryptionProfileErrorKind::NoSuchPublicKey({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::no_such_public_key::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_no_such_public_key_xml_err(response.body().as_ref(), output).map_err(crate::error::UpdateFieldLevelEncryptionProfileError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "PreconditionFailed" => crate::error::UpdateFieldLevelEncryptionProfileError { meta: generic, kind: crate::error::UpdateFieldLevelEncryptionProfileErrorKind::PreconditionFailed({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::precondition_failed::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_precondition_failed_xml_err(response.body().as_ref(), output).map_err(crate::error::UpdateFieldLevelEncryptionProfileError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "TooManyFieldLevelEncryptionEncryptionEntities" => crate::error::UpdateFieldLevelEncryptionProfileError { meta: generic, kind: crate::error::UpdateFieldLevelEncryptionProfileErrorKind::TooManyFieldLevelEncryptionEncryptionEntities({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::too_many_field_level_encryption_encryption_entities::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_too_many_field_level_encryption_encryption_entities_xml_err(response.body().as_ref(), output).map_err(crate::error::UpdateFieldLevelEncryptionProfileError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "TooManyFieldLevelEncryptionFieldPatterns" => crate::error::UpdateFieldLevelEncryptionProfileError { meta: generic, kind: crate::error::UpdateFieldLevelEncryptionProfileErrorKind::TooManyFieldLevelEncryptionFieldPatterns({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::too_many_field_level_encryption_field_patterns::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_too_many_field_level_encryption_field_patterns_xml_err(response.body().as_ref(), output).map_err(crate::error::UpdateFieldLevelEncryptionProfileError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::UpdateFieldLevelEncryptionProfileError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_field_level_encryption_profile_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UpdateFieldLevelEncryptionProfileOutput,
    crate::error::UpdateFieldLevelEncryptionProfileError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::update_field_level_encryption_profile_output::Builder::default();
        let _ = response;
        output = output.set_e_tag(
            crate::http_serde::deser_header_update_field_level_encryption_profile_update_field_level_encryption_profile_output_e_tag(response.headers())
                                    .map_err(|_|crate::error::UpdateFieldLevelEncryptionProfileError::unhandled("Failed to parse ETag from header `ETag"))?
        );
        output = output.set_field_level_encryption_profile(
            crate::http_serde::deser_payload_update_field_level_encryption_profile_update_field_level_encryption_profile_output_field_level_encryption_profile(response.body().as_ref())?
        );
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_function_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::UpdateFunctionOutput, crate::error::UpdateFunctionError> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::UpdateFunctionError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::UpdateFunctionError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "FunctionSizeLimitExceeded" => crate::error::UpdateFunctionError {
            meta: generic,
            kind: crate::error::UpdateFunctionErrorKind::FunctionSizeLimitExceeded({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::function_size_limit_exceeded::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_function_size_limit_exceeded_xml_err(response.body().as_ref(), output).map_err(crate::error::UpdateFunctionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidArgument" => crate::error::UpdateFunctionError {
            meta: generic,
            kind: crate::error::UpdateFunctionErrorKind::InvalidArgument({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_argument::Builder::default();
                    let _ = response;
                    output =
                        crate::xml_deser::deser_structure_crate_error_invalid_argument_xml_err(
                            response.body().as_ref(),
                            output,
                        )
                        .map_err(crate::error::UpdateFunctionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidIfMatchVersion" => crate::error::UpdateFunctionError {
            meta: generic,
            kind: crate::error::UpdateFunctionErrorKind::InvalidIfMatchVersion({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_if_match_version::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_if_match_version_xml_err(response.body().as_ref(), output).map_err(crate::error::UpdateFunctionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NoSuchFunctionExists" => crate::error::UpdateFunctionError {
            meta: generic,
            kind: crate::error::UpdateFunctionErrorKind::NoSuchFunctionExists({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::no_such_function_exists::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_no_such_function_exists_xml_err(response.body().as_ref(), output).map_err(crate::error::UpdateFunctionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "PreconditionFailed" => {
            crate::error::UpdateFunctionError {
                meta: generic,
                kind: crate::error::UpdateFunctionErrorKind::PreconditionFailed({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::precondition_failed::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_precondition_failed_xml_err(response.body().as_ref(), output).map_err(crate::error::UpdateFunctionError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "UnsupportedOperation" => crate::error::UpdateFunctionError {
            meta: generic,
            kind: crate::error::UpdateFunctionErrorKind::UnsupportedOperation({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::unsupported_operation::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_unsupported_operation_xml_err(response.body().as_ref(), output).map_err(crate::error::UpdateFunctionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::UpdateFunctionError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_function_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::UpdateFunctionOutput, crate::error::UpdateFunctionError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::update_function_output::Builder::default();
        let _ = response;
        output = output.set_e_tag(
            crate::http_serde::deser_header_update_function_update_function_output_e_tag(
                response.headers(),
            )
            .map_err(|_| {
                crate::error::UpdateFunctionError::unhandled(
                    "Failed to parse ETag from header `ETtag",
                )
            })?,
        );
        output = output.set_function_summary(
            crate::http_serde::deser_payload_update_function_update_function_output_function_summary(response.body().as_ref())?
        );
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_key_group_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::UpdateKeyGroupOutput, crate::error::UpdateKeyGroupError> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::UpdateKeyGroupError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::UpdateKeyGroupError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidArgument" => crate::error::UpdateKeyGroupError {
            meta: generic,
            kind: crate::error::UpdateKeyGroupErrorKind::InvalidArgument({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_argument::Builder::default();
                    let _ = response;
                    output =
                        crate::xml_deser::deser_structure_crate_error_invalid_argument_xml_err(
                            response.body().as_ref(),
                            output,
                        )
                        .map_err(crate::error::UpdateKeyGroupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidIfMatchVersion" => crate::error::UpdateKeyGroupError {
            meta: generic,
            kind: crate::error::UpdateKeyGroupErrorKind::InvalidIfMatchVersion({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_if_match_version::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_if_match_version_xml_err(response.body().as_ref(), output).map_err(crate::error::UpdateKeyGroupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "KeyGroupAlreadyExists" => crate::error::UpdateKeyGroupError {
            meta: generic,
            kind: crate::error::UpdateKeyGroupErrorKind::KeyGroupAlreadyExists({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::key_group_already_exists::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_key_group_already_exists_xml_err(response.body().as_ref(), output).map_err(crate::error::UpdateKeyGroupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NoSuchResource" => crate::error::UpdateKeyGroupError {
            meta: generic,
            kind: crate::error::UpdateKeyGroupErrorKind::NoSuchResource({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::no_such_resource::Builder::default();
                    let _ = response;
                    output =
                        crate::xml_deser::deser_structure_crate_error_no_such_resource_xml_err(
                            response.body().as_ref(),
                            output,
                        )
                        .map_err(crate::error::UpdateKeyGroupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "PreconditionFailed" => {
            crate::error::UpdateKeyGroupError {
                meta: generic,
                kind: crate::error::UpdateKeyGroupErrorKind::PreconditionFailed({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::precondition_failed::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_precondition_failed_xml_err(response.body().as_ref(), output).map_err(crate::error::UpdateKeyGroupError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "TooManyPublicKeysInKeyGroup" => crate::error::UpdateKeyGroupError {
            meta: generic,
            kind: crate::error::UpdateKeyGroupErrorKind::TooManyPublicKeysInKeyGroup({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::too_many_public_keys_in_key_group::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_too_many_public_keys_in_key_group_xml_err(response.body().as_ref(), output).map_err(crate::error::UpdateKeyGroupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::UpdateKeyGroupError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_key_group_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::UpdateKeyGroupOutput, crate::error::UpdateKeyGroupError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::update_key_group_output::Builder::default();
        let _ = response;
        output = output.set_e_tag(
            crate::http_serde::deser_header_update_key_group_update_key_group_output_e_tag(
                response.headers(),
            )
            .map_err(|_| {
                crate::error::UpdateKeyGroupError::unhandled(
                    "Failed to parse ETag from header `ETag",
                )
            })?,
        );
        output = output.set_key_group(
            crate::http_serde::deser_payload_update_key_group_update_key_group_output_key_group(
                response.body().as_ref(),
            )?,
        );
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_origin_request_policy_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UpdateOriginRequestPolicyOutput,
    crate::error::UpdateOriginRequestPolicyError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::UpdateOriginRequestPolicyError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::UpdateOriginRequestPolicyError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDenied" => crate::error::UpdateOriginRequestPolicyError { meta: generic, kind: crate::error::UpdateOriginRequestPolicyErrorKind::AccessDenied({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::access_denied::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_access_denied_xml_err(response.body().as_ref(), output).map_err(crate::error::UpdateOriginRequestPolicyError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "IllegalUpdate" => crate::error::UpdateOriginRequestPolicyError { meta: generic, kind: crate::error::UpdateOriginRequestPolicyErrorKind::IllegalUpdate({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::illegal_update::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_illegal_update_xml_err(response.body().as_ref(), output).map_err(crate::error::UpdateOriginRequestPolicyError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InconsistentQuantities" => crate::error::UpdateOriginRequestPolicyError { meta: generic, kind: crate::error::UpdateOriginRequestPolicyErrorKind::InconsistentQuantities({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::inconsistent_quantities::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_inconsistent_quantities_xml_err(response.body().as_ref(), output).map_err(crate::error::UpdateOriginRequestPolicyError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidArgument" => crate::error::UpdateOriginRequestPolicyError { meta: generic, kind: crate::error::UpdateOriginRequestPolicyErrorKind::InvalidArgument({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_argument::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_argument_xml_err(response.body().as_ref(), output).map_err(crate::error::UpdateOriginRequestPolicyError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidIfMatchVersion" => crate::error::UpdateOriginRequestPolicyError { meta: generic, kind: crate::error::UpdateOriginRequestPolicyErrorKind::InvalidIfMatchVersion({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_if_match_version::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_if_match_version_xml_err(response.body().as_ref(), output).map_err(crate::error::UpdateOriginRequestPolicyError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "NoSuchOriginRequestPolicy" => crate::error::UpdateOriginRequestPolicyError { meta: generic, kind: crate::error::UpdateOriginRequestPolicyErrorKind::NoSuchOriginRequestPolicy({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::no_such_origin_request_policy::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_no_such_origin_request_policy_xml_err(response.body().as_ref(), output).map_err(crate::error::UpdateOriginRequestPolicyError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "OriginRequestPolicyAlreadyExists" => crate::error::UpdateOriginRequestPolicyError { meta: generic, kind: crate::error::UpdateOriginRequestPolicyErrorKind::OriginRequestPolicyAlreadyExists({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::origin_request_policy_already_exists::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_origin_request_policy_already_exists_xml_err(response.body().as_ref(), output).map_err(crate::error::UpdateOriginRequestPolicyError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "PreconditionFailed" => crate::error::UpdateOriginRequestPolicyError { meta: generic, kind: crate::error::UpdateOriginRequestPolicyErrorKind::PreconditionFailed({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::precondition_failed::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_precondition_failed_xml_err(response.body().as_ref(), output).map_err(crate::error::UpdateOriginRequestPolicyError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "TooManyCookiesInOriginRequestPolicy" => crate::error::UpdateOriginRequestPolicyError { meta: generic, kind: crate::error::UpdateOriginRequestPolicyErrorKind::TooManyCookiesInOriginRequestPolicy({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::too_many_cookies_in_origin_request_policy::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_too_many_cookies_in_origin_request_policy_xml_err(response.body().as_ref(), output).map_err(crate::error::UpdateOriginRequestPolicyError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "TooManyHeadersInOriginRequestPolicy" => crate::error::UpdateOriginRequestPolicyError { meta: generic, kind: crate::error::UpdateOriginRequestPolicyErrorKind::TooManyHeadersInOriginRequestPolicy({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::too_many_headers_in_origin_request_policy::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_too_many_headers_in_origin_request_policy_xml_err(response.body().as_ref(), output).map_err(crate::error::UpdateOriginRequestPolicyError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "TooManyQueryStringsInOriginRequestPolicy" => crate::error::UpdateOriginRequestPolicyError { meta: generic, kind: crate::error::UpdateOriginRequestPolicyErrorKind::TooManyQueryStringsInOriginRequestPolicy({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::too_many_query_strings_in_origin_request_policy::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_too_many_query_strings_in_origin_request_policy_xml_err(response.body().as_ref(), output).map_err(crate::error::UpdateOriginRequestPolicyError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::UpdateOriginRequestPolicyError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_origin_request_policy_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UpdateOriginRequestPolicyOutput,
    crate::error::UpdateOriginRequestPolicyError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::update_origin_request_policy_output::Builder::default();
        let _ = response;
        output = output.set_e_tag(
            crate::http_serde::deser_header_update_origin_request_policy_update_origin_request_policy_output_e_tag(response.headers())
                                    .map_err(|_|crate::error::UpdateOriginRequestPolicyError::unhandled("Failed to parse ETag from header `ETag"))?
        );
        output = output.set_origin_request_policy(
            crate::http_serde::deser_payload_update_origin_request_policy_update_origin_request_policy_output_origin_request_policy(response.body().as_ref())?
        );
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_public_key_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::UpdatePublicKeyOutput, crate::error::UpdatePublicKeyError> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::UpdatePublicKeyError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::UpdatePublicKeyError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDenied" => crate::error::UpdatePublicKeyError {
            meta: generic,
            kind: crate::error::UpdatePublicKeyErrorKind::AccessDenied({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_access_denied_xml_err(
                        response.body().as_ref(),
                        output,
                    )
                    .map_err(crate::error::UpdatePublicKeyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "CannotChangeImmutablePublicKeyFields" => crate::error::UpdatePublicKeyError {
            meta: generic,
            kind: crate::error::UpdatePublicKeyErrorKind::CannotChangeImmutablePublicKeyFields({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::cannot_change_immutable_public_key_fields::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_cannot_change_immutable_public_key_fields_xml_err(response.body().as_ref(), output).map_err(crate::error::UpdatePublicKeyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "IllegalUpdate" => crate::error::UpdatePublicKeyError {
            meta: generic,
            kind: crate::error::UpdatePublicKeyErrorKind::IllegalUpdate({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::illegal_update::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_illegal_update_xml_err(
                        response.body().as_ref(),
                        output,
                    )
                    .map_err(crate::error::UpdatePublicKeyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidArgument" => crate::error::UpdatePublicKeyError {
            meta: generic,
            kind: crate::error::UpdatePublicKeyErrorKind::InvalidArgument({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_argument::Builder::default();
                    let _ = response;
                    output =
                        crate::xml_deser::deser_structure_crate_error_invalid_argument_xml_err(
                            response.body().as_ref(),
                            output,
                        )
                        .map_err(crate::error::UpdatePublicKeyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidIfMatchVersion" => crate::error::UpdatePublicKeyError {
            meta: generic,
            kind: crate::error::UpdatePublicKeyErrorKind::InvalidIfMatchVersion({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_if_match_version::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_if_match_version_xml_err(response.body().as_ref(), output).map_err(crate::error::UpdatePublicKeyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NoSuchPublicKey" => {
            crate::error::UpdatePublicKeyError {
                meta: generic,
                kind: crate::error::UpdatePublicKeyErrorKind::NoSuchPublicKey({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::no_such_public_key::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_no_such_public_key_xml_err(response.body().as_ref(), output).map_err(crate::error::UpdatePublicKeyError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "PreconditionFailed" => {
            crate::error::UpdatePublicKeyError {
                meta: generic,
                kind: crate::error::UpdatePublicKeyErrorKind::PreconditionFailed({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::precondition_failed::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_precondition_failed_xml_err(response.body().as_ref(), output).map_err(crate::error::UpdatePublicKeyError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::UpdatePublicKeyError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_public_key_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::UpdatePublicKeyOutput, crate::error::UpdatePublicKeyError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::update_public_key_output::Builder::default();
        let _ = response;
        output = output.set_e_tag(
            crate::http_serde::deser_header_update_public_key_update_public_key_output_e_tag(
                response.headers(),
            )
            .map_err(|_| {
                crate::error::UpdatePublicKeyError::unhandled(
                    "Failed to parse ETag from header `ETag",
                )
            })?,
        );
        output = output.set_public_key(
            crate::http_serde::deser_payload_update_public_key_update_public_key_output_public_key(
                response.body().as_ref(),
            )?,
        );
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_realtime_log_config_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UpdateRealtimeLogConfigOutput,
    crate::error::UpdateRealtimeLogConfigError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::UpdateRealtimeLogConfigError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::UpdateRealtimeLogConfigError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDenied" => crate::error::UpdateRealtimeLogConfigError {
            meta: generic,
            kind: crate::error::UpdateRealtimeLogConfigErrorKind::AccessDenied({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_access_denied_xml_err(
                        response.body().as_ref(),
                        output,
                    )
                    .map_err(crate::error::UpdateRealtimeLogConfigError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidArgument" => crate::error::UpdateRealtimeLogConfigError {
            meta: generic,
            kind: crate::error::UpdateRealtimeLogConfigErrorKind::InvalidArgument({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_argument::Builder::default();
                    let _ = response;
                    output =
                        crate::xml_deser::deser_structure_crate_error_invalid_argument_xml_err(
                            response.body().as_ref(),
                            output,
                        )
                        .map_err(crate::error::UpdateRealtimeLogConfigError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NoSuchRealtimeLogConfig" => crate::error::UpdateRealtimeLogConfigError {
            meta: generic,
            kind: crate::error::UpdateRealtimeLogConfigErrorKind::NoSuchRealtimeLogConfig({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::no_such_realtime_log_config::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_no_such_realtime_log_config_xml_err(response.body().as_ref(), output).map_err(crate::error::UpdateRealtimeLogConfigError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::UpdateRealtimeLogConfigError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_realtime_log_config_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UpdateRealtimeLogConfigOutput,
    crate::error::UpdateRealtimeLogConfigError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::update_realtime_log_config_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_update_realtime_log_config(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::UpdateRealtimeLogConfigError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_response_headers_policy_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UpdateResponseHeadersPolicyOutput,
    crate::error::UpdateResponseHeadersPolicyError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::UpdateResponseHeadersPolicyError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::UpdateResponseHeadersPolicyError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDenied" => crate::error::UpdateResponseHeadersPolicyError { meta: generic, kind: crate::error::UpdateResponseHeadersPolicyErrorKind::AccessDenied({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::access_denied::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_access_denied_xml_err(response.body().as_ref(), output).map_err(crate::error::UpdateResponseHeadersPolicyError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "IllegalUpdate" => crate::error::UpdateResponseHeadersPolicyError { meta: generic, kind: crate::error::UpdateResponseHeadersPolicyErrorKind::IllegalUpdate({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::illegal_update::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_illegal_update_xml_err(response.body().as_ref(), output).map_err(crate::error::UpdateResponseHeadersPolicyError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InconsistentQuantities" => crate::error::UpdateResponseHeadersPolicyError { meta: generic, kind: crate::error::UpdateResponseHeadersPolicyErrorKind::InconsistentQuantities({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::inconsistent_quantities::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_inconsistent_quantities_xml_err(response.body().as_ref(), output).map_err(crate::error::UpdateResponseHeadersPolicyError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidArgument" => crate::error::UpdateResponseHeadersPolicyError { meta: generic, kind: crate::error::UpdateResponseHeadersPolicyErrorKind::InvalidArgument({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_argument::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_argument_xml_err(response.body().as_ref(), output).map_err(crate::error::UpdateResponseHeadersPolicyError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidIfMatchVersion" => crate::error::UpdateResponseHeadersPolicyError { meta: generic, kind: crate::error::UpdateResponseHeadersPolicyErrorKind::InvalidIfMatchVersion({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_if_match_version::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_if_match_version_xml_err(response.body().as_ref(), output).map_err(crate::error::UpdateResponseHeadersPolicyError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "NoSuchResponseHeadersPolicy" => crate::error::UpdateResponseHeadersPolicyError { meta: generic, kind: crate::error::UpdateResponseHeadersPolicyErrorKind::NoSuchResponseHeadersPolicy({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::no_such_response_headers_policy::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_no_such_response_headers_policy_xml_err(response.body().as_ref(), output).map_err(crate::error::UpdateResponseHeadersPolicyError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "PreconditionFailed" => crate::error::UpdateResponseHeadersPolicyError { meta: generic, kind: crate::error::UpdateResponseHeadersPolicyErrorKind::PreconditionFailed({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::precondition_failed::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_precondition_failed_xml_err(response.body().as_ref(), output).map_err(crate::error::UpdateResponseHeadersPolicyError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "ResponseHeadersPolicyAlreadyExists" => crate::error::UpdateResponseHeadersPolicyError { meta: generic, kind: crate::error::UpdateResponseHeadersPolicyErrorKind::ResponseHeadersPolicyAlreadyExists({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::response_headers_policy_already_exists::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_response_headers_policy_already_exists_xml_err(response.body().as_ref(), output).map_err(crate::error::UpdateResponseHeadersPolicyError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "TooManyCustomHeadersInResponseHeadersPolicy" => crate::error::UpdateResponseHeadersPolicyError { meta: generic, kind: crate::error::UpdateResponseHeadersPolicyErrorKind::TooManyCustomHeadersInResponseHeadersPolicy({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::too_many_custom_headers_in_response_headers_policy::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_too_many_custom_headers_in_response_headers_policy_xml_err(response.body().as_ref(), output).map_err(crate::error::UpdateResponseHeadersPolicyError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::UpdateResponseHeadersPolicyError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_response_headers_policy_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UpdateResponseHeadersPolicyOutput,
    crate::error::UpdateResponseHeadersPolicyError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::update_response_headers_policy_output::Builder::default();
        let _ = response;
        output = output.set_e_tag(
            crate::http_serde::deser_header_update_response_headers_policy_update_response_headers_policy_output_e_tag(response.headers())
                                    .map_err(|_|crate::error::UpdateResponseHeadersPolicyError::unhandled("Failed to parse ETag from header `ETag"))?
        );
        output = output.set_response_headers_policy(
            crate::http_serde::deser_payload_update_response_headers_policy_update_response_headers_policy_output_response_headers_policy(response.body().as_ref())?
        );
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_streaming_distribution_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UpdateStreamingDistributionOutput,
    crate::error::UpdateStreamingDistributionError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::UpdateStreamingDistributionError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::UpdateStreamingDistributionError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDenied" => crate::error::UpdateStreamingDistributionError { meta: generic, kind: crate::error::UpdateStreamingDistributionErrorKind::AccessDenied({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::access_denied::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_access_denied_xml_err(response.body().as_ref(), output).map_err(crate::error::UpdateStreamingDistributionError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "CNAMEAlreadyExists" => crate::error::UpdateStreamingDistributionError { meta: generic, kind: crate::error::UpdateStreamingDistributionErrorKind::CnameAlreadyExists({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::cname_already_exists::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_cname_already_exists_xml_err(response.body().as_ref(), output).map_err(crate::error::UpdateStreamingDistributionError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "IllegalUpdate" => crate::error::UpdateStreamingDistributionError { meta: generic, kind: crate::error::UpdateStreamingDistributionErrorKind::IllegalUpdate({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::illegal_update::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_illegal_update_xml_err(response.body().as_ref(), output).map_err(crate::error::UpdateStreamingDistributionError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InconsistentQuantities" => crate::error::UpdateStreamingDistributionError { meta: generic, kind: crate::error::UpdateStreamingDistributionErrorKind::InconsistentQuantities({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::inconsistent_quantities::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_inconsistent_quantities_xml_err(response.body().as_ref(), output).map_err(crate::error::UpdateStreamingDistributionError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidArgument" => crate::error::UpdateStreamingDistributionError { meta: generic, kind: crate::error::UpdateStreamingDistributionErrorKind::InvalidArgument({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_argument::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_argument_xml_err(response.body().as_ref(), output).map_err(crate::error::UpdateStreamingDistributionError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidIfMatchVersion" => crate::error::UpdateStreamingDistributionError { meta: generic, kind: crate::error::UpdateStreamingDistributionErrorKind::InvalidIfMatchVersion({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_if_match_version::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_if_match_version_xml_err(response.body().as_ref(), output).map_err(crate::error::UpdateStreamingDistributionError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidOriginAccessIdentity" => crate::error::UpdateStreamingDistributionError { meta: generic, kind: crate::error::UpdateStreamingDistributionErrorKind::InvalidOriginAccessIdentity({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_origin_access_identity::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_origin_access_identity_xml_err(response.body().as_ref(), output).map_err(crate::error::UpdateStreamingDistributionError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "MissingBody" => crate::error::UpdateStreamingDistributionError { meta: generic, kind: crate::error::UpdateStreamingDistributionErrorKind::MissingBody({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::missing_body::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_missing_body_xml_err(response.body().as_ref(), output).map_err(crate::error::UpdateStreamingDistributionError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "NoSuchStreamingDistribution" => crate::error::UpdateStreamingDistributionError { meta: generic, kind: crate::error::UpdateStreamingDistributionErrorKind::NoSuchStreamingDistribution({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::no_such_streaming_distribution::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_no_such_streaming_distribution_xml_err(response.body().as_ref(), output).map_err(crate::error::UpdateStreamingDistributionError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "PreconditionFailed" => crate::error::UpdateStreamingDistributionError { meta: generic, kind: crate::error::UpdateStreamingDistributionErrorKind::PreconditionFailed({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::precondition_failed::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_precondition_failed_xml_err(response.body().as_ref(), output).map_err(crate::error::UpdateStreamingDistributionError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "TooManyStreamingDistributionCNAMEs" => crate::error::UpdateStreamingDistributionError { meta: generic, kind: crate::error::UpdateStreamingDistributionErrorKind::TooManyStreamingDistributionCnamEs({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::too_many_streaming_distribution_cnam_es::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_too_many_streaming_distribution_cnam_es_xml_err(response.body().as_ref(), output).map_err(crate::error::UpdateStreamingDistributionError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "TooManyTrustedSigners" => crate::error::UpdateStreamingDistributionError { meta: generic, kind: crate::error::UpdateStreamingDistributionErrorKind::TooManyTrustedSigners({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::too_many_trusted_signers::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_too_many_trusted_signers_xml_err(response.body().as_ref(), output).map_err(crate::error::UpdateStreamingDistributionError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "TrustedSignerDoesNotExist" => crate::error::UpdateStreamingDistributionError { meta: generic, kind: crate::error::UpdateStreamingDistributionErrorKind::TrustedSignerDoesNotExist({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::trusted_signer_does_not_exist::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_trusted_signer_does_not_exist_xml_err(response.body().as_ref(), output).map_err(crate::error::UpdateStreamingDistributionError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::UpdateStreamingDistributionError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_streaming_distribution_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UpdateStreamingDistributionOutput,
    crate::error::UpdateStreamingDistributionError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::update_streaming_distribution_output::Builder::default();
        let _ = response;
        output = output.set_e_tag(
            crate::http_serde::deser_header_update_streaming_distribution_update_streaming_distribution_output_e_tag(response.headers())
                                    .map_err(|_|crate::error::UpdateStreamingDistributionError::unhandled("Failed to parse ETag from header `ETag"))?
        );
        output = output.set_streaming_distribution(
            crate::http_serde::deser_payload_update_streaming_distribution_update_streaming_distribution_output_streaming_distribution(response.body().as_ref())?
        );
        output.build()
    })
}
