// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Error type for the `AssociateAlias` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct AssociateAliasError {
    /// Kind of error that occurred.
    pub kind: AssociateAliasErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `AssociateAlias` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum AssociateAliasErrorKind {
    /// <p>Access denied.</p>
    AccessDenied(crate::error::AccessDenied),
    /// <p>The update contains modifications that are not allowed.</p>
    IllegalUpdate(crate::error::IllegalUpdate),
    /// <p>An argument is invalid.</p>
    InvalidArgument(crate::error::InvalidArgument),
    /// <p>The specified distribution does not exist.</p>
    NoSuchDistribution(crate::error::NoSuchDistribution),
    /// <p>Your request contains more CNAMEs than are allowed per distribution.</p>
    TooManyDistributionCnamEs(crate::error::TooManyDistributionCnamEs),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for AssociateAliasError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            AssociateAliasErrorKind::AccessDenied(_inner) => _inner.fmt(f),
            AssociateAliasErrorKind::IllegalUpdate(_inner) => _inner.fmt(f),
            AssociateAliasErrorKind::InvalidArgument(_inner) => _inner.fmt(f),
            AssociateAliasErrorKind::NoSuchDistribution(_inner) => _inner.fmt(f),
            AssociateAliasErrorKind::TooManyDistributionCnamEs(_inner) => _inner.fmt(f),
            AssociateAliasErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for AssociateAliasError {
    fn code(&self) -> Option<&str> {
        AssociateAliasError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl AssociateAliasError {
    /// Creates a new `AssociateAliasError`.
    pub fn new(kind: AssociateAliasErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `AssociateAliasError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: AssociateAliasErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `AssociateAliasError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: AssociateAliasErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `AssociateAliasErrorKind::AccessDenied`.
    pub fn is_access_denied(&self) -> bool {
        matches!(&self.kind, AssociateAliasErrorKind::AccessDenied(_))
    }
    /// Returns `true` if the error kind is `AssociateAliasErrorKind::IllegalUpdate`.
    pub fn is_illegal_update(&self) -> bool {
        matches!(&self.kind, AssociateAliasErrorKind::IllegalUpdate(_))
    }
    /// Returns `true` if the error kind is `AssociateAliasErrorKind::InvalidArgument`.
    pub fn is_invalid_argument(&self) -> bool {
        matches!(&self.kind, AssociateAliasErrorKind::InvalidArgument(_))
    }
    /// Returns `true` if the error kind is `AssociateAliasErrorKind::NoSuchDistribution`.
    pub fn is_no_such_distribution(&self) -> bool {
        matches!(&self.kind, AssociateAliasErrorKind::NoSuchDistribution(_))
    }
    /// Returns `true` if the error kind is `AssociateAliasErrorKind::TooManyDistributionCnamEs`.
    pub fn is_too_many_distribution_cnam_es(&self) -> bool {
        matches!(
            &self.kind,
            AssociateAliasErrorKind::TooManyDistributionCnamEs(_)
        )
    }
}
impl std::error::Error for AssociateAliasError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            AssociateAliasErrorKind::AccessDenied(_inner) => Some(_inner),
            AssociateAliasErrorKind::IllegalUpdate(_inner) => Some(_inner),
            AssociateAliasErrorKind::InvalidArgument(_inner) => Some(_inner),
            AssociateAliasErrorKind::NoSuchDistribution(_inner) => Some(_inner),
            AssociateAliasErrorKind::TooManyDistributionCnamEs(_inner) => Some(_inner),
            AssociateAliasErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateCachePolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateCachePolicyError {
    /// Kind of error that occurred.
    pub kind: CreateCachePolicyErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateCachePolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateCachePolicyErrorKind {
    /// <p>Access denied.</p>
    AccessDenied(crate::error::AccessDenied),
    /// <p>A cache policy with this name already exists. You must provide a unique name. To modify an existing cache policy, use <code>UpdateCachePolicy</code>.</p>
    CachePolicyAlreadyExists(crate::error::CachePolicyAlreadyExists),
    /// <p>The value of <code>Quantity</code> and the size of <code>Items</code> don't match.</p>
    InconsistentQuantities(crate::error::InconsistentQuantities),
    /// <p>An argument is invalid.</p>
    InvalidArgument(crate::error::InvalidArgument),
    /// <p>You have reached the maximum number of cache policies for this Amazon Web Services account. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html">Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.</p>
    TooManyCachePolicies(crate::error::TooManyCachePolicies),
    /// <p>The number of cookies in the cache policy exceeds the maximum. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html">Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.</p>
    TooManyCookiesInCachePolicy(crate::error::TooManyCookiesInCachePolicy),
    /// <p>The number of headers in the cache policy exceeds the maximum. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html">Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.</p>
    TooManyHeadersInCachePolicy(crate::error::TooManyHeadersInCachePolicy),
    /// <p>The number of query strings in the cache policy exceeds the maximum. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html">Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.</p>
    TooManyQueryStringsInCachePolicy(crate::error::TooManyQueryStringsInCachePolicy),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateCachePolicyError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateCachePolicyErrorKind::AccessDenied(_inner) => _inner.fmt(f),
            CreateCachePolicyErrorKind::CachePolicyAlreadyExists(_inner) => _inner.fmt(f),
            CreateCachePolicyErrorKind::InconsistentQuantities(_inner) => _inner.fmt(f),
            CreateCachePolicyErrorKind::InvalidArgument(_inner) => _inner.fmt(f),
            CreateCachePolicyErrorKind::TooManyCachePolicies(_inner) => _inner.fmt(f),
            CreateCachePolicyErrorKind::TooManyCookiesInCachePolicy(_inner) => _inner.fmt(f),
            CreateCachePolicyErrorKind::TooManyHeadersInCachePolicy(_inner) => _inner.fmt(f),
            CreateCachePolicyErrorKind::TooManyQueryStringsInCachePolicy(_inner) => _inner.fmt(f),
            CreateCachePolicyErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateCachePolicyError {
    fn code(&self) -> Option<&str> {
        CreateCachePolicyError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateCachePolicyError {
    /// Creates a new `CreateCachePolicyError`.
    pub fn new(kind: CreateCachePolicyErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateCachePolicyError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateCachePolicyErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateCachePolicyError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateCachePolicyErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateCachePolicyErrorKind::AccessDenied`.
    pub fn is_access_denied(&self) -> bool {
        matches!(&self.kind, CreateCachePolicyErrorKind::AccessDenied(_))
    }
    /// Returns `true` if the error kind is `CreateCachePolicyErrorKind::CachePolicyAlreadyExists`.
    pub fn is_cache_policy_already_exists(&self) -> bool {
        matches!(
            &self.kind,
            CreateCachePolicyErrorKind::CachePolicyAlreadyExists(_)
        )
    }
    /// Returns `true` if the error kind is `CreateCachePolicyErrorKind::InconsistentQuantities`.
    pub fn is_inconsistent_quantities(&self) -> bool {
        matches!(
            &self.kind,
            CreateCachePolicyErrorKind::InconsistentQuantities(_)
        )
    }
    /// Returns `true` if the error kind is `CreateCachePolicyErrorKind::InvalidArgument`.
    pub fn is_invalid_argument(&self) -> bool {
        matches!(&self.kind, CreateCachePolicyErrorKind::InvalidArgument(_))
    }
    /// Returns `true` if the error kind is `CreateCachePolicyErrorKind::TooManyCachePolicies`.
    pub fn is_too_many_cache_policies(&self) -> bool {
        matches!(
            &self.kind,
            CreateCachePolicyErrorKind::TooManyCachePolicies(_)
        )
    }
    /// Returns `true` if the error kind is `CreateCachePolicyErrorKind::TooManyCookiesInCachePolicy`.
    pub fn is_too_many_cookies_in_cache_policy(&self) -> bool {
        matches!(
            &self.kind,
            CreateCachePolicyErrorKind::TooManyCookiesInCachePolicy(_)
        )
    }
    /// Returns `true` if the error kind is `CreateCachePolicyErrorKind::TooManyHeadersInCachePolicy`.
    pub fn is_too_many_headers_in_cache_policy(&self) -> bool {
        matches!(
            &self.kind,
            CreateCachePolicyErrorKind::TooManyHeadersInCachePolicy(_)
        )
    }
    /// Returns `true` if the error kind is `CreateCachePolicyErrorKind::TooManyQueryStringsInCachePolicy`.
    pub fn is_too_many_query_strings_in_cache_policy(&self) -> bool {
        matches!(
            &self.kind,
            CreateCachePolicyErrorKind::TooManyQueryStringsInCachePolicy(_)
        )
    }
}
impl std::error::Error for CreateCachePolicyError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateCachePolicyErrorKind::AccessDenied(_inner) => Some(_inner),
            CreateCachePolicyErrorKind::CachePolicyAlreadyExists(_inner) => Some(_inner),
            CreateCachePolicyErrorKind::InconsistentQuantities(_inner) => Some(_inner),
            CreateCachePolicyErrorKind::InvalidArgument(_inner) => Some(_inner),
            CreateCachePolicyErrorKind::TooManyCachePolicies(_inner) => Some(_inner),
            CreateCachePolicyErrorKind::TooManyCookiesInCachePolicy(_inner) => Some(_inner),
            CreateCachePolicyErrorKind::TooManyHeadersInCachePolicy(_inner) => Some(_inner),
            CreateCachePolicyErrorKind::TooManyQueryStringsInCachePolicy(_inner) => Some(_inner),
            CreateCachePolicyErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateCloudFrontOriginAccessIdentity` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateCloudFrontOriginAccessIdentityError {
    /// Kind of error that occurred.
    pub kind: CreateCloudFrontOriginAccessIdentityErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateCloudFrontOriginAccessIdentity` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateCloudFrontOriginAccessIdentityErrorKind {
    /// <p>If the <code>CallerReference</code> is a value you already sent in a previous request to create an identity but the content of the <code>CloudFrontOriginAccessIdentityConfig</code> is different from the original request, CloudFront returns a <code>CloudFrontOriginAccessIdentityAlreadyExists</code> error. </p>
    CloudFrontOriginAccessIdentityAlreadyExists(
        crate::error::CloudFrontOriginAccessIdentityAlreadyExists,
    ),
    /// <p>The value of <code>Quantity</code> and the size of <code>Items</code> don't match.</p>
    InconsistentQuantities(crate::error::InconsistentQuantities),
    /// <p>An argument is invalid.</p>
    InvalidArgument(crate::error::InvalidArgument),
    /// <p>This operation requires a body. Ensure that the body is present and the <code>Content-Type</code> header is set.</p>
    MissingBody(crate::error::MissingBody),
    /// <p>Processing your request would cause you to exceed the maximum number of origin access identities allowed.</p>
    TooManyCloudFrontOriginAccessIdentities(crate::error::TooManyCloudFrontOriginAccessIdentities),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateCloudFrontOriginAccessIdentityError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateCloudFrontOriginAccessIdentityErrorKind::CloudFrontOriginAccessIdentityAlreadyExists(_inner) =>
            _inner.fmt(f)
            ,
            CreateCloudFrontOriginAccessIdentityErrorKind::InconsistentQuantities(_inner) =>
            _inner.fmt(f)
            ,
            CreateCloudFrontOriginAccessIdentityErrorKind::InvalidArgument(_inner) =>
            _inner.fmt(f)
            ,
            CreateCloudFrontOriginAccessIdentityErrorKind::MissingBody(_inner) =>
            _inner.fmt(f)
            ,
            CreateCloudFrontOriginAccessIdentityErrorKind::TooManyCloudFrontOriginAccessIdentities(_inner) =>
            _inner.fmt(f)
            ,
            CreateCloudFrontOriginAccessIdentityErrorKind::Unhandled(_inner) => {
                _inner.fmt(f)
            }
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateCloudFrontOriginAccessIdentityError {
    fn code(&self) -> Option<&str> {
        CreateCloudFrontOriginAccessIdentityError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateCloudFrontOriginAccessIdentityError {
    /// Creates a new `CreateCloudFrontOriginAccessIdentityError`.
    pub fn new(
        kind: CreateCloudFrontOriginAccessIdentityErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateCloudFrontOriginAccessIdentityError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateCloudFrontOriginAccessIdentityErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateCloudFrontOriginAccessIdentityError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateCloudFrontOriginAccessIdentityErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateCloudFrontOriginAccessIdentityErrorKind::CloudFrontOriginAccessIdentityAlreadyExists`.
    pub fn is_cloud_front_origin_access_identity_already_exists(&self) -> bool {
        matches!(&self.kind, CreateCloudFrontOriginAccessIdentityErrorKind::CloudFrontOriginAccessIdentityAlreadyExists(_))
    }
    /// Returns `true` if the error kind is `CreateCloudFrontOriginAccessIdentityErrorKind::InconsistentQuantities`.
    pub fn is_inconsistent_quantities(&self) -> bool {
        matches!(
            &self.kind,
            CreateCloudFrontOriginAccessIdentityErrorKind::InconsistentQuantities(_)
        )
    }
    /// Returns `true` if the error kind is `CreateCloudFrontOriginAccessIdentityErrorKind::InvalidArgument`.
    pub fn is_invalid_argument(&self) -> bool {
        matches!(
            &self.kind,
            CreateCloudFrontOriginAccessIdentityErrorKind::InvalidArgument(_)
        )
    }
    /// Returns `true` if the error kind is `CreateCloudFrontOriginAccessIdentityErrorKind::MissingBody`.
    pub fn is_missing_body(&self) -> bool {
        matches!(
            &self.kind,
            CreateCloudFrontOriginAccessIdentityErrorKind::MissingBody(_)
        )
    }
    /// Returns `true` if the error kind is `CreateCloudFrontOriginAccessIdentityErrorKind::TooManyCloudFrontOriginAccessIdentities`.
    pub fn is_too_many_cloud_front_origin_access_identities(&self) -> bool {
        matches!(
            &self.kind,
            CreateCloudFrontOriginAccessIdentityErrorKind::TooManyCloudFrontOriginAccessIdentities(
                _
            )
        )
    }
}
impl std::error::Error for CreateCloudFrontOriginAccessIdentityError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateCloudFrontOriginAccessIdentityErrorKind::CloudFrontOriginAccessIdentityAlreadyExists(_inner) =>
            Some(_inner)
            ,
            CreateCloudFrontOriginAccessIdentityErrorKind::InconsistentQuantities(_inner) =>
            Some(_inner)
            ,
            CreateCloudFrontOriginAccessIdentityErrorKind::InvalidArgument(_inner) =>
            Some(_inner)
            ,
            CreateCloudFrontOriginAccessIdentityErrorKind::MissingBody(_inner) =>
            Some(_inner)
            ,
            CreateCloudFrontOriginAccessIdentityErrorKind::TooManyCloudFrontOriginAccessIdentities(_inner) =>
            Some(_inner)
            ,
            CreateCloudFrontOriginAccessIdentityErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `CreateDistribution` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateDistributionError {
    /// Kind of error that occurred.
    pub kind: CreateDistributionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateDistribution` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateDistributionErrorKind {
    /// <p>Access denied.</p>
    AccessDenied(crate::error::AccessDenied),
    /// <p>The CNAME specified is already defined for CloudFront.</p>
    CnameAlreadyExists(crate::error::CnameAlreadyExists),
    /// <p>The caller reference you attempted to create the distribution with is associated with another distribution.</p>
    DistributionAlreadyExists(crate::error::DistributionAlreadyExists),
    /// <p>The specified configuration for field-level encryption can't be associated with the specified cache behavior.</p>
    IllegalFieldLevelEncryptionConfigAssociationWithCacheBehavior(
        crate::error::IllegalFieldLevelEncryptionConfigAssociationWithCacheBehavior,
    ),
    /// <p>The value of <code>Quantity</code> and the size of <code>Items</code> don't match.</p>
    InconsistentQuantities(crate::error::InconsistentQuantities),
    /// <p>An argument is invalid.</p>
    InvalidArgument(crate::error::InvalidArgument),
    /// <p>The default root object file name is too big or contains an invalid character.</p>
    InvalidDefaultRootObject(crate::error::InvalidDefaultRootObject),
    /// <p>An invalid error code was specified.</p>
    InvalidErrorCode(crate::error::InvalidErrorCode),
    /// <p>Your request contains forward cookies option which doesn't match with the expectation for the <code>whitelisted</code> list of cookie names. Either list of cookie names has been specified when not allowed or list of cookie names is missing when expected.</p>
    InvalidForwardCookies(crate::error::InvalidForwardCookies),
    /// <p>A CloudFront function association is invalid.</p>
    InvalidFunctionAssociation(crate::error::InvalidFunctionAssociation),
    /// <p>The specified geo restriction parameter is not valid.</p>
    InvalidGeoRestrictionParameter(crate::error::InvalidGeoRestrictionParameter),
    /// <p>The headers specified are not valid for an Amazon S3 origin.</p>
    InvalidHeadersForS3Origin(crate::error::InvalidHeadersForS3Origin),
    /// <p>The specified Lambda@Edge function association is invalid.</p>
    InvalidLambdaFunctionAssociation(crate::error::InvalidLambdaFunctionAssociation),
    /// <p>The location code specified is not valid.</p>
    InvalidLocationCode(crate::error::InvalidLocationCode),
    /// <p>The minimum protocol version specified is not valid.</p>
    InvalidMinimumProtocolVersion(crate::error::InvalidMinimumProtocolVersion),
    /// <p>The Amazon S3 origin server specified does not refer to a valid Amazon S3 bucket.</p>
    InvalidOrigin(crate::error::InvalidOrigin),
    /// <p>The origin access identity is not valid or doesn't exist.</p>
    InvalidOriginAccessIdentity(crate::error::InvalidOriginAccessIdentity),
    /// <p>The keep alive timeout specified for the origin is not valid.</p>
    InvalidOriginKeepaliveTimeout(crate::error::InvalidOriginKeepaliveTimeout),
    /// <p>The read timeout specified for the origin is not valid.</p>
    InvalidOriginReadTimeout(crate::error::InvalidOriginReadTimeout),
    /// <p>You cannot specify SSLv3 as the minimum protocol version if you only want to support only clients that support Server Name Indication (SNI).</p>
    InvalidProtocolSettings(crate::error::InvalidProtocolSettings),
    /// <p>The query string parameters specified are not valid.</p>
    InvalidQueryStringParameters(crate::error::InvalidQueryStringParameters),
    /// <p>The relative path is too big, is not URL-encoded, or does not begin with a slash (/).</p>
    InvalidRelativePath(crate::error::InvalidRelativePath),
    /// <p>This operation requires the HTTPS protocol. Ensure that you specify the HTTPS protocol in your request, or omit the <code>RequiredProtocols</code> element from your distribution configuration.</p>
    InvalidRequiredProtocol(crate::error::InvalidRequiredProtocol),
    /// <p>A response code is not valid.</p>
    InvalidResponseCode(crate::error::InvalidResponseCode),
    /// <p>The TTL order specified is not valid.</p>
    InvalidTtlOrder(crate::error::InvalidTtlOrder),
    /// <p>A viewer certificate specified is not valid.</p>
    InvalidViewerCertificate(crate::error::InvalidViewerCertificate),
    /// <p>A web ACL ID specified is not valid. To specify a web ACL created using the latest version of WAF, use the ACL ARN, for example <code>arn:aws:wafv2:us-east-1:123456789012:global/webacl/ExampleWebACL/473e64fd-f30b-4765-81a0-62ad96dd167a</code>. To specify a web ACL created using WAF Classic, use the ACL ID, for example <code>473e64fd-f30b-4765-81a0-62ad96dd167a</code>.</p>
    InvalidWebAclId(crate::error::InvalidWebAclId),
    /// <p>This operation requires a body. Ensure that the body is present and the <code>Content-Type</code> header is set.</p>
    MissingBody(crate::error::MissingBody),
    /// <p>The cache policy does not exist.</p>
    NoSuchCachePolicy(crate::error::NoSuchCachePolicy),
    /// <p>The specified configuration for field-level encryption doesn't exist.</p>
    NoSuchFieldLevelEncryptionConfig(crate::error::NoSuchFieldLevelEncryptionConfig),
    /// <p>No origin exists with the specified <code>Origin Id</code>. </p>
    NoSuchOrigin(crate::error::NoSuchOrigin),
    /// <p>The origin request policy does not exist.</p>
    NoSuchOriginRequestPolicy(crate::error::NoSuchOriginRequestPolicy),
    /// <p>The real-time log configuration does not exist.</p>
    NoSuchRealtimeLogConfig(crate::error::NoSuchRealtimeLogConfig),
    /// <p>The response headers policy does not exist.</p>
    NoSuchResponseHeadersPolicy(crate::error::NoSuchResponseHeadersPolicy),
    /// <p>The specified real-time log configuration belongs to a different Amazon Web Services account.</p>
    RealtimeLogConfigOwnerMismatch(crate::error::RealtimeLogConfigOwnerMismatch),
    /// <p>You cannot create more cache behaviors for the distribution.</p>
    TooManyCacheBehaviors(crate::error::TooManyCacheBehaviors),
    /// <p>You cannot create anymore custom SSL/TLS certificates.</p>
    TooManyCertificates(crate::error::TooManyCertificates),
    /// <p>Your request contains more cookie names in the whitelist than are allowed per cache behavior.</p>
    TooManyCookieNamesInWhiteList(crate::error::TooManyCookieNamesInWhiteList),
    /// <p>Your request contains more CNAMEs than are allowed per distribution.</p>
    TooManyDistributionCnamEs(crate::error::TooManyDistributionCnamEs),
    /// <p>Processing your request would cause you to exceed the maximum number of distributions allowed.</p>
    TooManyDistributions(crate::error::TooManyDistributions),
    /// <p>The maximum number of distributions have been associated with the specified cache policy. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html">Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.</p>
    TooManyDistributionsAssociatedToCachePolicy(
        crate::error::TooManyDistributionsAssociatedToCachePolicy,
    ),
    /// <p>The maximum number of distributions have been associated with the specified configuration for field-level encryption.</p>
    TooManyDistributionsAssociatedToFieldLevelEncryptionConfig(
        crate::error::TooManyDistributionsAssociatedToFieldLevelEncryptionConfig,
    ),
    /// <p>The number of distributions that reference this key group is more than the maximum allowed. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html">Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.</p>
    TooManyDistributionsAssociatedToKeyGroup(
        crate::error::TooManyDistributionsAssociatedToKeyGroup,
    ),
    /// <p>The maximum number of distributions have been associated with the specified origin request policy. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html">Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.</p>
    TooManyDistributionsAssociatedToOriginRequestPolicy(
        crate::error::TooManyDistributionsAssociatedToOriginRequestPolicy,
    ),
    /// <p>The maximum number of distributions have been associated with the specified response headers policy.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html">Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.</p>
    TooManyDistributionsAssociatedToResponseHeadersPolicy(
        crate::error::TooManyDistributionsAssociatedToResponseHeadersPolicy,
    ),
    /// <p>You have reached the maximum number of distributions that are associated with a CloudFront function. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html">Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.</p>
    TooManyDistributionsWithFunctionAssociations(
        crate::error::TooManyDistributionsWithFunctionAssociations,
    ),
    /// <p>Processing your request would cause the maximum number of distributions with Lambda@Edge function associations per owner to be exceeded.</p>
    TooManyDistributionsWithLambdaAssociations(
        crate::error::TooManyDistributionsWithLambdaAssociations,
    ),
    /// <p>The maximum number of distributions have been associated with the specified Lambda@Edge function.</p>
    TooManyDistributionsWithSingleFunctionArn(
        crate::error::TooManyDistributionsWithSingleFunctionArn,
    ),
    /// <p>You have reached the maximum number of CloudFront function associations for this distribution. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html">Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.</p>
    TooManyFunctionAssociations(crate::error::TooManyFunctionAssociations),
    /// <p>Your request contains too many headers in forwarded values.</p>
    TooManyHeadersInForwardedValues(crate::error::TooManyHeadersInForwardedValues),
    /// <p>The number of key groups referenced by this distribution is more than the maximum allowed. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html">Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.</p>
    TooManyKeyGroupsAssociatedToDistribution(
        crate::error::TooManyKeyGroupsAssociatedToDistribution,
    ),
    /// <p>Your request contains more Lambda@Edge function associations than are allowed per distribution.</p>
    TooManyLambdaFunctionAssociations(crate::error::TooManyLambdaFunctionAssociations),
    /// <p>Your request contains too many origin custom headers.</p>
    TooManyOriginCustomHeaders(crate::error::TooManyOriginCustomHeaders),
    /// <p>Processing your request would cause you to exceed the maximum number of origin groups allowed.</p>
    TooManyOriginGroupsPerDistribution(crate::error::TooManyOriginGroupsPerDistribution),
    /// <p>You cannot create more origins for the distribution.</p>
    TooManyOrigins(crate::error::TooManyOrigins),
    /// <p>Your request contains too many query string parameters.</p>
    TooManyQueryStringParameters(crate::error::TooManyQueryStringParameters),
    /// <p>Your request contains more trusted signers than are allowed per distribution.</p>
    TooManyTrustedSigners(crate::error::TooManyTrustedSigners),
    /// <p>The specified key group does not exist.</p>
    TrustedKeyGroupDoesNotExist(crate::error::TrustedKeyGroupDoesNotExist),
    /// <p>One or more of your trusted signers don't exist.</p>
    TrustedSignerDoesNotExist(crate::error::TrustedSignerDoesNotExist),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateDistributionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateDistributionErrorKind::AccessDenied(_inner) =>
            _inner.fmt(f)
            ,
            CreateDistributionErrorKind::CnameAlreadyExists(_inner) =>
            _inner.fmt(f)
            ,
            CreateDistributionErrorKind::DistributionAlreadyExists(_inner) =>
            _inner.fmt(f)
            ,
            CreateDistributionErrorKind::IllegalFieldLevelEncryptionConfigAssociationWithCacheBehavior(_inner) =>
            _inner.fmt(f)
            ,
            CreateDistributionErrorKind::InconsistentQuantities(_inner) =>
            _inner.fmt(f)
            ,
            CreateDistributionErrorKind::InvalidArgument(_inner) =>
            _inner.fmt(f)
            ,
            CreateDistributionErrorKind::InvalidDefaultRootObject(_inner) =>
            _inner.fmt(f)
            ,
            CreateDistributionErrorKind::InvalidErrorCode(_inner) =>
            _inner.fmt(f)
            ,
            CreateDistributionErrorKind::InvalidForwardCookies(_inner) =>
            _inner.fmt(f)
            ,
            CreateDistributionErrorKind::InvalidFunctionAssociation(_inner) =>
            _inner.fmt(f)
            ,
            CreateDistributionErrorKind::InvalidGeoRestrictionParameter(_inner) =>
            _inner.fmt(f)
            ,
            CreateDistributionErrorKind::InvalidHeadersForS3Origin(_inner) =>
            _inner.fmt(f)
            ,
            CreateDistributionErrorKind::InvalidLambdaFunctionAssociation(_inner) =>
            _inner.fmt(f)
            ,
            CreateDistributionErrorKind::InvalidLocationCode(_inner) =>
            _inner.fmt(f)
            ,
            CreateDistributionErrorKind::InvalidMinimumProtocolVersion(_inner) =>
            _inner.fmt(f)
            ,
            CreateDistributionErrorKind::InvalidOrigin(_inner) =>
            _inner.fmt(f)
            ,
            CreateDistributionErrorKind::InvalidOriginAccessIdentity(_inner) =>
            _inner.fmt(f)
            ,
            CreateDistributionErrorKind::InvalidOriginKeepaliveTimeout(_inner) =>
            _inner.fmt(f)
            ,
            CreateDistributionErrorKind::InvalidOriginReadTimeout(_inner) =>
            _inner.fmt(f)
            ,
            CreateDistributionErrorKind::InvalidProtocolSettings(_inner) =>
            _inner.fmt(f)
            ,
            CreateDistributionErrorKind::InvalidQueryStringParameters(_inner) =>
            _inner.fmt(f)
            ,
            CreateDistributionErrorKind::InvalidRelativePath(_inner) =>
            _inner.fmt(f)
            ,
            CreateDistributionErrorKind::InvalidRequiredProtocol(_inner) =>
            _inner.fmt(f)
            ,
            CreateDistributionErrorKind::InvalidResponseCode(_inner) =>
            _inner.fmt(f)
            ,
            CreateDistributionErrorKind::InvalidTtlOrder(_inner) =>
            _inner.fmt(f)
            ,
            CreateDistributionErrorKind::InvalidViewerCertificate(_inner) =>
            _inner.fmt(f)
            ,
            CreateDistributionErrorKind::InvalidWebAclId(_inner) =>
            _inner.fmt(f)
            ,
            CreateDistributionErrorKind::MissingBody(_inner) =>
            _inner.fmt(f)
            ,
            CreateDistributionErrorKind::NoSuchCachePolicy(_inner) =>
            _inner.fmt(f)
            ,
            CreateDistributionErrorKind::NoSuchFieldLevelEncryptionConfig(_inner) =>
            _inner.fmt(f)
            ,
            CreateDistributionErrorKind::NoSuchOrigin(_inner) =>
            _inner.fmt(f)
            ,
            CreateDistributionErrorKind::NoSuchOriginRequestPolicy(_inner) =>
            _inner.fmt(f)
            ,
            CreateDistributionErrorKind::NoSuchRealtimeLogConfig(_inner) =>
            _inner.fmt(f)
            ,
            CreateDistributionErrorKind::NoSuchResponseHeadersPolicy(_inner) =>
            _inner.fmt(f)
            ,
            CreateDistributionErrorKind::RealtimeLogConfigOwnerMismatch(_inner) =>
            _inner.fmt(f)
            ,
            CreateDistributionErrorKind::TooManyCacheBehaviors(_inner) =>
            _inner.fmt(f)
            ,
            CreateDistributionErrorKind::TooManyCertificates(_inner) =>
            _inner.fmt(f)
            ,
            CreateDistributionErrorKind::TooManyCookieNamesInWhiteList(_inner) =>
            _inner.fmt(f)
            ,
            CreateDistributionErrorKind::TooManyDistributionCnamEs(_inner) =>
            _inner.fmt(f)
            ,
            CreateDistributionErrorKind::TooManyDistributions(_inner) =>
            _inner.fmt(f)
            ,
            CreateDistributionErrorKind::TooManyDistributionsAssociatedToCachePolicy(_inner) =>
            _inner.fmt(f)
            ,
            CreateDistributionErrorKind::TooManyDistributionsAssociatedToFieldLevelEncryptionConfig(_inner) =>
            _inner.fmt(f)
            ,
            CreateDistributionErrorKind::TooManyDistributionsAssociatedToKeyGroup(_inner) =>
            _inner.fmt(f)
            ,
            CreateDistributionErrorKind::TooManyDistributionsAssociatedToOriginRequestPolicy(_inner) =>
            _inner.fmt(f)
            ,
            CreateDistributionErrorKind::TooManyDistributionsAssociatedToResponseHeadersPolicy(_inner) =>
            _inner.fmt(f)
            ,
            CreateDistributionErrorKind::TooManyDistributionsWithFunctionAssociations(_inner) =>
            _inner.fmt(f)
            ,
            CreateDistributionErrorKind::TooManyDistributionsWithLambdaAssociations(_inner) =>
            _inner.fmt(f)
            ,
            CreateDistributionErrorKind::TooManyDistributionsWithSingleFunctionArn(_inner) =>
            _inner.fmt(f)
            ,
            CreateDistributionErrorKind::TooManyFunctionAssociations(_inner) =>
            _inner.fmt(f)
            ,
            CreateDistributionErrorKind::TooManyHeadersInForwardedValues(_inner) =>
            _inner.fmt(f)
            ,
            CreateDistributionErrorKind::TooManyKeyGroupsAssociatedToDistribution(_inner) =>
            _inner.fmt(f)
            ,
            CreateDistributionErrorKind::TooManyLambdaFunctionAssociations(_inner) =>
            _inner.fmt(f)
            ,
            CreateDistributionErrorKind::TooManyOriginCustomHeaders(_inner) =>
            _inner.fmt(f)
            ,
            CreateDistributionErrorKind::TooManyOriginGroupsPerDistribution(_inner) =>
            _inner.fmt(f)
            ,
            CreateDistributionErrorKind::TooManyOrigins(_inner) =>
            _inner.fmt(f)
            ,
            CreateDistributionErrorKind::TooManyQueryStringParameters(_inner) =>
            _inner.fmt(f)
            ,
            CreateDistributionErrorKind::TooManyTrustedSigners(_inner) =>
            _inner.fmt(f)
            ,
            CreateDistributionErrorKind::TrustedKeyGroupDoesNotExist(_inner) =>
            _inner.fmt(f)
            ,
            CreateDistributionErrorKind::TrustedSignerDoesNotExist(_inner) =>
            _inner.fmt(f)
            ,
            CreateDistributionErrorKind::Unhandled(_inner) => {
                _inner.fmt(f)
            }
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateDistributionError {
    fn code(&self) -> Option<&str> {
        CreateDistributionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateDistributionError {
    /// Creates a new `CreateDistributionError`.
    pub fn new(kind: CreateDistributionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateDistributionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateDistributionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateDistributionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateDistributionErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateDistributionErrorKind::AccessDenied`.
    pub fn is_access_denied(&self) -> bool {
        matches!(&self.kind, CreateDistributionErrorKind::AccessDenied(_))
    }
    /// Returns `true` if the error kind is `CreateDistributionErrorKind::CnameAlreadyExists`.
    pub fn is_cname_already_exists(&self) -> bool {
        matches!(
            &self.kind,
            CreateDistributionErrorKind::CnameAlreadyExists(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDistributionErrorKind::DistributionAlreadyExists`.
    pub fn is_distribution_already_exists(&self) -> bool {
        matches!(
            &self.kind,
            CreateDistributionErrorKind::DistributionAlreadyExists(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDistributionErrorKind::IllegalFieldLevelEncryptionConfigAssociationWithCacheBehavior`.
    pub fn is_illegal_field_level_encryption_config_association_with_cache_behavior(&self) -> bool {
        matches!(&self.kind, CreateDistributionErrorKind::IllegalFieldLevelEncryptionConfigAssociationWithCacheBehavior(_))
    }
    /// Returns `true` if the error kind is `CreateDistributionErrorKind::InconsistentQuantities`.
    pub fn is_inconsistent_quantities(&self) -> bool {
        matches!(
            &self.kind,
            CreateDistributionErrorKind::InconsistentQuantities(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDistributionErrorKind::InvalidArgument`.
    pub fn is_invalid_argument(&self) -> bool {
        matches!(&self.kind, CreateDistributionErrorKind::InvalidArgument(_))
    }
    /// Returns `true` if the error kind is `CreateDistributionErrorKind::InvalidDefaultRootObject`.
    pub fn is_invalid_default_root_object(&self) -> bool {
        matches!(
            &self.kind,
            CreateDistributionErrorKind::InvalidDefaultRootObject(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDistributionErrorKind::InvalidErrorCode`.
    pub fn is_invalid_error_code(&self) -> bool {
        matches!(&self.kind, CreateDistributionErrorKind::InvalidErrorCode(_))
    }
    /// Returns `true` if the error kind is `CreateDistributionErrorKind::InvalidForwardCookies`.
    pub fn is_invalid_forward_cookies(&self) -> bool {
        matches!(
            &self.kind,
            CreateDistributionErrorKind::InvalidForwardCookies(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDistributionErrorKind::InvalidFunctionAssociation`.
    pub fn is_invalid_function_association(&self) -> bool {
        matches!(
            &self.kind,
            CreateDistributionErrorKind::InvalidFunctionAssociation(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDistributionErrorKind::InvalidGeoRestrictionParameter`.
    pub fn is_invalid_geo_restriction_parameter(&self) -> bool {
        matches!(
            &self.kind,
            CreateDistributionErrorKind::InvalidGeoRestrictionParameter(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDistributionErrorKind::InvalidHeadersForS3Origin`.
    pub fn is_invalid_headers_for_s3_origin(&self) -> bool {
        matches!(
            &self.kind,
            CreateDistributionErrorKind::InvalidHeadersForS3Origin(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDistributionErrorKind::InvalidLambdaFunctionAssociation`.
    pub fn is_invalid_lambda_function_association(&self) -> bool {
        matches!(
            &self.kind,
            CreateDistributionErrorKind::InvalidLambdaFunctionAssociation(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDistributionErrorKind::InvalidLocationCode`.
    pub fn is_invalid_location_code(&self) -> bool {
        matches!(
            &self.kind,
            CreateDistributionErrorKind::InvalidLocationCode(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDistributionErrorKind::InvalidMinimumProtocolVersion`.
    pub fn is_invalid_minimum_protocol_version(&self) -> bool {
        matches!(
            &self.kind,
            CreateDistributionErrorKind::InvalidMinimumProtocolVersion(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDistributionErrorKind::InvalidOrigin`.
    pub fn is_invalid_origin(&self) -> bool {
        matches!(&self.kind, CreateDistributionErrorKind::InvalidOrigin(_))
    }
    /// Returns `true` if the error kind is `CreateDistributionErrorKind::InvalidOriginAccessIdentity`.
    pub fn is_invalid_origin_access_identity(&self) -> bool {
        matches!(
            &self.kind,
            CreateDistributionErrorKind::InvalidOriginAccessIdentity(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDistributionErrorKind::InvalidOriginKeepaliveTimeout`.
    pub fn is_invalid_origin_keepalive_timeout(&self) -> bool {
        matches!(
            &self.kind,
            CreateDistributionErrorKind::InvalidOriginKeepaliveTimeout(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDistributionErrorKind::InvalidOriginReadTimeout`.
    pub fn is_invalid_origin_read_timeout(&self) -> bool {
        matches!(
            &self.kind,
            CreateDistributionErrorKind::InvalidOriginReadTimeout(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDistributionErrorKind::InvalidProtocolSettings`.
    pub fn is_invalid_protocol_settings(&self) -> bool {
        matches!(
            &self.kind,
            CreateDistributionErrorKind::InvalidProtocolSettings(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDistributionErrorKind::InvalidQueryStringParameters`.
    pub fn is_invalid_query_string_parameters(&self) -> bool {
        matches!(
            &self.kind,
            CreateDistributionErrorKind::InvalidQueryStringParameters(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDistributionErrorKind::InvalidRelativePath`.
    pub fn is_invalid_relative_path(&self) -> bool {
        matches!(
            &self.kind,
            CreateDistributionErrorKind::InvalidRelativePath(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDistributionErrorKind::InvalidRequiredProtocol`.
    pub fn is_invalid_required_protocol(&self) -> bool {
        matches!(
            &self.kind,
            CreateDistributionErrorKind::InvalidRequiredProtocol(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDistributionErrorKind::InvalidResponseCode`.
    pub fn is_invalid_response_code(&self) -> bool {
        matches!(
            &self.kind,
            CreateDistributionErrorKind::InvalidResponseCode(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDistributionErrorKind::InvalidTtlOrder`.
    pub fn is_invalid_ttl_order(&self) -> bool {
        matches!(&self.kind, CreateDistributionErrorKind::InvalidTtlOrder(_))
    }
    /// Returns `true` if the error kind is `CreateDistributionErrorKind::InvalidViewerCertificate`.
    pub fn is_invalid_viewer_certificate(&self) -> bool {
        matches!(
            &self.kind,
            CreateDistributionErrorKind::InvalidViewerCertificate(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDistributionErrorKind::InvalidWebAclId`.
    pub fn is_invalid_web_acl_id(&self) -> bool {
        matches!(&self.kind, CreateDistributionErrorKind::InvalidWebAclId(_))
    }
    /// Returns `true` if the error kind is `CreateDistributionErrorKind::MissingBody`.
    pub fn is_missing_body(&self) -> bool {
        matches!(&self.kind, CreateDistributionErrorKind::MissingBody(_))
    }
    /// Returns `true` if the error kind is `CreateDistributionErrorKind::NoSuchCachePolicy`.
    pub fn is_no_such_cache_policy(&self) -> bool {
        matches!(
            &self.kind,
            CreateDistributionErrorKind::NoSuchCachePolicy(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDistributionErrorKind::NoSuchFieldLevelEncryptionConfig`.
    pub fn is_no_such_field_level_encryption_config(&self) -> bool {
        matches!(
            &self.kind,
            CreateDistributionErrorKind::NoSuchFieldLevelEncryptionConfig(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDistributionErrorKind::NoSuchOrigin`.
    pub fn is_no_such_origin(&self) -> bool {
        matches!(&self.kind, CreateDistributionErrorKind::NoSuchOrigin(_))
    }
    /// Returns `true` if the error kind is `CreateDistributionErrorKind::NoSuchOriginRequestPolicy`.
    pub fn is_no_such_origin_request_policy(&self) -> bool {
        matches!(
            &self.kind,
            CreateDistributionErrorKind::NoSuchOriginRequestPolicy(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDistributionErrorKind::NoSuchRealtimeLogConfig`.
    pub fn is_no_such_realtime_log_config(&self) -> bool {
        matches!(
            &self.kind,
            CreateDistributionErrorKind::NoSuchRealtimeLogConfig(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDistributionErrorKind::NoSuchResponseHeadersPolicy`.
    pub fn is_no_such_response_headers_policy(&self) -> bool {
        matches!(
            &self.kind,
            CreateDistributionErrorKind::NoSuchResponseHeadersPolicy(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDistributionErrorKind::RealtimeLogConfigOwnerMismatch`.
    pub fn is_realtime_log_config_owner_mismatch(&self) -> bool {
        matches!(
            &self.kind,
            CreateDistributionErrorKind::RealtimeLogConfigOwnerMismatch(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDistributionErrorKind::TooManyCacheBehaviors`.
    pub fn is_too_many_cache_behaviors(&self) -> bool {
        matches!(
            &self.kind,
            CreateDistributionErrorKind::TooManyCacheBehaviors(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDistributionErrorKind::TooManyCertificates`.
    pub fn is_too_many_certificates(&self) -> bool {
        matches!(
            &self.kind,
            CreateDistributionErrorKind::TooManyCertificates(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDistributionErrorKind::TooManyCookieNamesInWhiteList`.
    pub fn is_too_many_cookie_names_in_white_list(&self) -> bool {
        matches!(
            &self.kind,
            CreateDistributionErrorKind::TooManyCookieNamesInWhiteList(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDistributionErrorKind::TooManyDistributionCnamEs`.
    pub fn is_too_many_distribution_cnam_es(&self) -> bool {
        matches!(
            &self.kind,
            CreateDistributionErrorKind::TooManyDistributionCnamEs(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDistributionErrorKind::TooManyDistributions`.
    pub fn is_too_many_distributions(&self) -> bool {
        matches!(
            &self.kind,
            CreateDistributionErrorKind::TooManyDistributions(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDistributionErrorKind::TooManyDistributionsAssociatedToCachePolicy`.
    pub fn is_too_many_distributions_associated_to_cache_policy(&self) -> bool {
        matches!(
            &self.kind,
            CreateDistributionErrorKind::TooManyDistributionsAssociatedToCachePolicy(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDistributionErrorKind::TooManyDistributionsAssociatedToFieldLevelEncryptionConfig`.
    pub fn is_too_many_distributions_associated_to_field_level_encryption_config(&self) -> bool {
        matches!(
            &self.kind,
            CreateDistributionErrorKind::TooManyDistributionsAssociatedToFieldLevelEncryptionConfig(
                _
            )
        )
    }
    /// Returns `true` if the error kind is `CreateDistributionErrorKind::TooManyDistributionsAssociatedToKeyGroup`.
    pub fn is_too_many_distributions_associated_to_key_group(&self) -> bool {
        matches!(
            &self.kind,
            CreateDistributionErrorKind::TooManyDistributionsAssociatedToKeyGroup(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDistributionErrorKind::TooManyDistributionsAssociatedToOriginRequestPolicy`.
    pub fn is_too_many_distributions_associated_to_origin_request_policy(&self) -> bool {
        matches!(
            &self.kind,
            CreateDistributionErrorKind::TooManyDistributionsAssociatedToOriginRequestPolicy(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDistributionErrorKind::TooManyDistributionsAssociatedToResponseHeadersPolicy`.
    pub fn is_too_many_distributions_associated_to_response_headers_policy(&self) -> bool {
        matches!(
            &self.kind,
            CreateDistributionErrorKind::TooManyDistributionsAssociatedToResponseHeadersPolicy(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDistributionErrorKind::TooManyDistributionsWithFunctionAssociations`.
    pub fn is_too_many_distributions_with_function_associations(&self) -> bool {
        matches!(
            &self.kind,
            CreateDistributionErrorKind::TooManyDistributionsWithFunctionAssociations(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDistributionErrorKind::TooManyDistributionsWithLambdaAssociations`.
    pub fn is_too_many_distributions_with_lambda_associations(&self) -> bool {
        matches!(
            &self.kind,
            CreateDistributionErrorKind::TooManyDistributionsWithLambdaAssociations(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDistributionErrorKind::TooManyDistributionsWithSingleFunctionArn`.
    pub fn is_too_many_distributions_with_single_function_arn(&self) -> bool {
        matches!(
            &self.kind,
            CreateDistributionErrorKind::TooManyDistributionsWithSingleFunctionArn(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDistributionErrorKind::TooManyFunctionAssociations`.
    pub fn is_too_many_function_associations(&self) -> bool {
        matches!(
            &self.kind,
            CreateDistributionErrorKind::TooManyFunctionAssociations(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDistributionErrorKind::TooManyHeadersInForwardedValues`.
    pub fn is_too_many_headers_in_forwarded_values(&self) -> bool {
        matches!(
            &self.kind,
            CreateDistributionErrorKind::TooManyHeadersInForwardedValues(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDistributionErrorKind::TooManyKeyGroupsAssociatedToDistribution`.
    pub fn is_too_many_key_groups_associated_to_distribution(&self) -> bool {
        matches!(
            &self.kind,
            CreateDistributionErrorKind::TooManyKeyGroupsAssociatedToDistribution(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDistributionErrorKind::TooManyLambdaFunctionAssociations`.
    pub fn is_too_many_lambda_function_associations(&self) -> bool {
        matches!(
            &self.kind,
            CreateDistributionErrorKind::TooManyLambdaFunctionAssociations(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDistributionErrorKind::TooManyOriginCustomHeaders`.
    pub fn is_too_many_origin_custom_headers(&self) -> bool {
        matches!(
            &self.kind,
            CreateDistributionErrorKind::TooManyOriginCustomHeaders(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDistributionErrorKind::TooManyOriginGroupsPerDistribution`.
    pub fn is_too_many_origin_groups_per_distribution(&self) -> bool {
        matches!(
            &self.kind,
            CreateDistributionErrorKind::TooManyOriginGroupsPerDistribution(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDistributionErrorKind::TooManyOrigins`.
    pub fn is_too_many_origins(&self) -> bool {
        matches!(&self.kind, CreateDistributionErrorKind::TooManyOrigins(_))
    }
    /// Returns `true` if the error kind is `CreateDistributionErrorKind::TooManyQueryStringParameters`.
    pub fn is_too_many_query_string_parameters(&self) -> bool {
        matches!(
            &self.kind,
            CreateDistributionErrorKind::TooManyQueryStringParameters(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDistributionErrorKind::TooManyTrustedSigners`.
    pub fn is_too_many_trusted_signers(&self) -> bool {
        matches!(
            &self.kind,
            CreateDistributionErrorKind::TooManyTrustedSigners(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDistributionErrorKind::TrustedKeyGroupDoesNotExist`.
    pub fn is_trusted_key_group_does_not_exist(&self) -> bool {
        matches!(
            &self.kind,
            CreateDistributionErrorKind::TrustedKeyGroupDoesNotExist(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDistributionErrorKind::TrustedSignerDoesNotExist`.
    pub fn is_trusted_signer_does_not_exist(&self) -> bool {
        matches!(
            &self.kind,
            CreateDistributionErrorKind::TrustedSignerDoesNotExist(_)
        )
    }
}
impl std::error::Error for CreateDistributionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateDistributionErrorKind::AccessDenied(_inner) =>
            Some(_inner)
            ,
            CreateDistributionErrorKind::CnameAlreadyExists(_inner) =>
            Some(_inner)
            ,
            CreateDistributionErrorKind::DistributionAlreadyExists(_inner) =>
            Some(_inner)
            ,
            CreateDistributionErrorKind::IllegalFieldLevelEncryptionConfigAssociationWithCacheBehavior(_inner) =>
            Some(_inner)
            ,
            CreateDistributionErrorKind::InconsistentQuantities(_inner) =>
            Some(_inner)
            ,
            CreateDistributionErrorKind::InvalidArgument(_inner) =>
            Some(_inner)
            ,
            CreateDistributionErrorKind::InvalidDefaultRootObject(_inner) =>
            Some(_inner)
            ,
            CreateDistributionErrorKind::InvalidErrorCode(_inner) =>
            Some(_inner)
            ,
            CreateDistributionErrorKind::InvalidForwardCookies(_inner) =>
            Some(_inner)
            ,
            CreateDistributionErrorKind::InvalidFunctionAssociation(_inner) =>
            Some(_inner)
            ,
            CreateDistributionErrorKind::InvalidGeoRestrictionParameter(_inner) =>
            Some(_inner)
            ,
            CreateDistributionErrorKind::InvalidHeadersForS3Origin(_inner) =>
            Some(_inner)
            ,
            CreateDistributionErrorKind::InvalidLambdaFunctionAssociation(_inner) =>
            Some(_inner)
            ,
            CreateDistributionErrorKind::InvalidLocationCode(_inner) =>
            Some(_inner)
            ,
            CreateDistributionErrorKind::InvalidMinimumProtocolVersion(_inner) =>
            Some(_inner)
            ,
            CreateDistributionErrorKind::InvalidOrigin(_inner) =>
            Some(_inner)
            ,
            CreateDistributionErrorKind::InvalidOriginAccessIdentity(_inner) =>
            Some(_inner)
            ,
            CreateDistributionErrorKind::InvalidOriginKeepaliveTimeout(_inner) =>
            Some(_inner)
            ,
            CreateDistributionErrorKind::InvalidOriginReadTimeout(_inner) =>
            Some(_inner)
            ,
            CreateDistributionErrorKind::InvalidProtocolSettings(_inner) =>
            Some(_inner)
            ,
            CreateDistributionErrorKind::InvalidQueryStringParameters(_inner) =>
            Some(_inner)
            ,
            CreateDistributionErrorKind::InvalidRelativePath(_inner) =>
            Some(_inner)
            ,
            CreateDistributionErrorKind::InvalidRequiredProtocol(_inner) =>
            Some(_inner)
            ,
            CreateDistributionErrorKind::InvalidResponseCode(_inner) =>
            Some(_inner)
            ,
            CreateDistributionErrorKind::InvalidTtlOrder(_inner) =>
            Some(_inner)
            ,
            CreateDistributionErrorKind::InvalidViewerCertificate(_inner) =>
            Some(_inner)
            ,
            CreateDistributionErrorKind::InvalidWebAclId(_inner) =>
            Some(_inner)
            ,
            CreateDistributionErrorKind::MissingBody(_inner) =>
            Some(_inner)
            ,
            CreateDistributionErrorKind::NoSuchCachePolicy(_inner) =>
            Some(_inner)
            ,
            CreateDistributionErrorKind::NoSuchFieldLevelEncryptionConfig(_inner) =>
            Some(_inner)
            ,
            CreateDistributionErrorKind::NoSuchOrigin(_inner) =>
            Some(_inner)
            ,
            CreateDistributionErrorKind::NoSuchOriginRequestPolicy(_inner) =>
            Some(_inner)
            ,
            CreateDistributionErrorKind::NoSuchRealtimeLogConfig(_inner) =>
            Some(_inner)
            ,
            CreateDistributionErrorKind::NoSuchResponseHeadersPolicy(_inner) =>
            Some(_inner)
            ,
            CreateDistributionErrorKind::RealtimeLogConfigOwnerMismatch(_inner) =>
            Some(_inner)
            ,
            CreateDistributionErrorKind::TooManyCacheBehaviors(_inner) =>
            Some(_inner)
            ,
            CreateDistributionErrorKind::TooManyCertificates(_inner) =>
            Some(_inner)
            ,
            CreateDistributionErrorKind::TooManyCookieNamesInWhiteList(_inner) =>
            Some(_inner)
            ,
            CreateDistributionErrorKind::TooManyDistributionCnamEs(_inner) =>
            Some(_inner)
            ,
            CreateDistributionErrorKind::TooManyDistributions(_inner) =>
            Some(_inner)
            ,
            CreateDistributionErrorKind::TooManyDistributionsAssociatedToCachePolicy(_inner) =>
            Some(_inner)
            ,
            CreateDistributionErrorKind::TooManyDistributionsAssociatedToFieldLevelEncryptionConfig(_inner) =>
            Some(_inner)
            ,
            CreateDistributionErrorKind::TooManyDistributionsAssociatedToKeyGroup(_inner) =>
            Some(_inner)
            ,
            CreateDistributionErrorKind::TooManyDistributionsAssociatedToOriginRequestPolicy(_inner) =>
            Some(_inner)
            ,
            CreateDistributionErrorKind::TooManyDistributionsAssociatedToResponseHeadersPolicy(_inner) =>
            Some(_inner)
            ,
            CreateDistributionErrorKind::TooManyDistributionsWithFunctionAssociations(_inner) =>
            Some(_inner)
            ,
            CreateDistributionErrorKind::TooManyDistributionsWithLambdaAssociations(_inner) =>
            Some(_inner)
            ,
            CreateDistributionErrorKind::TooManyDistributionsWithSingleFunctionArn(_inner) =>
            Some(_inner)
            ,
            CreateDistributionErrorKind::TooManyFunctionAssociations(_inner) =>
            Some(_inner)
            ,
            CreateDistributionErrorKind::TooManyHeadersInForwardedValues(_inner) =>
            Some(_inner)
            ,
            CreateDistributionErrorKind::TooManyKeyGroupsAssociatedToDistribution(_inner) =>
            Some(_inner)
            ,
            CreateDistributionErrorKind::TooManyLambdaFunctionAssociations(_inner) =>
            Some(_inner)
            ,
            CreateDistributionErrorKind::TooManyOriginCustomHeaders(_inner) =>
            Some(_inner)
            ,
            CreateDistributionErrorKind::TooManyOriginGroupsPerDistribution(_inner) =>
            Some(_inner)
            ,
            CreateDistributionErrorKind::TooManyOrigins(_inner) =>
            Some(_inner)
            ,
            CreateDistributionErrorKind::TooManyQueryStringParameters(_inner) =>
            Some(_inner)
            ,
            CreateDistributionErrorKind::TooManyTrustedSigners(_inner) =>
            Some(_inner)
            ,
            CreateDistributionErrorKind::TrustedKeyGroupDoesNotExist(_inner) =>
            Some(_inner)
            ,
            CreateDistributionErrorKind::TrustedSignerDoesNotExist(_inner) =>
            Some(_inner)
            ,
            CreateDistributionErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `CreateDistributionWithTags` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateDistributionWithTagsError {
    /// Kind of error that occurred.
    pub kind: CreateDistributionWithTagsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateDistributionWithTags` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateDistributionWithTagsErrorKind {
    /// <p>Access denied.</p>
    AccessDenied(crate::error::AccessDenied),
    /// <p>The CNAME specified is already defined for CloudFront.</p>
    CnameAlreadyExists(crate::error::CnameAlreadyExists),
    /// <p>The caller reference you attempted to create the distribution with is associated with another distribution.</p>
    DistributionAlreadyExists(crate::error::DistributionAlreadyExists),
    /// <p>The specified configuration for field-level encryption can't be associated with the specified cache behavior.</p>
    IllegalFieldLevelEncryptionConfigAssociationWithCacheBehavior(
        crate::error::IllegalFieldLevelEncryptionConfigAssociationWithCacheBehavior,
    ),
    /// <p>The value of <code>Quantity</code> and the size of <code>Items</code> don't match.</p>
    InconsistentQuantities(crate::error::InconsistentQuantities),
    /// <p>An argument is invalid.</p>
    InvalidArgument(crate::error::InvalidArgument),
    /// <p>The default root object file name is too big or contains an invalid character.</p>
    InvalidDefaultRootObject(crate::error::InvalidDefaultRootObject),
    /// <p>An invalid error code was specified.</p>
    InvalidErrorCode(crate::error::InvalidErrorCode),
    /// <p>Your request contains forward cookies option which doesn't match with the expectation for the <code>whitelisted</code> list of cookie names. Either list of cookie names has been specified when not allowed or list of cookie names is missing when expected.</p>
    InvalidForwardCookies(crate::error::InvalidForwardCookies),
    /// <p>A CloudFront function association is invalid.</p>
    InvalidFunctionAssociation(crate::error::InvalidFunctionAssociation),
    /// <p>The specified geo restriction parameter is not valid.</p>
    InvalidGeoRestrictionParameter(crate::error::InvalidGeoRestrictionParameter),
    /// <p>The headers specified are not valid for an Amazon S3 origin.</p>
    InvalidHeadersForS3Origin(crate::error::InvalidHeadersForS3Origin),
    /// <p>The specified Lambda@Edge function association is invalid.</p>
    InvalidLambdaFunctionAssociation(crate::error::InvalidLambdaFunctionAssociation),
    /// <p>The location code specified is not valid.</p>
    InvalidLocationCode(crate::error::InvalidLocationCode),
    /// <p>The minimum protocol version specified is not valid.</p>
    InvalidMinimumProtocolVersion(crate::error::InvalidMinimumProtocolVersion),
    /// <p>The Amazon S3 origin server specified does not refer to a valid Amazon S3 bucket.</p>
    InvalidOrigin(crate::error::InvalidOrigin),
    /// <p>The origin access identity is not valid or doesn't exist.</p>
    InvalidOriginAccessIdentity(crate::error::InvalidOriginAccessIdentity),
    /// <p>The keep alive timeout specified for the origin is not valid.</p>
    InvalidOriginKeepaliveTimeout(crate::error::InvalidOriginKeepaliveTimeout),
    /// <p>The read timeout specified for the origin is not valid.</p>
    InvalidOriginReadTimeout(crate::error::InvalidOriginReadTimeout),
    /// <p>You cannot specify SSLv3 as the minimum protocol version if you only want to support only clients that support Server Name Indication (SNI).</p>
    InvalidProtocolSettings(crate::error::InvalidProtocolSettings),
    /// <p>The query string parameters specified are not valid.</p>
    InvalidQueryStringParameters(crate::error::InvalidQueryStringParameters),
    /// <p>The relative path is too big, is not URL-encoded, or does not begin with a slash (/).</p>
    InvalidRelativePath(crate::error::InvalidRelativePath),
    /// <p>This operation requires the HTTPS protocol. Ensure that you specify the HTTPS protocol in your request, or omit the <code>RequiredProtocols</code> element from your distribution configuration.</p>
    InvalidRequiredProtocol(crate::error::InvalidRequiredProtocol),
    /// <p>A response code is not valid.</p>
    InvalidResponseCode(crate::error::InvalidResponseCode),
    /// <p>The tagging specified is not valid.</p>
    InvalidTagging(crate::error::InvalidTagging),
    /// <p>The TTL order specified is not valid.</p>
    InvalidTtlOrder(crate::error::InvalidTtlOrder),
    /// <p>A viewer certificate specified is not valid.</p>
    InvalidViewerCertificate(crate::error::InvalidViewerCertificate),
    /// <p>A web ACL ID specified is not valid. To specify a web ACL created using the latest version of WAF, use the ACL ARN, for example <code>arn:aws:wafv2:us-east-1:123456789012:global/webacl/ExampleWebACL/473e64fd-f30b-4765-81a0-62ad96dd167a</code>. To specify a web ACL created using WAF Classic, use the ACL ID, for example <code>473e64fd-f30b-4765-81a0-62ad96dd167a</code>.</p>
    InvalidWebAclId(crate::error::InvalidWebAclId),
    /// <p>This operation requires a body. Ensure that the body is present and the <code>Content-Type</code> header is set.</p>
    MissingBody(crate::error::MissingBody),
    /// <p>The cache policy does not exist.</p>
    NoSuchCachePolicy(crate::error::NoSuchCachePolicy),
    /// <p>The specified configuration for field-level encryption doesn't exist.</p>
    NoSuchFieldLevelEncryptionConfig(crate::error::NoSuchFieldLevelEncryptionConfig),
    /// <p>No origin exists with the specified <code>Origin Id</code>. </p>
    NoSuchOrigin(crate::error::NoSuchOrigin),
    /// <p>The origin request policy does not exist.</p>
    NoSuchOriginRequestPolicy(crate::error::NoSuchOriginRequestPolicy),
    /// <p>The real-time log configuration does not exist.</p>
    NoSuchRealtimeLogConfig(crate::error::NoSuchRealtimeLogConfig),
    /// <p>The response headers policy does not exist.</p>
    NoSuchResponseHeadersPolicy(crate::error::NoSuchResponseHeadersPolicy),
    /// <p>The specified real-time log configuration belongs to a different Amazon Web Services account.</p>
    RealtimeLogConfigOwnerMismatch(crate::error::RealtimeLogConfigOwnerMismatch),
    /// <p>You cannot create more cache behaviors for the distribution.</p>
    TooManyCacheBehaviors(crate::error::TooManyCacheBehaviors),
    /// <p>You cannot create anymore custom SSL/TLS certificates.</p>
    TooManyCertificates(crate::error::TooManyCertificates),
    /// <p>Your request contains more cookie names in the whitelist than are allowed per cache behavior.</p>
    TooManyCookieNamesInWhiteList(crate::error::TooManyCookieNamesInWhiteList),
    /// <p>Your request contains more CNAMEs than are allowed per distribution.</p>
    TooManyDistributionCnamEs(crate::error::TooManyDistributionCnamEs),
    /// <p>Processing your request would cause you to exceed the maximum number of distributions allowed.</p>
    TooManyDistributions(crate::error::TooManyDistributions),
    /// <p>The maximum number of distributions have been associated with the specified cache policy. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html">Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.</p>
    TooManyDistributionsAssociatedToCachePolicy(
        crate::error::TooManyDistributionsAssociatedToCachePolicy,
    ),
    /// <p>The maximum number of distributions have been associated with the specified configuration for field-level encryption.</p>
    TooManyDistributionsAssociatedToFieldLevelEncryptionConfig(
        crate::error::TooManyDistributionsAssociatedToFieldLevelEncryptionConfig,
    ),
    /// <p>The number of distributions that reference this key group is more than the maximum allowed. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html">Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.</p>
    TooManyDistributionsAssociatedToKeyGroup(
        crate::error::TooManyDistributionsAssociatedToKeyGroup,
    ),
    /// <p>The maximum number of distributions have been associated with the specified origin request policy. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html">Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.</p>
    TooManyDistributionsAssociatedToOriginRequestPolicy(
        crate::error::TooManyDistributionsAssociatedToOriginRequestPolicy,
    ),
    /// <p>The maximum number of distributions have been associated with the specified response headers policy.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html">Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.</p>
    TooManyDistributionsAssociatedToResponseHeadersPolicy(
        crate::error::TooManyDistributionsAssociatedToResponseHeadersPolicy,
    ),
    /// <p>You have reached the maximum number of distributions that are associated with a CloudFront function. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html">Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.</p>
    TooManyDistributionsWithFunctionAssociations(
        crate::error::TooManyDistributionsWithFunctionAssociations,
    ),
    /// <p>Processing your request would cause the maximum number of distributions with Lambda@Edge function associations per owner to be exceeded.</p>
    TooManyDistributionsWithLambdaAssociations(
        crate::error::TooManyDistributionsWithLambdaAssociations,
    ),
    /// <p>The maximum number of distributions have been associated with the specified Lambda@Edge function.</p>
    TooManyDistributionsWithSingleFunctionArn(
        crate::error::TooManyDistributionsWithSingleFunctionArn,
    ),
    /// <p>You have reached the maximum number of CloudFront function associations for this distribution. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html">Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.</p>
    TooManyFunctionAssociations(crate::error::TooManyFunctionAssociations),
    /// <p>Your request contains too many headers in forwarded values.</p>
    TooManyHeadersInForwardedValues(crate::error::TooManyHeadersInForwardedValues),
    /// <p>The number of key groups referenced by this distribution is more than the maximum allowed. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html">Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.</p>
    TooManyKeyGroupsAssociatedToDistribution(
        crate::error::TooManyKeyGroupsAssociatedToDistribution,
    ),
    /// <p>Your request contains more Lambda@Edge function associations than are allowed per distribution.</p>
    TooManyLambdaFunctionAssociations(crate::error::TooManyLambdaFunctionAssociations),
    /// <p>Your request contains too many origin custom headers.</p>
    TooManyOriginCustomHeaders(crate::error::TooManyOriginCustomHeaders),
    /// <p>Processing your request would cause you to exceed the maximum number of origin groups allowed.</p>
    TooManyOriginGroupsPerDistribution(crate::error::TooManyOriginGroupsPerDistribution),
    /// <p>You cannot create more origins for the distribution.</p>
    TooManyOrigins(crate::error::TooManyOrigins),
    /// <p>Your request contains too many query string parameters.</p>
    TooManyQueryStringParameters(crate::error::TooManyQueryStringParameters),
    /// <p>Your request contains more trusted signers than are allowed per distribution.</p>
    TooManyTrustedSigners(crate::error::TooManyTrustedSigners),
    /// <p>The specified key group does not exist.</p>
    TrustedKeyGroupDoesNotExist(crate::error::TrustedKeyGroupDoesNotExist),
    /// <p>One or more of your trusted signers don't exist.</p>
    TrustedSignerDoesNotExist(crate::error::TrustedSignerDoesNotExist),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateDistributionWithTagsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateDistributionWithTagsErrorKind::AccessDenied(_inner) =>
            _inner.fmt(f)
            ,
            CreateDistributionWithTagsErrorKind::CnameAlreadyExists(_inner) =>
            _inner.fmt(f)
            ,
            CreateDistributionWithTagsErrorKind::DistributionAlreadyExists(_inner) =>
            _inner.fmt(f)
            ,
            CreateDistributionWithTagsErrorKind::IllegalFieldLevelEncryptionConfigAssociationWithCacheBehavior(_inner) =>
            _inner.fmt(f)
            ,
            CreateDistributionWithTagsErrorKind::InconsistentQuantities(_inner) =>
            _inner.fmt(f)
            ,
            CreateDistributionWithTagsErrorKind::InvalidArgument(_inner) =>
            _inner.fmt(f)
            ,
            CreateDistributionWithTagsErrorKind::InvalidDefaultRootObject(_inner) =>
            _inner.fmt(f)
            ,
            CreateDistributionWithTagsErrorKind::InvalidErrorCode(_inner) =>
            _inner.fmt(f)
            ,
            CreateDistributionWithTagsErrorKind::InvalidForwardCookies(_inner) =>
            _inner.fmt(f)
            ,
            CreateDistributionWithTagsErrorKind::InvalidFunctionAssociation(_inner) =>
            _inner.fmt(f)
            ,
            CreateDistributionWithTagsErrorKind::InvalidGeoRestrictionParameter(_inner) =>
            _inner.fmt(f)
            ,
            CreateDistributionWithTagsErrorKind::InvalidHeadersForS3Origin(_inner) =>
            _inner.fmt(f)
            ,
            CreateDistributionWithTagsErrorKind::InvalidLambdaFunctionAssociation(_inner) =>
            _inner.fmt(f)
            ,
            CreateDistributionWithTagsErrorKind::InvalidLocationCode(_inner) =>
            _inner.fmt(f)
            ,
            CreateDistributionWithTagsErrorKind::InvalidMinimumProtocolVersion(_inner) =>
            _inner.fmt(f)
            ,
            CreateDistributionWithTagsErrorKind::InvalidOrigin(_inner) =>
            _inner.fmt(f)
            ,
            CreateDistributionWithTagsErrorKind::InvalidOriginAccessIdentity(_inner) =>
            _inner.fmt(f)
            ,
            CreateDistributionWithTagsErrorKind::InvalidOriginKeepaliveTimeout(_inner) =>
            _inner.fmt(f)
            ,
            CreateDistributionWithTagsErrorKind::InvalidOriginReadTimeout(_inner) =>
            _inner.fmt(f)
            ,
            CreateDistributionWithTagsErrorKind::InvalidProtocolSettings(_inner) =>
            _inner.fmt(f)
            ,
            CreateDistributionWithTagsErrorKind::InvalidQueryStringParameters(_inner) =>
            _inner.fmt(f)
            ,
            CreateDistributionWithTagsErrorKind::InvalidRelativePath(_inner) =>
            _inner.fmt(f)
            ,
            CreateDistributionWithTagsErrorKind::InvalidRequiredProtocol(_inner) =>
            _inner.fmt(f)
            ,
            CreateDistributionWithTagsErrorKind::InvalidResponseCode(_inner) =>
            _inner.fmt(f)
            ,
            CreateDistributionWithTagsErrorKind::InvalidTagging(_inner) =>
            _inner.fmt(f)
            ,
            CreateDistributionWithTagsErrorKind::InvalidTtlOrder(_inner) =>
            _inner.fmt(f)
            ,
            CreateDistributionWithTagsErrorKind::InvalidViewerCertificate(_inner) =>
            _inner.fmt(f)
            ,
            CreateDistributionWithTagsErrorKind::InvalidWebAclId(_inner) =>
            _inner.fmt(f)
            ,
            CreateDistributionWithTagsErrorKind::MissingBody(_inner) =>
            _inner.fmt(f)
            ,
            CreateDistributionWithTagsErrorKind::NoSuchCachePolicy(_inner) =>
            _inner.fmt(f)
            ,
            CreateDistributionWithTagsErrorKind::NoSuchFieldLevelEncryptionConfig(_inner) =>
            _inner.fmt(f)
            ,
            CreateDistributionWithTagsErrorKind::NoSuchOrigin(_inner) =>
            _inner.fmt(f)
            ,
            CreateDistributionWithTagsErrorKind::NoSuchOriginRequestPolicy(_inner) =>
            _inner.fmt(f)
            ,
            CreateDistributionWithTagsErrorKind::NoSuchRealtimeLogConfig(_inner) =>
            _inner.fmt(f)
            ,
            CreateDistributionWithTagsErrorKind::NoSuchResponseHeadersPolicy(_inner) =>
            _inner.fmt(f)
            ,
            CreateDistributionWithTagsErrorKind::RealtimeLogConfigOwnerMismatch(_inner) =>
            _inner.fmt(f)
            ,
            CreateDistributionWithTagsErrorKind::TooManyCacheBehaviors(_inner) =>
            _inner.fmt(f)
            ,
            CreateDistributionWithTagsErrorKind::TooManyCertificates(_inner) =>
            _inner.fmt(f)
            ,
            CreateDistributionWithTagsErrorKind::TooManyCookieNamesInWhiteList(_inner) =>
            _inner.fmt(f)
            ,
            CreateDistributionWithTagsErrorKind::TooManyDistributionCnamEs(_inner) =>
            _inner.fmt(f)
            ,
            CreateDistributionWithTagsErrorKind::TooManyDistributions(_inner) =>
            _inner.fmt(f)
            ,
            CreateDistributionWithTagsErrorKind::TooManyDistributionsAssociatedToCachePolicy(_inner) =>
            _inner.fmt(f)
            ,
            CreateDistributionWithTagsErrorKind::TooManyDistributionsAssociatedToFieldLevelEncryptionConfig(_inner) =>
            _inner.fmt(f)
            ,
            CreateDistributionWithTagsErrorKind::TooManyDistributionsAssociatedToKeyGroup(_inner) =>
            _inner.fmt(f)
            ,
            CreateDistributionWithTagsErrorKind::TooManyDistributionsAssociatedToOriginRequestPolicy(_inner) =>
            _inner.fmt(f)
            ,
            CreateDistributionWithTagsErrorKind::TooManyDistributionsAssociatedToResponseHeadersPolicy(_inner) =>
            _inner.fmt(f)
            ,
            CreateDistributionWithTagsErrorKind::TooManyDistributionsWithFunctionAssociations(_inner) =>
            _inner.fmt(f)
            ,
            CreateDistributionWithTagsErrorKind::TooManyDistributionsWithLambdaAssociations(_inner) =>
            _inner.fmt(f)
            ,
            CreateDistributionWithTagsErrorKind::TooManyDistributionsWithSingleFunctionArn(_inner) =>
            _inner.fmt(f)
            ,
            CreateDistributionWithTagsErrorKind::TooManyFunctionAssociations(_inner) =>
            _inner.fmt(f)
            ,
            CreateDistributionWithTagsErrorKind::TooManyHeadersInForwardedValues(_inner) =>
            _inner.fmt(f)
            ,
            CreateDistributionWithTagsErrorKind::TooManyKeyGroupsAssociatedToDistribution(_inner) =>
            _inner.fmt(f)
            ,
            CreateDistributionWithTagsErrorKind::TooManyLambdaFunctionAssociations(_inner) =>
            _inner.fmt(f)
            ,
            CreateDistributionWithTagsErrorKind::TooManyOriginCustomHeaders(_inner) =>
            _inner.fmt(f)
            ,
            CreateDistributionWithTagsErrorKind::TooManyOriginGroupsPerDistribution(_inner) =>
            _inner.fmt(f)
            ,
            CreateDistributionWithTagsErrorKind::TooManyOrigins(_inner) =>
            _inner.fmt(f)
            ,
            CreateDistributionWithTagsErrorKind::TooManyQueryStringParameters(_inner) =>
            _inner.fmt(f)
            ,
            CreateDistributionWithTagsErrorKind::TooManyTrustedSigners(_inner) =>
            _inner.fmt(f)
            ,
            CreateDistributionWithTagsErrorKind::TrustedKeyGroupDoesNotExist(_inner) =>
            _inner.fmt(f)
            ,
            CreateDistributionWithTagsErrorKind::TrustedSignerDoesNotExist(_inner) =>
            _inner.fmt(f)
            ,
            CreateDistributionWithTagsErrorKind::Unhandled(_inner) => {
                _inner.fmt(f)
            }
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateDistributionWithTagsError {
    fn code(&self) -> Option<&str> {
        CreateDistributionWithTagsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateDistributionWithTagsError {
    /// Creates a new `CreateDistributionWithTagsError`.
    pub fn new(kind: CreateDistributionWithTagsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateDistributionWithTagsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateDistributionWithTagsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateDistributionWithTagsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateDistributionWithTagsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateDistributionWithTagsErrorKind::AccessDenied`.
    pub fn is_access_denied(&self) -> bool {
        matches!(
            &self.kind,
            CreateDistributionWithTagsErrorKind::AccessDenied(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDistributionWithTagsErrorKind::CnameAlreadyExists`.
    pub fn is_cname_already_exists(&self) -> bool {
        matches!(
            &self.kind,
            CreateDistributionWithTagsErrorKind::CnameAlreadyExists(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDistributionWithTagsErrorKind::DistributionAlreadyExists`.
    pub fn is_distribution_already_exists(&self) -> bool {
        matches!(
            &self.kind,
            CreateDistributionWithTagsErrorKind::DistributionAlreadyExists(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDistributionWithTagsErrorKind::IllegalFieldLevelEncryptionConfigAssociationWithCacheBehavior`.
    pub fn is_illegal_field_level_encryption_config_association_with_cache_behavior(&self) -> bool {
        matches!(&self.kind, CreateDistributionWithTagsErrorKind::IllegalFieldLevelEncryptionConfigAssociationWithCacheBehavior(_))
    }
    /// Returns `true` if the error kind is `CreateDistributionWithTagsErrorKind::InconsistentQuantities`.
    pub fn is_inconsistent_quantities(&self) -> bool {
        matches!(
            &self.kind,
            CreateDistributionWithTagsErrorKind::InconsistentQuantities(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDistributionWithTagsErrorKind::InvalidArgument`.
    pub fn is_invalid_argument(&self) -> bool {
        matches!(
            &self.kind,
            CreateDistributionWithTagsErrorKind::InvalidArgument(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDistributionWithTagsErrorKind::InvalidDefaultRootObject`.
    pub fn is_invalid_default_root_object(&self) -> bool {
        matches!(
            &self.kind,
            CreateDistributionWithTagsErrorKind::InvalidDefaultRootObject(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDistributionWithTagsErrorKind::InvalidErrorCode`.
    pub fn is_invalid_error_code(&self) -> bool {
        matches!(
            &self.kind,
            CreateDistributionWithTagsErrorKind::InvalidErrorCode(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDistributionWithTagsErrorKind::InvalidForwardCookies`.
    pub fn is_invalid_forward_cookies(&self) -> bool {
        matches!(
            &self.kind,
            CreateDistributionWithTagsErrorKind::InvalidForwardCookies(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDistributionWithTagsErrorKind::InvalidFunctionAssociation`.
    pub fn is_invalid_function_association(&self) -> bool {
        matches!(
            &self.kind,
            CreateDistributionWithTagsErrorKind::InvalidFunctionAssociation(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDistributionWithTagsErrorKind::InvalidGeoRestrictionParameter`.
    pub fn is_invalid_geo_restriction_parameter(&self) -> bool {
        matches!(
            &self.kind,
            CreateDistributionWithTagsErrorKind::InvalidGeoRestrictionParameter(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDistributionWithTagsErrorKind::InvalidHeadersForS3Origin`.
    pub fn is_invalid_headers_for_s3_origin(&self) -> bool {
        matches!(
            &self.kind,
            CreateDistributionWithTagsErrorKind::InvalidHeadersForS3Origin(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDistributionWithTagsErrorKind::InvalidLambdaFunctionAssociation`.
    pub fn is_invalid_lambda_function_association(&self) -> bool {
        matches!(
            &self.kind,
            CreateDistributionWithTagsErrorKind::InvalidLambdaFunctionAssociation(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDistributionWithTagsErrorKind::InvalidLocationCode`.
    pub fn is_invalid_location_code(&self) -> bool {
        matches!(
            &self.kind,
            CreateDistributionWithTagsErrorKind::InvalidLocationCode(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDistributionWithTagsErrorKind::InvalidMinimumProtocolVersion`.
    pub fn is_invalid_minimum_protocol_version(&self) -> bool {
        matches!(
            &self.kind,
            CreateDistributionWithTagsErrorKind::InvalidMinimumProtocolVersion(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDistributionWithTagsErrorKind::InvalidOrigin`.
    pub fn is_invalid_origin(&self) -> bool {
        matches!(
            &self.kind,
            CreateDistributionWithTagsErrorKind::InvalidOrigin(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDistributionWithTagsErrorKind::InvalidOriginAccessIdentity`.
    pub fn is_invalid_origin_access_identity(&self) -> bool {
        matches!(
            &self.kind,
            CreateDistributionWithTagsErrorKind::InvalidOriginAccessIdentity(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDistributionWithTagsErrorKind::InvalidOriginKeepaliveTimeout`.
    pub fn is_invalid_origin_keepalive_timeout(&self) -> bool {
        matches!(
            &self.kind,
            CreateDistributionWithTagsErrorKind::InvalidOriginKeepaliveTimeout(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDistributionWithTagsErrorKind::InvalidOriginReadTimeout`.
    pub fn is_invalid_origin_read_timeout(&self) -> bool {
        matches!(
            &self.kind,
            CreateDistributionWithTagsErrorKind::InvalidOriginReadTimeout(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDistributionWithTagsErrorKind::InvalidProtocolSettings`.
    pub fn is_invalid_protocol_settings(&self) -> bool {
        matches!(
            &self.kind,
            CreateDistributionWithTagsErrorKind::InvalidProtocolSettings(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDistributionWithTagsErrorKind::InvalidQueryStringParameters`.
    pub fn is_invalid_query_string_parameters(&self) -> bool {
        matches!(
            &self.kind,
            CreateDistributionWithTagsErrorKind::InvalidQueryStringParameters(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDistributionWithTagsErrorKind::InvalidRelativePath`.
    pub fn is_invalid_relative_path(&self) -> bool {
        matches!(
            &self.kind,
            CreateDistributionWithTagsErrorKind::InvalidRelativePath(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDistributionWithTagsErrorKind::InvalidRequiredProtocol`.
    pub fn is_invalid_required_protocol(&self) -> bool {
        matches!(
            &self.kind,
            CreateDistributionWithTagsErrorKind::InvalidRequiredProtocol(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDistributionWithTagsErrorKind::InvalidResponseCode`.
    pub fn is_invalid_response_code(&self) -> bool {
        matches!(
            &self.kind,
            CreateDistributionWithTagsErrorKind::InvalidResponseCode(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDistributionWithTagsErrorKind::InvalidTagging`.
    pub fn is_invalid_tagging(&self) -> bool {
        matches!(
            &self.kind,
            CreateDistributionWithTagsErrorKind::InvalidTagging(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDistributionWithTagsErrorKind::InvalidTtlOrder`.
    pub fn is_invalid_ttl_order(&self) -> bool {
        matches!(
            &self.kind,
            CreateDistributionWithTagsErrorKind::InvalidTtlOrder(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDistributionWithTagsErrorKind::InvalidViewerCertificate`.
    pub fn is_invalid_viewer_certificate(&self) -> bool {
        matches!(
            &self.kind,
            CreateDistributionWithTagsErrorKind::InvalidViewerCertificate(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDistributionWithTagsErrorKind::InvalidWebAclId`.
    pub fn is_invalid_web_acl_id(&self) -> bool {
        matches!(
            &self.kind,
            CreateDistributionWithTagsErrorKind::InvalidWebAclId(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDistributionWithTagsErrorKind::MissingBody`.
    pub fn is_missing_body(&self) -> bool {
        matches!(
            &self.kind,
            CreateDistributionWithTagsErrorKind::MissingBody(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDistributionWithTagsErrorKind::NoSuchCachePolicy`.
    pub fn is_no_such_cache_policy(&self) -> bool {
        matches!(
            &self.kind,
            CreateDistributionWithTagsErrorKind::NoSuchCachePolicy(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDistributionWithTagsErrorKind::NoSuchFieldLevelEncryptionConfig`.
    pub fn is_no_such_field_level_encryption_config(&self) -> bool {
        matches!(
            &self.kind,
            CreateDistributionWithTagsErrorKind::NoSuchFieldLevelEncryptionConfig(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDistributionWithTagsErrorKind::NoSuchOrigin`.
    pub fn is_no_such_origin(&self) -> bool {
        matches!(
            &self.kind,
            CreateDistributionWithTagsErrorKind::NoSuchOrigin(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDistributionWithTagsErrorKind::NoSuchOriginRequestPolicy`.
    pub fn is_no_such_origin_request_policy(&self) -> bool {
        matches!(
            &self.kind,
            CreateDistributionWithTagsErrorKind::NoSuchOriginRequestPolicy(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDistributionWithTagsErrorKind::NoSuchRealtimeLogConfig`.
    pub fn is_no_such_realtime_log_config(&self) -> bool {
        matches!(
            &self.kind,
            CreateDistributionWithTagsErrorKind::NoSuchRealtimeLogConfig(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDistributionWithTagsErrorKind::NoSuchResponseHeadersPolicy`.
    pub fn is_no_such_response_headers_policy(&self) -> bool {
        matches!(
            &self.kind,
            CreateDistributionWithTagsErrorKind::NoSuchResponseHeadersPolicy(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDistributionWithTagsErrorKind::RealtimeLogConfigOwnerMismatch`.
    pub fn is_realtime_log_config_owner_mismatch(&self) -> bool {
        matches!(
            &self.kind,
            CreateDistributionWithTagsErrorKind::RealtimeLogConfigOwnerMismatch(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDistributionWithTagsErrorKind::TooManyCacheBehaviors`.
    pub fn is_too_many_cache_behaviors(&self) -> bool {
        matches!(
            &self.kind,
            CreateDistributionWithTagsErrorKind::TooManyCacheBehaviors(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDistributionWithTagsErrorKind::TooManyCertificates`.
    pub fn is_too_many_certificates(&self) -> bool {
        matches!(
            &self.kind,
            CreateDistributionWithTagsErrorKind::TooManyCertificates(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDistributionWithTagsErrorKind::TooManyCookieNamesInWhiteList`.
    pub fn is_too_many_cookie_names_in_white_list(&self) -> bool {
        matches!(
            &self.kind,
            CreateDistributionWithTagsErrorKind::TooManyCookieNamesInWhiteList(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDistributionWithTagsErrorKind::TooManyDistributionCnamEs`.
    pub fn is_too_many_distribution_cnam_es(&self) -> bool {
        matches!(
            &self.kind,
            CreateDistributionWithTagsErrorKind::TooManyDistributionCnamEs(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDistributionWithTagsErrorKind::TooManyDistributions`.
    pub fn is_too_many_distributions(&self) -> bool {
        matches!(
            &self.kind,
            CreateDistributionWithTagsErrorKind::TooManyDistributions(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDistributionWithTagsErrorKind::TooManyDistributionsAssociatedToCachePolicy`.
    pub fn is_too_many_distributions_associated_to_cache_policy(&self) -> bool {
        matches!(
            &self.kind,
            CreateDistributionWithTagsErrorKind::TooManyDistributionsAssociatedToCachePolicy(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDistributionWithTagsErrorKind::TooManyDistributionsAssociatedToFieldLevelEncryptionConfig`.
    pub fn is_too_many_distributions_associated_to_field_level_encryption_config(&self) -> bool {
        matches!(&self.kind, CreateDistributionWithTagsErrorKind::TooManyDistributionsAssociatedToFieldLevelEncryptionConfig(_))
    }
    /// Returns `true` if the error kind is `CreateDistributionWithTagsErrorKind::TooManyDistributionsAssociatedToKeyGroup`.
    pub fn is_too_many_distributions_associated_to_key_group(&self) -> bool {
        matches!(
            &self.kind,
            CreateDistributionWithTagsErrorKind::TooManyDistributionsAssociatedToKeyGroup(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDistributionWithTagsErrorKind::TooManyDistributionsAssociatedToOriginRequestPolicy`.
    pub fn is_too_many_distributions_associated_to_origin_request_policy(&self) -> bool {
        matches!(&self.kind, CreateDistributionWithTagsErrorKind::TooManyDistributionsAssociatedToOriginRequestPolicy(_))
    }
    /// Returns `true` if the error kind is `CreateDistributionWithTagsErrorKind::TooManyDistributionsAssociatedToResponseHeadersPolicy`.
    pub fn is_too_many_distributions_associated_to_response_headers_policy(&self) -> bool {
        matches!(&self.kind, CreateDistributionWithTagsErrorKind::TooManyDistributionsAssociatedToResponseHeadersPolicy(_))
    }
    /// Returns `true` if the error kind is `CreateDistributionWithTagsErrorKind::TooManyDistributionsWithFunctionAssociations`.
    pub fn is_too_many_distributions_with_function_associations(&self) -> bool {
        matches!(
            &self.kind,
            CreateDistributionWithTagsErrorKind::TooManyDistributionsWithFunctionAssociations(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDistributionWithTagsErrorKind::TooManyDistributionsWithLambdaAssociations`.
    pub fn is_too_many_distributions_with_lambda_associations(&self) -> bool {
        matches!(
            &self.kind,
            CreateDistributionWithTagsErrorKind::TooManyDistributionsWithLambdaAssociations(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDistributionWithTagsErrorKind::TooManyDistributionsWithSingleFunctionArn`.
    pub fn is_too_many_distributions_with_single_function_arn(&self) -> bool {
        matches!(
            &self.kind,
            CreateDistributionWithTagsErrorKind::TooManyDistributionsWithSingleFunctionArn(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDistributionWithTagsErrorKind::TooManyFunctionAssociations`.
    pub fn is_too_many_function_associations(&self) -> bool {
        matches!(
            &self.kind,
            CreateDistributionWithTagsErrorKind::TooManyFunctionAssociations(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDistributionWithTagsErrorKind::TooManyHeadersInForwardedValues`.
    pub fn is_too_many_headers_in_forwarded_values(&self) -> bool {
        matches!(
            &self.kind,
            CreateDistributionWithTagsErrorKind::TooManyHeadersInForwardedValues(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDistributionWithTagsErrorKind::TooManyKeyGroupsAssociatedToDistribution`.
    pub fn is_too_many_key_groups_associated_to_distribution(&self) -> bool {
        matches!(
            &self.kind,
            CreateDistributionWithTagsErrorKind::TooManyKeyGroupsAssociatedToDistribution(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDistributionWithTagsErrorKind::TooManyLambdaFunctionAssociations`.
    pub fn is_too_many_lambda_function_associations(&self) -> bool {
        matches!(
            &self.kind,
            CreateDistributionWithTagsErrorKind::TooManyLambdaFunctionAssociations(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDistributionWithTagsErrorKind::TooManyOriginCustomHeaders`.
    pub fn is_too_many_origin_custom_headers(&self) -> bool {
        matches!(
            &self.kind,
            CreateDistributionWithTagsErrorKind::TooManyOriginCustomHeaders(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDistributionWithTagsErrorKind::TooManyOriginGroupsPerDistribution`.
    pub fn is_too_many_origin_groups_per_distribution(&self) -> bool {
        matches!(
            &self.kind,
            CreateDistributionWithTagsErrorKind::TooManyOriginGroupsPerDistribution(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDistributionWithTagsErrorKind::TooManyOrigins`.
    pub fn is_too_many_origins(&self) -> bool {
        matches!(
            &self.kind,
            CreateDistributionWithTagsErrorKind::TooManyOrigins(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDistributionWithTagsErrorKind::TooManyQueryStringParameters`.
    pub fn is_too_many_query_string_parameters(&self) -> bool {
        matches!(
            &self.kind,
            CreateDistributionWithTagsErrorKind::TooManyQueryStringParameters(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDistributionWithTagsErrorKind::TooManyTrustedSigners`.
    pub fn is_too_many_trusted_signers(&self) -> bool {
        matches!(
            &self.kind,
            CreateDistributionWithTagsErrorKind::TooManyTrustedSigners(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDistributionWithTagsErrorKind::TrustedKeyGroupDoesNotExist`.
    pub fn is_trusted_key_group_does_not_exist(&self) -> bool {
        matches!(
            &self.kind,
            CreateDistributionWithTagsErrorKind::TrustedKeyGroupDoesNotExist(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDistributionWithTagsErrorKind::TrustedSignerDoesNotExist`.
    pub fn is_trusted_signer_does_not_exist(&self) -> bool {
        matches!(
            &self.kind,
            CreateDistributionWithTagsErrorKind::TrustedSignerDoesNotExist(_)
        )
    }
}
impl std::error::Error for CreateDistributionWithTagsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateDistributionWithTagsErrorKind::AccessDenied(_inner) =>
            Some(_inner)
            ,
            CreateDistributionWithTagsErrorKind::CnameAlreadyExists(_inner) =>
            Some(_inner)
            ,
            CreateDistributionWithTagsErrorKind::DistributionAlreadyExists(_inner) =>
            Some(_inner)
            ,
            CreateDistributionWithTagsErrorKind::IllegalFieldLevelEncryptionConfigAssociationWithCacheBehavior(_inner) =>
            Some(_inner)
            ,
            CreateDistributionWithTagsErrorKind::InconsistentQuantities(_inner) =>
            Some(_inner)
            ,
            CreateDistributionWithTagsErrorKind::InvalidArgument(_inner) =>
            Some(_inner)
            ,
            CreateDistributionWithTagsErrorKind::InvalidDefaultRootObject(_inner) =>
            Some(_inner)
            ,
            CreateDistributionWithTagsErrorKind::InvalidErrorCode(_inner) =>
            Some(_inner)
            ,
            CreateDistributionWithTagsErrorKind::InvalidForwardCookies(_inner) =>
            Some(_inner)
            ,
            CreateDistributionWithTagsErrorKind::InvalidFunctionAssociation(_inner) =>
            Some(_inner)
            ,
            CreateDistributionWithTagsErrorKind::InvalidGeoRestrictionParameter(_inner) =>
            Some(_inner)
            ,
            CreateDistributionWithTagsErrorKind::InvalidHeadersForS3Origin(_inner) =>
            Some(_inner)
            ,
            CreateDistributionWithTagsErrorKind::InvalidLambdaFunctionAssociation(_inner) =>
            Some(_inner)
            ,
            CreateDistributionWithTagsErrorKind::InvalidLocationCode(_inner) =>
            Some(_inner)
            ,
            CreateDistributionWithTagsErrorKind::InvalidMinimumProtocolVersion(_inner) =>
            Some(_inner)
            ,
            CreateDistributionWithTagsErrorKind::InvalidOrigin(_inner) =>
            Some(_inner)
            ,
            CreateDistributionWithTagsErrorKind::InvalidOriginAccessIdentity(_inner) =>
            Some(_inner)
            ,
            CreateDistributionWithTagsErrorKind::InvalidOriginKeepaliveTimeout(_inner) =>
            Some(_inner)
            ,
            CreateDistributionWithTagsErrorKind::InvalidOriginReadTimeout(_inner) =>
            Some(_inner)
            ,
            CreateDistributionWithTagsErrorKind::InvalidProtocolSettings(_inner) =>
            Some(_inner)
            ,
            CreateDistributionWithTagsErrorKind::InvalidQueryStringParameters(_inner) =>
            Some(_inner)
            ,
            CreateDistributionWithTagsErrorKind::InvalidRelativePath(_inner) =>
            Some(_inner)
            ,
            CreateDistributionWithTagsErrorKind::InvalidRequiredProtocol(_inner) =>
            Some(_inner)
            ,
            CreateDistributionWithTagsErrorKind::InvalidResponseCode(_inner) =>
            Some(_inner)
            ,
            CreateDistributionWithTagsErrorKind::InvalidTagging(_inner) =>
            Some(_inner)
            ,
            CreateDistributionWithTagsErrorKind::InvalidTtlOrder(_inner) =>
            Some(_inner)
            ,
            CreateDistributionWithTagsErrorKind::InvalidViewerCertificate(_inner) =>
            Some(_inner)
            ,
            CreateDistributionWithTagsErrorKind::InvalidWebAclId(_inner) =>
            Some(_inner)
            ,
            CreateDistributionWithTagsErrorKind::MissingBody(_inner) =>
            Some(_inner)
            ,
            CreateDistributionWithTagsErrorKind::NoSuchCachePolicy(_inner) =>
            Some(_inner)
            ,
            CreateDistributionWithTagsErrorKind::NoSuchFieldLevelEncryptionConfig(_inner) =>
            Some(_inner)
            ,
            CreateDistributionWithTagsErrorKind::NoSuchOrigin(_inner) =>
            Some(_inner)
            ,
            CreateDistributionWithTagsErrorKind::NoSuchOriginRequestPolicy(_inner) =>
            Some(_inner)
            ,
            CreateDistributionWithTagsErrorKind::NoSuchRealtimeLogConfig(_inner) =>
            Some(_inner)
            ,
            CreateDistributionWithTagsErrorKind::NoSuchResponseHeadersPolicy(_inner) =>
            Some(_inner)
            ,
            CreateDistributionWithTagsErrorKind::RealtimeLogConfigOwnerMismatch(_inner) =>
            Some(_inner)
            ,
            CreateDistributionWithTagsErrorKind::TooManyCacheBehaviors(_inner) =>
            Some(_inner)
            ,
            CreateDistributionWithTagsErrorKind::TooManyCertificates(_inner) =>
            Some(_inner)
            ,
            CreateDistributionWithTagsErrorKind::TooManyCookieNamesInWhiteList(_inner) =>
            Some(_inner)
            ,
            CreateDistributionWithTagsErrorKind::TooManyDistributionCnamEs(_inner) =>
            Some(_inner)
            ,
            CreateDistributionWithTagsErrorKind::TooManyDistributions(_inner) =>
            Some(_inner)
            ,
            CreateDistributionWithTagsErrorKind::TooManyDistributionsAssociatedToCachePolicy(_inner) =>
            Some(_inner)
            ,
            CreateDistributionWithTagsErrorKind::TooManyDistributionsAssociatedToFieldLevelEncryptionConfig(_inner) =>
            Some(_inner)
            ,
            CreateDistributionWithTagsErrorKind::TooManyDistributionsAssociatedToKeyGroup(_inner) =>
            Some(_inner)
            ,
            CreateDistributionWithTagsErrorKind::TooManyDistributionsAssociatedToOriginRequestPolicy(_inner) =>
            Some(_inner)
            ,
            CreateDistributionWithTagsErrorKind::TooManyDistributionsAssociatedToResponseHeadersPolicy(_inner) =>
            Some(_inner)
            ,
            CreateDistributionWithTagsErrorKind::TooManyDistributionsWithFunctionAssociations(_inner) =>
            Some(_inner)
            ,
            CreateDistributionWithTagsErrorKind::TooManyDistributionsWithLambdaAssociations(_inner) =>
            Some(_inner)
            ,
            CreateDistributionWithTagsErrorKind::TooManyDistributionsWithSingleFunctionArn(_inner) =>
            Some(_inner)
            ,
            CreateDistributionWithTagsErrorKind::TooManyFunctionAssociations(_inner) =>
            Some(_inner)
            ,
            CreateDistributionWithTagsErrorKind::TooManyHeadersInForwardedValues(_inner) =>
            Some(_inner)
            ,
            CreateDistributionWithTagsErrorKind::TooManyKeyGroupsAssociatedToDistribution(_inner) =>
            Some(_inner)
            ,
            CreateDistributionWithTagsErrorKind::TooManyLambdaFunctionAssociations(_inner) =>
            Some(_inner)
            ,
            CreateDistributionWithTagsErrorKind::TooManyOriginCustomHeaders(_inner) =>
            Some(_inner)
            ,
            CreateDistributionWithTagsErrorKind::TooManyOriginGroupsPerDistribution(_inner) =>
            Some(_inner)
            ,
            CreateDistributionWithTagsErrorKind::TooManyOrigins(_inner) =>
            Some(_inner)
            ,
            CreateDistributionWithTagsErrorKind::TooManyQueryStringParameters(_inner) =>
            Some(_inner)
            ,
            CreateDistributionWithTagsErrorKind::TooManyTrustedSigners(_inner) =>
            Some(_inner)
            ,
            CreateDistributionWithTagsErrorKind::TrustedKeyGroupDoesNotExist(_inner) =>
            Some(_inner)
            ,
            CreateDistributionWithTagsErrorKind::TrustedSignerDoesNotExist(_inner) =>
            Some(_inner)
            ,
            CreateDistributionWithTagsErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `CreateFieldLevelEncryptionConfig` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateFieldLevelEncryptionConfigError {
    /// Kind of error that occurred.
    pub kind: CreateFieldLevelEncryptionConfigErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateFieldLevelEncryptionConfig` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateFieldLevelEncryptionConfigErrorKind {
    /// <p>The specified configuration for field-level encryption already exists.</p>
    FieldLevelEncryptionConfigAlreadyExists(crate::error::FieldLevelEncryptionConfigAlreadyExists),
    /// <p>The value of <code>Quantity</code> and the size of <code>Items</code> don't match.</p>
    InconsistentQuantities(crate::error::InconsistentQuantities),
    /// <p>An argument is invalid.</p>
    InvalidArgument(crate::error::InvalidArgument),
    /// <p>The specified profile for field-level encryption doesn't exist.</p>
    NoSuchFieldLevelEncryptionProfile(crate::error::NoSuchFieldLevelEncryptionProfile),
    /// <p>No profile specified for the field-level encryption query argument.</p>
    QueryArgProfileEmpty(crate::error::QueryArgProfileEmpty),
    /// <p>The maximum number of configurations for field-level encryption have been created.</p>
    TooManyFieldLevelEncryptionConfigs(crate::error::TooManyFieldLevelEncryptionConfigs),
    /// <p>The maximum number of content type profiles for field-level encryption have been created.</p>
    TooManyFieldLevelEncryptionContentTypeProfiles(
        crate::error::TooManyFieldLevelEncryptionContentTypeProfiles,
    ),
    /// <p>The maximum number of query arg profiles for field-level encryption have been created.</p>
    TooManyFieldLevelEncryptionQueryArgProfiles(
        crate::error::TooManyFieldLevelEncryptionQueryArgProfiles,
    ),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateFieldLevelEncryptionConfigError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateFieldLevelEncryptionConfigErrorKind::FieldLevelEncryptionConfigAlreadyExists(_inner) =>
            _inner.fmt(f)
            ,
            CreateFieldLevelEncryptionConfigErrorKind::InconsistentQuantities(_inner) =>
            _inner.fmt(f)
            ,
            CreateFieldLevelEncryptionConfigErrorKind::InvalidArgument(_inner) =>
            _inner.fmt(f)
            ,
            CreateFieldLevelEncryptionConfigErrorKind::NoSuchFieldLevelEncryptionProfile(_inner) =>
            _inner.fmt(f)
            ,
            CreateFieldLevelEncryptionConfigErrorKind::QueryArgProfileEmpty(_inner) =>
            _inner.fmt(f)
            ,
            CreateFieldLevelEncryptionConfigErrorKind::TooManyFieldLevelEncryptionConfigs(_inner) =>
            _inner.fmt(f)
            ,
            CreateFieldLevelEncryptionConfigErrorKind::TooManyFieldLevelEncryptionContentTypeProfiles(_inner) =>
            _inner.fmt(f)
            ,
            CreateFieldLevelEncryptionConfigErrorKind::TooManyFieldLevelEncryptionQueryArgProfiles(_inner) =>
            _inner.fmt(f)
            ,
            CreateFieldLevelEncryptionConfigErrorKind::Unhandled(_inner) => {
                _inner.fmt(f)
            }
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateFieldLevelEncryptionConfigError {
    fn code(&self) -> Option<&str> {
        CreateFieldLevelEncryptionConfigError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateFieldLevelEncryptionConfigError {
    /// Creates a new `CreateFieldLevelEncryptionConfigError`.
    pub fn new(
        kind: CreateFieldLevelEncryptionConfigErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateFieldLevelEncryptionConfigError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateFieldLevelEncryptionConfigErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateFieldLevelEncryptionConfigError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateFieldLevelEncryptionConfigErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateFieldLevelEncryptionConfigErrorKind::FieldLevelEncryptionConfigAlreadyExists`.
    pub fn is_field_level_encryption_config_already_exists(&self) -> bool {
        matches!(
            &self.kind,
            CreateFieldLevelEncryptionConfigErrorKind::FieldLevelEncryptionConfigAlreadyExists(_)
        )
    }
    /// Returns `true` if the error kind is `CreateFieldLevelEncryptionConfigErrorKind::InconsistentQuantities`.
    pub fn is_inconsistent_quantities(&self) -> bool {
        matches!(
            &self.kind,
            CreateFieldLevelEncryptionConfigErrorKind::InconsistentQuantities(_)
        )
    }
    /// Returns `true` if the error kind is `CreateFieldLevelEncryptionConfigErrorKind::InvalidArgument`.
    pub fn is_invalid_argument(&self) -> bool {
        matches!(
            &self.kind,
            CreateFieldLevelEncryptionConfigErrorKind::InvalidArgument(_)
        )
    }
    /// Returns `true` if the error kind is `CreateFieldLevelEncryptionConfigErrorKind::NoSuchFieldLevelEncryptionProfile`.
    pub fn is_no_such_field_level_encryption_profile(&self) -> bool {
        matches!(
            &self.kind,
            CreateFieldLevelEncryptionConfigErrorKind::NoSuchFieldLevelEncryptionProfile(_)
        )
    }
    /// Returns `true` if the error kind is `CreateFieldLevelEncryptionConfigErrorKind::QueryArgProfileEmpty`.
    pub fn is_query_arg_profile_empty(&self) -> bool {
        matches!(
            &self.kind,
            CreateFieldLevelEncryptionConfigErrorKind::QueryArgProfileEmpty(_)
        )
    }
    /// Returns `true` if the error kind is `CreateFieldLevelEncryptionConfigErrorKind::TooManyFieldLevelEncryptionConfigs`.
    pub fn is_too_many_field_level_encryption_configs(&self) -> bool {
        matches!(
            &self.kind,
            CreateFieldLevelEncryptionConfigErrorKind::TooManyFieldLevelEncryptionConfigs(_)
        )
    }
    /// Returns `true` if the error kind is `CreateFieldLevelEncryptionConfigErrorKind::TooManyFieldLevelEncryptionContentTypeProfiles`.
    pub fn is_too_many_field_level_encryption_content_type_profiles(&self) -> bool {
        matches!(&self.kind, CreateFieldLevelEncryptionConfigErrorKind::TooManyFieldLevelEncryptionContentTypeProfiles(_))
    }
    /// Returns `true` if the error kind is `CreateFieldLevelEncryptionConfigErrorKind::TooManyFieldLevelEncryptionQueryArgProfiles`.
    pub fn is_too_many_field_level_encryption_query_arg_profiles(&self) -> bool {
        matches!(
            &self.kind,
            CreateFieldLevelEncryptionConfigErrorKind::TooManyFieldLevelEncryptionQueryArgProfiles(
                _
            )
        )
    }
}
impl std::error::Error for CreateFieldLevelEncryptionConfigError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateFieldLevelEncryptionConfigErrorKind::FieldLevelEncryptionConfigAlreadyExists(_inner) =>
            Some(_inner)
            ,
            CreateFieldLevelEncryptionConfigErrorKind::InconsistentQuantities(_inner) =>
            Some(_inner)
            ,
            CreateFieldLevelEncryptionConfigErrorKind::InvalidArgument(_inner) =>
            Some(_inner)
            ,
            CreateFieldLevelEncryptionConfigErrorKind::NoSuchFieldLevelEncryptionProfile(_inner) =>
            Some(_inner)
            ,
            CreateFieldLevelEncryptionConfigErrorKind::QueryArgProfileEmpty(_inner) =>
            Some(_inner)
            ,
            CreateFieldLevelEncryptionConfigErrorKind::TooManyFieldLevelEncryptionConfigs(_inner) =>
            Some(_inner)
            ,
            CreateFieldLevelEncryptionConfigErrorKind::TooManyFieldLevelEncryptionContentTypeProfiles(_inner) =>
            Some(_inner)
            ,
            CreateFieldLevelEncryptionConfigErrorKind::TooManyFieldLevelEncryptionQueryArgProfiles(_inner) =>
            Some(_inner)
            ,
            CreateFieldLevelEncryptionConfigErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `CreateFieldLevelEncryptionProfile` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateFieldLevelEncryptionProfileError {
    /// Kind of error that occurred.
    pub kind: CreateFieldLevelEncryptionProfileErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateFieldLevelEncryptionProfile` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateFieldLevelEncryptionProfileErrorKind {
    /// <p>The specified profile for field-level encryption already exists.</p>
    FieldLevelEncryptionProfileAlreadyExists(
        crate::error::FieldLevelEncryptionProfileAlreadyExists,
    ),
    /// <p>The maximum size of a profile for field-level encryption was exceeded.</p>
    FieldLevelEncryptionProfileSizeExceeded(crate::error::FieldLevelEncryptionProfileSizeExceeded),
    /// <p>The value of <code>Quantity</code> and the size of <code>Items</code> don't match.</p>
    InconsistentQuantities(crate::error::InconsistentQuantities),
    /// <p>An argument is invalid.</p>
    InvalidArgument(crate::error::InvalidArgument),
    /// <p>The specified public key doesn't exist.</p>
    NoSuchPublicKey(crate::error::NoSuchPublicKey),
    /// <p>The maximum number of encryption entities for field-level encryption have been created.</p>
    TooManyFieldLevelEncryptionEncryptionEntities(
        crate::error::TooManyFieldLevelEncryptionEncryptionEntities,
    ),
    /// <p>The maximum number of field patterns for field-level encryption have been created.</p>
    TooManyFieldLevelEncryptionFieldPatterns(
        crate::error::TooManyFieldLevelEncryptionFieldPatterns,
    ),
    /// <p>The maximum number of profiles for field-level encryption have been created.</p>
    TooManyFieldLevelEncryptionProfiles(crate::error::TooManyFieldLevelEncryptionProfiles),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateFieldLevelEncryptionProfileError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateFieldLevelEncryptionProfileErrorKind::FieldLevelEncryptionProfileAlreadyExists(_inner) =>
            _inner.fmt(f)
            ,
            CreateFieldLevelEncryptionProfileErrorKind::FieldLevelEncryptionProfileSizeExceeded(_inner) =>
            _inner.fmt(f)
            ,
            CreateFieldLevelEncryptionProfileErrorKind::InconsistentQuantities(_inner) =>
            _inner.fmt(f)
            ,
            CreateFieldLevelEncryptionProfileErrorKind::InvalidArgument(_inner) =>
            _inner.fmt(f)
            ,
            CreateFieldLevelEncryptionProfileErrorKind::NoSuchPublicKey(_inner) =>
            _inner.fmt(f)
            ,
            CreateFieldLevelEncryptionProfileErrorKind::TooManyFieldLevelEncryptionEncryptionEntities(_inner) =>
            _inner.fmt(f)
            ,
            CreateFieldLevelEncryptionProfileErrorKind::TooManyFieldLevelEncryptionFieldPatterns(_inner) =>
            _inner.fmt(f)
            ,
            CreateFieldLevelEncryptionProfileErrorKind::TooManyFieldLevelEncryptionProfiles(_inner) =>
            _inner.fmt(f)
            ,
            CreateFieldLevelEncryptionProfileErrorKind::Unhandled(_inner) => {
                _inner.fmt(f)
            }
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateFieldLevelEncryptionProfileError {
    fn code(&self) -> Option<&str> {
        CreateFieldLevelEncryptionProfileError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateFieldLevelEncryptionProfileError {
    /// Creates a new `CreateFieldLevelEncryptionProfileError`.
    pub fn new(
        kind: CreateFieldLevelEncryptionProfileErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateFieldLevelEncryptionProfileError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateFieldLevelEncryptionProfileErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateFieldLevelEncryptionProfileError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateFieldLevelEncryptionProfileErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateFieldLevelEncryptionProfileErrorKind::FieldLevelEncryptionProfileAlreadyExists`.
    pub fn is_field_level_encryption_profile_already_exists(&self) -> bool {
        matches!(
            &self.kind,
            CreateFieldLevelEncryptionProfileErrorKind::FieldLevelEncryptionProfileAlreadyExists(_)
        )
    }
    /// Returns `true` if the error kind is `CreateFieldLevelEncryptionProfileErrorKind::FieldLevelEncryptionProfileSizeExceeded`.
    pub fn is_field_level_encryption_profile_size_exceeded(&self) -> bool {
        matches!(
            &self.kind,
            CreateFieldLevelEncryptionProfileErrorKind::FieldLevelEncryptionProfileSizeExceeded(_)
        )
    }
    /// Returns `true` if the error kind is `CreateFieldLevelEncryptionProfileErrorKind::InconsistentQuantities`.
    pub fn is_inconsistent_quantities(&self) -> bool {
        matches!(
            &self.kind,
            CreateFieldLevelEncryptionProfileErrorKind::InconsistentQuantities(_)
        )
    }
    /// Returns `true` if the error kind is `CreateFieldLevelEncryptionProfileErrorKind::InvalidArgument`.
    pub fn is_invalid_argument(&self) -> bool {
        matches!(
            &self.kind,
            CreateFieldLevelEncryptionProfileErrorKind::InvalidArgument(_)
        )
    }
    /// Returns `true` if the error kind is `CreateFieldLevelEncryptionProfileErrorKind::NoSuchPublicKey`.
    pub fn is_no_such_public_key(&self) -> bool {
        matches!(
            &self.kind,
            CreateFieldLevelEncryptionProfileErrorKind::NoSuchPublicKey(_)
        )
    }
    /// Returns `true` if the error kind is `CreateFieldLevelEncryptionProfileErrorKind::TooManyFieldLevelEncryptionEncryptionEntities`.
    pub fn is_too_many_field_level_encryption_encryption_entities(&self) -> bool {
        matches!(&self.kind, CreateFieldLevelEncryptionProfileErrorKind::TooManyFieldLevelEncryptionEncryptionEntities(_))
    }
    /// Returns `true` if the error kind is `CreateFieldLevelEncryptionProfileErrorKind::TooManyFieldLevelEncryptionFieldPatterns`.
    pub fn is_too_many_field_level_encryption_field_patterns(&self) -> bool {
        matches!(
            &self.kind,
            CreateFieldLevelEncryptionProfileErrorKind::TooManyFieldLevelEncryptionFieldPatterns(_)
        )
    }
    /// Returns `true` if the error kind is `CreateFieldLevelEncryptionProfileErrorKind::TooManyFieldLevelEncryptionProfiles`.
    pub fn is_too_many_field_level_encryption_profiles(&self) -> bool {
        matches!(
            &self.kind,
            CreateFieldLevelEncryptionProfileErrorKind::TooManyFieldLevelEncryptionProfiles(_)
        )
    }
}
impl std::error::Error for CreateFieldLevelEncryptionProfileError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateFieldLevelEncryptionProfileErrorKind::FieldLevelEncryptionProfileAlreadyExists(_inner) =>
            Some(_inner)
            ,
            CreateFieldLevelEncryptionProfileErrorKind::FieldLevelEncryptionProfileSizeExceeded(_inner) =>
            Some(_inner)
            ,
            CreateFieldLevelEncryptionProfileErrorKind::InconsistentQuantities(_inner) =>
            Some(_inner)
            ,
            CreateFieldLevelEncryptionProfileErrorKind::InvalidArgument(_inner) =>
            Some(_inner)
            ,
            CreateFieldLevelEncryptionProfileErrorKind::NoSuchPublicKey(_inner) =>
            Some(_inner)
            ,
            CreateFieldLevelEncryptionProfileErrorKind::TooManyFieldLevelEncryptionEncryptionEntities(_inner) =>
            Some(_inner)
            ,
            CreateFieldLevelEncryptionProfileErrorKind::TooManyFieldLevelEncryptionFieldPatterns(_inner) =>
            Some(_inner)
            ,
            CreateFieldLevelEncryptionProfileErrorKind::TooManyFieldLevelEncryptionProfiles(_inner) =>
            Some(_inner)
            ,
            CreateFieldLevelEncryptionProfileErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `CreateFunction` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateFunctionError {
    /// Kind of error that occurred.
    pub kind: CreateFunctionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateFunction` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateFunctionErrorKind {
    /// <p>A function with the same name already exists in this Amazon Web Services account. To create a function, you must provide a unique name. To update an existing function, use <code>UpdateFunction</code>.</p>
    FunctionAlreadyExists(crate::error::FunctionAlreadyExists),
    /// <p>The function is too large. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html">Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.</p>
    FunctionSizeLimitExceeded(crate::error::FunctionSizeLimitExceeded),
    /// <p>An argument is invalid.</p>
    InvalidArgument(crate::error::InvalidArgument),
    /// <p>You have reached the maximum number of CloudFront functions for this Amazon Web Services account. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html">Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.</p>
    TooManyFunctions(crate::error::TooManyFunctions),
    /// <p>This operation is not supported in this region.</p>
    UnsupportedOperation(crate::error::UnsupportedOperation),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateFunctionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateFunctionErrorKind::FunctionAlreadyExists(_inner) => _inner.fmt(f),
            CreateFunctionErrorKind::FunctionSizeLimitExceeded(_inner) => _inner.fmt(f),
            CreateFunctionErrorKind::InvalidArgument(_inner) => _inner.fmt(f),
            CreateFunctionErrorKind::TooManyFunctions(_inner) => _inner.fmt(f),
            CreateFunctionErrorKind::UnsupportedOperation(_inner) => _inner.fmt(f),
            CreateFunctionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateFunctionError {
    fn code(&self) -> Option<&str> {
        CreateFunctionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateFunctionError {
    /// Creates a new `CreateFunctionError`.
    pub fn new(kind: CreateFunctionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateFunctionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateFunctionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateFunctionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateFunctionErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateFunctionErrorKind::FunctionAlreadyExists`.
    pub fn is_function_already_exists(&self) -> bool {
        matches!(
            &self.kind,
            CreateFunctionErrorKind::FunctionAlreadyExists(_)
        )
    }
    /// Returns `true` if the error kind is `CreateFunctionErrorKind::FunctionSizeLimitExceeded`.
    pub fn is_function_size_limit_exceeded(&self) -> bool {
        matches!(
            &self.kind,
            CreateFunctionErrorKind::FunctionSizeLimitExceeded(_)
        )
    }
    /// Returns `true` if the error kind is `CreateFunctionErrorKind::InvalidArgument`.
    pub fn is_invalid_argument(&self) -> bool {
        matches!(&self.kind, CreateFunctionErrorKind::InvalidArgument(_))
    }
    /// Returns `true` if the error kind is `CreateFunctionErrorKind::TooManyFunctions`.
    pub fn is_too_many_functions(&self) -> bool {
        matches!(&self.kind, CreateFunctionErrorKind::TooManyFunctions(_))
    }
    /// Returns `true` if the error kind is `CreateFunctionErrorKind::UnsupportedOperation`.
    pub fn is_unsupported_operation(&self) -> bool {
        matches!(&self.kind, CreateFunctionErrorKind::UnsupportedOperation(_))
    }
}
impl std::error::Error for CreateFunctionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateFunctionErrorKind::FunctionAlreadyExists(_inner) => Some(_inner),
            CreateFunctionErrorKind::FunctionSizeLimitExceeded(_inner) => Some(_inner),
            CreateFunctionErrorKind::InvalidArgument(_inner) => Some(_inner),
            CreateFunctionErrorKind::TooManyFunctions(_inner) => Some(_inner),
            CreateFunctionErrorKind::UnsupportedOperation(_inner) => Some(_inner),
            CreateFunctionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateInvalidation` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateInvalidationError {
    /// Kind of error that occurred.
    pub kind: CreateInvalidationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateInvalidation` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateInvalidationErrorKind {
    /// <p>Access denied.</p>
    AccessDenied(crate::error::AccessDenied),
    /// <p>Invalidation batch specified is too large.</p>
    BatchTooLarge(crate::error::BatchTooLarge),
    /// <p>The value of <code>Quantity</code> and the size of <code>Items</code> don't match.</p>
    InconsistentQuantities(crate::error::InconsistentQuantities),
    /// <p>An argument is invalid.</p>
    InvalidArgument(crate::error::InvalidArgument),
    /// <p>This operation requires a body. Ensure that the body is present and the <code>Content-Type</code> header is set.</p>
    MissingBody(crate::error::MissingBody),
    /// <p>The specified distribution does not exist.</p>
    NoSuchDistribution(crate::error::NoSuchDistribution),
    /// <p>You have exceeded the maximum number of allowable InProgress invalidation batch requests, or invalidation objects.</p>
    TooManyInvalidationsInProgress(crate::error::TooManyInvalidationsInProgress),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateInvalidationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateInvalidationErrorKind::AccessDenied(_inner) => _inner.fmt(f),
            CreateInvalidationErrorKind::BatchTooLarge(_inner) => _inner.fmt(f),
            CreateInvalidationErrorKind::InconsistentQuantities(_inner) => _inner.fmt(f),
            CreateInvalidationErrorKind::InvalidArgument(_inner) => _inner.fmt(f),
            CreateInvalidationErrorKind::MissingBody(_inner) => _inner.fmt(f),
            CreateInvalidationErrorKind::NoSuchDistribution(_inner) => _inner.fmt(f),
            CreateInvalidationErrorKind::TooManyInvalidationsInProgress(_inner) => _inner.fmt(f),
            CreateInvalidationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateInvalidationError {
    fn code(&self) -> Option<&str> {
        CreateInvalidationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateInvalidationError {
    /// Creates a new `CreateInvalidationError`.
    pub fn new(kind: CreateInvalidationErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateInvalidationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateInvalidationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateInvalidationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateInvalidationErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateInvalidationErrorKind::AccessDenied`.
    pub fn is_access_denied(&self) -> bool {
        matches!(&self.kind, CreateInvalidationErrorKind::AccessDenied(_))
    }
    /// Returns `true` if the error kind is `CreateInvalidationErrorKind::BatchTooLarge`.
    pub fn is_batch_too_large(&self) -> bool {
        matches!(&self.kind, CreateInvalidationErrorKind::BatchTooLarge(_))
    }
    /// Returns `true` if the error kind is `CreateInvalidationErrorKind::InconsistentQuantities`.
    pub fn is_inconsistent_quantities(&self) -> bool {
        matches!(
            &self.kind,
            CreateInvalidationErrorKind::InconsistentQuantities(_)
        )
    }
    /// Returns `true` if the error kind is `CreateInvalidationErrorKind::InvalidArgument`.
    pub fn is_invalid_argument(&self) -> bool {
        matches!(&self.kind, CreateInvalidationErrorKind::InvalidArgument(_))
    }
    /// Returns `true` if the error kind is `CreateInvalidationErrorKind::MissingBody`.
    pub fn is_missing_body(&self) -> bool {
        matches!(&self.kind, CreateInvalidationErrorKind::MissingBody(_))
    }
    /// Returns `true` if the error kind is `CreateInvalidationErrorKind::NoSuchDistribution`.
    pub fn is_no_such_distribution(&self) -> bool {
        matches!(
            &self.kind,
            CreateInvalidationErrorKind::NoSuchDistribution(_)
        )
    }
    /// Returns `true` if the error kind is `CreateInvalidationErrorKind::TooManyInvalidationsInProgress`.
    pub fn is_too_many_invalidations_in_progress(&self) -> bool {
        matches!(
            &self.kind,
            CreateInvalidationErrorKind::TooManyInvalidationsInProgress(_)
        )
    }
}
impl std::error::Error for CreateInvalidationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateInvalidationErrorKind::AccessDenied(_inner) => Some(_inner),
            CreateInvalidationErrorKind::BatchTooLarge(_inner) => Some(_inner),
            CreateInvalidationErrorKind::InconsistentQuantities(_inner) => Some(_inner),
            CreateInvalidationErrorKind::InvalidArgument(_inner) => Some(_inner),
            CreateInvalidationErrorKind::MissingBody(_inner) => Some(_inner),
            CreateInvalidationErrorKind::NoSuchDistribution(_inner) => Some(_inner),
            CreateInvalidationErrorKind::TooManyInvalidationsInProgress(_inner) => Some(_inner),
            CreateInvalidationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateKeyGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateKeyGroupError {
    /// Kind of error that occurred.
    pub kind: CreateKeyGroupErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateKeyGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateKeyGroupErrorKind {
    /// <p>An argument is invalid.</p>
    InvalidArgument(crate::error::InvalidArgument),
    /// <p>A key group with this name already exists. You must provide a unique name. To modify an existing key group, use <code>UpdateKeyGroup</code>.</p>
    KeyGroupAlreadyExists(crate::error::KeyGroupAlreadyExists),
    /// <p>You have reached the maximum number of key groups for this Amazon Web Services account. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html">Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.</p>
    TooManyKeyGroups(crate::error::TooManyKeyGroups),
    /// <p>The number of public keys in this key group is more than the maximum allowed. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html">Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.</p>
    TooManyPublicKeysInKeyGroup(crate::error::TooManyPublicKeysInKeyGroup),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateKeyGroupError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateKeyGroupErrorKind::InvalidArgument(_inner) => _inner.fmt(f),
            CreateKeyGroupErrorKind::KeyGroupAlreadyExists(_inner) => _inner.fmt(f),
            CreateKeyGroupErrorKind::TooManyKeyGroups(_inner) => _inner.fmt(f),
            CreateKeyGroupErrorKind::TooManyPublicKeysInKeyGroup(_inner) => _inner.fmt(f),
            CreateKeyGroupErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateKeyGroupError {
    fn code(&self) -> Option<&str> {
        CreateKeyGroupError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateKeyGroupError {
    /// Creates a new `CreateKeyGroupError`.
    pub fn new(kind: CreateKeyGroupErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateKeyGroupError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateKeyGroupErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateKeyGroupError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateKeyGroupErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateKeyGroupErrorKind::InvalidArgument`.
    pub fn is_invalid_argument(&self) -> bool {
        matches!(&self.kind, CreateKeyGroupErrorKind::InvalidArgument(_))
    }
    /// Returns `true` if the error kind is `CreateKeyGroupErrorKind::KeyGroupAlreadyExists`.
    pub fn is_key_group_already_exists(&self) -> bool {
        matches!(
            &self.kind,
            CreateKeyGroupErrorKind::KeyGroupAlreadyExists(_)
        )
    }
    /// Returns `true` if the error kind is `CreateKeyGroupErrorKind::TooManyKeyGroups`.
    pub fn is_too_many_key_groups(&self) -> bool {
        matches!(&self.kind, CreateKeyGroupErrorKind::TooManyKeyGroups(_))
    }
    /// Returns `true` if the error kind is `CreateKeyGroupErrorKind::TooManyPublicKeysInKeyGroup`.
    pub fn is_too_many_public_keys_in_key_group(&self) -> bool {
        matches!(
            &self.kind,
            CreateKeyGroupErrorKind::TooManyPublicKeysInKeyGroup(_)
        )
    }
}
impl std::error::Error for CreateKeyGroupError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateKeyGroupErrorKind::InvalidArgument(_inner) => Some(_inner),
            CreateKeyGroupErrorKind::KeyGroupAlreadyExists(_inner) => Some(_inner),
            CreateKeyGroupErrorKind::TooManyKeyGroups(_inner) => Some(_inner),
            CreateKeyGroupErrorKind::TooManyPublicKeysInKeyGroup(_inner) => Some(_inner),
            CreateKeyGroupErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateMonitoringSubscription` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateMonitoringSubscriptionError {
    /// Kind of error that occurred.
    pub kind: CreateMonitoringSubscriptionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateMonitoringSubscription` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateMonitoringSubscriptionErrorKind {
    /// <p>Access denied.</p>
    AccessDenied(crate::error::AccessDenied),
    /// <p>The specified distribution does not exist.</p>
    NoSuchDistribution(crate::error::NoSuchDistribution),
    /// <p>This operation is not supported in this region.</p>
    UnsupportedOperation(crate::error::UnsupportedOperation),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateMonitoringSubscriptionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateMonitoringSubscriptionErrorKind::AccessDenied(_inner) => _inner.fmt(f),
            CreateMonitoringSubscriptionErrorKind::NoSuchDistribution(_inner) => _inner.fmt(f),
            CreateMonitoringSubscriptionErrorKind::UnsupportedOperation(_inner) => _inner.fmt(f),
            CreateMonitoringSubscriptionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateMonitoringSubscriptionError {
    fn code(&self) -> Option<&str> {
        CreateMonitoringSubscriptionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateMonitoringSubscriptionError {
    /// Creates a new `CreateMonitoringSubscriptionError`.
    pub fn new(kind: CreateMonitoringSubscriptionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateMonitoringSubscriptionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateMonitoringSubscriptionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateMonitoringSubscriptionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateMonitoringSubscriptionErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateMonitoringSubscriptionErrorKind::AccessDenied`.
    pub fn is_access_denied(&self) -> bool {
        matches!(
            &self.kind,
            CreateMonitoringSubscriptionErrorKind::AccessDenied(_)
        )
    }
    /// Returns `true` if the error kind is `CreateMonitoringSubscriptionErrorKind::NoSuchDistribution`.
    pub fn is_no_such_distribution(&self) -> bool {
        matches!(
            &self.kind,
            CreateMonitoringSubscriptionErrorKind::NoSuchDistribution(_)
        )
    }
    /// Returns `true` if the error kind is `CreateMonitoringSubscriptionErrorKind::UnsupportedOperation`.
    pub fn is_unsupported_operation(&self) -> bool {
        matches!(
            &self.kind,
            CreateMonitoringSubscriptionErrorKind::UnsupportedOperation(_)
        )
    }
}
impl std::error::Error for CreateMonitoringSubscriptionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateMonitoringSubscriptionErrorKind::AccessDenied(_inner) => Some(_inner),
            CreateMonitoringSubscriptionErrorKind::NoSuchDistribution(_inner) => Some(_inner),
            CreateMonitoringSubscriptionErrorKind::UnsupportedOperation(_inner) => Some(_inner),
            CreateMonitoringSubscriptionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateOriginRequestPolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateOriginRequestPolicyError {
    /// Kind of error that occurred.
    pub kind: CreateOriginRequestPolicyErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateOriginRequestPolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateOriginRequestPolicyErrorKind {
    /// <p>Access denied.</p>
    AccessDenied(crate::error::AccessDenied),
    /// <p>The value of <code>Quantity</code> and the size of <code>Items</code> don't match.</p>
    InconsistentQuantities(crate::error::InconsistentQuantities),
    /// <p>An argument is invalid.</p>
    InvalidArgument(crate::error::InvalidArgument),
    /// <p>An origin request policy with this name already exists. You must provide a unique name. To modify an existing origin request policy, use <code>UpdateOriginRequestPolicy</code>.</p>
    OriginRequestPolicyAlreadyExists(crate::error::OriginRequestPolicyAlreadyExists),
    /// <p>The number of cookies in the origin request policy exceeds the maximum. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html">Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.</p>
    TooManyCookiesInOriginRequestPolicy(crate::error::TooManyCookiesInOriginRequestPolicy),
    /// <p>The number of headers in the origin request policy exceeds the maximum. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html">Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.</p>
    TooManyHeadersInOriginRequestPolicy(crate::error::TooManyHeadersInOriginRequestPolicy),
    /// <p>You have reached the maximum number of origin request policies for this Amazon Web Services account. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html">Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.</p>
    TooManyOriginRequestPolicies(crate::error::TooManyOriginRequestPolicies),
    /// <p>The number of query strings in the origin request policy exceeds the maximum. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html">Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.</p>
    TooManyQueryStringsInOriginRequestPolicy(
        crate::error::TooManyQueryStringsInOriginRequestPolicy,
    ),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateOriginRequestPolicyError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateOriginRequestPolicyErrorKind::AccessDenied(_inner) => _inner.fmt(f),
            CreateOriginRequestPolicyErrorKind::InconsistentQuantities(_inner) => _inner.fmt(f),
            CreateOriginRequestPolicyErrorKind::InvalidArgument(_inner) => _inner.fmt(f),
            CreateOriginRequestPolicyErrorKind::OriginRequestPolicyAlreadyExists(_inner) => {
                _inner.fmt(f)
            }
            CreateOriginRequestPolicyErrorKind::TooManyCookiesInOriginRequestPolicy(_inner) => {
                _inner.fmt(f)
            }
            CreateOriginRequestPolicyErrorKind::TooManyHeadersInOriginRequestPolicy(_inner) => {
                _inner.fmt(f)
            }
            CreateOriginRequestPolicyErrorKind::TooManyOriginRequestPolicies(_inner) => {
                _inner.fmt(f)
            }
            CreateOriginRequestPolicyErrorKind::TooManyQueryStringsInOriginRequestPolicy(
                _inner,
            ) => _inner.fmt(f),
            CreateOriginRequestPolicyErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateOriginRequestPolicyError {
    fn code(&self) -> Option<&str> {
        CreateOriginRequestPolicyError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateOriginRequestPolicyError {
    /// Creates a new `CreateOriginRequestPolicyError`.
    pub fn new(kind: CreateOriginRequestPolicyErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateOriginRequestPolicyError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateOriginRequestPolicyErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateOriginRequestPolicyError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateOriginRequestPolicyErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateOriginRequestPolicyErrorKind::AccessDenied`.
    pub fn is_access_denied(&self) -> bool {
        matches!(
            &self.kind,
            CreateOriginRequestPolicyErrorKind::AccessDenied(_)
        )
    }
    /// Returns `true` if the error kind is `CreateOriginRequestPolicyErrorKind::InconsistentQuantities`.
    pub fn is_inconsistent_quantities(&self) -> bool {
        matches!(
            &self.kind,
            CreateOriginRequestPolicyErrorKind::InconsistentQuantities(_)
        )
    }
    /// Returns `true` if the error kind is `CreateOriginRequestPolicyErrorKind::InvalidArgument`.
    pub fn is_invalid_argument(&self) -> bool {
        matches!(
            &self.kind,
            CreateOriginRequestPolicyErrorKind::InvalidArgument(_)
        )
    }
    /// Returns `true` if the error kind is `CreateOriginRequestPolicyErrorKind::OriginRequestPolicyAlreadyExists`.
    pub fn is_origin_request_policy_already_exists(&self) -> bool {
        matches!(
            &self.kind,
            CreateOriginRequestPolicyErrorKind::OriginRequestPolicyAlreadyExists(_)
        )
    }
    /// Returns `true` if the error kind is `CreateOriginRequestPolicyErrorKind::TooManyCookiesInOriginRequestPolicy`.
    pub fn is_too_many_cookies_in_origin_request_policy(&self) -> bool {
        matches!(
            &self.kind,
            CreateOriginRequestPolicyErrorKind::TooManyCookiesInOriginRequestPolicy(_)
        )
    }
    /// Returns `true` if the error kind is `CreateOriginRequestPolicyErrorKind::TooManyHeadersInOriginRequestPolicy`.
    pub fn is_too_many_headers_in_origin_request_policy(&self) -> bool {
        matches!(
            &self.kind,
            CreateOriginRequestPolicyErrorKind::TooManyHeadersInOriginRequestPolicy(_)
        )
    }
    /// Returns `true` if the error kind is `CreateOriginRequestPolicyErrorKind::TooManyOriginRequestPolicies`.
    pub fn is_too_many_origin_request_policies(&self) -> bool {
        matches!(
            &self.kind,
            CreateOriginRequestPolicyErrorKind::TooManyOriginRequestPolicies(_)
        )
    }
    /// Returns `true` if the error kind is `CreateOriginRequestPolicyErrorKind::TooManyQueryStringsInOriginRequestPolicy`.
    pub fn is_too_many_query_strings_in_origin_request_policy(&self) -> bool {
        matches!(
            &self.kind,
            CreateOriginRequestPolicyErrorKind::TooManyQueryStringsInOriginRequestPolicy(_)
        )
    }
}
impl std::error::Error for CreateOriginRequestPolicyError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateOriginRequestPolicyErrorKind::AccessDenied(_inner) => Some(_inner),
            CreateOriginRequestPolicyErrorKind::InconsistentQuantities(_inner) => Some(_inner),
            CreateOriginRequestPolicyErrorKind::InvalidArgument(_inner) => Some(_inner),
            CreateOriginRequestPolicyErrorKind::OriginRequestPolicyAlreadyExists(_inner) => {
                Some(_inner)
            }
            CreateOriginRequestPolicyErrorKind::TooManyCookiesInOriginRequestPolicy(_inner) => {
                Some(_inner)
            }
            CreateOriginRequestPolicyErrorKind::TooManyHeadersInOriginRequestPolicy(_inner) => {
                Some(_inner)
            }
            CreateOriginRequestPolicyErrorKind::TooManyOriginRequestPolicies(_inner) => {
                Some(_inner)
            }
            CreateOriginRequestPolicyErrorKind::TooManyQueryStringsInOriginRequestPolicy(
                _inner,
            ) => Some(_inner),
            CreateOriginRequestPolicyErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreatePublicKey` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreatePublicKeyError {
    /// Kind of error that occurred.
    pub kind: CreatePublicKeyErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreatePublicKey` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreatePublicKeyErrorKind {
    /// <p>An argument is invalid.</p>
    InvalidArgument(crate::error::InvalidArgument),
    /// <p>The specified public key already exists.</p>
    PublicKeyAlreadyExists(crate::error::PublicKeyAlreadyExists),
    /// <p>The maximum number of public keys for field-level encryption have been created. To create a new public key, delete one of the existing keys.</p>
    TooManyPublicKeys(crate::error::TooManyPublicKeys),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreatePublicKeyError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreatePublicKeyErrorKind::InvalidArgument(_inner) => _inner.fmt(f),
            CreatePublicKeyErrorKind::PublicKeyAlreadyExists(_inner) => _inner.fmt(f),
            CreatePublicKeyErrorKind::TooManyPublicKeys(_inner) => _inner.fmt(f),
            CreatePublicKeyErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreatePublicKeyError {
    fn code(&self) -> Option<&str> {
        CreatePublicKeyError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreatePublicKeyError {
    /// Creates a new `CreatePublicKeyError`.
    pub fn new(kind: CreatePublicKeyErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreatePublicKeyError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreatePublicKeyErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreatePublicKeyError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreatePublicKeyErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreatePublicKeyErrorKind::InvalidArgument`.
    pub fn is_invalid_argument(&self) -> bool {
        matches!(&self.kind, CreatePublicKeyErrorKind::InvalidArgument(_))
    }
    /// Returns `true` if the error kind is `CreatePublicKeyErrorKind::PublicKeyAlreadyExists`.
    pub fn is_public_key_already_exists(&self) -> bool {
        matches!(
            &self.kind,
            CreatePublicKeyErrorKind::PublicKeyAlreadyExists(_)
        )
    }
    /// Returns `true` if the error kind is `CreatePublicKeyErrorKind::TooManyPublicKeys`.
    pub fn is_too_many_public_keys(&self) -> bool {
        matches!(&self.kind, CreatePublicKeyErrorKind::TooManyPublicKeys(_))
    }
}
impl std::error::Error for CreatePublicKeyError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreatePublicKeyErrorKind::InvalidArgument(_inner) => Some(_inner),
            CreatePublicKeyErrorKind::PublicKeyAlreadyExists(_inner) => Some(_inner),
            CreatePublicKeyErrorKind::TooManyPublicKeys(_inner) => Some(_inner),
            CreatePublicKeyErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateRealtimeLogConfig` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateRealtimeLogConfigError {
    /// Kind of error that occurred.
    pub kind: CreateRealtimeLogConfigErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateRealtimeLogConfig` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateRealtimeLogConfigErrorKind {
    /// <p>Access denied.</p>
    AccessDenied(crate::error::AccessDenied),
    /// <p>An argument is invalid.</p>
    InvalidArgument(crate::error::InvalidArgument),
    /// <p>A real-time log configuration with this name already exists. You must provide a unique name. To modify an existing real-time log configuration, use <code>UpdateRealtimeLogConfig</code>.</p>
    RealtimeLogConfigAlreadyExists(crate::error::RealtimeLogConfigAlreadyExists),
    /// <p>You have reached the maximum number of real-time log configurations for this Amazon Web Services account. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html">Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.</p>
    TooManyRealtimeLogConfigs(crate::error::TooManyRealtimeLogConfigs),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateRealtimeLogConfigError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateRealtimeLogConfigErrorKind::AccessDenied(_inner) => _inner.fmt(f),
            CreateRealtimeLogConfigErrorKind::InvalidArgument(_inner) => _inner.fmt(f),
            CreateRealtimeLogConfigErrorKind::RealtimeLogConfigAlreadyExists(_inner) => {
                _inner.fmt(f)
            }
            CreateRealtimeLogConfigErrorKind::TooManyRealtimeLogConfigs(_inner) => _inner.fmt(f),
            CreateRealtimeLogConfigErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateRealtimeLogConfigError {
    fn code(&self) -> Option<&str> {
        CreateRealtimeLogConfigError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateRealtimeLogConfigError {
    /// Creates a new `CreateRealtimeLogConfigError`.
    pub fn new(kind: CreateRealtimeLogConfigErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateRealtimeLogConfigError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateRealtimeLogConfigErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateRealtimeLogConfigError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateRealtimeLogConfigErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateRealtimeLogConfigErrorKind::AccessDenied`.
    pub fn is_access_denied(&self) -> bool {
        matches!(
            &self.kind,
            CreateRealtimeLogConfigErrorKind::AccessDenied(_)
        )
    }
    /// Returns `true` if the error kind is `CreateRealtimeLogConfigErrorKind::InvalidArgument`.
    pub fn is_invalid_argument(&self) -> bool {
        matches!(
            &self.kind,
            CreateRealtimeLogConfigErrorKind::InvalidArgument(_)
        )
    }
    /// Returns `true` if the error kind is `CreateRealtimeLogConfigErrorKind::RealtimeLogConfigAlreadyExists`.
    pub fn is_realtime_log_config_already_exists(&self) -> bool {
        matches!(
            &self.kind,
            CreateRealtimeLogConfigErrorKind::RealtimeLogConfigAlreadyExists(_)
        )
    }
    /// Returns `true` if the error kind is `CreateRealtimeLogConfigErrorKind::TooManyRealtimeLogConfigs`.
    pub fn is_too_many_realtime_log_configs(&self) -> bool {
        matches!(
            &self.kind,
            CreateRealtimeLogConfigErrorKind::TooManyRealtimeLogConfigs(_)
        )
    }
}
impl std::error::Error for CreateRealtimeLogConfigError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateRealtimeLogConfigErrorKind::AccessDenied(_inner) => Some(_inner),
            CreateRealtimeLogConfigErrorKind::InvalidArgument(_inner) => Some(_inner),
            CreateRealtimeLogConfigErrorKind::RealtimeLogConfigAlreadyExists(_inner) => {
                Some(_inner)
            }
            CreateRealtimeLogConfigErrorKind::TooManyRealtimeLogConfigs(_inner) => Some(_inner),
            CreateRealtimeLogConfigErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateResponseHeadersPolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateResponseHeadersPolicyError {
    /// Kind of error that occurred.
    pub kind: CreateResponseHeadersPolicyErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateResponseHeadersPolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateResponseHeadersPolicyErrorKind {
    /// <p>Access denied.</p>
    AccessDenied(crate::error::AccessDenied),
    /// <p>The value of <code>Quantity</code> and the size of <code>Items</code> don't match.</p>
    InconsistentQuantities(crate::error::InconsistentQuantities),
    /// <p>An argument is invalid.</p>
    InvalidArgument(crate::error::InvalidArgument),
    /// <p>A response headers policy with this name already exists. You must provide a unique name. To modify an existing response headers policy, use <code>UpdateResponseHeadersPolicy</code>.</p>
    ResponseHeadersPolicyAlreadyExists(crate::error::ResponseHeadersPolicyAlreadyExists),
    /// <p>The number of custom headers in the response headers policy exceeds the maximum.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html">Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.</p>
    TooManyCustomHeadersInResponseHeadersPolicy(
        crate::error::TooManyCustomHeadersInResponseHeadersPolicy,
    ),
    /// <p>You have reached the maximum number of response headers policies for this Amazon Web Services account.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html">Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.</p>
    TooManyResponseHeadersPolicies(crate::error::TooManyResponseHeadersPolicies),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateResponseHeadersPolicyError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateResponseHeadersPolicyErrorKind::AccessDenied(_inner) => _inner.fmt(f),
            CreateResponseHeadersPolicyErrorKind::InconsistentQuantities(_inner) => _inner.fmt(f),
            CreateResponseHeadersPolicyErrorKind::InvalidArgument(_inner) => _inner.fmt(f),
            CreateResponseHeadersPolicyErrorKind::ResponseHeadersPolicyAlreadyExists(_inner) => {
                _inner.fmt(f)
            }
            CreateResponseHeadersPolicyErrorKind::TooManyCustomHeadersInResponseHeadersPolicy(
                _inner,
            ) => _inner.fmt(f),
            CreateResponseHeadersPolicyErrorKind::TooManyResponseHeadersPolicies(_inner) => {
                _inner.fmt(f)
            }
            CreateResponseHeadersPolicyErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateResponseHeadersPolicyError {
    fn code(&self) -> Option<&str> {
        CreateResponseHeadersPolicyError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateResponseHeadersPolicyError {
    /// Creates a new `CreateResponseHeadersPolicyError`.
    pub fn new(kind: CreateResponseHeadersPolicyErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateResponseHeadersPolicyError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateResponseHeadersPolicyErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateResponseHeadersPolicyError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateResponseHeadersPolicyErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateResponseHeadersPolicyErrorKind::AccessDenied`.
    pub fn is_access_denied(&self) -> bool {
        matches!(
            &self.kind,
            CreateResponseHeadersPolicyErrorKind::AccessDenied(_)
        )
    }
    /// Returns `true` if the error kind is `CreateResponseHeadersPolicyErrorKind::InconsistentQuantities`.
    pub fn is_inconsistent_quantities(&self) -> bool {
        matches!(
            &self.kind,
            CreateResponseHeadersPolicyErrorKind::InconsistentQuantities(_)
        )
    }
    /// Returns `true` if the error kind is `CreateResponseHeadersPolicyErrorKind::InvalidArgument`.
    pub fn is_invalid_argument(&self) -> bool {
        matches!(
            &self.kind,
            CreateResponseHeadersPolicyErrorKind::InvalidArgument(_)
        )
    }
    /// Returns `true` if the error kind is `CreateResponseHeadersPolicyErrorKind::ResponseHeadersPolicyAlreadyExists`.
    pub fn is_response_headers_policy_already_exists(&self) -> bool {
        matches!(
            &self.kind,
            CreateResponseHeadersPolicyErrorKind::ResponseHeadersPolicyAlreadyExists(_)
        )
    }
    /// Returns `true` if the error kind is `CreateResponseHeadersPolicyErrorKind::TooManyCustomHeadersInResponseHeadersPolicy`.
    pub fn is_too_many_custom_headers_in_response_headers_policy(&self) -> bool {
        matches!(
            &self.kind,
            CreateResponseHeadersPolicyErrorKind::TooManyCustomHeadersInResponseHeadersPolicy(_)
        )
    }
    /// Returns `true` if the error kind is `CreateResponseHeadersPolicyErrorKind::TooManyResponseHeadersPolicies`.
    pub fn is_too_many_response_headers_policies(&self) -> bool {
        matches!(
            &self.kind,
            CreateResponseHeadersPolicyErrorKind::TooManyResponseHeadersPolicies(_)
        )
    }
}
impl std::error::Error for CreateResponseHeadersPolicyError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateResponseHeadersPolicyErrorKind::AccessDenied(_inner) => Some(_inner),
            CreateResponseHeadersPolicyErrorKind::InconsistentQuantities(_inner) => Some(_inner),
            CreateResponseHeadersPolicyErrorKind::InvalidArgument(_inner) => Some(_inner),
            CreateResponseHeadersPolicyErrorKind::ResponseHeadersPolicyAlreadyExists(_inner) => {
                Some(_inner)
            }
            CreateResponseHeadersPolicyErrorKind::TooManyCustomHeadersInResponseHeadersPolicy(
                _inner,
            ) => Some(_inner),
            CreateResponseHeadersPolicyErrorKind::TooManyResponseHeadersPolicies(_inner) => {
                Some(_inner)
            }
            CreateResponseHeadersPolicyErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateStreamingDistribution` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateStreamingDistributionError {
    /// Kind of error that occurred.
    pub kind: CreateStreamingDistributionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateStreamingDistribution` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateStreamingDistributionErrorKind {
    /// <p>Access denied.</p>
    AccessDenied(crate::error::AccessDenied),
    /// <p>The CNAME specified is already defined for CloudFront.</p>
    CnameAlreadyExists(crate::error::CnameAlreadyExists),
    /// <p>The value of <code>Quantity</code> and the size of <code>Items</code> don't match.</p>
    InconsistentQuantities(crate::error::InconsistentQuantities),
    /// <p>An argument is invalid.</p>
    InvalidArgument(crate::error::InvalidArgument),
    /// <p>The Amazon S3 origin server specified does not refer to a valid Amazon S3 bucket.</p>
    InvalidOrigin(crate::error::InvalidOrigin),
    /// <p>The origin access identity is not valid or doesn't exist.</p>
    InvalidOriginAccessIdentity(crate::error::InvalidOriginAccessIdentity),
    /// <p>This operation requires a body. Ensure that the body is present and the <code>Content-Type</code> header is set.</p>
    MissingBody(crate::error::MissingBody),
    /// <p>The caller reference you attempted to create the streaming distribution with is associated with another distribution</p>
    StreamingDistributionAlreadyExists(crate::error::StreamingDistributionAlreadyExists),
    /// <p>Your request contains more CNAMEs than are allowed per distribution.</p>
    TooManyStreamingDistributionCnamEs(crate::error::TooManyStreamingDistributionCnamEs),
    /// <p>Processing your request would cause you to exceed the maximum number of streaming distributions allowed.</p>
    TooManyStreamingDistributions(crate::error::TooManyStreamingDistributions),
    /// <p>Your request contains more trusted signers than are allowed per distribution.</p>
    TooManyTrustedSigners(crate::error::TooManyTrustedSigners),
    /// <p>One or more of your trusted signers don't exist.</p>
    TrustedSignerDoesNotExist(crate::error::TrustedSignerDoesNotExist),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateStreamingDistributionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateStreamingDistributionErrorKind::AccessDenied(_inner) => _inner.fmt(f),
            CreateStreamingDistributionErrorKind::CnameAlreadyExists(_inner) => _inner.fmt(f),
            CreateStreamingDistributionErrorKind::InconsistentQuantities(_inner) => _inner.fmt(f),
            CreateStreamingDistributionErrorKind::InvalidArgument(_inner) => _inner.fmt(f),
            CreateStreamingDistributionErrorKind::InvalidOrigin(_inner) => _inner.fmt(f),
            CreateStreamingDistributionErrorKind::InvalidOriginAccessIdentity(_inner) => {
                _inner.fmt(f)
            }
            CreateStreamingDistributionErrorKind::MissingBody(_inner) => _inner.fmt(f),
            CreateStreamingDistributionErrorKind::StreamingDistributionAlreadyExists(_inner) => {
                _inner.fmt(f)
            }
            CreateStreamingDistributionErrorKind::TooManyStreamingDistributionCnamEs(_inner) => {
                _inner.fmt(f)
            }
            CreateStreamingDistributionErrorKind::TooManyStreamingDistributions(_inner) => {
                _inner.fmt(f)
            }
            CreateStreamingDistributionErrorKind::TooManyTrustedSigners(_inner) => _inner.fmt(f),
            CreateStreamingDistributionErrorKind::TrustedSignerDoesNotExist(_inner) => {
                _inner.fmt(f)
            }
            CreateStreamingDistributionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateStreamingDistributionError {
    fn code(&self) -> Option<&str> {
        CreateStreamingDistributionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateStreamingDistributionError {
    /// Creates a new `CreateStreamingDistributionError`.
    pub fn new(kind: CreateStreamingDistributionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateStreamingDistributionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateStreamingDistributionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateStreamingDistributionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateStreamingDistributionErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateStreamingDistributionErrorKind::AccessDenied`.
    pub fn is_access_denied(&self) -> bool {
        matches!(
            &self.kind,
            CreateStreamingDistributionErrorKind::AccessDenied(_)
        )
    }
    /// Returns `true` if the error kind is `CreateStreamingDistributionErrorKind::CnameAlreadyExists`.
    pub fn is_cname_already_exists(&self) -> bool {
        matches!(
            &self.kind,
            CreateStreamingDistributionErrorKind::CnameAlreadyExists(_)
        )
    }
    /// Returns `true` if the error kind is `CreateStreamingDistributionErrorKind::InconsistentQuantities`.
    pub fn is_inconsistent_quantities(&self) -> bool {
        matches!(
            &self.kind,
            CreateStreamingDistributionErrorKind::InconsistentQuantities(_)
        )
    }
    /// Returns `true` if the error kind is `CreateStreamingDistributionErrorKind::InvalidArgument`.
    pub fn is_invalid_argument(&self) -> bool {
        matches!(
            &self.kind,
            CreateStreamingDistributionErrorKind::InvalidArgument(_)
        )
    }
    /// Returns `true` if the error kind is `CreateStreamingDistributionErrorKind::InvalidOrigin`.
    pub fn is_invalid_origin(&self) -> bool {
        matches!(
            &self.kind,
            CreateStreamingDistributionErrorKind::InvalidOrigin(_)
        )
    }
    /// Returns `true` if the error kind is `CreateStreamingDistributionErrorKind::InvalidOriginAccessIdentity`.
    pub fn is_invalid_origin_access_identity(&self) -> bool {
        matches!(
            &self.kind,
            CreateStreamingDistributionErrorKind::InvalidOriginAccessIdentity(_)
        )
    }
    /// Returns `true` if the error kind is `CreateStreamingDistributionErrorKind::MissingBody`.
    pub fn is_missing_body(&self) -> bool {
        matches!(
            &self.kind,
            CreateStreamingDistributionErrorKind::MissingBody(_)
        )
    }
    /// Returns `true` if the error kind is `CreateStreamingDistributionErrorKind::StreamingDistributionAlreadyExists`.
    pub fn is_streaming_distribution_already_exists(&self) -> bool {
        matches!(
            &self.kind,
            CreateStreamingDistributionErrorKind::StreamingDistributionAlreadyExists(_)
        )
    }
    /// Returns `true` if the error kind is `CreateStreamingDistributionErrorKind::TooManyStreamingDistributionCnamEs`.
    pub fn is_too_many_streaming_distribution_cnam_es(&self) -> bool {
        matches!(
            &self.kind,
            CreateStreamingDistributionErrorKind::TooManyStreamingDistributionCnamEs(_)
        )
    }
    /// Returns `true` if the error kind is `CreateStreamingDistributionErrorKind::TooManyStreamingDistributions`.
    pub fn is_too_many_streaming_distributions(&self) -> bool {
        matches!(
            &self.kind,
            CreateStreamingDistributionErrorKind::TooManyStreamingDistributions(_)
        )
    }
    /// Returns `true` if the error kind is `CreateStreamingDistributionErrorKind::TooManyTrustedSigners`.
    pub fn is_too_many_trusted_signers(&self) -> bool {
        matches!(
            &self.kind,
            CreateStreamingDistributionErrorKind::TooManyTrustedSigners(_)
        )
    }
    /// Returns `true` if the error kind is `CreateStreamingDistributionErrorKind::TrustedSignerDoesNotExist`.
    pub fn is_trusted_signer_does_not_exist(&self) -> bool {
        matches!(
            &self.kind,
            CreateStreamingDistributionErrorKind::TrustedSignerDoesNotExist(_)
        )
    }
}
impl std::error::Error for CreateStreamingDistributionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateStreamingDistributionErrorKind::AccessDenied(_inner) => Some(_inner),
            CreateStreamingDistributionErrorKind::CnameAlreadyExists(_inner) => Some(_inner),
            CreateStreamingDistributionErrorKind::InconsistentQuantities(_inner) => Some(_inner),
            CreateStreamingDistributionErrorKind::InvalidArgument(_inner) => Some(_inner),
            CreateStreamingDistributionErrorKind::InvalidOrigin(_inner) => Some(_inner),
            CreateStreamingDistributionErrorKind::InvalidOriginAccessIdentity(_inner) => {
                Some(_inner)
            }
            CreateStreamingDistributionErrorKind::MissingBody(_inner) => Some(_inner),
            CreateStreamingDistributionErrorKind::StreamingDistributionAlreadyExists(_inner) => {
                Some(_inner)
            }
            CreateStreamingDistributionErrorKind::TooManyStreamingDistributionCnamEs(_inner) => {
                Some(_inner)
            }
            CreateStreamingDistributionErrorKind::TooManyStreamingDistributions(_inner) => {
                Some(_inner)
            }
            CreateStreamingDistributionErrorKind::TooManyTrustedSigners(_inner) => Some(_inner),
            CreateStreamingDistributionErrorKind::TrustedSignerDoesNotExist(_inner) => Some(_inner),
            CreateStreamingDistributionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateStreamingDistributionWithTags` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateStreamingDistributionWithTagsError {
    /// Kind of error that occurred.
    pub kind: CreateStreamingDistributionWithTagsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateStreamingDistributionWithTags` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateStreamingDistributionWithTagsErrorKind {
    /// <p>Access denied.</p>
    AccessDenied(crate::error::AccessDenied),
    /// <p>The CNAME specified is already defined for CloudFront.</p>
    CnameAlreadyExists(crate::error::CnameAlreadyExists),
    /// <p>The value of <code>Quantity</code> and the size of <code>Items</code> don't match.</p>
    InconsistentQuantities(crate::error::InconsistentQuantities),
    /// <p>An argument is invalid.</p>
    InvalidArgument(crate::error::InvalidArgument),
    /// <p>The Amazon S3 origin server specified does not refer to a valid Amazon S3 bucket.</p>
    InvalidOrigin(crate::error::InvalidOrigin),
    /// <p>The origin access identity is not valid or doesn't exist.</p>
    InvalidOriginAccessIdentity(crate::error::InvalidOriginAccessIdentity),
    /// <p>The tagging specified is not valid.</p>
    InvalidTagging(crate::error::InvalidTagging),
    /// <p>This operation requires a body. Ensure that the body is present and the <code>Content-Type</code> header is set.</p>
    MissingBody(crate::error::MissingBody),
    /// <p>The caller reference you attempted to create the streaming distribution with is associated with another distribution</p>
    StreamingDistributionAlreadyExists(crate::error::StreamingDistributionAlreadyExists),
    /// <p>Your request contains more CNAMEs than are allowed per distribution.</p>
    TooManyStreamingDistributionCnamEs(crate::error::TooManyStreamingDistributionCnamEs),
    /// <p>Processing your request would cause you to exceed the maximum number of streaming distributions allowed.</p>
    TooManyStreamingDistributions(crate::error::TooManyStreamingDistributions),
    /// <p>Your request contains more trusted signers than are allowed per distribution.</p>
    TooManyTrustedSigners(crate::error::TooManyTrustedSigners),
    /// <p>One or more of your trusted signers don't exist.</p>
    TrustedSignerDoesNotExist(crate::error::TrustedSignerDoesNotExist),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateStreamingDistributionWithTagsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateStreamingDistributionWithTagsErrorKind::AccessDenied(_inner) => _inner.fmt(f),
            CreateStreamingDistributionWithTagsErrorKind::CnameAlreadyExists(_inner) => {
                _inner.fmt(f)
            }
            CreateStreamingDistributionWithTagsErrorKind::InconsistentQuantities(_inner) => {
                _inner.fmt(f)
            }
            CreateStreamingDistributionWithTagsErrorKind::InvalidArgument(_inner) => _inner.fmt(f),
            CreateStreamingDistributionWithTagsErrorKind::InvalidOrigin(_inner) => _inner.fmt(f),
            CreateStreamingDistributionWithTagsErrorKind::InvalidOriginAccessIdentity(_inner) => {
                _inner.fmt(f)
            }
            CreateStreamingDistributionWithTagsErrorKind::InvalidTagging(_inner) => _inner.fmt(f),
            CreateStreamingDistributionWithTagsErrorKind::MissingBody(_inner) => _inner.fmt(f),
            CreateStreamingDistributionWithTagsErrorKind::StreamingDistributionAlreadyExists(
                _inner,
            ) => _inner.fmt(f),
            CreateStreamingDistributionWithTagsErrorKind::TooManyStreamingDistributionCnamEs(
                _inner,
            ) => _inner.fmt(f),
            CreateStreamingDistributionWithTagsErrorKind::TooManyStreamingDistributions(_inner) => {
                _inner.fmt(f)
            }
            CreateStreamingDistributionWithTagsErrorKind::TooManyTrustedSigners(_inner) => {
                _inner.fmt(f)
            }
            CreateStreamingDistributionWithTagsErrorKind::TrustedSignerDoesNotExist(_inner) => {
                _inner.fmt(f)
            }
            CreateStreamingDistributionWithTagsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateStreamingDistributionWithTagsError {
    fn code(&self) -> Option<&str> {
        CreateStreamingDistributionWithTagsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateStreamingDistributionWithTagsError {
    /// Creates a new `CreateStreamingDistributionWithTagsError`.
    pub fn new(
        kind: CreateStreamingDistributionWithTagsErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateStreamingDistributionWithTagsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateStreamingDistributionWithTagsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateStreamingDistributionWithTagsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateStreamingDistributionWithTagsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateStreamingDistributionWithTagsErrorKind::AccessDenied`.
    pub fn is_access_denied(&self) -> bool {
        matches!(
            &self.kind,
            CreateStreamingDistributionWithTagsErrorKind::AccessDenied(_)
        )
    }
    /// Returns `true` if the error kind is `CreateStreamingDistributionWithTagsErrorKind::CnameAlreadyExists`.
    pub fn is_cname_already_exists(&self) -> bool {
        matches!(
            &self.kind,
            CreateStreamingDistributionWithTagsErrorKind::CnameAlreadyExists(_)
        )
    }
    /// Returns `true` if the error kind is `CreateStreamingDistributionWithTagsErrorKind::InconsistentQuantities`.
    pub fn is_inconsistent_quantities(&self) -> bool {
        matches!(
            &self.kind,
            CreateStreamingDistributionWithTagsErrorKind::InconsistentQuantities(_)
        )
    }
    /// Returns `true` if the error kind is `CreateStreamingDistributionWithTagsErrorKind::InvalidArgument`.
    pub fn is_invalid_argument(&self) -> bool {
        matches!(
            &self.kind,
            CreateStreamingDistributionWithTagsErrorKind::InvalidArgument(_)
        )
    }
    /// Returns `true` if the error kind is `CreateStreamingDistributionWithTagsErrorKind::InvalidOrigin`.
    pub fn is_invalid_origin(&self) -> bool {
        matches!(
            &self.kind,
            CreateStreamingDistributionWithTagsErrorKind::InvalidOrigin(_)
        )
    }
    /// Returns `true` if the error kind is `CreateStreamingDistributionWithTagsErrorKind::InvalidOriginAccessIdentity`.
    pub fn is_invalid_origin_access_identity(&self) -> bool {
        matches!(
            &self.kind,
            CreateStreamingDistributionWithTagsErrorKind::InvalidOriginAccessIdentity(_)
        )
    }
    /// Returns `true` if the error kind is `CreateStreamingDistributionWithTagsErrorKind::InvalidTagging`.
    pub fn is_invalid_tagging(&self) -> bool {
        matches!(
            &self.kind,
            CreateStreamingDistributionWithTagsErrorKind::InvalidTagging(_)
        )
    }
    /// Returns `true` if the error kind is `CreateStreamingDistributionWithTagsErrorKind::MissingBody`.
    pub fn is_missing_body(&self) -> bool {
        matches!(
            &self.kind,
            CreateStreamingDistributionWithTagsErrorKind::MissingBody(_)
        )
    }
    /// Returns `true` if the error kind is `CreateStreamingDistributionWithTagsErrorKind::StreamingDistributionAlreadyExists`.
    pub fn is_streaming_distribution_already_exists(&self) -> bool {
        matches!(
            &self.kind,
            CreateStreamingDistributionWithTagsErrorKind::StreamingDistributionAlreadyExists(_)
        )
    }
    /// Returns `true` if the error kind is `CreateStreamingDistributionWithTagsErrorKind::TooManyStreamingDistributionCnamEs`.
    pub fn is_too_many_streaming_distribution_cnam_es(&self) -> bool {
        matches!(
            &self.kind,
            CreateStreamingDistributionWithTagsErrorKind::TooManyStreamingDistributionCnamEs(_)
        )
    }
    /// Returns `true` if the error kind is `CreateStreamingDistributionWithTagsErrorKind::TooManyStreamingDistributions`.
    pub fn is_too_many_streaming_distributions(&self) -> bool {
        matches!(
            &self.kind,
            CreateStreamingDistributionWithTagsErrorKind::TooManyStreamingDistributions(_)
        )
    }
    /// Returns `true` if the error kind is `CreateStreamingDistributionWithTagsErrorKind::TooManyTrustedSigners`.
    pub fn is_too_many_trusted_signers(&self) -> bool {
        matches!(
            &self.kind,
            CreateStreamingDistributionWithTagsErrorKind::TooManyTrustedSigners(_)
        )
    }
    /// Returns `true` if the error kind is `CreateStreamingDistributionWithTagsErrorKind::TrustedSignerDoesNotExist`.
    pub fn is_trusted_signer_does_not_exist(&self) -> bool {
        matches!(
            &self.kind,
            CreateStreamingDistributionWithTagsErrorKind::TrustedSignerDoesNotExist(_)
        )
    }
}
impl std::error::Error for CreateStreamingDistributionWithTagsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateStreamingDistributionWithTagsErrorKind::AccessDenied(_inner) => Some(_inner),
            CreateStreamingDistributionWithTagsErrorKind::CnameAlreadyExists(_inner) => {
                Some(_inner)
            }
            CreateStreamingDistributionWithTagsErrorKind::InconsistentQuantities(_inner) => {
                Some(_inner)
            }
            CreateStreamingDistributionWithTagsErrorKind::InvalidArgument(_inner) => Some(_inner),
            CreateStreamingDistributionWithTagsErrorKind::InvalidOrigin(_inner) => Some(_inner),
            CreateStreamingDistributionWithTagsErrorKind::InvalidOriginAccessIdentity(_inner) => {
                Some(_inner)
            }
            CreateStreamingDistributionWithTagsErrorKind::InvalidTagging(_inner) => Some(_inner),
            CreateStreamingDistributionWithTagsErrorKind::MissingBody(_inner) => Some(_inner),
            CreateStreamingDistributionWithTagsErrorKind::StreamingDistributionAlreadyExists(
                _inner,
            ) => Some(_inner),
            CreateStreamingDistributionWithTagsErrorKind::TooManyStreamingDistributionCnamEs(
                _inner,
            ) => Some(_inner),
            CreateStreamingDistributionWithTagsErrorKind::TooManyStreamingDistributions(_inner) => {
                Some(_inner)
            }
            CreateStreamingDistributionWithTagsErrorKind::TooManyTrustedSigners(_inner) => {
                Some(_inner)
            }
            CreateStreamingDistributionWithTagsErrorKind::TrustedSignerDoesNotExist(_inner) => {
                Some(_inner)
            }
            CreateStreamingDistributionWithTagsErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `DeleteCachePolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteCachePolicyError {
    /// Kind of error that occurred.
    pub kind: DeleteCachePolicyErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteCachePolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteCachePolicyErrorKind {
    /// <p>Access denied.</p>
    AccessDenied(crate::error::AccessDenied),
    /// <p>Cannot delete the cache policy because it is attached to one or more cache behaviors.</p>
    CachePolicyInUse(crate::error::CachePolicyInUse),
    /// <p>You cannot delete a managed policy.</p>
    IllegalDelete(crate::error::IllegalDelete),
    /// <p>The <code>If-Match</code> version is missing or not valid.</p>
    InvalidIfMatchVersion(crate::error::InvalidIfMatchVersion),
    /// <p>The cache policy does not exist.</p>
    NoSuchCachePolicy(crate::error::NoSuchCachePolicy),
    /// <p>The precondition in one or more of the request fields evaluated to <code>false</code>.</p>
    PreconditionFailed(crate::error::PreconditionFailed),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteCachePolicyError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteCachePolicyErrorKind::AccessDenied(_inner) => _inner.fmt(f),
            DeleteCachePolicyErrorKind::CachePolicyInUse(_inner) => _inner.fmt(f),
            DeleteCachePolicyErrorKind::IllegalDelete(_inner) => _inner.fmt(f),
            DeleteCachePolicyErrorKind::InvalidIfMatchVersion(_inner) => _inner.fmt(f),
            DeleteCachePolicyErrorKind::NoSuchCachePolicy(_inner) => _inner.fmt(f),
            DeleteCachePolicyErrorKind::PreconditionFailed(_inner) => _inner.fmt(f),
            DeleteCachePolicyErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteCachePolicyError {
    fn code(&self) -> Option<&str> {
        DeleteCachePolicyError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteCachePolicyError {
    /// Creates a new `DeleteCachePolicyError`.
    pub fn new(kind: DeleteCachePolicyErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteCachePolicyError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteCachePolicyErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteCachePolicyError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteCachePolicyErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteCachePolicyErrorKind::AccessDenied`.
    pub fn is_access_denied(&self) -> bool {
        matches!(&self.kind, DeleteCachePolicyErrorKind::AccessDenied(_))
    }
    /// Returns `true` if the error kind is `DeleteCachePolicyErrorKind::CachePolicyInUse`.
    pub fn is_cache_policy_in_use(&self) -> bool {
        matches!(&self.kind, DeleteCachePolicyErrorKind::CachePolicyInUse(_))
    }
    /// Returns `true` if the error kind is `DeleteCachePolicyErrorKind::IllegalDelete`.
    pub fn is_illegal_delete(&self) -> bool {
        matches!(&self.kind, DeleteCachePolicyErrorKind::IllegalDelete(_))
    }
    /// Returns `true` if the error kind is `DeleteCachePolicyErrorKind::InvalidIfMatchVersion`.
    pub fn is_invalid_if_match_version(&self) -> bool {
        matches!(
            &self.kind,
            DeleteCachePolicyErrorKind::InvalidIfMatchVersion(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteCachePolicyErrorKind::NoSuchCachePolicy`.
    pub fn is_no_such_cache_policy(&self) -> bool {
        matches!(&self.kind, DeleteCachePolicyErrorKind::NoSuchCachePolicy(_))
    }
    /// Returns `true` if the error kind is `DeleteCachePolicyErrorKind::PreconditionFailed`.
    pub fn is_precondition_failed(&self) -> bool {
        matches!(
            &self.kind,
            DeleteCachePolicyErrorKind::PreconditionFailed(_)
        )
    }
}
impl std::error::Error for DeleteCachePolicyError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteCachePolicyErrorKind::AccessDenied(_inner) => Some(_inner),
            DeleteCachePolicyErrorKind::CachePolicyInUse(_inner) => Some(_inner),
            DeleteCachePolicyErrorKind::IllegalDelete(_inner) => Some(_inner),
            DeleteCachePolicyErrorKind::InvalidIfMatchVersion(_inner) => Some(_inner),
            DeleteCachePolicyErrorKind::NoSuchCachePolicy(_inner) => Some(_inner),
            DeleteCachePolicyErrorKind::PreconditionFailed(_inner) => Some(_inner),
            DeleteCachePolicyErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteCloudFrontOriginAccessIdentity` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteCloudFrontOriginAccessIdentityError {
    /// Kind of error that occurred.
    pub kind: DeleteCloudFrontOriginAccessIdentityErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteCloudFrontOriginAccessIdentity` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteCloudFrontOriginAccessIdentityErrorKind {
    /// <p>Access denied.</p>
    AccessDenied(crate::error::AccessDenied),
    /// <p>The Origin Access Identity specified is already in use.</p>
    CloudFrontOriginAccessIdentityInUse(crate::error::CloudFrontOriginAccessIdentityInUse),
    /// <p>The <code>If-Match</code> version is missing or not valid.</p>
    InvalidIfMatchVersion(crate::error::InvalidIfMatchVersion),
    /// <p>The specified origin access identity does not exist.</p>
    NoSuchCloudFrontOriginAccessIdentity(crate::error::NoSuchCloudFrontOriginAccessIdentity),
    /// <p>The precondition in one or more of the request fields evaluated to <code>false</code>.</p>
    PreconditionFailed(crate::error::PreconditionFailed),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteCloudFrontOriginAccessIdentityError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteCloudFrontOriginAccessIdentityErrorKind::AccessDenied(_inner) => _inner.fmt(f),
            DeleteCloudFrontOriginAccessIdentityErrorKind::CloudFrontOriginAccessIdentityInUse(
                _inner,
            ) => _inner.fmt(f),
            DeleteCloudFrontOriginAccessIdentityErrorKind::InvalidIfMatchVersion(_inner) => {
                _inner.fmt(f)
            }
            DeleteCloudFrontOriginAccessIdentityErrorKind::NoSuchCloudFrontOriginAccessIdentity(
                _inner,
            ) => _inner.fmt(f),
            DeleteCloudFrontOriginAccessIdentityErrorKind::PreconditionFailed(_inner) => {
                _inner.fmt(f)
            }
            DeleteCloudFrontOriginAccessIdentityErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteCloudFrontOriginAccessIdentityError {
    fn code(&self) -> Option<&str> {
        DeleteCloudFrontOriginAccessIdentityError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteCloudFrontOriginAccessIdentityError {
    /// Creates a new `DeleteCloudFrontOriginAccessIdentityError`.
    pub fn new(
        kind: DeleteCloudFrontOriginAccessIdentityErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteCloudFrontOriginAccessIdentityError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteCloudFrontOriginAccessIdentityErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteCloudFrontOriginAccessIdentityError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteCloudFrontOriginAccessIdentityErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteCloudFrontOriginAccessIdentityErrorKind::AccessDenied`.
    pub fn is_access_denied(&self) -> bool {
        matches!(
            &self.kind,
            DeleteCloudFrontOriginAccessIdentityErrorKind::AccessDenied(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteCloudFrontOriginAccessIdentityErrorKind::CloudFrontOriginAccessIdentityInUse`.
    pub fn is_cloud_front_origin_access_identity_in_use(&self) -> bool {
        matches!(
            &self.kind,
            DeleteCloudFrontOriginAccessIdentityErrorKind::CloudFrontOriginAccessIdentityInUse(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteCloudFrontOriginAccessIdentityErrorKind::InvalidIfMatchVersion`.
    pub fn is_invalid_if_match_version(&self) -> bool {
        matches!(
            &self.kind,
            DeleteCloudFrontOriginAccessIdentityErrorKind::InvalidIfMatchVersion(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteCloudFrontOriginAccessIdentityErrorKind::NoSuchCloudFrontOriginAccessIdentity`.
    pub fn is_no_such_cloud_front_origin_access_identity(&self) -> bool {
        matches!(
            &self.kind,
            DeleteCloudFrontOriginAccessIdentityErrorKind::NoSuchCloudFrontOriginAccessIdentity(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteCloudFrontOriginAccessIdentityErrorKind::PreconditionFailed`.
    pub fn is_precondition_failed(&self) -> bool {
        matches!(
            &self.kind,
            DeleteCloudFrontOriginAccessIdentityErrorKind::PreconditionFailed(_)
        )
    }
}
impl std::error::Error for DeleteCloudFrontOriginAccessIdentityError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteCloudFrontOriginAccessIdentityErrorKind::AccessDenied(_inner) => Some(_inner),
            DeleteCloudFrontOriginAccessIdentityErrorKind::CloudFrontOriginAccessIdentityInUse(
                _inner,
            ) => Some(_inner),
            DeleteCloudFrontOriginAccessIdentityErrorKind::InvalidIfMatchVersion(_inner) => {
                Some(_inner)
            }
            DeleteCloudFrontOriginAccessIdentityErrorKind::NoSuchCloudFrontOriginAccessIdentity(
                _inner,
            ) => Some(_inner),
            DeleteCloudFrontOriginAccessIdentityErrorKind::PreconditionFailed(_inner) => {
                Some(_inner)
            }
            DeleteCloudFrontOriginAccessIdentityErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `DeleteDistribution` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteDistributionError {
    /// Kind of error that occurred.
    pub kind: DeleteDistributionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteDistribution` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteDistributionErrorKind {
    /// <p>Access denied.</p>
    AccessDenied(crate::error::AccessDenied),
    /// <p>The specified CloudFront distribution is not disabled. You must disable the distribution before you can delete it.</p>
    DistributionNotDisabled(crate::error::DistributionNotDisabled),
    /// <p>The <code>If-Match</code> version is missing or not valid.</p>
    InvalidIfMatchVersion(crate::error::InvalidIfMatchVersion),
    /// <p>The specified distribution does not exist.</p>
    NoSuchDistribution(crate::error::NoSuchDistribution),
    /// <p>The precondition in one or more of the request fields evaluated to <code>false</code>.</p>
    PreconditionFailed(crate::error::PreconditionFailed),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteDistributionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteDistributionErrorKind::AccessDenied(_inner) => _inner.fmt(f),
            DeleteDistributionErrorKind::DistributionNotDisabled(_inner) => _inner.fmt(f),
            DeleteDistributionErrorKind::InvalidIfMatchVersion(_inner) => _inner.fmt(f),
            DeleteDistributionErrorKind::NoSuchDistribution(_inner) => _inner.fmt(f),
            DeleteDistributionErrorKind::PreconditionFailed(_inner) => _inner.fmt(f),
            DeleteDistributionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteDistributionError {
    fn code(&self) -> Option<&str> {
        DeleteDistributionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteDistributionError {
    /// Creates a new `DeleteDistributionError`.
    pub fn new(kind: DeleteDistributionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteDistributionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteDistributionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteDistributionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteDistributionErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteDistributionErrorKind::AccessDenied`.
    pub fn is_access_denied(&self) -> bool {
        matches!(&self.kind, DeleteDistributionErrorKind::AccessDenied(_))
    }
    /// Returns `true` if the error kind is `DeleteDistributionErrorKind::DistributionNotDisabled`.
    pub fn is_distribution_not_disabled(&self) -> bool {
        matches!(
            &self.kind,
            DeleteDistributionErrorKind::DistributionNotDisabled(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteDistributionErrorKind::InvalidIfMatchVersion`.
    pub fn is_invalid_if_match_version(&self) -> bool {
        matches!(
            &self.kind,
            DeleteDistributionErrorKind::InvalidIfMatchVersion(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteDistributionErrorKind::NoSuchDistribution`.
    pub fn is_no_such_distribution(&self) -> bool {
        matches!(
            &self.kind,
            DeleteDistributionErrorKind::NoSuchDistribution(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteDistributionErrorKind::PreconditionFailed`.
    pub fn is_precondition_failed(&self) -> bool {
        matches!(
            &self.kind,
            DeleteDistributionErrorKind::PreconditionFailed(_)
        )
    }
}
impl std::error::Error for DeleteDistributionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteDistributionErrorKind::AccessDenied(_inner) => Some(_inner),
            DeleteDistributionErrorKind::DistributionNotDisabled(_inner) => Some(_inner),
            DeleteDistributionErrorKind::InvalidIfMatchVersion(_inner) => Some(_inner),
            DeleteDistributionErrorKind::NoSuchDistribution(_inner) => Some(_inner),
            DeleteDistributionErrorKind::PreconditionFailed(_inner) => Some(_inner),
            DeleteDistributionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteFieldLevelEncryptionConfig` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteFieldLevelEncryptionConfigError {
    /// Kind of error that occurred.
    pub kind: DeleteFieldLevelEncryptionConfigErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteFieldLevelEncryptionConfig` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteFieldLevelEncryptionConfigErrorKind {
    /// <p>Access denied.</p>
    AccessDenied(crate::error::AccessDenied),
    /// <p>The specified configuration for field-level encryption is in use.</p>
    FieldLevelEncryptionConfigInUse(crate::error::FieldLevelEncryptionConfigInUse),
    /// <p>The <code>If-Match</code> version is missing or not valid.</p>
    InvalidIfMatchVersion(crate::error::InvalidIfMatchVersion),
    /// <p>The specified configuration for field-level encryption doesn't exist.</p>
    NoSuchFieldLevelEncryptionConfig(crate::error::NoSuchFieldLevelEncryptionConfig),
    /// <p>The precondition in one or more of the request fields evaluated to <code>false</code>.</p>
    PreconditionFailed(crate::error::PreconditionFailed),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteFieldLevelEncryptionConfigError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteFieldLevelEncryptionConfigErrorKind::AccessDenied(_inner) => _inner.fmt(f),
            DeleteFieldLevelEncryptionConfigErrorKind::FieldLevelEncryptionConfigInUse(_inner) => {
                _inner.fmt(f)
            }
            DeleteFieldLevelEncryptionConfigErrorKind::InvalidIfMatchVersion(_inner) => {
                _inner.fmt(f)
            }
            DeleteFieldLevelEncryptionConfigErrorKind::NoSuchFieldLevelEncryptionConfig(_inner) => {
                _inner.fmt(f)
            }
            DeleteFieldLevelEncryptionConfigErrorKind::PreconditionFailed(_inner) => _inner.fmt(f),
            DeleteFieldLevelEncryptionConfigErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteFieldLevelEncryptionConfigError {
    fn code(&self) -> Option<&str> {
        DeleteFieldLevelEncryptionConfigError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteFieldLevelEncryptionConfigError {
    /// Creates a new `DeleteFieldLevelEncryptionConfigError`.
    pub fn new(
        kind: DeleteFieldLevelEncryptionConfigErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteFieldLevelEncryptionConfigError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteFieldLevelEncryptionConfigErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteFieldLevelEncryptionConfigError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteFieldLevelEncryptionConfigErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteFieldLevelEncryptionConfigErrorKind::AccessDenied`.
    pub fn is_access_denied(&self) -> bool {
        matches!(
            &self.kind,
            DeleteFieldLevelEncryptionConfigErrorKind::AccessDenied(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteFieldLevelEncryptionConfigErrorKind::FieldLevelEncryptionConfigInUse`.
    pub fn is_field_level_encryption_config_in_use(&self) -> bool {
        matches!(
            &self.kind,
            DeleteFieldLevelEncryptionConfigErrorKind::FieldLevelEncryptionConfigInUse(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteFieldLevelEncryptionConfigErrorKind::InvalidIfMatchVersion`.
    pub fn is_invalid_if_match_version(&self) -> bool {
        matches!(
            &self.kind,
            DeleteFieldLevelEncryptionConfigErrorKind::InvalidIfMatchVersion(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteFieldLevelEncryptionConfigErrorKind::NoSuchFieldLevelEncryptionConfig`.
    pub fn is_no_such_field_level_encryption_config(&self) -> bool {
        matches!(
            &self.kind,
            DeleteFieldLevelEncryptionConfigErrorKind::NoSuchFieldLevelEncryptionConfig(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteFieldLevelEncryptionConfigErrorKind::PreconditionFailed`.
    pub fn is_precondition_failed(&self) -> bool {
        matches!(
            &self.kind,
            DeleteFieldLevelEncryptionConfigErrorKind::PreconditionFailed(_)
        )
    }
}
impl std::error::Error for DeleteFieldLevelEncryptionConfigError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteFieldLevelEncryptionConfigErrorKind::AccessDenied(_inner) => Some(_inner),
            DeleteFieldLevelEncryptionConfigErrorKind::FieldLevelEncryptionConfigInUse(_inner) => {
                Some(_inner)
            }
            DeleteFieldLevelEncryptionConfigErrorKind::InvalidIfMatchVersion(_inner) => {
                Some(_inner)
            }
            DeleteFieldLevelEncryptionConfigErrorKind::NoSuchFieldLevelEncryptionConfig(_inner) => {
                Some(_inner)
            }
            DeleteFieldLevelEncryptionConfigErrorKind::PreconditionFailed(_inner) => Some(_inner),
            DeleteFieldLevelEncryptionConfigErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteFieldLevelEncryptionProfile` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteFieldLevelEncryptionProfileError {
    /// Kind of error that occurred.
    pub kind: DeleteFieldLevelEncryptionProfileErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteFieldLevelEncryptionProfile` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteFieldLevelEncryptionProfileErrorKind {
    /// <p>Access denied.</p>
    AccessDenied(crate::error::AccessDenied),
    /// <p>The specified profile for field-level encryption is in use.</p>
    FieldLevelEncryptionProfileInUse(crate::error::FieldLevelEncryptionProfileInUse),
    /// <p>The <code>If-Match</code> version is missing or not valid.</p>
    InvalidIfMatchVersion(crate::error::InvalidIfMatchVersion),
    /// <p>The specified profile for field-level encryption doesn't exist.</p>
    NoSuchFieldLevelEncryptionProfile(crate::error::NoSuchFieldLevelEncryptionProfile),
    /// <p>The precondition in one or more of the request fields evaluated to <code>false</code>.</p>
    PreconditionFailed(crate::error::PreconditionFailed),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteFieldLevelEncryptionProfileError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteFieldLevelEncryptionProfileErrorKind::AccessDenied(_inner) => _inner.fmt(f),
            DeleteFieldLevelEncryptionProfileErrorKind::FieldLevelEncryptionProfileInUse(
                _inner,
            ) => _inner.fmt(f),
            DeleteFieldLevelEncryptionProfileErrorKind::InvalidIfMatchVersion(_inner) => {
                _inner.fmt(f)
            }
            DeleteFieldLevelEncryptionProfileErrorKind::NoSuchFieldLevelEncryptionProfile(
                _inner,
            ) => _inner.fmt(f),
            DeleteFieldLevelEncryptionProfileErrorKind::PreconditionFailed(_inner) => _inner.fmt(f),
            DeleteFieldLevelEncryptionProfileErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteFieldLevelEncryptionProfileError {
    fn code(&self) -> Option<&str> {
        DeleteFieldLevelEncryptionProfileError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteFieldLevelEncryptionProfileError {
    /// Creates a new `DeleteFieldLevelEncryptionProfileError`.
    pub fn new(
        kind: DeleteFieldLevelEncryptionProfileErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteFieldLevelEncryptionProfileError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteFieldLevelEncryptionProfileErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteFieldLevelEncryptionProfileError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteFieldLevelEncryptionProfileErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteFieldLevelEncryptionProfileErrorKind::AccessDenied`.
    pub fn is_access_denied(&self) -> bool {
        matches!(
            &self.kind,
            DeleteFieldLevelEncryptionProfileErrorKind::AccessDenied(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteFieldLevelEncryptionProfileErrorKind::FieldLevelEncryptionProfileInUse`.
    pub fn is_field_level_encryption_profile_in_use(&self) -> bool {
        matches!(
            &self.kind,
            DeleteFieldLevelEncryptionProfileErrorKind::FieldLevelEncryptionProfileInUse(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteFieldLevelEncryptionProfileErrorKind::InvalidIfMatchVersion`.
    pub fn is_invalid_if_match_version(&self) -> bool {
        matches!(
            &self.kind,
            DeleteFieldLevelEncryptionProfileErrorKind::InvalidIfMatchVersion(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteFieldLevelEncryptionProfileErrorKind::NoSuchFieldLevelEncryptionProfile`.
    pub fn is_no_such_field_level_encryption_profile(&self) -> bool {
        matches!(
            &self.kind,
            DeleteFieldLevelEncryptionProfileErrorKind::NoSuchFieldLevelEncryptionProfile(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteFieldLevelEncryptionProfileErrorKind::PreconditionFailed`.
    pub fn is_precondition_failed(&self) -> bool {
        matches!(
            &self.kind,
            DeleteFieldLevelEncryptionProfileErrorKind::PreconditionFailed(_)
        )
    }
}
impl std::error::Error for DeleteFieldLevelEncryptionProfileError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteFieldLevelEncryptionProfileErrorKind::AccessDenied(_inner) => Some(_inner),
            DeleteFieldLevelEncryptionProfileErrorKind::FieldLevelEncryptionProfileInUse(
                _inner,
            ) => Some(_inner),
            DeleteFieldLevelEncryptionProfileErrorKind::InvalidIfMatchVersion(_inner) => {
                Some(_inner)
            }
            DeleteFieldLevelEncryptionProfileErrorKind::NoSuchFieldLevelEncryptionProfile(
                _inner,
            ) => Some(_inner),
            DeleteFieldLevelEncryptionProfileErrorKind::PreconditionFailed(_inner) => Some(_inner),
            DeleteFieldLevelEncryptionProfileErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteFunction` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteFunctionError {
    /// Kind of error that occurred.
    pub kind: DeleteFunctionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteFunction` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteFunctionErrorKind {
    /// <p>Cannot delete the function because it’s attached to one or more cache behaviors.</p>
    FunctionInUse(crate::error::FunctionInUse),
    /// <p>The <code>If-Match</code> version is missing or not valid.</p>
    InvalidIfMatchVersion(crate::error::InvalidIfMatchVersion),
    /// <p>The function does not exist.</p>
    NoSuchFunctionExists(crate::error::NoSuchFunctionExists),
    /// <p>The precondition in one or more of the request fields evaluated to <code>false</code>.</p>
    PreconditionFailed(crate::error::PreconditionFailed),
    /// <p>This operation is not supported in this region.</p>
    UnsupportedOperation(crate::error::UnsupportedOperation),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteFunctionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteFunctionErrorKind::FunctionInUse(_inner) => _inner.fmt(f),
            DeleteFunctionErrorKind::InvalidIfMatchVersion(_inner) => _inner.fmt(f),
            DeleteFunctionErrorKind::NoSuchFunctionExists(_inner) => _inner.fmt(f),
            DeleteFunctionErrorKind::PreconditionFailed(_inner) => _inner.fmt(f),
            DeleteFunctionErrorKind::UnsupportedOperation(_inner) => _inner.fmt(f),
            DeleteFunctionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteFunctionError {
    fn code(&self) -> Option<&str> {
        DeleteFunctionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteFunctionError {
    /// Creates a new `DeleteFunctionError`.
    pub fn new(kind: DeleteFunctionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteFunctionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteFunctionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteFunctionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteFunctionErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteFunctionErrorKind::FunctionInUse`.
    pub fn is_function_in_use(&self) -> bool {
        matches!(&self.kind, DeleteFunctionErrorKind::FunctionInUse(_))
    }
    /// Returns `true` if the error kind is `DeleteFunctionErrorKind::InvalidIfMatchVersion`.
    pub fn is_invalid_if_match_version(&self) -> bool {
        matches!(
            &self.kind,
            DeleteFunctionErrorKind::InvalidIfMatchVersion(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteFunctionErrorKind::NoSuchFunctionExists`.
    pub fn is_no_such_function_exists(&self) -> bool {
        matches!(&self.kind, DeleteFunctionErrorKind::NoSuchFunctionExists(_))
    }
    /// Returns `true` if the error kind is `DeleteFunctionErrorKind::PreconditionFailed`.
    pub fn is_precondition_failed(&self) -> bool {
        matches!(&self.kind, DeleteFunctionErrorKind::PreconditionFailed(_))
    }
    /// Returns `true` if the error kind is `DeleteFunctionErrorKind::UnsupportedOperation`.
    pub fn is_unsupported_operation(&self) -> bool {
        matches!(&self.kind, DeleteFunctionErrorKind::UnsupportedOperation(_))
    }
}
impl std::error::Error for DeleteFunctionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteFunctionErrorKind::FunctionInUse(_inner) => Some(_inner),
            DeleteFunctionErrorKind::InvalidIfMatchVersion(_inner) => Some(_inner),
            DeleteFunctionErrorKind::NoSuchFunctionExists(_inner) => Some(_inner),
            DeleteFunctionErrorKind::PreconditionFailed(_inner) => Some(_inner),
            DeleteFunctionErrorKind::UnsupportedOperation(_inner) => Some(_inner),
            DeleteFunctionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteKeyGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteKeyGroupError {
    /// Kind of error that occurred.
    pub kind: DeleteKeyGroupErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteKeyGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteKeyGroupErrorKind {
    /// <p>The <code>If-Match</code> version is missing or not valid.</p>
    InvalidIfMatchVersion(crate::error::InvalidIfMatchVersion),
    /// <p>A resource that was specified is not valid.</p>
    NoSuchResource(crate::error::NoSuchResource),
    /// <p>The precondition in one or more of the request fields evaluated to <code>false</code>.</p>
    PreconditionFailed(crate::error::PreconditionFailed),
    /// <p>Cannot delete this resource because it is in use.</p>
    ResourceInUse(crate::error::ResourceInUse),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteKeyGroupError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteKeyGroupErrorKind::InvalidIfMatchVersion(_inner) => _inner.fmt(f),
            DeleteKeyGroupErrorKind::NoSuchResource(_inner) => _inner.fmt(f),
            DeleteKeyGroupErrorKind::PreconditionFailed(_inner) => _inner.fmt(f),
            DeleteKeyGroupErrorKind::ResourceInUse(_inner) => _inner.fmt(f),
            DeleteKeyGroupErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteKeyGroupError {
    fn code(&self) -> Option<&str> {
        DeleteKeyGroupError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteKeyGroupError {
    /// Creates a new `DeleteKeyGroupError`.
    pub fn new(kind: DeleteKeyGroupErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteKeyGroupError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteKeyGroupErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteKeyGroupError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteKeyGroupErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteKeyGroupErrorKind::InvalidIfMatchVersion`.
    pub fn is_invalid_if_match_version(&self) -> bool {
        matches!(
            &self.kind,
            DeleteKeyGroupErrorKind::InvalidIfMatchVersion(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteKeyGroupErrorKind::NoSuchResource`.
    pub fn is_no_such_resource(&self) -> bool {
        matches!(&self.kind, DeleteKeyGroupErrorKind::NoSuchResource(_))
    }
    /// Returns `true` if the error kind is `DeleteKeyGroupErrorKind::PreconditionFailed`.
    pub fn is_precondition_failed(&self) -> bool {
        matches!(&self.kind, DeleteKeyGroupErrorKind::PreconditionFailed(_))
    }
    /// Returns `true` if the error kind is `DeleteKeyGroupErrorKind::ResourceInUse`.
    pub fn is_resource_in_use(&self) -> bool {
        matches!(&self.kind, DeleteKeyGroupErrorKind::ResourceInUse(_))
    }
}
impl std::error::Error for DeleteKeyGroupError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteKeyGroupErrorKind::InvalidIfMatchVersion(_inner) => Some(_inner),
            DeleteKeyGroupErrorKind::NoSuchResource(_inner) => Some(_inner),
            DeleteKeyGroupErrorKind::PreconditionFailed(_inner) => Some(_inner),
            DeleteKeyGroupErrorKind::ResourceInUse(_inner) => Some(_inner),
            DeleteKeyGroupErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteMonitoringSubscription` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteMonitoringSubscriptionError {
    /// Kind of error that occurred.
    pub kind: DeleteMonitoringSubscriptionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteMonitoringSubscription` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteMonitoringSubscriptionErrorKind {
    /// <p>Access denied.</p>
    AccessDenied(crate::error::AccessDenied),
    /// <p>The specified distribution does not exist.</p>
    NoSuchDistribution(crate::error::NoSuchDistribution),
    /// <p>This operation is not supported in this region.</p>
    UnsupportedOperation(crate::error::UnsupportedOperation),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteMonitoringSubscriptionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteMonitoringSubscriptionErrorKind::AccessDenied(_inner) => _inner.fmt(f),
            DeleteMonitoringSubscriptionErrorKind::NoSuchDistribution(_inner) => _inner.fmt(f),
            DeleteMonitoringSubscriptionErrorKind::UnsupportedOperation(_inner) => _inner.fmt(f),
            DeleteMonitoringSubscriptionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteMonitoringSubscriptionError {
    fn code(&self) -> Option<&str> {
        DeleteMonitoringSubscriptionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteMonitoringSubscriptionError {
    /// Creates a new `DeleteMonitoringSubscriptionError`.
    pub fn new(kind: DeleteMonitoringSubscriptionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteMonitoringSubscriptionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteMonitoringSubscriptionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteMonitoringSubscriptionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteMonitoringSubscriptionErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteMonitoringSubscriptionErrorKind::AccessDenied`.
    pub fn is_access_denied(&self) -> bool {
        matches!(
            &self.kind,
            DeleteMonitoringSubscriptionErrorKind::AccessDenied(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteMonitoringSubscriptionErrorKind::NoSuchDistribution`.
    pub fn is_no_such_distribution(&self) -> bool {
        matches!(
            &self.kind,
            DeleteMonitoringSubscriptionErrorKind::NoSuchDistribution(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteMonitoringSubscriptionErrorKind::UnsupportedOperation`.
    pub fn is_unsupported_operation(&self) -> bool {
        matches!(
            &self.kind,
            DeleteMonitoringSubscriptionErrorKind::UnsupportedOperation(_)
        )
    }
}
impl std::error::Error for DeleteMonitoringSubscriptionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteMonitoringSubscriptionErrorKind::AccessDenied(_inner) => Some(_inner),
            DeleteMonitoringSubscriptionErrorKind::NoSuchDistribution(_inner) => Some(_inner),
            DeleteMonitoringSubscriptionErrorKind::UnsupportedOperation(_inner) => Some(_inner),
            DeleteMonitoringSubscriptionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteOriginRequestPolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteOriginRequestPolicyError {
    /// Kind of error that occurred.
    pub kind: DeleteOriginRequestPolicyErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteOriginRequestPolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteOriginRequestPolicyErrorKind {
    /// <p>Access denied.</p>
    AccessDenied(crate::error::AccessDenied),
    /// <p>You cannot delete a managed policy.</p>
    IllegalDelete(crate::error::IllegalDelete),
    /// <p>The <code>If-Match</code> version is missing or not valid.</p>
    InvalidIfMatchVersion(crate::error::InvalidIfMatchVersion),
    /// <p>The origin request policy does not exist.</p>
    NoSuchOriginRequestPolicy(crate::error::NoSuchOriginRequestPolicy),
    /// <p>Cannot delete the origin request policy because it is attached to one or more cache behaviors.</p>
    OriginRequestPolicyInUse(crate::error::OriginRequestPolicyInUse),
    /// <p>The precondition in one or more of the request fields evaluated to <code>false</code>.</p>
    PreconditionFailed(crate::error::PreconditionFailed),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteOriginRequestPolicyError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteOriginRequestPolicyErrorKind::AccessDenied(_inner) => _inner.fmt(f),
            DeleteOriginRequestPolicyErrorKind::IllegalDelete(_inner) => _inner.fmt(f),
            DeleteOriginRequestPolicyErrorKind::InvalidIfMatchVersion(_inner) => _inner.fmt(f),
            DeleteOriginRequestPolicyErrorKind::NoSuchOriginRequestPolicy(_inner) => _inner.fmt(f),
            DeleteOriginRequestPolicyErrorKind::OriginRequestPolicyInUse(_inner) => _inner.fmt(f),
            DeleteOriginRequestPolicyErrorKind::PreconditionFailed(_inner) => _inner.fmt(f),
            DeleteOriginRequestPolicyErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteOriginRequestPolicyError {
    fn code(&self) -> Option<&str> {
        DeleteOriginRequestPolicyError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteOriginRequestPolicyError {
    /// Creates a new `DeleteOriginRequestPolicyError`.
    pub fn new(kind: DeleteOriginRequestPolicyErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteOriginRequestPolicyError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteOriginRequestPolicyErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteOriginRequestPolicyError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteOriginRequestPolicyErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteOriginRequestPolicyErrorKind::AccessDenied`.
    pub fn is_access_denied(&self) -> bool {
        matches!(
            &self.kind,
            DeleteOriginRequestPolicyErrorKind::AccessDenied(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteOriginRequestPolicyErrorKind::IllegalDelete`.
    pub fn is_illegal_delete(&self) -> bool {
        matches!(
            &self.kind,
            DeleteOriginRequestPolicyErrorKind::IllegalDelete(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteOriginRequestPolicyErrorKind::InvalidIfMatchVersion`.
    pub fn is_invalid_if_match_version(&self) -> bool {
        matches!(
            &self.kind,
            DeleteOriginRequestPolicyErrorKind::InvalidIfMatchVersion(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteOriginRequestPolicyErrorKind::NoSuchOriginRequestPolicy`.
    pub fn is_no_such_origin_request_policy(&self) -> bool {
        matches!(
            &self.kind,
            DeleteOriginRequestPolicyErrorKind::NoSuchOriginRequestPolicy(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteOriginRequestPolicyErrorKind::OriginRequestPolicyInUse`.
    pub fn is_origin_request_policy_in_use(&self) -> bool {
        matches!(
            &self.kind,
            DeleteOriginRequestPolicyErrorKind::OriginRequestPolicyInUse(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteOriginRequestPolicyErrorKind::PreconditionFailed`.
    pub fn is_precondition_failed(&self) -> bool {
        matches!(
            &self.kind,
            DeleteOriginRequestPolicyErrorKind::PreconditionFailed(_)
        )
    }
}
impl std::error::Error for DeleteOriginRequestPolicyError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteOriginRequestPolicyErrorKind::AccessDenied(_inner) => Some(_inner),
            DeleteOriginRequestPolicyErrorKind::IllegalDelete(_inner) => Some(_inner),
            DeleteOriginRequestPolicyErrorKind::InvalidIfMatchVersion(_inner) => Some(_inner),
            DeleteOriginRequestPolicyErrorKind::NoSuchOriginRequestPolicy(_inner) => Some(_inner),
            DeleteOriginRequestPolicyErrorKind::OriginRequestPolicyInUse(_inner) => Some(_inner),
            DeleteOriginRequestPolicyErrorKind::PreconditionFailed(_inner) => Some(_inner),
            DeleteOriginRequestPolicyErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeletePublicKey` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeletePublicKeyError {
    /// Kind of error that occurred.
    pub kind: DeletePublicKeyErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeletePublicKey` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeletePublicKeyErrorKind {
    /// <p>Access denied.</p>
    AccessDenied(crate::error::AccessDenied),
    /// <p>The <code>If-Match</code> version is missing or not valid.</p>
    InvalidIfMatchVersion(crate::error::InvalidIfMatchVersion),
    /// <p>The specified public key doesn't exist.</p>
    NoSuchPublicKey(crate::error::NoSuchPublicKey),
    /// <p>The precondition in one or more of the request fields evaluated to <code>false</code>.</p>
    PreconditionFailed(crate::error::PreconditionFailed),
    /// <p>The specified public key is in use. </p>
    PublicKeyInUse(crate::error::PublicKeyInUse),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeletePublicKeyError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeletePublicKeyErrorKind::AccessDenied(_inner) => _inner.fmt(f),
            DeletePublicKeyErrorKind::InvalidIfMatchVersion(_inner) => _inner.fmt(f),
            DeletePublicKeyErrorKind::NoSuchPublicKey(_inner) => _inner.fmt(f),
            DeletePublicKeyErrorKind::PreconditionFailed(_inner) => _inner.fmt(f),
            DeletePublicKeyErrorKind::PublicKeyInUse(_inner) => _inner.fmt(f),
            DeletePublicKeyErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeletePublicKeyError {
    fn code(&self) -> Option<&str> {
        DeletePublicKeyError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeletePublicKeyError {
    /// Creates a new `DeletePublicKeyError`.
    pub fn new(kind: DeletePublicKeyErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeletePublicKeyError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeletePublicKeyErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeletePublicKeyError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeletePublicKeyErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeletePublicKeyErrorKind::AccessDenied`.
    pub fn is_access_denied(&self) -> bool {
        matches!(&self.kind, DeletePublicKeyErrorKind::AccessDenied(_))
    }
    /// Returns `true` if the error kind is `DeletePublicKeyErrorKind::InvalidIfMatchVersion`.
    pub fn is_invalid_if_match_version(&self) -> bool {
        matches!(
            &self.kind,
            DeletePublicKeyErrorKind::InvalidIfMatchVersion(_)
        )
    }
    /// Returns `true` if the error kind is `DeletePublicKeyErrorKind::NoSuchPublicKey`.
    pub fn is_no_such_public_key(&self) -> bool {
        matches!(&self.kind, DeletePublicKeyErrorKind::NoSuchPublicKey(_))
    }
    /// Returns `true` if the error kind is `DeletePublicKeyErrorKind::PreconditionFailed`.
    pub fn is_precondition_failed(&self) -> bool {
        matches!(&self.kind, DeletePublicKeyErrorKind::PreconditionFailed(_))
    }
    /// Returns `true` if the error kind is `DeletePublicKeyErrorKind::PublicKeyInUse`.
    pub fn is_public_key_in_use(&self) -> bool {
        matches!(&self.kind, DeletePublicKeyErrorKind::PublicKeyInUse(_))
    }
}
impl std::error::Error for DeletePublicKeyError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeletePublicKeyErrorKind::AccessDenied(_inner) => Some(_inner),
            DeletePublicKeyErrorKind::InvalidIfMatchVersion(_inner) => Some(_inner),
            DeletePublicKeyErrorKind::NoSuchPublicKey(_inner) => Some(_inner),
            DeletePublicKeyErrorKind::PreconditionFailed(_inner) => Some(_inner),
            DeletePublicKeyErrorKind::PublicKeyInUse(_inner) => Some(_inner),
            DeletePublicKeyErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteRealtimeLogConfig` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteRealtimeLogConfigError {
    /// Kind of error that occurred.
    pub kind: DeleteRealtimeLogConfigErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteRealtimeLogConfig` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteRealtimeLogConfigErrorKind {
    /// <p>Access denied.</p>
    AccessDenied(crate::error::AccessDenied),
    /// <p>An argument is invalid.</p>
    InvalidArgument(crate::error::InvalidArgument),
    /// <p>The real-time log configuration does not exist.</p>
    NoSuchRealtimeLogConfig(crate::error::NoSuchRealtimeLogConfig),
    /// <p>Cannot delete the real-time log configuration because it is attached to one or more cache behaviors.</p>
    RealtimeLogConfigInUse(crate::error::RealtimeLogConfigInUse),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteRealtimeLogConfigError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteRealtimeLogConfigErrorKind::AccessDenied(_inner) => _inner.fmt(f),
            DeleteRealtimeLogConfigErrorKind::InvalidArgument(_inner) => _inner.fmt(f),
            DeleteRealtimeLogConfigErrorKind::NoSuchRealtimeLogConfig(_inner) => _inner.fmt(f),
            DeleteRealtimeLogConfigErrorKind::RealtimeLogConfigInUse(_inner) => _inner.fmt(f),
            DeleteRealtimeLogConfigErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteRealtimeLogConfigError {
    fn code(&self) -> Option<&str> {
        DeleteRealtimeLogConfigError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteRealtimeLogConfigError {
    /// Creates a new `DeleteRealtimeLogConfigError`.
    pub fn new(kind: DeleteRealtimeLogConfigErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteRealtimeLogConfigError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteRealtimeLogConfigErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteRealtimeLogConfigError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteRealtimeLogConfigErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteRealtimeLogConfigErrorKind::AccessDenied`.
    pub fn is_access_denied(&self) -> bool {
        matches!(
            &self.kind,
            DeleteRealtimeLogConfigErrorKind::AccessDenied(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteRealtimeLogConfigErrorKind::InvalidArgument`.
    pub fn is_invalid_argument(&self) -> bool {
        matches!(
            &self.kind,
            DeleteRealtimeLogConfigErrorKind::InvalidArgument(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteRealtimeLogConfigErrorKind::NoSuchRealtimeLogConfig`.
    pub fn is_no_such_realtime_log_config(&self) -> bool {
        matches!(
            &self.kind,
            DeleteRealtimeLogConfigErrorKind::NoSuchRealtimeLogConfig(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteRealtimeLogConfigErrorKind::RealtimeLogConfigInUse`.
    pub fn is_realtime_log_config_in_use(&self) -> bool {
        matches!(
            &self.kind,
            DeleteRealtimeLogConfigErrorKind::RealtimeLogConfigInUse(_)
        )
    }
}
impl std::error::Error for DeleteRealtimeLogConfigError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteRealtimeLogConfigErrorKind::AccessDenied(_inner) => Some(_inner),
            DeleteRealtimeLogConfigErrorKind::InvalidArgument(_inner) => Some(_inner),
            DeleteRealtimeLogConfigErrorKind::NoSuchRealtimeLogConfig(_inner) => Some(_inner),
            DeleteRealtimeLogConfigErrorKind::RealtimeLogConfigInUse(_inner) => Some(_inner),
            DeleteRealtimeLogConfigErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteResponseHeadersPolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteResponseHeadersPolicyError {
    /// Kind of error that occurred.
    pub kind: DeleteResponseHeadersPolicyErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteResponseHeadersPolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteResponseHeadersPolicyErrorKind {
    /// <p>Access denied.</p>
    AccessDenied(crate::error::AccessDenied),
    /// <p>You cannot delete a managed policy.</p>
    IllegalDelete(crate::error::IllegalDelete),
    /// <p>The <code>If-Match</code> version is missing or not valid.</p>
    InvalidIfMatchVersion(crate::error::InvalidIfMatchVersion),
    /// <p>The response headers policy does not exist.</p>
    NoSuchResponseHeadersPolicy(crate::error::NoSuchResponseHeadersPolicy),
    /// <p>The precondition in one or more of the request fields evaluated to <code>false</code>.</p>
    PreconditionFailed(crate::error::PreconditionFailed),
    /// <p>Cannot delete the response headers policy because it is attached to one or more cache behaviors in a CloudFront distribution. </p>
    ResponseHeadersPolicyInUse(crate::error::ResponseHeadersPolicyInUse),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteResponseHeadersPolicyError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteResponseHeadersPolicyErrorKind::AccessDenied(_inner) => _inner.fmt(f),
            DeleteResponseHeadersPolicyErrorKind::IllegalDelete(_inner) => _inner.fmt(f),
            DeleteResponseHeadersPolicyErrorKind::InvalidIfMatchVersion(_inner) => _inner.fmt(f),
            DeleteResponseHeadersPolicyErrorKind::NoSuchResponseHeadersPolicy(_inner) => {
                _inner.fmt(f)
            }
            DeleteResponseHeadersPolicyErrorKind::PreconditionFailed(_inner) => _inner.fmt(f),
            DeleteResponseHeadersPolicyErrorKind::ResponseHeadersPolicyInUse(_inner) => {
                _inner.fmt(f)
            }
            DeleteResponseHeadersPolicyErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteResponseHeadersPolicyError {
    fn code(&self) -> Option<&str> {
        DeleteResponseHeadersPolicyError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteResponseHeadersPolicyError {
    /// Creates a new `DeleteResponseHeadersPolicyError`.
    pub fn new(kind: DeleteResponseHeadersPolicyErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteResponseHeadersPolicyError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteResponseHeadersPolicyErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteResponseHeadersPolicyError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteResponseHeadersPolicyErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteResponseHeadersPolicyErrorKind::AccessDenied`.
    pub fn is_access_denied(&self) -> bool {
        matches!(
            &self.kind,
            DeleteResponseHeadersPolicyErrorKind::AccessDenied(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteResponseHeadersPolicyErrorKind::IllegalDelete`.
    pub fn is_illegal_delete(&self) -> bool {
        matches!(
            &self.kind,
            DeleteResponseHeadersPolicyErrorKind::IllegalDelete(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteResponseHeadersPolicyErrorKind::InvalidIfMatchVersion`.
    pub fn is_invalid_if_match_version(&self) -> bool {
        matches!(
            &self.kind,
            DeleteResponseHeadersPolicyErrorKind::InvalidIfMatchVersion(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteResponseHeadersPolicyErrorKind::NoSuchResponseHeadersPolicy`.
    pub fn is_no_such_response_headers_policy(&self) -> bool {
        matches!(
            &self.kind,
            DeleteResponseHeadersPolicyErrorKind::NoSuchResponseHeadersPolicy(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteResponseHeadersPolicyErrorKind::PreconditionFailed`.
    pub fn is_precondition_failed(&self) -> bool {
        matches!(
            &self.kind,
            DeleteResponseHeadersPolicyErrorKind::PreconditionFailed(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteResponseHeadersPolicyErrorKind::ResponseHeadersPolicyInUse`.
    pub fn is_response_headers_policy_in_use(&self) -> bool {
        matches!(
            &self.kind,
            DeleteResponseHeadersPolicyErrorKind::ResponseHeadersPolicyInUse(_)
        )
    }
}
impl std::error::Error for DeleteResponseHeadersPolicyError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteResponseHeadersPolicyErrorKind::AccessDenied(_inner) => Some(_inner),
            DeleteResponseHeadersPolicyErrorKind::IllegalDelete(_inner) => Some(_inner),
            DeleteResponseHeadersPolicyErrorKind::InvalidIfMatchVersion(_inner) => Some(_inner),
            DeleteResponseHeadersPolicyErrorKind::NoSuchResponseHeadersPolicy(_inner) => {
                Some(_inner)
            }
            DeleteResponseHeadersPolicyErrorKind::PreconditionFailed(_inner) => Some(_inner),
            DeleteResponseHeadersPolicyErrorKind::ResponseHeadersPolicyInUse(_inner) => {
                Some(_inner)
            }
            DeleteResponseHeadersPolicyErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteStreamingDistribution` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteStreamingDistributionError {
    /// Kind of error that occurred.
    pub kind: DeleteStreamingDistributionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteStreamingDistribution` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteStreamingDistributionErrorKind {
    /// <p>Access denied.</p>
    AccessDenied(crate::error::AccessDenied),
    /// <p>The <code>If-Match</code> version is missing or not valid.</p>
    InvalidIfMatchVersion(crate::error::InvalidIfMatchVersion),
    /// <p>The specified streaming distribution does not exist.</p>
    NoSuchStreamingDistribution(crate::error::NoSuchStreamingDistribution),
    /// <p>The precondition in one or more of the request fields evaluated to <code>false</code>.</p>
    PreconditionFailed(crate::error::PreconditionFailed),
    /// <p>The specified CloudFront distribution is not disabled. You must disable the distribution before you can delete it.</p>
    StreamingDistributionNotDisabled(crate::error::StreamingDistributionNotDisabled),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteStreamingDistributionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteStreamingDistributionErrorKind::AccessDenied(_inner) => _inner.fmt(f),
            DeleteStreamingDistributionErrorKind::InvalidIfMatchVersion(_inner) => _inner.fmt(f),
            DeleteStreamingDistributionErrorKind::NoSuchStreamingDistribution(_inner) => {
                _inner.fmt(f)
            }
            DeleteStreamingDistributionErrorKind::PreconditionFailed(_inner) => _inner.fmt(f),
            DeleteStreamingDistributionErrorKind::StreamingDistributionNotDisabled(_inner) => {
                _inner.fmt(f)
            }
            DeleteStreamingDistributionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteStreamingDistributionError {
    fn code(&self) -> Option<&str> {
        DeleteStreamingDistributionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteStreamingDistributionError {
    /// Creates a new `DeleteStreamingDistributionError`.
    pub fn new(kind: DeleteStreamingDistributionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteStreamingDistributionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteStreamingDistributionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteStreamingDistributionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteStreamingDistributionErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteStreamingDistributionErrorKind::AccessDenied`.
    pub fn is_access_denied(&self) -> bool {
        matches!(
            &self.kind,
            DeleteStreamingDistributionErrorKind::AccessDenied(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteStreamingDistributionErrorKind::InvalidIfMatchVersion`.
    pub fn is_invalid_if_match_version(&self) -> bool {
        matches!(
            &self.kind,
            DeleteStreamingDistributionErrorKind::InvalidIfMatchVersion(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteStreamingDistributionErrorKind::NoSuchStreamingDistribution`.
    pub fn is_no_such_streaming_distribution(&self) -> bool {
        matches!(
            &self.kind,
            DeleteStreamingDistributionErrorKind::NoSuchStreamingDistribution(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteStreamingDistributionErrorKind::PreconditionFailed`.
    pub fn is_precondition_failed(&self) -> bool {
        matches!(
            &self.kind,
            DeleteStreamingDistributionErrorKind::PreconditionFailed(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteStreamingDistributionErrorKind::StreamingDistributionNotDisabled`.
    pub fn is_streaming_distribution_not_disabled(&self) -> bool {
        matches!(
            &self.kind,
            DeleteStreamingDistributionErrorKind::StreamingDistributionNotDisabled(_)
        )
    }
}
impl std::error::Error for DeleteStreamingDistributionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteStreamingDistributionErrorKind::AccessDenied(_inner) => Some(_inner),
            DeleteStreamingDistributionErrorKind::InvalidIfMatchVersion(_inner) => Some(_inner),
            DeleteStreamingDistributionErrorKind::NoSuchStreamingDistribution(_inner) => {
                Some(_inner)
            }
            DeleteStreamingDistributionErrorKind::PreconditionFailed(_inner) => Some(_inner),
            DeleteStreamingDistributionErrorKind::StreamingDistributionNotDisabled(_inner) => {
                Some(_inner)
            }
            DeleteStreamingDistributionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeFunction` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeFunctionError {
    /// Kind of error that occurred.
    pub kind: DescribeFunctionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeFunction` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeFunctionErrorKind {
    /// <p>The function does not exist.</p>
    NoSuchFunctionExists(crate::error::NoSuchFunctionExists),
    /// <p>This operation is not supported in this region.</p>
    UnsupportedOperation(crate::error::UnsupportedOperation),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeFunctionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeFunctionErrorKind::NoSuchFunctionExists(_inner) => _inner.fmt(f),
            DescribeFunctionErrorKind::UnsupportedOperation(_inner) => _inner.fmt(f),
            DescribeFunctionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeFunctionError {
    fn code(&self) -> Option<&str> {
        DescribeFunctionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeFunctionError {
    /// Creates a new `DescribeFunctionError`.
    pub fn new(kind: DescribeFunctionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeFunctionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeFunctionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeFunctionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeFunctionErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeFunctionErrorKind::NoSuchFunctionExists`.
    pub fn is_no_such_function_exists(&self) -> bool {
        matches!(
            &self.kind,
            DescribeFunctionErrorKind::NoSuchFunctionExists(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeFunctionErrorKind::UnsupportedOperation`.
    pub fn is_unsupported_operation(&self) -> bool {
        matches!(
            &self.kind,
            DescribeFunctionErrorKind::UnsupportedOperation(_)
        )
    }
}
impl std::error::Error for DescribeFunctionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeFunctionErrorKind::NoSuchFunctionExists(_inner) => Some(_inner),
            DescribeFunctionErrorKind::UnsupportedOperation(_inner) => Some(_inner),
            DescribeFunctionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetCachePolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetCachePolicyError {
    /// Kind of error that occurred.
    pub kind: GetCachePolicyErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetCachePolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetCachePolicyErrorKind {
    /// <p>Access denied.</p>
    AccessDenied(crate::error::AccessDenied),
    /// <p>The cache policy does not exist.</p>
    NoSuchCachePolicy(crate::error::NoSuchCachePolicy),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetCachePolicyError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetCachePolicyErrorKind::AccessDenied(_inner) => _inner.fmt(f),
            GetCachePolicyErrorKind::NoSuchCachePolicy(_inner) => _inner.fmt(f),
            GetCachePolicyErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetCachePolicyError {
    fn code(&self) -> Option<&str> {
        GetCachePolicyError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetCachePolicyError {
    /// Creates a new `GetCachePolicyError`.
    pub fn new(kind: GetCachePolicyErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetCachePolicyError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetCachePolicyErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetCachePolicyError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetCachePolicyErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetCachePolicyErrorKind::AccessDenied`.
    pub fn is_access_denied(&self) -> bool {
        matches!(&self.kind, GetCachePolicyErrorKind::AccessDenied(_))
    }
    /// Returns `true` if the error kind is `GetCachePolicyErrorKind::NoSuchCachePolicy`.
    pub fn is_no_such_cache_policy(&self) -> bool {
        matches!(&self.kind, GetCachePolicyErrorKind::NoSuchCachePolicy(_))
    }
}
impl std::error::Error for GetCachePolicyError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetCachePolicyErrorKind::AccessDenied(_inner) => Some(_inner),
            GetCachePolicyErrorKind::NoSuchCachePolicy(_inner) => Some(_inner),
            GetCachePolicyErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetCachePolicyConfig` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetCachePolicyConfigError {
    /// Kind of error that occurred.
    pub kind: GetCachePolicyConfigErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetCachePolicyConfig` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetCachePolicyConfigErrorKind {
    /// <p>Access denied.</p>
    AccessDenied(crate::error::AccessDenied),
    /// <p>The cache policy does not exist.</p>
    NoSuchCachePolicy(crate::error::NoSuchCachePolicy),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetCachePolicyConfigError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetCachePolicyConfigErrorKind::AccessDenied(_inner) => _inner.fmt(f),
            GetCachePolicyConfigErrorKind::NoSuchCachePolicy(_inner) => _inner.fmt(f),
            GetCachePolicyConfigErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetCachePolicyConfigError {
    fn code(&self) -> Option<&str> {
        GetCachePolicyConfigError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetCachePolicyConfigError {
    /// Creates a new `GetCachePolicyConfigError`.
    pub fn new(kind: GetCachePolicyConfigErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetCachePolicyConfigError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetCachePolicyConfigErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetCachePolicyConfigError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetCachePolicyConfigErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetCachePolicyConfigErrorKind::AccessDenied`.
    pub fn is_access_denied(&self) -> bool {
        matches!(&self.kind, GetCachePolicyConfigErrorKind::AccessDenied(_))
    }
    /// Returns `true` if the error kind is `GetCachePolicyConfigErrorKind::NoSuchCachePolicy`.
    pub fn is_no_such_cache_policy(&self) -> bool {
        matches!(
            &self.kind,
            GetCachePolicyConfigErrorKind::NoSuchCachePolicy(_)
        )
    }
}
impl std::error::Error for GetCachePolicyConfigError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetCachePolicyConfigErrorKind::AccessDenied(_inner) => Some(_inner),
            GetCachePolicyConfigErrorKind::NoSuchCachePolicy(_inner) => Some(_inner),
            GetCachePolicyConfigErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetCloudFrontOriginAccessIdentity` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetCloudFrontOriginAccessIdentityError {
    /// Kind of error that occurred.
    pub kind: GetCloudFrontOriginAccessIdentityErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetCloudFrontOriginAccessIdentity` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetCloudFrontOriginAccessIdentityErrorKind {
    /// <p>Access denied.</p>
    AccessDenied(crate::error::AccessDenied),
    /// <p>The specified origin access identity does not exist.</p>
    NoSuchCloudFrontOriginAccessIdentity(crate::error::NoSuchCloudFrontOriginAccessIdentity),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetCloudFrontOriginAccessIdentityError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetCloudFrontOriginAccessIdentityErrorKind::AccessDenied(_inner) => _inner.fmt(f),
            GetCloudFrontOriginAccessIdentityErrorKind::NoSuchCloudFrontOriginAccessIdentity(
                _inner,
            ) => _inner.fmt(f),
            GetCloudFrontOriginAccessIdentityErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetCloudFrontOriginAccessIdentityError {
    fn code(&self) -> Option<&str> {
        GetCloudFrontOriginAccessIdentityError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetCloudFrontOriginAccessIdentityError {
    /// Creates a new `GetCloudFrontOriginAccessIdentityError`.
    pub fn new(
        kind: GetCloudFrontOriginAccessIdentityErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetCloudFrontOriginAccessIdentityError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetCloudFrontOriginAccessIdentityErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetCloudFrontOriginAccessIdentityError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetCloudFrontOriginAccessIdentityErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetCloudFrontOriginAccessIdentityErrorKind::AccessDenied`.
    pub fn is_access_denied(&self) -> bool {
        matches!(
            &self.kind,
            GetCloudFrontOriginAccessIdentityErrorKind::AccessDenied(_)
        )
    }
    /// Returns `true` if the error kind is `GetCloudFrontOriginAccessIdentityErrorKind::NoSuchCloudFrontOriginAccessIdentity`.
    pub fn is_no_such_cloud_front_origin_access_identity(&self) -> bool {
        matches!(
            &self.kind,
            GetCloudFrontOriginAccessIdentityErrorKind::NoSuchCloudFrontOriginAccessIdentity(_)
        )
    }
}
impl std::error::Error for GetCloudFrontOriginAccessIdentityError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetCloudFrontOriginAccessIdentityErrorKind::AccessDenied(_inner) => Some(_inner),
            GetCloudFrontOriginAccessIdentityErrorKind::NoSuchCloudFrontOriginAccessIdentity(
                _inner,
            ) => Some(_inner),
            GetCloudFrontOriginAccessIdentityErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetCloudFrontOriginAccessIdentityConfig` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetCloudFrontOriginAccessIdentityConfigError {
    /// Kind of error that occurred.
    pub kind: GetCloudFrontOriginAccessIdentityConfigErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetCloudFrontOriginAccessIdentityConfig` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetCloudFrontOriginAccessIdentityConfigErrorKind {
    /// <p>Access denied.</p>
    AccessDenied(crate::error::AccessDenied),
    /// <p>The specified origin access identity does not exist.</p>
    NoSuchCloudFrontOriginAccessIdentity(crate::error::NoSuchCloudFrontOriginAccessIdentity),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetCloudFrontOriginAccessIdentityConfigError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetCloudFrontOriginAccessIdentityConfigErrorKind::AccessDenied(_inner) =>
            _inner.fmt(f)
            ,
            GetCloudFrontOriginAccessIdentityConfigErrorKind::NoSuchCloudFrontOriginAccessIdentity(_inner) =>
            _inner.fmt(f)
            ,
            GetCloudFrontOriginAccessIdentityConfigErrorKind::Unhandled(_inner) => {
                _inner.fmt(f)
            }
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetCloudFrontOriginAccessIdentityConfigError {
    fn code(&self) -> Option<&str> {
        GetCloudFrontOriginAccessIdentityConfigError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetCloudFrontOriginAccessIdentityConfigError {
    /// Creates a new `GetCloudFrontOriginAccessIdentityConfigError`.
    pub fn new(
        kind: GetCloudFrontOriginAccessIdentityConfigErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetCloudFrontOriginAccessIdentityConfigError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetCloudFrontOriginAccessIdentityConfigErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetCloudFrontOriginAccessIdentityConfigError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetCloudFrontOriginAccessIdentityConfigErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetCloudFrontOriginAccessIdentityConfigErrorKind::AccessDenied`.
    pub fn is_access_denied(&self) -> bool {
        matches!(
            &self.kind,
            GetCloudFrontOriginAccessIdentityConfigErrorKind::AccessDenied(_)
        )
    }
    /// Returns `true` if the error kind is `GetCloudFrontOriginAccessIdentityConfigErrorKind::NoSuchCloudFrontOriginAccessIdentity`.
    pub fn is_no_such_cloud_front_origin_access_identity(&self) -> bool {
        matches!(
            &self.kind,
            GetCloudFrontOriginAccessIdentityConfigErrorKind::NoSuchCloudFrontOriginAccessIdentity(
                _
            )
        )
    }
}
impl std::error::Error for GetCloudFrontOriginAccessIdentityConfigError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetCloudFrontOriginAccessIdentityConfigErrorKind::AccessDenied(_inner) =>
            Some(_inner)
            ,
            GetCloudFrontOriginAccessIdentityConfigErrorKind::NoSuchCloudFrontOriginAccessIdentity(_inner) =>
            Some(_inner)
            ,
            GetCloudFrontOriginAccessIdentityConfigErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `GetDistribution` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetDistributionError {
    /// Kind of error that occurred.
    pub kind: GetDistributionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetDistribution` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetDistributionErrorKind {
    /// <p>Access denied.</p>
    AccessDenied(crate::error::AccessDenied),
    /// <p>The specified distribution does not exist.</p>
    NoSuchDistribution(crate::error::NoSuchDistribution),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetDistributionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetDistributionErrorKind::AccessDenied(_inner) => _inner.fmt(f),
            GetDistributionErrorKind::NoSuchDistribution(_inner) => _inner.fmt(f),
            GetDistributionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetDistributionError {
    fn code(&self) -> Option<&str> {
        GetDistributionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetDistributionError {
    /// Creates a new `GetDistributionError`.
    pub fn new(kind: GetDistributionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetDistributionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetDistributionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetDistributionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetDistributionErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetDistributionErrorKind::AccessDenied`.
    pub fn is_access_denied(&self) -> bool {
        matches!(&self.kind, GetDistributionErrorKind::AccessDenied(_))
    }
    /// Returns `true` if the error kind is `GetDistributionErrorKind::NoSuchDistribution`.
    pub fn is_no_such_distribution(&self) -> bool {
        matches!(&self.kind, GetDistributionErrorKind::NoSuchDistribution(_))
    }
}
impl std::error::Error for GetDistributionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetDistributionErrorKind::AccessDenied(_inner) => Some(_inner),
            GetDistributionErrorKind::NoSuchDistribution(_inner) => Some(_inner),
            GetDistributionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetDistributionConfig` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetDistributionConfigError {
    /// Kind of error that occurred.
    pub kind: GetDistributionConfigErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetDistributionConfig` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetDistributionConfigErrorKind {
    /// <p>Access denied.</p>
    AccessDenied(crate::error::AccessDenied),
    /// <p>The specified distribution does not exist.</p>
    NoSuchDistribution(crate::error::NoSuchDistribution),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetDistributionConfigError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetDistributionConfigErrorKind::AccessDenied(_inner) => _inner.fmt(f),
            GetDistributionConfigErrorKind::NoSuchDistribution(_inner) => _inner.fmt(f),
            GetDistributionConfigErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetDistributionConfigError {
    fn code(&self) -> Option<&str> {
        GetDistributionConfigError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetDistributionConfigError {
    /// Creates a new `GetDistributionConfigError`.
    pub fn new(kind: GetDistributionConfigErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetDistributionConfigError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetDistributionConfigErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetDistributionConfigError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetDistributionConfigErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetDistributionConfigErrorKind::AccessDenied`.
    pub fn is_access_denied(&self) -> bool {
        matches!(&self.kind, GetDistributionConfigErrorKind::AccessDenied(_))
    }
    /// Returns `true` if the error kind is `GetDistributionConfigErrorKind::NoSuchDistribution`.
    pub fn is_no_such_distribution(&self) -> bool {
        matches!(
            &self.kind,
            GetDistributionConfigErrorKind::NoSuchDistribution(_)
        )
    }
}
impl std::error::Error for GetDistributionConfigError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetDistributionConfigErrorKind::AccessDenied(_inner) => Some(_inner),
            GetDistributionConfigErrorKind::NoSuchDistribution(_inner) => Some(_inner),
            GetDistributionConfigErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetFieldLevelEncryption` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetFieldLevelEncryptionError {
    /// Kind of error that occurred.
    pub kind: GetFieldLevelEncryptionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetFieldLevelEncryption` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetFieldLevelEncryptionErrorKind {
    /// <p>Access denied.</p>
    AccessDenied(crate::error::AccessDenied),
    /// <p>The specified configuration for field-level encryption doesn't exist.</p>
    NoSuchFieldLevelEncryptionConfig(crate::error::NoSuchFieldLevelEncryptionConfig),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetFieldLevelEncryptionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetFieldLevelEncryptionErrorKind::AccessDenied(_inner) => _inner.fmt(f),
            GetFieldLevelEncryptionErrorKind::NoSuchFieldLevelEncryptionConfig(_inner) => {
                _inner.fmt(f)
            }
            GetFieldLevelEncryptionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetFieldLevelEncryptionError {
    fn code(&self) -> Option<&str> {
        GetFieldLevelEncryptionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetFieldLevelEncryptionError {
    /// Creates a new `GetFieldLevelEncryptionError`.
    pub fn new(kind: GetFieldLevelEncryptionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetFieldLevelEncryptionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetFieldLevelEncryptionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetFieldLevelEncryptionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetFieldLevelEncryptionErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetFieldLevelEncryptionErrorKind::AccessDenied`.
    pub fn is_access_denied(&self) -> bool {
        matches!(
            &self.kind,
            GetFieldLevelEncryptionErrorKind::AccessDenied(_)
        )
    }
    /// Returns `true` if the error kind is `GetFieldLevelEncryptionErrorKind::NoSuchFieldLevelEncryptionConfig`.
    pub fn is_no_such_field_level_encryption_config(&self) -> bool {
        matches!(
            &self.kind,
            GetFieldLevelEncryptionErrorKind::NoSuchFieldLevelEncryptionConfig(_)
        )
    }
}
impl std::error::Error for GetFieldLevelEncryptionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetFieldLevelEncryptionErrorKind::AccessDenied(_inner) => Some(_inner),
            GetFieldLevelEncryptionErrorKind::NoSuchFieldLevelEncryptionConfig(_inner) => {
                Some(_inner)
            }
            GetFieldLevelEncryptionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetFieldLevelEncryptionConfig` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetFieldLevelEncryptionConfigError {
    /// Kind of error that occurred.
    pub kind: GetFieldLevelEncryptionConfigErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetFieldLevelEncryptionConfig` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetFieldLevelEncryptionConfigErrorKind {
    /// <p>Access denied.</p>
    AccessDenied(crate::error::AccessDenied),
    /// <p>The specified configuration for field-level encryption doesn't exist.</p>
    NoSuchFieldLevelEncryptionConfig(crate::error::NoSuchFieldLevelEncryptionConfig),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetFieldLevelEncryptionConfigError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetFieldLevelEncryptionConfigErrorKind::AccessDenied(_inner) => _inner.fmt(f),
            GetFieldLevelEncryptionConfigErrorKind::NoSuchFieldLevelEncryptionConfig(_inner) => {
                _inner.fmt(f)
            }
            GetFieldLevelEncryptionConfigErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetFieldLevelEncryptionConfigError {
    fn code(&self) -> Option<&str> {
        GetFieldLevelEncryptionConfigError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetFieldLevelEncryptionConfigError {
    /// Creates a new `GetFieldLevelEncryptionConfigError`.
    pub fn new(
        kind: GetFieldLevelEncryptionConfigErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetFieldLevelEncryptionConfigError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetFieldLevelEncryptionConfigErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetFieldLevelEncryptionConfigError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetFieldLevelEncryptionConfigErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetFieldLevelEncryptionConfigErrorKind::AccessDenied`.
    pub fn is_access_denied(&self) -> bool {
        matches!(
            &self.kind,
            GetFieldLevelEncryptionConfigErrorKind::AccessDenied(_)
        )
    }
    /// Returns `true` if the error kind is `GetFieldLevelEncryptionConfigErrorKind::NoSuchFieldLevelEncryptionConfig`.
    pub fn is_no_such_field_level_encryption_config(&self) -> bool {
        matches!(
            &self.kind,
            GetFieldLevelEncryptionConfigErrorKind::NoSuchFieldLevelEncryptionConfig(_)
        )
    }
}
impl std::error::Error for GetFieldLevelEncryptionConfigError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetFieldLevelEncryptionConfigErrorKind::AccessDenied(_inner) => Some(_inner),
            GetFieldLevelEncryptionConfigErrorKind::NoSuchFieldLevelEncryptionConfig(_inner) => {
                Some(_inner)
            }
            GetFieldLevelEncryptionConfigErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetFieldLevelEncryptionProfile` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetFieldLevelEncryptionProfileError {
    /// Kind of error that occurred.
    pub kind: GetFieldLevelEncryptionProfileErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetFieldLevelEncryptionProfile` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetFieldLevelEncryptionProfileErrorKind {
    /// <p>Access denied.</p>
    AccessDenied(crate::error::AccessDenied),
    /// <p>The specified profile for field-level encryption doesn't exist.</p>
    NoSuchFieldLevelEncryptionProfile(crate::error::NoSuchFieldLevelEncryptionProfile),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetFieldLevelEncryptionProfileError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetFieldLevelEncryptionProfileErrorKind::AccessDenied(_inner) => _inner.fmt(f),
            GetFieldLevelEncryptionProfileErrorKind::NoSuchFieldLevelEncryptionProfile(_inner) => {
                _inner.fmt(f)
            }
            GetFieldLevelEncryptionProfileErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetFieldLevelEncryptionProfileError {
    fn code(&self) -> Option<&str> {
        GetFieldLevelEncryptionProfileError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetFieldLevelEncryptionProfileError {
    /// Creates a new `GetFieldLevelEncryptionProfileError`.
    pub fn new(
        kind: GetFieldLevelEncryptionProfileErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetFieldLevelEncryptionProfileError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetFieldLevelEncryptionProfileErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetFieldLevelEncryptionProfileError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetFieldLevelEncryptionProfileErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetFieldLevelEncryptionProfileErrorKind::AccessDenied`.
    pub fn is_access_denied(&self) -> bool {
        matches!(
            &self.kind,
            GetFieldLevelEncryptionProfileErrorKind::AccessDenied(_)
        )
    }
    /// Returns `true` if the error kind is `GetFieldLevelEncryptionProfileErrorKind::NoSuchFieldLevelEncryptionProfile`.
    pub fn is_no_such_field_level_encryption_profile(&self) -> bool {
        matches!(
            &self.kind,
            GetFieldLevelEncryptionProfileErrorKind::NoSuchFieldLevelEncryptionProfile(_)
        )
    }
}
impl std::error::Error for GetFieldLevelEncryptionProfileError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetFieldLevelEncryptionProfileErrorKind::AccessDenied(_inner) => Some(_inner),
            GetFieldLevelEncryptionProfileErrorKind::NoSuchFieldLevelEncryptionProfile(_inner) => {
                Some(_inner)
            }
            GetFieldLevelEncryptionProfileErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetFieldLevelEncryptionProfileConfig` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetFieldLevelEncryptionProfileConfigError {
    /// Kind of error that occurred.
    pub kind: GetFieldLevelEncryptionProfileConfigErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetFieldLevelEncryptionProfileConfig` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetFieldLevelEncryptionProfileConfigErrorKind {
    /// <p>Access denied.</p>
    AccessDenied(crate::error::AccessDenied),
    /// <p>The specified profile for field-level encryption doesn't exist.</p>
    NoSuchFieldLevelEncryptionProfile(crate::error::NoSuchFieldLevelEncryptionProfile),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetFieldLevelEncryptionProfileConfigError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetFieldLevelEncryptionProfileConfigErrorKind::AccessDenied(_inner) => _inner.fmt(f),
            GetFieldLevelEncryptionProfileConfigErrorKind::NoSuchFieldLevelEncryptionProfile(
                _inner,
            ) => _inner.fmt(f),
            GetFieldLevelEncryptionProfileConfigErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetFieldLevelEncryptionProfileConfigError {
    fn code(&self) -> Option<&str> {
        GetFieldLevelEncryptionProfileConfigError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetFieldLevelEncryptionProfileConfigError {
    /// Creates a new `GetFieldLevelEncryptionProfileConfigError`.
    pub fn new(
        kind: GetFieldLevelEncryptionProfileConfigErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetFieldLevelEncryptionProfileConfigError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetFieldLevelEncryptionProfileConfigErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetFieldLevelEncryptionProfileConfigError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetFieldLevelEncryptionProfileConfigErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetFieldLevelEncryptionProfileConfigErrorKind::AccessDenied`.
    pub fn is_access_denied(&self) -> bool {
        matches!(
            &self.kind,
            GetFieldLevelEncryptionProfileConfigErrorKind::AccessDenied(_)
        )
    }
    /// Returns `true` if the error kind is `GetFieldLevelEncryptionProfileConfigErrorKind::NoSuchFieldLevelEncryptionProfile`.
    pub fn is_no_such_field_level_encryption_profile(&self) -> bool {
        matches!(
            &self.kind,
            GetFieldLevelEncryptionProfileConfigErrorKind::NoSuchFieldLevelEncryptionProfile(_)
        )
    }
}
impl std::error::Error for GetFieldLevelEncryptionProfileConfigError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetFieldLevelEncryptionProfileConfigErrorKind::AccessDenied(_inner) => Some(_inner),
            GetFieldLevelEncryptionProfileConfigErrorKind::NoSuchFieldLevelEncryptionProfile(
                _inner,
            ) => Some(_inner),
            GetFieldLevelEncryptionProfileConfigErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `GetFunction` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetFunctionError {
    /// Kind of error that occurred.
    pub kind: GetFunctionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetFunction` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetFunctionErrorKind {
    /// <p>The function does not exist.</p>
    NoSuchFunctionExists(crate::error::NoSuchFunctionExists),
    /// <p>This operation is not supported in this region.</p>
    UnsupportedOperation(crate::error::UnsupportedOperation),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetFunctionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetFunctionErrorKind::NoSuchFunctionExists(_inner) => _inner.fmt(f),
            GetFunctionErrorKind::UnsupportedOperation(_inner) => _inner.fmt(f),
            GetFunctionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetFunctionError {
    fn code(&self) -> Option<&str> {
        GetFunctionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetFunctionError {
    /// Creates a new `GetFunctionError`.
    pub fn new(kind: GetFunctionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetFunctionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetFunctionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetFunctionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetFunctionErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetFunctionErrorKind::NoSuchFunctionExists`.
    pub fn is_no_such_function_exists(&self) -> bool {
        matches!(&self.kind, GetFunctionErrorKind::NoSuchFunctionExists(_))
    }
    /// Returns `true` if the error kind is `GetFunctionErrorKind::UnsupportedOperation`.
    pub fn is_unsupported_operation(&self) -> bool {
        matches!(&self.kind, GetFunctionErrorKind::UnsupportedOperation(_))
    }
}
impl std::error::Error for GetFunctionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetFunctionErrorKind::NoSuchFunctionExists(_inner) => Some(_inner),
            GetFunctionErrorKind::UnsupportedOperation(_inner) => Some(_inner),
            GetFunctionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetInvalidation` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetInvalidationError {
    /// Kind of error that occurred.
    pub kind: GetInvalidationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetInvalidation` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetInvalidationErrorKind {
    /// <p>Access denied.</p>
    AccessDenied(crate::error::AccessDenied),
    /// <p>The specified distribution does not exist.</p>
    NoSuchDistribution(crate::error::NoSuchDistribution),
    /// <p>The specified invalidation does not exist.</p>
    NoSuchInvalidation(crate::error::NoSuchInvalidation),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetInvalidationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetInvalidationErrorKind::AccessDenied(_inner) => _inner.fmt(f),
            GetInvalidationErrorKind::NoSuchDistribution(_inner) => _inner.fmt(f),
            GetInvalidationErrorKind::NoSuchInvalidation(_inner) => _inner.fmt(f),
            GetInvalidationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetInvalidationError {
    fn code(&self) -> Option<&str> {
        GetInvalidationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetInvalidationError {
    /// Creates a new `GetInvalidationError`.
    pub fn new(kind: GetInvalidationErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetInvalidationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetInvalidationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetInvalidationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetInvalidationErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetInvalidationErrorKind::AccessDenied`.
    pub fn is_access_denied(&self) -> bool {
        matches!(&self.kind, GetInvalidationErrorKind::AccessDenied(_))
    }
    /// Returns `true` if the error kind is `GetInvalidationErrorKind::NoSuchDistribution`.
    pub fn is_no_such_distribution(&self) -> bool {
        matches!(&self.kind, GetInvalidationErrorKind::NoSuchDistribution(_))
    }
    /// Returns `true` if the error kind is `GetInvalidationErrorKind::NoSuchInvalidation`.
    pub fn is_no_such_invalidation(&self) -> bool {
        matches!(&self.kind, GetInvalidationErrorKind::NoSuchInvalidation(_))
    }
}
impl std::error::Error for GetInvalidationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetInvalidationErrorKind::AccessDenied(_inner) => Some(_inner),
            GetInvalidationErrorKind::NoSuchDistribution(_inner) => Some(_inner),
            GetInvalidationErrorKind::NoSuchInvalidation(_inner) => Some(_inner),
            GetInvalidationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetKeyGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetKeyGroupError {
    /// Kind of error that occurred.
    pub kind: GetKeyGroupErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetKeyGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetKeyGroupErrorKind {
    /// <p>A resource that was specified is not valid.</p>
    NoSuchResource(crate::error::NoSuchResource),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetKeyGroupError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetKeyGroupErrorKind::NoSuchResource(_inner) => _inner.fmt(f),
            GetKeyGroupErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetKeyGroupError {
    fn code(&self) -> Option<&str> {
        GetKeyGroupError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetKeyGroupError {
    /// Creates a new `GetKeyGroupError`.
    pub fn new(kind: GetKeyGroupErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetKeyGroupError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetKeyGroupErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetKeyGroupError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetKeyGroupErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetKeyGroupErrorKind::NoSuchResource`.
    pub fn is_no_such_resource(&self) -> bool {
        matches!(&self.kind, GetKeyGroupErrorKind::NoSuchResource(_))
    }
}
impl std::error::Error for GetKeyGroupError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetKeyGroupErrorKind::NoSuchResource(_inner) => Some(_inner),
            GetKeyGroupErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetKeyGroupConfig` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetKeyGroupConfigError {
    /// Kind of error that occurred.
    pub kind: GetKeyGroupConfigErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetKeyGroupConfig` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetKeyGroupConfigErrorKind {
    /// <p>A resource that was specified is not valid.</p>
    NoSuchResource(crate::error::NoSuchResource),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetKeyGroupConfigError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetKeyGroupConfigErrorKind::NoSuchResource(_inner) => _inner.fmt(f),
            GetKeyGroupConfigErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetKeyGroupConfigError {
    fn code(&self) -> Option<&str> {
        GetKeyGroupConfigError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetKeyGroupConfigError {
    /// Creates a new `GetKeyGroupConfigError`.
    pub fn new(kind: GetKeyGroupConfigErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetKeyGroupConfigError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetKeyGroupConfigErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetKeyGroupConfigError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetKeyGroupConfigErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetKeyGroupConfigErrorKind::NoSuchResource`.
    pub fn is_no_such_resource(&self) -> bool {
        matches!(&self.kind, GetKeyGroupConfigErrorKind::NoSuchResource(_))
    }
}
impl std::error::Error for GetKeyGroupConfigError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetKeyGroupConfigErrorKind::NoSuchResource(_inner) => Some(_inner),
            GetKeyGroupConfigErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetMonitoringSubscription` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetMonitoringSubscriptionError {
    /// Kind of error that occurred.
    pub kind: GetMonitoringSubscriptionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetMonitoringSubscription` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetMonitoringSubscriptionErrorKind {
    /// <p>Access denied.</p>
    AccessDenied(crate::error::AccessDenied),
    /// <p>The specified distribution does not exist.</p>
    NoSuchDistribution(crate::error::NoSuchDistribution),
    /// <p>This operation is not supported in this region.</p>
    UnsupportedOperation(crate::error::UnsupportedOperation),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetMonitoringSubscriptionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetMonitoringSubscriptionErrorKind::AccessDenied(_inner) => _inner.fmt(f),
            GetMonitoringSubscriptionErrorKind::NoSuchDistribution(_inner) => _inner.fmt(f),
            GetMonitoringSubscriptionErrorKind::UnsupportedOperation(_inner) => _inner.fmt(f),
            GetMonitoringSubscriptionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetMonitoringSubscriptionError {
    fn code(&self) -> Option<&str> {
        GetMonitoringSubscriptionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetMonitoringSubscriptionError {
    /// Creates a new `GetMonitoringSubscriptionError`.
    pub fn new(kind: GetMonitoringSubscriptionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetMonitoringSubscriptionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetMonitoringSubscriptionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetMonitoringSubscriptionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetMonitoringSubscriptionErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetMonitoringSubscriptionErrorKind::AccessDenied`.
    pub fn is_access_denied(&self) -> bool {
        matches!(
            &self.kind,
            GetMonitoringSubscriptionErrorKind::AccessDenied(_)
        )
    }
    /// Returns `true` if the error kind is `GetMonitoringSubscriptionErrorKind::NoSuchDistribution`.
    pub fn is_no_such_distribution(&self) -> bool {
        matches!(
            &self.kind,
            GetMonitoringSubscriptionErrorKind::NoSuchDistribution(_)
        )
    }
    /// Returns `true` if the error kind is `GetMonitoringSubscriptionErrorKind::UnsupportedOperation`.
    pub fn is_unsupported_operation(&self) -> bool {
        matches!(
            &self.kind,
            GetMonitoringSubscriptionErrorKind::UnsupportedOperation(_)
        )
    }
}
impl std::error::Error for GetMonitoringSubscriptionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetMonitoringSubscriptionErrorKind::AccessDenied(_inner) => Some(_inner),
            GetMonitoringSubscriptionErrorKind::NoSuchDistribution(_inner) => Some(_inner),
            GetMonitoringSubscriptionErrorKind::UnsupportedOperation(_inner) => Some(_inner),
            GetMonitoringSubscriptionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetOriginRequestPolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetOriginRequestPolicyError {
    /// Kind of error that occurred.
    pub kind: GetOriginRequestPolicyErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetOriginRequestPolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetOriginRequestPolicyErrorKind {
    /// <p>Access denied.</p>
    AccessDenied(crate::error::AccessDenied),
    /// <p>The origin request policy does not exist.</p>
    NoSuchOriginRequestPolicy(crate::error::NoSuchOriginRequestPolicy),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetOriginRequestPolicyError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetOriginRequestPolicyErrorKind::AccessDenied(_inner) => _inner.fmt(f),
            GetOriginRequestPolicyErrorKind::NoSuchOriginRequestPolicy(_inner) => _inner.fmt(f),
            GetOriginRequestPolicyErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetOriginRequestPolicyError {
    fn code(&self) -> Option<&str> {
        GetOriginRequestPolicyError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetOriginRequestPolicyError {
    /// Creates a new `GetOriginRequestPolicyError`.
    pub fn new(kind: GetOriginRequestPolicyErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetOriginRequestPolicyError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetOriginRequestPolicyErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetOriginRequestPolicyError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetOriginRequestPolicyErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetOriginRequestPolicyErrorKind::AccessDenied`.
    pub fn is_access_denied(&self) -> bool {
        matches!(&self.kind, GetOriginRequestPolicyErrorKind::AccessDenied(_))
    }
    /// Returns `true` if the error kind is `GetOriginRequestPolicyErrorKind::NoSuchOriginRequestPolicy`.
    pub fn is_no_such_origin_request_policy(&self) -> bool {
        matches!(
            &self.kind,
            GetOriginRequestPolicyErrorKind::NoSuchOriginRequestPolicy(_)
        )
    }
}
impl std::error::Error for GetOriginRequestPolicyError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetOriginRequestPolicyErrorKind::AccessDenied(_inner) => Some(_inner),
            GetOriginRequestPolicyErrorKind::NoSuchOriginRequestPolicy(_inner) => Some(_inner),
            GetOriginRequestPolicyErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetOriginRequestPolicyConfig` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetOriginRequestPolicyConfigError {
    /// Kind of error that occurred.
    pub kind: GetOriginRequestPolicyConfigErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetOriginRequestPolicyConfig` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetOriginRequestPolicyConfigErrorKind {
    /// <p>Access denied.</p>
    AccessDenied(crate::error::AccessDenied),
    /// <p>The origin request policy does not exist.</p>
    NoSuchOriginRequestPolicy(crate::error::NoSuchOriginRequestPolicy),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetOriginRequestPolicyConfigError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetOriginRequestPolicyConfigErrorKind::AccessDenied(_inner) => _inner.fmt(f),
            GetOriginRequestPolicyConfigErrorKind::NoSuchOriginRequestPolicy(_inner) => {
                _inner.fmt(f)
            }
            GetOriginRequestPolicyConfigErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetOriginRequestPolicyConfigError {
    fn code(&self) -> Option<&str> {
        GetOriginRequestPolicyConfigError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetOriginRequestPolicyConfigError {
    /// Creates a new `GetOriginRequestPolicyConfigError`.
    pub fn new(kind: GetOriginRequestPolicyConfigErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetOriginRequestPolicyConfigError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetOriginRequestPolicyConfigErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetOriginRequestPolicyConfigError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetOriginRequestPolicyConfigErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetOriginRequestPolicyConfigErrorKind::AccessDenied`.
    pub fn is_access_denied(&self) -> bool {
        matches!(
            &self.kind,
            GetOriginRequestPolicyConfigErrorKind::AccessDenied(_)
        )
    }
    /// Returns `true` if the error kind is `GetOriginRequestPolicyConfigErrorKind::NoSuchOriginRequestPolicy`.
    pub fn is_no_such_origin_request_policy(&self) -> bool {
        matches!(
            &self.kind,
            GetOriginRequestPolicyConfigErrorKind::NoSuchOriginRequestPolicy(_)
        )
    }
}
impl std::error::Error for GetOriginRequestPolicyConfigError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetOriginRequestPolicyConfigErrorKind::AccessDenied(_inner) => Some(_inner),
            GetOriginRequestPolicyConfigErrorKind::NoSuchOriginRequestPolicy(_inner) => {
                Some(_inner)
            }
            GetOriginRequestPolicyConfigErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetPublicKey` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetPublicKeyError {
    /// Kind of error that occurred.
    pub kind: GetPublicKeyErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetPublicKey` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetPublicKeyErrorKind {
    /// <p>Access denied.</p>
    AccessDenied(crate::error::AccessDenied),
    /// <p>The specified public key doesn't exist.</p>
    NoSuchPublicKey(crate::error::NoSuchPublicKey),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetPublicKeyError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetPublicKeyErrorKind::AccessDenied(_inner) => _inner.fmt(f),
            GetPublicKeyErrorKind::NoSuchPublicKey(_inner) => _inner.fmt(f),
            GetPublicKeyErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetPublicKeyError {
    fn code(&self) -> Option<&str> {
        GetPublicKeyError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetPublicKeyError {
    /// Creates a new `GetPublicKeyError`.
    pub fn new(kind: GetPublicKeyErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetPublicKeyError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetPublicKeyErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetPublicKeyError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetPublicKeyErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetPublicKeyErrorKind::AccessDenied`.
    pub fn is_access_denied(&self) -> bool {
        matches!(&self.kind, GetPublicKeyErrorKind::AccessDenied(_))
    }
    /// Returns `true` if the error kind is `GetPublicKeyErrorKind::NoSuchPublicKey`.
    pub fn is_no_such_public_key(&self) -> bool {
        matches!(&self.kind, GetPublicKeyErrorKind::NoSuchPublicKey(_))
    }
}
impl std::error::Error for GetPublicKeyError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetPublicKeyErrorKind::AccessDenied(_inner) => Some(_inner),
            GetPublicKeyErrorKind::NoSuchPublicKey(_inner) => Some(_inner),
            GetPublicKeyErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetPublicKeyConfig` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetPublicKeyConfigError {
    /// Kind of error that occurred.
    pub kind: GetPublicKeyConfigErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetPublicKeyConfig` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetPublicKeyConfigErrorKind {
    /// <p>Access denied.</p>
    AccessDenied(crate::error::AccessDenied),
    /// <p>The specified public key doesn't exist.</p>
    NoSuchPublicKey(crate::error::NoSuchPublicKey),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetPublicKeyConfigError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetPublicKeyConfigErrorKind::AccessDenied(_inner) => _inner.fmt(f),
            GetPublicKeyConfigErrorKind::NoSuchPublicKey(_inner) => _inner.fmt(f),
            GetPublicKeyConfigErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetPublicKeyConfigError {
    fn code(&self) -> Option<&str> {
        GetPublicKeyConfigError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetPublicKeyConfigError {
    /// Creates a new `GetPublicKeyConfigError`.
    pub fn new(kind: GetPublicKeyConfigErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetPublicKeyConfigError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetPublicKeyConfigErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetPublicKeyConfigError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetPublicKeyConfigErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetPublicKeyConfigErrorKind::AccessDenied`.
    pub fn is_access_denied(&self) -> bool {
        matches!(&self.kind, GetPublicKeyConfigErrorKind::AccessDenied(_))
    }
    /// Returns `true` if the error kind is `GetPublicKeyConfigErrorKind::NoSuchPublicKey`.
    pub fn is_no_such_public_key(&self) -> bool {
        matches!(&self.kind, GetPublicKeyConfigErrorKind::NoSuchPublicKey(_))
    }
}
impl std::error::Error for GetPublicKeyConfigError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetPublicKeyConfigErrorKind::AccessDenied(_inner) => Some(_inner),
            GetPublicKeyConfigErrorKind::NoSuchPublicKey(_inner) => Some(_inner),
            GetPublicKeyConfigErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetRealtimeLogConfig` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetRealtimeLogConfigError {
    /// Kind of error that occurred.
    pub kind: GetRealtimeLogConfigErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetRealtimeLogConfig` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetRealtimeLogConfigErrorKind {
    /// <p>Access denied.</p>
    AccessDenied(crate::error::AccessDenied),
    /// <p>An argument is invalid.</p>
    InvalidArgument(crate::error::InvalidArgument),
    /// <p>The real-time log configuration does not exist.</p>
    NoSuchRealtimeLogConfig(crate::error::NoSuchRealtimeLogConfig),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetRealtimeLogConfigError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetRealtimeLogConfigErrorKind::AccessDenied(_inner) => _inner.fmt(f),
            GetRealtimeLogConfigErrorKind::InvalidArgument(_inner) => _inner.fmt(f),
            GetRealtimeLogConfigErrorKind::NoSuchRealtimeLogConfig(_inner) => _inner.fmt(f),
            GetRealtimeLogConfigErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetRealtimeLogConfigError {
    fn code(&self) -> Option<&str> {
        GetRealtimeLogConfigError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetRealtimeLogConfigError {
    /// Creates a new `GetRealtimeLogConfigError`.
    pub fn new(kind: GetRealtimeLogConfigErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetRealtimeLogConfigError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetRealtimeLogConfigErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetRealtimeLogConfigError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetRealtimeLogConfigErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetRealtimeLogConfigErrorKind::AccessDenied`.
    pub fn is_access_denied(&self) -> bool {
        matches!(&self.kind, GetRealtimeLogConfigErrorKind::AccessDenied(_))
    }
    /// Returns `true` if the error kind is `GetRealtimeLogConfigErrorKind::InvalidArgument`.
    pub fn is_invalid_argument(&self) -> bool {
        matches!(
            &self.kind,
            GetRealtimeLogConfigErrorKind::InvalidArgument(_)
        )
    }
    /// Returns `true` if the error kind is `GetRealtimeLogConfigErrorKind::NoSuchRealtimeLogConfig`.
    pub fn is_no_such_realtime_log_config(&self) -> bool {
        matches!(
            &self.kind,
            GetRealtimeLogConfigErrorKind::NoSuchRealtimeLogConfig(_)
        )
    }
}
impl std::error::Error for GetRealtimeLogConfigError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetRealtimeLogConfigErrorKind::AccessDenied(_inner) => Some(_inner),
            GetRealtimeLogConfigErrorKind::InvalidArgument(_inner) => Some(_inner),
            GetRealtimeLogConfigErrorKind::NoSuchRealtimeLogConfig(_inner) => Some(_inner),
            GetRealtimeLogConfigErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetResponseHeadersPolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetResponseHeadersPolicyError {
    /// Kind of error that occurred.
    pub kind: GetResponseHeadersPolicyErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetResponseHeadersPolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetResponseHeadersPolicyErrorKind {
    /// <p>Access denied.</p>
    AccessDenied(crate::error::AccessDenied),
    /// <p>The response headers policy does not exist.</p>
    NoSuchResponseHeadersPolicy(crate::error::NoSuchResponseHeadersPolicy),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetResponseHeadersPolicyError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetResponseHeadersPolicyErrorKind::AccessDenied(_inner) => _inner.fmt(f),
            GetResponseHeadersPolicyErrorKind::NoSuchResponseHeadersPolicy(_inner) => _inner.fmt(f),
            GetResponseHeadersPolicyErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetResponseHeadersPolicyError {
    fn code(&self) -> Option<&str> {
        GetResponseHeadersPolicyError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetResponseHeadersPolicyError {
    /// Creates a new `GetResponseHeadersPolicyError`.
    pub fn new(kind: GetResponseHeadersPolicyErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetResponseHeadersPolicyError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetResponseHeadersPolicyErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetResponseHeadersPolicyError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetResponseHeadersPolicyErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetResponseHeadersPolicyErrorKind::AccessDenied`.
    pub fn is_access_denied(&self) -> bool {
        matches!(
            &self.kind,
            GetResponseHeadersPolicyErrorKind::AccessDenied(_)
        )
    }
    /// Returns `true` if the error kind is `GetResponseHeadersPolicyErrorKind::NoSuchResponseHeadersPolicy`.
    pub fn is_no_such_response_headers_policy(&self) -> bool {
        matches!(
            &self.kind,
            GetResponseHeadersPolicyErrorKind::NoSuchResponseHeadersPolicy(_)
        )
    }
}
impl std::error::Error for GetResponseHeadersPolicyError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetResponseHeadersPolicyErrorKind::AccessDenied(_inner) => Some(_inner),
            GetResponseHeadersPolicyErrorKind::NoSuchResponseHeadersPolicy(_inner) => Some(_inner),
            GetResponseHeadersPolicyErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetResponseHeadersPolicyConfig` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetResponseHeadersPolicyConfigError {
    /// Kind of error that occurred.
    pub kind: GetResponseHeadersPolicyConfigErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetResponseHeadersPolicyConfig` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetResponseHeadersPolicyConfigErrorKind {
    /// <p>Access denied.</p>
    AccessDenied(crate::error::AccessDenied),
    /// <p>The response headers policy does not exist.</p>
    NoSuchResponseHeadersPolicy(crate::error::NoSuchResponseHeadersPolicy),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetResponseHeadersPolicyConfigError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetResponseHeadersPolicyConfigErrorKind::AccessDenied(_inner) => _inner.fmt(f),
            GetResponseHeadersPolicyConfigErrorKind::NoSuchResponseHeadersPolicy(_inner) => {
                _inner.fmt(f)
            }
            GetResponseHeadersPolicyConfigErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetResponseHeadersPolicyConfigError {
    fn code(&self) -> Option<&str> {
        GetResponseHeadersPolicyConfigError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetResponseHeadersPolicyConfigError {
    /// Creates a new `GetResponseHeadersPolicyConfigError`.
    pub fn new(
        kind: GetResponseHeadersPolicyConfigErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetResponseHeadersPolicyConfigError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetResponseHeadersPolicyConfigErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetResponseHeadersPolicyConfigError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetResponseHeadersPolicyConfigErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetResponseHeadersPolicyConfigErrorKind::AccessDenied`.
    pub fn is_access_denied(&self) -> bool {
        matches!(
            &self.kind,
            GetResponseHeadersPolicyConfigErrorKind::AccessDenied(_)
        )
    }
    /// Returns `true` if the error kind is `GetResponseHeadersPolicyConfigErrorKind::NoSuchResponseHeadersPolicy`.
    pub fn is_no_such_response_headers_policy(&self) -> bool {
        matches!(
            &self.kind,
            GetResponseHeadersPolicyConfigErrorKind::NoSuchResponseHeadersPolicy(_)
        )
    }
}
impl std::error::Error for GetResponseHeadersPolicyConfigError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetResponseHeadersPolicyConfigErrorKind::AccessDenied(_inner) => Some(_inner),
            GetResponseHeadersPolicyConfigErrorKind::NoSuchResponseHeadersPolicy(_inner) => {
                Some(_inner)
            }
            GetResponseHeadersPolicyConfigErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetStreamingDistribution` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetStreamingDistributionError {
    /// Kind of error that occurred.
    pub kind: GetStreamingDistributionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetStreamingDistribution` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetStreamingDistributionErrorKind {
    /// <p>Access denied.</p>
    AccessDenied(crate::error::AccessDenied),
    /// <p>The specified streaming distribution does not exist.</p>
    NoSuchStreamingDistribution(crate::error::NoSuchStreamingDistribution),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetStreamingDistributionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetStreamingDistributionErrorKind::AccessDenied(_inner) => _inner.fmt(f),
            GetStreamingDistributionErrorKind::NoSuchStreamingDistribution(_inner) => _inner.fmt(f),
            GetStreamingDistributionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetStreamingDistributionError {
    fn code(&self) -> Option<&str> {
        GetStreamingDistributionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetStreamingDistributionError {
    /// Creates a new `GetStreamingDistributionError`.
    pub fn new(kind: GetStreamingDistributionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetStreamingDistributionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetStreamingDistributionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetStreamingDistributionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetStreamingDistributionErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetStreamingDistributionErrorKind::AccessDenied`.
    pub fn is_access_denied(&self) -> bool {
        matches!(
            &self.kind,
            GetStreamingDistributionErrorKind::AccessDenied(_)
        )
    }
    /// Returns `true` if the error kind is `GetStreamingDistributionErrorKind::NoSuchStreamingDistribution`.
    pub fn is_no_such_streaming_distribution(&self) -> bool {
        matches!(
            &self.kind,
            GetStreamingDistributionErrorKind::NoSuchStreamingDistribution(_)
        )
    }
}
impl std::error::Error for GetStreamingDistributionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetStreamingDistributionErrorKind::AccessDenied(_inner) => Some(_inner),
            GetStreamingDistributionErrorKind::NoSuchStreamingDistribution(_inner) => Some(_inner),
            GetStreamingDistributionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetStreamingDistributionConfig` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetStreamingDistributionConfigError {
    /// Kind of error that occurred.
    pub kind: GetStreamingDistributionConfigErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetStreamingDistributionConfig` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetStreamingDistributionConfigErrorKind {
    /// <p>Access denied.</p>
    AccessDenied(crate::error::AccessDenied),
    /// <p>The specified streaming distribution does not exist.</p>
    NoSuchStreamingDistribution(crate::error::NoSuchStreamingDistribution),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetStreamingDistributionConfigError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetStreamingDistributionConfigErrorKind::AccessDenied(_inner) => _inner.fmt(f),
            GetStreamingDistributionConfigErrorKind::NoSuchStreamingDistribution(_inner) => {
                _inner.fmt(f)
            }
            GetStreamingDistributionConfigErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetStreamingDistributionConfigError {
    fn code(&self) -> Option<&str> {
        GetStreamingDistributionConfigError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetStreamingDistributionConfigError {
    /// Creates a new `GetStreamingDistributionConfigError`.
    pub fn new(
        kind: GetStreamingDistributionConfigErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetStreamingDistributionConfigError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetStreamingDistributionConfigErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetStreamingDistributionConfigError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetStreamingDistributionConfigErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetStreamingDistributionConfigErrorKind::AccessDenied`.
    pub fn is_access_denied(&self) -> bool {
        matches!(
            &self.kind,
            GetStreamingDistributionConfigErrorKind::AccessDenied(_)
        )
    }
    /// Returns `true` if the error kind is `GetStreamingDistributionConfigErrorKind::NoSuchStreamingDistribution`.
    pub fn is_no_such_streaming_distribution(&self) -> bool {
        matches!(
            &self.kind,
            GetStreamingDistributionConfigErrorKind::NoSuchStreamingDistribution(_)
        )
    }
}
impl std::error::Error for GetStreamingDistributionConfigError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetStreamingDistributionConfigErrorKind::AccessDenied(_inner) => Some(_inner),
            GetStreamingDistributionConfigErrorKind::NoSuchStreamingDistribution(_inner) => {
                Some(_inner)
            }
            GetStreamingDistributionConfigErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListCachePolicies` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListCachePoliciesError {
    /// Kind of error that occurred.
    pub kind: ListCachePoliciesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListCachePolicies` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListCachePoliciesErrorKind {
    /// <p>Access denied.</p>
    AccessDenied(crate::error::AccessDenied),
    /// <p>An argument is invalid.</p>
    InvalidArgument(crate::error::InvalidArgument),
    /// <p>The cache policy does not exist.</p>
    NoSuchCachePolicy(crate::error::NoSuchCachePolicy),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListCachePoliciesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListCachePoliciesErrorKind::AccessDenied(_inner) => _inner.fmt(f),
            ListCachePoliciesErrorKind::InvalidArgument(_inner) => _inner.fmt(f),
            ListCachePoliciesErrorKind::NoSuchCachePolicy(_inner) => _inner.fmt(f),
            ListCachePoliciesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListCachePoliciesError {
    fn code(&self) -> Option<&str> {
        ListCachePoliciesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListCachePoliciesError {
    /// Creates a new `ListCachePoliciesError`.
    pub fn new(kind: ListCachePoliciesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListCachePoliciesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListCachePoliciesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListCachePoliciesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListCachePoliciesErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListCachePoliciesErrorKind::AccessDenied`.
    pub fn is_access_denied(&self) -> bool {
        matches!(&self.kind, ListCachePoliciesErrorKind::AccessDenied(_))
    }
    /// Returns `true` if the error kind is `ListCachePoliciesErrorKind::InvalidArgument`.
    pub fn is_invalid_argument(&self) -> bool {
        matches!(&self.kind, ListCachePoliciesErrorKind::InvalidArgument(_))
    }
    /// Returns `true` if the error kind is `ListCachePoliciesErrorKind::NoSuchCachePolicy`.
    pub fn is_no_such_cache_policy(&self) -> bool {
        matches!(&self.kind, ListCachePoliciesErrorKind::NoSuchCachePolicy(_))
    }
}
impl std::error::Error for ListCachePoliciesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListCachePoliciesErrorKind::AccessDenied(_inner) => Some(_inner),
            ListCachePoliciesErrorKind::InvalidArgument(_inner) => Some(_inner),
            ListCachePoliciesErrorKind::NoSuchCachePolicy(_inner) => Some(_inner),
            ListCachePoliciesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListCloudFrontOriginAccessIdentities` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListCloudFrontOriginAccessIdentitiesError {
    /// Kind of error that occurred.
    pub kind: ListCloudFrontOriginAccessIdentitiesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListCloudFrontOriginAccessIdentities` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListCloudFrontOriginAccessIdentitiesErrorKind {
    /// <p>An argument is invalid.</p>
    InvalidArgument(crate::error::InvalidArgument),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListCloudFrontOriginAccessIdentitiesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListCloudFrontOriginAccessIdentitiesErrorKind::InvalidArgument(_inner) => _inner.fmt(f),
            ListCloudFrontOriginAccessIdentitiesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListCloudFrontOriginAccessIdentitiesError {
    fn code(&self) -> Option<&str> {
        ListCloudFrontOriginAccessIdentitiesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListCloudFrontOriginAccessIdentitiesError {
    /// Creates a new `ListCloudFrontOriginAccessIdentitiesError`.
    pub fn new(
        kind: ListCloudFrontOriginAccessIdentitiesErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListCloudFrontOriginAccessIdentitiesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListCloudFrontOriginAccessIdentitiesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListCloudFrontOriginAccessIdentitiesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListCloudFrontOriginAccessIdentitiesErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListCloudFrontOriginAccessIdentitiesErrorKind::InvalidArgument`.
    pub fn is_invalid_argument(&self) -> bool {
        matches!(
            &self.kind,
            ListCloudFrontOriginAccessIdentitiesErrorKind::InvalidArgument(_)
        )
    }
}
impl std::error::Error for ListCloudFrontOriginAccessIdentitiesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListCloudFrontOriginAccessIdentitiesErrorKind::InvalidArgument(_inner) => Some(_inner),
            ListCloudFrontOriginAccessIdentitiesErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `ListConflictingAliases` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListConflictingAliasesError {
    /// Kind of error that occurred.
    pub kind: ListConflictingAliasesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListConflictingAliases` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListConflictingAliasesErrorKind {
    /// <p>An argument is invalid.</p>
    InvalidArgument(crate::error::InvalidArgument),
    /// <p>The specified distribution does not exist.</p>
    NoSuchDistribution(crate::error::NoSuchDistribution),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListConflictingAliasesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListConflictingAliasesErrorKind::InvalidArgument(_inner) => _inner.fmt(f),
            ListConflictingAliasesErrorKind::NoSuchDistribution(_inner) => _inner.fmt(f),
            ListConflictingAliasesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListConflictingAliasesError {
    fn code(&self) -> Option<&str> {
        ListConflictingAliasesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListConflictingAliasesError {
    /// Creates a new `ListConflictingAliasesError`.
    pub fn new(kind: ListConflictingAliasesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListConflictingAliasesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListConflictingAliasesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListConflictingAliasesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListConflictingAliasesErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListConflictingAliasesErrorKind::InvalidArgument`.
    pub fn is_invalid_argument(&self) -> bool {
        matches!(
            &self.kind,
            ListConflictingAliasesErrorKind::InvalidArgument(_)
        )
    }
    /// Returns `true` if the error kind is `ListConflictingAliasesErrorKind::NoSuchDistribution`.
    pub fn is_no_such_distribution(&self) -> bool {
        matches!(
            &self.kind,
            ListConflictingAliasesErrorKind::NoSuchDistribution(_)
        )
    }
}
impl std::error::Error for ListConflictingAliasesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListConflictingAliasesErrorKind::InvalidArgument(_inner) => Some(_inner),
            ListConflictingAliasesErrorKind::NoSuchDistribution(_inner) => Some(_inner),
            ListConflictingAliasesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListDistributions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListDistributionsError {
    /// Kind of error that occurred.
    pub kind: ListDistributionsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListDistributions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListDistributionsErrorKind {
    /// <p>An argument is invalid.</p>
    InvalidArgument(crate::error::InvalidArgument),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListDistributionsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListDistributionsErrorKind::InvalidArgument(_inner) => _inner.fmt(f),
            ListDistributionsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListDistributionsError {
    fn code(&self) -> Option<&str> {
        ListDistributionsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListDistributionsError {
    /// Creates a new `ListDistributionsError`.
    pub fn new(kind: ListDistributionsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListDistributionsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListDistributionsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListDistributionsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListDistributionsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListDistributionsErrorKind::InvalidArgument`.
    pub fn is_invalid_argument(&self) -> bool {
        matches!(&self.kind, ListDistributionsErrorKind::InvalidArgument(_))
    }
}
impl std::error::Error for ListDistributionsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListDistributionsErrorKind::InvalidArgument(_inner) => Some(_inner),
            ListDistributionsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListDistributionsByCachePolicyId` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListDistributionsByCachePolicyIdError {
    /// Kind of error that occurred.
    pub kind: ListDistributionsByCachePolicyIdErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListDistributionsByCachePolicyId` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListDistributionsByCachePolicyIdErrorKind {
    /// <p>Access denied.</p>
    AccessDenied(crate::error::AccessDenied),
    /// <p>An argument is invalid.</p>
    InvalidArgument(crate::error::InvalidArgument),
    /// <p>The cache policy does not exist.</p>
    NoSuchCachePolicy(crate::error::NoSuchCachePolicy),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListDistributionsByCachePolicyIdError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListDistributionsByCachePolicyIdErrorKind::AccessDenied(_inner) => _inner.fmt(f),
            ListDistributionsByCachePolicyIdErrorKind::InvalidArgument(_inner) => _inner.fmt(f),
            ListDistributionsByCachePolicyIdErrorKind::NoSuchCachePolicy(_inner) => _inner.fmt(f),
            ListDistributionsByCachePolicyIdErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListDistributionsByCachePolicyIdError {
    fn code(&self) -> Option<&str> {
        ListDistributionsByCachePolicyIdError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListDistributionsByCachePolicyIdError {
    /// Creates a new `ListDistributionsByCachePolicyIdError`.
    pub fn new(
        kind: ListDistributionsByCachePolicyIdErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListDistributionsByCachePolicyIdError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListDistributionsByCachePolicyIdErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListDistributionsByCachePolicyIdError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListDistributionsByCachePolicyIdErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListDistributionsByCachePolicyIdErrorKind::AccessDenied`.
    pub fn is_access_denied(&self) -> bool {
        matches!(
            &self.kind,
            ListDistributionsByCachePolicyIdErrorKind::AccessDenied(_)
        )
    }
    /// Returns `true` if the error kind is `ListDistributionsByCachePolicyIdErrorKind::InvalidArgument`.
    pub fn is_invalid_argument(&self) -> bool {
        matches!(
            &self.kind,
            ListDistributionsByCachePolicyIdErrorKind::InvalidArgument(_)
        )
    }
    /// Returns `true` if the error kind is `ListDistributionsByCachePolicyIdErrorKind::NoSuchCachePolicy`.
    pub fn is_no_such_cache_policy(&self) -> bool {
        matches!(
            &self.kind,
            ListDistributionsByCachePolicyIdErrorKind::NoSuchCachePolicy(_)
        )
    }
}
impl std::error::Error for ListDistributionsByCachePolicyIdError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListDistributionsByCachePolicyIdErrorKind::AccessDenied(_inner) => Some(_inner),
            ListDistributionsByCachePolicyIdErrorKind::InvalidArgument(_inner) => Some(_inner),
            ListDistributionsByCachePolicyIdErrorKind::NoSuchCachePolicy(_inner) => Some(_inner),
            ListDistributionsByCachePolicyIdErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListDistributionsByKeyGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListDistributionsByKeyGroupError {
    /// Kind of error that occurred.
    pub kind: ListDistributionsByKeyGroupErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListDistributionsByKeyGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListDistributionsByKeyGroupErrorKind {
    /// <p>An argument is invalid.</p>
    InvalidArgument(crate::error::InvalidArgument),
    /// <p>A resource that was specified is not valid.</p>
    NoSuchResource(crate::error::NoSuchResource),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListDistributionsByKeyGroupError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListDistributionsByKeyGroupErrorKind::InvalidArgument(_inner) => _inner.fmt(f),
            ListDistributionsByKeyGroupErrorKind::NoSuchResource(_inner) => _inner.fmt(f),
            ListDistributionsByKeyGroupErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListDistributionsByKeyGroupError {
    fn code(&self) -> Option<&str> {
        ListDistributionsByKeyGroupError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListDistributionsByKeyGroupError {
    /// Creates a new `ListDistributionsByKeyGroupError`.
    pub fn new(kind: ListDistributionsByKeyGroupErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListDistributionsByKeyGroupError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListDistributionsByKeyGroupErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListDistributionsByKeyGroupError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListDistributionsByKeyGroupErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListDistributionsByKeyGroupErrorKind::InvalidArgument`.
    pub fn is_invalid_argument(&self) -> bool {
        matches!(
            &self.kind,
            ListDistributionsByKeyGroupErrorKind::InvalidArgument(_)
        )
    }
    /// Returns `true` if the error kind is `ListDistributionsByKeyGroupErrorKind::NoSuchResource`.
    pub fn is_no_such_resource(&self) -> bool {
        matches!(
            &self.kind,
            ListDistributionsByKeyGroupErrorKind::NoSuchResource(_)
        )
    }
}
impl std::error::Error for ListDistributionsByKeyGroupError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListDistributionsByKeyGroupErrorKind::InvalidArgument(_inner) => Some(_inner),
            ListDistributionsByKeyGroupErrorKind::NoSuchResource(_inner) => Some(_inner),
            ListDistributionsByKeyGroupErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListDistributionsByOriginRequestPolicyId` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListDistributionsByOriginRequestPolicyIdError {
    /// Kind of error that occurred.
    pub kind: ListDistributionsByOriginRequestPolicyIdErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListDistributionsByOriginRequestPolicyId` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListDistributionsByOriginRequestPolicyIdErrorKind {
    /// <p>Access denied.</p>
    AccessDenied(crate::error::AccessDenied),
    /// <p>An argument is invalid.</p>
    InvalidArgument(crate::error::InvalidArgument),
    /// <p>The origin request policy does not exist.</p>
    NoSuchOriginRequestPolicy(crate::error::NoSuchOriginRequestPolicy),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListDistributionsByOriginRequestPolicyIdError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListDistributionsByOriginRequestPolicyIdErrorKind::AccessDenied(_inner) => {
                _inner.fmt(f)
            }
            ListDistributionsByOriginRequestPolicyIdErrorKind::InvalidArgument(_inner) => {
                _inner.fmt(f)
            }
            ListDistributionsByOriginRequestPolicyIdErrorKind::NoSuchOriginRequestPolicy(
                _inner,
            ) => _inner.fmt(f),
            ListDistributionsByOriginRequestPolicyIdErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListDistributionsByOriginRequestPolicyIdError {
    fn code(&self) -> Option<&str> {
        ListDistributionsByOriginRequestPolicyIdError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListDistributionsByOriginRequestPolicyIdError {
    /// Creates a new `ListDistributionsByOriginRequestPolicyIdError`.
    pub fn new(
        kind: ListDistributionsByOriginRequestPolicyIdErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListDistributionsByOriginRequestPolicyIdError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListDistributionsByOriginRequestPolicyIdErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListDistributionsByOriginRequestPolicyIdError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListDistributionsByOriginRequestPolicyIdErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListDistributionsByOriginRequestPolicyIdErrorKind::AccessDenied`.
    pub fn is_access_denied(&self) -> bool {
        matches!(
            &self.kind,
            ListDistributionsByOriginRequestPolicyIdErrorKind::AccessDenied(_)
        )
    }
    /// Returns `true` if the error kind is `ListDistributionsByOriginRequestPolicyIdErrorKind::InvalidArgument`.
    pub fn is_invalid_argument(&self) -> bool {
        matches!(
            &self.kind,
            ListDistributionsByOriginRequestPolicyIdErrorKind::InvalidArgument(_)
        )
    }
    /// Returns `true` if the error kind is `ListDistributionsByOriginRequestPolicyIdErrorKind::NoSuchOriginRequestPolicy`.
    pub fn is_no_such_origin_request_policy(&self) -> bool {
        matches!(
            &self.kind,
            ListDistributionsByOriginRequestPolicyIdErrorKind::NoSuchOriginRequestPolicy(_)
        )
    }
}
impl std::error::Error for ListDistributionsByOriginRequestPolicyIdError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListDistributionsByOriginRequestPolicyIdErrorKind::AccessDenied(_inner) => Some(_inner),
            ListDistributionsByOriginRequestPolicyIdErrorKind::InvalidArgument(_inner) => {
                Some(_inner)
            }
            ListDistributionsByOriginRequestPolicyIdErrorKind::NoSuchOriginRequestPolicy(
                _inner,
            ) => Some(_inner),
            ListDistributionsByOriginRequestPolicyIdErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `ListDistributionsByRealtimeLogConfig` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListDistributionsByRealtimeLogConfigError {
    /// Kind of error that occurred.
    pub kind: ListDistributionsByRealtimeLogConfigErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListDistributionsByRealtimeLogConfig` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListDistributionsByRealtimeLogConfigErrorKind {
    /// <p>An argument is invalid.</p>
    InvalidArgument(crate::error::InvalidArgument),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListDistributionsByRealtimeLogConfigError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListDistributionsByRealtimeLogConfigErrorKind::InvalidArgument(_inner) => _inner.fmt(f),
            ListDistributionsByRealtimeLogConfigErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListDistributionsByRealtimeLogConfigError {
    fn code(&self) -> Option<&str> {
        ListDistributionsByRealtimeLogConfigError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListDistributionsByRealtimeLogConfigError {
    /// Creates a new `ListDistributionsByRealtimeLogConfigError`.
    pub fn new(
        kind: ListDistributionsByRealtimeLogConfigErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListDistributionsByRealtimeLogConfigError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListDistributionsByRealtimeLogConfigErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListDistributionsByRealtimeLogConfigError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListDistributionsByRealtimeLogConfigErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListDistributionsByRealtimeLogConfigErrorKind::InvalidArgument`.
    pub fn is_invalid_argument(&self) -> bool {
        matches!(
            &self.kind,
            ListDistributionsByRealtimeLogConfigErrorKind::InvalidArgument(_)
        )
    }
}
impl std::error::Error for ListDistributionsByRealtimeLogConfigError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListDistributionsByRealtimeLogConfigErrorKind::InvalidArgument(_inner) => Some(_inner),
            ListDistributionsByRealtimeLogConfigErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `ListDistributionsByResponseHeadersPolicyId` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListDistributionsByResponseHeadersPolicyIdError {
    /// Kind of error that occurred.
    pub kind: ListDistributionsByResponseHeadersPolicyIdErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListDistributionsByResponseHeadersPolicyId` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListDistributionsByResponseHeadersPolicyIdErrorKind {
    /// <p>Access denied.</p>
    AccessDenied(crate::error::AccessDenied),
    /// <p>An argument is invalid.</p>
    InvalidArgument(crate::error::InvalidArgument),
    /// <p>The response headers policy does not exist.</p>
    NoSuchResponseHeadersPolicy(crate::error::NoSuchResponseHeadersPolicy),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListDistributionsByResponseHeadersPolicyIdError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListDistributionsByResponseHeadersPolicyIdErrorKind::AccessDenied(_inner) => {
                _inner.fmt(f)
            }
            ListDistributionsByResponseHeadersPolicyIdErrorKind::InvalidArgument(_inner) => {
                _inner.fmt(f)
            }
            ListDistributionsByResponseHeadersPolicyIdErrorKind::NoSuchResponseHeadersPolicy(
                _inner,
            ) => _inner.fmt(f),
            ListDistributionsByResponseHeadersPolicyIdErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListDistributionsByResponseHeadersPolicyIdError {
    fn code(&self) -> Option<&str> {
        ListDistributionsByResponseHeadersPolicyIdError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListDistributionsByResponseHeadersPolicyIdError {
    /// Creates a new `ListDistributionsByResponseHeadersPolicyIdError`.
    pub fn new(
        kind: ListDistributionsByResponseHeadersPolicyIdErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListDistributionsByResponseHeadersPolicyIdError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListDistributionsByResponseHeadersPolicyIdErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListDistributionsByResponseHeadersPolicyIdError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListDistributionsByResponseHeadersPolicyIdErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListDistributionsByResponseHeadersPolicyIdErrorKind::AccessDenied`.
    pub fn is_access_denied(&self) -> bool {
        matches!(
            &self.kind,
            ListDistributionsByResponseHeadersPolicyIdErrorKind::AccessDenied(_)
        )
    }
    /// Returns `true` if the error kind is `ListDistributionsByResponseHeadersPolicyIdErrorKind::InvalidArgument`.
    pub fn is_invalid_argument(&self) -> bool {
        matches!(
            &self.kind,
            ListDistributionsByResponseHeadersPolicyIdErrorKind::InvalidArgument(_)
        )
    }
    /// Returns `true` if the error kind is `ListDistributionsByResponseHeadersPolicyIdErrorKind::NoSuchResponseHeadersPolicy`.
    pub fn is_no_such_response_headers_policy(&self) -> bool {
        matches!(
            &self.kind,
            ListDistributionsByResponseHeadersPolicyIdErrorKind::NoSuchResponseHeadersPolicy(_)
        )
    }
}
impl std::error::Error for ListDistributionsByResponseHeadersPolicyIdError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListDistributionsByResponseHeadersPolicyIdErrorKind::AccessDenied(_inner) => {
                Some(_inner)
            }
            ListDistributionsByResponseHeadersPolicyIdErrorKind::InvalidArgument(_inner) => {
                Some(_inner)
            }
            ListDistributionsByResponseHeadersPolicyIdErrorKind::NoSuchResponseHeadersPolicy(
                _inner,
            ) => Some(_inner),
            ListDistributionsByResponseHeadersPolicyIdErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `ListDistributionsByWebACLId` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListDistributionsByWebACLIdError {
    /// Kind of error that occurred.
    pub kind: ListDistributionsByWebACLIdErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListDistributionsByWebACLId` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListDistributionsByWebACLIdErrorKind {
    /// <p>An argument is invalid.</p>
    InvalidArgument(crate::error::InvalidArgument),
    /// <p>A web ACL ID specified is not valid. To specify a web ACL created using the latest version of WAF, use the ACL ARN, for example <code>arn:aws:wafv2:us-east-1:123456789012:global/webacl/ExampleWebACL/473e64fd-f30b-4765-81a0-62ad96dd167a</code>. To specify a web ACL created using WAF Classic, use the ACL ID, for example <code>473e64fd-f30b-4765-81a0-62ad96dd167a</code>.</p>
    InvalidWebAclId(crate::error::InvalidWebAclId),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListDistributionsByWebACLIdError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListDistributionsByWebACLIdErrorKind::InvalidArgument(_inner) => _inner.fmt(f),
            ListDistributionsByWebACLIdErrorKind::InvalidWebAclId(_inner) => _inner.fmt(f),
            ListDistributionsByWebACLIdErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListDistributionsByWebACLIdError {
    fn code(&self) -> Option<&str> {
        ListDistributionsByWebACLIdError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListDistributionsByWebACLIdError {
    /// Creates a new `ListDistributionsByWebACLIdError`.
    pub fn new(kind: ListDistributionsByWebACLIdErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListDistributionsByWebACLIdError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListDistributionsByWebACLIdErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListDistributionsByWebACLIdError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListDistributionsByWebACLIdErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListDistributionsByWebACLIdErrorKind::InvalidArgument`.
    pub fn is_invalid_argument(&self) -> bool {
        matches!(
            &self.kind,
            ListDistributionsByWebACLIdErrorKind::InvalidArgument(_)
        )
    }
    /// Returns `true` if the error kind is `ListDistributionsByWebACLIdErrorKind::InvalidWebAclId`.
    pub fn is_invalid_web_acl_id(&self) -> bool {
        matches!(
            &self.kind,
            ListDistributionsByWebACLIdErrorKind::InvalidWebAclId(_)
        )
    }
}
impl std::error::Error for ListDistributionsByWebACLIdError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListDistributionsByWebACLIdErrorKind::InvalidArgument(_inner) => Some(_inner),
            ListDistributionsByWebACLIdErrorKind::InvalidWebAclId(_inner) => Some(_inner),
            ListDistributionsByWebACLIdErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListFieldLevelEncryptionConfigs` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListFieldLevelEncryptionConfigsError {
    /// Kind of error that occurred.
    pub kind: ListFieldLevelEncryptionConfigsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListFieldLevelEncryptionConfigs` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListFieldLevelEncryptionConfigsErrorKind {
    /// <p>An argument is invalid.</p>
    InvalidArgument(crate::error::InvalidArgument),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListFieldLevelEncryptionConfigsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListFieldLevelEncryptionConfigsErrorKind::InvalidArgument(_inner) => _inner.fmt(f),
            ListFieldLevelEncryptionConfigsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListFieldLevelEncryptionConfigsError {
    fn code(&self) -> Option<&str> {
        ListFieldLevelEncryptionConfigsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListFieldLevelEncryptionConfigsError {
    /// Creates a new `ListFieldLevelEncryptionConfigsError`.
    pub fn new(
        kind: ListFieldLevelEncryptionConfigsErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListFieldLevelEncryptionConfigsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListFieldLevelEncryptionConfigsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListFieldLevelEncryptionConfigsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListFieldLevelEncryptionConfigsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListFieldLevelEncryptionConfigsErrorKind::InvalidArgument`.
    pub fn is_invalid_argument(&self) -> bool {
        matches!(
            &self.kind,
            ListFieldLevelEncryptionConfigsErrorKind::InvalidArgument(_)
        )
    }
}
impl std::error::Error for ListFieldLevelEncryptionConfigsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListFieldLevelEncryptionConfigsErrorKind::InvalidArgument(_inner) => Some(_inner),
            ListFieldLevelEncryptionConfigsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListFieldLevelEncryptionProfiles` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListFieldLevelEncryptionProfilesError {
    /// Kind of error that occurred.
    pub kind: ListFieldLevelEncryptionProfilesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListFieldLevelEncryptionProfiles` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListFieldLevelEncryptionProfilesErrorKind {
    /// <p>An argument is invalid.</p>
    InvalidArgument(crate::error::InvalidArgument),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListFieldLevelEncryptionProfilesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListFieldLevelEncryptionProfilesErrorKind::InvalidArgument(_inner) => _inner.fmt(f),
            ListFieldLevelEncryptionProfilesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListFieldLevelEncryptionProfilesError {
    fn code(&self) -> Option<&str> {
        ListFieldLevelEncryptionProfilesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListFieldLevelEncryptionProfilesError {
    /// Creates a new `ListFieldLevelEncryptionProfilesError`.
    pub fn new(
        kind: ListFieldLevelEncryptionProfilesErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListFieldLevelEncryptionProfilesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListFieldLevelEncryptionProfilesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListFieldLevelEncryptionProfilesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListFieldLevelEncryptionProfilesErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListFieldLevelEncryptionProfilesErrorKind::InvalidArgument`.
    pub fn is_invalid_argument(&self) -> bool {
        matches!(
            &self.kind,
            ListFieldLevelEncryptionProfilesErrorKind::InvalidArgument(_)
        )
    }
}
impl std::error::Error for ListFieldLevelEncryptionProfilesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListFieldLevelEncryptionProfilesErrorKind::InvalidArgument(_inner) => Some(_inner),
            ListFieldLevelEncryptionProfilesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListFunctions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListFunctionsError {
    /// Kind of error that occurred.
    pub kind: ListFunctionsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListFunctions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListFunctionsErrorKind {
    /// <p>An argument is invalid.</p>
    InvalidArgument(crate::error::InvalidArgument),
    /// <p>This operation is not supported in this region.</p>
    UnsupportedOperation(crate::error::UnsupportedOperation),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListFunctionsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListFunctionsErrorKind::InvalidArgument(_inner) => _inner.fmt(f),
            ListFunctionsErrorKind::UnsupportedOperation(_inner) => _inner.fmt(f),
            ListFunctionsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListFunctionsError {
    fn code(&self) -> Option<&str> {
        ListFunctionsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListFunctionsError {
    /// Creates a new `ListFunctionsError`.
    pub fn new(kind: ListFunctionsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListFunctionsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListFunctionsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListFunctionsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListFunctionsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListFunctionsErrorKind::InvalidArgument`.
    pub fn is_invalid_argument(&self) -> bool {
        matches!(&self.kind, ListFunctionsErrorKind::InvalidArgument(_))
    }
    /// Returns `true` if the error kind is `ListFunctionsErrorKind::UnsupportedOperation`.
    pub fn is_unsupported_operation(&self) -> bool {
        matches!(&self.kind, ListFunctionsErrorKind::UnsupportedOperation(_))
    }
}
impl std::error::Error for ListFunctionsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListFunctionsErrorKind::InvalidArgument(_inner) => Some(_inner),
            ListFunctionsErrorKind::UnsupportedOperation(_inner) => Some(_inner),
            ListFunctionsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListInvalidations` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListInvalidationsError {
    /// Kind of error that occurred.
    pub kind: ListInvalidationsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListInvalidations` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListInvalidationsErrorKind {
    /// <p>Access denied.</p>
    AccessDenied(crate::error::AccessDenied),
    /// <p>An argument is invalid.</p>
    InvalidArgument(crate::error::InvalidArgument),
    /// <p>The specified distribution does not exist.</p>
    NoSuchDistribution(crate::error::NoSuchDistribution),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListInvalidationsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListInvalidationsErrorKind::AccessDenied(_inner) => _inner.fmt(f),
            ListInvalidationsErrorKind::InvalidArgument(_inner) => _inner.fmt(f),
            ListInvalidationsErrorKind::NoSuchDistribution(_inner) => _inner.fmt(f),
            ListInvalidationsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListInvalidationsError {
    fn code(&self) -> Option<&str> {
        ListInvalidationsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListInvalidationsError {
    /// Creates a new `ListInvalidationsError`.
    pub fn new(kind: ListInvalidationsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListInvalidationsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListInvalidationsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListInvalidationsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListInvalidationsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListInvalidationsErrorKind::AccessDenied`.
    pub fn is_access_denied(&self) -> bool {
        matches!(&self.kind, ListInvalidationsErrorKind::AccessDenied(_))
    }
    /// Returns `true` if the error kind is `ListInvalidationsErrorKind::InvalidArgument`.
    pub fn is_invalid_argument(&self) -> bool {
        matches!(&self.kind, ListInvalidationsErrorKind::InvalidArgument(_))
    }
    /// Returns `true` if the error kind is `ListInvalidationsErrorKind::NoSuchDistribution`.
    pub fn is_no_such_distribution(&self) -> bool {
        matches!(
            &self.kind,
            ListInvalidationsErrorKind::NoSuchDistribution(_)
        )
    }
}
impl std::error::Error for ListInvalidationsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListInvalidationsErrorKind::AccessDenied(_inner) => Some(_inner),
            ListInvalidationsErrorKind::InvalidArgument(_inner) => Some(_inner),
            ListInvalidationsErrorKind::NoSuchDistribution(_inner) => Some(_inner),
            ListInvalidationsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListKeyGroups` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListKeyGroupsError {
    /// Kind of error that occurred.
    pub kind: ListKeyGroupsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListKeyGroups` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListKeyGroupsErrorKind {
    /// <p>An argument is invalid.</p>
    InvalidArgument(crate::error::InvalidArgument),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListKeyGroupsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListKeyGroupsErrorKind::InvalidArgument(_inner) => _inner.fmt(f),
            ListKeyGroupsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListKeyGroupsError {
    fn code(&self) -> Option<&str> {
        ListKeyGroupsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListKeyGroupsError {
    /// Creates a new `ListKeyGroupsError`.
    pub fn new(kind: ListKeyGroupsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListKeyGroupsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListKeyGroupsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListKeyGroupsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListKeyGroupsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListKeyGroupsErrorKind::InvalidArgument`.
    pub fn is_invalid_argument(&self) -> bool {
        matches!(&self.kind, ListKeyGroupsErrorKind::InvalidArgument(_))
    }
}
impl std::error::Error for ListKeyGroupsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListKeyGroupsErrorKind::InvalidArgument(_inner) => Some(_inner),
            ListKeyGroupsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListOriginRequestPolicies` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListOriginRequestPoliciesError {
    /// Kind of error that occurred.
    pub kind: ListOriginRequestPoliciesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListOriginRequestPolicies` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListOriginRequestPoliciesErrorKind {
    /// <p>Access denied.</p>
    AccessDenied(crate::error::AccessDenied),
    /// <p>An argument is invalid.</p>
    InvalidArgument(crate::error::InvalidArgument),
    /// <p>The origin request policy does not exist.</p>
    NoSuchOriginRequestPolicy(crate::error::NoSuchOriginRequestPolicy),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListOriginRequestPoliciesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListOriginRequestPoliciesErrorKind::AccessDenied(_inner) => _inner.fmt(f),
            ListOriginRequestPoliciesErrorKind::InvalidArgument(_inner) => _inner.fmt(f),
            ListOriginRequestPoliciesErrorKind::NoSuchOriginRequestPolicy(_inner) => _inner.fmt(f),
            ListOriginRequestPoliciesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListOriginRequestPoliciesError {
    fn code(&self) -> Option<&str> {
        ListOriginRequestPoliciesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListOriginRequestPoliciesError {
    /// Creates a new `ListOriginRequestPoliciesError`.
    pub fn new(kind: ListOriginRequestPoliciesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListOriginRequestPoliciesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListOriginRequestPoliciesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListOriginRequestPoliciesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListOriginRequestPoliciesErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListOriginRequestPoliciesErrorKind::AccessDenied`.
    pub fn is_access_denied(&self) -> bool {
        matches!(
            &self.kind,
            ListOriginRequestPoliciesErrorKind::AccessDenied(_)
        )
    }
    /// Returns `true` if the error kind is `ListOriginRequestPoliciesErrorKind::InvalidArgument`.
    pub fn is_invalid_argument(&self) -> bool {
        matches!(
            &self.kind,
            ListOriginRequestPoliciesErrorKind::InvalidArgument(_)
        )
    }
    /// Returns `true` if the error kind is `ListOriginRequestPoliciesErrorKind::NoSuchOriginRequestPolicy`.
    pub fn is_no_such_origin_request_policy(&self) -> bool {
        matches!(
            &self.kind,
            ListOriginRequestPoliciesErrorKind::NoSuchOriginRequestPolicy(_)
        )
    }
}
impl std::error::Error for ListOriginRequestPoliciesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListOriginRequestPoliciesErrorKind::AccessDenied(_inner) => Some(_inner),
            ListOriginRequestPoliciesErrorKind::InvalidArgument(_inner) => Some(_inner),
            ListOriginRequestPoliciesErrorKind::NoSuchOriginRequestPolicy(_inner) => Some(_inner),
            ListOriginRequestPoliciesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListPublicKeys` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListPublicKeysError {
    /// Kind of error that occurred.
    pub kind: ListPublicKeysErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListPublicKeys` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListPublicKeysErrorKind {
    /// <p>An argument is invalid.</p>
    InvalidArgument(crate::error::InvalidArgument),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListPublicKeysError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListPublicKeysErrorKind::InvalidArgument(_inner) => _inner.fmt(f),
            ListPublicKeysErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListPublicKeysError {
    fn code(&self) -> Option<&str> {
        ListPublicKeysError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListPublicKeysError {
    /// Creates a new `ListPublicKeysError`.
    pub fn new(kind: ListPublicKeysErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListPublicKeysError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListPublicKeysErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListPublicKeysError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListPublicKeysErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListPublicKeysErrorKind::InvalidArgument`.
    pub fn is_invalid_argument(&self) -> bool {
        matches!(&self.kind, ListPublicKeysErrorKind::InvalidArgument(_))
    }
}
impl std::error::Error for ListPublicKeysError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListPublicKeysErrorKind::InvalidArgument(_inner) => Some(_inner),
            ListPublicKeysErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListRealtimeLogConfigs` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListRealtimeLogConfigsError {
    /// Kind of error that occurred.
    pub kind: ListRealtimeLogConfigsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListRealtimeLogConfigs` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListRealtimeLogConfigsErrorKind {
    /// <p>Access denied.</p>
    AccessDenied(crate::error::AccessDenied),
    /// <p>An argument is invalid.</p>
    InvalidArgument(crate::error::InvalidArgument),
    /// <p>The real-time log configuration does not exist.</p>
    NoSuchRealtimeLogConfig(crate::error::NoSuchRealtimeLogConfig),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListRealtimeLogConfigsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListRealtimeLogConfigsErrorKind::AccessDenied(_inner) => _inner.fmt(f),
            ListRealtimeLogConfigsErrorKind::InvalidArgument(_inner) => _inner.fmt(f),
            ListRealtimeLogConfigsErrorKind::NoSuchRealtimeLogConfig(_inner) => _inner.fmt(f),
            ListRealtimeLogConfigsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListRealtimeLogConfigsError {
    fn code(&self) -> Option<&str> {
        ListRealtimeLogConfigsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListRealtimeLogConfigsError {
    /// Creates a new `ListRealtimeLogConfigsError`.
    pub fn new(kind: ListRealtimeLogConfigsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListRealtimeLogConfigsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListRealtimeLogConfigsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListRealtimeLogConfigsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListRealtimeLogConfigsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListRealtimeLogConfigsErrorKind::AccessDenied`.
    pub fn is_access_denied(&self) -> bool {
        matches!(&self.kind, ListRealtimeLogConfigsErrorKind::AccessDenied(_))
    }
    /// Returns `true` if the error kind is `ListRealtimeLogConfigsErrorKind::InvalidArgument`.
    pub fn is_invalid_argument(&self) -> bool {
        matches!(
            &self.kind,
            ListRealtimeLogConfigsErrorKind::InvalidArgument(_)
        )
    }
    /// Returns `true` if the error kind is `ListRealtimeLogConfigsErrorKind::NoSuchRealtimeLogConfig`.
    pub fn is_no_such_realtime_log_config(&self) -> bool {
        matches!(
            &self.kind,
            ListRealtimeLogConfigsErrorKind::NoSuchRealtimeLogConfig(_)
        )
    }
}
impl std::error::Error for ListRealtimeLogConfigsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListRealtimeLogConfigsErrorKind::AccessDenied(_inner) => Some(_inner),
            ListRealtimeLogConfigsErrorKind::InvalidArgument(_inner) => Some(_inner),
            ListRealtimeLogConfigsErrorKind::NoSuchRealtimeLogConfig(_inner) => Some(_inner),
            ListRealtimeLogConfigsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListResponseHeadersPolicies` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListResponseHeadersPoliciesError {
    /// Kind of error that occurred.
    pub kind: ListResponseHeadersPoliciesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListResponseHeadersPolicies` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListResponseHeadersPoliciesErrorKind {
    /// <p>Access denied.</p>
    AccessDenied(crate::error::AccessDenied),
    /// <p>An argument is invalid.</p>
    InvalidArgument(crate::error::InvalidArgument),
    /// <p>The response headers policy does not exist.</p>
    NoSuchResponseHeadersPolicy(crate::error::NoSuchResponseHeadersPolicy),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListResponseHeadersPoliciesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListResponseHeadersPoliciesErrorKind::AccessDenied(_inner) => _inner.fmt(f),
            ListResponseHeadersPoliciesErrorKind::InvalidArgument(_inner) => _inner.fmt(f),
            ListResponseHeadersPoliciesErrorKind::NoSuchResponseHeadersPolicy(_inner) => {
                _inner.fmt(f)
            }
            ListResponseHeadersPoliciesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListResponseHeadersPoliciesError {
    fn code(&self) -> Option<&str> {
        ListResponseHeadersPoliciesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListResponseHeadersPoliciesError {
    /// Creates a new `ListResponseHeadersPoliciesError`.
    pub fn new(kind: ListResponseHeadersPoliciesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListResponseHeadersPoliciesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListResponseHeadersPoliciesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListResponseHeadersPoliciesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListResponseHeadersPoliciesErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListResponseHeadersPoliciesErrorKind::AccessDenied`.
    pub fn is_access_denied(&self) -> bool {
        matches!(
            &self.kind,
            ListResponseHeadersPoliciesErrorKind::AccessDenied(_)
        )
    }
    /// Returns `true` if the error kind is `ListResponseHeadersPoliciesErrorKind::InvalidArgument`.
    pub fn is_invalid_argument(&self) -> bool {
        matches!(
            &self.kind,
            ListResponseHeadersPoliciesErrorKind::InvalidArgument(_)
        )
    }
    /// Returns `true` if the error kind is `ListResponseHeadersPoliciesErrorKind::NoSuchResponseHeadersPolicy`.
    pub fn is_no_such_response_headers_policy(&self) -> bool {
        matches!(
            &self.kind,
            ListResponseHeadersPoliciesErrorKind::NoSuchResponseHeadersPolicy(_)
        )
    }
}
impl std::error::Error for ListResponseHeadersPoliciesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListResponseHeadersPoliciesErrorKind::AccessDenied(_inner) => Some(_inner),
            ListResponseHeadersPoliciesErrorKind::InvalidArgument(_inner) => Some(_inner),
            ListResponseHeadersPoliciesErrorKind::NoSuchResponseHeadersPolicy(_inner) => {
                Some(_inner)
            }
            ListResponseHeadersPoliciesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListStreamingDistributions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListStreamingDistributionsError {
    /// Kind of error that occurred.
    pub kind: ListStreamingDistributionsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListStreamingDistributions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListStreamingDistributionsErrorKind {
    /// <p>An argument is invalid.</p>
    InvalidArgument(crate::error::InvalidArgument),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListStreamingDistributionsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListStreamingDistributionsErrorKind::InvalidArgument(_inner) => _inner.fmt(f),
            ListStreamingDistributionsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListStreamingDistributionsError {
    fn code(&self) -> Option<&str> {
        ListStreamingDistributionsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListStreamingDistributionsError {
    /// Creates a new `ListStreamingDistributionsError`.
    pub fn new(kind: ListStreamingDistributionsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListStreamingDistributionsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListStreamingDistributionsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListStreamingDistributionsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListStreamingDistributionsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListStreamingDistributionsErrorKind::InvalidArgument`.
    pub fn is_invalid_argument(&self) -> bool {
        matches!(
            &self.kind,
            ListStreamingDistributionsErrorKind::InvalidArgument(_)
        )
    }
}
impl std::error::Error for ListStreamingDistributionsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListStreamingDistributionsErrorKind::InvalidArgument(_inner) => Some(_inner),
            ListStreamingDistributionsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListTagsForResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListTagsForResourceError {
    /// Kind of error that occurred.
    pub kind: ListTagsForResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListTagsForResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListTagsForResourceErrorKind {
    /// <p>Access denied.</p>
    AccessDenied(crate::error::AccessDenied),
    /// <p>An argument is invalid.</p>
    InvalidArgument(crate::error::InvalidArgument),
    /// <p>The tagging specified is not valid.</p>
    InvalidTagging(crate::error::InvalidTagging),
    /// <p>A resource that was specified is not valid.</p>
    NoSuchResource(crate::error::NoSuchResource),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListTagsForResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListTagsForResourceErrorKind::AccessDenied(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::InvalidArgument(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::InvalidTagging(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::NoSuchResource(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListTagsForResourceError {
    fn code(&self) -> Option<&str> {
        ListTagsForResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListTagsForResourceError {
    /// Creates a new `ListTagsForResourceError`.
    pub fn new(kind: ListTagsForResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListTagsForResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListTagsForResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListTagsForResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListTagsForResourceErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::AccessDenied`.
    pub fn is_access_denied(&self) -> bool {
        matches!(&self.kind, ListTagsForResourceErrorKind::AccessDenied(_))
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::InvalidArgument`.
    pub fn is_invalid_argument(&self) -> bool {
        matches!(&self.kind, ListTagsForResourceErrorKind::InvalidArgument(_))
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::InvalidTagging`.
    pub fn is_invalid_tagging(&self) -> bool {
        matches!(&self.kind, ListTagsForResourceErrorKind::InvalidTagging(_))
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::NoSuchResource`.
    pub fn is_no_such_resource(&self) -> bool {
        matches!(&self.kind, ListTagsForResourceErrorKind::NoSuchResource(_))
    }
}
impl std::error::Error for ListTagsForResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListTagsForResourceErrorKind::AccessDenied(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::InvalidArgument(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::InvalidTagging(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::NoSuchResource(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `PublishFunction` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct PublishFunctionError {
    /// Kind of error that occurred.
    pub kind: PublishFunctionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `PublishFunction` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum PublishFunctionErrorKind {
    /// <p>An argument is invalid.</p>
    InvalidArgument(crate::error::InvalidArgument),
    /// <p>The <code>If-Match</code> version is missing or not valid.</p>
    InvalidIfMatchVersion(crate::error::InvalidIfMatchVersion),
    /// <p>The function does not exist.</p>
    NoSuchFunctionExists(crate::error::NoSuchFunctionExists),
    /// <p>The precondition in one or more of the request fields evaluated to <code>false</code>.</p>
    PreconditionFailed(crate::error::PreconditionFailed),
    /// <p>This operation is not supported in this region.</p>
    UnsupportedOperation(crate::error::UnsupportedOperation),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for PublishFunctionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            PublishFunctionErrorKind::InvalidArgument(_inner) => _inner.fmt(f),
            PublishFunctionErrorKind::InvalidIfMatchVersion(_inner) => _inner.fmt(f),
            PublishFunctionErrorKind::NoSuchFunctionExists(_inner) => _inner.fmt(f),
            PublishFunctionErrorKind::PreconditionFailed(_inner) => _inner.fmt(f),
            PublishFunctionErrorKind::UnsupportedOperation(_inner) => _inner.fmt(f),
            PublishFunctionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for PublishFunctionError {
    fn code(&self) -> Option<&str> {
        PublishFunctionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl PublishFunctionError {
    /// Creates a new `PublishFunctionError`.
    pub fn new(kind: PublishFunctionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `PublishFunctionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: PublishFunctionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `PublishFunctionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: PublishFunctionErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `PublishFunctionErrorKind::InvalidArgument`.
    pub fn is_invalid_argument(&self) -> bool {
        matches!(&self.kind, PublishFunctionErrorKind::InvalidArgument(_))
    }
    /// Returns `true` if the error kind is `PublishFunctionErrorKind::InvalidIfMatchVersion`.
    pub fn is_invalid_if_match_version(&self) -> bool {
        matches!(
            &self.kind,
            PublishFunctionErrorKind::InvalidIfMatchVersion(_)
        )
    }
    /// Returns `true` if the error kind is `PublishFunctionErrorKind::NoSuchFunctionExists`.
    pub fn is_no_such_function_exists(&self) -> bool {
        matches!(
            &self.kind,
            PublishFunctionErrorKind::NoSuchFunctionExists(_)
        )
    }
    /// Returns `true` if the error kind is `PublishFunctionErrorKind::PreconditionFailed`.
    pub fn is_precondition_failed(&self) -> bool {
        matches!(&self.kind, PublishFunctionErrorKind::PreconditionFailed(_))
    }
    /// Returns `true` if the error kind is `PublishFunctionErrorKind::UnsupportedOperation`.
    pub fn is_unsupported_operation(&self) -> bool {
        matches!(
            &self.kind,
            PublishFunctionErrorKind::UnsupportedOperation(_)
        )
    }
}
impl std::error::Error for PublishFunctionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            PublishFunctionErrorKind::InvalidArgument(_inner) => Some(_inner),
            PublishFunctionErrorKind::InvalidIfMatchVersion(_inner) => Some(_inner),
            PublishFunctionErrorKind::NoSuchFunctionExists(_inner) => Some(_inner),
            PublishFunctionErrorKind::PreconditionFailed(_inner) => Some(_inner),
            PublishFunctionErrorKind::UnsupportedOperation(_inner) => Some(_inner),
            PublishFunctionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `TagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct TagResourceError {
    /// Kind of error that occurred.
    pub kind: TagResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `TagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum TagResourceErrorKind {
    /// <p>Access denied.</p>
    AccessDenied(crate::error::AccessDenied),
    /// <p>An argument is invalid.</p>
    InvalidArgument(crate::error::InvalidArgument),
    /// <p>The tagging specified is not valid.</p>
    InvalidTagging(crate::error::InvalidTagging),
    /// <p>A resource that was specified is not valid.</p>
    NoSuchResource(crate::error::NoSuchResource),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for TagResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            TagResourceErrorKind::AccessDenied(_inner) => _inner.fmt(f),
            TagResourceErrorKind::InvalidArgument(_inner) => _inner.fmt(f),
            TagResourceErrorKind::InvalidTagging(_inner) => _inner.fmt(f),
            TagResourceErrorKind::NoSuchResource(_inner) => _inner.fmt(f),
            TagResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for TagResourceError {
    fn code(&self) -> Option<&str> {
        TagResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl TagResourceError {
    /// Creates a new `TagResourceError`.
    pub fn new(kind: TagResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `TagResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: TagResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `TagResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: TagResourceErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::AccessDenied`.
    pub fn is_access_denied(&self) -> bool {
        matches!(&self.kind, TagResourceErrorKind::AccessDenied(_))
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::InvalidArgument`.
    pub fn is_invalid_argument(&self) -> bool {
        matches!(&self.kind, TagResourceErrorKind::InvalidArgument(_))
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::InvalidTagging`.
    pub fn is_invalid_tagging(&self) -> bool {
        matches!(&self.kind, TagResourceErrorKind::InvalidTagging(_))
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::NoSuchResource`.
    pub fn is_no_such_resource(&self) -> bool {
        matches!(&self.kind, TagResourceErrorKind::NoSuchResource(_))
    }
}
impl std::error::Error for TagResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            TagResourceErrorKind::AccessDenied(_inner) => Some(_inner),
            TagResourceErrorKind::InvalidArgument(_inner) => Some(_inner),
            TagResourceErrorKind::InvalidTagging(_inner) => Some(_inner),
            TagResourceErrorKind::NoSuchResource(_inner) => Some(_inner),
            TagResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `TestFunction` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct TestFunctionError {
    /// Kind of error that occurred.
    pub kind: TestFunctionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `TestFunction` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum TestFunctionErrorKind {
    /// <p>An argument is invalid.</p>
    InvalidArgument(crate::error::InvalidArgument),
    /// <p>The <code>If-Match</code> version is missing or not valid.</p>
    InvalidIfMatchVersion(crate::error::InvalidIfMatchVersion),
    /// <p>The function does not exist.</p>
    NoSuchFunctionExists(crate::error::NoSuchFunctionExists),
    /// <p>The CloudFront function failed.</p>
    TestFunctionFailed(crate::error::TestFunctionFailed),
    /// <p>This operation is not supported in this region.</p>
    UnsupportedOperation(crate::error::UnsupportedOperation),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for TestFunctionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            TestFunctionErrorKind::InvalidArgument(_inner) => _inner.fmt(f),
            TestFunctionErrorKind::InvalidIfMatchVersion(_inner) => _inner.fmt(f),
            TestFunctionErrorKind::NoSuchFunctionExists(_inner) => _inner.fmt(f),
            TestFunctionErrorKind::TestFunctionFailed(_inner) => _inner.fmt(f),
            TestFunctionErrorKind::UnsupportedOperation(_inner) => _inner.fmt(f),
            TestFunctionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for TestFunctionError {
    fn code(&self) -> Option<&str> {
        TestFunctionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl TestFunctionError {
    /// Creates a new `TestFunctionError`.
    pub fn new(kind: TestFunctionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `TestFunctionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: TestFunctionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `TestFunctionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: TestFunctionErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `TestFunctionErrorKind::InvalidArgument`.
    pub fn is_invalid_argument(&self) -> bool {
        matches!(&self.kind, TestFunctionErrorKind::InvalidArgument(_))
    }
    /// Returns `true` if the error kind is `TestFunctionErrorKind::InvalidIfMatchVersion`.
    pub fn is_invalid_if_match_version(&self) -> bool {
        matches!(&self.kind, TestFunctionErrorKind::InvalidIfMatchVersion(_))
    }
    /// Returns `true` if the error kind is `TestFunctionErrorKind::NoSuchFunctionExists`.
    pub fn is_no_such_function_exists(&self) -> bool {
        matches!(&self.kind, TestFunctionErrorKind::NoSuchFunctionExists(_))
    }
    /// Returns `true` if the error kind is `TestFunctionErrorKind::TestFunctionFailed`.
    pub fn is_test_function_failed(&self) -> bool {
        matches!(&self.kind, TestFunctionErrorKind::TestFunctionFailed(_))
    }
    /// Returns `true` if the error kind is `TestFunctionErrorKind::UnsupportedOperation`.
    pub fn is_unsupported_operation(&self) -> bool {
        matches!(&self.kind, TestFunctionErrorKind::UnsupportedOperation(_))
    }
}
impl std::error::Error for TestFunctionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            TestFunctionErrorKind::InvalidArgument(_inner) => Some(_inner),
            TestFunctionErrorKind::InvalidIfMatchVersion(_inner) => Some(_inner),
            TestFunctionErrorKind::NoSuchFunctionExists(_inner) => Some(_inner),
            TestFunctionErrorKind::TestFunctionFailed(_inner) => Some(_inner),
            TestFunctionErrorKind::UnsupportedOperation(_inner) => Some(_inner),
            TestFunctionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UntagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UntagResourceError {
    /// Kind of error that occurred.
    pub kind: UntagResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UntagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UntagResourceErrorKind {
    /// <p>Access denied.</p>
    AccessDenied(crate::error::AccessDenied),
    /// <p>An argument is invalid.</p>
    InvalidArgument(crate::error::InvalidArgument),
    /// <p>The tagging specified is not valid.</p>
    InvalidTagging(crate::error::InvalidTagging),
    /// <p>A resource that was specified is not valid.</p>
    NoSuchResource(crate::error::NoSuchResource),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UntagResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UntagResourceErrorKind::AccessDenied(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::InvalidArgument(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::InvalidTagging(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::NoSuchResource(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UntagResourceError {
    fn code(&self) -> Option<&str> {
        UntagResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UntagResourceError {
    /// Creates a new `UntagResourceError`.
    pub fn new(kind: UntagResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UntagResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UntagResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UntagResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UntagResourceErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::AccessDenied`.
    pub fn is_access_denied(&self) -> bool {
        matches!(&self.kind, UntagResourceErrorKind::AccessDenied(_))
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::InvalidArgument`.
    pub fn is_invalid_argument(&self) -> bool {
        matches!(&self.kind, UntagResourceErrorKind::InvalidArgument(_))
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::InvalidTagging`.
    pub fn is_invalid_tagging(&self) -> bool {
        matches!(&self.kind, UntagResourceErrorKind::InvalidTagging(_))
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::NoSuchResource`.
    pub fn is_no_such_resource(&self) -> bool {
        matches!(&self.kind, UntagResourceErrorKind::NoSuchResource(_))
    }
}
impl std::error::Error for UntagResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UntagResourceErrorKind::AccessDenied(_inner) => Some(_inner),
            UntagResourceErrorKind::InvalidArgument(_inner) => Some(_inner),
            UntagResourceErrorKind::InvalidTagging(_inner) => Some(_inner),
            UntagResourceErrorKind::NoSuchResource(_inner) => Some(_inner),
            UntagResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateCachePolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateCachePolicyError {
    /// Kind of error that occurred.
    pub kind: UpdateCachePolicyErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateCachePolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateCachePolicyErrorKind {
    /// <p>Access denied.</p>
    AccessDenied(crate::error::AccessDenied),
    /// <p>A cache policy with this name already exists. You must provide a unique name. To modify an existing cache policy, use <code>UpdateCachePolicy</code>.</p>
    CachePolicyAlreadyExists(crate::error::CachePolicyAlreadyExists),
    /// <p>The update contains modifications that are not allowed.</p>
    IllegalUpdate(crate::error::IllegalUpdate),
    /// <p>The value of <code>Quantity</code> and the size of <code>Items</code> don't match.</p>
    InconsistentQuantities(crate::error::InconsistentQuantities),
    /// <p>An argument is invalid.</p>
    InvalidArgument(crate::error::InvalidArgument),
    /// <p>The <code>If-Match</code> version is missing or not valid.</p>
    InvalidIfMatchVersion(crate::error::InvalidIfMatchVersion),
    /// <p>The cache policy does not exist.</p>
    NoSuchCachePolicy(crate::error::NoSuchCachePolicy),
    /// <p>The precondition in one or more of the request fields evaluated to <code>false</code>.</p>
    PreconditionFailed(crate::error::PreconditionFailed),
    /// <p>The number of cookies in the cache policy exceeds the maximum. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html">Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.</p>
    TooManyCookiesInCachePolicy(crate::error::TooManyCookiesInCachePolicy),
    /// <p>The number of headers in the cache policy exceeds the maximum. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html">Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.</p>
    TooManyHeadersInCachePolicy(crate::error::TooManyHeadersInCachePolicy),
    /// <p>The number of query strings in the cache policy exceeds the maximum. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html">Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.</p>
    TooManyQueryStringsInCachePolicy(crate::error::TooManyQueryStringsInCachePolicy),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateCachePolicyError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateCachePolicyErrorKind::AccessDenied(_inner) => _inner.fmt(f),
            UpdateCachePolicyErrorKind::CachePolicyAlreadyExists(_inner) => _inner.fmt(f),
            UpdateCachePolicyErrorKind::IllegalUpdate(_inner) => _inner.fmt(f),
            UpdateCachePolicyErrorKind::InconsistentQuantities(_inner) => _inner.fmt(f),
            UpdateCachePolicyErrorKind::InvalidArgument(_inner) => _inner.fmt(f),
            UpdateCachePolicyErrorKind::InvalidIfMatchVersion(_inner) => _inner.fmt(f),
            UpdateCachePolicyErrorKind::NoSuchCachePolicy(_inner) => _inner.fmt(f),
            UpdateCachePolicyErrorKind::PreconditionFailed(_inner) => _inner.fmt(f),
            UpdateCachePolicyErrorKind::TooManyCookiesInCachePolicy(_inner) => _inner.fmt(f),
            UpdateCachePolicyErrorKind::TooManyHeadersInCachePolicy(_inner) => _inner.fmt(f),
            UpdateCachePolicyErrorKind::TooManyQueryStringsInCachePolicy(_inner) => _inner.fmt(f),
            UpdateCachePolicyErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateCachePolicyError {
    fn code(&self) -> Option<&str> {
        UpdateCachePolicyError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateCachePolicyError {
    /// Creates a new `UpdateCachePolicyError`.
    pub fn new(kind: UpdateCachePolicyErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateCachePolicyError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateCachePolicyErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateCachePolicyError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateCachePolicyErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateCachePolicyErrorKind::AccessDenied`.
    pub fn is_access_denied(&self) -> bool {
        matches!(&self.kind, UpdateCachePolicyErrorKind::AccessDenied(_))
    }
    /// Returns `true` if the error kind is `UpdateCachePolicyErrorKind::CachePolicyAlreadyExists`.
    pub fn is_cache_policy_already_exists(&self) -> bool {
        matches!(
            &self.kind,
            UpdateCachePolicyErrorKind::CachePolicyAlreadyExists(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateCachePolicyErrorKind::IllegalUpdate`.
    pub fn is_illegal_update(&self) -> bool {
        matches!(&self.kind, UpdateCachePolicyErrorKind::IllegalUpdate(_))
    }
    /// Returns `true` if the error kind is `UpdateCachePolicyErrorKind::InconsistentQuantities`.
    pub fn is_inconsistent_quantities(&self) -> bool {
        matches!(
            &self.kind,
            UpdateCachePolicyErrorKind::InconsistentQuantities(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateCachePolicyErrorKind::InvalidArgument`.
    pub fn is_invalid_argument(&self) -> bool {
        matches!(&self.kind, UpdateCachePolicyErrorKind::InvalidArgument(_))
    }
    /// Returns `true` if the error kind is `UpdateCachePolicyErrorKind::InvalidIfMatchVersion`.
    pub fn is_invalid_if_match_version(&self) -> bool {
        matches!(
            &self.kind,
            UpdateCachePolicyErrorKind::InvalidIfMatchVersion(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateCachePolicyErrorKind::NoSuchCachePolicy`.
    pub fn is_no_such_cache_policy(&self) -> bool {
        matches!(&self.kind, UpdateCachePolicyErrorKind::NoSuchCachePolicy(_))
    }
    /// Returns `true` if the error kind is `UpdateCachePolicyErrorKind::PreconditionFailed`.
    pub fn is_precondition_failed(&self) -> bool {
        matches!(
            &self.kind,
            UpdateCachePolicyErrorKind::PreconditionFailed(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateCachePolicyErrorKind::TooManyCookiesInCachePolicy`.
    pub fn is_too_many_cookies_in_cache_policy(&self) -> bool {
        matches!(
            &self.kind,
            UpdateCachePolicyErrorKind::TooManyCookiesInCachePolicy(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateCachePolicyErrorKind::TooManyHeadersInCachePolicy`.
    pub fn is_too_many_headers_in_cache_policy(&self) -> bool {
        matches!(
            &self.kind,
            UpdateCachePolicyErrorKind::TooManyHeadersInCachePolicy(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateCachePolicyErrorKind::TooManyQueryStringsInCachePolicy`.
    pub fn is_too_many_query_strings_in_cache_policy(&self) -> bool {
        matches!(
            &self.kind,
            UpdateCachePolicyErrorKind::TooManyQueryStringsInCachePolicy(_)
        )
    }
}
impl std::error::Error for UpdateCachePolicyError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateCachePolicyErrorKind::AccessDenied(_inner) => Some(_inner),
            UpdateCachePolicyErrorKind::CachePolicyAlreadyExists(_inner) => Some(_inner),
            UpdateCachePolicyErrorKind::IllegalUpdate(_inner) => Some(_inner),
            UpdateCachePolicyErrorKind::InconsistentQuantities(_inner) => Some(_inner),
            UpdateCachePolicyErrorKind::InvalidArgument(_inner) => Some(_inner),
            UpdateCachePolicyErrorKind::InvalidIfMatchVersion(_inner) => Some(_inner),
            UpdateCachePolicyErrorKind::NoSuchCachePolicy(_inner) => Some(_inner),
            UpdateCachePolicyErrorKind::PreconditionFailed(_inner) => Some(_inner),
            UpdateCachePolicyErrorKind::TooManyCookiesInCachePolicy(_inner) => Some(_inner),
            UpdateCachePolicyErrorKind::TooManyHeadersInCachePolicy(_inner) => Some(_inner),
            UpdateCachePolicyErrorKind::TooManyQueryStringsInCachePolicy(_inner) => Some(_inner),
            UpdateCachePolicyErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateCloudFrontOriginAccessIdentity` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateCloudFrontOriginAccessIdentityError {
    /// Kind of error that occurred.
    pub kind: UpdateCloudFrontOriginAccessIdentityErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateCloudFrontOriginAccessIdentity` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateCloudFrontOriginAccessIdentityErrorKind {
    /// <p>Access denied.</p>
    AccessDenied(crate::error::AccessDenied),
    /// <p>The update contains modifications that are not allowed.</p>
    IllegalUpdate(crate::error::IllegalUpdate),
    /// <p>The value of <code>Quantity</code> and the size of <code>Items</code> don't match.</p>
    InconsistentQuantities(crate::error::InconsistentQuantities),
    /// <p>An argument is invalid.</p>
    InvalidArgument(crate::error::InvalidArgument),
    /// <p>The <code>If-Match</code> version is missing or not valid.</p>
    InvalidIfMatchVersion(crate::error::InvalidIfMatchVersion),
    /// <p>This operation requires a body. Ensure that the body is present and the <code>Content-Type</code> header is set.</p>
    MissingBody(crate::error::MissingBody),
    /// <p>The specified origin access identity does not exist.</p>
    NoSuchCloudFrontOriginAccessIdentity(crate::error::NoSuchCloudFrontOriginAccessIdentity),
    /// <p>The precondition in one or more of the request fields evaluated to <code>false</code>.</p>
    PreconditionFailed(crate::error::PreconditionFailed),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateCloudFrontOriginAccessIdentityError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateCloudFrontOriginAccessIdentityErrorKind::AccessDenied(_inner) => _inner.fmt(f),
            UpdateCloudFrontOriginAccessIdentityErrorKind::IllegalUpdate(_inner) => _inner.fmt(f),
            UpdateCloudFrontOriginAccessIdentityErrorKind::InconsistentQuantities(_inner) => {
                _inner.fmt(f)
            }
            UpdateCloudFrontOriginAccessIdentityErrorKind::InvalidArgument(_inner) => _inner.fmt(f),
            UpdateCloudFrontOriginAccessIdentityErrorKind::InvalidIfMatchVersion(_inner) => {
                _inner.fmt(f)
            }
            UpdateCloudFrontOriginAccessIdentityErrorKind::MissingBody(_inner) => _inner.fmt(f),
            UpdateCloudFrontOriginAccessIdentityErrorKind::NoSuchCloudFrontOriginAccessIdentity(
                _inner,
            ) => _inner.fmt(f),
            UpdateCloudFrontOriginAccessIdentityErrorKind::PreconditionFailed(_inner) => {
                _inner.fmt(f)
            }
            UpdateCloudFrontOriginAccessIdentityErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateCloudFrontOriginAccessIdentityError {
    fn code(&self) -> Option<&str> {
        UpdateCloudFrontOriginAccessIdentityError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateCloudFrontOriginAccessIdentityError {
    /// Creates a new `UpdateCloudFrontOriginAccessIdentityError`.
    pub fn new(
        kind: UpdateCloudFrontOriginAccessIdentityErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateCloudFrontOriginAccessIdentityError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateCloudFrontOriginAccessIdentityErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateCloudFrontOriginAccessIdentityError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateCloudFrontOriginAccessIdentityErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateCloudFrontOriginAccessIdentityErrorKind::AccessDenied`.
    pub fn is_access_denied(&self) -> bool {
        matches!(
            &self.kind,
            UpdateCloudFrontOriginAccessIdentityErrorKind::AccessDenied(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateCloudFrontOriginAccessIdentityErrorKind::IllegalUpdate`.
    pub fn is_illegal_update(&self) -> bool {
        matches!(
            &self.kind,
            UpdateCloudFrontOriginAccessIdentityErrorKind::IllegalUpdate(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateCloudFrontOriginAccessIdentityErrorKind::InconsistentQuantities`.
    pub fn is_inconsistent_quantities(&self) -> bool {
        matches!(
            &self.kind,
            UpdateCloudFrontOriginAccessIdentityErrorKind::InconsistentQuantities(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateCloudFrontOriginAccessIdentityErrorKind::InvalidArgument`.
    pub fn is_invalid_argument(&self) -> bool {
        matches!(
            &self.kind,
            UpdateCloudFrontOriginAccessIdentityErrorKind::InvalidArgument(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateCloudFrontOriginAccessIdentityErrorKind::InvalidIfMatchVersion`.
    pub fn is_invalid_if_match_version(&self) -> bool {
        matches!(
            &self.kind,
            UpdateCloudFrontOriginAccessIdentityErrorKind::InvalidIfMatchVersion(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateCloudFrontOriginAccessIdentityErrorKind::MissingBody`.
    pub fn is_missing_body(&self) -> bool {
        matches!(
            &self.kind,
            UpdateCloudFrontOriginAccessIdentityErrorKind::MissingBody(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateCloudFrontOriginAccessIdentityErrorKind::NoSuchCloudFrontOriginAccessIdentity`.
    pub fn is_no_such_cloud_front_origin_access_identity(&self) -> bool {
        matches!(
            &self.kind,
            UpdateCloudFrontOriginAccessIdentityErrorKind::NoSuchCloudFrontOriginAccessIdentity(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateCloudFrontOriginAccessIdentityErrorKind::PreconditionFailed`.
    pub fn is_precondition_failed(&self) -> bool {
        matches!(
            &self.kind,
            UpdateCloudFrontOriginAccessIdentityErrorKind::PreconditionFailed(_)
        )
    }
}
impl std::error::Error for UpdateCloudFrontOriginAccessIdentityError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateCloudFrontOriginAccessIdentityErrorKind::AccessDenied(_inner) => Some(_inner),
            UpdateCloudFrontOriginAccessIdentityErrorKind::IllegalUpdate(_inner) => Some(_inner),
            UpdateCloudFrontOriginAccessIdentityErrorKind::InconsistentQuantities(_inner) => {
                Some(_inner)
            }
            UpdateCloudFrontOriginAccessIdentityErrorKind::InvalidArgument(_inner) => Some(_inner),
            UpdateCloudFrontOriginAccessIdentityErrorKind::InvalidIfMatchVersion(_inner) => {
                Some(_inner)
            }
            UpdateCloudFrontOriginAccessIdentityErrorKind::MissingBody(_inner) => Some(_inner),
            UpdateCloudFrontOriginAccessIdentityErrorKind::NoSuchCloudFrontOriginAccessIdentity(
                _inner,
            ) => Some(_inner),
            UpdateCloudFrontOriginAccessIdentityErrorKind::PreconditionFailed(_inner) => {
                Some(_inner)
            }
            UpdateCloudFrontOriginAccessIdentityErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `UpdateDistribution` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateDistributionError {
    /// Kind of error that occurred.
    pub kind: UpdateDistributionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateDistribution` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateDistributionErrorKind {
    /// <p>Access denied.</p>
    AccessDenied(crate::error::AccessDenied),
    /// <p>The CNAME specified is already defined for CloudFront.</p>
    CnameAlreadyExists(crate::error::CnameAlreadyExists),
    /// <p>The specified configuration for field-level encryption can't be associated with the specified cache behavior.</p>
    IllegalFieldLevelEncryptionConfigAssociationWithCacheBehavior(
        crate::error::IllegalFieldLevelEncryptionConfigAssociationWithCacheBehavior,
    ),
    /// <p>The update contains modifications that are not allowed.</p>
    IllegalUpdate(crate::error::IllegalUpdate),
    /// <p>The value of <code>Quantity</code> and the size of <code>Items</code> don't match.</p>
    InconsistentQuantities(crate::error::InconsistentQuantities),
    /// <p>An argument is invalid.</p>
    InvalidArgument(crate::error::InvalidArgument),
    /// <p>The default root object file name is too big or contains an invalid character.</p>
    InvalidDefaultRootObject(crate::error::InvalidDefaultRootObject),
    /// <p>An invalid error code was specified.</p>
    InvalidErrorCode(crate::error::InvalidErrorCode),
    /// <p>Your request contains forward cookies option which doesn't match with the expectation for the <code>whitelisted</code> list of cookie names. Either list of cookie names has been specified when not allowed or list of cookie names is missing when expected.</p>
    InvalidForwardCookies(crate::error::InvalidForwardCookies),
    /// <p>A CloudFront function association is invalid.</p>
    InvalidFunctionAssociation(crate::error::InvalidFunctionAssociation),
    /// <p>The specified geo restriction parameter is not valid.</p>
    InvalidGeoRestrictionParameter(crate::error::InvalidGeoRestrictionParameter),
    /// <p>The headers specified are not valid for an Amazon S3 origin.</p>
    InvalidHeadersForS3Origin(crate::error::InvalidHeadersForS3Origin),
    /// <p>The <code>If-Match</code> version is missing or not valid.</p>
    InvalidIfMatchVersion(crate::error::InvalidIfMatchVersion),
    /// <p>The specified Lambda@Edge function association is invalid.</p>
    InvalidLambdaFunctionAssociation(crate::error::InvalidLambdaFunctionAssociation),
    /// <p>The location code specified is not valid.</p>
    InvalidLocationCode(crate::error::InvalidLocationCode),
    /// <p>The minimum protocol version specified is not valid.</p>
    InvalidMinimumProtocolVersion(crate::error::InvalidMinimumProtocolVersion),
    /// <p>The origin access identity is not valid or doesn't exist.</p>
    InvalidOriginAccessIdentity(crate::error::InvalidOriginAccessIdentity),
    /// <p>The keep alive timeout specified for the origin is not valid.</p>
    InvalidOriginKeepaliveTimeout(crate::error::InvalidOriginKeepaliveTimeout),
    /// <p>The read timeout specified for the origin is not valid.</p>
    InvalidOriginReadTimeout(crate::error::InvalidOriginReadTimeout),
    /// <p>The query string parameters specified are not valid.</p>
    InvalidQueryStringParameters(crate::error::InvalidQueryStringParameters),
    /// <p>The relative path is too big, is not URL-encoded, or does not begin with a slash (/).</p>
    InvalidRelativePath(crate::error::InvalidRelativePath),
    /// <p>This operation requires the HTTPS protocol. Ensure that you specify the HTTPS protocol in your request, or omit the <code>RequiredProtocols</code> element from your distribution configuration.</p>
    InvalidRequiredProtocol(crate::error::InvalidRequiredProtocol),
    /// <p>A response code is not valid.</p>
    InvalidResponseCode(crate::error::InvalidResponseCode),
    /// <p>The TTL order specified is not valid.</p>
    InvalidTtlOrder(crate::error::InvalidTtlOrder),
    /// <p>A viewer certificate specified is not valid.</p>
    InvalidViewerCertificate(crate::error::InvalidViewerCertificate),
    /// <p>A web ACL ID specified is not valid. To specify a web ACL created using the latest version of WAF, use the ACL ARN, for example <code>arn:aws:wafv2:us-east-1:123456789012:global/webacl/ExampleWebACL/473e64fd-f30b-4765-81a0-62ad96dd167a</code>. To specify a web ACL created using WAF Classic, use the ACL ID, for example <code>473e64fd-f30b-4765-81a0-62ad96dd167a</code>.</p>
    InvalidWebAclId(crate::error::InvalidWebAclId),
    /// <p>This operation requires a body. Ensure that the body is present and the <code>Content-Type</code> header is set.</p>
    MissingBody(crate::error::MissingBody),
    /// <p>The cache policy does not exist.</p>
    NoSuchCachePolicy(crate::error::NoSuchCachePolicy),
    /// <p>The specified distribution does not exist.</p>
    NoSuchDistribution(crate::error::NoSuchDistribution),
    /// <p>The specified configuration for field-level encryption doesn't exist.</p>
    NoSuchFieldLevelEncryptionConfig(crate::error::NoSuchFieldLevelEncryptionConfig),
    /// <p>No origin exists with the specified <code>Origin Id</code>. </p>
    NoSuchOrigin(crate::error::NoSuchOrigin),
    /// <p>The origin request policy does not exist.</p>
    NoSuchOriginRequestPolicy(crate::error::NoSuchOriginRequestPolicy),
    /// <p>The real-time log configuration does not exist.</p>
    NoSuchRealtimeLogConfig(crate::error::NoSuchRealtimeLogConfig),
    /// <p>The response headers policy does not exist.</p>
    NoSuchResponseHeadersPolicy(crate::error::NoSuchResponseHeadersPolicy),
    /// <p>The precondition in one or more of the request fields evaluated to <code>false</code>.</p>
    PreconditionFailed(crate::error::PreconditionFailed),
    /// <p>The specified real-time log configuration belongs to a different Amazon Web Services account.</p>
    RealtimeLogConfigOwnerMismatch(crate::error::RealtimeLogConfigOwnerMismatch),
    /// <p>You cannot create more cache behaviors for the distribution.</p>
    TooManyCacheBehaviors(crate::error::TooManyCacheBehaviors),
    /// <p>You cannot create anymore custom SSL/TLS certificates.</p>
    TooManyCertificates(crate::error::TooManyCertificates),
    /// <p>Your request contains more cookie names in the whitelist than are allowed per cache behavior.</p>
    TooManyCookieNamesInWhiteList(crate::error::TooManyCookieNamesInWhiteList),
    /// <p>Your request contains more CNAMEs than are allowed per distribution.</p>
    TooManyDistributionCnamEs(crate::error::TooManyDistributionCnamEs),
    /// <p>The maximum number of distributions have been associated with the specified cache policy. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html">Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.</p>
    TooManyDistributionsAssociatedToCachePolicy(
        crate::error::TooManyDistributionsAssociatedToCachePolicy,
    ),
    /// <p>The maximum number of distributions have been associated with the specified configuration for field-level encryption.</p>
    TooManyDistributionsAssociatedToFieldLevelEncryptionConfig(
        crate::error::TooManyDistributionsAssociatedToFieldLevelEncryptionConfig,
    ),
    /// <p>The number of distributions that reference this key group is more than the maximum allowed. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html">Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.</p>
    TooManyDistributionsAssociatedToKeyGroup(
        crate::error::TooManyDistributionsAssociatedToKeyGroup,
    ),
    /// <p>The maximum number of distributions have been associated with the specified origin request policy. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html">Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.</p>
    TooManyDistributionsAssociatedToOriginRequestPolicy(
        crate::error::TooManyDistributionsAssociatedToOriginRequestPolicy,
    ),
    /// <p>The maximum number of distributions have been associated with the specified response headers policy.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html">Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.</p>
    TooManyDistributionsAssociatedToResponseHeadersPolicy(
        crate::error::TooManyDistributionsAssociatedToResponseHeadersPolicy,
    ),
    /// <p>You have reached the maximum number of distributions that are associated with a CloudFront function. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html">Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.</p>
    TooManyDistributionsWithFunctionAssociations(
        crate::error::TooManyDistributionsWithFunctionAssociations,
    ),
    /// <p>Processing your request would cause the maximum number of distributions with Lambda@Edge function associations per owner to be exceeded.</p>
    TooManyDistributionsWithLambdaAssociations(
        crate::error::TooManyDistributionsWithLambdaAssociations,
    ),
    /// <p>The maximum number of distributions have been associated with the specified Lambda@Edge function.</p>
    TooManyDistributionsWithSingleFunctionArn(
        crate::error::TooManyDistributionsWithSingleFunctionArn,
    ),
    /// <p>You have reached the maximum number of CloudFront function associations for this distribution. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html">Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.</p>
    TooManyFunctionAssociations(crate::error::TooManyFunctionAssociations),
    /// <p>Your request contains too many headers in forwarded values.</p>
    TooManyHeadersInForwardedValues(crate::error::TooManyHeadersInForwardedValues),
    /// <p>The number of key groups referenced by this distribution is more than the maximum allowed. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html">Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.</p>
    TooManyKeyGroupsAssociatedToDistribution(
        crate::error::TooManyKeyGroupsAssociatedToDistribution,
    ),
    /// <p>Your request contains more Lambda@Edge function associations than are allowed per distribution.</p>
    TooManyLambdaFunctionAssociations(crate::error::TooManyLambdaFunctionAssociations),
    /// <p>Your request contains too many origin custom headers.</p>
    TooManyOriginCustomHeaders(crate::error::TooManyOriginCustomHeaders),
    /// <p>Processing your request would cause you to exceed the maximum number of origin groups allowed.</p>
    TooManyOriginGroupsPerDistribution(crate::error::TooManyOriginGroupsPerDistribution),
    /// <p>You cannot create more origins for the distribution.</p>
    TooManyOrigins(crate::error::TooManyOrigins),
    /// <p>Your request contains too many query string parameters.</p>
    TooManyQueryStringParameters(crate::error::TooManyQueryStringParameters),
    /// <p>Your request contains more trusted signers than are allowed per distribution.</p>
    TooManyTrustedSigners(crate::error::TooManyTrustedSigners),
    /// <p>The specified key group does not exist.</p>
    TrustedKeyGroupDoesNotExist(crate::error::TrustedKeyGroupDoesNotExist),
    /// <p>One or more of your trusted signers don't exist.</p>
    TrustedSignerDoesNotExist(crate::error::TrustedSignerDoesNotExist),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateDistributionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateDistributionErrorKind::AccessDenied(_inner) =>
            _inner.fmt(f)
            ,
            UpdateDistributionErrorKind::CnameAlreadyExists(_inner) =>
            _inner.fmt(f)
            ,
            UpdateDistributionErrorKind::IllegalFieldLevelEncryptionConfigAssociationWithCacheBehavior(_inner) =>
            _inner.fmt(f)
            ,
            UpdateDistributionErrorKind::IllegalUpdate(_inner) =>
            _inner.fmt(f)
            ,
            UpdateDistributionErrorKind::InconsistentQuantities(_inner) =>
            _inner.fmt(f)
            ,
            UpdateDistributionErrorKind::InvalidArgument(_inner) =>
            _inner.fmt(f)
            ,
            UpdateDistributionErrorKind::InvalidDefaultRootObject(_inner) =>
            _inner.fmt(f)
            ,
            UpdateDistributionErrorKind::InvalidErrorCode(_inner) =>
            _inner.fmt(f)
            ,
            UpdateDistributionErrorKind::InvalidForwardCookies(_inner) =>
            _inner.fmt(f)
            ,
            UpdateDistributionErrorKind::InvalidFunctionAssociation(_inner) =>
            _inner.fmt(f)
            ,
            UpdateDistributionErrorKind::InvalidGeoRestrictionParameter(_inner) =>
            _inner.fmt(f)
            ,
            UpdateDistributionErrorKind::InvalidHeadersForS3Origin(_inner) =>
            _inner.fmt(f)
            ,
            UpdateDistributionErrorKind::InvalidIfMatchVersion(_inner) =>
            _inner.fmt(f)
            ,
            UpdateDistributionErrorKind::InvalidLambdaFunctionAssociation(_inner) =>
            _inner.fmt(f)
            ,
            UpdateDistributionErrorKind::InvalidLocationCode(_inner) =>
            _inner.fmt(f)
            ,
            UpdateDistributionErrorKind::InvalidMinimumProtocolVersion(_inner) =>
            _inner.fmt(f)
            ,
            UpdateDistributionErrorKind::InvalidOriginAccessIdentity(_inner) =>
            _inner.fmt(f)
            ,
            UpdateDistributionErrorKind::InvalidOriginKeepaliveTimeout(_inner) =>
            _inner.fmt(f)
            ,
            UpdateDistributionErrorKind::InvalidOriginReadTimeout(_inner) =>
            _inner.fmt(f)
            ,
            UpdateDistributionErrorKind::InvalidQueryStringParameters(_inner) =>
            _inner.fmt(f)
            ,
            UpdateDistributionErrorKind::InvalidRelativePath(_inner) =>
            _inner.fmt(f)
            ,
            UpdateDistributionErrorKind::InvalidRequiredProtocol(_inner) =>
            _inner.fmt(f)
            ,
            UpdateDistributionErrorKind::InvalidResponseCode(_inner) =>
            _inner.fmt(f)
            ,
            UpdateDistributionErrorKind::InvalidTtlOrder(_inner) =>
            _inner.fmt(f)
            ,
            UpdateDistributionErrorKind::InvalidViewerCertificate(_inner) =>
            _inner.fmt(f)
            ,
            UpdateDistributionErrorKind::InvalidWebAclId(_inner) =>
            _inner.fmt(f)
            ,
            UpdateDistributionErrorKind::MissingBody(_inner) =>
            _inner.fmt(f)
            ,
            UpdateDistributionErrorKind::NoSuchCachePolicy(_inner) =>
            _inner.fmt(f)
            ,
            UpdateDistributionErrorKind::NoSuchDistribution(_inner) =>
            _inner.fmt(f)
            ,
            UpdateDistributionErrorKind::NoSuchFieldLevelEncryptionConfig(_inner) =>
            _inner.fmt(f)
            ,
            UpdateDistributionErrorKind::NoSuchOrigin(_inner) =>
            _inner.fmt(f)
            ,
            UpdateDistributionErrorKind::NoSuchOriginRequestPolicy(_inner) =>
            _inner.fmt(f)
            ,
            UpdateDistributionErrorKind::NoSuchRealtimeLogConfig(_inner) =>
            _inner.fmt(f)
            ,
            UpdateDistributionErrorKind::NoSuchResponseHeadersPolicy(_inner) =>
            _inner.fmt(f)
            ,
            UpdateDistributionErrorKind::PreconditionFailed(_inner) =>
            _inner.fmt(f)
            ,
            UpdateDistributionErrorKind::RealtimeLogConfigOwnerMismatch(_inner) =>
            _inner.fmt(f)
            ,
            UpdateDistributionErrorKind::TooManyCacheBehaviors(_inner) =>
            _inner.fmt(f)
            ,
            UpdateDistributionErrorKind::TooManyCertificates(_inner) =>
            _inner.fmt(f)
            ,
            UpdateDistributionErrorKind::TooManyCookieNamesInWhiteList(_inner) =>
            _inner.fmt(f)
            ,
            UpdateDistributionErrorKind::TooManyDistributionCnamEs(_inner) =>
            _inner.fmt(f)
            ,
            UpdateDistributionErrorKind::TooManyDistributionsAssociatedToCachePolicy(_inner) =>
            _inner.fmt(f)
            ,
            UpdateDistributionErrorKind::TooManyDistributionsAssociatedToFieldLevelEncryptionConfig(_inner) =>
            _inner.fmt(f)
            ,
            UpdateDistributionErrorKind::TooManyDistributionsAssociatedToKeyGroup(_inner) =>
            _inner.fmt(f)
            ,
            UpdateDistributionErrorKind::TooManyDistributionsAssociatedToOriginRequestPolicy(_inner) =>
            _inner.fmt(f)
            ,
            UpdateDistributionErrorKind::TooManyDistributionsAssociatedToResponseHeadersPolicy(_inner) =>
            _inner.fmt(f)
            ,
            UpdateDistributionErrorKind::TooManyDistributionsWithFunctionAssociations(_inner) =>
            _inner.fmt(f)
            ,
            UpdateDistributionErrorKind::TooManyDistributionsWithLambdaAssociations(_inner) =>
            _inner.fmt(f)
            ,
            UpdateDistributionErrorKind::TooManyDistributionsWithSingleFunctionArn(_inner) =>
            _inner.fmt(f)
            ,
            UpdateDistributionErrorKind::TooManyFunctionAssociations(_inner) =>
            _inner.fmt(f)
            ,
            UpdateDistributionErrorKind::TooManyHeadersInForwardedValues(_inner) =>
            _inner.fmt(f)
            ,
            UpdateDistributionErrorKind::TooManyKeyGroupsAssociatedToDistribution(_inner) =>
            _inner.fmt(f)
            ,
            UpdateDistributionErrorKind::TooManyLambdaFunctionAssociations(_inner) =>
            _inner.fmt(f)
            ,
            UpdateDistributionErrorKind::TooManyOriginCustomHeaders(_inner) =>
            _inner.fmt(f)
            ,
            UpdateDistributionErrorKind::TooManyOriginGroupsPerDistribution(_inner) =>
            _inner.fmt(f)
            ,
            UpdateDistributionErrorKind::TooManyOrigins(_inner) =>
            _inner.fmt(f)
            ,
            UpdateDistributionErrorKind::TooManyQueryStringParameters(_inner) =>
            _inner.fmt(f)
            ,
            UpdateDistributionErrorKind::TooManyTrustedSigners(_inner) =>
            _inner.fmt(f)
            ,
            UpdateDistributionErrorKind::TrustedKeyGroupDoesNotExist(_inner) =>
            _inner.fmt(f)
            ,
            UpdateDistributionErrorKind::TrustedSignerDoesNotExist(_inner) =>
            _inner.fmt(f)
            ,
            UpdateDistributionErrorKind::Unhandled(_inner) => {
                _inner.fmt(f)
            }
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateDistributionError {
    fn code(&self) -> Option<&str> {
        UpdateDistributionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateDistributionError {
    /// Creates a new `UpdateDistributionError`.
    pub fn new(kind: UpdateDistributionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateDistributionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateDistributionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateDistributionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateDistributionErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateDistributionErrorKind::AccessDenied`.
    pub fn is_access_denied(&self) -> bool {
        matches!(&self.kind, UpdateDistributionErrorKind::AccessDenied(_))
    }
    /// Returns `true` if the error kind is `UpdateDistributionErrorKind::CnameAlreadyExists`.
    pub fn is_cname_already_exists(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDistributionErrorKind::CnameAlreadyExists(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateDistributionErrorKind::IllegalFieldLevelEncryptionConfigAssociationWithCacheBehavior`.
    pub fn is_illegal_field_level_encryption_config_association_with_cache_behavior(&self) -> bool {
        matches!(&self.kind, UpdateDistributionErrorKind::IllegalFieldLevelEncryptionConfigAssociationWithCacheBehavior(_))
    }
    /// Returns `true` if the error kind is `UpdateDistributionErrorKind::IllegalUpdate`.
    pub fn is_illegal_update(&self) -> bool {
        matches!(&self.kind, UpdateDistributionErrorKind::IllegalUpdate(_))
    }
    /// Returns `true` if the error kind is `UpdateDistributionErrorKind::InconsistentQuantities`.
    pub fn is_inconsistent_quantities(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDistributionErrorKind::InconsistentQuantities(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateDistributionErrorKind::InvalidArgument`.
    pub fn is_invalid_argument(&self) -> bool {
        matches!(&self.kind, UpdateDistributionErrorKind::InvalidArgument(_))
    }
    /// Returns `true` if the error kind is `UpdateDistributionErrorKind::InvalidDefaultRootObject`.
    pub fn is_invalid_default_root_object(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDistributionErrorKind::InvalidDefaultRootObject(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateDistributionErrorKind::InvalidErrorCode`.
    pub fn is_invalid_error_code(&self) -> bool {
        matches!(&self.kind, UpdateDistributionErrorKind::InvalidErrorCode(_))
    }
    /// Returns `true` if the error kind is `UpdateDistributionErrorKind::InvalidForwardCookies`.
    pub fn is_invalid_forward_cookies(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDistributionErrorKind::InvalidForwardCookies(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateDistributionErrorKind::InvalidFunctionAssociation`.
    pub fn is_invalid_function_association(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDistributionErrorKind::InvalidFunctionAssociation(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateDistributionErrorKind::InvalidGeoRestrictionParameter`.
    pub fn is_invalid_geo_restriction_parameter(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDistributionErrorKind::InvalidGeoRestrictionParameter(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateDistributionErrorKind::InvalidHeadersForS3Origin`.
    pub fn is_invalid_headers_for_s3_origin(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDistributionErrorKind::InvalidHeadersForS3Origin(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateDistributionErrorKind::InvalidIfMatchVersion`.
    pub fn is_invalid_if_match_version(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDistributionErrorKind::InvalidIfMatchVersion(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateDistributionErrorKind::InvalidLambdaFunctionAssociation`.
    pub fn is_invalid_lambda_function_association(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDistributionErrorKind::InvalidLambdaFunctionAssociation(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateDistributionErrorKind::InvalidLocationCode`.
    pub fn is_invalid_location_code(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDistributionErrorKind::InvalidLocationCode(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateDistributionErrorKind::InvalidMinimumProtocolVersion`.
    pub fn is_invalid_minimum_protocol_version(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDistributionErrorKind::InvalidMinimumProtocolVersion(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateDistributionErrorKind::InvalidOriginAccessIdentity`.
    pub fn is_invalid_origin_access_identity(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDistributionErrorKind::InvalidOriginAccessIdentity(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateDistributionErrorKind::InvalidOriginKeepaliveTimeout`.
    pub fn is_invalid_origin_keepalive_timeout(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDistributionErrorKind::InvalidOriginKeepaliveTimeout(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateDistributionErrorKind::InvalidOriginReadTimeout`.
    pub fn is_invalid_origin_read_timeout(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDistributionErrorKind::InvalidOriginReadTimeout(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateDistributionErrorKind::InvalidQueryStringParameters`.
    pub fn is_invalid_query_string_parameters(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDistributionErrorKind::InvalidQueryStringParameters(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateDistributionErrorKind::InvalidRelativePath`.
    pub fn is_invalid_relative_path(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDistributionErrorKind::InvalidRelativePath(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateDistributionErrorKind::InvalidRequiredProtocol`.
    pub fn is_invalid_required_protocol(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDistributionErrorKind::InvalidRequiredProtocol(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateDistributionErrorKind::InvalidResponseCode`.
    pub fn is_invalid_response_code(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDistributionErrorKind::InvalidResponseCode(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateDistributionErrorKind::InvalidTtlOrder`.
    pub fn is_invalid_ttl_order(&self) -> bool {
        matches!(&self.kind, UpdateDistributionErrorKind::InvalidTtlOrder(_))
    }
    /// Returns `true` if the error kind is `UpdateDistributionErrorKind::InvalidViewerCertificate`.
    pub fn is_invalid_viewer_certificate(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDistributionErrorKind::InvalidViewerCertificate(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateDistributionErrorKind::InvalidWebAclId`.
    pub fn is_invalid_web_acl_id(&self) -> bool {
        matches!(&self.kind, UpdateDistributionErrorKind::InvalidWebAclId(_))
    }
    /// Returns `true` if the error kind is `UpdateDistributionErrorKind::MissingBody`.
    pub fn is_missing_body(&self) -> bool {
        matches!(&self.kind, UpdateDistributionErrorKind::MissingBody(_))
    }
    /// Returns `true` if the error kind is `UpdateDistributionErrorKind::NoSuchCachePolicy`.
    pub fn is_no_such_cache_policy(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDistributionErrorKind::NoSuchCachePolicy(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateDistributionErrorKind::NoSuchDistribution`.
    pub fn is_no_such_distribution(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDistributionErrorKind::NoSuchDistribution(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateDistributionErrorKind::NoSuchFieldLevelEncryptionConfig`.
    pub fn is_no_such_field_level_encryption_config(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDistributionErrorKind::NoSuchFieldLevelEncryptionConfig(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateDistributionErrorKind::NoSuchOrigin`.
    pub fn is_no_such_origin(&self) -> bool {
        matches!(&self.kind, UpdateDistributionErrorKind::NoSuchOrigin(_))
    }
    /// Returns `true` if the error kind is `UpdateDistributionErrorKind::NoSuchOriginRequestPolicy`.
    pub fn is_no_such_origin_request_policy(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDistributionErrorKind::NoSuchOriginRequestPolicy(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateDistributionErrorKind::NoSuchRealtimeLogConfig`.
    pub fn is_no_such_realtime_log_config(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDistributionErrorKind::NoSuchRealtimeLogConfig(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateDistributionErrorKind::NoSuchResponseHeadersPolicy`.
    pub fn is_no_such_response_headers_policy(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDistributionErrorKind::NoSuchResponseHeadersPolicy(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateDistributionErrorKind::PreconditionFailed`.
    pub fn is_precondition_failed(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDistributionErrorKind::PreconditionFailed(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateDistributionErrorKind::RealtimeLogConfigOwnerMismatch`.
    pub fn is_realtime_log_config_owner_mismatch(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDistributionErrorKind::RealtimeLogConfigOwnerMismatch(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateDistributionErrorKind::TooManyCacheBehaviors`.
    pub fn is_too_many_cache_behaviors(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDistributionErrorKind::TooManyCacheBehaviors(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateDistributionErrorKind::TooManyCertificates`.
    pub fn is_too_many_certificates(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDistributionErrorKind::TooManyCertificates(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateDistributionErrorKind::TooManyCookieNamesInWhiteList`.
    pub fn is_too_many_cookie_names_in_white_list(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDistributionErrorKind::TooManyCookieNamesInWhiteList(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateDistributionErrorKind::TooManyDistributionCnamEs`.
    pub fn is_too_many_distribution_cnam_es(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDistributionErrorKind::TooManyDistributionCnamEs(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateDistributionErrorKind::TooManyDistributionsAssociatedToCachePolicy`.
    pub fn is_too_many_distributions_associated_to_cache_policy(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDistributionErrorKind::TooManyDistributionsAssociatedToCachePolicy(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateDistributionErrorKind::TooManyDistributionsAssociatedToFieldLevelEncryptionConfig`.
    pub fn is_too_many_distributions_associated_to_field_level_encryption_config(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDistributionErrorKind::TooManyDistributionsAssociatedToFieldLevelEncryptionConfig(
                _
            )
        )
    }
    /// Returns `true` if the error kind is `UpdateDistributionErrorKind::TooManyDistributionsAssociatedToKeyGroup`.
    pub fn is_too_many_distributions_associated_to_key_group(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDistributionErrorKind::TooManyDistributionsAssociatedToKeyGroup(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateDistributionErrorKind::TooManyDistributionsAssociatedToOriginRequestPolicy`.
    pub fn is_too_many_distributions_associated_to_origin_request_policy(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDistributionErrorKind::TooManyDistributionsAssociatedToOriginRequestPolicy(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateDistributionErrorKind::TooManyDistributionsAssociatedToResponseHeadersPolicy`.
    pub fn is_too_many_distributions_associated_to_response_headers_policy(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDistributionErrorKind::TooManyDistributionsAssociatedToResponseHeadersPolicy(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateDistributionErrorKind::TooManyDistributionsWithFunctionAssociations`.
    pub fn is_too_many_distributions_with_function_associations(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDistributionErrorKind::TooManyDistributionsWithFunctionAssociations(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateDistributionErrorKind::TooManyDistributionsWithLambdaAssociations`.
    pub fn is_too_many_distributions_with_lambda_associations(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDistributionErrorKind::TooManyDistributionsWithLambdaAssociations(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateDistributionErrorKind::TooManyDistributionsWithSingleFunctionArn`.
    pub fn is_too_many_distributions_with_single_function_arn(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDistributionErrorKind::TooManyDistributionsWithSingleFunctionArn(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateDistributionErrorKind::TooManyFunctionAssociations`.
    pub fn is_too_many_function_associations(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDistributionErrorKind::TooManyFunctionAssociations(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateDistributionErrorKind::TooManyHeadersInForwardedValues`.
    pub fn is_too_many_headers_in_forwarded_values(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDistributionErrorKind::TooManyHeadersInForwardedValues(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateDistributionErrorKind::TooManyKeyGroupsAssociatedToDistribution`.
    pub fn is_too_many_key_groups_associated_to_distribution(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDistributionErrorKind::TooManyKeyGroupsAssociatedToDistribution(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateDistributionErrorKind::TooManyLambdaFunctionAssociations`.
    pub fn is_too_many_lambda_function_associations(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDistributionErrorKind::TooManyLambdaFunctionAssociations(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateDistributionErrorKind::TooManyOriginCustomHeaders`.
    pub fn is_too_many_origin_custom_headers(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDistributionErrorKind::TooManyOriginCustomHeaders(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateDistributionErrorKind::TooManyOriginGroupsPerDistribution`.
    pub fn is_too_many_origin_groups_per_distribution(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDistributionErrorKind::TooManyOriginGroupsPerDistribution(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateDistributionErrorKind::TooManyOrigins`.
    pub fn is_too_many_origins(&self) -> bool {
        matches!(&self.kind, UpdateDistributionErrorKind::TooManyOrigins(_))
    }
    /// Returns `true` if the error kind is `UpdateDistributionErrorKind::TooManyQueryStringParameters`.
    pub fn is_too_many_query_string_parameters(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDistributionErrorKind::TooManyQueryStringParameters(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateDistributionErrorKind::TooManyTrustedSigners`.
    pub fn is_too_many_trusted_signers(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDistributionErrorKind::TooManyTrustedSigners(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateDistributionErrorKind::TrustedKeyGroupDoesNotExist`.
    pub fn is_trusted_key_group_does_not_exist(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDistributionErrorKind::TrustedKeyGroupDoesNotExist(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateDistributionErrorKind::TrustedSignerDoesNotExist`.
    pub fn is_trusted_signer_does_not_exist(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDistributionErrorKind::TrustedSignerDoesNotExist(_)
        )
    }
}
impl std::error::Error for UpdateDistributionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateDistributionErrorKind::AccessDenied(_inner) =>
            Some(_inner)
            ,
            UpdateDistributionErrorKind::CnameAlreadyExists(_inner) =>
            Some(_inner)
            ,
            UpdateDistributionErrorKind::IllegalFieldLevelEncryptionConfigAssociationWithCacheBehavior(_inner) =>
            Some(_inner)
            ,
            UpdateDistributionErrorKind::IllegalUpdate(_inner) =>
            Some(_inner)
            ,
            UpdateDistributionErrorKind::InconsistentQuantities(_inner) =>
            Some(_inner)
            ,
            UpdateDistributionErrorKind::InvalidArgument(_inner) =>
            Some(_inner)
            ,
            UpdateDistributionErrorKind::InvalidDefaultRootObject(_inner) =>
            Some(_inner)
            ,
            UpdateDistributionErrorKind::InvalidErrorCode(_inner) =>
            Some(_inner)
            ,
            UpdateDistributionErrorKind::InvalidForwardCookies(_inner) =>
            Some(_inner)
            ,
            UpdateDistributionErrorKind::InvalidFunctionAssociation(_inner) =>
            Some(_inner)
            ,
            UpdateDistributionErrorKind::InvalidGeoRestrictionParameter(_inner) =>
            Some(_inner)
            ,
            UpdateDistributionErrorKind::InvalidHeadersForS3Origin(_inner) =>
            Some(_inner)
            ,
            UpdateDistributionErrorKind::InvalidIfMatchVersion(_inner) =>
            Some(_inner)
            ,
            UpdateDistributionErrorKind::InvalidLambdaFunctionAssociation(_inner) =>
            Some(_inner)
            ,
            UpdateDistributionErrorKind::InvalidLocationCode(_inner) =>
            Some(_inner)
            ,
            UpdateDistributionErrorKind::InvalidMinimumProtocolVersion(_inner) =>
            Some(_inner)
            ,
            UpdateDistributionErrorKind::InvalidOriginAccessIdentity(_inner) =>
            Some(_inner)
            ,
            UpdateDistributionErrorKind::InvalidOriginKeepaliveTimeout(_inner) =>
            Some(_inner)
            ,
            UpdateDistributionErrorKind::InvalidOriginReadTimeout(_inner) =>
            Some(_inner)
            ,
            UpdateDistributionErrorKind::InvalidQueryStringParameters(_inner) =>
            Some(_inner)
            ,
            UpdateDistributionErrorKind::InvalidRelativePath(_inner) =>
            Some(_inner)
            ,
            UpdateDistributionErrorKind::InvalidRequiredProtocol(_inner) =>
            Some(_inner)
            ,
            UpdateDistributionErrorKind::InvalidResponseCode(_inner) =>
            Some(_inner)
            ,
            UpdateDistributionErrorKind::InvalidTtlOrder(_inner) =>
            Some(_inner)
            ,
            UpdateDistributionErrorKind::InvalidViewerCertificate(_inner) =>
            Some(_inner)
            ,
            UpdateDistributionErrorKind::InvalidWebAclId(_inner) =>
            Some(_inner)
            ,
            UpdateDistributionErrorKind::MissingBody(_inner) =>
            Some(_inner)
            ,
            UpdateDistributionErrorKind::NoSuchCachePolicy(_inner) =>
            Some(_inner)
            ,
            UpdateDistributionErrorKind::NoSuchDistribution(_inner) =>
            Some(_inner)
            ,
            UpdateDistributionErrorKind::NoSuchFieldLevelEncryptionConfig(_inner) =>
            Some(_inner)
            ,
            UpdateDistributionErrorKind::NoSuchOrigin(_inner) =>
            Some(_inner)
            ,
            UpdateDistributionErrorKind::NoSuchOriginRequestPolicy(_inner) =>
            Some(_inner)
            ,
            UpdateDistributionErrorKind::NoSuchRealtimeLogConfig(_inner) =>
            Some(_inner)
            ,
            UpdateDistributionErrorKind::NoSuchResponseHeadersPolicy(_inner) =>
            Some(_inner)
            ,
            UpdateDistributionErrorKind::PreconditionFailed(_inner) =>
            Some(_inner)
            ,
            UpdateDistributionErrorKind::RealtimeLogConfigOwnerMismatch(_inner) =>
            Some(_inner)
            ,
            UpdateDistributionErrorKind::TooManyCacheBehaviors(_inner) =>
            Some(_inner)
            ,
            UpdateDistributionErrorKind::TooManyCertificates(_inner) =>
            Some(_inner)
            ,
            UpdateDistributionErrorKind::TooManyCookieNamesInWhiteList(_inner) =>
            Some(_inner)
            ,
            UpdateDistributionErrorKind::TooManyDistributionCnamEs(_inner) =>
            Some(_inner)
            ,
            UpdateDistributionErrorKind::TooManyDistributionsAssociatedToCachePolicy(_inner) =>
            Some(_inner)
            ,
            UpdateDistributionErrorKind::TooManyDistributionsAssociatedToFieldLevelEncryptionConfig(_inner) =>
            Some(_inner)
            ,
            UpdateDistributionErrorKind::TooManyDistributionsAssociatedToKeyGroup(_inner) =>
            Some(_inner)
            ,
            UpdateDistributionErrorKind::TooManyDistributionsAssociatedToOriginRequestPolicy(_inner) =>
            Some(_inner)
            ,
            UpdateDistributionErrorKind::TooManyDistributionsAssociatedToResponseHeadersPolicy(_inner) =>
            Some(_inner)
            ,
            UpdateDistributionErrorKind::TooManyDistributionsWithFunctionAssociations(_inner) =>
            Some(_inner)
            ,
            UpdateDistributionErrorKind::TooManyDistributionsWithLambdaAssociations(_inner) =>
            Some(_inner)
            ,
            UpdateDistributionErrorKind::TooManyDistributionsWithSingleFunctionArn(_inner) =>
            Some(_inner)
            ,
            UpdateDistributionErrorKind::TooManyFunctionAssociations(_inner) =>
            Some(_inner)
            ,
            UpdateDistributionErrorKind::TooManyHeadersInForwardedValues(_inner) =>
            Some(_inner)
            ,
            UpdateDistributionErrorKind::TooManyKeyGroupsAssociatedToDistribution(_inner) =>
            Some(_inner)
            ,
            UpdateDistributionErrorKind::TooManyLambdaFunctionAssociations(_inner) =>
            Some(_inner)
            ,
            UpdateDistributionErrorKind::TooManyOriginCustomHeaders(_inner) =>
            Some(_inner)
            ,
            UpdateDistributionErrorKind::TooManyOriginGroupsPerDistribution(_inner) =>
            Some(_inner)
            ,
            UpdateDistributionErrorKind::TooManyOrigins(_inner) =>
            Some(_inner)
            ,
            UpdateDistributionErrorKind::TooManyQueryStringParameters(_inner) =>
            Some(_inner)
            ,
            UpdateDistributionErrorKind::TooManyTrustedSigners(_inner) =>
            Some(_inner)
            ,
            UpdateDistributionErrorKind::TrustedKeyGroupDoesNotExist(_inner) =>
            Some(_inner)
            ,
            UpdateDistributionErrorKind::TrustedSignerDoesNotExist(_inner) =>
            Some(_inner)
            ,
            UpdateDistributionErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `UpdateFieldLevelEncryptionConfig` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateFieldLevelEncryptionConfigError {
    /// Kind of error that occurred.
    pub kind: UpdateFieldLevelEncryptionConfigErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateFieldLevelEncryptionConfig` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateFieldLevelEncryptionConfigErrorKind {
    /// <p>Access denied.</p>
    AccessDenied(crate::error::AccessDenied),
    /// <p>The update contains modifications that are not allowed.</p>
    IllegalUpdate(crate::error::IllegalUpdate),
    /// <p>The value of <code>Quantity</code> and the size of <code>Items</code> don't match.</p>
    InconsistentQuantities(crate::error::InconsistentQuantities),
    /// <p>An argument is invalid.</p>
    InvalidArgument(crate::error::InvalidArgument),
    /// <p>The <code>If-Match</code> version is missing or not valid.</p>
    InvalidIfMatchVersion(crate::error::InvalidIfMatchVersion),
    /// <p>The specified configuration for field-level encryption doesn't exist.</p>
    NoSuchFieldLevelEncryptionConfig(crate::error::NoSuchFieldLevelEncryptionConfig),
    /// <p>The specified profile for field-level encryption doesn't exist.</p>
    NoSuchFieldLevelEncryptionProfile(crate::error::NoSuchFieldLevelEncryptionProfile),
    /// <p>The precondition in one or more of the request fields evaluated to <code>false</code>.</p>
    PreconditionFailed(crate::error::PreconditionFailed),
    /// <p>No profile specified for the field-level encryption query argument.</p>
    QueryArgProfileEmpty(crate::error::QueryArgProfileEmpty),
    /// <p>The maximum number of content type profiles for field-level encryption have been created.</p>
    TooManyFieldLevelEncryptionContentTypeProfiles(
        crate::error::TooManyFieldLevelEncryptionContentTypeProfiles,
    ),
    /// <p>The maximum number of query arg profiles for field-level encryption have been created.</p>
    TooManyFieldLevelEncryptionQueryArgProfiles(
        crate::error::TooManyFieldLevelEncryptionQueryArgProfiles,
    ),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateFieldLevelEncryptionConfigError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateFieldLevelEncryptionConfigErrorKind::AccessDenied(_inner) =>
            _inner.fmt(f)
            ,
            UpdateFieldLevelEncryptionConfigErrorKind::IllegalUpdate(_inner) =>
            _inner.fmt(f)
            ,
            UpdateFieldLevelEncryptionConfigErrorKind::InconsistentQuantities(_inner) =>
            _inner.fmt(f)
            ,
            UpdateFieldLevelEncryptionConfigErrorKind::InvalidArgument(_inner) =>
            _inner.fmt(f)
            ,
            UpdateFieldLevelEncryptionConfigErrorKind::InvalidIfMatchVersion(_inner) =>
            _inner.fmt(f)
            ,
            UpdateFieldLevelEncryptionConfigErrorKind::NoSuchFieldLevelEncryptionConfig(_inner) =>
            _inner.fmt(f)
            ,
            UpdateFieldLevelEncryptionConfigErrorKind::NoSuchFieldLevelEncryptionProfile(_inner) =>
            _inner.fmt(f)
            ,
            UpdateFieldLevelEncryptionConfigErrorKind::PreconditionFailed(_inner) =>
            _inner.fmt(f)
            ,
            UpdateFieldLevelEncryptionConfigErrorKind::QueryArgProfileEmpty(_inner) =>
            _inner.fmt(f)
            ,
            UpdateFieldLevelEncryptionConfigErrorKind::TooManyFieldLevelEncryptionContentTypeProfiles(_inner) =>
            _inner.fmt(f)
            ,
            UpdateFieldLevelEncryptionConfigErrorKind::TooManyFieldLevelEncryptionQueryArgProfiles(_inner) =>
            _inner.fmt(f)
            ,
            UpdateFieldLevelEncryptionConfigErrorKind::Unhandled(_inner) => {
                _inner.fmt(f)
            }
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateFieldLevelEncryptionConfigError {
    fn code(&self) -> Option<&str> {
        UpdateFieldLevelEncryptionConfigError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateFieldLevelEncryptionConfigError {
    /// Creates a new `UpdateFieldLevelEncryptionConfigError`.
    pub fn new(
        kind: UpdateFieldLevelEncryptionConfigErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateFieldLevelEncryptionConfigError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateFieldLevelEncryptionConfigErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateFieldLevelEncryptionConfigError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateFieldLevelEncryptionConfigErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateFieldLevelEncryptionConfigErrorKind::AccessDenied`.
    pub fn is_access_denied(&self) -> bool {
        matches!(
            &self.kind,
            UpdateFieldLevelEncryptionConfigErrorKind::AccessDenied(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateFieldLevelEncryptionConfigErrorKind::IllegalUpdate`.
    pub fn is_illegal_update(&self) -> bool {
        matches!(
            &self.kind,
            UpdateFieldLevelEncryptionConfigErrorKind::IllegalUpdate(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateFieldLevelEncryptionConfigErrorKind::InconsistentQuantities`.
    pub fn is_inconsistent_quantities(&self) -> bool {
        matches!(
            &self.kind,
            UpdateFieldLevelEncryptionConfigErrorKind::InconsistentQuantities(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateFieldLevelEncryptionConfigErrorKind::InvalidArgument`.
    pub fn is_invalid_argument(&self) -> bool {
        matches!(
            &self.kind,
            UpdateFieldLevelEncryptionConfigErrorKind::InvalidArgument(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateFieldLevelEncryptionConfigErrorKind::InvalidIfMatchVersion`.
    pub fn is_invalid_if_match_version(&self) -> bool {
        matches!(
            &self.kind,
            UpdateFieldLevelEncryptionConfigErrorKind::InvalidIfMatchVersion(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateFieldLevelEncryptionConfigErrorKind::NoSuchFieldLevelEncryptionConfig`.
    pub fn is_no_such_field_level_encryption_config(&self) -> bool {
        matches!(
            &self.kind,
            UpdateFieldLevelEncryptionConfigErrorKind::NoSuchFieldLevelEncryptionConfig(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateFieldLevelEncryptionConfigErrorKind::NoSuchFieldLevelEncryptionProfile`.
    pub fn is_no_such_field_level_encryption_profile(&self) -> bool {
        matches!(
            &self.kind,
            UpdateFieldLevelEncryptionConfigErrorKind::NoSuchFieldLevelEncryptionProfile(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateFieldLevelEncryptionConfigErrorKind::PreconditionFailed`.
    pub fn is_precondition_failed(&self) -> bool {
        matches!(
            &self.kind,
            UpdateFieldLevelEncryptionConfigErrorKind::PreconditionFailed(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateFieldLevelEncryptionConfigErrorKind::QueryArgProfileEmpty`.
    pub fn is_query_arg_profile_empty(&self) -> bool {
        matches!(
            &self.kind,
            UpdateFieldLevelEncryptionConfigErrorKind::QueryArgProfileEmpty(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateFieldLevelEncryptionConfigErrorKind::TooManyFieldLevelEncryptionContentTypeProfiles`.
    pub fn is_too_many_field_level_encryption_content_type_profiles(&self) -> bool {
        matches!(&self.kind, UpdateFieldLevelEncryptionConfigErrorKind::TooManyFieldLevelEncryptionContentTypeProfiles(_))
    }
    /// Returns `true` if the error kind is `UpdateFieldLevelEncryptionConfigErrorKind::TooManyFieldLevelEncryptionQueryArgProfiles`.
    pub fn is_too_many_field_level_encryption_query_arg_profiles(&self) -> bool {
        matches!(
            &self.kind,
            UpdateFieldLevelEncryptionConfigErrorKind::TooManyFieldLevelEncryptionQueryArgProfiles(
                _
            )
        )
    }
}
impl std::error::Error for UpdateFieldLevelEncryptionConfigError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateFieldLevelEncryptionConfigErrorKind::AccessDenied(_inner) =>
            Some(_inner)
            ,
            UpdateFieldLevelEncryptionConfigErrorKind::IllegalUpdate(_inner) =>
            Some(_inner)
            ,
            UpdateFieldLevelEncryptionConfigErrorKind::InconsistentQuantities(_inner) =>
            Some(_inner)
            ,
            UpdateFieldLevelEncryptionConfigErrorKind::InvalidArgument(_inner) =>
            Some(_inner)
            ,
            UpdateFieldLevelEncryptionConfigErrorKind::InvalidIfMatchVersion(_inner) =>
            Some(_inner)
            ,
            UpdateFieldLevelEncryptionConfigErrorKind::NoSuchFieldLevelEncryptionConfig(_inner) =>
            Some(_inner)
            ,
            UpdateFieldLevelEncryptionConfigErrorKind::NoSuchFieldLevelEncryptionProfile(_inner) =>
            Some(_inner)
            ,
            UpdateFieldLevelEncryptionConfigErrorKind::PreconditionFailed(_inner) =>
            Some(_inner)
            ,
            UpdateFieldLevelEncryptionConfigErrorKind::QueryArgProfileEmpty(_inner) =>
            Some(_inner)
            ,
            UpdateFieldLevelEncryptionConfigErrorKind::TooManyFieldLevelEncryptionContentTypeProfiles(_inner) =>
            Some(_inner)
            ,
            UpdateFieldLevelEncryptionConfigErrorKind::TooManyFieldLevelEncryptionQueryArgProfiles(_inner) =>
            Some(_inner)
            ,
            UpdateFieldLevelEncryptionConfigErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `UpdateFieldLevelEncryptionProfile` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateFieldLevelEncryptionProfileError {
    /// Kind of error that occurred.
    pub kind: UpdateFieldLevelEncryptionProfileErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateFieldLevelEncryptionProfile` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateFieldLevelEncryptionProfileErrorKind {
    /// <p>Access denied.</p>
    AccessDenied(crate::error::AccessDenied),
    /// <p>The specified profile for field-level encryption already exists.</p>
    FieldLevelEncryptionProfileAlreadyExists(
        crate::error::FieldLevelEncryptionProfileAlreadyExists,
    ),
    /// <p>The maximum size of a profile for field-level encryption was exceeded.</p>
    FieldLevelEncryptionProfileSizeExceeded(crate::error::FieldLevelEncryptionProfileSizeExceeded),
    /// <p>The update contains modifications that are not allowed.</p>
    IllegalUpdate(crate::error::IllegalUpdate),
    /// <p>The value of <code>Quantity</code> and the size of <code>Items</code> don't match.</p>
    InconsistentQuantities(crate::error::InconsistentQuantities),
    /// <p>An argument is invalid.</p>
    InvalidArgument(crate::error::InvalidArgument),
    /// <p>The <code>If-Match</code> version is missing or not valid.</p>
    InvalidIfMatchVersion(crate::error::InvalidIfMatchVersion),
    /// <p>The specified profile for field-level encryption doesn't exist.</p>
    NoSuchFieldLevelEncryptionProfile(crate::error::NoSuchFieldLevelEncryptionProfile),
    /// <p>The specified public key doesn't exist.</p>
    NoSuchPublicKey(crate::error::NoSuchPublicKey),
    /// <p>The precondition in one or more of the request fields evaluated to <code>false</code>.</p>
    PreconditionFailed(crate::error::PreconditionFailed),
    /// <p>The maximum number of encryption entities for field-level encryption have been created.</p>
    TooManyFieldLevelEncryptionEncryptionEntities(
        crate::error::TooManyFieldLevelEncryptionEncryptionEntities,
    ),
    /// <p>The maximum number of field patterns for field-level encryption have been created.</p>
    TooManyFieldLevelEncryptionFieldPatterns(
        crate::error::TooManyFieldLevelEncryptionFieldPatterns,
    ),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateFieldLevelEncryptionProfileError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateFieldLevelEncryptionProfileErrorKind::AccessDenied(_inner) =>
            _inner.fmt(f)
            ,
            UpdateFieldLevelEncryptionProfileErrorKind::FieldLevelEncryptionProfileAlreadyExists(_inner) =>
            _inner.fmt(f)
            ,
            UpdateFieldLevelEncryptionProfileErrorKind::FieldLevelEncryptionProfileSizeExceeded(_inner) =>
            _inner.fmt(f)
            ,
            UpdateFieldLevelEncryptionProfileErrorKind::IllegalUpdate(_inner) =>
            _inner.fmt(f)
            ,
            UpdateFieldLevelEncryptionProfileErrorKind::InconsistentQuantities(_inner) =>
            _inner.fmt(f)
            ,
            UpdateFieldLevelEncryptionProfileErrorKind::InvalidArgument(_inner) =>
            _inner.fmt(f)
            ,
            UpdateFieldLevelEncryptionProfileErrorKind::InvalidIfMatchVersion(_inner) =>
            _inner.fmt(f)
            ,
            UpdateFieldLevelEncryptionProfileErrorKind::NoSuchFieldLevelEncryptionProfile(_inner) =>
            _inner.fmt(f)
            ,
            UpdateFieldLevelEncryptionProfileErrorKind::NoSuchPublicKey(_inner) =>
            _inner.fmt(f)
            ,
            UpdateFieldLevelEncryptionProfileErrorKind::PreconditionFailed(_inner) =>
            _inner.fmt(f)
            ,
            UpdateFieldLevelEncryptionProfileErrorKind::TooManyFieldLevelEncryptionEncryptionEntities(_inner) =>
            _inner.fmt(f)
            ,
            UpdateFieldLevelEncryptionProfileErrorKind::TooManyFieldLevelEncryptionFieldPatterns(_inner) =>
            _inner.fmt(f)
            ,
            UpdateFieldLevelEncryptionProfileErrorKind::Unhandled(_inner) => {
                _inner.fmt(f)
            }
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateFieldLevelEncryptionProfileError {
    fn code(&self) -> Option<&str> {
        UpdateFieldLevelEncryptionProfileError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateFieldLevelEncryptionProfileError {
    /// Creates a new `UpdateFieldLevelEncryptionProfileError`.
    pub fn new(
        kind: UpdateFieldLevelEncryptionProfileErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateFieldLevelEncryptionProfileError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateFieldLevelEncryptionProfileErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateFieldLevelEncryptionProfileError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateFieldLevelEncryptionProfileErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateFieldLevelEncryptionProfileErrorKind::AccessDenied`.
    pub fn is_access_denied(&self) -> bool {
        matches!(
            &self.kind,
            UpdateFieldLevelEncryptionProfileErrorKind::AccessDenied(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateFieldLevelEncryptionProfileErrorKind::FieldLevelEncryptionProfileAlreadyExists`.
    pub fn is_field_level_encryption_profile_already_exists(&self) -> bool {
        matches!(
            &self.kind,
            UpdateFieldLevelEncryptionProfileErrorKind::FieldLevelEncryptionProfileAlreadyExists(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateFieldLevelEncryptionProfileErrorKind::FieldLevelEncryptionProfileSizeExceeded`.
    pub fn is_field_level_encryption_profile_size_exceeded(&self) -> bool {
        matches!(
            &self.kind,
            UpdateFieldLevelEncryptionProfileErrorKind::FieldLevelEncryptionProfileSizeExceeded(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateFieldLevelEncryptionProfileErrorKind::IllegalUpdate`.
    pub fn is_illegal_update(&self) -> bool {
        matches!(
            &self.kind,
            UpdateFieldLevelEncryptionProfileErrorKind::IllegalUpdate(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateFieldLevelEncryptionProfileErrorKind::InconsistentQuantities`.
    pub fn is_inconsistent_quantities(&self) -> bool {
        matches!(
            &self.kind,
            UpdateFieldLevelEncryptionProfileErrorKind::InconsistentQuantities(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateFieldLevelEncryptionProfileErrorKind::InvalidArgument`.
    pub fn is_invalid_argument(&self) -> bool {
        matches!(
            &self.kind,
            UpdateFieldLevelEncryptionProfileErrorKind::InvalidArgument(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateFieldLevelEncryptionProfileErrorKind::InvalidIfMatchVersion`.
    pub fn is_invalid_if_match_version(&self) -> bool {
        matches!(
            &self.kind,
            UpdateFieldLevelEncryptionProfileErrorKind::InvalidIfMatchVersion(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateFieldLevelEncryptionProfileErrorKind::NoSuchFieldLevelEncryptionProfile`.
    pub fn is_no_such_field_level_encryption_profile(&self) -> bool {
        matches!(
            &self.kind,
            UpdateFieldLevelEncryptionProfileErrorKind::NoSuchFieldLevelEncryptionProfile(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateFieldLevelEncryptionProfileErrorKind::NoSuchPublicKey`.
    pub fn is_no_such_public_key(&self) -> bool {
        matches!(
            &self.kind,
            UpdateFieldLevelEncryptionProfileErrorKind::NoSuchPublicKey(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateFieldLevelEncryptionProfileErrorKind::PreconditionFailed`.
    pub fn is_precondition_failed(&self) -> bool {
        matches!(
            &self.kind,
            UpdateFieldLevelEncryptionProfileErrorKind::PreconditionFailed(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateFieldLevelEncryptionProfileErrorKind::TooManyFieldLevelEncryptionEncryptionEntities`.
    pub fn is_too_many_field_level_encryption_encryption_entities(&self) -> bool {
        matches!(&self.kind, UpdateFieldLevelEncryptionProfileErrorKind::TooManyFieldLevelEncryptionEncryptionEntities(_))
    }
    /// Returns `true` if the error kind is `UpdateFieldLevelEncryptionProfileErrorKind::TooManyFieldLevelEncryptionFieldPatterns`.
    pub fn is_too_many_field_level_encryption_field_patterns(&self) -> bool {
        matches!(
            &self.kind,
            UpdateFieldLevelEncryptionProfileErrorKind::TooManyFieldLevelEncryptionFieldPatterns(_)
        )
    }
}
impl std::error::Error for UpdateFieldLevelEncryptionProfileError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateFieldLevelEncryptionProfileErrorKind::AccessDenied(_inner) =>
            Some(_inner)
            ,
            UpdateFieldLevelEncryptionProfileErrorKind::FieldLevelEncryptionProfileAlreadyExists(_inner) =>
            Some(_inner)
            ,
            UpdateFieldLevelEncryptionProfileErrorKind::FieldLevelEncryptionProfileSizeExceeded(_inner) =>
            Some(_inner)
            ,
            UpdateFieldLevelEncryptionProfileErrorKind::IllegalUpdate(_inner) =>
            Some(_inner)
            ,
            UpdateFieldLevelEncryptionProfileErrorKind::InconsistentQuantities(_inner) =>
            Some(_inner)
            ,
            UpdateFieldLevelEncryptionProfileErrorKind::InvalidArgument(_inner) =>
            Some(_inner)
            ,
            UpdateFieldLevelEncryptionProfileErrorKind::InvalidIfMatchVersion(_inner) =>
            Some(_inner)
            ,
            UpdateFieldLevelEncryptionProfileErrorKind::NoSuchFieldLevelEncryptionProfile(_inner) =>
            Some(_inner)
            ,
            UpdateFieldLevelEncryptionProfileErrorKind::NoSuchPublicKey(_inner) =>
            Some(_inner)
            ,
            UpdateFieldLevelEncryptionProfileErrorKind::PreconditionFailed(_inner) =>
            Some(_inner)
            ,
            UpdateFieldLevelEncryptionProfileErrorKind::TooManyFieldLevelEncryptionEncryptionEntities(_inner) =>
            Some(_inner)
            ,
            UpdateFieldLevelEncryptionProfileErrorKind::TooManyFieldLevelEncryptionFieldPatterns(_inner) =>
            Some(_inner)
            ,
            UpdateFieldLevelEncryptionProfileErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `UpdateFunction` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateFunctionError {
    /// Kind of error that occurred.
    pub kind: UpdateFunctionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateFunction` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateFunctionErrorKind {
    /// <p>The function is too large. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html">Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.</p>
    FunctionSizeLimitExceeded(crate::error::FunctionSizeLimitExceeded),
    /// <p>An argument is invalid.</p>
    InvalidArgument(crate::error::InvalidArgument),
    /// <p>The <code>If-Match</code> version is missing or not valid.</p>
    InvalidIfMatchVersion(crate::error::InvalidIfMatchVersion),
    /// <p>The function does not exist.</p>
    NoSuchFunctionExists(crate::error::NoSuchFunctionExists),
    /// <p>The precondition in one or more of the request fields evaluated to <code>false</code>.</p>
    PreconditionFailed(crate::error::PreconditionFailed),
    /// <p>This operation is not supported in this region.</p>
    UnsupportedOperation(crate::error::UnsupportedOperation),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateFunctionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateFunctionErrorKind::FunctionSizeLimitExceeded(_inner) => _inner.fmt(f),
            UpdateFunctionErrorKind::InvalidArgument(_inner) => _inner.fmt(f),
            UpdateFunctionErrorKind::InvalidIfMatchVersion(_inner) => _inner.fmt(f),
            UpdateFunctionErrorKind::NoSuchFunctionExists(_inner) => _inner.fmt(f),
            UpdateFunctionErrorKind::PreconditionFailed(_inner) => _inner.fmt(f),
            UpdateFunctionErrorKind::UnsupportedOperation(_inner) => _inner.fmt(f),
            UpdateFunctionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateFunctionError {
    fn code(&self) -> Option<&str> {
        UpdateFunctionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateFunctionError {
    /// Creates a new `UpdateFunctionError`.
    pub fn new(kind: UpdateFunctionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateFunctionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateFunctionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateFunctionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateFunctionErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateFunctionErrorKind::FunctionSizeLimitExceeded`.
    pub fn is_function_size_limit_exceeded(&self) -> bool {
        matches!(
            &self.kind,
            UpdateFunctionErrorKind::FunctionSizeLimitExceeded(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateFunctionErrorKind::InvalidArgument`.
    pub fn is_invalid_argument(&self) -> bool {
        matches!(&self.kind, UpdateFunctionErrorKind::InvalidArgument(_))
    }
    /// Returns `true` if the error kind is `UpdateFunctionErrorKind::InvalidIfMatchVersion`.
    pub fn is_invalid_if_match_version(&self) -> bool {
        matches!(
            &self.kind,
            UpdateFunctionErrorKind::InvalidIfMatchVersion(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateFunctionErrorKind::NoSuchFunctionExists`.
    pub fn is_no_such_function_exists(&self) -> bool {
        matches!(&self.kind, UpdateFunctionErrorKind::NoSuchFunctionExists(_))
    }
    /// Returns `true` if the error kind is `UpdateFunctionErrorKind::PreconditionFailed`.
    pub fn is_precondition_failed(&self) -> bool {
        matches!(&self.kind, UpdateFunctionErrorKind::PreconditionFailed(_))
    }
    /// Returns `true` if the error kind is `UpdateFunctionErrorKind::UnsupportedOperation`.
    pub fn is_unsupported_operation(&self) -> bool {
        matches!(&self.kind, UpdateFunctionErrorKind::UnsupportedOperation(_))
    }
}
impl std::error::Error for UpdateFunctionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateFunctionErrorKind::FunctionSizeLimitExceeded(_inner) => Some(_inner),
            UpdateFunctionErrorKind::InvalidArgument(_inner) => Some(_inner),
            UpdateFunctionErrorKind::InvalidIfMatchVersion(_inner) => Some(_inner),
            UpdateFunctionErrorKind::NoSuchFunctionExists(_inner) => Some(_inner),
            UpdateFunctionErrorKind::PreconditionFailed(_inner) => Some(_inner),
            UpdateFunctionErrorKind::UnsupportedOperation(_inner) => Some(_inner),
            UpdateFunctionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateKeyGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateKeyGroupError {
    /// Kind of error that occurred.
    pub kind: UpdateKeyGroupErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateKeyGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateKeyGroupErrorKind {
    /// <p>An argument is invalid.</p>
    InvalidArgument(crate::error::InvalidArgument),
    /// <p>The <code>If-Match</code> version is missing or not valid.</p>
    InvalidIfMatchVersion(crate::error::InvalidIfMatchVersion),
    /// <p>A key group with this name already exists. You must provide a unique name. To modify an existing key group, use <code>UpdateKeyGroup</code>.</p>
    KeyGroupAlreadyExists(crate::error::KeyGroupAlreadyExists),
    /// <p>A resource that was specified is not valid.</p>
    NoSuchResource(crate::error::NoSuchResource),
    /// <p>The precondition in one or more of the request fields evaluated to <code>false</code>.</p>
    PreconditionFailed(crate::error::PreconditionFailed),
    /// <p>The number of public keys in this key group is more than the maximum allowed. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html">Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.</p>
    TooManyPublicKeysInKeyGroup(crate::error::TooManyPublicKeysInKeyGroup),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateKeyGroupError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateKeyGroupErrorKind::InvalidArgument(_inner) => _inner.fmt(f),
            UpdateKeyGroupErrorKind::InvalidIfMatchVersion(_inner) => _inner.fmt(f),
            UpdateKeyGroupErrorKind::KeyGroupAlreadyExists(_inner) => _inner.fmt(f),
            UpdateKeyGroupErrorKind::NoSuchResource(_inner) => _inner.fmt(f),
            UpdateKeyGroupErrorKind::PreconditionFailed(_inner) => _inner.fmt(f),
            UpdateKeyGroupErrorKind::TooManyPublicKeysInKeyGroup(_inner) => _inner.fmt(f),
            UpdateKeyGroupErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateKeyGroupError {
    fn code(&self) -> Option<&str> {
        UpdateKeyGroupError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateKeyGroupError {
    /// Creates a new `UpdateKeyGroupError`.
    pub fn new(kind: UpdateKeyGroupErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateKeyGroupError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateKeyGroupErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateKeyGroupError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateKeyGroupErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateKeyGroupErrorKind::InvalidArgument`.
    pub fn is_invalid_argument(&self) -> bool {
        matches!(&self.kind, UpdateKeyGroupErrorKind::InvalidArgument(_))
    }
    /// Returns `true` if the error kind is `UpdateKeyGroupErrorKind::InvalidIfMatchVersion`.
    pub fn is_invalid_if_match_version(&self) -> bool {
        matches!(
            &self.kind,
            UpdateKeyGroupErrorKind::InvalidIfMatchVersion(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateKeyGroupErrorKind::KeyGroupAlreadyExists`.
    pub fn is_key_group_already_exists(&self) -> bool {
        matches!(
            &self.kind,
            UpdateKeyGroupErrorKind::KeyGroupAlreadyExists(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateKeyGroupErrorKind::NoSuchResource`.
    pub fn is_no_such_resource(&self) -> bool {
        matches!(&self.kind, UpdateKeyGroupErrorKind::NoSuchResource(_))
    }
    /// Returns `true` if the error kind is `UpdateKeyGroupErrorKind::PreconditionFailed`.
    pub fn is_precondition_failed(&self) -> bool {
        matches!(&self.kind, UpdateKeyGroupErrorKind::PreconditionFailed(_))
    }
    /// Returns `true` if the error kind is `UpdateKeyGroupErrorKind::TooManyPublicKeysInKeyGroup`.
    pub fn is_too_many_public_keys_in_key_group(&self) -> bool {
        matches!(
            &self.kind,
            UpdateKeyGroupErrorKind::TooManyPublicKeysInKeyGroup(_)
        )
    }
}
impl std::error::Error for UpdateKeyGroupError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateKeyGroupErrorKind::InvalidArgument(_inner) => Some(_inner),
            UpdateKeyGroupErrorKind::InvalidIfMatchVersion(_inner) => Some(_inner),
            UpdateKeyGroupErrorKind::KeyGroupAlreadyExists(_inner) => Some(_inner),
            UpdateKeyGroupErrorKind::NoSuchResource(_inner) => Some(_inner),
            UpdateKeyGroupErrorKind::PreconditionFailed(_inner) => Some(_inner),
            UpdateKeyGroupErrorKind::TooManyPublicKeysInKeyGroup(_inner) => Some(_inner),
            UpdateKeyGroupErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateOriginRequestPolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateOriginRequestPolicyError {
    /// Kind of error that occurred.
    pub kind: UpdateOriginRequestPolicyErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateOriginRequestPolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateOriginRequestPolicyErrorKind {
    /// <p>Access denied.</p>
    AccessDenied(crate::error::AccessDenied),
    /// <p>The update contains modifications that are not allowed.</p>
    IllegalUpdate(crate::error::IllegalUpdate),
    /// <p>The value of <code>Quantity</code> and the size of <code>Items</code> don't match.</p>
    InconsistentQuantities(crate::error::InconsistentQuantities),
    /// <p>An argument is invalid.</p>
    InvalidArgument(crate::error::InvalidArgument),
    /// <p>The <code>If-Match</code> version is missing or not valid.</p>
    InvalidIfMatchVersion(crate::error::InvalidIfMatchVersion),
    /// <p>The origin request policy does not exist.</p>
    NoSuchOriginRequestPolicy(crate::error::NoSuchOriginRequestPolicy),
    /// <p>An origin request policy with this name already exists. You must provide a unique name. To modify an existing origin request policy, use <code>UpdateOriginRequestPolicy</code>.</p>
    OriginRequestPolicyAlreadyExists(crate::error::OriginRequestPolicyAlreadyExists),
    /// <p>The precondition in one or more of the request fields evaluated to <code>false</code>.</p>
    PreconditionFailed(crate::error::PreconditionFailed),
    /// <p>The number of cookies in the origin request policy exceeds the maximum. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html">Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.</p>
    TooManyCookiesInOriginRequestPolicy(crate::error::TooManyCookiesInOriginRequestPolicy),
    /// <p>The number of headers in the origin request policy exceeds the maximum. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html">Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.</p>
    TooManyHeadersInOriginRequestPolicy(crate::error::TooManyHeadersInOriginRequestPolicy),
    /// <p>The number of query strings in the origin request policy exceeds the maximum. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html">Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.</p>
    TooManyQueryStringsInOriginRequestPolicy(
        crate::error::TooManyQueryStringsInOriginRequestPolicy,
    ),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateOriginRequestPolicyError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateOriginRequestPolicyErrorKind::AccessDenied(_inner) => _inner.fmt(f),
            UpdateOriginRequestPolicyErrorKind::IllegalUpdate(_inner) => _inner.fmt(f),
            UpdateOriginRequestPolicyErrorKind::InconsistentQuantities(_inner) => _inner.fmt(f),
            UpdateOriginRequestPolicyErrorKind::InvalidArgument(_inner) => _inner.fmt(f),
            UpdateOriginRequestPolicyErrorKind::InvalidIfMatchVersion(_inner) => _inner.fmt(f),
            UpdateOriginRequestPolicyErrorKind::NoSuchOriginRequestPolicy(_inner) => _inner.fmt(f),
            UpdateOriginRequestPolicyErrorKind::OriginRequestPolicyAlreadyExists(_inner) => {
                _inner.fmt(f)
            }
            UpdateOriginRequestPolicyErrorKind::PreconditionFailed(_inner) => _inner.fmt(f),
            UpdateOriginRequestPolicyErrorKind::TooManyCookiesInOriginRequestPolicy(_inner) => {
                _inner.fmt(f)
            }
            UpdateOriginRequestPolicyErrorKind::TooManyHeadersInOriginRequestPolicy(_inner) => {
                _inner.fmt(f)
            }
            UpdateOriginRequestPolicyErrorKind::TooManyQueryStringsInOriginRequestPolicy(
                _inner,
            ) => _inner.fmt(f),
            UpdateOriginRequestPolicyErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateOriginRequestPolicyError {
    fn code(&self) -> Option<&str> {
        UpdateOriginRequestPolicyError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateOriginRequestPolicyError {
    /// Creates a new `UpdateOriginRequestPolicyError`.
    pub fn new(kind: UpdateOriginRequestPolicyErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateOriginRequestPolicyError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateOriginRequestPolicyErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateOriginRequestPolicyError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateOriginRequestPolicyErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateOriginRequestPolicyErrorKind::AccessDenied`.
    pub fn is_access_denied(&self) -> bool {
        matches!(
            &self.kind,
            UpdateOriginRequestPolicyErrorKind::AccessDenied(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateOriginRequestPolicyErrorKind::IllegalUpdate`.
    pub fn is_illegal_update(&self) -> bool {
        matches!(
            &self.kind,
            UpdateOriginRequestPolicyErrorKind::IllegalUpdate(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateOriginRequestPolicyErrorKind::InconsistentQuantities`.
    pub fn is_inconsistent_quantities(&self) -> bool {
        matches!(
            &self.kind,
            UpdateOriginRequestPolicyErrorKind::InconsistentQuantities(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateOriginRequestPolicyErrorKind::InvalidArgument`.
    pub fn is_invalid_argument(&self) -> bool {
        matches!(
            &self.kind,
            UpdateOriginRequestPolicyErrorKind::InvalidArgument(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateOriginRequestPolicyErrorKind::InvalidIfMatchVersion`.
    pub fn is_invalid_if_match_version(&self) -> bool {
        matches!(
            &self.kind,
            UpdateOriginRequestPolicyErrorKind::InvalidIfMatchVersion(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateOriginRequestPolicyErrorKind::NoSuchOriginRequestPolicy`.
    pub fn is_no_such_origin_request_policy(&self) -> bool {
        matches!(
            &self.kind,
            UpdateOriginRequestPolicyErrorKind::NoSuchOriginRequestPolicy(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateOriginRequestPolicyErrorKind::OriginRequestPolicyAlreadyExists`.
    pub fn is_origin_request_policy_already_exists(&self) -> bool {
        matches!(
            &self.kind,
            UpdateOriginRequestPolicyErrorKind::OriginRequestPolicyAlreadyExists(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateOriginRequestPolicyErrorKind::PreconditionFailed`.
    pub fn is_precondition_failed(&self) -> bool {
        matches!(
            &self.kind,
            UpdateOriginRequestPolicyErrorKind::PreconditionFailed(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateOriginRequestPolicyErrorKind::TooManyCookiesInOriginRequestPolicy`.
    pub fn is_too_many_cookies_in_origin_request_policy(&self) -> bool {
        matches!(
            &self.kind,
            UpdateOriginRequestPolicyErrorKind::TooManyCookiesInOriginRequestPolicy(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateOriginRequestPolicyErrorKind::TooManyHeadersInOriginRequestPolicy`.
    pub fn is_too_many_headers_in_origin_request_policy(&self) -> bool {
        matches!(
            &self.kind,
            UpdateOriginRequestPolicyErrorKind::TooManyHeadersInOriginRequestPolicy(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateOriginRequestPolicyErrorKind::TooManyQueryStringsInOriginRequestPolicy`.
    pub fn is_too_many_query_strings_in_origin_request_policy(&self) -> bool {
        matches!(
            &self.kind,
            UpdateOriginRequestPolicyErrorKind::TooManyQueryStringsInOriginRequestPolicy(_)
        )
    }
}
impl std::error::Error for UpdateOriginRequestPolicyError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateOriginRequestPolicyErrorKind::AccessDenied(_inner) => Some(_inner),
            UpdateOriginRequestPolicyErrorKind::IllegalUpdate(_inner) => Some(_inner),
            UpdateOriginRequestPolicyErrorKind::InconsistentQuantities(_inner) => Some(_inner),
            UpdateOriginRequestPolicyErrorKind::InvalidArgument(_inner) => Some(_inner),
            UpdateOriginRequestPolicyErrorKind::InvalidIfMatchVersion(_inner) => Some(_inner),
            UpdateOriginRequestPolicyErrorKind::NoSuchOriginRequestPolicy(_inner) => Some(_inner),
            UpdateOriginRequestPolicyErrorKind::OriginRequestPolicyAlreadyExists(_inner) => {
                Some(_inner)
            }
            UpdateOriginRequestPolicyErrorKind::PreconditionFailed(_inner) => Some(_inner),
            UpdateOriginRequestPolicyErrorKind::TooManyCookiesInOriginRequestPolicy(_inner) => {
                Some(_inner)
            }
            UpdateOriginRequestPolicyErrorKind::TooManyHeadersInOriginRequestPolicy(_inner) => {
                Some(_inner)
            }
            UpdateOriginRequestPolicyErrorKind::TooManyQueryStringsInOriginRequestPolicy(
                _inner,
            ) => Some(_inner),
            UpdateOriginRequestPolicyErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdatePublicKey` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdatePublicKeyError {
    /// Kind of error that occurred.
    pub kind: UpdatePublicKeyErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdatePublicKey` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdatePublicKeyErrorKind {
    /// <p>Access denied.</p>
    AccessDenied(crate::error::AccessDenied),
    /// <p>You can't change the value of a public key.</p>
    CannotChangeImmutablePublicKeyFields(crate::error::CannotChangeImmutablePublicKeyFields),
    /// <p>The update contains modifications that are not allowed.</p>
    IllegalUpdate(crate::error::IllegalUpdate),
    /// <p>An argument is invalid.</p>
    InvalidArgument(crate::error::InvalidArgument),
    /// <p>The <code>If-Match</code> version is missing or not valid.</p>
    InvalidIfMatchVersion(crate::error::InvalidIfMatchVersion),
    /// <p>The specified public key doesn't exist.</p>
    NoSuchPublicKey(crate::error::NoSuchPublicKey),
    /// <p>The precondition in one or more of the request fields evaluated to <code>false</code>.</p>
    PreconditionFailed(crate::error::PreconditionFailed),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdatePublicKeyError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdatePublicKeyErrorKind::AccessDenied(_inner) => _inner.fmt(f),
            UpdatePublicKeyErrorKind::CannotChangeImmutablePublicKeyFields(_inner) => _inner.fmt(f),
            UpdatePublicKeyErrorKind::IllegalUpdate(_inner) => _inner.fmt(f),
            UpdatePublicKeyErrorKind::InvalidArgument(_inner) => _inner.fmt(f),
            UpdatePublicKeyErrorKind::InvalidIfMatchVersion(_inner) => _inner.fmt(f),
            UpdatePublicKeyErrorKind::NoSuchPublicKey(_inner) => _inner.fmt(f),
            UpdatePublicKeyErrorKind::PreconditionFailed(_inner) => _inner.fmt(f),
            UpdatePublicKeyErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdatePublicKeyError {
    fn code(&self) -> Option<&str> {
        UpdatePublicKeyError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdatePublicKeyError {
    /// Creates a new `UpdatePublicKeyError`.
    pub fn new(kind: UpdatePublicKeyErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdatePublicKeyError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdatePublicKeyErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdatePublicKeyError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdatePublicKeyErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdatePublicKeyErrorKind::AccessDenied`.
    pub fn is_access_denied(&self) -> bool {
        matches!(&self.kind, UpdatePublicKeyErrorKind::AccessDenied(_))
    }
    /// Returns `true` if the error kind is `UpdatePublicKeyErrorKind::CannotChangeImmutablePublicKeyFields`.
    pub fn is_cannot_change_immutable_public_key_fields(&self) -> bool {
        matches!(
            &self.kind,
            UpdatePublicKeyErrorKind::CannotChangeImmutablePublicKeyFields(_)
        )
    }
    /// Returns `true` if the error kind is `UpdatePublicKeyErrorKind::IllegalUpdate`.
    pub fn is_illegal_update(&self) -> bool {
        matches!(&self.kind, UpdatePublicKeyErrorKind::IllegalUpdate(_))
    }
    /// Returns `true` if the error kind is `UpdatePublicKeyErrorKind::InvalidArgument`.
    pub fn is_invalid_argument(&self) -> bool {
        matches!(&self.kind, UpdatePublicKeyErrorKind::InvalidArgument(_))
    }
    /// Returns `true` if the error kind is `UpdatePublicKeyErrorKind::InvalidIfMatchVersion`.
    pub fn is_invalid_if_match_version(&self) -> bool {
        matches!(
            &self.kind,
            UpdatePublicKeyErrorKind::InvalidIfMatchVersion(_)
        )
    }
    /// Returns `true` if the error kind is `UpdatePublicKeyErrorKind::NoSuchPublicKey`.
    pub fn is_no_such_public_key(&self) -> bool {
        matches!(&self.kind, UpdatePublicKeyErrorKind::NoSuchPublicKey(_))
    }
    /// Returns `true` if the error kind is `UpdatePublicKeyErrorKind::PreconditionFailed`.
    pub fn is_precondition_failed(&self) -> bool {
        matches!(&self.kind, UpdatePublicKeyErrorKind::PreconditionFailed(_))
    }
}
impl std::error::Error for UpdatePublicKeyError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdatePublicKeyErrorKind::AccessDenied(_inner) => Some(_inner),
            UpdatePublicKeyErrorKind::CannotChangeImmutablePublicKeyFields(_inner) => Some(_inner),
            UpdatePublicKeyErrorKind::IllegalUpdate(_inner) => Some(_inner),
            UpdatePublicKeyErrorKind::InvalidArgument(_inner) => Some(_inner),
            UpdatePublicKeyErrorKind::InvalidIfMatchVersion(_inner) => Some(_inner),
            UpdatePublicKeyErrorKind::NoSuchPublicKey(_inner) => Some(_inner),
            UpdatePublicKeyErrorKind::PreconditionFailed(_inner) => Some(_inner),
            UpdatePublicKeyErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateRealtimeLogConfig` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateRealtimeLogConfigError {
    /// Kind of error that occurred.
    pub kind: UpdateRealtimeLogConfigErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateRealtimeLogConfig` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateRealtimeLogConfigErrorKind {
    /// <p>Access denied.</p>
    AccessDenied(crate::error::AccessDenied),
    /// <p>An argument is invalid.</p>
    InvalidArgument(crate::error::InvalidArgument),
    /// <p>The real-time log configuration does not exist.</p>
    NoSuchRealtimeLogConfig(crate::error::NoSuchRealtimeLogConfig),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateRealtimeLogConfigError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateRealtimeLogConfigErrorKind::AccessDenied(_inner) => _inner.fmt(f),
            UpdateRealtimeLogConfigErrorKind::InvalidArgument(_inner) => _inner.fmt(f),
            UpdateRealtimeLogConfigErrorKind::NoSuchRealtimeLogConfig(_inner) => _inner.fmt(f),
            UpdateRealtimeLogConfigErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateRealtimeLogConfigError {
    fn code(&self) -> Option<&str> {
        UpdateRealtimeLogConfigError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateRealtimeLogConfigError {
    /// Creates a new `UpdateRealtimeLogConfigError`.
    pub fn new(kind: UpdateRealtimeLogConfigErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateRealtimeLogConfigError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateRealtimeLogConfigErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateRealtimeLogConfigError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateRealtimeLogConfigErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateRealtimeLogConfigErrorKind::AccessDenied`.
    pub fn is_access_denied(&self) -> bool {
        matches!(
            &self.kind,
            UpdateRealtimeLogConfigErrorKind::AccessDenied(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateRealtimeLogConfigErrorKind::InvalidArgument`.
    pub fn is_invalid_argument(&self) -> bool {
        matches!(
            &self.kind,
            UpdateRealtimeLogConfigErrorKind::InvalidArgument(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateRealtimeLogConfigErrorKind::NoSuchRealtimeLogConfig`.
    pub fn is_no_such_realtime_log_config(&self) -> bool {
        matches!(
            &self.kind,
            UpdateRealtimeLogConfigErrorKind::NoSuchRealtimeLogConfig(_)
        )
    }
}
impl std::error::Error for UpdateRealtimeLogConfigError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateRealtimeLogConfigErrorKind::AccessDenied(_inner) => Some(_inner),
            UpdateRealtimeLogConfigErrorKind::InvalidArgument(_inner) => Some(_inner),
            UpdateRealtimeLogConfigErrorKind::NoSuchRealtimeLogConfig(_inner) => Some(_inner),
            UpdateRealtimeLogConfigErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateResponseHeadersPolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateResponseHeadersPolicyError {
    /// Kind of error that occurred.
    pub kind: UpdateResponseHeadersPolicyErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateResponseHeadersPolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateResponseHeadersPolicyErrorKind {
    /// <p>Access denied.</p>
    AccessDenied(crate::error::AccessDenied),
    /// <p>The update contains modifications that are not allowed.</p>
    IllegalUpdate(crate::error::IllegalUpdate),
    /// <p>The value of <code>Quantity</code> and the size of <code>Items</code> don't match.</p>
    InconsistentQuantities(crate::error::InconsistentQuantities),
    /// <p>An argument is invalid.</p>
    InvalidArgument(crate::error::InvalidArgument),
    /// <p>The <code>If-Match</code> version is missing or not valid.</p>
    InvalidIfMatchVersion(crate::error::InvalidIfMatchVersion),
    /// <p>The response headers policy does not exist.</p>
    NoSuchResponseHeadersPolicy(crate::error::NoSuchResponseHeadersPolicy),
    /// <p>The precondition in one or more of the request fields evaluated to <code>false</code>.</p>
    PreconditionFailed(crate::error::PreconditionFailed),
    /// <p>A response headers policy with this name already exists. You must provide a unique name. To modify an existing response headers policy, use <code>UpdateResponseHeadersPolicy</code>.</p>
    ResponseHeadersPolicyAlreadyExists(crate::error::ResponseHeadersPolicyAlreadyExists),
    /// <p>The number of custom headers in the response headers policy exceeds the maximum.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html">Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.</p>
    TooManyCustomHeadersInResponseHeadersPolicy(
        crate::error::TooManyCustomHeadersInResponseHeadersPolicy,
    ),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateResponseHeadersPolicyError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateResponseHeadersPolicyErrorKind::AccessDenied(_inner) => _inner.fmt(f),
            UpdateResponseHeadersPolicyErrorKind::IllegalUpdate(_inner) => _inner.fmt(f),
            UpdateResponseHeadersPolicyErrorKind::InconsistentQuantities(_inner) => _inner.fmt(f),
            UpdateResponseHeadersPolicyErrorKind::InvalidArgument(_inner) => _inner.fmt(f),
            UpdateResponseHeadersPolicyErrorKind::InvalidIfMatchVersion(_inner) => _inner.fmt(f),
            UpdateResponseHeadersPolicyErrorKind::NoSuchResponseHeadersPolicy(_inner) => {
                _inner.fmt(f)
            }
            UpdateResponseHeadersPolicyErrorKind::PreconditionFailed(_inner) => _inner.fmt(f),
            UpdateResponseHeadersPolicyErrorKind::ResponseHeadersPolicyAlreadyExists(_inner) => {
                _inner.fmt(f)
            }
            UpdateResponseHeadersPolicyErrorKind::TooManyCustomHeadersInResponseHeadersPolicy(
                _inner,
            ) => _inner.fmt(f),
            UpdateResponseHeadersPolicyErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateResponseHeadersPolicyError {
    fn code(&self) -> Option<&str> {
        UpdateResponseHeadersPolicyError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateResponseHeadersPolicyError {
    /// Creates a new `UpdateResponseHeadersPolicyError`.
    pub fn new(kind: UpdateResponseHeadersPolicyErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateResponseHeadersPolicyError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateResponseHeadersPolicyErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateResponseHeadersPolicyError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateResponseHeadersPolicyErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateResponseHeadersPolicyErrorKind::AccessDenied`.
    pub fn is_access_denied(&self) -> bool {
        matches!(
            &self.kind,
            UpdateResponseHeadersPolicyErrorKind::AccessDenied(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateResponseHeadersPolicyErrorKind::IllegalUpdate`.
    pub fn is_illegal_update(&self) -> bool {
        matches!(
            &self.kind,
            UpdateResponseHeadersPolicyErrorKind::IllegalUpdate(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateResponseHeadersPolicyErrorKind::InconsistentQuantities`.
    pub fn is_inconsistent_quantities(&self) -> bool {
        matches!(
            &self.kind,
            UpdateResponseHeadersPolicyErrorKind::InconsistentQuantities(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateResponseHeadersPolicyErrorKind::InvalidArgument`.
    pub fn is_invalid_argument(&self) -> bool {
        matches!(
            &self.kind,
            UpdateResponseHeadersPolicyErrorKind::InvalidArgument(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateResponseHeadersPolicyErrorKind::InvalidIfMatchVersion`.
    pub fn is_invalid_if_match_version(&self) -> bool {
        matches!(
            &self.kind,
            UpdateResponseHeadersPolicyErrorKind::InvalidIfMatchVersion(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateResponseHeadersPolicyErrorKind::NoSuchResponseHeadersPolicy`.
    pub fn is_no_such_response_headers_policy(&self) -> bool {
        matches!(
            &self.kind,
            UpdateResponseHeadersPolicyErrorKind::NoSuchResponseHeadersPolicy(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateResponseHeadersPolicyErrorKind::PreconditionFailed`.
    pub fn is_precondition_failed(&self) -> bool {
        matches!(
            &self.kind,
            UpdateResponseHeadersPolicyErrorKind::PreconditionFailed(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateResponseHeadersPolicyErrorKind::ResponseHeadersPolicyAlreadyExists`.
    pub fn is_response_headers_policy_already_exists(&self) -> bool {
        matches!(
            &self.kind,
            UpdateResponseHeadersPolicyErrorKind::ResponseHeadersPolicyAlreadyExists(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateResponseHeadersPolicyErrorKind::TooManyCustomHeadersInResponseHeadersPolicy`.
    pub fn is_too_many_custom_headers_in_response_headers_policy(&self) -> bool {
        matches!(
            &self.kind,
            UpdateResponseHeadersPolicyErrorKind::TooManyCustomHeadersInResponseHeadersPolicy(_)
        )
    }
}
impl std::error::Error for UpdateResponseHeadersPolicyError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateResponseHeadersPolicyErrorKind::AccessDenied(_inner) => Some(_inner),
            UpdateResponseHeadersPolicyErrorKind::IllegalUpdate(_inner) => Some(_inner),
            UpdateResponseHeadersPolicyErrorKind::InconsistentQuantities(_inner) => Some(_inner),
            UpdateResponseHeadersPolicyErrorKind::InvalidArgument(_inner) => Some(_inner),
            UpdateResponseHeadersPolicyErrorKind::InvalidIfMatchVersion(_inner) => Some(_inner),
            UpdateResponseHeadersPolicyErrorKind::NoSuchResponseHeadersPolicy(_inner) => {
                Some(_inner)
            }
            UpdateResponseHeadersPolicyErrorKind::PreconditionFailed(_inner) => Some(_inner),
            UpdateResponseHeadersPolicyErrorKind::ResponseHeadersPolicyAlreadyExists(_inner) => {
                Some(_inner)
            }
            UpdateResponseHeadersPolicyErrorKind::TooManyCustomHeadersInResponseHeadersPolicy(
                _inner,
            ) => Some(_inner),
            UpdateResponseHeadersPolicyErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateStreamingDistribution` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateStreamingDistributionError {
    /// Kind of error that occurred.
    pub kind: UpdateStreamingDistributionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateStreamingDistribution` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateStreamingDistributionErrorKind {
    /// <p>Access denied.</p>
    AccessDenied(crate::error::AccessDenied),
    /// <p>The CNAME specified is already defined for CloudFront.</p>
    CnameAlreadyExists(crate::error::CnameAlreadyExists),
    /// <p>The update contains modifications that are not allowed.</p>
    IllegalUpdate(crate::error::IllegalUpdate),
    /// <p>The value of <code>Quantity</code> and the size of <code>Items</code> don't match.</p>
    InconsistentQuantities(crate::error::InconsistentQuantities),
    /// <p>An argument is invalid.</p>
    InvalidArgument(crate::error::InvalidArgument),
    /// <p>The <code>If-Match</code> version is missing or not valid.</p>
    InvalidIfMatchVersion(crate::error::InvalidIfMatchVersion),
    /// <p>The origin access identity is not valid or doesn't exist.</p>
    InvalidOriginAccessIdentity(crate::error::InvalidOriginAccessIdentity),
    /// <p>This operation requires a body. Ensure that the body is present and the <code>Content-Type</code> header is set.</p>
    MissingBody(crate::error::MissingBody),
    /// <p>The specified streaming distribution does not exist.</p>
    NoSuchStreamingDistribution(crate::error::NoSuchStreamingDistribution),
    /// <p>The precondition in one or more of the request fields evaluated to <code>false</code>.</p>
    PreconditionFailed(crate::error::PreconditionFailed),
    /// <p>Your request contains more CNAMEs than are allowed per distribution.</p>
    TooManyStreamingDistributionCnamEs(crate::error::TooManyStreamingDistributionCnamEs),
    /// <p>Your request contains more trusted signers than are allowed per distribution.</p>
    TooManyTrustedSigners(crate::error::TooManyTrustedSigners),
    /// <p>One or more of your trusted signers don't exist.</p>
    TrustedSignerDoesNotExist(crate::error::TrustedSignerDoesNotExist),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateStreamingDistributionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateStreamingDistributionErrorKind::AccessDenied(_inner) => _inner.fmt(f),
            UpdateStreamingDistributionErrorKind::CnameAlreadyExists(_inner) => _inner.fmt(f),
            UpdateStreamingDistributionErrorKind::IllegalUpdate(_inner) => _inner.fmt(f),
            UpdateStreamingDistributionErrorKind::InconsistentQuantities(_inner) => _inner.fmt(f),
            UpdateStreamingDistributionErrorKind::InvalidArgument(_inner) => _inner.fmt(f),
            UpdateStreamingDistributionErrorKind::InvalidIfMatchVersion(_inner) => _inner.fmt(f),
            UpdateStreamingDistributionErrorKind::InvalidOriginAccessIdentity(_inner) => {
                _inner.fmt(f)
            }
            UpdateStreamingDistributionErrorKind::MissingBody(_inner) => _inner.fmt(f),
            UpdateStreamingDistributionErrorKind::NoSuchStreamingDistribution(_inner) => {
                _inner.fmt(f)
            }
            UpdateStreamingDistributionErrorKind::PreconditionFailed(_inner) => _inner.fmt(f),
            UpdateStreamingDistributionErrorKind::TooManyStreamingDistributionCnamEs(_inner) => {
                _inner.fmt(f)
            }
            UpdateStreamingDistributionErrorKind::TooManyTrustedSigners(_inner) => _inner.fmt(f),
            UpdateStreamingDistributionErrorKind::TrustedSignerDoesNotExist(_inner) => {
                _inner.fmt(f)
            }
            UpdateStreamingDistributionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateStreamingDistributionError {
    fn code(&self) -> Option<&str> {
        UpdateStreamingDistributionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateStreamingDistributionError {
    /// Creates a new `UpdateStreamingDistributionError`.
    pub fn new(kind: UpdateStreamingDistributionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateStreamingDistributionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateStreamingDistributionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateStreamingDistributionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateStreamingDistributionErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateStreamingDistributionErrorKind::AccessDenied`.
    pub fn is_access_denied(&self) -> bool {
        matches!(
            &self.kind,
            UpdateStreamingDistributionErrorKind::AccessDenied(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateStreamingDistributionErrorKind::CnameAlreadyExists`.
    pub fn is_cname_already_exists(&self) -> bool {
        matches!(
            &self.kind,
            UpdateStreamingDistributionErrorKind::CnameAlreadyExists(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateStreamingDistributionErrorKind::IllegalUpdate`.
    pub fn is_illegal_update(&self) -> bool {
        matches!(
            &self.kind,
            UpdateStreamingDistributionErrorKind::IllegalUpdate(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateStreamingDistributionErrorKind::InconsistentQuantities`.
    pub fn is_inconsistent_quantities(&self) -> bool {
        matches!(
            &self.kind,
            UpdateStreamingDistributionErrorKind::InconsistentQuantities(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateStreamingDistributionErrorKind::InvalidArgument`.
    pub fn is_invalid_argument(&self) -> bool {
        matches!(
            &self.kind,
            UpdateStreamingDistributionErrorKind::InvalidArgument(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateStreamingDistributionErrorKind::InvalidIfMatchVersion`.
    pub fn is_invalid_if_match_version(&self) -> bool {
        matches!(
            &self.kind,
            UpdateStreamingDistributionErrorKind::InvalidIfMatchVersion(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateStreamingDistributionErrorKind::InvalidOriginAccessIdentity`.
    pub fn is_invalid_origin_access_identity(&self) -> bool {
        matches!(
            &self.kind,
            UpdateStreamingDistributionErrorKind::InvalidOriginAccessIdentity(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateStreamingDistributionErrorKind::MissingBody`.
    pub fn is_missing_body(&self) -> bool {
        matches!(
            &self.kind,
            UpdateStreamingDistributionErrorKind::MissingBody(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateStreamingDistributionErrorKind::NoSuchStreamingDistribution`.
    pub fn is_no_such_streaming_distribution(&self) -> bool {
        matches!(
            &self.kind,
            UpdateStreamingDistributionErrorKind::NoSuchStreamingDistribution(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateStreamingDistributionErrorKind::PreconditionFailed`.
    pub fn is_precondition_failed(&self) -> bool {
        matches!(
            &self.kind,
            UpdateStreamingDistributionErrorKind::PreconditionFailed(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateStreamingDistributionErrorKind::TooManyStreamingDistributionCnamEs`.
    pub fn is_too_many_streaming_distribution_cnam_es(&self) -> bool {
        matches!(
            &self.kind,
            UpdateStreamingDistributionErrorKind::TooManyStreamingDistributionCnamEs(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateStreamingDistributionErrorKind::TooManyTrustedSigners`.
    pub fn is_too_many_trusted_signers(&self) -> bool {
        matches!(
            &self.kind,
            UpdateStreamingDistributionErrorKind::TooManyTrustedSigners(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateStreamingDistributionErrorKind::TrustedSignerDoesNotExist`.
    pub fn is_trusted_signer_does_not_exist(&self) -> bool {
        matches!(
            &self.kind,
            UpdateStreamingDistributionErrorKind::TrustedSignerDoesNotExist(_)
        )
    }
}
impl std::error::Error for UpdateStreamingDistributionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateStreamingDistributionErrorKind::AccessDenied(_inner) => Some(_inner),
            UpdateStreamingDistributionErrorKind::CnameAlreadyExists(_inner) => Some(_inner),
            UpdateStreamingDistributionErrorKind::IllegalUpdate(_inner) => Some(_inner),
            UpdateStreamingDistributionErrorKind::InconsistentQuantities(_inner) => Some(_inner),
            UpdateStreamingDistributionErrorKind::InvalidArgument(_inner) => Some(_inner),
            UpdateStreamingDistributionErrorKind::InvalidIfMatchVersion(_inner) => Some(_inner),
            UpdateStreamingDistributionErrorKind::InvalidOriginAccessIdentity(_inner) => {
                Some(_inner)
            }
            UpdateStreamingDistributionErrorKind::MissingBody(_inner) => Some(_inner),
            UpdateStreamingDistributionErrorKind::NoSuchStreamingDistribution(_inner) => {
                Some(_inner)
            }
            UpdateStreamingDistributionErrorKind::PreconditionFailed(_inner) => Some(_inner),
            UpdateStreamingDistributionErrorKind::TooManyStreamingDistributionCnamEs(_inner) => {
                Some(_inner)
            }
            UpdateStreamingDistributionErrorKind::TooManyTrustedSigners(_inner) => Some(_inner),
            UpdateStreamingDistributionErrorKind::TrustedSignerDoesNotExist(_inner) => Some(_inner),
            UpdateStreamingDistributionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// <p>One or more of your trusted signers don't exist.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TrustedSignerDoesNotExist {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for TrustedSignerDoesNotExist {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TrustedSignerDoesNotExist");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl TrustedSignerDoesNotExist {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for TrustedSignerDoesNotExist {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "TrustedSignerDoesNotExist")?;
        if let Some(inner_1) = &self.message {
            write!(f, ": {}", inner_1)?;
        }
        Ok(())
    }
}
impl std::error::Error for TrustedSignerDoesNotExist {}
/// See [`TrustedSignerDoesNotExist`](crate::error::TrustedSignerDoesNotExist)
pub mod trusted_signer_does_not_exist {
    /// A builder for [`TrustedSignerDoesNotExist`](crate::error::TrustedSignerDoesNotExist)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`TrustedSignerDoesNotExist`](crate::error::TrustedSignerDoesNotExist)
        pub fn build(self) -> crate::error::TrustedSignerDoesNotExist {
            crate::error::TrustedSignerDoesNotExist {
                message: self.message,
            }
        }
    }
}
impl TrustedSignerDoesNotExist {
    /// Creates a new builder-style object to manufacture [`TrustedSignerDoesNotExist`](crate::error::TrustedSignerDoesNotExist)
    pub fn builder() -> crate::error::trusted_signer_does_not_exist::Builder {
        crate::error::trusted_signer_does_not_exist::Builder::default()
    }
}

/// <p>Your request contains more trusted signers than are allowed per distribution.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TooManyTrustedSigners {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for TooManyTrustedSigners {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TooManyTrustedSigners");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl TooManyTrustedSigners {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for TooManyTrustedSigners {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "TooManyTrustedSigners")?;
        if let Some(inner_2) = &self.message {
            write!(f, ": {}", inner_2)?;
        }
        Ok(())
    }
}
impl std::error::Error for TooManyTrustedSigners {}
/// See [`TooManyTrustedSigners`](crate::error::TooManyTrustedSigners)
pub mod too_many_trusted_signers {
    /// A builder for [`TooManyTrustedSigners`](crate::error::TooManyTrustedSigners)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`TooManyTrustedSigners`](crate::error::TooManyTrustedSigners)
        pub fn build(self) -> crate::error::TooManyTrustedSigners {
            crate::error::TooManyTrustedSigners {
                message: self.message,
            }
        }
    }
}
impl TooManyTrustedSigners {
    /// Creates a new builder-style object to manufacture [`TooManyTrustedSigners`](crate::error::TooManyTrustedSigners)
    pub fn builder() -> crate::error::too_many_trusted_signers::Builder {
        crate::error::too_many_trusted_signers::Builder::default()
    }
}

/// <p>Your request contains more CNAMEs than are allowed per distribution.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TooManyStreamingDistributionCnamEs {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for TooManyStreamingDistributionCnamEs {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TooManyStreamingDistributionCnamEs");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl TooManyStreamingDistributionCnamEs {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for TooManyStreamingDistributionCnamEs {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(
            f,
            "TooManyStreamingDistributionCnamEs [TooManyStreamingDistributionCNAMEs]"
        )?;
        if let Some(inner_3) = &self.message {
            write!(f, ": {}", inner_3)?;
        }
        Ok(())
    }
}
impl std::error::Error for TooManyStreamingDistributionCnamEs {}
/// See [`TooManyStreamingDistributionCnamEs`](crate::error::TooManyStreamingDistributionCnamEs)
pub mod too_many_streaming_distribution_cnam_es {
    /// A builder for [`TooManyStreamingDistributionCnamEs`](crate::error::TooManyStreamingDistributionCnamEs)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`TooManyStreamingDistributionCnamEs`](crate::error::TooManyStreamingDistributionCnamEs)
        pub fn build(self) -> crate::error::TooManyStreamingDistributionCnamEs {
            crate::error::TooManyStreamingDistributionCnamEs {
                message: self.message,
            }
        }
    }
}
impl TooManyStreamingDistributionCnamEs {
    /// Creates a new builder-style object to manufacture [`TooManyStreamingDistributionCnamEs`](crate::error::TooManyStreamingDistributionCnamEs)
    pub fn builder() -> crate::error::too_many_streaming_distribution_cnam_es::Builder {
        crate::error::too_many_streaming_distribution_cnam_es::Builder::default()
    }
}

/// <p>The precondition in one or more of the request fields evaluated to <code>false</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PreconditionFailed {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for PreconditionFailed {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PreconditionFailed");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl PreconditionFailed {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for PreconditionFailed {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "PreconditionFailed")?;
        if let Some(inner_4) = &self.message {
            write!(f, ": {}", inner_4)?;
        }
        Ok(())
    }
}
impl std::error::Error for PreconditionFailed {}
/// See [`PreconditionFailed`](crate::error::PreconditionFailed)
pub mod precondition_failed {
    /// A builder for [`PreconditionFailed`](crate::error::PreconditionFailed)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`PreconditionFailed`](crate::error::PreconditionFailed)
        pub fn build(self) -> crate::error::PreconditionFailed {
            crate::error::PreconditionFailed {
                message: self.message,
            }
        }
    }
}
impl PreconditionFailed {
    /// Creates a new builder-style object to manufacture [`PreconditionFailed`](crate::error::PreconditionFailed)
    pub fn builder() -> crate::error::precondition_failed::Builder {
        crate::error::precondition_failed::Builder::default()
    }
}

/// <p>The specified streaming distribution does not exist.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct NoSuchStreamingDistribution {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for NoSuchStreamingDistribution {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("NoSuchStreamingDistribution");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl NoSuchStreamingDistribution {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for NoSuchStreamingDistribution {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "NoSuchStreamingDistribution")?;
        if let Some(inner_5) = &self.message {
            write!(f, ": {}", inner_5)?;
        }
        Ok(())
    }
}
impl std::error::Error for NoSuchStreamingDistribution {}
/// See [`NoSuchStreamingDistribution`](crate::error::NoSuchStreamingDistribution)
pub mod no_such_streaming_distribution {
    /// A builder for [`NoSuchStreamingDistribution`](crate::error::NoSuchStreamingDistribution)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`NoSuchStreamingDistribution`](crate::error::NoSuchStreamingDistribution)
        pub fn build(self) -> crate::error::NoSuchStreamingDistribution {
            crate::error::NoSuchStreamingDistribution {
                message: self.message,
            }
        }
    }
}
impl NoSuchStreamingDistribution {
    /// Creates a new builder-style object to manufacture [`NoSuchStreamingDistribution`](crate::error::NoSuchStreamingDistribution)
    pub fn builder() -> crate::error::no_such_streaming_distribution::Builder {
        crate::error::no_such_streaming_distribution::Builder::default()
    }
}

/// <p>This operation requires a body. Ensure that the body is present and the <code>Content-Type</code> header is set.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MissingBody {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for MissingBody {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MissingBody");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl MissingBody {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for MissingBody {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "MissingBody")?;
        if let Some(inner_6) = &self.message {
            write!(f, ": {}", inner_6)?;
        }
        Ok(())
    }
}
impl std::error::Error for MissingBody {}
/// See [`MissingBody`](crate::error::MissingBody)
pub mod missing_body {
    /// A builder for [`MissingBody`](crate::error::MissingBody)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`MissingBody`](crate::error::MissingBody)
        pub fn build(self) -> crate::error::MissingBody {
            crate::error::MissingBody {
                message: self.message,
            }
        }
    }
}
impl MissingBody {
    /// Creates a new builder-style object to manufacture [`MissingBody`](crate::error::MissingBody)
    pub fn builder() -> crate::error::missing_body::Builder {
        crate::error::missing_body::Builder::default()
    }
}

/// <p>The origin access identity is not valid or doesn't exist.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidOriginAccessIdentity {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidOriginAccessIdentity {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidOriginAccessIdentity");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidOriginAccessIdentity {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidOriginAccessIdentity {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidOriginAccessIdentity")?;
        if let Some(inner_7) = &self.message {
            write!(f, ": {}", inner_7)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidOriginAccessIdentity {}
/// See [`InvalidOriginAccessIdentity`](crate::error::InvalidOriginAccessIdentity)
pub mod invalid_origin_access_identity {
    /// A builder for [`InvalidOriginAccessIdentity`](crate::error::InvalidOriginAccessIdentity)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidOriginAccessIdentity`](crate::error::InvalidOriginAccessIdentity)
        pub fn build(self) -> crate::error::InvalidOriginAccessIdentity {
            crate::error::InvalidOriginAccessIdentity {
                message: self.message,
            }
        }
    }
}
impl InvalidOriginAccessIdentity {
    /// Creates a new builder-style object to manufacture [`InvalidOriginAccessIdentity`](crate::error::InvalidOriginAccessIdentity)
    pub fn builder() -> crate::error::invalid_origin_access_identity::Builder {
        crate::error::invalid_origin_access_identity::Builder::default()
    }
}

/// <p>The <code>If-Match</code> version is missing or not valid.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidIfMatchVersion {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidIfMatchVersion {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidIfMatchVersion");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidIfMatchVersion {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidIfMatchVersion {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidIfMatchVersion")?;
        if let Some(inner_8) = &self.message {
            write!(f, ": {}", inner_8)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidIfMatchVersion {}
/// See [`InvalidIfMatchVersion`](crate::error::InvalidIfMatchVersion)
pub mod invalid_if_match_version {
    /// A builder for [`InvalidIfMatchVersion`](crate::error::InvalidIfMatchVersion)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidIfMatchVersion`](crate::error::InvalidIfMatchVersion)
        pub fn build(self) -> crate::error::InvalidIfMatchVersion {
            crate::error::InvalidIfMatchVersion {
                message: self.message,
            }
        }
    }
}
impl InvalidIfMatchVersion {
    /// Creates a new builder-style object to manufacture [`InvalidIfMatchVersion`](crate::error::InvalidIfMatchVersion)
    pub fn builder() -> crate::error::invalid_if_match_version::Builder {
        crate::error::invalid_if_match_version::Builder::default()
    }
}

/// <p>An argument is invalid.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidArgument {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidArgument {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidArgument");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidArgument {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidArgument {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidArgument")?;
        if let Some(inner_9) = &self.message {
            write!(f, ": {}", inner_9)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidArgument {}
/// See [`InvalidArgument`](crate::error::InvalidArgument)
pub mod invalid_argument {
    /// A builder for [`InvalidArgument`](crate::error::InvalidArgument)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidArgument`](crate::error::InvalidArgument)
        pub fn build(self) -> crate::error::InvalidArgument {
            crate::error::InvalidArgument {
                message: self.message,
            }
        }
    }
}
impl InvalidArgument {
    /// Creates a new builder-style object to manufacture [`InvalidArgument`](crate::error::InvalidArgument)
    pub fn builder() -> crate::error::invalid_argument::Builder {
        crate::error::invalid_argument::Builder::default()
    }
}

/// <p>The value of <code>Quantity</code> and the size of <code>Items</code> don't match.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InconsistentQuantities {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InconsistentQuantities {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InconsistentQuantities");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InconsistentQuantities {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InconsistentQuantities {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InconsistentQuantities")?;
        if let Some(inner_10) = &self.message {
            write!(f, ": {}", inner_10)?;
        }
        Ok(())
    }
}
impl std::error::Error for InconsistentQuantities {}
/// See [`InconsistentQuantities`](crate::error::InconsistentQuantities)
pub mod inconsistent_quantities {
    /// A builder for [`InconsistentQuantities`](crate::error::InconsistentQuantities)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InconsistentQuantities`](crate::error::InconsistentQuantities)
        pub fn build(self) -> crate::error::InconsistentQuantities {
            crate::error::InconsistentQuantities {
                message: self.message,
            }
        }
    }
}
impl InconsistentQuantities {
    /// Creates a new builder-style object to manufacture [`InconsistentQuantities`](crate::error::InconsistentQuantities)
    pub fn builder() -> crate::error::inconsistent_quantities::Builder {
        crate::error::inconsistent_quantities::Builder::default()
    }
}

/// <p>The update contains modifications that are not allowed.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct IllegalUpdate {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for IllegalUpdate {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("IllegalUpdate");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl IllegalUpdate {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for IllegalUpdate {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "IllegalUpdate")?;
        if let Some(inner_11) = &self.message {
            write!(f, ": {}", inner_11)?;
        }
        Ok(())
    }
}
impl std::error::Error for IllegalUpdate {}
/// See [`IllegalUpdate`](crate::error::IllegalUpdate)
pub mod illegal_update {
    /// A builder for [`IllegalUpdate`](crate::error::IllegalUpdate)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`IllegalUpdate`](crate::error::IllegalUpdate)
        pub fn build(self) -> crate::error::IllegalUpdate {
            crate::error::IllegalUpdate {
                message: self.message,
            }
        }
    }
}
impl IllegalUpdate {
    /// Creates a new builder-style object to manufacture [`IllegalUpdate`](crate::error::IllegalUpdate)
    pub fn builder() -> crate::error::illegal_update::Builder {
        crate::error::illegal_update::Builder::default()
    }
}

/// <p>The CNAME specified is already defined for CloudFront.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CnameAlreadyExists {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for CnameAlreadyExists {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CnameAlreadyExists");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl CnameAlreadyExists {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for CnameAlreadyExists {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "CnameAlreadyExists [CNAMEAlreadyExists]")?;
        if let Some(inner_12) = &self.message {
            write!(f, ": {}", inner_12)?;
        }
        Ok(())
    }
}
impl std::error::Error for CnameAlreadyExists {}
/// See [`CnameAlreadyExists`](crate::error::CnameAlreadyExists)
pub mod cname_already_exists {
    /// A builder for [`CnameAlreadyExists`](crate::error::CnameAlreadyExists)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`CnameAlreadyExists`](crate::error::CnameAlreadyExists)
        pub fn build(self) -> crate::error::CnameAlreadyExists {
            crate::error::CnameAlreadyExists {
                message: self.message,
            }
        }
    }
}
impl CnameAlreadyExists {
    /// Creates a new builder-style object to manufacture [`CnameAlreadyExists`](crate::error::CnameAlreadyExists)
    pub fn builder() -> crate::error::cname_already_exists::Builder {
        crate::error::cname_already_exists::Builder::default()
    }
}

/// <p>Access denied.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AccessDenied {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for AccessDenied {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AccessDenied");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl AccessDenied {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for AccessDenied {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "AccessDenied")?;
        if let Some(inner_13) = &self.message {
            write!(f, ": {}", inner_13)?;
        }
        Ok(())
    }
}
impl std::error::Error for AccessDenied {}
/// See [`AccessDenied`](crate::error::AccessDenied)
pub mod access_denied {
    /// A builder for [`AccessDenied`](crate::error::AccessDenied)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`AccessDenied`](crate::error::AccessDenied)
        pub fn build(self) -> crate::error::AccessDenied {
            crate::error::AccessDenied {
                message: self.message,
            }
        }
    }
}
impl AccessDenied {
    /// Creates a new builder-style object to manufacture [`AccessDenied`](crate::error::AccessDenied)
    pub fn builder() -> crate::error::access_denied::Builder {
        crate::error::access_denied::Builder::default()
    }
}

/// <p>The number of custom headers in the response headers policy exceeds the maximum.</p>
/// <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html">Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TooManyCustomHeadersInResponseHeadersPolicy {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for TooManyCustomHeadersInResponseHeadersPolicy {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TooManyCustomHeadersInResponseHeadersPolicy");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl TooManyCustomHeadersInResponseHeadersPolicy {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for TooManyCustomHeadersInResponseHeadersPolicy {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "TooManyCustomHeadersInResponseHeadersPolicy")?;
        if let Some(inner_14) = &self.message {
            write!(f, ": {}", inner_14)?;
        }
        Ok(())
    }
}
impl std::error::Error for TooManyCustomHeadersInResponseHeadersPolicy {}
/// See [`TooManyCustomHeadersInResponseHeadersPolicy`](crate::error::TooManyCustomHeadersInResponseHeadersPolicy)
pub mod too_many_custom_headers_in_response_headers_policy {
    /// A builder for [`TooManyCustomHeadersInResponseHeadersPolicy`](crate::error::TooManyCustomHeadersInResponseHeadersPolicy)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`TooManyCustomHeadersInResponseHeadersPolicy`](crate::error::TooManyCustomHeadersInResponseHeadersPolicy)
        pub fn build(self) -> crate::error::TooManyCustomHeadersInResponseHeadersPolicy {
            crate::error::TooManyCustomHeadersInResponseHeadersPolicy {
                message: self.message,
            }
        }
    }
}
impl TooManyCustomHeadersInResponseHeadersPolicy {
    /// Creates a new builder-style object to manufacture [`TooManyCustomHeadersInResponseHeadersPolicy`](crate::error::TooManyCustomHeadersInResponseHeadersPolicy)
    pub fn builder() -> crate::error::too_many_custom_headers_in_response_headers_policy::Builder {
        crate::error::too_many_custom_headers_in_response_headers_policy::Builder::default()
    }
}

/// <p>A response headers policy with this name already exists. You must provide a unique name. To modify an existing response headers policy, use <code>UpdateResponseHeadersPolicy</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResponseHeadersPolicyAlreadyExists {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ResponseHeadersPolicyAlreadyExists {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResponseHeadersPolicyAlreadyExists");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ResponseHeadersPolicyAlreadyExists {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ResponseHeadersPolicyAlreadyExists {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ResponseHeadersPolicyAlreadyExists")?;
        if let Some(inner_15) = &self.message {
            write!(f, ": {}", inner_15)?;
        }
        Ok(())
    }
}
impl std::error::Error for ResponseHeadersPolicyAlreadyExists {}
/// See [`ResponseHeadersPolicyAlreadyExists`](crate::error::ResponseHeadersPolicyAlreadyExists)
pub mod response_headers_policy_already_exists {
    /// A builder for [`ResponseHeadersPolicyAlreadyExists`](crate::error::ResponseHeadersPolicyAlreadyExists)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ResponseHeadersPolicyAlreadyExists`](crate::error::ResponseHeadersPolicyAlreadyExists)
        pub fn build(self) -> crate::error::ResponseHeadersPolicyAlreadyExists {
            crate::error::ResponseHeadersPolicyAlreadyExists {
                message: self.message,
            }
        }
    }
}
impl ResponseHeadersPolicyAlreadyExists {
    /// Creates a new builder-style object to manufacture [`ResponseHeadersPolicyAlreadyExists`](crate::error::ResponseHeadersPolicyAlreadyExists)
    pub fn builder() -> crate::error::response_headers_policy_already_exists::Builder {
        crate::error::response_headers_policy_already_exists::Builder::default()
    }
}

/// <p>The response headers policy does not exist.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct NoSuchResponseHeadersPolicy {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for NoSuchResponseHeadersPolicy {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("NoSuchResponseHeadersPolicy");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl NoSuchResponseHeadersPolicy {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for NoSuchResponseHeadersPolicy {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "NoSuchResponseHeadersPolicy")?;
        if let Some(inner_16) = &self.message {
            write!(f, ": {}", inner_16)?;
        }
        Ok(())
    }
}
impl std::error::Error for NoSuchResponseHeadersPolicy {}
/// See [`NoSuchResponseHeadersPolicy`](crate::error::NoSuchResponseHeadersPolicy)
pub mod no_such_response_headers_policy {
    /// A builder for [`NoSuchResponseHeadersPolicy`](crate::error::NoSuchResponseHeadersPolicy)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`NoSuchResponseHeadersPolicy`](crate::error::NoSuchResponseHeadersPolicy)
        pub fn build(self) -> crate::error::NoSuchResponseHeadersPolicy {
            crate::error::NoSuchResponseHeadersPolicy {
                message: self.message,
            }
        }
    }
}
impl NoSuchResponseHeadersPolicy {
    /// Creates a new builder-style object to manufacture [`NoSuchResponseHeadersPolicy`](crate::error::NoSuchResponseHeadersPolicy)
    pub fn builder() -> crate::error::no_such_response_headers_policy::Builder {
        crate::error::no_such_response_headers_policy::Builder::default()
    }
}

/// <p>The real-time log configuration does not exist.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct NoSuchRealtimeLogConfig {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for NoSuchRealtimeLogConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("NoSuchRealtimeLogConfig");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl NoSuchRealtimeLogConfig {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for NoSuchRealtimeLogConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "NoSuchRealtimeLogConfig")?;
        if let Some(inner_17) = &self.message {
            write!(f, ": {}", inner_17)?;
        }
        Ok(())
    }
}
impl std::error::Error for NoSuchRealtimeLogConfig {}
/// See [`NoSuchRealtimeLogConfig`](crate::error::NoSuchRealtimeLogConfig)
pub mod no_such_realtime_log_config {
    /// A builder for [`NoSuchRealtimeLogConfig`](crate::error::NoSuchRealtimeLogConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`NoSuchRealtimeLogConfig`](crate::error::NoSuchRealtimeLogConfig)
        pub fn build(self) -> crate::error::NoSuchRealtimeLogConfig {
            crate::error::NoSuchRealtimeLogConfig {
                message: self.message,
            }
        }
    }
}
impl NoSuchRealtimeLogConfig {
    /// Creates a new builder-style object to manufacture [`NoSuchRealtimeLogConfig`](crate::error::NoSuchRealtimeLogConfig)
    pub fn builder() -> crate::error::no_such_realtime_log_config::Builder {
        crate::error::no_such_realtime_log_config::Builder::default()
    }
}

/// <p>The specified public key doesn't exist.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct NoSuchPublicKey {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for NoSuchPublicKey {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("NoSuchPublicKey");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl NoSuchPublicKey {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for NoSuchPublicKey {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "NoSuchPublicKey")?;
        if let Some(inner_18) = &self.message {
            write!(f, ": {}", inner_18)?;
        }
        Ok(())
    }
}
impl std::error::Error for NoSuchPublicKey {}
/// See [`NoSuchPublicKey`](crate::error::NoSuchPublicKey)
pub mod no_such_public_key {
    /// A builder for [`NoSuchPublicKey`](crate::error::NoSuchPublicKey)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`NoSuchPublicKey`](crate::error::NoSuchPublicKey)
        pub fn build(self) -> crate::error::NoSuchPublicKey {
            crate::error::NoSuchPublicKey {
                message: self.message,
            }
        }
    }
}
impl NoSuchPublicKey {
    /// Creates a new builder-style object to manufacture [`NoSuchPublicKey`](crate::error::NoSuchPublicKey)
    pub fn builder() -> crate::error::no_such_public_key::Builder {
        crate::error::no_such_public_key::Builder::default()
    }
}

/// <p>You can't change the value of a public key.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CannotChangeImmutablePublicKeyFields {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for CannotChangeImmutablePublicKeyFields {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CannotChangeImmutablePublicKeyFields");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl CannotChangeImmutablePublicKeyFields {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for CannotChangeImmutablePublicKeyFields {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "CannotChangeImmutablePublicKeyFields")?;
        if let Some(inner_19) = &self.message {
            write!(f, ": {}", inner_19)?;
        }
        Ok(())
    }
}
impl std::error::Error for CannotChangeImmutablePublicKeyFields {}
/// See [`CannotChangeImmutablePublicKeyFields`](crate::error::CannotChangeImmutablePublicKeyFields)
pub mod cannot_change_immutable_public_key_fields {
    /// A builder for [`CannotChangeImmutablePublicKeyFields`](crate::error::CannotChangeImmutablePublicKeyFields)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`CannotChangeImmutablePublicKeyFields`](crate::error::CannotChangeImmutablePublicKeyFields)
        pub fn build(self) -> crate::error::CannotChangeImmutablePublicKeyFields {
            crate::error::CannotChangeImmutablePublicKeyFields {
                message: self.message,
            }
        }
    }
}
impl CannotChangeImmutablePublicKeyFields {
    /// Creates a new builder-style object to manufacture [`CannotChangeImmutablePublicKeyFields`](crate::error::CannotChangeImmutablePublicKeyFields)
    pub fn builder() -> crate::error::cannot_change_immutable_public_key_fields::Builder {
        crate::error::cannot_change_immutable_public_key_fields::Builder::default()
    }
}

/// <p>The number of query strings in the origin request policy exceeds the maximum. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html">Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TooManyQueryStringsInOriginRequestPolicy {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for TooManyQueryStringsInOriginRequestPolicy {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TooManyQueryStringsInOriginRequestPolicy");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl TooManyQueryStringsInOriginRequestPolicy {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for TooManyQueryStringsInOriginRequestPolicy {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "TooManyQueryStringsInOriginRequestPolicy")?;
        if let Some(inner_20) = &self.message {
            write!(f, ": {}", inner_20)?;
        }
        Ok(())
    }
}
impl std::error::Error for TooManyQueryStringsInOriginRequestPolicy {}
/// See [`TooManyQueryStringsInOriginRequestPolicy`](crate::error::TooManyQueryStringsInOriginRequestPolicy)
pub mod too_many_query_strings_in_origin_request_policy {
    /// A builder for [`TooManyQueryStringsInOriginRequestPolicy`](crate::error::TooManyQueryStringsInOriginRequestPolicy)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`TooManyQueryStringsInOriginRequestPolicy`](crate::error::TooManyQueryStringsInOriginRequestPolicy)
        pub fn build(self) -> crate::error::TooManyQueryStringsInOriginRequestPolicy {
            crate::error::TooManyQueryStringsInOriginRequestPolicy {
                message: self.message,
            }
        }
    }
}
impl TooManyQueryStringsInOriginRequestPolicy {
    /// Creates a new builder-style object to manufacture [`TooManyQueryStringsInOriginRequestPolicy`](crate::error::TooManyQueryStringsInOriginRequestPolicy)
    pub fn builder() -> crate::error::too_many_query_strings_in_origin_request_policy::Builder {
        crate::error::too_many_query_strings_in_origin_request_policy::Builder::default()
    }
}

/// <p>The number of headers in the origin request policy exceeds the maximum. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html">Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TooManyHeadersInOriginRequestPolicy {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for TooManyHeadersInOriginRequestPolicy {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TooManyHeadersInOriginRequestPolicy");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl TooManyHeadersInOriginRequestPolicy {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for TooManyHeadersInOriginRequestPolicy {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "TooManyHeadersInOriginRequestPolicy")?;
        if let Some(inner_21) = &self.message {
            write!(f, ": {}", inner_21)?;
        }
        Ok(())
    }
}
impl std::error::Error for TooManyHeadersInOriginRequestPolicy {}
/// See [`TooManyHeadersInOriginRequestPolicy`](crate::error::TooManyHeadersInOriginRequestPolicy)
pub mod too_many_headers_in_origin_request_policy {
    /// A builder for [`TooManyHeadersInOriginRequestPolicy`](crate::error::TooManyHeadersInOriginRequestPolicy)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`TooManyHeadersInOriginRequestPolicy`](crate::error::TooManyHeadersInOriginRequestPolicy)
        pub fn build(self) -> crate::error::TooManyHeadersInOriginRequestPolicy {
            crate::error::TooManyHeadersInOriginRequestPolicy {
                message: self.message,
            }
        }
    }
}
impl TooManyHeadersInOriginRequestPolicy {
    /// Creates a new builder-style object to manufacture [`TooManyHeadersInOriginRequestPolicy`](crate::error::TooManyHeadersInOriginRequestPolicy)
    pub fn builder() -> crate::error::too_many_headers_in_origin_request_policy::Builder {
        crate::error::too_many_headers_in_origin_request_policy::Builder::default()
    }
}

/// <p>The number of cookies in the origin request policy exceeds the maximum. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html">Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TooManyCookiesInOriginRequestPolicy {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for TooManyCookiesInOriginRequestPolicy {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TooManyCookiesInOriginRequestPolicy");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl TooManyCookiesInOriginRequestPolicy {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for TooManyCookiesInOriginRequestPolicy {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "TooManyCookiesInOriginRequestPolicy")?;
        if let Some(inner_22) = &self.message {
            write!(f, ": {}", inner_22)?;
        }
        Ok(())
    }
}
impl std::error::Error for TooManyCookiesInOriginRequestPolicy {}
/// See [`TooManyCookiesInOriginRequestPolicy`](crate::error::TooManyCookiesInOriginRequestPolicy)
pub mod too_many_cookies_in_origin_request_policy {
    /// A builder for [`TooManyCookiesInOriginRequestPolicy`](crate::error::TooManyCookiesInOriginRequestPolicy)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`TooManyCookiesInOriginRequestPolicy`](crate::error::TooManyCookiesInOriginRequestPolicy)
        pub fn build(self) -> crate::error::TooManyCookiesInOriginRequestPolicy {
            crate::error::TooManyCookiesInOriginRequestPolicy {
                message: self.message,
            }
        }
    }
}
impl TooManyCookiesInOriginRequestPolicy {
    /// Creates a new builder-style object to manufacture [`TooManyCookiesInOriginRequestPolicy`](crate::error::TooManyCookiesInOriginRequestPolicy)
    pub fn builder() -> crate::error::too_many_cookies_in_origin_request_policy::Builder {
        crate::error::too_many_cookies_in_origin_request_policy::Builder::default()
    }
}

/// <p>An origin request policy with this name already exists. You must provide a unique name. To modify an existing origin request policy, use <code>UpdateOriginRequestPolicy</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct OriginRequestPolicyAlreadyExists {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for OriginRequestPolicyAlreadyExists {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("OriginRequestPolicyAlreadyExists");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl OriginRequestPolicyAlreadyExists {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for OriginRequestPolicyAlreadyExists {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "OriginRequestPolicyAlreadyExists")?;
        if let Some(inner_23) = &self.message {
            write!(f, ": {}", inner_23)?;
        }
        Ok(())
    }
}
impl std::error::Error for OriginRequestPolicyAlreadyExists {}
/// See [`OriginRequestPolicyAlreadyExists`](crate::error::OriginRequestPolicyAlreadyExists)
pub mod origin_request_policy_already_exists {
    /// A builder for [`OriginRequestPolicyAlreadyExists`](crate::error::OriginRequestPolicyAlreadyExists)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`OriginRequestPolicyAlreadyExists`](crate::error::OriginRequestPolicyAlreadyExists)
        pub fn build(self) -> crate::error::OriginRequestPolicyAlreadyExists {
            crate::error::OriginRequestPolicyAlreadyExists {
                message: self.message,
            }
        }
    }
}
impl OriginRequestPolicyAlreadyExists {
    /// Creates a new builder-style object to manufacture [`OriginRequestPolicyAlreadyExists`](crate::error::OriginRequestPolicyAlreadyExists)
    pub fn builder() -> crate::error::origin_request_policy_already_exists::Builder {
        crate::error::origin_request_policy_already_exists::Builder::default()
    }
}

/// <p>The origin request policy does not exist.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct NoSuchOriginRequestPolicy {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for NoSuchOriginRequestPolicy {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("NoSuchOriginRequestPolicy");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl NoSuchOriginRequestPolicy {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for NoSuchOriginRequestPolicy {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "NoSuchOriginRequestPolicy")?;
        if let Some(inner_24) = &self.message {
            write!(f, ": {}", inner_24)?;
        }
        Ok(())
    }
}
impl std::error::Error for NoSuchOriginRequestPolicy {}
/// See [`NoSuchOriginRequestPolicy`](crate::error::NoSuchOriginRequestPolicy)
pub mod no_such_origin_request_policy {
    /// A builder for [`NoSuchOriginRequestPolicy`](crate::error::NoSuchOriginRequestPolicy)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`NoSuchOriginRequestPolicy`](crate::error::NoSuchOriginRequestPolicy)
        pub fn build(self) -> crate::error::NoSuchOriginRequestPolicy {
            crate::error::NoSuchOriginRequestPolicy {
                message: self.message,
            }
        }
    }
}
impl NoSuchOriginRequestPolicy {
    /// Creates a new builder-style object to manufacture [`NoSuchOriginRequestPolicy`](crate::error::NoSuchOriginRequestPolicy)
    pub fn builder() -> crate::error::no_such_origin_request_policy::Builder {
        crate::error::no_such_origin_request_policy::Builder::default()
    }
}

/// <p>The number of public keys in this key group is more than the maximum allowed. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html">Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TooManyPublicKeysInKeyGroup {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for TooManyPublicKeysInKeyGroup {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TooManyPublicKeysInKeyGroup");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl TooManyPublicKeysInKeyGroup {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for TooManyPublicKeysInKeyGroup {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "TooManyPublicKeysInKeyGroup")?;
        if let Some(inner_25) = &self.message {
            write!(f, ": {}", inner_25)?;
        }
        Ok(())
    }
}
impl std::error::Error for TooManyPublicKeysInKeyGroup {}
/// See [`TooManyPublicKeysInKeyGroup`](crate::error::TooManyPublicKeysInKeyGroup)
pub mod too_many_public_keys_in_key_group {
    /// A builder for [`TooManyPublicKeysInKeyGroup`](crate::error::TooManyPublicKeysInKeyGroup)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`TooManyPublicKeysInKeyGroup`](crate::error::TooManyPublicKeysInKeyGroup)
        pub fn build(self) -> crate::error::TooManyPublicKeysInKeyGroup {
            crate::error::TooManyPublicKeysInKeyGroup {
                message: self.message,
            }
        }
    }
}
impl TooManyPublicKeysInKeyGroup {
    /// Creates a new builder-style object to manufacture [`TooManyPublicKeysInKeyGroup`](crate::error::TooManyPublicKeysInKeyGroup)
    pub fn builder() -> crate::error::too_many_public_keys_in_key_group::Builder {
        crate::error::too_many_public_keys_in_key_group::Builder::default()
    }
}

/// <p>A resource that was specified is not valid.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct NoSuchResource {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for NoSuchResource {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("NoSuchResource");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl NoSuchResource {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for NoSuchResource {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "NoSuchResource")?;
        if let Some(inner_26) = &self.message {
            write!(f, ": {}", inner_26)?;
        }
        Ok(())
    }
}
impl std::error::Error for NoSuchResource {}
/// See [`NoSuchResource`](crate::error::NoSuchResource)
pub mod no_such_resource {
    /// A builder for [`NoSuchResource`](crate::error::NoSuchResource)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`NoSuchResource`](crate::error::NoSuchResource)
        pub fn build(self) -> crate::error::NoSuchResource {
            crate::error::NoSuchResource {
                message: self.message,
            }
        }
    }
}
impl NoSuchResource {
    /// Creates a new builder-style object to manufacture [`NoSuchResource`](crate::error::NoSuchResource)
    pub fn builder() -> crate::error::no_such_resource::Builder {
        crate::error::no_such_resource::Builder::default()
    }
}

/// <p>A key group with this name already exists. You must provide a unique name. To modify an existing key group, use <code>UpdateKeyGroup</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct KeyGroupAlreadyExists {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for KeyGroupAlreadyExists {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("KeyGroupAlreadyExists");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl KeyGroupAlreadyExists {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for KeyGroupAlreadyExists {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "KeyGroupAlreadyExists")?;
        if let Some(inner_27) = &self.message {
            write!(f, ": {}", inner_27)?;
        }
        Ok(())
    }
}
impl std::error::Error for KeyGroupAlreadyExists {}
/// See [`KeyGroupAlreadyExists`](crate::error::KeyGroupAlreadyExists)
pub mod key_group_already_exists {
    /// A builder for [`KeyGroupAlreadyExists`](crate::error::KeyGroupAlreadyExists)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`KeyGroupAlreadyExists`](crate::error::KeyGroupAlreadyExists)
        pub fn build(self) -> crate::error::KeyGroupAlreadyExists {
            crate::error::KeyGroupAlreadyExists {
                message: self.message,
            }
        }
    }
}
impl KeyGroupAlreadyExists {
    /// Creates a new builder-style object to manufacture [`KeyGroupAlreadyExists`](crate::error::KeyGroupAlreadyExists)
    pub fn builder() -> crate::error::key_group_already_exists::Builder {
        crate::error::key_group_already_exists::Builder::default()
    }
}

/// <p>This operation is not supported in this region.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UnsupportedOperation {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for UnsupportedOperation {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UnsupportedOperation");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl UnsupportedOperation {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for UnsupportedOperation {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "UnsupportedOperation")?;
        if let Some(inner_28) = &self.message {
            write!(f, ": {}", inner_28)?;
        }
        Ok(())
    }
}
impl std::error::Error for UnsupportedOperation {}
/// See [`UnsupportedOperation`](crate::error::UnsupportedOperation)
pub mod unsupported_operation {
    /// A builder for [`UnsupportedOperation`](crate::error::UnsupportedOperation)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`UnsupportedOperation`](crate::error::UnsupportedOperation)
        pub fn build(self) -> crate::error::UnsupportedOperation {
            crate::error::UnsupportedOperation {
                message: self.message,
            }
        }
    }
}
impl UnsupportedOperation {
    /// Creates a new builder-style object to manufacture [`UnsupportedOperation`](crate::error::UnsupportedOperation)
    pub fn builder() -> crate::error::unsupported_operation::Builder {
        crate::error::unsupported_operation::Builder::default()
    }
}

/// <p>The function does not exist.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct NoSuchFunctionExists {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for NoSuchFunctionExists {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("NoSuchFunctionExists");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl NoSuchFunctionExists {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for NoSuchFunctionExists {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "NoSuchFunctionExists")?;
        if let Some(inner_29) = &self.message {
            write!(f, ": {}", inner_29)?;
        }
        Ok(())
    }
}
impl std::error::Error for NoSuchFunctionExists {}
/// See [`NoSuchFunctionExists`](crate::error::NoSuchFunctionExists)
pub mod no_such_function_exists {
    /// A builder for [`NoSuchFunctionExists`](crate::error::NoSuchFunctionExists)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`NoSuchFunctionExists`](crate::error::NoSuchFunctionExists)
        pub fn build(self) -> crate::error::NoSuchFunctionExists {
            crate::error::NoSuchFunctionExists {
                message: self.message,
            }
        }
    }
}
impl NoSuchFunctionExists {
    /// Creates a new builder-style object to manufacture [`NoSuchFunctionExists`](crate::error::NoSuchFunctionExists)
    pub fn builder() -> crate::error::no_such_function_exists::Builder {
        crate::error::no_such_function_exists::Builder::default()
    }
}

/// <p>The function is too large. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html">Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct FunctionSizeLimitExceeded {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for FunctionSizeLimitExceeded {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("FunctionSizeLimitExceeded");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl FunctionSizeLimitExceeded {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for FunctionSizeLimitExceeded {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "FunctionSizeLimitExceeded")?;
        if let Some(inner_30) = &self.message {
            write!(f, ": {}", inner_30)?;
        }
        Ok(())
    }
}
impl std::error::Error for FunctionSizeLimitExceeded {}
/// See [`FunctionSizeLimitExceeded`](crate::error::FunctionSizeLimitExceeded)
pub mod function_size_limit_exceeded {
    /// A builder for [`FunctionSizeLimitExceeded`](crate::error::FunctionSizeLimitExceeded)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`FunctionSizeLimitExceeded`](crate::error::FunctionSizeLimitExceeded)
        pub fn build(self) -> crate::error::FunctionSizeLimitExceeded {
            crate::error::FunctionSizeLimitExceeded {
                message: self.message,
            }
        }
    }
}
impl FunctionSizeLimitExceeded {
    /// Creates a new builder-style object to manufacture [`FunctionSizeLimitExceeded`](crate::error::FunctionSizeLimitExceeded)
    pub fn builder() -> crate::error::function_size_limit_exceeded::Builder {
        crate::error::function_size_limit_exceeded::Builder::default()
    }
}

/// <p>The maximum number of field patterns for field-level encryption have been created.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TooManyFieldLevelEncryptionFieldPatterns {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for TooManyFieldLevelEncryptionFieldPatterns {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TooManyFieldLevelEncryptionFieldPatterns");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl TooManyFieldLevelEncryptionFieldPatterns {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for TooManyFieldLevelEncryptionFieldPatterns {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "TooManyFieldLevelEncryptionFieldPatterns")?;
        if let Some(inner_31) = &self.message {
            write!(f, ": {}", inner_31)?;
        }
        Ok(())
    }
}
impl std::error::Error for TooManyFieldLevelEncryptionFieldPatterns {}
/// See [`TooManyFieldLevelEncryptionFieldPatterns`](crate::error::TooManyFieldLevelEncryptionFieldPatterns)
pub mod too_many_field_level_encryption_field_patterns {
    /// A builder for [`TooManyFieldLevelEncryptionFieldPatterns`](crate::error::TooManyFieldLevelEncryptionFieldPatterns)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`TooManyFieldLevelEncryptionFieldPatterns`](crate::error::TooManyFieldLevelEncryptionFieldPatterns)
        pub fn build(self) -> crate::error::TooManyFieldLevelEncryptionFieldPatterns {
            crate::error::TooManyFieldLevelEncryptionFieldPatterns {
                message: self.message,
            }
        }
    }
}
impl TooManyFieldLevelEncryptionFieldPatterns {
    /// Creates a new builder-style object to manufacture [`TooManyFieldLevelEncryptionFieldPatterns`](crate::error::TooManyFieldLevelEncryptionFieldPatterns)
    pub fn builder() -> crate::error::too_many_field_level_encryption_field_patterns::Builder {
        crate::error::too_many_field_level_encryption_field_patterns::Builder::default()
    }
}

/// <p>The maximum number of encryption entities for field-level encryption have been created.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TooManyFieldLevelEncryptionEncryptionEntities {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for TooManyFieldLevelEncryptionEncryptionEntities {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TooManyFieldLevelEncryptionEncryptionEntities");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl TooManyFieldLevelEncryptionEncryptionEntities {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for TooManyFieldLevelEncryptionEncryptionEntities {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "TooManyFieldLevelEncryptionEncryptionEntities")?;
        if let Some(inner_32) = &self.message {
            write!(f, ": {}", inner_32)?;
        }
        Ok(())
    }
}
impl std::error::Error for TooManyFieldLevelEncryptionEncryptionEntities {}
/// See [`TooManyFieldLevelEncryptionEncryptionEntities`](crate::error::TooManyFieldLevelEncryptionEncryptionEntities)
pub mod too_many_field_level_encryption_encryption_entities {
    /// A builder for [`TooManyFieldLevelEncryptionEncryptionEntities`](crate::error::TooManyFieldLevelEncryptionEncryptionEntities)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`TooManyFieldLevelEncryptionEncryptionEntities`](crate::error::TooManyFieldLevelEncryptionEncryptionEntities)
        pub fn build(self) -> crate::error::TooManyFieldLevelEncryptionEncryptionEntities {
            crate::error::TooManyFieldLevelEncryptionEncryptionEntities {
                message: self.message,
            }
        }
    }
}
impl TooManyFieldLevelEncryptionEncryptionEntities {
    /// Creates a new builder-style object to manufacture [`TooManyFieldLevelEncryptionEncryptionEntities`](crate::error::TooManyFieldLevelEncryptionEncryptionEntities)
    pub fn builder() -> crate::error::too_many_field_level_encryption_encryption_entities::Builder {
        crate::error::too_many_field_level_encryption_encryption_entities::Builder::default()
    }
}

/// <p>The specified profile for field-level encryption doesn't exist.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct NoSuchFieldLevelEncryptionProfile {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for NoSuchFieldLevelEncryptionProfile {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("NoSuchFieldLevelEncryptionProfile");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl NoSuchFieldLevelEncryptionProfile {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for NoSuchFieldLevelEncryptionProfile {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "NoSuchFieldLevelEncryptionProfile")?;
        if let Some(inner_33) = &self.message {
            write!(f, ": {}", inner_33)?;
        }
        Ok(())
    }
}
impl std::error::Error for NoSuchFieldLevelEncryptionProfile {}
/// See [`NoSuchFieldLevelEncryptionProfile`](crate::error::NoSuchFieldLevelEncryptionProfile)
pub mod no_such_field_level_encryption_profile {
    /// A builder for [`NoSuchFieldLevelEncryptionProfile`](crate::error::NoSuchFieldLevelEncryptionProfile)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`NoSuchFieldLevelEncryptionProfile`](crate::error::NoSuchFieldLevelEncryptionProfile)
        pub fn build(self) -> crate::error::NoSuchFieldLevelEncryptionProfile {
            crate::error::NoSuchFieldLevelEncryptionProfile {
                message: self.message,
            }
        }
    }
}
impl NoSuchFieldLevelEncryptionProfile {
    /// Creates a new builder-style object to manufacture [`NoSuchFieldLevelEncryptionProfile`](crate::error::NoSuchFieldLevelEncryptionProfile)
    pub fn builder() -> crate::error::no_such_field_level_encryption_profile::Builder {
        crate::error::no_such_field_level_encryption_profile::Builder::default()
    }
}

/// <p>The maximum size of a profile for field-level encryption was exceeded.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct FieldLevelEncryptionProfileSizeExceeded {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for FieldLevelEncryptionProfileSizeExceeded {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("FieldLevelEncryptionProfileSizeExceeded");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl FieldLevelEncryptionProfileSizeExceeded {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for FieldLevelEncryptionProfileSizeExceeded {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "FieldLevelEncryptionProfileSizeExceeded")?;
        if let Some(inner_34) = &self.message {
            write!(f, ": {}", inner_34)?;
        }
        Ok(())
    }
}
impl std::error::Error for FieldLevelEncryptionProfileSizeExceeded {}
/// See [`FieldLevelEncryptionProfileSizeExceeded`](crate::error::FieldLevelEncryptionProfileSizeExceeded)
pub mod field_level_encryption_profile_size_exceeded {
    /// A builder for [`FieldLevelEncryptionProfileSizeExceeded`](crate::error::FieldLevelEncryptionProfileSizeExceeded)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`FieldLevelEncryptionProfileSizeExceeded`](crate::error::FieldLevelEncryptionProfileSizeExceeded)
        pub fn build(self) -> crate::error::FieldLevelEncryptionProfileSizeExceeded {
            crate::error::FieldLevelEncryptionProfileSizeExceeded {
                message: self.message,
            }
        }
    }
}
impl FieldLevelEncryptionProfileSizeExceeded {
    /// Creates a new builder-style object to manufacture [`FieldLevelEncryptionProfileSizeExceeded`](crate::error::FieldLevelEncryptionProfileSizeExceeded)
    pub fn builder() -> crate::error::field_level_encryption_profile_size_exceeded::Builder {
        crate::error::field_level_encryption_profile_size_exceeded::Builder::default()
    }
}

/// <p>The specified profile for field-level encryption already exists.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct FieldLevelEncryptionProfileAlreadyExists {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for FieldLevelEncryptionProfileAlreadyExists {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("FieldLevelEncryptionProfileAlreadyExists");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl FieldLevelEncryptionProfileAlreadyExists {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for FieldLevelEncryptionProfileAlreadyExists {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "FieldLevelEncryptionProfileAlreadyExists")?;
        if let Some(inner_35) = &self.message {
            write!(f, ": {}", inner_35)?;
        }
        Ok(())
    }
}
impl std::error::Error for FieldLevelEncryptionProfileAlreadyExists {}
/// See [`FieldLevelEncryptionProfileAlreadyExists`](crate::error::FieldLevelEncryptionProfileAlreadyExists)
pub mod field_level_encryption_profile_already_exists {
    /// A builder for [`FieldLevelEncryptionProfileAlreadyExists`](crate::error::FieldLevelEncryptionProfileAlreadyExists)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`FieldLevelEncryptionProfileAlreadyExists`](crate::error::FieldLevelEncryptionProfileAlreadyExists)
        pub fn build(self) -> crate::error::FieldLevelEncryptionProfileAlreadyExists {
            crate::error::FieldLevelEncryptionProfileAlreadyExists {
                message: self.message,
            }
        }
    }
}
impl FieldLevelEncryptionProfileAlreadyExists {
    /// Creates a new builder-style object to manufacture [`FieldLevelEncryptionProfileAlreadyExists`](crate::error::FieldLevelEncryptionProfileAlreadyExists)
    pub fn builder() -> crate::error::field_level_encryption_profile_already_exists::Builder {
        crate::error::field_level_encryption_profile_already_exists::Builder::default()
    }
}

/// <p>The maximum number of query arg profiles for field-level encryption have been created.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TooManyFieldLevelEncryptionQueryArgProfiles {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for TooManyFieldLevelEncryptionQueryArgProfiles {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TooManyFieldLevelEncryptionQueryArgProfiles");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl TooManyFieldLevelEncryptionQueryArgProfiles {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for TooManyFieldLevelEncryptionQueryArgProfiles {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "TooManyFieldLevelEncryptionQueryArgProfiles")?;
        if let Some(inner_36) = &self.message {
            write!(f, ": {}", inner_36)?;
        }
        Ok(())
    }
}
impl std::error::Error for TooManyFieldLevelEncryptionQueryArgProfiles {}
/// See [`TooManyFieldLevelEncryptionQueryArgProfiles`](crate::error::TooManyFieldLevelEncryptionQueryArgProfiles)
pub mod too_many_field_level_encryption_query_arg_profiles {
    /// A builder for [`TooManyFieldLevelEncryptionQueryArgProfiles`](crate::error::TooManyFieldLevelEncryptionQueryArgProfiles)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`TooManyFieldLevelEncryptionQueryArgProfiles`](crate::error::TooManyFieldLevelEncryptionQueryArgProfiles)
        pub fn build(self) -> crate::error::TooManyFieldLevelEncryptionQueryArgProfiles {
            crate::error::TooManyFieldLevelEncryptionQueryArgProfiles {
                message: self.message,
            }
        }
    }
}
impl TooManyFieldLevelEncryptionQueryArgProfiles {
    /// Creates a new builder-style object to manufacture [`TooManyFieldLevelEncryptionQueryArgProfiles`](crate::error::TooManyFieldLevelEncryptionQueryArgProfiles)
    pub fn builder() -> crate::error::too_many_field_level_encryption_query_arg_profiles::Builder {
        crate::error::too_many_field_level_encryption_query_arg_profiles::Builder::default()
    }
}

/// <p>The maximum number of content type profiles for field-level encryption have been created.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TooManyFieldLevelEncryptionContentTypeProfiles {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for TooManyFieldLevelEncryptionContentTypeProfiles {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TooManyFieldLevelEncryptionContentTypeProfiles");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl TooManyFieldLevelEncryptionContentTypeProfiles {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for TooManyFieldLevelEncryptionContentTypeProfiles {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "TooManyFieldLevelEncryptionContentTypeProfiles")?;
        if let Some(inner_37) = &self.message {
            write!(f, ": {}", inner_37)?;
        }
        Ok(())
    }
}
impl std::error::Error for TooManyFieldLevelEncryptionContentTypeProfiles {}
/// See [`TooManyFieldLevelEncryptionContentTypeProfiles`](crate::error::TooManyFieldLevelEncryptionContentTypeProfiles)
pub mod too_many_field_level_encryption_content_type_profiles {
    /// A builder for [`TooManyFieldLevelEncryptionContentTypeProfiles`](crate::error::TooManyFieldLevelEncryptionContentTypeProfiles)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`TooManyFieldLevelEncryptionContentTypeProfiles`](crate::error::TooManyFieldLevelEncryptionContentTypeProfiles)
        pub fn build(self) -> crate::error::TooManyFieldLevelEncryptionContentTypeProfiles {
            crate::error::TooManyFieldLevelEncryptionContentTypeProfiles {
                message: self.message,
            }
        }
    }
}
impl TooManyFieldLevelEncryptionContentTypeProfiles {
    /// Creates a new builder-style object to manufacture [`TooManyFieldLevelEncryptionContentTypeProfiles`](crate::error::TooManyFieldLevelEncryptionContentTypeProfiles)
    pub fn builder() -> crate::error::too_many_field_level_encryption_content_type_profiles::Builder
    {
        crate::error::too_many_field_level_encryption_content_type_profiles::Builder::default()
    }
}

/// <p>No profile specified for the field-level encryption query argument.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct QueryArgProfileEmpty {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for QueryArgProfileEmpty {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("QueryArgProfileEmpty");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl QueryArgProfileEmpty {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for QueryArgProfileEmpty {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "QueryArgProfileEmpty")?;
        if let Some(inner_38) = &self.message {
            write!(f, ": {}", inner_38)?;
        }
        Ok(())
    }
}
impl std::error::Error for QueryArgProfileEmpty {}
/// See [`QueryArgProfileEmpty`](crate::error::QueryArgProfileEmpty)
pub mod query_arg_profile_empty {
    /// A builder for [`QueryArgProfileEmpty`](crate::error::QueryArgProfileEmpty)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`QueryArgProfileEmpty`](crate::error::QueryArgProfileEmpty)
        pub fn build(self) -> crate::error::QueryArgProfileEmpty {
            crate::error::QueryArgProfileEmpty {
                message: self.message,
            }
        }
    }
}
impl QueryArgProfileEmpty {
    /// Creates a new builder-style object to manufacture [`QueryArgProfileEmpty`](crate::error::QueryArgProfileEmpty)
    pub fn builder() -> crate::error::query_arg_profile_empty::Builder {
        crate::error::query_arg_profile_empty::Builder::default()
    }
}

/// <p>The specified configuration for field-level encryption doesn't exist.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct NoSuchFieldLevelEncryptionConfig {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for NoSuchFieldLevelEncryptionConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("NoSuchFieldLevelEncryptionConfig");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl NoSuchFieldLevelEncryptionConfig {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for NoSuchFieldLevelEncryptionConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "NoSuchFieldLevelEncryptionConfig")?;
        if let Some(inner_39) = &self.message {
            write!(f, ": {}", inner_39)?;
        }
        Ok(())
    }
}
impl std::error::Error for NoSuchFieldLevelEncryptionConfig {}
/// See [`NoSuchFieldLevelEncryptionConfig`](crate::error::NoSuchFieldLevelEncryptionConfig)
pub mod no_such_field_level_encryption_config {
    /// A builder for [`NoSuchFieldLevelEncryptionConfig`](crate::error::NoSuchFieldLevelEncryptionConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`NoSuchFieldLevelEncryptionConfig`](crate::error::NoSuchFieldLevelEncryptionConfig)
        pub fn build(self) -> crate::error::NoSuchFieldLevelEncryptionConfig {
            crate::error::NoSuchFieldLevelEncryptionConfig {
                message: self.message,
            }
        }
    }
}
impl NoSuchFieldLevelEncryptionConfig {
    /// Creates a new builder-style object to manufacture [`NoSuchFieldLevelEncryptionConfig`](crate::error::NoSuchFieldLevelEncryptionConfig)
    pub fn builder() -> crate::error::no_such_field_level_encryption_config::Builder {
        crate::error::no_such_field_level_encryption_config::Builder::default()
    }
}

/// <p>The specified key group does not exist.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TrustedKeyGroupDoesNotExist {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for TrustedKeyGroupDoesNotExist {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TrustedKeyGroupDoesNotExist");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl TrustedKeyGroupDoesNotExist {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for TrustedKeyGroupDoesNotExist {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "TrustedKeyGroupDoesNotExist")?;
        if let Some(inner_40) = &self.message {
            write!(f, ": {}", inner_40)?;
        }
        Ok(())
    }
}
impl std::error::Error for TrustedKeyGroupDoesNotExist {}
/// See [`TrustedKeyGroupDoesNotExist`](crate::error::TrustedKeyGroupDoesNotExist)
pub mod trusted_key_group_does_not_exist {
    /// A builder for [`TrustedKeyGroupDoesNotExist`](crate::error::TrustedKeyGroupDoesNotExist)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`TrustedKeyGroupDoesNotExist`](crate::error::TrustedKeyGroupDoesNotExist)
        pub fn build(self) -> crate::error::TrustedKeyGroupDoesNotExist {
            crate::error::TrustedKeyGroupDoesNotExist {
                message: self.message,
            }
        }
    }
}
impl TrustedKeyGroupDoesNotExist {
    /// Creates a new builder-style object to manufacture [`TrustedKeyGroupDoesNotExist`](crate::error::TrustedKeyGroupDoesNotExist)
    pub fn builder() -> crate::error::trusted_key_group_does_not_exist::Builder {
        crate::error::trusted_key_group_does_not_exist::Builder::default()
    }
}

/// <p>Your request contains too many query string parameters.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TooManyQueryStringParameters {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for TooManyQueryStringParameters {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TooManyQueryStringParameters");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl TooManyQueryStringParameters {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for TooManyQueryStringParameters {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "TooManyQueryStringParameters")?;
        if let Some(inner_41) = &self.message {
            write!(f, ": {}", inner_41)?;
        }
        Ok(())
    }
}
impl std::error::Error for TooManyQueryStringParameters {}
/// See [`TooManyQueryStringParameters`](crate::error::TooManyQueryStringParameters)
pub mod too_many_query_string_parameters {
    /// A builder for [`TooManyQueryStringParameters`](crate::error::TooManyQueryStringParameters)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`TooManyQueryStringParameters`](crate::error::TooManyQueryStringParameters)
        pub fn build(self) -> crate::error::TooManyQueryStringParameters {
            crate::error::TooManyQueryStringParameters {
                message: self.message,
            }
        }
    }
}
impl TooManyQueryStringParameters {
    /// Creates a new builder-style object to manufacture [`TooManyQueryStringParameters`](crate::error::TooManyQueryStringParameters)
    pub fn builder() -> crate::error::too_many_query_string_parameters::Builder {
        crate::error::too_many_query_string_parameters::Builder::default()
    }
}

/// <p>You cannot create more origins for the distribution.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TooManyOrigins {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for TooManyOrigins {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TooManyOrigins");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl TooManyOrigins {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for TooManyOrigins {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "TooManyOrigins")?;
        if let Some(inner_42) = &self.message {
            write!(f, ": {}", inner_42)?;
        }
        Ok(())
    }
}
impl std::error::Error for TooManyOrigins {}
/// See [`TooManyOrigins`](crate::error::TooManyOrigins)
pub mod too_many_origins {
    /// A builder for [`TooManyOrigins`](crate::error::TooManyOrigins)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`TooManyOrigins`](crate::error::TooManyOrigins)
        pub fn build(self) -> crate::error::TooManyOrigins {
            crate::error::TooManyOrigins {
                message: self.message,
            }
        }
    }
}
impl TooManyOrigins {
    /// Creates a new builder-style object to manufacture [`TooManyOrigins`](crate::error::TooManyOrigins)
    pub fn builder() -> crate::error::too_many_origins::Builder {
        crate::error::too_many_origins::Builder::default()
    }
}

/// <p>Processing your request would cause you to exceed the maximum number of origin groups allowed.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TooManyOriginGroupsPerDistribution {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for TooManyOriginGroupsPerDistribution {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TooManyOriginGroupsPerDistribution");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl TooManyOriginGroupsPerDistribution {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for TooManyOriginGroupsPerDistribution {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "TooManyOriginGroupsPerDistribution")?;
        if let Some(inner_43) = &self.message {
            write!(f, ": {}", inner_43)?;
        }
        Ok(())
    }
}
impl std::error::Error for TooManyOriginGroupsPerDistribution {}
/// See [`TooManyOriginGroupsPerDistribution`](crate::error::TooManyOriginGroupsPerDistribution)
pub mod too_many_origin_groups_per_distribution {
    /// A builder for [`TooManyOriginGroupsPerDistribution`](crate::error::TooManyOriginGroupsPerDistribution)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`TooManyOriginGroupsPerDistribution`](crate::error::TooManyOriginGroupsPerDistribution)
        pub fn build(self) -> crate::error::TooManyOriginGroupsPerDistribution {
            crate::error::TooManyOriginGroupsPerDistribution {
                message: self.message,
            }
        }
    }
}
impl TooManyOriginGroupsPerDistribution {
    /// Creates a new builder-style object to manufacture [`TooManyOriginGroupsPerDistribution`](crate::error::TooManyOriginGroupsPerDistribution)
    pub fn builder() -> crate::error::too_many_origin_groups_per_distribution::Builder {
        crate::error::too_many_origin_groups_per_distribution::Builder::default()
    }
}

/// <p>Your request contains too many origin custom headers.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TooManyOriginCustomHeaders {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for TooManyOriginCustomHeaders {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TooManyOriginCustomHeaders");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl TooManyOriginCustomHeaders {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for TooManyOriginCustomHeaders {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "TooManyOriginCustomHeaders")?;
        if let Some(inner_44) = &self.message {
            write!(f, ": {}", inner_44)?;
        }
        Ok(())
    }
}
impl std::error::Error for TooManyOriginCustomHeaders {}
/// See [`TooManyOriginCustomHeaders`](crate::error::TooManyOriginCustomHeaders)
pub mod too_many_origin_custom_headers {
    /// A builder for [`TooManyOriginCustomHeaders`](crate::error::TooManyOriginCustomHeaders)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`TooManyOriginCustomHeaders`](crate::error::TooManyOriginCustomHeaders)
        pub fn build(self) -> crate::error::TooManyOriginCustomHeaders {
            crate::error::TooManyOriginCustomHeaders {
                message: self.message,
            }
        }
    }
}
impl TooManyOriginCustomHeaders {
    /// Creates a new builder-style object to manufacture [`TooManyOriginCustomHeaders`](crate::error::TooManyOriginCustomHeaders)
    pub fn builder() -> crate::error::too_many_origin_custom_headers::Builder {
        crate::error::too_many_origin_custom_headers::Builder::default()
    }
}

/// <p>Your request contains more Lambda@Edge function associations than are allowed per distribution.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TooManyLambdaFunctionAssociations {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for TooManyLambdaFunctionAssociations {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TooManyLambdaFunctionAssociations");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl TooManyLambdaFunctionAssociations {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for TooManyLambdaFunctionAssociations {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "TooManyLambdaFunctionAssociations")?;
        if let Some(inner_45) = &self.message {
            write!(f, ": {}", inner_45)?;
        }
        Ok(())
    }
}
impl std::error::Error for TooManyLambdaFunctionAssociations {}
/// See [`TooManyLambdaFunctionAssociations`](crate::error::TooManyLambdaFunctionAssociations)
pub mod too_many_lambda_function_associations {
    /// A builder for [`TooManyLambdaFunctionAssociations`](crate::error::TooManyLambdaFunctionAssociations)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`TooManyLambdaFunctionAssociations`](crate::error::TooManyLambdaFunctionAssociations)
        pub fn build(self) -> crate::error::TooManyLambdaFunctionAssociations {
            crate::error::TooManyLambdaFunctionAssociations {
                message: self.message,
            }
        }
    }
}
impl TooManyLambdaFunctionAssociations {
    /// Creates a new builder-style object to manufacture [`TooManyLambdaFunctionAssociations`](crate::error::TooManyLambdaFunctionAssociations)
    pub fn builder() -> crate::error::too_many_lambda_function_associations::Builder {
        crate::error::too_many_lambda_function_associations::Builder::default()
    }
}

/// <p>The number of key groups referenced by this distribution is more than the maximum allowed. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html">Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TooManyKeyGroupsAssociatedToDistribution {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for TooManyKeyGroupsAssociatedToDistribution {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TooManyKeyGroupsAssociatedToDistribution");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl TooManyKeyGroupsAssociatedToDistribution {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for TooManyKeyGroupsAssociatedToDistribution {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "TooManyKeyGroupsAssociatedToDistribution")?;
        if let Some(inner_46) = &self.message {
            write!(f, ": {}", inner_46)?;
        }
        Ok(())
    }
}
impl std::error::Error for TooManyKeyGroupsAssociatedToDistribution {}
/// See [`TooManyKeyGroupsAssociatedToDistribution`](crate::error::TooManyKeyGroupsAssociatedToDistribution)
pub mod too_many_key_groups_associated_to_distribution {
    /// A builder for [`TooManyKeyGroupsAssociatedToDistribution`](crate::error::TooManyKeyGroupsAssociatedToDistribution)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`TooManyKeyGroupsAssociatedToDistribution`](crate::error::TooManyKeyGroupsAssociatedToDistribution)
        pub fn build(self) -> crate::error::TooManyKeyGroupsAssociatedToDistribution {
            crate::error::TooManyKeyGroupsAssociatedToDistribution {
                message: self.message,
            }
        }
    }
}
impl TooManyKeyGroupsAssociatedToDistribution {
    /// Creates a new builder-style object to manufacture [`TooManyKeyGroupsAssociatedToDistribution`](crate::error::TooManyKeyGroupsAssociatedToDistribution)
    pub fn builder() -> crate::error::too_many_key_groups_associated_to_distribution::Builder {
        crate::error::too_many_key_groups_associated_to_distribution::Builder::default()
    }
}

/// <p>Your request contains too many headers in forwarded values.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TooManyHeadersInForwardedValues {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for TooManyHeadersInForwardedValues {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TooManyHeadersInForwardedValues");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl TooManyHeadersInForwardedValues {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for TooManyHeadersInForwardedValues {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "TooManyHeadersInForwardedValues")?;
        if let Some(inner_47) = &self.message {
            write!(f, ": {}", inner_47)?;
        }
        Ok(())
    }
}
impl std::error::Error for TooManyHeadersInForwardedValues {}
/// See [`TooManyHeadersInForwardedValues`](crate::error::TooManyHeadersInForwardedValues)
pub mod too_many_headers_in_forwarded_values {
    /// A builder for [`TooManyHeadersInForwardedValues`](crate::error::TooManyHeadersInForwardedValues)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`TooManyHeadersInForwardedValues`](crate::error::TooManyHeadersInForwardedValues)
        pub fn build(self) -> crate::error::TooManyHeadersInForwardedValues {
            crate::error::TooManyHeadersInForwardedValues {
                message: self.message,
            }
        }
    }
}
impl TooManyHeadersInForwardedValues {
    /// Creates a new builder-style object to manufacture [`TooManyHeadersInForwardedValues`](crate::error::TooManyHeadersInForwardedValues)
    pub fn builder() -> crate::error::too_many_headers_in_forwarded_values::Builder {
        crate::error::too_many_headers_in_forwarded_values::Builder::default()
    }
}

/// <p>You have reached the maximum number of CloudFront function associations for this distribution. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html">Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TooManyFunctionAssociations {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for TooManyFunctionAssociations {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TooManyFunctionAssociations");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl TooManyFunctionAssociations {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for TooManyFunctionAssociations {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "TooManyFunctionAssociations")?;
        if let Some(inner_48) = &self.message {
            write!(f, ": {}", inner_48)?;
        }
        Ok(())
    }
}
impl std::error::Error for TooManyFunctionAssociations {}
/// See [`TooManyFunctionAssociations`](crate::error::TooManyFunctionAssociations)
pub mod too_many_function_associations {
    /// A builder for [`TooManyFunctionAssociations`](crate::error::TooManyFunctionAssociations)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`TooManyFunctionAssociations`](crate::error::TooManyFunctionAssociations)
        pub fn build(self) -> crate::error::TooManyFunctionAssociations {
            crate::error::TooManyFunctionAssociations {
                message: self.message,
            }
        }
    }
}
impl TooManyFunctionAssociations {
    /// Creates a new builder-style object to manufacture [`TooManyFunctionAssociations`](crate::error::TooManyFunctionAssociations)
    pub fn builder() -> crate::error::too_many_function_associations::Builder {
        crate::error::too_many_function_associations::Builder::default()
    }
}

/// <p>The maximum number of distributions have been associated with the specified Lambda@Edge function.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TooManyDistributionsWithSingleFunctionArn {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for TooManyDistributionsWithSingleFunctionArn {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TooManyDistributionsWithSingleFunctionArn");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl TooManyDistributionsWithSingleFunctionArn {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for TooManyDistributionsWithSingleFunctionArn {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(
            f,
            "TooManyDistributionsWithSingleFunctionArn [TooManyDistributionsWithSingleFunctionARN]"
        )?;
        if let Some(inner_49) = &self.message {
            write!(f, ": {}", inner_49)?;
        }
        Ok(())
    }
}
impl std::error::Error for TooManyDistributionsWithSingleFunctionArn {}
/// See [`TooManyDistributionsWithSingleFunctionArn`](crate::error::TooManyDistributionsWithSingleFunctionArn)
pub mod too_many_distributions_with_single_function_arn {
    /// A builder for [`TooManyDistributionsWithSingleFunctionArn`](crate::error::TooManyDistributionsWithSingleFunctionArn)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`TooManyDistributionsWithSingleFunctionArn`](crate::error::TooManyDistributionsWithSingleFunctionArn)
        pub fn build(self) -> crate::error::TooManyDistributionsWithSingleFunctionArn {
            crate::error::TooManyDistributionsWithSingleFunctionArn {
                message: self.message,
            }
        }
    }
}
impl TooManyDistributionsWithSingleFunctionArn {
    /// Creates a new builder-style object to manufacture [`TooManyDistributionsWithSingleFunctionArn`](crate::error::TooManyDistributionsWithSingleFunctionArn)
    pub fn builder() -> crate::error::too_many_distributions_with_single_function_arn::Builder {
        crate::error::too_many_distributions_with_single_function_arn::Builder::default()
    }
}

/// <p>Processing your request would cause the maximum number of distributions with Lambda@Edge function associations per owner to be exceeded.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TooManyDistributionsWithLambdaAssociations {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for TooManyDistributionsWithLambdaAssociations {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TooManyDistributionsWithLambdaAssociations");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl TooManyDistributionsWithLambdaAssociations {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for TooManyDistributionsWithLambdaAssociations {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "TooManyDistributionsWithLambdaAssociations")?;
        if let Some(inner_50) = &self.message {
            write!(f, ": {}", inner_50)?;
        }
        Ok(())
    }
}
impl std::error::Error for TooManyDistributionsWithLambdaAssociations {}
/// See [`TooManyDistributionsWithLambdaAssociations`](crate::error::TooManyDistributionsWithLambdaAssociations)
pub mod too_many_distributions_with_lambda_associations {
    /// A builder for [`TooManyDistributionsWithLambdaAssociations`](crate::error::TooManyDistributionsWithLambdaAssociations)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`TooManyDistributionsWithLambdaAssociations`](crate::error::TooManyDistributionsWithLambdaAssociations)
        pub fn build(self) -> crate::error::TooManyDistributionsWithLambdaAssociations {
            crate::error::TooManyDistributionsWithLambdaAssociations {
                message: self.message,
            }
        }
    }
}
impl TooManyDistributionsWithLambdaAssociations {
    /// Creates a new builder-style object to manufacture [`TooManyDistributionsWithLambdaAssociations`](crate::error::TooManyDistributionsWithLambdaAssociations)
    pub fn builder() -> crate::error::too_many_distributions_with_lambda_associations::Builder {
        crate::error::too_many_distributions_with_lambda_associations::Builder::default()
    }
}

/// <p>You have reached the maximum number of distributions that are associated with a CloudFront function. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html">Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TooManyDistributionsWithFunctionAssociations {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for TooManyDistributionsWithFunctionAssociations {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TooManyDistributionsWithFunctionAssociations");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl TooManyDistributionsWithFunctionAssociations {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for TooManyDistributionsWithFunctionAssociations {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "TooManyDistributionsWithFunctionAssociations")?;
        if let Some(inner_51) = &self.message {
            write!(f, ": {}", inner_51)?;
        }
        Ok(())
    }
}
impl std::error::Error for TooManyDistributionsWithFunctionAssociations {}
/// See [`TooManyDistributionsWithFunctionAssociations`](crate::error::TooManyDistributionsWithFunctionAssociations)
pub mod too_many_distributions_with_function_associations {
    /// A builder for [`TooManyDistributionsWithFunctionAssociations`](crate::error::TooManyDistributionsWithFunctionAssociations)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`TooManyDistributionsWithFunctionAssociations`](crate::error::TooManyDistributionsWithFunctionAssociations)
        pub fn build(self) -> crate::error::TooManyDistributionsWithFunctionAssociations {
            crate::error::TooManyDistributionsWithFunctionAssociations {
                message: self.message,
            }
        }
    }
}
impl TooManyDistributionsWithFunctionAssociations {
    /// Creates a new builder-style object to manufacture [`TooManyDistributionsWithFunctionAssociations`](crate::error::TooManyDistributionsWithFunctionAssociations)
    pub fn builder() -> crate::error::too_many_distributions_with_function_associations::Builder {
        crate::error::too_many_distributions_with_function_associations::Builder::default()
    }
}

/// <p>The maximum number of distributions have been associated with the specified response headers policy.</p>
/// <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html">Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TooManyDistributionsAssociatedToResponseHeadersPolicy {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for TooManyDistributionsAssociatedToResponseHeadersPolicy {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TooManyDistributionsAssociatedToResponseHeadersPolicy");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl TooManyDistributionsAssociatedToResponseHeadersPolicy {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for TooManyDistributionsAssociatedToResponseHeadersPolicy {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "TooManyDistributionsAssociatedToResponseHeadersPolicy")?;
        if let Some(inner_52) = &self.message {
            write!(f, ": {}", inner_52)?;
        }
        Ok(())
    }
}
impl std::error::Error for TooManyDistributionsAssociatedToResponseHeadersPolicy {}
/// See [`TooManyDistributionsAssociatedToResponseHeadersPolicy`](crate::error::TooManyDistributionsAssociatedToResponseHeadersPolicy)
pub mod too_many_distributions_associated_to_response_headers_policy {
    /// A builder for [`TooManyDistributionsAssociatedToResponseHeadersPolicy`](crate::error::TooManyDistributionsAssociatedToResponseHeadersPolicy)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`TooManyDistributionsAssociatedToResponseHeadersPolicy`](crate::error::TooManyDistributionsAssociatedToResponseHeadersPolicy)
        pub fn build(self) -> crate::error::TooManyDistributionsAssociatedToResponseHeadersPolicy {
            crate::error::TooManyDistributionsAssociatedToResponseHeadersPolicy {
                message: self.message,
            }
        }
    }
}
impl TooManyDistributionsAssociatedToResponseHeadersPolicy {
    /// Creates a new builder-style object to manufacture [`TooManyDistributionsAssociatedToResponseHeadersPolicy`](crate::error::TooManyDistributionsAssociatedToResponseHeadersPolicy)
    pub fn builder(
    ) -> crate::error::too_many_distributions_associated_to_response_headers_policy::Builder {
        crate::error::too_many_distributions_associated_to_response_headers_policy::Builder::default(
        )
    }
}

/// <p>The maximum number of distributions have been associated with the specified origin request policy. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html">Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TooManyDistributionsAssociatedToOriginRequestPolicy {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for TooManyDistributionsAssociatedToOriginRequestPolicy {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TooManyDistributionsAssociatedToOriginRequestPolicy");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl TooManyDistributionsAssociatedToOriginRequestPolicy {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for TooManyDistributionsAssociatedToOriginRequestPolicy {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "TooManyDistributionsAssociatedToOriginRequestPolicy")?;
        if let Some(inner_53) = &self.message {
            write!(f, ": {}", inner_53)?;
        }
        Ok(())
    }
}
impl std::error::Error for TooManyDistributionsAssociatedToOriginRequestPolicy {}
/// See [`TooManyDistributionsAssociatedToOriginRequestPolicy`](crate::error::TooManyDistributionsAssociatedToOriginRequestPolicy)
pub mod too_many_distributions_associated_to_origin_request_policy {
    /// A builder for [`TooManyDistributionsAssociatedToOriginRequestPolicy`](crate::error::TooManyDistributionsAssociatedToOriginRequestPolicy)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`TooManyDistributionsAssociatedToOriginRequestPolicy`](crate::error::TooManyDistributionsAssociatedToOriginRequestPolicy)
        pub fn build(self) -> crate::error::TooManyDistributionsAssociatedToOriginRequestPolicy {
            crate::error::TooManyDistributionsAssociatedToOriginRequestPolicy {
                message: self.message,
            }
        }
    }
}
impl TooManyDistributionsAssociatedToOriginRequestPolicy {
    /// Creates a new builder-style object to manufacture [`TooManyDistributionsAssociatedToOriginRequestPolicy`](crate::error::TooManyDistributionsAssociatedToOriginRequestPolicy)
    pub fn builder(
    ) -> crate::error::too_many_distributions_associated_to_origin_request_policy::Builder {
        crate::error::too_many_distributions_associated_to_origin_request_policy::Builder::default()
    }
}

/// <p>The number of distributions that reference this key group is more than the maximum allowed. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html">Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TooManyDistributionsAssociatedToKeyGroup {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for TooManyDistributionsAssociatedToKeyGroup {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TooManyDistributionsAssociatedToKeyGroup");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl TooManyDistributionsAssociatedToKeyGroup {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for TooManyDistributionsAssociatedToKeyGroup {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "TooManyDistributionsAssociatedToKeyGroup")?;
        if let Some(inner_54) = &self.message {
            write!(f, ": {}", inner_54)?;
        }
        Ok(())
    }
}
impl std::error::Error for TooManyDistributionsAssociatedToKeyGroup {}
/// See [`TooManyDistributionsAssociatedToKeyGroup`](crate::error::TooManyDistributionsAssociatedToKeyGroup)
pub mod too_many_distributions_associated_to_key_group {
    /// A builder for [`TooManyDistributionsAssociatedToKeyGroup`](crate::error::TooManyDistributionsAssociatedToKeyGroup)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`TooManyDistributionsAssociatedToKeyGroup`](crate::error::TooManyDistributionsAssociatedToKeyGroup)
        pub fn build(self) -> crate::error::TooManyDistributionsAssociatedToKeyGroup {
            crate::error::TooManyDistributionsAssociatedToKeyGroup {
                message: self.message,
            }
        }
    }
}
impl TooManyDistributionsAssociatedToKeyGroup {
    /// Creates a new builder-style object to manufacture [`TooManyDistributionsAssociatedToKeyGroup`](crate::error::TooManyDistributionsAssociatedToKeyGroup)
    pub fn builder() -> crate::error::too_many_distributions_associated_to_key_group::Builder {
        crate::error::too_many_distributions_associated_to_key_group::Builder::default()
    }
}

/// <p>The maximum number of distributions have been associated with the specified configuration for field-level encryption.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TooManyDistributionsAssociatedToFieldLevelEncryptionConfig {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for TooManyDistributionsAssociatedToFieldLevelEncryptionConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter =
            f.debug_struct("TooManyDistributionsAssociatedToFieldLevelEncryptionConfig");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl TooManyDistributionsAssociatedToFieldLevelEncryptionConfig {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for TooManyDistributionsAssociatedToFieldLevelEncryptionConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(
            f,
            "TooManyDistributionsAssociatedToFieldLevelEncryptionConfig"
        )?;
        if let Some(inner_55) = &self.message {
            write!(f, ": {}", inner_55)?;
        }
        Ok(())
    }
}
impl std::error::Error for TooManyDistributionsAssociatedToFieldLevelEncryptionConfig {}
/// See [`TooManyDistributionsAssociatedToFieldLevelEncryptionConfig`](crate::error::TooManyDistributionsAssociatedToFieldLevelEncryptionConfig)
pub mod too_many_distributions_associated_to_field_level_encryption_config {
    /// A builder for [`TooManyDistributionsAssociatedToFieldLevelEncryptionConfig`](crate::error::TooManyDistributionsAssociatedToFieldLevelEncryptionConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`TooManyDistributionsAssociatedToFieldLevelEncryptionConfig`](crate::error::TooManyDistributionsAssociatedToFieldLevelEncryptionConfig)
        pub fn build(
            self,
        ) -> crate::error::TooManyDistributionsAssociatedToFieldLevelEncryptionConfig {
            crate::error::TooManyDistributionsAssociatedToFieldLevelEncryptionConfig {
                message: self.message,
            }
        }
    }
}
impl TooManyDistributionsAssociatedToFieldLevelEncryptionConfig {
    /// Creates a new builder-style object to manufacture [`TooManyDistributionsAssociatedToFieldLevelEncryptionConfig`](crate::error::TooManyDistributionsAssociatedToFieldLevelEncryptionConfig)
    pub fn builder(
    ) -> crate::error::too_many_distributions_associated_to_field_level_encryption_config::Builder
    {
        crate::error::too_many_distributions_associated_to_field_level_encryption_config::Builder::default()
    }
}

/// <p>The maximum number of distributions have been associated with the specified cache policy. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html">Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TooManyDistributionsAssociatedToCachePolicy {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for TooManyDistributionsAssociatedToCachePolicy {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TooManyDistributionsAssociatedToCachePolicy");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl TooManyDistributionsAssociatedToCachePolicy {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for TooManyDistributionsAssociatedToCachePolicy {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "TooManyDistributionsAssociatedToCachePolicy")?;
        if let Some(inner_56) = &self.message {
            write!(f, ": {}", inner_56)?;
        }
        Ok(())
    }
}
impl std::error::Error for TooManyDistributionsAssociatedToCachePolicy {}
/// See [`TooManyDistributionsAssociatedToCachePolicy`](crate::error::TooManyDistributionsAssociatedToCachePolicy)
pub mod too_many_distributions_associated_to_cache_policy {
    /// A builder for [`TooManyDistributionsAssociatedToCachePolicy`](crate::error::TooManyDistributionsAssociatedToCachePolicy)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`TooManyDistributionsAssociatedToCachePolicy`](crate::error::TooManyDistributionsAssociatedToCachePolicy)
        pub fn build(self) -> crate::error::TooManyDistributionsAssociatedToCachePolicy {
            crate::error::TooManyDistributionsAssociatedToCachePolicy {
                message: self.message,
            }
        }
    }
}
impl TooManyDistributionsAssociatedToCachePolicy {
    /// Creates a new builder-style object to manufacture [`TooManyDistributionsAssociatedToCachePolicy`](crate::error::TooManyDistributionsAssociatedToCachePolicy)
    pub fn builder() -> crate::error::too_many_distributions_associated_to_cache_policy::Builder {
        crate::error::too_many_distributions_associated_to_cache_policy::Builder::default()
    }
}

/// <p>Your request contains more CNAMEs than are allowed per distribution.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TooManyDistributionCnamEs {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for TooManyDistributionCnamEs {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TooManyDistributionCnamEs");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl TooManyDistributionCnamEs {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for TooManyDistributionCnamEs {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "TooManyDistributionCnamEs [TooManyDistributionCNAMEs]")?;
        if let Some(inner_57) = &self.message {
            write!(f, ": {}", inner_57)?;
        }
        Ok(())
    }
}
impl std::error::Error for TooManyDistributionCnamEs {}
/// See [`TooManyDistributionCnamEs`](crate::error::TooManyDistributionCnamEs)
pub mod too_many_distribution_cnam_es {
    /// A builder for [`TooManyDistributionCnamEs`](crate::error::TooManyDistributionCnamEs)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`TooManyDistributionCnamEs`](crate::error::TooManyDistributionCnamEs)
        pub fn build(self) -> crate::error::TooManyDistributionCnamEs {
            crate::error::TooManyDistributionCnamEs {
                message: self.message,
            }
        }
    }
}
impl TooManyDistributionCnamEs {
    /// Creates a new builder-style object to manufacture [`TooManyDistributionCnamEs`](crate::error::TooManyDistributionCnamEs)
    pub fn builder() -> crate::error::too_many_distribution_cnam_es::Builder {
        crate::error::too_many_distribution_cnam_es::Builder::default()
    }
}

/// <p>Your request contains more cookie names in the whitelist than are allowed per cache behavior.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TooManyCookieNamesInWhiteList {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for TooManyCookieNamesInWhiteList {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TooManyCookieNamesInWhiteList");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl TooManyCookieNamesInWhiteList {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for TooManyCookieNamesInWhiteList {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "TooManyCookieNamesInWhiteList")?;
        if let Some(inner_58) = &self.message {
            write!(f, ": {}", inner_58)?;
        }
        Ok(())
    }
}
impl std::error::Error for TooManyCookieNamesInWhiteList {}
/// See [`TooManyCookieNamesInWhiteList`](crate::error::TooManyCookieNamesInWhiteList)
pub mod too_many_cookie_names_in_white_list {
    /// A builder for [`TooManyCookieNamesInWhiteList`](crate::error::TooManyCookieNamesInWhiteList)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`TooManyCookieNamesInWhiteList`](crate::error::TooManyCookieNamesInWhiteList)
        pub fn build(self) -> crate::error::TooManyCookieNamesInWhiteList {
            crate::error::TooManyCookieNamesInWhiteList {
                message: self.message,
            }
        }
    }
}
impl TooManyCookieNamesInWhiteList {
    /// Creates a new builder-style object to manufacture [`TooManyCookieNamesInWhiteList`](crate::error::TooManyCookieNamesInWhiteList)
    pub fn builder() -> crate::error::too_many_cookie_names_in_white_list::Builder {
        crate::error::too_many_cookie_names_in_white_list::Builder::default()
    }
}

/// <p>You cannot create anymore custom SSL/TLS certificates.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TooManyCertificates {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for TooManyCertificates {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TooManyCertificates");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl TooManyCertificates {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for TooManyCertificates {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "TooManyCertificates")?;
        if let Some(inner_59) = &self.message {
            write!(f, ": {}", inner_59)?;
        }
        Ok(())
    }
}
impl std::error::Error for TooManyCertificates {}
/// See [`TooManyCertificates`](crate::error::TooManyCertificates)
pub mod too_many_certificates {
    /// A builder for [`TooManyCertificates`](crate::error::TooManyCertificates)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`TooManyCertificates`](crate::error::TooManyCertificates)
        pub fn build(self) -> crate::error::TooManyCertificates {
            crate::error::TooManyCertificates {
                message: self.message,
            }
        }
    }
}
impl TooManyCertificates {
    /// Creates a new builder-style object to manufacture [`TooManyCertificates`](crate::error::TooManyCertificates)
    pub fn builder() -> crate::error::too_many_certificates::Builder {
        crate::error::too_many_certificates::Builder::default()
    }
}

/// <p>You cannot create more cache behaviors for the distribution.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TooManyCacheBehaviors {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for TooManyCacheBehaviors {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TooManyCacheBehaviors");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl TooManyCacheBehaviors {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for TooManyCacheBehaviors {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "TooManyCacheBehaviors")?;
        if let Some(inner_60) = &self.message {
            write!(f, ": {}", inner_60)?;
        }
        Ok(())
    }
}
impl std::error::Error for TooManyCacheBehaviors {}
/// See [`TooManyCacheBehaviors`](crate::error::TooManyCacheBehaviors)
pub mod too_many_cache_behaviors {
    /// A builder for [`TooManyCacheBehaviors`](crate::error::TooManyCacheBehaviors)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`TooManyCacheBehaviors`](crate::error::TooManyCacheBehaviors)
        pub fn build(self) -> crate::error::TooManyCacheBehaviors {
            crate::error::TooManyCacheBehaviors {
                message: self.message,
            }
        }
    }
}
impl TooManyCacheBehaviors {
    /// Creates a new builder-style object to manufacture [`TooManyCacheBehaviors`](crate::error::TooManyCacheBehaviors)
    pub fn builder() -> crate::error::too_many_cache_behaviors::Builder {
        crate::error::too_many_cache_behaviors::Builder::default()
    }
}

/// <p>The specified real-time log configuration belongs to a different Amazon Web Services account.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RealtimeLogConfigOwnerMismatch {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for RealtimeLogConfigOwnerMismatch {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RealtimeLogConfigOwnerMismatch");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl RealtimeLogConfigOwnerMismatch {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for RealtimeLogConfigOwnerMismatch {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "RealtimeLogConfigOwnerMismatch")?;
        if let Some(inner_61) = &self.message {
            write!(f, ": {}", inner_61)?;
        }
        Ok(())
    }
}
impl std::error::Error for RealtimeLogConfigOwnerMismatch {}
/// See [`RealtimeLogConfigOwnerMismatch`](crate::error::RealtimeLogConfigOwnerMismatch)
pub mod realtime_log_config_owner_mismatch {
    /// A builder for [`RealtimeLogConfigOwnerMismatch`](crate::error::RealtimeLogConfigOwnerMismatch)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`RealtimeLogConfigOwnerMismatch`](crate::error::RealtimeLogConfigOwnerMismatch)
        pub fn build(self) -> crate::error::RealtimeLogConfigOwnerMismatch {
            crate::error::RealtimeLogConfigOwnerMismatch {
                message: self.message,
            }
        }
    }
}
impl RealtimeLogConfigOwnerMismatch {
    /// Creates a new builder-style object to manufacture [`RealtimeLogConfigOwnerMismatch`](crate::error::RealtimeLogConfigOwnerMismatch)
    pub fn builder() -> crate::error::realtime_log_config_owner_mismatch::Builder {
        crate::error::realtime_log_config_owner_mismatch::Builder::default()
    }
}

/// <p>No origin exists with the specified <code>Origin Id</code>. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct NoSuchOrigin {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for NoSuchOrigin {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("NoSuchOrigin");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl NoSuchOrigin {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for NoSuchOrigin {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "NoSuchOrigin")?;
        if let Some(inner_62) = &self.message {
            write!(f, ": {}", inner_62)?;
        }
        Ok(())
    }
}
impl std::error::Error for NoSuchOrigin {}
/// See [`NoSuchOrigin`](crate::error::NoSuchOrigin)
pub mod no_such_origin {
    /// A builder for [`NoSuchOrigin`](crate::error::NoSuchOrigin)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`NoSuchOrigin`](crate::error::NoSuchOrigin)
        pub fn build(self) -> crate::error::NoSuchOrigin {
            crate::error::NoSuchOrigin {
                message: self.message,
            }
        }
    }
}
impl NoSuchOrigin {
    /// Creates a new builder-style object to manufacture [`NoSuchOrigin`](crate::error::NoSuchOrigin)
    pub fn builder() -> crate::error::no_such_origin::Builder {
        crate::error::no_such_origin::Builder::default()
    }
}

/// <p>The specified distribution does not exist.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct NoSuchDistribution {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for NoSuchDistribution {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("NoSuchDistribution");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl NoSuchDistribution {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for NoSuchDistribution {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "NoSuchDistribution")?;
        if let Some(inner_63) = &self.message {
            write!(f, ": {}", inner_63)?;
        }
        Ok(())
    }
}
impl std::error::Error for NoSuchDistribution {}
/// See [`NoSuchDistribution`](crate::error::NoSuchDistribution)
pub mod no_such_distribution {
    /// A builder for [`NoSuchDistribution`](crate::error::NoSuchDistribution)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`NoSuchDistribution`](crate::error::NoSuchDistribution)
        pub fn build(self) -> crate::error::NoSuchDistribution {
            crate::error::NoSuchDistribution {
                message: self.message,
            }
        }
    }
}
impl NoSuchDistribution {
    /// Creates a new builder-style object to manufacture [`NoSuchDistribution`](crate::error::NoSuchDistribution)
    pub fn builder() -> crate::error::no_such_distribution::Builder {
        crate::error::no_such_distribution::Builder::default()
    }
}

/// <p>The cache policy does not exist.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct NoSuchCachePolicy {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for NoSuchCachePolicy {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("NoSuchCachePolicy");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl NoSuchCachePolicy {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for NoSuchCachePolicy {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "NoSuchCachePolicy")?;
        if let Some(inner_64) = &self.message {
            write!(f, ": {}", inner_64)?;
        }
        Ok(())
    }
}
impl std::error::Error for NoSuchCachePolicy {}
/// See [`NoSuchCachePolicy`](crate::error::NoSuchCachePolicy)
pub mod no_such_cache_policy {
    /// A builder for [`NoSuchCachePolicy`](crate::error::NoSuchCachePolicy)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`NoSuchCachePolicy`](crate::error::NoSuchCachePolicy)
        pub fn build(self) -> crate::error::NoSuchCachePolicy {
            crate::error::NoSuchCachePolicy {
                message: self.message,
            }
        }
    }
}
impl NoSuchCachePolicy {
    /// Creates a new builder-style object to manufacture [`NoSuchCachePolicy`](crate::error::NoSuchCachePolicy)
    pub fn builder() -> crate::error::no_such_cache_policy::Builder {
        crate::error::no_such_cache_policy::Builder::default()
    }
}

/// <p>A web ACL ID specified is not valid. To specify a web ACL created using the latest version of WAF, use the ACL ARN, for example <code>arn:aws:wafv2:us-east-1:123456789012:global/webacl/ExampleWebACL/473e64fd-f30b-4765-81a0-62ad96dd167a</code>. To specify a web ACL created using WAF Classic, use the ACL ID, for example <code>473e64fd-f30b-4765-81a0-62ad96dd167a</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidWebAclId {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidWebAclId {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidWebAclId");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidWebAclId {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidWebAclId {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidWebAclId [InvalidWebACLId]")?;
        if let Some(inner_65) = &self.message {
            write!(f, ": {}", inner_65)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidWebAclId {}
/// See [`InvalidWebAclId`](crate::error::InvalidWebAclId)
pub mod invalid_web_acl_id {
    /// A builder for [`InvalidWebAclId`](crate::error::InvalidWebAclId)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidWebAclId`](crate::error::InvalidWebAclId)
        pub fn build(self) -> crate::error::InvalidWebAclId {
            crate::error::InvalidWebAclId {
                message: self.message,
            }
        }
    }
}
impl InvalidWebAclId {
    /// Creates a new builder-style object to manufacture [`InvalidWebAclId`](crate::error::InvalidWebAclId)
    pub fn builder() -> crate::error::invalid_web_acl_id::Builder {
        crate::error::invalid_web_acl_id::Builder::default()
    }
}

/// <p>A viewer certificate specified is not valid.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidViewerCertificate {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidViewerCertificate {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidViewerCertificate");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidViewerCertificate {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidViewerCertificate {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidViewerCertificate")?;
        if let Some(inner_66) = &self.message {
            write!(f, ": {}", inner_66)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidViewerCertificate {}
/// See [`InvalidViewerCertificate`](crate::error::InvalidViewerCertificate)
pub mod invalid_viewer_certificate {
    /// A builder for [`InvalidViewerCertificate`](crate::error::InvalidViewerCertificate)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidViewerCertificate`](crate::error::InvalidViewerCertificate)
        pub fn build(self) -> crate::error::InvalidViewerCertificate {
            crate::error::InvalidViewerCertificate {
                message: self.message,
            }
        }
    }
}
impl InvalidViewerCertificate {
    /// Creates a new builder-style object to manufacture [`InvalidViewerCertificate`](crate::error::InvalidViewerCertificate)
    pub fn builder() -> crate::error::invalid_viewer_certificate::Builder {
        crate::error::invalid_viewer_certificate::Builder::default()
    }
}

/// <p>The TTL order specified is not valid.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidTtlOrder {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidTtlOrder {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidTtlOrder");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidTtlOrder {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidTtlOrder {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidTtlOrder [InvalidTTLOrder]")?;
        if let Some(inner_67) = &self.message {
            write!(f, ": {}", inner_67)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidTtlOrder {}
/// See [`InvalidTtlOrder`](crate::error::InvalidTtlOrder)
pub mod invalid_ttl_order {
    /// A builder for [`InvalidTtlOrder`](crate::error::InvalidTtlOrder)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidTtlOrder`](crate::error::InvalidTtlOrder)
        pub fn build(self) -> crate::error::InvalidTtlOrder {
            crate::error::InvalidTtlOrder {
                message: self.message,
            }
        }
    }
}
impl InvalidTtlOrder {
    /// Creates a new builder-style object to manufacture [`InvalidTtlOrder`](crate::error::InvalidTtlOrder)
    pub fn builder() -> crate::error::invalid_ttl_order::Builder {
        crate::error::invalid_ttl_order::Builder::default()
    }
}

/// <p>A response code is not valid.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidResponseCode {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidResponseCode {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidResponseCode");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidResponseCode {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidResponseCode {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidResponseCode")?;
        if let Some(inner_68) = &self.message {
            write!(f, ": {}", inner_68)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidResponseCode {}
/// See [`InvalidResponseCode`](crate::error::InvalidResponseCode)
pub mod invalid_response_code {
    /// A builder for [`InvalidResponseCode`](crate::error::InvalidResponseCode)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidResponseCode`](crate::error::InvalidResponseCode)
        pub fn build(self) -> crate::error::InvalidResponseCode {
            crate::error::InvalidResponseCode {
                message: self.message,
            }
        }
    }
}
impl InvalidResponseCode {
    /// Creates a new builder-style object to manufacture [`InvalidResponseCode`](crate::error::InvalidResponseCode)
    pub fn builder() -> crate::error::invalid_response_code::Builder {
        crate::error::invalid_response_code::Builder::default()
    }
}

/// <p>This operation requires the HTTPS protocol. Ensure that you specify the HTTPS protocol in your request, or omit the <code>RequiredProtocols</code> element from your distribution configuration.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidRequiredProtocol {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidRequiredProtocol {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidRequiredProtocol");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidRequiredProtocol {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidRequiredProtocol {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidRequiredProtocol")?;
        if let Some(inner_69) = &self.message {
            write!(f, ": {}", inner_69)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidRequiredProtocol {}
/// See [`InvalidRequiredProtocol`](crate::error::InvalidRequiredProtocol)
pub mod invalid_required_protocol {
    /// A builder for [`InvalidRequiredProtocol`](crate::error::InvalidRequiredProtocol)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidRequiredProtocol`](crate::error::InvalidRequiredProtocol)
        pub fn build(self) -> crate::error::InvalidRequiredProtocol {
            crate::error::InvalidRequiredProtocol {
                message: self.message,
            }
        }
    }
}
impl InvalidRequiredProtocol {
    /// Creates a new builder-style object to manufacture [`InvalidRequiredProtocol`](crate::error::InvalidRequiredProtocol)
    pub fn builder() -> crate::error::invalid_required_protocol::Builder {
        crate::error::invalid_required_protocol::Builder::default()
    }
}

/// <p>The relative path is too big, is not URL-encoded, or does not begin with a slash (/).</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidRelativePath {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidRelativePath {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidRelativePath");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidRelativePath {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidRelativePath {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidRelativePath")?;
        if let Some(inner_70) = &self.message {
            write!(f, ": {}", inner_70)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidRelativePath {}
/// See [`InvalidRelativePath`](crate::error::InvalidRelativePath)
pub mod invalid_relative_path {
    /// A builder for [`InvalidRelativePath`](crate::error::InvalidRelativePath)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidRelativePath`](crate::error::InvalidRelativePath)
        pub fn build(self) -> crate::error::InvalidRelativePath {
            crate::error::InvalidRelativePath {
                message: self.message,
            }
        }
    }
}
impl InvalidRelativePath {
    /// Creates a new builder-style object to manufacture [`InvalidRelativePath`](crate::error::InvalidRelativePath)
    pub fn builder() -> crate::error::invalid_relative_path::Builder {
        crate::error::invalid_relative_path::Builder::default()
    }
}

/// <p>The query string parameters specified are not valid.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidQueryStringParameters {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidQueryStringParameters {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidQueryStringParameters");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidQueryStringParameters {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidQueryStringParameters {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidQueryStringParameters")?;
        if let Some(inner_71) = &self.message {
            write!(f, ": {}", inner_71)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidQueryStringParameters {}
/// See [`InvalidQueryStringParameters`](crate::error::InvalidQueryStringParameters)
pub mod invalid_query_string_parameters {
    /// A builder for [`InvalidQueryStringParameters`](crate::error::InvalidQueryStringParameters)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidQueryStringParameters`](crate::error::InvalidQueryStringParameters)
        pub fn build(self) -> crate::error::InvalidQueryStringParameters {
            crate::error::InvalidQueryStringParameters {
                message: self.message,
            }
        }
    }
}
impl InvalidQueryStringParameters {
    /// Creates a new builder-style object to manufacture [`InvalidQueryStringParameters`](crate::error::InvalidQueryStringParameters)
    pub fn builder() -> crate::error::invalid_query_string_parameters::Builder {
        crate::error::invalid_query_string_parameters::Builder::default()
    }
}

/// <p>The read timeout specified for the origin is not valid.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidOriginReadTimeout {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidOriginReadTimeout {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidOriginReadTimeout");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidOriginReadTimeout {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidOriginReadTimeout {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidOriginReadTimeout")?;
        if let Some(inner_72) = &self.message {
            write!(f, ": {}", inner_72)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidOriginReadTimeout {}
/// See [`InvalidOriginReadTimeout`](crate::error::InvalidOriginReadTimeout)
pub mod invalid_origin_read_timeout {
    /// A builder for [`InvalidOriginReadTimeout`](crate::error::InvalidOriginReadTimeout)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidOriginReadTimeout`](crate::error::InvalidOriginReadTimeout)
        pub fn build(self) -> crate::error::InvalidOriginReadTimeout {
            crate::error::InvalidOriginReadTimeout {
                message: self.message,
            }
        }
    }
}
impl InvalidOriginReadTimeout {
    /// Creates a new builder-style object to manufacture [`InvalidOriginReadTimeout`](crate::error::InvalidOriginReadTimeout)
    pub fn builder() -> crate::error::invalid_origin_read_timeout::Builder {
        crate::error::invalid_origin_read_timeout::Builder::default()
    }
}

/// <p>The keep alive timeout specified for the origin is not valid.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidOriginKeepaliveTimeout {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidOriginKeepaliveTimeout {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidOriginKeepaliveTimeout");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidOriginKeepaliveTimeout {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidOriginKeepaliveTimeout {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidOriginKeepaliveTimeout")?;
        if let Some(inner_73) = &self.message {
            write!(f, ": {}", inner_73)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidOriginKeepaliveTimeout {}
/// See [`InvalidOriginKeepaliveTimeout`](crate::error::InvalidOriginKeepaliveTimeout)
pub mod invalid_origin_keepalive_timeout {
    /// A builder for [`InvalidOriginKeepaliveTimeout`](crate::error::InvalidOriginKeepaliveTimeout)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidOriginKeepaliveTimeout`](crate::error::InvalidOriginKeepaliveTimeout)
        pub fn build(self) -> crate::error::InvalidOriginKeepaliveTimeout {
            crate::error::InvalidOriginKeepaliveTimeout {
                message: self.message,
            }
        }
    }
}
impl InvalidOriginKeepaliveTimeout {
    /// Creates a new builder-style object to manufacture [`InvalidOriginKeepaliveTimeout`](crate::error::InvalidOriginKeepaliveTimeout)
    pub fn builder() -> crate::error::invalid_origin_keepalive_timeout::Builder {
        crate::error::invalid_origin_keepalive_timeout::Builder::default()
    }
}

/// <p>The minimum protocol version specified is not valid.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidMinimumProtocolVersion {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidMinimumProtocolVersion {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidMinimumProtocolVersion");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidMinimumProtocolVersion {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidMinimumProtocolVersion {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidMinimumProtocolVersion")?;
        if let Some(inner_74) = &self.message {
            write!(f, ": {}", inner_74)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidMinimumProtocolVersion {}
/// See [`InvalidMinimumProtocolVersion`](crate::error::InvalidMinimumProtocolVersion)
pub mod invalid_minimum_protocol_version {
    /// A builder for [`InvalidMinimumProtocolVersion`](crate::error::InvalidMinimumProtocolVersion)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidMinimumProtocolVersion`](crate::error::InvalidMinimumProtocolVersion)
        pub fn build(self) -> crate::error::InvalidMinimumProtocolVersion {
            crate::error::InvalidMinimumProtocolVersion {
                message: self.message,
            }
        }
    }
}
impl InvalidMinimumProtocolVersion {
    /// Creates a new builder-style object to manufacture [`InvalidMinimumProtocolVersion`](crate::error::InvalidMinimumProtocolVersion)
    pub fn builder() -> crate::error::invalid_minimum_protocol_version::Builder {
        crate::error::invalid_minimum_protocol_version::Builder::default()
    }
}

/// <p>The location code specified is not valid.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidLocationCode {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidLocationCode {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidLocationCode");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidLocationCode {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidLocationCode {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidLocationCode")?;
        if let Some(inner_75) = &self.message {
            write!(f, ": {}", inner_75)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidLocationCode {}
/// See [`InvalidLocationCode`](crate::error::InvalidLocationCode)
pub mod invalid_location_code {
    /// A builder for [`InvalidLocationCode`](crate::error::InvalidLocationCode)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidLocationCode`](crate::error::InvalidLocationCode)
        pub fn build(self) -> crate::error::InvalidLocationCode {
            crate::error::InvalidLocationCode {
                message: self.message,
            }
        }
    }
}
impl InvalidLocationCode {
    /// Creates a new builder-style object to manufacture [`InvalidLocationCode`](crate::error::InvalidLocationCode)
    pub fn builder() -> crate::error::invalid_location_code::Builder {
        crate::error::invalid_location_code::Builder::default()
    }
}

/// <p>The specified Lambda@Edge function association is invalid.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidLambdaFunctionAssociation {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidLambdaFunctionAssociation {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidLambdaFunctionAssociation");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidLambdaFunctionAssociation {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidLambdaFunctionAssociation {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidLambdaFunctionAssociation")?;
        if let Some(inner_76) = &self.message {
            write!(f, ": {}", inner_76)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidLambdaFunctionAssociation {}
/// See [`InvalidLambdaFunctionAssociation`](crate::error::InvalidLambdaFunctionAssociation)
pub mod invalid_lambda_function_association {
    /// A builder for [`InvalidLambdaFunctionAssociation`](crate::error::InvalidLambdaFunctionAssociation)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidLambdaFunctionAssociation`](crate::error::InvalidLambdaFunctionAssociation)
        pub fn build(self) -> crate::error::InvalidLambdaFunctionAssociation {
            crate::error::InvalidLambdaFunctionAssociation {
                message: self.message,
            }
        }
    }
}
impl InvalidLambdaFunctionAssociation {
    /// Creates a new builder-style object to manufacture [`InvalidLambdaFunctionAssociation`](crate::error::InvalidLambdaFunctionAssociation)
    pub fn builder() -> crate::error::invalid_lambda_function_association::Builder {
        crate::error::invalid_lambda_function_association::Builder::default()
    }
}

/// <p>The headers specified are not valid for an Amazon S3 origin.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidHeadersForS3Origin {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidHeadersForS3Origin {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidHeadersForS3Origin");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidHeadersForS3Origin {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidHeadersForS3Origin {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidHeadersForS3Origin")?;
        if let Some(inner_77) = &self.message {
            write!(f, ": {}", inner_77)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidHeadersForS3Origin {}
/// See [`InvalidHeadersForS3Origin`](crate::error::InvalidHeadersForS3Origin)
pub mod invalid_headers_for_s3_origin {
    /// A builder for [`InvalidHeadersForS3Origin`](crate::error::InvalidHeadersForS3Origin)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidHeadersForS3Origin`](crate::error::InvalidHeadersForS3Origin)
        pub fn build(self) -> crate::error::InvalidHeadersForS3Origin {
            crate::error::InvalidHeadersForS3Origin {
                message: self.message,
            }
        }
    }
}
impl InvalidHeadersForS3Origin {
    /// Creates a new builder-style object to manufacture [`InvalidHeadersForS3Origin`](crate::error::InvalidHeadersForS3Origin)
    pub fn builder() -> crate::error::invalid_headers_for_s3_origin::Builder {
        crate::error::invalid_headers_for_s3_origin::Builder::default()
    }
}

/// <p>The specified geo restriction parameter is not valid.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidGeoRestrictionParameter {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidGeoRestrictionParameter {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidGeoRestrictionParameter");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidGeoRestrictionParameter {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidGeoRestrictionParameter {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidGeoRestrictionParameter")?;
        if let Some(inner_78) = &self.message {
            write!(f, ": {}", inner_78)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidGeoRestrictionParameter {}
/// See [`InvalidGeoRestrictionParameter`](crate::error::InvalidGeoRestrictionParameter)
pub mod invalid_geo_restriction_parameter {
    /// A builder for [`InvalidGeoRestrictionParameter`](crate::error::InvalidGeoRestrictionParameter)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidGeoRestrictionParameter`](crate::error::InvalidGeoRestrictionParameter)
        pub fn build(self) -> crate::error::InvalidGeoRestrictionParameter {
            crate::error::InvalidGeoRestrictionParameter {
                message: self.message,
            }
        }
    }
}
impl InvalidGeoRestrictionParameter {
    /// Creates a new builder-style object to manufacture [`InvalidGeoRestrictionParameter`](crate::error::InvalidGeoRestrictionParameter)
    pub fn builder() -> crate::error::invalid_geo_restriction_parameter::Builder {
        crate::error::invalid_geo_restriction_parameter::Builder::default()
    }
}

/// <p>A CloudFront function association is invalid.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidFunctionAssociation {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidFunctionAssociation {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidFunctionAssociation");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidFunctionAssociation {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidFunctionAssociation {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidFunctionAssociation")?;
        if let Some(inner_79) = &self.message {
            write!(f, ": {}", inner_79)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidFunctionAssociation {}
/// See [`InvalidFunctionAssociation`](crate::error::InvalidFunctionAssociation)
pub mod invalid_function_association {
    /// A builder for [`InvalidFunctionAssociation`](crate::error::InvalidFunctionAssociation)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidFunctionAssociation`](crate::error::InvalidFunctionAssociation)
        pub fn build(self) -> crate::error::InvalidFunctionAssociation {
            crate::error::InvalidFunctionAssociation {
                message: self.message,
            }
        }
    }
}
impl InvalidFunctionAssociation {
    /// Creates a new builder-style object to manufacture [`InvalidFunctionAssociation`](crate::error::InvalidFunctionAssociation)
    pub fn builder() -> crate::error::invalid_function_association::Builder {
        crate::error::invalid_function_association::Builder::default()
    }
}

/// <p>Your request contains forward cookies option which doesn't match with the expectation for the <code>whitelisted</code> list of cookie names. Either list of cookie names has been specified when not allowed or list of cookie names is missing when expected.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidForwardCookies {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidForwardCookies {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidForwardCookies");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidForwardCookies {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidForwardCookies {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidForwardCookies")?;
        if let Some(inner_80) = &self.message {
            write!(f, ": {}", inner_80)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidForwardCookies {}
/// See [`InvalidForwardCookies`](crate::error::InvalidForwardCookies)
pub mod invalid_forward_cookies {
    /// A builder for [`InvalidForwardCookies`](crate::error::InvalidForwardCookies)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidForwardCookies`](crate::error::InvalidForwardCookies)
        pub fn build(self) -> crate::error::InvalidForwardCookies {
            crate::error::InvalidForwardCookies {
                message: self.message,
            }
        }
    }
}
impl InvalidForwardCookies {
    /// Creates a new builder-style object to manufacture [`InvalidForwardCookies`](crate::error::InvalidForwardCookies)
    pub fn builder() -> crate::error::invalid_forward_cookies::Builder {
        crate::error::invalid_forward_cookies::Builder::default()
    }
}

/// <p>An invalid error code was specified.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidErrorCode {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidErrorCode {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidErrorCode");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidErrorCode {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidErrorCode {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidErrorCode")?;
        if let Some(inner_81) = &self.message {
            write!(f, ": {}", inner_81)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidErrorCode {}
/// See [`InvalidErrorCode`](crate::error::InvalidErrorCode)
pub mod invalid_error_code {
    /// A builder for [`InvalidErrorCode`](crate::error::InvalidErrorCode)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidErrorCode`](crate::error::InvalidErrorCode)
        pub fn build(self) -> crate::error::InvalidErrorCode {
            crate::error::InvalidErrorCode {
                message: self.message,
            }
        }
    }
}
impl InvalidErrorCode {
    /// Creates a new builder-style object to manufacture [`InvalidErrorCode`](crate::error::InvalidErrorCode)
    pub fn builder() -> crate::error::invalid_error_code::Builder {
        crate::error::invalid_error_code::Builder::default()
    }
}

/// <p>The default root object file name is too big or contains an invalid character.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidDefaultRootObject {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidDefaultRootObject {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidDefaultRootObject");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidDefaultRootObject {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidDefaultRootObject {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidDefaultRootObject")?;
        if let Some(inner_82) = &self.message {
            write!(f, ": {}", inner_82)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidDefaultRootObject {}
/// See [`InvalidDefaultRootObject`](crate::error::InvalidDefaultRootObject)
pub mod invalid_default_root_object {
    /// A builder for [`InvalidDefaultRootObject`](crate::error::InvalidDefaultRootObject)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidDefaultRootObject`](crate::error::InvalidDefaultRootObject)
        pub fn build(self) -> crate::error::InvalidDefaultRootObject {
            crate::error::InvalidDefaultRootObject {
                message: self.message,
            }
        }
    }
}
impl InvalidDefaultRootObject {
    /// Creates a new builder-style object to manufacture [`InvalidDefaultRootObject`](crate::error::InvalidDefaultRootObject)
    pub fn builder() -> crate::error::invalid_default_root_object::Builder {
        crate::error::invalid_default_root_object::Builder::default()
    }
}

/// <p>The specified configuration for field-level encryption can't be associated with the specified cache behavior.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct IllegalFieldLevelEncryptionConfigAssociationWithCacheBehavior {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for IllegalFieldLevelEncryptionConfigAssociationWithCacheBehavior {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter =
            f.debug_struct("IllegalFieldLevelEncryptionConfigAssociationWithCacheBehavior");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl IllegalFieldLevelEncryptionConfigAssociationWithCacheBehavior {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for IllegalFieldLevelEncryptionConfigAssociationWithCacheBehavior {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(
            f,
            "IllegalFieldLevelEncryptionConfigAssociationWithCacheBehavior"
        )?;
        if let Some(inner_83) = &self.message {
            write!(f, ": {}", inner_83)?;
        }
        Ok(())
    }
}
impl std::error::Error for IllegalFieldLevelEncryptionConfigAssociationWithCacheBehavior {}
/// See [`IllegalFieldLevelEncryptionConfigAssociationWithCacheBehavior`](crate::error::IllegalFieldLevelEncryptionConfigAssociationWithCacheBehavior)
pub mod illegal_field_level_encryption_config_association_with_cache_behavior {
    /// A builder for [`IllegalFieldLevelEncryptionConfigAssociationWithCacheBehavior`](crate::error::IllegalFieldLevelEncryptionConfigAssociationWithCacheBehavior)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`IllegalFieldLevelEncryptionConfigAssociationWithCacheBehavior`](crate::error::IllegalFieldLevelEncryptionConfigAssociationWithCacheBehavior)
        pub fn build(
            self,
        ) -> crate::error::IllegalFieldLevelEncryptionConfigAssociationWithCacheBehavior {
            crate::error::IllegalFieldLevelEncryptionConfigAssociationWithCacheBehavior {
                message: self.message,
            }
        }
    }
}
impl IllegalFieldLevelEncryptionConfigAssociationWithCacheBehavior {
    /// Creates a new builder-style object to manufacture [`IllegalFieldLevelEncryptionConfigAssociationWithCacheBehavior`](crate::error::IllegalFieldLevelEncryptionConfigAssociationWithCacheBehavior)
    pub fn builder(
    ) -> crate::error::illegal_field_level_encryption_config_association_with_cache_behavior::Builder
    {
        crate::error::illegal_field_level_encryption_config_association_with_cache_behavior::Builder::default()
    }
}

/// <p>The specified origin access identity does not exist.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct NoSuchCloudFrontOriginAccessIdentity {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for NoSuchCloudFrontOriginAccessIdentity {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("NoSuchCloudFrontOriginAccessIdentity");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl NoSuchCloudFrontOriginAccessIdentity {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for NoSuchCloudFrontOriginAccessIdentity {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "NoSuchCloudFrontOriginAccessIdentity")?;
        if let Some(inner_84) = &self.message {
            write!(f, ": {}", inner_84)?;
        }
        Ok(())
    }
}
impl std::error::Error for NoSuchCloudFrontOriginAccessIdentity {}
/// See [`NoSuchCloudFrontOriginAccessIdentity`](crate::error::NoSuchCloudFrontOriginAccessIdentity)
pub mod no_such_cloud_front_origin_access_identity {
    /// A builder for [`NoSuchCloudFrontOriginAccessIdentity`](crate::error::NoSuchCloudFrontOriginAccessIdentity)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`NoSuchCloudFrontOriginAccessIdentity`](crate::error::NoSuchCloudFrontOriginAccessIdentity)
        pub fn build(self) -> crate::error::NoSuchCloudFrontOriginAccessIdentity {
            crate::error::NoSuchCloudFrontOriginAccessIdentity {
                message: self.message,
            }
        }
    }
}
impl NoSuchCloudFrontOriginAccessIdentity {
    /// Creates a new builder-style object to manufacture [`NoSuchCloudFrontOriginAccessIdentity`](crate::error::NoSuchCloudFrontOriginAccessIdentity)
    pub fn builder() -> crate::error::no_such_cloud_front_origin_access_identity::Builder {
        crate::error::no_such_cloud_front_origin_access_identity::Builder::default()
    }
}

/// <p>The number of query strings in the cache policy exceeds the maximum. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html">Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TooManyQueryStringsInCachePolicy {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for TooManyQueryStringsInCachePolicy {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TooManyQueryStringsInCachePolicy");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl TooManyQueryStringsInCachePolicy {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for TooManyQueryStringsInCachePolicy {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "TooManyQueryStringsInCachePolicy")?;
        if let Some(inner_85) = &self.message {
            write!(f, ": {}", inner_85)?;
        }
        Ok(())
    }
}
impl std::error::Error for TooManyQueryStringsInCachePolicy {}
/// See [`TooManyQueryStringsInCachePolicy`](crate::error::TooManyQueryStringsInCachePolicy)
pub mod too_many_query_strings_in_cache_policy {
    /// A builder for [`TooManyQueryStringsInCachePolicy`](crate::error::TooManyQueryStringsInCachePolicy)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`TooManyQueryStringsInCachePolicy`](crate::error::TooManyQueryStringsInCachePolicy)
        pub fn build(self) -> crate::error::TooManyQueryStringsInCachePolicy {
            crate::error::TooManyQueryStringsInCachePolicy {
                message: self.message,
            }
        }
    }
}
impl TooManyQueryStringsInCachePolicy {
    /// Creates a new builder-style object to manufacture [`TooManyQueryStringsInCachePolicy`](crate::error::TooManyQueryStringsInCachePolicy)
    pub fn builder() -> crate::error::too_many_query_strings_in_cache_policy::Builder {
        crate::error::too_many_query_strings_in_cache_policy::Builder::default()
    }
}

/// <p>The number of headers in the cache policy exceeds the maximum. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html">Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TooManyHeadersInCachePolicy {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for TooManyHeadersInCachePolicy {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TooManyHeadersInCachePolicy");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl TooManyHeadersInCachePolicy {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for TooManyHeadersInCachePolicy {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "TooManyHeadersInCachePolicy")?;
        if let Some(inner_86) = &self.message {
            write!(f, ": {}", inner_86)?;
        }
        Ok(())
    }
}
impl std::error::Error for TooManyHeadersInCachePolicy {}
/// See [`TooManyHeadersInCachePolicy`](crate::error::TooManyHeadersInCachePolicy)
pub mod too_many_headers_in_cache_policy {
    /// A builder for [`TooManyHeadersInCachePolicy`](crate::error::TooManyHeadersInCachePolicy)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`TooManyHeadersInCachePolicy`](crate::error::TooManyHeadersInCachePolicy)
        pub fn build(self) -> crate::error::TooManyHeadersInCachePolicy {
            crate::error::TooManyHeadersInCachePolicy {
                message: self.message,
            }
        }
    }
}
impl TooManyHeadersInCachePolicy {
    /// Creates a new builder-style object to manufacture [`TooManyHeadersInCachePolicy`](crate::error::TooManyHeadersInCachePolicy)
    pub fn builder() -> crate::error::too_many_headers_in_cache_policy::Builder {
        crate::error::too_many_headers_in_cache_policy::Builder::default()
    }
}

/// <p>The number of cookies in the cache policy exceeds the maximum. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html">Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TooManyCookiesInCachePolicy {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for TooManyCookiesInCachePolicy {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TooManyCookiesInCachePolicy");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl TooManyCookiesInCachePolicy {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for TooManyCookiesInCachePolicy {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "TooManyCookiesInCachePolicy")?;
        if let Some(inner_87) = &self.message {
            write!(f, ": {}", inner_87)?;
        }
        Ok(())
    }
}
impl std::error::Error for TooManyCookiesInCachePolicy {}
/// See [`TooManyCookiesInCachePolicy`](crate::error::TooManyCookiesInCachePolicy)
pub mod too_many_cookies_in_cache_policy {
    /// A builder for [`TooManyCookiesInCachePolicy`](crate::error::TooManyCookiesInCachePolicy)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`TooManyCookiesInCachePolicy`](crate::error::TooManyCookiesInCachePolicy)
        pub fn build(self) -> crate::error::TooManyCookiesInCachePolicy {
            crate::error::TooManyCookiesInCachePolicy {
                message: self.message,
            }
        }
    }
}
impl TooManyCookiesInCachePolicy {
    /// Creates a new builder-style object to manufacture [`TooManyCookiesInCachePolicy`](crate::error::TooManyCookiesInCachePolicy)
    pub fn builder() -> crate::error::too_many_cookies_in_cache_policy::Builder {
        crate::error::too_many_cookies_in_cache_policy::Builder::default()
    }
}

/// <p>A cache policy with this name already exists. You must provide a unique name. To modify an existing cache policy, use <code>UpdateCachePolicy</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CachePolicyAlreadyExists {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for CachePolicyAlreadyExists {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CachePolicyAlreadyExists");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl CachePolicyAlreadyExists {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for CachePolicyAlreadyExists {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "CachePolicyAlreadyExists")?;
        if let Some(inner_88) = &self.message {
            write!(f, ": {}", inner_88)?;
        }
        Ok(())
    }
}
impl std::error::Error for CachePolicyAlreadyExists {}
/// See [`CachePolicyAlreadyExists`](crate::error::CachePolicyAlreadyExists)
pub mod cache_policy_already_exists {
    /// A builder for [`CachePolicyAlreadyExists`](crate::error::CachePolicyAlreadyExists)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`CachePolicyAlreadyExists`](crate::error::CachePolicyAlreadyExists)
        pub fn build(self) -> crate::error::CachePolicyAlreadyExists {
            crate::error::CachePolicyAlreadyExists {
                message: self.message,
            }
        }
    }
}
impl CachePolicyAlreadyExists {
    /// Creates a new builder-style object to manufacture [`CachePolicyAlreadyExists`](crate::error::CachePolicyAlreadyExists)
    pub fn builder() -> crate::error::cache_policy_already_exists::Builder {
        crate::error::cache_policy_already_exists::Builder::default()
    }
}

/// <p>The tagging specified is not valid.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidTagging {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidTagging {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidTagging");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidTagging {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidTagging {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidTagging")?;
        if let Some(inner_89) = &self.message {
            write!(f, ": {}", inner_89)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidTagging {}
/// See [`InvalidTagging`](crate::error::InvalidTagging)
pub mod invalid_tagging {
    /// A builder for [`InvalidTagging`](crate::error::InvalidTagging)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidTagging`](crate::error::InvalidTagging)
        pub fn build(self) -> crate::error::InvalidTagging {
            crate::error::InvalidTagging {
                message: self.message,
            }
        }
    }
}
impl InvalidTagging {
    /// Creates a new builder-style object to manufacture [`InvalidTagging`](crate::error::InvalidTagging)
    pub fn builder() -> crate::error::invalid_tagging::Builder {
        crate::error::invalid_tagging::Builder::default()
    }
}

/// <p>The CloudFront function failed.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TestFunctionFailed {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for TestFunctionFailed {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TestFunctionFailed");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl TestFunctionFailed {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for TestFunctionFailed {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "TestFunctionFailed")?;
        if let Some(inner_90) = &self.message {
            write!(f, ": {}", inner_90)?;
        }
        Ok(())
    }
}
impl std::error::Error for TestFunctionFailed {}
/// See [`TestFunctionFailed`](crate::error::TestFunctionFailed)
pub mod test_function_failed {
    /// A builder for [`TestFunctionFailed`](crate::error::TestFunctionFailed)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`TestFunctionFailed`](crate::error::TestFunctionFailed)
        pub fn build(self) -> crate::error::TestFunctionFailed {
            crate::error::TestFunctionFailed {
                message: self.message,
            }
        }
    }
}
impl TestFunctionFailed {
    /// Creates a new builder-style object to manufacture [`TestFunctionFailed`](crate::error::TestFunctionFailed)
    pub fn builder() -> crate::error::test_function_failed::Builder {
        crate::error::test_function_failed::Builder::default()
    }
}

/// <p>The specified invalidation does not exist.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct NoSuchInvalidation {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for NoSuchInvalidation {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("NoSuchInvalidation");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl NoSuchInvalidation {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for NoSuchInvalidation {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "NoSuchInvalidation")?;
        if let Some(inner_91) = &self.message {
            write!(f, ": {}", inner_91)?;
        }
        Ok(())
    }
}
impl std::error::Error for NoSuchInvalidation {}
/// See [`NoSuchInvalidation`](crate::error::NoSuchInvalidation)
pub mod no_such_invalidation {
    /// A builder for [`NoSuchInvalidation`](crate::error::NoSuchInvalidation)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`NoSuchInvalidation`](crate::error::NoSuchInvalidation)
        pub fn build(self) -> crate::error::NoSuchInvalidation {
            crate::error::NoSuchInvalidation {
                message: self.message,
            }
        }
    }
}
impl NoSuchInvalidation {
    /// Creates a new builder-style object to manufacture [`NoSuchInvalidation`](crate::error::NoSuchInvalidation)
    pub fn builder() -> crate::error::no_such_invalidation::Builder {
        crate::error::no_such_invalidation::Builder::default()
    }
}

/// <p>The specified CloudFront distribution is not disabled. You must disable the distribution before you can delete it.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StreamingDistributionNotDisabled {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for StreamingDistributionNotDisabled {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StreamingDistributionNotDisabled");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl StreamingDistributionNotDisabled {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for StreamingDistributionNotDisabled {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "StreamingDistributionNotDisabled")?;
        if let Some(inner_92) = &self.message {
            write!(f, ": {}", inner_92)?;
        }
        Ok(())
    }
}
impl std::error::Error for StreamingDistributionNotDisabled {}
/// See [`StreamingDistributionNotDisabled`](crate::error::StreamingDistributionNotDisabled)
pub mod streaming_distribution_not_disabled {
    /// A builder for [`StreamingDistributionNotDisabled`](crate::error::StreamingDistributionNotDisabled)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`StreamingDistributionNotDisabled`](crate::error::StreamingDistributionNotDisabled)
        pub fn build(self) -> crate::error::StreamingDistributionNotDisabled {
            crate::error::StreamingDistributionNotDisabled {
                message: self.message,
            }
        }
    }
}
impl StreamingDistributionNotDisabled {
    /// Creates a new builder-style object to manufacture [`StreamingDistributionNotDisabled`](crate::error::StreamingDistributionNotDisabled)
    pub fn builder() -> crate::error::streaming_distribution_not_disabled::Builder {
        crate::error::streaming_distribution_not_disabled::Builder::default()
    }
}

/// <p>Cannot delete the response headers policy because it is attached to one or more cache behaviors in a CloudFront distribution. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResponseHeadersPolicyInUse {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ResponseHeadersPolicyInUse {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResponseHeadersPolicyInUse");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ResponseHeadersPolicyInUse {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ResponseHeadersPolicyInUse {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ResponseHeadersPolicyInUse")?;
        if let Some(inner_93) = &self.message {
            write!(f, ": {}", inner_93)?;
        }
        Ok(())
    }
}
impl std::error::Error for ResponseHeadersPolicyInUse {}
/// See [`ResponseHeadersPolicyInUse`](crate::error::ResponseHeadersPolicyInUse)
pub mod response_headers_policy_in_use {
    /// A builder for [`ResponseHeadersPolicyInUse`](crate::error::ResponseHeadersPolicyInUse)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ResponseHeadersPolicyInUse`](crate::error::ResponseHeadersPolicyInUse)
        pub fn build(self) -> crate::error::ResponseHeadersPolicyInUse {
            crate::error::ResponseHeadersPolicyInUse {
                message: self.message,
            }
        }
    }
}
impl ResponseHeadersPolicyInUse {
    /// Creates a new builder-style object to manufacture [`ResponseHeadersPolicyInUse`](crate::error::ResponseHeadersPolicyInUse)
    pub fn builder() -> crate::error::response_headers_policy_in_use::Builder {
        crate::error::response_headers_policy_in_use::Builder::default()
    }
}

/// <p>You cannot delete a managed policy.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct IllegalDelete {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for IllegalDelete {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("IllegalDelete");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl IllegalDelete {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for IllegalDelete {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "IllegalDelete")?;
        if let Some(inner_94) = &self.message {
            write!(f, ": {}", inner_94)?;
        }
        Ok(())
    }
}
impl std::error::Error for IllegalDelete {}
/// See [`IllegalDelete`](crate::error::IllegalDelete)
pub mod illegal_delete {
    /// A builder for [`IllegalDelete`](crate::error::IllegalDelete)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`IllegalDelete`](crate::error::IllegalDelete)
        pub fn build(self) -> crate::error::IllegalDelete {
            crate::error::IllegalDelete {
                message: self.message,
            }
        }
    }
}
impl IllegalDelete {
    /// Creates a new builder-style object to manufacture [`IllegalDelete`](crate::error::IllegalDelete)
    pub fn builder() -> crate::error::illegal_delete::Builder {
        crate::error::illegal_delete::Builder::default()
    }
}

/// <p>Cannot delete the real-time log configuration because it is attached to one or more cache behaviors.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RealtimeLogConfigInUse {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for RealtimeLogConfigInUse {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RealtimeLogConfigInUse");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl RealtimeLogConfigInUse {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for RealtimeLogConfigInUse {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "RealtimeLogConfigInUse")?;
        if let Some(inner_95) = &self.message {
            write!(f, ": {}", inner_95)?;
        }
        Ok(())
    }
}
impl std::error::Error for RealtimeLogConfigInUse {}
/// See [`RealtimeLogConfigInUse`](crate::error::RealtimeLogConfigInUse)
pub mod realtime_log_config_in_use {
    /// A builder for [`RealtimeLogConfigInUse`](crate::error::RealtimeLogConfigInUse)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`RealtimeLogConfigInUse`](crate::error::RealtimeLogConfigInUse)
        pub fn build(self) -> crate::error::RealtimeLogConfigInUse {
            crate::error::RealtimeLogConfigInUse {
                message: self.message,
            }
        }
    }
}
impl RealtimeLogConfigInUse {
    /// Creates a new builder-style object to manufacture [`RealtimeLogConfigInUse`](crate::error::RealtimeLogConfigInUse)
    pub fn builder() -> crate::error::realtime_log_config_in_use::Builder {
        crate::error::realtime_log_config_in_use::Builder::default()
    }
}

/// <p>The specified public key is in use. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PublicKeyInUse {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for PublicKeyInUse {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PublicKeyInUse");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl PublicKeyInUse {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for PublicKeyInUse {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "PublicKeyInUse")?;
        if let Some(inner_96) = &self.message {
            write!(f, ": {}", inner_96)?;
        }
        Ok(())
    }
}
impl std::error::Error for PublicKeyInUse {}
/// See [`PublicKeyInUse`](crate::error::PublicKeyInUse)
pub mod public_key_in_use {
    /// A builder for [`PublicKeyInUse`](crate::error::PublicKeyInUse)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`PublicKeyInUse`](crate::error::PublicKeyInUse)
        pub fn build(self) -> crate::error::PublicKeyInUse {
            crate::error::PublicKeyInUse {
                message: self.message,
            }
        }
    }
}
impl PublicKeyInUse {
    /// Creates a new builder-style object to manufacture [`PublicKeyInUse`](crate::error::PublicKeyInUse)
    pub fn builder() -> crate::error::public_key_in_use::Builder {
        crate::error::public_key_in_use::Builder::default()
    }
}

/// <p>Cannot delete the origin request policy because it is attached to one or more cache behaviors.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct OriginRequestPolicyInUse {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for OriginRequestPolicyInUse {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("OriginRequestPolicyInUse");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl OriginRequestPolicyInUse {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for OriginRequestPolicyInUse {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "OriginRequestPolicyInUse")?;
        if let Some(inner_97) = &self.message {
            write!(f, ": {}", inner_97)?;
        }
        Ok(())
    }
}
impl std::error::Error for OriginRequestPolicyInUse {}
/// See [`OriginRequestPolicyInUse`](crate::error::OriginRequestPolicyInUse)
pub mod origin_request_policy_in_use {
    /// A builder for [`OriginRequestPolicyInUse`](crate::error::OriginRequestPolicyInUse)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`OriginRequestPolicyInUse`](crate::error::OriginRequestPolicyInUse)
        pub fn build(self) -> crate::error::OriginRequestPolicyInUse {
            crate::error::OriginRequestPolicyInUse {
                message: self.message,
            }
        }
    }
}
impl OriginRequestPolicyInUse {
    /// Creates a new builder-style object to manufacture [`OriginRequestPolicyInUse`](crate::error::OriginRequestPolicyInUse)
    pub fn builder() -> crate::error::origin_request_policy_in_use::Builder {
        crate::error::origin_request_policy_in_use::Builder::default()
    }
}

/// <p>Cannot delete this resource because it is in use.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResourceInUse {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ResourceInUse {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResourceInUse");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ResourceInUse {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ResourceInUse {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ResourceInUse")?;
        if let Some(inner_98) = &self.message {
            write!(f, ": {}", inner_98)?;
        }
        Ok(())
    }
}
impl std::error::Error for ResourceInUse {}
/// See [`ResourceInUse`](crate::error::ResourceInUse)
pub mod resource_in_use {
    /// A builder for [`ResourceInUse`](crate::error::ResourceInUse)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ResourceInUse`](crate::error::ResourceInUse)
        pub fn build(self) -> crate::error::ResourceInUse {
            crate::error::ResourceInUse {
                message: self.message,
            }
        }
    }
}
impl ResourceInUse {
    /// Creates a new builder-style object to manufacture [`ResourceInUse`](crate::error::ResourceInUse)
    pub fn builder() -> crate::error::resource_in_use::Builder {
        crate::error::resource_in_use::Builder::default()
    }
}

/// <p>Cannot delete the function because it’s attached to one or more cache behaviors.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct FunctionInUse {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for FunctionInUse {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("FunctionInUse");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl FunctionInUse {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for FunctionInUse {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "FunctionInUse")?;
        if let Some(inner_99) = &self.message {
            write!(f, ": {}", inner_99)?;
        }
        Ok(())
    }
}
impl std::error::Error for FunctionInUse {}
/// See [`FunctionInUse`](crate::error::FunctionInUse)
pub mod function_in_use {
    /// A builder for [`FunctionInUse`](crate::error::FunctionInUse)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`FunctionInUse`](crate::error::FunctionInUse)
        pub fn build(self) -> crate::error::FunctionInUse {
            crate::error::FunctionInUse {
                message: self.message,
            }
        }
    }
}
impl FunctionInUse {
    /// Creates a new builder-style object to manufacture [`FunctionInUse`](crate::error::FunctionInUse)
    pub fn builder() -> crate::error::function_in_use::Builder {
        crate::error::function_in_use::Builder::default()
    }
}

/// <p>The specified profile for field-level encryption is in use.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct FieldLevelEncryptionProfileInUse {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for FieldLevelEncryptionProfileInUse {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("FieldLevelEncryptionProfileInUse");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl FieldLevelEncryptionProfileInUse {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for FieldLevelEncryptionProfileInUse {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "FieldLevelEncryptionProfileInUse")?;
        if let Some(inner_100) = &self.message {
            write!(f, ": {}", inner_100)?;
        }
        Ok(())
    }
}
impl std::error::Error for FieldLevelEncryptionProfileInUse {}
/// See [`FieldLevelEncryptionProfileInUse`](crate::error::FieldLevelEncryptionProfileInUse)
pub mod field_level_encryption_profile_in_use {
    /// A builder for [`FieldLevelEncryptionProfileInUse`](crate::error::FieldLevelEncryptionProfileInUse)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`FieldLevelEncryptionProfileInUse`](crate::error::FieldLevelEncryptionProfileInUse)
        pub fn build(self) -> crate::error::FieldLevelEncryptionProfileInUse {
            crate::error::FieldLevelEncryptionProfileInUse {
                message: self.message,
            }
        }
    }
}
impl FieldLevelEncryptionProfileInUse {
    /// Creates a new builder-style object to manufacture [`FieldLevelEncryptionProfileInUse`](crate::error::FieldLevelEncryptionProfileInUse)
    pub fn builder() -> crate::error::field_level_encryption_profile_in_use::Builder {
        crate::error::field_level_encryption_profile_in_use::Builder::default()
    }
}

/// <p>The specified configuration for field-level encryption is in use.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct FieldLevelEncryptionConfigInUse {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for FieldLevelEncryptionConfigInUse {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("FieldLevelEncryptionConfigInUse");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl FieldLevelEncryptionConfigInUse {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for FieldLevelEncryptionConfigInUse {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "FieldLevelEncryptionConfigInUse")?;
        if let Some(inner_101) = &self.message {
            write!(f, ": {}", inner_101)?;
        }
        Ok(())
    }
}
impl std::error::Error for FieldLevelEncryptionConfigInUse {}
/// See [`FieldLevelEncryptionConfigInUse`](crate::error::FieldLevelEncryptionConfigInUse)
pub mod field_level_encryption_config_in_use {
    /// A builder for [`FieldLevelEncryptionConfigInUse`](crate::error::FieldLevelEncryptionConfigInUse)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`FieldLevelEncryptionConfigInUse`](crate::error::FieldLevelEncryptionConfigInUse)
        pub fn build(self) -> crate::error::FieldLevelEncryptionConfigInUse {
            crate::error::FieldLevelEncryptionConfigInUse {
                message: self.message,
            }
        }
    }
}
impl FieldLevelEncryptionConfigInUse {
    /// Creates a new builder-style object to manufacture [`FieldLevelEncryptionConfigInUse`](crate::error::FieldLevelEncryptionConfigInUse)
    pub fn builder() -> crate::error::field_level_encryption_config_in_use::Builder {
        crate::error::field_level_encryption_config_in_use::Builder::default()
    }
}

/// <p>The specified CloudFront distribution is not disabled. You must disable the distribution before you can delete it.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DistributionNotDisabled {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DistributionNotDisabled {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DistributionNotDisabled");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl DistributionNotDisabled {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for DistributionNotDisabled {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "DistributionNotDisabled")?;
        if let Some(inner_102) = &self.message {
            write!(f, ": {}", inner_102)?;
        }
        Ok(())
    }
}
impl std::error::Error for DistributionNotDisabled {}
/// See [`DistributionNotDisabled`](crate::error::DistributionNotDisabled)
pub mod distribution_not_disabled {
    /// A builder for [`DistributionNotDisabled`](crate::error::DistributionNotDisabled)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`DistributionNotDisabled`](crate::error::DistributionNotDisabled)
        pub fn build(self) -> crate::error::DistributionNotDisabled {
            crate::error::DistributionNotDisabled {
                message: self.message,
            }
        }
    }
}
impl DistributionNotDisabled {
    /// Creates a new builder-style object to manufacture [`DistributionNotDisabled`](crate::error::DistributionNotDisabled)
    pub fn builder() -> crate::error::distribution_not_disabled::Builder {
        crate::error::distribution_not_disabled::Builder::default()
    }
}

/// <p>The Origin Access Identity specified is already in use.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CloudFrontOriginAccessIdentityInUse {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for CloudFrontOriginAccessIdentityInUse {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CloudFrontOriginAccessIdentityInUse");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl CloudFrontOriginAccessIdentityInUse {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for CloudFrontOriginAccessIdentityInUse {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "CloudFrontOriginAccessIdentityInUse")?;
        if let Some(inner_103) = &self.message {
            write!(f, ": {}", inner_103)?;
        }
        Ok(())
    }
}
impl std::error::Error for CloudFrontOriginAccessIdentityInUse {}
/// See [`CloudFrontOriginAccessIdentityInUse`](crate::error::CloudFrontOriginAccessIdentityInUse)
pub mod cloud_front_origin_access_identity_in_use {
    /// A builder for [`CloudFrontOriginAccessIdentityInUse`](crate::error::CloudFrontOriginAccessIdentityInUse)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`CloudFrontOriginAccessIdentityInUse`](crate::error::CloudFrontOriginAccessIdentityInUse)
        pub fn build(self) -> crate::error::CloudFrontOriginAccessIdentityInUse {
            crate::error::CloudFrontOriginAccessIdentityInUse {
                message: self.message,
            }
        }
    }
}
impl CloudFrontOriginAccessIdentityInUse {
    /// Creates a new builder-style object to manufacture [`CloudFrontOriginAccessIdentityInUse`](crate::error::CloudFrontOriginAccessIdentityInUse)
    pub fn builder() -> crate::error::cloud_front_origin_access_identity_in_use::Builder {
        crate::error::cloud_front_origin_access_identity_in_use::Builder::default()
    }
}

/// <p>Cannot delete the cache policy because it is attached to one or more cache behaviors.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CachePolicyInUse {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for CachePolicyInUse {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CachePolicyInUse");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl CachePolicyInUse {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for CachePolicyInUse {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "CachePolicyInUse")?;
        if let Some(inner_104) = &self.message {
            write!(f, ": {}", inner_104)?;
        }
        Ok(())
    }
}
impl std::error::Error for CachePolicyInUse {}
/// See [`CachePolicyInUse`](crate::error::CachePolicyInUse)
pub mod cache_policy_in_use {
    /// A builder for [`CachePolicyInUse`](crate::error::CachePolicyInUse)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`CachePolicyInUse`](crate::error::CachePolicyInUse)
        pub fn build(self) -> crate::error::CachePolicyInUse {
            crate::error::CachePolicyInUse {
                message: self.message,
            }
        }
    }
}
impl CachePolicyInUse {
    /// Creates a new builder-style object to manufacture [`CachePolicyInUse`](crate::error::CachePolicyInUse)
    pub fn builder() -> crate::error::cache_policy_in_use::Builder {
        crate::error::cache_policy_in_use::Builder::default()
    }
}

/// <p>Processing your request would cause you to exceed the maximum number of streaming distributions allowed.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TooManyStreamingDistributions {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for TooManyStreamingDistributions {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TooManyStreamingDistributions");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl TooManyStreamingDistributions {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for TooManyStreamingDistributions {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "TooManyStreamingDistributions")?;
        if let Some(inner_105) = &self.message {
            write!(f, ": {}", inner_105)?;
        }
        Ok(())
    }
}
impl std::error::Error for TooManyStreamingDistributions {}
/// See [`TooManyStreamingDistributions`](crate::error::TooManyStreamingDistributions)
pub mod too_many_streaming_distributions {
    /// A builder for [`TooManyStreamingDistributions`](crate::error::TooManyStreamingDistributions)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`TooManyStreamingDistributions`](crate::error::TooManyStreamingDistributions)
        pub fn build(self) -> crate::error::TooManyStreamingDistributions {
            crate::error::TooManyStreamingDistributions {
                message: self.message,
            }
        }
    }
}
impl TooManyStreamingDistributions {
    /// Creates a new builder-style object to manufacture [`TooManyStreamingDistributions`](crate::error::TooManyStreamingDistributions)
    pub fn builder() -> crate::error::too_many_streaming_distributions::Builder {
        crate::error::too_many_streaming_distributions::Builder::default()
    }
}

/// <p>The caller reference you attempted to create the streaming distribution with is associated with another distribution</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StreamingDistributionAlreadyExists {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for StreamingDistributionAlreadyExists {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StreamingDistributionAlreadyExists");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl StreamingDistributionAlreadyExists {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for StreamingDistributionAlreadyExists {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "StreamingDistributionAlreadyExists")?;
        if let Some(inner_106) = &self.message {
            write!(f, ": {}", inner_106)?;
        }
        Ok(())
    }
}
impl std::error::Error for StreamingDistributionAlreadyExists {}
/// See [`StreamingDistributionAlreadyExists`](crate::error::StreamingDistributionAlreadyExists)
pub mod streaming_distribution_already_exists {
    /// A builder for [`StreamingDistributionAlreadyExists`](crate::error::StreamingDistributionAlreadyExists)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`StreamingDistributionAlreadyExists`](crate::error::StreamingDistributionAlreadyExists)
        pub fn build(self) -> crate::error::StreamingDistributionAlreadyExists {
            crate::error::StreamingDistributionAlreadyExists {
                message: self.message,
            }
        }
    }
}
impl StreamingDistributionAlreadyExists {
    /// Creates a new builder-style object to manufacture [`StreamingDistributionAlreadyExists`](crate::error::StreamingDistributionAlreadyExists)
    pub fn builder() -> crate::error::streaming_distribution_already_exists::Builder {
        crate::error::streaming_distribution_already_exists::Builder::default()
    }
}

/// <p>The Amazon S3 origin server specified does not refer to a valid Amazon S3 bucket.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidOrigin {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidOrigin {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidOrigin");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidOrigin {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidOrigin {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidOrigin")?;
        if let Some(inner_107) = &self.message {
            write!(f, ": {}", inner_107)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidOrigin {}
/// See [`InvalidOrigin`](crate::error::InvalidOrigin)
pub mod invalid_origin {
    /// A builder for [`InvalidOrigin`](crate::error::InvalidOrigin)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidOrigin`](crate::error::InvalidOrigin)
        pub fn build(self) -> crate::error::InvalidOrigin {
            crate::error::InvalidOrigin {
                message: self.message,
            }
        }
    }
}
impl InvalidOrigin {
    /// Creates a new builder-style object to manufacture [`InvalidOrigin`](crate::error::InvalidOrigin)
    pub fn builder() -> crate::error::invalid_origin::Builder {
        crate::error::invalid_origin::Builder::default()
    }
}

/// <p>You have reached the maximum number of response headers policies for this Amazon Web Services account.</p>
/// <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html">Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TooManyResponseHeadersPolicies {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for TooManyResponseHeadersPolicies {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TooManyResponseHeadersPolicies");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl TooManyResponseHeadersPolicies {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for TooManyResponseHeadersPolicies {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "TooManyResponseHeadersPolicies")?;
        if let Some(inner_108) = &self.message {
            write!(f, ": {}", inner_108)?;
        }
        Ok(())
    }
}
impl std::error::Error for TooManyResponseHeadersPolicies {}
/// See [`TooManyResponseHeadersPolicies`](crate::error::TooManyResponseHeadersPolicies)
pub mod too_many_response_headers_policies {
    /// A builder for [`TooManyResponseHeadersPolicies`](crate::error::TooManyResponseHeadersPolicies)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`TooManyResponseHeadersPolicies`](crate::error::TooManyResponseHeadersPolicies)
        pub fn build(self) -> crate::error::TooManyResponseHeadersPolicies {
            crate::error::TooManyResponseHeadersPolicies {
                message: self.message,
            }
        }
    }
}
impl TooManyResponseHeadersPolicies {
    /// Creates a new builder-style object to manufacture [`TooManyResponseHeadersPolicies`](crate::error::TooManyResponseHeadersPolicies)
    pub fn builder() -> crate::error::too_many_response_headers_policies::Builder {
        crate::error::too_many_response_headers_policies::Builder::default()
    }
}

/// <p>You have reached the maximum number of real-time log configurations for this Amazon Web Services account. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html">Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TooManyRealtimeLogConfigs {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for TooManyRealtimeLogConfigs {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TooManyRealtimeLogConfigs");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl TooManyRealtimeLogConfigs {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for TooManyRealtimeLogConfigs {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "TooManyRealtimeLogConfigs")?;
        if let Some(inner_109) = &self.message {
            write!(f, ": {}", inner_109)?;
        }
        Ok(())
    }
}
impl std::error::Error for TooManyRealtimeLogConfigs {}
/// See [`TooManyRealtimeLogConfigs`](crate::error::TooManyRealtimeLogConfigs)
pub mod too_many_realtime_log_configs {
    /// A builder for [`TooManyRealtimeLogConfigs`](crate::error::TooManyRealtimeLogConfigs)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`TooManyRealtimeLogConfigs`](crate::error::TooManyRealtimeLogConfigs)
        pub fn build(self) -> crate::error::TooManyRealtimeLogConfigs {
            crate::error::TooManyRealtimeLogConfigs {
                message: self.message,
            }
        }
    }
}
impl TooManyRealtimeLogConfigs {
    /// Creates a new builder-style object to manufacture [`TooManyRealtimeLogConfigs`](crate::error::TooManyRealtimeLogConfigs)
    pub fn builder() -> crate::error::too_many_realtime_log_configs::Builder {
        crate::error::too_many_realtime_log_configs::Builder::default()
    }
}

/// <p>A real-time log configuration with this name already exists. You must provide a unique name. To modify an existing real-time log configuration, use <code>UpdateRealtimeLogConfig</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RealtimeLogConfigAlreadyExists {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for RealtimeLogConfigAlreadyExists {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RealtimeLogConfigAlreadyExists");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl RealtimeLogConfigAlreadyExists {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for RealtimeLogConfigAlreadyExists {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "RealtimeLogConfigAlreadyExists")?;
        if let Some(inner_110) = &self.message {
            write!(f, ": {}", inner_110)?;
        }
        Ok(())
    }
}
impl std::error::Error for RealtimeLogConfigAlreadyExists {}
/// See [`RealtimeLogConfigAlreadyExists`](crate::error::RealtimeLogConfigAlreadyExists)
pub mod realtime_log_config_already_exists {
    /// A builder for [`RealtimeLogConfigAlreadyExists`](crate::error::RealtimeLogConfigAlreadyExists)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`RealtimeLogConfigAlreadyExists`](crate::error::RealtimeLogConfigAlreadyExists)
        pub fn build(self) -> crate::error::RealtimeLogConfigAlreadyExists {
            crate::error::RealtimeLogConfigAlreadyExists {
                message: self.message,
            }
        }
    }
}
impl RealtimeLogConfigAlreadyExists {
    /// Creates a new builder-style object to manufacture [`RealtimeLogConfigAlreadyExists`](crate::error::RealtimeLogConfigAlreadyExists)
    pub fn builder() -> crate::error::realtime_log_config_already_exists::Builder {
        crate::error::realtime_log_config_already_exists::Builder::default()
    }
}

/// <p>The maximum number of public keys for field-level encryption have been created. To create a new public key, delete one of the existing keys.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TooManyPublicKeys {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for TooManyPublicKeys {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TooManyPublicKeys");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl TooManyPublicKeys {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for TooManyPublicKeys {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "TooManyPublicKeys")?;
        if let Some(inner_111) = &self.message {
            write!(f, ": {}", inner_111)?;
        }
        Ok(())
    }
}
impl std::error::Error for TooManyPublicKeys {}
/// See [`TooManyPublicKeys`](crate::error::TooManyPublicKeys)
pub mod too_many_public_keys {
    /// A builder for [`TooManyPublicKeys`](crate::error::TooManyPublicKeys)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`TooManyPublicKeys`](crate::error::TooManyPublicKeys)
        pub fn build(self) -> crate::error::TooManyPublicKeys {
            crate::error::TooManyPublicKeys {
                message: self.message,
            }
        }
    }
}
impl TooManyPublicKeys {
    /// Creates a new builder-style object to manufacture [`TooManyPublicKeys`](crate::error::TooManyPublicKeys)
    pub fn builder() -> crate::error::too_many_public_keys::Builder {
        crate::error::too_many_public_keys::Builder::default()
    }
}

/// <p>The specified public key already exists.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PublicKeyAlreadyExists {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for PublicKeyAlreadyExists {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PublicKeyAlreadyExists");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl PublicKeyAlreadyExists {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for PublicKeyAlreadyExists {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "PublicKeyAlreadyExists")?;
        if let Some(inner_112) = &self.message {
            write!(f, ": {}", inner_112)?;
        }
        Ok(())
    }
}
impl std::error::Error for PublicKeyAlreadyExists {}
/// See [`PublicKeyAlreadyExists`](crate::error::PublicKeyAlreadyExists)
pub mod public_key_already_exists {
    /// A builder for [`PublicKeyAlreadyExists`](crate::error::PublicKeyAlreadyExists)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`PublicKeyAlreadyExists`](crate::error::PublicKeyAlreadyExists)
        pub fn build(self) -> crate::error::PublicKeyAlreadyExists {
            crate::error::PublicKeyAlreadyExists {
                message: self.message,
            }
        }
    }
}
impl PublicKeyAlreadyExists {
    /// Creates a new builder-style object to manufacture [`PublicKeyAlreadyExists`](crate::error::PublicKeyAlreadyExists)
    pub fn builder() -> crate::error::public_key_already_exists::Builder {
        crate::error::public_key_already_exists::Builder::default()
    }
}

/// <p>You have reached the maximum number of origin request policies for this Amazon Web Services account. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html">Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TooManyOriginRequestPolicies {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for TooManyOriginRequestPolicies {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TooManyOriginRequestPolicies");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl TooManyOriginRequestPolicies {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for TooManyOriginRequestPolicies {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "TooManyOriginRequestPolicies")?;
        if let Some(inner_113) = &self.message {
            write!(f, ": {}", inner_113)?;
        }
        Ok(())
    }
}
impl std::error::Error for TooManyOriginRequestPolicies {}
/// See [`TooManyOriginRequestPolicies`](crate::error::TooManyOriginRequestPolicies)
pub mod too_many_origin_request_policies {
    /// A builder for [`TooManyOriginRequestPolicies`](crate::error::TooManyOriginRequestPolicies)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`TooManyOriginRequestPolicies`](crate::error::TooManyOriginRequestPolicies)
        pub fn build(self) -> crate::error::TooManyOriginRequestPolicies {
            crate::error::TooManyOriginRequestPolicies {
                message: self.message,
            }
        }
    }
}
impl TooManyOriginRequestPolicies {
    /// Creates a new builder-style object to manufacture [`TooManyOriginRequestPolicies`](crate::error::TooManyOriginRequestPolicies)
    pub fn builder() -> crate::error::too_many_origin_request_policies::Builder {
        crate::error::too_many_origin_request_policies::Builder::default()
    }
}

/// <p>You have reached the maximum number of key groups for this Amazon Web Services account. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html">Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TooManyKeyGroups {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for TooManyKeyGroups {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TooManyKeyGroups");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl TooManyKeyGroups {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for TooManyKeyGroups {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "TooManyKeyGroups")?;
        if let Some(inner_114) = &self.message {
            write!(f, ": {}", inner_114)?;
        }
        Ok(())
    }
}
impl std::error::Error for TooManyKeyGroups {}
/// See [`TooManyKeyGroups`](crate::error::TooManyKeyGroups)
pub mod too_many_key_groups {
    /// A builder for [`TooManyKeyGroups`](crate::error::TooManyKeyGroups)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`TooManyKeyGroups`](crate::error::TooManyKeyGroups)
        pub fn build(self) -> crate::error::TooManyKeyGroups {
            crate::error::TooManyKeyGroups {
                message: self.message,
            }
        }
    }
}
impl TooManyKeyGroups {
    /// Creates a new builder-style object to manufacture [`TooManyKeyGroups`](crate::error::TooManyKeyGroups)
    pub fn builder() -> crate::error::too_many_key_groups::Builder {
        crate::error::too_many_key_groups::Builder::default()
    }
}

/// <p>You have exceeded the maximum number of allowable InProgress invalidation batch requests, or invalidation objects.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TooManyInvalidationsInProgress {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for TooManyInvalidationsInProgress {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TooManyInvalidationsInProgress");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl TooManyInvalidationsInProgress {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for TooManyInvalidationsInProgress {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "TooManyInvalidationsInProgress")?;
        if let Some(inner_115) = &self.message {
            write!(f, ": {}", inner_115)?;
        }
        Ok(())
    }
}
impl std::error::Error for TooManyInvalidationsInProgress {}
/// See [`TooManyInvalidationsInProgress`](crate::error::TooManyInvalidationsInProgress)
pub mod too_many_invalidations_in_progress {
    /// A builder for [`TooManyInvalidationsInProgress`](crate::error::TooManyInvalidationsInProgress)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`TooManyInvalidationsInProgress`](crate::error::TooManyInvalidationsInProgress)
        pub fn build(self) -> crate::error::TooManyInvalidationsInProgress {
            crate::error::TooManyInvalidationsInProgress {
                message: self.message,
            }
        }
    }
}
impl TooManyInvalidationsInProgress {
    /// Creates a new builder-style object to manufacture [`TooManyInvalidationsInProgress`](crate::error::TooManyInvalidationsInProgress)
    pub fn builder() -> crate::error::too_many_invalidations_in_progress::Builder {
        crate::error::too_many_invalidations_in_progress::Builder::default()
    }
}

/// <p>Invalidation batch specified is too large.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchTooLarge {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for BatchTooLarge {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchTooLarge");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl BatchTooLarge {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for BatchTooLarge {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "BatchTooLarge")?;
        if let Some(inner_116) = &self.message {
            write!(f, ": {}", inner_116)?;
        }
        Ok(())
    }
}
impl std::error::Error for BatchTooLarge {}
/// See [`BatchTooLarge`](crate::error::BatchTooLarge)
pub mod batch_too_large {
    /// A builder for [`BatchTooLarge`](crate::error::BatchTooLarge)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchTooLarge`](crate::error::BatchTooLarge)
        pub fn build(self) -> crate::error::BatchTooLarge {
            crate::error::BatchTooLarge {
                message: self.message,
            }
        }
    }
}
impl BatchTooLarge {
    /// Creates a new builder-style object to manufacture [`BatchTooLarge`](crate::error::BatchTooLarge)
    pub fn builder() -> crate::error::batch_too_large::Builder {
        crate::error::batch_too_large::Builder::default()
    }
}

/// <p>You have reached the maximum number of CloudFront functions for this Amazon Web Services account. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html">Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TooManyFunctions {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for TooManyFunctions {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TooManyFunctions");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl TooManyFunctions {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for TooManyFunctions {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "TooManyFunctions")?;
        if let Some(inner_117) = &self.message {
            write!(f, ": {}", inner_117)?;
        }
        Ok(())
    }
}
impl std::error::Error for TooManyFunctions {}
/// See [`TooManyFunctions`](crate::error::TooManyFunctions)
pub mod too_many_functions {
    /// A builder for [`TooManyFunctions`](crate::error::TooManyFunctions)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`TooManyFunctions`](crate::error::TooManyFunctions)
        pub fn build(self) -> crate::error::TooManyFunctions {
            crate::error::TooManyFunctions {
                message: self.message,
            }
        }
    }
}
impl TooManyFunctions {
    /// Creates a new builder-style object to manufacture [`TooManyFunctions`](crate::error::TooManyFunctions)
    pub fn builder() -> crate::error::too_many_functions::Builder {
        crate::error::too_many_functions::Builder::default()
    }
}

/// <p>A function with the same name already exists in this Amazon Web Services account. To create a function, you must provide a unique name. To update an existing function, use <code>UpdateFunction</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct FunctionAlreadyExists {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for FunctionAlreadyExists {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("FunctionAlreadyExists");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl FunctionAlreadyExists {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for FunctionAlreadyExists {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "FunctionAlreadyExists")?;
        if let Some(inner_118) = &self.message {
            write!(f, ": {}", inner_118)?;
        }
        Ok(())
    }
}
impl std::error::Error for FunctionAlreadyExists {}
/// See [`FunctionAlreadyExists`](crate::error::FunctionAlreadyExists)
pub mod function_already_exists {
    /// A builder for [`FunctionAlreadyExists`](crate::error::FunctionAlreadyExists)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`FunctionAlreadyExists`](crate::error::FunctionAlreadyExists)
        pub fn build(self) -> crate::error::FunctionAlreadyExists {
            crate::error::FunctionAlreadyExists {
                message: self.message,
            }
        }
    }
}
impl FunctionAlreadyExists {
    /// Creates a new builder-style object to manufacture [`FunctionAlreadyExists`](crate::error::FunctionAlreadyExists)
    pub fn builder() -> crate::error::function_already_exists::Builder {
        crate::error::function_already_exists::Builder::default()
    }
}

/// <p>The maximum number of profiles for field-level encryption have been created.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TooManyFieldLevelEncryptionProfiles {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for TooManyFieldLevelEncryptionProfiles {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TooManyFieldLevelEncryptionProfiles");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl TooManyFieldLevelEncryptionProfiles {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for TooManyFieldLevelEncryptionProfiles {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "TooManyFieldLevelEncryptionProfiles")?;
        if let Some(inner_119) = &self.message {
            write!(f, ": {}", inner_119)?;
        }
        Ok(())
    }
}
impl std::error::Error for TooManyFieldLevelEncryptionProfiles {}
/// See [`TooManyFieldLevelEncryptionProfiles`](crate::error::TooManyFieldLevelEncryptionProfiles)
pub mod too_many_field_level_encryption_profiles {
    /// A builder for [`TooManyFieldLevelEncryptionProfiles`](crate::error::TooManyFieldLevelEncryptionProfiles)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`TooManyFieldLevelEncryptionProfiles`](crate::error::TooManyFieldLevelEncryptionProfiles)
        pub fn build(self) -> crate::error::TooManyFieldLevelEncryptionProfiles {
            crate::error::TooManyFieldLevelEncryptionProfiles {
                message: self.message,
            }
        }
    }
}
impl TooManyFieldLevelEncryptionProfiles {
    /// Creates a new builder-style object to manufacture [`TooManyFieldLevelEncryptionProfiles`](crate::error::TooManyFieldLevelEncryptionProfiles)
    pub fn builder() -> crate::error::too_many_field_level_encryption_profiles::Builder {
        crate::error::too_many_field_level_encryption_profiles::Builder::default()
    }
}

/// <p>The maximum number of configurations for field-level encryption have been created.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TooManyFieldLevelEncryptionConfigs {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for TooManyFieldLevelEncryptionConfigs {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TooManyFieldLevelEncryptionConfigs");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl TooManyFieldLevelEncryptionConfigs {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for TooManyFieldLevelEncryptionConfigs {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "TooManyFieldLevelEncryptionConfigs")?;
        if let Some(inner_120) = &self.message {
            write!(f, ": {}", inner_120)?;
        }
        Ok(())
    }
}
impl std::error::Error for TooManyFieldLevelEncryptionConfigs {}
/// See [`TooManyFieldLevelEncryptionConfigs`](crate::error::TooManyFieldLevelEncryptionConfigs)
pub mod too_many_field_level_encryption_configs {
    /// A builder for [`TooManyFieldLevelEncryptionConfigs`](crate::error::TooManyFieldLevelEncryptionConfigs)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`TooManyFieldLevelEncryptionConfigs`](crate::error::TooManyFieldLevelEncryptionConfigs)
        pub fn build(self) -> crate::error::TooManyFieldLevelEncryptionConfigs {
            crate::error::TooManyFieldLevelEncryptionConfigs {
                message: self.message,
            }
        }
    }
}
impl TooManyFieldLevelEncryptionConfigs {
    /// Creates a new builder-style object to manufacture [`TooManyFieldLevelEncryptionConfigs`](crate::error::TooManyFieldLevelEncryptionConfigs)
    pub fn builder() -> crate::error::too_many_field_level_encryption_configs::Builder {
        crate::error::too_many_field_level_encryption_configs::Builder::default()
    }
}

/// <p>The specified configuration for field-level encryption already exists.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct FieldLevelEncryptionConfigAlreadyExists {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for FieldLevelEncryptionConfigAlreadyExists {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("FieldLevelEncryptionConfigAlreadyExists");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl FieldLevelEncryptionConfigAlreadyExists {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for FieldLevelEncryptionConfigAlreadyExists {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "FieldLevelEncryptionConfigAlreadyExists")?;
        if let Some(inner_121) = &self.message {
            write!(f, ": {}", inner_121)?;
        }
        Ok(())
    }
}
impl std::error::Error for FieldLevelEncryptionConfigAlreadyExists {}
/// See [`FieldLevelEncryptionConfigAlreadyExists`](crate::error::FieldLevelEncryptionConfigAlreadyExists)
pub mod field_level_encryption_config_already_exists {
    /// A builder for [`FieldLevelEncryptionConfigAlreadyExists`](crate::error::FieldLevelEncryptionConfigAlreadyExists)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`FieldLevelEncryptionConfigAlreadyExists`](crate::error::FieldLevelEncryptionConfigAlreadyExists)
        pub fn build(self) -> crate::error::FieldLevelEncryptionConfigAlreadyExists {
            crate::error::FieldLevelEncryptionConfigAlreadyExists {
                message: self.message,
            }
        }
    }
}
impl FieldLevelEncryptionConfigAlreadyExists {
    /// Creates a new builder-style object to manufacture [`FieldLevelEncryptionConfigAlreadyExists`](crate::error::FieldLevelEncryptionConfigAlreadyExists)
    pub fn builder() -> crate::error::field_level_encryption_config_already_exists::Builder {
        crate::error::field_level_encryption_config_already_exists::Builder::default()
    }
}

/// <p>Processing your request would cause you to exceed the maximum number of distributions allowed.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TooManyDistributions {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for TooManyDistributions {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TooManyDistributions");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl TooManyDistributions {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for TooManyDistributions {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "TooManyDistributions")?;
        if let Some(inner_122) = &self.message {
            write!(f, ": {}", inner_122)?;
        }
        Ok(())
    }
}
impl std::error::Error for TooManyDistributions {}
/// See [`TooManyDistributions`](crate::error::TooManyDistributions)
pub mod too_many_distributions {
    /// A builder for [`TooManyDistributions`](crate::error::TooManyDistributions)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`TooManyDistributions`](crate::error::TooManyDistributions)
        pub fn build(self) -> crate::error::TooManyDistributions {
            crate::error::TooManyDistributions {
                message: self.message,
            }
        }
    }
}
impl TooManyDistributions {
    /// Creates a new builder-style object to manufacture [`TooManyDistributions`](crate::error::TooManyDistributions)
    pub fn builder() -> crate::error::too_many_distributions::Builder {
        crate::error::too_many_distributions::Builder::default()
    }
}

/// <p>You cannot specify SSLv3 as the minimum protocol version if you only want to support only clients that support Server Name Indication (SNI).</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidProtocolSettings {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidProtocolSettings {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidProtocolSettings");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidProtocolSettings {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidProtocolSettings {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidProtocolSettings")?;
        if let Some(inner_123) = &self.message {
            write!(f, ": {}", inner_123)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidProtocolSettings {}
/// See [`InvalidProtocolSettings`](crate::error::InvalidProtocolSettings)
pub mod invalid_protocol_settings {
    /// A builder for [`InvalidProtocolSettings`](crate::error::InvalidProtocolSettings)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidProtocolSettings`](crate::error::InvalidProtocolSettings)
        pub fn build(self) -> crate::error::InvalidProtocolSettings {
            crate::error::InvalidProtocolSettings {
                message: self.message,
            }
        }
    }
}
impl InvalidProtocolSettings {
    /// Creates a new builder-style object to manufacture [`InvalidProtocolSettings`](crate::error::InvalidProtocolSettings)
    pub fn builder() -> crate::error::invalid_protocol_settings::Builder {
        crate::error::invalid_protocol_settings::Builder::default()
    }
}

/// <p>The caller reference you attempted to create the distribution with is associated with another distribution.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DistributionAlreadyExists {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DistributionAlreadyExists {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DistributionAlreadyExists");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl DistributionAlreadyExists {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for DistributionAlreadyExists {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "DistributionAlreadyExists")?;
        if let Some(inner_124) = &self.message {
            write!(f, ": {}", inner_124)?;
        }
        Ok(())
    }
}
impl std::error::Error for DistributionAlreadyExists {}
/// See [`DistributionAlreadyExists`](crate::error::DistributionAlreadyExists)
pub mod distribution_already_exists {
    /// A builder for [`DistributionAlreadyExists`](crate::error::DistributionAlreadyExists)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`DistributionAlreadyExists`](crate::error::DistributionAlreadyExists)
        pub fn build(self) -> crate::error::DistributionAlreadyExists {
            crate::error::DistributionAlreadyExists {
                message: self.message,
            }
        }
    }
}
impl DistributionAlreadyExists {
    /// Creates a new builder-style object to manufacture [`DistributionAlreadyExists`](crate::error::DistributionAlreadyExists)
    pub fn builder() -> crate::error::distribution_already_exists::Builder {
        crate::error::distribution_already_exists::Builder::default()
    }
}

/// <p>Processing your request would cause you to exceed the maximum number of origin access identities allowed.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TooManyCloudFrontOriginAccessIdentities {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for TooManyCloudFrontOriginAccessIdentities {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TooManyCloudFrontOriginAccessIdentities");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl TooManyCloudFrontOriginAccessIdentities {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for TooManyCloudFrontOriginAccessIdentities {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "TooManyCloudFrontOriginAccessIdentities")?;
        if let Some(inner_125) = &self.message {
            write!(f, ": {}", inner_125)?;
        }
        Ok(())
    }
}
impl std::error::Error for TooManyCloudFrontOriginAccessIdentities {}
/// See [`TooManyCloudFrontOriginAccessIdentities`](crate::error::TooManyCloudFrontOriginAccessIdentities)
pub mod too_many_cloud_front_origin_access_identities {
    /// A builder for [`TooManyCloudFrontOriginAccessIdentities`](crate::error::TooManyCloudFrontOriginAccessIdentities)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`TooManyCloudFrontOriginAccessIdentities`](crate::error::TooManyCloudFrontOriginAccessIdentities)
        pub fn build(self) -> crate::error::TooManyCloudFrontOriginAccessIdentities {
            crate::error::TooManyCloudFrontOriginAccessIdentities {
                message: self.message,
            }
        }
    }
}
impl TooManyCloudFrontOriginAccessIdentities {
    /// Creates a new builder-style object to manufacture [`TooManyCloudFrontOriginAccessIdentities`](crate::error::TooManyCloudFrontOriginAccessIdentities)
    pub fn builder() -> crate::error::too_many_cloud_front_origin_access_identities::Builder {
        crate::error::too_many_cloud_front_origin_access_identities::Builder::default()
    }
}

/// <p>If the <code>CallerReference</code> is a value you already sent in a previous request to create an identity but the content of the <code>CloudFrontOriginAccessIdentityConfig</code> is different from the original request, CloudFront returns a <code>CloudFrontOriginAccessIdentityAlreadyExists</code> error. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CloudFrontOriginAccessIdentityAlreadyExists {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for CloudFrontOriginAccessIdentityAlreadyExists {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CloudFrontOriginAccessIdentityAlreadyExists");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl CloudFrontOriginAccessIdentityAlreadyExists {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for CloudFrontOriginAccessIdentityAlreadyExists {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "CloudFrontOriginAccessIdentityAlreadyExists")?;
        if let Some(inner_126) = &self.message {
            write!(f, ": {}", inner_126)?;
        }
        Ok(())
    }
}
impl std::error::Error for CloudFrontOriginAccessIdentityAlreadyExists {}
/// See [`CloudFrontOriginAccessIdentityAlreadyExists`](crate::error::CloudFrontOriginAccessIdentityAlreadyExists)
pub mod cloud_front_origin_access_identity_already_exists {
    /// A builder for [`CloudFrontOriginAccessIdentityAlreadyExists`](crate::error::CloudFrontOriginAccessIdentityAlreadyExists)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`CloudFrontOriginAccessIdentityAlreadyExists`](crate::error::CloudFrontOriginAccessIdentityAlreadyExists)
        pub fn build(self) -> crate::error::CloudFrontOriginAccessIdentityAlreadyExists {
            crate::error::CloudFrontOriginAccessIdentityAlreadyExists {
                message: self.message,
            }
        }
    }
}
impl CloudFrontOriginAccessIdentityAlreadyExists {
    /// Creates a new builder-style object to manufacture [`CloudFrontOriginAccessIdentityAlreadyExists`](crate::error::CloudFrontOriginAccessIdentityAlreadyExists)
    pub fn builder() -> crate::error::cloud_front_origin_access_identity_already_exists::Builder {
        crate::error::cloud_front_origin_access_identity_already_exists::Builder::default()
    }
}

/// <p>You have reached the maximum number of cache policies for this Amazon Web Services account. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html">Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TooManyCachePolicies {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for TooManyCachePolicies {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TooManyCachePolicies");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl TooManyCachePolicies {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for TooManyCachePolicies {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "TooManyCachePolicies")?;
        if let Some(inner_127) = &self.message {
            write!(f, ": {}", inner_127)?;
        }
        Ok(())
    }
}
impl std::error::Error for TooManyCachePolicies {}
/// See [`TooManyCachePolicies`](crate::error::TooManyCachePolicies)
pub mod too_many_cache_policies {
    /// A builder for [`TooManyCachePolicies`](crate::error::TooManyCachePolicies)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`TooManyCachePolicies`](crate::error::TooManyCachePolicies)
        pub fn build(self) -> crate::error::TooManyCachePolicies {
            crate::error::TooManyCachePolicies {
                message: self.message,
            }
        }
    }
}
impl TooManyCachePolicies {
    /// Creates a new builder-style object to manufacture [`TooManyCachePolicies`](crate::error::TooManyCachePolicies)
    pub fn builder() -> crate::error::too_many_cache_policies::Builder {
        crate::error::too_many_cache_policies::Builder::default()
    }
}
