// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle<
    C = aws_smithy_client::erase::DynConnector,
    M = crate::middleware::DefaultMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    client: aws_smithy_client::Client<C, M, R>,
    conf: crate::Config,
}

/// Client for Amazon CloudFront
///
/// Client for invoking operations on Amazon CloudFront. Each operation on Amazon CloudFront is a method on this
/// this struct. `.send()` MUST be invoked on the generated operations to dispatch the request to the service.
///
/// # Examples
/// **Constructing a client and invoking an operation**
/// ```rust,no_run
/// # async fn docs() {
///     // create a shared configuration. This can be used & shared between multiple service clients.
///     let shared_config = aws_config::load_from_env().await;
///     let client = aws_sdk_cloudfront::Client::new(&shared_config);
///     // invoke an operation
///     /* let rsp = client
///         .<operation_name>().
///         .<param>("some value")
///         .send().await; */
/// # }
/// ```
/// **Constructing a client with custom configuration**
/// ```rust,no_run
/// use aws_config::RetryConfig;
/// # async fn docs() {
///     let shared_config = aws_config::load_from_env().await;
///     let config = aws_sdk_cloudfront::config::Builder::from(&shared_config)
///         .retry_config(RetryConfig::disabled())
///         .build();
///     let client = aws_sdk_cloudfront::Client::from_conf(config);
/// # }
#[derive(std::fmt::Debug)]
pub struct Client<
    C = aws_smithy_client::erase::DynConnector,
    M = crate::middleware::DefaultMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    handle: std::sync::Arc<Handle<C, M, R>>,
}

impl<C, M, R> std::clone::Clone for Client<C, M, R> {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl<C, M, R> From<aws_smithy_client::Client<C, M, R>> for Client<C, M, R> {
    fn from(client: aws_smithy_client::Client<C, M, R>) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl<C, M, R> Client<C, M, R> {
    /// Creates a client with the given service configuration.
    pub fn with_config(client: aws_smithy_client::Client<C, M, R>, conf: crate::Config) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl<C, M, R> Client<C, M, R>
where
    C: aws_smithy_client::bounds::SmithyConnector,
    M: aws_smithy_client::bounds::SmithyMiddleware<C>,
    R: aws_smithy_client::retry::NewRequestPolicy,
{
    /// Constructs a fluent builder for the `AssociateAlias` operation.
    ///
    /// See [`AssociateAlias`](crate::client::fluent_builders::AssociateAlias) for more information about the
    /// operation and its arguments.
    pub fn associate_alias(&self) -> fluent_builders::AssociateAlias<C, M, R> {
        fluent_builders::AssociateAlias::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateCachePolicy` operation.
    ///
    /// See [`CreateCachePolicy`](crate::client::fluent_builders::CreateCachePolicy) for more information about the
    /// operation and its arguments.
    pub fn create_cache_policy(&self) -> fluent_builders::CreateCachePolicy<C, M, R> {
        fluent_builders::CreateCachePolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateCloudFrontOriginAccessIdentity` operation.
    ///
    /// See [`CreateCloudFrontOriginAccessIdentity`](crate::client::fluent_builders::CreateCloudFrontOriginAccessIdentity) for more information about the
    /// operation and its arguments.
    pub fn create_cloud_front_origin_access_identity(
        &self,
    ) -> fluent_builders::CreateCloudFrontOriginAccessIdentity<C, M, R> {
        fluent_builders::CreateCloudFrontOriginAccessIdentity::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateDistribution` operation.
    ///
    /// See [`CreateDistribution`](crate::client::fluent_builders::CreateDistribution) for more information about the
    /// operation and its arguments.
    pub fn create_distribution(&self) -> fluent_builders::CreateDistribution<C, M, R> {
        fluent_builders::CreateDistribution::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateDistributionWithTags` operation.
    ///
    /// See [`CreateDistributionWithTags`](crate::client::fluent_builders::CreateDistributionWithTags) for more information about the
    /// operation and its arguments.
    pub fn create_distribution_with_tags(
        &self,
    ) -> fluent_builders::CreateDistributionWithTags<C, M, R> {
        fluent_builders::CreateDistributionWithTags::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateFieldLevelEncryptionConfig` operation.
    ///
    /// See [`CreateFieldLevelEncryptionConfig`](crate::client::fluent_builders::CreateFieldLevelEncryptionConfig) for more information about the
    /// operation and its arguments.
    pub fn create_field_level_encryption_config(
        &self,
    ) -> fluent_builders::CreateFieldLevelEncryptionConfig<C, M, R> {
        fluent_builders::CreateFieldLevelEncryptionConfig::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateFieldLevelEncryptionProfile` operation.
    ///
    /// See [`CreateFieldLevelEncryptionProfile`](crate::client::fluent_builders::CreateFieldLevelEncryptionProfile) for more information about the
    /// operation and its arguments.
    pub fn create_field_level_encryption_profile(
        &self,
    ) -> fluent_builders::CreateFieldLevelEncryptionProfile<C, M, R> {
        fluent_builders::CreateFieldLevelEncryptionProfile::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateFunction` operation.
    ///
    /// See [`CreateFunction`](crate::client::fluent_builders::CreateFunction) for more information about the
    /// operation and its arguments.
    pub fn create_function(&self) -> fluent_builders::CreateFunction<C, M, R> {
        fluent_builders::CreateFunction::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateInvalidation` operation.
    ///
    /// See [`CreateInvalidation`](crate::client::fluent_builders::CreateInvalidation) for more information about the
    /// operation and its arguments.
    pub fn create_invalidation(&self) -> fluent_builders::CreateInvalidation<C, M, R> {
        fluent_builders::CreateInvalidation::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateKeyGroup` operation.
    ///
    /// See [`CreateKeyGroup`](crate::client::fluent_builders::CreateKeyGroup) for more information about the
    /// operation and its arguments.
    pub fn create_key_group(&self) -> fluent_builders::CreateKeyGroup<C, M, R> {
        fluent_builders::CreateKeyGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateMonitoringSubscription` operation.
    ///
    /// See [`CreateMonitoringSubscription`](crate::client::fluent_builders::CreateMonitoringSubscription) for more information about the
    /// operation and its arguments.
    pub fn create_monitoring_subscription(
        &self,
    ) -> fluent_builders::CreateMonitoringSubscription<C, M, R> {
        fluent_builders::CreateMonitoringSubscription::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateOriginRequestPolicy` operation.
    ///
    /// See [`CreateOriginRequestPolicy`](crate::client::fluent_builders::CreateOriginRequestPolicy) for more information about the
    /// operation and its arguments.
    pub fn create_origin_request_policy(
        &self,
    ) -> fluent_builders::CreateOriginRequestPolicy<C, M, R> {
        fluent_builders::CreateOriginRequestPolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreatePublicKey` operation.
    ///
    /// See [`CreatePublicKey`](crate::client::fluent_builders::CreatePublicKey) for more information about the
    /// operation and its arguments.
    pub fn create_public_key(&self) -> fluent_builders::CreatePublicKey<C, M, R> {
        fluent_builders::CreatePublicKey::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateRealtimeLogConfig` operation.
    ///
    /// See [`CreateRealtimeLogConfig`](crate::client::fluent_builders::CreateRealtimeLogConfig) for more information about the
    /// operation and its arguments.
    pub fn create_realtime_log_config(&self) -> fluent_builders::CreateRealtimeLogConfig<C, M, R> {
        fluent_builders::CreateRealtimeLogConfig::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateResponseHeadersPolicy` operation.
    ///
    /// See [`CreateResponseHeadersPolicy`](crate::client::fluent_builders::CreateResponseHeadersPolicy) for more information about the
    /// operation and its arguments.
    pub fn create_response_headers_policy(
        &self,
    ) -> fluent_builders::CreateResponseHeadersPolicy<C, M, R> {
        fluent_builders::CreateResponseHeadersPolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateStreamingDistribution` operation.
    ///
    /// See [`CreateStreamingDistribution`](crate::client::fluent_builders::CreateStreamingDistribution) for more information about the
    /// operation and its arguments.
    pub fn create_streaming_distribution(
        &self,
    ) -> fluent_builders::CreateStreamingDistribution<C, M, R> {
        fluent_builders::CreateStreamingDistribution::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateStreamingDistributionWithTags` operation.
    ///
    /// See [`CreateStreamingDistributionWithTags`](crate::client::fluent_builders::CreateStreamingDistributionWithTags) for more information about the
    /// operation and its arguments.
    pub fn create_streaming_distribution_with_tags(
        &self,
    ) -> fluent_builders::CreateStreamingDistributionWithTags<C, M, R> {
        fluent_builders::CreateStreamingDistributionWithTags::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteCachePolicy` operation.
    ///
    /// See [`DeleteCachePolicy`](crate::client::fluent_builders::DeleteCachePolicy) for more information about the
    /// operation and its arguments.
    pub fn delete_cache_policy(&self) -> fluent_builders::DeleteCachePolicy<C, M, R> {
        fluent_builders::DeleteCachePolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteCloudFrontOriginAccessIdentity` operation.
    ///
    /// See [`DeleteCloudFrontOriginAccessIdentity`](crate::client::fluent_builders::DeleteCloudFrontOriginAccessIdentity) for more information about the
    /// operation and its arguments.
    pub fn delete_cloud_front_origin_access_identity(
        &self,
    ) -> fluent_builders::DeleteCloudFrontOriginAccessIdentity<C, M, R> {
        fluent_builders::DeleteCloudFrontOriginAccessIdentity::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteDistribution` operation.
    ///
    /// See [`DeleteDistribution`](crate::client::fluent_builders::DeleteDistribution) for more information about the
    /// operation and its arguments.
    pub fn delete_distribution(&self) -> fluent_builders::DeleteDistribution<C, M, R> {
        fluent_builders::DeleteDistribution::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteFieldLevelEncryptionConfig` operation.
    ///
    /// See [`DeleteFieldLevelEncryptionConfig`](crate::client::fluent_builders::DeleteFieldLevelEncryptionConfig) for more information about the
    /// operation and its arguments.
    pub fn delete_field_level_encryption_config(
        &self,
    ) -> fluent_builders::DeleteFieldLevelEncryptionConfig<C, M, R> {
        fluent_builders::DeleteFieldLevelEncryptionConfig::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteFieldLevelEncryptionProfile` operation.
    ///
    /// See [`DeleteFieldLevelEncryptionProfile`](crate::client::fluent_builders::DeleteFieldLevelEncryptionProfile) for more information about the
    /// operation and its arguments.
    pub fn delete_field_level_encryption_profile(
        &self,
    ) -> fluent_builders::DeleteFieldLevelEncryptionProfile<C, M, R> {
        fluent_builders::DeleteFieldLevelEncryptionProfile::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteFunction` operation.
    ///
    /// See [`DeleteFunction`](crate::client::fluent_builders::DeleteFunction) for more information about the
    /// operation and its arguments.
    pub fn delete_function(&self) -> fluent_builders::DeleteFunction<C, M, R> {
        fluent_builders::DeleteFunction::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteKeyGroup` operation.
    ///
    /// See [`DeleteKeyGroup`](crate::client::fluent_builders::DeleteKeyGroup) for more information about the
    /// operation and its arguments.
    pub fn delete_key_group(&self) -> fluent_builders::DeleteKeyGroup<C, M, R> {
        fluent_builders::DeleteKeyGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteMonitoringSubscription` operation.
    ///
    /// See [`DeleteMonitoringSubscription`](crate::client::fluent_builders::DeleteMonitoringSubscription) for more information about the
    /// operation and its arguments.
    pub fn delete_monitoring_subscription(
        &self,
    ) -> fluent_builders::DeleteMonitoringSubscription<C, M, R> {
        fluent_builders::DeleteMonitoringSubscription::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteOriginRequestPolicy` operation.
    ///
    /// See [`DeleteOriginRequestPolicy`](crate::client::fluent_builders::DeleteOriginRequestPolicy) for more information about the
    /// operation and its arguments.
    pub fn delete_origin_request_policy(
        &self,
    ) -> fluent_builders::DeleteOriginRequestPolicy<C, M, R> {
        fluent_builders::DeleteOriginRequestPolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeletePublicKey` operation.
    ///
    /// See [`DeletePublicKey`](crate::client::fluent_builders::DeletePublicKey) for more information about the
    /// operation and its arguments.
    pub fn delete_public_key(&self) -> fluent_builders::DeletePublicKey<C, M, R> {
        fluent_builders::DeletePublicKey::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteRealtimeLogConfig` operation.
    ///
    /// See [`DeleteRealtimeLogConfig`](crate::client::fluent_builders::DeleteRealtimeLogConfig) for more information about the
    /// operation and its arguments.
    pub fn delete_realtime_log_config(&self) -> fluent_builders::DeleteRealtimeLogConfig<C, M, R> {
        fluent_builders::DeleteRealtimeLogConfig::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteResponseHeadersPolicy` operation.
    ///
    /// See [`DeleteResponseHeadersPolicy`](crate::client::fluent_builders::DeleteResponseHeadersPolicy) for more information about the
    /// operation and its arguments.
    pub fn delete_response_headers_policy(
        &self,
    ) -> fluent_builders::DeleteResponseHeadersPolicy<C, M, R> {
        fluent_builders::DeleteResponseHeadersPolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteStreamingDistribution` operation.
    ///
    /// See [`DeleteStreamingDistribution`](crate::client::fluent_builders::DeleteStreamingDistribution) for more information about the
    /// operation and its arguments.
    pub fn delete_streaming_distribution(
        &self,
    ) -> fluent_builders::DeleteStreamingDistribution<C, M, R> {
        fluent_builders::DeleteStreamingDistribution::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeFunction` operation.
    ///
    /// See [`DescribeFunction`](crate::client::fluent_builders::DescribeFunction) for more information about the
    /// operation and its arguments.
    pub fn describe_function(&self) -> fluent_builders::DescribeFunction<C, M, R> {
        fluent_builders::DescribeFunction::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetCachePolicy` operation.
    ///
    /// See [`GetCachePolicy`](crate::client::fluent_builders::GetCachePolicy) for more information about the
    /// operation and its arguments.
    pub fn get_cache_policy(&self) -> fluent_builders::GetCachePolicy<C, M, R> {
        fluent_builders::GetCachePolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetCachePolicyConfig` operation.
    ///
    /// See [`GetCachePolicyConfig`](crate::client::fluent_builders::GetCachePolicyConfig) for more information about the
    /// operation and its arguments.
    pub fn get_cache_policy_config(&self) -> fluent_builders::GetCachePolicyConfig<C, M, R> {
        fluent_builders::GetCachePolicyConfig::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetCloudFrontOriginAccessIdentity` operation.
    ///
    /// See [`GetCloudFrontOriginAccessIdentity`](crate::client::fluent_builders::GetCloudFrontOriginAccessIdentity) for more information about the
    /// operation and its arguments.
    pub fn get_cloud_front_origin_access_identity(
        &self,
    ) -> fluent_builders::GetCloudFrontOriginAccessIdentity<C, M, R> {
        fluent_builders::GetCloudFrontOriginAccessIdentity::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetCloudFrontOriginAccessIdentityConfig` operation.
    ///
    /// See [`GetCloudFrontOriginAccessIdentityConfig`](crate::client::fluent_builders::GetCloudFrontOriginAccessIdentityConfig) for more information about the
    /// operation and its arguments.
    pub fn get_cloud_front_origin_access_identity_config(
        &self,
    ) -> fluent_builders::GetCloudFrontOriginAccessIdentityConfig<C, M, R> {
        fluent_builders::GetCloudFrontOriginAccessIdentityConfig::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetDistribution` operation.
    ///
    /// See [`GetDistribution`](crate::client::fluent_builders::GetDistribution) for more information about the
    /// operation and its arguments.
    pub fn get_distribution(&self) -> fluent_builders::GetDistribution<C, M, R> {
        fluent_builders::GetDistribution::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetDistributionConfig` operation.
    ///
    /// See [`GetDistributionConfig`](crate::client::fluent_builders::GetDistributionConfig) for more information about the
    /// operation and its arguments.
    pub fn get_distribution_config(&self) -> fluent_builders::GetDistributionConfig<C, M, R> {
        fluent_builders::GetDistributionConfig::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetFieldLevelEncryption` operation.
    ///
    /// See [`GetFieldLevelEncryption`](crate::client::fluent_builders::GetFieldLevelEncryption) for more information about the
    /// operation and its arguments.
    pub fn get_field_level_encryption(&self) -> fluent_builders::GetFieldLevelEncryption<C, M, R> {
        fluent_builders::GetFieldLevelEncryption::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetFieldLevelEncryptionConfig` operation.
    ///
    /// See [`GetFieldLevelEncryptionConfig`](crate::client::fluent_builders::GetFieldLevelEncryptionConfig) for more information about the
    /// operation and its arguments.
    pub fn get_field_level_encryption_config(
        &self,
    ) -> fluent_builders::GetFieldLevelEncryptionConfig<C, M, R> {
        fluent_builders::GetFieldLevelEncryptionConfig::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetFieldLevelEncryptionProfile` operation.
    ///
    /// See [`GetFieldLevelEncryptionProfile`](crate::client::fluent_builders::GetFieldLevelEncryptionProfile) for more information about the
    /// operation and its arguments.
    pub fn get_field_level_encryption_profile(
        &self,
    ) -> fluent_builders::GetFieldLevelEncryptionProfile<C, M, R> {
        fluent_builders::GetFieldLevelEncryptionProfile::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetFieldLevelEncryptionProfileConfig` operation.
    ///
    /// See [`GetFieldLevelEncryptionProfileConfig`](crate::client::fluent_builders::GetFieldLevelEncryptionProfileConfig) for more information about the
    /// operation and its arguments.
    pub fn get_field_level_encryption_profile_config(
        &self,
    ) -> fluent_builders::GetFieldLevelEncryptionProfileConfig<C, M, R> {
        fluent_builders::GetFieldLevelEncryptionProfileConfig::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetFunction` operation.
    ///
    /// See [`GetFunction`](crate::client::fluent_builders::GetFunction) for more information about the
    /// operation and its arguments.
    pub fn get_function(&self) -> fluent_builders::GetFunction<C, M, R> {
        fluent_builders::GetFunction::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetInvalidation` operation.
    ///
    /// See [`GetInvalidation`](crate::client::fluent_builders::GetInvalidation) for more information about the
    /// operation and its arguments.
    pub fn get_invalidation(&self) -> fluent_builders::GetInvalidation<C, M, R> {
        fluent_builders::GetInvalidation::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetKeyGroup` operation.
    ///
    /// See [`GetKeyGroup`](crate::client::fluent_builders::GetKeyGroup) for more information about the
    /// operation and its arguments.
    pub fn get_key_group(&self) -> fluent_builders::GetKeyGroup<C, M, R> {
        fluent_builders::GetKeyGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetKeyGroupConfig` operation.
    ///
    /// See [`GetKeyGroupConfig`](crate::client::fluent_builders::GetKeyGroupConfig) for more information about the
    /// operation and its arguments.
    pub fn get_key_group_config(&self) -> fluent_builders::GetKeyGroupConfig<C, M, R> {
        fluent_builders::GetKeyGroupConfig::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetMonitoringSubscription` operation.
    ///
    /// See [`GetMonitoringSubscription`](crate::client::fluent_builders::GetMonitoringSubscription) for more information about the
    /// operation and its arguments.
    pub fn get_monitoring_subscription(
        &self,
    ) -> fluent_builders::GetMonitoringSubscription<C, M, R> {
        fluent_builders::GetMonitoringSubscription::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetOriginRequestPolicy` operation.
    ///
    /// See [`GetOriginRequestPolicy`](crate::client::fluent_builders::GetOriginRequestPolicy) for more information about the
    /// operation and its arguments.
    pub fn get_origin_request_policy(&self) -> fluent_builders::GetOriginRequestPolicy<C, M, R> {
        fluent_builders::GetOriginRequestPolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetOriginRequestPolicyConfig` operation.
    ///
    /// See [`GetOriginRequestPolicyConfig`](crate::client::fluent_builders::GetOriginRequestPolicyConfig) for more information about the
    /// operation and its arguments.
    pub fn get_origin_request_policy_config(
        &self,
    ) -> fluent_builders::GetOriginRequestPolicyConfig<C, M, R> {
        fluent_builders::GetOriginRequestPolicyConfig::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetPublicKey` operation.
    ///
    /// See [`GetPublicKey`](crate::client::fluent_builders::GetPublicKey) for more information about the
    /// operation and its arguments.
    pub fn get_public_key(&self) -> fluent_builders::GetPublicKey<C, M, R> {
        fluent_builders::GetPublicKey::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetPublicKeyConfig` operation.
    ///
    /// See [`GetPublicKeyConfig`](crate::client::fluent_builders::GetPublicKeyConfig) for more information about the
    /// operation and its arguments.
    pub fn get_public_key_config(&self) -> fluent_builders::GetPublicKeyConfig<C, M, R> {
        fluent_builders::GetPublicKeyConfig::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetRealtimeLogConfig` operation.
    ///
    /// See [`GetRealtimeLogConfig`](crate::client::fluent_builders::GetRealtimeLogConfig) for more information about the
    /// operation and its arguments.
    pub fn get_realtime_log_config(&self) -> fluent_builders::GetRealtimeLogConfig<C, M, R> {
        fluent_builders::GetRealtimeLogConfig::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetResponseHeadersPolicy` operation.
    ///
    /// See [`GetResponseHeadersPolicy`](crate::client::fluent_builders::GetResponseHeadersPolicy) for more information about the
    /// operation and its arguments.
    pub fn get_response_headers_policy(
        &self,
    ) -> fluent_builders::GetResponseHeadersPolicy<C, M, R> {
        fluent_builders::GetResponseHeadersPolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetResponseHeadersPolicyConfig` operation.
    ///
    /// See [`GetResponseHeadersPolicyConfig`](crate::client::fluent_builders::GetResponseHeadersPolicyConfig) for more information about the
    /// operation and its arguments.
    pub fn get_response_headers_policy_config(
        &self,
    ) -> fluent_builders::GetResponseHeadersPolicyConfig<C, M, R> {
        fluent_builders::GetResponseHeadersPolicyConfig::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetStreamingDistribution` operation.
    ///
    /// See [`GetStreamingDistribution`](crate::client::fluent_builders::GetStreamingDistribution) for more information about the
    /// operation and its arguments.
    pub fn get_streaming_distribution(&self) -> fluent_builders::GetStreamingDistribution<C, M, R> {
        fluent_builders::GetStreamingDistribution::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetStreamingDistributionConfig` operation.
    ///
    /// See [`GetStreamingDistributionConfig`](crate::client::fluent_builders::GetStreamingDistributionConfig) for more information about the
    /// operation and its arguments.
    pub fn get_streaming_distribution_config(
        &self,
    ) -> fluent_builders::GetStreamingDistributionConfig<C, M, R> {
        fluent_builders::GetStreamingDistributionConfig::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListCachePolicies` operation.
    ///
    /// See [`ListCachePolicies`](crate::client::fluent_builders::ListCachePolicies) for more information about the
    /// operation and its arguments.
    pub fn list_cache_policies(&self) -> fluent_builders::ListCachePolicies<C, M, R> {
        fluent_builders::ListCachePolicies::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListCloudFrontOriginAccessIdentities` operation.
    ///
    /// See [`ListCloudFrontOriginAccessIdentities`](crate::client::fluent_builders::ListCloudFrontOriginAccessIdentities) for more information about the
    /// operation and its arguments.
    pub fn list_cloud_front_origin_access_identities(
        &self,
    ) -> fluent_builders::ListCloudFrontOriginAccessIdentities<C, M, R> {
        fluent_builders::ListCloudFrontOriginAccessIdentities::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListConflictingAliases` operation.
    ///
    /// See [`ListConflictingAliases`](crate::client::fluent_builders::ListConflictingAliases) for more information about the
    /// operation and its arguments.
    pub fn list_conflicting_aliases(&self) -> fluent_builders::ListConflictingAliases<C, M, R> {
        fluent_builders::ListConflictingAliases::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListDistributions` operation.
    ///
    /// See [`ListDistributions`](crate::client::fluent_builders::ListDistributions) for more information about the
    /// operation and its arguments.
    pub fn list_distributions(&self) -> fluent_builders::ListDistributions<C, M, R> {
        fluent_builders::ListDistributions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListDistributionsByCachePolicyId` operation.
    ///
    /// See [`ListDistributionsByCachePolicyId`](crate::client::fluent_builders::ListDistributionsByCachePolicyId) for more information about the
    /// operation and its arguments.
    pub fn list_distributions_by_cache_policy_id(
        &self,
    ) -> fluent_builders::ListDistributionsByCachePolicyId<C, M, R> {
        fluent_builders::ListDistributionsByCachePolicyId::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListDistributionsByKeyGroup` operation.
    ///
    /// See [`ListDistributionsByKeyGroup`](crate::client::fluent_builders::ListDistributionsByKeyGroup) for more information about the
    /// operation and its arguments.
    pub fn list_distributions_by_key_group(
        &self,
    ) -> fluent_builders::ListDistributionsByKeyGroup<C, M, R> {
        fluent_builders::ListDistributionsByKeyGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListDistributionsByOriginRequestPolicyId` operation.
    ///
    /// See [`ListDistributionsByOriginRequestPolicyId`](crate::client::fluent_builders::ListDistributionsByOriginRequestPolicyId) for more information about the
    /// operation and its arguments.
    pub fn list_distributions_by_origin_request_policy_id(
        &self,
    ) -> fluent_builders::ListDistributionsByOriginRequestPolicyId<C, M, R> {
        fluent_builders::ListDistributionsByOriginRequestPolicyId::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListDistributionsByRealtimeLogConfig` operation.
    ///
    /// See [`ListDistributionsByRealtimeLogConfig`](crate::client::fluent_builders::ListDistributionsByRealtimeLogConfig) for more information about the
    /// operation and its arguments.
    pub fn list_distributions_by_realtime_log_config(
        &self,
    ) -> fluent_builders::ListDistributionsByRealtimeLogConfig<C, M, R> {
        fluent_builders::ListDistributionsByRealtimeLogConfig::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListDistributionsByResponseHeadersPolicyId` operation.
    ///
    /// See [`ListDistributionsByResponseHeadersPolicyId`](crate::client::fluent_builders::ListDistributionsByResponseHeadersPolicyId) for more information about the
    /// operation and its arguments.
    pub fn list_distributions_by_response_headers_policy_id(
        &self,
    ) -> fluent_builders::ListDistributionsByResponseHeadersPolicyId<C, M, R> {
        fluent_builders::ListDistributionsByResponseHeadersPolicyId::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListDistributionsByWebACLId` operation.
    ///
    /// See [`ListDistributionsByWebACLId`](crate::client::fluent_builders::ListDistributionsByWebACLId) for more information about the
    /// operation and its arguments.
    pub fn list_distributions_by_web_acl_id(
        &self,
    ) -> fluent_builders::ListDistributionsByWebACLId<C, M, R> {
        fluent_builders::ListDistributionsByWebACLId::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListFieldLevelEncryptionConfigs` operation.
    ///
    /// See [`ListFieldLevelEncryptionConfigs`](crate::client::fluent_builders::ListFieldLevelEncryptionConfigs) for more information about the
    /// operation and its arguments.
    pub fn list_field_level_encryption_configs(
        &self,
    ) -> fluent_builders::ListFieldLevelEncryptionConfigs<C, M, R> {
        fluent_builders::ListFieldLevelEncryptionConfigs::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListFieldLevelEncryptionProfiles` operation.
    ///
    /// See [`ListFieldLevelEncryptionProfiles`](crate::client::fluent_builders::ListFieldLevelEncryptionProfiles) for more information about the
    /// operation and its arguments.
    pub fn list_field_level_encryption_profiles(
        &self,
    ) -> fluent_builders::ListFieldLevelEncryptionProfiles<C, M, R> {
        fluent_builders::ListFieldLevelEncryptionProfiles::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListFunctions` operation.
    ///
    /// See [`ListFunctions`](crate::client::fluent_builders::ListFunctions) for more information about the
    /// operation and its arguments.
    pub fn list_functions(&self) -> fluent_builders::ListFunctions<C, M, R> {
        fluent_builders::ListFunctions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListInvalidations` operation.
    ///
    /// See [`ListInvalidations`](crate::client::fluent_builders::ListInvalidations) for more information about the
    /// operation and its arguments.
    pub fn list_invalidations(&self) -> fluent_builders::ListInvalidations<C, M, R> {
        fluent_builders::ListInvalidations::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListKeyGroups` operation.
    ///
    /// See [`ListKeyGroups`](crate::client::fluent_builders::ListKeyGroups) for more information about the
    /// operation and its arguments.
    pub fn list_key_groups(&self) -> fluent_builders::ListKeyGroups<C, M, R> {
        fluent_builders::ListKeyGroups::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListOriginRequestPolicies` operation.
    ///
    /// See [`ListOriginRequestPolicies`](crate::client::fluent_builders::ListOriginRequestPolicies) for more information about the
    /// operation and its arguments.
    pub fn list_origin_request_policies(
        &self,
    ) -> fluent_builders::ListOriginRequestPolicies<C, M, R> {
        fluent_builders::ListOriginRequestPolicies::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListPublicKeys` operation.
    ///
    /// See [`ListPublicKeys`](crate::client::fluent_builders::ListPublicKeys) for more information about the
    /// operation and its arguments.
    pub fn list_public_keys(&self) -> fluent_builders::ListPublicKeys<C, M, R> {
        fluent_builders::ListPublicKeys::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListRealtimeLogConfigs` operation.
    ///
    /// See [`ListRealtimeLogConfigs`](crate::client::fluent_builders::ListRealtimeLogConfigs) for more information about the
    /// operation and its arguments.
    pub fn list_realtime_log_configs(&self) -> fluent_builders::ListRealtimeLogConfigs<C, M, R> {
        fluent_builders::ListRealtimeLogConfigs::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListResponseHeadersPolicies` operation.
    ///
    /// See [`ListResponseHeadersPolicies`](crate::client::fluent_builders::ListResponseHeadersPolicies) for more information about the
    /// operation and its arguments.
    pub fn list_response_headers_policies(
        &self,
    ) -> fluent_builders::ListResponseHeadersPolicies<C, M, R> {
        fluent_builders::ListResponseHeadersPolicies::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListStreamingDistributions` operation.
    ///
    /// See [`ListStreamingDistributions`](crate::client::fluent_builders::ListStreamingDistributions) for more information about the
    /// operation and its arguments.
    pub fn list_streaming_distributions(
        &self,
    ) -> fluent_builders::ListStreamingDistributions<C, M, R> {
        fluent_builders::ListStreamingDistributions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListTagsForResource` operation.
    ///
    /// See [`ListTagsForResource`](crate::client::fluent_builders::ListTagsForResource) for more information about the
    /// operation and its arguments.
    pub fn list_tags_for_resource(&self) -> fluent_builders::ListTagsForResource<C, M, R> {
        fluent_builders::ListTagsForResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `PublishFunction` operation.
    ///
    /// See [`PublishFunction`](crate::client::fluent_builders::PublishFunction) for more information about the
    /// operation and its arguments.
    pub fn publish_function(&self) -> fluent_builders::PublishFunction<C, M, R> {
        fluent_builders::PublishFunction::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `TagResource` operation.
    ///
    /// See [`TagResource`](crate::client::fluent_builders::TagResource) for more information about the
    /// operation and its arguments.
    pub fn tag_resource(&self) -> fluent_builders::TagResource<C, M, R> {
        fluent_builders::TagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `TestFunction` operation.
    ///
    /// See [`TestFunction`](crate::client::fluent_builders::TestFunction) for more information about the
    /// operation and its arguments.
    pub fn test_function(&self) -> fluent_builders::TestFunction<C, M, R> {
        fluent_builders::TestFunction::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UntagResource` operation.
    ///
    /// See [`UntagResource`](crate::client::fluent_builders::UntagResource) for more information about the
    /// operation and its arguments.
    pub fn untag_resource(&self) -> fluent_builders::UntagResource<C, M, R> {
        fluent_builders::UntagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateCachePolicy` operation.
    ///
    /// See [`UpdateCachePolicy`](crate::client::fluent_builders::UpdateCachePolicy) for more information about the
    /// operation and its arguments.
    pub fn update_cache_policy(&self) -> fluent_builders::UpdateCachePolicy<C, M, R> {
        fluent_builders::UpdateCachePolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateCloudFrontOriginAccessIdentity` operation.
    ///
    /// See [`UpdateCloudFrontOriginAccessIdentity`](crate::client::fluent_builders::UpdateCloudFrontOriginAccessIdentity) for more information about the
    /// operation and its arguments.
    pub fn update_cloud_front_origin_access_identity(
        &self,
    ) -> fluent_builders::UpdateCloudFrontOriginAccessIdentity<C, M, R> {
        fluent_builders::UpdateCloudFrontOriginAccessIdentity::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateDistribution` operation.
    ///
    /// See [`UpdateDistribution`](crate::client::fluent_builders::UpdateDistribution) for more information about the
    /// operation and its arguments.
    pub fn update_distribution(&self) -> fluent_builders::UpdateDistribution<C, M, R> {
        fluent_builders::UpdateDistribution::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateFieldLevelEncryptionConfig` operation.
    ///
    /// See [`UpdateFieldLevelEncryptionConfig`](crate::client::fluent_builders::UpdateFieldLevelEncryptionConfig) for more information about the
    /// operation and its arguments.
    pub fn update_field_level_encryption_config(
        &self,
    ) -> fluent_builders::UpdateFieldLevelEncryptionConfig<C, M, R> {
        fluent_builders::UpdateFieldLevelEncryptionConfig::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateFieldLevelEncryptionProfile` operation.
    ///
    /// See [`UpdateFieldLevelEncryptionProfile`](crate::client::fluent_builders::UpdateFieldLevelEncryptionProfile) for more information about the
    /// operation and its arguments.
    pub fn update_field_level_encryption_profile(
        &self,
    ) -> fluent_builders::UpdateFieldLevelEncryptionProfile<C, M, R> {
        fluent_builders::UpdateFieldLevelEncryptionProfile::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateFunction` operation.
    ///
    /// See [`UpdateFunction`](crate::client::fluent_builders::UpdateFunction) for more information about the
    /// operation and its arguments.
    pub fn update_function(&self) -> fluent_builders::UpdateFunction<C, M, R> {
        fluent_builders::UpdateFunction::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateKeyGroup` operation.
    ///
    /// See [`UpdateKeyGroup`](crate::client::fluent_builders::UpdateKeyGroup) for more information about the
    /// operation and its arguments.
    pub fn update_key_group(&self) -> fluent_builders::UpdateKeyGroup<C, M, R> {
        fluent_builders::UpdateKeyGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateOriginRequestPolicy` operation.
    ///
    /// See [`UpdateOriginRequestPolicy`](crate::client::fluent_builders::UpdateOriginRequestPolicy) for more information about the
    /// operation and its arguments.
    pub fn update_origin_request_policy(
        &self,
    ) -> fluent_builders::UpdateOriginRequestPolicy<C, M, R> {
        fluent_builders::UpdateOriginRequestPolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdatePublicKey` operation.
    ///
    /// See [`UpdatePublicKey`](crate::client::fluent_builders::UpdatePublicKey) for more information about the
    /// operation and its arguments.
    pub fn update_public_key(&self) -> fluent_builders::UpdatePublicKey<C, M, R> {
        fluent_builders::UpdatePublicKey::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateRealtimeLogConfig` operation.
    ///
    /// See [`UpdateRealtimeLogConfig`](crate::client::fluent_builders::UpdateRealtimeLogConfig) for more information about the
    /// operation and its arguments.
    pub fn update_realtime_log_config(&self) -> fluent_builders::UpdateRealtimeLogConfig<C, M, R> {
        fluent_builders::UpdateRealtimeLogConfig::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateResponseHeadersPolicy` operation.
    ///
    /// See [`UpdateResponseHeadersPolicy`](crate::client::fluent_builders::UpdateResponseHeadersPolicy) for more information about the
    /// operation and its arguments.
    pub fn update_response_headers_policy(
        &self,
    ) -> fluent_builders::UpdateResponseHeadersPolicy<C, M, R> {
        fluent_builders::UpdateResponseHeadersPolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateStreamingDistribution` operation.
    ///
    /// See [`UpdateStreamingDistribution`](crate::client::fluent_builders::UpdateStreamingDistribution) for more information about the
    /// operation and its arguments.
    pub fn update_streaming_distribution(
        &self,
    ) -> fluent_builders::UpdateStreamingDistribution<C, M, R> {
        fluent_builders::UpdateStreamingDistribution::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `AssociateAlias`.
    ///
    /// <p>Associates an alias (also known as a CNAME or an alternate domain name) with a CloudFront
    /// distribution.</p>
    /// <p>With this operation you can move an alias that’s already in use on a CloudFront distribution
    /// to a different distribution in one step. This prevents the downtime that could occur if
    /// you first remove the alias from one distribution and then separately add the alias to
    /// another distribution.</p>
    /// <p>To use this operation to associate an alias with a distribution, you provide the alias
    /// and the ID of the target distribution for the alias. For more information, including how
    /// to set up the target distribution, prerequisites that you must complete, and other
    /// restrictions, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/CNAMEs.html#alternate-domain-names-move">Moving an alternate domain name to a different distribution</a>
    /// in the <i>Amazon CloudFront Developer Guide</i>.</p>
    #[derive(std::fmt::Debug)]
    pub struct AssociateAlias<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::associate_alias_input::Builder,
    }
    impl<C, M, R> AssociateAlias<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AssociateAlias`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AssociateAliasOutput,
            aws_smithy_http::result::SdkError<crate::error::AssociateAliasError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AssociateAliasInputOperationOutputAlias,
                crate::output::AssociateAliasOutput,
                crate::error::AssociateAliasError,
                crate::input::AssociateAliasInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the distribution that you’re associating the alias with.</p>
        pub fn target_distribution_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.target_distribution_id(inp);
            self
        }
        /// <p>The ID of the distribution that you’re associating the alias with.</p>
        pub fn set_target_distribution_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_target_distribution_id(input);
            self
        }
        /// <p>The alias (also known as a CNAME) to add to the target distribution.</p>
        pub fn alias(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.alias(inp);
            self
        }
        /// <p>The alias (also known as a CNAME) to add to the target distribution.</p>
        pub fn set_alias(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_alias(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateCachePolicy`.
    ///
    /// <p>Creates a cache policy.</p>
    /// <p>After you create a cache policy, you can attach it to one or more cache behaviors. When it’s
    /// attached to a cache behavior, the cache policy determines the following:</p>
    /// <ul>
    /// <li>
    /// <p>The values that CloudFront includes in the <i>cache key</i>. These values can
    /// include HTTP headers, cookies, and URL query strings. CloudFront uses the cache key to
    /// find an object in its cache that it can return to the viewer.</p>
    /// </li>
    /// <li>
    /// <p>The default, minimum, and maximum time to live (TTL) values that you want objects to stay
    /// in the CloudFront cache.</p>
    /// </li>
    /// </ul>
    /// <p>The headers, cookies, and query strings that are included in the cache key are automatically
    /// included in requests that CloudFront sends to the origin. CloudFront sends a request when it can’t
    /// find an object in its cache that matches the request’s cache key. If you want to send
    /// values to the origin but <i>not</i> include them in the cache key, use
    /// <code>OriginRequestPolicy</code>.</p>
    /// <p>For more information about cache policies, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html">Controlling the cache key</a> in the
    /// <i>Amazon CloudFront Developer Guide</i>.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateCachePolicy<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_cache_policy_input::Builder,
    }
    impl<C, M, R> CreateCachePolicy<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateCachePolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateCachePolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateCachePolicyError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateCachePolicyInputOperationOutputAlias,
                crate::output::CreateCachePolicyOutput,
                crate::error::CreateCachePolicyError,
                crate::input::CreateCachePolicyInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A cache policy configuration.</p>
        pub fn cache_policy_config(mut self, inp: crate::model::CachePolicyConfig) -> Self {
            self.inner = self.inner.cache_policy_config(inp);
            self
        }
        /// <p>A cache policy configuration.</p>
        pub fn set_cache_policy_config(
            mut self,
            input: std::option::Option<crate::model::CachePolicyConfig>,
        ) -> Self {
            self.inner = self.inner.set_cache_policy_config(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateCloudFrontOriginAccessIdentity`.
    ///
    /// <p>Creates a new origin access identity. If you're using Amazon S3 for your origin, you can
    /// use an origin access identity to require users to access your content using a CloudFront URL instead
    /// of the Amazon S3 URL. For more information about how to use origin access identities, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html">Serving Private Content through CloudFront</a> in the
    /// <i>Amazon CloudFront Developer Guide</i>.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateCloudFrontOriginAccessIdentity<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_cloud_front_origin_access_identity_input::Builder,
    }
    impl<C, M, R> CreateCloudFrontOriginAccessIdentity<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateCloudFrontOriginAccessIdentity`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateCloudFrontOriginAccessIdentityOutput,
            aws_smithy_http::result::SdkError<
                crate::error::CreateCloudFrontOriginAccessIdentityError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateCloudFrontOriginAccessIdentityInputOperationOutputAlias,
                crate::output::CreateCloudFrontOriginAccessIdentityOutput,
                crate::error::CreateCloudFrontOriginAccessIdentityError,
                crate::input::CreateCloudFrontOriginAccessIdentityInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The current configuration information for the identity.</p>
        pub fn cloud_front_origin_access_identity_config(
            mut self,
            inp: crate::model::CloudFrontOriginAccessIdentityConfig,
        ) -> Self {
            self.inner = self.inner.cloud_front_origin_access_identity_config(inp);
            self
        }
        /// <p>The current configuration information for the identity.</p>
        pub fn set_cloud_front_origin_access_identity_config(
            mut self,
            input: std::option::Option<crate::model::CloudFrontOriginAccessIdentityConfig>,
        ) -> Self {
            self.inner = self
                .inner
                .set_cloud_front_origin_access_identity_config(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateDistribution`.
    ///
    /// <p>Creates a new web distribution. You create a CloudFront distribution to tell CloudFront where you
    /// want content to be delivered from, and the details about how to track and manage content delivery. Send a <code>POST</code> request to the
    /// <code>/<i>CloudFront API version</i>/distribution</code>/<code>distribution ID</code> resource.</p>
    /// <important>
    /// <p>When you update a distribution, there are more required fields than when you create a distribution.
    /// When you update your distribution by using
    /// <a href="https://docs.aws.amazon.com/cloudfront/latest/APIReference/API_UpdateDistribution.html">UpdateDistribution</a>,
    /// follow the steps included
    /// in the documentation to get the current configuration
    /// and then make your updates. This helps to make sure that you include all of the required fields. To view a summary,
    /// see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-overview-required-fields.html">Required
    /// Fields for Create Distribution and Update Distribution</a> in the <i>Amazon CloudFront Developer Guide</i>.</p>
    /// </important>
    #[derive(std::fmt::Debug)]
    pub struct CreateDistribution<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_distribution_input::Builder,
    }
    impl<C, M, R> CreateDistribution<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateDistribution`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateDistributionOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateDistributionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateDistributionInputOperationOutputAlias,
                crate::output::CreateDistributionOutput,
                crate::error::CreateDistributionError,
                crate::input::CreateDistributionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The distribution's configuration information.</p>
        pub fn distribution_config(mut self, inp: crate::model::DistributionConfig) -> Self {
            self.inner = self.inner.distribution_config(inp);
            self
        }
        /// <p>The distribution's configuration information.</p>
        pub fn set_distribution_config(
            mut self,
            input: std::option::Option<crate::model::DistributionConfig>,
        ) -> Self {
            self.inner = self.inner.set_distribution_config(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateDistributionWithTags`.
    ///
    /// <p>Create a new distribution with tags.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateDistributionWithTags<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_distribution_with_tags_input::Builder,
    }
    impl<C, M, R> CreateDistributionWithTags<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateDistributionWithTags`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateDistributionWithTagsOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateDistributionWithTagsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateDistributionWithTagsInputOperationOutputAlias,
                crate::output::CreateDistributionWithTagsOutput,
                crate::error::CreateDistributionWithTagsError,
                crate::input::CreateDistributionWithTagsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The distribution's configuration information. </p>
        pub fn distribution_config_with_tags(
            mut self,
            inp: crate::model::DistributionConfigWithTags,
        ) -> Self {
            self.inner = self.inner.distribution_config_with_tags(inp);
            self
        }
        /// <p>The distribution's configuration information. </p>
        pub fn set_distribution_config_with_tags(
            mut self,
            input: std::option::Option<crate::model::DistributionConfigWithTags>,
        ) -> Self {
            self.inner = self.inner.set_distribution_config_with_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateFieldLevelEncryptionConfig`.
    ///
    /// <p>Create a new field-level encryption configuration.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateFieldLevelEncryptionConfig<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_field_level_encryption_config_input::Builder,
    }
    impl<C, M, R> CreateFieldLevelEncryptionConfig<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateFieldLevelEncryptionConfig`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateFieldLevelEncryptionConfigOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateFieldLevelEncryptionConfigError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateFieldLevelEncryptionConfigInputOperationOutputAlias,
                crate::output::CreateFieldLevelEncryptionConfigOutput,
                crate::error::CreateFieldLevelEncryptionConfigError,
                crate::input::CreateFieldLevelEncryptionConfigInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The request to create a new field-level encryption configuration.</p>
        pub fn field_level_encryption_config(
            mut self,
            inp: crate::model::FieldLevelEncryptionConfig,
        ) -> Self {
            self.inner = self.inner.field_level_encryption_config(inp);
            self
        }
        /// <p>The request to create a new field-level encryption configuration.</p>
        pub fn set_field_level_encryption_config(
            mut self,
            input: std::option::Option<crate::model::FieldLevelEncryptionConfig>,
        ) -> Self {
            self.inner = self.inner.set_field_level_encryption_config(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateFieldLevelEncryptionProfile`.
    ///
    /// <p>Create a field-level encryption profile.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateFieldLevelEncryptionProfile<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_field_level_encryption_profile_input::Builder,
    }
    impl<C, M, R> CreateFieldLevelEncryptionProfile<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateFieldLevelEncryptionProfile`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateFieldLevelEncryptionProfileOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateFieldLevelEncryptionProfileError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateFieldLevelEncryptionProfileInputOperationOutputAlias,
                crate::output::CreateFieldLevelEncryptionProfileOutput,
                crate::error::CreateFieldLevelEncryptionProfileError,
                crate::input::CreateFieldLevelEncryptionProfileInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The request to create a field-level encryption profile.</p>
        pub fn field_level_encryption_profile_config(
            mut self,
            inp: crate::model::FieldLevelEncryptionProfileConfig,
        ) -> Self {
            self.inner = self.inner.field_level_encryption_profile_config(inp);
            self
        }
        /// <p>The request to create a field-level encryption profile.</p>
        pub fn set_field_level_encryption_profile_config(
            mut self,
            input: std::option::Option<crate::model::FieldLevelEncryptionProfileConfig>,
        ) -> Self {
            self.inner = self.inner.set_field_level_encryption_profile_config(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateFunction`.
    ///
    /// <p>Creates a CloudFront function.</p>
    /// <p>To create a function, you provide the function code and some configuration information
    /// about the function. The response contains an Amazon Resource Name (ARN) that uniquely
    /// identifies the function.</p>
    /// <p>When you create a function, it’s in the <code>DEVELOPMENT</code> stage. In this stage, you
    /// can test the function with <code>TestFunction</code>, and update it with
    /// <code>UpdateFunction</code>.</p>
    /// <p>When you’re ready to use your function with a CloudFront distribution, use
    /// <code>PublishFunction</code> to copy the function from the <code>DEVELOPMENT</code>
    /// stage to <code>LIVE</code>. When it’s live, you can attach the function to a
    /// distribution’s cache behavior, using the function’s ARN.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateFunction<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_function_input::Builder,
    }
    impl<C, M, R> CreateFunction<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateFunction`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateFunctionOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateFunctionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateFunctionInputOperationOutputAlias,
                crate::output::CreateFunctionOutput,
                crate::error::CreateFunctionError,
                crate::input::CreateFunctionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A name to identify the function.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>A name to identify the function.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>Configuration information about the function, including an optional comment and the
        /// function’s runtime.</p>
        pub fn function_config(mut self, inp: crate::model::FunctionConfig) -> Self {
            self.inner = self.inner.function_config(inp);
            self
        }
        /// <p>Configuration information about the function, including an optional comment and the
        /// function’s runtime.</p>
        pub fn set_function_config(
            mut self,
            input: std::option::Option<crate::model::FunctionConfig>,
        ) -> Self {
            self.inner = self.inner.set_function_config(input);
            self
        }
        /// <p>The function code. For more information about writing a CloudFront function, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/writing-function-code.html">Writing function
        /// code for CloudFront Functions</a> in the <i>Amazon CloudFront Developer Guide</i>.</p>
        pub fn function_code(mut self, inp: aws_smithy_types::Blob) -> Self {
            self.inner = self.inner.function_code(inp);
            self
        }
        /// <p>The function code. For more information about writing a CloudFront function, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/writing-function-code.html">Writing function
        /// code for CloudFront Functions</a> in the <i>Amazon CloudFront Developer Guide</i>.</p>
        pub fn set_function_code(
            mut self,
            input: std::option::Option<aws_smithy_types::Blob>,
        ) -> Self {
            self.inner = self.inner.set_function_code(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateInvalidation`.
    ///
    /// <p>Create a new invalidation. </p>
    #[derive(std::fmt::Debug)]
    pub struct CreateInvalidation<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_invalidation_input::Builder,
    }
    impl<C, M, R> CreateInvalidation<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateInvalidation`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateInvalidationOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateInvalidationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateInvalidationInputOperationOutputAlias,
                crate::output::CreateInvalidationOutput,
                crate::error::CreateInvalidationError,
                crate::input::CreateInvalidationInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The distribution's id.</p>
        pub fn distribution_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.distribution_id(inp);
            self
        }
        /// <p>The distribution's id.</p>
        pub fn set_distribution_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_distribution_id(input);
            self
        }
        /// <p>The batch information for the invalidation.</p>
        pub fn invalidation_batch(mut self, inp: crate::model::InvalidationBatch) -> Self {
            self.inner = self.inner.invalidation_batch(inp);
            self
        }
        /// <p>The batch information for the invalidation.</p>
        pub fn set_invalidation_batch(
            mut self,
            input: std::option::Option<crate::model::InvalidationBatch>,
        ) -> Self {
            self.inner = self.inner.set_invalidation_batch(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateKeyGroup`.
    ///
    /// <p>Creates a key group that you can use with <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html">CloudFront signed URLs and signed cookies</a>.</p>
    /// <p>To create a key group, you must specify at least one public key for the key group. After you
    /// create a key group, you can reference it from one or more cache behaviors. When you
    /// reference a key group in a cache behavior, CloudFront requires signed URLs or signed cookies
    /// for all requests that match the cache behavior. The URLs or cookies must be signed with
    /// a private key whose corresponding public key is in the key group. The signed URL or
    /// cookie contains information about which public key CloudFront should use to verify the
    /// signature. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html">Serving private content</a> in the <i>Amazon CloudFront Developer Guide</i>.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateKeyGroup<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_key_group_input::Builder,
    }
    impl<C, M, R> CreateKeyGroup<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateKeyGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateKeyGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateKeyGroupError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateKeyGroupInputOperationOutputAlias,
                crate::output::CreateKeyGroupOutput,
                crate::error::CreateKeyGroupError,
                crate::input::CreateKeyGroupInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A key group configuration.</p>
        pub fn key_group_config(mut self, inp: crate::model::KeyGroupConfig) -> Self {
            self.inner = self.inner.key_group_config(inp);
            self
        }
        /// <p>A key group configuration.</p>
        pub fn set_key_group_config(
            mut self,
            input: std::option::Option<crate::model::KeyGroupConfig>,
        ) -> Self {
            self.inner = self.inner.set_key_group_config(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateMonitoringSubscription`.
    ///
    /// <p>Enables additional CloudWatch metrics for the specified CloudFront distribution. The
    /// additional metrics incur an additional cost.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/viewing-cloudfront-metrics.html#monitoring-console.distributions-additional">Viewing additional CloudFront distribution metrics</a> in the
    /// <i>Amazon CloudFront Developer Guide</i>.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateMonitoringSubscription<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_monitoring_subscription_input::Builder,
    }
    impl<C, M, R> CreateMonitoringSubscription<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateMonitoringSubscription`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateMonitoringSubscriptionOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateMonitoringSubscriptionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateMonitoringSubscriptionInputOperationOutputAlias,
                crate::output::CreateMonitoringSubscriptionOutput,
                crate::error::CreateMonitoringSubscriptionError,
                crate::input::CreateMonitoringSubscriptionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the distribution that you are enabling metrics for.</p>
        pub fn distribution_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.distribution_id(inp);
            self
        }
        /// <p>The ID of the distribution that you are enabling metrics for.</p>
        pub fn set_distribution_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_distribution_id(input);
            self
        }
        /// <p>A monitoring subscription. This structure contains information about whether additional
        /// CloudWatch metrics are enabled for a given CloudFront distribution.</p>
        pub fn monitoring_subscription(
            mut self,
            inp: crate::model::MonitoringSubscription,
        ) -> Self {
            self.inner = self.inner.monitoring_subscription(inp);
            self
        }
        /// <p>A monitoring subscription. This structure contains information about whether additional
        /// CloudWatch metrics are enabled for a given CloudFront distribution.</p>
        pub fn set_monitoring_subscription(
            mut self,
            input: std::option::Option<crate::model::MonitoringSubscription>,
        ) -> Self {
            self.inner = self.inner.set_monitoring_subscription(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateOriginRequestPolicy`.
    ///
    /// <p>Creates an origin request policy.</p>
    /// <p>After you create an origin request policy, you can attach it to one or more cache behaviors.
    /// When it’s attached to a cache behavior, the origin request policy determines the values
    /// that CloudFront includes in requests that it sends to the origin. Each request that CloudFront sends
    /// to the origin includes the following:</p>
    /// <ul>
    /// <li>
    /// <p>The request body and the URL path (without the domain name) from the viewer
    /// request.</p>
    /// </li>
    /// <li>
    /// <p>The headers that CloudFront automatically includes in every origin request, including
    /// <code>Host</code>, <code>User-Agent</code>, and <code>X-Amz-Cf-Id</code>.</p>
    /// </li>
    /// <li>
    /// <p>All HTTP headers, cookies, and URL query strings that are specified in the cache policy or
    /// the origin request policy. These can include items from the viewer request and,
    /// in the case of headers, additional ones that are added by CloudFront.</p>
    /// </li>
    /// </ul>
    /// <p>CloudFront sends a request when it can’t find a valid object in its cache that matches the
    /// request. If you want to send values to the origin and also include them in the cache
    /// key, use <code>CachePolicy</code>.</p>
    /// <p>For more information about origin request policies, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-origin-requests.html">Controlling origin requests</a> in the
    /// <i>Amazon CloudFront Developer Guide</i>.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateOriginRequestPolicy<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_origin_request_policy_input::Builder,
    }
    impl<C, M, R> CreateOriginRequestPolicy<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateOriginRequestPolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateOriginRequestPolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateOriginRequestPolicyError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateOriginRequestPolicyInputOperationOutputAlias,
                crate::output::CreateOriginRequestPolicyOutput,
                crate::error::CreateOriginRequestPolicyError,
                crate::input::CreateOriginRequestPolicyInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>An origin request policy configuration.</p>
        pub fn origin_request_policy_config(
            mut self,
            inp: crate::model::OriginRequestPolicyConfig,
        ) -> Self {
            self.inner = self.inner.origin_request_policy_config(inp);
            self
        }
        /// <p>An origin request policy configuration.</p>
        pub fn set_origin_request_policy_config(
            mut self,
            input: std::option::Option<crate::model::OriginRequestPolicyConfig>,
        ) -> Self {
            self.inner = self.inner.set_origin_request_policy_config(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreatePublicKey`.
    ///
    /// <p>Uploads a public key to CloudFront that you can use with <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html">signed URLs and signed cookies</a>, or with <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/field-level-encryption.html">field-level encryption</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreatePublicKey<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_public_key_input::Builder,
    }
    impl<C, M, R> CreatePublicKey<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreatePublicKey`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreatePublicKeyOutput,
            aws_smithy_http::result::SdkError<crate::error::CreatePublicKeyError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreatePublicKeyInputOperationOutputAlias,
                crate::output::CreatePublicKeyOutput,
                crate::error::CreatePublicKeyError,
                crate::input::CreatePublicKeyInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A CloudFront public key configuration.</p>
        pub fn public_key_config(mut self, inp: crate::model::PublicKeyConfig) -> Self {
            self.inner = self.inner.public_key_config(inp);
            self
        }
        /// <p>A CloudFront public key configuration.</p>
        pub fn set_public_key_config(
            mut self,
            input: std::option::Option<crate::model::PublicKeyConfig>,
        ) -> Self {
            self.inner = self.inner.set_public_key_config(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateRealtimeLogConfig`.
    ///
    /// <p>Creates a real-time log configuration.</p>
    /// <p>After you create a real-time log configuration, you can attach it to one or more cache
    /// behaviors to send real-time log data to the specified Amazon Kinesis data stream.</p>
    /// <p>For more information about real-time log configurations, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/real-time-logs.html">Real-time logs</a> in the <i>Amazon CloudFront Developer Guide</i>.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateRealtimeLogConfig<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_realtime_log_config_input::Builder,
    }
    impl<C, M, R> CreateRealtimeLogConfig<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateRealtimeLogConfig`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateRealtimeLogConfigOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateRealtimeLogConfigError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateRealtimeLogConfigInputOperationOutputAlias,
                crate::output::CreateRealtimeLogConfigOutput,
                crate::error::CreateRealtimeLogConfigError,
                crate::input::CreateRealtimeLogConfigInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `EndPoints`.
        ///
        /// To override the contents of this collection use [`set_end_points`](Self::set_end_points).
        ///
        /// <p>Contains information about the Amazon Kinesis data stream where you are sending real-time
        /// log data.</p>
        pub fn end_points(mut self, inp: impl Into<crate::model::EndPoint>) -> Self {
            self.inner = self.inner.end_points(inp);
            self
        }
        /// <p>Contains information about the Amazon Kinesis data stream where you are sending real-time
        /// log data.</p>
        pub fn set_end_points(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::EndPoint>>,
        ) -> Self {
            self.inner = self.inner.set_end_points(input);
            self
        }
        /// Appends an item to `Fields`.
        ///
        /// To override the contents of this collection use [`set_fields`](Self::set_fields).
        ///
        /// <p>A list of fields to include in each real-time log record.</p>
        /// <p>For more information about fields, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/real-time-logs.html#understand-real-time-log-config-fields">Real-time log configuration fields</a> in the
        /// <i>Amazon CloudFront Developer Guide</i>.</p>
        pub fn fields(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.fields(inp);
            self
        }
        /// <p>A list of fields to include in each real-time log record.</p>
        /// <p>For more information about fields, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/real-time-logs.html#understand-real-time-log-config-fields">Real-time log configuration fields</a> in the
        /// <i>Amazon CloudFront Developer Guide</i>.</p>
        pub fn set_fields(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_fields(input);
            self
        }
        /// <p>A unique name to identify this real-time log configuration.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>A unique name to identify this real-time log configuration.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The sampling rate for this real-time log configuration. The sampling rate determines the
        /// percentage of viewer requests that are represented in the real-time log data. You must
        /// provide an integer between 1 and 100, inclusive.</p>
        pub fn sampling_rate(mut self, inp: i64) -> Self {
            self.inner = self.inner.sampling_rate(inp);
            self
        }
        /// <p>The sampling rate for this real-time log configuration. The sampling rate determines the
        /// percentage of viewer requests that are represented in the real-time log data. You must
        /// provide an integer between 1 and 100, inclusive.</p>
        pub fn set_sampling_rate(mut self, input: std::option::Option<i64>) -> Self {
            self.inner = self.inner.set_sampling_rate(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateResponseHeadersPolicy`.
    ///
    /// <p>Creates a response headers policy.</p>
    /// <p>A response headers policy contains information about a set of HTTP response headers
    /// and their values. To create a response headers policy, you provide some metadata about
    /// the policy, and a set of configurations that specify the response headers.</p>
    /// <p>After you create a response headers policy, you can use its ID to attach it to one or more
    /// cache behaviors in a CloudFront distribution. When it’s attached to a cache behavior, CloudFront
    /// adds the headers in the policy to HTTP responses that it sends for requests that match
    /// the cache behavior.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateResponseHeadersPolicy<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_response_headers_policy_input::Builder,
    }
    impl<C, M, R> CreateResponseHeadersPolicy<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateResponseHeadersPolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateResponseHeadersPolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateResponseHeadersPolicyError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateResponseHeadersPolicyInputOperationOutputAlias,
                crate::output::CreateResponseHeadersPolicyOutput,
                crate::error::CreateResponseHeadersPolicyError,
                crate::input::CreateResponseHeadersPolicyInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Contains metadata about the response headers policy, and a set of configurations that
        /// specify the response headers.</p>
        pub fn response_headers_policy_config(
            mut self,
            inp: crate::model::ResponseHeadersPolicyConfig,
        ) -> Self {
            self.inner = self.inner.response_headers_policy_config(inp);
            self
        }
        /// <p>Contains metadata about the response headers policy, and a set of configurations that
        /// specify the response headers.</p>
        pub fn set_response_headers_policy_config(
            mut self,
            input: std::option::Option<crate::model::ResponseHeadersPolicyConfig>,
        ) -> Self {
            self.inner = self.inner.set_response_headers_policy_config(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateStreamingDistribution`.
    ///
    /// <p>This API is deprecated.
    /// Amazon CloudFront is deprecating real-time messaging protocol (RTMP) distributions on December 31, 2020.
    /// For more information, <a href="http://forums.aws.amazon.com/ann.jspa?annID=7356">read the announcement</a> on the Amazon CloudFront discussion forum.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateStreamingDistribution<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_streaming_distribution_input::Builder,
    }
    impl<C, M, R> CreateStreamingDistribution<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateStreamingDistribution`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateStreamingDistributionOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateStreamingDistributionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateStreamingDistributionInputOperationOutputAlias,
                crate::output::CreateStreamingDistributionOutput,
                crate::error::CreateStreamingDistributionError,
                crate::input::CreateStreamingDistributionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The streaming distribution's configuration information.</p>
        pub fn streaming_distribution_config(
            mut self,
            inp: crate::model::StreamingDistributionConfig,
        ) -> Self {
            self.inner = self.inner.streaming_distribution_config(inp);
            self
        }
        /// <p>The streaming distribution's configuration information.</p>
        pub fn set_streaming_distribution_config(
            mut self,
            input: std::option::Option<crate::model::StreamingDistributionConfig>,
        ) -> Self {
            self.inner = self.inner.set_streaming_distribution_config(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateStreamingDistributionWithTags`.
    ///
    /// <p>This API is deprecated.
    /// Amazon CloudFront is deprecating real-time messaging protocol (RTMP) distributions on December 31, 2020.
    /// For more information, <a href="http://forums.aws.amazon.com/ann.jspa?annID=7356">read the announcement</a> on the Amazon CloudFront discussion forum.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateStreamingDistributionWithTags<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_streaming_distribution_with_tags_input::Builder,
    }
    impl<C, M, R> CreateStreamingDistributionWithTags<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateStreamingDistributionWithTags`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateStreamingDistributionWithTagsOutput,
            aws_smithy_http::result::SdkError<
                crate::error::CreateStreamingDistributionWithTagsError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateStreamingDistributionWithTagsInputOperationOutputAlias,
                crate::output::CreateStreamingDistributionWithTagsOutput,
                crate::error::CreateStreamingDistributionWithTagsError,
                crate::input::CreateStreamingDistributionWithTagsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The streaming distribution's configuration information. </p>
        pub fn streaming_distribution_config_with_tags(
            mut self,
            inp: crate::model::StreamingDistributionConfigWithTags,
        ) -> Self {
            self.inner = self.inner.streaming_distribution_config_with_tags(inp);
            self
        }
        /// <p> The streaming distribution's configuration information. </p>
        pub fn set_streaming_distribution_config_with_tags(
            mut self,
            input: std::option::Option<crate::model::StreamingDistributionConfigWithTags>,
        ) -> Self {
            self.inner = self
                .inner
                .set_streaming_distribution_config_with_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteCachePolicy`.
    ///
    /// <p>Deletes a cache policy.</p>
    /// <p>You cannot delete a cache policy if it’s attached to a cache behavior. First update your
    /// distributions to remove the cache policy from all cache behaviors, then delete the cache
    /// policy.</p>
    /// <p>To delete a cache policy, you must provide the policy’s identifier and version. To get these
    /// values, you can use <code>ListCachePolicies</code> or
    /// <code>GetCachePolicy</code>.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteCachePolicy<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_cache_policy_input::Builder,
    }
    impl<C, M, R> DeleteCachePolicy<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteCachePolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteCachePolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteCachePolicyError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteCachePolicyInputOperationOutputAlias,
                crate::output::DeleteCachePolicyOutput,
                crate::error::DeleteCachePolicyError,
                crate::input::DeleteCachePolicyInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier for the cache policy that you are deleting. To get the
        /// identifier, you can use <code>ListCachePolicies</code>.</p>
        pub fn id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(inp);
            self
        }
        /// <p>The unique identifier for the cache policy that you are deleting. To get the
        /// identifier, you can use <code>ListCachePolicies</code>.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
        /// <p>The version of the cache policy that you are deleting. The version is the cache
        /// policy’s <code>ETag</code> value, which you can get using
        /// <code>ListCachePolicies</code>, <code>GetCachePolicy</code>, or
        /// <code>GetCachePolicyConfig</code>.</p>
        pub fn if_match(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.if_match(inp);
            self
        }
        /// <p>The version of the cache policy that you are deleting. The version is the cache
        /// policy’s <code>ETag</code> value, which you can get using
        /// <code>ListCachePolicies</code>, <code>GetCachePolicy</code>, or
        /// <code>GetCachePolicyConfig</code>.</p>
        pub fn set_if_match(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_if_match(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteCloudFrontOriginAccessIdentity`.
    ///
    /// <p>Delete an origin access identity. </p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteCloudFrontOriginAccessIdentity<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_cloud_front_origin_access_identity_input::Builder,
    }
    impl<C, M, R> DeleteCloudFrontOriginAccessIdentity<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteCloudFrontOriginAccessIdentity`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteCloudFrontOriginAccessIdentityOutput,
            aws_smithy_http::result::SdkError<
                crate::error::DeleteCloudFrontOriginAccessIdentityError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteCloudFrontOriginAccessIdentityInputOperationOutputAlias,
                crate::output::DeleteCloudFrontOriginAccessIdentityOutput,
                crate::error::DeleteCloudFrontOriginAccessIdentityError,
                crate::input::DeleteCloudFrontOriginAccessIdentityInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The origin access identity's ID.</p>
        pub fn id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(inp);
            self
        }
        /// <p>The origin access identity's ID.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
        /// <p>The value of the <code>ETag</code> header you received from a previous <code>GET</code>
        /// or <code>PUT</code> request. For example: <code>E2QWRUHAPOMQZL</code>.</p>
        pub fn if_match(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.if_match(inp);
            self
        }
        /// <p>The value of the <code>ETag</code> header you received from a previous <code>GET</code>
        /// or <code>PUT</code> request. For example: <code>E2QWRUHAPOMQZL</code>.</p>
        pub fn set_if_match(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_if_match(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteDistribution`.
    ///
    /// <p>Delete a distribution. </p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteDistribution<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_distribution_input::Builder,
    }
    impl<C, M, R> DeleteDistribution<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteDistribution`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteDistributionOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteDistributionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteDistributionInputOperationOutputAlias,
                crate::output::DeleteDistributionOutput,
                crate::error::DeleteDistributionError,
                crate::input::DeleteDistributionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The distribution ID. </p>
        pub fn id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(inp);
            self
        }
        /// <p>The distribution ID. </p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
        /// <p>The value of the <code>ETag</code> header that you received when you disabled the
        /// distribution. For example: <code>E2QWRUHAPOMQZL</code>. </p>
        pub fn if_match(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.if_match(inp);
            self
        }
        /// <p>The value of the <code>ETag</code> header that you received when you disabled the
        /// distribution. For example: <code>E2QWRUHAPOMQZL</code>. </p>
        pub fn set_if_match(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_if_match(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteFieldLevelEncryptionConfig`.
    ///
    /// <p>Remove a field-level encryption configuration.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteFieldLevelEncryptionConfig<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_field_level_encryption_config_input::Builder,
    }
    impl<C, M, R> DeleteFieldLevelEncryptionConfig<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteFieldLevelEncryptionConfig`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteFieldLevelEncryptionConfigOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteFieldLevelEncryptionConfigError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteFieldLevelEncryptionConfigInputOperationOutputAlias,
                crate::output::DeleteFieldLevelEncryptionConfigOutput,
                crate::error::DeleteFieldLevelEncryptionConfigError,
                crate::input::DeleteFieldLevelEncryptionConfigInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the configuration you want to delete from CloudFront.</p>
        pub fn id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(inp);
            self
        }
        /// <p>The ID of the configuration you want to delete from CloudFront.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
        /// <p>The value of the <code>ETag</code> header that you received when retrieving the
        /// configuration identity to delete. For example: <code>E2QWRUHAPOMQZL</code>.</p>
        pub fn if_match(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.if_match(inp);
            self
        }
        /// <p>The value of the <code>ETag</code> header that you received when retrieving the
        /// configuration identity to delete. For example: <code>E2QWRUHAPOMQZL</code>.</p>
        pub fn set_if_match(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_if_match(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteFieldLevelEncryptionProfile`.
    ///
    /// <p>Remove a field-level encryption profile.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteFieldLevelEncryptionProfile<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_field_level_encryption_profile_input::Builder,
    }
    impl<C, M, R> DeleteFieldLevelEncryptionProfile<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteFieldLevelEncryptionProfile`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteFieldLevelEncryptionProfileOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteFieldLevelEncryptionProfileError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteFieldLevelEncryptionProfileInputOperationOutputAlias,
                crate::output::DeleteFieldLevelEncryptionProfileOutput,
                crate::error::DeleteFieldLevelEncryptionProfileError,
                crate::input::DeleteFieldLevelEncryptionProfileInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Request the ID of the profile you want to delete from CloudFront.</p>
        pub fn id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(inp);
            self
        }
        /// <p>Request the ID of the profile you want to delete from CloudFront.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
        /// <p>The value of the <code>ETag</code> header that you received when retrieving the
        /// profile to delete. For example: <code>E2QWRUHAPOMQZL</code>.</p>
        pub fn if_match(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.if_match(inp);
            self
        }
        /// <p>The value of the <code>ETag</code> header that you received when retrieving the
        /// profile to delete. For example: <code>E2QWRUHAPOMQZL</code>.</p>
        pub fn set_if_match(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_if_match(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteFunction`.
    ///
    /// <p>Deletes a CloudFront function.</p>
    /// <p>You cannot delete a function if it’s associated with a cache behavior. First, update your
    /// distributions to remove the function association from all cache behaviors, then delete
    /// the function.</p>
    /// <p>To delete a function, you must provide the function’s name and version
    /// (<code>ETag</code> value). To get these values, you can use <code>ListFunctions</code>
    /// and <code>DescribeFunction</code>.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteFunction<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_function_input::Builder,
    }
    impl<C, M, R> DeleteFunction<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteFunction`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteFunctionOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteFunctionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteFunctionInputOperationOutputAlias,
                crate::output::DeleteFunctionOutput,
                crate::error::DeleteFunctionError,
                crate::input::DeleteFunctionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the function that you are deleting.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name of the function that you are deleting.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The current version (<code>ETag</code> value) of the function that you are deleting, which
        /// you can get using <code>DescribeFunction</code>.</p>
        pub fn if_match(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.if_match(inp);
            self
        }
        /// <p>The current version (<code>ETag</code> value) of the function that you are deleting, which
        /// you can get using <code>DescribeFunction</code>.</p>
        pub fn set_if_match(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_if_match(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteKeyGroup`.
    ///
    /// <p>Deletes a key group.</p>
    /// <p>You cannot delete a key group that is referenced in a cache behavior. First update
    /// your distributions to remove the key group from all cache behaviors, then delete the key
    /// group.</p>
    /// <p>To delete a key group, you must provide the key group’s identifier and version. To get
    /// these values, use <code>ListKeyGroups</code> followed by <code>GetKeyGroup</code> or
    /// <code>GetKeyGroupConfig</code>.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteKeyGroup<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_key_group_input::Builder,
    }
    impl<C, M, R> DeleteKeyGroup<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteKeyGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteKeyGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteKeyGroupError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteKeyGroupInputOperationOutputAlias,
                crate::output::DeleteKeyGroupOutput,
                crate::error::DeleteKeyGroupError,
                crate::input::DeleteKeyGroupInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the key group that you are deleting. To get the identifier, use
        /// <code>ListKeyGroups</code>.</p>
        pub fn id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(inp);
            self
        }
        /// <p>The identifier of the key group that you are deleting. To get the identifier, use
        /// <code>ListKeyGroups</code>.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
        /// <p>The version of the key group that you are deleting. The version is the key group’s
        /// <code>ETag</code> value. To get the <code>ETag</code>, use <code>GetKeyGroup</code> or
        /// <code>GetKeyGroupConfig</code>.</p>
        pub fn if_match(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.if_match(inp);
            self
        }
        /// <p>The version of the key group that you are deleting. The version is the key group’s
        /// <code>ETag</code> value. To get the <code>ETag</code>, use <code>GetKeyGroup</code> or
        /// <code>GetKeyGroupConfig</code>.</p>
        pub fn set_if_match(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_if_match(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteMonitoringSubscription`.
    ///
    /// <p>Disables additional CloudWatch metrics for the specified CloudFront distribution.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteMonitoringSubscription<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_monitoring_subscription_input::Builder,
    }
    impl<C, M, R> DeleteMonitoringSubscription<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteMonitoringSubscription`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteMonitoringSubscriptionOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteMonitoringSubscriptionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteMonitoringSubscriptionInputOperationOutputAlias,
                crate::output::DeleteMonitoringSubscriptionOutput,
                crate::error::DeleteMonitoringSubscriptionError,
                crate::input::DeleteMonitoringSubscriptionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the distribution that you are disabling metrics for.</p>
        pub fn distribution_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.distribution_id(inp);
            self
        }
        /// <p>The ID of the distribution that you are disabling metrics for.</p>
        pub fn set_distribution_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_distribution_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteOriginRequestPolicy`.
    ///
    /// <p>Deletes an origin request policy.</p>
    /// <p>You cannot delete an origin request policy if it’s attached to any cache behaviors. First
    /// update your distributions to remove the origin request policy from all cache behaviors,
    /// then delete the origin request policy.</p>
    /// <p>To delete an origin request policy, you must provide the policy’s identifier and version. To
    /// get the identifier, you can use <code>ListOriginRequestPolicies</code> or
    /// <code>GetOriginRequestPolicy</code>.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteOriginRequestPolicy<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_origin_request_policy_input::Builder,
    }
    impl<C, M, R> DeleteOriginRequestPolicy<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteOriginRequestPolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteOriginRequestPolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteOriginRequestPolicyError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteOriginRequestPolicyInputOperationOutputAlias,
                crate::output::DeleteOriginRequestPolicyOutput,
                crate::error::DeleteOriginRequestPolicyError,
                crate::input::DeleteOriginRequestPolicyInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier for the origin request policy that you are deleting. To get the
        /// identifier, you can use <code>ListOriginRequestPolicies</code>.</p>
        pub fn id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(inp);
            self
        }
        /// <p>The unique identifier for the origin request policy that you are deleting. To get the
        /// identifier, you can use <code>ListOriginRequestPolicies</code>.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
        /// <p>The version of the origin request policy that you are deleting. The version is the origin
        /// request policy’s <code>ETag</code> value, which you can get using
        /// <code>ListOriginRequestPolicies</code>, <code>GetOriginRequestPolicy</code>, or
        /// <code>GetOriginRequestPolicyConfig</code>.</p>
        pub fn if_match(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.if_match(inp);
            self
        }
        /// <p>The version of the origin request policy that you are deleting. The version is the origin
        /// request policy’s <code>ETag</code> value, which you can get using
        /// <code>ListOriginRequestPolicies</code>, <code>GetOriginRequestPolicy</code>, or
        /// <code>GetOriginRequestPolicyConfig</code>.</p>
        pub fn set_if_match(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_if_match(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeletePublicKey`.
    ///
    /// <p>Remove a public key you previously added to CloudFront.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeletePublicKey<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_public_key_input::Builder,
    }
    impl<C, M, R> DeletePublicKey<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeletePublicKey`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeletePublicKeyOutput,
            aws_smithy_http::result::SdkError<crate::error::DeletePublicKeyError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeletePublicKeyInputOperationOutputAlias,
                crate::output::DeletePublicKeyOutput,
                crate::error::DeletePublicKeyError,
                crate::input::DeletePublicKeyInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the public key you want to remove from CloudFront.</p>
        pub fn id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(inp);
            self
        }
        /// <p>The ID of the public key you want to remove from CloudFront.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
        /// <p>The value of the <code>ETag</code> header that you received when retrieving the
        /// public key identity to delete. For example: <code>E2QWRUHAPOMQZL</code>.</p>
        pub fn if_match(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.if_match(inp);
            self
        }
        /// <p>The value of the <code>ETag</code> header that you received when retrieving the
        /// public key identity to delete. For example: <code>E2QWRUHAPOMQZL</code>.</p>
        pub fn set_if_match(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_if_match(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteRealtimeLogConfig`.
    ///
    /// <p>Deletes a real-time log configuration.</p>
    /// <p>You cannot delete a real-time log configuration if it’s attached to a cache behavior.
    /// First update your distributions to remove the real-time log configuration from all cache
    /// behaviors, then delete the real-time log configuration.</p>
    /// <p>To delete a real-time log configuration, you can provide the configuration’s name or its
    /// Amazon Resource Name (ARN). You must provide at least one. If you provide both, CloudFront
    /// uses the name to identify the real-time log configuration to delete.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteRealtimeLogConfig<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_realtime_log_config_input::Builder,
    }
    impl<C, M, R> DeleteRealtimeLogConfig<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteRealtimeLogConfig`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteRealtimeLogConfigOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteRealtimeLogConfigError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteRealtimeLogConfigInputOperationOutputAlias,
                crate::output::DeleteRealtimeLogConfigOutput,
                crate::error::DeleteRealtimeLogConfigError,
                crate::input::DeleteRealtimeLogConfigInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the real-time log configuration to delete.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name of the real-time log configuration to delete.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the real-time log configuration to delete.</p>
        pub fn arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the real-time log configuration to delete.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteResponseHeadersPolicy`.
    ///
    /// <p>Deletes a response headers policy.</p>
    /// <p>You cannot delete a response headers policy if it’s attached to a cache behavior.
    /// First update your distributions to remove the response headers policy from all cache
    /// behaviors, then delete the response headers policy.</p>
    /// <p>To delete a response headers policy, you must provide the policy’s identifier and
    /// version. To get these values, you can use <code>ListResponseHeadersPolicies</code> or
    /// <code>GetResponseHeadersPolicy</code>. </p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteResponseHeadersPolicy<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_response_headers_policy_input::Builder,
    }
    impl<C, M, R> DeleteResponseHeadersPolicy<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteResponseHeadersPolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteResponseHeadersPolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteResponseHeadersPolicyError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteResponseHeadersPolicyInputOperationOutputAlias,
                crate::output::DeleteResponseHeadersPolicyOutput,
                crate::error::DeleteResponseHeadersPolicyError,
                crate::input::DeleteResponseHeadersPolicyInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier for the response headers policy that you are deleting.</p>
        /// <p>To get the identifier, you can use <code>ListResponseHeadersPolicies</code>.</p>
        pub fn id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(inp);
            self
        }
        /// <p>The identifier for the response headers policy that you are deleting.</p>
        /// <p>To get the identifier, you can use <code>ListResponseHeadersPolicies</code>.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
        /// <p>The version of the response headers policy that you are deleting.</p>
        /// <p>The version is the response headers policy’s <code>ETag</code> value, which you can
        /// get using <code>ListResponseHeadersPolicies</code>,
        /// <code>GetResponseHeadersPolicy</code>, or
        /// <code>GetResponseHeadersPolicyConfig</code>.</p>
        pub fn if_match(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.if_match(inp);
            self
        }
        /// <p>The version of the response headers policy that you are deleting.</p>
        /// <p>The version is the response headers policy’s <code>ETag</code> value, which you can
        /// get using <code>ListResponseHeadersPolicies</code>,
        /// <code>GetResponseHeadersPolicy</code>, or
        /// <code>GetResponseHeadersPolicyConfig</code>.</p>
        pub fn set_if_match(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_if_match(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteStreamingDistribution`.
    ///
    /// <p>Delete a streaming distribution. To delete an RTMP distribution using the CloudFront API,
    /// perform the following steps.</p>
    ///
    /// <p>
    /// <b>To delete an RTMP distribution using the CloudFront
    /// API</b>:</p>
    /// <ol>
    /// <li>
    /// <p>Disable the RTMP distribution.</p>
    /// </li>
    /// <li>
    /// <p>Submit a <code>GET Streaming Distribution Config</code> request to get the current
    /// configuration and the <code>Etag</code> header for the distribution. </p>
    /// </li>
    /// <li>
    /// <p>Update the XML document that was returned in the response to your <code>GET
    /// Streaming Distribution Config</code> request to change the value of <code>Enabled</code>
    /// to <code>false</code>.</p>
    /// </li>
    /// <li>
    /// <p>Submit a <code>PUT Streaming Distribution Config</code> request to update the
    /// configuration for your distribution. In the request body, include the XML document that
    /// you updated in Step 3. Then set the value of the HTTP <code>If-Match</code> header to the
    /// value of the <code>ETag</code> header that CloudFront returned when you submitted the <code>GET
    /// Streaming Distribution Config</code> request in Step 2.</p>
    /// </li>
    /// <li>
    /// <p>Review the response to the <code>PUT Streaming Distribution Config</code> request
    /// to confirm that the distribution was successfully disabled.</p>
    /// </li>
    /// <li>
    /// <p>Submit a <code>GET Streaming Distribution Config</code> request to confirm that
    /// your changes have propagated. When propagation is complete, the value of
    /// <code>Status</code> is <code>Deployed</code>.</p>
    /// </li>
    /// <li>
    /// <p>Submit a <code>DELETE Streaming Distribution</code> request. Set the value of the
    /// HTTP <code>If-Match</code> header to the value of the <code>ETag</code> header that CloudFront
    /// returned when you submitted the <code>GET Streaming Distribution Config</code> request in
    /// Step 2.</p>
    /// </li>
    /// <li>
    /// <p>Review the response to your <code>DELETE Streaming Distribution</code> request to
    /// confirm that the distribution was successfully deleted.</p>
    /// </li>
    /// </ol>
    /// <p>For information about deleting a distribution using the CloudFront console, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/HowToDeleteDistribution.html">Deleting a Distribution</a> in the
    /// <i>Amazon CloudFront Developer Guide</i>.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteStreamingDistribution<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_streaming_distribution_input::Builder,
    }
    impl<C, M, R> DeleteStreamingDistribution<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteStreamingDistribution`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteStreamingDistributionOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteStreamingDistributionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteStreamingDistributionInputOperationOutputAlias,
                crate::output::DeleteStreamingDistributionOutput,
                crate::error::DeleteStreamingDistributionError,
                crate::input::DeleteStreamingDistributionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The distribution ID. </p>
        pub fn id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(inp);
            self
        }
        /// <p>The distribution ID. </p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
        /// <p>The value of the <code>ETag</code> header that you received when you disabled the
        /// streaming distribution. For example: <code>E2QWRUHAPOMQZL</code>.</p>
        pub fn if_match(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.if_match(inp);
            self
        }
        /// <p>The value of the <code>ETag</code> header that you received when you disabled the
        /// streaming distribution. For example: <code>E2QWRUHAPOMQZL</code>.</p>
        pub fn set_if_match(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_if_match(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeFunction`.
    ///
    /// <p>Gets configuration information and metadata about a CloudFront function, but not the function’s
    /// code. To get a function’s code, use <code>GetFunction</code>.</p>
    /// <p>To get configuration information and metadata about a function, you must provide the
    /// function’s name and stage. To get these values, you can use
    /// <code>ListFunctions</code>.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeFunction<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_function_input::Builder,
    }
    impl<C, M, R> DescribeFunction<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeFunction`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeFunctionOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeFunctionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeFunctionInputOperationOutputAlias,
                crate::output::DescribeFunctionOutput,
                crate::error::DescribeFunctionError,
                crate::input::DescribeFunctionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the function that you are getting information about.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name of the function that you are getting information about.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The function’s stage, either <code>DEVELOPMENT</code> or <code>LIVE</code>.</p>
        pub fn stage(mut self, inp: crate::model::FunctionStage) -> Self {
            self.inner = self.inner.stage(inp);
            self
        }
        /// <p>The function’s stage, either <code>DEVELOPMENT</code> or <code>LIVE</code>.</p>
        pub fn set_stage(
            mut self,
            input: std::option::Option<crate::model::FunctionStage>,
        ) -> Self {
            self.inner = self.inner.set_stage(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetCachePolicy`.
    ///
    /// <p>Gets a cache policy, including the following metadata:</p>
    /// <ul>
    /// <li>
    /// <p>The policy’s identifier.</p>
    /// </li>
    /// <li>
    /// <p>The date and time when the policy was last modified.</p>
    /// </li>
    /// </ul>
    /// <p>To get a cache policy, you must provide the policy’s identifier. If the cache policy is
    /// attached to a distribution’s cache behavior, you can get the policy’s identifier using
    /// <code>ListDistributions</code> or <code>GetDistribution</code>. If the cache policy is
    /// not attached to a cache behavior, you can get the identifier using
    /// <code>ListCachePolicies</code>.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetCachePolicy<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_cache_policy_input::Builder,
    }
    impl<C, M, R> GetCachePolicy<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetCachePolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetCachePolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::GetCachePolicyError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetCachePolicyInputOperationOutputAlias,
                crate::output::GetCachePolicyOutput,
                crate::error::GetCachePolicyError,
                crate::input::GetCachePolicyInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier for the cache policy. If the cache policy is attached to a
        /// distribution’s cache behavior, you can get the policy’s identifier using
        /// <code>ListDistributions</code> or <code>GetDistribution</code>. If the cache policy is
        /// not attached to a cache behavior, you can get the identifier using
        /// <code>ListCachePolicies</code>.</p>
        pub fn id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(inp);
            self
        }
        /// <p>The unique identifier for the cache policy. If the cache policy is attached to a
        /// distribution’s cache behavior, you can get the policy’s identifier using
        /// <code>ListDistributions</code> or <code>GetDistribution</code>. If the cache policy is
        /// not attached to a cache behavior, you can get the identifier using
        /// <code>ListCachePolicies</code>.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetCachePolicyConfig`.
    ///
    /// <p>Gets a cache policy configuration.</p>
    /// <p>To get a cache policy configuration, you must provide the policy’s identifier. If the cache
    /// policy is attached to a distribution’s cache behavior, you can get the policy’s
    /// identifier using <code>ListDistributions</code> or <code>GetDistribution</code>. If the
    /// cache policy is not attached to a cache behavior, you can get the identifier using
    /// <code>ListCachePolicies</code>.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetCachePolicyConfig<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_cache_policy_config_input::Builder,
    }
    impl<C, M, R> GetCachePolicyConfig<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetCachePolicyConfig`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetCachePolicyConfigOutput,
            aws_smithy_http::result::SdkError<crate::error::GetCachePolicyConfigError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetCachePolicyConfigInputOperationOutputAlias,
                crate::output::GetCachePolicyConfigOutput,
                crate::error::GetCachePolicyConfigError,
                crate::input::GetCachePolicyConfigInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier for the cache policy. If the cache policy is attached to a
        /// distribution’s cache behavior, you can get the policy’s identifier using
        /// <code>ListDistributions</code> or <code>GetDistribution</code>. If the cache policy is
        /// not attached to a cache behavior, you can get the identifier using
        /// <code>ListCachePolicies</code>.</p>
        pub fn id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(inp);
            self
        }
        /// <p>The unique identifier for the cache policy. If the cache policy is attached to a
        /// distribution’s cache behavior, you can get the policy’s identifier using
        /// <code>ListDistributions</code> or <code>GetDistribution</code>. If the cache policy is
        /// not attached to a cache behavior, you can get the identifier using
        /// <code>ListCachePolicies</code>.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetCloudFrontOriginAccessIdentity`.
    ///
    /// <p>Get the information about an origin access identity. </p>
    #[derive(std::fmt::Debug)]
    pub struct GetCloudFrontOriginAccessIdentity<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_cloud_front_origin_access_identity_input::Builder,
    }
    impl<C, M, R> GetCloudFrontOriginAccessIdentity<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetCloudFrontOriginAccessIdentity`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetCloudFrontOriginAccessIdentityOutput,
            aws_smithy_http::result::SdkError<crate::error::GetCloudFrontOriginAccessIdentityError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetCloudFrontOriginAccessIdentityInputOperationOutputAlias,
                crate::output::GetCloudFrontOriginAccessIdentityOutput,
                crate::error::GetCloudFrontOriginAccessIdentityError,
                crate::input::GetCloudFrontOriginAccessIdentityInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identity's ID.</p>
        pub fn id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(inp);
            self
        }
        /// <p>The identity's ID.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetCloudFrontOriginAccessIdentityConfig`.
    ///
    /// <p>Get the configuration information about an origin access identity. </p>
    #[derive(std::fmt::Debug)]
    pub struct GetCloudFrontOriginAccessIdentityConfig<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_cloud_front_origin_access_identity_config_input::Builder,
    }
    impl<C, M, R> GetCloudFrontOriginAccessIdentityConfig<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetCloudFrontOriginAccessIdentityConfig`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetCloudFrontOriginAccessIdentityConfigOutput,
            aws_smithy_http::result::SdkError<
                crate::error::GetCloudFrontOriginAccessIdentityConfigError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetCloudFrontOriginAccessIdentityConfigInputOperationOutputAlias,
                crate::output::GetCloudFrontOriginAccessIdentityConfigOutput,
                crate::error::GetCloudFrontOriginAccessIdentityConfigError,
                crate::input::GetCloudFrontOriginAccessIdentityConfigInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identity's ID. </p>
        pub fn id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(inp);
            self
        }
        /// <p>The identity's ID. </p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetDistribution`.
    ///
    /// <p>Get the information about a distribution.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetDistribution<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_distribution_input::Builder,
    }
    impl<C, M, R> GetDistribution<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetDistribution`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetDistributionOutput,
            aws_smithy_http::result::SdkError<crate::error::GetDistributionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetDistributionInputOperationOutputAlias,
                crate::output::GetDistributionOutput,
                crate::error::GetDistributionError,
                crate::input::GetDistributionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The distribution's ID. If the ID is empty, an empty distribution configuration is returned.</p>
        pub fn id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(inp);
            self
        }
        /// <p>The distribution's ID. If the ID is empty, an empty distribution configuration is returned.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetDistributionConfig`.
    ///
    /// <p>Get the configuration information about a distribution. </p>
    #[derive(std::fmt::Debug)]
    pub struct GetDistributionConfig<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_distribution_config_input::Builder,
    }
    impl<C, M, R> GetDistributionConfig<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetDistributionConfig`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetDistributionConfigOutput,
            aws_smithy_http::result::SdkError<crate::error::GetDistributionConfigError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetDistributionConfigInputOperationOutputAlias,
                crate::output::GetDistributionConfigOutput,
                crate::error::GetDistributionConfigError,
                crate::input::GetDistributionConfigInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The distribution's ID. If the ID is empty, an empty distribution configuration is returned.</p>
        pub fn id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(inp);
            self
        }
        /// <p>The distribution's ID. If the ID is empty, an empty distribution configuration is returned.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetFieldLevelEncryption`.
    ///
    /// <p>Get the field-level encryption configuration information.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetFieldLevelEncryption<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_field_level_encryption_input::Builder,
    }
    impl<C, M, R> GetFieldLevelEncryption<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetFieldLevelEncryption`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetFieldLevelEncryptionOutput,
            aws_smithy_http::result::SdkError<crate::error::GetFieldLevelEncryptionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetFieldLevelEncryptionInputOperationOutputAlias,
                crate::output::GetFieldLevelEncryptionOutput,
                crate::error::GetFieldLevelEncryptionError,
                crate::input::GetFieldLevelEncryptionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Request the ID for the field-level encryption configuration information.</p>
        pub fn id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(inp);
            self
        }
        /// <p>Request the ID for the field-level encryption configuration information.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetFieldLevelEncryptionConfig`.
    ///
    /// <p>Get the field-level encryption configuration information.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetFieldLevelEncryptionConfig<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_field_level_encryption_config_input::Builder,
    }
    impl<C, M, R> GetFieldLevelEncryptionConfig<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetFieldLevelEncryptionConfig`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetFieldLevelEncryptionConfigOutput,
            aws_smithy_http::result::SdkError<crate::error::GetFieldLevelEncryptionConfigError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetFieldLevelEncryptionConfigInputOperationOutputAlias,
                crate::output::GetFieldLevelEncryptionConfigOutput,
                crate::error::GetFieldLevelEncryptionConfigError,
                crate::input::GetFieldLevelEncryptionConfigInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Request the ID for the field-level encryption configuration information.</p>
        pub fn id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(inp);
            self
        }
        /// <p>Request the ID for the field-level encryption configuration information.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetFieldLevelEncryptionProfile`.
    ///
    /// <p>Get the field-level encryption profile information.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetFieldLevelEncryptionProfile<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_field_level_encryption_profile_input::Builder,
    }
    impl<C, M, R> GetFieldLevelEncryptionProfile<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetFieldLevelEncryptionProfile`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetFieldLevelEncryptionProfileOutput,
            aws_smithy_http::result::SdkError<crate::error::GetFieldLevelEncryptionProfileError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetFieldLevelEncryptionProfileInputOperationOutputAlias,
                crate::output::GetFieldLevelEncryptionProfileOutput,
                crate::error::GetFieldLevelEncryptionProfileError,
                crate::input::GetFieldLevelEncryptionProfileInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Get the ID for the field-level encryption profile information.</p>
        pub fn id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(inp);
            self
        }
        /// <p>Get the ID for the field-level encryption profile information.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetFieldLevelEncryptionProfileConfig`.
    ///
    /// <p>Get the field-level encryption profile configuration information.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetFieldLevelEncryptionProfileConfig<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_field_level_encryption_profile_config_input::Builder,
    }
    impl<C, M, R> GetFieldLevelEncryptionProfileConfig<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetFieldLevelEncryptionProfileConfig`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetFieldLevelEncryptionProfileConfigOutput,
            aws_smithy_http::result::SdkError<
                crate::error::GetFieldLevelEncryptionProfileConfigError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetFieldLevelEncryptionProfileConfigInputOperationOutputAlias,
                crate::output::GetFieldLevelEncryptionProfileConfigOutput,
                crate::error::GetFieldLevelEncryptionProfileConfigError,
                crate::input::GetFieldLevelEncryptionProfileConfigInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Get the ID for the field-level encryption profile configuration information.</p>
        pub fn id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(inp);
            self
        }
        /// <p>Get the ID for the field-level encryption profile configuration information.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetFunction`.
    ///
    /// <p>Gets the code of a CloudFront function. To get configuration information and metadata about
    /// a function, use <code>DescribeFunction</code>.</p>
    /// <p>To get a function’s code, you must provide the function’s name and stage. To get these
    /// values, you can use <code>ListFunctions</code>.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetFunction<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_function_input::Builder,
    }
    impl<C, M, R> GetFunction<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetFunction`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetFunctionOutput,
            aws_smithy_http::result::SdkError<crate::error::GetFunctionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetFunctionInputOperationOutputAlias,
                crate::output::GetFunctionOutput,
                crate::error::GetFunctionError,
                crate::input::GetFunctionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the function whose code you are getting.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name of the function whose code you are getting.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The function’s stage, either <code>DEVELOPMENT</code> or <code>LIVE</code>.</p>
        pub fn stage(mut self, inp: crate::model::FunctionStage) -> Self {
            self.inner = self.inner.stage(inp);
            self
        }
        /// <p>The function’s stage, either <code>DEVELOPMENT</code> or <code>LIVE</code>.</p>
        pub fn set_stage(
            mut self,
            input: std::option::Option<crate::model::FunctionStage>,
        ) -> Self {
            self.inner = self.inner.set_stage(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetInvalidation`.
    ///
    /// <p>Get the information about an invalidation. </p>
    #[derive(std::fmt::Debug)]
    pub struct GetInvalidation<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_invalidation_input::Builder,
    }
    impl<C, M, R> GetInvalidation<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetInvalidation`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetInvalidationOutput,
            aws_smithy_http::result::SdkError<crate::error::GetInvalidationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetInvalidationInputOperationOutputAlias,
                crate::output::GetInvalidationOutput,
                crate::error::GetInvalidationError,
                crate::input::GetInvalidationInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The distribution's ID.</p>
        pub fn distribution_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.distribution_id(inp);
            self
        }
        /// <p>The distribution's ID.</p>
        pub fn set_distribution_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_distribution_id(input);
            self
        }
        /// <p>The identifier for the invalidation request, for example,
        /// <code>IDFDVBD632BHDS5</code>.</p>
        pub fn id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(inp);
            self
        }
        /// <p>The identifier for the invalidation request, for example,
        /// <code>IDFDVBD632BHDS5</code>.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetKeyGroup`.
    ///
    /// <p>Gets a key group, including the date and time when the key group was last modified.</p>
    /// <p>To get a key group, you must provide the key group’s identifier. If the key group is
    /// referenced in a distribution’s cache behavior, you can get the key group’s identifier
    /// using <code>ListDistributions</code> or <code>GetDistribution</code>. If the key group
    /// is not referenced in a cache behavior, you can get the identifier using
    /// <code>ListKeyGroups</code>.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetKeyGroup<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_key_group_input::Builder,
    }
    impl<C, M, R> GetKeyGroup<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetKeyGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetKeyGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::GetKeyGroupError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetKeyGroupInputOperationOutputAlias,
                crate::output::GetKeyGroupOutput,
                crate::error::GetKeyGroupError,
                crate::input::GetKeyGroupInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the key group that you are getting. To get the identifier, use
        /// <code>ListKeyGroups</code>.</p>
        pub fn id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(inp);
            self
        }
        /// <p>The identifier of the key group that you are getting. To get the identifier, use
        /// <code>ListKeyGroups</code>.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetKeyGroupConfig`.
    ///
    /// <p>Gets a key group configuration.</p>
    /// <p>To get a key group configuration, you must provide the key group’s identifier. If the
    /// key group is referenced in a distribution’s cache behavior, you can get the key group’s
    /// identifier using <code>ListDistributions</code> or <code>GetDistribution</code>. If the
    /// key group is not referenced in a cache behavior, you can get the identifier using
    /// <code>ListKeyGroups</code>.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetKeyGroupConfig<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_key_group_config_input::Builder,
    }
    impl<C, M, R> GetKeyGroupConfig<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetKeyGroupConfig`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetKeyGroupConfigOutput,
            aws_smithy_http::result::SdkError<crate::error::GetKeyGroupConfigError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetKeyGroupConfigInputOperationOutputAlias,
                crate::output::GetKeyGroupConfigOutput,
                crate::error::GetKeyGroupConfigError,
                crate::input::GetKeyGroupConfigInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the key group whose configuration you are getting. To get the
        /// identifier, use <code>ListKeyGroups</code>.</p>
        pub fn id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(inp);
            self
        }
        /// <p>The identifier of the key group whose configuration you are getting. To get the
        /// identifier, use <code>ListKeyGroups</code>.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetMonitoringSubscription`.
    ///
    /// <p>Gets information about whether additional CloudWatch metrics are enabled for the specified
    /// CloudFront distribution.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetMonitoringSubscription<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_monitoring_subscription_input::Builder,
    }
    impl<C, M, R> GetMonitoringSubscription<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetMonitoringSubscription`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetMonitoringSubscriptionOutput,
            aws_smithy_http::result::SdkError<crate::error::GetMonitoringSubscriptionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetMonitoringSubscriptionInputOperationOutputAlias,
                crate::output::GetMonitoringSubscriptionOutput,
                crate::error::GetMonitoringSubscriptionError,
                crate::input::GetMonitoringSubscriptionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the distribution that you are getting metrics information for.</p>
        pub fn distribution_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.distribution_id(inp);
            self
        }
        /// <p>The ID of the distribution that you are getting metrics information for.</p>
        pub fn set_distribution_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_distribution_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetOriginRequestPolicy`.
    ///
    /// <p>Gets an origin request policy, including the following metadata:</p>
    /// <ul>
    /// <li>
    /// <p>The policy’s identifier.</p>
    /// </li>
    /// <li>
    /// <p>The date and time when the policy was last modified.</p>
    /// </li>
    /// </ul>
    /// <p>To get an origin request policy, you must provide the policy’s identifier. If the origin
    /// request policy is attached to a distribution’s cache behavior, you can get the policy’s
    /// identifier using <code>ListDistributions</code> or <code>GetDistribution</code>. If the
    /// origin request policy is not attached to a cache behavior, you can get the identifier
    /// using <code>ListOriginRequestPolicies</code>.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetOriginRequestPolicy<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_origin_request_policy_input::Builder,
    }
    impl<C, M, R> GetOriginRequestPolicy<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetOriginRequestPolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetOriginRequestPolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::GetOriginRequestPolicyError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetOriginRequestPolicyInputOperationOutputAlias,
                crate::output::GetOriginRequestPolicyOutput,
                crate::error::GetOriginRequestPolicyError,
                crate::input::GetOriginRequestPolicyInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier for the origin request policy. If the origin request policy is
        /// attached to a distribution’s cache behavior, you can get the policy’s identifier using
        /// <code>ListDistributions</code> or <code>GetDistribution</code>. If the origin request
        /// policy is not attached to a cache behavior, you can get the identifier using
        /// <code>ListOriginRequestPolicies</code>.</p>
        pub fn id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(inp);
            self
        }
        /// <p>The unique identifier for the origin request policy. If the origin request policy is
        /// attached to a distribution’s cache behavior, you can get the policy’s identifier using
        /// <code>ListDistributions</code> or <code>GetDistribution</code>. If the origin request
        /// policy is not attached to a cache behavior, you can get the identifier using
        /// <code>ListOriginRequestPolicies</code>.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetOriginRequestPolicyConfig`.
    ///
    /// <p>Gets an origin request policy configuration.</p>
    /// <p>To get an origin request policy configuration, you must provide the policy’s identifier. If
    /// the origin request policy is attached to a distribution’s cache behavior, you can get
    /// the policy’s identifier using <code>ListDistributions</code> or
    /// <code>GetDistribution</code>. If the origin request policy is not attached to a cache
    /// behavior, you can get the identifier using
    /// <code>ListOriginRequestPolicies</code>.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetOriginRequestPolicyConfig<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_origin_request_policy_config_input::Builder,
    }
    impl<C, M, R> GetOriginRequestPolicyConfig<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetOriginRequestPolicyConfig`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetOriginRequestPolicyConfigOutput,
            aws_smithy_http::result::SdkError<crate::error::GetOriginRequestPolicyConfigError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetOriginRequestPolicyConfigInputOperationOutputAlias,
                crate::output::GetOriginRequestPolicyConfigOutput,
                crate::error::GetOriginRequestPolicyConfigError,
                crate::input::GetOriginRequestPolicyConfigInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier for the origin request policy. If the origin request policy is
        /// attached to a distribution’s cache behavior, you can get the policy’s identifier using
        /// <code>ListDistributions</code> or <code>GetDistribution</code>. If the origin request
        /// policy is not attached to a cache behavior, you can get the identifier using
        /// <code>ListOriginRequestPolicies</code>.</p>
        pub fn id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(inp);
            self
        }
        /// <p>The unique identifier for the origin request policy. If the origin request policy is
        /// attached to a distribution’s cache behavior, you can get the policy’s identifier using
        /// <code>ListDistributions</code> or <code>GetDistribution</code>. If the origin request
        /// policy is not attached to a cache behavior, you can get the identifier using
        /// <code>ListOriginRequestPolicies</code>.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetPublicKey`.
    ///
    /// <p>Gets a public key.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetPublicKey<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_public_key_input::Builder,
    }
    impl<C, M, R> GetPublicKey<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetPublicKey`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetPublicKeyOutput,
            aws_smithy_http::result::SdkError<crate::error::GetPublicKeyError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetPublicKeyInputOperationOutputAlias,
                crate::output::GetPublicKeyOutput,
                crate::error::GetPublicKeyError,
                crate::input::GetPublicKeyInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the public key you are getting.</p>
        pub fn id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(inp);
            self
        }
        /// <p>The identifier of the public key you are getting.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetPublicKeyConfig`.
    ///
    /// <p>Gets a public key configuration.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetPublicKeyConfig<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_public_key_config_input::Builder,
    }
    impl<C, M, R> GetPublicKeyConfig<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetPublicKeyConfig`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetPublicKeyConfigOutput,
            aws_smithy_http::result::SdkError<crate::error::GetPublicKeyConfigError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetPublicKeyConfigInputOperationOutputAlias,
                crate::output::GetPublicKeyConfigOutput,
                crate::error::GetPublicKeyConfigError,
                crate::input::GetPublicKeyConfigInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the public key whose configuration you are getting.</p>
        pub fn id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(inp);
            self
        }
        /// <p>The identifier of the public key whose configuration you are getting.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetRealtimeLogConfig`.
    ///
    /// <p>Gets a real-time log configuration.</p>
    /// <p>To get a real-time log configuration, you can provide the configuration’s name or its Amazon
    /// Resource Name (ARN). You must provide at least one. If you provide both, CloudFront uses the
    /// name to identify the real-time log configuration to get.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetRealtimeLogConfig<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_realtime_log_config_input::Builder,
    }
    impl<C, M, R> GetRealtimeLogConfig<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetRealtimeLogConfig`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetRealtimeLogConfigOutput,
            aws_smithy_http::result::SdkError<crate::error::GetRealtimeLogConfigError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetRealtimeLogConfigInputOperationOutputAlias,
                crate::output::GetRealtimeLogConfigOutput,
                crate::error::GetRealtimeLogConfigError,
                crate::input::GetRealtimeLogConfigInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the real-time log configuration to get.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name of the real-time log configuration to get.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the real-time log configuration to get.</p>
        pub fn arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the real-time log configuration to get.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetResponseHeadersPolicy`.
    ///
    /// <p>Gets a response headers policy, including metadata (the policy’s identifier and the date and
    /// time when the policy was last modified).</p>
    /// <p>To get a response headers policy, you must provide the policy’s identifier. If the
    /// response headers policy is attached to a distribution’s cache behavior, you can get the
    /// policy’s identifier using <code>ListDistributions</code> or
    /// <code>GetDistribution</code>. If the response headers policy is not attached to a cache
    /// behavior, you can get the identifier using
    /// <code>ListResponseHeadersPolicies</code>.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetResponseHeadersPolicy<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_response_headers_policy_input::Builder,
    }
    impl<C, M, R> GetResponseHeadersPolicy<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetResponseHeadersPolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetResponseHeadersPolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::GetResponseHeadersPolicyError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetResponseHeadersPolicyInputOperationOutputAlias,
                crate::output::GetResponseHeadersPolicyOutput,
                crate::error::GetResponseHeadersPolicyError,
                crate::input::GetResponseHeadersPolicyInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier for the response headers policy.</p>
        /// <p>If the response headers policy is attached to a distribution’s cache behavior, you can
        /// get the policy’s identifier using <code>ListDistributions</code> or
        /// <code>GetDistribution</code>. If the response headers policy is not attached to a
        /// cache behavior, you can get the identifier using
        /// <code>ListResponseHeadersPolicies</code>.</p>
        pub fn id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(inp);
            self
        }
        /// <p>The identifier for the response headers policy.</p>
        /// <p>If the response headers policy is attached to a distribution’s cache behavior, you can
        /// get the policy’s identifier using <code>ListDistributions</code> or
        /// <code>GetDistribution</code>. If the response headers policy is not attached to a
        /// cache behavior, you can get the identifier using
        /// <code>ListResponseHeadersPolicies</code>.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetResponseHeadersPolicyConfig`.
    ///
    /// <p>Gets a response headers policy configuration.</p>
    /// <p>To get a response headers policy configuration, you must provide the policy’s
    /// identifier. If the response headers policy is attached to a distribution’s cache
    /// behavior, you can get the policy’s identifier using <code>ListDistributions</code> or
    /// <code>GetDistribution</code>. If the response headers policy is not attached to a
    /// cache behavior, you can get the identifier using
    /// <code>ListResponseHeadersPolicies</code>.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetResponseHeadersPolicyConfig<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_response_headers_policy_config_input::Builder,
    }
    impl<C, M, R> GetResponseHeadersPolicyConfig<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetResponseHeadersPolicyConfig`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetResponseHeadersPolicyConfigOutput,
            aws_smithy_http::result::SdkError<crate::error::GetResponseHeadersPolicyConfigError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetResponseHeadersPolicyConfigInputOperationOutputAlias,
                crate::output::GetResponseHeadersPolicyConfigOutput,
                crate::error::GetResponseHeadersPolicyConfigError,
                crate::input::GetResponseHeadersPolicyConfigInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier for the response headers policy.</p>
        /// <p>If the response headers policy is attached to a distribution’s cache behavior, you can
        /// get the policy’s identifier using <code>ListDistributions</code> or
        /// <code>GetDistribution</code>. If the response headers policy is not attached to a
        /// cache behavior, you can get the identifier using
        /// <code>ListResponseHeadersPolicies</code>.</p>
        pub fn id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(inp);
            self
        }
        /// <p>The identifier for the response headers policy.</p>
        /// <p>If the response headers policy is attached to a distribution’s cache behavior, you can
        /// get the policy’s identifier using <code>ListDistributions</code> or
        /// <code>GetDistribution</code>. If the response headers policy is not attached to a
        /// cache behavior, you can get the identifier using
        /// <code>ListResponseHeadersPolicies</code>.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetStreamingDistribution`.
    ///
    /// <p>Gets information about a specified RTMP distribution, including the distribution configuration.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetStreamingDistribution<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_streaming_distribution_input::Builder,
    }
    impl<C, M, R> GetStreamingDistribution<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetStreamingDistribution`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetStreamingDistributionOutput,
            aws_smithy_http::result::SdkError<crate::error::GetStreamingDistributionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetStreamingDistributionInputOperationOutputAlias,
                crate::output::GetStreamingDistributionOutput,
                crate::error::GetStreamingDistributionError,
                crate::input::GetStreamingDistributionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The streaming distribution's ID.</p>
        pub fn id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(inp);
            self
        }
        /// <p>The streaming distribution's ID.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetStreamingDistributionConfig`.
    ///
    /// <p>Get the configuration information about a streaming distribution. </p>
    #[derive(std::fmt::Debug)]
    pub struct GetStreamingDistributionConfig<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_streaming_distribution_config_input::Builder,
    }
    impl<C, M, R> GetStreamingDistributionConfig<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetStreamingDistributionConfig`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetStreamingDistributionConfigOutput,
            aws_smithy_http::result::SdkError<crate::error::GetStreamingDistributionConfigError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetStreamingDistributionConfigInputOperationOutputAlias,
                crate::output::GetStreamingDistributionConfigOutput,
                crate::error::GetStreamingDistributionConfigError,
                crate::input::GetStreamingDistributionConfigInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The streaming distribution's ID.</p>
        pub fn id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(inp);
            self
        }
        /// <p>The streaming distribution's ID.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListCachePolicies`.
    ///
    /// <p>Gets a list of cache policies.</p>
    /// <p>You can optionally apply a filter to return only the managed policies created by Amazon Web Services, or
    /// only the custom policies created in your Amazon Web Services account.</p>
    /// <p>You can optionally specify the maximum number of items to receive in the response. If
    /// the total number of items in the list exceeds the maximum that you specify, or the
    /// default maximum, the response is paginated. To get the next page of items, send a
    /// subsequent request that specifies the <code>NextMarker</code> value from the current
    /// response as the <code>Marker</code> value in the subsequent request.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListCachePolicies<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_cache_policies_input::Builder,
    }
    impl<C, M, R> ListCachePolicies<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListCachePolicies`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListCachePoliciesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListCachePoliciesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListCachePoliciesInputOperationOutputAlias,
                crate::output::ListCachePoliciesOutput,
                crate::error::ListCachePoliciesError,
                crate::input::ListCachePoliciesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A filter to return only the specified kinds of cache policies. Valid values
        /// are:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>managed</code> – Returns only the managed policies created by Amazon Web Services.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>custom</code> – Returns only the custom policies created in your Amazon Web Services account.</p>
        /// </li>
        /// </ul>
        pub fn r#type(mut self, inp: crate::model::CachePolicyType) -> Self {
            self.inner = self.inner.r#type(inp);
            self
        }
        /// <p>A filter to return only the specified kinds of cache policies. Valid values
        /// are:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>managed</code> – Returns only the managed policies created by Amazon Web Services.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>custom</code> – Returns only the custom policies created in your Amazon Web Services account.</p>
        /// </li>
        /// </ul>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::CachePolicyType>,
        ) -> Self {
            self.inner = self.inner.set_type(input);
            self
        }
        /// <p>Use this field when paginating results to indicate where to begin in your list of
        /// cache policies. The response includes cache policies in the list that occur after the
        /// marker. To get the next page of the list, set this field’s value to the value of
        /// <code>NextMarker</code> from the current page’s response.</p>
        pub fn marker(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(inp);
            self
        }
        /// <p>Use this field when paginating results to indicate where to begin in your list of
        /// cache policies. The response includes cache policies in the list that occur after the
        /// marker. To get the next page of the list, set this field’s value to the value of
        /// <code>NextMarker</code> from the current page’s response.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
        /// <p>The maximum number of cache policies that you want in the response.</p>
        pub fn max_items(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_items(inp);
            self
        }
        /// <p>The maximum number of cache policies that you want in the response.</p>
        pub fn set_max_items(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_items(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListCloudFrontOriginAccessIdentities`.
    ///
    /// <p>Lists origin access identities.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListCloudFrontOriginAccessIdentities<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_cloud_front_origin_access_identities_input::Builder,
    }
    impl<C, M, R> ListCloudFrontOriginAccessIdentities<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListCloudFrontOriginAccessIdentities`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListCloudFrontOriginAccessIdentitiesOutput,
            aws_smithy_http::result::SdkError<
                crate::error::ListCloudFrontOriginAccessIdentitiesError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListCloudFrontOriginAccessIdentitiesInputOperationOutputAlias,
                crate::output::ListCloudFrontOriginAccessIdentitiesOutput,
                crate::error::ListCloudFrontOriginAccessIdentitiesError,
                crate::input::ListCloudFrontOriginAccessIdentitiesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Use this when paginating results to indicate where to begin in your list of origin
        /// access identities. The results include identities in the list that occur after the marker. To
        /// get the next page of results, set the <code>Marker</code> to the value of the
        /// <code>NextMarker</code> from the current page's response (which is also the ID of the last
        /// identity on that page).</p>
        pub fn marker(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(inp);
            self
        }
        /// <p>Use this when paginating results to indicate where to begin in your list of origin
        /// access identities. The results include identities in the list that occur after the marker. To
        /// get the next page of results, set the <code>Marker</code> to the value of the
        /// <code>NextMarker</code> from the current page's response (which is also the ID of the last
        /// identity on that page).</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
        /// <p>The maximum number of origin access identities you want in the response body.
        /// </p>
        pub fn max_items(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_items(inp);
            self
        }
        /// <p>The maximum number of origin access identities you want in the response body.
        /// </p>
        pub fn set_max_items(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_items(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListConflictingAliases`.
    ///
    /// <p>Gets a list of aliases (also called CNAMEs or alternate domain names) that conflict or
    /// overlap with the provided alias, and the associated CloudFront distributions and Amazon Web Services
    /// accounts for each conflicting alias. In the returned list, the distribution and account
    /// IDs are partially hidden, which allows you to identify the distributions and accounts
    /// that you own, but helps to protect the information of ones that you don’t own.</p>
    /// <p>Use this operation to find aliases that are in use in CloudFront that conflict or overlap
    /// with the provided alias. For example, if you provide <code>www.example.com</code> as
    /// input, the returned list can include <code>www.example.com</code> and the overlapping
    /// wildcard alternate domain name (<code>*.example.com</code>), if they exist. If you
    /// provide <code>*.example.com</code> as input, the returned list can include
    /// <code>*.example.com</code> and any alternate domain names covered by that wildcard (for
    /// example, <code>www.example.com</code>, <code>test.example.com</code>,
    /// <code>dev.example.com</code>, and so on), if they exist.</p>
    /// <p>To list conflicting aliases, you provide the alias to search and the ID of a distribution in
    /// your account that has an attached SSL/TLS certificate that includes the provided alias.
    /// For more information, including how to set up the distribution and certificate, see
    /// <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/CNAMEs.html#alternate-domain-names-move">Moving an alternate domain name to a different distribution</a>
    /// in the <i>Amazon CloudFront Developer Guide</i>.</p>
    /// <p>You can optionally specify the maximum number of items to receive in the response. If
    /// the total number of items in the list exceeds the maximum that you specify, or the
    /// default maximum, the response is paginated. To get the next page of items, send a
    /// subsequent request that specifies the <code>NextMarker</code> value from the current
    /// response as the <code>Marker</code> value in the subsequent request.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListConflictingAliases<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_conflicting_aliases_input::Builder,
    }
    impl<C, M, R> ListConflictingAliases<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListConflictingAliases`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListConflictingAliasesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListConflictingAliasesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListConflictingAliasesInputOperationOutputAlias,
                crate::output::ListConflictingAliasesOutput,
                crate::error::ListConflictingAliasesError,
                crate::input::ListConflictingAliasesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of a distribution in your account that has an attached SSL/TLS certificate that
        /// includes the provided alias.</p>
        pub fn distribution_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.distribution_id(inp);
            self
        }
        /// <p>The ID of a distribution in your account that has an attached SSL/TLS certificate that
        /// includes the provided alias.</p>
        pub fn set_distribution_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_distribution_id(input);
            self
        }
        /// <p>The alias (also called a CNAME) to search for conflicting aliases.</p>
        pub fn alias(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.alias(inp);
            self
        }
        /// <p>The alias (also called a CNAME) to search for conflicting aliases.</p>
        pub fn set_alias(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_alias(input);
            self
        }
        /// <p>Use this field when paginating results to indicate where to begin in the list of
        /// conflicting aliases. The response includes conflicting aliases in the list that occur
        /// after the marker. To get the next page of the list, set this field’s value to the value
        /// of <code>NextMarker</code> from the current page’s response.</p>
        pub fn marker(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(inp);
            self
        }
        /// <p>Use this field when paginating results to indicate where to begin in the list of
        /// conflicting aliases. The response includes conflicting aliases in the list that occur
        /// after the marker. To get the next page of the list, set this field’s value to the value
        /// of <code>NextMarker</code> from the current page’s response.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
        /// <p>The maximum number of conflicting aliases that you want in the response.</p>
        pub fn max_items(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_items(inp);
            self
        }
        /// <p>The maximum number of conflicting aliases that you want in the response.</p>
        pub fn set_max_items(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_items(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListDistributions`.
    ///
    /// <p>List CloudFront distributions.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListDistributions<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_distributions_input::Builder,
    }
    impl<C, M, R> ListDistributions<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListDistributions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListDistributionsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListDistributionsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListDistributionsInputOperationOutputAlias,
                crate::output::ListDistributionsOutput,
                crate::error::ListDistributionsError,
                crate::input::ListDistributionsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Use this when paginating results to indicate where to begin in your list of
        /// distributions. The results include distributions in the list that occur after the marker. To
        /// get the next page of results, set the <code>Marker</code> to the value of the
        /// <code>NextMarker</code> from the current page's response (which is also the ID of the last
        /// distribution on that page).</p>
        pub fn marker(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(inp);
            self
        }
        /// <p>Use this when paginating results to indicate where to begin in your list of
        /// distributions. The results include distributions in the list that occur after the marker. To
        /// get the next page of results, set the <code>Marker</code> to the value of the
        /// <code>NextMarker</code> from the current page's response (which is also the ID of the last
        /// distribution on that page).</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
        /// <p>The maximum number of distributions you want in the response body.</p>
        pub fn max_items(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_items(inp);
            self
        }
        /// <p>The maximum number of distributions you want in the response body.</p>
        pub fn set_max_items(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_items(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListDistributionsByCachePolicyId`.
    ///
    /// <p>Gets a list of distribution IDs for distributions that have a cache behavior that’s
    /// associated with the specified cache policy.</p>
    /// <p>You can optionally specify the maximum number of items to receive in the response. If
    /// the total number of items in the list exceeds the maximum that you specify, or the
    /// default maximum, the response is paginated. To get the next page of items, send a
    /// subsequent request that specifies the <code>NextMarker</code> value from the current
    /// response as the <code>Marker</code> value in the subsequent request.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListDistributionsByCachePolicyId<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_distributions_by_cache_policy_id_input::Builder,
    }
    impl<C, M, R> ListDistributionsByCachePolicyId<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListDistributionsByCachePolicyId`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListDistributionsByCachePolicyIdOutput,
            aws_smithy_http::result::SdkError<crate::error::ListDistributionsByCachePolicyIdError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListDistributionsByCachePolicyIdInputOperationOutputAlias,
                crate::output::ListDistributionsByCachePolicyIdOutput,
                crate::error::ListDistributionsByCachePolicyIdError,
                crate::input::ListDistributionsByCachePolicyIdInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Use this field when paginating results to indicate where to begin in your list of
        /// distribution IDs. The response includes distribution IDs in the list that occur after
        /// the marker. To get the next page of the list, set this field’s value to the value of
        /// <code>NextMarker</code> from the current page’s response.</p>
        pub fn marker(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(inp);
            self
        }
        /// <p>Use this field when paginating results to indicate where to begin in your list of
        /// distribution IDs. The response includes distribution IDs in the list that occur after
        /// the marker. To get the next page of the list, set this field’s value to the value of
        /// <code>NextMarker</code> from the current page’s response.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
        /// <p>The maximum number of distribution IDs that you want in the response.</p>
        pub fn max_items(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_items(inp);
            self
        }
        /// <p>The maximum number of distribution IDs that you want in the response.</p>
        pub fn set_max_items(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_items(input);
            self
        }
        /// <p>The ID of the cache policy whose associated distribution IDs you want to list.</p>
        pub fn cache_policy_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cache_policy_id(inp);
            self
        }
        /// <p>The ID of the cache policy whose associated distribution IDs you want to list.</p>
        pub fn set_cache_policy_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_cache_policy_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListDistributionsByKeyGroup`.
    ///
    /// <p>Gets a list of distribution IDs for distributions that have a cache behavior that references
    /// the specified key group.</p>
    /// <p>You can optionally specify the maximum number of items to receive in the response. If
    /// the total number of items in the list exceeds the maximum that you specify, or the
    /// default maximum, the response is paginated. To get the next page of items, send a
    /// subsequent request that specifies the <code>NextMarker</code> value from the current
    /// response as the <code>Marker</code> value in the subsequent request.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListDistributionsByKeyGroup<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_distributions_by_key_group_input::Builder,
    }
    impl<C, M, R> ListDistributionsByKeyGroup<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListDistributionsByKeyGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListDistributionsByKeyGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::ListDistributionsByKeyGroupError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListDistributionsByKeyGroupInputOperationOutputAlias,
                crate::output::ListDistributionsByKeyGroupOutput,
                crate::error::ListDistributionsByKeyGroupError,
                crate::input::ListDistributionsByKeyGroupInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Use this field when paginating results to indicate where to begin in your list of
        /// distribution IDs. The response includes distribution IDs in the list that occur after
        /// the marker. To get the next page of the list, set this field’s value to the value of
        /// <code>NextMarker</code> from the current page’s response.</p>
        pub fn marker(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(inp);
            self
        }
        /// <p>Use this field when paginating results to indicate where to begin in your list of
        /// distribution IDs. The response includes distribution IDs in the list that occur after
        /// the marker. To get the next page of the list, set this field’s value to the value of
        /// <code>NextMarker</code> from the current page’s response.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
        /// <p>The maximum number of distribution IDs that you want in the response.</p>
        pub fn max_items(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_items(inp);
            self
        }
        /// <p>The maximum number of distribution IDs that you want in the response.</p>
        pub fn set_max_items(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_items(input);
            self
        }
        /// <p>The ID of the key group whose associated distribution IDs you are listing.</p>
        pub fn key_group_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.key_group_id(inp);
            self
        }
        /// <p>The ID of the key group whose associated distribution IDs you are listing.</p>
        pub fn set_key_group_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_key_group_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListDistributionsByOriginRequestPolicyId`.
    ///
    /// <p>Gets a list of distribution IDs for distributions that have a cache behavior that’s
    /// associated with the specified origin request policy.</p>
    /// <p>You can optionally specify the maximum number of items to receive in the response. If
    /// the total number of items in the list exceeds the maximum that you specify, or the
    /// default maximum, the response is paginated. To get the next page of items, send a
    /// subsequent request that specifies the <code>NextMarker</code> value from the current
    /// response as the <code>Marker</code> value in the subsequent request.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListDistributionsByOriginRequestPolicyId<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_distributions_by_origin_request_policy_id_input::Builder,
    }
    impl<C, M, R> ListDistributionsByOriginRequestPolicyId<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListDistributionsByOriginRequestPolicyId`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListDistributionsByOriginRequestPolicyIdOutput,
            aws_smithy_http::result::SdkError<
                crate::error::ListDistributionsByOriginRequestPolicyIdError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListDistributionsByOriginRequestPolicyIdInputOperationOutputAlias,
                crate::output::ListDistributionsByOriginRequestPolicyIdOutput,
                crate::error::ListDistributionsByOriginRequestPolicyIdError,
                crate::input::ListDistributionsByOriginRequestPolicyIdInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Use this field when paginating results to indicate where to begin in your list of
        /// distribution IDs. The response includes distribution IDs in the list that occur after
        /// the marker. To get the next page of the list, set this field’s value to the value of
        /// <code>NextMarker</code> from the current page’s response.</p>
        pub fn marker(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(inp);
            self
        }
        /// <p>Use this field when paginating results to indicate where to begin in your list of
        /// distribution IDs. The response includes distribution IDs in the list that occur after
        /// the marker. To get the next page of the list, set this field’s value to the value of
        /// <code>NextMarker</code> from the current page’s response.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
        /// <p>The maximum number of distribution IDs that you want in the response.</p>
        pub fn max_items(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_items(inp);
            self
        }
        /// <p>The maximum number of distribution IDs that you want in the response.</p>
        pub fn set_max_items(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_items(input);
            self
        }
        /// <p>The ID of the origin request policy whose associated distribution IDs you want to
        /// list.</p>
        pub fn origin_request_policy_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.origin_request_policy_id(inp);
            self
        }
        /// <p>The ID of the origin request policy whose associated distribution IDs you want to
        /// list.</p>
        pub fn set_origin_request_policy_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_origin_request_policy_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListDistributionsByRealtimeLogConfig`.
    ///
    /// <p>Gets a list of distributions that have a cache behavior that’s associated with the specified
    /// real-time log configuration.</p>
    /// <p>You can specify the real-time log configuration by its name or its Amazon Resource Name
    /// (ARN). You must provide at least one. If you provide both, CloudFront uses the name to
    /// identify the real-time log configuration to list distributions for.</p>
    /// <p>You can optionally specify the maximum number of items to receive in the response. If
    /// the total number of items in the list exceeds the maximum that you specify, or the
    /// default maximum, the response is paginated. To get the next page of items, send a
    /// subsequent request that specifies the <code>NextMarker</code> value from the current
    /// response as the <code>Marker</code> value in the subsequent request. </p>
    #[derive(std::fmt::Debug)]
    pub struct ListDistributionsByRealtimeLogConfig<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_distributions_by_realtime_log_config_input::Builder,
    }
    impl<C, M, R> ListDistributionsByRealtimeLogConfig<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListDistributionsByRealtimeLogConfig`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListDistributionsByRealtimeLogConfigOutput,
            aws_smithy_http::result::SdkError<
                crate::error::ListDistributionsByRealtimeLogConfigError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListDistributionsByRealtimeLogConfigInputOperationOutputAlias,
                crate::output::ListDistributionsByRealtimeLogConfigOutput,
                crate::error::ListDistributionsByRealtimeLogConfigError,
                crate::input::ListDistributionsByRealtimeLogConfigInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Use this field when paginating results to indicate where to begin in your list of
        /// distributions. The response includes distributions in the list that occur after the
        /// marker. To get the next page of the list, set this field’s value to the value of
        /// <code>NextMarker</code> from the current page’s response.</p>
        pub fn marker(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(inp);
            self
        }
        /// <p>Use this field when paginating results to indicate where to begin in your list of
        /// distributions. The response includes distributions in the list that occur after the
        /// marker. To get the next page of the list, set this field’s value to the value of
        /// <code>NextMarker</code> from the current page’s response.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
        /// <p>The maximum number of distributions that you want in the response.</p>
        pub fn max_items(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_items(inp);
            self
        }
        /// <p>The maximum number of distributions that you want in the response.</p>
        pub fn set_max_items(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_items(input);
            self
        }
        /// <p>The name of the real-time log configuration whose associated distributions you want to
        /// list.</p>
        pub fn realtime_log_config_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.realtime_log_config_name(inp);
            self
        }
        /// <p>The name of the real-time log configuration whose associated distributions you want to
        /// list.</p>
        pub fn set_realtime_log_config_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_realtime_log_config_name(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the real-time log configuration whose associated
        /// distributions you want to list.</p>
        pub fn realtime_log_config_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.realtime_log_config_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the real-time log configuration whose associated
        /// distributions you want to list.</p>
        pub fn set_realtime_log_config_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_realtime_log_config_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListDistributionsByResponseHeadersPolicyId`.
    ///
    /// <p>Gets a list of distribution IDs for distributions that have a cache behavior that’s
    /// associated with the specified response headers policy.</p>
    /// <p>You can optionally specify the maximum number of items to receive in the response. If
    /// the total number of items in the list exceeds the maximum that you specify, or the
    /// default maximum, the response is paginated. To get the next page of items, send a
    /// subsequent request that specifies the <code>NextMarker</code> value from the current
    /// response as the <code>Marker</code> value in the subsequent request.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListDistributionsByResponseHeadersPolicyId<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_distributions_by_response_headers_policy_id_input::Builder,
    }
    impl<C, M, R> ListDistributionsByResponseHeadersPolicyId<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListDistributionsByResponseHeadersPolicyId`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListDistributionsByResponseHeadersPolicyIdOutput,
            aws_smithy_http::result::SdkError<
                crate::error::ListDistributionsByResponseHeadersPolicyIdError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListDistributionsByResponseHeadersPolicyIdInputOperationOutputAlias,
                crate::output::ListDistributionsByResponseHeadersPolicyIdOutput,
                crate::error::ListDistributionsByResponseHeadersPolicyIdError,
                crate::input::ListDistributionsByResponseHeadersPolicyIdInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Use this field when paginating results to indicate where to begin in your list of
        /// distribution IDs. The response includes distribution IDs in the list that occur after
        /// the marker. To get the next page of the list, set this field’s value to the value of
        /// <code>NextMarker</code> from the current page’s response.</p>
        pub fn marker(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(inp);
            self
        }
        /// <p>Use this field when paginating results to indicate where to begin in your list of
        /// distribution IDs. The response includes distribution IDs in the list that occur after
        /// the marker. To get the next page of the list, set this field’s value to the value of
        /// <code>NextMarker</code> from the current page’s response.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
        /// <p>The maximum number of distribution IDs that you want to get in the response.</p>
        pub fn max_items(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_items(inp);
            self
        }
        /// <p>The maximum number of distribution IDs that you want to get in the response.</p>
        pub fn set_max_items(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_items(input);
            self
        }
        /// <p>The ID of the response headers policy whose associated distribution IDs you want to
        /// list.</p>
        pub fn response_headers_policy_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.response_headers_policy_id(inp);
            self
        }
        /// <p>The ID of the response headers policy whose associated distribution IDs you want to
        /// list.</p>
        pub fn set_response_headers_policy_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_response_headers_policy_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListDistributionsByWebACLId`.
    ///
    /// <p>List the distributions that are associated with a specified WAF web ACL.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListDistributionsByWebACLId<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_distributions_by_web_acl_id_input::Builder,
    }
    impl<C, M, R> ListDistributionsByWebACLId<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListDistributionsByWebACLId`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListDistributionsByWebAclIdOutput,
            aws_smithy_http::result::SdkError<crate::error::ListDistributionsByWebACLIdError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListDistributionsByWebAclIdInputOperationOutputAlias,
                crate::output::ListDistributionsByWebAclIdOutput,
                crate::error::ListDistributionsByWebACLIdError,
                crate::input::ListDistributionsByWebAclIdInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Use <code>Marker</code> and <code>MaxItems</code> to control pagination of results. If
        /// you have more than <code>MaxItems</code> distributions that satisfy the request, the response
        /// includes a <code>NextMarker</code> element. To get the next page of results, submit another
        /// request. For the value of <code>Marker</code>, specify the value of <code>NextMarker</code>
        /// from the last response. (For the first request, omit <code>Marker</code>.) </p>
        pub fn marker(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(inp);
            self
        }
        /// <p>Use <code>Marker</code> and <code>MaxItems</code> to control pagination of results. If
        /// you have more than <code>MaxItems</code> distributions that satisfy the request, the response
        /// includes a <code>NextMarker</code> element. To get the next page of results, submit another
        /// request. For the value of <code>Marker</code>, specify the value of <code>NextMarker</code>
        /// from the last response. (For the first request, omit <code>Marker</code>.) </p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
        /// <p>The maximum number of distributions that you want CloudFront to return in the response body.
        /// The maximum and default values are both 100.</p>
        pub fn max_items(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_items(inp);
            self
        }
        /// <p>The maximum number of distributions that you want CloudFront to return in the response body.
        /// The maximum and default values are both 100.</p>
        pub fn set_max_items(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_items(input);
            self
        }
        /// <p>The ID of the WAF web ACL that you want to list the associated distributions.
        /// If you specify "null" for the ID, the request returns a list of the distributions that aren't
        /// associated with a web ACL.</p>
        pub fn web_acl_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.web_acl_id(inp);
            self
        }
        /// <p>The ID of the WAF web ACL that you want to list the associated distributions.
        /// If you specify "null" for the ID, the request returns a list of the distributions that aren't
        /// associated with a web ACL.</p>
        pub fn set_web_acl_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_web_acl_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListFieldLevelEncryptionConfigs`.
    ///
    /// <p>List all field-level encryption configurations that have been created in CloudFront for this account.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListFieldLevelEncryptionConfigs<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_field_level_encryption_configs_input::Builder,
    }
    impl<C, M, R> ListFieldLevelEncryptionConfigs<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListFieldLevelEncryptionConfigs`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListFieldLevelEncryptionConfigsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListFieldLevelEncryptionConfigsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListFieldLevelEncryptionConfigsInputOperationOutputAlias,
                crate::output::ListFieldLevelEncryptionConfigsOutput,
                crate::error::ListFieldLevelEncryptionConfigsError,
                crate::input::ListFieldLevelEncryptionConfigsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Use this when paginating results to indicate where to begin in your list of configurations. The results include configurations in the list that
        /// occur after the marker. To get the next page of results, set the <code>Marker</code> to the value of the
        /// <code>NextMarker</code> from the current page's response (which is also the ID of the last configuration on that page). </p>
        pub fn marker(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(inp);
            self
        }
        /// <p>Use this when paginating results to indicate where to begin in your list of configurations. The results include configurations in the list that
        /// occur after the marker. To get the next page of results, set the <code>Marker</code> to the value of the
        /// <code>NextMarker</code> from the current page's response (which is also the ID of the last configuration on that page). </p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
        /// <p>The maximum number of field-level encryption configurations you want in the response body. </p>
        pub fn max_items(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_items(inp);
            self
        }
        /// <p>The maximum number of field-level encryption configurations you want in the response body. </p>
        pub fn set_max_items(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_items(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListFieldLevelEncryptionProfiles`.
    ///
    /// <p>Request a list of field-level encryption profiles that have been created in CloudFront for this account.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListFieldLevelEncryptionProfiles<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_field_level_encryption_profiles_input::Builder,
    }
    impl<C, M, R> ListFieldLevelEncryptionProfiles<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListFieldLevelEncryptionProfiles`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListFieldLevelEncryptionProfilesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListFieldLevelEncryptionProfilesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListFieldLevelEncryptionProfilesInputOperationOutputAlias,
                crate::output::ListFieldLevelEncryptionProfilesOutput,
                crate::error::ListFieldLevelEncryptionProfilesError,
                crate::input::ListFieldLevelEncryptionProfilesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Use this when paginating results to indicate where to begin in your list of profiles. The results include profiles in the list that
        /// occur after the marker. To get the next page of results, set the <code>Marker</code> to the value of the
        /// <code>NextMarker</code> from the current page's response (which is also the ID of the last profile on that page). </p>
        pub fn marker(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(inp);
            self
        }
        /// <p>Use this when paginating results to indicate where to begin in your list of profiles. The results include profiles in the list that
        /// occur after the marker. To get the next page of results, set the <code>Marker</code> to the value of the
        /// <code>NextMarker</code> from the current page's response (which is also the ID of the last profile on that page). </p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
        /// <p>The maximum number of field-level encryption profiles you want in the response body. </p>
        pub fn max_items(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_items(inp);
            self
        }
        /// <p>The maximum number of field-level encryption profiles you want in the response body. </p>
        pub fn set_max_items(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_items(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListFunctions`.
    ///
    /// <p>Gets a list of all CloudFront functions in your Amazon Web Services account.</p>
    /// <p>You can optionally apply a filter to return only the functions that are in the
    /// specified stage, either <code>DEVELOPMENT</code> or <code>LIVE</code>.</p>
    /// <p>You can optionally specify the maximum number of items to receive in the response. If
    /// the total number of items in the list exceeds the maximum that you specify, or the
    /// default maximum, the response is paginated. To get the next page of items, send a
    /// subsequent request that specifies the <code>NextMarker</code> value from the current
    /// response as the <code>Marker</code> value in the subsequent request.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListFunctions<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_functions_input::Builder,
    }
    impl<C, M, R> ListFunctions<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListFunctions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListFunctionsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListFunctionsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListFunctionsInputOperationOutputAlias,
                crate::output::ListFunctionsOutput,
                crate::error::ListFunctionsError,
                crate::input::ListFunctionsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Use this field when paginating results to indicate where to begin in your list of
        /// functions. The response includes functions in the list that occur after the marker. To
        /// get the next page of the list, set this field’s value to the value of
        /// <code>NextMarker</code> from the current page’s response.</p>
        pub fn marker(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(inp);
            self
        }
        /// <p>Use this field when paginating results to indicate where to begin in your list of
        /// functions. The response includes functions in the list that occur after the marker. To
        /// get the next page of the list, set this field’s value to the value of
        /// <code>NextMarker</code> from the current page’s response.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
        /// <p>The maximum number of functions that you want in the response.</p>
        pub fn max_items(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_items(inp);
            self
        }
        /// <p>The maximum number of functions that you want in the response.</p>
        pub fn set_max_items(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_items(input);
            self
        }
        /// <p>An optional filter to return only the functions that are in the specified stage,
        /// either <code>DEVELOPMENT</code> or <code>LIVE</code>.</p>
        pub fn stage(mut self, inp: crate::model::FunctionStage) -> Self {
            self.inner = self.inner.stage(inp);
            self
        }
        /// <p>An optional filter to return only the functions that are in the specified stage,
        /// either <code>DEVELOPMENT</code> or <code>LIVE</code>.</p>
        pub fn set_stage(
            mut self,
            input: std::option::Option<crate::model::FunctionStage>,
        ) -> Self {
            self.inner = self.inner.set_stage(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListInvalidations`.
    ///
    /// <p>Lists invalidation batches. </p>
    #[derive(std::fmt::Debug)]
    pub struct ListInvalidations<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_invalidations_input::Builder,
    }
    impl<C, M, R> ListInvalidations<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListInvalidations`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListInvalidationsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListInvalidationsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListInvalidationsInputOperationOutputAlias,
                crate::output::ListInvalidationsOutput,
                crate::error::ListInvalidationsError,
                crate::input::ListInvalidationsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The distribution's ID.</p>
        pub fn distribution_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.distribution_id(inp);
            self
        }
        /// <p>The distribution's ID.</p>
        pub fn set_distribution_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_distribution_id(input);
            self
        }
        /// <p>Use this parameter when paginating results to indicate where to begin in your list of
        /// invalidation batches. Because the results are returned in decreasing order from most recent to
        /// oldest, the most recent results are on the first page, the second page will contain earlier
        /// results, and so on. To get the next page of results, set <code>Marker</code> to the value of
        /// the <code>NextMarker</code> from the current page's response. This value is the same as the ID
        /// of the last invalidation batch on that page. </p>
        pub fn marker(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(inp);
            self
        }
        /// <p>Use this parameter when paginating results to indicate where to begin in your list of
        /// invalidation batches. Because the results are returned in decreasing order from most recent to
        /// oldest, the most recent results are on the first page, the second page will contain earlier
        /// results, and so on. To get the next page of results, set <code>Marker</code> to the value of
        /// the <code>NextMarker</code> from the current page's response. This value is the same as the ID
        /// of the last invalidation batch on that page. </p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
        /// <p>The maximum number of invalidation batches that you want in the response
        /// body.</p>
        pub fn max_items(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_items(inp);
            self
        }
        /// <p>The maximum number of invalidation batches that you want in the response
        /// body.</p>
        pub fn set_max_items(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_items(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListKeyGroups`.
    ///
    /// <p>Gets a list of key groups.</p>
    /// <p>You can optionally specify the maximum number of items to receive in the response. If
    /// the total number of items in the list exceeds the maximum that you specify, or the
    /// default maximum, the response is paginated. To get the next page of items, send a
    /// subsequent request that specifies the <code>NextMarker</code> value from the current
    /// response as the <code>Marker</code> value in the subsequent request.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListKeyGroups<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_key_groups_input::Builder,
    }
    impl<C, M, R> ListKeyGroups<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListKeyGroups`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListKeyGroupsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListKeyGroupsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListKeyGroupsInputOperationOutputAlias,
                crate::output::ListKeyGroupsOutput,
                crate::error::ListKeyGroupsError,
                crate::input::ListKeyGroupsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Use this field when paginating results to indicate where to begin in your list of key
        /// groups. The response includes key groups in the list that occur after the marker. To get
        /// the next page of the list, set this field’s value to the value of
        /// <code>NextMarker</code> from the current page’s response.</p>
        pub fn marker(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(inp);
            self
        }
        /// <p>Use this field when paginating results to indicate where to begin in your list of key
        /// groups. The response includes key groups in the list that occur after the marker. To get
        /// the next page of the list, set this field’s value to the value of
        /// <code>NextMarker</code> from the current page’s response.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
        /// <p>The maximum number of key groups that you want in the response.</p>
        pub fn max_items(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_items(inp);
            self
        }
        /// <p>The maximum number of key groups that you want in the response.</p>
        pub fn set_max_items(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_items(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListOriginRequestPolicies`.
    ///
    /// <p>Gets a list of origin request policies.</p>
    /// <p>You can optionally apply a filter to return only the managed policies created by Amazon Web Services, or
    /// only the custom policies created in your Amazon Web Services account.</p>
    /// <p>You can optionally specify the maximum number of items to receive in the response. If
    /// the total number of items in the list exceeds the maximum that you specify, or the
    /// default maximum, the response is paginated. To get the next page of items, send a
    /// subsequent request that specifies the <code>NextMarker</code> value from the current
    /// response as the <code>Marker</code> value in the subsequent request.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListOriginRequestPolicies<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_origin_request_policies_input::Builder,
    }
    impl<C, M, R> ListOriginRequestPolicies<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListOriginRequestPolicies`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListOriginRequestPoliciesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListOriginRequestPoliciesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListOriginRequestPoliciesInputOperationOutputAlias,
                crate::output::ListOriginRequestPoliciesOutput,
                crate::error::ListOriginRequestPoliciesError,
                crate::input::ListOriginRequestPoliciesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A filter to return only the specified kinds of origin request policies. Valid values
        /// are:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>managed</code> – Returns only the managed policies created by Amazon Web Services.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>custom</code> – Returns only the custom policies created in your Amazon Web Services account.</p>
        /// </li>
        /// </ul>
        pub fn r#type(mut self, inp: crate::model::OriginRequestPolicyType) -> Self {
            self.inner = self.inner.r#type(inp);
            self
        }
        /// <p>A filter to return only the specified kinds of origin request policies. Valid values
        /// are:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>managed</code> – Returns only the managed policies created by Amazon Web Services.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>custom</code> – Returns only the custom policies created in your Amazon Web Services account.</p>
        /// </li>
        /// </ul>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::OriginRequestPolicyType>,
        ) -> Self {
            self.inner = self.inner.set_type(input);
            self
        }
        /// <p>Use this field when paginating results to indicate where to begin in your list of
        /// origin request policies. The response includes origin request policies in the list that
        /// occur after the marker. To get the next page of the list, set this field’s value to the
        /// value of <code>NextMarker</code> from the current page’s response.</p>
        pub fn marker(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(inp);
            self
        }
        /// <p>Use this field when paginating results to indicate where to begin in your list of
        /// origin request policies. The response includes origin request policies in the list that
        /// occur after the marker. To get the next page of the list, set this field’s value to the
        /// value of <code>NextMarker</code> from the current page’s response.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
        /// <p>The maximum number of origin request policies that you want in the response.</p>
        pub fn max_items(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_items(inp);
            self
        }
        /// <p>The maximum number of origin request policies that you want in the response.</p>
        pub fn set_max_items(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_items(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListPublicKeys`.
    ///
    /// <p>List all public keys that have been added to CloudFront for this account.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListPublicKeys<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_public_keys_input::Builder,
    }
    impl<C, M, R> ListPublicKeys<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListPublicKeys`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListPublicKeysOutput,
            aws_smithy_http::result::SdkError<crate::error::ListPublicKeysError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListPublicKeysInputOperationOutputAlias,
                crate::output::ListPublicKeysOutput,
                crate::error::ListPublicKeysError,
                crate::input::ListPublicKeysInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Use this when paginating results to indicate where to begin in your list of public keys. The results include public keys in the list that
        /// occur after the marker. To get the next page of results, set the <code>Marker</code> to the value of the
        /// <code>NextMarker</code> from the current page's response (which is also the ID of the last public key on that page). </p>
        pub fn marker(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(inp);
            self
        }
        /// <p>Use this when paginating results to indicate where to begin in your list of public keys. The results include public keys in the list that
        /// occur after the marker. To get the next page of results, set the <code>Marker</code> to the value of the
        /// <code>NextMarker</code> from the current page's response (which is also the ID of the last public key on that page). </p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
        /// <p>The maximum number of public keys you want in the response body. </p>
        pub fn max_items(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_items(inp);
            self
        }
        /// <p>The maximum number of public keys you want in the response body. </p>
        pub fn set_max_items(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_items(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListRealtimeLogConfigs`.
    ///
    /// <p>Gets a list of real-time log configurations.</p>
    /// <p>You can optionally specify the maximum number of items to receive in the response. If
    /// the total number of items in the list exceeds the maximum that you specify, or the
    /// default maximum, the response is paginated. To get the next page of items, send a
    /// subsequent request that specifies the <code>NextMarker</code> value from the current
    /// response as the <code>Marker</code> value in the subsequent request. </p>
    #[derive(std::fmt::Debug)]
    pub struct ListRealtimeLogConfigs<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_realtime_log_configs_input::Builder,
    }
    impl<C, M, R> ListRealtimeLogConfigs<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListRealtimeLogConfigs`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListRealtimeLogConfigsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListRealtimeLogConfigsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListRealtimeLogConfigsInputOperationOutputAlias,
                crate::output::ListRealtimeLogConfigsOutput,
                crate::error::ListRealtimeLogConfigsError,
                crate::input::ListRealtimeLogConfigsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The maximum number of real-time log configurations that you want in the response.</p>
        pub fn max_items(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_items(inp);
            self
        }
        /// <p>The maximum number of real-time log configurations that you want in the response.</p>
        pub fn set_max_items(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_items(input);
            self
        }
        /// <p>Use this field when paginating results to indicate where to begin in your list of real-time
        /// log configurations. The response includes real-time log configurations in the list that
        /// occur after the marker. To get the next page of the list, set this field’s value to the
        /// value of <code>NextMarker</code> from the current page’s response.</p>
        pub fn marker(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(inp);
            self
        }
        /// <p>Use this field when paginating results to indicate where to begin in your list of real-time
        /// log configurations. The response includes real-time log configurations in the list that
        /// occur after the marker. To get the next page of the list, set this field’s value to the
        /// value of <code>NextMarker</code> from the current page’s response.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListResponseHeadersPolicies`.
    ///
    /// <p>Gets a list of response headers policies.</p>
    /// <p>You can optionally apply a filter to get only the managed policies created by Amazon Web Services,
    /// or only the custom policies created in your Amazon Web Services account.</p>
    /// <p>You can optionally specify the maximum number of items to receive in the response. If
    /// the total number of items in the list exceeds the maximum that you specify, or the
    /// default maximum, the response is paginated. To get the next page of items, send a
    /// subsequent request that specifies the <code>NextMarker</code> value from the current
    /// response as the <code>Marker</code> value in the subsequent request.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListResponseHeadersPolicies<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_response_headers_policies_input::Builder,
    }
    impl<C, M, R> ListResponseHeadersPolicies<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListResponseHeadersPolicies`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListResponseHeadersPoliciesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListResponseHeadersPoliciesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListResponseHeadersPoliciesInputOperationOutputAlias,
                crate::output::ListResponseHeadersPoliciesOutput,
                crate::error::ListResponseHeadersPoliciesError,
                crate::input::ListResponseHeadersPoliciesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A filter to get only the specified kind of response headers policies. Valid values
        /// are:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>managed</code> – Gets only the managed policies created by Amazon Web Services.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>custom</code> – Gets only the custom policies created in your
        /// Amazon Web Services account.</p>
        /// </li>
        /// </ul>
        pub fn r#type(mut self, inp: crate::model::ResponseHeadersPolicyType) -> Self {
            self.inner = self.inner.r#type(inp);
            self
        }
        /// <p>A filter to get only the specified kind of response headers policies. Valid values
        /// are:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>managed</code> – Gets only the managed policies created by Amazon Web Services.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>custom</code> – Gets only the custom policies created in your
        /// Amazon Web Services account.</p>
        /// </li>
        /// </ul>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::ResponseHeadersPolicyType>,
        ) -> Self {
            self.inner = self.inner.set_type(input);
            self
        }
        /// <p>Use this field when paginating results to indicate where to begin in your list of response
        /// headers policies. The response includes response headers policies in the list that occur
        /// after the marker. To get the next page of the list, set this field’s value to the value
        /// of <code>NextMarker</code> from the current page’s response. </p>
        pub fn marker(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(inp);
            self
        }
        /// <p>Use this field when paginating results to indicate where to begin in your list of response
        /// headers policies. The response includes response headers policies in the list that occur
        /// after the marker. To get the next page of the list, set this field’s value to the value
        /// of <code>NextMarker</code> from the current page’s response. </p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
        /// <p>The maximum number of response headers policies that you want to get in the response.</p>
        pub fn max_items(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_items(inp);
            self
        }
        /// <p>The maximum number of response headers policies that you want to get in the response.</p>
        pub fn set_max_items(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_items(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListStreamingDistributions`.
    ///
    /// <p>List streaming distributions. </p>
    #[derive(std::fmt::Debug)]
    pub struct ListStreamingDistributions<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_streaming_distributions_input::Builder,
    }
    impl<C, M, R> ListStreamingDistributions<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListStreamingDistributions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListStreamingDistributionsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListStreamingDistributionsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListStreamingDistributionsInputOperationOutputAlias,
                crate::output::ListStreamingDistributionsOutput,
                crate::error::ListStreamingDistributionsError,
                crate::input::ListStreamingDistributionsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The value that you provided for the <code>Marker</code> request parameter.</p>
        pub fn marker(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(inp);
            self
        }
        /// <p>The value that you provided for the <code>Marker</code> request parameter.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
        /// <p>The value that you provided for the <code>MaxItems</code> request parameter.</p>
        pub fn max_items(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_items(inp);
            self
        }
        /// <p>The value that you provided for the <code>MaxItems</code> request parameter.</p>
        pub fn set_max_items(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_items(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTagsForResource`.
    ///
    /// <p>List tags for a CloudFront resource.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListTagsForResource<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_tags_for_resource_input::Builder,
    }
    impl<C, M, R> ListTagsForResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListTagsForResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTagsForResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTagsForResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListTagsForResourceInputOperationOutputAlias,
                crate::output::ListTagsForResourceOutput,
                crate::error::ListTagsForResourceError,
                crate::input::ListTagsForResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> An ARN of a CloudFront resource.</p>
        pub fn resource(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource(inp);
            self
        }
        /// <p> An ARN of a CloudFront resource.</p>
        pub fn set_resource(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PublishFunction`.
    ///
    /// <p>Publishes a CloudFront function by copying the function code from the <code>DEVELOPMENT</code>
    /// stage to <code>LIVE</code>. This automatically updates all cache behaviors that are
    /// using this function to use the newly published copy in the <code>LIVE</code>
    /// stage.</p>
    /// <p>When a function is published to the <code>LIVE</code> stage, you can attach the function to
    /// a distribution’s cache behavior, using the function’s Amazon Resource Name (ARN).</p>
    /// <p>To publish a function, you must provide the function’s name and version (<code>ETag</code>
    /// value). To get these values, you can use <code>ListFunctions</code> and
    /// <code>DescribeFunction</code>.</p>
    #[derive(std::fmt::Debug)]
    pub struct PublishFunction<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::publish_function_input::Builder,
    }
    impl<C, M, R> PublishFunction<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `PublishFunction`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PublishFunctionOutput,
            aws_smithy_http::result::SdkError<crate::error::PublishFunctionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::PublishFunctionInputOperationOutputAlias,
                crate::output::PublishFunctionOutput,
                crate::error::PublishFunctionError,
                crate::input::PublishFunctionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the function that you are publishing.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name of the function that you are publishing.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The current version (<code>ETag</code> value) of the function that you are publishing, which
        /// you can get using <code>DescribeFunction</code>.</p>
        pub fn if_match(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.if_match(inp);
            self
        }
        /// <p>The current version (<code>ETag</code> value) of the function that you are publishing, which
        /// you can get using <code>DescribeFunction</code>.</p>
        pub fn set_if_match(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_if_match(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TagResource`.
    ///
    /// <p>Add tags to a CloudFront resource.</p>
    #[derive(std::fmt::Debug)]
    pub struct TagResource<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::tag_resource_input::Builder,
    }
    impl<C, M, R> TagResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `TagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::TagResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::TagResourceInputOperationOutputAlias,
                crate::output::TagResourceOutput,
                crate::error::TagResourceError,
                crate::input::TagResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> An ARN of a CloudFront resource.</p>
        pub fn resource(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource(inp);
            self
        }
        /// <p> An ARN of a CloudFront resource.</p>
        pub fn set_resource(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource(input);
            self
        }
        /// <p> A complex type that contains zero or more <code>Tag</code> elements.</p>
        pub fn tags(mut self, inp: crate::model::Tags) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p> A complex type that contains zero or more <code>Tag</code> elements.</p>
        pub fn set_tags(mut self, input: std::option::Option<crate::model::Tags>) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TestFunction`.
    ///
    /// <p>Tests a CloudFront function.</p>
    /// <p>To test a function, you provide an <i>event object</i> that represents an HTTP
    /// request or response that your CloudFront distribution could receive in production. CloudFront runs
    /// the function, passing it the event object that you provided, and returns the function’s
    /// result (the modified event object) in the response. The response also contains function
    /// logs and error messages, if any exist. For more information about testing functions, see
    /// <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/managing-functions.html#test-function">Testing functions</a> in the <i>Amazon CloudFront Developer Guide</i>.</p>
    /// <p>To test a function, you provide the function’s name and version (<code>ETag</code> value)
    /// along with the event object. To get the function’s name and version, you can use
    /// <code>ListFunctions</code> and <code>DescribeFunction</code>.</p>
    #[derive(std::fmt::Debug)]
    pub struct TestFunction<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::test_function_input::Builder,
    }
    impl<C, M, R> TestFunction<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `TestFunction`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TestFunctionOutput,
            aws_smithy_http::result::SdkError<crate::error::TestFunctionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::TestFunctionInputOperationOutputAlias,
                crate::output::TestFunctionOutput,
                crate::error::TestFunctionError,
                crate::input::TestFunctionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the function that you are testing.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name of the function that you are testing.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The current version (<code>ETag</code> value) of the function that you are testing, which
        /// you can get using <code>DescribeFunction</code>.</p>
        pub fn if_match(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.if_match(inp);
            self
        }
        /// <p>The current version (<code>ETag</code> value) of the function that you are testing, which
        /// you can get using <code>DescribeFunction</code>.</p>
        pub fn set_if_match(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_if_match(input);
            self
        }
        /// <p>The stage of the function that you are testing, either <code>DEVELOPMENT</code> or
        /// <code>LIVE</code>.</p>
        pub fn stage(mut self, inp: crate::model::FunctionStage) -> Self {
            self.inner = self.inner.stage(inp);
            self
        }
        /// <p>The stage of the function that you are testing, either <code>DEVELOPMENT</code> or
        /// <code>LIVE</code>.</p>
        pub fn set_stage(
            mut self,
            input: std::option::Option<crate::model::FunctionStage>,
        ) -> Self {
            self.inner = self.inner.set_stage(input);
            self
        }
        /// <p>The event object to test the function with. For more information about the structure of the
        /// event object, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/managing-functions.html#test-function">Testing functions</a> in the <i>Amazon CloudFront Developer Guide</i>.</p>
        pub fn event_object(mut self, inp: aws_smithy_types::Blob) -> Self {
            self.inner = self.inner.event_object(inp);
            self
        }
        /// <p>The event object to test the function with. For more information about the structure of the
        /// event object, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/managing-functions.html#test-function">Testing functions</a> in the <i>Amazon CloudFront Developer Guide</i>.</p>
        pub fn set_event_object(
            mut self,
            input: std::option::Option<aws_smithy_types::Blob>,
        ) -> Self {
            self.inner = self.inner.set_event_object(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UntagResource`.
    ///
    /// <p>Remove tags from a CloudFront resource.</p>
    #[derive(std::fmt::Debug)]
    pub struct UntagResource<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::untag_resource_input::Builder,
    }
    impl<C, M, R> UntagResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UntagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UntagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::UntagResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UntagResourceInputOperationOutputAlias,
                crate::output::UntagResourceOutput,
                crate::error::UntagResourceError,
                crate::input::UntagResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> An ARN of a CloudFront resource.</p>
        pub fn resource(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource(inp);
            self
        }
        /// <p> An ARN of a CloudFront resource.</p>
        pub fn set_resource(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource(input);
            self
        }
        /// <p> A complex type that contains zero or more <code>Tag</code> key elements.</p>
        pub fn tag_keys(mut self, inp: crate::model::TagKeys) -> Self {
            self.inner = self.inner.tag_keys(inp);
            self
        }
        /// <p> A complex type that contains zero or more <code>Tag</code> key elements.</p>
        pub fn set_tag_keys(mut self, input: std::option::Option<crate::model::TagKeys>) -> Self {
            self.inner = self.inner.set_tag_keys(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateCachePolicy`.
    ///
    /// <p>Updates a cache policy configuration.</p>
    /// <p>When you update a cache policy configuration, all the fields are updated with the
    /// values provided in the request. You cannot update some fields independent of others. To
    /// update a cache policy configuration:</p>
    /// <ol>
    /// <li>
    /// <p>Use <code>GetCachePolicyConfig</code> to get the current configuration.</p>
    /// </li>
    /// <li>
    /// <p>Locally modify the fields in the cache policy configuration that you want to
    /// update.</p>
    /// </li>
    /// <li>
    /// <p>Call <code>UpdateCachePolicy</code> by providing the entire cache policy
    /// configuration, including the fields that you modified and those that you
    /// didn’t.</p>
    /// </li>
    /// </ol>
    #[derive(std::fmt::Debug)]
    pub struct UpdateCachePolicy<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_cache_policy_input::Builder,
    }
    impl<C, M, R> UpdateCachePolicy<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateCachePolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateCachePolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateCachePolicyError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateCachePolicyInputOperationOutputAlias,
                crate::output::UpdateCachePolicyOutput,
                crate::error::UpdateCachePolicyError,
                crate::input::UpdateCachePolicyInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A cache policy configuration.</p>
        pub fn cache_policy_config(mut self, inp: crate::model::CachePolicyConfig) -> Self {
            self.inner = self.inner.cache_policy_config(inp);
            self
        }
        /// <p>A cache policy configuration.</p>
        pub fn set_cache_policy_config(
            mut self,
            input: std::option::Option<crate::model::CachePolicyConfig>,
        ) -> Self {
            self.inner = self.inner.set_cache_policy_config(input);
            self
        }
        /// <p>The unique identifier for the cache policy that you are updating. The identifier is returned
        /// in a cache behavior’s <code>CachePolicyId</code> field in the response to
        /// <code>GetDistributionConfig</code>.</p>
        pub fn id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(inp);
            self
        }
        /// <p>The unique identifier for the cache policy that you are updating. The identifier is returned
        /// in a cache behavior’s <code>CachePolicyId</code> field in the response to
        /// <code>GetDistributionConfig</code>.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
        /// <p>The version of the cache policy that you are updating. The version is returned in the cache
        /// policy’s <code>ETag</code> field in the response to
        /// <code>GetCachePolicyConfig</code>.</p>
        pub fn if_match(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.if_match(inp);
            self
        }
        /// <p>The version of the cache policy that you are updating. The version is returned in the cache
        /// policy’s <code>ETag</code> field in the response to
        /// <code>GetCachePolicyConfig</code>.</p>
        pub fn set_if_match(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_if_match(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateCloudFrontOriginAccessIdentity`.
    ///
    /// <p>Update an origin access identity. </p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateCloudFrontOriginAccessIdentity<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_cloud_front_origin_access_identity_input::Builder,
    }
    impl<C, M, R> UpdateCloudFrontOriginAccessIdentity<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateCloudFrontOriginAccessIdentity`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateCloudFrontOriginAccessIdentityOutput,
            aws_smithy_http::result::SdkError<
                crate::error::UpdateCloudFrontOriginAccessIdentityError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateCloudFrontOriginAccessIdentityInputOperationOutputAlias,
                crate::output::UpdateCloudFrontOriginAccessIdentityOutput,
                crate::error::UpdateCloudFrontOriginAccessIdentityError,
                crate::input::UpdateCloudFrontOriginAccessIdentityInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identity's configuration information.</p>
        pub fn cloud_front_origin_access_identity_config(
            mut self,
            inp: crate::model::CloudFrontOriginAccessIdentityConfig,
        ) -> Self {
            self.inner = self.inner.cloud_front_origin_access_identity_config(inp);
            self
        }
        /// <p>The identity's configuration information.</p>
        pub fn set_cloud_front_origin_access_identity_config(
            mut self,
            input: std::option::Option<crate::model::CloudFrontOriginAccessIdentityConfig>,
        ) -> Self {
            self.inner = self
                .inner
                .set_cloud_front_origin_access_identity_config(input);
            self
        }
        /// <p>The identity's id.</p>
        pub fn id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(inp);
            self
        }
        /// <p>The identity's id.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
        /// <p>The value of the <code>ETag</code> header that you received when retrieving the
        /// identity's configuration. For example: <code>E2QWRUHAPOMQZL</code>.</p>
        pub fn if_match(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.if_match(inp);
            self
        }
        /// <p>The value of the <code>ETag</code> header that you received when retrieving the
        /// identity's configuration. For example: <code>E2QWRUHAPOMQZL</code>.</p>
        pub fn set_if_match(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_if_match(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateDistribution`.
    ///
    /// <p>Updates the configuration for a web distribution. </p>
    /// <important>
    /// <p>When you update a distribution, there are more required fields than when you create a distribution.
    /// When you update your distribution by using this API action, follow the steps here to get the current configuration
    /// and then make your updates, to make sure that you include all of the required fields. To view a summary,
    /// see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-overview-required-fields.html">Required
    /// Fields for Create Distribution and Update Distribution</a> in the <i>Amazon CloudFront Developer Guide</i>.</p>
    /// </important>
    /// <p>The update process includes getting the current distribution configuration, updating the XML document that is
    /// returned to make your changes, and then submitting an <code>UpdateDistribution</code> request to make the updates.</p>
    /// <p>For information about updating a distribution using the CloudFront console instead, see  
    /// <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-web-creating-console.html">Creating a
    /// Distribution</a> in the <i>Amazon CloudFront Developer Guide</i>.</p>
    ///
    /// <p>
    /// <b>To update a web distribution using the CloudFront API</b>
    /// </p>
    /// <ol>
    /// <li>
    /// <p>Submit a
    /// <a href="https://docs.aws.amazon.com/cloudfront/latest/APIReference/API_GetDistributionConfig.html">GetDistributionConfig</a>
    /// request to get the current configuration and an <code>Etag</code> header  
    /// for the distribution.</p>
    /// <note>
    /// <p>If you update the distribution again, you must get a new <code>Etag</code> header.</p>
    /// </note>
    /// </li>
    /// <li>
    /// <p>Update the XML document that was returned in the response to your <code>GetDistributionConfig</code> request to include
    /// your changes. </p>
    /// <important>
    /// <p>When you edit the XML file, be aware of the following:</p>
    /// <ul>
    /// <li>
    /// <p>You must strip out the ETag parameter that is returned.</p>
    /// </li>
    /// <li>
    /// <p>Additional fields are required when you update a distribution. There may be fields included in the
    /// XML file for features that you haven't configured for your distribution. This is expected and required to
    /// successfully update the distribution.</p>
    /// </li>
    /// <li>
    /// <p>You can't change the value of <code>CallerReference</code>. If you try to change this value, CloudFront returns an  
    /// <code>IllegalUpdate</code> error. </p>
    /// </li>
    /// <li>
    /// <p>The new configuration replaces the existing configuration; the values that you specify in an
    /// <code>UpdateDistribution</code> request are not merged into your existing configuration. When you add, delete, or
    /// replace values in an element that allows multiple values (for example, <code>CNAME</code>), you must specify all of the
    /// values that you want to appear in the updated distribution. In addition,  
    /// you must update the corresponding <code>Quantity</code> element.</p>
    /// </li>
    /// </ul>
    /// </important>
    /// </li>
    /// <li>
    /// <p>Submit an <code>UpdateDistribution</code> request to update the configuration for your distribution:</p>
    /// <ul>
    /// <li>
    /// <p>In the request body, include the XML document that you updated in Step 2. The request body must include an  
    /// XML document with a <code>DistributionConfig</code> element.</p>
    /// </li>
    /// <li>
    /// <p>Set the value of the HTTP <code>If-Match</code> header to the value of the <code>ETag</code> header that CloudFront returned  
    /// when you submitted the <code>GetDistributionConfig</code> request in Step 1.</p>
    /// </li>
    /// </ul>
    /// </li>
    /// <li>
    /// <p>Review the response to the <code>UpdateDistribution</code> request to confirm that the configuration was  
    /// successfully updated.</p>
    /// </li>
    /// <li>
    /// <p>Optional: Submit a
    /// <a href="https://docs.aws.amazon.com/cloudfront/latest/APIReference/API_GetDistribution.html">GetDistribution</a>
    /// request to confirm that your changes have propagated.  
    /// When propagation is complete, the value of <code>Status</code> is <code>Deployed</code>.</p>
    /// </li>
    /// </ol>
    #[derive(std::fmt::Debug)]
    pub struct UpdateDistribution<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_distribution_input::Builder,
    }
    impl<C, M, R> UpdateDistribution<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateDistribution`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateDistributionOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateDistributionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateDistributionInputOperationOutputAlias,
                crate::output::UpdateDistributionOutput,
                crate::error::UpdateDistributionError,
                crate::input::UpdateDistributionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The distribution's configuration information.</p>
        pub fn distribution_config(mut self, inp: crate::model::DistributionConfig) -> Self {
            self.inner = self.inner.distribution_config(inp);
            self
        }
        /// <p>The distribution's configuration information.</p>
        pub fn set_distribution_config(
            mut self,
            input: std::option::Option<crate::model::DistributionConfig>,
        ) -> Self {
            self.inner = self.inner.set_distribution_config(input);
            self
        }
        /// <p>The distribution's id.</p>
        pub fn id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(inp);
            self
        }
        /// <p>The distribution's id.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
        /// <p>The value of the <code>ETag</code> header that you received when retrieving the
        /// distribution's configuration. For example: <code>E2QWRUHAPOMQZL</code>.</p>
        pub fn if_match(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.if_match(inp);
            self
        }
        /// <p>The value of the <code>ETag</code> header that you received when retrieving the
        /// distribution's configuration. For example: <code>E2QWRUHAPOMQZL</code>.</p>
        pub fn set_if_match(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_if_match(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateFieldLevelEncryptionConfig`.
    ///
    /// <p>Update a field-level encryption configuration. </p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateFieldLevelEncryptionConfig<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_field_level_encryption_config_input::Builder,
    }
    impl<C, M, R> UpdateFieldLevelEncryptionConfig<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateFieldLevelEncryptionConfig`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateFieldLevelEncryptionConfigOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateFieldLevelEncryptionConfigError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateFieldLevelEncryptionConfigInputOperationOutputAlias,
                crate::output::UpdateFieldLevelEncryptionConfigOutput,
                crate::error::UpdateFieldLevelEncryptionConfigError,
                crate::input::UpdateFieldLevelEncryptionConfigInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Request to update a field-level encryption configuration. </p>
        pub fn field_level_encryption_config(
            mut self,
            inp: crate::model::FieldLevelEncryptionConfig,
        ) -> Self {
            self.inner = self.inner.field_level_encryption_config(inp);
            self
        }
        /// <p>Request to update a field-level encryption configuration. </p>
        pub fn set_field_level_encryption_config(
            mut self,
            input: std::option::Option<crate::model::FieldLevelEncryptionConfig>,
        ) -> Self {
            self.inner = self.inner.set_field_level_encryption_config(input);
            self
        }
        /// <p>The ID of the configuration you want to update.</p>
        pub fn id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(inp);
            self
        }
        /// <p>The ID of the configuration you want to update.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
        /// <p>The value of the <code>ETag</code> header that you received when retrieving the configuration identity to update.
        /// For example: <code>E2QWRUHAPOMQZL</code>.</p>
        pub fn if_match(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.if_match(inp);
            self
        }
        /// <p>The value of the <code>ETag</code> header that you received when retrieving the configuration identity to update.
        /// For example: <code>E2QWRUHAPOMQZL</code>.</p>
        pub fn set_if_match(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_if_match(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateFieldLevelEncryptionProfile`.
    ///
    /// <p>Update a field-level encryption profile. </p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateFieldLevelEncryptionProfile<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_field_level_encryption_profile_input::Builder,
    }
    impl<C, M, R> UpdateFieldLevelEncryptionProfile<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateFieldLevelEncryptionProfile`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateFieldLevelEncryptionProfileOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateFieldLevelEncryptionProfileError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateFieldLevelEncryptionProfileInputOperationOutputAlias,
                crate::output::UpdateFieldLevelEncryptionProfileOutput,
                crate::error::UpdateFieldLevelEncryptionProfileError,
                crate::input::UpdateFieldLevelEncryptionProfileInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Request to update a field-level encryption profile. </p>
        pub fn field_level_encryption_profile_config(
            mut self,
            inp: crate::model::FieldLevelEncryptionProfileConfig,
        ) -> Self {
            self.inner = self.inner.field_level_encryption_profile_config(inp);
            self
        }
        /// <p>Request to update a field-level encryption profile. </p>
        pub fn set_field_level_encryption_profile_config(
            mut self,
            input: std::option::Option<crate::model::FieldLevelEncryptionProfileConfig>,
        ) -> Self {
            self.inner = self.inner.set_field_level_encryption_profile_config(input);
            self
        }
        /// <p>The ID of the field-level encryption profile request. </p>
        pub fn id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(inp);
            self
        }
        /// <p>The ID of the field-level encryption profile request. </p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
        /// <p>The value of the <code>ETag</code> header that you received when retrieving the profile identity to update.
        /// For example: <code>E2QWRUHAPOMQZL</code>.</p>
        pub fn if_match(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.if_match(inp);
            self
        }
        /// <p>The value of the <code>ETag</code> header that you received when retrieving the profile identity to update.
        /// For example: <code>E2QWRUHAPOMQZL</code>.</p>
        pub fn set_if_match(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_if_match(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateFunction`.
    ///
    /// <p>Updates a CloudFront function.</p>
    /// <p>You can update a function’s code or the comment that describes the function. You
    /// cannot update a function’s name.</p>
    /// <p>To update a function, you provide the function’s name and version (<code>ETag</code> value)
    /// along with the updated function code. To get the name and version, you can use
    /// <code>ListFunctions</code> and <code>DescribeFunction</code>.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateFunction<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_function_input::Builder,
    }
    impl<C, M, R> UpdateFunction<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateFunction`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateFunctionOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateFunctionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateFunctionInputOperationOutputAlias,
                crate::output::UpdateFunctionOutput,
                crate::error::UpdateFunctionError,
                crate::input::UpdateFunctionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the function that you are updating.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name of the function that you are updating.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The current version (<code>ETag</code> value) of the function that you are updating, which
        /// you can get using <code>DescribeFunction</code>.</p>
        pub fn if_match(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.if_match(inp);
            self
        }
        /// <p>The current version (<code>ETag</code> value) of the function that you are updating, which
        /// you can get using <code>DescribeFunction</code>.</p>
        pub fn set_if_match(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_if_match(input);
            self
        }
        /// <p>Configuration information about the function.</p>
        pub fn function_config(mut self, inp: crate::model::FunctionConfig) -> Self {
            self.inner = self.inner.function_config(inp);
            self
        }
        /// <p>Configuration information about the function.</p>
        pub fn set_function_config(
            mut self,
            input: std::option::Option<crate::model::FunctionConfig>,
        ) -> Self {
            self.inner = self.inner.set_function_config(input);
            self
        }
        /// <p>The function code. For more information about writing a CloudFront function, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/writing-function-code.html">Writing function
        /// code for CloudFront Functions</a> in the <i>Amazon CloudFront Developer Guide</i>.</p>
        pub fn function_code(mut self, inp: aws_smithy_types::Blob) -> Self {
            self.inner = self.inner.function_code(inp);
            self
        }
        /// <p>The function code. For more information about writing a CloudFront function, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/writing-function-code.html">Writing function
        /// code for CloudFront Functions</a> in the <i>Amazon CloudFront Developer Guide</i>.</p>
        pub fn set_function_code(
            mut self,
            input: std::option::Option<aws_smithy_types::Blob>,
        ) -> Self {
            self.inner = self.inner.set_function_code(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateKeyGroup`.
    ///
    /// <p>Updates a key group.</p>
    /// <p>When you update a key group, all the fields are updated with the values provided in
    /// the request. You cannot update some fields independent of others. To update a key
    /// group:</p>
    /// <ol>
    /// <li>
    /// <p>Get the current key group with <code>GetKeyGroup</code> or
    /// <code>GetKeyGroupConfig</code>.</p>
    /// </li>
    /// <li>
    /// <p>Locally modify the fields in the key group that you want to update. For
    /// example, add or remove public key IDs.</p>
    /// </li>
    /// <li>
    /// <p>Call <code>UpdateKeyGroup</code> with the entire key group object, including
    /// the fields that you modified and those that you didn’t.</p>
    /// </li>
    /// </ol>
    #[derive(std::fmt::Debug)]
    pub struct UpdateKeyGroup<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_key_group_input::Builder,
    }
    impl<C, M, R> UpdateKeyGroup<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateKeyGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateKeyGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateKeyGroupError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateKeyGroupInputOperationOutputAlias,
                crate::output::UpdateKeyGroupOutput,
                crate::error::UpdateKeyGroupError,
                crate::input::UpdateKeyGroupInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The key group configuration.</p>
        pub fn key_group_config(mut self, inp: crate::model::KeyGroupConfig) -> Self {
            self.inner = self.inner.key_group_config(inp);
            self
        }
        /// <p>The key group configuration.</p>
        pub fn set_key_group_config(
            mut self,
            input: std::option::Option<crate::model::KeyGroupConfig>,
        ) -> Self {
            self.inner = self.inner.set_key_group_config(input);
            self
        }
        /// <p>The identifier of the key group that you are updating.</p>
        pub fn id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(inp);
            self
        }
        /// <p>The identifier of the key group that you are updating.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
        /// <p>The version of the key group that you are updating. The version is the key group’s
        /// <code>ETag</code> value.</p>
        pub fn if_match(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.if_match(inp);
            self
        }
        /// <p>The version of the key group that you are updating. The version is the key group’s
        /// <code>ETag</code> value.</p>
        pub fn set_if_match(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_if_match(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateOriginRequestPolicy`.
    ///
    /// <p>Updates an origin request policy configuration.</p>
    /// <p>When you update an origin request policy configuration, all the fields are updated
    /// with the values provided in the request. You cannot update some fields independent of
    /// others. To update an origin request policy configuration:</p>
    /// <ol>
    /// <li>
    /// <p>Use <code>GetOriginRequestPolicyConfig</code> to get the current configuration.</p>
    /// </li>
    /// <li>
    /// <p>Locally modify the fields in the origin request policy configuration that you
    /// want to update.</p>
    /// </li>
    /// <li>
    /// <p>Call <code>UpdateOriginRequestPolicy</code> by providing the entire origin
    /// request policy configuration, including the fields that you modified and those
    /// that you didn’t.</p>
    /// </li>
    /// </ol>
    #[derive(std::fmt::Debug)]
    pub struct UpdateOriginRequestPolicy<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_origin_request_policy_input::Builder,
    }
    impl<C, M, R> UpdateOriginRequestPolicy<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateOriginRequestPolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateOriginRequestPolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateOriginRequestPolicyError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateOriginRequestPolicyInputOperationOutputAlias,
                crate::output::UpdateOriginRequestPolicyOutput,
                crate::error::UpdateOriginRequestPolicyError,
                crate::input::UpdateOriginRequestPolicyInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>An origin request policy configuration.</p>
        pub fn origin_request_policy_config(
            mut self,
            inp: crate::model::OriginRequestPolicyConfig,
        ) -> Self {
            self.inner = self.inner.origin_request_policy_config(inp);
            self
        }
        /// <p>An origin request policy configuration.</p>
        pub fn set_origin_request_policy_config(
            mut self,
            input: std::option::Option<crate::model::OriginRequestPolicyConfig>,
        ) -> Self {
            self.inner = self.inner.set_origin_request_policy_config(input);
            self
        }
        /// <p>The unique identifier for the origin request policy that you are updating. The identifier is
        /// returned in a cache behavior’s <code>OriginRequestPolicyId</code> field in the response
        /// to <code>GetDistributionConfig</code>.</p>
        pub fn id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(inp);
            self
        }
        /// <p>The unique identifier for the origin request policy that you are updating. The identifier is
        /// returned in a cache behavior’s <code>OriginRequestPolicyId</code> field in the response
        /// to <code>GetDistributionConfig</code>.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
        /// <p>The version of the origin request policy that you are updating. The version is returned in
        /// the origin request policy’s <code>ETag</code> field in the response to
        /// <code>GetOriginRequestPolicyConfig</code>.</p>
        pub fn if_match(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.if_match(inp);
            self
        }
        /// <p>The version of the origin request policy that you are updating. The version is returned in
        /// the origin request policy’s <code>ETag</code> field in the response to
        /// <code>GetOriginRequestPolicyConfig</code>.</p>
        pub fn set_if_match(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_if_match(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdatePublicKey`.
    ///
    /// <p>Update public key information. Note that the only value you can change is the comment.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdatePublicKey<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_public_key_input::Builder,
    }
    impl<C, M, R> UpdatePublicKey<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdatePublicKey`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdatePublicKeyOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdatePublicKeyError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdatePublicKeyInputOperationOutputAlias,
                crate::output::UpdatePublicKeyOutput,
                crate::error::UpdatePublicKeyError,
                crate::input::UpdatePublicKeyInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A public key configuration.</p>
        pub fn public_key_config(mut self, inp: crate::model::PublicKeyConfig) -> Self {
            self.inner = self.inner.public_key_config(inp);
            self
        }
        /// <p>A public key configuration.</p>
        pub fn set_public_key_config(
            mut self,
            input: std::option::Option<crate::model::PublicKeyConfig>,
        ) -> Self {
            self.inner = self.inner.set_public_key_config(input);
            self
        }
        /// <p>The identifier of the public key that you are updating.</p>
        pub fn id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(inp);
            self
        }
        /// <p>The identifier of the public key that you are updating.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
        /// <p>The value of the <code>ETag</code> header that you received when retrieving the public key to update.
        /// For example: <code>E2QWRUHAPOMQZL</code>.</p>
        pub fn if_match(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.if_match(inp);
            self
        }
        /// <p>The value of the <code>ETag</code> header that you received when retrieving the public key to update.
        /// For example: <code>E2QWRUHAPOMQZL</code>.</p>
        pub fn set_if_match(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_if_match(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateRealtimeLogConfig`.
    ///
    /// <p>Updates a real-time log configuration.</p>
    /// <p>When you update a real-time log configuration, all the parameters are updated with the
    /// values provided in the request. You cannot update some parameters independent of others.
    /// To update a real-time log configuration:</p>
    /// <ol>
    /// <li>
    /// <p>Call <code>GetRealtimeLogConfig</code> to get the current real-time log
    /// configuration.</p>
    /// </li>
    /// <li>
    /// <p>Locally modify the parameters in the real-time log configuration that you want
    /// to update.</p>
    /// </li>
    /// <li>
    /// <p>Call this API (<code>UpdateRealtimeLogConfig</code>) by providing the entire
    /// real-time log configuration, including the parameters that you modified and
    /// those that you didn’t.</p>
    /// </li>
    /// </ol>
    /// <p>You cannot update a real-time log configuration’s <code>Name</code> or
    /// <code>ARN</code>.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateRealtimeLogConfig<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_realtime_log_config_input::Builder,
    }
    impl<C, M, R> UpdateRealtimeLogConfig<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateRealtimeLogConfig`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateRealtimeLogConfigOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateRealtimeLogConfigError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateRealtimeLogConfigInputOperationOutputAlias,
                crate::output::UpdateRealtimeLogConfigOutput,
                crate::error::UpdateRealtimeLogConfigError,
                crate::input::UpdateRealtimeLogConfigInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `EndPoints`.
        ///
        /// To override the contents of this collection use [`set_end_points`](Self::set_end_points).
        ///
        /// <p>Contains information about the Amazon Kinesis data stream where you are sending real-time
        /// log data.</p>
        pub fn end_points(mut self, inp: impl Into<crate::model::EndPoint>) -> Self {
            self.inner = self.inner.end_points(inp);
            self
        }
        /// <p>Contains information about the Amazon Kinesis data stream where you are sending real-time
        /// log data.</p>
        pub fn set_end_points(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::EndPoint>>,
        ) -> Self {
            self.inner = self.inner.set_end_points(input);
            self
        }
        /// Appends an item to `Fields`.
        ///
        /// To override the contents of this collection use [`set_fields`](Self::set_fields).
        ///
        /// <p>A list of fields to include in each real-time log record.</p>
        /// <p>For more information about fields, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/real-time-logs.html#understand-real-time-log-config-fields">Real-time log configuration fields</a> in the
        /// <i>Amazon CloudFront Developer Guide</i>.</p>
        pub fn fields(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.fields(inp);
            self
        }
        /// <p>A list of fields to include in each real-time log record.</p>
        /// <p>For more information about fields, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/real-time-logs.html#understand-real-time-log-config-fields">Real-time log configuration fields</a> in the
        /// <i>Amazon CloudFront Developer Guide</i>.</p>
        pub fn set_fields(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_fields(input);
            self
        }
        /// <p>The name for this real-time log configuration.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name for this real-time log configuration.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) for this real-time log configuration.</p>
        pub fn arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) for this real-time log configuration.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_arn(input);
            self
        }
        /// <p>The sampling rate for this real-time log configuration. The sampling rate determines the
        /// percentage of viewer requests that are represented in the real-time log data. You must
        /// provide an integer between 1 and 100, inclusive.</p>
        pub fn sampling_rate(mut self, inp: i64) -> Self {
            self.inner = self.inner.sampling_rate(inp);
            self
        }
        /// <p>The sampling rate for this real-time log configuration. The sampling rate determines the
        /// percentage of viewer requests that are represented in the real-time log data. You must
        /// provide an integer between 1 and 100, inclusive.</p>
        pub fn set_sampling_rate(mut self, input: std::option::Option<i64>) -> Self {
            self.inner = self.inner.set_sampling_rate(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateResponseHeadersPolicy`.
    ///
    /// <p>Updates a response headers policy.</p>
    /// <p>When you update a response headers policy, the entire policy is replaced. You cannot
    /// update some policy fields independent of others. To update a response headers policy
    /// configuration:</p>
    /// <ol>
    /// <li>
    /// <p>Use <code>GetResponseHeadersPolicyConfig</code> to get the current policy’s
    /// configuration.</p>
    /// </li>
    /// <li>
    /// <p>Modify the fields in the response headers policy configuration that you want
    /// to update.</p>
    /// </li>
    /// <li>
    /// <p>Call <code>UpdateResponseHeadersPolicy</code>, providing the entire response
    /// headers policy configuration, including the fields that you modified and those
    /// that you didn’t.</p>
    /// </li>
    /// </ol>
    #[derive(std::fmt::Debug)]
    pub struct UpdateResponseHeadersPolicy<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_response_headers_policy_input::Builder,
    }
    impl<C, M, R> UpdateResponseHeadersPolicy<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateResponseHeadersPolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateResponseHeadersPolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateResponseHeadersPolicyError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateResponseHeadersPolicyInputOperationOutputAlias,
                crate::output::UpdateResponseHeadersPolicyOutput,
                crate::error::UpdateResponseHeadersPolicyError,
                crate::input::UpdateResponseHeadersPolicyInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A response headers policy configuration.</p>
        pub fn response_headers_policy_config(
            mut self,
            inp: crate::model::ResponseHeadersPolicyConfig,
        ) -> Self {
            self.inner = self.inner.response_headers_policy_config(inp);
            self
        }
        /// <p>A response headers policy configuration.</p>
        pub fn set_response_headers_policy_config(
            mut self,
            input: std::option::Option<crate::model::ResponseHeadersPolicyConfig>,
        ) -> Self {
            self.inner = self.inner.set_response_headers_policy_config(input);
            self
        }
        /// <p>The identifier for the response headers policy that you are updating.</p>
        pub fn id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(inp);
            self
        }
        /// <p>The identifier for the response headers policy that you are updating.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
        /// <p>The version of the response headers policy that you are updating.</p>
        /// <p>The version is returned in the cache policy’s <code>ETag</code> field in the response
        /// to <code>GetResponseHeadersPolicyConfig</code>.</p>
        pub fn if_match(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.if_match(inp);
            self
        }
        /// <p>The version of the response headers policy that you are updating.</p>
        /// <p>The version is returned in the cache policy’s <code>ETag</code> field in the response
        /// to <code>GetResponseHeadersPolicyConfig</code>.</p>
        pub fn set_if_match(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_if_match(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateStreamingDistribution`.
    ///
    /// <p>Update a streaming distribution. </p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateStreamingDistribution<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_streaming_distribution_input::Builder,
    }
    impl<C, M, R> UpdateStreamingDistribution<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateStreamingDistribution`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateStreamingDistributionOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateStreamingDistributionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateStreamingDistributionInputOperationOutputAlias,
                crate::output::UpdateStreamingDistributionOutput,
                crate::error::UpdateStreamingDistributionError,
                crate::input::UpdateStreamingDistributionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The streaming distribution's configuration information.</p>
        pub fn streaming_distribution_config(
            mut self,
            inp: crate::model::StreamingDistributionConfig,
        ) -> Self {
            self.inner = self.inner.streaming_distribution_config(inp);
            self
        }
        /// <p>The streaming distribution's configuration information.</p>
        pub fn set_streaming_distribution_config(
            mut self,
            input: std::option::Option<crate::model::StreamingDistributionConfig>,
        ) -> Self {
            self.inner = self.inner.set_streaming_distribution_config(input);
            self
        }
        /// <p>The streaming distribution's id.</p>
        pub fn id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(inp);
            self
        }
        /// <p>The streaming distribution's id.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
        /// <p>The value of the <code>ETag</code> header that you received when retrieving the
        /// streaming distribution's configuration. For example: <code>E2QWRUHAPOMQZL</code>.</p>
        pub fn if_match(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.if_match(inp);
            self
        }
        /// <p>The value of the <code>ETag</code> header that you received when retrieving the
        /// streaming distribution's configuration. For example: <code>E2QWRUHAPOMQZL</code>.</p>
        pub fn set_if_match(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_if_match(input);
            self
        }
    }
}
impl<C> Client<C, crate::middleware::DefaultMiddleware, aws_smithy_client::retry::Standard> {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn(conf: crate::Config, conn: C) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::new()
            .connector(conn)
            .middleware(crate::middleware::DefaultMiddleware::new());
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
impl
    Client<
        aws_smithy_client::erase::DynConnector,
        crate::middleware::DefaultMiddleware,
        aws_smithy_client::retry::Standard,
    >
{
    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(config: &aws_types::config::Config) -> Self {
        Self::from_conf(config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::dyn_https()
            .middleware(crate::middleware::DefaultMiddleware::new());
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        // the builder maintains a try-state. To avoid suppressing the warning when sleep is unset,
        // only set it if we actually have a sleep impl.
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();

        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
