// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// <p>A streaming distribution tells CloudFront where you want RTMP content to be delivered from, and the details about how to
/// track and manage content delivery.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StreamingDistribution {
    /// <p>The identifier for the RTMP distribution. For example:
    /// <code>EGTXBD79EXAMPLE</code>.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The ARN (Amazon Resource Name) for the distribution. For example:
    /// <code>arn:aws:cloudfront::123456789012:distribution/EDFDVBD632BHDS5</code>, where
    /// <code>123456789012</code> is your Amazon Web Services account ID.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The current status of the RTMP distribution. When the status is <code>Deployed</code>,
    /// the distribution's information is propagated to all CloudFront edge locations.</p>
    pub status: std::option::Option<std::string::String>,
    /// <p>The date and time that the distribution was last modified. </p>
    pub last_modified_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The domain name that corresponds to the streaming distribution, for example, <code>s5c39gqb8ow64r.cloudfront.net</code>. </p>
    pub domain_name: std::option::Option<std::string::String>,
    /// <p>A complex type that lists the Amazon Web Services accounts, if any, that you included in the
    /// <code>TrustedSigners</code> complex type for this distribution. These are the accounts that
    /// you want to allow to create signed URLs for private content.</p>
    /// <p>The <code>Signer</code> complex type lists the Amazon Web Services account number of the trusted
    /// signer or <code>self</code> if the signer is the Amazon Web Services account that created the distribution.
    /// The <code>Signer</code> element also includes the IDs of any active CloudFront key pairs that are
    /// associated with the trusted signer's Amazon Web Services account. If no <code>KeyPairId</code> element
    /// appears for a <code>Signer</code>, that signer can't create signed URLs.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html">Serving Private
    /// Content through CloudFront</a> in the <i>Amazon CloudFront Developer Guide</i>. </p>
    pub active_trusted_signers: std::option::Option<crate::model::ActiveTrustedSigners>,
    /// <p>The current configuration information for the RTMP distribution.</p>
    pub streaming_distribution_config:
        std::option::Option<crate::model::StreamingDistributionConfig>,
}
impl StreamingDistribution {
    /// <p>The identifier for the RTMP distribution. For example:
    /// <code>EGTXBD79EXAMPLE</code>.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The ARN (Amazon Resource Name) for the distribution. For example:
    /// <code>arn:aws:cloudfront::123456789012:distribution/EDFDVBD632BHDS5</code>, where
    /// <code>123456789012</code> is your Amazon Web Services account ID.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The current status of the RTMP distribution. When the status is <code>Deployed</code>,
    /// the distribution's information is propagated to all CloudFront edge locations.</p>
    pub fn status(&self) -> std::option::Option<&str> {
        self.status.as_deref()
    }
    /// <p>The date and time that the distribution was last modified. </p>
    pub fn last_modified_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_modified_time.as_ref()
    }
    /// <p>The domain name that corresponds to the streaming distribution, for example, <code>s5c39gqb8ow64r.cloudfront.net</code>. </p>
    pub fn domain_name(&self) -> std::option::Option<&str> {
        self.domain_name.as_deref()
    }
    /// <p>A complex type that lists the Amazon Web Services accounts, if any, that you included in the
    /// <code>TrustedSigners</code> complex type for this distribution. These are the accounts that
    /// you want to allow to create signed URLs for private content.</p>
    /// <p>The <code>Signer</code> complex type lists the Amazon Web Services account number of the trusted
    /// signer or <code>self</code> if the signer is the Amazon Web Services account that created the distribution.
    /// The <code>Signer</code> element also includes the IDs of any active CloudFront key pairs that are
    /// associated with the trusted signer's Amazon Web Services account. If no <code>KeyPairId</code> element
    /// appears for a <code>Signer</code>, that signer can't create signed URLs.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html">Serving Private
    /// Content through CloudFront</a> in the <i>Amazon CloudFront Developer Guide</i>. </p>
    pub fn active_trusted_signers(
        &self,
    ) -> std::option::Option<&crate::model::ActiveTrustedSigners> {
        self.active_trusted_signers.as_ref()
    }
    /// <p>The current configuration information for the RTMP distribution.</p>
    pub fn streaming_distribution_config(
        &self,
    ) -> std::option::Option<&crate::model::StreamingDistributionConfig> {
        self.streaming_distribution_config.as_ref()
    }
}
impl std::fmt::Debug for StreamingDistribution {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StreamingDistribution");
        formatter.field("id", &self.id);
        formatter.field("arn", &self.arn);
        formatter.field("status", &self.status);
        formatter.field("last_modified_time", &self.last_modified_time);
        formatter.field("domain_name", &self.domain_name);
        formatter.field("active_trusted_signers", &self.active_trusted_signers);
        formatter.field(
            "streaming_distribution_config",
            &self.streaming_distribution_config,
        );
        formatter.finish()
    }
}
/// See [`StreamingDistribution`](crate::model::StreamingDistribution)
pub mod streaming_distribution {
    /// A builder for [`StreamingDistribution`](crate::model::StreamingDistribution)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<std::string::String>,
        pub(crate) last_modified_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) domain_name: std::option::Option<std::string::String>,
        pub(crate) active_trusted_signers: std::option::Option<crate::model::ActiveTrustedSigners>,
        pub(crate) streaming_distribution_config:
            std::option::Option<crate::model::StreamingDistributionConfig>,
    }
    impl Builder {
        /// <p>The identifier for the RTMP distribution. For example:
        /// <code>EGTXBD79EXAMPLE</code>.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The identifier for the RTMP distribution. For example:
        /// <code>EGTXBD79EXAMPLE</code>.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The ARN (Amazon Resource Name) for the distribution. For example:
        /// <code>arn:aws:cloudfront::123456789012:distribution/EDFDVBD632BHDS5</code>, where
        /// <code>123456789012</code> is your Amazon Web Services account ID.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The ARN (Amazon Resource Name) for the distribution. For example:
        /// <code>arn:aws:cloudfront::123456789012:distribution/EDFDVBD632BHDS5</code>, where
        /// <code>123456789012</code> is your Amazon Web Services account ID.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The current status of the RTMP distribution. When the status is <code>Deployed</code>,
        /// the distribution's information is propagated to all CloudFront edge locations.</p>
        pub fn status(mut self, input: impl Into<std::string::String>) -> Self {
            self.status = Some(input.into());
            self
        }
        /// <p>The current status of the RTMP distribution. When the status is <code>Deployed</code>,
        /// the distribution's information is propagated to all CloudFront edge locations.</p>
        pub fn set_status(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.status = input;
            self
        }
        /// <p>The date and time that the distribution was last modified. </p>
        pub fn last_modified_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_modified_time = Some(input);
            self
        }
        /// <p>The date and time that the distribution was last modified. </p>
        pub fn set_last_modified_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_modified_time = input;
            self
        }
        /// <p>The domain name that corresponds to the streaming distribution, for example, <code>s5c39gqb8ow64r.cloudfront.net</code>. </p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain_name = Some(input.into());
            self
        }
        /// <p>The domain name that corresponds to the streaming distribution, for example, <code>s5c39gqb8ow64r.cloudfront.net</code>. </p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain_name = input;
            self
        }
        /// <p>A complex type that lists the Amazon Web Services accounts, if any, that you included in the
        /// <code>TrustedSigners</code> complex type for this distribution. These are the accounts that
        /// you want to allow to create signed URLs for private content.</p>
        /// <p>The <code>Signer</code> complex type lists the Amazon Web Services account number of the trusted
        /// signer or <code>self</code> if the signer is the Amazon Web Services account that created the distribution.
        /// The <code>Signer</code> element also includes the IDs of any active CloudFront key pairs that are
        /// associated with the trusted signer's Amazon Web Services account. If no <code>KeyPairId</code> element
        /// appears for a <code>Signer</code>, that signer can't create signed URLs.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html">Serving Private
        /// Content through CloudFront</a> in the <i>Amazon CloudFront Developer Guide</i>. </p>
        pub fn active_trusted_signers(mut self, input: crate::model::ActiveTrustedSigners) -> Self {
            self.active_trusted_signers = Some(input);
            self
        }
        /// <p>A complex type that lists the Amazon Web Services accounts, if any, that you included in the
        /// <code>TrustedSigners</code> complex type for this distribution. These are the accounts that
        /// you want to allow to create signed URLs for private content.</p>
        /// <p>The <code>Signer</code> complex type lists the Amazon Web Services account number of the trusted
        /// signer or <code>self</code> if the signer is the Amazon Web Services account that created the distribution.
        /// The <code>Signer</code> element also includes the IDs of any active CloudFront key pairs that are
        /// associated with the trusted signer's Amazon Web Services account. If no <code>KeyPairId</code> element
        /// appears for a <code>Signer</code>, that signer can't create signed URLs.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html">Serving Private
        /// Content through CloudFront</a> in the <i>Amazon CloudFront Developer Guide</i>. </p>
        pub fn set_active_trusted_signers(
            mut self,
            input: std::option::Option<crate::model::ActiveTrustedSigners>,
        ) -> Self {
            self.active_trusted_signers = input;
            self
        }
        /// <p>The current configuration information for the RTMP distribution.</p>
        pub fn streaming_distribution_config(
            mut self,
            input: crate::model::StreamingDistributionConfig,
        ) -> Self {
            self.streaming_distribution_config = Some(input);
            self
        }
        /// <p>The current configuration information for the RTMP distribution.</p>
        pub fn set_streaming_distribution_config(
            mut self,
            input: std::option::Option<crate::model::StreamingDistributionConfig>,
        ) -> Self {
            self.streaming_distribution_config = input;
            self
        }
        /// Consumes the builder and constructs a [`StreamingDistribution`](crate::model::StreamingDistribution)
        pub fn build(self) -> crate::model::StreamingDistribution {
            crate::model::StreamingDistribution {
                id: self.id,
                arn: self.arn,
                status: self.status,
                last_modified_time: self.last_modified_time,
                domain_name: self.domain_name,
                active_trusted_signers: self.active_trusted_signers,
                streaming_distribution_config: self.streaming_distribution_config,
            }
        }
    }
}
impl StreamingDistribution {
    /// Creates a new builder-style object to manufacture [`StreamingDistribution`](crate::model::StreamingDistribution)
    pub fn builder() -> crate::model::streaming_distribution::Builder {
        crate::model::streaming_distribution::Builder::default()
    }
}

/// <p>The RTMP distribution's configuration information.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StreamingDistributionConfig {
    /// <p>A unique value (for example, a date-time stamp) that ensures that the request can't be
    /// replayed.</p>
    /// <p>If the value of <code>CallerReference</code> is new (regardless of the content of the
    /// <code>StreamingDistributionConfig</code> object), CloudFront creates a new distribution.</p>
    /// <p>If <code>CallerReference</code> is a value that you already sent in a previous request to
    /// create a distribution, CloudFront returns a <code>DistributionAlreadyExists</code> error.</p>
    pub caller_reference: std::option::Option<std::string::String>,
    /// <p>A complex type that contains information about the Amazon S3 bucket from which you want
    /// CloudFront to get your media files for distribution. </p>
    pub s3_origin: std::option::Option<crate::model::S3Origin>,
    /// <p>A complex type that contains information about CNAMEs (alternate domain names), if any,
    /// for this streaming distribution. </p>
    pub aliases: std::option::Option<crate::model::Aliases>,
    /// <p>Any comments you want to include about the streaming distribution. </p>
    pub comment: std::option::Option<std::string::String>,
    /// <p>A complex type that controls whether access logs are written for the streaming
    /// distribution. </p>
    pub logging: std::option::Option<crate::model::StreamingLoggingConfig>,
    /// <p>A complex type that specifies any Amazon Web Services accounts that you want to permit to create signed
    /// URLs for private content. If you want the distribution to use signed URLs, include this
    /// element; if you want the distribution to use public URLs, remove this element. For more
    /// information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html">Serving Private Content through
    /// CloudFront</a> in the <i>Amazon CloudFront Developer Guide</i>. </p>
    pub trusted_signers: std::option::Option<crate::model::TrustedSigners>,
    /// <p>A complex type that contains information about price class for this streaming
    /// distribution. </p>
    pub price_class: std::option::Option<crate::model::PriceClass>,
    /// <p>Whether the streaming distribution is enabled to accept user requests for
    /// content.</p>
    pub enabled: std::option::Option<bool>,
}
impl StreamingDistributionConfig {
    /// <p>A unique value (for example, a date-time stamp) that ensures that the request can't be
    /// replayed.</p>
    /// <p>If the value of <code>CallerReference</code> is new (regardless of the content of the
    /// <code>StreamingDistributionConfig</code> object), CloudFront creates a new distribution.</p>
    /// <p>If <code>CallerReference</code> is a value that you already sent in a previous request to
    /// create a distribution, CloudFront returns a <code>DistributionAlreadyExists</code> error.</p>
    pub fn caller_reference(&self) -> std::option::Option<&str> {
        self.caller_reference.as_deref()
    }
    /// <p>A complex type that contains information about the Amazon S3 bucket from which you want
    /// CloudFront to get your media files for distribution. </p>
    pub fn s3_origin(&self) -> std::option::Option<&crate::model::S3Origin> {
        self.s3_origin.as_ref()
    }
    /// <p>A complex type that contains information about CNAMEs (alternate domain names), if any,
    /// for this streaming distribution. </p>
    pub fn aliases(&self) -> std::option::Option<&crate::model::Aliases> {
        self.aliases.as_ref()
    }
    /// <p>Any comments you want to include about the streaming distribution. </p>
    pub fn comment(&self) -> std::option::Option<&str> {
        self.comment.as_deref()
    }
    /// <p>A complex type that controls whether access logs are written for the streaming
    /// distribution. </p>
    pub fn logging(&self) -> std::option::Option<&crate::model::StreamingLoggingConfig> {
        self.logging.as_ref()
    }
    /// <p>A complex type that specifies any Amazon Web Services accounts that you want to permit to create signed
    /// URLs for private content. If you want the distribution to use signed URLs, include this
    /// element; if you want the distribution to use public URLs, remove this element. For more
    /// information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html">Serving Private Content through
    /// CloudFront</a> in the <i>Amazon CloudFront Developer Guide</i>. </p>
    pub fn trusted_signers(&self) -> std::option::Option<&crate::model::TrustedSigners> {
        self.trusted_signers.as_ref()
    }
    /// <p>A complex type that contains information about price class for this streaming
    /// distribution. </p>
    pub fn price_class(&self) -> std::option::Option<&crate::model::PriceClass> {
        self.price_class.as_ref()
    }
    /// <p>Whether the streaming distribution is enabled to accept user requests for
    /// content.</p>
    pub fn enabled(&self) -> std::option::Option<bool> {
        self.enabled
    }
}
impl std::fmt::Debug for StreamingDistributionConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StreamingDistributionConfig");
        formatter.field("caller_reference", &self.caller_reference);
        formatter.field("s3_origin", &self.s3_origin);
        formatter.field("aliases", &self.aliases);
        formatter.field("comment", &self.comment);
        formatter.field("logging", &self.logging);
        formatter.field("trusted_signers", &self.trusted_signers);
        formatter.field("price_class", &self.price_class);
        formatter.field("enabled", &self.enabled);
        formatter.finish()
    }
}
/// See [`StreamingDistributionConfig`](crate::model::StreamingDistributionConfig)
pub mod streaming_distribution_config {
    /// A builder for [`StreamingDistributionConfig`](crate::model::StreamingDistributionConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) caller_reference: std::option::Option<std::string::String>,
        pub(crate) s3_origin: std::option::Option<crate::model::S3Origin>,
        pub(crate) aliases: std::option::Option<crate::model::Aliases>,
        pub(crate) comment: std::option::Option<std::string::String>,
        pub(crate) logging: std::option::Option<crate::model::StreamingLoggingConfig>,
        pub(crate) trusted_signers: std::option::Option<crate::model::TrustedSigners>,
        pub(crate) price_class: std::option::Option<crate::model::PriceClass>,
        pub(crate) enabled: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>A unique value (for example, a date-time stamp) that ensures that the request can't be
        /// replayed.</p>
        /// <p>If the value of <code>CallerReference</code> is new (regardless of the content of the
        /// <code>StreamingDistributionConfig</code> object), CloudFront creates a new distribution.</p>
        /// <p>If <code>CallerReference</code> is a value that you already sent in a previous request to
        /// create a distribution, CloudFront returns a <code>DistributionAlreadyExists</code> error.</p>
        pub fn caller_reference(mut self, input: impl Into<std::string::String>) -> Self {
            self.caller_reference = Some(input.into());
            self
        }
        /// <p>A unique value (for example, a date-time stamp) that ensures that the request can't be
        /// replayed.</p>
        /// <p>If the value of <code>CallerReference</code> is new (regardless of the content of the
        /// <code>StreamingDistributionConfig</code> object), CloudFront creates a new distribution.</p>
        /// <p>If <code>CallerReference</code> is a value that you already sent in a previous request to
        /// create a distribution, CloudFront returns a <code>DistributionAlreadyExists</code> error.</p>
        pub fn set_caller_reference(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.caller_reference = input;
            self
        }
        /// <p>A complex type that contains information about the Amazon S3 bucket from which you want
        /// CloudFront to get your media files for distribution. </p>
        pub fn s3_origin(mut self, input: crate::model::S3Origin) -> Self {
            self.s3_origin = Some(input);
            self
        }
        /// <p>A complex type that contains information about the Amazon S3 bucket from which you want
        /// CloudFront to get your media files for distribution. </p>
        pub fn set_s3_origin(mut self, input: std::option::Option<crate::model::S3Origin>) -> Self {
            self.s3_origin = input;
            self
        }
        /// <p>A complex type that contains information about CNAMEs (alternate domain names), if any,
        /// for this streaming distribution. </p>
        pub fn aliases(mut self, input: crate::model::Aliases) -> Self {
            self.aliases = Some(input);
            self
        }
        /// <p>A complex type that contains information about CNAMEs (alternate domain names), if any,
        /// for this streaming distribution. </p>
        pub fn set_aliases(mut self, input: std::option::Option<crate::model::Aliases>) -> Self {
            self.aliases = input;
            self
        }
        /// <p>Any comments you want to include about the streaming distribution. </p>
        pub fn comment(mut self, input: impl Into<std::string::String>) -> Self {
            self.comment = Some(input.into());
            self
        }
        /// <p>Any comments you want to include about the streaming distribution. </p>
        pub fn set_comment(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.comment = input;
            self
        }
        /// <p>A complex type that controls whether access logs are written for the streaming
        /// distribution. </p>
        pub fn logging(mut self, input: crate::model::StreamingLoggingConfig) -> Self {
            self.logging = Some(input);
            self
        }
        /// <p>A complex type that controls whether access logs are written for the streaming
        /// distribution. </p>
        pub fn set_logging(
            mut self,
            input: std::option::Option<crate::model::StreamingLoggingConfig>,
        ) -> Self {
            self.logging = input;
            self
        }
        /// <p>A complex type that specifies any Amazon Web Services accounts that you want to permit to create signed
        /// URLs for private content. If you want the distribution to use signed URLs, include this
        /// element; if you want the distribution to use public URLs, remove this element. For more
        /// information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html">Serving Private Content through
        /// CloudFront</a> in the <i>Amazon CloudFront Developer Guide</i>. </p>
        pub fn trusted_signers(mut self, input: crate::model::TrustedSigners) -> Self {
            self.trusted_signers = Some(input);
            self
        }
        /// <p>A complex type that specifies any Amazon Web Services accounts that you want to permit to create signed
        /// URLs for private content. If you want the distribution to use signed URLs, include this
        /// element; if you want the distribution to use public URLs, remove this element. For more
        /// information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html">Serving Private Content through
        /// CloudFront</a> in the <i>Amazon CloudFront Developer Guide</i>. </p>
        pub fn set_trusted_signers(
            mut self,
            input: std::option::Option<crate::model::TrustedSigners>,
        ) -> Self {
            self.trusted_signers = input;
            self
        }
        /// <p>A complex type that contains information about price class for this streaming
        /// distribution. </p>
        pub fn price_class(mut self, input: crate::model::PriceClass) -> Self {
            self.price_class = Some(input);
            self
        }
        /// <p>A complex type that contains information about price class for this streaming
        /// distribution. </p>
        pub fn set_price_class(
            mut self,
            input: std::option::Option<crate::model::PriceClass>,
        ) -> Self {
            self.price_class = input;
            self
        }
        /// <p>Whether the streaming distribution is enabled to accept user requests for
        /// content.</p>
        pub fn enabled(mut self, input: bool) -> Self {
            self.enabled = Some(input);
            self
        }
        /// <p>Whether the streaming distribution is enabled to accept user requests for
        /// content.</p>
        pub fn set_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.enabled = input;
            self
        }
        /// Consumes the builder and constructs a [`StreamingDistributionConfig`](crate::model::StreamingDistributionConfig)
        pub fn build(self) -> crate::model::StreamingDistributionConfig {
            crate::model::StreamingDistributionConfig {
                caller_reference: self.caller_reference,
                s3_origin: self.s3_origin,
                aliases: self.aliases,
                comment: self.comment,
                logging: self.logging,
                trusted_signers: self.trusted_signers,
                price_class: self.price_class,
                enabled: self.enabled,
            }
        }
    }
}
impl StreamingDistributionConfig {
    /// Creates a new builder-style object to manufacture [`StreamingDistributionConfig`](crate::model::StreamingDistributionConfig)
    pub fn builder() -> crate::model::streaming_distribution_config::Builder {
        crate::model::streaming_distribution_config::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum PriceClass {
    #[allow(missing_docs)] // documentation missing in model
    PriceClass100,
    #[allow(missing_docs)] // documentation missing in model
    PriceClass200,
    #[allow(missing_docs)] // documentation missing in model
    PriceClassAll,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for PriceClass {
    fn from(s: &str) -> Self {
        match s {
            "PriceClass_100" => PriceClass::PriceClass100,
            "PriceClass_200" => PriceClass::PriceClass200,
            "PriceClass_All" => PriceClass::PriceClassAll,
            other => PriceClass::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for PriceClass {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(PriceClass::from(s))
    }
}
impl PriceClass {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            PriceClass::PriceClass100 => "PriceClass_100",
            PriceClass::PriceClass200 => "PriceClass_200",
            PriceClass::PriceClassAll => "PriceClass_All",
            PriceClass::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["PriceClass_100", "PriceClass_200", "PriceClass_All"]
    }
}
impl AsRef<str> for PriceClass {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>A list of Amazon Web Services accounts whose public keys CloudFront can use to verify the signatures of signed
/// URLs and signed cookies.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TrustedSigners {
    /// <p>This field is <code>true</code> if any of the Amazon Web Services accounts have public keys that CloudFront can
    /// use to verify the signatures of signed URLs and signed cookies. If not, this field is
    /// <code>false</code>.</p>
    pub enabled: std::option::Option<bool>,
    /// <p>The number of Amazon Web Services accounts in the list.</p>
    pub quantity: std::option::Option<i32>,
    /// <p>A list of Amazon Web Services account identifiers.</p>
    pub items: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl TrustedSigners {
    /// <p>This field is <code>true</code> if any of the Amazon Web Services accounts have public keys that CloudFront can
    /// use to verify the signatures of signed URLs and signed cookies. If not, this field is
    /// <code>false</code>.</p>
    pub fn enabled(&self) -> std::option::Option<bool> {
        self.enabled
    }
    /// <p>The number of Amazon Web Services accounts in the list.</p>
    pub fn quantity(&self) -> std::option::Option<i32> {
        self.quantity
    }
    /// <p>A list of Amazon Web Services account identifiers.</p>
    pub fn items(&self) -> std::option::Option<&[std::string::String]> {
        self.items.as_deref()
    }
}
impl std::fmt::Debug for TrustedSigners {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TrustedSigners");
        formatter.field("enabled", &self.enabled);
        formatter.field("quantity", &self.quantity);
        formatter.field("items", &self.items);
        formatter.finish()
    }
}
/// See [`TrustedSigners`](crate::model::TrustedSigners)
pub mod trusted_signers {
    /// A builder for [`TrustedSigners`](crate::model::TrustedSigners)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) enabled: std::option::Option<bool>,
        pub(crate) quantity: std::option::Option<i32>,
        pub(crate) items: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>This field is <code>true</code> if any of the Amazon Web Services accounts have public keys that CloudFront can
        /// use to verify the signatures of signed URLs and signed cookies. If not, this field is
        /// <code>false</code>.</p>
        pub fn enabled(mut self, input: bool) -> Self {
            self.enabled = Some(input);
            self
        }
        /// <p>This field is <code>true</code> if any of the Amazon Web Services accounts have public keys that CloudFront can
        /// use to verify the signatures of signed URLs and signed cookies. If not, this field is
        /// <code>false</code>.</p>
        pub fn set_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.enabled = input;
            self
        }
        /// <p>The number of Amazon Web Services accounts in the list.</p>
        pub fn quantity(mut self, input: i32) -> Self {
            self.quantity = Some(input);
            self
        }
        /// <p>The number of Amazon Web Services accounts in the list.</p>
        pub fn set_quantity(mut self, input: std::option::Option<i32>) -> Self {
            self.quantity = input;
            self
        }
        /// Appends an item to `items`.
        ///
        /// To override the contents of this collection use [`set_items`](Self::set_items).
        ///
        /// <p>A list of Amazon Web Services account identifiers.</p>
        pub fn items(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.items.unwrap_or_default();
            v.push(input.into());
            self.items = Some(v);
            self
        }
        /// <p>A list of Amazon Web Services account identifiers.</p>
        pub fn set_items(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.items = input;
            self
        }
        /// Consumes the builder and constructs a [`TrustedSigners`](crate::model::TrustedSigners)
        pub fn build(self) -> crate::model::TrustedSigners {
            crate::model::TrustedSigners {
                enabled: self.enabled,
                quantity: self.quantity,
                items: self.items,
            }
        }
    }
}
impl TrustedSigners {
    /// Creates a new builder-style object to manufacture [`TrustedSigners`](crate::model::TrustedSigners)
    pub fn builder() -> crate::model::trusted_signers::Builder {
        crate::model::trusted_signers::Builder::default()
    }
}

/// <p>A complex type that controls whether access logs are written for this streaming distribution.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StreamingLoggingConfig {
    /// <p>Specifies whether you want CloudFront to save access logs to an Amazon S3 bucket. If you don't
    /// want to enable logging when you create a streaming distribution or if you want to disable
    /// logging for an existing streaming distribution, specify <code>false</code> for
    /// <code>Enabled</code>, and specify <code>empty Bucket</code> and <code>Prefix</code>
    /// elements. If you specify <code>false</code> for <code>Enabled</code> but you specify values
    /// for <code>Bucket</code> and <code>Prefix</code>, the values are automatically deleted.
    /// </p>
    pub enabled: std::option::Option<bool>,
    /// <p>The Amazon S3 bucket to store the access logs in, for example, <code>myawslogbucket.s3.amazonaws.com</code>.</p>
    pub bucket: std::option::Option<std::string::String>,
    /// <p>An optional string that you want CloudFront to prefix to the access log filenames for this streaming distribution, for example,
    /// <code>myprefix/</code>. If you want to enable logging, but you don't want to specify a prefix, you still must include
    /// an empty <code>Prefix</code> element in the <code>Logging</code> element.</p>
    pub prefix: std::option::Option<std::string::String>,
}
impl StreamingLoggingConfig {
    /// <p>Specifies whether you want CloudFront to save access logs to an Amazon S3 bucket. If you don't
    /// want to enable logging when you create a streaming distribution or if you want to disable
    /// logging for an existing streaming distribution, specify <code>false</code> for
    /// <code>Enabled</code>, and specify <code>empty Bucket</code> and <code>Prefix</code>
    /// elements. If you specify <code>false</code> for <code>Enabled</code> but you specify values
    /// for <code>Bucket</code> and <code>Prefix</code>, the values are automatically deleted.
    /// </p>
    pub fn enabled(&self) -> std::option::Option<bool> {
        self.enabled
    }
    /// <p>The Amazon S3 bucket to store the access logs in, for example, <code>myawslogbucket.s3.amazonaws.com</code>.</p>
    pub fn bucket(&self) -> std::option::Option<&str> {
        self.bucket.as_deref()
    }
    /// <p>An optional string that you want CloudFront to prefix to the access log filenames for this streaming distribution, for example,
    /// <code>myprefix/</code>. If you want to enable logging, but you don't want to specify a prefix, you still must include
    /// an empty <code>Prefix</code> element in the <code>Logging</code> element.</p>
    pub fn prefix(&self) -> std::option::Option<&str> {
        self.prefix.as_deref()
    }
}
impl std::fmt::Debug for StreamingLoggingConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StreamingLoggingConfig");
        formatter.field("enabled", &self.enabled);
        formatter.field("bucket", &self.bucket);
        formatter.field("prefix", &self.prefix);
        formatter.finish()
    }
}
/// See [`StreamingLoggingConfig`](crate::model::StreamingLoggingConfig)
pub mod streaming_logging_config {
    /// A builder for [`StreamingLoggingConfig`](crate::model::StreamingLoggingConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) enabled: std::option::Option<bool>,
        pub(crate) bucket: std::option::Option<std::string::String>,
        pub(crate) prefix: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Specifies whether you want CloudFront to save access logs to an Amazon S3 bucket. If you don't
        /// want to enable logging when you create a streaming distribution or if you want to disable
        /// logging for an existing streaming distribution, specify <code>false</code> for
        /// <code>Enabled</code>, and specify <code>empty Bucket</code> and <code>Prefix</code>
        /// elements. If you specify <code>false</code> for <code>Enabled</code> but you specify values
        /// for <code>Bucket</code> and <code>Prefix</code>, the values are automatically deleted.
        /// </p>
        pub fn enabled(mut self, input: bool) -> Self {
            self.enabled = Some(input);
            self
        }
        /// <p>Specifies whether you want CloudFront to save access logs to an Amazon S3 bucket. If you don't
        /// want to enable logging when you create a streaming distribution or if you want to disable
        /// logging for an existing streaming distribution, specify <code>false</code> for
        /// <code>Enabled</code>, and specify <code>empty Bucket</code> and <code>Prefix</code>
        /// elements. If you specify <code>false</code> for <code>Enabled</code> but you specify values
        /// for <code>Bucket</code> and <code>Prefix</code>, the values are automatically deleted.
        /// </p>
        pub fn set_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.enabled = input;
            self
        }
        /// <p>The Amazon S3 bucket to store the access logs in, for example, <code>myawslogbucket.s3.amazonaws.com</code>.</p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket = Some(input.into());
            self
        }
        /// <p>The Amazon S3 bucket to store the access logs in, for example, <code>myawslogbucket.s3.amazonaws.com</code>.</p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bucket = input;
            self
        }
        /// <p>An optional string that you want CloudFront to prefix to the access log filenames for this streaming distribution, for example,
        /// <code>myprefix/</code>. If you want to enable logging, but you don't want to specify a prefix, you still must include
        /// an empty <code>Prefix</code> element in the <code>Logging</code> element.</p>
        pub fn prefix(mut self, input: impl Into<std::string::String>) -> Self {
            self.prefix = Some(input.into());
            self
        }
        /// <p>An optional string that you want CloudFront to prefix to the access log filenames for this streaming distribution, for example,
        /// <code>myprefix/</code>. If you want to enable logging, but you don't want to specify a prefix, you still must include
        /// an empty <code>Prefix</code> element in the <code>Logging</code> element.</p>
        pub fn set_prefix(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.prefix = input;
            self
        }
        /// Consumes the builder and constructs a [`StreamingLoggingConfig`](crate::model::StreamingLoggingConfig)
        pub fn build(self) -> crate::model::StreamingLoggingConfig {
            crate::model::StreamingLoggingConfig {
                enabled: self.enabled,
                bucket: self.bucket,
                prefix: self.prefix,
            }
        }
    }
}
impl StreamingLoggingConfig {
    /// Creates a new builder-style object to manufacture [`StreamingLoggingConfig`](crate::model::StreamingLoggingConfig)
    pub fn builder() -> crate::model::streaming_logging_config::Builder {
        crate::model::streaming_logging_config::Builder::default()
    }
}

/// <p>A complex type that contains information about CNAMEs (alternate domain names), if any,
/// for this distribution. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Aliases {
    /// <p>The number of CNAME aliases, if any, that you want to associate with this
    /// distribution.</p>
    pub quantity: std::option::Option<i32>,
    /// <p>A complex type that contains the CNAME aliases, if any, that you want to associate with
    /// this distribution.</p>
    pub items: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl Aliases {
    /// <p>The number of CNAME aliases, if any, that you want to associate with this
    /// distribution.</p>
    pub fn quantity(&self) -> std::option::Option<i32> {
        self.quantity
    }
    /// <p>A complex type that contains the CNAME aliases, if any, that you want to associate with
    /// this distribution.</p>
    pub fn items(&self) -> std::option::Option<&[std::string::String]> {
        self.items.as_deref()
    }
}
impl std::fmt::Debug for Aliases {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Aliases");
        formatter.field("quantity", &self.quantity);
        formatter.field("items", &self.items);
        formatter.finish()
    }
}
/// See [`Aliases`](crate::model::Aliases)
pub mod aliases {
    /// A builder for [`Aliases`](crate::model::Aliases)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) quantity: std::option::Option<i32>,
        pub(crate) items: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The number of CNAME aliases, if any, that you want to associate with this
        /// distribution.</p>
        pub fn quantity(mut self, input: i32) -> Self {
            self.quantity = Some(input);
            self
        }
        /// <p>The number of CNAME aliases, if any, that you want to associate with this
        /// distribution.</p>
        pub fn set_quantity(mut self, input: std::option::Option<i32>) -> Self {
            self.quantity = input;
            self
        }
        /// Appends an item to `items`.
        ///
        /// To override the contents of this collection use [`set_items`](Self::set_items).
        ///
        /// <p>A complex type that contains the CNAME aliases, if any, that you want to associate with
        /// this distribution.</p>
        pub fn items(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.items.unwrap_or_default();
            v.push(input.into());
            self.items = Some(v);
            self
        }
        /// <p>A complex type that contains the CNAME aliases, if any, that you want to associate with
        /// this distribution.</p>
        pub fn set_items(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.items = input;
            self
        }
        /// Consumes the builder and constructs a [`Aliases`](crate::model::Aliases)
        pub fn build(self) -> crate::model::Aliases {
            crate::model::Aliases {
                quantity: self.quantity,
                items: self.items,
            }
        }
    }
}
impl Aliases {
    /// Creates a new builder-style object to manufacture [`Aliases`](crate::model::Aliases)
    pub fn builder() -> crate::model::aliases::Builder {
        crate::model::aliases::Builder::default()
    }
}

/// <p>A complex type that contains information about the Amazon S3 bucket from which you want
/// CloudFront to get your media files for distribution.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct S3Origin {
    /// <p>The DNS name of the Amazon S3 origin. </p>
    pub domain_name: std::option::Option<std::string::String>,
    /// <p>The CloudFront origin access identity to associate with the distribution. Use an origin
    /// access identity to configure the distribution so that end users can only access objects in an
    /// Amazon S3 bucket through CloudFront.</p>
    /// <p>If you want end users to be able to access objects using either the CloudFront URL or the
    /// Amazon S3 URL, specify an empty <code>OriginAccessIdentity</code> element.</p>
    /// <p>To delete the origin access identity from an existing distribution, update the
    /// distribution configuration and include an empty <code>OriginAccessIdentity</code>
    /// element.</p>
    /// <p>To replace the origin access identity, update the distribution configuration and
    /// specify the new origin access identity.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/private-content-restricting-access-to-s3.html">Using an Origin Access
    /// Identity to Restrict Access to Your Amazon S3 Content</a> in the <i>
    /// Amazon CloudFront Developer Guide</i>.</p>
    pub origin_access_identity: std::option::Option<std::string::String>,
}
impl S3Origin {
    /// <p>The DNS name of the Amazon S3 origin. </p>
    pub fn domain_name(&self) -> std::option::Option<&str> {
        self.domain_name.as_deref()
    }
    /// <p>The CloudFront origin access identity to associate with the distribution. Use an origin
    /// access identity to configure the distribution so that end users can only access objects in an
    /// Amazon S3 bucket through CloudFront.</p>
    /// <p>If you want end users to be able to access objects using either the CloudFront URL or the
    /// Amazon S3 URL, specify an empty <code>OriginAccessIdentity</code> element.</p>
    /// <p>To delete the origin access identity from an existing distribution, update the
    /// distribution configuration and include an empty <code>OriginAccessIdentity</code>
    /// element.</p>
    /// <p>To replace the origin access identity, update the distribution configuration and
    /// specify the new origin access identity.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/private-content-restricting-access-to-s3.html">Using an Origin Access
    /// Identity to Restrict Access to Your Amazon S3 Content</a> in the <i>
    /// Amazon CloudFront Developer Guide</i>.</p>
    pub fn origin_access_identity(&self) -> std::option::Option<&str> {
        self.origin_access_identity.as_deref()
    }
}
impl std::fmt::Debug for S3Origin {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("S3Origin");
        formatter.field("domain_name", &self.domain_name);
        formatter.field("origin_access_identity", &self.origin_access_identity);
        formatter.finish()
    }
}
/// See [`S3Origin`](crate::model::S3Origin)
pub mod s3_origin {
    /// A builder for [`S3Origin`](crate::model::S3Origin)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) domain_name: std::option::Option<std::string::String>,
        pub(crate) origin_access_identity: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The DNS name of the Amazon S3 origin. </p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain_name = Some(input.into());
            self
        }
        /// <p>The DNS name of the Amazon S3 origin. </p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain_name = input;
            self
        }
        /// <p>The CloudFront origin access identity to associate with the distribution. Use an origin
        /// access identity to configure the distribution so that end users can only access objects in an
        /// Amazon S3 bucket through CloudFront.</p>
        /// <p>If you want end users to be able to access objects using either the CloudFront URL or the
        /// Amazon S3 URL, specify an empty <code>OriginAccessIdentity</code> element.</p>
        /// <p>To delete the origin access identity from an existing distribution, update the
        /// distribution configuration and include an empty <code>OriginAccessIdentity</code>
        /// element.</p>
        /// <p>To replace the origin access identity, update the distribution configuration and
        /// specify the new origin access identity.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/private-content-restricting-access-to-s3.html">Using an Origin Access
        /// Identity to Restrict Access to Your Amazon S3 Content</a> in the <i>
        /// Amazon CloudFront Developer Guide</i>.</p>
        pub fn origin_access_identity(mut self, input: impl Into<std::string::String>) -> Self {
            self.origin_access_identity = Some(input.into());
            self
        }
        /// <p>The CloudFront origin access identity to associate with the distribution. Use an origin
        /// access identity to configure the distribution so that end users can only access objects in an
        /// Amazon S3 bucket through CloudFront.</p>
        /// <p>If you want end users to be able to access objects using either the CloudFront URL or the
        /// Amazon S3 URL, specify an empty <code>OriginAccessIdentity</code> element.</p>
        /// <p>To delete the origin access identity from an existing distribution, update the
        /// distribution configuration and include an empty <code>OriginAccessIdentity</code>
        /// element.</p>
        /// <p>To replace the origin access identity, update the distribution configuration and
        /// specify the new origin access identity.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/private-content-restricting-access-to-s3.html">Using an Origin Access
        /// Identity to Restrict Access to Your Amazon S3 Content</a> in the <i>
        /// Amazon CloudFront Developer Guide</i>.</p>
        pub fn set_origin_access_identity(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.origin_access_identity = input;
            self
        }
        /// Consumes the builder and constructs a [`S3Origin`](crate::model::S3Origin)
        pub fn build(self) -> crate::model::S3Origin {
            crate::model::S3Origin {
                domain_name: self.domain_name,
                origin_access_identity: self.origin_access_identity,
            }
        }
    }
}
impl S3Origin {
    /// Creates a new builder-style object to manufacture [`S3Origin`](crate::model::S3Origin)
    pub fn builder() -> crate::model::s3_origin::Builder {
        crate::model::s3_origin::Builder::default()
    }
}

/// <p>A list of Amazon Web Services accounts and the active CloudFront key pairs in each account that CloudFront can use
/// to verify the signatures of signed URLs and signed cookies.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ActiveTrustedSigners {
    /// <p>This field is <code>true</code> if any of the Amazon Web Services accounts in the list have active CloudFront
    /// key pairs that CloudFront can use to verify the signatures of signed URLs and signed cookies.
    /// If not, this field is <code>false</code>.</p>
    pub enabled: std::option::Option<bool>,
    /// <p>The number of Amazon Web Services accounts in the list.</p>
    pub quantity: std::option::Option<i32>,
    /// <p>A list of Amazon Web Services accounts and the identifiers of active CloudFront key pairs in each account that
    /// CloudFront can use to verify the signatures of signed URLs and signed cookies.</p>
    pub items: std::option::Option<std::vec::Vec<crate::model::Signer>>,
}
impl ActiveTrustedSigners {
    /// <p>This field is <code>true</code> if any of the Amazon Web Services accounts in the list have active CloudFront
    /// key pairs that CloudFront can use to verify the signatures of signed URLs and signed cookies.
    /// If not, this field is <code>false</code>.</p>
    pub fn enabled(&self) -> std::option::Option<bool> {
        self.enabled
    }
    /// <p>The number of Amazon Web Services accounts in the list.</p>
    pub fn quantity(&self) -> std::option::Option<i32> {
        self.quantity
    }
    /// <p>A list of Amazon Web Services accounts and the identifiers of active CloudFront key pairs in each account that
    /// CloudFront can use to verify the signatures of signed URLs and signed cookies.</p>
    pub fn items(&self) -> std::option::Option<&[crate::model::Signer]> {
        self.items.as_deref()
    }
}
impl std::fmt::Debug for ActiveTrustedSigners {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ActiveTrustedSigners");
        formatter.field("enabled", &self.enabled);
        formatter.field("quantity", &self.quantity);
        formatter.field("items", &self.items);
        formatter.finish()
    }
}
/// See [`ActiveTrustedSigners`](crate::model::ActiveTrustedSigners)
pub mod active_trusted_signers {
    /// A builder for [`ActiveTrustedSigners`](crate::model::ActiveTrustedSigners)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) enabled: std::option::Option<bool>,
        pub(crate) quantity: std::option::Option<i32>,
        pub(crate) items: std::option::Option<std::vec::Vec<crate::model::Signer>>,
    }
    impl Builder {
        /// <p>This field is <code>true</code> if any of the Amazon Web Services accounts in the list have active CloudFront
        /// key pairs that CloudFront can use to verify the signatures of signed URLs and signed cookies.
        /// If not, this field is <code>false</code>.</p>
        pub fn enabled(mut self, input: bool) -> Self {
            self.enabled = Some(input);
            self
        }
        /// <p>This field is <code>true</code> if any of the Amazon Web Services accounts in the list have active CloudFront
        /// key pairs that CloudFront can use to verify the signatures of signed URLs and signed cookies.
        /// If not, this field is <code>false</code>.</p>
        pub fn set_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.enabled = input;
            self
        }
        /// <p>The number of Amazon Web Services accounts in the list.</p>
        pub fn quantity(mut self, input: i32) -> Self {
            self.quantity = Some(input);
            self
        }
        /// <p>The number of Amazon Web Services accounts in the list.</p>
        pub fn set_quantity(mut self, input: std::option::Option<i32>) -> Self {
            self.quantity = input;
            self
        }
        /// Appends an item to `items`.
        ///
        /// To override the contents of this collection use [`set_items`](Self::set_items).
        ///
        /// <p>A list of Amazon Web Services accounts and the identifiers of active CloudFront key pairs in each account that
        /// CloudFront can use to verify the signatures of signed URLs and signed cookies.</p>
        pub fn items(mut self, input: impl Into<crate::model::Signer>) -> Self {
            let mut v = self.items.unwrap_or_default();
            v.push(input.into());
            self.items = Some(v);
            self
        }
        /// <p>A list of Amazon Web Services accounts and the identifiers of active CloudFront key pairs in each account that
        /// CloudFront can use to verify the signatures of signed URLs and signed cookies.</p>
        pub fn set_items(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Signer>>,
        ) -> Self {
            self.items = input;
            self
        }
        /// Consumes the builder and constructs a [`ActiveTrustedSigners`](crate::model::ActiveTrustedSigners)
        pub fn build(self) -> crate::model::ActiveTrustedSigners {
            crate::model::ActiveTrustedSigners {
                enabled: self.enabled,
                quantity: self.quantity,
                items: self.items,
            }
        }
    }
}
impl ActiveTrustedSigners {
    /// Creates a new builder-style object to manufacture [`ActiveTrustedSigners`](crate::model::ActiveTrustedSigners)
    pub fn builder() -> crate::model::active_trusted_signers::Builder {
        crate::model::active_trusted_signers::Builder::default()
    }
}

/// <p>A list of Amazon Web Services accounts and the active CloudFront key pairs in each account that CloudFront can use to
/// verify the signatures of signed URLs and signed cookies.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Signer {
    /// <p>An Amazon Web Services account number that contains active CloudFront key pairs that CloudFront can use to verify the
    /// signatures of signed URLs and signed cookies. If the Amazon Web Services account that owns the key pairs
    /// is the same account that owns the CloudFront distribution, the value of this field is
    /// <code>self</code>.</p>
    pub aws_account_number: std::option::Option<std::string::String>,
    /// <p>A list of CloudFront key pair identifiers.</p>
    pub key_pair_ids: std::option::Option<crate::model::KeyPairIds>,
}
impl Signer {
    /// <p>An Amazon Web Services account number that contains active CloudFront key pairs that CloudFront can use to verify the
    /// signatures of signed URLs and signed cookies. If the Amazon Web Services account that owns the key pairs
    /// is the same account that owns the CloudFront distribution, the value of this field is
    /// <code>self</code>.</p>
    pub fn aws_account_number(&self) -> std::option::Option<&str> {
        self.aws_account_number.as_deref()
    }
    /// <p>A list of CloudFront key pair identifiers.</p>
    pub fn key_pair_ids(&self) -> std::option::Option<&crate::model::KeyPairIds> {
        self.key_pair_ids.as_ref()
    }
}
impl std::fmt::Debug for Signer {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Signer");
        formatter.field("aws_account_number", &self.aws_account_number);
        formatter.field("key_pair_ids", &self.key_pair_ids);
        formatter.finish()
    }
}
/// See [`Signer`](crate::model::Signer)
pub mod signer {
    /// A builder for [`Signer`](crate::model::Signer)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) aws_account_number: std::option::Option<std::string::String>,
        pub(crate) key_pair_ids: std::option::Option<crate::model::KeyPairIds>,
    }
    impl Builder {
        /// <p>An Amazon Web Services account number that contains active CloudFront key pairs that CloudFront can use to verify the
        /// signatures of signed URLs and signed cookies. If the Amazon Web Services account that owns the key pairs
        /// is the same account that owns the CloudFront distribution, the value of this field is
        /// <code>self</code>.</p>
        pub fn aws_account_number(mut self, input: impl Into<std::string::String>) -> Self {
            self.aws_account_number = Some(input.into());
            self
        }
        /// <p>An Amazon Web Services account number that contains active CloudFront key pairs that CloudFront can use to verify the
        /// signatures of signed URLs and signed cookies. If the Amazon Web Services account that owns the key pairs
        /// is the same account that owns the CloudFront distribution, the value of this field is
        /// <code>self</code>.</p>
        pub fn set_aws_account_number(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.aws_account_number = input;
            self
        }
        /// <p>A list of CloudFront key pair identifiers.</p>
        pub fn key_pair_ids(mut self, input: crate::model::KeyPairIds) -> Self {
            self.key_pair_ids = Some(input);
            self
        }
        /// <p>A list of CloudFront key pair identifiers.</p>
        pub fn set_key_pair_ids(
            mut self,
            input: std::option::Option<crate::model::KeyPairIds>,
        ) -> Self {
            self.key_pair_ids = input;
            self
        }
        /// Consumes the builder and constructs a [`Signer`](crate::model::Signer)
        pub fn build(self) -> crate::model::Signer {
            crate::model::Signer {
                aws_account_number: self.aws_account_number,
                key_pair_ids: self.key_pair_ids,
            }
        }
    }
}
impl Signer {
    /// Creates a new builder-style object to manufacture [`Signer`](crate::model::Signer)
    pub fn builder() -> crate::model::signer::Builder {
        crate::model::signer::Builder::default()
    }
}

/// <p>A list of CloudFront key pair identifiers.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct KeyPairIds {
    /// <p>The number of key pair identifiers in the list.</p>
    pub quantity: std::option::Option<i32>,
    /// <p>A list of CloudFront key pair identifiers.</p>
    pub items: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl KeyPairIds {
    /// <p>The number of key pair identifiers in the list.</p>
    pub fn quantity(&self) -> std::option::Option<i32> {
        self.quantity
    }
    /// <p>A list of CloudFront key pair identifiers.</p>
    pub fn items(&self) -> std::option::Option<&[std::string::String]> {
        self.items.as_deref()
    }
}
impl std::fmt::Debug for KeyPairIds {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("KeyPairIds");
        formatter.field("quantity", &self.quantity);
        formatter.field("items", &self.items);
        formatter.finish()
    }
}
/// See [`KeyPairIds`](crate::model::KeyPairIds)
pub mod key_pair_ids {
    /// A builder for [`KeyPairIds`](crate::model::KeyPairIds)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) quantity: std::option::Option<i32>,
        pub(crate) items: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The number of key pair identifiers in the list.</p>
        pub fn quantity(mut self, input: i32) -> Self {
            self.quantity = Some(input);
            self
        }
        /// <p>The number of key pair identifiers in the list.</p>
        pub fn set_quantity(mut self, input: std::option::Option<i32>) -> Self {
            self.quantity = input;
            self
        }
        /// Appends an item to `items`.
        ///
        /// To override the contents of this collection use [`set_items`](Self::set_items).
        ///
        /// <p>A list of CloudFront key pair identifiers.</p>
        pub fn items(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.items.unwrap_or_default();
            v.push(input.into());
            self.items = Some(v);
            self
        }
        /// <p>A list of CloudFront key pair identifiers.</p>
        pub fn set_items(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.items = input;
            self
        }
        /// Consumes the builder and constructs a [`KeyPairIds`](crate::model::KeyPairIds)
        pub fn build(self) -> crate::model::KeyPairIds {
            crate::model::KeyPairIds {
                quantity: self.quantity,
                items: self.items,
            }
        }
    }
}
impl KeyPairIds {
    /// Creates a new builder-style object to manufacture [`KeyPairIds`](crate::model::KeyPairIds)
    pub fn builder() -> crate::model::key_pair_ids::Builder {
        crate::model::key_pair_ids::Builder::default()
    }
}

/// <p>A response headers policy.</p>
/// <p>A response headers policy contains information about a set of HTTP response headers
/// and their values.</p>
/// <p>After you create a response headers policy, you can use its ID to attach it to one or more
/// cache behaviors in a CloudFront distribution. When it’s attached to a cache behavior, CloudFront
/// adds the headers in the policy to HTTP responses that it sends for requests that match
/// the cache behavior.</p>
/// <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/adding-response-headers.html">Adding HTTP headers to CloudFront responses</a> in the
/// <i>Amazon CloudFront Developer Guide</i>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResponseHeadersPolicy {
    /// <p>The identifier for the response headers policy.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The date and time when the response headers policy was last modified.</p>
    pub last_modified_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>A response headers policy configuration.</p>
    /// <p>A response headers policy contains information about a set of HTTP response headers and
    /// their values. CloudFront adds the headers in the policy to HTTP responses that it sends for
    /// requests that match a cache behavior that’s associated with the policy.</p>
    pub response_headers_policy_config:
        std::option::Option<crate::model::ResponseHeadersPolicyConfig>,
}
impl ResponseHeadersPolicy {
    /// <p>The identifier for the response headers policy.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The date and time when the response headers policy was last modified.</p>
    pub fn last_modified_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_modified_time.as_ref()
    }
    /// <p>A response headers policy configuration.</p>
    /// <p>A response headers policy contains information about a set of HTTP response headers and
    /// their values. CloudFront adds the headers in the policy to HTTP responses that it sends for
    /// requests that match a cache behavior that’s associated with the policy.</p>
    pub fn response_headers_policy_config(
        &self,
    ) -> std::option::Option<&crate::model::ResponseHeadersPolicyConfig> {
        self.response_headers_policy_config.as_ref()
    }
}
impl std::fmt::Debug for ResponseHeadersPolicy {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResponseHeadersPolicy");
        formatter.field("id", &self.id);
        formatter.field("last_modified_time", &self.last_modified_time);
        formatter.field(
            "response_headers_policy_config",
            &self.response_headers_policy_config,
        );
        formatter.finish()
    }
}
/// See [`ResponseHeadersPolicy`](crate::model::ResponseHeadersPolicy)
pub mod response_headers_policy {
    /// A builder for [`ResponseHeadersPolicy`](crate::model::ResponseHeadersPolicy)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) last_modified_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) response_headers_policy_config:
            std::option::Option<crate::model::ResponseHeadersPolicyConfig>,
    }
    impl Builder {
        /// <p>The identifier for the response headers policy.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The identifier for the response headers policy.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The date and time when the response headers policy was last modified.</p>
        pub fn last_modified_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_modified_time = Some(input);
            self
        }
        /// <p>The date and time when the response headers policy was last modified.</p>
        pub fn set_last_modified_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_modified_time = input;
            self
        }
        /// <p>A response headers policy configuration.</p>
        /// <p>A response headers policy contains information about a set of HTTP response headers and
        /// their values. CloudFront adds the headers in the policy to HTTP responses that it sends for
        /// requests that match a cache behavior that’s associated with the policy.</p>
        pub fn response_headers_policy_config(
            mut self,
            input: crate::model::ResponseHeadersPolicyConfig,
        ) -> Self {
            self.response_headers_policy_config = Some(input);
            self
        }
        /// <p>A response headers policy configuration.</p>
        /// <p>A response headers policy contains information about a set of HTTP response headers and
        /// their values. CloudFront adds the headers in the policy to HTTP responses that it sends for
        /// requests that match a cache behavior that’s associated with the policy.</p>
        pub fn set_response_headers_policy_config(
            mut self,
            input: std::option::Option<crate::model::ResponseHeadersPolicyConfig>,
        ) -> Self {
            self.response_headers_policy_config = input;
            self
        }
        /// Consumes the builder and constructs a [`ResponseHeadersPolicy`](crate::model::ResponseHeadersPolicy)
        pub fn build(self) -> crate::model::ResponseHeadersPolicy {
            crate::model::ResponseHeadersPolicy {
                id: self.id,
                last_modified_time: self.last_modified_time,
                response_headers_policy_config: self.response_headers_policy_config,
            }
        }
    }
}
impl ResponseHeadersPolicy {
    /// Creates a new builder-style object to manufacture [`ResponseHeadersPolicy`](crate::model::ResponseHeadersPolicy)
    pub fn builder() -> crate::model::response_headers_policy::Builder {
        crate::model::response_headers_policy::Builder::default()
    }
}

/// <p>A response headers policy configuration.</p>
/// <p>A response headers policy configuration contains metadata about the response headers policy,
/// and configurations for sets of HTTP response headers and their values. CloudFront adds the
/// headers in the policy to HTTP responses that it sends for requests that match a cache
/// behavior associated with the policy.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResponseHeadersPolicyConfig {
    /// <p>A comment to describe the response headers policy.</p>
    /// <p>The comment cannot be longer than 128 characters.</p>
    pub comment: std::option::Option<std::string::String>,
    /// <p>A name to identify the response headers policy.</p>
    /// <p>The name must be unique for response headers policies in this Amazon Web Services account.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>A configuration for a set of HTTP response headers that are used for cross-origin
    /// resource sharing (CORS).</p>
    pub cors_config: std::option::Option<crate::model::ResponseHeadersPolicyCorsConfig>,
    /// <p>A configuration for a set of security-related HTTP response headers.</p>
    pub security_headers_config:
        std::option::Option<crate::model::ResponseHeadersPolicySecurityHeadersConfig>,
    /// <p>A configuration for a set of custom HTTP response headers.</p>
    pub custom_headers_config:
        std::option::Option<crate::model::ResponseHeadersPolicyCustomHeadersConfig>,
}
impl ResponseHeadersPolicyConfig {
    /// <p>A comment to describe the response headers policy.</p>
    /// <p>The comment cannot be longer than 128 characters.</p>
    pub fn comment(&self) -> std::option::Option<&str> {
        self.comment.as_deref()
    }
    /// <p>A name to identify the response headers policy.</p>
    /// <p>The name must be unique for response headers policies in this Amazon Web Services account.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>A configuration for a set of HTTP response headers that are used for cross-origin
    /// resource sharing (CORS).</p>
    pub fn cors_config(
        &self,
    ) -> std::option::Option<&crate::model::ResponseHeadersPolicyCorsConfig> {
        self.cors_config.as_ref()
    }
    /// <p>A configuration for a set of security-related HTTP response headers.</p>
    pub fn security_headers_config(
        &self,
    ) -> std::option::Option<&crate::model::ResponseHeadersPolicySecurityHeadersConfig> {
        self.security_headers_config.as_ref()
    }
    /// <p>A configuration for a set of custom HTTP response headers.</p>
    pub fn custom_headers_config(
        &self,
    ) -> std::option::Option<&crate::model::ResponseHeadersPolicyCustomHeadersConfig> {
        self.custom_headers_config.as_ref()
    }
}
impl std::fmt::Debug for ResponseHeadersPolicyConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResponseHeadersPolicyConfig");
        formatter.field("comment", &self.comment);
        formatter.field("name", &self.name);
        formatter.field("cors_config", &self.cors_config);
        formatter.field("security_headers_config", &self.security_headers_config);
        formatter.field("custom_headers_config", &self.custom_headers_config);
        formatter.finish()
    }
}
/// See [`ResponseHeadersPolicyConfig`](crate::model::ResponseHeadersPolicyConfig)
pub mod response_headers_policy_config {
    /// A builder for [`ResponseHeadersPolicyConfig`](crate::model::ResponseHeadersPolicyConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) comment: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) cors_config: std::option::Option<crate::model::ResponseHeadersPolicyCorsConfig>,
        pub(crate) security_headers_config:
            std::option::Option<crate::model::ResponseHeadersPolicySecurityHeadersConfig>,
        pub(crate) custom_headers_config:
            std::option::Option<crate::model::ResponseHeadersPolicyCustomHeadersConfig>,
    }
    impl Builder {
        /// <p>A comment to describe the response headers policy.</p>
        /// <p>The comment cannot be longer than 128 characters.</p>
        pub fn comment(mut self, input: impl Into<std::string::String>) -> Self {
            self.comment = Some(input.into());
            self
        }
        /// <p>A comment to describe the response headers policy.</p>
        /// <p>The comment cannot be longer than 128 characters.</p>
        pub fn set_comment(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.comment = input;
            self
        }
        /// <p>A name to identify the response headers policy.</p>
        /// <p>The name must be unique for response headers policies in this Amazon Web Services account.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>A name to identify the response headers policy.</p>
        /// <p>The name must be unique for response headers policies in this Amazon Web Services account.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>A configuration for a set of HTTP response headers that are used for cross-origin
        /// resource sharing (CORS).</p>
        pub fn cors_config(mut self, input: crate::model::ResponseHeadersPolicyCorsConfig) -> Self {
            self.cors_config = Some(input);
            self
        }
        /// <p>A configuration for a set of HTTP response headers that are used for cross-origin
        /// resource sharing (CORS).</p>
        pub fn set_cors_config(
            mut self,
            input: std::option::Option<crate::model::ResponseHeadersPolicyCorsConfig>,
        ) -> Self {
            self.cors_config = input;
            self
        }
        /// <p>A configuration for a set of security-related HTTP response headers.</p>
        pub fn security_headers_config(
            mut self,
            input: crate::model::ResponseHeadersPolicySecurityHeadersConfig,
        ) -> Self {
            self.security_headers_config = Some(input);
            self
        }
        /// <p>A configuration for a set of security-related HTTP response headers.</p>
        pub fn set_security_headers_config(
            mut self,
            input: std::option::Option<crate::model::ResponseHeadersPolicySecurityHeadersConfig>,
        ) -> Self {
            self.security_headers_config = input;
            self
        }
        /// <p>A configuration for a set of custom HTTP response headers.</p>
        pub fn custom_headers_config(
            mut self,
            input: crate::model::ResponseHeadersPolicyCustomHeadersConfig,
        ) -> Self {
            self.custom_headers_config = Some(input);
            self
        }
        /// <p>A configuration for a set of custom HTTP response headers.</p>
        pub fn set_custom_headers_config(
            mut self,
            input: std::option::Option<crate::model::ResponseHeadersPolicyCustomHeadersConfig>,
        ) -> Self {
            self.custom_headers_config = input;
            self
        }
        /// Consumes the builder and constructs a [`ResponseHeadersPolicyConfig`](crate::model::ResponseHeadersPolicyConfig)
        pub fn build(self) -> crate::model::ResponseHeadersPolicyConfig {
            crate::model::ResponseHeadersPolicyConfig {
                comment: self.comment,
                name: self.name,
                cors_config: self.cors_config,
                security_headers_config: self.security_headers_config,
                custom_headers_config: self.custom_headers_config,
            }
        }
    }
}
impl ResponseHeadersPolicyConfig {
    /// Creates a new builder-style object to manufacture [`ResponseHeadersPolicyConfig`](crate::model::ResponseHeadersPolicyConfig)
    pub fn builder() -> crate::model::response_headers_policy_config::Builder {
        crate::model::response_headers_policy_config::Builder::default()
    }
}

/// <p>A list of HTTP response header names and their values. CloudFront includes these headers in HTTP
/// responses that it sends for requests that match a cache behavior that’s associated with
/// this response headers policy.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResponseHeadersPolicyCustomHeadersConfig {
    /// <p>The number of HTTP response headers in the list.</p>
    pub quantity: std::option::Option<i32>,
    /// <p>The list of HTTP response headers and their values.</p>
    pub items: std::option::Option<std::vec::Vec<crate::model::ResponseHeadersPolicyCustomHeader>>,
}
impl ResponseHeadersPolicyCustomHeadersConfig {
    /// <p>The number of HTTP response headers in the list.</p>
    pub fn quantity(&self) -> std::option::Option<i32> {
        self.quantity
    }
    /// <p>The list of HTTP response headers and their values.</p>
    pub fn items(&self) -> std::option::Option<&[crate::model::ResponseHeadersPolicyCustomHeader]> {
        self.items.as_deref()
    }
}
impl std::fmt::Debug for ResponseHeadersPolicyCustomHeadersConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResponseHeadersPolicyCustomHeadersConfig");
        formatter.field("quantity", &self.quantity);
        formatter.field("items", &self.items);
        formatter.finish()
    }
}
/// See [`ResponseHeadersPolicyCustomHeadersConfig`](crate::model::ResponseHeadersPolicyCustomHeadersConfig)
pub mod response_headers_policy_custom_headers_config {
    /// A builder for [`ResponseHeadersPolicyCustomHeadersConfig`](crate::model::ResponseHeadersPolicyCustomHeadersConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) quantity: std::option::Option<i32>,
        pub(crate) items:
            std::option::Option<std::vec::Vec<crate::model::ResponseHeadersPolicyCustomHeader>>,
    }
    impl Builder {
        /// <p>The number of HTTP response headers in the list.</p>
        pub fn quantity(mut self, input: i32) -> Self {
            self.quantity = Some(input);
            self
        }
        /// <p>The number of HTTP response headers in the list.</p>
        pub fn set_quantity(mut self, input: std::option::Option<i32>) -> Self {
            self.quantity = input;
            self
        }
        /// Appends an item to `items`.
        ///
        /// To override the contents of this collection use [`set_items`](Self::set_items).
        ///
        /// <p>The list of HTTP response headers and their values.</p>
        pub fn items(
            mut self,
            input: impl Into<crate::model::ResponseHeadersPolicyCustomHeader>,
        ) -> Self {
            let mut v = self.items.unwrap_or_default();
            v.push(input.into());
            self.items = Some(v);
            self
        }
        /// <p>The list of HTTP response headers and their values.</p>
        pub fn set_items(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::ResponseHeadersPolicyCustomHeader>,
            >,
        ) -> Self {
            self.items = input;
            self
        }
        /// Consumes the builder and constructs a [`ResponseHeadersPolicyCustomHeadersConfig`](crate::model::ResponseHeadersPolicyCustomHeadersConfig)
        pub fn build(self) -> crate::model::ResponseHeadersPolicyCustomHeadersConfig {
            crate::model::ResponseHeadersPolicyCustomHeadersConfig {
                quantity: self.quantity,
                items: self.items,
            }
        }
    }
}
impl ResponseHeadersPolicyCustomHeadersConfig {
    /// Creates a new builder-style object to manufacture [`ResponseHeadersPolicyCustomHeadersConfig`](crate::model::ResponseHeadersPolicyCustomHeadersConfig)
    pub fn builder() -> crate::model::response_headers_policy_custom_headers_config::Builder {
        crate::model::response_headers_policy_custom_headers_config::Builder::default()
    }
}

/// <p>An HTTP response header name and its value. CloudFront includes this header in HTTP responses that
/// it sends for requests that match a cache behavior that’s associated with this response
/// headers policy.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResponseHeadersPolicyCustomHeader {
    /// <p>The HTTP response header name.</p>
    pub header: std::option::Option<std::string::String>,
    /// <p>The value for the HTTP response header.</p>
    pub value: std::option::Option<std::string::String>,
    /// <p>A Boolean that determines whether CloudFront overrides a response header with the same name
    /// received from the origin with the header specified here.</p>
    pub r#override: std::option::Option<bool>,
}
impl ResponseHeadersPolicyCustomHeader {
    /// <p>The HTTP response header name.</p>
    pub fn header(&self) -> std::option::Option<&str> {
        self.header.as_deref()
    }
    /// <p>The value for the HTTP response header.</p>
    pub fn value(&self) -> std::option::Option<&str> {
        self.value.as_deref()
    }
    /// <p>A Boolean that determines whether CloudFront overrides a response header with the same name
    /// received from the origin with the header specified here.</p>
    pub fn r#override(&self) -> std::option::Option<bool> {
        self.r#override
    }
}
impl std::fmt::Debug for ResponseHeadersPolicyCustomHeader {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResponseHeadersPolicyCustomHeader");
        formatter.field("header", &self.header);
        formatter.field("value", &self.value);
        formatter.field("r#override", &self.r#override);
        formatter.finish()
    }
}
/// See [`ResponseHeadersPolicyCustomHeader`](crate::model::ResponseHeadersPolicyCustomHeader)
pub mod response_headers_policy_custom_header {
    /// A builder for [`ResponseHeadersPolicyCustomHeader`](crate::model::ResponseHeadersPolicyCustomHeader)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) header: std::option::Option<std::string::String>,
        pub(crate) value: std::option::Option<std::string::String>,
        pub(crate) r#override: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The HTTP response header name.</p>
        pub fn header(mut self, input: impl Into<std::string::String>) -> Self {
            self.header = Some(input.into());
            self
        }
        /// <p>The HTTP response header name.</p>
        pub fn set_header(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.header = input;
            self
        }
        /// <p>The value for the HTTP response header.</p>
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            self.value = Some(input.into());
            self
        }
        /// <p>The value for the HTTP response header.</p>
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.value = input;
            self
        }
        /// <p>A Boolean that determines whether CloudFront overrides a response header with the same name
        /// received from the origin with the header specified here.</p>
        pub fn r#override(mut self, input: bool) -> Self {
            self.r#override = Some(input);
            self
        }
        /// <p>A Boolean that determines whether CloudFront overrides a response header with the same name
        /// received from the origin with the header specified here.</p>
        pub fn set_override(mut self, input: std::option::Option<bool>) -> Self {
            self.r#override = input;
            self
        }
        /// Consumes the builder and constructs a [`ResponseHeadersPolicyCustomHeader`](crate::model::ResponseHeadersPolicyCustomHeader)
        pub fn build(self) -> crate::model::ResponseHeadersPolicyCustomHeader {
            crate::model::ResponseHeadersPolicyCustomHeader {
                header: self.header,
                value: self.value,
                r#override: self.r#override,
            }
        }
    }
}
impl ResponseHeadersPolicyCustomHeader {
    /// Creates a new builder-style object to manufacture [`ResponseHeadersPolicyCustomHeader`](crate::model::ResponseHeadersPolicyCustomHeader)
    pub fn builder() -> crate::model::response_headers_policy_custom_header::Builder {
        crate::model::response_headers_policy_custom_header::Builder::default()
    }
}

/// <p>A configuration for a set of security-related HTTP response headers. CloudFront adds these headers
/// to HTTP responses that it sends for requests that match a cache behavior associated with
/// this response headers policy.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResponseHeadersPolicySecurityHeadersConfig {
    /// <p>Determines whether CloudFront includes the <code>X-XSS-Protection</code> HTTP response header and
    /// the header’s value.</p>
    /// <p>For more information about the <code>X-XSS-Protection</code> HTTP response header, see
    /// <a href="https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/X-XSS-Protection">X-XSS-Protection</a> in the MDN Web Docs.</p>
    pub xss_protection: std::option::Option<crate::model::ResponseHeadersPolicyXssProtection>,
    /// <p>Determines whether CloudFront includes the <code>X-Frame-Options</code> HTTP response header and
    /// the header’s value.</p>
    /// <p>For more information about the <code>X-Frame-Options</code> HTTP response header, see
    /// <a href="https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/X-Frame-Options">X-Frame-Options</a> in the MDN Web Docs.</p>
    pub frame_options: std::option::Option<crate::model::ResponseHeadersPolicyFrameOptions>,
    /// <p>Determines whether CloudFront includes the <code>Referrer-Policy</code> HTTP response header and
    /// the header’s value.</p>
    /// <p>For more information about the <code>Referrer-Policy</code> HTTP response header, see
    /// <a href="https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Referrer-Policy">Referrer-Policy</a> in the MDN Web Docs.</p>
    pub referrer_policy: std::option::Option<crate::model::ResponseHeadersPolicyReferrerPolicy>,
    /// <p>The policy directives and their values that CloudFront includes as values for the
    /// <code>Content-Security-Policy</code> HTTP response header.</p>
    /// <p>For more information about the <code>Content-Security-Policy</code> HTTP response
    /// header, see <a href="https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Content-Security-Policy">Content-Security-Policy</a> in the MDN Web Docs.</p>
    pub content_security_policy:
        std::option::Option<crate::model::ResponseHeadersPolicyContentSecurityPolicy>,
    /// <p>Determines whether CloudFront includes the <code>X-Content-Type-Options</code> HTTP response
    /// header with its value set to <code>nosniff</code>.</p>
    /// <p>For more information about the <code>X-Content-Type-Options</code> HTTP response
    /// header, see <a href="https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/X-Content-Type-Options">X-Content-Type-Options</a> in the MDN Web Docs.</p>
    pub content_type_options:
        std::option::Option<crate::model::ResponseHeadersPolicyContentTypeOptions>,
    /// <p>Determines whether CloudFront includes the <code>Strict-Transport-Security</code> HTTP response
    /// header and the header’s value.</p>
    /// <p>For more information about the <code>Strict-Transport-Security</code> HTTP response
    /// header, see <a href="https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Strict-Transport-Security">Strict-Transport-Security</a> in the MDN Web Docs.</p>
    pub strict_transport_security:
        std::option::Option<crate::model::ResponseHeadersPolicyStrictTransportSecurity>,
}
impl ResponseHeadersPolicySecurityHeadersConfig {
    /// <p>Determines whether CloudFront includes the <code>X-XSS-Protection</code> HTTP response header and
    /// the header’s value.</p>
    /// <p>For more information about the <code>X-XSS-Protection</code> HTTP response header, see
    /// <a href="https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/X-XSS-Protection">X-XSS-Protection</a> in the MDN Web Docs.</p>
    pub fn xss_protection(
        &self,
    ) -> std::option::Option<&crate::model::ResponseHeadersPolicyXssProtection> {
        self.xss_protection.as_ref()
    }
    /// <p>Determines whether CloudFront includes the <code>X-Frame-Options</code> HTTP response header and
    /// the header’s value.</p>
    /// <p>For more information about the <code>X-Frame-Options</code> HTTP response header, see
    /// <a href="https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/X-Frame-Options">X-Frame-Options</a> in the MDN Web Docs.</p>
    pub fn frame_options(
        &self,
    ) -> std::option::Option<&crate::model::ResponseHeadersPolicyFrameOptions> {
        self.frame_options.as_ref()
    }
    /// <p>Determines whether CloudFront includes the <code>Referrer-Policy</code> HTTP response header and
    /// the header’s value.</p>
    /// <p>For more information about the <code>Referrer-Policy</code> HTTP response header, see
    /// <a href="https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Referrer-Policy">Referrer-Policy</a> in the MDN Web Docs.</p>
    pub fn referrer_policy(
        &self,
    ) -> std::option::Option<&crate::model::ResponseHeadersPolicyReferrerPolicy> {
        self.referrer_policy.as_ref()
    }
    /// <p>The policy directives and their values that CloudFront includes as values for the
    /// <code>Content-Security-Policy</code> HTTP response header.</p>
    /// <p>For more information about the <code>Content-Security-Policy</code> HTTP response
    /// header, see <a href="https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Content-Security-Policy">Content-Security-Policy</a> in the MDN Web Docs.</p>
    pub fn content_security_policy(
        &self,
    ) -> std::option::Option<&crate::model::ResponseHeadersPolicyContentSecurityPolicy> {
        self.content_security_policy.as_ref()
    }
    /// <p>Determines whether CloudFront includes the <code>X-Content-Type-Options</code> HTTP response
    /// header with its value set to <code>nosniff</code>.</p>
    /// <p>For more information about the <code>X-Content-Type-Options</code> HTTP response
    /// header, see <a href="https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/X-Content-Type-Options">X-Content-Type-Options</a> in the MDN Web Docs.</p>
    pub fn content_type_options(
        &self,
    ) -> std::option::Option<&crate::model::ResponseHeadersPolicyContentTypeOptions> {
        self.content_type_options.as_ref()
    }
    /// <p>Determines whether CloudFront includes the <code>Strict-Transport-Security</code> HTTP response
    /// header and the header’s value.</p>
    /// <p>For more information about the <code>Strict-Transport-Security</code> HTTP response
    /// header, see <a href="https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Strict-Transport-Security">Strict-Transport-Security</a> in the MDN Web Docs.</p>
    pub fn strict_transport_security(
        &self,
    ) -> std::option::Option<&crate::model::ResponseHeadersPolicyStrictTransportSecurity> {
        self.strict_transport_security.as_ref()
    }
}
impl std::fmt::Debug for ResponseHeadersPolicySecurityHeadersConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResponseHeadersPolicySecurityHeadersConfig");
        formatter.field("xss_protection", &self.xss_protection);
        formatter.field("frame_options", &self.frame_options);
        formatter.field("referrer_policy", &self.referrer_policy);
        formatter.field("content_security_policy", &self.content_security_policy);
        formatter.field("content_type_options", &self.content_type_options);
        formatter.field("strict_transport_security", &self.strict_transport_security);
        formatter.finish()
    }
}
/// See [`ResponseHeadersPolicySecurityHeadersConfig`](crate::model::ResponseHeadersPolicySecurityHeadersConfig)
pub mod response_headers_policy_security_headers_config {
    /// A builder for [`ResponseHeadersPolicySecurityHeadersConfig`](crate::model::ResponseHeadersPolicySecurityHeadersConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) xss_protection:
            std::option::Option<crate::model::ResponseHeadersPolicyXssProtection>,
        pub(crate) frame_options:
            std::option::Option<crate::model::ResponseHeadersPolicyFrameOptions>,
        pub(crate) referrer_policy:
            std::option::Option<crate::model::ResponseHeadersPolicyReferrerPolicy>,
        pub(crate) content_security_policy:
            std::option::Option<crate::model::ResponseHeadersPolicyContentSecurityPolicy>,
        pub(crate) content_type_options:
            std::option::Option<crate::model::ResponseHeadersPolicyContentTypeOptions>,
        pub(crate) strict_transport_security:
            std::option::Option<crate::model::ResponseHeadersPolicyStrictTransportSecurity>,
    }
    impl Builder {
        /// <p>Determines whether CloudFront includes the <code>X-XSS-Protection</code> HTTP response header and
        /// the header’s value.</p>
        /// <p>For more information about the <code>X-XSS-Protection</code> HTTP response header, see
        /// <a href="https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/X-XSS-Protection">X-XSS-Protection</a> in the MDN Web Docs.</p>
        pub fn xss_protection(
            mut self,
            input: crate::model::ResponseHeadersPolicyXssProtection,
        ) -> Self {
            self.xss_protection = Some(input);
            self
        }
        /// <p>Determines whether CloudFront includes the <code>X-XSS-Protection</code> HTTP response header and
        /// the header’s value.</p>
        /// <p>For more information about the <code>X-XSS-Protection</code> HTTP response header, see
        /// <a href="https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/X-XSS-Protection">X-XSS-Protection</a> in the MDN Web Docs.</p>
        pub fn set_xss_protection(
            mut self,
            input: std::option::Option<crate::model::ResponseHeadersPolicyXssProtection>,
        ) -> Self {
            self.xss_protection = input;
            self
        }
        /// <p>Determines whether CloudFront includes the <code>X-Frame-Options</code> HTTP response header and
        /// the header’s value.</p>
        /// <p>For more information about the <code>X-Frame-Options</code> HTTP response header, see
        /// <a href="https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/X-Frame-Options">X-Frame-Options</a> in the MDN Web Docs.</p>
        pub fn frame_options(
            mut self,
            input: crate::model::ResponseHeadersPolicyFrameOptions,
        ) -> Self {
            self.frame_options = Some(input);
            self
        }
        /// <p>Determines whether CloudFront includes the <code>X-Frame-Options</code> HTTP response header and
        /// the header’s value.</p>
        /// <p>For more information about the <code>X-Frame-Options</code> HTTP response header, see
        /// <a href="https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/X-Frame-Options">X-Frame-Options</a> in the MDN Web Docs.</p>
        pub fn set_frame_options(
            mut self,
            input: std::option::Option<crate::model::ResponseHeadersPolicyFrameOptions>,
        ) -> Self {
            self.frame_options = input;
            self
        }
        /// <p>Determines whether CloudFront includes the <code>Referrer-Policy</code> HTTP response header and
        /// the header’s value.</p>
        /// <p>For more information about the <code>Referrer-Policy</code> HTTP response header, see
        /// <a href="https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Referrer-Policy">Referrer-Policy</a> in the MDN Web Docs.</p>
        pub fn referrer_policy(
            mut self,
            input: crate::model::ResponseHeadersPolicyReferrerPolicy,
        ) -> Self {
            self.referrer_policy = Some(input);
            self
        }
        /// <p>Determines whether CloudFront includes the <code>Referrer-Policy</code> HTTP response header and
        /// the header’s value.</p>
        /// <p>For more information about the <code>Referrer-Policy</code> HTTP response header, see
        /// <a href="https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Referrer-Policy">Referrer-Policy</a> in the MDN Web Docs.</p>
        pub fn set_referrer_policy(
            mut self,
            input: std::option::Option<crate::model::ResponseHeadersPolicyReferrerPolicy>,
        ) -> Self {
            self.referrer_policy = input;
            self
        }
        /// <p>The policy directives and their values that CloudFront includes as values for the
        /// <code>Content-Security-Policy</code> HTTP response header.</p>
        /// <p>For more information about the <code>Content-Security-Policy</code> HTTP response
        /// header, see <a href="https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Content-Security-Policy">Content-Security-Policy</a> in the MDN Web Docs.</p>
        pub fn content_security_policy(
            mut self,
            input: crate::model::ResponseHeadersPolicyContentSecurityPolicy,
        ) -> Self {
            self.content_security_policy = Some(input);
            self
        }
        /// <p>The policy directives and their values that CloudFront includes as values for the
        /// <code>Content-Security-Policy</code> HTTP response header.</p>
        /// <p>For more information about the <code>Content-Security-Policy</code> HTTP response
        /// header, see <a href="https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Content-Security-Policy">Content-Security-Policy</a> in the MDN Web Docs.</p>
        pub fn set_content_security_policy(
            mut self,
            input: std::option::Option<crate::model::ResponseHeadersPolicyContentSecurityPolicy>,
        ) -> Self {
            self.content_security_policy = input;
            self
        }
        /// <p>Determines whether CloudFront includes the <code>X-Content-Type-Options</code> HTTP response
        /// header with its value set to <code>nosniff</code>.</p>
        /// <p>For more information about the <code>X-Content-Type-Options</code> HTTP response
        /// header, see <a href="https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/X-Content-Type-Options">X-Content-Type-Options</a> in the MDN Web Docs.</p>
        pub fn content_type_options(
            mut self,
            input: crate::model::ResponseHeadersPolicyContentTypeOptions,
        ) -> Self {
            self.content_type_options = Some(input);
            self
        }
        /// <p>Determines whether CloudFront includes the <code>X-Content-Type-Options</code> HTTP response
        /// header with its value set to <code>nosniff</code>.</p>
        /// <p>For more information about the <code>X-Content-Type-Options</code> HTTP response
        /// header, see <a href="https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/X-Content-Type-Options">X-Content-Type-Options</a> in the MDN Web Docs.</p>
        pub fn set_content_type_options(
            mut self,
            input: std::option::Option<crate::model::ResponseHeadersPolicyContentTypeOptions>,
        ) -> Self {
            self.content_type_options = input;
            self
        }
        /// <p>Determines whether CloudFront includes the <code>Strict-Transport-Security</code> HTTP response
        /// header and the header’s value.</p>
        /// <p>For more information about the <code>Strict-Transport-Security</code> HTTP response
        /// header, see <a href="https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Strict-Transport-Security">Strict-Transport-Security</a> in the MDN Web Docs.</p>
        pub fn strict_transport_security(
            mut self,
            input: crate::model::ResponseHeadersPolicyStrictTransportSecurity,
        ) -> Self {
            self.strict_transport_security = Some(input);
            self
        }
        /// <p>Determines whether CloudFront includes the <code>Strict-Transport-Security</code> HTTP response
        /// header and the header’s value.</p>
        /// <p>For more information about the <code>Strict-Transport-Security</code> HTTP response
        /// header, see <a href="https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Strict-Transport-Security">Strict-Transport-Security</a> in the MDN Web Docs.</p>
        pub fn set_strict_transport_security(
            mut self,
            input: std::option::Option<crate::model::ResponseHeadersPolicyStrictTransportSecurity>,
        ) -> Self {
            self.strict_transport_security = input;
            self
        }
        /// Consumes the builder and constructs a [`ResponseHeadersPolicySecurityHeadersConfig`](crate::model::ResponseHeadersPolicySecurityHeadersConfig)
        pub fn build(self) -> crate::model::ResponseHeadersPolicySecurityHeadersConfig {
            crate::model::ResponseHeadersPolicySecurityHeadersConfig {
                xss_protection: self.xss_protection,
                frame_options: self.frame_options,
                referrer_policy: self.referrer_policy,
                content_security_policy: self.content_security_policy,
                content_type_options: self.content_type_options,
                strict_transport_security: self.strict_transport_security,
            }
        }
    }
}
impl ResponseHeadersPolicySecurityHeadersConfig {
    /// Creates a new builder-style object to manufacture [`ResponseHeadersPolicySecurityHeadersConfig`](crate::model::ResponseHeadersPolicySecurityHeadersConfig)
    pub fn builder() -> crate::model::response_headers_policy_security_headers_config::Builder {
        crate::model::response_headers_policy_security_headers_config::Builder::default()
    }
}

/// <p>Determines whether CloudFront includes the <code>Strict-Transport-Security</code> HTTP response
/// header and the header’s value.</p>
/// <p>For more information about the <code>Strict-Transport-Security</code> HTTP response
/// header, see <a href="https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Strict-Transport-Security">Strict-Transport-Security</a> in the MDN Web Docs.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResponseHeadersPolicyStrictTransportSecurity {
    /// <p>A Boolean that determines whether CloudFront overrides the <code>Strict-Transport-Security</code>
    /// HTTP response header received from the origin with the one specified in this response
    /// headers policy.</p>
    pub r#override: std::option::Option<bool>,
    /// <p>A Boolean that determines whether CloudFront includes the <code>includeSubDomains</code> directive
    /// in the <code>Strict-Transport-Security</code> HTTP response header.</p>
    pub include_subdomains: std::option::Option<bool>,
    /// <p>A Boolean that determines whether CloudFront includes the <code>preload</code> directive in the
    /// <code>Strict-Transport-Security</code> HTTP response header.</p>
    pub preload: std::option::Option<bool>,
    /// <p>A number that CloudFront uses as the value for the <code>max-age</code> directive in the
    /// <code>Strict-Transport-Security</code> HTTP response header.</p>
    pub access_control_max_age_sec: std::option::Option<i32>,
}
impl ResponseHeadersPolicyStrictTransportSecurity {
    /// <p>A Boolean that determines whether CloudFront overrides the <code>Strict-Transport-Security</code>
    /// HTTP response header received from the origin with the one specified in this response
    /// headers policy.</p>
    pub fn r#override(&self) -> std::option::Option<bool> {
        self.r#override
    }
    /// <p>A Boolean that determines whether CloudFront includes the <code>includeSubDomains</code> directive
    /// in the <code>Strict-Transport-Security</code> HTTP response header.</p>
    pub fn include_subdomains(&self) -> std::option::Option<bool> {
        self.include_subdomains
    }
    /// <p>A Boolean that determines whether CloudFront includes the <code>preload</code> directive in the
    /// <code>Strict-Transport-Security</code> HTTP response header.</p>
    pub fn preload(&self) -> std::option::Option<bool> {
        self.preload
    }
    /// <p>A number that CloudFront uses as the value for the <code>max-age</code> directive in the
    /// <code>Strict-Transport-Security</code> HTTP response header.</p>
    pub fn access_control_max_age_sec(&self) -> std::option::Option<i32> {
        self.access_control_max_age_sec
    }
}
impl std::fmt::Debug for ResponseHeadersPolicyStrictTransportSecurity {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResponseHeadersPolicyStrictTransportSecurity");
        formatter.field("r#override", &self.r#override);
        formatter.field("include_subdomains", &self.include_subdomains);
        formatter.field("preload", &self.preload);
        formatter.field(
            "access_control_max_age_sec",
            &self.access_control_max_age_sec,
        );
        formatter.finish()
    }
}
/// See [`ResponseHeadersPolicyStrictTransportSecurity`](crate::model::ResponseHeadersPolicyStrictTransportSecurity)
pub mod response_headers_policy_strict_transport_security {
    /// A builder for [`ResponseHeadersPolicyStrictTransportSecurity`](crate::model::ResponseHeadersPolicyStrictTransportSecurity)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) r#override: std::option::Option<bool>,
        pub(crate) include_subdomains: std::option::Option<bool>,
        pub(crate) preload: std::option::Option<bool>,
        pub(crate) access_control_max_age_sec: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>A Boolean that determines whether CloudFront overrides the <code>Strict-Transport-Security</code>
        /// HTTP response header received from the origin with the one specified in this response
        /// headers policy.</p>
        pub fn r#override(mut self, input: bool) -> Self {
            self.r#override = Some(input);
            self
        }
        /// <p>A Boolean that determines whether CloudFront overrides the <code>Strict-Transport-Security</code>
        /// HTTP response header received from the origin with the one specified in this response
        /// headers policy.</p>
        pub fn set_override(mut self, input: std::option::Option<bool>) -> Self {
            self.r#override = input;
            self
        }
        /// <p>A Boolean that determines whether CloudFront includes the <code>includeSubDomains</code> directive
        /// in the <code>Strict-Transport-Security</code> HTTP response header.</p>
        pub fn include_subdomains(mut self, input: bool) -> Self {
            self.include_subdomains = Some(input);
            self
        }
        /// <p>A Boolean that determines whether CloudFront includes the <code>includeSubDomains</code> directive
        /// in the <code>Strict-Transport-Security</code> HTTP response header.</p>
        pub fn set_include_subdomains(mut self, input: std::option::Option<bool>) -> Self {
            self.include_subdomains = input;
            self
        }
        /// <p>A Boolean that determines whether CloudFront includes the <code>preload</code> directive in the
        /// <code>Strict-Transport-Security</code> HTTP response header.</p>
        pub fn preload(mut self, input: bool) -> Self {
            self.preload = Some(input);
            self
        }
        /// <p>A Boolean that determines whether CloudFront includes the <code>preload</code> directive in the
        /// <code>Strict-Transport-Security</code> HTTP response header.</p>
        pub fn set_preload(mut self, input: std::option::Option<bool>) -> Self {
            self.preload = input;
            self
        }
        /// <p>A number that CloudFront uses as the value for the <code>max-age</code> directive in the
        /// <code>Strict-Transport-Security</code> HTTP response header.</p>
        pub fn access_control_max_age_sec(mut self, input: i32) -> Self {
            self.access_control_max_age_sec = Some(input);
            self
        }
        /// <p>A number that CloudFront uses as the value for the <code>max-age</code> directive in the
        /// <code>Strict-Transport-Security</code> HTTP response header.</p>
        pub fn set_access_control_max_age_sec(mut self, input: std::option::Option<i32>) -> Self {
            self.access_control_max_age_sec = input;
            self
        }
        /// Consumes the builder and constructs a [`ResponseHeadersPolicyStrictTransportSecurity`](crate::model::ResponseHeadersPolicyStrictTransportSecurity)
        pub fn build(self) -> crate::model::ResponseHeadersPolicyStrictTransportSecurity {
            crate::model::ResponseHeadersPolicyStrictTransportSecurity {
                r#override: self.r#override,
                include_subdomains: self.include_subdomains,
                preload: self.preload,
                access_control_max_age_sec: self.access_control_max_age_sec,
            }
        }
    }
}
impl ResponseHeadersPolicyStrictTransportSecurity {
    /// Creates a new builder-style object to manufacture [`ResponseHeadersPolicyStrictTransportSecurity`](crate::model::ResponseHeadersPolicyStrictTransportSecurity)
    pub fn builder() -> crate::model::response_headers_policy_strict_transport_security::Builder {
        crate::model::response_headers_policy_strict_transport_security::Builder::default()
    }
}

/// <p>Determines whether CloudFront includes the <code>X-Content-Type-Options</code> HTTP response
/// header with its value set to <code>nosniff</code>.</p>
/// <p>For more information about the <code>X-Content-Type-Options</code> HTTP response
/// header, see <a href="https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/X-Content-Type-Options">X-Content-Type-Options</a> in the MDN Web Docs.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResponseHeadersPolicyContentTypeOptions {
    /// <p>A Boolean that determines whether CloudFront overrides the <code>X-Content-Type-Options</code>
    /// HTTP response header received from the origin with the one specified in this response
    /// headers policy.</p>
    pub r#override: std::option::Option<bool>,
}
impl ResponseHeadersPolicyContentTypeOptions {
    /// <p>A Boolean that determines whether CloudFront overrides the <code>X-Content-Type-Options</code>
    /// HTTP response header received from the origin with the one specified in this response
    /// headers policy.</p>
    pub fn r#override(&self) -> std::option::Option<bool> {
        self.r#override
    }
}
impl std::fmt::Debug for ResponseHeadersPolicyContentTypeOptions {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResponseHeadersPolicyContentTypeOptions");
        formatter.field("r#override", &self.r#override);
        formatter.finish()
    }
}
/// See [`ResponseHeadersPolicyContentTypeOptions`](crate::model::ResponseHeadersPolicyContentTypeOptions)
pub mod response_headers_policy_content_type_options {
    /// A builder for [`ResponseHeadersPolicyContentTypeOptions`](crate::model::ResponseHeadersPolicyContentTypeOptions)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) r#override: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>A Boolean that determines whether CloudFront overrides the <code>X-Content-Type-Options</code>
        /// HTTP response header received from the origin with the one specified in this response
        /// headers policy.</p>
        pub fn r#override(mut self, input: bool) -> Self {
            self.r#override = Some(input);
            self
        }
        /// <p>A Boolean that determines whether CloudFront overrides the <code>X-Content-Type-Options</code>
        /// HTTP response header received from the origin with the one specified in this response
        /// headers policy.</p>
        pub fn set_override(mut self, input: std::option::Option<bool>) -> Self {
            self.r#override = input;
            self
        }
        /// Consumes the builder and constructs a [`ResponseHeadersPolicyContentTypeOptions`](crate::model::ResponseHeadersPolicyContentTypeOptions)
        pub fn build(self) -> crate::model::ResponseHeadersPolicyContentTypeOptions {
            crate::model::ResponseHeadersPolicyContentTypeOptions {
                r#override: self.r#override,
            }
        }
    }
}
impl ResponseHeadersPolicyContentTypeOptions {
    /// Creates a new builder-style object to manufacture [`ResponseHeadersPolicyContentTypeOptions`](crate::model::ResponseHeadersPolicyContentTypeOptions)
    pub fn builder() -> crate::model::response_headers_policy_content_type_options::Builder {
        crate::model::response_headers_policy_content_type_options::Builder::default()
    }
}

/// <p>The policy directives and their values that CloudFront includes as values for the
/// <code>Content-Security-Policy</code> HTTP response header.</p>
/// <p>For more information about the <code>Content-Security-Policy</code> HTTP response
/// header, see <a href="https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Content-Security-Policy">Content-Security-Policy</a> in the MDN Web Docs.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResponseHeadersPolicyContentSecurityPolicy {
    /// <p>A Boolean that determines whether CloudFront overrides the <code>Content-Security-Policy</code>
    /// HTTP response header received from the origin with the one specified in this response
    /// headers policy.</p>
    pub r#override: std::option::Option<bool>,
    /// <p>The policy directives and their values that CloudFront includes as values for the
    /// <code>Content-Security-Policy</code> HTTP response header.</p>
    pub content_security_policy: std::option::Option<std::string::String>,
}
impl ResponseHeadersPolicyContentSecurityPolicy {
    /// <p>A Boolean that determines whether CloudFront overrides the <code>Content-Security-Policy</code>
    /// HTTP response header received from the origin with the one specified in this response
    /// headers policy.</p>
    pub fn r#override(&self) -> std::option::Option<bool> {
        self.r#override
    }
    /// <p>The policy directives and their values that CloudFront includes as values for the
    /// <code>Content-Security-Policy</code> HTTP response header.</p>
    pub fn content_security_policy(&self) -> std::option::Option<&str> {
        self.content_security_policy.as_deref()
    }
}
impl std::fmt::Debug for ResponseHeadersPolicyContentSecurityPolicy {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResponseHeadersPolicyContentSecurityPolicy");
        formatter.field("r#override", &self.r#override);
        formatter.field("content_security_policy", &self.content_security_policy);
        formatter.finish()
    }
}
/// See [`ResponseHeadersPolicyContentSecurityPolicy`](crate::model::ResponseHeadersPolicyContentSecurityPolicy)
pub mod response_headers_policy_content_security_policy {
    /// A builder for [`ResponseHeadersPolicyContentSecurityPolicy`](crate::model::ResponseHeadersPolicyContentSecurityPolicy)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) r#override: std::option::Option<bool>,
        pub(crate) content_security_policy: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A Boolean that determines whether CloudFront overrides the <code>Content-Security-Policy</code>
        /// HTTP response header received from the origin with the one specified in this response
        /// headers policy.</p>
        pub fn r#override(mut self, input: bool) -> Self {
            self.r#override = Some(input);
            self
        }
        /// <p>A Boolean that determines whether CloudFront overrides the <code>Content-Security-Policy</code>
        /// HTTP response header received from the origin with the one specified in this response
        /// headers policy.</p>
        pub fn set_override(mut self, input: std::option::Option<bool>) -> Self {
            self.r#override = input;
            self
        }
        /// <p>The policy directives and their values that CloudFront includes as values for the
        /// <code>Content-Security-Policy</code> HTTP response header.</p>
        pub fn content_security_policy(mut self, input: impl Into<std::string::String>) -> Self {
            self.content_security_policy = Some(input.into());
            self
        }
        /// <p>The policy directives and their values that CloudFront includes as values for the
        /// <code>Content-Security-Policy</code> HTTP response header.</p>
        pub fn set_content_security_policy(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.content_security_policy = input;
            self
        }
        /// Consumes the builder and constructs a [`ResponseHeadersPolicyContentSecurityPolicy`](crate::model::ResponseHeadersPolicyContentSecurityPolicy)
        pub fn build(self) -> crate::model::ResponseHeadersPolicyContentSecurityPolicy {
            crate::model::ResponseHeadersPolicyContentSecurityPolicy {
                r#override: self.r#override,
                content_security_policy: self.content_security_policy,
            }
        }
    }
}
impl ResponseHeadersPolicyContentSecurityPolicy {
    /// Creates a new builder-style object to manufacture [`ResponseHeadersPolicyContentSecurityPolicy`](crate::model::ResponseHeadersPolicyContentSecurityPolicy)
    pub fn builder() -> crate::model::response_headers_policy_content_security_policy::Builder {
        crate::model::response_headers_policy_content_security_policy::Builder::default()
    }
}

/// <p>Determines whether CloudFront includes the <code>Referrer-Policy</code> HTTP response header and
/// the header’s value.</p>
/// <p>For more information about the <code>Referrer-Policy</code> HTTP response header, see
/// <a href="https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Referrer-Policy">Referrer-Policy</a> in the MDN Web Docs.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResponseHeadersPolicyReferrerPolicy {
    /// <p>A Boolean that determines whether CloudFront overrides the <code>Referrer-Policy</code> HTTP
    /// response header received from the origin with the one specified in this response headers
    /// policy.</p>
    pub r#override: std::option::Option<bool>,
    /// <p>The value of the <code>Referrer-Policy</code> HTTP response header. Valid values
    /// are:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>no-referrer</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>no-referrer-when-downgrade</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>origin</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>origin-when-cross-origin</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>same-origin</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>strict-origin</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>strict-origin-when-cross-origin</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>unsafe-url</code>
    /// </p>
    /// </li>
    /// </ul>
    /// <p>For more information about these values, see <a href="https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Referrer-Policy">Referrer-Policy</a> in the MDN Web Docs.</p>
    pub referrer_policy: std::option::Option<crate::model::ReferrerPolicyList>,
}
impl ResponseHeadersPolicyReferrerPolicy {
    /// <p>A Boolean that determines whether CloudFront overrides the <code>Referrer-Policy</code> HTTP
    /// response header received from the origin with the one specified in this response headers
    /// policy.</p>
    pub fn r#override(&self) -> std::option::Option<bool> {
        self.r#override
    }
    /// <p>The value of the <code>Referrer-Policy</code> HTTP response header. Valid values
    /// are:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>no-referrer</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>no-referrer-when-downgrade</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>origin</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>origin-when-cross-origin</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>same-origin</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>strict-origin</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>strict-origin-when-cross-origin</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>unsafe-url</code>
    /// </p>
    /// </li>
    /// </ul>
    /// <p>For more information about these values, see <a href="https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Referrer-Policy">Referrer-Policy</a> in the MDN Web Docs.</p>
    pub fn referrer_policy(&self) -> std::option::Option<&crate::model::ReferrerPolicyList> {
        self.referrer_policy.as_ref()
    }
}
impl std::fmt::Debug for ResponseHeadersPolicyReferrerPolicy {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResponseHeadersPolicyReferrerPolicy");
        formatter.field("r#override", &self.r#override);
        formatter.field("referrer_policy", &self.referrer_policy);
        formatter.finish()
    }
}
/// See [`ResponseHeadersPolicyReferrerPolicy`](crate::model::ResponseHeadersPolicyReferrerPolicy)
pub mod response_headers_policy_referrer_policy {
    /// A builder for [`ResponseHeadersPolicyReferrerPolicy`](crate::model::ResponseHeadersPolicyReferrerPolicy)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) r#override: std::option::Option<bool>,
        pub(crate) referrer_policy: std::option::Option<crate::model::ReferrerPolicyList>,
    }
    impl Builder {
        /// <p>A Boolean that determines whether CloudFront overrides the <code>Referrer-Policy</code> HTTP
        /// response header received from the origin with the one specified in this response headers
        /// policy.</p>
        pub fn r#override(mut self, input: bool) -> Self {
            self.r#override = Some(input);
            self
        }
        /// <p>A Boolean that determines whether CloudFront overrides the <code>Referrer-Policy</code> HTTP
        /// response header received from the origin with the one specified in this response headers
        /// policy.</p>
        pub fn set_override(mut self, input: std::option::Option<bool>) -> Self {
            self.r#override = input;
            self
        }
        /// <p>The value of the <code>Referrer-Policy</code> HTTP response header. Valid values
        /// are:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>no-referrer</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>no-referrer-when-downgrade</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>origin</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>origin-when-cross-origin</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>same-origin</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>strict-origin</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>strict-origin-when-cross-origin</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>unsafe-url</code>
        /// </p>
        /// </li>
        /// </ul>
        /// <p>For more information about these values, see <a href="https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Referrer-Policy">Referrer-Policy</a> in the MDN Web Docs.</p>
        pub fn referrer_policy(mut self, input: crate::model::ReferrerPolicyList) -> Self {
            self.referrer_policy = Some(input);
            self
        }
        /// <p>The value of the <code>Referrer-Policy</code> HTTP response header. Valid values
        /// are:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>no-referrer</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>no-referrer-when-downgrade</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>origin</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>origin-when-cross-origin</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>same-origin</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>strict-origin</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>strict-origin-when-cross-origin</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>unsafe-url</code>
        /// </p>
        /// </li>
        /// </ul>
        /// <p>For more information about these values, see <a href="https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Referrer-Policy">Referrer-Policy</a> in the MDN Web Docs.</p>
        pub fn set_referrer_policy(
            mut self,
            input: std::option::Option<crate::model::ReferrerPolicyList>,
        ) -> Self {
            self.referrer_policy = input;
            self
        }
        /// Consumes the builder and constructs a [`ResponseHeadersPolicyReferrerPolicy`](crate::model::ResponseHeadersPolicyReferrerPolicy)
        pub fn build(self) -> crate::model::ResponseHeadersPolicyReferrerPolicy {
            crate::model::ResponseHeadersPolicyReferrerPolicy {
                r#override: self.r#override,
                referrer_policy: self.referrer_policy,
            }
        }
    }
}
impl ResponseHeadersPolicyReferrerPolicy {
    /// Creates a new builder-style object to manufacture [`ResponseHeadersPolicyReferrerPolicy`](crate::model::ResponseHeadersPolicyReferrerPolicy)
    pub fn builder() -> crate::model::response_headers_policy_referrer_policy::Builder {
        crate::model::response_headers_policy_referrer_policy::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ReferrerPolicyList {
    #[allow(missing_docs)] // documentation missing in model
    NoReferrer,
    #[allow(missing_docs)] // documentation missing in model
    NoReferrerWhenDowngrade,
    #[allow(missing_docs)] // documentation missing in model
    Origin,
    #[allow(missing_docs)] // documentation missing in model
    OriginWhenCrossOrigin,
    #[allow(missing_docs)] // documentation missing in model
    SameOrigin,
    #[allow(missing_docs)] // documentation missing in model
    StrictOrigin,
    #[allow(missing_docs)] // documentation missing in model
    StrictOriginWhenCrossOrigin,
    #[allow(missing_docs)] // documentation missing in model
    UnsafeUrl,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ReferrerPolicyList {
    fn from(s: &str) -> Self {
        match s {
            "no-referrer" => ReferrerPolicyList::NoReferrer,
            "no-referrer-when-downgrade" => ReferrerPolicyList::NoReferrerWhenDowngrade,
            "origin" => ReferrerPolicyList::Origin,
            "origin-when-cross-origin" => ReferrerPolicyList::OriginWhenCrossOrigin,
            "same-origin" => ReferrerPolicyList::SameOrigin,
            "strict-origin" => ReferrerPolicyList::StrictOrigin,
            "strict-origin-when-cross-origin" => ReferrerPolicyList::StrictOriginWhenCrossOrigin,
            "unsafe-url" => ReferrerPolicyList::UnsafeUrl,
            other => ReferrerPolicyList::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ReferrerPolicyList {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ReferrerPolicyList::from(s))
    }
}
impl ReferrerPolicyList {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ReferrerPolicyList::NoReferrer => "no-referrer",
            ReferrerPolicyList::NoReferrerWhenDowngrade => "no-referrer-when-downgrade",
            ReferrerPolicyList::Origin => "origin",
            ReferrerPolicyList::OriginWhenCrossOrigin => "origin-when-cross-origin",
            ReferrerPolicyList::SameOrigin => "same-origin",
            ReferrerPolicyList::StrictOrigin => "strict-origin",
            ReferrerPolicyList::StrictOriginWhenCrossOrigin => "strict-origin-when-cross-origin",
            ReferrerPolicyList::UnsafeUrl => "unsafe-url",
            ReferrerPolicyList::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "no-referrer",
            "no-referrer-when-downgrade",
            "origin",
            "origin-when-cross-origin",
            "same-origin",
            "strict-origin",
            "strict-origin-when-cross-origin",
            "unsafe-url",
        ]
    }
}
impl AsRef<str> for ReferrerPolicyList {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Determines whether CloudFront includes the <code>X-Frame-Options</code> HTTP response header and
/// the header’s value.</p>
/// <p>For more information about the <code>X-Frame-Options</code> HTTP response header, see
/// <a href="https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/X-Frame-Options">X-Frame-Options</a> in the MDN Web Docs.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResponseHeadersPolicyFrameOptions {
    /// <p>A Boolean that determines whether CloudFront overrides the <code>X-Frame-Options</code> HTTP
    /// response header received from the origin with the one specified in this response headers
    /// policy.</p>
    pub r#override: std::option::Option<bool>,
    /// <p>The value of the <code>X-Frame-Options</code> HTTP response header. Valid values are
    /// <code>DENY</code> and <code>SAMEORIGIN</code>. </p>
    /// <p>For more information about these values, see <a href="https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/X-Frame-Options">X-Frame-Options</a> in the MDN Web Docs.</p>
    pub frame_option: std::option::Option<crate::model::FrameOptionsList>,
}
impl ResponseHeadersPolicyFrameOptions {
    /// <p>A Boolean that determines whether CloudFront overrides the <code>X-Frame-Options</code> HTTP
    /// response header received from the origin with the one specified in this response headers
    /// policy.</p>
    pub fn r#override(&self) -> std::option::Option<bool> {
        self.r#override
    }
    /// <p>The value of the <code>X-Frame-Options</code> HTTP response header. Valid values are
    /// <code>DENY</code> and <code>SAMEORIGIN</code>. </p>
    /// <p>For more information about these values, see <a href="https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/X-Frame-Options">X-Frame-Options</a> in the MDN Web Docs.</p>
    pub fn frame_option(&self) -> std::option::Option<&crate::model::FrameOptionsList> {
        self.frame_option.as_ref()
    }
}
impl std::fmt::Debug for ResponseHeadersPolicyFrameOptions {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResponseHeadersPolicyFrameOptions");
        formatter.field("r#override", &self.r#override);
        formatter.field("frame_option", &self.frame_option);
        formatter.finish()
    }
}
/// See [`ResponseHeadersPolicyFrameOptions`](crate::model::ResponseHeadersPolicyFrameOptions)
pub mod response_headers_policy_frame_options {
    /// A builder for [`ResponseHeadersPolicyFrameOptions`](crate::model::ResponseHeadersPolicyFrameOptions)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) r#override: std::option::Option<bool>,
        pub(crate) frame_option: std::option::Option<crate::model::FrameOptionsList>,
    }
    impl Builder {
        /// <p>A Boolean that determines whether CloudFront overrides the <code>X-Frame-Options</code> HTTP
        /// response header received from the origin with the one specified in this response headers
        /// policy.</p>
        pub fn r#override(mut self, input: bool) -> Self {
            self.r#override = Some(input);
            self
        }
        /// <p>A Boolean that determines whether CloudFront overrides the <code>X-Frame-Options</code> HTTP
        /// response header received from the origin with the one specified in this response headers
        /// policy.</p>
        pub fn set_override(mut self, input: std::option::Option<bool>) -> Self {
            self.r#override = input;
            self
        }
        /// <p>The value of the <code>X-Frame-Options</code> HTTP response header. Valid values are
        /// <code>DENY</code> and <code>SAMEORIGIN</code>. </p>
        /// <p>For more information about these values, see <a href="https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/X-Frame-Options">X-Frame-Options</a> in the MDN Web Docs.</p>
        pub fn frame_option(mut self, input: crate::model::FrameOptionsList) -> Self {
            self.frame_option = Some(input);
            self
        }
        /// <p>The value of the <code>X-Frame-Options</code> HTTP response header. Valid values are
        /// <code>DENY</code> and <code>SAMEORIGIN</code>. </p>
        /// <p>For more information about these values, see <a href="https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/X-Frame-Options">X-Frame-Options</a> in the MDN Web Docs.</p>
        pub fn set_frame_option(
            mut self,
            input: std::option::Option<crate::model::FrameOptionsList>,
        ) -> Self {
            self.frame_option = input;
            self
        }
        /// Consumes the builder and constructs a [`ResponseHeadersPolicyFrameOptions`](crate::model::ResponseHeadersPolicyFrameOptions)
        pub fn build(self) -> crate::model::ResponseHeadersPolicyFrameOptions {
            crate::model::ResponseHeadersPolicyFrameOptions {
                r#override: self.r#override,
                frame_option: self.frame_option,
            }
        }
    }
}
impl ResponseHeadersPolicyFrameOptions {
    /// Creates a new builder-style object to manufacture [`ResponseHeadersPolicyFrameOptions`](crate::model::ResponseHeadersPolicyFrameOptions)
    pub fn builder() -> crate::model::response_headers_policy_frame_options::Builder {
        crate::model::response_headers_policy_frame_options::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum FrameOptionsList {
    #[allow(missing_docs)] // documentation missing in model
    Deny,
    #[allow(missing_docs)] // documentation missing in model
    Sameorigin,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for FrameOptionsList {
    fn from(s: &str) -> Self {
        match s {
            "DENY" => FrameOptionsList::Deny,
            "SAMEORIGIN" => FrameOptionsList::Sameorigin,
            other => FrameOptionsList::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for FrameOptionsList {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(FrameOptionsList::from(s))
    }
}
impl FrameOptionsList {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            FrameOptionsList::Deny => "DENY",
            FrameOptionsList::Sameorigin => "SAMEORIGIN",
            FrameOptionsList::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["DENY", "SAMEORIGIN"]
    }
}
impl AsRef<str> for FrameOptionsList {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Determines whether CloudFront includes the <code>X-XSS-Protection</code> HTTP response header and
/// the header’s value.</p>
/// <p>For more information about the <code>X-XSS-Protection</code> HTTP response header, see
/// <a href="https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/X-XSS-Protection">X-XSS-Protection</a> in the MDN Web Docs.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResponseHeadersPolicyXssProtection {
    /// <p>A Boolean that determines whether CloudFront overrides the <code>X-XSS-Protection</code> HTTP
    /// response header received from the origin with the one specified in this response headers
    /// policy.</p>
    pub r#override: std::option::Option<bool>,
    /// <p>A Boolean that determines the value of the <code>X-XSS-Protection</code> HTTP response
    /// header. When this setting is <code>true</code>, the value of the
    /// <code>X-XSS-Protection</code> header is <code>1</code>. When this setting is
    /// <code>false</code>, the value of the <code>X-XSS-Protection</code> header is
    /// <code>0</code>.</p>
    /// <p>For more information about these settings, see <a href="https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/X-XSS-Protection">X-XSS-Protection</a> in the MDN Web Docs.</p>
    pub protection: std::option::Option<bool>,
    /// <p>A Boolean that determines whether CloudFront includes the <code>mode=block</code> directive in the
    /// <code>X-XSS-Protection</code> header.</p>
    /// <p>For more information about this directive, see <a href="https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/X-XSS-Protection">X-XSS-Protection</a> in the MDN Web Docs.</p>
    pub mode_block: std::option::Option<bool>,
    /// <p>A reporting URI, which CloudFront uses as the value of the <code>report</code> directive in the
    /// <code>X-XSS-Protection</code> header.</p>
    /// <p>You cannot specify a <code>ReportUri</code> when <code>ModeBlock</code> is
    /// <code>true</code>.</p>
    /// <p>For more information about using a reporting URL, see <a href="https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/X-XSS-Protection">X-XSS-Protection</a> in the MDN Web Docs.</p>
    pub report_uri: std::option::Option<std::string::String>,
}
impl ResponseHeadersPolicyXssProtection {
    /// <p>A Boolean that determines whether CloudFront overrides the <code>X-XSS-Protection</code> HTTP
    /// response header received from the origin with the one specified in this response headers
    /// policy.</p>
    pub fn r#override(&self) -> std::option::Option<bool> {
        self.r#override
    }
    /// <p>A Boolean that determines the value of the <code>X-XSS-Protection</code> HTTP response
    /// header. When this setting is <code>true</code>, the value of the
    /// <code>X-XSS-Protection</code> header is <code>1</code>. When this setting is
    /// <code>false</code>, the value of the <code>X-XSS-Protection</code> header is
    /// <code>0</code>.</p>
    /// <p>For more information about these settings, see <a href="https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/X-XSS-Protection">X-XSS-Protection</a> in the MDN Web Docs.</p>
    pub fn protection(&self) -> std::option::Option<bool> {
        self.protection
    }
    /// <p>A Boolean that determines whether CloudFront includes the <code>mode=block</code> directive in the
    /// <code>X-XSS-Protection</code> header.</p>
    /// <p>For more information about this directive, see <a href="https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/X-XSS-Protection">X-XSS-Protection</a> in the MDN Web Docs.</p>
    pub fn mode_block(&self) -> std::option::Option<bool> {
        self.mode_block
    }
    /// <p>A reporting URI, which CloudFront uses as the value of the <code>report</code> directive in the
    /// <code>X-XSS-Protection</code> header.</p>
    /// <p>You cannot specify a <code>ReportUri</code> when <code>ModeBlock</code> is
    /// <code>true</code>.</p>
    /// <p>For more information about using a reporting URL, see <a href="https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/X-XSS-Protection">X-XSS-Protection</a> in the MDN Web Docs.</p>
    pub fn report_uri(&self) -> std::option::Option<&str> {
        self.report_uri.as_deref()
    }
}
impl std::fmt::Debug for ResponseHeadersPolicyXssProtection {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResponseHeadersPolicyXssProtection");
        formatter.field("r#override", &self.r#override);
        formatter.field("protection", &self.protection);
        formatter.field("mode_block", &self.mode_block);
        formatter.field("report_uri", &self.report_uri);
        formatter.finish()
    }
}
/// See [`ResponseHeadersPolicyXssProtection`](crate::model::ResponseHeadersPolicyXssProtection)
pub mod response_headers_policy_xss_protection {
    /// A builder for [`ResponseHeadersPolicyXssProtection`](crate::model::ResponseHeadersPolicyXssProtection)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) r#override: std::option::Option<bool>,
        pub(crate) protection: std::option::Option<bool>,
        pub(crate) mode_block: std::option::Option<bool>,
        pub(crate) report_uri: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A Boolean that determines whether CloudFront overrides the <code>X-XSS-Protection</code> HTTP
        /// response header received from the origin with the one specified in this response headers
        /// policy.</p>
        pub fn r#override(mut self, input: bool) -> Self {
            self.r#override = Some(input);
            self
        }
        /// <p>A Boolean that determines whether CloudFront overrides the <code>X-XSS-Protection</code> HTTP
        /// response header received from the origin with the one specified in this response headers
        /// policy.</p>
        pub fn set_override(mut self, input: std::option::Option<bool>) -> Self {
            self.r#override = input;
            self
        }
        /// <p>A Boolean that determines the value of the <code>X-XSS-Protection</code> HTTP response
        /// header. When this setting is <code>true</code>, the value of the
        /// <code>X-XSS-Protection</code> header is <code>1</code>. When this setting is
        /// <code>false</code>, the value of the <code>X-XSS-Protection</code> header is
        /// <code>0</code>.</p>
        /// <p>For more information about these settings, see <a href="https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/X-XSS-Protection">X-XSS-Protection</a> in the MDN Web Docs.</p>
        pub fn protection(mut self, input: bool) -> Self {
            self.protection = Some(input);
            self
        }
        /// <p>A Boolean that determines the value of the <code>X-XSS-Protection</code> HTTP response
        /// header. When this setting is <code>true</code>, the value of the
        /// <code>X-XSS-Protection</code> header is <code>1</code>. When this setting is
        /// <code>false</code>, the value of the <code>X-XSS-Protection</code> header is
        /// <code>0</code>.</p>
        /// <p>For more information about these settings, see <a href="https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/X-XSS-Protection">X-XSS-Protection</a> in the MDN Web Docs.</p>
        pub fn set_protection(mut self, input: std::option::Option<bool>) -> Self {
            self.protection = input;
            self
        }
        /// <p>A Boolean that determines whether CloudFront includes the <code>mode=block</code> directive in the
        /// <code>X-XSS-Protection</code> header.</p>
        /// <p>For more information about this directive, see <a href="https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/X-XSS-Protection">X-XSS-Protection</a> in the MDN Web Docs.</p>
        pub fn mode_block(mut self, input: bool) -> Self {
            self.mode_block = Some(input);
            self
        }
        /// <p>A Boolean that determines whether CloudFront includes the <code>mode=block</code> directive in the
        /// <code>X-XSS-Protection</code> header.</p>
        /// <p>For more information about this directive, see <a href="https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/X-XSS-Protection">X-XSS-Protection</a> in the MDN Web Docs.</p>
        pub fn set_mode_block(mut self, input: std::option::Option<bool>) -> Self {
            self.mode_block = input;
            self
        }
        /// <p>A reporting URI, which CloudFront uses as the value of the <code>report</code> directive in the
        /// <code>X-XSS-Protection</code> header.</p>
        /// <p>You cannot specify a <code>ReportUri</code> when <code>ModeBlock</code> is
        /// <code>true</code>.</p>
        /// <p>For more information about using a reporting URL, see <a href="https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/X-XSS-Protection">X-XSS-Protection</a> in the MDN Web Docs.</p>
        pub fn report_uri(mut self, input: impl Into<std::string::String>) -> Self {
            self.report_uri = Some(input.into());
            self
        }
        /// <p>A reporting URI, which CloudFront uses as the value of the <code>report</code> directive in the
        /// <code>X-XSS-Protection</code> header.</p>
        /// <p>You cannot specify a <code>ReportUri</code> when <code>ModeBlock</code> is
        /// <code>true</code>.</p>
        /// <p>For more information about using a reporting URL, see <a href="https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/X-XSS-Protection">X-XSS-Protection</a> in the MDN Web Docs.</p>
        pub fn set_report_uri(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.report_uri = input;
            self
        }
        /// Consumes the builder and constructs a [`ResponseHeadersPolicyXssProtection`](crate::model::ResponseHeadersPolicyXssProtection)
        pub fn build(self) -> crate::model::ResponseHeadersPolicyXssProtection {
            crate::model::ResponseHeadersPolicyXssProtection {
                r#override: self.r#override,
                protection: self.protection,
                mode_block: self.mode_block,
                report_uri: self.report_uri,
            }
        }
    }
}
impl ResponseHeadersPolicyXssProtection {
    /// Creates a new builder-style object to manufacture [`ResponseHeadersPolicyXssProtection`](crate::model::ResponseHeadersPolicyXssProtection)
    pub fn builder() -> crate::model::response_headers_policy_xss_protection::Builder {
        crate::model::response_headers_policy_xss_protection::Builder::default()
    }
}

/// <p>A configuration for a set of HTTP response headers that are used for cross-origin resource
/// sharing (CORS). CloudFront adds these headers to HTTP responses that it sends for CORS
/// requests that match a cache behavior associated with this response headers
/// policy.</p>
/// <p>For more information about CORS, see <a href="https://developer.mozilla.org/en-US/docs/Web/HTTP/CORS">Cross-Origin Resource
/// Sharing (CORS)</a> in the MDN Web Docs.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResponseHeadersPolicyCorsConfig {
    /// <p>A list of origins (domain names) that CloudFront can use as the value for the
    /// <code>Access-Control-Allow-Origin</code> HTTP response header.</p>
    /// <p>For more information about the <code>Access-Control-Allow-Origin</code> HTTP response
    /// header, see <a href="https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Access-Control-Allow-Origin">Access-Control-Allow-Origin</a> in the MDN Web Docs.</p>
    pub access_control_allow_origins:
        std::option::Option<crate::model::ResponseHeadersPolicyAccessControlAllowOrigins>,
    /// <p>A list of HTTP header names that CloudFront includes as values for the
    /// <code>Access-Control-Allow-Headers</code> HTTP response header.</p>
    /// <p>For more information about the <code>Access-Control-Allow-Headers</code> HTTP response
    /// header, see <a href="https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Access-Control-Allow-Headers">Access-Control-Allow-Headers</a> in the MDN Web Docs.</p>
    pub access_control_allow_headers:
        std::option::Option<crate::model::ResponseHeadersPolicyAccessControlAllowHeaders>,
    /// <p>A list of HTTP methods that CloudFront includes as values for the
    /// <code>Access-Control-Allow-Methods</code> HTTP response header.</p>
    /// <p>For more information about the <code>Access-Control-Allow-Methods</code> HTTP response
    /// header, see <a href="https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Access-Control-Allow-Methods">Access-Control-Allow-Methods</a> in the MDN Web Docs.</p>
    pub access_control_allow_methods:
        std::option::Option<crate::model::ResponseHeadersPolicyAccessControlAllowMethods>,
    /// <p>A Boolean that CloudFront uses as the value for the <code>Access-Control-Allow-Credentials</code>
    /// HTTP response header.</p>
    /// <p>For more information about the <code>Access-Control-Allow-Credentials</code> HTTP
    /// response header, see <a href="https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Access-Control-Allow-Credentials">Access-Control-Allow-Credentials</a> in the MDN Web Docs.</p>
    pub access_control_allow_credentials: std::option::Option<bool>,
    /// <p>A list of HTTP headers that CloudFront includes as values for the
    /// <code>Access-Control-Expose-Headers</code> HTTP response header.</p>
    /// <p>For more information about the <code>Access-Control-Expose-Headers</code> HTTP
    /// response header, see <a href="https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Access-Control-Expose-Headers">Access-Control-Expose-Headers</a> in the MDN Web Docs.</p>
    pub access_control_expose_headers:
        std::option::Option<crate::model::ResponseHeadersPolicyAccessControlExposeHeaders>,
    /// <p>A number that CloudFront uses as the value for the <code>Access-Control-Max-Age</code> HTTP
    /// response header.</p>
    /// <p>For more information about the <code>Access-Control-Max-Age</code> HTTP response
    /// header, see <a href="https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Access-Control-Max-Age">Access-Control-Max-Age</a> in the MDN Web Docs.</p>
    pub access_control_max_age_sec: std::option::Option<i32>,
    /// <p>A Boolean that determines whether CloudFront overrides HTTP response headers received from the
    /// origin with the ones specified in this response headers policy.</p>
    pub origin_override: std::option::Option<bool>,
}
impl ResponseHeadersPolicyCorsConfig {
    /// <p>A list of origins (domain names) that CloudFront can use as the value for the
    /// <code>Access-Control-Allow-Origin</code> HTTP response header.</p>
    /// <p>For more information about the <code>Access-Control-Allow-Origin</code> HTTP response
    /// header, see <a href="https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Access-Control-Allow-Origin">Access-Control-Allow-Origin</a> in the MDN Web Docs.</p>
    pub fn access_control_allow_origins(
        &self,
    ) -> std::option::Option<&crate::model::ResponseHeadersPolicyAccessControlAllowOrigins> {
        self.access_control_allow_origins.as_ref()
    }
    /// <p>A list of HTTP header names that CloudFront includes as values for the
    /// <code>Access-Control-Allow-Headers</code> HTTP response header.</p>
    /// <p>For more information about the <code>Access-Control-Allow-Headers</code> HTTP response
    /// header, see <a href="https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Access-Control-Allow-Headers">Access-Control-Allow-Headers</a> in the MDN Web Docs.</p>
    pub fn access_control_allow_headers(
        &self,
    ) -> std::option::Option<&crate::model::ResponseHeadersPolicyAccessControlAllowHeaders> {
        self.access_control_allow_headers.as_ref()
    }
    /// <p>A list of HTTP methods that CloudFront includes as values for the
    /// <code>Access-Control-Allow-Methods</code> HTTP response header.</p>
    /// <p>For more information about the <code>Access-Control-Allow-Methods</code> HTTP response
    /// header, see <a href="https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Access-Control-Allow-Methods">Access-Control-Allow-Methods</a> in the MDN Web Docs.</p>
    pub fn access_control_allow_methods(
        &self,
    ) -> std::option::Option<&crate::model::ResponseHeadersPolicyAccessControlAllowMethods> {
        self.access_control_allow_methods.as_ref()
    }
    /// <p>A Boolean that CloudFront uses as the value for the <code>Access-Control-Allow-Credentials</code>
    /// HTTP response header.</p>
    /// <p>For more information about the <code>Access-Control-Allow-Credentials</code> HTTP
    /// response header, see <a href="https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Access-Control-Allow-Credentials">Access-Control-Allow-Credentials</a> in the MDN Web Docs.</p>
    pub fn access_control_allow_credentials(&self) -> std::option::Option<bool> {
        self.access_control_allow_credentials
    }
    /// <p>A list of HTTP headers that CloudFront includes as values for the
    /// <code>Access-Control-Expose-Headers</code> HTTP response header.</p>
    /// <p>For more information about the <code>Access-Control-Expose-Headers</code> HTTP
    /// response header, see <a href="https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Access-Control-Expose-Headers">Access-Control-Expose-Headers</a> in the MDN Web Docs.</p>
    pub fn access_control_expose_headers(
        &self,
    ) -> std::option::Option<&crate::model::ResponseHeadersPolicyAccessControlExposeHeaders> {
        self.access_control_expose_headers.as_ref()
    }
    /// <p>A number that CloudFront uses as the value for the <code>Access-Control-Max-Age</code> HTTP
    /// response header.</p>
    /// <p>For more information about the <code>Access-Control-Max-Age</code> HTTP response
    /// header, see <a href="https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Access-Control-Max-Age">Access-Control-Max-Age</a> in the MDN Web Docs.</p>
    pub fn access_control_max_age_sec(&self) -> std::option::Option<i32> {
        self.access_control_max_age_sec
    }
    /// <p>A Boolean that determines whether CloudFront overrides HTTP response headers received from the
    /// origin with the ones specified in this response headers policy.</p>
    pub fn origin_override(&self) -> std::option::Option<bool> {
        self.origin_override
    }
}
impl std::fmt::Debug for ResponseHeadersPolicyCorsConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResponseHeadersPolicyCorsConfig");
        formatter.field(
            "access_control_allow_origins",
            &self.access_control_allow_origins,
        );
        formatter.field(
            "access_control_allow_headers",
            &self.access_control_allow_headers,
        );
        formatter.field(
            "access_control_allow_methods",
            &self.access_control_allow_methods,
        );
        formatter.field(
            "access_control_allow_credentials",
            &self.access_control_allow_credentials,
        );
        formatter.field(
            "access_control_expose_headers",
            &self.access_control_expose_headers,
        );
        formatter.field(
            "access_control_max_age_sec",
            &self.access_control_max_age_sec,
        );
        formatter.field("origin_override", &self.origin_override);
        formatter.finish()
    }
}
/// See [`ResponseHeadersPolicyCorsConfig`](crate::model::ResponseHeadersPolicyCorsConfig)
pub mod response_headers_policy_cors_config {
    /// A builder for [`ResponseHeadersPolicyCorsConfig`](crate::model::ResponseHeadersPolicyCorsConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) access_control_allow_origins:
            std::option::Option<crate::model::ResponseHeadersPolicyAccessControlAllowOrigins>,
        pub(crate) access_control_allow_headers:
            std::option::Option<crate::model::ResponseHeadersPolicyAccessControlAllowHeaders>,
        pub(crate) access_control_allow_methods:
            std::option::Option<crate::model::ResponseHeadersPolicyAccessControlAllowMethods>,
        pub(crate) access_control_allow_credentials: std::option::Option<bool>,
        pub(crate) access_control_expose_headers:
            std::option::Option<crate::model::ResponseHeadersPolicyAccessControlExposeHeaders>,
        pub(crate) access_control_max_age_sec: std::option::Option<i32>,
        pub(crate) origin_override: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>A list of origins (domain names) that CloudFront can use as the value for the
        /// <code>Access-Control-Allow-Origin</code> HTTP response header.</p>
        /// <p>For more information about the <code>Access-Control-Allow-Origin</code> HTTP response
        /// header, see <a href="https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Access-Control-Allow-Origin">Access-Control-Allow-Origin</a> in the MDN Web Docs.</p>
        pub fn access_control_allow_origins(
            mut self,
            input: crate::model::ResponseHeadersPolicyAccessControlAllowOrigins,
        ) -> Self {
            self.access_control_allow_origins = Some(input);
            self
        }
        /// <p>A list of origins (domain names) that CloudFront can use as the value for the
        /// <code>Access-Control-Allow-Origin</code> HTTP response header.</p>
        /// <p>For more information about the <code>Access-Control-Allow-Origin</code> HTTP response
        /// header, see <a href="https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Access-Control-Allow-Origin">Access-Control-Allow-Origin</a> in the MDN Web Docs.</p>
        pub fn set_access_control_allow_origins(
            mut self,
            input: std::option::Option<
                crate::model::ResponseHeadersPolicyAccessControlAllowOrigins,
            >,
        ) -> Self {
            self.access_control_allow_origins = input;
            self
        }
        /// <p>A list of HTTP header names that CloudFront includes as values for the
        /// <code>Access-Control-Allow-Headers</code> HTTP response header.</p>
        /// <p>For more information about the <code>Access-Control-Allow-Headers</code> HTTP response
        /// header, see <a href="https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Access-Control-Allow-Headers">Access-Control-Allow-Headers</a> in the MDN Web Docs.</p>
        pub fn access_control_allow_headers(
            mut self,
            input: crate::model::ResponseHeadersPolicyAccessControlAllowHeaders,
        ) -> Self {
            self.access_control_allow_headers = Some(input);
            self
        }
        /// <p>A list of HTTP header names that CloudFront includes as values for the
        /// <code>Access-Control-Allow-Headers</code> HTTP response header.</p>
        /// <p>For more information about the <code>Access-Control-Allow-Headers</code> HTTP response
        /// header, see <a href="https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Access-Control-Allow-Headers">Access-Control-Allow-Headers</a> in the MDN Web Docs.</p>
        pub fn set_access_control_allow_headers(
            mut self,
            input: std::option::Option<
                crate::model::ResponseHeadersPolicyAccessControlAllowHeaders,
            >,
        ) -> Self {
            self.access_control_allow_headers = input;
            self
        }
        /// <p>A list of HTTP methods that CloudFront includes as values for the
        /// <code>Access-Control-Allow-Methods</code> HTTP response header.</p>
        /// <p>For more information about the <code>Access-Control-Allow-Methods</code> HTTP response
        /// header, see <a href="https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Access-Control-Allow-Methods">Access-Control-Allow-Methods</a> in the MDN Web Docs.</p>
        pub fn access_control_allow_methods(
            mut self,
            input: crate::model::ResponseHeadersPolicyAccessControlAllowMethods,
        ) -> Self {
            self.access_control_allow_methods = Some(input);
            self
        }
        /// <p>A list of HTTP methods that CloudFront includes as values for the
        /// <code>Access-Control-Allow-Methods</code> HTTP response header.</p>
        /// <p>For more information about the <code>Access-Control-Allow-Methods</code> HTTP response
        /// header, see <a href="https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Access-Control-Allow-Methods">Access-Control-Allow-Methods</a> in the MDN Web Docs.</p>
        pub fn set_access_control_allow_methods(
            mut self,
            input: std::option::Option<
                crate::model::ResponseHeadersPolicyAccessControlAllowMethods,
            >,
        ) -> Self {
            self.access_control_allow_methods = input;
            self
        }
        /// <p>A Boolean that CloudFront uses as the value for the <code>Access-Control-Allow-Credentials</code>
        /// HTTP response header.</p>
        /// <p>For more information about the <code>Access-Control-Allow-Credentials</code> HTTP
        /// response header, see <a href="https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Access-Control-Allow-Credentials">Access-Control-Allow-Credentials</a> in the MDN Web Docs.</p>
        pub fn access_control_allow_credentials(mut self, input: bool) -> Self {
            self.access_control_allow_credentials = Some(input);
            self
        }
        /// <p>A Boolean that CloudFront uses as the value for the <code>Access-Control-Allow-Credentials</code>
        /// HTTP response header.</p>
        /// <p>For more information about the <code>Access-Control-Allow-Credentials</code> HTTP
        /// response header, see <a href="https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Access-Control-Allow-Credentials">Access-Control-Allow-Credentials</a> in the MDN Web Docs.</p>
        pub fn set_access_control_allow_credentials(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.access_control_allow_credentials = input;
            self
        }
        /// <p>A list of HTTP headers that CloudFront includes as values for the
        /// <code>Access-Control-Expose-Headers</code> HTTP response header.</p>
        /// <p>For more information about the <code>Access-Control-Expose-Headers</code> HTTP
        /// response header, see <a href="https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Access-Control-Expose-Headers">Access-Control-Expose-Headers</a> in the MDN Web Docs.</p>
        pub fn access_control_expose_headers(
            mut self,
            input: crate::model::ResponseHeadersPolicyAccessControlExposeHeaders,
        ) -> Self {
            self.access_control_expose_headers = Some(input);
            self
        }
        /// <p>A list of HTTP headers that CloudFront includes as values for the
        /// <code>Access-Control-Expose-Headers</code> HTTP response header.</p>
        /// <p>For more information about the <code>Access-Control-Expose-Headers</code> HTTP
        /// response header, see <a href="https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Access-Control-Expose-Headers">Access-Control-Expose-Headers</a> in the MDN Web Docs.</p>
        pub fn set_access_control_expose_headers(
            mut self,
            input: std::option::Option<
                crate::model::ResponseHeadersPolicyAccessControlExposeHeaders,
            >,
        ) -> Self {
            self.access_control_expose_headers = input;
            self
        }
        /// <p>A number that CloudFront uses as the value for the <code>Access-Control-Max-Age</code> HTTP
        /// response header.</p>
        /// <p>For more information about the <code>Access-Control-Max-Age</code> HTTP response
        /// header, see <a href="https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Access-Control-Max-Age">Access-Control-Max-Age</a> in the MDN Web Docs.</p>
        pub fn access_control_max_age_sec(mut self, input: i32) -> Self {
            self.access_control_max_age_sec = Some(input);
            self
        }
        /// <p>A number that CloudFront uses as the value for the <code>Access-Control-Max-Age</code> HTTP
        /// response header.</p>
        /// <p>For more information about the <code>Access-Control-Max-Age</code> HTTP response
        /// header, see <a href="https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Access-Control-Max-Age">Access-Control-Max-Age</a> in the MDN Web Docs.</p>
        pub fn set_access_control_max_age_sec(mut self, input: std::option::Option<i32>) -> Self {
            self.access_control_max_age_sec = input;
            self
        }
        /// <p>A Boolean that determines whether CloudFront overrides HTTP response headers received from the
        /// origin with the ones specified in this response headers policy.</p>
        pub fn origin_override(mut self, input: bool) -> Self {
            self.origin_override = Some(input);
            self
        }
        /// <p>A Boolean that determines whether CloudFront overrides HTTP response headers received from the
        /// origin with the ones specified in this response headers policy.</p>
        pub fn set_origin_override(mut self, input: std::option::Option<bool>) -> Self {
            self.origin_override = input;
            self
        }
        /// Consumes the builder and constructs a [`ResponseHeadersPolicyCorsConfig`](crate::model::ResponseHeadersPolicyCorsConfig)
        pub fn build(self) -> crate::model::ResponseHeadersPolicyCorsConfig {
            crate::model::ResponseHeadersPolicyCorsConfig {
                access_control_allow_origins: self.access_control_allow_origins,
                access_control_allow_headers: self.access_control_allow_headers,
                access_control_allow_methods: self.access_control_allow_methods,
                access_control_allow_credentials: self.access_control_allow_credentials,
                access_control_expose_headers: self.access_control_expose_headers,
                access_control_max_age_sec: self.access_control_max_age_sec,
                origin_override: self.origin_override,
            }
        }
    }
}
impl ResponseHeadersPolicyCorsConfig {
    /// Creates a new builder-style object to manufacture [`ResponseHeadersPolicyCorsConfig`](crate::model::ResponseHeadersPolicyCorsConfig)
    pub fn builder() -> crate::model::response_headers_policy_cors_config::Builder {
        crate::model::response_headers_policy_cors_config::Builder::default()
    }
}

/// <p>A list of HTTP headers that CloudFront includes as values for the
/// <code>Access-Control-Expose-Headers</code> HTTP response header.</p>
/// <p>For more information about the <code>Access-Control-Expose-Headers</code> HTTP
/// response header, see <a href="https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Access-Control-Expose-Headers">Access-Control-Expose-Headers</a> in the MDN Web Docs.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResponseHeadersPolicyAccessControlExposeHeaders {
    /// <p>The number of HTTP headers in the list.</p>
    pub quantity: std::option::Option<i32>,
    /// <p>The list of HTTP headers. You can specify <code>*</code> to expose all headers.</p>
    pub items: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl ResponseHeadersPolicyAccessControlExposeHeaders {
    /// <p>The number of HTTP headers in the list.</p>
    pub fn quantity(&self) -> std::option::Option<i32> {
        self.quantity
    }
    /// <p>The list of HTTP headers. You can specify <code>*</code> to expose all headers.</p>
    pub fn items(&self) -> std::option::Option<&[std::string::String]> {
        self.items.as_deref()
    }
}
impl std::fmt::Debug for ResponseHeadersPolicyAccessControlExposeHeaders {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResponseHeadersPolicyAccessControlExposeHeaders");
        formatter.field("quantity", &self.quantity);
        formatter.field("items", &self.items);
        formatter.finish()
    }
}
/// See [`ResponseHeadersPolicyAccessControlExposeHeaders`](crate::model::ResponseHeadersPolicyAccessControlExposeHeaders)
pub mod response_headers_policy_access_control_expose_headers {
    /// A builder for [`ResponseHeadersPolicyAccessControlExposeHeaders`](crate::model::ResponseHeadersPolicyAccessControlExposeHeaders)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) quantity: std::option::Option<i32>,
        pub(crate) items: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The number of HTTP headers in the list.</p>
        pub fn quantity(mut self, input: i32) -> Self {
            self.quantity = Some(input);
            self
        }
        /// <p>The number of HTTP headers in the list.</p>
        pub fn set_quantity(mut self, input: std::option::Option<i32>) -> Self {
            self.quantity = input;
            self
        }
        /// Appends an item to `items`.
        ///
        /// To override the contents of this collection use [`set_items`](Self::set_items).
        ///
        /// <p>The list of HTTP headers. You can specify <code>*</code> to expose all headers.</p>
        pub fn items(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.items.unwrap_or_default();
            v.push(input.into());
            self.items = Some(v);
            self
        }
        /// <p>The list of HTTP headers. You can specify <code>*</code> to expose all headers.</p>
        pub fn set_items(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.items = input;
            self
        }
        /// Consumes the builder and constructs a [`ResponseHeadersPolicyAccessControlExposeHeaders`](crate::model::ResponseHeadersPolicyAccessControlExposeHeaders)
        pub fn build(self) -> crate::model::ResponseHeadersPolicyAccessControlExposeHeaders {
            crate::model::ResponseHeadersPolicyAccessControlExposeHeaders {
                quantity: self.quantity,
                items: self.items,
            }
        }
    }
}
impl ResponseHeadersPolicyAccessControlExposeHeaders {
    /// Creates a new builder-style object to manufacture [`ResponseHeadersPolicyAccessControlExposeHeaders`](crate::model::ResponseHeadersPolicyAccessControlExposeHeaders)
    pub fn builder() -> crate::model::response_headers_policy_access_control_expose_headers::Builder
    {
        crate::model::response_headers_policy_access_control_expose_headers::Builder::default()
    }
}

/// <p>A list of HTTP methods that CloudFront includes as values for the
/// <code>Access-Control-Allow-Methods</code> HTTP response header.</p>
/// <p>For more information about the <code>Access-Control-Allow-Methods</code> HTTP response
/// header, see <a href="https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Access-Control-Allow-Methods">Access-Control-Allow-Methods</a> in the MDN Web Docs.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResponseHeadersPolicyAccessControlAllowMethods {
    /// <p>The number of HTTP methods in the list.</p>
    pub quantity: std::option::Option<i32>,
    /// <p>The list of HTTP methods. Valid values are:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>GET</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>DELETE</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>HEAD</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>OPTIONS</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>PATCH</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>POST</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>PUT</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>ALL</code>
    /// </p>
    /// </li>
    /// </ul>
    /// <p>
    /// <code>ALL</code> is a special value that includes all of the listed HTTP
    /// methods.</p>
    pub items: std::option::Option<
        std::vec::Vec<crate::model::ResponseHeadersPolicyAccessControlAllowMethodsValues>,
    >,
}
impl ResponseHeadersPolicyAccessControlAllowMethods {
    /// <p>The number of HTTP methods in the list.</p>
    pub fn quantity(&self) -> std::option::Option<i32> {
        self.quantity
    }
    /// <p>The list of HTTP methods. Valid values are:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>GET</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>DELETE</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>HEAD</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>OPTIONS</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>PATCH</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>POST</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>PUT</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>ALL</code>
    /// </p>
    /// </li>
    /// </ul>
    /// <p>
    /// <code>ALL</code> is a special value that includes all of the listed HTTP
    /// methods.</p>
    pub fn items(
        &self,
    ) -> std::option::Option<&[crate::model::ResponseHeadersPolicyAccessControlAllowMethodsValues]>
    {
        self.items.as_deref()
    }
}
impl std::fmt::Debug for ResponseHeadersPolicyAccessControlAllowMethods {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResponseHeadersPolicyAccessControlAllowMethods");
        formatter.field("quantity", &self.quantity);
        formatter.field("items", &self.items);
        formatter.finish()
    }
}
/// See [`ResponseHeadersPolicyAccessControlAllowMethods`](crate::model::ResponseHeadersPolicyAccessControlAllowMethods)
pub mod response_headers_policy_access_control_allow_methods {
    /// A builder for [`ResponseHeadersPolicyAccessControlAllowMethods`](crate::model::ResponseHeadersPolicyAccessControlAllowMethods)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) quantity: std::option::Option<i32>,
        pub(crate) items: std::option::Option<
            std::vec::Vec<crate::model::ResponseHeadersPolicyAccessControlAllowMethodsValues>,
        >,
    }
    impl Builder {
        /// <p>The number of HTTP methods in the list.</p>
        pub fn quantity(mut self, input: i32) -> Self {
            self.quantity = Some(input);
            self
        }
        /// <p>The number of HTTP methods in the list.</p>
        pub fn set_quantity(mut self, input: std::option::Option<i32>) -> Self {
            self.quantity = input;
            self
        }
        /// Appends an item to `items`.
        ///
        /// To override the contents of this collection use [`set_items`](Self::set_items).
        ///
        /// <p>The list of HTTP methods. Valid values are:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>GET</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>DELETE</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>HEAD</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>OPTIONS</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>PATCH</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>POST</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>PUT</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ALL</code>
        /// </p>
        /// </li>
        /// </ul>
        /// <p>
        /// <code>ALL</code> is a special value that includes all of the listed HTTP
        /// methods.</p>
        pub fn items(
            mut self,
            input: impl Into<crate::model::ResponseHeadersPolicyAccessControlAllowMethodsValues>,
        ) -> Self {
            let mut v = self.items.unwrap_or_default();
            v.push(input.into());
            self.items = Some(v);
            self
        }
        /// <p>The list of HTTP methods. Valid values are:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>GET</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>DELETE</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>HEAD</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>OPTIONS</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>PATCH</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>POST</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>PUT</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ALL</code>
        /// </p>
        /// </li>
        /// </ul>
        /// <p>
        /// <code>ALL</code> is a special value that includes all of the listed HTTP
        /// methods.</p>
        pub fn set_items(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::ResponseHeadersPolicyAccessControlAllowMethodsValues>,
            >,
        ) -> Self {
            self.items = input;
            self
        }
        /// Consumes the builder and constructs a [`ResponseHeadersPolicyAccessControlAllowMethods`](crate::model::ResponseHeadersPolicyAccessControlAllowMethods)
        pub fn build(self) -> crate::model::ResponseHeadersPolicyAccessControlAllowMethods {
            crate::model::ResponseHeadersPolicyAccessControlAllowMethods {
                quantity: self.quantity,
                items: self.items,
            }
        }
    }
}
impl ResponseHeadersPolicyAccessControlAllowMethods {
    /// Creates a new builder-style object to manufacture [`ResponseHeadersPolicyAccessControlAllowMethods`](crate::model::ResponseHeadersPolicyAccessControlAllowMethods)
    pub fn builder() -> crate::model::response_headers_policy_access_control_allow_methods::Builder
    {
        crate::model::response_headers_policy_access_control_allow_methods::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ResponseHeadersPolicyAccessControlAllowMethodsValues {
    #[allow(missing_docs)] // documentation missing in model
    All,
    #[allow(missing_docs)] // documentation missing in model
    Delete,
    #[allow(missing_docs)] // documentation missing in model
    Get,
    #[allow(missing_docs)] // documentation missing in model
    Head,
    #[allow(missing_docs)] // documentation missing in model
    Options,
    #[allow(missing_docs)] // documentation missing in model
    Patch,
    #[allow(missing_docs)] // documentation missing in model
    Post,
    #[allow(missing_docs)] // documentation missing in model
    Put,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ResponseHeadersPolicyAccessControlAllowMethodsValues {
    fn from(s: &str) -> Self {
        match s {
            "ALL" => ResponseHeadersPolicyAccessControlAllowMethodsValues::All,
            "DELETE" => ResponseHeadersPolicyAccessControlAllowMethodsValues::Delete,
            "GET" => ResponseHeadersPolicyAccessControlAllowMethodsValues::Get,
            "HEAD" => ResponseHeadersPolicyAccessControlAllowMethodsValues::Head,
            "OPTIONS" => ResponseHeadersPolicyAccessControlAllowMethodsValues::Options,
            "PATCH" => ResponseHeadersPolicyAccessControlAllowMethodsValues::Patch,
            "POST" => ResponseHeadersPolicyAccessControlAllowMethodsValues::Post,
            "PUT" => ResponseHeadersPolicyAccessControlAllowMethodsValues::Put,
            other => {
                ResponseHeadersPolicyAccessControlAllowMethodsValues::Unknown(other.to_owned())
            }
        }
    }
}
impl std::str::FromStr for ResponseHeadersPolicyAccessControlAllowMethodsValues {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ResponseHeadersPolicyAccessControlAllowMethodsValues::from(
            s,
        ))
    }
}
impl ResponseHeadersPolicyAccessControlAllowMethodsValues {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ResponseHeadersPolicyAccessControlAllowMethodsValues::All => "ALL",
            ResponseHeadersPolicyAccessControlAllowMethodsValues::Delete => "DELETE",
            ResponseHeadersPolicyAccessControlAllowMethodsValues::Get => "GET",
            ResponseHeadersPolicyAccessControlAllowMethodsValues::Head => "HEAD",
            ResponseHeadersPolicyAccessControlAllowMethodsValues::Options => "OPTIONS",
            ResponseHeadersPolicyAccessControlAllowMethodsValues::Patch => "PATCH",
            ResponseHeadersPolicyAccessControlAllowMethodsValues::Post => "POST",
            ResponseHeadersPolicyAccessControlAllowMethodsValues::Put => "PUT",
            ResponseHeadersPolicyAccessControlAllowMethodsValues::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "ALL", "DELETE", "GET", "HEAD", "OPTIONS", "PATCH", "POST", "PUT",
        ]
    }
}
impl AsRef<str> for ResponseHeadersPolicyAccessControlAllowMethodsValues {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>A list of HTTP header names that CloudFront includes as values for the
/// <code>Access-Control-Allow-Headers</code> HTTP response header.</p>
/// <p>For more information about the <code>Access-Control-Allow-Headers</code> HTTP response
/// header, see <a href="https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Access-Control-Allow-Headers">Access-Control-Allow-Headers</a> in the MDN Web Docs.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResponseHeadersPolicyAccessControlAllowHeaders {
    /// <p>The number of HTTP header names in the list.</p>
    pub quantity: std::option::Option<i32>,
    /// <p>The list of HTTP header names. You can specify <code>*</code> to allow all headers.</p>
    pub items: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl ResponseHeadersPolicyAccessControlAllowHeaders {
    /// <p>The number of HTTP header names in the list.</p>
    pub fn quantity(&self) -> std::option::Option<i32> {
        self.quantity
    }
    /// <p>The list of HTTP header names. You can specify <code>*</code> to allow all headers.</p>
    pub fn items(&self) -> std::option::Option<&[std::string::String]> {
        self.items.as_deref()
    }
}
impl std::fmt::Debug for ResponseHeadersPolicyAccessControlAllowHeaders {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResponseHeadersPolicyAccessControlAllowHeaders");
        formatter.field("quantity", &self.quantity);
        formatter.field("items", &self.items);
        formatter.finish()
    }
}
/// See [`ResponseHeadersPolicyAccessControlAllowHeaders`](crate::model::ResponseHeadersPolicyAccessControlAllowHeaders)
pub mod response_headers_policy_access_control_allow_headers {
    /// A builder for [`ResponseHeadersPolicyAccessControlAllowHeaders`](crate::model::ResponseHeadersPolicyAccessControlAllowHeaders)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) quantity: std::option::Option<i32>,
        pub(crate) items: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The number of HTTP header names in the list.</p>
        pub fn quantity(mut self, input: i32) -> Self {
            self.quantity = Some(input);
            self
        }
        /// <p>The number of HTTP header names in the list.</p>
        pub fn set_quantity(mut self, input: std::option::Option<i32>) -> Self {
            self.quantity = input;
            self
        }
        /// Appends an item to `items`.
        ///
        /// To override the contents of this collection use [`set_items`](Self::set_items).
        ///
        /// <p>The list of HTTP header names. You can specify <code>*</code> to allow all headers.</p>
        pub fn items(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.items.unwrap_or_default();
            v.push(input.into());
            self.items = Some(v);
            self
        }
        /// <p>The list of HTTP header names. You can specify <code>*</code> to allow all headers.</p>
        pub fn set_items(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.items = input;
            self
        }
        /// Consumes the builder and constructs a [`ResponseHeadersPolicyAccessControlAllowHeaders`](crate::model::ResponseHeadersPolicyAccessControlAllowHeaders)
        pub fn build(self) -> crate::model::ResponseHeadersPolicyAccessControlAllowHeaders {
            crate::model::ResponseHeadersPolicyAccessControlAllowHeaders {
                quantity: self.quantity,
                items: self.items,
            }
        }
    }
}
impl ResponseHeadersPolicyAccessControlAllowHeaders {
    /// Creates a new builder-style object to manufacture [`ResponseHeadersPolicyAccessControlAllowHeaders`](crate::model::ResponseHeadersPolicyAccessControlAllowHeaders)
    pub fn builder() -> crate::model::response_headers_policy_access_control_allow_headers::Builder
    {
        crate::model::response_headers_policy_access_control_allow_headers::Builder::default()
    }
}

/// <p>A list of origins (domain names) that CloudFront can use as the value for the
/// <code>Access-Control-Allow-Origin</code> HTTP response header.</p>
/// <p>For more information about the <code>Access-Control-Allow-Origin</code> HTTP response
/// header, see <a href="https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Access-Control-Allow-Origin">Access-Control-Allow-Origin</a> in the MDN Web Docs.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResponseHeadersPolicyAccessControlAllowOrigins {
    /// <p>The number of origins in the list.</p>
    pub quantity: std::option::Option<i32>,
    /// <p>The list of origins (domain names). You can specify <code>*</code> to allow all
    /// origins.</p>
    pub items: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl ResponseHeadersPolicyAccessControlAllowOrigins {
    /// <p>The number of origins in the list.</p>
    pub fn quantity(&self) -> std::option::Option<i32> {
        self.quantity
    }
    /// <p>The list of origins (domain names). You can specify <code>*</code> to allow all
    /// origins.</p>
    pub fn items(&self) -> std::option::Option<&[std::string::String]> {
        self.items.as_deref()
    }
}
impl std::fmt::Debug for ResponseHeadersPolicyAccessControlAllowOrigins {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResponseHeadersPolicyAccessControlAllowOrigins");
        formatter.field("quantity", &self.quantity);
        formatter.field("items", &self.items);
        formatter.finish()
    }
}
/// See [`ResponseHeadersPolicyAccessControlAllowOrigins`](crate::model::ResponseHeadersPolicyAccessControlAllowOrigins)
pub mod response_headers_policy_access_control_allow_origins {
    /// A builder for [`ResponseHeadersPolicyAccessControlAllowOrigins`](crate::model::ResponseHeadersPolicyAccessControlAllowOrigins)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) quantity: std::option::Option<i32>,
        pub(crate) items: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The number of origins in the list.</p>
        pub fn quantity(mut self, input: i32) -> Self {
            self.quantity = Some(input);
            self
        }
        /// <p>The number of origins in the list.</p>
        pub fn set_quantity(mut self, input: std::option::Option<i32>) -> Self {
            self.quantity = input;
            self
        }
        /// Appends an item to `items`.
        ///
        /// To override the contents of this collection use [`set_items`](Self::set_items).
        ///
        /// <p>The list of origins (domain names). You can specify <code>*</code> to allow all
        /// origins.</p>
        pub fn items(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.items.unwrap_or_default();
            v.push(input.into());
            self.items = Some(v);
            self
        }
        /// <p>The list of origins (domain names). You can specify <code>*</code> to allow all
        /// origins.</p>
        pub fn set_items(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.items = input;
            self
        }
        /// Consumes the builder and constructs a [`ResponseHeadersPolicyAccessControlAllowOrigins`](crate::model::ResponseHeadersPolicyAccessControlAllowOrigins)
        pub fn build(self) -> crate::model::ResponseHeadersPolicyAccessControlAllowOrigins {
            crate::model::ResponseHeadersPolicyAccessControlAllowOrigins {
                quantity: self.quantity,
                items: self.items,
            }
        }
    }
}
impl ResponseHeadersPolicyAccessControlAllowOrigins {
    /// Creates a new builder-style object to manufacture [`ResponseHeadersPolicyAccessControlAllowOrigins`](crate::model::ResponseHeadersPolicyAccessControlAllowOrigins)
    pub fn builder() -> crate::model::response_headers_policy_access_control_allow_origins::Builder
    {
        crate::model::response_headers_policy_access_control_allow_origins::Builder::default()
    }
}

/// <p>A real-time log configuration.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RealtimeLogConfig {
    /// <p>The Amazon Resource Name (ARN) of this real-time log configuration.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The unique name of this real-time log configuration.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The sampling rate for this real-time log configuration. The sampling rate determines the
    /// percentage of viewer requests that are represented in the real-time log data. The
    /// sampling rate is an integer between 1 and 100, inclusive.</p>
    pub sampling_rate: std::option::Option<i64>,
    /// <p>Contains information about the Amazon Kinesis data stream where you are sending real-time
    /// log data for this real-time log configuration.</p>
    pub end_points: std::option::Option<std::vec::Vec<crate::model::EndPoint>>,
    /// <p>A list of fields that are included in each real-time log record. In an API response, the
    /// fields are provided in the same order in which they are sent to the Amazon Kinesis data
    /// stream.</p>
    /// <p>For more information about fields, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/real-time-logs.html#understand-real-time-log-config-fields">Real-time log configuration fields</a> in the
    /// <i>Amazon CloudFront Developer Guide</i>.</p>
    pub fields: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl RealtimeLogConfig {
    /// <p>The Amazon Resource Name (ARN) of this real-time log configuration.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The unique name of this real-time log configuration.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The sampling rate for this real-time log configuration. The sampling rate determines the
    /// percentage of viewer requests that are represented in the real-time log data. The
    /// sampling rate is an integer between 1 and 100, inclusive.</p>
    pub fn sampling_rate(&self) -> std::option::Option<i64> {
        self.sampling_rate
    }
    /// <p>Contains information about the Amazon Kinesis data stream where you are sending real-time
    /// log data for this real-time log configuration.</p>
    pub fn end_points(&self) -> std::option::Option<&[crate::model::EndPoint]> {
        self.end_points.as_deref()
    }
    /// <p>A list of fields that are included in each real-time log record. In an API response, the
    /// fields are provided in the same order in which they are sent to the Amazon Kinesis data
    /// stream.</p>
    /// <p>For more information about fields, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/real-time-logs.html#understand-real-time-log-config-fields">Real-time log configuration fields</a> in the
    /// <i>Amazon CloudFront Developer Guide</i>.</p>
    pub fn fields(&self) -> std::option::Option<&[std::string::String]> {
        self.fields.as_deref()
    }
}
impl std::fmt::Debug for RealtimeLogConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RealtimeLogConfig");
        formatter.field("arn", &self.arn);
        formatter.field("name", &self.name);
        formatter.field("sampling_rate", &self.sampling_rate);
        formatter.field("end_points", &self.end_points);
        formatter.field("fields", &self.fields);
        formatter.finish()
    }
}
/// See [`RealtimeLogConfig`](crate::model::RealtimeLogConfig)
pub mod realtime_log_config {
    /// A builder for [`RealtimeLogConfig`](crate::model::RealtimeLogConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) sampling_rate: std::option::Option<i64>,
        pub(crate) end_points: std::option::Option<std::vec::Vec<crate::model::EndPoint>>,
        pub(crate) fields: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of this real-time log configuration.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of this real-time log configuration.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The unique name of this real-time log configuration.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The unique name of this real-time log configuration.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The sampling rate for this real-time log configuration. The sampling rate determines the
        /// percentage of viewer requests that are represented in the real-time log data. The
        /// sampling rate is an integer between 1 and 100, inclusive.</p>
        pub fn sampling_rate(mut self, input: i64) -> Self {
            self.sampling_rate = Some(input);
            self
        }
        /// <p>The sampling rate for this real-time log configuration. The sampling rate determines the
        /// percentage of viewer requests that are represented in the real-time log data. The
        /// sampling rate is an integer between 1 and 100, inclusive.</p>
        pub fn set_sampling_rate(mut self, input: std::option::Option<i64>) -> Self {
            self.sampling_rate = input;
            self
        }
        /// Appends an item to `end_points`.
        ///
        /// To override the contents of this collection use [`set_end_points`](Self::set_end_points).
        ///
        /// <p>Contains information about the Amazon Kinesis data stream where you are sending real-time
        /// log data for this real-time log configuration.</p>
        pub fn end_points(mut self, input: impl Into<crate::model::EndPoint>) -> Self {
            let mut v = self.end_points.unwrap_or_default();
            v.push(input.into());
            self.end_points = Some(v);
            self
        }
        /// <p>Contains information about the Amazon Kinesis data stream where you are sending real-time
        /// log data for this real-time log configuration.</p>
        pub fn set_end_points(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::EndPoint>>,
        ) -> Self {
            self.end_points = input;
            self
        }
        /// Appends an item to `fields`.
        ///
        /// To override the contents of this collection use [`set_fields`](Self::set_fields).
        ///
        /// <p>A list of fields that are included in each real-time log record. In an API response, the
        /// fields are provided in the same order in which they are sent to the Amazon Kinesis data
        /// stream.</p>
        /// <p>For more information about fields, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/real-time-logs.html#understand-real-time-log-config-fields">Real-time log configuration fields</a> in the
        /// <i>Amazon CloudFront Developer Guide</i>.</p>
        pub fn fields(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.fields.unwrap_or_default();
            v.push(input.into());
            self.fields = Some(v);
            self
        }
        /// <p>A list of fields that are included in each real-time log record. In an API response, the
        /// fields are provided in the same order in which they are sent to the Amazon Kinesis data
        /// stream.</p>
        /// <p>For more information about fields, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/real-time-logs.html#understand-real-time-log-config-fields">Real-time log configuration fields</a> in the
        /// <i>Amazon CloudFront Developer Guide</i>.</p>
        pub fn set_fields(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.fields = input;
            self
        }
        /// Consumes the builder and constructs a [`RealtimeLogConfig`](crate::model::RealtimeLogConfig)
        pub fn build(self) -> crate::model::RealtimeLogConfig {
            crate::model::RealtimeLogConfig {
                arn: self.arn,
                name: self.name,
                sampling_rate: self.sampling_rate,
                end_points: self.end_points,
                fields: self.fields,
            }
        }
    }
}
impl RealtimeLogConfig {
    /// Creates a new builder-style object to manufacture [`RealtimeLogConfig`](crate::model::RealtimeLogConfig)
    pub fn builder() -> crate::model::realtime_log_config::Builder {
        crate::model::realtime_log_config::Builder::default()
    }
}

/// <p>Contains information about the Amazon Kinesis data stream where you are sending real-time
/// log data in a real-time log configuration.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EndPoint {
    /// <p>The type of data stream where you are sending real-time log data. The only valid value is
    /// <code>Kinesis</code>.</p>
    pub stream_type: std::option::Option<std::string::String>,
    /// <p>Contains information about the Amazon Kinesis data stream where you are sending
    /// real-time log data.</p>
    pub kinesis_stream_config: std::option::Option<crate::model::KinesisStreamConfig>,
}
impl EndPoint {
    /// <p>The type of data stream where you are sending real-time log data. The only valid value is
    /// <code>Kinesis</code>.</p>
    pub fn stream_type(&self) -> std::option::Option<&str> {
        self.stream_type.as_deref()
    }
    /// <p>Contains information about the Amazon Kinesis data stream where you are sending
    /// real-time log data.</p>
    pub fn kinesis_stream_config(&self) -> std::option::Option<&crate::model::KinesisStreamConfig> {
        self.kinesis_stream_config.as_ref()
    }
}
impl std::fmt::Debug for EndPoint {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EndPoint");
        formatter.field("stream_type", &self.stream_type);
        formatter.field("kinesis_stream_config", &self.kinesis_stream_config);
        formatter.finish()
    }
}
/// See [`EndPoint`](crate::model::EndPoint)
pub mod end_point {
    /// A builder for [`EndPoint`](crate::model::EndPoint)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) stream_type: std::option::Option<std::string::String>,
        pub(crate) kinesis_stream_config: std::option::Option<crate::model::KinesisStreamConfig>,
    }
    impl Builder {
        /// <p>The type of data stream where you are sending real-time log data. The only valid value is
        /// <code>Kinesis</code>.</p>
        pub fn stream_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.stream_type = Some(input.into());
            self
        }
        /// <p>The type of data stream where you are sending real-time log data. The only valid value is
        /// <code>Kinesis</code>.</p>
        pub fn set_stream_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.stream_type = input;
            self
        }
        /// <p>Contains information about the Amazon Kinesis data stream where you are sending
        /// real-time log data.</p>
        pub fn kinesis_stream_config(mut self, input: crate::model::KinesisStreamConfig) -> Self {
            self.kinesis_stream_config = Some(input);
            self
        }
        /// <p>Contains information about the Amazon Kinesis data stream where you are sending
        /// real-time log data.</p>
        pub fn set_kinesis_stream_config(
            mut self,
            input: std::option::Option<crate::model::KinesisStreamConfig>,
        ) -> Self {
            self.kinesis_stream_config = input;
            self
        }
        /// Consumes the builder and constructs a [`EndPoint`](crate::model::EndPoint)
        pub fn build(self) -> crate::model::EndPoint {
            crate::model::EndPoint {
                stream_type: self.stream_type,
                kinesis_stream_config: self.kinesis_stream_config,
            }
        }
    }
}
impl EndPoint {
    /// Creates a new builder-style object to manufacture [`EndPoint`](crate::model::EndPoint)
    pub fn builder() -> crate::model::end_point::Builder {
        crate::model::end_point::Builder::default()
    }
}

/// <p>Contains information about the Amazon Kinesis data stream where you are sending
/// real-time log data.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct KinesisStreamConfig {
    /// <p>The Amazon Resource Name (ARN) of an Identity and Access Management (IAM) role that
    /// CloudFront can use to send real-time log data to your Kinesis data stream.</p>
    /// <p>For more information the IAM role, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/real-time-logs.html#understand-real-time-log-config-iam-role">Real-time log configuration IAM role</a> in the
    /// <i>Amazon CloudFront Developer Guide</i>.</p>
    pub role_arn: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the Kinesis data stream where you are sending real-time
    /// log data.</p>
    pub stream_arn: std::option::Option<std::string::String>,
}
impl KinesisStreamConfig {
    /// <p>The Amazon Resource Name (ARN) of an Identity and Access Management (IAM) role that
    /// CloudFront can use to send real-time log data to your Kinesis data stream.</p>
    /// <p>For more information the IAM role, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/real-time-logs.html#understand-real-time-log-config-iam-role">Real-time log configuration IAM role</a> in the
    /// <i>Amazon CloudFront Developer Guide</i>.</p>
    pub fn role_arn(&self) -> std::option::Option<&str> {
        self.role_arn.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the Kinesis data stream where you are sending real-time
    /// log data.</p>
    pub fn stream_arn(&self) -> std::option::Option<&str> {
        self.stream_arn.as_deref()
    }
}
impl std::fmt::Debug for KinesisStreamConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("KinesisStreamConfig");
        formatter.field("role_arn", &self.role_arn);
        formatter.field("stream_arn", &self.stream_arn);
        formatter.finish()
    }
}
/// See [`KinesisStreamConfig`](crate::model::KinesisStreamConfig)
pub mod kinesis_stream_config {
    /// A builder for [`KinesisStreamConfig`](crate::model::KinesisStreamConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) role_arn: std::option::Option<std::string::String>,
        pub(crate) stream_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of an Identity and Access Management (IAM) role that
        /// CloudFront can use to send real-time log data to your Kinesis data stream.</p>
        /// <p>For more information the IAM role, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/real-time-logs.html#understand-real-time-log-config-iam-role">Real-time log configuration IAM role</a> in the
        /// <i>Amazon CloudFront Developer Guide</i>.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of an Identity and Access Management (IAM) role that
        /// CloudFront can use to send real-time log data to your Kinesis data stream.</p>
        /// <p>For more information the IAM role, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/real-time-logs.html#understand-real-time-log-config-iam-role">Real-time log configuration IAM role</a> in the
        /// <i>Amazon CloudFront Developer Guide</i>.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_arn = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Kinesis data stream where you are sending real-time
        /// log data.</p>
        pub fn stream_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.stream_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Kinesis data stream where you are sending real-time
        /// log data.</p>
        pub fn set_stream_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.stream_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`KinesisStreamConfig`](crate::model::KinesisStreamConfig)
        pub fn build(self) -> crate::model::KinesisStreamConfig {
            crate::model::KinesisStreamConfig {
                role_arn: self.role_arn,
                stream_arn: self.stream_arn,
            }
        }
    }
}
impl KinesisStreamConfig {
    /// Creates a new builder-style object to manufacture [`KinesisStreamConfig`](crate::model::KinesisStreamConfig)
    pub fn builder() -> crate::model::kinesis_stream_config::Builder {
        crate::model::kinesis_stream_config::Builder::default()
    }
}

/// <p>A public key that you can use with <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html">signed URLs and signed cookies</a>, or with <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/field-level-encryption.html">field-level encryption</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PublicKey {
    /// <p>The identifier of the public key.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The date and time when the public key was uploaded.</p>
    pub created_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>Configuration information about a public key that you can use with <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html">signed URLs and signed cookies</a>, or with <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/field-level-encryption.html">field-level encryption</a>.</p>
    pub public_key_config: std::option::Option<crate::model::PublicKeyConfig>,
}
impl PublicKey {
    /// <p>The identifier of the public key.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The date and time when the public key was uploaded.</p>
    pub fn created_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.created_time.as_ref()
    }
    /// <p>Configuration information about a public key that you can use with <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html">signed URLs and signed cookies</a>, or with <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/field-level-encryption.html">field-level encryption</a>.</p>
    pub fn public_key_config(&self) -> std::option::Option<&crate::model::PublicKeyConfig> {
        self.public_key_config.as_ref()
    }
}
impl std::fmt::Debug for PublicKey {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PublicKey");
        formatter.field("id", &self.id);
        formatter.field("created_time", &self.created_time);
        formatter.field("public_key_config", &self.public_key_config);
        formatter.finish()
    }
}
/// See [`PublicKey`](crate::model::PublicKey)
pub mod public_key {
    /// A builder for [`PublicKey`](crate::model::PublicKey)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) created_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) public_key_config: std::option::Option<crate::model::PublicKeyConfig>,
    }
    impl Builder {
        /// <p>The identifier of the public key.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The identifier of the public key.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The date and time when the public key was uploaded.</p>
        pub fn created_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.created_time = Some(input);
            self
        }
        /// <p>The date and time when the public key was uploaded.</p>
        pub fn set_created_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.created_time = input;
            self
        }
        /// <p>Configuration information about a public key that you can use with <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html">signed URLs and signed cookies</a>, or with <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/field-level-encryption.html">field-level encryption</a>.</p>
        pub fn public_key_config(mut self, input: crate::model::PublicKeyConfig) -> Self {
            self.public_key_config = Some(input);
            self
        }
        /// <p>Configuration information about a public key that you can use with <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html">signed URLs and signed cookies</a>, or with <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/field-level-encryption.html">field-level encryption</a>.</p>
        pub fn set_public_key_config(
            mut self,
            input: std::option::Option<crate::model::PublicKeyConfig>,
        ) -> Self {
            self.public_key_config = input;
            self
        }
        /// Consumes the builder and constructs a [`PublicKey`](crate::model::PublicKey)
        pub fn build(self) -> crate::model::PublicKey {
            crate::model::PublicKey {
                id: self.id,
                created_time: self.created_time,
                public_key_config: self.public_key_config,
            }
        }
    }
}
impl PublicKey {
    /// Creates a new builder-style object to manufacture [`PublicKey`](crate::model::PublicKey)
    pub fn builder() -> crate::model::public_key::Builder {
        crate::model::public_key::Builder::default()
    }
}

/// <p>Configuration information about a public key that you can use with <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html">signed URLs and signed cookies</a>, or with <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/field-level-encryption.html">field-level encryption</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PublicKeyConfig {
    /// <p>A string included in the request to help make sure that the request can’t be
    /// replayed.</p>
    pub caller_reference: std::option::Option<std::string::String>,
    /// <p>A name to help identify the public key.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The public key that you can use with <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html">signed URLs and signed cookies</a>, or with <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/field-level-encryption.html">field-level encryption</a>.</p>
    pub encoded_key: std::option::Option<std::string::String>,
    /// <p>A comment to describe the public key. The comment cannot be longer than 128
    /// characters.</p>
    pub comment: std::option::Option<std::string::String>,
}
impl PublicKeyConfig {
    /// <p>A string included in the request to help make sure that the request can’t be
    /// replayed.</p>
    pub fn caller_reference(&self) -> std::option::Option<&str> {
        self.caller_reference.as_deref()
    }
    /// <p>A name to help identify the public key.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The public key that you can use with <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html">signed URLs and signed cookies</a>, or with <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/field-level-encryption.html">field-level encryption</a>.</p>
    pub fn encoded_key(&self) -> std::option::Option<&str> {
        self.encoded_key.as_deref()
    }
    /// <p>A comment to describe the public key. The comment cannot be longer than 128
    /// characters.</p>
    pub fn comment(&self) -> std::option::Option<&str> {
        self.comment.as_deref()
    }
}
impl std::fmt::Debug for PublicKeyConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PublicKeyConfig");
        formatter.field("caller_reference", &self.caller_reference);
        formatter.field("name", &self.name);
        formatter.field("encoded_key", &self.encoded_key);
        formatter.field("comment", &self.comment);
        formatter.finish()
    }
}
/// See [`PublicKeyConfig`](crate::model::PublicKeyConfig)
pub mod public_key_config {
    /// A builder for [`PublicKeyConfig`](crate::model::PublicKeyConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) caller_reference: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) encoded_key: std::option::Option<std::string::String>,
        pub(crate) comment: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A string included in the request to help make sure that the request can’t be
        /// replayed.</p>
        pub fn caller_reference(mut self, input: impl Into<std::string::String>) -> Self {
            self.caller_reference = Some(input.into());
            self
        }
        /// <p>A string included in the request to help make sure that the request can’t be
        /// replayed.</p>
        pub fn set_caller_reference(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.caller_reference = input;
            self
        }
        /// <p>A name to help identify the public key.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>A name to help identify the public key.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The public key that you can use with <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html">signed URLs and signed cookies</a>, or with <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/field-level-encryption.html">field-level encryption</a>.</p>
        pub fn encoded_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.encoded_key = Some(input.into());
            self
        }
        /// <p>The public key that you can use with <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html">signed URLs and signed cookies</a>, or with <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/field-level-encryption.html">field-level encryption</a>.</p>
        pub fn set_encoded_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.encoded_key = input;
            self
        }
        /// <p>A comment to describe the public key. The comment cannot be longer than 128
        /// characters.</p>
        pub fn comment(mut self, input: impl Into<std::string::String>) -> Self {
            self.comment = Some(input.into());
            self
        }
        /// <p>A comment to describe the public key. The comment cannot be longer than 128
        /// characters.</p>
        pub fn set_comment(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.comment = input;
            self
        }
        /// Consumes the builder and constructs a [`PublicKeyConfig`](crate::model::PublicKeyConfig)
        pub fn build(self) -> crate::model::PublicKeyConfig {
            crate::model::PublicKeyConfig {
                caller_reference: self.caller_reference,
                name: self.name,
                encoded_key: self.encoded_key,
                comment: self.comment,
            }
        }
    }
}
impl PublicKeyConfig {
    /// Creates a new builder-style object to manufacture [`PublicKeyConfig`](crate::model::PublicKeyConfig)
    pub fn builder() -> crate::model::public_key_config::Builder {
        crate::model::public_key_config::Builder::default()
    }
}

/// <p>An origin request policy.</p>
/// <p>When it’s attached to a cache behavior, the origin request policy determines the values that
/// CloudFront includes in requests that it sends to the origin. Each request that CloudFront sends to
/// the origin includes the following:</p>
/// <ul>
/// <li>
/// <p>The request body and the URL path (without the domain name) from the viewer
/// request.</p>
/// </li>
/// <li>
/// <p>The headers that CloudFront automatically includes in every origin request, including
/// <code>Host</code>, <code>User-Agent</code>, and <code>X-Amz-Cf-Id</code>.</p>
/// </li>
/// <li>
/// <p>All HTTP headers, cookies, and URL query strings that are specified in the
/// cache policy or the origin request policy. These can include items from the
/// viewer request and, in the case of headers, additional ones that are added by
/// CloudFront.</p>
/// </li>
/// </ul>
/// <p>CloudFront sends a request when it can’t find an object in its cache that matches the request. If
/// you want to send values to the origin and also include them in the cache key, use
/// <code>CachePolicy</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct OriginRequestPolicy {
    /// <p>The unique identifier for the origin request policy.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The date and time when the origin request policy was last modified.</p>
    pub last_modified_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The origin request policy configuration.</p>
    pub origin_request_policy_config: std::option::Option<crate::model::OriginRequestPolicyConfig>,
}
impl OriginRequestPolicy {
    /// <p>The unique identifier for the origin request policy.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The date and time when the origin request policy was last modified.</p>
    pub fn last_modified_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_modified_time.as_ref()
    }
    /// <p>The origin request policy configuration.</p>
    pub fn origin_request_policy_config(
        &self,
    ) -> std::option::Option<&crate::model::OriginRequestPolicyConfig> {
        self.origin_request_policy_config.as_ref()
    }
}
impl std::fmt::Debug for OriginRequestPolicy {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("OriginRequestPolicy");
        formatter.field("id", &self.id);
        formatter.field("last_modified_time", &self.last_modified_time);
        formatter.field(
            "origin_request_policy_config",
            &self.origin_request_policy_config,
        );
        formatter.finish()
    }
}
/// See [`OriginRequestPolicy`](crate::model::OriginRequestPolicy)
pub mod origin_request_policy {
    /// A builder for [`OriginRequestPolicy`](crate::model::OriginRequestPolicy)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) last_modified_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) origin_request_policy_config:
            std::option::Option<crate::model::OriginRequestPolicyConfig>,
    }
    impl Builder {
        /// <p>The unique identifier for the origin request policy.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the origin request policy.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The date and time when the origin request policy was last modified.</p>
        pub fn last_modified_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_modified_time = Some(input);
            self
        }
        /// <p>The date and time when the origin request policy was last modified.</p>
        pub fn set_last_modified_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_modified_time = input;
            self
        }
        /// <p>The origin request policy configuration.</p>
        pub fn origin_request_policy_config(
            mut self,
            input: crate::model::OriginRequestPolicyConfig,
        ) -> Self {
            self.origin_request_policy_config = Some(input);
            self
        }
        /// <p>The origin request policy configuration.</p>
        pub fn set_origin_request_policy_config(
            mut self,
            input: std::option::Option<crate::model::OriginRequestPolicyConfig>,
        ) -> Self {
            self.origin_request_policy_config = input;
            self
        }
        /// Consumes the builder and constructs a [`OriginRequestPolicy`](crate::model::OriginRequestPolicy)
        pub fn build(self) -> crate::model::OriginRequestPolicy {
            crate::model::OriginRequestPolicy {
                id: self.id,
                last_modified_time: self.last_modified_time,
                origin_request_policy_config: self.origin_request_policy_config,
            }
        }
    }
}
impl OriginRequestPolicy {
    /// Creates a new builder-style object to manufacture [`OriginRequestPolicy`](crate::model::OriginRequestPolicy)
    pub fn builder() -> crate::model::origin_request_policy::Builder {
        crate::model::origin_request_policy::Builder::default()
    }
}

/// <p>An origin request policy configuration.</p>
/// <p>This configuration determines the values that CloudFront includes in requests that it sends to the
/// origin. Each request that CloudFront sends to the origin includes the following:</p>
/// <ul>
/// <li>
/// <p>The request body and the URL path (without the domain name) from the viewer
/// request.</p>
/// </li>
/// <li>
/// <p>The headers that CloudFront automatically includes in every origin request, including
/// <code>Host</code>, <code>User-Agent</code>, and <code>X-Amz-Cf-Id</code>.</p>
/// </li>
/// <li>
/// <p>All HTTP headers, cookies, and URL query strings that are specified in the
/// cache policy or the origin request policy. These can include items from the
/// viewer request and, in the case of headers, additional ones that are added by
/// CloudFront.</p>
/// </li>
/// </ul>
/// <p>CloudFront sends a request when it can’t find an object in its cache that matches the request. If
/// you want to send values to the origin and also include them in the cache key, use
/// <code>CachePolicy</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct OriginRequestPolicyConfig {
    /// <p>A comment to describe the origin request policy. The comment cannot be longer than 128
    /// characters.</p>
    pub comment: std::option::Option<std::string::String>,
    /// <p>A unique name to identify the origin request policy.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The HTTP headers to include in origin requests. These can include headers from viewer
    /// requests and additional headers added by CloudFront.</p>
    pub headers_config: std::option::Option<crate::model::OriginRequestPolicyHeadersConfig>,
    /// <p>The cookies from viewer requests to include in origin requests.</p>
    pub cookies_config: std::option::Option<crate::model::OriginRequestPolicyCookiesConfig>,
    /// <p>The URL query strings from viewer requests to include in origin requests.</p>
    pub query_strings_config:
        std::option::Option<crate::model::OriginRequestPolicyQueryStringsConfig>,
}
impl OriginRequestPolicyConfig {
    /// <p>A comment to describe the origin request policy. The comment cannot be longer than 128
    /// characters.</p>
    pub fn comment(&self) -> std::option::Option<&str> {
        self.comment.as_deref()
    }
    /// <p>A unique name to identify the origin request policy.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The HTTP headers to include in origin requests. These can include headers from viewer
    /// requests and additional headers added by CloudFront.</p>
    pub fn headers_config(
        &self,
    ) -> std::option::Option<&crate::model::OriginRequestPolicyHeadersConfig> {
        self.headers_config.as_ref()
    }
    /// <p>The cookies from viewer requests to include in origin requests.</p>
    pub fn cookies_config(
        &self,
    ) -> std::option::Option<&crate::model::OriginRequestPolicyCookiesConfig> {
        self.cookies_config.as_ref()
    }
    /// <p>The URL query strings from viewer requests to include in origin requests.</p>
    pub fn query_strings_config(
        &self,
    ) -> std::option::Option<&crate::model::OriginRequestPolicyQueryStringsConfig> {
        self.query_strings_config.as_ref()
    }
}
impl std::fmt::Debug for OriginRequestPolicyConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("OriginRequestPolicyConfig");
        formatter.field("comment", &self.comment);
        formatter.field("name", &self.name);
        formatter.field("headers_config", &self.headers_config);
        formatter.field("cookies_config", &self.cookies_config);
        formatter.field("query_strings_config", &self.query_strings_config);
        formatter.finish()
    }
}
/// See [`OriginRequestPolicyConfig`](crate::model::OriginRequestPolicyConfig)
pub mod origin_request_policy_config {
    /// A builder for [`OriginRequestPolicyConfig`](crate::model::OriginRequestPolicyConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) comment: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) headers_config:
            std::option::Option<crate::model::OriginRequestPolicyHeadersConfig>,
        pub(crate) cookies_config:
            std::option::Option<crate::model::OriginRequestPolicyCookiesConfig>,
        pub(crate) query_strings_config:
            std::option::Option<crate::model::OriginRequestPolicyQueryStringsConfig>,
    }
    impl Builder {
        /// <p>A comment to describe the origin request policy. The comment cannot be longer than 128
        /// characters.</p>
        pub fn comment(mut self, input: impl Into<std::string::String>) -> Self {
            self.comment = Some(input.into());
            self
        }
        /// <p>A comment to describe the origin request policy. The comment cannot be longer than 128
        /// characters.</p>
        pub fn set_comment(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.comment = input;
            self
        }
        /// <p>A unique name to identify the origin request policy.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>A unique name to identify the origin request policy.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The HTTP headers to include in origin requests. These can include headers from viewer
        /// requests and additional headers added by CloudFront.</p>
        pub fn headers_config(
            mut self,
            input: crate::model::OriginRequestPolicyHeadersConfig,
        ) -> Self {
            self.headers_config = Some(input);
            self
        }
        /// <p>The HTTP headers to include in origin requests. These can include headers from viewer
        /// requests and additional headers added by CloudFront.</p>
        pub fn set_headers_config(
            mut self,
            input: std::option::Option<crate::model::OriginRequestPolicyHeadersConfig>,
        ) -> Self {
            self.headers_config = input;
            self
        }
        /// <p>The cookies from viewer requests to include in origin requests.</p>
        pub fn cookies_config(
            mut self,
            input: crate::model::OriginRequestPolicyCookiesConfig,
        ) -> Self {
            self.cookies_config = Some(input);
            self
        }
        /// <p>The cookies from viewer requests to include in origin requests.</p>
        pub fn set_cookies_config(
            mut self,
            input: std::option::Option<crate::model::OriginRequestPolicyCookiesConfig>,
        ) -> Self {
            self.cookies_config = input;
            self
        }
        /// <p>The URL query strings from viewer requests to include in origin requests.</p>
        pub fn query_strings_config(
            mut self,
            input: crate::model::OriginRequestPolicyQueryStringsConfig,
        ) -> Self {
            self.query_strings_config = Some(input);
            self
        }
        /// <p>The URL query strings from viewer requests to include in origin requests.</p>
        pub fn set_query_strings_config(
            mut self,
            input: std::option::Option<crate::model::OriginRequestPolicyQueryStringsConfig>,
        ) -> Self {
            self.query_strings_config = input;
            self
        }
        /// Consumes the builder and constructs a [`OriginRequestPolicyConfig`](crate::model::OriginRequestPolicyConfig)
        pub fn build(self) -> crate::model::OriginRequestPolicyConfig {
            crate::model::OriginRequestPolicyConfig {
                comment: self.comment,
                name: self.name,
                headers_config: self.headers_config,
                cookies_config: self.cookies_config,
                query_strings_config: self.query_strings_config,
            }
        }
    }
}
impl OriginRequestPolicyConfig {
    /// Creates a new builder-style object to manufacture [`OriginRequestPolicyConfig`](crate::model::OriginRequestPolicyConfig)
    pub fn builder() -> crate::model::origin_request_policy_config::Builder {
        crate::model::origin_request_policy_config::Builder::default()
    }
}

/// <p>An object that determines whether any URL query strings in viewer requests (and if so, which
/// query strings) are included in requests that CloudFront sends to the origin.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct OriginRequestPolicyQueryStringsConfig {
    /// <p>Determines whether any URL query strings in viewer requests are included in requests that
    /// CloudFront sends to the origin. Valid values are:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>none</code> – Query strings in viewer requests are not included in requests that
    /// CloudFront sends to the origin. Even when this field is set to <code>none</code>, any
    /// query strings that are listed in a <code>CachePolicy</code>
    /// <i>are</i> included in origin requests.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>whitelist</code> – The query strings in viewer requests that are listed in the
    /// <code>QueryStringNames</code> type are included in requests that CloudFront sends to
    /// the origin.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>all</code> – All query strings in viewer requests are included in requests that CloudFront
    /// sends to the origin.</p>
    /// </li>
    /// </ul>
    pub query_string_behavior:
        std::option::Option<crate::model::OriginRequestPolicyQueryStringBehavior>,
    /// <p>Contains a list of the query strings in viewer requests that are included in requests that
    /// CloudFront sends to the origin.</p>
    pub query_strings: std::option::Option<crate::model::QueryStringNames>,
}
impl OriginRequestPolicyQueryStringsConfig {
    /// <p>Determines whether any URL query strings in viewer requests are included in requests that
    /// CloudFront sends to the origin. Valid values are:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>none</code> – Query strings in viewer requests are not included in requests that
    /// CloudFront sends to the origin. Even when this field is set to <code>none</code>, any
    /// query strings that are listed in a <code>CachePolicy</code>
    /// <i>are</i> included in origin requests.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>whitelist</code> – The query strings in viewer requests that are listed in the
    /// <code>QueryStringNames</code> type are included in requests that CloudFront sends to
    /// the origin.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>all</code> – All query strings in viewer requests are included in requests that CloudFront
    /// sends to the origin.</p>
    /// </li>
    /// </ul>
    pub fn query_string_behavior(
        &self,
    ) -> std::option::Option<&crate::model::OriginRequestPolicyQueryStringBehavior> {
        self.query_string_behavior.as_ref()
    }
    /// <p>Contains a list of the query strings in viewer requests that are included in requests that
    /// CloudFront sends to the origin.</p>
    pub fn query_strings(&self) -> std::option::Option<&crate::model::QueryStringNames> {
        self.query_strings.as_ref()
    }
}
impl std::fmt::Debug for OriginRequestPolicyQueryStringsConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("OriginRequestPolicyQueryStringsConfig");
        formatter.field("query_string_behavior", &self.query_string_behavior);
        formatter.field("query_strings", &self.query_strings);
        formatter.finish()
    }
}
/// See [`OriginRequestPolicyQueryStringsConfig`](crate::model::OriginRequestPolicyQueryStringsConfig)
pub mod origin_request_policy_query_strings_config {
    /// A builder for [`OriginRequestPolicyQueryStringsConfig`](crate::model::OriginRequestPolicyQueryStringsConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) query_string_behavior:
            std::option::Option<crate::model::OriginRequestPolicyQueryStringBehavior>,
        pub(crate) query_strings: std::option::Option<crate::model::QueryStringNames>,
    }
    impl Builder {
        /// <p>Determines whether any URL query strings in viewer requests are included in requests that
        /// CloudFront sends to the origin. Valid values are:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>none</code> – Query strings in viewer requests are not included in requests that
        /// CloudFront sends to the origin. Even when this field is set to <code>none</code>, any
        /// query strings that are listed in a <code>CachePolicy</code>
        /// <i>are</i> included in origin requests.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>whitelist</code> – The query strings in viewer requests that are listed in the
        /// <code>QueryStringNames</code> type are included in requests that CloudFront sends to
        /// the origin.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>all</code> – All query strings in viewer requests are included in requests that CloudFront
        /// sends to the origin.</p>
        /// </li>
        /// </ul>
        pub fn query_string_behavior(
            mut self,
            input: crate::model::OriginRequestPolicyQueryStringBehavior,
        ) -> Self {
            self.query_string_behavior = Some(input);
            self
        }
        /// <p>Determines whether any URL query strings in viewer requests are included in requests that
        /// CloudFront sends to the origin. Valid values are:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>none</code> – Query strings in viewer requests are not included in requests that
        /// CloudFront sends to the origin. Even when this field is set to <code>none</code>, any
        /// query strings that are listed in a <code>CachePolicy</code>
        /// <i>are</i> included in origin requests.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>whitelist</code> – The query strings in viewer requests that are listed in the
        /// <code>QueryStringNames</code> type are included in requests that CloudFront sends to
        /// the origin.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>all</code> – All query strings in viewer requests are included in requests that CloudFront
        /// sends to the origin.</p>
        /// </li>
        /// </ul>
        pub fn set_query_string_behavior(
            mut self,
            input: std::option::Option<crate::model::OriginRequestPolicyQueryStringBehavior>,
        ) -> Self {
            self.query_string_behavior = input;
            self
        }
        /// <p>Contains a list of the query strings in viewer requests that are included in requests that
        /// CloudFront sends to the origin.</p>
        pub fn query_strings(mut self, input: crate::model::QueryStringNames) -> Self {
            self.query_strings = Some(input);
            self
        }
        /// <p>Contains a list of the query strings in viewer requests that are included in requests that
        /// CloudFront sends to the origin.</p>
        pub fn set_query_strings(
            mut self,
            input: std::option::Option<crate::model::QueryStringNames>,
        ) -> Self {
            self.query_strings = input;
            self
        }
        /// Consumes the builder and constructs a [`OriginRequestPolicyQueryStringsConfig`](crate::model::OriginRequestPolicyQueryStringsConfig)
        pub fn build(self) -> crate::model::OriginRequestPolicyQueryStringsConfig {
            crate::model::OriginRequestPolicyQueryStringsConfig {
                query_string_behavior: self.query_string_behavior,
                query_strings: self.query_strings,
            }
        }
    }
}
impl OriginRequestPolicyQueryStringsConfig {
    /// Creates a new builder-style object to manufacture [`OriginRequestPolicyQueryStringsConfig`](crate::model::OriginRequestPolicyQueryStringsConfig)
    pub fn builder() -> crate::model::origin_request_policy_query_strings_config::Builder {
        crate::model::origin_request_policy_query_strings_config::Builder::default()
    }
}

/// <p>Contains a list of query string names.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct QueryStringNames {
    /// <p>The number of query string names in the <code>Items</code> list.</p>
    pub quantity: std::option::Option<i32>,
    /// <p>A list of query string names.</p>
    pub items: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl QueryStringNames {
    /// <p>The number of query string names in the <code>Items</code> list.</p>
    pub fn quantity(&self) -> std::option::Option<i32> {
        self.quantity
    }
    /// <p>A list of query string names.</p>
    pub fn items(&self) -> std::option::Option<&[std::string::String]> {
        self.items.as_deref()
    }
}
impl std::fmt::Debug for QueryStringNames {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("QueryStringNames");
        formatter.field("quantity", &self.quantity);
        formatter.field("items", &self.items);
        formatter.finish()
    }
}
/// See [`QueryStringNames`](crate::model::QueryStringNames)
pub mod query_string_names {
    /// A builder for [`QueryStringNames`](crate::model::QueryStringNames)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) quantity: std::option::Option<i32>,
        pub(crate) items: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The number of query string names in the <code>Items</code> list.</p>
        pub fn quantity(mut self, input: i32) -> Self {
            self.quantity = Some(input);
            self
        }
        /// <p>The number of query string names in the <code>Items</code> list.</p>
        pub fn set_quantity(mut self, input: std::option::Option<i32>) -> Self {
            self.quantity = input;
            self
        }
        /// Appends an item to `items`.
        ///
        /// To override the contents of this collection use [`set_items`](Self::set_items).
        ///
        /// <p>A list of query string names.</p>
        pub fn items(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.items.unwrap_or_default();
            v.push(input.into());
            self.items = Some(v);
            self
        }
        /// <p>A list of query string names.</p>
        pub fn set_items(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.items = input;
            self
        }
        /// Consumes the builder and constructs a [`QueryStringNames`](crate::model::QueryStringNames)
        pub fn build(self) -> crate::model::QueryStringNames {
            crate::model::QueryStringNames {
                quantity: self.quantity,
                items: self.items,
            }
        }
    }
}
impl QueryStringNames {
    /// Creates a new builder-style object to manufacture [`QueryStringNames`](crate::model::QueryStringNames)
    pub fn builder() -> crate::model::query_string_names::Builder {
        crate::model::query_string_names::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum OriginRequestPolicyQueryStringBehavior {
    #[allow(missing_docs)] // documentation missing in model
    All,
    #[allow(missing_docs)] // documentation missing in model
    None,
    #[allow(missing_docs)] // documentation missing in model
    Whitelist,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for OriginRequestPolicyQueryStringBehavior {
    fn from(s: &str) -> Self {
        match s {
            "all" => OriginRequestPolicyQueryStringBehavior::All,
            "none" => OriginRequestPolicyQueryStringBehavior::None,
            "whitelist" => OriginRequestPolicyQueryStringBehavior::Whitelist,
            other => OriginRequestPolicyQueryStringBehavior::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for OriginRequestPolicyQueryStringBehavior {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(OriginRequestPolicyQueryStringBehavior::from(s))
    }
}
impl OriginRequestPolicyQueryStringBehavior {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            OriginRequestPolicyQueryStringBehavior::All => "all",
            OriginRequestPolicyQueryStringBehavior::None => "none",
            OriginRequestPolicyQueryStringBehavior::Whitelist => "whitelist",
            OriginRequestPolicyQueryStringBehavior::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["all", "none", "whitelist"]
    }
}
impl AsRef<str> for OriginRequestPolicyQueryStringBehavior {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>An object that determines whether any cookies in viewer requests (and if so, which cookies)
/// are included in requests that CloudFront sends to the origin.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct OriginRequestPolicyCookiesConfig {
    /// <p>Determines whether cookies in viewer requests are included in requests that CloudFront sends to
    /// the origin. Valid values are:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>none</code> – Cookies in viewer requests are not included in requests that CloudFront
    /// sends to the origin. Even when this field is set to <code>none</code>, any
    /// cookies that are listed in a <code>CachePolicy</code>
    /// <i>are</i>
    /// included in origin requests.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>whitelist</code> – The cookies in viewer requests that are listed in the
    /// <code>CookieNames</code> type are included in requests that CloudFront sends to the
    /// origin.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>all</code> – All cookies in viewer requests are included in requests that CloudFront sends
    /// to the origin.</p>
    /// </li>
    /// </ul>
    pub cookie_behavior: std::option::Option<crate::model::OriginRequestPolicyCookieBehavior>,
    /// <p>Contains a list of cookie names.</p>
    pub cookies: std::option::Option<crate::model::CookieNames>,
}
impl OriginRequestPolicyCookiesConfig {
    /// <p>Determines whether cookies in viewer requests are included in requests that CloudFront sends to
    /// the origin. Valid values are:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>none</code> – Cookies in viewer requests are not included in requests that CloudFront
    /// sends to the origin. Even when this field is set to <code>none</code>, any
    /// cookies that are listed in a <code>CachePolicy</code>
    /// <i>are</i>
    /// included in origin requests.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>whitelist</code> – The cookies in viewer requests that are listed in the
    /// <code>CookieNames</code> type are included in requests that CloudFront sends to the
    /// origin.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>all</code> – All cookies in viewer requests are included in requests that CloudFront sends
    /// to the origin.</p>
    /// </li>
    /// </ul>
    pub fn cookie_behavior(
        &self,
    ) -> std::option::Option<&crate::model::OriginRequestPolicyCookieBehavior> {
        self.cookie_behavior.as_ref()
    }
    /// <p>Contains a list of cookie names.</p>
    pub fn cookies(&self) -> std::option::Option<&crate::model::CookieNames> {
        self.cookies.as_ref()
    }
}
impl std::fmt::Debug for OriginRequestPolicyCookiesConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("OriginRequestPolicyCookiesConfig");
        formatter.field("cookie_behavior", &self.cookie_behavior);
        formatter.field("cookies", &self.cookies);
        formatter.finish()
    }
}
/// See [`OriginRequestPolicyCookiesConfig`](crate::model::OriginRequestPolicyCookiesConfig)
pub mod origin_request_policy_cookies_config {
    /// A builder for [`OriginRequestPolicyCookiesConfig`](crate::model::OriginRequestPolicyCookiesConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cookie_behavior:
            std::option::Option<crate::model::OriginRequestPolicyCookieBehavior>,
        pub(crate) cookies: std::option::Option<crate::model::CookieNames>,
    }
    impl Builder {
        /// <p>Determines whether cookies in viewer requests are included in requests that CloudFront sends to
        /// the origin. Valid values are:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>none</code> – Cookies in viewer requests are not included in requests that CloudFront
        /// sends to the origin. Even when this field is set to <code>none</code>, any
        /// cookies that are listed in a <code>CachePolicy</code>
        /// <i>are</i>
        /// included in origin requests.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>whitelist</code> – The cookies in viewer requests that are listed in the
        /// <code>CookieNames</code> type are included in requests that CloudFront sends to the
        /// origin.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>all</code> – All cookies in viewer requests are included in requests that CloudFront sends
        /// to the origin.</p>
        /// </li>
        /// </ul>
        pub fn cookie_behavior(
            mut self,
            input: crate::model::OriginRequestPolicyCookieBehavior,
        ) -> Self {
            self.cookie_behavior = Some(input);
            self
        }
        /// <p>Determines whether cookies in viewer requests are included in requests that CloudFront sends to
        /// the origin. Valid values are:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>none</code> – Cookies in viewer requests are not included in requests that CloudFront
        /// sends to the origin. Even when this field is set to <code>none</code>, any
        /// cookies that are listed in a <code>CachePolicy</code>
        /// <i>are</i>
        /// included in origin requests.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>whitelist</code> – The cookies in viewer requests that are listed in the
        /// <code>CookieNames</code> type are included in requests that CloudFront sends to the
        /// origin.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>all</code> – All cookies in viewer requests are included in requests that CloudFront sends
        /// to the origin.</p>
        /// </li>
        /// </ul>
        pub fn set_cookie_behavior(
            mut self,
            input: std::option::Option<crate::model::OriginRequestPolicyCookieBehavior>,
        ) -> Self {
            self.cookie_behavior = input;
            self
        }
        /// <p>Contains a list of cookie names.</p>
        pub fn cookies(mut self, input: crate::model::CookieNames) -> Self {
            self.cookies = Some(input);
            self
        }
        /// <p>Contains a list of cookie names.</p>
        pub fn set_cookies(
            mut self,
            input: std::option::Option<crate::model::CookieNames>,
        ) -> Self {
            self.cookies = input;
            self
        }
        /// Consumes the builder and constructs a [`OriginRequestPolicyCookiesConfig`](crate::model::OriginRequestPolicyCookiesConfig)
        pub fn build(self) -> crate::model::OriginRequestPolicyCookiesConfig {
            crate::model::OriginRequestPolicyCookiesConfig {
                cookie_behavior: self.cookie_behavior,
                cookies: self.cookies,
            }
        }
    }
}
impl OriginRequestPolicyCookiesConfig {
    /// Creates a new builder-style object to manufacture [`OriginRequestPolicyCookiesConfig`](crate::model::OriginRequestPolicyCookiesConfig)
    pub fn builder() -> crate::model::origin_request_policy_cookies_config::Builder {
        crate::model::origin_request_policy_cookies_config::Builder::default()
    }
}

/// <p>Contains a list of cookie names.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CookieNames {
    /// <p>The number of cookie names in the <code>Items</code> list.</p>
    pub quantity: std::option::Option<i32>,
    /// <p>A list of cookie names.</p>
    pub items: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl CookieNames {
    /// <p>The number of cookie names in the <code>Items</code> list.</p>
    pub fn quantity(&self) -> std::option::Option<i32> {
        self.quantity
    }
    /// <p>A list of cookie names.</p>
    pub fn items(&self) -> std::option::Option<&[std::string::String]> {
        self.items.as_deref()
    }
}
impl std::fmt::Debug for CookieNames {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CookieNames");
        formatter.field("quantity", &self.quantity);
        formatter.field("items", &self.items);
        formatter.finish()
    }
}
/// See [`CookieNames`](crate::model::CookieNames)
pub mod cookie_names {
    /// A builder for [`CookieNames`](crate::model::CookieNames)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) quantity: std::option::Option<i32>,
        pub(crate) items: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The number of cookie names in the <code>Items</code> list.</p>
        pub fn quantity(mut self, input: i32) -> Self {
            self.quantity = Some(input);
            self
        }
        /// <p>The number of cookie names in the <code>Items</code> list.</p>
        pub fn set_quantity(mut self, input: std::option::Option<i32>) -> Self {
            self.quantity = input;
            self
        }
        /// Appends an item to `items`.
        ///
        /// To override the contents of this collection use [`set_items`](Self::set_items).
        ///
        /// <p>A list of cookie names.</p>
        pub fn items(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.items.unwrap_or_default();
            v.push(input.into());
            self.items = Some(v);
            self
        }
        /// <p>A list of cookie names.</p>
        pub fn set_items(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.items = input;
            self
        }
        /// Consumes the builder and constructs a [`CookieNames`](crate::model::CookieNames)
        pub fn build(self) -> crate::model::CookieNames {
            crate::model::CookieNames {
                quantity: self.quantity,
                items: self.items,
            }
        }
    }
}
impl CookieNames {
    /// Creates a new builder-style object to manufacture [`CookieNames`](crate::model::CookieNames)
    pub fn builder() -> crate::model::cookie_names::Builder {
        crate::model::cookie_names::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum OriginRequestPolicyCookieBehavior {
    #[allow(missing_docs)] // documentation missing in model
    All,
    #[allow(missing_docs)] // documentation missing in model
    None,
    #[allow(missing_docs)] // documentation missing in model
    Whitelist,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for OriginRequestPolicyCookieBehavior {
    fn from(s: &str) -> Self {
        match s {
            "all" => OriginRequestPolicyCookieBehavior::All,
            "none" => OriginRequestPolicyCookieBehavior::None,
            "whitelist" => OriginRequestPolicyCookieBehavior::Whitelist,
            other => OriginRequestPolicyCookieBehavior::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for OriginRequestPolicyCookieBehavior {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(OriginRequestPolicyCookieBehavior::from(s))
    }
}
impl OriginRequestPolicyCookieBehavior {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            OriginRequestPolicyCookieBehavior::All => "all",
            OriginRequestPolicyCookieBehavior::None => "none",
            OriginRequestPolicyCookieBehavior::Whitelist => "whitelist",
            OriginRequestPolicyCookieBehavior::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["all", "none", "whitelist"]
    }
}
impl AsRef<str> for OriginRequestPolicyCookieBehavior {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>An object that determines whether any HTTP headers (and if so, which headers) are included
/// in requests that CloudFront sends to the origin.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct OriginRequestPolicyHeadersConfig {
    /// <p>Determines whether any HTTP headers are included in requests that CloudFront sends to the origin.
    /// Valid values are:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>none</code> – HTTP headers are not included in requests that CloudFront sends to the
    /// origin. Even when this field is set to <code>none</code>, any headers that are
    /// listed in a <code>CachePolicy</code>
    /// <i>are</i> included in origin
    /// requests.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>whitelist</code> – The HTTP headers that are listed in the <code>Headers</code> type
    /// are included in requests that CloudFront sends to the origin.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>allViewer</code> – All HTTP headers in viewer requests are included in requests that
    /// CloudFront sends to the origin.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>allViewerAndWhitelistCloudFront</code> – All HTTP headers in viewer requests and the
    /// additional CloudFront headers that are listed in the <code>Headers</code> type are
    /// included in requests that CloudFront sends to the origin. The additional headers are
    /// added by CloudFront.</p>
    /// </li>
    /// </ul>
    pub header_behavior: std::option::Option<crate::model::OriginRequestPolicyHeaderBehavior>,
    /// <p>Contains a list of HTTP header names.</p>
    pub headers: std::option::Option<crate::model::Headers>,
}
impl OriginRequestPolicyHeadersConfig {
    /// <p>Determines whether any HTTP headers are included in requests that CloudFront sends to the origin.
    /// Valid values are:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>none</code> – HTTP headers are not included in requests that CloudFront sends to the
    /// origin. Even when this field is set to <code>none</code>, any headers that are
    /// listed in a <code>CachePolicy</code>
    /// <i>are</i> included in origin
    /// requests.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>whitelist</code> – The HTTP headers that are listed in the <code>Headers</code> type
    /// are included in requests that CloudFront sends to the origin.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>allViewer</code> – All HTTP headers in viewer requests are included in requests that
    /// CloudFront sends to the origin.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>allViewerAndWhitelistCloudFront</code> – All HTTP headers in viewer requests and the
    /// additional CloudFront headers that are listed in the <code>Headers</code> type are
    /// included in requests that CloudFront sends to the origin. The additional headers are
    /// added by CloudFront.</p>
    /// </li>
    /// </ul>
    pub fn header_behavior(
        &self,
    ) -> std::option::Option<&crate::model::OriginRequestPolicyHeaderBehavior> {
        self.header_behavior.as_ref()
    }
    /// <p>Contains a list of HTTP header names.</p>
    pub fn headers(&self) -> std::option::Option<&crate::model::Headers> {
        self.headers.as_ref()
    }
}
impl std::fmt::Debug for OriginRequestPolicyHeadersConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("OriginRequestPolicyHeadersConfig");
        formatter.field("header_behavior", &self.header_behavior);
        formatter.field("headers", &self.headers);
        formatter.finish()
    }
}
/// See [`OriginRequestPolicyHeadersConfig`](crate::model::OriginRequestPolicyHeadersConfig)
pub mod origin_request_policy_headers_config {
    /// A builder for [`OriginRequestPolicyHeadersConfig`](crate::model::OriginRequestPolicyHeadersConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) header_behavior:
            std::option::Option<crate::model::OriginRequestPolicyHeaderBehavior>,
        pub(crate) headers: std::option::Option<crate::model::Headers>,
    }
    impl Builder {
        /// <p>Determines whether any HTTP headers are included in requests that CloudFront sends to the origin.
        /// Valid values are:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>none</code> – HTTP headers are not included in requests that CloudFront sends to the
        /// origin. Even when this field is set to <code>none</code>, any headers that are
        /// listed in a <code>CachePolicy</code>
        /// <i>are</i> included in origin
        /// requests.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>whitelist</code> – The HTTP headers that are listed in the <code>Headers</code> type
        /// are included in requests that CloudFront sends to the origin.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>allViewer</code> – All HTTP headers in viewer requests are included in requests that
        /// CloudFront sends to the origin.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>allViewerAndWhitelistCloudFront</code> – All HTTP headers in viewer requests and the
        /// additional CloudFront headers that are listed in the <code>Headers</code> type are
        /// included in requests that CloudFront sends to the origin. The additional headers are
        /// added by CloudFront.</p>
        /// </li>
        /// </ul>
        pub fn header_behavior(
            mut self,
            input: crate::model::OriginRequestPolicyHeaderBehavior,
        ) -> Self {
            self.header_behavior = Some(input);
            self
        }
        /// <p>Determines whether any HTTP headers are included in requests that CloudFront sends to the origin.
        /// Valid values are:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>none</code> – HTTP headers are not included in requests that CloudFront sends to the
        /// origin. Even when this field is set to <code>none</code>, any headers that are
        /// listed in a <code>CachePolicy</code>
        /// <i>are</i> included in origin
        /// requests.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>whitelist</code> – The HTTP headers that are listed in the <code>Headers</code> type
        /// are included in requests that CloudFront sends to the origin.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>allViewer</code> – All HTTP headers in viewer requests are included in requests that
        /// CloudFront sends to the origin.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>allViewerAndWhitelistCloudFront</code> – All HTTP headers in viewer requests and the
        /// additional CloudFront headers that are listed in the <code>Headers</code> type are
        /// included in requests that CloudFront sends to the origin. The additional headers are
        /// added by CloudFront.</p>
        /// </li>
        /// </ul>
        pub fn set_header_behavior(
            mut self,
            input: std::option::Option<crate::model::OriginRequestPolicyHeaderBehavior>,
        ) -> Self {
            self.header_behavior = input;
            self
        }
        /// <p>Contains a list of HTTP header names.</p>
        pub fn headers(mut self, input: crate::model::Headers) -> Self {
            self.headers = Some(input);
            self
        }
        /// <p>Contains a list of HTTP header names.</p>
        pub fn set_headers(mut self, input: std::option::Option<crate::model::Headers>) -> Self {
            self.headers = input;
            self
        }
        /// Consumes the builder and constructs a [`OriginRequestPolicyHeadersConfig`](crate::model::OriginRequestPolicyHeadersConfig)
        pub fn build(self) -> crate::model::OriginRequestPolicyHeadersConfig {
            crate::model::OriginRequestPolicyHeadersConfig {
                header_behavior: self.header_behavior,
                headers: self.headers,
            }
        }
    }
}
impl OriginRequestPolicyHeadersConfig {
    /// Creates a new builder-style object to manufacture [`OriginRequestPolicyHeadersConfig`](crate::model::OriginRequestPolicyHeadersConfig)
    pub fn builder() -> crate::model::origin_request_policy_headers_config::Builder {
        crate::model::origin_request_policy_headers_config::Builder::default()
    }
}

/// <p>Contains a list of HTTP header names.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Headers {
    /// <p>The number of header names in the <code>Items</code> list.</p>
    pub quantity: std::option::Option<i32>,
    /// <p>A list of HTTP header names.</p>
    pub items: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl Headers {
    /// <p>The number of header names in the <code>Items</code> list.</p>
    pub fn quantity(&self) -> std::option::Option<i32> {
        self.quantity
    }
    /// <p>A list of HTTP header names.</p>
    pub fn items(&self) -> std::option::Option<&[std::string::String]> {
        self.items.as_deref()
    }
}
impl std::fmt::Debug for Headers {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Headers");
        formatter.field("quantity", &self.quantity);
        formatter.field("items", &self.items);
        formatter.finish()
    }
}
/// See [`Headers`](crate::model::Headers)
pub mod headers {
    /// A builder for [`Headers`](crate::model::Headers)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) quantity: std::option::Option<i32>,
        pub(crate) items: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The number of header names in the <code>Items</code> list.</p>
        pub fn quantity(mut self, input: i32) -> Self {
            self.quantity = Some(input);
            self
        }
        /// <p>The number of header names in the <code>Items</code> list.</p>
        pub fn set_quantity(mut self, input: std::option::Option<i32>) -> Self {
            self.quantity = input;
            self
        }
        /// Appends an item to `items`.
        ///
        /// To override the contents of this collection use [`set_items`](Self::set_items).
        ///
        /// <p>A list of HTTP header names.</p>
        pub fn items(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.items.unwrap_or_default();
            v.push(input.into());
            self.items = Some(v);
            self
        }
        /// <p>A list of HTTP header names.</p>
        pub fn set_items(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.items = input;
            self
        }
        /// Consumes the builder and constructs a [`Headers`](crate::model::Headers)
        pub fn build(self) -> crate::model::Headers {
            crate::model::Headers {
                quantity: self.quantity,
                items: self.items,
            }
        }
    }
}
impl Headers {
    /// Creates a new builder-style object to manufacture [`Headers`](crate::model::Headers)
    pub fn builder() -> crate::model::headers::Builder {
        crate::model::headers::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum OriginRequestPolicyHeaderBehavior {
    #[allow(missing_docs)] // documentation missing in model
    AllViewer,
    #[allow(missing_docs)] // documentation missing in model
    AllViewerAndWhitelistCloudFront,
    #[allow(missing_docs)] // documentation missing in model
    None,
    #[allow(missing_docs)] // documentation missing in model
    Whitelist,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for OriginRequestPolicyHeaderBehavior {
    fn from(s: &str) -> Self {
        match s {
            "allViewer" => OriginRequestPolicyHeaderBehavior::AllViewer,
            "allViewerAndWhitelistCloudFront" => {
                OriginRequestPolicyHeaderBehavior::AllViewerAndWhitelistCloudFront
            }
            "none" => OriginRequestPolicyHeaderBehavior::None,
            "whitelist" => OriginRequestPolicyHeaderBehavior::Whitelist,
            other => OriginRequestPolicyHeaderBehavior::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for OriginRequestPolicyHeaderBehavior {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(OriginRequestPolicyHeaderBehavior::from(s))
    }
}
impl OriginRequestPolicyHeaderBehavior {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            OriginRequestPolicyHeaderBehavior::AllViewer => "allViewer",
            OriginRequestPolicyHeaderBehavior::AllViewerAndWhitelistCloudFront => {
                "allViewerAndWhitelistCloudFront"
            }
            OriginRequestPolicyHeaderBehavior::None => "none",
            OriginRequestPolicyHeaderBehavior::Whitelist => "whitelist",
            OriginRequestPolicyHeaderBehavior::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "allViewer",
            "allViewerAndWhitelistCloudFront",
            "none",
            "whitelist",
        ]
    }
}
impl AsRef<str> for OriginRequestPolicyHeaderBehavior {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>A key group.</p>
/// <p>A key group contains a list of public keys that you can use with <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html">CloudFront signed URLs and signed cookies</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct KeyGroup {
    /// <p>The identifier for the key group.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The date and time when the key group was last modified.</p>
    pub last_modified_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The key group configuration.</p>
    pub key_group_config: std::option::Option<crate::model::KeyGroupConfig>,
}
impl KeyGroup {
    /// <p>The identifier for the key group.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The date and time when the key group was last modified.</p>
    pub fn last_modified_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_modified_time.as_ref()
    }
    /// <p>The key group configuration.</p>
    pub fn key_group_config(&self) -> std::option::Option<&crate::model::KeyGroupConfig> {
        self.key_group_config.as_ref()
    }
}
impl std::fmt::Debug for KeyGroup {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("KeyGroup");
        formatter.field("id", &self.id);
        formatter.field("last_modified_time", &self.last_modified_time);
        formatter.field("key_group_config", &self.key_group_config);
        formatter.finish()
    }
}
/// See [`KeyGroup`](crate::model::KeyGroup)
pub mod key_group {
    /// A builder for [`KeyGroup`](crate::model::KeyGroup)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) last_modified_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) key_group_config: std::option::Option<crate::model::KeyGroupConfig>,
    }
    impl Builder {
        /// <p>The identifier for the key group.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The identifier for the key group.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The date and time when the key group was last modified.</p>
        pub fn last_modified_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_modified_time = Some(input);
            self
        }
        /// <p>The date and time when the key group was last modified.</p>
        pub fn set_last_modified_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_modified_time = input;
            self
        }
        /// <p>The key group configuration.</p>
        pub fn key_group_config(mut self, input: crate::model::KeyGroupConfig) -> Self {
            self.key_group_config = Some(input);
            self
        }
        /// <p>The key group configuration.</p>
        pub fn set_key_group_config(
            mut self,
            input: std::option::Option<crate::model::KeyGroupConfig>,
        ) -> Self {
            self.key_group_config = input;
            self
        }
        /// Consumes the builder and constructs a [`KeyGroup`](crate::model::KeyGroup)
        pub fn build(self) -> crate::model::KeyGroup {
            crate::model::KeyGroup {
                id: self.id,
                last_modified_time: self.last_modified_time,
                key_group_config: self.key_group_config,
            }
        }
    }
}
impl KeyGroup {
    /// Creates a new builder-style object to manufacture [`KeyGroup`](crate::model::KeyGroup)
    pub fn builder() -> crate::model::key_group::Builder {
        crate::model::key_group::Builder::default()
    }
}

/// <p>A key group configuration.</p>
/// <p>A key group contains a list of public keys that you can use with <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html">CloudFront signed URLs and signed cookies</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct KeyGroupConfig {
    /// <p>A name to identify the key group.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>A list of the identifiers of the public keys in the key group.</p>
    pub items: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>A comment to describe the key group. The comment cannot be longer than 128
    /// characters.</p>
    pub comment: std::option::Option<std::string::String>,
}
impl KeyGroupConfig {
    /// <p>A name to identify the key group.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>A list of the identifiers of the public keys in the key group.</p>
    pub fn items(&self) -> std::option::Option<&[std::string::String]> {
        self.items.as_deref()
    }
    /// <p>A comment to describe the key group. The comment cannot be longer than 128
    /// characters.</p>
    pub fn comment(&self) -> std::option::Option<&str> {
        self.comment.as_deref()
    }
}
impl std::fmt::Debug for KeyGroupConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("KeyGroupConfig");
        formatter.field("name", &self.name);
        formatter.field("items", &self.items);
        formatter.field("comment", &self.comment);
        formatter.finish()
    }
}
/// See [`KeyGroupConfig`](crate::model::KeyGroupConfig)
pub mod key_group_config {
    /// A builder for [`KeyGroupConfig`](crate::model::KeyGroupConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) items: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) comment: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A name to identify the key group.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>A name to identify the key group.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Appends an item to `items`.
        ///
        /// To override the contents of this collection use [`set_items`](Self::set_items).
        ///
        /// <p>A list of the identifiers of the public keys in the key group.</p>
        pub fn items(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.items.unwrap_or_default();
            v.push(input.into());
            self.items = Some(v);
            self
        }
        /// <p>A list of the identifiers of the public keys in the key group.</p>
        pub fn set_items(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.items = input;
            self
        }
        /// <p>A comment to describe the key group. The comment cannot be longer than 128
        /// characters.</p>
        pub fn comment(mut self, input: impl Into<std::string::String>) -> Self {
            self.comment = Some(input.into());
            self
        }
        /// <p>A comment to describe the key group. The comment cannot be longer than 128
        /// characters.</p>
        pub fn set_comment(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.comment = input;
            self
        }
        /// Consumes the builder and constructs a [`KeyGroupConfig`](crate::model::KeyGroupConfig)
        pub fn build(self) -> crate::model::KeyGroupConfig {
            crate::model::KeyGroupConfig {
                name: self.name,
                items: self.items,
                comment: self.comment,
            }
        }
    }
}
impl KeyGroupConfig {
    /// Creates a new builder-style object to manufacture [`KeyGroupConfig`](crate::model::KeyGroupConfig)
    pub fn builder() -> crate::model::key_group_config::Builder {
        crate::model::key_group_config::Builder::default()
    }
}

/// <p>Contains configuration information and metadata about a CloudFront function.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct FunctionSummary {
    /// <p>The name of the CloudFront function.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The status of the CloudFront function.</p>
    pub status: std::option::Option<std::string::String>,
    /// <p>Contains configuration information about a CloudFront function.</p>
    pub function_config: std::option::Option<crate::model::FunctionConfig>,
    /// <p>Contains metadata about a CloudFront function.</p>
    pub function_metadata: std::option::Option<crate::model::FunctionMetadata>,
}
impl FunctionSummary {
    /// <p>The name of the CloudFront function.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The status of the CloudFront function.</p>
    pub fn status(&self) -> std::option::Option<&str> {
        self.status.as_deref()
    }
    /// <p>Contains configuration information about a CloudFront function.</p>
    pub fn function_config(&self) -> std::option::Option<&crate::model::FunctionConfig> {
        self.function_config.as_ref()
    }
    /// <p>Contains metadata about a CloudFront function.</p>
    pub fn function_metadata(&self) -> std::option::Option<&crate::model::FunctionMetadata> {
        self.function_metadata.as_ref()
    }
}
impl std::fmt::Debug for FunctionSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("FunctionSummary");
        formatter.field("name", &self.name);
        formatter.field("status", &self.status);
        formatter.field("function_config", &self.function_config);
        formatter.field("function_metadata", &self.function_metadata);
        formatter.finish()
    }
}
/// See [`FunctionSummary`](crate::model::FunctionSummary)
pub mod function_summary {
    /// A builder for [`FunctionSummary`](crate::model::FunctionSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<std::string::String>,
        pub(crate) function_config: std::option::Option<crate::model::FunctionConfig>,
        pub(crate) function_metadata: std::option::Option<crate::model::FunctionMetadata>,
    }
    impl Builder {
        /// <p>The name of the CloudFront function.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the CloudFront function.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The status of the CloudFront function.</p>
        pub fn status(mut self, input: impl Into<std::string::String>) -> Self {
            self.status = Some(input.into());
            self
        }
        /// <p>The status of the CloudFront function.</p>
        pub fn set_status(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.status = input;
            self
        }
        /// <p>Contains configuration information about a CloudFront function.</p>
        pub fn function_config(mut self, input: crate::model::FunctionConfig) -> Self {
            self.function_config = Some(input);
            self
        }
        /// <p>Contains configuration information about a CloudFront function.</p>
        pub fn set_function_config(
            mut self,
            input: std::option::Option<crate::model::FunctionConfig>,
        ) -> Self {
            self.function_config = input;
            self
        }
        /// <p>Contains metadata about a CloudFront function.</p>
        pub fn function_metadata(mut self, input: crate::model::FunctionMetadata) -> Self {
            self.function_metadata = Some(input);
            self
        }
        /// <p>Contains metadata about a CloudFront function.</p>
        pub fn set_function_metadata(
            mut self,
            input: std::option::Option<crate::model::FunctionMetadata>,
        ) -> Self {
            self.function_metadata = input;
            self
        }
        /// Consumes the builder and constructs a [`FunctionSummary`](crate::model::FunctionSummary)
        pub fn build(self) -> crate::model::FunctionSummary {
            crate::model::FunctionSummary {
                name: self.name,
                status: self.status,
                function_config: self.function_config,
                function_metadata: self.function_metadata,
            }
        }
    }
}
impl FunctionSummary {
    /// Creates a new builder-style object to manufacture [`FunctionSummary`](crate::model::FunctionSummary)
    pub fn builder() -> crate::model::function_summary::Builder {
        crate::model::function_summary::Builder::default()
    }
}

/// <p>Contains metadata about a CloudFront function.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct FunctionMetadata {
    /// <p>The Amazon Resource Name (ARN) of the function. The ARN uniquely identifies the
    /// function.</p>
    pub function_arn: std::option::Option<std::string::String>,
    /// <p>The stage that the function is in, either <code>DEVELOPMENT</code> or
    /// <code>LIVE</code>.</p>
    /// <p>When a function is in the <code>DEVELOPMENT</code> stage, you can test the function with
    /// <code>TestFunction</code>, and update it with <code>UpdateFunction</code>.</p>
    /// <p>When a function is in the <code>LIVE</code> stage, you can attach the function to a
    /// distribution’s cache behavior, using the function’s ARN.</p>
    pub stage: std::option::Option<crate::model::FunctionStage>,
    /// <p>The date and time when the function was created.</p>
    pub created_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The date and time when the function was most recently updated.</p>
    pub last_modified_time: std::option::Option<aws_smithy_types::DateTime>,
}
impl FunctionMetadata {
    /// <p>The Amazon Resource Name (ARN) of the function. The ARN uniquely identifies the
    /// function.</p>
    pub fn function_arn(&self) -> std::option::Option<&str> {
        self.function_arn.as_deref()
    }
    /// <p>The stage that the function is in, either <code>DEVELOPMENT</code> or
    /// <code>LIVE</code>.</p>
    /// <p>When a function is in the <code>DEVELOPMENT</code> stage, you can test the function with
    /// <code>TestFunction</code>, and update it with <code>UpdateFunction</code>.</p>
    /// <p>When a function is in the <code>LIVE</code> stage, you can attach the function to a
    /// distribution’s cache behavior, using the function’s ARN.</p>
    pub fn stage(&self) -> std::option::Option<&crate::model::FunctionStage> {
        self.stage.as_ref()
    }
    /// <p>The date and time when the function was created.</p>
    pub fn created_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.created_time.as_ref()
    }
    /// <p>The date and time when the function was most recently updated.</p>
    pub fn last_modified_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_modified_time.as_ref()
    }
}
impl std::fmt::Debug for FunctionMetadata {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("FunctionMetadata");
        formatter.field("function_arn", &self.function_arn);
        formatter.field("stage", &self.stage);
        formatter.field("created_time", &self.created_time);
        formatter.field("last_modified_time", &self.last_modified_time);
        formatter.finish()
    }
}
/// See [`FunctionMetadata`](crate::model::FunctionMetadata)
pub mod function_metadata {
    /// A builder for [`FunctionMetadata`](crate::model::FunctionMetadata)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) function_arn: std::option::Option<std::string::String>,
        pub(crate) stage: std::option::Option<crate::model::FunctionStage>,
        pub(crate) created_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) last_modified_time: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the function. The ARN uniquely identifies the
        /// function.</p>
        pub fn function_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.function_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the function. The ARN uniquely identifies the
        /// function.</p>
        pub fn set_function_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.function_arn = input;
            self
        }
        /// <p>The stage that the function is in, either <code>DEVELOPMENT</code> or
        /// <code>LIVE</code>.</p>
        /// <p>When a function is in the <code>DEVELOPMENT</code> stage, you can test the function with
        /// <code>TestFunction</code>, and update it with <code>UpdateFunction</code>.</p>
        /// <p>When a function is in the <code>LIVE</code> stage, you can attach the function to a
        /// distribution’s cache behavior, using the function’s ARN.</p>
        pub fn stage(mut self, input: crate::model::FunctionStage) -> Self {
            self.stage = Some(input);
            self
        }
        /// <p>The stage that the function is in, either <code>DEVELOPMENT</code> or
        /// <code>LIVE</code>.</p>
        /// <p>When a function is in the <code>DEVELOPMENT</code> stage, you can test the function with
        /// <code>TestFunction</code>, and update it with <code>UpdateFunction</code>.</p>
        /// <p>When a function is in the <code>LIVE</code> stage, you can attach the function to a
        /// distribution’s cache behavior, using the function’s ARN.</p>
        pub fn set_stage(
            mut self,
            input: std::option::Option<crate::model::FunctionStage>,
        ) -> Self {
            self.stage = input;
            self
        }
        /// <p>The date and time when the function was created.</p>
        pub fn created_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.created_time = Some(input);
            self
        }
        /// <p>The date and time when the function was created.</p>
        pub fn set_created_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.created_time = input;
            self
        }
        /// <p>The date and time when the function was most recently updated.</p>
        pub fn last_modified_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_modified_time = Some(input);
            self
        }
        /// <p>The date and time when the function was most recently updated.</p>
        pub fn set_last_modified_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_modified_time = input;
            self
        }
        /// Consumes the builder and constructs a [`FunctionMetadata`](crate::model::FunctionMetadata)
        pub fn build(self) -> crate::model::FunctionMetadata {
            crate::model::FunctionMetadata {
                function_arn: self.function_arn,
                stage: self.stage,
                created_time: self.created_time,
                last_modified_time: self.last_modified_time,
            }
        }
    }
}
impl FunctionMetadata {
    /// Creates a new builder-style object to manufacture [`FunctionMetadata`](crate::model::FunctionMetadata)
    pub fn builder() -> crate::model::function_metadata::Builder {
        crate::model::function_metadata::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum FunctionStage {
    #[allow(missing_docs)] // documentation missing in model
    Development,
    #[allow(missing_docs)] // documentation missing in model
    Live,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for FunctionStage {
    fn from(s: &str) -> Self {
        match s {
            "DEVELOPMENT" => FunctionStage::Development,
            "LIVE" => FunctionStage::Live,
            other => FunctionStage::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for FunctionStage {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(FunctionStage::from(s))
    }
}
impl FunctionStage {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            FunctionStage::Development => "DEVELOPMENT",
            FunctionStage::Live => "LIVE",
            FunctionStage::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["DEVELOPMENT", "LIVE"]
    }
}
impl AsRef<str> for FunctionStage {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Contains configuration information about a CloudFront function.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct FunctionConfig {
    /// <p>A comment to describe the function.</p>
    pub comment: std::option::Option<std::string::String>,
    /// <p>The function’s runtime environment. The only valid value is
    /// <code>cloudfront-js-1.0</code>.</p>
    pub runtime: std::option::Option<crate::model::FunctionRuntime>,
}
impl FunctionConfig {
    /// <p>A comment to describe the function.</p>
    pub fn comment(&self) -> std::option::Option<&str> {
        self.comment.as_deref()
    }
    /// <p>The function’s runtime environment. The only valid value is
    /// <code>cloudfront-js-1.0</code>.</p>
    pub fn runtime(&self) -> std::option::Option<&crate::model::FunctionRuntime> {
        self.runtime.as_ref()
    }
}
impl std::fmt::Debug for FunctionConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("FunctionConfig");
        formatter.field("comment", &self.comment);
        formatter.field("runtime", &self.runtime);
        formatter.finish()
    }
}
/// See [`FunctionConfig`](crate::model::FunctionConfig)
pub mod function_config {
    /// A builder for [`FunctionConfig`](crate::model::FunctionConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) comment: std::option::Option<std::string::String>,
        pub(crate) runtime: std::option::Option<crate::model::FunctionRuntime>,
    }
    impl Builder {
        /// <p>A comment to describe the function.</p>
        pub fn comment(mut self, input: impl Into<std::string::String>) -> Self {
            self.comment = Some(input.into());
            self
        }
        /// <p>A comment to describe the function.</p>
        pub fn set_comment(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.comment = input;
            self
        }
        /// <p>The function’s runtime environment. The only valid value is
        /// <code>cloudfront-js-1.0</code>.</p>
        pub fn runtime(mut self, input: crate::model::FunctionRuntime) -> Self {
            self.runtime = Some(input);
            self
        }
        /// <p>The function’s runtime environment. The only valid value is
        /// <code>cloudfront-js-1.0</code>.</p>
        pub fn set_runtime(
            mut self,
            input: std::option::Option<crate::model::FunctionRuntime>,
        ) -> Self {
            self.runtime = input;
            self
        }
        /// Consumes the builder and constructs a [`FunctionConfig`](crate::model::FunctionConfig)
        pub fn build(self) -> crate::model::FunctionConfig {
            crate::model::FunctionConfig {
                comment: self.comment,
                runtime: self.runtime,
            }
        }
    }
}
impl FunctionConfig {
    /// Creates a new builder-style object to manufacture [`FunctionConfig`](crate::model::FunctionConfig)
    pub fn builder() -> crate::model::function_config::Builder {
        crate::model::function_config::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum FunctionRuntime {
    #[allow(missing_docs)] // documentation missing in model
    CloudfrontJs10,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for FunctionRuntime {
    fn from(s: &str) -> Self {
        match s {
            "cloudfront-js-1.0" => FunctionRuntime::CloudfrontJs10,
            other => FunctionRuntime::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for FunctionRuntime {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(FunctionRuntime::from(s))
    }
}
impl FunctionRuntime {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            FunctionRuntime::CloudfrontJs10 => "cloudfront-js-1.0",
            FunctionRuntime::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["cloudfront-js-1.0"]
    }
}
impl AsRef<str> for FunctionRuntime {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>A complex data type for field-level encryption profiles.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct FieldLevelEncryptionProfile {
    /// <p>The ID for a field-level encryption profile configuration which includes a set of profiles that specify certain
    /// selected data fields to be encrypted by specific public keys.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The last time the field-level encryption profile was updated.</p>
    pub last_modified_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>A complex data type that includes the profile name and the encryption entities for the field-level encryption profile.</p>
    pub field_level_encryption_profile_config:
        std::option::Option<crate::model::FieldLevelEncryptionProfileConfig>,
}
impl FieldLevelEncryptionProfile {
    /// <p>The ID for a field-level encryption profile configuration which includes a set of profiles that specify certain
    /// selected data fields to be encrypted by specific public keys.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The last time the field-level encryption profile was updated.</p>
    pub fn last_modified_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_modified_time.as_ref()
    }
    /// <p>A complex data type that includes the profile name and the encryption entities for the field-level encryption profile.</p>
    pub fn field_level_encryption_profile_config(
        &self,
    ) -> std::option::Option<&crate::model::FieldLevelEncryptionProfileConfig> {
        self.field_level_encryption_profile_config.as_ref()
    }
}
impl std::fmt::Debug for FieldLevelEncryptionProfile {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("FieldLevelEncryptionProfile");
        formatter.field("id", &self.id);
        formatter.field("last_modified_time", &self.last_modified_time);
        formatter.field(
            "field_level_encryption_profile_config",
            &self.field_level_encryption_profile_config,
        );
        formatter.finish()
    }
}
/// See [`FieldLevelEncryptionProfile`](crate::model::FieldLevelEncryptionProfile)
pub mod field_level_encryption_profile {
    /// A builder for [`FieldLevelEncryptionProfile`](crate::model::FieldLevelEncryptionProfile)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) last_modified_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) field_level_encryption_profile_config:
            std::option::Option<crate::model::FieldLevelEncryptionProfileConfig>,
    }
    impl Builder {
        /// <p>The ID for a field-level encryption profile configuration which includes a set of profiles that specify certain
        /// selected data fields to be encrypted by specific public keys.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The ID for a field-level encryption profile configuration which includes a set of profiles that specify certain
        /// selected data fields to be encrypted by specific public keys.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The last time the field-level encryption profile was updated.</p>
        pub fn last_modified_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_modified_time = Some(input);
            self
        }
        /// <p>The last time the field-level encryption profile was updated.</p>
        pub fn set_last_modified_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_modified_time = input;
            self
        }
        /// <p>A complex data type that includes the profile name and the encryption entities for the field-level encryption profile.</p>
        pub fn field_level_encryption_profile_config(
            mut self,
            input: crate::model::FieldLevelEncryptionProfileConfig,
        ) -> Self {
            self.field_level_encryption_profile_config = Some(input);
            self
        }
        /// <p>A complex data type that includes the profile name and the encryption entities for the field-level encryption profile.</p>
        pub fn set_field_level_encryption_profile_config(
            mut self,
            input: std::option::Option<crate::model::FieldLevelEncryptionProfileConfig>,
        ) -> Self {
            self.field_level_encryption_profile_config = input;
            self
        }
        /// Consumes the builder and constructs a [`FieldLevelEncryptionProfile`](crate::model::FieldLevelEncryptionProfile)
        pub fn build(self) -> crate::model::FieldLevelEncryptionProfile {
            crate::model::FieldLevelEncryptionProfile {
                id: self.id,
                last_modified_time: self.last_modified_time,
                field_level_encryption_profile_config: self.field_level_encryption_profile_config,
            }
        }
    }
}
impl FieldLevelEncryptionProfile {
    /// Creates a new builder-style object to manufacture [`FieldLevelEncryptionProfile`](crate::model::FieldLevelEncryptionProfile)
    pub fn builder() -> crate::model::field_level_encryption_profile::Builder {
        crate::model::field_level_encryption_profile::Builder::default()
    }
}

/// <p>A complex data type of profiles for the field-level encryption.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct FieldLevelEncryptionProfileConfig {
    /// <p>Profile name for the field-level encryption profile.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>A unique number that ensures that the request can't be replayed.</p>
    pub caller_reference: std::option::Option<std::string::String>,
    /// <p>An optional comment for the field-level encryption profile. The comment cannot be longer
    /// than 128 characters.</p>
    pub comment: std::option::Option<std::string::String>,
    /// <p>A complex data type of encryption entities for the field-level encryption profile that include the public key ID, provider, and
    /// field patterns for specifying which fields to encrypt with this key.</p>
    pub encryption_entities: std::option::Option<crate::model::EncryptionEntities>,
}
impl FieldLevelEncryptionProfileConfig {
    /// <p>Profile name for the field-level encryption profile.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>A unique number that ensures that the request can't be replayed.</p>
    pub fn caller_reference(&self) -> std::option::Option<&str> {
        self.caller_reference.as_deref()
    }
    /// <p>An optional comment for the field-level encryption profile. The comment cannot be longer
    /// than 128 characters.</p>
    pub fn comment(&self) -> std::option::Option<&str> {
        self.comment.as_deref()
    }
    /// <p>A complex data type of encryption entities for the field-level encryption profile that include the public key ID, provider, and
    /// field patterns for specifying which fields to encrypt with this key.</p>
    pub fn encryption_entities(&self) -> std::option::Option<&crate::model::EncryptionEntities> {
        self.encryption_entities.as_ref()
    }
}
impl std::fmt::Debug for FieldLevelEncryptionProfileConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("FieldLevelEncryptionProfileConfig");
        formatter.field("name", &self.name);
        formatter.field("caller_reference", &self.caller_reference);
        formatter.field("comment", &self.comment);
        formatter.field("encryption_entities", &self.encryption_entities);
        formatter.finish()
    }
}
/// See [`FieldLevelEncryptionProfileConfig`](crate::model::FieldLevelEncryptionProfileConfig)
pub mod field_level_encryption_profile_config {
    /// A builder for [`FieldLevelEncryptionProfileConfig`](crate::model::FieldLevelEncryptionProfileConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) caller_reference: std::option::Option<std::string::String>,
        pub(crate) comment: std::option::Option<std::string::String>,
        pub(crate) encryption_entities: std::option::Option<crate::model::EncryptionEntities>,
    }
    impl Builder {
        /// <p>Profile name for the field-level encryption profile.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>Profile name for the field-level encryption profile.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>A unique number that ensures that the request can't be replayed.</p>
        pub fn caller_reference(mut self, input: impl Into<std::string::String>) -> Self {
            self.caller_reference = Some(input.into());
            self
        }
        /// <p>A unique number that ensures that the request can't be replayed.</p>
        pub fn set_caller_reference(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.caller_reference = input;
            self
        }
        /// <p>An optional comment for the field-level encryption profile. The comment cannot be longer
        /// than 128 characters.</p>
        pub fn comment(mut self, input: impl Into<std::string::String>) -> Self {
            self.comment = Some(input.into());
            self
        }
        /// <p>An optional comment for the field-level encryption profile. The comment cannot be longer
        /// than 128 characters.</p>
        pub fn set_comment(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.comment = input;
            self
        }
        /// <p>A complex data type of encryption entities for the field-level encryption profile that include the public key ID, provider, and
        /// field patterns for specifying which fields to encrypt with this key.</p>
        pub fn encryption_entities(mut self, input: crate::model::EncryptionEntities) -> Self {
            self.encryption_entities = Some(input);
            self
        }
        /// <p>A complex data type of encryption entities for the field-level encryption profile that include the public key ID, provider, and
        /// field patterns for specifying which fields to encrypt with this key.</p>
        pub fn set_encryption_entities(
            mut self,
            input: std::option::Option<crate::model::EncryptionEntities>,
        ) -> Self {
            self.encryption_entities = input;
            self
        }
        /// Consumes the builder and constructs a [`FieldLevelEncryptionProfileConfig`](crate::model::FieldLevelEncryptionProfileConfig)
        pub fn build(self) -> crate::model::FieldLevelEncryptionProfileConfig {
            crate::model::FieldLevelEncryptionProfileConfig {
                name: self.name,
                caller_reference: self.caller_reference,
                comment: self.comment,
                encryption_entities: self.encryption_entities,
            }
        }
    }
}
impl FieldLevelEncryptionProfileConfig {
    /// Creates a new builder-style object to manufacture [`FieldLevelEncryptionProfileConfig`](crate::model::FieldLevelEncryptionProfileConfig)
    pub fn builder() -> crate::model::field_level_encryption_profile_config::Builder {
        crate::model::field_level_encryption_profile_config::Builder::default()
    }
}

/// <p>Complex data type for field-level encryption profiles that includes all of the encryption entities. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EncryptionEntities {
    /// <p>Number of field pattern items in a field-level encryption content type-profile mapping. </p>
    pub quantity: std::option::Option<i32>,
    /// <p>An array of field patterns in a field-level encryption content type-profile mapping. </p>
    pub items: std::option::Option<std::vec::Vec<crate::model::EncryptionEntity>>,
}
impl EncryptionEntities {
    /// <p>Number of field pattern items in a field-level encryption content type-profile mapping. </p>
    pub fn quantity(&self) -> std::option::Option<i32> {
        self.quantity
    }
    /// <p>An array of field patterns in a field-level encryption content type-profile mapping. </p>
    pub fn items(&self) -> std::option::Option<&[crate::model::EncryptionEntity]> {
        self.items.as_deref()
    }
}
impl std::fmt::Debug for EncryptionEntities {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EncryptionEntities");
        formatter.field("quantity", &self.quantity);
        formatter.field("items", &self.items);
        formatter.finish()
    }
}
/// See [`EncryptionEntities`](crate::model::EncryptionEntities)
pub mod encryption_entities {
    /// A builder for [`EncryptionEntities`](crate::model::EncryptionEntities)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) quantity: std::option::Option<i32>,
        pub(crate) items: std::option::Option<std::vec::Vec<crate::model::EncryptionEntity>>,
    }
    impl Builder {
        /// <p>Number of field pattern items in a field-level encryption content type-profile mapping. </p>
        pub fn quantity(mut self, input: i32) -> Self {
            self.quantity = Some(input);
            self
        }
        /// <p>Number of field pattern items in a field-level encryption content type-profile mapping. </p>
        pub fn set_quantity(mut self, input: std::option::Option<i32>) -> Self {
            self.quantity = input;
            self
        }
        /// Appends an item to `items`.
        ///
        /// To override the contents of this collection use [`set_items`](Self::set_items).
        ///
        /// <p>An array of field patterns in a field-level encryption content type-profile mapping. </p>
        pub fn items(mut self, input: impl Into<crate::model::EncryptionEntity>) -> Self {
            let mut v = self.items.unwrap_or_default();
            v.push(input.into());
            self.items = Some(v);
            self
        }
        /// <p>An array of field patterns in a field-level encryption content type-profile mapping. </p>
        pub fn set_items(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::EncryptionEntity>>,
        ) -> Self {
            self.items = input;
            self
        }
        /// Consumes the builder and constructs a [`EncryptionEntities`](crate::model::EncryptionEntities)
        pub fn build(self) -> crate::model::EncryptionEntities {
            crate::model::EncryptionEntities {
                quantity: self.quantity,
                items: self.items,
            }
        }
    }
}
impl EncryptionEntities {
    /// Creates a new builder-style object to manufacture [`EncryptionEntities`](crate::model::EncryptionEntities)
    pub fn builder() -> crate::model::encryption_entities::Builder {
        crate::model::encryption_entities::Builder::default()
    }
}

/// <p>Complex data type for field-level encryption profiles that includes the encryption key and field pattern specifications. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EncryptionEntity {
    /// <p>The public key associated with a set of field-level encryption patterns, to be used when encrypting the fields that match
    /// the patterns. </p>
    pub public_key_id: std::option::Option<std::string::String>,
    /// <p>The provider associated with the public key being used for encryption. This value must also be provided with the private key
    /// for applications to be able to decrypt data.</p>
    pub provider_id: std::option::Option<std::string::String>,
    /// <p>Field patterns in a field-level encryption content type profile specify the fields that you want to be encrypted. You can provide the
    /// full field name, or any beginning characters followed by a wildcard (*). You can't overlap field patterns. For example, you can't have
    /// both ABC* and AB*. Note that field patterns are case-sensitive. </p>
    pub field_patterns: std::option::Option<crate::model::FieldPatterns>,
}
impl EncryptionEntity {
    /// <p>The public key associated with a set of field-level encryption patterns, to be used when encrypting the fields that match
    /// the patterns. </p>
    pub fn public_key_id(&self) -> std::option::Option<&str> {
        self.public_key_id.as_deref()
    }
    /// <p>The provider associated with the public key being used for encryption. This value must also be provided with the private key
    /// for applications to be able to decrypt data.</p>
    pub fn provider_id(&self) -> std::option::Option<&str> {
        self.provider_id.as_deref()
    }
    /// <p>Field patterns in a field-level encryption content type profile specify the fields that you want to be encrypted. You can provide the
    /// full field name, or any beginning characters followed by a wildcard (*). You can't overlap field patterns. For example, you can't have
    /// both ABC* and AB*. Note that field patterns are case-sensitive. </p>
    pub fn field_patterns(&self) -> std::option::Option<&crate::model::FieldPatterns> {
        self.field_patterns.as_ref()
    }
}
impl std::fmt::Debug for EncryptionEntity {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EncryptionEntity");
        formatter.field("public_key_id", &self.public_key_id);
        formatter.field("provider_id", &self.provider_id);
        formatter.field("field_patterns", &self.field_patterns);
        formatter.finish()
    }
}
/// See [`EncryptionEntity`](crate::model::EncryptionEntity)
pub mod encryption_entity {
    /// A builder for [`EncryptionEntity`](crate::model::EncryptionEntity)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) public_key_id: std::option::Option<std::string::String>,
        pub(crate) provider_id: std::option::Option<std::string::String>,
        pub(crate) field_patterns: std::option::Option<crate::model::FieldPatterns>,
    }
    impl Builder {
        /// <p>The public key associated with a set of field-level encryption patterns, to be used when encrypting the fields that match
        /// the patterns. </p>
        pub fn public_key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.public_key_id = Some(input.into());
            self
        }
        /// <p>The public key associated with a set of field-level encryption patterns, to be used when encrypting the fields that match
        /// the patterns. </p>
        pub fn set_public_key_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.public_key_id = input;
            self
        }
        /// <p>The provider associated with the public key being used for encryption. This value must also be provided with the private key
        /// for applications to be able to decrypt data.</p>
        pub fn provider_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.provider_id = Some(input.into());
            self
        }
        /// <p>The provider associated with the public key being used for encryption. This value must also be provided with the private key
        /// for applications to be able to decrypt data.</p>
        pub fn set_provider_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.provider_id = input;
            self
        }
        /// <p>Field patterns in a field-level encryption content type profile specify the fields that you want to be encrypted. You can provide the
        /// full field name, or any beginning characters followed by a wildcard (*). You can't overlap field patterns. For example, you can't have
        /// both ABC* and AB*. Note that field patterns are case-sensitive. </p>
        pub fn field_patterns(mut self, input: crate::model::FieldPatterns) -> Self {
            self.field_patterns = Some(input);
            self
        }
        /// <p>Field patterns in a field-level encryption content type profile specify the fields that you want to be encrypted. You can provide the
        /// full field name, or any beginning characters followed by a wildcard (*). You can't overlap field patterns. For example, you can't have
        /// both ABC* and AB*. Note that field patterns are case-sensitive. </p>
        pub fn set_field_patterns(
            mut self,
            input: std::option::Option<crate::model::FieldPatterns>,
        ) -> Self {
            self.field_patterns = input;
            self
        }
        /// Consumes the builder and constructs a [`EncryptionEntity`](crate::model::EncryptionEntity)
        pub fn build(self) -> crate::model::EncryptionEntity {
            crate::model::EncryptionEntity {
                public_key_id: self.public_key_id,
                provider_id: self.provider_id,
                field_patterns: self.field_patterns,
            }
        }
    }
}
impl EncryptionEntity {
    /// Creates a new builder-style object to manufacture [`EncryptionEntity`](crate::model::EncryptionEntity)
    pub fn builder() -> crate::model::encryption_entity::Builder {
        crate::model::encryption_entity::Builder::default()
    }
}

/// <p>A complex data type that includes the field patterns to match for field-level encryption.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct FieldPatterns {
    /// <p>The number of field-level encryption field patterns.</p>
    pub quantity: std::option::Option<i32>,
    /// <p>An array of the field-level encryption field patterns.</p>
    pub items: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl FieldPatterns {
    /// <p>The number of field-level encryption field patterns.</p>
    pub fn quantity(&self) -> std::option::Option<i32> {
        self.quantity
    }
    /// <p>An array of the field-level encryption field patterns.</p>
    pub fn items(&self) -> std::option::Option<&[std::string::String]> {
        self.items.as_deref()
    }
}
impl std::fmt::Debug for FieldPatterns {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("FieldPatterns");
        formatter.field("quantity", &self.quantity);
        formatter.field("items", &self.items);
        formatter.finish()
    }
}
/// See [`FieldPatterns`](crate::model::FieldPatterns)
pub mod field_patterns {
    /// A builder for [`FieldPatterns`](crate::model::FieldPatterns)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) quantity: std::option::Option<i32>,
        pub(crate) items: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The number of field-level encryption field patterns.</p>
        pub fn quantity(mut self, input: i32) -> Self {
            self.quantity = Some(input);
            self
        }
        /// <p>The number of field-level encryption field patterns.</p>
        pub fn set_quantity(mut self, input: std::option::Option<i32>) -> Self {
            self.quantity = input;
            self
        }
        /// Appends an item to `items`.
        ///
        /// To override the contents of this collection use [`set_items`](Self::set_items).
        ///
        /// <p>An array of the field-level encryption field patterns.</p>
        pub fn items(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.items.unwrap_or_default();
            v.push(input.into());
            self.items = Some(v);
            self
        }
        /// <p>An array of the field-level encryption field patterns.</p>
        pub fn set_items(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.items = input;
            self
        }
        /// Consumes the builder and constructs a [`FieldPatterns`](crate::model::FieldPatterns)
        pub fn build(self) -> crate::model::FieldPatterns {
            crate::model::FieldPatterns {
                quantity: self.quantity,
                items: self.items,
            }
        }
    }
}
impl FieldPatterns {
    /// Creates a new builder-style object to manufacture [`FieldPatterns`](crate::model::FieldPatterns)
    pub fn builder() -> crate::model::field_patterns::Builder {
        crate::model::field_patterns::Builder::default()
    }
}

/// <p>A complex data type that includes the profile configurations and other options specified for field-level encryption. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct FieldLevelEncryption {
    /// <p>The configuration ID for a field-level encryption configuration which includes a set of profiles that specify certain
    /// selected data fields to be encrypted by specific public keys.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The last time the field-level encryption configuration was changed. </p>
    pub last_modified_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>A complex data type that includes the profile configurations specified for field-level encryption. </p>
    pub field_level_encryption_config:
        std::option::Option<crate::model::FieldLevelEncryptionConfig>,
}
impl FieldLevelEncryption {
    /// <p>The configuration ID for a field-level encryption configuration which includes a set of profiles that specify certain
    /// selected data fields to be encrypted by specific public keys.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The last time the field-level encryption configuration was changed. </p>
    pub fn last_modified_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_modified_time.as_ref()
    }
    /// <p>A complex data type that includes the profile configurations specified for field-level encryption. </p>
    pub fn field_level_encryption_config(
        &self,
    ) -> std::option::Option<&crate::model::FieldLevelEncryptionConfig> {
        self.field_level_encryption_config.as_ref()
    }
}
impl std::fmt::Debug for FieldLevelEncryption {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("FieldLevelEncryption");
        formatter.field("id", &self.id);
        formatter.field("last_modified_time", &self.last_modified_time);
        formatter.field(
            "field_level_encryption_config",
            &self.field_level_encryption_config,
        );
        formatter.finish()
    }
}
/// See [`FieldLevelEncryption`](crate::model::FieldLevelEncryption)
pub mod field_level_encryption {
    /// A builder for [`FieldLevelEncryption`](crate::model::FieldLevelEncryption)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) last_modified_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) field_level_encryption_config:
            std::option::Option<crate::model::FieldLevelEncryptionConfig>,
    }
    impl Builder {
        /// <p>The configuration ID for a field-level encryption configuration which includes a set of profiles that specify certain
        /// selected data fields to be encrypted by specific public keys.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The configuration ID for a field-level encryption configuration which includes a set of profiles that specify certain
        /// selected data fields to be encrypted by specific public keys.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The last time the field-level encryption configuration was changed. </p>
        pub fn last_modified_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_modified_time = Some(input);
            self
        }
        /// <p>The last time the field-level encryption configuration was changed. </p>
        pub fn set_last_modified_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_modified_time = input;
            self
        }
        /// <p>A complex data type that includes the profile configurations specified for field-level encryption. </p>
        pub fn field_level_encryption_config(
            mut self,
            input: crate::model::FieldLevelEncryptionConfig,
        ) -> Self {
            self.field_level_encryption_config = Some(input);
            self
        }
        /// <p>A complex data type that includes the profile configurations specified for field-level encryption. </p>
        pub fn set_field_level_encryption_config(
            mut self,
            input: std::option::Option<crate::model::FieldLevelEncryptionConfig>,
        ) -> Self {
            self.field_level_encryption_config = input;
            self
        }
        /// Consumes the builder and constructs a [`FieldLevelEncryption`](crate::model::FieldLevelEncryption)
        pub fn build(self) -> crate::model::FieldLevelEncryption {
            crate::model::FieldLevelEncryption {
                id: self.id,
                last_modified_time: self.last_modified_time,
                field_level_encryption_config: self.field_level_encryption_config,
            }
        }
    }
}
impl FieldLevelEncryption {
    /// Creates a new builder-style object to manufacture [`FieldLevelEncryption`](crate::model::FieldLevelEncryption)
    pub fn builder() -> crate::model::field_level_encryption::Builder {
        crate::model::field_level_encryption::Builder::default()
    }
}

/// <p>A complex data type that includes the profile configurations specified for field-level encryption. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct FieldLevelEncryptionConfig {
    /// <p>A unique number that ensures the request can't be replayed.</p>
    pub caller_reference: std::option::Option<std::string::String>,
    /// <p>An optional comment about the configuration. The comment cannot be longer than 128
    /// characters.</p>
    pub comment: std::option::Option<std::string::String>,
    /// <p>A complex data type that specifies when to forward content if a profile isn't found and the profile that can be provided as a
    /// query argument in a request.</p>
    pub query_arg_profile_config: std::option::Option<crate::model::QueryArgProfileConfig>,
    /// <p>A complex data type that specifies when to forward content if a content type isn't recognized and profiles to use as by default
    /// in a request if a query argument doesn't specify a profile to use.</p>
    pub content_type_profile_config: std::option::Option<crate::model::ContentTypeProfileConfig>,
}
impl FieldLevelEncryptionConfig {
    /// <p>A unique number that ensures the request can't be replayed.</p>
    pub fn caller_reference(&self) -> std::option::Option<&str> {
        self.caller_reference.as_deref()
    }
    /// <p>An optional comment about the configuration. The comment cannot be longer than 128
    /// characters.</p>
    pub fn comment(&self) -> std::option::Option<&str> {
        self.comment.as_deref()
    }
    /// <p>A complex data type that specifies when to forward content if a profile isn't found and the profile that can be provided as a
    /// query argument in a request.</p>
    pub fn query_arg_profile_config(
        &self,
    ) -> std::option::Option<&crate::model::QueryArgProfileConfig> {
        self.query_arg_profile_config.as_ref()
    }
    /// <p>A complex data type that specifies when to forward content if a content type isn't recognized and profiles to use as by default
    /// in a request if a query argument doesn't specify a profile to use.</p>
    pub fn content_type_profile_config(
        &self,
    ) -> std::option::Option<&crate::model::ContentTypeProfileConfig> {
        self.content_type_profile_config.as_ref()
    }
}
impl std::fmt::Debug for FieldLevelEncryptionConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("FieldLevelEncryptionConfig");
        formatter.field("caller_reference", &self.caller_reference);
        formatter.field("comment", &self.comment);
        formatter.field("query_arg_profile_config", &self.query_arg_profile_config);
        formatter.field(
            "content_type_profile_config",
            &self.content_type_profile_config,
        );
        formatter.finish()
    }
}
/// See [`FieldLevelEncryptionConfig`](crate::model::FieldLevelEncryptionConfig)
pub mod field_level_encryption_config {
    /// A builder for [`FieldLevelEncryptionConfig`](crate::model::FieldLevelEncryptionConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) caller_reference: std::option::Option<std::string::String>,
        pub(crate) comment: std::option::Option<std::string::String>,
        pub(crate) query_arg_profile_config:
            std::option::Option<crate::model::QueryArgProfileConfig>,
        pub(crate) content_type_profile_config:
            std::option::Option<crate::model::ContentTypeProfileConfig>,
    }
    impl Builder {
        /// <p>A unique number that ensures the request can't be replayed.</p>
        pub fn caller_reference(mut self, input: impl Into<std::string::String>) -> Self {
            self.caller_reference = Some(input.into());
            self
        }
        /// <p>A unique number that ensures the request can't be replayed.</p>
        pub fn set_caller_reference(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.caller_reference = input;
            self
        }
        /// <p>An optional comment about the configuration. The comment cannot be longer than 128
        /// characters.</p>
        pub fn comment(mut self, input: impl Into<std::string::String>) -> Self {
            self.comment = Some(input.into());
            self
        }
        /// <p>An optional comment about the configuration. The comment cannot be longer than 128
        /// characters.</p>
        pub fn set_comment(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.comment = input;
            self
        }
        /// <p>A complex data type that specifies when to forward content if a profile isn't found and the profile that can be provided as a
        /// query argument in a request.</p>
        pub fn query_arg_profile_config(
            mut self,
            input: crate::model::QueryArgProfileConfig,
        ) -> Self {
            self.query_arg_profile_config = Some(input);
            self
        }
        /// <p>A complex data type that specifies when to forward content if a profile isn't found and the profile that can be provided as a
        /// query argument in a request.</p>
        pub fn set_query_arg_profile_config(
            mut self,
            input: std::option::Option<crate::model::QueryArgProfileConfig>,
        ) -> Self {
            self.query_arg_profile_config = input;
            self
        }
        /// <p>A complex data type that specifies when to forward content if a content type isn't recognized and profiles to use as by default
        /// in a request if a query argument doesn't specify a profile to use.</p>
        pub fn content_type_profile_config(
            mut self,
            input: crate::model::ContentTypeProfileConfig,
        ) -> Self {
            self.content_type_profile_config = Some(input);
            self
        }
        /// <p>A complex data type that specifies when to forward content if a content type isn't recognized and profiles to use as by default
        /// in a request if a query argument doesn't specify a profile to use.</p>
        pub fn set_content_type_profile_config(
            mut self,
            input: std::option::Option<crate::model::ContentTypeProfileConfig>,
        ) -> Self {
            self.content_type_profile_config = input;
            self
        }
        /// Consumes the builder and constructs a [`FieldLevelEncryptionConfig`](crate::model::FieldLevelEncryptionConfig)
        pub fn build(self) -> crate::model::FieldLevelEncryptionConfig {
            crate::model::FieldLevelEncryptionConfig {
                caller_reference: self.caller_reference,
                comment: self.comment,
                query_arg_profile_config: self.query_arg_profile_config,
                content_type_profile_config: self.content_type_profile_config,
            }
        }
    }
}
impl FieldLevelEncryptionConfig {
    /// Creates a new builder-style object to manufacture [`FieldLevelEncryptionConfig`](crate::model::FieldLevelEncryptionConfig)
    pub fn builder() -> crate::model::field_level_encryption_config::Builder {
        crate::model::field_level_encryption_config::Builder::default()
    }
}

/// <p>The configuration for a field-level encryption content type-profile mapping. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ContentTypeProfileConfig {
    /// <p>The setting in a field-level encryption content type-profile mapping that specifies what to do
    /// when an unknown content type is provided for the profile. If true, content is
    /// forwarded without being encrypted when the content type is unknown. If false (the
    /// default), an error is returned when the content type is unknown. </p>
    pub forward_when_content_type_is_unknown: std::option::Option<bool>,
    /// <p>The configuration for a field-level encryption content type-profile. </p>
    pub content_type_profiles: std::option::Option<crate::model::ContentTypeProfiles>,
}
impl ContentTypeProfileConfig {
    /// <p>The setting in a field-level encryption content type-profile mapping that specifies what to do
    /// when an unknown content type is provided for the profile. If true, content is
    /// forwarded without being encrypted when the content type is unknown. If false (the
    /// default), an error is returned when the content type is unknown. </p>
    pub fn forward_when_content_type_is_unknown(&self) -> std::option::Option<bool> {
        self.forward_when_content_type_is_unknown
    }
    /// <p>The configuration for a field-level encryption content type-profile. </p>
    pub fn content_type_profiles(&self) -> std::option::Option<&crate::model::ContentTypeProfiles> {
        self.content_type_profiles.as_ref()
    }
}
impl std::fmt::Debug for ContentTypeProfileConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ContentTypeProfileConfig");
        formatter.field(
            "forward_when_content_type_is_unknown",
            &self.forward_when_content_type_is_unknown,
        );
        formatter.field("content_type_profiles", &self.content_type_profiles);
        formatter.finish()
    }
}
/// See [`ContentTypeProfileConfig`](crate::model::ContentTypeProfileConfig)
pub mod content_type_profile_config {
    /// A builder for [`ContentTypeProfileConfig`](crate::model::ContentTypeProfileConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) forward_when_content_type_is_unknown: std::option::Option<bool>,
        pub(crate) content_type_profiles: std::option::Option<crate::model::ContentTypeProfiles>,
    }
    impl Builder {
        /// <p>The setting in a field-level encryption content type-profile mapping that specifies what to do
        /// when an unknown content type is provided for the profile. If true, content is
        /// forwarded without being encrypted when the content type is unknown. If false (the
        /// default), an error is returned when the content type is unknown. </p>
        pub fn forward_when_content_type_is_unknown(mut self, input: bool) -> Self {
            self.forward_when_content_type_is_unknown = Some(input);
            self
        }
        /// <p>The setting in a field-level encryption content type-profile mapping that specifies what to do
        /// when an unknown content type is provided for the profile. If true, content is
        /// forwarded without being encrypted when the content type is unknown. If false (the
        /// default), an error is returned when the content type is unknown. </p>
        pub fn set_forward_when_content_type_is_unknown(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.forward_when_content_type_is_unknown = input;
            self
        }
        /// <p>The configuration for a field-level encryption content type-profile. </p>
        pub fn content_type_profiles(mut self, input: crate::model::ContentTypeProfiles) -> Self {
            self.content_type_profiles = Some(input);
            self
        }
        /// <p>The configuration for a field-level encryption content type-profile. </p>
        pub fn set_content_type_profiles(
            mut self,
            input: std::option::Option<crate::model::ContentTypeProfiles>,
        ) -> Self {
            self.content_type_profiles = input;
            self
        }
        /// Consumes the builder and constructs a [`ContentTypeProfileConfig`](crate::model::ContentTypeProfileConfig)
        pub fn build(self) -> crate::model::ContentTypeProfileConfig {
            crate::model::ContentTypeProfileConfig {
                forward_when_content_type_is_unknown: self.forward_when_content_type_is_unknown,
                content_type_profiles: self.content_type_profiles,
            }
        }
    }
}
impl ContentTypeProfileConfig {
    /// Creates a new builder-style object to manufacture [`ContentTypeProfileConfig`](crate::model::ContentTypeProfileConfig)
    pub fn builder() -> crate::model::content_type_profile_config::Builder {
        crate::model::content_type_profile_config::Builder::default()
    }
}

/// <p>Field-level encryption content type-profile. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ContentTypeProfiles {
    /// <p>The number of field-level encryption content type-profile mappings. </p>
    pub quantity: std::option::Option<i32>,
    /// <p>Items in a field-level encryption content type-profile mapping. </p>
    pub items: std::option::Option<std::vec::Vec<crate::model::ContentTypeProfile>>,
}
impl ContentTypeProfiles {
    /// <p>The number of field-level encryption content type-profile mappings. </p>
    pub fn quantity(&self) -> std::option::Option<i32> {
        self.quantity
    }
    /// <p>Items in a field-level encryption content type-profile mapping. </p>
    pub fn items(&self) -> std::option::Option<&[crate::model::ContentTypeProfile]> {
        self.items.as_deref()
    }
}
impl std::fmt::Debug for ContentTypeProfiles {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ContentTypeProfiles");
        formatter.field("quantity", &self.quantity);
        formatter.field("items", &self.items);
        formatter.finish()
    }
}
/// See [`ContentTypeProfiles`](crate::model::ContentTypeProfiles)
pub mod content_type_profiles {
    /// A builder for [`ContentTypeProfiles`](crate::model::ContentTypeProfiles)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) quantity: std::option::Option<i32>,
        pub(crate) items: std::option::Option<std::vec::Vec<crate::model::ContentTypeProfile>>,
    }
    impl Builder {
        /// <p>The number of field-level encryption content type-profile mappings. </p>
        pub fn quantity(mut self, input: i32) -> Self {
            self.quantity = Some(input);
            self
        }
        /// <p>The number of field-level encryption content type-profile mappings. </p>
        pub fn set_quantity(mut self, input: std::option::Option<i32>) -> Self {
            self.quantity = input;
            self
        }
        /// Appends an item to `items`.
        ///
        /// To override the contents of this collection use [`set_items`](Self::set_items).
        ///
        /// <p>Items in a field-level encryption content type-profile mapping. </p>
        pub fn items(mut self, input: impl Into<crate::model::ContentTypeProfile>) -> Self {
            let mut v = self.items.unwrap_or_default();
            v.push(input.into());
            self.items = Some(v);
            self
        }
        /// <p>Items in a field-level encryption content type-profile mapping. </p>
        pub fn set_items(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ContentTypeProfile>>,
        ) -> Self {
            self.items = input;
            self
        }
        /// Consumes the builder and constructs a [`ContentTypeProfiles`](crate::model::ContentTypeProfiles)
        pub fn build(self) -> crate::model::ContentTypeProfiles {
            crate::model::ContentTypeProfiles {
                quantity: self.quantity,
                items: self.items,
            }
        }
    }
}
impl ContentTypeProfiles {
    /// Creates a new builder-style object to manufacture [`ContentTypeProfiles`](crate::model::ContentTypeProfiles)
    pub fn builder() -> crate::model::content_type_profiles::Builder {
        crate::model::content_type_profiles::Builder::default()
    }
}

/// <p>A field-level encryption content type profile. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ContentTypeProfile {
    /// <p>The format for a field-level encryption content type-profile mapping. </p>
    pub format: std::option::Option<crate::model::Format>,
    /// <p>The profile ID for a field-level encryption content type-profile mapping. </p>
    pub profile_id: std::option::Option<std::string::String>,
    /// <p>The content type for a field-level encryption content type-profile mapping. </p>
    pub content_type: std::option::Option<std::string::String>,
}
impl ContentTypeProfile {
    /// <p>The format for a field-level encryption content type-profile mapping. </p>
    pub fn format(&self) -> std::option::Option<&crate::model::Format> {
        self.format.as_ref()
    }
    /// <p>The profile ID for a field-level encryption content type-profile mapping. </p>
    pub fn profile_id(&self) -> std::option::Option<&str> {
        self.profile_id.as_deref()
    }
    /// <p>The content type for a field-level encryption content type-profile mapping. </p>
    pub fn content_type(&self) -> std::option::Option<&str> {
        self.content_type.as_deref()
    }
}
impl std::fmt::Debug for ContentTypeProfile {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ContentTypeProfile");
        formatter.field("format", &self.format);
        formatter.field("profile_id", &self.profile_id);
        formatter.field("content_type", &self.content_type);
        formatter.finish()
    }
}
/// See [`ContentTypeProfile`](crate::model::ContentTypeProfile)
pub mod content_type_profile {
    /// A builder for [`ContentTypeProfile`](crate::model::ContentTypeProfile)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) format: std::option::Option<crate::model::Format>,
        pub(crate) profile_id: std::option::Option<std::string::String>,
        pub(crate) content_type: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The format for a field-level encryption content type-profile mapping. </p>
        pub fn format(mut self, input: crate::model::Format) -> Self {
            self.format = Some(input);
            self
        }
        /// <p>The format for a field-level encryption content type-profile mapping. </p>
        pub fn set_format(mut self, input: std::option::Option<crate::model::Format>) -> Self {
            self.format = input;
            self
        }
        /// <p>The profile ID for a field-level encryption content type-profile mapping. </p>
        pub fn profile_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.profile_id = Some(input.into());
            self
        }
        /// <p>The profile ID for a field-level encryption content type-profile mapping. </p>
        pub fn set_profile_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.profile_id = input;
            self
        }
        /// <p>The content type for a field-level encryption content type-profile mapping. </p>
        pub fn content_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.content_type = Some(input.into());
            self
        }
        /// <p>The content type for a field-level encryption content type-profile mapping. </p>
        pub fn set_content_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.content_type = input;
            self
        }
        /// Consumes the builder and constructs a [`ContentTypeProfile`](crate::model::ContentTypeProfile)
        pub fn build(self) -> crate::model::ContentTypeProfile {
            crate::model::ContentTypeProfile {
                format: self.format,
                profile_id: self.profile_id,
                content_type: self.content_type,
            }
        }
    }
}
impl ContentTypeProfile {
    /// Creates a new builder-style object to manufacture [`ContentTypeProfile`](crate::model::ContentTypeProfile)
    pub fn builder() -> crate::model::content_type_profile::Builder {
        crate::model::content_type_profile::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum Format {
    #[allow(missing_docs)] // documentation missing in model
    UrlEncoded,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for Format {
    fn from(s: &str) -> Self {
        match s {
            "URLEncoded" => Format::UrlEncoded,
            other => Format::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for Format {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(Format::from(s))
    }
}
impl Format {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            Format::UrlEncoded => "URLEncoded",
            Format::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["URLEncoded"]
    }
}
impl AsRef<str> for Format {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Configuration for query argument-profile mapping for field-level encryption.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct QueryArgProfileConfig {
    /// <p>Flag to set if you want a request to be forwarded to the origin even if the profile specified by the field-level encryption query argument,
    /// fle-profile, is unknown.</p>
    pub forward_when_query_arg_profile_is_unknown: std::option::Option<bool>,
    /// <p>Profiles specified for query argument-profile mapping for field-level encryption.</p>
    pub query_arg_profiles: std::option::Option<crate::model::QueryArgProfiles>,
}
impl QueryArgProfileConfig {
    /// <p>Flag to set if you want a request to be forwarded to the origin even if the profile specified by the field-level encryption query argument,
    /// fle-profile, is unknown.</p>
    pub fn forward_when_query_arg_profile_is_unknown(&self) -> std::option::Option<bool> {
        self.forward_when_query_arg_profile_is_unknown
    }
    /// <p>Profiles specified for query argument-profile mapping for field-level encryption.</p>
    pub fn query_arg_profiles(&self) -> std::option::Option<&crate::model::QueryArgProfiles> {
        self.query_arg_profiles.as_ref()
    }
}
impl std::fmt::Debug for QueryArgProfileConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("QueryArgProfileConfig");
        formatter.field(
            "forward_when_query_arg_profile_is_unknown",
            &self.forward_when_query_arg_profile_is_unknown,
        );
        formatter.field("query_arg_profiles", &self.query_arg_profiles);
        formatter.finish()
    }
}
/// See [`QueryArgProfileConfig`](crate::model::QueryArgProfileConfig)
pub mod query_arg_profile_config {
    /// A builder for [`QueryArgProfileConfig`](crate::model::QueryArgProfileConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) forward_when_query_arg_profile_is_unknown: std::option::Option<bool>,
        pub(crate) query_arg_profiles: std::option::Option<crate::model::QueryArgProfiles>,
    }
    impl Builder {
        /// <p>Flag to set if you want a request to be forwarded to the origin even if the profile specified by the field-level encryption query argument,
        /// fle-profile, is unknown.</p>
        pub fn forward_when_query_arg_profile_is_unknown(mut self, input: bool) -> Self {
            self.forward_when_query_arg_profile_is_unknown = Some(input);
            self
        }
        /// <p>Flag to set if you want a request to be forwarded to the origin even if the profile specified by the field-level encryption query argument,
        /// fle-profile, is unknown.</p>
        pub fn set_forward_when_query_arg_profile_is_unknown(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.forward_when_query_arg_profile_is_unknown = input;
            self
        }
        /// <p>Profiles specified for query argument-profile mapping for field-level encryption.</p>
        pub fn query_arg_profiles(mut self, input: crate::model::QueryArgProfiles) -> Self {
            self.query_arg_profiles = Some(input);
            self
        }
        /// <p>Profiles specified for query argument-profile mapping for field-level encryption.</p>
        pub fn set_query_arg_profiles(
            mut self,
            input: std::option::Option<crate::model::QueryArgProfiles>,
        ) -> Self {
            self.query_arg_profiles = input;
            self
        }
        /// Consumes the builder and constructs a [`QueryArgProfileConfig`](crate::model::QueryArgProfileConfig)
        pub fn build(self) -> crate::model::QueryArgProfileConfig {
            crate::model::QueryArgProfileConfig {
                forward_when_query_arg_profile_is_unknown: self
                    .forward_when_query_arg_profile_is_unknown,
                query_arg_profiles: self.query_arg_profiles,
            }
        }
    }
}
impl QueryArgProfileConfig {
    /// Creates a new builder-style object to manufacture [`QueryArgProfileConfig`](crate::model::QueryArgProfileConfig)
    pub fn builder() -> crate::model::query_arg_profile_config::Builder {
        crate::model::query_arg_profile_config::Builder::default()
    }
}

/// <p>Query argument-profile mapping for field-level encryption.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct QueryArgProfiles {
    /// <p>Number of profiles for query argument-profile mapping for field-level encryption.</p>
    pub quantity: std::option::Option<i32>,
    /// <p>Number of items for query argument-profile mapping for field-level encryption.</p>
    pub items: std::option::Option<std::vec::Vec<crate::model::QueryArgProfile>>,
}
impl QueryArgProfiles {
    /// <p>Number of profiles for query argument-profile mapping for field-level encryption.</p>
    pub fn quantity(&self) -> std::option::Option<i32> {
        self.quantity
    }
    /// <p>Number of items for query argument-profile mapping for field-level encryption.</p>
    pub fn items(&self) -> std::option::Option<&[crate::model::QueryArgProfile]> {
        self.items.as_deref()
    }
}
impl std::fmt::Debug for QueryArgProfiles {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("QueryArgProfiles");
        formatter.field("quantity", &self.quantity);
        formatter.field("items", &self.items);
        formatter.finish()
    }
}
/// See [`QueryArgProfiles`](crate::model::QueryArgProfiles)
pub mod query_arg_profiles {
    /// A builder for [`QueryArgProfiles`](crate::model::QueryArgProfiles)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) quantity: std::option::Option<i32>,
        pub(crate) items: std::option::Option<std::vec::Vec<crate::model::QueryArgProfile>>,
    }
    impl Builder {
        /// <p>Number of profiles for query argument-profile mapping for field-level encryption.</p>
        pub fn quantity(mut self, input: i32) -> Self {
            self.quantity = Some(input);
            self
        }
        /// <p>Number of profiles for query argument-profile mapping for field-level encryption.</p>
        pub fn set_quantity(mut self, input: std::option::Option<i32>) -> Self {
            self.quantity = input;
            self
        }
        /// Appends an item to `items`.
        ///
        /// To override the contents of this collection use [`set_items`](Self::set_items).
        ///
        /// <p>Number of items for query argument-profile mapping for field-level encryption.</p>
        pub fn items(mut self, input: impl Into<crate::model::QueryArgProfile>) -> Self {
            let mut v = self.items.unwrap_or_default();
            v.push(input.into());
            self.items = Some(v);
            self
        }
        /// <p>Number of items for query argument-profile mapping for field-level encryption.</p>
        pub fn set_items(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::QueryArgProfile>>,
        ) -> Self {
            self.items = input;
            self
        }
        /// Consumes the builder and constructs a [`QueryArgProfiles`](crate::model::QueryArgProfiles)
        pub fn build(self) -> crate::model::QueryArgProfiles {
            crate::model::QueryArgProfiles {
                quantity: self.quantity,
                items: self.items,
            }
        }
    }
}
impl QueryArgProfiles {
    /// Creates a new builder-style object to manufacture [`QueryArgProfiles`](crate::model::QueryArgProfiles)
    pub fn builder() -> crate::model::query_arg_profiles::Builder {
        crate::model::query_arg_profiles::Builder::default()
    }
}

/// <p>Query argument-profile mapping for field-level encryption.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct QueryArgProfile {
    /// <p>Query argument for field-level encryption query argument-profile mapping.</p>
    pub query_arg: std::option::Option<std::string::String>,
    /// <p>ID of profile to use for field-level encryption query argument-profile mapping</p>
    pub profile_id: std::option::Option<std::string::String>,
}
impl QueryArgProfile {
    /// <p>Query argument for field-level encryption query argument-profile mapping.</p>
    pub fn query_arg(&self) -> std::option::Option<&str> {
        self.query_arg.as_deref()
    }
    /// <p>ID of profile to use for field-level encryption query argument-profile mapping</p>
    pub fn profile_id(&self) -> std::option::Option<&str> {
        self.profile_id.as_deref()
    }
}
impl std::fmt::Debug for QueryArgProfile {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("QueryArgProfile");
        formatter.field("query_arg", &self.query_arg);
        formatter.field("profile_id", &self.profile_id);
        formatter.finish()
    }
}
/// See [`QueryArgProfile`](crate::model::QueryArgProfile)
pub mod query_arg_profile {
    /// A builder for [`QueryArgProfile`](crate::model::QueryArgProfile)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) query_arg: std::option::Option<std::string::String>,
        pub(crate) profile_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Query argument for field-level encryption query argument-profile mapping.</p>
        pub fn query_arg(mut self, input: impl Into<std::string::String>) -> Self {
            self.query_arg = Some(input.into());
            self
        }
        /// <p>Query argument for field-level encryption query argument-profile mapping.</p>
        pub fn set_query_arg(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.query_arg = input;
            self
        }
        /// <p>ID of profile to use for field-level encryption query argument-profile mapping</p>
        pub fn profile_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.profile_id = Some(input.into());
            self
        }
        /// <p>ID of profile to use for field-level encryption query argument-profile mapping</p>
        pub fn set_profile_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.profile_id = input;
            self
        }
        /// Consumes the builder and constructs a [`QueryArgProfile`](crate::model::QueryArgProfile)
        pub fn build(self) -> crate::model::QueryArgProfile {
            crate::model::QueryArgProfile {
                query_arg: self.query_arg,
                profile_id: self.profile_id,
            }
        }
    }
}
impl QueryArgProfile {
    /// Creates a new builder-style object to manufacture [`QueryArgProfile`](crate::model::QueryArgProfile)
    pub fn builder() -> crate::model::query_arg_profile::Builder {
        crate::model::query_arg_profile::Builder::default()
    }
}

/// <p>A distribution tells CloudFront where you want content to be delivered from, and the details about how to
/// track and manage content delivery.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Distribution {
    /// <p>The identifier for the distribution. For example: <code>EDFDVBD632BHDS5</code>.
    /// </p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The ARN (Amazon Resource Name) for the distribution. For example:
    /// <code>arn:aws:cloudfront::123456789012:distribution/EDFDVBD632BHDS5</code>, where
    /// <code>123456789012</code> is your Amazon Web Services account ID.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>This response element indicates the current status of the distribution. When the status
    /// is <code>Deployed</code>, the distribution's information is fully propagated to all CloudFront edge
    /// locations. </p>
    pub status: std::option::Option<std::string::String>,
    /// <p>The date and time the distribution was last modified. </p>
    pub last_modified_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The number of invalidation batches currently in progress. </p>
    pub in_progress_invalidation_batches: std::option::Option<i32>,
    /// <p>The domain name corresponding to the distribution, for example, <code>d111111abcdef8.cloudfront.net</code>. </p>
    pub domain_name: std::option::Option<std::string::String>,
    /// <important>
    /// <p>We recommend using <code>TrustedKeyGroups</code> instead of
    /// <code>TrustedSigners</code>.</p>
    /// </important>
    /// <p>CloudFront automatically adds this field to the response if you’ve configured a cache behavior in
    /// this distribution to serve private content using trusted signers. This field contains a
    /// list of Amazon Web Services account IDs and the active CloudFront key pairs in each account that CloudFront can use
    /// to verify the signatures of signed URLs or signed cookies.</p>
    pub active_trusted_signers: std::option::Option<crate::model::ActiveTrustedSigners>,
    /// <p>CloudFront automatically adds this field to the response if you’ve configured a cache
    /// behavior in this distribution to serve private content using key groups. This field
    /// contains a list of key groups and the public keys in each key group that CloudFront can use to
    /// verify the signatures of signed URLs or signed cookies.</p>
    pub active_trusted_key_groups: std::option::Option<crate::model::ActiveTrustedKeyGroups>,
    /// <p>The current configuration information for the distribution. Send a <code>GET</code>
    /// request to the <code>/<i>CloudFront API version</i>/distribution ID/config</code>
    /// resource.</p>
    pub distribution_config: std::option::Option<crate::model::DistributionConfig>,
    /// <p>Amazon Web Services services in China customers must file for an Internet Content Provider (ICP) recordal if they want to serve content
    /// publicly on an alternate domain name, also known as a CNAME, that they've added to CloudFront. AliasICPRecordal provides the ICP
    /// recordal status for CNAMEs associated with distributions.</p>
    /// <p>For more information about ICP recordals, see  <a href="https://docs.amazonaws.cn/en_us/aws/latest/userguide/accounts-and-credentials.html">
    /// Signup, Accounts, and Credentials</a> in <i>Getting Started with Amazon Web Services services in China</i>.</p>
    pub alias_icp_recordals: std::option::Option<std::vec::Vec<crate::model::AliasIcpRecordal>>,
}
impl Distribution {
    /// <p>The identifier for the distribution. For example: <code>EDFDVBD632BHDS5</code>.
    /// </p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The ARN (Amazon Resource Name) for the distribution. For example:
    /// <code>arn:aws:cloudfront::123456789012:distribution/EDFDVBD632BHDS5</code>, where
    /// <code>123456789012</code> is your Amazon Web Services account ID.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>This response element indicates the current status of the distribution. When the status
    /// is <code>Deployed</code>, the distribution's information is fully propagated to all CloudFront edge
    /// locations. </p>
    pub fn status(&self) -> std::option::Option<&str> {
        self.status.as_deref()
    }
    /// <p>The date and time the distribution was last modified. </p>
    pub fn last_modified_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_modified_time.as_ref()
    }
    /// <p>The number of invalidation batches currently in progress. </p>
    pub fn in_progress_invalidation_batches(&self) -> std::option::Option<i32> {
        self.in_progress_invalidation_batches
    }
    /// <p>The domain name corresponding to the distribution, for example, <code>d111111abcdef8.cloudfront.net</code>. </p>
    pub fn domain_name(&self) -> std::option::Option<&str> {
        self.domain_name.as_deref()
    }
    /// <important>
    /// <p>We recommend using <code>TrustedKeyGroups</code> instead of
    /// <code>TrustedSigners</code>.</p>
    /// </important>
    /// <p>CloudFront automatically adds this field to the response if you’ve configured a cache behavior in
    /// this distribution to serve private content using trusted signers. This field contains a
    /// list of Amazon Web Services account IDs and the active CloudFront key pairs in each account that CloudFront can use
    /// to verify the signatures of signed URLs or signed cookies.</p>
    pub fn active_trusted_signers(
        &self,
    ) -> std::option::Option<&crate::model::ActiveTrustedSigners> {
        self.active_trusted_signers.as_ref()
    }
    /// <p>CloudFront automatically adds this field to the response if you’ve configured a cache
    /// behavior in this distribution to serve private content using key groups. This field
    /// contains a list of key groups and the public keys in each key group that CloudFront can use to
    /// verify the signatures of signed URLs or signed cookies.</p>
    pub fn active_trusted_key_groups(
        &self,
    ) -> std::option::Option<&crate::model::ActiveTrustedKeyGroups> {
        self.active_trusted_key_groups.as_ref()
    }
    /// <p>The current configuration information for the distribution. Send a <code>GET</code>
    /// request to the <code>/<i>CloudFront API version</i>/distribution ID/config</code>
    /// resource.</p>
    pub fn distribution_config(&self) -> std::option::Option<&crate::model::DistributionConfig> {
        self.distribution_config.as_ref()
    }
    /// <p>Amazon Web Services services in China customers must file for an Internet Content Provider (ICP) recordal if they want to serve content
    /// publicly on an alternate domain name, also known as a CNAME, that they've added to CloudFront. AliasICPRecordal provides the ICP
    /// recordal status for CNAMEs associated with distributions.</p>
    /// <p>For more information about ICP recordals, see  <a href="https://docs.amazonaws.cn/en_us/aws/latest/userguide/accounts-and-credentials.html">
    /// Signup, Accounts, and Credentials</a> in <i>Getting Started with Amazon Web Services services in China</i>.</p>
    pub fn alias_icp_recordals(&self) -> std::option::Option<&[crate::model::AliasIcpRecordal]> {
        self.alias_icp_recordals.as_deref()
    }
}
impl std::fmt::Debug for Distribution {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Distribution");
        formatter.field("id", &self.id);
        formatter.field("arn", &self.arn);
        formatter.field("status", &self.status);
        formatter.field("last_modified_time", &self.last_modified_time);
        formatter.field(
            "in_progress_invalidation_batches",
            &self.in_progress_invalidation_batches,
        );
        formatter.field("domain_name", &self.domain_name);
        formatter.field("active_trusted_signers", &self.active_trusted_signers);
        formatter.field("active_trusted_key_groups", &self.active_trusted_key_groups);
        formatter.field("distribution_config", &self.distribution_config);
        formatter.field("alias_icp_recordals", &self.alias_icp_recordals);
        formatter.finish()
    }
}
/// See [`Distribution`](crate::model::Distribution)
pub mod distribution {
    /// A builder for [`Distribution`](crate::model::Distribution)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<std::string::String>,
        pub(crate) last_modified_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) in_progress_invalidation_batches: std::option::Option<i32>,
        pub(crate) domain_name: std::option::Option<std::string::String>,
        pub(crate) active_trusted_signers: std::option::Option<crate::model::ActiveTrustedSigners>,
        pub(crate) active_trusted_key_groups:
            std::option::Option<crate::model::ActiveTrustedKeyGroups>,
        pub(crate) distribution_config: std::option::Option<crate::model::DistributionConfig>,
        pub(crate) alias_icp_recordals:
            std::option::Option<std::vec::Vec<crate::model::AliasIcpRecordal>>,
    }
    impl Builder {
        /// <p>The identifier for the distribution. For example: <code>EDFDVBD632BHDS5</code>.
        /// </p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The identifier for the distribution. For example: <code>EDFDVBD632BHDS5</code>.
        /// </p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The ARN (Amazon Resource Name) for the distribution. For example:
        /// <code>arn:aws:cloudfront::123456789012:distribution/EDFDVBD632BHDS5</code>, where
        /// <code>123456789012</code> is your Amazon Web Services account ID.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The ARN (Amazon Resource Name) for the distribution. For example:
        /// <code>arn:aws:cloudfront::123456789012:distribution/EDFDVBD632BHDS5</code>, where
        /// <code>123456789012</code> is your Amazon Web Services account ID.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>This response element indicates the current status of the distribution. When the status
        /// is <code>Deployed</code>, the distribution's information is fully propagated to all CloudFront edge
        /// locations. </p>
        pub fn status(mut self, input: impl Into<std::string::String>) -> Self {
            self.status = Some(input.into());
            self
        }
        /// <p>This response element indicates the current status of the distribution. When the status
        /// is <code>Deployed</code>, the distribution's information is fully propagated to all CloudFront edge
        /// locations. </p>
        pub fn set_status(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.status = input;
            self
        }
        /// <p>The date and time the distribution was last modified. </p>
        pub fn last_modified_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_modified_time = Some(input);
            self
        }
        /// <p>The date and time the distribution was last modified. </p>
        pub fn set_last_modified_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_modified_time = input;
            self
        }
        /// <p>The number of invalidation batches currently in progress. </p>
        pub fn in_progress_invalidation_batches(mut self, input: i32) -> Self {
            self.in_progress_invalidation_batches = Some(input);
            self
        }
        /// <p>The number of invalidation batches currently in progress. </p>
        pub fn set_in_progress_invalidation_batches(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.in_progress_invalidation_batches = input;
            self
        }
        /// <p>The domain name corresponding to the distribution, for example, <code>d111111abcdef8.cloudfront.net</code>. </p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain_name = Some(input.into());
            self
        }
        /// <p>The domain name corresponding to the distribution, for example, <code>d111111abcdef8.cloudfront.net</code>. </p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain_name = input;
            self
        }
        /// <important>
        /// <p>We recommend using <code>TrustedKeyGroups</code> instead of
        /// <code>TrustedSigners</code>.</p>
        /// </important>
        /// <p>CloudFront automatically adds this field to the response if you’ve configured a cache behavior in
        /// this distribution to serve private content using trusted signers. This field contains a
        /// list of Amazon Web Services account IDs and the active CloudFront key pairs in each account that CloudFront can use
        /// to verify the signatures of signed URLs or signed cookies.</p>
        pub fn active_trusted_signers(mut self, input: crate::model::ActiveTrustedSigners) -> Self {
            self.active_trusted_signers = Some(input);
            self
        }
        /// <important>
        /// <p>We recommend using <code>TrustedKeyGroups</code> instead of
        /// <code>TrustedSigners</code>.</p>
        /// </important>
        /// <p>CloudFront automatically adds this field to the response if you’ve configured a cache behavior in
        /// this distribution to serve private content using trusted signers. This field contains a
        /// list of Amazon Web Services account IDs and the active CloudFront key pairs in each account that CloudFront can use
        /// to verify the signatures of signed URLs or signed cookies.</p>
        pub fn set_active_trusted_signers(
            mut self,
            input: std::option::Option<crate::model::ActiveTrustedSigners>,
        ) -> Self {
            self.active_trusted_signers = input;
            self
        }
        /// <p>CloudFront automatically adds this field to the response if you’ve configured a cache
        /// behavior in this distribution to serve private content using key groups. This field
        /// contains a list of key groups and the public keys in each key group that CloudFront can use to
        /// verify the signatures of signed URLs or signed cookies.</p>
        pub fn active_trusted_key_groups(
            mut self,
            input: crate::model::ActiveTrustedKeyGroups,
        ) -> Self {
            self.active_trusted_key_groups = Some(input);
            self
        }
        /// <p>CloudFront automatically adds this field to the response if you’ve configured a cache
        /// behavior in this distribution to serve private content using key groups. This field
        /// contains a list of key groups and the public keys in each key group that CloudFront can use to
        /// verify the signatures of signed URLs or signed cookies.</p>
        pub fn set_active_trusted_key_groups(
            mut self,
            input: std::option::Option<crate::model::ActiveTrustedKeyGroups>,
        ) -> Self {
            self.active_trusted_key_groups = input;
            self
        }
        /// <p>The current configuration information for the distribution. Send a <code>GET</code>
        /// request to the <code>/<i>CloudFront API version</i>/distribution ID/config</code>
        /// resource.</p>
        pub fn distribution_config(mut self, input: crate::model::DistributionConfig) -> Self {
            self.distribution_config = Some(input);
            self
        }
        /// <p>The current configuration information for the distribution. Send a <code>GET</code>
        /// request to the <code>/<i>CloudFront API version</i>/distribution ID/config</code>
        /// resource.</p>
        pub fn set_distribution_config(
            mut self,
            input: std::option::Option<crate::model::DistributionConfig>,
        ) -> Self {
            self.distribution_config = input;
            self
        }
        /// Appends an item to `alias_icp_recordals`.
        ///
        /// To override the contents of this collection use [`set_alias_icp_recordals`](Self::set_alias_icp_recordals).
        ///
        /// <p>Amazon Web Services services in China customers must file for an Internet Content Provider (ICP) recordal if they want to serve content
        /// publicly on an alternate domain name, also known as a CNAME, that they've added to CloudFront. AliasICPRecordal provides the ICP
        /// recordal status for CNAMEs associated with distributions.</p>
        /// <p>For more information about ICP recordals, see  <a href="https://docs.amazonaws.cn/en_us/aws/latest/userguide/accounts-and-credentials.html">
        /// Signup, Accounts, and Credentials</a> in <i>Getting Started with Amazon Web Services services in China</i>.</p>
        pub fn alias_icp_recordals(
            mut self,
            input: impl Into<crate::model::AliasIcpRecordal>,
        ) -> Self {
            let mut v = self.alias_icp_recordals.unwrap_or_default();
            v.push(input.into());
            self.alias_icp_recordals = Some(v);
            self
        }
        /// <p>Amazon Web Services services in China customers must file for an Internet Content Provider (ICP) recordal if they want to serve content
        /// publicly on an alternate domain name, also known as a CNAME, that they've added to CloudFront. AliasICPRecordal provides the ICP
        /// recordal status for CNAMEs associated with distributions.</p>
        /// <p>For more information about ICP recordals, see  <a href="https://docs.amazonaws.cn/en_us/aws/latest/userguide/accounts-and-credentials.html">
        /// Signup, Accounts, and Credentials</a> in <i>Getting Started with Amazon Web Services services in China</i>.</p>
        pub fn set_alias_icp_recordals(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AliasIcpRecordal>>,
        ) -> Self {
            self.alias_icp_recordals = input;
            self
        }
        /// Consumes the builder and constructs a [`Distribution`](crate::model::Distribution)
        pub fn build(self) -> crate::model::Distribution {
            crate::model::Distribution {
                id: self.id,
                arn: self.arn,
                status: self.status,
                last_modified_time: self.last_modified_time,
                in_progress_invalidation_batches: self.in_progress_invalidation_batches,
                domain_name: self.domain_name,
                active_trusted_signers: self.active_trusted_signers,
                active_trusted_key_groups: self.active_trusted_key_groups,
                distribution_config: self.distribution_config,
                alias_icp_recordals: self.alias_icp_recordals,
            }
        }
    }
}
impl Distribution {
    /// Creates a new builder-style object to manufacture [`Distribution`](crate::model::Distribution)
    pub fn builder() -> crate::model::distribution::Builder {
        crate::model::distribution::Builder::default()
    }
}

/// <p>Amazon Web Services services in China customers must file for an Internet Content Provider (ICP) recordal if they want to serve content
/// publicly on an alternate domain name, also known as a CNAME, that they've added to CloudFront. AliasICPRecordal provides the ICP
/// recordal status for CNAMEs associated with distributions. The status is returned in the CloudFront response; you can't configure
/// it yourself.</p>
/// <p>For more information about ICP recordals, see  <a href="https://docs.amazonaws.cn/en_us/aws/latest/userguide/accounts-and-credentials.html">
/// Signup, Accounts, and Credentials</a> in <i>Getting Started with Amazon Web Services services in China</i>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AliasIcpRecordal {
    /// <p>A domain name associated with a distribution. </p>
    pub cname: std::option::Option<std::string::String>,
    /// <p>The Internet Content Provider (ICP) recordal status for a CNAME. The ICPRecordalStatus is set to
    /// APPROVED for all CNAMEs (aliases) in regions outside of China. </p>
    /// <p>The status values returned are the following:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <b>APPROVED</b> indicates that the associated CNAME has a valid ICP recordal number.
    /// Multiple CNAMEs can be associated with a distribution, and CNAMEs can correspond to different ICP recordals. To be marked as
    /// APPROVED, that is, valid to use with China region, a CNAME must have one ICP recordal number associated with it.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>SUSPENDED</b> indicates that the associated CNAME does not have a valid ICP recordal
    /// number.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>PENDING</b> indicates that CloudFront can't determine the ICP recordal status of the
    /// CNAME associated with the distribution because there was an error in trying to determine the status. You can try again
    /// to see if the error is resolved in which case CloudFront returns an APPROVED or SUSPENDED status.</p>
    /// </li>
    /// </ul>
    pub icp_recordal_status: std::option::Option<crate::model::IcpRecordalStatus>,
}
impl AliasIcpRecordal {
    /// <p>A domain name associated with a distribution. </p>
    pub fn cname(&self) -> std::option::Option<&str> {
        self.cname.as_deref()
    }
    /// <p>The Internet Content Provider (ICP) recordal status for a CNAME. The ICPRecordalStatus is set to
    /// APPROVED for all CNAMEs (aliases) in regions outside of China. </p>
    /// <p>The status values returned are the following:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <b>APPROVED</b> indicates that the associated CNAME has a valid ICP recordal number.
    /// Multiple CNAMEs can be associated with a distribution, and CNAMEs can correspond to different ICP recordals. To be marked as
    /// APPROVED, that is, valid to use with China region, a CNAME must have one ICP recordal number associated with it.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>SUSPENDED</b> indicates that the associated CNAME does not have a valid ICP recordal
    /// number.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>PENDING</b> indicates that CloudFront can't determine the ICP recordal status of the
    /// CNAME associated with the distribution because there was an error in trying to determine the status. You can try again
    /// to see if the error is resolved in which case CloudFront returns an APPROVED or SUSPENDED status.</p>
    /// </li>
    /// </ul>
    pub fn icp_recordal_status(&self) -> std::option::Option<&crate::model::IcpRecordalStatus> {
        self.icp_recordal_status.as_ref()
    }
}
impl std::fmt::Debug for AliasIcpRecordal {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AliasIcpRecordal");
        formatter.field("cname", &self.cname);
        formatter.field("icp_recordal_status", &self.icp_recordal_status);
        formatter.finish()
    }
}
/// See [`AliasIcpRecordal`](crate::model::AliasIcpRecordal)
pub mod alias_icp_recordal {
    /// A builder for [`AliasIcpRecordal`](crate::model::AliasIcpRecordal)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cname: std::option::Option<std::string::String>,
        pub(crate) icp_recordal_status: std::option::Option<crate::model::IcpRecordalStatus>,
    }
    impl Builder {
        /// <p>A domain name associated with a distribution. </p>
        pub fn cname(mut self, input: impl Into<std::string::String>) -> Self {
            self.cname = Some(input.into());
            self
        }
        /// <p>A domain name associated with a distribution. </p>
        pub fn set_cname(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.cname = input;
            self
        }
        /// <p>The Internet Content Provider (ICP) recordal status for a CNAME. The ICPRecordalStatus is set to
        /// APPROVED for all CNAMEs (aliases) in regions outside of China. </p>
        /// <p>The status values returned are the following:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>APPROVED</b> indicates that the associated CNAME has a valid ICP recordal number.
        /// Multiple CNAMEs can be associated with a distribution, and CNAMEs can correspond to different ICP recordals. To be marked as
        /// APPROVED, that is, valid to use with China region, a CNAME must have one ICP recordal number associated with it.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>SUSPENDED</b> indicates that the associated CNAME does not have a valid ICP recordal
        /// number.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>PENDING</b> indicates that CloudFront can't determine the ICP recordal status of the
        /// CNAME associated with the distribution because there was an error in trying to determine the status. You can try again
        /// to see if the error is resolved in which case CloudFront returns an APPROVED or SUSPENDED status.</p>
        /// </li>
        /// </ul>
        pub fn icp_recordal_status(mut self, input: crate::model::IcpRecordalStatus) -> Self {
            self.icp_recordal_status = Some(input);
            self
        }
        /// <p>The Internet Content Provider (ICP) recordal status for a CNAME. The ICPRecordalStatus is set to
        /// APPROVED for all CNAMEs (aliases) in regions outside of China. </p>
        /// <p>The status values returned are the following:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>APPROVED</b> indicates that the associated CNAME has a valid ICP recordal number.
        /// Multiple CNAMEs can be associated with a distribution, and CNAMEs can correspond to different ICP recordals. To be marked as
        /// APPROVED, that is, valid to use with China region, a CNAME must have one ICP recordal number associated with it.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>SUSPENDED</b> indicates that the associated CNAME does not have a valid ICP recordal
        /// number.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>PENDING</b> indicates that CloudFront can't determine the ICP recordal status of the
        /// CNAME associated with the distribution because there was an error in trying to determine the status. You can try again
        /// to see if the error is resolved in which case CloudFront returns an APPROVED or SUSPENDED status.</p>
        /// </li>
        /// </ul>
        pub fn set_icp_recordal_status(
            mut self,
            input: std::option::Option<crate::model::IcpRecordalStatus>,
        ) -> Self {
            self.icp_recordal_status = input;
            self
        }
        /// Consumes the builder and constructs a [`AliasIcpRecordal`](crate::model::AliasIcpRecordal)
        pub fn build(self) -> crate::model::AliasIcpRecordal {
            crate::model::AliasIcpRecordal {
                cname: self.cname,
                icp_recordal_status: self.icp_recordal_status,
            }
        }
    }
}
impl AliasIcpRecordal {
    /// Creates a new builder-style object to manufacture [`AliasIcpRecordal`](crate::model::AliasIcpRecordal)
    pub fn builder() -> crate::model::alias_icp_recordal::Builder {
        crate::model::alias_icp_recordal::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum IcpRecordalStatus {
    #[allow(missing_docs)] // documentation missing in model
    Approved,
    #[allow(missing_docs)] // documentation missing in model
    Pending,
    #[allow(missing_docs)] // documentation missing in model
    Suspended,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for IcpRecordalStatus {
    fn from(s: &str) -> Self {
        match s {
            "APPROVED" => IcpRecordalStatus::Approved,
            "PENDING" => IcpRecordalStatus::Pending,
            "SUSPENDED" => IcpRecordalStatus::Suspended,
            other => IcpRecordalStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for IcpRecordalStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(IcpRecordalStatus::from(s))
    }
}
impl IcpRecordalStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            IcpRecordalStatus::Approved => "APPROVED",
            IcpRecordalStatus::Pending => "PENDING",
            IcpRecordalStatus::Suspended => "SUSPENDED",
            IcpRecordalStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["APPROVED", "PENDING", "SUSPENDED"]
    }
}
impl AsRef<str> for IcpRecordalStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>A distribution configuration.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DistributionConfig {
    /// <p>A unique value (for example, a date-time stamp) that ensures that the request can't be
    /// replayed.</p>
    /// <p>If the value of <code>CallerReference</code> is new (regardless of the content of the
    /// <code>DistributionConfig</code> object), CloudFront creates a new distribution.</p>
    /// <p>If <code>CallerReference</code> is a value that you already sent in a previous request to
    /// create a distribution, CloudFront returns a <code>DistributionAlreadyExists</code> error.</p>
    pub caller_reference: std::option::Option<std::string::String>,
    /// <p>A complex type that contains information about CNAMEs (alternate domain names), if any,
    /// for this distribution.</p>
    pub aliases: std::option::Option<crate::model::Aliases>,
    /// <p>The object that you want CloudFront to request from your origin (for example,
    /// <code>index.html</code>) when a viewer requests the root URL for your distribution
    /// (<code>http://www.example.com</code>) instead of an object in your distribution
    /// (<code>http://www.example.com/product-description.html</code>). Specifying a default root
    /// object avoids exposing the contents of your distribution.</p>
    /// <p>Specify only the object name, for example, <code>index.html</code>. Don't add a
    /// <code>/</code> before the object name.</p>
    /// <p>If you don't want to specify a default root object when you create a distribution,
    /// include an empty <code>DefaultRootObject</code> element.</p>
    /// <p>To delete the default root object from an existing distribution, update the
    /// distribution configuration and include an empty <code>DefaultRootObject</code>
    /// element.</p>
    /// <p>To replace the default root object, update the distribution configuration and specify
    /// the new object.</p>
    /// <p>For more information about the default root object, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/DefaultRootObject.html">Creating a Default Root Object</a> in the
    /// <i>Amazon CloudFront Developer Guide</i>.</p>
    pub default_root_object: std::option::Option<std::string::String>,
    /// <p>A complex type that contains information about origins for this distribution.
    /// </p>
    pub origins: std::option::Option<crate::model::Origins>,
    /// <p> A complex type that contains information about origin groups for this
    /// distribution.</p>
    pub origin_groups: std::option::Option<crate::model::OriginGroups>,
    /// <p>A complex type that describes the default cache behavior if you don't specify a
    /// <code>CacheBehavior</code> element or if files don't match any of the values of
    /// <code>PathPattern</code> in <code>CacheBehavior</code> elements. You must create exactly one
    /// default cache behavior.</p>
    pub default_cache_behavior: std::option::Option<crate::model::DefaultCacheBehavior>,
    /// <p>A complex type that contains zero or more <code>CacheBehavior</code> elements.
    /// </p>
    pub cache_behaviors: std::option::Option<crate::model::CacheBehaviors>,
    /// <p>A complex type that controls the following:</p>
    /// <ul>
    /// <li>
    /// <p>Whether CloudFront replaces HTTP status codes in the 4xx and 5xx range with custom error
    /// messages before returning the response to the viewer.</p>
    /// </li>
    /// <li>
    /// <p>How long CloudFront caches HTTP status codes in the 4xx and 5xx range.</p>
    /// </li>
    /// </ul>
    /// <p>For more information about custom error pages, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/custom-error-pages.html">Customizing Error Responses</a> in the
    /// <i>Amazon CloudFront Developer Guide</i>.</p>
    pub custom_error_responses: std::option::Option<crate::model::CustomErrorResponses>,
    /// <p>An optional comment to describe the distribution. The comment cannot be longer than 128
    /// characters.</p>
    pub comment: std::option::Option<std::string::String>,
    /// <p>A complex type that controls whether access logs are written for the
    /// distribution.</p>
    /// <p>For more information about logging, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/AccessLogs.html">Access
    /// Logs</a> in the <i>Amazon CloudFront Developer Guide</i>.</p>
    pub logging: std::option::Option<crate::model::LoggingConfig>,
    /// <p>The price class that corresponds with the maximum price that you want to pay for CloudFront
    /// service. If you specify <code>PriceClass_All</code>, CloudFront responds to requests for your
    /// objects from all CloudFront edge locations.</p>
    /// <p>If you specify a price class other than <code>PriceClass_All</code>, CloudFront serves your
    /// objects from the CloudFront edge location that has the lowest latency among the edge locations in
    /// your price class. Viewers who are in or near regions that are excluded from your specified
    /// price class may encounter slower performance.</p>
    /// <p>For more information about price classes, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PriceClass.html">Choosing the Price Class
    /// for a CloudFront Distribution</a> in the <i>Amazon CloudFront Developer Guide</i>. For
    /// information about CloudFront pricing, including how price classes (such as Price Class 100)
    /// map to CloudFront regions, see <a href="http://aws.amazon.com/cloudfront/pricing/">Amazon CloudFront
    /// Pricing</a>.</p>
    pub price_class: std::option::Option<crate::model::PriceClass>,
    /// <p>From this field, you can enable or disable the selected distribution.</p>
    pub enabled: std::option::Option<bool>,
    /// <p>A complex type that determines the distribution’s SSL/TLS configuration for
    /// communicating with viewers.</p>
    pub viewer_certificate: std::option::Option<crate::model::ViewerCertificate>,
    /// <p>A complex type that identifies ways in which you want to restrict distribution of your
    /// content.</p>
    pub restrictions: std::option::Option<crate::model::Restrictions>,
    /// <p>A unique identifier that specifies the WAF web ACL, if any, to associate
    /// with this distribution. To specify a web ACL created using the latest version of
    /// WAF, use the ACL ARN, for example
    /// <code>arn:aws:wafv2:us-east-1:123456789012:global/webacl/ExampleWebACL/473e64fd-f30b-4765-81a0-62ad96dd167a</code>.
    /// To specify a web ACL created using WAF Classic, use the ACL ID, for example
    /// <code>473e64fd-f30b-4765-81a0-62ad96dd167a</code>.</p>
    /// <p>WAF is a web application firewall that lets you monitor the HTTP and HTTPS
    /// requests that are forwarded to CloudFront, and lets you control access to your content. Based on
    /// conditions that you specify, such as the IP addresses that requests originate from or the
    /// values of query strings, CloudFront responds to requests either with the requested content or with
    /// an HTTP 403 status code (Forbidden). You can also configure CloudFront to return a custom error page
    /// when a request is blocked. For more information about WAF, see the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/what-is-aws-waf.html">WAF
    /// Developer Guide</a>. </p>
    pub web_acl_id: std::option::Option<std::string::String>,
    /// <p>(Optional) Specify the maximum HTTP version that you want viewers to use to communicate
    /// with CloudFront. The default value for new web distributions is http2. Viewers that don't support
    /// HTTP/2 automatically use an earlier HTTP version.</p>
    /// <p>For viewers and CloudFront to use HTTP/2, viewers must support TLS 1.2 or later, and must
    /// support Server Name Identification (SNI).</p>
    /// <p>In general, configuring CloudFront to communicate with viewers using HTTP/2 reduces latency.
    /// You can improve performance by optimizing for HTTP/2. For more information, do an Internet
    /// search for "http/2 optimization." </p>
    pub http_version: std::option::Option<crate::model::HttpVersion>,
    /// <p>If you want CloudFront to respond to IPv6 DNS requests with an IPv6 address for your
    /// distribution, specify <code>true</code>. If you specify <code>false</code>, CloudFront responds to
    /// IPv6 DNS requests with the DNS response code <code>NOERROR</code> and with no IP addresses.
    /// This allows viewers to submit a second request, for an IPv4 address for your distribution. </p>
    /// <p>In general, you should enable IPv6 if you have users on IPv6 networks who want to
    /// access your content. However, if you're using signed URLs or signed cookies to restrict access
    /// to your content, and if you're using a custom policy that includes the <code>IpAddress</code>
    /// parameter to restrict the IP addresses that can access your content, don't enable IPv6. If
    /// you want to restrict access to some content by IP address and not restrict access to other
    /// content (or restrict access but not by IP address), you can create two distributions. For more
    /// information, see  
    /// <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/private-content-creating-signed-url-custom-policy.html">Creating a Signed URL Using a Custom Policy</a> in the <i>Amazon CloudFront Developer Guide</i>.</p>
    /// <p>If you're using an Route 53 Amazon Web Services Integration alias resource record set to route traffic to your CloudFront
    /// distribution, you need to create a second alias resource record set when both of the following
    /// are true:</p>
    /// <ul>
    /// <li>
    /// <p>You enable IPv6 for the distribution</p>
    /// </li>
    /// <li>
    /// <p>You're using alternate domain names in the URLs for your objects</p>
    /// </li>
    /// </ul>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/routing-to-cloudfront-distribution.html">Routing Traffic
    /// to an Amazon CloudFront Web Distribution by Using Your Domain Name</a> in the <i>Route 53 Amazon Web Services Integration
    /// Developer Guide</i>.</p>
    /// <p>If you created a CNAME resource record set, either with Route 53 Amazon Web Services Integration or with another DNS
    /// service, you don't need to make any changes. A CNAME record will route traffic to your
    /// distribution regardless of the IP address format of the viewer request.</p>
    pub is_ipv6_enabled: std::option::Option<bool>,
}
impl DistributionConfig {
    /// <p>A unique value (for example, a date-time stamp) that ensures that the request can't be
    /// replayed.</p>
    /// <p>If the value of <code>CallerReference</code> is new (regardless of the content of the
    /// <code>DistributionConfig</code> object), CloudFront creates a new distribution.</p>
    /// <p>If <code>CallerReference</code> is a value that you already sent in a previous request to
    /// create a distribution, CloudFront returns a <code>DistributionAlreadyExists</code> error.</p>
    pub fn caller_reference(&self) -> std::option::Option<&str> {
        self.caller_reference.as_deref()
    }
    /// <p>A complex type that contains information about CNAMEs (alternate domain names), if any,
    /// for this distribution.</p>
    pub fn aliases(&self) -> std::option::Option<&crate::model::Aliases> {
        self.aliases.as_ref()
    }
    /// <p>The object that you want CloudFront to request from your origin (for example,
    /// <code>index.html</code>) when a viewer requests the root URL for your distribution
    /// (<code>http://www.example.com</code>) instead of an object in your distribution
    /// (<code>http://www.example.com/product-description.html</code>). Specifying a default root
    /// object avoids exposing the contents of your distribution.</p>
    /// <p>Specify only the object name, for example, <code>index.html</code>. Don't add a
    /// <code>/</code> before the object name.</p>
    /// <p>If you don't want to specify a default root object when you create a distribution,
    /// include an empty <code>DefaultRootObject</code> element.</p>
    /// <p>To delete the default root object from an existing distribution, update the
    /// distribution configuration and include an empty <code>DefaultRootObject</code>
    /// element.</p>
    /// <p>To replace the default root object, update the distribution configuration and specify
    /// the new object.</p>
    /// <p>For more information about the default root object, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/DefaultRootObject.html">Creating a Default Root Object</a> in the
    /// <i>Amazon CloudFront Developer Guide</i>.</p>
    pub fn default_root_object(&self) -> std::option::Option<&str> {
        self.default_root_object.as_deref()
    }
    /// <p>A complex type that contains information about origins for this distribution.
    /// </p>
    pub fn origins(&self) -> std::option::Option<&crate::model::Origins> {
        self.origins.as_ref()
    }
    /// <p> A complex type that contains information about origin groups for this
    /// distribution.</p>
    pub fn origin_groups(&self) -> std::option::Option<&crate::model::OriginGroups> {
        self.origin_groups.as_ref()
    }
    /// <p>A complex type that describes the default cache behavior if you don't specify a
    /// <code>CacheBehavior</code> element or if files don't match any of the values of
    /// <code>PathPattern</code> in <code>CacheBehavior</code> elements. You must create exactly one
    /// default cache behavior.</p>
    pub fn default_cache_behavior(
        &self,
    ) -> std::option::Option<&crate::model::DefaultCacheBehavior> {
        self.default_cache_behavior.as_ref()
    }
    /// <p>A complex type that contains zero or more <code>CacheBehavior</code> elements.
    /// </p>
    pub fn cache_behaviors(&self) -> std::option::Option<&crate::model::CacheBehaviors> {
        self.cache_behaviors.as_ref()
    }
    /// <p>A complex type that controls the following:</p>
    /// <ul>
    /// <li>
    /// <p>Whether CloudFront replaces HTTP status codes in the 4xx and 5xx range with custom error
    /// messages before returning the response to the viewer.</p>
    /// </li>
    /// <li>
    /// <p>How long CloudFront caches HTTP status codes in the 4xx and 5xx range.</p>
    /// </li>
    /// </ul>
    /// <p>For more information about custom error pages, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/custom-error-pages.html">Customizing Error Responses</a> in the
    /// <i>Amazon CloudFront Developer Guide</i>.</p>
    pub fn custom_error_responses(
        &self,
    ) -> std::option::Option<&crate::model::CustomErrorResponses> {
        self.custom_error_responses.as_ref()
    }
    /// <p>An optional comment to describe the distribution. The comment cannot be longer than 128
    /// characters.</p>
    pub fn comment(&self) -> std::option::Option<&str> {
        self.comment.as_deref()
    }
    /// <p>A complex type that controls whether access logs are written for the
    /// distribution.</p>
    /// <p>For more information about logging, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/AccessLogs.html">Access
    /// Logs</a> in the <i>Amazon CloudFront Developer Guide</i>.</p>
    pub fn logging(&self) -> std::option::Option<&crate::model::LoggingConfig> {
        self.logging.as_ref()
    }
    /// <p>The price class that corresponds with the maximum price that you want to pay for CloudFront
    /// service. If you specify <code>PriceClass_All</code>, CloudFront responds to requests for your
    /// objects from all CloudFront edge locations.</p>
    /// <p>If you specify a price class other than <code>PriceClass_All</code>, CloudFront serves your
    /// objects from the CloudFront edge location that has the lowest latency among the edge locations in
    /// your price class. Viewers who are in or near regions that are excluded from your specified
    /// price class may encounter slower performance.</p>
    /// <p>For more information about price classes, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PriceClass.html">Choosing the Price Class
    /// for a CloudFront Distribution</a> in the <i>Amazon CloudFront Developer Guide</i>. For
    /// information about CloudFront pricing, including how price classes (such as Price Class 100)
    /// map to CloudFront regions, see <a href="http://aws.amazon.com/cloudfront/pricing/">Amazon CloudFront
    /// Pricing</a>.</p>
    pub fn price_class(&self) -> std::option::Option<&crate::model::PriceClass> {
        self.price_class.as_ref()
    }
    /// <p>From this field, you can enable or disable the selected distribution.</p>
    pub fn enabled(&self) -> std::option::Option<bool> {
        self.enabled
    }
    /// <p>A complex type that determines the distribution’s SSL/TLS configuration for
    /// communicating with viewers.</p>
    pub fn viewer_certificate(&self) -> std::option::Option<&crate::model::ViewerCertificate> {
        self.viewer_certificate.as_ref()
    }
    /// <p>A complex type that identifies ways in which you want to restrict distribution of your
    /// content.</p>
    pub fn restrictions(&self) -> std::option::Option<&crate::model::Restrictions> {
        self.restrictions.as_ref()
    }
    /// <p>A unique identifier that specifies the WAF web ACL, if any, to associate
    /// with this distribution. To specify a web ACL created using the latest version of
    /// WAF, use the ACL ARN, for example
    /// <code>arn:aws:wafv2:us-east-1:123456789012:global/webacl/ExampleWebACL/473e64fd-f30b-4765-81a0-62ad96dd167a</code>.
    /// To specify a web ACL created using WAF Classic, use the ACL ID, for example
    /// <code>473e64fd-f30b-4765-81a0-62ad96dd167a</code>.</p>
    /// <p>WAF is a web application firewall that lets you monitor the HTTP and HTTPS
    /// requests that are forwarded to CloudFront, and lets you control access to your content. Based on
    /// conditions that you specify, such as the IP addresses that requests originate from or the
    /// values of query strings, CloudFront responds to requests either with the requested content or with
    /// an HTTP 403 status code (Forbidden). You can also configure CloudFront to return a custom error page
    /// when a request is blocked. For more information about WAF, see the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/what-is-aws-waf.html">WAF
    /// Developer Guide</a>. </p>
    pub fn web_acl_id(&self) -> std::option::Option<&str> {
        self.web_acl_id.as_deref()
    }
    /// <p>(Optional) Specify the maximum HTTP version that you want viewers to use to communicate
    /// with CloudFront. The default value for new web distributions is http2. Viewers that don't support
    /// HTTP/2 automatically use an earlier HTTP version.</p>
    /// <p>For viewers and CloudFront to use HTTP/2, viewers must support TLS 1.2 or later, and must
    /// support Server Name Identification (SNI).</p>
    /// <p>In general, configuring CloudFront to communicate with viewers using HTTP/2 reduces latency.
    /// You can improve performance by optimizing for HTTP/2. For more information, do an Internet
    /// search for "http/2 optimization." </p>
    pub fn http_version(&self) -> std::option::Option<&crate::model::HttpVersion> {
        self.http_version.as_ref()
    }
    /// <p>If you want CloudFront to respond to IPv6 DNS requests with an IPv6 address for your
    /// distribution, specify <code>true</code>. If you specify <code>false</code>, CloudFront responds to
    /// IPv6 DNS requests with the DNS response code <code>NOERROR</code> and with no IP addresses.
    /// This allows viewers to submit a second request, for an IPv4 address for your distribution. </p>
    /// <p>In general, you should enable IPv6 if you have users on IPv6 networks who want to
    /// access your content. However, if you're using signed URLs or signed cookies to restrict access
    /// to your content, and if you're using a custom policy that includes the <code>IpAddress</code>
    /// parameter to restrict the IP addresses that can access your content, don't enable IPv6. If
    /// you want to restrict access to some content by IP address and not restrict access to other
    /// content (or restrict access but not by IP address), you can create two distributions. For more
    /// information, see  
    /// <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/private-content-creating-signed-url-custom-policy.html">Creating a Signed URL Using a Custom Policy</a> in the <i>Amazon CloudFront Developer Guide</i>.</p>
    /// <p>If you're using an Route 53 Amazon Web Services Integration alias resource record set to route traffic to your CloudFront
    /// distribution, you need to create a second alias resource record set when both of the following
    /// are true:</p>
    /// <ul>
    /// <li>
    /// <p>You enable IPv6 for the distribution</p>
    /// </li>
    /// <li>
    /// <p>You're using alternate domain names in the URLs for your objects</p>
    /// </li>
    /// </ul>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/routing-to-cloudfront-distribution.html">Routing Traffic
    /// to an Amazon CloudFront Web Distribution by Using Your Domain Name</a> in the <i>Route 53 Amazon Web Services Integration
    /// Developer Guide</i>.</p>
    /// <p>If you created a CNAME resource record set, either with Route 53 Amazon Web Services Integration or with another DNS
    /// service, you don't need to make any changes. A CNAME record will route traffic to your
    /// distribution regardless of the IP address format of the viewer request.</p>
    pub fn is_ipv6_enabled(&self) -> std::option::Option<bool> {
        self.is_ipv6_enabled
    }
}
impl std::fmt::Debug for DistributionConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DistributionConfig");
        formatter.field("caller_reference", &self.caller_reference);
        formatter.field("aliases", &self.aliases);
        formatter.field("default_root_object", &self.default_root_object);
        formatter.field("origins", &self.origins);
        formatter.field("origin_groups", &self.origin_groups);
        formatter.field("default_cache_behavior", &self.default_cache_behavior);
        formatter.field("cache_behaviors", &self.cache_behaviors);
        formatter.field("custom_error_responses", &self.custom_error_responses);
        formatter.field("comment", &"*** Sensitive Data Redacted ***");
        formatter.field("logging", &self.logging);
        formatter.field("price_class", &self.price_class);
        formatter.field("enabled", &self.enabled);
        formatter.field("viewer_certificate", &self.viewer_certificate);
        formatter.field("restrictions", &self.restrictions);
        formatter.field("web_acl_id", &self.web_acl_id);
        formatter.field("http_version", &self.http_version);
        formatter.field("is_ipv6_enabled", &self.is_ipv6_enabled);
        formatter.finish()
    }
}
/// See [`DistributionConfig`](crate::model::DistributionConfig)
pub mod distribution_config {
    /// A builder for [`DistributionConfig`](crate::model::DistributionConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) caller_reference: std::option::Option<std::string::String>,
        pub(crate) aliases: std::option::Option<crate::model::Aliases>,
        pub(crate) default_root_object: std::option::Option<std::string::String>,
        pub(crate) origins: std::option::Option<crate::model::Origins>,
        pub(crate) origin_groups: std::option::Option<crate::model::OriginGroups>,
        pub(crate) default_cache_behavior: std::option::Option<crate::model::DefaultCacheBehavior>,
        pub(crate) cache_behaviors: std::option::Option<crate::model::CacheBehaviors>,
        pub(crate) custom_error_responses: std::option::Option<crate::model::CustomErrorResponses>,
        pub(crate) comment: std::option::Option<std::string::String>,
        pub(crate) logging: std::option::Option<crate::model::LoggingConfig>,
        pub(crate) price_class: std::option::Option<crate::model::PriceClass>,
        pub(crate) enabled: std::option::Option<bool>,
        pub(crate) viewer_certificate: std::option::Option<crate::model::ViewerCertificate>,
        pub(crate) restrictions: std::option::Option<crate::model::Restrictions>,
        pub(crate) web_acl_id: std::option::Option<std::string::String>,
        pub(crate) http_version: std::option::Option<crate::model::HttpVersion>,
        pub(crate) is_ipv6_enabled: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>A unique value (for example, a date-time stamp) that ensures that the request can't be
        /// replayed.</p>
        /// <p>If the value of <code>CallerReference</code> is new (regardless of the content of the
        /// <code>DistributionConfig</code> object), CloudFront creates a new distribution.</p>
        /// <p>If <code>CallerReference</code> is a value that you already sent in a previous request to
        /// create a distribution, CloudFront returns a <code>DistributionAlreadyExists</code> error.</p>
        pub fn caller_reference(mut self, input: impl Into<std::string::String>) -> Self {
            self.caller_reference = Some(input.into());
            self
        }
        /// <p>A unique value (for example, a date-time stamp) that ensures that the request can't be
        /// replayed.</p>
        /// <p>If the value of <code>CallerReference</code> is new (regardless of the content of the
        /// <code>DistributionConfig</code> object), CloudFront creates a new distribution.</p>
        /// <p>If <code>CallerReference</code> is a value that you already sent in a previous request to
        /// create a distribution, CloudFront returns a <code>DistributionAlreadyExists</code> error.</p>
        pub fn set_caller_reference(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.caller_reference = input;
            self
        }
        /// <p>A complex type that contains information about CNAMEs (alternate domain names), if any,
        /// for this distribution.</p>
        pub fn aliases(mut self, input: crate::model::Aliases) -> Self {
            self.aliases = Some(input);
            self
        }
        /// <p>A complex type that contains information about CNAMEs (alternate domain names), if any,
        /// for this distribution.</p>
        pub fn set_aliases(mut self, input: std::option::Option<crate::model::Aliases>) -> Self {
            self.aliases = input;
            self
        }
        /// <p>The object that you want CloudFront to request from your origin (for example,
        /// <code>index.html</code>) when a viewer requests the root URL for your distribution
        /// (<code>http://www.example.com</code>) instead of an object in your distribution
        /// (<code>http://www.example.com/product-description.html</code>). Specifying a default root
        /// object avoids exposing the contents of your distribution.</p>
        /// <p>Specify only the object name, for example, <code>index.html</code>. Don't add a
        /// <code>/</code> before the object name.</p>
        /// <p>If you don't want to specify a default root object when you create a distribution,
        /// include an empty <code>DefaultRootObject</code> element.</p>
        /// <p>To delete the default root object from an existing distribution, update the
        /// distribution configuration and include an empty <code>DefaultRootObject</code>
        /// element.</p>
        /// <p>To replace the default root object, update the distribution configuration and specify
        /// the new object.</p>
        /// <p>For more information about the default root object, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/DefaultRootObject.html">Creating a Default Root Object</a> in the
        /// <i>Amazon CloudFront Developer Guide</i>.</p>
        pub fn default_root_object(mut self, input: impl Into<std::string::String>) -> Self {
            self.default_root_object = Some(input.into());
            self
        }
        /// <p>The object that you want CloudFront to request from your origin (for example,
        /// <code>index.html</code>) when a viewer requests the root URL for your distribution
        /// (<code>http://www.example.com</code>) instead of an object in your distribution
        /// (<code>http://www.example.com/product-description.html</code>). Specifying a default root
        /// object avoids exposing the contents of your distribution.</p>
        /// <p>Specify only the object name, for example, <code>index.html</code>. Don't add a
        /// <code>/</code> before the object name.</p>
        /// <p>If you don't want to specify a default root object when you create a distribution,
        /// include an empty <code>DefaultRootObject</code> element.</p>
        /// <p>To delete the default root object from an existing distribution, update the
        /// distribution configuration and include an empty <code>DefaultRootObject</code>
        /// element.</p>
        /// <p>To replace the default root object, update the distribution configuration and specify
        /// the new object.</p>
        /// <p>For more information about the default root object, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/DefaultRootObject.html">Creating a Default Root Object</a> in the
        /// <i>Amazon CloudFront Developer Guide</i>.</p>
        pub fn set_default_root_object(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.default_root_object = input;
            self
        }
        /// <p>A complex type that contains information about origins for this distribution.
        /// </p>
        pub fn origins(mut self, input: crate::model::Origins) -> Self {
            self.origins = Some(input);
            self
        }
        /// <p>A complex type that contains information about origins for this distribution.
        /// </p>
        pub fn set_origins(mut self, input: std::option::Option<crate::model::Origins>) -> Self {
            self.origins = input;
            self
        }
        /// <p> A complex type that contains information about origin groups for this
        /// distribution.</p>
        pub fn origin_groups(mut self, input: crate::model::OriginGroups) -> Self {
            self.origin_groups = Some(input);
            self
        }
        /// <p> A complex type that contains information about origin groups for this
        /// distribution.</p>
        pub fn set_origin_groups(
            mut self,
            input: std::option::Option<crate::model::OriginGroups>,
        ) -> Self {
            self.origin_groups = input;
            self
        }
        /// <p>A complex type that describes the default cache behavior if you don't specify a
        /// <code>CacheBehavior</code> element or if files don't match any of the values of
        /// <code>PathPattern</code> in <code>CacheBehavior</code> elements. You must create exactly one
        /// default cache behavior.</p>
        pub fn default_cache_behavior(mut self, input: crate::model::DefaultCacheBehavior) -> Self {
            self.default_cache_behavior = Some(input);
            self
        }
        /// <p>A complex type that describes the default cache behavior if you don't specify a
        /// <code>CacheBehavior</code> element or if files don't match any of the values of
        /// <code>PathPattern</code> in <code>CacheBehavior</code> elements. You must create exactly one
        /// default cache behavior.</p>
        pub fn set_default_cache_behavior(
            mut self,
            input: std::option::Option<crate::model::DefaultCacheBehavior>,
        ) -> Self {
            self.default_cache_behavior = input;
            self
        }
        /// <p>A complex type that contains zero or more <code>CacheBehavior</code> elements.
        /// </p>
        pub fn cache_behaviors(mut self, input: crate::model::CacheBehaviors) -> Self {
            self.cache_behaviors = Some(input);
            self
        }
        /// <p>A complex type that contains zero or more <code>CacheBehavior</code> elements.
        /// </p>
        pub fn set_cache_behaviors(
            mut self,
            input: std::option::Option<crate::model::CacheBehaviors>,
        ) -> Self {
            self.cache_behaviors = input;
            self
        }
        /// <p>A complex type that controls the following:</p>
        /// <ul>
        /// <li>
        /// <p>Whether CloudFront replaces HTTP status codes in the 4xx and 5xx range with custom error
        /// messages before returning the response to the viewer.</p>
        /// </li>
        /// <li>
        /// <p>How long CloudFront caches HTTP status codes in the 4xx and 5xx range.</p>
        /// </li>
        /// </ul>
        /// <p>For more information about custom error pages, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/custom-error-pages.html">Customizing Error Responses</a> in the
        /// <i>Amazon CloudFront Developer Guide</i>.</p>
        pub fn custom_error_responses(mut self, input: crate::model::CustomErrorResponses) -> Self {
            self.custom_error_responses = Some(input);
            self
        }
        /// <p>A complex type that controls the following:</p>
        /// <ul>
        /// <li>
        /// <p>Whether CloudFront replaces HTTP status codes in the 4xx and 5xx range with custom error
        /// messages before returning the response to the viewer.</p>
        /// </li>
        /// <li>
        /// <p>How long CloudFront caches HTTP status codes in the 4xx and 5xx range.</p>
        /// </li>
        /// </ul>
        /// <p>For more information about custom error pages, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/custom-error-pages.html">Customizing Error Responses</a> in the
        /// <i>Amazon CloudFront Developer Guide</i>.</p>
        pub fn set_custom_error_responses(
            mut self,
            input: std::option::Option<crate::model::CustomErrorResponses>,
        ) -> Self {
            self.custom_error_responses = input;
            self
        }
        /// <p>An optional comment to describe the distribution. The comment cannot be longer than 128
        /// characters.</p>
        pub fn comment(mut self, input: impl Into<std::string::String>) -> Self {
            self.comment = Some(input.into());
            self
        }
        /// <p>An optional comment to describe the distribution. The comment cannot be longer than 128
        /// characters.</p>
        pub fn set_comment(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.comment = input;
            self
        }
        /// <p>A complex type that controls whether access logs are written for the
        /// distribution.</p>
        /// <p>For more information about logging, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/AccessLogs.html">Access
        /// Logs</a> in the <i>Amazon CloudFront Developer Guide</i>.</p>
        pub fn logging(mut self, input: crate::model::LoggingConfig) -> Self {
            self.logging = Some(input);
            self
        }
        /// <p>A complex type that controls whether access logs are written for the
        /// distribution.</p>
        /// <p>For more information about logging, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/AccessLogs.html">Access
        /// Logs</a> in the <i>Amazon CloudFront Developer Guide</i>.</p>
        pub fn set_logging(
            mut self,
            input: std::option::Option<crate::model::LoggingConfig>,
        ) -> Self {
            self.logging = input;
            self
        }
        /// <p>The price class that corresponds with the maximum price that you want to pay for CloudFront
        /// service. If you specify <code>PriceClass_All</code>, CloudFront responds to requests for your
        /// objects from all CloudFront edge locations.</p>
        /// <p>If you specify a price class other than <code>PriceClass_All</code>, CloudFront serves your
        /// objects from the CloudFront edge location that has the lowest latency among the edge locations in
        /// your price class. Viewers who are in or near regions that are excluded from your specified
        /// price class may encounter slower performance.</p>
        /// <p>For more information about price classes, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PriceClass.html">Choosing the Price Class
        /// for a CloudFront Distribution</a> in the <i>Amazon CloudFront Developer Guide</i>. For
        /// information about CloudFront pricing, including how price classes (such as Price Class 100)
        /// map to CloudFront regions, see <a href="http://aws.amazon.com/cloudfront/pricing/">Amazon CloudFront
        /// Pricing</a>.</p>
        pub fn price_class(mut self, input: crate::model::PriceClass) -> Self {
            self.price_class = Some(input);
            self
        }
        /// <p>The price class that corresponds with the maximum price that you want to pay for CloudFront
        /// service. If you specify <code>PriceClass_All</code>, CloudFront responds to requests for your
        /// objects from all CloudFront edge locations.</p>
        /// <p>If you specify a price class other than <code>PriceClass_All</code>, CloudFront serves your
        /// objects from the CloudFront edge location that has the lowest latency among the edge locations in
        /// your price class. Viewers who are in or near regions that are excluded from your specified
        /// price class may encounter slower performance.</p>
        /// <p>For more information about price classes, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PriceClass.html">Choosing the Price Class
        /// for a CloudFront Distribution</a> in the <i>Amazon CloudFront Developer Guide</i>. For
        /// information about CloudFront pricing, including how price classes (such as Price Class 100)
        /// map to CloudFront regions, see <a href="http://aws.amazon.com/cloudfront/pricing/">Amazon CloudFront
        /// Pricing</a>.</p>
        pub fn set_price_class(
            mut self,
            input: std::option::Option<crate::model::PriceClass>,
        ) -> Self {
            self.price_class = input;
            self
        }
        /// <p>From this field, you can enable or disable the selected distribution.</p>
        pub fn enabled(mut self, input: bool) -> Self {
            self.enabled = Some(input);
            self
        }
        /// <p>From this field, you can enable or disable the selected distribution.</p>
        pub fn set_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.enabled = input;
            self
        }
        /// <p>A complex type that determines the distribution’s SSL/TLS configuration for
        /// communicating with viewers.</p>
        pub fn viewer_certificate(mut self, input: crate::model::ViewerCertificate) -> Self {
            self.viewer_certificate = Some(input);
            self
        }
        /// <p>A complex type that determines the distribution’s SSL/TLS configuration for
        /// communicating with viewers.</p>
        pub fn set_viewer_certificate(
            mut self,
            input: std::option::Option<crate::model::ViewerCertificate>,
        ) -> Self {
            self.viewer_certificate = input;
            self
        }
        /// <p>A complex type that identifies ways in which you want to restrict distribution of your
        /// content.</p>
        pub fn restrictions(mut self, input: crate::model::Restrictions) -> Self {
            self.restrictions = Some(input);
            self
        }
        /// <p>A complex type that identifies ways in which you want to restrict distribution of your
        /// content.</p>
        pub fn set_restrictions(
            mut self,
            input: std::option::Option<crate::model::Restrictions>,
        ) -> Self {
            self.restrictions = input;
            self
        }
        /// <p>A unique identifier that specifies the WAF web ACL, if any, to associate
        /// with this distribution. To specify a web ACL created using the latest version of
        /// WAF, use the ACL ARN, for example
        /// <code>arn:aws:wafv2:us-east-1:123456789012:global/webacl/ExampleWebACL/473e64fd-f30b-4765-81a0-62ad96dd167a</code>.
        /// To specify a web ACL created using WAF Classic, use the ACL ID, for example
        /// <code>473e64fd-f30b-4765-81a0-62ad96dd167a</code>.</p>
        /// <p>WAF is a web application firewall that lets you monitor the HTTP and HTTPS
        /// requests that are forwarded to CloudFront, and lets you control access to your content. Based on
        /// conditions that you specify, such as the IP addresses that requests originate from or the
        /// values of query strings, CloudFront responds to requests either with the requested content or with
        /// an HTTP 403 status code (Forbidden). You can also configure CloudFront to return a custom error page
        /// when a request is blocked. For more information about WAF, see the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/what-is-aws-waf.html">WAF
        /// Developer Guide</a>. </p>
        pub fn web_acl_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.web_acl_id = Some(input.into());
            self
        }
        /// <p>A unique identifier that specifies the WAF web ACL, if any, to associate
        /// with this distribution. To specify a web ACL created using the latest version of
        /// WAF, use the ACL ARN, for example
        /// <code>arn:aws:wafv2:us-east-1:123456789012:global/webacl/ExampleWebACL/473e64fd-f30b-4765-81a0-62ad96dd167a</code>.
        /// To specify a web ACL created using WAF Classic, use the ACL ID, for example
        /// <code>473e64fd-f30b-4765-81a0-62ad96dd167a</code>.</p>
        /// <p>WAF is a web application firewall that lets you monitor the HTTP and HTTPS
        /// requests that are forwarded to CloudFront, and lets you control access to your content. Based on
        /// conditions that you specify, such as the IP addresses that requests originate from or the
        /// values of query strings, CloudFront responds to requests either with the requested content or with
        /// an HTTP 403 status code (Forbidden). You can also configure CloudFront to return a custom error page
        /// when a request is blocked. For more information about WAF, see the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/what-is-aws-waf.html">WAF
        /// Developer Guide</a>. </p>
        pub fn set_web_acl_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.web_acl_id = input;
            self
        }
        /// <p>(Optional) Specify the maximum HTTP version that you want viewers to use to communicate
        /// with CloudFront. The default value for new web distributions is http2. Viewers that don't support
        /// HTTP/2 automatically use an earlier HTTP version.</p>
        /// <p>For viewers and CloudFront to use HTTP/2, viewers must support TLS 1.2 or later, and must
        /// support Server Name Identification (SNI).</p>
        /// <p>In general, configuring CloudFront to communicate with viewers using HTTP/2 reduces latency.
        /// You can improve performance by optimizing for HTTP/2. For more information, do an Internet
        /// search for "http/2 optimization." </p>
        pub fn http_version(mut self, input: crate::model::HttpVersion) -> Self {
            self.http_version = Some(input);
            self
        }
        /// <p>(Optional) Specify the maximum HTTP version that you want viewers to use to communicate
        /// with CloudFront. The default value for new web distributions is http2. Viewers that don't support
        /// HTTP/2 automatically use an earlier HTTP version.</p>
        /// <p>For viewers and CloudFront to use HTTP/2, viewers must support TLS 1.2 or later, and must
        /// support Server Name Identification (SNI).</p>
        /// <p>In general, configuring CloudFront to communicate with viewers using HTTP/2 reduces latency.
        /// You can improve performance by optimizing for HTTP/2. For more information, do an Internet
        /// search for "http/2 optimization." </p>
        pub fn set_http_version(
            mut self,
            input: std::option::Option<crate::model::HttpVersion>,
        ) -> Self {
            self.http_version = input;
            self
        }
        /// <p>If you want CloudFront to respond to IPv6 DNS requests with an IPv6 address for your
        /// distribution, specify <code>true</code>. If you specify <code>false</code>, CloudFront responds to
        /// IPv6 DNS requests with the DNS response code <code>NOERROR</code> and with no IP addresses.
        /// This allows viewers to submit a second request, for an IPv4 address for your distribution. </p>
        /// <p>In general, you should enable IPv6 if you have users on IPv6 networks who want to
        /// access your content. However, if you're using signed URLs or signed cookies to restrict access
        /// to your content, and if you're using a custom policy that includes the <code>IpAddress</code>
        /// parameter to restrict the IP addresses that can access your content, don't enable IPv6. If
        /// you want to restrict access to some content by IP address and not restrict access to other
        /// content (or restrict access but not by IP address), you can create two distributions. For more
        /// information, see  
        /// <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/private-content-creating-signed-url-custom-policy.html">Creating a Signed URL Using a Custom Policy</a> in the <i>Amazon CloudFront Developer Guide</i>.</p>
        /// <p>If you're using an Route 53 Amazon Web Services Integration alias resource record set to route traffic to your CloudFront
        /// distribution, you need to create a second alias resource record set when both of the following
        /// are true:</p>
        /// <ul>
        /// <li>
        /// <p>You enable IPv6 for the distribution</p>
        /// </li>
        /// <li>
        /// <p>You're using alternate domain names in the URLs for your objects</p>
        /// </li>
        /// </ul>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/routing-to-cloudfront-distribution.html">Routing Traffic
        /// to an Amazon CloudFront Web Distribution by Using Your Domain Name</a> in the <i>Route 53 Amazon Web Services Integration
        /// Developer Guide</i>.</p>
        /// <p>If you created a CNAME resource record set, either with Route 53 Amazon Web Services Integration or with another DNS
        /// service, you don't need to make any changes. A CNAME record will route traffic to your
        /// distribution regardless of the IP address format of the viewer request.</p>
        pub fn is_ipv6_enabled(mut self, input: bool) -> Self {
            self.is_ipv6_enabled = Some(input);
            self
        }
        /// <p>If you want CloudFront to respond to IPv6 DNS requests with an IPv6 address for your
        /// distribution, specify <code>true</code>. If you specify <code>false</code>, CloudFront responds to
        /// IPv6 DNS requests with the DNS response code <code>NOERROR</code> and with no IP addresses.
        /// This allows viewers to submit a second request, for an IPv4 address for your distribution. </p>
        /// <p>In general, you should enable IPv6 if you have users on IPv6 networks who want to
        /// access your content. However, if you're using signed URLs or signed cookies to restrict access
        /// to your content, and if you're using a custom policy that includes the <code>IpAddress</code>
        /// parameter to restrict the IP addresses that can access your content, don't enable IPv6. If
        /// you want to restrict access to some content by IP address and not restrict access to other
        /// content (or restrict access but not by IP address), you can create two distributions. For more
        /// information, see  
        /// <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/private-content-creating-signed-url-custom-policy.html">Creating a Signed URL Using a Custom Policy</a> in the <i>Amazon CloudFront Developer Guide</i>.</p>
        /// <p>If you're using an Route 53 Amazon Web Services Integration alias resource record set to route traffic to your CloudFront
        /// distribution, you need to create a second alias resource record set when both of the following
        /// are true:</p>
        /// <ul>
        /// <li>
        /// <p>You enable IPv6 for the distribution</p>
        /// </li>
        /// <li>
        /// <p>You're using alternate domain names in the URLs for your objects</p>
        /// </li>
        /// </ul>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/routing-to-cloudfront-distribution.html">Routing Traffic
        /// to an Amazon CloudFront Web Distribution by Using Your Domain Name</a> in the <i>Route 53 Amazon Web Services Integration
        /// Developer Guide</i>.</p>
        /// <p>If you created a CNAME resource record set, either with Route 53 Amazon Web Services Integration or with another DNS
        /// service, you don't need to make any changes. A CNAME record will route traffic to your
        /// distribution regardless of the IP address format of the viewer request.</p>
        pub fn set_is_ipv6_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.is_ipv6_enabled = input;
            self
        }
        /// Consumes the builder and constructs a [`DistributionConfig`](crate::model::DistributionConfig)
        pub fn build(self) -> crate::model::DistributionConfig {
            crate::model::DistributionConfig {
                caller_reference: self.caller_reference,
                aliases: self.aliases,
                default_root_object: self.default_root_object,
                origins: self.origins,
                origin_groups: self.origin_groups,
                default_cache_behavior: self.default_cache_behavior,
                cache_behaviors: self.cache_behaviors,
                custom_error_responses: self.custom_error_responses,
                comment: self.comment,
                logging: self.logging,
                price_class: self.price_class,
                enabled: self.enabled,
                viewer_certificate: self.viewer_certificate,
                restrictions: self.restrictions,
                web_acl_id: self.web_acl_id,
                http_version: self.http_version,
                is_ipv6_enabled: self.is_ipv6_enabled,
            }
        }
    }
}
impl DistributionConfig {
    /// Creates a new builder-style object to manufacture [`DistributionConfig`](crate::model::DistributionConfig)
    pub fn builder() -> crate::model::distribution_config::Builder {
        crate::model::distribution_config::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum HttpVersion {
    #[allow(missing_docs)] // documentation missing in model
    Http11,
    #[allow(missing_docs)] // documentation missing in model
    Http2,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for HttpVersion {
    fn from(s: &str) -> Self {
        match s {
            "http1.1" => HttpVersion::Http11,
            "http2" => HttpVersion::Http2,
            other => HttpVersion::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for HttpVersion {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(HttpVersion::from(s))
    }
}
impl HttpVersion {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            HttpVersion::Http11 => "http1.1",
            HttpVersion::Http2 => "http2",
            HttpVersion::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["http1.1", "http2"]
    }
}
impl AsRef<str> for HttpVersion {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>A complex type that identifies ways in which you want to restrict distribution of your
/// content.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Restrictions {
    /// <p>A complex type that controls the countries in which your content is distributed. CloudFront
    /// determines the location of your users using <code>MaxMind</code> GeoIP databases.</p>
    pub geo_restriction: std::option::Option<crate::model::GeoRestriction>,
}
impl Restrictions {
    /// <p>A complex type that controls the countries in which your content is distributed. CloudFront
    /// determines the location of your users using <code>MaxMind</code> GeoIP databases.</p>
    pub fn geo_restriction(&self) -> std::option::Option<&crate::model::GeoRestriction> {
        self.geo_restriction.as_ref()
    }
}
impl std::fmt::Debug for Restrictions {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Restrictions");
        formatter.field("geo_restriction", &self.geo_restriction);
        formatter.finish()
    }
}
/// See [`Restrictions`](crate::model::Restrictions)
pub mod restrictions {
    /// A builder for [`Restrictions`](crate::model::Restrictions)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) geo_restriction: std::option::Option<crate::model::GeoRestriction>,
    }
    impl Builder {
        /// <p>A complex type that controls the countries in which your content is distributed. CloudFront
        /// determines the location of your users using <code>MaxMind</code> GeoIP databases.</p>
        pub fn geo_restriction(mut self, input: crate::model::GeoRestriction) -> Self {
            self.geo_restriction = Some(input);
            self
        }
        /// <p>A complex type that controls the countries in which your content is distributed. CloudFront
        /// determines the location of your users using <code>MaxMind</code> GeoIP databases.</p>
        pub fn set_geo_restriction(
            mut self,
            input: std::option::Option<crate::model::GeoRestriction>,
        ) -> Self {
            self.geo_restriction = input;
            self
        }
        /// Consumes the builder and constructs a [`Restrictions`](crate::model::Restrictions)
        pub fn build(self) -> crate::model::Restrictions {
            crate::model::Restrictions {
                geo_restriction: self.geo_restriction,
            }
        }
    }
}
impl Restrictions {
    /// Creates a new builder-style object to manufacture [`Restrictions`](crate::model::Restrictions)
    pub fn builder() -> crate::model::restrictions::Builder {
        crate::model::restrictions::Builder::default()
    }
}

/// <p>A complex type that controls the countries in which your content is distributed. CloudFront
/// determines the location of your users using <code>MaxMind</code> GeoIP databases. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GeoRestriction {
    /// <p>The method that you want to use to restrict distribution of your content by
    /// country:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>none</code>: No geo restriction is enabled, meaning access to content is not
    /// restricted by client geo location.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>blacklist</code>: The <code>Location</code> elements specify the countries in
    /// which you don't want CloudFront to distribute your content.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>whitelist</code>: The <code>Location</code> elements specify the countries in
    /// which you want CloudFront to distribute your content.</p>
    /// </li>
    /// </ul>
    pub restriction_type: std::option::Option<crate::model::GeoRestrictionType>,
    /// <p>When geo restriction is <code>enabled</code>, this is the number of countries in your
    /// <code>whitelist</code> or <code>blacklist</code>. Otherwise, when it is not enabled,
    /// <code>Quantity</code> is <code>0</code>, and you can omit <code>Items</code>.</p>
    pub quantity: std::option::Option<i32>,
    /// <p> A complex type that contains a <code>Location</code> element for each country in which
    /// you want CloudFront either to distribute your content (<code>whitelist</code>) or not distribute
    /// your content (<code>blacklist</code>).</p>
    /// <p>The <code>Location</code> element is a two-letter, uppercase country code for a country
    /// that you want to include in your <code>blacklist</code> or <code>whitelist</code>. Include one
    /// <code>Location</code> element for each country.</p>
    /// <p>CloudFront and <code>MaxMind</code> both use <code>ISO 3166</code> country codes. For the
    /// current list of countries and the corresponding codes, see <code>ISO 3166-1-alpha-2</code>
    /// code on the <i>International Organization for Standardization</i> website. You
    /// can also refer to the country list on the CloudFront console, which includes both country names and
    /// codes.</p>
    pub items: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl GeoRestriction {
    /// <p>The method that you want to use to restrict distribution of your content by
    /// country:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>none</code>: No geo restriction is enabled, meaning access to content is not
    /// restricted by client geo location.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>blacklist</code>: The <code>Location</code> elements specify the countries in
    /// which you don't want CloudFront to distribute your content.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>whitelist</code>: The <code>Location</code> elements specify the countries in
    /// which you want CloudFront to distribute your content.</p>
    /// </li>
    /// </ul>
    pub fn restriction_type(&self) -> std::option::Option<&crate::model::GeoRestrictionType> {
        self.restriction_type.as_ref()
    }
    /// <p>When geo restriction is <code>enabled</code>, this is the number of countries in your
    /// <code>whitelist</code> or <code>blacklist</code>. Otherwise, when it is not enabled,
    /// <code>Quantity</code> is <code>0</code>, and you can omit <code>Items</code>.</p>
    pub fn quantity(&self) -> std::option::Option<i32> {
        self.quantity
    }
    /// <p> A complex type that contains a <code>Location</code> element for each country in which
    /// you want CloudFront either to distribute your content (<code>whitelist</code>) or not distribute
    /// your content (<code>blacklist</code>).</p>
    /// <p>The <code>Location</code> element is a two-letter, uppercase country code for a country
    /// that you want to include in your <code>blacklist</code> or <code>whitelist</code>. Include one
    /// <code>Location</code> element for each country.</p>
    /// <p>CloudFront and <code>MaxMind</code> both use <code>ISO 3166</code> country codes. For the
    /// current list of countries and the corresponding codes, see <code>ISO 3166-1-alpha-2</code>
    /// code on the <i>International Organization for Standardization</i> website. You
    /// can also refer to the country list on the CloudFront console, which includes both country names and
    /// codes.</p>
    pub fn items(&self) -> std::option::Option<&[std::string::String]> {
        self.items.as_deref()
    }
}
impl std::fmt::Debug for GeoRestriction {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GeoRestriction");
        formatter.field("restriction_type", &self.restriction_type);
        formatter.field("quantity", &self.quantity);
        formatter.field("items", &self.items);
        formatter.finish()
    }
}
/// See [`GeoRestriction`](crate::model::GeoRestriction)
pub mod geo_restriction {
    /// A builder for [`GeoRestriction`](crate::model::GeoRestriction)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) restriction_type: std::option::Option<crate::model::GeoRestrictionType>,
        pub(crate) quantity: std::option::Option<i32>,
        pub(crate) items: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The method that you want to use to restrict distribution of your content by
        /// country:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>none</code>: No geo restriction is enabled, meaning access to content is not
        /// restricted by client geo location.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>blacklist</code>: The <code>Location</code> elements specify the countries in
        /// which you don't want CloudFront to distribute your content.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>whitelist</code>: The <code>Location</code> elements specify the countries in
        /// which you want CloudFront to distribute your content.</p>
        /// </li>
        /// </ul>
        pub fn restriction_type(mut self, input: crate::model::GeoRestrictionType) -> Self {
            self.restriction_type = Some(input);
            self
        }
        /// <p>The method that you want to use to restrict distribution of your content by
        /// country:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>none</code>: No geo restriction is enabled, meaning access to content is not
        /// restricted by client geo location.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>blacklist</code>: The <code>Location</code> elements specify the countries in
        /// which you don't want CloudFront to distribute your content.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>whitelist</code>: The <code>Location</code> elements specify the countries in
        /// which you want CloudFront to distribute your content.</p>
        /// </li>
        /// </ul>
        pub fn set_restriction_type(
            mut self,
            input: std::option::Option<crate::model::GeoRestrictionType>,
        ) -> Self {
            self.restriction_type = input;
            self
        }
        /// <p>When geo restriction is <code>enabled</code>, this is the number of countries in your
        /// <code>whitelist</code> or <code>blacklist</code>. Otherwise, when it is not enabled,
        /// <code>Quantity</code> is <code>0</code>, and you can omit <code>Items</code>.</p>
        pub fn quantity(mut self, input: i32) -> Self {
            self.quantity = Some(input);
            self
        }
        /// <p>When geo restriction is <code>enabled</code>, this is the number of countries in your
        /// <code>whitelist</code> or <code>blacklist</code>. Otherwise, when it is not enabled,
        /// <code>Quantity</code> is <code>0</code>, and you can omit <code>Items</code>.</p>
        pub fn set_quantity(mut self, input: std::option::Option<i32>) -> Self {
            self.quantity = input;
            self
        }
        /// Appends an item to `items`.
        ///
        /// To override the contents of this collection use [`set_items`](Self::set_items).
        ///
        /// <p> A complex type that contains a <code>Location</code> element for each country in which
        /// you want CloudFront either to distribute your content (<code>whitelist</code>) or not distribute
        /// your content (<code>blacklist</code>).</p>
        /// <p>The <code>Location</code> element is a two-letter, uppercase country code for a country
        /// that you want to include in your <code>blacklist</code> or <code>whitelist</code>. Include one
        /// <code>Location</code> element for each country.</p>
        /// <p>CloudFront and <code>MaxMind</code> both use <code>ISO 3166</code> country codes. For the
        /// current list of countries and the corresponding codes, see <code>ISO 3166-1-alpha-2</code>
        /// code on the <i>International Organization for Standardization</i> website. You
        /// can also refer to the country list on the CloudFront console, which includes both country names and
        /// codes.</p>
        pub fn items(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.items.unwrap_or_default();
            v.push(input.into());
            self.items = Some(v);
            self
        }
        /// <p> A complex type that contains a <code>Location</code> element for each country in which
        /// you want CloudFront either to distribute your content (<code>whitelist</code>) or not distribute
        /// your content (<code>blacklist</code>).</p>
        /// <p>The <code>Location</code> element is a two-letter, uppercase country code for a country
        /// that you want to include in your <code>blacklist</code> or <code>whitelist</code>. Include one
        /// <code>Location</code> element for each country.</p>
        /// <p>CloudFront and <code>MaxMind</code> both use <code>ISO 3166</code> country codes. For the
        /// current list of countries and the corresponding codes, see <code>ISO 3166-1-alpha-2</code>
        /// code on the <i>International Organization for Standardization</i> website. You
        /// can also refer to the country list on the CloudFront console, which includes both country names and
        /// codes.</p>
        pub fn set_items(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.items = input;
            self
        }
        /// Consumes the builder and constructs a [`GeoRestriction`](crate::model::GeoRestriction)
        pub fn build(self) -> crate::model::GeoRestriction {
            crate::model::GeoRestriction {
                restriction_type: self.restriction_type,
                quantity: self.quantity,
                items: self.items,
            }
        }
    }
}
impl GeoRestriction {
    /// Creates a new builder-style object to manufacture [`GeoRestriction`](crate::model::GeoRestriction)
    pub fn builder() -> crate::model::geo_restriction::Builder {
        crate::model::geo_restriction::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum GeoRestrictionType {
    #[allow(missing_docs)] // documentation missing in model
    Blacklist,
    #[allow(missing_docs)] // documentation missing in model
    None,
    #[allow(missing_docs)] // documentation missing in model
    Whitelist,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for GeoRestrictionType {
    fn from(s: &str) -> Self {
        match s {
            "blacklist" => GeoRestrictionType::Blacklist,
            "none" => GeoRestrictionType::None,
            "whitelist" => GeoRestrictionType::Whitelist,
            other => GeoRestrictionType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for GeoRestrictionType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(GeoRestrictionType::from(s))
    }
}
impl GeoRestrictionType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            GeoRestrictionType::Blacklist => "blacklist",
            GeoRestrictionType::None => "none",
            GeoRestrictionType::Whitelist => "whitelist",
            GeoRestrictionType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["blacklist", "none", "whitelist"]
    }
}
impl AsRef<str> for GeoRestrictionType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>A complex type that determines the distribution’s SSL/TLS configuration for communicating
/// with viewers.</p>
/// <p>If the distribution doesn’t use <code>Aliases</code> (also known as alternate domain
/// names or CNAMEs)—that is, if the distribution uses the CloudFront domain name such as
/// <code>d111111abcdef8.cloudfront.net</code>—set <code>CloudFrontDefaultCertificate</code>
/// to <code>true</code> and leave all other fields empty.</p>
/// <p>If the distribution uses <code>Aliases</code> (alternate domain names or CNAMEs), use
/// the fields in this type to specify the following settings:</p>
/// <ul>
/// <li>
/// <p>Which viewers the distribution accepts HTTPS connections from: only viewers that support
/// <a href="https://en.wikipedia.org/wiki/Server_Name_Indication">server name
/// indication (SNI)</a> (recommended), or all viewers including those that
/// don’t support SNI.</p>
/// <ul>
/// <li>
/// <p>To accept HTTPS connections from only viewers that support SNI, set
/// <code>SSLSupportMethod</code> to <code>sni-only</code>. This is
/// recommended. Most browsers and clients support
/// SNI.
/// </p>
/// </li>
/// <li>
/// <p>To accept HTTPS connections from all viewers, including those that don’t support SNI,
/// set <code>SSLSupportMethod</code> to <code>vip</code>. This is not
/// recommended, and results in additional monthly charges from
/// CloudFront.</p>
/// </li>
/// </ul>
/// </li>
/// <li>
/// <p>The minimum SSL/TLS protocol version that the distribution can use to
/// communicate with viewers. To specify a minimum version, choose a value for
/// <code>MinimumProtocolVersion</code>. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-web-values-specify.html#DownloadDistValues-security-policy">Security Policy</a> in the
/// <i>Amazon CloudFront Developer Guide</i>.</p>
/// </li>
/// <li>
/// <p>The location of the SSL/TLS certificate, <a href="https://docs.aws.amazon.com/acm/latest/userguide/acm-overview.html">Certificate Manager (ACM)</a> (recommended) or <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_server-certs.html">Identity and Access Management (IAM)</a>. You specify the location
/// by setting a value in one of the following fields (not both):</p>
/// <ul>
/// <li>
/// <p>
/// <code>ACMCertificateArn</code>
/// </p>
/// </li>
/// <li>
/// <p>
/// <code>IAMCertificateId</code>
/// </p>
/// </li>
/// </ul>
/// </li>
/// </ul>
/// <p>All distributions support HTTPS connections from viewers. To require viewers to use
/// HTTPS only, or to redirect them from HTTP to HTTPS, use
/// <code>ViewerProtocolPolicy</code> in the <code>CacheBehavior</code> or
/// <code>DefaultCacheBehavior</code>. To specify how CloudFront should use SSL/TLS to
/// communicate with your custom origin, use <code>CustomOriginConfig</code>.</p>
/// <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-https.html">Using
/// HTTPS with CloudFront</a> and <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-https-alternate-domain-names.html">
/// Using Alternate Domain Names and HTTPS</a> in the
/// <i>Amazon CloudFront Developer Guide</i>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ViewerCertificate {
    /// <p>If the distribution uses the CloudFront domain name such as
    /// <code>d111111abcdef8.cloudfront.net</code>, set this field to <code>true</code>.</p>
    /// <p>If the distribution uses <code>Aliases</code> (alternate domain names or CNAMEs), set
    /// this field to <code>false</code> and specify values for the following fields:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>ACMCertificateArn</code> or <code>IAMCertificateId</code> (specify a value for one,
    /// not both)</p>
    ///
    /// </li>
    /// <li>
    /// <p>
    /// <code>MinimumProtocolVersion</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>SSLSupportMethod</code>
    /// </p>
    /// </li>
    /// </ul>
    pub cloud_front_default_certificate: std::option::Option<bool>,
    /// <p>If the distribution uses <code>Aliases</code> (alternate domain names or CNAMEs) and
    /// the SSL/TLS certificate is stored in <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_server-certs.html">Identity and Access Management (IAM)</a>, provide the ID of the IAM
    /// certificate.</p>
    /// <p>If you specify an IAM certificate ID, you must also specify values for
    /// <code>MinimumProtocolVersion</code> and <code>SSLSupportMethod</code>. </p>
    pub iam_certificate_id: std::option::Option<std::string::String>,
    /// <p>If the distribution uses <code>Aliases</code> (alternate domain names or CNAMEs) and
    /// the SSL/TLS certificate is stored in <a href="https://docs.aws.amazon.com/acm/latest/userguide/acm-overview.html">Certificate Manager (ACM)</a>, provide the Amazon Resource
    /// Name (ARN) of the ACM certificate. CloudFront only supports ACM certificates in the US
    /// East (N. Virginia) Region (<code>us-east-1</code>).</p>
    /// <p>If you specify an ACM certificate ARN, you must also specify values for
    /// <code>MinimumProtocolVersion</code> and <code>SSLSupportMethod</code>.</p>
    pub acm_certificate_arn: std::option::Option<std::string::String>,
    /// <p>If the distribution uses <code>Aliases</code> (alternate domain names or CNAMEs), specify
    /// which viewers the distribution accepts HTTPS connections from.</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>sni-only</code> – The distribution accepts HTTPS connections from only viewers that
    /// support <a href="https://en.wikipedia.org/wiki/Server_Name_Indication">server
    /// name indication (SNI)</a>. This is recommended. Most browsers and clients support SNI.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>vip</code> – The distribution accepts HTTPS connections from all viewers including
    /// those that don’t support SNI. This is not recommended, and results in additional
    /// monthly charges from CloudFront.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>static-ip</code> - Do not specify this value unless your distribution
    /// has been enabled for this feature by the CloudFront team. If you have a use case
    /// that requires static IP addresses for a distribution, contact CloudFront through
    /// the <a href="https://console.aws.amazon.com/support/home">Amazon Web Services Support Center</a>.</p>
    /// </li>
    /// </ul>
    /// <p>If the distribution uses the CloudFront domain name such as
    /// <code>d111111abcdef8.cloudfront.net</code>, don’t set a value for this field.</p>
    pub ssl_support_method: std::option::Option<crate::model::SslSupportMethod>,
    /// <p>If the distribution uses <code>Aliases</code> (alternate domain names or CNAMEs),
    /// specify the security policy that you want CloudFront to use for HTTPS connections with
    /// viewers. The security policy determines two settings:</p>
    /// <ul>
    /// <li>
    /// <p>The minimum SSL/TLS protocol that CloudFront can use to communicate with
    /// viewers.</p>
    /// </li>
    /// <li>
    /// <p>The ciphers that CloudFront can use to encrypt the content that it returns to
    /// viewers.</p>
    /// </li>
    /// </ul>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-web-values-specify.html#DownloadDistValues-security-policy">Security Policy</a> and <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/secure-connections-supported-viewer-protocols-ciphers.html#secure-connections-supported-ciphers">Supported Protocols and Ciphers Between Viewers and
    /// CloudFront</a> in the <i>Amazon CloudFront Developer Guide</i>.</p>
    /// <note>
    /// <p>On the CloudFront console, this setting is called <b>Security
    /// Policy</b>.</p>
    /// </note>
    /// <p>When you’re using SNI only (you set <code>SSLSupportMethod</code> to <code>sni-only</code>),
    /// you must specify <code>TLSv1</code> or higher.</p>
    /// <p>If the distribution uses the CloudFront domain name such as
    /// <code>d111111abcdef8.cloudfront.net</code> (you set
    /// <code>CloudFrontDefaultCertificate</code> to <code>true</code>), CloudFront automatically sets
    /// the security policy to <code>TLSv1</code> regardless of the value that you set
    /// here.</p>
    pub minimum_protocol_version: std::option::Option<crate::model::MinimumProtocolVersion>,
    /// <p>This field is deprecated. Use one of the following fields instead:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>ACMCertificateArn</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>IAMCertificateId</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>CloudFrontDefaultCertificate</code>
    /// </p>
    /// </li>
    /// </ul>
    pub certificate: std::option::Option<std::string::String>,
    /// <p>This field is deprecated. Use one of the following fields instead:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>ACMCertificateArn</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>IAMCertificateId</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>CloudFrontDefaultCertificate</code>
    /// </p>
    /// </li>
    /// </ul>
    pub certificate_source: std::option::Option<crate::model::CertificateSource>,
}
impl ViewerCertificate {
    /// <p>If the distribution uses the CloudFront domain name such as
    /// <code>d111111abcdef8.cloudfront.net</code>, set this field to <code>true</code>.</p>
    /// <p>If the distribution uses <code>Aliases</code> (alternate domain names or CNAMEs), set
    /// this field to <code>false</code> and specify values for the following fields:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>ACMCertificateArn</code> or <code>IAMCertificateId</code> (specify a value for one,
    /// not both)</p>
    ///
    /// </li>
    /// <li>
    /// <p>
    /// <code>MinimumProtocolVersion</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>SSLSupportMethod</code>
    /// </p>
    /// </li>
    /// </ul>
    pub fn cloud_front_default_certificate(&self) -> std::option::Option<bool> {
        self.cloud_front_default_certificate
    }
    /// <p>If the distribution uses <code>Aliases</code> (alternate domain names or CNAMEs) and
    /// the SSL/TLS certificate is stored in <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_server-certs.html">Identity and Access Management (IAM)</a>, provide the ID of the IAM
    /// certificate.</p>
    /// <p>If you specify an IAM certificate ID, you must also specify values for
    /// <code>MinimumProtocolVersion</code> and <code>SSLSupportMethod</code>. </p>
    pub fn iam_certificate_id(&self) -> std::option::Option<&str> {
        self.iam_certificate_id.as_deref()
    }
    /// <p>If the distribution uses <code>Aliases</code> (alternate domain names or CNAMEs) and
    /// the SSL/TLS certificate is stored in <a href="https://docs.aws.amazon.com/acm/latest/userguide/acm-overview.html">Certificate Manager (ACM)</a>, provide the Amazon Resource
    /// Name (ARN) of the ACM certificate. CloudFront only supports ACM certificates in the US
    /// East (N. Virginia) Region (<code>us-east-1</code>).</p>
    /// <p>If you specify an ACM certificate ARN, you must also specify values for
    /// <code>MinimumProtocolVersion</code> and <code>SSLSupportMethod</code>.</p>
    pub fn acm_certificate_arn(&self) -> std::option::Option<&str> {
        self.acm_certificate_arn.as_deref()
    }
    /// <p>If the distribution uses <code>Aliases</code> (alternate domain names or CNAMEs), specify
    /// which viewers the distribution accepts HTTPS connections from.</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>sni-only</code> – The distribution accepts HTTPS connections from only viewers that
    /// support <a href="https://en.wikipedia.org/wiki/Server_Name_Indication">server
    /// name indication (SNI)</a>. This is recommended. Most browsers and clients support SNI.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>vip</code> – The distribution accepts HTTPS connections from all viewers including
    /// those that don’t support SNI. This is not recommended, and results in additional
    /// monthly charges from CloudFront.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>static-ip</code> - Do not specify this value unless your distribution
    /// has been enabled for this feature by the CloudFront team. If you have a use case
    /// that requires static IP addresses for a distribution, contact CloudFront through
    /// the <a href="https://console.aws.amazon.com/support/home">Amazon Web Services Support Center</a>.</p>
    /// </li>
    /// </ul>
    /// <p>If the distribution uses the CloudFront domain name such as
    /// <code>d111111abcdef8.cloudfront.net</code>, don’t set a value for this field.</p>
    pub fn ssl_support_method(&self) -> std::option::Option<&crate::model::SslSupportMethod> {
        self.ssl_support_method.as_ref()
    }
    /// <p>If the distribution uses <code>Aliases</code> (alternate domain names or CNAMEs),
    /// specify the security policy that you want CloudFront to use for HTTPS connections with
    /// viewers. The security policy determines two settings:</p>
    /// <ul>
    /// <li>
    /// <p>The minimum SSL/TLS protocol that CloudFront can use to communicate with
    /// viewers.</p>
    /// </li>
    /// <li>
    /// <p>The ciphers that CloudFront can use to encrypt the content that it returns to
    /// viewers.</p>
    /// </li>
    /// </ul>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-web-values-specify.html#DownloadDistValues-security-policy">Security Policy</a> and <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/secure-connections-supported-viewer-protocols-ciphers.html#secure-connections-supported-ciphers">Supported Protocols and Ciphers Between Viewers and
    /// CloudFront</a> in the <i>Amazon CloudFront Developer Guide</i>.</p>
    /// <note>
    /// <p>On the CloudFront console, this setting is called <b>Security
    /// Policy</b>.</p>
    /// </note>
    /// <p>When you’re using SNI only (you set <code>SSLSupportMethod</code> to <code>sni-only</code>),
    /// you must specify <code>TLSv1</code> or higher.</p>
    /// <p>If the distribution uses the CloudFront domain name such as
    /// <code>d111111abcdef8.cloudfront.net</code> (you set
    /// <code>CloudFrontDefaultCertificate</code> to <code>true</code>), CloudFront automatically sets
    /// the security policy to <code>TLSv1</code> regardless of the value that you set
    /// here.</p>
    pub fn minimum_protocol_version(
        &self,
    ) -> std::option::Option<&crate::model::MinimumProtocolVersion> {
        self.minimum_protocol_version.as_ref()
    }
    /// <p>This field is deprecated. Use one of the following fields instead:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>ACMCertificateArn</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>IAMCertificateId</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>CloudFrontDefaultCertificate</code>
    /// </p>
    /// </li>
    /// </ul>
    pub fn certificate(&self) -> std::option::Option<&str> {
        self.certificate.as_deref()
    }
    /// <p>This field is deprecated. Use one of the following fields instead:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>ACMCertificateArn</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>IAMCertificateId</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>CloudFrontDefaultCertificate</code>
    /// </p>
    /// </li>
    /// </ul>
    pub fn certificate_source(&self) -> std::option::Option<&crate::model::CertificateSource> {
        self.certificate_source.as_ref()
    }
}
impl std::fmt::Debug for ViewerCertificate {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ViewerCertificate");
        formatter.field(
            "cloud_front_default_certificate",
            &self.cloud_front_default_certificate,
        );
        formatter.field("iam_certificate_id", &self.iam_certificate_id);
        formatter.field("acm_certificate_arn", &self.acm_certificate_arn);
        formatter.field("ssl_support_method", &self.ssl_support_method);
        formatter.field("minimum_protocol_version", &self.minimum_protocol_version);
        formatter.field("certificate", &self.certificate);
        formatter.field("certificate_source", &self.certificate_source);
        formatter.finish()
    }
}
/// See [`ViewerCertificate`](crate::model::ViewerCertificate)
pub mod viewer_certificate {
    /// A builder for [`ViewerCertificate`](crate::model::ViewerCertificate)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cloud_front_default_certificate: std::option::Option<bool>,
        pub(crate) iam_certificate_id: std::option::Option<std::string::String>,
        pub(crate) acm_certificate_arn: std::option::Option<std::string::String>,
        pub(crate) ssl_support_method: std::option::Option<crate::model::SslSupportMethod>,
        pub(crate) minimum_protocol_version:
            std::option::Option<crate::model::MinimumProtocolVersion>,
        pub(crate) certificate: std::option::Option<std::string::String>,
        pub(crate) certificate_source: std::option::Option<crate::model::CertificateSource>,
    }
    impl Builder {
        /// <p>If the distribution uses the CloudFront domain name such as
        /// <code>d111111abcdef8.cloudfront.net</code>, set this field to <code>true</code>.</p>
        /// <p>If the distribution uses <code>Aliases</code> (alternate domain names or CNAMEs), set
        /// this field to <code>false</code> and specify values for the following fields:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>ACMCertificateArn</code> or <code>IAMCertificateId</code> (specify a value for one,
        /// not both)</p>
        ///
        /// </li>
        /// <li>
        /// <p>
        /// <code>MinimumProtocolVersion</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>SSLSupportMethod</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn cloud_front_default_certificate(mut self, input: bool) -> Self {
            self.cloud_front_default_certificate = Some(input);
            self
        }
        /// <p>If the distribution uses the CloudFront domain name such as
        /// <code>d111111abcdef8.cloudfront.net</code>, set this field to <code>true</code>.</p>
        /// <p>If the distribution uses <code>Aliases</code> (alternate domain names or CNAMEs), set
        /// this field to <code>false</code> and specify values for the following fields:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>ACMCertificateArn</code> or <code>IAMCertificateId</code> (specify a value for one,
        /// not both)</p>
        ///
        /// </li>
        /// <li>
        /// <p>
        /// <code>MinimumProtocolVersion</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>SSLSupportMethod</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_cloud_front_default_certificate(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.cloud_front_default_certificate = input;
            self
        }
        /// <p>If the distribution uses <code>Aliases</code> (alternate domain names or CNAMEs) and
        /// the SSL/TLS certificate is stored in <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_server-certs.html">Identity and Access Management (IAM)</a>, provide the ID of the IAM
        /// certificate.</p>
        /// <p>If you specify an IAM certificate ID, you must also specify values for
        /// <code>MinimumProtocolVersion</code> and <code>SSLSupportMethod</code>. </p>
        pub fn iam_certificate_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.iam_certificate_id = Some(input.into());
            self
        }
        /// <p>If the distribution uses <code>Aliases</code> (alternate domain names or CNAMEs) and
        /// the SSL/TLS certificate is stored in <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_server-certs.html">Identity and Access Management (IAM)</a>, provide the ID of the IAM
        /// certificate.</p>
        /// <p>If you specify an IAM certificate ID, you must also specify values for
        /// <code>MinimumProtocolVersion</code> and <code>SSLSupportMethod</code>. </p>
        pub fn set_iam_certificate_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.iam_certificate_id = input;
            self
        }
        /// <p>If the distribution uses <code>Aliases</code> (alternate domain names or CNAMEs) and
        /// the SSL/TLS certificate is stored in <a href="https://docs.aws.amazon.com/acm/latest/userguide/acm-overview.html">Certificate Manager (ACM)</a>, provide the Amazon Resource
        /// Name (ARN) of the ACM certificate. CloudFront only supports ACM certificates in the US
        /// East (N. Virginia) Region (<code>us-east-1</code>).</p>
        /// <p>If you specify an ACM certificate ARN, you must also specify values for
        /// <code>MinimumProtocolVersion</code> and <code>SSLSupportMethod</code>.</p>
        pub fn acm_certificate_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.acm_certificate_arn = Some(input.into());
            self
        }
        /// <p>If the distribution uses <code>Aliases</code> (alternate domain names or CNAMEs) and
        /// the SSL/TLS certificate is stored in <a href="https://docs.aws.amazon.com/acm/latest/userguide/acm-overview.html">Certificate Manager (ACM)</a>, provide the Amazon Resource
        /// Name (ARN) of the ACM certificate. CloudFront only supports ACM certificates in the US
        /// East (N. Virginia) Region (<code>us-east-1</code>).</p>
        /// <p>If you specify an ACM certificate ARN, you must also specify values for
        /// <code>MinimumProtocolVersion</code> and <code>SSLSupportMethod</code>.</p>
        pub fn set_acm_certificate_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.acm_certificate_arn = input;
            self
        }
        /// <p>If the distribution uses <code>Aliases</code> (alternate domain names or CNAMEs), specify
        /// which viewers the distribution accepts HTTPS connections from.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>sni-only</code> – The distribution accepts HTTPS connections from only viewers that
        /// support <a href="https://en.wikipedia.org/wiki/Server_Name_Indication">server
        /// name indication (SNI)</a>. This is recommended. Most browsers and clients support SNI.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>vip</code> – The distribution accepts HTTPS connections from all viewers including
        /// those that don’t support SNI. This is not recommended, and results in additional
        /// monthly charges from CloudFront.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>static-ip</code> - Do not specify this value unless your distribution
        /// has been enabled for this feature by the CloudFront team. If you have a use case
        /// that requires static IP addresses for a distribution, contact CloudFront through
        /// the <a href="https://console.aws.amazon.com/support/home">Amazon Web Services Support Center</a>.</p>
        /// </li>
        /// </ul>
        /// <p>If the distribution uses the CloudFront domain name such as
        /// <code>d111111abcdef8.cloudfront.net</code>, don’t set a value for this field.</p>
        pub fn ssl_support_method(mut self, input: crate::model::SslSupportMethod) -> Self {
            self.ssl_support_method = Some(input);
            self
        }
        /// <p>If the distribution uses <code>Aliases</code> (alternate domain names or CNAMEs), specify
        /// which viewers the distribution accepts HTTPS connections from.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>sni-only</code> – The distribution accepts HTTPS connections from only viewers that
        /// support <a href="https://en.wikipedia.org/wiki/Server_Name_Indication">server
        /// name indication (SNI)</a>. This is recommended. Most browsers and clients support SNI.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>vip</code> – The distribution accepts HTTPS connections from all viewers including
        /// those that don’t support SNI. This is not recommended, and results in additional
        /// monthly charges from CloudFront.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>static-ip</code> - Do not specify this value unless your distribution
        /// has been enabled for this feature by the CloudFront team. If you have a use case
        /// that requires static IP addresses for a distribution, contact CloudFront through
        /// the <a href="https://console.aws.amazon.com/support/home">Amazon Web Services Support Center</a>.</p>
        /// </li>
        /// </ul>
        /// <p>If the distribution uses the CloudFront domain name such as
        /// <code>d111111abcdef8.cloudfront.net</code>, don’t set a value for this field.</p>
        pub fn set_ssl_support_method(
            mut self,
            input: std::option::Option<crate::model::SslSupportMethod>,
        ) -> Self {
            self.ssl_support_method = input;
            self
        }
        /// <p>If the distribution uses <code>Aliases</code> (alternate domain names or CNAMEs),
        /// specify the security policy that you want CloudFront to use for HTTPS connections with
        /// viewers. The security policy determines two settings:</p>
        /// <ul>
        /// <li>
        /// <p>The minimum SSL/TLS protocol that CloudFront can use to communicate with
        /// viewers.</p>
        /// </li>
        /// <li>
        /// <p>The ciphers that CloudFront can use to encrypt the content that it returns to
        /// viewers.</p>
        /// </li>
        /// </ul>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-web-values-specify.html#DownloadDistValues-security-policy">Security Policy</a> and <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/secure-connections-supported-viewer-protocols-ciphers.html#secure-connections-supported-ciphers">Supported Protocols and Ciphers Between Viewers and
        /// CloudFront</a> in the <i>Amazon CloudFront Developer Guide</i>.</p>
        /// <note>
        /// <p>On the CloudFront console, this setting is called <b>Security
        /// Policy</b>.</p>
        /// </note>
        /// <p>When you’re using SNI only (you set <code>SSLSupportMethod</code> to <code>sni-only</code>),
        /// you must specify <code>TLSv1</code> or higher.</p>
        /// <p>If the distribution uses the CloudFront domain name such as
        /// <code>d111111abcdef8.cloudfront.net</code> (you set
        /// <code>CloudFrontDefaultCertificate</code> to <code>true</code>), CloudFront automatically sets
        /// the security policy to <code>TLSv1</code> regardless of the value that you set
        /// here.</p>
        pub fn minimum_protocol_version(
            mut self,
            input: crate::model::MinimumProtocolVersion,
        ) -> Self {
            self.minimum_protocol_version = Some(input);
            self
        }
        /// <p>If the distribution uses <code>Aliases</code> (alternate domain names or CNAMEs),
        /// specify the security policy that you want CloudFront to use for HTTPS connections with
        /// viewers. The security policy determines two settings:</p>
        /// <ul>
        /// <li>
        /// <p>The minimum SSL/TLS protocol that CloudFront can use to communicate with
        /// viewers.</p>
        /// </li>
        /// <li>
        /// <p>The ciphers that CloudFront can use to encrypt the content that it returns to
        /// viewers.</p>
        /// </li>
        /// </ul>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-web-values-specify.html#DownloadDistValues-security-policy">Security Policy</a> and <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/secure-connections-supported-viewer-protocols-ciphers.html#secure-connections-supported-ciphers">Supported Protocols and Ciphers Between Viewers and
        /// CloudFront</a> in the <i>Amazon CloudFront Developer Guide</i>.</p>
        /// <note>
        /// <p>On the CloudFront console, this setting is called <b>Security
        /// Policy</b>.</p>
        /// </note>
        /// <p>When you’re using SNI only (you set <code>SSLSupportMethod</code> to <code>sni-only</code>),
        /// you must specify <code>TLSv1</code> or higher.</p>
        /// <p>If the distribution uses the CloudFront domain name such as
        /// <code>d111111abcdef8.cloudfront.net</code> (you set
        /// <code>CloudFrontDefaultCertificate</code> to <code>true</code>), CloudFront automatically sets
        /// the security policy to <code>TLSv1</code> regardless of the value that you set
        /// here.</p>
        pub fn set_minimum_protocol_version(
            mut self,
            input: std::option::Option<crate::model::MinimumProtocolVersion>,
        ) -> Self {
            self.minimum_protocol_version = input;
            self
        }
        /// <p>This field is deprecated. Use one of the following fields instead:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>ACMCertificateArn</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>IAMCertificateId</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>CloudFrontDefaultCertificate</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn certificate(mut self, input: impl Into<std::string::String>) -> Self {
            self.certificate = Some(input.into());
            self
        }
        /// <p>This field is deprecated. Use one of the following fields instead:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>ACMCertificateArn</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>IAMCertificateId</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>CloudFrontDefaultCertificate</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_certificate(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.certificate = input;
            self
        }
        /// <p>This field is deprecated. Use one of the following fields instead:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>ACMCertificateArn</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>IAMCertificateId</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>CloudFrontDefaultCertificate</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn certificate_source(mut self, input: crate::model::CertificateSource) -> Self {
            self.certificate_source = Some(input);
            self
        }
        /// <p>This field is deprecated. Use one of the following fields instead:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>ACMCertificateArn</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>IAMCertificateId</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>CloudFrontDefaultCertificate</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_certificate_source(
            mut self,
            input: std::option::Option<crate::model::CertificateSource>,
        ) -> Self {
            self.certificate_source = input;
            self
        }
        /// Consumes the builder and constructs a [`ViewerCertificate`](crate::model::ViewerCertificate)
        pub fn build(self) -> crate::model::ViewerCertificate {
            crate::model::ViewerCertificate {
                cloud_front_default_certificate: self.cloud_front_default_certificate,
                iam_certificate_id: self.iam_certificate_id,
                acm_certificate_arn: self.acm_certificate_arn,
                ssl_support_method: self.ssl_support_method,
                minimum_protocol_version: self.minimum_protocol_version,
                certificate: self.certificate,
                certificate_source: self.certificate_source,
            }
        }
    }
}
impl ViewerCertificate {
    /// Creates a new builder-style object to manufacture [`ViewerCertificate`](crate::model::ViewerCertificate)
    pub fn builder() -> crate::model::viewer_certificate::Builder {
        crate::model::viewer_certificate::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum CertificateSource {
    #[allow(missing_docs)] // documentation missing in model
    Acm,
    #[allow(missing_docs)] // documentation missing in model
    Cloudfront,
    #[allow(missing_docs)] // documentation missing in model
    Iam,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for CertificateSource {
    fn from(s: &str) -> Self {
        match s {
            "acm" => CertificateSource::Acm,
            "cloudfront" => CertificateSource::Cloudfront,
            "iam" => CertificateSource::Iam,
            other => CertificateSource::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for CertificateSource {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(CertificateSource::from(s))
    }
}
impl CertificateSource {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            CertificateSource::Acm => "acm",
            CertificateSource::Cloudfront => "cloudfront",
            CertificateSource::Iam => "iam",
            CertificateSource::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["acm", "cloudfront", "iam"]
    }
}
impl AsRef<str> for CertificateSource {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum MinimumProtocolVersion {
    #[allow(missing_docs)] // documentation missing in model
    SsLv3,
    #[allow(missing_docs)] // documentation missing in model
    TlSv1,
    #[allow(missing_docs)] // documentation missing in model
    TlSv112016,
    #[allow(missing_docs)] // documentation missing in model
    TlSv122018,
    #[allow(missing_docs)] // documentation missing in model
    TlSv122019,
    #[allow(missing_docs)] // documentation missing in model
    TlSv122021,
    #[allow(missing_docs)] // documentation missing in model
    TlSv12016,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for MinimumProtocolVersion {
    fn from(s: &str) -> Self {
        match s {
            "SSLv3" => MinimumProtocolVersion::SsLv3,
            "TLSv1" => MinimumProtocolVersion::TlSv1,
            "TLSv1.1_2016" => MinimumProtocolVersion::TlSv112016,
            "TLSv1.2_2018" => MinimumProtocolVersion::TlSv122018,
            "TLSv1.2_2019" => MinimumProtocolVersion::TlSv122019,
            "TLSv1.2_2021" => MinimumProtocolVersion::TlSv122021,
            "TLSv1_2016" => MinimumProtocolVersion::TlSv12016,
            other => MinimumProtocolVersion::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for MinimumProtocolVersion {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(MinimumProtocolVersion::from(s))
    }
}
impl MinimumProtocolVersion {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            MinimumProtocolVersion::SsLv3 => "SSLv3",
            MinimumProtocolVersion::TlSv1 => "TLSv1",
            MinimumProtocolVersion::TlSv112016 => "TLSv1.1_2016",
            MinimumProtocolVersion::TlSv122018 => "TLSv1.2_2018",
            MinimumProtocolVersion::TlSv122019 => "TLSv1.2_2019",
            MinimumProtocolVersion::TlSv122021 => "TLSv1.2_2021",
            MinimumProtocolVersion::TlSv12016 => "TLSv1_2016",
            MinimumProtocolVersion::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "SSLv3",
            "TLSv1",
            "TLSv1.1_2016",
            "TLSv1.2_2018",
            "TLSv1.2_2019",
            "TLSv1.2_2021",
            "TLSv1_2016",
        ]
    }
}
impl AsRef<str> for MinimumProtocolVersion {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum SslSupportMethod {
    #[allow(missing_docs)] // documentation missing in model
    SniOnly,
    #[allow(missing_docs)] // documentation missing in model
    StaticIp,
    #[allow(missing_docs)] // documentation missing in model
    Vip,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for SslSupportMethod {
    fn from(s: &str) -> Self {
        match s {
            "sni-only" => SslSupportMethod::SniOnly,
            "static-ip" => SslSupportMethod::StaticIp,
            "vip" => SslSupportMethod::Vip,
            other => SslSupportMethod::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for SslSupportMethod {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(SslSupportMethod::from(s))
    }
}
impl SslSupportMethod {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            SslSupportMethod::SniOnly => "sni-only",
            SslSupportMethod::StaticIp => "static-ip",
            SslSupportMethod::Vip => "vip",
            SslSupportMethod::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["sni-only", "static-ip", "vip"]
    }
}
impl AsRef<str> for SslSupportMethod {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>A complex type that controls whether access logs are written for the
/// distribution.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LoggingConfig {
    /// <p>Specifies whether you want CloudFront to save access logs to an Amazon S3 bucket. If you don't
    /// want to enable logging when you create a distribution or if you want to disable logging for an
    /// existing distribution, specify <code>false</code> for <code>Enabled</code>, and specify empty
    /// <code>Bucket</code> and <code>Prefix</code> elements. If you specify <code>false</code> for
    /// <code>Enabled</code> but you specify values for <code>Bucket</code>, <code>prefix</code>,
    /// and <code>IncludeCookies</code>, the values are automatically deleted.</p>
    pub enabled: std::option::Option<bool>,
    /// <p>Specifies whether you want CloudFront to include cookies in access logs, specify
    /// <code>true</code> for <code>IncludeCookies</code>. If you choose to include cookies in logs,
    /// CloudFront logs all cookies regardless of how you configure the cache behaviors for this
    /// distribution. If you don't want to include cookies when you create a distribution or if you
    /// want to disable include cookies for an existing distribution, specify <code>false</code> for
    /// <code>IncludeCookies</code>.</p>
    pub include_cookies: std::option::Option<bool>,
    /// <p>The Amazon S3 bucket to store the access logs in, for example,
    /// <code>myawslogbucket.s3.amazonaws.com</code>.</p>
    pub bucket: std::option::Option<std::string::String>,
    /// <p>An optional string that you want CloudFront to prefix to the access log
    /// <code>filenames</code> for this distribution, for example, <code>myprefix/</code>. If you
    /// want to enable logging, but you don't want to specify a prefix, you still must include an
    /// empty <code>Prefix</code> element in the <code>Logging</code> element.</p>
    pub prefix: std::option::Option<std::string::String>,
}
impl LoggingConfig {
    /// <p>Specifies whether you want CloudFront to save access logs to an Amazon S3 bucket. If you don't
    /// want to enable logging when you create a distribution or if you want to disable logging for an
    /// existing distribution, specify <code>false</code> for <code>Enabled</code>, and specify empty
    /// <code>Bucket</code> and <code>Prefix</code> elements. If you specify <code>false</code> for
    /// <code>Enabled</code> but you specify values for <code>Bucket</code>, <code>prefix</code>,
    /// and <code>IncludeCookies</code>, the values are automatically deleted.</p>
    pub fn enabled(&self) -> std::option::Option<bool> {
        self.enabled
    }
    /// <p>Specifies whether you want CloudFront to include cookies in access logs, specify
    /// <code>true</code> for <code>IncludeCookies</code>. If you choose to include cookies in logs,
    /// CloudFront logs all cookies regardless of how you configure the cache behaviors for this
    /// distribution. If you don't want to include cookies when you create a distribution or if you
    /// want to disable include cookies for an existing distribution, specify <code>false</code> for
    /// <code>IncludeCookies</code>.</p>
    pub fn include_cookies(&self) -> std::option::Option<bool> {
        self.include_cookies
    }
    /// <p>The Amazon S3 bucket to store the access logs in, for example,
    /// <code>myawslogbucket.s3.amazonaws.com</code>.</p>
    pub fn bucket(&self) -> std::option::Option<&str> {
        self.bucket.as_deref()
    }
    /// <p>An optional string that you want CloudFront to prefix to the access log
    /// <code>filenames</code> for this distribution, for example, <code>myprefix/</code>. If you
    /// want to enable logging, but you don't want to specify a prefix, you still must include an
    /// empty <code>Prefix</code> element in the <code>Logging</code> element.</p>
    pub fn prefix(&self) -> std::option::Option<&str> {
        self.prefix.as_deref()
    }
}
impl std::fmt::Debug for LoggingConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LoggingConfig");
        formatter.field("enabled", &self.enabled);
        formatter.field("include_cookies", &self.include_cookies);
        formatter.field("bucket", &self.bucket);
        formatter.field("prefix", &self.prefix);
        formatter.finish()
    }
}
/// See [`LoggingConfig`](crate::model::LoggingConfig)
pub mod logging_config {
    /// A builder for [`LoggingConfig`](crate::model::LoggingConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) enabled: std::option::Option<bool>,
        pub(crate) include_cookies: std::option::Option<bool>,
        pub(crate) bucket: std::option::Option<std::string::String>,
        pub(crate) prefix: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Specifies whether you want CloudFront to save access logs to an Amazon S3 bucket. If you don't
        /// want to enable logging when you create a distribution or if you want to disable logging for an
        /// existing distribution, specify <code>false</code> for <code>Enabled</code>, and specify empty
        /// <code>Bucket</code> and <code>Prefix</code> elements. If you specify <code>false</code> for
        /// <code>Enabled</code> but you specify values for <code>Bucket</code>, <code>prefix</code>,
        /// and <code>IncludeCookies</code>, the values are automatically deleted.</p>
        pub fn enabled(mut self, input: bool) -> Self {
            self.enabled = Some(input);
            self
        }
        /// <p>Specifies whether you want CloudFront to save access logs to an Amazon S3 bucket. If you don't
        /// want to enable logging when you create a distribution or if you want to disable logging for an
        /// existing distribution, specify <code>false</code> for <code>Enabled</code>, and specify empty
        /// <code>Bucket</code> and <code>Prefix</code> elements. If you specify <code>false</code> for
        /// <code>Enabled</code> but you specify values for <code>Bucket</code>, <code>prefix</code>,
        /// and <code>IncludeCookies</code>, the values are automatically deleted.</p>
        pub fn set_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.enabled = input;
            self
        }
        /// <p>Specifies whether you want CloudFront to include cookies in access logs, specify
        /// <code>true</code> for <code>IncludeCookies</code>. If you choose to include cookies in logs,
        /// CloudFront logs all cookies regardless of how you configure the cache behaviors for this
        /// distribution. If you don't want to include cookies when you create a distribution or if you
        /// want to disable include cookies for an existing distribution, specify <code>false</code> for
        /// <code>IncludeCookies</code>.</p>
        pub fn include_cookies(mut self, input: bool) -> Self {
            self.include_cookies = Some(input);
            self
        }
        /// <p>Specifies whether you want CloudFront to include cookies in access logs, specify
        /// <code>true</code> for <code>IncludeCookies</code>. If you choose to include cookies in logs,
        /// CloudFront logs all cookies regardless of how you configure the cache behaviors for this
        /// distribution. If you don't want to include cookies when you create a distribution or if you
        /// want to disable include cookies for an existing distribution, specify <code>false</code> for
        /// <code>IncludeCookies</code>.</p>
        pub fn set_include_cookies(mut self, input: std::option::Option<bool>) -> Self {
            self.include_cookies = input;
            self
        }
        /// <p>The Amazon S3 bucket to store the access logs in, for example,
        /// <code>myawslogbucket.s3.amazonaws.com</code>.</p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket = Some(input.into());
            self
        }
        /// <p>The Amazon S3 bucket to store the access logs in, for example,
        /// <code>myawslogbucket.s3.amazonaws.com</code>.</p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bucket = input;
            self
        }
        /// <p>An optional string that you want CloudFront to prefix to the access log
        /// <code>filenames</code> for this distribution, for example, <code>myprefix/</code>. If you
        /// want to enable logging, but you don't want to specify a prefix, you still must include an
        /// empty <code>Prefix</code> element in the <code>Logging</code> element.</p>
        pub fn prefix(mut self, input: impl Into<std::string::String>) -> Self {
            self.prefix = Some(input.into());
            self
        }
        /// <p>An optional string that you want CloudFront to prefix to the access log
        /// <code>filenames</code> for this distribution, for example, <code>myprefix/</code>. If you
        /// want to enable logging, but you don't want to specify a prefix, you still must include an
        /// empty <code>Prefix</code> element in the <code>Logging</code> element.</p>
        pub fn set_prefix(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.prefix = input;
            self
        }
        /// Consumes the builder and constructs a [`LoggingConfig`](crate::model::LoggingConfig)
        pub fn build(self) -> crate::model::LoggingConfig {
            crate::model::LoggingConfig {
                enabled: self.enabled,
                include_cookies: self.include_cookies,
                bucket: self.bucket,
                prefix: self.prefix,
            }
        }
    }
}
impl LoggingConfig {
    /// Creates a new builder-style object to manufacture [`LoggingConfig`](crate::model::LoggingConfig)
    pub fn builder() -> crate::model::logging_config::Builder {
        crate::model::logging_config::Builder::default()
    }
}

/// <p>A complex type that controls:</p>
/// <ul>
/// <li>
/// <p>Whether CloudFront replaces HTTP status codes in the 4xx and 5xx range with custom error
/// messages before returning the response to the viewer.</p>
/// </li>
/// <li>
/// <p>How long CloudFront caches HTTP status codes in the 4xx and 5xx range.</p>
/// </li>
/// </ul>
/// <p>For more information about custom error pages, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/custom-error-pages.html">Customizing Error Responses</a> in the
/// <i>Amazon CloudFront Developer Guide</i>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CustomErrorResponses {
    /// <p>The number of HTTP status codes for which you want to specify a custom error page
    /// and/or a caching duration. If <code>Quantity</code> is <code>0</code>, you can omit
    /// <code>Items</code>.</p>
    pub quantity: std::option::Option<i32>,
    /// <p>A complex type that contains a <code>CustomErrorResponse</code> element for each HTTP
    /// status code for which you want to specify a custom error page and/or a caching duration.
    /// </p>
    pub items: std::option::Option<std::vec::Vec<crate::model::CustomErrorResponse>>,
}
impl CustomErrorResponses {
    /// <p>The number of HTTP status codes for which you want to specify a custom error page
    /// and/or a caching duration. If <code>Quantity</code> is <code>0</code>, you can omit
    /// <code>Items</code>.</p>
    pub fn quantity(&self) -> std::option::Option<i32> {
        self.quantity
    }
    /// <p>A complex type that contains a <code>CustomErrorResponse</code> element for each HTTP
    /// status code for which you want to specify a custom error page and/or a caching duration.
    /// </p>
    pub fn items(&self) -> std::option::Option<&[crate::model::CustomErrorResponse]> {
        self.items.as_deref()
    }
}
impl std::fmt::Debug for CustomErrorResponses {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CustomErrorResponses");
        formatter.field("quantity", &self.quantity);
        formatter.field("items", &self.items);
        formatter.finish()
    }
}
/// See [`CustomErrorResponses`](crate::model::CustomErrorResponses)
pub mod custom_error_responses {
    /// A builder for [`CustomErrorResponses`](crate::model::CustomErrorResponses)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) quantity: std::option::Option<i32>,
        pub(crate) items: std::option::Option<std::vec::Vec<crate::model::CustomErrorResponse>>,
    }
    impl Builder {
        /// <p>The number of HTTP status codes for which you want to specify a custom error page
        /// and/or a caching duration. If <code>Quantity</code> is <code>0</code>, you can omit
        /// <code>Items</code>.</p>
        pub fn quantity(mut self, input: i32) -> Self {
            self.quantity = Some(input);
            self
        }
        /// <p>The number of HTTP status codes for which you want to specify a custom error page
        /// and/or a caching duration. If <code>Quantity</code> is <code>0</code>, you can omit
        /// <code>Items</code>.</p>
        pub fn set_quantity(mut self, input: std::option::Option<i32>) -> Self {
            self.quantity = input;
            self
        }
        /// Appends an item to `items`.
        ///
        /// To override the contents of this collection use [`set_items`](Self::set_items).
        ///
        /// <p>A complex type that contains a <code>CustomErrorResponse</code> element for each HTTP
        /// status code for which you want to specify a custom error page and/or a caching duration.
        /// </p>
        pub fn items(mut self, input: impl Into<crate::model::CustomErrorResponse>) -> Self {
            let mut v = self.items.unwrap_or_default();
            v.push(input.into());
            self.items = Some(v);
            self
        }
        /// <p>A complex type that contains a <code>CustomErrorResponse</code> element for each HTTP
        /// status code for which you want to specify a custom error page and/or a caching duration.
        /// </p>
        pub fn set_items(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::CustomErrorResponse>>,
        ) -> Self {
            self.items = input;
            self
        }
        /// Consumes the builder and constructs a [`CustomErrorResponses`](crate::model::CustomErrorResponses)
        pub fn build(self) -> crate::model::CustomErrorResponses {
            crate::model::CustomErrorResponses {
                quantity: self.quantity,
                items: self.items,
            }
        }
    }
}
impl CustomErrorResponses {
    /// Creates a new builder-style object to manufacture [`CustomErrorResponses`](crate::model::CustomErrorResponses)
    pub fn builder() -> crate::model::custom_error_responses::Builder {
        crate::model::custom_error_responses::Builder::default()
    }
}

/// <p>A complex type that controls:</p>
/// <ul>
/// <li>
/// <p>Whether CloudFront replaces HTTP status codes in the 4xx and 5xx range with custom error
/// messages before returning the response to the viewer. </p>
/// </li>
/// <li>
/// <p>How long CloudFront caches HTTP status codes in the 4xx and 5xx range.</p>
/// </li>
/// </ul>
/// <p>For more information about custom error pages, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/custom-error-pages.html">Customizing Error Responses</a> in the
/// <i>Amazon CloudFront Developer Guide</i>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CustomErrorResponse {
    /// <p>The HTTP status code for which you want to specify a custom error page and/or a caching
    /// duration.</p>
    pub error_code: std::option::Option<i32>,
    /// <p>The path to the custom error page that you want CloudFront to return to a viewer when your
    /// origin returns the HTTP status code specified by <code>ErrorCode</code>, for example,
    /// <code>/4xx-errors/403-forbidden.html</code>. If you want to store your objects and your
    /// custom error pages in different locations, your distribution must include a cache behavior for
    /// which the following is true:</p>
    /// <ul>
    /// <li>
    /// <p>The value of <code>PathPattern</code> matches the path to your custom error
    /// messages. For example, suppose you saved custom error pages for 4xx errors in an Amazon S3
    /// bucket in a directory named <code>/4xx-errors</code>. Your distribution must include a
    /// cache behavior for which the path pattern routes requests for your custom error pages to
    /// that location, for example, <code>/4xx-errors/*</code>. </p>
    /// </li>
    /// <li>
    /// <p>The value of <code>TargetOriginId</code> specifies the value of the <code>ID</code>
    /// element for the origin that contains your custom error pages.</p>
    /// </li>
    /// </ul>
    /// <p>If you specify a value for <code>ResponsePagePath</code>, you must also specify a value
    /// for <code>ResponseCode</code>.</p>
    /// <p>We recommend that you store custom error pages in an Amazon S3 bucket. If you store custom
    /// error pages on an HTTP server and the server starts to return 5xx errors, CloudFront can't get the
    /// files that you want to return to viewers because the origin server is unavailable.</p>
    pub response_page_path: std::option::Option<std::string::String>,
    /// <p>The HTTP status code that you want CloudFront to return to the viewer along with the custom
    /// error page. There are a variety of reasons that you might want CloudFront to return a status code
    /// different from the status code that your origin returned to CloudFront, for example:</p>
    /// <ul>
    /// <li>
    /// <p>Some Internet devices (some firewalls and corporate proxies, for example) intercept
    /// HTTP 4xx and 5xx and prevent the response from being returned to the viewer. If you
    /// substitute <code>200</code>, the response typically won't be intercepted.</p>
    /// </li>
    /// <li>
    /// <p>If you don't care about distinguishing among different client errors or server
    /// errors, you can specify <code>400</code> or <code>500</code> as the
    /// <code>ResponseCode</code> for all 4xx or 5xx errors.</p>
    /// </li>
    /// <li>
    /// <p>You might want to return a <code>200</code> status code (OK) and static website so
    /// your customers don't know that your website is down.</p>
    /// </li>
    /// </ul>
    /// <p>If you specify a value for <code>ResponseCode</code>, you must also specify a value for
    /// <code>ResponsePagePath</code>.</p>
    pub response_code: std::option::Option<std::string::String>,
    /// <p>The minimum amount of time, in seconds, that you want CloudFront to cache the HTTP status
    /// code specified in <code>ErrorCode</code>. When this time period has elapsed, CloudFront queries your
    /// origin to see whether the problem that caused the error has been resolved and the requested
    /// object is now available.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/custom-error-pages.html">Customizing
    /// Error Responses</a> in the <i>Amazon CloudFront Developer Guide</i>.</p>
    pub error_caching_min_ttl: std::option::Option<i64>,
}
impl CustomErrorResponse {
    /// <p>The HTTP status code for which you want to specify a custom error page and/or a caching
    /// duration.</p>
    pub fn error_code(&self) -> std::option::Option<i32> {
        self.error_code
    }
    /// <p>The path to the custom error page that you want CloudFront to return to a viewer when your
    /// origin returns the HTTP status code specified by <code>ErrorCode</code>, for example,
    /// <code>/4xx-errors/403-forbidden.html</code>. If you want to store your objects and your
    /// custom error pages in different locations, your distribution must include a cache behavior for
    /// which the following is true:</p>
    /// <ul>
    /// <li>
    /// <p>The value of <code>PathPattern</code> matches the path to your custom error
    /// messages. For example, suppose you saved custom error pages for 4xx errors in an Amazon S3
    /// bucket in a directory named <code>/4xx-errors</code>. Your distribution must include a
    /// cache behavior for which the path pattern routes requests for your custom error pages to
    /// that location, for example, <code>/4xx-errors/*</code>. </p>
    /// </li>
    /// <li>
    /// <p>The value of <code>TargetOriginId</code> specifies the value of the <code>ID</code>
    /// element for the origin that contains your custom error pages.</p>
    /// </li>
    /// </ul>
    /// <p>If you specify a value for <code>ResponsePagePath</code>, you must also specify a value
    /// for <code>ResponseCode</code>.</p>
    /// <p>We recommend that you store custom error pages in an Amazon S3 bucket. If you store custom
    /// error pages on an HTTP server and the server starts to return 5xx errors, CloudFront can't get the
    /// files that you want to return to viewers because the origin server is unavailable.</p>
    pub fn response_page_path(&self) -> std::option::Option<&str> {
        self.response_page_path.as_deref()
    }
    /// <p>The HTTP status code that you want CloudFront to return to the viewer along with the custom
    /// error page. There are a variety of reasons that you might want CloudFront to return a status code
    /// different from the status code that your origin returned to CloudFront, for example:</p>
    /// <ul>
    /// <li>
    /// <p>Some Internet devices (some firewalls and corporate proxies, for example) intercept
    /// HTTP 4xx and 5xx and prevent the response from being returned to the viewer. If you
    /// substitute <code>200</code>, the response typically won't be intercepted.</p>
    /// </li>
    /// <li>
    /// <p>If you don't care about distinguishing among different client errors or server
    /// errors, you can specify <code>400</code> or <code>500</code> as the
    /// <code>ResponseCode</code> for all 4xx or 5xx errors.</p>
    /// </li>
    /// <li>
    /// <p>You might want to return a <code>200</code> status code (OK) and static website so
    /// your customers don't know that your website is down.</p>
    /// </li>
    /// </ul>
    /// <p>If you specify a value for <code>ResponseCode</code>, you must also specify a value for
    /// <code>ResponsePagePath</code>.</p>
    pub fn response_code(&self) -> std::option::Option<&str> {
        self.response_code.as_deref()
    }
    /// <p>The minimum amount of time, in seconds, that you want CloudFront to cache the HTTP status
    /// code specified in <code>ErrorCode</code>. When this time period has elapsed, CloudFront queries your
    /// origin to see whether the problem that caused the error has been resolved and the requested
    /// object is now available.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/custom-error-pages.html">Customizing
    /// Error Responses</a> in the <i>Amazon CloudFront Developer Guide</i>.</p>
    pub fn error_caching_min_ttl(&self) -> std::option::Option<i64> {
        self.error_caching_min_ttl
    }
}
impl std::fmt::Debug for CustomErrorResponse {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CustomErrorResponse");
        formatter.field("error_code", &self.error_code);
        formatter.field("response_page_path", &self.response_page_path);
        formatter.field("response_code", &self.response_code);
        formatter.field("error_caching_min_ttl", &self.error_caching_min_ttl);
        formatter.finish()
    }
}
/// See [`CustomErrorResponse`](crate::model::CustomErrorResponse)
pub mod custom_error_response {
    /// A builder for [`CustomErrorResponse`](crate::model::CustomErrorResponse)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) error_code: std::option::Option<i32>,
        pub(crate) response_page_path: std::option::Option<std::string::String>,
        pub(crate) response_code: std::option::Option<std::string::String>,
        pub(crate) error_caching_min_ttl: std::option::Option<i64>,
    }
    impl Builder {
        /// <p>The HTTP status code for which you want to specify a custom error page and/or a caching
        /// duration.</p>
        pub fn error_code(mut self, input: i32) -> Self {
            self.error_code = Some(input);
            self
        }
        /// <p>The HTTP status code for which you want to specify a custom error page and/or a caching
        /// duration.</p>
        pub fn set_error_code(mut self, input: std::option::Option<i32>) -> Self {
            self.error_code = input;
            self
        }
        /// <p>The path to the custom error page that you want CloudFront to return to a viewer when your
        /// origin returns the HTTP status code specified by <code>ErrorCode</code>, for example,
        /// <code>/4xx-errors/403-forbidden.html</code>. If you want to store your objects and your
        /// custom error pages in different locations, your distribution must include a cache behavior for
        /// which the following is true:</p>
        /// <ul>
        /// <li>
        /// <p>The value of <code>PathPattern</code> matches the path to your custom error
        /// messages. For example, suppose you saved custom error pages for 4xx errors in an Amazon S3
        /// bucket in a directory named <code>/4xx-errors</code>. Your distribution must include a
        /// cache behavior for which the path pattern routes requests for your custom error pages to
        /// that location, for example, <code>/4xx-errors/*</code>. </p>
        /// </li>
        /// <li>
        /// <p>The value of <code>TargetOriginId</code> specifies the value of the <code>ID</code>
        /// element for the origin that contains your custom error pages.</p>
        /// </li>
        /// </ul>
        /// <p>If you specify a value for <code>ResponsePagePath</code>, you must also specify a value
        /// for <code>ResponseCode</code>.</p>
        /// <p>We recommend that you store custom error pages in an Amazon S3 bucket. If you store custom
        /// error pages on an HTTP server and the server starts to return 5xx errors, CloudFront can't get the
        /// files that you want to return to viewers because the origin server is unavailable.</p>
        pub fn response_page_path(mut self, input: impl Into<std::string::String>) -> Self {
            self.response_page_path = Some(input.into());
            self
        }
        /// <p>The path to the custom error page that you want CloudFront to return to a viewer when your
        /// origin returns the HTTP status code specified by <code>ErrorCode</code>, for example,
        /// <code>/4xx-errors/403-forbidden.html</code>. If you want to store your objects and your
        /// custom error pages in different locations, your distribution must include a cache behavior for
        /// which the following is true:</p>
        /// <ul>
        /// <li>
        /// <p>The value of <code>PathPattern</code> matches the path to your custom error
        /// messages. For example, suppose you saved custom error pages for 4xx errors in an Amazon S3
        /// bucket in a directory named <code>/4xx-errors</code>. Your distribution must include a
        /// cache behavior for which the path pattern routes requests for your custom error pages to
        /// that location, for example, <code>/4xx-errors/*</code>. </p>
        /// </li>
        /// <li>
        /// <p>The value of <code>TargetOriginId</code> specifies the value of the <code>ID</code>
        /// element for the origin that contains your custom error pages.</p>
        /// </li>
        /// </ul>
        /// <p>If you specify a value for <code>ResponsePagePath</code>, you must also specify a value
        /// for <code>ResponseCode</code>.</p>
        /// <p>We recommend that you store custom error pages in an Amazon S3 bucket. If you store custom
        /// error pages on an HTTP server and the server starts to return 5xx errors, CloudFront can't get the
        /// files that you want to return to viewers because the origin server is unavailable.</p>
        pub fn set_response_page_path(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.response_page_path = input;
            self
        }
        /// <p>The HTTP status code that you want CloudFront to return to the viewer along with the custom
        /// error page. There are a variety of reasons that you might want CloudFront to return a status code
        /// different from the status code that your origin returned to CloudFront, for example:</p>
        /// <ul>
        /// <li>
        /// <p>Some Internet devices (some firewalls and corporate proxies, for example) intercept
        /// HTTP 4xx and 5xx and prevent the response from being returned to the viewer. If you
        /// substitute <code>200</code>, the response typically won't be intercepted.</p>
        /// </li>
        /// <li>
        /// <p>If you don't care about distinguishing among different client errors or server
        /// errors, you can specify <code>400</code> or <code>500</code> as the
        /// <code>ResponseCode</code> for all 4xx or 5xx errors.</p>
        /// </li>
        /// <li>
        /// <p>You might want to return a <code>200</code> status code (OK) and static website so
        /// your customers don't know that your website is down.</p>
        /// </li>
        /// </ul>
        /// <p>If you specify a value for <code>ResponseCode</code>, you must also specify a value for
        /// <code>ResponsePagePath</code>.</p>
        pub fn response_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.response_code = Some(input.into());
            self
        }
        /// <p>The HTTP status code that you want CloudFront to return to the viewer along with the custom
        /// error page. There are a variety of reasons that you might want CloudFront to return a status code
        /// different from the status code that your origin returned to CloudFront, for example:</p>
        /// <ul>
        /// <li>
        /// <p>Some Internet devices (some firewalls and corporate proxies, for example) intercept
        /// HTTP 4xx and 5xx and prevent the response from being returned to the viewer. If you
        /// substitute <code>200</code>, the response typically won't be intercepted.</p>
        /// </li>
        /// <li>
        /// <p>If you don't care about distinguishing among different client errors or server
        /// errors, you can specify <code>400</code> or <code>500</code> as the
        /// <code>ResponseCode</code> for all 4xx or 5xx errors.</p>
        /// </li>
        /// <li>
        /// <p>You might want to return a <code>200</code> status code (OK) and static website so
        /// your customers don't know that your website is down.</p>
        /// </li>
        /// </ul>
        /// <p>If you specify a value for <code>ResponseCode</code>, you must also specify a value for
        /// <code>ResponsePagePath</code>.</p>
        pub fn set_response_code(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.response_code = input;
            self
        }
        /// <p>The minimum amount of time, in seconds, that you want CloudFront to cache the HTTP status
        /// code specified in <code>ErrorCode</code>. When this time period has elapsed, CloudFront queries your
        /// origin to see whether the problem that caused the error has been resolved and the requested
        /// object is now available.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/custom-error-pages.html">Customizing
        /// Error Responses</a> in the <i>Amazon CloudFront Developer Guide</i>.</p>
        pub fn error_caching_min_ttl(mut self, input: i64) -> Self {
            self.error_caching_min_ttl = Some(input);
            self
        }
        /// <p>The minimum amount of time, in seconds, that you want CloudFront to cache the HTTP status
        /// code specified in <code>ErrorCode</code>. When this time period has elapsed, CloudFront queries your
        /// origin to see whether the problem that caused the error has been resolved and the requested
        /// object is now available.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/custom-error-pages.html">Customizing
        /// Error Responses</a> in the <i>Amazon CloudFront Developer Guide</i>.</p>
        pub fn set_error_caching_min_ttl(mut self, input: std::option::Option<i64>) -> Self {
            self.error_caching_min_ttl = input;
            self
        }
        /// Consumes the builder and constructs a [`CustomErrorResponse`](crate::model::CustomErrorResponse)
        pub fn build(self) -> crate::model::CustomErrorResponse {
            crate::model::CustomErrorResponse {
                error_code: self.error_code,
                response_page_path: self.response_page_path,
                response_code: self.response_code,
                error_caching_min_ttl: self.error_caching_min_ttl,
            }
        }
    }
}
impl CustomErrorResponse {
    /// Creates a new builder-style object to manufacture [`CustomErrorResponse`](crate::model::CustomErrorResponse)
    pub fn builder() -> crate::model::custom_error_response::Builder {
        crate::model::custom_error_response::Builder::default()
    }
}

/// <p>A complex type that contains zero or more <code>CacheBehavior</code> elements.
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CacheBehaviors {
    /// <p>The number of cache behaviors for this distribution. </p>
    pub quantity: std::option::Option<i32>,
    /// <p>Optional: A complex type that contains cache behaviors for this distribution. If
    /// <code>Quantity</code> is <code>0</code>, you can omit <code>Items</code>.</p>
    pub items: std::option::Option<std::vec::Vec<crate::model::CacheBehavior>>,
}
impl CacheBehaviors {
    /// <p>The number of cache behaviors for this distribution. </p>
    pub fn quantity(&self) -> std::option::Option<i32> {
        self.quantity
    }
    /// <p>Optional: A complex type that contains cache behaviors for this distribution. If
    /// <code>Quantity</code> is <code>0</code>, you can omit <code>Items</code>.</p>
    pub fn items(&self) -> std::option::Option<&[crate::model::CacheBehavior]> {
        self.items.as_deref()
    }
}
impl std::fmt::Debug for CacheBehaviors {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CacheBehaviors");
        formatter.field("quantity", &self.quantity);
        formatter.field("items", &self.items);
        formatter.finish()
    }
}
/// See [`CacheBehaviors`](crate::model::CacheBehaviors)
pub mod cache_behaviors {
    /// A builder for [`CacheBehaviors`](crate::model::CacheBehaviors)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) quantity: std::option::Option<i32>,
        pub(crate) items: std::option::Option<std::vec::Vec<crate::model::CacheBehavior>>,
    }
    impl Builder {
        /// <p>The number of cache behaviors for this distribution. </p>
        pub fn quantity(mut self, input: i32) -> Self {
            self.quantity = Some(input);
            self
        }
        /// <p>The number of cache behaviors for this distribution. </p>
        pub fn set_quantity(mut self, input: std::option::Option<i32>) -> Self {
            self.quantity = input;
            self
        }
        /// Appends an item to `items`.
        ///
        /// To override the contents of this collection use [`set_items`](Self::set_items).
        ///
        /// <p>Optional: A complex type that contains cache behaviors for this distribution. If
        /// <code>Quantity</code> is <code>0</code>, you can omit <code>Items</code>.</p>
        pub fn items(mut self, input: impl Into<crate::model::CacheBehavior>) -> Self {
            let mut v = self.items.unwrap_or_default();
            v.push(input.into());
            self.items = Some(v);
            self
        }
        /// <p>Optional: A complex type that contains cache behaviors for this distribution. If
        /// <code>Quantity</code> is <code>0</code>, you can omit <code>Items</code>.</p>
        pub fn set_items(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::CacheBehavior>>,
        ) -> Self {
            self.items = input;
            self
        }
        /// Consumes the builder and constructs a [`CacheBehaviors`](crate::model::CacheBehaviors)
        pub fn build(self) -> crate::model::CacheBehaviors {
            crate::model::CacheBehaviors {
                quantity: self.quantity,
                items: self.items,
            }
        }
    }
}
impl CacheBehaviors {
    /// Creates a new builder-style object to manufacture [`CacheBehaviors`](crate::model::CacheBehaviors)
    pub fn builder() -> crate::model::cache_behaviors::Builder {
        crate::model::cache_behaviors::Builder::default()
    }
}

/// <p>A complex type that describes how CloudFront processes requests.</p>
/// <p>You must create at least as many cache behaviors (including the default cache behavior) as
/// you have origins if you want CloudFront to serve objects from all of the origins. Each cache
/// behavior specifies the one origin from which you want CloudFront to get objects. If you have
/// two origins and only the default cache behavior, the default cache behavior will cause
/// CloudFront to get objects from one of the origins, but the other origin is never used.</p>
/// <p>For the current quota (formerly known as limit) on the number of cache behaviors that you
/// can add to a distribution, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html">Quotas</a> in the <i>Amazon CloudFront Developer Guide</i>.</p>
/// <p>If you don’t want to specify any cache behaviors, include only an empty
/// <code>CacheBehaviors</code> element. Don’t include an empty <code>CacheBehavior</code>
/// element because this is invalid.</p>
/// <p>To delete all cache behaviors in an existing distribution, update the distribution
/// configuration and include only an empty <code>CacheBehaviors</code> element.</p>
/// <p>To add, change, or remove one or more cache behaviors, update the distribution
/// configuration and specify all of the cache behaviors that you want to include in the updated
/// distribution.</p>
/// <p>For more information about cache behaviors, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-web-values-specify.html#DownloadDistValuesCacheBehavior">Cache Behavior Settings</a> in the <i>Amazon CloudFront Developer Guide</i>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CacheBehavior {
    /// <p>The pattern (for example, <code>images/*.jpg</code>) that specifies which requests to
    /// apply the behavior to. When CloudFront receives a viewer request, the requested path is compared
    /// with path patterns in the order in which cache behaviors are listed in the
    /// distribution.</p>
    /// <note>
    /// <p>You can optionally include a slash (<code>/</code>) at the beginning of the path
    /// pattern. For example, <code>/images/*.jpg</code>. CloudFront behavior is the same with or without
    /// the leading <code>/</code>.</p>
    /// </note>
    /// <p>The path pattern for the default cache behavior is <code>*</code> and cannot be
    /// changed. If the request for an object does not match the path pattern for any cache behaviors,
    /// CloudFront applies the behavior in the default cache behavior.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-web-values-specify.html#DownloadDistValuesPathPattern">Path
    /// Pattern</a> in the <i> Amazon CloudFront Developer Guide</i>.</p>
    pub path_pattern: std::option::Option<std::string::String>,
    /// <p>The value of <code>ID</code> for the origin that you want CloudFront to route requests to
    /// when they match this cache behavior.</p>
    pub target_origin_id: std::option::Option<std::string::String>,
    /// <important>
    /// <p>We recommend using <code>TrustedKeyGroups</code> instead of
    /// <code>TrustedSigners</code>.</p>
    /// </important>
    /// <p>A list of Amazon Web Services account IDs whose public keys CloudFront can use to validate signed URLs or signed
    /// cookies.</p>
    /// <p>When a cache behavior contains trusted signers, CloudFront requires signed URLs or signed cookies
    /// for all requests that match the cache behavior. The URLs or cookies must be signed with
    /// the private key of a CloudFront key pair in the trusted signer’s Amazon Web Services account. The signed URL
    /// or cookie contains information about which public key CloudFront should use to verify the
    /// signature. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html">Serving private content</a> in the <i>Amazon CloudFront Developer Guide</i>.</p>
    pub trusted_signers: std::option::Option<crate::model::TrustedSigners>,
    /// <p>A list of key groups that CloudFront can use to validate signed URLs or signed cookies.</p>
    /// <p>When a cache behavior contains trusted key groups, CloudFront requires signed URLs or signed
    /// cookies for all requests that match the cache behavior. The URLs or cookies must be
    /// signed with a private key whose corresponding public key is in the key group. The signed
    /// URL or cookie contains information about which public key CloudFront should use to verify the
    /// signature. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html">Serving private content</a> in the <i>Amazon CloudFront Developer Guide</i>.</p>
    pub trusted_key_groups: std::option::Option<crate::model::TrustedKeyGroups>,
    /// <p>The protocol that viewers can use to access the files in the origin specified by
    /// <code>TargetOriginId</code> when a request matches the path pattern in
    /// <code>PathPattern</code>. You can specify the following options:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>allow-all</code>: Viewers can use HTTP or HTTPS.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>redirect-to-https</code>: If a viewer submits an HTTP request, CloudFront returns
    /// an HTTP status code of 301 (Moved Permanently) to the viewer along with the HTTPS URL. The
    /// viewer then resubmits the request using the new URL. </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>https-only</code>: If a viewer sends an HTTP request, CloudFront returns an HTTP
    /// status code of 403 (Forbidden). </p>
    /// </li>
    /// </ul>
    /// <p>For more information about requiring the HTTPS protocol, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-https-viewers-to-cloudfront.html">Requiring HTTPS Between Viewers and CloudFront</a> in the
    /// <i>Amazon CloudFront Developer Guide</i>.</p>
    /// <note>
    /// <p>The only way to guarantee that viewers retrieve an object that was fetched from the origin
    /// using HTTPS is never to use any other protocol to fetch the object. If you have
    /// recently changed from HTTP to HTTPS, we recommend that you clear your objects’ cache
    /// because cached objects are protocol agnostic. That means that an edge location will
    /// return an object from the cache regardless of whether the current request protocol
    /// matches the protocol used previously. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Expiration.html">Managing Cache Expiration</a> in the
    /// <i>Amazon CloudFront Developer Guide</i>.</p>
    /// </note>
    pub viewer_protocol_policy: std::option::Option<crate::model::ViewerProtocolPolicy>,
    /// <p>A complex type that controls which HTTP methods CloudFront processes and forwards to your
    /// Amazon S3 bucket or your custom origin. There are three choices:</p>
    /// <ul>
    /// <li>
    /// <p>CloudFront forwards only <code>GET</code> and <code>HEAD</code> requests.</p>
    /// </li>
    /// <li>
    /// <p>CloudFront forwards only <code>GET</code>, <code>HEAD</code>, and <code>OPTIONS</code>
    /// requests.</p>
    /// </li>
    /// <li>
    /// <p>CloudFront forwards <code>GET, HEAD, OPTIONS, PUT, PATCH, POST</code>, and
    /// <code>DELETE</code> requests.</p>
    /// </li>
    /// </ul>
    /// <p>If you pick the third choice, you may need to restrict access to your Amazon S3 bucket or
    /// to your custom origin so users can't perform operations that you don't want them to. For
    /// example, you might not want users to have permissions to delete objects from your
    /// origin.</p>
    pub allowed_methods: std::option::Option<crate::model::AllowedMethods>,
    /// <p>Indicates whether you want to distribute media files in the Microsoft Smooth Streaming
    /// format using the origin that is associated with this cache behavior. If so, specify
    /// <code>true</code>; if not, specify <code>false</code>. If you specify <code>true</code> for
    /// <code>SmoothStreaming</code>, you can still distribute other content using this cache
    /// behavior if the content matches the value of <code>PathPattern</code>. </p>
    pub smooth_streaming: std::option::Option<bool>,
    /// <p>Whether you want CloudFront to automatically compress certain files for this cache behavior.
    /// If so, specify true; if not, specify false. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/ServingCompressedFiles.html">Serving Compressed Files</a> in the
    /// <i>Amazon CloudFront Developer Guide</i>.</p>
    pub compress: std::option::Option<bool>,
    /// <p>A complex type that contains zero or more Lambda@Edge function associations for a cache
    /// behavior.</p>
    pub lambda_function_associations: std::option::Option<crate::model::LambdaFunctionAssociations>,
    /// <p>A list of CloudFront functions that are associated with this cache behavior. CloudFront functions must
    /// be published to the <code>LIVE</code> stage to associate them with a cache
    /// behavior.</p>
    pub function_associations: std::option::Option<crate::model::FunctionAssociations>,
    /// <p>The value of <code>ID</code> for the field-level encryption configuration that you want CloudFront
    /// to use for encrypting specific fields of data for this cache behavior.</p>
    pub field_level_encryption_id: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the real-time log configuration that is attached to this
    /// cache behavior. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/real-time-logs.html">Real-time logs</a> in the <i>Amazon CloudFront Developer Guide</i>.</p>
    pub realtime_log_config_arn: std::option::Option<std::string::String>,
    /// <p>The unique identifier of the cache policy that is attached to this cache behavior. For more
    /// information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy">Creating cache policies</a> or <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-managed-cache-policies.html">Using the managed cache policies</a> in the
    /// <i>Amazon CloudFront Developer Guide</i>.</p>
    /// <p>A <code>CacheBehavior</code> must include either a
    /// <code>CachePolicyId</code> or <code>ForwardedValues</code>. We recommend that you
    /// use a <code>CachePolicyId</code>.</p>
    pub cache_policy_id: std::option::Option<std::string::String>,
    /// <p>The unique identifier of the origin request policy that is attached to this cache behavior.
    /// For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-origin-requests.html#origin-request-create-origin-request-policy">Creating origin request policies</a> or <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-managed-origin-request-policies.html">Using the managed origin request policies</a> in the
    /// <i>Amazon CloudFront Developer Guide</i>.</p>
    pub origin_request_policy_id: std::option::Option<std::string::String>,
    /// <p>The identifier for a response headers policy.</p>
    pub response_headers_policy_id: std::option::Option<std::string::String>,
    /// <p>This field is deprecated. We recommend that you use a cache policy or an origin
    /// request policy instead of this field. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/working-with-policies.html">Working with policies</a> in the
    /// <i>Amazon CloudFront Developer Guide</i>.</p>
    /// <p>If you want to include values in the cache key, use a cache policy. For more
    /// information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy">Creating cache policies</a> or <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-managed-cache-policies.html">Using the managed cache policies</a> in the
    /// <i>Amazon CloudFront Developer Guide</i>.</p>
    /// <p>If you want to send values to the origin but not include them in the cache key, use an
    /// origin request policy. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-origin-requests.html#origin-request-create-origin-request-policy">Creating origin request policies</a> or <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-managed-origin-request-policies.html">Using the managed origin request policies</a> in the
    /// <i>Amazon CloudFront Developer Guide</i>.</p>
    /// <p>A <code>CacheBehavior</code> must include either a
    /// <code>CachePolicyId</code> or <code>ForwardedValues</code>. We recommend that you
    /// use a <code>CachePolicyId</code>.</p>
    /// <p>A complex type that specifies how CloudFront handles query strings, cookies, and HTTP headers.</p>
    pub forwarded_values: std::option::Option<crate::model::ForwardedValues>,
    /// <p>This field is deprecated. We recommend that you use the <code>MinTTL</code> field in a cache
    /// policy instead of this field. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy">Creating cache policies</a> or <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-managed-cache-policies.html">Using the managed cache policies</a> in the
    /// <i>Amazon CloudFront Developer Guide</i>.</p>
    /// <p>The minimum amount of time that you want objects to stay in CloudFront caches before CloudFront
    /// forwards another request to your origin to determine whether the object has been updated. For
    /// more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Expiration.html">
    /// Managing How Long Content Stays in an Edge Cache (Expiration)</a> in the <i>
    /// Amazon CloudFront Developer Guide</i>.</p>
    /// <p>You must specify <code>0</code> for <code>MinTTL</code> if you configure CloudFront to
    /// forward all headers to your origin (under <code>Headers</code>, if you specify <code>1</code>
    /// for <code>Quantity</code> and <code>*</code> for <code>Name</code>).</p>
    pub min_ttl: std::option::Option<i64>,
    /// <p>This field is deprecated. We recommend that you use the <code>DefaultTTL</code> field in a
    /// cache policy instead of this field. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy">Creating cache policies</a> or <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-managed-cache-policies.html">Using the managed cache policies</a> in the
    /// <i>Amazon CloudFront Developer Guide</i>.</p>
    /// <p>The default amount of time that you want objects to stay in CloudFront caches before CloudFront
    /// forwards another request to your origin to determine whether the object has been updated. The
    /// value that you specify applies only when your origin does not add HTTP headers such as
    /// <code>Cache-Control max-age</code>, <code>Cache-Control s-maxage</code>, and
    /// <code>Expires</code> to objects. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Expiration.html">Managing How Long Content Stays
    /// in an Edge Cache (Expiration)</a> in the <i>Amazon CloudFront Developer Guide</i>.</p>
    pub default_ttl: std::option::Option<i64>,
    /// <p>This field is deprecated. We recommend that you use the <code>MaxTTL</code> field in a cache
    /// policy instead of this field. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy">Creating cache policies</a> or <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-managed-cache-policies.html">Using the managed cache policies</a> in the
    /// <i>Amazon CloudFront Developer Guide</i>.</p>
    /// <p>The maximum amount of time that you want objects to stay in CloudFront caches before CloudFront
    /// forwards another request to your origin to determine whether the object has been updated. The
    /// value that you specify applies only when your origin adds HTTP headers such as
    /// <code>Cache-Control max-age</code>, <code>Cache-Control s-maxage</code>, and
    /// <code>Expires</code> to objects. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Expiration.html">Managing How Long Content Stays
    /// in an Edge Cache (Expiration)</a> in the <i>Amazon CloudFront Developer Guide</i>.</p>
    pub max_ttl: std::option::Option<i64>,
}
impl CacheBehavior {
    /// <p>The pattern (for example, <code>images/*.jpg</code>) that specifies which requests to
    /// apply the behavior to. When CloudFront receives a viewer request, the requested path is compared
    /// with path patterns in the order in which cache behaviors are listed in the
    /// distribution.</p>
    /// <note>
    /// <p>You can optionally include a slash (<code>/</code>) at the beginning of the path
    /// pattern. For example, <code>/images/*.jpg</code>. CloudFront behavior is the same with or without
    /// the leading <code>/</code>.</p>
    /// </note>
    /// <p>The path pattern for the default cache behavior is <code>*</code> and cannot be
    /// changed. If the request for an object does not match the path pattern for any cache behaviors,
    /// CloudFront applies the behavior in the default cache behavior.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-web-values-specify.html#DownloadDistValuesPathPattern">Path
    /// Pattern</a> in the <i> Amazon CloudFront Developer Guide</i>.</p>
    pub fn path_pattern(&self) -> std::option::Option<&str> {
        self.path_pattern.as_deref()
    }
    /// <p>The value of <code>ID</code> for the origin that you want CloudFront to route requests to
    /// when they match this cache behavior.</p>
    pub fn target_origin_id(&self) -> std::option::Option<&str> {
        self.target_origin_id.as_deref()
    }
    /// <important>
    /// <p>We recommend using <code>TrustedKeyGroups</code> instead of
    /// <code>TrustedSigners</code>.</p>
    /// </important>
    /// <p>A list of Amazon Web Services account IDs whose public keys CloudFront can use to validate signed URLs or signed
    /// cookies.</p>
    /// <p>When a cache behavior contains trusted signers, CloudFront requires signed URLs or signed cookies
    /// for all requests that match the cache behavior. The URLs or cookies must be signed with
    /// the private key of a CloudFront key pair in the trusted signer’s Amazon Web Services account. The signed URL
    /// or cookie contains information about which public key CloudFront should use to verify the
    /// signature. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html">Serving private content</a> in the <i>Amazon CloudFront Developer Guide</i>.</p>
    pub fn trusted_signers(&self) -> std::option::Option<&crate::model::TrustedSigners> {
        self.trusted_signers.as_ref()
    }
    /// <p>A list of key groups that CloudFront can use to validate signed URLs or signed cookies.</p>
    /// <p>When a cache behavior contains trusted key groups, CloudFront requires signed URLs or signed
    /// cookies for all requests that match the cache behavior. The URLs or cookies must be
    /// signed with a private key whose corresponding public key is in the key group. The signed
    /// URL or cookie contains information about which public key CloudFront should use to verify the
    /// signature. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html">Serving private content</a> in the <i>Amazon CloudFront Developer Guide</i>.</p>
    pub fn trusted_key_groups(&self) -> std::option::Option<&crate::model::TrustedKeyGroups> {
        self.trusted_key_groups.as_ref()
    }
    /// <p>The protocol that viewers can use to access the files in the origin specified by
    /// <code>TargetOriginId</code> when a request matches the path pattern in
    /// <code>PathPattern</code>. You can specify the following options:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>allow-all</code>: Viewers can use HTTP or HTTPS.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>redirect-to-https</code>: If a viewer submits an HTTP request, CloudFront returns
    /// an HTTP status code of 301 (Moved Permanently) to the viewer along with the HTTPS URL. The
    /// viewer then resubmits the request using the new URL. </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>https-only</code>: If a viewer sends an HTTP request, CloudFront returns an HTTP
    /// status code of 403 (Forbidden). </p>
    /// </li>
    /// </ul>
    /// <p>For more information about requiring the HTTPS protocol, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-https-viewers-to-cloudfront.html">Requiring HTTPS Between Viewers and CloudFront</a> in the
    /// <i>Amazon CloudFront Developer Guide</i>.</p>
    /// <note>
    /// <p>The only way to guarantee that viewers retrieve an object that was fetched from the origin
    /// using HTTPS is never to use any other protocol to fetch the object. If you have
    /// recently changed from HTTP to HTTPS, we recommend that you clear your objects’ cache
    /// because cached objects are protocol agnostic. That means that an edge location will
    /// return an object from the cache regardless of whether the current request protocol
    /// matches the protocol used previously. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Expiration.html">Managing Cache Expiration</a> in the
    /// <i>Amazon CloudFront Developer Guide</i>.</p>
    /// </note>
    pub fn viewer_protocol_policy(
        &self,
    ) -> std::option::Option<&crate::model::ViewerProtocolPolicy> {
        self.viewer_protocol_policy.as_ref()
    }
    /// <p>A complex type that controls which HTTP methods CloudFront processes and forwards to your
    /// Amazon S3 bucket or your custom origin. There are three choices:</p>
    /// <ul>
    /// <li>
    /// <p>CloudFront forwards only <code>GET</code> and <code>HEAD</code> requests.</p>
    /// </li>
    /// <li>
    /// <p>CloudFront forwards only <code>GET</code>, <code>HEAD</code>, and <code>OPTIONS</code>
    /// requests.</p>
    /// </li>
    /// <li>
    /// <p>CloudFront forwards <code>GET, HEAD, OPTIONS, PUT, PATCH, POST</code>, and
    /// <code>DELETE</code> requests.</p>
    /// </li>
    /// </ul>
    /// <p>If you pick the third choice, you may need to restrict access to your Amazon S3 bucket or
    /// to your custom origin so users can't perform operations that you don't want them to. For
    /// example, you might not want users to have permissions to delete objects from your
    /// origin.</p>
    pub fn allowed_methods(&self) -> std::option::Option<&crate::model::AllowedMethods> {
        self.allowed_methods.as_ref()
    }
    /// <p>Indicates whether you want to distribute media files in the Microsoft Smooth Streaming
    /// format using the origin that is associated with this cache behavior. If so, specify
    /// <code>true</code>; if not, specify <code>false</code>. If you specify <code>true</code> for
    /// <code>SmoothStreaming</code>, you can still distribute other content using this cache
    /// behavior if the content matches the value of <code>PathPattern</code>. </p>
    pub fn smooth_streaming(&self) -> std::option::Option<bool> {
        self.smooth_streaming
    }
    /// <p>Whether you want CloudFront to automatically compress certain files for this cache behavior.
    /// If so, specify true; if not, specify false. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/ServingCompressedFiles.html">Serving Compressed Files</a> in the
    /// <i>Amazon CloudFront Developer Guide</i>.</p>
    pub fn compress(&self) -> std::option::Option<bool> {
        self.compress
    }
    /// <p>A complex type that contains zero or more Lambda@Edge function associations for a cache
    /// behavior.</p>
    pub fn lambda_function_associations(
        &self,
    ) -> std::option::Option<&crate::model::LambdaFunctionAssociations> {
        self.lambda_function_associations.as_ref()
    }
    /// <p>A list of CloudFront functions that are associated with this cache behavior. CloudFront functions must
    /// be published to the <code>LIVE</code> stage to associate them with a cache
    /// behavior.</p>
    pub fn function_associations(
        &self,
    ) -> std::option::Option<&crate::model::FunctionAssociations> {
        self.function_associations.as_ref()
    }
    /// <p>The value of <code>ID</code> for the field-level encryption configuration that you want CloudFront
    /// to use for encrypting specific fields of data for this cache behavior.</p>
    pub fn field_level_encryption_id(&self) -> std::option::Option<&str> {
        self.field_level_encryption_id.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the real-time log configuration that is attached to this
    /// cache behavior. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/real-time-logs.html">Real-time logs</a> in the <i>Amazon CloudFront Developer Guide</i>.</p>
    pub fn realtime_log_config_arn(&self) -> std::option::Option<&str> {
        self.realtime_log_config_arn.as_deref()
    }
    /// <p>The unique identifier of the cache policy that is attached to this cache behavior. For more
    /// information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy">Creating cache policies</a> or <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-managed-cache-policies.html">Using the managed cache policies</a> in the
    /// <i>Amazon CloudFront Developer Guide</i>.</p>
    /// <p>A <code>CacheBehavior</code> must include either a
    /// <code>CachePolicyId</code> or <code>ForwardedValues</code>. We recommend that you
    /// use a <code>CachePolicyId</code>.</p>
    pub fn cache_policy_id(&self) -> std::option::Option<&str> {
        self.cache_policy_id.as_deref()
    }
    /// <p>The unique identifier of the origin request policy that is attached to this cache behavior.
    /// For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-origin-requests.html#origin-request-create-origin-request-policy">Creating origin request policies</a> or <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-managed-origin-request-policies.html">Using the managed origin request policies</a> in the
    /// <i>Amazon CloudFront Developer Guide</i>.</p>
    pub fn origin_request_policy_id(&self) -> std::option::Option<&str> {
        self.origin_request_policy_id.as_deref()
    }
    /// <p>The identifier for a response headers policy.</p>
    pub fn response_headers_policy_id(&self) -> std::option::Option<&str> {
        self.response_headers_policy_id.as_deref()
    }
    /// <p>This field is deprecated. We recommend that you use a cache policy or an origin
    /// request policy instead of this field. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/working-with-policies.html">Working with policies</a> in the
    /// <i>Amazon CloudFront Developer Guide</i>.</p>
    /// <p>If you want to include values in the cache key, use a cache policy. For more
    /// information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy">Creating cache policies</a> or <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-managed-cache-policies.html">Using the managed cache policies</a> in the
    /// <i>Amazon CloudFront Developer Guide</i>.</p>
    /// <p>If you want to send values to the origin but not include them in the cache key, use an
    /// origin request policy. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-origin-requests.html#origin-request-create-origin-request-policy">Creating origin request policies</a> or <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-managed-origin-request-policies.html">Using the managed origin request policies</a> in the
    /// <i>Amazon CloudFront Developer Guide</i>.</p>
    /// <p>A <code>CacheBehavior</code> must include either a
    /// <code>CachePolicyId</code> or <code>ForwardedValues</code>. We recommend that you
    /// use a <code>CachePolicyId</code>.</p>
    /// <p>A complex type that specifies how CloudFront handles query strings, cookies, and HTTP headers.</p>
    pub fn forwarded_values(&self) -> std::option::Option<&crate::model::ForwardedValues> {
        self.forwarded_values.as_ref()
    }
    /// <p>This field is deprecated. We recommend that you use the <code>MinTTL</code> field in a cache
    /// policy instead of this field. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy">Creating cache policies</a> or <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-managed-cache-policies.html">Using the managed cache policies</a> in the
    /// <i>Amazon CloudFront Developer Guide</i>.</p>
    /// <p>The minimum amount of time that you want objects to stay in CloudFront caches before CloudFront
    /// forwards another request to your origin to determine whether the object has been updated. For
    /// more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Expiration.html">
    /// Managing How Long Content Stays in an Edge Cache (Expiration)</a> in the <i>
    /// Amazon CloudFront Developer Guide</i>.</p>
    /// <p>You must specify <code>0</code> for <code>MinTTL</code> if you configure CloudFront to
    /// forward all headers to your origin (under <code>Headers</code>, if you specify <code>1</code>
    /// for <code>Quantity</code> and <code>*</code> for <code>Name</code>).</p>
    pub fn min_ttl(&self) -> std::option::Option<i64> {
        self.min_ttl
    }
    /// <p>This field is deprecated. We recommend that you use the <code>DefaultTTL</code> field in a
    /// cache policy instead of this field. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy">Creating cache policies</a> or <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-managed-cache-policies.html">Using the managed cache policies</a> in the
    /// <i>Amazon CloudFront Developer Guide</i>.</p>
    /// <p>The default amount of time that you want objects to stay in CloudFront caches before CloudFront
    /// forwards another request to your origin to determine whether the object has been updated. The
    /// value that you specify applies only when your origin does not add HTTP headers such as
    /// <code>Cache-Control max-age</code>, <code>Cache-Control s-maxage</code>, and
    /// <code>Expires</code> to objects. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Expiration.html">Managing How Long Content Stays
    /// in an Edge Cache (Expiration)</a> in the <i>Amazon CloudFront Developer Guide</i>.</p>
    pub fn default_ttl(&self) -> std::option::Option<i64> {
        self.default_ttl
    }
    /// <p>This field is deprecated. We recommend that you use the <code>MaxTTL</code> field in a cache
    /// policy instead of this field. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy">Creating cache policies</a> or <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-managed-cache-policies.html">Using the managed cache policies</a> in the
    /// <i>Amazon CloudFront Developer Guide</i>.</p>
    /// <p>The maximum amount of time that you want objects to stay in CloudFront caches before CloudFront
    /// forwards another request to your origin to determine whether the object has been updated. The
    /// value that you specify applies only when your origin adds HTTP headers such as
    /// <code>Cache-Control max-age</code>, <code>Cache-Control s-maxage</code>, and
    /// <code>Expires</code> to objects. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Expiration.html">Managing How Long Content Stays
    /// in an Edge Cache (Expiration)</a> in the <i>Amazon CloudFront Developer Guide</i>.</p>
    pub fn max_ttl(&self) -> std::option::Option<i64> {
        self.max_ttl
    }
}
impl std::fmt::Debug for CacheBehavior {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CacheBehavior");
        formatter.field("path_pattern", &self.path_pattern);
        formatter.field("target_origin_id", &self.target_origin_id);
        formatter.field("trusted_signers", &self.trusted_signers);
        formatter.field("trusted_key_groups", &self.trusted_key_groups);
        formatter.field("viewer_protocol_policy", &self.viewer_protocol_policy);
        formatter.field("allowed_methods", &self.allowed_methods);
        formatter.field("smooth_streaming", &self.smooth_streaming);
        formatter.field("compress", &self.compress);
        formatter.field(
            "lambda_function_associations",
            &self.lambda_function_associations,
        );
        formatter.field("function_associations", &self.function_associations);
        formatter.field("field_level_encryption_id", &self.field_level_encryption_id);
        formatter.field("realtime_log_config_arn", &self.realtime_log_config_arn);
        formatter.field("cache_policy_id", &self.cache_policy_id);
        formatter.field("origin_request_policy_id", &self.origin_request_policy_id);
        formatter.field(
            "response_headers_policy_id",
            &self.response_headers_policy_id,
        );
        formatter.field("forwarded_values", &self.forwarded_values);
        formatter.field("min_ttl", &self.min_ttl);
        formatter.field("default_ttl", &self.default_ttl);
        formatter.field("max_ttl", &self.max_ttl);
        formatter.finish()
    }
}
/// See [`CacheBehavior`](crate::model::CacheBehavior)
pub mod cache_behavior {
    /// A builder for [`CacheBehavior`](crate::model::CacheBehavior)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) path_pattern: std::option::Option<std::string::String>,
        pub(crate) target_origin_id: std::option::Option<std::string::String>,
        pub(crate) trusted_signers: std::option::Option<crate::model::TrustedSigners>,
        pub(crate) trusted_key_groups: std::option::Option<crate::model::TrustedKeyGroups>,
        pub(crate) viewer_protocol_policy: std::option::Option<crate::model::ViewerProtocolPolicy>,
        pub(crate) allowed_methods: std::option::Option<crate::model::AllowedMethods>,
        pub(crate) smooth_streaming: std::option::Option<bool>,
        pub(crate) compress: std::option::Option<bool>,
        pub(crate) lambda_function_associations:
            std::option::Option<crate::model::LambdaFunctionAssociations>,
        pub(crate) function_associations: std::option::Option<crate::model::FunctionAssociations>,
        pub(crate) field_level_encryption_id: std::option::Option<std::string::String>,
        pub(crate) realtime_log_config_arn: std::option::Option<std::string::String>,
        pub(crate) cache_policy_id: std::option::Option<std::string::String>,
        pub(crate) origin_request_policy_id: std::option::Option<std::string::String>,
        pub(crate) response_headers_policy_id: std::option::Option<std::string::String>,
        pub(crate) forwarded_values: std::option::Option<crate::model::ForwardedValues>,
        pub(crate) min_ttl: std::option::Option<i64>,
        pub(crate) default_ttl: std::option::Option<i64>,
        pub(crate) max_ttl: std::option::Option<i64>,
    }
    impl Builder {
        /// <p>The pattern (for example, <code>images/*.jpg</code>) that specifies which requests to
        /// apply the behavior to. When CloudFront receives a viewer request, the requested path is compared
        /// with path patterns in the order in which cache behaviors are listed in the
        /// distribution.</p>
        /// <note>
        /// <p>You can optionally include a slash (<code>/</code>) at the beginning of the path
        /// pattern. For example, <code>/images/*.jpg</code>. CloudFront behavior is the same with or without
        /// the leading <code>/</code>.</p>
        /// </note>
        /// <p>The path pattern for the default cache behavior is <code>*</code> and cannot be
        /// changed. If the request for an object does not match the path pattern for any cache behaviors,
        /// CloudFront applies the behavior in the default cache behavior.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-web-values-specify.html#DownloadDistValuesPathPattern">Path
        /// Pattern</a> in the <i> Amazon CloudFront Developer Guide</i>.</p>
        pub fn path_pattern(mut self, input: impl Into<std::string::String>) -> Self {
            self.path_pattern = Some(input.into());
            self
        }
        /// <p>The pattern (for example, <code>images/*.jpg</code>) that specifies which requests to
        /// apply the behavior to. When CloudFront receives a viewer request, the requested path is compared
        /// with path patterns in the order in which cache behaviors are listed in the
        /// distribution.</p>
        /// <note>
        /// <p>You can optionally include a slash (<code>/</code>) at the beginning of the path
        /// pattern. For example, <code>/images/*.jpg</code>. CloudFront behavior is the same with or without
        /// the leading <code>/</code>.</p>
        /// </note>
        /// <p>The path pattern for the default cache behavior is <code>*</code> and cannot be
        /// changed. If the request for an object does not match the path pattern for any cache behaviors,
        /// CloudFront applies the behavior in the default cache behavior.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-web-values-specify.html#DownloadDistValuesPathPattern">Path
        /// Pattern</a> in the <i> Amazon CloudFront Developer Guide</i>.</p>
        pub fn set_path_pattern(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.path_pattern = input;
            self
        }
        /// <p>The value of <code>ID</code> for the origin that you want CloudFront to route requests to
        /// when they match this cache behavior.</p>
        pub fn target_origin_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.target_origin_id = Some(input.into());
            self
        }
        /// <p>The value of <code>ID</code> for the origin that you want CloudFront to route requests to
        /// when they match this cache behavior.</p>
        pub fn set_target_origin_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.target_origin_id = input;
            self
        }
        /// <important>
        /// <p>We recommend using <code>TrustedKeyGroups</code> instead of
        /// <code>TrustedSigners</code>.</p>
        /// </important>
        /// <p>A list of Amazon Web Services account IDs whose public keys CloudFront can use to validate signed URLs or signed
        /// cookies.</p>
        /// <p>When a cache behavior contains trusted signers, CloudFront requires signed URLs or signed cookies
        /// for all requests that match the cache behavior. The URLs or cookies must be signed with
        /// the private key of a CloudFront key pair in the trusted signer’s Amazon Web Services account. The signed URL
        /// or cookie contains information about which public key CloudFront should use to verify the
        /// signature. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html">Serving private content</a> in the <i>Amazon CloudFront Developer Guide</i>.</p>
        pub fn trusted_signers(mut self, input: crate::model::TrustedSigners) -> Self {
            self.trusted_signers = Some(input);
            self
        }
        /// <important>
        /// <p>We recommend using <code>TrustedKeyGroups</code> instead of
        /// <code>TrustedSigners</code>.</p>
        /// </important>
        /// <p>A list of Amazon Web Services account IDs whose public keys CloudFront can use to validate signed URLs or signed
        /// cookies.</p>
        /// <p>When a cache behavior contains trusted signers, CloudFront requires signed URLs or signed cookies
        /// for all requests that match the cache behavior. The URLs or cookies must be signed with
        /// the private key of a CloudFront key pair in the trusted signer’s Amazon Web Services account. The signed URL
        /// or cookie contains information about which public key CloudFront should use to verify the
        /// signature. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html">Serving private content</a> in the <i>Amazon CloudFront Developer Guide</i>.</p>
        pub fn set_trusted_signers(
            mut self,
            input: std::option::Option<crate::model::TrustedSigners>,
        ) -> Self {
            self.trusted_signers = input;
            self
        }
        /// <p>A list of key groups that CloudFront can use to validate signed URLs or signed cookies.</p>
        /// <p>When a cache behavior contains trusted key groups, CloudFront requires signed URLs or signed
        /// cookies for all requests that match the cache behavior. The URLs or cookies must be
        /// signed with a private key whose corresponding public key is in the key group. The signed
        /// URL or cookie contains information about which public key CloudFront should use to verify the
        /// signature. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html">Serving private content</a> in the <i>Amazon CloudFront Developer Guide</i>.</p>
        pub fn trusted_key_groups(mut self, input: crate::model::TrustedKeyGroups) -> Self {
            self.trusted_key_groups = Some(input);
            self
        }
        /// <p>A list of key groups that CloudFront can use to validate signed URLs or signed cookies.</p>
        /// <p>When a cache behavior contains trusted key groups, CloudFront requires signed URLs or signed
        /// cookies for all requests that match the cache behavior. The URLs or cookies must be
        /// signed with a private key whose corresponding public key is in the key group. The signed
        /// URL or cookie contains information about which public key CloudFront should use to verify the
        /// signature. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html">Serving private content</a> in the <i>Amazon CloudFront Developer Guide</i>.</p>
        pub fn set_trusted_key_groups(
            mut self,
            input: std::option::Option<crate::model::TrustedKeyGroups>,
        ) -> Self {
            self.trusted_key_groups = input;
            self
        }
        /// <p>The protocol that viewers can use to access the files in the origin specified by
        /// <code>TargetOriginId</code> when a request matches the path pattern in
        /// <code>PathPattern</code>. You can specify the following options:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>allow-all</code>: Viewers can use HTTP or HTTPS.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>redirect-to-https</code>: If a viewer submits an HTTP request, CloudFront returns
        /// an HTTP status code of 301 (Moved Permanently) to the viewer along with the HTTPS URL. The
        /// viewer then resubmits the request using the new URL. </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>https-only</code>: If a viewer sends an HTTP request, CloudFront returns an HTTP
        /// status code of 403 (Forbidden). </p>
        /// </li>
        /// </ul>
        /// <p>For more information about requiring the HTTPS protocol, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-https-viewers-to-cloudfront.html">Requiring HTTPS Between Viewers and CloudFront</a> in the
        /// <i>Amazon CloudFront Developer Guide</i>.</p>
        /// <note>
        /// <p>The only way to guarantee that viewers retrieve an object that was fetched from the origin
        /// using HTTPS is never to use any other protocol to fetch the object. If you have
        /// recently changed from HTTP to HTTPS, we recommend that you clear your objects’ cache
        /// because cached objects are protocol agnostic. That means that an edge location will
        /// return an object from the cache regardless of whether the current request protocol
        /// matches the protocol used previously. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Expiration.html">Managing Cache Expiration</a> in the
        /// <i>Amazon CloudFront Developer Guide</i>.</p>
        /// </note>
        pub fn viewer_protocol_policy(mut self, input: crate::model::ViewerProtocolPolicy) -> Self {
            self.viewer_protocol_policy = Some(input);
            self
        }
        /// <p>The protocol that viewers can use to access the files in the origin specified by
        /// <code>TargetOriginId</code> when a request matches the path pattern in
        /// <code>PathPattern</code>. You can specify the following options:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>allow-all</code>: Viewers can use HTTP or HTTPS.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>redirect-to-https</code>: If a viewer submits an HTTP request, CloudFront returns
        /// an HTTP status code of 301 (Moved Permanently) to the viewer along with the HTTPS URL. The
        /// viewer then resubmits the request using the new URL. </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>https-only</code>: If a viewer sends an HTTP request, CloudFront returns an HTTP
        /// status code of 403 (Forbidden). </p>
        /// </li>
        /// </ul>
        /// <p>For more information about requiring the HTTPS protocol, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-https-viewers-to-cloudfront.html">Requiring HTTPS Between Viewers and CloudFront</a> in the
        /// <i>Amazon CloudFront Developer Guide</i>.</p>
        /// <note>
        /// <p>The only way to guarantee that viewers retrieve an object that was fetched from the origin
        /// using HTTPS is never to use any other protocol to fetch the object. If you have
        /// recently changed from HTTP to HTTPS, we recommend that you clear your objects’ cache
        /// because cached objects are protocol agnostic. That means that an edge location will
        /// return an object from the cache regardless of whether the current request protocol
        /// matches the protocol used previously. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Expiration.html">Managing Cache Expiration</a> in the
        /// <i>Amazon CloudFront Developer Guide</i>.</p>
        /// </note>
        pub fn set_viewer_protocol_policy(
            mut self,
            input: std::option::Option<crate::model::ViewerProtocolPolicy>,
        ) -> Self {
            self.viewer_protocol_policy = input;
            self
        }
        /// <p>A complex type that controls which HTTP methods CloudFront processes and forwards to your
        /// Amazon S3 bucket or your custom origin. There are three choices:</p>
        /// <ul>
        /// <li>
        /// <p>CloudFront forwards only <code>GET</code> and <code>HEAD</code> requests.</p>
        /// </li>
        /// <li>
        /// <p>CloudFront forwards only <code>GET</code>, <code>HEAD</code>, and <code>OPTIONS</code>
        /// requests.</p>
        /// </li>
        /// <li>
        /// <p>CloudFront forwards <code>GET, HEAD, OPTIONS, PUT, PATCH, POST</code>, and
        /// <code>DELETE</code> requests.</p>
        /// </li>
        /// </ul>
        /// <p>If you pick the third choice, you may need to restrict access to your Amazon S3 bucket or
        /// to your custom origin so users can't perform operations that you don't want them to. For
        /// example, you might not want users to have permissions to delete objects from your
        /// origin.</p>
        pub fn allowed_methods(mut self, input: crate::model::AllowedMethods) -> Self {
            self.allowed_methods = Some(input);
            self
        }
        /// <p>A complex type that controls which HTTP methods CloudFront processes and forwards to your
        /// Amazon S3 bucket or your custom origin. There are three choices:</p>
        /// <ul>
        /// <li>
        /// <p>CloudFront forwards only <code>GET</code> and <code>HEAD</code> requests.</p>
        /// </li>
        /// <li>
        /// <p>CloudFront forwards only <code>GET</code>, <code>HEAD</code>, and <code>OPTIONS</code>
        /// requests.</p>
        /// </li>
        /// <li>
        /// <p>CloudFront forwards <code>GET, HEAD, OPTIONS, PUT, PATCH, POST</code>, and
        /// <code>DELETE</code> requests.</p>
        /// </li>
        /// </ul>
        /// <p>If you pick the third choice, you may need to restrict access to your Amazon S3 bucket or
        /// to your custom origin so users can't perform operations that you don't want them to. For
        /// example, you might not want users to have permissions to delete objects from your
        /// origin.</p>
        pub fn set_allowed_methods(
            mut self,
            input: std::option::Option<crate::model::AllowedMethods>,
        ) -> Self {
            self.allowed_methods = input;
            self
        }
        /// <p>Indicates whether you want to distribute media files in the Microsoft Smooth Streaming
        /// format using the origin that is associated with this cache behavior. If so, specify
        /// <code>true</code>; if not, specify <code>false</code>. If you specify <code>true</code> for
        /// <code>SmoothStreaming</code>, you can still distribute other content using this cache
        /// behavior if the content matches the value of <code>PathPattern</code>. </p>
        pub fn smooth_streaming(mut self, input: bool) -> Self {
            self.smooth_streaming = Some(input);
            self
        }
        /// <p>Indicates whether you want to distribute media files in the Microsoft Smooth Streaming
        /// format using the origin that is associated with this cache behavior. If so, specify
        /// <code>true</code>; if not, specify <code>false</code>. If you specify <code>true</code> for
        /// <code>SmoothStreaming</code>, you can still distribute other content using this cache
        /// behavior if the content matches the value of <code>PathPattern</code>. </p>
        pub fn set_smooth_streaming(mut self, input: std::option::Option<bool>) -> Self {
            self.smooth_streaming = input;
            self
        }
        /// <p>Whether you want CloudFront to automatically compress certain files for this cache behavior.
        /// If so, specify true; if not, specify false. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/ServingCompressedFiles.html">Serving Compressed Files</a> in the
        /// <i>Amazon CloudFront Developer Guide</i>.</p>
        pub fn compress(mut self, input: bool) -> Self {
            self.compress = Some(input);
            self
        }
        /// <p>Whether you want CloudFront to automatically compress certain files for this cache behavior.
        /// If so, specify true; if not, specify false. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/ServingCompressedFiles.html">Serving Compressed Files</a> in the
        /// <i>Amazon CloudFront Developer Guide</i>.</p>
        pub fn set_compress(mut self, input: std::option::Option<bool>) -> Self {
            self.compress = input;
            self
        }
        /// <p>A complex type that contains zero or more Lambda@Edge function associations for a cache
        /// behavior.</p>
        pub fn lambda_function_associations(
            mut self,
            input: crate::model::LambdaFunctionAssociations,
        ) -> Self {
            self.lambda_function_associations = Some(input);
            self
        }
        /// <p>A complex type that contains zero or more Lambda@Edge function associations for a cache
        /// behavior.</p>
        pub fn set_lambda_function_associations(
            mut self,
            input: std::option::Option<crate::model::LambdaFunctionAssociations>,
        ) -> Self {
            self.lambda_function_associations = input;
            self
        }
        /// <p>A list of CloudFront functions that are associated with this cache behavior. CloudFront functions must
        /// be published to the <code>LIVE</code> stage to associate them with a cache
        /// behavior.</p>
        pub fn function_associations(mut self, input: crate::model::FunctionAssociations) -> Self {
            self.function_associations = Some(input);
            self
        }
        /// <p>A list of CloudFront functions that are associated with this cache behavior. CloudFront functions must
        /// be published to the <code>LIVE</code> stage to associate them with a cache
        /// behavior.</p>
        pub fn set_function_associations(
            mut self,
            input: std::option::Option<crate::model::FunctionAssociations>,
        ) -> Self {
            self.function_associations = input;
            self
        }
        /// <p>The value of <code>ID</code> for the field-level encryption configuration that you want CloudFront
        /// to use for encrypting specific fields of data for this cache behavior.</p>
        pub fn field_level_encryption_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.field_level_encryption_id = Some(input.into());
            self
        }
        /// <p>The value of <code>ID</code> for the field-level encryption configuration that you want CloudFront
        /// to use for encrypting specific fields of data for this cache behavior.</p>
        pub fn set_field_level_encryption_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.field_level_encryption_id = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the real-time log configuration that is attached to this
        /// cache behavior. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/real-time-logs.html">Real-time logs</a> in the <i>Amazon CloudFront Developer Guide</i>.</p>
        pub fn realtime_log_config_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.realtime_log_config_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the real-time log configuration that is attached to this
        /// cache behavior. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/real-time-logs.html">Real-time logs</a> in the <i>Amazon CloudFront Developer Guide</i>.</p>
        pub fn set_realtime_log_config_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.realtime_log_config_arn = input;
            self
        }
        /// <p>The unique identifier of the cache policy that is attached to this cache behavior. For more
        /// information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy">Creating cache policies</a> or <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-managed-cache-policies.html">Using the managed cache policies</a> in the
        /// <i>Amazon CloudFront Developer Guide</i>.</p>
        /// <p>A <code>CacheBehavior</code> must include either a
        /// <code>CachePolicyId</code> or <code>ForwardedValues</code>. We recommend that you
        /// use a <code>CachePolicyId</code>.</p>
        pub fn cache_policy_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.cache_policy_id = Some(input.into());
            self
        }
        /// <p>The unique identifier of the cache policy that is attached to this cache behavior. For more
        /// information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy">Creating cache policies</a> or <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-managed-cache-policies.html">Using the managed cache policies</a> in the
        /// <i>Amazon CloudFront Developer Guide</i>.</p>
        /// <p>A <code>CacheBehavior</code> must include either a
        /// <code>CachePolicyId</code> or <code>ForwardedValues</code>. We recommend that you
        /// use a <code>CachePolicyId</code>.</p>
        pub fn set_cache_policy_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.cache_policy_id = input;
            self
        }
        /// <p>The unique identifier of the origin request policy that is attached to this cache behavior.
        /// For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-origin-requests.html#origin-request-create-origin-request-policy">Creating origin request policies</a> or <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-managed-origin-request-policies.html">Using the managed origin request policies</a> in the
        /// <i>Amazon CloudFront Developer Guide</i>.</p>
        pub fn origin_request_policy_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.origin_request_policy_id = Some(input.into());
            self
        }
        /// <p>The unique identifier of the origin request policy that is attached to this cache behavior.
        /// For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-origin-requests.html#origin-request-create-origin-request-policy">Creating origin request policies</a> or <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-managed-origin-request-policies.html">Using the managed origin request policies</a> in the
        /// <i>Amazon CloudFront Developer Guide</i>.</p>
        pub fn set_origin_request_policy_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.origin_request_policy_id = input;
            self
        }
        /// <p>The identifier for a response headers policy.</p>
        pub fn response_headers_policy_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.response_headers_policy_id = Some(input.into());
            self
        }
        /// <p>The identifier for a response headers policy.</p>
        pub fn set_response_headers_policy_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.response_headers_policy_id = input;
            self
        }
        /// <p>This field is deprecated. We recommend that you use a cache policy or an origin
        /// request policy instead of this field. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/working-with-policies.html">Working with policies</a> in the
        /// <i>Amazon CloudFront Developer Guide</i>.</p>
        /// <p>If you want to include values in the cache key, use a cache policy. For more
        /// information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy">Creating cache policies</a> or <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-managed-cache-policies.html">Using the managed cache policies</a> in the
        /// <i>Amazon CloudFront Developer Guide</i>.</p>
        /// <p>If you want to send values to the origin but not include them in the cache key, use an
        /// origin request policy. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-origin-requests.html#origin-request-create-origin-request-policy">Creating origin request policies</a> or <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-managed-origin-request-policies.html">Using the managed origin request policies</a> in the
        /// <i>Amazon CloudFront Developer Guide</i>.</p>
        /// <p>A <code>CacheBehavior</code> must include either a
        /// <code>CachePolicyId</code> or <code>ForwardedValues</code>. We recommend that you
        /// use a <code>CachePolicyId</code>.</p>
        /// <p>A complex type that specifies how CloudFront handles query strings, cookies, and HTTP headers.</p>
        pub fn forwarded_values(mut self, input: crate::model::ForwardedValues) -> Self {
            self.forwarded_values = Some(input);
            self
        }
        /// <p>This field is deprecated. We recommend that you use a cache policy or an origin
        /// request policy instead of this field. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/working-with-policies.html">Working with policies</a> in the
        /// <i>Amazon CloudFront Developer Guide</i>.</p>
        /// <p>If you want to include values in the cache key, use a cache policy. For more
        /// information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy">Creating cache policies</a> or <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-managed-cache-policies.html">Using the managed cache policies</a> in the
        /// <i>Amazon CloudFront Developer Guide</i>.</p>
        /// <p>If you want to send values to the origin but not include them in the cache key, use an
        /// origin request policy. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-origin-requests.html#origin-request-create-origin-request-policy">Creating origin request policies</a> or <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-managed-origin-request-policies.html">Using the managed origin request policies</a> in the
        /// <i>Amazon CloudFront Developer Guide</i>.</p>
        /// <p>A <code>CacheBehavior</code> must include either a
        /// <code>CachePolicyId</code> or <code>ForwardedValues</code>. We recommend that you
        /// use a <code>CachePolicyId</code>.</p>
        /// <p>A complex type that specifies how CloudFront handles query strings, cookies, and HTTP headers.</p>
        pub fn set_forwarded_values(
            mut self,
            input: std::option::Option<crate::model::ForwardedValues>,
        ) -> Self {
            self.forwarded_values = input;
            self
        }
        /// <p>This field is deprecated. We recommend that you use the <code>MinTTL</code> field in a cache
        /// policy instead of this field. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy">Creating cache policies</a> or <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-managed-cache-policies.html">Using the managed cache policies</a> in the
        /// <i>Amazon CloudFront Developer Guide</i>.</p>
        /// <p>The minimum amount of time that you want objects to stay in CloudFront caches before CloudFront
        /// forwards another request to your origin to determine whether the object has been updated. For
        /// more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Expiration.html">
        /// Managing How Long Content Stays in an Edge Cache (Expiration)</a> in the <i>
        /// Amazon CloudFront Developer Guide</i>.</p>
        /// <p>You must specify <code>0</code> for <code>MinTTL</code> if you configure CloudFront to
        /// forward all headers to your origin (under <code>Headers</code>, if you specify <code>1</code>
        /// for <code>Quantity</code> and <code>*</code> for <code>Name</code>).</p>
        pub fn min_ttl(mut self, input: i64) -> Self {
            self.min_ttl = Some(input);
            self
        }
        /// <p>This field is deprecated. We recommend that you use the <code>MinTTL</code> field in a cache
        /// policy instead of this field. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy">Creating cache policies</a> or <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-managed-cache-policies.html">Using the managed cache policies</a> in the
        /// <i>Amazon CloudFront Developer Guide</i>.</p>
        /// <p>The minimum amount of time that you want objects to stay in CloudFront caches before CloudFront
        /// forwards another request to your origin to determine whether the object has been updated. For
        /// more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Expiration.html">
        /// Managing How Long Content Stays in an Edge Cache (Expiration)</a> in the <i>
        /// Amazon CloudFront Developer Guide</i>.</p>
        /// <p>You must specify <code>0</code> for <code>MinTTL</code> if you configure CloudFront to
        /// forward all headers to your origin (under <code>Headers</code>, if you specify <code>1</code>
        /// for <code>Quantity</code> and <code>*</code> for <code>Name</code>).</p>
        pub fn set_min_ttl(mut self, input: std::option::Option<i64>) -> Self {
            self.min_ttl = input;
            self
        }
        /// <p>This field is deprecated. We recommend that you use the <code>DefaultTTL</code> field in a
        /// cache policy instead of this field. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy">Creating cache policies</a> or <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-managed-cache-policies.html">Using the managed cache policies</a> in the
        /// <i>Amazon CloudFront Developer Guide</i>.</p>
        /// <p>The default amount of time that you want objects to stay in CloudFront caches before CloudFront
        /// forwards another request to your origin to determine whether the object has been updated. The
        /// value that you specify applies only when your origin does not add HTTP headers such as
        /// <code>Cache-Control max-age</code>, <code>Cache-Control s-maxage</code>, and
        /// <code>Expires</code> to objects. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Expiration.html">Managing How Long Content Stays
        /// in an Edge Cache (Expiration)</a> in the <i>Amazon CloudFront Developer Guide</i>.</p>
        pub fn default_ttl(mut self, input: i64) -> Self {
            self.default_ttl = Some(input);
            self
        }
        /// <p>This field is deprecated. We recommend that you use the <code>DefaultTTL</code> field in a
        /// cache policy instead of this field. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy">Creating cache policies</a> or <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-managed-cache-policies.html">Using the managed cache policies</a> in the
        /// <i>Amazon CloudFront Developer Guide</i>.</p>
        /// <p>The default amount of time that you want objects to stay in CloudFront caches before CloudFront
        /// forwards another request to your origin to determine whether the object has been updated. The
        /// value that you specify applies only when your origin does not add HTTP headers such as
        /// <code>Cache-Control max-age</code>, <code>Cache-Control s-maxage</code>, and
        /// <code>Expires</code> to objects. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Expiration.html">Managing How Long Content Stays
        /// in an Edge Cache (Expiration)</a> in the <i>Amazon CloudFront Developer Guide</i>.</p>
        pub fn set_default_ttl(mut self, input: std::option::Option<i64>) -> Self {
            self.default_ttl = input;
            self
        }
        /// <p>This field is deprecated. We recommend that you use the <code>MaxTTL</code> field in a cache
        /// policy instead of this field. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy">Creating cache policies</a> or <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-managed-cache-policies.html">Using the managed cache policies</a> in the
        /// <i>Amazon CloudFront Developer Guide</i>.</p>
        /// <p>The maximum amount of time that you want objects to stay in CloudFront caches before CloudFront
        /// forwards another request to your origin to determine whether the object has been updated. The
        /// value that you specify applies only when your origin adds HTTP headers such as
        /// <code>Cache-Control max-age</code>, <code>Cache-Control s-maxage</code>, and
        /// <code>Expires</code> to objects. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Expiration.html">Managing How Long Content Stays
        /// in an Edge Cache (Expiration)</a> in the <i>Amazon CloudFront Developer Guide</i>.</p>
        pub fn max_ttl(mut self, input: i64) -> Self {
            self.max_ttl = Some(input);
            self
        }
        /// <p>This field is deprecated. We recommend that you use the <code>MaxTTL</code> field in a cache
        /// policy instead of this field. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy">Creating cache policies</a> or <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-managed-cache-policies.html">Using the managed cache policies</a> in the
        /// <i>Amazon CloudFront Developer Guide</i>.</p>
        /// <p>The maximum amount of time that you want objects to stay in CloudFront caches before CloudFront
        /// forwards another request to your origin to determine whether the object has been updated. The
        /// value that you specify applies only when your origin adds HTTP headers such as
        /// <code>Cache-Control max-age</code>, <code>Cache-Control s-maxage</code>, and
        /// <code>Expires</code> to objects. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Expiration.html">Managing How Long Content Stays
        /// in an Edge Cache (Expiration)</a> in the <i>Amazon CloudFront Developer Guide</i>.</p>
        pub fn set_max_ttl(mut self, input: std::option::Option<i64>) -> Self {
            self.max_ttl = input;
            self
        }
        /// Consumes the builder and constructs a [`CacheBehavior`](crate::model::CacheBehavior)
        pub fn build(self) -> crate::model::CacheBehavior {
            crate::model::CacheBehavior {
                path_pattern: self.path_pattern,
                target_origin_id: self.target_origin_id,
                trusted_signers: self.trusted_signers,
                trusted_key_groups: self.trusted_key_groups,
                viewer_protocol_policy: self.viewer_protocol_policy,
                allowed_methods: self.allowed_methods,
                smooth_streaming: self.smooth_streaming,
                compress: self.compress,
                lambda_function_associations: self.lambda_function_associations,
                function_associations: self.function_associations,
                field_level_encryption_id: self.field_level_encryption_id,
                realtime_log_config_arn: self.realtime_log_config_arn,
                cache_policy_id: self.cache_policy_id,
                origin_request_policy_id: self.origin_request_policy_id,
                response_headers_policy_id: self.response_headers_policy_id,
                forwarded_values: self.forwarded_values,
                min_ttl: self.min_ttl,
                default_ttl: self.default_ttl,
                max_ttl: self.max_ttl,
            }
        }
    }
}
impl CacheBehavior {
    /// Creates a new builder-style object to manufacture [`CacheBehavior`](crate::model::CacheBehavior)
    pub fn builder() -> crate::model::cache_behavior::Builder {
        crate::model::cache_behavior::Builder::default()
    }
}

/// <p>This field is deprecated. We recommend that you use a cache policy or an origin
/// request policy instead of this field.</p>
/// <p>If you want to include values in the cache key, use a cache policy. For more information,
/// see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy">Creating cache policies</a> in the <i>Amazon CloudFront Developer Guide</i>.</p>
/// <p>If you want to send values to the origin but not include them in the cache key, use an
/// origin request policy. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-origin-requests.html#origin-request-create-origin-request-policy">Creating origin request policies</a> in the
/// <i>Amazon CloudFront Developer Guide</i>.</p>
/// <p>A complex type that specifies how CloudFront handles query strings, cookies, and HTTP headers.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ForwardedValues {
    /// <p>This field is deprecated. We recommend that you use a cache policy or an origin
    /// request policy instead of this field.</p>
    /// <p>If you want to include query strings in the cache key, use a cache policy. For more
    /// information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy">Creating cache policies</a> in the <i>Amazon CloudFront Developer Guide</i>.</p>
    /// <p>If you want to send query strings to the origin but not include them in the cache key, use
    /// an origin request policy. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-origin-requests.html#origin-request-create-origin-request-policy">Creating origin request policies</a> in the
    /// <i>Amazon CloudFront Developer Guide</i>.</p>
    /// <p>Indicates whether you want CloudFront to forward query strings to the origin that is
    /// associated with this cache behavior and cache based on the query string parameters. CloudFront
    /// behavior depends on the value of <code>QueryString</code> and on the values that you specify
    /// for <code>QueryStringCacheKeys</code>, if any:</p>
    /// <p>If you specify true for <code>QueryString</code> and you don't specify any values for
    /// <code>QueryStringCacheKeys</code>, CloudFront forwards all query string parameters to the origin
    /// and caches based on all query string parameters. Depending on how many query string parameters
    /// and values you have, this can adversely affect performance because CloudFront must forward more
    /// requests to the origin.</p>
    /// <p>If you specify true for <code>QueryString</code> and you specify one or more values for
    /// <code>QueryStringCacheKeys</code>, CloudFront forwards all query string parameters to the origin,
    /// but it only caches based on the query string parameters that you specify.</p>
    /// <p>If you specify false for <code>QueryString</code>, CloudFront doesn't forward any query
    /// string parameters to the origin, and doesn't cache based on query string parameters.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/QueryStringParameters.html">Configuring CloudFront to Cache Based on Query String Parameters</a> in the
    /// <i>Amazon CloudFront Developer Guide</i>.</p>
    pub query_string: std::option::Option<bool>,
    /// <p>This field is deprecated. We recommend that you use a cache policy or an origin
    /// request policy instead of this field.</p>
    /// <p>If you want to include cookies in the cache key, use a cache policy. For more
    /// information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy">Creating cache policies</a> in the <i>Amazon CloudFront Developer Guide</i>.</p>
    /// <p>If you want to send cookies to the origin but not include them in the cache key, use an
    /// origin request policy. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-origin-requests.html#origin-request-create-origin-request-policy">Creating origin request policies</a> in the
    /// <i>Amazon CloudFront Developer Guide</i>.</p>
    /// <p>A complex type that specifies whether you want CloudFront to forward cookies to the origin
    /// and, if so, which ones. For more information about forwarding cookies to the origin, see
    /// <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Cookies.html">How CloudFront Forwards, Caches, and Logs Cookies</a> in the
    /// <i>Amazon CloudFront Developer Guide</i>.</p>
    pub cookies: std::option::Option<crate::model::CookiePreference>,
    /// <p>This field is deprecated. We recommend that you use a cache policy or an origin
    /// request policy instead of this field.</p>
    /// <p>If you want to include headers in the cache key, use a cache policy. For more information,
    /// see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy">Creating cache policies</a> in the <i>Amazon CloudFront Developer Guide</i>.</p>
    /// <p>If you want to send headers to the origin but not include them in the cache key, use an
    /// origin request policy. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-origin-requests.html#origin-request-create-origin-request-policy">Creating origin request policies</a> in the
    /// <i>Amazon CloudFront Developer Guide</i>.</p>
    /// <p>A complex type that specifies the <code>Headers</code>, if any, that you want CloudFront to forward to the
    /// origin for this cache behavior (whitelisted headers). For the headers that you specify, CloudFront also caches
    /// separate versions of a specified object that is based on the header values in viewer requests.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/header-caching.html">
    /// Caching Content Based on Request Headers</a> in the <i>Amazon CloudFront Developer Guide</i>.</p>
    pub headers: std::option::Option<crate::model::Headers>,
    /// <p>This field is deprecated. We recommend that you use a cache policy or an origin
    /// request policy instead of this field.</p>
    /// <p>If you want to include query strings in the cache key, use a cache policy. For more
    /// information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy">Creating cache policies</a> in the <i>Amazon CloudFront Developer Guide</i>.</p>
    /// <p>If you want to send query strings to the origin but not include them in the cache key, use
    /// an origin request policy. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-origin-requests.html#origin-request-create-origin-request-policy">Creating origin request policies</a> in the
    /// <i>Amazon CloudFront Developer Guide</i>.</p>
    /// <p>A complex type that contains information about the query string parameters that you
    /// want CloudFront to use for caching for this cache behavior.</p>
    pub query_string_cache_keys: std::option::Option<crate::model::QueryStringCacheKeys>,
}
impl ForwardedValues {
    /// <p>This field is deprecated. We recommend that you use a cache policy or an origin
    /// request policy instead of this field.</p>
    /// <p>If you want to include query strings in the cache key, use a cache policy. For more
    /// information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy">Creating cache policies</a> in the <i>Amazon CloudFront Developer Guide</i>.</p>
    /// <p>If you want to send query strings to the origin but not include them in the cache key, use
    /// an origin request policy. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-origin-requests.html#origin-request-create-origin-request-policy">Creating origin request policies</a> in the
    /// <i>Amazon CloudFront Developer Guide</i>.</p>
    /// <p>Indicates whether you want CloudFront to forward query strings to the origin that is
    /// associated with this cache behavior and cache based on the query string parameters. CloudFront
    /// behavior depends on the value of <code>QueryString</code> and on the values that you specify
    /// for <code>QueryStringCacheKeys</code>, if any:</p>
    /// <p>If you specify true for <code>QueryString</code> and you don't specify any values for
    /// <code>QueryStringCacheKeys</code>, CloudFront forwards all query string parameters to the origin
    /// and caches based on all query string parameters. Depending on how many query string parameters
    /// and values you have, this can adversely affect performance because CloudFront must forward more
    /// requests to the origin.</p>
    /// <p>If you specify true for <code>QueryString</code> and you specify one or more values for
    /// <code>QueryStringCacheKeys</code>, CloudFront forwards all query string parameters to the origin,
    /// but it only caches based on the query string parameters that you specify.</p>
    /// <p>If you specify false for <code>QueryString</code>, CloudFront doesn't forward any query
    /// string parameters to the origin, and doesn't cache based on query string parameters.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/QueryStringParameters.html">Configuring CloudFront to Cache Based on Query String Parameters</a> in the
    /// <i>Amazon CloudFront Developer Guide</i>.</p>
    pub fn query_string(&self) -> std::option::Option<bool> {
        self.query_string
    }
    /// <p>This field is deprecated. We recommend that you use a cache policy or an origin
    /// request policy instead of this field.</p>
    /// <p>If you want to include cookies in the cache key, use a cache policy. For more
    /// information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy">Creating cache policies</a> in the <i>Amazon CloudFront Developer Guide</i>.</p>
    /// <p>If you want to send cookies to the origin but not include them in the cache key, use an
    /// origin request policy. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-origin-requests.html#origin-request-create-origin-request-policy">Creating origin request policies</a> in the
    /// <i>Amazon CloudFront Developer Guide</i>.</p>
    /// <p>A complex type that specifies whether you want CloudFront to forward cookies to the origin
    /// and, if so, which ones. For more information about forwarding cookies to the origin, see
    /// <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Cookies.html">How CloudFront Forwards, Caches, and Logs Cookies</a> in the
    /// <i>Amazon CloudFront Developer Guide</i>.</p>
    pub fn cookies(&self) -> std::option::Option<&crate::model::CookiePreference> {
        self.cookies.as_ref()
    }
    /// <p>This field is deprecated. We recommend that you use a cache policy or an origin
    /// request policy instead of this field.</p>
    /// <p>If you want to include headers in the cache key, use a cache policy. For more information,
    /// see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy">Creating cache policies</a> in the <i>Amazon CloudFront Developer Guide</i>.</p>
    /// <p>If you want to send headers to the origin but not include them in the cache key, use an
    /// origin request policy. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-origin-requests.html#origin-request-create-origin-request-policy">Creating origin request policies</a> in the
    /// <i>Amazon CloudFront Developer Guide</i>.</p>
    /// <p>A complex type that specifies the <code>Headers</code>, if any, that you want CloudFront to forward to the
    /// origin for this cache behavior (whitelisted headers). For the headers that you specify, CloudFront also caches
    /// separate versions of a specified object that is based on the header values in viewer requests.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/header-caching.html">
    /// Caching Content Based on Request Headers</a> in the <i>Amazon CloudFront Developer Guide</i>.</p>
    pub fn headers(&self) -> std::option::Option<&crate::model::Headers> {
        self.headers.as_ref()
    }
    /// <p>This field is deprecated. We recommend that you use a cache policy or an origin
    /// request policy instead of this field.</p>
    /// <p>If you want to include query strings in the cache key, use a cache policy. For more
    /// information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy">Creating cache policies</a> in the <i>Amazon CloudFront Developer Guide</i>.</p>
    /// <p>If you want to send query strings to the origin but not include them in the cache key, use
    /// an origin request policy. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-origin-requests.html#origin-request-create-origin-request-policy">Creating origin request policies</a> in the
    /// <i>Amazon CloudFront Developer Guide</i>.</p>
    /// <p>A complex type that contains information about the query string parameters that you
    /// want CloudFront to use for caching for this cache behavior.</p>
    pub fn query_string_cache_keys(
        &self,
    ) -> std::option::Option<&crate::model::QueryStringCacheKeys> {
        self.query_string_cache_keys.as_ref()
    }
}
impl std::fmt::Debug for ForwardedValues {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ForwardedValues");
        formatter.field("query_string", &self.query_string);
        formatter.field("cookies", &self.cookies);
        formatter.field("headers", &self.headers);
        formatter.field("query_string_cache_keys", &self.query_string_cache_keys);
        formatter.finish()
    }
}
/// See [`ForwardedValues`](crate::model::ForwardedValues)
pub mod forwarded_values {
    /// A builder for [`ForwardedValues`](crate::model::ForwardedValues)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) query_string: std::option::Option<bool>,
        pub(crate) cookies: std::option::Option<crate::model::CookiePreference>,
        pub(crate) headers: std::option::Option<crate::model::Headers>,
        pub(crate) query_string_cache_keys: std::option::Option<crate::model::QueryStringCacheKeys>,
    }
    impl Builder {
        /// <p>This field is deprecated. We recommend that you use a cache policy or an origin
        /// request policy instead of this field.</p>
        /// <p>If you want to include query strings in the cache key, use a cache policy. For more
        /// information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy">Creating cache policies</a> in the <i>Amazon CloudFront Developer Guide</i>.</p>
        /// <p>If you want to send query strings to the origin but not include them in the cache key, use
        /// an origin request policy. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-origin-requests.html#origin-request-create-origin-request-policy">Creating origin request policies</a> in the
        /// <i>Amazon CloudFront Developer Guide</i>.</p>
        /// <p>Indicates whether you want CloudFront to forward query strings to the origin that is
        /// associated with this cache behavior and cache based on the query string parameters. CloudFront
        /// behavior depends on the value of <code>QueryString</code> and on the values that you specify
        /// for <code>QueryStringCacheKeys</code>, if any:</p>
        /// <p>If you specify true for <code>QueryString</code> and you don't specify any values for
        /// <code>QueryStringCacheKeys</code>, CloudFront forwards all query string parameters to the origin
        /// and caches based on all query string parameters. Depending on how many query string parameters
        /// and values you have, this can adversely affect performance because CloudFront must forward more
        /// requests to the origin.</p>
        /// <p>If you specify true for <code>QueryString</code> and you specify one or more values for
        /// <code>QueryStringCacheKeys</code>, CloudFront forwards all query string parameters to the origin,
        /// but it only caches based on the query string parameters that you specify.</p>
        /// <p>If you specify false for <code>QueryString</code>, CloudFront doesn't forward any query
        /// string parameters to the origin, and doesn't cache based on query string parameters.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/QueryStringParameters.html">Configuring CloudFront to Cache Based on Query String Parameters</a> in the
        /// <i>Amazon CloudFront Developer Guide</i>.</p>
        pub fn query_string(mut self, input: bool) -> Self {
            self.query_string = Some(input);
            self
        }
        /// <p>This field is deprecated. We recommend that you use a cache policy or an origin
        /// request policy instead of this field.</p>
        /// <p>If you want to include query strings in the cache key, use a cache policy. For more
        /// information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy">Creating cache policies</a> in the <i>Amazon CloudFront Developer Guide</i>.</p>
        /// <p>If you want to send query strings to the origin but not include them in the cache key, use
        /// an origin request policy. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-origin-requests.html#origin-request-create-origin-request-policy">Creating origin request policies</a> in the
        /// <i>Amazon CloudFront Developer Guide</i>.</p>
        /// <p>Indicates whether you want CloudFront to forward query strings to the origin that is
        /// associated with this cache behavior and cache based on the query string parameters. CloudFront
        /// behavior depends on the value of <code>QueryString</code> and on the values that you specify
        /// for <code>QueryStringCacheKeys</code>, if any:</p>
        /// <p>If you specify true for <code>QueryString</code> and you don't specify any values for
        /// <code>QueryStringCacheKeys</code>, CloudFront forwards all query string parameters to the origin
        /// and caches based on all query string parameters. Depending on how many query string parameters
        /// and values you have, this can adversely affect performance because CloudFront must forward more
        /// requests to the origin.</p>
        /// <p>If you specify true for <code>QueryString</code> and you specify one or more values for
        /// <code>QueryStringCacheKeys</code>, CloudFront forwards all query string parameters to the origin,
        /// but it only caches based on the query string parameters that you specify.</p>
        /// <p>If you specify false for <code>QueryString</code>, CloudFront doesn't forward any query
        /// string parameters to the origin, and doesn't cache based on query string parameters.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/QueryStringParameters.html">Configuring CloudFront to Cache Based on Query String Parameters</a> in the
        /// <i>Amazon CloudFront Developer Guide</i>.</p>
        pub fn set_query_string(mut self, input: std::option::Option<bool>) -> Self {
            self.query_string = input;
            self
        }
        /// <p>This field is deprecated. We recommend that you use a cache policy or an origin
        /// request policy instead of this field.</p>
        /// <p>If you want to include cookies in the cache key, use a cache policy. For more
        /// information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy">Creating cache policies</a> in the <i>Amazon CloudFront Developer Guide</i>.</p>
        /// <p>If you want to send cookies to the origin but not include them in the cache key, use an
        /// origin request policy. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-origin-requests.html#origin-request-create-origin-request-policy">Creating origin request policies</a> in the
        /// <i>Amazon CloudFront Developer Guide</i>.</p>
        /// <p>A complex type that specifies whether you want CloudFront to forward cookies to the origin
        /// and, if so, which ones. For more information about forwarding cookies to the origin, see
        /// <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Cookies.html">How CloudFront Forwards, Caches, and Logs Cookies</a> in the
        /// <i>Amazon CloudFront Developer Guide</i>.</p>
        pub fn cookies(mut self, input: crate::model::CookiePreference) -> Self {
            self.cookies = Some(input);
            self
        }
        /// <p>This field is deprecated. We recommend that you use a cache policy or an origin
        /// request policy instead of this field.</p>
        /// <p>If you want to include cookies in the cache key, use a cache policy. For more
        /// information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy">Creating cache policies</a> in the <i>Amazon CloudFront Developer Guide</i>.</p>
        /// <p>If you want to send cookies to the origin but not include them in the cache key, use an
        /// origin request policy. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-origin-requests.html#origin-request-create-origin-request-policy">Creating origin request policies</a> in the
        /// <i>Amazon CloudFront Developer Guide</i>.</p>
        /// <p>A complex type that specifies whether you want CloudFront to forward cookies to the origin
        /// and, if so, which ones. For more information about forwarding cookies to the origin, see
        /// <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Cookies.html">How CloudFront Forwards, Caches, and Logs Cookies</a> in the
        /// <i>Amazon CloudFront Developer Guide</i>.</p>
        pub fn set_cookies(
            mut self,
            input: std::option::Option<crate::model::CookiePreference>,
        ) -> Self {
            self.cookies = input;
            self
        }
        /// <p>This field is deprecated. We recommend that you use a cache policy or an origin
        /// request policy instead of this field.</p>
        /// <p>If you want to include headers in the cache key, use a cache policy. For more information,
        /// see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy">Creating cache policies</a> in the <i>Amazon CloudFront Developer Guide</i>.</p>
        /// <p>If you want to send headers to the origin but not include them in the cache key, use an
        /// origin request policy. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-origin-requests.html#origin-request-create-origin-request-policy">Creating origin request policies</a> in the
        /// <i>Amazon CloudFront Developer Guide</i>.</p>
        /// <p>A complex type that specifies the <code>Headers</code>, if any, that you want CloudFront to forward to the
        /// origin for this cache behavior (whitelisted headers). For the headers that you specify, CloudFront also caches
        /// separate versions of a specified object that is based on the header values in viewer requests.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/header-caching.html">
        /// Caching Content Based on Request Headers</a> in the <i>Amazon CloudFront Developer Guide</i>.</p>
        pub fn headers(mut self, input: crate::model::Headers) -> Self {
            self.headers = Some(input);
            self
        }
        /// <p>This field is deprecated. We recommend that you use a cache policy or an origin
        /// request policy instead of this field.</p>
        /// <p>If you want to include headers in the cache key, use a cache policy. For more information,
        /// see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy">Creating cache policies</a> in the <i>Amazon CloudFront Developer Guide</i>.</p>
        /// <p>If you want to send headers to the origin but not include them in the cache key, use an
        /// origin request policy. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-origin-requests.html#origin-request-create-origin-request-policy">Creating origin request policies</a> in the
        /// <i>Amazon CloudFront Developer Guide</i>.</p>
        /// <p>A complex type that specifies the <code>Headers</code>, if any, that you want CloudFront to forward to the
        /// origin for this cache behavior (whitelisted headers). For the headers that you specify, CloudFront also caches
        /// separate versions of a specified object that is based on the header values in viewer requests.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/header-caching.html">
        /// Caching Content Based on Request Headers</a> in the <i>Amazon CloudFront Developer Guide</i>.</p>
        pub fn set_headers(mut self, input: std::option::Option<crate::model::Headers>) -> Self {
            self.headers = input;
            self
        }
        /// <p>This field is deprecated. We recommend that you use a cache policy or an origin
        /// request policy instead of this field.</p>
        /// <p>If you want to include query strings in the cache key, use a cache policy. For more
        /// information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy">Creating cache policies</a> in the <i>Amazon CloudFront Developer Guide</i>.</p>
        /// <p>If you want to send query strings to the origin but not include them in the cache key, use
        /// an origin request policy. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-origin-requests.html#origin-request-create-origin-request-policy">Creating origin request policies</a> in the
        /// <i>Amazon CloudFront Developer Guide</i>.</p>
        /// <p>A complex type that contains information about the query string parameters that you
        /// want CloudFront to use for caching for this cache behavior.</p>
        pub fn query_string_cache_keys(
            mut self,
            input: crate::model::QueryStringCacheKeys,
        ) -> Self {
            self.query_string_cache_keys = Some(input);
            self
        }
        /// <p>This field is deprecated. We recommend that you use a cache policy or an origin
        /// request policy instead of this field.</p>
        /// <p>If you want to include query strings in the cache key, use a cache policy. For more
        /// information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy">Creating cache policies</a> in the <i>Amazon CloudFront Developer Guide</i>.</p>
        /// <p>If you want to send query strings to the origin but not include them in the cache key, use
        /// an origin request policy. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-origin-requests.html#origin-request-create-origin-request-policy">Creating origin request policies</a> in the
        /// <i>Amazon CloudFront Developer Guide</i>.</p>
        /// <p>A complex type that contains information about the query string parameters that you
        /// want CloudFront to use for caching for this cache behavior.</p>
        pub fn set_query_string_cache_keys(
            mut self,
            input: std::option::Option<crate::model::QueryStringCacheKeys>,
        ) -> Self {
            self.query_string_cache_keys = input;
            self
        }
        /// Consumes the builder and constructs a [`ForwardedValues`](crate::model::ForwardedValues)
        pub fn build(self) -> crate::model::ForwardedValues {
            crate::model::ForwardedValues {
                query_string: self.query_string,
                cookies: self.cookies,
                headers: self.headers,
                query_string_cache_keys: self.query_string_cache_keys,
            }
        }
    }
}
impl ForwardedValues {
    /// Creates a new builder-style object to manufacture [`ForwardedValues`](crate::model::ForwardedValues)
    pub fn builder() -> crate::model::forwarded_values::Builder {
        crate::model::forwarded_values::Builder::default()
    }
}

/// <p>This field is deprecated. We recommend that you use a cache policy or an origin
/// request policy instead of this field.</p>
/// <p>If you want to include query strings in the cache key, use
/// <code>QueryStringsConfig</code> in a cache policy. See
/// <code>CachePolicy</code>.</p>
/// <p>If you want to send query strings to the origin but not include them in the cache key,
/// use <code>QueryStringsConfig</code> in an origin request policy. See
/// <code>OriginRequestPolicy</code>.</p>
/// <p>A complex type that contains information about the query string parameters that you want
/// CloudFront to use for caching for a cache behavior.
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct QueryStringCacheKeys {
    /// <p>The number of <code>whitelisted</code> query string parameters for a cache
    /// behavior.</p>
    pub quantity: std::option::Option<i32>,
    /// <p>A list that contains the query string parameters that you want CloudFront to use
    /// as a basis for caching for a cache behavior. If <code>Quantity</code> is 0, you can omit
    /// <code>Items</code>. </p>
    pub items: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl QueryStringCacheKeys {
    /// <p>The number of <code>whitelisted</code> query string parameters for a cache
    /// behavior.</p>
    pub fn quantity(&self) -> std::option::Option<i32> {
        self.quantity
    }
    /// <p>A list that contains the query string parameters that you want CloudFront to use
    /// as a basis for caching for a cache behavior. If <code>Quantity</code> is 0, you can omit
    /// <code>Items</code>. </p>
    pub fn items(&self) -> std::option::Option<&[std::string::String]> {
        self.items.as_deref()
    }
}
impl std::fmt::Debug for QueryStringCacheKeys {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("QueryStringCacheKeys");
        formatter.field("quantity", &self.quantity);
        formatter.field("items", &self.items);
        formatter.finish()
    }
}
/// See [`QueryStringCacheKeys`](crate::model::QueryStringCacheKeys)
pub mod query_string_cache_keys {
    /// A builder for [`QueryStringCacheKeys`](crate::model::QueryStringCacheKeys)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) quantity: std::option::Option<i32>,
        pub(crate) items: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The number of <code>whitelisted</code> query string parameters for a cache
        /// behavior.</p>
        pub fn quantity(mut self, input: i32) -> Self {
            self.quantity = Some(input);
            self
        }
        /// <p>The number of <code>whitelisted</code> query string parameters for a cache
        /// behavior.</p>
        pub fn set_quantity(mut self, input: std::option::Option<i32>) -> Self {
            self.quantity = input;
            self
        }
        /// Appends an item to `items`.
        ///
        /// To override the contents of this collection use [`set_items`](Self::set_items).
        ///
        /// <p>A list that contains the query string parameters that you want CloudFront to use
        /// as a basis for caching for a cache behavior. If <code>Quantity</code> is 0, you can omit
        /// <code>Items</code>. </p>
        pub fn items(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.items.unwrap_or_default();
            v.push(input.into());
            self.items = Some(v);
            self
        }
        /// <p>A list that contains the query string parameters that you want CloudFront to use
        /// as a basis for caching for a cache behavior. If <code>Quantity</code> is 0, you can omit
        /// <code>Items</code>. </p>
        pub fn set_items(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.items = input;
            self
        }
        /// Consumes the builder and constructs a [`QueryStringCacheKeys`](crate::model::QueryStringCacheKeys)
        pub fn build(self) -> crate::model::QueryStringCacheKeys {
            crate::model::QueryStringCacheKeys {
                quantity: self.quantity,
                items: self.items,
            }
        }
    }
}
impl QueryStringCacheKeys {
    /// Creates a new builder-style object to manufacture [`QueryStringCacheKeys`](crate::model::QueryStringCacheKeys)
    pub fn builder() -> crate::model::query_string_cache_keys::Builder {
        crate::model::query_string_cache_keys::Builder::default()
    }
}

/// <p>This field is deprecated. We recommend that you use a cache policy or an origin
/// request policy instead of this field.</p>
/// <p>If you want to include cookies in the cache key, use <code>CookiesConfig</code> in a
/// cache policy. See <code>CachePolicy</code>.</p>
/// <p>If you want to send cookies to the origin but not include them in the cache key, use
/// <code>CookiesConfig</code> in an origin request policy. See
/// <code>OriginRequestPolicy</code>.</p>
/// <p>A complex type that specifies whether you want CloudFront to forward cookies to the origin
/// and, if so, which ones. For more information about forwarding cookies to the origin, see
/// <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Cookies.html">Caching Content
/// Based on Cookies</a> in the <i>Amazon CloudFront Developer Guide</i>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CookiePreference {
    /// <p>This field is deprecated. We recommend that you use a cache policy or an origin
    /// request policy instead of this field.</p>
    /// <p>If you want to include cookies in the cache key, use a cache policy. For more information,
    /// see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy">Creating cache policies</a> in the <i>Amazon CloudFront Developer Guide</i>.</p>
    /// <p>If you want to send cookies to the origin but not include them in the cache key, use origin
    /// request policy. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-origin-requests.html#origin-request-create-origin-request-policy">Creating origin request policies</a> in the
    /// <i>Amazon CloudFront Developer Guide</i>.</p>
    /// <p>Specifies which cookies to forward to the origin for this cache behavior: all, none, or
    /// the list of cookies specified in the <code>WhitelistedNames</code> complex type.</p>
    /// <p>Amazon S3 doesn't process cookies. When the cache behavior is forwarding requests to an
    /// Amazon S3 origin, specify none for the <code>Forward</code> element.</p>
    pub forward: std::option::Option<crate::model::ItemSelection>,
    /// <p>This field is deprecated. We recommend that you use a cache policy or an origin
    /// request policy instead of this field.</p>
    /// <p>If you want to include cookies in the cache key, use a cache policy. For more information,
    /// see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy">Creating cache policies</a> in the <i>Amazon CloudFront Developer Guide</i>.</p>
    /// <p>If you want to send cookies to the origin but not include them in the cache key, use an
    /// origin request policy. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-origin-requests.html#origin-request-create-origin-request-policy">Creating origin request policies</a> in the
    /// <i>Amazon CloudFront Developer Guide</i>.</p>
    /// <p>Required if you specify <code>whitelist</code> for the value of <code>Forward</code>.
    /// A complex type that specifies how many different cookies you want CloudFront to forward to the
    /// origin for this cache behavior and, if you want to forward selected cookies, the names of
    /// those cookies.</p>
    /// <p>If you specify <code>all</code> or <code>none</code> for the value of <code>Forward</code>, omit
    /// <code>WhitelistedNames</code>. If you change the value of <code>Forward</code> from
    /// <code>whitelist</code> to <code>all</code> or <code>none</code> and you don't delete the <code>WhitelistedNames</code>
    /// element and its child elements, CloudFront deletes them automatically.</p>
    /// <p>For the current limit on the number of cookie names that you can whitelist for each
    /// cache behavior, see <a href="https://docs.aws.amazon.com/general/latest/gr/xrefaws_service_limits.html#limits_cloudfront">
    /// CloudFront Limits</a> in the <i>Amazon Web Services General Reference</i>.</p>
    pub whitelisted_names: std::option::Option<crate::model::CookieNames>,
}
impl CookiePreference {
    /// <p>This field is deprecated. We recommend that you use a cache policy or an origin
    /// request policy instead of this field.</p>
    /// <p>If you want to include cookies in the cache key, use a cache policy. For more information,
    /// see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy">Creating cache policies</a> in the <i>Amazon CloudFront Developer Guide</i>.</p>
    /// <p>If you want to send cookies to the origin but not include them in the cache key, use origin
    /// request policy. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-origin-requests.html#origin-request-create-origin-request-policy">Creating origin request policies</a> in the
    /// <i>Amazon CloudFront Developer Guide</i>.</p>
    /// <p>Specifies which cookies to forward to the origin for this cache behavior: all, none, or
    /// the list of cookies specified in the <code>WhitelistedNames</code> complex type.</p>
    /// <p>Amazon S3 doesn't process cookies. When the cache behavior is forwarding requests to an
    /// Amazon S3 origin, specify none for the <code>Forward</code> element.</p>
    pub fn forward(&self) -> std::option::Option<&crate::model::ItemSelection> {
        self.forward.as_ref()
    }
    /// <p>This field is deprecated. We recommend that you use a cache policy or an origin
    /// request policy instead of this field.</p>
    /// <p>If you want to include cookies in the cache key, use a cache policy. For more information,
    /// see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy">Creating cache policies</a> in the <i>Amazon CloudFront Developer Guide</i>.</p>
    /// <p>If you want to send cookies to the origin but not include them in the cache key, use an
    /// origin request policy. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-origin-requests.html#origin-request-create-origin-request-policy">Creating origin request policies</a> in the
    /// <i>Amazon CloudFront Developer Guide</i>.</p>
    /// <p>Required if you specify <code>whitelist</code> for the value of <code>Forward</code>.
    /// A complex type that specifies how many different cookies you want CloudFront to forward to the
    /// origin for this cache behavior and, if you want to forward selected cookies, the names of
    /// those cookies.</p>
    /// <p>If you specify <code>all</code> or <code>none</code> for the value of <code>Forward</code>, omit
    /// <code>WhitelistedNames</code>. If you change the value of <code>Forward</code> from
    /// <code>whitelist</code> to <code>all</code> or <code>none</code> and you don't delete the <code>WhitelistedNames</code>
    /// element and its child elements, CloudFront deletes them automatically.</p>
    /// <p>For the current limit on the number of cookie names that you can whitelist for each
    /// cache behavior, see <a href="https://docs.aws.amazon.com/general/latest/gr/xrefaws_service_limits.html#limits_cloudfront">
    /// CloudFront Limits</a> in the <i>Amazon Web Services General Reference</i>.</p>
    pub fn whitelisted_names(&self) -> std::option::Option<&crate::model::CookieNames> {
        self.whitelisted_names.as_ref()
    }
}
impl std::fmt::Debug for CookiePreference {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CookiePreference");
        formatter.field("forward", &self.forward);
        formatter.field("whitelisted_names", &self.whitelisted_names);
        formatter.finish()
    }
}
/// See [`CookiePreference`](crate::model::CookiePreference)
pub mod cookie_preference {
    /// A builder for [`CookiePreference`](crate::model::CookiePreference)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) forward: std::option::Option<crate::model::ItemSelection>,
        pub(crate) whitelisted_names: std::option::Option<crate::model::CookieNames>,
    }
    impl Builder {
        /// <p>This field is deprecated. We recommend that you use a cache policy or an origin
        /// request policy instead of this field.</p>
        /// <p>If you want to include cookies in the cache key, use a cache policy. For more information,
        /// see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy">Creating cache policies</a> in the <i>Amazon CloudFront Developer Guide</i>.</p>
        /// <p>If you want to send cookies to the origin but not include them in the cache key, use origin
        /// request policy. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-origin-requests.html#origin-request-create-origin-request-policy">Creating origin request policies</a> in the
        /// <i>Amazon CloudFront Developer Guide</i>.</p>
        /// <p>Specifies which cookies to forward to the origin for this cache behavior: all, none, or
        /// the list of cookies specified in the <code>WhitelistedNames</code> complex type.</p>
        /// <p>Amazon S3 doesn't process cookies. When the cache behavior is forwarding requests to an
        /// Amazon S3 origin, specify none for the <code>Forward</code> element.</p>
        pub fn forward(mut self, input: crate::model::ItemSelection) -> Self {
            self.forward = Some(input);
            self
        }
        /// <p>This field is deprecated. We recommend that you use a cache policy or an origin
        /// request policy instead of this field.</p>
        /// <p>If you want to include cookies in the cache key, use a cache policy. For more information,
        /// see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy">Creating cache policies</a> in the <i>Amazon CloudFront Developer Guide</i>.</p>
        /// <p>If you want to send cookies to the origin but not include them in the cache key, use origin
        /// request policy. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-origin-requests.html#origin-request-create-origin-request-policy">Creating origin request policies</a> in the
        /// <i>Amazon CloudFront Developer Guide</i>.</p>
        /// <p>Specifies which cookies to forward to the origin for this cache behavior: all, none, or
        /// the list of cookies specified in the <code>WhitelistedNames</code> complex type.</p>
        /// <p>Amazon S3 doesn't process cookies. When the cache behavior is forwarding requests to an
        /// Amazon S3 origin, specify none for the <code>Forward</code> element.</p>
        pub fn set_forward(
            mut self,
            input: std::option::Option<crate::model::ItemSelection>,
        ) -> Self {
            self.forward = input;
            self
        }
        /// <p>This field is deprecated. We recommend that you use a cache policy or an origin
        /// request policy instead of this field.</p>
        /// <p>If you want to include cookies in the cache key, use a cache policy. For more information,
        /// see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy">Creating cache policies</a> in the <i>Amazon CloudFront Developer Guide</i>.</p>
        /// <p>If you want to send cookies to the origin but not include them in the cache key, use an
        /// origin request policy. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-origin-requests.html#origin-request-create-origin-request-policy">Creating origin request policies</a> in the
        /// <i>Amazon CloudFront Developer Guide</i>.</p>
        /// <p>Required if you specify <code>whitelist</code> for the value of <code>Forward</code>.
        /// A complex type that specifies how many different cookies you want CloudFront to forward to the
        /// origin for this cache behavior and, if you want to forward selected cookies, the names of
        /// those cookies.</p>
        /// <p>If you specify <code>all</code> or <code>none</code> for the value of <code>Forward</code>, omit
        /// <code>WhitelistedNames</code>. If you change the value of <code>Forward</code> from
        /// <code>whitelist</code> to <code>all</code> or <code>none</code> and you don't delete the <code>WhitelistedNames</code>
        /// element and its child elements, CloudFront deletes them automatically.</p>
        /// <p>For the current limit on the number of cookie names that you can whitelist for each
        /// cache behavior, see <a href="https://docs.aws.amazon.com/general/latest/gr/xrefaws_service_limits.html#limits_cloudfront">
        /// CloudFront Limits</a> in the <i>Amazon Web Services General Reference</i>.</p>
        pub fn whitelisted_names(mut self, input: crate::model::CookieNames) -> Self {
            self.whitelisted_names = Some(input);
            self
        }
        /// <p>This field is deprecated. We recommend that you use a cache policy or an origin
        /// request policy instead of this field.</p>
        /// <p>If you want to include cookies in the cache key, use a cache policy. For more information,
        /// see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy">Creating cache policies</a> in the <i>Amazon CloudFront Developer Guide</i>.</p>
        /// <p>If you want to send cookies to the origin but not include them in the cache key, use an
        /// origin request policy. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-origin-requests.html#origin-request-create-origin-request-policy">Creating origin request policies</a> in the
        /// <i>Amazon CloudFront Developer Guide</i>.</p>
        /// <p>Required if you specify <code>whitelist</code> for the value of <code>Forward</code>.
        /// A complex type that specifies how many different cookies you want CloudFront to forward to the
        /// origin for this cache behavior and, if you want to forward selected cookies, the names of
        /// those cookies.</p>
        /// <p>If you specify <code>all</code> or <code>none</code> for the value of <code>Forward</code>, omit
        /// <code>WhitelistedNames</code>. If you change the value of <code>Forward</code> from
        /// <code>whitelist</code> to <code>all</code> or <code>none</code> and you don't delete the <code>WhitelistedNames</code>
        /// element and its child elements, CloudFront deletes them automatically.</p>
        /// <p>For the current limit on the number of cookie names that you can whitelist for each
        /// cache behavior, see <a href="https://docs.aws.amazon.com/general/latest/gr/xrefaws_service_limits.html#limits_cloudfront">
        /// CloudFront Limits</a> in the <i>Amazon Web Services General Reference</i>.</p>
        pub fn set_whitelisted_names(
            mut self,
            input: std::option::Option<crate::model::CookieNames>,
        ) -> Self {
            self.whitelisted_names = input;
            self
        }
        /// Consumes the builder and constructs a [`CookiePreference`](crate::model::CookiePreference)
        pub fn build(self) -> crate::model::CookiePreference {
            crate::model::CookiePreference {
                forward: self.forward,
                whitelisted_names: self.whitelisted_names,
            }
        }
    }
}
impl CookiePreference {
    /// Creates a new builder-style object to manufacture [`CookiePreference`](crate::model::CookiePreference)
    pub fn builder() -> crate::model::cookie_preference::Builder {
        crate::model::cookie_preference::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ItemSelection {
    #[allow(missing_docs)] // documentation missing in model
    All,
    #[allow(missing_docs)] // documentation missing in model
    None,
    #[allow(missing_docs)] // documentation missing in model
    Whitelist,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ItemSelection {
    fn from(s: &str) -> Self {
        match s {
            "all" => ItemSelection::All,
            "none" => ItemSelection::None,
            "whitelist" => ItemSelection::Whitelist,
            other => ItemSelection::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ItemSelection {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ItemSelection::from(s))
    }
}
impl ItemSelection {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ItemSelection::All => "all",
            ItemSelection::None => "none",
            ItemSelection::Whitelist => "whitelist",
            ItemSelection::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["all", "none", "whitelist"]
    }
}
impl AsRef<str> for ItemSelection {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>A list of CloudFront functions that are associated with a cache behavior in a CloudFront distribution.
/// CloudFront functions must be published to the <code>LIVE</code> stage to associate them with a
/// cache behavior.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct FunctionAssociations {
    /// <p>The number of CloudFront functions in the list.</p>
    pub quantity: std::option::Option<i32>,
    /// <p>The CloudFront functions that are associated with a cache behavior in a CloudFront distribution.  CloudFront
    /// functions must be published to the <code>LIVE</code> stage to associate them with a
    /// cache behavior.</p>
    pub items: std::option::Option<std::vec::Vec<crate::model::FunctionAssociation>>,
}
impl FunctionAssociations {
    /// <p>The number of CloudFront functions in the list.</p>
    pub fn quantity(&self) -> std::option::Option<i32> {
        self.quantity
    }
    /// <p>The CloudFront functions that are associated with a cache behavior in a CloudFront distribution.  CloudFront
    /// functions must be published to the <code>LIVE</code> stage to associate them with a
    /// cache behavior.</p>
    pub fn items(&self) -> std::option::Option<&[crate::model::FunctionAssociation]> {
        self.items.as_deref()
    }
}
impl std::fmt::Debug for FunctionAssociations {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("FunctionAssociations");
        formatter.field("quantity", &self.quantity);
        formatter.field("items", &self.items);
        formatter.finish()
    }
}
/// See [`FunctionAssociations`](crate::model::FunctionAssociations)
pub mod function_associations {
    /// A builder for [`FunctionAssociations`](crate::model::FunctionAssociations)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) quantity: std::option::Option<i32>,
        pub(crate) items: std::option::Option<std::vec::Vec<crate::model::FunctionAssociation>>,
    }
    impl Builder {
        /// <p>The number of CloudFront functions in the list.</p>
        pub fn quantity(mut self, input: i32) -> Self {
            self.quantity = Some(input);
            self
        }
        /// <p>The number of CloudFront functions in the list.</p>
        pub fn set_quantity(mut self, input: std::option::Option<i32>) -> Self {
            self.quantity = input;
            self
        }
        /// Appends an item to `items`.
        ///
        /// To override the contents of this collection use [`set_items`](Self::set_items).
        ///
        /// <p>The CloudFront functions that are associated with a cache behavior in a CloudFront distribution.  CloudFront
        /// functions must be published to the <code>LIVE</code> stage to associate them with a
        /// cache behavior.</p>
        pub fn items(mut self, input: impl Into<crate::model::FunctionAssociation>) -> Self {
            let mut v = self.items.unwrap_or_default();
            v.push(input.into());
            self.items = Some(v);
            self
        }
        /// <p>The CloudFront functions that are associated with a cache behavior in a CloudFront distribution.  CloudFront
        /// functions must be published to the <code>LIVE</code> stage to associate them with a
        /// cache behavior.</p>
        pub fn set_items(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::FunctionAssociation>>,
        ) -> Self {
            self.items = input;
            self
        }
        /// Consumes the builder and constructs a [`FunctionAssociations`](crate::model::FunctionAssociations)
        pub fn build(self) -> crate::model::FunctionAssociations {
            crate::model::FunctionAssociations {
                quantity: self.quantity,
                items: self.items,
            }
        }
    }
}
impl FunctionAssociations {
    /// Creates a new builder-style object to manufacture [`FunctionAssociations`](crate::model::FunctionAssociations)
    pub fn builder() -> crate::model::function_associations::Builder {
        crate::model::function_associations::Builder::default()
    }
}

/// <p>A CloudFront function that is associated with a cache behavior in a CloudFront
/// distribution.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct FunctionAssociation {
    /// <p>The Amazon Resource Name (ARN) of the function.</p>
    pub function_arn: std::option::Option<std::string::String>,
    /// <p>The event type of the function, either <code>viewer-request</code> or
    /// <code>viewer-response</code>. You cannot use origin-facing event types
    /// (<code>origin-request</code> and <code>origin-response</code>) with a CloudFront
    /// function.</p>
    pub event_type: std::option::Option<crate::model::EventType>,
}
impl FunctionAssociation {
    /// <p>The Amazon Resource Name (ARN) of the function.</p>
    pub fn function_arn(&self) -> std::option::Option<&str> {
        self.function_arn.as_deref()
    }
    /// <p>The event type of the function, either <code>viewer-request</code> or
    /// <code>viewer-response</code>. You cannot use origin-facing event types
    /// (<code>origin-request</code> and <code>origin-response</code>) with a CloudFront
    /// function.</p>
    pub fn event_type(&self) -> std::option::Option<&crate::model::EventType> {
        self.event_type.as_ref()
    }
}
impl std::fmt::Debug for FunctionAssociation {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("FunctionAssociation");
        formatter.field("function_arn", &self.function_arn);
        formatter.field("event_type", &self.event_type);
        formatter.finish()
    }
}
/// See [`FunctionAssociation`](crate::model::FunctionAssociation)
pub mod function_association {
    /// A builder for [`FunctionAssociation`](crate::model::FunctionAssociation)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) function_arn: std::option::Option<std::string::String>,
        pub(crate) event_type: std::option::Option<crate::model::EventType>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the function.</p>
        pub fn function_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.function_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the function.</p>
        pub fn set_function_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.function_arn = input;
            self
        }
        /// <p>The event type of the function, either <code>viewer-request</code> or
        /// <code>viewer-response</code>. You cannot use origin-facing event types
        /// (<code>origin-request</code> and <code>origin-response</code>) with a CloudFront
        /// function.</p>
        pub fn event_type(mut self, input: crate::model::EventType) -> Self {
            self.event_type = Some(input);
            self
        }
        /// <p>The event type of the function, either <code>viewer-request</code> or
        /// <code>viewer-response</code>. You cannot use origin-facing event types
        /// (<code>origin-request</code> and <code>origin-response</code>) with a CloudFront
        /// function.</p>
        pub fn set_event_type(
            mut self,
            input: std::option::Option<crate::model::EventType>,
        ) -> Self {
            self.event_type = input;
            self
        }
        /// Consumes the builder and constructs a [`FunctionAssociation`](crate::model::FunctionAssociation)
        pub fn build(self) -> crate::model::FunctionAssociation {
            crate::model::FunctionAssociation {
                function_arn: self.function_arn,
                event_type: self.event_type,
            }
        }
    }
}
impl FunctionAssociation {
    /// Creates a new builder-style object to manufacture [`FunctionAssociation`](crate::model::FunctionAssociation)
    pub fn builder() -> crate::model::function_association::Builder {
        crate::model::function_association::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum EventType {
    #[allow(missing_docs)] // documentation missing in model
    OriginRequest,
    #[allow(missing_docs)] // documentation missing in model
    OriginResponse,
    #[allow(missing_docs)] // documentation missing in model
    ViewerRequest,
    #[allow(missing_docs)] // documentation missing in model
    ViewerResponse,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for EventType {
    fn from(s: &str) -> Self {
        match s {
            "origin-request" => EventType::OriginRequest,
            "origin-response" => EventType::OriginResponse,
            "viewer-request" => EventType::ViewerRequest,
            "viewer-response" => EventType::ViewerResponse,
            other => EventType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for EventType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(EventType::from(s))
    }
}
impl EventType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            EventType::OriginRequest => "origin-request",
            EventType::OriginResponse => "origin-response",
            EventType::ViewerRequest => "viewer-request",
            EventType::ViewerResponse => "viewer-response",
            EventType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "origin-request",
            "origin-response",
            "viewer-request",
            "viewer-response",
        ]
    }
}
impl AsRef<str> for EventType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>A complex type that specifies a list of Lambda@Edge functions associations for a cache
/// behavior.</p>
///
/// <p>If you want to invoke one or more Lambda@Edge functions triggered by requests that match the
/// <code>PathPattern</code> of the cache behavior, specify the applicable values for
/// <code>Quantity</code> and <code>Items</code>. Note that there can be up to 4
/// <code>LambdaFunctionAssociation</code> items in this list (one for each possible value of
/// <code>EventType</code>) and each <code>EventType</code> can be associated with only one function.</p>
///
/// <p>If you don't want to invoke any Lambda@Edge functions for the requests that match
/// <code>PathPattern</code>, specify <code>0</code> for <code>Quantity</code> and omit
/// <code>Items</code>. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LambdaFunctionAssociations {
    /// <p>The number of Lambda@Edge function associations for this cache behavior.</p>
    pub quantity: std::option::Option<i32>,
    /// <p>
    /// <b>Optional</b>: A complex type that contains <code>LambdaFunctionAssociation</code> items
    /// for this cache behavior. If <code>Quantity</code> is <code>0</code>, you can omit <code>Items</code>.</p>
    pub items: std::option::Option<std::vec::Vec<crate::model::LambdaFunctionAssociation>>,
}
impl LambdaFunctionAssociations {
    /// <p>The number of Lambda@Edge function associations for this cache behavior.</p>
    pub fn quantity(&self) -> std::option::Option<i32> {
        self.quantity
    }
    /// <p>
    /// <b>Optional</b>: A complex type that contains <code>LambdaFunctionAssociation</code> items
    /// for this cache behavior. If <code>Quantity</code> is <code>0</code>, you can omit <code>Items</code>.</p>
    pub fn items(&self) -> std::option::Option<&[crate::model::LambdaFunctionAssociation]> {
        self.items.as_deref()
    }
}
impl std::fmt::Debug for LambdaFunctionAssociations {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LambdaFunctionAssociations");
        formatter.field("quantity", &self.quantity);
        formatter.field("items", &self.items);
        formatter.finish()
    }
}
/// See [`LambdaFunctionAssociations`](crate::model::LambdaFunctionAssociations)
pub mod lambda_function_associations {
    /// A builder for [`LambdaFunctionAssociations`](crate::model::LambdaFunctionAssociations)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) quantity: std::option::Option<i32>,
        pub(crate) items:
            std::option::Option<std::vec::Vec<crate::model::LambdaFunctionAssociation>>,
    }
    impl Builder {
        /// <p>The number of Lambda@Edge function associations for this cache behavior.</p>
        pub fn quantity(mut self, input: i32) -> Self {
            self.quantity = Some(input);
            self
        }
        /// <p>The number of Lambda@Edge function associations for this cache behavior.</p>
        pub fn set_quantity(mut self, input: std::option::Option<i32>) -> Self {
            self.quantity = input;
            self
        }
        /// Appends an item to `items`.
        ///
        /// To override the contents of this collection use [`set_items`](Self::set_items).
        ///
        /// <p>
        /// <b>Optional</b>: A complex type that contains <code>LambdaFunctionAssociation</code> items
        /// for this cache behavior. If <code>Quantity</code> is <code>0</code>, you can omit <code>Items</code>.</p>
        pub fn items(mut self, input: impl Into<crate::model::LambdaFunctionAssociation>) -> Self {
            let mut v = self.items.unwrap_or_default();
            v.push(input.into());
            self.items = Some(v);
            self
        }
        /// <p>
        /// <b>Optional</b>: A complex type that contains <code>LambdaFunctionAssociation</code> items
        /// for this cache behavior. If <code>Quantity</code> is <code>0</code>, you can omit <code>Items</code>.</p>
        pub fn set_items(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::LambdaFunctionAssociation>>,
        ) -> Self {
            self.items = input;
            self
        }
        /// Consumes the builder and constructs a [`LambdaFunctionAssociations`](crate::model::LambdaFunctionAssociations)
        pub fn build(self) -> crate::model::LambdaFunctionAssociations {
            crate::model::LambdaFunctionAssociations {
                quantity: self.quantity,
                items: self.items,
            }
        }
    }
}
impl LambdaFunctionAssociations {
    /// Creates a new builder-style object to manufacture [`LambdaFunctionAssociations`](crate::model::LambdaFunctionAssociations)
    pub fn builder() -> crate::model::lambda_function_associations::Builder {
        crate::model::lambda_function_associations::Builder::default()
    }
}

/// <p>A complex type that contains a Lambda@Edge function association.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LambdaFunctionAssociation {
    /// <p>The ARN of the Lambda@Edge function. You must specify the ARN of a function version; you can't specify an alias
    /// or $LATEST.</p>
    pub lambda_function_arn: std::option::Option<std::string::String>,
    /// <p>Specifies the event type that triggers a Lambda@Edge function invocation. You can specify the following values:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>viewer-request</code>: The function executes when CloudFront receives a request from a viewer
    /// and before it checks to see whether the requested object is in the edge cache. </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>origin-request</code>: The function executes only when CloudFront sends a request to your
    /// origin. When the requested object is in the edge cache, the function doesn't
    /// execute.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>origin-response</code>: The function executes after CloudFront receives a response from the origin and
    /// before it caches the object in the response. When the requested object is in the edge cache, the function doesn't execute.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>viewer-response</code>: The function executes before CloudFront returns the requested object to the viewer.
    /// The function executes regardless of whether the object was already in the edge cache.</p>
    /// <p>If the origin returns an HTTP status code other than HTTP 200 (OK), the function doesn't execute.</p>
    /// </li>
    /// </ul>
    pub event_type: std::option::Option<crate::model::EventType>,
    /// <p>A flag that allows a Lambda@Edge function to have read access to the body content. For more information,
    /// see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/lambda-include-body-access.html">Accessing the Request Body by Choosing the
    /// Include Body Option</a> in the Amazon CloudFront Developer Guide.</p>
    pub include_body: std::option::Option<bool>,
}
impl LambdaFunctionAssociation {
    /// <p>The ARN of the Lambda@Edge function. You must specify the ARN of a function version; you can't specify an alias
    /// or $LATEST.</p>
    pub fn lambda_function_arn(&self) -> std::option::Option<&str> {
        self.lambda_function_arn.as_deref()
    }
    /// <p>Specifies the event type that triggers a Lambda@Edge function invocation. You can specify the following values:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>viewer-request</code>: The function executes when CloudFront receives a request from a viewer
    /// and before it checks to see whether the requested object is in the edge cache. </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>origin-request</code>: The function executes only when CloudFront sends a request to your
    /// origin. When the requested object is in the edge cache, the function doesn't
    /// execute.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>origin-response</code>: The function executes after CloudFront receives a response from the origin and
    /// before it caches the object in the response. When the requested object is in the edge cache, the function doesn't execute.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>viewer-response</code>: The function executes before CloudFront returns the requested object to the viewer.
    /// The function executes regardless of whether the object was already in the edge cache.</p>
    /// <p>If the origin returns an HTTP status code other than HTTP 200 (OK), the function doesn't execute.</p>
    /// </li>
    /// </ul>
    pub fn event_type(&self) -> std::option::Option<&crate::model::EventType> {
        self.event_type.as_ref()
    }
    /// <p>A flag that allows a Lambda@Edge function to have read access to the body content. For more information,
    /// see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/lambda-include-body-access.html">Accessing the Request Body by Choosing the
    /// Include Body Option</a> in the Amazon CloudFront Developer Guide.</p>
    pub fn include_body(&self) -> std::option::Option<bool> {
        self.include_body
    }
}
impl std::fmt::Debug for LambdaFunctionAssociation {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LambdaFunctionAssociation");
        formatter.field("lambda_function_arn", &self.lambda_function_arn);
        formatter.field("event_type", &self.event_type);
        formatter.field("include_body", &self.include_body);
        formatter.finish()
    }
}
/// See [`LambdaFunctionAssociation`](crate::model::LambdaFunctionAssociation)
pub mod lambda_function_association {
    /// A builder for [`LambdaFunctionAssociation`](crate::model::LambdaFunctionAssociation)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) lambda_function_arn: std::option::Option<std::string::String>,
        pub(crate) event_type: std::option::Option<crate::model::EventType>,
        pub(crate) include_body: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The ARN of the Lambda@Edge function. You must specify the ARN of a function version; you can't specify an alias
        /// or $LATEST.</p>
        pub fn lambda_function_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.lambda_function_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the Lambda@Edge function. You must specify the ARN of a function version; you can't specify an alias
        /// or $LATEST.</p>
        pub fn set_lambda_function_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.lambda_function_arn = input;
            self
        }
        /// <p>Specifies the event type that triggers a Lambda@Edge function invocation. You can specify the following values:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>viewer-request</code>: The function executes when CloudFront receives a request from a viewer
        /// and before it checks to see whether the requested object is in the edge cache. </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>origin-request</code>: The function executes only when CloudFront sends a request to your
        /// origin. When the requested object is in the edge cache, the function doesn't
        /// execute.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>origin-response</code>: The function executes after CloudFront receives a response from the origin and
        /// before it caches the object in the response. When the requested object is in the edge cache, the function doesn't execute.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>viewer-response</code>: The function executes before CloudFront returns the requested object to the viewer.
        /// The function executes regardless of whether the object was already in the edge cache.</p>
        /// <p>If the origin returns an HTTP status code other than HTTP 200 (OK), the function doesn't execute.</p>
        /// </li>
        /// </ul>
        pub fn event_type(mut self, input: crate::model::EventType) -> Self {
            self.event_type = Some(input);
            self
        }
        /// <p>Specifies the event type that triggers a Lambda@Edge function invocation. You can specify the following values:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>viewer-request</code>: The function executes when CloudFront receives a request from a viewer
        /// and before it checks to see whether the requested object is in the edge cache. </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>origin-request</code>: The function executes only when CloudFront sends a request to your
        /// origin. When the requested object is in the edge cache, the function doesn't
        /// execute.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>origin-response</code>: The function executes after CloudFront receives a response from the origin and
        /// before it caches the object in the response. When the requested object is in the edge cache, the function doesn't execute.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>viewer-response</code>: The function executes before CloudFront returns the requested object to the viewer.
        /// The function executes regardless of whether the object was already in the edge cache.</p>
        /// <p>If the origin returns an HTTP status code other than HTTP 200 (OK), the function doesn't execute.</p>
        /// </li>
        /// </ul>
        pub fn set_event_type(
            mut self,
            input: std::option::Option<crate::model::EventType>,
        ) -> Self {
            self.event_type = input;
            self
        }
        /// <p>A flag that allows a Lambda@Edge function to have read access to the body content. For more information,
        /// see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/lambda-include-body-access.html">Accessing the Request Body by Choosing the
        /// Include Body Option</a> in the Amazon CloudFront Developer Guide.</p>
        pub fn include_body(mut self, input: bool) -> Self {
            self.include_body = Some(input);
            self
        }
        /// <p>A flag that allows a Lambda@Edge function to have read access to the body content. For more information,
        /// see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/lambda-include-body-access.html">Accessing the Request Body by Choosing the
        /// Include Body Option</a> in the Amazon CloudFront Developer Guide.</p>
        pub fn set_include_body(mut self, input: std::option::Option<bool>) -> Self {
            self.include_body = input;
            self
        }
        /// Consumes the builder and constructs a [`LambdaFunctionAssociation`](crate::model::LambdaFunctionAssociation)
        pub fn build(self) -> crate::model::LambdaFunctionAssociation {
            crate::model::LambdaFunctionAssociation {
                lambda_function_arn: self.lambda_function_arn,
                event_type: self.event_type,
                include_body: self.include_body,
            }
        }
    }
}
impl LambdaFunctionAssociation {
    /// Creates a new builder-style object to manufacture [`LambdaFunctionAssociation`](crate::model::LambdaFunctionAssociation)
    pub fn builder() -> crate::model::lambda_function_association::Builder {
        crate::model::lambda_function_association::Builder::default()
    }
}

/// <p>A complex type that controls which HTTP methods CloudFront processes and forwards to your
/// Amazon S3 bucket or your custom origin. There are three choices:</p>
/// <ul>
/// <li>
/// <p>CloudFront forwards only <code>GET</code> and <code>HEAD</code> requests.</p>
/// </li>
/// <li>
/// <p>CloudFront forwards only <code>GET</code>, <code>HEAD</code>, and <code>OPTIONS</code>
/// requests.</p>
/// </li>
/// <li>
/// <p>CloudFront forwards <code>GET, HEAD, OPTIONS, PUT, PATCH, POST</code>, and
/// <code>DELETE</code> requests.</p>
/// </li>
/// </ul>
/// <p>If you pick the third choice, you may need to restrict access to your Amazon S3 bucket or
/// to your custom origin so users can't perform operations that you don't want them to. For
/// example, you might not want users to have permissions to delete objects from your
/// origin.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AllowedMethods {
    /// <p>The number of HTTP methods that you want CloudFront to forward to your origin. Valid values
    /// are 2 (for <code>GET</code> and <code>HEAD</code> requests), 3 (for <code>GET</code>,
    /// <code>HEAD</code>, and <code>OPTIONS</code> requests) and 7 (for <code>GET, HEAD, OPTIONS,
    /// PUT, PATCH, POST</code>, and <code>DELETE</code> requests).</p>
    pub quantity: std::option::Option<i32>,
    /// <p>A complex type that contains the HTTP methods that you want CloudFront to process and forward
    /// to your origin.</p>
    pub items: std::option::Option<std::vec::Vec<crate::model::Method>>,
    /// <p>A complex type that controls whether CloudFront caches the response to requests using the
    /// specified HTTP methods. There are two choices:</p>
    /// <ul>
    /// <li>
    /// <p>CloudFront caches responses to <code>GET</code> and <code>HEAD</code> requests.</p>
    /// </li>
    /// <li>
    /// <p>CloudFront caches responses to <code>GET</code>, <code>HEAD</code>, and
    /// <code>OPTIONS</code> requests.</p>
    /// </li>
    /// </ul>
    /// <p>If you pick the second choice for your Amazon S3 Origin, you may need to forward
    /// Access-Control-Request-Method, Access-Control-Request-Headers, and Origin headers for the
    /// responses to be cached correctly. </p>
    pub cached_methods: std::option::Option<crate::model::CachedMethods>,
}
impl AllowedMethods {
    /// <p>The number of HTTP methods that you want CloudFront to forward to your origin. Valid values
    /// are 2 (for <code>GET</code> and <code>HEAD</code> requests), 3 (for <code>GET</code>,
    /// <code>HEAD</code>, and <code>OPTIONS</code> requests) and 7 (for <code>GET, HEAD, OPTIONS,
    /// PUT, PATCH, POST</code>, and <code>DELETE</code> requests).</p>
    pub fn quantity(&self) -> std::option::Option<i32> {
        self.quantity
    }
    /// <p>A complex type that contains the HTTP methods that you want CloudFront to process and forward
    /// to your origin.</p>
    pub fn items(&self) -> std::option::Option<&[crate::model::Method]> {
        self.items.as_deref()
    }
    /// <p>A complex type that controls whether CloudFront caches the response to requests using the
    /// specified HTTP methods. There are two choices:</p>
    /// <ul>
    /// <li>
    /// <p>CloudFront caches responses to <code>GET</code> and <code>HEAD</code> requests.</p>
    /// </li>
    /// <li>
    /// <p>CloudFront caches responses to <code>GET</code>, <code>HEAD</code>, and
    /// <code>OPTIONS</code> requests.</p>
    /// </li>
    /// </ul>
    /// <p>If you pick the second choice for your Amazon S3 Origin, you may need to forward
    /// Access-Control-Request-Method, Access-Control-Request-Headers, and Origin headers for the
    /// responses to be cached correctly. </p>
    pub fn cached_methods(&self) -> std::option::Option<&crate::model::CachedMethods> {
        self.cached_methods.as_ref()
    }
}
impl std::fmt::Debug for AllowedMethods {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AllowedMethods");
        formatter.field("quantity", &self.quantity);
        formatter.field("items", &self.items);
        formatter.field("cached_methods", &self.cached_methods);
        formatter.finish()
    }
}
/// See [`AllowedMethods`](crate::model::AllowedMethods)
pub mod allowed_methods {
    /// A builder for [`AllowedMethods`](crate::model::AllowedMethods)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) quantity: std::option::Option<i32>,
        pub(crate) items: std::option::Option<std::vec::Vec<crate::model::Method>>,
        pub(crate) cached_methods: std::option::Option<crate::model::CachedMethods>,
    }
    impl Builder {
        /// <p>The number of HTTP methods that you want CloudFront to forward to your origin. Valid values
        /// are 2 (for <code>GET</code> and <code>HEAD</code> requests), 3 (for <code>GET</code>,
        /// <code>HEAD</code>, and <code>OPTIONS</code> requests) and 7 (for <code>GET, HEAD, OPTIONS,
        /// PUT, PATCH, POST</code>, and <code>DELETE</code> requests).</p>
        pub fn quantity(mut self, input: i32) -> Self {
            self.quantity = Some(input);
            self
        }
        /// <p>The number of HTTP methods that you want CloudFront to forward to your origin. Valid values
        /// are 2 (for <code>GET</code> and <code>HEAD</code> requests), 3 (for <code>GET</code>,
        /// <code>HEAD</code>, and <code>OPTIONS</code> requests) and 7 (for <code>GET, HEAD, OPTIONS,
        /// PUT, PATCH, POST</code>, and <code>DELETE</code> requests).</p>
        pub fn set_quantity(mut self, input: std::option::Option<i32>) -> Self {
            self.quantity = input;
            self
        }
        /// Appends an item to `items`.
        ///
        /// To override the contents of this collection use [`set_items`](Self::set_items).
        ///
        /// <p>A complex type that contains the HTTP methods that you want CloudFront to process and forward
        /// to your origin.</p>
        pub fn items(mut self, input: impl Into<crate::model::Method>) -> Self {
            let mut v = self.items.unwrap_or_default();
            v.push(input.into());
            self.items = Some(v);
            self
        }
        /// <p>A complex type that contains the HTTP methods that you want CloudFront to process and forward
        /// to your origin.</p>
        pub fn set_items(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Method>>,
        ) -> Self {
            self.items = input;
            self
        }
        /// <p>A complex type that controls whether CloudFront caches the response to requests using the
        /// specified HTTP methods. There are two choices:</p>
        /// <ul>
        /// <li>
        /// <p>CloudFront caches responses to <code>GET</code> and <code>HEAD</code> requests.</p>
        /// </li>
        /// <li>
        /// <p>CloudFront caches responses to <code>GET</code>, <code>HEAD</code>, and
        /// <code>OPTIONS</code> requests.</p>
        /// </li>
        /// </ul>
        /// <p>If you pick the second choice for your Amazon S3 Origin, you may need to forward
        /// Access-Control-Request-Method, Access-Control-Request-Headers, and Origin headers for the
        /// responses to be cached correctly. </p>
        pub fn cached_methods(mut self, input: crate::model::CachedMethods) -> Self {
            self.cached_methods = Some(input);
            self
        }
        /// <p>A complex type that controls whether CloudFront caches the response to requests using the
        /// specified HTTP methods. There are two choices:</p>
        /// <ul>
        /// <li>
        /// <p>CloudFront caches responses to <code>GET</code> and <code>HEAD</code> requests.</p>
        /// </li>
        /// <li>
        /// <p>CloudFront caches responses to <code>GET</code>, <code>HEAD</code>, and
        /// <code>OPTIONS</code> requests.</p>
        /// </li>
        /// </ul>
        /// <p>If you pick the second choice for your Amazon S3 Origin, you may need to forward
        /// Access-Control-Request-Method, Access-Control-Request-Headers, and Origin headers for the
        /// responses to be cached correctly. </p>
        pub fn set_cached_methods(
            mut self,
            input: std::option::Option<crate::model::CachedMethods>,
        ) -> Self {
            self.cached_methods = input;
            self
        }
        /// Consumes the builder and constructs a [`AllowedMethods`](crate::model::AllowedMethods)
        pub fn build(self) -> crate::model::AllowedMethods {
            crate::model::AllowedMethods {
                quantity: self.quantity,
                items: self.items,
                cached_methods: self.cached_methods,
            }
        }
    }
}
impl AllowedMethods {
    /// Creates a new builder-style object to manufacture [`AllowedMethods`](crate::model::AllowedMethods)
    pub fn builder() -> crate::model::allowed_methods::Builder {
        crate::model::allowed_methods::Builder::default()
    }
}

/// <p>A complex type that controls whether CloudFront caches the response to requests using the
/// specified HTTP methods. There are two choices:</p>
/// <ul>
/// <li>
/// <p>CloudFront caches responses to <code>GET</code> and <code>HEAD</code> requests.</p>
/// </li>
/// <li>
/// <p>CloudFront caches responses to <code>GET</code>, <code>HEAD</code>, and
/// <code>OPTIONS</code> requests.</p>
/// </li>
/// </ul>
/// <p>If you pick the second choice for your Amazon S3 Origin, you may need to forward
/// Access-Control-Request-Method, Access-Control-Request-Headers, and Origin headers for the
/// responses to be cached correctly. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CachedMethods {
    /// <p>The number of HTTP methods for which you want CloudFront to cache responses. Valid values are
    /// <code>2</code> (for caching responses to <code>GET</code> and <code>HEAD</code> requests)
    /// and <code>3</code> (for caching responses to <code>GET</code>, <code>HEAD</code>, and
    /// <code>OPTIONS</code> requests).</p>
    pub quantity: std::option::Option<i32>,
    /// <p>A complex type that contains the HTTP methods that you want CloudFront to cache responses
    /// to.</p>
    pub items: std::option::Option<std::vec::Vec<crate::model::Method>>,
}
impl CachedMethods {
    /// <p>The number of HTTP methods for which you want CloudFront to cache responses. Valid values are
    /// <code>2</code> (for caching responses to <code>GET</code> and <code>HEAD</code> requests)
    /// and <code>3</code> (for caching responses to <code>GET</code>, <code>HEAD</code>, and
    /// <code>OPTIONS</code> requests).</p>
    pub fn quantity(&self) -> std::option::Option<i32> {
        self.quantity
    }
    /// <p>A complex type that contains the HTTP methods that you want CloudFront to cache responses
    /// to.</p>
    pub fn items(&self) -> std::option::Option<&[crate::model::Method]> {
        self.items.as_deref()
    }
}
impl std::fmt::Debug for CachedMethods {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CachedMethods");
        formatter.field("quantity", &self.quantity);
        formatter.field("items", &self.items);
        formatter.finish()
    }
}
/// See [`CachedMethods`](crate::model::CachedMethods)
pub mod cached_methods {
    /// A builder for [`CachedMethods`](crate::model::CachedMethods)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) quantity: std::option::Option<i32>,
        pub(crate) items: std::option::Option<std::vec::Vec<crate::model::Method>>,
    }
    impl Builder {
        /// <p>The number of HTTP methods for which you want CloudFront to cache responses. Valid values are
        /// <code>2</code> (for caching responses to <code>GET</code> and <code>HEAD</code> requests)
        /// and <code>3</code> (for caching responses to <code>GET</code>, <code>HEAD</code>, and
        /// <code>OPTIONS</code> requests).</p>
        pub fn quantity(mut self, input: i32) -> Self {
            self.quantity = Some(input);
            self
        }
        /// <p>The number of HTTP methods for which you want CloudFront to cache responses. Valid values are
        /// <code>2</code> (for caching responses to <code>GET</code> and <code>HEAD</code> requests)
        /// and <code>3</code> (for caching responses to <code>GET</code>, <code>HEAD</code>, and
        /// <code>OPTIONS</code> requests).</p>
        pub fn set_quantity(mut self, input: std::option::Option<i32>) -> Self {
            self.quantity = input;
            self
        }
        /// Appends an item to `items`.
        ///
        /// To override the contents of this collection use [`set_items`](Self::set_items).
        ///
        /// <p>A complex type that contains the HTTP methods that you want CloudFront to cache responses
        /// to.</p>
        pub fn items(mut self, input: impl Into<crate::model::Method>) -> Self {
            let mut v = self.items.unwrap_or_default();
            v.push(input.into());
            self.items = Some(v);
            self
        }
        /// <p>A complex type that contains the HTTP methods that you want CloudFront to cache responses
        /// to.</p>
        pub fn set_items(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Method>>,
        ) -> Self {
            self.items = input;
            self
        }
        /// Consumes the builder and constructs a [`CachedMethods`](crate::model::CachedMethods)
        pub fn build(self) -> crate::model::CachedMethods {
            crate::model::CachedMethods {
                quantity: self.quantity,
                items: self.items,
            }
        }
    }
}
impl CachedMethods {
    /// Creates a new builder-style object to manufacture [`CachedMethods`](crate::model::CachedMethods)
    pub fn builder() -> crate::model::cached_methods::Builder {
        crate::model::cached_methods::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum Method {
    #[allow(missing_docs)] // documentation missing in model
    Delete,
    #[allow(missing_docs)] // documentation missing in model
    Get,
    #[allow(missing_docs)] // documentation missing in model
    Head,
    #[allow(missing_docs)] // documentation missing in model
    Options,
    #[allow(missing_docs)] // documentation missing in model
    Patch,
    #[allow(missing_docs)] // documentation missing in model
    Post,
    #[allow(missing_docs)] // documentation missing in model
    Put,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for Method {
    fn from(s: &str) -> Self {
        match s {
            "DELETE" => Method::Delete,
            "GET" => Method::Get,
            "HEAD" => Method::Head,
            "OPTIONS" => Method::Options,
            "PATCH" => Method::Patch,
            "POST" => Method::Post,
            "PUT" => Method::Put,
            other => Method::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for Method {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(Method::from(s))
    }
}
impl Method {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            Method::Delete => "DELETE",
            Method::Get => "GET",
            Method::Head => "HEAD",
            Method::Options => "OPTIONS",
            Method::Patch => "PATCH",
            Method::Post => "POST",
            Method::Put => "PUT",
            Method::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["DELETE", "GET", "HEAD", "OPTIONS", "PATCH", "POST", "PUT"]
    }
}
impl AsRef<str> for Method {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ViewerProtocolPolicy {
    #[allow(missing_docs)] // documentation missing in model
    AllowAll,
    #[allow(missing_docs)] // documentation missing in model
    HttpsOnly,
    #[allow(missing_docs)] // documentation missing in model
    RedirectToHttps,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ViewerProtocolPolicy {
    fn from(s: &str) -> Self {
        match s {
            "allow-all" => ViewerProtocolPolicy::AllowAll,
            "https-only" => ViewerProtocolPolicy::HttpsOnly,
            "redirect-to-https" => ViewerProtocolPolicy::RedirectToHttps,
            other => ViewerProtocolPolicy::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ViewerProtocolPolicy {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ViewerProtocolPolicy::from(s))
    }
}
impl ViewerProtocolPolicy {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ViewerProtocolPolicy::AllowAll => "allow-all",
            ViewerProtocolPolicy::HttpsOnly => "https-only",
            ViewerProtocolPolicy::RedirectToHttps => "redirect-to-https",
            ViewerProtocolPolicy::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["allow-all", "https-only", "redirect-to-https"]
    }
}
impl AsRef<str> for ViewerProtocolPolicy {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>A list of key groups whose public keys CloudFront can use to verify the signatures of signed
/// URLs and signed cookies.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TrustedKeyGroups {
    /// <p>This field is <code>true</code> if any of the key groups in the list have public keys that
    /// CloudFront can use to verify the signatures of signed URLs and signed cookies. If not, this
    /// field is <code>false</code>.</p>
    pub enabled: std::option::Option<bool>,
    /// <p>The number of key groups in the list.</p>
    pub quantity: std::option::Option<i32>,
    /// <p>A list of key groups identifiers.</p>
    pub items: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl TrustedKeyGroups {
    /// <p>This field is <code>true</code> if any of the key groups in the list have public keys that
    /// CloudFront can use to verify the signatures of signed URLs and signed cookies. If not, this
    /// field is <code>false</code>.</p>
    pub fn enabled(&self) -> std::option::Option<bool> {
        self.enabled
    }
    /// <p>The number of key groups in the list.</p>
    pub fn quantity(&self) -> std::option::Option<i32> {
        self.quantity
    }
    /// <p>A list of key groups identifiers.</p>
    pub fn items(&self) -> std::option::Option<&[std::string::String]> {
        self.items.as_deref()
    }
}
impl std::fmt::Debug for TrustedKeyGroups {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TrustedKeyGroups");
        formatter.field("enabled", &self.enabled);
        formatter.field("quantity", &self.quantity);
        formatter.field("items", &self.items);
        formatter.finish()
    }
}
/// See [`TrustedKeyGroups`](crate::model::TrustedKeyGroups)
pub mod trusted_key_groups {
    /// A builder for [`TrustedKeyGroups`](crate::model::TrustedKeyGroups)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) enabled: std::option::Option<bool>,
        pub(crate) quantity: std::option::Option<i32>,
        pub(crate) items: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>This field is <code>true</code> if any of the key groups in the list have public keys that
        /// CloudFront can use to verify the signatures of signed URLs and signed cookies. If not, this
        /// field is <code>false</code>.</p>
        pub fn enabled(mut self, input: bool) -> Self {
            self.enabled = Some(input);
            self
        }
        /// <p>This field is <code>true</code> if any of the key groups in the list have public keys that
        /// CloudFront can use to verify the signatures of signed URLs and signed cookies. If not, this
        /// field is <code>false</code>.</p>
        pub fn set_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.enabled = input;
            self
        }
        /// <p>The number of key groups in the list.</p>
        pub fn quantity(mut self, input: i32) -> Self {
            self.quantity = Some(input);
            self
        }
        /// <p>The number of key groups in the list.</p>
        pub fn set_quantity(mut self, input: std::option::Option<i32>) -> Self {
            self.quantity = input;
            self
        }
        /// Appends an item to `items`.
        ///
        /// To override the contents of this collection use [`set_items`](Self::set_items).
        ///
        /// <p>A list of key groups identifiers.</p>
        pub fn items(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.items.unwrap_or_default();
            v.push(input.into());
            self.items = Some(v);
            self
        }
        /// <p>A list of key groups identifiers.</p>
        pub fn set_items(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.items = input;
            self
        }
        /// Consumes the builder and constructs a [`TrustedKeyGroups`](crate::model::TrustedKeyGroups)
        pub fn build(self) -> crate::model::TrustedKeyGroups {
            crate::model::TrustedKeyGroups {
                enabled: self.enabled,
                quantity: self.quantity,
                items: self.items,
            }
        }
    }
}
impl TrustedKeyGroups {
    /// Creates a new builder-style object to manufacture [`TrustedKeyGroups`](crate::model::TrustedKeyGroups)
    pub fn builder() -> crate::model::trusted_key_groups::Builder {
        crate::model::trusted_key_groups::Builder::default()
    }
}

/// <p>A complex type that describes the default cache behavior if you don’t specify a
/// <code>CacheBehavior</code> element or if request URLs don’t match any of the values of
/// <code>PathPattern</code> in <code>CacheBehavior</code> elements. You must create exactly
/// one default cache behavior.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DefaultCacheBehavior {
    /// <p>The value of <code>ID</code> for the origin that you want CloudFront to route requests to when
    /// they use the default cache behavior.</p>
    pub target_origin_id: std::option::Option<std::string::String>,
    /// <important>
    /// <p>We recommend using <code>TrustedKeyGroups</code> instead of
    /// <code>TrustedSigners</code>.</p>
    /// </important>
    /// <p>A list of Amazon Web Services account IDs whose public keys CloudFront can use to validate signed URLs or signed
    /// cookies.</p>
    /// <p>When a cache behavior contains trusted signers, CloudFront requires signed URLs or signed cookies
    /// for all requests that match the cache behavior. The URLs or cookies must be signed with
    /// the private key of a CloudFront key pair in a trusted signer’s Amazon Web Services account. The signed URL or
    /// cookie contains information about which public key CloudFront should use to verify the
    /// signature. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html">Serving private content</a> in the <i>Amazon CloudFront Developer Guide</i>.</p>
    pub trusted_signers: std::option::Option<crate::model::TrustedSigners>,
    /// <p>A list of key groups that CloudFront can use to validate signed URLs or signed cookies.</p>
    /// <p>When a cache behavior contains trusted key groups, CloudFront requires signed URLs or signed
    /// cookies for all requests that match the cache behavior. The URLs or cookies must be
    /// signed with a private key whose corresponding public key is in the key group. The signed
    /// URL or cookie contains information about which public key CloudFront should use to verify the
    /// signature. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html">Serving private content</a> in the <i>Amazon CloudFront Developer Guide</i>.</p>
    pub trusted_key_groups: std::option::Option<crate::model::TrustedKeyGroups>,
    /// <p>The protocol that viewers can use to access the files in the origin specified by
    /// <code>TargetOriginId</code> when a request matches the path pattern in
    /// <code>PathPattern</code>. You can specify the following options:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>allow-all</code>: Viewers can use HTTP or HTTPS.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>redirect-to-https</code>: If a viewer submits an HTTP request, CloudFront returns
    /// an HTTP status code of 301 (Moved Permanently) to the viewer along with the HTTPS URL. The
    /// viewer then resubmits the request using the new URL.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>https-only</code>: If a viewer sends an HTTP request, CloudFront returns an HTTP
    /// status code of 403 (Forbidden).</p>
    /// </li>
    /// </ul>
    /// <p>For more information about requiring the HTTPS protocol, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-https-viewers-to-cloudfront.html">Requiring HTTPS Between Viewers and CloudFront</a> in the <i>Amazon CloudFront Developer Guide</i>.</p>
    /// <note>
    /// <p>The only way to guarantee that viewers retrieve an object that was fetched from
    /// the origin using HTTPS is never to use any other protocol to fetch the object. If
    /// you have recently changed from HTTP to HTTPS, we recommend that you clear your
    /// objects’ cache because cached objects are protocol agnostic. That means that an edge
    /// location will return an object from the cache regardless of whether the current
    /// request protocol matches the protocol used previously. For more information, see
    /// <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Expiration.html">Managing Cache
    /// Expiration</a> in the
    /// <i>Amazon CloudFront Developer Guide</i>.</p>
    /// </note>
    pub viewer_protocol_policy: std::option::Option<crate::model::ViewerProtocolPolicy>,
    /// <p>A complex type that controls which HTTP methods CloudFront processes and forwards to your
    /// Amazon S3 bucket or your custom origin. There are three choices:</p>
    /// <ul>
    /// <li>
    /// <p>CloudFront forwards only <code>GET</code> and <code>HEAD</code> requests.</p>
    /// </li>
    /// <li>
    /// <p>CloudFront forwards only <code>GET</code>, <code>HEAD</code>, and <code>OPTIONS</code>
    /// requests.</p>
    /// </li>
    /// <li>
    /// <p>CloudFront forwards <code>GET, HEAD, OPTIONS, PUT, PATCH, POST</code>, and
    /// <code>DELETE</code> requests.</p>
    /// </li>
    /// </ul>
    /// <p>If you pick the third choice, you may need to restrict access to your Amazon S3 bucket or
    /// to your custom origin so users can't perform operations that you don't want them to. For
    /// example, you might not want users to have permissions to delete objects from your
    /// origin.</p>
    pub allowed_methods: std::option::Option<crate::model::AllowedMethods>,
    /// <p>Indicates whether you want to distribute media files in the Microsoft Smooth Streaming
    /// format using the origin that is associated with this cache behavior. If so, specify
    /// <code>true</code>; if not, specify <code>false</code>. If you specify <code>true</code> for
    /// <code>SmoothStreaming</code>, you can still distribute other content using this cache
    /// behavior if the content matches the value of <code>PathPattern</code>. </p>
    pub smooth_streaming: std::option::Option<bool>,
    /// <p>Whether you want CloudFront to automatically compress certain files for this cache behavior.
    /// If so, specify <code>true</code>; if not, specify <code>false</code>. For more information,
    /// see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/ServingCompressedFiles.html">Serving Compressed Files</a> in
    /// the <i>Amazon CloudFront Developer Guide</i>.</p>
    pub compress: std::option::Option<bool>,
    /// <p>A complex type that contains zero or more Lambda@Edge function associations for a cache
    /// behavior.</p>
    pub lambda_function_associations: std::option::Option<crate::model::LambdaFunctionAssociations>,
    /// <p>A list of CloudFront functions that are associated with this cache behavior. CloudFront functions must
    /// be published to the <code>LIVE</code> stage to associate them with a cache
    /// behavior.</p>
    pub function_associations: std::option::Option<crate::model::FunctionAssociations>,
    /// <p>The value of <code>ID</code> for the field-level encryption configuration that you want CloudFront
    /// to use for encrypting specific fields of data for the default cache behavior.</p>
    pub field_level_encryption_id: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the real-time log configuration that is attached to this
    /// cache behavior. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/real-time-logs.html">Real-time logs</a> in the <i>Amazon CloudFront Developer Guide</i>.</p>
    pub realtime_log_config_arn: std::option::Option<std::string::String>,
    /// <p>The unique identifier of the cache policy that is attached to the default cache behavior.
    /// For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy">Creating cache policies</a> or <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-managed-cache-policies.html">Using the managed cache policies</a> in the
    /// <i>Amazon CloudFront Developer Guide</i>.</p>
    /// <p>A <code>DefaultCacheBehavior</code> must include either a
    /// <code>CachePolicyId</code> or <code>ForwardedValues</code>. We recommend that you
    /// use a <code>CachePolicyId</code>.</p>
    pub cache_policy_id: std::option::Option<std::string::String>,
    /// <p>The unique identifier of the origin request policy that is attached to the default cache
    /// behavior. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-origin-requests.html#origin-request-create-origin-request-policy">Creating origin request policies</a> or <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-managed-origin-request-policies.html">Using the managed origin request policies</a> in the
    /// <i>Amazon CloudFront Developer Guide</i>.</p>
    pub origin_request_policy_id: std::option::Option<std::string::String>,
    /// <p>The identifier for a response headers policy.</p>
    pub response_headers_policy_id: std::option::Option<std::string::String>,
    /// <p>This field is deprecated. We recommend that you use a cache policy or an origin request
    /// policy instead of this field. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/working-with-policies.html">Working with policies</a> in the
    /// <i>Amazon CloudFront Developer Guide</i>.</p>
    /// <p>If you want to include values in the cache key, use a cache policy. For more information,
    /// see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy">Creating cache policies</a> or <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-managed-cache-policies.html">Using the managed cache policies</a> in the
    /// <i>Amazon CloudFront Developer Guide</i>.</p>
    /// <p>If you want to send values to the origin but not include them in the cache key, use an
    /// origin request policy. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-origin-requests.html#origin-request-create-origin-request-policy">Creating origin request policies</a> or <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-managed-origin-request-policies.html">Using the managed origin request policies</a> in the
    /// <i>Amazon CloudFront Developer Guide</i>.</p>
    /// <p>A <code>DefaultCacheBehavior</code> must include either a
    /// <code>CachePolicyId</code> or <code>ForwardedValues</code>. We recommend that you
    /// use a <code>CachePolicyId</code>.</p>
    /// <p>A complex type that specifies how CloudFront handles query strings, cookies, and HTTP headers.</p>
    pub forwarded_values: std::option::Option<crate::model::ForwardedValues>,
    /// <p>This field is deprecated. We recommend that you use the <code>MinTTL</code> field in a cache
    /// policy instead of this field. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy">Creating cache policies</a> or <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-managed-cache-policies.html">Using the managed cache policies</a> in the
    /// <i>Amazon CloudFront Developer Guide</i>.</p>
    /// <p>The minimum amount of time that you want objects to stay in CloudFront caches before CloudFront
    /// forwards another request to your origin to determine whether the object has been updated. For
    /// more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Expiration.html">Managing How Long Content Stays
    /// in an Edge Cache (Expiration)</a> in the <i>Amazon CloudFront Developer Guide</i>.</p>
    /// <p>You must specify <code>0</code> for <code>MinTTL</code> if you configure CloudFront to
    /// forward all headers to your origin (under <code>Headers</code>, if you specify <code>1</code>
    /// for <code>Quantity</code> and <code>*</code> for <code>Name</code>).</p>
    pub min_ttl: std::option::Option<i64>,
    /// <p>This field is deprecated. We recommend that you use the <code>DefaultTTL</code> field in a
    /// cache policy instead of this field. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy">Creating cache policies</a> or <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-managed-cache-policies.html">Using the managed cache policies</a> in the
    /// <i>Amazon CloudFront Developer Guide</i>.</p>
    /// <p>The default amount of time that you want objects to stay in CloudFront caches before CloudFront
    /// forwards another request to your origin to determine whether the object has been updated. The
    /// value that you specify applies only when your origin does not add HTTP headers such as
    /// <code>Cache-Control max-age</code>, <code>Cache-Control s-maxage</code>, and
    /// <code>Expires</code> to objects. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Expiration.html">Managing How Long Content Stays
    /// in an Edge Cache (Expiration)</a> in the <i>Amazon CloudFront Developer Guide</i>.</p>
    pub default_ttl: std::option::Option<i64>,
    /// <p>This field is deprecated. We recommend that you use the <code>MaxTTL</code> field in a cache
    /// policy instead of this field. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy">Creating cache policies</a> or <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-managed-cache-policies.html">Using the managed cache policies</a> in the
    /// <i>Amazon CloudFront Developer Guide</i>.</p>
    /// <p>The maximum amount of time that you want objects to stay in CloudFront caches before CloudFront
    /// forwards another request to your origin to determine whether the object has been updated. The
    /// value that you specify applies only when your origin adds HTTP headers such as
    /// <code>Cache-Control max-age</code>, <code>Cache-Control s-maxage</code>, and
    /// <code>Expires</code> to objects. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Expiration.html">Managing How Long Content Stays
    /// in an Edge Cache (Expiration)</a> in the <i>Amazon CloudFront Developer Guide</i>.</p>
    pub max_ttl: std::option::Option<i64>,
}
impl DefaultCacheBehavior {
    /// <p>The value of <code>ID</code> for the origin that you want CloudFront to route requests to when
    /// they use the default cache behavior.</p>
    pub fn target_origin_id(&self) -> std::option::Option<&str> {
        self.target_origin_id.as_deref()
    }
    /// <important>
    /// <p>We recommend using <code>TrustedKeyGroups</code> instead of
    /// <code>TrustedSigners</code>.</p>
    /// </important>
    /// <p>A list of Amazon Web Services account IDs whose public keys CloudFront can use to validate signed URLs or signed
    /// cookies.</p>
    /// <p>When a cache behavior contains trusted signers, CloudFront requires signed URLs or signed cookies
    /// for all requests that match the cache behavior. The URLs or cookies must be signed with
    /// the private key of a CloudFront key pair in a trusted signer’s Amazon Web Services account. The signed URL or
    /// cookie contains information about which public key CloudFront should use to verify the
    /// signature. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html">Serving private content</a> in the <i>Amazon CloudFront Developer Guide</i>.</p>
    pub fn trusted_signers(&self) -> std::option::Option<&crate::model::TrustedSigners> {
        self.trusted_signers.as_ref()
    }
    /// <p>A list of key groups that CloudFront can use to validate signed URLs or signed cookies.</p>
    /// <p>When a cache behavior contains trusted key groups, CloudFront requires signed URLs or signed
    /// cookies for all requests that match the cache behavior. The URLs or cookies must be
    /// signed with a private key whose corresponding public key is in the key group. The signed
    /// URL or cookie contains information about which public key CloudFront should use to verify the
    /// signature. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html">Serving private content</a> in the <i>Amazon CloudFront Developer Guide</i>.</p>
    pub fn trusted_key_groups(&self) -> std::option::Option<&crate::model::TrustedKeyGroups> {
        self.trusted_key_groups.as_ref()
    }
    /// <p>The protocol that viewers can use to access the files in the origin specified by
    /// <code>TargetOriginId</code> when a request matches the path pattern in
    /// <code>PathPattern</code>. You can specify the following options:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>allow-all</code>: Viewers can use HTTP or HTTPS.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>redirect-to-https</code>: If a viewer submits an HTTP request, CloudFront returns
    /// an HTTP status code of 301 (Moved Permanently) to the viewer along with the HTTPS URL. The
    /// viewer then resubmits the request using the new URL.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>https-only</code>: If a viewer sends an HTTP request, CloudFront returns an HTTP
    /// status code of 403 (Forbidden).</p>
    /// </li>
    /// </ul>
    /// <p>For more information about requiring the HTTPS protocol, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-https-viewers-to-cloudfront.html">Requiring HTTPS Between Viewers and CloudFront</a> in the <i>Amazon CloudFront Developer Guide</i>.</p>
    /// <note>
    /// <p>The only way to guarantee that viewers retrieve an object that was fetched from
    /// the origin using HTTPS is never to use any other protocol to fetch the object. If
    /// you have recently changed from HTTP to HTTPS, we recommend that you clear your
    /// objects’ cache because cached objects are protocol agnostic. That means that an edge
    /// location will return an object from the cache regardless of whether the current
    /// request protocol matches the protocol used previously. For more information, see
    /// <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Expiration.html">Managing Cache
    /// Expiration</a> in the
    /// <i>Amazon CloudFront Developer Guide</i>.</p>
    /// </note>
    pub fn viewer_protocol_policy(
        &self,
    ) -> std::option::Option<&crate::model::ViewerProtocolPolicy> {
        self.viewer_protocol_policy.as_ref()
    }
    /// <p>A complex type that controls which HTTP methods CloudFront processes and forwards to your
    /// Amazon S3 bucket or your custom origin. There are three choices:</p>
    /// <ul>
    /// <li>
    /// <p>CloudFront forwards only <code>GET</code> and <code>HEAD</code> requests.</p>
    /// </li>
    /// <li>
    /// <p>CloudFront forwards only <code>GET</code>, <code>HEAD</code>, and <code>OPTIONS</code>
    /// requests.</p>
    /// </li>
    /// <li>
    /// <p>CloudFront forwards <code>GET, HEAD, OPTIONS, PUT, PATCH, POST</code>, and
    /// <code>DELETE</code> requests.</p>
    /// </li>
    /// </ul>
    /// <p>If you pick the third choice, you may need to restrict access to your Amazon S3 bucket or
    /// to your custom origin so users can't perform operations that you don't want them to. For
    /// example, you might not want users to have permissions to delete objects from your
    /// origin.</p>
    pub fn allowed_methods(&self) -> std::option::Option<&crate::model::AllowedMethods> {
        self.allowed_methods.as_ref()
    }
    /// <p>Indicates whether you want to distribute media files in the Microsoft Smooth Streaming
    /// format using the origin that is associated with this cache behavior. If so, specify
    /// <code>true</code>; if not, specify <code>false</code>. If you specify <code>true</code> for
    /// <code>SmoothStreaming</code>, you can still distribute other content using this cache
    /// behavior if the content matches the value of <code>PathPattern</code>. </p>
    pub fn smooth_streaming(&self) -> std::option::Option<bool> {
        self.smooth_streaming
    }
    /// <p>Whether you want CloudFront to automatically compress certain files for this cache behavior.
    /// If so, specify <code>true</code>; if not, specify <code>false</code>. For more information,
    /// see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/ServingCompressedFiles.html">Serving Compressed Files</a> in
    /// the <i>Amazon CloudFront Developer Guide</i>.</p>
    pub fn compress(&self) -> std::option::Option<bool> {
        self.compress
    }
    /// <p>A complex type that contains zero or more Lambda@Edge function associations for a cache
    /// behavior.</p>
    pub fn lambda_function_associations(
        &self,
    ) -> std::option::Option<&crate::model::LambdaFunctionAssociations> {
        self.lambda_function_associations.as_ref()
    }
    /// <p>A list of CloudFront functions that are associated with this cache behavior. CloudFront functions must
    /// be published to the <code>LIVE</code> stage to associate them with a cache
    /// behavior.</p>
    pub fn function_associations(
        &self,
    ) -> std::option::Option<&crate::model::FunctionAssociations> {
        self.function_associations.as_ref()
    }
    /// <p>The value of <code>ID</code> for the field-level encryption configuration that you want CloudFront
    /// to use for encrypting specific fields of data for the default cache behavior.</p>
    pub fn field_level_encryption_id(&self) -> std::option::Option<&str> {
        self.field_level_encryption_id.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the real-time log configuration that is attached to this
    /// cache behavior. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/real-time-logs.html">Real-time logs</a> in the <i>Amazon CloudFront Developer Guide</i>.</p>
    pub fn realtime_log_config_arn(&self) -> std::option::Option<&str> {
        self.realtime_log_config_arn.as_deref()
    }
    /// <p>The unique identifier of the cache policy that is attached to the default cache behavior.
    /// For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy">Creating cache policies</a> or <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-managed-cache-policies.html">Using the managed cache policies</a> in the
    /// <i>Amazon CloudFront Developer Guide</i>.</p>
    /// <p>A <code>DefaultCacheBehavior</code> must include either a
    /// <code>CachePolicyId</code> or <code>ForwardedValues</code>. We recommend that you
    /// use a <code>CachePolicyId</code>.</p>
    pub fn cache_policy_id(&self) -> std::option::Option<&str> {
        self.cache_policy_id.as_deref()
    }
    /// <p>The unique identifier of the origin request policy that is attached to the default cache
    /// behavior. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-origin-requests.html#origin-request-create-origin-request-policy">Creating origin request policies</a> or <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-managed-origin-request-policies.html">Using the managed origin request policies</a> in the
    /// <i>Amazon CloudFront Developer Guide</i>.</p>
    pub fn origin_request_policy_id(&self) -> std::option::Option<&str> {
        self.origin_request_policy_id.as_deref()
    }
    /// <p>The identifier for a response headers policy.</p>
    pub fn response_headers_policy_id(&self) -> std::option::Option<&str> {
        self.response_headers_policy_id.as_deref()
    }
    /// <p>This field is deprecated. We recommend that you use a cache policy or an origin request
    /// policy instead of this field. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/working-with-policies.html">Working with policies</a> in the
    /// <i>Amazon CloudFront Developer Guide</i>.</p>
    /// <p>If you want to include values in the cache key, use a cache policy. For more information,
    /// see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy">Creating cache policies</a> or <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-managed-cache-policies.html">Using the managed cache policies</a> in the
    /// <i>Amazon CloudFront Developer Guide</i>.</p>
    /// <p>If you want to send values to the origin but not include them in the cache key, use an
    /// origin request policy. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-origin-requests.html#origin-request-create-origin-request-policy">Creating origin request policies</a> or <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-managed-origin-request-policies.html">Using the managed origin request policies</a> in the
    /// <i>Amazon CloudFront Developer Guide</i>.</p>
    /// <p>A <code>DefaultCacheBehavior</code> must include either a
    /// <code>CachePolicyId</code> or <code>ForwardedValues</code>. We recommend that you
    /// use a <code>CachePolicyId</code>.</p>
    /// <p>A complex type that specifies how CloudFront handles query strings, cookies, and HTTP headers.</p>
    pub fn forwarded_values(&self) -> std::option::Option<&crate::model::ForwardedValues> {
        self.forwarded_values.as_ref()
    }
    /// <p>This field is deprecated. We recommend that you use the <code>MinTTL</code> field in a cache
    /// policy instead of this field. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy">Creating cache policies</a> or <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-managed-cache-policies.html">Using the managed cache policies</a> in the
    /// <i>Amazon CloudFront Developer Guide</i>.</p>
    /// <p>The minimum amount of time that you want objects to stay in CloudFront caches before CloudFront
    /// forwards another request to your origin to determine whether the object has been updated. For
    /// more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Expiration.html">Managing How Long Content Stays
    /// in an Edge Cache (Expiration)</a> in the <i>Amazon CloudFront Developer Guide</i>.</p>
    /// <p>You must specify <code>0</code> for <code>MinTTL</code> if you configure CloudFront to
    /// forward all headers to your origin (under <code>Headers</code>, if you specify <code>1</code>
    /// for <code>Quantity</code> and <code>*</code> for <code>Name</code>).</p>
    pub fn min_ttl(&self) -> std::option::Option<i64> {
        self.min_ttl
    }
    /// <p>This field is deprecated. We recommend that you use the <code>DefaultTTL</code> field in a
    /// cache policy instead of this field. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy">Creating cache policies</a> or <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-managed-cache-policies.html">Using the managed cache policies</a> in the
    /// <i>Amazon CloudFront Developer Guide</i>.</p>
    /// <p>The default amount of time that you want objects to stay in CloudFront caches before CloudFront
    /// forwards another request to your origin to determine whether the object has been updated. The
    /// value that you specify applies only when your origin does not add HTTP headers such as
    /// <code>Cache-Control max-age</code>, <code>Cache-Control s-maxage</code>, and
    /// <code>Expires</code> to objects. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Expiration.html">Managing How Long Content Stays
    /// in an Edge Cache (Expiration)</a> in the <i>Amazon CloudFront Developer Guide</i>.</p>
    pub fn default_ttl(&self) -> std::option::Option<i64> {
        self.default_ttl
    }
    /// <p>This field is deprecated. We recommend that you use the <code>MaxTTL</code> field in a cache
    /// policy instead of this field. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy">Creating cache policies</a> or <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-managed-cache-policies.html">Using the managed cache policies</a> in the
    /// <i>Amazon CloudFront Developer Guide</i>.</p>
    /// <p>The maximum amount of time that you want objects to stay in CloudFront caches before CloudFront
    /// forwards another request to your origin to determine whether the object has been updated. The
    /// value that you specify applies only when your origin adds HTTP headers such as
    /// <code>Cache-Control max-age</code>, <code>Cache-Control s-maxage</code>, and
    /// <code>Expires</code> to objects. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Expiration.html">Managing How Long Content Stays
    /// in an Edge Cache (Expiration)</a> in the <i>Amazon CloudFront Developer Guide</i>.</p>
    pub fn max_ttl(&self) -> std::option::Option<i64> {
        self.max_ttl
    }
}
impl std::fmt::Debug for DefaultCacheBehavior {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DefaultCacheBehavior");
        formatter.field("target_origin_id", &self.target_origin_id);
        formatter.field("trusted_signers", &self.trusted_signers);
        formatter.field("trusted_key_groups", &self.trusted_key_groups);
        formatter.field("viewer_protocol_policy", &self.viewer_protocol_policy);
        formatter.field("allowed_methods", &self.allowed_methods);
        formatter.field("smooth_streaming", &self.smooth_streaming);
        formatter.field("compress", &self.compress);
        formatter.field(
            "lambda_function_associations",
            &self.lambda_function_associations,
        );
        formatter.field("function_associations", &self.function_associations);
        formatter.field("field_level_encryption_id", &self.field_level_encryption_id);
        formatter.field("realtime_log_config_arn", &self.realtime_log_config_arn);
        formatter.field("cache_policy_id", &self.cache_policy_id);
        formatter.field("origin_request_policy_id", &self.origin_request_policy_id);
        formatter.field(
            "response_headers_policy_id",
            &self.response_headers_policy_id,
        );
        formatter.field("forwarded_values", &self.forwarded_values);
        formatter.field("min_ttl", &self.min_ttl);
        formatter.field("default_ttl", &self.default_ttl);
        formatter.field("max_ttl", &self.max_ttl);
        formatter.finish()
    }
}
/// See [`DefaultCacheBehavior`](crate::model::DefaultCacheBehavior)
pub mod default_cache_behavior {
    /// A builder for [`DefaultCacheBehavior`](crate::model::DefaultCacheBehavior)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) target_origin_id: std::option::Option<std::string::String>,
        pub(crate) trusted_signers: std::option::Option<crate::model::TrustedSigners>,
        pub(crate) trusted_key_groups: std::option::Option<crate::model::TrustedKeyGroups>,
        pub(crate) viewer_protocol_policy: std::option::Option<crate::model::ViewerProtocolPolicy>,
        pub(crate) allowed_methods: std::option::Option<crate::model::AllowedMethods>,
        pub(crate) smooth_streaming: std::option::Option<bool>,
        pub(crate) compress: std::option::Option<bool>,
        pub(crate) lambda_function_associations:
            std::option::Option<crate::model::LambdaFunctionAssociations>,
        pub(crate) function_associations: std::option::Option<crate::model::FunctionAssociations>,
        pub(crate) field_level_encryption_id: std::option::Option<std::string::String>,
        pub(crate) realtime_log_config_arn: std::option::Option<std::string::String>,
        pub(crate) cache_policy_id: std::option::Option<std::string::String>,
        pub(crate) origin_request_policy_id: std::option::Option<std::string::String>,
        pub(crate) response_headers_policy_id: std::option::Option<std::string::String>,
        pub(crate) forwarded_values: std::option::Option<crate::model::ForwardedValues>,
        pub(crate) min_ttl: std::option::Option<i64>,
        pub(crate) default_ttl: std::option::Option<i64>,
        pub(crate) max_ttl: std::option::Option<i64>,
    }
    impl Builder {
        /// <p>The value of <code>ID</code> for the origin that you want CloudFront to route requests to when
        /// they use the default cache behavior.</p>
        pub fn target_origin_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.target_origin_id = Some(input.into());
            self
        }
        /// <p>The value of <code>ID</code> for the origin that you want CloudFront to route requests to when
        /// they use the default cache behavior.</p>
        pub fn set_target_origin_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.target_origin_id = input;
            self
        }
        /// <important>
        /// <p>We recommend using <code>TrustedKeyGroups</code> instead of
        /// <code>TrustedSigners</code>.</p>
        /// </important>
        /// <p>A list of Amazon Web Services account IDs whose public keys CloudFront can use to validate signed URLs or signed
        /// cookies.</p>
        /// <p>When a cache behavior contains trusted signers, CloudFront requires signed URLs or signed cookies
        /// for all requests that match the cache behavior. The URLs or cookies must be signed with
        /// the private key of a CloudFront key pair in a trusted signer’s Amazon Web Services account. The signed URL or
        /// cookie contains information about which public key CloudFront should use to verify the
        /// signature. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html">Serving private content</a> in the <i>Amazon CloudFront Developer Guide</i>.</p>
        pub fn trusted_signers(mut self, input: crate::model::TrustedSigners) -> Self {
            self.trusted_signers = Some(input);
            self
        }
        /// <important>
        /// <p>We recommend using <code>TrustedKeyGroups</code> instead of
        /// <code>TrustedSigners</code>.</p>
        /// </important>
        /// <p>A list of Amazon Web Services account IDs whose public keys CloudFront can use to validate signed URLs or signed
        /// cookies.</p>
        /// <p>When a cache behavior contains trusted signers, CloudFront requires signed URLs or signed cookies
        /// for all requests that match the cache behavior. The URLs or cookies must be signed with
        /// the private key of a CloudFront key pair in a trusted signer’s Amazon Web Services account. The signed URL or
        /// cookie contains information about which public key CloudFront should use to verify the
        /// signature. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html">Serving private content</a> in the <i>Amazon CloudFront Developer Guide</i>.</p>
        pub fn set_trusted_signers(
            mut self,
            input: std::option::Option<crate::model::TrustedSigners>,
        ) -> Self {
            self.trusted_signers = input;
            self
        }
        /// <p>A list of key groups that CloudFront can use to validate signed URLs or signed cookies.</p>
        /// <p>When a cache behavior contains trusted key groups, CloudFront requires signed URLs or signed
        /// cookies for all requests that match the cache behavior. The URLs or cookies must be
        /// signed with a private key whose corresponding public key is in the key group. The signed
        /// URL or cookie contains information about which public key CloudFront should use to verify the
        /// signature. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html">Serving private content</a> in the <i>Amazon CloudFront Developer Guide</i>.</p>
        pub fn trusted_key_groups(mut self, input: crate::model::TrustedKeyGroups) -> Self {
            self.trusted_key_groups = Some(input);
            self
        }
        /// <p>A list of key groups that CloudFront can use to validate signed URLs or signed cookies.</p>
        /// <p>When a cache behavior contains trusted key groups, CloudFront requires signed URLs or signed
        /// cookies for all requests that match the cache behavior. The URLs or cookies must be
        /// signed with a private key whose corresponding public key is in the key group. The signed
        /// URL or cookie contains information about which public key CloudFront should use to verify the
        /// signature. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html">Serving private content</a> in the <i>Amazon CloudFront Developer Guide</i>.</p>
        pub fn set_trusted_key_groups(
            mut self,
            input: std::option::Option<crate::model::TrustedKeyGroups>,
        ) -> Self {
            self.trusted_key_groups = input;
            self
        }
        /// <p>The protocol that viewers can use to access the files in the origin specified by
        /// <code>TargetOriginId</code> when a request matches the path pattern in
        /// <code>PathPattern</code>. You can specify the following options:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>allow-all</code>: Viewers can use HTTP or HTTPS.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>redirect-to-https</code>: If a viewer submits an HTTP request, CloudFront returns
        /// an HTTP status code of 301 (Moved Permanently) to the viewer along with the HTTPS URL. The
        /// viewer then resubmits the request using the new URL.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>https-only</code>: If a viewer sends an HTTP request, CloudFront returns an HTTP
        /// status code of 403 (Forbidden).</p>
        /// </li>
        /// </ul>
        /// <p>For more information about requiring the HTTPS protocol, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-https-viewers-to-cloudfront.html">Requiring HTTPS Between Viewers and CloudFront</a> in the <i>Amazon CloudFront Developer Guide</i>.</p>
        /// <note>
        /// <p>The only way to guarantee that viewers retrieve an object that was fetched from
        /// the origin using HTTPS is never to use any other protocol to fetch the object. If
        /// you have recently changed from HTTP to HTTPS, we recommend that you clear your
        /// objects’ cache because cached objects are protocol agnostic. That means that an edge
        /// location will return an object from the cache regardless of whether the current
        /// request protocol matches the protocol used previously. For more information, see
        /// <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Expiration.html">Managing Cache
        /// Expiration</a> in the
        /// <i>Amazon CloudFront Developer Guide</i>.</p>
        /// </note>
        pub fn viewer_protocol_policy(mut self, input: crate::model::ViewerProtocolPolicy) -> Self {
            self.viewer_protocol_policy = Some(input);
            self
        }
        /// <p>The protocol that viewers can use to access the files in the origin specified by
        /// <code>TargetOriginId</code> when a request matches the path pattern in
        /// <code>PathPattern</code>. You can specify the following options:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>allow-all</code>: Viewers can use HTTP or HTTPS.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>redirect-to-https</code>: If a viewer submits an HTTP request, CloudFront returns
        /// an HTTP status code of 301 (Moved Permanently) to the viewer along with the HTTPS URL. The
        /// viewer then resubmits the request using the new URL.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>https-only</code>: If a viewer sends an HTTP request, CloudFront returns an HTTP
        /// status code of 403 (Forbidden).</p>
        /// </li>
        /// </ul>
        /// <p>For more information about requiring the HTTPS protocol, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-https-viewers-to-cloudfront.html">Requiring HTTPS Between Viewers and CloudFront</a> in the <i>Amazon CloudFront Developer Guide</i>.</p>
        /// <note>
        /// <p>The only way to guarantee that viewers retrieve an object that was fetched from
        /// the origin using HTTPS is never to use any other protocol to fetch the object. If
        /// you have recently changed from HTTP to HTTPS, we recommend that you clear your
        /// objects’ cache because cached objects are protocol agnostic. That means that an edge
        /// location will return an object from the cache regardless of whether the current
        /// request protocol matches the protocol used previously. For more information, see
        /// <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Expiration.html">Managing Cache
        /// Expiration</a> in the
        /// <i>Amazon CloudFront Developer Guide</i>.</p>
        /// </note>
        pub fn set_viewer_protocol_policy(
            mut self,
            input: std::option::Option<crate::model::ViewerProtocolPolicy>,
        ) -> Self {
            self.viewer_protocol_policy = input;
            self
        }
        /// <p>A complex type that controls which HTTP methods CloudFront processes and forwards to your
        /// Amazon S3 bucket or your custom origin. There are three choices:</p>
        /// <ul>
        /// <li>
        /// <p>CloudFront forwards only <code>GET</code> and <code>HEAD</code> requests.</p>
        /// </li>
        /// <li>
        /// <p>CloudFront forwards only <code>GET</code>, <code>HEAD</code>, and <code>OPTIONS</code>
        /// requests.</p>
        /// </li>
        /// <li>
        /// <p>CloudFront forwards <code>GET, HEAD, OPTIONS, PUT, PATCH, POST</code>, and
        /// <code>DELETE</code> requests.</p>
        /// </li>
        /// </ul>
        /// <p>If you pick the third choice, you may need to restrict access to your Amazon S3 bucket or
        /// to your custom origin so users can't perform operations that you don't want them to. For
        /// example, you might not want users to have permissions to delete objects from your
        /// origin.</p>
        pub fn allowed_methods(mut self, input: crate::model::AllowedMethods) -> Self {
            self.allowed_methods = Some(input);
            self
        }
        /// <p>A complex type that controls which HTTP methods CloudFront processes and forwards to your
        /// Amazon S3 bucket or your custom origin. There are three choices:</p>
        /// <ul>
        /// <li>
        /// <p>CloudFront forwards only <code>GET</code> and <code>HEAD</code> requests.</p>
        /// </li>
        /// <li>
        /// <p>CloudFront forwards only <code>GET</code>, <code>HEAD</code>, and <code>OPTIONS</code>
        /// requests.</p>
        /// </li>
        /// <li>
        /// <p>CloudFront forwards <code>GET, HEAD, OPTIONS, PUT, PATCH, POST</code>, and
        /// <code>DELETE</code> requests.</p>
        /// </li>
        /// </ul>
        /// <p>If you pick the third choice, you may need to restrict access to your Amazon S3 bucket or
        /// to your custom origin so users can't perform operations that you don't want them to. For
        /// example, you might not want users to have permissions to delete objects from your
        /// origin.</p>
        pub fn set_allowed_methods(
            mut self,
            input: std::option::Option<crate::model::AllowedMethods>,
        ) -> Self {
            self.allowed_methods = input;
            self
        }
        /// <p>Indicates whether you want to distribute media files in the Microsoft Smooth Streaming
        /// format using the origin that is associated with this cache behavior. If so, specify
        /// <code>true</code>; if not, specify <code>false</code>. If you specify <code>true</code> for
        /// <code>SmoothStreaming</code>, you can still distribute other content using this cache
        /// behavior if the content matches the value of <code>PathPattern</code>. </p>
        pub fn smooth_streaming(mut self, input: bool) -> Self {
            self.smooth_streaming = Some(input);
            self
        }
        /// <p>Indicates whether you want to distribute media files in the Microsoft Smooth Streaming
        /// format using the origin that is associated with this cache behavior. If so, specify
        /// <code>true</code>; if not, specify <code>false</code>. If you specify <code>true</code> for
        /// <code>SmoothStreaming</code>, you can still distribute other content using this cache
        /// behavior if the content matches the value of <code>PathPattern</code>. </p>
        pub fn set_smooth_streaming(mut self, input: std::option::Option<bool>) -> Self {
            self.smooth_streaming = input;
            self
        }
        /// <p>Whether you want CloudFront to automatically compress certain files for this cache behavior.
        /// If so, specify <code>true</code>; if not, specify <code>false</code>. For more information,
        /// see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/ServingCompressedFiles.html">Serving Compressed Files</a> in
        /// the <i>Amazon CloudFront Developer Guide</i>.</p>
        pub fn compress(mut self, input: bool) -> Self {
            self.compress = Some(input);
            self
        }
        /// <p>Whether you want CloudFront to automatically compress certain files for this cache behavior.
        /// If so, specify <code>true</code>; if not, specify <code>false</code>. For more information,
        /// see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/ServingCompressedFiles.html">Serving Compressed Files</a> in
        /// the <i>Amazon CloudFront Developer Guide</i>.</p>
        pub fn set_compress(mut self, input: std::option::Option<bool>) -> Self {
            self.compress = input;
            self
        }
        /// <p>A complex type that contains zero or more Lambda@Edge function associations for a cache
        /// behavior.</p>
        pub fn lambda_function_associations(
            mut self,
            input: crate::model::LambdaFunctionAssociations,
        ) -> Self {
            self.lambda_function_associations = Some(input);
            self
        }
        /// <p>A complex type that contains zero or more Lambda@Edge function associations for a cache
        /// behavior.</p>
        pub fn set_lambda_function_associations(
            mut self,
            input: std::option::Option<crate::model::LambdaFunctionAssociations>,
        ) -> Self {
            self.lambda_function_associations = input;
            self
        }
        /// <p>A list of CloudFront functions that are associated with this cache behavior. CloudFront functions must
        /// be published to the <code>LIVE</code> stage to associate them with a cache
        /// behavior.</p>
        pub fn function_associations(mut self, input: crate::model::FunctionAssociations) -> Self {
            self.function_associations = Some(input);
            self
        }
        /// <p>A list of CloudFront functions that are associated with this cache behavior. CloudFront functions must
        /// be published to the <code>LIVE</code> stage to associate them with a cache
        /// behavior.</p>
        pub fn set_function_associations(
            mut self,
            input: std::option::Option<crate::model::FunctionAssociations>,
        ) -> Self {
            self.function_associations = input;
            self
        }
        /// <p>The value of <code>ID</code> for the field-level encryption configuration that you want CloudFront
        /// to use for encrypting specific fields of data for the default cache behavior.</p>
        pub fn field_level_encryption_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.field_level_encryption_id = Some(input.into());
            self
        }
        /// <p>The value of <code>ID</code> for the field-level encryption configuration that you want CloudFront
        /// to use for encrypting specific fields of data for the default cache behavior.</p>
        pub fn set_field_level_encryption_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.field_level_encryption_id = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the real-time log configuration that is attached to this
        /// cache behavior. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/real-time-logs.html">Real-time logs</a> in the <i>Amazon CloudFront Developer Guide</i>.</p>
        pub fn realtime_log_config_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.realtime_log_config_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the real-time log configuration that is attached to this
        /// cache behavior. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/real-time-logs.html">Real-time logs</a> in the <i>Amazon CloudFront Developer Guide</i>.</p>
        pub fn set_realtime_log_config_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.realtime_log_config_arn = input;
            self
        }
        /// <p>The unique identifier of the cache policy that is attached to the default cache behavior.
        /// For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy">Creating cache policies</a> or <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-managed-cache-policies.html">Using the managed cache policies</a> in the
        /// <i>Amazon CloudFront Developer Guide</i>.</p>
        /// <p>A <code>DefaultCacheBehavior</code> must include either a
        /// <code>CachePolicyId</code> or <code>ForwardedValues</code>. We recommend that you
        /// use a <code>CachePolicyId</code>.</p>
        pub fn cache_policy_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.cache_policy_id = Some(input.into());
            self
        }
        /// <p>The unique identifier of the cache policy that is attached to the default cache behavior.
        /// For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy">Creating cache policies</a> or <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-managed-cache-policies.html">Using the managed cache policies</a> in the
        /// <i>Amazon CloudFront Developer Guide</i>.</p>
        /// <p>A <code>DefaultCacheBehavior</code> must include either a
        /// <code>CachePolicyId</code> or <code>ForwardedValues</code>. We recommend that you
        /// use a <code>CachePolicyId</code>.</p>
        pub fn set_cache_policy_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.cache_policy_id = input;
            self
        }
        /// <p>The unique identifier of the origin request policy that is attached to the default cache
        /// behavior. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-origin-requests.html#origin-request-create-origin-request-policy">Creating origin request policies</a> or <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-managed-origin-request-policies.html">Using the managed origin request policies</a> in the
        /// <i>Amazon CloudFront Developer Guide</i>.</p>
        pub fn origin_request_policy_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.origin_request_policy_id = Some(input.into());
            self
        }
        /// <p>The unique identifier of the origin request policy that is attached to the default cache
        /// behavior. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-origin-requests.html#origin-request-create-origin-request-policy">Creating origin request policies</a> or <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-managed-origin-request-policies.html">Using the managed origin request policies</a> in the
        /// <i>Amazon CloudFront Developer Guide</i>.</p>
        pub fn set_origin_request_policy_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.origin_request_policy_id = input;
            self
        }
        /// <p>The identifier for a response headers policy.</p>
        pub fn response_headers_policy_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.response_headers_policy_id = Some(input.into());
            self
        }
        /// <p>The identifier for a response headers policy.</p>
        pub fn set_response_headers_policy_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.response_headers_policy_id = input;
            self
        }
        /// <p>This field is deprecated. We recommend that you use a cache policy or an origin request
        /// policy instead of this field. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/working-with-policies.html">Working with policies</a> in the
        /// <i>Amazon CloudFront Developer Guide</i>.</p>
        /// <p>If you want to include values in the cache key, use a cache policy. For more information,
        /// see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy">Creating cache policies</a> or <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-managed-cache-policies.html">Using the managed cache policies</a> in the
        /// <i>Amazon CloudFront Developer Guide</i>.</p>
        /// <p>If you want to send values to the origin but not include them in the cache key, use an
        /// origin request policy. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-origin-requests.html#origin-request-create-origin-request-policy">Creating origin request policies</a> or <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-managed-origin-request-policies.html">Using the managed origin request policies</a> in the
        /// <i>Amazon CloudFront Developer Guide</i>.</p>
        /// <p>A <code>DefaultCacheBehavior</code> must include either a
        /// <code>CachePolicyId</code> or <code>ForwardedValues</code>. We recommend that you
        /// use a <code>CachePolicyId</code>.</p>
        /// <p>A complex type that specifies how CloudFront handles query strings, cookies, and HTTP headers.</p>
        pub fn forwarded_values(mut self, input: crate::model::ForwardedValues) -> Self {
            self.forwarded_values = Some(input);
            self
        }
        /// <p>This field is deprecated. We recommend that you use a cache policy or an origin request
        /// policy instead of this field. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/working-with-policies.html">Working with policies</a> in the
        /// <i>Amazon CloudFront Developer Guide</i>.</p>
        /// <p>If you want to include values in the cache key, use a cache policy. For more information,
        /// see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy">Creating cache policies</a> or <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-managed-cache-policies.html">Using the managed cache policies</a> in the
        /// <i>Amazon CloudFront Developer Guide</i>.</p>
        /// <p>If you want to send values to the origin but not include them in the cache key, use an
        /// origin request policy. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-origin-requests.html#origin-request-create-origin-request-policy">Creating origin request policies</a> or <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-managed-origin-request-policies.html">Using the managed origin request policies</a> in the
        /// <i>Amazon CloudFront Developer Guide</i>.</p>
        /// <p>A <code>DefaultCacheBehavior</code> must include either a
        /// <code>CachePolicyId</code> or <code>ForwardedValues</code>. We recommend that you
        /// use a <code>CachePolicyId</code>.</p>
        /// <p>A complex type that specifies how CloudFront handles query strings, cookies, and HTTP headers.</p>
        pub fn set_forwarded_values(
            mut self,
            input: std::option::Option<crate::model::ForwardedValues>,
        ) -> Self {
            self.forwarded_values = input;
            self
        }
        /// <p>This field is deprecated. We recommend that you use the <code>MinTTL</code> field in a cache
        /// policy instead of this field. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy">Creating cache policies</a> or <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-managed-cache-policies.html">Using the managed cache policies</a> in the
        /// <i>Amazon CloudFront Developer Guide</i>.</p>
        /// <p>The minimum amount of time that you want objects to stay in CloudFront caches before CloudFront
        /// forwards another request to your origin to determine whether the object has been updated. For
        /// more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Expiration.html">Managing How Long Content Stays
        /// in an Edge Cache (Expiration)</a> in the <i>Amazon CloudFront Developer Guide</i>.</p>
        /// <p>You must specify <code>0</code> for <code>MinTTL</code> if you configure CloudFront to
        /// forward all headers to your origin (under <code>Headers</code>, if you specify <code>1</code>
        /// for <code>Quantity</code> and <code>*</code> for <code>Name</code>).</p>
        pub fn min_ttl(mut self, input: i64) -> Self {
            self.min_ttl = Some(input);
            self
        }
        /// <p>This field is deprecated. We recommend that you use the <code>MinTTL</code> field in a cache
        /// policy instead of this field. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy">Creating cache policies</a> or <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-managed-cache-policies.html">Using the managed cache policies</a> in the
        /// <i>Amazon CloudFront Developer Guide</i>.</p>
        /// <p>The minimum amount of time that you want objects to stay in CloudFront caches before CloudFront
        /// forwards another request to your origin to determine whether the object has been updated. For
        /// more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Expiration.html">Managing How Long Content Stays
        /// in an Edge Cache (Expiration)</a> in the <i>Amazon CloudFront Developer Guide</i>.</p>
        /// <p>You must specify <code>0</code> for <code>MinTTL</code> if you configure CloudFront to
        /// forward all headers to your origin (under <code>Headers</code>, if you specify <code>1</code>
        /// for <code>Quantity</code> and <code>*</code> for <code>Name</code>).</p>
        pub fn set_min_ttl(mut self, input: std::option::Option<i64>) -> Self {
            self.min_ttl = input;
            self
        }
        /// <p>This field is deprecated. We recommend that you use the <code>DefaultTTL</code> field in a
        /// cache policy instead of this field. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy">Creating cache policies</a> or <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-managed-cache-policies.html">Using the managed cache policies</a> in the
        /// <i>Amazon CloudFront Developer Guide</i>.</p>
        /// <p>The default amount of time that you want objects to stay in CloudFront caches before CloudFront
        /// forwards another request to your origin to determine whether the object has been updated. The
        /// value that you specify applies only when your origin does not add HTTP headers such as
        /// <code>Cache-Control max-age</code>, <code>Cache-Control s-maxage</code>, and
        /// <code>Expires</code> to objects. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Expiration.html">Managing How Long Content Stays
        /// in an Edge Cache (Expiration)</a> in the <i>Amazon CloudFront Developer Guide</i>.</p>
        pub fn default_ttl(mut self, input: i64) -> Self {
            self.default_ttl = Some(input);
            self
        }
        /// <p>This field is deprecated. We recommend that you use the <code>DefaultTTL</code> field in a
        /// cache policy instead of this field. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy">Creating cache policies</a> or <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-managed-cache-policies.html">Using the managed cache policies</a> in the
        /// <i>Amazon CloudFront Developer Guide</i>.</p>
        /// <p>The default amount of time that you want objects to stay in CloudFront caches before CloudFront
        /// forwards another request to your origin to determine whether the object has been updated. The
        /// value that you specify applies only when your origin does not add HTTP headers such as
        /// <code>Cache-Control max-age</code>, <code>Cache-Control s-maxage</code>, and
        /// <code>Expires</code> to objects. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Expiration.html">Managing How Long Content Stays
        /// in an Edge Cache (Expiration)</a> in the <i>Amazon CloudFront Developer Guide</i>.</p>
        pub fn set_default_ttl(mut self, input: std::option::Option<i64>) -> Self {
            self.default_ttl = input;
            self
        }
        /// <p>This field is deprecated. We recommend that you use the <code>MaxTTL</code> field in a cache
        /// policy instead of this field. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy">Creating cache policies</a> or <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-managed-cache-policies.html">Using the managed cache policies</a> in the
        /// <i>Amazon CloudFront Developer Guide</i>.</p>
        /// <p>The maximum amount of time that you want objects to stay in CloudFront caches before CloudFront
        /// forwards another request to your origin to determine whether the object has been updated. The
        /// value that you specify applies only when your origin adds HTTP headers such as
        /// <code>Cache-Control max-age</code>, <code>Cache-Control s-maxage</code>, and
        /// <code>Expires</code> to objects. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Expiration.html">Managing How Long Content Stays
        /// in an Edge Cache (Expiration)</a> in the <i>Amazon CloudFront Developer Guide</i>.</p>
        pub fn max_ttl(mut self, input: i64) -> Self {
            self.max_ttl = Some(input);
            self
        }
        /// <p>This field is deprecated. We recommend that you use the <code>MaxTTL</code> field in a cache
        /// policy instead of this field. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy">Creating cache policies</a> or <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-managed-cache-policies.html">Using the managed cache policies</a> in the
        /// <i>Amazon CloudFront Developer Guide</i>.</p>
        /// <p>The maximum amount of time that you want objects to stay in CloudFront caches before CloudFront
        /// forwards another request to your origin to determine whether the object has been updated. The
        /// value that you specify applies only when your origin adds HTTP headers such as
        /// <code>Cache-Control max-age</code>, <code>Cache-Control s-maxage</code>, and
        /// <code>Expires</code> to objects. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Expiration.html">Managing How Long Content Stays
        /// in an Edge Cache (Expiration)</a> in the <i>Amazon CloudFront Developer Guide</i>.</p>
        pub fn set_max_ttl(mut self, input: std::option::Option<i64>) -> Self {
            self.max_ttl = input;
            self
        }
        /// Consumes the builder and constructs a [`DefaultCacheBehavior`](crate::model::DefaultCacheBehavior)
        pub fn build(self) -> crate::model::DefaultCacheBehavior {
            crate::model::DefaultCacheBehavior {
                target_origin_id: self.target_origin_id,
                trusted_signers: self.trusted_signers,
                trusted_key_groups: self.trusted_key_groups,
                viewer_protocol_policy: self.viewer_protocol_policy,
                allowed_methods: self.allowed_methods,
                smooth_streaming: self.smooth_streaming,
                compress: self.compress,
                lambda_function_associations: self.lambda_function_associations,
                function_associations: self.function_associations,
                field_level_encryption_id: self.field_level_encryption_id,
                realtime_log_config_arn: self.realtime_log_config_arn,
                cache_policy_id: self.cache_policy_id,
                origin_request_policy_id: self.origin_request_policy_id,
                response_headers_policy_id: self.response_headers_policy_id,
                forwarded_values: self.forwarded_values,
                min_ttl: self.min_ttl,
                default_ttl: self.default_ttl,
                max_ttl: self.max_ttl,
            }
        }
    }
}
impl DefaultCacheBehavior {
    /// Creates a new builder-style object to manufacture [`DefaultCacheBehavior`](crate::model::DefaultCacheBehavior)
    pub fn builder() -> crate::model::default_cache_behavior::Builder {
        crate::model::default_cache_behavior::Builder::default()
    }
}

/// <p>A complex data type for the origin groups specified for a distribution.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct OriginGroups {
    /// <p>The number of origin groups.</p>
    pub quantity: std::option::Option<i32>,
    /// <p>The items (origin groups) in a distribution.</p>
    pub items: std::option::Option<std::vec::Vec<crate::model::OriginGroup>>,
}
impl OriginGroups {
    /// <p>The number of origin groups.</p>
    pub fn quantity(&self) -> std::option::Option<i32> {
        self.quantity
    }
    /// <p>The items (origin groups) in a distribution.</p>
    pub fn items(&self) -> std::option::Option<&[crate::model::OriginGroup]> {
        self.items.as_deref()
    }
}
impl std::fmt::Debug for OriginGroups {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("OriginGroups");
        formatter.field("quantity", &self.quantity);
        formatter.field("items", &self.items);
        formatter.finish()
    }
}
/// See [`OriginGroups`](crate::model::OriginGroups)
pub mod origin_groups {
    /// A builder for [`OriginGroups`](crate::model::OriginGroups)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) quantity: std::option::Option<i32>,
        pub(crate) items: std::option::Option<std::vec::Vec<crate::model::OriginGroup>>,
    }
    impl Builder {
        /// <p>The number of origin groups.</p>
        pub fn quantity(mut self, input: i32) -> Self {
            self.quantity = Some(input);
            self
        }
        /// <p>The number of origin groups.</p>
        pub fn set_quantity(mut self, input: std::option::Option<i32>) -> Self {
            self.quantity = input;
            self
        }
        /// Appends an item to `items`.
        ///
        /// To override the contents of this collection use [`set_items`](Self::set_items).
        ///
        /// <p>The items (origin groups) in a distribution.</p>
        pub fn items(mut self, input: impl Into<crate::model::OriginGroup>) -> Self {
            let mut v = self.items.unwrap_or_default();
            v.push(input.into());
            self.items = Some(v);
            self
        }
        /// <p>The items (origin groups) in a distribution.</p>
        pub fn set_items(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::OriginGroup>>,
        ) -> Self {
            self.items = input;
            self
        }
        /// Consumes the builder and constructs a [`OriginGroups`](crate::model::OriginGroups)
        pub fn build(self) -> crate::model::OriginGroups {
            crate::model::OriginGroups {
                quantity: self.quantity,
                items: self.items,
            }
        }
    }
}
impl OriginGroups {
    /// Creates a new builder-style object to manufacture [`OriginGroups`](crate::model::OriginGroups)
    pub fn builder() -> crate::model::origin_groups::Builder {
        crate::model::origin_groups::Builder::default()
    }
}

/// <p>An origin group includes two origins (a primary origin and a second origin to failover to) and a failover criteria that you specify.
/// You create an origin group to support origin failover in CloudFront. When you create or update a distribution, you can specifiy
/// the origin group instead of a single origin, and CloudFront will failover from the primary origin to the second origin
/// under the failover conditions that you've chosen.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct OriginGroup {
    /// <p>The origin group's ID.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>A complex type that contains information about the failover criteria for an origin group.</p>
    pub failover_criteria: std::option::Option<crate::model::OriginGroupFailoverCriteria>,
    /// <p>A complex type that contains information about the origins in an origin group.</p>
    pub members: std::option::Option<crate::model::OriginGroupMembers>,
}
impl OriginGroup {
    /// <p>The origin group's ID.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>A complex type that contains information about the failover criteria for an origin group.</p>
    pub fn failover_criteria(
        &self,
    ) -> std::option::Option<&crate::model::OriginGroupFailoverCriteria> {
        self.failover_criteria.as_ref()
    }
    /// <p>A complex type that contains information about the origins in an origin group.</p>
    pub fn members(&self) -> std::option::Option<&crate::model::OriginGroupMembers> {
        self.members.as_ref()
    }
}
impl std::fmt::Debug for OriginGroup {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("OriginGroup");
        formatter.field("id", &self.id);
        formatter.field("failover_criteria", &self.failover_criteria);
        formatter.field("members", &self.members);
        formatter.finish()
    }
}
/// See [`OriginGroup`](crate::model::OriginGroup)
pub mod origin_group {
    /// A builder for [`OriginGroup`](crate::model::OriginGroup)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) failover_criteria:
            std::option::Option<crate::model::OriginGroupFailoverCriteria>,
        pub(crate) members: std::option::Option<crate::model::OriginGroupMembers>,
    }
    impl Builder {
        /// <p>The origin group's ID.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The origin group's ID.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>A complex type that contains information about the failover criteria for an origin group.</p>
        pub fn failover_criteria(
            mut self,
            input: crate::model::OriginGroupFailoverCriteria,
        ) -> Self {
            self.failover_criteria = Some(input);
            self
        }
        /// <p>A complex type that contains information about the failover criteria for an origin group.</p>
        pub fn set_failover_criteria(
            mut self,
            input: std::option::Option<crate::model::OriginGroupFailoverCriteria>,
        ) -> Self {
            self.failover_criteria = input;
            self
        }
        /// <p>A complex type that contains information about the origins in an origin group.</p>
        pub fn members(mut self, input: crate::model::OriginGroupMembers) -> Self {
            self.members = Some(input);
            self
        }
        /// <p>A complex type that contains information about the origins in an origin group.</p>
        pub fn set_members(
            mut self,
            input: std::option::Option<crate::model::OriginGroupMembers>,
        ) -> Self {
            self.members = input;
            self
        }
        /// Consumes the builder and constructs a [`OriginGroup`](crate::model::OriginGroup)
        pub fn build(self) -> crate::model::OriginGroup {
            crate::model::OriginGroup {
                id: self.id,
                failover_criteria: self.failover_criteria,
                members: self.members,
            }
        }
    }
}
impl OriginGroup {
    /// Creates a new builder-style object to manufacture [`OriginGroup`](crate::model::OriginGroup)
    pub fn builder() -> crate::model::origin_group::Builder {
        crate::model::origin_group::Builder::default()
    }
}

/// <p>A complex data type for the origins included in an origin group.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct OriginGroupMembers {
    /// <p>The number of origins in an origin group.</p>
    pub quantity: std::option::Option<i32>,
    /// <p>Items (origins) in an origin group.</p>
    pub items: std::option::Option<std::vec::Vec<crate::model::OriginGroupMember>>,
}
impl OriginGroupMembers {
    /// <p>The number of origins in an origin group.</p>
    pub fn quantity(&self) -> std::option::Option<i32> {
        self.quantity
    }
    /// <p>Items (origins) in an origin group.</p>
    pub fn items(&self) -> std::option::Option<&[crate::model::OriginGroupMember]> {
        self.items.as_deref()
    }
}
impl std::fmt::Debug for OriginGroupMembers {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("OriginGroupMembers");
        formatter.field("quantity", &self.quantity);
        formatter.field("items", &self.items);
        formatter.finish()
    }
}
/// See [`OriginGroupMembers`](crate::model::OriginGroupMembers)
pub mod origin_group_members {
    /// A builder for [`OriginGroupMembers`](crate::model::OriginGroupMembers)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) quantity: std::option::Option<i32>,
        pub(crate) items: std::option::Option<std::vec::Vec<crate::model::OriginGroupMember>>,
    }
    impl Builder {
        /// <p>The number of origins in an origin group.</p>
        pub fn quantity(mut self, input: i32) -> Self {
            self.quantity = Some(input);
            self
        }
        /// <p>The number of origins in an origin group.</p>
        pub fn set_quantity(mut self, input: std::option::Option<i32>) -> Self {
            self.quantity = input;
            self
        }
        /// Appends an item to `items`.
        ///
        /// To override the contents of this collection use [`set_items`](Self::set_items).
        ///
        /// <p>Items (origins) in an origin group.</p>
        pub fn items(mut self, input: impl Into<crate::model::OriginGroupMember>) -> Self {
            let mut v = self.items.unwrap_or_default();
            v.push(input.into());
            self.items = Some(v);
            self
        }
        /// <p>Items (origins) in an origin group.</p>
        pub fn set_items(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::OriginGroupMember>>,
        ) -> Self {
            self.items = input;
            self
        }
        /// Consumes the builder and constructs a [`OriginGroupMembers`](crate::model::OriginGroupMembers)
        pub fn build(self) -> crate::model::OriginGroupMembers {
            crate::model::OriginGroupMembers {
                quantity: self.quantity,
                items: self.items,
            }
        }
    }
}
impl OriginGroupMembers {
    /// Creates a new builder-style object to manufacture [`OriginGroupMembers`](crate::model::OriginGroupMembers)
    pub fn builder() -> crate::model::origin_group_members::Builder {
        crate::model::origin_group_members::Builder::default()
    }
}

/// <p>An origin in an origin group.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct OriginGroupMember {
    /// <p>The ID for an origin in an origin group.</p>
    pub origin_id: std::option::Option<std::string::String>,
}
impl OriginGroupMember {
    /// <p>The ID for an origin in an origin group.</p>
    pub fn origin_id(&self) -> std::option::Option<&str> {
        self.origin_id.as_deref()
    }
}
impl std::fmt::Debug for OriginGroupMember {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("OriginGroupMember");
        formatter.field("origin_id", &self.origin_id);
        formatter.finish()
    }
}
/// See [`OriginGroupMember`](crate::model::OriginGroupMember)
pub mod origin_group_member {
    /// A builder for [`OriginGroupMember`](crate::model::OriginGroupMember)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) origin_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID for an origin in an origin group.</p>
        pub fn origin_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.origin_id = Some(input.into());
            self
        }
        /// <p>The ID for an origin in an origin group.</p>
        pub fn set_origin_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.origin_id = input;
            self
        }
        /// Consumes the builder and constructs a [`OriginGroupMember`](crate::model::OriginGroupMember)
        pub fn build(self) -> crate::model::OriginGroupMember {
            crate::model::OriginGroupMember {
                origin_id: self.origin_id,
            }
        }
    }
}
impl OriginGroupMember {
    /// Creates a new builder-style object to manufacture [`OriginGroupMember`](crate::model::OriginGroupMember)
    pub fn builder() -> crate::model::origin_group_member::Builder {
        crate::model::origin_group_member::Builder::default()
    }
}

/// <p>A complex data type that includes information about the failover criteria for an origin group, including
/// the status codes for which CloudFront will failover from the primary origin to the second origin.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct OriginGroupFailoverCriteria {
    /// <p>The status codes that, when returned from the primary origin, will trigger CloudFront to failover
    /// to the second origin.</p>
    pub status_codes: std::option::Option<crate::model::StatusCodes>,
}
impl OriginGroupFailoverCriteria {
    /// <p>The status codes that, when returned from the primary origin, will trigger CloudFront to failover
    /// to the second origin.</p>
    pub fn status_codes(&self) -> std::option::Option<&crate::model::StatusCodes> {
        self.status_codes.as_ref()
    }
}
impl std::fmt::Debug for OriginGroupFailoverCriteria {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("OriginGroupFailoverCriteria");
        formatter.field("status_codes", &self.status_codes);
        formatter.finish()
    }
}
/// See [`OriginGroupFailoverCriteria`](crate::model::OriginGroupFailoverCriteria)
pub mod origin_group_failover_criteria {
    /// A builder for [`OriginGroupFailoverCriteria`](crate::model::OriginGroupFailoverCriteria)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) status_codes: std::option::Option<crate::model::StatusCodes>,
    }
    impl Builder {
        /// <p>The status codes that, when returned from the primary origin, will trigger CloudFront to failover
        /// to the second origin.</p>
        pub fn status_codes(mut self, input: crate::model::StatusCodes) -> Self {
            self.status_codes = Some(input);
            self
        }
        /// <p>The status codes that, when returned from the primary origin, will trigger CloudFront to failover
        /// to the second origin.</p>
        pub fn set_status_codes(
            mut self,
            input: std::option::Option<crate::model::StatusCodes>,
        ) -> Self {
            self.status_codes = input;
            self
        }
        /// Consumes the builder and constructs a [`OriginGroupFailoverCriteria`](crate::model::OriginGroupFailoverCriteria)
        pub fn build(self) -> crate::model::OriginGroupFailoverCriteria {
            crate::model::OriginGroupFailoverCriteria {
                status_codes: self.status_codes,
            }
        }
    }
}
impl OriginGroupFailoverCriteria {
    /// Creates a new builder-style object to manufacture [`OriginGroupFailoverCriteria`](crate::model::OriginGroupFailoverCriteria)
    pub fn builder() -> crate::model::origin_group_failover_criteria::Builder {
        crate::model::origin_group_failover_criteria::Builder::default()
    }
}

/// <p>A complex data type for the status codes that you specify that, when returned by a primary origin, trigger
/// CloudFront to failover to a second origin.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StatusCodes {
    /// <p>The number of status codes.</p>
    pub quantity: std::option::Option<i32>,
    /// <p>The items (status codes) for an origin group.</p>
    pub items: std::option::Option<std::vec::Vec<i32>>,
}
impl StatusCodes {
    /// <p>The number of status codes.</p>
    pub fn quantity(&self) -> std::option::Option<i32> {
        self.quantity
    }
    /// <p>The items (status codes) for an origin group.</p>
    pub fn items(&self) -> std::option::Option<&[i32]> {
        self.items.as_deref()
    }
}
impl std::fmt::Debug for StatusCodes {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StatusCodes");
        formatter.field("quantity", &self.quantity);
        formatter.field("items", &self.items);
        formatter.finish()
    }
}
/// See [`StatusCodes`](crate::model::StatusCodes)
pub mod status_codes {
    /// A builder for [`StatusCodes`](crate::model::StatusCodes)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) quantity: std::option::Option<i32>,
        pub(crate) items: std::option::Option<std::vec::Vec<i32>>,
    }
    impl Builder {
        /// <p>The number of status codes.</p>
        pub fn quantity(mut self, input: i32) -> Self {
            self.quantity = Some(input);
            self
        }
        /// <p>The number of status codes.</p>
        pub fn set_quantity(mut self, input: std::option::Option<i32>) -> Self {
            self.quantity = input;
            self
        }
        /// Appends an item to `items`.
        ///
        /// To override the contents of this collection use [`set_items`](Self::set_items).
        ///
        /// <p>The items (status codes) for an origin group.</p>
        pub fn items(mut self, input: impl Into<i32>) -> Self {
            let mut v = self.items.unwrap_or_default();
            v.push(input.into());
            self.items = Some(v);
            self
        }
        /// <p>The items (status codes) for an origin group.</p>
        pub fn set_items(mut self, input: std::option::Option<std::vec::Vec<i32>>) -> Self {
            self.items = input;
            self
        }
        /// Consumes the builder and constructs a [`StatusCodes`](crate::model::StatusCodes)
        pub fn build(self) -> crate::model::StatusCodes {
            crate::model::StatusCodes {
                quantity: self.quantity,
                items: self.items,
            }
        }
    }
}
impl StatusCodes {
    /// Creates a new builder-style object to manufacture [`StatusCodes`](crate::model::StatusCodes)
    pub fn builder() -> crate::model::status_codes::Builder {
        crate::model::status_codes::Builder::default()
    }
}

/// <p>Contains information about the origins for this distribution.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Origins {
    /// <p>The number of origins for this distribution.</p>
    pub quantity: std::option::Option<i32>,
    /// <p>A list of origins.</p>
    pub items: std::option::Option<std::vec::Vec<crate::model::Origin>>,
}
impl Origins {
    /// <p>The number of origins for this distribution.</p>
    pub fn quantity(&self) -> std::option::Option<i32> {
        self.quantity
    }
    /// <p>A list of origins.</p>
    pub fn items(&self) -> std::option::Option<&[crate::model::Origin]> {
        self.items.as_deref()
    }
}
impl std::fmt::Debug for Origins {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Origins");
        formatter.field("quantity", &self.quantity);
        formatter.field("items", &self.items);
        formatter.finish()
    }
}
/// See [`Origins`](crate::model::Origins)
pub mod origins {
    /// A builder for [`Origins`](crate::model::Origins)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) quantity: std::option::Option<i32>,
        pub(crate) items: std::option::Option<std::vec::Vec<crate::model::Origin>>,
    }
    impl Builder {
        /// <p>The number of origins for this distribution.</p>
        pub fn quantity(mut self, input: i32) -> Self {
            self.quantity = Some(input);
            self
        }
        /// <p>The number of origins for this distribution.</p>
        pub fn set_quantity(mut self, input: std::option::Option<i32>) -> Self {
            self.quantity = input;
            self
        }
        /// Appends an item to `items`.
        ///
        /// To override the contents of this collection use [`set_items`](Self::set_items).
        ///
        /// <p>A list of origins.</p>
        pub fn items(mut self, input: impl Into<crate::model::Origin>) -> Self {
            let mut v = self.items.unwrap_or_default();
            v.push(input.into());
            self.items = Some(v);
            self
        }
        /// <p>A list of origins.</p>
        pub fn set_items(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Origin>>,
        ) -> Self {
            self.items = input;
            self
        }
        /// Consumes the builder and constructs a [`Origins`](crate::model::Origins)
        pub fn build(self) -> crate::model::Origins {
            crate::model::Origins {
                quantity: self.quantity,
                items: self.items,
            }
        }
    }
}
impl Origins {
    /// Creates a new builder-style object to manufacture [`Origins`](crate::model::Origins)
    pub fn builder() -> crate::model::origins::Builder {
        crate::model::origins::Builder::default()
    }
}

/// <p>An origin.</p>
/// <p>An origin is the location where content is stored, and from which CloudFront gets content to
/// serve to viewers. To specify an origin:</p>
/// <ul>
/// <li>
/// <p>Use <code>S3OriginConfig</code> to specify an Amazon S3 bucket that is not
/// configured with static website hosting.</p>
/// </li>
/// <li>
/// <p>Use <code>CustomOriginConfig</code> to specify all other kinds of origins,
/// including:</p>
/// <ul>
/// <li>
/// <p>An Amazon S3 bucket that is configured with static website hosting</p>
/// </li>
/// <li>
/// <p>An Elastic Load Balancing load balancer</p>
/// </li>
/// <li>
/// <p>An AWS Elemental MediaPackage endpoint</p>
/// </li>
/// <li>
/// <p>An AWS Elemental MediaStore container</p>
/// </li>
/// <li>
/// <p>Any other HTTP server, running on an Amazon EC2 instance or any other
/// kind of host</p>
/// </li>
/// </ul>
/// </li>
/// </ul>
/// <p>For the current maximum number of origins that you can specify per distribution, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html#limits-web-distributions">General Quotas on Web Distributions</a> in the <i>Amazon CloudFront Developer Guide</i>
/// (quotas were formerly referred to as limits).</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Origin {
    /// <p>A unique identifier for the origin. This value must be unique within the
    /// distribution.</p>
    /// <p>Use this value to specify the <code>TargetOriginId</code> in a
    /// <code>CacheBehavior</code> or <code>DefaultCacheBehavior</code>.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The domain name for the origin.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-web-values-specify.html#DownloadDistValuesDomainName">Origin Domain Name</a> in the <i>Amazon CloudFront Developer Guide</i>.</p>
    pub domain_name: std::option::Option<std::string::String>,
    /// <p>An optional path that CloudFront appends to the origin domain name when CloudFront requests content from
    /// the origin.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-web-values-specify.html#DownloadDistValuesOriginPath">Origin Path</a> in the
    /// <i>Amazon CloudFront Developer Guide</i>.</p>
    pub origin_path: std::option::Option<std::string::String>,
    /// <p>A list of HTTP header names and values that CloudFront adds to the requests that it sends to
    /// the origin.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/add-origin-custom-headers.html">Adding Custom Headers to Origin Requests</a> in the
    /// <i>Amazon CloudFront Developer Guide</i>.</p>
    pub custom_headers: std::option::Option<crate::model::CustomHeaders>,
    /// <p>Use this type to specify an origin that is an Amazon S3 bucket that is not configured with static
    /// website hosting. To specify any other type of origin, including an Amazon S3 bucket that is
    /// configured with static website hosting, use the <code>CustomOriginConfig</code> type
    /// instead.</p>
    pub s3_origin_config: std::option::Option<crate::model::S3OriginConfig>,
    /// <p>Use this type to specify an origin that is not an Amazon S3 bucket, with one exception. If the
    /// Amazon S3 bucket is configured with static website hosting, use this type. If the Amazon S3 bucket
    /// is not configured with static website hosting, use the <code>S3OriginConfig</code> type
    /// instead.</p>
    pub custom_origin_config: std::option::Option<crate::model::CustomOriginConfig>,
    /// <p>The number of times that CloudFront attempts to connect to the origin. The minimum number
    /// is 1, the maximum is 3, and the default (if you don’t specify otherwise) is 3.</p>
    /// <p>For a custom origin (including an Amazon S3 bucket that’s configured with static
    /// website hosting), this value also specifies the number of times that CloudFront attempts to
    /// get a response from the origin, in the case of an <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-web-values-specify.html#DownloadDistValuesOriginResponseTimeout">Origin Response Timeout</a>.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-web-values-specify.html#origin-connection-attempts">Origin Connection Attempts</a> in the
    /// <i>Amazon CloudFront Developer Guide</i>.</p>
    pub connection_attempts: std::option::Option<i32>,
    /// <p>The number of seconds that CloudFront waits when trying to establish a connection to the origin.
    /// The minimum timeout is 1 second, the maximum is 10 seconds, and the default (if you
    /// don’t specify otherwise) is 10 seconds.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-web-values-specify.html#origin-connection-timeout">Origin Connection Timeout</a> in the
    /// <i>Amazon CloudFront Developer Guide</i>.</p>
    pub connection_timeout: std::option::Option<i32>,
    /// <p>CloudFront Origin Shield. Using Origin Shield can help reduce the load on your
    /// origin.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/origin-shield.html">Using Origin Shield</a> in the <i>Amazon CloudFront Developer Guide</i>.</p>
    pub origin_shield: std::option::Option<crate::model::OriginShield>,
}
impl Origin {
    /// <p>A unique identifier for the origin. This value must be unique within the
    /// distribution.</p>
    /// <p>Use this value to specify the <code>TargetOriginId</code> in a
    /// <code>CacheBehavior</code> or <code>DefaultCacheBehavior</code>.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The domain name for the origin.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-web-values-specify.html#DownloadDistValuesDomainName">Origin Domain Name</a> in the <i>Amazon CloudFront Developer Guide</i>.</p>
    pub fn domain_name(&self) -> std::option::Option<&str> {
        self.domain_name.as_deref()
    }
    /// <p>An optional path that CloudFront appends to the origin domain name when CloudFront requests content from
    /// the origin.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-web-values-specify.html#DownloadDistValuesOriginPath">Origin Path</a> in the
    /// <i>Amazon CloudFront Developer Guide</i>.</p>
    pub fn origin_path(&self) -> std::option::Option<&str> {
        self.origin_path.as_deref()
    }
    /// <p>A list of HTTP header names and values that CloudFront adds to the requests that it sends to
    /// the origin.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/add-origin-custom-headers.html">Adding Custom Headers to Origin Requests</a> in the
    /// <i>Amazon CloudFront Developer Guide</i>.</p>
    pub fn custom_headers(&self) -> std::option::Option<&crate::model::CustomHeaders> {
        self.custom_headers.as_ref()
    }
    /// <p>Use this type to specify an origin that is an Amazon S3 bucket that is not configured with static
    /// website hosting. To specify any other type of origin, including an Amazon S3 bucket that is
    /// configured with static website hosting, use the <code>CustomOriginConfig</code> type
    /// instead.</p>
    pub fn s3_origin_config(&self) -> std::option::Option<&crate::model::S3OriginConfig> {
        self.s3_origin_config.as_ref()
    }
    /// <p>Use this type to specify an origin that is not an Amazon S3 bucket, with one exception. If the
    /// Amazon S3 bucket is configured with static website hosting, use this type. If the Amazon S3 bucket
    /// is not configured with static website hosting, use the <code>S3OriginConfig</code> type
    /// instead.</p>
    pub fn custom_origin_config(&self) -> std::option::Option<&crate::model::CustomOriginConfig> {
        self.custom_origin_config.as_ref()
    }
    /// <p>The number of times that CloudFront attempts to connect to the origin. The minimum number
    /// is 1, the maximum is 3, and the default (if you don’t specify otherwise) is 3.</p>
    /// <p>For a custom origin (including an Amazon S3 bucket that’s configured with static
    /// website hosting), this value also specifies the number of times that CloudFront attempts to
    /// get a response from the origin, in the case of an <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-web-values-specify.html#DownloadDistValuesOriginResponseTimeout">Origin Response Timeout</a>.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-web-values-specify.html#origin-connection-attempts">Origin Connection Attempts</a> in the
    /// <i>Amazon CloudFront Developer Guide</i>.</p>
    pub fn connection_attempts(&self) -> std::option::Option<i32> {
        self.connection_attempts
    }
    /// <p>The number of seconds that CloudFront waits when trying to establish a connection to the origin.
    /// The minimum timeout is 1 second, the maximum is 10 seconds, and the default (if you
    /// don’t specify otherwise) is 10 seconds.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-web-values-specify.html#origin-connection-timeout">Origin Connection Timeout</a> in the
    /// <i>Amazon CloudFront Developer Guide</i>.</p>
    pub fn connection_timeout(&self) -> std::option::Option<i32> {
        self.connection_timeout
    }
    /// <p>CloudFront Origin Shield. Using Origin Shield can help reduce the load on your
    /// origin.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/origin-shield.html">Using Origin Shield</a> in the <i>Amazon CloudFront Developer Guide</i>.</p>
    pub fn origin_shield(&self) -> std::option::Option<&crate::model::OriginShield> {
        self.origin_shield.as_ref()
    }
}
impl std::fmt::Debug for Origin {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Origin");
        formatter.field("id", &self.id);
        formatter.field("domain_name", &self.domain_name);
        formatter.field("origin_path", &self.origin_path);
        formatter.field("custom_headers", &self.custom_headers);
        formatter.field("s3_origin_config", &self.s3_origin_config);
        formatter.field("custom_origin_config", &self.custom_origin_config);
        formatter.field("connection_attempts", &self.connection_attempts);
        formatter.field("connection_timeout", &self.connection_timeout);
        formatter.field("origin_shield", &self.origin_shield);
        formatter.finish()
    }
}
/// See [`Origin`](crate::model::Origin)
pub mod origin {
    /// A builder for [`Origin`](crate::model::Origin)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) domain_name: std::option::Option<std::string::String>,
        pub(crate) origin_path: std::option::Option<std::string::String>,
        pub(crate) custom_headers: std::option::Option<crate::model::CustomHeaders>,
        pub(crate) s3_origin_config: std::option::Option<crate::model::S3OriginConfig>,
        pub(crate) custom_origin_config: std::option::Option<crate::model::CustomOriginConfig>,
        pub(crate) connection_attempts: std::option::Option<i32>,
        pub(crate) connection_timeout: std::option::Option<i32>,
        pub(crate) origin_shield: std::option::Option<crate::model::OriginShield>,
    }
    impl Builder {
        /// <p>A unique identifier for the origin. This value must be unique within the
        /// distribution.</p>
        /// <p>Use this value to specify the <code>TargetOriginId</code> in a
        /// <code>CacheBehavior</code> or <code>DefaultCacheBehavior</code>.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>A unique identifier for the origin. This value must be unique within the
        /// distribution.</p>
        /// <p>Use this value to specify the <code>TargetOriginId</code> in a
        /// <code>CacheBehavior</code> or <code>DefaultCacheBehavior</code>.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The domain name for the origin.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-web-values-specify.html#DownloadDistValuesDomainName">Origin Domain Name</a> in the <i>Amazon CloudFront Developer Guide</i>.</p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain_name = Some(input.into());
            self
        }
        /// <p>The domain name for the origin.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-web-values-specify.html#DownloadDistValuesDomainName">Origin Domain Name</a> in the <i>Amazon CloudFront Developer Guide</i>.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain_name = input;
            self
        }
        /// <p>An optional path that CloudFront appends to the origin domain name when CloudFront requests content from
        /// the origin.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-web-values-specify.html#DownloadDistValuesOriginPath">Origin Path</a> in the
        /// <i>Amazon CloudFront Developer Guide</i>.</p>
        pub fn origin_path(mut self, input: impl Into<std::string::String>) -> Self {
            self.origin_path = Some(input.into());
            self
        }
        /// <p>An optional path that CloudFront appends to the origin domain name when CloudFront requests content from
        /// the origin.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-web-values-specify.html#DownloadDistValuesOriginPath">Origin Path</a> in the
        /// <i>Amazon CloudFront Developer Guide</i>.</p>
        pub fn set_origin_path(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.origin_path = input;
            self
        }
        /// <p>A list of HTTP header names and values that CloudFront adds to the requests that it sends to
        /// the origin.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/add-origin-custom-headers.html">Adding Custom Headers to Origin Requests</a> in the
        /// <i>Amazon CloudFront Developer Guide</i>.</p>
        pub fn custom_headers(mut self, input: crate::model::CustomHeaders) -> Self {
            self.custom_headers = Some(input);
            self
        }
        /// <p>A list of HTTP header names and values that CloudFront adds to the requests that it sends to
        /// the origin.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/add-origin-custom-headers.html">Adding Custom Headers to Origin Requests</a> in the
        /// <i>Amazon CloudFront Developer Guide</i>.</p>
        pub fn set_custom_headers(
            mut self,
            input: std::option::Option<crate::model::CustomHeaders>,
        ) -> Self {
            self.custom_headers = input;
            self
        }
        /// <p>Use this type to specify an origin that is an Amazon S3 bucket that is not configured with static
        /// website hosting. To specify any other type of origin, including an Amazon S3 bucket that is
        /// configured with static website hosting, use the <code>CustomOriginConfig</code> type
        /// instead.</p>
        pub fn s3_origin_config(mut self, input: crate::model::S3OriginConfig) -> Self {
            self.s3_origin_config = Some(input);
            self
        }
        /// <p>Use this type to specify an origin that is an Amazon S3 bucket that is not configured with static
        /// website hosting. To specify any other type of origin, including an Amazon S3 bucket that is
        /// configured with static website hosting, use the <code>CustomOriginConfig</code> type
        /// instead.</p>
        pub fn set_s3_origin_config(
            mut self,
            input: std::option::Option<crate::model::S3OriginConfig>,
        ) -> Self {
            self.s3_origin_config = input;
            self
        }
        /// <p>Use this type to specify an origin that is not an Amazon S3 bucket, with one exception. If the
        /// Amazon S3 bucket is configured with static website hosting, use this type. If the Amazon S3 bucket
        /// is not configured with static website hosting, use the <code>S3OriginConfig</code> type
        /// instead.</p>
        pub fn custom_origin_config(mut self, input: crate::model::CustomOriginConfig) -> Self {
            self.custom_origin_config = Some(input);
            self
        }
        /// <p>Use this type to specify an origin that is not an Amazon S3 bucket, with one exception. If the
        /// Amazon S3 bucket is configured with static website hosting, use this type. If the Amazon S3 bucket
        /// is not configured with static website hosting, use the <code>S3OriginConfig</code> type
        /// instead.</p>
        pub fn set_custom_origin_config(
            mut self,
            input: std::option::Option<crate::model::CustomOriginConfig>,
        ) -> Self {
            self.custom_origin_config = input;
            self
        }
        /// <p>The number of times that CloudFront attempts to connect to the origin. The minimum number
        /// is 1, the maximum is 3, and the default (if you don’t specify otherwise) is 3.</p>
        /// <p>For a custom origin (including an Amazon S3 bucket that’s configured with static
        /// website hosting), this value also specifies the number of times that CloudFront attempts to
        /// get a response from the origin, in the case of an <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-web-values-specify.html#DownloadDistValuesOriginResponseTimeout">Origin Response Timeout</a>.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-web-values-specify.html#origin-connection-attempts">Origin Connection Attempts</a> in the
        /// <i>Amazon CloudFront Developer Guide</i>.</p>
        pub fn connection_attempts(mut self, input: i32) -> Self {
            self.connection_attempts = Some(input);
            self
        }
        /// <p>The number of times that CloudFront attempts to connect to the origin. The minimum number
        /// is 1, the maximum is 3, and the default (if you don’t specify otherwise) is 3.</p>
        /// <p>For a custom origin (including an Amazon S3 bucket that’s configured with static
        /// website hosting), this value also specifies the number of times that CloudFront attempts to
        /// get a response from the origin, in the case of an <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-web-values-specify.html#DownloadDistValuesOriginResponseTimeout">Origin Response Timeout</a>.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-web-values-specify.html#origin-connection-attempts">Origin Connection Attempts</a> in the
        /// <i>Amazon CloudFront Developer Guide</i>.</p>
        pub fn set_connection_attempts(mut self, input: std::option::Option<i32>) -> Self {
            self.connection_attempts = input;
            self
        }
        /// <p>The number of seconds that CloudFront waits when trying to establish a connection to the origin.
        /// The minimum timeout is 1 second, the maximum is 10 seconds, and the default (if you
        /// don’t specify otherwise) is 10 seconds.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-web-values-specify.html#origin-connection-timeout">Origin Connection Timeout</a> in the
        /// <i>Amazon CloudFront Developer Guide</i>.</p>
        pub fn connection_timeout(mut self, input: i32) -> Self {
            self.connection_timeout = Some(input);
            self
        }
        /// <p>The number of seconds that CloudFront waits when trying to establish a connection to the origin.
        /// The minimum timeout is 1 second, the maximum is 10 seconds, and the default (if you
        /// don’t specify otherwise) is 10 seconds.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-web-values-specify.html#origin-connection-timeout">Origin Connection Timeout</a> in the
        /// <i>Amazon CloudFront Developer Guide</i>.</p>
        pub fn set_connection_timeout(mut self, input: std::option::Option<i32>) -> Self {
            self.connection_timeout = input;
            self
        }
        /// <p>CloudFront Origin Shield. Using Origin Shield can help reduce the load on your
        /// origin.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/origin-shield.html">Using Origin Shield</a> in the <i>Amazon CloudFront Developer Guide</i>.</p>
        pub fn origin_shield(mut self, input: crate::model::OriginShield) -> Self {
            self.origin_shield = Some(input);
            self
        }
        /// <p>CloudFront Origin Shield. Using Origin Shield can help reduce the load on your
        /// origin.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/origin-shield.html">Using Origin Shield</a> in the <i>Amazon CloudFront Developer Guide</i>.</p>
        pub fn set_origin_shield(
            mut self,
            input: std::option::Option<crate::model::OriginShield>,
        ) -> Self {
            self.origin_shield = input;
            self
        }
        /// Consumes the builder and constructs a [`Origin`](crate::model::Origin)
        pub fn build(self) -> crate::model::Origin {
            crate::model::Origin {
                id: self.id,
                domain_name: self.domain_name,
                origin_path: self.origin_path,
                custom_headers: self.custom_headers,
                s3_origin_config: self.s3_origin_config,
                custom_origin_config: self.custom_origin_config,
                connection_attempts: self.connection_attempts,
                connection_timeout: self.connection_timeout,
                origin_shield: self.origin_shield,
            }
        }
    }
}
impl Origin {
    /// Creates a new builder-style object to manufacture [`Origin`](crate::model::Origin)
    pub fn builder() -> crate::model::origin::Builder {
        crate::model::origin::Builder::default()
    }
}

/// <p>CloudFront Origin Shield.</p>
/// <p>Using Origin Shield can help reduce the load on your origin. For more
/// information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/origin-shield.html">Using Origin Shield</a> in the <i>Amazon CloudFront Developer Guide</i>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct OriginShield {
    /// <p>A flag that specifies whether Origin Shield is enabled.</p>
    /// <p>When it’s enabled, CloudFront routes all requests through Origin Shield, which can
    /// help protect your origin. When it’s disabled, CloudFront might send requests directly to
    /// your origin from multiple edge locations or regional edge caches.</p>
    pub enabled: std::option::Option<bool>,
    /// <p>The Amazon Web Services Region for Origin Shield.</p>
    /// <p>Specify the Amazon Web Services Region that has the lowest latency to your origin.
    /// To specify a region, use the region code, not the region name.
    /// For example, specify the US East (Ohio) region as <code>us-east-2</code>.</p>
    /// <p>When you enable CloudFront Origin Shield, you must specify the Amazon Web Services Region for Origin
    /// Shield. For the list of Amazon Web Services Regions that you can specify, and for help choosing the best
    /// Region for your origin, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/origin-shield.html#choose-origin-shield-region">Choosing the Amazon Web Services Region for Origin Shield</a> in the
    /// <i>Amazon CloudFront Developer Guide</i>.</p>
    pub origin_shield_region: std::option::Option<std::string::String>,
}
impl OriginShield {
    /// <p>A flag that specifies whether Origin Shield is enabled.</p>
    /// <p>When it’s enabled, CloudFront routes all requests through Origin Shield, which can
    /// help protect your origin. When it’s disabled, CloudFront might send requests directly to
    /// your origin from multiple edge locations or regional edge caches.</p>
    pub fn enabled(&self) -> std::option::Option<bool> {
        self.enabled
    }
    /// <p>The Amazon Web Services Region for Origin Shield.</p>
    /// <p>Specify the Amazon Web Services Region that has the lowest latency to your origin.
    /// To specify a region, use the region code, not the region name.
    /// For example, specify the US East (Ohio) region as <code>us-east-2</code>.</p>
    /// <p>When you enable CloudFront Origin Shield, you must specify the Amazon Web Services Region for Origin
    /// Shield. For the list of Amazon Web Services Regions that you can specify, and for help choosing the best
    /// Region for your origin, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/origin-shield.html#choose-origin-shield-region">Choosing the Amazon Web Services Region for Origin Shield</a> in the
    /// <i>Amazon CloudFront Developer Guide</i>.</p>
    pub fn origin_shield_region(&self) -> std::option::Option<&str> {
        self.origin_shield_region.as_deref()
    }
}
impl std::fmt::Debug for OriginShield {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("OriginShield");
        formatter.field("enabled", &self.enabled);
        formatter.field("origin_shield_region", &self.origin_shield_region);
        formatter.finish()
    }
}
/// See [`OriginShield`](crate::model::OriginShield)
pub mod origin_shield {
    /// A builder for [`OriginShield`](crate::model::OriginShield)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) enabled: std::option::Option<bool>,
        pub(crate) origin_shield_region: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A flag that specifies whether Origin Shield is enabled.</p>
        /// <p>When it’s enabled, CloudFront routes all requests through Origin Shield, which can
        /// help protect your origin. When it’s disabled, CloudFront might send requests directly to
        /// your origin from multiple edge locations or regional edge caches.</p>
        pub fn enabled(mut self, input: bool) -> Self {
            self.enabled = Some(input);
            self
        }
        /// <p>A flag that specifies whether Origin Shield is enabled.</p>
        /// <p>When it’s enabled, CloudFront routes all requests through Origin Shield, which can
        /// help protect your origin. When it’s disabled, CloudFront might send requests directly to
        /// your origin from multiple edge locations or regional edge caches.</p>
        pub fn set_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.enabled = input;
            self
        }
        /// <p>The Amazon Web Services Region for Origin Shield.</p>
        /// <p>Specify the Amazon Web Services Region that has the lowest latency to your origin.
        /// To specify a region, use the region code, not the region name.
        /// For example, specify the US East (Ohio) region as <code>us-east-2</code>.</p>
        /// <p>When you enable CloudFront Origin Shield, you must specify the Amazon Web Services Region for Origin
        /// Shield. For the list of Amazon Web Services Regions that you can specify, and for help choosing the best
        /// Region for your origin, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/origin-shield.html#choose-origin-shield-region">Choosing the Amazon Web Services Region for Origin Shield</a> in the
        /// <i>Amazon CloudFront Developer Guide</i>.</p>
        pub fn origin_shield_region(mut self, input: impl Into<std::string::String>) -> Self {
            self.origin_shield_region = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services Region for Origin Shield.</p>
        /// <p>Specify the Amazon Web Services Region that has the lowest latency to your origin.
        /// To specify a region, use the region code, not the region name.
        /// For example, specify the US East (Ohio) region as <code>us-east-2</code>.</p>
        /// <p>When you enable CloudFront Origin Shield, you must specify the Amazon Web Services Region for Origin
        /// Shield. For the list of Amazon Web Services Regions that you can specify, and for help choosing the best
        /// Region for your origin, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/origin-shield.html#choose-origin-shield-region">Choosing the Amazon Web Services Region for Origin Shield</a> in the
        /// <i>Amazon CloudFront Developer Guide</i>.</p>
        pub fn set_origin_shield_region(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.origin_shield_region = input;
            self
        }
        /// Consumes the builder and constructs a [`OriginShield`](crate::model::OriginShield)
        pub fn build(self) -> crate::model::OriginShield {
            crate::model::OriginShield {
                enabled: self.enabled,
                origin_shield_region: self.origin_shield_region,
            }
        }
    }
}
impl OriginShield {
    /// Creates a new builder-style object to manufacture [`OriginShield`](crate::model::OriginShield)
    pub fn builder() -> crate::model::origin_shield::Builder {
        crate::model::origin_shield::Builder::default()
    }
}

/// <p>A custom origin. A custom origin is any origin that is <i>not</i> an Amazon S3
/// bucket, with one exception. An Amazon S3 bucket that is <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/WebsiteHosting.html">configured with
/// static website hosting</a>
/// <i>is</i> a custom origin.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CustomOriginConfig {
    /// <p>The HTTP port that CloudFront uses to connect to the origin. Specify the HTTP port that the origin
    /// listens on.</p>
    pub http_port: std::option::Option<i32>,
    /// <p>The HTTPS port that CloudFront uses to connect to the origin. Specify the HTTPS port that the
    /// origin listens on.</p>
    pub https_port: std::option::Option<i32>,
    /// <p>Specifies the protocol (HTTP or HTTPS) that CloudFront uses to connect to the origin. Valid values
    /// are:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>http-only</code> – CloudFront always uses HTTP to connect to the
    /// origin.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>match-viewer</code> – CloudFront connects to the origin using the same
    /// protocol that the viewer used to connect to CloudFront.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>https-only</code> – CloudFront always uses HTTPS to connect to the
    /// origin.</p>
    /// </li>
    /// </ul>
    pub origin_protocol_policy: std::option::Option<crate::model::OriginProtocolPolicy>,
    /// <p>Specifies the minimum SSL/TLS protocol that CloudFront uses when connecting to your origin over
    /// HTTPS. Valid values include <code>SSLv3</code>, <code>TLSv1</code>,
    /// <code>TLSv1.1</code>, and <code>TLSv1.2</code>.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-web-values-specify.html#DownloadDistValuesOriginSSLProtocols">Minimum Origin SSL Protocol</a> in the
    /// <i>Amazon CloudFront Developer Guide</i>.</p>
    pub origin_ssl_protocols: std::option::Option<crate::model::OriginSslProtocols>,
    /// <p>Specifies how long, in seconds, CloudFront waits for a response from the origin. This is also
    /// known as the <i>origin response timeout</i>. The minimum timeout is 1
    /// second, the maximum is 60 seconds, and the default (if you don’t specify otherwise) is
    /// 30 seconds.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-web-values-specify.html#DownloadDistValuesOriginResponseTimeout">Origin Response Timeout</a> in the
    /// <i>Amazon CloudFront Developer Guide</i>.</p>
    pub origin_read_timeout: std::option::Option<i32>,
    /// <p>Specifies how long, in seconds, CloudFront persists its connection to the origin. The minimum
    /// timeout is 1 second, the maximum is 60 seconds, and the default (if you don’t specify
    /// otherwise) is 5 seconds.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-web-values-specify.html#DownloadDistValuesOriginKeepaliveTimeout">Origin Keep-alive Timeout</a> in the
    /// <i>Amazon CloudFront Developer Guide</i>.</p>
    pub origin_keepalive_timeout: std::option::Option<i32>,
}
impl CustomOriginConfig {
    /// <p>The HTTP port that CloudFront uses to connect to the origin. Specify the HTTP port that the origin
    /// listens on.</p>
    pub fn http_port(&self) -> std::option::Option<i32> {
        self.http_port
    }
    /// <p>The HTTPS port that CloudFront uses to connect to the origin. Specify the HTTPS port that the
    /// origin listens on.</p>
    pub fn https_port(&self) -> std::option::Option<i32> {
        self.https_port
    }
    /// <p>Specifies the protocol (HTTP or HTTPS) that CloudFront uses to connect to the origin. Valid values
    /// are:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>http-only</code> – CloudFront always uses HTTP to connect to the
    /// origin.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>match-viewer</code> – CloudFront connects to the origin using the same
    /// protocol that the viewer used to connect to CloudFront.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>https-only</code> – CloudFront always uses HTTPS to connect to the
    /// origin.</p>
    /// </li>
    /// </ul>
    pub fn origin_protocol_policy(
        &self,
    ) -> std::option::Option<&crate::model::OriginProtocolPolicy> {
        self.origin_protocol_policy.as_ref()
    }
    /// <p>Specifies the minimum SSL/TLS protocol that CloudFront uses when connecting to your origin over
    /// HTTPS. Valid values include <code>SSLv3</code>, <code>TLSv1</code>,
    /// <code>TLSv1.1</code>, and <code>TLSv1.2</code>.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-web-values-specify.html#DownloadDistValuesOriginSSLProtocols">Minimum Origin SSL Protocol</a> in the
    /// <i>Amazon CloudFront Developer Guide</i>.</p>
    pub fn origin_ssl_protocols(&self) -> std::option::Option<&crate::model::OriginSslProtocols> {
        self.origin_ssl_protocols.as_ref()
    }
    /// <p>Specifies how long, in seconds, CloudFront waits for a response from the origin. This is also
    /// known as the <i>origin response timeout</i>. The minimum timeout is 1
    /// second, the maximum is 60 seconds, and the default (if you don’t specify otherwise) is
    /// 30 seconds.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-web-values-specify.html#DownloadDistValuesOriginResponseTimeout">Origin Response Timeout</a> in the
    /// <i>Amazon CloudFront Developer Guide</i>.</p>
    pub fn origin_read_timeout(&self) -> std::option::Option<i32> {
        self.origin_read_timeout
    }
    /// <p>Specifies how long, in seconds, CloudFront persists its connection to the origin. The minimum
    /// timeout is 1 second, the maximum is 60 seconds, and the default (if you don’t specify
    /// otherwise) is 5 seconds.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-web-values-specify.html#DownloadDistValuesOriginKeepaliveTimeout">Origin Keep-alive Timeout</a> in the
    /// <i>Amazon CloudFront Developer Guide</i>.</p>
    pub fn origin_keepalive_timeout(&self) -> std::option::Option<i32> {
        self.origin_keepalive_timeout
    }
}
impl std::fmt::Debug for CustomOriginConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CustomOriginConfig");
        formatter.field("http_port", &self.http_port);
        formatter.field("https_port", &self.https_port);
        formatter.field("origin_protocol_policy", &self.origin_protocol_policy);
        formatter.field("origin_ssl_protocols", &self.origin_ssl_protocols);
        formatter.field("origin_read_timeout", &self.origin_read_timeout);
        formatter.field("origin_keepalive_timeout", &self.origin_keepalive_timeout);
        formatter.finish()
    }
}
/// See [`CustomOriginConfig`](crate::model::CustomOriginConfig)
pub mod custom_origin_config {
    /// A builder for [`CustomOriginConfig`](crate::model::CustomOriginConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) http_port: std::option::Option<i32>,
        pub(crate) https_port: std::option::Option<i32>,
        pub(crate) origin_protocol_policy: std::option::Option<crate::model::OriginProtocolPolicy>,
        pub(crate) origin_ssl_protocols: std::option::Option<crate::model::OriginSslProtocols>,
        pub(crate) origin_read_timeout: std::option::Option<i32>,
        pub(crate) origin_keepalive_timeout: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The HTTP port that CloudFront uses to connect to the origin. Specify the HTTP port that the origin
        /// listens on.</p>
        pub fn http_port(mut self, input: i32) -> Self {
            self.http_port = Some(input);
            self
        }
        /// <p>The HTTP port that CloudFront uses to connect to the origin. Specify the HTTP port that the origin
        /// listens on.</p>
        pub fn set_http_port(mut self, input: std::option::Option<i32>) -> Self {
            self.http_port = input;
            self
        }
        /// <p>The HTTPS port that CloudFront uses to connect to the origin. Specify the HTTPS port that the
        /// origin listens on.</p>
        pub fn https_port(mut self, input: i32) -> Self {
            self.https_port = Some(input);
            self
        }
        /// <p>The HTTPS port that CloudFront uses to connect to the origin. Specify the HTTPS port that the
        /// origin listens on.</p>
        pub fn set_https_port(mut self, input: std::option::Option<i32>) -> Self {
            self.https_port = input;
            self
        }
        /// <p>Specifies the protocol (HTTP or HTTPS) that CloudFront uses to connect to the origin. Valid values
        /// are:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>http-only</code> – CloudFront always uses HTTP to connect to the
        /// origin.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>match-viewer</code> – CloudFront connects to the origin using the same
        /// protocol that the viewer used to connect to CloudFront.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>https-only</code> – CloudFront always uses HTTPS to connect to the
        /// origin.</p>
        /// </li>
        /// </ul>
        pub fn origin_protocol_policy(mut self, input: crate::model::OriginProtocolPolicy) -> Self {
            self.origin_protocol_policy = Some(input);
            self
        }
        /// <p>Specifies the protocol (HTTP or HTTPS) that CloudFront uses to connect to the origin. Valid values
        /// are:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>http-only</code> – CloudFront always uses HTTP to connect to the
        /// origin.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>match-viewer</code> – CloudFront connects to the origin using the same
        /// protocol that the viewer used to connect to CloudFront.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>https-only</code> – CloudFront always uses HTTPS to connect to the
        /// origin.</p>
        /// </li>
        /// </ul>
        pub fn set_origin_protocol_policy(
            mut self,
            input: std::option::Option<crate::model::OriginProtocolPolicy>,
        ) -> Self {
            self.origin_protocol_policy = input;
            self
        }
        /// <p>Specifies the minimum SSL/TLS protocol that CloudFront uses when connecting to your origin over
        /// HTTPS. Valid values include <code>SSLv3</code>, <code>TLSv1</code>,
        /// <code>TLSv1.1</code>, and <code>TLSv1.2</code>.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-web-values-specify.html#DownloadDistValuesOriginSSLProtocols">Minimum Origin SSL Protocol</a> in the
        /// <i>Amazon CloudFront Developer Guide</i>.</p>
        pub fn origin_ssl_protocols(mut self, input: crate::model::OriginSslProtocols) -> Self {
            self.origin_ssl_protocols = Some(input);
            self
        }
        /// <p>Specifies the minimum SSL/TLS protocol that CloudFront uses when connecting to your origin over
        /// HTTPS. Valid values include <code>SSLv3</code>, <code>TLSv1</code>,
        /// <code>TLSv1.1</code>, and <code>TLSv1.2</code>.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-web-values-specify.html#DownloadDistValuesOriginSSLProtocols">Minimum Origin SSL Protocol</a> in the
        /// <i>Amazon CloudFront Developer Guide</i>.</p>
        pub fn set_origin_ssl_protocols(
            mut self,
            input: std::option::Option<crate::model::OriginSslProtocols>,
        ) -> Self {
            self.origin_ssl_protocols = input;
            self
        }
        /// <p>Specifies how long, in seconds, CloudFront waits for a response from the origin. This is also
        /// known as the <i>origin response timeout</i>. The minimum timeout is 1
        /// second, the maximum is 60 seconds, and the default (if you don’t specify otherwise) is
        /// 30 seconds.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-web-values-specify.html#DownloadDistValuesOriginResponseTimeout">Origin Response Timeout</a> in the
        /// <i>Amazon CloudFront Developer Guide</i>.</p>
        pub fn origin_read_timeout(mut self, input: i32) -> Self {
            self.origin_read_timeout = Some(input);
            self
        }
        /// <p>Specifies how long, in seconds, CloudFront waits for a response from the origin. This is also
        /// known as the <i>origin response timeout</i>. The minimum timeout is 1
        /// second, the maximum is 60 seconds, and the default (if you don’t specify otherwise) is
        /// 30 seconds.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-web-values-specify.html#DownloadDistValuesOriginResponseTimeout">Origin Response Timeout</a> in the
        /// <i>Amazon CloudFront Developer Guide</i>.</p>
        pub fn set_origin_read_timeout(mut self, input: std::option::Option<i32>) -> Self {
            self.origin_read_timeout = input;
            self
        }
        /// <p>Specifies how long, in seconds, CloudFront persists its connection to the origin. The minimum
        /// timeout is 1 second, the maximum is 60 seconds, and the default (if you don’t specify
        /// otherwise) is 5 seconds.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-web-values-specify.html#DownloadDistValuesOriginKeepaliveTimeout">Origin Keep-alive Timeout</a> in the
        /// <i>Amazon CloudFront Developer Guide</i>.</p>
        pub fn origin_keepalive_timeout(mut self, input: i32) -> Self {
            self.origin_keepalive_timeout = Some(input);
            self
        }
        /// <p>Specifies how long, in seconds, CloudFront persists its connection to the origin. The minimum
        /// timeout is 1 second, the maximum is 60 seconds, and the default (if you don’t specify
        /// otherwise) is 5 seconds.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-web-values-specify.html#DownloadDistValuesOriginKeepaliveTimeout">Origin Keep-alive Timeout</a> in the
        /// <i>Amazon CloudFront Developer Guide</i>.</p>
        pub fn set_origin_keepalive_timeout(mut self, input: std::option::Option<i32>) -> Self {
            self.origin_keepalive_timeout = input;
            self
        }
        /// Consumes the builder and constructs a [`CustomOriginConfig`](crate::model::CustomOriginConfig)
        pub fn build(self) -> crate::model::CustomOriginConfig {
            crate::model::CustomOriginConfig {
                http_port: self.http_port,
                https_port: self.https_port,
                origin_protocol_policy: self.origin_protocol_policy,
                origin_ssl_protocols: self.origin_ssl_protocols,
                origin_read_timeout: self.origin_read_timeout,
                origin_keepalive_timeout: self.origin_keepalive_timeout,
            }
        }
    }
}
impl CustomOriginConfig {
    /// Creates a new builder-style object to manufacture [`CustomOriginConfig`](crate::model::CustomOriginConfig)
    pub fn builder() -> crate::model::custom_origin_config::Builder {
        crate::model::custom_origin_config::Builder::default()
    }
}

/// <p>A complex type that contains information about the SSL/TLS protocols that CloudFront can use
/// when establishing an HTTPS connection with your origin. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct OriginSslProtocols {
    /// <p>The number of SSL/TLS protocols that you want to allow CloudFront to use when establishing an
    /// HTTPS connection with this origin. </p>
    pub quantity: std::option::Option<i32>,
    /// <p>A list that contains allowed SSL/TLS protocols for this distribution.</p>
    pub items: std::option::Option<std::vec::Vec<crate::model::SslProtocol>>,
}
impl OriginSslProtocols {
    /// <p>The number of SSL/TLS protocols that you want to allow CloudFront to use when establishing an
    /// HTTPS connection with this origin. </p>
    pub fn quantity(&self) -> std::option::Option<i32> {
        self.quantity
    }
    /// <p>A list that contains allowed SSL/TLS protocols for this distribution.</p>
    pub fn items(&self) -> std::option::Option<&[crate::model::SslProtocol]> {
        self.items.as_deref()
    }
}
impl std::fmt::Debug for OriginSslProtocols {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("OriginSslProtocols");
        formatter.field("quantity", &self.quantity);
        formatter.field("items", &self.items);
        formatter.finish()
    }
}
/// See [`OriginSslProtocols`](crate::model::OriginSslProtocols)
pub mod origin_ssl_protocols {
    /// A builder for [`OriginSslProtocols`](crate::model::OriginSslProtocols)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) quantity: std::option::Option<i32>,
        pub(crate) items: std::option::Option<std::vec::Vec<crate::model::SslProtocol>>,
    }
    impl Builder {
        /// <p>The number of SSL/TLS protocols that you want to allow CloudFront to use when establishing an
        /// HTTPS connection with this origin. </p>
        pub fn quantity(mut self, input: i32) -> Self {
            self.quantity = Some(input);
            self
        }
        /// <p>The number of SSL/TLS protocols that you want to allow CloudFront to use when establishing an
        /// HTTPS connection with this origin. </p>
        pub fn set_quantity(mut self, input: std::option::Option<i32>) -> Self {
            self.quantity = input;
            self
        }
        /// Appends an item to `items`.
        ///
        /// To override the contents of this collection use [`set_items`](Self::set_items).
        ///
        /// <p>A list that contains allowed SSL/TLS protocols for this distribution.</p>
        pub fn items(mut self, input: impl Into<crate::model::SslProtocol>) -> Self {
            let mut v = self.items.unwrap_or_default();
            v.push(input.into());
            self.items = Some(v);
            self
        }
        /// <p>A list that contains allowed SSL/TLS protocols for this distribution.</p>
        pub fn set_items(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SslProtocol>>,
        ) -> Self {
            self.items = input;
            self
        }
        /// Consumes the builder and constructs a [`OriginSslProtocols`](crate::model::OriginSslProtocols)
        pub fn build(self) -> crate::model::OriginSslProtocols {
            crate::model::OriginSslProtocols {
                quantity: self.quantity,
                items: self.items,
            }
        }
    }
}
impl OriginSslProtocols {
    /// Creates a new builder-style object to manufacture [`OriginSslProtocols`](crate::model::OriginSslProtocols)
    pub fn builder() -> crate::model::origin_ssl_protocols::Builder {
        crate::model::origin_ssl_protocols::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum SslProtocol {
    #[allow(missing_docs)] // documentation missing in model
    SsLv3,
    #[allow(missing_docs)] // documentation missing in model
    TlSv1,
    #[allow(missing_docs)] // documentation missing in model
    TlSv11,
    #[allow(missing_docs)] // documentation missing in model
    TlSv12,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for SslProtocol {
    fn from(s: &str) -> Self {
        match s {
            "SSLv3" => SslProtocol::SsLv3,
            "TLSv1" => SslProtocol::TlSv1,
            "TLSv1.1" => SslProtocol::TlSv11,
            "TLSv1.2" => SslProtocol::TlSv12,
            other => SslProtocol::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for SslProtocol {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(SslProtocol::from(s))
    }
}
impl SslProtocol {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            SslProtocol::SsLv3 => "SSLv3",
            SslProtocol::TlSv1 => "TLSv1",
            SslProtocol::TlSv11 => "TLSv1.1",
            SslProtocol::TlSv12 => "TLSv1.2",
            SslProtocol::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["SSLv3", "TLSv1", "TLSv1.1", "TLSv1.2"]
    }
}
impl AsRef<str> for SslProtocol {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum OriginProtocolPolicy {
    #[allow(missing_docs)] // documentation missing in model
    HttpOnly,
    #[allow(missing_docs)] // documentation missing in model
    HttpsOnly,
    #[allow(missing_docs)] // documentation missing in model
    MatchViewer,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for OriginProtocolPolicy {
    fn from(s: &str) -> Self {
        match s {
            "http-only" => OriginProtocolPolicy::HttpOnly,
            "https-only" => OriginProtocolPolicy::HttpsOnly,
            "match-viewer" => OriginProtocolPolicy::MatchViewer,
            other => OriginProtocolPolicy::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for OriginProtocolPolicy {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(OriginProtocolPolicy::from(s))
    }
}
impl OriginProtocolPolicy {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            OriginProtocolPolicy::HttpOnly => "http-only",
            OriginProtocolPolicy::HttpsOnly => "https-only",
            OriginProtocolPolicy::MatchViewer => "match-viewer",
            OriginProtocolPolicy::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["http-only", "https-only", "match-viewer"]
    }
}
impl AsRef<str> for OriginProtocolPolicy {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>A complex type that contains information about the Amazon S3 origin. If the origin is a
/// custom origin or an S3 bucket that is configured as a website endpoint, use the
/// <code>CustomOriginConfig</code> element instead.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct S3OriginConfig {
    /// <p>The CloudFront origin access identity to associate with the origin. Use an origin access
    /// identity to configure the origin so that viewers can <i>only</i> access objects
    /// in an Amazon S3 bucket through CloudFront. The format of the value is:</p>
    /// <p>origin-access-identity/cloudfront/<i>ID-of-origin-access-identity</i>
    /// </p>
    /// <p>where <code>
    /// <i>ID-of-origin-access-identity</i>
    /// </code> is the value that
    /// CloudFront returned in the <code>ID</code> element when you created the origin access
    /// identity.</p>
    /// <p>If you want viewers to be able to access objects using either the CloudFront URL or the Amazon S3
    /// URL, specify an empty <code>OriginAccessIdentity</code> element.</p>
    /// <p>To delete the origin access identity from an existing distribution, update the
    /// distribution configuration and include an empty <code>OriginAccessIdentity</code>
    /// element.</p>
    /// <p>To replace the origin access identity, update the distribution configuration and
    /// specify the new origin access identity.</p>
    /// <p>For more information about the origin access identity, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html">Serving Private Content through CloudFront</a> in the
    /// <i>Amazon CloudFront Developer Guide</i>.</p>
    pub origin_access_identity: std::option::Option<std::string::String>,
}
impl S3OriginConfig {
    /// <p>The CloudFront origin access identity to associate with the origin. Use an origin access
    /// identity to configure the origin so that viewers can <i>only</i> access objects
    /// in an Amazon S3 bucket through CloudFront. The format of the value is:</p>
    /// <p>origin-access-identity/cloudfront/<i>ID-of-origin-access-identity</i>
    /// </p>
    /// <p>where <code>
    /// <i>ID-of-origin-access-identity</i>
    /// </code> is the value that
    /// CloudFront returned in the <code>ID</code> element when you created the origin access
    /// identity.</p>
    /// <p>If you want viewers to be able to access objects using either the CloudFront URL or the Amazon S3
    /// URL, specify an empty <code>OriginAccessIdentity</code> element.</p>
    /// <p>To delete the origin access identity from an existing distribution, update the
    /// distribution configuration and include an empty <code>OriginAccessIdentity</code>
    /// element.</p>
    /// <p>To replace the origin access identity, update the distribution configuration and
    /// specify the new origin access identity.</p>
    /// <p>For more information about the origin access identity, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html">Serving Private Content through CloudFront</a> in the
    /// <i>Amazon CloudFront Developer Guide</i>.</p>
    pub fn origin_access_identity(&self) -> std::option::Option<&str> {
        self.origin_access_identity.as_deref()
    }
}
impl std::fmt::Debug for S3OriginConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("S3OriginConfig");
        formatter.field("origin_access_identity", &self.origin_access_identity);
        formatter.finish()
    }
}
/// See [`S3OriginConfig`](crate::model::S3OriginConfig)
pub mod s3_origin_config {
    /// A builder for [`S3OriginConfig`](crate::model::S3OriginConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) origin_access_identity: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The CloudFront origin access identity to associate with the origin. Use an origin access
        /// identity to configure the origin so that viewers can <i>only</i> access objects
        /// in an Amazon S3 bucket through CloudFront. The format of the value is:</p>
        /// <p>origin-access-identity/cloudfront/<i>ID-of-origin-access-identity</i>
        /// </p>
        /// <p>where <code>
        /// <i>ID-of-origin-access-identity</i>
        /// </code> is the value that
        /// CloudFront returned in the <code>ID</code> element when you created the origin access
        /// identity.</p>
        /// <p>If you want viewers to be able to access objects using either the CloudFront URL or the Amazon S3
        /// URL, specify an empty <code>OriginAccessIdentity</code> element.</p>
        /// <p>To delete the origin access identity from an existing distribution, update the
        /// distribution configuration and include an empty <code>OriginAccessIdentity</code>
        /// element.</p>
        /// <p>To replace the origin access identity, update the distribution configuration and
        /// specify the new origin access identity.</p>
        /// <p>For more information about the origin access identity, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html">Serving Private Content through CloudFront</a> in the
        /// <i>Amazon CloudFront Developer Guide</i>.</p>
        pub fn origin_access_identity(mut self, input: impl Into<std::string::String>) -> Self {
            self.origin_access_identity = Some(input.into());
            self
        }
        /// <p>The CloudFront origin access identity to associate with the origin. Use an origin access
        /// identity to configure the origin so that viewers can <i>only</i> access objects
        /// in an Amazon S3 bucket through CloudFront. The format of the value is:</p>
        /// <p>origin-access-identity/cloudfront/<i>ID-of-origin-access-identity</i>
        /// </p>
        /// <p>where <code>
        /// <i>ID-of-origin-access-identity</i>
        /// </code> is the value that
        /// CloudFront returned in the <code>ID</code> element when you created the origin access
        /// identity.</p>
        /// <p>If you want viewers to be able to access objects using either the CloudFront URL or the Amazon S3
        /// URL, specify an empty <code>OriginAccessIdentity</code> element.</p>
        /// <p>To delete the origin access identity from an existing distribution, update the
        /// distribution configuration and include an empty <code>OriginAccessIdentity</code>
        /// element.</p>
        /// <p>To replace the origin access identity, update the distribution configuration and
        /// specify the new origin access identity.</p>
        /// <p>For more information about the origin access identity, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html">Serving Private Content through CloudFront</a> in the
        /// <i>Amazon CloudFront Developer Guide</i>.</p>
        pub fn set_origin_access_identity(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.origin_access_identity = input;
            self
        }
        /// Consumes the builder and constructs a [`S3OriginConfig`](crate::model::S3OriginConfig)
        pub fn build(self) -> crate::model::S3OriginConfig {
            crate::model::S3OriginConfig {
                origin_access_identity: self.origin_access_identity,
            }
        }
    }
}
impl S3OriginConfig {
    /// Creates a new builder-style object to manufacture [`S3OriginConfig`](crate::model::S3OriginConfig)
    pub fn builder() -> crate::model::s3_origin_config::Builder {
        crate::model::s3_origin_config::Builder::default()
    }
}

/// <p>A complex type that contains the list of Custom Headers for each origin. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CustomHeaders {
    /// <p>The number of custom headers, if any, for this distribution.</p>
    pub quantity: std::option::Option<i32>,
    /// <p>
    /// <b>Optional</b>: A list that contains one
    /// <code>OriginCustomHeader</code> element for each custom header that you want CloudFront to forward
    /// to the origin. If Quantity is <code>0</code>, omit <code>Items</code>.</p>
    pub items: std::option::Option<std::vec::Vec<crate::model::OriginCustomHeader>>,
}
impl CustomHeaders {
    /// <p>The number of custom headers, if any, for this distribution.</p>
    pub fn quantity(&self) -> std::option::Option<i32> {
        self.quantity
    }
    /// <p>
    /// <b>Optional</b>: A list that contains one
    /// <code>OriginCustomHeader</code> element for each custom header that you want CloudFront to forward
    /// to the origin. If Quantity is <code>0</code>, omit <code>Items</code>.</p>
    pub fn items(&self) -> std::option::Option<&[crate::model::OriginCustomHeader]> {
        self.items.as_deref()
    }
}
impl std::fmt::Debug for CustomHeaders {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CustomHeaders");
        formatter.field("quantity", &self.quantity);
        formatter.field("items", &self.items);
        formatter.finish()
    }
}
/// See [`CustomHeaders`](crate::model::CustomHeaders)
pub mod custom_headers {
    /// A builder for [`CustomHeaders`](crate::model::CustomHeaders)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) quantity: std::option::Option<i32>,
        pub(crate) items: std::option::Option<std::vec::Vec<crate::model::OriginCustomHeader>>,
    }
    impl Builder {
        /// <p>The number of custom headers, if any, for this distribution.</p>
        pub fn quantity(mut self, input: i32) -> Self {
            self.quantity = Some(input);
            self
        }
        /// <p>The number of custom headers, if any, for this distribution.</p>
        pub fn set_quantity(mut self, input: std::option::Option<i32>) -> Self {
            self.quantity = input;
            self
        }
        /// Appends an item to `items`.
        ///
        /// To override the contents of this collection use [`set_items`](Self::set_items).
        ///
        /// <p>
        /// <b>Optional</b>: A list that contains one
        /// <code>OriginCustomHeader</code> element for each custom header that you want CloudFront to forward
        /// to the origin. If Quantity is <code>0</code>, omit <code>Items</code>.</p>
        pub fn items(mut self, input: impl Into<crate::model::OriginCustomHeader>) -> Self {
            let mut v = self.items.unwrap_or_default();
            v.push(input.into());
            self.items = Some(v);
            self
        }
        /// <p>
        /// <b>Optional</b>: A list that contains one
        /// <code>OriginCustomHeader</code> element for each custom header that you want CloudFront to forward
        /// to the origin. If Quantity is <code>0</code>, omit <code>Items</code>.</p>
        pub fn set_items(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::OriginCustomHeader>>,
        ) -> Self {
            self.items = input;
            self
        }
        /// Consumes the builder and constructs a [`CustomHeaders`](crate::model::CustomHeaders)
        pub fn build(self) -> crate::model::CustomHeaders {
            crate::model::CustomHeaders {
                quantity: self.quantity,
                items: self.items,
            }
        }
    }
}
impl CustomHeaders {
    /// Creates a new builder-style object to manufacture [`CustomHeaders`](crate::model::CustomHeaders)
    pub fn builder() -> crate::model::custom_headers::Builder {
        crate::model::custom_headers::Builder::default()
    }
}

/// <p>A complex type that contains <code>HeaderName</code> and <code>HeaderValue</code>
/// elements, if any, for this distribution. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct OriginCustomHeader {
    /// <p>The name of a header that you want CloudFront to send to your origin. For more information, see
    /// <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/forward-custom-headers.html">Adding Custom
    /// Headers to Origin Requests</a> in the <i> Amazon CloudFront Developer Guide</i>.</p>
    pub header_name: std::option::Option<std::string::String>,
    /// <p>The value for the header that you specified in the <code>HeaderName</code>
    /// field.</p>
    pub header_value: std::option::Option<std::string::String>,
}
impl OriginCustomHeader {
    /// <p>The name of a header that you want CloudFront to send to your origin. For more information, see
    /// <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/forward-custom-headers.html">Adding Custom
    /// Headers to Origin Requests</a> in the <i> Amazon CloudFront Developer Guide</i>.</p>
    pub fn header_name(&self) -> std::option::Option<&str> {
        self.header_name.as_deref()
    }
    /// <p>The value for the header that you specified in the <code>HeaderName</code>
    /// field.</p>
    pub fn header_value(&self) -> std::option::Option<&str> {
        self.header_value.as_deref()
    }
}
impl std::fmt::Debug for OriginCustomHeader {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("OriginCustomHeader");
        formatter.field("header_name", &self.header_name);
        formatter.field("header_value", &"*** Sensitive Data Redacted ***");
        formatter.finish()
    }
}
/// See [`OriginCustomHeader`](crate::model::OriginCustomHeader)
pub mod origin_custom_header {
    /// A builder for [`OriginCustomHeader`](crate::model::OriginCustomHeader)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) header_name: std::option::Option<std::string::String>,
        pub(crate) header_value: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of a header that you want CloudFront to send to your origin. For more information, see
        /// <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/forward-custom-headers.html">Adding Custom
        /// Headers to Origin Requests</a> in the <i> Amazon CloudFront Developer Guide</i>.</p>
        pub fn header_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.header_name = Some(input.into());
            self
        }
        /// <p>The name of a header that you want CloudFront to send to your origin. For more information, see
        /// <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/forward-custom-headers.html">Adding Custom
        /// Headers to Origin Requests</a> in the <i> Amazon CloudFront Developer Guide</i>.</p>
        pub fn set_header_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.header_name = input;
            self
        }
        /// <p>The value for the header that you specified in the <code>HeaderName</code>
        /// field.</p>
        pub fn header_value(mut self, input: impl Into<std::string::String>) -> Self {
            self.header_value = Some(input.into());
            self
        }
        /// <p>The value for the header that you specified in the <code>HeaderName</code>
        /// field.</p>
        pub fn set_header_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.header_value = input;
            self
        }
        /// Consumes the builder and constructs a [`OriginCustomHeader`](crate::model::OriginCustomHeader)
        pub fn build(self) -> crate::model::OriginCustomHeader {
            crate::model::OriginCustomHeader {
                header_name: self.header_name,
                header_value: self.header_value,
            }
        }
    }
}
impl OriginCustomHeader {
    /// Creates a new builder-style object to manufacture [`OriginCustomHeader`](crate::model::OriginCustomHeader)
    pub fn builder() -> crate::model::origin_custom_header::Builder {
        crate::model::origin_custom_header::Builder::default()
    }
}

/// <p>A list of key groups, and the public keys in each key group,
/// that CloudFront can use to verify the signatures of signed URLs and signed cookies.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ActiveTrustedKeyGroups {
    /// <p>This field is <code>true</code> if any of the key groups have public keys that CloudFront can use
    /// to verify the signatures of signed URLs and signed cookies. If not, this field is
    /// <code>false</code>.</p>
    pub enabled: std::option::Option<bool>,
    /// <p>The number of key groups in the list.</p>
    pub quantity: std::option::Option<i32>,
    /// <p>A list of key groups, including the identifiers of the public keys in each key group that
    /// CloudFront can use to verify the signatures of signed URLs and signed cookies.</p>
    pub items: std::option::Option<std::vec::Vec<crate::model::KgKeyPairIds>>,
}
impl ActiveTrustedKeyGroups {
    /// <p>This field is <code>true</code> if any of the key groups have public keys that CloudFront can use
    /// to verify the signatures of signed URLs and signed cookies. If not, this field is
    /// <code>false</code>.</p>
    pub fn enabled(&self) -> std::option::Option<bool> {
        self.enabled
    }
    /// <p>The number of key groups in the list.</p>
    pub fn quantity(&self) -> std::option::Option<i32> {
        self.quantity
    }
    /// <p>A list of key groups, including the identifiers of the public keys in each key group that
    /// CloudFront can use to verify the signatures of signed URLs and signed cookies.</p>
    pub fn items(&self) -> std::option::Option<&[crate::model::KgKeyPairIds]> {
        self.items.as_deref()
    }
}
impl std::fmt::Debug for ActiveTrustedKeyGroups {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ActiveTrustedKeyGroups");
        formatter.field("enabled", &self.enabled);
        formatter.field("quantity", &self.quantity);
        formatter.field("items", &self.items);
        formatter.finish()
    }
}
/// See [`ActiveTrustedKeyGroups`](crate::model::ActiveTrustedKeyGroups)
pub mod active_trusted_key_groups {
    /// A builder for [`ActiveTrustedKeyGroups`](crate::model::ActiveTrustedKeyGroups)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) enabled: std::option::Option<bool>,
        pub(crate) quantity: std::option::Option<i32>,
        pub(crate) items: std::option::Option<std::vec::Vec<crate::model::KgKeyPairIds>>,
    }
    impl Builder {
        /// <p>This field is <code>true</code> if any of the key groups have public keys that CloudFront can use
        /// to verify the signatures of signed URLs and signed cookies. If not, this field is
        /// <code>false</code>.</p>
        pub fn enabled(mut self, input: bool) -> Self {
            self.enabled = Some(input);
            self
        }
        /// <p>This field is <code>true</code> if any of the key groups have public keys that CloudFront can use
        /// to verify the signatures of signed URLs and signed cookies. If not, this field is
        /// <code>false</code>.</p>
        pub fn set_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.enabled = input;
            self
        }
        /// <p>The number of key groups in the list.</p>
        pub fn quantity(mut self, input: i32) -> Self {
            self.quantity = Some(input);
            self
        }
        /// <p>The number of key groups in the list.</p>
        pub fn set_quantity(mut self, input: std::option::Option<i32>) -> Self {
            self.quantity = input;
            self
        }
        /// Appends an item to `items`.
        ///
        /// To override the contents of this collection use [`set_items`](Self::set_items).
        ///
        /// <p>A list of key groups, including the identifiers of the public keys in each key group that
        /// CloudFront can use to verify the signatures of signed URLs and signed cookies.</p>
        pub fn items(mut self, input: impl Into<crate::model::KgKeyPairIds>) -> Self {
            let mut v = self.items.unwrap_or_default();
            v.push(input.into());
            self.items = Some(v);
            self
        }
        /// <p>A list of key groups, including the identifiers of the public keys in each key group that
        /// CloudFront can use to verify the signatures of signed URLs and signed cookies.</p>
        pub fn set_items(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::KgKeyPairIds>>,
        ) -> Self {
            self.items = input;
            self
        }
        /// Consumes the builder and constructs a [`ActiveTrustedKeyGroups`](crate::model::ActiveTrustedKeyGroups)
        pub fn build(self) -> crate::model::ActiveTrustedKeyGroups {
            crate::model::ActiveTrustedKeyGroups {
                enabled: self.enabled,
                quantity: self.quantity,
                items: self.items,
            }
        }
    }
}
impl ActiveTrustedKeyGroups {
    /// Creates a new builder-style object to manufacture [`ActiveTrustedKeyGroups`](crate::model::ActiveTrustedKeyGroups)
    pub fn builder() -> crate::model::active_trusted_key_groups::Builder {
        crate::model::active_trusted_key_groups::Builder::default()
    }
}

/// <p>A list of identifiers for the public keys that CloudFront can use to verify the
/// signatures of signed URLs and signed cookies.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct KgKeyPairIds {
    /// <p>The identifier of the key group that contains the public keys.</p>
    pub key_group_id: std::option::Option<std::string::String>,
    /// <p>A list of CloudFront key pair identifiers.</p>
    pub key_pair_ids: std::option::Option<crate::model::KeyPairIds>,
}
impl KgKeyPairIds {
    /// <p>The identifier of the key group that contains the public keys.</p>
    pub fn key_group_id(&self) -> std::option::Option<&str> {
        self.key_group_id.as_deref()
    }
    /// <p>A list of CloudFront key pair identifiers.</p>
    pub fn key_pair_ids(&self) -> std::option::Option<&crate::model::KeyPairIds> {
        self.key_pair_ids.as_ref()
    }
}
impl std::fmt::Debug for KgKeyPairIds {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("KgKeyPairIds");
        formatter.field("key_group_id", &self.key_group_id);
        formatter.field("key_pair_ids", &self.key_pair_ids);
        formatter.finish()
    }
}
/// See [`KgKeyPairIds`](crate::model::KgKeyPairIds)
pub mod kg_key_pair_ids {
    /// A builder for [`KgKeyPairIds`](crate::model::KgKeyPairIds)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) key_group_id: std::option::Option<std::string::String>,
        pub(crate) key_pair_ids: std::option::Option<crate::model::KeyPairIds>,
    }
    impl Builder {
        /// <p>The identifier of the key group that contains the public keys.</p>
        pub fn key_group_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.key_group_id = Some(input.into());
            self
        }
        /// <p>The identifier of the key group that contains the public keys.</p>
        pub fn set_key_group_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key_group_id = input;
            self
        }
        /// <p>A list of CloudFront key pair identifiers.</p>
        pub fn key_pair_ids(mut self, input: crate::model::KeyPairIds) -> Self {
            self.key_pair_ids = Some(input);
            self
        }
        /// <p>A list of CloudFront key pair identifiers.</p>
        pub fn set_key_pair_ids(
            mut self,
            input: std::option::Option<crate::model::KeyPairIds>,
        ) -> Self {
            self.key_pair_ids = input;
            self
        }
        /// Consumes the builder and constructs a [`KgKeyPairIds`](crate::model::KgKeyPairIds)
        pub fn build(self) -> crate::model::KgKeyPairIds {
            crate::model::KgKeyPairIds {
                key_group_id: self.key_group_id,
                key_pair_ids: self.key_pair_ids,
            }
        }
    }
}
impl KgKeyPairIds {
    /// Creates a new builder-style object to manufacture [`KgKeyPairIds`](crate::model::KgKeyPairIds)
    pub fn builder() -> crate::model::kg_key_pair_ids::Builder {
        crate::model::kg_key_pair_ids::Builder::default()
    }
}

/// <p>CloudFront origin access identity.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CloudFrontOriginAccessIdentity {
    /// <p>The ID for the origin access identity, for example, <code>E74FTE3AJFJ256A</code>.
    /// </p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The Amazon S3 canonical user ID for the origin access identity, used when giving the origin
    /// access identity read permission to an object in Amazon S3. </p>
    pub s3_canonical_user_id: std::option::Option<std::string::String>,
    /// <p>The current configuration information for the identity. </p>
    pub cloud_front_origin_access_identity_config:
        std::option::Option<crate::model::CloudFrontOriginAccessIdentityConfig>,
}
impl CloudFrontOriginAccessIdentity {
    /// <p>The ID for the origin access identity, for example, <code>E74FTE3AJFJ256A</code>.
    /// </p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The Amazon S3 canonical user ID for the origin access identity, used when giving the origin
    /// access identity read permission to an object in Amazon S3. </p>
    pub fn s3_canonical_user_id(&self) -> std::option::Option<&str> {
        self.s3_canonical_user_id.as_deref()
    }
    /// <p>The current configuration information for the identity. </p>
    pub fn cloud_front_origin_access_identity_config(
        &self,
    ) -> std::option::Option<&crate::model::CloudFrontOriginAccessIdentityConfig> {
        self.cloud_front_origin_access_identity_config.as_ref()
    }
}
impl std::fmt::Debug for CloudFrontOriginAccessIdentity {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CloudFrontOriginAccessIdentity");
        formatter.field("id", &self.id);
        formatter.field("s3_canonical_user_id", &self.s3_canonical_user_id);
        formatter.field(
            "cloud_front_origin_access_identity_config",
            &self.cloud_front_origin_access_identity_config,
        );
        formatter.finish()
    }
}
/// See [`CloudFrontOriginAccessIdentity`](crate::model::CloudFrontOriginAccessIdentity)
pub mod cloud_front_origin_access_identity {
    /// A builder for [`CloudFrontOriginAccessIdentity`](crate::model::CloudFrontOriginAccessIdentity)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) s3_canonical_user_id: std::option::Option<std::string::String>,
        pub(crate) cloud_front_origin_access_identity_config:
            std::option::Option<crate::model::CloudFrontOriginAccessIdentityConfig>,
    }
    impl Builder {
        /// <p>The ID for the origin access identity, for example, <code>E74FTE3AJFJ256A</code>.
        /// </p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The ID for the origin access identity, for example, <code>E74FTE3AJFJ256A</code>.
        /// </p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The Amazon S3 canonical user ID for the origin access identity, used when giving the origin
        /// access identity read permission to an object in Amazon S3. </p>
        pub fn s3_canonical_user_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.s3_canonical_user_id = Some(input.into());
            self
        }
        /// <p>The Amazon S3 canonical user ID for the origin access identity, used when giving the origin
        /// access identity read permission to an object in Amazon S3. </p>
        pub fn set_s3_canonical_user_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.s3_canonical_user_id = input;
            self
        }
        /// <p>The current configuration information for the identity. </p>
        pub fn cloud_front_origin_access_identity_config(
            mut self,
            input: crate::model::CloudFrontOriginAccessIdentityConfig,
        ) -> Self {
            self.cloud_front_origin_access_identity_config = Some(input);
            self
        }
        /// <p>The current configuration information for the identity. </p>
        pub fn set_cloud_front_origin_access_identity_config(
            mut self,
            input: std::option::Option<crate::model::CloudFrontOriginAccessIdentityConfig>,
        ) -> Self {
            self.cloud_front_origin_access_identity_config = input;
            self
        }
        /// Consumes the builder and constructs a [`CloudFrontOriginAccessIdentity`](crate::model::CloudFrontOriginAccessIdentity)
        pub fn build(self) -> crate::model::CloudFrontOriginAccessIdentity {
            crate::model::CloudFrontOriginAccessIdentity {
                id: self.id,
                s3_canonical_user_id: self.s3_canonical_user_id,
                cloud_front_origin_access_identity_config: self
                    .cloud_front_origin_access_identity_config,
            }
        }
    }
}
impl CloudFrontOriginAccessIdentity {
    /// Creates a new builder-style object to manufacture [`CloudFrontOriginAccessIdentity`](crate::model::CloudFrontOriginAccessIdentity)
    pub fn builder() -> crate::model::cloud_front_origin_access_identity::Builder {
        crate::model::cloud_front_origin_access_identity::Builder::default()
    }
}

/// <p>Origin access identity configuration. Send a <code>GET</code> request to the
/// <code>/<i>CloudFront API version</i>/CloudFront/identity ID/config</code> resource.
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CloudFrontOriginAccessIdentityConfig {
    /// <p>A unique value (for example, a date-time stamp) that ensures that the request can't be replayed.</p>
    /// <p>If the value of <code>CallerReference</code> is new (regardless of the content of the
    /// <code>CloudFrontOriginAccessIdentityConfig</code> object), a new origin access identity is
    /// created.</p>
    /// <p>If the <code>CallerReference</code> is a value already sent in a previous identity
    /// request, and the content of the <code>CloudFrontOriginAccessIdentityConfig</code> is identical
    /// to the original request (ignoring white space), the response includes the same information
    /// returned to the original request. </p>
    /// <p>If the <code>CallerReference</code> is a value you already sent in a previous request
    /// to create an identity, but the content of the
    /// <code>CloudFrontOriginAccessIdentityConfig</code> is different from the original request,
    /// CloudFront returns a <code>CloudFrontOriginAccessIdentityAlreadyExists</code> error. </p>
    pub caller_reference: std::option::Option<std::string::String>,
    /// <p>A comment to describe the origin access identity. The comment cannot be longer
    /// than 128 characters.</p>
    pub comment: std::option::Option<std::string::String>,
}
impl CloudFrontOriginAccessIdentityConfig {
    /// <p>A unique value (for example, a date-time stamp) that ensures that the request can't be replayed.</p>
    /// <p>If the value of <code>CallerReference</code> is new (regardless of the content of the
    /// <code>CloudFrontOriginAccessIdentityConfig</code> object), a new origin access identity is
    /// created.</p>
    /// <p>If the <code>CallerReference</code> is a value already sent in a previous identity
    /// request, and the content of the <code>CloudFrontOriginAccessIdentityConfig</code> is identical
    /// to the original request (ignoring white space), the response includes the same information
    /// returned to the original request. </p>
    /// <p>If the <code>CallerReference</code> is a value you already sent in a previous request
    /// to create an identity, but the content of the
    /// <code>CloudFrontOriginAccessIdentityConfig</code> is different from the original request,
    /// CloudFront returns a <code>CloudFrontOriginAccessIdentityAlreadyExists</code> error. </p>
    pub fn caller_reference(&self) -> std::option::Option<&str> {
        self.caller_reference.as_deref()
    }
    /// <p>A comment to describe the origin access identity. The comment cannot be longer
    /// than 128 characters.</p>
    pub fn comment(&self) -> std::option::Option<&str> {
        self.comment.as_deref()
    }
}
impl std::fmt::Debug for CloudFrontOriginAccessIdentityConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CloudFrontOriginAccessIdentityConfig");
        formatter.field("caller_reference", &self.caller_reference);
        formatter.field("comment", &self.comment);
        formatter.finish()
    }
}
/// See [`CloudFrontOriginAccessIdentityConfig`](crate::model::CloudFrontOriginAccessIdentityConfig)
pub mod cloud_front_origin_access_identity_config {
    /// A builder for [`CloudFrontOriginAccessIdentityConfig`](crate::model::CloudFrontOriginAccessIdentityConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) caller_reference: std::option::Option<std::string::String>,
        pub(crate) comment: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A unique value (for example, a date-time stamp) that ensures that the request can't be replayed.</p>
        /// <p>If the value of <code>CallerReference</code> is new (regardless of the content of the
        /// <code>CloudFrontOriginAccessIdentityConfig</code> object), a new origin access identity is
        /// created.</p>
        /// <p>If the <code>CallerReference</code> is a value already sent in a previous identity
        /// request, and the content of the <code>CloudFrontOriginAccessIdentityConfig</code> is identical
        /// to the original request (ignoring white space), the response includes the same information
        /// returned to the original request. </p>
        /// <p>If the <code>CallerReference</code> is a value you already sent in a previous request
        /// to create an identity, but the content of the
        /// <code>CloudFrontOriginAccessIdentityConfig</code> is different from the original request,
        /// CloudFront returns a <code>CloudFrontOriginAccessIdentityAlreadyExists</code> error. </p>
        pub fn caller_reference(mut self, input: impl Into<std::string::String>) -> Self {
            self.caller_reference = Some(input.into());
            self
        }
        /// <p>A unique value (for example, a date-time stamp) that ensures that the request can't be replayed.</p>
        /// <p>If the value of <code>CallerReference</code> is new (regardless of the content of the
        /// <code>CloudFrontOriginAccessIdentityConfig</code> object), a new origin access identity is
        /// created.</p>
        /// <p>If the <code>CallerReference</code> is a value already sent in a previous identity
        /// request, and the content of the <code>CloudFrontOriginAccessIdentityConfig</code> is identical
        /// to the original request (ignoring white space), the response includes the same information
        /// returned to the original request. </p>
        /// <p>If the <code>CallerReference</code> is a value you already sent in a previous request
        /// to create an identity, but the content of the
        /// <code>CloudFrontOriginAccessIdentityConfig</code> is different from the original request,
        /// CloudFront returns a <code>CloudFrontOriginAccessIdentityAlreadyExists</code> error. </p>
        pub fn set_caller_reference(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.caller_reference = input;
            self
        }
        /// <p>A comment to describe the origin access identity. The comment cannot be longer
        /// than 128 characters.</p>
        pub fn comment(mut self, input: impl Into<std::string::String>) -> Self {
            self.comment = Some(input.into());
            self
        }
        /// <p>A comment to describe the origin access identity. The comment cannot be longer
        /// than 128 characters.</p>
        pub fn set_comment(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.comment = input;
            self
        }
        /// Consumes the builder and constructs a [`CloudFrontOriginAccessIdentityConfig`](crate::model::CloudFrontOriginAccessIdentityConfig)
        pub fn build(self) -> crate::model::CloudFrontOriginAccessIdentityConfig {
            crate::model::CloudFrontOriginAccessIdentityConfig {
                caller_reference: self.caller_reference,
                comment: self.comment,
            }
        }
    }
}
impl CloudFrontOriginAccessIdentityConfig {
    /// Creates a new builder-style object to manufacture [`CloudFrontOriginAccessIdentityConfig`](crate::model::CloudFrontOriginAccessIdentityConfig)
    pub fn builder() -> crate::model::cloud_front_origin_access_identity_config::Builder {
        crate::model::cloud_front_origin_access_identity_config::Builder::default()
    }
}

/// <p>A cache policy.</p>
/// <p>When it’s attached to a cache behavior, the cache policy determines the
/// following:</p>
/// <ul>
/// <li>
/// <p>The values that CloudFront includes in the cache key. These values can include HTTP headers,
/// cookies, and URL query strings. CloudFront uses the cache key to find an object in its
/// cache that it can return to the viewer.</p>
/// </li>
/// <li>
/// <p>The default, minimum, and maximum time to live (TTL) values that you want objects to stay
/// in the CloudFront cache.</p>
/// </li>
/// </ul>
/// <p>The headers, cookies, and query strings that are included in the cache key are automatically
/// included in requests that CloudFront sends to the origin. CloudFront sends a request when it can’t
/// find a valid object in its cache that matches the request’s cache key. If you want to
/// send values to the origin but <i>not</i> include them in the cache key,
/// use <code>OriginRequestPolicy</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CachePolicy {
    /// <p>The unique identifier for the cache policy.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The date and time when the cache policy was last modified.</p>
    pub last_modified_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The cache policy configuration.</p>
    pub cache_policy_config: std::option::Option<crate::model::CachePolicyConfig>,
}
impl CachePolicy {
    /// <p>The unique identifier for the cache policy.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The date and time when the cache policy was last modified.</p>
    pub fn last_modified_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_modified_time.as_ref()
    }
    /// <p>The cache policy configuration.</p>
    pub fn cache_policy_config(&self) -> std::option::Option<&crate::model::CachePolicyConfig> {
        self.cache_policy_config.as_ref()
    }
}
impl std::fmt::Debug for CachePolicy {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CachePolicy");
        formatter.field("id", &self.id);
        formatter.field("last_modified_time", &self.last_modified_time);
        formatter.field("cache_policy_config", &self.cache_policy_config);
        formatter.finish()
    }
}
/// See [`CachePolicy`](crate::model::CachePolicy)
pub mod cache_policy {
    /// A builder for [`CachePolicy`](crate::model::CachePolicy)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) last_modified_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) cache_policy_config: std::option::Option<crate::model::CachePolicyConfig>,
    }
    impl Builder {
        /// <p>The unique identifier for the cache policy.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the cache policy.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The date and time when the cache policy was last modified.</p>
        pub fn last_modified_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_modified_time = Some(input);
            self
        }
        /// <p>The date and time when the cache policy was last modified.</p>
        pub fn set_last_modified_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_modified_time = input;
            self
        }
        /// <p>The cache policy configuration.</p>
        pub fn cache_policy_config(mut self, input: crate::model::CachePolicyConfig) -> Self {
            self.cache_policy_config = Some(input);
            self
        }
        /// <p>The cache policy configuration.</p>
        pub fn set_cache_policy_config(
            mut self,
            input: std::option::Option<crate::model::CachePolicyConfig>,
        ) -> Self {
            self.cache_policy_config = input;
            self
        }
        /// Consumes the builder and constructs a [`CachePolicy`](crate::model::CachePolicy)
        pub fn build(self) -> crate::model::CachePolicy {
            crate::model::CachePolicy {
                id: self.id,
                last_modified_time: self.last_modified_time,
                cache_policy_config: self.cache_policy_config,
            }
        }
    }
}
impl CachePolicy {
    /// Creates a new builder-style object to manufacture [`CachePolicy`](crate::model::CachePolicy)
    pub fn builder() -> crate::model::cache_policy::Builder {
        crate::model::cache_policy::Builder::default()
    }
}

/// <p>A cache policy configuration.</p>
/// <p>This configuration determines the following:</p>
/// <ul>
/// <li>
/// <p>The values that CloudFront includes in the cache key. These values can include HTTP headers,
/// cookies, and URL query strings. CloudFront uses the cache key to find an object in its
/// cache that it can return to the viewer.</p>
/// </li>
/// <li>
/// <p>The default, minimum, and maximum time to live (TTL) values that you want objects to stay
/// in the CloudFront cache.</p>
/// </li>
/// </ul>
/// <p>The headers, cookies, and query strings that are included in the cache key are automatically
/// included in requests that CloudFront sends to the origin. CloudFront sends a request when it can’t
/// find a valid object in its cache that matches the request’s cache key. If you want to
/// send values to the origin but <i>not</i> include them in the cache key,
/// use <code>OriginRequestPolicy</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CachePolicyConfig {
    /// <p>A comment to describe the cache policy. The comment cannot be longer than 128
    /// characters.</p>
    pub comment: std::option::Option<std::string::String>,
    /// <p>A unique name to identify the cache policy.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The default amount of time, in seconds, that you want objects to stay in the CloudFront
    /// cache before CloudFront sends another request to the origin to see if the object has been
    /// updated. CloudFront uses this value as the object’s time to live (TTL) only when the origin
    /// does <i>not</i> send <code>Cache-Control</code> or <code>Expires</code>
    /// headers with the object. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Expiration.html">Managing How Long Content Stays in an Edge Cache (Expiration)</a> in the
    /// <i>Amazon CloudFront Developer Guide</i>.</p>
    /// <p>The default value for this field is 86400 seconds (one day). If the value of
    /// <code>MinTTL</code> is more than 86400 seconds, then the default value for this field is
    /// the same as the value of <code>MinTTL</code>.</p>
    pub default_ttl: std::option::Option<i64>,
    /// <p>The maximum amount of time, in seconds, that objects stay in the CloudFront cache
    /// before CloudFront sends another request to the origin to see if the object has been updated.
    /// CloudFront uses this value only when the origin sends <code>Cache-Control</code> or
    /// <code>Expires</code> headers with the object. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Expiration.html">Managing How Long Content Stays in an Edge Cache (Expiration)</a> in the
    /// <i>Amazon CloudFront Developer Guide</i>.</p>
    /// <p>The default value for this field is 31536000 seconds (one year). If the value of
    /// <code>MinTTL</code> or <code>DefaultTTL</code> is more than 31536000 seconds, then the
    /// default value for this field is the same as the value of <code>DefaultTTL</code>.</p>
    pub max_ttl: std::option::Option<i64>,
    /// <p>The minimum amount of time, in seconds, that you want objects to stay in the CloudFront
    /// cache before CloudFront sends another request to the origin to see if the object has been
    /// updated. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Expiration.html">Managing How Long Content Stays in an Edge Cache (Expiration)</a> in the
    /// <i>Amazon CloudFront Developer Guide</i>.</p>
    pub min_ttl: std::option::Option<i64>,
    /// <p>The HTTP headers, cookies, and URL query strings to include in the cache key. The
    /// values included in the cache key are automatically included in requests that CloudFront sends
    /// to the origin.</p>
    pub parameters_in_cache_key_and_forwarded_to_origin:
        std::option::Option<crate::model::ParametersInCacheKeyAndForwardedToOrigin>,
}
impl CachePolicyConfig {
    /// <p>A comment to describe the cache policy. The comment cannot be longer than 128
    /// characters.</p>
    pub fn comment(&self) -> std::option::Option<&str> {
        self.comment.as_deref()
    }
    /// <p>A unique name to identify the cache policy.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The default amount of time, in seconds, that you want objects to stay in the CloudFront
    /// cache before CloudFront sends another request to the origin to see if the object has been
    /// updated. CloudFront uses this value as the object’s time to live (TTL) only when the origin
    /// does <i>not</i> send <code>Cache-Control</code> or <code>Expires</code>
    /// headers with the object. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Expiration.html">Managing How Long Content Stays in an Edge Cache (Expiration)</a> in the
    /// <i>Amazon CloudFront Developer Guide</i>.</p>
    /// <p>The default value for this field is 86400 seconds (one day). If the value of
    /// <code>MinTTL</code> is more than 86400 seconds, then the default value for this field is
    /// the same as the value of <code>MinTTL</code>.</p>
    pub fn default_ttl(&self) -> std::option::Option<i64> {
        self.default_ttl
    }
    /// <p>The maximum amount of time, in seconds, that objects stay in the CloudFront cache
    /// before CloudFront sends another request to the origin to see if the object has been updated.
    /// CloudFront uses this value only when the origin sends <code>Cache-Control</code> or
    /// <code>Expires</code> headers with the object. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Expiration.html">Managing How Long Content Stays in an Edge Cache (Expiration)</a> in the
    /// <i>Amazon CloudFront Developer Guide</i>.</p>
    /// <p>The default value for this field is 31536000 seconds (one year). If the value of
    /// <code>MinTTL</code> or <code>DefaultTTL</code> is more than 31536000 seconds, then the
    /// default value for this field is the same as the value of <code>DefaultTTL</code>.</p>
    pub fn max_ttl(&self) -> std::option::Option<i64> {
        self.max_ttl
    }
    /// <p>The minimum amount of time, in seconds, that you want objects to stay in the CloudFront
    /// cache before CloudFront sends another request to the origin to see if the object has been
    /// updated. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Expiration.html">Managing How Long Content Stays in an Edge Cache (Expiration)</a> in the
    /// <i>Amazon CloudFront Developer Guide</i>.</p>
    pub fn min_ttl(&self) -> std::option::Option<i64> {
        self.min_ttl
    }
    /// <p>The HTTP headers, cookies, and URL query strings to include in the cache key. The
    /// values included in the cache key are automatically included in requests that CloudFront sends
    /// to the origin.</p>
    pub fn parameters_in_cache_key_and_forwarded_to_origin(
        &self,
    ) -> std::option::Option<&crate::model::ParametersInCacheKeyAndForwardedToOrigin> {
        self.parameters_in_cache_key_and_forwarded_to_origin
            .as_ref()
    }
}
impl std::fmt::Debug for CachePolicyConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CachePolicyConfig");
        formatter.field("comment", &self.comment);
        formatter.field("name", &self.name);
        formatter.field("default_ttl", &self.default_ttl);
        formatter.field("max_ttl", &self.max_ttl);
        formatter.field("min_ttl", &self.min_ttl);
        formatter.field(
            "parameters_in_cache_key_and_forwarded_to_origin",
            &self.parameters_in_cache_key_and_forwarded_to_origin,
        );
        formatter.finish()
    }
}
/// See [`CachePolicyConfig`](crate::model::CachePolicyConfig)
pub mod cache_policy_config {
    /// A builder for [`CachePolicyConfig`](crate::model::CachePolicyConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) comment: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) default_ttl: std::option::Option<i64>,
        pub(crate) max_ttl: std::option::Option<i64>,
        pub(crate) min_ttl: std::option::Option<i64>,
        pub(crate) parameters_in_cache_key_and_forwarded_to_origin:
            std::option::Option<crate::model::ParametersInCacheKeyAndForwardedToOrigin>,
    }
    impl Builder {
        /// <p>A comment to describe the cache policy. The comment cannot be longer than 128
        /// characters.</p>
        pub fn comment(mut self, input: impl Into<std::string::String>) -> Self {
            self.comment = Some(input.into());
            self
        }
        /// <p>A comment to describe the cache policy. The comment cannot be longer than 128
        /// characters.</p>
        pub fn set_comment(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.comment = input;
            self
        }
        /// <p>A unique name to identify the cache policy.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>A unique name to identify the cache policy.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The default amount of time, in seconds, that you want objects to stay in the CloudFront
        /// cache before CloudFront sends another request to the origin to see if the object has been
        /// updated. CloudFront uses this value as the object’s time to live (TTL) only when the origin
        /// does <i>not</i> send <code>Cache-Control</code> or <code>Expires</code>
        /// headers with the object. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Expiration.html">Managing How Long Content Stays in an Edge Cache (Expiration)</a> in the
        /// <i>Amazon CloudFront Developer Guide</i>.</p>
        /// <p>The default value for this field is 86400 seconds (one day). If the value of
        /// <code>MinTTL</code> is more than 86400 seconds, then the default value for this field is
        /// the same as the value of <code>MinTTL</code>.</p>
        pub fn default_ttl(mut self, input: i64) -> Self {
            self.default_ttl = Some(input);
            self
        }
        /// <p>The default amount of time, in seconds, that you want objects to stay in the CloudFront
        /// cache before CloudFront sends another request to the origin to see if the object has been
        /// updated. CloudFront uses this value as the object’s time to live (TTL) only when the origin
        /// does <i>not</i> send <code>Cache-Control</code> or <code>Expires</code>
        /// headers with the object. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Expiration.html">Managing How Long Content Stays in an Edge Cache (Expiration)</a> in the
        /// <i>Amazon CloudFront Developer Guide</i>.</p>
        /// <p>The default value for this field is 86400 seconds (one day). If the value of
        /// <code>MinTTL</code> is more than 86400 seconds, then the default value for this field is
        /// the same as the value of <code>MinTTL</code>.</p>
        pub fn set_default_ttl(mut self, input: std::option::Option<i64>) -> Self {
            self.default_ttl = input;
            self
        }
        /// <p>The maximum amount of time, in seconds, that objects stay in the CloudFront cache
        /// before CloudFront sends another request to the origin to see if the object has been updated.
        /// CloudFront uses this value only when the origin sends <code>Cache-Control</code> or
        /// <code>Expires</code> headers with the object. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Expiration.html">Managing How Long Content Stays in an Edge Cache (Expiration)</a> in the
        /// <i>Amazon CloudFront Developer Guide</i>.</p>
        /// <p>The default value for this field is 31536000 seconds (one year). If the value of
        /// <code>MinTTL</code> or <code>DefaultTTL</code> is more than 31536000 seconds, then the
        /// default value for this field is the same as the value of <code>DefaultTTL</code>.</p>
        pub fn max_ttl(mut self, input: i64) -> Self {
            self.max_ttl = Some(input);
            self
        }
        /// <p>The maximum amount of time, in seconds, that objects stay in the CloudFront cache
        /// before CloudFront sends another request to the origin to see if the object has been updated.
        /// CloudFront uses this value only when the origin sends <code>Cache-Control</code> or
        /// <code>Expires</code> headers with the object. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Expiration.html">Managing How Long Content Stays in an Edge Cache (Expiration)</a> in the
        /// <i>Amazon CloudFront Developer Guide</i>.</p>
        /// <p>The default value for this field is 31536000 seconds (one year). If the value of
        /// <code>MinTTL</code> or <code>DefaultTTL</code> is more than 31536000 seconds, then the
        /// default value for this field is the same as the value of <code>DefaultTTL</code>.</p>
        pub fn set_max_ttl(mut self, input: std::option::Option<i64>) -> Self {
            self.max_ttl = input;
            self
        }
        /// <p>The minimum amount of time, in seconds, that you want objects to stay in the CloudFront
        /// cache before CloudFront sends another request to the origin to see if the object has been
        /// updated. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Expiration.html">Managing How Long Content Stays in an Edge Cache (Expiration)</a> in the
        /// <i>Amazon CloudFront Developer Guide</i>.</p>
        pub fn min_ttl(mut self, input: i64) -> Self {
            self.min_ttl = Some(input);
            self
        }
        /// <p>The minimum amount of time, in seconds, that you want objects to stay in the CloudFront
        /// cache before CloudFront sends another request to the origin to see if the object has been
        /// updated. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Expiration.html">Managing How Long Content Stays in an Edge Cache (Expiration)</a> in the
        /// <i>Amazon CloudFront Developer Guide</i>.</p>
        pub fn set_min_ttl(mut self, input: std::option::Option<i64>) -> Self {
            self.min_ttl = input;
            self
        }
        /// <p>The HTTP headers, cookies, and URL query strings to include in the cache key. The
        /// values included in the cache key are automatically included in requests that CloudFront sends
        /// to the origin.</p>
        pub fn parameters_in_cache_key_and_forwarded_to_origin(
            mut self,
            input: crate::model::ParametersInCacheKeyAndForwardedToOrigin,
        ) -> Self {
            self.parameters_in_cache_key_and_forwarded_to_origin = Some(input);
            self
        }
        /// <p>The HTTP headers, cookies, and URL query strings to include in the cache key. The
        /// values included in the cache key are automatically included in requests that CloudFront sends
        /// to the origin.</p>
        pub fn set_parameters_in_cache_key_and_forwarded_to_origin(
            mut self,
            input: std::option::Option<crate::model::ParametersInCacheKeyAndForwardedToOrigin>,
        ) -> Self {
            self.parameters_in_cache_key_and_forwarded_to_origin = input;
            self
        }
        /// Consumes the builder and constructs a [`CachePolicyConfig`](crate::model::CachePolicyConfig)
        pub fn build(self) -> crate::model::CachePolicyConfig {
            crate::model::CachePolicyConfig {
                comment: self.comment,
                name: self.name,
                default_ttl: self.default_ttl,
                max_ttl: self.max_ttl,
                min_ttl: self.min_ttl,
                parameters_in_cache_key_and_forwarded_to_origin: self
                    .parameters_in_cache_key_and_forwarded_to_origin,
            }
        }
    }
}
impl CachePolicyConfig {
    /// Creates a new builder-style object to manufacture [`CachePolicyConfig`](crate::model::CachePolicyConfig)
    pub fn builder() -> crate::model::cache_policy_config::Builder {
        crate::model::cache_policy_config::Builder::default()
    }
}

/// <p>This object determines the values that CloudFront includes in the cache key. These values can
/// include HTTP headers, cookies, and URL query strings. CloudFront uses the cache key to find an
/// object in its cache that it can return to the viewer.</p>
/// <p>The headers, cookies, and query strings that are included in the cache key are automatically
/// included in requests that CloudFront sends to the origin. CloudFront sends a request when it can’t
/// find an object in its cache that matches the request’s cache key. If you want to send
/// values to the origin but <i>not</i> include them in the cache key, use
/// <code>OriginRequestPolicy</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ParametersInCacheKeyAndForwardedToOrigin {
    /// <p>A flag that can affect whether the <code>Accept-Encoding</code> HTTP header is
    /// included in the cache key and included in requests that CloudFront sends to the origin.</p>
    /// <p>This field is related to the <code>EnableAcceptEncodingBrotli</code> field. If one or
    /// both of these fields is <code>true</code>
    /// <i>and</i> the viewer request
    /// includes the <code>Accept-Encoding</code> header, then CloudFront does the following:</p>
    /// <ul>
    /// <li>
    /// <p>Normalizes the value of the viewer’s <code>Accept-Encoding</code>
    /// header</p>
    /// </li>
    /// <li>
    /// <p>Includes the normalized header in the cache key</p>
    /// </li>
    /// <li>
    /// <p>Includes the normalized header in the request to the origin, if a request is necessary</p>
    /// </li>
    /// </ul>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-policy-compressed-objects">Compression support</a> in the
    /// <i>Amazon CloudFront Developer Guide</i>.</p>
    /// <p>If you set this value to <code>true</code>, and this cache behavior also has an origin
    /// request policy attached, do not include the <code>Accept-Encoding</code> header in the
    /// origin request policy. CloudFront always includes the <code>Accept-Encoding</code> header in
    /// origin requests when the value of this field is <code>true</code>, so including this
    /// header in an origin request policy has no effect.</p>
    /// <p>If both of these fields are <code>false</code>, then CloudFront treats the
    /// <code>Accept-Encoding</code> header the same as any other HTTP header in the viewer
    /// request. By default, it’s not included in the cache key and it’s not included in origin
    /// requests. In this case, you can manually add <code>Accept-Encoding</code> to the headers
    /// whitelist like any other HTTP header.</p>
    pub enable_accept_encoding_gzip: std::option::Option<bool>,
    /// <p>A flag that can affect whether the <code>Accept-Encoding</code> HTTP header is
    /// included in the cache key and included in requests that CloudFront sends to the origin.</p>
    /// <p>This field is related to the <code>EnableAcceptEncodingGzip</code> field. If one or
    /// both of these fields is <code>true</code>
    /// <i>and</i> the viewer request
    /// includes the <code>Accept-Encoding</code> header, then CloudFront does the following:</p>
    /// <ul>
    /// <li>
    /// <p>Normalizes the value of the viewer’s <code>Accept-Encoding</code>
    /// header</p>
    /// </li>
    /// <li>
    /// <p>Includes the normalized header in the cache key</p>
    /// </li>
    /// <li>
    /// <p>Includes the normalized header in the request to the origin, if a request is necessary</p>
    /// </li>
    /// </ul>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-policy-compressed-objects">Compression support</a> in the
    /// <i>Amazon CloudFront Developer Guide</i>.</p>
    /// <p>If you set this value to <code>true</code>, and this cache behavior also has an origin
    /// request policy attached, do not include the <code>Accept-Encoding</code> header in the
    /// origin request policy. CloudFront always includes the <code>Accept-Encoding</code> header in
    /// origin requests when the value of this field is <code>true</code>, so including this
    /// header in an origin request policy has no effect.</p>
    /// <p>If both of these fields are <code>false</code>, then CloudFront treats the
    /// <code>Accept-Encoding</code> header the same as any other HTTP header in the viewer
    /// request. By default, it’s not included in the cache key and it’s not included in origin
    /// requests. In this case, you can manually add <code>Accept-Encoding</code> to the headers
    /// whitelist like any other HTTP header.</p>
    pub enable_accept_encoding_brotli: std::option::Option<bool>,
    /// <p>An object that determines whether any HTTP headers (and if so, which headers) are
    /// included in the cache key and automatically included in requests that CloudFront sends to the
    /// origin.</p>
    pub headers_config: std::option::Option<crate::model::CachePolicyHeadersConfig>,
    /// <p>An object that determines whether any cookies in viewer requests (and if so, which cookies)
    /// are included in the cache key and automatically included in requests that CloudFront sends to
    /// the origin.</p>
    pub cookies_config: std::option::Option<crate::model::CachePolicyCookiesConfig>,
    /// <p>An object that determines whether any URL query strings in viewer requests (and if so, which
    /// query strings) are included in the cache key and automatically included in requests that
    /// CloudFront sends to the origin.</p>
    pub query_strings_config: std::option::Option<crate::model::CachePolicyQueryStringsConfig>,
}
impl ParametersInCacheKeyAndForwardedToOrigin {
    /// <p>A flag that can affect whether the <code>Accept-Encoding</code> HTTP header is
    /// included in the cache key and included in requests that CloudFront sends to the origin.</p>
    /// <p>This field is related to the <code>EnableAcceptEncodingBrotli</code> field. If one or
    /// both of these fields is <code>true</code>
    /// <i>and</i> the viewer request
    /// includes the <code>Accept-Encoding</code> header, then CloudFront does the following:</p>
    /// <ul>
    /// <li>
    /// <p>Normalizes the value of the viewer’s <code>Accept-Encoding</code>
    /// header</p>
    /// </li>
    /// <li>
    /// <p>Includes the normalized header in the cache key</p>
    /// </li>
    /// <li>
    /// <p>Includes the normalized header in the request to the origin, if a request is necessary</p>
    /// </li>
    /// </ul>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-policy-compressed-objects">Compression support</a> in the
    /// <i>Amazon CloudFront Developer Guide</i>.</p>
    /// <p>If you set this value to <code>true</code>, and this cache behavior also has an origin
    /// request policy attached, do not include the <code>Accept-Encoding</code> header in the
    /// origin request policy. CloudFront always includes the <code>Accept-Encoding</code> header in
    /// origin requests when the value of this field is <code>true</code>, so including this
    /// header in an origin request policy has no effect.</p>
    /// <p>If both of these fields are <code>false</code>, then CloudFront treats the
    /// <code>Accept-Encoding</code> header the same as any other HTTP header in the viewer
    /// request. By default, it’s not included in the cache key and it’s not included in origin
    /// requests. In this case, you can manually add <code>Accept-Encoding</code> to the headers
    /// whitelist like any other HTTP header.</p>
    pub fn enable_accept_encoding_gzip(&self) -> std::option::Option<bool> {
        self.enable_accept_encoding_gzip
    }
    /// <p>A flag that can affect whether the <code>Accept-Encoding</code> HTTP header is
    /// included in the cache key and included in requests that CloudFront sends to the origin.</p>
    /// <p>This field is related to the <code>EnableAcceptEncodingGzip</code> field. If one or
    /// both of these fields is <code>true</code>
    /// <i>and</i> the viewer request
    /// includes the <code>Accept-Encoding</code> header, then CloudFront does the following:</p>
    /// <ul>
    /// <li>
    /// <p>Normalizes the value of the viewer’s <code>Accept-Encoding</code>
    /// header</p>
    /// </li>
    /// <li>
    /// <p>Includes the normalized header in the cache key</p>
    /// </li>
    /// <li>
    /// <p>Includes the normalized header in the request to the origin, if a request is necessary</p>
    /// </li>
    /// </ul>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-policy-compressed-objects">Compression support</a> in the
    /// <i>Amazon CloudFront Developer Guide</i>.</p>
    /// <p>If you set this value to <code>true</code>, and this cache behavior also has an origin
    /// request policy attached, do not include the <code>Accept-Encoding</code> header in the
    /// origin request policy. CloudFront always includes the <code>Accept-Encoding</code> header in
    /// origin requests when the value of this field is <code>true</code>, so including this
    /// header in an origin request policy has no effect.</p>
    /// <p>If both of these fields are <code>false</code>, then CloudFront treats the
    /// <code>Accept-Encoding</code> header the same as any other HTTP header in the viewer
    /// request. By default, it’s not included in the cache key and it’s not included in origin
    /// requests. In this case, you can manually add <code>Accept-Encoding</code> to the headers
    /// whitelist like any other HTTP header.</p>
    pub fn enable_accept_encoding_brotli(&self) -> std::option::Option<bool> {
        self.enable_accept_encoding_brotli
    }
    /// <p>An object that determines whether any HTTP headers (and if so, which headers) are
    /// included in the cache key and automatically included in requests that CloudFront sends to the
    /// origin.</p>
    pub fn headers_config(&self) -> std::option::Option<&crate::model::CachePolicyHeadersConfig> {
        self.headers_config.as_ref()
    }
    /// <p>An object that determines whether any cookies in viewer requests (and if so, which cookies)
    /// are included in the cache key and automatically included in requests that CloudFront sends to
    /// the origin.</p>
    pub fn cookies_config(&self) -> std::option::Option<&crate::model::CachePolicyCookiesConfig> {
        self.cookies_config.as_ref()
    }
    /// <p>An object that determines whether any URL query strings in viewer requests (and if so, which
    /// query strings) are included in the cache key and automatically included in requests that
    /// CloudFront sends to the origin.</p>
    pub fn query_strings_config(
        &self,
    ) -> std::option::Option<&crate::model::CachePolicyQueryStringsConfig> {
        self.query_strings_config.as_ref()
    }
}
impl std::fmt::Debug for ParametersInCacheKeyAndForwardedToOrigin {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ParametersInCacheKeyAndForwardedToOrigin");
        formatter.field(
            "enable_accept_encoding_gzip",
            &self.enable_accept_encoding_gzip,
        );
        formatter.field(
            "enable_accept_encoding_brotli",
            &self.enable_accept_encoding_brotli,
        );
        formatter.field("headers_config", &self.headers_config);
        formatter.field("cookies_config", &self.cookies_config);
        formatter.field("query_strings_config", &self.query_strings_config);
        formatter.finish()
    }
}
/// See [`ParametersInCacheKeyAndForwardedToOrigin`](crate::model::ParametersInCacheKeyAndForwardedToOrigin)
pub mod parameters_in_cache_key_and_forwarded_to_origin {
    /// A builder for [`ParametersInCacheKeyAndForwardedToOrigin`](crate::model::ParametersInCacheKeyAndForwardedToOrigin)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) enable_accept_encoding_gzip: std::option::Option<bool>,
        pub(crate) enable_accept_encoding_brotli: std::option::Option<bool>,
        pub(crate) headers_config: std::option::Option<crate::model::CachePolicyHeadersConfig>,
        pub(crate) cookies_config: std::option::Option<crate::model::CachePolicyCookiesConfig>,
        pub(crate) query_strings_config:
            std::option::Option<crate::model::CachePolicyQueryStringsConfig>,
    }
    impl Builder {
        /// <p>A flag that can affect whether the <code>Accept-Encoding</code> HTTP header is
        /// included in the cache key and included in requests that CloudFront sends to the origin.</p>
        /// <p>This field is related to the <code>EnableAcceptEncodingBrotli</code> field. If one or
        /// both of these fields is <code>true</code>
        /// <i>and</i> the viewer request
        /// includes the <code>Accept-Encoding</code> header, then CloudFront does the following:</p>
        /// <ul>
        /// <li>
        /// <p>Normalizes the value of the viewer’s <code>Accept-Encoding</code>
        /// header</p>
        /// </li>
        /// <li>
        /// <p>Includes the normalized header in the cache key</p>
        /// </li>
        /// <li>
        /// <p>Includes the normalized header in the request to the origin, if a request is necessary</p>
        /// </li>
        /// </ul>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-policy-compressed-objects">Compression support</a> in the
        /// <i>Amazon CloudFront Developer Guide</i>.</p>
        /// <p>If you set this value to <code>true</code>, and this cache behavior also has an origin
        /// request policy attached, do not include the <code>Accept-Encoding</code> header in the
        /// origin request policy. CloudFront always includes the <code>Accept-Encoding</code> header in
        /// origin requests when the value of this field is <code>true</code>, so including this
        /// header in an origin request policy has no effect.</p>
        /// <p>If both of these fields are <code>false</code>, then CloudFront treats the
        /// <code>Accept-Encoding</code> header the same as any other HTTP header in the viewer
        /// request. By default, it’s not included in the cache key and it’s not included in origin
        /// requests. In this case, you can manually add <code>Accept-Encoding</code> to the headers
        /// whitelist like any other HTTP header.</p>
        pub fn enable_accept_encoding_gzip(mut self, input: bool) -> Self {
            self.enable_accept_encoding_gzip = Some(input);
            self
        }
        /// <p>A flag that can affect whether the <code>Accept-Encoding</code> HTTP header is
        /// included in the cache key and included in requests that CloudFront sends to the origin.</p>
        /// <p>This field is related to the <code>EnableAcceptEncodingBrotli</code> field. If one or
        /// both of these fields is <code>true</code>
        /// <i>and</i> the viewer request
        /// includes the <code>Accept-Encoding</code> header, then CloudFront does the following:</p>
        /// <ul>
        /// <li>
        /// <p>Normalizes the value of the viewer’s <code>Accept-Encoding</code>
        /// header</p>
        /// </li>
        /// <li>
        /// <p>Includes the normalized header in the cache key</p>
        /// </li>
        /// <li>
        /// <p>Includes the normalized header in the request to the origin, if a request is necessary</p>
        /// </li>
        /// </ul>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-policy-compressed-objects">Compression support</a> in the
        /// <i>Amazon CloudFront Developer Guide</i>.</p>
        /// <p>If you set this value to <code>true</code>, and this cache behavior also has an origin
        /// request policy attached, do not include the <code>Accept-Encoding</code> header in the
        /// origin request policy. CloudFront always includes the <code>Accept-Encoding</code> header in
        /// origin requests when the value of this field is <code>true</code>, so including this
        /// header in an origin request policy has no effect.</p>
        /// <p>If both of these fields are <code>false</code>, then CloudFront treats the
        /// <code>Accept-Encoding</code> header the same as any other HTTP header in the viewer
        /// request. By default, it’s not included in the cache key and it’s not included in origin
        /// requests. In this case, you can manually add <code>Accept-Encoding</code> to the headers
        /// whitelist like any other HTTP header.</p>
        pub fn set_enable_accept_encoding_gzip(mut self, input: std::option::Option<bool>) -> Self {
            self.enable_accept_encoding_gzip = input;
            self
        }
        /// <p>A flag that can affect whether the <code>Accept-Encoding</code> HTTP header is
        /// included in the cache key and included in requests that CloudFront sends to the origin.</p>
        /// <p>This field is related to the <code>EnableAcceptEncodingGzip</code> field. If one or
        /// both of these fields is <code>true</code>
        /// <i>and</i> the viewer request
        /// includes the <code>Accept-Encoding</code> header, then CloudFront does the following:</p>
        /// <ul>
        /// <li>
        /// <p>Normalizes the value of the viewer’s <code>Accept-Encoding</code>
        /// header</p>
        /// </li>
        /// <li>
        /// <p>Includes the normalized header in the cache key</p>
        /// </li>
        /// <li>
        /// <p>Includes the normalized header in the request to the origin, if a request is necessary</p>
        /// </li>
        /// </ul>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-policy-compressed-objects">Compression support</a> in the
        /// <i>Amazon CloudFront Developer Guide</i>.</p>
        /// <p>If you set this value to <code>true</code>, and this cache behavior also has an origin
        /// request policy attached, do not include the <code>Accept-Encoding</code> header in the
        /// origin request policy. CloudFront always includes the <code>Accept-Encoding</code> header in
        /// origin requests when the value of this field is <code>true</code>, so including this
        /// header in an origin request policy has no effect.</p>
        /// <p>If both of these fields are <code>false</code>, then CloudFront treats the
        /// <code>Accept-Encoding</code> header the same as any other HTTP header in the viewer
        /// request. By default, it’s not included in the cache key and it’s not included in origin
        /// requests. In this case, you can manually add <code>Accept-Encoding</code> to the headers
        /// whitelist like any other HTTP header.</p>
        pub fn enable_accept_encoding_brotli(mut self, input: bool) -> Self {
            self.enable_accept_encoding_brotli = Some(input);
            self
        }
        /// <p>A flag that can affect whether the <code>Accept-Encoding</code> HTTP header is
        /// included in the cache key and included in requests that CloudFront sends to the origin.</p>
        /// <p>This field is related to the <code>EnableAcceptEncodingGzip</code> field. If one or
        /// both of these fields is <code>true</code>
        /// <i>and</i> the viewer request
        /// includes the <code>Accept-Encoding</code> header, then CloudFront does the following:</p>
        /// <ul>
        /// <li>
        /// <p>Normalizes the value of the viewer’s <code>Accept-Encoding</code>
        /// header</p>
        /// </li>
        /// <li>
        /// <p>Includes the normalized header in the cache key</p>
        /// </li>
        /// <li>
        /// <p>Includes the normalized header in the request to the origin, if a request is necessary</p>
        /// </li>
        /// </ul>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-policy-compressed-objects">Compression support</a> in the
        /// <i>Amazon CloudFront Developer Guide</i>.</p>
        /// <p>If you set this value to <code>true</code>, and this cache behavior also has an origin
        /// request policy attached, do not include the <code>Accept-Encoding</code> header in the
        /// origin request policy. CloudFront always includes the <code>Accept-Encoding</code> header in
        /// origin requests when the value of this field is <code>true</code>, so including this
        /// header in an origin request policy has no effect.</p>
        /// <p>If both of these fields are <code>false</code>, then CloudFront treats the
        /// <code>Accept-Encoding</code> header the same as any other HTTP header in the viewer
        /// request. By default, it’s not included in the cache key and it’s not included in origin
        /// requests. In this case, you can manually add <code>Accept-Encoding</code> to the headers
        /// whitelist like any other HTTP header.</p>
        pub fn set_enable_accept_encoding_brotli(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.enable_accept_encoding_brotli = input;
            self
        }
        /// <p>An object that determines whether any HTTP headers (and if so, which headers) are
        /// included in the cache key and automatically included in requests that CloudFront sends to the
        /// origin.</p>
        pub fn headers_config(mut self, input: crate::model::CachePolicyHeadersConfig) -> Self {
            self.headers_config = Some(input);
            self
        }
        /// <p>An object that determines whether any HTTP headers (and if so, which headers) are
        /// included in the cache key and automatically included in requests that CloudFront sends to the
        /// origin.</p>
        pub fn set_headers_config(
            mut self,
            input: std::option::Option<crate::model::CachePolicyHeadersConfig>,
        ) -> Self {
            self.headers_config = input;
            self
        }
        /// <p>An object that determines whether any cookies in viewer requests (and if so, which cookies)
        /// are included in the cache key and automatically included in requests that CloudFront sends to
        /// the origin.</p>
        pub fn cookies_config(mut self, input: crate::model::CachePolicyCookiesConfig) -> Self {
            self.cookies_config = Some(input);
            self
        }
        /// <p>An object that determines whether any cookies in viewer requests (and if so, which cookies)
        /// are included in the cache key and automatically included in requests that CloudFront sends to
        /// the origin.</p>
        pub fn set_cookies_config(
            mut self,
            input: std::option::Option<crate::model::CachePolicyCookiesConfig>,
        ) -> Self {
            self.cookies_config = input;
            self
        }
        /// <p>An object that determines whether any URL query strings in viewer requests (and if so, which
        /// query strings) are included in the cache key and automatically included in requests that
        /// CloudFront sends to the origin.</p>
        pub fn query_strings_config(
            mut self,
            input: crate::model::CachePolicyQueryStringsConfig,
        ) -> Self {
            self.query_strings_config = Some(input);
            self
        }
        /// <p>An object that determines whether any URL query strings in viewer requests (and if so, which
        /// query strings) are included in the cache key and automatically included in requests that
        /// CloudFront sends to the origin.</p>
        pub fn set_query_strings_config(
            mut self,
            input: std::option::Option<crate::model::CachePolicyQueryStringsConfig>,
        ) -> Self {
            self.query_strings_config = input;
            self
        }
        /// Consumes the builder and constructs a [`ParametersInCacheKeyAndForwardedToOrigin`](crate::model::ParametersInCacheKeyAndForwardedToOrigin)
        pub fn build(self) -> crate::model::ParametersInCacheKeyAndForwardedToOrigin {
            crate::model::ParametersInCacheKeyAndForwardedToOrigin {
                enable_accept_encoding_gzip: self.enable_accept_encoding_gzip,
                enable_accept_encoding_brotli: self.enable_accept_encoding_brotli,
                headers_config: self.headers_config,
                cookies_config: self.cookies_config,
                query_strings_config: self.query_strings_config,
            }
        }
    }
}
impl ParametersInCacheKeyAndForwardedToOrigin {
    /// Creates a new builder-style object to manufacture [`ParametersInCacheKeyAndForwardedToOrigin`](crate::model::ParametersInCacheKeyAndForwardedToOrigin)
    pub fn builder() -> crate::model::parameters_in_cache_key_and_forwarded_to_origin::Builder {
        crate::model::parameters_in_cache_key_and_forwarded_to_origin::Builder::default()
    }
}

/// <p>An object that determines whether any URL query strings in viewer requests (and if so, which
/// query strings) are included in the cache key and automatically included in requests that
/// CloudFront sends to the origin.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CachePolicyQueryStringsConfig {
    /// <p>Determines whether any URL query strings in viewer requests are included in the cache key
    /// and automatically included in requests that CloudFront sends to the origin. Valid values
    /// are:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>none</code> – Query strings in viewer requests are not included in the cache key and
    /// are not automatically included in requests that CloudFront sends to the origin. Even
    /// when this field is set to <code>none</code>, any query strings that are listed
    /// in an <code>OriginRequestPolicy</code>
    /// <i>are</i> included in
    /// origin requests.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>whitelist</code> – The query strings in viewer requests that are listed in the
    /// <code>QueryStringNames</code> type are included in the cache key and
    /// automatically included in requests that CloudFront sends to the origin.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>allExcept</code> – All query strings in viewer requests that are <i>
    /// <b>not</b>
    /// </i> listed in the
    /// <code>QueryStringNames</code> type are included in the cache key and
    /// automatically included in requests that CloudFront sends to the origin.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>all</code> – All query strings in viewer requests are included in the cache key and
    /// are automatically included in requests that CloudFront sends to the origin.</p>
    /// </li>
    /// </ul>
    pub query_string_behavior: std::option::Option<crate::model::CachePolicyQueryStringBehavior>,
    /// <p>Contains the specific query strings in viewer requests that either <i>
    /// <b>are</b>
    /// </i> or <i>
    /// <b>are
    /// not</b>
    /// </i> included in the cache key and automatically included in
    /// requests that CloudFront sends to the origin. The behavior depends on whether the
    /// <code>QueryStringBehavior</code> field in the <code>CachePolicyQueryStringsConfig</code>
    /// type is set to <code>whitelist</code> (the listed query strings <i>
    /// <b>are</b>
    /// </i> included) or <code>allExcept</code> (the listed
    /// query strings <i>
    /// <b>are not</b>
    /// </i> included,
    /// but all other query strings are).</p>
    pub query_strings: std::option::Option<crate::model::QueryStringNames>,
}
impl CachePolicyQueryStringsConfig {
    /// <p>Determines whether any URL query strings in viewer requests are included in the cache key
    /// and automatically included in requests that CloudFront sends to the origin. Valid values
    /// are:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>none</code> – Query strings in viewer requests are not included in the cache key and
    /// are not automatically included in requests that CloudFront sends to the origin. Even
    /// when this field is set to <code>none</code>, any query strings that are listed
    /// in an <code>OriginRequestPolicy</code>
    /// <i>are</i> included in
    /// origin requests.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>whitelist</code> – The query strings in viewer requests that are listed in the
    /// <code>QueryStringNames</code> type are included in the cache key and
    /// automatically included in requests that CloudFront sends to the origin.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>allExcept</code> – All query strings in viewer requests that are <i>
    /// <b>not</b>
    /// </i> listed in the
    /// <code>QueryStringNames</code> type are included in the cache key and
    /// automatically included in requests that CloudFront sends to the origin.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>all</code> – All query strings in viewer requests are included in the cache key and
    /// are automatically included in requests that CloudFront sends to the origin.</p>
    /// </li>
    /// </ul>
    pub fn query_string_behavior(
        &self,
    ) -> std::option::Option<&crate::model::CachePolicyQueryStringBehavior> {
        self.query_string_behavior.as_ref()
    }
    /// <p>Contains the specific query strings in viewer requests that either <i>
    /// <b>are</b>
    /// </i> or <i>
    /// <b>are
    /// not</b>
    /// </i> included in the cache key and automatically included in
    /// requests that CloudFront sends to the origin. The behavior depends on whether the
    /// <code>QueryStringBehavior</code> field in the <code>CachePolicyQueryStringsConfig</code>
    /// type is set to <code>whitelist</code> (the listed query strings <i>
    /// <b>are</b>
    /// </i> included) or <code>allExcept</code> (the listed
    /// query strings <i>
    /// <b>are not</b>
    /// </i> included,
    /// but all other query strings are).</p>
    pub fn query_strings(&self) -> std::option::Option<&crate::model::QueryStringNames> {
        self.query_strings.as_ref()
    }
}
impl std::fmt::Debug for CachePolicyQueryStringsConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CachePolicyQueryStringsConfig");
        formatter.field("query_string_behavior", &self.query_string_behavior);
        formatter.field("query_strings", &self.query_strings);
        formatter.finish()
    }
}
/// See [`CachePolicyQueryStringsConfig`](crate::model::CachePolicyQueryStringsConfig)
pub mod cache_policy_query_strings_config {
    /// A builder for [`CachePolicyQueryStringsConfig`](crate::model::CachePolicyQueryStringsConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) query_string_behavior:
            std::option::Option<crate::model::CachePolicyQueryStringBehavior>,
        pub(crate) query_strings: std::option::Option<crate::model::QueryStringNames>,
    }
    impl Builder {
        /// <p>Determines whether any URL query strings in viewer requests are included in the cache key
        /// and automatically included in requests that CloudFront sends to the origin. Valid values
        /// are:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>none</code> – Query strings in viewer requests are not included in the cache key and
        /// are not automatically included in requests that CloudFront sends to the origin. Even
        /// when this field is set to <code>none</code>, any query strings that are listed
        /// in an <code>OriginRequestPolicy</code>
        /// <i>are</i> included in
        /// origin requests.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>whitelist</code> – The query strings in viewer requests that are listed in the
        /// <code>QueryStringNames</code> type are included in the cache key and
        /// automatically included in requests that CloudFront sends to the origin.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>allExcept</code> – All query strings in viewer requests that are <i>
        /// <b>not</b>
        /// </i> listed in the
        /// <code>QueryStringNames</code> type are included in the cache key and
        /// automatically included in requests that CloudFront sends to the origin.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>all</code> – All query strings in viewer requests are included in the cache key and
        /// are automatically included in requests that CloudFront sends to the origin.</p>
        /// </li>
        /// </ul>
        pub fn query_string_behavior(
            mut self,
            input: crate::model::CachePolicyQueryStringBehavior,
        ) -> Self {
            self.query_string_behavior = Some(input);
            self
        }
        /// <p>Determines whether any URL query strings in viewer requests are included in the cache key
        /// and automatically included in requests that CloudFront sends to the origin. Valid values
        /// are:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>none</code> – Query strings in viewer requests are not included in the cache key and
        /// are not automatically included in requests that CloudFront sends to the origin. Even
        /// when this field is set to <code>none</code>, any query strings that are listed
        /// in an <code>OriginRequestPolicy</code>
        /// <i>are</i> included in
        /// origin requests.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>whitelist</code> – The query strings in viewer requests that are listed in the
        /// <code>QueryStringNames</code> type are included in the cache key and
        /// automatically included in requests that CloudFront sends to the origin.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>allExcept</code> – All query strings in viewer requests that are <i>
        /// <b>not</b>
        /// </i> listed in the
        /// <code>QueryStringNames</code> type are included in the cache key and
        /// automatically included in requests that CloudFront sends to the origin.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>all</code> – All query strings in viewer requests are included in the cache key and
        /// are automatically included in requests that CloudFront sends to the origin.</p>
        /// </li>
        /// </ul>
        pub fn set_query_string_behavior(
            mut self,
            input: std::option::Option<crate::model::CachePolicyQueryStringBehavior>,
        ) -> Self {
            self.query_string_behavior = input;
            self
        }
        /// <p>Contains the specific query strings in viewer requests that either <i>
        /// <b>are</b>
        /// </i> or <i>
        /// <b>are
        /// not</b>
        /// </i> included in the cache key and automatically included in
        /// requests that CloudFront sends to the origin. The behavior depends on whether the
        /// <code>QueryStringBehavior</code> field in the <code>CachePolicyQueryStringsConfig</code>
        /// type is set to <code>whitelist</code> (the listed query strings <i>
        /// <b>are</b>
        /// </i> included) or <code>allExcept</code> (the listed
        /// query strings <i>
        /// <b>are not</b>
        /// </i> included,
        /// but all other query strings are).</p>
        pub fn query_strings(mut self, input: crate::model::QueryStringNames) -> Self {
            self.query_strings = Some(input);
            self
        }
        /// <p>Contains the specific query strings in viewer requests that either <i>
        /// <b>are</b>
        /// </i> or <i>
        /// <b>are
        /// not</b>
        /// </i> included in the cache key and automatically included in
        /// requests that CloudFront sends to the origin. The behavior depends on whether the
        /// <code>QueryStringBehavior</code> field in the <code>CachePolicyQueryStringsConfig</code>
        /// type is set to <code>whitelist</code> (the listed query strings <i>
        /// <b>are</b>
        /// </i> included) or <code>allExcept</code> (the listed
        /// query strings <i>
        /// <b>are not</b>
        /// </i> included,
        /// but all other query strings are).</p>
        pub fn set_query_strings(
            mut self,
            input: std::option::Option<crate::model::QueryStringNames>,
        ) -> Self {
            self.query_strings = input;
            self
        }
        /// Consumes the builder and constructs a [`CachePolicyQueryStringsConfig`](crate::model::CachePolicyQueryStringsConfig)
        pub fn build(self) -> crate::model::CachePolicyQueryStringsConfig {
            crate::model::CachePolicyQueryStringsConfig {
                query_string_behavior: self.query_string_behavior,
                query_strings: self.query_strings,
            }
        }
    }
}
impl CachePolicyQueryStringsConfig {
    /// Creates a new builder-style object to manufacture [`CachePolicyQueryStringsConfig`](crate::model::CachePolicyQueryStringsConfig)
    pub fn builder() -> crate::model::cache_policy_query_strings_config::Builder {
        crate::model::cache_policy_query_strings_config::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum CachePolicyQueryStringBehavior {
    #[allow(missing_docs)] // documentation missing in model
    All,
    #[allow(missing_docs)] // documentation missing in model
    AllExcept,
    #[allow(missing_docs)] // documentation missing in model
    None,
    #[allow(missing_docs)] // documentation missing in model
    Whitelist,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for CachePolicyQueryStringBehavior {
    fn from(s: &str) -> Self {
        match s {
            "all" => CachePolicyQueryStringBehavior::All,
            "allExcept" => CachePolicyQueryStringBehavior::AllExcept,
            "none" => CachePolicyQueryStringBehavior::None,
            "whitelist" => CachePolicyQueryStringBehavior::Whitelist,
            other => CachePolicyQueryStringBehavior::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for CachePolicyQueryStringBehavior {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(CachePolicyQueryStringBehavior::from(s))
    }
}
impl CachePolicyQueryStringBehavior {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            CachePolicyQueryStringBehavior::All => "all",
            CachePolicyQueryStringBehavior::AllExcept => "allExcept",
            CachePolicyQueryStringBehavior::None => "none",
            CachePolicyQueryStringBehavior::Whitelist => "whitelist",
            CachePolicyQueryStringBehavior::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["all", "allExcept", "none", "whitelist"]
    }
}
impl AsRef<str> for CachePolicyQueryStringBehavior {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>An object that determines whether any cookies in viewer requests (and if so, which cookies)
/// are included in the cache key and automatically included in requests that CloudFront sends to
/// the origin.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CachePolicyCookiesConfig {
    /// <p>Determines whether any cookies in viewer requests are included in the cache key and
    /// automatically included in requests that CloudFront sends to the origin. Valid values
    /// are:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>none</code> – Cookies in viewer requests are not included in the cache key and are
    /// not automatically included in requests that CloudFront sends to the origin. Even when
    /// this field is set to <code>none</code>, any cookies that are listed in an
    /// <code>OriginRequestPolicy</code>
    /// <i>are</i> included in origin
    /// requests.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>whitelist</code> – The cookies in viewer requests that are listed in the
    /// <code>CookieNames</code> type are included in the cache key and automatically
    /// included in requests that CloudFront sends to the origin.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>allExcept</code> – All cookies in viewer requests that are <i>
    /// <b>not</b>
    /// </i> listed in the <code>CookieNames</code>
    /// type are included in the cache key and automatically included in requests that
    /// CloudFront sends to the origin.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>all</code> – All cookies in viewer requests are included in the cache key and are
    /// automatically included in requests that CloudFront sends to the origin.</p>
    /// </li>
    /// </ul>
    pub cookie_behavior: std::option::Option<crate::model::CachePolicyCookieBehavior>,
    /// <p>Contains a list of cookie names.</p>
    pub cookies: std::option::Option<crate::model::CookieNames>,
}
impl CachePolicyCookiesConfig {
    /// <p>Determines whether any cookies in viewer requests are included in the cache key and
    /// automatically included in requests that CloudFront sends to the origin. Valid values
    /// are:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>none</code> – Cookies in viewer requests are not included in the cache key and are
    /// not automatically included in requests that CloudFront sends to the origin. Even when
    /// this field is set to <code>none</code>, any cookies that are listed in an
    /// <code>OriginRequestPolicy</code>
    /// <i>are</i> included in origin
    /// requests.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>whitelist</code> – The cookies in viewer requests that are listed in the
    /// <code>CookieNames</code> type are included in the cache key and automatically
    /// included in requests that CloudFront sends to the origin.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>allExcept</code> – All cookies in viewer requests that are <i>
    /// <b>not</b>
    /// </i> listed in the <code>CookieNames</code>
    /// type are included in the cache key and automatically included in requests that
    /// CloudFront sends to the origin.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>all</code> – All cookies in viewer requests are included in the cache key and are
    /// automatically included in requests that CloudFront sends to the origin.</p>
    /// </li>
    /// </ul>
    pub fn cookie_behavior(&self) -> std::option::Option<&crate::model::CachePolicyCookieBehavior> {
        self.cookie_behavior.as_ref()
    }
    /// <p>Contains a list of cookie names.</p>
    pub fn cookies(&self) -> std::option::Option<&crate::model::CookieNames> {
        self.cookies.as_ref()
    }
}
impl std::fmt::Debug for CachePolicyCookiesConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CachePolicyCookiesConfig");
        formatter.field("cookie_behavior", &self.cookie_behavior);
        formatter.field("cookies", &self.cookies);
        formatter.finish()
    }
}
/// See [`CachePolicyCookiesConfig`](crate::model::CachePolicyCookiesConfig)
pub mod cache_policy_cookies_config {
    /// A builder for [`CachePolicyCookiesConfig`](crate::model::CachePolicyCookiesConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cookie_behavior: std::option::Option<crate::model::CachePolicyCookieBehavior>,
        pub(crate) cookies: std::option::Option<crate::model::CookieNames>,
    }
    impl Builder {
        /// <p>Determines whether any cookies in viewer requests are included in the cache key and
        /// automatically included in requests that CloudFront sends to the origin. Valid values
        /// are:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>none</code> – Cookies in viewer requests are not included in the cache key and are
        /// not automatically included in requests that CloudFront sends to the origin. Even when
        /// this field is set to <code>none</code>, any cookies that are listed in an
        /// <code>OriginRequestPolicy</code>
        /// <i>are</i> included in origin
        /// requests.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>whitelist</code> – The cookies in viewer requests that are listed in the
        /// <code>CookieNames</code> type are included in the cache key and automatically
        /// included in requests that CloudFront sends to the origin.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>allExcept</code> – All cookies in viewer requests that are <i>
        /// <b>not</b>
        /// </i> listed in the <code>CookieNames</code>
        /// type are included in the cache key and automatically included in requests that
        /// CloudFront sends to the origin.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>all</code> – All cookies in viewer requests are included in the cache key and are
        /// automatically included in requests that CloudFront sends to the origin.</p>
        /// </li>
        /// </ul>
        pub fn cookie_behavior(mut self, input: crate::model::CachePolicyCookieBehavior) -> Self {
            self.cookie_behavior = Some(input);
            self
        }
        /// <p>Determines whether any cookies in viewer requests are included in the cache key and
        /// automatically included in requests that CloudFront sends to the origin. Valid values
        /// are:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>none</code> – Cookies in viewer requests are not included in the cache key and are
        /// not automatically included in requests that CloudFront sends to the origin. Even when
        /// this field is set to <code>none</code>, any cookies that are listed in an
        /// <code>OriginRequestPolicy</code>
        /// <i>are</i> included in origin
        /// requests.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>whitelist</code> – The cookies in viewer requests that are listed in the
        /// <code>CookieNames</code> type are included in the cache key and automatically
        /// included in requests that CloudFront sends to the origin.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>allExcept</code> – All cookies in viewer requests that are <i>
        /// <b>not</b>
        /// </i> listed in the <code>CookieNames</code>
        /// type are included in the cache key and automatically included in requests that
        /// CloudFront sends to the origin.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>all</code> – All cookies in viewer requests are included in the cache key and are
        /// automatically included in requests that CloudFront sends to the origin.</p>
        /// </li>
        /// </ul>
        pub fn set_cookie_behavior(
            mut self,
            input: std::option::Option<crate::model::CachePolicyCookieBehavior>,
        ) -> Self {
            self.cookie_behavior = input;
            self
        }
        /// <p>Contains a list of cookie names.</p>
        pub fn cookies(mut self, input: crate::model::CookieNames) -> Self {
            self.cookies = Some(input);
            self
        }
        /// <p>Contains a list of cookie names.</p>
        pub fn set_cookies(
            mut self,
            input: std::option::Option<crate::model::CookieNames>,
        ) -> Self {
            self.cookies = input;
            self
        }
        /// Consumes the builder and constructs a [`CachePolicyCookiesConfig`](crate::model::CachePolicyCookiesConfig)
        pub fn build(self) -> crate::model::CachePolicyCookiesConfig {
            crate::model::CachePolicyCookiesConfig {
                cookie_behavior: self.cookie_behavior,
                cookies: self.cookies,
            }
        }
    }
}
impl CachePolicyCookiesConfig {
    /// Creates a new builder-style object to manufacture [`CachePolicyCookiesConfig`](crate::model::CachePolicyCookiesConfig)
    pub fn builder() -> crate::model::cache_policy_cookies_config::Builder {
        crate::model::cache_policy_cookies_config::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum CachePolicyCookieBehavior {
    #[allow(missing_docs)] // documentation missing in model
    All,
    #[allow(missing_docs)] // documentation missing in model
    AllExcept,
    #[allow(missing_docs)] // documentation missing in model
    None,
    #[allow(missing_docs)] // documentation missing in model
    Whitelist,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for CachePolicyCookieBehavior {
    fn from(s: &str) -> Self {
        match s {
            "all" => CachePolicyCookieBehavior::All,
            "allExcept" => CachePolicyCookieBehavior::AllExcept,
            "none" => CachePolicyCookieBehavior::None,
            "whitelist" => CachePolicyCookieBehavior::Whitelist,
            other => CachePolicyCookieBehavior::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for CachePolicyCookieBehavior {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(CachePolicyCookieBehavior::from(s))
    }
}
impl CachePolicyCookieBehavior {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            CachePolicyCookieBehavior::All => "all",
            CachePolicyCookieBehavior::AllExcept => "allExcept",
            CachePolicyCookieBehavior::None => "none",
            CachePolicyCookieBehavior::Whitelist => "whitelist",
            CachePolicyCookieBehavior::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["all", "allExcept", "none", "whitelist"]
    }
}
impl AsRef<str> for CachePolicyCookieBehavior {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>An object that determines whether any HTTP headers (and if so, which headers) are included
/// in the cache key and automatically included in requests that CloudFront sends to the
/// origin.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CachePolicyHeadersConfig {
    /// <p>Determines whether any HTTP headers are included in the cache key and automatically
    /// included in requests that CloudFront sends to the origin. Valid values are:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>none</code> – HTTP headers are not included in the cache key and are not
    /// automatically included in requests that CloudFront sends to the origin. Even when this
    /// field is set to <code>none</code>, any headers that are listed in an
    /// <code>OriginRequestPolicy</code>
    /// <i>are</i> included in origin
    /// requests.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>whitelist</code> – The HTTP headers that are listed in the <code>Headers</code> type
    /// are included in the cache key and are automatically included in requests that
    /// CloudFront sends to the origin.</p>
    /// </li>
    /// </ul>
    pub header_behavior: std::option::Option<crate::model::CachePolicyHeaderBehavior>,
    /// <p>Contains a list of HTTP header names.</p>
    pub headers: std::option::Option<crate::model::Headers>,
}
impl CachePolicyHeadersConfig {
    /// <p>Determines whether any HTTP headers are included in the cache key and automatically
    /// included in requests that CloudFront sends to the origin. Valid values are:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>none</code> – HTTP headers are not included in the cache key and are not
    /// automatically included in requests that CloudFront sends to the origin. Even when this
    /// field is set to <code>none</code>, any headers that are listed in an
    /// <code>OriginRequestPolicy</code>
    /// <i>are</i> included in origin
    /// requests.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>whitelist</code> – The HTTP headers that are listed in the <code>Headers</code> type
    /// are included in the cache key and are automatically included in requests that
    /// CloudFront sends to the origin.</p>
    /// </li>
    /// </ul>
    pub fn header_behavior(&self) -> std::option::Option<&crate::model::CachePolicyHeaderBehavior> {
        self.header_behavior.as_ref()
    }
    /// <p>Contains a list of HTTP header names.</p>
    pub fn headers(&self) -> std::option::Option<&crate::model::Headers> {
        self.headers.as_ref()
    }
}
impl std::fmt::Debug for CachePolicyHeadersConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CachePolicyHeadersConfig");
        formatter.field("header_behavior", &self.header_behavior);
        formatter.field("headers", &self.headers);
        formatter.finish()
    }
}
/// See [`CachePolicyHeadersConfig`](crate::model::CachePolicyHeadersConfig)
pub mod cache_policy_headers_config {
    /// A builder for [`CachePolicyHeadersConfig`](crate::model::CachePolicyHeadersConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) header_behavior: std::option::Option<crate::model::CachePolicyHeaderBehavior>,
        pub(crate) headers: std::option::Option<crate::model::Headers>,
    }
    impl Builder {
        /// <p>Determines whether any HTTP headers are included in the cache key and automatically
        /// included in requests that CloudFront sends to the origin. Valid values are:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>none</code> – HTTP headers are not included in the cache key and are not
        /// automatically included in requests that CloudFront sends to the origin. Even when this
        /// field is set to <code>none</code>, any headers that are listed in an
        /// <code>OriginRequestPolicy</code>
        /// <i>are</i> included in origin
        /// requests.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>whitelist</code> – The HTTP headers that are listed in the <code>Headers</code> type
        /// are included in the cache key and are automatically included in requests that
        /// CloudFront sends to the origin.</p>
        /// </li>
        /// </ul>
        pub fn header_behavior(mut self, input: crate::model::CachePolicyHeaderBehavior) -> Self {
            self.header_behavior = Some(input);
            self
        }
        /// <p>Determines whether any HTTP headers are included in the cache key and automatically
        /// included in requests that CloudFront sends to the origin. Valid values are:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>none</code> – HTTP headers are not included in the cache key and are not
        /// automatically included in requests that C