// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Operation shape for `AssociateAlias`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`associate_alias`](crate::client::Client::associate_alias).
///
/// See [`crate::client::fluent_builders::AssociateAlias`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct AssociateAlias {
    _private: (),
}
impl AssociateAlias {
    /// Creates a new builder-style object to manufacture [`AssociateAliasInput`](crate::input::AssociateAliasInput)
    pub fn builder() -> crate::input::associate_alias_input::Builder {
        crate::input::associate_alias_input::Builder::default()
    }
    /// Creates a new `AssociateAlias` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for AssociateAlias {
    type Output =
        std::result::Result<crate::output::AssociateAliasOutput, crate::error::AssociateAliasError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_associate_alias_error(response)
        } else {
            crate::operation_deser::parse_associate_alias_response(response)
        }
    }
}

/// Operation shape for `CreateCachePolicy`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_cache_policy`](crate::client::Client::create_cache_policy).
///
/// See [`crate::client::fluent_builders::CreateCachePolicy`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateCachePolicy {
    _private: (),
}
impl CreateCachePolicy {
    /// Creates a new builder-style object to manufacture [`CreateCachePolicyInput`](crate::input::CreateCachePolicyInput)
    pub fn builder() -> crate::input::create_cache_policy_input::Builder {
        crate::input::create_cache_policy_input::Builder::default()
    }
    /// Creates a new `CreateCachePolicy` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateCachePolicy {
    type Output = std::result::Result<
        crate::output::CreateCachePolicyOutput,
        crate::error::CreateCachePolicyError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 201 {
            crate::operation_deser::parse_create_cache_policy_error(response)
        } else {
            crate::operation_deser::parse_create_cache_policy_response(response)
        }
    }
}

/// Operation shape for `CreateCloudFrontOriginAccessIdentity`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_cloud_front_origin_access_identity`](crate::client::Client::create_cloud_front_origin_access_identity).
///
/// See [`crate::client::fluent_builders::CreateCloudFrontOriginAccessIdentity`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateCloudFrontOriginAccessIdentity {
    _private: (),
}
impl CreateCloudFrontOriginAccessIdentity {
    /// Creates a new builder-style object to manufacture [`CreateCloudFrontOriginAccessIdentityInput`](crate::input::CreateCloudFrontOriginAccessIdentityInput)
    pub fn builder() -> crate::input::create_cloud_front_origin_access_identity_input::Builder {
        crate::input::create_cloud_front_origin_access_identity_input::Builder::default()
    }
    /// Creates a new `CreateCloudFrontOriginAccessIdentity` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateCloudFrontOriginAccessIdentity {
    type Output = std::result::Result<
        crate::output::CreateCloudFrontOriginAccessIdentityOutput,
        crate::error::CreateCloudFrontOriginAccessIdentityError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 201 {
            crate::operation_deser::parse_create_cloud_front_origin_access_identity_error(response)
        } else {
            crate::operation_deser::parse_create_cloud_front_origin_access_identity_response(
                response,
            )
        }
    }
}

/// Operation shape for `CreateDistribution`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_distribution`](crate::client::Client::create_distribution).
///
/// See [`crate::client::fluent_builders::CreateDistribution`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateDistribution {
    _private: (),
}
impl CreateDistribution {
    /// Creates a new builder-style object to manufacture [`CreateDistributionInput`](crate::input::CreateDistributionInput)
    pub fn builder() -> crate::input::create_distribution_input::Builder {
        crate::input::create_distribution_input::Builder::default()
    }
    /// Creates a new `CreateDistribution` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateDistribution {
    type Output = std::result::Result<
        crate::output::CreateDistributionOutput,
        crate::error::CreateDistributionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 201 {
            crate::operation_deser::parse_create_distribution_error(response)
        } else {
            crate::operation_deser::parse_create_distribution_response(response)
        }
    }
}

/// Operation shape for `CreateDistributionWithTags`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_distribution_with_tags`](crate::client::Client::create_distribution_with_tags).
///
/// See [`crate::client::fluent_builders::CreateDistributionWithTags`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateDistributionWithTags {
    _private: (),
}
impl CreateDistributionWithTags {
    /// Creates a new builder-style object to manufacture [`CreateDistributionWithTagsInput`](crate::input::CreateDistributionWithTagsInput)
    pub fn builder() -> crate::input::create_distribution_with_tags_input::Builder {
        crate::input::create_distribution_with_tags_input::Builder::default()
    }
    /// Creates a new `CreateDistributionWithTags` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateDistributionWithTags {
    type Output = std::result::Result<
        crate::output::CreateDistributionWithTagsOutput,
        crate::error::CreateDistributionWithTagsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 201 {
            crate::operation_deser::parse_create_distribution_with_tags_error(response)
        } else {
            crate::operation_deser::parse_create_distribution_with_tags_response(response)
        }
    }
}

/// Operation shape for `CreateFieldLevelEncryptionConfig`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_field_level_encryption_config`](crate::client::Client::create_field_level_encryption_config).
///
/// See [`crate::client::fluent_builders::CreateFieldLevelEncryptionConfig`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateFieldLevelEncryptionConfig {
    _private: (),
}
impl CreateFieldLevelEncryptionConfig {
    /// Creates a new builder-style object to manufacture [`CreateFieldLevelEncryptionConfigInput`](crate::input::CreateFieldLevelEncryptionConfigInput)
    pub fn builder() -> crate::input::create_field_level_encryption_config_input::Builder {
        crate::input::create_field_level_encryption_config_input::Builder::default()
    }
    /// Creates a new `CreateFieldLevelEncryptionConfig` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateFieldLevelEncryptionConfig {
    type Output = std::result::Result<
        crate::output::CreateFieldLevelEncryptionConfigOutput,
        crate::error::CreateFieldLevelEncryptionConfigError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 201 {
            crate::operation_deser::parse_create_field_level_encryption_config_error(response)
        } else {
            crate::operation_deser::parse_create_field_level_encryption_config_response(response)
        }
    }
}

/// Operation shape for `CreateFieldLevelEncryptionProfile`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_field_level_encryption_profile`](crate::client::Client::create_field_level_encryption_profile).
///
/// See [`crate::client::fluent_builders::CreateFieldLevelEncryptionProfile`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateFieldLevelEncryptionProfile {
    _private: (),
}
impl CreateFieldLevelEncryptionProfile {
    /// Creates a new builder-style object to manufacture [`CreateFieldLevelEncryptionProfileInput`](crate::input::CreateFieldLevelEncryptionProfileInput)
    pub fn builder() -> crate::input::create_field_level_encryption_profile_input::Builder {
        crate::input::create_field_level_encryption_profile_input::Builder::default()
    }
    /// Creates a new `CreateFieldLevelEncryptionProfile` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateFieldLevelEncryptionProfile {
    type Output = std::result::Result<
        crate::output::CreateFieldLevelEncryptionProfileOutput,
        crate::error::CreateFieldLevelEncryptionProfileError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 201 {
            crate::operation_deser::parse_create_field_level_encryption_profile_error(response)
        } else {
            crate::operation_deser::parse_create_field_level_encryption_profile_response(response)
        }
    }
}

/// Operation shape for `CreateFunction`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_function`](crate::client::Client::create_function).
///
/// See [`crate::client::fluent_builders::CreateFunction`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateFunction {
    _private: (),
}
impl CreateFunction {
    /// Creates a new builder-style object to manufacture [`CreateFunctionInput`](crate::input::CreateFunctionInput)
    pub fn builder() -> crate::input::create_function_input::Builder {
        crate::input::create_function_input::Builder::default()
    }
    /// Creates a new `CreateFunction` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateFunction {
    type Output =
        std::result::Result<crate::output::CreateFunctionOutput, crate::error::CreateFunctionError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 201 {
            crate::operation_deser::parse_create_function_error(response)
        } else {
            crate::operation_deser::parse_create_function_response(response)
        }
    }
}

/// Operation shape for `CreateInvalidation`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_invalidation`](crate::client::Client::create_invalidation).
///
/// See [`crate::client::fluent_builders::CreateInvalidation`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateInvalidation {
    _private: (),
}
impl CreateInvalidation {
    /// Creates a new builder-style object to manufacture [`CreateInvalidationInput`](crate::input::CreateInvalidationInput)
    pub fn builder() -> crate::input::create_invalidation_input::Builder {
        crate::input::create_invalidation_input::Builder::default()
    }
    /// Creates a new `CreateInvalidation` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateInvalidation {
    type Output = std::result::Result<
        crate::output::CreateInvalidationOutput,
        crate::error::CreateInvalidationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 201 {
            crate::operation_deser::parse_create_invalidation_error(response)
        } else {
            crate::operation_deser::parse_create_invalidation_response(response)
        }
    }
}

/// Operation shape for `CreateKeyGroup`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_key_group`](crate::client::Client::create_key_group).
///
/// See [`crate::client::fluent_builders::CreateKeyGroup`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateKeyGroup {
    _private: (),
}
impl CreateKeyGroup {
    /// Creates a new builder-style object to manufacture [`CreateKeyGroupInput`](crate::input::CreateKeyGroupInput)
    pub fn builder() -> crate::input::create_key_group_input::Builder {
        crate::input::create_key_group_input::Builder::default()
    }
    /// Creates a new `CreateKeyGroup` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateKeyGroup {
    type Output =
        std::result::Result<crate::output::CreateKeyGroupOutput, crate::error::CreateKeyGroupError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 201 {
            crate::operation_deser::parse_create_key_group_error(response)
        } else {
            crate::operation_deser::parse_create_key_group_response(response)
        }
    }
}

/// Operation shape for `CreateMonitoringSubscription`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_monitoring_subscription`](crate::client::Client::create_monitoring_subscription).
///
/// See [`crate::client::fluent_builders::CreateMonitoringSubscription`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateMonitoringSubscription {
    _private: (),
}
impl CreateMonitoringSubscription {
    /// Creates a new builder-style object to manufacture [`CreateMonitoringSubscriptionInput`](crate::input::CreateMonitoringSubscriptionInput)
    pub fn builder() -> crate::input::create_monitoring_subscription_input::Builder {
        crate::input::create_monitoring_subscription_input::Builder::default()
    }
    /// Creates a new `CreateMonitoringSubscription` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateMonitoringSubscription {
    type Output = std::result::Result<
        crate::output::CreateMonitoringSubscriptionOutput,
        crate::error::CreateMonitoringSubscriptionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_monitoring_subscription_error(response)
        } else {
            crate::operation_deser::parse_create_monitoring_subscription_response(response)
        }
    }
}

/// Operation shape for `CreateOriginRequestPolicy`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_origin_request_policy`](crate::client::Client::create_origin_request_policy).
///
/// See [`crate::client::fluent_builders::CreateOriginRequestPolicy`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateOriginRequestPolicy {
    _private: (),
}
impl CreateOriginRequestPolicy {
    /// Creates a new builder-style object to manufacture [`CreateOriginRequestPolicyInput`](crate::input::CreateOriginRequestPolicyInput)
    pub fn builder() -> crate::input::create_origin_request_policy_input::Builder {
        crate::input::create_origin_request_policy_input::Builder::default()
    }
    /// Creates a new `CreateOriginRequestPolicy` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateOriginRequestPolicy {
    type Output = std::result::Result<
        crate::output::CreateOriginRequestPolicyOutput,
        crate::error::CreateOriginRequestPolicyError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 201 {
            crate::operation_deser::parse_create_origin_request_policy_error(response)
        } else {
            crate::operation_deser::parse_create_origin_request_policy_response(response)
        }
    }
}

/// Operation shape for `CreatePublicKey`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_public_key`](crate::client::Client::create_public_key).
///
/// See [`crate::client::fluent_builders::CreatePublicKey`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreatePublicKey {
    _private: (),
}
impl CreatePublicKey {
    /// Creates a new builder-style object to manufacture [`CreatePublicKeyInput`](crate::input::CreatePublicKeyInput)
    pub fn builder() -> crate::input::create_public_key_input::Builder {
        crate::input::create_public_key_input::Builder::default()
    }
    /// Creates a new `CreatePublicKey` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreatePublicKey {
    type Output = std::result::Result<
        crate::output::CreatePublicKeyOutput,
        crate::error::CreatePublicKeyError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 201 {
            crate::operation_deser::parse_create_public_key_error(response)
        } else {
            crate::operation_deser::parse_create_public_key_response(response)
        }
    }
}

/// Operation shape for `CreateRealtimeLogConfig`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_realtime_log_config`](crate::client::Client::create_realtime_log_config).
///
/// See [`crate::client::fluent_builders::CreateRealtimeLogConfig`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateRealtimeLogConfig {
    _private: (),
}
impl CreateRealtimeLogConfig {
    /// Creates a new builder-style object to manufacture [`CreateRealtimeLogConfigInput`](crate::input::CreateRealtimeLogConfigInput)
    pub fn builder() -> crate::input::create_realtime_log_config_input::Builder {
        crate::input::create_realtime_log_config_input::Builder::default()
    }
    /// Creates a new `CreateRealtimeLogConfig` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateRealtimeLogConfig {
    type Output = std::result::Result<
        crate::output::CreateRealtimeLogConfigOutput,
        crate::error::CreateRealtimeLogConfigError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 201 {
            crate::operation_deser::parse_create_realtime_log_config_error(response)
        } else {
            crate::operation_deser::parse_create_realtime_log_config_response(response)
        }
    }
}

/// Operation shape for `CreateResponseHeadersPolicy`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_response_headers_policy`](crate::client::Client::create_response_headers_policy).
///
/// See [`crate::client::fluent_builders::CreateResponseHeadersPolicy`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateResponseHeadersPolicy {
    _private: (),
}
impl CreateResponseHeadersPolicy {
    /// Creates a new builder-style object to manufacture [`CreateResponseHeadersPolicyInput`](crate::input::CreateResponseHeadersPolicyInput)
    pub fn builder() -> crate::input::create_response_headers_policy_input::Builder {
        crate::input::create_response_headers_policy_input::Builder::default()
    }
    /// Creates a new `CreateResponseHeadersPolicy` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateResponseHeadersPolicy {
    type Output = std::result::Result<
        crate::output::CreateResponseHeadersPolicyOutput,
        crate::error::CreateResponseHeadersPolicyError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 201 {
            crate::operation_deser::parse_create_response_headers_policy_error(response)
        } else {
            crate::operation_deser::parse_create_response_headers_policy_response(response)
        }
    }
}

/// Operation shape for `CreateStreamingDistribution`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_streaming_distribution`](crate::client::Client::create_streaming_distribution).
///
/// See [`crate::client::fluent_builders::CreateStreamingDistribution`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateStreamingDistribution {
    _private: (),
}
impl CreateStreamingDistribution {
    /// Creates a new builder-style object to manufacture [`CreateStreamingDistributionInput`](crate::input::CreateStreamingDistributionInput)
    pub fn builder() -> crate::input::create_streaming_distribution_input::Builder {
        crate::input::create_streaming_distribution_input::Builder::default()
    }
    /// Creates a new `CreateStreamingDistribution` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateStreamingDistribution {
    type Output = std::result::Result<
        crate::output::CreateStreamingDistributionOutput,
        crate::error::CreateStreamingDistributionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 201 {
            crate::operation_deser::parse_create_streaming_distribution_error(response)
        } else {
            crate::operation_deser::parse_create_streaming_distribution_response(response)
        }
    }
}

/// Operation shape for `CreateStreamingDistributionWithTags`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_streaming_distribution_with_tags`](crate::client::Client::create_streaming_distribution_with_tags).
///
/// See [`crate::client::fluent_builders::CreateStreamingDistributionWithTags`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateStreamingDistributionWithTags {
    _private: (),
}
impl CreateStreamingDistributionWithTags {
    /// Creates a new builder-style object to manufacture [`CreateStreamingDistributionWithTagsInput`](crate::input::CreateStreamingDistributionWithTagsInput)
    pub fn builder() -> crate::input::create_streaming_distribution_with_tags_input::Builder {
        crate::input::create_streaming_distribution_with_tags_input::Builder::default()
    }
    /// Creates a new `CreateStreamingDistributionWithTags` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateStreamingDistributionWithTags {
    type Output = std::result::Result<
        crate::output::CreateStreamingDistributionWithTagsOutput,
        crate::error::CreateStreamingDistributionWithTagsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 201 {
            crate::operation_deser::parse_create_streaming_distribution_with_tags_error(response)
        } else {
            crate::operation_deser::parse_create_streaming_distribution_with_tags_response(response)
        }
    }
}

/// Operation shape for `DeleteCachePolicy`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_cache_policy`](crate::client::Client::delete_cache_policy).
///
/// See [`crate::client::fluent_builders::DeleteCachePolicy`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteCachePolicy {
    _private: (),
}
impl DeleteCachePolicy {
    /// Creates a new builder-style object to manufacture [`DeleteCachePolicyInput`](crate::input::DeleteCachePolicyInput)
    pub fn builder() -> crate::input::delete_cache_policy_input::Builder {
        crate::input::delete_cache_policy_input::Builder::default()
    }
    /// Creates a new `DeleteCachePolicy` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteCachePolicy {
    type Output = std::result::Result<
        crate::output::DeleteCachePolicyOutput,
        crate::error::DeleteCachePolicyError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 204 {
            crate::operation_deser::parse_delete_cache_policy_error(response)
        } else {
            crate::operation_deser::parse_delete_cache_policy_response(response)
        }
    }
}

/// Operation shape for `DeleteCloudFrontOriginAccessIdentity`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_cloud_front_origin_access_identity`](crate::client::Client::delete_cloud_front_origin_access_identity).
///
/// See [`crate::client::fluent_builders::DeleteCloudFrontOriginAccessIdentity`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteCloudFrontOriginAccessIdentity {
    _private: (),
}
impl DeleteCloudFrontOriginAccessIdentity {
    /// Creates a new builder-style object to manufacture [`DeleteCloudFrontOriginAccessIdentityInput`](crate::input::DeleteCloudFrontOriginAccessIdentityInput)
    pub fn builder() -> crate::input::delete_cloud_front_origin_access_identity_input::Builder {
        crate::input::delete_cloud_front_origin_access_identity_input::Builder::default()
    }
    /// Creates a new `DeleteCloudFrontOriginAccessIdentity` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteCloudFrontOriginAccessIdentity {
    type Output = std::result::Result<
        crate::output::DeleteCloudFrontOriginAccessIdentityOutput,
        crate::error::DeleteCloudFrontOriginAccessIdentityError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 204 {
            crate::operation_deser::parse_delete_cloud_front_origin_access_identity_error(response)
        } else {
            crate::operation_deser::parse_delete_cloud_front_origin_access_identity_response(
                response,
            )
        }
    }
}

/// Operation shape for `DeleteDistribution`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_distribution`](crate::client::Client::delete_distribution).
///
/// See [`crate::client::fluent_builders::DeleteDistribution`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteDistribution {
    _private: (),
}
impl DeleteDistribution {
    /// Creates a new builder-style object to manufacture [`DeleteDistributionInput`](crate::input::DeleteDistributionInput)
    pub fn builder() -> crate::input::delete_distribution_input::Builder {
        crate::input::delete_distribution_input::Builder::default()
    }
    /// Creates a new `DeleteDistribution` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteDistribution {
    type Output = std::result::Result<
        crate::output::DeleteDistributionOutput,
        crate::error::DeleteDistributionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 204 {
            crate::operation_deser::parse_delete_distribution_error(response)
        } else {
            crate::operation_deser::parse_delete_distribution_response(response)
        }
    }
}

/// Operation shape for `DeleteFieldLevelEncryptionConfig`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_field_level_encryption_config`](crate::client::Client::delete_field_level_encryption_config).
///
/// See [`crate::client::fluent_builders::DeleteFieldLevelEncryptionConfig`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteFieldLevelEncryptionConfig {
    _private: (),
}
impl DeleteFieldLevelEncryptionConfig {
    /// Creates a new builder-style object to manufacture [`DeleteFieldLevelEncryptionConfigInput`](crate::input::DeleteFieldLevelEncryptionConfigInput)
    pub fn builder() -> crate::input::delete_field_level_encryption_config_input::Builder {
        crate::input::delete_field_level_encryption_config_input::Builder::default()
    }
    /// Creates a new `DeleteFieldLevelEncryptionConfig` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteFieldLevelEncryptionConfig {
    type Output = std::result::Result<
        crate::output::DeleteFieldLevelEncryptionConfigOutput,
        crate::error::DeleteFieldLevelEncryptionConfigError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 204 {
            crate::operation_deser::parse_delete_field_level_encryption_config_error(response)
        } else {
            crate::operation_deser::parse_delete_field_level_encryption_config_response(response)
        }
    }
}

/// Operation shape for `DeleteFieldLevelEncryptionProfile`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_field_level_encryption_profile`](crate::client::Client::delete_field_level_encryption_profile).
///
/// See [`crate::client::fluent_builders::DeleteFieldLevelEncryptionProfile`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteFieldLevelEncryptionProfile {
    _private: (),
}
impl DeleteFieldLevelEncryptionProfile {
    /// Creates a new builder-style object to manufacture [`DeleteFieldLevelEncryptionProfileInput`](crate::input::DeleteFieldLevelEncryptionProfileInput)
    pub fn builder() -> crate::input::delete_field_level_encryption_profile_input::Builder {
        crate::input::delete_field_level_encryption_profile_input::Builder::default()
    }
    /// Creates a new `DeleteFieldLevelEncryptionProfile` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteFieldLevelEncryptionProfile {
    type Output = std::result::Result<
        crate::output::DeleteFieldLevelEncryptionProfileOutput,
        crate::error::DeleteFieldLevelEncryptionProfileError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 204 {
            crate::operation_deser::parse_delete_field_level_encryption_profile_error(response)
        } else {
            crate::operation_deser::parse_delete_field_level_encryption_profile_response(response)
        }
    }
}

/// Operation shape for `DeleteFunction`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_function`](crate::client::Client::delete_function).
///
/// See [`crate::client::fluent_builders::DeleteFunction`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteFunction {
    _private: (),
}
impl DeleteFunction {
    /// Creates a new builder-style object to manufacture [`DeleteFunctionInput`](crate::input::DeleteFunctionInput)
    pub fn builder() -> crate::input::delete_function_input::Builder {
        crate::input::delete_function_input::Builder::default()
    }
    /// Creates a new `DeleteFunction` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteFunction {
    type Output =
        std::result::Result<crate::output::DeleteFunctionOutput, crate::error::DeleteFunctionError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 204 {
            crate::operation_deser::parse_delete_function_error(response)
        } else {
            crate::operation_deser::parse_delete_function_response(response)
        }
    }
}

/// Operation shape for `DeleteKeyGroup`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_key_group`](crate::client::Client::delete_key_group).
///
/// See [`crate::client::fluent_builders::DeleteKeyGroup`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteKeyGroup {
    _private: (),
}
impl DeleteKeyGroup {
    /// Creates a new builder-style object to manufacture [`DeleteKeyGroupInput`](crate::input::DeleteKeyGroupInput)
    pub fn builder() -> crate::input::delete_key_group_input::Builder {
        crate::input::delete_key_group_input::Builder::default()
    }
    /// Creates a new `DeleteKeyGroup` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteKeyGroup {
    type Output =
        std::result::Result<crate::output::DeleteKeyGroupOutput, crate::error::DeleteKeyGroupError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 204 {
            crate::operation_deser::parse_delete_key_group_error(response)
        } else {
            crate::operation_deser::parse_delete_key_group_response(response)
        }
    }
}

/// Operation shape for `DeleteMonitoringSubscription`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_monitoring_subscription`](crate::client::Client::delete_monitoring_subscription).
///
/// See [`crate::client::fluent_builders::DeleteMonitoringSubscription`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteMonitoringSubscription {
    _private: (),
}
impl DeleteMonitoringSubscription {
    /// Creates a new builder-style object to manufacture [`DeleteMonitoringSubscriptionInput`](crate::input::DeleteMonitoringSubscriptionInput)
    pub fn builder() -> crate::input::delete_monitoring_subscription_input::Builder {
        crate::input::delete_monitoring_subscription_input::Builder::default()
    }
    /// Creates a new `DeleteMonitoringSubscription` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteMonitoringSubscription {
    type Output = std::result::Result<
        crate::output::DeleteMonitoringSubscriptionOutput,
        crate::error::DeleteMonitoringSubscriptionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_monitoring_subscription_error(response)
        } else {
            crate::operation_deser::parse_delete_monitoring_subscription_response(response)
        }
    }
}

/// Operation shape for `DeleteOriginRequestPolicy`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_origin_request_policy`](crate::client::Client::delete_origin_request_policy).
///
/// See [`crate::client::fluent_builders::DeleteOriginRequestPolicy`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteOriginRequestPolicy {
    _private: (),
}
impl DeleteOriginRequestPolicy {
    /// Creates a new builder-style object to manufacture [`DeleteOriginRequestPolicyInput`](crate::input::DeleteOriginRequestPolicyInput)
    pub fn builder() -> crate::input::delete_origin_request_policy_input::Builder {
        crate::input::delete_origin_request_policy_input::Builder::default()
    }
    /// Creates a new `DeleteOriginRequestPolicy` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteOriginRequestPolicy {
    type Output = std::result::Result<
        crate::output::DeleteOriginRequestPolicyOutput,
        crate::error::DeleteOriginRequestPolicyError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 204 {
            crate::operation_deser::parse_delete_origin_request_policy_error(response)
        } else {
            crate::operation_deser::parse_delete_origin_request_policy_response(response)
        }
    }
}

/// Operation shape for `DeletePublicKey`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_public_key`](crate::client::Client::delete_public_key).
///
/// See [`crate::client::fluent_builders::DeletePublicKey`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeletePublicKey {
    _private: (),
}
impl DeletePublicKey {
    /// Creates a new builder-style object to manufacture [`DeletePublicKeyInput`](crate::input::DeletePublicKeyInput)
    pub fn builder() -> crate::input::delete_public_key_input::Builder {
        crate::input::delete_public_key_input::Builder::default()
    }
    /// Creates a new `DeletePublicKey` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeletePublicKey {
    type Output = std::result::Result<
        crate::output::DeletePublicKeyOutput,
        crate::error::DeletePublicKeyError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 204 {
            crate::operation_deser::parse_delete_public_key_error(response)
        } else {
            crate::operation_deser::parse_delete_public_key_response(response)
        }
    }
}

/// Operation shape for `DeleteRealtimeLogConfig`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_realtime_log_config`](crate::client::Client::delete_realtime_log_config).
///
/// See [`crate::client::fluent_builders::DeleteRealtimeLogConfig`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteRealtimeLogConfig {
    _private: (),
}
impl DeleteRealtimeLogConfig {
    /// Creates a new builder-style object to manufacture [`DeleteRealtimeLogConfigInput`](crate::input::DeleteRealtimeLogConfigInput)
    pub fn builder() -> crate::input::delete_realtime_log_config_input::Builder {
        crate::input::delete_realtime_log_config_input::Builder::default()
    }
    /// Creates a new `DeleteRealtimeLogConfig` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteRealtimeLogConfig {
    type Output = std::result::Result<
        crate::output::DeleteRealtimeLogConfigOutput,
        crate::error::DeleteRealtimeLogConfigError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 204 {
            crate::operation_deser::parse_delete_realtime_log_config_error(response)
        } else {
            crate::operation_deser::parse_delete_realtime_log_config_response(response)
        }
    }
}

/// Operation shape for `DeleteResponseHeadersPolicy`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_response_headers_policy`](crate::client::Client::delete_response_headers_policy).
///
/// See [`crate::client::fluent_builders::DeleteResponseHeadersPolicy`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteResponseHeadersPolicy {
    _private: (),
}
impl DeleteResponseHeadersPolicy {
    /// Creates a new builder-style object to manufacture [`DeleteResponseHeadersPolicyInput`](crate::input::DeleteResponseHeadersPolicyInput)
    pub fn builder() -> crate::input::delete_response_headers_policy_input::Builder {
        crate::input::delete_response_headers_policy_input::Builder::default()
    }
    /// Creates a new `DeleteResponseHeadersPolicy` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteResponseHeadersPolicy {
    type Output = std::result::Result<
        crate::output::DeleteResponseHeadersPolicyOutput,
        crate::error::DeleteResponseHeadersPolicyError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 204 {
            crate::operation_deser::parse_delete_response_headers_policy_error(response)
        } else {
            crate::operation_deser::parse_delete_response_headers_policy_response(response)
        }
    }
}

/// Operation shape for `DeleteStreamingDistribution`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_streaming_distribution`](crate::client::Client::delete_streaming_distribution).
///
/// See [`crate::client::fluent_builders::DeleteStreamingDistribution`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteStreamingDistribution {
    _private: (),
}
impl DeleteStreamingDistribution {
    /// Creates a new builder-style object to manufacture [`DeleteStreamingDistributionInput`](crate::input::DeleteStreamingDistributionInput)
    pub fn builder() -> crate::input::delete_streaming_distribution_input::Builder {
        crate::input::delete_streaming_distribution_input::Builder::default()
    }
    /// Creates a new `DeleteStreamingDistribution` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteStreamingDistribution {
    type Output = std::result::Result<
        crate::output::DeleteStreamingDistributionOutput,
        crate::error::DeleteStreamingDistributionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 204 {
            crate::operation_deser::parse_delete_streaming_distribution_error(response)
        } else {
            crate::operation_deser::parse_delete_streaming_distribution_response(response)
        }
    }
}

/// Operation shape for `DescribeFunction`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_function`](crate::client::Client::describe_function).
///
/// See [`crate::client::fluent_builders::DescribeFunction`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeFunction {
    _private: (),
}
impl DescribeFunction {
    /// Creates a new builder-style object to manufacture [`DescribeFunctionInput`](crate::input::DescribeFunctionInput)
    pub fn builder() -> crate::input::describe_function_input::Builder {
        crate::input::describe_function_input::Builder::default()
    }
    /// Creates a new `DescribeFunction` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeFunction {
    type Output = std::result::Result<
        crate::output::DescribeFunctionOutput,
        crate::error::DescribeFunctionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_function_error(response)
        } else {
            crate::operation_deser::parse_describe_function_response(response)
        }
    }
}

/// Operation shape for `GetCachePolicy`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_cache_policy`](crate::client::Client::get_cache_policy).
///
/// See [`crate::client::fluent_builders::GetCachePolicy`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetCachePolicy {
    _private: (),
}
impl GetCachePolicy {
    /// Creates a new builder-style object to manufacture [`GetCachePolicyInput`](crate::input::GetCachePolicyInput)
    pub fn builder() -> crate::input::get_cache_policy_input::Builder {
        crate::input::get_cache_policy_input::Builder::default()
    }
    /// Creates a new `GetCachePolicy` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetCachePolicy {
    type Output =
        std::result::Result<crate::output::GetCachePolicyOutput, crate::error::GetCachePolicyError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_cache_policy_error(response)
        } else {
            crate::operation_deser::parse_get_cache_policy_response(response)
        }
    }
}

/// Operation shape for `GetCachePolicyConfig`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_cache_policy_config`](crate::client::Client::get_cache_policy_config).
///
/// See [`crate::client::fluent_builders::GetCachePolicyConfig`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetCachePolicyConfig {
    _private: (),
}
impl GetCachePolicyConfig {
    /// Creates a new builder-style object to manufacture [`GetCachePolicyConfigInput`](crate::input::GetCachePolicyConfigInput)
    pub fn builder() -> crate::input::get_cache_policy_config_input::Builder {
        crate::input::get_cache_policy_config_input::Builder::default()
    }
    /// Creates a new `GetCachePolicyConfig` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetCachePolicyConfig {
    type Output = std::result::Result<
        crate::output::GetCachePolicyConfigOutput,
        crate::error::GetCachePolicyConfigError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_cache_policy_config_error(response)
        } else {
            crate::operation_deser::parse_get_cache_policy_config_response(response)
        }
    }
}

/// Operation shape for `GetCloudFrontOriginAccessIdentity`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_cloud_front_origin_access_identity`](crate::client::Client::get_cloud_front_origin_access_identity).
///
/// See [`crate::client::fluent_builders::GetCloudFrontOriginAccessIdentity`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetCloudFrontOriginAccessIdentity {
    _private: (),
}
impl GetCloudFrontOriginAccessIdentity {
    /// Creates a new builder-style object to manufacture [`GetCloudFrontOriginAccessIdentityInput`](crate::input::GetCloudFrontOriginAccessIdentityInput)
    pub fn builder() -> crate::input::get_cloud_front_origin_access_identity_input::Builder {
        crate::input::get_cloud_front_origin_access_identity_input::Builder::default()
    }
    /// Creates a new `GetCloudFrontOriginAccessIdentity` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetCloudFrontOriginAccessIdentity {
    type Output = std::result::Result<
        crate::output::GetCloudFrontOriginAccessIdentityOutput,
        crate::error::GetCloudFrontOriginAccessIdentityError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_cloud_front_origin_access_identity_error(response)
        } else {
            crate::operation_deser::parse_get_cloud_front_origin_access_identity_response(response)
        }
    }
}

/// Operation shape for `GetCloudFrontOriginAccessIdentityConfig`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_cloud_front_origin_access_identity_config`](crate::client::Client::get_cloud_front_origin_access_identity_config).
///
/// See [`crate::client::fluent_builders::GetCloudFrontOriginAccessIdentityConfig`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetCloudFrontOriginAccessIdentityConfig {
    _private: (),
}
impl GetCloudFrontOriginAccessIdentityConfig {
    /// Creates a new builder-style object to manufacture [`GetCloudFrontOriginAccessIdentityConfigInput`](crate::input::GetCloudFrontOriginAccessIdentityConfigInput)
    pub fn builder() -> crate::input::get_cloud_front_origin_access_identity_config_input::Builder {
        crate::input::get_cloud_front_origin_access_identity_config_input::Builder::default()
    }
    /// Creates a new `GetCloudFrontOriginAccessIdentityConfig` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetCloudFrontOriginAccessIdentityConfig {
    type Output = std::result::Result<
        crate::output::GetCloudFrontOriginAccessIdentityConfigOutput,
        crate::error::GetCloudFrontOriginAccessIdentityConfigError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_cloud_front_origin_access_identity_config_error(
                response,
            )
        } else {
            crate::operation_deser::parse_get_cloud_front_origin_access_identity_config_response(
                response,
            )
        }
    }
}

/// Operation shape for `GetDistribution`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_distribution`](crate::client::Client::get_distribution).
///
/// See [`crate::client::fluent_builders::GetDistribution`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetDistribution {
    _private: (),
}
impl GetDistribution {
    /// Creates a new builder-style object to manufacture [`GetDistributionInput`](crate::input::GetDistributionInput)
    pub fn builder() -> crate::input::get_distribution_input::Builder {
        crate::input::get_distribution_input::Builder::default()
    }
    /// Creates a new `GetDistribution` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetDistribution {
    type Output = std::result::Result<
        crate::output::GetDistributionOutput,
        crate::error::GetDistributionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_distribution_error(response)
        } else {
            crate::operation_deser::parse_get_distribution_response(response)
        }
    }
}

/// Operation shape for `GetDistributionConfig`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_distribution_config`](crate::client::Client::get_distribution_config).
///
/// See [`crate::client::fluent_builders::GetDistributionConfig`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetDistributionConfig {
    _private: (),
}
impl GetDistributionConfig {
    /// Creates a new builder-style object to manufacture [`GetDistributionConfigInput`](crate::input::GetDistributionConfigInput)
    pub fn builder() -> crate::input::get_distribution_config_input::Builder {
        crate::input::get_distribution_config_input::Builder::default()
    }
    /// Creates a new `GetDistributionConfig` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetDistributionConfig {
    type Output = std::result::Result<
        crate::output::GetDistributionConfigOutput,
        crate::error::GetDistributionConfigError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_distribution_config_error(response)
        } else {
            crate::operation_deser::parse_get_distribution_config_response(response)
        }
    }
}

/// Operation shape for `GetFieldLevelEncryption`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_field_level_encryption`](crate::client::Client::get_field_level_encryption).
///
/// See [`crate::client::fluent_builders::GetFieldLevelEncryption`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetFieldLevelEncryption {
    _private: (),
}
impl GetFieldLevelEncryption {
    /// Creates a new builder-style object to manufacture [`GetFieldLevelEncryptionInput`](crate::input::GetFieldLevelEncryptionInput)
    pub fn builder() -> crate::input::get_field_level_encryption_input::Builder {
        crate::input::get_field_level_encryption_input::Builder::default()
    }
    /// Creates a new `GetFieldLevelEncryption` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetFieldLevelEncryption {
    type Output = std::result::Result<
        crate::output::GetFieldLevelEncryptionOutput,
        crate::error::GetFieldLevelEncryptionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_field_level_encryption_error(response)
        } else {
            crate::operation_deser::parse_get_field_level_encryption_response(response)
        }
    }
}

/// Operation shape for `GetFieldLevelEncryptionConfig`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_field_level_encryption_config`](crate::client::Client::get_field_level_encryption_config).
///
/// See [`crate::client::fluent_builders::GetFieldLevelEncryptionConfig`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetFieldLevelEncryptionConfig {
    _private: (),
}
impl GetFieldLevelEncryptionConfig {
    /// Creates a new builder-style object to manufacture [`GetFieldLevelEncryptionConfigInput`](crate::input::GetFieldLevelEncryptionConfigInput)
    pub fn builder() -> crate::input::get_field_level_encryption_config_input::Builder {
        crate::input::get_field_level_encryption_config_input::Builder::default()
    }
    /// Creates a new `GetFieldLevelEncryptionConfig` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetFieldLevelEncryptionConfig {
    type Output = std::result::Result<
        crate::output::GetFieldLevelEncryptionConfigOutput,
        crate::error::GetFieldLevelEncryptionConfigError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_field_level_encryption_config_error(response)
        } else {
            crate::operation_deser::parse_get_field_level_encryption_config_response(response)
        }
    }
}

/// Operation shape for `GetFieldLevelEncryptionProfile`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_field_level_encryption_profile`](crate::client::Client::get_field_level_encryption_profile).
///
/// See [`crate::client::fluent_builders::GetFieldLevelEncryptionProfile`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetFieldLevelEncryptionProfile {
    _private: (),
}
impl GetFieldLevelEncryptionProfile {
    /// Creates a new builder-style object to manufacture [`GetFieldLevelEncryptionProfileInput`](crate::input::GetFieldLevelEncryptionProfileInput)
    pub fn builder() -> crate::input::get_field_level_encryption_profile_input::Builder {
        crate::input::get_field_level_encryption_profile_input::Builder::default()
    }
    /// Creates a new `GetFieldLevelEncryptionProfile` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetFieldLevelEncryptionProfile {
    type Output = std::result::Result<
        crate::output::GetFieldLevelEncryptionProfileOutput,
        crate::error::GetFieldLevelEncryptionProfileError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_field_level_encryption_profile_error(response)
        } else {
            crate::operation_deser::parse_get_field_level_encryption_profile_response(response)
        }
    }
}

/// Operation shape for `GetFieldLevelEncryptionProfileConfig`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_field_level_encryption_profile_config`](crate::client::Client::get_field_level_encryption_profile_config).
///
/// See [`crate::client::fluent_builders::GetFieldLevelEncryptionProfileConfig`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetFieldLevelEncryptionProfileConfig {
    _private: (),
}
impl GetFieldLevelEncryptionProfileConfig {
    /// Creates a new builder-style object to manufacture [`GetFieldLevelEncryptionProfileConfigInput`](crate::input::GetFieldLevelEncryptionProfileConfigInput)
    pub fn builder() -> crate::input::get_field_level_encryption_profile_config_input::Builder {
        crate::input::get_field_level_encryption_profile_config_input::Builder::default()
    }
    /// Creates a new `GetFieldLevelEncryptionProfileConfig` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetFieldLevelEncryptionProfileConfig {
    type Output = std::result::Result<
        crate::output::GetFieldLevelEncryptionProfileConfigOutput,
        crate::error::GetFieldLevelEncryptionProfileConfigError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_field_level_encryption_profile_config_error(response)
        } else {
            crate::operation_deser::parse_get_field_level_encryption_profile_config_response(
                response,
            )
        }
    }
}

/// Operation shape for `GetFunction`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_function`](crate::client::Client::get_function).
///
/// See [`crate::client::fluent_builders::GetFunction`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetFunction {
    _private: (),
}
impl GetFunction {
    /// Creates a new builder-style object to manufacture [`GetFunctionInput`](crate::input::GetFunctionInput)
    pub fn builder() -> crate::input::get_function_input::Builder {
        crate::input::get_function_input::Builder::default()
    }
    /// Creates a new `GetFunction` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetFunction {
    type Output =
        std::result::Result<crate::output::GetFunctionOutput, crate::error::GetFunctionError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_function_error(response)
        } else {
            crate::operation_deser::parse_get_function_response(response)
        }
    }
}

/// Operation shape for `GetInvalidation`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_invalidation`](crate::client::Client::get_invalidation).
///
/// See [`crate::client::fluent_builders::GetInvalidation`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetInvalidation {
    _private: (),
}
impl GetInvalidation {
    /// Creates a new builder-style object to manufacture [`GetInvalidationInput`](crate::input::GetInvalidationInput)
    pub fn builder() -> crate::input::get_invalidation_input::Builder {
        crate::input::get_invalidation_input::Builder::default()
    }
    /// Creates a new `GetInvalidation` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetInvalidation {
    type Output = std::result::Result<
        crate::output::GetInvalidationOutput,
        crate::error::GetInvalidationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_invalidation_error(response)
        } else {
            crate::operation_deser::parse_get_invalidation_response(response)
        }
    }
}

/// Operation shape for `GetKeyGroup`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_key_group`](crate::client::Client::get_key_group).
///
/// See [`crate::client::fluent_builders::GetKeyGroup`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetKeyGroup {
    _private: (),
}
impl GetKeyGroup {
    /// Creates a new builder-style object to manufacture [`GetKeyGroupInput`](crate::input::GetKeyGroupInput)
    pub fn builder() -> crate::input::get_key_group_input::Builder {
        crate::input::get_key_group_input::Builder::default()
    }
    /// Creates a new `GetKeyGroup` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetKeyGroup {
    type Output =
        std::result::Result<crate::output::GetKeyGroupOutput, crate::error::GetKeyGroupError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_key_group_error(response)
        } else {
            crate::operation_deser::parse_get_key_group_response(response)
        }
    }
}

/// Operation shape for `GetKeyGroupConfig`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_key_group_config`](crate::client::Client::get_key_group_config).
///
/// See [`crate::client::fluent_builders::GetKeyGroupConfig`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetKeyGroupConfig {
    _private: (),
}
impl GetKeyGroupConfig {
    /// Creates a new builder-style object to manufacture [`GetKeyGroupConfigInput`](crate::input::GetKeyGroupConfigInput)
    pub fn builder() -> crate::input::get_key_group_config_input::Builder {
        crate::input::get_key_group_config_input::Builder::default()
    }
    /// Creates a new `GetKeyGroupConfig` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetKeyGroupConfig {
    type Output = std::result::Result<
        crate::output::GetKeyGroupConfigOutput,
        crate::error::GetKeyGroupConfigError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_key_group_config_error(response)
        } else {
            crate::operation_deser::parse_get_key_group_config_response(response)
        }
    }
}

/// Operation shape for `GetMonitoringSubscription`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_monitoring_subscription`](crate::client::Client::get_monitoring_subscription).
///
/// See [`crate::client::fluent_builders::GetMonitoringSubscription`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetMonitoringSubscription {
    _private: (),
}
impl GetMonitoringSubscription {
    /// Creates a new builder-style object to manufacture [`GetMonitoringSubscriptionInput`](crate::input::GetMonitoringSubscriptionInput)
    pub fn builder() -> crate::input::get_monitoring_subscription_input::Builder {
        crate::input::get_monitoring_subscription_input::Builder::default()
    }
    /// Creates a new `GetMonitoringSubscription` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetMonitoringSubscription {
    type Output = std::result::Result<
        crate::output::GetMonitoringSubscriptionOutput,
        crate::error::GetMonitoringSubscriptionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_monitoring_subscription_error(response)
        } else {
            crate::operation_deser::parse_get_monitoring_subscription_response(response)
        }
    }
}

/// Operation shape for `GetOriginRequestPolicy`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_origin_request_policy`](crate::client::Client::get_origin_request_policy).
///
/// See [`crate::client::fluent_builders::GetOriginRequestPolicy`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetOriginRequestPolicy {
    _private: (),
}
impl GetOriginRequestPolicy {
    /// Creates a new builder-style object to manufacture [`GetOriginRequestPolicyInput`](crate::input::GetOriginRequestPolicyInput)
    pub fn builder() -> crate::input::get_origin_request_policy_input::Builder {
        crate::input::get_origin_request_policy_input::Builder::default()
    }
    /// Creates a new `GetOriginRequestPolicy` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetOriginRequestPolicy {
    type Output = std::result::Result<
        crate::output::GetOriginRequestPolicyOutput,
        crate::error::GetOriginRequestPolicyError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_origin_request_policy_error(response)
        } else {
            crate::operation_deser::parse_get_origin_request_policy_response(response)
        }
    }
}

/// Operation shape for `GetOriginRequestPolicyConfig`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_origin_request_policy_config`](crate::client::Client::get_origin_request_policy_config).
///
/// See [`crate::client::fluent_builders::GetOriginRequestPolicyConfig`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetOriginRequestPolicyConfig {
    _private: (),
}
impl GetOriginRequestPolicyConfig {
    /// Creates a new builder-style object to manufacture [`GetOriginRequestPolicyConfigInput`](crate::input::GetOriginRequestPolicyConfigInput)
    pub fn builder() -> crate::input::get_origin_request_policy_config_input::Builder {
        crate::input::get_origin_request_policy_config_input::Builder::default()
    }
    /// Creates a new `GetOriginRequestPolicyConfig` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetOriginRequestPolicyConfig {
    type Output = std::result::Result<
        crate::output::GetOriginRequestPolicyConfigOutput,
        crate::error::GetOriginRequestPolicyConfigError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_origin_request_policy_config_error(response)
        } else {
            crate::operation_deser::parse_get_origin_request_policy_config_response(response)
        }
    }
}

/// Operation shape for `GetPublicKey`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_public_key`](crate::client::Client::get_public_key).
///
/// See [`crate::client::fluent_builders::GetPublicKey`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetPublicKey {
    _private: (),
}
impl GetPublicKey {
    /// Creates a new builder-style object to manufacture [`GetPublicKeyInput`](crate::input::GetPublicKeyInput)
    pub fn builder() -> crate::input::get_public_key_input::Builder {
        crate::input::get_public_key_input::Builder::default()
    }
    /// Creates a new `GetPublicKey` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetPublicKey {
    type Output =
        std::result::Result<crate::output::GetPublicKeyOutput, crate::error::GetPublicKeyError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_public_key_error(response)
        } else {
            crate::operation_deser::parse_get_public_key_response(response)
        }
    }
}

/// Operation shape for `GetPublicKeyConfig`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_public_key_config`](crate::client::Client::get_public_key_config).
///
/// See [`crate::client::fluent_builders::GetPublicKeyConfig`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetPublicKeyConfig {
    _private: (),
}
impl GetPublicKeyConfig {
    /// Creates a new builder-style object to manufacture [`GetPublicKeyConfigInput`](crate::input::GetPublicKeyConfigInput)
    pub fn builder() -> crate::input::get_public_key_config_input::Builder {
        crate::input::get_public_key_config_input::Builder::default()
    }
    /// Creates a new `GetPublicKeyConfig` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetPublicKeyConfig {
    type Output = std::result::Result<
        crate::output::GetPublicKeyConfigOutput,
        crate::error::GetPublicKeyConfigError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_public_key_config_error(response)
        } else {
            crate::operation_deser::parse_get_public_key_config_response(response)
        }
    }
}

/// Operation shape for `GetRealtimeLogConfig`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_realtime_log_config`](crate::client::Client::get_realtime_log_config).
///
/// See [`crate::client::fluent_builders::GetRealtimeLogConfig`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetRealtimeLogConfig {
    _private: (),
}
impl GetRealtimeLogConfig {
    /// Creates a new builder-style object to manufacture [`GetRealtimeLogConfigInput`](crate::input::GetRealtimeLogConfigInput)
    pub fn builder() -> crate::input::get_realtime_log_config_input::Builder {
        crate::input::get_realtime_log_config_input::Builder::default()
    }
    /// Creates a new `GetRealtimeLogConfig` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetRealtimeLogConfig {
    type Output = std::result::Result<
        crate::output::GetRealtimeLogConfigOutput,
        crate::error::GetRealtimeLogConfigError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_realtime_log_config_error(response)
        } else {
            crate::operation_deser::parse_get_realtime_log_config_response(response)
        }
    }
}

/// Operation shape for `GetResponseHeadersPolicy`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_response_headers_policy`](crate::client::Client::get_response_headers_policy).
///
/// See [`crate::client::fluent_builders::GetResponseHeadersPolicy`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetResponseHeadersPolicy {
    _private: (),
}
impl GetResponseHeadersPolicy {
    /// Creates a new builder-style object to manufacture [`GetResponseHeadersPolicyInput`](crate::input::GetResponseHeadersPolicyInput)
    pub fn builder() -> crate::input::get_response_headers_policy_input::Builder {
        crate::input::get_response_headers_policy_input::Builder::default()
    }
    /// Creates a new `GetResponseHeadersPolicy` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetResponseHeadersPolicy {
    type Output = std::result::Result<
        crate::output::GetResponseHeadersPolicyOutput,
        crate::error::GetResponseHeadersPolicyError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_response_headers_policy_error(response)
        } else {
            crate::operation_deser::parse_get_response_headers_policy_response(response)
        }
    }
}

/// Operation shape for `GetResponseHeadersPolicyConfig`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_response_headers_policy_config`](crate::client::Client::get_response_headers_policy_config).
///
/// See [`crate::client::fluent_builders::GetResponseHeadersPolicyConfig`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetResponseHeadersPolicyConfig {
    _private: (),
}
impl GetResponseHeadersPolicyConfig {
    /// Creates a new builder-style object to manufacture [`GetResponseHeadersPolicyConfigInput`](crate::input::GetResponseHeadersPolicyConfigInput)
    pub fn builder() -> crate::input::get_response_headers_policy_config_input::Builder {
        crate::input::get_response_headers_policy_config_input::Builder::default()
    }
    /// Creates a new `GetResponseHeadersPolicyConfig` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetResponseHeadersPolicyConfig {
    type Output = std::result::Result<
        crate::output::GetResponseHeadersPolicyConfigOutput,
        crate::error::GetResponseHeadersPolicyConfigError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_response_headers_policy_config_error(response)
        } else {
            crate::operation_deser::parse_get_response_headers_policy_config_response(response)
        }
    }
}

/// Operation shape for `GetStreamingDistribution`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_streaming_distribution`](crate::client::Client::get_streaming_distribution).
///
/// See [`crate::client::fluent_builders::GetStreamingDistribution`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetStreamingDistribution {
    _private: (),
}
impl GetStreamingDistribution {
    /// Creates a new builder-style object to manufacture [`GetStreamingDistributionInput`](crate::input::GetStreamingDistributionInput)
    pub fn builder() -> crate::input::get_streaming_distribution_input::Builder {
        crate::input::get_streaming_distribution_input::Builder::default()
    }
    /// Creates a new `GetStreamingDistribution` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetStreamingDistribution {
    type Output = std::result::Result<
        crate::output::GetStreamingDistributionOutput,
        crate::error::GetStreamingDistributionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_streaming_distribution_error(response)
        } else {
            crate::operation_deser::parse_get_streaming_distribution_response(response)
        }
    }
}

/// Operation shape for `GetStreamingDistributionConfig`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_streaming_distribution_config`](crate::client::Client::get_streaming_distribution_config).
///
/// See [`crate::client::fluent_builders::GetStreamingDistributionConfig`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetStreamingDistributionConfig {
    _private: (),
}
impl GetStreamingDistributionConfig {
    /// Creates a new builder-style object to manufacture [`GetStreamingDistributionConfigInput`](crate::input::GetStreamingDistributionConfigInput)
    pub fn builder() -> crate::input::get_streaming_distribution_config_input::Builder {
        crate::input::get_streaming_distribution_config_input::Builder::default()
    }
    /// Creates a new `GetStreamingDistributionConfig` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetStreamingDistributionConfig {
    type Output = std::result::Result<
        crate::output::GetStreamingDistributionConfigOutput,
        crate::error::GetStreamingDistributionConfigError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_streaming_distribution_config_error(response)
        } else {
            crate::operation_deser::parse_get_streaming_distribution_config_response(response)
        }
    }
}

/// Operation shape for `ListCachePolicies`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_cache_policies`](crate::client::Client::list_cache_policies).
///
/// See [`crate::client::fluent_builders::ListCachePolicies`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListCachePolicies {
    _private: (),
}
impl ListCachePolicies {
    /// Creates a new builder-style object to manufacture [`ListCachePoliciesInput`](crate::input::ListCachePoliciesInput)
    pub fn builder() -> crate::input::list_cache_policies_input::Builder {
        crate::input::list_cache_policies_input::Builder::default()
    }
    /// Creates a new `ListCachePolicies` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListCachePolicies {
    type Output = std::result::Result<
        crate::output::ListCachePoliciesOutput,
        crate::error::ListCachePoliciesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_cache_policies_error(response)
        } else {
            crate::operation_deser::parse_list_cache_policies_response(response)
        }
    }
}

/// Operation shape for `ListCloudFrontOriginAccessIdentities`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_cloud_front_origin_access_identities`](crate::client::Client::list_cloud_front_origin_access_identities).
///
/// See [`crate::client::fluent_builders::ListCloudFrontOriginAccessIdentities`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListCloudFrontOriginAccessIdentities {
    _private: (),
}
impl ListCloudFrontOriginAccessIdentities {
    /// Creates a new builder-style object to manufacture [`ListCloudFrontOriginAccessIdentitiesInput`](crate::input::ListCloudFrontOriginAccessIdentitiesInput)
    pub fn builder() -> crate::input::list_cloud_front_origin_access_identities_input::Builder {
        crate::input::list_cloud_front_origin_access_identities_input::Builder::default()
    }
    /// Creates a new `ListCloudFrontOriginAccessIdentities` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListCloudFrontOriginAccessIdentities {
    type Output = std::result::Result<
        crate::output::ListCloudFrontOriginAccessIdentitiesOutput,
        crate::error::ListCloudFrontOriginAccessIdentitiesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_cloud_front_origin_access_identities_error(response)
        } else {
            crate::operation_deser::parse_list_cloud_front_origin_access_identities_response(
                response,
            )
        }
    }
}

/// Operation shape for `ListConflictingAliases`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_conflicting_aliases`](crate::client::Client::list_conflicting_aliases).
///
/// See [`crate::client::fluent_builders::ListConflictingAliases`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListConflictingAliases {
    _private: (),
}
impl ListConflictingAliases {
    /// Creates a new builder-style object to manufacture [`ListConflictingAliasesInput`](crate::input::ListConflictingAliasesInput)
    pub fn builder() -> crate::input::list_conflicting_aliases_input::Builder {
        crate::input::list_conflicting_aliases_input::Builder::default()
    }
    /// Creates a new `ListConflictingAliases` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListConflictingAliases {
    type Output = std::result::Result<
        crate::output::ListConflictingAliasesOutput,
        crate::error::ListConflictingAliasesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_conflicting_aliases_error(response)
        } else {
            crate::operation_deser::parse_list_conflicting_aliases_response(response)
        }
    }
}

/// Operation shape for `ListDistributions`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_distributions`](crate::client::Client::list_distributions).
///
/// See [`crate::client::fluent_builders::ListDistributions`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListDistributions {
    _private: (),
}
impl ListDistributions {
    /// Creates a new builder-style object to manufacture [`ListDistributionsInput`](crate::input::ListDistributionsInput)
    pub fn builder() -> crate::input::list_distributions_input::Builder {
        crate::input::list_distributions_input::Builder::default()
    }
    /// Creates a new `ListDistributions` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListDistributions {
    type Output = std::result::Result<
        crate::output::ListDistributionsOutput,
        crate::error::ListDistributionsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_distributions_error(response)
        } else {
            crate::operation_deser::parse_list_distributions_response(response)
        }
    }
}

/// Operation shape for `ListDistributionsByCachePolicyId`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_distributions_by_cache_policy_id`](crate::client::Client::list_distributions_by_cache_policy_id).
///
/// See [`crate::client::fluent_builders::ListDistributionsByCachePolicyId`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListDistributionsByCachePolicyId {
    _private: (),
}
impl ListDistributionsByCachePolicyId {
    /// Creates a new builder-style object to manufacture [`ListDistributionsByCachePolicyIdInput`](crate::input::ListDistributionsByCachePolicyIdInput)
    pub fn builder() -> crate::input::list_distributions_by_cache_policy_id_input::Builder {
        crate::input::list_distributions_by_cache_policy_id_input::Builder::default()
    }
    /// Creates a new `ListDistributionsByCachePolicyId` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListDistributionsByCachePolicyId {
    type Output = std::result::Result<
        crate::output::ListDistributionsByCachePolicyIdOutput,
        crate::error::ListDistributionsByCachePolicyIdError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_distributions_by_cache_policy_id_error(response)
        } else {
            crate::operation_deser::parse_list_distributions_by_cache_policy_id_response(response)
        }
    }
}

/// Operation shape for `ListDistributionsByKeyGroup`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_distributions_by_key_group`](crate::client::Client::list_distributions_by_key_group).
///
/// See [`crate::client::fluent_builders::ListDistributionsByKeyGroup`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListDistributionsByKeyGroup {
    _private: (),
}
impl ListDistributionsByKeyGroup {
    /// Creates a new builder-style object to manufacture [`ListDistributionsByKeyGroupInput`](crate::input::ListDistributionsByKeyGroupInput)
    pub fn builder() -> crate::input::list_distributions_by_key_group_input::Builder {
        crate::input::list_distributions_by_key_group_input::Builder::default()
    }
    /// Creates a new `ListDistributionsByKeyGroup` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListDistributionsByKeyGroup {
    type Output = std::result::Result<
        crate::output::ListDistributionsByKeyGroupOutput,
        crate::error::ListDistributionsByKeyGroupError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_distributions_by_key_group_error(response)
        } else {
            crate::operation_deser::parse_list_distributions_by_key_group_response(response)
        }
    }
}

/// Operation shape for `ListDistributionsByOriginRequestPolicyId`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_distributions_by_origin_request_policy_id`](crate::client::Client::list_distributions_by_origin_request_policy_id).
///
/// See [`crate::client::fluent_builders::ListDistributionsByOriginRequestPolicyId`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListDistributionsByOriginRequestPolicyId {
    _private: (),
}
impl ListDistributionsByOriginRequestPolicyId {
    /// Creates a new builder-style object to manufacture [`ListDistributionsByOriginRequestPolicyIdInput`](crate::input::ListDistributionsByOriginRequestPolicyIdInput)
    pub fn builder() -> crate::input::list_distributions_by_origin_request_policy_id_input::Builder
    {
        crate::input::list_distributions_by_origin_request_policy_id_input::Builder::default()
    }
    /// Creates a new `ListDistributionsByOriginRequestPolicyId` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListDistributionsByOriginRequestPolicyId {
    type Output = std::result::Result<
        crate::output::ListDistributionsByOriginRequestPolicyIdOutput,
        crate::error::ListDistributionsByOriginRequestPolicyIdError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_distributions_by_origin_request_policy_id_error(
                response,
            )
        } else {
            crate::operation_deser::parse_list_distributions_by_origin_request_policy_id_response(
                response,
            )
        }
    }
}

/// Operation shape for `ListDistributionsByRealtimeLogConfig`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_distributions_by_realtime_log_config`](crate::client::Client::list_distributions_by_realtime_log_config).
///
/// See [`crate::client::fluent_builders::ListDistributionsByRealtimeLogConfig`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListDistributionsByRealtimeLogConfig {
    _private: (),
}
impl ListDistributionsByRealtimeLogConfig {
    /// Creates a new builder-style object to manufacture [`ListDistributionsByRealtimeLogConfigInput`](crate::input::ListDistributionsByRealtimeLogConfigInput)
    pub fn builder() -> crate::input::list_distributions_by_realtime_log_config_input::Builder {
        crate::input::list_distributions_by_realtime_log_config_input::Builder::default()
    }
    /// Creates a new `ListDistributionsByRealtimeLogConfig` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListDistributionsByRealtimeLogConfig {
    type Output = std::result::Result<
        crate::output::ListDistributionsByRealtimeLogConfigOutput,
        crate::error::ListDistributionsByRealtimeLogConfigError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_distributions_by_realtime_log_config_error(response)
        } else {
            crate::operation_deser::parse_list_distributions_by_realtime_log_config_response(
                response,
            )
        }
    }
}

/// Operation shape for `ListDistributionsByResponseHeadersPolicyId`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_distributions_by_response_headers_policy_id`](crate::client::Client::list_distributions_by_response_headers_policy_id).
///
/// See [`crate::client::fluent_builders::ListDistributionsByResponseHeadersPolicyId`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListDistributionsByResponseHeadersPolicyId {
    _private: (),
}
impl ListDistributionsByResponseHeadersPolicyId {
    /// Creates a new builder-style object to manufacture [`ListDistributionsByResponseHeadersPolicyIdInput`](crate::input::ListDistributionsByResponseHeadersPolicyIdInput)
    pub fn builder() -> crate::input::list_distributions_by_response_headers_policy_id_input::Builder
    {
        crate::input::list_distributions_by_response_headers_policy_id_input::Builder::default()
    }
    /// Creates a new `ListDistributionsByResponseHeadersPolicyId` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListDistributionsByResponseHeadersPolicyId {
    type Output = std::result::Result<
        crate::output::ListDistributionsByResponseHeadersPolicyIdOutput,
        crate::error::ListDistributionsByResponseHeadersPolicyIdError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_distributions_by_response_headers_policy_id_error(
                response,
            )
        } else {
            crate::operation_deser::parse_list_distributions_by_response_headers_policy_id_response(
                response,
            )
        }
    }
}

/// Operation shape for `ListDistributionsByWebACLId`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_distributions_by_web_acl_id`](crate::client::Client::list_distributions_by_web_acl_id).
///
/// See [`crate::client::fluent_builders::ListDistributionsByWebACLId`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListDistributionsByWebACLId {
    _private: (),
}
impl ListDistributionsByWebACLId {
    /// Creates a new builder-style object to manufacture [`ListDistributionsByWebAclIdInput`](crate::input::ListDistributionsByWebAclIdInput)
    pub fn builder() -> crate::input::list_distributions_by_web_acl_id_input::Builder {
        crate::input::list_distributions_by_web_acl_id_input::Builder::default()
    }
    /// Creates a new `ListDistributionsByWebACLId` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListDistributionsByWebACLId {
    type Output = std::result::Result<
        crate::output::ListDistributionsByWebAclIdOutput,
        crate::error::ListDistributionsByWebACLIdError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_distributions_by_web_acl_id_error(response)
        } else {
            crate::operation_deser::parse_list_distributions_by_web_acl_id_response(response)
        }
    }
}

/// Operation shape for `ListFieldLevelEncryptionConfigs`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_field_level_encryption_configs`](crate::client::Client::list_field_level_encryption_configs).
///
/// See [`crate::client::fluent_builders::ListFieldLevelEncryptionConfigs`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListFieldLevelEncryptionConfigs {
    _private: (),
}
impl ListFieldLevelEncryptionConfigs {
    /// Creates a new builder-style object to manufacture [`ListFieldLevelEncryptionConfigsInput`](crate::input::ListFieldLevelEncryptionConfigsInput)
    pub fn builder() -> crate::input::list_field_level_encryption_configs_input::Builder {
        crate::input::list_field_level_encryption_configs_input::Builder::default()
    }
    /// Creates a new `ListFieldLevelEncryptionConfigs` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListFieldLevelEncryptionConfigs {
    type Output = std::result::Result<
        crate::output::ListFieldLevelEncryptionConfigsOutput,
        crate::error::ListFieldLevelEncryptionConfigsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_field_level_encryption_configs_error(response)
        } else {
            crate::operation_deser::parse_list_field_level_encryption_configs_response(response)
        }
    }
}

/// Operation shape for `ListFieldLevelEncryptionProfiles`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_field_level_encryption_profiles`](crate::client::Client::list_field_level_encryption_profiles).
///
/// See [`crate::client::fluent_builders::ListFieldLevelEncryptionProfiles`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListFieldLevelEncryptionProfiles {
    _private: (),
}
impl ListFieldLevelEncryptionProfiles {
    /// Creates a new builder-style object to manufacture [`ListFieldLevelEncryptionProfilesInput`](crate::input::ListFieldLevelEncryptionProfilesInput)
    pub fn builder() -> crate::input::list_field_level_encryption_profiles_input::Builder {
        crate::input::list_field_level_encryption_profiles_input::Builder::default()
    }
    /// Creates a new `ListFieldLevelEncryptionProfiles` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListFieldLevelEncryptionProfiles {
    type Output = std::result::Result<
        crate::output::ListFieldLevelEncryptionProfilesOutput,
        crate::error::ListFieldLevelEncryptionProfilesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_field_level_encryption_profiles_error(response)
        } else {
            crate::operation_deser::parse_list_field_level_encryption_profiles_response(response)
        }
    }
}

/// Operation shape for `ListFunctions`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_functions`](crate::client::Client::list_functions).
///
/// See [`crate::client::fluent_builders::ListFunctions`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListFunctions {
    _private: (),
}
impl ListFunctions {
    /// Creates a new builder-style object to manufacture [`ListFunctionsInput`](crate::input::ListFunctionsInput)
    pub fn builder() -> crate::input::list_functions_input::Builder {
        crate::input::list_functions_input::Builder::default()
    }
    /// Creates a new `ListFunctions` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListFunctions {
    type Output =
        std::result::Result<crate::output::ListFunctionsOutput, crate::error::ListFunctionsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_functions_error(response)
        } else {
            crate::operation_deser::parse_list_functions_response(response)
        }
    }
}

/// Operation shape for `ListInvalidations`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_invalidations`](crate::client::Client::list_invalidations).
///
/// See [`crate::client::fluent_builders::ListInvalidations`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListInvalidations {
    _private: (),
}
impl ListInvalidations {
    /// Creates a new builder-style object to manufacture [`ListInvalidationsInput`](crate::input::ListInvalidationsInput)
    pub fn builder() -> crate::input::list_invalidations_input::Builder {
        crate::input::list_invalidations_input::Builder::default()
    }
    /// Creates a new `ListInvalidations` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListInvalidations {
    type Output = std::result::Result<
        crate::output::ListInvalidationsOutput,
        crate::error::ListInvalidationsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_invalidations_error(response)
        } else {
            crate::operation_deser::parse_list_invalidations_response(response)
        }
    }
}

/// Operation shape for `ListKeyGroups`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_key_groups`](crate::client::Client::list_key_groups).
///
/// See [`crate::client::fluent_builders::ListKeyGroups`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListKeyGroups {
    _private: (),
}
impl ListKeyGroups {
    /// Creates a new builder-style object to manufacture [`ListKeyGroupsInput`](crate::input::ListKeyGroupsInput)
    pub fn builder() -> crate::input::list_key_groups_input::Builder {
        crate::input::list_key_groups_input::Builder::default()
    }
    /// Creates a new `ListKeyGroups` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListKeyGroups {
    type Output =
        std::result::Result<crate::output::ListKeyGroupsOutput, crate::error::ListKeyGroupsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_key_groups_error(response)
        } else {
            crate::operation_deser::parse_list_key_groups_response(response)
        }
    }
}

/// Operation shape for `ListOriginRequestPolicies`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_origin_request_policies`](crate::client::Client::list_origin_request_policies).
///
/// See [`crate::client::fluent_builders::ListOriginRequestPolicies`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListOriginRequestPolicies {
    _private: (),
}
impl ListOriginRequestPolicies {
    /// Creates a new builder-style object to manufacture [`ListOriginRequestPoliciesInput`](crate::input::ListOriginRequestPoliciesInput)
    pub fn builder() -> crate::input::list_origin_request_policies_input::Builder {
        crate::input::list_origin_request_policies_input::Builder::default()
    }
    /// Creates a new `ListOriginRequestPolicies` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListOriginRequestPolicies {
    type Output = std::result::Result<
        crate::output::ListOriginRequestPoliciesOutput,
        crate::error::ListOriginRequestPoliciesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_origin_request_policies_error(response)
        } else {
            crate::operation_deser::parse_list_origin_request_policies_response(response)
        }
    }
}

/// Operation shape for `ListPublicKeys`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_public_keys`](crate::client::Client::list_public_keys).
///
/// See [`crate::client::fluent_builders::ListPublicKeys`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListPublicKeys {
    _private: (),
}
impl ListPublicKeys {
    /// Creates a new builder-style object to manufacture [`ListPublicKeysInput`](crate::input::ListPublicKeysInput)
    pub fn builder() -> crate::input::list_public_keys_input::Builder {
        crate::input::list_public_keys_input::Builder::default()
    }
    /// Creates a new `ListPublicKeys` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListPublicKeys {
    type Output =
        std::result::Result<crate::output::ListPublicKeysOutput, crate::error::ListPublicKeysError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_public_keys_error(response)
        } else {
            crate::operation_deser::parse_list_public_keys_response(response)
        }
    }
}

/// Operation shape for `ListRealtimeLogConfigs`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_realtime_log_configs`](crate::client::Client::list_realtime_log_configs).
///
/// See [`crate::client::fluent_builders::ListRealtimeLogConfigs`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListRealtimeLogConfigs {
    _private: (),
}
impl ListRealtimeLogConfigs {
    /// Creates a new builder-style object to manufacture [`ListRealtimeLogConfigsInput`](crate::input::ListRealtimeLogConfigsInput)
    pub fn builder() -> crate::input::list_realtime_log_configs_input::Builder {
        crate::input::list_realtime_log_configs_input::Builder::default()
    }
    /// Creates a new `ListRealtimeLogConfigs` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListRealtimeLogConfigs {
    type Output = std::result::Result<
        crate::output::ListRealtimeLogConfigsOutput,
        crate::error::ListRealtimeLogConfigsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_realtime_log_configs_error(response)
        } else {
            crate::operation_deser::parse_list_realtime_log_configs_response(response)
        }
    }
}

/// Operation shape for `ListResponseHeadersPolicies`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_response_headers_policies`](crate::client::Client::list_response_headers_policies).
///
/// See [`crate::client::fluent_builders::ListResponseHeadersPolicies`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListResponseHeadersPolicies {
    _private: (),
}
impl ListResponseHeadersPolicies {
    /// Creates a new builder-style object to manufacture [`ListResponseHeadersPoliciesInput`](crate::input::ListResponseHeadersPoliciesInput)
    pub fn builder() -> crate::input::list_response_headers_policies_input::Builder {
        crate::input::list_response_headers_policies_input::Builder::default()
    }
    /// Creates a new `ListResponseHeadersPolicies` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListResponseHeadersPolicies {
    type Output = std::result::Result<
        crate::output::ListResponseHeadersPoliciesOutput,
        crate::error::ListResponseHeadersPoliciesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_response_headers_policies_error(response)
        } else {
            crate::operation_deser::parse_list_response_headers_policies_response(response)
        }
    }
}

/// Operation shape for `ListStreamingDistributions`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_streaming_distributions`](crate::client::Client::list_streaming_distributions).
///
/// See [`crate::client::fluent_builders::ListStreamingDistributions`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListStreamingDistributions {
    _private: (),
}
impl ListStreamingDistributions {
    /// Creates a new builder-style object to manufacture [`ListStreamingDistributionsInput`](crate::input::ListStreamingDistributionsInput)
    pub fn builder() -> crate::input::list_streaming_distributions_input::Builder {
        crate::input::list_streaming_distributions_input::Builder::default()
    }
    /// Creates a new `ListStreamingDistributions` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListStreamingDistributions {
    type Output = std::result::Result<
        crate::output::ListStreamingDistributionsOutput,
        crate::error::ListStreamingDistributionsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_streaming_distributions_error(response)
        } else {
            crate::operation_deser::parse_list_streaming_distributions_response(response)
        }
    }
}

/// Operation shape for `ListTagsForResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_tags_for_resource`](crate::client::Client::list_tags_for_resource).
///
/// See [`crate::client::fluent_builders::ListTagsForResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListTagsForResource {
    _private: (),
}
impl ListTagsForResource {
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    pub fn builder() -> crate::input::list_tags_for_resource_input::Builder {
        crate::input::list_tags_for_resource_input::Builder::default()
    }
    /// Creates a new `ListTagsForResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListTagsForResource {
    type Output = std::result::Result<
        crate::output::ListTagsForResourceOutput,
        crate::error::ListTagsForResourceError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_tags_for_resource_error(response)
        } else {
            crate::operation_deser::parse_list_tags_for_resource_response(response)
        }
    }
}

/// Operation shape for `PublishFunction`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`publish_function`](crate::client::Client::publish_function).
///
/// See [`crate::client::fluent_builders::PublishFunction`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct PublishFunction {
    _private: (),
}
impl PublishFunction {
    /// Creates a new builder-style object to manufacture [`PublishFunctionInput`](crate::input::PublishFunctionInput)
    pub fn builder() -> crate::input::publish_function_input::Builder {
        crate::input::publish_function_input::Builder::default()
    }
    /// Creates a new `PublishFunction` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for PublishFunction {
    type Output = std::result::Result<
        crate::output::PublishFunctionOutput,
        crate::error::PublishFunctionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_publish_function_error(response)
        } else {
            crate::operation_deser::parse_publish_function_response(response)
        }
    }
}

/// Operation shape for `TagResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`tag_resource`](crate::client::Client::tag_resource).
///
/// See [`crate::client::fluent_builders::TagResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct TagResource {
    _private: (),
}
impl TagResource {
    /// Creates a new builder-style object to manufacture [`TagResourceInput`](crate::input::TagResourceInput)
    pub fn builder() -> crate::input::tag_resource_input::Builder {
        crate::input::tag_resource_input::Builder::default()
    }
    /// Creates a new `TagResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for TagResource {
    type Output =
        std::result::Result<crate::output::TagResourceOutput, crate::error::TagResourceError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 204 {
            crate::operation_deser::parse_tag_resource_error(response)
        } else {
            crate::operation_deser::parse_tag_resource_response(response)
        }
    }
}

/// Operation shape for `TestFunction`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`test_function`](crate::client::Client::test_function).
///
/// See [`crate::client::fluent_builders::TestFunction`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct TestFunction {
    _private: (),
}
impl TestFunction {
    /// Creates a new builder-style object to manufacture [`TestFunctionInput`](crate::input::TestFunctionInput)
    pub fn builder() -> crate::input::test_function_input::Builder {
        crate::input::test_function_input::Builder::default()
    }
    /// Creates a new `TestFunction` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for TestFunction {
    type Output =
        std::result::Result<crate::output::TestFunctionOutput, crate::error::TestFunctionError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_test_function_error(response)
        } else {
            crate::operation_deser::parse_test_function_response(response)
        }
    }
}

/// Operation shape for `UntagResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`untag_resource`](crate::client::Client::untag_resource).
///
/// See [`crate::client::fluent_builders::UntagResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UntagResource {
    _private: (),
}
impl UntagResource {
    /// Creates a new builder-style object to manufacture [`UntagResourceInput`](crate::input::UntagResourceInput)
    pub fn builder() -> crate::input::untag_resource_input::Builder {
        crate::input::untag_resource_input::Builder::default()
    }
    /// Creates a new `UntagResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UntagResource {
    type Output =
        std::result::Result<crate::output::UntagResourceOutput, crate::error::UntagResourceError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 204 {
            crate::operation_deser::parse_untag_resource_error(response)
        } else {
            crate::operation_deser::parse_untag_resource_response(response)
        }
    }
}

/// Operation shape for `UpdateCachePolicy`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_cache_policy`](crate::client::Client::update_cache_policy).
///
/// See [`crate::client::fluent_builders::UpdateCachePolicy`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateCachePolicy {
    _private: (),
}
impl UpdateCachePolicy {
    /// Creates a new builder-style object to manufacture [`UpdateCachePolicyInput`](crate::input::UpdateCachePolicyInput)
    pub fn builder() -> crate::input::update_cache_policy_input::Builder {
        crate::input::update_cache_policy_input::Builder::default()
    }
    /// Creates a new `UpdateCachePolicy` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateCachePolicy {
    type Output = std::result::Result<
        crate::output::UpdateCachePolicyOutput,
        crate::error::UpdateCachePolicyError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_cache_policy_error(response)
        } else {
            crate::operation_deser::parse_update_cache_policy_response(response)
        }
    }
}

/// Operation shape for `UpdateCloudFrontOriginAccessIdentity`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_cloud_front_origin_access_identity`](crate::client::Client::update_cloud_front_origin_access_identity).
///
/// See [`crate::client::fluent_builders::UpdateCloudFrontOriginAccessIdentity`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateCloudFrontOriginAccessIdentity {
    _private: (),
}
impl UpdateCloudFrontOriginAccessIdentity {
    /// Creates a new builder-style object to manufacture [`UpdateCloudFrontOriginAccessIdentityInput`](crate::input::UpdateCloudFrontOriginAccessIdentityInput)
    pub fn builder() -> crate::input::update_cloud_front_origin_access_identity_input::Builder {
        crate::input::update_cloud_front_origin_access_identity_input::Builder::default()
    }
    /// Creates a new `UpdateCloudFrontOriginAccessIdentity` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateCloudFrontOriginAccessIdentity {
    type Output = std::result::Result<
        crate::output::UpdateCloudFrontOriginAccessIdentityOutput,
        crate::error::UpdateCloudFrontOriginAccessIdentityError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_cloud_front_origin_access_identity_error(response)
        } else {
            crate::operation_deser::parse_update_cloud_front_origin_access_identity_response(
                response,
            )
        }
    }
}

/// Operation shape for `UpdateDistribution`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_distribution`](crate::client::Client::update_distribution).
///
/// See [`crate::client::fluent_builders::UpdateDistribution`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateDistribution {
    _private: (),
}
impl UpdateDistribution {
    /// Creates a new builder-style object to manufacture [`UpdateDistributionInput`](crate::input::UpdateDistributionInput)
    pub fn builder() -> crate::input::update_distribution_input::Builder {
        crate::input::update_distribution_input::Builder::default()
    }
    /// Creates a new `UpdateDistribution` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateDistribution {
    type Output = std::result::Result<
        crate::output::UpdateDistributionOutput,
        crate::error::UpdateDistributionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_distribution_error(response)
        } else {
            crate::operation_deser::parse_update_distribution_response(response)
        }
    }
}

/// Operation shape for `UpdateFieldLevelEncryptionConfig`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_field_level_encryption_config`](crate::client::Client::update_field_level_encryption_config).
///
/// See [`crate::client::fluent_builders::UpdateFieldLevelEncryptionConfig`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateFieldLevelEncryptionConfig {
    _private: (),
}
impl UpdateFieldLevelEncryptionConfig {
    /// Creates a new builder-style object to manufacture [`UpdateFieldLevelEncryptionConfigInput`](crate::input::UpdateFieldLevelEncryptionConfigInput)
    pub fn builder() -> crate::input::update_field_level_encryption_config_input::Builder {
        crate::input::update_field_level_encryption_config_input::Builder::default()
    }
    /// Creates a new `UpdateFieldLevelEncryptionConfig` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateFieldLevelEncryptionConfig {
    type Output = std::result::Result<
        crate::output::UpdateFieldLevelEncryptionConfigOutput,
        crate::error::UpdateFieldLevelEncryptionConfigError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_field_level_encryption_config_error(response)
        } else {
            crate::operation_deser::parse_update_field_level_encryption_config_response(response)
        }
    }
}

/// Operation shape for `UpdateFieldLevelEncryptionProfile`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_field_level_encryption_profile`](crate::client::Client::update_field_level_encryption_profile).
///
/// See [`crate::client::fluent_builders::UpdateFieldLevelEncryptionProfile`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateFieldLevelEncryptionProfile {
    _private: (),
}
impl UpdateFieldLevelEncryptionProfile {
    /// Creates a new builder-style object to manufacture [`UpdateFieldLevelEncryptionProfileInput`](crate::input::UpdateFieldLevelEncryptionProfileInput)
    pub fn builder() -> crate::input::update_field_level_encryption_profile_input::Builder {
        crate::input::update_field_level_encryption_profile_input::Builder::default()
    }
    /// Creates a new `UpdateFieldLevelEncryptionProfile` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateFieldLevelEncryptionProfile {
    type Output = std::result::Result<
        crate::output::UpdateFieldLevelEncryptionProfileOutput,
        crate::error::UpdateFieldLevelEncryptionProfileError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_field_level_encryption_profile_error(response)
        } else {
            crate::operation_deser::parse_update_field_level_encryption_profile_response(response)
        }
    }
}

/// Operation shape for `UpdateFunction`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_function`](crate::client::Client::update_function).
///
/// See [`crate::client::fluent_builders::UpdateFunction`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateFunction {
    _private: (),
}
impl UpdateFunction {
    /// Creates a new builder-style object to manufacture [`UpdateFunctionInput`](crate::input::UpdateFunctionInput)
    pub fn builder() -> crate::input::update_function_input::Builder {
        crate::input::update_function_input::Builder::default()
    }
    /// Creates a new `UpdateFunction` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateFunction {
    type Output =
        std::result::Result<crate::output::UpdateFunctionOutput, crate::error::UpdateFunctionError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_function_error(response)
        } else {
            crate::operation_deser::parse_update_function_response(response)
        }
    }
}

/// Operation shape for `UpdateKeyGroup`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_key_group`](crate::client::Client::update_key_group).
///
/// See [`crate::client::fluent_builders::UpdateKeyGroup`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateKeyGroup {
    _private: (),
}
impl UpdateKeyGroup {
    /// Creates a new builder-style object to manufacture [`UpdateKeyGroupInput`](crate::input::UpdateKeyGroupInput)
    pub fn builder() -> crate::input::update_key_group_input::Builder {
        crate::input::update_key_group_input::Builder::default()
    }
    /// Creates a new `UpdateKeyGroup` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateKeyGroup {
    type Output =
        std::result::Result<crate::output::UpdateKeyGroupOutput, crate::error::UpdateKeyGroupError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_key_group_error(response)
        } else {
            crate::operation_deser::parse_update_key_group_response(response)
        }
    }
}

/// Operation shape for `UpdateOriginRequestPolicy`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_origin_request_policy`](crate::client::Client::update_origin_request_policy).
///
/// See [`crate::client::fluent_builders::UpdateOriginRequestPolicy`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateOriginRequestPolicy {
    _private: (),
}
impl UpdateOriginRequestPolicy {
    /// Creates a new builder-style object to manufacture [`UpdateOriginRequestPolicyInput`](crate::input::UpdateOriginRequestPolicyInput)
    pub fn builder() -> crate::input::update_origin_request_policy_input::Builder {
        crate::input::update_origin_request_policy_input::Builder::default()
    }
    /// Creates a new `UpdateOriginRequestPolicy` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateOriginRequestPolicy {
    type Output = std::result::Result<
        crate::output::UpdateOriginRequestPolicyOutput,
        crate::error::UpdateOriginRequestPolicyError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_origin_request_policy_error(response)
        } else {
            crate::operation_deser::parse_update_origin_request_policy_response(response)
        }
    }
}

/// Operation shape for `UpdatePublicKey`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_public_key`](crate::client::Client::update_public_key).
///
/// See [`crate::client::fluent_builders::UpdatePublicKey`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdatePublicKey {
    _private: (),
}
impl UpdatePublicKey {
    /// Creates a new builder-style object to manufacture [`UpdatePublicKeyInput`](crate::input::UpdatePublicKeyInput)
    pub fn builder() -> crate::input::update_public_key_input::Builder {
        crate::input::update_public_key_input::Builder::default()
    }
    /// Creates a new `UpdatePublicKey` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdatePublicKey {
    type Output = std::result::Result<
        crate::output::UpdatePublicKeyOutput,
        crate::error::UpdatePublicKeyError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_public_key_error(response)
        } else {
            crate::operation_deser::parse_update_public_key_response(response)
        }
    }
}

/// Operation shape for `UpdateRealtimeLogConfig`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_realtime_log_config`](crate::client::Client::update_realtime_log_config).
///
/// See [`crate::client::fluent_builders::UpdateRealtimeLogConfig`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateRealtimeLogConfig {
    _private: (),
}
impl UpdateRealtimeLogConfig {
    /// Creates a new builder-style object to manufacture [`UpdateRealtimeLogConfigInput`](crate::input::UpdateRealtimeLogConfigInput)
    pub fn builder() -> crate::input::update_realtime_log_config_input::Builder {
        crate::input::update_realtime_log_config_input::Builder::default()
    }
    /// Creates a new `UpdateRealtimeLogConfig` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateRealtimeLogConfig {
    type Output = std::result::Result<
        crate::output::UpdateRealtimeLogConfigOutput,
        crate::error::UpdateRealtimeLogConfigError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_realtime_log_config_error(response)
        } else {
            crate::operation_deser::parse_update_realtime_log_config_response(response)
        }
    }
}

/// Operation shape for `UpdateResponseHeadersPolicy`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_response_headers_policy`](crate::client::Client::update_response_headers_policy).
///
/// See [`crate::client::fluent_builders::UpdateResponseHeadersPolicy`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateResponseHeadersPolicy {
    _private: (),
}
impl UpdateResponseHeadersPolicy {
    /// Creates a new builder-style object to manufacture [`UpdateResponseHeadersPolicyInput`](crate::input::UpdateResponseHeadersPolicyInput)
    pub fn builder() -> crate::input::update_response_headers_policy_input::Builder {
        crate::input::update_response_headers_policy_input::Builder::default()
    }
    /// Creates a new `UpdateResponseHeadersPolicy` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateResponseHeadersPolicy {
    type Output = std::result::Result<
        crate::output::UpdateResponseHeadersPolicyOutput,
        crate::error::UpdateResponseHeadersPolicyError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_response_headers_policy_error(response)
        } else {
            crate::operation_deser::parse_update_response_headers_policy_response(response)
        }
    }
}

/// Operation shape for `UpdateStreamingDistribution`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_streaming_distribution`](crate::client::Client::update_streaming_distribution).
///
/// See [`crate::client::fluent_builders::UpdateStreamingDistribution`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateStreamingDistribution {
    _private: (),
}
impl UpdateStreamingDistribution {
    /// Creates a new builder-style object to manufacture [`UpdateStreamingDistributionInput`](crate::input::UpdateStreamingDistributionInput)
    pub fn builder() -> crate::input::update_streaming_distribution_input::Builder {
        crate::input::update_streaming_distribution_input::Builder::default()
    }
    /// Creates a new `UpdateStreamingDistribution` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateStreamingDistribution {
    type Output = std::result::Result<
        crate::output::UpdateStreamingDistributionOutput,
        crate::error::UpdateStreamingDistributionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_streaming_distribution_error(response)
        } else {
            crate::operation_deser::parse_update_streaming_distribution_response(response)
        }
    }
}
