// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// All possible error types for this service.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum Error {
    /// <p>Access denied.</p>
    AccessDenied(crate::error::AccessDenied),
    /// <p>Invalidation batch specified is too large.</p>
    BatchTooLarge(crate::error::BatchTooLarge),
    /// <p>The CNAME specified is already defined for CloudFront.</p>
    CnameAlreadyExists(crate::error::CnameAlreadyExists),
    /// <p>A cache policy with this name already exists. You must provide a unique name. To
    /// modify an existing cache policy, use <code>UpdateCachePolicy</code>.</p>
    CachePolicyAlreadyExists(crate::error::CachePolicyAlreadyExists),
    /// <p>Cannot delete the cache policy because it is attached to one or more cache
    /// behaviors.</p>
    CachePolicyInUse(crate::error::CachePolicyInUse),
    /// <p>You can't change the value of a public key.</p>
    CannotChangeImmutablePublicKeyFields(crate::error::CannotChangeImmutablePublicKeyFields),
    /// <p>If the <code>CallerReference</code> is a value you already sent in a previous request to create an identity but the content
    /// of the <code>CloudFrontOriginAccessIdentityConfig</code> is different from the original request, CloudFront returns a
    /// <code>CloudFrontOriginAccessIdentityAlreadyExists</code> error. </p>
    CloudFrontOriginAccessIdentityAlreadyExists(
        crate::error::CloudFrontOriginAccessIdentityAlreadyExists,
    ),
    /// <p>The Origin Access Identity specified is already in use.</p>
    CloudFrontOriginAccessIdentityInUse(crate::error::CloudFrontOriginAccessIdentityInUse),
    /// <p>The caller reference you attempted to create the distribution with is associated with another distribution.</p>
    DistributionAlreadyExists(crate::error::DistributionAlreadyExists),
    /// <p>The specified CloudFront distribution is not disabled. You must disable
    /// the distribution before you can delete it.</p>
    DistributionNotDisabled(crate::error::DistributionNotDisabled),
    /// <p>The specified configuration for field-level encryption already exists.</p>
    FieldLevelEncryptionConfigAlreadyExists(crate::error::FieldLevelEncryptionConfigAlreadyExists),
    /// <p>The specified configuration for field-level encryption is in use.</p>
    FieldLevelEncryptionConfigInUse(crate::error::FieldLevelEncryptionConfigInUse),
    /// <p>The specified profile for field-level encryption already exists.</p>
    FieldLevelEncryptionProfileAlreadyExists(
        crate::error::FieldLevelEncryptionProfileAlreadyExists,
    ),
    /// <p>The specified profile for field-level encryption is in use.</p>
    FieldLevelEncryptionProfileInUse(crate::error::FieldLevelEncryptionProfileInUse),
    /// <p>The maximum size of a profile for field-level encryption was exceeded.</p>
    FieldLevelEncryptionProfileSizeExceeded(crate::error::FieldLevelEncryptionProfileSizeExceeded),
    /// <p>A function with the same name already exists in this Amazon Web Services account. To create a
    /// function, you must provide a unique name. To update an existing function, use
    /// <code>UpdateFunction</code>.</p>
    FunctionAlreadyExists(crate::error::FunctionAlreadyExists),
    /// <p>Cannot delete the function because it’s attached to one or more cache
    /// behaviors.</p>
    FunctionInUse(crate::error::FunctionInUse),
    /// <p>The function is too large. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html">Quotas</a> (formerly known as limits) in the
    /// <i>Amazon CloudFront Developer Guide</i>.</p>
    FunctionSizeLimitExceeded(crate::error::FunctionSizeLimitExceeded),
    /// <p>You cannot delete a managed policy.</p>
    IllegalDelete(crate::error::IllegalDelete),
    /// <p>The specified configuration for field-level encryption can't be associated with the specified cache behavior.</p>
    IllegalFieldLevelEncryptionConfigAssociationWithCacheBehavior(
        crate::error::IllegalFieldLevelEncryptionConfigAssociationWithCacheBehavior,
    ),
    /// <p>The update contains modifications that are not allowed.</p>
    IllegalUpdate(crate::error::IllegalUpdate),
    /// <p>The value of <code>Quantity</code> and the size of <code>Items</code> don't match.</p>
    InconsistentQuantities(crate::error::InconsistentQuantities),
    /// <p>An argument is invalid.</p>
    InvalidArgument(crate::error::InvalidArgument),
    /// <p>The default root object file name is too big or contains an invalid character.</p>
    InvalidDefaultRootObject(crate::error::InvalidDefaultRootObject),
    /// <p>An invalid error code was specified.</p>
    InvalidErrorCode(crate::error::InvalidErrorCode),
    /// <p>Your request contains forward cookies option which doesn't match with the expectation for the <code>whitelisted</code>
    /// list of cookie names. Either list of cookie names has been specified when not allowed or list of cookie names is missing when expected.</p>
    InvalidForwardCookies(crate::error::InvalidForwardCookies),
    /// <p>A CloudFront function association is invalid.</p>
    InvalidFunctionAssociation(crate::error::InvalidFunctionAssociation),
    /// <p>The specified geo restriction parameter is not valid.</p>
    InvalidGeoRestrictionParameter(crate::error::InvalidGeoRestrictionParameter),
    /// <p>The headers specified are not valid for an Amazon S3 origin.</p>
    InvalidHeadersForS3Origin(crate::error::InvalidHeadersForS3Origin),
    /// <p>The <code>If-Match</code> version is missing or not valid.</p>
    InvalidIfMatchVersion(crate::error::InvalidIfMatchVersion),
    /// <p>The specified Lambda@Edge function association is invalid.</p>
    InvalidLambdaFunctionAssociation(crate::error::InvalidLambdaFunctionAssociation),
    /// <p>The location code specified is not valid.</p>
    InvalidLocationCode(crate::error::InvalidLocationCode),
    /// <p>The minimum protocol version specified is not valid.</p>
    InvalidMinimumProtocolVersion(crate::error::InvalidMinimumProtocolVersion),
    /// <p>The Amazon S3 origin server specified does not refer to a valid Amazon S3 bucket.</p>
    InvalidOrigin(crate::error::InvalidOrigin),
    /// <p>The origin access identity is not valid or doesn't exist.</p>
    InvalidOriginAccessIdentity(crate::error::InvalidOriginAccessIdentity),
    /// <p>The keep alive timeout specified for the origin is not valid.</p>
    InvalidOriginKeepaliveTimeout(crate::error::InvalidOriginKeepaliveTimeout),
    /// <p>The read timeout specified for the origin is not valid.</p>
    InvalidOriginReadTimeout(crate::error::InvalidOriginReadTimeout),
    /// <p>You cannot specify SSLv3 as the minimum protocol version if you only want to support only clients that support
    /// Server Name Indication (SNI).</p>
    InvalidProtocolSettings(crate::error::InvalidProtocolSettings),
    /// <p>The query string parameters specified are not valid.</p>
    InvalidQueryStringParameters(crate::error::InvalidQueryStringParameters),
    /// <p>The relative path is too big, is not URL-encoded, or does not begin with a slash (/).</p>
    InvalidRelativePath(crate::error::InvalidRelativePath),
    /// <p>This operation requires the HTTPS protocol. Ensure that you specify the HTTPS protocol in your request, or omit the
    /// <code>RequiredProtocols</code> element from your distribution configuration.</p>
    InvalidRequiredProtocol(crate::error::InvalidRequiredProtocol),
    /// <p>A response code is not valid.</p>
    InvalidResponseCode(crate::error::InvalidResponseCode),
    /// <p>The TTL order specified is not valid.</p>
    InvalidTtlOrder(crate::error::InvalidTtlOrder),
    /// <p>The tagging specified is not valid.</p>
    InvalidTagging(crate::error::InvalidTagging),
    /// <p>A viewer certificate specified is not valid.</p>
    InvalidViewerCertificate(crate::error::InvalidViewerCertificate),
    /// <p>A web ACL ID specified is not valid. To specify a web ACL created using the latest
    /// version of WAF, use the ACL ARN, for example
    /// <code>arn:aws:wafv2:us-east-1:123456789012:global/webacl/ExampleWebACL/473e64fd-f30b-4765-81a0-62ad96dd167a</code>.
    /// To specify a web ACL created using WAF Classic, use the ACL ID, for example
    /// <code>473e64fd-f30b-4765-81a0-62ad96dd167a</code>.</p>
    InvalidWebAclId(crate::error::InvalidWebAclId),
    /// <p>A key group with this name already exists. You must provide a unique name. To modify an
    /// existing key group, use <code>UpdateKeyGroup</code>.</p>
    KeyGroupAlreadyExists(crate::error::KeyGroupAlreadyExists),
    /// <p>This operation requires a body. Ensure that the body is present and the <code>Content-Type</code> header is set.</p>
    MissingBody(crate::error::MissingBody),
    /// <p>The cache policy does not exist.</p>
    NoSuchCachePolicy(crate::error::NoSuchCachePolicy),
    /// <p>The specified origin access identity does not exist.</p>
    NoSuchCloudFrontOriginAccessIdentity(crate::error::NoSuchCloudFrontOriginAccessIdentity),
    /// <p>The specified distribution does not exist.</p>
    NoSuchDistribution(crate::error::NoSuchDistribution),
    /// <p>The specified configuration for field-level encryption doesn't exist.</p>
    NoSuchFieldLevelEncryptionConfig(crate::error::NoSuchFieldLevelEncryptionConfig),
    /// <p>The specified profile for field-level encryption doesn't exist.</p>
    NoSuchFieldLevelEncryptionProfile(crate::error::NoSuchFieldLevelEncryptionProfile),
    /// <p>The function does not exist.</p>
    NoSuchFunctionExists(crate::error::NoSuchFunctionExists),
    /// <p>The specified invalidation does not exist.</p>
    NoSuchInvalidation(crate::error::NoSuchInvalidation),
    /// <p>No origin exists with the specified <code>Origin Id</code>. </p>
    NoSuchOrigin(crate::error::NoSuchOrigin),
    /// <p>The origin request policy does not exist.</p>
    NoSuchOriginRequestPolicy(crate::error::NoSuchOriginRequestPolicy),
    /// <p>The specified public key doesn't exist.</p>
    NoSuchPublicKey(crate::error::NoSuchPublicKey),
    /// <p>The real-time log configuration does not exist.</p>
    NoSuchRealtimeLogConfig(crate::error::NoSuchRealtimeLogConfig),
    /// <p>A resource that was specified is not valid.</p>
    NoSuchResource(crate::error::NoSuchResource),
    /// <p>The response headers policy does not exist.</p>
    NoSuchResponseHeadersPolicy(crate::error::NoSuchResponseHeadersPolicy),
    /// <p>The specified streaming distribution does not exist.</p>
    NoSuchStreamingDistribution(crate::error::NoSuchStreamingDistribution),
    /// <p>An origin request policy with this name already exists. You must provide a unique
    /// name. To modify an existing origin request policy, use
    /// <code>UpdateOriginRequestPolicy</code>.</p>
    OriginRequestPolicyAlreadyExists(crate::error::OriginRequestPolicyAlreadyExists),
    /// <p>Cannot delete the origin request policy because it is attached to one or more cache
    /// behaviors.</p>
    OriginRequestPolicyInUse(crate::error::OriginRequestPolicyInUse),
    /// <p>The precondition in one or more of the request fields evaluated to
    /// <code>false</code>.</p>
    PreconditionFailed(crate::error::PreconditionFailed),
    /// <p>The specified public key already exists.</p>
    PublicKeyAlreadyExists(crate::error::PublicKeyAlreadyExists),
    /// <p>The specified public key is in use. </p>
    PublicKeyInUse(crate::error::PublicKeyInUse),
    /// <p>No profile specified for the field-level encryption query argument.</p>
    QueryArgProfileEmpty(crate::error::QueryArgProfileEmpty),
    /// <p>A real-time log configuration with this name already exists. You must provide a unique name.
    /// To modify an existing real-time log configuration, use
    /// <code>UpdateRealtimeLogConfig</code>.</p>
    RealtimeLogConfigAlreadyExists(crate::error::RealtimeLogConfigAlreadyExists),
    /// <p>Cannot delete the real-time log configuration because it is attached to one or more cache
    /// behaviors.</p>
    RealtimeLogConfigInUse(crate::error::RealtimeLogConfigInUse),
    /// <p>The specified real-time log configuration belongs to a different Amazon Web Services account.</p>
    RealtimeLogConfigOwnerMismatch(crate::error::RealtimeLogConfigOwnerMismatch),
    /// <p>Cannot delete this resource because it is in use.</p>
    ResourceInUse(crate::error::ResourceInUse),
    /// <p>A response headers policy with this name already exists. You must provide a unique name. To
    /// modify an existing response headers policy, use
    /// <code>UpdateResponseHeadersPolicy</code>.</p>
    ResponseHeadersPolicyAlreadyExists(crate::error::ResponseHeadersPolicyAlreadyExists),
    /// <p>Cannot delete the response headers policy because it is attached to one or more cache
    /// behaviors in a CloudFront distribution. </p>
    ResponseHeadersPolicyInUse(crate::error::ResponseHeadersPolicyInUse),
    /// <p>The caller reference you attempted to create the streaming distribution with
    /// is associated with another distribution</p>
    StreamingDistributionAlreadyExists(crate::error::StreamingDistributionAlreadyExists),
    /// <p>The specified CloudFront distribution is not disabled. You must disable
    /// the distribution before you can delete it.</p>
    StreamingDistributionNotDisabled(crate::error::StreamingDistributionNotDisabled),
    /// <p>The CloudFront function failed.</p>
    TestFunctionFailed(crate::error::TestFunctionFailed),
    /// <p>You cannot create more cache behaviors for the distribution.</p>
    TooManyCacheBehaviors(crate::error::TooManyCacheBehaviors),
    /// <p>You have reached the maximum number of cache policies for this Amazon Web Services account. For more
    /// information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html">Quotas</a> (formerly known as limits) in the
    /// <i>Amazon CloudFront Developer Guide</i>.</p>
    TooManyCachePolicies(crate::error::TooManyCachePolicies),
    /// <p>You cannot create anymore custom SSL/TLS certificates.</p>
    TooManyCertificates(crate::error::TooManyCertificates),
    /// <p>Processing your request would cause you to exceed the maximum number of origin access identities allowed.</p>
    TooManyCloudFrontOriginAccessIdentities(crate::error::TooManyCloudFrontOriginAccessIdentities),
    /// <p>Your request contains more cookie names in the whitelist than are allowed per cache behavior.</p>
    TooManyCookieNamesInWhiteList(crate::error::TooManyCookieNamesInWhiteList),
    /// <p>The number of cookies in the cache policy exceeds the maximum. For more information,
    /// see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html">Quotas</a> (formerly known as limits) in the
    /// <i>Amazon CloudFront Developer Guide</i>.</p>
    TooManyCookiesInCachePolicy(crate::error::TooManyCookiesInCachePolicy),
    /// <p>The number of cookies in the origin request policy exceeds the maximum. For more
    /// information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html">Quotas</a> (formerly known as limits) in the
    /// <i>Amazon CloudFront Developer Guide</i>.</p>
    TooManyCookiesInOriginRequestPolicy(crate::error::TooManyCookiesInOriginRequestPolicy),
    /// <p>The number of custom headers in the response headers policy exceeds the maximum.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html">Quotas</a> (formerly known as limits) in the
    /// <i>Amazon CloudFront Developer Guide</i>.</p>
    TooManyCustomHeadersInResponseHeadersPolicy(
        crate::error::TooManyCustomHeadersInResponseHeadersPolicy,
    ),
    /// <p>Your request contains more CNAMEs than are allowed per distribution.</p>
    TooManyDistributionCnamEs(crate::error::TooManyDistributionCnamEs),
    /// <p>Processing your request would cause you to exceed the maximum number of distributions allowed.</p>
    TooManyDistributions(crate::error::TooManyDistributions),
    /// <p>The maximum number of distributions have been associated with the specified cache
    /// policy. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html">Quotas</a> (formerly known as limits) in the
    /// <i>Amazon CloudFront Developer Guide</i>.</p>
    TooManyDistributionsAssociatedToCachePolicy(
        crate::error::TooManyDistributionsAssociatedToCachePolicy,
    ),
    /// <p>The maximum number of distributions have been associated with the specified configuration for field-level encryption.</p>
    TooManyDistributionsAssociatedToFieldLevelEncryptionConfig(
        crate::error::TooManyDistributionsAssociatedToFieldLevelEncryptionConfig,
    ),
    /// <p>The number of distributions that reference this key group is more than the maximum
    /// allowed. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html">Quotas</a> (formerly known as limits) in the
    /// <i>Amazon CloudFront Developer Guide</i>.</p>
    TooManyDistributionsAssociatedToKeyGroup(
        crate::error::TooManyDistributionsAssociatedToKeyGroup,
    ),
    /// <p>The maximum number of distributions have been associated with the specified origin
    /// request policy. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html">Quotas</a> (formerly known as limits) in the
    /// <i>Amazon CloudFront Developer Guide</i>.</p>
    TooManyDistributionsAssociatedToOriginRequestPolicy(
        crate::error::TooManyDistributionsAssociatedToOriginRequestPolicy,
    ),
    /// <p>The maximum number of distributions have been associated with the specified response headers
    /// policy.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html">Quotas</a> (formerly known as limits) in the
    /// <i>Amazon CloudFront Developer Guide</i>.</p>
    TooManyDistributionsAssociatedToResponseHeadersPolicy(
        crate::error::TooManyDistributionsAssociatedToResponseHeadersPolicy,
    ),
    /// <p>You have reached the maximum number of distributions that are associated with a CloudFront
    /// function. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html">Quotas</a> (formerly known as limits) in the
    /// <i>Amazon CloudFront Developer Guide</i>.</p>
    TooManyDistributionsWithFunctionAssociations(
        crate::error::TooManyDistributionsWithFunctionAssociations,
    ),
    /// <p>Processing your request would cause the maximum number of distributions with Lambda@Edge function associations per owner
    /// to be exceeded.</p>
    TooManyDistributionsWithLambdaAssociations(
        crate::error::TooManyDistributionsWithLambdaAssociations,
    ),
    /// <p>The maximum number of distributions have been associated with the specified Lambda@Edge
    /// function.</p>
    TooManyDistributionsWithSingleFunctionArn(
        crate::error::TooManyDistributionsWithSingleFunctionArn,
    ),
    /// <p>The maximum number of configurations for field-level encryption have been created.</p>
    TooManyFieldLevelEncryptionConfigs(crate::error::TooManyFieldLevelEncryptionConfigs),
    /// <p>The maximum number of content type profiles for field-level encryption have been created.</p>
    TooManyFieldLevelEncryptionContentTypeProfiles(
        crate::error::TooManyFieldLevelEncryptionContentTypeProfiles,
    ),
    /// <p>The maximum number of encryption entities for field-level encryption have been created.</p>
    TooManyFieldLevelEncryptionEncryptionEntities(
        crate::error::TooManyFieldLevelEncryptionEncryptionEntities,
    ),
    /// <p>The maximum number of field patterns for field-level encryption have been created.</p>
    TooManyFieldLevelEncryptionFieldPatterns(
        crate::error::TooManyFieldLevelEncryptionFieldPatterns,
    ),
    /// <p>The maximum number of profiles for field-level encryption have been created.</p>
    TooManyFieldLevelEncryptionProfiles(crate::error::TooManyFieldLevelEncryptionProfiles),
    /// <p>The maximum number of query arg profiles for field-level encryption have been created.</p>
    TooManyFieldLevelEncryptionQueryArgProfiles(
        crate::error::TooManyFieldLevelEncryptionQueryArgProfiles,
    ),
    /// <p>You have reached the maximum number of CloudFront function associations for this
    /// distribution. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html">Quotas</a> (formerly known as limits) in the
    /// <i>Amazon CloudFront Developer Guide</i>.</p>
    TooManyFunctionAssociations(crate::error::TooManyFunctionAssociations),
    /// <p>You have reached the maximum number of CloudFront functions for this Amazon Web Services account. For more
    /// information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html">Quotas</a> (formerly known as limits) in the
    /// <i>Amazon CloudFront Developer Guide</i>.</p>
    TooManyFunctions(crate::error::TooManyFunctions),
    /// <p>The number of headers in the cache policy exceeds the maximum. For more information,
    /// see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html">Quotas</a> (formerly known as limits) in the
    /// <i>Amazon CloudFront Developer Guide</i>.</p>
    TooManyHeadersInCachePolicy(crate::error::TooManyHeadersInCachePolicy),
    /// <p>Your request contains too many headers in forwarded values.</p>
    TooManyHeadersInForwardedValues(crate::error::TooManyHeadersInForwardedValues),
    /// <p>The number of headers in the origin request policy exceeds the maximum. For more
    /// information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html">Quotas</a> (formerly known as limits) in the
    /// <i>Amazon CloudFront Developer Guide</i>.</p>
    TooManyHeadersInOriginRequestPolicy(crate::error::TooManyHeadersInOriginRequestPolicy),
    /// <p>You have exceeded the maximum number of allowable InProgress invalidation batch requests, or invalidation objects.</p>
    TooManyInvalidationsInProgress(crate::error::TooManyInvalidationsInProgress),
    /// <p>You have reached the maximum number of key groups for this Amazon Web Services account. For more
    /// information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html">Quotas</a> (formerly known as limits) in the
    /// <i>Amazon CloudFront Developer Guide</i>.</p>
    TooManyKeyGroups(crate::error::TooManyKeyGroups),
    /// <p>The number of key groups referenced by this distribution is more than the maximum
    /// allowed. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html">Quotas</a> (formerly known as limits) in the
    /// <i>Amazon CloudFront Developer Guide</i>.</p>
    TooManyKeyGroupsAssociatedToDistribution(
        crate::error::TooManyKeyGroupsAssociatedToDistribution,
    ),
    /// <p>Your request contains more Lambda@Edge function associations than are allowed per distribution.</p>
    TooManyLambdaFunctionAssociations(crate::error::TooManyLambdaFunctionAssociations),
    /// <p>Your request contains too many origin custom headers.</p>
    TooManyOriginCustomHeaders(crate::error::TooManyOriginCustomHeaders),
    /// <p>Processing your request would cause you to exceed the maximum number of origin groups allowed.</p>
    TooManyOriginGroupsPerDistribution(crate::error::TooManyOriginGroupsPerDistribution),
    /// <p>You have reached the maximum number of origin request policies for this Amazon Web Services account.
    /// For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html">Quotas</a> (formerly known as limits) in the
    /// <i>Amazon CloudFront Developer Guide</i>.</p>
    TooManyOriginRequestPolicies(crate::error::TooManyOriginRequestPolicies),
    /// <p>You cannot create more origins for the distribution.</p>
    TooManyOrigins(crate::error::TooManyOrigins),
    /// <p>The maximum number of public keys for field-level encryption have been created. To create a new public key, delete one of the existing keys.</p>
    TooManyPublicKeys(crate::error::TooManyPublicKeys),
    /// <p>The number of public keys in this key group is more than the maximum allowed. For more
    /// information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html">Quotas</a> (formerly known as limits) in the
    /// <i>Amazon CloudFront Developer Guide</i>.</p>
    TooManyPublicKeysInKeyGroup(crate::error::TooManyPublicKeysInKeyGroup),
    /// <p>Your request contains too many query string parameters.</p>
    TooManyQueryStringParameters(crate::error::TooManyQueryStringParameters),
    /// <p>The number of query strings in the cache policy exceeds the maximum. For more
    /// information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html">Quotas</a> (formerly known as limits) in the
    /// <i>Amazon CloudFront Developer Guide</i>.</p>
    TooManyQueryStringsInCachePolicy(crate::error::TooManyQueryStringsInCachePolicy),
    /// <p>The number of query strings in the origin request policy exceeds the maximum. For more
    /// information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html">Quotas</a> (formerly known as limits) in the
    /// <i>Amazon CloudFront Developer Guide</i>.</p>
    TooManyQueryStringsInOriginRequestPolicy(
        crate::error::TooManyQueryStringsInOriginRequestPolicy,
    ),
    /// <p>You have reached the maximum number of real-time log configurations for this Amazon Web Services account.
    /// For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html">Quotas</a> (formerly known as limits) in the
    /// <i>Amazon CloudFront Developer Guide</i>.</p>
    TooManyRealtimeLogConfigs(crate::error::TooManyRealtimeLogConfigs),
    /// <p>You have reached the maximum number of response headers policies for this
    /// Amazon Web Services account.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html">Quotas</a> (formerly known as limits) in the
    /// <i>Amazon CloudFront Developer Guide</i>.</p>
    TooManyResponseHeadersPolicies(crate::error::TooManyResponseHeadersPolicies),
    /// <p>Your request contains more CNAMEs than are allowed per distribution.</p>
    TooManyStreamingDistributionCnamEs(crate::error::TooManyStreamingDistributionCnamEs),
    /// <p>Processing your request would cause you to exceed the maximum number of streaming distributions allowed.</p>
    TooManyStreamingDistributions(crate::error::TooManyStreamingDistributions),
    /// <p>Your request contains more trusted signers than are allowed per distribution.</p>
    TooManyTrustedSigners(crate::error::TooManyTrustedSigners),
    /// <p>The specified key group does not exist.</p>
    TrustedKeyGroupDoesNotExist(crate::error::TrustedKeyGroupDoesNotExist),
    /// <p>One or more of your trusted signers don't exist.</p>
    TrustedSignerDoesNotExist(crate::error::TrustedSignerDoesNotExist),
    /// <p>This operation is not supported in this region.</p>
    UnsupportedOperation(crate::error::UnsupportedOperation),
    /// An unhandled error occurred.
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for Error {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match self {
            Error::AccessDenied(inner) => inner.fmt(f),
            Error::BatchTooLarge(inner) => inner.fmt(f),
            Error::CnameAlreadyExists(inner) => inner.fmt(f),
            Error::CachePolicyAlreadyExists(inner) => inner.fmt(f),
            Error::CachePolicyInUse(inner) => inner.fmt(f),
            Error::CannotChangeImmutablePublicKeyFields(inner) => inner.fmt(f),
            Error::CloudFrontOriginAccessIdentityAlreadyExists(inner) => inner.fmt(f),
            Error::CloudFrontOriginAccessIdentityInUse(inner) => inner.fmt(f),
            Error::DistributionAlreadyExists(inner) => inner.fmt(f),
            Error::DistributionNotDisabled(inner) => inner.fmt(f),
            Error::FieldLevelEncryptionConfigAlreadyExists(inner) => inner.fmt(f),
            Error::FieldLevelEncryptionConfigInUse(inner) => inner.fmt(f),
            Error::FieldLevelEncryptionProfileAlreadyExists(inner) => inner.fmt(f),
            Error::FieldLevelEncryptionProfileInUse(inner) => inner.fmt(f),
            Error::FieldLevelEncryptionProfileSizeExceeded(inner) => inner.fmt(f),
            Error::FunctionAlreadyExists(inner) => inner.fmt(f),
            Error::FunctionInUse(inner) => inner.fmt(f),
            Error::FunctionSizeLimitExceeded(inner) => inner.fmt(f),
            Error::IllegalDelete(inner) => inner.fmt(f),
            Error::IllegalFieldLevelEncryptionConfigAssociationWithCacheBehavior(inner) => {
                inner.fmt(f)
            }
            Error::IllegalUpdate(inner) => inner.fmt(f),
            Error::InconsistentQuantities(inner) => inner.fmt(f),
            Error::InvalidArgument(inner) => inner.fmt(f),
            Error::InvalidDefaultRootObject(inner) => inner.fmt(f),
            Error::InvalidErrorCode(inner) => inner.fmt(f),
            Error::InvalidForwardCookies(inner) => inner.fmt(f),
            Error::InvalidFunctionAssociation(inner) => inner.fmt(f),
            Error::InvalidGeoRestrictionParameter(inner) => inner.fmt(f),
            Error::InvalidHeadersForS3Origin(inner) => inner.fmt(f),
            Error::InvalidIfMatchVersion(inner) => inner.fmt(f),
            Error::InvalidLambdaFunctionAssociation(inner) => inner.fmt(f),
            Error::InvalidLocationCode(inner) => inner.fmt(f),
            Error::InvalidMinimumProtocolVersion(inner) => inner.fmt(f),
            Error::InvalidOrigin(inner) => inner.fmt(f),
            Error::InvalidOriginAccessIdentity(inner) => inner.fmt(f),
            Error::InvalidOriginKeepaliveTimeout(inner) => inner.fmt(f),
            Error::InvalidOriginReadTimeout(inner) => inner.fmt(f),
            Error::InvalidProtocolSettings(inner) => inner.fmt(f),
            Error::InvalidQueryStringParameters(inner) => inner.fmt(f),
            Error::InvalidRelativePath(inner) => inner.fmt(f),
            Error::InvalidRequiredProtocol(inner) => inner.fmt(f),
            Error::InvalidResponseCode(inner) => inner.fmt(f),
            Error::InvalidTtlOrder(inner) => inner.fmt(f),
            Error::InvalidTagging(inner) => inner.fmt(f),
            Error::InvalidViewerCertificate(inner) => inner.fmt(f),
            Error::InvalidWebAclId(inner) => inner.fmt(f),
            Error::KeyGroupAlreadyExists(inner) => inner.fmt(f),
            Error::MissingBody(inner) => inner.fmt(f),
            Error::NoSuchCachePolicy(inner) => inner.fmt(f),
            Error::NoSuchCloudFrontOriginAccessIdentity(inner) => inner.fmt(f),
            Error::NoSuchDistribution(inner) => inner.fmt(f),
            Error::NoSuchFieldLevelEncryptionConfig(inner) => inner.fmt(f),
            Error::NoSuchFieldLevelEncryptionProfile(inner) => inner.fmt(f),
            Error::NoSuchFunctionExists(inner) => inner.fmt(f),
            Error::NoSuchInvalidation(inner) => inner.fmt(f),
            Error::NoSuchOrigin(inner) => inner.fmt(f),
            Error::NoSuchOriginRequestPolicy(inner) => inner.fmt(f),
            Error::NoSuchPublicKey(inner) => inner.fmt(f),
            Error::NoSuchRealtimeLogConfig(inner) => inner.fmt(f),
            Error::NoSuchResource(inner) => inner.fmt(f),
            Error::NoSuchResponseHeadersPolicy(inner) => inner.fmt(f),
            Error::NoSuchStreamingDistribution(inner) => inner.fmt(f),
            Error::OriginRequestPolicyAlreadyExists(inner) => inner.fmt(f),
            Error::OriginRequestPolicyInUse(inner) => inner.fmt(f),
            Error::PreconditionFailed(inner) => inner.fmt(f),
            Error::PublicKeyAlreadyExists(inner) => inner.fmt(f),
            Error::PublicKeyInUse(inner) => inner.fmt(f),
            Error::QueryArgProfileEmpty(inner) => inner.fmt(f),
            Error::RealtimeLogConfigAlreadyExists(inner) => inner.fmt(f),
            Error::RealtimeLogConfigInUse(inner) => inner.fmt(f),
            Error::RealtimeLogConfigOwnerMismatch(inner) => inner.fmt(f),
            Error::ResourceInUse(inner) => inner.fmt(f),
            Error::ResponseHeadersPolicyAlreadyExists(inner) => inner.fmt(f),
            Error::ResponseHeadersPolicyInUse(inner) => inner.fmt(f),
            Error::StreamingDistributionAlreadyExists(inner) => inner.fmt(f),
            Error::StreamingDistributionNotDisabled(inner) => inner.fmt(f),
            Error::TestFunctionFailed(inner) => inner.fmt(f),
            Error::TooManyCacheBehaviors(inner) => inner.fmt(f),
            Error::TooManyCachePolicies(inner) => inner.fmt(f),
            Error::TooManyCertificates(inner) => inner.fmt(f),
            Error::TooManyCloudFrontOriginAccessIdentities(inner) => inner.fmt(f),
            Error::TooManyCookieNamesInWhiteList(inner) => inner.fmt(f),
            Error::TooManyCookiesInCachePolicy(inner) => inner.fmt(f),
            Error::TooManyCookiesInOriginRequestPolicy(inner) => inner.fmt(f),
            Error::TooManyCustomHeadersInResponseHeadersPolicy(inner) => inner.fmt(f),
            Error::TooManyDistributionCnamEs(inner) => inner.fmt(f),
            Error::TooManyDistributions(inner) => inner.fmt(f),
            Error::TooManyDistributionsAssociatedToCachePolicy(inner) => inner.fmt(f),
            Error::TooManyDistributionsAssociatedToFieldLevelEncryptionConfig(inner) => {
                inner.fmt(f)
            }
            Error::TooManyDistributionsAssociatedToKeyGroup(inner) => inner.fmt(f),
            Error::TooManyDistributionsAssociatedToOriginRequestPolicy(inner) => inner.fmt(f),
            Error::TooManyDistributionsAssociatedToResponseHeadersPolicy(inner) => inner.fmt(f),
            Error::TooManyDistributionsWithFunctionAssociations(inner) => inner.fmt(f),
            Error::TooManyDistributionsWithLambdaAssociations(inner) => inner.fmt(f),
            Error::TooManyDistributionsWithSingleFunctionArn(inner) => inner.fmt(f),
            Error::TooManyFieldLevelEncryptionConfigs(inner) => inner.fmt(f),
            Error::TooManyFieldLevelEncryptionContentTypeProfiles(inner) => inner.fmt(f),
            Error::TooManyFieldLevelEncryptionEncryptionEntities(inner) => inner.fmt(f),
            Error::TooManyFieldLevelEncryptionFieldPatterns(inner) => inner.fmt(f),
            Error::TooManyFieldLevelEncryptionProfiles(inner) => inner.fmt(f),
            Error::TooManyFieldLevelEncryptionQueryArgProfiles(inner) => inner.fmt(f),
            Error::TooManyFunctionAssociations(inner) => inner.fmt(f),
            Error::TooManyFunctions(inner) => inner.fmt(f),
            Error::TooManyHeadersInCachePolicy(inner) => inner.fmt(f),
            Error::TooManyHeadersInForwardedValues(inner) => inner.fmt(f),
            Error::TooManyHeadersInOriginRequestPolicy(inner) => inner.fmt(f),
            Error::TooManyInvalidationsInProgress(inner) => inner.fmt(f),
            Error::TooManyKeyGroups(inner) => inner.fmt(f),
            Error::TooManyKeyGroupsAssociatedToDistribution(inner) => inner.fmt(f),
            Error::TooManyLambdaFunctionAssociations(inner) => inner.fmt(f),
            Error::TooManyOriginCustomHeaders(inner) => inner.fmt(f),
            Error::TooManyOriginGroupsPerDistribution(inner) => inner.fmt(f),
            Error::TooManyOriginRequestPolicies(inner) => inner.fmt(f),
            Error::TooManyOrigins(inner) => inner.fmt(f),
            Error::TooManyPublicKeys(inner) => inner.fmt(f),
            Error::TooManyPublicKeysInKeyGroup(inner) => inner.fmt(f),
            Error::TooManyQueryStringParameters(inner) => inner.fmt(f),
            Error::TooManyQueryStringsInCachePolicy(inner) => inner.fmt(f),
            Error::TooManyQueryStringsInOriginRequestPolicy(inner) => inner.fmt(f),
            Error::TooManyRealtimeLogConfigs(inner) => inner.fmt(f),
            Error::TooManyResponseHeadersPolicies(inner) => inner.fmt(f),
            Error::TooManyStreamingDistributionCnamEs(inner) => inner.fmt(f),
            Error::TooManyStreamingDistributions(inner) => inner.fmt(f),
            Error::TooManyTrustedSigners(inner) => inner.fmt(f),
            Error::TrustedKeyGroupDoesNotExist(inner) => inner.fmt(f),
            Error::TrustedSignerDoesNotExist(inner) => inner.fmt(f),
            Error::UnsupportedOperation(inner) => inner.fmt(f),
            Error::Unhandled(inner) => inner.fmt(f),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::AssociateAliasError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::AssociateAliasError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::AssociateAliasErrorKind::AccessDenied(inner) => {
                    Error::AccessDenied(inner)
                }
                crate::error::AssociateAliasErrorKind::IllegalUpdate(inner) => {
                    Error::IllegalUpdate(inner)
                }
                crate::error::AssociateAliasErrorKind::InvalidArgument(inner) => {
                    Error::InvalidArgument(inner)
                }
                crate::error::AssociateAliasErrorKind::NoSuchDistribution(inner) => {
                    Error::NoSuchDistribution(inner)
                }
                crate::error::AssociateAliasErrorKind::TooManyDistributionCnamEs(inner) => {
                    Error::TooManyDistributionCnamEs(inner)
                }
                crate::error::AssociateAliasErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CreateCachePolicyError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::CreateCachePolicyError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::CreateCachePolicyErrorKind::AccessDenied(inner) => {
                    Error::AccessDenied(inner)
                }
                crate::error::CreateCachePolicyErrorKind::CachePolicyAlreadyExists(inner) => {
                    Error::CachePolicyAlreadyExists(inner)
                }
                crate::error::CreateCachePolicyErrorKind::InconsistentQuantities(inner) => {
                    Error::InconsistentQuantities(inner)
                }
                crate::error::CreateCachePolicyErrorKind::InvalidArgument(inner) => {
                    Error::InvalidArgument(inner)
                }
                crate::error::CreateCachePolicyErrorKind::TooManyCachePolicies(inner) => {
                    Error::TooManyCachePolicies(inner)
                }
                crate::error::CreateCachePolicyErrorKind::TooManyCookiesInCachePolicy(inner) => {
                    Error::TooManyCookiesInCachePolicy(inner)
                }
                crate::error::CreateCachePolicyErrorKind::TooManyHeadersInCachePolicy(inner) => {
                    Error::TooManyHeadersInCachePolicy(inner)
                }
                crate::error::CreateCachePolicyErrorKind::TooManyQueryStringsInCachePolicy(
                    inner,
                ) => Error::TooManyQueryStringsInCachePolicy(inner),
                crate::error::CreateCachePolicyErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<
        aws_smithy_http::result::SdkError<
            crate::error::CreateCloudFrontOriginAccessIdentityError,
            R,
        >,
    > for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::CreateCloudFrontOriginAccessIdentityError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::CreateCloudFrontOriginAccessIdentityErrorKind::CloudFrontOriginAccessIdentityAlreadyExists(inner) => Error::CloudFrontOriginAccessIdentityAlreadyExists(inner),
                crate::error::CreateCloudFrontOriginAccessIdentityErrorKind::InconsistentQuantities(inner) => Error::InconsistentQuantities(inner),
                crate::error::CreateCloudFrontOriginAccessIdentityErrorKind::InvalidArgument(inner) => Error::InvalidArgument(inner),
                crate::error::CreateCloudFrontOriginAccessIdentityErrorKind::MissingBody(inner) => Error::MissingBody(inner),
                crate::error::CreateCloudFrontOriginAccessIdentityErrorKind::TooManyCloudFrontOriginAccessIdentities(inner) => Error::TooManyCloudFrontOriginAccessIdentities(inner),
                crate::error::CreateCloudFrontOriginAccessIdentityErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CreateDistributionError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::CreateDistributionError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::CreateDistributionErrorKind::AccessDenied(inner) => Error::AccessDenied(inner),
                crate::error::CreateDistributionErrorKind::CnameAlreadyExists(inner) => Error::CnameAlreadyExists(inner),
                crate::error::CreateDistributionErrorKind::DistributionAlreadyExists(inner) => Error::DistributionAlreadyExists(inner),
                crate::error::CreateDistributionErrorKind::IllegalFieldLevelEncryptionConfigAssociationWithCacheBehavior(inner) => Error::IllegalFieldLevelEncryptionConfigAssociationWithCacheBehavior(inner),
                crate::error::CreateDistributionErrorKind::InconsistentQuantities(inner) => Error::InconsistentQuantities(inner),
                crate::error::CreateDistributionErrorKind::InvalidArgument(inner) => Error::InvalidArgument(inner),
                crate::error::CreateDistributionErrorKind::InvalidDefaultRootObject(inner) => Error::InvalidDefaultRootObject(inner),
                crate::error::CreateDistributionErrorKind::InvalidErrorCode(inner) => Error::InvalidErrorCode(inner),
                crate::error::CreateDistributionErrorKind::InvalidForwardCookies(inner) => Error::InvalidForwardCookies(inner),
                crate::error::CreateDistributionErrorKind::InvalidFunctionAssociation(inner) => Error::InvalidFunctionAssociation(inner),
                crate::error::CreateDistributionErrorKind::InvalidGeoRestrictionParameter(inner) => Error::InvalidGeoRestrictionParameter(inner),
                crate::error::CreateDistributionErrorKind::InvalidHeadersForS3Origin(inner) => Error::InvalidHeadersForS3Origin(inner),
                crate::error::CreateDistributionErrorKind::InvalidLambdaFunctionAssociation(inner) => Error::InvalidLambdaFunctionAssociation(inner),
                crate::error::CreateDistributionErrorKind::InvalidLocationCode(inner) => Error::InvalidLocationCode(inner),
                crate::error::CreateDistributionErrorKind::InvalidMinimumProtocolVersion(inner) => Error::InvalidMinimumProtocolVersion(inner),
                crate::error::CreateDistributionErrorKind::InvalidOrigin(inner) => Error::InvalidOrigin(inner),
                crate::error::CreateDistributionErrorKind::InvalidOriginAccessIdentity(inner) => Error::InvalidOriginAccessIdentity(inner),
                crate::error::CreateDistributionErrorKind::InvalidOriginKeepaliveTimeout(inner) => Error::InvalidOriginKeepaliveTimeout(inner),
                crate::error::CreateDistributionErrorKind::InvalidOriginReadTimeout(inner) => Error::InvalidOriginReadTimeout(inner),
                crate::error::CreateDistributionErrorKind::InvalidProtocolSettings(inner) => Error::InvalidProtocolSettings(inner),
                crate::error::CreateDistributionErrorKind::InvalidQueryStringParameters(inner) => Error::InvalidQueryStringParameters(inner),
                crate::error::CreateDistributionErrorKind::InvalidRelativePath(inner) => Error::InvalidRelativePath(inner),
                crate::error::CreateDistributionErrorKind::InvalidRequiredProtocol(inner) => Error::InvalidRequiredProtocol(inner),
                crate::error::CreateDistributionErrorKind::InvalidResponseCode(inner) => Error::InvalidResponseCode(inner),
                crate::error::CreateDistributionErrorKind::InvalidTtlOrder(inner) => Error::InvalidTtlOrder(inner),
                crate::error::CreateDistributionErrorKind::InvalidViewerCertificate(inner) => Error::InvalidViewerCertificate(inner),
                crate::error::CreateDistributionErrorKind::InvalidWebAclId(inner) => Error::InvalidWebAclId(inner),
                crate::error::CreateDistributionErrorKind::MissingBody(inner) => Error::MissingBody(inner),
                crate::error::CreateDistributionErrorKind::NoSuchCachePolicy(inner) => Error::NoSuchCachePolicy(inner),
                crate::error::CreateDistributionErrorKind::NoSuchFieldLevelEncryptionConfig(inner) => Error::NoSuchFieldLevelEncryptionConfig(inner),
                crate::error::CreateDistributionErrorKind::NoSuchOrigin(inner) => Error::NoSuchOrigin(inner),
                crate::error::CreateDistributionErrorKind::NoSuchOriginRequestPolicy(inner) => Error::NoSuchOriginRequestPolicy(inner),
                crate::error::CreateDistributionErrorKind::NoSuchRealtimeLogConfig(inner) => Error::NoSuchRealtimeLogConfig(inner),
                crate::error::CreateDistributionErrorKind::NoSuchResponseHeadersPolicy(inner) => Error::NoSuchResponseHeadersPolicy(inner),
                crate::error::CreateDistributionErrorKind::RealtimeLogConfigOwnerMismatch(inner) => Error::RealtimeLogConfigOwnerMismatch(inner),
                crate::error::CreateDistributionErrorKind::TooManyCacheBehaviors(inner) => Error::TooManyCacheBehaviors(inner),
                crate::error::CreateDistributionErrorKind::TooManyCertificates(inner) => Error::TooManyCertificates(inner),
                crate::error::CreateDistributionErrorKind::TooManyCookieNamesInWhiteList(inner) => Error::TooManyCookieNamesInWhiteList(inner),
                crate::error::CreateDistributionErrorKind::TooManyDistributionCnamEs(inner) => Error::TooManyDistributionCnamEs(inner),
                crate::error::CreateDistributionErrorKind::TooManyDistributions(inner) => Error::TooManyDistributions(inner),
                crate::error::CreateDistributionErrorKind::TooManyDistributionsAssociatedToCachePolicy(inner) => Error::TooManyDistributionsAssociatedToCachePolicy(inner),
                crate::error::CreateDistributionErrorKind::TooManyDistributionsAssociatedToFieldLevelEncryptionConfig(inner) => Error::TooManyDistributionsAssociatedToFieldLevelEncryptionConfig(inner),
                crate::error::CreateDistributionErrorKind::TooManyDistributionsAssociatedToKeyGroup(inner) => Error::TooManyDistributionsAssociatedToKeyGroup(inner),
                crate::error::CreateDistributionErrorKind::TooManyDistributionsAssociatedToOriginRequestPolicy(inner) => Error::TooManyDistributionsAssociatedToOriginRequestPolicy(inner),
                crate::error::CreateDistributionErrorKind::TooManyDistributionsAssociatedToResponseHeadersPolicy(inner) => Error::TooManyDistributionsAssociatedToResponseHeadersPolicy(inner),
                crate::error::CreateDistributionErrorKind::TooManyDistributionsWithFunctionAssociations(inner) => Error::TooManyDistributionsWithFunctionAssociations(inner),
                crate::error::CreateDistributionErrorKind::TooManyDistributionsWithLambdaAssociations(inner) => Error::TooManyDistributionsWithLambdaAssociations(inner),
                crate::error::CreateDistributionErrorKind::TooManyDistributionsWithSingleFunctionArn(inner) => Error::TooManyDistributionsWithSingleFunctionArn(inner),
                crate::error::CreateDistributionErrorKind::TooManyFunctionAssociations(inner) => Error::TooManyFunctionAssociations(inner),
                crate::error::CreateDistributionErrorKind::TooManyHeadersInForwardedValues(inner) => Error::TooManyHeadersInForwardedValues(inner),
                crate::error::CreateDistributionErrorKind::TooManyKeyGroupsAssociatedToDistribution(inner) => Error::TooManyKeyGroupsAssociatedToDistribution(inner),
                crate::error::CreateDistributionErrorKind::TooManyLambdaFunctionAssociations(inner) => Error::TooManyLambdaFunctionAssociations(inner),
                crate::error::CreateDistributionErrorKind::TooManyOriginCustomHeaders(inner) => Error::TooManyOriginCustomHeaders(inner),
                crate::error::CreateDistributionErrorKind::TooManyOriginGroupsPerDistribution(inner) => Error::TooManyOriginGroupsPerDistribution(inner),
                crate::error::CreateDistributionErrorKind::TooManyOrigins(inner) => Error::TooManyOrigins(inner),
                crate::error::CreateDistributionErrorKind::TooManyQueryStringParameters(inner) => Error::TooManyQueryStringParameters(inner),
                crate::error::CreateDistributionErrorKind::TooManyTrustedSigners(inner) => Error::TooManyTrustedSigners(inner),
                crate::error::CreateDistributionErrorKind::TrustedKeyGroupDoesNotExist(inner) => Error::TrustedKeyGroupDoesNotExist(inner),
                crate::error::CreateDistributionErrorKind::TrustedSignerDoesNotExist(inner) => Error::TrustedSignerDoesNotExist(inner),
                crate::error::CreateDistributionErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CreateDistributionWithTagsError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::CreateDistributionWithTagsError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::CreateDistributionWithTagsErrorKind::AccessDenied(inner) => Error::AccessDenied(inner),
                crate::error::CreateDistributionWithTagsErrorKind::CnameAlreadyExists(inner) => Error::CnameAlreadyExists(inner),
                crate::error::CreateDistributionWithTagsErrorKind::DistributionAlreadyExists(inner) => Error::DistributionAlreadyExists(inner),
                crate::error::CreateDistributionWithTagsErrorKind::IllegalFieldLevelEncryptionConfigAssociationWithCacheBehavior(inner) => Error::IllegalFieldLevelEncryptionConfigAssociationWithCacheBehavior(inner),
                crate::error::CreateDistributionWithTagsErrorKind::InconsistentQuantities(inner) => Error::InconsistentQuantities(inner),
                crate::error::CreateDistributionWithTagsErrorKind::InvalidArgument(inner) => Error::InvalidArgument(inner),
                crate::error::CreateDistributionWithTagsErrorKind::InvalidDefaultRootObject(inner) => Error::InvalidDefaultRootObject(inner),
                crate::error::CreateDistributionWithTagsErrorKind::InvalidErrorCode(inner) => Error::InvalidErrorCode(inner),
                crate::error::CreateDistributionWithTagsErrorKind::InvalidForwardCookies(inner) => Error::InvalidForwardCookies(inner),
                crate::error::CreateDistributionWithTagsErrorKind::InvalidFunctionAssociation(inner) => Error::InvalidFunctionAssociation(inner),
                crate::error::CreateDistributionWithTagsErrorKind::InvalidGeoRestrictionParameter(inner) => Error::InvalidGeoRestrictionParameter(inner),
                crate::error::CreateDistributionWithTagsErrorKind::InvalidHeadersForS3Origin(inner) => Error::InvalidHeadersForS3Origin(inner),
                crate::error::CreateDistributionWithTagsErrorKind::InvalidLambdaFunctionAssociation(inner) => Error::InvalidLambdaFunctionAssociation(inner),
                crate::error::CreateDistributionWithTagsErrorKind::InvalidLocationCode(inner) => Error::InvalidLocationCode(inner),
                crate::error::CreateDistributionWithTagsErrorKind::InvalidMinimumProtocolVersion(inner) => Error::InvalidMinimumProtocolVersion(inner),
                crate::error::CreateDistributionWithTagsErrorKind::InvalidOrigin(inner) => Error::InvalidOrigin(inner),
                crate::error::CreateDistributionWithTagsErrorKind::InvalidOriginAccessIdentity(inner) => Error::InvalidOriginAccessIdentity(inner),
                crate::error::CreateDistributionWithTagsErrorKind::InvalidOriginKeepaliveTimeout(inner) => Error::InvalidOriginKeepaliveTimeout(inner),
                crate::error::CreateDistributionWithTagsErrorKind::InvalidOriginReadTimeout(inner) => Error::InvalidOriginReadTimeout(inner),
                crate::error::CreateDistributionWithTagsErrorKind::InvalidProtocolSettings(inner) => Error::InvalidProtocolSettings(inner),
                crate::error::CreateDistributionWithTagsErrorKind::InvalidQueryStringParameters(inner) => Error::InvalidQueryStringParameters(inner),
                crate::error::CreateDistributionWithTagsErrorKind::InvalidRelativePath(inner) => Error::InvalidRelativePath(inner),
                crate::error::CreateDistributionWithTagsErrorKind::InvalidRequiredProtocol(inner) => Error::InvalidRequiredProtocol(inner),
                crate::error::CreateDistributionWithTagsErrorKind::InvalidResponseCode(inner) => Error::InvalidResponseCode(inner),
                crate::error::CreateDistributionWithTagsErrorKind::InvalidTagging(inner) => Error::InvalidTagging(inner),
                crate::error::CreateDistributionWithTagsErrorKind::InvalidTtlOrder(inner) => Error::InvalidTtlOrder(inner),
                crate::error::CreateDistributionWithTagsErrorKind::InvalidViewerCertificate(inner) => Error::InvalidViewerCertificate(inner),
                crate::error::CreateDistributionWithTagsErrorKind::InvalidWebAclId(inner) => Error::InvalidWebAclId(inner),
                crate::error::CreateDistributionWithTagsErrorKind::MissingBody(inner) => Error::MissingBody(inner),
                crate::error::CreateDistributionWithTagsErrorKind::NoSuchCachePolicy(inner) => Error::NoSuchCachePolicy(inner),
                crate::error::CreateDistributionWithTagsErrorKind::NoSuchFieldLevelEncryptionConfig(inner) => Error::NoSuchFieldLevelEncryptionConfig(inner),
                crate::error::CreateDistributionWithTagsErrorKind::NoSuchOrigin(inner) => Error::NoSuchOrigin(inner),
                crate::error::CreateDistributionWithTagsErrorKind::NoSuchOriginRequestPolicy(inner) => Error::NoSuchOriginRequestPolicy(inner),
                crate::error::CreateDistributionWithTagsErrorKind::NoSuchRealtimeLogConfig(inner) => Error::NoSuchRealtimeLogConfig(inner),
                crate::error::CreateDistributionWithTagsErrorKind::NoSuchResponseHeadersPolicy(inner) => Error::NoSuchResponseHeadersPolicy(inner),
                crate::error::CreateDistributionWithTagsErrorKind::RealtimeLogConfigOwnerMismatch(inner) => Error::RealtimeLogConfigOwnerMismatch(inner),
                crate::error::CreateDistributionWithTagsErrorKind::TooManyCacheBehaviors(inner) => Error::TooManyCacheBehaviors(inner),
                crate::error::CreateDistributionWithTagsErrorKind::TooManyCertificates(inner) => Error::TooManyCertificates(inner),
                crate::error::CreateDistributionWithTagsErrorKind::TooManyCookieNamesInWhiteList(inner) => Error::TooManyCookieNamesInWhiteList(inner),
                crate::error::CreateDistributionWithTagsErrorKind::TooManyDistributionCnamEs(inner) => Error::TooManyDistributionCnamEs(inner),
                crate::error::CreateDistributionWithTagsErrorKind::TooManyDistributions(inner) => Error::TooManyDistributions(inner),
                crate::error::CreateDistributionWithTagsErrorKind::TooManyDistributionsAssociatedToCachePolicy(inner) => Error::TooManyDistributionsAssociatedToCachePolicy(inner),
                crate::error::CreateDistributionWithTagsErrorKind::TooManyDistributionsAssociatedToFieldLevelEncryptionConfig(inner) => Error::TooManyDistributionsAssociatedToFieldLevelEncryptionConfig(inner),
                crate::error::CreateDistributionWithTagsErrorKind::TooManyDistributionsAssociatedToKeyGroup(inner) => Error::TooManyDistributionsAssociatedToKeyGroup(inner),
                crate::error::CreateDistributionWithTagsErrorKind::TooManyDistributionsAssociatedToOriginRequestPolicy(inner) => Error::TooManyDistributionsAssociatedToOriginRequestPolicy(inner),
                crate::error::CreateDistributionWithTagsErrorKind::TooManyDistributionsAssociatedToResponseHeadersPolicy(inner) => Error::TooManyDistributionsAssociatedToResponseHeadersPolicy(inner),
                crate::error::CreateDistributionWithTagsErrorKind::TooManyDistributionsWithFunctionAssociations(inner) => Error::TooManyDistributionsWithFunctionAssociations(inner),
                crate::error::CreateDistributionWithTagsErrorKind::TooManyDistributionsWithLambdaAssociations(inner) => Error::TooManyDistributionsWithLambdaAssociations(inner),
                crate::error::CreateDistributionWithTagsErrorKind::TooManyDistributionsWithSingleFunctionArn(inner) => Error::TooManyDistributionsWithSingleFunctionArn(inner),
                crate::error::CreateDistributionWithTagsErrorKind::TooManyFunctionAssociations(inner) => Error::TooManyFunctionAssociations(inner),
                crate::error::CreateDistributionWithTagsErrorKind::TooManyHeadersInForwardedValues(inner) => Error::TooManyHeadersInForwardedValues(inner),
                crate::error::CreateDistributionWithTagsErrorKind::TooManyKeyGroupsAssociatedToDistribution(inner) => Error::TooManyKeyGroupsAssociatedToDistribution(inner),
                crate::error::CreateDistributionWithTagsErrorKind::TooManyLambdaFunctionAssociations(inner) => Error::TooManyLambdaFunctionAssociations(inner),
                crate::error::CreateDistributionWithTagsErrorKind::TooManyOriginCustomHeaders(inner) => Error::TooManyOriginCustomHeaders(inner),
                crate::error::CreateDistributionWithTagsErrorKind::TooManyOriginGroupsPerDistribution(inner) => Error::TooManyOriginGroupsPerDistribution(inner),
                crate::error::CreateDistributionWithTagsErrorKind::TooManyOrigins(inner) => Error::TooManyOrigins(inner),
                crate::error::CreateDistributionWithTagsErrorKind::TooManyQueryStringParameters(inner) => Error::TooManyQueryStringParameters(inner),
                crate::error::CreateDistributionWithTagsErrorKind::TooManyTrustedSigners(inner) => Error::TooManyTrustedSigners(inner),
                crate::error::CreateDistributionWithTagsErrorKind::TrustedKeyGroupDoesNotExist(inner) => Error::TrustedKeyGroupDoesNotExist(inner),
                crate::error::CreateDistributionWithTagsErrorKind::TrustedSignerDoesNotExist(inner) => Error::TrustedSignerDoesNotExist(inner),
                crate::error::CreateDistributionWithTagsErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<aws_smithy_http::result::SdkError<crate::error::CreateFieldLevelEncryptionConfigError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::CreateFieldLevelEncryptionConfigError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::CreateFieldLevelEncryptionConfigErrorKind::FieldLevelEncryptionConfigAlreadyExists(inner) => Error::FieldLevelEncryptionConfigAlreadyExists(inner),
                crate::error::CreateFieldLevelEncryptionConfigErrorKind::InconsistentQuantities(inner) => Error::InconsistentQuantities(inner),
                crate::error::CreateFieldLevelEncryptionConfigErrorKind::InvalidArgument(inner) => Error::InvalidArgument(inner),
                crate::error::CreateFieldLevelEncryptionConfigErrorKind::NoSuchFieldLevelEncryptionProfile(inner) => Error::NoSuchFieldLevelEncryptionProfile(inner),
                crate::error::CreateFieldLevelEncryptionConfigErrorKind::QueryArgProfileEmpty(inner) => Error::QueryArgProfileEmpty(inner),
                crate::error::CreateFieldLevelEncryptionConfigErrorKind::TooManyFieldLevelEncryptionConfigs(inner) => Error::TooManyFieldLevelEncryptionConfigs(inner),
                crate::error::CreateFieldLevelEncryptionConfigErrorKind::TooManyFieldLevelEncryptionContentTypeProfiles(inner) => Error::TooManyFieldLevelEncryptionContentTypeProfiles(inner),
                crate::error::CreateFieldLevelEncryptionConfigErrorKind::TooManyFieldLevelEncryptionQueryArgProfiles(inner) => Error::TooManyFieldLevelEncryptionQueryArgProfiles(inner),
                crate::error::CreateFieldLevelEncryptionConfigErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<aws_smithy_http::result::SdkError<crate::error::CreateFieldLevelEncryptionProfileError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::CreateFieldLevelEncryptionProfileError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::CreateFieldLevelEncryptionProfileErrorKind::FieldLevelEncryptionProfileAlreadyExists(inner) => Error::FieldLevelEncryptionProfileAlreadyExists(inner),
                crate::error::CreateFieldLevelEncryptionProfileErrorKind::FieldLevelEncryptionProfileSizeExceeded(inner) => Error::FieldLevelEncryptionProfileSizeExceeded(inner),
                crate::error::CreateFieldLevelEncryptionProfileErrorKind::InconsistentQuantities(inner) => Error::InconsistentQuantities(inner),
                crate::error::CreateFieldLevelEncryptionProfileErrorKind::InvalidArgument(inner) => Error::InvalidArgument(inner),
                crate::error::CreateFieldLevelEncryptionProfileErrorKind::NoSuchPublicKey(inner) => Error::NoSuchPublicKey(inner),
                crate::error::CreateFieldLevelEncryptionProfileErrorKind::TooManyFieldLevelEncryptionEncryptionEntities(inner) => Error::TooManyFieldLevelEncryptionEncryptionEntities(inner),
                crate::error::CreateFieldLevelEncryptionProfileErrorKind::TooManyFieldLevelEncryptionFieldPatterns(inner) => Error::TooManyFieldLevelEncryptionFieldPatterns(inner),
                crate::error::CreateFieldLevelEncryptionProfileErrorKind::TooManyFieldLevelEncryptionProfiles(inner) => Error::TooManyFieldLevelEncryptionProfiles(inner),
                crate::error::CreateFieldLevelEncryptionProfileErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CreateFunctionError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::CreateFunctionError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::CreateFunctionErrorKind::FunctionAlreadyExists(inner) => {
                    Error::FunctionAlreadyExists(inner)
                }
                crate::error::CreateFunctionErrorKind::FunctionSizeLimitExceeded(inner) => {
                    Error::FunctionSizeLimitExceeded(inner)
                }
                crate::error::CreateFunctionErrorKind::InvalidArgument(inner) => {
                    Error::InvalidArgument(inner)
                }
                crate::error::CreateFunctionErrorKind::TooManyFunctions(inner) => {
                    Error::TooManyFunctions(inner)
                }
                crate::error::CreateFunctionErrorKind::UnsupportedOperation(inner) => {
                    Error::UnsupportedOperation(inner)
                }
                crate::error::CreateFunctionErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CreateInvalidationError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::CreateInvalidationError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::CreateInvalidationErrorKind::AccessDenied(inner) => {
                    Error::AccessDenied(inner)
                }
                crate::error::CreateInvalidationErrorKind::BatchTooLarge(inner) => {
                    Error::BatchTooLarge(inner)
                }
                crate::error::CreateInvalidationErrorKind::InconsistentQuantities(inner) => {
                    Error::InconsistentQuantities(inner)
                }
                crate::error::CreateInvalidationErrorKind::InvalidArgument(inner) => {
                    Error::InvalidArgument(inner)
                }
                crate::error::CreateInvalidationErrorKind::MissingBody(inner) => {
                    Error::MissingBody(inner)
                }
                crate::error::CreateInvalidationErrorKind::NoSuchDistribution(inner) => {
                    Error::NoSuchDistribution(inner)
                }
                crate::error::CreateInvalidationErrorKind::TooManyInvalidationsInProgress(
                    inner,
                ) => Error::TooManyInvalidationsInProgress(inner),
                crate::error::CreateInvalidationErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CreateKeyGroupError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::CreateKeyGroupError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::CreateKeyGroupErrorKind::InvalidArgument(inner) => {
                    Error::InvalidArgument(inner)
                }
                crate::error::CreateKeyGroupErrorKind::KeyGroupAlreadyExists(inner) => {
                    Error::KeyGroupAlreadyExists(inner)
                }
                crate::error::CreateKeyGroupErrorKind::TooManyKeyGroups(inner) => {
                    Error::TooManyKeyGroups(inner)
                }
                crate::error::CreateKeyGroupErrorKind::TooManyPublicKeysInKeyGroup(inner) => {
                    Error::TooManyPublicKeysInKeyGroup(inner)
                }
                crate::error::CreateKeyGroupErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CreateMonitoringSubscriptionError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::CreateMonitoringSubscriptionError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::CreateMonitoringSubscriptionErrorKind::AccessDenied(inner) => {
                    Error::AccessDenied(inner)
                }
                crate::error::CreateMonitoringSubscriptionErrorKind::NoSuchDistribution(inner) => {
                    Error::NoSuchDistribution(inner)
                }
                crate::error::CreateMonitoringSubscriptionErrorKind::UnsupportedOperation(
                    inner,
                ) => Error::UnsupportedOperation(inner),
                crate::error::CreateMonitoringSubscriptionErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CreateOriginRequestPolicyError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::CreateOriginRequestPolicyError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::CreateOriginRequestPolicyErrorKind::AccessDenied(inner) => Error::AccessDenied(inner),
                crate::error::CreateOriginRequestPolicyErrorKind::InconsistentQuantities(inner) => Error::InconsistentQuantities(inner),
                crate::error::CreateOriginRequestPolicyErrorKind::InvalidArgument(inner) => Error::InvalidArgument(inner),
                crate::error::CreateOriginRequestPolicyErrorKind::OriginRequestPolicyAlreadyExists(inner) => Error::OriginRequestPolicyAlreadyExists(inner),
                crate::error::CreateOriginRequestPolicyErrorKind::TooManyCookiesInOriginRequestPolicy(inner) => Error::TooManyCookiesInOriginRequestPolicy(inner),
                crate::error::CreateOriginRequestPolicyErrorKind::TooManyHeadersInOriginRequestPolicy(inner) => Error::TooManyHeadersInOriginRequestPolicy(inner),
                crate::error::CreateOriginRequestPolicyErrorKind::TooManyOriginRequestPolicies(inner) => Error::TooManyOriginRequestPolicies(inner),
                crate::error::CreateOriginRequestPolicyErrorKind::TooManyQueryStringsInOriginRequestPolicy(inner) => Error::TooManyQueryStringsInOriginRequestPolicy(inner),
                crate::error::CreateOriginRequestPolicyErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CreatePublicKeyError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::CreatePublicKeyError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::CreatePublicKeyErrorKind::InvalidArgument(inner) => {
                    Error::InvalidArgument(inner)
                }
                crate::error::CreatePublicKeyErrorKind::PublicKeyAlreadyExists(inner) => {
                    Error::PublicKeyAlreadyExists(inner)
                }
                crate::error::CreatePublicKeyErrorKind::TooManyPublicKeys(inner) => {
                    Error::TooManyPublicKeys(inner)
                }
                crate::error::CreatePublicKeyErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CreateRealtimeLogConfigError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::CreateRealtimeLogConfigError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::CreateRealtimeLogConfigErrorKind::AccessDenied(inner) => {
                    Error::AccessDenied(inner)
                }
                crate::error::CreateRealtimeLogConfigErrorKind::InvalidArgument(inner) => {
                    Error::InvalidArgument(inner)
                }
                crate::error::CreateRealtimeLogConfigErrorKind::RealtimeLogConfigAlreadyExists(
                    inner,
                ) => Error::RealtimeLogConfigAlreadyExists(inner),
                crate::error::CreateRealtimeLogConfigErrorKind::TooManyRealtimeLogConfigs(
                    inner,
                ) => Error::TooManyRealtimeLogConfigs(inner),
                crate::error::CreateRealtimeLogConfigErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CreateResponseHeadersPolicyError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::CreateResponseHeadersPolicyError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::CreateResponseHeadersPolicyErrorKind::AccessDenied(inner) => Error::AccessDenied(inner),
                crate::error::CreateResponseHeadersPolicyErrorKind::InconsistentQuantities(inner) => Error::InconsistentQuantities(inner),
                crate::error::CreateResponseHeadersPolicyErrorKind::InvalidArgument(inner) => Error::InvalidArgument(inner),
                crate::error::CreateResponseHeadersPolicyErrorKind::ResponseHeadersPolicyAlreadyExists(inner) => Error::ResponseHeadersPolicyAlreadyExists(inner),
                crate::error::CreateResponseHeadersPolicyErrorKind::TooManyCustomHeadersInResponseHeadersPolicy(inner) => Error::TooManyCustomHeadersInResponseHeadersPolicy(inner),
                crate::error::CreateResponseHeadersPolicyErrorKind::TooManyResponseHeadersPolicies(inner) => Error::TooManyResponseHeadersPolicies(inner),
                crate::error::CreateResponseHeadersPolicyErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CreateStreamingDistributionError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::CreateStreamingDistributionError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::CreateStreamingDistributionErrorKind::AccessDenied(inner) => Error::AccessDenied(inner),
                crate::error::CreateStreamingDistributionErrorKind::CnameAlreadyExists(inner) => Error::CnameAlreadyExists(inner),
                crate::error::CreateStreamingDistributionErrorKind::InconsistentQuantities(inner) => Error::InconsistentQuantities(inner),
                crate::error::CreateStreamingDistributionErrorKind::InvalidArgument(inner) => Error::InvalidArgument(inner),
                crate::error::CreateStreamingDistributionErrorKind::InvalidOrigin(inner) => Error::InvalidOrigin(inner),
                crate::error::CreateStreamingDistributionErrorKind::InvalidOriginAccessIdentity(inner) => Error::InvalidOriginAccessIdentity(inner),
                crate::error::CreateStreamingDistributionErrorKind::MissingBody(inner) => Error::MissingBody(inner),
                crate::error::CreateStreamingDistributionErrorKind::StreamingDistributionAlreadyExists(inner) => Error::StreamingDistributionAlreadyExists(inner),
                crate::error::CreateStreamingDistributionErrorKind::TooManyStreamingDistributionCnamEs(inner) => Error::TooManyStreamingDistributionCnamEs(inner),
                crate::error::CreateStreamingDistributionErrorKind::TooManyStreamingDistributions(inner) => Error::TooManyStreamingDistributions(inner),
                crate::error::CreateStreamingDistributionErrorKind::TooManyTrustedSigners(inner) => Error::TooManyTrustedSigners(inner),
                crate::error::CreateStreamingDistributionErrorKind::TrustedSignerDoesNotExist(inner) => Error::TrustedSignerDoesNotExist(inner),
                crate::error::CreateStreamingDistributionErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<
        aws_smithy_http::result::SdkError<
            crate::error::CreateStreamingDistributionWithTagsError,
            R,
        >,
    > for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::CreateStreamingDistributionWithTagsError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::CreateStreamingDistributionWithTagsErrorKind::AccessDenied(inner) => Error::AccessDenied(inner),
                crate::error::CreateStreamingDistributionWithTagsErrorKind::CnameAlreadyExists(inner) => Error::CnameAlreadyExists(inner),
                crate::error::CreateStreamingDistributionWithTagsErrorKind::InconsistentQuantities(inner) => Error::InconsistentQuantities(inner),
                crate::error::CreateStreamingDistributionWithTagsErrorKind::InvalidArgument(inner) => Error::InvalidArgument(inner),
                crate::error::CreateStreamingDistributionWithTagsErrorKind::InvalidOrigin(inner) => Error::InvalidOrigin(inner),
                crate::error::CreateStreamingDistributionWithTagsErrorKind::InvalidOriginAccessIdentity(inner) => Error::InvalidOriginAccessIdentity(inner),
                crate::error::CreateStreamingDistributionWithTagsErrorKind::InvalidTagging(inner) => Error::InvalidTagging(inner),
                crate::error::CreateStreamingDistributionWithTagsErrorKind::MissingBody(inner) => Error::MissingBody(inner),
                crate::error::CreateStreamingDistributionWithTagsErrorKind::StreamingDistributionAlreadyExists(inner) => Error::StreamingDistributionAlreadyExists(inner),
                crate::error::CreateStreamingDistributionWithTagsErrorKind::TooManyStreamingDistributionCnamEs(inner) => Error::TooManyStreamingDistributionCnamEs(inner),
                crate::error::CreateStreamingDistributionWithTagsErrorKind::TooManyStreamingDistributions(inner) => Error::TooManyStreamingDistributions(inner),
                crate::error::CreateStreamingDistributionWithTagsErrorKind::TooManyTrustedSigners(inner) => Error::TooManyTrustedSigners(inner),
                crate::error::CreateStreamingDistributionWithTagsErrorKind::TrustedSignerDoesNotExist(inner) => Error::TrustedSignerDoesNotExist(inner),
                crate::error::CreateStreamingDistributionWithTagsErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeleteCachePolicyError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DeleteCachePolicyError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DeleteCachePolicyErrorKind::AccessDenied(inner) => {
                    Error::AccessDenied(inner)
                }
                crate::error::DeleteCachePolicyErrorKind::CachePolicyInUse(inner) => {
                    Error::CachePolicyInUse(inner)
                }
                crate::error::DeleteCachePolicyErrorKind::IllegalDelete(inner) => {
                    Error::IllegalDelete(inner)
                }
                crate::error::DeleteCachePolicyErrorKind::InvalidIfMatchVersion(inner) => {
                    Error::InvalidIfMatchVersion(inner)
                }
                crate::error::DeleteCachePolicyErrorKind::NoSuchCachePolicy(inner) => {
                    Error::NoSuchCachePolicy(inner)
                }
                crate::error::DeleteCachePolicyErrorKind::PreconditionFailed(inner) => {
                    Error::PreconditionFailed(inner)
                }
                crate::error::DeleteCachePolicyErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<
        aws_smithy_http::result::SdkError<
            crate::error::DeleteCloudFrontOriginAccessIdentityError,
            R,
        >,
    > for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::DeleteCloudFrontOriginAccessIdentityError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::DeleteCloudFrontOriginAccessIdentityErrorKind::AccessDenied(inner) => Error::AccessDenied(inner),
                crate::error::DeleteCloudFrontOriginAccessIdentityErrorKind::CloudFrontOriginAccessIdentityInUse(inner) => Error::CloudFrontOriginAccessIdentityInUse(inner),
                crate::error::DeleteCloudFrontOriginAccessIdentityErrorKind::InvalidIfMatchVersion(inner) => Error::InvalidIfMatchVersion(inner),
                crate::error::DeleteCloudFrontOriginAccessIdentityErrorKind::NoSuchCloudFrontOriginAccessIdentity(inner) => Error::NoSuchCloudFrontOriginAccessIdentity(inner),
                crate::error::DeleteCloudFrontOriginAccessIdentityErrorKind::PreconditionFailed(inner) => Error::PreconditionFailed(inner),
                crate::error::DeleteCloudFrontOriginAccessIdentityErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeleteDistributionError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DeleteDistributionError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DeleteDistributionErrorKind::AccessDenied(inner) => {
                    Error::AccessDenied(inner)
                }
                crate::error::DeleteDistributionErrorKind::DistributionNotDisabled(inner) => {
                    Error::DistributionNotDisabled(inner)
                }
                crate::error::DeleteDistributionErrorKind::InvalidIfMatchVersion(inner) => {
                    Error::InvalidIfMatchVersion(inner)
                }
                crate::error::DeleteDistributionErrorKind::NoSuchDistribution(inner) => {
                    Error::NoSuchDistribution(inner)
                }
                crate::error::DeleteDistributionErrorKind::PreconditionFailed(inner) => {
                    Error::PreconditionFailed(inner)
                }
                crate::error::DeleteDistributionErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<aws_smithy_http::result::SdkError<crate::error::DeleteFieldLevelEncryptionConfigError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::DeleteFieldLevelEncryptionConfigError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::DeleteFieldLevelEncryptionConfigErrorKind::AccessDenied(inner) => Error::AccessDenied(inner),
                crate::error::DeleteFieldLevelEncryptionConfigErrorKind::FieldLevelEncryptionConfigInUse(inner) => Error::FieldLevelEncryptionConfigInUse(inner),
                crate::error::DeleteFieldLevelEncryptionConfigErrorKind::InvalidIfMatchVersion(inner) => Error::InvalidIfMatchVersion(inner),
                crate::error::DeleteFieldLevelEncryptionConfigErrorKind::NoSuchFieldLevelEncryptionConfig(inner) => Error::NoSuchFieldLevelEncryptionConfig(inner),
                crate::error::DeleteFieldLevelEncryptionConfigErrorKind::PreconditionFailed(inner) => Error::PreconditionFailed(inner),
                crate::error::DeleteFieldLevelEncryptionConfigErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<aws_smithy_http::result::SdkError<crate::error::DeleteFieldLevelEncryptionProfileError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::DeleteFieldLevelEncryptionProfileError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::DeleteFieldLevelEncryptionProfileErrorKind::AccessDenied(inner) => Error::AccessDenied(inner),
                crate::error::DeleteFieldLevelEncryptionProfileErrorKind::FieldLevelEncryptionProfileInUse(inner) => Error::FieldLevelEncryptionProfileInUse(inner),
                crate::error::DeleteFieldLevelEncryptionProfileErrorKind::InvalidIfMatchVersion(inner) => Error::InvalidIfMatchVersion(inner),
                crate::error::DeleteFieldLevelEncryptionProfileErrorKind::NoSuchFieldLevelEncryptionProfile(inner) => Error::NoSuchFieldLevelEncryptionProfile(inner),
                crate::error::DeleteFieldLevelEncryptionProfileErrorKind::PreconditionFailed(inner) => Error::PreconditionFailed(inner),
                crate::error::DeleteFieldLevelEncryptionProfileErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeleteFunctionError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::DeleteFunctionError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DeleteFunctionErrorKind::FunctionInUse(inner) => {
                    Error::FunctionInUse(inner)
                }
                crate::error::DeleteFunctionErrorKind::InvalidIfMatchVersion(inner) => {
                    Error::InvalidIfMatchVersion(inner)
                }
                crate::error::DeleteFunctionErrorKind::NoSuchFunctionExists(inner) => {
                    Error::NoSuchFunctionExists(inner)
                }
                crate::error::DeleteFunctionErrorKind::PreconditionFailed(inner) => {
                    Error::PreconditionFailed(inner)
                }
                crate::error::DeleteFunctionErrorKind::UnsupportedOperation(inner) => {
                    Error::UnsupportedOperation(inner)
                }
                crate::error::DeleteFunctionErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeleteKeyGroupError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::DeleteKeyGroupError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DeleteKeyGroupErrorKind::InvalidIfMatchVersion(inner) => {
                    Error::InvalidIfMatchVersion(inner)
                }
                crate::error::DeleteKeyGroupErrorKind::NoSuchResource(inner) => {
                    Error::NoSuchResource(inner)
                }
                crate::error::DeleteKeyGroupErrorKind::PreconditionFailed(inner) => {
                    Error::PreconditionFailed(inner)
                }
                crate::error::DeleteKeyGroupErrorKind::ResourceInUse(inner) => {
                    Error::ResourceInUse(inner)
                }
                crate::error::DeleteKeyGroupErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeleteMonitoringSubscriptionError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DeleteMonitoringSubscriptionError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DeleteMonitoringSubscriptionErrorKind::AccessDenied(inner) => {
                    Error::AccessDenied(inner)
                }
                crate::error::DeleteMonitoringSubscriptionErrorKind::NoSuchDistribution(inner) => {
                    Error::NoSuchDistribution(inner)
                }
                crate::error::DeleteMonitoringSubscriptionErrorKind::UnsupportedOperation(
                    inner,
                ) => Error::UnsupportedOperation(inner),
                crate::error::DeleteMonitoringSubscriptionErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeleteOriginRequestPolicyError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DeleteOriginRequestPolicyError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DeleteOriginRequestPolicyErrorKind::AccessDenied(inner) => {
                    Error::AccessDenied(inner)
                }
                crate::error::DeleteOriginRequestPolicyErrorKind::IllegalDelete(inner) => {
                    Error::IllegalDelete(inner)
                }
                crate::error::DeleteOriginRequestPolicyErrorKind::InvalidIfMatchVersion(inner) => {
                    Error::InvalidIfMatchVersion(inner)
                }
                crate::error::DeleteOriginRequestPolicyErrorKind::NoSuchOriginRequestPolicy(
                    inner,
                ) => Error::NoSuchOriginRequestPolicy(inner),
                crate::error::DeleteOriginRequestPolicyErrorKind::OriginRequestPolicyInUse(
                    inner,
                ) => Error::OriginRequestPolicyInUse(inner),
                crate::error::DeleteOriginRequestPolicyErrorKind::PreconditionFailed(inner) => {
                    Error::PreconditionFailed(inner)
                }
                crate::error::DeleteOriginRequestPolicyErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeletePublicKeyError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::DeletePublicKeyError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DeletePublicKeyErrorKind::AccessDenied(inner) => {
                    Error::AccessDenied(inner)
                }
                crate::error::DeletePublicKeyErrorKind::InvalidIfMatchVersion(inner) => {
                    Error::InvalidIfMatchVersion(inner)
                }
                crate::error::DeletePublicKeyErrorKind::NoSuchPublicKey(inner) => {
                    Error::NoSuchPublicKey(inner)
                }
                crate::error::DeletePublicKeyErrorKind::PreconditionFailed(inner) => {
                    Error::PreconditionFailed(inner)
                }
                crate::error::DeletePublicKeyErrorKind::PublicKeyInUse(inner) => {
                    Error::PublicKeyInUse(inner)
                }
                crate::error::DeletePublicKeyErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeleteRealtimeLogConfigError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DeleteRealtimeLogConfigError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DeleteRealtimeLogConfigErrorKind::AccessDenied(inner) => {
                    Error::AccessDenied(inner)
                }
                crate::error::DeleteRealtimeLogConfigErrorKind::InvalidArgument(inner) => {
                    Error::InvalidArgument(inner)
                }
                crate::error::DeleteRealtimeLogConfigErrorKind::NoSuchRealtimeLogConfig(inner) => {
                    Error::NoSuchRealtimeLogConfig(inner)
                }
                crate::error::DeleteRealtimeLogConfigErrorKind::RealtimeLogConfigInUse(inner) => {
                    Error::RealtimeLogConfigInUse(inner)
                }
                crate::error::DeleteRealtimeLogConfigErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeleteResponseHeadersPolicyError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DeleteResponseHeadersPolicyError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DeleteResponseHeadersPolicyErrorKind::AccessDenied(inner) => {
                    Error::AccessDenied(inner)
                }
                crate::error::DeleteResponseHeadersPolicyErrorKind::IllegalDelete(inner) => {
                    Error::IllegalDelete(inner)
                }
                crate::error::DeleteResponseHeadersPolicyErrorKind::InvalidIfMatchVersion(
                    inner,
                ) => Error::InvalidIfMatchVersion(inner),
                crate::error::DeleteResponseHeadersPolicyErrorKind::NoSuchResponseHeadersPolicy(
                    inner,
                ) => Error::NoSuchResponseHeadersPolicy(inner),
                crate::error::DeleteResponseHeadersPolicyErrorKind::PreconditionFailed(inner) => {
                    Error::PreconditionFailed(inner)
                }
                crate::error::DeleteResponseHeadersPolicyErrorKind::ResponseHeadersPolicyInUse(
                    inner,
                ) => Error::ResponseHeadersPolicyInUse(inner),
                crate::error::DeleteResponseHeadersPolicyErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeleteStreamingDistributionError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DeleteStreamingDistributionError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::DeleteStreamingDistributionErrorKind::AccessDenied(inner) => Error::AccessDenied(inner),
                crate::error::DeleteStreamingDistributionErrorKind::InvalidIfMatchVersion(inner) => Error::InvalidIfMatchVersion(inner),
                crate::error::DeleteStreamingDistributionErrorKind::NoSuchStreamingDistribution(inner) => Error::NoSuchStreamingDistribution(inner),
                crate::error::DeleteStreamingDistributionErrorKind::PreconditionFailed(inner) => Error::PreconditionFailed(inner),
                crate::error::DeleteStreamingDistributionErrorKind::StreamingDistributionNotDisabled(inner) => Error::StreamingDistributionNotDisabled(inner),
                crate::error::DeleteStreamingDistributionErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeFunctionError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DescribeFunctionError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DescribeFunctionErrorKind::NoSuchFunctionExists(inner) => {
                    Error::NoSuchFunctionExists(inner)
                }
                crate::error::DescribeFunctionErrorKind::UnsupportedOperation(inner) => {
                    Error::UnsupportedOperation(inner)
                }
                crate::error::DescribeFunctionErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GetCachePolicyError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::GetCachePolicyError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::GetCachePolicyErrorKind::AccessDenied(inner) => {
                    Error::AccessDenied(inner)
                }
                crate::error::GetCachePolicyErrorKind::NoSuchCachePolicy(inner) => {
                    Error::NoSuchCachePolicy(inner)
                }
                crate::error::GetCachePolicyErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GetCachePolicyConfigError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::GetCachePolicyConfigError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::GetCachePolicyConfigErrorKind::AccessDenied(inner) => {
                    Error::AccessDenied(inner)
                }
                crate::error::GetCachePolicyConfigErrorKind::NoSuchCachePolicy(inner) => {
                    Error::NoSuchCachePolicy(inner)
                }
                crate::error::GetCachePolicyConfigErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<aws_smithy_http::result::SdkError<crate::error::GetCloudFrontOriginAccessIdentityError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::GetCloudFrontOriginAccessIdentityError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::GetCloudFrontOriginAccessIdentityErrorKind::AccessDenied(inner) => Error::AccessDenied(inner),
                crate::error::GetCloudFrontOriginAccessIdentityErrorKind::NoSuchCloudFrontOriginAccessIdentity(inner) => Error::NoSuchCloudFrontOriginAccessIdentity(inner),
                crate::error::GetCloudFrontOriginAccessIdentityErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<
        aws_smithy_http::result::SdkError<
            crate::error::GetCloudFrontOriginAccessIdentityConfigError,
            R,
        >,
    > for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::GetCloudFrontOriginAccessIdentityConfigError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::GetCloudFrontOriginAccessIdentityConfigErrorKind::AccessDenied(inner) => Error::AccessDenied(inner),
                crate::error::GetCloudFrontOriginAccessIdentityConfigErrorKind::NoSuchCloudFrontOriginAccessIdentity(inner) => Error::NoSuchCloudFrontOriginAccessIdentity(inner),
                crate::error::GetCloudFrontOriginAccessIdentityConfigErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GetDistributionError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::GetDistributionError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::GetDistributionErrorKind::AccessDenied(inner) => {
                    Error::AccessDenied(inner)
                }
                crate::error::GetDistributionErrorKind::NoSuchDistribution(inner) => {
                    Error::NoSuchDistribution(inner)
                }
                crate::error::GetDistributionErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GetDistributionConfigError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::GetDistributionConfigError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::GetDistributionConfigErrorKind::AccessDenied(inner) => {
                    Error::AccessDenied(inner)
                }
                crate::error::GetDistributionConfigErrorKind::NoSuchDistribution(inner) => {
                    Error::NoSuchDistribution(inner)
                }
                crate::error::GetDistributionConfigErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GetFieldLevelEncryptionError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::GetFieldLevelEncryptionError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::GetFieldLevelEncryptionErrorKind::AccessDenied(inner) => Error::AccessDenied(inner),
                crate::error::GetFieldLevelEncryptionErrorKind::NoSuchFieldLevelEncryptionConfig(inner) => Error::NoSuchFieldLevelEncryptionConfig(inner),
                crate::error::GetFieldLevelEncryptionErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GetFieldLevelEncryptionConfigError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::GetFieldLevelEncryptionConfigError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::GetFieldLevelEncryptionConfigErrorKind::AccessDenied(inner) => Error::AccessDenied(inner),
                crate::error::GetFieldLevelEncryptionConfigErrorKind::NoSuchFieldLevelEncryptionConfig(inner) => Error::NoSuchFieldLevelEncryptionConfig(inner),
                crate::error::GetFieldLevelEncryptionConfigErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<aws_smithy_http::result::SdkError<crate::error::GetFieldLevelEncryptionProfileError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::GetFieldLevelEncryptionProfileError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::GetFieldLevelEncryptionProfileErrorKind::AccessDenied(inner) => Error::AccessDenied(inner),
                crate::error::GetFieldLevelEncryptionProfileErrorKind::NoSuchFieldLevelEncryptionProfile(inner) => Error::NoSuchFieldLevelEncryptionProfile(inner),
                crate::error::GetFieldLevelEncryptionProfileErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<
        aws_smithy_http::result::SdkError<
            crate::error::GetFieldLevelEncryptionProfileConfigError,
            R,
        >,
    > for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::GetFieldLevelEncryptionProfileConfigError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::GetFieldLevelEncryptionProfileConfigErrorKind::AccessDenied(inner) => Error::AccessDenied(inner),
                crate::error::GetFieldLevelEncryptionProfileConfigErrorKind::NoSuchFieldLevelEncryptionProfile(inner) => Error::NoSuchFieldLevelEncryptionProfile(inner),
                crate::error::GetFieldLevelEncryptionProfileConfigErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GetFunctionError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::GetFunctionError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::GetFunctionErrorKind::NoSuchFunctionExists(inner) => {
                    Error::NoSuchFunctionExists(inner)
                }
                crate::error::GetFunctionErrorKind::UnsupportedOperation(inner) => {
                    Error::UnsupportedOperation(inner)
                }
                crate::error::GetFunctionErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GetInvalidationError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::GetInvalidationError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::GetInvalidationErrorKind::AccessDenied(inner) => {
                    Error::AccessDenied(inner)
                }
                crate::error::GetInvalidationErrorKind::NoSuchDistribution(inner) => {
                    Error::NoSuchDistribution(inner)
                }
                crate::error::GetInvalidationErrorKind::NoSuchInvalidation(inner) => {
                    Error::NoSuchInvalidation(inner)
                }
                crate::error::GetInvalidationErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GetKeyGroupError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::GetKeyGroupError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::GetKeyGroupErrorKind::NoSuchResource(inner) => {
                    Error::NoSuchResource(inner)
                }
                crate::error::GetKeyGroupErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GetKeyGroupConfigError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::GetKeyGroupConfigError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::GetKeyGroupConfigErrorKind::NoSuchResource(inner) => {
                    Error::NoSuchResource(inner)
                }
                crate::error::GetKeyGroupConfigErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GetMonitoringSubscriptionError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::GetMonitoringSubscriptionError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::GetMonitoringSubscriptionErrorKind::AccessDenied(inner) => {
                    Error::AccessDenied(inner)
                }
                crate::error::GetMonitoringSubscriptionErrorKind::NoSuchDistribution(inner) => {
                    Error::NoSuchDistribution(inner)
                }
                crate::error::GetMonitoringSubscriptionErrorKind::UnsupportedOperation(inner) => {
                    Error::UnsupportedOperation(inner)
                }
                crate::error::GetMonitoringSubscriptionErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GetOriginRequestPolicyError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::GetOriginRequestPolicyError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::GetOriginRequestPolicyErrorKind::AccessDenied(inner) => {
                    Error::AccessDenied(inner)
                }
                crate::error::GetOriginRequestPolicyErrorKind::NoSuchOriginRequestPolicy(inner) => {
                    Error::NoSuchOriginRequestPolicy(inner)
                }
                crate::error::GetOriginRequestPolicyErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GetOriginRequestPolicyConfigError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::GetOriginRequestPolicyConfigError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::GetOriginRequestPolicyConfigErrorKind::AccessDenied(inner) => {
                    Error::AccessDenied(inner)
                }
                crate::error::GetOriginRequestPolicyConfigErrorKind::NoSuchOriginRequestPolicy(
                    inner,
                ) => Error::NoSuchOriginRequestPolicy(inner),
                crate::error::GetOriginRequestPolicyConfigErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GetPublicKeyError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::GetPublicKeyError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::GetPublicKeyErrorKind::AccessDenied(inner) => {
                    Error::AccessDenied(inner)
                }
                crate::error::GetPublicKeyErrorKind::NoSuchPublicKey(inner) => {
                    Error::NoSuchPublicKey(inner)
                }
                crate::error::GetPublicKeyErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GetPublicKeyConfigError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::GetPublicKeyConfigError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::GetPublicKeyConfigErrorKind::AccessDenied(inner) => {
                    Error::AccessDenied(inner)
                }
                crate::error::GetPublicKeyConfigErrorKind::NoSuchPublicKey(inner) => {
                    Error::NoSuchPublicKey(inner)
                }
                crate::error::GetPublicKeyConfigErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GetRealtimeLogConfigError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::GetRealtimeLogConfigError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::GetRealtimeLogConfigErrorKind::AccessDenied(inner) => {
                    Error::AccessDenied(inner)
                }
                crate::error::GetRealtimeLogConfigErrorKind::InvalidArgument(inner) => {
                    Error::InvalidArgument(inner)
                }
                crate::error::GetRealtimeLogConfigErrorKind::NoSuchRealtimeLogConfig(inner) => {
                    Error::NoSuchRealtimeLogConfig(inner)
                }
                crate::error::GetRealtimeLogConfigErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GetResponseHeadersPolicyError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::GetResponseHeadersPolicyError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::GetResponseHeadersPolicyErrorKind::AccessDenied(inner) => {
                    Error::AccessDenied(inner)
                }
                crate::error::GetResponseHeadersPolicyErrorKind::NoSuchResponseHeadersPolicy(
                    inner,
                ) => Error::NoSuchResponseHeadersPolicy(inner),
                crate::error::GetResponseHeadersPolicyErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<aws_smithy_http::result::SdkError<crate::error::GetResponseHeadersPolicyConfigError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::GetResponseHeadersPolicyConfigError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::GetResponseHeadersPolicyConfigErrorKind::AccessDenied(inner) => Error::AccessDenied(inner),
                crate::error::GetResponseHeadersPolicyConfigErrorKind::NoSuchResponseHeadersPolicy(inner) => Error::NoSuchResponseHeadersPolicy(inner),
                crate::error::GetResponseHeadersPolicyConfigErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GetStreamingDistributionError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::GetStreamingDistributionError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::GetStreamingDistributionErrorKind::AccessDenied(inner) => {
                    Error::AccessDenied(inner)
                }
                crate::error::GetStreamingDistributionErrorKind::NoSuchStreamingDistribution(
                    inner,
                ) => Error::NoSuchStreamingDistribution(inner),
                crate::error::GetStreamingDistributionErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<aws_smithy_http::result::SdkError<crate::error::GetStreamingDistributionConfigError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::GetStreamingDistributionConfigError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::GetStreamingDistributionConfigErrorKind::AccessDenied(inner) => Error::AccessDenied(inner),
                crate::error::GetStreamingDistributionConfigErrorKind::NoSuchStreamingDistribution(inner) => Error::NoSuchStreamingDistribution(inner),
                crate::error::GetStreamingDistributionConfigErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ListCachePoliciesError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::ListCachePoliciesError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ListCachePoliciesErrorKind::AccessDenied(inner) => {
                    Error::AccessDenied(inner)
                }
                crate::error::ListCachePoliciesErrorKind::InvalidArgument(inner) => {
                    Error::InvalidArgument(inner)
                }
                crate::error::ListCachePoliciesErrorKind::NoSuchCachePolicy(inner) => {
                    Error::NoSuchCachePolicy(inner)
                }
                crate::error::ListCachePoliciesErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<
        aws_smithy_http::result::SdkError<
            crate::error::ListCloudFrontOriginAccessIdentitiesError,
            R,
        >,
    > for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::ListCloudFrontOriginAccessIdentitiesError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ListCloudFrontOriginAccessIdentitiesErrorKind::InvalidArgument(
                    inner,
                ) => Error::InvalidArgument(inner),
                crate::error::ListCloudFrontOriginAccessIdentitiesErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ListConflictingAliasesError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::ListConflictingAliasesError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ListConflictingAliasesErrorKind::InvalidArgument(inner) => {
                    Error::InvalidArgument(inner)
                }
                crate::error::ListConflictingAliasesErrorKind::NoSuchDistribution(inner) => {
                    Error::NoSuchDistribution(inner)
                }
                crate::error::ListConflictingAliasesErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ListDistributionsError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::ListDistributionsError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ListDistributionsErrorKind::InvalidArgument(inner) => {
                    Error::InvalidArgument(inner)
                }
                crate::error::ListDistributionsErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<aws_smithy_http::result::SdkError<crate::error::ListDistributionsByCachePolicyIdError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::ListDistributionsByCachePolicyIdError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ListDistributionsByCachePolicyIdErrorKind::AccessDenied(inner) => {
                    Error::AccessDenied(inner)
                }
                crate::error::ListDistributionsByCachePolicyIdErrorKind::InvalidArgument(inner) => {
                    Error::InvalidArgument(inner)
                }
                crate::error::ListDistributionsByCachePolicyIdErrorKind::NoSuchCachePolicy(
                    inner,
                ) => Error::NoSuchCachePolicy(inner),
                crate::error::ListDistributionsByCachePolicyIdErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ListDistributionsByKeyGroupError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::ListDistributionsByKeyGroupError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ListDistributionsByKeyGroupErrorKind::InvalidArgument(inner) => {
                    Error::InvalidArgument(inner)
                }
                crate::error::ListDistributionsByKeyGroupErrorKind::NoSuchResource(inner) => {
                    Error::NoSuchResource(inner)
                }
                crate::error::ListDistributionsByKeyGroupErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<
        aws_smithy_http::result::SdkError<
            crate::error::ListDistributionsByOriginRequestPolicyIdError,
            R,
        >,
    > for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::ListDistributionsByOriginRequestPolicyIdError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::ListDistributionsByOriginRequestPolicyIdErrorKind::AccessDenied(inner) => Error::AccessDenied(inner),
                crate::error::ListDistributionsByOriginRequestPolicyIdErrorKind::InvalidArgument(inner) => Error::InvalidArgument(inner),
                crate::error::ListDistributionsByOriginRequestPolicyIdErrorKind::NoSuchOriginRequestPolicy(inner) => Error::NoSuchOriginRequestPolicy(inner),
                crate::error::ListDistributionsByOriginRequestPolicyIdErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<
        aws_smithy_http::result::SdkError<
            crate::error::ListDistributionsByRealtimeLogConfigError,
            R,
        >,
    > for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::ListDistributionsByRealtimeLogConfigError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ListDistributionsByRealtimeLogConfigErrorKind::InvalidArgument(
                    inner,
                ) => Error::InvalidArgument(inner),
                crate::error::ListDistributionsByRealtimeLogConfigErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<
        aws_smithy_http::result::SdkError<
            crate::error::ListDistributionsByResponseHeadersPolicyIdError,
            R,
        >,
    > for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::ListDistributionsByResponseHeadersPolicyIdError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::ListDistributionsByResponseHeadersPolicyIdErrorKind::AccessDenied(inner) => Error::AccessDenied(inner),
                crate::error::ListDistributionsByResponseHeadersPolicyIdErrorKind::InvalidArgument(inner) => Error::InvalidArgument(inner),
                crate::error::ListDistributionsByResponseHeadersPolicyIdErrorKind::NoSuchResponseHeadersPolicy(inner) => Error::NoSuchResponseHeadersPolicy(inner),
                crate::error::ListDistributionsByResponseHeadersPolicyIdErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ListDistributionsByWebACLIdError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::ListDistributionsByWebACLIdError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ListDistributionsByWebACLIdErrorKind::InvalidArgument(inner) => {
                    Error::InvalidArgument(inner)
                }
                crate::error::ListDistributionsByWebACLIdErrorKind::InvalidWebAclId(inner) => {
                    Error::InvalidWebAclId(inner)
                }
                crate::error::ListDistributionsByWebACLIdErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<aws_smithy_http::result::SdkError<crate::error::ListFieldLevelEncryptionConfigsError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::ListFieldLevelEncryptionConfigsError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ListFieldLevelEncryptionConfigsErrorKind::InvalidArgument(inner) => {
                    Error::InvalidArgument(inner)
                }
                crate::error::ListFieldLevelEncryptionConfigsErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<aws_smithy_http::result::SdkError<crate::error::ListFieldLevelEncryptionProfilesError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::ListFieldLevelEncryptionProfilesError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ListFieldLevelEncryptionProfilesErrorKind::InvalidArgument(inner) => {
                    Error::InvalidArgument(inner)
                }
                crate::error::ListFieldLevelEncryptionProfilesErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ListFunctionsError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::ListFunctionsError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ListFunctionsErrorKind::InvalidArgument(inner) => {
                    Error::InvalidArgument(inner)
                }
                crate::error::ListFunctionsErrorKind::UnsupportedOperation(inner) => {
                    Error::UnsupportedOperation(inner)
                }
                crate::error::ListFunctionsErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ListInvalidationsError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::ListInvalidationsError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ListInvalidationsErrorKind::AccessDenied(inner) => {
                    Error::AccessDenied(inner)
                }
                crate::error::ListInvalidationsErrorKind::InvalidArgument(inner) => {
                    Error::InvalidArgument(inner)
                }
                crate::error::ListInvalidationsErrorKind::NoSuchDistribution(inner) => {
                    Error::NoSuchDistribution(inner)
                }
                crate::error::ListInvalidationsErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ListKeyGroupsError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::ListKeyGroupsError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ListKeyGroupsErrorKind::InvalidArgument(inner) => {
                    Error::InvalidArgument(inner)
                }
                crate::error::ListKeyGroupsErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ListOriginRequestPoliciesError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::ListOriginRequestPoliciesError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ListOriginRequestPoliciesErrorKind::AccessDenied(inner) => {
                    Error::AccessDenied(inner)
                }
                crate::error::ListOriginRequestPoliciesErrorKind::InvalidArgument(inner) => {
                    Error::InvalidArgument(inner)
                }
                crate::error::ListOriginRequestPoliciesErrorKind::NoSuchOriginRequestPolicy(
                    inner,
                ) => Error::NoSuchOriginRequestPolicy(inner),
                crate::error::ListOriginRequestPoliciesErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ListPublicKeysError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::ListPublicKeysError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ListPublicKeysErrorKind::InvalidArgument(inner) => {
                    Error::InvalidArgument(inner)
                }
                crate::error::ListPublicKeysErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ListRealtimeLogConfigsError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::ListRealtimeLogConfigsError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ListRealtimeLogConfigsErrorKind::AccessDenied(inner) => {
                    Error::AccessDenied(inner)
                }
                crate::error::ListRealtimeLogConfigsErrorKind::InvalidArgument(inner) => {
                    Error::InvalidArgument(inner)
                }
                crate::error::ListRealtimeLogConfigsErrorKind::NoSuchRealtimeLogConfig(inner) => {
                    Error::NoSuchRealtimeLogConfig(inner)
                }
                crate::error::ListRealtimeLogConfigsErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ListResponseHeadersPoliciesError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::ListResponseHeadersPoliciesError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ListResponseHeadersPoliciesErrorKind::AccessDenied(inner) => {
                    Error::AccessDenied(inner)
                }
                crate::error::ListResponseHeadersPoliciesErrorKind::InvalidArgument(inner) => {
                    Error::InvalidArgument(inner)
                }
                crate::error::ListResponseHeadersPoliciesErrorKind::NoSuchResponseHeadersPolicy(
                    inner,
                ) => Error::NoSuchResponseHeadersPolicy(inner),
                crate::error::ListResponseHeadersPoliciesErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ListStreamingDistributionsError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::ListStreamingDistributionsError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ListStreamingDistributionsErrorKind::InvalidArgument(inner) => {
                    Error::InvalidArgument(inner)
                }
                crate::error::ListStreamingDistributionsErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ListTagsForResourceError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::ListTagsForResourceError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ListTagsForResourceErrorKind::AccessDenied(inner) => {
                    Error::AccessDenied(inner)
                }
                crate::error::ListTagsForResourceErrorKind::InvalidArgument(inner) => {
                    Error::InvalidArgument(inner)
                }
                crate::error::ListTagsForResourceErrorKind::InvalidTagging(inner) => {
                    Error::InvalidTagging(inner)
                }
                crate::error::ListTagsForResourceErrorKind::NoSuchResource(inner) => {
                    Error::NoSuchResource(inner)
                }
                crate::error::ListTagsForResourceErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::PublishFunctionError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::PublishFunctionError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::PublishFunctionErrorKind::InvalidArgument(inner) => {
                    Error::InvalidArgument(inner)
                }
                crate::error::PublishFunctionErrorKind::InvalidIfMatchVersion(inner) => {
                    Error::InvalidIfMatchVersion(inner)
                }
                crate::error::PublishFunctionErrorKind::NoSuchFunctionExists(inner) => {
                    Error::NoSuchFunctionExists(inner)
                }
                crate::error::PublishFunctionErrorKind::PreconditionFailed(inner) => {
                    Error::PreconditionFailed(inner)
                }
                crate::error::PublishFunctionErrorKind::UnsupportedOperation(inner) => {
                    Error::UnsupportedOperation(inner)
                }
                crate::error::PublishFunctionErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::TagResourceError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::TagResourceError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::TagResourceErrorKind::AccessDenied(inner) => {
                    Error::AccessDenied(inner)
                }
                crate::error::TagResourceErrorKind::InvalidArgument(inner) => {
                    Error::InvalidArgument(inner)
                }
                crate::error::TagResourceErrorKind::InvalidTagging(inner) => {
                    Error::InvalidTagging(inner)
                }
                crate::error::TagResourceErrorKind::NoSuchResource(inner) => {
                    Error::NoSuchResource(inner)
                }
                crate::error::TagResourceErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::TestFunctionError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::TestFunctionError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::TestFunctionErrorKind::InvalidArgument(inner) => {
                    Error::InvalidArgument(inner)
                }
                crate::error::TestFunctionErrorKind::InvalidIfMatchVersion(inner) => {
                    Error::InvalidIfMatchVersion(inner)
                }
                crate::error::TestFunctionErrorKind::NoSuchFunctionExists(inner) => {
                    Error::NoSuchFunctionExists(inner)
                }
                crate::error::TestFunctionErrorKind::TestFunctionFailed(inner) => {
                    Error::TestFunctionFailed(inner)
                }
                crate::error::TestFunctionErrorKind::UnsupportedOperation(inner) => {
                    Error::UnsupportedOperation(inner)
                }
                crate::error::TestFunctionErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::UntagResourceError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::UntagResourceError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::UntagResourceErrorKind::AccessDenied(inner) => {
                    Error::AccessDenied(inner)
                }
                crate::error::UntagResourceErrorKind::InvalidArgument(inner) => {
                    Error::InvalidArgument(inner)
                }
                crate::error::UntagResourceErrorKind::InvalidTagging(inner) => {
                    Error::InvalidTagging(inner)
                }
                crate::error::UntagResourceErrorKind::NoSuchResource(inner) => {
                    Error::NoSuchResource(inner)
                }
                crate::error::UntagResourceErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::UpdateCachePolicyError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::UpdateCachePolicyError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::UpdateCachePolicyErrorKind::AccessDenied(inner) => {
                    Error::AccessDenied(inner)
                }
                crate::error::UpdateCachePolicyErrorKind::CachePolicyAlreadyExists(inner) => {
                    Error::CachePolicyAlreadyExists(inner)
                }
                crate::error::UpdateCachePolicyErrorKind::IllegalUpdate(inner) => {
                    Error::IllegalUpdate(inner)
                }
                crate::error::UpdateCachePolicyErrorKind::InconsistentQuantities(inner) => {
                    Error::InconsistentQuantities(inner)
                }
                crate::error::UpdateCachePolicyErrorKind::InvalidArgument(inner) => {
                    Error::InvalidArgument(inner)
                }
                crate::error::UpdateCachePolicyErrorKind::InvalidIfMatchVersion(inner) => {
                    Error::InvalidIfMatchVersion(inner)
                }
                crate::error::UpdateCachePolicyErrorKind::NoSuchCachePolicy(inner) => {
                    Error::NoSuchCachePolicy(inner)
                }
                crate::error::UpdateCachePolicyErrorKind::PreconditionFailed(inner) => {
                    Error::PreconditionFailed(inner)
                }
                crate::error::UpdateCachePolicyErrorKind::TooManyCookiesInCachePolicy(inner) => {
                    Error::TooManyCookiesInCachePolicy(inner)
                }
                crate::error::UpdateCachePolicyErrorKind::TooManyHeadersInCachePolicy(inner) => {
                    Error::TooManyHeadersInCachePolicy(inner)
                }
                crate::error::UpdateCachePolicyErrorKind::TooManyQueryStringsInCachePolicy(
                    inner,
                ) => Error::TooManyQueryStringsInCachePolicy(inner),
                crate::error::UpdateCachePolicyErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<
        aws_smithy_http::result::SdkError<
            crate::error::UpdateCloudFrontOriginAccessIdentityError,
            R,
        >,
    > for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::UpdateCloudFrontOriginAccessIdentityError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::UpdateCloudFrontOriginAccessIdentityErrorKind::AccessDenied(inner) => Error::AccessDenied(inner),
                crate::error::UpdateCloudFrontOriginAccessIdentityErrorKind::IllegalUpdate(inner) => Error::IllegalUpdate(inner),
                crate::error::UpdateCloudFrontOriginAccessIdentityErrorKind::InconsistentQuantities(inner) => Error::InconsistentQuantities(inner),
                crate::error::UpdateCloudFrontOriginAccessIdentityErrorKind::InvalidArgument(inner) => Error::InvalidArgument(inner),
                crate::error::UpdateCloudFrontOriginAccessIdentityErrorKind::InvalidIfMatchVersion(inner) => Error::InvalidIfMatchVersion(inner),
                crate::error::UpdateCloudFrontOriginAccessIdentityErrorKind::MissingBody(inner) => Error::MissingBody(inner),
                crate::error::UpdateCloudFrontOriginAccessIdentityErrorKind::NoSuchCloudFrontOriginAccessIdentity(inner) => Error::NoSuchCloudFrontOriginAccessIdentity(inner),
                crate::error::UpdateCloudFrontOriginAccessIdentityErrorKind::PreconditionFailed(inner) => Error::PreconditionFailed(inner),
                crate::error::UpdateCloudFrontOriginAccessIdentityErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::UpdateDistributionError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::UpdateDistributionError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::UpdateDistributionErrorKind::AccessDenied(inner) => Error::AccessDenied(inner),
                crate::error::UpdateDistributionErrorKind::CnameAlreadyExists(inner) => Error::CnameAlreadyExists(inner),
                crate::error::UpdateDistributionErrorKind::IllegalFieldLevelEncryptionConfigAssociationWithCacheBehavior(inner) => Error::IllegalFieldLevelEncryptionConfigAssociationWithCacheBehavior(inner),
                crate::error::UpdateDistributionErrorKind::IllegalUpdate(inner) => Error::IllegalUpdate(inner),
                crate::error::UpdateDistributionErrorKind::InconsistentQuantities(inner) => Error::InconsistentQuantities(inner),
                crate::error::UpdateDistributionErrorKind::InvalidArgument(inner) => Error::InvalidArgument(inner),
                crate::error::UpdateDistributionErrorKind::InvalidDefaultRootObject(inner) => Error::InvalidDefaultRootObject(inner),
                crate::error::UpdateDistributionErrorKind::InvalidErrorCode(inner) => Error::InvalidErrorCode(inner),
                crate::error::UpdateDistributionErrorKind::InvalidForwardCookies(inner) => Error::InvalidForwardCookies(inner),
                crate::error::UpdateDistributionErrorKind::InvalidFunctionAssociation(inner) => Error::InvalidFunctionAssociation(inner),
                crate::error::UpdateDistributionErrorKind::InvalidGeoRestrictionParameter(inner) => Error::InvalidGeoRestrictionParameter(inner),
                crate::error::UpdateDistributionErrorKind::InvalidHeadersForS3Origin(inner) => Error::InvalidHeadersForS3Origin(inner),
                crate::error::UpdateDistributionErrorKind::InvalidIfMatchVersion(inner) => Error::InvalidIfMatchVersion(inner),
                crate::error::UpdateDistributionErrorKind::InvalidLambdaFunctionAssociation(inner) => Error::InvalidLambdaFunctionAssociation(inner),
                crate::error::UpdateDistributionErrorKind::InvalidLocationCode(inner) => Error::InvalidLocationCode(inner),
                crate::error::UpdateDistributionErrorKind::InvalidMinimumProtocolVersion(inner) => Error::InvalidMinimumProtocolVersion(inner),
                crate::error::UpdateDistributionErrorKind::InvalidOriginAccessIdentity(inner) => Error::InvalidOriginAccessIdentity(inner),
                crate::error::UpdateDistributionErrorKind::InvalidOriginKeepaliveTimeout(inner) => Error::InvalidOriginKeepaliveTimeout(inner),
                crate::error::UpdateDistributionErrorKind::InvalidOriginReadTimeout(inner) => Error::InvalidOriginReadTimeout(inner),
                crate::error::UpdateDistributionErrorKind::InvalidQueryStringParameters(inner) => Error::InvalidQueryStringParameters(inner),
                crate::error::UpdateDistributionErrorKind::InvalidRelativePath(inner) => Error::InvalidRelativePath(inner),
                crate::error::UpdateDistributionErrorKind::InvalidRequiredProtocol(inner) => Error::InvalidRequiredProtocol(inner),
                crate::error::UpdateDistributionErrorKind::InvalidResponseCode(inner) => Error::InvalidResponseCode(inner),
                crate::error::UpdateDistributionErrorKind::InvalidTtlOrder(inner) => Error::InvalidTtlOrder(inner),
                crate::error::UpdateDistributionErrorKind::InvalidViewerCertificate(inner) => Error::InvalidViewerCertificate(inner),
                crate::error::UpdateDistributionErrorKind::InvalidWebAclId(inner) => Error::InvalidWebAclId(inner),
                crate::error::UpdateDistributionErrorKind::MissingBody(inner) => Error::MissingBody(inner),
                crate::error::UpdateDistributionErrorKind::NoSuchCachePolicy(inner) => Error::NoSuchCachePolicy(inner),
                crate::error::UpdateDistributionErrorKind::NoSuchDistribution(inner) => Error::NoSuchDistribution(inner),
                crate::error::UpdateDistributionErrorKind::NoSuchFieldLevelEncryptionConfig(inner) => Error::NoSuchFieldLevelEncryptionConfig(inner),
                crate::error::UpdateDistributionErrorKind::NoSuchOrigin(inner) => Error::NoSuchOrigin(inner),
                crate::error::UpdateDistributionErrorKind::NoSuchOriginRequestPolicy(inner) => Error::NoSuchOriginRequestPolicy(inner),
                crate::error::UpdateDistributionErrorKind::NoSuchRealtimeLogConfig(inner) => Error::NoSuchRealtimeLogConfig(inner),
                crate::error::UpdateDistributionErrorKind::NoSuchResponseHeadersPolicy(inner) => Error::NoSuchResponseHeadersPolicy(inner),
                crate::error::UpdateDistributionErrorKind::PreconditionFailed(inner) => Error::PreconditionFailed(inner),
                crate::error::UpdateDistributionErrorKind::RealtimeLogConfigOwnerMismatch(inner) => Error::RealtimeLogConfigOwnerMismatch(inner),
                crate::error::UpdateDistributionErrorKind::TooManyCacheBehaviors(inner) => Error::TooManyCacheBehaviors(inner),
                crate::error::UpdateDistributionErrorKind::TooManyCertificates(inner) => Error::TooManyCertificates(inner),
                crate::error::UpdateDistributionErrorKind::TooManyCookieNamesInWhiteList(inner) => Error::TooManyCookieNamesInWhiteList(inner),
                crate::error::UpdateDistributionErrorKind::TooManyDistributionCnamEs(inner) => Error::TooManyDistributionCnamEs(inner),
                crate::error::UpdateDistributionErrorKind::TooManyDistributionsAssociatedToCachePolicy(inner) => Error::TooManyDistributionsAssociatedToCachePolicy(inner),
                crate::error::UpdateDistributionErrorKind::TooManyDistributionsAssociatedToFieldLevelEncryptionConfig(inner) => Error::TooManyDistributionsAssociatedToFieldLevelEncryptionConfig(inner),
                crate::error::UpdateDistributionErrorKind::TooManyDistributionsAssociatedToKeyGroup(inner) => Error::TooManyDistributionsAssociatedToKeyGroup(inner),
                crate::error::UpdateDistributionErrorKind::TooManyDistributionsAssociatedToOriginRequestPolicy(inner) => Error::TooManyDistributionsAssociatedToOriginRequestPolicy(inner),
                crate::error::UpdateDistributionErrorKind::TooManyDistributionsAssociatedToResponseHeadersPolicy(inner) => Error::TooManyDistributionsAssociatedToResponseHeadersPolicy(inner),
                crate::error::UpdateDistributionErrorKind::TooManyDistributionsWithFunctionAssociations(inner) => Error::TooManyDistributionsWithFunctionAssociations(inner),
                crate::error::UpdateDistributionErrorKind::TooManyDistributionsWithLambdaAssociations(inner) => Error::TooManyDistributionsWithLambdaAssociations(inner),
                crate::error::UpdateDistributionErrorKind::TooManyDistributionsWithSingleFunctionArn(inner) => Error::TooManyDistributionsWithSingleFunctionArn(inner),
                crate::error::UpdateDistributionErrorKind::TooManyFunctionAssociations(inner) => Error::TooManyFunctionAssociations(inner),
                crate::error::UpdateDistributionErrorKind::TooManyHeadersInForwardedValues(inner) => Error::TooManyHeadersInForwardedValues(inner),
                crate::error::UpdateDistributionErrorKind::TooManyKeyGroupsAssociatedToDistribution(inner) => Error::TooManyKeyGroupsAssociatedToDistribution(inner),
                crate::error::UpdateDistributionErrorKind::TooManyLambdaFunctionAssociations(inner) => Error::TooManyLambdaFunctionAssociations(inner),
                crate::error::UpdateDistributionErrorKind::TooManyOriginCustomHeaders(inner) => Error::TooManyOriginCustomHeaders(inner),
                crate::error::UpdateDistributionErrorKind::TooManyOriginGroupsPerDistribution(inner) => Error::TooManyOriginGroupsPerDistribution(inner),
                crate::error::UpdateDistributionErrorKind::TooManyOrigins(inner) => Error::TooManyOrigins(inner),
                crate::error::UpdateDistributionErrorKind::TooManyQueryStringParameters(inner) => Error::TooManyQueryStringParameters(inner),
                crate::error::UpdateDistributionErrorKind::TooManyTrustedSigners(inner) => Error::TooManyTrustedSigners(inner),
                crate::error::UpdateDistributionErrorKind::TrustedKeyGroupDoesNotExist(inner) => Error::TrustedKeyGroupDoesNotExist(inner),
                crate::error::UpdateDistributionErrorKind::TrustedSignerDoesNotExist(inner) => Error::TrustedSignerDoesNotExist(inner),
                crate::error::UpdateDistributionErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<aws_smithy_http::result::SdkError<crate::error::UpdateFieldLevelEncryptionConfigError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::UpdateFieldLevelEncryptionConfigError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::UpdateFieldLevelEncryptionConfigErrorKind::AccessDenied(inner) => Error::AccessDenied(inner),
                crate::error::UpdateFieldLevelEncryptionConfigErrorKind::IllegalUpdate(inner) => Error::IllegalUpdate(inner),
                crate::error::UpdateFieldLevelEncryptionConfigErrorKind::InconsistentQuantities(inner) => Error::InconsistentQuantities(inner),
                crate::error::UpdateFieldLevelEncryptionConfigErrorKind::InvalidArgument(inner) => Error::InvalidArgument(inner),
                crate::error::UpdateFieldLevelEncryptionConfigErrorKind::InvalidIfMatchVersion(inner) => Error::InvalidIfMatchVersion(inner),
                crate::error::UpdateFieldLevelEncryptionConfigErrorKind::NoSuchFieldLevelEncryptionConfig(inner) => Error::NoSuchFieldLevelEncryptionConfig(inner),
                crate::error::UpdateFieldLevelEncryptionConfigErrorKind::NoSuchFieldLevelEncryptionProfile(inner) => Error::NoSuchFieldLevelEncryptionProfile(inner),
                crate::error::UpdateFieldLevelEncryptionConfigErrorKind::PreconditionFailed(inner) => Error::PreconditionFailed(inner),
                crate::error::UpdateFieldLevelEncryptionConfigErrorKind::QueryArgProfileEmpty(inner) => Error::QueryArgProfileEmpty(inner),
                crate::error::UpdateFieldLevelEncryptionConfigErrorKind::TooManyFieldLevelEncryptionContentTypeProfiles(inner) => Error::TooManyFieldLevelEncryptionContentTypeProfiles(inner),
                crate::error::UpdateFieldLevelEncryptionConfigErrorKind::TooManyFieldLevelEncryptionQueryArgProfiles(inner) => Error::TooManyFieldLevelEncryptionQueryArgProfiles(inner),
                crate::error::UpdateFieldLevelEncryptionConfigErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<aws_smithy_http::result::SdkError<crate::error::UpdateFieldLevelEncryptionProfileError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::UpdateFieldLevelEncryptionProfileError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::UpdateFieldLevelEncryptionProfileErrorKind::AccessDenied(inner) => Error::AccessDenied(inner),
                crate::error::UpdateFieldLevelEncryptionProfileErrorKind::FieldLevelEncryptionProfileAlreadyExists(inner) => Error::FieldLevelEncryptionProfileAlreadyExists(inner),
                crate::error::UpdateFieldLevelEncryptionProfileErrorKind::FieldLevelEncryptionProfileSizeExceeded(inner) => Error::FieldLevelEncryptionProfileSizeExceeded(inner),
                crate::error::UpdateFieldLevelEncryptionProfileErrorKind::IllegalUpdate(inner) => Error::IllegalUpdate(inner),
                crate::error::UpdateFieldLevelEncryptionProfileErrorKind::InconsistentQuantities(inner) => Error::InconsistentQuantities(inner),
                crate::error::UpdateFieldLevelEncryptionProfileErrorKind::InvalidArgument(inner) => Error::InvalidArgument(inner),
                crate::error::UpdateFieldLevelEncryptionProfileErrorKind::InvalidIfMatchVersion(inner) => Error::InvalidIfMatchVersion(inner),
                crate::error::UpdateFieldLevelEncryptionProfileErrorKind::NoSuchFieldLevelEncryptionProfile(inner) => Error::NoSuchFieldLevelEncryptionProfile(inner),
                crate::error::UpdateFieldLevelEncryptionProfileErrorKind::NoSuchPublicKey(inner) => Error::NoSuchPublicKey(inner),
                crate::error::UpdateFieldLevelEncryptionProfileErrorKind::PreconditionFailed(inner) => Error::PreconditionFailed(inner),
                crate::error::UpdateFieldLevelEncryptionProfileErrorKind::TooManyFieldLevelEncryptionEncryptionEntities(inner) => Error::TooManyFieldLevelEncryptionEncryptionEntities(inner),
                crate::error::UpdateFieldLevelEncryptionProfileErrorKind::TooManyFieldLevelEncryptionFieldPatterns(inner) => Error::TooManyFieldLevelEncryptionFieldPatterns(inner),
                crate::error::UpdateFieldLevelEncryptionProfileErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::UpdateFunctionError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::UpdateFunctionError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::UpdateFunctionErrorKind::FunctionSizeLimitExceeded(inner) => {
                    Error::FunctionSizeLimitExceeded(inner)
                }
                crate::error::UpdateFunctionErrorKind::InvalidArgument(inner) => {
                    Error::InvalidArgument(inner)
                }
                crate::error::UpdateFunctionErrorKind::InvalidIfMatchVersion(inner) => {
                    Error::InvalidIfMatchVersion(inner)
                }
                crate::error::UpdateFunctionErrorKind::NoSuchFunctionExists(inner) => {
                    Error::NoSuchFunctionExists(inner)
                }
                crate::error::UpdateFunctionErrorKind::PreconditionFailed(inner) => {
                    Error::PreconditionFailed(inner)
                }
                crate::error::UpdateFunctionErrorKind::UnsupportedOperation(inner) => {
                    Error::UnsupportedOperation(inner)
                }
                crate::error::UpdateFunctionErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::UpdateKeyGroupError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::UpdateKeyGroupError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::UpdateKeyGroupErrorKind::InvalidArgument(inner) => {
                    Error::InvalidArgument(inner)
                }
                crate::error::UpdateKeyGroupErrorKind::InvalidIfMatchVersion(inner) => {
                    Error::InvalidIfMatchVersion(inner)
                }
                crate::error::UpdateKeyGroupErrorKind::KeyGroupAlreadyExists(inner) => {
                    Error::KeyGroupAlreadyExists(inner)
                }
                crate::error::UpdateKeyGroupErrorKind::NoSuchResource(inner) => {
                    Error::NoSuchResource(inner)
                }
                crate::error::UpdateKeyGroupErrorKind::PreconditionFailed(inner) => {
                    Error::PreconditionFailed(inner)
                }
                crate::error::UpdateKeyGroupErrorKind::TooManyPublicKeysInKeyGroup(inner) => {
                    Error::TooManyPublicKeysInKeyGroup(inner)
                }
                crate::error::UpdateKeyGroupErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::UpdateOriginRequestPolicyError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::UpdateOriginRequestPolicyError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::UpdateOriginRequestPolicyErrorKind::AccessDenied(inner) => Error::AccessDenied(inner),
                crate::error::UpdateOriginRequestPolicyErrorKind::IllegalUpdate(inner) => Error::IllegalUpdate(inner),
                crate::error::UpdateOriginRequestPolicyErrorKind::InconsistentQuantities(inner) => Error::InconsistentQuantities(inner),
                crate::error::UpdateOriginRequestPolicyErrorKind::InvalidArgument(inner) => Error::InvalidArgument(inner),
                crate::error::UpdateOriginRequestPolicyErrorKind::InvalidIfMatchVersion(inner) => Error::InvalidIfMatchVersion(inner),
                crate::error::UpdateOriginRequestPolicyErrorKind::NoSuchOriginRequestPolicy(inner) => Error::NoSuchOriginRequestPolicy(inner),
                crate::error::UpdateOriginRequestPolicyErrorKind::OriginRequestPolicyAlreadyExists(inner) => Error::OriginRequestPolicyAlreadyExists(inner),
                crate::error::UpdateOriginRequestPolicyErrorKind::PreconditionFailed(inner) => Error::PreconditionFailed(inner),
                crate::error::UpdateOriginRequestPolicyErrorKind::TooManyCookiesInOriginRequestPolicy(inner) => Error::TooManyCookiesInOriginRequestPolicy(inner),
                crate::error::UpdateOriginRequestPolicyErrorKind::TooManyHeadersInOriginRequestPolicy(inner) => Error::TooManyHeadersInOriginRequestPolicy(inner),
                crate::error::UpdateOriginRequestPolicyErrorKind::TooManyQueryStringsInOriginRequestPolicy(inner) => Error::TooManyQueryStringsInOriginRequestPolicy(inner),
                crate::error::UpdateOriginRequestPolicyErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::UpdatePublicKeyError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::UpdatePublicKeyError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::UpdatePublicKeyErrorKind::AccessDenied(inner) => {
                    Error::AccessDenied(inner)
                }
                crate::error::UpdatePublicKeyErrorKind::CannotChangeImmutablePublicKeyFields(
                    inner,
                ) => Error::CannotChangeImmutablePublicKeyFields(inner),
                crate::error::UpdatePublicKeyErrorKind::IllegalUpdate(inner) => {
                    Error::IllegalUpdate(inner)
                }
                crate::error::UpdatePublicKeyErrorKind::InvalidArgument(inner) => {
                    Error::InvalidArgument(inner)
                }
                crate::error::UpdatePublicKeyErrorKind::InvalidIfMatchVersion(inner) => {
                    Error::InvalidIfMatchVersion(inner)
                }
                crate::error::UpdatePublicKeyErrorKind::NoSuchPublicKey(inner) => {
                    Error::NoSuchPublicKey(inner)
                }
                crate::error::UpdatePublicKeyErrorKind::PreconditionFailed(inner) => {
                    Error::PreconditionFailed(inner)
                }
                crate::error::UpdatePublicKeyErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::UpdateRealtimeLogConfigError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::UpdateRealtimeLogConfigError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::UpdateRealtimeLogConfigErrorKind::AccessDenied(inner) => {
                    Error::AccessDenied(inner)
                }
                crate::error::UpdateRealtimeLogConfigErrorKind::InvalidArgument(inner) => {
                    Error::InvalidArgument(inner)
                }
                crate::error::UpdateRealtimeLogConfigErrorKind::NoSuchRealtimeLogConfig(inner) => {
                    Error::NoSuchRealtimeLogConfig(inner)
                }
                crate::error::UpdateRealtimeLogConfigErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::UpdateResponseHeadersPolicyError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::UpdateResponseHeadersPolicyError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::UpdateResponseHeadersPolicyErrorKind::AccessDenied(inner) => Error::AccessDenied(inner),
                crate::error::UpdateResponseHeadersPolicyErrorKind::IllegalUpdate(inner) => Error::IllegalUpdate(inner),
                crate::error::UpdateResponseHeadersPolicyErrorKind::InconsistentQuantities(inner) => Error::InconsistentQuantities(inner),
                crate::error::UpdateResponseHeadersPolicyErrorKind::InvalidArgument(inner) => Error::InvalidArgument(inner),
                crate::error::UpdateResponseHeadersPolicyErrorKind::InvalidIfMatchVersion(inner) => Error::InvalidIfMatchVersion(inner),
                crate::error::UpdateResponseHeadersPolicyErrorKind::NoSuchResponseHeadersPolicy(inner) => Error::NoSuchResponseHeadersPolicy(inner),
                crate::error::UpdateResponseHeadersPolicyErrorKind::PreconditionFailed(inner) => Error::PreconditionFailed(inner),
                crate::error::UpdateResponseHeadersPolicyErrorKind::ResponseHeadersPolicyAlreadyExists(inner) => Error::ResponseHeadersPolicyAlreadyExists(inner),
                crate::error::UpdateResponseHeadersPolicyErrorKind::TooManyCustomHeadersInResponseHeadersPolicy(inner) => Error::TooManyCustomHeadersInResponseHeadersPolicy(inner),
                crate::error::UpdateResponseHeadersPolicyErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::UpdateStreamingDistributionError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::UpdateStreamingDistributionError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::UpdateStreamingDistributionErrorKind::AccessDenied(inner) => Error::AccessDenied(inner),
                crate::error::UpdateStreamingDistributionErrorKind::CnameAlreadyExists(inner) => Error::CnameAlreadyExists(inner),
                crate::error::UpdateStreamingDistributionErrorKind::IllegalUpdate(inner) => Error::IllegalUpdate(inner),
                crate::error::UpdateStreamingDistributionErrorKind::InconsistentQuantities(inner) => Error::InconsistentQuantities(inner),
                crate::error::UpdateStreamingDistributionErrorKind::InvalidArgument(inner) => Error::InvalidArgument(inner),
                crate::error::UpdateStreamingDistributionErrorKind::InvalidIfMatchVersion(inner) => Error::InvalidIfMatchVersion(inner),
                crate::error::UpdateStreamingDistributionErrorKind::InvalidOriginAccessIdentity(inner) => Error::InvalidOriginAccessIdentity(inner),
                crate::error::UpdateStreamingDistributionErrorKind::MissingBody(inner) => Error::MissingBody(inner),
                crate::error::UpdateStreamingDistributionErrorKind::NoSuchStreamingDistribution(inner) => Error::NoSuchStreamingDistribution(inner),
                crate::error::UpdateStreamingDistributionErrorKind::PreconditionFailed(inner) => Error::PreconditionFailed(inner),
                crate::error::UpdateStreamingDistributionErrorKind::TooManyStreamingDistributionCnamEs(inner) => Error::TooManyStreamingDistributionCnamEs(inner),
                crate::error::UpdateStreamingDistributionErrorKind::TooManyTrustedSigners(inner) => Error::TooManyTrustedSigners(inner),
                crate::error::UpdateStreamingDistributionErrorKind::TrustedSignerDoesNotExist(inner) => Error::TrustedSignerDoesNotExist(inner),
                crate::error::UpdateStreamingDistributionErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl std::error::Error for Error {}
