// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// <p>The returned result of the corresponding request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateStreamingDistributionOutput {
    /// <p>The streaming distribution's information.</p>
    pub streaming_distribution: std::option::Option<crate::model::StreamingDistribution>,
    /// <p>The current version of the configuration. For example:
    /// <code>E2QWRUHAPOMQZL</code>.</p>
    pub e_tag: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for UpdateStreamingDistributionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateStreamingDistributionOutput");
        formatter.field("streaming_distribution", &self.streaming_distribution);
        formatter.field("e_tag", &self.e_tag);
        formatter.finish()
    }
}
/// See [`UpdateStreamingDistributionOutput`](crate::output::UpdateStreamingDistributionOutput)
pub mod update_streaming_distribution_output {
    /// A builder for [`UpdateStreamingDistributionOutput`](crate::output::UpdateStreamingDistributionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) streaming_distribution: std::option::Option<crate::model::StreamingDistribution>,
        pub(crate) e_tag: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The streaming distribution's information.</p>
        pub fn streaming_distribution(
            mut self,
            input: crate::model::StreamingDistribution,
        ) -> Self {
            self.streaming_distribution = Some(input);
            self
        }
        /// <p>The streaming distribution's information.</p>
        pub fn set_streaming_distribution(
            mut self,
            input: std::option::Option<crate::model::StreamingDistribution>,
        ) -> Self {
            self.streaming_distribution = input;
            self
        }
        /// <p>The current version of the configuration. For example:
        /// <code>E2QWRUHAPOMQZL</code>.</p>
        pub fn e_tag(mut self, input: impl Into<std::string::String>) -> Self {
            self.e_tag = Some(input.into());
            self
        }
        /// <p>The current version of the configuration. For example:
        /// <code>E2QWRUHAPOMQZL</code>.</p>
        pub fn set_e_tag(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.e_tag = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateStreamingDistributionOutput`](crate::output::UpdateStreamingDistributionOutput)
        pub fn build(self) -> crate::output::UpdateStreamingDistributionOutput {
            crate::output::UpdateStreamingDistributionOutput {
                streaming_distribution: self.streaming_distribution,
                e_tag: self.e_tag,
            }
        }
    }
}
impl UpdateStreamingDistributionOutput {
    /// Creates a new builder-style object to manufacture [`UpdateStreamingDistributionOutput`](crate::output::UpdateStreamingDistributionOutput)
    pub fn builder() -> crate::output::update_streaming_distribution_output::Builder {
        crate::output::update_streaming_distribution_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateResponseHeadersPolicyOutput {
    /// <p>A response headers policy.</p>
    pub response_headers_policy: std::option::Option<crate::model::ResponseHeadersPolicy>,
    /// <p>The current version of the response headers policy.</p>
    pub e_tag: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for UpdateResponseHeadersPolicyOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateResponseHeadersPolicyOutput");
        formatter.field("response_headers_policy", &self.response_headers_policy);
        formatter.field("e_tag", &self.e_tag);
        formatter.finish()
    }
}
/// See [`UpdateResponseHeadersPolicyOutput`](crate::output::UpdateResponseHeadersPolicyOutput)
pub mod update_response_headers_policy_output {
    /// A builder for [`UpdateResponseHeadersPolicyOutput`](crate::output::UpdateResponseHeadersPolicyOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) response_headers_policy:
            std::option::Option<crate::model::ResponseHeadersPolicy>,
        pub(crate) e_tag: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A response headers policy.</p>
        pub fn response_headers_policy(
            mut self,
            input: crate::model::ResponseHeadersPolicy,
        ) -> Self {
            self.response_headers_policy = Some(input);
            self
        }
        /// <p>A response headers policy.</p>
        pub fn set_response_headers_policy(
            mut self,
            input: std::option::Option<crate::model::ResponseHeadersPolicy>,
        ) -> Self {
            self.response_headers_policy = input;
            self
        }
        /// <p>The current version of the response headers policy.</p>
        pub fn e_tag(mut self, input: impl Into<std::string::String>) -> Self {
            self.e_tag = Some(input.into());
            self
        }
        /// <p>The current version of the response headers policy.</p>
        pub fn set_e_tag(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.e_tag = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateResponseHeadersPolicyOutput`](crate::output::UpdateResponseHeadersPolicyOutput)
        pub fn build(self) -> crate::output::UpdateResponseHeadersPolicyOutput {
            crate::output::UpdateResponseHeadersPolicyOutput {
                response_headers_policy: self.response_headers_policy,
                e_tag: self.e_tag,
            }
        }
    }
}
impl UpdateResponseHeadersPolicyOutput {
    /// Creates a new builder-style object to manufacture [`UpdateResponseHeadersPolicyOutput`](crate::output::UpdateResponseHeadersPolicyOutput)
    pub fn builder() -> crate::output::update_response_headers_policy_output::Builder {
        crate::output::update_response_headers_policy_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateRealtimeLogConfigOutput {
    /// <p>A real-time log configuration.</p>
    pub realtime_log_config: std::option::Option<crate::model::RealtimeLogConfig>,
}
impl std::fmt::Debug for UpdateRealtimeLogConfigOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateRealtimeLogConfigOutput");
        formatter.field("realtime_log_config", &self.realtime_log_config);
        formatter.finish()
    }
}
/// See [`UpdateRealtimeLogConfigOutput`](crate::output::UpdateRealtimeLogConfigOutput)
pub mod update_realtime_log_config_output {
    /// A builder for [`UpdateRealtimeLogConfigOutput`](crate::output::UpdateRealtimeLogConfigOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) realtime_log_config: std::option::Option<crate::model::RealtimeLogConfig>,
    }
    impl Builder {
        /// <p>A real-time log configuration.</p>
        pub fn realtime_log_config(mut self, input: crate::model::RealtimeLogConfig) -> Self {
            self.realtime_log_config = Some(input);
            self
        }
        /// <p>A real-time log configuration.</p>
        pub fn set_realtime_log_config(
            mut self,
            input: std::option::Option<crate::model::RealtimeLogConfig>,
        ) -> Self {
            self.realtime_log_config = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateRealtimeLogConfigOutput`](crate::output::UpdateRealtimeLogConfigOutput)
        pub fn build(self) -> crate::output::UpdateRealtimeLogConfigOutput {
            crate::output::UpdateRealtimeLogConfigOutput {
                realtime_log_config: self.realtime_log_config,
            }
        }
    }
}
impl UpdateRealtimeLogConfigOutput {
    /// Creates a new builder-style object to manufacture [`UpdateRealtimeLogConfigOutput`](crate::output::UpdateRealtimeLogConfigOutput)
    pub fn builder() -> crate::output::update_realtime_log_config_output::Builder {
        crate::output::update_realtime_log_config_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdatePublicKeyOutput {
    /// <p>The public key.</p>
    pub public_key: std::option::Option<crate::model::PublicKey>,
    /// <p>The identifier of the current version of the public key.</p>
    pub e_tag: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for UpdatePublicKeyOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdatePublicKeyOutput");
        formatter.field("public_key", &self.public_key);
        formatter.field("e_tag", &self.e_tag);
        formatter.finish()
    }
}
/// See [`UpdatePublicKeyOutput`](crate::output::UpdatePublicKeyOutput)
pub mod update_public_key_output {
    /// A builder for [`UpdatePublicKeyOutput`](crate::output::UpdatePublicKeyOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) public_key: std::option::Option<crate::model::PublicKey>,
        pub(crate) e_tag: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The public key.</p>
        pub fn public_key(mut self, input: crate::model::PublicKey) -> Self {
            self.public_key = Some(input);
            self
        }
        /// <p>The public key.</p>
        pub fn set_public_key(
            mut self,
            input: std::option::Option<crate::model::PublicKey>,
        ) -> Self {
            self.public_key = input;
            self
        }
        /// <p>The identifier of the current version of the public key.</p>
        pub fn e_tag(mut self, input: impl Into<std::string::String>) -> Self {
            self.e_tag = Some(input.into());
            self
        }
        /// <p>The identifier of the current version of the public key.</p>
        pub fn set_e_tag(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.e_tag = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdatePublicKeyOutput`](crate::output::UpdatePublicKeyOutput)
        pub fn build(self) -> crate::output::UpdatePublicKeyOutput {
            crate::output::UpdatePublicKeyOutput {
                public_key: self.public_key,
                e_tag: self.e_tag,
            }
        }
    }
}
impl UpdatePublicKeyOutput {
    /// Creates a new builder-style object to manufacture [`UpdatePublicKeyOutput`](crate::output::UpdatePublicKeyOutput)
    pub fn builder() -> crate::output::update_public_key_output::Builder {
        crate::output::update_public_key_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateOriginRequestPolicyOutput {
    /// <p>An origin request policy.</p>
    pub origin_request_policy: std::option::Option<crate::model::OriginRequestPolicy>,
    /// <p>The current version of the origin request policy.</p>
    pub e_tag: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for UpdateOriginRequestPolicyOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateOriginRequestPolicyOutput");
        formatter.field("origin_request_policy", &self.origin_request_policy);
        formatter.field("e_tag", &self.e_tag);
        formatter.finish()
    }
}
/// See [`UpdateOriginRequestPolicyOutput`](crate::output::UpdateOriginRequestPolicyOutput)
pub mod update_origin_request_policy_output {
    /// A builder for [`UpdateOriginRequestPolicyOutput`](crate::output::UpdateOriginRequestPolicyOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) origin_request_policy: std::option::Option<crate::model::OriginRequestPolicy>,
        pub(crate) e_tag: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>An origin request policy.</p>
        pub fn origin_request_policy(mut self, input: crate::model::OriginRequestPolicy) -> Self {
            self.origin_request_policy = Some(input);
            self
        }
        /// <p>An origin request policy.</p>
        pub fn set_origin_request_policy(
            mut self,
            input: std::option::Option<crate::model::OriginRequestPolicy>,
        ) -> Self {
            self.origin_request_policy = input;
            self
        }
        /// <p>The current version of the origin request policy.</p>
        pub fn e_tag(mut self, input: impl Into<std::string::String>) -> Self {
            self.e_tag = Some(input.into());
            self
        }
        /// <p>The current version of the origin request policy.</p>
        pub fn set_e_tag(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.e_tag = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateOriginRequestPolicyOutput`](crate::output::UpdateOriginRequestPolicyOutput)
        pub fn build(self) -> crate::output::UpdateOriginRequestPolicyOutput {
            crate::output::UpdateOriginRequestPolicyOutput {
                origin_request_policy: self.origin_request_policy,
                e_tag: self.e_tag,
            }
        }
    }
}
impl UpdateOriginRequestPolicyOutput {
    /// Creates a new builder-style object to manufacture [`UpdateOriginRequestPolicyOutput`](crate::output::UpdateOriginRequestPolicyOutput)
    pub fn builder() -> crate::output::update_origin_request_policy_output::Builder {
        crate::output::update_origin_request_policy_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateKeyGroupOutput {
    /// <p>The key group that was just updated.</p>
    pub key_group: std::option::Option<crate::model::KeyGroup>,
    /// <p>The identifier for this version of the key group.</p>
    pub e_tag: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for UpdateKeyGroupOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateKeyGroupOutput");
        formatter.field("key_group", &self.key_group);
        formatter.field("e_tag", &self.e_tag);
        formatter.finish()
    }
}
/// See [`UpdateKeyGroupOutput`](crate::output::UpdateKeyGroupOutput)
pub mod update_key_group_output {
    /// A builder for [`UpdateKeyGroupOutput`](crate::output::UpdateKeyGroupOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) key_group: std::option::Option<crate::model::KeyGroup>,
        pub(crate) e_tag: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The key group that was just updated.</p>
        pub fn key_group(mut self, input: crate::model::KeyGroup) -> Self {
            self.key_group = Some(input);
            self
        }
        /// <p>The key group that was just updated.</p>
        pub fn set_key_group(mut self, input: std::option::Option<crate::model::KeyGroup>) -> Self {
            self.key_group = input;
            self
        }
        /// <p>The identifier for this version of the key group.</p>
        pub fn e_tag(mut self, input: impl Into<std::string::String>) -> Self {
            self.e_tag = Some(input.into());
            self
        }
        /// <p>The identifier for this version of the key group.</p>
        pub fn set_e_tag(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.e_tag = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateKeyGroupOutput`](crate::output::UpdateKeyGroupOutput)
        pub fn build(self) -> crate::output::UpdateKeyGroupOutput {
            crate::output::UpdateKeyGroupOutput {
                key_group: self.key_group,
                e_tag: self.e_tag,
            }
        }
    }
}
impl UpdateKeyGroupOutput {
    /// Creates a new builder-style object to manufacture [`UpdateKeyGroupOutput`](crate::output::UpdateKeyGroupOutput)
    pub fn builder() -> crate::output::update_key_group_output::Builder {
        crate::output::update_key_group_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateFunctionOutput {
    /// <p>Contains configuration information and metadata about a CloudFront function.</p>
    pub function_summary: std::option::Option<crate::model::FunctionSummary>,
    /// <p>The version identifier for the current version of the CloudFront function.</p>
    pub e_tag: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for UpdateFunctionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateFunctionOutput");
        formatter.field("function_summary", &self.function_summary);
        formatter.field("e_tag", &self.e_tag);
        formatter.finish()
    }
}
/// See [`UpdateFunctionOutput`](crate::output::UpdateFunctionOutput)
pub mod update_function_output {
    /// A builder for [`UpdateFunctionOutput`](crate::output::UpdateFunctionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) function_summary: std::option::Option<crate::model::FunctionSummary>,
        pub(crate) e_tag: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Contains configuration information and metadata about a CloudFront function.</p>
        pub fn function_summary(mut self, input: crate::model::FunctionSummary) -> Self {
            self.function_summary = Some(input);
            self
        }
        /// <p>Contains configuration information and metadata about a CloudFront function.</p>
        pub fn set_function_summary(
            mut self,
            input: std::option::Option<crate::model::FunctionSummary>,
        ) -> Self {
            self.function_summary = input;
            self
        }
        /// <p>The version identifier for the current version of the CloudFront function.</p>
        pub fn e_tag(mut self, input: impl Into<std::string::String>) -> Self {
            self.e_tag = Some(input.into());
            self
        }
        /// <p>The version identifier for the current version of the CloudFront function.</p>
        pub fn set_e_tag(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.e_tag = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateFunctionOutput`](crate::output::UpdateFunctionOutput)
        pub fn build(self) -> crate::output::UpdateFunctionOutput {
            crate::output::UpdateFunctionOutput {
                function_summary: self.function_summary,
                e_tag: self.e_tag,
            }
        }
    }
}
impl UpdateFunctionOutput {
    /// Creates a new builder-style object to manufacture [`UpdateFunctionOutput`](crate::output::UpdateFunctionOutput)
    pub fn builder() -> crate::output::update_function_output::Builder {
        crate::output::update_function_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateFieldLevelEncryptionProfileOutput {
    /// <p>Return the results of updating the profile.</p>
    pub field_level_encryption_profile:
        std::option::Option<crate::model::FieldLevelEncryptionProfile>,
    /// <p>The result of the field-level encryption profile request. </p>
    pub e_tag: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for UpdateFieldLevelEncryptionProfileOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateFieldLevelEncryptionProfileOutput");
        formatter.field(
            "field_level_encryption_profile",
            &self.field_level_encryption_profile,
        );
        formatter.field("e_tag", &self.e_tag);
        formatter.finish()
    }
}
/// See [`UpdateFieldLevelEncryptionProfileOutput`](crate::output::UpdateFieldLevelEncryptionProfileOutput)
pub mod update_field_level_encryption_profile_output {
    /// A builder for [`UpdateFieldLevelEncryptionProfileOutput`](crate::output::UpdateFieldLevelEncryptionProfileOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) field_level_encryption_profile:
            std::option::Option<crate::model::FieldLevelEncryptionProfile>,
        pub(crate) e_tag: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Return the results of updating the profile.</p>
        pub fn field_level_encryption_profile(
            mut self,
            input: crate::model::FieldLevelEncryptionProfile,
        ) -> Self {
            self.field_level_encryption_profile = Some(input);
            self
        }
        /// <p>Return the results of updating the profile.</p>
        pub fn set_field_level_encryption_profile(
            mut self,
            input: std::option::Option<crate::model::FieldLevelEncryptionProfile>,
        ) -> Self {
            self.field_level_encryption_profile = input;
            self
        }
        /// <p>The result of the field-level encryption profile request. </p>
        pub fn e_tag(mut self, input: impl Into<std::string::String>) -> Self {
            self.e_tag = Some(input.into());
            self
        }
        /// <p>The result of the field-level encryption profile request. </p>
        pub fn set_e_tag(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.e_tag = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateFieldLevelEncryptionProfileOutput`](crate::output::UpdateFieldLevelEncryptionProfileOutput)
        pub fn build(self) -> crate::output::UpdateFieldLevelEncryptionProfileOutput {
            crate::output::UpdateFieldLevelEncryptionProfileOutput {
                field_level_encryption_profile: self.field_level_encryption_profile,
                e_tag: self.e_tag,
            }
        }
    }
}
impl UpdateFieldLevelEncryptionProfileOutput {
    /// Creates a new builder-style object to manufacture [`UpdateFieldLevelEncryptionProfileOutput`](crate::output::UpdateFieldLevelEncryptionProfileOutput)
    pub fn builder() -> crate::output::update_field_level_encryption_profile_output::Builder {
        crate::output::update_field_level_encryption_profile_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateFieldLevelEncryptionConfigOutput {
    /// <p>Return the results of updating the configuration.</p>
    pub field_level_encryption: std::option::Option<crate::model::FieldLevelEncryption>,
    /// <p>The value of the <code>ETag</code> header that you received when updating the configuration.
    /// For example: <code>E2QWRUHAPOMQZL</code>.</p>
    pub e_tag: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for UpdateFieldLevelEncryptionConfigOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateFieldLevelEncryptionConfigOutput");
        formatter.field("field_level_encryption", &self.field_level_encryption);
        formatter.field("e_tag", &self.e_tag);
        formatter.finish()
    }
}
/// See [`UpdateFieldLevelEncryptionConfigOutput`](crate::output::UpdateFieldLevelEncryptionConfigOutput)
pub mod update_field_level_encryption_config_output {
    /// A builder for [`UpdateFieldLevelEncryptionConfigOutput`](crate::output::UpdateFieldLevelEncryptionConfigOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) field_level_encryption: std::option::Option<crate::model::FieldLevelEncryption>,
        pub(crate) e_tag: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Return the results of updating the configuration.</p>
        pub fn field_level_encryption(mut self, input: crate::model::FieldLevelEncryption) -> Self {
            self.field_level_encryption = Some(input);
            self
        }
        /// <p>Return the results of updating the configuration.</p>
        pub fn set_field_level_encryption(
            mut self,
            input: std::option::Option<crate::model::FieldLevelEncryption>,
        ) -> Self {
            self.field_level_encryption = input;
            self
        }
        /// <p>The value of the <code>ETag</code> header that you received when updating the configuration.
        /// For example: <code>E2QWRUHAPOMQZL</code>.</p>
        pub fn e_tag(mut self, input: impl Into<std::string::String>) -> Self {
            self.e_tag = Some(input.into());
            self
        }
        /// <p>The value of the <code>ETag</code> header that you received when updating the configuration.
        /// For example: <code>E2QWRUHAPOMQZL</code>.</p>
        pub fn set_e_tag(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.e_tag = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateFieldLevelEncryptionConfigOutput`](crate::output::UpdateFieldLevelEncryptionConfigOutput)
        pub fn build(self) -> crate::output::UpdateFieldLevelEncryptionConfigOutput {
            crate::output::UpdateFieldLevelEncryptionConfigOutput {
                field_level_encryption: self.field_level_encryption,
                e_tag: self.e_tag,
            }
        }
    }
}
impl UpdateFieldLevelEncryptionConfigOutput {
    /// Creates a new builder-style object to manufacture [`UpdateFieldLevelEncryptionConfigOutput`](crate::output::UpdateFieldLevelEncryptionConfigOutput)
    pub fn builder() -> crate::output::update_field_level_encryption_config_output::Builder {
        crate::output::update_field_level_encryption_config_output::Builder::default()
    }
}

/// <p>The returned result of the corresponding request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateDistributionOutput {
    /// <p>The distribution's information.</p>
    pub distribution: std::option::Option<crate::model::Distribution>,
    /// <p>The current version of the configuration. For example:
    /// <code>E2QWRUHAPOMQZL</code>.</p>
    pub e_tag: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for UpdateDistributionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateDistributionOutput");
        formatter.field("distribution", &self.distribution);
        formatter.field("e_tag", &self.e_tag);
        formatter.finish()
    }
}
/// See [`UpdateDistributionOutput`](crate::output::UpdateDistributionOutput)
pub mod update_distribution_output {
    /// A builder for [`UpdateDistributionOutput`](crate::output::UpdateDistributionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) distribution: std::option::Option<crate::model::Distribution>,
        pub(crate) e_tag: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The distribution's information.</p>
        pub fn distribution(mut self, input: crate::model::Distribution) -> Self {
            self.distribution = Some(input);
            self
        }
        /// <p>The distribution's information.</p>
        pub fn set_distribution(
            mut self,
            input: std::option::Option<crate::model::Distribution>,
        ) -> Self {
            self.distribution = input;
            self
        }
        /// <p>The current version of the configuration. For example:
        /// <code>E2QWRUHAPOMQZL</code>.</p>
        pub fn e_tag(mut self, input: impl Into<std::string::String>) -> Self {
            self.e_tag = Some(input.into());
            self
        }
        /// <p>The current version of the configuration. For example:
        /// <code>E2QWRUHAPOMQZL</code>.</p>
        pub fn set_e_tag(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.e_tag = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateDistributionOutput`](crate::output::UpdateDistributionOutput)
        pub fn build(self) -> crate::output::UpdateDistributionOutput {
            crate::output::UpdateDistributionOutput {
                distribution: self.distribution,
                e_tag: self.e_tag,
            }
        }
    }
}
impl UpdateDistributionOutput {
    /// Creates a new builder-style object to manufacture [`UpdateDistributionOutput`](crate::output::UpdateDistributionOutput)
    pub fn builder() -> crate::output::update_distribution_output::Builder {
        crate::output::update_distribution_output::Builder::default()
    }
}

/// <p>The returned result of the corresponding request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateCloudFrontOriginAccessIdentityOutput {
    /// <p>The origin access identity's information.</p>
    pub cloud_front_origin_access_identity:
        std::option::Option<crate::model::CloudFrontOriginAccessIdentity>,
    /// <p>The current version of the configuration. For example:
    /// <code>E2QWRUHAPOMQZL</code>.</p>
    pub e_tag: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for UpdateCloudFrontOriginAccessIdentityOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateCloudFrontOriginAccessIdentityOutput");
        formatter.field(
            "cloud_front_origin_access_identity",
            &self.cloud_front_origin_access_identity,
        );
        formatter.field("e_tag", &self.e_tag);
        formatter.finish()
    }
}
/// See [`UpdateCloudFrontOriginAccessIdentityOutput`](crate::output::UpdateCloudFrontOriginAccessIdentityOutput)
pub mod update_cloud_front_origin_access_identity_output {
    /// A builder for [`UpdateCloudFrontOriginAccessIdentityOutput`](crate::output::UpdateCloudFrontOriginAccessIdentityOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cloud_front_origin_access_identity:
            std::option::Option<crate::model::CloudFrontOriginAccessIdentity>,
        pub(crate) e_tag: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The origin access identity's information.</p>
        pub fn cloud_front_origin_access_identity(
            mut self,
            input: crate::model::CloudFrontOriginAccessIdentity,
        ) -> Self {
            self.cloud_front_origin_access_identity = Some(input);
            self
        }
        /// <p>The origin access identity's information.</p>
        pub fn set_cloud_front_origin_access_identity(
            mut self,
            input: std::option::Option<crate::model::CloudFrontOriginAccessIdentity>,
        ) -> Self {
            self.cloud_front_origin_access_identity = input;
            self
        }
        /// <p>The current version of the configuration. For example:
        /// <code>E2QWRUHAPOMQZL</code>.</p>
        pub fn e_tag(mut self, input: impl Into<std::string::String>) -> Self {
            self.e_tag = Some(input.into());
            self
        }
        /// <p>The current version of the configuration. For example:
        /// <code>E2QWRUHAPOMQZL</code>.</p>
        pub fn set_e_tag(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.e_tag = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateCloudFrontOriginAccessIdentityOutput`](crate::output::UpdateCloudFrontOriginAccessIdentityOutput)
        pub fn build(self) -> crate::output::UpdateCloudFrontOriginAccessIdentityOutput {
            crate::output::UpdateCloudFrontOriginAccessIdentityOutput {
                cloud_front_origin_access_identity: self.cloud_front_origin_access_identity,
                e_tag: self.e_tag,
            }
        }
    }
}
impl UpdateCloudFrontOriginAccessIdentityOutput {
    /// Creates a new builder-style object to manufacture [`UpdateCloudFrontOriginAccessIdentityOutput`](crate::output::UpdateCloudFrontOriginAccessIdentityOutput)
    pub fn builder() -> crate::output::update_cloud_front_origin_access_identity_output::Builder {
        crate::output::update_cloud_front_origin_access_identity_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateCachePolicyOutput {
    /// <p>A cache policy.</p>
    pub cache_policy: std::option::Option<crate::model::CachePolicy>,
    /// <p>The current version of the cache policy.</p>
    pub e_tag: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for UpdateCachePolicyOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateCachePolicyOutput");
        formatter.field("cache_policy", &self.cache_policy);
        formatter.field("e_tag", &self.e_tag);
        formatter.finish()
    }
}
/// See [`UpdateCachePolicyOutput`](crate::output::UpdateCachePolicyOutput)
pub mod update_cache_policy_output {
    /// A builder for [`UpdateCachePolicyOutput`](crate::output::UpdateCachePolicyOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cache_policy: std::option::Option<crate::model::CachePolicy>,
        pub(crate) e_tag: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A cache policy.</p>
        pub fn cache_policy(mut self, input: crate::model::CachePolicy) -> Self {
            self.cache_policy = Some(input);
            self
        }
        /// <p>A cache policy.</p>
        pub fn set_cache_policy(
            mut self,
            input: std::option::Option<crate::model::CachePolicy>,
        ) -> Self {
            self.cache_policy = input;
            self
        }
        /// <p>The current version of the cache policy.</p>
        pub fn e_tag(mut self, input: impl Into<std::string::String>) -> Self {
            self.e_tag = Some(input.into());
            self
        }
        /// <p>The current version of the cache policy.</p>
        pub fn set_e_tag(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.e_tag = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateCachePolicyOutput`](crate::output::UpdateCachePolicyOutput)
        pub fn build(self) -> crate::output::UpdateCachePolicyOutput {
            crate::output::UpdateCachePolicyOutput {
                cache_policy: self.cache_policy,
                e_tag: self.e_tag,
            }
        }
    }
}
impl UpdateCachePolicyOutput {
    /// Creates a new builder-style object to manufacture [`UpdateCachePolicyOutput`](crate::output::UpdateCachePolicyOutput)
    pub fn builder() -> crate::output::update_cache_policy_output::Builder {
        crate::output::update_cache_policy_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UntagResourceOutput {}
impl std::fmt::Debug for UntagResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UntagResourceOutput");
        formatter.finish()
    }
}
/// See [`UntagResourceOutput`](crate::output::UntagResourceOutput)
pub mod untag_resource_output {
    /// A builder for [`UntagResourceOutput`](crate::output::UntagResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`UntagResourceOutput`](crate::output::UntagResourceOutput)
        pub fn build(self) -> crate::output::UntagResourceOutput {
            crate::output::UntagResourceOutput {}
        }
    }
}
impl UntagResourceOutput {
    /// Creates a new builder-style object to manufacture [`UntagResourceOutput`](crate::output::UntagResourceOutput)
    pub fn builder() -> crate::output::untag_resource_output::Builder {
        crate::output::untag_resource_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TestFunctionOutput {
    /// <p>An object that represents the result of running the function with the provided event
    /// object.</p>
    pub test_result: std::option::Option<crate::model::TestResult>,
}
impl std::fmt::Debug for TestFunctionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TestFunctionOutput");
        formatter.field("test_result", &self.test_result);
        formatter.finish()
    }
}
/// See [`TestFunctionOutput`](crate::output::TestFunctionOutput)
pub mod test_function_output {
    /// A builder for [`TestFunctionOutput`](crate::output::TestFunctionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) test_result: std::option::Option<crate::model::TestResult>,
    }
    impl Builder {
        /// <p>An object that represents the result of running the function with the provided event
        /// object.</p>
        pub fn test_result(mut self, input: crate::model::TestResult) -> Self {
            self.test_result = Some(input);
            self
        }
        /// <p>An object that represents the result of running the function with the provided event
        /// object.</p>
        pub fn set_test_result(
            mut self,
            input: std::option::Option<crate::model::TestResult>,
        ) -> Self {
            self.test_result = input;
            self
        }
        /// Consumes the builder and constructs a [`TestFunctionOutput`](crate::output::TestFunctionOutput)
        pub fn build(self) -> crate::output::TestFunctionOutput {
            crate::output::TestFunctionOutput {
                test_result: self.test_result,
            }
        }
    }
}
impl TestFunctionOutput {
    /// Creates a new builder-style object to manufacture [`TestFunctionOutput`](crate::output::TestFunctionOutput)
    pub fn builder() -> crate::output::test_function_output::Builder {
        crate::output::test_function_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TagResourceOutput {}
impl std::fmt::Debug for TagResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TagResourceOutput");
        formatter.finish()
    }
}
/// See [`TagResourceOutput`](crate::output::TagResourceOutput)
pub mod tag_resource_output {
    /// A builder for [`TagResourceOutput`](crate::output::TagResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`TagResourceOutput`](crate::output::TagResourceOutput)
        pub fn build(self) -> crate::output::TagResourceOutput {
            crate::output::TagResourceOutput {}
        }
    }
}
impl TagResourceOutput {
    /// Creates a new builder-style object to manufacture [`TagResourceOutput`](crate::output::TagResourceOutput)
    pub fn builder() -> crate::output::tag_resource_output::Builder {
        crate::output::tag_resource_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PublishFunctionOutput {
    /// <p>Contains configuration information and metadata about a CloudFront function.</p>
    pub function_summary: std::option::Option<crate::model::FunctionSummary>,
}
impl std::fmt::Debug for PublishFunctionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PublishFunctionOutput");
        formatter.field("function_summary", &self.function_summary);
        formatter.finish()
    }
}
/// See [`PublishFunctionOutput`](crate::output::PublishFunctionOutput)
pub mod publish_function_output {
    /// A builder for [`PublishFunctionOutput`](crate::output::PublishFunctionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) function_summary: std::option::Option<crate::model::FunctionSummary>,
    }
    impl Builder {
        /// <p>Contains configuration information and metadata about a CloudFront function.</p>
        pub fn function_summary(mut self, input: crate::model::FunctionSummary) -> Self {
            self.function_summary = Some(input);
            self
        }
        /// <p>Contains configuration information and metadata about a CloudFront function.</p>
        pub fn set_function_summary(
            mut self,
            input: std::option::Option<crate::model::FunctionSummary>,
        ) -> Self {
            self.function_summary = input;
            self
        }
        /// Consumes the builder and constructs a [`PublishFunctionOutput`](crate::output::PublishFunctionOutput)
        pub fn build(self) -> crate::output::PublishFunctionOutput {
            crate::output::PublishFunctionOutput {
                function_summary: self.function_summary,
            }
        }
    }
}
impl PublishFunctionOutput {
    /// Creates a new builder-style object to manufacture [`PublishFunctionOutput`](crate::output::PublishFunctionOutput)
    pub fn builder() -> crate::output::publish_function_output::Builder {
        crate::output::publish_function_output::Builder::default()
    }
}

/// <p> The returned result of the corresponding request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTagsForResourceOutput {
    /// <p> A complex type that contains zero or more <code>Tag</code> elements.</p>
    pub tags: std::option::Option<crate::model::Tags>,
}
impl std::fmt::Debug for ListTagsForResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTagsForResourceOutput");
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
pub mod list_tags_for_resource_output {
    /// A builder for [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) tags: std::option::Option<crate::model::Tags>,
    }
    impl Builder {
        /// <p> A complex type that contains zero or more <code>Tag</code> elements.</p>
        pub fn tags(mut self, input: crate::model::Tags) -> Self {
            self.tags = Some(input);
            self
        }
        /// <p> A complex type that contains zero or more <code>Tag</code> elements.</p>
        pub fn set_tags(mut self, input: std::option::Option<crate::model::Tags>) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
        pub fn build(self) -> crate::output::ListTagsForResourceOutput {
            crate::output::ListTagsForResourceOutput { tags: self.tags }
        }
    }
}
impl ListTagsForResourceOutput {
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
    pub fn builder() -> crate::output::list_tags_for_resource_output::Builder {
        crate::output::list_tags_for_resource_output::Builder::default()
    }
}

/// <p>The returned result of the corresponding request. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListStreamingDistributionsOutput {
    /// <p>The <code>StreamingDistributionList</code> type. </p>
    pub streaming_distribution_list: std::option::Option<crate::model::StreamingDistributionList>,
}
impl std::fmt::Debug for ListStreamingDistributionsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListStreamingDistributionsOutput");
        formatter.field(
            "streaming_distribution_list",
            &self.streaming_distribution_list,
        );
        formatter.finish()
    }
}
/// See [`ListStreamingDistributionsOutput`](crate::output::ListStreamingDistributionsOutput)
pub mod list_streaming_distributions_output {
    /// A builder for [`ListStreamingDistributionsOutput`](crate::output::ListStreamingDistributionsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) streaming_distribution_list:
            std::option::Option<crate::model::StreamingDistributionList>,
    }
    impl Builder {
        /// <p>The <code>StreamingDistributionList</code> type. </p>
        pub fn streaming_distribution_list(
            mut self,
            input: crate::model::StreamingDistributionList,
        ) -> Self {
            self.streaming_distribution_list = Some(input);
            self
        }
        /// <p>The <code>StreamingDistributionList</code> type. </p>
        pub fn set_streaming_distribution_list(
            mut self,
            input: std::option::Option<crate::model::StreamingDistributionList>,
        ) -> Self {
            self.streaming_distribution_list = input;
            self
        }
        /// Consumes the builder and constructs a [`ListStreamingDistributionsOutput`](crate::output::ListStreamingDistributionsOutput)
        pub fn build(self) -> crate::output::ListStreamingDistributionsOutput {
            crate::output::ListStreamingDistributionsOutput {
                streaming_distribution_list: self.streaming_distribution_list,
            }
        }
    }
}
impl ListStreamingDistributionsOutput {
    /// Creates a new builder-style object to manufacture [`ListStreamingDistributionsOutput`](crate::output::ListStreamingDistributionsOutput)
    pub fn builder() -> crate::output::list_streaming_distributions_output::Builder {
        crate::output::list_streaming_distributions_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListResponseHeadersPoliciesOutput {
    /// <p>A list of response headers policies.</p>
    pub response_headers_policy_list: std::option::Option<crate::model::ResponseHeadersPolicyList>,
}
impl std::fmt::Debug for ListResponseHeadersPoliciesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListResponseHeadersPoliciesOutput");
        formatter.field(
            "response_headers_policy_list",
            &self.response_headers_policy_list,
        );
        formatter.finish()
    }
}
/// See [`ListResponseHeadersPoliciesOutput`](crate::output::ListResponseHeadersPoliciesOutput)
pub mod list_response_headers_policies_output {
    /// A builder for [`ListResponseHeadersPoliciesOutput`](crate::output::ListResponseHeadersPoliciesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) response_headers_policy_list:
            std::option::Option<crate::model::ResponseHeadersPolicyList>,
    }
    impl Builder {
        /// <p>A list of response headers policies.</p>
        pub fn response_headers_policy_list(
            mut self,
            input: crate::model::ResponseHeadersPolicyList,
        ) -> Self {
            self.response_headers_policy_list = Some(input);
            self
        }
        /// <p>A list of response headers policies.</p>
        pub fn set_response_headers_policy_list(
            mut self,
            input: std::option::Option<crate::model::ResponseHeadersPolicyList>,
        ) -> Self {
            self.response_headers_policy_list = input;
            self
        }
        /// Consumes the builder and constructs a [`ListResponseHeadersPoliciesOutput`](crate::output::ListResponseHeadersPoliciesOutput)
        pub fn build(self) -> crate::output::ListResponseHeadersPoliciesOutput {
            crate::output::ListResponseHeadersPoliciesOutput {
                response_headers_policy_list: self.response_headers_policy_list,
            }
        }
    }
}
impl ListResponseHeadersPoliciesOutput {
    /// Creates a new builder-style object to manufacture [`ListResponseHeadersPoliciesOutput`](crate::output::ListResponseHeadersPoliciesOutput)
    pub fn builder() -> crate::output::list_response_headers_policies_output::Builder {
        crate::output::list_response_headers_policies_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListRealtimeLogConfigsOutput {
    /// <p>A list of real-time log configurations.</p>
    pub realtime_log_configs: std::option::Option<crate::model::RealtimeLogConfigs>,
}
impl std::fmt::Debug for ListRealtimeLogConfigsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListRealtimeLogConfigsOutput");
        formatter.field("realtime_log_configs", &self.realtime_log_configs);
        formatter.finish()
    }
}
/// See [`ListRealtimeLogConfigsOutput`](crate::output::ListRealtimeLogConfigsOutput)
pub mod list_realtime_log_configs_output {
    /// A builder for [`ListRealtimeLogConfigsOutput`](crate::output::ListRealtimeLogConfigsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) realtime_log_configs: std::option::Option<crate::model::RealtimeLogConfigs>,
    }
    impl Builder {
        /// <p>A list of real-time log configurations.</p>
        pub fn realtime_log_configs(mut self, input: crate::model::RealtimeLogConfigs) -> Self {
            self.realtime_log_configs = Some(input);
            self
        }
        /// <p>A list of real-time log configurations.</p>
        pub fn set_realtime_log_configs(
            mut self,
            input: std::option::Option<crate::model::RealtimeLogConfigs>,
        ) -> Self {
            self.realtime_log_configs = input;
            self
        }
        /// Consumes the builder and constructs a [`ListRealtimeLogConfigsOutput`](crate::output::ListRealtimeLogConfigsOutput)
        pub fn build(self) -> crate::output::ListRealtimeLogConfigsOutput {
            crate::output::ListRealtimeLogConfigsOutput {
                realtime_log_configs: self.realtime_log_configs,
            }
        }
    }
}
impl ListRealtimeLogConfigsOutput {
    /// Creates a new builder-style object to manufacture [`ListRealtimeLogConfigsOutput`](crate::output::ListRealtimeLogConfigsOutput)
    pub fn builder() -> crate::output::list_realtime_log_configs_output::Builder {
        crate::output::list_realtime_log_configs_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListPublicKeysOutput {
    /// <p>Returns a list of all public keys that have been added to CloudFront for this account.</p>
    pub public_key_list: std::option::Option<crate::model::PublicKeyList>,
}
impl std::fmt::Debug for ListPublicKeysOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListPublicKeysOutput");
        formatter.field("public_key_list", &self.public_key_list);
        formatter.finish()
    }
}
/// See [`ListPublicKeysOutput`](crate::output::ListPublicKeysOutput)
pub mod list_public_keys_output {
    /// A builder for [`ListPublicKeysOutput`](crate::output::ListPublicKeysOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) public_key_list: std::option::Option<crate::model::PublicKeyList>,
    }
    impl Builder {
        /// <p>Returns a list of all public keys that have been added to CloudFront for this account.</p>
        pub fn public_key_list(mut self, input: crate::model::PublicKeyList) -> Self {
            self.public_key_list = Some(input);
            self
        }
        /// <p>Returns a list of all public keys that have been added to CloudFront for this account.</p>
        pub fn set_public_key_list(
            mut self,
            input: std::option::Option<crate::model::PublicKeyList>,
        ) -> Self {
            self.public_key_list = input;
            self
        }
        /// Consumes the builder and constructs a [`ListPublicKeysOutput`](crate::output::ListPublicKeysOutput)
        pub fn build(self) -> crate::output::ListPublicKeysOutput {
            crate::output::ListPublicKeysOutput {
                public_key_list: self.public_key_list,
            }
        }
    }
}
impl ListPublicKeysOutput {
    /// Creates a new builder-style object to manufacture [`ListPublicKeysOutput`](crate::output::ListPublicKeysOutput)
    pub fn builder() -> crate::output::list_public_keys_output::Builder {
        crate::output::list_public_keys_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListOriginRequestPoliciesOutput {
    /// <p>A list of origin request policies.</p>
    pub origin_request_policy_list: std::option::Option<crate::model::OriginRequestPolicyList>,
}
impl std::fmt::Debug for ListOriginRequestPoliciesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListOriginRequestPoliciesOutput");
        formatter.field(
            "origin_request_policy_list",
            &self.origin_request_policy_list,
        );
        formatter.finish()
    }
}
/// See [`ListOriginRequestPoliciesOutput`](crate::output::ListOriginRequestPoliciesOutput)
pub mod list_origin_request_policies_output {
    /// A builder for [`ListOriginRequestPoliciesOutput`](crate::output::ListOriginRequestPoliciesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) origin_request_policy_list:
            std::option::Option<crate::model::OriginRequestPolicyList>,
    }
    impl Builder {
        /// <p>A list of origin request policies.</p>
        pub fn origin_request_policy_list(
            mut self,
            input: crate::model::OriginRequestPolicyList,
        ) -> Self {
            self.origin_request_policy_list = Some(input);
            self
        }
        /// <p>A list of origin request policies.</p>
        pub fn set_origin_request_policy_list(
            mut self,
            input: std::option::Option<crate::model::OriginRequestPolicyList>,
        ) -> Self {
            self.origin_request_policy_list = input;
            self
        }
        /// Consumes the builder and constructs a [`ListOriginRequestPoliciesOutput`](crate::output::ListOriginRequestPoliciesOutput)
        pub fn build(self) -> crate::output::ListOriginRequestPoliciesOutput {
            crate::output::ListOriginRequestPoliciesOutput {
                origin_request_policy_list: self.origin_request_policy_list,
            }
        }
    }
}
impl ListOriginRequestPoliciesOutput {
    /// Creates a new builder-style object to manufacture [`ListOriginRequestPoliciesOutput`](crate::output::ListOriginRequestPoliciesOutput)
    pub fn builder() -> crate::output::list_origin_request_policies_output::Builder {
        crate::output::list_origin_request_policies_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListKeyGroupsOutput {
    /// <p>A list of key groups.</p>
    pub key_group_list: std::option::Option<crate::model::KeyGroupList>,
}
impl std::fmt::Debug for ListKeyGroupsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListKeyGroupsOutput");
        formatter.field("key_group_list", &self.key_group_list);
        formatter.finish()
    }
}
/// See [`ListKeyGroupsOutput`](crate::output::ListKeyGroupsOutput)
pub mod list_key_groups_output {
    /// A builder for [`ListKeyGroupsOutput`](crate::output::ListKeyGroupsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) key_group_list: std::option::Option<crate::model::KeyGroupList>,
    }
    impl Builder {
        /// <p>A list of key groups.</p>
        pub fn key_group_list(mut self, input: crate::model::KeyGroupList) -> Self {
            self.key_group_list = Some(input);
            self
        }
        /// <p>A list of key groups.</p>
        pub fn set_key_group_list(
            mut self,
            input: std::option::Option<crate::model::KeyGroupList>,
        ) -> Self {
            self.key_group_list = input;
            self
        }
        /// Consumes the builder and constructs a [`ListKeyGroupsOutput`](crate::output::ListKeyGroupsOutput)
        pub fn build(self) -> crate::output::ListKeyGroupsOutput {
            crate::output::ListKeyGroupsOutput {
                key_group_list: self.key_group_list,
            }
        }
    }
}
impl ListKeyGroupsOutput {
    /// Creates a new builder-style object to manufacture [`ListKeyGroupsOutput`](crate::output::ListKeyGroupsOutput)
    pub fn builder() -> crate::output::list_key_groups_output::Builder {
        crate::output::list_key_groups_output::Builder::default()
    }
}

/// <p>The returned result of the corresponding request. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListInvalidationsOutput {
    /// <p>Information about invalidation batches. </p>
    pub invalidation_list: std::option::Option<crate::model::InvalidationList>,
}
impl std::fmt::Debug for ListInvalidationsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListInvalidationsOutput");
        formatter.field("invalidation_list", &self.invalidation_list);
        formatter.finish()
    }
}
/// See [`ListInvalidationsOutput`](crate::output::ListInvalidationsOutput)
pub mod list_invalidations_output {
    /// A builder for [`ListInvalidationsOutput`](crate::output::ListInvalidationsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) invalidation_list: std::option::Option<crate::model::InvalidationList>,
    }
    impl Builder {
        /// <p>Information about invalidation batches. </p>
        pub fn invalidation_list(mut self, input: crate::model::InvalidationList) -> Self {
            self.invalidation_list = Some(input);
            self
        }
        /// <p>Information about invalidation batches. </p>
        pub fn set_invalidation_list(
            mut self,
            input: std::option::Option<crate::model::InvalidationList>,
        ) -> Self {
            self.invalidation_list = input;
            self
        }
        /// Consumes the builder and constructs a [`ListInvalidationsOutput`](crate::output::ListInvalidationsOutput)
        pub fn build(self) -> crate::output::ListInvalidationsOutput {
            crate::output::ListInvalidationsOutput {
                invalidation_list: self.invalidation_list,
            }
        }
    }
}
impl ListInvalidationsOutput {
    /// Creates a new builder-style object to manufacture [`ListInvalidationsOutput`](crate::output::ListInvalidationsOutput)
    pub fn builder() -> crate::output::list_invalidations_output::Builder {
        crate::output::list_invalidations_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListFunctionsOutput {
    /// <p>A list of CloudFront functions.</p>
    pub function_list: std::option::Option<crate::model::FunctionList>,
}
impl std::fmt::Debug for ListFunctionsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListFunctionsOutput");
        formatter.field("function_list", &self.function_list);
        formatter.finish()
    }
}
/// See [`ListFunctionsOutput`](crate::output::ListFunctionsOutput)
pub mod list_functions_output {
    /// A builder for [`ListFunctionsOutput`](crate::output::ListFunctionsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) function_list: std::option::Option<crate::model::FunctionList>,
    }
    impl Builder {
        /// <p>A list of CloudFront functions.</p>
        pub fn function_list(mut self, input: crate::model::FunctionList) -> Self {
            self.function_list = Some(input);
            self
        }
        /// <p>A list of CloudFront functions.</p>
        pub fn set_function_list(
            mut self,
            input: std::option::Option<crate::model::FunctionList>,
        ) -> Self {
            self.function_list = input;
            self
        }
        /// Consumes the builder and constructs a [`ListFunctionsOutput`](crate::output::ListFunctionsOutput)
        pub fn build(self) -> crate::output::ListFunctionsOutput {
            crate::output::ListFunctionsOutput {
                function_list: self.function_list,
            }
        }
    }
}
impl ListFunctionsOutput {
    /// Creates a new builder-style object to manufacture [`ListFunctionsOutput`](crate::output::ListFunctionsOutput)
    pub fn builder() -> crate::output::list_functions_output::Builder {
        crate::output::list_functions_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListFieldLevelEncryptionProfilesOutput {
    /// <p>Returns a list of the field-level encryption profiles that have been created in CloudFront for this account.</p>
    pub field_level_encryption_profile_list:
        std::option::Option<crate::model::FieldLevelEncryptionProfileList>,
}
impl std::fmt::Debug for ListFieldLevelEncryptionProfilesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListFieldLevelEncryptionProfilesOutput");
        formatter.field(
            "field_level_encryption_profile_list",
            &self.field_level_encryption_profile_list,
        );
        formatter.finish()
    }
}
/// See [`ListFieldLevelEncryptionProfilesOutput`](crate::output::ListFieldLevelEncryptionProfilesOutput)
pub mod list_field_level_encryption_profiles_output {
    /// A builder for [`ListFieldLevelEncryptionProfilesOutput`](crate::output::ListFieldLevelEncryptionProfilesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) field_level_encryption_profile_list:
            std::option::Option<crate::model::FieldLevelEncryptionProfileList>,
    }
    impl Builder {
        /// <p>Returns a list of the field-level encryption profiles that have been created in CloudFront for this account.</p>
        pub fn field_level_encryption_profile_list(
            mut self,
            input: crate::model::FieldLevelEncryptionProfileList,
        ) -> Self {
            self.field_level_encryption_profile_list = Some(input);
            self
        }
        /// <p>Returns a list of the field-level encryption profiles that have been created in CloudFront for this account.</p>
        pub fn set_field_level_encryption_profile_list(
            mut self,
            input: std::option::Option<crate::model::FieldLevelEncryptionProfileList>,
        ) -> Self {
            self.field_level_encryption_profile_list = input;
            self
        }
        /// Consumes the builder and constructs a [`ListFieldLevelEncryptionProfilesOutput`](crate::output::ListFieldLevelEncryptionProfilesOutput)
        pub fn build(self) -> crate::output::ListFieldLevelEncryptionProfilesOutput {
            crate::output::ListFieldLevelEncryptionProfilesOutput {
                field_level_encryption_profile_list: self.field_level_encryption_profile_list,
            }
        }
    }
}
impl ListFieldLevelEncryptionProfilesOutput {
    /// Creates a new builder-style object to manufacture [`ListFieldLevelEncryptionProfilesOutput`](crate::output::ListFieldLevelEncryptionProfilesOutput)
    pub fn builder() -> crate::output::list_field_level_encryption_profiles_output::Builder {
        crate::output::list_field_level_encryption_profiles_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListFieldLevelEncryptionConfigsOutput {
    /// <p>Returns a list of all field-level encryption configurations that have been created in CloudFront for this account.</p>
    pub field_level_encryption_list: std::option::Option<crate::model::FieldLevelEncryptionList>,
}
impl std::fmt::Debug for ListFieldLevelEncryptionConfigsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListFieldLevelEncryptionConfigsOutput");
        formatter.field(
            "field_level_encryption_list",
            &self.field_level_encryption_list,
        );
        formatter.finish()
    }
}
/// See [`ListFieldLevelEncryptionConfigsOutput`](crate::output::ListFieldLevelEncryptionConfigsOutput)
pub mod list_field_level_encryption_configs_output {
    /// A builder for [`ListFieldLevelEncryptionConfigsOutput`](crate::output::ListFieldLevelEncryptionConfigsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) field_level_encryption_list:
            std::option::Option<crate::model::FieldLevelEncryptionList>,
    }
    impl Builder {
        /// <p>Returns a list of all field-level encryption configurations that have been created in CloudFront for this account.</p>
        pub fn field_level_encryption_list(
            mut self,
            input: crate::model::FieldLevelEncryptionList,
        ) -> Self {
            self.field_level_encryption_list = Some(input);
            self
        }
        /// <p>Returns a list of all field-level encryption configurations that have been created in CloudFront for this account.</p>
        pub fn set_field_level_encryption_list(
            mut self,
            input: std::option::Option<crate::model::FieldLevelEncryptionList>,
        ) -> Self {
            self.field_level_encryption_list = input;
            self
        }
        /// Consumes the builder and constructs a [`ListFieldLevelEncryptionConfigsOutput`](crate::output::ListFieldLevelEncryptionConfigsOutput)
        pub fn build(self) -> crate::output::ListFieldLevelEncryptionConfigsOutput {
            crate::output::ListFieldLevelEncryptionConfigsOutput {
                field_level_encryption_list: self.field_level_encryption_list,
            }
        }
    }
}
impl ListFieldLevelEncryptionConfigsOutput {
    /// Creates a new builder-style object to manufacture [`ListFieldLevelEncryptionConfigsOutput`](crate::output::ListFieldLevelEncryptionConfigsOutput)
    pub fn builder() -> crate::output::list_field_level_encryption_configs_output::Builder {
        crate::output::list_field_level_encryption_configs_output::Builder::default()
    }
}

/// <p>The response to a request to list the distributions that are associated with a
/// specified WAF web ACL.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListDistributionsByWebAclIdOutput {
    /// <p>The <code>DistributionList</code> type. </p>
    pub distribution_list: std::option::Option<crate::model::DistributionList>,
}
impl std::fmt::Debug for ListDistributionsByWebAclIdOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListDistributionsByWebAclIdOutput");
        formatter.field("distribution_list", &self.distribution_list);
        formatter.finish()
    }
}
/// See [`ListDistributionsByWebAclIdOutput`](crate::output::ListDistributionsByWebAclIdOutput)
pub mod list_distributions_by_web_acl_id_output {
    /// A builder for [`ListDistributionsByWebAclIdOutput`](crate::output::ListDistributionsByWebAclIdOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) distribution_list: std::option::Option<crate::model::DistributionList>,
    }
    impl Builder {
        /// <p>The <code>DistributionList</code> type. </p>
        pub fn distribution_list(mut self, input: crate::model::DistributionList) -> Self {
            self.distribution_list = Some(input);
            self
        }
        /// <p>The <code>DistributionList</code> type. </p>
        pub fn set_distribution_list(
            mut self,
            input: std::option::Option<crate::model::DistributionList>,
        ) -> Self {
            self.distribution_list = input;
            self
        }
        /// Consumes the builder and constructs a [`ListDistributionsByWebAclIdOutput`](crate::output::ListDistributionsByWebAclIdOutput)
        pub fn build(self) -> crate::output::ListDistributionsByWebAclIdOutput {
            crate::output::ListDistributionsByWebAclIdOutput {
                distribution_list: self.distribution_list,
            }
        }
    }
}
impl ListDistributionsByWebAclIdOutput {
    /// Creates a new builder-style object to manufacture [`ListDistributionsByWebAclIdOutput`](crate::output::ListDistributionsByWebAclIdOutput)
    pub fn builder() -> crate::output::list_distributions_by_web_acl_id_output::Builder {
        crate::output::list_distributions_by_web_acl_id_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListDistributionsByResponseHeadersPolicyIdOutput {
    /// <p>A list of distribution IDs.</p>
    pub distribution_id_list: std::option::Option<crate::model::DistributionIdList>,
}
impl std::fmt::Debug for ListDistributionsByResponseHeadersPolicyIdOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListDistributionsByResponseHeadersPolicyIdOutput");
        formatter.field("distribution_id_list", &self.distribution_id_list);
        formatter.finish()
    }
}
/// See [`ListDistributionsByResponseHeadersPolicyIdOutput`](crate::output::ListDistributionsByResponseHeadersPolicyIdOutput)
pub mod list_distributions_by_response_headers_policy_id_output {
    /// A builder for [`ListDistributionsByResponseHeadersPolicyIdOutput`](crate::output::ListDistributionsByResponseHeadersPolicyIdOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) distribution_id_list: std::option::Option<crate::model::DistributionIdList>,
    }
    impl Builder {
        /// <p>A list of distribution IDs.</p>
        pub fn distribution_id_list(mut self, input: crate::model::DistributionIdList) -> Self {
            self.distribution_id_list = Some(input);
            self
        }
        /// <p>A list of distribution IDs.</p>
        pub fn set_distribution_id_list(
            mut self,
            input: std::option::Option<crate::model::DistributionIdList>,
        ) -> Self {
            self.distribution_id_list = input;
            self
        }
        /// Consumes the builder and constructs a [`ListDistributionsByResponseHeadersPolicyIdOutput`](crate::output::ListDistributionsByResponseHeadersPolicyIdOutput)
        pub fn build(self) -> crate::output::ListDistributionsByResponseHeadersPolicyIdOutput {
            crate::output::ListDistributionsByResponseHeadersPolicyIdOutput {
                distribution_id_list: self.distribution_id_list,
            }
        }
    }
}
impl ListDistributionsByResponseHeadersPolicyIdOutput {
    /// Creates a new builder-style object to manufacture [`ListDistributionsByResponseHeadersPolicyIdOutput`](crate::output::ListDistributionsByResponseHeadersPolicyIdOutput)
    pub fn builder(
    ) -> crate::output::list_distributions_by_response_headers_policy_id_output::Builder {
        crate::output::list_distributions_by_response_headers_policy_id_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListDistributionsByRealtimeLogConfigOutput {
    /// <p>A distribution list.</p>
    pub distribution_list: std::option::Option<crate::model::DistributionList>,
}
impl std::fmt::Debug for ListDistributionsByRealtimeLogConfigOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListDistributionsByRealtimeLogConfigOutput");
        formatter.field("distribution_list", &self.distribution_list);
        formatter.finish()
    }
}
/// See [`ListDistributionsByRealtimeLogConfigOutput`](crate::output::ListDistributionsByRealtimeLogConfigOutput)
pub mod list_distributions_by_realtime_log_config_output {
    /// A builder for [`ListDistributionsByRealtimeLogConfigOutput`](crate::output::ListDistributionsByRealtimeLogConfigOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) distribution_list: std::option::Option<crate::model::DistributionList>,
    }
    impl Builder {
        /// <p>A distribution list.</p>
        pub fn distribution_list(mut self, input: crate::model::DistributionList) -> Self {
            self.distribution_list = Some(input);
            self
        }
        /// <p>A distribution list.</p>
        pub fn set_distribution_list(
            mut self,
            input: std::option::Option<crate::model::DistributionList>,
        ) -> Self {
            self.distribution_list = input;
            self
        }
        /// Consumes the builder and constructs a [`ListDistributionsByRealtimeLogConfigOutput`](crate::output::ListDistributionsByRealtimeLogConfigOutput)
        pub fn build(self) -> crate::output::ListDistributionsByRealtimeLogConfigOutput {
            crate::output::ListDistributionsByRealtimeLogConfigOutput {
                distribution_list: self.distribution_list,
            }
        }
    }
}
impl ListDistributionsByRealtimeLogConfigOutput {
    /// Creates a new builder-style object to manufacture [`ListDistributionsByRealtimeLogConfigOutput`](crate::output::ListDistributionsByRealtimeLogConfigOutput)
    pub fn builder() -> crate::output::list_distributions_by_realtime_log_config_output::Builder {
        crate::output::list_distributions_by_realtime_log_config_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListDistributionsByOriginRequestPolicyIdOutput {
    /// <p>A list of distribution IDs.</p>
    pub distribution_id_list: std::option::Option<crate::model::DistributionIdList>,
}
impl std::fmt::Debug for ListDistributionsByOriginRequestPolicyIdOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListDistributionsByOriginRequestPolicyIdOutput");
        formatter.field("distribution_id_list", &self.distribution_id_list);
        formatter.finish()
    }
}
/// See [`ListDistributionsByOriginRequestPolicyIdOutput`](crate::output::ListDistributionsByOriginRequestPolicyIdOutput)
pub mod list_distributions_by_origin_request_policy_id_output {
    /// A builder for [`ListDistributionsByOriginRequestPolicyIdOutput`](crate::output::ListDistributionsByOriginRequestPolicyIdOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) distribution_id_list: std::option::Option<crate::model::DistributionIdList>,
    }
    impl Builder {
        /// <p>A list of distribution IDs.</p>
        pub fn distribution_id_list(mut self, input: crate::model::DistributionIdList) -> Self {
            self.distribution_id_list = Some(input);
            self
        }
        /// <p>A list of distribution IDs.</p>
        pub fn set_distribution_id_list(
            mut self,
            input: std::option::Option<crate::model::DistributionIdList>,
        ) -> Self {
            self.distribution_id_list = input;
            self
        }
        /// Consumes the builder and constructs a [`ListDistributionsByOriginRequestPolicyIdOutput`](crate::output::ListDistributionsByOriginRequestPolicyIdOutput)
        pub fn build(self) -> crate::output::ListDistributionsByOriginRequestPolicyIdOutput {
            crate::output::ListDistributionsByOriginRequestPolicyIdOutput {
                distribution_id_list: self.distribution_id_list,
            }
        }
    }
}
impl ListDistributionsByOriginRequestPolicyIdOutput {
    /// Creates a new builder-style object to manufacture [`ListDistributionsByOriginRequestPolicyIdOutput`](crate::output::ListDistributionsByOriginRequestPolicyIdOutput)
    pub fn builder() -> crate::output::list_distributions_by_origin_request_policy_id_output::Builder
    {
        crate::output::list_distributions_by_origin_request_policy_id_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListDistributionsByKeyGroupOutput {
    /// <p>A list of distribution IDs.</p>
    pub distribution_id_list: std::option::Option<crate::model::DistributionIdList>,
}
impl std::fmt::Debug for ListDistributionsByKeyGroupOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListDistributionsByKeyGroupOutput");
        formatter.field("distribution_id_list", &self.distribution_id_list);
        formatter.finish()
    }
}
/// See [`ListDistributionsByKeyGroupOutput`](crate::output::ListDistributionsByKeyGroupOutput)
pub mod list_distributions_by_key_group_output {
    /// A builder for [`ListDistributionsByKeyGroupOutput`](crate::output::ListDistributionsByKeyGroupOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) distribution_id_list: std::option::Option<crate::model::DistributionIdList>,
    }
    impl Builder {
        /// <p>A list of distribution IDs.</p>
        pub fn distribution_id_list(mut self, input: crate::model::DistributionIdList) -> Self {
            self.distribution_id_list = Some(input);
            self
        }
        /// <p>A list of distribution IDs.</p>
        pub fn set_distribution_id_list(
            mut self,
            input: std::option::Option<crate::model::DistributionIdList>,
        ) -> Self {
            self.distribution_id_list = input;
            self
        }
        /// Consumes the builder and constructs a [`ListDistributionsByKeyGroupOutput`](crate::output::ListDistributionsByKeyGroupOutput)
        pub fn build(self) -> crate::output::ListDistributionsByKeyGroupOutput {
            crate::output::ListDistributionsByKeyGroupOutput {
                distribution_id_list: self.distribution_id_list,
            }
        }
    }
}
impl ListDistributionsByKeyGroupOutput {
    /// Creates a new builder-style object to manufacture [`ListDistributionsByKeyGroupOutput`](crate::output::ListDistributionsByKeyGroupOutput)
    pub fn builder() -> crate::output::list_distributions_by_key_group_output::Builder {
        crate::output::list_distributions_by_key_group_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListDistributionsByCachePolicyIdOutput {
    /// <p>A list of distribution IDs.</p>
    pub distribution_id_list: std::option::Option<crate::model::DistributionIdList>,
}
impl std::fmt::Debug for ListDistributionsByCachePolicyIdOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListDistributionsByCachePolicyIdOutput");
        formatter.field("distribution_id_list", &self.distribution_id_list);
        formatter.finish()
    }
}
/// See [`ListDistributionsByCachePolicyIdOutput`](crate::output::ListDistributionsByCachePolicyIdOutput)
pub mod list_distributions_by_cache_policy_id_output {
    /// A builder for [`ListDistributionsByCachePolicyIdOutput`](crate::output::ListDistributionsByCachePolicyIdOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) distribution_id_list: std::option::Option<crate::model::DistributionIdList>,
    }
    impl Builder {
        /// <p>A list of distribution IDs.</p>
        pub fn distribution_id_list(mut self, input: crate::model::DistributionIdList) -> Self {
            self.distribution_id_list = Some(input);
            self
        }
        /// <p>A list of distribution IDs.</p>
        pub fn set_distribution_id_list(
            mut self,
            input: std::option::Option<crate::model::DistributionIdList>,
        ) -> Self {
            self.distribution_id_list = input;
            self
        }
        /// Consumes the builder and constructs a [`ListDistributionsByCachePolicyIdOutput`](crate::output::ListDistributionsByCachePolicyIdOutput)
        pub fn build(self) -> crate::output::ListDistributionsByCachePolicyIdOutput {
            crate::output::ListDistributionsByCachePolicyIdOutput {
                distribution_id_list: self.distribution_id_list,
            }
        }
    }
}
impl ListDistributionsByCachePolicyIdOutput {
    /// Creates a new builder-style object to manufacture [`ListDistributionsByCachePolicyIdOutput`](crate::output::ListDistributionsByCachePolicyIdOutput)
    pub fn builder() -> crate::output::list_distributions_by_cache_policy_id_output::Builder {
        crate::output::list_distributions_by_cache_policy_id_output::Builder::default()
    }
}

/// <p>The returned result of the corresponding request. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListDistributionsOutput {
    /// <p>The <code>DistributionList</code> type. </p>
    pub distribution_list: std::option::Option<crate::model::DistributionList>,
}
impl std::fmt::Debug for ListDistributionsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListDistributionsOutput");
        formatter.field("distribution_list", &self.distribution_list);
        formatter.finish()
    }
}
/// See [`ListDistributionsOutput`](crate::output::ListDistributionsOutput)
pub mod list_distributions_output {
    /// A builder for [`ListDistributionsOutput`](crate::output::ListDistributionsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) distribution_list: std::option::Option<crate::model::DistributionList>,
    }
    impl Builder {
        /// <p>The <code>DistributionList</code> type. </p>
        pub fn distribution_list(mut self, input: crate::model::DistributionList) -> Self {
            self.distribution_list = Some(input);
            self
        }
        /// <p>The <code>DistributionList</code> type. </p>
        pub fn set_distribution_list(
            mut self,
            input: std::option::Option<crate::model::DistributionList>,
        ) -> Self {
            self.distribution_list = input;
            self
        }
        /// Consumes the builder and constructs a [`ListDistributionsOutput`](crate::output::ListDistributionsOutput)
        pub fn build(self) -> crate::output::ListDistributionsOutput {
            crate::output::ListDistributionsOutput {
                distribution_list: self.distribution_list,
            }
        }
    }
}
impl ListDistributionsOutput {
    /// Creates a new builder-style object to manufacture [`ListDistributionsOutput`](crate::output::ListDistributionsOutput)
    pub fn builder() -> crate::output::list_distributions_output::Builder {
        crate::output::list_distributions_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListConflictingAliasesOutput {
    /// <p>A list of conflicting aliases.</p>
    pub conflicting_aliases_list: std::option::Option<crate::model::ConflictingAliasesList>,
}
impl std::fmt::Debug for ListConflictingAliasesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListConflictingAliasesOutput");
        formatter.field("conflicting_aliases_list", &self.conflicting_aliases_list);
        formatter.finish()
    }
}
/// See [`ListConflictingAliasesOutput`](crate::output::ListConflictingAliasesOutput)
pub mod list_conflicting_aliases_output {
    /// A builder for [`ListConflictingAliasesOutput`](crate::output::ListConflictingAliasesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) conflicting_aliases_list:
            std::option::Option<crate::model::ConflictingAliasesList>,
    }
    impl Builder {
        /// <p>A list of conflicting aliases.</p>
        pub fn conflicting_aliases_list(
            mut self,
            input: crate::model::ConflictingAliasesList,
        ) -> Self {
            self.conflicting_aliases_list = Some(input);
            self
        }
        /// <p>A list of conflicting aliases.</p>
        pub fn set_conflicting_aliases_list(
            mut self,
            input: std::option::Option<crate::model::ConflictingAliasesList>,
        ) -> Self {
            self.conflicting_aliases_list = input;
            self
        }
        /// Consumes the builder and constructs a [`ListConflictingAliasesOutput`](crate::output::ListConflictingAliasesOutput)
        pub fn build(self) -> crate::output::ListConflictingAliasesOutput {
            crate::output::ListConflictingAliasesOutput {
                conflicting_aliases_list: self.conflicting_aliases_list,
            }
        }
    }
}
impl ListConflictingAliasesOutput {
    /// Creates a new builder-style object to manufacture [`ListConflictingAliasesOutput`](crate::output::ListConflictingAliasesOutput)
    pub fn builder() -> crate::output::list_conflicting_aliases_output::Builder {
        crate::output::list_conflicting_aliases_output::Builder::default()
    }
}

/// <p>The returned result of the corresponding request. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListCloudFrontOriginAccessIdentitiesOutput {
    /// <p>The <code>CloudFrontOriginAccessIdentityList</code> type. </p>
    pub cloud_front_origin_access_identity_list:
        std::option::Option<crate::model::CloudFrontOriginAccessIdentityList>,
}
impl std::fmt::Debug for ListCloudFrontOriginAccessIdentitiesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListCloudFrontOriginAccessIdentitiesOutput");
        formatter.field(
            "cloud_front_origin_access_identity_list",
            &self.cloud_front_origin_access_identity_list,
        );
        formatter.finish()
    }
}
/// See [`ListCloudFrontOriginAccessIdentitiesOutput`](crate::output::ListCloudFrontOriginAccessIdentitiesOutput)
pub mod list_cloud_front_origin_access_identities_output {
    /// A builder for [`ListCloudFrontOriginAccessIdentitiesOutput`](crate::output::ListCloudFrontOriginAccessIdentitiesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cloud_front_origin_access_identity_list:
            std::option::Option<crate::model::CloudFrontOriginAccessIdentityList>,
    }
    impl Builder {
        /// <p>The <code>CloudFrontOriginAccessIdentityList</code> type. </p>
        pub fn cloud_front_origin_access_identity_list(
            mut self,
            input: crate::model::CloudFrontOriginAccessIdentityList,
        ) -> Self {
            self.cloud_front_origin_access_identity_list = Some(input);
            self
        }
        /// <p>The <code>CloudFrontOriginAccessIdentityList</code> type. </p>
        pub fn set_cloud_front_origin_access_identity_list(
            mut self,
            input: std::option::Option<crate::model::CloudFrontOriginAccessIdentityList>,
        ) -> Self {
            self.cloud_front_origin_access_identity_list = input;
            self
        }
        /// Consumes the builder and constructs a [`ListCloudFrontOriginAccessIdentitiesOutput`](crate::output::ListCloudFrontOriginAccessIdentitiesOutput)
        pub fn build(self) -> crate::output::ListCloudFrontOriginAccessIdentitiesOutput {
            crate::output::ListCloudFrontOriginAccessIdentitiesOutput {
                cloud_front_origin_access_identity_list: self
                    .cloud_front_origin_access_identity_list,
            }
        }
    }
}
impl ListCloudFrontOriginAccessIdentitiesOutput {
    /// Creates a new builder-style object to manufacture [`ListCloudFrontOriginAccessIdentitiesOutput`](crate::output::ListCloudFrontOriginAccessIdentitiesOutput)
    pub fn builder() -> crate::output::list_cloud_front_origin_access_identities_output::Builder {
        crate::output::list_cloud_front_origin_access_identities_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListCachePoliciesOutput {
    /// <p>A list of cache policies.</p>
    pub cache_policy_list: std::option::Option<crate::model::CachePolicyList>,
}
impl std::fmt::Debug for ListCachePoliciesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListCachePoliciesOutput");
        formatter.field("cache_policy_list", &self.cache_policy_list);
        formatter.finish()
    }
}
/// See [`ListCachePoliciesOutput`](crate::output::ListCachePoliciesOutput)
pub mod list_cache_policies_output {
    /// A builder for [`ListCachePoliciesOutput`](crate::output::ListCachePoliciesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cache_policy_list: std::option::Option<crate::model::CachePolicyList>,
    }
    impl Builder {
        /// <p>A list of cache policies.</p>
        pub fn cache_policy_list(mut self, input: crate::model::CachePolicyList) -> Self {
            self.cache_policy_list = Some(input);
            self
        }
        /// <p>A list of cache policies.</p>
        pub fn set_cache_policy_list(
            mut self,
            input: std::option::Option<crate::model::CachePolicyList>,
        ) -> Self {
            self.cache_policy_list = input;
            self
        }
        /// Consumes the builder and constructs a [`ListCachePoliciesOutput`](crate::output::ListCachePoliciesOutput)
        pub fn build(self) -> crate::output::ListCachePoliciesOutput {
            crate::output::ListCachePoliciesOutput {
                cache_policy_list: self.cache_policy_list,
            }
        }
    }
}
impl ListCachePoliciesOutput {
    /// Creates a new builder-style object to manufacture [`ListCachePoliciesOutput`](crate::output::ListCachePoliciesOutput)
    pub fn builder() -> crate::output::list_cache_policies_output::Builder {
        crate::output::list_cache_policies_output::Builder::default()
    }
}

/// <p>The returned result of the corresponding request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetStreamingDistributionConfigOutput {
    /// <p>The streaming distribution's configuration information.</p>
    pub streaming_distribution_config:
        std::option::Option<crate::model::StreamingDistributionConfig>,
    /// <p>The current version of the configuration. For example: <code>E2QWRUHAPOMQZL</code>.
    /// </p>
    pub e_tag: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for GetStreamingDistributionConfigOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetStreamingDistributionConfigOutput");
        formatter.field(
            "streaming_distribution_config",
            &self.streaming_distribution_config,
        );
        formatter.field("e_tag", &self.e_tag);
        formatter.finish()
    }
}
/// See [`GetStreamingDistributionConfigOutput`](crate::output::GetStreamingDistributionConfigOutput)
pub mod get_streaming_distribution_config_output {
    /// A builder for [`GetStreamingDistributionConfigOutput`](crate::output::GetStreamingDistributionConfigOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) streaming_distribution_config:
            std::option::Option<crate::model::StreamingDistributionConfig>,
        pub(crate) e_tag: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The streaming distribution's configuration information.</p>
        pub fn streaming_distribution_config(
            mut self,
            input: crate::model::StreamingDistributionConfig,
        ) -> Self {
            self.streaming_distribution_config = Some(input);
            self
        }
        /// <p>The streaming distribution's configuration information.</p>
        pub fn set_streaming_distribution_config(
            mut self,
            input: std::option::Option<crate::model::StreamingDistributionConfig>,
        ) -> Self {
            self.streaming_distribution_config = input;
            self
        }
        /// <p>The current version of the configuration. For example: <code>E2QWRUHAPOMQZL</code>.
        /// </p>
        pub fn e_tag(mut self, input: impl Into<std::string::String>) -> Self {
            self.e_tag = Some(input.into());
            self
        }
        /// <p>The current version of the configuration. For example: <code>E2QWRUHAPOMQZL</code>.
        /// </p>
        pub fn set_e_tag(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.e_tag = input;
            self
        }
        /// Consumes the builder and constructs a [`GetStreamingDistributionConfigOutput`](crate::output::GetStreamingDistributionConfigOutput)
        pub fn build(self) -> crate::output::GetStreamingDistributionConfigOutput {
            crate::output::GetStreamingDistributionConfigOutput {
                streaming_distribution_config: self.streaming_distribution_config,
                e_tag: self.e_tag,
            }
        }
    }
}
impl GetStreamingDistributionConfigOutput {
    /// Creates a new builder-style object to manufacture [`GetStreamingDistributionConfigOutput`](crate::output::GetStreamingDistributionConfigOutput)
    pub fn builder() -> crate::output::get_streaming_distribution_config_output::Builder {
        crate::output::get_streaming_distribution_config_output::Builder::default()
    }
}

/// <p>The returned result of the corresponding request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetStreamingDistributionOutput {
    /// <p>The streaming distribution's information.</p>
    pub streaming_distribution: std::option::Option<crate::model::StreamingDistribution>,
    /// <p>The current version of the streaming distribution's information. For example:
    /// <code>E2QWRUHAPOMQZL</code>.</p>
    pub e_tag: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for GetStreamingDistributionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetStreamingDistributionOutput");
        formatter.field("streaming_distribution", &self.streaming_distribution);
        formatter.field("e_tag", &self.e_tag);
        formatter.finish()
    }
}
/// See [`GetStreamingDistributionOutput`](crate::output::GetStreamingDistributionOutput)
pub mod get_streaming_distribution_output {
    /// A builder for [`GetStreamingDistributionOutput`](crate::output::GetStreamingDistributionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) streaming_distribution: std::option::Option<crate::model::StreamingDistribution>,
        pub(crate) e_tag: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The streaming distribution's information.</p>
        pub fn streaming_distribution(
            mut self,
            input: crate::model::StreamingDistribution,
        ) -> Self {
            self.streaming_distribution = Some(input);
            self
        }
        /// <p>The streaming distribution's information.</p>
        pub fn set_streaming_distribution(
            mut self,
            input: std::option::Option<crate::model::StreamingDistribution>,
        ) -> Self {
            self.streaming_distribution = input;
            self
        }
        /// <p>The current version of the streaming distribution's information. For example:
        /// <code>E2QWRUHAPOMQZL</code>.</p>
        pub fn e_tag(mut self, input: impl Into<std::string::String>) -> Self {
            self.e_tag = Some(input.into());
            self
        }
        /// <p>The current version of the streaming distribution's information. For example:
        /// <code>E2QWRUHAPOMQZL</code>.</p>
        pub fn set_e_tag(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.e_tag = input;
            self
        }
        /// Consumes the builder and constructs a [`GetStreamingDistributionOutput`](crate::output::GetStreamingDistributionOutput)
        pub fn build(self) -> crate::output::GetStreamingDistributionOutput {
            crate::output::GetStreamingDistributionOutput {
                streaming_distribution: self.streaming_distribution,
                e_tag: self.e_tag,
            }
        }
    }
}
impl GetStreamingDistributionOutput {
    /// Creates a new builder-style object to manufacture [`GetStreamingDistributionOutput`](crate::output::GetStreamingDistributionOutput)
    pub fn builder() -> crate::output::get_streaming_distribution_output::Builder {
        crate::output::get_streaming_distribution_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetResponseHeadersPolicyConfigOutput {
    /// <p>Contains a response headers policy.</p>
    pub response_headers_policy_config:
        std::option::Option<crate::model::ResponseHeadersPolicyConfig>,
    /// <p>The version identifier for the current version of the response headers policy.</p>
    pub e_tag: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for GetResponseHeadersPolicyConfigOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetResponseHeadersPolicyConfigOutput");
        formatter.field(
            "response_headers_policy_config",
            &self.response_headers_policy_config,
        );
        formatter.field("e_tag", &self.e_tag);
        formatter.finish()
    }
}
/// See [`GetResponseHeadersPolicyConfigOutput`](crate::output::GetResponseHeadersPolicyConfigOutput)
pub mod get_response_headers_policy_config_output {
    /// A builder for [`GetResponseHeadersPolicyConfigOutput`](crate::output::GetResponseHeadersPolicyConfigOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) response_headers_policy_config:
            std::option::Option<crate::model::ResponseHeadersPolicyConfig>,
        pub(crate) e_tag: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Contains a response headers policy.</p>
        pub fn response_headers_policy_config(
            mut self,
            input: crate::model::ResponseHeadersPolicyConfig,
        ) -> Self {
            self.response_headers_policy_config = Some(input);
            self
        }
        /// <p>Contains a response headers policy.</p>
        pub fn set_response_headers_policy_config(
            mut self,
            input: std::option::Option<crate::model::ResponseHeadersPolicyConfig>,
        ) -> Self {
            self.response_headers_policy_config = input;
            self
        }
        /// <p>The version identifier for the current version of the response headers policy.</p>
        pub fn e_tag(mut self, input: impl Into<std::string::String>) -> Self {
            self.e_tag = Some(input.into());
            self
        }
        /// <p>The version identifier for the current version of the response headers policy.</p>
        pub fn set_e_tag(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.e_tag = input;
            self
        }
        /// Consumes the builder and constructs a [`GetResponseHeadersPolicyConfigOutput`](crate::output::GetResponseHeadersPolicyConfigOutput)
        pub fn build(self) -> crate::output::GetResponseHeadersPolicyConfigOutput {
            crate::output::GetResponseHeadersPolicyConfigOutput {
                response_headers_policy_config: self.response_headers_policy_config,
                e_tag: self.e_tag,
            }
        }
    }
}
impl GetResponseHeadersPolicyConfigOutput {
    /// Creates a new builder-style object to manufacture [`GetResponseHeadersPolicyConfigOutput`](crate::output::GetResponseHeadersPolicyConfigOutput)
    pub fn builder() -> crate::output::get_response_headers_policy_config_output::Builder {
        crate::output::get_response_headers_policy_config_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetResponseHeadersPolicyOutput {
    /// <p>Contains a response headers policy.</p>
    pub response_headers_policy: std::option::Option<crate::model::ResponseHeadersPolicy>,
    /// <p>The version identifier for the current version of the response headers policy.</p>
    pub e_tag: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for GetResponseHeadersPolicyOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetResponseHeadersPolicyOutput");
        formatter.field("response_headers_policy", &self.response_headers_policy);
        formatter.field("e_tag", &self.e_tag);
        formatter.finish()
    }
}
/// See [`GetResponseHeadersPolicyOutput`](crate::output::GetResponseHeadersPolicyOutput)
pub mod get_response_headers_policy_output {
    /// A builder for [`GetResponseHeadersPolicyOutput`](crate::output::GetResponseHeadersPolicyOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) response_headers_policy:
            std::option::Option<crate::model::ResponseHeadersPolicy>,
        pub(crate) e_tag: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Contains a response headers policy.</p>
        pub fn response_headers_policy(
            mut self,
            input: crate::model::ResponseHeadersPolicy,
        ) -> Self {
            self.response_headers_policy = Some(input);
            self
        }
        /// <p>Contains a response headers policy.</p>
        pub fn set_response_headers_policy(
            mut self,
            input: std::option::Option<crate::model::ResponseHeadersPolicy>,
        ) -> Self {
            self.response_headers_policy = input;
            self
        }
        /// <p>The version identifier for the current version of the response headers policy.</p>
        pub fn e_tag(mut self, input: impl Into<std::string::String>) -> Self {
            self.e_tag = Some(input.into());
            self
        }
        /// <p>The version identifier for the current version of the response headers policy.</p>
        pub fn set_e_tag(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.e_tag = input;
            self
        }
        /// Consumes the builder and constructs a [`GetResponseHeadersPolicyOutput`](crate::output::GetResponseHeadersPolicyOutput)
        pub fn build(self) -> crate::output::GetResponseHeadersPolicyOutput {
            crate::output::GetResponseHeadersPolicyOutput {
                response_headers_policy: self.response_headers_policy,
                e_tag: self.e_tag,
            }
        }
    }
}
impl GetResponseHeadersPolicyOutput {
    /// Creates a new builder-style object to manufacture [`GetResponseHeadersPolicyOutput`](crate::output::GetResponseHeadersPolicyOutput)
    pub fn builder() -> crate::output::get_response_headers_policy_output::Builder {
        crate::output::get_response_headers_policy_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetRealtimeLogConfigOutput {
    /// <p>A real-time log configuration.</p>
    pub realtime_log_config: std::option::Option<crate::model::RealtimeLogConfig>,
}
impl std::fmt::Debug for GetRealtimeLogConfigOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetRealtimeLogConfigOutput");
        formatter.field("realtime_log_config", &self.realtime_log_config);
        formatter.finish()
    }
}
/// See [`GetRealtimeLogConfigOutput`](crate::output::GetRealtimeLogConfigOutput)
pub mod get_realtime_log_config_output {
    /// A builder for [`GetRealtimeLogConfigOutput`](crate::output::GetRealtimeLogConfigOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) realtime_log_config: std::option::Option<crate::model::RealtimeLogConfig>,
    }
    impl Builder {
        /// <p>A real-time log configuration.</p>
        pub fn realtime_log_config(mut self, input: crate::model::RealtimeLogConfig) -> Self {
            self.realtime_log_config = Some(input);
            self
        }
        /// <p>A real-time log configuration.</p>
        pub fn set_realtime_log_config(
            mut self,
            input: std::option::Option<crate::model::RealtimeLogConfig>,
        ) -> Self {
            self.realtime_log_config = input;
            self
        }
        /// Consumes the builder and constructs a [`GetRealtimeLogConfigOutput`](crate::output::GetRealtimeLogConfigOutput)
        pub fn build(self) -> crate::output::GetRealtimeLogConfigOutput {
            crate::output::GetRealtimeLogConfigOutput {
                realtime_log_config: self.realtime_log_config,
            }
        }
    }
}
impl GetRealtimeLogConfigOutput {
    /// Creates a new builder-style object to manufacture [`GetRealtimeLogConfigOutput`](crate::output::GetRealtimeLogConfigOutput)
    pub fn builder() -> crate::output::get_realtime_log_config_output::Builder {
        crate::output::get_realtime_log_config_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetPublicKeyConfigOutput {
    /// <p>A public key configuration.</p>
    pub public_key_config: std::option::Option<crate::model::PublicKeyConfig>,
    /// <p>The identifier for this version of the public key configuration.</p>
    pub e_tag: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for GetPublicKeyConfigOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetPublicKeyConfigOutput");
        formatter.field("public_key_config", &self.public_key_config);
        formatter.field("e_tag", &self.e_tag);
        formatter.finish()
    }
}
/// See [`GetPublicKeyConfigOutput`](crate::output::GetPublicKeyConfigOutput)
pub mod get_public_key_config_output {
    /// A builder for [`GetPublicKeyConfigOutput`](crate::output::GetPublicKeyConfigOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) public_key_config: std::option::Option<crate::model::PublicKeyConfig>,
        pub(crate) e_tag: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A public key configuration.</p>
        pub fn public_key_config(mut self, input: crate::model::PublicKeyConfig) -> Self {
            self.public_key_config = Some(input);
            self
        }
        /// <p>A public key configuration.</p>
        pub fn set_public_key_config(
            mut self,
            input: std::option::Option<crate::model::PublicKeyConfig>,
        ) -> Self {
            self.public_key_config = input;
            self
        }
        /// <p>The identifier for this version of the public key configuration.</p>
        pub fn e_tag(mut self, input: impl Into<std::string::String>) -> Self {
            self.e_tag = Some(input.into());
            self
        }
        /// <p>The identifier for this version of the public key configuration.</p>
        pub fn set_e_tag(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.e_tag = input;
            self
        }
        /// Consumes the builder and constructs a [`GetPublicKeyConfigOutput`](crate::output::GetPublicKeyConfigOutput)
        pub fn build(self) -> crate::output::GetPublicKeyConfigOutput {
            crate::output::GetPublicKeyConfigOutput {
                public_key_config: self.public_key_config,
                e_tag: self.e_tag,
            }
        }
    }
}
impl GetPublicKeyConfigOutput {
    /// Creates a new builder-style object to manufacture [`GetPublicKeyConfigOutput`](crate::output::GetPublicKeyConfigOutput)
    pub fn builder() -> crate::output::get_public_key_config_output::Builder {
        crate::output::get_public_key_config_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetPublicKeyOutput {
    /// <p>The public key.</p>
    pub public_key: std::option::Option<crate::model::PublicKey>,
    /// <p>The identifier for this version of the public key.</p>
    pub e_tag: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for GetPublicKeyOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetPublicKeyOutput");
        formatter.field("public_key", &self.public_key);
        formatter.field("e_tag", &self.e_tag);
        formatter.finish()
    }
}
/// See [`GetPublicKeyOutput`](crate::output::GetPublicKeyOutput)
pub mod get_public_key_output {
    /// A builder for [`GetPublicKeyOutput`](crate::output::GetPublicKeyOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) public_key: std::option::Option<crate::model::PublicKey>,
        pub(crate) e_tag: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The public key.</p>
        pub fn public_key(mut self, input: crate::model::PublicKey) -> Self {
            self.public_key = Some(input);
            self
        }
        /// <p>The public key.</p>
        pub fn set_public_key(
            mut self,
            input: std::option::Option<crate::model::PublicKey>,
        ) -> Self {
            self.public_key = input;
            self
        }
        /// <p>The identifier for this version of the public key.</p>
        pub fn e_tag(mut self, input: impl Into<std::string::String>) -> Self {
            self.e_tag = Some(input.into());
            self
        }
        /// <p>The identifier for this version of the public key.</p>
        pub fn set_e_tag(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.e_tag = input;
            self
        }
        /// Consumes the builder and constructs a [`GetPublicKeyOutput`](crate::output::GetPublicKeyOutput)
        pub fn build(self) -> crate::output::GetPublicKeyOutput {
            crate::output::GetPublicKeyOutput {
                public_key: self.public_key,
                e_tag: self.e_tag,
            }
        }
    }
}
impl GetPublicKeyOutput {
    /// Creates a new builder-style object to manufacture [`GetPublicKeyOutput`](crate::output::GetPublicKeyOutput)
    pub fn builder() -> crate::output::get_public_key_output::Builder {
        crate::output::get_public_key_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetOriginRequestPolicyConfigOutput {
    /// <p>The origin request policy configuration.</p>
    pub origin_request_policy_config: std::option::Option<crate::model::OriginRequestPolicyConfig>,
    /// <p>The current version of the origin request policy.</p>
    pub e_tag: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for GetOriginRequestPolicyConfigOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetOriginRequestPolicyConfigOutput");
        formatter.field(
            "origin_request_policy_config",
            &self.origin_request_policy_config,
        );
        formatter.field("e_tag", &self.e_tag);
        formatter.finish()
    }
}
/// See [`GetOriginRequestPolicyConfigOutput`](crate::output::GetOriginRequestPolicyConfigOutput)
pub mod get_origin_request_policy_config_output {
    /// A builder for [`GetOriginRequestPolicyConfigOutput`](crate::output::GetOriginRequestPolicyConfigOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) origin_request_policy_config:
            std::option::Option<crate::model::OriginRequestPolicyConfig>,
        pub(crate) e_tag: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The origin request policy configuration.</p>
        pub fn origin_request_policy_config(
            mut self,
            input: crate::model::OriginRequestPolicyConfig,
        ) -> Self {
            self.origin_request_policy_config = Some(input);
            self
        }
        /// <p>The origin request policy configuration.</p>
        pub fn set_origin_request_policy_config(
            mut self,
            input: std::option::Option<crate::model::OriginRequestPolicyConfig>,
        ) -> Self {
            self.origin_request_policy_config = input;
            self
        }
        /// <p>The current version of the origin request policy.</p>
        pub fn e_tag(mut self, input: impl Into<std::string::String>) -> Self {
            self.e_tag = Some(input.into());
            self
        }
        /// <p>The current version of the origin request policy.</p>
        pub fn set_e_tag(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.e_tag = input;
            self
        }
        /// Consumes the builder and constructs a [`GetOriginRequestPolicyConfigOutput`](crate::output::GetOriginRequestPolicyConfigOutput)
        pub fn build(self) -> crate::output::GetOriginRequestPolicyConfigOutput {
            crate::output::GetOriginRequestPolicyConfigOutput {
                origin_request_policy_config: self.origin_request_policy_config,
                e_tag: self.e_tag,
            }
        }
    }
}
impl GetOriginRequestPolicyConfigOutput {
    /// Creates a new builder-style object to manufacture [`GetOriginRequestPolicyConfigOutput`](crate::output::GetOriginRequestPolicyConfigOutput)
    pub fn builder() -> crate::output::get_origin_request_policy_config_output::Builder {
        crate::output::get_origin_request_policy_config_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetOriginRequestPolicyOutput {
    /// <p>The origin request policy.</p>
    pub origin_request_policy: std::option::Option<crate::model::OriginRequestPolicy>,
    /// <p>The current version of the origin request policy.</p>
    pub e_tag: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for GetOriginRequestPolicyOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetOriginRequestPolicyOutput");
        formatter.field("origin_request_policy", &self.origin_request_policy);
        formatter.field("e_tag", &self.e_tag);
        formatter.finish()
    }
}
/// See [`GetOriginRequestPolicyOutput`](crate::output::GetOriginRequestPolicyOutput)
pub mod get_origin_request_policy_output {
    /// A builder for [`GetOriginRequestPolicyOutput`](crate::output::GetOriginRequestPolicyOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) origin_request_policy: std::option::Option<crate::model::OriginRequestPolicy>,
        pub(crate) e_tag: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The origin request policy.</p>
        pub fn origin_request_policy(mut self, input: crate::model::OriginRequestPolicy) -> Self {
            self.origin_request_policy = Some(input);
            self
        }
        /// <p>The origin request policy.</p>
        pub fn set_origin_request_policy(
            mut self,
            input: std::option::Option<crate::model::OriginRequestPolicy>,
        ) -> Self {
            self.origin_request_policy = input;
            self
        }
        /// <p>The current version of the origin request policy.</p>
        pub fn e_tag(mut self, input: impl Into<std::string::String>) -> Self {
            self.e_tag = Some(input.into());
            self
        }
        /// <p>The current version of the origin request policy.</p>
        pub fn set_e_tag(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.e_tag = input;
            self
        }
        /// Consumes the builder and constructs a [`GetOriginRequestPolicyOutput`](crate::output::GetOriginRequestPolicyOutput)
        pub fn build(self) -> crate::output::GetOriginRequestPolicyOutput {
            crate::output::GetOriginRequestPolicyOutput {
                origin_request_policy: self.origin_request_policy,
                e_tag: self.e_tag,
            }
        }
    }
}
impl GetOriginRequestPolicyOutput {
    /// Creates a new builder-style object to manufacture [`GetOriginRequestPolicyOutput`](crate::output::GetOriginRequestPolicyOutput)
    pub fn builder() -> crate::output::get_origin_request_policy_output::Builder {
        crate::output::get_origin_request_policy_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetMonitoringSubscriptionOutput {
    /// <p>A monitoring subscription. This structure contains information about whether additional
    /// CloudWatch metrics are enabled for a given CloudFront distribution.</p>
    pub monitoring_subscription: std::option::Option<crate::model::MonitoringSubscription>,
}
impl std::fmt::Debug for GetMonitoringSubscriptionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetMonitoringSubscriptionOutput");
        formatter.field("monitoring_subscription", &self.monitoring_subscription);
        formatter.finish()
    }
}
/// See [`GetMonitoringSubscriptionOutput`](crate::output::GetMonitoringSubscriptionOutput)
pub mod get_monitoring_subscription_output {
    /// A builder for [`GetMonitoringSubscriptionOutput`](crate::output::GetMonitoringSubscriptionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) monitoring_subscription:
            std::option::Option<crate::model::MonitoringSubscription>,
    }
    impl Builder {
        /// <p>A monitoring subscription. This structure contains information about whether additional
        /// CloudWatch metrics are enabled for a given CloudFront distribution.</p>
        pub fn monitoring_subscription(
            mut self,
            input: crate::model::MonitoringSubscription,
        ) -> Self {
            self.monitoring_subscription = Some(input);
            self
        }
        /// <p>A monitoring subscription. This structure contains information about whether additional
        /// CloudWatch metrics are enabled for a given CloudFront distribution.</p>
        pub fn set_monitoring_subscription(
            mut self,
            input: std::option::Option<crate::model::MonitoringSubscription>,
        ) -> Self {
            self.monitoring_subscription = input;
            self
        }
        /// Consumes the builder and constructs a [`GetMonitoringSubscriptionOutput`](crate::output::GetMonitoringSubscriptionOutput)
        pub fn build(self) -> crate::output::GetMonitoringSubscriptionOutput {
            crate::output::GetMonitoringSubscriptionOutput {
                monitoring_subscription: self.monitoring_subscription,
            }
        }
    }
}
impl GetMonitoringSubscriptionOutput {
    /// Creates a new builder-style object to manufacture [`GetMonitoringSubscriptionOutput`](crate::output::GetMonitoringSubscriptionOutput)
    pub fn builder() -> crate::output::get_monitoring_subscription_output::Builder {
        crate::output::get_monitoring_subscription_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetKeyGroupConfigOutput {
    /// <p>The key group configuration.</p>
    pub key_group_config: std::option::Option<crate::model::KeyGroupConfig>,
    /// <p>The identifier for this version of the key group.</p>
    pub e_tag: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for GetKeyGroupConfigOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetKeyGroupConfigOutput");
        formatter.field("key_group_config", &self.key_group_config);
        formatter.field("e_tag", &self.e_tag);
        formatter.finish()
    }
}
/// See [`GetKeyGroupConfigOutput`](crate::output::GetKeyGroupConfigOutput)
pub mod get_key_group_config_output {
    /// A builder for [`GetKeyGroupConfigOutput`](crate::output::GetKeyGroupConfigOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) key_group_config: std::option::Option<crate::model::KeyGroupConfig>,
        pub(crate) e_tag: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The key group configuration.</p>
        pub fn key_group_config(mut self, input: crate::model::KeyGroupConfig) -> Self {
            self.key_group_config = Some(input);
            self
        }
        /// <p>The key group configuration.</p>
        pub fn set_key_group_config(
            mut self,
            input: std::option::Option<crate::model::KeyGroupConfig>,
        ) -> Self {
            self.key_group_config = input;
            self
        }
        /// <p>The identifier for this version of the key group.</p>
        pub fn e_tag(mut self, input: impl Into<std::string::String>) -> Self {
            self.e_tag = Some(input.into());
            self
        }
        /// <p>The identifier for this version of the key group.</p>
        pub fn set_e_tag(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.e_tag = input;
            self
        }
        /// Consumes the builder and constructs a [`GetKeyGroupConfigOutput`](crate::output::GetKeyGroupConfigOutput)
        pub fn build(self) -> crate::output::GetKeyGroupConfigOutput {
            crate::output::GetKeyGroupConfigOutput {
                key_group_config: self.key_group_config,
                e_tag: self.e_tag,
            }
        }
    }
}
impl GetKeyGroupConfigOutput {
    /// Creates a new builder-style object to manufacture [`GetKeyGroupConfigOutput`](crate::output::GetKeyGroupConfigOutput)
    pub fn builder() -> crate::output::get_key_group_config_output::Builder {
        crate::output::get_key_group_config_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetKeyGroupOutput {
    /// <p>The key group.</p>
    pub key_group: std::option::Option<crate::model::KeyGroup>,
    /// <p>The identifier for this version of the key group.</p>
    pub e_tag: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for GetKeyGroupOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetKeyGroupOutput");
        formatter.field("key_group", &self.key_group);
        formatter.field("e_tag", &self.e_tag);
        formatter.finish()
    }
}
/// See [`GetKeyGroupOutput`](crate::output::GetKeyGroupOutput)
pub mod get_key_group_output {
    /// A builder for [`GetKeyGroupOutput`](crate::output::GetKeyGroupOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) key_group: std::option::Option<crate::model::KeyGroup>,
        pub(crate) e_tag: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The key group.</p>
        pub fn key_group(mut self, input: crate::model::KeyGroup) -> Self {
            self.key_group = Some(input);
            self
        }
        /// <p>The key group.</p>
        pub fn set_key_group(mut self, input: std::option::Option<crate::model::KeyGroup>) -> Self {
            self.key_group = input;
            self
        }
        /// <p>The identifier for this version of the key group.</p>
        pub fn e_tag(mut self, input: impl Into<std::string::String>) -> Self {
            self.e_tag = Some(input.into());
            self
        }
        /// <p>The identifier for this version of the key group.</p>
        pub fn set_e_tag(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.e_tag = input;
            self
        }
        /// Consumes the builder and constructs a [`GetKeyGroupOutput`](crate::output::GetKeyGroupOutput)
        pub fn build(self) -> crate::output::GetKeyGroupOutput {
            crate::output::GetKeyGroupOutput {
                key_group: self.key_group,
                e_tag: self.e_tag,
            }
        }
    }
}
impl GetKeyGroupOutput {
    /// Creates a new builder-style object to manufacture [`GetKeyGroupOutput`](crate::output::GetKeyGroupOutput)
    pub fn builder() -> crate::output::get_key_group_output::Builder {
        crate::output::get_key_group_output::Builder::default()
    }
}

/// <p>The returned result of the corresponding request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetInvalidationOutput {
    /// <p>The invalidation's information. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/InvalidationDatatype.html">Invalidation Complex Type</a>. </p>
    pub invalidation: std::option::Option<crate::model::Invalidation>,
}
impl std::fmt::Debug for GetInvalidationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetInvalidationOutput");
        formatter.field("invalidation", &self.invalidation);
        formatter.finish()
    }
}
/// See [`GetInvalidationOutput`](crate::output::GetInvalidationOutput)
pub mod get_invalidation_output {
    /// A builder for [`GetInvalidationOutput`](crate::output::GetInvalidationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) invalidation: std::option::Option<crate::model::Invalidation>,
    }
    impl Builder {
        /// <p>The invalidation's information. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/InvalidationDatatype.html">Invalidation Complex Type</a>. </p>
        pub fn invalidation(mut self, input: crate::model::Invalidation) -> Self {
            self.invalidation = Some(input);
            self
        }
        /// <p>The invalidation's information. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/InvalidationDatatype.html">Invalidation Complex Type</a>. </p>
        pub fn set_invalidation(
            mut self,
            input: std::option::Option<crate::model::Invalidation>,
        ) -> Self {
            self.invalidation = input;
            self
        }
        /// Consumes the builder and constructs a [`GetInvalidationOutput`](crate::output::GetInvalidationOutput)
        pub fn build(self) -> crate::output::GetInvalidationOutput {
            crate::output::GetInvalidationOutput {
                invalidation: self.invalidation,
            }
        }
    }
}
impl GetInvalidationOutput {
    /// Creates a new builder-style object to manufacture [`GetInvalidationOutput`](crate::output::GetInvalidationOutput)
    pub fn builder() -> crate::output::get_invalidation_output::Builder {
        crate::output::get_invalidation_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetFunctionOutput {
    /// <p>The function code of a CloudFront function.</p>
    pub function_code: std::option::Option<aws_smithy_types::Blob>,
    /// <p>The version identifier for the current version of the CloudFront function.</p>
    pub e_tag: std::option::Option<std::string::String>,
    /// <p>The content type (media type) of the response.</p>
    pub content_type: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for GetFunctionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetFunctionOutput");
        formatter.field("function_code", &"*** Sensitive Data Redacted ***");
        formatter.field("e_tag", &self.e_tag);
        formatter.field("content_type", &self.content_type);
        formatter.finish()
    }
}
/// See [`GetFunctionOutput`](crate::output::GetFunctionOutput)
pub mod get_function_output {
    /// A builder for [`GetFunctionOutput`](crate::output::GetFunctionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) function_code: std::option::Option<aws_smithy_types::Blob>,
        pub(crate) e_tag: std::option::Option<std::string::String>,
        pub(crate) content_type: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The function code of a CloudFront function.</p>
        pub fn function_code(mut self, input: aws_smithy_types::Blob) -> Self {
            self.function_code = Some(input);
            self
        }
        /// <p>The function code of a CloudFront function.</p>
        pub fn set_function_code(
            mut self,
            input: std::option::Option<aws_smithy_types::Blob>,
        ) -> Self {
            self.function_code = input;
            self
        }
        /// <p>The version identifier for the current version of the CloudFront function.</p>
        pub fn e_tag(mut self, input: impl Into<std::string::String>) -> Self {
            self.e_tag = Some(input.into());
            self
        }
        /// <p>The version identifier for the current version of the CloudFront function.</p>
        pub fn set_e_tag(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.e_tag = input;
            self
        }
        /// <p>The content type (media type) of the response.</p>
        pub fn content_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.content_type = Some(input.into());
            self
        }
        /// <p>The content type (media type) of the response.</p>
        pub fn set_content_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.content_type = input;
            self
        }
        /// Consumes the builder and constructs a [`GetFunctionOutput`](crate::output::GetFunctionOutput)
        pub fn build(self) -> crate::output::GetFunctionOutput {
            crate::output::GetFunctionOutput {
                function_code: self.function_code,
                e_tag: self.e_tag,
                content_type: self.content_type,
            }
        }
    }
}
impl GetFunctionOutput {
    /// Creates a new builder-style object to manufacture [`GetFunctionOutput`](crate::output::GetFunctionOutput)
    pub fn builder() -> crate::output::get_function_output::Builder {
        crate::output::get_function_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetFieldLevelEncryptionProfileConfigOutput {
    /// <p>Return the field-level encryption profile configuration information.</p>
    pub field_level_encryption_profile_config:
        std::option::Option<crate::model::FieldLevelEncryptionProfileConfig>,
    /// <p>The current version of the field-level encryption profile configuration result. For example: <code>E2QWRUHAPOMQZL</code>.</p>
    pub e_tag: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for GetFieldLevelEncryptionProfileConfigOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetFieldLevelEncryptionProfileConfigOutput");
        formatter.field(
            "field_level_encryption_profile_config",
            &self.field_level_encryption_profile_config,
        );
        formatter.field("e_tag", &self.e_tag);
        formatter.finish()
    }
}
/// See [`GetFieldLevelEncryptionProfileConfigOutput`](crate::output::GetFieldLevelEncryptionProfileConfigOutput)
pub mod get_field_level_encryption_profile_config_output {
    /// A builder for [`GetFieldLevelEncryptionProfileConfigOutput`](crate::output::GetFieldLevelEncryptionProfileConfigOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) field_level_encryption_profile_config:
            std::option::Option<crate::model::FieldLevelEncryptionProfileConfig>,
        pub(crate) e_tag: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Return the field-level encryption profile configuration information.</p>
        pub fn field_level_encryption_profile_config(
            mut self,
            input: crate::model::FieldLevelEncryptionProfileConfig,
        ) -> Self {
            self.field_level_encryption_profile_config = Some(input);
            self
        }
        /// <p>Return the field-level encryption profile configuration information.</p>
        pub fn set_field_level_encryption_profile_config(
            mut self,
            input: std::option::Option<crate::model::FieldLevelEncryptionProfileConfig>,
        ) -> Self {
            self.field_level_encryption_profile_config = input;
            self
        }
        /// <p>The current version of the field-level encryption profile configuration result. For example: <code>E2QWRUHAPOMQZL</code>.</p>
        pub fn e_tag(mut self, input: impl Into<std::string::String>) -> Self {
            self.e_tag = Some(input.into());
            self
        }
        /// <p>The current version of the field-level encryption profile configuration result. For example: <code>E2QWRUHAPOMQZL</code>.</p>
        pub fn set_e_tag(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.e_tag = input;
            self
        }
        /// Consumes the builder and constructs a [`GetFieldLevelEncryptionProfileConfigOutput`](crate::output::GetFieldLevelEncryptionProfileConfigOutput)
        pub fn build(self) -> crate::output::GetFieldLevelEncryptionProfileConfigOutput {
            crate::output::GetFieldLevelEncryptionProfileConfigOutput {
                field_level_encryption_profile_config: self.field_level_encryption_profile_config,
                e_tag: self.e_tag,
            }
        }
    }
}
impl GetFieldLevelEncryptionProfileConfigOutput {
    /// Creates a new builder-style object to manufacture [`GetFieldLevelEncryptionProfileConfigOutput`](crate::output::GetFieldLevelEncryptionProfileConfigOutput)
    pub fn builder() -> crate::output::get_field_level_encryption_profile_config_output::Builder {
        crate::output::get_field_level_encryption_profile_config_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetFieldLevelEncryptionProfileOutput {
    /// <p>Return the field-level encryption profile information.</p>
    pub field_level_encryption_profile:
        std::option::Option<crate::model::FieldLevelEncryptionProfile>,
    /// <p>The current version of the field level encryption profile. For example: <code>E2QWRUHAPOMQZL</code>.</p>
    pub e_tag: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for GetFieldLevelEncryptionProfileOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetFieldLevelEncryptionProfileOutput");
        formatter.field(
            "field_level_encryption_profile",
            &self.field_level_encryption_profile,
        );
        formatter.field("e_tag", &self.e_tag);
        formatter.finish()
    }
}
/// See [`GetFieldLevelEncryptionProfileOutput`](crate::output::GetFieldLevelEncryptionProfileOutput)
pub mod get_field_level_encryption_profile_output {
    /// A builder for [`GetFieldLevelEncryptionProfileOutput`](crate::output::GetFieldLevelEncryptionProfileOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) field_level_encryption_profile:
            std::option::Option<crate::model::FieldLevelEncryptionProfile>,
        pub(crate) e_tag: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Return the field-level encryption profile information.</p>
        pub fn field_level_encryption_profile(
            mut self,
            input: crate::model::FieldLevelEncryptionProfile,
        ) -> Self {
            self.field_level_encryption_profile = Some(input);
            self
        }
        /// <p>Return the field-level encryption profile information.</p>
        pub fn set_field_level_encryption_profile(
            mut self,
            input: std::option::Option<crate::model::FieldLevelEncryptionProfile>,
        ) -> Self {
            self.field_level_encryption_profile = input;
            self
        }
        /// <p>The current version of the field level encryption profile. For example: <code>E2QWRUHAPOMQZL</code>.</p>
        pub fn e_tag(mut self, input: impl Into<std::string::String>) -> Self {
            self.e_tag = Some(input.into());
            self
        }
        /// <p>The current version of the field level encryption profile. For example: <code>E2QWRUHAPOMQZL</code>.</p>
        pub fn set_e_tag(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.e_tag = input;
            self
        }
        /// Consumes the builder and constructs a [`GetFieldLevelEncryptionProfileOutput`](crate::output::GetFieldLevelEncryptionProfileOutput)
        pub fn build(self) -> crate::output::GetFieldLevelEncryptionProfileOutput {
            crate::output::GetFieldLevelEncryptionProfileOutput {
                field_level_encryption_profile: self.field_level_encryption_profile,
                e_tag: self.e_tag,
            }
        }
    }
}
impl GetFieldLevelEncryptionProfileOutput {
    /// Creates a new builder-style object to manufacture [`GetFieldLevelEncryptionProfileOutput`](crate::output::GetFieldLevelEncryptionProfileOutput)
    pub fn builder() -> crate::output::get_field_level_encryption_profile_output::Builder {
        crate::output::get_field_level_encryption_profile_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetFieldLevelEncryptionConfigOutput {
    /// <p>Return the field-level encryption configuration information.</p>
    pub field_level_encryption_config:
        std::option::Option<crate::model::FieldLevelEncryptionConfig>,
    /// <p>The current version of the field level encryption configuration. For example: <code>E2QWRUHAPOMQZL</code>.</p>
    pub e_tag: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for GetFieldLevelEncryptionConfigOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetFieldLevelEncryptionConfigOutput");
        formatter.field(
            "field_level_encryption_config",
            &self.field_level_encryption_config,
        );
        formatter.field("e_tag", &self.e_tag);
        formatter.finish()
    }
}
/// See [`GetFieldLevelEncryptionConfigOutput`](crate::output::GetFieldLevelEncryptionConfigOutput)
pub mod get_field_level_encryption_config_output {
    /// A builder for [`GetFieldLevelEncryptionConfigOutput`](crate::output::GetFieldLevelEncryptionConfigOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) field_level_encryption_config:
            std::option::Option<crate::model::FieldLevelEncryptionConfig>,
        pub(crate) e_tag: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Return the field-level encryption configuration information.</p>
        pub fn field_level_encryption_config(
            mut self,
            input: crate::model::FieldLevelEncryptionConfig,
        ) -> Self {
            self.field_level_encryption_config = Some(input);
            self
        }
        /// <p>Return the field-level encryption configuration information.</p>
        pub fn set_field_level_encryption_config(
            mut self,
            input: std::option::Option<crate::model::FieldLevelEncryptionConfig>,
        ) -> Self {
            self.field_level_encryption_config = input;
            self
        }
        /// <p>The current version of the field level encryption configuration. For example: <code>E2QWRUHAPOMQZL</code>.</p>
        pub fn e_tag(mut self, input: impl Into<std::string::String>) -> Self {
            self.e_tag = Some(input.into());
            self
        }
        /// <p>The current version of the field level encryption configuration. For example: <code>E2QWRUHAPOMQZL</code>.</p>
        pub fn set_e_tag(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.e_tag = input;
            self
        }
        /// Consumes the builder and constructs a [`GetFieldLevelEncryptionConfigOutput`](crate::output::GetFieldLevelEncryptionConfigOutput)
        pub fn build(self) -> crate::output::GetFieldLevelEncryptionConfigOutput {
            crate::output::GetFieldLevelEncryptionConfigOutput {
                field_level_encryption_config: self.field_level_encryption_config,
                e_tag: self.e_tag,
            }
        }
    }
}
impl GetFieldLevelEncryptionConfigOutput {
    /// Creates a new builder-style object to manufacture [`GetFieldLevelEncryptionConfigOutput`](crate::output::GetFieldLevelEncryptionConfigOutput)
    pub fn builder() -> crate::output::get_field_level_encryption_config_output::Builder {
        crate::output::get_field_level_encryption_config_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetFieldLevelEncryptionOutput {
    /// <p>Return the field-level encryption configuration information.</p>
    pub field_level_encryption: std::option::Option<crate::model::FieldLevelEncryption>,
    /// <p>The current version of the field level encryption configuration. For example: <code>E2QWRUHAPOMQZL</code>.</p>
    pub e_tag: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for GetFieldLevelEncryptionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetFieldLevelEncryptionOutput");
        formatter.field("field_level_encryption", &self.field_level_encryption);
        formatter.field("e_tag", &self.e_tag);
        formatter.finish()
    }
}
/// See [`GetFieldLevelEncryptionOutput`](crate::output::GetFieldLevelEncryptionOutput)
pub mod get_field_level_encryption_output {
    /// A builder for [`GetFieldLevelEncryptionOutput`](crate::output::GetFieldLevelEncryptionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) field_level_encryption: std::option::Option<crate::model::FieldLevelEncryption>,
        pub(crate) e_tag: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Return the field-level encryption configuration information.</p>
        pub fn field_level_encryption(mut self, input: crate::model::FieldLevelEncryption) -> Self {
            self.field_level_encryption = Some(input);
            self
        }
        /// <p>Return the field-level encryption configuration information.</p>
        pub fn set_field_level_encryption(
            mut self,
            input: std::option::Option<crate::model::FieldLevelEncryption>,
        ) -> Self {
            self.field_level_encryption = input;
            self
        }
        /// <p>The current version of the field level encryption configuration. For example: <code>E2QWRUHAPOMQZL</code>.</p>
        pub fn e_tag(mut self, input: impl Into<std::string::String>) -> Self {
            self.e_tag = Some(input.into());
            self
        }
        /// <p>The current version of the field level encryption configuration. For example: <code>E2QWRUHAPOMQZL</code>.</p>
        pub fn set_e_tag(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.e_tag = input;
            self
        }
        /// Consumes the builder and constructs a [`GetFieldLevelEncryptionOutput`](crate::output::GetFieldLevelEncryptionOutput)
        pub fn build(self) -> crate::output::GetFieldLevelEncryptionOutput {
            crate::output::GetFieldLevelEncryptionOutput {
                field_level_encryption: self.field_level_encryption,
                e_tag: self.e_tag,
            }
        }
    }
}
impl GetFieldLevelEncryptionOutput {
    /// Creates a new builder-style object to manufacture [`GetFieldLevelEncryptionOutput`](crate::output::GetFieldLevelEncryptionOutput)
    pub fn builder() -> crate::output::get_field_level_encryption_output::Builder {
        crate::output::get_field_level_encryption_output::Builder::default()
    }
}

/// <p>The returned result of the corresponding request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetDistributionConfigOutput {
    /// <p>The distribution's configuration information.</p>
    pub distribution_config: std::option::Option<crate::model::DistributionConfig>,
    /// <p>The current version of the configuration. For example:
    /// <code>E2QWRUHAPOMQZL</code>.</p>
    pub e_tag: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for GetDistributionConfigOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetDistributionConfigOutput");
        formatter.field("distribution_config", &self.distribution_config);
        formatter.field("e_tag", &self.e_tag);
        formatter.finish()
    }
}
/// See [`GetDistributionConfigOutput`](crate::output::GetDistributionConfigOutput)
pub mod get_distribution_config_output {
    /// A builder for [`GetDistributionConfigOutput`](crate::output::GetDistributionConfigOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) distribution_config: std::option::Option<crate::model::DistributionConfig>,
        pub(crate) e_tag: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The distribution's configuration information.</p>
        pub fn distribution_config(mut self, input: crate::model::DistributionConfig) -> Self {
            self.distribution_config = Some(input);
            self
        }
        /// <p>The distribution's configuration information.</p>
        pub fn set_distribution_config(
            mut self,
            input: std::option::Option<crate::model::DistributionConfig>,
        ) -> Self {
            self.distribution_config = input;
            self
        }
        /// <p>The current version of the configuration. For example:
        /// <code>E2QWRUHAPOMQZL</code>.</p>
        pub fn e_tag(mut self, input: impl Into<std::string::String>) -> Self {
            self.e_tag = Some(input.into());
            self
        }
        /// <p>The current version of the configuration. For example:
        /// <code>E2QWRUHAPOMQZL</code>.</p>
        pub fn set_e_tag(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.e_tag = input;
            self
        }
        /// Consumes the builder and constructs a [`GetDistributionConfigOutput`](crate::output::GetDistributionConfigOutput)
        pub fn build(self) -> crate::output::GetDistributionConfigOutput {
            crate::output::GetDistributionConfigOutput {
                distribution_config: self.distribution_config,
                e_tag: self.e_tag,
            }
        }
    }
}
impl GetDistributionConfigOutput {
    /// Creates a new builder-style object to manufacture [`GetDistributionConfigOutput`](crate::output::GetDistributionConfigOutput)
    pub fn builder() -> crate::output::get_distribution_config_output::Builder {
        crate::output::get_distribution_config_output::Builder::default()
    }
}

/// <p>The returned result of the corresponding request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetDistributionOutput {
    /// <p>The distribution's information.</p>
    pub distribution: std::option::Option<crate::model::Distribution>,
    /// <p>The current version of the distribution's information. For example:
    /// <code>E2QWRUHAPOMQZL</code>.</p>
    pub e_tag: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for GetDistributionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetDistributionOutput");
        formatter.field("distribution", &self.distribution);
        formatter.field("e_tag", &self.e_tag);
        formatter.finish()
    }
}
/// See [`GetDistributionOutput`](crate::output::GetDistributionOutput)
pub mod get_distribution_output {
    /// A builder for [`GetDistributionOutput`](crate::output::GetDistributionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) distribution: std::option::Option<crate::model::Distribution>,
        pub(crate) e_tag: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The distribution's information.</p>
        pub fn distribution(mut self, input: crate::model::Distribution) -> Self {
            self.distribution = Some(input);
            self
        }
        /// <p>The distribution's information.</p>
        pub fn set_distribution(
            mut self,
            input: std::option::Option<crate::model::Distribution>,
        ) -> Self {
            self.distribution = input;
            self
        }
        /// <p>The current version of the distribution's information. For example:
        /// <code>E2QWRUHAPOMQZL</code>.</p>
        pub fn e_tag(mut self, input: impl Into<std::string::String>) -> Self {
            self.e_tag = Some(input.into());
            self
        }
        /// <p>The current version of the distribution's information. For example:
        /// <code>E2QWRUHAPOMQZL</code>.</p>
        pub fn set_e_tag(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.e_tag = input;
            self
        }
        /// Consumes the builder and constructs a [`GetDistributionOutput`](crate::output::GetDistributionOutput)
        pub fn build(self) -> crate::output::GetDistributionOutput {
            crate::output::GetDistributionOutput {
                distribution: self.distribution,
                e_tag: self.e_tag,
            }
        }
    }
}
impl GetDistributionOutput {
    /// Creates a new builder-style object to manufacture [`GetDistributionOutput`](crate::output::GetDistributionOutput)
    pub fn builder() -> crate::output::get_distribution_output::Builder {
        crate::output::get_distribution_output::Builder::default()
    }
}

/// <p>The returned result of the corresponding request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetCloudFrontOriginAccessIdentityConfigOutput {
    /// <p>The origin access identity's configuration information. </p>
    pub cloud_front_origin_access_identity_config:
        std::option::Option<crate::model::CloudFrontOriginAccessIdentityConfig>,
    /// <p>The current version of the configuration. For example:
    /// <code>E2QWRUHAPOMQZL</code>.</p>
    pub e_tag: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for GetCloudFrontOriginAccessIdentityConfigOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetCloudFrontOriginAccessIdentityConfigOutput");
        formatter.field(
            "cloud_front_origin_access_identity_config",
            &self.cloud_front_origin_access_identity_config,
        );
        formatter.field("e_tag", &self.e_tag);
        formatter.finish()
    }
}
/// See [`GetCloudFrontOriginAccessIdentityConfigOutput`](crate::output::GetCloudFrontOriginAccessIdentityConfigOutput)
pub mod get_cloud_front_origin_access_identity_config_output {
    /// A builder for [`GetCloudFrontOriginAccessIdentityConfigOutput`](crate::output::GetCloudFrontOriginAccessIdentityConfigOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cloud_front_origin_access_identity_config:
            std::option::Option<crate::model::CloudFrontOriginAccessIdentityConfig>,
        pub(crate) e_tag: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The origin access identity's configuration information. </p>
        pub fn cloud_front_origin_access_identity_config(
            mut self,
            input: crate::model::CloudFrontOriginAccessIdentityConfig,
        ) -> Self {
            self.cloud_front_origin_access_identity_config = Some(input);
            self
        }
        /// <p>The origin access identity's configuration information. </p>
        pub fn set_cloud_front_origin_access_identity_config(
            mut self,
            input: std::option::Option<crate::model::CloudFrontOriginAccessIdentityConfig>,
        ) -> Self {
            self.cloud_front_origin_access_identity_config = input;
            self
        }
        /// <p>The current version of the configuration. For example:
        /// <code>E2QWRUHAPOMQZL</code>.</p>
        pub fn e_tag(mut self, input: impl Into<std::string::String>) -> Self {
            self.e_tag = Some(input.into());
            self
        }
        /// <p>The current version of the configuration. For example:
        /// <code>E2QWRUHAPOMQZL</code>.</p>
        pub fn set_e_tag(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.e_tag = input;
            self
        }
        /// Consumes the builder and constructs a [`GetCloudFrontOriginAccessIdentityConfigOutput`](crate::output::GetCloudFrontOriginAccessIdentityConfigOutput)
        pub fn build(self) -> crate::output::GetCloudFrontOriginAccessIdentityConfigOutput {
            crate::output::GetCloudFrontOriginAccessIdentityConfigOutput {
                cloud_front_origin_access_identity_config: self
                    .cloud_front_origin_access_identity_config,
                e_tag: self.e_tag,
            }
        }
    }
}
impl GetCloudFrontOriginAccessIdentityConfigOutput {
    /// Creates a new builder-style object to manufacture [`GetCloudFrontOriginAccessIdentityConfigOutput`](crate::output::GetCloudFrontOriginAccessIdentityConfigOutput)
    pub fn builder() -> crate::output::get_cloud_front_origin_access_identity_config_output::Builder
    {
        crate::output::get_cloud_front_origin_access_identity_config_output::Builder::default()
    }
}

/// <p>The returned result of the corresponding request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetCloudFrontOriginAccessIdentityOutput {
    /// <p>The origin access identity's information.</p>
    pub cloud_front_origin_access_identity:
        std::option::Option<crate::model::CloudFrontOriginAccessIdentity>,
    /// <p>The current version of the origin access identity's information. For example:
    /// <code>E2QWRUHAPOMQZL</code>.</p>
    pub e_tag: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for GetCloudFrontOriginAccessIdentityOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetCloudFrontOriginAccessIdentityOutput");
        formatter.field(
            "cloud_front_origin_access_identity",
            &self.cloud_front_origin_access_identity,
        );
        formatter.field("e_tag", &self.e_tag);
        formatter.finish()
    }
}
/// See [`GetCloudFrontOriginAccessIdentityOutput`](crate::output::GetCloudFrontOriginAccessIdentityOutput)
pub mod get_cloud_front_origin_access_identity_output {
    /// A builder for [`GetCloudFrontOriginAccessIdentityOutput`](crate::output::GetCloudFrontOriginAccessIdentityOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cloud_front_origin_access_identity:
            std::option::Option<crate::model::CloudFrontOriginAccessIdentity>,
        pub(crate) e_tag: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The origin access identity's information.</p>
        pub fn cloud_front_origin_access_identity(
            mut self,
            input: crate::model::CloudFrontOriginAccessIdentity,
        ) -> Self {
            self.cloud_front_origin_access_identity = Some(input);
            self
        }
        /// <p>The origin access identity's information.</p>
        pub fn set_cloud_front_origin_access_identity(
            mut self,
            input: std::option::Option<crate::model::CloudFrontOriginAccessIdentity>,
        ) -> Self {
            self.cloud_front_origin_access_identity = input;
            self
        }
        /// <p>The current version of the origin access identity's information. For example:
        /// <code>E2QWRUHAPOMQZL</code>.</p>
        pub fn e_tag(mut self, input: impl Into<std::string::String>) -> Self {
            self.e_tag = Some(input.into());
            self
        }
        /// <p>The current version of the origin access identity's information. For example:
        /// <code>E2QWRUHAPOMQZL</code>.</p>
        pub fn set_e_tag(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.e_tag = input;
            self
        }
        /// Consumes the builder and constructs a [`GetCloudFrontOriginAccessIdentityOutput`](crate::output::GetCloudFrontOriginAccessIdentityOutput)
        pub fn build(self) -> crate::output::GetCloudFrontOriginAccessIdentityOutput {
            crate::output::GetCloudFrontOriginAccessIdentityOutput {
                cloud_front_origin_access_identity: self.cloud_front_origin_access_identity,
                e_tag: self.e_tag,
            }
        }
    }
}
impl GetCloudFrontOriginAccessIdentityOutput {
    /// Creates a new builder-style object to manufacture [`GetCloudFrontOriginAccessIdentityOutput`](crate::output::GetCloudFrontOriginAccessIdentityOutput)
    pub fn builder() -> crate::output::get_cloud_front_origin_access_identity_output::Builder {
        crate::output::get_cloud_front_origin_access_identity_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetCachePolicyConfigOutput {
    /// <p>The cache policy configuration.</p>
    pub cache_policy_config: std::option::Option<crate::model::CachePolicyConfig>,
    /// <p>The current version of the cache policy.</p>
    pub e_tag: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for GetCachePolicyConfigOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetCachePolicyConfigOutput");
        formatter.field("cache_policy_config", &self.cache_policy_config);
        formatter.field("e_tag", &self.e_tag);
        formatter.finish()
    }
}
/// See [`GetCachePolicyConfigOutput`](crate::output::GetCachePolicyConfigOutput)
pub mod get_cache_policy_config_output {
    /// A builder for [`GetCachePolicyConfigOutput`](crate::output::GetCachePolicyConfigOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cache_policy_config: std::option::Option<crate::model::CachePolicyConfig>,
        pub(crate) e_tag: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The cache policy configuration.</p>
        pub fn cache_policy_config(mut self, input: crate::model::CachePolicyConfig) -> Self {
            self.cache_policy_config = Some(input);
            self
        }
        /// <p>The cache policy configuration.</p>
        pub fn set_cache_policy_config(
            mut self,
            input: std::option::Option<crate::model::CachePolicyConfig>,
        ) -> Self {
            self.cache_policy_config = input;
            self
        }
        /// <p>The current version of the cache policy.</p>
        pub fn e_tag(mut self, input: impl Into<std::string::String>) -> Self {
            self.e_tag = Some(input.into());
            self
        }
        /// <p>The current version of the cache policy.</p>
        pub fn set_e_tag(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.e_tag = input;
            self
        }
        /// Consumes the builder and constructs a [`GetCachePolicyConfigOutput`](crate::output::GetCachePolicyConfigOutput)
        pub fn build(self) -> crate::output::GetCachePolicyConfigOutput {
            crate::output::GetCachePolicyConfigOutput {
                cache_policy_config: self.cache_policy_config,
                e_tag: self.e_tag,
            }
        }
    }
}
impl GetCachePolicyConfigOutput {
    /// Creates a new builder-style object to manufacture [`GetCachePolicyConfigOutput`](crate::output::GetCachePolicyConfigOutput)
    pub fn builder() -> crate::output::get_cache_policy_config_output::Builder {
        crate::output::get_cache_policy_config_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetCachePolicyOutput {
    /// <p>The cache policy.</p>
    pub cache_policy: std::option::Option<crate::model::CachePolicy>,
    /// <p>The current version of the cache policy.</p>
    pub e_tag: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for GetCachePolicyOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetCachePolicyOutput");
        formatter.field("cache_policy", &self.cache_policy);
        formatter.field("e_tag", &self.e_tag);
        formatter.finish()
    }
}
/// See [`GetCachePolicyOutput`](crate::output::GetCachePolicyOutput)
pub mod get_cache_policy_output {
    /// A builder for [`GetCachePolicyOutput`](crate::output::GetCachePolicyOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cache_policy: std::option::Option<crate::model::CachePolicy>,
        pub(crate) e_tag: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The cache policy.</p>
        pub fn cache_policy(mut self, input: crate::model::CachePolicy) -> Self {
            self.cache_policy = Some(input);
            self
        }
        /// <p>The cache policy.</p>
        pub fn set_cache_policy(
            mut self,
            input: std::option::Option<crate::model::CachePolicy>,
        ) -> Self {
            self.cache_policy = input;
            self
        }
        /// <p>The current version of the cache policy.</p>
        pub fn e_tag(mut self, input: impl Into<std::string::String>) -> Self {
            self.e_tag = Some(input.into());
            self
        }
        /// <p>The current version of the cache policy.</p>
        pub fn set_e_tag(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.e_tag = input;
            self
        }
        /// Consumes the builder and constructs a [`GetCachePolicyOutput`](crate::output::GetCachePolicyOutput)
        pub fn build(self) -> crate::output::GetCachePolicyOutput {
            crate::output::GetCachePolicyOutput {
                cache_policy: self.cache_policy,
                e_tag: self.e_tag,
            }
        }
    }
}
impl GetCachePolicyOutput {
    /// Creates a new builder-style object to manufacture [`GetCachePolicyOutput`](crate::output::GetCachePolicyOutput)
    pub fn builder() -> crate::output::get_cache_policy_output::Builder {
        crate::output::get_cache_policy_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeFunctionOutput {
    /// <p>Contains configuration information and metadata about a CloudFront function.</p>
    pub function_summary: std::option::Option<crate::model::FunctionSummary>,
    /// <p>The version identifier for the current version of the CloudFront function.</p>
    pub e_tag: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DescribeFunctionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeFunctionOutput");
        formatter.field("function_summary", &self.function_summary);
        formatter.field("e_tag", &self.e_tag);
        formatter.finish()
    }
}
/// See [`DescribeFunctionOutput`](crate::output::DescribeFunctionOutput)
pub mod describe_function_output {
    /// A builder for [`DescribeFunctionOutput`](crate::output::DescribeFunctionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) function_summary: std::option::Option<crate::model::FunctionSummary>,
        pub(crate) e_tag: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Contains configuration information and metadata about a CloudFront function.</p>
        pub fn function_summary(mut self, input: crate::model::FunctionSummary) -> Self {
            self.function_summary = Some(input);
            self
        }
        /// <p>Contains configuration information and metadata about a CloudFront function.</p>
        pub fn set_function_summary(
            mut self,
            input: std::option::Option<crate::model::FunctionSummary>,
        ) -> Self {
            self.function_summary = input;
            self
        }
        /// <p>The version identifier for the current version of the CloudFront function.</p>
        pub fn e_tag(mut self, input: impl Into<std::string::String>) -> Self {
            self.e_tag = Some(input.into());
            self
        }
        /// <p>The version identifier for the current version of the CloudFront function.</p>
        pub fn set_e_tag(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.e_tag = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeFunctionOutput`](crate::output::DescribeFunctionOutput)
        pub fn build(self) -> crate::output::DescribeFunctionOutput {
            crate::output::DescribeFunctionOutput {
                function_summary: self.function_summary,
                e_tag: self.e_tag,
            }
        }
    }
}
impl DescribeFunctionOutput {
    /// Creates a new builder-style object to manufacture [`DescribeFunctionOutput`](crate::output::DescribeFunctionOutput)
    pub fn builder() -> crate::output::describe_function_output::Builder {
        crate::output::describe_function_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteStreamingDistributionOutput {}
impl std::fmt::Debug for DeleteStreamingDistributionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteStreamingDistributionOutput");
        formatter.finish()
    }
}
/// See [`DeleteStreamingDistributionOutput`](crate::output::DeleteStreamingDistributionOutput)
pub mod delete_streaming_distribution_output {
    /// A builder for [`DeleteStreamingDistributionOutput`](crate::output::DeleteStreamingDistributionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteStreamingDistributionOutput`](crate::output::DeleteStreamingDistributionOutput)
        pub fn build(self) -> crate::output::DeleteStreamingDistributionOutput {
            crate::output::DeleteStreamingDistributionOutput {}
        }
    }
}
impl DeleteStreamingDistributionOutput {
    /// Creates a new builder-style object to manufacture [`DeleteStreamingDistributionOutput`](crate::output::DeleteStreamingDistributionOutput)
    pub fn builder() -> crate::output::delete_streaming_distribution_output::Builder {
        crate::output::delete_streaming_distribution_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteResponseHeadersPolicyOutput {}
impl std::fmt::Debug for DeleteResponseHeadersPolicyOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteResponseHeadersPolicyOutput");
        formatter.finish()
    }
}
/// See [`DeleteResponseHeadersPolicyOutput`](crate::output::DeleteResponseHeadersPolicyOutput)
pub mod delete_response_headers_policy_output {
    /// A builder for [`DeleteResponseHeadersPolicyOutput`](crate::output::DeleteResponseHeadersPolicyOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteResponseHeadersPolicyOutput`](crate::output::DeleteResponseHeadersPolicyOutput)
        pub fn build(self) -> crate::output::DeleteResponseHeadersPolicyOutput {
            crate::output::DeleteResponseHeadersPolicyOutput {}
        }
    }
}
impl DeleteResponseHeadersPolicyOutput {
    /// Creates a new builder-style object to manufacture [`DeleteResponseHeadersPolicyOutput`](crate::output::DeleteResponseHeadersPolicyOutput)
    pub fn builder() -> crate::output::delete_response_headers_policy_output::Builder {
        crate::output::delete_response_headers_policy_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteRealtimeLogConfigOutput {}
impl std::fmt::Debug for DeleteRealtimeLogConfigOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteRealtimeLogConfigOutput");
        formatter.finish()
    }
}
/// See [`DeleteRealtimeLogConfigOutput`](crate::output::DeleteRealtimeLogConfigOutput)
pub mod delete_realtime_log_config_output {
    /// A builder for [`DeleteRealtimeLogConfigOutput`](crate::output::DeleteRealtimeLogConfigOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteRealtimeLogConfigOutput`](crate::output::DeleteRealtimeLogConfigOutput)
        pub fn build(self) -> crate::output::DeleteRealtimeLogConfigOutput {
            crate::output::DeleteRealtimeLogConfigOutput {}
        }
    }
}
impl DeleteRealtimeLogConfigOutput {
    /// Creates a new builder-style object to manufacture [`DeleteRealtimeLogConfigOutput`](crate::output::DeleteRealtimeLogConfigOutput)
    pub fn builder() -> crate::output::delete_realtime_log_config_output::Builder {
        crate::output::delete_realtime_log_config_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeletePublicKeyOutput {}
impl std::fmt::Debug for DeletePublicKeyOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeletePublicKeyOutput");
        formatter.finish()
    }
}
/// See [`DeletePublicKeyOutput`](crate::output::DeletePublicKeyOutput)
pub mod delete_public_key_output {
    /// A builder for [`DeletePublicKeyOutput`](crate::output::DeletePublicKeyOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeletePublicKeyOutput`](crate::output::DeletePublicKeyOutput)
        pub fn build(self) -> crate::output::DeletePublicKeyOutput {
            crate::output::DeletePublicKeyOutput {}
        }
    }
}
impl DeletePublicKeyOutput {
    /// Creates a new builder-style object to manufacture [`DeletePublicKeyOutput`](crate::output::DeletePublicKeyOutput)
    pub fn builder() -> crate::output::delete_public_key_output::Builder {
        crate::output::delete_public_key_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteOriginRequestPolicyOutput {}
impl std::fmt::Debug for DeleteOriginRequestPolicyOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteOriginRequestPolicyOutput");
        formatter.finish()
    }
}
/// See [`DeleteOriginRequestPolicyOutput`](crate::output::DeleteOriginRequestPolicyOutput)
pub mod delete_origin_request_policy_output {
    /// A builder for [`DeleteOriginRequestPolicyOutput`](crate::output::DeleteOriginRequestPolicyOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteOriginRequestPolicyOutput`](crate::output::DeleteOriginRequestPolicyOutput)
        pub fn build(self) -> crate::output::DeleteOriginRequestPolicyOutput {
            crate::output::DeleteOriginRequestPolicyOutput {}
        }
    }
}
impl DeleteOriginRequestPolicyOutput {
    /// Creates a new builder-style object to manufacture [`DeleteOriginRequestPolicyOutput`](crate::output::DeleteOriginRequestPolicyOutput)
    pub fn builder() -> crate::output::delete_origin_request_policy_output::Builder {
        crate::output::delete_origin_request_policy_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteMonitoringSubscriptionOutput {}
impl std::fmt::Debug for DeleteMonitoringSubscriptionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteMonitoringSubscriptionOutput");
        formatter.finish()
    }
}
/// See [`DeleteMonitoringSubscriptionOutput`](crate::output::DeleteMonitoringSubscriptionOutput)
pub mod delete_monitoring_subscription_output {
    /// A builder for [`DeleteMonitoringSubscriptionOutput`](crate::output::DeleteMonitoringSubscriptionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteMonitoringSubscriptionOutput`](crate::output::DeleteMonitoringSubscriptionOutput)
        pub fn build(self) -> crate::output::DeleteMonitoringSubscriptionOutput {
            crate::output::DeleteMonitoringSubscriptionOutput {}
        }
    }
}
impl DeleteMonitoringSubscriptionOutput {
    /// Creates a new builder-style object to manufacture [`DeleteMonitoringSubscriptionOutput`](crate::output::DeleteMonitoringSubscriptionOutput)
    pub fn builder() -> crate::output::delete_monitoring_subscription_output::Builder {
        crate::output::delete_monitoring_subscription_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteKeyGroupOutput {}
impl std::fmt::Debug for DeleteKeyGroupOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteKeyGroupOutput");
        formatter.finish()
    }
}
/// See [`DeleteKeyGroupOutput`](crate::output::DeleteKeyGroupOutput)
pub mod delete_key_group_output {
    /// A builder for [`DeleteKeyGroupOutput`](crate::output::DeleteKeyGroupOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteKeyGroupOutput`](crate::output::DeleteKeyGroupOutput)
        pub fn build(self) -> crate::output::DeleteKeyGroupOutput {
            crate::output::DeleteKeyGroupOutput {}
        }
    }
}
impl DeleteKeyGroupOutput {
    /// Creates a new builder-style object to manufacture [`DeleteKeyGroupOutput`](crate::output::DeleteKeyGroupOutput)
    pub fn builder() -> crate::output::delete_key_group_output::Builder {
        crate::output::delete_key_group_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteFunctionOutput {}
impl std::fmt::Debug for DeleteFunctionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteFunctionOutput");
        formatter.finish()
    }
}
/// See [`DeleteFunctionOutput`](crate::output::DeleteFunctionOutput)
pub mod delete_function_output {
    /// A builder for [`DeleteFunctionOutput`](crate::output::DeleteFunctionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteFunctionOutput`](crate::output::DeleteFunctionOutput)
        pub fn build(self) -> crate::output::DeleteFunctionOutput {
            crate::output::DeleteFunctionOutput {}
        }
    }
}
impl DeleteFunctionOutput {
    /// Creates a new builder-style object to manufacture [`DeleteFunctionOutput`](crate::output::DeleteFunctionOutput)
    pub fn builder() -> crate::output::delete_function_output::Builder {
        crate::output::delete_function_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteFieldLevelEncryptionProfileOutput {}
impl std::fmt::Debug for DeleteFieldLevelEncryptionProfileOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteFieldLevelEncryptionProfileOutput");
        formatter.finish()
    }
}
/// See [`DeleteFieldLevelEncryptionProfileOutput`](crate::output::DeleteFieldLevelEncryptionProfileOutput)
pub mod delete_field_level_encryption_profile_output {
    /// A builder for [`DeleteFieldLevelEncryptionProfileOutput`](crate::output::DeleteFieldLevelEncryptionProfileOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteFieldLevelEncryptionProfileOutput`](crate::output::DeleteFieldLevelEncryptionProfileOutput)
        pub fn build(self) -> crate::output::DeleteFieldLevelEncryptionProfileOutput {
            crate::output::DeleteFieldLevelEncryptionProfileOutput {}
        }
    }
}
impl DeleteFieldLevelEncryptionProfileOutput {
    /// Creates a new builder-style object to manufacture [`DeleteFieldLevelEncryptionProfileOutput`](crate::output::DeleteFieldLevelEncryptionProfileOutput)
    pub fn builder() -> crate::output::delete_field_level_encryption_profile_output::Builder {
        crate::output::delete_field_level_encryption_profile_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteFieldLevelEncryptionConfigOutput {}
impl std::fmt::Debug for DeleteFieldLevelEncryptionConfigOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteFieldLevelEncryptionConfigOutput");
        formatter.finish()
    }
}
/// See [`DeleteFieldLevelEncryptionConfigOutput`](crate::output::DeleteFieldLevelEncryptionConfigOutput)
pub mod delete_field_level_encryption_config_output {
    /// A builder for [`DeleteFieldLevelEncryptionConfigOutput`](crate::output::DeleteFieldLevelEncryptionConfigOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteFieldLevelEncryptionConfigOutput`](crate::output::DeleteFieldLevelEncryptionConfigOutput)
        pub fn build(self) -> crate::output::DeleteFieldLevelEncryptionConfigOutput {
            crate::output::DeleteFieldLevelEncryptionConfigOutput {}
        }
    }
}
impl DeleteFieldLevelEncryptionConfigOutput {
    /// Creates a new builder-style object to manufacture [`DeleteFieldLevelEncryptionConfigOutput`](crate::output::DeleteFieldLevelEncryptionConfigOutput)
    pub fn builder() -> crate::output::delete_field_level_encryption_config_output::Builder {
        crate::output::delete_field_level_encryption_config_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteDistributionOutput {}
impl std::fmt::Debug for DeleteDistributionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteDistributionOutput");
        formatter.finish()
    }
}
/// See [`DeleteDistributionOutput`](crate::output::DeleteDistributionOutput)
pub mod delete_distribution_output {
    /// A builder for [`DeleteDistributionOutput`](crate::output::DeleteDistributionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteDistributionOutput`](crate::output::DeleteDistributionOutput)
        pub fn build(self) -> crate::output::DeleteDistributionOutput {
            crate::output::DeleteDistributionOutput {}
        }
    }
}
impl DeleteDistributionOutput {
    /// Creates a new builder-style object to manufacture [`DeleteDistributionOutput`](crate::output::DeleteDistributionOutput)
    pub fn builder() -> crate::output::delete_distribution_output::Builder {
        crate::output::delete_distribution_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteCloudFrontOriginAccessIdentityOutput {}
impl std::fmt::Debug for DeleteCloudFrontOriginAccessIdentityOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteCloudFrontOriginAccessIdentityOutput");
        formatter.finish()
    }
}
/// See [`DeleteCloudFrontOriginAccessIdentityOutput`](crate::output::DeleteCloudFrontOriginAccessIdentityOutput)
pub mod delete_cloud_front_origin_access_identity_output {
    /// A builder for [`DeleteCloudFrontOriginAccessIdentityOutput`](crate::output::DeleteCloudFrontOriginAccessIdentityOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteCloudFrontOriginAccessIdentityOutput`](crate::output::DeleteCloudFrontOriginAccessIdentityOutput)
        pub fn build(self) -> crate::output::DeleteCloudFrontOriginAccessIdentityOutput {
            crate::output::DeleteCloudFrontOriginAccessIdentityOutput {}
        }
    }
}
impl DeleteCloudFrontOriginAccessIdentityOutput {
    /// Creates a new builder-style object to manufacture [`DeleteCloudFrontOriginAccessIdentityOutput`](crate::output::DeleteCloudFrontOriginAccessIdentityOutput)
    pub fn builder() -> crate::output::delete_cloud_front_origin_access_identity_output::Builder {
        crate::output::delete_cloud_front_origin_access_identity_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteCachePolicyOutput {}
impl std::fmt::Debug for DeleteCachePolicyOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteCachePolicyOutput");
        formatter.finish()
    }
}
/// See [`DeleteCachePolicyOutput`](crate::output::DeleteCachePolicyOutput)
pub mod delete_cache_policy_output {
    /// A builder for [`DeleteCachePolicyOutput`](crate::output::DeleteCachePolicyOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteCachePolicyOutput`](crate::output::DeleteCachePolicyOutput)
        pub fn build(self) -> crate::output::DeleteCachePolicyOutput {
            crate::output::DeleteCachePolicyOutput {}
        }
    }
}
impl DeleteCachePolicyOutput {
    /// Creates a new builder-style object to manufacture [`DeleteCachePolicyOutput`](crate::output::DeleteCachePolicyOutput)
    pub fn builder() -> crate::output::delete_cache_policy_output::Builder {
        crate::output::delete_cache_policy_output::Builder::default()
    }
}

/// <p>The returned result of the corresponding request. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateStreamingDistributionWithTagsOutput {
    /// <p>The streaming distribution's information. </p>
    pub streaming_distribution: std::option::Option<crate::model::StreamingDistribution>,
    /// <p>The fully qualified URI of the new streaming distribution resource just created.</p>
    pub location: std::option::Option<std::string::String>,
    /// <p>The current version of the distribution created.</p>
    pub e_tag: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for CreateStreamingDistributionWithTagsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateStreamingDistributionWithTagsOutput");
        formatter.field("streaming_distribution", &self.streaming_distribution);
        formatter.field("location", &self.location);
        formatter.field("e_tag", &self.e_tag);
        formatter.finish()
    }
}
/// See [`CreateStreamingDistributionWithTagsOutput`](crate::output::CreateStreamingDistributionWithTagsOutput)
pub mod create_streaming_distribution_with_tags_output {
    /// A builder for [`CreateStreamingDistributionWithTagsOutput`](crate::output::CreateStreamingDistributionWithTagsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) streaming_distribution: std::option::Option<crate::model::StreamingDistribution>,
        pub(crate) location: std::option::Option<std::string::String>,
        pub(crate) e_tag: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The streaming distribution's information. </p>
        pub fn streaming_distribution(
            mut self,
            input: crate::model::StreamingDistribution,
        ) -> Self {
            self.streaming_distribution = Some(input);
            self
        }
        /// <p>The streaming distribution's information. </p>
        pub fn set_streaming_distribution(
            mut self,
            input: std::option::Option<crate::model::StreamingDistribution>,
        ) -> Self {
            self.streaming_distribution = input;
            self
        }
        /// <p>The fully qualified URI of the new streaming distribution resource just created.</p>
        pub fn location(mut self, input: impl Into<std::string::String>) -> Self {
            self.location = Some(input.into());
            self
        }
        /// <p>The fully qualified URI of the new streaming distribution resource just created.</p>
        pub fn set_location(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.location = input;
            self
        }
        /// <p>The current version of the distribution created.</p>
        pub fn e_tag(mut self, input: impl Into<std::string::String>) -> Self {
            self.e_tag = Some(input.into());
            self
        }
        /// <p>The current version of the distribution created.</p>
        pub fn set_e_tag(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.e_tag = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateStreamingDistributionWithTagsOutput`](crate::output::CreateStreamingDistributionWithTagsOutput)
        pub fn build(self) -> crate::output::CreateStreamingDistributionWithTagsOutput {
            crate::output::CreateStreamingDistributionWithTagsOutput {
                streaming_distribution: self.streaming_distribution,
                location: self.location,
                e_tag: self.e_tag,
            }
        }
    }
}
impl CreateStreamingDistributionWithTagsOutput {
    /// Creates a new builder-style object to manufacture [`CreateStreamingDistributionWithTagsOutput`](crate::output::CreateStreamingDistributionWithTagsOutput)
    pub fn builder() -> crate::output::create_streaming_distribution_with_tags_output::Builder {
        crate::output::create_streaming_distribution_with_tags_output::Builder::default()
    }
}

/// <p>The returned result of the corresponding request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateStreamingDistributionOutput {
    /// <p>The streaming distribution's information.</p>
    pub streaming_distribution: std::option::Option<crate::model::StreamingDistribution>,
    /// <p>The fully qualified URI of the new streaming distribution resource just created.</p>
    pub location: std::option::Option<std::string::String>,
    /// <p>The current version of the streaming distribution created.</p>
    pub e_tag: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for CreateStreamingDistributionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateStreamingDistributionOutput");
        formatter.field("streaming_distribution", &self.streaming_distribution);
        formatter.field("location", &self.location);
        formatter.field("e_tag", &self.e_tag);
        formatter.finish()
    }
}
/// See [`CreateStreamingDistributionOutput`](crate::output::CreateStreamingDistributionOutput)
pub mod create_streaming_distribution_output {
    /// A builder for [`CreateStreamingDistributionOutput`](crate::output::CreateStreamingDistributionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) streaming_distribution: std::option::Option<crate::model::StreamingDistribution>,
        pub(crate) location: std::option::Option<std::string::String>,
        pub(crate) e_tag: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The streaming distribution's information.</p>
        pub fn streaming_distribution(
            mut self,
            input: crate::model::StreamingDistribution,
        ) -> Self {
            self.streaming_distribution = Some(input);
            self
        }
        /// <p>The streaming distribution's information.</p>
        pub fn set_streaming_distribution(
            mut self,
            input: std::option::Option<crate::model::StreamingDistribution>,
        ) -> Self {
            self.streaming_distribution = input;
            self
        }
        /// <p>The fully qualified URI of the new streaming distribution resource just created.</p>
        pub fn location(mut self, input: impl Into<std::string::String>) -> Self {
            self.location = Some(input.into());
            self
        }
        /// <p>The fully qualified URI of the new streaming distribution resource just created.</p>
        pub fn set_location(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.location = input;
            self
        }
        /// <p>The current version of the streaming distribution created.</p>
        pub fn e_tag(mut self, input: impl Into<std::string::String>) -> Self {
            self.e_tag = Some(input.into());
            self
        }
        /// <p>The current version of the streaming distribution created.</p>
        pub fn set_e_tag(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.e_tag = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateStreamingDistributionOutput`](crate::output::CreateStreamingDistributionOutput)
        pub fn build(self) -> crate::output::CreateStreamingDistributionOutput {
            crate::output::CreateStreamingDistributionOutput {
                streaming_distribution: self.streaming_distribution,
                location: self.location,
                e_tag: self.e_tag,
            }
        }
    }
}
impl CreateStreamingDistributionOutput {
    /// Creates a new builder-style object to manufacture [`CreateStreamingDistributionOutput`](crate::output::CreateStreamingDistributionOutput)
    pub fn builder() -> crate::output::create_streaming_distribution_output::Builder {
        crate::output::create_streaming_distribution_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateResponseHeadersPolicyOutput {
    /// <p>Contains a response headers policy.</p>
    pub response_headers_policy: std::option::Option<crate::model::ResponseHeadersPolicy>,
    /// <p>The URL of the response headers policy.</p>
    pub location: std::option::Option<std::string::String>,
    /// <p>The version identifier for the current version of the response headers policy.</p>
    pub e_tag: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for CreateResponseHeadersPolicyOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateResponseHeadersPolicyOutput");
        formatter.field("response_headers_policy", &self.response_headers_policy);
        formatter.field("location", &self.location);
        formatter.field("e_tag", &self.e_tag);
        formatter.finish()
    }
}
/// See [`CreateResponseHeadersPolicyOutput`](crate::output::CreateResponseHeadersPolicyOutput)
pub mod create_response_headers_policy_output {
    /// A builder for [`CreateResponseHeadersPolicyOutput`](crate::output::CreateResponseHeadersPolicyOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) response_headers_policy:
            std::option::Option<crate::model::ResponseHeadersPolicy>,
        pub(crate) location: std::option::Option<std::string::String>,
        pub(crate) e_tag: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Contains a response headers policy.</p>
        pub fn response_headers_policy(
            mut self,
            input: crate::model::ResponseHeadersPolicy,
        ) -> Self {
            self.response_headers_policy = Some(input);
            self
        }
        /// <p>Contains a response headers policy.</p>
        pub fn set_response_headers_policy(
            mut self,
            input: std::option::Option<crate::model::ResponseHeadersPolicy>,
        ) -> Self {
            self.response_headers_policy = input;
            self
        }
        /// <p>The URL of the response headers policy.</p>
        pub fn location(mut self, input: impl Into<std::string::String>) -> Self {
            self.location = Some(input.into());
            self
        }
        /// <p>The URL of the response headers policy.</p>
        pub fn set_location(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.location = input;
            self
        }
        /// <p>The version identifier for the current version of the response headers policy.</p>
        pub fn e_tag(mut self, input: impl Into<std::string::String>) -> Self {
            self.e_tag = Some(input.into());
            self
        }
        /// <p>The version identifier for the current version of the response headers policy.</p>
        pub fn set_e_tag(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.e_tag = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateResponseHeadersPolicyOutput`](crate::output::CreateResponseHeadersPolicyOutput)
        pub fn build(self) -> crate::output::CreateResponseHeadersPolicyOutput {
            crate::output::CreateResponseHeadersPolicyOutput {
                response_headers_policy: self.response_headers_policy,
                location: self.location,
                e_tag: self.e_tag,
            }
        }
    }
}
impl CreateResponseHeadersPolicyOutput {
    /// Creates a new builder-style object to manufacture [`CreateResponseHeadersPolicyOutput`](crate::output::CreateResponseHeadersPolicyOutput)
    pub fn builder() -> crate::output::create_response_headers_policy_output::Builder {
        crate::output::create_response_headers_policy_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateRealtimeLogConfigOutput {
    /// <p>A real-time log configuration.</p>
    pub realtime_log_config: std::option::Option<crate::model::RealtimeLogConfig>,
}
impl std::fmt::Debug for CreateRealtimeLogConfigOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateRealtimeLogConfigOutput");
        formatter.field("realtime_log_config", &self.realtime_log_config);
        formatter.finish()
    }
}
/// See [`CreateRealtimeLogConfigOutput`](crate::output::CreateRealtimeLogConfigOutput)
pub mod create_realtime_log_config_output {
    /// A builder for [`CreateRealtimeLogConfigOutput`](crate::output::CreateRealtimeLogConfigOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) realtime_log_config: std::option::Option<crate::model::RealtimeLogConfig>,
    }
    impl Builder {
        /// <p>A real-time log configuration.</p>
        pub fn realtime_log_config(mut self, input: crate::model::RealtimeLogConfig) -> Self {
            self.realtime_log_config = Some(input);
            self
        }
        /// <p>A real-time log configuration.</p>
        pub fn set_realtime_log_config(
            mut self,
            input: std::option::Option<crate::model::RealtimeLogConfig>,
        ) -> Self {
            self.realtime_log_config = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateRealtimeLogConfigOutput`](crate::output::CreateRealtimeLogConfigOutput)
        pub fn build(self) -> crate::output::CreateRealtimeLogConfigOutput {
            crate::output::CreateRealtimeLogConfigOutput {
                realtime_log_config: self.realtime_log_config,
            }
        }
    }
}
impl CreateRealtimeLogConfigOutput {
    /// Creates a new builder-style object to manufacture [`CreateRealtimeLogConfigOutput`](crate::output::CreateRealtimeLogConfigOutput)
    pub fn builder() -> crate::output::create_realtime_log_config_output::Builder {
        crate::output::create_realtime_log_config_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreatePublicKeyOutput {
    /// <p>The public key.</p>
    pub public_key: std::option::Option<crate::model::PublicKey>,
    /// <p>The URL of the public key.</p>
    pub location: std::option::Option<std::string::String>,
    /// <p>The identifier for this version of the public key.</p>
    pub e_tag: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for CreatePublicKeyOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreatePublicKeyOutput");
        formatter.field("public_key", &self.public_key);
        formatter.field("location", &self.location);
        formatter.field("e_tag", &self.e_tag);
        formatter.finish()
    }
}
/// See [`CreatePublicKeyOutput`](crate::output::CreatePublicKeyOutput)
pub mod create_public_key_output {
    /// A builder for [`CreatePublicKeyOutput`](crate::output::CreatePublicKeyOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) public_key: std::option::Option<crate::model::PublicKey>,
        pub(crate) location: std::option::Option<std::string::String>,
        pub(crate) e_tag: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The public key.</p>
        pub fn public_key(mut self, input: crate::model::PublicKey) -> Self {
            self.public_key = Some(input);
            self
        }
        /// <p>The public key.</p>
        pub fn set_public_key(
            mut self,
            input: std::option::Option<crate::model::PublicKey>,
        ) -> Self {
            self.public_key = input;
            self
        }
        /// <p>The URL of the public key.</p>
        pub fn location(mut self, input: impl Into<std::string::String>) -> Self {
            self.location = Some(input.into());
            self
        }
        /// <p>The URL of the public key.</p>
        pub fn set_location(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.location = input;
            self
        }
        /// <p>The identifier for this version of the public key.</p>
        pub fn e_tag(mut self, input: impl Into<std::string::String>) -> Self {
            self.e_tag = Some(input.into());
            self
        }
        /// <p>The identifier for this version of the public key.</p>
        pub fn set_e_tag(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.e_tag = input;
            self
        }
        /// Consumes the builder and constructs a [`CreatePublicKeyOutput`](crate::output::CreatePublicKeyOutput)
        pub fn build(self) -> crate::output::CreatePublicKeyOutput {
            crate::output::CreatePublicKeyOutput {
                public_key: self.public_key,
                location: self.location,
                e_tag: self.e_tag,
            }
        }
    }
}
impl CreatePublicKeyOutput {
    /// Creates a new builder-style object to manufacture [`CreatePublicKeyOutput`](crate::output::CreatePublicKeyOutput)
    pub fn builder() -> crate::output::create_public_key_output::Builder {
        crate::output::create_public_key_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateOriginRequestPolicyOutput {
    /// <p>An origin request policy.</p>
    pub origin_request_policy: std::option::Option<crate::model::OriginRequestPolicy>,
    /// <p>The fully qualified URI of the origin request policy just created.</p>
    pub location: std::option::Option<std::string::String>,
    /// <p>The current version of the origin request policy.</p>
    pub e_tag: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for CreateOriginRequestPolicyOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateOriginRequestPolicyOutput");
        formatter.field("origin_request_policy", &self.origin_request_policy);
        formatter.field("location", &self.location);
        formatter.field("e_tag", &self.e_tag);
        formatter.finish()
    }
}
/// See [`CreateOriginRequestPolicyOutput`](crate::output::CreateOriginRequestPolicyOutput)
pub mod create_origin_request_policy_output {
    /// A builder for [`CreateOriginRequestPolicyOutput`](crate::output::CreateOriginRequestPolicyOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) origin_request_policy: std::option::Option<crate::model::OriginRequestPolicy>,
        pub(crate) location: std::option::Option<std::string::String>,
        pub(crate) e_tag: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>An origin request policy.</p>
        pub fn origin_request_policy(mut self, input: crate::model::OriginRequestPolicy) -> Self {
            self.origin_request_policy = Some(input);
            self
        }
        /// <p>An origin request policy.</p>
        pub fn set_origin_request_policy(
            mut self,
            input: std::option::Option<crate::model::OriginRequestPolicy>,
        ) -> Self {
            self.origin_request_policy = input;
            self
        }
        /// <p>The fully qualified URI of the origin request policy just created.</p>
        pub fn location(mut self, input: impl Into<std::string::String>) -> Self {
            self.location = Some(input.into());
            self
        }
        /// <p>The fully qualified URI of the origin request policy just created.</p>
        pub fn set_location(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.location = input;
            self
        }
        /// <p>The current version of the origin request policy.</p>
        pub fn e_tag(mut self, input: impl Into<std::string::String>) -> Self {
            self.e_tag = Some(input.into());
            self
        }
        /// <p>The current version of the origin request policy.</p>
        pub fn set_e_tag(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.e_tag = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateOriginRequestPolicyOutput`](crate::output::CreateOriginRequestPolicyOutput)
        pub fn build(self) -> crate::output::CreateOriginRequestPolicyOutput {
            crate::output::CreateOriginRequestPolicyOutput {
                origin_request_policy: self.origin_request_policy,
                location: self.location,
                e_tag: self.e_tag,
            }
        }
    }
}
impl CreateOriginRequestPolicyOutput {
    /// Creates a new builder-style object to manufacture [`CreateOriginRequestPolicyOutput`](crate::output::CreateOriginRequestPolicyOutput)
    pub fn builder() -> crate::output::create_origin_request_policy_output::Builder {
        crate::output::create_origin_request_policy_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateMonitoringSubscriptionOutput {
    /// <p>A monitoring subscription. This structure contains information about whether additional
    /// CloudWatch metrics are enabled for a given CloudFront distribution.</p>
    pub monitoring_subscription: std::option::Option<crate::model::MonitoringSubscription>,
}
impl std::fmt::Debug for CreateMonitoringSubscriptionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateMonitoringSubscriptionOutput");
        formatter.field("monitoring_subscription", &self.monitoring_subscription);
        formatter.finish()
    }
}
/// See [`CreateMonitoringSubscriptionOutput`](crate::output::CreateMonitoringSubscriptionOutput)
pub mod create_monitoring_subscription_output {
    /// A builder for [`CreateMonitoringSubscriptionOutput`](crate::output::CreateMonitoringSubscriptionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) monitoring_subscription:
            std::option::Option<crate::model::MonitoringSubscription>,
    }
    impl Builder {
        /// <p>A monitoring subscription. This structure contains information about whether additional
        /// CloudWatch metrics are enabled for a given CloudFront distribution.</p>
        pub fn monitoring_subscription(
            mut self,
            input: crate::model::MonitoringSubscription,
        ) -> Self {
            self.monitoring_subscription = Some(input);
            self
        }
        /// <p>A monitoring subscription. This structure contains information about whether additional
        /// CloudWatch metrics are enabled for a given CloudFront distribution.</p>
        pub fn set_monitoring_subscription(
            mut self,
            input: std::option::Option<crate::model::MonitoringSubscription>,
        ) -> Self {
            self.monitoring_subscription = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateMonitoringSubscriptionOutput`](crate::output::CreateMonitoringSubscriptionOutput)
        pub fn build(self) -> crate::output::CreateMonitoringSubscriptionOutput {
            crate::output::CreateMonitoringSubscriptionOutput {
                monitoring_subscription: self.monitoring_subscription,
            }
        }
    }
}
impl CreateMonitoringSubscriptionOutput {
    /// Creates a new builder-style object to manufacture [`CreateMonitoringSubscriptionOutput`](crate::output::CreateMonitoringSubscriptionOutput)
    pub fn builder() -> crate::output::create_monitoring_subscription_output::Builder {
        crate::output::create_monitoring_subscription_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateKeyGroupOutput {
    /// <p>The key group that was just created.</p>
    pub key_group: std::option::Option<crate::model::KeyGroup>,
    /// <p>The URL of the key group.</p>
    pub location: std::option::Option<std::string::String>,
    /// <p>The identifier for this version of the key group.</p>
    pub e_tag: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for CreateKeyGroupOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateKeyGroupOutput");
        formatter.field("key_group", &self.key_group);
        formatter.field("location", &self.location);
        formatter.field("e_tag", &self.e_tag);
        formatter.finish()
    }
}
/// See [`CreateKeyGroupOutput`](crate::output::CreateKeyGroupOutput)
pub mod create_key_group_output {
    /// A builder for [`CreateKeyGroupOutput`](crate::output::CreateKeyGroupOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) key_group: std::option::Option<crate::model::KeyGroup>,
        pub(crate) location: std::option::Option<std::string::String>,
        pub(crate) e_tag: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The key group that was just created.</p>
        pub fn key_group(mut self, input: crate::model::KeyGroup) -> Self {
            self.key_group = Some(input);
            self
        }
        /// <p>The key group that was just created.</p>
        pub fn set_key_group(mut self, input: std::option::Option<crate::model::KeyGroup>) -> Self {
            self.key_group = input;
            self
        }
        /// <p>The URL of the key group.</p>
        pub fn location(mut self, input: impl Into<std::string::String>) -> Self {
            self.location = Some(input.into());
            self
        }
        /// <p>The URL of the key group.</p>
        pub fn set_location(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.location = input;
            self
        }
        /// <p>The identifier for this version of the key group.</p>
        pub fn e_tag(mut self, input: impl Into<std::string::String>) -> Self {
            self.e_tag = Some(input.into());
            self
        }
        /// <p>The identifier for this version of the key group.</p>
        pub fn set_e_tag(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.e_tag = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateKeyGroupOutput`](crate::output::CreateKeyGroupOutput)
        pub fn build(self) -> crate::output::CreateKeyGroupOutput {
            crate::output::CreateKeyGroupOutput {
                key_group: self.key_group,
                location: self.location,
                e_tag: self.e_tag,
            }
        }
    }
}
impl CreateKeyGroupOutput {
    /// Creates a new builder-style object to manufacture [`CreateKeyGroupOutput`](crate::output::CreateKeyGroupOutput)
    pub fn builder() -> crate::output::create_key_group_output::Builder {
        crate::output::create_key_group_output::Builder::default()
    }
}

/// <p>The returned result of the corresponding request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateInvalidationOutput {
    /// <p>The fully qualified URI of the distribution and invalidation batch request, including
    /// the <code>Invalidation ID</code>.</p>
    pub location: std::option::Option<std::string::String>,
    /// <p>The invalidation's information.</p>
    pub invalidation: std::option::Option<crate::model::Invalidation>,
}
impl std::fmt::Debug for CreateInvalidationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateInvalidationOutput");
        formatter.field("location", &self.location);
        formatter.field("invalidation", &self.invalidation);
        formatter.finish()
    }
}
/// See [`CreateInvalidationOutput`](crate::output::CreateInvalidationOutput)
pub mod create_invalidation_output {
    /// A builder for [`CreateInvalidationOutput`](crate::output::CreateInvalidationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) location: std::option::Option<std::string::String>,
        pub(crate) invalidation: std::option::Option<crate::model::Invalidation>,
    }
    impl Builder {
        /// <p>The fully qualified URI of the distribution and invalidation batch request, including
        /// the <code>Invalidation ID</code>.</p>
        pub fn location(mut self, input: impl Into<std::string::String>) -> Self {
            self.location = Some(input.into());
            self
        }
        /// <p>The fully qualified URI of the distribution and invalidation batch request, including
        /// the <code>Invalidation ID</code>.</p>
        pub fn set_location(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.location = input;
            self
        }
        /// <p>The invalidation's information.</p>
        pub fn invalidation(mut self, input: crate::model::Invalidation) -> Self {
            self.invalidation = Some(input);
            self
        }
        /// <p>The invalidation's information.</p>
        pub fn set_invalidation(
            mut self,
            input: std::option::Option<crate::model::Invalidation>,
        ) -> Self {
            self.invalidation = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateInvalidationOutput`](crate::output::CreateInvalidationOutput)
        pub fn build(self) -> crate::output::CreateInvalidationOutput {
            crate::output::CreateInvalidationOutput {
                location: self.location,
                invalidation: self.invalidation,
            }
        }
    }
}
impl CreateInvalidationOutput {
    /// Creates a new builder-style object to manufacture [`CreateInvalidationOutput`](crate::output::CreateInvalidationOutput)
    pub fn builder() -> crate::output::create_invalidation_output::Builder {
        crate::output::create_invalidation_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateFunctionOutput {
    /// <p>Contains configuration information and metadata about a CloudFront function.</p>
    pub function_summary: std::option::Option<crate::model::FunctionSummary>,
    /// <p>The URL of the CloudFront function. Use the URL to manage the function with the CloudFront
    /// API.</p>
    pub location: std::option::Option<std::string::String>,
    /// <p>The version identifier for the current version of the CloudFront function.</p>
    pub e_tag: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for CreateFunctionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateFunctionOutput");
        formatter.field("function_summary", &self.function_summary);
        formatter.field("location", &self.location);
        formatter.field("e_tag", &self.e_tag);
        formatter.finish()
    }
}
/// See [`CreateFunctionOutput`](crate::output::CreateFunctionOutput)
pub mod create_function_output {
    /// A builder for [`CreateFunctionOutput`](crate::output::CreateFunctionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) function_summary: std::option::Option<crate::model::FunctionSummary>,
        pub(crate) location: std::option::Option<std::string::String>,
        pub(crate) e_tag: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Contains configuration information and metadata about a CloudFront function.</p>
        pub fn function_summary(mut self, input: crate::model::FunctionSummary) -> Self {
            self.function_summary = Some(input);
            self
        }
        /// <p>Contains configuration information and metadata about a CloudFront function.</p>
        pub fn set_function_summary(
            mut self,
            input: std::option::Option<crate::model::FunctionSummary>,
        ) -> Self {
            self.function_summary = input;
            self
        }
        /// <p>The URL of the CloudFront function. Use the URL to manage the function with the CloudFront
        /// API.</p>
        pub fn location(mut self, input: impl Into<std::string::String>) -> Self {
            self.location = Some(input.into());
            self
        }
        /// <p>The URL of the CloudFront function. Use the URL to manage the function with the CloudFront
        /// API.</p>
        pub fn set_location(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.location = input;
            self
        }
        /// <p>The version identifier for the current version of the CloudFront function.</p>
        pub fn e_tag(mut self, input: impl Into<std::string::String>) -> Self {
            self.e_tag = Some(input.into());
            self
        }
        /// <p>The version identifier for the current version of the CloudFront function.</p>
        pub fn set_e_tag(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.e_tag = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateFunctionOutput`](crate::output::CreateFunctionOutput)
        pub fn build(self) -> crate::output::CreateFunctionOutput {
            crate::output::CreateFunctionOutput {
                function_summary: self.function_summary,
                location: self.location,
                e_tag: self.e_tag,
            }
        }
    }
}
impl CreateFunctionOutput {
    /// Creates a new builder-style object to manufacture [`CreateFunctionOutput`](crate::output::CreateFunctionOutput)
    pub fn builder() -> crate::output::create_function_output::Builder {
        crate::output::create_function_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateFieldLevelEncryptionProfileOutput {
    /// <p>Returned when you create a new field-level encryption profile.</p>
    pub field_level_encryption_profile:
        std::option::Option<crate::model::FieldLevelEncryptionProfile>,
    /// <p>The fully qualified URI of the new profile resource just created.</p>
    pub location: std::option::Option<std::string::String>,
    /// <p>The current version of the field level encryption profile. For example: <code>E2QWRUHAPOMQZL</code>.</p>
    pub e_tag: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for CreateFieldLevelEncryptionProfileOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateFieldLevelEncryptionProfileOutput");
        formatter.field(
            "field_level_encryption_profile",
            &self.field_level_encryption_profile,
        );
        formatter.field("location", &self.location);
        formatter.field("e_tag", &self.e_tag);
        formatter.finish()
    }
}
/// See [`CreateFieldLevelEncryptionProfileOutput`](crate::output::CreateFieldLevelEncryptionProfileOutput)
pub mod create_field_level_encryption_profile_output {
    /// A builder for [`CreateFieldLevelEncryptionProfileOutput`](crate::output::CreateFieldLevelEncryptionProfileOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) field_level_encryption_profile:
            std::option::Option<crate::model::FieldLevelEncryptionProfile>,
        pub(crate) location: std::option::Option<std::string::String>,
        pub(crate) e_tag: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Returned when you create a new field-level encryption profile.</p>
        pub fn field_level_encryption_profile(
            mut self,
            input: crate::model::FieldLevelEncryptionProfile,
        ) -> Self {
            self.field_level_encryption_profile = Some(input);
            self
        }
        /// <p>Returned when you create a new field-level encryption profile.</p>
        pub fn set_field_level_encryption_profile(
            mut self,
            input: std::option::Option<crate::model::FieldLevelEncryptionProfile>,
        ) -> Self {
            self.field_level_encryption_profile = input;
            self
        }
        /// <p>The fully qualified URI of the new profile resource just created.</p>
        pub fn location(mut self, input: impl Into<std::string::String>) -> Self {
            self.location = Some(input.into());
            self
        }
        /// <p>The fully qualified URI of the new profile resource just created.</p>
        pub fn set_location(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.location = input;
            self
        }
        /// <p>The current version of the field level encryption profile. For example: <code>E2QWRUHAPOMQZL</code>.</p>
        pub fn e_tag(mut self, input: impl Into<std::string::String>) -> Self {
            self.e_tag = Some(input.into());
            self
        }
        /// <p>The current version of the field level encryption profile. For example: <code>E2QWRUHAPOMQZL</code>.</p>
        pub fn set_e_tag(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.e_tag = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateFieldLevelEncryptionProfileOutput`](crate::output::CreateFieldLevelEncryptionProfileOutput)
        pub fn build(self) -> crate::output::CreateFieldLevelEncryptionProfileOutput {
            crate::output::CreateFieldLevelEncryptionProfileOutput {
                field_level_encryption_profile: self.field_level_encryption_profile,
                location: self.location,
                e_tag: self.e_tag,
            }
        }
    }
}
impl CreateFieldLevelEncryptionProfileOutput {
    /// Creates a new builder-style object to manufacture [`CreateFieldLevelEncryptionProfileOutput`](crate::output::CreateFieldLevelEncryptionProfileOutput)
    pub fn builder() -> crate::output::create_field_level_encryption_profile_output::Builder {
        crate::output::create_field_level_encryption_profile_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateFieldLevelEncryptionConfigOutput {
    /// <p>Returned when you create a new field-level encryption configuration.</p>
    pub field_level_encryption: std::option::Option<crate::model::FieldLevelEncryption>,
    /// <p>The fully qualified URI of the new configuration resource just created.</p>
    pub location: std::option::Option<std::string::String>,
    /// <p>The current version of the field level encryption configuration. For example: <code>E2QWRUHAPOMQZL</code>.</p>
    pub e_tag: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for CreateFieldLevelEncryptionConfigOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateFieldLevelEncryptionConfigOutput");
        formatter.field("field_level_encryption", &self.field_level_encryption);
        formatter.field("location", &self.location);
        formatter.field("e_tag", &self.e_tag);
        formatter.finish()
    }
}
/// See [`CreateFieldLevelEncryptionConfigOutput`](crate::output::CreateFieldLevelEncryptionConfigOutput)
pub mod create_field_level_encryption_config_output {
    /// A builder for [`CreateFieldLevelEncryptionConfigOutput`](crate::output::CreateFieldLevelEncryptionConfigOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) field_level_encryption: std::option::Option<crate::model::FieldLevelEncryption>,
        pub(crate) location: std::option::Option<std::string::String>,
        pub(crate) e_tag: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Returned when you create a new field-level encryption configuration.</p>
        pub fn field_level_encryption(mut self, input: crate::model::FieldLevelEncryption) -> Self {
            self.field_level_encryption = Some(input);
            self
        }
        /// <p>Returned when you create a new field-level encryption configuration.</p>
        pub fn set_field_level_encryption(
            mut self,
            input: std::option::Option<crate::model::FieldLevelEncryption>,
        ) -> Self {
            self.field_level_encryption = input;
            self
        }
        /// <p>The fully qualified URI of the new configuration resource just created.</p>
        pub fn location(mut self, input: impl Into<std::string::String>) -> Self {
            self.location = Some(input.into());
            self
        }
        /// <p>The fully qualified URI of the new configuration resource just created.</p>
        pub fn set_location(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.location = input;
            self
        }
        /// <p>The current version of the field level encryption configuration. For example: <code>E2QWRUHAPOMQZL</code>.</p>
        pub fn e_tag(mut self, input: impl Into<std::string::String>) -> Self {
            self.e_tag = Some(input.into());
            self
        }
        /// <p>The current version of the field level encryption configuration. For example: <code>E2QWRUHAPOMQZL</code>.</p>
        pub fn set_e_tag(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.e_tag = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateFieldLevelEncryptionConfigOutput`](crate::output::CreateFieldLevelEncryptionConfigOutput)
        pub fn build(self) -> crate::output::CreateFieldLevelEncryptionConfigOutput {
            crate::output::CreateFieldLevelEncryptionConfigOutput {
                field_level_encryption: self.field_level_encryption,
                location: self.location,
                e_tag: self.e_tag,
            }
        }
    }
}
impl CreateFieldLevelEncryptionConfigOutput {
    /// Creates a new builder-style object to manufacture [`CreateFieldLevelEncryptionConfigOutput`](crate::output::CreateFieldLevelEncryptionConfigOutput)
    pub fn builder() -> crate::output::create_field_level_encryption_config_output::Builder {
        crate::output::create_field_level_encryption_config_output::Builder::default()
    }
}

/// <p>The returned result of the corresponding request. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateDistributionWithTagsOutput {
    /// <p>The distribution's information. </p>
    pub distribution: std::option::Option<crate::model::Distribution>,
    /// <p>The fully qualified URI of the new distribution resource just created.</p>
    pub location: std::option::Option<std::string::String>,
    /// <p>The current version of the distribution created.</p>
    pub e_tag: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for CreateDistributionWithTagsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateDistributionWithTagsOutput");
        formatter.field("distribution", &self.distribution);
        formatter.field("location", &self.location);
        formatter.field("e_tag", &self.e_tag);
        formatter.finish()
    }
}
/// See [`CreateDistributionWithTagsOutput`](crate::output::CreateDistributionWithTagsOutput)
pub mod create_distribution_with_tags_output {
    /// A builder for [`CreateDistributionWithTagsOutput`](crate::output::CreateDistributionWithTagsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) distribution: std::option::Option<crate::model::Distribution>,
        pub(crate) location: std::option::Option<std::string::String>,
        pub(crate) e_tag: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The distribution's information. </p>
        pub fn distribution(mut self, input: crate::model::Distribution) -> Self {
            self.distribution = Some(input);
            self
        }
        /// <p>The distribution's information. </p>
        pub fn set_distribution(
            mut self,
            input: std::option::Option<crate::model::Distribution>,
        ) -> Self {
            self.distribution = input;
            self
        }
        /// <p>The fully qualified URI of the new distribution resource just created.</p>
        pub fn location(mut self, input: impl Into<std::string::String>) -> Self {
            self.location = Some(input.into());
            self
        }
        /// <p>The fully qualified URI of the new distribution resource just created.</p>
        pub fn set_location(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.location = input;
            self
        }
        /// <p>The current version of the distribution created.</p>
        pub fn e_tag(mut self, input: impl Into<std::string::String>) -> Self {
            self.e_tag = Some(input.into());
            self
        }
        /// <p>The current version of the distribution created.</p>
        pub fn set_e_tag(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.e_tag = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateDistributionWithTagsOutput`](crate::output::CreateDistributionWithTagsOutput)
        pub fn build(self) -> crate::output::CreateDistributionWithTagsOutput {
            crate::output::CreateDistributionWithTagsOutput {
                distribution: self.distribution,
                location: self.location,
                e_tag: self.e_tag,
            }
        }
    }
}
impl CreateDistributionWithTagsOutput {
    /// Creates a new builder-style object to manufacture [`CreateDistributionWithTagsOutput`](crate::output::CreateDistributionWithTagsOutput)
    pub fn builder() -> crate::output::create_distribution_with_tags_output::Builder {
        crate::output::create_distribution_with_tags_output::Builder::default()
    }
}

/// <p>The returned result of the corresponding request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateDistributionOutput {
    /// <p>The distribution's information.</p>
    pub distribution: std::option::Option<crate::model::Distribution>,
    /// <p>The fully qualified URI of the new distribution resource just created.</p>
    pub location: std::option::Option<std::string::String>,
    /// <p>The current version of the distribution created.</p>
    pub e_tag: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for CreateDistributionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateDistributionOutput");
        formatter.field("distribution", &self.distribution);
        formatter.field("location", &self.location);
        formatter.field("e_tag", &self.e_tag);
        formatter.finish()
    }
}
/// See [`CreateDistributionOutput`](crate::output::CreateDistributionOutput)
pub mod create_distribution_output {
    /// A builder for [`CreateDistributionOutput`](crate::output::CreateDistributionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) distribution: std::option::Option<crate::model::Distribution>,
        pub(crate) location: std::option::Option<std::string::String>,
        pub(crate) e_tag: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The distribution's information.</p>
        pub fn distribution(mut self, input: crate::model::Distribution) -> Self {
            self.distribution = Some(input);
            self
        }
        /// <p>The distribution's information.</p>
        pub fn set_distribution(
            mut self,
            input: std::option::Option<crate::model::Distribution>,
        ) -> Self {
            self.distribution = input;
            self
        }
        /// <p>The fully qualified URI of the new distribution resource just created.</p>
        pub fn location(mut self, input: impl Into<std::string::String>) -> Self {
            self.location = Some(input.into());
            self
        }
        /// <p>The fully qualified URI of the new distribution resource just created.</p>
        pub fn set_location(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.location = input;
            self
        }
        /// <p>The current version of the distribution created.</p>
        pub fn e_tag(mut self, input: impl Into<std::string::String>) -> Self {
            self.e_tag = Some(input.into());
            self
        }
        /// <p>The current version of the distribution created.</p>
        pub fn set_e_tag(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.e_tag = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateDistributionOutput`](crate::output::CreateDistributionOutput)
        pub fn build(self) -> crate::output::CreateDistributionOutput {
            crate::output::CreateDistributionOutput {
                distribution: self.distribution,
                location: self.location,
                e_tag: self.e_tag,
            }
        }
    }
}
impl CreateDistributionOutput {
    /// Creates a new builder-style object to manufacture [`CreateDistributionOutput`](crate::output::CreateDistributionOutput)
    pub fn builder() -> crate::output::create_distribution_output::Builder {
        crate::output::create_distribution_output::Builder::default()
    }
}

/// <p>The returned result of the corresponding request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateCloudFrontOriginAccessIdentityOutput {
    /// <p>The origin access identity's information.</p>
    pub cloud_front_origin_access_identity:
        std::option::Option<crate::model::CloudFrontOriginAccessIdentity>,
    /// <p>The fully qualified URI of the new origin access identity just created.</p>
    pub location: std::option::Option<std::string::String>,
    /// <p>The current version of the origin access identity created.</p>
    pub e_tag: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for CreateCloudFrontOriginAccessIdentityOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateCloudFrontOriginAccessIdentityOutput");
        formatter.field(
            "cloud_front_origin_access_identity",
            &self.cloud_front_origin_access_identity,
        );
        formatter.field("location", &self.location);
        formatter.field("e_tag", &self.e_tag);
        formatter.finish()
    }
}
/// See [`CreateCloudFrontOriginAccessIdentityOutput`](crate::output::CreateCloudFrontOriginAccessIdentityOutput)
pub mod create_cloud_front_origin_access_identity_output {
    /// A builder for [`CreateCloudFrontOriginAccessIdentityOutput`](crate::output::CreateCloudFrontOriginAccessIdentityOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cloud_front_origin_access_identity:
            std::option::Option<crate::model::CloudFrontOriginAccessIdentity>,
        pub(crate) location: std::option::Option<std::string::String>,
        pub(crate) e_tag: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The origin access identity's information.</p>
        pub fn cloud_front_origin_access_identity(
            mut self,
            input: crate::model::CloudFrontOriginAccessIdentity,
        ) -> Self {
            self.cloud_front_origin_access_identity = Some(input);
            self
        }
        /// <p>The origin access identity's information.</p>
        pub fn set_cloud_front_origin_access_identity(
            mut self,
            input: std::option::Option<crate::model::CloudFrontOriginAccessIdentity>,
        ) -> Self {
            self.cloud_front_origin_access_identity = input;
            self
        }
        /// <p>The fully qualified URI of the new origin access identity just created.</p>
        pub fn location(mut self, input: impl Into<std::string::String>) -> Self {
            self.location = Some(input.into());
            self
        }
        /// <p>The fully qualified URI of the new origin access identity just created.</p>
        pub fn set_location(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.location = input;
            self
        }
        /// <p>The current version of the origin access identity created.</p>
        pub fn e_tag(mut self, input: impl Into<std::string::String>) -> Self {
            self.e_tag = Some(input.into());
            self
        }
        /// <p>The current version of the origin access identity created.</p>
        pub fn set_e_tag(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.e_tag = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateCloudFrontOriginAccessIdentityOutput`](crate::output::CreateCloudFrontOriginAccessIdentityOutput)
        pub fn build(self) -> crate::output::CreateCloudFrontOriginAccessIdentityOutput {
            crate::output::CreateCloudFrontOriginAccessIdentityOutput {
                cloud_front_origin_access_identity: self.cloud_front_origin_access_identity,
                location: self.location,
                e_tag: self.e_tag,
            }
        }
    }
}
impl CreateCloudFrontOriginAccessIdentityOutput {
    /// Creates a new builder-style object to manufacture [`CreateCloudFrontOriginAccessIdentityOutput`](crate::output::CreateCloudFrontOriginAccessIdentityOutput)
    pub fn builder() -> crate::output::create_cloud_front_origin_access_identity_output::Builder {
        crate::output::create_cloud_front_origin_access_identity_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateCachePolicyOutput {
    /// <p>A cache policy.</p>
    pub cache_policy: std::option::Option<crate::model::CachePolicy>,
    /// <p>The fully qualified URI of the cache policy just created.</p>
    pub location: std::option::Option<std::string::String>,
    /// <p>The current version of the cache policy.</p>
    pub e_tag: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for CreateCachePolicyOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateCachePolicyOutput");
        formatter.field("cache_policy", &self.cache_policy);
        formatter.field("location", &self.location);
        formatter.field("e_tag", &self.e_tag);
        formatter.finish()
    }
}
/// See [`CreateCachePolicyOutput`](crate::output::CreateCachePolicyOutput)
pub mod create_cache_policy_output {
    /// A builder for [`CreateCachePolicyOutput`](crate::output::CreateCachePolicyOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cache_policy: std::option::Option<crate::model::CachePolicy>,
        pub(crate) location: std::option::Option<std::string::String>,
        pub(crate) e_tag: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A cache policy.</p>
        pub fn cache_policy(mut self, input: crate::model::CachePolicy) -> Self {
            self.cache_policy = Some(input);
            self
        }
        /// <p>A cache policy.</p>
        pub fn set_cache_policy(
            mut self,
            input: std::option::Option<crate::model::CachePolicy>,
        ) -> Self {
            self.cache_policy = input;
            self
        }
        /// <p>The fully qualified URI of the cache policy just created.</p>
        pub fn location(mut self, input: impl Into<std::string::String>) -> Self {
            self.location = Some(input.into());
            self
        }
        /// <p>The fully qualified URI of the cache policy just created.</p>
        pub fn set_location(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.location = input;
            self
        }
        /// <p>The current version of the cache policy.</p>
        pub fn e_tag(mut self, input: impl Into<std::string::String>) -> Self {
            self.e_tag = Some(input.into());
            self
        }
        /// <p>The current version of the cache policy.</p>
        pub fn set_e_tag(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.e_tag = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateCachePolicyOutput`](crate::output::CreateCachePolicyOutput)
        pub fn build(self) -> crate::output::CreateCachePolicyOutput {
            crate::output::CreateCachePolicyOutput {
                cache_policy: self.cache_policy,
                location: self.location,
                e_tag: self.e_tag,
            }
        }
    }
}
impl CreateCachePolicyOutput {
    /// Creates a new builder-style object to manufacture [`CreateCachePolicyOutput`](crate::output::CreateCachePolicyOutput)
    pub fn builder() -> crate::output::create_cache_policy_output::Builder {
        crate::output::create_cache_policy_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AssociateAliasOutput {}
impl std::fmt::Debug for AssociateAliasOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AssociateAliasOutput");
        formatter.finish()
    }
}
/// See [`AssociateAliasOutput`](crate::output::AssociateAliasOutput)
pub mod associate_alias_output {
    /// A builder for [`AssociateAliasOutput`](crate::output::AssociateAliasOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`AssociateAliasOutput`](crate::output::AssociateAliasOutput)
        pub fn build(self) -> crate::output::AssociateAliasOutput {
            crate::output::AssociateAliasOutput {}
        }
    }
}
impl AssociateAliasOutput {
    /// Creates a new builder-style object to manufacture [`AssociateAliasOutput`](crate::output::AssociateAliasOutput)
    pub fn builder() -> crate::output::associate_alias_output::Builder {
        crate::output::associate_alias_output::Builder::default()
    }
}
