// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Error type for the `ActivateType` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ActivateTypeError {
    /// Kind of error that occurred.
    pub kind: ActivateTypeErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ActivateType` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ActivateTypeErrorKind {
    /// <p>An error occurred during a CloudFormation registry operation.</p>
    CfnRegistryException(crate::error::CfnRegistryException),
    /// <p>The specified extension doesn't exist in the CloudFormation registry.</p>
    TypeNotFoundException(crate::error::TypeNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ActivateTypeError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ActivateTypeErrorKind::CfnRegistryException(_inner) => _inner.fmt(f),
            ActivateTypeErrorKind::TypeNotFoundException(_inner) => _inner.fmt(f),
            ActivateTypeErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ActivateTypeError {
    fn code(&self) -> Option<&str> {
        ActivateTypeError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ActivateTypeError {
    /// Creates a new `ActivateTypeError`.
    pub fn new(kind: ActivateTypeErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ActivateTypeError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ActivateTypeErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ActivateTypeError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ActivateTypeErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ActivateTypeErrorKind::CfnRegistryException`.
    pub fn is_cfn_registry_exception(&self) -> bool {
        matches!(&self.kind, ActivateTypeErrorKind::CfnRegistryException(_))
    }
    /// Returns `true` if the error kind is `ActivateTypeErrorKind::TypeNotFoundException`.
    pub fn is_type_not_found_exception(&self) -> bool {
        matches!(&self.kind, ActivateTypeErrorKind::TypeNotFoundException(_))
    }
}
impl std::error::Error for ActivateTypeError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ActivateTypeErrorKind::CfnRegistryException(_inner) => Some(_inner),
            ActivateTypeErrorKind::TypeNotFoundException(_inner) => Some(_inner),
            ActivateTypeErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `BatchDescribeTypeConfigurations` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct BatchDescribeTypeConfigurationsError {
    /// Kind of error that occurred.
    pub kind: BatchDescribeTypeConfigurationsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `BatchDescribeTypeConfigurations` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum BatchDescribeTypeConfigurationsErrorKind {
    /// <p>An error occurred during a CloudFormation registry operation.</p>
    CfnRegistryException(crate::error::CfnRegistryException),
    /// <p>The specified extension configuration can't be found.</p>
    TypeConfigurationNotFoundException(crate::error::TypeConfigurationNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for BatchDescribeTypeConfigurationsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            BatchDescribeTypeConfigurationsErrorKind::CfnRegistryException(_inner) => _inner.fmt(f),
            BatchDescribeTypeConfigurationsErrorKind::TypeConfigurationNotFoundException(
                _inner,
            ) => _inner.fmt(f),
            BatchDescribeTypeConfigurationsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for BatchDescribeTypeConfigurationsError {
    fn code(&self) -> Option<&str> {
        BatchDescribeTypeConfigurationsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl BatchDescribeTypeConfigurationsError {
    /// Creates a new `BatchDescribeTypeConfigurationsError`.
    pub fn new(
        kind: BatchDescribeTypeConfigurationsErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `BatchDescribeTypeConfigurationsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: BatchDescribeTypeConfigurationsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `BatchDescribeTypeConfigurationsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: BatchDescribeTypeConfigurationsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `BatchDescribeTypeConfigurationsErrorKind::CfnRegistryException`.
    pub fn is_cfn_registry_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchDescribeTypeConfigurationsErrorKind::CfnRegistryException(_)
        )
    }
    /// Returns `true` if the error kind is `BatchDescribeTypeConfigurationsErrorKind::TypeConfigurationNotFoundException`.
    pub fn is_type_configuration_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchDescribeTypeConfigurationsErrorKind::TypeConfigurationNotFoundException(_)
        )
    }
}
impl std::error::Error for BatchDescribeTypeConfigurationsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            BatchDescribeTypeConfigurationsErrorKind::CfnRegistryException(_inner) => Some(_inner),
            BatchDescribeTypeConfigurationsErrorKind::TypeConfigurationNotFoundException(
                _inner,
            ) => Some(_inner),
            BatchDescribeTypeConfigurationsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CancelUpdateStack` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CancelUpdateStackError {
    /// Kind of error that occurred.
    pub kind: CancelUpdateStackErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CancelUpdateStack` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CancelUpdateStackErrorKind {
    /// <p>A client request token already exists.</p>
    TokenAlreadyExistsException(crate::error::TokenAlreadyExistsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CancelUpdateStackError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CancelUpdateStackErrorKind::TokenAlreadyExistsException(_inner) => _inner.fmt(f),
            CancelUpdateStackErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CancelUpdateStackError {
    fn code(&self) -> Option<&str> {
        CancelUpdateStackError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CancelUpdateStackError {
    /// Creates a new `CancelUpdateStackError`.
    pub fn new(kind: CancelUpdateStackErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CancelUpdateStackError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CancelUpdateStackErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CancelUpdateStackError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CancelUpdateStackErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CancelUpdateStackErrorKind::TokenAlreadyExistsException`.
    pub fn is_token_already_exists_exception(&self) -> bool {
        matches!(
            &self.kind,
            CancelUpdateStackErrorKind::TokenAlreadyExistsException(_)
        )
    }
}
impl std::error::Error for CancelUpdateStackError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CancelUpdateStackErrorKind::TokenAlreadyExistsException(_inner) => Some(_inner),
            CancelUpdateStackErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ContinueUpdateRollback` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ContinueUpdateRollbackError {
    /// Kind of error that occurred.
    pub kind: ContinueUpdateRollbackErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ContinueUpdateRollback` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ContinueUpdateRollbackErrorKind {
    /// <p>A client request token already exists.</p>
    TokenAlreadyExistsException(crate::error::TokenAlreadyExistsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ContinueUpdateRollbackError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ContinueUpdateRollbackErrorKind::TokenAlreadyExistsException(_inner) => _inner.fmt(f),
            ContinueUpdateRollbackErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ContinueUpdateRollbackError {
    fn code(&self) -> Option<&str> {
        ContinueUpdateRollbackError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ContinueUpdateRollbackError {
    /// Creates a new `ContinueUpdateRollbackError`.
    pub fn new(kind: ContinueUpdateRollbackErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ContinueUpdateRollbackError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ContinueUpdateRollbackErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ContinueUpdateRollbackError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ContinueUpdateRollbackErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ContinueUpdateRollbackErrorKind::TokenAlreadyExistsException`.
    pub fn is_token_already_exists_exception(&self) -> bool {
        matches!(
            &self.kind,
            ContinueUpdateRollbackErrorKind::TokenAlreadyExistsException(_)
        )
    }
}
impl std::error::Error for ContinueUpdateRollbackError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ContinueUpdateRollbackErrorKind::TokenAlreadyExistsException(_inner) => Some(_inner),
            ContinueUpdateRollbackErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateChangeSet` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateChangeSetError {
    /// Kind of error that occurred.
    pub kind: CreateChangeSetErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateChangeSet` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateChangeSetErrorKind {
    /// <p>The resource with the name requested already exists.</p>
    AlreadyExistsException(crate::error::AlreadyExistsException),
    /// <p>The template contains resources with capabilities that weren't specified in the Capabilities parameter.</p>
    InsufficientCapabilitiesException(crate::error::InsufficientCapabilitiesException),
    /// <p>The quota for the resource has already been reached.</p>
    /// <p>For information on resource and stack limitations, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/cloudformation-limits.html">CloudFormation quotas</a> in the <i>CloudFormation User Guide</i>.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateChangeSetError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateChangeSetErrorKind::AlreadyExistsException(_inner) => _inner.fmt(f),
            CreateChangeSetErrorKind::InsufficientCapabilitiesException(_inner) => _inner.fmt(f),
            CreateChangeSetErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            CreateChangeSetErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateChangeSetError {
    fn code(&self) -> Option<&str> {
        CreateChangeSetError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateChangeSetError {
    /// Creates a new `CreateChangeSetError`.
    pub fn new(kind: CreateChangeSetErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateChangeSetError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateChangeSetErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateChangeSetError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateChangeSetErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateChangeSetErrorKind::AlreadyExistsException`.
    pub fn is_already_exists_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateChangeSetErrorKind::AlreadyExistsException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateChangeSetErrorKind::InsufficientCapabilitiesException`.
    pub fn is_insufficient_capabilities_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateChangeSetErrorKind::InsufficientCapabilitiesException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateChangeSetErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateChangeSetErrorKind::LimitExceededException(_)
        )
    }
}
impl std::error::Error for CreateChangeSetError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateChangeSetErrorKind::AlreadyExistsException(_inner) => Some(_inner),
            CreateChangeSetErrorKind::InsufficientCapabilitiesException(_inner) => Some(_inner),
            CreateChangeSetErrorKind::LimitExceededException(_inner) => Some(_inner),
            CreateChangeSetErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateStack` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateStackError {
    /// Kind of error that occurred.
    pub kind: CreateStackErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateStack` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateStackErrorKind {
    /// <p>The resource with the name requested already exists.</p>
    AlreadyExistsException(crate::error::AlreadyExistsException),
    /// <p>The template contains resources with capabilities that weren't specified in the Capabilities parameter.</p>
    InsufficientCapabilitiesException(crate::error::InsufficientCapabilitiesException),
    /// <p>The quota for the resource has already been reached.</p>
    /// <p>For information on resource and stack limitations, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/cloudformation-limits.html">CloudFormation quotas</a> in the <i>CloudFormation User Guide</i>.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>A client request token already exists.</p>
    TokenAlreadyExistsException(crate::error::TokenAlreadyExistsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateStackError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateStackErrorKind::AlreadyExistsException(_inner) => _inner.fmt(f),
            CreateStackErrorKind::InsufficientCapabilitiesException(_inner) => _inner.fmt(f),
            CreateStackErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            CreateStackErrorKind::TokenAlreadyExistsException(_inner) => _inner.fmt(f),
            CreateStackErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateStackError {
    fn code(&self) -> Option<&str> {
        CreateStackError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateStackError {
    /// Creates a new `CreateStackError`.
    pub fn new(kind: CreateStackErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateStackError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateStackErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateStackError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateStackErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateStackErrorKind::AlreadyExistsException`.
    pub fn is_already_exists_exception(&self) -> bool {
        matches!(&self.kind, CreateStackErrorKind::AlreadyExistsException(_))
    }
    /// Returns `true` if the error kind is `CreateStackErrorKind::InsufficientCapabilitiesException`.
    pub fn is_insufficient_capabilities_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateStackErrorKind::InsufficientCapabilitiesException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateStackErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(&self.kind, CreateStackErrorKind::LimitExceededException(_))
    }
    /// Returns `true` if the error kind is `CreateStackErrorKind::TokenAlreadyExistsException`.
    pub fn is_token_already_exists_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateStackErrorKind::TokenAlreadyExistsException(_)
        )
    }
}
impl std::error::Error for CreateStackError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateStackErrorKind::AlreadyExistsException(_inner) => Some(_inner),
            CreateStackErrorKind::InsufficientCapabilitiesException(_inner) => Some(_inner),
            CreateStackErrorKind::LimitExceededException(_inner) => Some(_inner),
            CreateStackErrorKind::TokenAlreadyExistsException(_inner) => Some(_inner),
            CreateStackErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateStackInstances` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateStackInstancesError {
    /// Kind of error that occurred.
    pub kind: CreateStackInstancesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateStackInstances` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateStackInstancesErrorKind {
    /// <p>The specified operation isn't valid.</p>
    InvalidOperationException(crate::error::InvalidOperationException),
    /// <p>The quota for the resource has already been reached.</p>
    /// <p>For information on resource and stack limitations, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/cloudformation-limits.html">CloudFormation quotas</a> in the <i>CloudFormation User Guide</i>.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The specified operation ID already exists.</p>
    OperationIdAlreadyExistsException(crate::error::OperationIdAlreadyExistsException),
    /// <p>Another operation is currently in progress for this stack set. Only one operation can be performed for a stack set at a given time.</p>
    OperationInProgressException(crate::error::OperationInProgressException),
    /// <p>The specified stack set doesn't exist.</p>
    StackSetNotFoundException(crate::error::StackSetNotFoundException),
    /// <p>Another operation has been performed on this stack set since the specified operation was performed.</p>
    StaleRequestException(crate::error::StaleRequestException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateStackInstancesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateStackInstancesErrorKind::InvalidOperationException(_inner) => _inner.fmt(f),
            CreateStackInstancesErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            CreateStackInstancesErrorKind::OperationIdAlreadyExistsException(_inner) => {
                _inner.fmt(f)
            }
            CreateStackInstancesErrorKind::OperationInProgressException(_inner) => _inner.fmt(f),
            CreateStackInstancesErrorKind::StackSetNotFoundException(_inner) => _inner.fmt(f),
            CreateStackInstancesErrorKind::StaleRequestException(_inner) => _inner.fmt(f),
            CreateStackInstancesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateStackInstancesError {
    fn code(&self) -> Option<&str> {
        CreateStackInstancesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateStackInstancesError {
    /// Creates a new `CreateStackInstancesError`.
    pub fn new(kind: CreateStackInstancesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateStackInstancesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateStackInstancesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateStackInstancesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateStackInstancesErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateStackInstancesErrorKind::InvalidOperationException`.
    pub fn is_invalid_operation_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateStackInstancesErrorKind::InvalidOperationException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateStackInstancesErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateStackInstancesErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateStackInstancesErrorKind::OperationIdAlreadyExistsException`.
    pub fn is_operation_id_already_exists_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateStackInstancesErrorKind::OperationIdAlreadyExistsException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateStackInstancesErrorKind::OperationInProgressException`.
    pub fn is_operation_in_progress_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateStackInstancesErrorKind::OperationInProgressException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateStackInstancesErrorKind::StackSetNotFoundException`.
    pub fn is_stack_set_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateStackInstancesErrorKind::StackSetNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateStackInstancesErrorKind::StaleRequestException`.
    pub fn is_stale_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateStackInstancesErrorKind::StaleRequestException(_)
        )
    }
}
impl std::error::Error for CreateStackInstancesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateStackInstancesErrorKind::InvalidOperationException(_inner) => Some(_inner),
            CreateStackInstancesErrorKind::LimitExceededException(_inner) => Some(_inner),
            CreateStackInstancesErrorKind::OperationIdAlreadyExistsException(_inner) => {
                Some(_inner)
            }
            CreateStackInstancesErrorKind::OperationInProgressException(_inner) => Some(_inner),
            CreateStackInstancesErrorKind::StackSetNotFoundException(_inner) => Some(_inner),
            CreateStackInstancesErrorKind::StaleRequestException(_inner) => Some(_inner),
            CreateStackInstancesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateStackSet` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateStackSetError {
    /// Kind of error that occurred.
    pub kind: CreateStackSetErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateStackSet` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateStackSetErrorKind {
    /// <p>The specified resource exists, but has been changed.</p>
    CreatedButModifiedException(crate::error::CreatedButModifiedException),
    /// <p>The quota for the resource has already been reached.</p>
    /// <p>For information on resource and stack limitations, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/cloudformation-limits.html">CloudFormation quotas</a> in the <i>CloudFormation User Guide</i>.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The specified name is already in use.</p>
    NameAlreadyExistsException(crate::error::NameAlreadyExistsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateStackSetError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateStackSetErrorKind::CreatedButModifiedException(_inner) => _inner.fmt(f),
            CreateStackSetErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            CreateStackSetErrorKind::NameAlreadyExistsException(_inner) => _inner.fmt(f),
            CreateStackSetErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateStackSetError {
    fn code(&self) -> Option<&str> {
        CreateStackSetError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateStackSetError {
    /// Creates a new `CreateStackSetError`.
    pub fn new(kind: CreateStackSetErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateStackSetError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateStackSetErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateStackSetError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateStackSetErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateStackSetErrorKind::CreatedButModifiedException`.
    pub fn is_created_but_modified_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateStackSetErrorKind::CreatedButModifiedException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateStackSetErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateStackSetErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateStackSetErrorKind::NameAlreadyExistsException`.
    pub fn is_name_already_exists_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateStackSetErrorKind::NameAlreadyExistsException(_)
        )
    }
}
impl std::error::Error for CreateStackSetError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateStackSetErrorKind::CreatedButModifiedException(_inner) => Some(_inner),
            CreateStackSetErrorKind::LimitExceededException(_inner) => Some(_inner),
            CreateStackSetErrorKind::NameAlreadyExistsException(_inner) => Some(_inner),
            CreateStackSetErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeactivateType` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeactivateTypeError {
    /// Kind of error that occurred.
    pub kind: DeactivateTypeErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeactivateType` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeactivateTypeErrorKind {
    /// <p>An error occurred during a CloudFormation registry operation.</p>
    CfnRegistryException(crate::error::CfnRegistryException),
    /// <p>The specified extension doesn't exist in the CloudFormation registry.</p>
    TypeNotFoundException(crate::error::TypeNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeactivateTypeError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeactivateTypeErrorKind::CfnRegistryException(_inner) => _inner.fmt(f),
            DeactivateTypeErrorKind::TypeNotFoundException(_inner) => _inner.fmt(f),
            DeactivateTypeErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeactivateTypeError {
    fn code(&self) -> Option<&str> {
        DeactivateTypeError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeactivateTypeError {
    /// Creates a new `DeactivateTypeError`.
    pub fn new(kind: DeactivateTypeErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeactivateTypeError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeactivateTypeErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeactivateTypeError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeactivateTypeErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeactivateTypeErrorKind::CfnRegistryException`.
    pub fn is_cfn_registry_exception(&self) -> bool {
        matches!(&self.kind, DeactivateTypeErrorKind::CfnRegistryException(_))
    }
    /// Returns `true` if the error kind is `DeactivateTypeErrorKind::TypeNotFoundException`.
    pub fn is_type_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeactivateTypeErrorKind::TypeNotFoundException(_)
        )
    }
}
impl std::error::Error for DeactivateTypeError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeactivateTypeErrorKind::CfnRegistryException(_inner) => Some(_inner),
            DeactivateTypeErrorKind::TypeNotFoundException(_inner) => Some(_inner),
            DeactivateTypeErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteChangeSet` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteChangeSetError {
    /// Kind of error that occurred.
    pub kind: DeleteChangeSetErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteChangeSet` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteChangeSetErrorKind {
    /// <p>The specified change set can't be used to update the stack. For example, the change set status might be <code>CREATE_IN_PROGRESS</code>, or the stack status might be <code>UPDATE_IN_PROGRESS</code>.</p>
    InvalidChangeSetStatusException(crate::error::InvalidChangeSetStatusException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteChangeSetError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteChangeSetErrorKind::InvalidChangeSetStatusException(_inner) => _inner.fmt(f),
            DeleteChangeSetErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteChangeSetError {
    fn code(&self) -> Option<&str> {
        DeleteChangeSetError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteChangeSetError {
    /// Creates a new `DeleteChangeSetError`.
    pub fn new(kind: DeleteChangeSetErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteChangeSetError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteChangeSetErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteChangeSetError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteChangeSetErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteChangeSetErrorKind::InvalidChangeSetStatusException`.
    pub fn is_invalid_change_set_status_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteChangeSetErrorKind::InvalidChangeSetStatusException(_)
        )
    }
}
impl std::error::Error for DeleteChangeSetError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteChangeSetErrorKind::InvalidChangeSetStatusException(_inner) => Some(_inner),
            DeleteChangeSetErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteStack` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteStackError {
    /// Kind of error that occurred.
    pub kind: DeleteStackErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteStack` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteStackErrorKind {
    /// <p>A client request token already exists.</p>
    TokenAlreadyExistsException(crate::error::TokenAlreadyExistsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteStackError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteStackErrorKind::TokenAlreadyExistsException(_inner) => _inner.fmt(f),
            DeleteStackErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteStackError {
    fn code(&self) -> Option<&str> {
        DeleteStackError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteStackError {
    /// Creates a new `DeleteStackError`.
    pub fn new(kind: DeleteStackErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteStackError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteStackErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteStackError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteStackErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteStackErrorKind::TokenAlreadyExistsException`.
    pub fn is_token_already_exists_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteStackErrorKind::TokenAlreadyExistsException(_)
        )
    }
}
impl std::error::Error for DeleteStackError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteStackErrorKind::TokenAlreadyExistsException(_inner) => Some(_inner),
            DeleteStackErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteStackInstances` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteStackInstancesError {
    /// Kind of error that occurred.
    pub kind: DeleteStackInstancesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteStackInstances` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteStackInstancesErrorKind {
    /// <p>The specified operation isn't valid.</p>
    InvalidOperationException(crate::error::InvalidOperationException),
    /// <p>The specified operation ID already exists.</p>
    OperationIdAlreadyExistsException(crate::error::OperationIdAlreadyExistsException),
    /// <p>Another operation is currently in progress for this stack set. Only one operation can be performed for a stack set at a given time.</p>
    OperationInProgressException(crate::error::OperationInProgressException),
    /// <p>The specified stack set doesn't exist.</p>
    StackSetNotFoundException(crate::error::StackSetNotFoundException),
    /// <p>Another operation has been performed on this stack set since the specified operation was performed.</p>
    StaleRequestException(crate::error::StaleRequestException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteStackInstancesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteStackInstancesErrorKind::InvalidOperationException(_inner) => _inner.fmt(f),
            DeleteStackInstancesErrorKind::OperationIdAlreadyExistsException(_inner) => {
                _inner.fmt(f)
            }
            DeleteStackInstancesErrorKind::OperationInProgressException(_inner) => _inner.fmt(f),
            DeleteStackInstancesErrorKind::StackSetNotFoundException(_inner) => _inner.fmt(f),
            DeleteStackInstancesErrorKind::StaleRequestException(_inner) => _inner.fmt(f),
            DeleteStackInstancesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteStackInstancesError {
    fn code(&self) -> Option<&str> {
        DeleteStackInstancesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteStackInstancesError {
    /// Creates a new `DeleteStackInstancesError`.
    pub fn new(kind: DeleteStackInstancesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteStackInstancesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteStackInstancesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteStackInstancesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteStackInstancesErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteStackInstancesErrorKind::InvalidOperationException`.
    pub fn is_invalid_operation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteStackInstancesErrorKind::InvalidOperationException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteStackInstancesErrorKind::OperationIdAlreadyExistsException`.
    pub fn is_operation_id_already_exists_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteStackInstancesErrorKind::OperationIdAlreadyExistsException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteStackInstancesErrorKind::OperationInProgressException`.
    pub fn is_operation_in_progress_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteStackInstancesErrorKind::OperationInProgressException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteStackInstancesErrorKind::StackSetNotFoundException`.
    pub fn is_stack_set_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteStackInstancesErrorKind::StackSetNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteStackInstancesErrorKind::StaleRequestException`.
    pub fn is_stale_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteStackInstancesErrorKind::StaleRequestException(_)
        )
    }
}
impl std::error::Error for DeleteStackInstancesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteStackInstancesErrorKind::InvalidOperationException(_inner) => Some(_inner),
            DeleteStackInstancesErrorKind::OperationIdAlreadyExistsException(_inner) => {
                Some(_inner)
            }
            DeleteStackInstancesErrorKind::OperationInProgressException(_inner) => Some(_inner),
            DeleteStackInstancesErrorKind::StackSetNotFoundException(_inner) => Some(_inner),
            DeleteStackInstancesErrorKind::StaleRequestException(_inner) => Some(_inner),
            DeleteStackInstancesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteStackSet` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteStackSetError {
    /// Kind of error that occurred.
    pub kind: DeleteStackSetErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteStackSet` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteStackSetErrorKind {
    /// <p>Another operation is currently in progress for this stack set. Only one operation can be performed for a stack set at a given time.</p>
    OperationInProgressException(crate::error::OperationInProgressException),
    /// <p>You can't yet delete this stack set, because it still contains one or more stack instances. Delete all stack instances from the stack set before deleting the stack set.</p>
    StackSetNotEmptyException(crate::error::StackSetNotEmptyException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteStackSetError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteStackSetErrorKind::OperationInProgressException(_inner) => _inner.fmt(f),
            DeleteStackSetErrorKind::StackSetNotEmptyException(_inner) => _inner.fmt(f),
            DeleteStackSetErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteStackSetError {
    fn code(&self) -> Option<&str> {
        DeleteStackSetError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteStackSetError {
    /// Creates a new `DeleteStackSetError`.
    pub fn new(kind: DeleteStackSetErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteStackSetError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteStackSetErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteStackSetError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteStackSetErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteStackSetErrorKind::OperationInProgressException`.
    pub fn is_operation_in_progress_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteStackSetErrorKind::OperationInProgressException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteStackSetErrorKind::StackSetNotEmptyException`.
    pub fn is_stack_set_not_empty_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteStackSetErrorKind::StackSetNotEmptyException(_)
        )
    }
}
impl std::error::Error for DeleteStackSetError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteStackSetErrorKind::OperationInProgressException(_inner) => Some(_inner),
            DeleteStackSetErrorKind::StackSetNotEmptyException(_inner) => Some(_inner),
            DeleteStackSetErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeregisterType` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeregisterTypeError {
    /// Kind of error that occurred.
    pub kind: DeregisterTypeErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeregisterType` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeregisterTypeErrorKind {
    /// <p>An error occurred during a CloudFormation registry operation.</p>
    CfnRegistryException(crate::error::CfnRegistryException),
    /// <p>The specified extension doesn't exist in the CloudFormation registry.</p>
    TypeNotFoundException(crate::error::TypeNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeregisterTypeError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeregisterTypeErrorKind::CfnRegistryException(_inner) => _inner.fmt(f),
            DeregisterTypeErrorKind::TypeNotFoundException(_inner) => _inner.fmt(f),
            DeregisterTypeErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeregisterTypeError {
    fn code(&self) -> Option<&str> {
        DeregisterTypeError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeregisterTypeError {
    /// Creates a new `DeregisterTypeError`.
    pub fn new(kind: DeregisterTypeErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeregisterTypeError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeregisterTypeErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeregisterTypeError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeregisterTypeErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeregisterTypeErrorKind::CfnRegistryException`.
    pub fn is_cfn_registry_exception(&self) -> bool {
        matches!(&self.kind, DeregisterTypeErrorKind::CfnRegistryException(_))
    }
    /// Returns `true` if the error kind is `DeregisterTypeErrorKind::TypeNotFoundException`.
    pub fn is_type_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeregisterTypeErrorKind::TypeNotFoundException(_)
        )
    }
}
impl std::error::Error for DeregisterTypeError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeregisterTypeErrorKind::CfnRegistryException(_inner) => Some(_inner),
            DeregisterTypeErrorKind::TypeNotFoundException(_inner) => Some(_inner),
            DeregisterTypeErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeAccountLimits` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeAccountLimitsError {
    /// Kind of error that occurred.
    pub kind: DescribeAccountLimitsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeAccountLimits` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeAccountLimitsErrorKind {
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeAccountLimitsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeAccountLimitsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeAccountLimitsError {
    fn code(&self) -> Option<&str> {
        DescribeAccountLimitsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeAccountLimitsError {
    /// Creates a new `DescribeAccountLimitsError`.
    pub fn new(kind: DescribeAccountLimitsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeAccountLimitsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeAccountLimitsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeAccountLimitsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeAccountLimitsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
}
impl std::error::Error for DescribeAccountLimitsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeAccountLimitsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeChangeSet` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeChangeSetError {
    /// Kind of error that occurred.
    pub kind: DescribeChangeSetErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeChangeSet` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeChangeSetErrorKind {
    /// <p>The specified change set name or ID doesn't exit. To view valid change sets for a stack, use the <code>ListChangeSets</code> operation.</p>
    ChangeSetNotFoundException(crate::error::ChangeSetNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeChangeSetError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeChangeSetErrorKind::ChangeSetNotFoundException(_inner) => _inner.fmt(f),
            DescribeChangeSetErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeChangeSetError {
    fn code(&self) -> Option<&str> {
        DescribeChangeSetError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeChangeSetError {
    /// Creates a new `DescribeChangeSetError`.
    pub fn new(kind: DescribeChangeSetErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeChangeSetError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeChangeSetErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeChangeSetError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeChangeSetErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeChangeSetErrorKind::ChangeSetNotFoundException`.
    pub fn is_change_set_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeChangeSetErrorKind::ChangeSetNotFoundException(_)
        )
    }
}
impl std::error::Error for DescribeChangeSetError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeChangeSetErrorKind::ChangeSetNotFoundException(_inner) => Some(_inner),
            DescribeChangeSetErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeChangeSetHooks` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeChangeSetHooksError {
    /// Kind of error that occurred.
    pub kind: DescribeChangeSetHooksErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeChangeSetHooks` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeChangeSetHooksErrorKind {
    /// <p>The specified change set name or ID doesn't exit. To view valid change sets for a stack, use the <code>ListChangeSets</code> operation.</p>
    ChangeSetNotFoundException(crate::error::ChangeSetNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeChangeSetHooksError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeChangeSetHooksErrorKind::ChangeSetNotFoundException(_inner) => _inner.fmt(f),
            DescribeChangeSetHooksErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeChangeSetHooksError {
    fn code(&self) -> Option<&str> {
        DescribeChangeSetHooksError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeChangeSetHooksError {
    /// Creates a new `DescribeChangeSetHooksError`.
    pub fn new(kind: DescribeChangeSetHooksErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeChangeSetHooksError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeChangeSetHooksErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeChangeSetHooksError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeChangeSetHooksErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeChangeSetHooksErrorKind::ChangeSetNotFoundException`.
    pub fn is_change_set_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeChangeSetHooksErrorKind::ChangeSetNotFoundException(_)
        )
    }
}
impl std::error::Error for DescribeChangeSetHooksError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeChangeSetHooksErrorKind::ChangeSetNotFoundException(_inner) => Some(_inner),
            DescribeChangeSetHooksErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribePublisher` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribePublisherError {
    /// Kind of error that occurred.
    pub kind: DescribePublisherErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribePublisher` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribePublisherErrorKind {
    /// <p>An error occurred during a CloudFormation registry operation.</p>
    CfnRegistryException(crate::error::CfnRegistryException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribePublisherError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribePublisherErrorKind::CfnRegistryException(_inner) => _inner.fmt(f),
            DescribePublisherErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribePublisherError {
    fn code(&self) -> Option<&str> {
        DescribePublisherError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribePublisherError {
    /// Creates a new `DescribePublisherError`.
    pub fn new(kind: DescribePublisherErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribePublisherError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribePublisherErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribePublisherError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribePublisherErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribePublisherErrorKind::CfnRegistryException`.
    pub fn is_cfn_registry_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribePublisherErrorKind::CfnRegistryException(_)
        )
    }
}
impl std::error::Error for DescribePublisherError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribePublisherErrorKind::CfnRegistryException(_inner) => Some(_inner),
            DescribePublisherErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeStackDriftDetectionStatus` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeStackDriftDetectionStatusError {
    /// Kind of error that occurred.
    pub kind: DescribeStackDriftDetectionStatusErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeStackDriftDetectionStatus` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeStackDriftDetectionStatusErrorKind {
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeStackDriftDetectionStatusError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeStackDriftDetectionStatusErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeStackDriftDetectionStatusError {
    fn code(&self) -> Option<&str> {
        DescribeStackDriftDetectionStatusError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeStackDriftDetectionStatusError {
    /// Creates a new `DescribeStackDriftDetectionStatusError`.
    pub fn new(
        kind: DescribeStackDriftDetectionStatusErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeStackDriftDetectionStatusError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeStackDriftDetectionStatusErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeStackDriftDetectionStatusError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeStackDriftDetectionStatusErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
}
impl std::error::Error for DescribeStackDriftDetectionStatusError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeStackDriftDetectionStatusErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeStackEvents` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeStackEventsError {
    /// Kind of error that occurred.
    pub kind: DescribeStackEventsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeStackEvents` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeStackEventsErrorKind {
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeStackEventsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeStackEventsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeStackEventsError {
    fn code(&self) -> Option<&str> {
        DescribeStackEventsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeStackEventsError {
    /// Creates a new `DescribeStackEventsError`.
    pub fn new(kind: DescribeStackEventsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeStackEventsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeStackEventsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeStackEventsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeStackEventsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
}
impl std::error::Error for DescribeStackEventsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeStackEventsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeStackInstance` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeStackInstanceError {
    /// Kind of error that occurred.
    pub kind: DescribeStackInstanceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeStackInstance` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeStackInstanceErrorKind {
    /// <p>The specified stack instance doesn't exist.</p>
    StackInstanceNotFoundException(crate::error::StackInstanceNotFoundException),
    /// <p>The specified stack set doesn't exist.</p>
    StackSetNotFoundException(crate::error::StackSetNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeStackInstanceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeStackInstanceErrorKind::StackInstanceNotFoundException(_inner) => _inner.fmt(f),
            DescribeStackInstanceErrorKind::StackSetNotFoundException(_inner) => _inner.fmt(f),
            DescribeStackInstanceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeStackInstanceError {
    fn code(&self) -> Option<&str> {
        DescribeStackInstanceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeStackInstanceError {
    /// Creates a new `DescribeStackInstanceError`.
    pub fn new(kind: DescribeStackInstanceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeStackInstanceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeStackInstanceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeStackInstanceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeStackInstanceErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeStackInstanceErrorKind::StackInstanceNotFoundException`.
    pub fn is_stack_instance_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeStackInstanceErrorKind::StackInstanceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeStackInstanceErrorKind::StackSetNotFoundException`.
    pub fn is_stack_set_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeStackInstanceErrorKind::StackSetNotFoundException(_)
        )
    }
}
impl std::error::Error for DescribeStackInstanceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeStackInstanceErrorKind::StackInstanceNotFoundException(_inner) => Some(_inner),
            DescribeStackInstanceErrorKind::StackSetNotFoundException(_inner) => Some(_inner),
            DescribeStackInstanceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeStackResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeStackResourceError {
    /// Kind of error that occurred.
    pub kind: DescribeStackResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeStackResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeStackResourceErrorKind {
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeStackResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeStackResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeStackResourceError {
    fn code(&self) -> Option<&str> {
        DescribeStackResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeStackResourceError {
    /// Creates a new `DescribeStackResourceError`.
    pub fn new(kind: DescribeStackResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeStackResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeStackResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeStackResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeStackResourceErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
}
impl std::error::Error for DescribeStackResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeStackResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeStackResourceDrifts` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeStackResourceDriftsError {
    /// Kind of error that occurred.
    pub kind: DescribeStackResourceDriftsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeStackResourceDrifts` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeStackResourceDriftsErrorKind {
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeStackResourceDriftsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeStackResourceDriftsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeStackResourceDriftsError {
    fn code(&self) -> Option<&str> {
        DescribeStackResourceDriftsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeStackResourceDriftsError {
    /// Creates a new `DescribeStackResourceDriftsError`.
    pub fn new(kind: DescribeStackResourceDriftsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeStackResourceDriftsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeStackResourceDriftsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeStackResourceDriftsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeStackResourceDriftsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
}
impl std::error::Error for DescribeStackResourceDriftsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeStackResourceDriftsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeStackResources` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeStackResourcesError {
    /// Kind of error that occurred.
    pub kind: DescribeStackResourcesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeStackResources` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeStackResourcesErrorKind {
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeStackResourcesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeStackResourcesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeStackResourcesError {
    fn code(&self) -> Option<&str> {
        DescribeStackResourcesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeStackResourcesError {
    /// Creates a new `DescribeStackResourcesError`.
    pub fn new(kind: DescribeStackResourcesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeStackResourcesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeStackResourcesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeStackResourcesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeStackResourcesErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
}
impl std::error::Error for DescribeStackResourcesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeStackResourcesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeStacks` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeStacksError {
    /// Kind of error that occurred.
    pub kind: DescribeStacksErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeStacks` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeStacksErrorKind {
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeStacksError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeStacksErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeStacksError {
    fn code(&self) -> Option<&str> {
        DescribeStacksError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeStacksError {
    /// Creates a new `DescribeStacksError`.
    pub fn new(kind: DescribeStacksErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeStacksError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeStacksErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeStacksError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeStacksErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
}
impl std::error::Error for DescribeStacksError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeStacksErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeStackSet` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeStackSetError {
    /// Kind of error that occurred.
    pub kind: DescribeStackSetErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeStackSet` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeStackSetErrorKind {
    /// <p>The specified stack set doesn't exist.</p>
    StackSetNotFoundException(crate::error::StackSetNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeStackSetError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeStackSetErrorKind::StackSetNotFoundException(_inner) => _inner.fmt(f),
            DescribeStackSetErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeStackSetError {
    fn code(&self) -> Option<&str> {
        DescribeStackSetError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeStackSetError {
    /// Creates a new `DescribeStackSetError`.
    pub fn new(kind: DescribeStackSetErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeStackSetError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeStackSetErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeStackSetError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeStackSetErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeStackSetErrorKind::StackSetNotFoundException`.
    pub fn is_stack_set_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeStackSetErrorKind::StackSetNotFoundException(_)
        )
    }
}
impl std::error::Error for DescribeStackSetError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeStackSetErrorKind::StackSetNotFoundException(_inner) => Some(_inner),
            DescribeStackSetErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeStackSetOperation` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeStackSetOperationError {
    /// Kind of error that occurred.
    pub kind: DescribeStackSetOperationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeStackSetOperation` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeStackSetOperationErrorKind {
    /// <p>The specified ID refers to an operation that doesn't exist.</p>
    OperationNotFoundException(crate::error::OperationNotFoundException),
    /// <p>The specified stack set doesn't exist.</p>
    StackSetNotFoundException(crate::error::StackSetNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeStackSetOperationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeStackSetOperationErrorKind::OperationNotFoundException(_inner) => _inner.fmt(f),
            DescribeStackSetOperationErrorKind::StackSetNotFoundException(_inner) => _inner.fmt(f),
            DescribeStackSetOperationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeStackSetOperationError {
    fn code(&self) -> Option<&str> {
        DescribeStackSetOperationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeStackSetOperationError {
    /// Creates a new `DescribeStackSetOperationError`.
    pub fn new(kind: DescribeStackSetOperationErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeStackSetOperationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeStackSetOperationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeStackSetOperationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeStackSetOperationErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeStackSetOperationErrorKind::OperationNotFoundException`.
    pub fn is_operation_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeStackSetOperationErrorKind::OperationNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeStackSetOperationErrorKind::StackSetNotFoundException`.
    pub fn is_stack_set_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeStackSetOperationErrorKind::StackSetNotFoundException(_)
        )
    }
}
impl std::error::Error for DescribeStackSetOperationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeStackSetOperationErrorKind::OperationNotFoundException(_inner) => Some(_inner),
            DescribeStackSetOperationErrorKind::StackSetNotFoundException(_inner) => Some(_inner),
            DescribeStackSetOperationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeType` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeTypeError {
    /// Kind of error that occurred.
    pub kind: DescribeTypeErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeType` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeTypeErrorKind {
    /// <p>An error occurred during a CloudFormation registry operation.</p>
    CfnRegistryException(crate::error::CfnRegistryException),
    /// <p>The specified extension doesn't exist in the CloudFormation registry.</p>
    TypeNotFoundException(crate::error::TypeNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeTypeError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeTypeErrorKind::CfnRegistryException(_inner) => _inner.fmt(f),
            DescribeTypeErrorKind::TypeNotFoundException(_inner) => _inner.fmt(f),
            DescribeTypeErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeTypeError {
    fn code(&self) -> Option<&str> {
        DescribeTypeError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeTypeError {
    /// Creates a new `DescribeTypeError`.
    pub fn new(kind: DescribeTypeErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeTypeError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeTypeErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeTypeError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeTypeErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeTypeErrorKind::CfnRegistryException`.
    pub fn is_cfn_registry_exception(&self) -> bool {
        matches!(&self.kind, DescribeTypeErrorKind::CfnRegistryException(_))
    }
    /// Returns `true` if the error kind is `DescribeTypeErrorKind::TypeNotFoundException`.
    pub fn is_type_not_found_exception(&self) -> bool {
        matches!(&self.kind, DescribeTypeErrorKind::TypeNotFoundException(_))
    }
}
impl std::error::Error for DescribeTypeError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeTypeErrorKind::CfnRegistryException(_inner) => Some(_inner),
            DescribeTypeErrorKind::TypeNotFoundException(_inner) => Some(_inner),
            DescribeTypeErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeTypeRegistration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeTypeRegistrationError {
    /// Kind of error that occurred.
    pub kind: DescribeTypeRegistrationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeTypeRegistration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeTypeRegistrationErrorKind {
    /// <p>An error occurred during a CloudFormation registry operation.</p>
    CfnRegistryException(crate::error::CfnRegistryException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeTypeRegistrationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeTypeRegistrationErrorKind::CfnRegistryException(_inner) => _inner.fmt(f),
            DescribeTypeRegistrationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeTypeRegistrationError {
    fn code(&self) -> Option<&str> {
        DescribeTypeRegistrationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeTypeRegistrationError {
    /// Creates a new `DescribeTypeRegistrationError`.
    pub fn new(kind: DescribeTypeRegistrationErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeTypeRegistrationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeTypeRegistrationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeTypeRegistrationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeTypeRegistrationErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeTypeRegistrationErrorKind::CfnRegistryException`.
    pub fn is_cfn_registry_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeTypeRegistrationErrorKind::CfnRegistryException(_)
        )
    }
}
impl std::error::Error for DescribeTypeRegistrationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeTypeRegistrationErrorKind::CfnRegistryException(_inner) => Some(_inner),
            DescribeTypeRegistrationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DetectStackDrift` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DetectStackDriftError {
    /// Kind of error that occurred.
    pub kind: DetectStackDriftErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DetectStackDrift` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DetectStackDriftErrorKind {
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DetectStackDriftError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DetectStackDriftErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DetectStackDriftError {
    fn code(&self) -> Option<&str> {
        DetectStackDriftError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DetectStackDriftError {
    /// Creates a new `DetectStackDriftError`.
    pub fn new(kind: DetectStackDriftErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DetectStackDriftError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DetectStackDriftErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DetectStackDriftError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DetectStackDriftErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
}
impl std::error::Error for DetectStackDriftError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DetectStackDriftErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DetectStackResourceDrift` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DetectStackResourceDriftError {
    /// Kind of error that occurred.
    pub kind: DetectStackResourceDriftErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DetectStackResourceDrift` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DetectStackResourceDriftErrorKind {
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DetectStackResourceDriftError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DetectStackResourceDriftErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DetectStackResourceDriftError {
    fn code(&self) -> Option<&str> {
        DetectStackResourceDriftError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DetectStackResourceDriftError {
    /// Creates a new `DetectStackResourceDriftError`.
    pub fn new(kind: DetectStackResourceDriftErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DetectStackResourceDriftError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DetectStackResourceDriftErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DetectStackResourceDriftError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DetectStackResourceDriftErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
}
impl std::error::Error for DetectStackResourceDriftError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DetectStackResourceDriftErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DetectStackSetDrift` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DetectStackSetDriftError {
    /// Kind of error that occurred.
    pub kind: DetectStackSetDriftErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DetectStackSetDrift` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DetectStackSetDriftErrorKind {
    /// <p>The specified operation isn't valid.</p>
    InvalidOperationException(crate::error::InvalidOperationException),
    /// <p>Another operation is currently in progress for this stack set. Only one operation can be performed for a stack set at a given time.</p>
    OperationInProgressException(crate::error::OperationInProgressException),
    /// <p>The specified stack set doesn't exist.</p>
    StackSetNotFoundException(crate::error::StackSetNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DetectStackSetDriftError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DetectStackSetDriftErrorKind::InvalidOperationException(_inner) => _inner.fmt(f),
            DetectStackSetDriftErrorKind::OperationInProgressException(_inner) => _inner.fmt(f),
            DetectStackSetDriftErrorKind::StackSetNotFoundException(_inner) => _inner.fmt(f),
            DetectStackSetDriftErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DetectStackSetDriftError {
    fn code(&self) -> Option<&str> {
        DetectStackSetDriftError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DetectStackSetDriftError {
    /// Creates a new `DetectStackSetDriftError`.
    pub fn new(kind: DetectStackSetDriftErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DetectStackSetDriftError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DetectStackSetDriftErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DetectStackSetDriftError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DetectStackSetDriftErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DetectStackSetDriftErrorKind::InvalidOperationException`.
    pub fn is_invalid_operation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DetectStackSetDriftErrorKind::InvalidOperationException(_)
        )
    }
    /// Returns `true` if the error kind is `DetectStackSetDriftErrorKind::OperationInProgressException`.
    pub fn is_operation_in_progress_exception(&self) -> bool {
        matches!(
            &self.kind,
            DetectStackSetDriftErrorKind::OperationInProgressException(_)
        )
    }
    /// Returns `true` if the error kind is `DetectStackSetDriftErrorKind::StackSetNotFoundException`.
    pub fn is_stack_set_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DetectStackSetDriftErrorKind::StackSetNotFoundException(_)
        )
    }
}
impl std::error::Error for DetectStackSetDriftError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DetectStackSetDriftErrorKind::InvalidOperationException(_inner) => Some(_inner),
            DetectStackSetDriftErrorKind::OperationInProgressException(_inner) => Some(_inner),
            DetectStackSetDriftErrorKind::StackSetNotFoundException(_inner) => Some(_inner),
            DetectStackSetDriftErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `EstimateTemplateCost` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct EstimateTemplateCostError {
    /// Kind of error that occurred.
    pub kind: EstimateTemplateCostErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `EstimateTemplateCost` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum EstimateTemplateCostErrorKind {
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for EstimateTemplateCostError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            EstimateTemplateCostErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for EstimateTemplateCostError {
    fn code(&self) -> Option<&str> {
        EstimateTemplateCostError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl EstimateTemplateCostError {
    /// Creates a new `EstimateTemplateCostError`.
    pub fn new(kind: EstimateTemplateCostErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `EstimateTemplateCostError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: EstimateTemplateCostErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `EstimateTemplateCostError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: EstimateTemplateCostErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
}
impl std::error::Error for EstimateTemplateCostError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            EstimateTemplateCostErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ExecuteChangeSet` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ExecuteChangeSetError {
    /// Kind of error that occurred.
    pub kind: ExecuteChangeSetErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ExecuteChangeSet` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ExecuteChangeSetErrorKind {
    /// <p>The specified change set name or ID doesn't exit. To view valid change sets for a stack, use the <code>ListChangeSets</code> operation.</p>
    ChangeSetNotFoundException(crate::error::ChangeSetNotFoundException),
    /// <p>The template contains resources with capabilities that weren't specified in the Capabilities parameter.</p>
    InsufficientCapabilitiesException(crate::error::InsufficientCapabilitiesException),
    /// <p>The specified change set can't be used to update the stack. For example, the change set status might be <code>CREATE_IN_PROGRESS</code>, or the stack status might be <code>UPDATE_IN_PROGRESS</code>.</p>
    InvalidChangeSetStatusException(crate::error::InvalidChangeSetStatusException),
    /// <p>A client request token already exists.</p>
    TokenAlreadyExistsException(crate::error::TokenAlreadyExistsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ExecuteChangeSetError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ExecuteChangeSetErrorKind::ChangeSetNotFoundException(_inner) => _inner.fmt(f),
            ExecuteChangeSetErrorKind::InsufficientCapabilitiesException(_inner) => _inner.fmt(f),
            ExecuteChangeSetErrorKind::InvalidChangeSetStatusException(_inner) => _inner.fmt(f),
            ExecuteChangeSetErrorKind::TokenAlreadyExistsException(_inner) => _inner.fmt(f),
            ExecuteChangeSetErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ExecuteChangeSetError {
    fn code(&self) -> Option<&str> {
        ExecuteChangeSetError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ExecuteChangeSetError {
    /// Creates a new `ExecuteChangeSetError`.
    pub fn new(kind: ExecuteChangeSetErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ExecuteChangeSetError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ExecuteChangeSetErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ExecuteChangeSetError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ExecuteChangeSetErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ExecuteChangeSetErrorKind::ChangeSetNotFoundException`.
    pub fn is_change_set_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ExecuteChangeSetErrorKind::ChangeSetNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ExecuteChangeSetErrorKind::InsufficientCapabilitiesException`.
    pub fn is_insufficient_capabilities_exception(&self) -> bool {
        matches!(
            &self.kind,
            ExecuteChangeSetErrorKind::InsufficientCapabilitiesException(_)
        )
    }
    /// Returns `true` if the error kind is `ExecuteChangeSetErrorKind::InvalidChangeSetStatusException`.
    pub fn is_invalid_change_set_status_exception(&self) -> bool {
        matches!(
            &self.kind,
            ExecuteChangeSetErrorKind::InvalidChangeSetStatusException(_)
        )
    }
    /// Returns `true` if the error kind is `ExecuteChangeSetErrorKind::TokenAlreadyExistsException`.
    pub fn is_token_already_exists_exception(&self) -> bool {
        matches!(
            &self.kind,
            ExecuteChangeSetErrorKind::TokenAlreadyExistsException(_)
        )
    }
}
impl std::error::Error for ExecuteChangeSetError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ExecuteChangeSetErrorKind::ChangeSetNotFoundException(_inner) => Some(_inner),
            ExecuteChangeSetErrorKind::InsufficientCapabilitiesException(_inner) => Some(_inner),
            ExecuteChangeSetErrorKind::InvalidChangeSetStatusException(_inner) => Some(_inner),
            ExecuteChangeSetErrorKind::TokenAlreadyExistsException(_inner) => Some(_inner),
            ExecuteChangeSetErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetStackPolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetStackPolicyError {
    /// Kind of error that occurred.
    pub kind: GetStackPolicyErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetStackPolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetStackPolicyErrorKind {
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetStackPolicyError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetStackPolicyErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetStackPolicyError {
    fn code(&self) -> Option<&str> {
        GetStackPolicyError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetStackPolicyError {
    /// Creates a new `GetStackPolicyError`.
    pub fn new(kind: GetStackPolicyErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetStackPolicyError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetStackPolicyErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetStackPolicyError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetStackPolicyErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
}
impl std::error::Error for GetStackPolicyError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetStackPolicyErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetTemplate` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetTemplateError {
    /// Kind of error that occurred.
    pub kind: GetTemplateErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetTemplate` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetTemplateErrorKind {
    /// <p>The specified change set name or ID doesn't exit. To view valid change sets for a stack, use the <code>ListChangeSets</code> operation.</p>
    ChangeSetNotFoundException(crate::error::ChangeSetNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetTemplateError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetTemplateErrorKind::ChangeSetNotFoundException(_inner) => _inner.fmt(f),
            GetTemplateErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetTemplateError {
    fn code(&self) -> Option<&str> {
        GetTemplateError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetTemplateError {
    /// Creates a new `GetTemplateError`.
    pub fn new(kind: GetTemplateErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetTemplateError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetTemplateErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetTemplateError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetTemplateErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetTemplateErrorKind::ChangeSetNotFoundException`.
    pub fn is_change_set_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetTemplateErrorKind::ChangeSetNotFoundException(_)
        )
    }
}
impl std::error::Error for GetTemplateError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetTemplateErrorKind::ChangeSetNotFoundException(_inner) => Some(_inner),
            GetTemplateErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetTemplateSummary` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetTemplateSummaryError {
    /// Kind of error that occurred.
    pub kind: GetTemplateSummaryErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetTemplateSummary` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetTemplateSummaryErrorKind {
    /// <p>The specified stack set doesn't exist.</p>
    StackSetNotFoundException(crate::error::StackSetNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetTemplateSummaryError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetTemplateSummaryErrorKind::StackSetNotFoundException(_inner) => _inner.fmt(f),
            GetTemplateSummaryErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetTemplateSummaryError {
    fn code(&self) -> Option<&str> {
        GetTemplateSummaryError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetTemplateSummaryError {
    /// Creates a new `GetTemplateSummaryError`.
    pub fn new(kind: GetTemplateSummaryErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetTemplateSummaryError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetTemplateSummaryErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetTemplateSummaryError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetTemplateSummaryErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetTemplateSummaryErrorKind::StackSetNotFoundException`.
    pub fn is_stack_set_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetTemplateSummaryErrorKind::StackSetNotFoundException(_)
        )
    }
}
impl std::error::Error for GetTemplateSummaryError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetTemplateSummaryErrorKind::StackSetNotFoundException(_inner) => Some(_inner),
            GetTemplateSummaryErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ImportStacksToStackSet` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ImportStacksToStackSetError {
    /// Kind of error that occurred.
    pub kind: ImportStacksToStackSetErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ImportStacksToStackSet` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ImportStacksToStackSetErrorKind {
    /// <p>The specified operation isn't valid.</p>
    InvalidOperationException(crate::error::InvalidOperationException),
    /// <p>The quota for the resource has already been reached.</p>
    /// <p>For information on resource and stack limitations, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/cloudformation-limits.html">CloudFormation quotas</a> in the <i>CloudFormation User Guide</i>.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The specified operation ID already exists.</p>
    OperationIdAlreadyExistsException(crate::error::OperationIdAlreadyExistsException),
    /// <p>Another operation is currently in progress for this stack set. Only one operation can be performed for a stack set at a given time.</p>
    OperationInProgressException(crate::error::OperationInProgressException),
    /// <p>The specified stack ARN doesn't exist or stack doesn't exist corresponding to the ARN in input.</p>
    StackNotFoundException(crate::error::StackNotFoundException),
    /// <p>The specified stack set doesn't exist.</p>
    StackSetNotFoundException(crate::error::StackSetNotFoundException),
    /// <p>Another operation has been performed on this stack set since the specified operation was performed.</p>
    StaleRequestException(crate::error::StaleRequestException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ImportStacksToStackSetError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ImportStacksToStackSetErrorKind::InvalidOperationException(_inner) => _inner.fmt(f),
            ImportStacksToStackSetErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            ImportStacksToStackSetErrorKind::OperationIdAlreadyExistsException(_inner) => {
                _inner.fmt(f)
            }
            ImportStacksToStackSetErrorKind::OperationInProgressException(_inner) => _inner.fmt(f),
            ImportStacksToStackSetErrorKind::StackNotFoundException(_inner) => _inner.fmt(f),
            ImportStacksToStackSetErrorKind::StackSetNotFoundException(_inner) => _inner.fmt(f),
            ImportStacksToStackSetErrorKind::StaleRequestException(_inner) => _inner.fmt(f),
            ImportStacksToStackSetErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ImportStacksToStackSetError {
    fn code(&self) -> Option<&str> {
        ImportStacksToStackSetError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ImportStacksToStackSetError {
    /// Creates a new `ImportStacksToStackSetError`.
    pub fn new(kind: ImportStacksToStackSetErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ImportStacksToStackSetError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ImportStacksToStackSetErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ImportStacksToStackSetError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ImportStacksToStackSetErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ImportStacksToStackSetErrorKind::InvalidOperationException`.
    pub fn is_invalid_operation_exception(&self) -> bool {
        matches!(
            &self.kind,
            ImportStacksToStackSetErrorKind::InvalidOperationException(_)
        )
    }
    /// Returns `true` if the error kind is `ImportStacksToStackSetErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            ImportStacksToStackSetErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `ImportStacksToStackSetErrorKind::OperationIdAlreadyExistsException`.
    pub fn is_operation_id_already_exists_exception(&self) -> bool {
        matches!(
            &self.kind,
            ImportStacksToStackSetErrorKind::OperationIdAlreadyExistsException(_)
        )
    }
    /// Returns `true` if the error kind is `ImportStacksToStackSetErrorKind::OperationInProgressException`.
    pub fn is_operation_in_progress_exception(&self) -> bool {
        matches!(
            &self.kind,
            ImportStacksToStackSetErrorKind::OperationInProgressException(_)
        )
    }
    /// Returns `true` if the error kind is `ImportStacksToStackSetErrorKind::StackNotFoundException`.
    pub fn is_stack_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ImportStacksToStackSetErrorKind::StackNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ImportStacksToStackSetErrorKind::StackSetNotFoundException`.
    pub fn is_stack_set_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ImportStacksToStackSetErrorKind::StackSetNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ImportStacksToStackSetErrorKind::StaleRequestException`.
    pub fn is_stale_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            ImportStacksToStackSetErrorKind::StaleRequestException(_)
        )
    }
}
impl std::error::Error for ImportStacksToStackSetError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ImportStacksToStackSetErrorKind::InvalidOperationException(_inner) => Some(_inner),
            ImportStacksToStackSetErrorKind::LimitExceededException(_inner) => Some(_inner),
            ImportStacksToStackSetErrorKind::OperationIdAlreadyExistsException(_inner) => {
                Some(_inner)
            }
            ImportStacksToStackSetErrorKind::OperationInProgressException(_inner) => Some(_inner),
            ImportStacksToStackSetErrorKind::StackNotFoundException(_inner) => Some(_inner),
            ImportStacksToStackSetErrorKind::StackSetNotFoundException(_inner) => Some(_inner),
            ImportStacksToStackSetErrorKind::StaleRequestException(_inner) => Some(_inner),
            ImportStacksToStackSetErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListChangeSets` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListChangeSetsError {
    /// Kind of error that occurred.
    pub kind: ListChangeSetsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListChangeSets` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListChangeSetsErrorKind {
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListChangeSetsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListChangeSetsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListChangeSetsError {
    fn code(&self) -> Option<&str> {
        ListChangeSetsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListChangeSetsError {
    /// Creates a new `ListChangeSetsError`.
    pub fn new(kind: ListChangeSetsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListChangeSetsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListChangeSetsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListChangeSetsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListChangeSetsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
}
impl std::error::Error for ListChangeSetsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListChangeSetsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListExports` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListExportsError {
    /// Kind of error that occurred.
    pub kind: ListExportsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListExports` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListExportsErrorKind {
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListExportsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListExportsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListExportsError {
    fn code(&self) -> Option<&str> {
        ListExportsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListExportsError {
    /// Creates a new `ListExportsError`.
    pub fn new(kind: ListExportsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListExportsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListExportsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListExportsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListExportsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
}
impl std::error::Error for ListExportsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListExportsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListImports` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListImportsError {
    /// Kind of error that occurred.
    pub kind: ListImportsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListImports` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListImportsErrorKind {
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListImportsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListImportsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListImportsError {
    fn code(&self) -> Option<&str> {
        ListImportsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListImportsError {
    /// Creates a new `ListImportsError`.
    pub fn new(kind: ListImportsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListImportsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListImportsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListImportsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListImportsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
}
impl std::error::Error for ListImportsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListImportsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListStackInstances` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListStackInstancesError {
    /// Kind of error that occurred.
    pub kind: ListStackInstancesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListStackInstances` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListStackInstancesErrorKind {
    /// <p>The specified stack set doesn't exist.</p>
    StackSetNotFoundException(crate::error::StackSetNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListStackInstancesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListStackInstancesErrorKind::StackSetNotFoundException(_inner) => _inner.fmt(f),
            ListStackInstancesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListStackInstancesError {
    fn code(&self) -> Option<&str> {
        ListStackInstancesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListStackInstancesError {
    /// Creates a new `ListStackInstancesError`.
    pub fn new(kind: ListStackInstancesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListStackInstancesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListStackInstancesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListStackInstancesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListStackInstancesErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListStackInstancesErrorKind::StackSetNotFoundException`.
    pub fn is_stack_set_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListStackInstancesErrorKind::StackSetNotFoundException(_)
        )
    }
}
impl std::error::Error for ListStackInstancesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListStackInstancesErrorKind::StackSetNotFoundException(_inner) => Some(_inner),
            ListStackInstancesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListStackResources` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListStackResourcesError {
    /// Kind of error that occurred.
    pub kind: ListStackResourcesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListStackResources` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListStackResourcesErrorKind {
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListStackResourcesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListStackResourcesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListStackResourcesError {
    fn code(&self) -> Option<&str> {
        ListStackResourcesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListStackResourcesError {
    /// Creates a new `ListStackResourcesError`.
    pub fn new(kind: ListStackResourcesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListStackResourcesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListStackResourcesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListStackResourcesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListStackResourcesErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
}
impl std::error::Error for ListStackResourcesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListStackResourcesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListStacks` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListStacksError {
    /// Kind of error that occurred.
    pub kind: ListStacksErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListStacks` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListStacksErrorKind {
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListStacksError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListStacksErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListStacksError {
    fn code(&self) -> Option<&str> {
        ListStacksError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListStacksError {
    /// Creates a new `ListStacksError`.
    pub fn new(kind: ListStacksErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListStacksError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListStacksErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListStacksError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListStacksErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
}
impl std::error::Error for ListStacksError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListStacksErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListStackSetOperationResults` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListStackSetOperationResultsError {
    /// Kind of error that occurred.
    pub kind: ListStackSetOperationResultsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListStackSetOperationResults` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListStackSetOperationResultsErrorKind {
    /// <p>The specified ID refers to an operation that doesn't exist.</p>
    OperationNotFoundException(crate::error::OperationNotFoundException),
    /// <p>The specified stack set doesn't exist.</p>
    StackSetNotFoundException(crate::error::StackSetNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListStackSetOperationResultsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListStackSetOperationResultsErrorKind::OperationNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            ListStackSetOperationResultsErrorKind::StackSetNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            ListStackSetOperationResultsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListStackSetOperationResultsError {
    fn code(&self) -> Option<&str> {
        ListStackSetOperationResultsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListStackSetOperationResultsError {
    /// Creates a new `ListStackSetOperationResultsError`.
    pub fn new(kind: ListStackSetOperationResultsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListStackSetOperationResultsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListStackSetOperationResultsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListStackSetOperationResultsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListStackSetOperationResultsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListStackSetOperationResultsErrorKind::OperationNotFoundException`.
    pub fn is_operation_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListStackSetOperationResultsErrorKind::OperationNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListStackSetOperationResultsErrorKind::StackSetNotFoundException`.
    pub fn is_stack_set_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListStackSetOperationResultsErrorKind::StackSetNotFoundException(_)
        )
    }
}
impl std::error::Error for ListStackSetOperationResultsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListStackSetOperationResultsErrorKind::OperationNotFoundException(_inner) => {
                Some(_inner)
            }
            ListStackSetOperationResultsErrorKind::StackSetNotFoundException(_inner) => {
                Some(_inner)
            }
            ListStackSetOperationResultsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListStackSetOperations` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListStackSetOperationsError {
    /// Kind of error that occurred.
    pub kind: ListStackSetOperationsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListStackSetOperations` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListStackSetOperationsErrorKind {
    /// <p>The specified stack set doesn't exist.</p>
    StackSetNotFoundException(crate::error::StackSetNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListStackSetOperationsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListStackSetOperationsErrorKind::StackSetNotFoundException(_inner) => _inner.fmt(f),
            ListStackSetOperationsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListStackSetOperationsError {
    fn code(&self) -> Option<&str> {
        ListStackSetOperationsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListStackSetOperationsError {
    /// Creates a new `ListStackSetOperationsError`.
    pub fn new(kind: ListStackSetOperationsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListStackSetOperationsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListStackSetOperationsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListStackSetOperationsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListStackSetOperationsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListStackSetOperationsErrorKind::StackSetNotFoundException`.
    pub fn is_stack_set_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListStackSetOperationsErrorKind::StackSetNotFoundException(_)
        )
    }
}
impl std::error::Error for ListStackSetOperationsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListStackSetOperationsErrorKind::StackSetNotFoundException(_inner) => Some(_inner),
            ListStackSetOperationsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListStackSets` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListStackSetsError {
    /// Kind of error that occurred.
    pub kind: ListStackSetsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListStackSets` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListStackSetsErrorKind {
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListStackSetsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListStackSetsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListStackSetsError {
    fn code(&self) -> Option<&str> {
        ListStackSetsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListStackSetsError {
    /// Creates a new `ListStackSetsError`.
    pub fn new(kind: ListStackSetsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListStackSetsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListStackSetsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListStackSetsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListStackSetsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
}
impl std::error::Error for ListStackSetsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListStackSetsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListTypeRegistrations` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListTypeRegistrationsError {
    /// Kind of error that occurred.
    pub kind: ListTypeRegistrationsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListTypeRegistrations` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListTypeRegistrationsErrorKind {
    /// <p>An error occurred during a CloudFormation registry operation.</p>
    CfnRegistryException(crate::error::CfnRegistryException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListTypeRegistrationsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListTypeRegistrationsErrorKind::CfnRegistryException(_inner) => _inner.fmt(f),
            ListTypeRegistrationsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListTypeRegistrationsError {
    fn code(&self) -> Option<&str> {
        ListTypeRegistrationsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListTypeRegistrationsError {
    /// Creates a new `ListTypeRegistrationsError`.
    pub fn new(kind: ListTypeRegistrationsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListTypeRegistrationsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListTypeRegistrationsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListTypeRegistrationsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListTypeRegistrationsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListTypeRegistrationsErrorKind::CfnRegistryException`.
    pub fn is_cfn_registry_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTypeRegistrationsErrorKind::CfnRegistryException(_)
        )
    }
}
impl std::error::Error for ListTypeRegistrationsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListTypeRegistrationsErrorKind::CfnRegistryException(_inner) => Some(_inner),
            ListTypeRegistrationsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListTypes` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListTypesError {
    /// Kind of error that occurred.
    pub kind: ListTypesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListTypes` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListTypesErrorKind {
    /// <p>An error occurred during a CloudFormation registry operation.</p>
    CfnRegistryException(crate::error::CfnRegistryException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListTypesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListTypesErrorKind::CfnRegistryException(_inner) => _inner.fmt(f),
            ListTypesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListTypesError {
    fn code(&self) -> Option<&str> {
        ListTypesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListTypesError {
    /// Creates a new `ListTypesError`.
    pub fn new(kind: ListTypesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListTypesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListTypesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListTypesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListTypesErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListTypesErrorKind::CfnRegistryException`.
    pub fn is_cfn_registry_exception(&self) -> bool {
        matches!(&self.kind, ListTypesErrorKind::CfnRegistryException(_))
    }
}
impl std::error::Error for ListTypesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListTypesErrorKind::CfnRegistryException(_inner) => Some(_inner),
            ListTypesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListTypeVersions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListTypeVersionsError {
    /// Kind of error that occurred.
    pub kind: ListTypeVersionsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListTypeVersions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListTypeVersionsErrorKind {
    /// <p>An error occurred during a CloudFormation registry operation.</p>
    CfnRegistryException(crate::error::CfnRegistryException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListTypeVersionsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListTypeVersionsErrorKind::CfnRegistryException(_inner) => _inner.fmt(f),
            ListTypeVersionsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListTypeVersionsError {
    fn code(&self) -> Option<&str> {
        ListTypeVersionsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListTypeVersionsError {
    /// Creates a new `ListTypeVersionsError`.
    pub fn new(kind: ListTypeVersionsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListTypeVersionsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListTypeVersionsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListTypeVersionsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListTypeVersionsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListTypeVersionsErrorKind::CfnRegistryException`.
    pub fn is_cfn_registry_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTypeVersionsErrorKind::CfnRegistryException(_)
        )
    }
}
impl std::error::Error for ListTypeVersionsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListTypeVersionsErrorKind::CfnRegistryException(_inner) => Some(_inner),
            ListTypeVersionsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `PublishType` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct PublishTypeError {
    /// Kind of error that occurred.
    pub kind: PublishTypeErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `PublishType` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum PublishTypeErrorKind {
    /// <p>An error occurred during a CloudFormation registry operation.</p>
    CfnRegistryException(crate::error::CfnRegistryException),
    /// <p>The specified extension doesn't exist in the CloudFormation registry.</p>
    TypeNotFoundException(crate::error::TypeNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for PublishTypeError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            PublishTypeErrorKind::CfnRegistryException(_inner) => _inner.fmt(f),
            PublishTypeErrorKind::TypeNotFoundException(_inner) => _inner.fmt(f),
            PublishTypeErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for PublishTypeError {
    fn code(&self) -> Option<&str> {
        PublishTypeError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl PublishTypeError {
    /// Creates a new `PublishTypeError`.
    pub fn new(kind: PublishTypeErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `PublishTypeError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: PublishTypeErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `PublishTypeError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: PublishTypeErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `PublishTypeErrorKind::CfnRegistryException`.
    pub fn is_cfn_registry_exception(&self) -> bool {
        matches!(&self.kind, PublishTypeErrorKind::CfnRegistryException(_))
    }
    /// Returns `true` if the error kind is `PublishTypeErrorKind::TypeNotFoundException`.
    pub fn is_type_not_found_exception(&self) -> bool {
        matches!(&self.kind, PublishTypeErrorKind::TypeNotFoundException(_))
    }
}
impl std::error::Error for PublishTypeError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            PublishTypeErrorKind::CfnRegistryException(_inner) => Some(_inner),
            PublishTypeErrorKind::TypeNotFoundException(_inner) => Some(_inner),
            PublishTypeErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `RecordHandlerProgress` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct RecordHandlerProgressError {
    /// Kind of error that occurred.
    pub kind: RecordHandlerProgressErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `RecordHandlerProgress` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum RecordHandlerProgressErrorKind {
    /// <p>Error reserved for use by the <a href="https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/what-is-cloudformation-cli.html">CloudFormation CLI</a>. CloudFormation doesn't return this error to users.</p>
    InvalidStateTransitionException(crate::error::InvalidStateTransitionException),
    /// <p>Error reserved for use by the <a href="https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/what-is-cloudformation-cli.html">CloudFormation CLI</a>. CloudFormation doesn't return this error to users.</p>
    OperationStatusCheckFailedException(crate::error::OperationStatusCheckFailedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for RecordHandlerProgressError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            RecordHandlerProgressErrorKind::InvalidStateTransitionException(_inner) => {
                _inner.fmt(f)
            }
            RecordHandlerProgressErrorKind::OperationStatusCheckFailedException(_inner) => {
                _inner.fmt(f)
            }
            RecordHandlerProgressErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for RecordHandlerProgressError {
    fn code(&self) -> Option<&str> {
        RecordHandlerProgressError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl RecordHandlerProgressError {
    /// Creates a new `RecordHandlerProgressError`.
    pub fn new(kind: RecordHandlerProgressErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `RecordHandlerProgressError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: RecordHandlerProgressErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `RecordHandlerProgressError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: RecordHandlerProgressErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `RecordHandlerProgressErrorKind::InvalidStateTransitionException`.
    pub fn is_invalid_state_transition_exception(&self) -> bool {
        matches!(
            &self.kind,
            RecordHandlerProgressErrorKind::InvalidStateTransitionException(_)
        )
    }
    /// Returns `true` if the error kind is `RecordHandlerProgressErrorKind::OperationStatusCheckFailedException`.
    pub fn is_operation_status_check_failed_exception(&self) -> bool {
        matches!(
            &self.kind,
            RecordHandlerProgressErrorKind::OperationStatusCheckFailedException(_)
        )
    }
}
impl std::error::Error for RecordHandlerProgressError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            RecordHandlerProgressErrorKind::InvalidStateTransitionException(_inner) => Some(_inner),
            RecordHandlerProgressErrorKind::OperationStatusCheckFailedException(_inner) => {
                Some(_inner)
            }
            RecordHandlerProgressErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `RegisterPublisher` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct RegisterPublisherError {
    /// Kind of error that occurred.
    pub kind: RegisterPublisherErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `RegisterPublisher` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum RegisterPublisherErrorKind {
    /// <p>An error occurred during a CloudFormation registry operation.</p>
    CfnRegistryException(crate::error::CfnRegistryException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for RegisterPublisherError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            RegisterPublisherErrorKind::CfnRegistryException(_inner) => _inner.fmt(f),
            RegisterPublisherErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for RegisterPublisherError {
    fn code(&self) -> Option<&str> {
        RegisterPublisherError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl RegisterPublisherError {
    /// Creates a new `RegisterPublisherError`.
    pub fn new(kind: RegisterPublisherErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `RegisterPublisherError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: RegisterPublisherErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `RegisterPublisherError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: RegisterPublisherErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `RegisterPublisherErrorKind::CfnRegistryException`.
    pub fn is_cfn_registry_exception(&self) -> bool {
        matches!(
            &self.kind,
            RegisterPublisherErrorKind::CfnRegistryException(_)
        )
    }
}
impl std::error::Error for RegisterPublisherError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            RegisterPublisherErrorKind::CfnRegistryException(_inner) => Some(_inner),
            RegisterPublisherErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `RegisterType` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct RegisterTypeError {
    /// Kind of error that occurred.
    pub kind: RegisterTypeErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `RegisterType` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum RegisterTypeErrorKind {
    /// <p>An error occurred during a CloudFormation registry operation.</p>
    CfnRegistryException(crate::error::CfnRegistryException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for RegisterTypeError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            RegisterTypeErrorKind::CfnRegistryException(_inner) => _inner.fmt(f),
            RegisterTypeErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for RegisterTypeError {
    fn code(&self) -> Option<&str> {
        RegisterTypeError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl RegisterTypeError {
    /// Creates a new `RegisterTypeError`.
    pub fn new(kind: RegisterTypeErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `RegisterTypeError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: RegisterTypeErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `RegisterTypeError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: RegisterTypeErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `RegisterTypeErrorKind::CfnRegistryException`.
    pub fn is_cfn_registry_exception(&self) -> bool {
        matches!(&self.kind, RegisterTypeErrorKind::CfnRegistryException(_))
    }
}
impl std::error::Error for RegisterTypeError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            RegisterTypeErrorKind::CfnRegistryException(_inner) => Some(_inner),
            RegisterTypeErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `RollbackStack` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct RollbackStackError {
    /// Kind of error that occurred.
    pub kind: RollbackStackErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `RollbackStack` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum RollbackStackErrorKind {
    /// <p>A client request token already exists.</p>
    TokenAlreadyExistsException(crate::error::TokenAlreadyExistsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for RollbackStackError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            RollbackStackErrorKind::TokenAlreadyExistsException(_inner) => _inner.fmt(f),
            RollbackStackErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for RollbackStackError {
    fn code(&self) -> Option<&str> {
        RollbackStackError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl RollbackStackError {
    /// Creates a new `RollbackStackError`.
    pub fn new(kind: RollbackStackErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `RollbackStackError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: RollbackStackErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `RollbackStackError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: RollbackStackErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `RollbackStackErrorKind::TokenAlreadyExistsException`.
    pub fn is_token_already_exists_exception(&self) -> bool {
        matches!(
            &self.kind,
            RollbackStackErrorKind::TokenAlreadyExistsException(_)
        )
    }
}
impl std::error::Error for RollbackStackError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            RollbackStackErrorKind::TokenAlreadyExistsException(_inner) => Some(_inner),
            RollbackStackErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `SetStackPolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct SetStackPolicyError {
    /// Kind of error that occurred.
    pub kind: SetStackPolicyErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `SetStackPolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum SetStackPolicyErrorKind {
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for SetStackPolicyError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            SetStackPolicyErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for SetStackPolicyError {
    fn code(&self) -> Option<&str> {
        SetStackPolicyError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl SetStackPolicyError {
    /// Creates a new `SetStackPolicyError`.
    pub fn new(kind: SetStackPolicyErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `SetStackPolicyError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: SetStackPolicyErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `SetStackPolicyError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: SetStackPolicyErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
}
impl std::error::Error for SetStackPolicyError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            SetStackPolicyErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `SetTypeConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct SetTypeConfigurationError {
    /// Kind of error that occurred.
    pub kind: SetTypeConfigurationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `SetTypeConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum SetTypeConfigurationErrorKind {
    /// <p>An error occurred during a CloudFormation registry operation.</p>
    CfnRegistryException(crate::error::CfnRegistryException),
    /// <p>The specified extension doesn't exist in the CloudFormation registry.</p>
    TypeNotFoundException(crate::error::TypeNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for SetTypeConfigurationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            SetTypeConfigurationErrorKind::CfnRegistryException(_inner) => _inner.fmt(f),
            SetTypeConfigurationErrorKind::TypeNotFoundException(_inner) => _inner.fmt(f),
            SetTypeConfigurationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for SetTypeConfigurationError {
    fn code(&self) -> Option<&str> {
        SetTypeConfigurationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl SetTypeConfigurationError {
    /// Creates a new `SetTypeConfigurationError`.
    pub fn new(kind: SetTypeConfigurationErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `SetTypeConfigurationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: SetTypeConfigurationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `SetTypeConfigurationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: SetTypeConfigurationErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `SetTypeConfigurationErrorKind::CfnRegistryException`.
    pub fn is_cfn_registry_exception(&self) -> bool {
        matches!(
            &self.kind,
            SetTypeConfigurationErrorKind::CfnRegistryException(_)
        )
    }
    /// Returns `true` if the error kind is `SetTypeConfigurationErrorKind::TypeNotFoundException`.
    pub fn is_type_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            SetTypeConfigurationErrorKind::TypeNotFoundException(_)
        )
    }
}
impl std::error::Error for SetTypeConfigurationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            SetTypeConfigurationErrorKind::CfnRegistryException(_inner) => Some(_inner),
            SetTypeConfigurationErrorKind::TypeNotFoundException(_inner) => Some(_inner),
            SetTypeConfigurationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `SetTypeDefaultVersion` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct SetTypeDefaultVersionError {
    /// Kind of error that occurred.
    pub kind: SetTypeDefaultVersionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `SetTypeDefaultVersion` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum SetTypeDefaultVersionErrorKind {
    /// <p>An error occurred during a CloudFormation registry operation.</p>
    CfnRegistryException(crate::error::CfnRegistryException),
    /// <p>The specified extension doesn't exist in the CloudFormation registry.</p>
    TypeNotFoundException(crate::error::TypeNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for SetTypeDefaultVersionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            SetTypeDefaultVersionErrorKind::CfnRegistryException(_inner) => _inner.fmt(f),
            SetTypeDefaultVersionErrorKind::TypeNotFoundException(_inner) => _inner.fmt(f),
            SetTypeDefaultVersionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for SetTypeDefaultVersionError {
    fn code(&self) -> Option<&str> {
        SetTypeDefaultVersionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl SetTypeDefaultVersionError {
    /// Creates a new `SetTypeDefaultVersionError`.
    pub fn new(kind: SetTypeDefaultVersionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `SetTypeDefaultVersionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: SetTypeDefaultVersionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `SetTypeDefaultVersionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: SetTypeDefaultVersionErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `SetTypeDefaultVersionErrorKind::CfnRegistryException`.
    pub fn is_cfn_registry_exception(&self) -> bool {
        matches!(
            &self.kind,
            SetTypeDefaultVersionErrorKind::CfnRegistryException(_)
        )
    }
    /// Returns `true` if the error kind is `SetTypeDefaultVersionErrorKind::TypeNotFoundException`.
    pub fn is_type_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            SetTypeDefaultVersionErrorKind::TypeNotFoundException(_)
        )
    }
}
impl std::error::Error for SetTypeDefaultVersionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            SetTypeDefaultVersionErrorKind::CfnRegistryException(_inner) => Some(_inner),
            SetTypeDefaultVersionErrorKind::TypeNotFoundException(_inner) => Some(_inner),
            SetTypeDefaultVersionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `SignalResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct SignalResourceError {
    /// Kind of error that occurred.
    pub kind: SignalResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `SignalResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum SignalResourceErrorKind {
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for SignalResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            SignalResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for SignalResourceError {
    fn code(&self) -> Option<&str> {
        SignalResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl SignalResourceError {
    /// Creates a new `SignalResourceError`.
    pub fn new(kind: SignalResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `SignalResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: SignalResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `SignalResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: SignalResourceErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
}
impl std::error::Error for SignalResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            SignalResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `StopStackSetOperation` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct StopStackSetOperationError {
    /// Kind of error that occurred.
    pub kind: StopStackSetOperationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `StopStackSetOperation` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum StopStackSetOperationErrorKind {
    /// <p>The specified operation isn't valid.</p>
    InvalidOperationException(crate::error::InvalidOperationException),
    /// <p>The specified ID refers to an operation that doesn't exist.</p>
    OperationNotFoundException(crate::error::OperationNotFoundException),
    /// <p>The specified stack set doesn't exist.</p>
    StackSetNotFoundException(crate::error::StackSetNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for StopStackSetOperationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            StopStackSetOperationErrorKind::InvalidOperationException(_inner) => _inner.fmt(f),
            StopStackSetOperationErrorKind::OperationNotFoundException(_inner) => _inner.fmt(f),
            StopStackSetOperationErrorKind::StackSetNotFoundException(_inner) => _inner.fmt(f),
            StopStackSetOperationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for StopStackSetOperationError {
    fn code(&self) -> Option<&str> {
        StopStackSetOperationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl StopStackSetOperationError {
    /// Creates a new `StopStackSetOperationError`.
    pub fn new(kind: StopStackSetOperationErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `StopStackSetOperationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: StopStackSetOperationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `StopStackSetOperationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: StopStackSetOperationErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `StopStackSetOperationErrorKind::InvalidOperationException`.
    pub fn is_invalid_operation_exception(&self) -> bool {
        matches!(
            &self.kind,
            StopStackSetOperationErrorKind::InvalidOperationException(_)
        )
    }
    /// Returns `true` if the error kind is `StopStackSetOperationErrorKind::OperationNotFoundException`.
    pub fn is_operation_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            StopStackSetOperationErrorKind::OperationNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `StopStackSetOperationErrorKind::StackSetNotFoundException`.
    pub fn is_stack_set_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            StopStackSetOperationErrorKind::StackSetNotFoundException(_)
        )
    }
}
impl std::error::Error for StopStackSetOperationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            StopStackSetOperationErrorKind::InvalidOperationException(_inner) => Some(_inner),
            StopStackSetOperationErrorKind::OperationNotFoundException(_inner) => Some(_inner),
            StopStackSetOperationErrorKind::StackSetNotFoundException(_inner) => Some(_inner),
            StopStackSetOperationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `TestType` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct TestTypeError {
    /// Kind of error that occurred.
    pub kind: TestTypeErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `TestType` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum TestTypeErrorKind {
    /// <p>An error occurred during a CloudFormation registry operation.</p>
    CfnRegistryException(crate::error::CfnRegistryException),
    /// <p>The specified extension doesn't exist in the CloudFormation registry.</p>
    TypeNotFoundException(crate::error::TypeNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for TestTypeError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            TestTypeErrorKind::CfnRegistryException(_inner) => _inner.fmt(f),
            TestTypeErrorKind::TypeNotFoundException(_inner) => _inner.fmt(f),
            TestTypeErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for TestTypeError {
    fn code(&self) -> Option<&str> {
        TestTypeError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl TestTypeError {
    /// Creates a new `TestTypeError`.
    pub fn new(kind: TestTypeErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `TestTypeError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: TestTypeErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `TestTypeError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: TestTypeErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `TestTypeErrorKind::CfnRegistryException`.
    pub fn is_cfn_registry_exception(&self) -> bool {
        matches!(&self.kind, TestTypeErrorKind::CfnRegistryException(_))
    }
    /// Returns `true` if the error kind is `TestTypeErrorKind::TypeNotFoundException`.
    pub fn is_type_not_found_exception(&self) -> bool {
        matches!(&self.kind, TestTypeErrorKind::TypeNotFoundException(_))
    }
}
impl std::error::Error for TestTypeError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            TestTypeErrorKind::CfnRegistryException(_inner) => Some(_inner),
            TestTypeErrorKind::TypeNotFoundException(_inner) => Some(_inner),
            TestTypeErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateStack` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateStackError {
    /// Kind of error that occurred.
    pub kind: UpdateStackErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateStack` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateStackErrorKind {
    /// <p>The template contains resources with capabilities that weren't specified in the Capabilities parameter.</p>
    InsufficientCapabilitiesException(crate::error::InsufficientCapabilitiesException),
    /// <p>A client request token already exists.</p>
    TokenAlreadyExistsException(crate::error::TokenAlreadyExistsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateStackError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateStackErrorKind::InsufficientCapabilitiesException(_inner) => _inner.fmt(f),
            UpdateStackErrorKind::TokenAlreadyExistsException(_inner) => _inner.fmt(f),
            UpdateStackErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateStackError {
    fn code(&self) -> Option<&str> {
        UpdateStackError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateStackError {
    /// Creates a new `UpdateStackError`.
    pub fn new(kind: UpdateStackErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateStackError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateStackErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateStackError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateStackErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateStackErrorKind::InsufficientCapabilitiesException`.
    pub fn is_insufficient_capabilities_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateStackErrorKind::InsufficientCapabilitiesException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateStackErrorKind::TokenAlreadyExistsException`.
    pub fn is_token_already_exists_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateStackErrorKind::TokenAlreadyExistsException(_)
        )
    }
}
impl std::error::Error for UpdateStackError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateStackErrorKind::InsufficientCapabilitiesException(_inner) => Some(_inner),
            UpdateStackErrorKind::TokenAlreadyExistsException(_inner) => Some(_inner),
            UpdateStackErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateStackInstances` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateStackInstancesError {
    /// Kind of error that occurred.
    pub kind: UpdateStackInstancesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateStackInstances` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateStackInstancesErrorKind {
    /// <p>The specified operation isn't valid.</p>
    InvalidOperationException(crate::error::InvalidOperationException),
    /// <p>The specified operation ID already exists.</p>
    OperationIdAlreadyExistsException(crate::error::OperationIdAlreadyExistsException),
    /// <p>Another operation is currently in progress for this stack set. Only one operation can be performed for a stack set at a given time.</p>
    OperationInProgressException(crate::error::OperationInProgressException),
    /// <p>The specified stack instance doesn't exist.</p>
    StackInstanceNotFoundException(crate::error::StackInstanceNotFoundException),
    /// <p>The specified stack set doesn't exist.</p>
    StackSetNotFoundException(crate::error::StackSetNotFoundException),
    /// <p>Another operation has been performed on this stack set since the specified operation was performed.</p>
    StaleRequestException(crate::error::StaleRequestException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateStackInstancesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateStackInstancesErrorKind::InvalidOperationException(_inner) => _inner.fmt(f),
            UpdateStackInstancesErrorKind::OperationIdAlreadyExistsException(_inner) => {
                _inner.fmt(f)
            }
            UpdateStackInstancesErrorKind::OperationInProgressException(_inner) => _inner.fmt(f),
            UpdateStackInstancesErrorKind::StackInstanceNotFoundException(_inner) => _inner.fmt(f),
            UpdateStackInstancesErrorKind::StackSetNotFoundException(_inner) => _inner.fmt(f),
            UpdateStackInstancesErrorKind::StaleRequestException(_inner) => _inner.fmt(f),
            UpdateStackInstancesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateStackInstancesError {
    fn code(&self) -> Option<&str> {
        UpdateStackInstancesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateStackInstancesError {
    /// Creates a new `UpdateStackInstancesError`.
    pub fn new(kind: UpdateStackInstancesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateStackInstancesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateStackInstancesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateStackInstancesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateStackInstancesErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateStackInstancesErrorKind::InvalidOperationException`.
    pub fn is_invalid_operation_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateStackInstancesErrorKind::InvalidOperationException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateStackInstancesErrorKind::OperationIdAlreadyExistsException`.
    pub fn is_operation_id_already_exists_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateStackInstancesErrorKind::OperationIdAlreadyExistsException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateStackInstancesErrorKind::OperationInProgressException`.
    pub fn is_operation_in_progress_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateStackInstancesErrorKind::OperationInProgressException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateStackInstancesErrorKind::StackInstanceNotFoundException`.
    pub fn is_stack_instance_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateStackInstancesErrorKind::StackInstanceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateStackInstancesErrorKind::StackSetNotFoundException`.
    pub fn is_stack_set_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateStackInstancesErrorKind::StackSetNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateStackInstancesErrorKind::StaleRequestException`.
    pub fn is_stale_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateStackInstancesErrorKind::StaleRequestException(_)
        )
    }
}
impl std::error::Error for UpdateStackInstancesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateStackInstancesErrorKind::InvalidOperationException(_inner) => Some(_inner),
            UpdateStackInstancesErrorKind::OperationIdAlreadyExistsException(_inner) => {
                Some(_inner)
            }
            UpdateStackInstancesErrorKind::OperationInProgressException(_inner) => Some(_inner),
            UpdateStackInstancesErrorKind::StackInstanceNotFoundException(_inner) => Some(_inner),
            UpdateStackInstancesErrorKind::StackSetNotFoundException(_inner) => Some(_inner),
            UpdateStackInstancesErrorKind::StaleRequestException(_inner) => Some(_inner),
            UpdateStackInstancesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateStackSet` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateStackSetError {
    /// Kind of error that occurred.
    pub kind: UpdateStackSetErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateStackSet` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateStackSetErrorKind {
    /// <p>The specified operation isn't valid.</p>
    InvalidOperationException(crate::error::InvalidOperationException),
    /// <p>The specified operation ID already exists.</p>
    OperationIdAlreadyExistsException(crate::error::OperationIdAlreadyExistsException),
    /// <p>Another operation is currently in progress for this stack set. Only one operation can be performed for a stack set at a given time.</p>
    OperationInProgressException(crate::error::OperationInProgressException),
    /// <p>The specified stack instance doesn't exist.</p>
    StackInstanceNotFoundException(crate::error::StackInstanceNotFoundException),
    /// <p>The specified stack set doesn't exist.</p>
    StackSetNotFoundException(crate::error::StackSetNotFoundException),
    /// <p>Another operation has been performed on this stack set since the specified operation was performed.</p>
    StaleRequestException(crate::error::StaleRequestException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateStackSetError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateStackSetErrorKind::InvalidOperationException(_inner) => _inner.fmt(f),
            UpdateStackSetErrorKind::OperationIdAlreadyExistsException(_inner) => _inner.fmt(f),
            UpdateStackSetErrorKind::OperationInProgressException(_inner) => _inner.fmt(f),
            UpdateStackSetErrorKind::StackInstanceNotFoundException(_inner) => _inner.fmt(f),
            UpdateStackSetErrorKind::StackSetNotFoundException(_inner) => _inner.fmt(f),
            UpdateStackSetErrorKind::StaleRequestException(_inner) => _inner.fmt(f),
            UpdateStackSetErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateStackSetError {
    fn code(&self) -> Option<&str> {
        UpdateStackSetError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateStackSetError {
    /// Creates a new `UpdateStackSetError`.
    pub fn new(kind: UpdateStackSetErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateStackSetError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateStackSetErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateStackSetError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateStackSetErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateStackSetErrorKind::InvalidOperationException`.
    pub fn is_invalid_operation_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateStackSetErrorKind::InvalidOperationException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateStackSetErrorKind::OperationIdAlreadyExistsException`.
    pub fn is_operation_id_already_exists_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateStackSetErrorKind::OperationIdAlreadyExistsException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateStackSetErrorKind::OperationInProgressException`.
    pub fn is_operation_in_progress_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateStackSetErrorKind::OperationInProgressException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateStackSetErrorKind::StackInstanceNotFoundException`.
    pub fn is_stack_instance_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateStackSetErrorKind::StackInstanceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateStackSetErrorKind::StackSetNotFoundException`.
    pub fn is_stack_set_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateStackSetErrorKind::StackSetNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateStackSetErrorKind::StaleRequestException`.
    pub fn is_stale_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateStackSetErrorKind::StaleRequestException(_)
        )
    }
}
impl std::error::Error for UpdateStackSetError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateStackSetErrorKind::InvalidOperationException(_inner) => Some(_inner),
            UpdateStackSetErrorKind::OperationIdAlreadyExistsException(_inner) => Some(_inner),
            UpdateStackSetErrorKind::OperationInProgressException(_inner) => Some(_inner),
            UpdateStackSetErrorKind::StackInstanceNotFoundException(_inner) => Some(_inner),
            UpdateStackSetErrorKind::StackSetNotFoundException(_inner) => Some(_inner),
            UpdateStackSetErrorKind::StaleRequestException(_inner) => Some(_inner),
            UpdateStackSetErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateTerminationProtection` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateTerminationProtectionError {
    /// Kind of error that occurred.
    pub kind: UpdateTerminationProtectionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateTerminationProtection` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateTerminationProtectionErrorKind {
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateTerminationProtectionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateTerminationProtectionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateTerminationProtectionError {
    fn code(&self) -> Option<&str> {
        UpdateTerminationProtectionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateTerminationProtectionError {
    /// Creates a new `UpdateTerminationProtectionError`.
    pub fn new(kind: UpdateTerminationProtectionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateTerminationProtectionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateTerminationProtectionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateTerminationProtectionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateTerminationProtectionErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
}
impl std::error::Error for UpdateTerminationProtectionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateTerminationProtectionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ValidateTemplate` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ValidateTemplateError {
    /// Kind of error that occurred.
    pub kind: ValidateTemplateErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ValidateTemplate` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ValidateTemplateErrorKind {
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ValidateTemplateError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ValidateTemplateErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ValidateTemplateError {
    fn code(&self) -> Option<&str> {
        ValidateTemplateError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ValidateTemplateError {
    /// Creates a new `ValidateTemplateError`.
    pub fn new(kind: ValidateTemplateErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ValidateTemplateError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ValidateTemplateErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ValidateTemplateError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ValidateTemplateErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
}
impl std::error::Error for ValidateTemplateError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ValidateTemplateErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// <p>Another operation has been performed on this stack set since the specified operation was performed.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StaleRequestException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for StaleRequestException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StaleRequestException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl StaleRequestException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for StaleRequestException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "StaleRequestException")?;
        if let Some(inner_1) = &self.message {
            write!(f, ": {}", inner_1)?;
        }
        Ok(())
    }
}
impl std::error::Error for StaleRequestException {}
/// See [`StaleRequestException`](crate::error::StaleRequestException)
pub mod stale_request_exception {
    /// A builder for [`StaleRequestException`](crate::error::StaleRequestException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`StaleRequestException`](crate::error::StaleRequestException)
        pub fn build(self) -> crate::error::StaleRequestException {
            crate::error::StaleRequestException {
                message: self.message,
            }
        }
    }
}
impl StaleRequestException {
    /// Creates a new builder-style object to manufacture [`StaleRequestException`](crate::error::StaleRequestException)
    pub fn builder() -> crate::error::stale_request_exception::Builder {
        crate::error::stale_request_exception::Builder::default()
    }
}

/// <p>The specified stack set doesn't exist.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StackSetNotFoundException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for StackSetNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StackSetNotFoundException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl StackSetNotFoundException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for StackSetNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "StackSetNotFoundException")?;
        if let Some(inner_2) = &self.message {
            write!(f, ": {}", inner_2)?;
        }
        Ok(())
    }
}
impl std::error::Error for StackSetNotFoundException {}
/// See [`StackSetNotFoundException`](crate::error::StackSetNotFoundException)
pub mod stack_set_not_found_exception {
    /// A builder for [`StackSetNotFoundException`](crate::error::StackSetNotFoundException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`StackSetNotFoundException`](crate::error::StackSetNotFoundException)
        pub fn build(self) -> crate::error::StackSetNotFoundException {
            crate::error::StackSetNotFoundException {
                message: self.message,
            }
        }
    }
}
impl StackSetNotFoundException {
    /// Creates a new builder-style object to manufacture [`StackSetNotFoundException`](crate::error::StackSetNotFoundException)
    pub fn builder() -> crate::error::stack_set_not_found_exception::Builder {
        crate::error::stack_set_not_found_exception::Builder::default()
    }
}

/// <p>The specified stack instance doesn't exist.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StackInstanceNotFoundException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for StackInstanceNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StackInstanceNotFoundException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl StackInstanceNotFoundException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for StackInstanceNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "StackInstanceNotFoundException")?;
        if let Some(inner_3) = &self.message {
            write!(f, ": {}", inner_3)?;
        }
        Ok(())
    }
}
impl std::error::Error for StackInstanceNotFoundException {}
/// See [`StackInstanceNotFoundException`](crate::error::StackInstanceNotFoundException)
pub mod stack_instance_not_found_exception {
    /// A builder for [`StackInstanceNotFoundException`](crate::error::StackInstanceNotFoundException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`StackInstanceNotFoundException`](crate::error::StackInstanceNotFoundException)
        pub fn build(self) -> crate::error::StackInstanceNotFoundException {
            crate::error::StackInstanceNotFoundException {
                message: self.message,
            }
        }
    }
}
impl StackInstanceNotFoundException {
    /// Creates a new builder-style object to manufacture [`StackInstanceNotFoundException`](crate::error::StackInstanceNotFoundException)
    pub fn builder() -> crate::error::stack_instance_not_found_exception::Builder {
        crate::error::stack_instance_not_found_exception::Builder::default()
    }
}

/// <p>Another operation is currently in progress for this stack set. Only one operation can be performed for a stack set at a given time.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct OperationInProgressException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for OperationInProgressException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("OperationInProgressException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl OperationInProgressException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for OperationInProgressException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "OperationInProgressException")?;
        if let Some(inner_4) = &self.message {
            write!(f, ": {}", inner_4)?;
        }
        Ok(())
    }
}
impl std::error::Error for OperationInProgressException {}
/// See [`OperationInProgressException`](crate::error::OperationInProgressException)
pub mod operation_in_progress_exception {
    /// A builder for [`OperationInProgressException`](crate::error::OperationInProgressException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`OperationInProgressException`](crate::error::OperationInProgressException)
        pub fn build(self) -> crate::error::OperationInProgressException {
            crate::error::OperationInProgressException {
                message: self.message,
            }
        }
    }
}
impl OperationInProgressException {
    /// Creates a new builder-style object to manufacture [`OperationInProgressException`](crate::error::OperationInProgressException)
    pub fn builder() -> crate::error::operation_in_progress_exception::Builder {
        crate::error::operation_in_progress_exception::Builder::default()
    }
}

/// <p>The specified operation ID already exists.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct OperationIdAlreadyExistsException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for OperationIdAlreadyExistsException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("OperationIdAlreadyExistsException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl OperationIdAlreadyExistsException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for OperationIdAlreadyExistsException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "OperationIdAlreadyExistsException")?;
        if let Some(inner_5) = &self.message {
            write!(f, ": {}", inner_5)?;
        }
        Ok(())
    }
}
impl std::error::Error for OperationIdAlreadyExistsException {}
/// See [`OperationIdAlreadyExistsException`](crate::error::OperationIdAlreadyExistsException)
pub mod operation_id_already_exists_exception {
    /// A builder for [`OperationIdAlreadyExistsException`](crate::error::OperationIdAlreadyExistsException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`OperationIdAlreadyExistsException`](crate::error::OperationIdAlreadyExistsException)
        pub fn build(self) -> crate::error::OperationIdAlreadyExistsException {
            crate::error::OperationIdAlreadyExistsException {
                message: self.message,
            }
        }
    }
}
impl OperationIdAlreadyExistsException {
    /// Creates a new builder-style object to manufacture [`OperationIdAlreadyExistsException`](crate::error::OperationIdAlreadyExistsException)
    pub fn builder() -> crate::error::operation_id_already_exists_exception::Builder {
        crate::error::operation_id_already_exists_exception::Builder::default()
    }
}

/// <p>The specified operation isn't valid.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidOperationException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidOperationException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidOperationException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidOperationException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidOperationException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidOperationException")?;
        if let Some(inner_6) = &self.message {
            write!(f, ": {}", inner_6)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidOperationException {}
/// See [`InvalidOperationException`](crate::error::InvalidOperationException)
pub mod invalid_operation_exception {
    /// A builder for [`InvalidOperationException`](crate::error::InvalidOperationException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidOperationException`](crate::error::InvalidOperationException)
        pub fn build(self) -> crate::error::InvalidOperationException {
            crate::error::InvalidOperationException {
                message: self.message,
            }
        }
    }
}
impl InvalidOperationException {
    /// Creates a new builder-style object to manufacture [`InvalidOperationException`](crate::error::InvalidOperationException)
    pub fn builder() -> crate::error::invalid_operation_exception::Builder {
        crate::error::invalid_operation_exception::Builder::default()
    }
}

/// <p>A client request token already exists.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TokenAlreadyExistsException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for TokenAlreadyExistsException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TokenAlreadyExistsException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl TokenAlreadyExistsException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for TokenAlreadyExistsException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "TokenAlreadyExistsException")?;
        if let Some(inner_7) = &self.message {
            write!(f, ": {}", inner_7)?;
        }
        Ok(())
    }
}
impl std::error::Error for TokenAlreadyExistsException {}
/// See [`TokenAlreadyExistsException`](crate::error::TokenAlreadyExistsException)
pub mod token_already_exists_exception {
    /// A builder for [`TokenAlreadyExistsException`](crate::error::TokenAlreadyExistsException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`TokenAlreadyExistsException`](crate::error::TokenAlreadyExistsException)
        pub fn build(self) -> crate::error::TokenAlreadyExistsException {
            crate::error::TokenAlreadyExistsException {
                message: self.message,
            }
        }
    }
}
impl TokenAlreadyExistsException {
    /// Creates a new builder-style object to manufacture [`TokenAlreadyExistsException`](crate::error::TokenAlreadyExistsException)
    pub fn builder() -> crate::error::token_already_exists_exception::Builder {
        crate::error::token_already_exists_exception::Builder::default()
    }
}

/// <p>The template contains resources with capabilities that weren't specified in the Capabilities parameter.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InsufficientCapabilitiesException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InsufficientCapabilitiesException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InsufficientCapabilitiesException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InsufficientCapabilitiesException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InsufficientCapabilitiesException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InsufficientCapabilitiesException")?;
        if let Some(inner_8) = &self.message {
            write!(f, ": {}", inner_8)?;
        }
        Ok(())
    }
}
impl std::error::Error for InsufficientCapabilitiesException {}
/// See [`InsufficientCapabilitiesException`](crate::error::InsufficientCapabilitiesException)
pub mod insufficient_capabilities_exception {
    /// A builder for [`InsufficientCapabilitiesException`](crate::error::InsufficientCapabilitiesException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InsufficientCapabilitiesException`](crate::error::InsufficientCapabilitiesException)
        pub fn build(self) -> crate::error::InsufficientCapabilitiesException {
            crate::error::InsufficientCapabilitiesException {
                message: self.message,
            }
        }
    }
}
impl InsufficientCapabilitiesException {
    /// Creates a new builder-style object to manufacture [`InsufficientCapabilitiesException`](crate::error::InsufficientCapabilitiesException)
    pub fn builder() -> crate::error::insufficient_capabilities_exception::Builder {
        crate::error::insufficient_capabilities_exception::Builder::default()
    }
}

/// <p>The specified extension doesn't exist in the CloudFormation registry.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TypeNotFoundException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for TypeNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TypeNotFoundException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl TypeNotFoundException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for TypeNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "TypeNotFoundException")?;
        if let Some(inner_9) = &self.message {
            write!(f, ": {}", inner_9)?;
        }
        Ok(())
    }
}
impl std::error::Error for TypeNotFoundException {}
/// See [`TypeNotFoundException`](crate::error::TypeNotFoundException)
pub mod type_not_found_exception {
    /// A builder for [`TypeNotFoundException`](crate::error::TypeNotFoundException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`TypeNotFoundException`](crate::error::TypeNotFoundException)
        pub fn build(self) -> crate::error::TypeNotFoundException {
            crate::error::TypeNotFoundException {
                message: self.message,
            }
        }
    }
}
impl TypeNotFoundException {
    /// Creates a new builder-style object to manufacture [`TypeNotFoundException`](crate::error::TypeNotFoundException)
    pub fn builder() -> crate::error::type_not_found_exception::Builder {
        crate::error::type_not_found_exception::Builder::default()
    }
}

/// <p>An error occurred during a CloudFormation registry operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CfnRegistryException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for CfnRegistryException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CfnRegistryException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl CfnRegistryException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for CfnRegistryException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "CfnRegistryException [CFNRegistryException]")?;
        if let Some(inner_10) = &self.message {
            write!(f, ": {}", inner_10)?;
        }
        Ok(())
    }
}
impl std::error::Error for CfnRegistryException {}
/// See [`CfnRegistryException`](crate::error::CfnRegistryException)
pub mod cfn_registry_exception {
    /// A builder for [`CfnRegistryException`](crate::error::CfnRegistryException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`CfnRegistryException`](crate::error::CfnRegistryException)
        pub fn build(self) -> crate::error::CfnRegistryException {
            crate::error::CfnRegistryException {
                message: self.message,
            }
        }
    }
}
impl CfnRegistryException {
    /// Creates a new builder-style object to manufacture [`CfnRegistryException`](crate::error::CfnRegistryException)
    pub fn builder() -> crate::error::cfn_registry_exception::Builder {
        crate::error::cfn_registry_exception::Builder::default()
    }
}

/// <p>The specified ID refers to an operation that doesn't exist.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct OperationNotFoundException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for OperationNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("OperationNotFoundException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl OperationNotFoundException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for OperationNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "OperationNotFoundException")?;
        if let Some(inner_11) = &self.message {
            write!(f, ": {}", inner_11)?;
        }
        Ok(())
    }
}
impl std::error::Error for OperationNotFoundException {}
/// See [`OperationNotFoundException`](crate::error::OperationNotFoundException)
pub mod operation_not_found_exception {
    /// A builder for [`OperationNotFoundException`](crate::error::OperationNotFoundException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`OperationNotFoundException`](crate::error::OperationNotFoundException)
        pub fn build(self) -> crate::error::OperationNotFoundException {
            crate::error::OperationNotFoundException {
                message: self.message,
            }
        }
    }
}
impl OperationNotFoundException {
    /// Creates a new builder-style object to manufacture [`OperationNotFoundException`](crate::error::OperationNotFoundException)
    pub fn builder() -> crate::error::operation_not_found_exception::Builder {
        crate::error::operation_not_found_exception::Builder::default()
    }
}

/// <p>Error reserved for use by the <a href="https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/what-is-cloudformation-cli.html">CloudFormation CLI</a>. CloudFormation doesn't return this error to users.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct OperationStatusCheckFailedException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for OperationStatusCheckFailedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("OperationStatusCheckFailedException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl OperationStatusCheckFailedException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for OperationStatusCheckFailedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "OperationStatusCheckFailedException")?;
        if let Some(inner_12) = &self.message {
            write!(f, ": {}", inner_12)?;
        }
        Ok(())
    }
}
impl std::error::Error for OperationStatusCheckFailedException {}
/// See [`OperationStatusCheckFailedException`](crate::error::OperationStatusCheckFailedException)
pub mod operation_status_check_failed_exception {
    /// A builder for [`OperationStatusCheckFailedException`](crate::error::OperationStatusCheckFailedException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`OperationStatusCheckFailedException`](crate::error::OperationStatusCheckFailedException)
        pub fn build(self) -> crate::error::OperationStatusCheckFailedException {
            crate::error::OperationStatusCheckFailedException {
                message: self.message,
            }
        }
    }
}
impl OperationStatusCheckFailedException {
    /// Creates a new builder-style object to manufacture [`OperationStatusCheckFailedException`](crate::error::OperationStatusCheckFailedException)
    pub fn builder() -> crate::error::operation_status_check_failed_exception::Builder {
        crate::error::operation_status_check_failed_exception::Builder::default()
    }
}

/// <p>Error reserved for use by the <a href="https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/what-is-cloudformation-cli.html">CloudFormation CLI</a>. CloudFormation doesn't return this error to users.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidStateTransitionException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidStateTransitionException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidStateTransitionException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidStateTransitionException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidStateTransitionException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidStateTransitionException")?;
        if let Some(inner_13) = &self.message {
            write!(f, ": {}", inner_13)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidStateTransitionException {}
/// See [`InvalidStateTransitionException`](crate::error::InvalidStateTransitionException)
pub mod invalid_state_transition_exception {
    /// A builder for [`InvalidStateTransitionException`](crate::error::InvalidStateTransitionException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidStateTransitionException`](crate::error::InvalidStateTransitionException)
        pub fn build(self) -> crate::error::InvalidStateTransitionException {
            crate::error::InvalidStateTransitionException {
                message: self.message,
            }
        }
    }
}
impl InvalidStateTransitionException {
    /// Creates a new builder-style object to manufacture [`InvalidStateTransitionException`](crate::error::InvalidStateTransitionException)
    pub fn builder() -> crate::error::invalid_state_transition_exception::Builder {
        crate::error::invalid_state_transition_exception::Builder::default()
    }
}

/// <p>The specified stack ARN doesn't exist or stack doesn't exist corresponding to the ARN in input.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StackNotFoundException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for StackNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StackNotFoundException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl StackNotFoundException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for StackNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "StackNotFoundException")?;
        if let Some(inner_14) = &self.message {
            write!(f, ": {}", inner_14)?;
        }
        Ok(())
    }
}
impl std::error::Error for StackNotFoundException {}
/// See [`StackNotFoundException`](crate::error::StackNotFoundException)
pub mod stack_not_found_exception {
    /// A builder for [`StackNotFoundException`](crate::error::StackNotFoundException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`StackNotFoundException`](crate::error::StackNotFoundException)
        pub fn build(self) -> crate::error::StackNotFoundException {
            crate::error::StackNotFoundException {
                message: self.message,
            }
        }
    }
}
impl StackNotFoundException {
    /// Creates a new builder-style object to manufacture [`StackNotFoundException`](crate::error::StackNotFoundException)
    pub fn builder() -> crate::error::stack_not_found_exception::Builder {
        crate::error::stack_not_found_exception::Builder::default()
    }
}

/// <p>The quota for the resource has already been reached.</p>
/// <p>For information on resource and stack limitations, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/cloudformation-limits.html">CloudFormation quotas</a> in the <i>CloudFormation User Guide</i>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LimitExceededException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for LimitExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LimitExceededException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl LimitExceededException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for LimitExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "LimitExceededException")?;
        if let Some(inner_15) = &self.message {
            write!(f, ": {}", inner_15)?;
        }
        Ok(())
    }
}
impl std::error::Error for LimitExceededException {}
/// See [`LimitExceededException`](crate::error::LimitExceededException)
pub mod limit_exceeded_exception {
    /// A builder for [`LimitExceededException`](crate::error::LimitExceededException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`LimitExceededException`](crate::error::LimitExceededException)
        pub fn build(self) -> crate::error::LimitExceededException {
            crate::error::LimitExceededException {
                message: self.message,
            }
        }
    }
}
impl LimitExceededException {
    /// Creates a new builder-style object to manufacture [`LimitExceededException`](crate::error::LimitExceededException)
    pub fn builder() -> crate::error::limit_exceeded_exception::Builder {
        crate::error::limit_exceeded_exception::Builder::default()
    }
}

/// <p>The specified change set name or ID doesn't exit. To view valid change sets for a stack, use the <code>ListChangeSets</code> operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ChangeSetNotFoundException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ChangeSetNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ChangeSetNotFoundException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ChangeSetNotFoundException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ChangeSetNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ChangeSetNotFoundException")?;
        if let Some(inner_16) = &self.message {
            write!(f, ": {}", inner_16)?;
        }
        Ok(())
    }
}
impl std::error::Error for ChangeSetNotFoundException {}
/// See [`ChangeSetNotFoundException`](crate::error::ChangeSetNotFoundException)
pub mod change_set_not_found_exception {
    /// A builder for [`ChangeSetNotFoundException`](crate::error::ChangeSetNotFoundException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ChangeSetNotFoundException`](crate::error::ChangeSetNotFoundException)
        pub fn build(self) -> crate::error::ChangeSetNotFoundException {
            crate::error::ChangeSetNotFoundException {
                message: self.message,
            }
        }
    }
}
impl ChangeSetNotFoundException {
    /// Creates a new builder-style object to manufacture [`ChangeSetNotFoundException`](crate::error::ChangeSetNotFoundException)
    pub fn builder() -> crate::error::change_set_not_found_exception::Builder {
        crate::error::change_set_not_found_exception::Builder::default()
    }
}

/// <p>The specified change set can't be used to update the stack. For example, the change set status might be <code>CREATE_IN_PROGRESS</code>, or the stack status might be <code>UPDATE_IN_PROGRESS</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidChangeSetStatusException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidChangeSetStatusException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidChangeSetStatusException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidChangeSetStatusException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidChangeSetStatusException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidChangeSetStatusException")?;
        if let Some(inner_17) = &self.message {
            write!(f, ": {}", inner_17)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidChangeSetStatusException {}
/// See [`InvalidChangeSetStatusException`](crate::error::InvalidChangeSetStatusException)
pub mod invalid_change_set_status_exception {
    /// A builder for [`InvalidChangeSetStatusException`](crate::error::InvalidChangeSetStatusException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidChangeSetStatusException`](crate::error::InvalidChangeSetStatusException)
        pub fn build(self) -> crate::error::InvalidChangeSetStatusException {
            crate::error::InvalidChangeSetStatusException {
                message: self.message,
            }
        }
    }
}
impl InvalidChangeSetStatusException {
    /// Creates a new builder-style object to manufacture [`InvalidChangeSetStatusException`](crate::error::InvalidChangeSetStatusException)
    pub fn builder() -> crate::error::invalid_change_set_status_exception::Builder {
        crate::error::invalid_change_set_status_exception::Builder::default()
    }
}

/// <p>You can't yet delete this stack set, because it still contains one or more stack instances. Delete all stack instances from the stack set before deleting the stack set.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StackSetNotEmptyException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for StackSetNotEmptyException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StackSetNotEmptyException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl StackSetNotEmptyException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for StackSetNotEmptyException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "StackSetNotEmptyException")?;
        if let Some(inner_18) = &self.message {
            write!(f, ": {}", inner_18)?;
        }
        Ok(())
    }
}
impl std::error::Error for StackSetNotEmptyException {}
/// See [`StackSetNotEmptyException`](crate::error::StackSetNotEmptyException)
pub mod stack_set_not_empty_exception {
    /// A builder for [`StackSetNotEmptyException`](crate::error::StackSetNotEmptyException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`StackSetNotEmptyException`](crate::error::StackSetNotEmptyException)
        pub fn build(self) -> crate::error::StackSetNotEmptyException {
            crate::error::StackSetNotEmptyException {
                message: self.message,
            }
        }
    }
}
impl StackSetNotEmptyException {
    /// Creates a new builder-style object to manufacture [`StackSetNotEmptyException`](crate::error::StackSetNotEmptyException)
    pub fn builder() -> crate::error::stack_set_not_empty_exception::Builder {
        crate::error::stack_set_not_empty_exception::Builder::default()
    }
}

/// <p>The specified name is already in use.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct NameAlreadyExistsException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for NameAlreadyExistsException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("NameAlreadyExistsException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl NameAlreadyExistsException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for NameAlreadyExistsException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "NameAlreadyExistsException")?;
        if let Some(inner_19) = &self.message {
            write!(f, ": {}", inner_19)?;
        }
        Ok(())
    }
}
impl std::error::Error for NameAlreadyExistsException {}
/// See [`NameAlreadyExistsException`](crate::error::NameAlreadyExistsException)
pub mod name_already_exists_exception {
    /// A builder for [`NameAlreadyExistsException`](crate::error::NameAlreadyExistsException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`NameAlreadyExistsException`](crate::error::NameAlreadyExistsException)
        pub fn build(self) -> crate::error::NameAlreadyExistsException {
            crate::error::NameAlreadyExistsException {
                message: self.message,
            }
        }
    }
}
impl NameAlreadyExistsException {
    /// Creates a new builder-style object to manufacture [`NameAlreadyExistsException`](crate::error::NameAlreadyExistsException)
    pub fn builder() -> crate::error::name_already_exists_exception::Builder {
        crate::error::name_already_exists_exception::Builder::default()
    }
}

/// <p>The specified resource exists, but has been changed.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreatedButModifiedException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for CreatedButModifiedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreatedButModifiedException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl CreatedButModifiedException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for CreatedButModifiedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "CreatedButModifiedException")?;
        if let Some(inner_20) = &self.message {
            write!(f, ": {}", inner_20)?;
        }
        Ok(())
    }
}
impl std::error::Error for CreatedButModifiedException {}
/// See [`CreatedButModifiedException`](crate::error::CreatedButModifiedException)
pub mod created_but_modified_exception {
    /// A builder for [`CreatedButModifiedException`](crate::error::CreatedButModifiedException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`CreatedButModifiedException`](crate::error::CreatedButModifiedException)
        pub fn build(self) -> crate::error::CreatedButModifiedException {
            crate::error::CreatedButModifiedException {
                message: self.message,
            }
        }
    }
}
impl CreatedButModifiedException {
    /// Creates a new builder-style object to manufacture [`CreatedButModifiedException`](crate::error::CreatedButModifiedException)
    pub fn builder() -> crate::error::created_but_modified_exception::Builder {
        crate::error::created_but_modified_exception::Builder::default()
    }
}

/// <p>The resource with the name requested already exists.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AlreadyExistsException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for AlreadyExistsException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AlreadyExistsException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl AlreadyExistsException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for AlreadyExistsException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "AlreadyExistsException")?;
        if let Some(inner_21) = &self.message {
            write!(f, ": {}", inner_21)?;
        }
        Ok(())
    }
}
impl std::error::Error for AlreadyExistsException {}
/// See [`AlreadyExistsException`](crate::error::AlreadyExistsException)
pub mod already_exists_exception {
    /// A builder for [`AlreadyExistsException`](crate::error::AlreadyExistsException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`AlreadyExistsException`](crate::error::AlreadyExistsException)
        pub fn build(self) -> crate::error::AlreadyExistsException {
            crate::error::AlreadyExistsException {
                message: self.message,
            }
        }
    }
}
impl AlreadyExistsException {
    /// Creates a new builder-style object to manufacture [`AlreadyExistsException`](crate::error::AlreadyExistsException)
    pub fn builder() -> crate::error::already_exists_exception::Builder {
        crate::error::already_exists_exception::Builder::default()
    }
}

/// <p>The specified extension configuration can't be found.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TypeConfigurationNotFoundException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for TypeConfigurationNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TypeConfigurationNotFoundException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl TypeConfigurationNotFoundException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for TypeConfigurationNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "TypeConfigurationNotFoundException")?;
        if let Some(inner_22) = &self.message {
            write!(f, ": {}", inner_22)?;
        }
        Ok(())
    }
}
impl std::error::Error for TypeConfigurationNotFoundException {}
/// See [`TypeConfigurationNotFoundException`](crate::error::TypeConfigurationNotFoundException)
pub mod type_configuration_not_found_exception {
    /// A builder for [`TypeConfigurationNotFoundException`](crate::error::TypeConfigurationNotFoundException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`TypeConfigurationNotFoundException`](crate::error::TypeConfigurationNotFoundException)
        pub fn build(self) -> crate::error::TypeConfigurationNotFoundException {
            crate::error::TypeConfigurationNotFoundException {
                message: self.message,
            }
        }
    }
}
impl TypeConfigurationNotFoundException {
    /// Creates a new builder-style object to manufacture [`TypeConfigurationNotFoundException`](crate::error::TypeConfigurationNotFoundException)
    pub fn builder() -> crate::error::type_configuration_not_found_exception::Builder {
        crate::error::type_configuration_not_found_exception::Builder::default()
    }
}
