// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum Capability {
    #[allow(missing_docs)] // documentation missing in model
    CapabilityAutoExpand,
    #[allow(missing_docs)] // documentation missing in model
    CapabilityIam,
    #[allow(missing_docs)] // documentation missing in model
    CapabilityNamedIam,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for Capability {
    fn from(s: &str) -> Self {
        match s {
            "CAPABILITY_AUTO_EXPAND" => Capability::CapabilityAutoExpand,
            "CAPABILITY_IAM" => Capability::CapabilityIam,
            "CAPABILITY_NAMED_IAM" => Capability::CapabilityNamedIam,
            other => Capability::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for Capability {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(Capability::from(s))
    }
}
impl Capability {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            Capability::CapabilityAutoExpand => "CAPABILITY_AUTO_EXPAND",
            Capability::CapabilityIam => "CAPABILITY_IAM",
            Capability::CapabilityNamedIam => "CAPABILITY_NAMED_IAM",
            Capability::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "CAPABILITY_AUTO_EXPAND",
            "CAPABILITY_IAM",
            "CAPABILITY_NAMED_IAM",
        ]
    }
}
impl AsRef<str> for Capability {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The TemplateParameter data type.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TemplateParameter {
    /// <p>The name associated with the parameter.</p>
    pub parameter_key: std::option::Option<std::string::String>,
    /// <p>The default value associated with the parameter.</p>
    pub default_value: std::option::Option<std::string::String>,
    /// <p>Flag indicating whether the parameter should be displayed as plain text in logs and UIs.</p>
    pub no_echo: std::option::Option<bool>,
    /// <p>User defined description associated with the parameter.</p>
    pub description: std::option::Option<std::string::String>,
}
impl TemplateParameter {
    /// <p>The name associated with the parameter.</p>
    pub fn parameter_key(&self) -> std::option::Option<&str> {
        self.parameter_key.as_deref()
    }
    /// <p>The default value associated with the parameter.</p>
    pub fn default_value(&self) -> std::option::Option<&str> {
        self.default_value.as_deref()
    }
    /// <p>Flag indicating whether the parameter should be displayed as plain text in logs and UIs.</p>
    pub fn no_echo(&self) -> std::option::Option<bool> {
        self.no_echo
    }
    /// <p>User defined description associated with the parameter.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
}
impl std::fmt::Debug for TemplateParameter {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TemplateParameter");
        formatter.field("parameter_key", &self.parameter_key);
        formatter.field("default_value", &self.default_value);
        formatter.field("no_echo", &self.no_echo);
        formatter.field("description", &self.description);
        formatter.finish()
    }
}
/// See [`TemplateParameter`](crate::model::TemplateParameter)
pub mod template_parameter {
    /// A builder for [`TemplateParameter`](crate::model::TemplateParameter)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) parameter_key: std::option::Option<std::string::String>,
        pub(crate) default_value: std::option::Option<std::string::String>,
        pub(crate) no_echo: std::option::Option<bool>,
        pub(crate) description: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name associated with the parameter.</p>
        pub fn parameter_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.parameter_key = Some(input.into());
            self
        }
        /// <p>The name associated with the parameter.</p>
        pub fn set_parameter_key(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.parameter_key = input;
            self
        }
        /// <p>The default value associated with the parameter.</p>
        pub fn default_value(mut self, input: impl Into<std::string::String>) -> Self {
            self.default_value = Some(input.into());
            self
        }
        /// <p>The default value associated with the parameter.</p>
        pub fn set_default_value(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.default_value = input;
            self
        }
        /// <p>Flag indicating whether the parameter should be displayed as plain text in logs and UIs.</p>
        pub fn no_echo(mut self, input: bool) -> Self {
            self.no_echo = Some(input);
            self
        }
        /// <p>Flag indicating whether the parameter should be displayed as plain text in logs and UIs.</p>
        pub fn set_no_echo(mut self, input: std::option::Option<bool>) -> Self {
            self.no_echo = input;
            self
        }
        /// <p>User defined description associated with the parameter.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>User defined description associated with the parameter.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Consumes the builder and constructs a [`TemplateParameter`](crate::model::TemplateParameter)
        pub fn build(self) -> crate::model::TemplateParameter {
            crate::model::TemplateParameter {
                parameter_key: self.parameter_key,
                default_value: self.default_value,
                no_echo: self.no_echo,
                description: self.description,
            }
        }
    }
}
impl TemplateParameter {
    /// Creates a new builder-style object to manufacture [`TemplateParameter`](crate::model::TemplateParameter)
    pub fn builder() -> crate::model::template_parameter::Builder {
        crate::model::template_parameter::Builder::default()
    }
}

/// <p>Describes whether StackSets performs non-conflicting operations concurrently and queues conflicting operations.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ManagedExecution {
    /// <p>When <code>true</code>, StackSets performs non-conflicting operations concurrently and queues conflicting operations. After conflicting operations finish, StackSets starts queued operations in request order.</p> <note>
    /// <p>If there are already running or queued operations, StackSets queues all incoming operations even if they are non-conflicting.</p>
    /// <p>You can't modify your stack set's execution configuration while there are running or queued operations for that stack set.</p>
    /// </note>
    /// <p>When <code>false</code> (default), StackSets performs one operation at a time in request order.</p>
    pub active: std::option::Option<bool>,
}
impl ManagedExecution {
    /// <p>When <code>true</code>, StackSets performs non-conflicting operations concurrently and queues conflicting operations. After conflicting operations finish, StackSets starts queued operations in request order.</p> <note>
    /// <p>If there are already running or queued operations, StackSets queues all incoming operations even if they are non-conflicting.</p>
    /// <p>You can't modify your stack set's execution configuration while there are running or queued operations for that stack set.</p>
    /// </note>
    /// <p>When <code>false</code> (default), StackSets performs one operation at a time in request order.</p>
    pub fn active(&self) -> std::option::Option<bool> {
        self.active
    }
}
impl std::fmt::Debug for ManagedExecution {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ManagedExecution");
        formatter.field("active", &self.active);
        formatter.finish()
    }
}
/// See [`ManagedExecution`](crate::model::ManagedExecution)
pub mod managed_execution {
    /// A builder for [`ManagedExecution`](crate::model::ManagedExecution)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) active: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>When <code>true</code>, StackSets performs non-conflicting operations concurrently and queues conflicting operations. After conflicting operations finish, StackSets starts queued operations in request order.</p> <note>
        /// <p>If there are already running or queued operations, StackSets queues all incoming operations even if they are non-conflicting.</p>
        /// <p>You can't modify your stack set's execution configuration while there are running or queued operations for that stack set.</p>
        /// </note>
        /// <p>When <code>false</code> (default), StackSets performs one operation at a time in request order.</p>
        pub fn active(mut self, input: bool) -> Self {
            self.active = Some(input);
            self
        }
        /// <p>When <code>true</code>, StackSets performs non-conflicting operations concurrently and queues conflicting operations. After conflicting operations finish, StackSets starts queued operations in request order.</p> <note>
        /// <p>If there are already running or queued operations, StackSets queues all incoming operations even if they are non-conflicting.</p>
        /// <p>You can't modify your stack set's execution configuration while there are running or queued operations for that stack set.</p>
        /// </note>
        /// <p>When <code>false</code> (default), StackSets performs one operation at a time in request order.</p>
        pub fn set_active(mut self, input: std::option::Option<bool>) -> Self {
            self.active = input;
            self
        }
        /// Consumes the builder and constructs a [`ManagedExecution`](crate::model::ManagedExecution)
        pub fn build(self) -> crate::model::ManagedExecution {
            crate::model::ManagedExecution {
                active: self.active,
            }
        }
    }
}
impl ManagedExecution {
    /// Creates a new builder-style object to manufacture [`ManagedExecution`](crate::model::ManagedExecution)
    pub fn builder() -> crate::model::managed_execution::Builder {
        crate::model::managed_execution::Builder::default()
    }
}

/// _Note: `CallAs::Self` has been renamed to `::SelfValue`._
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum CallAs {
    #[allow(missing_docs)] // documentation missing in model
    DelegatedAdmin,
    /// _Note: `::Self` has been renamed to `::SelfValue`._
    SelfValue,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for CallAs {
    fn from(s: &str) -> Self {
        match s {
            "DELEGATED_ADMIN" => CallAs::DelegatedAdmin,
            "SELF" => CallAs::SelfValue,
            other => CallAs::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for CallAs {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(CallAs::from(s))
    }
}
impl CallAs {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            CallAs::DelegatedAdmin => "DELEGATED_ADMIN",
            CallAs::SelfValue => "SELF",
            CallAs::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["DELEGATED_ADMIN", "SELF"]
    }
}
impl AsRef<str> for CallAs {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>[Service-managed permissions] Describes whether StackSets automatically deploys to Organizations accounts that are added to a target organization or organizational unit (OU).</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AutoDeployment {
    /// <p>If set to <code>true</code>, StackSets automatically deploys additional stack instances to Organizations accounts that are added to a target organization or organizational unit (OU) in the specified Regions. If an account is removed from a target organization or OU, StackSets deletes stack instances from the account in the specified Regions.</p>
    pub enabled: std::option::Option<bool>,
    /// <p>If set to <code>true</code>, stack resources are retained when an account is removed from a target organization or OU. If set to <code>false</code>, stack resources are deleted. Specify only if <code>Enabled</code> is set to <code>True</code>.</p>
    pub retain_stacks_on_account_removal: std::option::Option<bool>,
}
impl AutoDeployment {
    /// <p>If set to <code>true</code>, StackSets automatically deploys additional stack instances to Organizations accounts that are added to a target organization or organizational unit (OU) in the specified Regions. If an account is removed from a target organization or OU, StackSets deletes stack instances from the account in the specified Regions.</p>
    pub fn enabled(&self) -> std::option::Option<bool> {
        self.enabled
    }
    /// <p>If set to <code>true</code>, stack resources are retained when an account is removed from a target organization or OU. If set to <code>false</code>, stack resources are deleted. Specify only if <code>Enabled</code> is set to <code>True</code>.</p>
    pub fn retain_stacks_on_account_removal(&self) -> std::option::Option<bool> {
        self.retain_stacks_on_account_removal
    }
}
impl std::fmt::Debug for AutoDeployment {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AutoDeployment");
        formatter.field("enabled", &self.enabled);
        formatter.field(
            "retain_stacks_on_account_removal",
            &self.retain_stacks_on_account_removal,
        );
        formatter.finish()
    }
}
/// See [`AutoDeployment`](crate::model::AutoDeployment)
pub mod auto_deployment {
    /// A builder for [`AutoDeployment`](crate::model::AutoDeployment)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) enabled: std::option::Option<bool>,
        pub(crate) retain_stacks_on_account_removal: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>If set to <code>true</code>, StackSets automatically deploys additional stack instances to Organizations accounts that are added to a target organization or organizational unit (OU) in the specified Regions. If an account is removed from a target organization or OU, StackSets deletes stack instances from the account in the specified Regions.</p>
        pub fn enabled(mut self, input: bool) -> Self {
            self.enabled = Some(input);
            self
        }
        /// <p>If set to <code>true</code>, StackSets automatically deploys additional stack instances to Organizations accounts that are added to a target organization or organizational unit (OU) in the specified Regions. If an account is removed from a target organization or OU, StackSets deletes stack instances from the account in the specified Regions.</p>
        pub fn set_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.enabled = input;
            self
        }
        /// <p>If set to <code>true</code>, stack resources are retained when an account is removed from a target organization or OU. If set to <code>false</code>, stack resources are deleted. Specify only if <code>Enabled</code> is set to <code>True</code>.</p>
        pub fn retain_stacks_on_account_removal(mut self, input: bool) -> Self {
            self.retain_stacks_on_account_removal = Some(input);
            self
        }
        /// <p>If set to <code>true</code>, stack resources are retained when an account is removed from a target organization or OU. If set to <code>false</code>, stack resources are deleted. Specify only if <code>Enabled</code> is set to <code>True</code>.</p>
        pub fn set_retain_stacks_on_account_removal(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.retain_stacks_on_account_removal = input;
            self
        }
        /// Consumes the builder and constructs a [`AutoDeployment`](crate::model::AutoDeployment)
        pub fn build(self) -> crate::model::AutoDeployment {
            crate::model::AutoDeployment {
                enabled: self.enabled,
                retain_stacks_on_account_removal: self.retain_stacks_on_account_removal,
            }
        }
    }
}
impl AutoDeployment {
    /// Creates a new builder-style object to manufacture [`AutoDeployment`](crate::model::AutoDeployment)
    pub fn builder() -> crate::model::auto_deployment::Builder {
        crate::model::auto_deployment::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum PermissionModels {
    #[allow(missing_docs)] // documentation missing in model
    SelfManaged,
    #[allow(missing_docs)] // documentation missing in model
    ServiceManaged,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for PermissionModels {
    fn from(s: &str) -> Self {
        match s {
            "SELF_MANAGED" => PermissionModels::SelfManaged,
            "SERVICE_MANAGED" => PermissionModels::ServiceManaged,
            other => PermissionModels::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for PermissionModels {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(PermissionModels::from(s))
    }
}
impl PermissionModels {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            PermissionModels::SelfManaged => "SELF_MANAGED",
            PermissionModels::ServiceManaged => "SERVICE_MANAGED",
            PermissionModels::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["SELF_MANAGED", "SERVICE_MANAGED"]
    }
}
impl AsRef<str> for PermissionModels {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>[Service-managed permissions] The Organizations accounts to which StackSets deploys. StackSets does not deploy stack instances to the organization management account, even if the organization management account is in your organization or in an OU in your organization.</p>
/// <p>For update operations, you can specify either <code>Accounts</code> or <code>OrganizationalUnitIds</code>. For create and delete operations, specify <code>OrganizationalUnitIds</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeploymentTargets {
    /// <p>The names of one or more Amazon Web Services accounts for which you want to deploy stack set updates.</p>
    pub accounts: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>Returns the value of the <code>AccountsUrl</code> property.</p>
    pub accounts_url: std::option::Option<std::string::String>,
    /// <p>The organization root ID or organizational unit (OU) IDs to which StackSets deploys.</p>
    pub organizational_unit_ids: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl DeploymentTargets {
    /// <p>The names of one or more Amazon Web Services accounts for which you want to deploy stack set updates.</p>
    pub fn accounts(&self) -> std::option::Option<&[std::string::String]> {
        self.accounts.as_deref()
    }
    /// <p>Returns the value of the <code>AccountsUrl</code> property.</p>
    pub fn accounts_url(&self) -> std::option::Option<&str> {
        self.accounts_url.as_deref()
    }
    /// <p>The organization root ID or organizational unit (OU) IDs to which StackSets deploys.</p>
    pub fn organizational_unit_ids(&self) -> std::option::Option<&[std::string::String]> {
        self.organizational_unit_ids.as_deref()
    }
}
impl std::fmt::Debug for DeploymentTargets {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeploymentTargets");
        formatter.field("accounts", &self.accounts);
        formatter.field("accounts_url", &self.accounts_url);
        formatter.field("organizational_unit_ids", &self.organizational_unit_ids);
        formatter.finish()
    }
}
/// See [`DeploymentTargets`](crate::model::DeploymentTargets)
pub mod deployment_targets {
    /// A builder for [`DeploymentTargets`](crate::model::DeploymentTargets)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) accounts: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) accounts_url: std::option::Option<std::string::String>,
        pub(crate) organizational_unit_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// Appends an item to `accounts`.
        ///
        /// To override the contents of this collection use [`set_accounts`](Self::set_accounts).
        ///
        /// <p>The names of one or more Amazon Web Services accounts for which you want to deploy stack set updates.</p>
        pub fn accounts(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.accounts.unwrap_or_default();
            v.push(input.into());
            self.accounts = Some(v);
            self
        }
        /// <p>The names of one or more Amazon Web Services accounts for which you want to deploy stack set updates.</p>
        pub fn set_accounts(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.accounts = input;
            self
        }
        /// <p>Returns the value of the <code>AccountsUrl</code> property.</p>
        pub fn accounts_url(mut self, input: impl Into<std::string::String>) -> Self {
            self.accounts_url = Some(input.into());
            self
        }
        /// <p>Returns the value of the <code>AccountsUrl</code> property.</p>
        pub fn set_accounts_url(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.accounts_url = input;
            self
        }
        /// Appends an item to `organizational_unit_ids`.
        ///
        /// To override the contents of this collection use [`set_organizational_unit_ids`](Self::set_organizational_unit_ids).
        ///
        /// <p>The organization root ID or organizational unit (OU) IDs to which StackSets deploys.</p>
        pub fn organizational_unit_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.organizational_unit_ids.unwrap_or_default();
            v.push(input.into());
            self.organizational_unit_ids = Some(v);
            self
        }
        /// <p>The organization root ID or organizational unit (OU) IDs to which StackSets deploys.</p>
        pub fn set_organizational_unit_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.organizational_unit_ids = input;
            self
        }
        /// Consumes the builder and constructs a [`DeploymentTargets`](crate::model::DeploymentTargets)
        pub fn build(self) -> crate::model::DeploymentTargets {
            crate::model::DeploymentTargets {
                accounts: self.accounts,
                accounts_url: self.accounts_url,
                organizational_unit_ids: self.organizational_unit_ids,
            }
        }
    }
}
impl DeploymentTargets {
    /// Creates a new builder-style object to manufacture [`DeploymentTargets`](crate::model::DeploymentTargets)
    pub fn builder() -> crate::model::deployment_targets::Builder {
        crate::model::deployment_targets::Builder::default()
    }
}

/// <p>The user-specified preferences for how CloudFormation performs a stack set operation. </p>
/// <p>For more information on maximum concurrent accounts and failure tolerance, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-concepts.html#stackset-ops-options">Stack set operation options</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StackSetOperationPreferences {
    /// <p>The concurrency type of deploying StackSets operations in Regions, could be in parallel or one Region at a time.</p>
    pub region_concurrency_type: std::option::Option<crate::model::RegionConcurrencyType>,
    /// <p>The order of the Regions in where you want to perform the stack operation.</p>
    pub region_order: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The number of accounts, per Region, for which this operation can fail before CloudFormation stops the operation in that Region. If the operation is stopped in a Region, CloudFormation doesn't attempt the operation in any subsequent Regions.</p>
    /// <p>Conditional: You must specify either <code>FailureToleranceCount</code> or <code>FailureTolerancePercentage</code> (but not both).</p>
    /// <p>By default, <code>0</code> is specified.</p>
    pub failure_tolerance_count: std::option::Option<i32>,
    /// <p>The percentage of accounts, per Region, for which this stack operation can fail before CloudFormation stops the operation in that Region. If the operation is stopped in a Region, CloudFormation doesn't attempt the operation in any subsequent Regions.</p>
    /// <p>When calculating the number of accounts based on the specified percentage, CloudFormation rounds <i>down</i> to the next whole number.</p>
    /// <p>Conditional: You must specify either <code>FailureToleranceCount</code> or <code>FailureTolerancePercentage</code>, but not both.</p>
    /// <p>By default, <code>0</code> is specified.</p>
    pub failure_tolerance_percentage: std::option::Option<i32>,
    /// <p>The maximum number of accounts in which to perform this operation at one time. This is dependent on the value of <code>FailureToleranceCount</code>. <code>MaxConcurrentCount</code> is at most one more than the <code>FailureToleranceCount</code>.</p>
    /// <p>Note that this setting lets you specify the <i>maximum</i> for operations. For large deployments, under certain circumstances the actual number of accounts acted upon concurrently may be lower due to service throttling.</p>
    /// <p>Conditional: You must specify either <code>MaxConcurrentCount</code> or <code>MaxConcurrentPercentage</code>, but not both.</p>
    /// <p>By default, <code>1</code> is specified.</p>
    pub max_concurrent_count: std::option::Option<i32>,
    /// <p>The maximum percentage of accounts in which to perform this operation at one time.</p>
    /// <p>When calculating the number of accounts based on the specified percentage, CloudFormation rounds down to the next whole number. This is true except in cases where rounding down would result is zero. In this case, CloudFormation sets the number as one instead.</p>
    /// <p>Note that this setting lets you specify the <i>maximum</i> for operations. For large deployments, under certain circumstances the actual number of accounts acted upon concurrently may be lower due to service throttling.</p>
    /// <p>Conditional: You must specify either <code>MaxConcurrentCount</code> or <code>MaxConcurrentPercentage</code>, but not both.</p>
    /// <p>By default, <code>1</code> is specified.</p>
    pub max_concurrent_percentage: std::option::Option<i32>,
}
impl StackSetOperationPreferences {
    /// <p>The concurrency type of deploying StackSets operations in Regions, could be in parallel or one Region at a time.</p>
    pub fn region_concurrency_type(
        &self,
    ) -> std::option::Option<&crate::model::RegionConcurrencyType> {
        self.region_concurrency_type.as_ref()
    }
    /// <p>The order of the Regions in where you want to perform the stack operation.</p>
    pub fn region_order(&self) -> std::option::Option<&[std::string::String]> {
        self.region_order.as_deref()
    }
    /// <p>The number of accounts, per Region, for which this operation can fail before CloudFormation stops the operation in that Region. If the operation is stopped in a Region, CloudFormation doesn't attempt the operation in any subsequent Regions.</p>
    /// <p>Conditional: You must specify either <code>FailureToleranceCount</code> or <code>FailureTolerancePercentage</code> (but not both).</p>
    /// <p>By default, <code>0</code> is specified.</p>
    pub fn failure_tolerance_count(&self) -> std::option::Option<i32> {
        self.failure_tolerance_count
    }
    /// <p>The percentage of accounts, per Region, for which this stack operation can fail before CloudFormation stops the operation in that Region. If the operation is stopped in a Region, CloudFormation doesn't attempt the operation in any subsequent Regions.</p>
    /// <p>When calculating the number of accounts based on the specified percentage, CloudFormation rounds <i>down</i> to the next whole number.</p>
    /// <p>Conditional: You must specify either <code>FailureToleranceCount</code> or <code>FailureTolerancePercentage</code>, but not both.</p>
    /// <p>By default, <code>0</code> is specified.</p>
    pub fn failure_tolerance_percentage(&self) -> std::option::Option<i32> {
        self.failure_tolerance_percentage
    }
    /// <p>The maximum number of accounts in which to perform this operation at one time. This is dependent on the value of <code>FailureToleranceCount</code>. <code>MaxConcurrentCount</code> is at most one more than the <code>FailureToleranceCount</code>.</p>
    /// <p>Note that this setting lets you specify the <i>maximum</i> for operations. For large deployments, under certain circumstances the actual number of accounts acted upon concurrently may be lower due to service throttling.</p>
    /// <p>Conditional: You must specify either <code>MaxConcurrentCount</code> or <code>MaxConcurrentPercentage</code>, but not both.</p>
    /// <p>By default, <code>1</code> is specified.</p>
    pub fn max_concurrent_count(&self) -> std::option::Option<i32> {
        self.max_concurrent_count
    }
    /// <p>The maximum percentage of accounts in which to perform this operation at one time.</p>
    /// <p>When calculating the number of accounts based on the specified percentage, CloudFormation rounds down to the next whole number. This is true except in cases where rounding down would result is zero. In this case, CloudFormation sets the number as one instead.</p>
    /// <p>Note that this setting lets you specify the <i>maximum</i> for operations. For large deployments, under certain circumstances the actual number of accounts acted upon concurrently may be lower due to service throttling.</p>
    /// <p>Conditional: You must specify either <code>MaxConcurrentCount</code> or <code>MaxConcurrentPercentage</code>, but not both.</p>
    /// <p>By default, <code>1</code> is specified.</p>
    pub fn max_concurrent_percentage(&self) -> std::option::Option<i32> {
        self.max_concurrent_percentage
    }
}
impl std::fmt::Debug for StackSetOperationPreferences {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StackSetOperationPreferences");
        formatter.field("region_concurrency_type", &self.region_concurrency_type);
        formatter.field("region_order", &self.region_order);
        formatter.field("failure_tolerance_count", &self.failure_tolerance_count);
        formatter.field(
            "failure_tolerance_percentage",
            &self.failure_tolerance_percentage,
        );
        formatter.field("max_concurrent_count", &self.max_concurrent_count);
        formatter.field("max_concurrent_percentage", &self.max_concurrent_percentage);
        formatter.finish()
    }
}
/// See [`StackSetOperationPreferences`](crate::model::StackSetOperationPreferences)
pub mod stack_set_operation_preferences {
    /// A builder for [`StackSetOperationPreferences`](crate::model::StackSetOperationPreferences)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) region_concurrency_type:
            std::option::Option<crate::model::RegionConcurrencyType>,
        pub(crate) region_order: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) failure_tolerance_count: std::option::Option<i32>,
        pub(crate) failure_tolerance_percentage: std::option::Option<i32>,
        pub(crate) max_concurrent_count: std::option::Option<i32>,
        pub(crate) max_concurrent_percentage: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The concurrency type of deploying StackSets operations in Regions, could be in parallel or one Region at a time.</p>
        pub fn region_concurrency_type(
            mut self,
            input: crate::model::RegionConcurrencyType,
        ) -> Self {
            self.region_concurrency_type = Some(input);
            self
        }
        /// <p>The concurrency type of deploying StackSets operations in Regions, could be in parallel or one Region at a time.</p>
        pub fn set_region_concurrency_type(
            mut self,
            input: std::option::Option<crate::model::RegionConcurrencyType>,
        ) -> Self {
            self.region_concurrency_type = input;
            self
        }
        /// Appends an item to `region_order`.
        ///
        /// To override the contents of this collection use [`set_region_order`](Self::set_region_order).
        ///
        /// <p>The order of the Regions in where you want to perform the stack operation.</p>
        pub fn region_order(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.region_order.unwrap_or_default();
            v.push(input.into());
            self.region_order = Some(v);
            self
        }
        /// <p>The order of the Regions in where you want to perform the stack operation.</p>
        pub fn set_region_order(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.region_order = input;
            self
        }
        /// <p>The number of accounts, per Region, for which this operation can fail before CloudFormation stops the operation in that Region. If the operation is stopped in a Region, CloudFormation doesn't attempt the operation in any subsequent Regions.</p>
        /// <p>Conditional: You must specify either <code>FailureToleranceCount</code> or <code>FailureTolerancePercentage</code> (but not both).</p>
        /// <p>By default, <code>0</code> is specified.</p>
        pub fn failure_tolerance_count(mut self, input: i32) -> Self {
            self.failure_tolerance_count = Some(input);
            self
        }
        /// <p>The number of accounts, per Region, for which this operation can fail before CloudFormation stops the operation in that Region. If the operation is stopped in a Region, CloudFormation doesn't attempt the operation in any subsequent Regions.</p>
        /// <p>Conditional: You must specify either <code>FailureToleranceCount</code> or <code>FailureTolerancePercentage</code> (but not both).</p>
        /// <p>By default, <code>0</code> is specified.</p>
        pub fn set_failure_tolerance_count(mut self, input: std::option::Option<i32>) -> Self {
            self.failure_tolerance_count = input;
            self
        }
        /// <p>The percentage of accounts, per Region, for which this stack operation can fail before CloudFormation stops the operation in that Region. If the operation is stopped in a Region, CloudFormation doesn't attempt the operation in any subsequent Regions.</p>
        /// <p>When calculating the number of accounts based on the specified percentage, CloudFormation rounds <i>down</i> to the next whole number.</p>
        /// <p>Conditional: You must specify either <code>FailureToleranceCount</code> or <code>FailureTolerancePercentage</code>, but not both.</p>
        /// <p>By default, <code>0</code> is specified.</p>
        pub fn failure_tolerance_percentage(mut self, input: i32) -> Self {
            self.failure_tolerance_percentage = Some(input);
            self
        }
        /// <p>The percentage of accounts, per Region, for which this stack operation can fail before CloudFormation stops the operation in that Region. If the operation is stopped in a Region, CloudFormation doesn't attempt the operation in any subsequent Regions.</p>
        /// <p>When calculating the number of accounts based on the specified percentage, CloudFormation rounds <i>down</i> to the next whole number.</p>
        /// <p>Conditional: You must specify either <code>FailureToleranceCount</code> or <code>FailureTolerancePercentage</code>, but not both.</p>
        /// <p>By default, <code>0</code> is specified.</p>
        pub fn set_failure_tolerance_percentage(mut self, input: std::option::Option<i32>) -> Self {
            self.failure_tolerance_percentage = input;
            self
        }
        /// <p>The maximum number of accounts in which to perform this operation at one time. This is dependent on the value of <code>FailureToleranceCount</code>. <code>MaxConcurrentCount</code> is at most one more than the <code>FailureToleranceCount</code>.</p>
        /// <p>Note that this setting lets you specify the <i>maximum</i> for operations. For large deployments, under certain circumstances the actual number of accounts acted upon concurrently may be lower due to service throttling.</p>
        /// <p>Conditional: You must specify either <code>MaxConcurrentCount</code> or <code>MaxConcurrentPercentage</code>, but not both.</p>
        /// <p>By default, <code>1</code> is specified.</p>
        pub fn max_concurrent_count(mut self, input: i32) -> Self {
            self.max_concurrent_count = Some(input);
            self
        }
        /// <p>The maximum number of accounts in which to perform this operation at one time. This is dependent on the value of <code>FailureToleranceCount</code>. <code>MaxConcurrentCount</code> is at most one more than the <code>FailureToleranceCount</code>.</p>
        /// <p>Note that this setting lets you specify the <i>maximum</i> for operations. For large deployments, under certain circumstances the actual number of accounts acted upon concurrently may be lower due to service throttling.</p>
        /// <p>Conditional: You must specify either <code>MaxConcurrentCount</code> or <code>MaxConcurrentPercentage</code>, but not both.</p>
        /// <p>By default, <code>1</code> is specified.</p>
        pub fn set_max_concurrent_count(mut self, input: std::option::Option<i32>) -> Self {
            self.max_concurrent_count = input;
            self
        }
        /// <p>The maximum percentage of accounts in which to perform this operation at one time.</p>
        /// <p>When calculating the number of accounts based on the specified percentage, CloudFormation rounds down to the next whole number. This is true except in cases where rounding down would result is zero. In this case, CloudFormation sets the number as one instead.</p>
        /// <p>Note that this setting lets you specify the <i>maximum</i> for operations. For large deployments, under certain circumstances the actual number of accounts acted upon concurrently may be lower due to service throttling.</p>
        /// <p>Conditional: You must specify either <code>MaxConcurrentCount</code> or <code>MaxConcurrentPercentage</code>, but not both.</p>
        /// <p>By default, <code>1</code> is specified.</p>
        pub fn max_concurrent_percentage(mut self, input: i32) -> Self {
            self.max_concurrent_percentage = Some(input);
            self
        }
        /// <p>The maximum percentage of accounts in which to perform this operation at one time.</p>
        /// <p>When calculating the number of accounts based on the specified percentage, CloudFormation rounds down to the next whole number. This is true except in cases where rounding down would result is zero. In this case, CloudFormation sets the number as one instead.</p>
        /// <p>Note that this setting lets you specify the <i>maximum</i> for operations. For large deployments, under certain circumstances the actual number of accounts acted upon concurrently may be lower due to service throttling.</p>
        /// <p>Conditional: You must specify either <code>MaxConcurrentCount</code> or <code>MaxConcurrentPercentage</code>, but not both.</p>
        /// <p>By default, <code>1</code> is specified.</p>
        pub fn set_max_concurrent_percentage(mut self, input: std::option::Option<i32>) -> Self {
            self.max_concurrent_percentage = input;
            self
        }
        /// Consumes the builder and constructs a [`StackSetOperationPreferences`](crate::model::StackSetOperationPreferences)
        pub fn build(self) -> crate::model::StackSetOperationPreferences {
            crate::model::StackSetOperationPreferences {
                region_concurrency_type: self.region_concurrency_type,
                region_order: self.region_order,
                failure_tolerance_count: self.failure_tolerance_count,
                failure_tolerance_percentage: self.failure_tolerance_percentage,
                max_concurrent_count: self.max_concurrent_count,
                max_concurrent_percentage: self.max_concurrent_percentage,
            }
        }
    }
}
impl StackSetOperationPreferences {
    /// Creates a new builder-style object to manufacture [`StackSetOperationPreferences`](crate::model::StackSetOperationPreferences)
    pub fn builder() -> crate::model::stack_set_operation_preferences::Builder {
        crate::model::stack_set_operation_preferences::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum RegionConcurrencyType {
    #[allow(missing_docs)] // documentation missing in model
    Parallel,
    #[allow(missing_docs)] // documentation missing in model
    Sequential,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for RegionConcurrencyType {
    fn from(s: &str) -> Self {
        match s {
            "PARALLEL" => RegionConcurrencyType::Parallel,
            "SEQUENTIAL" => RegionConcurrencyType::Sequential,
            other => RegionConcurrencyType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for RegionConcurrencyType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(RegionConcurrencyType::from(s))
    }
}
impl RegionConcurrencyType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            RegionConcurrencyType::Parallel => "PARALLEL",
            RegionConcurrencyType::Sequential => "SEQUENTIAL",
            RegionConcurrencyType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["PARALLEL", "SEQUENTIAL"]
    }
}
impl AsRef<str> for RegionConcurrencyType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The Tag type enables you to specify a key-value pair that can be used to store information about an CloudFormation stack.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Tag {
    /// <p> <i>Required</i>. A string used to identify this tag. You can specify a maximum of 128 characters for a tag key. Tags owned by Amazon Web Services (Amazon Web Services) have the reserved prefix: <code>aws:</code>.</p>
    pub key: std::option::Option<std::string::String>,
    /// <p> <i>Required</i>. A string containing the value for this tag. You can specify a maximum of 256 characters for a tag value.</p>
    pub value: std::option::Option<std::string::String>,
}
impl Tag {
    /// <p> <i>Required</i>. A string used to identify this tag. You can specify a maximum of 128 characters for a tag key. Tags owned by Amazon Web Services (Amazon Web Services) have the reserved prefix: <code>aws:</code>.</p>
    pub fn key(&self) -> std::option::Option<&str> {
        self.key.as_deref()
    }
    /// <p> <i>Required</i>. A string containing the value for this tag. You can specify a maximum of 256 characters for a tag value.</p>
    pub fn value(&self) -> std::option::Option<&str> {
        self.value.as_deref()
    }
}
impl std::fmt::Debug for Tag {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Tag");
        formatter.field("key", &self.key);
        formatter.field("value", &self.value);
        formatter.finish()
    }
}
/// See [`Tag`](crate::model::Tag)
pub mod tag {
    /// A builder for [`Tag`](crate::model::Tag)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) key: std::option::Option<std::string::String>,
        pub(crate) value: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p> <i>Required</i>. A string used to identify this tag. You can specify a maximum of 128 characters for a tag key. Tags owned by Amazon Web Services (Amazon Web Services) have the reserved prefix: <code>aws:</code>.</p>
        pub fn key(mut self, input: impl Into<std::string::String>) -> Self {
            self.key = Some(input.into());
            self
        }
        /// <p> <i>Required</i>. A string used to identify this tag. You can specify a maximum of 128 characters for a tag key. Tags owned by Amazon Web Services (Amazon Web Services) have the reserved prefix: <code>aws:</code>.</p>
        pub fn set_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key = input;
            self
        }
        /// <p> <i>Required</i>. A string containing the value for this tag. You can specify a maximum of 256 characters for a tag value.</p>
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            self.value = Some(input.into());
            self
        }
        /// <p> <i>Required</i>. A string containing the value for this tag. You can specify a maximum of 256 characters for a tag value.</p>
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.value = input;
            self
        }
        /// Consumes the builder and constructs a [`Tag`](crate::model::Tag)
        pub fn build(self) -> crate::model::Tag {
            crate::model::Tag {
                key: self.key,
                value: self.value,
            }
        }
    }
}
impl Tag {
    /// Creates a new builder-style object to manufacture [`Tag`](crate::model::Tag)
    pub fn builder() -> crate::model::tag::Builder {
        crate::model::tag::Builder::default()
    }
}

/// <p>The Parameter data type.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Parameter {
    /// <p>The key associated with the parameter. If you don't specify a key and value for a particular parameter, CloudFormation uses the default value that is specified in your template.</p>
    pub parameter_key: std::option::Option<std::string::String>,
    /// <p>The input value associated with the parameter.</p>
    pub parameter_value: std::option::Option<std::string::String>,
    /// <p>During a stack update, use the existing parameter value that the stack is using for a given parameter key. If you specify <code>true</code>, do not specify a parameter value.</p>
    pub use_previous_value: std::option::Option<bool>,
    /// <p>Read-only. Read-only. The value that corresponds to a SSM parameter key. This field is returned only for <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/parameters-section-structure.html#aws-ssm-parameter-types"> <code>SSM</code> </a> parameter types in the template.</p>
    pub resolved_value: std::option::Option<std::string::String>,
}
impl Parameter {
    /// <p>The key associated with the parameter. If you don't specify a key and value for a particular parameter, CloudFormation uses the default value that is specified in your template.</p>
    pub fn parameter_key(&self) -> std::option::Option<&str> {
        self.parameter_key.as_deref()
    }
    /// <p>The input value associated with the parameter.</p>
    pub fn parameter_value(&self) -> std::option::Option<&str> {
        self.parameter_value.as_deref()
    }
    /// <p>During a stack update, use the existing parameter value that the stack is using for a given parameter key. If you specify <code>true</code>, do not specify a parameter value.</p>
    pub fn use_previous_value(&self) -> std::option::Option<bool> {
        self.use_previous_value
    }
    /// <p>Read-only. Read-only. The value that corresponds to a SSM parameter key. This field is returned only for <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/parameters-section-structure.html#aws-ssm-parameter-types"> <code>SSM</code> </a> parameter types in the template.</p>
    pub fn resolved_value(&self) -> std::option::Option<&str> {
        self.resolved_value.as_deref()
    }
}
impl std::fmt::Debug for Parameter {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Parameter");
        formatter.field("parameter_key", &self.parameter_key);
        formatter.field("parameter_value", &self.parameter_value);
        formatter.field("use_previous_value", &self.use_previous_value);
        formatter.field("resolved_value", &self.resolved_value);
        formatter.finish()
    }
}
/// See [`Parameter`](crate::model::Parameter)
pub mod parameter {
    /// A builder for [`Parameter`](crate::model::Parameter)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) parameter_key: std::option::Option<std::string::String>,
        pub(crate) parameter_value: std::option::Option<std::string::String>,
        pub(crate) use_previous_value: std::option::Option<bool>,
        pub(crate) resolved_value: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The key associated with the parameter. If you don't specify a key and value for a particular parameter, CloudFormation uses the default value that is specified in your template.</p>
        pub fn parameter_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.parameter_key = Some(input.into());
            self
        }
        /// <p>The key associated with the parameter. If you don't specify a key and value for a particular parameter, CloudFormation uses the default value that is specified in your template.</p>
        pub fn set_parameter_key(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.parameter_key = input;
            self
        }
        /// <p>The input value associated with the parameter.</p>
        pub fn parameter_value(mut self, input: impl Into<std::string::String>) -> Self {
            self.parameter_value = Some(input.into());
            self
        }
        /// <p>The input value associated with the parameter.</p>
        pub fn set_parameter_value(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.parameter_value = input;
            self
        }
        /// <p>During a stack update, use the existing parameter value that the stack is using for a given parameter key. If you specify <code>true</code>, do not specify a parameter value.</p>
        pub fn use_previous_value(mut self, input: bool) -> Self {
            self.use_previous_value = Some(input);
            self
        }
        /// <p>During a stack update, use the existing parameter value that the stack is using for a given parameter key. If you specify <code>true</code>, do not specify a parameter value.</p>
        pub fn set_use_previous_value(mut self, input: std::option::Option<bool>) -> Self {
            self.use_previous_value = input;
            self
        }
        /// <p>Read-only. Read-only. The value that corresponds to a SSM parameter key. This field is returned only for <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/parameters-section-structure.html#aws-ssm-parameter-types"> <code>SSM</code> </a> parameter types in the template.</p>
        pub fn resolved_value(mut self, input: impl Into<std::string::String>) -> Self {
            self.resolved_value = Some(input.into());
            self
        }
        /// <p>Read-only. Read-only. The value that corresponds to a SSM parameter key. This field is returned only for <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/parameters-section-structure.html#aws-ssm-parameter-types"> <code>SSM</code> </a> parameter types in the template.</p>
        pub fn set_resolved_value(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resolved_value = input;
            self
        }
        /// Consumes the builder and constructs a [`Parameter`](crate::model::Parameter)
        pub fn build(self) -> crate::model::Parameter {
            crate::model::Parameter {
                parameter_key: self.parameter_key,
                parameter_value: self.parameter_value,
                use_previous_value: self.use_previous_value,
                resolved_value: self.resolved_value,
            }
        }
    }
}
impl Parameter {
    /// Creates a new builder-style object to manufacture [`Parameter`](crate::model::Parameter)
    pub fn builder() -> crate::model::parameter::Builder {
        crate::model::parameter::Builder::default()
    }
}

/// <p>Structure containing the rollback triggers for CloudFormation to monitor during stack creation and updating operations, and for the specified monitoring period afterwards.</p>
/// <p>Rollback triggers enable you to have CloudFormation monitor the state of your application during stack creation and updating, and to roll back that operation if the application breaches the threshold of any of the alarms you've specified. For more information, see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-rollback-triggers.html">Monitor and Roll Back Stack Operations</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RollbackConfiguration {
    /// <p>The triggers to monitor during stack creation or update actions. </p>
    /// <p>By default, CloudFormation saves the rollback triggers specified for a stack and applies them to any subsequent update operations for the stack, unless you specify otherwise. If you do specify rollback triggers for this parameter, those triggers replace any list of triggers previously specified for the stack. This means:</p>
    /// <ul>
    /// <li> <p>To use the rollback triggers previously specified for this stack, if any, don't specify this parameter.</p> </li>
    /// <li> <p>To specify new or updated rollback triggers, you must specify <i>all</i> the triggers that you want used for this stack, even triggers you've specifed before (for example, when creating the stack or during a previous stack update). Any triggers that you don't include in the updated list of triggers are no longer applied to the stack.</p> </li>
    /// <li> <p>To remove all currently specified triggers, specify an empty list for this parameter.</p> </li>
    /// </ul>
    /// <p>If a specified trigger is missing, the entire stack operation fails and is rolled back. </p>
    pub rollback_triggers: std::option::Option<std::vec::Vec<crate::model::RollbackTrigger>>,
    /// <p>The amount of time, in minutes, during which CloudFormation should monitor all the rollback triggers after the stack creation or update operation deploys all necessary resources.</p>
    /// <p>The default is 0 minutes.</p>
    /// <p>If you specify a monitoring period but do not specify any rollback triggers, CloudFormation still waits the specified period of time before cleaning up old resources after update operations. You can use this monitoring period to perform any manual stack validation desired, and manually cancel the stack creation or update (using <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_CancelUpdateStack.html">CancelUpdateStack</a>, for example) as necessary.</p>
    /// <p>If you specify 0 for this parameter, CloudFormation still monitors the specified rollback triggers during stack creation and update operations. Then, for update operations, it begins disposing of old resources immediately once the operation completes.</p>
    pub monitoring_time_in_minutes: std::option::Option<i32>,
}
impl RollbackConfiguration {
    /// <p>The triggers to monitor during stack creation or update actions. </p>
    /// <p>By default, CloudFormation saves the rollback triggers specified for a stack and applies them to any subsequent update operations for the stack, unless you specify otherwise. If you do specify rollback triggers for this parameter, those triggers replace any list of triggers previously specified for the stack. This means:</p>
    /// <ul>
    /// <li> <p>To use the rollback triggers previously specified for this stack, if any, don't specify this parameter.</p> </li>
    /// <li> <p>To specify new or updated rollback triggers, you must specify <i>all</i> the triggers that you want used for this stack, even triggers you've specifed before (for example, when creating the stack or during a previous stack update). Any triggers that you don't include in the updated list of triggers are no longer applied to the stack.</p> </li>
    /// <li> <p>To remove all currently specified triggers, specify an empty list for this parameter.</p> </li>
    /// </ul>
    /// <p>If a specified trigger is missing, the entire stack operation fails and is rolled back. </p>
    pub fn rollback_triggers(&self) -> std::option::Option<&[crate::model::RollbackTrigger]> {
        self.rollback_triggers.as_deref()
    }
    /// <p>The amount of time, in minutes, during which CloudFormation should monitor all the rollback triggers after the stack creation or update operation deploys all necessary resources.</p>
    /// <p>The default is 0 minutes.</p>
    /// <p>If you specify a monitoring period but do not specify any rollback triggers, CloudFormation still waits the specified period of time before cleaning up old resources after update operations. You can use this monitoring period to perform any manual stack validation desired, and manually cancel the stack creation or update (using <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_CancelUpdateStack.html">CancelUpdateStack</a>, for example) as necessary.</p>
    /// <p>If you specify 0 for this parameter, CloudFormation still monitors the specified rollback triggers during stack creation and update operations. Then, for update operations, it begins disposing of old resources immediately once the operation completes.</p>
    pub fn monitoring_time_in_minutes(&self) -> std::option::Option<i32> {
        self.monitoring_time_in_minutes
    }
}
impl std::fmt::Debug for RollbackConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RollbackConfiguration");
        formatter.field("rollback_triggers", &self.rollback_triggers);
        formatter.field(
            "monitoring_time_in_minutes",
            &self.monitoring_time_in_minutes,
        );
        formatter.finish()
    }
}
/// See [`RollbackConfiguration`](crate::model::RollbackConfiguration)
pub mod rollback_configuration {
    /// A builder for [`RollbackConfiguration`](crate::model::RollbackConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) rollback_triggers:
            std::option::Option<std::vec::Vec<crate::model::RollbackTrigger>>,
        pub(crate) monitoring_time_in_minutes: std::option::Option<i32>,
    }
    impl Builder {
        /// Appends an item to `rollback_triggers`.
        ///
        /// To override the contents of this collection use [`set_rollback_triggers`](Self::set_rollback_triggers).
        ///
        /// <p>The triggers to monitor during stack creation or update actions. </p>
        /// <p>By default, CloudFormation saves the rollback triggers specified for a stack and applies them to any subsequent update operations for the stack, unless you specify otherwise. If you do specify rollback triggers for this parameter, those triggers replace any list of triggers previously specified for the stack. This means:</p>
        /// <ul>
        /// <li> <p>To use the rollback triggers previously specified for this stack, if any, don't specify this parameter.</p> </li>
        /// <li> <p>To specify new or updated rollback triggers, you must specify <i>all</i> the triggers that you want used for this stack, even triggers you've specifed before (for example, when creating the stack or during a previous stack update). Any triggers that you don't include in the updated list of triggers are no longer applied to the stack.</p> </li>
        /// <li> <p>To remove all currently specified triggers, specify an empty list for this parameter.</p> </li>
        /// </ul>
        /// <p>If a specified trigger is missing, the entire stack operation fails and is rolled back. </p>
        pub fn rollback_triggers(mut self, input: crate::model::RollbackTrigger) -> Self {
            let mut v = self.rollback_triggers.unwrap_or_default();
            v.push(input);
            self.rollback_triggers = Some(v);
            self
        }
        /// <p>The triggers to monitor during stack creation or update actions. </p>
        /// <p>By default, CloudFormation saves the rollback triggers specified for a stack and applies them to any subsequent update operations for the stack, unless you specify otherwise. If you do specify rollback triggers for this parameter, those triggers replace any list of triggers previously specified for the stack. This means:</p>
        /// <ul>
        /// <li> <p>To use the rollback triggers previously specified for this stack, if any, don't specify this parameter.</p> </li>
        /// <li> <p>To specify new or updated rollback triggers, you must specify <i>all</i> the triggers that you want used for this stack, even triggers you've specifed before (for example, when creating the stack or during a previous stack update). Any triggers that you don't include in the updated list of triggers are no longer applied to the stack.</p> </li>
        /// <li> <p>To remove all currently specified triggers, specify an empty list for this parameter.</p> </li>
        /// </ul>
        /// <p>If a specified trigger is missing, the entire stack operation fails and is rolled back. </p>
        pub fn set_rollback_triggers(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::RollbackTrigger>>,
        ) -> Self {
            self.rollback_triggers = input;
            self
        }
        /// <p>The amount of time, in minutes, during which CloudFormation should monitor all the rollback triggers after the stack creation or update operation deploys all necessary resources.</p>
        /// <p>The default is 0 minutes.</p>
        /// <p>If you specify a monitoring period but do not specify any rollback triggers, CloudFormation still waits the specified period of time before cleaning up old resources after update operations. You can use this monitoring period to perform any manual stack validation desired, and manually cancel the stack creation or update (using <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_CancelUpdateStack.html">CancelUpdateStack</a>, for example) as necessary.</p>
        /// <p>If you specify 0 for this parameter, CloudFormation still monitors the specified rollback triggers during stack creation and update operations. Then, for update operations, it begins disposing of old resources immediately once the operation completes.</p>
        pub fn monitoring_time_in_minutes(mut self, input: i32) -> Self {
            self.monitoring_time_in_minutes = Some(input);
            self
        }
        /// <p>The amount of time, in minutes, during which CloudFormation should monitor all the rollback triggers after the stack creation or update operation deploys all necessary resources.</p>
        /// <p>The default is 0 minutes.</p>
        /// <p>If you specify a monitoring period but do not specify any rollback triggers, CloudFormation still waits the specified period of time before cleaning up old resources after update operations. You can use this monitoring period to perform any manual stack validation desired, and manually cancel the stack creation or update (using <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_CancelUpdateStack.html">CancelUpdateStack</a>, for example) as necessary.</p>
        /// <p>If you specify 0 for this parameter, CloudFormation still monitors the specified rollback triggers during stack creation and update operations. Then, for update operations, it begins disposing of old resources immediately once the operation completes.</p>
        pub fn set_monitoring_time_in_minutes(mut self, input: std::option::Option<i32>) -> Self {
            self.monitoring_time_in_minutes = input;
            self
        }
        /// Consumes the builder and constructs a [`RollbackConfiguration`](crate::model::RollbackConfiguration)
        pub fn build(self) -> crate::model::RollbackConfiguration {
            crate::model::RollbackConfiguration {
                rollback_triggers: self.rollback_triggers,
                monitoring_time_in_minutes: self.monitoring_time_in_minutes,
            }
        }
    }
}
impl RollbackConfiguration {
    /// Creates a new builder-style object to manufacture [`RollbackConfiguration`](crate::model::RollbackConfiguration)
    pub fn builder() -> crate::model::rollback_configuration::Builder {
        crate::model::rollback_configuration::Builder::default()
    }
}

/// <p>A rollback trigger CloudFormation monitors during creation and updating of stacks. If any of the alarms you specify goes to ALARM state during the stack operation or within the specified monitoring period afterwards, CloudFormation rolls back the entire stack operation. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RollbackTrigger {
    /// <p>The Amazon Resource Name (ARN) of the rollback trigger.</p>
    /// <p>If a specified trigger is missing, the entire stack operation fails and is rolled back. </p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The resource type of the rollback trigger. Specify either <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cw-alarm.html">AWS::CloudWatch::Alarm</a> or <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudwatch-compositealarm.html">AWS::CloudWatch::CompositeAlarm</a> resource types.</p>
    pub r#type: std::option::Option<std::string::String>,
}
impl RollbackTrigger {
    /// <p>The Amazon Resource Name (ARN) of the rollback trigger.</p>
    /// <p>If a specified trigger is missing, the entire stack operation fails and is rolled back. </p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The resource type of the rollback trigger. Specify either <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cw-alarm.html">AWS::CloudWatch::Alarm</a> or <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudwatch-compositealarm.html">AWS::CloudWatch::CompositeAlarm</a> resource types.</p>
    pub fn r#type(&self) -> std::option::Option<&str> {
        self.r#type.as_deref()
    }
}
impl std::fmt::Debug for RollbackTrigger {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RollbackTrigger");
        formatter.field("arn", &self.arn);
        formatter.field("r#type", &self.r#type);
        formatter.finish()
    }
}
/// See [`RollbackTrigger`](crate::model::RollbackTrigger)
pub mod rollback_trigger {
    /// A builder for [`RollbackTrigger`](crate::model::RollbackTrigger)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) r#type: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the rollback trigger.</p>
        /// <p>If a specified trigger is missing, the entire stack operation fails and is rolled back. </p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the rollback trigger.</p>
        /// <p>If a specified trigger is missing, the entire stack operation fails and is rolled back. </p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The resource type of the rollback trigger. Specify either <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cw-alarm.html">AWS::CloudWatch::Alarm</a> or <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudwatch-compositealarm.html">AWS::CloudWatch::CompositeAlarm</a> resource types.</p>
        pub fn r#type(mut self, input: impl Into<std::string::String>) -> Self {
            self.r#type = Some(input.into());
            self
        }
        /// <p>The resource type of the rollback trigger. Specify either <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cw-alarm.html">AWS::CloudWatch::Alarm</a> or <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudwatch-compositealarm.html">AWS::CloudWatch::CompositeAlarm</a> resource types.</p>
        pub fn set_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.r#type = input;
            self
        }
        /// Consumes the builder and constructs a [`RollbackTrigger`](crate::model::RollbackTrigger)
        pub fn build(self) -> crate::model::RollbackTrigger {
            crate::model::RollbackTrigger {
                arn: self.arn,
                r#type: self.r#type,
            }
        }
    }
}
impl RollbackTrigger {
    /// Creates a new builder-style object to manufacture [`RollbackTrigger`](crate::model::RollbackTrigger)
    pub fn builder() -> crate::model::rollback_trigger::Builder {
        crate::model::rollback_trigger::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ThirdPartyType {
    #[allow(missing_docs)] // documentation missing in model
    Module,
    #[allow(missing_docs)] // documentation missing in model
    Resource,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ThirdPartyType {
    fn from(s: &str) -> Self {
        match s {
            "MODULE" => ThirdPartyType::Module,
            "RESOURCE" => ThirdPartyType::Resource,
            other => ThirdPartyType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ThirdPartyType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ThirdPartyType::from(s))
    }
}
impl ThirdPartyType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ThirdPartyType::Module => "MODULE",
            ThirdPartyType::Resource => "RESOURCE",
            ThirdPartyType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["MODULE", "RESOURCE"]
    }
}
impl AsRef<str> for ThirdPartyType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ResourceSignalStatus {
    #[allow(missing_docs)] // documentation missing in model
    Failure,
    #[allow(missing_docs)] // documentation missing in model
    Success,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ResourceSignalStatus {
    fn from(s: &str) -> Self {
        match s {
            "FAILURE" => ResourceSignalStatus::Failure,
            "SUCCESS" => ResourceSignalStatus::Success,
            other => ResourceSignalStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ResourceSignalStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ResourceSignalStatus::from(s))
    }
}
impl ResourceSignalStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ResourceSignalStatus::Failure => "FAILURE",
            ResourceSignalStatus::Success => "SUCCESS",
            ResourceSignalStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["FAILURE", "SUCCESS"]
    }
}
impl AsRef<str> for ResourceSignalStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum RegistryType {
    #[allow(missing_docs)] // documentation missing in model
    Module,
    #[allow(missing_docs)] // documentation missing in model
    Resource,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for RegistryType {
    fn from(s: &str) -> Self {
        match s {
            "MODULE" => RegistryType::Module,
            "RESOURCE" => RegistryType::Resource,
            other => RegistryType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for RegistryType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(RegistryType::from(s))
    }
}
impl RegistryType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            RegistryType::Module => "MODULE",
            RegistryType::Resource => "RESOURCE",
            RegistryType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["MODULE", "RESOURCE"]
    }
}
impl AsRef<str> for RegistryType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Contains logging configuration information for an extension.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LoggingConfig {
    /// <p>The ARN of the role that CloudFormation should assume when sending log entries to CloudWatch logs.</p>
    pub log_role_arn: std::option::Option<std::string::String>,
    /// <p>The Amazon CloudWatch log group to which CloudFormation sends error logging information when invoking the extension's handlers.</p>
    pub log_group_name: std::option::Option<std::string::String>,
}
impl LoggingConfig {
    /// <p>The ARN of the role that CloudFormation should assume when sending log entries to CloudWatch logs.</p>
    pub fn log_role_arn(&self) -> std::option::Option<&str> {
        self.log_role_arn.as_deref()
    }
    /// <p>The Amazon CloudWatch log group to which CloudFormation sends error logging information when invoking the extension's handlers.</p>
    pub fn log_group_name(&self) -> std::option::Option<&str> {
        self.log_group_name.as_deref()
    }
}
impl std::fmt::Debug for LoggingConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LoggingConfig");
        formatter.field("log_role_arn", &self.log_role_arn);
        formatter.field("log_group_name", &self.log_group_name);
        formatter.finish()
    }
}
/// See [`LoggingConfig`](crate::model::LoggingConfig)
pub mod logging_config {
    /// A builder for [`LoggingConfig`](crate::model::LoggingConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) log_role_arn: std::option::Option<std::string::String>,
        pub(crate) log_group_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the role that CloudFormation should assume when sending log entries to CloudWatch logs.</p>
        pub fn log_role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.log_role_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the role that CloudFormation should assume when sending log entries to CloudWatch logs.</p>
        pub fn set_log_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.log_role_arn = input;
            self
        }
        /// <p>The Amazon CloudWatch log group to which CloudFormation sends error logging information when invoking the extension's handlers.</p>
        pub fn log_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.log_group_name = Some(input.into());
            self
        }
        /// <p>The Amazon CloudWatch log group to which CloudFormation sends error logging information when invoking the extension's handlers.</p>
        pub fn set_log_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.log_group_name = input;
            self
        }
        /// Consumes the builder and constructs a [`LoggingConfig`](crate::model::LoggingConfig)
        pub fn build(self) -> crate::model::LoggingConfig {
            crate::model::LoggingConfig {
                log_role_arn: self.log_role_arn,
                log_group_name: self.log_group_name,
            }
        }
    }
}
impl LoggingConfig {
    /// Creates a new builder-style object to manufacture [`LoggingConfig`](crate::model::LoggingConfig)
    pub fn builder() -> crate::model::logging_config::Builder {
        crate::model::logging_config::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum HandlerErrorCode {
    #[allow(missing_docs)] // documentation missing in model
    AccessDenied,
    #[allow(missing_docs)] // documentation missing in model
    AlreadyExists,
    #[allow(missing_docs)] // documentation missing in model
    GeneralServiceException,
    #[allow(missing_docs)] // documentation missing in model
    InternalFailure,
    #[allow(missing_docs)] // documentation missing in model
    InvalidCredentials,
    #[allow(missing_docs)] // documentation missing in model
    InvalidRequest,
    #[allow(missing_docs)] // documentation missing in model
    InvalidTypeConfiguration,
    #[allow(missing_docs)] // documentation missing in model
    NetworkFailure,
    #[allow(missing_docs)] // documentation missing in model
    NotFound,
    #[allow(missing_docs)] // documentation missing in model
    ServiceTimeout,
    #[allow(missing_docs)] // documentation missing in model
    NotUpdatable,
    #[allow(missing_docs)] // documentation missing in model
    ResourceConflict,
    #[allow(missing_docs)] // documentation missing in model
    ServiceInternalError,
    #[allow(missing_docs)] // documentation missing in model
    ServiceLimitExceeded,
    #[allow(missing_docs)] // documentation missing in model
    Throttling,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for HandlerErrorCode {
    fn from(s: &str) -> Self {
        match s {
            "AccessDenied" => HandlerErrorCode::AccessDenied,
            "AlreadyExists" => HandlerErrorCode::AlreadyExists,
            "GeneralServiceException" => HandlerErrorCode::GeneralServiceException,
            "InternalFailure" => HandlerErrorCode::InternalFailure,
            "InvalidCredentials" => HandlerErrorCode::InvalidCredentials,
            "InvalidRequest" => HandlerErrorCode::InvalidRequest,
            "InvalidTypeConfiguration" => HandlerErrorCode::InvalidTypeConfiguration,
            "NetworkFailure" => HandlerErrorCode::NetworkFailure,
            "NotFound" => HandlerErrorCode::NotFound,
            "NotStabilized" => HandlerErrorCode::ServiceTimeout,
            "NotUpdatable" => HandlerErrorCode::NotUpdatable,
            "ResourceConflict" => HandlerErrorCode::ResourceConflict,
            "ServiceInternalError" => HandlerErrorCode::ServiceInternalError,
            "ServiceLimitExceeded" => HandlerErrorCode::ServiceLimitExceeded,
            "Throttling" => HandlerErrorCode::Throttling,
            other => HandlerErrorCode::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for HandlerErrorCode {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(HandlerErrorCode::from(s))
    }
}
impl HandlerErrorCode {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            HandlerErrorCode::AccessDenied => "AccessDenied",
            HandlerErrorCode::AlreadyExists => "AlreadyExists",
            HandlerErrorCode::GeneralServiceException => "GeneralServiceException",
            HandlerErrorCode::InternalFailure => "InternalFailure",
            HandlerErrorCode::InvalidCredentials => "InvalidCredentials",
            HandlerErrorCode::InvalidRequest => "InvalidRequest",
            HandlerErrorCode::InvalidTypeConfiguration => "InvalidTypeConfiguration",
            HandlerErrorCode::NetworkFailure => "NetworkFailure",
            HandlerErrorCode::NotFound => "NotFound",
            HandlerErrorCode::ServiceTimeout => "NotStabilized",
            HandlerErrorCode::NotUpdatable => "NotUpdatable",
            HandlerErrorCode::ResourceConflict => "ResourceConflict",
            HandlerErrorCode::ServiceInternalError => "ServiceInternalError",
            HandlerErrorCode::ServiceLimitExceeded => "ServiceLimitExceeded",
            HandlerErrorCode::Throttling => "Throttling",
            HandlerErrorCode::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "AccessDenied",
            "AlreadyExists",
            "GeneralServiceException",
            "InternalFailure",
            "InvalidCredentials",
            "InvalidRequest",
            "InvalidTypeConfiguration",
            "NetworkFailure",
            "NotFound",
            "NotStabilized",
            "NotUpdatable",
            "ResourceConflict",
            "ServiceInternalError",
            "ServiceLimitExceeded",
            "Throttling",
        ]
    }
}
impl AsRef<str> for HandlerErrorCode {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum OperationStatus {
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    #[allow(missing_docs)] // documentation missing in model
    InProgress,
    #[allow(missing_docs)] // documentation missing in model
    Pending,
    #[allow(missing_docs)] // documentation missing in model
    Success,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for OperationStatus {
    fn from(s: &str) -> Self {
        match s {
            "FAILED" => OperationStatus::Failed,
            "IN_PROGRESS" => OperationStatus::InProgress,
            "PENDING" => OperationStatus::Pending,
            "SUCCESS" => OperationStatus::Success,
            other => OperationStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for OperationStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(OperationStatus::from(s))
    }
}
impl OperationStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            OperationStatus::Failed => "FAILED",
            OperationStatus::InProgress => "IN_PROGRESS",
            OperationStatus::Pending => "PENDING",
            OperationStatus::Success => "SUCCESS",
            OperationStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["FAILED", "IN_PROGRESS", "PENDING", "SUCCESS"]
    }
}
impl AsRef<str> for OperationStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Contains summary information about a specific version of a CloudFormation extension.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TypeVersionSummary {
    /// <p>The kind of extension.</p>
    pub r#type: std::option::Option<crate::model::RegistryType>,
    /// <p>The name of the extension.</p>
    pub type_name: std::option::Option<std::string::String>,
    /// <p>The ID of a specific version of the extension. The version ID is the value at the end of the Amazon Resource Name (ARN) assigned to the extension version when it is registered.</p>
    pub version_id: std::option::Option<std::string::String>,
    /// <p>Whether the specified extension version is set as the default version.</p>
    /// <p>This applies only to private extensions you have registered in your account, and extensions published by Amazon. For public third-party extensions, whether or not they are activated in your account, CloudFormation returns <code>null</code>.</p>
    pub is_default_version: std::option::Option<bool>,
    /// <p>The Amazon Resource Name (ARN) of the extension version.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>When the version was registered.</p>
    pub time_created: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The description of the extension version.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>For public extensions that have been activated for this account and region, the version of the public extension to be used for CloudFormation operations in this account and region. For any extensions other than activated third-arty extensions, CloudFormation returns <code>null</code>.</p>
    /// <p>How you specified <code>AutoUpdate</code> when enabling the extension affects whether CloudFormation automatically updates the extention in this account and region when a new version is released. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/registry-public.html#registry-public-enable-auto">Setting CloudFormation to automatically use new versions of extensions</a> in the <i>CloudFormation User Guide</i>.</p>
    pub public_version_number: std::option::Option<std::string::String>,
}
impl TypeVersionSummary {
    /// <p>The kind of extension.</p>
    pub fn r#type(&self) -> std::option::Option<&crate::model::RegistryType> {
        self.r#type.as_ref()
    }
    /// <p>The name of the extension.</p>
    pub fn type_name(&self) -> std::option::Option<&str> {
        self.type_name.as_deref()
    }
    /// <p>The ID of a specific version of the extension. The version ID is the value at the end of the Amazon Resource Name (ARN) assigned to the extension version when it is registered.</p>
    pub fn version_id(&self) -> std::option::Option<&str> {
        self.version_id.as_deref()
    }
    /// <p>Whether the specified extension version is set as the default version.</p>
    /// <p>This applies only to private extensions you have registered in your account, and extensions published by Amazon. For public third-party extensions, whether or not they are activated in your account, CloudFormation returns <code>null</code>.</p>
    pub fn is_default_version(&self) -> std::option::Option<bool> {
        self.is_default_version
    }
    /// <p>The Amazon Resource Name (ARN) of the extension version.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>When the version was registered.</p>
    pub fn time_created(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.time_created.as_ref()
    }
    /// <p>The description of the extension version.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>For public extensions that have been activated for this account and region, the version of the public extension to be used for CloudFormation operations in this account and region. For any extensions other than activated third-arty extensions, CloudFormation returns <code>null</code>.</p>
    /// <p>How you specified <code>AutoUpdate</code> when enabling the extension affects whether CloudFormation automatically updates the extention in this account and region when a new version is released. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/registry-public.html#registry-public-enable-auto">Setting CloudFormation to automatically use new versions of extensions</a> in the <i>CloudFormation User Guide</i>.</p>
    pub fn public_version_number(&self) -> std::option::Option<&str> {
        self.public_version_number.as_deref()
    }
}
impl std::fmt::Debug for TypeVersionSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TypeVersionSummary");
        formatter.field("r#type", &self.r#type);
        formatter.field("type_name", &self.type_name);
        formatter.field("version_id", &self.version_id);
        formatter.field("is_default_version", &self.is_default_version);
        formatter.field("arn", &self.arn);
        formatter.field("time_created", &self.time_created);
        formatter.field("description", &self.description);
        formatter.field("public_version_number", &self.public_version_number);
        formatter.finish()
    }
}
/// See [`TypeVersionSummary`](crate::model::TypeVersionSummary)
pub mod type_version_summary {
    /// A builder for [`TypeVersionSummary`](crate::model::TypeVersionSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) r#type: std::option::Option<crate::model::RegistryType>,
        pub(crate) type_name: std::option::Option<std::string::String>,
        pub(crate) version_id: std::option::Option<std::string::String>,
        pub(crate) is_default_version: std::option::Option<bool>,
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) time_created: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) public_version_number: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The kind of extension.</p>
        pub fn r#type(mut self, input: crate::model::RegistryType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The kind of extension.</p>
        pub fn set_type(mut self, input: std::option::Option<crate::model::RegistryType>) -> Self {
            self.r#type = input;
            self
        }
        /// <p>The name of the extension.</p>
        pub fn type_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.type_name = Some(input.into());
            self
        }
        /// <p>The name of the extension.</p>
        pub fn set_type_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.type_name = input;
            self
        }
        /// <p>The ID of a specific version of the extension. The version ID is the value at the end of the Amazon Resource Name (ARN) assigned to the extension version when it is registered.</p>
        pub fn version_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.version_id = Some(input.into());
            self
        }
        /// <p>The ID of a specific version of the extension. The version ID is the value at the end of the Amazon Resource Name (ARN) assigned to the extension version when it is registered.</p>
        pub fn set_version_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.version_id = input;
            self
        }
        /// <p>Whether the specified extension version is set as the default version.</p>
        /// <p>This applies only to private extensions you have registered in your account, and extensions published by Amazon. For public third-party extensions, whether or not they are activated in your account, CloudFormation returns <code>null</code>.</p>
        pub fn is_default_version(mut self, input: bool) -> Self {
            self.is_default_version = Some(input);
            self
        }
        /// <p>Whether the specified extension version is set as the default version.</p>
        /// <p>This applies only to private extensions you have registered in your account, and extensions published by Amazon. For public third-party extensions, whether or not they are activated in your account, CloudFormation returns <code>null</code>.</p>
        pub fn set_is_default_version(mut self, input: std::option::Option<bool>) -> Self {
            self.is_default_version = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the extension version.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the extension version.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>When the version was registered.</p>
        pub fn time_created(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.time_created = Some(input);
            self
        }
        /// <p>When the version was registered.</p>
        pub fn set_time_created(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.time_created = input;
            self
        }
        /// <p>The description of the extension version.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the extension version.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>For public extensions that have been activated for this account and region, the version of the public extension to be used for CloudFormation operations in this account and region. For any extensions other than activated third-arty extensions, CloudFormation returns <code>null</code>.</p>
        /// <p>How you specified <code>AutoUpdate</code> when enabling the extension affects whether CloudFormation automatically updates the extention in this account and region when a new version is released. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/registry-public.html#registry-public-enable-auto">Setting CloudFormation to automatically use new versions of extensions</a> in the <i>CloudFormation User Guide</i>.</p>
        pub fn public_version_number(mut self, input: impl Into<std::string::String>) -> Self {
            self.public_version_number = Some(input.into());
            self
        }
        /// <p>For public extensions that have been activated for this account and region, the version of the public extension to be used for CloudFormation operations in this account and region. For any extensions other than activated third-arty extensions, CloudFormation returns <code>null</code>.</p>
        /// <p>How you specified <code>AutoUpdate</code> when enabling the extension affects whether CloudFormation automatically updates the extention in this account and region when a new version is released. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/registry-public.html#registry-public-enable-auto">Setting CloudFormation to automatically use new versions of extensions</a> in the <i>CloudFormation User Guide</i>.</p>
        pub fn set_public_version_number(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.public_version_number = input;
            self
        }
        /// Consumes the builder and constructs a [`TypeVersionSummary`](crate::model::TypeVersionSummary)
        pub fn build(self) -> crate::model::TypeVersionSummary {
            crate::model::TypeVersionSummary {
                r#type: self.r#type,
                type_name: self.type_name,
                version_id: self.version_id,
                is_default_version: self.is_default_version,
                arn: self.arn,
                time_created: self.time_created,
                description: self.description,
                public_version_number: self.public_version_number,
            }
        }
    }
}
impl TypeVersionSummary {
    /// Creates a new builder-style object to manufacture [`TypeVersionSummary`](crate::model::TypeVersionSummary)
    pub fn builder() -> crate::model::type_version_summary::Builder {
        crate::model::type_version_summary::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum DeprecatedStatus {
    #[allow(missing_docs)] // documentation missing in model
    Deprecated,
    #[allow(missing_docs)] // documentation missing in model
    Live,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for DeprecatedStatus {
    fn from(s: &str) -> Self {
        match s {
            "DEPRECATED" => DeprecatedStatus::Deprecated,
            "LIVE" => DeprecatedStatus::Live,
            other => DeprecatedStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for DeprecatedStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(DeprecatedStatus::from(s))
    }
}
impl DeprecatedStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            DeprecatedStatus::Deprecated => "DEPRECATED",
            DeprecatedStatus::Live => "LIVE",
            DeprecatedStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["DEPRECATED", "LIVE"]
    }
}
impl AsRef<str> for DeprecatedStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Contains summary information about the specified CloudFormation extension.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TypeSummary {
    /// <p>The kind of extension.</p>
    pub r#type: std::option::Option<crate::model::RegistryType>,
    /// <p>The name of the extension.</p>
    /// <p>If you specified a <code>TypeNameAlias</code> when you <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_ActivateType.html">activate this extension</a> in your account and region, CloudFormation considers that alias as the type name.</p>
    pub type_name: std::option::Option<std::string::String>,
    /// <p>The ID of the default version of the extension. The default version is used when the extension version is not specified.</p>
    /// <p>This applies only to private extensions you have registered in your account. For public extensions, both those provided by Amazon and published by third parties, CloudFormation returns <code>null</code>. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_RegisterType.html">RegisterType</a>.</p>
    /// <p>To set the default version of an extension, use <code> <code>SetTypeDefaultVersion</code> </code>. </p>
    pub default_version_id: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the extension.</p>
    pub type_arn: std::option::Option<std::string::String>,
    /// <p>When the specified extension version was registered. This applies only to:</p>
    /// <ul>
    /// <li> <p>Private extensions you have registered in your account. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_RegisterType.html">RegisterType</a>.</p> </li>
    /// <li> <p>Public extensions you have activated in your account with auto-update specified. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_ActivateType.html">ActivateType</a>.</p> </li>
    /// </ul>
    /// <p>For all other extension types, CloudFormation returns <code>null</code>.</p>
    pub last_updated: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The description of the extension.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The ID of the extension publisher, if the extension is published by a third party. Extensions published by Amazon do not return a publisher ID.</p>
    pub publisher_id: std::option::Option<std::string::String>,
    /// <p>For public extensions that have been activated for this account and region, the type name of the public extension.</p>
    /// <p>If you specified a <code>TypeNameAlias</code> when enabling the extension in this account and region, CloudFormation treats that alias as the extension's type name within the account and region, not the type name of the public extension. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/registry-public.html#registry-public-enable-alias">Specifying aliases to refer to extensions</a> in the <i>CloudFormation User Guide</i>.</p>
    pub original_type_name: std::option::Option<std::string::String>,
    /// <p>For public extensions that have been activated for this account and region, the version of the public extension to be used for CloudFormation operations in this account and region.</p>
    /// <p>How you specified <code>AutoUpdate</code> when enabling the extension affects whether CloudFormation automatically updates the extention in this account and region when a new version is released. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/registry-public.html#registry-public-enable-auto">Setting CloudFormation to automatically use new versions of extensions</a> in the <i>CloudFormation User Guide</i>.</p>
    pub public_version_number: std::option::Option<std::string::String>,
    /// <p>For public extensions that have been activated for this account and region, the latest version of the public extension <i>that is available</i>. For any extensions other than activated third-arty extensions, CloudFormation returns <code>null</code>.</p>
    /// <p>How you specified <code>AutoUpdate</code> when enabling the extension affects whether CloudFormation automatically updates the extention in this account and region when a new version is released. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/registry-public.html#registry-public-enable-auto">Setting CloudFormation to automatically use new versions of extensions</a> in the <i>CloudFormation User Guide</i>.</p>
    pub latest_public_version: std::option::Option<std::string::String>,
    /// <p>The service used to verify the publisher identity.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/publish-extension.html">Registering your account to publish CloudFormation extensions</a> in the <i> CFN-CLI User Guide for Extension Development</i>.</p>
    pub publisher_identity: std::option::Option<crate::model::IdentityProvider>,
    /// <p>The publisher name, as defined in the public profile for that publisher in the service used to verify the publisher identity.</p>
    pub publisher_name: std::option::Option<std::string::String>,
    /// <p>Whether or not the extension is activated for this account and region. </p>
    /// <p>This applies only to third-party public extensions. Extensions published by Amazon are activated by default.</p>
    pub is_activated: std::option::Option<bool>,
}
impl TypeSummary {
    /// <p>The kind of extension.</p>
    pub fn r#type(&self) -> std::option::Option<&crate::model::RegistryType> {
        self.r#type.as_ref()
    }
    /// <p>The name of the extension.</p>
    /// <p>If you specified a <code>TypeNameAlias</code> when you <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_ActivateType.html">activate this extension</a> in your account and region, CloudFormation considers that alias as the type name.</p>
    pub fn type_name(&self) -> std::option::Option<&str> {
        self.type_name.as_deref()
    }
    /// <p>The ID of the default version of the extension. The default version is used when the extension version is not specified.</p>
    /// <p>This applies only to private extensions you have registered in your account. For public extensions, both those provided by Amazon and published by third parties, CloudFormation returns <code>null</code>. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_RegisterType.html">RegisterType</a>.</p>
    /// <p>To set the default version of an extension, use <code> <code>SetTypeDefaultVersion</code> </code>. </p>
    pub fn default_version_id(&self) -> std::option::Option<&str> {
        self.default_version_id.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the extension.</p>
    pub fn type_arn(&self) -> std::option::Option<&str> {
        self.type_arn.as_deref()
    }
    /// <p>When the specified extension version was registered. This applies only to:</p>
    /// <ul>
    /// <li> <p>Private extensions you have registered in your account. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_RegisterType.html">RegisterType</a>.</p> </li>
    /// <li> <p>Public extensions you have activated in your account with auto-update specified. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_ActivateType.html">ActivateType</a>.</p> </li>
    /// </ul>
    /// <p>For all other extension types, CloudFormation returns <code>null</code>.</p>
    pub fn last_updated(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_updated.as_ref()
    }
    /// <p>The description of the extension.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The ID of the extension publisher, if the extension is published by a third party. Extensions published by Amazon do not return a publisher ID.</p>
    pub fn publisher_id(&self) -> std::option::Option<&str> {
        self.publisher_id.as_deref()
    }
    /// <p>For public extensions that have been activated for this account and region, the type name of the public extension.</p>
    /// <p>If you specified a <code>TypeNameAlias</code> when enabling the extension in this account and region, CloudFormation treats that alias as the extension's type name within the account and region, not the type name of the public extension. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/registry-public.html#registry-public-enable-alias">Specifying aliases to refer to extensions</a> in the <i>CloudFormation User Guide</i>.</p>
    pub fn original_type_name(&self) -> std::option::Option<&str> {
        self.original_type_name.as_deref()
    }
    /// <p>For public extensions that have been activated for this account and region, the version of the public extension to be used for CloudFormation operations in this account and region.</p>
    /// <p>How you specified <code>AutoUpdate</code> when enabling the extension affects whether CloudFormation automatically updates the extention in this account and region when a new version is released. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/registry-public.html#registry-public-enable-auto">Setting CloudFormation to automatically use new versions of extensions</a> in the <i>CloudFormation User Guide</i>.</p>
    pub fn public_version_number(&self) -> std::option::Option<&str> {
        self.public_version_number.as_deref()
    }
    /// <p>For public extensions that have been activated for this account and region, the latest version of the public extension <i>that is available</i>. For any extensions other than activated third-arty extensions, CloudFormation returns <code>null</code>.</p>
    /// <p>How you specified <code>AutoUpdate</code> when enabling the extension affects whether CloudFormation automatically updates the extention in this account and region when a new version is released. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/registry-public.html#registry-public-enable-auto">Setting CloudFormation to automatically use new versions of extensions</a> in the <i>CloudFormation User Guide</i>.</p>
    pub fn latest_public_version(&self) -> std::option::Option<&str> {
        self.latest_public_version.as_deref()
    }
    /// <p>The service used to verify the publisher identity.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/publish-extension.html">Registering your account to publish CloudFormation extensions</a> in the <i> CFN-CLI User Guide for Extension Development</i>.</p>
    pub fn publisher_identity(&self) -> std::option::Option<&crate::model::IdentityProvider> {
        self.publisher_identity.as_ref()
    }
    /// <p>The publisher name, as defined in the public profile for that publisher in the service used to verify the publisher identity.</p>
    pub fn publisher_name(&self) -> std::option::Option<&str> {
        self.publisher_name.as_deref()
    }
    /// <p>Whether or not the extension is activated for this account and region. </p>
    /// <p>This applies only to third-party public extensions. Extensions published by Amazon are activated by default.</p>
    pub fn is_activated(&self) -> std::option::Option<bool> {
        self.is_activated
    }
}
impl std::fmt::Debug for TypeSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TypeSummary");
        formatter.field("r#type", &self.r#type);
        formatter.field("type_name", &self.type_name);
        formatter.field("default_version_id", &self.default_version_id);
        formatter.field("type_arn", &self.type_arn);
        formatter.field("last_updated", &self.last_updated);
        formatter.field("description", &self.description);
        formatter.field("publisher_id", &self.publisher_id);
        formatter.field("original_type_name", &self.original_type_name);
        formatter.field("public_version_number", &self.public_version_number);
        formatter.field("latest_public_version", &self.latest_public_version);
        formatter.field("publisher_identity", &self.publisher_identity);
        formatter.field("publisher_name", &self.publisher_name);
        formatter.field("is_activated", &self.is_activated);
        formatter.finish()
    }
}
/// See [`TypeSummary`](crate::model::TypeSummary)
pub mod type_summary {
    /// A builder for [`TypeSummary`](crate::model::TypeSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) r#type: std::option::Option<crate::model::RegistryType>,
        pub(crate) type_name: std::option::Option<std::string::String>,
        pub(crate) default_version_id: std::option::Option<std::string::String>,
        pub(crate) type_arn: std::option::Option<std::string::String>,
        pub(crate) last_updated: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) publisher_id: std::option::Option<std::string::String>,
        pub(crate) original_type_name: std::option::Option<std::string::String>,
        pub(crate) public_version_number: std::option::Option<std::string::String>,
        pub(crate) latest_public_version: std::option::Option<std::string::String>,
        pub(crate) publisher_identity: std::option::Option<crate::model::IdentityProvider>,
        pub(crate) publisher_name: std::option::Option<std::string::String>,
        pub(crate) is_activated: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The kind of extension.</p>
        pub fn r#type(mut self, input: crate::model::RegistryType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The kind of extension.</p>
        pub fn set_type(mut self, input: std::option::Option<crate::model::RegistryType>) -> Self {
            self.r#type = input;
            self
        }
        /// <p>The name of the extension.</p>
        /// <p>If you specified a <code>TypeNameAlias</code> when you <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_ActivateType.html">activate this extension</a> in your account and region, CloudFormation considers that alias as the type name.</p>
        pub fn type_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.type_name = Some(input.into());
            self
        }
        /// <p>The name of the extension.</p>
        /// <p>If you specified a <code>TypeNameAlias</code> when you <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_ActivateType.html">activate this extension</a> in your account and region, CloudFormation considers that alias as the type name.</p>
        pub fn set_type_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.type_name = input;
            self
        }
        /// <p>The ID of the default version of the extension. The default version is used when the extension version is not specified.</p>
        /// <p>This applies only to private extensions you have registered in your account. For public extensions, both those provided by Amazon and published by third parties, CloudFormation returns <code>null</code>. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_RegisterType.html">RegisterType</a>.</p>
        /// <p>To set the default version of an extension, use <code> <code>SetTypeDefaultVersion</code> </code>. </p>
        pub fn default_version_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.default_version_id = Some(input.into());
            self
        }
        /// <p>The ID of the default version of the extension. The default version is used when the extension version is not specified.</p>
        /// <p>This applies only to private extensions you have registered in your account. For public extensions, both those provided by Amazon and published by third parties, CloudFormation returns <code>null</code>. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_RegisterType.html">RegisterType</a>.</p>
        /// <p>To set the default version of an extension, use <code> <code>SetTypeDefaultVersion</code> </code>. </p>
        pub fn set_default_version_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.default_version_id = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the extension.</p>
        pub fn type_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.type_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the extension.</p>
        pub fn set_type_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.type_arn = input;
            self
        }
        /// <p>When the specified extension version was registered. This applies only to:</p>
        /// <ul>
        /// <li> <p>Private extensions you have registered in your account. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_RegisterType.html">RegisterType</a>.</p> </li>
        /// <li> <p>Public extensions you have activated in your account with auto-update specified. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_ActivateType.html">ActivateType</a>.</p> </li>
        /// </ul>
        /// <p>For all other extension types, CloudFormation returns <code>null</code>.</p>
        pub fn last_updated(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_updated = Some(input);
            self
        }
        /// <p>When the specified extension version was registered. This applies only to:</p>
        /// <ul>
        /// <li> <p>Private extensions you have registered in your account. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_RegisterType.html">RegisterType</a>.</p> </li>
        /// <li> <p>Public extensions you have activated in your account with auto-update specified. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_ActivateType.html">ActivateType</a>.</p> </li>
        /// </ul>
        /// <p>For all other extension types, CloudFormation returns <code>null</code>.</p>
        pub fn set_last_updated(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_updated = input;
            self
        }
        /// <p>The description of the extension.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the extension.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The ID of the extension publisher, if the extension is published by a third party. Extensions published by Amazon do not return a publisher ID.</p>
        pub fn publisher_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.publisher_id = Some(input.into());
            self
        }
        /// <p>The ID of the extension publisher, if the extension is published by a third party. Extensions published by Amazon do not return a publisher ID.</p>
        pub fn set_publisher_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.publisher_id = input;
            self
        }
        /// <p>For public extensions that have been activated for this account and region, the type name of the public extension.</p>
        /// <p>If you specified a <code>TypeNameAlias</code> when enabling the extension in this account and region, CloudFormation treats that alias as the extension's type name within the account and region, not the type name of the public extension. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/registry-public.html#registry-public-enable-alias">Specifying aliases to refer to extensions</a> in the <i>CloudFormation User Guide</i>.</p>
        pub fn original_type_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.original_type_name = Some(input.into());
            self
        }
        /// <p>For public extensions that have been activated for this account and region, the type name of the public extension.</p>
        /// <p>If you specified a <code>TypeNameAlias</code> when enabling the extension in this account and region, CloudFormation treats that alias as the extension's type name within the account and region, not the type name of the public extension. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/registry-public.html#registry-public-enable-alias">Specifying aliases to refer to extensions</a> in the <i>CloudFormation User Guide</i>.</p>
        pub fn set_original_type_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.original_type_name = input;
            self
        }
        /// <p>For public extensions that have been activated for this account and region, the version of the public extension to be used for CloudFormation operations in this account and region.</p>
        /// <p>How you specified <code>AutoUpdate</code> when enabling the extension affects whether CloudFormation automatically updates the extention in this account and region when a new version is released. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/registry-public.html#registry-public-enable-auto">Setting CloudFormation to automatically use new versions of extensions</a> in the <i>CloudFormation User Guide</i>.</p>
        pub fn public_version_number(mut self, input: impl Into<std::string::String>) -> Self {
            self.public_version_number = Some(input.into());
            self
        }
        /// <p>For public extensions that have been activated for this account and region, the version of the public extension to be used for CloudFormation operations in this account and region.</p>
        /// <p>How you specified <code>AutoUpdate</code> when enabling the extension affects whether CloudFormation automatically updates the extention in this account and region when a new version is released. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/registry-public.html#registry-public-enable-auto">Setting CloudFormation to automatically use new versions of extensions</a> in the <i>CloudFormation User Guide</i>.</p>
        pub fn set_public_version_number(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.public_version_number = input;
            self
        }
        /// <p>For public extensions that have been activated for this account and region, the latest version of the public extension <i>that is available</i>. For any extensions other than activated third-arty extensions, CloudFormation returns <code>null</code>.</p>
        /// <p>How you specified <code>AutoUpdate</code> when enabling the extension affects whether CloudFormation automatically updates the extention in this account and region when a new version is released. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/registry-public.html#registry-public-enable-auto">Setting CloudFormation to automatically use new versions of extensions</a> in the <i>CloudFormation User Guide</i>.</p>
        pub fn latest_public_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.latest_public_version = Some(input.into());
            self
        }
        /// <p>For public extensions that have been activated for this account and region, the latest version of the public extension <i>that is available</i>. For any extensions other than activated third-arty extensions, CloudFormation returns <code>null</code>.</p>
        /// <p>How you specified <code>AutoUpdate</code> when enabling the extension affects whether CloudFormation automatically updates the extention in this account and region when a new version is released. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/registry-public.html#registry-public-enable-auto">Setting CloudFormation to automatically use new versions of extensions</a> in the <i>CloudFormation User Guide</i>.</p>
        pub fn set_latest_public_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.latest_public_version = input;
            self
        }
        /// <p>The service used to verify the publisher identity.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/publish-extension.html">Registering your account to publish CloudFormation extensions</a> in the <i> CFN-CLI User Guide for Extension Development</i>.</p>
        pub fn publisher_identity(mut self, input: crate::model::IdentityProvider) -> Self {
            self.publisher_identity = Some(input);
            self
        }
        /// <p>The service used to verify the publisher identity.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/publish-extension.html">Registering your account to publish CloudFormation extensions</a> in the <i> CFN-CLI User Guide for Extension Development</i>.</p>
        pub fn set_publisher_identity(
            mut self,
            input: std::option::Option<crate::model::IdentityProvider>,
        ) -> Self {
            self.publisher_identity = input;
            self
        }
        /// <p>The publisher name, as defined in the public profile for that publisher in the service used to verify the publisher identity.</p>
        pub fn publisher_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.publisher_name = Some(input.into());
            self
        }
        /// <p>The publisher name, as defined in the public profile for that publisher in the service used to verify the publisher identity.</p>
        pub fn set_publisher_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.publisher_name = input;
            self
        }
        /// <p>Whether or not the extension is activated for this account and region. </p>
        /// <p>This applies only to third-party public extensions. Extensions published by Amazon are activated by default.</p>
        pub fn is_activated(mut self, input: bool) -> Self {
            self.is_activated = Some(input);
            self
        }
        /// <p>Whether or not the extension is activated for this account and region. </p>
        /// <p>This applies only to third-party public extensions. Extensions published by Amazon are activated by default.</p>
        pub fn set_is_activated(mut self, input: std::option::Option<bool>) -> Self {
            self.is_activated = input;
            self
        }
        /// Consumes the builder and constructs a [`TypeSummary`](crate::model::TypeSummary)
        pub fn build(self) -> crate::model::TypeSummary {
            crate::model::TypeSummary {
                r#type: self.r#type,
                type_name: self.type_name,
                default_version_id: self.default_version_id,
                type_arn: self.type_arn,
                last_updated: self.last_updated,
                description: self.description,
                publisher_id: self.publisher_id,
                original_type_name: self.original_type_name,
                public_version_number: self.public_version_number,
                latest_public_version: self.latest_public_version,
                publisher_identity: self.publisher_identity,
                publisher_name: self.publisher_name,
                is_activated: self.is_activated,
            }
        }
    }
}
impl TypeSummary {
    /// Creates a new builder-style object to manufacture [`TypeSummary`](crate::model::TypeSummary)
    pub fn builder() -> crate::model::type_summary::Builder {
        crate::model::type_summary::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum IdentityProvider {
    #[allow(missing_docs)] // documentation missing in model
    AwsMarketplace,
    #[allow(missing_docs)] // documentation missing in model
    Bitbucket,
    #[allow(missing_docs)] // documentation missing in model
    GitHub,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for IdentityProvider {
    fn from(s: &str) -> Self {
        match s {
            "AWS_Marketplace" => IdentityProvider::AwsMarketplace,
            "Bitbucket" => IdentityProvider::Bitbucket,
            "GitHub" => IdentityProvider::GitHub,
            other => IdentityProvider::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for IdentityProvider {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(IdentityProvider::from(s))
    }
}
impl IdentityProvider {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            IdentityProvider::AwsMarketplace => "AWS_Marketplace",
            IdentityProvider::Bitbucket => "Bitbucket",
            IdentityProvider::GitHub => "GitHub",
            IdentityProvider::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["AWS_Marketplace", "Bitbucket", "GitHub"]
    }
}
impl AsRef<str> for IdentityProvider {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Filter criteria to use in determining which extensions to return.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TypeFilters {
    /// <p>The category of extensions to return.</p>
    /// <ul>
    /// <li> <p> <code>REGISTERED</code>: Private extensions that have been registered for this account and region.</p> </li>
    /// <li> <p> <code>ACTIVATED</code>: Public extensions that have been activated for this account and region.</p> </li>
    /// <li> <p> <code>THIRD_PARTY</code>: Extensions available for use from publishers other than Amazon. This includes:</p>
    /// <ul>
    /// <li> <p>Private extensions registered in the account.</p> </li>
    /// <li> <p>Public extensions from publishers other than Amazon, whether activated or not.</p> </li>
    /// </ul> </li>
    /// <li> <p> <code>AWS_TYPES</code>: Extensions available for use from Amazon.</p> </li>
    /// </ul>
    pub category: std::option::Option<crate::model::Category>,
    /// <p>The id of the publisher of the extension. </p>
    /// <p>Extensions published by Amazon are not assigned a publisher ID. Use the <code>AWS_TYPE</code> category to specify a list of types published by Amazon.</p>
    pub publisher_id: std::option::Option<std::string::String>,
    /// <p>A prefix to use as a filter for results.</p>
    pub type_name_prefix: std::option::Option<std::string::String>,
}
impl TypeFilters {
    /// <p>The category of extensions to return.</p>
    /// <ul>
    /// <li> <p> <code>REGISTERED</code>: Private extensions that have been registered for this account and region.</p> </li>
    /// <li> <p> <code>ACTIVATED</code>: Public extensions that have been activated for this account and region.</p> </li>
    /// <li> <p> <code>THIRD_PARTY</code>: Extensions available for use from publishers other than Amazon. This includes:</p>
    /// <ul>
    /// <li> <p>Private extensions registered in the account.</p> </li>
    /// <li> <p>Public extensions from publishers other than Amazon, whether activated or not.</p> </li>
    /// </ul> </li>
    /// <li> <p> <code>AWS_TYPES</code>: Extensions available for use from Amazon.</p> </li>
    /// </ul>
    pub fn category(&self) -> std::option::Option<&crate::model::Category> {
        self.category.as_ref()
    }
    /// <p>The id of the publisher of the extension. </p>
    /// <p>Extensions published by Amazon are not assigned a publisher ID. Use the <code>AWS_TYPE</code> category to specify a list of types published by Amazon.</p>
    pub fn publisher_id(&self) -> std::option::Option<&str> {
        self.publisher_id.as_deref()
    }
    /// <p>A prefix to use as a filter for results.</p>
    pub fn type_name_prefix(&self) -> std::option::Option<&str> {
        self.type_name_prefix.as_deref()
    }
}
impl std::fmt::Debug for TypeFilters {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TypeFilters");
        formatter.field("category", &self.category);
        formatter.field("publisher_id", &self.publisher_id);
        formatter.field("type_name_prefix", &self.type_name_prefix);
        formatter.finish()
    }
}
/// See [`TypeFilters`](crate::model::TypeFilters)
pub mod type_filters {
    /// A builder for [`TypeFilters`](crate::model::TypeFilters)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) category: std::option::Option<crate::model::Category>,
        pub(crate) publisher_id: std::option::Option<std::string::String>,
        pub(crate) type_name_prefix: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The category of extensions to return.</p>
        /// <ul>
        /// <li> <p> <code>REGISTERED</code>: Private extensions that have been registered for this account and region.</p> </li>
        /// <li> <p> <code>ACTIVATED</code>: Public extensions that have been activated for this account and region.</p> </li>
        /// <li> <p> <code>THIRD_PARTY</code>: Extensions available for use from publishers other than Amazon. This includes:</p>
        /// <ul>
        /// <li> <p>Private extensions registered in the account.</p> </li>
        /// <li> <p>Public extensions from publishers other than Amazon, whether activated or not.</p> </li>
        /// </ul> </li>
        /// <li> <p> <code>AWS_TYPES</code>: Extensions available for use from Amazon.</p> </li>
        /// </ul>
        pub fn category(mut self, input: crate::model::Category) -> Self {
            self.category = Some(input);
            self
        }
        /// <p>The category of extensions to return.</p>
        /// <ul>
        /// <li> <p> <code>REGISTERED</code>: Private extensions that have been registered for this account and region.</p> </li>
        /// <li> <p> <code>ACTIVATED</code>: Public extensions that have been activated for this account and region.</p> </li>
        /// <li> <p> <code>THIRD_PARTY</code>: Extensions available for use from publishers other than Amazon. This includes:</p>
        /// <ul>
        /// <li> <p>Private extensions registered in the account.</p> </li>
        /// <li> <p>Public extensions from publishers other than Amazon, whether activated or not.</p> </li>
        /// </ul> </li>
        /// <li> <p> <code>AWS_TYPES</code>: Extensions available for use from Amazon.</p> </li>
        /// </ul>
        pub fn set_category(mut self, input: std::option::Option<crate::model::Category>) -> Self {
            self.category = input;
            self
        }
        /// <p>The id of the publisher of the extension. </p>
        /// <p>Extensions published by Amazon are not assigned a publisher ID. Use the <code>AWS_TYPE</code> category to specify a list of types published by Amazon.</p>
        pub fn publisher_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.publisher_id = Some(input.into());
            self
        }
        /// <p>The id of the publisher of the extension. </p>
        /// <p>Extensions published by Amazon are not assigned a publisher ID. Use the <code>AWS_TYPE</code> category to specify a list of types published by Amazon.</p>
        pub fn set_publisher_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.publisher_id = input;
            self
        }
        /// <p>A prefix to use as a filter for results.</p>
        pub fn type_name_prefix(mut self, input: impl Into<std::string::String>) -> Self {
            self.type_name_prefix = Some(input.into());
            self
        }
        /// <p>A prefix to use as a filter for results.</p>
        pub fn set_type_name_prefix(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.type_name_prefix = input;
            self
        }
        /// Consumes the builder and constructs a [`TypeFilters`](crate::model::TypeFilters)
        pub fn build(self) -> crate::model::TypeFilters {
            crate::model::TypeFilters {
                category: self.category,
                publisher_id: self.publisher_id,
                type_name_prefix: self.type_name_prefix,
            }
        }
    }
}
impl TypeFilters {
    /// Creates a new builder-style object to manufacture [`TypeFilters`](crate::model::TypeFilters)
    pub fn builder() -> crate::model::type_filters::Builder {
        crate::model::type_filters::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum Category {
    #[allow(missing_docs)] // documentation missing in model
    Activated,
    #[allow(missing_docs)] // documentation missing in model
    AwsTypes,
    #[allow(missing_docs)] // documentation missing in model
    Registered,
    #[allow(missing_docs)] // documentation missing in model
    ThirdParty,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for Category {
    fn from(s: &str) -> Self {
        match s {
            "ACTIVATED" => Category::Activated,
            "AWS_TYPES" => Category::AwsTypes,
            "REGISTERED" => Category::Registered,
            "THIRD_PARTY" => Category::ThirdParty,
            other => Category::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for Category {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(Category::from(s))
    }
}
impl Category {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            Category::Activated => "ACTIVATED",
            Category::AwsTypes => "AWS_TYPES",
            Category::Registered => "REGISTERED",
            Category::ThirdParty => "THIRD_PARTY",
            Category::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ACTIVATED", "AWS_TYPES", "REGISTERED", "THIRD_PARTY"]
    }
}
impl AsRef<str> for Category {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ProvisioningType {
    #[allow(missing_docs)] // documentation missing in model
    FullyMutable,
    #[allow(missing_docs)] // documentation missing in model
    Immutable,
    #[allow(missing_docs)] // documentation missing in model
    NonProvisionable,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ProvisioningType {
    fn from(s: &str) -> Self {
        match s {
            "FULLY_MUTABLE" => ProvisioningType::FullyMutable,
            "IMMUTABLE" => ProvisioningType::Immutable,
            "NON_PROVISIONABLE" => ProvisioningType::NonProvisionable,
            other => ProvisioningType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ProvisioningType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ProvisioningType::from(s))
    }
}
impl ProvisioningType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ProvisioningType::FullyMutable => "FULLY_MUTABLE",
            ProvisioningType::Immutable => "IMMUTABLE",
            ProvisioningType::NonProvisionable => "NON_PROVISIONABLE",
            ProvisioningType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["FULLY_MUTABLE", "IMMUTABLE", "NON_PROVISIONABLE"]
    }
}
impl AsRef<str> for ProvisioningType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum Visibility {
    #[allow(missing_docs)] // documentation missing in model
    Private,
    #[allow(missing_docs)] // documentation missing in model
    Public,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for Visibility {
    fn from(s: &str) -> Self {
        match s {
            "PRIVATE" => Visibility::Private,
            "PUBLIC" => Visibility::Public,
            other => Visibility::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for Visibility {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(Visibility::from(s))
    }
}
impl Visibility {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            Visibility::Private => "PRIVATE",
            Visibility::Public => "PUBLIC",
            Visibility::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["PRIVATE", "PUBLIC"]
    }
}
impl AsRef<str> for Visibility {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum RegistrationStatus {
    #[allow(missing_docs)] // documentation missing in model
    Complete,
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    #[allow(missing_docs)] // documentation missing in model
    InProgress,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for RegistrationStatus {
    fn from(s: &str) -> Self {
        match s {
            "COMPLETE" => RegistrationStatus::Complete,
            "FAILED" => RegistrationStatus::Failed,
            "IN_PROGRESS" => RegistrationStatus::InProgress,
            other => RegistrationStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for RegistrationStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(RegistrationStatus::from(s))
    }
}
impl RegistrationStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            RegistrationStatus::Complete => "COMPLETE",
            RegistrationStatus::Failed => "FAILED",
            RegistrationStatus::InProgress => "IN_PROGRESS",
            RegistrationStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["COMPLETE", "FAILED", "IN_PROGRESS"]
    }
}
impl AsRef<str> for RegistrationStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The structures that contain summary information about the specified stack set.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StackSetSummary {
    /// <p>The name of the stack set.</p>
    pub stack_set_name: std::option::Option<std::string::String>,
    /// <p>The ID of the stack set.</p>
    pub stack_set_id: std::option::Option<std::string::String>,
    /// <p>A description of the stack set that you specify when the stack set is created or updated.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The status of the stack set.</p>
    pub status: std::option::Option<crate::model::StackSetStatus>,
    /// <p>[Service-managed permissions] Describes whether StackSets automatically deploys to Organizations accounts that are added to a target organizational unit (OU).</p>
    pub auto_deployment: std::option::Option<crate::model::AutoDeployment>,
    /// <p>Describes how the IAM roles required for stack set operations are created.</p>
    /// <ul>
    /// <li> <p>With <code>self-managed</code> permissions, you must create the administrator and execution roles required to deploy to target accounts. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-prereqs-self-managed.html">Grant Self-Managed Stack Set Permissions</a>.</p> </li>
    /// <li> <p>With <code>service-managed</code> permissions, StackSets automatically creates the IAM roles required to deploy to accounts managed by Organizations. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-prereqs-service-managed.html">Grant Service-Managed Stack Set Permissions</a>.</p> </li>
    /// </ul>
    pub permission_model: std::option::Option<crate::model::PermissionModels>,
    /// <p>Status of the stack set's actual configuration compared to its expected template and parameter configuration. A stack set is considered to have drifted if one or more of its stack instances have drifted from their expected template and parameter configuration.</p>
    /// <ul>
    /// <li> <p> <code>DRIFTED</code>: One or more of the stack instances belonging to the stack set stack differs from the expected template and parameter configuration. A stack instance is considered to have drifted if one or more of the resources in the associated stack have drifted.</p> </li>
    /// <li> <p> <code>NOT_CHECKED</code>: CloudFormation has not checked the stack set for drift.</p> </li>
    /// <li> <p> <code>IN_SYNC</code>: All of the stack instances belonging to the stack set stack match from the expected template and parameter configuration.</p> </li>
    /// <li> <p> <code>UNKNOWN</code>: This value is reserved for future use.</p> </li>
    /// </ul>
    pub drift_status: std::option::Option<crate::model::StackDriftStatus>,
    /// <p>Most recent time when CloudFormation performed a drift detection operation on the stack set. This value will be <code>NULL</code> for any stack set on which drift detection has not yet been performed.</p>
    pub last_drift_check_timestamp: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>Describes whether StackSets performs non-conflicting operations concurrently and queues conflicting operations.</p>
    pub managed_execution: std::option::Option<crate::model::ManagedExecution>,
}
impl StackSetSummary {
    /// <p>The name of the stack set.</p>
    pub fn stack_set_name(&self) -> std::option::Option<&str> {
        self.stack_set_name.as_deref()
    }
    /// <p>The ID of the stack set.</p>
    pub fn stack_set_id(&self) -> std::option::Option<&str> {
        self.stack_set_id.as_deref()
    }
    /// <p>A description of the stack set that you specify when the stack set is created or updated.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The status of the stack set.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::StackSetStatus> {
        self.status.as_ref()
    }
    /// <p>[Service-managed permissions] Describes whether StackSets automatically deploys to Organizations accounts that are added to a target organizational unit (OU).</p>
    pub fn auto_deployment(&self) -> std::option::Option<&crate::model::AutoDeployment> {
        self.auto_deployment.as_ref()
    }
    /// <p>Describes how the IAM roles required for stack set operations are created.</p>
    /// <ul>
    /// <li> <p>With <code>self-managed</code> permissions, you must create the administrator and execution roles required to deploy to target accounts. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-prereqs-self-managed.html">Grant Self-Managed Stack Set Permissions</a>.</p> </li>
    /// <li> <p>With <code>service-managed</code> permissions, StackSets automatically creates the IAM roles required to deploy to accounts managed by Organizations. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-prereqs-service-managed.html">Grant Service-Managed Stack Set Permissions</a>.</p> </li>
    /// </ul>
    pub fn permission_model(&self) -> std::option::Option<&crate::model::PermissionModels> {
        self.permission_model.as_ref()
    }
    /// <p>Status of the stack set's actual configuration compared to its expected template and parameter configuration. A stack set is considered to have drifted if one or more of its stack instances have drifted from their expected template and parameter configuration.</p>
    /// <ul>
    /// <li> <p> <code>DRIFTED</code>: One or more of the stack instances belonging to the stack set stack differs from the expected template and parameter configuration. A stack instance is considered to have drifted if one or more of the resources in the associated stack have drifted.</p> </li>
    /// <li> <p> <code>NOT_CHECKED</code>: CloudFormation has not checked the stack set for drift.</p> </li>
    /// <li> <p> <code>IN_SYNC</code>: All of the stack instances belonging to the stack set stack match from the expected template and parameter configuration.</p> </li>
    /// <li> <p> <code>UNKNOWN</code>: This value is reserved for future use.</p> </li>
    /// </ul>
    pub fn drift_status(&self) -> std::option::Option<&crate::model::StackDriftStatus> {
        self.drift_status.as_ref()
    }
    /// <p>Most recent time when CloudFormation performed a drift detection operation on the stack set. This value will be <code>NULL</code> for any stack set on which drift detection has not yet been performed.</p>
    pub fn last_drift_check_timestamp(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_drift_check_timestamp.as_ref()
    }
    /// <p>Describes whether StackSets performs non-conflicting operations concurrently and queues conflicting operations.</p>
    pub fn managed_execution(&self) -> std::option::Option<&crate::model::ManagedExecution> {
        self.managed_execution.as_ref()
    }
}
impl std::fmt::Debug for StackSetSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StackSetSummary");
        formatter.field("stack_set_name", &self.stack_set_name);
        formatter.field("stack_set_id", &self.stack_set_id);
        formatter.field("description", &self.description);
        formatter.field("status", &self.status);
        formatter.field("auto_deployment", &self.auto_deployment);
        formatter.field("permission_model", &self.permission_model);
        formatter.field("drift_status", &self.drift_status);
        formatter.field(
            "last_drift_check_timestamp",
            &self.last_drift_check_timestamp,
        );
        formatter.field("managed_execution", &self.managed_execution);
        formatter.finish()
    }
}
/// See [`StackSetSummary`](crate::model::StackSetSummary)
pub mod stack_set_summary {
    /// A builder for [`StackSetSummary`](crate::model::StackSetSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) stack_set_name: std::option::Option<std::string::String>,
        pub(crate) stack_set_id: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::StackSetStatus>,
        pub(crate) auto_deployment: std::option::Option<crate::model::AutoDeployment>,
        pub(crate) permission_model: std::option::Option<crate::model::PermissionModels>,
        pub(crate) drift_status: std::option::Option<crate::model::StackDriftStatus>,
        pub(crate) last_drift_check_timestamp: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) managed_execution: std::option::Option<crate::model::ManagedExecution>,
    }
    impl Builder {
        /// <p>The name of the stack set.</p>
        pub fn stack_set_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.stack_set_name = Some(input.into());
            self
        }
        /// <p>The name of the stack set.</p>
        pub fn set_stack_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.stack_set_name = input;
            self
        }
        /// <p>The ID of the stack set.</p>
        pub fn stack_set_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.stack_set_id = Some(input.into());
            self
        }
        /// <p>The ID of the stack set.</p>
        pub fn set_stack_set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.stack_set_id = input;
            self
        }
        /// <p>A description of the stack set that you specify when the stack set is created or updated.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A description of the stack set that you specify when the stack set is created or updated.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The status of the stack set.</p>
        pub fn status(mut self, input: crate::model::StackSetStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of the stack set.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::StackSetStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>[Service-managed permissions] Describes whether StackSets automatically deploys to Organizations accounts that are added to a target organizational unit (OU).</p>
        pub fn auto_deployment(mut self, input: crate::model::AutoDeployment) -> Self {
            self.auto_deployment = Some(input);
            self
        }
        /// <p>[Service-managed permissions] Describes whether StackSets automatically deploys to Organizations accounts that are added to a target organizational unit (OU).</p>
        pub fn set_auto_deployment(
            mut self,
            input: std::option::Option<crate::model::AutoDeployment>,
        ) -> Self {
            self.auto_deployment = input;
            self
        }
        /// <p>Describes how the IAM roles required for stack set operations are created.</p>
        /// <ul>
        /// <li> <p>With <code>self-managed</code> permissions, you must create the administrator and execution roles required to deploy to target accounts. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-prereqs-self-managed.html">Grant Self-Managed Stack Set Permissions</a>.</p> </li>
        /// <li> <p>With <code>service-managed</code> permissions, StackSets automatically creates the IAM roles required to deploy to accounts managed by Organizations. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-prereqs-service-managed.html">Grant Service-Managed Stack Set Permissions</a>.</p> </li>
        /// </ul>
        pub fn permission_model(mut self, input: crate::model::PermissionModels) -> Self {
            self.permission_model = Some(input);
            self
        }
        /// <p>Describes how the IAM roles required for stack set operations are created.</p>
        /// <ul>
        /// <li> <p>With <code>self-managed</code> permissions, you must create the administrator and execution roles required to deploy to target accounts. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-prereqs-self-managed.html">Grant Self-Managed Stack Set Permissions</a>.</p> </li>
        /// <li> <p>With <code>service-managed</code> permissions, StackSets automatically creates the IAM roles required to deploy to accounts managed by Organizations. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-prereqs-service-managed.html">Grant Service-Managed Stack Set Permissions</a>.</p> </li>
        /// </ul>
        pub fn set_permission_model(
            mut self,
            input: std::option::Option<crate::model::PermissionModels>,
        ) -> Self {
            self.permission_model = input;
            self
        }
        /// <p>Status of the stack set's actual configuration compared to its expected template and parameter configuration. A stack set is considered to have drifted if one or more of its stack instances have drifted from their expected template and parameter configuration.</p>
        /// <ul>
        /// <li> <p> <code>DRIFTED</code>: One or more of the stack instances belonging to the stack set stack differs from the expected template and parameter configuration. A stack instance is considered to have drifted if one or more of the resources in the associated stack have drifted.</p> </li>
        /// <li> <p> <code>NOT_CHECKED</code>: CloudFormation has not checked the stack set for drift.</p> </li>
        /// <li> <p> <code>IN_SYNC</code>: All of the stack instances belonging to the stack set stack match from the expected template and parameter configuration.</p> </li>
        /// <li> <p> <code>UNKNOWN</code>: This value is reserved for future use.</p> </li>
        /// </ul>
        pub fn drift_status(mut self, input: crate::model::StackDriftStatus) -> Self {
            self.drift_status = Some(input);
            self
        }
        /// <p>Status of the stack set's actual configuration compared to its expected template and parameter configuration. A stack set is considered to have drifted if one or more of its stack instances have drifted from their expected template and parameter configuration.</p>
        /// <ul>
        /// <li> <p> <code>DRIFTED</code>: One or more of the stack instances belonging to the stack set stack differs from the expected template and parameter configuration. A stack instance is considered to have drifted if one or more of the resources in the associated stack have drifted.</p> </li>
        /// <li> <p> <code>NOT_CHECKED</code>: CloudFormation has not checked the stack set for drift.</p> </li>
        /// <li> <p> <code>IN_SYNC</code>: All of the stack instances belonging to the stack set stack match from the expected template and parameter configuration.</p> </li>
        /// <li> <p> <code>UNKNOWN</code>: This value is reserved for future use.</p> </li>
        /// </ul>
        pub fn set_drift_status(
            mut self,
            input: std::option::Option<crate::model::StackDriftStatus>,
        ) -> Self {
            self.drift_status = input;
            self
        }
        /// <p>Most recent time when CloudFormation performed a drift detection operation on the stack set. This value will be <code>NULL</code> for any stack set on which drift detection has not yet been performed.</p>
        pub fn last_drift_check_timestamp(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_drift_check_timestamp = Some(input);
            self
        }
        /// <p>Most recent time when CloudFormation performed a drift detection operation on the stack set. This value will be <code>NULL</code> for any stack set on which drift detection has not yet been performed.</p>
        pub fn set_last_drift_check_timestamp(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_drift_check_timestamp = input;
            self
        }
        /// <p>Describes whether StackSets performs non-conflicting operations concurrently and queues conflicting operations.</p>
        pub fn managed_execution(mut self, input: crate::model::ManagedExecution) -> Self {
            self.managed_execution = Some(input);
            self
        }
        /// <p>Describes whether StackSets performs non-conflicting operations concurrently and queues conflicting operations.</p>
        pub fn set_managed_execution(
            mut self,
            input: std::option::Option<crate::model::ManagedExecution>,
        ) -> Self {
            self.managed_execution = input;
            self
        }
        /// Consumes the builder and constructs a [`StackSetSummary`](crate::model::StackSetSummary)
        pub fn build(self) -> crate::model::StackSetSummary {
            crate::model::StackSetSummary {
                stack_set_name: self.stack_set_name,
                stack_set_id: self.stack_set_id,
                description: self.description,
                status: self.status,
                auto_deployment: self.auto_deployment,
                permission_model: self.permission_model,
                drift_status: self.drift_status,
                last_drift_check_timestamp: self.last_drift_check_timestamp,
                managed_execution: self.managed_execution,
            }
        }
    }
}
impl StackSetSummary {
    /// Creates a new builder-style object to manufacture [`StackSetSummary`](crate::model::StackSetSummary)
    pub fn builder() -> crate::model::stack_set_summary::Builder {
        crate::model::stack_set_summary::Builder::default()
    }
}

/// _Note: `StackDriftStatus::Unknown` has been renamed to `::UnknownValue`._
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum StackDriftStatus {
    #[allow(missing_docs)] // documentation missing in model
    Drifted,
    #[allow(missing_docs)] // documentation missing in model
    InSync,
    #[allow(missing_docs)] // documentation missing in model
    NotChecked,
    /// _Note: `::Unknown` has been renamed to `::UnknownValue`._
    UnknownValue,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for StackDriftStatus {
    fn from(s: &str) -> Self {
        match s {
            "DRIFTED" => StackDriftStatus::Drifted,
            "IN_SYNC" => StackDriftStatus::InSync,
            "NOT_CHECKED" => StackDriftStatus::NotChecked,
            "UNKNOWN" => StackDriftStatus::UnknownValue,
            other => StackDriftStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for StackDriftStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(StackDriftStatus::from(s))
    }
}
impl StackDriftStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            StackDriftStatus::Drifted => "DRIFTED",
            StackDriftStatus::InSync => "IN_SYNC",
            StackDriftStatus::NotChecked => "NOT_CHECKED",
            StackDriftStatus::UnknownValue => "UNKNOWN",
            StackDriftStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["DRIFTED", "IN_SYNC", "NOT_CHECKED", "UNKNOWN"]
    }
}
impl AsRef<str> for StackDriftStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum StackSetStatus {
    #[allow(missing_docs)] // documentation missing in model
    Active,
    #[allow(missing_docs)] // documentation missing in model
    Deleted,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for StackSetStatus {
    fn from(s: &str) -> Self {
        match s {
            "ACTIVE" => StackSetStatus::Active,
            "DELETED" => StackSetStatus::Deleted,
            other => StackSetStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for StackSetStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(StackSetStatus::from(s))
    }
}
impl StackSetStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            StackSetStatus::Active => "ACTIVE",
            StackSetStatus::Deleted => "DELETED",
            StackSetStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ACTIVE", "DELETED"]
    }
}
impl AsRef<str> for StackSetStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The structures that contain summary information about the specified operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StackSetOperationSummary {
    /// <p>The unique ID of the stack set operation.</p>
    pub operation_id: std::option::Option<std::string::String>,
    /// <p>The type of operation: <code>CREATE</code>, <code>UPDATE</code>, or <code>DELETE</code>. Create and delete operations affect only the specified stack instances that are associated with the specified stack set. Update operations affect both the stack set itself as well as <i>all</i> associated stack set instances.</p>
    pub action: std::option::Option<crate::model::StackSetOperationAction>,
    /// <p>The overall status of the operation.</p>
    /// <ul>
    /// <li> <p> <code>FAILED</code>: The operation exceeded the specified failure tolerance. The failure tolerance value that you've set for an operation is applied for each Region during stack create and update operations. If the number of failed stacks within a Region exceeds the failure tolerance, the status of the operation in the Region is set to <code>FAILED</code>. This in turn sets the status of the operation as a whole to <code>FAILED</code>, and CloudFormation cancels the operation in any remaining Regions.</p> </li>
    /// <li> <p> <code>QUEUED</code>: [Service-managed permissions] For automatic deployments that require a sequence of operations, the operation is queued to be performed. For more information, see the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-concepts.html#stackset-status-codes">stack set operation status codes</a> in the CloudFormation User Guide.</p> </li>
    /// <li> <p> <code>RUNNING</code>: The operation is currently being performed.</p> </li>
    /// <li> <p> <code>STOPPED</code>: The user has cancelled the operation.</p> </li>
    /// <li> <p> <code>STOPPING</code>: The operation is in the process of stopping, at user request. </p> </li>
    /// <li> <p> <code>SUCCEEDED</code>: The operation completed creating or updating all the specified stacks without exceeding the failure tolerance for the operation.</p> </li>
    /// </ul>
    pub status: std::option::Option<crate::model::StackSetOperationStatus>,
    /// <p>The time at which the operation was initiated. Note that the creation times for the stack set operation might differ from the creation time of the individual stacks themselves. This is because CloudFormation needs to perform preparatory work for the operation, such as dispatching the work to the requested Regions, before actually creating the first stacks.</p>
    pub creation_timestamp: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The time at which the stack set operation ended, across all accounts and Regions specified. Note that this doesn't necessarily mean that the stack set operation was successful, or even attempted, in each account or Region.</p>
    pub end_timestamp: std::option::Option<aws_smithy_types::DateTime>,
}
impl StackSetOperationSummary {
    /// <p>The unique ID of the stack set operation.</p>
    pub fn operation_id(&self) -> std::option::Option<&str> {
        self.operation_id.as_deref()
    }
    /// <p>The type of operation: <code>CREATE</code>, <code>UPDATE</code>, or <code>DELETE</code>. Create and delete operations affect only the specified stack instances that are associated with the specified stack set. Update operations affect both the stack set itself as well as <i>all</i> associated stack set instances.</p>
    pub fn action(&self) -> std::option::Option<&crate::model::StackSetOperationAction> {
        self.action.as_ref()
    }
    /// <p>The overall status of the operation.</p>
    /// <ul>
    /// <li> <p> <code>FAILED</code>: The operation exceeded the specified failure tolerance. The failure tolerance value that you've set for an operation is applied for each Region during stack create and update operations. If the number of failed stacks within a Region exceeds the failure tolerance, the status of the operation in the Region is set to <code>FAILED</code>. This in turn sets the status of the operation as a whole to <code>FAILED</code>, and CloudFormation cancels the operation in any remaining Regions.</p> </li>
    /// <li> <p> <code>QUEUED</code>: [Service-managed permissions] For automatic deployments that require a sequence of operations, the operation is queued to be performed. For more information, see the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-concepts.html#stackset-status-codes">stack set operation status codes</a> in the CloudFormation User Guide.</p> </li>
    /// <li> <p> <code>RUNNING</code>: The operation is currently being performed.</p> </li>
    /// <li> <p> <code>STOPPED</code>: The user has cancelled the operation.</p> </li>
    /// <li> <p> <code>STOPPING</code>: The operation is in the process of stopping, at user request. </p> </li>
    /// <li> <p> <code>SUCCEEDED</code>: The operation completed creating or updating all the specified stacks without exceeding the failure tolerance for the operation.</p> </li>
    /// </ul>
    pub fn status(&self) -> std::option::Option<&crate::model::StackSetOperationStatus> {
        self.status.as_ref()
    }
    /// <p>The time at which the operation was initiated. Note that the creation times for the stack set operation might differ from the creation time of the individual stacks themselves. This is because CloudFormation needs to perform preparatory work for the operation, such as dispatching the work to the requested Regions, before actually creating the first stacks.</p>
    pub fn creation_timestamp(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.creation_timestamp.as_ref()
    }
    /// <p>The time at which the stack set operation ended, across all accounts and Regions specified. Note that this doesn't necessarily mean that the stack set operation was successful, or even attempted, in each account or Region.</p>
    pub fn end_timestamp(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.end_timestamp.as_ref()
    }
}
impl std::fmt::Debug for StackSetOperationSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StackSetOperationSummary");
        formatter.field("operation_id", &self.operation_id);
        formatter.field("action", &self.action);
        formatter.field("status", &self.status);
        formatter.field("creation_timestamp", &self.creation_timestamp);
        formatter.field("end_timestamp", &self.end_timestamp);
        formatter.finish()
    }
}
/// See [`StackSetOperationSummary`](crate::model::StackSetOperationSummary)
pub mod stack_set_operation_summary {
    /// A builder for [`StackSetOperationSummary`](crate::model::StackSetOperationSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) operation_id: std::option::Option<std::string::String>,
        pub(crate) action: std::option::Option<crate::model::StackSetOperationAction>,
        pub(crate) status: std::option::Option<crate::model::StackSetOperationStatus>,
        pub(crate) creation_timestamp: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) end_timestamp: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The unique ID of the stack set operation.</p>
        pub fn operation_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.operation_id = Some(input.into());
            self
        }
        /// <p>The unique ID of the stack set operation.</p>
        pub fn set_operation_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.operation_id = input;
            self
        }
        /// <p>The type of operation: <code>CREATE</code>, <code>UPDATE</code>, or <code>DELETE</code>. Create and delete operations affect only the specified stack instances that are associated with the specified stack set. Update operations affect both the stack set itself as well as <i>all</i> associated stack set instances.</p>
        pub fn action(mut self, input: crate::model::StackSetOperationAction) -> Self {
            self.action = Some(input);
            self
        }
        /// <p>The type of operation: <code>CREATE</code>, <code>UPDATE</code>, or <code>DELETE</code>. Create and delete operations affect only the specified stack instances that are associated with the specified stack set. Update operations affect both the stack set itself as well as <i>all</i> associated stack set instances.</p>
        pub fn set_action(
            mut self,
            input: std::option::Option<crate::model::StackSetOperationAction>,
        ) -> Self {
            self.action = input;
            self
        }
        /// <p>The overall status of the operation.</p>
        /// <ul>
        /// <li> <p> <code>FAILED</code>: The operation exceeded the specified failure tolerance. The failure tolerance value that you've set for an operation is applied for each Region during stack create and update operations. If the number of failed stacks within a Region exceeds the failure tolerance, the status of the operation in the Region is set to <code>FAILED</code>. This in turn sets the status of the operation as a whole to <code>FAILED</code>, and CloudFormation cancels the operation in any remaining Regions.</p> </li>
        /// <li> <p> <code>QUEUED</code>: [Service-managed permissions] For automatic deployments that require a sequence of operations, the operation is queued to be performed. For more information, see the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-concepts.html#stackset-status-codes">stack set operation status codes</a> in the CloudFormation User Guide.</p> </li>
        /// <li> <p> <code>RUNNING</code>: The operation is currently being performed.</p> </li>
        /// <li> <p> <code>STOPPED</code>: The user has cancelled the operation.</p> </li>
        /// <li> <p> <code>STOPPING</code>: The operation is in the process of stopping, at user request. </p> </li>
        /// <li> <p> <code>SUCCEEDED</code>: The operation completed creating or updating all the specified stacks without exceeding the failure tolerance for the operation.</p> </li>
        /// </ul>
        pub fn status(mut self, input: crate::model::StackSetOperationStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The overall status of the operation.</p>
        /// <ul>
        /// <li> <p> <code>FAILED</code>: The operation exceeded the specified failure tolerance. The failure tolerance value that you've set for an operation is applied for each Region during stack create and update operations. If the number of failed stacks within a Region exceeds the failure tolerance, the status of the operation in the Region is set to <code>FAILED</code>. This in turn sets the status of the operation as a whole to <code>FAILED</code>, and CloudFormation cancels the operation in any remaining Regions.</p> </li>
        /// <li> <p> <code>QUEUED</code>: [Service-managed permissions] For automatic deployments that require a sequence of operations, the operation is queued to be performed. For more information, see the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-concepts.html#stackset-status-codes">stack set operation status codes</a> in the CloudFormation User Guide.</p> </li>
        /// <li> <p> <code>RUNNING</code>: The operation is currently being performed.</p> </li>
        /// <li> <p> <code>STOPPED</code>: The user has cancelled the operation.</p> </li>
        /// <li> <p> <code>STOPPING</code>: The operation is in the process of stopping, at user request. </p> </li>
        /// <li> <p> <code>SUCCEEDED</code>: The operation completed creating or updating all the specified stacks without exceeding the failure tolerance for the operation.</p> </li>
        /// </ul>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::StackSetOperationStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>The time at which the operation was initiated. Note that the creation times for the stack set operation might differ from the creation time of the individual stacks themselves. This is because CloudFormation needs to perform preparatory work for the operation, such as dispatching the work to the requested Regions, before actually creating the first stacks.</p>
        pub fn creation_timestamp(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.creation_timestamp = Some(input);
            self
        }
        /// <p>The time at which the operation was initiated. Note that the creation times for the stack set operation might differ from the creation time of the individual stacks themselves. This is because CloudFormation needs to perform preparatory work for the operation, such as dispatching the work to the requested Regions, before actually creating the first stacks.</p>
        pub fn set_creation_timestamp(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.creation_timestamp = input;
            self
        }
        /// <p>The time at which the stack set operation ended, across all accounts and Regions specified. Note that this doesn't necessarily mean that the stack set operation was successful, or even attempted, in each account or Region.</p>
        pub fn end_timestamp(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.end_timestamp = Some(input);
            self
        }
        /// <p>The time at which the stack set operation ended, across all accounts and Regions specified. Note that this doesn't necessarily mean that the stack set operation was successful, or even attempted, in each account or Region.</p>
        pub fn set_end_timestamp(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.end_timestamp = input;
            self
        }
        /// Consumes the builder and constructs a [`StackSetOperationSummary`](crate::model::StackSetOperationSummary)
        pub fn build(self) -> crate::model::StackSetOperationSummary {
            crate::model::StackSetOperationSummary {
                operation_id: self.operation_id,
                action: self.action,
                status: self.status,
                creation_timestamp: self.creation_timestamp,
                end_timestamp: self.end_timestamp,
            }
        }
    }
}
impl StackSetOperationSummary {
    /// Creates a new builder-style object to manufacture [`StackSetOperationSummary`](crate::model::StackSetOperationSummary)
    pub fn builder() -> crate::model::stack_set_operation_summary::Builder {
        crate::model::stack_set_operation_summary::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum StackSetOperationStatus {
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    #[allow(missing_docs)] // documentation missing in model
    Queued,
    #[allow(missing_docs)] // documentation missing in model
    Running,
    #[allow(missing_docs)] // documentation missing in model
    Stopped,
    #[allow(missing_docs)] // documentation missing in model
    Stopping,
    #[allow(missing_docs)] // documentation missing in model
    Succeeded,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for StackSetOperationStatus {
    fn from(s: &str) -> Self {
        match s {
            "FAILED" => StackSetOperationStatus::Failed,
            "QUEUED" => StackSetOperationStatus::Queued,
            "RUNNING" => StackSetOperationStatus::Running,
            "STOPPED" => StackSetOperationStatus::Stopped,
            "STOPPING" => StackSetOperationStatus::Stopping,
            "SUCCEEDED" => StackSetOperationStatus::Succeeded,
            other => StackSetOperationStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for StackSetOperationStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(StackSetOperationStatus::from(s))
    }
}
impl StackSetOperationStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            StackSetOperationStatus::Failed => "FAILED",
            StackSetOperationStatus::Queued => "QUEUED",
            StackSetOperationStatus::Running => "RUNNING",
            StackSetOperationStatus::Stopped => "STOPPED",
            StackSetOperationStatus::Stopping => "STOPPING",
            StackSetOperationStatus::Succeeded => "SUCCEEDED",
            StackSetOperationStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "FAILED",
            "QUEUED",
            "RUNNING",
            "STOPPED",
            "STOPPING",
            "SUCCEEDED",
        ]
    }
}
impl AsRef<str> for StackSetOperationStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum StackSetOperationAction {
    #[allow(missing_docs)] // documentation missing in model
    Create,
    #[allow(missing_docs)] // documentation missing in model
    Delete,
    #[allow(missing_docs)] // documentation missing in model
    DetectDrift,
    #[allow(missing_docs)] // documentation missing in model
    Update,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for StackSetOperationAction {
    fn from(s: &str) -> Self {
        match s {
            "CREATE" => StackSetOperationAction::Create,
            "DELETE" => StackSetOperationAction::Delete,
            "DETECT_DRIFT" => StackSetOperationAction::DetectDrift,
            "UPDATE" => StackSetOperationAction::Update,
            other => StackSetOperationAction::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for StackSetOperationAction {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(StackSetOperationAction::from(s))
    }
}
impl StackSetOperationAction {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            StackSetOperationAction::Create => "CREATE",
            StackSetOperationAction::Delete => "DELETE",
            StackSetOperationAction::DetectDrift => "DETECT_DRIFT",
            StackSetOperationAction::Update => "UPDATE",
            StackSetOperationAction::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["CREATE", "DELETE", "DETECT_DRIFT", "UPDATE"]
    }
}
impl AsRef<str> for StackSetOperationAction {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The structure that contains information about a specified operation's results for a given account in a given Region.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StackSetOperationResultSummary {
    /// <p>[Self-managed permissions] The name of the Amazon Web Services account for this operation result.</p>
    pub account: std::option::Option<std::string::String>,
    /// <p>The name of the Amazon Web Services Region for this operation result.</p>
    pub region: std::option::Option<std::string::String>,
    /// <p>The result status of the stack set operation for the given account in the given Region.</p>
    /// <ul>
    /// <li> <p> <code>CANCELLED</code>: The operation in the specified account and Region has been cancelled. This is either because a user has stopped the stack set operation, or because the failure tolerance of the stack set operation has been exceeded.</p> </li>
    /// <li> <p> <code>FAILED</code>: The operation in the specified account and Region failed. </p> <p>If the stack set operation fails in enough accounts within a Region, the failure tolerance for the stack set operation as a whole might be exceeded. </p> </li>
    /// <li> <p> <code>RUNNING</code>: The operation in the specified account and Region is currently in progress.</p> </li>
    /// <li> <p> <code>PENDING</code>: The operation in the specified account and Region has yet to start. </p> </li>
    /// <li> <p> <code>SUCCEEDED</code>: The operation in the specified account and Region completed successfully.</p> </li>
    /// </ul>
    pub status: std::option::Option<crate::model::StackSetOperationResultStatus>,
    /// <p>The reason for the assigned result status.</p>
    pub status_reason: std::option::Option<std::string::String>,
    /// <p>The results of the account gate function CloudFormation invokes, if present, before proceeding with stack set operations in an account</p>
    pub account_gate_result: std::option::Option<crate::model::AccountGateResult>,
    /// <p>[Service-managed permissions] The organization root ID or organizational unit (OU) IDs that you specified for <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_DeploymentTargets.html">DeploymentTargets</a>.</p>
    pub organizational_unit_id: std::option::Option<std::string::String>,
}
impl StackSetOperationResultSummary {
    /// <p>[Self-managed permissions] The name of the Amazon Web Services account for this operation result.</p>
    pub fn account(&self) -> std::option::Option<&str> {
        self.account.as_deref()
    }
    /// <p>The name of the Amazon Web Services Region for this operation result.</p>
    pub fn region(&self) -> std::option::Option<&str> {
        self.region.as_deref()
    }
    /// <p>The result status of the stack set operation for the given account in the given Region.</p>
    /// <ul>
    /// <li> <p> <code>CANCELLED</code>: The operation in the specified account and Region has been cancelled. This is either because a user has stopped the stack set operation, or because the failure tolerance of the stack set operation has been exceeded.</p> </li>
    /// <li> <p> <code>FAILED</code>: The operation in the specified account and Region failed. </p> <p>If the stack set operation fails in enough accounts within a Region, the failure tolerance for the stack set operation as a whole might be exceeded. </p> </li>
    /// <li> <p> <code>RUNNING</code>: The operation in the specified account and Region is currently in progress.</p> </li>
    /// <li> <p> <code>PENDING</code>: The operation in the specified account and Region has yet to start. </p> </li>
    /// <li> <p> <code>SUCCEEDED</code>: The operation in the specified account and Region completed successfully.</p> </li>
    /// </ul>
    pub fn status(&self) -> std::option::Option<&crate::model::StackSetOperationResultStatus> {
        self.status.as_ref()
    }
    /// <p>The reason for the assigned result status.</p>
    pub fn status_reason(&self) -> std::option::Option<&str> {
        self.status_reason.as_deref()
    }
    /// <p>The results of the account gate function CloudFormation invokes, if present, before proceeding with stack set operations in an account</p>
    pub fn account_gate_result(&self) -> std::option::Option<&crate::model::AccountGateResult> {
        self.account_gate_result.as_ref()
    }
    /// <p>[Service-managed permissions] The organization root ID or organizational unit (OU) IDs that you specified for <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_DeploymentTargets.html">DeploymentTargets</a>.</p>
    pub fn organizational_unit_id(&self) -> std::option::Option<&str> {
        self.organizational_unit_id.as_deref()
    }
}
impl std::fmt::Debug for StackSetOperationResultSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StackSetOperationResultSummary");
        formatter.field("account", &self.account);
        formatter.field("region", &self.region);
        formatter.field("status", &self.status);
        formatter.field("status_reason", &self.status_reason);
        formatter.field("account_gate_result", &self.account_gate_result);
        formatter.field("organizational_unit_id", &self.organizational_unit_id);
        formatter.finish()
    }
}
/// See [`StackSetOperationResultSummary`](crate::model::StackSetOperationResultSummary)
pub mod stack_set_operation_result_summary {
    /// A builder for [`StackSetOperationResultSummary`](crate::model::StackSetOperationResultSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) account: std::option::Option<std::string::String>,
        pub(crate) region: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::StackSetOperationResultStatus>,
        pub(crate) status_reason: std::option::Option<std::string::String>,
        pub(crate) account_gate_result: std::option::Option<crate::model::AccountGateResult>,
        pub(crate) organizational_unit_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>[Self-managed permissions] The name of the Amazon Web Services account for this operation result.</p>
        pub fn account(mut self, input: impl Into<std::string::String>) -> Self {
            self.account = Some(input.into());
            self
        }
        /// <p>[Self-managed permissions] The name of the Amazon Web Services account for this operation result.</p>
        pub fn set_account(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.account = input;
            self
        }
        /// <p>The name of the Amazon Web Services Region for this operation result.</p>
        pub fn region(mut self, input: impl Into<std::string::String>) -> Self {
            self.region = Some(input.into());
            self
        }
        /// <p>The name of the Amazon Web Services Region for this operation result.</p>
        pub fn set_region(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.region = input;
            self
        }
        /// <p>The result status of the stack set operation for the given account in the given Region.</p>
        /// <ul>
        /// <li> <p> <code>CANCELLED</code>: The operation in the specified account and Region has been cancelled. This is either because a user has stopped the stack set operation, or because the failure tolerance of the stack set operation has been exceeded.</p> </li>
        /// <li> <p> <code>FAILED</code>: The operation in the specified account and Region failed. </p> <p>If the stack set operation fails in enough accounts within a Region, the failure tolerance for the stack set operation as a whole might be exceeded. </p> </li>
        /// <li> <p> <code>RUNNING</code>: The operation in the specified account and Region is currently in progress.</p> </li>
        /// <li> <p> <code>PENDING</code>: The operation in the specified account and Region has yet to start. </p> </li>
        /// <li> <p> <code>SUCCEEDED</code>: The operation in the specified account and Region completed successfully.</p> </li>
        /// </ul>
        pub fn status(mut self, input: crate::model::StackSetOperationResultStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The result status of the stack set operation for the given account in the given Region.</p>
        /// <ul>
        /// <li> <p> <code>CANCELLED</code>: The operation in the specified account and Region has been cancelled. This is either because a user has stopped the stack set operation, or because the failure tolerance of the stack set operation has been exceeded.</p> </li>
        /// <li> <p> <code>FAILED</code>: The operation in the specified account and Region failed. </p> <p>If the stack set operation fails in enough accounts within a Region, the failure tolerance for the stack set operation as a whole might be exceeded. </p> </li>
        /// <li> <p> <code>RUNNING</code>: The operation in the specified account and Region is currently in progress.</p> </li>
        /// <li> <p> <code>PENDING</code>: The operation in the specified account and Region has yet to start. </p> </li>
        /// <li> <p> <code>SUCCEEDED</code>: The operation in the specified account and Region completed successfully.</p> </li>
        /// </ul>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::StackSetOperationResultStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>The reason for the assigned result status.</p>
        pub fn status_reason(mut self, input: impl Into<std::string::String>) -> Self {
            self.status_reason = Some(input.into());
            self
        }
        /// <p>The reason for the assigned result status.</p>
        pub fn set_status_reason(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.status_reason = input;
            self
        }
        /// <p>The results of the account gate function CloudFormation invokes, if present, before proceeding with stack set operations in an account</p>
        pub fn account_gate_result(mut self, input: crate::model::AccountGateResult) -> Self {
            self.account_gate_result = Some(input);
            self
        }
        /// <p>The results of the account gate function CloudFormation invokes, if present, before proceeding with stack set operations in an account</p>
        pub fn set_account_gate_result(
            mut self,
            input: std::option::Option<crate::model::AccountGateResult>,
        ) -> Self {
            self.account_gate_result = input;
            self
        }
        /// <p>[Service-managed permissions] The organization root ID or organizational unit (OU) IDs that you specified for <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_DeploymentTargets.html">DeploymentTargets</a>.</p>
        pub fn organizational_unit_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.organizational_unit_id = Some(input.into());
            self
        }
        /// <p>[Service-managed permissions] The organization root ID or organizational unit (OU) IDs that you specified for <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_DeploymentTargets.html">DeploymentTargets</a>.</p>
        pub fn set_organizational_unit_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.organizational_unit_id = input;
            self
        }
        /// Consumes the builder and constructs a [`StackSetOperationResultSummary`](crate::model::StackSetOperationResultSummary)
        pub fn build(self) -> crate::model::StackSetOperationResultSummary {
            crate::model::StackSetOperationResultSummary {
                account: self.account,
                region: self.region,
                status: self.status,
                status_reason: self.status_reason,
                account_gate_result: self.account_gate_result,
                organizational_unit_id: self.organizational_unit_id,
            }
        }
    }
}
impl StackSetOperationResultSummary {
    /// Creates a new builder-style object to manufacture [`StackSetOperationResultSummary`](crate::model::StackSetOperationResultSummary)
    pub fn builder() -> crate::model::stack_set_operation_result_summary::Builder {
        crate::model::stack_set_operation_result_summary::Builder::default()
    }
}

/// <p>Structure that contains the results of the account gate function which CloudFormation invokes, if present, before proceeding with a stack set operation in an account and Region.</p>
/// <p>For each account and Region, CloudFormation lets you specify a Lambda function that encapsulates any requirements that must be met before CloudFormation can proceed with a stack set operation in that account and Region. CloudFormation invokes the function each time a stack set operation is requested for that account and Region; if the function returns <code>FAILED</code>, CloudFormation cancels the operation in that account and Region, and sets the stack set operation result status for that account and Region to <code>FAILED</code>.</p>
/// <p>For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-account-gating.html">Configuring a target account gate</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AccountGateResult {
    /// <p>The status of the account gate function.</p>
    /// <ul>
    /// <li> <p> <code>SUCCEEDED</code>: The account gate function has determined that the account and Region passes any requirements for a stack set operation to occur. CloudFormation proceeds with the stack operation in that account and Region. </p> </li>
    /// <li> <p> <code>FAILED</code>: The account gate function has determined that the account and Region does not meet the requirements for a stack set operation to occur. AWS CloudFormation cancels the stack set operation in that account and Region, and sets the stack set operation result status for that account and Region to <code>FAILED</code>. </p> </li>
    /// <li> <p> <code>SKIPPED</code>: CloudFormation has skipped calling the account gate function for this account and Region, for one of the following reasons:</p>
    /// <ul>
    /// <li> <p>An account gate function has not been specified for the account and Region. CloudFormation proceeds with the stack set operation in this account and Region.</p> </li>
    /// <li> <p>The <code>AWSCloudFormationStackSetExecutionRole</code> of the stack set adminstration account lacks permissions to invoke the function. CloudFormation proceeds with the stack set operation in this account and Region.</p> </li>
    /// <li> <p>Either no action is necessary, or no action is possible, on the stack. CloudFormation skips the stack set operation in this account and Region.</p> </li>
    /// </ul> </li>
    /// </ul>
    pub status: std::option::Option<crate::model::AccountGateStatus>,
    /// <p>The reason for the account gate status assigned to this account and Region for the stack set operation.</p>
    pub status_reason: std::option::Option<std::string::String>,
}
impl AccountGateResult {
    /// <p>The status of the account gate function.</p>
    /// <ul>
    /// <li> <p> <code>SUCCEEDED</code>: The account gate function has determined that the account and Region passes any requirements for a stack set operation to occur. CloudFormation proceeds with the stack operation in that account and Region. </p> </li>
    /// <li> <p> <code>FAILED</code>: The account gate function has determined that the account and Region does not meet the requirements for a stack set operation to occur. AWS CloudFormation cancels the stack set operation in that account and Region, and sets the stack set operation result status for that account and Region to <code>FAILED</code>. </p> </li>
    /// <li> <p> <code>SKIPPED</code>: CloudFormation has skipped calling the account gate function for this account and Region, for one of the following reasons:</p>
    /// <ul>
    /// <li> <p>An account gate function has not been specified for the account and Region. CloudFormation proceeds with the stack set operation in this account and Region.</p> </li>
    /// <li> <p>The <code>AWSCloudFormationStackSetExecutionRole</code> of the stack set adminstration account lacks permissions to invoke the function. CloudFormation proceeds with the stack set operation in this account and Region.</p> </li>
    /// <li> <p>Either no action is necessary, or no action is possible, on the stack. CloudFormation skips the stack set operation in this account and Region.</p> </li>
    /// </ul> </li>
    /// </ul>
    pub fn status(&self) -> std::option::Option<&crate::model::AccountGateStatus> {
        self.status.as_ref()
    }
    /// <p>The reason for the account gate status assigned to this account and Region for the stack set operation.</p>
    pub fn status_reason(&self) -> std::option::Option<&str> {
        self.status_reason.as_deref()
    }
}
impl std::fmt::Debug for AccountGateResult {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AccountGateResult");
        formatter.field("status", &self.status);
        formatter.field("status_reason", &self.status_reason);
        formatter.finish()
    }
}
/// See [`AccountGateResult`](crate::model::AccountGateResult)
pub mod account_gate_result {
    /// A builder for [`AccountGateResult`](crate::model::AccountGateResult)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) status: std::option::Option<crate::model::AccountGateStatus>,
        pub(crate) status_reason: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The status of the account gate function.</p>
        /// <ul>
        /// <li> <p> <code>SUCCEEDED</code>: The account gate function has determined that the account and Region passes any requirements for a stack set operation to occur. CloudFormation proceeds with the stack operation in that account and Region. </p> </li>
        /// <li> <p> <code>FAILED</code>: The account gate function has determined that the account and Region does not meet the requirements for a stack set operation to occur. AWS CloudFormation cancels the stack set operation in that account and Region, and sets the stack set operation result status for that account and Region to <code>FAILED</code>. </p> </li>
        /// <li> <p> <code>SKIPPED</code>: CloudFormation has skipped calling the account gate function for this account and Region, for one of the following reasons:</p>
        /// <ul>
        /// <li> <p>An account gate function has not been specified for the account and Region. CloudFormation proceeds with the stack set operation in this account and Region.</p> </li>
        /// <li> <p>The <code>AWSCloudFormationStackSetExecutionRole</code> of the stack set adminstration account lacks permissions to invoke the function. CloudFormation proceeds with the stack set operation in this account and Region.</p> </li>
        /// <li> <p>Either no action is necessary, or no action is possible, on the stack. CloudFormation skips the stack set operation in this account and Region.</p> </li>
        /// </ul> </li>
        /// </ul>
        pub fn status(mut self, input: crate::model::AccountGateStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of the account gate function.</p>
        /// <ul>
        /// <li> <p> <code>SUCCEEDED</code>: The account gate function has determined that the account and Region passes any requirements for a stack set operation to occur. CloudFormation proceeds with the stack operation in that account and Region. </p> </li>
        /// <li> <p> <code>FAILED</code>: The account gate function has determined that the account and Region does not meet the requirements for a stack set operation to occur. AWS CloudFormation cancels the stack set operation in that account and Region, and sets the stack set operation result status for that account and Region to <code>FAILED</code>. </p> </li>
        /// <li> <p> <code>SKIPPED</code>: CloudFormation has skipped calling the account gate function for this account and Region, for one of the following reasons:</p>
        /// <ul>
        /// <li> <p>An account gate function has not been specified for the account and Region. CloudFormation proceeds with the stack set operation in this account and Region.</p> </li>
        /// <li> <p>The <code>AWSCloudFormationStackSetExecutionRole</code> of the stack set adminstration account lacks permissions to invoke the function. CloudFormation proceeds with the stack set operation in this account and Region.</p> </li>
        /// <li> <p>Either no action is necessary, or no action is possible, on the stack. CloudFormation skips the stack set operation in this account and Region.</p> </li>
        /// </ul> </li>
        /// </ul>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::AccountGateStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>The reason for the account gate status assigned to this account and Region for the stack set operation.</p>
        pub fn status_reason(mut self, input: impl Into<std::string::String>) -> Self {
            self.status_reason = Some(input.into());
            self
        }
        /// <p>The reason for the account gate status assigned to this account and Region for the stack set operation.</p>
        pub fn set_status_reason(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.status_reason = input;
            self
        }
        /// Consumes the builder and constructs a [`AccountGateResult`](crate::model::AccountGateResult)
        pub fn build(self) -> crate::model::AccountGateResult {
            crate::model::AccountGateResult {
                status: self.status,
                status_reason: self.status_reason,
            }
        }
    }
}
impl AccountGateResult {
    /// Creates a new builder-style object to manufacture [`AccountGateResult`](crate::model::AccountGateResult)
    pub fn builder() -> crate::model::account_gate_result::Builder {
        crate::model::account_gate_result::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum AccountGateStatus {
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    #[allow(missing_docs)] // documentation missing in model
    Skipped,
    #[allow(missing_docs)] // documentation missing in model
    Succeeded,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for AccountGateStatus {
    fn from(s: &str) -> Self {
        match s {
            "FAILED" => AccountGateStatus::Failed,
            "SKIPPED" => AccountGateStatus::Skipped,
            "SUCCEEDED" => AccountGateStatus::Succeeded,
            other => AccountGateStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for AccountGateStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(AccountGateStatus::from(s))
    }
}
impl AccountGateStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            AccountGateStatus::Failed => "FAILED",
            AccountGateStatus::Skipped => "SKIPPED",
            AccountGateStatus::Succeeded => "SUCCEEDED",
            AccountGateStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["FAILED", "SKIPPED", "SUCCEEDED"]
    }
}
impl AsRef<str> for AccountGateStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum StackSetOperationResultStatus {
    #[allow(missing_docs)] // documentation missing in model
    Cancelled,
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    #[allow(missing_docs)] // documentation missing in model
    Pending,
    #[allow(missing_docs)] // documentation missing in model
    Running,
    #[allow(missing_docs)] // documentation missing in model
    Succeeded,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for StackSetOperationResultStatus {
    fn from(s: &str) -> Self {
        match s {
            "CANCELLED" => StackSetOperationResultStatus::Cancelled,
            "FAILED" => StackSetOperationResultStatus::Failed,
            "PENDING" => StackSetOperationResultStatus::Pending,
            "RUNNING" => StackSetOperationResultStatus::Running,
            "SUCCEEDED" => StackSetOperationResultStatus::Succeeded,
            other => StackSetOperationResultStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for StackSetOperationResultStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(StackSetOperationResultStatus::from(s))
    }
}
impl StackSetOperationResultStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            StackSetOperationResultStatus::Cancelled => "CANCELLED",
            StackSetOperationResultStatus::Failed => "FAILED",
            StackSetOperationResultStatus::Pending => "PENDING",
            StackSetOperationResultStatus::Running => "RUNNING",
            StackSetOperationResultStatus::Succeeded => "SUCCEEDED",
            StackSetOperationResultStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["CANCELLED", "FAILED", "PENDING", "RUNNING", "SUCCEEDED"]
    }
}
impl AsRef<str> for StackSetOperationResultStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The StackSummary Data Type</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StackSummary {
    /// <p>Unique stack identifier.</p>
    pub stack_id: std::option::Option<std::string::String>,
    /// <p>The name associated with the stack.</p>
    pub stack_name: std::option::Option<std::string::String>,
    /// <p>The template description of the template used to create the stack.</p>
    pub template_description: std::option::Option<std::string::String>,
    /// <p>The time the stack was created.</p>
    pub creation_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The time the stack was last updated. This field will only be returned if the stack has been updated at least once.</p>
    pub last_updated_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The time the stack was deleted.</p>
    pub deletion_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The current status of the stack.</p>
    pub stack_status: std::option::Option<crate::model::StackStatus>,
    /// <p>Success/Failure message associated with the stack status.</p>
    pub stack_status_reason: std::option::Option<std::string::String>,
    /// <p>For nested stacks--stacks created as resources for another stack--the stack ID of the direct parent of this stack. For the first level of nested stacks, the root stack is also the parent stack.</p>
    /// <p>For more information, see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-nested-stacks.html">Working with Nested Stacks</a> in the <i>CloudFormation User Guide</i>.</p>
    pub parent_id: std::option::Option<std::string::String>,
    /// <p>For nested stacks--stacks created as resources for another stack--the stack ID of the top-level stack to which the nested stack ultimately belongs.</p>
    /// <p>For more information, see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-nested-stacks.html">Working with Nested Stacks</a> in the <i>CloudFormation User Guide</i>.</p>
    pub root_id: std::option::Option<std::string::String>,
    /// <p>Summarizes information on whether a stack's actual configuration differs, or has <i>drifted</i>, from it's expected configuration, as defined in the stack template and any values specified as template parameters. For more information, see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-stack-drift.html">Detecting Unregulated Configuration Changes to Stacks and Resources</a>.</p>
    pub drift_information: std::option::Option<crate::model::StackDriftInformationSummary>,
}
impl StackSummary {
    /// <p>Unique stack identifier.</p>
    pub fn stack_id(&self) -> std::option::Option<&str> {
        self.stack_id.as_deref()
    }
    /// <p>The name associated with the stack.</p>
    pub fn stack_name(&self) -> std::option::Option<&str> {
        self.stack_name.as_deref()
    }
    /// <p>The template description of the template used to create the stack.</p>
    pub fn template_description(&self) -> std::option::Option<&str> {
        self.template_description.as_deref()
    }
    /// <p>The time the stack was created.</p>
    pub fn creation_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.creation_time.as_ref()
    }
    /// <p>The time the stack was last updated. This field will only be returned if the stack has been updated at least once.</p>
    pub fn last_updated_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_updated_time.as_ref()
    }
    /// <p>The time the stack was deleted.</p>
    pub fn deletion_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.deletion_time.as_ref()
    }
    /// <p>The current status of the stack.</p>
    pub fn stack_status(&self) -> std::option::Option<&crate::model::StackStatus> {
        self.stack_status.as_ref()
    }
    /// <p>Success/Failure message associated with the stack status.</p>
    pub fn stack_status_reason(&self) -> std::option::Option<&str> {
        self.stack_status_reason.as_deref()
    }
    /// <p>For nested stacks--stacks created as resources for another stack--the stack ID of the direct parent of this stack. For the first level of nested stacks, the root stack is also the parent stack.</p>
    /// <p>For more information, see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-nested-stacks.html">Working with Nested Stacks</a> in the <i>CloudFormation User Guide</i>.</p>
    pub fn parent_id(&self) -> std::option::Option<&str> {
        self.parent_id.as_deref()
    }
    /// <p>For nested stacks--stacks created as resources for another stack--the stack ID of the top-level stack to which the nested stack ultimately belongs.</p>
    /// <p>For more information, see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-nested-stacks.html">Working with Nested Stacks</a> in the <i>CloudFormation User Guide</i>.</p>
    pub fn root_id(&self) -> std::option::Option<&str> {
        self.root_id.as_deref()
    }
    /// <p>Summarizes information on whether a stack's actual configuration differs, or has <i>drifted</i>, from it's expected configuration, as defined in the stack template and any values specified as template parameters. For more information, see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-stack-drift.html">Detecting Unregulated Configuration Changes to Stacks and Resources</a>.</p>
    pub fn drift_information(
        &self,
    ) -> std::option::Option<&crate::model::StackDriftInformationSummary> {
        self.drift_information.as_ref()
    }
}
impl std::fmt::Debug for StackSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StackSummary");
        formatter.field("stack_id", &self.stack_id);
        formatter.field("stack_name", &self.stack_name);
        formatter.field("template_description", &self.template_description);
        formatter.field("creation_time", &self.creation_time);
        formatter.field("last_updated_time", &self.last_updated_time);
        formatter.field("deletion_time", &self.deletion_time);
        formatter.field("stack_status", &self.stack_status);
        formatter.field("stack_status_reason", &self.stack_status_reason);
        formatter.field("parent_id", &self.parent_id);
        formatter.field("root_id", &self.root_id);
        formatter.field("drift_information", &self.drift_information);
        formatter.finish()
    }
}
/// See [`StackSummary`](crate::model::StackSummary)
pub mod stack_summary {
    /// A builder for [`StackSummary`](crate::model::StackSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) stack_id: std::option::Option<std::string::String>,
        pub(crate) stack_name: std::option::Option<std::string::String>,
        pub(crate) template_description: std::option::Option<std::string::String>,
        pub(crate) creation_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) last_updated_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) deletion_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) stack_status: std::option::Option<crate::model::StackStatus>,
        pub(crate) stack_status_reason: std::option::Option<std::string::String>,
        pub(crate) parent_id: std::option::Option<std::string::String>,
        pub(crate) root_id: std::option::Option<std::string::String>,
        pub(crate) drift_information:
            std::option::Option<crate::model::StackDriftInformationSummary>,
    }
    impl Builder {
        /// <p>Unique stack identifier.</p>
        pub fn stack_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.stack_id = Some(input.into());
            self
        }
        /// <p>Unique stack identifier.</p>
        pub fn set_stack_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.stack_id = input;
            self
        }
        /// <p>The name associated with the stack.</p>
        pub fn stack_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.stack_name = Some(input.into());
            self
        }
        /// <p>The name associated with the stack.</p>
        pub fn set_stack_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.stack_name = input;
            self
        }
        /// <p>The template description of the template used to create the stack.</p>
        pub fn template_description(mut self, input: impl Into<std::string::String>) -> Self {
            self.template_description = Some(input.into());
            self
        }
        /// <p>The template description of the template used to create the stack.</p>
        pub fn set_template_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.template_description = input;
            self
        }
        /// <p>The time the stack was created.</p>
        pub fn creation_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.creation_time = Some(input);
            self
        }
        /// <p>The time the stack was created.</p>
        pub fn set_creation_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.creation_time = input;
            self
        }
        /// <p>The time the stack was last updated. This field will only be returned if the stack has been updated at least once.</p>
        pub fn last_updated_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_updated_time = Some(input);
            self
        }
        /// <p>The time the stack was last updated. This field will only be returned if the stack has been updated at least once.</p>
        pub fn set_last_updated_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_updated_time = input;
            self
        }
        /// <p>The time the stack was deleted.</p>
        pub fn deletion_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.deletion_time = Some(input);
            self
        }
        /// <p>The time the stack was deleted.</p>
        pub fn set_deletion_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.deletion_time = input;
            self
        }
        /// <p>The current status of the stack.</p>
        pub fn stack_status(mut self, input: crate::model::StackStatus) -> Self {
            self.stack_status = Some(input);
            self
        }
        /// <p>The current status of the stack.</p>
        pub fn set_stack_status(
            mut self,
            input: std::option::Option<crate::model::StackStatus>,
        ) -> Self {
            self.stack_status = input;
            self
        }
        /// <p>Success/Failure message associated with the stack status.</p>
        pub fn stack_status_reason(mut self, input: impl Into<std::string::String>) -> Self {
            self.stack_status_reason = Some(input.into());
            self
        }
        /// <p>Success/Failure message associated with the stack status.</p>
        pub fn set_stack_status_reason(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.stack_status_reason = input;
            self
        }
        /// <p>For nested stacks--stacks created as resources for another stack--the stack ID of the direct parent of this stack. For the first level of nested stacks, the root stack is also the parent stack.</p>
        /// <p>For more information, see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-nested-stacks.html">Working with Nested Stacks</a> in the <i>CloudFormation User Guide</i>.</p>
        pub fn parent_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.parent_id = Some(input.into());
            self
        }
        /// <p>For nested stacks--stacks created as resources for another stack--the stack ID of the direct parent of this stack. For the first level of nested stacks, the root stack is also the parent stack.</p>
        /// <p>For more information, see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-nested-stacks.html">Working with Nested Stacks</a> in the <i>CloudFormation User Guide</i>.</p>
        pub fn set_parent_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.parent_id = input;
            self
        }
        /// <p>For nested stacks--stacks created as resources for another stack--the stack ID of the top-level stack to which the nested stack ultimately belongs.</p>
        /// <p>For more information, see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-nested-stacks.html">Working with Nested Stacks</a> in the <i>CloudFormation User Guide</i>.</p>
        pub fn root_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.root_id = Some(input.into());
            self
        }
        /// <p>For nested stacks--stacks created as resources for another stack--the stack ID of the top-level stack to which the nested stack ultimately belongs.</p>
        /// <p>For more information, see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-nested-stacks.html">Working with Nested Stacks</a> in the <i>CloudFormation User Guide</i>.</p>
        pub fn set_root_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.root_id = input;
            self
        }
        /// <p>Summarizes information on whether a stack's actual configuration differs, or has <i>drifted</i>, from it's expected configuration, as defined in the stack template and any values specified as template parameters. For more information, see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-stack-drift.html">Detecting Unregulated Configuration Changes to Stacks and Resources</a>.</p>
        pub fn drift_information(
            mut self,
            input: crate::model::StackDriftInformationSummary,
        ) -> Self {
            self.drift_information = Some(input);
            self
        }
        /// <p>Summarizes information on whether a stack's actual configuration differs, or has <i>drifted</i>, from it's expected configuration, as defined in the stack template and any values specified as template parameters. For more information, see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-stack-drift.html">Detecting Unregulated Configuration Changes to Stacks and Resources</a>.</p>
        pub fn set_drift_information(
            mut self,
            input: std::option::Option<crate::model::StackDriftInformationSummary>,
        ) -> Self {
            self.drift_information = input;
            self
        }
        /// Consumes the builder and constructs a [`StackSummary`](crate::model::StackSummary)
        pub fn build(self) -> crate::model::StackSummary {
            crate::model::StackSummary {
                stack_id: self.stack_id,
                stack_name: self.stack_name,
                template_description: self.template_description,
                creation_time: self.creation_time,
                last_updated_time: self.last_updated_time,
                deletion_time: self.deletion_time,
                stack_status: self.stack_status,
                stack_status_reason: self.stack_status_reason,
                parent_id: self.parent_id,
                root_id: self.root_id,
                drift_information: self.drift_information,
            }
        }
    }
}
impl StackSummary {
    /// Creates a new builder-style object to manufacture [`StackSummary`](crate::model::StackSummary)
    pub fn builder() -> crate::model::stack_summary::Builder {
        crate::model::stack_summary::Builder::default()
    }
}

/// <p>Contains information about whether the stack's actual configuration differs, or has <i>drifted</i>, from its expected configuration, as defined in the stack template and any values specified as template parameters. A stack is considered to have drifted if one or more of its resources have drifted.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StackDriftInformationSummary {
    /// <p>Status of the stack's actual configuration compared to its expected template configuration. </p>
    /// <ul>
    /// <li> <p> <code>DRIFTED</code>: The stack differs from its expected template configuration. A stack is considered to have drifted if one or more of its resources have drifted.</p> </li>
    /// <li> <p> <code>NOT_CHECKED</code>: CloudFormation has not checked if the stack differs from its expected template configuration.</p> </li>
    /// <li> <p> <code>IN_SYNC</code>: The stack's actual configuration matches its expected template configuration.</p> </li>
    /// <li> <p> <code>UNKNOWN</code>: This value is reserved for future use.</p> </li>
    /// </ul>
    pub stack_drift_status: std::option::Option<crate::model::StackDriftStatus>,
    /// <p>Most recent time when a drift detection operation was initiated on the stack, or any of its individual resources that support drift detection.</p>
    pub last_check_timestamp: std::option::Option<aws_smithy_types::DateTime>,
}
impl StackDriftInformationSummary {
    /// <p>Status of the stack's actual configuration compared to its expected template configuration. </p>
    /// <ul>
    /// <li> <p> <code>DRIFTED</code>: The stack differs from its expected template configuration. A stack is considered to have drifted if one or more of its resources have drifted.</p> </li>
    /// <li> <p> <code>NOT_CHECKED</code>: CloudFormation has not checked if the stack differs from its expected template configuration.</p> </li>
    /// <li> <p> <code>IN_SYNC</code>: The stack's actual configuration matches its expected template configuration.</p> </li>
    /// <li> <p> <code>UNKNOWN</code>: This value is reserved for future use.</p> </li>
    /// </ul>
    pub fn stack_drift_status(&self) -> std::option::Option<&crate::model::StackDriftStatus> {
        self.stack_drift_status.as_ref()
    }
    /// <p>Most recent time when a drift detection operation was initiated on the stack, or any of its individual resources that support drift detection.</p>
    pub fn last_check_timestamp(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_check_timestamp.as_ref()
    }
}
impl std::fmt::Debug for StackDriftInformationSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StackDriftInformationSummary");
        formatter.field("stack_drift_status", &self.stack_drift_status);
        formatter.field("last_check_timestamp", &self.last_check_timestamp);
        formatter.finish()
    }
}
/// See [`StackDriftInformationSummary`](crate::model::StackDriftInformationSummary)
pub mod stack_drift_information_summary {
    /// A builder for [`StackDriftInformationSummary`](crate::model::StackDriftInformationSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) stack_drift_status: std::option::Option<crate::model::StackDriftStatus>,
        pub(crate) last_check_timestamp: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>Status of the stack's actual configuration compared to its expected template configuration. </p>
        /// <ul>
        /// <li> <p> <code>DRIFTED</code>: The stack differs from its expected template configuration. A stack is considered to have drifted if one or more of its resources have drifted.</p> </li>
        /// <li> <p> <code>NOT_CHECKED</code>: CloudFormation has not checked if the stack differs from its expected template configuration.</p> </li>
        /// <li> <p> <code>IN_SYNC</code>: The stack's actual configuration matches its expected template configuration.</p> </li>
        /// <li> <p> <code>UNKNOWN</code>: This value is reserved for future use.</p> </li>
        /// </ul>
        pub fn stack_drift_status(mut self, input: crate::model::StackDriftStatus) -> Self {
            self.stack_drift_status = Some(input);
            self
        }
        /// <p>Status of the stack's actual configuration compared to its expected template configuration. </p>
        /// <ul>
        /// <li> <p> <code>DRIFTED</code>: The stack differs from its expected template configuration. A stack is considered to have drifted if one or more of its resources have drifted.</p> </li>
        /// <li> <p> <code>NOT_CHECKED</code>: CloudFormation has not checked if the stack differs from its expected template configuration.</p> </li>
        /// <li> <p> <code>IN_SYNC</code>: The stack's actual configuration matches its expected template configuration.</p> </li>
        /// <li> <p> <code>UNKNOWN</code>: This value is reserved for future use.</p> </li>
        /// </ul>
        pub fn set_stack_drift_status(
            mut self,
            input: std::option::Option<crate::model::StackDriftStatus>,
        ) -> Self {
            self.stack_drift_status = input;
            self
        }
        /// <p>Most recent time when a drift detection operation was initiated on the stack, or any of its individual resources that support drift detection.</p>
        pub fn last_check_timestamp(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_check_timestamp = Some(input);
            self
        }
        /// <p>Most recent time when a drift detection operation was initiated on the stack, or any of its individual resources that support drift detection.</p>
        pub fn set_last_check_timestamp(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_check_timestamp = input;
            self
        }
        /// Consumes the builder and constructs a [`StackDriftInformationSummary`](crate::model::StackDriftInformationSummary)
        pub fn build(self) -> crate::model::StackDriftInformationSummary {
            crate::model::StackDriftInformationSummary {
                stack_drift_status: self.stack_drift_status,
                last_check_timestamp: self.last_check_timestamp,
            }
        }
    }
}
impl StackDriftInformationSummary {
    /// Creates a new builder-style object to manufacture [`StackDriftInformationSummary`](crate::model::StackDriftInformationSummary)
    pub fn builder() -> crate::model::stack_drift_information_summary::Builder {
        crate::model::stack_drift_information_summary::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum StackStatus {
    #[allow(missing_docs)] // documentation missing in model
    CreateComplete,
    #[allow(missing_docs)] // documentation missing in model
    CreateFailed,
    #[allow(missing_docs)] // documentation missing in model
    CreateInProgress,
    #[allow(missing_docs)] // documentation missing in model
    DeleteComplete,
    #[allow(missing_docs)] // documentation missing in model
    DeleteFailed,
    #[allow(missing_docs)] // documentation missing in model
    DeleteInProgress,
    #[allow(missing_docs)] // documentation missing in model
    ImportComplete,
    #[allow(missing_docs)] // documentation missing in model
    ImportInProgress,
    #[allow(missing_docs)] // documentation missing in model
    ImportRollbackComplete,
    #[allow(missing_docs)] // documentation missing in model
    ImportRollbackFailed,
    #[allow(missing_docs)] // documentation missing in model
    ImportRollbackInProgress,
    #[allow(missing_docs)] // documentation missing in model
    ReviewInProgress,
    #[allow(missing_docs)] // documentation missing in model
    RollbackComplete,
    #[allow(missing_docs)] // documentation missing in model
    RollbackFailed,
    #[allow(missing_docs)] // documentation missing in model
    RollbackInProgress,
    #[allow(missing_docs)] // documentation missing in model
    UpdateComplete,
    #[allow(missing_docs)] // documentation missing in model
    UpdateCompleteCleanupInProgress,
    #[allow(missing_docs)] // documentation missing in model
    UpdateFailed,
    #[allow(missing_docs)] // documentation missing in model
    UpdateInProgress,
    #[allow(missing_docs)] // documentation missing in model
    UpdateRollbackComplete,
    #[allow(missing_docs)] // documentation missing in model
    UpdateRollbackCompleteCleanupInProgress,
    #[allow(missing_docs)] // documentation missing in model
    UpdateRollbackFailed,
    #[allow(missing_docs)] // documentation missing in model
    UpdateRollbackInProgress,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for StackStatus {
    fn from(s: &str) -> Self {
        match s {
            "CREATE_COMPLETE" => StackStatus::CreateComplete,
            "CREATE_FAILED" => StackStatus::CreateFailed,
            "CREATE_IN_PROGRESS" => StackStatus::CreateInProgress,
            "DELETE_COMPLETE" => StackStatus::DeleteComplete,
            "DELETE_FAILED" => StackStatus::DeleteFailed,
            "DELETE_IN_PROGRESS" => StackStatus::DeleteInProgress,
            "IMPORT_COMPLETE" => StackStatus::ImportComplete,
            "IMPORT_IN_PROGRESS" => StackStatus::ImportInProgress,
            "IMPORT_ROLLBACK_COMPLETE" => StackStatus::ImportRollbackComplete,
            "IMPORT_ROLLBACK_FAILED" => StackStatus::ImportRollbackFailed,
            "IMPORT_ROLLBACK_IN_PROGRESS" => StackStatus::ImportRollbackInProgress,
            "REVIEW_IN_PROGRESS" => StackStatus::ReviewInProgress,
            "ROLLBACK_COMPLETE" => StackStatus::RollbackComplete,
            "ROLLBACK_FAILED" => StackStatus::RollbackFailed,
            "ROLLBACK_IN_PROGRESS" => StackStatus::RollbackInProgress,
            "UPDATE_COMPLETE" => StackStatus::UpdateComplete,
            "UPDATE_COMPLETE_CLEANUP_IN_PROGRESS" => StackStatus::UpdateCompleteCleanupInProgress,
            "UPDATE_FAILED" => StackStatus::UpdateFailed,
            "UPDATE_IN_PROGRESS" => StackStatus::UpdateInProgress,
            "UPDATE_ROLLBACK_COMPLETE" => StackStatus::UpdateRollbackComplete,
            "UPDATE_ROLLBACK_COMPLETE_CLEANUP_IN_PROGRESS" => {
                StackStatus::UpdateRollbackCompleteCleanupInProgress
            }
            "UPDATE_ROLLBACK_FAILED" => StackStatus::UpdateRollbackFailed,
            "UPDATE_ROLLBACK_IN_PROGRESS" => StackStatus::UpdateRollbackInProgress,
            other => StackStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for StackStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(StackStatus::from(s))
    }
}
impl StackStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            StackStatus::CreateComplete => "CREATE_COMPLETE",
            StackStatus::CreateFailed => "CREATE_FAILED",
            StackStatus::CreateInProgress => "CREATE_IN_PROGRESS",
            StackStatus::DeleteComplete => "DELETE_COMPLETE",
            StackStatus::DeleteFailed => "DELETE_FAILED",
            StackStatus::DeleteInProgress => "DELETE_IN_PROGRESS",
            StackStatus::ImportComplete => "IMPORT_COMPLETE",
            StackStatus::ImportInProgress => "IMPORT_IN_PROGRESS",
            StackStatus::ImportRollbackComplete => "IMPORT_ROLLBACK_COMPLETE",
            StackStatus::ImportRollbackFailed => "IMPORT_ROLLBACK_FAILED",
            StackStatus::ImportRollbackInProgress => "IMPORT_ROLLBACK_IN_PROGRESS",
            StackStatus::ReviewInProgress => "REVIEW_IN_PROGRESS",
            StackStatus::RollbackComplete => "ROLLBACK_COMPLETE",
            StackStatus::RollbackFailed => "ROLLBACK_FAILED",
            StackStatus::RollbackInProgress => "ROLLBACK_IN_PROGRESS",
            StackStatus::UpdateComplete => "UPDATE_COMPLETE",
            StackStatus::UpdateCompleteCleanupInProgress => "UPDATE_COMPLETE_CLEANUP_IN_PROGRESS",
            StackStatus::UpdateFailed => "UPDATE_FAILED",
            StackStatus::UpdateInProgress => "UPDATE_IN_PROGRESS",
            StackStatus::UpdateRollbackComplete => "UPDATE_ROLLBACK_COMPLETE",
            StackStatus::UpdateRollbackCompleteCleanupInProgress => {
                "UPDATE_ROLLBACK_COMPLETE_CLEANUP_IN_PROGRESS"
            }
            StackStatus::UpdateRollbackFailed => "UPDATE_ROLLBACK_FAILED",
            StackStatus::UpdateRollbackInProgress => "UPDATE_ROLLBACK_IN_PROGRESS",
            StackStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "CREATE_COMPLETE",
            "CREATE_FAILED",
            "CREATE_IN_PROGRESS",
            "DELETE_COMPLETE",
            "DELETE_FAILED",
            "DELETE_IN_PROGRESS",
            "IMPORT_COMPLETE",
            "IMPORT_IN_PROGRESS",
            "IMPORT_ROLLBACK_COMPLETE",
            "IMPORT_ROLLBACK_FAILED",
            "IMPORT_ROLLBACK_IN_PROGRESS",
            "REVIEW_IN_PROGRESS",
            "ROLLBACK_COMPLETE",
            "ROLLBACK_FAILED",
            "ROLLBACK_IN_PROGRESS",
            "UPDATE_COMPLETE",
            "UPDATE_COMPLETE_CLEANUP_IN_PROGRESS",
            "UPDATE_FAILED",
            "UPDATE_IN_PROGRESS",
            "UPDATE_ROLLBACK_COMPLETE",
            "UPDATE_ROLLBACK_COMPLETE_CLEANUP_IN_PROGRESS",
            "UPDATE_ROLLBACK_FAILED",
            "UPDATE_ROLLBACK_IN_PROGRESS",
        ]
    }
}
impl AsRef<str> for StackStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Contains high-level information about the specified stack resource.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StackResourceSummary {
    /// <p>The logical name of the resource specified in the template.</p>
    pub logical_resource_id: std::option::Option<std::string::String>,
    /// <p>The name or unique identifier that corresponds to a physical instance ID of the resource.</p>
    pub physical_resource_id: std::option::Option<std::string::String>,
    /// <p>Type of resource. (For more information, go to <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-template-resource-type-ref.html">Amazon Web Services Resource Types Reference</a> in the CloudFormation User Guide.)</p>
    pub resource_type: std::option::Option<std::string::String>,
    /// <p>Time the status was updated.</p>
    pub last_updated_timestamp: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>Current status of the resource.</p>
    pub resource_status: std::option::Option<crate::model::ResourceStatus>,
    /// <p>Success/failure message associated with the resource.</p>
    pub resource_status_reason: std::option::Option<std::string::String>,
    /// <p>Information about whether the resource's actual configuration differs, or has <i>drifted</i>, from its expected configuration, as defined in the stack template and any values specified as template parameters. For more information, see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-stack-drift.html">Detecting Unregulated Configuration Changes to Stacks and Resources</a>.</p>
    pub drift_information: std::option::Option<crate::model::StackResourceDriftInformationSummary>,
    /// <p>Contains information about the module from which the resource was created, if the resource was created from a module included in the stack template.</p>
    pub module_info: std::option::Option<crate::model::ModuleInfo>,
}
impl StackResourceSummary {
    /// <p>The logical name of the resource specified in the template.</p>
    pub fn logical_resource_id(&self) -> std::option::Option<&str> {
        self.logical_resource_id.as_deref()
    }
    /// <p>The name or unique identifier that corresponds to a physical instance ID of the resource.</p>
    pub fn physical_resource_id(&self) -> std::option::Option<&str> {
        self.physical_resource_id.as_deref()
    }
    /// <p>Type of resource. (For more information, go to <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-template-resource-type-ref.html">Amazon Web Services Resource Types Reference</a> in the CloudFormation User Guide.)</p>
    pub fn resource_type(&self) -> std::option::Option<&str> {
        self.resource_type.as_deref()
    }
    /// <p>Time the status was updated.</p>
    pub fn last_updated_timestamp(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_updated_timestamp.as_ref()
    }
    /// <p>Current status of the resource.</p>
    pub fn resource_status(&self) -> std::option::Option<&crate::model::ResourceStatus> {
        self.resource_status.as_ref()
    }
    /// <p>Success/failure message associated with the resource.</p>
    pub fn resource_status_reason(&self) -> std::option::Option<&str> {
        self.resource_status_reason.as_deref()
    }
    /// <p>Information about whether the resource's actual configuration differs, or has <i>drifted</i>, from its expected configuration, as defined in the stack template and any values specified as template parameters. For more information, see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-stack-drift.html">Detecting Unregulated Configuration Changes to Stacks and Resources</a>.</p>
    pub fn drift_information(
        &self,
    ) -> std::option::Option<&crate::model::StackResourceDriftInformationSummary> {
        self.drift_information.as_ref()
    }
    /// <p>Contains information about the module from which the resource was created, if the resource was created from a module included in the stack template.</p>
    pub fn module_info(&self) -> std::option::Option<&crate::model::ModuleInfo> {
        self.module_info.as_ref()
    }
}
impl std::fmt::Debug for StackResourceSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StackResourceSummary");
        formatter.field("logical_resource_id", &self.logical_resource_id);
        formatter.field("physical_resource_id", &self.physical_resource_id);
        formatter.field("resource_type", &self.resource_type);
        formatter.field("last_updated_timestamp", &self.last_updated_timestamp);
        formatter.field("resource_status", &self.resource_status);
        formatter.field("resource_status_reason", &self.resource_status_reason);
        formatter.field("drift_information", &self.drift_information);
        formatter.field("module_info", &self.module_info);
        formatter.finish()
    }
}
/// See [`StackResourceSummary`](crate::model::StackResourceSummary)
pub mod stack_resource_summary {
    /// A builder for [`StackResourceSummary`](crate::model::StackResourceSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) logical_resource_id: std::option::Option<std::string::String>,
        pub(crate) physical_resource_id: std::option::Option<std::string::String>,
        pub(crate) resource_type: std::option::Option<std::string::String>,
        pub(crate) last_updated_timestamp: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) resource_status: std::option::Option<crate::model::ResourceStatus>,
        pub(crate) resource_status_reason: std::option::Option<std::string::String>,
        pub(crate) drift_information:
            std::option::Option<crate::model::StackResourceDriftInformationSummary>,
        pub(crate) module_info: std::option::Option<crate::model::ModuleInfo>,
    }
    impl Builder {
        /// <p>The logical name of the resource specified in the template.</p>
        pub fn logical_resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.logical_resource_id = Some(input.into());
            self
        }
        /// <p>The logical name of the resource specified in the template.</p>
        pub fn set_logical_resource_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.logical_resource_id = input;
            self
        }
        /// <p>The name or unique identifier that corresponds to a physical instance ID of the resource.</p>
        pub fn physical_resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.physical_resource_id = Some(input.into());
            self
        }
        /// <p>The name or unique identifier that corresponds to a physical instance ID of the resource.</p>
        pub fn set_physical_resource_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.physical_resource_id = input;
            self
        }
        /// <p>Type of resource. (For more information, go to <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-template-resource-type-ref.html">Amazon Web Services Resource Types Reference</a> in the CloudFormation User Guide.)</p>
        pub fn resource_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_type = Some(input.into());
            self
        }
        /// <p>Type of resource. (For more information, go to <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-template-resource-type-ref.html">Amazon Web Services Resource Types Reference</a> in the CloudFormation User Guide.)</p>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_type = input;
            self
        }
        /// <p>Time the status was updated.</p>
        pub fn last_updated_timestamp(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_updated_timestamp = Some(input);
            self
        }
        /// <p>Time the status was updated.</p>
        pub fn set_last_updated_timestamp(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_updated_timestamp = input;
            self
        }
        /// <p>Current status of the resource.</p>
        pub fn resource_status(mut self, input: crate::model::ResourceStatus) -> Self {
            self.resource_status = Some(input);
            self
        }
        /// <p>Current status of the resource.</p>
        pub fn set_resource_status(
            mut self,
            input: std::option::Option<crate::model::ResourceStatus>,
        ) -> Self {
            self.resource_status = input;
            self
        }
        /// <p>Success/failure message associated with the resource.</p>
        pub fn resource_status_reason(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_status_reason = Some(input.into());
            self
        }
        /// <p>Success/failure message associated with the resource.</p>
        pub fn set_resource_status_reason(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_status_reason = input;
            self
        }
        /// <p>Information about whether the resource's actual configuration differs, or has <i>drifted</i>, from its expected configuration, as defined in the stack template and any values specified as template parameters. For more information, see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-stack-drift.html">Detecting Unregulated Configuration Changes to Stacks and Resources</a>.</p>
        pub fn drift_information(
            mut self,
            input: crate::model::StackResourceDriftInformationSummary,
        ) -> Self {
            self.drift_information = Some(input);
            self
        }
        /// <p>Information about whether the resource's actual configuration differs, or has <i>drifted</i>, from its expected configuration, as defined in the stack template and any values specified as template parameters. For more information, see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-stack-drift.html">Detecting Unregulated Configuration Changes to Stacks and Resources</a>.</p>
        pub fn set_drift_information(
            mut self,
            input: std::option::Option<crate::model::StackResourceDriftInformationSummary>,
        ) -> Self {
            self.drift_information = input;
            self
        }
        /// <p>Contains information about the module from which the resource was created, if the resource was created from a module included in the stack template.</p>
        pub fn module_info(mut self, input: crate::model::ModuleInfo) -> Self {
            self.module_info = Some(input);
            self
        }
        /// <p>Contains information about the module from which the resource was created, if the resource was created from a module included in the stack template.</p>
        pub fn set_module_info(
            mut self,
            input: std::option::Option<crate::model::ModuleInfo>,
        ) -> Self {
            self.module_info = input;
            self
        }
        /// Consumes the builder and constructs a [`StackResourceSummary`](crate::model::StackResourceSummary)
        pub fn build(self) -> crate::model::StackResourceSummary {
            crate::model::StackResourceSummary {
                logical_resource_id: self.logical_resource_id,
                physical_resource_id: self.physical_resource_id,
                resource_type: self.resource_type,
                last_updated_timestamp: self.last_updated_timestamp,
                resource_status: self.resource_status,
                resource_status_reason: self.resource_status_reason,
                drift_information: self.drift_information,
                module_info: self.module_info,
            }
        }
    }
}
impl StackResourceSummary {
    /// Creates a new builder-style object to manufacture [`StackResourceSummary`](crate::model::StackResourceSummary)
    pub fn builder() -> crate::model::stack_resource_summary::Builder {
        crate::model::stack_resource_summary::Builder::default()
    }
}

/// <p>Contains information about the module from which the resource was created, if the resource was created from a module included in the stack template.</p>
/// <p>For more information on modules, see <a href="AWSCloudFormation/latest/UserGuide/modules.html">Using modules to encapsulate and reuse resource configurations</a> in the <i>CloudFormation User Guide</i>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ModuleInfo {
    /// <p>A concantenated list of the the module type or types containing the resource. Module types are listed starting with the inner-most nested module, and separated by <code>/</code>.</p>
    /// <p>In the following example, the resource was created from a module of type <code>AWS::First::Example::MODULE</code>, that is nested inside a parent module of type <code>AWS::Second::Example::MODULE</code>.</p>
    /// <p> <code>AWS::First::Example::MODULE/AWS::Second::Example::MODULE</code> </p>
    pub type_hierarchy: std::option::Option<std::string::String>,
    /// <p>A concantenated list of the logical IDs of the module or modules containing the resource. Modules are listed starting with the inner-most nested module, and separated by <code>/</code>.</p>
    /// <p>In the following example, the resource was created from a module, <code>moduleA</code>, that is nested inside a parent module, <code>moduleB</code>.</p>
    /// <p> <code>moduleA/moduleB</code> </p>
    /// <p>For more information, see <a href="AWSCloudFormation/latest/UserGuide/modules.html#module-ref-resources">Referencing resources in a module</a> in the <i>CloudFormation User Guide</i>.</p>
    pub logical_id_hierarchy: std::option::Option<std::string::String>,
}
impl ModuleInfo {
    /// <p>A concantenated list of the the module type or types containing the resource. Module types are listed starting with the inner-most nested module, and separated by <code>/</code>.</p>
    /// <p>In the following example, the resource was created from a module of type <code>AWS::First::Example::MODULE</code>, that is nested inside a parent module of type <code>AWS::Second::Example::MODULE</code>.</p>
    /// <p> <code>AWS::First::Example::MODULE/AWS::Second::Example::MODULE</code> </p>
    pub fn type_hierarchy(&self) -> std::option::Option<&str> {
        self.type_hierarchy.as_deref()
    }
    /// <p>A concantenated list of the logical IDs of the module or modules containing the resource. Modules are listed starting with the inner-most nested module, and separated by <code>/</code>.</p>
    /// <p>In the following example, the resource was created from a module, <code>moduleA</code>, that is nested inside a parent module, <code>moduleB</code>.</p>
    /// <p> <code>moduleA/moduleB</code> </p>
    /// <p>For more information, see <a href="AWSCloudFormation/latest/UserGuide/modules.html#module-ref-resources">Referencing resources in a module</a> in the <i>CloudFormation User Guide</i>.</p>
    pub fn logical_id_hierarchy(&self) -> std::option::Option<&str> {
        self.logical_id_hierarchy.as_deref()
    }
}
impl std::fmt::Debug for ModuleInfo {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ModuleInfo");
        formatter.field("type_hierarchy", &self.type_hierarchy);
        formatter.field("logical_id_hierarchy", &self.logical_id_hierarchy);
        formatter.finish()
    }
}
/// See [`ModuleInfo`](crate::model::ModuleInfo)
pub mod module_info {
    /// A builder for [`ModuleInfo`](crate::model::ModuleInfo)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) type_hierarchy: std::option::Option<std::string::String>,
        pub(crate) logical_id_hierarchy: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A concantenated list of the the module type or types containing the resource. Module types are listed starting with the inner-most nested module, and separated by <code>/</code>.</p>
        /// <p>In the following example, the resource was created from a module of type <code>AWS::First::Example::MODULE</code>, that is nested inside a parent module of type <code>AWS::Second::Example::MODULE</code>.</p>
        /// <p> <code>AWS::First::Example::MODULE/AWS::Second::Example::MODULE</code> </p>
        pub fn type_hierarchy(mut self, input: impl Into<std::string::String>) -> Self {
            self.type_hierarchy = Some(input.into());
            self
        }
        /// <p>A concantenated list of the the module type or types containing the resource. Module types are listed starting with the inner-most nested module, and separated by <code>/</code>.</p>
        /// <p>In the following example, the resource was created from a module of type <code>AWS::First::Example::MODULE</code>, that is nested inside a parent module of type <code>AWS::Second::Example::MODULE</code>.</p>
        /// <p> <code>AWS::First::Example::MODULE/AWS::Second::Example::MODULE</code> </p>
        pub fn set_type_hierarchy(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.type_hierarchy = input;
            self
        }
        /// <p>A concantenated list of the logical IDs of the module or modules containing the resource. Modules are listed starting with the inner-most nested module, and separated by <code>/</code>.</p>
        /// <p>In the following example, the resource was created from a module, <code>moduleA</code>, that is nested inside a parent module, <code>moduleB</code>.</p>
        /// <p> <code>moduleA/moduleB</code> </p>
        /// <p>For more information, see <a href="AWSCloudFormation/latest/UserGuide/modules.html#module-ref-resources">Referencing resources in a module</a> in the <i>CloudFormation User Guide</i>.</p>
        pub fn logical_id_hierarchy(mut self, input: impl Into<std::string::String>) -> Self {
            self.logical_id_hierarchy = Some(input.into());
            self
        }
        /// <p>A concantenated list of the logical IDs of the module or modules containing the resource. Modules are listed starting with the inner-most nested module, and separated by <code>/</code>.</p>
        /// <p>In the following example, the resource was created from a module, <code>moduleA</code>, that is nested inside a parent module, <code>moduleB</code>.</p>
        /// <p> <code>moduleA/moduleB</code> </p>
        /// <p>For more information, see <a href="AWSCloudFormation/latest/UserGuide/modules.html#module-ref-resources">Referencing resources in a module</a> in the <i>CloudFormation User Guide</i>.</p>
        pub fn set_logical_id_hierarchy(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.logical_id_hierarchy = input;
            self
        }
        /// Consumes the builder and constructs a [`ModuleInfo`](crate::model::ModuleInfo)
        pub fn build(self) -> crate::model::ModuleInfo {
            crate::model::ModuleInfo {
                type_hierarchy: self.type_hierarchy,
                logical_id_hierarchy: self.logical_id_hierarchy,
            }
        }
    }
}
impl ModuleInfo {
    /// Creates a new builder-style object to manufacture [`ModuleInfo`](crate::model::ModuleInfo)
    pub fn builder() -> crate::model::module_info::Builder {
        crate::model::module_info::Builder::default()
    }
}

/// <p>Summarizes information about whether the resource's actual configuration differs, or has <i>drifted</i>, from its expected configuration.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StackResourceDriftInformationSummary {
    /// <p>Status of the resource's actual configuration compared to its expected configuration</p>
    /// <ul>
    /// <li> <p> <code>DELETED</code>: The resource differs from its expected configuration in that it has been deleted.</p> </li>
    /// <li> <p> <code>MODIFIED</code>: The resource differs from its expected configuration.</p> </li>
    /// <li> <p> <code>NOT_CHECKED</code>: CloudFormation has not checked if the resource differs from its expected configuration.</p> <p>Any resources that do not currently support drift detection have a status of <code>NOT_CHECKED</code>. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-stack-drift-resource-list.html">Resources that Support Drift Detection</a>. If you performed an <code>ContinueUpdateRollback</code> operation on a stack, any resources included in <code>ResourcesToSkip</code> will also have a status of <code>NOT_CHECKED</code>. For more information on skipping resources during rollback operations, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-updating-stacks-continueupdaterollback.html">Continue Rolling Back an Update</a> in the CloudFormation User Guide.</p> </li>
    /// <li> <p> <code>IN_SYNC</code>: The resources's actual configuration matches its expected configuration.</p> </li>
    /// </ul>
    pub stack_resource_drift_status: std::option::Option<crate::model::StackResourceDriftStatus>,
    /// <p>When CloudFormation last checked if the resource had drifted from its expected configuration.</p>
    pub last_check_timestamp: std::option::Option<aws_smithy_types::DateTime>,
}
impl StackResourceDriftInformationSummary {
    /// <p>Status of the resource's actual configuration compared to its expected configuration</p>
    /// <ul>
    /// <li> <p> <code>DELETED</code>: The resource differs from its expected configuration in that it has been deleted.</p> </li>
    /// <li> <p> <code>MODIFIED</code>: The resource differs from its expected configuration.</p> </li>
    /// <li> <p> <code>NOT_CHECKED</code>: CloudFormation has not checked if the resource differs from its expected configuration.</p> <p>Any resources that do not currently support drift detection have a status of <code>NOT_CHECKED</code>. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-stack-drift-resource-list.html">Resources that Support Drift Detection</a>. If you performed an <code>ContinueUpdateRollback</code> operation on a stack, any resources included in <code>ResourcesToSkip</code> will also have a status of <code>NOT_CHECKED</code>. For more information on skipping resources during rollback operations, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-updating-stacks-continueupdaterollback.html">Continue Rolling Back an Update</a> in the CloudFormation User Guide.</p> </li>
    /// <li> <p> <code>IN_SYNC</code>: The resources's actual configuration matches its expected configuration.</p> </li>
    /// </ul>
    pub fn stack_resource_drift_status(
        &self,
    ) -> std::option::Option<&crate::model::StackResourceDriftStatus> {
        self.stack_resource_drift_status.as_ref()
    }
    /// <p>When CloudFormation last checked if the resource had drifted from its expected configuration.</p>
    pub fn last_check_timestamp(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_check_timestamp.as_ref()
    }
}
impl std::fmt::Debug for StackResourceDriftInformationSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StackResourceDriftInformationSummary");
        formatter.field(
            "stack_resource_drift_status",
            &self.stack_resource_drift_status,
        );
        formatter.field("last_check_timestamp", &self.last_check_timestamp);
        formatter.finish()
    }
}
/// See [`StackResourceDriftInformationSummary`](crate::model::StackResourceDriftInformationSummary)
pub mod stack_resource_drift_information_summary {
    /// A builder for [`StackResourceDriftInformationSummary`](crate::model::StackResourceDriftInformationSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) stack_resource_drift_status:
            std::option::Option<crate::model::StackResourceDriftStatus>,
        pub(crate) last_check_timestamp: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>Status of the resource's actual configuration compared to its expected configuration</p>
        /// <ul>
        /// <li> <p> <code>DELETED</code>: The resource differs from its expected configuration in that it has been deleted.</p> </li>
        /// <li> <p> <code>MODIFIED</code>: The resource differs from its expected configuration.</p> </li>
        /// <li> <p> <code>NOT_CHECKED</code>: CloudFormation has not checked if the resource differs from its expected configuration.</p> <p>Any resources that do not currently support drift detection have a status of <code>NOT_CHECKED</code>. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-stack-drift-resource-list.html">Resources that Support Drift Detection</a>. If you performed an <code>ContinueUpdateRollback</code> operation on a stack, any resources included in <code>ResourcesToSkip</code> will also have a status of <code>NOT_CHECKED</code>. For more information on skipping resources during rollback operations, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-updating-stacks-continueupdaterollback.html">Continue Rolling Back an Update</a> in the CloudFormation User Guide.</p> </li>
        /// <li> <p> <code>IN_SYNC</code>: The resources's actual configuration matches its expected configuration.</p> </li>
        /// </ul>
        pub fn stack_resource_drift_status(
            mut self,
            input: crate::model::StackResourceDriftStatus,
        ) -> Self {
            self.stack_resource_drift_status = Some(input);
            self
        }
        /// <p>Status of the resource's actual configuration compared to its expected configuration</p>
        /// <ul>
        /// <li> <p> <code>DELETED</code>: The resource differs from its expected configuration in that it has been deleted.</p> </li>
        /// <li> <p> <code>MODIFIED</code>: The resource differs from its expected configuration.</p> </li>
        /// <li> <p> <code>NOT_CHECKED</code>: CloudFormation has not checked if the resource differs from its expected configuration.</p> <p>Any resources that do not currently support drift detection have a status of <code>NOT_CHECKED</code>. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-stack-drift-resource-list.html">Resources that Support Drift Detection</a>. If you performed an <code>ContinueUpdateRollback</code> operation on a stack, any resources included in <code>ResourcesToSkip</code> will also have a status of <code>NOT_CHECKED</code>. For more information on skipping resources during rollback operations, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-updating-stacks-continueupdaterollback.html">Continue Rolling Back an Update</a> in the CloudFormation User Guide.</p> </li>
        /// <li> <p> <code>IN_SYNC</code>: The resources's actual configuration matches its expected configuration.</p> </li>
        /// </ul>
        pub fn set_stack_resource_drift_status(
            mut self,
            input: std::option::Option<crate::model::StackResourceDriftStatus>,
        ) -> Self {
            self.stack_resource_drift_status = input;
            self
        }
        /// <p>When CloudFormation last checked if the resource had drifted from its expected configuration.</p>
        pub fn last_check_timestamp(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_check_timestamp = Some(input);
            self
        }
        /// <p>When CloudFormation last checked if the resource had drifted from its expected configuration.</p>
        pub fn set_last_check_timestamp(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_check_timestamp = input;
            self
        }
        /// Consumes the builder and constructs a [`StackResourceDriftInformationSummary`](crate::model::StackResourceDriftInformationSummary)
        pub fn build(self) -> crate::model::StackResourceDriftInformationSummary {
            crate::model::StackResourceDriftInformationSummary {
                stack_resource_drift_status: self.stack_resource_drift_status,
                last_check_timestamp: self.last_check_timestamp,
            }
        }
    }
}
impl StackResourceDriftInformationSummary {
    /// Creates a new builder-style object to manufacture [`StackResourceDriftInformationSummary`](crate::model::StackResourceDriftInformationSummary)
    pub fn builder() -> crate::model::stack_resource_drift_information_summary::Builder {
        crate::model::stack_resource_drift_information_summary::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum StackResourceDriftStatus {
    #[allow(missing_docs)] // documentation missing in model
    Deleted,
    #[allow(missing_docs)] // documentation missing in model
    InSync,
    #[allow(missing_docs)] // documentation missing in model
    Modified,
    #[allow(missing_docs)] // documentation missing in model
    NotChecked,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for StackResourceDriftStatus {
    fn from(s: &str) -> Self {
        match s {
            "DELETED" => StackResourceDriftStatus::Deleted,
            "IN_SYNC" => StackResourceDriftStatus::InSync,
            "MODIFIED" => StackResourceDriftStatus::Modified,
            "NOT_CHECKED" => StackResourceDriftStatus::NotChecked,
            other => StackResourceDriftStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for StackResourceDriftStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(StackResourceDriftStatus::from(s))
    }
}
impl StackResourceDriftStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            StackResourceDriftStatus::Deleted => "DELETED",
            StackResourceDriftStatus::InSync => "IN_SYNC",
            StackResourceDriftStatus::Modified => "MODIFIED",
            StackResourceDriftStatus::NotChecked => "NOT_CHECKED",
            StackResourceDriftStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["DELETED", "IN_SYNC", "MODIFIED", "NOT_CHECKED"]
    }
}
impl AsRef<str> for StackResourceDriftStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ResourceStatus {
    #[allow(missing_docs)] // documentation missing in model
    CreateComplete,
    #[allow(missing_docs)] // documentation missing in model
    CreateFailed,
    #[allow(missing_docs)] // documentation missing in model
    CreateInProgress,
    #[allow(missing_docs)] // documentation missing in model
    DeleteComplete,
    #[allow(missing_docs)] // documentation missing in model
    DeleteFailed,
    #[allow(missing_docs)] // documentation missing in model
    DeleteInProgress,
    #[allow(missing_docs)] // documentation missing in model
    DeleteSkipped,
    #[allow(missing_docs)] // documentation missing in model
    ImportComplete,
    #[allow(missing_docs)] // documentation missing in model
    ImportFailed,
    #[allow(missing_docs)] // documentation missing in model
    ImportInProgress,
    #[allow(missing_docs)] // documentation missing in model
    ImportRollbackComplete,
    #[allow(missing_docs)] // documentation missing in model
    ImportRollbackFailed,
    #[allow(missing_docs)] // documentation missing in model
    ImportRollbackInProgress,
    #[allow(missing_docs)] // documentation missing in model
    RollbackComplete,
    #[allow(missing_docs)] // documentation missing in model
    RollbackFailed,
    #[allow(missing_docs)] // documentation missing in model
    RollbackInProgress,
    #[allow(missing_docs)] // documentation missing in model
    UpdateComplete,
    #[allow(missing_docs)] // documentation missing in model
    UpdateFailed,
    #[allow(missing_docs)] // documentation missing in model
    UpdateInProgress,
    #[allow(missing_docs)] // documentation missing in model
    UpdateRollbackComplete,
    #[allow(missing_docs)] // documentation missing in model
    UpdateRollbackFailed,
    #[allow(missing_docs)] // documentation missing in model
    UpdateRollbackInProgress,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ResourceStatus {
    fn from(s: &str) -> Self {
        match s {
            "CREATE_COMPLETE" => ResourceStatus::CreateComplete,
            "CREATE_FAILED" => ResourceStatus::CreateFailed,
            "CREATE_IN_PROGRESS" => ResourceStatus::CreateInProgress,
            "DELETE_COMPLETE" => ResourceStatus::DeleteComplete,
            "DELETE_FAILED" => ResourceStatus::DeleteFailed,
            "DELETE_IN_PROGRESS" => ResourceStatus::DeleteInProgress,
            "DELETE_SKIPPED" => ResourceStatus::DeleteSkipped,
            "IMPORT_COMPLETE" => ResourceStatus::ImportComplete,
            "IMPORT_FAILED" => ResourceStatus::ImportFailed,
            "IMPORT_IN_PROGRESS" => ResourceStatus::ImportInProgress,
            "IMPORT_ROLLBACK_COMPLETE" => ResourceStatus::ImportRollbackComplete,
            "IMPORT_ROLLBACK_FAILED" => ResourceStatus::ImportRollbackFailed,
            "IMPORT_ROLLBACK_IN_PROGRESS" => ResourceStatus::ImportRollbackInProgress,
            "ROLLBACK_COMPLETE" => ResourceStatus::RollbackComplete,
            "ROLLBACK_FAILED" => ResourceStatus::RollbackFailed,
            "ROLLBACK_IN_PROGRESS" => ResourceStatus::RollbackInProgress,
            "UPDATE_COMPLETE" => ResourceStatus::UpdateComplete,
            "UPDATE_FAILED" => ResourceStatus::UpdateFailed,
            "UPDATE_IN_PROGRESS" => ResourceStatus::UpdateInProgress,
            "UPDATE_ROLLBACK_COMPLETE" => ResourceStatus::UpdateRollbackComplete,
            "UPDATE_ROLLBACK_FAILED" => ResourceStatus::UpdateRollbackFailed,
            "UPDATE_ROLLBACK_IN_PROGRESS" => ResourceStatus::UpdateRollbackInProgress,
            other => ResourceStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ResourceStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ResourceStatus::from(s))
    }
}
impl ResourceStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ResourceStatus::CreateComplete => "CREATE_COMPLETE",
            ResourceStatus::CreateFailed => "CREATE_FAILED",
            ResourceStatus::CreateInProgress => "CREATE_IN_PROGRESS",
            ResourceStatus::DeleteComplete => "DELETE_COMPLETE",
            ResourceStatus::DeleteFailed => "DELETE_FAILED",
            ResourceStatus::DeleteInProgress => "DELETE_IN_PROGRESS",
            ResourceStatus::DeleteSkipped => "DELETE_SKIPPED",
            ResourceStatus::ImportComplete => "IMPORT_COMPLETE",
            ResourceStatus::ImportFailed => "IMPORT_FAILED",
            ResourceStatus::ImportInProgress => "IMPORT_IN_PROGRESS",
            ResourceStatus::ImportRollbackComplete => "IMPORT_ROLLBACK_COMPLETE",
            ResourceStatus::ImportRollbackFailed => "IMPORT_ROLLBACK_FAILED",
            ResourceStatus::ImportRollbackInProgress => "IMPORT_ROLLBACK_IN_PROGRESS",
            ResourceStatus::RollbackComplete => "ROLLBACK_COMPLETE",
            ResourceStatus::RollbackFailed => "ROLLBACK_FAILED",
            ResourceStatus::RollbackInProgress => "ROLLBACK_IN_PROGRESS",
            ResourceStatus::UpdateComplete => "UPDATE_COMPLETE",
            ResourceStatus::UpdateFailed => "UPDATE_FAILED",
            ResourceStatus::UpdateInProgress => "UPDATE_IN_PROGRESS",
            ResourceStatus::UpdateRollbackComplete => "UPDATE_ROLLBACK_COMPLETE",
            ResourceStatus::UpdateRollbackFailed => "UPDATE_ROLLBACK_FAILED",
            ResourceStatus::UpdateRollbackInProgress => "UPDATE_ROLLBACK_IN_PROGRESS",
            ResourceStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "CREATE_COMPLETE",
            "CREATE_FAILED",
            "CREATE_IN_PROGRESS",
            "DELETE_COMPLETE",
            "DELETE_FAILED",
            "DELETE_IN_PROGRESS",
            "DELETE_SKIPPED",
            "IMPORT_COMPLETE",
            "IMPORT_FAILED",
            "IMPORT_IN_PROGRESS",
            "IMPORT_ROLLBACK_COMPLETE",
            "IMPORT_ROLLBACK_FAILED",
            "IMPORT_ROLLBACK_IN_PROGRESS",
            "ROLLBACK_COMPLETE",
            "ROLLBACK_FAILED",
            "ROLLBACK_IN_PROGRESS",
            "UPDATE_COMPLETE",
            "UPDATE_FAILED",
            "UPDATE_IN_PROGRESS",
            "UPDATE_ROLLBACK_COMPLETE",
            "UPDATE_ROLLBACK_FAILED",
            "UPDATE_ROLLBACK_IN_PROGRESS",
        ]
    }
}
impl AsRef<str> for ResourceStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The structure that contains summary information about a stack instance.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StackInstanceSummary {
    /// <p>The name or unique ID of the stack set that the stack instance is associated with.</p>
    pub stack_set_id: std::option::Option<std::string::String>,
    /// <p>The name of the Amazon Web Services Region that the stack instance is associated with.</p>
    pub region: std::option::Option<std::string::String>,
    /// <p>[Self-managed permissions] The name of the Amazon Web Services account that the stack instance is associated with.</p>
    pub account: std::option::Option<std::string::String>,
    /// <p>The ID of the stack instance.</p>
    pub stack_id: std::option::Option<std::string::String>,
    /// <p>The status of the stack instance, in terms of its synchronization with its associated stack set.</p>
    /// <ul>
    /// <li> <p> <code>INOPERABLE</code>: A <code>DeleteStackInstances</code> operation has failed and left the stack in an unstable state. Stacks in this state are excluded from further <code>UpdateStackSet</code> operations. You might need to perform a <code>DeleteStackInstances</code> operation, with <code>RetainStacks</code> set to <code>true</code>, to delete the stack instance, and then delete the stack manually.</p> </li>
    /// <li> <p> <code>OUTDATED</code>: The stack isn't currently up to date with the stack set because:</p>
    /// <ul>
    /// <li> <p>The associated stack failed during a <code>CreateStackSet</code> or <code>UpdateStackSet</code> operation. </p> </li>
    /// <li> <p>The stack was part of a <code>CreateStackSet</code> or <code>UpdateStackSet</code> operation that failed or was stopped before the stack was created or updated. </p> </li>
    /// </ul> </li>
    /// <li> <p> <code>CURRENT</code>: The stack is currently up to date with the stack set.</p> </li>
    /// </ul>
    pub status: std::option::Option<crate::model::StackInstanceStatus>,
    /// <p>The explanation for the specific status code assigned to this stack instance.</p>
    pub status_reason: std::option::Option<std::string::String>,
    /// <p>The detailed status of the stack instance.</p>
    pub stack_instance_status: std::option::Option<crate::model::StackInstanceComprehensiveStatus>,
    /// <p>[Service-managed permissions] The organization root ID or organizational unit (OU) IDs that you specified for <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_DeploymentTargets.html">DeploymentTargets</a>.</p>
    pub organizational_unit_id: std::option::Option<std::string::String>,
    /// <p>Status of the stack instance's actual configuration compared to the expected template and parameter configuration of the stack set to which it belongs. </p>
    /// <ul>
    /// <li> <p> <code>DRIFTED</code>: The stack differs from the expected template and parameter configuration of the stack set to which it belongs. A stack instance is considered to have drifted if one or more of the resources in the associated stack have drifted.</p> </li>
    /// <li> <p> <code>NOT_CHECKED</code>: CloudFormation has not checked if the stack instance differs from its expected stack set configuration.</p> </li>
    /// <li> <p> <code>IN_SYNC</code>: The stack instance's actual configuration matches its expected stack set configuration.</p> </li>
    /// <li> <p> <code>UNKNOWN</code>: This value is reserved for future use.</p> </li>
    /// </ul>
    pub drift_status: std::option::Option<crate::model::StackDriftStatus>,
    /// <p>Most recent time when CloudFormation performed a drift detection operation on the stack instance. This value will be <code>NULL</code> for any stack instance on which drift detection has not yet been performed.</p>
    pub last_drift_check_timestamp: std::option::Option<aws_smithy_types::DateTime>,
}
impl StackInstanceSummary {
    /// <p>The name or unique ID of the stack set that the stack instance is associated with.</p>
    pub fn stack_set_id(&self) -> std::option::Option<&str> {
        self.stack_set_id.as_deref()
    }
    /// <p>The name of the Amazon Web Services Region that the stack instance is associated with.</p>
    pub fn region(&self) -> std::option::Option<&str> {
        self.region.as_deref()
    }
    /// <p>[Self-managed permissions] The name of the Amazon Web Services account that the stack instance is associated with.</p>
    pub fn account(&self) -> std::option::Option<&str> {
        self.account.as_deref()
    }
    /// <p>The ID of the stack instance.</p>
    pub fn stack_id(&self) -> std::option::Option<&str> {
        self.stack_id.as_deref()
    }
    /// <p>The status of the stack instance, in terms of its synchronization with its associated stack set.</p>
    /// <ul>
    /// <li> <p> <code>INOPERABLE</code>: A <code>DeleteStackInstances</code> operation has failed and left the stack in an unstable state. Stacks in this state are excluded from further <code>UpdateStackSet</code> operations. You might need to perform a <code>DeleteStackInstances</code> operation, with <code>RetainStacks</code> set to <code>true</code>, to delete the stack instance, and then delete the stack manually.</p> </li>
    /// <li> <p> <code>OUTDATED</code>: The stack isn't currently up to date with the stack set because:</p>
    /// <ul>
    /// <li> <p>The associated stack failed during a <code>CreateStackSet</code> or <code>UpdateStackSet</code> operation. </p> </li>
    /// <li> <p>The stack was part of a <code>CreateStackSet</code> or <code>UpdateStackSet</code> operation that failed or was stopped before the stack was created or updated. </p> </li>
    /// </ul> </li>
    /// <li> <p> <code>CURRENT</code>: The stack is currently up to date with the stack set.</p> </li>
    /// </ul>
    pub fn status(&self) -> std::option::Option<&crate::model::StackInstanceStatus> {
        self.status.as_ref()
    }
    /// <p>The explanation for the specific status code assigned to this stack instance.</p>
    pub fn status_reason(&self) -> std::option::Option<&str> {
        self.status_reason.as_deref()
    }
    /// <p>The detailed status of the stack instance.</p>
    pub fn stack_instance_status(
        &self,
    ) -> std::option::Option<&crate::model::StackInstanceComprehensiveStatus> {
        self.stack_instance_status.as_ref()
    }
    /// <p>[Service-managed permissions] The organization root ID or organizational unit (OU) IDs that you specified for <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_DeploymentTargets.html">DeploymentTargets</a>.</p>
    pub fn organizational_unit_id(&self) -> std::option::Option<&str> {
        self.organizational_unit_id.as_deref()
    }
    /// <p>Status of the stack instance's actual configuration compared to the expected template and parameter configuration of the stack set to which it belongs. </p>
    /// <ul>
    /// <li> <p> <code>DRIFTED</code>: The stack differs from the expected template and parameter configuration of the stack set to which it belongs. A stack instance is considered to have drifted if one or more of the resources in the associated stack have drifted.</p> </li>
    /// <li> <p> <code>NOT_CHECKED</code>: CloudFormation has not checked if the stack instance differs from its expected stack set configuration.</p> </li>
    /// <li> <p> <code>IN_SYNC</code>: The stack instance's actual configuration matches its expected stack set configuration.</p> </li>
    /// <li> <p> <code>UNKNOWN</code>: This value is reserved for future use.</p> </li>
    /// </ul>
    pub fn drift_status(&self) -> std::option::Option<&crate::model::StackDriftStatus> {
        self.drift_status.as_ref()
    }
    /// <p>Most recent time when CloudFormation performed a drift detection operation on the stack instance. This value will be <code>NULL</code> for any stack instance on which drift detection has not yet been performed.</p>
    pub fn last_drift_check_timestamp(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_drift_check_timestamp.as_ref()
    }
}
impl std::fmt::Debug for StackInstanceSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StackInstanceSummary");
        formatter.field("stack_set_id", &self.stack_set_id);
        formatter.field("region", &self.region);
        formatter.field("account", &self.account);
        formatter.field("stack_id", &self.stack_id);
        formatter.field("status", &self.status);
        formatter.field("status_reason", &self.status_reason);
        formatter.field("stack_instance_status", &self.stack_instance_status);
        formatter.field("organizational_unit_id", &self.organizational_unit_id);
        formatter.field("drift_status", &self.drift_status);
        formatter.field(
            "last_drift_check_timestamp",
            &self.last_drift_check_timestamp,
        );
        formatter.finish()
    }
}
/// See [`StackInstanceSummary`](crate::model::StackInstanceSummary)
pub mod stack_instance_summary {
    /// A builder for [`StackInstanceSummary`](crate::model::StackInstanceSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) stack_set_id: std::option::Option<std::string::String>,
        pub(crate) region: std::option::Option<std::string::String>,
        pub(crate) account: std::option::Option<std::string::String>,
        pub(crate) stack_id: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::StackInstanceStatus>,
        pub(crate) status_reason: std::option::Option<std::string::String>,
        pub(crate) stack_instance_status:
            std::option::Option<crate::model::StackInstanceComprehensiveStatus>,
        pub(crate) organizational_unit_id: std::option::Option<std::string::String>,
        pub(crate) drift_status: std::option::Option<crate::model::StackDriftStatus>,
        pub(crate) last_drift_check_timestamp: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The name or unique ID of the stack set that the stack instance is associated with.</p>
        pub fn stack_set_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.stack_set_id = Some(input.into());
            self
        }
        /// <p>The name or unique ID of the stack set that the stack instance is associated with.</p>
        pub fn set_stack_set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.stack_set_id = input;
            self
        }
        /// <p>The name of the Amazon Web Services Region that the stack instance is associated with.</p>
        pub fn region(mut self, input: impl Into<std::string::String>) -> Self {
            self.region = Some(input.into());
            self
        }
        /// <p>The name of the Amazon Web Services Region that the stack instance is associated with.</p>
        pub fn set_region(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.region = input;
            self
        }
        /// <p>[Self-managed permissions] The name of the Amazon Web Services account that the stack instance is associated with.</p>
        pub fn account(mut self, input: impl Into<std::string::String>) -> Self {
            self.account = Some(input.into());
            self
        }
        /// <p>[Self-managed permissions] The name of the Amazon Web Services account that the stack instance is associated with.</p>
        pub fn set_account(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.account = input;
            self
        }
        /// <p>The ID of the stack instance.</p>
        pub fn stack_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.stack_id = Some(input.into());
            self
        }
        /// <p>The ID of the stack instance.</p>
        pub fn set_stack_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.stack_id = input;
            self
        }
        /// <p>The status of the stack instance, in terms of its synchronization with its associated stack set.</p>
        /// <ul>
        /// <li> <p> <code>INOPERABLE</code>: A <code>DeleteStackInstances</code> operation has failed and left the stack in an unstable state. Stacks in this state are excluded from further <code>UpdateStackSet</code> operations. You might need to perform a <code>DeleteStackInstances</code> operation, with <code>RetainStacks</code> set to <code>true</code>, to delete the stack instance, and then delete the stack manually.</p> </li>
        /// <li> <p> <code>OUTDATED</code>: The stack isn't currently up to date with the stack set because:</p>
        /// <ul>
        /// <li> <p>The associated stack failed during a <code>CreateStackSet</code> or <code>UpdateStackSet</code> operation. </p> </li>
        /// <li> <p>The stack was part of a <code>CreateStackSet</code> or <code>UpdateStackSet</code> operation that failed or was stopped before the stack was created or updated. </p> </li>
        /// </ul> </li>
        /// <li> <p> <code>CURRENT</code>: The stack is currently up to date with the stack set.</p> </li>
        /// </ul>
        pub fn status(mut self, input: crate::model::StackInstanceStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of the stack instance, in terms of its synchronization with its associated stack set.</p>
        /// <ul>
        /// <li> <p> <code>INOPERABLE</code>: A <code>DeleteStackInstances</code> operation has failed and left the stack in an unstable state. Stacks in this state are excluded from further <code>UpdateStackSet</code> operations. You might need to perform a <code>DeleteStackInstances</code> operation, with <code>RetainStacks</code> set to <code>true</code>, to delete the stack instance, and then delete the stack manually.</p> </li>
        /// <li> <p> <code>OUTDATED</code>: The stack isn't currently up to date with the stack set because:</p>
        /// <ul>
        /// <li> <p>The associated stack failed during a <code>CreateStackSet</code> or <code>UpdateStackSet</code> operation. </p> </li>
        /// <li> <p>The stack was part of a <code>CreateStackSet</code> or <code>UpdateStackSet</code> operation that failed or was stopped before the stack was created or updated. </p> </li>
        /// </ul> </li>
        /// <li> <p> <code>CURRENT</code>: The stack is currently up to date with the stack set.</p> </li>
        /// </ul>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::StackInstanceStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>The explanation for the specific status code assigned to this stack instance.</p>
        pub fn status_reason(mut self, input: impl Into<std::string::String>) -> Self {
            self.status_reason = Some(input.into());
            self
        }
        /// <p>The explanation for the specific status code assigned to this stack instance.</p>
        pub fn set_status_reason(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.status_reason = input;
            self
        }
        /// <p>The detailed status of the stack instance.</p>
        pub fn stack_instance_status(
            mut self,
            input: crate::model::StackInstanceComprehensiveStatus,
        ) -> Self {
            self.stack_instance_status = Some(input);
            self
        }
        /// <p>The detailed status of the stack instance.</p>
        pub fn set_stack_instance_status(
            mut self,
            input: std::option::Option<crate::model::StackInstanceComprehensiveStatus>,
        ) -> Self {
            self.stack_instance_status = input;
            self
        }
        /// <p>[Service-managed permissions] The organization root ID or organizational unit (OU) IDs that you specified for <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_DeploymentTargets.html">DeploymentTargets</a>.</p>
        pub fn organizational_unit_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.organizational_unit_id = Some(input.into());
            self
        }
        /// <p>[Service-managed permissions] The organization root ID or organizational unit (OU) IDs that you specified for <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_DeploymentTargets.html">DeploymentTargets</a>.</p>
        pub fn set_organizational_unit_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.organizational_unit_id = input;
            self
        }
        /// <p>Status of the stack instance's actual configuration compared to the expected template and parameter configuration of the stack set to which it belongs. </p>
        /// <ul>
        /// <li> <p> <code>DRIFTED</code>: The stack differs from the expected template and parameter configuration of the stack set to which it belongs. A stack instance is considered to have drifted if one or more of the resources in the associated stack have drifted.</p> </li>
        /// <li> <p> <code>NOT_CHECKED</code>: CloudFormation has not checked if the stack instance differs from its expected stack set configuration.</p> </li>
        /// <li> <p> <code>IN_SYNC</code>: The stack instance's actual configuration matches its expected stack set configuration.</p> </li>
        /// <li> <p> <code>UNKNOWN</code>: This value is reserved for future use.</p> </li>
        /// </ul>
        pub fn drift_status(mut self, input: crate::model::StackDriftStatus) -> Self {
            self.drift_status = Some(input);
            self
        }
        /// <p>Status of the stack instance's actual configuration compared to the expected template and parameter configuration of the stack set to which it belongs. </p>
        /// <ul>
        /// <li> <p> <code>DRIFTED</code>: The stack differs from the expected template and parameter configuration of the stack set to which it belongs. A stack instance is considered to have drifted if one or more of the resources in the associated stack have drifted.</p> </li>
        /// <li> <p> <code>NOT_CHECKED</code>: CloudFormation has not checked if the stack instance differs from its expected stack set configuration.</p> </li>
        /// <li> <p> <code>IN_SYNC</code>: The stack instance's actual configuration matches its expected stack set configuration.</p> </li>
        /// <li> <p> <code>UNKNOWN</code>: This value is reserved for future use.</p> </li>
        /// </ul>
        pub fn set_drift_status(
            mut self,
            input: std::option::Option<crate::model::StackDriftStatus>,
        ) -> Self {
            self.drift_status = input;
            self
        }
        /// <p>Most recent time when CloudFormation performed a drift detection operation on the stack instance. This value will be <code>NULL</code> for any stack instance on which drift detection has not yet been performed.</p>
        pub fn last_drift_check_timestamp(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_drift_check_timestamp = Some(input);
            self
        }
        /// <p>Most recent time when CloudFormation performed a drift detection operation on the stack instance. This value will be <code>NULL</code> for any stack instance on which drift detection has not yet been performed.</p>
        pub fn set_last_drift_check_timestamp(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_drift_check_timestamp = input;
            self
        }
        /// Consumes the builder and constructs a [`StackInstanceSummary`](crate::model::StackInstanceSummary)
        pub fn build(self) -> crate::model::StackInstanceSummary {
            crate::model::StackInstanceSummary {
                stack_set_id: self.stack_set_id,
                region: self.region,
                account: self.account,
                stack_id: self.stack_id,
                status: self.status,
                status_reason: self.status_reason,
                stack_instance_status: self.stack_instance_status,
                organizational_unit_id: self.organizational_unit_id,
                drift_status: self.drift_status,
                last_drift_check_timestamp: self.last_drift_check_timestamp,
            }
        }
    }
}
impl StackInstanceSummary {
    /// Creates a new builder-style object to manufacture [`StackInstanceSummary`](crate::model::StackInstanceSummary)
    pub fn builder() -> crate::model::stack_instance_summary::Builder {
        crate::model::stack_instance_summary::Builder::default()
    }
}

/// <p>The detailed status of the stack instance.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StackInstanceComprehensiveStatus {
    /// <ul>
    /// <li> <p> <code>CANCELLED</code>: The operation in the specified account and Region has been cancelled. This is either because a user has stopped the stack set operation, or because the failure tolerance of the stack set operation has been exceeded.</p> </li>
    /// <li> <p> <code>FAILED</code>: The operation in the specified account and Region failed. If the stack set operation fails in enough accounts within a Region, the failure tolerance for the stack set operation as a whole might be exceeded.</p> </li>
    /// <li> <p> <code>INOPERABLE</code>: A <code>DeleteStackInstances</code> operation has failed and left the stack in an unstable state. Stacks in this state are excluded from further <code>UpdateStackSet</code> operations. You might need to perform a <code>DeleteStackInstances</code> operation, with <code>RetainStacks</code> set to <code>true</code>, to delete the stack instance, and then delete the stack manually.</p> </li>
    /// <li> <p> <code>PENDING</code>: The operation in the specified account and Region has yet to start.</p> </li>
    /// <li> <p> <code>RUNNING</code>: The operation in the specified account and Region is currently in progress.</p> </li>
    /// <li> <p> <code>SUCCEEDED</code>: The operation in the specified account and Region completed successfully.</p> </li>
    /// </ul>
    pub detailed_status: std::option::Option<crate::model::StackInstanceDetailedStatus>,
}
impl StackInstanceComprehensiveStatus {
    /// <ul>
    /// <li> <p> <code>CANCELLED</code>: The operation in the specified account and Region has been cancelled. This is either because a user has stopped the stack set operation, or because the failure tolerance of the stack set operation has been exceeded.</p> </li>
    /// <li> <p> <code>FAILED</code>: The operation in the specified account and Region failed. If the stack set operation fails in enough accounts within a Region, the failure tolerance for the stack set operation as a whole might be exceeded.</p> </li>
    /// <li> <p> <code>INOPERABLE</code>: A <code>DeleteStackInstances</code> operation has failed and left the stack in an unstable state. Stacks in this state are excluded from further <code>UpdateStackSet</code> operations. You might need to perform a <code>DeleteStackInstances</code> operation, with <code>RetainStacks</code> set to <code>true</code>, to delete the stack instance, and then delete the stack manually.</p> </li>
    /// <li> <p> <code>PENDING</code>: The operation in the specified account and Region has yet to start.</p> </li>
    /// <li> <p> <code>RUNNING</code>: The operation in the specified account and Region is currently in progress.</p> </li>
    /// <li> <p> <code>SUCCEEDED</code>: The operation in the specified account and Region completed successfully.</p> </li>
    /// </ul>
    pub fn detailed_status(
        &self,
    ) -> std::option::Option<&crate::model::StackInstanceDetailedStatus> {
        self.detailed_status.as_ref()
    }
}
impl std::fmt::Debug for StackInstanceComprehensiveStatus {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StackInstanceComprehensiveStatus");
        formatter.field("detailed_status", &self.detailed_status);
        formatter.finish()
    }
}
/// See [`StackInstanceComprehensiveStatus`](crate::model::StackInstanceComprehensiveStatus)
pub mod stack_instance_comprehensive_status {
    /// A builder for [`StackInstanceComprehensiveStatus`](crate::model::StackInstanceComprehensiveStatus)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) detailed_status: std::option::Option<crate::model::StackInstanceDetailedStatus>,
    }
    impl Builder {
        /// <ul>
        /// <li> <p> <code>CANCELLED</code>: The operation in the specified account and Region has been cancelled. This is either because a user has stopped the stack set operation, or because the failure tolerance of the stack set operation has been exceeded.</p> </li>
        /// <li> <p> <code>FAILED</code>: The operation in the specified account and Region failed. If the stack set operation fails in enough accounts within a Region, the failure tolerance for the stack set operation as a whole might be exceeded.</p> </li>
        /// <li> <p> <code>INOPERABLE</code>: A <code>DeleteStackInstances</code> operation has failed and left the stack in an unstable state. Stacks in this state are excluded from further <code>UpdateStackSet</code> operations. You might need to perform a <code>DeleteStackInstances</code> operation, with <code>RetainStacks</code> set to <code>true</code>, to delete the stack instance, and then delete the stack manually.</p> </li>
        /// <li> <p> <code>PENDING</code>: The operation in the specified account and Region has yet to start.</p> </li>
        /// <li> <p> <code>RUNNING</code>: The operation in the specified account and Region is currently in progress.</p> </li>
        /// <li> <p> <code>SUCCEEDED</code>: The operation in the specified account and Region completed successfully.</p> </li>
        /// </ul>
        pub fn detailed_status(mut self, input: crate::model::StackInstanceDetailedStatus) -> Self {
            self.detailed_status = Some(input);
            self
        }
        /// <ul>
        /// <li> <p> <code>CANCELLED</code>: The operation in the specified account and Region has been cancelled. This is either because a user has stopped the stack set operation, or because the failure tolerance of the stack set operation has been exceeded.</p> </li>
        /// <li> <p> <code>FAILED</code>: The operation in the specified account and Region failed. If the stack set operation fails in enough accounts within a Region, the failure tolerance for the stack set operation as a whole might be exceeded.</p> </li>
        /// <li> <p> <code>INOPERABLE</code>: A <code>DeleteStackInstances</code> operation has failed and left the stack in an unstable state. Stacks in this state are excluded from further <code>UpdateStackSet</code> operations. You might need to perform a <code>DeleteStackInstances</code> operation, with <code>RetainStacks</code> set to <code>true</code>, to delete the stack instance, and then delete the stack manually.</p> </li>
        /// <li> <p> <code>PENDING</code>: The operation in the specified account and Region has yet to start.</p> </li>
        /// <li> <p> <code>RUNNING</code>: The operation in the specified account and Region is currently in progress.</p> </li>
        /// <li> <p> <code>SUCCEEDED</code>: The operation in the specified account and Region completed successfully.</p> </li>
        /// </ul>
        pub fn set_detailed_status(
            mut self,
            input: std::option::Option<crate::model::StackInstanceDetailedStatus>,
        ) -> Self {
            self.detailed_status = input;
            self
        }
        /// Consumes the builder and constructs a [`StackInstanceComprehensiveStatus`](crate::model::StackInstanceComprehensiveStatus)
        pub fn build(self) -> crate::model::StackInstanceComprehensiveStatus {
            crate::model::StackInstanceComprehensiveStatus {
                detailed_status: self.detailed_status,
            }
        }
    }
}
impl StackInstanceComprehensiveStatus {
    /// Creates a new builder-style object to manufacture [`StackInstanceComprehensiveStatus`](crate::model::StackInstanceComprehensiveStatus)
    pub fn builder() -> crate::model::stack_instance_comprehensive_status::Builder {
        crate::model::stack_instance_comprehensive_status::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum StackInstanceDetailedStatus {
    #[allow(missing_docs)] // documentation missing in model
    Cancelled,
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    #[allow(missing_docs)] // documentation missing in model
    Inoperable,
    #[allow(missing_docs)] // documentation missing in model
    Pending,
    #[allow(missing_docs)] // documentation missing in model
    Running,
    #[allow(missing_docs)] // documentation missing in model
    Succeeded,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for StackInstanceDetailedStatus {
    fn from(s: &str) -> Self {
        match s {
            "CANCELLED" => StackInstanceDetailedStatus::Cancelled,
            "FAILED" => StackInstanceDetailedStatus::Failed,
            "INOPERABLE" => StackInstanceDetailedStatus::Inoperable,
            "PENDING" => StackInstanceDetailedStatus::Pending,
            "RUNNING" => StackInstanceDetailedStatus::Running,
            "SUCCEEDED" => StackInstanceDetailedStatus::Succeeded,
            other => StackInstanceDetailedStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for StackInstanceDetailedStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(StackInstanceDetailedStatus::from(s))
    }
}
impl StackInstanceDetailedStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            StackInstanceDetailedStatus::Cancelled => "CANCELLED",
            StackInstanceDetailedStatus::Failed => "FAILED",
            StackInstanceDetailedStatus::Inoperable => "INOPERABLE",
            StackInstanceDetailedStatus::Pending => "PENDING",
            StackInstanceDetailedStatus::Running => "RUNNING",
            StackInstanceDetailedStatus::Succeeded => "SUCCEEDED",
            StackInstanceDetailedStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "CANCELLED",
            "FAILED",
            "INOPERABLE",
            "PENDING",
            "RUNNING",
            "SUCCEEDED",
        ]
    }
}
impl AsRef<str> for StackInstanceDetailedStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum StackInstanceStatus {
    #[allow(missing_docs)] // documentation missing in model
    Current,
    #[allow(missing_docs)] // documentation missing in model
    Inoperable,
    #[allow(missing_docs)] // documentation missing in model
    Outdated,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for StackInstanceStatus {
    fn from(s: &str) -> Self {
        match s {
            "CURRENT" => StackInstanceStatus::Current,
            "INOPERABLE" => StackInstanceStatus::Inoperable,
            "OUTDATED" => StackInstanceStatus::Outdated,
            other => StackInstanceStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for StackInstanceStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(StackInstanceStatus::from(s))
    }
}
impl StackInstanceStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            StackInstanceStatus::Current => "CURRENT",
            StackInstanceStatus::Inoperable => "INOPERABLE",
            StackInstanceStatus::Outdated => "OUTDATED",
            StackInstanceStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["CURRENT", "INOPERABLE", "OUTDATED"]
    }
}
impl AsRef<str> for StackInstanceStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The status that stack instances are filtered by.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StackInstanceFilter {
    /// <p>The type of filter to apply.</p>
    pub name: std::option::Option<crate::model::StackInstanceFilterName>,
    /// <p>The status to filter by.</p>
    pub values: std::option::Option<std::string::String>,
}
impl StackInstanceFilter {
    /// <p>The type of filter to apply.</p>
    pub fn name(&self) -> std::option::Option<&crate::model::StackInstanceFilterName> {
        self.name.as_ref()
    }
    /// <p>The status to filter by.</p>
    pub fn values(&self) -> std::option::Option<&str> {
        self.values.as_deref()
    }
}
impl std::fmt::Debug for StackInstanceFilter {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StackInstanceFilter");
        formatter.field("name", &self.name);
        formatter.field("values", &self.values);
        formatter.finish()
    }
}
/// See [`StackInstanceFilter`](crate::model::StackInstanceFilter)
pub mod stack_instance_filter {
    /// A builder for [`StackInstanceFilter`](crate::model::StackInstanceFilter)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<crate::model::StackInstanceFilterName>,
        pub(crate) values: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The type of filter to apply.</p>
        pub fn name(mut self, input: crate::model::StackInstanceFilterName) -> Self {
            self.name = Some(input);
            self
        }
        /// <p>The type of filter to apply.</p>
        pub fn set_name(
            mut self,
            input: std::option::Option<crate::model::StackInstanceFilterName>,
        ) -> Self {
            self.name = input;
            self
        }
        /// <p>The status to filter by.</p>
        pub fn values(mut self, input: impl Into<std::string::String>) -> Self {
            self.values = Some(input.into());
            self
        }
        /// <p>The status to filter by.</p>
        pub fn set_values(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.values = input;
            self
        }
        /// Consumes the builder and constructs a [`StackInstanceFilter`](crate::model::StackInstanceFilter)
        pub fn build(self) -> crate::model::StackInstanceFilter {
            crate::model::StackInstanceFilter {
                name: self.name,
                values: self.values,
            }
        }
    }
}
impl StackInstanceFilter {
    /// Creates a new builder-style object to manufacture [`StackInstanceFilter`](crate::model::StackInstanceFilter)
    pub fn builder() -> crate::model::stack_instance_filter::Builder {
        crate::model::stack_instance_filter::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum StackInstanceFilterName {
    #[allow(missing_docs)] // documentation missing in model
    DetailedStatus,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for StackInstanceFilterName {
    fn from(s: &str) -> Self {
        match s {
            "DETAILED_STATUS" => StackInstanceFilterName::DetailedStatus,
            other => StackInstanceFilterName::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for StackInstanceFilterName {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(StackInstanceFilterName::from(s))
    }
}
impl StackInstanceFilterName {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            StackInstanceFilterName::DetailedStatus => "DETAILED_STATUS",
            StackInstanceFilterName::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["DETAILED_STATUS"]
    }
}
impl AsRef<str> for StackInstanceFilterName {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The <code>Export</code> structure describes the exported output values for a stack.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Export {
    /// <p>The stack that contains the exported output name and value.</p>
    pub exporting_stack_id: std::option::Option<std::string::String>,
    /// <p>The name of exported output value. Use this name and the <code>Fn::ImportValue</code> function to import the associated value into other stacks. The name is defined in the <code>Export</code> field in the associated stack's <code>Outputs</code> section.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The value of the exported output, such as a resource physical ID. This value is defined in the <code>Export</code> field in the associated stack's <code>Outputs</code> section.</p>
    pub value: std::option::Option<std::string::String>,
}
impl Export {
    /// <p>The stack that contains the exported output name and value.</p>
    pub fn exporting_stack_id(&self) -> std::option::Option<&str> {
        self.exporting_stack_id.as_deref()
    }
    /// <p>The name of exported output value. Use this name and the <code>Fn::ImportValue</code> function to import the associated value into other stacks. The name is defined in the <code>Export</code> field in the associated stack's <code>Outputs</code> section.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The value of the exported output, such as a resource physical ID. This value is defined in the <code>Export</code> field in the associated stack's <code>Outputs</code> section.</p>
    pub fn value(&self) -> std::option::Option<&str> {
        self.value.as_deref()
    }
}
impl std::fmt::Debug for Export {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Export");
        formatter.field("exporting_stack_id", &self.exporting_stack_id);
        formatter.field("name", &self.name);
        formatter.field("value", &self.value);
        formatter.finish()
    }
}
/// See [`Export`](crate::model::Export)
pub mod export {
    /// A builder for [`Export`](crate::model::Export)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) exporting_stack_id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) value: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The stack that contains the exported output name and value.</p>
        pub fn exporting_stack_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.exporting_stack_id = Some(input.into());
            self
        }
        /// <p>The stack that contains the exported output name and value.</p>
        pub fn set_exporting_stack_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.exporting_stack_id = input;
            self
        }
        /// <p>The name of exported output value. Use this name and the <code>Fn::ImportValue</code> function to import the associated value into other stacks. The name is defined in the <code>Export</code> field in the associated stack's <code>Outputs</code> section.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of exported output value. Use this name and the <code>Fn::ImportValue</code> function to import the associated value into other stacks. The name is defined in the <code>Export</code> field in the associated stack's <code>Outputs</code> section.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The value of the exported output, such as a resource physical ID. This value is defined in the <code>Export</code> field in the associated stack's <code>Outputs</code> section.</p>
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            self.value = Some(input.into());
            self
        }
        /// <p>The value of the exported output, such as a resource physical ID. This value is defined in the <code>Export</code> field in the associated stack's <code>Outputs</code> section.</p>
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.value = input;
            self
        }
        /// Consumes the builder and constructs a [`Export`](crate::model::Export)
        pub fn build(self) -> crate::model::Export {
            crate::model::Export {
                exporting_stack_id: self.exporting_stack_id,
                name: self.name,
                value: self.value,
            }
        }
    }
}
impl Export {
    /// Creates a new builder-style object to manufacture [`Export`](crate::model::Export)
    pub fn builder() -> crate::model::export::Builder {
        crate::model::export::Builder::default()
    }
}

/// <p>The <code>ChangeSetSummary</code> structure describes a change set, its status, and the stack with which it's associated.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ChangeSetSummary {
    /// <p>The ID of the stack with which the change set is associated.</p>
    pub stack_id: std::option::Option<std::string::String>,
    /// <p>The name of the stack with which the change set is associated.</p>
    pub stack_name: std::option::Option<std::string::String>,
    /// <p>The ID of the change set.</p>
    pub change_set_id: std::option::Option<std::string::String>,
    /// <p>The name of the change set.</p>
    pub change_set_name: std::option::Option<std::string::String>,
    /// <p>If the change set execution status is <code>AVAILABLE</code>, you can execute the change set. If you can’t execute the change set, the status indicates why. For example, a change set might be in an <code>UNAVAILABLE</code> state because CloudFormation is still creating it or in an <code>OBSOLETE</code> state because the stack was already updated.</p>
    pub execution_status: std::option::Option<crate::model::ExecutionStatus>,
    /// <p>The state of the change set, such as <code>CREATE_IN_PROGRESS</code>, <code>CREATE_COMPLETE</code>, or <code>FAILED</code>.</p>
    pub status: std::option::Option<crate::model::ChangeSetStatus>,
    /// <p>A description of the change set's status. For example, if your change set is in the <code>FAILED</code> state, CloudFormation shows the error message.</p>
    pub status_reason: std::option::Option<std::string::String>,
    /// <p>The start time when the change set was created, in UTC.</p>
    pub creation_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>Descriptive information about the change set.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>Specifies the current setting of <code>IncludeNestedStacks</code> for the change set.</p>
    pub include_nested_stacks: std::option::Option<bool>,
    /// <p>The parent change set ID.</p>
    pub parent_change_set_id: std::option::Option<std::string::String>,
    /// <p>The root change set ID.</p>
    pub root_change_set_id: std::option::Option<std::string::String>,
}
impl ChangeSetSummary {
    /// <p>The ID of the stack with which the change set is associated.</p>
    pub fn stack_id(&self) -> std::option::Option<&str> {
        self.stack_id.as_deref()
    }
    /// <p>The name of the stack with which the change set is associated.</p>
    pub fn stack_name(&self) -> std::option::Option<&str> {
        self.stack_name.as_deref()
    }
    /// <p>The ID of the change set.</p>
    pub fn change_set_id(&self) -> std::option::Option<&str> {
        self.change_set_id.as_deref()
    }
    /// <p>The name of the change set.</p>
    pub fn change_set_name(&self) -> std::option::Option<&str> {
        self.change_set_name.as_deref()
    }
    /// <p>If the change set execution status is <code>AVAILABLE</code>, you can execute the change set. If you can’t execute the change set, the status indicates why. For example, a change set might be in an <code>UNAVAILABLE</code> state because CloudFormation is still creating it or in an <code>OBSOLETE</code> state because the stack was already updated.</p>
    pub fn execution_status(&self) -> std::option::Option<&crate::model::ExecutionStatus> {
        self.execution_status.as_ref()
    }
    /// <p>The state of the change set, such as <code>CREATE_IN_PROGRESS</code>, <code>CREATE_COMPLETE</code>, or <code>FAILED</code>.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::ChangeSetStatus> {
        self.status.as_ref()
    }
    /// <p>A description of the change set's status. For example, if your change set is in the <code>FAILED</code> state, CloudFormation shows the error message.</p>
    pub fn status_reason(&self) -> std::option::Option<&str> {
        self.status_reason.as_deref()
    }
    /// <p>The start time when the change set was created, in UTC.</p>
    pub fn creation_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.creation_time.as_ref()
    }
    /// <p>Descriptive information about the change set.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>Specifies the current setting of <code>IncludeNestedStacks</code> for the change set.</p>
    pub fn include_nested_stacks(&self) -> std::option::Option<bool> {
        self.include_nested_stacks
    }
    /// <p>The parent change set ID.</p>
    pub fn parent_change_set_id(&self) -> std::option::Option<&str> {
        self.parent_change_set_id.as_deref()
    }
    /// <p>The root change set ID.</p>
    pub fn root_change_set_id(&self) -> std::option::Option<&str> {
        self.root_change_set_id.as_deref()
    }
}
impl std::fmt::Debug for ChangeSetSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ChangeSetSummary");
        formatter.field("stack_id", &self.stack_id);
        formatter.field("stack_name", &self.stack_name);
        formatter.field("change_set_id", &self.change_set_id);
        formatter.field("change_set_name", &self.change_set_name);
        formatter.field("execution_status", &self.execution_status);
        formatter.field("status", &self.status);
        formatter.field("status_reason", &self.status_reason);
        formatter.field("creation_time", &self.creation_time);
        formatter.field("description", &self.description);
        formatter.field("include_nested_stacks", &self.include_nested_stacks);
        formatter.field("parent_change_set_id", &self.parent_change_set_id);
        formatter.field("root_change_set_id", &self.root_change_set_id);
        formatter.finish()
    }
}
/// See [`ChangeSetSummary`](crate::model::ChangeSetSummary)
pub mod change_set_summary {
    /// A builder for [`ChangeSetSummary`](crate::model::ChangeSetSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) stack_id: std::option::Option<std::string::String>,
        pub(crate) stack_name: std::option::Option<std::string::String>,
        pub(crate) change_set_id: std::option::Option<std::string::String>,
        pub(crate) change_set_name: std::option::Option<std::string::String>,
        pub(crate) execution_status: std::option::Option<crate::model::ExecutionStatus>,
        pub(crate) status: std::option::Option<crate::model::ChangeSetStatus>,
        pub(crate) status_reason: std::option::Option<std::string::String>,
        pub(crate) creation_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) include_nested_stacks: std::option::Option<bool>,
        pub(crate) parent_change_set_id: std::option::Option<std::string::String>,
        pub(crate) root_change_set_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the stack with which the change set is associated.</p>
        pub fn stack_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.stack_id = Some(input.into());
            self
        }
        /// <p>The ID of the stack with which the change set is associated.</p>
        pub fn set_stack_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.stack_id = input;
            self
        }
        /// <p>The name of the stack with which the change set is associated.</p>
        pub fn stack_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.stack_name = Some(input.into());
            self
        }
        /// <p>The name of the stack with which the change set is associated.</p>
        pub fn set_stack_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.stack_name = input;
            self
        }
        /// <p>The ID of the change set.</p>
        pub fn change_set_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.change_set_id = Some(input.into());
            self
        }
        /// <p>The ID of the change set.</p>
        pub fn set_change_set_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.change_set_id = input;
            self
        }
        /// <p>The name of the change set.</p>
        pub fn change_set_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.change_set_name = Some(input.into());
            self
        }
        /// <p>The name of the change set.</p>
        pub fn set_change_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.change_set_name = input;
            self
        }
        /// <p>If the change set execution status is <code>AVAILABLE</code>, you can execute the change set. If you can’t execute the change set, the status indicates why. For example, a change set might be in an <code>UNAVAILABLE</code> state because CloudFormation is still creating it or in an <code>OBSOLETE</code> state because the stack was already updated.</p>
        pub fn execution_status(mut self, input: crate::model::ExecutionStatus) -> Self {
            self.execution_status = Some(input);
            self
        }
        /// <p>If the change set execution status is <code>AVAILABLE</code>, you can execute the change set. If you can’t execute the change set, the status indicates why. For example, a change set might be in an <code>UNAVAILABLE</code> state because CloudFormation is still creating it or in an <code>OBSOLETE</code> state because the stack was already updated.</p>
        pub fn set_execution_status(
            mut self,
            input: std::option::Option<crate::model::ExecutionStatus>,
        ) -> Self {
            self.execution_status = input;
            self
        }
        /// <p>The state of the change set, such as <code>CREATE_IN_PROGRESS</code>, <code>CREATE_COMPLETE</code>, or <code>FAILED</code>.</p>
        pub fn status(mut self, input: crate::model::ChangeSetStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The state of the change set, such as <code>CREATE_IN_PROGRESS</code>, <code>CREATE_COMPLETE</code>, or <code>FAILED</code>.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::ChangeSetStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>A description of the change set's status. For example, if your change set is in the <code>FAILED</code> state, CloudFormation shows the error message.</p>
        pub fn status_reason(mut self, input: impl Into<std::string::String>) -> Self {
            self.status_reason = Some(input.into());
            self
        }
        /// <p>A description of the change set's status. For example, if your change set is in the <code>FAILED</code> state, CloudFormation shows the error message.</p>
        pub fn set_status_reason(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.status_reason = input;
            self
        }
        /// <p>The start time when the change set was created, in UTC.</p>
        pub fn creation_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.creation_time = Some(input);
            self
        }
        /// <p>The start time when the change set was created, in UTC.</p>
        pub fn set_creation_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.creation_time = input;
            self
        }
        /// <p>Descriptive information about the change set.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>Descriptive information about the change set.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>Specifies the current setting of <code>IncludeNestedStacks</code> for the change set.</p>
        pub fn include_nested_stacks(mut self, input: bool) -> Self {
            self.include_nested_stacks = Some(input);
            self
        }
        /// <p>Specifies the current setting of <code>IncludeNestedStacks</code> for the change set.</p>
        pub fn set_include_nested_stacks(mut self, input: std::option::Option<bool>) -> Self {
            self.include_nested_stacks = input;
            self
        }
        /// <p>The parent change set ID.</p>
        pub fn parent_change_set_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.parent_change_set_id = Some(input.into());
            self
        }
        /// <p>The parent change set ID.</p>
        pub fn set_parent_change_set_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.parent_change_set_id = input;
            self
        }
        /// <p>The root change set ID.</p>
        pub fn root_change_set_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.root_change_set_id = Some(input.into());
            self
        }
        /// <p>The root change set ID.</p>
        pub fn set_root_change_set_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.root_change_set_id = input;
            self
        }
        /// Consumes the builder and constructs a [`ChangeSetSummary`](crate::model::ChangeSetSummary)
        pub fn build(self) -> crate::model::ChangeSetSummary {
            crate::model::ChangeSetSummary {
                stack_id: self.stack_id,
                stack_name: self.stack_name,
                change_set_id: self.change_set_id,
                change_set_name: self.change_set_name,
                execution_status: self.execution_status,
                status: self.status,
                status_reason: self.status_reason,
                creation_time: self.creation_time,
                description: self.description,
                include_nested_stacks: self.include_nested_stacks,
                parent_change_set_id: self.parent_change_set_id,
                root_change_set_id: self.root_change_set_id,
            }
        }
    }
}
impl ChangeSetSummary {
    /// Creates a new builder-style object to manufacture [`ChangeSetSummary`](crate::model::ChangeSetSummary)
    pub fn builder() -> crate::model::change_set_summary::Builder {
        crate::model::change_set_summary::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ChangeSetStatus {
    #[allow(missing_docs)] // documentation missing in model
    CreateComplete,
    #[allow(missing_docs)] // documentation missing in model
    CreateInProgress,
    #[allow(missing_docs)] // documentation missing in model
    CreatePending,
    #[allow(missing_docs)] // documentation missing in model
    DeleteComplete,
    #[allow(missing_docs)] // documentation missing in model
    DeleteFailed,
    #[allow(missing_docs)] // documentation missing in model
    DeleteInProgress,
    #[allow(missing_docs)] // documentation missing in model
    DeletePending,
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ChangeSetStatus {
    fn from(s: &str) -> Self {
        match s {
            "CREATE_COMPLETE" => ChangeSetStatus::CreateComplete,
            "CREATE_IN_PROGRESS" => ChangeSetStatus::CreateInProgress,
            "CREATE_PENDING" => ChangeSetStatus::CreatePending,
            "DELETE_COMPLETE" => ChangeSetStatus::DeleteComplete,
            "DELETE_FAILED" => ChangeSetStatus::DeleteFailed,
            "DELETE_IN_PROGRESS" => ChangeSetStatus::DeleteInProgress,
            "DELETE_PENDING" => ChangeSetStatus::DeletePending,
            "FAILED" => ChangeSetStatus::Failed,
            other => ChangeSetStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ChangeSetStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ChangeSetStatus::from(s))
    }
}
impl ChangeSetStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ChangeSetStatus::CreateComplete => "CREATE_COMPLETE",
            ChangeSetStatus::CreateInProgress => "CREATE_IN_PROGRESS",
            ChangeSetStatus::CreatePending => "CREATE_PENDING",
            ChangeSetStatus::DeleteComplete => "DELETE_COMPLETE",
            ChangeSetStatus::DeleteFailed => "DELETE_FAILED",
            ChangeSetStatus::DeleteInProgress => "DELETE_IN_PROGRESS",
            ChangeSetStatus::DeletePending => "DELETE_PENDING",
            ChangeSetStatus::Failed => "FAILED",
            ChangeSetStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "CREATE_COMPLETE",
            "CREATE_IN_PROGRESS",
            "CREATE_PENDING",
            "DELETE_COMPLETE",
            "DELETE_FAILED",
            "DELETE_IN_PROGRESS",
            "DELETE_PENDING",
            "FAILED",
        ]
    }
}
impl AsRef<str> for ChangeSetStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ExecutionStatus {
    #[allow(missing_docs)] // documentation missing in model
    Available,
    #[allow(missing_docs)] // documentation missing in model
    ExecuteComplete,
    #[allow(missing_docs)] // documentation missing in model
    ExecuteFailed,
    #[allow(missing_docs)] // documentation missing in model
    ExecuteInProgress,
    #[allow(missing_docs)] // documentation missing in model
    Obsolete,
    #[allow(missing_docs)] // documentation missing in model
    Unavailable,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ExecutionStatus {
    fn from(s: &str) -> Self {
        match s {
            "AVAILABLE" => ExecutionStatus::Available,
            "EXECUTE_COMPLETE" => ExecutionStatus::ExecuteComplete,
            "EXECUTE_FAILED" => ExecutionStatus::ExecuteFailed,
            "EXECUTE_IN_PROGRESS" => ExecutionStatus::ExecuteInProgress,
            "OBSOLETE" => ExecutionStatus::Obsolete,
            "UNAVAILABLE" => ExecutionStatus::Unavailable,
            other => ExecutionStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ExecutionStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ExecutionStatus::from(s))
    }
}
impl ExecutionStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ExecutionStatus::Available => "AVAILABLE",
            ExecutionStatus::ExecuteComplete => "EXECUTE_COMPLETE",
            ExecutionStatus::ExecuteFailed => "EXECUTE_FAILED",
            ExecutionStatus::ExecuteInProgress => "EXECUTE_IN_PROGRESS",
            ExecutionStatus::Obsolete => "OBSOLETE",
            ExecutionStatus::Unavailable => "UNAVAILABLE",
            ExecutionStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "AVAILABLE",
            "EXECUTE_COMPLETE",
            "EXECUTE_FAILED",
            "EXECUTE_IN_PROGRESS",
            "OBSOLETE",
            "UNAVAILABLE",
        ]
    }
}
impl AsRef<str> for ExecutionStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Describes the target resources of a specific type in your import template (for example, all <code>AWS::S3::Bucket</code> resources) and the properties you can provide during the import to identify resources of that type.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResourceIdentifierSummary {
    /// <p>The template resource type of the target resources, such as <code>AWS::S3::Bucket</code>.</p>
    pub resource_type: std::option::Option<std::string::String>,
    /// <p>The logical IDs of the target resources of the specified <code>ResourceType</code>, as defined in the import template.</p>
    pub logical_resource_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The resource properties you can provide during the import to identify your target resources. For example, <code>BucketName</code> is a possible identifier property for <code>AWS::S3::Bucket</code> resources.</p>
    pub resource_identifiers: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl ResourceIdentifierSummary {
    /// <p>The template resource type of the target resources, such as <code>AWS::S3::Bucket</code>.</p>
    pub fn resource_type(&self) -> std::option::Option<&str> {
        self.resource_type.as_deref()
    }
    /// <p>The logical IDs of the target resources of the specified <code>ResourceType</code>, as defined in the import template.</p>
    pub fn logical_resource_ids(&self) -> std::option::Option<&[std::string::String]> {
        self.logical_resource_ids.as_deref()
    }
    /// <p>The resource properties you can provide during the import to identify your target resources. For example, <code>BucketName</code> is a possible identifier property for <code>AWS::S3::Bucket</code> resources.</p>
    pub fn resource_identifiers(&self) -> std::option::Option<&[std::string::String]> {
        self.resource_identifiers.as_deref()
    }
}
impl std::fmt::Debug for ResourceIdentifierSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResourceIdentifierSummary");
        formatter.field("resource_type", &self.resource_type);
        formatter.field("logical_resource_ids", &self.logical_resource_ids);
        formatter.field("resource_identifiers", &self.resource_identifiers);
        formatter.finish()
    }
}
/// See [`ResourceIdentifierSummary`](crate::model::ResourceIdentifierSummary)
pub mod resource_identifier_summary {
    /// A builder for [`ResourceIdentifierSummary`](crate::model::ResourceIdentifierSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_type: std::option::Option<std::string::String>,
        pub(crate) logical_resource_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) resource_identifiers: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The template resource type of the target resources, such as <code>AWS::S3::Bucket</code>.</p>
        pub fn resource_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_type = Some(input.into());
            self
        }
        /// <p>The template resource type of the target resources, such as <code>AWS::S3::Bucket</code>.</p>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_type = input;
            self
        }
        /// Appends an item to `logical_resource_ids`.
        ///
        /// To override the contents of this collection use [`set_logical_resource_ids`](Self::set_logical_resource_ids).
        ///
        /// <p>The logical IDs of the target resources of the specified <code>ResourceType</code>, as defined in the import template.</p>
        pub fn logical_resource_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.logical_resource_ids.unwrap_or_default();
            v.push(input.into());
            self.logical_resource_ids = Some(v);
            self
        }
        /// <p>The logical IDs of the target resources of the specified <code>ResourceType</code>, as defined in the import template.</p>
        pub fn set_logical_resource_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.logical_resource_ids = input;
            self
        }
        /// Appends an item to `resource_identifiers`.
        ///
        /// To override the contents of this collection use [`set_resource_identifiers`](Self::set_resource_identifiers).
        ///
        /// <p>The resource properties you can provide during the import to identify your target resources. For example, <code>BucketName</code> is a possible identifier property for <code>AWS::S3::Bucket</code> resources.</p>
        pub fn resource_identifiers(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.resource_identifiers.unwrap_or_default();
            v.push(input.into());
            self.resource_identifiers = Some(v);
            self
        }
        /// <p>The resource properties you can provide during the import to identify your target resources. For example, <code>BucketName</code> is a possible identifier property for <code>AWS::S3::Bucket</code> resources.</p>
        pub fn set_resource_identifiers(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.resource_identifiers = input;
            self
        }
        /// Consumes the builder and constructs a [`ResourceIdentifierSummary`](crate::model::ResourceIdentifierSummary)
        pub fn build(self) -> crate::model::ResourceIdentifierSummary {
            crate::model::ResourceIdentifierSummary {
                resource_type: self.resource_type,
                logical_resource_ids: self.logical_resource_ids,
                resource_identifiers: self.resource_identifiers,
            }
        }
    }
}
impl ResourceIdentifierSummary {
    /// Creates a new builder-style object to manufacture [`ResourceIdentifierSummary`](crate::model::ResourceIdentifierSummary)
    pub fn builder() -> crate::model::resource_identifier_summary::Builder {
        crate::model::resource_identifier_summary::Builder::default()
    }
}

/// <p>The ParameterDeclaration data type.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ParameterDeclaration {
    /// <p>The name that is associated with the parameter.</p>
    pub parameter_key: std::option::Option<std::string::String>,
    /// <p>The default value of the parameter.</p>
    pub default_value: std::option::Option<std::string::String>,
    /// <p>The type of parameter.</p>
    pub parameter_type: std::option::Option<std::string::String>,
    /// <p>Flag that indicates whether the parameter value is shown as plain text in logs and in the Amazon Web Services Management Console.</p>
    pub no_echo: std::option::Option<bool>,
    /// <p>The description that is associate with the parameter.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The criteria that CloudFormation uses to validate parameter values.</p>
    pub parameter_constraints: std::option::Option<crate::model::ParameterConstraints>,
}
impl ParameterDeclaration {
    /// <p>The name that is associated with the parameter.</p>
    pub fn parameter_key(&self) -> std::option::Option<&str> {
        self.parameter_key.as_deref()
    }
    /// <p>The default value of the parameter.</p>
    pub fn default_value(&self) -> std::option::Option<&str> {
        self.default_value.as_deref()
    }
    /// <p>The type of parameter.</p>
    pub fn parameter_type(&self) -> std::option::Option<&str> {
        self.parameter_type.as_deref()
    }
    /// <p>Flag that indicates whether the parameter value is shown as plain text in logs and in the Amazon Web Services Management Console.</p>
    pub fn no_echo(&self) -> std::option::Option<bool> {
        self.no_echo
    }
    /// <p>The description that is associate with the parameter.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The criteria that CloudFormation uses to validate parameter values.</p>
    pub fn parameter_constraints(
        &self,
    ) -> std::option::Option<&crate::model::ParameterConstraints> {
        self.parameter_constraints.as_ref()
    }
}
impl std::fmt::Debug for ParameterDeclaration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ParameterDeclaration");
        formatter.field("parameter_key", &self.parameter_key);
        formatter.field("default_value", &self.default_value);
        formatter.field("parameter_type", &self.parameter_type);
        formatter.field("no_echo", &self.no_echo);
        formatter.field("description", &self.description);
        formatter.field("parameter_constraints", &self.parameter_constraints);
        formatter.finish()
    }
}
/// See [`ParameterDeclaration`](crate::model::ParameterDeclaration)
pub mod parameter_declaration {
    /// A builder for [`ParameterDeclaration`](crate::model::ParameterDeclaration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) parameter_key: std::option::Option<std::string::String>,
        pub(crate) default_value: std::option::Option<std::string::String>,
        pub(crate) parameter_type: std::option::Option<std::string::String>,
        pub(crate) no_echo: std::option::Option<bool>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) parameter_constraints: std::option::Option<crate::model::ParameterConstraints>,
    }
    impl Builder {
        /// <p>The name that is associated with the parameter.</p>
        pub fn parameter_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.parameter_key = Some(input.into());
            self
        }
        /// <p>The name that is associated with the parameter.</p>
        pub fn set_parameter_key(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.parameter_key = input;
            self
        }
        /// <p>The default value of the parameter.</p>
        pub fn default_value(mut self, input: impl Into<std::string::String>) -> Self {
            self.default_value = Some(input.into());
            self
        }
        /// <p>The default value of the parameter.</p>
        pub fn set_default_value(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.default_value = input;
            self
        }
        /// <p>The type of parameter.</p>
        pub fn parameter_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.parameter_type = Some(input.into());
            self
        }
        /// <p>The type of parameter.</p>
        pub fn set_parameter_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.parameter_type = input;
            self
        }
        /// <p>Flag that indicates whether the parameter value is shown as plain text in logs and in the Amazon Web Services Management Console.</p>
        pub fn no_echo(mut self, input: bool) -> Self {
            self.no_echo = Some(input);
            self
        }
        /// <p>Flag that indicates whether the parameter value is shown as plain text in logs and in the Amazon Web Services Management Console.</p>
        pub fn set_no_echo(mut self, input: std::option::Option<bool>) -> Self {
            self.no_echo = input;
            self
        }
        /// <p>The description that is associate with the parameter.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description that is associate with the parameter.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The criteria that CloudFormation uses to validate parameter values.</p>
        pub fn parameter_constraints(mut self, input: crate::model::ParameterConstraints) -> Self {
            self.parameter_constraints = Some(input);
            self
        }
        /// <p>The criteria that CloudFormation uses to validate parameter values.</p>
        pub fn set_parameter_constraints(
            mut self,
            input: std::option::Option<crate::model::ParameterConstraints>,
        ) -> Self {
            self.parameter_constraints = input;
            self
        }
        /// Consumes the builder and constructs a [`ParameterDeclaration`](crate::model::ParameterDeclaration)
        pub fn build(self) -> crate::model::ParameterDeclaration {
            crate::model::ParameterDeclaration {
                parameter_key: self.parameter_key,
                default_value: self.default_value,
                parameter_type: self.parameter_type,
                no_echo: self.no_echo,
                description: self.description,
                parameter_constraints: self.parameter_constraints,
            }
        }
    }
}
impl ParameterDeclaration {
    /// Creates a new builder-style object to manufacture [`ParameterDeclaration`](crate::model::ParameterDeclaration)
    pub fn builder() -> crate::model::parameter_declaration::Builder {
        crate::model::parameter_declaration::Builder::default()
    }
}

/// <p>A set of criteria that CloudFormation uses to validate parameter values. Although other constraints might be defined in the stack template, CloudFormation returns only the <code>AllowedValues</code> property.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ParameterConstraints {
    /// <p>A list of values that are permitted for a parameter.</p>
    pub allowed_values: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl ParameterConstraints {
    /// <p>A list of values that are permitted for a parameter.</p>
    pub fn allowed_values(&self) -> std::option::Option<&[std::string::String]> {
        self.allowed_values.as_deref()
    }
}
impl std::fmt::Debug for ParameterConstraints {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ParameterConstraints");
        formatter.field("allowed_values", &self.allowed_values);
        formatter.finish()
    }
}
/// See [`ParameterConstraints`](crate::model::ParameterConstraints)
pub mod parameter_constraints {
    /// A builder for [`ParameterConstraints`](crate::model::ParameterConstraints)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) allowed_values: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// Appends an item to `allowed_values`.
        ///
        /// To override the contents of this collection use [`set_allowed_values`](Self::set_allowed_values).
        ///
        /// <p>A list of values that are permitted for a parameter.</p>
        pub fn allowed_values(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.allowed_values.unwrap_or_default();
            v.push(input.into());
            self.allowed_values = Some(v);
            self
        }
        /// <p>A list of values that are permitted for a parameter.</p>
        pub fn set_allowed_values(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.allowed_values = input;
            self
        }
        /// Consumes the builder and constructs a [`ParameterConstraints`](crate::model::ParameterConstraints)
        pub fn build(self) -> crate::model::ParameterConstraints {
            crate::model::ParameterConstraints {
                allowed_values: self.allowed_values,
            }
        }
    }
}
impl ParameterConstraints {
    /// Creates a new builder-style object to manufacture [`ParameterConstraints`](crate::model::ParameterConstraints)
    pub fn builder() -> crate::model::parameter_constraints::Builder {
        crate::model::parameter_constraints::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum TemplateStage {
    #[allow(missing_docs)] // documentation missing in model
    Original,
    #[allow(missing_docs)] // documentation missing in model
    Processed,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for TemplateStage {
    fn from(s: &str) -> Self {
        match s {
            "Original" => TemplateStage::Original,
            "Processed" => TemplateStage::Processed,
            other => TemplateStage::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for TemplateStage {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(TemplateStage::from(s))
    }
}
impl TemplateStage {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            TemplateStage::Original => "Original",
            TemplateStage::Processed => "Processed",
            TemplateStage::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["Original", "Processed"]
    }
}
impl AsRef<str> for TemplateStage {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Contains the drift information for a resource that has been checked for drift. This includes actual and expected property values for resources in which CloudFormation has detected drift. Only resource properties explicitly defined in the stack template are checked for drift. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-stack-drift.html">Detecting Unregulated Configuration Changes to Stacks and Resources</a>.</p>
/// <p>Resources that do not currently support drift detection cannot be checked. For a list of resources that support drift detection, see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-stack-drift-resource-list.html">Resources that Support Drift Detection</a>.</p>
/// <p>Use <code>DetectStackResourceDrift</code> to detect drift on individual resources, or <code>DetectStackDrift</code> to detect drift on all resources in a given stack that support drift detection.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StackResourceDrift {
    /// <p>The ID of the stack.</p>
    pub stack_id: std::option::Option<std::string::String>,
    /// <p>The logical name of the resource specified in the template.</p>
    pub logical_resource_id: std::option::Option<std::string::String>,
    /// <p>The name or unique identifier that corresponds to a physical instance ID of a resource supported by CloudFormation. </p>
    pub physical_resource_id: std::option::Option<std::string::String>,
    /// <p>Context information that enables CloudFormation to uniquely identify a resource. CloudFormation uses context key-value pairs in cases where a resource's logical and physical IDs are not enough to uniquely identify that resource. Each context key-value pair specifies a unique resource that contains the targeted resource.</p>
    pub physical_resource_id_context:
        std::option::Option<std::vec::Vec<crate::model::PhysicalResourceIdContextKeyValuePair>>,
    /// <p>The type of the resource.</p>
    pub resource_type: std::option::Option<std::string::String>,
    /// <p>A JSON structure containing the expected property values of the stack resource, as defined in the stack template and any values specified as template parameters. </p>
    /// <p>For resources whose <code>StackResourceDriftStatus</code> is <code>DELETED</code>, this structure will not be present. </p>
    pub expected_properties: std::option::Option<std::string::String>,
    /// <p>A JSON structure containing the actual property values of the stack resource.</p>
    /// <p>For resources whose <code>StackResourceDriftStatus</code> is <code>DELETED</code>, this structure will not be present. </p>
    pub actual_properties: std::option::Option<std::string::String>,
    /// <p>A collection of the resource properties whose actual values differ from their expected values. These will be present only for resources whose <code>StackResourceDriftStatus</code> is <code>MODIFIED</code>. </p>
    pub property_differences: std::option::Option<std::vec::Vec<crate::model::PropertyDifference>>,
    /// <p>Status of the resource's actual configuration compared to its expected configuration</p>
    /// <ul>
    /// <li> <p> <code>DELETED</code>: The resource differs from its expected template configuration because the resource has been deleted.</p> </li>
    /// <li> <p> <code>MODIFIED</code>: One or more resource properties differ from their expected values (as defined in the stack template and any values specified as template parameters).</p> </li>
    /// <li> <p> <code>IN_SYNC</code>: The resources's actual configuration matches its expected template configuration.</p> </li>
    /// <li> <p> <code>NOT_CHECKED</code>: CloudFormation does not currently return this value.</p> </li>
    /// </ul>
    pub stack_resource_drift_status: std::option::Option<crate::model::StackResourceDriftStatus>,
    /// <p>Time at which CloudFormation performed drift detection on the stack resource.</p>
    pub timestamp: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>Contains information about the module from which the resource was created, if the resource was created from a module included in the stack template.</p>
    pub module_info: std::option::Option<crate::model::ModuleInfo>,
}
impl StackResourceDrift {
    /// <p>The ID of the stack.</p>
    pub fn stack_id(&self) -> std::option::Option<&str> {
        self.stack_id.as_deref()
    }
    /// <p>The logical name of the resource specified in the template.</p>
    pub fn logical_resource_id(&self) -> std::option::Option<&str> {
        self.logical_resource_id.as_deref()
    }
    /// <p>The name or unique identifier that corresponds to a physical instance ID of a resource supported by CloudFormation. </p>
    pub fn physical_resource_id(&self) -> std::option::Option<&str> {
        self.physical_resource_id.as_deref()
    }
    /// <p>Context information that enables CloudFormation to uniquely identify a resource. CloudFormation uses context key-value pairs in cases where a resource's logical and physical IDs are not enough to uniquely identify that resource. Each context key-value pair specifies a unique resource that contains the targeted resource.</p>
    pub fn physical_resource_id_context(
        &self,
    ) -> std::option::Option<&[crate::model::PhysicalResourceIdContextKeyValuePair]> {
        self.physical_resource_id_context.as_deref()
    }
    /// <p>The type of the resource.</p>
    pub fn resource_type(&self) -> std::option::Option<&str> {
        self.resource_type.as_deref()
    }
    /// <p>A JSON structure containing the expected property values of the stack resource, as defined in the stack template and any values specified as template parameters. </p>
    /// <p>For resources whose <code>StackResourceDriftStatus</code> is <code>DELETED</code>, this structure will not be present. </p>
    pub fn expected_properties(&self) -> std::option::Option<&str> {
        self.expected_properties.as_deref()
    }
    /// <p>A JSON structure containing the actual property values of the stack resource.</p>
    /// <p>For resources whose <code>StackResourceDriftStatus</code> is <code>DELETED</code>, this structure will not be present. </p>
    pub fn actual_properties(&self) -> std::option::Option<&str> {
        self.actual_properties.as_deref()
    }
    /// <p>A collection of the resource properties whose actual values differ from their expected values. These will be present only for resources whose <code>StackResourceDriftStatus</code> is <code>MODIFIED</code>. </p>
    pub fn property_differences(&self) -> std::option::Option<&[crate::model::PropertyDifference]> {
        self.property_differences.as_deref()
    }
    /// <p>Status of the resource's actual configuration compared to its expected configuration</p>
    /// <ul>
    /// <li> <p> <code>DELETED</code>: The resource differs from its expected template configuration because the resource has been deleted.</p> </li>
    /// <li> <p> <code>MODIFIED</code>: One or more resource properties differ from their expected values (as defined in the stack template and any values specified as template parameters).</p> </li>
    /// <li> <p> <code>IN_SYNC</code>: The resources's actual configuration matches its expected template configuration.</p> </li>
    /// <li> <p> <code>NOT_CHECKED</code>: CloudFormation does not currently return this value.</p> </li>
    /// </ul>
    pub fn stack_resource_drift_status(
        &self,
    ) -> std::option::Option<&crate::model::StackResourceDriftStatus> {
        self.stack_resource_drift_status.as_ref()
    }
    /// <p>Time at which CloudFormation performed drift detection on the stack resource.</p>
    pub fn timestamp(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.timestamp.as_ref()
    }
    /// <p>Contains information about the module from which the resource was created, if the resource was created from a module included in the stack template.</p>
    pub fn module_info(&self) -> std::option::Option<&crate::model::ModuleInfo> {
        self.module_info.as_ref()
    }
}
impl std::fmt::Debug for StackResourceDrift {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StackResourceDrift");
        formatter.field("stack_id", &self.stack_id);
        formatter.field("logical_resource_id", &self.logical_resource_id);
        formatter.field("physical_resource_id", &self.physical_resource_id);
        formatter.field(
            "physical_resource_id_context",
            &self.physical_resource_id_context,
        );
        formatter.field("resource_type", &self.resource_type);
        formatter.field("expected_properties", &self.expected_properties);
        formatter.field("actual_properties", &self.actual_properties);
        formatter.field("property_differences", &self.property_differences);
        formatter.field(
            "stack_resource_drift_status",
            &self.stack_resource_drift_status,
        );
        formatter.field("timestamp", &self.timestamp);
        formatter.field("module_info", &self.module_info);
        formatter.finish()
    }
}
/// See [`StackResourceDrift`](crate::model::StackResourceDrift)
pub mod stack_resource_drift {
    /// A builder for [`StackResourceDrift`](crate::model::StackResourceDrift)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) stack_id: std::option::Option<std::string::String>,
        pub(crate) logical_resource_id: std::option::Option<std::string::String>,
        pub(crate) physical_resource_id: std::option::Option<std::string::String>,
        pub(crate) physical_resource_id_context:
            std::option::Option<std::vec::Vec<crate::model::PhysicalResourceIdContextKeyValuePair>>,
        pub(crate) resource_type: std::option::Option<std::string::String>,
        pub(crate) expected_properties: std::option::Option<std::string::String>,
        pub(crate) actual_properties: std::option::Option<std::string::String>,
        pub(crate) property_differences:
            std::option::Option<std::vec::Vec<crate::model::PropertyDifference>>,
        pub(crate) stack_resource_drift_status:
            std::option::Option<crate::model::StackResourceDriftStatus>,
        pub(crate) timestamp: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) module_info: std::option::Option<crate::model::ModuleInfo>,
    }
    impl Builder {
        /// <p>The ID of the stack.</p>
        pub fn stack_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.stack_id = Some(input.into());
            self
        }
        /// <p>The ID of the stack.</p>
        pub fn set_stack_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.stack_id = input;
            self
        }
        /// <p>The logical name of the resource specified in the template.</p>
        pub fn logical_resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.logical_resource_id = Some(input.into());
            self
        }
        /// <p>The logical name of the resource specified in the template.</p>
        pub fn set_logical_resource_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.logical_resource_id = input;
            self
        }
        /// <p>The name or unique identifier that corresponds to a physical instance ID of a resource supported by CloudFormation. </p>
        pub fn physical_resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.physical_resource_id = Some(input.into());
            self
        }
        /// <p>The name or unique identifier that corresponds to a physical instance ID of a resource supported by CloudFormation. </p>
        pub fn set_physical_resource_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.physical_resource_id = input;
            self
        }
        /// Appends an item to `physical_resource_id_context`.
        ///
        /// To override the contents of this collection use [`set_physical_resource_id_context`](Self::set_physical_resource_id_context).
        ///
        /// <p>Context information that enables CloudFormation to uniquely identify a resource. CloudFormation uses context key-value pairs in cases where a resource's logical and physical IDs are not enough to uniquely identify that resource. Each context key-value pair specifies a unique resource that contains the targeted resource.</p>
        pub fn physical_resource_id_context(
            mut self,
            input: crate::model::PhysicalResourceIdContextKeyValuePair,
        ) -> Self {
            let mut v = self.physical_resource_id_context.unwrap_or_default();
            v.push(input);
            self.physical_resource_id_context = Some(v);
            self
        }
        /// <p>Context information that enables CloudFormation to uniquely identify a resource. CloudFormation uses context key-value pairs in cases where a resource's logical and physical IDs are not enough to uniquely identify that resource. Each context key-value pair specifies a unique resource that contains the targeted resource.</p>
        pub fn set_physical_resource_id_context(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::PhysicalResourceIdContextKeyValuePair>,
            >,
        ) -> Self {
            self.physical_resource_id_context = input;
            self
        }
        /// <p>The type of the resource.</p>
        pub fn resource_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_type = Some(input.into());
            self
        }
        /// <p>The type of the resource.</p>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_type = input;
            self
        }
        /// <p>A JSON structure containing the expected property values of the stack resource, as defined in the stack template and any values specified as template parameters. </p>
        /// <p>For resources whose <code>StackResourceDriftStatus</code> is <code>DELETED</code>, this structure will not be present. </p>
        pub fn expected_properties(mut self, input: impl Into<std::string::String>) -> Self {
            self.expected_properties = Some(input.into());
            self
        }
        /// <p>A JSON structure containing the expected property values of the stack resource, as defined in the stack template and any values specified as template parameters. </p>
        /// <p>For resources whose <code>StackResourceDriftStatus</code> is <code>DELETED</code>, this structure will not be present. </p>
        pub fn set_expected_properties(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.expected_properties = input;
            self
        }
        /// <p>A JSON structure containing the actual property values of the stack resource.</p>
        /// <p>For resources whose <code>StackResourceDriftStatus</code> is <code>DELETED</code>, this structure will not be present. </p>
        pub fn actual_properties(mut self, input: impl Into<std::string::String>) -> Self {
            self.actual_properties = Some(input.into());
            self
        }
        /// <p>A JSON structure containing the actual property values of the stack resource.</p>
        /// <p>For resources whose <code>StackResourceDriftStatus</code> is <code>DELETED</code>, this structure will not be present. </p>
        pub fn set_actual_properties(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.actual_properties = input;
            self
        }
        /// Appends an item to `property_differences`.
        ///
        /// To override the contents of this collection use [`set_property_differences`](Self::set_property_differences).
        ///
        /// <p>A collection of the resource properties whose actual values differ from their expected values. These will be present only for resources whose <code>StackResourceDriftStatus</code> is <code>MODIFIED</code>. </p>
        pub fn property_differences(mut self, input: crate::model::PropertyDifference) -> Self {
            let mut v = self.property_differences.unwrap_or_default();
            v.push(input);
            self.property_differences = Some(v);
            self
        }
        /// <p>A collection of the resource properties whose actual values differ from their expected values. These will be present only for resources whose <code>StackResourceDriftStatus</code> is <code>MODIFIED</code>. </p>
        pub fn set_property_differences(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PropertyDifference>>,
        ) -> Self {
            self.property_differences = input;
            self
        }
        /// <p>Status of the resource's actual configuration compared to its expected configuration</p>
        /// <ul>
        /// <li> <p> <code>DELETED</code>: The resource differs from its expected template configuration because the resource has been deleted.</p> </li>
        /// <li> <p> <code>MODIFIED</code>: One or more resource properties differ from their expected values (as defined in the stack template and any values specified as template parameters).</p> </li>
        /// <li> <p> <code>IN_SYNC</code>: The resources's actual configuration matches its expected template configuration.</p> </li>
        /// <li> <p> <code>NOT_CHECKED</code>: CloudFormation does not currently return this value.</p> </li>
        /// </ul>
        pub fn stack_resource_drift_status(
            mut self,
            input: crate::model::StackResourceDriftStatus,
        ) -> Self {
            self.stack_resource_drift_status = Some(input);
            self
        }
        /// <p>Status of the resource's actual configuration compared to its expected configuration</p>
        /// <ul>
        /// <li> <p> <code>DELETED</code>: The resource differs from its expected template configuration because the resource has been deleted.</p> </li>
        /// <li> <p> <code>MODIFIED</code>: One or more resource properties differ from their expected values (as defined in the stack template and any values specified as template parameters).</p> </li>
        /// <li> <p> <code>IN_SYNC</code>: The resources's actual configuration matches its expected template configuration.</p> </li>
        /// <li> <p> <code>NOT_CHECKED</code>: CloudFormation does not currently return this value.</p> </li>
        /// </ul>
        pub fn set_stack_resource_drift_status(
            mut self,
            input: std::option::Option<crate::model::StackResourceDriftStatus>,
        ) -> Self {
            self.stack_resource_drift_status = input;
            self
        }
        /// <p>Time at which CloudFormation performed drift detection on the stack resource.</p>
        pub fn timestamp(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.timestamp = Some(input);
            self
        }
        /// <p>Time at which CloudFormation performed drift detection on the stack resource.</p>
        pub fn set_timestamp(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.timestamp = input;
            self
        }
        /// <p>Contains information about the module from which the resource was created, if the resource was created from a module included in the stack template.</p>
        pub fn module_info(mut self, input: crate::model::ModuleInfo) -> Self {
            self.module_info = Some(input);
            self
        }
        /// <p>Contains information about the module from which the resource was created, if the resource was created from a module included in the stack template.</p>
        pub fn set_module_info(
            mut self,
            input: std::option::Option<crate::model::ModuleInfo>,
        ) -> Self {
            self.module_info = input;
            self
        }
        /// Consumes the builder and constructs a [`StackResourceDrift`](crate::model::StackResourceDrift)
        pub fn build(self) -> crate::model::StackResourceDrift {
            crate::model::StackResourceDrift {
                stack_id: self.stack_id,
                logical_resource_id: self.logical_resource_id,
                physical_resource_id: self.physical_resource_id,
                physical_resource_id_context: self.physical_resource_id_context,
                resource_type: self.resource_type,
                expected_properties: self.expected_properties,
                actual_properties: self.actual_properties,
                property_differences: self.property_differences,
                stack_resource_drift_status: self.stack_resource_drift_status,
                timestamp: self.timestamp,
                module_info: self.module_info,
            }
        }
    }
}
impl StackResourceDrift {
    /// Creates a new builder-style object to manufacture [`StackResourceDrift`](crate::model::StackResourceDrift)
    pub fn builder() -> crate::model::stack_resource_drift::Builder {
        crate::model::stack_resource_drift::Builder::default()
    }
}

/// <p>Information about a resource property whose actual value differs from its expected value, as defined in the stack template and any values specified as template parameters. These will be present only for resources whose <code>StackResourceDriftStatus</code> is <code>MODIFIED</code>. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-stack-drift.html">Detecting Unregulated Configuration Changes to Stacks and Resources</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PropertyDifference {
    /// <p>The fully-qualified path to the resource property.</p>
    pub property_path: std::option::Option<std::string::String>,
    /// <p>The expected property value of the resource property, as defined in the stack template and any values specified as template parameters.</p>
    pub expected_value: std::option::Option<std::string::String>,
    /// <p>The actual property value of the resource property.</p>
    pub actual_value: std::option::Option<std::string::String>,
    /// <p>The type of property difference.</p>
    /// <ul>
    /// <li> <p> <code>ADD</code>: A value has been added to a resource property that is an array or list data type.</p> </li>
    /// <li> <p> <code>REMOVE</code>: The property has been removed from the current resource configuration.</p> </li>
    /// <li> <p> <code>NOT_EQUAL</code>: The current property value differs from its expected value (as defined in the stack template and any values specified as template parameters).</p> </li>
    /// </ul>
    pub difference_type: std::option::Option<crate::model::DifferenceType>,
}
impl PropertyDifference {
    /// <p>The fully-qualified path to the resource property.</p>
    pub fn property_path(&self) -> std::option::Option<&str> {
        self.property_path.as_deref()
    }
    /// <p>The expected property value of the resource property, as defined in the stack template and any values specified as template parameters.</p>
    pub fn expected_value(&self) -> std::option::Option<&str> {
        self.expected_value.as_deref()
    }
    /// <p>The actual property value of the resource property.</p>
    pub fn actual_value(&self) -> std::option::Option<&str> {
        self.actual_value.as_deref()
    }
    /// <p>The type of property difference.</p>
    /// <ul>
    /// <li> <p> <code>ADD</code>: A value has been added to a resource property that is an array or list data type.</p> </li>
    /// <li> <p> <code>REMOVE</code>: The property has been removed from the current resource configuration.</p> </li>
    /// <li> <p> <code>NOT_EQUAL</code>: The current property value differs from its expected value (as defined in the stack template and any values specified as template parameters).</p> </li>
    /// </ul>
    pub fn difference_type(&self) -> std::option::Option<&crate::model::DifferenceType> {
        self.difference_type.as_ref()
    }
}
impl std::fmt::Debug for PropertyDifference {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PropertyDifference");
        formatter.field("property_path", &self.property_path);
        formatter.field("expected_value", &self.expected_value);
        formatter.field("actual_value", &self.actual_value);
        formatter.field("difference_type", &self.difference_type);
        formatter.finish()
    }
}
/// See [`PropertyDifference`](crate::model::PropertyDifference)
pub mod property_difference {
    /// A builder for [`PropertyDifference`](crate::model::PropertyDifference)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) property_path: std::option::Option<std::string::String>,
        pub(crate) expected_value: std::option::Option<std::string::String>,
        pub(crate) actual_value: std::option::Option<std::string::String>,
        pub(crate) difference_type: std::option::Option<crate::model::DifferenceType>,
    }
    impl Builder {
        /// <p>The fully-qualified path to the resource property.</p>
        pub fn property_path(mut self, input: impl Into<std::string::String>) -> Self {
            self.property_path = Some(input.into());
            self
        }
        /// <p>The fully-qualified path to the resource property.</p>
        pub fn set_property_path(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.property_path = input;
            self
        }
        /// <p>The expected property value of the resource property, as defined in the stack template and any values specified as template parameters.</p>
        pub fn expected_value(mut self, input: impl Into<std::string::String>) -> Self {
            self.expected_value = Some(input.into());
            self
        }
        /// <p>The expected property value of the resource property, as defined in the stack template and any values specified as template parameters.</p>
        pub fn set_expected_value(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.expected_value = input;
            self
        }
        /// <p>The actual property value of the resource property.</p>
        pub fn actual_value(mut self, input: impl Into<std::string::String>) -> Self {
            self.actual_value = Some(input.into());
            self
        }
        /// <p>The actual property value of the resource property.</p>
        pub fn set_actual_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.actual_value = input;
            self
        }
        /// <p>The type of property difference.</p>
        /// <ul>
        /// <li> <p> <code>ADD</code>: A value has been added to a resource property that is an array or list data type.</p> </li>
        /// <li> <p> <code>REMOVE</code>: The property has been removed from the current resource configuration.</p> </li>
        /// <li> <p> <code>NOT_EQUAL</code>: The current property value differs from its expected value (as defined in the stack template and any values specified as template parameters).</p> </li>
        /// </ul>
        pub fn difference_type(mut self, input: crate::model::DifferenceType) -> Self {
            self.difference_type = Some(input);
            self
        }
        /// <p>The type of property difference.</p>
        /// <ul>
        /// <li> <p> <code>ADD</code>: A value has been added to a resource property that is an array or list data type.</p> </li>
        /// <li> <p> <code>REMOVE</code>: The property has been removed from the current resource configuration.</p> </li>
        /// <li> <p> <code>NOT_EQUAL</code>: The current property value differs from its expected value (as defined in the stack template and any values specified as template parameters).</p> </li>
        /// </ul>
        pub fn set_difference_type(
            mut self,
            input: std::option::Option<crate::model::DifferenceType>,
        ) -> Self {
            self.difference_type = input;
            self
        }
        /// Consumes the builder and constructs a [`PropertyDifference`](crate::model::PropertyDifference)
        pub fn build(self) -> crate::model::PropertyDifference {
            crate::model::PropertyDifference {
                property_path: self.property_path,
                expected_value: self.expected_value,
                actual_value: self.actual_value,
                difference_type: self.difference_type,
            }
        }
    }
}
impl PropertyDifference {
    /// Creates a new builder-style object to manufacture [`PropertyDifference`](crate::model::PropertyDifference)
    pub fn builder() -> crate::model::property_difference::Builder {
        crate::model::property_difference::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum DifferenceType {
    #[allow(missing_docs)] // documentation missing in model
    Add,
    #[allow(missing_docs)] // documentation missing in model
    NotEqual,
    #[allow(missing_docs)] // documentation missing in model
    Remove,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for DifferenceType {
    fn from(s: &str) -> Self {
        match s {
            "ADD" => DifferenceType::Add,
            "NOT_EQUAL" => DifferenceType::NotEqual,
            "REMOVE" => DifferenceType::Remove,
            other => DifferenceType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for DifferenceType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(DifferenceType::from(s))
    }
}
impl DifferenceType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            DifferenceType::Add => "ADD",
            DifferenceType::NotEqual => "NOT_EQUAL",
            DifferenceType::Remove => "REMOVE",
            DifferenceType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ADD", "NOT_EQUAL", "REMOVE"]
    }
}
impl AsRef<str> for DifferenceType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Context information that enables CloudFormation to uniquely identify a resource. CloudFormation uses context key-value pairs in cases where a resource's logical and physical IDs are not enough to uniquely identify that resource. Each context key-value pair specifies a resource that contains the targeted resource.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PhysicalResourceIdContextKeyValuePair {
    /// <p>The resource context key.</p>
    pub key: std::option::Option<std::string::String>,
    /// <p>The resource context value.</p>
    pub value: std::option::Option<std::string::String>,
}
impl PhysicalResourceIdContextKeyValuePair {
    /// <p>The resource context key.</p>
    pub fn key(&self) -> std::option::Option<&str> {
        self.key.as_deref()
    }
    /// <p>The resource context value.</p>
    pub fn value(&self) -> std::option::Option<&str> {
        self.value.as_deref()
    }
}
impl std::fmt::Debug for PhysicalResourceIdContextKeyValuePair {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PhysicalResourceIdContextKeyValuePair");
        formatter.field("key", &self.key);
        formatter.field("value", &self.value);
        formatter.finish()
    }
}
/// See [`PhysicalResourceIdContextKeyValuePair`](crate::model::PhysicalResourceIdContextKeyValuePair)
pub mod physical_resource_id_context_key_value_pair {
    /// A builder for [`PhysicalResourceIdContextKeyValuePair`](crate::model::PhysicalResourceIdContextKeyValuePair)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) key: std::option::Option<std::string::String>,
        pub(crate) value: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The resource context key.</p>
        pub fn key(mut self, input: impl Into<std::string::String>) -> Self {
            self.key = Some(input.into());
            self
        }
        /// <p>The resource context key.</p>
        pub fn set_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key = input;
            self
        }
        /// <p>The resource context value.</p>
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            self.value = Some(input.into());
            self
        }
        /// <p>The resource context value.</p>
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.value = input;
            self
        }
        /// Consumes the builder and constructs a [`PhysicalResourceIdContextKeyValuePair`](crate::model::PhysicalResourceIdContextKeyValuePair)
        pub fn build(self) -> crate::model::PhysicalResourceIdContextKeyValuePair {
            crate::model::PhysicalResourceIdContextKeyValuePair {
                key: self.key,
                value: self.value,
            }
        }
    }
}
impl PhysicalResourceIdContextKeyValuePair {
    /// Creates a new builder-style object to manufacture [`PhysicalResourceIdContextKeyValuePair`](crate::model::PhysicalResourceIdContextKeyValuePair)
    pub fn builder() -> crate::model::physical_resource_id_context_key_value_pair::Builder {
        crate::model::physical_resource_id_context_key_value_pair::Builder::default()
    }
}

/// <p>For extensions that are modules, a public third-party extension that must be activated in your account in order for the module itself to be activated.</p>
/// <p>For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/modules.html#module-enabling">Activating public modules for use in your account</a> in the <i>CloudFormation User Guide</i>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RequiredActivatedType {
    /// <p>An alias assigned to the public extension, in this account and region. If you specify an alias for the extension, CloudFormation treats the alias as the extension type name within this account and region. You must use the alias to refer to the extension in your templates, API calls, and CloudFormation console.</p>
    pub type_name_alias: std::option::Option<std::string::String>,
    /// <p>The type name of the public extension.</p>
    /// <p>If you specified a <code>TypeNameAlias</code> when enabling the extension in this account and region, CloudFormation treats that alias as the extension's type name within the account and region, not the type name of the public extension. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/registry-public.html#registry-public-enable-alias">Specifying aliases to refer to extensions</a> in the <i>CloudFormation User Guide</i>.</p>
    pub original_type_name: std::option::Option<std::string::String>,
    /// <p>The publisher ID of the extension publisher.</p>
    pub publisher_id: std::option::Option<std::string::String>,
    /// <p>A list of the major versions of the extension type that the macro supports.</p>
    pub supported_major_versions: std::option::Option<std::vec::Vec<i32>>,
}
impl RequiredActivatedType {
    /// <p>An alias assigned to the public extension, in this account and region. If you specify an alias for the extension, CloudFormation treats the alias as the extension type name within this account and region. You must use the alias to refer to the extension in your templates, API calls, and CloudFormation console.</p>
    pub fn type_name_alias(&self) -> std::option::Option<&str> {
        self.type_name_alias.as_deref()
    }
    /// <p>The type name of the public extension.</p>
    /// <p>If you specified a <code>TypeNameAlias</code> when enabling the extension in this account and region, CloudFormation treats that alias as the extension's type name within the account and region, not the type name of the public extension. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/registry-public.html#registry-public-enable-alias">Specifying aliases to refer to extensions</a> in the <i>CloudFormation User Guide</i>.</p>
    pub fn original_type_name(&self) -> std::option::Option<&str> {
        self.original_type_name.as_deref()
    }
    /// <p>The publisher ID of the extension publisher.</p>
    pub fn publisher_id(&self) -> std::option::Option<&str> {
        self.publisher_id.as_deref()
    }
    /// <p>A list of the major versions of the extension type that the macro supports.</p>
    pub fn supported_major_versions(&self) -> std::option::Option<&[i32]> {
        self.supported_major_versions.as_deref()
    }
}
impl std::fmt::Debug for RequiredActivatedType {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RequiredActivatedType");
        formatter.field("type_name_alias", &self.type_name_alias);
        formatter.field("original_type_name", &self.original_type_name);
        formatter.field("publisher_id", &self.publisher_id);
        formatter.field("supported_major_versions", &self.supported_major_versions);
        formatter.finish()
    }
}
/// See [`RequiredActivatedType`](crate::model::RequiredActivatedType)
pub mod required_activated_type {
    /// A builder for [`RequiredActivatedType`](crate::model::RequiredActivatedType)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) type_name_alias: std::option::Option<std::string::String>,
        pub(crate) original_type_name: std::option::Option<std::string::String>,
        pub(crate) publisher_id: std::option::Option<std::string::String>,
        pub(crate) supported_major_versions: std::option::Option<std::vec::Vec<i32>>,
    }
    impl Builder {
        /// <p>An alias assigned to the public extension, in this account and region. If you specify an alias for the extension, CloudFormation treats the alias as the extension type name within this account and region. You must use the alias to refer to the extension in your templates, API calls, and CloudFormation console.</p>
        pub fn type_name_alias(mut self, input: impl Into<std::string::String>) -> Self {
            self.type_name_alias = Some(input.into());
            self
        }
        /// <p>An alias assigned to the public extension, in this account and region. If you specify an alias for the extension, CloudFormation treats the alias as the extension type name within this account and region. You must use the alias to refer to the extension in your templates, API calls, and CloudFormation console.</p>
        pub fn set_type_name_alias(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.type_name_alias = input;
            self
        }
        /// <p>The type name of the public extension.</p>
        /// <p>If you specified a <code>TypeNameAlias</code> when enabling the extension in this account and region, CloudFormation treats that alias as the extension's type name within the account and region, not the type name of the public extension. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/registry-public.html#registry-public-enable-alias">Specifying aliases to refer to extensions</a> in the <i>CloudFormation User Guide</i>.</p>
        pub fn original_type_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.original_type_name = Some(input.into());
            self
        }
        /// <p>The type name of the public extension.</p>
        /// <p>If you specified a <code>TypeNameAlias</code> when enabling the extension in this account and region, CloudFormation treats that alias as the extension's type name within the account and region, not the type name of the public extension. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/registry-public.html#registry-public-enable-alias">Specifying aliases to refer to extensions</a> in the <i>CloudFormation User Guide</i>.</p>
        pub fn set_original_type_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.original_type_name = input;
            self
        }
        /// <p>The publisher ID of the extension publisher.</p>
        pub fn publisher_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.publisher_id = Some(input.into());
            self
        }
        /// <p>The publisher ID of the extension publisher.</p>
        pub fn set_publisher_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.publisher_id = input;
            self
        }
        /// Appends an item to `supported_major_versions`.
        ///
        /// To override the contents of this collection use [`set_supported_major_versions`](Self::set_supported_major_versions).
        ///
        /// <p>A list of the major versions of the extension type that the macro supports.</p>
        pub fn supported_major_versions(mut self, input: i32) -> Self {
            let mut v = self.supported_major_versions.unwrap_or_default();
            v.push(input);
            self.supported_major_versions = Some(v);
            self
        }
        /// <p>A list of the major versions of the extension type that the macro supports.</p>
        pub fn set_supported_major_versions(
            mut self,
            input: std::option::Option<std::vec::Vec<i32>>,
        ) -> Self {
            self.supported_major_versions = input;
            self
        }
        /// Consumes the builder and constructs a [`RequiredActivatedType`](crate::model::RequiredActivatedType)
        pub fn build(self) -> crate::model::RequiredActivatedType {
            crate::model::RequiredActivatedType {
                type_name_alias: self.type_name_alias,
                original_type_name: self.original_type_name,
                publisher_id: self.publisher_id,
                supported_major_versions: self.supported_major_versions,
            }
        }
    }
}
impl RequiredActivatedType {
    /// Creates a new builder-style object to manufacture [`RequiredActivatedType`](crate::model::RequiredActivatedType)
    pub fn builder() -> crate::model::required_activated_type::Builder {
        crate::model::required_activated_type::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum TypeTestsStatus {
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    #[allow(missing_docs)] // documentation missing in model
    InProgress,
    #[allow(missing_docs)] // documentation missing in model
    NotTested,
    #[allow(missing_docs)] // documentation missing in model
    Passed,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for TypeTestsStatus {
    fn from(s: &str) -> Self {
        match s {
            "FAILED" => TypeTestsStatus::Failed,
            "IN_PROGRESS" => TypeTestsStatus::InProgress,
            "NOT_TESTED" => TypeTestsStatus::NotTested,
            "PASSED" => TypeTestsStatus::Passed,
            other => TypeTestsStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for TypeTestsStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(TypeTestsStatus::from(s))
    }
}
impl TypeTestsStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            TypeTestsStatus::Failed => "FAILED",
            TypeTestsStatus::InProgress => "IN_PROGRESS",
            TypeTestsStatus::NotTested => "NOT_TESTED",
            TypeTestsStatus::Passed => "PASSED",
            TypeTestsStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["FAILED", "IN_PROGRESS", "NOT_TESTED", "PASSED"]
    }
}
impl AsRef<str> for TypeTestsStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The structure that contains information about a stack set operation. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StackSetOperation {
    /// <p>The unique ID of a stack set operation.</p>
    pub operation_id: std::option::Option<std::string::String>,
    /// <p>The ID of the stack set.</p>
    pub stack_set_id: std::option::Option<std::string::String>,
    /// <p>The type of stack set operation: <code>CREATE</code>, <code>UPDATE</code>, or <code>DELETE</code>. Create and delete operations affect only the specified stack set instances that are associated with the specified stack set. Update operations affect both the stack set itself, as well as <i>all</i> associated stack set instances.</p>
    pub action: std::option::Option<crate::model::StackSetOperationAction>,
    /// <p>The status of the operation. </p>
    /// <ul>
    /// <li> <p> <code>FAILED</code>: The operation exceeded the specified failure tolerance. The failure tolerance value that you've set for an operation is applied for each Region during stack create and update operations. If the number of failed stacks within a Region exceeds the failure tolerance, the status of the operation in the Region is set to <code>FAILED</code>. This in turn sets the status of the operation as a whole to <code>FAILED</code>, and CloudFormation cancels the operation in any remaining Regions.</p> </li>
    /// <li> <p> <code>QUEUED</code>: [Service-managed permissions] For automatic deployments that require a sequence of operations, the operation is queued to be performed. For more information, see the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-concepts.html#stackset-status-codes">stack set operation status codes</a> in the CloudFormation User Guide.</p> </li>
    /// <li> <p> <code>RUNNING</code>: The operation is currently being performed.</p> </li>
    /// <li> <p> <code>STOPPED</code>: The user has cancelled the operation.</p> </li>
    /// <li> <p> <code>STOPPING</code>: The operation is in the process of stopping, at user request. </p> </li>
    /// <li> <p> <code>SUCCEEDED</code>: The operation completed creating or updating all the specified stacks without exceeding the failure tolerance for the operation.</p> </li>
    /// </ul>
    pub status: std::option::Option<crate::model::StackSetOperationStatus>,
    /// <p>The preferences for how CloudFormation performs this stack set operation.</p>
    pub operation_preferences: std::option::Option<crate::model::StackSetOperationPreferences>,
    /// <p>For stack set operations of action type <code>DELETE</code>, specifies whether to remove the stack instances from the specified stack set, but doesn't delete the stacks. You can't reassociate a retained stack, or add an existing, saved stack to a new stack set.</p>
    pub retain_stacks: std::option::Option<bool>,
    /// <p>The Amazon Resource Number (ARN) of the IAM role used to perform this stack set operation. </p>
    /// <p>Use customized administrator roles to control which users or groups can manage specific stack sets within the same administrator account. For more information, see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-prereqs.html">Define Permissions for Multiple Administrators</a> in the <i>CloudFormation User Guide</i>.</p>
    pub administration_role_arn: std::option::Option<std::string::String>,
    /// <p>The name of the IAM execution role used to create or update the stack set.</p>
    /// <p>Use customized execution roles to control which stack resources users and groups can include in their stack sets. </p>
    pub execution_role_name: std::option::Option<std::string::String>,
    /// <p>The time at which the operation was initiated. Note that the creation times for the stack set operation might differ from the creation time of the individual stacks themselves. This is because CloudFormation needs to perform preparatory work for the operation, such as dispatching the work to the requested Regions, before actually creating the first stacks.</p>
    pub creation_timestamp: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The time at which the stack set operation ended, across all accounts and Regions specified. Note that this doesn't necessarily mean that the stack set operation was successful, or even attempted, in each account or Region.</p>
    pub end_timestamp: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>[Service-managed permissions] The Organizations accounts affected by the stack operation.</p>
    pub deployment_targets: std::option::Option<crate::model::DeploymentTargets>,
    /// <p>Detailed information about the drift status of the stack set. This includes information about drift operations currently being performed on the stack set.</p>
    /// <p>this information will only be present for stack set operations whose <code>Action</code> type is <code>DETECT_DRIFT</code>.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-drift.html">Detecting Unmanaged Changes in Stack Sets</a> in the CloudFormation User Guide.</p>
    pub stack_set_drift_detection_details:
        std::option::Option<crate::model::StackSetDriftDetectionDetails>,
}
impl StackSetOperation {
    /// <p>The unique ID of a stack set operation.</p>
    pub fn operation_id(&self) -> std::option::Option<&str> {
        self.operation_id.as_deref()
    }
    /// <p>The ID of the stack set.</p>
    pub fn stack_set_id(&self) -> std::option::Option<&str> {
        self.stack_set_id.as_deref()
    }
    /// <p>The type of stack set operation: <code>CREATE</code>, <code>UPDATE</code>, or <code>DELETE</code>. Create and delete operations affect only the specified stack set instances that are associated with the specified stack set. Update operations affect both the stack set itself, as well as <i>all</i> associated stack set instances.</p>
    pub fn action(&self) -> std::option::Option<&crate::model::StackSetOperationAction> {
        self.action.as_ref()
    }
    /// <p>The status of the operation. </p>
    /// <ul>
    /// <li> <p> <code>FAILED</code>: The operation exceeded the specified failure tolerance. The failure tolerance value that you've set for an operation is applied for each Region during stack create and update operations. If the number of failed stacks within a Region exceeds the failure tolerance, the status of the operation in the Region is set to <code>FAILED</code>. This in turn sets the status of the operation as a whole to <code>FAILED</code>, and CloudFormation cancels the operation in any remaining Regions.</p> </li>
    /// <li> <p> <code>QUEUED</code>: [Service-managed permissions] For automatic deployments that require a sequence of operations, the operation is queued to be performed. For more information, see the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-concepts.html#stackset-status-codes">stack set operation status codes</a> in the CloudFormation User Guide.</p> </li>
    /// <li> <p> <code>RUNNING</code>: The operation is currently being performed.</p> </li>
    /// <li> <p> <code>STOPPED</code>: The user has cancelled the operation.</p> </li>
    /// <li> <p> <code>STOPPING</code>: The operation is in the process of stopping, at user request. </p> </li>
    /// <li> <p> <code>SUCCEEDED</code>: The operation completed creating or updating all the specified stacks without exceeding the failure tolerance for the operation.</p> </li>
    /// </ul>
    pub fn status(&self) -> std::option::Option<&crate::model::StackSetOperationStatus> {
        self.status.as_ref()
    }
    /// <p>The preferences for how CloudFormation performs this stack set operation.</p>
    pub fn operation_preferences(
        &self,
    ) -> std::option::Option<&crate::model::StackSetOperationPreferences> {
        self.operation_preferences.as_ref()
    }
    /// <p>For stack set operations of action type <code>DELETE</code>, specifies whether to remove the stack instances from the specified stack set, but doesn't delete the stacks. You can't reassociate a retained stack, or add an existing, saved stack to a new stack set.</p>
    pub fn retain_stacks(&self) -> std::option::Option<bool> {
        self.retain_stacks
    }
    /// <p>The Amazon Resource Number (ARN) of the IAM role used to perform this stack set operation. </p>
    /// <p>Use customized administrator roles to control which users or groups can manage specific stack sets within the same administrator account. For more information, see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-prereqs.html">Define Permissions for Multiple Administrators</a> in the <i>CloudFormation User Guide</i>.</p>
    pub fn administration_role_arn(&self) -> std::option::Option<&str> {
        self.administration_role_arn.as_deref()
    }
    /// <p>The name of the IAM execution role used to create or update the stack set.</p>
    /// <p>Use customized execution roles to control which stack resources users and groups can include in their stack sets. </p>
    pub fn execution_role_name(&self) -> std::option::Option<&str> {
        self.execution_role_name.as_deref()
    }
    /// <p>The time at which the operation was initiated. Note that the creation times for the stack set operation might differ from the creation time of the individual stacks themselves. This is because CloudFormation needs to perform preparatory work for the operation, such as dispatching the work to the requested Regions, before actually creating the first stacks.</p>
    pub fn creation_timestamp(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.creation_timestamp.as_ref()
    }
    /// <p>The time at which the stack set operation ended, across all accounts and Regions specified. Note that this doesn't necessarily mean that the stack set operation was successful, or even attempted, in each account or Region.</p>
    pub fn end_timestamp(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.end_timestamp.as_ref()
    }
    /// <p>[Service-managed permissions] The Organizations accounts affected by the stack operation.</p>
    pub fn deployment_targets(&self) -> std::option::Option<&crate::model::DeploymentTargets> {
        self.deployment_targets.as_ref()
    }
    /// <p>Detailed information about the drift status of the stack set. This includes information about drift operations currently being performed on the stack set.</p>
    /// <p>this information will only be present for stack set operations whose <code>Action</code> type is <code>DETECT_DRIFT</code>.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-drift.html">Detecting Unmanaged Changes in Stack Sets</a> in the CloudFormation User Guide.</p>
    pub fn stack_set_drift_detection_details(
        &self,
    ) -> std::option::Option<&crate::model::StackSetDriftDetectionDetails> {
        self.stack_set_drift_detection_details.as_ref()
    }
}
impl std::fmt::Debug for StackSetOperation {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StackSetOperation");
        formatter.field("operation_id", &self.operation_id);
        formatter.field("stack_set_id", &self.stack_set_id);
        formatter.field("action", &self.action);
        formatter.field("status", &self.status);
        formatter.field("operation_preferences", &self.operation_preferences);
        formatter.field("retain_stacks", &self.retain_stacks);
        formatter.field("administration_role_arn", &self.administration_role_arn);
        formatter.field("execution_role_name", &self.execution_role_name);
        formatter.field("creation_timestamp", &self.creation_timestamp);
        formatter.field("end_timestamp", &self.end_timestamp);
        formatter.field("deployment_targets", &self.deployment_targets);
        formatter.field(
            "stack_set_drift_detection_details",
            &self.stack_set_drift_detection_details,
        );
        formatter.finish()
    }
}
/// See [`StackSetOperation`](crate::model::StackSetOperation)
pub mod stack_set_operation {
    /// A builder for [`StackSetOperation`](crate::model::StackSetOperation)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) operation_id: std::option::Option<std::string::String>,
        pub(crate) stack_set_id: std::option::Option<std::string::String>,
        pub(crate) action: std::option::Option<crate::model::StackSetOperationAction>,
        pub(crate) status: std::option::Option<crate::model::StackSetOperationStatus>,
        pub(crate) operation_preferences:
            std::option::Option<crate::model::StackSetOperationPreferences>,
        pub(crate) retain_stacks: std::option::Option<bool>,
        pub(crate) administration_role_arn: std::option::Option<std::string::String>,
        pub(crate) execution_role_name: std::option::Option<std::string::String>,
        pub(crate) creation_timestamp: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) end_timestamp: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) deployment_targets: std::option::Option<crate::model::DeploymentTargets>,
        pub(crate) stack_set_drift_detection_details:
            std::option::Option<crate::model::StackSetDriftDetectionDetails>,
    }
    impl Builder {
        /// <p>The unique ID of a stack set operation.</p>
        pub fn operation_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.operation_id = Some(input.into());
            self
        }
        /// <p>The unique ID of a stack set operation.</p>
        pub fn set_operation_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.operation_id = input;
            self
        }
        /// <p>The ID of the stack set.</p>
        pub fn stack_set_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.stack_set_id = Some(input.into());
            self
        }
        /// <p>The ID of the stack set.</p>
        pub fn set_stack_set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.stack_set_id = input;
            self
        }
        /// <p>The type of stack set operation: <code>CREATE</code>, <code>UPDATE</code>, or <code>DELETE</code>. Create and delete operations affect only the specified stack set instances that are associated with the specified stack set. Update operations affect both the stack set itself, as well as <i>all</i> associated stack set instances.</p>
        pub fn action(mut self, input: crate::model::StackSetOperationAction) -> Self {
            self.action = Some(input);
            self
        }
        /// <p>The type of stack set operation: <code>CREATE</code>, <code>UPDATE</code>, or <code>DELETE</code>. Create and delete operations affect only the specified stack set instances that are associated with the specified stack set. Update operations affect both the stack set itself, as well as <i>all</i> associated stack set instances.</p>
        pub fn set_action(
            mut self,
            input: std::option::Option<crate::model::StackSetOperationAction>,
        ) -> Self {
            self.action = input;
            self
        }
        /// <p>The status of the operation. </p>
        /// <ul>
        /// <li> <p> <code>FAILED</code>: The operation exceeded the specified failure tolerance. The failure tolerance value that you've set for an operation is applied for each Region during stack create and update operations. If the number of failed stacks within a Region exceeds the failure tolerance, the status of the operation in the Region is set to <code>FAILED</code>. This in turn sets the status of the operation as a whole to <code>FAILED</code>, and CloudFormation cancels the operation in any remaining Regions.</p> </li>
        /// <li> <p> <code>QUEUED</code>: [Service-managed permissions] For automatic deployments that require a sequence of operations, the operation is queued to be performed. For more information, see the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-concepts.html#stackset-status-codes">stack set operation status codes</a> in the CloudFormation User Guide.</p> </li>
        /// <li> <p> <code>RUNNING</code>: The operation is currently being performed.</p> </li>
        /// <li> <p> <code>STOPPED</code>: The user has cancelled the operation.</p> </li>
        /// <li> <p> <code>STOPPING</code>: The operation is in the process of stopping, at user request. </p> </li>
        /// <li> <p> <code>SUCCEEDED</code>: The operation completed creating or updating all the specified stacks without exceeding the failure tolerance for the operation.</p> </li>
        /// </ul>
        pub fn status(mut self, input: crate::model::StackSetOperationStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of the operation. </p>
        /// <ul>
        /// <li> <p> <code>FAILED</code>: The operation exceeded the specified failure tolerance. The failure tolerance value that you've set for an operation is applied for each Region during stack create and update operations. If the number of failed stacks within a Region exceeds the failure tolerance, the status of the operation in the Region is set to <code>FAILED</code>. This in turn sets the status of the operation as a whole to <code>FAILED</code>, and CloudFormation cancels the operation in any remaining Regions.</p> </li>
        /// <li> <p> <code>QUEUED</code>: [Service-managed permissions] For automatic deployments that require a sequence of operations, the operation is queued to be performed. For more information, see the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-concepts.html#stackset-status-codes">stack set operation status codes</a> in the CloudFormation User Guide.</p> </li>
        /// <li> <p> <code>RUNNING</code>: The operation is currently being performed.</p> </li>
        /// <li> <p> <code>STOPPED</code>: The user has cancelled the operation.</p> </li>
        /// <li> <p> <code>STOPPING</code>: The operation is in the process of stopping, at user request. </p> </li>
        /// <li> <p> <code>SUCCEEDED</code>: The operation completed creating or updating all the specified stacks without exceeding the failure tolerance for the operation.</p> </li>
        /// </ul>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::StackSetOperationStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>The preferences for how CloudFormation performs this stack set operation.</p>
        pub fn operation_preferences(
            mut self,
            input: crate::model::StackSetOperationPreferences,
        ) -> Self {
            self.operation_preferences = Some(input);
            self
        }
        /// <p>The preferences for how CloudFormation performs this stack set operation.</p>
        pub fn set_operation_preferences(
            mut self,
            input: std::option::Option<crate::model::StackSetOperationPreferences>,
        ) -> Self {
            self.operation_preferences = input;
            self
        }
        /// <p>For stack set operations of action type <code>DELETE</code>, specifies whether to remove the stack instances from the specified stack set, but doesn't delete the stacks. You can't reassociate a retained stack, or add an existing, saved stack to a new stack set.</p>
        pub fn retain_stacks(mut self, input: bool) -> Self {
            self.retain_stacks = Some(input);
            self
        }
        /// <p>For stack set operations of action type <code>DELETE</code>, specifies whether to remove the stack instances from the specified stack set, but doesn't delete the stacks. You can't reassociate a retained stack, or add an existing, saved stack to a new stack set.</p>
        pub fn set_retain_stacks(mut self, input: std::option::Option<bool>) -> Self {
            self.retain_stacks = input;
            self
        }
        /// <p>The Amazon Resource Number (ARN) of the IAM role used to perform this stack set operation. </p>
        /// <p>Use customized administrator roles to control which users or groups can manage specific stack sets within the same administrator account. For more information, see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-prereqs.html">Define Permissions for Multiple Administrators</a> in the <i>CloudFormation User Guide</i>.</p>
        pub fn administration_role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.administration_role_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Number (ARN) of the IAM role used to perform this stack set operation. </p>
        /// <p>Use customized administrator roles to control which users or groups can manage specific stack sets within the same administrator account. For more information, see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-prereqs.html">Define Permissions for Multiple Administrators</a> in the <i>CloudFormation User Guide</i>.</p>
        pub fn set_administration_role_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.administration_role_arn = input;
            self
        }
        /// <p>The name of the IAM execution role used to create or update the stack set.</p>
        /// <p>Use customized execution roles to control which stack resources users and groups can include in their stack sets. </p>
        pub fn execution_role_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.execution_role_name = Some(input.into());
            self
        }
        /// <p>The name of the IAM execution role used to create or update the stack set.</p>
        /// <p>Use customized execution roles to control which stack resources users and groups can include in their stack sets. </p>
        pub fn set_execution_role_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.execution_role_name = input;
            self
        }
        /// <p>The time at which the operation was initiated. Note that the creation times for the stack set operation might differ from the creation time of the individual stacks themselves. This is because CloudFormation needs to perform preparatory work for the operation, such as dispatching the work to the requested Regions, before actually creating the first stacks.</p>
        pub fn creation_timestamp(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.creation_timestamp = Some(input);
            self
        }
        /// <p>The time at which the operation was initiated. Note that the creation times for the stack set operation might differ from the creation time of the individual stacks themselves. This is because CloudFormation needs to perform preparatory work for the operation, such as dispatching the work to the requested Regions, before actually creating the first stacks.</p>
        pub fn set_creation_timestamp(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.creation_timestamp = input;
            self
        }
        /// <p>The time at which the stack set operation ended, across all accounts and Regions specified. Note that this doesn't necessarily mean that the stack set operation was successful, or even attempted, in each account or Region.</p>
        pub fn end_timestamp(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.end_timestamp = Some(input);
            self
        }
        /// <p>The time at which the stack set operation ended, across all accounts and Regions specified. Note that this doesn't necessarily mean that the stack set operation was successful, or even attempted, in each account or Region.</p>
        pub fn set_end_timestamp(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.end_timestamp = input;
            self
        }
        /// <p>[Service-managed permissions] The Organizations accounts affected by the stack operation.</p>
        pub fn deployment_targets(mut self, input: crate::model::DeploymentTargets) -> Self {
            self.deployment_targets = Some(input);
            self
        }
        /// <p>[Service-managed permissions] The Organizations accounts affected by the stack operation.</p>
        pub fn set_deployment_targets(
            mut self,
            input: std::option::Option<crate::model::DeploymentTargets>,
        ) -> Self {
            self.deployment_targets = input;
            self
        }
        /// <p>Detailed information about the drift status of the stack set. This includes information about drift operations currently being performed on the stack set.</p>
        /// <p>this information will only be present for stack set operations whose <code>Action</code> type is <code>DETECT_DRIFT</code>.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-drift.html">Detecting Unmanaged Changes in Stack Sets</a> in the CloudFormation User Guide.</p>
        pub fn stack_set_drift_detection_details(
            mut self,
            input: crate::model::StackSetDriftDetectionDetails,
        ) -> Self {
            self.stack_set_drift_detection_details = Some(input);
            self
        }
        /// <p>Detailed information about the drift status of the stack set. This includes information about drift operations currently being performed on the stack set.</p>
        /// <p>this information will only be present for stack set operations whose <code>Action</code> type is <code>DETECT_DRIFT</code>.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-drift.html">Detecting Unmanaged Changes in Stack Sets</a> in the CloudFormation User Guide.</p>
        pub fn set_stack_set_drift_detection_details(
            mut self,
            input: std::option::Option<crate::model::StackSetDriftDetectionDetails>,
        ) -> Self {
            self.stack_set_drift_detection_details = input;
            self
        }
        /// Consumes the builder and constructs a [`StackSetOperation`](crate::model::StackSetOperation)
        pub fn build(self) -> crate::model::StackSetOperation {
            crate::model::StackSetOperation {
                operation_id: self.operation_id,
                stack_set_id: self.stack_set_id,
                action: self.action,
                status: self.status,
                operation_preferences: self.operation_preferences,
                retain_stacks: self.retain_stacks,
                administration_role_arn: self.administration_role_arn,
                execution_role_name: self.execution_role_name,
                creation_timestamp: self.creation_timestamp,
                end_timestamp: self.end_timestamp,
                deployment_targets: self.deployment_targets,
                stack_set_drift_detection_details: self.stack_set_drift_detection_details,
            }
        }
    }
}
impl StackSetOperation {
    /// Creates a new builder-style object to manufacture [`StackSetOperation`](crate::model::StackSetOperation)
    pub fn builder() -> crate::model::stack_set_operation::Builder {
        crate::model::stack_set_operation::Builder::default()
    }
}

/// <p>Detailed information about the drift status of the stack set.</p>
/// <p>For stack sets, contains information about the last <i>completed</i> drift operation performed on the stack set. Information about drift operations in-progress is not included. </p>
/// <p>For stack set operations, includes information about drift operations currently being performed on the stack set.</p>
/// <p>For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-drift.html">Detecting Unmanaged Changes in Stack Sets</a> in the <i>CloudFormation User Guide</i>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StackSetDriftDetectionDetails {
    /// <p>Status of the stack set's actual configuration compared to its expected template and parameter configuration. A stack set is considered to have drifted if one or more of its stack instances have drifted from their expected template and parameter configuration.</p>
    /// <ul>
    /// <li> <p> <code>DRIFTED</code>: One or more of the stack instances belonging to the stack set stack differs from the expected template and parameter configuration. A stack instance is considered to have drifted if one or more of the resources in the associated stack have drifted.</p> </li>
    /// <li> <p> <code>NOT_CHECKED</code>: CloudFormation has not checked the stack set for drift.</p> </li>
    /// <li> <p> <code>IN_SYNC</code>: All of the stack instances belonging to the stack set stack match from the expected template and parameter configuration.</p> </li>
    /// </ul>
    pub drift_status: std::option::Option<crate::model::StackSetDriftStatus>,
    /// <p>The status of the stack set drift detection operation.</p>
    /// <ul>
    /// <li> <p> <code>COMPLETED</code>: The drift detection operation completed without failing on any stack instances.</p> </li>
    /// <li> <p> <code>FAILED</code>: The drift detection operation exceeded the specified failure tolerance. </p> </li>
    /// <li> <p> <code>PARTIAL_SUCCESS</code>: The drift detection operation completed without exceeding the failure tolerance for the operation.</p> </li>
    /// <li> <p> <code>IN_PROGRESS</code>: The drift detection operation is currently being performed.</p> </li>
    /// <li> <p> <code>STOPPED</code>: The user has cancelled the drift detection operation.</p> </li>
    /// </ul>
    pub drift_detection_status: std::option::Option<crate::model::StackSetDriftDetectionStatus>,
    /// <p>Most recent time when CloudFormation performed a drift detection operation on the stack set. This value will be <code>NULL</code> for any stack set on which drift detection has not yet been performed.</p>
    pub last_drift_check_timestamp: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The total number of stack instances belonging to this stack set. </p>
    /// <p>The total number of stack instances is equal to the total of:</p>
    /// <ul>
    /// <li> <p>Stack instances that match the stack set configuration. </p> </li>
    /// <li> <p>Stack instances that have drifted from the stack set configuration. </p> </li>
    /// <li> <p>Stack instances where the drift detection operation has failed.</p> </li>
    /// <li> <p>Stack instances currently being checked for drift.</p> </li>
    /// </ul>
    pub total_stack_instances_count: i32,
    /// <p>The number of stack instances that have drifted from the expected template and parameter configuration of the stack set. A stack instance is considered to have drifted if one or more of the resources in the associated stack do not match their expected configuration.</p>
    pub drifted_stack_instances_count: i32,
    /// <p>The number of stack instances which match the expected template and parameter configuration of the stack set.</p>
    pub in_sync_stack_instances_count: i32,
    /// <p>The number of stack instances that are currently being checked for drift.</p>
    pub in_progress_stack_instances_count: i32,
    /// <p>The number of stack instances for which the drift detection operation failed.</p>
    pub failed_stack_instances_count: i32,
}
impl StackSetDriftDetectionDetails {
    /// <p>Status of the stack set's actual configuration compared to its expected template and parameter configuration. A stack set is considered to have drifted if one or more of its stack instances have drifted from their expected template and parameter configuration.</p>
    /// <ul>
    /// <li> <p> <code>DRIFTED</code>: One or more of the stack instances belonging to the stack set stack differs from the expected template and parameter configuration. A stack instance is considered to have drifted if one or more of the resources in the associated stack have drifted.</p> </li>
    /// <li> <p> <code>NOT_CHECKED</code>: CloudFormation has not checked the stack set for drift.</p> </li>
    /// <li> <p> <code>IN_SYNC</code>: All of the stack instances belonging to the stack set stack match from the expected template and parameter configuration.</p> </li>
    /// </ul>
    pub fn drift_status(&self) -> std::option::Option<&crate::model::StackSetDriftStatus> {
        self.drift_status.as_ref()
    }
    /// <p>The status of the stack set drift detection operation.</p>
    /// <ul>
    /// <li> <p> <code>COMPLETED</code>: The drift detection operation completed without failing on any stack instances.</p> </li>
    /// <li> <p> <code>FAILED</code>: The drift detection operation exceeded the specified failure tolerance. </p> </li>
    /// <li> <p> <code>PARTIAL_SUCCESS</code>: The drift detection operation completed without exceeding the failure tolerance for the operation.</p> </li>
    /// <li> <p> <code>IN_PROGRESS</code>: The drift detection operation is currently being performed.</p> </li>
    /// <li> <p> <code>STOPPED</code>: The user has cancelled the drift detection operation.</p> </li>
    /// </ul>
    pub fn drift_detection_status(
        &self,
    ) -> std::option::Option<&crate::model::StackSetDriftDetectionStatus> {
        self.drift_detection_status.as_ref()
    }
    /// <p>Most recent time when CloudFormation performed a drift detection operation on the stack set. This value will be <code>NULL</code> for any stack set on which drift detection has not yet been performed.</p>
    pub fn last_drift_check_timestamp(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_drift_check_timestamp.as_ref()
    }
    /// <p>The total number of stack instances belonging to this stack set. </p>
    /// <p>The total number of stack instances is equal to the total of:</p>
    /// <ul>
    /// <li> <p>Stack instances that match the stack set configuration. </p> </li>
    /// <li> <p>Stack instances that have drifted from the stack set configuration. </p> </li>
    /// <li> <p>Stack instances where the drift detection operation has failed.</p> </li>
    /// <li> <p>Stack instances currently being checked for drift.</p> </li>
    /// </ul>
    pub fn total_stack_instances_count(&self) -> i32 {
        self.total_stack_instances_count
    }
    /// <p>The number of stack instances that have drifted from the expected template and parameter configuration of the stack set. A stack instance is considered to have drifted if one or more of the resources in the associated stack do not match their expected configuration.</p>
    pub fn drifted_stack_instances_count(&self) -> i32 {
        self.drifted_stack_instances_count
    }
    /// <p>The number of stack instances which match the expected template and parameter configuration of the stack set.</p>
    pub fn in_sync_stack_instances_count(&self) -> i32 {
        self.in_sync_stack_instances_count
    }
    /// <p>The number of stack instances that are currently being checked for drift.</p>
    pub fn in_progress_stack_instances_count(&self) -> i32 {
        self.in_progress_stack_instances_count
    }
    /// <p>The number of stack instances for which the drift detection operation failed.</p>
    pub fn failed_stack_instances_count(&self) -> i32 {
        self.failed_stack_instances_count
    }
}
impl std::fmt::Debug for StackSetDriftDetectionDetails {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StackSetDriftDetectionDetails");
        formatter.field("drift_status", &self.drift_status);
        formatter.field("drift_detection_status", &self.drift_detection_status);
        formatter.field(
            "last_drift_check_timestamp",
            &self.last_drift_check_timestamp,
        );
        formatter.field(
            "total_stack_instances_count",
            &self.total_stack_instances_count,
        );
        formatter.field(
            "drifted_stack_instances_count",
            &self.drifted_stack_instances_count,
        );
        formatter.field(
            "in_sync_stack_instances_count",
            &self.in_sync_stack_instances_count,
        );
        formatter.field(
            "in_progress_stack_instances_count",
            &self.in_progress_stack_instances_count,
        );
        formatter.field(
            "failed_stack_instances_count",
            &self.failed_stack_instances_count,
        );
        formatter.finish()
    }
}
/// See [`StackSetDriftDetectionDetails`](crate::model::StackSetDriftDetectionDetails)
pub mod stack_set_drift_detection_details {
    /// A builder for [`StackSetDriftDetectionDetails`](crate::model::StackSetDriftDetectionDetails)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) drift_status: std::option::Option<crate::model::StackSetDriftStatus>,
        pub(crate) drift_detection_status:
            std::option::Option<crate::model::StackSetDriftDetectionStatus>,
        pub(crate) last_drift_check_timestamp: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) total_stack_instances_count: std::option::Option<i32>,
        pub(crate) drifted_stack_instances_count: std::option::Option<i32>,
        pub(crate) in_sync_stack_instances_count: std::option::Option<i32>,
        pub(crate) in_progress_stack_instances_count: std::option::Option<i32>,
        pub(crate) failed_stack_instances_count: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>Status of the stack set's actual configuration compared to its expected template and parameter configuration. A stack set is considered to have drifted if one or more of its stack instances have drifted from their expected template and parameter configuration.</p>
        /// <ul>
        /// <li> <p> <code>DRIFTED</code>: One or more of the stack instances belonging to the stack set stack differs from the expected template and parameter configuration. A stack instance is considered to have drifted if one or more of the resources in the associated stack have drifted.</p> </li>
        /// <li> <p> <code>NOT_CHECKED</code>: CloudFormation has not checked the stack set for drift.</p> </li>
        /// <li> <p> <code>IN_SYNC</code>: All of the stack instances belonging to the stack set stack match from the expected template and parameter configuration.</p> </li>
        /// </ul>
        pub fn drift_status(mut self, input: crate::model::StackSetDriftStatus) -> Self {
            self.drift_status = Some(input);
            self
        }
        /// <p>Status of the stack set's actual configuration compared to its expected template and parameter configuration. A stack set is considered to have drifted if one or more of its stack instances have drifted from their expected template and parameter configuration.</p>
        /// <ul>
        /// <li> <p> <code>DRIFTED</code>: One or more of the stack instances belonging to the stack set stack differs from the expected template and parameter configuration. A stack instance is considered to have drifted if one or more of the resources in the associated stack have drifted.</p> </li>
        /// <li> <p> <code>NOT_CHECKED</code>: CloudFormation has not checked the stack set for drift.</p> </li>
        /// <li> <p> <code>IN_SYNC</code>: All of the stack instances belonging to the stack set stack match from the expected template and parameter configuration.</p> </li>
        /// </ul>
        pub fn set_drift_status(
            mut self,
            input: std::option::Option<crate::model::StackSetDriftStatus>,
        ) -> Self {
            self.drift_status = input;
            self
        }
        /// <p>The status of the stack set drift detection operation.</p>
        /// <ul>
        /// <li> <p> <code>COMPLETED</code>: The drift detection operation completed without failing on any stack instances.</p> </li>
        /// <li> <p> <code>FAILED</code>: The drift detection operation exceeded the specified failure tolerance. </p> </li>
        /// <li> <p> <code>PARTIAL_SUCCESS</code>: The drift detection operation completed without exceeding the failure tolerance for the operation.</p> </li>
        /// <li> <p> <code>IN_PROGRESS</code>: The drift detection operation is currently being performed.</p> </li>
        /// <li> <p> <code>STOPPED</code>: The user has cancelled the drift detection operation.</p> </li>
        /// </ul>
        pub fn drift_detection_status(
            mut self,
            input: crate::model::StackSetDriftDetectionStatus,
        ) -> Self {
            self.drift_detection_status = Some(input);
            self
        }
        /// <p>The status of the stack set drift detection operation.</p>
        /// <ul>
        /// <li> <p> <code>COMPLETED</code>: The drift detection operation completed without failing on any stack instances.</p> </li>
        /// <li> <p> <code>FAILED</code>: The drift detection operation exceeded the specified failure tolerance. </p> </li>
        /// <li> <p> <code>PARTIAL_SUCCESS</code>: The drift detection operation completed without exceeding the failure tolerance for the operation.</p> </li>
        /// <li> <p> <code>IN_PROGRESS</code>: The drift detection operation is currently being performed.</p> </li>
        /// <li> <p> <code>STOPPED</code>: The user has cancelled the drift detection operation.</p> </li>
        /// </ul>
        pub fn set_drift_detection_status(
            mut self,
            input: std::option::Option<crate::model::StackSetDriftDetectionStatus>,
        ) -> Self {
            self.drift_detection_status = input;
            self
        }
        /// <p>Most recent time when CloudFormation performed a drift detection operation on the stack set. This value will be <code>NULL</code> for any stack set on which drift detection has not yet been performed.</p>
        pub fn last_drift_check_timestamp(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_drift_check_timestamp = Some(input);
            self
        }
        /// <p>Most recent time when CloudFormation performed a drift detection operation on the stack set. This value will be <code>NULL</code> for any stack set on which drift detection has not yet been performed.</p>
        pub fn set_last_drift_check_timestamp(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_drift_check_timestamp = input;
            self
        }
        /// <p>The total number of stack instances belonging to this stack set. </p>
        /// <p>The total number of stack instances is equal to the total of:</p>
        /// <ul>
        /// <li> <p>Stack instances that match the stack set configuration. </p> </li>
        /// <li> <p>Stack instances that have drifted from the stack set configuration. </p> </li>
        /// <li> <p>Stack instances where the drift detection operation has failed.</p> </li>
        /// <li> <p>Stack instances currently being checked for drift.</p> </li>
        /// </ul>
        pub fn total_stack_instances_count(mut self, input: i32) -> Self {
            self.total_stack_instances_count = Some(input);
            self
        }
        /// <p>The total number of stack instances belonging to this stack set. </p>
        /// <p>The total number of stack instances is equal to the total of:</p>
        /// <ul>
        /// <li> <p>Stack instances that match the stack set configuration. </p> </li>
        /// <li> <p>Stack instances that have drifted from the stack set configuration. </p> </li>
        /// <li> <p>Stack instances where the drift detection operation has failed.</p> </li>
        /// <li> <p>Stack instances currently being checked for drift.</p> </li>
        /// </ul>
        pub fn set_total_stack_instances_count(mut self, input: std::option::Option<i32>) -> Self {
            self.total_stack_instances_count = input;
            self
        }
        /// <p>The number of stack instances that have drifted from the expected template and parameter configuration of the stack set. A stack instance is considered to have drifted if one or more of the resources in the associated stack do not match their expected configuration.</p>
        pub fn drifted_stack_instances_count(mut self, input: i32) -> Self {
            self.drifted_stack_instances_count = Some(input);
            self
        }
        /// <p>The number of stack instances that have drifted from the expected template and parameter configuration of the stack set. A stack instance is considered to have drifted if one or more of the resources in the associated stack do not match their expected configuration.</p>
        pub fn set_drifted_stack_instances_count(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.drifted_stack_instances_count = input;
            self
        }
        /// <p>The number of stack instances which match the expected template and parameter configuration of the stack set.</p>
        pub fn in_sync_stack_instances_count(mut self, input: i32) -> Self {
            self.in_sync_stack_instances_count = Some(input);
            self
        }
        /// <p>The number of stack instances which match the expected template and parameter configuration of the stack set.</p>
        pub fn set_in_sync_stack_instances_count(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.in_sync_stack_instances_count = input;
            self
        }
        /// <p>The number of stack instances that are currently being checked for drift.</p>
        pub fn in_progress_stack_instances_count(mut self, input: i32) -> Self {
            self.in_progress_stack_instances_count = Some(input);
            self
        }
        /// <p>The number of stack instances that are currently being checked for drift.</p>
        pub fn set_in_progress_stack_instances_count(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.in_progress_stack_instances_count = input;
            self
        }
        /// <p>The number of stack instances for which the drift detection operation failed.</p>
        pub fn failed_stack_instances_count(mut self, input: i32) -> Self {
            self.failed_stack_instances_count = Some(input);
            self
        }
        /// <p>The number of stack instances for which the drift detection operation failed.</p>
        pub fn set_failed_stack_instances_count(mut self, input: std::option::Option<i32>) -> Self {
            self.failed_stack_instances_count = input;
            self
        }
        /// Consumes the builder and constructs a [`StackSetDriftDetectionDetails`](crate::model::StackSetDriftDetectionDetails)
        pub fn build(self) -> crate::model::StackSetDriftDetectionDetails {
            crate::model::StackSetDriftDetectionDetails {
                drift_status: self.drift_status,
                drift_detection_status: self.drift_detection_status,
                last_drift_check_timestamp: self.last_drift_check_timestamp,
                total_stack_instances_count: self.total_stack_instances_count.unwrap_or_default(),
                drifted_stack_instances_count: self
                    .drifted_stack_instances_count
                    .unwrap_or_default(),
                in_sync_stack_instances_count: self
                    .in_sync_stack_instances_count
                    .unwrap_or_default(),
                in_progress_stack_instances_count: self
                    .in_progress_stack_instances_count
                    .unwrap_or_default(),
                failed_stack_instances_count: self.failed_stack_instances_count.unwrap_or_default(),
            }
        }
    }
}
impl StackSetDriftDetectionDetails {
    /// Creates a new builder-style object to manufacture [`StackSetDriftDetectionDetails`](crate::model::StackSetDriftDetectionDetails)
    pub fn builder() -> crate::model::stack_set_drift_detection_details::Builder {
        crate::model::stack_set_drift_detection_details::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum StackSetDriftDetectionStatus {
    #[allow(missing_docs)] // documentation missing in model
    Completed,
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    #[allow(missing_docs)] // documentation missing in model
    InProgress,
    #[allow(missing_docs)] // documentation missing in model
    PartialSuccess,
    #[allow(missing_docs)] // documentation missing in model
    Stopped,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for StackSetDriftDetectionStatus {
    fn from(s: &str) -> Self {
        match s {
            "COMPLETED" => StackSetDriftDetectionStatus::Completed,
            "FAILED" => StackSetDriftDetectionStatus::Failed,
            "IN_PROGRESS" => StackSetDriftDetectionStatus::InProgress,
            "PARTIAL_SUCCESS" => StackSetDriftDetectionStatus::PartialSuccess,
            "STOPPED" => StackSetDriftDetectionStatus::Stopped,
            other => StackSetDriftDetectionStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for StackSetDriftDetectionStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(StackSetDriftDetectionStatus::from(s))
    }
}
impl StackSetDriftDetectionStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            StackSetDriftDetectionStatus::Completed => "COMPLETED",
            StackSetDriftDetectionStatus::Failed => "FAILED",
            StackSetDriftDetectionStatus::InProgress => "IN_PROGRESS",
            StackSetDriftDetectionStatus::PartialSuccess => "PARTIAL_SUCCESS",
            StackSetDriftDetectionStatus::Stopped => "STOPPED",
            StackSetDriftDetectionStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "COMPLETED",
            "FAILED",
            "IN_PROGRESS",
            "PARTIAL_SUCCESS",
            "STOPPED",
        ]
    }
}
impl AsRef<str> for StackSetDriftDetectionStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum StackSetDriftStatus {
    #[allow(missing_docs)] // documentation missing in model
    Drifted,
    #[allow(missing_docs)] // documentation missing in model
    InSync,
    #[allow(missing_docs)] // documentation missing in model
    NotChecked,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for StackSetDriftStatus {
    fn from(s: &str) -> Self {
        match s {
            "DRIFTED" => StackSetDriftStatus::Drifted,
            "IN_SYNC" => StackSetDriftStatus::InSync,
            "NOT_CHECKED" => StackSetDriftStatus::NotChecked,
            other => StackSetDriftStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for StackSetDriftStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(StackSetDriftStatus::from(s))
    }
}
impl StackSetDriftStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            StackSetDriftStatus::Drifted => "DRIFTED",
            StackSetDriftStatus::InSync => "IN_SYNC",
            StackSetDriftStatus::NotChecked => "NOT_CHECKED",
            StackSetDriftStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["DRIFTED", "IN_SYNC", "NOT_CHECKED"]
    }
}
impl AsRef<str> for StackSetDriftStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>A structure that contains information about a stack set. A stack set enables you to provision stacks into Amazon Web Services accounts and across Regions by using a single CloudFormation template. In the stack set, you specify the template to use, as well as any parameters and capabilities that the template requires. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StackSet {
    /// <p>The name that's associated with the stack set.</p>
    pub stack_set_name: std::option::Option<std::string::String>,
    /// <p>The ID of the stack set.</p>
    pub stack_set_id: std::option::Option<std::string::String>,
    /// <p>A description of the stack set that you specify when the stack set is created or updated.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The status of the stack set.</p>
    pub status: std::option::Option<crate::model::StackSetStatus>,
    /// <p>The structure that contains the body of the template that was used to create or update the stack set.</p>
    pub template_body: std::option::Option<std::string::String>,
    /// <p>A list of input parameters for a stack set.</p>
    pub parameters: std::option::Option<std::vec::Vec<crate::model::Parameter>>,
    /// <p>The capabilities that are allowed in the stack set. Some stack set templates might include resources that can affect permissions in your Amazon Web Services account—for example, by creating new Identity and Access Management (IAM) users. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html#capabilities">Acknowledging IAM Resources in CloudFormation Templates.</a> </p>
    pub capabilities: std::option::Option<std::vec::Vec<crate::model::Capability>>,
    /// <p>A list of tags that specify information about the stack set. A maximum number of 50 tags can be specified.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    /// <p>The Amazon Resource Number (ARN) of the stack set.</p>
    pub stack_set_arn: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Number (ARN) of the IAM role used to create or update the stack set.</p>
    /// <p>Use customized administrator roles to control which users or groups can manage specific stack sets within the same administrator account. For more information, see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-prereqs.html">Prerequisites: Granting Permissions for Stack Set Operations</a> in the <i>CloudFormation User Guide</i>.</p>
    pub administration_role_arn: std::option::Option<std::string::String>,
    /// <p>The name of the IAM execution role used to create or update the stack set. </p>
    /// <p>Use customized execution roles to control which stack resources users and groups can include in their stack sets. </p>
    pub execution_role_name: std::option::Option<std::string::String>,
    /// <p>Detailed information about the drift status of the stack set.</p>
    /// <p>For stack sets, contains information about the last <i>completed</i> drift operation performed on the stack set. Information about drift operations currently in progress is not included.</p>
    pub stack_set_drift_detection_details:
        std::option::Option<crate::model::StackSetDriftDetectionDetails>,
    /// <p>[Service-managed permissions] Describes whether StackSets automatically deploys to Organizations accounts that are added to a target organization or organizational unit (OU).</p>
    pub auto_deployment: std::option::Option<crate::model::AutoDeployment>,
    /// <p>Describes how the IAM roles required for stack set operations are created.</p>
    /// <ul>
    /// <li> <p>With <code>self-managed</code> permissions, you must create the administrator and execution roles required to deploy to target accounts. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-prereqs-self-managed.html">Grant Self-Managed Stack Set Permissions</a>.</p> </li>
    /// <li> <p>With <code>service-managed</code> permissions, StackSets automatically creates the IAM roles required to deploy to accounts managed by Organizations. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-prereqs-service-managed.html">Grant Service-Managed Stack Set Permissions</a>.</p> </li>
    /// </ul>
    pub permission_model: std::option::Option<crate::model::PermissionModels>,
    /// <p>[Service-managed permissions] The organization root ID or organizational unit (OU) IDs that you specified for <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_DeploymentTargets.html">DeploymentTargets</a>.</p>
    pub organizational_unit_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>Describes whether StackSets performs non-conflicting operations concurrently and queues conflicting operations.</p>
    pub managed_execution: std::option::Option<crate::model::ManagedExecution>,
}
impl StackSet {
    /// <p>The name that's associated with the stack set.</p>
    pub fn stack_set_name(&self) -> std::option::Option<&str> {
        self.stack_set_name.as_deref()
    }
    /// <p>The ID of the stack set.</p>
    pub fn stack_set_id(&self) -> std::option::Option<&str> {
        self.stack_set_id.as_deref()
    }
    /// <p>A description of the stack set that you specify when the stack set is created or updated.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The status of the stack set.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::StackSetStatus> {
        self.status.as_ref()
    }
    /// <p>The structure that contains the body of the template that was used to create or update the stack set.</p>
    pub fn template_body(&self) -> std::option::Option<&str> {
        self.template_body.as_deref()
    }
    /// <p>A list of input parameters for a stack set.</p>
    pub fn parameters(&self) -> std::option::Option<&[crate::model::Parameter]> {
        self.parameters.as_deref()
    }
    /// <p>The capabilities that are allowed in the stack set. Some stack set templates might include resources that can affect permissions in your Amazon Web Services account—for example, by creating new Identity and Access Management (IAM) users. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html#capabilities">Acknowledging IAM Resources in CloudFormation Templates.</a> </p>
    pub fn capabilities(&self) -> std::option::Option<&[crate::model::Capability]> {
        self.capabilities.as_deref()
    }
    /// <p>A list of tags that specify information about the stack set. A maximum number of 50 tags can be specified.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
    /// <p>The Amazon Resource Number (ARN) of the stack set.</p>
    pub fn stack_set_arn(&self) -> std::option::Option<&str> {
        self.stack_set_arn.as_deref()
    }
    /// <p>The Amazon Resource Number (ARN) of the IAM role used to create or update the stack set.</p>
    /// <p>Use customized administrator roles to control which users or groups can manage specific stack sets within the same administrator account. For more information, see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-prereqs.html">Prerequisites: Granting Permissions for Stack Set Operations</a> in the <i>CloudFormation User Guide</i>.</p>
    pub fn administration_role_arn(&self) -> std::option::Option<&str> {
        self.administration_role_arn.as_deref()
    }
    /// <p>The name of the IAM execution role used to create or update the stack set. </p>
    /// <p>Use customized execution roles to control which stack resources users and groups can include in their stack sets. </p>
    pub fn execution_role_name(&self) -> std::option::Option<&str> {
        self.execution_role_name.as_deref()
    }
    /// <p>Detailed information about the drift status of the stack set.</p>
    /// <p>For stack sets, contains information about the last <i>completed</i> drift operation performed on the stack set. Information about drift operations currently in progress is not included.</p>
    pub fn stack_set_drift_detection_details(
        &self,
    ) -> std::option::Option<&crate::model::StackSetDriftDetectionDetails> {
        self.stack_set_drift_detection_details.as_ref()
    }
    /// <p>[Service-managed permissions] Describes whether StackSets automatically deploys to Organizations accounts that are added to a target organization or organizational unit (OU).</p>
    pub fn auto_deployment(&self) -> std::option::Option<&crate::model::AutoDeployment> {
        self.auto_deployment.as_ref()
    }
    /// <p>Describes how the IAM roles required for stack set operations are created.</p>
    /// <ul>
    /// <li> <p>With <code>self-managed</code> permissions, you must create the administrator and execution roles required to deploy to target accounts. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-prereqs-self-managed.html">Grant Self-Managed Stack Set Permissions</a>.</p> </li>
    /// <li> <p>With <code>service-managed</code> permissions, StackSets automatically creates the IAM roles required to deploy to accounts managed by Organizations. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-prereqs-service-managed.html">Grant Service-Managed Stack Set Permissions</a>.</p> </li>
    /// </ul>
    pub fn permission_model(&self) -> std::option::Option<&crate::model::PermissionModels> {
        self.permission_model.as_ref()
    }
    /// <p>[Service-managed permissions] The organization root ID or organizational unit (OU) IDs that you specified for <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_DeploymentTargets.html">DeploymentTargets</a>.</p>
    pub fn organizational_unit_ids(&self) -> std::option::Option<&[std::string::String]> {
        self.organizational_unit_ids.as_deref()
    }
    /// <p>Describes whether StackSets performs non-conflicting operations concurrently and queues conflicting operations.</p>
    pub fn managed_execution(&self) -> std::option::Option<&crate::model::ManagedExecution> {
        self.managed_execution.as_ref()
    }
}
impl std::fmt::Debug for StackSet {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StackSet");
        formatter.field("stack_set_name", &self.stack_set_name);
        formatter.field("stack_set_id", &self.stack_set_id);
        formatter.field("description", &self.description);
        formatter.field("status", &self.status);
        formatter.field("template_body", &self.template_body);
        formatter.field("parameters", &self.parameters);
        formatter.field("capabilities", &self.capabilities);
        formatter.field("tags", &self.tags);
        formatter.field("stack_set_arn", &self.stack_set_arn);
        formatter.field("administration_role_arn", &self.administration_role_arn);
        formatter.field("execution_role_name", &self.execution_role_name);
        formatter.field(
            "stack_set_drift_detection_details",
            &self.stack_set_drift_detection_details,
        );
        formatter.field("auto_deployment", &self.auto_deployment);
        formatter.field("permission_model", &self.permission_model);
        formatter.field("organizational_unit_ids", &self.organizational_unit_ids);
        formatter.field("managed_execution", &self.managed_execution);
        formatter.finish()
    }
}
/// See [`StackSet`](crate::model::StackSet)
pub mod stack_set {
    /// A builder for [`StackSet`](crate::model::StackSet)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) stack_set_name: std::option::Option<std::string::String>,
        pub(crate) stack_set_id: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::StackSetStatus>,
        pub(crate) template_body: std::option::Option<std::string::String>,
        pub(crate) parameters: std::option::Option<std::vec::Vec<crate::model::Parameter>>,
        pub(crate) capabilities: std::option::Option<std::vec::Vec<crate::model::Capability>>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        pub(crate) stack_set_arn: std::option::Option<std::string::String>,
        pub(crate) administration_role_arn: std::option::Option<std::string::String>,
        pub(crate) execution_role_name: std::option::Option<std::string::String>,
        pub(crate) stack_set_drift_detection_details:
            std::option::Option<crate::model::StackSetDriftDetectionDetails>,
        pub(crate) auto_deployment: std::option::Option<crate::model::AutoDeployment>,
        pub(crate) permission_model: std::option::Option<crate::model::PermissionModels>,
        pub(crate) organizational_unit_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) managed_execution: std::option::Option<crate::model::ManagedExecution>,
    }
    impl Builder {
        /// <p>The name that's associated with the stack set.</p>
        pub fn stack_set_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.stack_set_name = Some(input.into());
            self
        }
        /// <p>The name that's associated with the stack set.</p>
        pub fn set_stack_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.stack_set_name = input;
            self
        }
        /// <p>The ID of the stack set.</p>
        pub fn stack_set_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.stack_set_id = Some(input.into());
            self
        }
        /// <p>The ID of the stack set.</p>
        pub fn set_stack_set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.stack_set_id = input;
            self
        }
        /// <p>A description of the stack set that you specify when the stack set is created or updated.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A description of the stack set that you specify when the stack set is created or updated.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The status of the stack set.</p>
        pub fn status(mut self, input: crate::model::StackSetStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of the stack set.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::StackSetStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>The structure that contains the body of the template that was used to create or update the stack set.</p>
        pub fn template_body(mut self, input: impl Into<std::string::String>) -> Self {
            self.template_body = Some(input.into());
            self
        }
        /// <p>The structure that contains the body of the template that was used to create or update the stack set.</p>
        pub fn set_template_body(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.template_body = input;
            self
        }
        /// Appends an item to `parameters`.
        ///
        /// To override the contents of this collection use [`set_parameters`](Self::set_parameters).
        ///
        /// <p>A list of input parameters for a stack set.</p>
        pub fn parameters(mut self, input: crate::model::Parameter) -> Self {
            let mut v = self.parameters.unwrap_or_default();
            v.push(input);
            self.parameters = Some(v);
            self
        }
        /// <p>A list of input parameters for a stack set.</p>
        pub fn set_parameters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Parameter>>,
        ) -> Self {
            self.parameters = input;
            self
        }
        /// Appends an item to `capabilities`.
        ///
        /// To override the contents of this collection use [`set_capabilities`](Self::set_capabilities).
        ///
        /// <p>The capabilities that are allowed in the stack set. Some stack set templates might include resources that can affect permissions in your Amazon Web Services account—for example, by creating new Identity and Access Management (IAM) users. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html#capabilities">Acknowledging IAM Resources in CloudFormation Templates.</a> </p>
        pub fn capabilities(mut self, input: crate::model::Capability) -> Self {
            let mut v = self.capabilities.unwrap_or_default();
            v.push(input);
            self.capabilities = Some(v);
            self
        }
        /// <p>The capabilities that are allowed in the stack set. Some stack set templates might include resources that can affect permissions in your Amazon Web Services account—for example, by creating new Identity and Access Management (IAM) users. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html#capabilities">Acknowledging IAM Resources in CloudFormation Templates.</a> </p>
        pub fn set_capabilities(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Capability>>,
        ) -> Self {
            self.capabilities = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of tags that specify information about the stack set. A maximum number of 50 tags can be specified.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input);
            self.tags = Some(v);
            self
        }
        /// <p>A list of tags that specify information about the stack set. A maximum number of 50 tags can be specified.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>The Amazon Resource Number (ARN) of the stack set.</p>
        pub fn stack_set_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.stack_set_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Number (ARN) of the stack set.</p>
        pub fn set_stack_set_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.stack_set_arn = input;
            self
        }
        /// <p>The Amazon Resource Number (ARN) of the IAM role used to create or update the stack set.</p>
        /// <p>Use customized administrator roles to control which users or groups can manage specific stack sets within the same administrator account. For more information, see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-prereqs.html">Prerequisites: Granting Permissions for Stack Set Operations</a> in the <i>CloudFormation User Guide</i>.</p>
        pub fn administration_role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.administration_role_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Number (ARN) of the IAM role used to create or update the stack set.</p>
        /// <p>Use customized administrator roles to control which users or groups can manage specific stack sets within the same administrator account. For more information, see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-prereqs.html">Prerequisites: Granting Permissions for Stack Set Operations</a> in the <i>CloudFormation User Guide</i>.</p>
        pub fn set_administration_role_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.administration_role_arn = input;
            self
        }
        /// <p>The name of the IAM execution role used to create or update the stack set. </p>
        /// <p>Use customized execution roles to control which stack resources users and groups can include in their stack sets. </p>
        pub fn execution_role_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.execution_role_name = Some(input.into());
            self
        }
        /// <p>The name of the IAM execution role used to create or update the stack set. </p>
        /// <p>Use customized execution roles to control which stack resources users and groups can include in their stack sets. </p>
        pub fn set_execution_role_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.execution_role_name = input;
            self
        }
        /// <p>Detailed information about the drift status of the stack set.</p>
        /// <p>For stack sets, contains information about the last <i>completed</i> drift operation performed on the stack set. Information about drift operations currently in progress is not included.</p>
        pub fn stack_set_drift_detection_details(
            mut self,
            input: crate::model::StackSetDriftDetectionDetails,
        ) -> Self {
            self.stack_set_drift_detection_details = Some(input);
            self
        }
        /// <p>Detailed information about the drift status of the stack set.</p>
        /// <p>For stack sets, contains information about the last <i>completed</i> drift operation performed on the stack set. Information about drift operations currently in progress is not included.</p>
        pub fn set_stack_set_drift_detection_details(
            mut self,
            input: std::option::Option<crate::model::StackSetDriftDetectionDetails>,
        ) -> Self {
            self.stack_set_drift_detection_details = input;
            self
        }
        /// <p>[Service-managed permissions] Describes whether StackSets automatically deploys to Organizations accounts that are added to a target organization or organizational unit (OU).</p>
        pub fn auto_deployment(mut self, input: crate::model::AutoDeployment) -> Self {
            self.auto_deployment = Some(input);
            self
        }
        /// <p>[Service-managed permissions] Describes whether StackSets automatically deploys to Organizations accounts that are added to a target organization or organizational unit (OU).</p>
        pub fn set_auto_deployment(
            mut self,
            input: std::option::Option<crate::model::AutoDeployment>,
        ) -> Self {
            self.auto_deployment = input;
            self
        }
        /// <p>Describes how the IAM roles required for stack set operations are created.</p>
        /// <ul>
        /// <li> <p>With <code>self-managed</code> permissions, you must create the administrator and execution roles required to deploy to target accounts. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-prereqs-self-managed.html">Grant Self-Managed Stack Set Permissions</a>.</p> </li>
        /// <li> <p>With <code>service-managed</code> permissions, StackSets automatically creates the IAM roles required to deploy to accounts managed by Organizations. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-prereqs-service-managed.html">Grant Service-Managed Stack Set Permissions</a>.</p> </li>
        /// </ul>
        pub fn permission_model(mut self, input: crate::model::PermissionModels) -> Self {
            self.permission_model = Some(input);
            self
        }
        /// <p>Describes how the IAM roles required for stack set operations are created.</p>
        /// <ul>
        /// <li> <p>With <code>self-managed</code> permissions, you must create the administrator and execution roles required to deploy to target accounts. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-prereqs-self-managed.html">Grant Self-Managed Stack Set Permissions</a>.</p> </li>
        /// <li> <p>With <code>service-managed</code> permissions, StackSets automatically creates the IAM roles required to deploy to accounts managed by Organizations. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-prereqs-service-managed.html">Grant Service-Managed Stack Set Permissions</a>.</p> </li>
        /// </ul>
        pub fn set_permission_model(
            mut self,
            input: std::option::Option<crate::model::PermissionModels>,
        ) -> Self {
            self.permission_model = input;
            self
        }
        /// Appends an item to `organizational_unit_ids`.
        ///
        /// To override the contents of this collection use [`set_organizational_unit_ids`](Self::set_organizational_unit_ids).
        ///
        /// <p>[Service-managed permissions] The organization root ID or organizational unit (OU) IDs that you specified for <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_DeploymentTargets.html">DeploymentTargets</a>.</p>
        pub fn organizational_unit_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.organizational_unit_ids.unwrap_or_default();
            v.push(input.into());
            self.organizational_unit_ids = Some(v);
            self
        }
        /// <p>[Service-managed permissions] The organization root ID or organizational unit (OU) IDs that you specified for <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_DeploymentTargets.html">DeploymentTargets</a>.</p>
        pub fn set_organizational_unit_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.organizational_unit_ids = input;
            self
        }
        /// <p>Describes whether StackSets performs non-conflicting operations concurrently and queues conflicting operations.</p>
        pub fn managed_execution(mut self, input: crate::model::ManagedExecution) -> Self {
            self.managed_execution = Some(input);
            self
        }
        /// <p>Describes whether StackSets performs non-conflicting operations concurrently and queues conflicting operations.</p>
        pub fn set_managed_execution(
            mut self,
            input: std::option::Option<crate::model::ManagedExecution>,
        ) -> Self {
            self.managed_execution = input;
            self
        }
        /// Consumes the builder and constructs a [`StackSet`](crate::model::StackSet)
        pub fn build(self) -> crate::model::StackSet {
            crate::model::StackSet {
                stack_set_name: self.stack_set_name,
                stack_set_id: self.stack_set_id,
                description: self.description,
                status: self.status,
                template_body: self.template_body,
                parameters: self.parameters,
                capabilities: self.capabilities,
                tags: self.tags,
                stack_set_arn: self.stack_set_arn,
                administration_role_arn: self.administration_role_arn,
                execution_role_name: self.execution_role_name,
                stack_set_drift_detection_details: self.stack_set_drift_detection_details,
                auto_deployment: self.auto_deployment,
                permission_model: self.permission_model,
                organizational_unit_ids: self.organizational_unit_ids,
                managed_execution: self.managed_execution,
            }
        }
    }
}
impl StackSet {
    /// Creates a new builder-style object to manufacture [`StackSet`](crate::model::StackSet)
    pub fn builder() -> crate::model::stack_set::Builder {
        crate::model::stack_set::Builder::default()
    }
}

/// <p>The Stack data type.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Stack {
    /// <p>Unique identifier of the stack.</p>
    pub stack_id: std::option::Option<std::string::String>,
    /// <p>The name associated with the stack.</p>
    pub stack_name: std::option::Option<std::string::String>,
    /// <p>The unique ID of the change set.</p>
    pub change_set_id: std::option::Option<std::string::String>,
    /// <p>A user-defined description associated with the stack.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>A list of <code>Parameter</code> structures.</p>
    pub parameters: std::option::Option<std::vec::Vec<crate::model::Parameter>>,
    /// <p>The time at which the stack was created.</p>
    pub creation_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The time the stack was deleted.</p>
    pub deletion_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The time the stack was last updated. This field will only be returned if the stack has been updated at least once.</p>
    pub last_updated_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The rollback triggers for CloudFormation to monitor during stack creation and updating operations, and for the specified monitoring period afterwards.</p>
    pub rollback_configuration: std::option::Option<crate::model::RollbackConfiguration>,
    /// <p>Current status of the stack.</p>
    pub stack_status: std::option::Option<crate::model::StackStatus>,
    /// <p>Success/failure message associated with the stack status.</p>
    pub stack_status_reason: std::option::Option<std::string::String>,
    /// <p>Boolean to enable or disable rollback on stack creation failures:</p>
    /// <ul>
    /// <li> <p> <code>true</code>: disable rollback</p> </li>
    /// <li> <p> <code>false</code>: enable rollback</p> </li>
    /// </ul>
    pub disable_rollback: std::option::Option<bool>,
    /// <p>SNS topic ARNs to which stack related events are published.</p>
    pub notification_ar_ns: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The amount of time within which stack creation should complete.</p>
    pub timeout_in_minutes: std::option::Option<i32>,
    /// <p>The capabilities allowed in the stack.</p>
    pub capabilities: std::option::Option<std::vec::Vec<crate::model::Capability>>,
    /// <p>A list of output structures.</p>
    pub outputs: std::option::Option<std::vec::Vec<crate::model::Output>>,
    /// <p>The Amazon Resource Name (ARN) of an Identity and Access Management (IAM) role that is associated with the stack. During a stack operation, CloudFormation uses this role's credentials to make calls on your behalf.</p>
    pub role_arn: std::option::Option<std::string::String>,
    /// <p>A list of <code>Tag</code>s that specify information about the stack.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    /// <p>Whether termination protection is enabled for the stack.</p>
    /// <p> For <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-nested-stacks.html">nested stacks</a>, termination protection is set on the root stack and cannot be changed directly on the nested stack. For more information, see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-protect-stacks.html">Protecting a Stack From Being Deleted</a> in the <i>CloudFormation User Guide</i>.</p>
    pub enable_termination_protection: std::option::Option<bool>,
    /// <p>For nested stacks--stacks created as resources for another stack--the stack ID of the direct parent of this stack. For the first level of nested stacks, the root stack is also the parent stack.</p>
    /// <p>For more information, see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-nested-stacks.html">Working with Nested Stacks</a> in the <i>CloudFormation User Guide</i>.</p>
    pub parent_id: std::option::Option<std::string::String>,
    /// <p>For nested stacks--stacks created as resources for another stack--the stack ID of the top-level stack to which the nested stack ultimately belongs.</p>
    /// <p>For more information, see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-nested-stacks.html">Working with Nested Stacks</a> in the <i>CloudFormation User Guide</i>.</p>
    pub root_id: std::option::Option<std::string::String>,
    /// <p>Information on whether a stack's actual configuration differs, or has <i>drifted</i>, from it's expected configuration, as defined in the stack template and any values specified as template parameters. For more information, see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-stack-drift.html">Detecting Unregulated Configuration Changes to Stacks and Resources</a>.</p>
    pub drift_information: std::option::Option<crate::model::StackDriftInformation>,
}
impl Stack {
    /// <p>Unique identifier of the stack.</p>
    pub fn stack_id(&self) -> std::option::Option<&str> {
        self.stack_id.as_deref()
    }
    /// <p>The name associated with the stack.</p>
    pub fn stack_name(&self) -> std::option::Option<&str> {
        self.stack_name.as_deref()
    }
    /// <p>The unique ID of the change set.</p>
    pub fn change_set_id(&self) -> std::option::Option<&str> {
        self.change_set_id.as_deref()
    }
    /// <p>A user-defined description associated with the stack.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>A list of <code>Parameter</code> structures.</p>
    pub fn parameters(&self) -> std::option::Option<&[crate::model::Parameter]> {
        self.parameters.as_deref()
    }
    /// <p>The time at which the stack was created.</p>
    pub fn creation_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.creation_time.as_ref()
    }
    /// <p>The time the stack was deleted.</p>
    pub fn deletion_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.deletion_time.as_ref()
    }
    /// <p>The time the stack was last updated. This field will only be returned if the stack has been updated at least once.</p>
    pub fn last_updated_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_updated_time.as_ref()
    }
    /// <p>The rollback triggers for CloudFormation to monitor during stack creation and updating operations, and for the specified monitoring period afterwards.</p>
    pub fn rollback_configuration(
        &self,
    ) -> std::option::Option<&crate::model::RollbackConfiguration> {
        self.rollback_configuration.as_ref()
    }
    /// <p>Current status of the stack.</p>
    pub fn stack_status(&self) -> std::option::Option<&crate::model::StackStatus> {
        self.stack_status.as_ref()
    }
    /// <p>Success/failure message associated with the stack status.</p>
    pub fn stack_status_reason(&self) -> std::option::Option<&str> {
        self.stack_status_reason.as_deref()
    }
    /// <p>Boolean to enable or disable rollback on stack creation failures:</p>
    /// <ul>
    /// <li> <p> <code>true</code>: disable rollback</p> </li>
    /// <li> <p> <code>false</code>: enable rollback</p> </li>
    /// </ul>
    pub fn disable_rollback(&self) -> std::option::Option<bool> {
        self.disable_rollback
    }
    /// <p>SNS topic ARNs to which stack related events are published.</p>
    pub fn notification_ar_ns(&self) -> std::option::Option<&[std::string::String]> {
        self.notification_ar_ns.as_deref()
    }
    /// <p>The amount of time within which stack creation should complete.</p>
    pub fn timeout_in_minutes(&self) -> std::option::Option<i32> {
        self.timeout_in_minutes
    }
    /// <p>The capabilities allowed in the stack.</p>
    pub fn capabilities(&self) -> std::option::Option<&[crate::model::Capability]> {
        self.capabilities.as_deref()
    }
    /// <p>A list of output structures.</p>
    pub fn outputs(&self) -> std::option::Option<&[crate::model::Output]> {
        self.outputs.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of an Identity and Access Management (IAM) role that is associated with the stack. During a stack operation, CloudFormation uses this role's credentials to make calls on your behalf.</p>
    pub fn role_arn(&self) -> std::option::Option<&str> {
        self.role_arn.as_deref()
    }
    /// <p>A list of <code>Tag</code>s that specify information about the stack.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
    /// <p>Whether termination protection is enabled for the stack.</p>
    /// <p> For <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-nested-stacks.html">nested stacks</a>, termination protection is set on the root stack and cannot be changed directly on the nested stack. For more information, see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-protect-stacks.html">Protecting a Stack From Being Deleted</a> in the <i>CloudFormation User Guide</i>.</p>
    pub fn enable_termination_protection(&self) -> std::option::Option<bool> {
        self.enable_termination_protection
    }
    /// <p>For nested stacks--stacks created as resources for another stack--the stack ID of the direct parent of this stack. For the first level of nested stacks, the root stack is also the parent stack.</p>
    /// <p>For more information, see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-nested-stacks.html">Working with Nested Stacks</a> in the <i>CloudFormation User Guide</i>.</p>
    pub fn parent_id(&self) -> std::option::Option<&str> {
        self.parent_id.as_deref()
    }
    /// <p>For nested stacks--stacks created as resources for another stack--the stack ID of the top-level stack to which the nested stack ultimately belongs.</p>
    /// <p>For more information, see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-nested-stacks.html">Working with Nested Stacks</a> in the <i>CloudFormation User Guide</i>.</p>
    pub fn root_id(&self) -> std::option::Option<&str> {
        self.root_id.as_deref()
    }
    /// <p>Information on whether a stack's actual configuration differs, or has <i>drifted</i>, from it's expected configuration, as defined in the stack template and any values specified as template parameters. For more information, see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-stack-drift.html">Detecting Unregulated Configuration Changes to Stacks and Resources</a>.</p>
    pub fn drift_information(&self) -> std::option::Option<&crate::model::StackDriftInformation> {
        self.drift_information.as_ref()
    }
}
impl std::fmt::Debug for Stack {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Stack");
        formatter.field("stack_id", &self.stack_id);
        formatter.field("stack_name", &self.stack_name);
        formatter.field("change_set_id", &self.change_set_id);
        formatter.field("description", &self.description);
        formatter.field("parameters", &self.parameters);
        formatter.field("creation_time", &self.creation_time);
        formatter.field("deletion_time", &self.deletion_time);
        formatter.field("last_updated_time", &self.last_updated_time);
        formatter.field("rollback_configuration", &self.rollback_configuration);
        formatter.field("stack_status", &self.stack_status);
        formatter.field("stack_status_reason", &self.stack_status_reason);
        formatter.field("disable_rollback", &self.disable_rollback);
        formatter.field("notification_ar_ns", &self.notification_ar_ns);
        formatter.field("timeout_in_minutes", &self.timeout_in_minutes);
        formatter.field("capabilities", &self.capabilities);
        formatter.field("outputs", &self.outputs);
        formatter.field("role_arn", &self.role_arn);
        formatter.field("tags", &self.tags);
        formatter.field(
            "enable_termination_protection",
            &self.enable_termination_protection,
        );
        formatter.field("parent_id", &self.parent_id);
        formatter.field("root_id", &self.root_id);
        formatter.field("drift_information", &self.drift_information);
        formatter.finish()
    }
}
/// See [`Stack`](crate::model::Stack)
pub mod stack {
    /// A builder for [`Stack`](crate::model::Stack)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) stack_id: std::option::Option<std::string::String>,
        pub(crate) stack_name: std::option::Option<std::string::String>,
        pub(crate) change_set_id: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) parameters: std::option::Option<std::vec::Vec<crate::model::Parameter>>,
        pub(crate) creation_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) deletion_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) last_updated_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) rollback_configuration: std::option::Option<crate::model::RollbackConfiguration>,
        pub(crate) stack_status: std::option::Option<crate::model::StackStatus>,
        pub(crate) stack_status_reason: std::option::Option<std::string::String>,
        pub(crate) disable_rollback: std::option::Option<bool>,
        pub(crate) notification_ar_ns: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) timeout_in_minutes: std::option::Option<i32>,
        pub(crate) capabilities: std::option::Option<std::vec::Vec<crate::model::Capability>>,
        pub(crate) outputs: std::option::Option<std::vec::Vec<crate::model::Output>>,
        pub(crate) role_arn: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        pub(crate) enable_termination_protection: std::option::Option<bool>,
        pub(crate) parent_id: std::option::Option<std::string::String>,
        pub(crate) root_id: std::option::Option<std::string::String>,
        pub(crate) drift_information: std::option::Option<crate::model::StackDriftInformation>,
    }
    impl Builder {
        /// <p>Unique identifier of the stack.</p>
        pub fn stack_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.stack_id = Some(input.into());
            self
        }
        /// <p>Unique identifier of the stack.</p>
        pub fn set_stack_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.stack_id = input;
            self
        }
        /// <p>The name associated with the stack.</p>
        pub fn stack_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.stack_name = Some(input.into());
            self
        }
        /// <p>The name associated with the stack.</p>
        pub fn set_stack_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.stack_name = input;
            self
        }
        /// <p>The unique ID of the change set.</p>
        pub fn change_set_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.change_set_id = Some(input.into());
            self
        }
        /// <p>The unique ID of the change set.</p>
        pub fn set_change_set_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.change_set_id = input;
            self
        }
        /// <p>A user-defined description associated with the stack.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A user-defined description associated with the stack.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Appends an item to `parameters`.
        ///
        /// To override the contents of this collection use [`set_parameters`](Self::set_parameters).
        ///
        /// <p>A list of <code>Parameter</code> structures.</p>
        pub fn parameters(mut self, input: crate::model::Parameter) -> Self {
            let mut v = self.parameters.unwrap_or_default();
            v.push(input);
            self.parameters = Some(v);
            self
        }
        /// <p>A list of <code>Parameter</code> structures.</p>
        pub fn set_parameters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Parameter>>,
        ) -> Self {
            self.parameters = input;
            self
        }
        /// <p>The time at which the stack was created.</p>
        pub fn creation_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.creation_time = Some(input);
            self
        }
        /// <p>The time at which the stack was created.</p>
        pub fn set_creation_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.creation_time = input;
            self
        }
        /// <p>The time the stack was deleted.</p>
        pub fn deletion_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.deletion_time = Some(input);
            self
        }
        /// <p>The time the stack was deleted.</p>
        pub fn set_deletion_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.deletion_time = input;
            self
        }
        /// <p>The time the stack was last updated. This field will only be returned if the stack has been updated at least once.</p>
        pub fn last_updated_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_updated_time = Some(input);
            self
        }
        /// <p>The time the stack was last updated. This field will only be returned if the stack has been updated at least once.</p>
        pub fn set_last_updated_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_updated_time = input;
            self
        }
        /// <p>The rollback triggers for CloudFormation to monitor during stack creation and updating operations, and for the specified monitoring period afterwards.</p>
        pub fn rollback_configuration(
            mut self,
            input: crate::model::RollbackConfiguration,
        ) -> Self {
            self.rollback_configuration = Some(input);
            self
        }
        /// <p>The rollback triggers for CloudFormation to monitor during stack creation and updating operations, and for the specified monitoring period afterwards.</p>
        pub fn set_rollback_configuration(
            mut self,
            input: std::option::Option<crate::model::RollbackConfiguration>,
        ) -> Self {
            self.rollback_configuration = input;
            self
        }
        /// <p>Current status of the stack.</p>
        pub fn stack_status(mut self, input: crate::model::StackStatus) -> Self {
            self.stack_status = Some(input);
            self
        }
        /// <p>Current status of the stack.</p>
        pub fn set_stack_status(
            mut self,
            input: std::option::Option<crate::model::StackStatus>,
        ) -> Self {
            self.stack_status = input;
            self
        }
        /// <p>Success/failure message associated with the stack status.</p>
        pub fn stack_status_reason(mut self, input: impl Into<std::string::String>) -> Self {
            self.stack_status_reason = Some(input.into());
            self
        }
        /// <p>Success/failure message associated with the stack status.</p>
        pub fn set_stack_status_reason(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.stack_status_reason = input;
            self
        }
        /// <p>Boolean to enable or disable rollback on stack creation failures:</p>
        /// <ul>
        /// <li> <p> <code>true</code>: disable rollback</p> </li>
        /// <li> <p> <code>false</code>: enable rollback</p> </li>
        /// </ul>
        pub fn disable_rollback(mut self, input: bool) -> Self {
            self.disable_rollback = Some(input);
            self
        }
        /// <p>Boolean to enable or disable rollback on stack creation failures:</p>
        /// <ul>
        /// <li> <p> <code>true</code>: disable rollback</p> </li>
        /// <li> <p> <code>false</code>: enable rollback</p> </li>
        /// </ul>
        pub fn set_disable_rollback(mut self, input: std::option::Option<bool>) -> Self {
            self.disable_rollback = input;
            self
        }
        /// Appends an item to `notification_ar_ns`.
        ///
        /// To override the contents of this collection use [`set_notification_ar_ns`](Self::set_notification_ar_ns).
        ///
        /// <p>SNS topic ARNs to which stack related events are published.</p>
        pub fn notification_ar_ns(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.notification_ar_ns.unwrap_or_default();
            v.push(input.into());
            self.notification_ar_ns = Some(v);
            self
        }
        /// <p>SNS topic ARNs to which stack related events are published.</p>
        pub fn set_notification_ar_ns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.notification_ar_ns = input;
            self
        }
        /// <p>The amount of time within which stack creation should complete.</p>
        pub fn timeout_in_minutes(mut self, input: i32) -> Self {
            self.timeout_in_minutes = Some(input);
            self
        }
        /// <p>The amount of time within which stack creation should complete.</p>
        pub fn set_timeout_in_minutes(mut self, input: std::option::Option<i32>) -> Self {
            self.timeout_in_minutes = input;
            self
        }
        /// Appends an item to `capabilities`.
        ///
        /// To override the contents of this collection use [`set_capabilities`](Self::set_capabilities).
        ///
        /// <p>The capabilities allowed in the stack.</p>
        pub fn capabilities(mut self, input: crate::model::Capability) -> Self {
            let mut v = self.capabilities.unwrap_or_default();
            v.push(input);
            self.capabilities = Some(v);
            self
        }
        /// <p>The capabilities allowed in the stack.</p>
        pub fn set_capabilities(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Capability>>,
        ) -> Self {
            self.capabilities = input;
            self
        }
        /// Appends an item to `outputs`.
        ///
        /// To override the contents of this collection use [`set_outputs`](Self::set_outputs).
        ///
        /// <p>A list of output structures.</p>
        pub fn outputs(mut self, input: crate::model::Output) -> Self {
            let mut v = self.outputs.unwrap_or_default();
            v.push(input);
            self.outputs = Some(v);
            self
        }
        /// <p>A list of output structures.</p>
        pub fn set_outputs(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Output>>,
        ) -> Self {
            self.outputs = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of an Identity and Access Management (IAM) role that is associated with the stack. During a stack operation, CloudFormation uses this role's credentials to make calls on your behalf.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of an Identity and Access Management (IAM) role that is associated with the stack. During a stack operation, CloudFormation uses this role's credentials to make calls on your behalf.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_arn = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of <code>Tag</code>s that specify information about the stack.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input);
            self.tags = Some(v);
            self
        }
        /// <p>A list of <code>Tag</code>s that specify information about the stack.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>Whether termination protection is enabled for the stack.</p>
        /// <p> For <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-nested-stacks.html">nested stacks</a>, termination protection is set on the root stack and cannot be changed directly on the nested stack. For more information, see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-protect-stacks.html">Protecting a Stack From Being Deleted</a> in the <i>CloudFormation User Guide</i>.</p>
        pub fn enable_termination_protection(mut self, input: bool) -> Self {
            self.enable_termination_protection = Some(input);
            self
        }
        /// <p>Whether termination protection is enabled for the stack.</p>
        /// <p> For <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-nested-stacks.html">nested stacks</a>, termination protection is set on the root stack and cannot be changed directly on the nested stack. For more information, see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-protect-stacks.html">Protecting a Stack From Being Deleted</a> in the <i>CloudFormation User Guide</i>.</p>
        pub fn set_enable_termination_protection(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.enable_termination_protection = input;
            self
        }
        /// <p>For nested stacks--stacks created as resources for another stack--the stack ID of the direct parent of this stack. For the first level of nested stacks, the root stack is also the parent stack.</p>
        /// <p>For more information, see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-nested-stacks.html">Working with Nested Stacks</a> in the <i>CloudFormation User Guide</i>.</p>
        pub fn parent_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.parent_id = Some(input.into());
            self
        }
        /// <p>For nested stacks--stacks created as resources for another stack--the stack ID of the direct parent of this stack. For the first level of nested stacks, the root stack is also the parent stack.</p>
        /// <p>For more information, see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-nested-stacks.html">Working with Nested Stacks</a> in the <i>CloudFormation User Guide</i>.</p>
        pub fn set_parent_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.parent_id = input;
            self
        }
        /// <p>For nested stacks--stacks created as resources for another stack--the stack ID of the top-level stack to which the nested stack ultimately belongs.</p>
        /// <p>For more information, see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-nested-stacks.html">Working with Nested Stacks</a> in the <i>CloudFormation User Guide</i>.</p>
        pub fn root_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.root_id = Some(input.into());
            self
        }
        /// <p>For nested stacks--stacks created as resources for another stack--the stack ID of the top-level stack to which the nested stack ultimately belongs.</p>
        /// <p>For more information, see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-nested-stacks.html">Working with Nested Stacks</a> in the <i>CloudFormation User Guide</i>.</p>
        pub fn set_root_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.root_id = input;
            self
        }
        /// <p>Information on whether a stack's actual configuration differs, or has <i>drifted</i>, from it's expected configuration, as defined in the stack template and any values specified as template parameters. For more information, see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-stack-drift.html">Detecting Unregulated Configuration Changes to Stacks and Resources</a>.</p>
        pub fn drift_information(mut self, input: crate::model::StackDriftInformation) -> Self {
            self.drift_information = Some(input);
            self
        }
        /// <p>Information on whether a stack's actual configuration differs, or has <i>drifted</i>, from it's expected configuration, as defined in the stack template and any values specified as template parameters. For more information, see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-stack-drift.html">Detecting Unregulated Configuration Changes to Stacks and Resources</a>.</p>
        pub fn set_drift_information(
            mut self,
            input: std::option::Option<crate::model::StackDriftInformation>,
        ) -> Self {
            self.drift_information = input;
            self
        }
        /// Consumes the builder and constructs a [`Stack`](crate::model::Stack)
        pub fn build(self) -> crate::model::Stack {
            crate::model::Stack {
                stack_id: self.stack_id,
                stack_name: self.stack_name,
                change_set_id: self.change_set_id,
                description: self.description,
                parameters: self.parameters,
                creation_time: self.creation_time,
                deletion_time: self.deletion_time,
                last_updated_time: self.last_updated_time,
                rollback_configuration: self.rollback_configuration,
                stack_status: self.stack_status,
                stack_status_reason: self.stack_status_reason,
                disable_rollback: self.disable_rollback,
                notification_ar_ns: self.notification_ar_ns,
                timeout_in_minutes: self.timeout_in_minutes,
                capabilities: self.capabilities,
                outputs: self.outputs,
                role_arn: self.role_arn,
                tags: self.tags,
                enable_termination_protection: self.enable_termination_protection,
                parent_id: self.parent_id,
                root_id: self.root_id,
                drift_information: self.drift_information,
            }
        }
    }
}
impl Stack {
    /// Creates a new builder-style object to manufacture [`Stack`](crate::model::Stack)
    pub fn builder() -> crate::model::stack::Builder {
        crate::model::stack::Builder::default()
    }
}

/// <p>Contains information about whether the stack's actual configuration differs, or has <i>drifted</i>, from its expected configuration, as defined in the stack template and any values specified as template parameters. A stack is considered to have drifted if one or more of its resources have drifted.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StackDriftInformation {
    /// <p>Status of the stack's actual configuration compared to its expected template configuration. </p>
    /// <ul>
    /// <li> <p> <code>DRIFTED</code>: The stack differs from its expected template configuration. A stack is considered to have drifted if one or more of its resources have drifted.</p> </li>
    /// <li> <p> <code>NOT_CHECKED</code>: CloudFormation has not checked if the stack differs from its expected template configuration.</p> </li>
    /// <li> <p> <code>IN_SYNC</code>: The stack's actual configuration matches its expected template configuration.</p> </li>
    /// <li> <p> <code>UNKNOWN</code>: This value is reserved for future use.</p> </li>
    /// </ul>
    pub stack_drift_status: std::option::Option<crate::model::StackDriftStatus>,
    /// <p>Most recent time when a drift detection operation was initiated on the stack, or any of its individual resources that support drift detection.</p>
    pub last_check_timestamp: std::option::Option<aws_smithy_types::DateTime>,
}
impl StackDriftInformation {
    /// <p>Status of the stack's actual configuration compared to its expected template configuration. </p>
    /// <ul>
    /// <li> <p> <code>DRIFTED</code>: The stack differs from its expected template configuration. A stack is considered to have drifted if one or more of its resources have drifted.</p> </li>
    /// <li> <p> <code>NOT_CHECKED</code>: CloudFormation has not checked if the stack differs from its expected template configuration.</p> </li>
    /// <li> <p> <code>IN_SYNC</code>: The stack's actual configuration matches its expected template configuration.</p> </li>
    /// <li> <p> <code>UNKNOWN</code>: This value is reserved for future use.</p> </li>
    /// </ul>
    pub fn stack_drift_status(&self) -> std::option::Option<&crate::model::StackDriftStatus> {
        self.stack_drift_status.as_ref()
    }
    /// <p>Most recent time when a drift detection operation was initiated on the stack, or any of its individual resources that support drift detection.</p>
    pub fn last_check_timestamp(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_check_timestamp.as_ref()
    }
}
impl std::fmt::Debug for StackDriftInformation {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StackDriftInformation");
        formatter.field("stack_drift_status", &self.stack_drift_status);
        formatter.field("last_check_timestamp", &self.last_check_timestamp);
        formatter.finish()
    }
}
/// See [`StackDriftInformation`](crate::model::StackDriftInformation)
pub mod stack_drift_information {
    /// A builder for [`StackDriftInformation`](crate::model::StackDriftInformation)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) stack_drift_status: std::option::Option<crate::model::StackDriftStatus>,
        pub(crate) last_check_timestamp: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>Status of the stack's actual configuration compared to its expected template configuration. </p>
        /// <ul>
        /// <li> <p> <code>DRIFTED</code>: The stack differs from its expected template configuration. A stack is considered to have drifted if one or more of its resources have drifted.</p> </li>
        /// <li> <p> <code>NOT_CHECKED</code>: CloudFormation has not checked if the stack differs from its expected template configuration.</p> </li>
        /// <li> <p> <code>IN_SYNC</code>: The stack's actual configuration matches its expected template configuration.</p> </li>
        /// <li> <p> <code>UNKNOWN</code>: This value is reserved for future use.</p> </li>
        /// </ul>
        pub fn stack_drift_status(mut self, input: crate::model::StackDriftStatus) -> Self {
            self.stack_drift_status = Some(input);
            self
        }
        /// <p>Status of the stack's actual configuration compared to its expected template configuration. </p>
        /// <ul>
        /// <li> <p> <code>DRIFTED</code>: The stack differs from its expected template configuration. A stack is considered to have drifted if one or more of its resources have drifted.</p> </li>
        /// <li> <p> <code>NOT_CHECKED</code>: CloudFormation has not checked if the stack differs from its expected template configuration.</p> </li>
        /// <li> <p> <code>IN_SYNC</code>: The stack's actual configuration matches its expected template configuration.</p> </li>
        /// <li> <p> <code>UNKNOWN</code>: This value is reserved for future use.</p> </li>
        /// </ul>
        pub fn set_stack_drift_status(
            mut self,
            input: std::option::Option<crate::model::StackDriftStatus>,
        ) -> Self {
            self.stack_drift_status = input;
            self
        }
        /// <p>Most recent time when a drift detection operation was initiated on the stack, or any of its individual resources that support drift detection.</p>
        pub fn last_check_timestamp(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_check_timestamp = Some(input);
            self
        }
        /// <p>Most recent time when a drift detection operation was initiated on the stack, or any of its individual resources that support drift detection.</p>
        pub fn set_last_check_timestamp(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_check_timestamp = input;
            self
        }
        /// Consumes the builder and constructs a [`StackDriftInformation`](crate::model::StackDriftInformation)
        pub fn build(self) -> crate::model::StackDriftInformation {
            crate::model::StackDriftInformation {
                stack_drift_status: self.stack_drift_status,
                last_check_timestamp: self.last_check_timestamp,
            }
        }
    }
}
impl StackDriftInformation {
    /// Creates a new builder-style object to manufacture [`StackDriftInformation`](crate::model::StackDriftInformation)
    pub fn builder() -> crate::model::stack_drift_information::Builder {
        crate::model::stack_drift_information::Builder::default()
    }
}

/// <p>The Output data type.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Output {
    /// <p>The key associated with the output.</p>
    pub output_key: std::option::Option<std::string::String>,
    /// <p>The value associated with the output.</p>
    pub output_value: std::option::Option<std::string::String>,
    /// <p>User defined description associated with the output.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The name of the export associated with the output.</p>
    pub export_name: std::option::Option<std::string::String>,
}
impl Output {
    /// <p>The key associated with the output.</p>
    pub fn output_key(&self) -> std::option::Option<&str> {
        self.output_key.as_deref()
    }
    /// <p>The value associated with the output.</p>
    pub fn output_value(&self) -> std::option::Option<&str> {
        self.output_value.as_deref()
    }
    /// <p>User defined description associated with the output.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The name of the export associated with the output.</p>
    pub fn export_name(&self) -> std::option::Option<&str> {
        self.export_name.as_deref()
    }
}
impl std::fmt::Debug for Output {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Output");
        formatter.field("output_key", &self.output_key);
        formatter.field("output_value", &self.output_value);
        formatter.field("description", &self.description);
        formatter.field("export_name", &self.export_name);
        formatter.finish()
    }
}
/// See [`Output`](crate::model::Output)
pub mod output {
    /// A builder for [`Output`](crate::model::Output)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) output_key: std::option::Option<std::string::String>,
        pub(crate) output_value: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) export_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The key associated with the output.</p>
        pub fn output_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.output_key = Some(input.into());
            self
        }
        /// <p>The key associated with the output.</p>
        pub fn set_output_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.output_key = input;
            self
        }
        /// <p>The value associated with the output.</p>
        pub fn output_value(mut self, input: impl Into<std::string::String>) -> Self {
            self.output_value = Some(input.into());
            self
        }
        /// <p>The value associated with the output.</p>
        pub fn set_output_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.output_value = input;
            self
        }
        /// <p>User defined description associated with the output.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>User defined description associated with the output.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The name of the export associated with the output.</p>
        pub fn export_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.export_name = Some(input.into());
            self
        }
        /// <p>The name of the export associated with the output.</p>
        pub fn set_export_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.export_name = input;
            self
        }
        /// Consumes the builder and constructs a [`Output`](crate::model::Output)
        pub fn build(self) -> crate::model::Output {
            crate::model::Output {
                output_key: self.output_key,
                output_value: self.output_value,
                description: self.description,
                export_name: self.export_name,
            }
        }
    }
}
impl Output {
    /// Creates a new builder-style object to manufacture [`Output`](crate::model::Output)
    pub fn builder() -> crate::model::output::Builder {
        crate::model::output::Builder::default()
    }
}

/// <p>The StackResource data type.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StackResource {
    /// <p>The name associated with the stack.</p>
    pub stack_name: std::option::Option<std::string::String>,
    /// <p>Unique identifier of the stack.</p>
    pub stack_id: std::option::Option<std::string::String>,
    /// <p>The logical name of the resource specified in the template.</p>
    pub logical_resource_id: std::option::Option<std::string::String>,
    /// <p>The name or unique identifier that corresponds to a physical instance ID of a resource supported by CloudFormation.</p>
    pub physical_resource_id: std::option::Option<std::string::String>,
    /// <p>Type of resource. (For more information, go to <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-template-resource-type-ref.html">Amazon Web Services Resource Types Reference</a> in the CloudFormation User Guide.)</p>
    pub resource_type: std::option::Option<std::string::String>,
    /// <p>Time the status was updated.</p>
    pub timestamp: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>Current status of the resource.</p>
    pub resource_status: std::option::Option<crate::model::ResourceStatus>,
    /// <p>Success/failure message associated with the resource.</p>
    pub resource_status_reason: std::option::Option<std::string::String>,
    /// <p>User defined description associated with the resource.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>Information about whether the resource's actual configuration differs, or has <i>drifted</i>, from its expected configuration, as defined in the stack template and any values specified as template parameters. For more information, see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-stack-drift.html">Detecting Unregulated Configuration Changes to Stacks and Resources</a>.</p>
    pub drift_information: std::option::Option<crate::model::StackResourceDriftInformation>,
    /// <p>Contains information about the module from which the resource was created, if the resource was created from a module included in the stack template.</p>
    pub module_info: std::option::Option<crate::model::ModuleInfo>,
}
impl StackResource {
    /// <p>The name associated with the stack.</p>
    pub fn stack_name(&self) -> std::option::Option<&str> {
        self.stack_name.as_deref()
    }
    /// <p>Unique identifier of the stack.</p>
    pub fn stack_id(&self) -> std::option::Option<&str> {
        self.stack_id.as_deref()
    }
    /// <p>The logical name of the resource specified in the template.</p>
    pub fn logical_resource_id(&self) -> std::option::Option<&str> {
        self.logical_resource_id.as_deref()
    }
    /// <p>The name or unique identifier that corresponds to a physical instance ID of a resource supported by CloudFormation.</p>
    pub fn physical_resource_id(&self) -> std::option::Option<&str> {
        self.physical_resource_id.as_deref()
    }
    /// <p>Type of resource. (For more information, go to <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-template-resource-type-ref.html">Amazon Web Services Resource Types Reference</a> in the CloudFormation User Guide.)</p>
    pub fn resource_type(&self) -> std::option::Option<&str> {
        self.resource_type.as_deref()
    }
    /// <p>Time the status was updated.</p>
    pub fn timestamp(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.timestamp.as_ref()
    }
    /// <p>Current status of the resource.</p>
    pub fn resource_status(&self) -> std::option::Option<&crate::model::ResourceStatus> {
        self.resource_status.as_ref()
    }
    /// <p>Success/failure message associated with the resource.</p>
    pub fn resource_status_reason(&self) -> std::option::Option<&str> {
        self.resource_status_reason.as_deref()
    }
    /// <p>User defined description associated with the resource.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>Information about whether the resource's actual configuration differs, or has <i>drifted</i>, from its expected configuration, as defined in the stack template and any values specified as template parameters. For more information, see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-stack-drift.html">Detecting Unregulated Configuration Changes to Stacks and Resources</a>.</p>
    pub fn drift_information(
        &self,
    ) -> std::option::Option<&crate::model::StackResourceDriftInformation> {
        self.drift_information.as_ref()
    }
    /// <p>Contains information about the module from which the resource was created, if the resource was created from a module included in the stack template.</p>
    pub fn module_info(&self) -> std::option::Option<&crate::model::ModuleInfo> {
        self.module_info.as_ref()
    }
}
impl std::fmt::Debug for StackResource {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StackResource");
        formatter.field("stack_name", &self.stack_name);
        formatter.field("stack_id", &self.stack_id);
        formatter.field("logical_resource_id", &self.logical_resource_id);
        formatter.field("physical_resource_id", &self.physical_resource_id);
        formatter.field("resource_type", &self.resource_type);
        formatter.field("timestamp", &self.timestamp);
        formatter.field("resource_status", &self.resource_status);
        formatter.field("resource_status_reason", &self.resource_status_reason);
        formatter.field("description", &self.description);
        formatter.field("drift_information", &self.drift_information);
        formatter.field("module_info", &self.module_info);
        formatter.finish()
    }
}
/// See [`StackResource`](crate::model::StackResource)
pub mod stack_resource {
    /// A builder for [`StackResource`](crate::model::StackResource)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) stack_name: std::option::Option<std::string::String>,
        pub(crate) stack_id: std::option::Option<std::string::String>,
        pub(crate) logical_resource_id: std::option::Option<std::string::String>,
        pub(crate) physical_resource_id: std::option::Option<std::string::String>,
        pub(crate) resource_type: std::option::Option<std::string::String>,
        pub(crate) timestamp: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) resource_status: std::option::Option<crate::model::ResourceStatus>,
        pub(crate) resource_status_reason: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) drift_information:
            std::option::Option<crate::model::StackResourceDriftInformation>,
        pub(crate) module_info: std::option::Option<crate::model::ModuleInfo>,
    }
    impl Builder {
        /// <p>The name associated with the stack.</p>
        pub fn stack_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.stack_name = Some(input.into());
            self
        }
        /// <p>The name associated with the stack.</p>
        pub fn set_stack_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.stack_name = input;
            self
        }
        /// <p>Unique identifier of the stack.</p>
        pub fn stack_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.stack_id = Some(input.into());
            self
        }
        /// <p>Unique identifier of the stack.</p>
        pub fn set_stack_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.stack_id = input;
            self
        }
        /// <p>The logical name of the resource specified in the template.</p>
        pub fn logical_resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.logical_resource_id = Some(input.into());
            self
        }
        /// <p>The logical name of the resource specified in the template.</p>
        pub fn set_logical_resource_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.logical_resource_id = input;
            self
        }
        /// <p>The name or unique identifier that corresponds to a physical instance ID of a resource supported by CloudFormation.</p>
        pub fn physical_resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.physical_resource_id = Some(input.into());
            self
        }
        /// <p>The name or unique identifier that corresponds to a physical instance ID of a resource supported by CloudFormation.</p>
        pub fn set_physical_resource_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.physical_resource_id = input;
            self
        }
        /// <p>Type of resource. (For more information, go to <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-template-resource-type-ref.html">Amazon Web Services Resource Types Reference</a> in the CloudFormation User Guide.)</p>
        pub fn resource_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_type = Some(input.into());
            self
        }
        /// <p>Type of resource. (For more information, go to <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-template-resource-type-ref.html">Amazon Web Services Resource Types Reference</a> in the CloudFormation User Guide.)</p>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_type = input;
            self
        }
        /// <p>Time the status was updated.</p>
        pub fn timestamp(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.timestamp = Some(input);
            self
        }
        /// <p>Time the status was updated.</p>
        pub fn set_timestamp(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.timestamp = input;
            self
        }
        /// <p>Current status of the resource.</p>
        pub fn resource_status(mut self, input: crate::model::ResourceStatus) -> Self {
            self.resource_status = Some(input);
            self
        }
        /// <p>Current status of the resource.</p>
        pub fn set_resource_status(
            mut self,
            input: std::option::Option<crate::model::ResourceStatus>,
        ) -> Self {
            self.resource_status = input;
            self
        }
        /// <p>Success/failure message associated with the resource.</p>
        pub fn resource_status_reason(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_status_reason = Some(input.into());
            self
        }
        /// <p>Success/failure message associated with the resource.</p>
        pub fn set_resource_status_reason(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_status_reason = input;
            self
        }
        /// <p>User defined description associated with the resource.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>User defined description associated with the resource.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>Information about whether the resource's actual configuration differs, or has <i>drifted</i>, from its expected configuration, as defined in the stack template and any values specified as template parameters. For more information, see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-stack-drift.html">Detecting Unregulated Configuration Changes to Stacks and Resources</a>.</p>
        pub fn drift_information(
            mut self,
            input: crate::model::StackResourceDriftInformation,
        ) -> Self {
            self.drift_information = Some(input);
            self
        }
        /// <p>Information about whether the resource's actual configuration differs, or has <i>drifted</i>, from its expected configuration, as defined in the stack template and any values specified as template parameters. For more information, see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-stack-drift.html">Detecting Unregulated Configuration Changes to Stacks and Resources</a>.</p>
        pub fn set_drift_information(
            mut self,
            input: std::option::Option<crate::model::StackResourceDriftInformation>,
        ) -> Self {
            self.drift_information = input;
            self
        }
        /// <p>Contains information about the module from which the resource was created, if the resource was created from a module included in the stack template.</p>
        pub fn module_info(mut self, input: crate::model::ModuleInfo) -> Self {
            self.module_info = Some(input);
            self
        }
        /// <p>Contains information about the module from which the resource was created, if the resource was created from a module included in the stack template.</p>
        pub fn set_module_info(
            mut self,
            input: std::option::Option<crate::model::ModuleInfo>,
        ) -> Self {
            self.module_info = input;
            self
        }
        /// Consumes the builder and constructs a [`StackResource`](crate::model::StackResource)
        pub fn build(self) -> crate::model::StackResource {
            crate::model::StackResource {
                stack_name: self.stack_name,
                stack_id: self.stack_id,
                logical_resource_id: self.logical_resource_id,
                physical_resource_id: self.physical_resource_id,
                resource_type: self.resource_type,
                timestamp: self.timestamp,
                resource_status: self.resource_status,
                resource_status_reason: self.resource_status_reason,
                description: self.description,
                drift_information: self.drift_information,
                module_info: self.module_info,
            }
        }
    }
}
impl StackResource {
    /// Creates a new builder-style object to manufacture [`StackResource`](crate::model::StackResource)
    pub fn builder() -> crate::model::stack_resource::Builder {
        crate::model::stack_resource::Builder::default()
    }
}

/// <p>Contains information about whether the resource's actual configuration differs, or has <i>drifted</i>, from its expected configuration.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StackResourceDriftInformation {
    /// <p>Status of the resource's actual configuration compared to its expected configuration</p>
    /// <ul>
    /// <li> <p> <code>DELETED</code>: The resource differs from its expected configuration in that it has been deleted.</p> </li>
    /// <li> <p> <code>MODIFIED</code>: The resource differs from its expected configuration.</p> </li>
    /// <li> <p> <code>NOT_CHECKED</code>: CloudFormation has not checked if the resource differs from its expected configuration.</p> <p>Any resources that do not currently support drift detection have a status of <code>NOT_CHECKED</code>. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-stack-drift-resource-list.html">Resources that Support Drift Detection</a>. </p> </li>
    /// <li> <p> <code>IN_SYNC</code>: The resources's actual configuration matches its expected configuration.</p> </li>
    /// </ul>
    pub stack_resource_drift_status: std::option::Option<crate::model::StackResourceDriftStatus>,
    /// <p>When CloudFormation last checked if the resource had drifted from its expected configuration.</p>
    pub last_check_timestamp: std::option::Option<aws_smithy_types::DateTime>,
}
impl StackResourceDriftInformation {
    /// <p>Status of the resource's actual configuration compared to its expected configuration</p>
    /// <ul>
    /// <li> <p> <code>DELETED</code>: The resource differs from its expected configuration in that it has been deleted.</p> </li>
    /// <li> <p> <code>MODIFIED</code>: The resource differs from its expected configuration.</p> </li>
    /// <li> <p> <code>NOT_CHECKED</code>: CloudFormation has not checked if the resource differs from its expected configuration.</p> <p>Any resources that do not currently support drift detection have a status of <code>NOT_CHECKED</code>. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-stack-drift-resource-list.html">Resources that Support Drift Detection</a>. </p> </li>
    /// <li> <p> <code>IN_SYNC</code>: The resources's actual configuration matches its expected configuration.</p> </li>
    /// </ul>
    pub fn stack_resource_drift_status(
        &self,
    ) -> std::option::Option<&crate::model::StackResourceDriftStatus> {
        self.stack_resource_drift_status.as_ref()
    }
    /// <p>When CloudFormation last checked if the resource had drifted from its expected configuration.</p>
    pub fn last_check_timestamp(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_check_timestamp.as_ref()
    }
}
impl std::fmt::Debug for StackResourceDriftInformation {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StackResourceDriftInformation");
        formatter.field(
            "stack_resource_drift_status",
            &self.stack_resource_drift_status,
        );
        formatter.field("last_check_timestamp", &self.last_check_timestamp);
        formatter.finish()
    }
}
/// See [`StackResourceDriftInformation`](crate::model::StackResourceDriftInformation)
pub mod stack_resource_drift_information {
    /// A builder for [`StackResourceDriftInformation`](crate::model::StackResourceDriftInformation)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) stack_resource_drift_status:
            std::option::Option<crate::model::StackResourceDriftStatus>,
        pub(crate) last_check_timestamp: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>Status of the resource's actual configuration compared to its expected configuration</p>
        /// <ul>
        /// <li> <p> <code>DELETED</code>: The resource differs from its expected configuration in that it has been deleted.</p> </li>
        /// <li> <p> <code>MODIFIED</code>: The resource differs from its expected configuration.</p> </li>
        /// <li> <p> <code>NOT_CHECKED</code>: CloudFormation has not checked if the resource differs from its expected configuration.</p> <p>Any resources that do not currently support drift detection have a status of <code>NOT_CHECKED</code>. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-stack-drift-resource-list.html">Resources that Support Drift Detection</a>. </p> </li>
        /// <li> <p> <code>IN_SYNC</code>: The resources's actual configuration matches its expected configuration.</p> </li>
        /// </ul>
        pub fn stack_resource_drift_status(
            mut self,
            input: crate::model::StackResourceDriftStatus,
        ) -> Self {
            self.stack_resource_drift_status = Some(input);
            self
        }
        /// <p>Status of the resource's actual configuration compared to its expected configuration</p>
        /// <ul>
        /// <li> <p> <code>DELETED</code>: The resource differs from its expected configuration in that it has been deleted.</p> </li>
        /// <li> <p> <code>MODIFIED</code>: The resource differs from its expected configuration.</p> </li>
        /// <li> <p> <code>NOT_CHECKED</code>: CloudFormation has not checked if the resource differs from its expected configuration.</p> <p>Any resources that do not currently support drift detection have a status of <code>NOT_CHECKED</code>. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-stack-drift-resource-list.html">Resources that Support Drift Detection</a>. </p> </li>
        /// <li> <p> <code>IN_SYNC</code>: The resources's actual configuration matches its expected configuration.</p> </li>
        /// </ul>
        pub fn set_stack_resource_drift_status(
            mut self,
            input: std::option::Option<crate::model::StackResourceDriftStatus>,
        ) -> Self {
            self.stack_resource_drift_status = input;
            self
        }
        /// <p>When CloudFormation last checked if the resource had drifted from its expected configuration.</p>
        pub fn last_check_timestamp(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_check_timestamp = Some(input);
            self
        }
        /// <p>When CloudFormation last checked if the resource had drifted from its expected configuration.</p>
        pub fn set_last_check_timestamp(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_check_timestamp = input;
            self
        }
        /// Consumes the builder and constructs a [`StackResourceDriftInformation`](crate::model::StackResourceDriftInformation)
        pub fn build(self) -> crate::model::StackResourceDriftInformation {
            crate::model::StackResourceDriftInformation {
                stack_resource_drift_status: self.stack_resource_drift_status,
                last_check_timestamp: self.last_check_timestamp,
            }
        }
    }
}
impl StackResourceDriftInformation {
    /// Creates a new builder-style object to manufacture [`StackResourceDriftInformation`](crate::model::StackResourceDriftInformation)
    pub fn builder() -> crate::model::stack_resource_drift_information::Builder {
        crate::model::stack_resource_drift_information::Builder::default()
    }
}

/// <p>Contains detailed information about the specified stack resource.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StackResourceDetail {
    /// <p>The name associated with the stack.</p>
    pub stack_name: std::option::Option<std::string::String>,
    /// <p>Unique identifier of the stack.</p>
    pub stack_id: std::option::Option<std::string::String>,
    /// <p>The logical name of the resource specified in the template.</p>
    pub logical_resource_id: std::option::Option<std::string::String>,
    /// <p>The name or unique identifier that corresponds to a physical instance ID of a resource supported by CloudFormation.</p>
    pub physical_resource_id: std::option::Option<std::string::String>,
    /// <p>Type of resource. ((For more information, go to <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-template-resource-type-ref.html">Amazon Web Services Resource Types Reference</a> in the CloudFormation User Guide.)</p>
    pub resource_type: std::option::Option<std::string::String>,
    /// <p>Time the status was updated.</p>
    pub last_updated_timestamp: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>Current status of the resource.</p>
    pub resource_status: std::option::Option<crate::model::ResourceStatus>,
    /// <p>Success/failure message associated with the resource.</p>
    pub resource_status_reason: std::option::Option<std::string::String>,
    /// <p>User defined description associated with the resource.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The content of the <code>Metadata</code> attribute declared for the resource. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-attribute-metadata.html">Metadata Attribute</a> in the CloudFormation User Guide.</p>
    pub metadata: std::option::Option<std::string::String>,
    /// <p>Information about whether the resource's actual configuration differs, or has <i>drifted</i>, from its expected configuration, as defined in the stack template and any values specified as template parameters. For more information, see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-stack-drift.html">Detecting Unregulated Configuration Changes to Stacks and Resources</a>.</p>
    pub drift_information: std::option::Option<crate::model::StackResourceDriftInformation>,
    /// <p>Contains information about the module from which the resource was created, if the resource was created from a module included in the stack template.</p>
    pub module_info: std::option::Option<crate::model::ModuleInfo>,
}
impl StackResourceDetail {
    /// <p>The name associated with the stack.</p>
    pub fn stack_name(&self) -> std::option::Option<&str> {
        self.stack_name.as_deref()
    }
    /// <p>Unique identifier of the stack.</p>
    pub fn stack_id(&self) -> std::option::Option<&str> {
        self.stack_id.as_deref()
    }
    /// <p>The logical name of the resource specified in the template.</p>
    pub fn logical_resource_id(&self) -> std::option::Option<&str> {
        self.logical_resource_id.as_deref()
    }
    /// <p>The name or unique identifier that corresponds to a physical instance ID of a resource supported by CloudFormation.</p>
    pub fn physical_resource_id(&self) -> std::option::Option<&str> {
        self.physical_resource_id.as_deref()
    }
    /// <p>Type of resource. ((For more information, go to <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-template-resource-type-ref.html">Amazon Web Services Resource Types Reference</a> in the CloudFormation User Guide.)</p>
    pub fn resource_type(&self) -> std::option::Option<&str> {
        self.resource_type.as_deref()
    }
    /// <p>Time the status was updated.</p>
    pub fn last_updated_timestamp(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_updated_timestamp.as_ref()
    }
    /// <p>Current status of the resource.</p>
    pub fn resource_status(&self) -> std::option::Option<&crate::model::ResourceStatus> {
        self.resource_status.as_ref()
    }
    /// <p>Success/failure message associated with the resource.</p>
    pub fn resource_status_reason(&self) -> std::option::Option<&str> {
        self.resource_status_reason.as_deref()
    }
    /// <p>User defined description associated with the resource.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The content of the <code>Metadata</code> attribute declared for the resource. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-attribute-metadata.html">Metadata Attribute</a> in the CloudFormation User Guide.</p>
    pub fn metadata(&self) -> std::option::Option<&str> {
        self.metadata.as_deref()
    }
    /// <p>Information about whether the resource's actual configuration differs, or has <i>drifted</i>, from its expected configuration, as defined in the stack template and any values specified as template parameters. For more information, see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-stack-drift.html">Detecting Unregulated Configuration Changes to Stacks and Resources</a>.</p>
    pub fn drift_information(
        &self,
    ) -> std::option::Option<&crate::model::StackResourceDriftInformation> {
        self.drift_information.as_ref()
    }
    /// <p>Contains information about the module from which the resource was created, if the resource was created from a module included in the stack template.</p>
    pub fn module_info(&self) -> std::option::Option<&crate::model::ModuleInfo> {
        self.module_info.as_ref()
    }
}
impl std::fmt::Debug for StackResourceDetail {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StackResourceDetail");
        formatter.field("stack_name", &self.stack_name);
        formatter.field("stack_id", &self.stack_id);
        formatter.field("logical_resource_id", &self.logical_resource_id);
        formatter.field("physical_resource_id", &self.physical_resource_id);
        formatter.field("resource_type", &self.resource_type);
        formatter.field("last_updated_timestamp", &self.last_updated_timestamp);
        formatter.field("resource_status", &self.resource_status);
        formatter.field("resource_status_reason", &self.resource_status_reason);
        formatter.field("description", &self.description);
        formatter.field("metadata", &self.metadata);
        formatter.field("drift_information", &self.drift_information);
        formatter.field("module_info", &self.module_info);
        formatter.finish()
    }
}
/// See [`StackResourceDetail`](crate::model::StackResourceDetail)
pub mod stack_resource_detail {
    /// A builder for [`StackResourceDetail`](crate::model::StackResourceDetail)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) stack_name: std::option::Option<std::string::String>,
        pub(crate) stack_id: std::option::Option<std::string::String>,
        pub(crate) logical_resource_id: std::option::Option<std::string::String>,
        pub(crate) physical_resource_id: std::option::Option<std::string::String>,
        pub(crate) resource_type: std::option::Option<std::string::String>,
        pub(crate) last_updated_timestamp: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) resource_status: std::option::Option<crate::model::ResourceStatus>,
        pub(crate) resource_status_reason: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) metadata: std::option::Option<std::string::String>,
        pub(crate) drift_information:
            std::option::Option<crate::model::StackResourceDriftInformation>,
        pub(crate) module_info: std::option::Option<crate::model::ModuleInfo>,
    }
    impl Builder {
        /// <p>The name associated with the stack.</p>
        pub fn stack_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.stack_name = Some(input.into());
            self
        }
        /// <p>The name associated with the stack.</p>
        pub fn set_stack_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.stack_name = input;
            self
        }
        /// <p>Unique identifier of the stack.</p>
        pub fn stack_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.stack_id = Some(input.into());
            self
        }
        /// <p>Unique identifier of the stack.</p>
        pub fn set_stack_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.stack_id = input;
            self
        }
        /// <p>The logical name of the resource specified in the template.</p>
        pub fn logical_resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.logical_resource_id = Some(input.into());
            self
        }
        /// <p>The logical name of the resource specified in the template.</p>
        pub fn set_logical_resource_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.logical_resource_id = input;
            self
        }
        /// <p>The name or unique identifier that corresponds to a physical instance ID of a resource supported by CloudFormation.</p>
        pub fn physical_resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.physical_resource_id = Some(input.into());
            self
        }
        /// <p>The name or unique identifier that corresponds to a physical instance ID of a resource supported by CloudFormation.</p>
        pub fn set_physical_resource_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.physical_resource_id = input;
            self
        }
        /// <p>Type of resource. ((For more information, go to <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-template-resource-type-ref.html">Amazon Web Services Resource Types Reference</a> in the CloudFormation User Guide.)</p>
        pub fn resource_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_type = Some(input.into());
            self
        }
        /// <p>Type of resource. ((For more information, go to <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-template-resource-type-ref.html">Amazon Web Services Resource Types Reference</a> in the CloudFormation User Guide.)</p>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_type = input;
            self
        }
        /// <p>Time the status was updated.</p>
        pub fn last_updated_timestamp(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_updated_timestamp = Some(input);
            self
        }
        /// <p>Time the status was updated.</p>
        pub fn set_last_updated_timestamp(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_updated_timestamp = input;
            self
        }
        /// <p>Current status of the resource.</p>
        pub fn resource_status(mut self, input: crate::model::ResourceStatus) -> Self {
            self.resource_status = Some(input);
            self
        }
        /// <p>Current status of the resource.</p>
        pub fn set_resource_status(
            mut self,
            input: std::option::Option<crate::model::ResourceStatus>,
        ) -> Self {
            self.resource_status = input;
            self
        }
        /// <p>Success/failure message associated with the resource.</p>
        pub fn resource_status_reason(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_status_reason = Some(input.into());
            self
        }
        /// <p>Success/failure message associated with the resource.</p>
        pub fn set_resource_status_reason(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_status_reason = input;
            self
        }
        /// <p>User defined description associated with the resource.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>User defined description associated with the resource.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The content of the <code>Metadata</code> attribute declared for the resource. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-attribute-metadata.html">Metadata Attribute</a> in the CloudFormation User Guide.</p>
        pub fn metadata(mut self, input: impl Into<std::string::String>) -> Self {
            self.metadata = Some(input.into());
            self
        }
        /// <p>The content of the <code>Metadata</code> attribute declared for the resource. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-attribute-metadata.html">Metadata Attribute</a> in the CloudFormation User Guide.</p>
        pub fn set_metadata(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.metadata = input;
            self
        }
        /// <p>Information about whether the resource's actual configuration differs, or has <i>drifted</i>, from its expected configuration, as defined in the stack template and any values specified as template parameters. For more information, see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-stack-drift.html">Detecting Unregulated Configuration Changes to Stacks and Resources</a>.</p>
        pub fn drift_information(
            mut self,
            input: crate::model::StackResourceDriftInformation,
        ) -> Self {
            self.drift_information = Some(input);
            self
        }
        /// <p>Information about whether the resource's actual configuration differs, or has <i>drifted</i>, from its expected configuration, as defined in the stack template and any values specified as template parameters. For more information, see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-stack-drift.html">Detecting Unregulated Configuration Changes to Stacks and Resources</a>.</p>
        pub fn set_drift_information(
            mut self,
            input: std::option::Option<crate::model::StackResourceDriftInformation>,
        ) -> Self {
            self.drift_information = input;
            self
        }
        /// <p>Contains information about the module from which the resource was created, if the resource was created from a module included in the stack template.</p>
        pub fn module_info(mut self, input: crate::model::ModuleInfo) -> Self {
            self.module_info = Some(input);
            self
        }
        /// <p>Contains information about the module from which the resource was created, if the resource was created from a module included in the stack template.</p>
        pub fn set_module_info(
            mut self,
            input: std::option::Option<crate::model::ModuleInfo>,
        ) -> Self {
            self.module_info = input;
            self
        }
        /// Consumes the builder and constructs a [`StackResourceDetail`](crate::model::StackResourceDetail)
        pub fn build(self) -> crate::model::StackResourceDetail {
            crate::model::StackResourceDetail {
                stack_name: self.stack_name,
                stack_id: self.stack_id,
                logical_resource_id: self.logical_resource_id,
                physical_resource_id: self.physical_resource_id,
                resource_type: self.resource_type,
                last_updated_timestamp: self.last_updated_timestamp,
                resource_status: self.resource_status,
                resource_status_reason: self.resource_status_reason,
                description: self.description,
                metadata: self.metadata,
                drift_information: self.drift_information,
                module_info: self.module_info,
            }
        }
    }
}
impl StackResourceDetail {
    /// Creates a new builder-style object to manufacture [`StackResourceDetail`](crate::model::StackResourceDetail)
    pub fn builder() -> crate::model::stack_resource_detail::Builder {
        crate::model::stack_resource_detail::Builder::default()
    }
}

/// <p>An CloudFormation stack, in a specific account and Region, that's part of a stack set operation. A stack instance is a reference to an attempted or actual stack in a given account within a given Region. A stack instance can exist without a stack—for example, if the stack couldn't be created for some reason. A stack instance is associated with only one stack set. Each stack instance contains the ID of its associated stack set, as well as the ID of the actual stack and the stack status.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StackInstance {
    /// <p>The name or unique ID of the stack set that the stack instance is associated with.</p>
    pub stack_set_id: std::option::Option<std::string::String>,
    /// <p>The name of the Amazon Web Services Region that the stack instance is associated with.</p>
    pub region: std::option::Option<std::string::String>,
    /// <p>[Self-managed permissions] The name of the Amazon Web Services account that the stack instance is associated with.</p>
    pub account: std::option::Option<std::string::String>,
    /// <p>The ID of the stack instance.</p>
    pub stack_id: std::option::Option<std::string::String>,
    /// <p>A list of parameters from the stack set template whose values have been overridden in this stack instance.</p>
    pub parameter_overrides: std::option::Option<std::vec::Vec<crate::model::Parameter>>,
    /// <p>The status of the stack instance, in terms of its synchronization with its associated stack set.</p>
    /// <ul>
    /// <li> <p> <code>INOPERABLE</code>: A <code>DeleteStackInstances</code> operation has failed and left the stack in an unstable state. Stacks in this state are excluded from further <code>UpdateStackSet</code> operations. You might need to perform a <code>DeleteStackInstances</code> operation, with <code>RetainStacks</code> set to <code>true</code>, to delete the stack instance, and then delete the stack manually.</p> </li>
    /// <li> <p> <code>OUTDATED</code>: The stack isn't currently up to date with the stack set because:</p>
    /// <ul>
    /// <li> <p>The associated stack failed during a <code>CreateStackSet</code> or <code>UpdateStackSet</code> operation. </p> </li>
    /// <li> <p>The stack was part of a <code>CreateStackSet</code> or <code>UpdateStackSet</code> operation that failed or was stopped before the stack was created or updated. </p> </li>
    /// </ul> </li>
    /// <li> <p> <code>CURRENT</code>: The stack is currently up to date with the stack set.</p> </li>
    /// </ul>
    pub status: std::option::Option<crate::model::StackInstanceStatus>,
    /// <p>The detailed status of the stack instance.</p>
    pub stack_instance_status: std::option::Option<crate::model::StackInstanceComprehensiveStatus>,
    /// <p>The explanation for the specific status code that is assigned to this stack instance.</p>
    pub status_reason: std::option::Option<std::string::String>,
    /// <p>[Service-managed permissions] The organization root ID or organizational unit (OU) IDs that you specified for <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_DeploymentTargets.html">DeploymentTargets</a>.</p>
    pub organizational_unit_id: std::option::Option<std::string::String>,
    /// <p>Status of the stack instance's actual configuration compared to the expected template and parameter configuration of the stack set to which it belongs. </p>
    /// <ul>
    /// <li> <p> <code>DRIFTED</code>: The stack differs from the expected template and parameter configuration of the stack set to which it belongs. A stack instance is considered to have drifted if one or more of the resources in the associated stack have drifted.</p> </li>
    /// <li> <p> <code>NOT_CHECKED</code>: CloudFormation has not checked if the stack instance differs from its expected stack set configuration.</p> </li>
    /// <li> <p> <code>IN_SYNC</code>: The stack instance's actual configuration matches its expected stack set configuration.</p> </li>
    /// <li> <p> <code>UNKNOWN</code>: This value is reserved for future use.</p> </li>
    /// </ul>
    pub drift_status: std::option::Option<crate::model::StackDriftStatus>,
    /// <p>Most recent time when CloudFormation performed a drift detection operation on the stack instance. This value will be <code>NULL</code> for any stack instance on which drift detection has not yet been performed.</p>
    pub last_drift_check_timestamp: std::option::Option<aws_smithy_types::DateTime>,
}
impl StackInstance {
    /// <p>The name or unique ID of the stack set that the stack instance is associated with.</p>
    pub fn stack_set_id(&self) -> std::option::Option<&str> {
        self.stack_set_id.as_deref()
    }
    /// <p>The name of the Amazon Web Services Region that the stack instance is associated with.</p>
    pub fn region(&self) -> std::option::Option<&str> {
        self.region.as_deref()
    }
    /// <p>[Self-managed permissions] The name of the Amazon Web Services account that the stack instance is associated with.</p>
    pub fn account(&self) -> std::option::Option<&str> {
        self.account.as_deref()
    }
    /// <p>The ID of the stack instance.</p>
    pub fn stack_id(&self) -> std::option::Option<&str> {
        self.stack_id.as_deref()
    }
    /// <p>A list of parameters from the stack set template whose values have been overridden in this stack instance.</p>
    pub fn parameter_overrides(&self) -> std::option::Option<&[crate::model::Parameter]> {
        self.parameter_overrides.as_deref()
    }
    /// <p>The status of the stack instance, in terms of its synchronization with its associated stack set.</p>
    /// <ul>
    /// <li> <p> <code>INOPERABLE</code>: A <code>DeleteStackInstances</code> operation has failed and left the stack in an unstable state. Stacks in this state are excluded from further <code>UpdateStackSet</code> operations. You might need to perform a <code>DeleteStackInstances</code> operation, with <code>RetainStacks</code> set to <code>true</code>, to delete the stack instance, and then delete the stack manually.</p> </li>
    /// <li> <p> <code>OUTDATED</code>: The stack isn't currently up to date with the stack set because:</p>
    /// <ul>
    /// <li> <p>The associated stack failed during a <code>CreateStackSet</code> or <code>UpdateStackSet</code> operation. </p> </li>
    /// <li> <p>The stack was part of a <code>CreateStackSet</code> or <code>UpdateStackSet</code> operation that failed or was stopped before the stack was created or updated. </p> </li>
    /// </ul> </li>
    /// <li> <p> <code>CURRENT</code>: The stack is currently up to date with the stack set.</p> </li>
    /// </ul>
    pub fn status(&self) -> std::option::Option<&crate::model::StackInstanceStatus> {
        self.status.as_ref()
    }
    /// <p>The detailed status of the stack instance.</p>
    pub fn stack_instance_status(
        &self,
    ) -> std::option::Option<&crate::model::StackInstanceComprehensiveStatus> {
        self.stack_instance_status.as_ref()
    }
    /// <p>The explanation for the specific status code that is assigned to this stack instance.</p>
    pub fn status_reason(&self) -> std::option::Option<&str> {
        self.status_reason.as_deref()
    }
    /// <p>[Service-managed permissions] The organization root ID or organizational unit (OU) IDs that you specified for <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_DeploymentTargets.html">DeploymentTargets</a>.</p>
    pub fn organizational_unit_id(&self) -> std::option::Option<&str> {
        self.organizational_unit_id.as_deref()
    }
    /// <p>Status of the stack instance's actual configuration compared to the expected template and parameter configuration of the stack set to which it belongs. </p>
    /// <ul>
    /// <li> <p> <code>DRIFTED</code>: The stack differs from the expected template and parameter configuration of the stack set to which it belongs. A stack instance is considered to have drifted if one or more of the resources in the associated stack have drifted.</p> </li>
    /// <li> <p> <code>NOT_CHECKED</code>: CloudFormation has not checked if the stack instance differs from its expected stack set configuration.</p> </li>
    /// <li> <p> <code>IN_SYNC</code>: The stack instance's actual configuration matches its expected stack set configuration.</p> </li>
    /// <li> <p> <code>UNKNOWN</code>: This value is reserved for future use.</p> </li>
    /// </ul>
    pub fn drift_status(&self) -> std::option::Option<&crate::model::StackDriftStatus> {
        self.drift_status.as_ref()
    }
    /// <p>Most recent time when CloudFormation performed a drift detection operation on the stack instance. This value will be <code>NULL</code> for any stack instance on which drift detection has not yet been performed.</p>
    pub fn last_drift_check_timestamp(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_drift_check_timestamp.as_ref()
    }
}
impl std::fmt::Debug for StackInstance {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StackInstance");
        formatter.field("stack_set_id", &self.stack_set_id);
        formatter.field("region", &self.region);
        formatter.field("account", &self.account);
        formatter.field("stack_id", &self.stack_id);
        formatter.field("parameter_overrides", &self.parameter_overrides);
        formatter.field("status", &self.status);
        formatter.field("stack_instance_status", &self.stack_instance_status);
        formatter.field("status_reason", &self.status_reason);
        formatter.field("organizational_unit_id", &self.organizational_unit_id);
        formatter.field("drift_status", &self.drift_status);
        formatter.field(
            "last_drift_check_timestamp",
            &self.last_drift_check_timestamp,
        );
        formatter.finish()
    }
}
/// See [`StackInstance`](crate::model::StackInstance)
pub mod stack_instance {
    /// A builder for [`StackInstance`](crate::model::StackInstance)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) stack_set_id: std::option::Option<std::string::String>,
        pub(crate) region: std::option::Option<std::string::String>,
        pub(crate) account: std::option::Option<std::string::String>,
        pub(crate) stack_id: std::option::Option<std::string::String>,
        pub(crate) parameter_overrides: std::option::Option<std::vec::Vec<crate::model::Parameter>>,
        pub(crate) status: std::option::Option<crate::model::StackInstanceStatus>,
        pub(crate) stack_instance_status:
            std::option::Option<crate::model::StackInstanceComprehensiveStatus>,
        pub(crate) status_reason: std::option::Option<std::string::String>,
        pub(crate) organizational_unit_id: std::option::Option<std::string::String>,
        pub(crate) drift_status: std::option::Option<crate::model::StackDriftStatus>,
        pub(crate) last_drift_check_timestamp: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The name or unique ID of the stack set that the stack instance is associated with.</p>
        pub fn stack_set_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.stack_set_id = Some(input.into());
            self
        }
        /// <p>The name or unique ID of the stack set that the stack instance is associated with.</p>
        pub fn set_stack_set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.stack_set_id = input;
            self
        }
        /// <p>The name of the Amazon Web Services Region that the stack instance is associated with.</p>
        pub fn region(mut self, input: impl Into<std::string::String>) -> Self {
            self.region = Some(input.into());
            self
        }
        /// <p>The name of the Amazon Web Services Region that the stack instance is associated with.</p>
        pub fn set_region(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.region = input;
            self
        }
        /// <p>[Self-managed permissions] The name of the Amazon Web Services account that the stack instance is associated with.</p>
        pub fn account(mut self, input: impl Into<std::string::String>) -> Self {
            self.account = Some(input.into());
            self
        }
        /// <p>[Self-managed permissions] The name of the Amazon Web Services account that the stack instance is associated with.</p>
        pub fn set_account(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.account = input;
            self
        }
        /// <p>The ID of the stack instance.</p>
        pub fn stack_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.stack_id = Some(input.into());
            self
        }
        /// <p>The ID of the stack instance.</p>
        pub fn set_stack_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.stack_id = input;
            self
        }
        /// Appends an item to `parameter_overrides`.
        ///
        /// To override the contents of this collection use [`set_parameter_overrides`](Self::set_parameter_overrides).
        ///
        /// <p>A list of parameters from the stack set template whose values have been overridden in this stack instance.</p>
        pub fn parameter_overrides(mut self, input: crate::model::Parameter) -> Self {
            let mut v = self.parameter_overrides.unwrap_or_default();
            v.push(input);
            self.parameter_overrides = Some(v);
            self
        }
        /// <p>A list of parameters from the stack set template whose values have been overridden in this stack instance.</p>
        pub fn set_parameter_overrides(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Parameter>>,
        ) -> Self {
            self.parameter_overrides = input;
            self
        }
        /// <p>The status of the stack instance, in terms of its synchronization with its associated stack set.</p>
        /// <ul>
        /// <li> <p> <code>INOPERABLE</code>: A <code>DeleteStackInstances</code> operation has failed and left the stack in an unstable state. Stacks in this state are excluded from further <code>UpdateStackSet</code> operations. You might need to perform a <code>DeleteStackInstances</code> operation, with <code>RetainStacks</code> set to <code>true</code>, to delete the stack instance, and then delete the stack manually.</p> </li>
        /// <li> <p> <code>OUTDATED</code>: The stack isn't currently up to date with the stack set because:</p>
        /// <ul>
        /// <li> <p>The associated stack failed during a <code>CreateStackSet</code> or <code>UpdateStackSet</code> operation. </p> </li>
        /// <li> <p>The stack was part of a <code>CreateStackSet</code> or <code>UpdateStackSet</code> operation that failed or was stopped before the stack was created or updated. </p> </li>
        /// </ul> </li>
        /// <li> <p> <code>CURRENT</code>: The stack is currently up to date with the stack set.</p> </li>
        /// </ul>
        pub fn status(mut self, input: crate::model::StackInstanceStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of the stack instance, in terms of its synchronization with its associated stack set.</p>
        /// <ul>
        /// <li> <p> <code>INOPERABLE</code>: A <code>DeleteStackInstances</code> operation has failed and left the stack in an unstable state. Stacks in this state are excluded from further <code>UpdateStackSet</code> operations. You might need to perform a <code>DeleteStackInstances</code> operation, with <code>RetainStacks</code> set to <code>true</code>, to delete the stack instance, and then delete the stack manually.</p> </li>
        /// <li> <p> <code>OUTDATED</code>: The stack isn't currently up to date with the stack set because:</p>
        /// <ul>
        /// <li> <p>The associated stack failed during a <code>CreateStackSet</code> or <code>UpdateStackSet</code> operation. </p> </li>
        /// <li> <p>The stack was part of a <code>CreateStackSet</code> or <code>UpdateStackSet</code> operation that failed or was stopped before the stack was created or updated. </p> </li>
        /// </ul> </li>
        /// <li> <p> <code>CURRENT</code>: The stack is currently up to date with the stack set.</p> </li>
        /// </ul>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::StackInstanceStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>The detailed status of the stack instance.</p>
        pub fn stack_instance_status(
            mut self,
            input: crate::model::StackInstanceComprehensiveStatus,
        ) -> Self {
            self.stack_instance_status = Some(input);
            self
        }
        /// <p>The detailed status of the stack instance.</p>
        pub fn set_stack_instance_status(
            mut self,
            input: std::option::Option<crate::model::StackInstanceComprehensiveStatus>,
        ) -> Self {
            self.stack_instance_status = input;
            self
        }
        /// <p>The explanation for the specific status code that is assigned to this stack instance.</p>
        pub fn status_reason(mut self, input: impl Into<std::string::String>) -> Self {
            self.status_reason = Some(input.into());
            self
        }
        /// <p>The explanation for the specific status code that is assigned to this stack instance.</p>
        pub fn set_status_reason(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.status_reason = input;
            self
        }
        /// <p>[Service-managed permissions] The organization root ID or organizational unit (OU) IDs that you specified for <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_DeploymentTargets.html">DeploymentTargets</a>.</p>
        pub fn organizational_unit_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.organizational_unit_id = Some(input.into());
            self
        }
        /// <p>[Service-managed permissions] The organization root ID or organizational unit (OU) IDs that you specified for <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_DeploymentTargets.html">DeploymentTargets</a>.</p>
        pub fn set_organizational_unit_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.organizational_unit_id = input;
            self
        }
        /// <p>Status of the stack instance's actual configuration compared to the expected template and parameter configuration of the stack set to which it belongs. </p>
        /// <ul>
        /// <li> <p> <code>DRIFTED</code>: The stack differs from the expected template and parameter configuration of the stack set to which it belongs. A stack instance is considered to have drifted if one or more of the resources in the associated stack have drifted.</p> </li>
        /// <li> <p> <code>NOT_CHECKED</code>: CloudFormation has not checked if the stack instance differs from its expected stack set configuration.</p> </li>
        /// <li> <p> <code>IN_SYNC</code>: The stack instance's actual configuration matches its expected stack set configuration.</p> </li>
        /// <li> <p> <code>UNKNOWN</code>: This value is reserved for future use.</p> </li>
        /// </ul>
        pub fn drift_status(mut self, input: crate::model::StackDriftStatus) -> Self {
            self.drift_status = Some(input);
            self
        }
        /// <p>Status of the stack instance's actual configuration compared to the expected template and parameter configuration of the stack set to which it belongs. </p>
        /// <ul>
        /// <li> <p> <code>DRIFTED</code>: The stack differs from the expected template and parameter configuration of the stack set to which it belongs. A stack instance is considered to have drifted if one or more of the resources in the associated stack have drifted.</p> </li>
        /// <li> <p> <code>NOT_CHECKED</code>: CloudFormation has not checked if the stack instance differs from its expected stack set configuration.</p> </li>
        /// <li> <p> <code>IN_SYNC</code>: The stack instance's actual configuration matches its expected stack set configuration.</p> </li>
        /// <li> <p> <code>UNKNOWN</code>: This value is reserved for future use.</p> </li>
        /// </ul>
        pub fn set_drift_status(
            mut self,
            input: std::option::Option<crate::model::StackDriftStatus>,
        ) -> Self {
            self.drift_status = input;
            self
        }
        /// <p>Most recent time when CloudFormation performed a drift detection operation on the stack instance. This value will be <code>NULL</code> for any stack instance on which drift detection has not yet been performed.</p>
        pub fn last_drift_check_timestamp(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_drift_check_timestamp = Some(input);
            self
        }
        /// <p>Most recent time when CloudFormation performed a drift detection operation on the stack instance. This value will be <code>NULL</code> for any stack instance on which drift detection has not yet been performed.</p>
        pub fn set_last_drift_check_timestamp(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_drift_check_timestamp = input;
            self
        }
        /// Consumes the builder and constructs a [`StackInstance`](crate::model::StackInstance)
        pub fn build(self) -> crate::model::StackInstance {
            crate::model::StackInstance {
                stack_set_id: self.stack_set_id,
                region: self.region,
                account: self.account,
                stack_id: self.stack_id,
                parameter_overrides: self.parameter_overrides,
                status: self.status,
                stack_instance_status: self.stack_instance_status,
                status_reason: self.status_reason,
                organizational_unit_id: self.organizational_unit_id,
                drift_status: self.drift_status,
                last_drift_check_timestamp: self.last_drift_check_timestamp,
            }
        }
    }
}
impl StackInstance {
    /// Creates a new builder-style object to manufacture [`StackInstance`](crate::model::StackInstance)
    pub fn builder() -> crate::model::stack_instance::Builder {
        crate::model::stack_instance::Builder::default()
    }
}

/// <p>The StackEvent data type.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StackEvent {
    /// <p>The unique ID name of the instance of the stack.</p>
    pub stack_id: std::option::Option<std::string::String>,
    /// <p>The unique ID of this event.</p>
    pub event_id: std::option::Option<std::string::String>,
    /// <p>The name associated with a stack.</p>
    pub stack_name: std::option::Option<std::string::String>,
    /// <p>The logical name of the resource specified in the template.</p>
    pub logical_resource_id: std::option::Option<std::string::String>,
    /// <p>The name or unique identifier associated with the physical instance of the resource.</p>
    pub physical_resource_id: std::option::Option<std::string::String>,
    /// <p>Type of resource. (For more information, go to <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-template-resource-type-ref.html">Amazon Web Services Resource Types Reference</a> in the CloudFormation User Guide.)</p>
    pub resource_type: std::option::Option<std::string::String>,
    /// <p>Time the status was updated.</p>
    pub timestamp: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>Current status of the resource.</p>
    pub resource_status: std::option::Option<crate::model::ResourceStatus>,
    /// <p>Success/failure message associated with the resource.</p>
    pub resource_status_reason: std::option::Option<std::string::String>,
    /// <p>BLOB of the properties used to create the resource.</p>
    pub resource_properties: std::option::Option<std::string::String>,
    /// <p>The token passed to the operation that generated this event.</p>
    /// <p>All events triggered by a given stack operation are assigned the same client request token, which you can use to track operations. For example, if you execute a <code>CreateStack</code> operation with the token <code>token1</code>, then all the <code>StackEvents</code> generated by that operation will have <code>ClientRequestToken</code> set as <code>token1</code>.</p>
    /// <p>In the console, stack operations display the client request token on the Events tab. Stack operations that are initiated from the console use the token format <i>Console-StackOperation-ID</i>, which helps you easily identify the stack operation . For example, if you create a stack using the console, each stack event would be assigned the same token in the following format: <code>Console-CreateStack-7f59c3cf-00d2-40c7-b2ff-e75db0987002</code>. </p>
    pub client_request_token: std::option::Option<std::string::String>,
}
impl StackEvent {
    /// <p>The unique ID name of the instance of the stack.</p>
    pub fn stack_id(&self) -> std::option::Option<&str> {
        self.stack_id.as_deref()
    }
    /// <p>The unique ID of this event.</p>
    pub fn event_id(&self) -> std::option::Option<&str> {
        self.event_id.as_deref()
    }
    /// <p>The name associated with a stack.</p>
    pub fn stack_name(&self) -> std::option::Option<&str> {
        self.stack_name.as_deref()
    }
    /// <p>The logical name of the resource specified in the template.</p>
    pub fn logical_resource_id(&self) -> std::option::Option<&str> {
        self.logical_resource_id.as_deref()
    }
    /// <p>The name or unique identifier associated with the physical instance of the resource.</p>
    pub fn physical_resource_id(&self) -> std::option::Option<&str> {
        self.physical_resource_id.as_deref()
    }
    /// <p>Type of resource. (For more information, go to <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-template-resource-type-ref.html">Amazon Web Services Resource Types Reference</a> in the CloudFormation User Guide.)</p>
    pub fn resource_type(&self) -> std::option::Option<&str> {
        self.resource_type.as_deref()
    }
    /// <p>Time the status was updated.</p>
    pub fn timestamp(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.timestamp.as_ref()
    }
    /// <p>Current status of the resource.</p>
    pub fn resource_status(&self) -> std::option::Option<&crate::model::ResourceStatus> {
        self.resource_status.as_ref()
    }
    /// <p>Success/failure message associated with the resource.</p>
    pub fn resource_status_reason(&self) -> std::option::Option<&str> {
        self.resource_status_reason.as_deref()
    }
    /// <p>BLOB of the properties used to create the resource.</p>
    pub fn resource_properties(&self) -> std::option::Option<&str> {
        self.resource_properties.as_deref()
    }
    /// <p>The token passed to the operation that generated this event.</p>
    /// <p>All events triggered by a given stack operation are assigned the same client request token, which you can use to track operations. For example, if you execute a <code>CreateStack</code> operation with the token <code>token1</code>, then all the <code>StackEvents</code> generated by that operation will have <code>ClientRequestToken</code> set as <code>token1</code>.</p>
    /// <p>In the console, stack operations display the client request token on the Events tab. Stack operations that are initiated from the console use the token format <i>Console-StackOperation-ID</i>, which helps you easily identify the stack operation . For example, if you create a stack using the console, each stack event would be assigned the same token in the following format: <code>Console-CreateStack-7f59c3cf-00d2-40c7-b2ff-e75db0987002</code>. </p>
    pub fn client_request_token(&self) -> std::option::Option<&str> {
        self.client_request_token.as_deref()
    }
}
impl std::fmt::Debug for StackEvent {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StackEvent");
        formatter.field("stack_id", &self.stack_id);
        formatter.field("event_id", &self.event_id);
        formatter.field("stack_name", &self.stack_name);
        formatter.field("logical_resource_id", &self.logical_resource_id);
        formatter.field("physical_resource_id", &self.physical_resource_id);
        formatter.field("resource_type", &self.resource_type);
        formatter.field("timestamp", &self.timestamp);
        formatter.field("resource_status", &self.resource_status);
        formatter.field("resource_status_reason", &self.resource_status_reason);
        formatter.field("resource_properties", &self.resource_properties);
        formatter.field("client_request_token", &self.client_request_token);
        formatter.finish()
    }
}
/// See [`StackEvent`](crate::model::StackEvent)
pub mod stack_event {
    /// A builder for [`StackEvent`](crate::model::StackEvent)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) stack_id: std::option::Option<std::string::String>,
        pub(crate) event_id: std::option::Option<std::string::String>,
        pub(crate) stack_name: std::option::Option<std::string::String>,
        pub(crate) logical_resource_id: std::option::Option<std::string::String>,
        pub(crate) physical_resource_id: std::option::Option<std::string::String>,
        pub(crate) resource_type: std::option::Option<std::string::String>,
        pub(crate) timestamp: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) resource_status: std::option::Option<crate::model::ResourceStatus>,
        pub(crate) resource_status_reason: std::option::Option<std::string::String>,
        pub(crate) resource_properties: std::option::Option<std::string::String>,
        pub(crate) client_request_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique ID name of the instance of the stack.</p>
        pub fn stack_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.stack_id = Some(input.into());
            self
        }
        /// <p>The unique ID name of the instance of the stack.</p>
        pub fn set_stack_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.stack_id = input;
            self
        }
        /// <p>The unique ID of this event.</p>
        pub fn event_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.event_id = Some(input.into());
            self
        }
        /// <p>The unique ID of this event.</p>
        pub fn set_event_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.event_id = input;
            self
        }
        /// <p>The name associated with a stack.</p>
        pub fn stack_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.stack_name = Some(input.into());
            self
        }
        /// <p>The name associated with a stack.</p>
        pub fn set_stack_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.stack_name = input;
            self
        }
        /// <p>The logical name of the resource specified in the template.</p>
        pub fn logical_resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.logical_resource_id = Some(input.into());
            self
        }
        /// <p>The logical name of the resource specified in the template.</p>
        pub fn set_logical_resource_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.logical_resource_id = input;
            self
        }
        /// <p>The name or unique identifier associated with the physical instance of the resource.</p>
        pub fn physical_resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.physical_resource_id = Some(input.into());
            self
        }
        /// <p>The name or unique identifier associated with the physical instance of the resource.</p>
        pub fn set_physical_resource_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.physical_resource_id = input;
            self
        }
        /// <p>Type of resource. (For more information, go to <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-template-resource-type-ref.html">Amazon Web Services Resource Types Reference</a> in the CloudFormation User Guide.)</p>
        pub fn resource_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_type = Some(input.into());
            self
        }
        /// <p>Type of resource. (For more information, go to <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-template-resource-type-ref.html">Amazon Web Services Resource Types Reference</a> in the CloudFormation User Guide.)</p>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_type = input;
            self
        }
        /// <p>Time the status was updated.</p>
        pub fn timestamp(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.timestamp = Some(input);
            self
        }
        /// <p>Time the status was updated.</p>
        pub fn set_timestamp(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.timestamp = input;
            self
        }
        /// <p>Current status of the resource.</p>
        pub fn resource_status(mut self, input: crate::model::ResourceStatus) -> Self {
            self.resource_status = Some(input);
            self
        }
        /// <p>Current status of the resource.</p>
        pub fn set_resource_status(
            mut self,
            input: std::option::Option<crate::model::ResourceStatus>,
        ) -> Self {
            self.resource_status = input;
            self
        }
        /// <p>Success/failure message associated with the resource.</p>
        pub fn resource_status_reason(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_status_reason = Some(input.into());
            self
        }
        /// <p>Success/failure message associated with the resource.</p>
        pub fn set_resource_status_reason(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_status_reason = input;
            self
        }
        /// <p>BLOB of the properties used to create the resource.</p>
        pub fn resource_properties(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_properties = Some(input.into());
            self
        }
        /// <p>BLOB of the properties used to create the resource.</p>
        pub fn set_resource_properties(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_properties = input;
            self
        }
        /// <p>The token passed to the operation that generated this event.</p>
        /// <p>All events triggered by a given stack operation are assigned the same client request token, which you can use to track operations. For example, if you execute a <code>CreateStack</code> operation with the token <code>token1</code>, then all the <code>StackEvents</code> generated by that operation will have <code>ClientRequestToken</code> set as <code>token1</code>.</p>
        /// <p>In the console, stack operations display the client request token on the Events tab. Stack operations that are initiated from the console use the token format <i>Console-StackOperation-ID</i>, which helps you easily identify the stack operation . For example, if you create a stack using the console, each stack event would be assigned the same token in the following format: <code>Console-CreateStack-7f59c3cf-00d2-40c7-b2ff-e75db0987002</code>. </p>
        pub fn client_request_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_request_token = Some(input.into());
            self
        }
        /// <p>The token passed to the operation that generated this event.</p>
        /// <p>All events triggered by a given stack operation are assigned the same client request token, which you can use to track operations. For example, if you execute a <code>CreateStack</code> operation with the token <code>token1</code>, then all the <code>StackEvents</code> generated by that operation will have <code>ClientRequestToken</code> set as <code>token1</code>.</p>
        /// <p>In the console, stack operations display the client request token on the Events tab. Stack operations that are initiated from the console use the token format <i>Console-StackOperation-ID</i>, which helps you easily identify the stack operation . For example, if you create a stack using the console, each stack event would be assigned the same token in the following format: <code>Console-CreateStack-7f59c3cf-00d2-40c7-b2ff-e75db0987002</code>. </p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.client_request_token = input;
            self
        }
        /// Consumes the builder and constructs a [`StackEvent`](crate::model::StackEvent)
        pub fn build(self) -> crate::model::StackEvent {
            crate::model::StackEvent {
                stack_id: self.stack_id,
                event_id: self.event_id,
                stack_name: self.stack_name,
                logical_resource_id: self.logical_resource_id,
                physical_resource_id: self.physical_resource_id,
                resource_type: self.resource_type,
                timestamp: self.timestamp,
                resource_status: self.resource_status,
                resource_status_reason: self.resource_status_reason,
                resource_properties: self.resource_properties,
                client_request_token: self.client_request_token,
            }
        }
    }
}
impl StackEvent {
    /// Creates a new builder-style object to manufacture [`StackEvent`](crate::model::StackEvent)
    pub fn builder() -> crate::model::stack_event::Builder {
        crate::model::stack_event::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum StackDriftDetectionStatus {
    #[allow(missing_docs)] // documentation missing in model
    DetectionComplete,
    #[allow(missing_docs)] // documentation missing in model
    DetectionFailed,
    #[allow(missing_docs)] // documentation missing in model
    DetectionInProgress,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for StackDriftDetectionStatus {
    fn from(s: &str) -> Self {
        match s {
            "DETECTION_COMPLETE" => StackDriftDetectionStatus::DetectionComplete,
            "DETECTION_FAILED" => StackDriftDetectionStatus::DetectionFailed,
            "DETECTION_IN_PROGRESS" => StackDriftDetectionStatus::DetectionInProgress,
            other => StackDriftDetectionStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for StackDriftDetectionStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(StackDriftDetectionStatus::from(s))
    }
}
impl StackDriftDetectionStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            StackDriftDetectionStatus::DetectionComplete => "DETECTION_COMPLETE",
            StackDriftDetectionStatus::DetectionFailed => "DETECTION_FAILED",
            StackDriftDetectionStatus::DetectionInProgress => "DETECTION_IN_PROGRESS",
            StackDriftDetectionStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "DETECTION_COMPLETE",
            "DETECTION_FAILED",
            "DETECTION_IN_PROGRESS",
        ]
    }
}
impl AsRef<str> for StackDriftDetectionStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum PublisherStatus {
    #[allow(missing_docs)] // documentation missing in model
    Unverified,
    #[allow(missing_docs)] // documentation missing in model
    Verified,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for PublisherStatus {
    fn from(s: &str) -> Self {
        match s {
            "UNVERIFIED" => PublisherStatus::Unverified,
            "VERIFIED" => PublisherStatus::Verified,
            other => PublisherStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for PublisherStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(PublisherStatus::from(s))
    }
}
impl PublisherStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            PublisherStatus::Unverified => "UNVERIFIED",
            PublisherStatus::Verified => "VERIFIED",
            PublisherStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["UNVERIFIED", "VERIFIED"]
    }
}
impl AsRef<str> for PublisherStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The <code>Change</code> structure describes the changes CloudFormation will perform if you execute the change set.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Change {
    /// <p>The type of entity that CloudFormation changes. Currently, the only entity type is <code>Resource</code>.</p>
    pub r#type: std::option::Option<crate::model::ChangeType>,
    /// <p>A <code>ResourceChange</code> structure that describes the resource and action that CloudFormation will perform.</p>
    pub resource_change: std::option::Option<crate::model::ResourceChange>,
}
impl Change {
    /// <p>The type of entity that CloudFormation changes. Currently, the only entity type is <code>Resource</code>.</p>
    pub fn r#type(&self) -> std::option::Option<&crate::model::ChangeType> {
        self.r#type.as_ref()
    }
    /// <p>A <code>ResourceChange</code> structure that describes the resource and action that CloudFormation will perform.</p>
    pub fn resource_change(&self) -> std::option::Option<&crate::model::ResourceChange> {
        self.resource_change.as_ref()
    }
}
impl std::fmt::Debug for Change {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Change");
        formatter.field("r#type", &self.r#type);
        formatter.field("resource_change", &self.resource_change);
        formatter.finish()
    }
}
/// See [`Change`](crate::model::Change)
pub mod change {
    /// A builder for [`Change`](crate::model::Change)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) r#type: std::option::Option<crate::model::ChangeType>,
        pub(crate) resource_change: std::option::Option<crate::model::ResourceChange>,
    }
    impl Builder {
        /// <p>The type of entity that CloudFormation changes. Currently, the only entity type is <code>Resource</code>.</p>
        pub fn r#type(mut self, input: crate::model::ChangeType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The type of entity that CloudFormation changes. Currently, the only entity type is <code>Resource</code>.</p>
        pub fn set_type(mut self, input: std::option::Option<crate::model::ChangeType>) -> Self {
            self.r#type = input;
            self
        }
        /// <p>A <code>ResourceChange</code> structure that describes the resource and action that CloudFormation will perform.</p>
        pub fn resource_change(mut self, input: crate::model::ResourceChange) -> Self {
            self.resource_change = Some(input);
            self
        }
        /// <p>A <code>ResourceChange</code> structure that describes the resource and action that CloudFormation will perform.</p>
        pub fn set_resource_change(
            mut self,
            input: std::option::Option<crate::model::ResourceChange>,
        ) -> Self {
            self.resource_change = input;
            self
        }
        /// Consumes the builder and constructs a [`Change`](crate::model::Change)
        pub fn build(self) -> crate::model::Change {
            crate::model::Change {
                r#type: self.r#type,
                resource_change: self.resource_change,
            }
        }
    }
}
impl Change {
    /// Creates a new builder-style object to manufacture [`Change`](crate::model::Change)
    pub fn builder() -> crate::model::change::Builder {
        crate::model::change::Builder::default()
    }
}

/// <p>The <code>ResourceChange</code> structure describes the resource and the action that CloudFormation will perform on it if you execute this change set.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResourceChange {
    /// <p>The action that CloudFormation takes on the resource, such as <code>Add</code> (adds a new resource), <code>Modify</code> (changes a resource), <code>Remove</code> (deletes a resource), <code>Import</code> (imports a resource), or <code>Dynamic</code> (exact action for the resource cannot be determined).</p>
    pub action: std::option::Option<crate::model::ChangeAction>,
    /// <p>The resource's logical ID, which is defined in the stack's template.</p>
    pub logical_resource_id: std::option::Option<std::string::String>,
    /// <p>The resource's physical ID (resource name). Resources that you are adding don't have physical IDs because they haven't been created.</p>
    pub physical_resource_id: std::option::Option<std::string::String>,
    /// <p>The type of CloudFormation resource, such as <code>AWS::S3::Bucket</code>.</p>
    pub resource_type: std::option::Option<std::string::String>,
    /// <p>For the <code>Modify</code> action, indicates whether CloudFormation will replace the resource by creating a new one and deleting the old one. This value depends on the value of the <code>RequiresRecreation</code> property in the <code>ResourceTargetDefinition</code> structure. For example, if the <code>RequiresRecreation</code> field is <code>Always</code> and the <code>Evaluation</code> field is <code>Static</code>, <code>Replacement</code> is <code>True</code>. If the <code>RequiresRecreation</code> field is <code>Always</code> and the <code>Evaluation</code> field is <code>Dynamic</code>, <code>Replacement</code> is <code>Conditionally</code>.</p>
    /// <p>If you have multiple changes with different <code>RequiresRecreation</code> values, the <code>Replacement</code> value depends on the change with the most impact. A <code>RequiresRecreation</code> value of <code>Always</code> has the most impact, followed by <code>Conditionally</code>, and then <code>Never</code>.</p>
    pub replacement: std::option::Option<crate::model::Replacement>,
    /// <p>For the <code>Modify</code> action, indicates which resource attribute is triggering this update, such as a change in the resource attribute's <code>Metadata</code>, <code>Properties</code>, or <code>Tags</code>.</p>
    pub scope: std::option::Option<std::vec::Vec<crate::model::ResourceAttribute>>,
    /// <p>For the <code>Modify</code> action, a list of <code>ResourceChangeDetail</code> structures that describes the changes that CloudFormation will make to the resource. </p>
    pub details: std::option::Option<std::vec::Vec<crate::model::ResourceChangeDetail>>,
    /// <p>The change set ID of the nested change set.</p>
    pub change_set_id: std::option::Option<std::string::String>,
    /// <p>Contains information about the module from which the resource was created, if the resource was created from a module included in the stack template.</p>
    pub module_info: std::option::Option<crate::model::ModuleInfo>,
}
impl ResourceChange {
    /// <p>The action that CloudFormation takes on the resource, such as <code>Add</code> (adds a new resource), <code>Modify</code> (changes a resource), <code>Remove</code> (deletes a resource), <code>Import</code> (imports a resource), or <code>Dynamic</code> (exact action for the resource cannot be determined).</p>
    pub fn action(&self) -> std::option::Option<&crate::model::ChangeAction> {
        self.action.as_ref()
    }
    /// <p>The resource's logical ID, which is defined in the stack's template.</p>
    pub fn logical_resource_id(&self) -> std::option::Option<&str> {
        self.logical_resource_id.as_deref()
    }
    /// <p>The resource's physical ID (resource name). Resources that you are adding don't have physical IDs because they haven't been created.</p>
    pub fn physical_resource_id(&self) -> std::option::Option<&str> {
        self.physical_resource_id.as_deref()
    }
    /// <p>The type of CloudFormation resource, such as <code>AWS::S3::Bucket</code>.</p>
    pub fn resource_type(&self) -> std::option::Option<&str> {
        self.resource_type.as_deref()
    }
    /// <p>For the <code>Modify</code> action, indicates whether CloudFormation will replace the resource by creating a new one and deleting the old one. This value depends on the value of the <code>RequiresRecreation</code> property in the <code>ResourceTargetDefinition</code> structure. For example, if the <code>RequiresRecreation</code> field is <code>Always</code> and the <code>Evaluation</code> field is <code>Static</code>, <code>Replacement</code> is <code>True</code>. If the <code>RequiresRecreation</code> field is <code>Always</code> and the <code>Evaluation</code> field is <code>Dynamic</code>, <code>Replacement</code> is <code>Conditionally</code>.</p>
    /// <p>If you have multiple changes with different <code>RequiresRecreation</code> values, the <code>Replacement</code> value depends on the change with the most impact. A <code>RequiresRecreation</code> value of <code>Always</code> has the most impact, followed by <code>Conditionally</code>, and then <code>Never</code>.</p>
    pub fn replacement(&self) -> std::option::Option<&crate::model::Replacement> {
        self.replacement.as_ref()
    }
    /// <p>For the <code>Modify</code> action, indicates which resource attribute is triggering this update, such as a change in the resource attribute's <code>Metadata</code>, <code>Properties</code>, or <code>Tags</code>.</p>
    pub fn scope(&self) -> std::option::Option<&[crate::model::ResourceAttribute]> {
        self.scope.as_deref()
    }
    /// <p>For the <code>Modify</code> action, a list of <code>ResourceChangeDetail</code> structures that describes the changes that CloudFormation will make to the resource. </p>
    pub fn details(&self) -> std::option::Option<&[crate::model::ResourceChangeDetail]> {
        self.details.as_deref()
    }
    /// <p>The change set ID of the nested change set.</p>
    pub fn change_set_id(&self) -> std::option::Option<&str> {
        self.change_set_id.as_deref()
    }
    /// <p>Contains information about the module from which the resource was created, if the resource was created from a module included in the stack template.</p>
    pub fn module_info(&self) -> std::option::Option<&crate::model::ModuleInfo> {
        self.module_info.as_ref()
    }
}
impl std::fmt::Debug for ResourceChange {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResourceChange");
        formatter.field("action", &self.action);
        formatter.field("logical_resource_id", &self.logical_resource_id);
        formatter.field("physical_resource_id", &self.physical_resource_id);
        formatter.field("resource_type", &self.resource_type);
        formatter.field("replacement", &self.replacement);
        formatter.field("scope", &self.scope);
        formatter.field("details", &self.details);
        formatter.field("change_set_id", &self.change_set_id);
        formatter.field("module_info", &self.module_info);
        formatter.finish()
    }
}
/// See [`ResourceChange`](crate::model::ResourceChange)
pub mod resource_change {
    /// A builder for [`ResourceChange`](crate::model::ResourceChange)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) action: std::option::Option<crate::model::ChangeAction>,
        pub(crate) logical_resource_id: std::option::Option<std::string::String>,
        pub(crate) physical_resource_id: std::option::Option<std::string::String>,
        pub(crate) resource_type: std::option::Option<std::string::String>,
        pub(crate) replacement: std::option::Option<crate::model::Replacement>,
        pub(crate) scope: std::option::Option<std::vec::Vec<crate::model::ResourceAttribute>>,
        pub(crate) details: std::option::Option<std::vec::Vec<crate::model::ResourceChangeDetail>>,
        pub(crate) change_set_id: std::option::Option<std::string::String>,
        pub(crate) module_info: std::option::Option<crate::model::ModuleInfo>,
    }
    impl Builder {
        /// <p>The action that CloudFormation takes on the resource, such as <code>Add</code> (adds a new resource), <code>Modify</code> (changes a resource), <code>Remove</code> (deletes a resource), <code>Import</code> (imports a resource), or <code>Dynamic</code> (exact action for the resource cannot be determined).</p>
        pub fn action(mut self, input: crate::model::ChangeAction) -> Self {
            self.action = Some(input);
            self
        }
        /// <p>The action that CloudFormation takes on the resource, such as <code>Add</code> (adds a new resource), <code>Modify</code> (changes a resource), <code>Remove</code> (deletes a resource), <code>Import</code> (imports a resource), or <code>Dynamic</code> (exact action for the resource cannot be determined).</p>
        pub fn set_action(
            mut self,
            input: std::option::Option<crate::model::ChangeAction>,
        ) -> Self {
            self.action = input;
            self
        }
        /// <p>The resource's logical ID, which is defined in the stack's template.</p>
        pub fn logical_resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.logical_resource_id = Some(input.into());
            self
        }
        /// <p>The resource's logical ID, which is defined in the stack's template.</p>
        pub fn set_logical_resource_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.logical_resource_id = input;
            self
        }
        /// <p>The resource's physical ID (resource name). Resources that you are adding don't have physical IDs because they haven't been created.</p>
        pub fn physical_resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.physical_resource_id = Some(input.into());
            self
        }
        /// <p>The resource's physical ID (resource name). Resources that you are adding don't have physical IDs because they haven't been created.</p>
        pub fn set_physical_resource_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.physical_resource_id = input;
            self
        }
        /// <p>The type of CloudFormation resource, such as <code>AWS::S3::Bucket</code>.</p>
        pub fn resource_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_type = Some(input.into());
            self
        }
        /// <p>The type of CloudFormation resource, such as <code>AWS::S3::Bucket</code>.</p>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_type = input;
            self
        }
        /// <p>For the <code>Modify</code> action, indicates whether CloudFormation will replace the resource by creating a new one and deleting the old one. This value depends on the value of the <code>RequiresRecreation</code> property in the <code>ResourceTargetDefinition</code> structure. For example, if the <code>RequiresRecreation</code> field is <code>Always</code> and the <code>Evaluation</code> field is <code>Static</code>, <code>Replacement</code> is <code>True</code>. If the <code>RequiresRecreation</code> field is <code>Always</code> and the <code>Evaluation</code> field is <code>Dynamic</code>, <code>Replacement</code> is <code>Conditionally</code>.</p>
        /// <p>If you have multiple changes with different <code>RequiresRecreation</code> values, the <code>Replacement</code> value depends on the change with the most impact. A <code>RequiresRecreation</code> value of <code>Always</code> has the most impact, followed by <code>Conditionally</code>, and then <code>Never</code>.</p>
        pub fn replacement(mut self, input: crate::model::Replacement) -> Self {
            self.replacement = Some(input);
            self
        }
        /// <p>For the <code>Modify</code> action, indicates whether CloudFormation will replace the resource by creating a new one and deleting the old one. This value depends on the value of the <code>RequiresRecreation</code> property in the <code>ResourceTargetDefinition</code> structure. For example, if the <code>RequiresRecreation</code> field is <code>Always</code> and the <code>Evaluation</code> field is <code>Static</code>, <code>Replacement</code> is <code>True</code>. If the <code>RequiresRecreation</code> field is <code>Always</code> and the <code>Evaluation</code> field is <code>Dynamic</code>, <code>Replacement</code> is <code>Conditionally</code>.</p>
        /// <p>If you have multiple changes with different <code>RequiresRecreation</code> values, the <code>Replacement</code> value depends on the change with the most impact. A <code>RequiresRecreation</code> value of <code>Always</code> has the most impact, followed by <code>Conditionally</code>, and then <code>Never</code>.</p>
        pub fn set_replacement(
            mut self,
            input: std::option::Option<crate::model::Replacement>,
        ) -> Self {
            self.replacement = input;
            self
        }
        /// Appends an item to `scope`.
        ///
        /// To override the contents of this collection use [`set_scope`](Self::set_scope).
        ///
        /// <p>For the <code>Modify</code> action, indicates which resource attribute is triggering this update, such as a change in the resource attribute's <code>Metadata</code>, <code>Properties</code>, or <code>Tags</code>.</p>
        pub fn scope(mut self, input: crate::model::ResourceAttribute) -> Self {
            let mut v = self.scope.unwrap_or_default();
            v.push(input);
            self.scope = Some(v);
            self
        }
        /// <p>For the <code>Modify</code> action, indicates which resource attribute is triggering this update, such as a change in the resource attribute's <code>Metadata</code>, <code>Properties</code>, or <code>Tags</code>.</p>
        pub fn set_scope(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ResourceAttribute>>,
        ) -> Self {
            self.scope = input;
            self
        }
        /// Appends an item to `details`.
        ///
        /// To override the contents of this collection use [`set_details`](Self::set_details).
        ///
        /// <p>For the <code>Modify</code> action, a list of <code>ResourceChangeDetail</code> structures that describes the changes that CloudFormation will make to the resource. </p>
        pub fn details(mut self, input: crate::model::ResourceChangeDetail) -> Self {
            let mut v = self.details.unwrap_or_default();
            v.push(input);
            self.details = Some(v);
            self
        }
        /// <p>For the <code>Modify</code> action, a list of <code>ResourceChangeDetail</code> structures that describes the changes that CloudFormation will make to the resource. </p>
        pub fn set_details(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ResourceChangeDetail>>,
        ) -> Self {
            self.details = input;
            self
        }
        /// <p>The change set ID of the nested change set.</p>
        pub fn change_set_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.change_set_id = Some(input.into());
            self
        }
        /// <p>The change set ID of the nested change set.</p>
        pub fn set_change_set_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.change_set_id = input;
            self
        }
        /// <p>Contains information about the module from which the resource was created, if the resource was created from a module included in the stack template.</p>
        pub fn module_info(mut self, input: crate::model::ModuleInfo) -> Self {
            self.module_info = Some(input);
            self
        }
        /// <p>Contains information about the module from which the resource was created, if the resource was created from a module included in the stack template.</p>
        pub fn set_module_info(
            mut self,
            input: std::option::Option<crate::model::ModuleInfo>,
        ) -> Self {
            self.module_info = input;
            self
        }
        /// Consumes the builder and constructs a [`ResourceChange`](crate::model::ResourceChange)
        pub fn build(self) -> crate::model::ResourceChange {
            crate::model::ResourceChange {
                action: self.action,
                logical_resource_id: self.logical_resource_id,
                physical_resource_id: self.physical_resource_id,
                resource_type: self.resource_type,
                replacement: self.replacement,
                scope: self.scope,
                details: self.details,
                change_set_id: self.change_set_id,
                module_info: self.module_info,
            }
        }
    }
}
impl ResourceChange {
    /// Creates a new builder-style object to manufacture [`ResourceChange`](crate::model::ResourceChange)
    pub fn builder() -> crate::model::resource_change::Builder {
        crate::model::resource_change::Builder::default()
    }
}

/// <p>For a resource with <code>Modify</code> as the action, the <code>ResourceChange</code> structure describes the changes CloudFormation will make to that resource.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResourceChangeDetail {
    /// <p>A <code>ResourceTargetDefinition</code> structure that describes the field that CloudFormation will change and whether the resource will be recreated.</p>
    pub target: std::option::Option<crate::model::ResourceTargetDefinition>,
    /// <p>Indicates whether CloudFormation can determine the target value, and whether the target value will change before you execute a change set.</p>
    /// <p>For <code>Static</code> evaluations, CloudFormation can determine that the target value will change, and its value. For example, if you directly modify the <code>InstanceType</code> property of an EC2 instance, CloudFormation knows that this property value will change, and its value, so this is a <code>Static</code> evaluation.</p>
    /// <p>For <code>Dynamic</code> evaluations, cannot determine the target value because it depends on the result of an intrinsic function, such as a <code>Ref</code> or <code>Fn::GetAtt</code> intrinsic function, when the stack is updated. For example, if your template includes a reference to a resource that is conditionally recreated, the value of the reference (the physical ID of the resource) might change, depending on if the resource is recreated. If the resource is recreated, it will have a new physical ID, so all references to that resource will also be updated.</p>
    pub evaluation: std::option::Option<crate::model::EvaluationType>,
    /// <p>The group to which the <code>CausingEntity</code> value belongs. There are five entity groups:</p>
    /// <ul>
    /// <li> <p> <code>ResourceReference</code> entities are <code>Ref</code> intrinsic functions that refer to resources in the template, such as <code>{ "Ref" : "MyEC2InstanceResource" }</code>.</p> </li>
    /// <li> <p> <code>ParameterReference</code> entities are <code>Ref</code> intrinsic functions that get template parameter values, such as <code>{ "Ref" : "MyPasswordParameter" }</code>.</p> </li>
    /// <li> <p> <code>ResourceAttribute</code> entities are <code>Fn::GetAtt</code> intrinsic functions that get resource attribute values, such as <code>{ "Fn::GetAtt" : [ "MyEC2InstanceResource", "PublicDnsName" ] }</code>.</p> </li>
    /// <li> <p> <code>DirectModification</code> entities are changes that are made directly to the template.</p> </li>
    /// <li> <p> <code>Automatic</code> entities are <code>AWS::CloudFormation::Stack</code> resource types, which are also known as nested stacks. If you made no changes to the <code>AWS::CloudFormation::Stack</code> resource, CloudFormation sets the <code>ChangeSource</code> to <code>Automatic</code> because the nested stack's template might have changed. Changes to a nested stack's template aren't visible to CloudFormation until you run an update on the parent stack.</p> </li>
    /// </ul>
    pub change_source: std::option::Option<crate::model::ChangeSource>,
    /// <p>The identity of the entity that triggered this change. This entity is a member of the group that is specified by the <code>ChangeSource</code> field. For example, if you modified the value of the <code>KeyPairName</code> parameter, the <code>CausingEntity</code> is the name of the parameter (<code>KeyPairName</code>).</p>
    /// <p>If the <code>ChangeSource</code> value is <code>DirectModification</code>, no value is given for <code>CausingEntity</code>.</p>
    pub causing_entity: std::option::Option<std::string::String>,
}
impl ResourceChangeDetail {
    /// <p>A <code>ResourceTargetDefinition</code> structure that describes the field that CloudFormation will change and whether the resource will be recreated.</p>
    pub fn target(&self) -> std::option::Option<&crate::model::ResourceTargetDefinition> {
        self.target.as_ref()
    }
    /// <p>Indicates whether CloudFormation can determine the target value, and whether the target value will change before you execute a change set.</p>
    /// <p>For <code>Static</code> evaluations, CloudFormation can determine that the target value will change, and its value. For example, if you directly modify the <code>InstanceType</code> property of an EC2 instance, CloudFormation knows that this property value will change, and its value, so this is a <code>Static</code> evaluation.</p>
    /// <p>For <code>Dynamic</code> evaluations, cannot determine the target value because it depends on the result of an intrinsic function, such as a <code>Ref</code> or <code>Fn::GetAtt</code> intrinsic function, when the stack is updated. For example, if your template includes a reference to a resource that is conditionally recreated, the value of the reference (the physical ID of the resource) might change, depending on if the resource is recreated. If the resource is recreated, it will have a new physical ID, so all references to that resource will also be updated.</p>
    pub fn evaluation(&self) -> std::option::Option<&crate::model::EvaluationType> {
        self.evaluation.as_ref()
    }
    /// <p>The group to which the <code>CausingEntity</code> value belongs. There are five entity groups:</p>
    /// <ul>
    /// <li> <p> <code>ResourceReference</code> entities are <code>Ref</code> intrinsic functions that refer to resources in the template, such as <code>{ "Ref" : "MyEC2InstanceResource" }</code>.</p> </li>
    /// <li> <p> <code>ParameterReference</code> entities are <code>Ref</code> intrinsic functions that get template parameter values, such as <code>{ "Ref" : "MyPasswordParameter" }</code>.</p> </li>
    /// <li> <p> <code>ResourceAttribute</code> entities are <code>Fn::GetAtt</code> intrinsic functions that get resource attribute values, such as <code>{ "Fn::GetAtt" : [ "MyEC2InstanceResource", "PublicDnsName" ] }</code>.</p> </li>
    /// <li> <p> <code>DirectModification</code> entities are changes that are made directly to the template.</p> </li>
    /// <li> <p> <code>Automatic</code> entities are <code>AWS::CloudFormation::Stack</code> resource types, which are also known as nested stacks. If you made no changes to the <code>AWS::CloudFormation::Stack</code> resource, CloudFormation sets the <code>ChangeSource</code> to <code>Automatic</code> because the nested stack's template might have changed. Changes to a nested stack's template aren't visible to CloudFormation until you run an update on the parent stack.</p> </li>
    /// </ul>
    pub fn change_source(&self) -> std::option::Option<&crate::model::ChangeSource> {
        self.change_source.as_ref()
    }
    /// <p>The identity of the entity that triggered this change. This entity is a member of the group that is specified by the <code>ChangeSource</code> field. For example, if you modified the value of the <code>KeyPairName</code> parameter, the <code>CausingEntity</code> is the name of the parameter (<code>KeyPairName</code>).</p>
    /// <p>If the <code>ChangeSource</code> value is <code>DirectModification</code>, no value is given for <code>CausingEntity</code>.</p>
    pub fn causing_entity(&self) -> std::option::Option<&str> {
        self.causing_entity.as_deref()
    }
}
impl std::fmt::Debug for ResourceChangeDetail {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResourceChangeDetail");
        formatter.field("target", &self.target);
        formatter.field("evaluation", &self.evaluation);
        formatter.field("change_source", &self.change_source);
        formatter.field("causing_entity", &self.causing_entity);
        formatter.finish()
    }
}
/// See [`ResourceChangeDetail`](crate::model::ResourceChangeDetail)
pub mod resource_change_detail {
    /// A builder for [`ResourceChangeDetail`](crate::model::ResourceChangeDetail)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) target: std::option::Option<crate::model::ResourceTargetDefinition>,
        pub(crate) evaluation: std::option::Option<crate::model::EvaluationType>,
        pub(crate) change_source: std::option::Option<crate::model::ChangeSource>,
        pub(crate) causing_entity: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A <code>ResourceTargetDefinition</code> structure that describes the field that CloudFormation will change and whether the resource will be recreated.</p>
        pub fn target(mut self, input: crate::model::ResourceTargetDefinition) -> Self {
            self.target = Some(input);
            self
        }
        /// <p>A <code>ResourceTargetDefinition</code> structure that describes the field that CloudFormation will change and whether the resource will be recreated.</p>
        pub fn set_target(
            mut self,
            input: std::option::Option<crate::model::ResourceTargetDefinition>,
        ) -> Self {
            self.target = input;
            self
        }
        /// <p>Indicates whether CloudFormation can determine the target value, and whether the target value will change before you execute a change set.</p>
        /// <p>For <code>Static</code> evaluations, CloudFormation can determine that the target value will change, and its value. For example, if you directly modify the <code>InstanceType</code> property of an EC2 instance, CloudFormation knows that this property value will change, and its value, so this is a <code>Static</code> evaluation.</p>
        /// <p>For <code>Dynamic</code> evaluations, cannot determine the target value because it depends on the result of an intrinsic function, such as a <code>Ref</code> or <code>Fn::GetAtt</code> intrinsic function, when the stack is updated. For example, if your template includes a reference to a resource that is conditionally recreated, the value of the reference (the physical ID of the resource) might change, depending on if the resource is recreated. If the resource is recreated, it will have a new physical ID, so all references to that resource will also be updated.</p>
        pub fn evaluation(mut self, input: crate::model::EvaluationType) -> Self {
            self.evaluation = Some(input);
            self
        }
        /// <p>Indicates whether CloudFormation can determine the target value, and whether the target value will change before you execute a change set.</p>
        /// <p>For <code>Static</code> evaluations, CloudFormation can determine that the target value will change, and its value. For example, if you directly modify the <code>InstanceType</code> property of an EC2 instance, CloudFormation knows that this property value will change, and its value, so this is a <code>Static</code> evaluation.</p>
        /// <p>For <code>Dynamic</code> evaluations, cannot determine the target value because it depends on the result of an intrinsic function, such as a <code>Ref</code> or <code>Fn::GetAtt</code> intrinsic function, when the stack is updated. For example, if your template includes a reference to a resource that is conditionally recreated, the value of the reference (the physical ID of the resource) might change, depending on if the resource is recreated. If the resource is recreated, it will have a new physical ID, so all references to that resource will also be updated.</p>
        pub fn set_evaluation(
            mut self,
            input: std::option::Option<crate::model::EvaluationType>,
        ) -> Self {
            self.evaluation = input;
            self
        }
        /// <p>The group to which the <code>CausingEntity</code> value belongs. There are five entity groups:</p>
        /// <ul>
        /// <li> <p> <code>ResourceReference</code> entities are <code>Ref</code> intrinsic functions that refer to resources in the template, such as <code>{ "Ref" : "MyEC2InstanceResource" }</code>.</p> </li>
        /// <li> <p> <code>ParameterReference</code> entities are <code>Ref</code> intrinsic functions that get template parameter values, such as <code>{ "Ref" : "MyPasswordParameter" }</code>.</p> </li>
        /// <li> <p> <code>ResourceAttribute</code> entities are <code>Fn::GetAtt</code> intrinsic functions that get resource attribute values, such as <code>{ "Fn::GetAtt" : [ "MyEC2InstanceResource", "PublicDnsName" ] }</code>.</p> </li>
        /// <li> <p> <code>DirectModification</code> entities are changes that are made directly to the template.</p> </li>
        /// <li> <p> <code>Automatic</code> entities are <code>AWS::CloudFormation::Stack</code> resource types, which are also known as nested stacks. If you made no changes to the <code>AWS::CloudFormation::Stack</code> resource, CloudFormation sets the <code>ChangeSource</code> to <code>Automatic</code> because the nested stack's template might have changed. Changes to a nested stack's template aren't visible to CloudFormation until you run an update on the parent stack.</p> </li>
        /// </ul>
        pub fn change_source(mut self, input: crate::model::ChangeSource) -> Self {
            self.change_source = Some(input);
            self
        }
        /// <p>The group to which the <code>CausingEntity</code> value belongs. There are five entity groups:</p>
        /// <ul>
        /// <li> <p> <code>ResourceReference</code> entities are <code>Ref</code> intrinsic functions that refer to resources in the template, such as <code>{ "Ref" : "MyEC2InstanceResource" }</code>.</p> </li>
        /// <li> <p> <code>ParameterReference</code> entities are <code>Ref</code> intrinsic functions that get template parameter values, such as <code>{ "Ref" : "MyPasswordParameter" }</code>.</p> </li>
        /// <li> <p> <code>ResourceAttribute</code> entities are <code>Fn::GetAtt</code> intrinsic functions that get resource attribute values, such as <code>{ "Fn::GetAtt" : [ "MyEC2InstanceResource", "PublicDnsName" ] }</code>.</p> </li>
        /// <li> <p> <code>DirectModification</code> entities are changes that are made directly to the template.</p> </li>
        /// <li> <p> <code>Automatic</code> entities are <code>AWS::CloudFormation::Stack</code> resource types, which are also known as nested stacks. If you made no changes to the <code>AWS::CloudFormation::Stack</code> resource, CloudFormation sets the <code>ChangeSource</code> to <code>Automatic</code> because the nested stack's template might have changed. Changes to a nested stack's template aren't visible to CloudFormation until you run an update on the parent stack.</p> </li>
        /// </ul>
        pub fn set_change_source(
            mut self,
            input: std::option::Option<crate::model::ChangeSource>,
        ) -> Self {
            self.change_source = input;
            self
        }
        /// <p>The identity of the entity that triggered this change. This entity is a member of the group that is specified by the <code>ChangeSource</code> field. For example, if you modified the value of the <code>KeyPairName</code> parameter, the <code>CausingEntity</code> is the name of the parameter (<code>KeyPairName</code>).</p>
        /// <p>If the <code>ChangeSource</code> value is <code>DirectModification</code>, no value is given for <code>CausingEntity</code>.</p>
        pub fn causing_entity(mut self, input: impl Into<std::string::String>) -> Self {
            self.causing_entity = Some(input.into());
            self
        }
        /// <p>The identity of the entity that triggered this change. This entity is a member of the group that is specified by the <code>ChangeSource</code> field. For example, if you modified the value of the <code>KeyPairName</code> parameter, the <code>CausingEntity</code> is the name of the parameter (<code>KeyPairName</code>).</p>
        /// <p>If the <code>ChangeSource</code> value is <code>DirectModification</code>, no value is given for <code>CausingEntity</code>.</p>
        pub fn set_causing_entity(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.causing_entity = input;
            self
        }
        /// Consumes the builder and constructs a [`ResourceChangeDetail`](crate::model::ResourceChangeDetail)
        pub fn build(self) -> crate::model::ResourceChangeDetail {
            crate::model::ResourceChangeDetail {
                target: self.target,
                evaluation: self.evaluation,
                change_source: self.change_source,
                causing_entity: self.causing_entity,
            }
        }
    }
}
impl ResourceChangeDetail {
    /// Creates a new builder-style object to manufacture [`ResourceChangeDetail`](crate::model::ResourceChangeDetail)
    pub fn builder() -> crate::model::resource_change_detail::Builder {
        crate::model::resource_change_detail::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ChangeSource {
    #[allow(missing_docs)] // documentation missing in model
    Automatic,
    #[allow(missing_docs)] // documentation missing in model
    DirectModification,
    #[allow(missing_docs)] // documentation missing in model
    ParameterReference,
    #[allow(missing_docs)] // documentation missing in model
    ResourceAttribute,
    #[allow(missing_docs)] // documentation missing in model
    ResourceReference,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ChangeSource {
    fn from(s: &str) -> Self {
        match s {
            "Automatic" => ChangeSource::Automatic,
            "DirectModification" => ChangeSource::DirectModification,
            "ParameterReference" => ChangeSource::ParameterReference,
            "ResourceAttribute" => ChangeSource::ResourceAttribute,
            "ResourceReference" => ChangeSource::ResourceReference,
            other => ChangeSource::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ChangeSource {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ChangeSource::from(s))
    }
}
impl ChangeSource {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ChangeSource::Automatic => "Automatic",
            ChangeSource::DirectModification => "DirectModification",
            ChangeSource::ParameterReference => "ParameterReference",
            ChangeSource::ResourceAttribute => "ResourceAttribute",
            ChangeSource::ResourceReference => "ResourceReference",
            ChangeSource::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "Automatic",
            "DirectModification",
            "ParameterReference",
            "ResourceAttribute",
            "ResourceReference",
        ]
    }
}
impl AsRef<str> for ChangeSource {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum EvaluationType {
    #[allow(missing_docs)] // documentation missing in model
    Dynamic,
    #[allow(missing_docs)] // documentation missing in model
    Static,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for EvaluationType {
    fn from(s: &str) -> Self {
        match s {
            "Dynamic" => EvaluationType::Dynamic,
            "Static" => EvaluationType::Static,
            other => EvaluationType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for EvaluationType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(EvaluationType::from(s))
    }
}
impl EvaluationType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            EvaluationType::Dynamic => "Dynamic",
            EvaluationType::Static => "Static",
            EvaluationType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["Dynamic", "Static"]
    }
}
impl AsRef<str> for EvaluationType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The field that CloudFormation will change, such as the name of a resource's property, and whether the resource will be recreated.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResourceTargetDefinition {
    /// <p>Indicates which resource attribute is triggering this update, such as a change in the resource attribute's <code>Metadata</code>, <code>Properties</code>, or <code>Tags</code>.</p>
    pub attribute: std::option::Option<crate::model::ResourceAttribute>,
    /// <p>If the <code>Attribute</code> value is <code>Properties</code>, the name of the property. For all other attributes, the value is null.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>If the <code>Attribute</code> value is <code>Properties</code>, indicates whether a change to this property causes the resource to be recreated. The value can be <code>Never</code>, <code>Always</code>, or <code>Conditionally</code>. To determine the conditions for a <code>Conditionally</code> recreation, see the update behavior for that <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-template-resource-type-ref.html">property</a> in the CloudFormation User Guide.</p>
    pub requires_recreation: std::option::Option<crate::model::RequiresRecreation>,
}
impl ResourceTargetDefinition {
    /// <p>Indicates which resource attribute is triggering this update, such as a change in the resource attribute's <code>Metadata</code>, <code>Properties</code>, or <code>Tags</code>.</p>
    pub fn attribute(&self) -> std::option::Option<&crate::model::ResourceAttribute> {
        self.attribute.as_ref()
    }
    /// <p>If the <code>Attribute</code> value is <code>Properties</code>, the name of the property. For all other attributes, the value is null.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>If the <code>Attribute</code> value is <code>Properties</code>, indicates whether a change to this property causes the resource to be recreated. The value can be <code>Never</code>, <code>Always</code>, or <code>Conditionally</code>. To determine the conditions for a <code>Conditionally</code> recreation, see the update behavior for that <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-template-resource-type-ref.html">property</a> in the CloudFormation User Guide.</p>
    pub fn requires_recreation(&self) -> std::option::Option<&crate::model::RequiresRecreation> {
        self.requires_recreation.as_ref()
    }
}
impl std::fmt::Debug for ResourceTargetDefinition {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResourceTargetDefinition");
        formatter.field("attribute", &self.attribute);
        formatter.field("name", &self.name);
        formatter.field("requires_recreation", &self.requires_recreation);
        formatter.finish()
    }
}
/// See [`ResourceTargetDefinition`](crate::model::ResourceTargetDefinition)
pub mod resource_target_definition {
    /// A builder for [`ResourceTargetDefinition`](crate::model::ResourceTargetDefinition)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) attribute: std::option::Option<crate::model::ResourceAttribute>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) requires_recreation: std::option::Option<crate::model::RequiresRecreation>,
    }
    impl Builder {
        /// <p>Indicates which resource attribute is triggering this update, such as a change in the resource attribute's <code>Metadata</code>, <code>Properties</code>, or <code>Tags</code>.</p>
        pub fn attribute(mut self, input: crate::model::ResourceAttribute) -> Self {
            self.attribute = Some(input);
            self
        }
        /// <p>Indicates which resource attribute is triggering this update, such as a change in the resource attribute's <code>Metadata</code>, <code>Properties</code>, or <code>Tags</code>.</p>
        pub fn set_attribute(
            mut self,
            input: std::option::Option<crate::model::ResourceAttribute>,
        ) -> Self {
            self.attribute = input;
            self
        }
        /// <p>If the <code>Attribute</code> value is <code>Properties</code>, the name of the property. For all other attributes, the value is null.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>If the <code>Attribute</code> value is <code>Properties</code>, the name of the property. For all other attributes, the value is null.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>If the <code>Attribute</code> value is <code>Properties</code>, indicates whether a change to this property causes the resource to be recreated. The value can be <code>Never</code>, <code>Always</code>, or <code>Conditionally</code>. To determine the conditions for a <code>Conditionally</code> recreation, see the update behavior for that <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-template-resource-type-ref.html">property</a> in the CloudFormation User Guide.</p>
        pub fn requires_recreation(mut self, input: crate::model::RequiresRecreation) -> Self {
            self.requires_recreation = Some(input);
            self
        }
        /// <p>If the <code>Attribute</code> value is <code>Properties</code>, indicates whether a change to this property causes the resource to be recreated. The value can be <code>Never</code>, <code>Always</code>, or <code>Conditionally</code>. To determine the conditions for a <code>Conditionally</code> recreation, see the update behavior for that <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-template-resource-type-ref.html">property</a> in the CloudFormation User Guide.</p>
        pub fn set_requires_recreation(
            mut self,
            input: std::option::Option<crate::model::RequiresRecreation>,
        ) -> Self {
            self.requires_recreation = input;
            self
        }
        /// Consumes the builder and constructs a [`ResourceTargetDefinition`](crate::model::ResourceTargetDefinition)
        pub fn build(self) -> crate::model::ResourceTargetDefinition {
            crate::model::ResourceTargetDefinition {
                attribute: self.attribute,
                name: self.name,
                requires_recreation: self.requires_recreation,
            }
        }
    }
}
impl ResourceTargetDefinition {
    /// Creates a new builder-style object to manufacture [`ResourceTargetDefinition`](crate::model::ResourceTargetDefinition)
    pub fn builder() -> crate::model::resource_target_definition::Builder {
        crate::model::resource_target_definition::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum RequiresRecreation {
    #[allow(missing_docs)] // documentation missing in model
    Always,
    #[allow(missing_docs)] // documentation missing in model
    Conditionally,
    #[allow(missing_docs)] // documentation missing in model
    Never,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for RequiresRecreation {
    fn from(s: &str) -> Self {
        match s {
            "Always" => RequiresRecreation::Always,
            "Conditionally" => RequiresRecreation::Conditionally,
            "Never" => RequiresRecreation::Never,
            other => RequiresRecreation::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for RequiresRecreation {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(RequiresRecreation::from(s))
    }
}
impl RequiresRecreation {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            RequiresRecreation::Always => "Always",
            RequiresRecreation::Conditionally => "Conditionally",
            RequiresRecreation::Never => "Never",
            RequiresRecreation::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["Always", "Conditionally", "Never"]
    }
}
impl AsRef<str> for RequiresRecreation {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ResourceAttribute {
    #[allow(missing_docs)] // documentation missing in model
    CreationPolicy,
    #[allow(missing_docs)] // documentation missing in model
    DeletionPolicy,
    #[allow(missing_docs)] // documentation missing in model
    Metadata,
    #[allow(missing_docs)] // documentation missing in model
    Properties,
    #[allow(missing_docs)] // documentation missing in model
    Tags,
    #[allow(missing_docs)] // documentation missing in model
    UpdatePolicy,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ResourceAttribute {
    fn from(s: &str) -> Self {
        match s {
            "CreationPolicy" => ResourceAttribute::CreationPolicy,
            "DeletionPolicy" => ResourceAttribute::DeletionPolicy,
            "Metadata" => ResourceAttribute::Metadata,
            "Properties" => ResourceAttribute::Properties,
            "Tags" => ResourceAttribute::Tags,
            "UpdatePolicy" => ResourceAttribute::UpdatePolicy,
            other => ResourceAttribute::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ResourceAttribute {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ResourceAttribute::from(s))
    }
}
impl ResourceAttribute {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ResourceAttribute::CreationPolicy => "CreationPolicy",
            ResourceAttribute::DeletionPolicy => "DeletionPolicy",
            ResourceAttribute::Metadata => "Metadata",
            ResourceAttribute::Properties => "Properties",
            ResourceAttribute::Tags => "Tags",
            ResourceAttribute::UpdatePolicy => "UpdatePolicy",
            ResourceAttribute::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "CreationPolicy",
            "DeletionPolicy",
            "Metadata",
            "Properties",
            "Tags",
            "UpdatePolicy",
        ]
    }
}
impl AsRef<str> for ResourceAttribute {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum Replacement {
    #[allow(missing_docs)] // documentation missing in model
    Conditional,
    #[allow(missing_docs)] // documentation missing in model
    False,
    #[allow(missing_docs)] // documentation missing in model
    True,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for Replacement {
    fn from(s: &str) -> Self {
        match s {
            "Conditional" => Replacement::Conditional,
            "False" => Replacement::False,
            "True" => Replacement::True,
            other => Replacement::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for Replacement {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(Replacement::from(s))
    }
}
impl Replacement {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            Replacement::Conditional => "Conditional",
            Replacement::False => "False",
            Replacement::True => "True",
            Replacement::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["Conditional", "False", "True"]
    }
}
impl AsRef<str> for Replacement {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ChangeAction {
    #[allow(missing_docs)] // documentation missing in model
    Add,
    #[allow(missing_docs)] // documentation missing in model
    Dynamic,
    #[allow(missing_docs)] // documentation missing in model
    Import,
    #[allow(missing_docs)] // documentation missing in model
    Modify,
    #[allow(missing_docs)] // documentation missing in model
    Remove,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ChangeAction {
    fn from(s: &str) -> Self {
        match s {
            "Add" => ChangeAction::Add,
            "Dynamic" => ChangeAction::Dynamic,
            "Import" => ChangeAction::Import,
            "Modify" => ChangeAction::Modify,
            "Remove" => ChangeAction::Remove,
            other => ChangeAction::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ChangeAction {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ChangeAction::from(s))
    }
}
impl ChangeAction {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ChangeAction::Add => "Add",
            ChangeAction::Dynamic => "Dynamic",
            ChangeAction::Import => "Import",
            ChangeAction::Modify => "Modify",
            ChangeAction::Remove => "Remove",
            ChangeAction::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["Add", "Dynamic", "Import", "Modify", "Remove"]
    }
}
impl AsRef<str> for ChangeAction {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ChangeType {
    #[allow(missing_docs)] // documentation missing in model
    Resource,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ChangeType {
    fn from(s: &str) -> Self {
        match s {
            "Resource" => ChangeType::Resource,
            other => ChangeType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ChangeType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ChangeType::from(s))
    }
}
impl ChangeType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ChangeType::Resource => "Resource",
            ChangeType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["Resource"]
    }
}
impl AsRef<str> for ChangeType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The AccountLimit data type. </p>
/// <p>CloudFormation has the following limits per account:</p>
/// <ul>
/// <li> <p>Number of concurrent resources</p> </li>
/// <li> <p>Number of stacks</p> </li>
/// <li> <p>Number of stack outputs</p> </li>
/// </ul>
/// <p>For more information about these account limits, and other CloudFormation limits, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/cloudformation-limits.html">CloudFormation Limits</a> in the <i>CloudFormation User Guide</i>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AccountLimit {
    /// <p>The name of the account limit.</p>
    /// <p>Values: <code>ConcurrentResourcesLimit</code> | <code>StackLimit</code> | <code>StackOutputsLimit</code> </p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The value that is associated with the account limit name.</p>
    pub value: std::option::Option<i32>,
}
impl AccountLimit {
    /// <p>The name of the account limit.</p>
    /// <p>Values: <code>ConcurrentResourcesLimit</code> | <code>StackLimit</code> | <code>StackOutputsLimit</code> </p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The value that is associated with the account limit name.</p>
    pub fn value(&self) -> std::option::Option<i32> {
        self.value
    }
}
impl std::fmt::Debug for AccountLimit {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AccountLimit");
        formatter.field("name", &self.name);
        formatter.field("value", &self.value);
        formatter.finish()
    }
}
/// See [`AccountLimit`](crate::model::AccountLimit)
pub mod account_limit {
    /// A builder for [`AccountLimit`](crate::model::AccountLimit)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) value: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The name of the account limit.</p>
        /// <p>Values: <code>ConcurrentResourcesLimit</code> | <code>StackLimit</code> | <code>StackOutputsLimit</code> </p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the account limit.</p>
        /// <p>Values: <code>ConcurrentResourcesLimit</code> | <code>StackLimit</code> | <code>StackOutputsLimit</code> </p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The value that is associated with the account limit name.</p>
        pub fn value(mut self, input: i32) -> Self {
            self.value = Some(input);
            self
        }
        /// <p>The value that is associated with the account limit name.</p>
        pub fn set_value(mut self, input: std::option::Option<i32>) -> Self {
            self.value = input;
            self
        }
        /// Consumes the builder and constructs a [`AccountLimit`](crate::model::AccountLimit)
        pub fn build(self) -> crate::model::AccountLimit {
            crate::model::AccountLimit {
                name: self.name,
                value: self.value,
            }
        }
    }
}
impl AccountLimit {
    /// Creates a new builder-style object to manufacture [`AccountLimit`](crate::model::AccountLimit)
    pub fn builder() -> crate::model::account_limit::Builder {
        crate::model::account_limit::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum OnFailure {
    #[allow(missing_docs)] // documentation missing in model
    Delete,
    #[allow(missing_docs)] // documentation missing in model
    DoNothing,
    #[allow(missing_docs)] // documentation missing in model
    Rollback,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for OnFailure {
    fn from(s: &str) -> Self {
        match s {
            "DELETE" => OnFailure::Delete,
            "DO_NOTHING" => OnFailure::DoNothing,
            "ROLLBACK" => OnFailure::Rollback,
            other => OnFailure::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for OnFailure {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(OnFailure::from(s))
    }
}
impl OnFailure {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            OnFailure::Delete => "DELETE",
            OnFailure::DoNothing => "DO_NOTHING",
            OnFailure::Rollback => "ROLLBACK",
            OnFailure::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["DELETE", "DO_NOTHING", "ROLLBACK"]
    }
}
impl AsRef<str> for OnFailure {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Describes the target resource of an import operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResourceToImport {
    /// <p>The type of resource to import into your stack, such as <code>AWS::S3::Bucket</code>. For a list of supported resource types, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/resource-import-supported-resources.html">Resources that support import operations</a> in the CloudFormation User Guide.</p>
    pub resource_type: std::option::Option<std::string::String>,
    /// <p>The logical ID of the target resource as specified in the template.</p>
    pub logical_resource_id: std::option::Option<std::string::String>,
    /// <p>A key-value pair that identifies the target resource. The key is an identifier property (for example, <code>BucketName</code> for <code>AWS::S3::Bucket</code> resources) and the value is the actual property value (for example, <code>MyS3Bucket</code>).</p>
    pub resource_identifier:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl ResourceToImport {
    /// <p>The type of resource to import into your stack, such as <code>AWS::S3::Bucket</code>. For a list of supported resource types, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/resource-import-supported-resources.html">Resources that support import operations</a> in the CloudFormation User Guide.</p>
    pub fn resource_type(&self) -> std::option::Option<&str> {
        self.resource_type.as_deref()
    }
    /// <p>The logical ID of the target resource as specified in the template.</p>
    pub fn logical_resource_id(&self) -> std::option::Option<&str> {
        self.logical_resource_id.as_deref()
    }
    /// <p>A key-value pair that identifies the target resource. The key is an identifier property (for example, <code>BucketName</code> for <code>AWS::S3::Bucket</code> resources) and the value is the actual property value (for example, <code>MyS3Bucket</code>).</p>
    pub fn resource_identifier(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.resource_identifier.as_ref()
    }
}
impl std::fmt::Debug for ResourceToImport {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResourceToImport");
        formatter.field("resource_type", &self.resource_type);
        formatter.field("logical_resource_id", &self.logical_resource_id);
        formatter.field("resource_identifier", &self.resource_identifier);
        formatter.finish()
    }
}
/// See [`ResourceToImport`](crate::model::ResourceToImport)
pub mod resource_to_import {
    /// A builder for [`ResourceToImport`](crate::model::ResourceToImport)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_type: std::option::Option<std::string::String>,
        pub(crate) logical_resource_id: std::option::Option<std::string::String>,
        pub(crate) resource_identifier: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The type of resource to import into your stack, such as <code>AWS::S3::Bucket</code>. For a list of supported resource types, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/resource-import-supported-resources.html">Resources that support import operations</a> in the CloudFormation User Guide.</p>
        pub fn resource_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_type = Some(input.into());
            self
        }
        /// <p>The type of resource to import into your stack, such as <code>AWS::S3::Bucket</code>. For a list of supported resource types, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/resource-import-supported-resources.html">Resources that support import operations</a> in the CloudFormation User Guide.</p>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_type = input;
            self
        }
        /// <p>The logical ID of the target resource as specified in the template.</p>
        pub fn logical_resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.logical_resource_id = Some(input.into());
            self
        }
        /// <p>The logical ID of the target resource as specified in the template.</p>
        pub fn set_logical_resource_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.logical_resource_id = input;
            self
        }
        /// Adds a key-value pair to `resource_identifier`.
        ///
        /// To override the contents of this collection use [`set_resource_identifier`](Self::set_resource_identifier).
        ///
        /// <p>A key-value pair that identifies the target resource. The key is an identifier property (for example, <code>BucketName</code> for <code>AWS::S3::Bucket</code> resources) and the value is the actual property value (for example, <code>MyS3Bucket</code>).</p>
        pub fn resource_identifier(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.resource_identifier.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.resource_identifier = Some(hash_map);
            self
        }
        /// <p>A key-value pair that identifies the target resource. The key is an identifier property (for example, <code>BucketName</code> for <code>AWS::S3::Bucket</code> resources) and the value is the actual property value (for example, <code>MyS3Bucket</code>).</p>
        pub fn set_resource_identifier(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.resource_identifier = input;
            self
        }
        /// Consumes the builder and constructs a [`ResourceToImport`](crate::model::ResourceToImport)
        pub fn build(self) -> crate::model::ResourceToImport {
            crate::model::ResourceToImport {
                resource_type: self.resource_type,
                logical_resource_id: self.logical_resource_id,
                resource_identifier: self.resource_identifier,
            }
        }
    }
}
impl ResourceToImport {
    /// Creates a new builder-style object to manufacture [`ResourceToImport`](crate::model::ResourceToImport)
    pub fn builder() -> crate::model::resource_to_import::Builder {
        crate::model::resource_to_import::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ChangeSetType {
    #[allow(missing_docs)] // documentation missing in model
    Create,
    #[allow(missing_docs)] // documentation missing in model
    Import,
    #[allow(missing_docs)] // documentation missing in model
    Update,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ChangeSetType {
    fn from(s: &str) -> Self {
        match s {
            "CREATE" => ChangeSetType::Create,
            "IMPORT" => ChangeSetType::Import,
            "UPDATE" => ChangeSetType::Update,
            other => ChangeSetType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ChangeSetType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ChangeSetType::from(s))
    }
}
impl ChangeSetType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ChangeSetType::Create => "CREATE",
            ChangeSetType::Import => "IMPORT",
            ChangeSetType::Update => "UPDATE",
            ChangeSetType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["CREATE", "IMPORT", "UPDATE"]
    }
}
impl AsRef<str> for ChangeSetType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Detailed information concerning the specification of a CloudFormation extension in a given account and region.</p>
/// <p>For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/registry-register.html#registry-set-configuration">Configuring extensions at the account level</a> in the <i>CloudFormation User Guide</i>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TypeConfigurationDetails {
    /// <p>The Amazon Resource Name (ARN) for the configuration data, in this account and region.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The alias specified for this configuration, if one was specified when the configuration was set.</p>
    pub alias: std::option::Option<std::string::String>,
    /// <p>A JSON string specifying the configuration data for the extension, in this account and region. </p>
    /// <p>If a configuration has not been set for a specified extension, CloudFormation returns <code>{}</code>.</p>
    pub configuration: std::option::Option<std::string::String>,
    /// <p>When the configuration data was last updated for this extension.</p>
    /// <p>If a configuration has not been set for a specified extension, CloudFormation returns <code>null</code>.</p>
    pub last_updated: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The Amazon Resource Name (ARN) for the extension, in this account and region.</p>
    /// <p>For public extensions, this will be the ARN assigned when you <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_ActivateType.html">activate the type</a> in this account and region. For private extensions, this will be the ARN assigned when you <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_RegisterType.html">register the type</a> in this account and region. </p>
    pub type_arn: std::option::Option<std::string::String>,
    /// <p>The name of the extension.</p>
    pub type_name: std::option::Option<std::string::String>,
    /// <p>Whether or not this configuration data is the default configuration for the extension.</p>
    pub is_default_configuration: std::option::Option<bool>,
}
impl TypeConfigurationDetails {
    /// <p>The Amazon Resource Name (ARN) for the configuration data, in this account and region.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The alias specified for this configuration, if one was specified when the configuration was set.</p>
    pub fn alias(&self) -> std::option::Option<&str> {
        self.alias.as_deref()
    }
    /// <p>A JSON string specifying the configuration data for the extension, in this account and region. </p>
    /// <p>If a configuration has not been set for a specified extension, CloudFormation returns <code>{}</code>.</p>
    pub fn configuration(&self) -> std::option::Option<&str> {
        self.configuration.as_deref()
    }
    /// <p>When the configuration data was last updated for this extension.</p>
    /// <p>If a configuration has not been set for a specified extension, CloudFormation returns <code>null</code>.</p>
    pub fn last_updated(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_updated.as_ref()
    }
    /// <p>The Amazon Resource Name (ARN) for the extension, in this account and region.</p>
    /// <p>For public extensions, this will be the ARN assigned when you <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_ActivateType.html">activate the type</a> in this account and region. For private extensions, this will be the ARN assigned when you <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_RegisterType.html">register the type</a> in this account and region. </p>
    pub fn type_arn(&self) -> std::option::Option<&str> {
        self.type_arn.as_deref()
    }
    /// <p>The name of the extension.</p>
    pub fn type_name(&self) -> std::option::Option<&str> {
        self.type_name.as_deref()
    }
    /// <p>Whether or not this configuration data is the default configuration for the extension.</p>
    pub fn is_default_configuration(&self) -> std::option::Option<bool> {
        self.is_default_configuration
    }
}
impl std::fmt::Debug for TypeConfigurationDetails {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TypeConfigurationDetails");
        formatter.field("arn", &self.arn);
        formatter.field("alias", &self.alias);
        formatter.field("configuration", &self.configuration);
        formatter.field("last_updated", &self.last_updated);
        formatter.field("type_arn", &self.type_arn);
        formatter.field("type_name", &self.type_name);
        formatter.field("is_default_configuration", &self.is_default_configuration);
        formatter.finish()
    }
}
/// See [`TypeConfigurationDetails`](crate::model::TypeConfigurationDetails)
pub mod type_configuration_details {
    /// A builder for [`TypeConfigurationDetails`](crate::model::TypeConfigurationDetails)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) alias: std::option::Option<std::string::String>,
        pub(crate) configuration: std::option::Option<std::string::String>,
        pub(crate) last_updated: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) type_arn: std::option::Option<std::string::String>,
        pub(crate) type_name: std::option::Option<std::string::String>,
        pub(crate) is_default_configuration: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) for the configuration data, in this account and region.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the configuration data, in this account and region.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The alias specified for this configuration, if one was specified when the configuration was set.</p>
        pub fn alias(mut self, input: impl Into<std::string::String>) -> Self {
            self.alias = Some(input.into());
            self
        }
        /// <p>The alias specified for this configuration, if one was specified when the configuration was set.</p>
        pub fn set_alias(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.alias = input;
            self
        }
        /// <p>A JSON string specifying the configuration data for the extension, in this account and region. </p>
        /// <p>If a configuration has not been set for a specified extension, CloudFormation returns <code>{}</code>.</p>
        pub fn configuration(mut self, input: impl Into<std::string::String>) -> Self {
            self.configuration = Some(input.into());
            self
        }
        /// <p>A JSON string specifying the configuration data for the extension, in this account and region. </p>
        /// <p>If a configuration has not been set for a specified extension, CloudFormation returns <code>{}</code>.</p>
        pub fn set_configuration(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.configuration = input;
            self
        }
        /// <p>When the configuration data was last updated for this extension.</p>
        /// <p>If a configuration has not been set for a specified extension, CloudFormation returns <code>null</code>.</p>
        pub fn last_updated(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_updated = Some(input);
            self
        }
        /// <p>When the configuration data was last updated for this extension.</p>
        /// <p>If a configuration has not been set for a specified extension, CloudFormation returns <code>null</code>.</p>
        pub fn set_last_updated(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_updated = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the extension, in this account and region.</p>
        /// <p>For public extensions, this will be the ARN assigned when you <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_ActivateType.html">activate the type</a> in this account and region. For private extensions, this will be the ARN assigned when you <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_RegisterType.html">register the type</a> in this account and region. </p>
        pub fn type_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.type_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the extension, in this account and region.</p>
        /// <p>For public extensions, this will be the ARN assigned when you <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_ActivateType.html">activate the type</a> in this account and region. For private extensions, this will be the ARN assigned when you <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_RegisterType.html">register the type</a> in this account and region. </p>
        pub fn set_type_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.type_arn = input;
            self
        }
        /// <p>The name of the extension.</p>
        pub fn type_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.type_name = Some(input.into());
            self
        }
        /// <p>The name of the extension.</p>
        pub fn set_type_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.type_name = input;
            self
        }
        /// <p>Whether or not this configuration data is the default configuration for the extension.</p>
        pub fn is_default_configuration(mut self, input: bool) -> Self {
            self.is_default_configuration = Some(input);
            self
        }
        /// <p>Whether or not this configuration data is the default configuration for the extension.</p>
        pub fn set_is_default_configuration(mut self, input: std::option::Option<bool>) -> Self {
            self.is_default_configuration = input;
            self
        }
        /// Consumes the builder and constructs a [`TypeConfigurationDetails`](crate::model::TypeConfigurationDetails)
        pub fn build(self) -> crate::model::TypeConfigurationDetails {
            crate::model::TypeConfigurationDetails {
                arn: self.arn,
                alias: self.alias,
                configuration: self.configuration,
                last_updated: self.last_updated,
                type_arn: self.type_arn,
                type_name: self.type_name,
                is_default_configuration: self.is_default_configuration,
            }
        }
    }
}
impl TypeConfigurationDetails {
    /// Creates a new builder-style object to manufacture [`TypeConfigurationDetails`](crate::model::TypeConfigurationDetails)
    pub fn builder() -> crate::model::type_configuration_details::Builder {
        crate::model::type_configuration_details::Builder::default()
    }
}

/// <p>Identifying information for the configuration of a CloudFormation extension.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TypeConfigurationIdentifier {
    /// <p>The Amazon Resource Name (ARN) for the extension, in this account and region.</p>
    /// <p>For public extensions, this will be the ARN assigned when you <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_ActivateType.html">activate the type</a> in this account and region. For private extensions, this will be the ARN assigned when you <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_RegisterType.html">register the type</a> in this account and region. </p>
    pub type_arn: std::option::Option<std::string::String>,
    /// <p>The alias specified for this configuration, if one was specified when the configuration was set.</p>
    pub type_configuration_alias: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) for the configuration, in this account and region.</p>
    pub type_configuration_arn: std::option::Option<std::string::String>,
    /// <p>The type of extension.</p>
    pub r#type: std::option::Option<crate::model::ThirdPartyType>,
    /// <p>The name of the extension type to which this configuration applies.</p>
    pub type_name: std::option::Option<std::string::String>,
}
impl TypeConfigurationIdentifier {
    /// <p>The Amazon Resource Name (ARN) for the extension, in this account and region.</p>
    /// <p>For public extensions, this will be the ARN assigned when you <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_ActivateType.html">activate the type</a> in this account and region. For private extensions, this will be the ARN assigned when you <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_RegisterType.html">register the type</a> in this account and region. </p>
    pub fn type_arn(&self) -> std::option::Option<&str> {
        self.type_arn.as_deref()
    }
    /// <p>The alias specified for this configuration, if one was specified when the configuration was set.</p>
    pub fn type_configuration_alias(&self) -> std::option::Option<&str> {
        self.type_configuration_alias.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) for the configuration, in this account and region.</p>
    pub fn type_configuration_arn(&self) -> std::option::Option<&str> {
        self.type_configuration_arn.as_deref()
    }
    /// <p>The type of extension.</p>
    pub fn r#type(&self) -> std::option::Option<&crate::model::ThirdPartyType> {
        self.r#type.as_ref()
    }
    /// <p>The name of the extension type to which this configuration applies.</p>
    pub fn type_name(&self) -> std::option::Option<&str> {
        self.type_name.as_deref()
    }
}
impl std::fmt::Debug for TypeConfigurationIdentifier {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TypeConfigurationIdentifier");
        formatter.field("type_arn", &self.type_arn);
        formatter.field("type_configuration_alias", &self.type_configuration_alias);
        formatter.field("type_configuration_arn", &self.type_configuration_arn);
        formatter.field("r#type", &self.r#type);
        formatter.field("type_name", &self.type_name);
        formatter.finish()
    }
}
/// See [`TypeConfigurationIdentifier`](crate::model::TypeConfigurationIdentifier)
pub mod type_configuration_identifier {
    /// A builder for [`TypeConfigurationIdentifier`](crate::model::TypeConfigurationIdentifier)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) type_arn: std::option::Option<std::string::String>,
        pub(crate) type_configuration_alias: std::option::Option<std::string::String>,
        pub(crate) type_configuration_arn: std::option::Option<std::string::String>,
        pub(crate) r#type: std::option::Option<crate::model::ThirdPartyType>,
        pub(crate) type_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) for the extension, in this account and region.</p>
        /// <p>For public extensions, this will be the ARN assigned when you <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_ActivateType.html">activate the type</a> in this account and region. For private extensions, this will be the ARN assigned when you <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_RegisterType.html">register the type</a> in this account and region. </p>
        pub fn type_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.type_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the extension, in this account and region.</p>
        /// <p>For public extensions, this will be the ARN assigned when you <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_ActivateType.html">activate the type</a> in this account and region. For private extensions, this will be the ARN assigned when you <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_RegisterType.html">register the type</a> in this account and region. </p>
        pub fn set_type_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.type_arn = input;
            self
        }
        /// <p>The alias specified for this configuration, if one was specified when the configuration was set.</p>
        pub fn type_configuration_alias(mut self, input: impl Into<std::string::String>) -> Self {
            self.type_configuration_alias = Some(input.into());
            self
        }
        /// <p>The alias specified for this configuration, if one was specified when the configuration was set.</p>
        pub fn set_type_configuration_alias(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.type_configuration_alias = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the configuration, in this account and region.</p>
        pub fn type_configuration_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.type_configuration_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the configuration, in this account and region.</p>
        pub fn set_type_configuration_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.type_configuration_arn = input;
            self
        }
        /// <p>The type of extension.</p>
        pub fn r#type(mut self, input: crate::model::ThirdPartyType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The type of extension.</p>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::ThirdPartyType>,
        ) -> Self {
            self.r#type = input;
            self
        }
        /// <p>The name of the extension type to which this configuration applies.</p>
        pub fn type_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.type_name = Some(input.into());
            self
        }
        /// <p>The name of the extension type to which this configuration applies.</p>
        pub fn set_type_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.type_name = input;
            self
        }
        /// Consumes the builder and constructs a [`TypeConfigurationIdentifier`](crate::model::TypeConfigurationIdentifier)
        pub fn build(self) -> crate::model::TypeConfigurationIdentifier {
            crate::model::TypeConfigurationIdentifier {
                type_arn: self.type_arn,
                type_configuration_alias: self.type_configuration_alias,
                type_configuration_arn: self.type_configuration_arn,
                r#type: self.r#type,
                type_name: self.type_name,
            }
        }
    }
}
impl TypeConfigurationIdentifier {
    /// Creates a new builder-style object to manufacture [`TypeConfigurationIdentifier`](crate::model::TypeConfigurationIdentifier)
    pub fn builder() -> crate::model::type_configuration_identifier::Builder {
        crate::model::type_configuration_identifier::Builder::default()
    }
}

/// <p>Detailed information concerning an error generated during the setting of configuration data for a CloudFormation extension.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchDescribeTypeConfigurationsError {
    /// <p>The error code.</p>
    pub error_code: std::option::Option<std::string::String>,
    /// <p>The error message.</p>
    pub error_message: std::option::Option<std::string::String>,
    /// <p>Identifying information for the configuration of a CloudFormation extension.</p>
    pub type_configuration_identifier:
        std::option::Option<crate::model::TypeConfigurationIdentifier>,
}
impl BatchDescribeTypeConfigurationsError {
    /// <p>The error code.</p>
    pub fn error_code(&self) -> std::option::Option<&str> {
        self.error_code.as_deref()
    }
    /// <p>The error message.</p>
    pub fn error_message(&self) -> std::option::Option<&str> {
        self.error_message.as_deref()
    }
    /// <p>Identifying information for the configuration of a CloudFormation extension.</p>
    pub fn type_configuration_identifier(
        &self,
    ) -> std::option::Option<&crate::model::TypeConfigurationIdentifier> {
        self.type_configuration_identifier.as_ref()
    }
}
impl std::fmt::Debug for BatchDescribeTypeConfigurationsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchDescribeTypeConfigurationsError");
        formatter.field("error_code", &self.error_code);
        formatter.field("error_message", &self.error_message);
        formatter.field(
            "type_configuration_identifier",
            &self.type_configuration_identifier,
        );
        formatter.finish()
    }
}
/// See [`BatchDescribeTypeConfigurationsError`](crate::model::BatchDescribeTypeConfigurationsError)
pub mod batch_describe_type_configurations_error {
    /// A builder for [`BatchDescribeTypeConfigurationsError`](crate::model::BatchDescribeTypeConfigurationsError)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) error_code: std::option::Option<std::string::String>,
        pub(crate) error_message: std::option::Option<std::string::String>,
        pub(crate) type_configuration_identifier:
            std::option::Option<crate::model::TypeConfigurationIdentifier>,
    }
    impl Builder {
        /// <p>The error code.</p>
        pub fn error_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.error_code = Some(input.into());
            self
        }
        /// <p>The error code.</p>
        pub fn set_error_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.error_code = input;
            self
        }
        /// <p>The error message.</p>
        pub fn error_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.error_message = Some(input.into());
            self
        }
        /// <p>The error message.</p>
        pub fn set_error_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.error_message = input;
            self
        }
        /// <p>Identifying information for the configuration of a CloudFormation extension.</p>
        pub fn type_configuration_identifier(
            mut self,
            input: crate::model::TypeConfigurationIdentifier,
        ) -> Self {
            self.type_configuration_identifier = Some(input);
            self
        }
        /// <p>Identifying information for the configuration of a CloudFormation extension.</p>
        pub fn set_type_configuration_identifier(
            mut self,
            input: std::option::Option<crate::model::TypeConfigurationIdentifier>,
        ) -> Self {
            self.type_configuration_identifier = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchDescribeTypeConfigurationsError`](crate::model::BatchDescribeTypeConfigurationsError)
        pub fn build(self) -> crate::model::BatchDescribeTypeConfigurationsError {
            crate::model::BatchDescribeTypeConfigurationsError {
                error_code: self.error_code,
                error_message: self.error_message,
                type_configuration_identifier: self.type_configuration_identifier,
            }
        }
    }
}
impl BatchDescribeTypeConfigurationsError {
    /// Creates a new builder-style object to manufacture [`BatchDescribeTypeConfigurationsError`](crate::model::BatchDescribeTypeConfigurationsError)
    pub fn builder() -> crate::model::batch_describe_type_configurations_error::Builder {
        crate::model::batch_describe_type_configurations_error::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum VersionBump {
    #[allow(missing_docs)] // documentation missing in model
    Major,
    #[allow(missing_docs)] // documentation missing in model
    Minor,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for VersionBump {
    fn from(s: &str) -> Self {
        match s {
            "MAJOR" => VersionBump::Major,
            "MINOR" => VersionBump::Minor,
            other => VersionBump::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for VersionBump {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(VersionBump::from(s))
    }
}
impl VersionBump {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            VersionBump::Major => "MAJOR",
            VersionBump::Minor => "MINOR",
            VersionBump::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["MAJOR", "MINOR"]
    }
}
impl AsRef<str> for VersionBump {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}
