// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// All possible error types for this service.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum Error {
    /// <p>The resource with the name requested already exists.</p>
    AlreadyExistsException(crate::error::AlreadyExistsException),
    /// <p>An error occurred during a CloudFormation registry operation.</p>
    CfnRegistryException(crate::error::CfnRegistryException),
    /// <p>The specified change set name or ID doesn't exit. To view valid change sets for a stack, use the <code>ListChangeSets</code> action.</p>
    ChangeSetNotFoundException(crate::error::ChangeSetNotFoundException),
    /// <p>The specified resource exists, but has been changed.</p>
    CreatedButModifiedException(crate::error::CreatedButModifiedException),
    /// <p>The template contains resources with capabilities that weren't specified in the Capabilities parameter.</p>
    InsufficientCapabilitiesException(crate::error::InsufficientCapabilitiesException),
    /// <p>The specified change set can't be used to update the stack. For example, the change set status might be <code>CREATE_IN_PROGRESS</code>, or the stack status might be <code>UPDATE_IN_PROGRESS</code>.</p>
    InvalidChangeSetStatusException(crate::error::InvalidChangeSetStatusException),
    /// <p>The specified operation isn't valid.</p>
    InvalidOperationException(crate::error::InvalidOperationException),
    /// <p>Error reserved for use by the <a href="https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/what-is-cloudformation-cli.html">CloudFormation CLI</a>. CloudFormation does not return this error to users.</p>
    InvalidStateTransitionException(crate::error::InvalidStateTransitionException),
    /// <p>The quota for the resource has already been reached.</p>
    /// <p>For information on resource and stack limitations, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/cloudformation-limits.html">Limits</a> in the <i>CloudFormation User Guide</i>.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The specified name is already in use.</p>
    NameAlreadyExistsException(crate::error::NameAlreadyExistsException),
    /// <p>The specified operation ID already exists.</p>
    OperationIdAlreadyExistsException(crate::error::OperationIdAlreadyExistsException),
    /// <p>Another operation is currently in progress for this stack set. Only one operation can be performed for a stack set at a given time.</p>
    OperationInProgressException(crate::error::OperationInProgressException),
    /// <p>The specified ID refers to an operation that doesn't exist.</p>
    OperationNotFoundException(crate::error::OperationNotFoundException),
    /// <p>Error reserved for use by the <a href="https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/what-is-cloudformation-cli.html">CloudFormation CLI</a>. CloudFormation does not return this error to users.</p>
    OperationStatusCheckFailedException(crate::error::OperationStatusCheckFailedException),
    /// <p>The specified stack instance doesn't exist.</p>
    StackInstanceNotFoundException(crate::error::StackInstanceNotFoundException),
    /// <p>The specified stack ARN doesn’t exist or stack doesn’t exist corresponding to the ARN in input.</p>
    StackNotFoundException(crate::error::StackNotFoundException),
    /// <p>You can't yet delete this stack set, because it still contains one or more stack instances. Delete all stack instances from the stack set before deleting the stack set.</p>
    StackSetNotEmptyException(crate::error::StackSetNotEmptyException),
    /// <p>The specified stack set doesn't exist.</p>
    StackSetNotFoundException(crate::error::StackSetNotFoundException),
    /// <p>Another operation has been performed on this stack set since the specified operation was performed. </p>
    StaleRequestException(crate::error::StaleRequestException),
    /// <p>A client request token already exists.</p>
    TokenAlreadyExistsException(crate::error::TokenAlreadyExistsException),
    /// <p>The specified extension configuration cannot be found.</p>
    TypeConfigurationNotFoundException(crate::error::TypeConfigurationNotFoundException),
    /// <p>The specified extension does not exist in the CloudFormation registry.</p>
    TypeNotFoundException(crate::error::TypeNotFoundException),
    /// An unhandled error occurred.
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for Error {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match self {
            Error::AlreadyExistsException(inner) => inner.fmt(f),
            Error::CfnRegistryException(inner) => inner.fmt(f),
            Error::ChangeSetNotFoundException(inner) => inner.fmt(f),
            Error::CreatedButModifiedException(inner) => inner.fmt(f),
            Error::InsufficientCapabilitiesException(inner) => inner.fmt(f),
            Error::InvalidChangeSetStatusException(inner) => inner.fmt(f),
            Error::InvalidOperationException(inner) => inner.fmt(f),
            Error::InvalidStateTransitionException(inner) => inner.fmt(f),
            Error::LimitExceededException(inner) => inner.fmt(f),
            Error::NameAlreadyExistsException(inner) => inner.fmt(f),
            Error::OperationIdAlreadyExistsException(inner) => inner.fmt(f),
            Error::OperationInProgressException(inner) => inner.fmt(f),
            Error::OperationNotFoundException(inner) => inner.fmt(f),
            Error::OperationStatusCheckFailedException(inner) => inner.fmt(f),
            Error::StackInstanceNotFoundException(inner) => inner.fmt(f),
            Error::StackNotFoundException(inner) => inner.fmt(f),
            Error::StackSetNotEmptyException(inner) => inner.fmt(f),
            Error::StackSetNotFoundException(inner) => inner.fmt(f),
            Error::StaleRequestException(inner) => inner.fmt(f),
            Error::TokenAlreadyExistsException(inner) => inner.fmt(f),
            Error::TypeConfigurationNotFoundException(inner) => inner.fmt(f),
            Error::TypeNotFoundException(inner) => inner.fmt(f),
            Error::Unhandled(inner) => inner.fmt(f),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ActivateTypeError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::ActivateTypeError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ActivateTypeErrorKind::CfnRegistryException(inner) => {
                    Error::CfnRegistryException(inner)
                }
                crate::error::ActivateTypeErrorKind::TypeNotFoundException(inner) => {
                    Error::TypeNotFoundException(inner)
                }
                crate::error::ActivateTypeErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<aws_smithy_http::result::SdkError<crate::error::BatchDescribeTypeConfigurationsError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::BatchDescribeTypeConfigurationsError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::BatchDescribeTypeConfigurationsErrorKind::CfnRegistryException(inner) => Error::CfnRegistryException(inner),
                crate::error::BatchDescribeTypeConfigurationsErrorKind::TypeConfigurationNotFoundException(inner) => Error::TypeConfigurationNotFoundException(inner),
                crate::error::BatchDescribeTypeConfigurationsErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CancelUpdateStackError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::CancelUpdateStackError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::CancelUpdateStackErrorKind::TokenAlreadyExistsException(inner) => {
                    Error::TokenAlreadyExistsException(inner)
                }
                crate::error::CancelUpdateStackErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ContinueUpdateRollbackError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::ContinueUpdateRollbackError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ContinueUpdateRollbackErrorKind::TokenAlreadyExistsException(
                    inner,
                ) => Error::TokenAlreadyExistsException(inner),
                crate::error::ContinueUpdateRollbackErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CreateChangeSetError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::CreateChangeSetError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::CreateChangeSetErrorKind::AlreadyExistsException(inner) => {
                    Error::AlreadyExistsException(inner)
                }
                crate::error::CreateChangeSetErrorKind::InsufficientCapabilitiesException(
                    inner,
                ) => Error::InsufficientCapabilitiesException(inner),
                crate::error::CreateChangeSetErrorKind::LimitExceededException(inner) => {
                    Error::LimitExceededException(inner)
                }
                crate::error::CreateChangeSetErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CreateStackError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::CreateStackError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::CreateStackErrorKind::AlreadyExistsException(inner) => {
                    Error::AlreadyExistsException(inner)
                }
                crate::error::CreateStackErrorKind::InsufficientCapabilitiesException(inner) => {
                    Error::InsufficientCapabilitiesException(inner)
                }
                crate::error::CreateStackErrorKind::LimitExceededException(inner) => {
                    Error::LimitExceededException(inner)
                }
                crate::error::CreateStackErrorKind::TokenAlreadyExistsException(inner) => {
                    Error::TokenAlreadyExistsException(inner)
                }
                crate::error::CreateStackErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CreateStackInstancesError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::CreateStackInstancesError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::CreateStackInstancesErrorKind::InvalidOperationException(inner) => {
                    Error::InvalidOperationException(inner)
                }
                crate::error::CreateStackInstancesErrorKind::LimitExceededException(inner) => {
                    Error::LimitExceededException(inner)
                }
                crate::error::CreateStackInstancesErrorKind::OperationIdAlreadyExistsException(
                    inner,
                ) => Error::OperationIdAlreadyExistsException(inner),
                crate::error::CreateStackInstancesErrorKind::OperationInProgressException(
                    inner,
                ) => Error::OperationInProgressException(inner),
                crate::error::CreateStackInstancesErrorKind::StackSetNotFoundException(inner) => {
                    Error::StackSetNotFoundException(inner)
                }
                crate::error::CreateStackInstancesErrorKind::StaleRequestException(inner) => {
                    Error::StaleRequestException(inner)
                }
                crate::error::CreateStackInstancesErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CreateStackSetError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::CreateStackSetError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::CreateStackSetErrorKind::CreatedButModifiedException(inner) => {
                    Error::CreatedButModifiedException(inner)
                }
                crate::error::CreateStackSetErrorKind::LimitExceededException(inner) => {
                    Error::LimitExceededException(inner)
                }
                crate::error::CreateStackSetErrorKind::NameAlreadyExistsException(inner) => {
                    Error::NameAlreadyExistsException(inner)
                }
                crate::error::CreateStackSetErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeactivateTypeError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::DeactivateTypeError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DeactivateTypeErrorKind::CfnRegistryException(inner) => {
                    Error::CfnRegistryException(inner)
                }
                crate::error::DeactivateTypeErrorKind::TypeNotFoundException(inner) => {
                    Error::TypeNotFoundException(inner)
                }
                crate::error::DeactivateTypeErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeleteChangeSetError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::DeleteChangeSetError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DeleteChangeSetErrorKind::InvalidChangeSetStatusException(inner) => {
                    Error::InvalidChangeSetStatusException(inner)
                }
                crate::error::DeleteChangeSetErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeleteStackError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::DeleteStackError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DeleteStackErrorKind::TokenAlreadyExistsException(inner) => {
                    Error::TokenAlreadyExistsException(inner)
                }
                crate::error::DeleteStackErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeleteStackInstancesError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DeleteStackInstancesError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DeleteStackInstancesErrorKind::InvalidOperationException(inner) => {
                    Error::InvalidOperationException(inner)
                }
                crate::error::DeleteStackInstancesErrorKind::OperationIdAlreadyExistsException(
                    inner,
                ) => Error::OperationIdAlreadyExistsException(inner),
                crate::error::DeleteStackInstancesErrorKind::OperationInProgressException(
                    inner,
                ) => Error::OperationInProgressException(inner),
                crate::error::DeleteStackInstancesErrorKind::StackSetNotFoundException(inner) => {
                    Error::StackSetNotFoundException(inner)
                }
                crate::error::DeleteStackInstancesErrorKind::StaleRequestException(inner) => {
                    Error::StaleRequestException(inner)
                }
                crate::error::DeleteStackInstancesErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeleteStackSetError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::DeleteStackSetError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DeleteStackSetErrorKind::OperationInProgressException(inner) => {
                    Error::OperationInProgressException(inner)
                }
                crate::error::DeleteStackSetErrorKind::StackSetNotEmptyException(inner) => {
                    Error::StackSetNotEmptyException(inner)
                }
                crate::error::DeleteStackSetErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeregisterTypeError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::DeregisterTypeError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DeregisterTypeErrorKind::CfnRegistryException(inner) => {
                    Error::CfnRegistryException(inner)
                }
                crate::error::DeregisterTypeErrorKind::TypeNotFoundException(inner) => {
                    Error::TypeNotFoundException(inner)
                }
                crate::error::DeregisterTypeErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeAccountLimitsError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DescribeAccountLimitsError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DescribeAccountLimitsErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeChangeSetError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DescribeChangeSetError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DescribeChangeSetErrorKind::ChangeSetNotFoundException(inner) => {
                    Error::ChangeSetNotFoundException(inner)
                }
                crate::error::DescribeChangeSetErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribePublisherError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DescribePublisherError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DescribePublisherErrorKind::CfnRegistryException(inner) => {
                    Error::CfnRegistryException(inner)
                }
                crate::error::DescribePublisherErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<aws_smithy_http::result::SdkError<crate::error::DescribeStackDriftDetectionStatusError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::DescribeStackDriftDetectionStatusError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DescribeStackDriftDetectionStatusErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeStackEventsError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DescribeStackEventsError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DescribeStackEventsErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeStackInstanceError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DescribeStackInstanceError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DescribeStackInstanceErrorKind::StackInstanceNotFoundException(
                    inner,
                ) => Error::StackInstanceNotFoundException(inner),
                crate::error::DescribeStackInstanceErrorKind::StackSetNotFoundException(inner) => {
                    Error::StackSetNotFoundException(inner)
                }
                crate::error::DescribeStackInstanceErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeStackResourceError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DescribeStackResourceError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DescribeStackResourceErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeStackResourceDriftsError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DescribeStackResourceDriftsError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DescribeStackResourceDriftsErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeStackResourcesError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DescribeStackResourcesError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DescribeStackResourcesErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeStacksError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::DescribeStacksError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DescribeStacksErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeStackSetError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DescribeStackSetError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DescribeStackSetErrorKind::StackSetNotFoundException(inner) => {
                    Error::StackSetNotFoundException(inner)
                }
                crate::error::DescribeStackSetErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeStackSetOperationError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DescribeStackSetOperationError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DescribeStackSetOperationErrorKind::OperationNotFoundException(
                    inner,
                ) => Error::OperationNotFoundException(inner),
                crate::error::DescribeStackSetOperationErrorKind::StackSetNotFoundException(
                    inner,
                ) => Error::StackSetNotFoundException(inner),
                crate::error::DescribeStackSetOperationErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeTypeError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::DescribeTypeError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DescribeTypeErrorKind::CfnRegistryException(inner) => {
                    Error::CfnRegistryException(inner)
                }
                crate::error::DescribeTypeErrorKind::TypeNotFoundException(inner) => {
                    Error::TypeNotFoundException(inner)
                }
                crate::error::DescribeTypeErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeTypeRegistrationError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DescribeTypeRegistrationError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DescribeTypeRegistrationErrorKind::CfnRegistryException(inner) => {
                    Error::CfnRegistryException(inner)
                }
                crate::error::DescribeTypeRegistrationErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DetectStackDriftError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DetectStackDriftError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DetectStackDriftErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DetectStackResourceDriftError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DetectStackResourceDriftError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DetectStackResourceDriftErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DetectStackSetDriftError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DetectStackSetDriftError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DetectStackSetDriftErrorKind::InvalidOperationException(inner) => {
                    Error::InvalidOperationException(inner)
                }
                crate::error::DetectStackSetDriftErrorKind::OperationInProgressException(inner) => {
                    Error::OperationInProgressException(inner)
                }
                crate::error::DetectStackSetDriftErrorKind::StackSetNotFoundException(inner) => {
                    Error::StackSetNotFoundException(inner)
                }
                crate::error::DetectStackSetDriftErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::EstimateTemplateCostError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::EstimateTemplateCostError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::EstimateTemplateCostErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ExecuteChangeSetError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::ExecuteChangeSetError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ExecuteChangeSetErrorKind::ChangeSetNotFoundException(inner) => {
                    Error::ChangeSetNotFoundException(inner)
                }
                crate::error::ExecuteChangeSetErrorKind::InsufficientCapabilitiesException(
                    inner,
                ) => Error::InsufficientCapabilitiesException(inner),
                crate::error::ExecuteChangeSetErrorKind::InvalidChangeSetStatusException(inner) => {
                    Error::InvalidChangeSetStatusException(inner)
                }
                crate::error::ExecuteChangeSetErrorKind::TokenAlreadyExistsException(inner) => {
                    Error::TokenAlreadyExistsException(inner)
                }
                crate::error::ExecuteChangeSetErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GetStackPolicyError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::GetStackPolicyError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::GetStackPolicyErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GetTemplateError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::GetTemplateError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::GetTemplateErrorKind::ChangeSetNotFoundException(inner) => {
                    Error::ChangeSetNotFoundException(inner)
                }
                crate::error::GetTemplateErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GetTemplateSummaryError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::GetTemplateSummaryError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::GetTemplateSummaryErrorKind::StackSetNotFoundException(inner) => {
                    Error::StackSetNotFoundException(inner)
                }
                crate::error::GetTemplateSummaryErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ImportStacksToStackSetError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::ImportStacksToStackSetError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::ImportStacksToStackSetErrorKind::InvalidOperationException(inner) => Error::InvalidOperationException(inner),
                crate::error::ImportStacksToStackSetErrorKind::LimitExceededException(inner) => Error::LimitExceededException(inner),
                crate::error::ImportStacksToStackSetErrorKind::OperationIdAlreadyExistsException(inner) => Error::OperationIdAlreadyExistsException(inner),
                crate::error::ImportStacksToStackSetErrorKind::OperationInProgressException(inner) => Error::OperationInProgressException(inner),
                crate::error::ImportStacksToStackSetErrorKind::StackNotFoundException(inner) => Error::StackNotFoundException(inner),
                crate::error::ImportStacksToStackSetErrorKind::StackSetNotFoundException(inner) => Error::StackSetNotFoundException(inner),
                crate::error::ImportStacksToStackSetErrorKind::StaleRequestException(inner) => Error::StaleRequestException(inner),
                crate::error::ImportStacksToStackSetErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ListChangeSetsError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::ListChangeSetsError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ListChangeSetsErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ListExportsError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::ListExportsError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ListExportsErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ListImportsError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::ListImportsError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ListImportsErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ListStackInstancesError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::ListStackInstancesError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ListStackInstancesErrorKind::StackSetNotFoundException(inner) => {
                    Error::StackSetNotFoundException(inner)
                }
                crate::error::ListStackInstancesErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ListStackResourcesError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::ListStackResourcesError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ListStackResourcesErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ListStacksError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::ListStacksError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ListStacksErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ListStackSetOperationResultsError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::ListStackSetOperationResultsError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ListStackSetOperationResultsErrorKind::OperationNotFoundException(
                    inner,
                ) => Error::OperationNotFoundException(inner),
                crate::error::ListStackSetOperationResultsErrorKind::StackSetNotFoundException(
                    inner,
                ) => Error::StackSetNotFoundException(inner),
                crate::error::ListStackSetOperationResultsErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ListStackSetOperationsError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::ListStackSetOperationsError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ListStackSetOperationsErrorKind::StackSetNotFoundException(inner) => {
                    Error::StackSetNotFoundException(inner)
                }
                crate::error::ListStackSetOperationsErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ListStackSetsError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::ListStackSetsError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ListStackSetsErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ListTypeRegistrationsError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::ListTypeRegistrationsError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ListTypeRegistrationsErrorKind::CfnRegistryException(inner) => {
                    Error::CfnRegistryException(inner)
                }
                crate::error::ListTypeRegistrationsErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ListTypesError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::ListTypesError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ListTypesErrorKind::CfnRegistryException(inner) => {
                    Error::CfnRegistryException(inner)
                }
                crate::error::ListTypesErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ListTypeVersionsError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::ListTypeVersionsError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ListTypeVersionsErrorKind::CfnRegistryException(inner) => {
                    Error::CfnRegistryException(inner)
                }
                crate::error::ListTypeVersionsErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::PublishTypeError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::PublishTypeError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::PublishTypeErrorKind::CfnRegistryException(inner) => {
                    Error::CfnRegistryException(inner)
                }
                crate::error::PublishTypeErrorKind::TypeNotFoundException(inner) => {
                    Error::TypeNotFoundException(inner)
                }
                crate::error::PublishTypeErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::RecordHandlerProgressError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::RecordHandlerProgressError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::RecordHandlerProgressErrorKind::InvalidStateTransitionException(inner) => Error::InvalidStateTransitionException(inner),
                crate::error::RecordHandlerProgressErrorKind::OperationStatusCheckFailedException(inner) => Error::OperationStatusCheckFailedException(inner),
                crate::error::RecordHandlerProgressErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::RegisterPublisherError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::RegisterPublisherError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::RegisterPublisherErrorKind::CfnRegistryException(inner) => {
                    Error::CfnRegistryException(inner)
                }
                crate::error::RegisterPublisherErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::RegisterTypeError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::RegisterTypeError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::RegisterTypeErrorKind::CfnRegistryException(inner) => {
                    Error::CfnRegistryException(inner)
                }
                crate::error::RegisterTypeErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::RollbackStackError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::RollbackStackError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::RollbackStackErrorKind::TokenAlreadyExistsException(inner) => {
                    Error::TokenAlreadyExistsException(inner)
                }
                crate::error::RollbackStackErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::SetStackPolicyError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::SetStackPolicyError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::SetStackPolicyErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::SetTypeConfigurationError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::SetTypeConfigurationError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::SetTypeConfigurationErrorKind::CfnRegistryException(inner) => {
                    Error::CfnRegistryException(inner)
                }
                crate::error::SetTypeConfigurationErrorKind::TypeNotFoundException(inner) => {
                    Error::TypeNotFoundException(inner)
                }
                crate::error::SetTypeConfigurationErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::SetTypeDefaultVersionError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::SetTypeDefaultVersionError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::SetTypeDefaultVersionErrorKind::CfnRegistryException(inner) => {
                    Error::CfnRegistryException(inner)
                }
                crate::error::SetTypeDefaultVersionErrorKind::TypeNotFoundException(inner) => {
                    Error::TypeNotFoundException(inner)
                }
                crate::error::SetTypeDefaultVersionErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::SignalResourceError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::SignalResourceError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::SignalResourceErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::StopStackSetOperationError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::StopStackSetOperationError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::StopStackSetOperationErrorKind::InvalidOperationException(inner) => {
                    Error::InvalidOperationException(inner)
                }
                crate::error::StopStackSetOperationErrorKind::OperationNotFoundException(inner) => {
                    Error::OperationNotFoundException(inner)
                }
                crate::error::StopStackSetOperationErrorKind::StackSetNotFoundException(inner) => {
                    Error::StackSetNotFoundException(inner)
                }
                crate::error::StopStackSetOperationErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::TestTypeError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::TestTypeError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::TestTypeErrorKind::CfnRegistryException(inner) => {
                    Error::CfnRegistryException(inner)
                }
                crate::error::TestTypeErrorKind::TypeNotFoundException(inner) => {
                    Error::TypeNotFoundException(inner)
                }
                crate::error::TestTypeErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::UpdateStackError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::UpdateStackError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::UpdateStackErrorKind::InsufficientCapabilitiesException(inner) => {
                    Error::InsufficientCapabilitiesException(inner)
                }
                crate::error::UpdateStackErrorKind::TokenAlreadyExistsException(inner) => {
                    Error::TokenAlreadyExistsException(inner)
                }
                crate::error::UpdateStackErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::UpdateStackInstancesError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::UpdateStackInstancesError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::UpdateStackInstancesErrorKind::InvalidOperationException(inner) => {
                    Error::InvalidOperationException(inner)
                }
                crate::error::UpdateStackInstancesErrorKind::OperationIdAlreadyExistsException(
                    inner,
                ) => Error::OperationIdAlreadyExistsException(inner),
                crate::error::UpdateStackInstancesErrorKind::OperationInProgressException(
                    inner,
                ) => Error::OperationInProgressException(inner),
                crate::error::UpdateStackInstancesErrorKind::StackInstanceNotFoundException(
                    inner,
                ) => Error::StackInstanceNotFoundException(inner),
                crate::error::UpdateStackInstancesErrorKind::StackSetNotFoundException(inner) => {
                    Error::StackSetNotFoundException(inner)
                }
                crate::error::UpdateStackInstancesErrorKind::StaleRequestException(inner) => {
                    Error::StaleRequestException(inner)
                }
                crate::error::UpdateStackInstancesErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::UpdateStackSetError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::UpdateStackSetError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::UpdateStackSetErrorKind::InvalidOperationException(inner) => {
                    Error::InvalidOperationException(inner)
                }
                crate::error::UpdateStackSetErrorKind::OperationIdAlreadyExistsException(inner) => {
                    Error::OperationIdAlreadyExistsException(inner)
                }
                crate::error::UpdateStackSetErrorKind::OperationInProgressException(inner) => {
                    Error::OperationInProgressException(inner)
                }
                crate::error::UpdateStackSetErrorKind::StackInstanceNotFoundException(inner) => {
                    Error::StackInstanceNotFoundException(inner)
                }
                crate::error::UpdateStackSetErrorKind::StackSetNotFoundException(inner) => {
                    Error::StackSetNotFoundException(inner)
                }
                crate::error::UpdateStackSetErrorKind::StaleRequestException(inner) => {
                    Error::StaleRequestException(inner)
                }
                crate::error::UpdateStackSetErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::UpdateTerminationProtectionError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::UpdateTerminationProtectionError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::UpdateTerminationProtectionErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ValidateTemplateError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::ValidateTemplateError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ValidateTemplateErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl std::error::Error for Error {}
